
function [S1,S2,S3,pointset_stats]=set_lyness_jespersen_I_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J.N. Lyness, D. Jespersen,
%  "Moderate Degree Symmetric Quadrature Rules for the Triangle"
%  J. Inst. Maths Applies, 15 (1975), pp.19-32.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.22e-16 |PI|
% |   5 |   7 |   0 |   0 | 4.79e-16 |PI|
% |   6 |  12 |   0 |   0 | 1.24e-13 |PI|
% |   7 |  13 |   1 |   0 | 4.11e-14 |NI|
% |   8 |  16 |   0 |   0 | 8.38e-15 |PI|
% |   9 |  19 |   0 |   0 | 8.75e-15 |PI|
% |  11 |  27 |   0 |   3 | 1.36e-13 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        S1=[];
        
        S2=[
            3.33333333333333314829616256247391e-01 5.00000000000000000000000000000000e-01
            ];
        
        S3=[];
        
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        S1=[];
        
        S2=[
            5.20833333333333370340767487505218e-01 2.00000000000000011102230246251565e-01
            ];
        
        S3=[
            -5.62500000000000000000000000000000e-01
            ];
        
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        S1=[];
        
        S2=[
            1.09951743655321829140625311538315e-01 9.15762135097707291597757262024970e-02
            2.23381589678011499566778752523533e-01 4.45948490915964890213274429697776e-01
            ];
        
        S3=[];
        
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.8e-16
        
        S1=[];
        
        S2=[
            1.25939180544827167285149016606738e-01 1.01286507323456329010546994595643e-01
            1.32394152788506164197812609018001e-01 4.70142064105115053962435922585428e-01
            ];
        
        S3=[
            2.25000000000000005551115123125783e-01
            ];
        
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.2e-13
        
        S1=[
            8.28510756183895857862609091171180e-02 6.36502499121393894299103521916550e-01 5.31450498448321623223833398697025e-02
            ];
        
        S2=[
            1.16786275726340746383691282517248e-01 2.49286745170932910742322974328999e-01
            5.08449063702054657176709895338718e-02 6.30890144915017686555458453767642e-02
            ];
        
        S3=[];
        
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 4.1e-14
        
        S1=[
            7.71137608902583288061904909227451e-02 6.38444188569809556454970334016252e-01 4.86903154253175568522138405569422e-02
            ];
        
        S2=[
            1.75615257433210936177658822998637e-01 2.60345966079046586827416831511073e-01
            5.33472356088388957595647354992252e-02 6.51301029022162275561314004335145e-02
            ];
        
        S3=[
            -1.49570044467749491134966888239433e-01
            ];
        
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.4e-15
        
        S1=[
            2.72303141744348643771278517533574e-02 8.39477740995721137540197531734520e-03 7.28492392955404133303431990498211e-01
            ];
        
        S2=[
            9.50916342672849662642775570020603e-02 4.59292588292722903098308506741887e-01
            3.24584976231981348071542470279383e-02 5.05472283170310329736274468359625e-02
            1.03217370534718397290241398422950e-01 1.70569307751760101954374704291695e-01
            ];
        
        S3=[
            1.44315607677786200691016915698128e-01
            ];
        
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.7e-15
        
        S1=[
            4.32835393772894039265963783691404e-02 3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01
            ];
        
        S2=[
            3.13347002271398347716946375385305e-02 4.89682519198737009613608961444697e-01
            7.78275410047754301334776982912445e-02 4.37089591492935525263163754061679e-01
            7.96477389272090413596671965024143e-02 1.88203535619032191750221727488679e-01
            2.55776756586981006413861194914716e-02 4.47295133944529688108104892307892e-02
            ];
        
        S3=[
            9.71357962827961024521172817003389e-02
            ];
        
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   27
        % NEG. W.  :    0
        % OUT PTS. :    3
        % M.E.INF. : 1.4e-13
        
        S1=[
            5.23371119622038985519374421073735e-02 5.01781383104947381612603862777178e-02 5.93201213428213192102589346177410e-01
            2.07076596391406152208869428932303e-02 2.10220165361661298630835403855599e-02 8.07489003159792329000765676028095e-01
            ];
        
        S2=[
            1.36597310026770196733636453245708e-02 3.23649481112717324338134972094849e-02
            3.61845405034288622458937823012093e-02 1.19350912282593105140371392280940e-01
            9.27006328960604058207761735133090e-04 5.34611048270757227562910429696785e-01
            5.93229773807555996190110647603433e-02 2.03309900431281609378686425770866e-01
            7.71495349148225706414905289420858e-02 3.98969302965855809883777283175732e-01
            ];
        
        S3=[];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.22e-16    0    0
    5    7 4.79e-16    0    0
    6   12 1.24e-13    0    0
    7   13 4.11e-14    1    0
    8   16 8.38e-15    0    0
    9   19 8.75e-15    0    0
    11   27 1.36e-13    0    3
    ];




