
function [xyw,pointset_stats]=set_lyness_jespersen_I_standard(deg)

% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn. Dubiner basis,
%    number of points with negative weights, number of points outside the domain.
% --------------------------------------------------------------------
% SOURCE:
% J.N. Lyness, D. Jespersen,
% "Moderate Degree Symmetric Quadrature Rules for the Triangle"
% J. Inst. Maths Applies, 15 (1975), pp.19-32.
% --------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
% --------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.22e-16 |PI|
% |   5 |   7 |   0 |   0 | 4.79e-16 |PI|
% |   6 |  12 |   0 |   0 | 1.24e-13 |PI|
% |   7 |  13 |   1 |   0 | 4.11e-14 |NI|
% |   8 |  16 |   0 |   0 | 8.38e-15 |PI|
% |   9 |  19 |   0 |   0 | 8.75e-15 |PI|
% |  11 |  27 |   0 |   3 | 1.36e-13 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw=[
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 1.66666666666666657414808128123695e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 1.66666666666666657414808128123695e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 1.66666666666666657414808128123695e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -2.81250000000000000000000000000000e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.60416666666666685170383743752609e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw=[
            9.15762135097707291597757262024970e-02 9.15762135097707291597757262024970e-02 5.49758718276609284481004635836143e-02
            9.15762135097707291597757262024970e-02 8.16847572980458513924872931966092e-01 5.49758718276609284481004635836143e-02
            8.16847572980458513924872931966092e-01 9.15762135097707291597757262024970e-02 5.49758718276609284481004635836143e-02
            4.45948490915964890213274429697776e-01 4.45948490915964890213274429697776e-01 1.11690794839005777538964991890680e-01
            4.45948490915964890213274429697776e-01 1.08103018168070219573451140604448e-01 1.11690794839005777538964991890680e-01
            1.08103018168070219573451140604448e-01 4.45948490915964890213274429697776e-01 1.11690794839005777538964991890680e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.8e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.12500000000000002775557561562891e-01
            1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 6.29695902724135836425745083033689e-02
            1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 6.29695902724135836425745083033689e-02
            7.97426985353087314223330395179801e-01 1.01286507323456329010546994595643e-01 6.29695902724135836425745083033689e-02
            4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 6.61970763942530820989063045090006e-02
            4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 6.61970763942530820989063045090006e-02
            5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 6.61970763942530820989063045090006e-02
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.2e-13
        
        xyw=[
            2.49286745170932910742322974328999e-01 2.49286745170932910742322974328999e-01 5.83931378631717887262020383332128e-02
            2.49286745170932910742322974328999e-01 5.01426509658134178515354051342001e-01 5.83931378631717887262020383332128e-02
            5.01426509658134178515354051342001e-01 2.49286745170932910742322974328999e-01 5.83931378631717887262020383332128e-02
            6.30890144915017686555458453767642e-02 6.30890144915017686555458453767642e-02 2.54224531851033469509459905566473e-02
            6.30890144915017686555458453767642e-02 8.73821971016996434933332693617558e-01 2.54224531851033469509459905566473e-02
            8.73821971016996434933332693617558e-01 6.30890144915017686555458453767642e-02 2.54224531851033469509459905566473e-02
            6.36502499121393894299103521916550e-01 5.31450498448321623223833398697025e-02 4.14255378091957920938526171994454e-02
            6.36502499121393894299103521916550e-01 3.10352451033773957256300946028205e-01 4.14255378091957920938526171994454e-02
            5.31450498448321623223833398697025e-02 6.36502499121393894299103521916550e-01 4.14255378091957920938526171994454e-02
            5.31450498448321623223833398697025e-02 3.10352451033773957256300946028205e-01 4.14255378091957920938526171994454e-02
            3.10352451033773957256300946028205e-01 6.36502499121393894299103521916550e-01 4.14255378091957920938526171994454e-02
            3.10352451033773957256300946028205e-01 5.31450498448321623223833398697025e-02 4.14255378091957920938526171994454e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 4.1e-14
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -7.47850222338784786924037462085835e-02
            2.60345966079046586827416831511073e-01 2.60345966079046586827416831511073e-01 8.78076287166098534697766808676533e-02
            2.60345966079046586827416831511073e-01 4.79308067841906826345166336977854e-01 8.78076287166098534697766808676533e-02
            4.79308067841906826345166336977854e-01 2.60345966079046586827416831511073e-01 8.78076287166098534697766808676533e-02
            6.51301029022162275561314004335145e-02 6.51301029022162275561314004335145e-02 2.66736178044207801474119179374611e-02
            6.51301029022162275561314004335145e-02 8.69739794195567572643312814761885e-01 2.66736178044207801474119179374611e-02
            8.69739794195567572643312814761885e-01 6.51301029022162275561314004335145e-02 2.66736178044207801474119179374611e-02
            6.38444188569809556454970334016252e-01 4.86903154253175568522138405569422e-02 3.85568804451310934156005316708615e-02
            6.38444188569809556454970334016252e-01 3.12865496004872900570603633241262e-01 3.85568804451310934156005316708615e-02
            4.86903154253175568522138405569422e-02 6.38444188569809556454970334016252e-01 3.85568804451310934156005316708615e-02
            4.86903154253175568522138405569422e-02 3.12865496004872900570603633241262e-01 3.85568804451310934156005316708615e-02
            3.12865496004872900570603633241262e-01 6.38444188569809556454970334016252e-01 3.85568804451310934156005316708615e-02
            3.12865496004872900570603633241262e-01 4.86903154253175568522138405569422e-02 3.85568804451310934156005316708615e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.4e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 7.21578038388931142232962656635209e-02
            4.59292588292722903098308506741887e-01 4.59292588292722903098308506741887e-01 4.75458171336424970099265863154869e-02
            4.59292588292722903098308506741887e-01 8.14148234145541938033829865162261e-02 4.75458171336424970099265863154869e-02
            8.14148234145541938033829865162261e-02 4.59292588292722903098308506741887e-01 4.75458171336424970099265863154869e-02
            5.05472283170310329736274468359625e-02 5.05472283170310329736274468359625e-02 1.62292488115990708730240754675833e-02
            5.05472283170310329736274468359625e-02 8.98905543365937975686108529771445e-01 1.62292488115990708730240754675833e-02
            8.98905543365937975686108529771445e-01 5.05472283170310329736274468359625e-02 1.62292488115990708730240754675833e-02
            1.70569307751760101954374704291695e-01 1.70569307751760101954374704291695e-01 5.16086852673592125229085070259316e-02
            1.70569307751760101954374704291695e-01 6.58861384496479796091250591416610e-01 5.16086852673592125229085070259316e-02
            6.58861384496479796091250591416610e-01 1.70569307751760101954374704291695e-01 5.16086852673592125229085070259316e-02
            8.39477740995721137540197531734520e-03 7.28492392955404133303431990498211e-01 1.36151570872174356580108778302929e-02
            8.39477740995721137540197531734520e-03 2.63112829634638667464230366022093e-01 1.36151570872174356580108778302929e-02
            7.28492392955404133303431990498211e-01 8.39477740995721137540197531734520e-03 1.36151570872174356580108778302929e-02
            7.28492392955404133303431990498211e-01 2.63112829634638667464230366022093e-01 1.36151570872174356580108778302929e-02
            2.63112829634638667464230366022093e-01 8.39477740995721137540197531734520e-03 1.36151570872174356580108778302929e-02
            2.63112829634638667464230366022093e-01 7.28492392955404133303431990498211e-01 1.36151570872174356580108778302929e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.7e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.85678981413980651038464486646262e-02
            4.89682519198737009613608961444697e-01 4.89682519198737009613608961444697e-01 1.56673501135699208552942707228794e-02
            4.89682519198737009613608961444697e-01 2.06349616025259807727820771106053e-02 1.56673501135699208552942707228794e-02
            2.06349616025259807727820771106053e-02 4.89682519198737009613608961444697e-01 1.56673501135699208552942707228794e-02
            4.37089591492935525263163754061679e-01 4.37089591492935525263163754061679e-01 3.89137705023877220056327530528506e-02
            4.37089591492935525263163754061679e-01 1.25820817014128949473672491876641e-01 3.89137705023877220056327530528506e-02
            1.25820817014128949473672491876641e-01 4.37089591492935525263163754061679e-01 3.89137705023877220056327530528506e-02
            1.88203535619032191750221727488679e-01 1.88203535619032191750221727488679e-01 3.98238694636045276187275021584355e-02
            1.88203535619032191750221727488679e-01 6.23592928761935616499556545022642e-01 3.98238694636045276187275021584355e-02
            6.23592928761935616499556545022642e-01 1.88203535619032191750221727488679e-01 3.98238694636045276187275021584355e-02
            4.47295133944529688108104892307892e-02 4.47295133944529688108104892307892e-02 1.27888378293490537901400116993500e-02
            4.47295133944529688108104892307892e-02 9.10540973211094062378379021538422e-01 1.27888378293490537901400116993500e-02
            9.10540973211094062378379021538422e-01 4.47295133944529688108104892307892e-02 1.27888378293490537901400116993500e-02
            3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01 2.16417696886447054327451411381844e-02
            3.68384120547362581277184290229343e-02 2.21962989160765733487323814188130e-01 2.16417696886447054327451411381844e-02
            7.41198598784498008384957756788936e-01 3.68384120547362581277184290229343e-02 2.16417696886447054327451411381844e-02
            7.41198598784498008384957756788936e-01 2.21962989160765733487323814188130e-01 2.16417696886447054327451411381844e-02
            2.21962989160765733487323814188130e-01 3.68384120547362581277184290229343e-02 2.16417696886447054327451411381844e-02
            2.21962989160765733487323814188130e-01 7.41198598784498008384957756788936e-01 2.16417696886447054327451411381844e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   27
        % NEG. W.  :    0
        % OUT PTS. :    3
        % M.E.INF. : 1.4e-13
        
        xyw=[
            3.23649481112717324338134972094849e-02 3.23649481112717324338134972094849e-02 6.82986550133850376514965674346058e-03
            3.23649481112717324338134972094849e-02 9.35270103777456562887948621209944e-01 6.82986550133850376514965674346058e-03
            9.35270103777456562887948621209944e-01 3.23649481112717324338134972094849e-02 6.82986550133850376514965674346058e-03
            1.19350912282593105140371392280940e-01 1.19350912282593105140371392280940e-01 1.80922702517144137757121313825337e-02
            1.19350912282593105140371392280940e-01 7.61298175434813817474832831067033e-01 1.80922702517144137757121313825337e-02
            7.61298175434813817474832831067033e-01 1.19350912282593105140371392280940e-01 1.80922702517144137757121313825337e-02
            5.34611048270757227562910429696785e-01 5.34611048270757227562910429696785e-01 4.63503164480301595423011873364771e-04
            5.34611048270757227562910429696785e-01 -6.92220965415144551258208593935706e-02 4.63503164480301595423011873364771e-04
            -6.92220965415144551258208593935706e-02 5.34611048270757227562910429696785e-01 4.63503164480301595423011873364771e-04
            2.03309900431281609378686425770866e-01 2.03309900431281609378686425770866e-01 2.96614886903777720539299167512581e-02
            2.03309900431281609378686425770866e-01 5.93380199137436781242627148458268e-01 2.96614886903777720539299167512581e-02
            5.93380199137436781242627148458268e-01 2.03309900431281609378686425770866e-01 2.96614886903777720539299167512581e-02
            3.98969302965855809883777283175732e-01 3.98969302965855809883777283175732e-01 3.85747674574112506262757449349010e-02
            3.98969302965855809883777283175732e-01 2.02061394068288380232445433648536e-01 3.85747674574112506262757449349010e-02
            2.02061394068288380232445433648536e-01 3.98969302965855809883777283175732e-01 3.85747674574112506262757449349010e-02
            5.01781383104947381612603862777178e-02 5.93201213428213192102589346177410e-01 2.61685559811019249898400573783874e-02
            5.01781383104947381612603862777178e-02 3.56620648261292028102786844101502e-01 2.61685559811019249898400573783874e-02
            5.93201213428213192102589346177410e-01 5.01781383104947381612603862777178e-02 2.61685559811019249898400573783874e-02
            5.93201213428213192102589346177410e-01 3.56620648261292028102786844101502e-01 2.61685559811019249898400573783874e-02
            3.56620648261292028102786844101502e-01 5.01781383104947381612603862777178e-02 2.61685559811019249898400573783874e-02
            3.56620648261292028102786844101502e-01 5.93201213428213192102589346177410e-01 2.61685559811019249898400573783874e-02
            2.10220165361661298630835403855599e-02 8.07489003159792329000765676028095e-01 1.03538298195702989368260915625797e-02
            2.10220165361661298630835403855599e-02 1.71488980304041582769514207029715e-01 1.03538298195702989368260915625797e-02
            8.07489003159792329000765676028095e-01 2.10220165361661298630835403855599e-02 1.03538298195702989368260915625797e-02
            8.07489003159792329000765676028095e-01 1.71488980304041582769514207029715e-01 1.03538298195702989368260915625797e-02
            1.71488980304041582769514207029715e-01 2.10220165361661298630835403855599e-02 1.03538298195702989368260915625797e-02
            1.71488980304041582769514207029715e-01 8.07489003159792329000765676028095e-01 1.03538298195702989368260915625797e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.22e-16    0    0
    5    7 4.79e-16    0    0
    6   12 1.24e-13    0    0
    7   13 4.11e-14    1    0
    8   16 8.38e-15    0    0
    9   19 8.75e-15    0    0
    11   27 1.36e-13    0    3
    ];
