
function [xyw_bar,pointset_stats]=set_lyness_jespersen_II_barycentric(deg)

% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn. Dubiner basis,
%    number of points with negative weights, number of points outside the domain.
% --------------------------------------------------------------------
% SOURCE:
% J.N. Lyness, D. Jespersen,
% "Moderate Degree Symmetric Quadrature Rules for the Triangle"
% J. Inst. Maths Applies, 15 (1975), pp.19-32.
% --------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
% --------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.22e-16 |PI|
% |   5 |   7 |   0 |   0 | 4.79e-16 |PI|
% |   6 |  12 |   0 |   0 | 1.24e-13 |PI|
% |   7 |  13 |   1 |   0 | 4.11e-14 |NI|
% |   8 |  16 |   0 |   0 | 8.38e-15 |PI|
% |   9 |  19 |   0 |   0 | 8.75e-15 |PI|
% |  11 |  27 |   0 |   3 | 1.36e-13 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    4
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.4e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 7.50000000000000000000000000000000e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 8.33333333333333287074040640618477e-02
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 8.33333333333333287074040640618477e-02
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 8.33333333333333287074040640618477e-02
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.50000000000000011102230246251565e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 5.00000000000000027755575615628914e-02
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 5.00000000000000027755575615628914e-02
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 5.00000000000000027755575615628914e-02
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 1.33333333333333331482961625624739e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 1.33333333333333331482961625624739e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 1.33333333333333331482961625624739e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:   10
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 6.7e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.50000000000000122124532708767219e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 -1.66666666666666699048171551567066e-02
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 -1.66666666666666699048171551567066e-02
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 -1.66666666666666699048171551567066e-02
            7.88675134594812754507131558057154e-01 2.11324865405187134470565979427192e-01 1.11022302462515654042363166809082e-16 1.00000000000000033306690738754696e-01
            7.88675134594812754507131558057154e-01 1.11022302462515654042363166809082e-16 2.11324865405187134470565979427192e-01 1.00000000000000033306690738754696e-01
            2.11324865405187134470565979427192e-01 7.88675134594812754507131558057154e-01 1.11022302462515654042363166809082e-16 1.00000000000000033306690738754696e-01
            2.11324865405187134470565979427192e-01 1.11022302462515654042363166809082e-16 7.88675134594812754507131558057154e-01 1.00000000000000033306690738754696e-01
            1.11022302462515654042363166809082e-16 7.88675134594812754507131558057154e-01 2.11324865405187134470565979427192e-01 1.00000000000000033306690738754696e-01
            1.11022302462515654042363166809082e-16 2.11324865405187134470565979427192e-01 7.88675134594812754507131558057154e-01 1.00000000000000033306690738754696e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:   10
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.5e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.53124999999999988897769753748435e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 1.11111111111111115351546274609973e-02
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.11111111111111115351546274609973e-02
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.11111111111111115351546274609973e-02
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 7.11111111111111110494320541874913e-02
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 7.11111111111111110494320541874913e-02
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 7.11111111111111110494320541874913e-02
            1.42857142857142849212692681248882e-01 1.42857142857142849212692681248882e-01 7.14285714285714301574614637502236e-01 1.66736111111111112714766591125226e-01
            1.42857142857142849212692681248882e-01 7.14285714285714301574614637502236e-01 1.42857142857142849212692681248882e-01 1.66736111111111112714766591125226e-01
            7.14285714285714301574614637502236e-01 1.42857142857142849212692681248882e-01 1.42857142857142849212692681248882e-01 1.66736111111111112714766591125226e-01
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   16
        % NEG. W.  :    4
        % OUT PTS. :    4
        % M.E.INF. : 9.4e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -5.78571428571428847398294692538911e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 -1.98412698412698505767703949231873e-02
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 -1.98412698412698505767703949231873e-02
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 -1.98412698412698505767703949231873e-02
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.39682539682539916259251810970454e-02
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.39682539682539916259251810970454e-02
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 5.39682539682539916259251810970454e-02
            2.50000000000000000000000000000000e-01 2.50000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 4.06349206349206515387351146273431e-01
            2.50000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 2.50000000000000000000000000000000e-01 4.06349206349206515387351146273431e-01
            5.00000000000000000000000000000000e-01 2.50000000000000000000000000000000e-01 2.50000000000000000000000000000000e-01 4.06349206349206515387351146273431e-01
            9.08248290463863017230039531568764e-01 9.17517095361370244033238918746065e-02 -4.16333634234433702658861875534058e-17 4.28571428571428783560470776592410e-02
            9.08248290463863017230039531568764e-01 -4.16333634234433702658861875534058e-17 9.17517095361370244033238918746065e-02 4.28571428571428783560470776592410e-02
            9.17517095361370244033238918746065e-02 9.08248290463863017230039531568764e-01 -4.16333634234433702658861875534058e-17 4.28571428571428783560470776592410e-02
            9.17517095361370244033238918746065e-02 -4.16333634234433702658861875534058e-17 9.08248290463863017230039531568764e-01 4.28571428571428783560470776592410e-02
            -4.16333634234433702658861875534058e-17 9.08248290463863017230039531568764e-01 9.17517095361370244033238918746065e-02 4.28571428571428783560470776592410e-02
            -4.16333634234433702658861875534058e-17 9.17517095361370244033238918746065e-02 9.08248290463863017230039531568764e-01 4.28571428571428783560470776592410e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-13
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.76312615600534045023906060123409e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 4.03633844254456999184332843810807e-03
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 4.03633844254456999184332843810807e-03
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 4.03633844254456999184332843810807e-03
            1.54936060223760413423477189098776e-01 1.54936060223760413423477189098776e-01 6.90127879552479228664196853060275e-01 1.16652058589908985686278697357920e-01
            1.54936060223760413423477189098776e-01 6.90127879552479228664196853060275e-01 1.54936060223760413423477189098776e-01 1.16652058589908985686278697357920e-01
            6.90127879552479228664196853060275e-01 1.54936060223760413423477189098776e-01 1.54936060223760413423477189098776e-01 1.16652058589908985686278697357920e-01
            4.69150746143812025223951422958635e-01 4.69150746143812025223951422958635e-01 6.16985077123759495520971540827304e-02 1.06503991814179355124281300959410e-01
            4.69150746143812025223951422958635e-01 6.16985077123759495520971540827304e-02 4.69150746143812025223951422958635e-01 1.06503991814179355124281300959410e-01
            6.16985077123759495520971540827304e-02 4.69150746143812025223951422958635e-01 4.69150746143812025223951422958635e-01 1.06503991814179355124281300959410e-01
            0.00000000000000000000000000000000e+00 8.39299172272923610371719860268058e-01 1.60700827727076389628280139731942e-01 2.36850363099279058454182944615241e-02
            0.00000000000000000000000000000000e+00 1.60700827727076389628280139731942e-01 8.39299172272923610371719860268058e-01 2.36850363099279058454182944615241e-02
            8.39299172272923610371719860268058e-01 0.00000000000000000000000000000000e+00 1.60700827727076389628280139731942e-01 2.36850363099279058454182944615241e-02
            8.39299172272923610371719860268058e-01 1.60700827727076389628280139731942e-01 0.00000000000000000000000000000000e+00 2.36850363099279058454182944615241e-02
            1.60700827727076389628280139731942e-01 0.00000000000000000000000000000000e+00 8.39299172272923610371719860268058e-01 2.36850363099279058454182944615241e-02
            1.60700827727076389628280139731942e-01 8.39299172272923610371719860268058e-01 0.00000000000000000000000000000000e+00 2.36850363099279058454182944615241e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   21
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 7.3e-12
        
        xyw_bar=[
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 4.02424645099202019093986848474742e-03
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 4.02424645099202019093986848474742e-03
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 4.02424645099202019093986848474742e-03
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 -2.83052662639514562847864453942748e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 -2.83052662639514562847864453942748e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 -2.83052662639514562847864453942748e-01
            4.95681394175558176495854922904982e-01 4.95681394175558176495854922904982e-01 8.63721164888364700829015419003554e-03 3.47455822965168414917513928230619e-01
            4.95681394175558176495854922904982e-01 8.63721164888364700829015419003554e-03 4.95681394175558176495854922904982e-01 3.47455822965168414917513928230619e-01
            8.63721164888364700829015419003554e-03 4.95681394175558176495854922904982e-01 4.95681394175558176495854922904982e-01 3.47455822965168414917513928230619e-01
            9.03277575142653332829212331489543e-02 9.03277575142653332829212331489543e-02 8.19344484971469277923006302444264e-01 6.49076597140017391707189631233632e-02
            9.03277575142653332829212331489543e-02 8.19344484971469277923006302444264e-01 9.03277575142653332829212331489543e-02 6.49076597140017391707189631233632e-02
            8.19344484971469277923006302444264e-01 9.03277575142653332829212331489543e-02 9.03277575142653332829212331489543e-02 6.49076597140017391707189631233632e-02
            2.34154749707305209760477282543434e-01 2.34154749707305209760477282543434e-01 5.31690500585389580479045434913132e-01 1.50395092240645900094619946685270e-01
            2.34154749707305209760477282543434e-01 5.31690500585389580479045434913132e-01 2.34154749707305209760477282543434e-01 1.50395092240645900094619946685270e-01
            5.31690500585389580479045434913132e-01 2.34154749707305209760477282543434e-01 2.34154749707305209760477282543434e-01 1.50395092240645900094619946685270e-01
            0.00000000000000000000000000000000e+00 7.23606797749975050315640601183986e-01 2.76393202250024949684359398816014e-01 2.48015873010198825698857660881913e-02
            0.00000000000000000000000000000000e+00 2.76393202250024949684359398816014e-01 7.23606797749975050315640601183986e-01 2.48015873010198825698857660881913e-02
            7.23606797749975050315640601183986e-01 0.00000000000000000000000000000000e+00 2.76393202250024949684359398816014e-01 2.48015873010198825698857660881913e-02
            7.23606797749975050315640601183986e-01 2.76393202250024949684359398816014e-01 0.00000000000000000000000000000000e+00 2.48015873010198825698857660881913e-02
            2.76393202250024949684359398816014e-01 0.00000000000000000000000000000000e+00 7.23606797749975050315640601183986e-01 2.48015873010198825698857660881913e-02
            2.76393202250024949684359398816014e-01 7.23606797749975050315640601183986e-01 0.00000000000000000000000000000000e+00 2.48015873010198825698857660881913e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   22
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.6e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.13362484459919171664310511005169e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 3.54191263282109991723800579421777e-04
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 3.54191263282109991723800579421777e-04
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 3.54191263282109991723800579421777e-04
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 1.60113717128642606135624504304360e-02
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 1.60113717128642606135624504304360e-02
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 1.60113717128642606135624504304360e-02
            4.49779338187016208827628815924982e-01 4.49779338187016208827628815924982e-01 1.00441323625967582344742368150037e-01 8.41414335445766492505015321512474e-02
            4.49779338187016208827628815924982e-01 1.00441323625967582344742368150037e-01 4.49779338187016208827628815924982e-01 8.41414335445766492505015321512474e-02
            1.00441323625967582344742368150037e-01 4.49779338187016208827628815924982e-01 4.49779338187016208827628815924982e-01 8.41414335445766492505015321512474e-02
            4.69474431990903329214859240892110e-02 4.69474431990903329214859240892110e-02 9.06105113601819334157028151821578e-01 2.60641812382901259803613669419065e-02
            4.69474431990903329214859240892110e-02 9.06105113601819334157028151821578e-01 4.69474431990903329214859240892110e-02 2.60641812382901259803613669419065e-02
            9.06105113601819334157028151821578e-01 4.69474431990903329214859240892110e-02 4.69474431990903329214859240892110e-02 2.60641812382901259803613669419065e-02
            1.91871912737448913066629074819502e-01 1.91871912737448913066629074819502e-01 6.16256174525102173866741850360995e-01 8.24075819997682479378653397361632e-02
            1.91871912737448913066629074819502e-01 6.16256174525102173866741850360995e-01 1.91871912737448913066629074819502e-01 8.24075819997682479378653397361632e-02
            6.16256174525102173866741850360995e-01 1.91871912737448913066629074819502e-01 1.91871912737448913066629074819502e-01 8.24075819997682479378653397361632e-02
            3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01 2.21962989160765733487323814188130e-01 4.32835393772893969877024744619121e-02
            3.68384120547362581277184290229343e-02 2.21962989160765733487323814188130e-01 7.41198598784498008384957756788936e-01 4.32835393772893969877024744619121e-02
            7.41198598784498008384957756788936e-01 3.68384120547362581277184290229343e-02 2.21962989160765733487323814188130e-01 4.32835393772893969877024744619121e-02
            7.41198598784498008384957756788936e-01 2.21962989160765733487323814188130e-01 3.68384120547362581277184290229343e-02 4.32835393772893969877024744619121e-02
            2.21962989160765733487323814188130e-01 3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01 4.32835393772893969877024744619121e-02
            2.21962989160765733487323814188130e-01 7.41198598784498008384957756788936e-01 3.68384120547362581277184290229343e-02 4.32835393772893969877024744619121e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.5e-14
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 8.79773011622219103244901816651691e-02
            2.59891409282883290021715083639720e-02 2.59891409282883290021715083639720e-02 9.48021718143423397506808214529883e-01 8.74431155373619171944366001980598e-03
            2.59891409282883290021715083639720e-02 9.48021718143423397506808214529883e-01 2.59891409282883290021715083639720e-02 8.74431155373619171944366001980598e-03
            9.48021718143423397506808214529883e-01 2.59891409282883290021715083639720e-02 2.59891409282883290021715083639720e-02 8.74431155373619171944366001980598e-03
            9.42875026479226968634250738432456e-02 9.42875026479226968634250738432456e-02 8.11424994704154634028725467942422e-01 3.80815719939353383716174050732661e-02
            9.42875026479226968634250738432456e-02 8.11424994704154634028725467942422e-01 9.42875026479226968634250738432456e-02 3.80815719939353383716174050732661e-02
            8.11424994704154634028725467942422e-01 9.42875026479226968634250738432456e-02 9.42875026479226968634250738432456e-02 3.80815719939353383716174050732661e-02
            4.94636775017214702643286727834493e-01 4.94636775017214702643286727834493e-01 1.07264499655705947134265443310142e-02 1.88554480561312562403308845659922e-02
            4.94636775017214702643286727834493e-01 1.07264499655705947134265443310142e-02 4.94636775017214702643286727834493e-01 1.88554480561312562403308845659922e-02
            1.07264499655705947134265443310142e-02 4.94636775017214702643286727834493e-01 4.94636775017214702643286727834493e-01 1.88554480561312562403308845659922e-02
            2.07343382614514210038336727848218e-01 2.07343382614514210038336727848218e-01 5.85313234770971524412175313045736e-01 7.21596975447410110549029127469112e-02
            2.07343382614514210038336727848218e-01 5.85313234770971524412175313045736e-01 2.07343382614514210038336727848218e-01 7.21596975447410110549029127469112e-02
            5.85313234770971524412175313045736e-01 2.07343382614514210038336727848218e-01 2.07343382614514210038336727848218e-01 7.21596975447410110549029127469112e-02
            4.38907805700490705191896267933771e-01 4.38907805700490705191896267933771e-01 1.22184388599018589616207464132458e-01 6.93291387055372104741834959895641e-02
            4.38907805700490705191896267933771e-01 1.22184388599018589616207464132458e-01 4.38907805700490705191896267933771e-01 6.93291387055372104741834959895641e-02
            1.22184388599018589616207464132458e-01 4.38907805700490705191896267933771e-01 4.38907805700490705191896267933771e-01 6.93291387055372104741834959895641e-02
            0.00000000000000000000000000000000e+00 8.58870281282636427455656757956604e-01 1.41129718717363572544343242043396e-01 7.36238378330057556542254104670064e-03
            0.00000000000000000000000000000000e+00 1.41129718717363572544343242043396e-01 8.58870281282636427455656757956604e-01 7.36238378330057556542254104670064e-03
            8.58870281282636427455656757956604e-01 0.00000000000000000000000000000000e+00 1.41129718717363572544343242043396e-01 7.36238378330057556542254104670064e-03
            8.58870281282636427455656757956604e-01 1.41129718717363572544343242043396e-01 0.00000000000000000000000000000000e+00 7.36238378330057556542254104670064e-03
            1.41129718717363572544343242043396e-01 0.00000000000000000000000000000000e+00 8.58870281282636427455656757956604e-01 7.36238378330057556542254104670064e-03
            1.41129718717363572544343242043396e-01 8.58870281282636427455656757956604e-01 0.00000000000000000000000000000000e+00 7.36238378330057556542254104670064e-03
            4.48416775891305532941721878614771e-02 6.77937654882590168270439789921511e-01 2.77220667528279229863130694866413e-01 4.10563154292886076102142567378905e-02
            4.48416775891305532941721878614771e-02 2.77220667528279229863130694866413e-01 6.77937654882590168270439789921511e-01 4.10563154292886076102142567378905e-02
            6.77937654882590168270439789921511e-01 4.48416775891305532941721878614771e-02 2.77220667528279229863130694866413e-01 4.10563154292886076102142567378905e-02
            6.77937654882590168270439789921511e-01 2.77220667528279229863130694866413e-01 4.48416775891305532941721878614771e-02 4.10563154292886076102142567378905e-02
            2.77220667528279229863130694866413e-01 4.48416775891305532941721878614771e-02 6.77937654882590168270439789921511e-01 4.10563154292886076102142567378905e-02
            2.77220667528279229863130694866413e-01 6.77937654882590168270439789921511e-01 4.48416775891305532941721878614771e-02 4.10563154292886076102142567378905e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    4 1.39e-16    0    0
    3    7 2.22e-16    0    0
    4   10 6.66e-16    3    0
    5   10 2.50e-16    0    0
    6   16 9.44e-16    4    4
    7   16 2.80e-13    0    0
    8   21 7.28e-12    3    0
    9   22 3.57e-15    0    0
    11   28 3.54e-14    0    0
    ];




