
function [S1,S2,S3,pointset_stats]=set_lyness_jespersen_II_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J.N. Lyness, D. Jespersen,
%  "Moderate Degree Symmetric Quadrature Rules for the Triangle"
%  J. Inst. Maths Applies, 15 (1975), pp.19-32.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   4 |   0 |   0 | 1.39e-16 |PI|
% |   3 |   7 |   0 |   0 | 2.22e-16 |PI|
% |   4 |  10 |   3 |   0 | 6.66e-16 |NI|
% |   5 |  10 |   0 |   0 | 2.50e-16 |PI|
% |   6 |  16 |   4 |   4 | 9.44e-16 |N0|
% |   7 |  16 |   0 |   0 | 2.80e-13 |PI|
% |   8 |  21 |   3 |   0 | 7.28e-12 |NI|
% |   9 |  22 |   0 |   0 | 3.57e-15 |PI|
% |  11 |  28 |   0 |   0 | 3.54e-14 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    4
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.4e-16
        
        S1=[];
        
        S2=[
            8.33333333333333287074040640618477e-02 0.00000000000000000000000000000000e+00
            ];
        
        S3=[
            7.50000000000000000000000000000000e-01
            ];
        
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        S1=[];
        
        S2=[
            5.00000000000000027755575615628914e-02 0.00000000000000000000000000000000e+00
            1.33333333333333331482961625624739e-01 5.00000000000000000000000000000000e-01
            ];
        
        S3=[
            4.50000000000000011102230246251565e-01
            ];
        
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:   10
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 6.7e-16
        
        S1=[
            1.00000000000000005551115123125783e-01 7.88675134594812754507131558057154e-01 2.11324865405187134470565979427192e-01
            ];
        
        S2=[
            -1.66666666666666664353702032030924e-02 0.00000000000000000000000000000000e+00
            ];
        
        S3=[
            4.50000000000000011102230246251565e-01
            ];
        
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:   10
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.5e-16
        
        S1=[];
        
        S2=[
            1.11111111111111115351546274609973e-02 0.00000000000000000000000000000000e+00
            7.11111111111111110494320541874913e-02 5.00000000000000000000000000000000e-01
            1.66736111111111112714766591125226e-01 1.42857142857142849212692681248882e-01
            ];
        
        S3=[
            2.53124999999999988897769753748435e-01
            ];
        
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   16
        % NEG. W.  :    4
        % OUT PTS. :    4
        % M.E.INF. : 9.4e-16
        
        S1=[
            4.28571428571428575393653659375559e-02 9.08248290463863017230039531568764e-01 9.17517095361370244033238918746065e-02
            ];
        
        S2=[
            -1.98412698412698401684295390623447e-02 0.00000000000000000000000000000000e+00
            5.39682539682539708092434693753603e-02 5.00000000000000000000000000000000e-01
            4.06349206349206348853897452499950e-01 2.50000000000000000000000000000000e-01
            ];
        
        S3=[
            -5.78571428571428625353689767507603e-01
            ];
        
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-13
        
        S1=[
            2.36850363099267158251137743718573e-02 0.00000000000000000000000000000000e+00 8.39299172272923610371719860268058e-01
            ];
        
        S2=[
            4.03633844254436702919663915167803e-03 0.00000000000000000000000000000000e+00
            1.16652058589903129259823799657170e-01 1.54936060223760413423477189098776e-01
            1.06503991814174012175975292393559e-01 4.69150746143812025223951422958635e-01
            ];
        
        S3=[
            1.76312615600525190995284674499999e-01
            ];
        
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   21
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 7.3e-12
        
        S1=[
            2.48015873009206355703781810007058e-02 0.00000000000000000000000000000000e+00 7.23606797749975050315640601183986e-01
            ];
        
        S2=[
            4.02424645097591675291237578449000e-03 0.00000000000000000000000000000000e+00
            -2.83052662638381857806990637982381e-01 5.00000000000000000000000000000000e-01
            3.47455822963778027112624613437220e-01 4.95681394175558176495854922904982e-01
            6.49076597137420024941079077507311e-02 9.03277575142653332829212331489543e-02
            1.50395092240044075948546264953620e-01 2.34154749707305209760477282543434e-01
            ];
        
        S3=[];
        
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   22
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.6e-15
        
        S1=[
            4.32835393772894039265963783691404e-02 3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01
            ];
        
        S2=[
            3.54191263282110045933909203696999e-04 0.00000000000000000000000000000000e+00
            1.60113717128642640830094023840502e-02 5.00000000000000000000000000000000e-01
            8.41414335445766631282893399657041e-02 4.49779338187016208827628815924982e-01
            2.60641812382901329192552708491348e-02 4.69474431990903329214859240892110e-02
            8.24075819997682618156531475506199e-02 1.91871912737448913066629074819502e-01
            ];
        
        S3=[
            1.13362484459919199419886126634083e-01
            ];
        
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.5e-14
        
        S1=[
            7.36238378330057383069906506989355e-03 0.00000000000000000000000000000000e+00 8.58870281282636427455656757956604e-01
            4.10563154292886006713203528306622e-02 4.48416775891305532941721878614771e-02 6.77937654882590168270439789921511e-01
            ];
        
        S2=[
            8.74431155373618998472018404299888e-03 2.59891409282883290021715083639720e-02
            3.80815719939353314327235011660377e-02 9.42875026479226968634250738432456e-02
            1.88554480561312527708839326123780e-02 4.94636775017214702643286727834493e-01
            7.21596975447409971771151049324544e-02 2.07343382614514210038336727848218e-01
            6.93291387055371965963956881751074e-02 4.38907805700490705191896267933771e-01
            ];
        
        S3=[
            8.79773011622218964467023738507123e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    2    4 1.39e-16    0    0
    3    7 2.22e-16    0    0
    4   10 6.66e-16    3    0
    5   10 2.50e-16    0    0
    6   16 9.44e-16    4    4
    7   16 2.80e-13    0    0
    8   21 7.28e-12    3    0
    9   22 3.57e-15    0    0
    11   28 3.54e-14    0    0
    ];




