
function [xyw,pointset_stats]=set_lyness_jespersen_II_standard(deg)

% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn. Dubiner basis,
%    number of points with negative weights, number of points outside the domain.
% --------------------------------------------------------------------
% SOURCE:
% J.N. Lyness, D. Jespersen,
% "Moderate Degree Symmetric Quadrature Rules for the Triangle"
% J. Inst. Maths Applies, 15 (1975), pp.19-32.
% --------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
% --------------------------------------------------------------------
% |   2 |   4 |   0 |   0 | 1.39e-16 |PI|
% |   3 |   7 |   0 |   0 | 2.22e-16 |PI|
% |   4 |  10 |   3 |   0 | 6.66e-16 |NI|
% |   5 |  10 |   0 |   0 | 2.50e-16 |PI|
% |   6 |  16 |   4 |   4 | 9.44e-16 |N0|
% |   7 |  16 |   0 |   0 | 2.80e-13 |PI|
% |   8 |  21 |   3 |   0 | 7.28e-12 |NI|
% |   9 |  22 |   0 |   0 | 3.57e-15 |PI|
% |  11 |  28 |   0 |   0 | 3.54e-14 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    4
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.4e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.75000000000000000000000000000000e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 4.16666666666666643537020320309239e-02
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 4.16666666666666643537020320309239e-02
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 4.16666666666666643537020320309239e-02
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.25000000000000005551115123125783e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 2.50000000000000013877787807814457e-02
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 2.50000000000000013877787807814457e-02
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 2.50000000000000013877787807814457e-02
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 6.66666666666666657414808128123695e-02
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 6.66666666666666657414808128123695e-02
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 6.66666666666666657414808128123695e-02
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:   10
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 6.7e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.25000000000000061062266354383610e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 -8.33333333333333495240857757835329e-03
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 -8.33333333333333495240857757835329e-03
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 -8.33333333333333495240857757835329e-03
            7.88675134594812754507131558057154e-01 2.11324865405187134470565979427192e-01 5.00000000000000166533453693773481e-02
            7.88675134594812754507131558057154e-01 1.11022302462515654042363166809082e-16 5.00000000000000166533453693773481e-02
            2.11324865405187134470565979427192e-01 7.88675134594812754507131558057154e-01 5.00000000000000166533453693773481e-02
            2.11324865405187134470565979427192e-01 1.11022302462515654042363166809082e-16 5.00000000000000166533453693773481e-02
            1.11022302462515654042363166809082e-16 7.88675134594812754507131558057154e-01 5.00000000000000166533453693773481e-02
            1.11022302462515654042363166809082e-16 2.11324865405187134470565979427192e-01 5.00000000000000166533453693773481e-02
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:   10
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.5e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.26562499999999994448884876874217e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 5.55555555555555576757731373049864e-03
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 5.55555555555555576757731373049864e-03
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 5.55555555555555576757731373049864e-03
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 3.55555555555555555247160270937457e-02
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 3.55555555555555555247160270937457e-02
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 3.55555555555555555247160270937457e-02
            1.42857142857142849212692681248882e-01 1.42857142857142849212692681248882e-01 8.33680555555555563573832955626131e-02
            1.42857142857142849212692681248882e-01 7.14285714285714301574614637502236e-01 8.33680555555555563573832955626131e-02
            7.14285714285714301574614637502236e-01 1.42857142857142849212692681248882e-01 8.33680555555555563573832955626131e-02
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   16
        % NEG. W.  :    4
        % OUT PTS. :    4
        % M.E.INF. : 9.4e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -2.89285714285714423699147346269456e-01
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 -9.92063492063492528838519746159363e-03
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 -9.92063492063492528838519746159363e-03
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 -9.92063492063492528838519746159363e-03
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 2.69841269841269958129625905485227e-02
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 2.69841269841269958129625905485227e-02
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 2.69841269841269958129625905485227e-02
            2.50000000000000000000000000000000e-01 2.50000000000000000000000000000000e-01 2.03174603174603257693675573136716e-01
            2.50000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 2.03174603174603257693675573136716e-01
            5.00000000000000000000000000000000e-01 2.50000000000000000000000000000000e-01 2.03174603174603257693675573136716e-01
            9.08248290463863017230039531568764e-01 9.17517095361370244033238918746065e-02 2.14285714285714391780235388296205e-02
            9.08248290463863017230039531568764e-01 -4.16333634234433702658861875534058e-17 2.14285714285714391780235388296205e-02
            9.17517095361370244033238918746065e-02 9.08248290463863017230039531568764e-01 2.14285714285714391780235388296205e-02
            9.17517095361370244033238918746065e-02 -4.16333634234433702658861875534058e-17 2.14285714285714391780235388296205e-02
            -4.16333634234433702658861875534058e-17 9.08248290463863017230039531568764e-01 2.14285714285714391780235388296205e-02
            -4.16333634234433702658861875534058e-17 9.17517095361370244033238918746065e-02 2.14285714285714391780235388296205e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-13
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 8.81563078002670225119530300617043e-02
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 2.01816922127228499592166421905404e-03
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 2.01816922127228499592166421905404e-03
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 2.01816922127228499592166421905404e-03
            1.54936060223760413423477189098776e-01 1.54936060223760413423477189098776e-01 5.83260292949544928431393486789602e-02
            1.54936060223760413423477189098776e-01 6.90127879552479228664196853060275e-01 5.83260292949544928431393486789602e-02
            6.90127879552479228664196853060275e-01 1.54936060223760413423477189098776e-01 5.83260292949544928431393486789602e-02
            4.69150746143812025223951422958635e-01 4.69150746143812025223951422958635e-01 5.32519959070896775621406504797051e-02
            4.69150746143812025223951422958635e-01 6.16985077123759495520971540827304e-02 5.32519959070896775621406504797051e-02
            6.16985077123759495520971540827304e-02 4.69150746143812025223951422958635e-01 5.32519959070896775621406504797051e-02
            0.00000000000000000000000000000000e+00 8.39299172272923610371719860268058e-01 1.18425181549639529227091472307620e-02
            0.00000000000000000000000000000000e+00 1.60700827727076389628280139731942e-01 1.18425181549639529227091472307620e-02
            8.39299172272923610371719860268058e-01 0.00000000000000000000000000000000e+00 1.18425181549639529227091472307620e-02
            8.39299172272923610371719860268058e-01 1.60700827727076389628280139731942e-01 1.18425181549639529227091472307620e-02
            1.60700827727076389628280139731942e-01 0.00000000000000000000000000000000e+00 1.18425181549639529227091472307620e-02
            1.60700827727076389628280139731942e-01 8.39299172272923610371719860268058e-01 1.18425181549639529227091472307620e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   21
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 7.3e-12
        
        xyw=[
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 2.01212322549601009546993424237371e-03
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 2.01212322549601009546993424237371e-03
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 2.01212322549601009546993424237371e-03
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 -1.41526331319757281423932226971374e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 -1.41526331319757281423932226971374e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 -1.41526331319757281423932226971374e-01
            4.95681394175558176495854922904982e-01 4.95681394175558176495854922904982e-01 1.73727911482584207458756964115310e-01
            4.95681394175558176495854922904982e-01 8.63721164888364700829015419003554e-03 1.73727911482584207458756964115310e-01
            8.63721164888364700829015419003554e-03 4.95681394175558176495854922904982e-01 1.73727911482584207458756964115310e-01
            9.03277575142653332829212331489543e-02 9.03277575142653332829212331489543e-02 3.24538298570008695853594815616816e-02
            9.03277575142653332829212331489543e-02 8.19344484971469277923006302444264e-01 3.24538298570008695853594815616816e-02
            8.19344484971469277923006302444264e-01 9.03277575142653332829212331489543e-02 3.24538298570008695853594815616816e-02
            2.34154749707305209760477282543434e-01 2.34154749707305209760477282543434e-01 7.51975461203229500473099733426352e-02
            2.34154749707305209760477282543434e-01 5.31690500585389580479045434913132e-01 7.51975461203229500473099733426352e-02
            5.31690500585389580479045434913132e-01 2.34154749707305209760477282543434e-01 7.51975461203229500473099733426352e-02
            0.00000000000000000000000000000000e+00 7.23606797749975050315640601183986e-01 1.24007936505099412849428830440957e-02
            0.00000000000000000000000000000000e+00 2.76393202250024949684359398816014e-01 1.24007936505099412849428830440957e-02
            7.23606797749975050315640601183986e-01 0.00000000000000000000000000000000e+00 1.24007936505099412849428830440957e-02
            7.23606797749975050315640601183986e-01 2.76393202250024949684359398816014e-01 1.24007936505099412849428830440957e-02
            2.76393202250024949684359398816014e-01 0.00000000000000000000000000000000e+00 1.24007936505099412849428830440957e-02
            2.76393202250024949684359398816014e-01 7.23606797749975050315640601183986e-01 1.24007936505099412849428830440957e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   22
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.6e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 5.66812422299595858321552555025846e-02
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.77095631641054995861900289710889e-04
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 1.77095631641054995861900289710889e-04
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.77095631641054995861900289710889e-04
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 8.00568585643213030678122521521800e-03
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 8.00568585643213030678122521521800e-03
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 8.00568585643213030678122521521800e-03
            4.49779338187016208827628815924982e-01 4.49779338187016208827628815924982e-01 4.20707167722883246252507660756237e-02
            4.49779338187016208827628815924982e-01 1.00441323625967582344742368150037e-01 4.20707167722883246252507660756237e-02
            1.00441323625967582344742368150037e-01 4.49779338187016208827628815924982e-01 4.20707167722883246252507660756237e-02
            4.69474431990903329214859240892110e-02 4.69474431990903329214859240892110e-02 1.30320906191450629901806834709532e-02
            4.69474431990903329214859240892110e-02 9.06105113601819334157028151821578e-01 1.30320906191450629901806834709532e-02
            9.06105113601819334157028151821578e-01 4.69474431990903329214859240892110e-02 1.30320906191450629901806834709532e-02
            1.91871912737448913066629074819502e-01 1.91871912737448913066629074819502e-01 4.12037909998841239689326698680816e-02
            1.91871912737448913066629074819502e-01 6.16256174525102173866741850360995e-01 4.12037909998841239689326698680816e-02
            6.16256174525102173866741850360995e-01 1.91871912737448913066629074819502e-01 4.12037909998841239689326698680816e-02
            3.68384120547362581277184290229343e-02 7.41198598784498008384957756788936e-01 2.16417696886446984938512372309560e-02
            3.68384120547362581277184290229343e-02 2.21962989160765733487323814188130e-01 2.16417696886446984938512372309560e-02
            7.41198598784498008384957756788936e-01 3.68384120547362581277184290229343e-02 2.16417696886446984938512372309560e-02
            7.41198598784498008384957756788936e-01 2.21962989160765733487323814188130e-01 2.16417696886446984938512372309560e-02
            2.21962989160765733487323814188130e-01 3.68384120547362581277184290229343e-02 2.16417696886446984938512372309560e-02
            2.21962989160765733487323814188130e-01 7.41198598784498008384957756788936e-01 2.16417696886446984938512372309560e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.5e-14
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.39886505811109551622450908325845e-02
            2.59891409282883290021715083639720e-02 2.59891409282883290021715083639720e-02 4.37215577686809585972183000990299e-03
            2.59891409282883290021715083639720e-02 9.48021718143423397506808214529883e-01 4.37215577686809585972183000990299e-03
            9.48021718143423397506808214529883e-01 2.59891409282883290021715083639720e-02 4.37215577686809585972183000990299e-03
            9.42875026479226968634250738432456e-02 9.42875026479226968634250738432456e-02 1.90407859969676691858087025366331e-02
            9.42875026479226968634250738432456e-02 8.11424994704154634028725467942422e-01 1.90407859969676691858087025366331e-02
            8.11424994704154634028725467942422e-01 9.42875026479226968634250738432456e-02 1.90407859969676691858087025366331e-02
            4.94636775017214702643286727834493e-01 4.94636775017214702643286727834493e-01 9.42772402806562812016544228299608e-03
            4.94636775017214702643286727834493e-01 1.07264499655705947134265443310142e-02 9.42772402806562812016544228299608e-03
            1.07264499655705947134265443310142e-02 4.94636775017214702643286727834493e-01 9.42772402806562812016544228299608e-03
            2.07343382614514210038336727848218e-01 2.07343382614514210038336727848218e-01 3.60798487723705055274514563734556e-02
            2.07343382614514210038336727848218e-01 5.85313234770971524412175313045736e-01 3.60798487723705055274514563734556e-02
            5.85313234770971524412175313045736e-01 2.07343382614514210038336727848218e-01 3.60798487723705055274514563734556e-02
            4.38907805700490705191896267933771e-01 4.38907805700490705191896267933771e-01 3.46645693527686052370917479947821e-02
            4.38907805700490705191896267933771e-01 1.22184388599018589616207464132458e-01 3.46645693527686052370917479947821e-02
            1.22184388599018589616207464132458e-01 4.38907805700490705191896267933771e-01 3.46645693527686052370917479947821e-02
            0.00000000000000000000000000000000e+00 8.58870281282636427455656757956604e-01 3.68119189165028778271127052335032e-03
            0.00000000000000000000000000000000e+00 1.41129718717363572544343242043396e-01 3.68119189165028778271127052335032e-03
            8.58870281282636427455656757956604e-01 0.00000000000000000000000000000000e+00 3.68119189165028778271127052335032e-03
            8.58870281282636427455656757956604e-01 1.41129718717363572544343242043396e-01 3.68119189165028778271127052335032e-03
            1.41129718717363572544343242043396e-01 0.00000000000000000000000000000000e+00 3.68119189165028778271127052335032e-03
            1.41129718717363572544343242043396e-01 8.58870281282636427455656757956604e-01 3.68119189165028778271127052335032e-03
            4.48416775891305532941721878614771e-02 6.77937654882590168270439789921511e-01 2.05281577146443038051071283689453e-02
            4.48416775891305532941721878614771e-02 2.77220667528279229863130694866413e-01 2.05281577146443038051071283689453e-02
            6.77937654882590168270439789921511e-01 4.48416775891305532941721878614771e-02 2.05281577146443038051071283689453e-02
            6.77937654882590168270439789921511e-01 2.77220667528279229863130694866413e-01 2.05281577146443038051071283689453e-02
            2.77220667528279229863130694866413e-01 4.48416775891305532941721878614771e-02 2.05281577146443038051071283689453e-02
            2.77220667528279229863130694866413e-01 6.77937654882590168270439789921511e-01 2.05281577146443038051071283689453e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    4 1.39e-16    0    0
    3    7 2.22e-16    0    0
    4   10 6.66e-16    3    0
    5   10 2.50e-16    0    0
    6   16 9.44e-16    4    4
    7   16 2.80e-13    0    0
    8   21 7.28e-12    3    0
    9   22 3.57e-15    0    0
    11   28 3.54e-14    0    0
    ];

