
function [xyw_bar,pointset_stats]=set_lyness_jespersen_III_barycentric(deg)

% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn. Dubiner basis,
%    number of points with negative weights, number of points outside the domain.
% --------------------------------------------------------------------
% SOURCE:
% J.N. Lyness, D. Jespersen,
% "Moderate Degree Symmetric Quadrature Rules for the Triangle"
% J. Inst. Maths Applies, 15 (1975), pp.19-32.
% --------------------------------------------------------------------
%----------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%----------------------------------------
% |   4 |   9 |   0 |   0 | 3.89e-16 |PI|
% |   6 |  13 |   0 |   0 | 2.44e-15 |PI|
% |   8 |  16 |   1 |   0 | 2.91e-15 |NI|
%---------------------------------------
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    9
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-16
        
        xyw_bar=[
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 2.05401353459333628481697786583027e-02
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 2.05401353459333628481697786583027e-02
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 2.05401353459333628481697786583027e-02
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 6.19754988682671495436871111905930e-02
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 6.19754988682671495436871111905930e-02
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 6.19754988682671495436871111905930e-02
            1.88580484696445060954772543482250e-01 1.88580484696445060954772543482250e-01 6.22839030607109878090454913035501e-01 2.50817699119132819784994126166566e-01
            1.88580484696445060954772543482250e-01 6.22839030607109878090454913035501e-01 1.88580484696445060954772543482250e-01 2.50817699119132819784994126166566e-01
            6.22839030607109878090454913035501e-01 1.88580484696445060954772543482250e-01 1.88580484696445060954772543482250e-01 2.50817699119132819784994126166566e-01
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   13
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.4e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.52708966788352329402300711080898e-01
            4.73830813953651286407620091267745e-01 4.73830813953651286407620091267745e-01 5.23383720926974271847598174645100e-02 9.81358680788921022841719832285889e-02
            4.73830813953651286407620091267745e-01 5.23383720926974271847598174645100e-02 4.73830813953651286407620091267745e-01 9.81358680788921022841719832285889e-02
            5.23383720926974271847598174645100e-02 4.73830813953651286407620091267745e-01 4.73830813953651286407620091267745e-01 9.81358680788921022841719832285889e-02
            1.72117669630817510251219459860295e-01 1.72117669630817510251219459860295e-01 6.55764660738364923986409849021584e-01 1.29568429280625563304596425950876e-01
            1.72117669630817510251219459860295e-01 6.55764660738364923986409849021584e-01 1.72117669630817510251219459860295e-01 1.29568429280625563304596425950876e-01
            6.55764660738364923986409849021584e-01 1.72117669630817510251219459860295e-01 1.72117669630817510251219459860295e-01 1.29568429280625563304596425950876e-01
            0.00000000000000000000000000000000e+00 8.65307354083457047622118807339575e-01 1.34692645916542952377881192660425e-01 2.73630235221824884284114176580260e-02
            0.00000000000000000000000000000000e+00 1.34692645916542952377881192660425e-01 8.65307354083457047622118807339575e-01 2.73630235221824884284114176580260e-02
            8.65307354083457047622118807339575e-01 0.00000000000000000000000000000000e+00 1.34692645916542952377881192660425e-01 2.73630235221824884284114176580260e-02
            8.65307354083457047622118807339575e-01 1.34692645916542952377881192660425e-01 0.00000000000000000000000000000000e+00 2.73630235221824884284114176580260e-02
            1.34692645916542952377881192660425e-01 0.00000000000000000000000000000000e+00 8.65307354083457047622118807339575e-01 2.73630235221824884284114176580260e-02
            1.34692645916542952377881192660425e-01 8.65307354083457047622118807339575e-01 0.00000000000000000000000000000000e+00 2.73630235221824884284114176580260e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.9e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -2.83418385111395665365563445448061e-01
            4.76665439382152500424894014940946e-01 4.76665439382152500424894014940946e-01 4.66691212356949991502119701181073e-02 6.99069619326523755686864092240285e-02
            4.76665439382152500424894014940946e-01 4.66691212356949991502119701181073e-02 4.76665439382152500424894014940946e-01 6.99069619326523755686864092240285e-02
            4.66691212356949991502119701181073e-02 4.76665439382152500424894014940946e-01 4.76665439382152500424894014940946e-01 6.99069619326523755686864092240285e-02
            3.37718440544803322200806405817275e-02 3.37718440544803322200806405817275e-02 9.32456311891039391070989950094372e-01 1.70909126716008753776865347617786e-02
            3.37718440544803322200806405817275e-02 9.32456311891039391070989950094372e-01 3.37718440544803322200806405817275e-02 1.70909126716008753776865347617786e-02
            9.32456311891039391070989950094372e-01 3.37718440544803322200806405817275e-02 3.37718440544803322200806405817275e-02 1.70909126716008753776865347617786e-02
            2.70347889165403976186041745677358e-01 2.70347889165403976186041745677358e-01 4.59304221669192047627916508645285e-01 2.18829882330450170568880707833159e-01
            2.70347889165403976186041745677358e-01 4.59304221669192047627916508645285e-01 2.70347889165403976186041745677358e-01 2.18829882330450170568880707833159e-01
            4.59304221669192047627916508645285e-01 2.70347889165403976186041745677358e-01 2.70347889165403976186041745677358e-01 2.18829882330450170568880707833159e-01
            5.14643354866614888276643569042790e-02 7.45829490767251357397071842569858e-01 2.02706173746087126019688184896950e-01 6.09891857178808879935694164942106e-02
            5.14643354866614888276643569042790e-02 2.02706173746087126019688184896950e-01 7.45829490767251357397071842569858e-01 6.09891857178808879935694164942106e-02
            7.45829490767251357397071842569858e-01 5.14643354866614888276643569042790e-02 2.02706173746087126019688184896950e-01 6.09891857178808879935694164942106e-02
            7.45829490767251357397071842569858e-01 2.02706173746087126019688184896950e-01 5.14643354866614888276643569042790e-02 6.09891857178808879935694164942106e-02
            2.02706173746087126019688184896950e-01 5.14643354866614888276643569042790e-02 7.45829490767251357397071842569858e-01 6.09891857178808879935694164942106e-02
            2.02706173746087126019688184896950e-01 7.45829490767251357397071842569858e-01 5.14643354866614888276643569042790e-02 6.09891857178808879935694164942106e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    4    9 3.89e-16    0    0
    6   13 2.44e-15    0    0
    8   16 2.91e-15    1    0
    ];




