
function [S1,S2,S3,pointset_stats]=set_lyness_jespersen_III_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  J.N. Lyness, D. Jespersen,
%  "Moderate Degree Symmetric Quadrature Rules for the Triangle"
%  J. Inst. Maths Applies, 15 (1975), pp.19-32.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   4 |   9 |   0 |   0 | 3.89e-16 |PI|
% |   6 |  13 |   0 |   0 | 2.44e-15 |PI|
% |   8 |  16 |   1 |   0 | 2.91e-15 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    9
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-16
        
        S1=[];
        
        S2=[
            2.05401353459333628481697786583027e-02 0.00000000000000000000000000000000e+00
            6.19754988682671495436871111905930e-02 5.00000000000000000000000000000000e-01
            2.50817699119132819784994126166566e-01 1.88580484696445060954772543482250e-01
            ];
        
        S3=[];
        
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   13
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.4e-15
        
        S1=[
            2.73630235221824814895175137507977e-02 0.00000000000000000000000000000000e+00 8.65307354083457047622118807339575e-01
            ];
        
        S2=[
            9.81358680788920745285963675996754e-02 4.73830813953651286407620091267745e-01
            1.29568429280625535549020810321963e-01 1.72117669630817510251219459860295e-01
            ];
        
        S3=[
            1.52708966788352301646725095451984e-01
            ];
        
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.9e-15
        
        S1=[
            6.09891857178809157491450321231241e-02 5.14643354866614888276643569042790e-02 7.45829490767251357397071842569858e-01
            ];
        
        S2=[
            6.99069619326524033242620248529420e-02 4.76665439382152500424894014940946e-01
            1.70909126716008823165804386690070e-02 3.37718440544803322200806405817275e-02
            2.18829882330450281591183170348813e-01 2.70347889165403976186041745677358e-01
            ];
        
        S3=[
            -2.83418385111395776387865907963715e-01
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    4    9 3.89e-16    0    0
    6   13 2.44e-15    0    0
    8   16 2.91e-15    1    0
    ];




