
function [xyw,pointset_stats]=set_lyness_jespersen_III_standard(deg)

% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn. Dubiner basis,
%    number of points with negative weights, number of points outside the domain.
% --------------------------------------------------------------------
% SOURCE:
% J.N. Lyness, D. Jespersen,
% "Moderate Degree Symmetric Quadrature Rules for the Triangle"
% J. Inst. Maths Applies, 15 (1975), pp.19-32.
% --------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
% --------------------------------------------------------------------
% |   4 |   9 |   0 |   0 | 3.89e-16 |PI|
% |   6 |  13 |   0 |   0 | 2.44e-15 |PI|
% |   8 |  16 |   1 |   0 | 2.91e-15 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    9
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-16
        
        xyw=[
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.02700676729666814240848893291513e-02
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 1.02700676729666814240848893291513e-02
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.02700676729666814240848893291513e-02
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 3.09877494341335747718435555952965e-02
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 3.09877494341335747718435555952965e-02
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 3.09877494341335747718435555952965e-02
            1.88580484696445060954772543482250e-01 1.88580484696445060954772543482250e-01 1.25408849559566409892497063083283e-01
            1.88580484696445060954772543482250e-01 6.22839030607109878090454913035501e-01 1.25408849559566409892497063083283e-01
            6.22839030607109878090454913035501e-01 1.88580484696445060954772543482250e-01 1.25408849559566409892497063083283e-01
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   13
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.4e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 7.63544833941761647011503555404488e-02
            4.73830813953651286407620091267745e-01 4.73830813953651286407620091267745e-01 4.90679340394460511420859916142945e-02
            4.73830813953651286407620091267745e-01 5.23383720926974271847598174645100e-02 4.90679340394460511420859916142945e-02
            5.23383720926974271847598174645100e-02 4.73830813953651286407620091267745e-01 4.90679340394460511420859916142945e-02
            1.72117669630817510251219459860295e-01 1.72117669630817510251219459860295e-01 6.47842146403127816522982129754382e-02
            1.72117669630817510251219459860295e-01 6.55764660738364923986409849021584e-01 6.47842146403127816522982129754382e-02
            6.55764660738364923986409849021584e-01 1.72117669630817510251219459860295e-01 6.47842146403127816522982129754382e-02
            0.00000000000000000000000000000000e+00 8.65307354083457047622118807339575e-01 1.36815117610912442142057088290130e-02
            0.00000000000000000000000000000000e+00 1.34692645916542952377881192660425e-01 1.36815117610912442142057088290130e-02
            8.65307354083457047622118807339575e-01 0.00000000000000000000000000000000e+00 1.36815117610912442142057088290130e-02
            8.65307354083457047622118807339575e-01 1.34692645916542952377881192660425e-01 1.36815117610912442142057088290130e-02
            1.34692645916542952377881192660425e-01 0.00000000000000000000000000000000e+00 1.36815117610912442142057088290130e-02
            1.34692645916542952377881192660425e-01 8.65307354083457047622118807339575e-01 1.36815117610912442142057088290130e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.9e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -1.41709192555697832682781722724030e-01
            4.76665439382152500424894014940946e-01 4.76665439382152500424894014940946e-01 3.49534809663261877843432046120142e-02
            4.76665439382152500424894014940946e-01 4.66691212356949991502119701181073e-02 3.49534809663261877843432046120142e-02
            4.66691212356949991502119701181073e-02 4.76665439382152500424894014940946e-01 3.49534809663261877843432046120142e-02
            3.37718440544803322200806405817275e-02 3.37718440544803322200806405817275e-02 8.54545633580043768884326738088930e-03
            3.37718440544803322200806405817275e-02 9.32456311891039391070989950094372e-01 8.54545633580043768884326738088930e-03
            9.32456311891039391070989950094372e-01 3.37718440544803322200806405817275e-02 8.54545633580043768884326738088930e-03
            2.70347889165403976186041745677358e-01 2.70347889165403976186041745677358e-01 1.09414941165225085284440353916580e-01
            2.70347889165403976186041745677358e-01 4.59304221669192047627916508645285e-01 1.09414941165225085284440353916580e-01
            4.59304221669192047627916508645285e-01 2.70347889165403976186041745677358e-01 1.09414941165225085284440353916580e-01
            5.14643354866614888276643569042790e-02 7.45829490767251357397071842569858e-01 3.04945928589404439967847082471053e-02
            5.14643354866614888276643569042790e-02 2.02706173746087126019688184896950e-01 3.04945928589404439967847082471053e-02
            7.45829490767251357397071842569858e-01 5.14643354866614888276643569042790e-02 3.04945928589404439967847082471053e-02
            7.45829490767251357397071842569858e-01 2.02706173746087126019688184896950e-01 3.04945928589404439967847082471053e-02
            2.02706173746087126019688184896950e-01 5.14643354866614888276643569042790e-02 3.04945928589404439967847082471053e-02
            2.02706173746087126019688184896950e-01 7.45829490767251357397071842569858e-01 3.04945928589404439967847082471053e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    4    9 3.89e-16    0    0
    6   13 2.44e-15    0    0
    8   16 2.91e-15    1    0
    ];

