
function [xyw_bar,pointset_stats]=set_lyness_jespersen_I_C_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% J.N. Lyness, D. Jespersen,
% "Moderate Degree Symmetric Quadrature Rules for the Triangle"
% J. Inst. Maths Applies, 15 (1975), pp.19-32.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.22e-16 |PI|
% |   5 |   7 |   0 |   0 | 4.79e-16 |PI|
% |   6 |  12 |   0 |   0 | 2.31e-16 |PI|
% |   7 |  13 |   1 |   0 | 4.16e-16 |NI|
% |   8 |  16 |   0 |   0 | 5.83e-16 |PI|
% |   9 |  19 |   0 |   0 | 3.05e-16 |PI|
% |  11 |  27 |   0 |   3 | 4.58e-16 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw_bar=[
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 3.33333333333333314829616256247391e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 3.33333333333333314829616256247391e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 3.33333333333333314829616256247391e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 -5.62500000000000000000000000000000e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 6.00000000000000088817841970012523e-01 5.20833333333333370340767487505218e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.00000000000000066613381477509392e-01 5.20833333333333370340767487505218e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 5.20833333333333370340767487505218e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw_bar=[
            9.15762135097707291597757262024970e-02 9.15762135097707291597757262024970e-02 8.16847572980458513924872931966092e-01 1.09951743655321856896200927167229e-01
            9.15762135097707291597757262024970e-02 8.16847572980458513924872931966092e-01 9.15762135097707430375635340169538e-02 1.09951743655321856896200927167229e-01
            8.16847572980458513924872931966092e-01 9.15762135097707291597757262024970e-02 9.15762135097707569153513418314105e-02 1.09951743655321856896200927167229e-01
            4.45948490915964890213274429697776e-01 4.45948490915964890213274429697776e-01 1.08103018168070219573451140604448e-01 2.23381589678011555077929983781360e-01
            4.45948490915964890213274429697776e-01 1.08103018168070219573451140604448e-01 4.45948490915964890213274429697776e-01 2.23381589678011555077929983781360e-01
            1.08103018168070219573451140604448e-01 4.45948490915964890213274429697776e-01 4.45948490915964890213274429697776e-01 2.23381589678011555077929983781360e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.8e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 2.25000000000000005551115123125783e-01
            1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 1.25939180544827167285149016606738e-01
            1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 1.01286507323456342888334802410100e-01 1.25939180544827167285149016606738e-01
            7.97426985353087314223330395179801e-01 1.01286507323456329010546994595643e-01 1.01286507323456356766122610224556e-01 1.25939180544827167285149016606738e-01
            4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 1.32394152788506164197812609018001e-01
            4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 1.32394152788506164197812609018001e-01
            5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 1.32394152788506164197812609018001e-01
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.3e-16
        
        xyw_bar=[
            2.49286745170932910742322974328999e-01 2.49286745170797935378104170922597e-01 5.01426509658269181635148470377317e-01 1.16786275726386612472396109296824e-01
            2.49286745170932910742322974328999e-01 5.01426509658134178515354051342001e-01 2.49286745170932966253474205586826e-01 1.16786275726409247144310654675792e-01
            5.01426509658134178515354051342001e-01 2.49286745170932910742322974328999e-01 2.49286745170932910742322974328999e-01 1.16786275726342189673623295220750e-01
            6.30890144914937056608295051773894e-02 6.30890144915013384441238031286048e-02 8.73821971017004983650622307322919e-01 5.08449063702000672582137497101940e-02
            6.30890144915035450123852456272289e-02 8.73821971016977450119611603440717e-01 6.30890144915190465013665743754245e-02 5.08449063702193643221605157123122e-02
            8.73821971017004206494505069713341e-01 6.30890144914901251915750890475465e-02 6.30890144915056683139198412391124e-02 5.08449063702010456422542006293952e-02
            6.36502499121370468593283931113547e-01 5.31450498448372762871905194970168e-02 3.10352451033792275936207261111122e-01 8.28510756184012570058072810752492e-02
            6.36502499121420761696299450704828e-01 3.10352451033746756792197629692964e-01 5.31450498448324815115029196022078e-02 8.28510756183929580886982080301095e-02
            5.31450498448278046970116861302813e-02 6.36502499121351594801865303452360e-01 3.10352451033820586623335202602902e-01 8.28510756183844787603476333970320e-02
            5.31450498448204772250491600971145e-02 3.10352451033773957256300946028205e-01 6.36502499121405551640862086060224e-01 8.28510756183718777290181378702982e-02
            3.10352451033798770740901318276883e-01 6.36502499121393894299103521916550e-01 5.31450498448073904711463910643943e-02 8.28510756183713642508692487353983e-02
            3.10352451033773957256300946028205e-01 5.31450498447764152487593491969164e-02 6.36502499121449627494939704774879e-01 8.28510756183196278579217164406145e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 4.2e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 -1.49570044467681212418952441112197e-01
            2.60345966079032931084213942085626e-01 2.60345966079046642338568062768900e-01 4.79308067841920426577217995145475e-01 1.75615257433207633264160563157930e-01
            2.60345966079046586827416831511073e-01 4.79308067841920482088369226403302e-01 2.60345966079032931084213942085626e-01 1.75615257433207549997433716271189e-01
            4.79308067841920371066066763887648e-01 2.60345966079032986595365173343453e-01 2.60345966079046642338568062768900e-01 1.75615257433207577753009331900103e-01
            6.51301029022163108228582473202550e-02 6.51301029022153116221360846793687e-02 8.69739794195568349799430052371463e-01 5.33472356088384724870365971582942e-02
            6.51301029022153116221360846793687e-02 8.69739794195568349799430052371463e-01 6.51301029022163247006460551347118e-02 5.33472356088384794259305010655225e-02
            8.69739794195568460821732514887117e-01 6.51301029022163385784338629491685e-02 6.51301029022152005998336221637146e-02 5.33472356088384794259305010655225e-02
            6.38444188569813220190951597032836e-01 4.86903154253146286389863917065668e-02 3.12865496004872123414486395631684e-01 7.71137608902543736366652638025698e-02
            6.38444188569806114763593996030977e-01 3.12865496004875565105862733616959e-01 4.86903154253183201305432703520637e-02 7.71137608902598831184249661419017e-02
            4.86903154253182438027103273725515e-02 6.38444188569806114763593996030977e-01 3.12865496004875676128165196132613e-01 7.71137608902598831184249661419017e-02
            4.86903154253146147611985838921100e-02 3.12865496004872123414486395631684e-01 6.38444188569813220190951597032836e-01 7.71137608902543458810896481736563e-02
            3.12865496004872178925637626889511e-01 6.38444188569813220190951597032836e-01 4.86903154253145453722595448198263e-02 7.71137608902543736366652638025698e-02
            3.12865496004875565105862733616959e-01 4.86903154253182646193920390942367e-02 6.38444188569806225785896458546631e-01 7.71137608902598969962127739563584e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.8e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 1.44315607677787088869436615823361e-01
            4.59292588292722958609459737999714e-01 4.59292588292723347187518356804503e-01 8.14148234145536386918706739379559e-02 9.50916342672846054417945538261847e-02
            4.59292588292723680254425744351465e-01 8.14148234145537635919609442680667e-02 4.59292588292722570031401119194925e-01 9.50916342672846193195823616406415e-02
            8.14148234145535970585072504945856e-02 4.59292588292722736564854812968406e-01 4.59292588292723624743274513093638e-01 9.50916342672845638084311303828144e-02
            5.05472283170311023625664859082462e-02 5.05472283170309011346432725986233e-02 8.98905543365938086708410992287099e-01 3.24584976231980654182152079556545e-02
            5.05472283170309566457945038564503e-02 8.98905543365937975686108529771445e-01 5.05472283170310676680969663721044e-02 3.24584976231980723571091118628829e-02
            8.98905543365937975686108529771445e-01 5.05472283170310537903091585576476e-02 5.05472283170309705235823116709071e-02 3.24584976231980584793213040484261e-02
            1.70569307751760435021282091838657e-01 1.70569307751759990932072241776041e-01 6.58861384496479463024343203869648e-01 1.03217370534718230756787704649469e-01
            1.70569307751759907665345394889300e-01 6.58861384496479463024343203869648e-01 1.70569307751760601554735785612138e-01 1.03217370534718216878999896835012e-01
            6.58861384496479796091250591416610e-01 1.70569307751760462776857707467570e-01 1.70569307751759741131891701115819e-01 1.03217370534718203001212089020555e-01
            8.39477740995749760477551149051578e-03 7.28492392955404133303431990498211e-01 2.63112829634638334397322978475131e-01 2.72303141744349372355138427792554e-02
            8.39477740995767281184658514803232e-03 2.63112829634637557241205740865553e-01 7.28492392955404799437246765592135e-01 2.72303141744349788688772662226256e-02
            7.28492392955404466370339378045173e-01 8.39477740995770924103958066098130e-03 2.63112829634637834796961897154688e-01 2.72303141744350205022406896659959e-02
            7.28492392955404133303431990498211e-01 2.63112829634638500930776672248612e-01 8.39477740995736576579133725317661e-03 2.72303141744348574382339478461290e-02
            2.63112829634638667464230366022093e-01 8.39477740995763985210054158869752e-03 7.28492392955403689214222140435595e-01 2.72303141744350239716876416196101e-02
            2.63112829634637890308113128412515e-01 7.28492392955404244325734453013865e-01 8.39477740995786536615241857361980e-03 2.72303141744351454023309599961067e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.1e-16
        
        xyw_bar=[
            3.33333333333335257719909350271337e-01 3.33333333333331482961625624739099e-01 3.33333333333333259318465024989564e-01 9.71357962827988224985276133338630e-02
            4.89682519198736176946340492577292e-01 4.89682519198739063526204517984297e-01 2.06349616025247595274549894384108e-02 3.13347002271390229211078803928103e-02
            4.89682519198737009613608961444697e-01 2.06349616025245374828500644071028e-02 4.89682519198738397392389742890373e-01 3.13347002271387731209273397325887e-02
            2.06349616025248878969922117221358e-02 4.89682519198738230858936049116892e-01 4.89682519198736898591306498929043e-01 3.13347002271393143546518444964022e-02
            4.37089591492937745709213004374760e-01 4.37089591492935525263163754061679e-01 1.25820817014126673516472010305733e-01 7.78275410047742782770896496913338e-02
            4.37089591492937745709213004374760e-01 1.25820817014125674315749847664847e-01 4.37089591492936524463885916702566e-01 7.78275410047739035768188387010014e-02
            1.25820817014127700472769788575533e-01 4.37089591492935580774314985319506e-01 4.37089591492936690997339610476047e-01 7.78275410047746946107238841250364e-02
            1.88203535619033524017851277676527e-01 1.88203535619031969705616802457371e-01 6.23592928761934617298834382381756e-01 7.96477389272102626049942841746088e-02
            1.88203535619033940351485512110230e-01 6.23592928761932951964297444646945e-01 1.88203535619033135439792658871738e-01 7.96477389272104707718114013914601e-02
            6.23592928761936171611068857600912e-01 1.88203535619031553371982568023668e-01 1.88203535619032275016948574375419e-01 7.96477389272100266826015513288439e-02
            4.47295133944526565605848134055123e-02 4.47295133944527745217811798283947e-02 9.10540973211094617489891334116692e-01 2.55776756586980312524470804191878e-02
            4.47295133944526010494335821476852e-02 9.10540973211094728512193796632346e-01 4.47295133944526357439031016838271e-02 2.55776756586979271690385218107622e-02
            9.10540973211094395445286409085384e-01 4.47295133944528369718263149934501e-02 4.47295133944527675828872759211663e-02 2.55776756586981388053025909812277e-02
            3.68384120547366744613526634566369e-02 7.41198598784498008384957756788936e-01 2.21962989160765289398113964125514e-01 4.32835393772897300546098620088742e-02
            3.68384120547364316000660267036437e-02 2.21962989160765927776353123590525e-01 7.41198598784497564295747906726319e-01 4.32835393772896051545195916787634e-02
            7.41198598784497897362655294273281e-01 3.68384120547358973052354258470587e-02 2.21962989160766205332109279879660e-01 4.32835393772890292263255673788080e-02
            7.41198598784497564295747906726319e-01 2.21962989160766371865562973653141e-01 3.68384120547360638386891196205397e-02 4.32835393772892443320365885028878e-02
            2.21962989160765400420416426641168e-01 3.68384120547361401665220626000519e-02 7.41198598784498452474167606851552e-01 4.32835393772891610653097416161472e-02
            2.21962989160765011842357807836379e-01 7.41198598784498452474167606851552e-01 3.68384120547364801723233540542424e-02 4.32835393772895010711110330703377e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   27
        % NEG. W.  :    0
        % OUT PTS. :    3
        % M.E.INF. : 4.6e-16
        
        xyw_bar=[
            3.23649481112759096479436493609683e-02 3.23649481112759582202009767115669e-02 9.35270103777448125192961470020236e-01 1.36597310026778939739955376353464e-02
            3.23649481112759235257314571754250e-02 9.35270103777448236215263932535890e-01 3.23649481112758818923680337320548e-02 1.36597310026778714225903499368542e-02
            9.35270103777448236215263932535890e-01 3.23649481112758818923680337320548e-02 3.23649481112758818923680337320548e-02 1.36597310026778488711851622383620e-02
            1.19350912282581586576490906281833e-01 1.19350912282581544943127482838463e-01 7.61298175434836910113745034323074e-01 3.61845405034183567605232667574455e-02
            1.19350912282580892687100515558996e-01 7.61298175434837354202954884385690e-01 1.19350912282581766987732407869771e-01 3.61845405034180930825549182827672e-02
            7.61298175434837798292164734448306e-01 1.19350912282581128609493248404760e-01 1.19350912282581073098342017146933e-01 3.61845405034178571601621854370023e-02
            5.34611048270758115741330129822018e-01 5.34611048270758337785935054853326e-01 -6.92220965415164535272651846753433e-02 9.27006328960678542897011489287706e-04
            5.34611048270757782674422742275055e-01 -6.92220965415166755718701097066514e-02 5.34611048270758892897447367431596e-01 9.27006328960674422928756044370857e-04
            -6.92220965415166755718701097066514e-02 5.34611048270758337785935054853326e-01 5.34611048270758337785935054853326e-01 9.27006328960675940811797524077065e-04
            2.03309900431282941646315975958714e-01 2.03309900431283135935345285361109e-01 5.93380199137433894662763123051263e-01 5.93229773807741889157796322251670e-02
            2.03309900431282941646315975958714e-01 5.93380199137435115908090210723458e-01 2.03309900431281942445593813317828e-01 5.93229773807740778934771697095130e-02
            5.93380199137436115108812373364344e-01 2.03309900431281859178866966431087e-01 2.03309900431282025712320660204568e-01 5.93229773807739807489625150083157e-02
            3.98969302965855809883777283175732e-01 3.98969302965854699660752658019192e-01 2.02061394068289434944318827547249e-01 7.71495349148131615013568307404057e-02
            3.98969302965855809883777283175732e-01 2.02061394068289545966621290062903e-01 3.98969302965854588638450195503538e-01 7.71495349148131476235690229259490e-02
            2.02061394068289684744499368207471e-01 3.98969302965855809883777283175732e-01 3.98969302965854477616147732987884e-01 7.71495349148131337457812151114922e-02
            5.01781383104946895890030589271191e-02 5.93201213428212970057984421146102e-01 3.56620648261292361169694231648464e-01 5.23371119622041205965423671386816e-02
            5.01781383104947451001542901849461e-02 3.56620648261292694236601619195426e-01 5.93201213428212525968774571083486e-01 5.23371119622041483521179827675951e-02
            5.93201213428212748013379496114794e-01 5.01781383104946063222762120403786e-02 3.56620648261292638725450387937599e-01 5.23371119622040303909216163447127e-02
            5.93201213428212970057984421146102e-01 3.56620648261292416680845462906291e-01 5.01781383104946132611701159476070e-02 5.23371119622040165131338085302559e-02
            3.56620648261292527703147925421945e-01 5.01781383104947728557299058138597e-02 5.93201213428212636991077033599140e-01 5.23371119622041691687996944892802e-02
            3.56620648261292805258904081711080e-01 5.93201213428212525968774571083486e-01 5.01781383104946687723213472054340e-02 5.23371119622040650853911358808546e-02
            2.10220165361661680270000118753160e-02 8.07489003159792329000765676028095e-01 1.71488980304041471747211744514061e-01 2.07076596391405770569704714034742e-02
            2.10220165361663137437719939271119e-02 1.71488980304041638280665438287542e-01 8.07489003159792106956160750996787e-01 2.07076596391407088959546456408134e-02
            8.07489003159792106956160750996787e-01 2.10220165361663102743250419734977e-02 1.71488980304041582769514207029715e-01 2.07076596391407123654015975944276e-02
            8.07489003159792329000765676028095e-01 1.71488980304041443991636128885148e-01 2.10220165361662270075981950867572e-02 2.07076596391406742014851261046715e-02
            1.71488980304041638280665438287542e-01 2.10220165361662582326207626692849e-02 8.07489003159792106956160750996787e-01 2.07076596391406880792729339191283e-02
            1.71488980304041638280665438287542e-01 8.07489003159791884911555825965479e-01 2.10220165361665323189299670048058e-02 2.07076596391408164488101562028532e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.22e-16    0    0
    5    7 4.79e-16    0    0
    6   12 2.31e-16    0    0
    7   13 4.16e-16    1    0
    8   16 5.83e-16    0    0
    9   19 3.05e-16    0    0
    11   27 4.58e-16    0    3
    ];




