
function [xyw,pointset_stats]=set_lyness_jespersen_I_C_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% J.N. Lyness, D. Jespersen,
% "Moderate Degree Symmetric Quadrature Rules for the Triangle"
% J. Inst. Maths Applies, 15 (1975), pp.19-32.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
% |   3 |   4 |   1 |   0 | 2.22e-16 |NI|
% |   4 |   6 |   0 |   0 | 2.22e-16 |PI|
% |   5 |   7 |   0 |   0 | 4.79e-16 |PI|
% |   6 |  12 |   0 |   0 | 2.31e-16 |PI|
% |   7 |  13 |   1 |   0 | 4.16e-16 |NI|
% |   8 |  16 |   0 |   0 | 5.83e-16 |PI|
% |   9 |  19 |   0 |   0 | 3.05e-16 |PI|
% |  11 |  27 |   0 |   3 | 4.58e-16 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

switch deg
    
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw=[
            5.00000000000000000000000000000000e-01 5.00000000000000000000000000000000e-01 1.66666666666666657414808128123695e-01
            5.00000000000000000000000000000000e-01 0.00000000000000000000000000000000e+00 1.66666666666666657414808128123695e-01
            0.00000000000000000000000000000000e+00 5.00000000000000000000000000000000e-01 1.66666666666666657414808128123695e-01
            ];
        
    case   3
        
        % ALG. DEG.:    3
        % PTS CARD.:    4
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -2.81250000000000000000000000000000e-01
            2.00000000000000011102230246251565e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            2.00000000000000011102230246251565e-01 5.99999999999999977795539507496869e-01 2.60416666666666685170383743752609e-01
            5.99999999999999977795539507496869e-01 2.00000000000000011102230246251565e-01 2.60416666666666685170383743752609e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.2e-16
        
        xyw=[
            9.15762135097707291597757262024970e-02 9.15762135097707291597757262024970e-02 5.49758718276609284481004635836143e-02
            9.15762135097707291597757262024970e-02 8.16847572980458513924872931966092e-01 5.49758718276609284481004635836143e-02
            8.16847572980458513924872931966092e-01 9.15762135097707291597757262024970e-02 5.49758718276609284481004635836143e-02
            4.45948490915964890213274429697776e-01 4.45948490915964890213274429697776e-01 1.11690794839005777538964991890680e-01
            4.45948490915964890213274429697776e-01 1.08103018168070219573451140604448e-01 1.11690794839005777538964991890680e-01
            1.08103018168070219573451140604448e-01 4.45948490915964890213274429697776e-01 1.11690794839005777538964991890680e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.8e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.12500000000000002775557561562891e-01
            1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 6.29695902724135836425745083033689e-02
            1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 6.29695902724135836425745083033689e-02
            7.97426985353087314223330395179801e-01 1.01286507323456329010546994595643e-01 6.29695902724135836425745083033689e-02
            4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 6.61970763942530820989063045090006e-02
            4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 6.61970763942530820989063045090006e-02
            5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 6.61970763942530820989063045090006e-02
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.3e-16
        
        xyw=[
            2.49286745170932910742322974328999e-01 2.49286745170797935378104170922597e-01 5.83931378631933062361980546484119e-02
            2.49286745170932910742322974328999e-01 5.01426509658134178515354051342001e-01 5.83931378632046235721553273378959e-02
            5.01426509658134178515354051342001e-01 2.49286745170932910742322974328999e-01 5.83931378631710948368116476103751e-02
            6.30890144914937056608295051773894e-02 6.30890144915013384441238031286048e-02 2.54224531851000336291068748550970e-02
            6.30890144915035450123852456272289e-02 8.73821971016977450119611603440717e-01 2.54224531851096821610802578561561e-02
            8.73821971017004206494505069713341e-01 6.30890144914901251915750890475465e-02 2.54224531851005228211271003146976e-02
            6.36502499121370468593283931113547e-01 5.31450498448372762871905194970168e-02 4.14255378092006285029036405376246e-02
            6.36502499121420761696299450704828e-01 3.10352451033746756792197629692964e-01 4.14255378091964790443491040150548e-02
            5.31450498448278046970116861302813e-02 6.36502499121351594801865303452360e-01 4.14255378091922393801738166985160e-02
            5.31450498448204772250491600971145e-02 3.10352451033773957256300946028205e-01 4.14255378091859388645090689351491e-02
            3.10352451033798770740901318276883e-01 6.36502499121393894299103521916550e-01 4.14255378091856821254346243676991e-02
            3.10352451033773957256300946028205e-01 5.31450498447764152487593491969164e-02 4.14255378091598139289608582203073e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   13
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 4.2e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -7.47850222338406062094762205560983e-02
            2.60345966079032931084213942085626e-01 2.60345966079046642338568062768900e-01 8.78076287166038166320802815789648e-02
            2.60345966079046586827416831511073e-01 4.79308067841920482088369226403302e-01 8.78076287166037749987168581355945e-02
            4.79308067841920371066066763887648e-01 2.60345966079032986595365173343453e-01 8.78076287166037888765046659500513e-02
            6.51301029022163108228582473202550e-02 6.51301029022153116221360846793687e-02 2.66736178044192362435182985791471e-02
            6.51301029022153116221360846793687e-02 8.69739794195568349799430052371463e-01 2.66736178044192397129652505327613e-02
            8.69739794195568460821732514887117e-01 6.51301029022163385784338629491685e-02 2.66736178044192397129652505327613e-02
            6.38444188569813220190951597032836e-01 4.86903154253146286389863917065668e-02 3.85568804451271868183326319012849e-02
            6.38444188569806114763593996030977e-01 3.12865496004875565105862733616959e-01 3.85568804451299415592124830709508e-02
            4.86903154253182438027103273725515e-02 6.38444188569806114763593996030977e-01 3.85568804451299415592124830709508e-02
            4.86903154253146147611985838921100e-02 3.12865496004872123414486395631684e-01 3.85568804451271729405448240868282e-02
            3.12865496004872178925637626889511e-01 6.38444188569813220190951597032836e-01 3.85568804451271868183326319012849e-02
            3.12865496004875565105862733616959e-01 4.86903154253182646193920390942367e-02 3.85568804451299484981063869781792e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.8e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 7.21578038388935444347183079116803e-02
            4.59292588292722958609459737999714e-01 4.59292588292723347187518356804503e-01 4.75458171336423027208972769130924e-02
            4.59292588292723680254425744351465e-01 8.14148234145537635919609442680667e-02 4.75458171336423096597911808203207e-02
            8.14148234145535970585072504945856e-02 4.59292588292722736564854812968406e-01 4.75458171336422819042155651914072e-02
            5.05472283170311023625664859082462e-02 5.05472283170309011346432725986233e-02 1.62292488115990327091076039778272e-02
            5.05472283170309566457945038564503e-02 8.98905543365937975686108529771445e-01 1.62292488115990361785545559314414e-02
            8.98905543365937975686108529771445e-01 5.05472283170310537903091585576476e-02 1.62292488115990292396606520242131e-02
            1.70569307751760435021282091838657e-01 1.70569307751759990932072241776041e-01 5.16086852673591153783938523247343e-02
            1.70569307751759907665345394889300e-01 6.58861384496479463024343203869648e-01 5.16086852673591084394999484175059e-02
            6.58861384496479796091250591416610e-01 1.70569307751760462776857707467570e-01 5.16086852673591015006060445102776e-02
            8.39477740995749760477551149051578e-03 7.28492392955404133303431990498211e-01 1.36151570872174686177569213896277e-02
            8.39477740995767281184658514803232e-03 2.63112829634637557241205740865553e-01 1.36151570872174894344386331113128e-02
            7.28492392955404466370339378045173e-01 8.39477740995770924103958066098130e-03 1.36151570872175102511203448329979e-02
            7.28492392955404133303431990498211e-01 2.63112829634638500930776672248612e-01 1.36151570872174287191169739230645e-02
            2.63112829634638667464230366022093e-01 8.39477740995763985210054158869752e-03 1.36151570872175119858438208098050e-02
            2.63112829634637890308113128412515e-01 7.28492392955404244325734453013865e-01 1.36151570872175727011654799980533e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.1e-16
        
        xyw=[
            3.33333333333335257719909350271337e-01 3.33333333333331482961625624739099e-01 4.85678981413994112492638066669315e-02
            4.89682519198736176946340492577292e-01 4.89682519198739063526204517984297e-01 1.56673501135695114605539401964052e-02
            4.89682519198737009613608961444697e-01 2.06349616025245374828500644071028e-02 1.56673501135693865604636698662944e-02
            2.06349616025248878969922117221358e-02 4.89682519198738230858936049116892e-01 1.56673501135696571773259222482011e-02
            4.37089591492937745709213004374760e-01 4.37089591492935525263163754061679e-01 3.89137705023871391385448248456669e-02
            4.37089591492937745709213004374760e-01 1.25820817014125674315749847664847e-01 3.89137705023869517884094193505007e-02
            1.25820817014127700472769788575533e-01 4.37089591492935580774314985319506e-01 3.89137705023873473053619420625182e-02
            1.88203535619033524017851277676527e-01 1.88203535619031969705616802457371e-01 3.98238694636051313024971420873044e-02
            1.88203535619033940351485512110230e-01 6.23592928761932951964297444646945e-01 3.98238694636052353859057006957300e-02
            6.23592928761936171611068857600912e-01 1.88203535619031553371982568023668e-01 3.98238694636050133413007756644220e-02
            4.47295133944526565605848134055123e-02 4.47295133944527745217811798283947e-02 1.27888378293490156262235402095939e-02
            4.47295133944526010494335821476852e-02 9.10540973211094728512193796632346e-01 1.27888378293489635845192609053811e-02
            9.10540973211094395445286409085384e-01 4.47295133944528369718263149934501e-02 1.27888378293490694026512954906138e-02
            3.68384120547366744613526634566369e-02 7.41198598784498008384957756788936e-01 2.16417696886448650273049310044371e-02
            3.68384120547364316000660267036437e-02 2.21962989160765927776353123590525e-01 2.16417696886448025772597958393817e-02
            7.41198598784497897362655294273281e-01 3.68384120547358973052354258470587e-02 2.16417696886445146131627836894040e-02
            7.41198598784497564295747906726319e-01 2.21962989160766371865562973653141e-01 2.16417696886446221660182942514439e-02
            2.21962989160765400420416426641168e-01 3.68384120547361401665220626000519e-02 2.16417696886445805326548708080736e-02
            2.21962989160765011842357807836379e-01 7.41198598784498452474167606851552e-01 2.16417696886447505355555165351689e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   27
        % NEG. W.  :    0
        % OUT PTS. :    3
        % M.E.INF. : 4.6e-16
        
        xyw=[
            3.23649481112759096479436493609683e-02 3.23649481112759582202009767115669e-02 6.82986550133894698699776881767320e-03
            3.23649481112759235257314571754250e-02 9.35270103777448236215263932535890e-01 6.82986550133893571129517496842709e-03
            9.35270103777448236215263932535890e-01 3.23649481112758818923680337320548e-02 6.82986550133892443559258111918098e-03
            1.19350912282581586576490906281833e-01 1.19350912282581544943127482838463e-01 1.80922702517091783802616333787228e-02
            1.19350912282580892687100515558996e-01 7.61298175434837354202954884385690e-01 1.80922702517090465412774591413836e-02
            7.61298175434837798292164734448306e-01 1.19350912282581128609493248404760e-01 1.80922702517089285800810927185012e-02
            5.34611048270758115741330129822018e-01 5.34611048270758337785935054853326e-01 4.63503164480339271448505744643853e-04
            5.34611048270757782674422742275055e-01 -6.92220965415166755718701097066514e-02 4.63503164480337211464378022185429e-04
            -6.92220965415166755718701097066514e-02 5.34611048270758337785935054853326e-01 4.63503164480337970405898762038532e-04
            2.03309900431282941646315975958714e-01 2.03309900431283135935345285361109e-01 2.96614886903870944578898161125835e-02
            2.03309900431282941646315975958714e-01 5.93380199137435115908090210723458e-01 2.96614886903870389467385848547565e-02
            5.93380199137436115108812373364344e-01 2.03309900431281859178866966431087e-01 2.96614886903869903744812575041578e-02
            3.98969302965855809883777283175732e-01 3.98969302965854699660752658019192e-01 3.85747674574065807506784153702029e-02
            3.98969302965855809883777283175732e-01 2.02061394068289545966621290062903e-01 3.85747674574065738117845114629745e-02
            2.02061394068289684744499368207471e-01 3.98969302965855809883777283175732e-01 3.85747674574065668728906075557461e-02
            5.01781383104946895890030589271191e-02 5.93201213428212970057984421146102e-01 2.61685559811020602982711835693408e-02
            5.01781383104947451001542901849461e-02 3.56620648261292694236601619195426e-01 2.61685559811020741760589913837975e-02
            5.93201213428212748013379496114794e-01 5.01781383104946063222762120403786e-02 2.61685559811020151954608081723563e-02
            5.93201213428212970057984421146102e-01 3.56620648261292416680845462906291e-01 2.61685559811020082565669042651280e-02
            3.56620648261292527703147925421945e-01 5.01781383104947728557299058138597e-02 2.61685559811020845843998472446401e-02
            3.56620648261292805258904081711080e-01 5.93201213428212525968774571083486e-01 2.61685559811020325426955679404273e-02
            2.10220165361661680270000118753160e-02 8.07489003159792329000765676028095e-01 1.03538298195702885284852357017371e-02
            2.10220165361663137437719939271119e-02 1.71488980304041638280665438287542e-01 1.03538298195703544479773228204067e-02
            8.07489003159792106956160750996787e-01 2.10220165361663102743250419734977e-02 1.03538298195703561827007987972138e-02
            8.07489003159792329000765676028095e-01 1.71488980304041443991636128885148e-01 1.03538298195703371007425630523358e-02
            1.71488980304041638280665438287542e-01 2.10220165361662582326207626692849e-02 1.03538298195703440396364669595641e-02
            1.71488980304041638280665438287542e-01 8.07489003159791884911555825965479e-01 1.03538298195704082244050781014266e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    2    3 2.78e-16    0    0
    3    4 2.22e-16    1    0
    4    6 2.22e-16    0    0
    5    7 4.79e-16    0    0
    6   12 2.31e-16    0    0
    7   13 4.16e-16    1    0
    8   16 5.83e-16    0    0
    9   19 3.05e-16    0    0
    11   27 4.58e-16    0    3
    ];



