
function [S1,S2,S3,pointset_stats]=set_papanicolopulos_A_I_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicoloupolos
% "New fully symmetric and rotationally symmetric cubature rules on the
% triangle using minimal orthonormal bases".
% JCAM 294 (2016), 39-48.
% ** Using file fullsymmetry.txt from archives.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  15 |  48 |   3 |   0 | 5.41e-16 |NI|
% |  17 |  58 |   0 |   6 | 7.77e-16 |P0|
% |  21 |  87 |   0 |   0 | 5.24e-16 |PI|
% |  22 |  94 |   0 |   6 | 1.63e-15 |P0|
% |  23 | 102 |   0 |   0 | 9.72e-16 |PI|
% |  24 | 112 |   0 |   0 | 1.37e-15 |PI|
% |  25 | 118 |   0 |   6 | 6.75e-16 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  15
        
        % ALG. DEG.:   15
        % PTS CARD.:   48
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 5.4e-16
        
        S1=[
            2.56137198086816945952204349623571e-03 1.77079308752543730827444523612257e-03 3.82312373532611438076145304876263e-02
            1.21987513720667930389174316019307e-02 1.74998973013415944077753039209711e-02 1.49819041618278969707489522988908e-01
            1.64369433694439050219759934634567e-02 1.84230652117384832711088904488861e-02 3.07452940137402042086733899850515e-01
            2.83865520607584145840185385623045e-02 9.12052725923131191176906895634602e-02 2.03858752868167986127545532326621e-01
            3.78398767703287605690398720525991e-02 9.75429348243705002241554780084698e-02 3.63255400132045880301490115016350e-01
            ];
        
        S2=[
            -8.74563258264483139869938099764113e-02 2.95932339143480549470410778667429e-01
            1.18253597339156753254219012205795e-02 1.10411372943988075889798494699789e-01
            1.36333598005909922140643786292458e-02 5.55567775910977765252418691943603e-02
            1.81527498036424886351802854278503e-02 4.90536861361350884358500934467884e-01
            6.01510781202690206215244472787163e-02 2.32611403922656861942286354860698e-01
            1.22180120594431382285982579105621e-01 3.70936506366430440717607552869595e-01
            ];
        
        S3=[];
        
        
    case  17
        
        % ALG. DEG.:   17
        % PTS CARD.:   58
        % NEG. W.  :    0
        % OUT PTS. :    6
        % M.E.INF. : 7.8e-16
        
        S1=[
            5.25996151839412391486294762188436e-04 -1.70992795947950831925155057433585e-02 3.04698462180811813215797201337409e-01
            6.83698051276410232596214555655934e-03 1.56061494788847562181777206546940e-02 7.74677104516807435441450024882215e-02
            7.74029819683285085635260358571941e-03 1.24994725476382708556633005514414e-02 1.83007377411325222738014417700469e-01
            1.73068716861362777159616399558217e-02 2.48937969301927831955456582591069e-02 3.31361033435096818955400976847159e-01
            1.76338484142145555944036772189065e-02 6.09544889837634537577137905373093e-02 1.90839791501631328429766654153354e-01
            3.07203212055171571981393441319597e-02 1.10946632046319576536674844646768e-01 3.03713312450755168470095668453723e-01
            ];
        
        S2=[
            2.91966903457793617096549532163863e-03 1.49390638146109835243668939597228e-02
            9.33381935148833857818218007196265e-03 4.95097032924142199661332597315777e-01
            1.55792100091327861272061383601795e-02 8.01765199090131580605955718965561e-02
            2.58623839950941243615023523716445e-02 4.66726138086600184085028786284965e-01
            2.71575135754933173759528841628708e-02 1.59149357451283113285001036274480e-01
            3.82262065971893591487251740090869e-02 4.09581021965064795420374821333098e-01
            3.86093916834438777296867328914232e-02 2.44597319860783118938840630107734e-01
            ];
        
        S3=[
            4.23495202569146508841946285883751e-02
            ];
        
        
    case  21
        
        % ALG. DEG.:   21
        % PTS CARD.:   87
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.2e-16
        
        S1=[
            3.24321603629715857555759761510217e-03 1.01703755139702384929778489208729e-02 5.61060787404411287493388726943522e-02
            4.44606682456729577351817184194260e-03 7.40148001912942655328153662708246e-03 2.38060908939278198515054896233778e-01
            4.44713701276898583369945328058748e-03 9.48888021003903639472021325218520e-03 1.33714236127292523947929225869302e-01
            7.19283008979440269953231634758595e-03 1.07870852895329272236324413825059e-02 3.60878270361336406235608365022927e-01
            9.68818276967735834970252284392700e-03 4.88864101564119649112605259233533e-02 1.28560007074346699385003489624069e-01
            1.07718672547460047467238197782535e-02 4.07904784349213886396334771688998e-02 2.31929220198316188294995754404226e-01
            1.53764487922741950598481963652375e-02 1.02254765254272128593981960875681e-01 2.13182380246852126726153642266581e-01
            1.54182016250509965060722095131496e-02 5.61951037264934380455194684600428e-02 3.46153638930814133711777458302095e-01
            1.87279940818234902355499116310966e-02 1.93921114022049423386562239102204e-01 3.57417794125976018282386803548434e-01
            1.96189079783958622571482521834696e-02 1.31396937599549262776221780768537e-01 3.09641800485391083253006172526511e-01
            ];
        
        S2=[
            1.53252214157029924106179219478463e-03 1.08306479138961346542213703969537e-02
            2.95964208580089043962302319812352e-03 4.98681169280067615456886187530472e-01
            7.10507195198322675372404333415943e-03 5.32063025937022163192047230495518e-02
            1.24220254501511938316493655065642e-02 4.84368806799071960345060006147833e-01
            1.31538530905486034106033343960007e-02 1.17179324464095319102696635127359e-01
            1.61071199335594099355528641126512e-02 1.86199874531600445548562561270955e-01
            1.95569983274215299096088216401768e-02 2.37705046970502376080247586287442e-01
            2.11471458034111527146681197564249e-02 4.51118096863331430323995618891786e-01
            2.14872496180955330213890874802019e-02 2.98901616618379606382660540475626e-01
            ];
        
        S3=[];
        
        
    case  22
        
        % ALG. DEG.:   22
        % PTS CARD.:   94
        % NEG. W.  :    0
        % OUT PTS. :    6
        % M.E.INF. : 1.6e-15
        
        S1=[
            2.40144871110137460112455589273465e-12 -3.65758201288990725252858737803763e-01 1.21775779289979721453640593153978e-01
            3.39169872594534578535974134183562e-03 1.08660845048417047109534649962370e-02 5.46990068206437349274118275843648e-02
            4.74267636186850947283000223819727e-03 6.98641020724628195731620294850472e-03 3.60846088228242101170195610393421e-01
            5.17198910703703211566573116897416e-03 1.10884495183268746987259589786845e-02 1.31476833810282828229887286397570e-01
            5.62811991121282655103907899274418e-03 9.49913010597105804400097639472733e-03 2.35799841504738955100251018848212e-01
            1.05739505734042844864450927389043e-02 3.70466160480027797974322822938120e-02 3.53558464226123136953106040891726e-01
            1.10866124822367566327141474857854e-02 5.65981092525428552963973061196157e-02 1.32527176274670116518095142055245e-01
            1.21345104216061781821078824350479e-02 4.93070866574566307738436421459483e-02 2.33455411836817949833289276284631e-01
            1.51543784758764645687056926703917e-02 9.16967558296845758336601761584461e-02 3.40216421113571698686683930645813e-01
            1.67986745454602945382127643370040e-02 1.18093857071422919657877059762541e-01 2.28110979662494828268393121106783e-01
            1.85247665396751151623000453128043e-02 1.72252200982416225905069495638600e-01 3.19532176347331609012059061569744e-01
            ];
        
        S2=[
            1.44405557953197977508197347162877e-03 1.04964923185328299487517611510157e-02
            6.26646644955998130543939339531789e-03 4.95533645188751648014147122012218e-01
            7.65174436012302280202268534026189e-03 5.60496151328661179613632725704520e-02
            1.32798477841009326255727884813496e-02 4.76665205864216678932621107378509e-01
            1.51101200038225094712807106134278e-02 1.31716048354042047918710522935726e-01
            1.75918853888713949684685644569981e-02 4.43302304754163378763820446692989e-01
            1.88437083939252646158646342655629e-02 3.94784015644457919602672291148338e-01
            1.98482335994811590063058304167498e-02 2.11601327317755272261479149165098e-01
            2.08671624786287875086276955016729e-02 2.80558889938600508617838613645290e-01
            ];
        
        S3=[
            1.80460650055193419505350505005481e-02
            ];
        
        
    case  23
        
        % ALG. DEG.:   23
        % PTS CARD.:  102
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 9.7e-16
        
        S1=[
            1.39037413890586271716931499042857e-03 2.15375088982479138965953069373427e-03 1.11478221644365146913990827215457e-01
            2.09361317170022979972099363976668e-03 7.97567048343379887687110141314406e-03 4.59987619119273868917296965719288e-02
            2.26272789116058496358685481197881e-03 2.22521306870228970792302547465624e-03 2.99917045006213633939751161960885e-01
            5.09887607853182385497792239448245e-03 1.05679902342133303499993601803908e-02 1.94506172551481726351596535096178e-01
            5.80279248634163555969900372133452e-03 2.63901579600523857049854115075505e-02 1.04876013751831961839933171631856e-01
            6.99047412016323178873822286050199e-03 1.37266147889163348666530239938766e-02 3.93592741558122238831884942555916e-01
            1.01054474126854951926413050955489e-02 3.29316707171191241920737979853584e-02 2.77450101542849103530841148312902e-01
            1.09406868201110413912902075139755e-02 5.64583692867880043708694870474574e-02 1.70419309607223817826238132511207e-01
            1.26977474672001437033808102228249e-02 2.49058699506046365979017309655319e-01 2.80484645940626220461666662231437e-01
            1.49369052147359324816955350456738e-02 6.71002288455987278004144513943174e-02 3.59406843852176305365020425597322e-01
            1.62459448889631478951667276078297e-02 1.00958484047456359400385395019839e-01 2.39678973324078781192980613923282e-01
            2.04089649211380702586993152181094e-02 1.52081403116914759543476520775585e-01 3.16605382389148204413942266910453e-01
            ];
        
        S2=[
            1.02338493393064832413796860777211e-03 8.84309098564000847786381598325534e-03
            2.34953285611607439603565339325542e-03 4.99042317995364748117737008215045e-01
            4.42272294831746494436774952419000e-03 4.19184946319212034526735521922092e-02
            9.35939493458907111056443994812071e-03 8.38439594007418936838504919251136e-02
            1.12233049079555162463872619582617e-02 3.51566022256878052409945212275488e-01
            1.14553938607186642228974449153611e-02 4.81422500082097581941553698925418e-01
            1.48515281902704306127294131556482e-02 1.36036839176656848549029632522434e-01
            1.87339909775230337163343108386471e-02 4.45886210232929069974261437891982e-01
            2.00954488981750084564126268560358e-02 1.98337919690773967218433426751290e-01
            2.18695216024630233186965000413693e-02 3.97648733525920727860381020946079e-01
            ];
        
        S3=[];
        
        
    case  24
        
        % ALG. DEG.:   24
        % PTS CARD.:  112
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.4e-15
        
        S1=[
            1.74618458266172162270113421556061e-03 1.28915765322182144549112425835347e-03 3.89300321173704000354831578079029e-01
            1.83857160374278709967510447853556e-03 8.04615544134750990123983171997679e-03 3.99455189985108982675399147410644e-02
            1.99893663336212900477617537831065e-03 3.97463904079080419112779409829272e-03 1.77567553518447190930018564358761e-01
            2.06369617133590798133124799562665e-03 5.65339683877998013666887899830726e-03 9.73043731633908004496902321989182e-02
            2.29539508715841588867845324273276e-03 3.65416463470007168989894807964447e-02 4.73791364695558270270225875719916e-02
            4.57952328890823181367641936390100e-03 8.47203125278924405738845138102988e-03 2.76542334906226316970645484616398e-01
            5.29323009909540408840511460653033e-03 3.18687855584848661605334996238525e-02 1.01860048008413445197462010582967e-01
            5.57874699599088166163118884810501e-03 2.50744857569593221358061896353320e-02 1.79900411429897849613368521204393e-01
            8.61933948725664145218416933857952e-03 2.49546492072369834047673720078819e-02 3.74761488291451505538987021282082e-01
            9.99235399224706992427069707218834e-03 7.18069274899266751788218243746087e-02 1.62853713656418902511191504345334e-01
            1.03056162076813079969683784042900e-02 4.64953683252256055880025087390095e-02 2.62999946925326910651676826091716e-01
            1.46045461262502476035285425837174e-02 7.94456583289277762371938251817483e-02 3.53874622686032425100677301088581e-01
            1.49985006762504632926713554752496e-02 1.12104968398914525695708732655476e-01 2.40452720011096882091194970598735e-01
            1.92307831174366797299946085786360e-02 1.62887044320893126236882153534680e-01 3.16328836361366161344932379506645e-01
            ];
        
        S2=[
            7.67377461115814228295728405271348e-04 7.64481587209140354965963837230447e-03
            5.52357844475169761783162059032293e-03 4.95123266934894168400660419138148e-01
            8.38499530275631059506036280026819e-03 8.53357147077405536750305259374727e-02
            1.22173801780023523477769487044498e-02 4.75404357579430003610809762903955e-01
            1.30703906056117823836215663391158e-02 1.43613126002549662540985764280776e-01
            1.78812277584295790944235449160260e-02 4.40001375500573721488706269155955e-01
            1.82217441390973115822315975265155e-02 2.04386847871303928281250250620360e-01
            2.16414972175676158239188140441911e-02 3.91555207032681984458122315118089e-01
            2.16883129269226024304906275119720e-02 2.69360691849568234523815135617042e-01
            ];
        
        S3=[
            2.29379434809674903616993901778187e-02
            ];
        
        
    case  25
        
        % ALG. DEG.:   25
        % PTS CARD.:  118
        % NEG. W.  :    0
        % OUT PTS. :    6
        % M.E.INF. : 6.7e-16
        
        S1=[
            1.00584196363497492369976082926541e-03 -1.75486429018026650252654041750588e-04 2.75059108819840636428466495999601e-01
            1.77683419519510609439760795424945e-03 7.62723542435699269209647965794829e-03 4.06756516673179857601638786945841e-02
            2.52637680466070730506134012216535e-03 7.17445981822133118516182648249924e-03 9.80731978180811037049124934128486e-02
            2.89032133442563947400838486601060e-03 6.36745417209535428254563171890368e-03 1.77108966725932348573735453101108e-01
            4.31881775098157203590654162894680e-03 7.48751575325660133353178338211364e-03 3.81611685159125635369292695031618e-01
            5.62803724289998117541466982061138e-03 3.74639348798537011320242129386315e-02 9.58146591402575242835126800855505e-02
            6.23803510843159124410473026500767e-03 1.81035322019235805912629189151630e-02 2.70608545540926448413898697253899e-01
            6.52427065541083799765642581292013e-03 3.34959101480053617061471982196963e-02 1.73144453351435828603044342344219e-01
            9.57567429813979340003093909672316e-03 3.92067119187980567263096531860356e-02 3.69875713683459339531367504605441e-01
            9.67172537810269059010970238432492e-03 8.20162616970389335424584942302317e-02 1.64905597423194411055291652701271e-01
            1.05255356442389737259279769432396e-02 6.05057836750334115949456759153691e-02 2.59760411703463867105767803877825e-01
            1.37603313941475381698698043919649e-02 1.25482119096221894638532035060052e-01 2.41438155348012661871592854367918e-01
            1.38607452446401283041588214928197e-02 9.53671594914007325627380851074122e-02 3.48637419542872584177217731848941e-01
            1.70428089357299757111707805279366e-02 1.74659411566860711673143669031560e-01 3.16050027630206786799504925511428e-01
            ];
        
        S2=[
            7.97849780090490682399329003260391e-04 7.80221999790021124299155275139128e-03
            1.65405575591004460646316065464134e-03 4.99200051265863864458083298814017e-01
            3.94830678155925519912106125275386e-03 3.97459760601686362679885178295081e-02
            7.30593044195647009497740498318308e-03 4.89484252465692326605761763858027e-01
            8.12785587964132659466454100538613e-03 9.06944179019588681001096119871363e-02
            1.19703716855756939207999778318481e-02 1.51224281357815043547176969696011e-01
            1.22997656262038082553011975051049e-02 4.67213065208418099061304928909522e-01
            1.61127191760525034780471287376713e-02 2.11913294950495378898835951986257e-01
            1.62328697015011007287466071602466e-02 4.32762489787939796936910852309666e-01
            1.87988810381621539169483270370620e-02 2.73760447593867972670977906091139e-01
            1.88173003773445743358472270756465e-02 3.87365851530470428620844813849544e-01
            ];
        
        S3=[
            1.97301455641706938171076046728558e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    15   48 5.41e-16    3    0
    17   58 7.77e-16    0    6
    21   87 5.24e-16    0    0
    22   94 1.63e-15    0    6
    23  102 9.72e-16    0    0
    24  112 1.37e-15    0    0
    25  118 6.75e-16    0    6
    ];




