
function [S1,S2,S3,pointset_stats]=set_papanicolopulos_II_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicoloupolos
% "New fully symmetric and rotationally symmetric cubature rules on the
% triangle using minimal orthonormal bases".
% JCAM 294 (2016), 39-48.
% ** Using file fullsymmetry.txt from archives.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  22 |  96 |   0 |   0 | 6.73e-16 |PI|
% |  25 | 120 |   6 |   0 | 7.55e-15 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  22
        
        % ALG. DEG.:   22
        % PTS CARD.:   96
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.7e-16
        
        S1=[
            1.82862802731120917786034052454625e-03 7.73958468860307807757337172915868e-03 3.91001678273283775899571423906309e-02
            1.88044970396283829192074499303544e-03 5.77064130218403622228640070801475e-04 2.99563010316006073097128137305845e-01
            3.70410864001110163440388944877668e-03 9.79577185352314104560544905098141e-03 9.91675808522524682153687081154203e-02
            4.66834037183480599075835471012397e-03 9.18868020649896491414132526642788e-03 1.86190681552805714638054723764071e-01
            7.21134117192958560421667257855916e-03 1.34670875684018177820266970456942e-02 4.02938891855100456140803544258233e-01
            7.96743335988734334429661743115503e-03 5.06263124673368980488419310859172e-02 1.03588085409291874583459502900951e-01
            9.03580036943713547914480699319029e-03 4.83881177618376498439367594528449e-02 1.80823006888328891017536648178066e-01
            9.48064111155901521887923166787004e-03 2.74914358532603458895593462329998e-02 2.81943415079491888075580163786071e-01
            1.56173701283532084804761552732089e-02 6.71339744477043864900878133994411e-02 3.50712853397991353165963346327771e-01
            1.62453191810569830266786084393971e-02 9.67043036168603459268311439700483e-02 2.30176404403601320147743081179215e-01
            2.17848082235315120003260602743467e-02 1.51930454826702282522532527764270e-01 3.11593235863486472947414540612954e-01
            ];
        
        S2=[
            6.97145696250740256293132457443562e-04 7.22823551590805277872187062371268e-03
            1.73365376198036263456769834334636e-03 4.99714916562231881158595570013858e-01
            4.66131304304557344403425744872038e-03 4.19525272728040882208588868707011e-02
            1.15845767655995655898149010454290e-02 3.14132191520500925197012520584394e-01
            1.18789740330219103364717270210349e-02 4.80013651617116565706311348549207e-01
            1.53388036556666995657849383860594e-02 1.23087454230161152946010361119988e-01
            1.97163769402723364210228140791514e-02 4.45719630439115332976030003919732e-01
            2.05721514917347539364023134567105e-02 1.89862412183893686234981146299106e-01
            2.38406602781370373367320070201458e-02 2.60339233381755796870038466295227e-01
            2.44611970898748719294157893955344e-02 3.96366847671625999183220301347319e-01
            ];
        
        S3=[];
        
        
    case  25
        
        % ALG. DEG.:   25
        % PTS CARD.:  120
        % NEG. W.  :    6
        % OUT PTS. :    0
        % M.E.INF. : 7.5e-15
        
        S1=[
            1.13714181496524626216459985528218e-03 3.03302471090682499409163508374832e-04 1.78730929732423882150271765567595e-01
            1.71355194199545777210269559276412e-03 7.28506607201764421616330125175409e-03 4.10919626179091224127404302635114e-02
            1.96815375779926977906075791224794e-03 2.09819055278945201109541685013937e-03 3.80405002447553652888956321476144e-01
            2.89806198086506230232606284857866e-03 8.24935540216329907248216102289007e-03 9.84515981635840919938829074453679e-02
            4.77607271269496220372774430984464e-03 9.19844896889114756188821075966189e-03 2.71278993067566198682527556229616e-01
            6.48989797457113787998439491389036e-03 2.27894351251585400297550165760185e-02 1.73042709639871727933524425679934e-01
            6.84104347762794478410297571713272e-03 4.38684606504693083706136746968696e-02 9.17541328991964832972882959438721e-02
            8.26473228086363476130316030321410e-03 2.48398299166222302769568841540604e-02 3.76811651708434280916293346308521e-01
            1.02243648962692494641668616850438e-02 4.63554300688644033145990874800191e-02 2.65561584563092811794859926521895e-01
            1.02441540629610843698982236560369e-02 7.19441719771225091095701031917997e-02 1.70539121421737188688538822134433e-01
            1.36719002036592915394486169589072e-02 7.71705874722226348172426924065803e-02 3.55127335899842411226501326382277e-01
            1.50578629356948115458614267936355e-02 1.14037668606329273268684687536734e-01 2.44672816769111428625294024641335e-01
            1.58064259318789479547007204018882e-02 1.53156702364264596383236494148150e-01 3.28189451188987735275048862604308e-01
            1.29782369074059333868831345171202e+00 2.39691112819588936222459096825332e-01 2.45045069544505583758464695165458e-01
            ];
        
        S2=[
            -2.69549612236610292015370760054793e+00 2.41705564997226424184262327798933e-01
            -1.80530872827314322302816318455143e-03 6.68411454103012420135954130273603e-02
            8.18660001776087115597790866416972e-04 7.91213740209865609709360967372049e-03
            3.87240802246698566368987570740501e-03 3.86825002238830387146784062224469e-02
            5.19562728909426195522680558269712e-03 4.95717425830097813133079398539849e-01
            8.27582560362962772748662843014245e-03 9.66934516840111946134328491098131e-02
            1.14946929251026185719863903500482e-02 4.76796052923181057359158785402542e-01
            1.42897587003530078531010616416097e-02 1.51363116253387219867221347158193e-01
            1.55950327338982234343101040963120e-02 4.44551436843102165674679326912155e-01
            1.70629598758338420216862374445554e-02 3.61911501476409047661775275628315e-01
            1.71270723975188964016691528513547e-02 4.01885652208385124595224624499679e-01
            1.43068617453156993191143442345492e-01 2.29157170026697831755058132330305e-01
            ];
        
        S3=[];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    22   96 6.73e-16    0    0
    25  120 7.55e-15    6    0
    ];




