
function [xyw_bar,pointset_stats]=set_papanicolopulos_A_III_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicoloupolos
% "New fully symmetric and rotationally symmetric cubature rules on the
% triangle using minimal orthonormal bases".
% JCAM 294 (2016), 39-48.
% ** Using file rotationalsymmetry.txt from archives.
%--------------------------------------------------------------------
% REMARK:
% Rules are not appropriate for cubature when deg = 16.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  16 |  52 |   0 |   0 | 2.31e-06 |PI|
% |  18 |  66 |   0 |   0 | 6.11e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   52
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.3e-06
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 3.66324038067270749130521778624825e-02
            1.59610117131068415807781946114119e-02 1.68831254325296324647620593850661e-02 9.67155862854363501668331082328223e-01 3.54430487704302009735468637074973e-03
            1.68831254325296324647620593850661e-02 9.67155862854363501668331082328223e-01 1.59610117131068415807781946114119e-02 3.54430487704302009735468637074973e-03
            9.67155862854363501668331082328223e-01 1.59610117131068415807781946114119e-02 1.68831254325296324647620593850661e-02 3.54430487704302009735468637074973e-03
            3.82193084171853891123360469350700e-03 9.93496727440693339072907974696136e-02 8.96828396414212081211303484451491e-01 4.01758833704091156135973506025039e-03
            9.93496727440693339072907974696136e-02 8.96828396414212081211303484451491e-01 3.82193084171853891123360469350700e-03 4.01758833704091156135973506025039e-03
            8.96828396414212081211303484451491e-01 3.82193084171853891123360469350700e-03 9.93496727440693339072907974696136e-02 4.01758833704091156135973506025039e-03
            9.26217308054885085644158948525728e-02 4.71775047811925137691835274722507e-03 9.02660518716392190619046687061200e-01 4.19072009129610022898360099929960e-03
            4.71775047811925137691835274722507e-03 9.02660518716392190619046687061200e-01 9.26217308054885085644158948525728e-02 4.19072009129610022898360099929960e-03
            9.02660518716392190619046687061200e-01 9.26217308054885085644158948525728e-02 4.71775047811925137691835274722507e-03 4.19072009129610022898360099929960e-03
            9.80984970538446680865529714310469e-03 2.46738918291675518590366777971212e-01 7.43451232002940054499617872352246e-01 8.56278268515921550663172467920958e-03
            2.46738918291675518590366777971212e-01 7.43451232002940054499617872352246e-01 9.80984970538446680865529714310469e-03 8.56278268515921550663172467920958e-03
            7.43451232002940054499617872352246e-01 9.80984970538446680865529714310469e-03 2.46738918291675518590366777971212e-01 8.56278268515921550663172467920958e-03
            2.34453555493239956808437796098588e-01 1.25212213335406091080370671875244e-02 7.53025223173219404593226045108167e-01 9.97900781704974711161515443791359e-03
            1.25212213335406091080370671875244e-02 7.53025223173219404593226045108167e-01 2.34453555493239956808437796098588e-01 9.97900781704974711161515443791359e-03
            7.53025223173219404593226045108167e-01 2.34453555493239956808437796098588e-01 1.25212213335406091080370671875244e-02 9.97900781704974711161515443791359e-03
            5.16573913793264283267347991568386e-02 5.77757850135847475514516702332912e-02 8.90566823607088831060707434517099e-01 1.02125635397787746516673479391102e-02
            5.77757850135847475514516702332912e-02 8.90566823607088831060707434517099e-01 5.16573913793264283267347991568386e-02 1.02125635397787746516673479391102e-02
            8.90566823607088831060707434517099e-01 5.16573913793264283267347991568386e-02 5.77757850135847475514516702332912e-02 1.02125635397787746516673479391102e-02
            1.59791124093020334151482586548809e-02 4.13442936726308274408836496149888e-01 5.70577950864389671359333533473546e-01 1.40814747106397901432739416804907e-02
            4.13442936726308274408836496149888e-01 5.70577950864389671359333533473546e-01 1.59791124093020334151482586548809e-02 1.40814747106397901432739416804907e-02
            5.70577950864389671359333533473546e-01 1.59791124093020334151482586548809e-02 4.13442936726308274408836496149888e-01 1.40814747106397901432739416804907e-02
            3.96856475222830962223952155909501e-01 1.67626402347665279246591296669067e-02 5.86380884542402558423646041774191e-01 1.46299246556413908848526261863299e-02
            1.67626402347665279246591296669067e-02 5.86380884542402558423646041774191e-01 3.96856475222830962223952155909501e-01 1.46299246556413908848526261863299e-02
            5.86380884542402558423646041774191e-01 3.96856475222830962223952155909501e-01 1.67626402347665279246591296669067e-02 1.46299246556413908848526261863299e-02
            1.40368863416206357541682336886879e-01 5.04000292199502930579058102011913e-02 8.09231107363843404911563084169757e-01 1.60564662684797333780384320789381e-02
            5.04000292199502930579058102011913e-02 8.09231107363843404911563084169757e-01 1.40368863416206357541682336886879e-01 1.60564662684797333780384320789381e-02
            8.09231107363843404911563084169757e-01 1.40368863416206357541682336886879e-01 5.04000292199502930579058102011913e-02 1.60564662684797333780384320789381e-02
            4.86460646955515496614452786161564e-02 1.53602469291318488586739476886578e-01 7.97751466013129961751815244497266e-01 1.70243419710226287500098862892628e-02
            1.53602469291318488586739476886578e-01 7.97751466013129961751815244497266e-01 4.86460646955515496614452786161564e-02 1.70243419710226287500098862892628e-02
            7.97751466013129961751815244497266e-01 4.86460646955515496614452786161564e-02 1.53602469291318488586739476886578e-01 1.70243419710226287500098862892628e-02
            6.75456989279453468011382710756152e-02 2.93562718665030752962508131531649e-01 6.38891582407023816969626750505995e-01 2.49557676391715076158472896850071e-02
            2.93562718665030752962508131531649e-01 6.38891582407023816969626750505995e-01 6.75456989279453468011382710756152e-02 2.49557676391715076158472896850071e-02
            6.38891582407023816969626750505995e-01 6.75456989279453468011382710756152e-02 2.93562718665030752962508131531649e-01 2.49557676391715076158472896850071e-02
            1.60476192471738526856839257561660e-01 2.76119726602889581368316385123762e-01 5.63404080925371975041571204201318e-01 2.81991167170093995353319371588441e-02
            2.76119726602889581368316385123762e-01 5.63404080925371975041571204201318e-01 1.60476192471738526856839257561660e-01 2.81991167170093995353319371588441e-02
            5.63404080925371975041571204201318e-01 1.60476192471738526856839257561660e-01 2.76119726602889581368316385123762e-01 2.81991167170093995353319371588441e-02
            2.80462713730914248166925517580239e-01 7.72798343620785255225769105891231e-02 6.42257451907007226310497571830638e-01 2.82705789860670901603167948223927e-02
            7.72798343620785255225769105891231e-02 6.42257451907007226310497571830638e-01 2.80462713730914248166925517580239e-01 2.82705789860670901603167948223927e-02
            6.42257451907007226310497571830638e-01 2.80462713730914248166925517580239e-01 7.72798343620785255225769105891231e-02 2.82705789860670901603167948223927e-02
            1.47356925256593940254390417976538e-01 1.48012388839049768840538945369190e-01 7.04630685904356290905070636654273e-01 2.92261109170241992205596659459843e-02
            1.48012388839049768840538945369190e-01 7.04630685904356290905070636654273e-01 1.47356925256593940254390417976538e-01 2.92261109170241992205596659459843e-02
            7.04630685904356290905070636654273e-01 1.47356925256593940254390417976538e-01 1.48012388839049768840538945369190e-01 2.92261109170241992205596659459843e-02
            4.24740746647568945260076134218252e-01 2.08953636106141954487114276162174e-01 3.66305617246289072497233973990660e-01 3.40069090029891038517995127676841e-02
            2.08953636106141954487114276162174e-01 3.66305617246289072497233973990660e-01 4.24740746647568945260076134218252e-01 3.40069090029891038517995127676841e-02
            3.66305617246289072497233973990660e-01 4.24740746647568945260076134218252e-01 2.08953636106141954487114276162174e-01 3.40069090029891038517995127676841e-02
            4.51724383070898127812142774928361e-01 8.70333245801910154737512925748888e-02 4.61242292348910842836318124682293e-01 3.42356238000260451603828926181450e-02
            8.70333245801910154737512925748888e-02 4.61242292348910842836318124682293e-01 4.51724383070898127812142774928361e-01 3.42356238000260451603828926181450e-02
            4.61242292348910842836318124682293e-01 4.51724383070898127812142774928361e-01 8.70333245801910154737512925748888e-02 3.42356238000260451603828926181450e-02
            2.88318735917362067855407303795801e-01 1.90229119570889448898043383451295e-01 5.21452144511748594268851775268558e-01 3.99292500489855720080534240423731e-02
            1.90229119570889448898043383451295e-01 5.21452144511748594268851775268558e-01 2.88318735917362067855407303795801e-01 3.99292500489855720080534240423731e-02
            5.21452144511748594268851775268558e-01 2.88318735917362067855407303795801e-01 1.90229119570889448898043383451295e-01 3.99292500489855720080534240423731e-02
            ];
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   66
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.1e-16
        
        xyw_bar=[
            3.69780964055097839671137904815623e-03 7.43579235081241601834634025181003e-02 9.21944266851324800704503559245495e-01 2.63779112688252706173108741438682e-03
            7.43579235081241601834634025181003e-02 9.21944266851324800704503559245495e-01 3.69780964055097839671137904815623e-03 2.63779112688252706173108741438682e-03
            9.21944266851324800704503559245495e-01 3.69780964055097839671137904815623e-03 7.43579235081241601834634025181003e-02 2.63779112688252706173108741438682e-03
            1.49143992279988854554595434365183e-02 1.36909130733626482889775388684939e-02 9.71394687698638459316669013787759e-01 2.67490665099675119578681581344881e-03
            1.36909130733626482889775388684939e-02 9.71394687698638459316669013787759e-01 1.49143992279988854554595434365183e-02 2.67490665099675119578681581344881e-03
            9.71394687698638459316669013787759e-01 1.49143992279988854554595434365183e-02 1.36909130733626482889775388684939e-02 2.67490665099675119578681581344881e-03
            1.69739996219302907189130369403074e-03 2.08913690615461083988080304152390e-01 7.89388909422345963484701769630192e-01 3.19303827376352100664291810971918e-03
            2.08913690615461083988080304152390e-01 7.89388909422345963484701769630192e-01 1.69739996219302907189130369403074e-03 3.19303827376352100664291810971918e-03
            7.89388909422345963484701769630192e-01 1.69739996219302907189130369403074e-03 2.08913690615461083988080304152390e-01 3.19303827376352100664291810971918e-03
            8.06620839466252737004481332405703e-02 8.24353269029142778079322084749947e-03 9.11094383363083348825739449239336e-01 4.17069843761026792794410766873625e-03
            8.24353269029142778079322084749947e-03 9.11094383363083348825739449239336e-01 8.06620839466252737004481332405703e-02 4.17069843761026792794410766873625e-03
            9.11094383363083348825739449239336e-01 8.06620839466252737004481332405703e-02 8.24353269029142778079322084749947e-03 4.17069843761026792794410766873625e-03
            1.98747901402310800378359090245795e-01 6.97659509618316596435416698795962e-03 7.94275503501505997228093747253297e-01 5.25920323767891089578041530216979e-03
            6.97659509618316596435416698795962e-03 7.94275503501505997228093747253297e-01 1.98747901402310800378359090245795e-01 5.25920323767891089578041530216979e-03
            7.94275503501505997228093747253297e-01 1.98747901402310800378359090245795e-01 6.97659509618316596435416698795962e-03 5.25920323767891089578041530216979e-03
            3.46702719147276405831092915832414e-01 9.05977135347985074176335729134735e-03 6.44237509499243632404841264360584e-01 7.18844500798738583052793771344113e-03
            9.05977135347985074176335729134735e-03 6.44237509499243632404841264360584e-01 3.46702719147276405831092915832414e-01 7.18844500798738583052793771344113e-03
            6.44237509499243632404841264360584e-01 3.46702719147276405831092915832414e-01 9.05977135347985074176335729134735e-03 7.18844500798738583052793771344113e-03
            4.86346333871042757479585816327017e-02 5.57910529717466976973305747833365e-02 8.95574313641149033493604747491190e-01 8.95878269206539998292804227730812e-03
            5.57910529717466976973305747833365e-02 8.95574313641149033493604747491190e-01 4.86346333871042757479585816327017e-02 8.95878269206539998292804227730812e-03
            8.95574313641149033493604747491190e-01 4.86346333871042757479585816327017e-02 5.57910529717466976973305747833365e-02 8.95878269206539998292804227730812e-03
            1.28318629849446304985738365189718e-02 3.44692548477970428510985811954015e-01 6.42475588537084973950186395086348e-01 9.24872538712559477680485997552751e-03
            3.44692548477970428510985811954015e-01 6.42475588537084973950186395086348e-01 1.28318629849446304985738365189718e-02 9.24872538712559477680485997552751e-03
            6.42475588537084973950186395086348e-01 1.28318629849446304985738365189718e-02 3.44692548477970428510985811954015e-01 9.24872538712559477680485997552751e-03
            2.93595389942205159394816860185529e-02 1.39964110318391732334930566139519e-01 8.30676350687387765603375555656385e-01 1.00742462484914099829502731608954e-02
            1.39964110318391732334930566139519e-01 8.30676350687387765603375555656385e-01 2.93595389942205159394816860185529e-02 1.00742462484914099829502731608954e-02
            8.30676350687387765603375555656385e-01 2.93595389942205159394816860185529e-02 1.39964110318391732334930566139519e-01 1.00742462484914099829502731608954e-02
            4.90788394693759288944789886954823e-01 4.95822517789664629628276770745288e-01 1.33890875165761369380845735577168e-02 1.02300748864493692286137260794021e-02
            4.95822517789664629628276770745288e-01 1.33890875165761369380845735577168e-02 4.90788394693759288944789886954823e-01 1.02300748864493692286137260794021e-02
            1.33890875165761369380845735577168e-02 4.90788394693759288944789886954823e-01 4.95822517789664629628276770745288e-01 1.02300748864493692286137260794021e-02
            1.38618784059788779927657742518932e-01 4.47076793855018736478790231103631e-02 8.16673536554709311729993714834563e-01 1.27372161873653359093205850172126e-02
            4.47076793855018736478790231103631e-02 8.16673536554709311729993714834563e-01 1.38618784059788779927657742518932e-01 1.27372161873653359093205850172126e-02
            8.16673536554709311729993714834563e-01 1.38618784059788779927657742518932e-01 4.47076793855018736478790231103631e-02 1.27372161873653359093205850172126e-02
            2.63897606352200997381629576921114e-01 4.36720952517550692340009277359059e-02 6.92430298396043975017732918786351e-01 1.41269815514411794382665377156627e-02
            4.36720952517550692340009277359059e-02 6.92430298396043975017732918786351e-01 2.63897606352200997381629576921114e-01 1.41269815514411794382665377156627e-02
            6.92430298396043975017732918786351e-01 2.63897606352200997381629576921114e-01 4.36720952517550692340009277359059e-02 1.41269815514411794382665377156627e-02
            4.55911744930610901560541492472112e-02 2.45218573506195719469147320523916e-01 7.09190252000743259763737569301156e-01 1.53327744155534861220102627044071e-02
            2.45218573506195719469147320523916e-01 7.09190252000743259763737569301156e-01 4.55911744930610901560541492472112e-02 1.53327744155534861220102627044071e-02
            7.09190252000743259763737569301156e-01 4.55911744930610901560541492472112e-02 2.45218573506195719469147320523916e-01 1.53327744155534861220102627044071e-02
            3.94010358537068061668406926401076e-01 5.92769337816446834077410699137545e-02 5.46712707681287324312791042757453e-01 1.91509883044683817954201288102922e-02
            5.92769337816446834077410699137545e-02 5.46712707681287324312791042757453e-01 3.94010358537068061668406926401076e-01 1.91509883044683817954201288102922e-02
            5.46712707681287324312791042757453e-01 3.94010358537068061668406926401076e-01 5.92769337816446834077410699137545e-02 1.91509883044683817954201288102922e-02
            1.06867206940964756811673908032390e-01 1.28325526947980300684903909314016e-01 7.64807266111054984136785606096964e-01 1.95813758511073771062527271169529e-02
            1.28325526947980300684903909314016e-01 7.64807266111054984136785606096964e-01 1.06867206940964756811673908032390e-01 1.95813758511073771062527271169529e-02
            7.64807266111054984136785606096964e-01 1.06867206940964756811673908032390e-01 1.28325526947980300684903909314016e-01 1.95813758511073771062527271169529e-02
            2.20575279425483411488428941993334e-01 1.13275821301684689879074596774444e-01 6.66148899272831940265859884675592e-01 2.25192148727883269254679277082687e-02
            1.13275821301684689879074596774444e-01 6.66148899272831940265859884675592e-01 2.20575279425483411488428941993334e-01 2.25192148727883269254679277082687e-02
            6.66148899272831940265859884675592e-01 2.20575279425483411488428941993334e-01 1.13275821301684689879074596774444e-01 2.25192148727883269254679277082687e-02
            1.23653835041298731933778753955266e-01 2.42720437216092432830549796562991e-01 6.33625727742608724213368986966088e-01 2.37440880536187205740450423263610e-02
            2.42720437216092432830549796562991e-01 6.33625727742608724213368986966088e-01 1.23653835041298731933778753955266e-01 2.37440880536187205740450423263610e-02
            6.33625727742608724213368986966088e-01 1.23653835041298731933778753955266e-01 2.42720437216092432830549796562991e-01 2.37440880536187205740450423263610e-02
            7.13348794100979594068334677103849e-02 3.87908478942486534268851983142667e-01 5.40756641647415436935375510074664e-01 2.45125802347510302059419018405606e-02
            3.87908478942486534268851983142667e-01 5.40756641647415436935375510074664e-01 7.13348794100979594068334677103849e-02 2.45125802347510302059419018405606e-02
            5.40756641647415436935375510074664e-01 7.13348794100979594068334677103849e-02 3.87908478942486534268851983142667e-01 2.45125802347510302059419018405606e-02
            2.24126910324971617693989855979453e-01 2.13289800009618973897218552338018e-01 5.62583289665409380653215976053616e-01 2.46814736022687927774477145703713e-02
            2.13289800009618973897218552338018e-01 5.62583289665409380653215976053616e-01 2.24126910324971617693989855979453e-01 2.46814736022687927774477145703713e-02
            5.62583289665409380653215976053616e-01 2.24126910324971617693989855979453e-01 2.13289800009618973897218552338018e-01 2.46814736022687927774477145703713e-02
            3.51619049955642692939505877802731e-01 1.37937509976456512683640198702051e-01 5.10443440067900877643580770381959e-01 2.69676629199526833591260555067493e-02
            1.37937509976456512683640198702051e-01 5.10443440067900877643580770381959e-01 3.51619049955642692939505877802731e-01 2.69676629199526833591260555067493e-02
            5.10443440067900877643580770381959e-01 3.51619049955642692939505877802731e-01 1.37937509976456512683640198702051e-01 2.69676629199526833591260555067493e-02
            3.60762340567732431306779972146614e-01 4.65125819964767317493681275664130e-01 1.74111839467500195688387520931428e-01 3.23462108737914630363086132547323e-02
            4.65125819964767317493681275664130e-01 1.74111839467500195688387520931428e-01 3.60762340567732431306779972146614e-01 3.23462108737914630363086132547323e-02
            1.74111839467500195688387520931428e-01 3.60762340567732431306779972146614e-01 4.65125819964767317493681275664130e-01 3.23462108737914630363086132547323e-02
            3.11300128982519408449292086515925e-01 2.70073629388671410112010562443174e-01 4.18626241628809125927546119783074e-01 3.39968545171754968348132308619824e-02
            2.70073629388671410112010562443174e-01 4.18626241628809125927546119783074e-01 3.11300128982519408449292086515925e-01 3.39968545171754968348132308619824e-02
            4.18626241628809125927546119783074e-01 3.11300128982519408449292086515925e-01 2.70073629388671410112010562443174e-01 3.39968545171754968348132308619824e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    16   52 2.31e-06    0    0
    18   66 6.11e-16    0    0
    ];





