
function [R,pointset_stats]=set_papanicolopulos_A_III_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% R:
%    R is a matrix N x 3,
%    with N possibly zero.
%    The pointset is written in terms of rotations of type "rot"
%    applied resp. to R=(w,a,b), where, setting c=1-a-b
%    rot(w,a,b)=[w,a,b,c; w,c,a,b; w,b,c,a]
%    REMARK: the sum of the weights of the set extracted from R,
%            for each rule, makes 1.
%    REMARK: in R the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicoloupolos
% "New fully symmetric and rotationally symmetric cubature rules on the
% triangle using minimal orthonormal bases".
% JCAM 294 (2016), 39-48.
% ** Using file rotationalsymmetry.txt from archives.
%--------------------------------------------------------------------
% REMARK:
% Rules are not appropriate for cubature when deg = 16.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  16 |  52 |   0 |   0 | 2.31e-06 |PI|
% |  18 |  66 |   0 |   0 | 6.11e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   52
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.3e-06
        
        R=[
            3.66324038067270818519460817697109e-02 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01
            3.54430487704302096471642435915328e-03 1.59610117131068415807781946114119e-02 1.68831254325296324647620593850661e-02
            4.01758833704091242872147304865393e-03 3.82193084171853891123360469350700e-03 9.93496727440693339072907974696136e-02
            4.19072009129610109634533898770314e-03 9.26217308054885085644158948525728e-02 4.71775047811925137691835274722507e-03
            8.56278268515921724135520065601668e-03 9.80984970538446680865529714310469e-03 2.46738918291675518590366777971212e-01
            9.97900781704974884633863041472068e-03 2.34453555493239956808437796098588e-01 1.25212213335406091080370671875244e-02
            1.02125635397787763863908239159173e-02 5.16573913793264283267347991568386e-02 5.77757850135847475514516702332912e-02
            1.40814747106397936127208936341049e-02 1.59791124093020334151482586548809e-02 4.13442936726308274408836496149888e-01
            1.46299246556413943542995781399441e-02 3.96856475222830962223952155909501e-01 1.67626402347665279246591296669067e-02
            1.60564662684797368474853840325522e-02 1.40368863416206357541682336886879e-01 5.04000292199502930579058102011913e-02
            1.70243419710226322194568382428770e-02 4.86460646955515496614452786161564e-02 1.53602469291318488586739476886578e-01
            2.49557676391715145547411935922355e-02 6.75456989279453468011382710756152e-02 2.93562718665030752962508131531649e-01
            2.81991167170094064742258410660725e-02 1.60476192471738526856839257561660e-01 2.76119726602889581368316385123762e-01
            2.82705789860670970992106987296211e-02 2.80462713730914248166925517580239e-01 7.72798343620785255225769105891231e-02
            2.92261109170242061594535698532127e-02 1.47356925256593940254390417976538e-01 1.48012388839049768840538945369190e-01
            3.40069090029891107906934166749124e-02 4.24740746647568945260076134218252e-01 2.08953636106141954487114276162174e-01
            3.42356238000260520992767965253734e-02 4.51724383070898127812142774928361e-01 8.70333245801910154737512925748888e-02
            3.99292500489855789469473279496015e-02 2.88318735917362067855407303795801e-01 1.90229119570889448898043383451295e-01
            ];
        
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   66
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.1e-16
        
        R=[
            2.63779112688252662805021842018505e-03 3.69780964055097839671137904815623e-03 7.43579235081241601834634025181003e-02
            2.67490665099675076210594681924704e-03 1.49143992279988854554595434365183e-02 1.36909130733626482889775388684939e-02
            3.19303827376352013928118012131563e-03 1.69739996219302907189130369403074e-03 2.08913690615461083988080304152390e-01
            4.17069843761026706058236968033270e-03 8.06620839466252737004481332405703e-02 8.24353269029142778079322084749947e-03
            5.25920323767891002841867731376624e-03 1.98747901402310800378359090245795e-01 6.97659509618316596435416698795962e-03
            7.18844500798738409580446173663404e-03 3.46702719147276405831092915832414e-01 9.05977135347985074176335729134735e-03
            8.95878269206539824820456630050103e-03 4.86346333871042757479585816327017e-02 5.57910529717466976973305747833365e-02
            9.24872538712559304208138399872041e-03 1.28318629849446304985738365189718e-02 3.44692548477970428510985811954015e-01
            1.00742462484914082482267971840884e-02 2.93595389942205159394816860185529e-02 1.39964110318391732334930566139519e-01
            1.02300748864493674938902501025950e-02 4.90788394693759288944789886954823e-01 4.95822517789664629628276770745288e-01
            1.27372161873653324398736330635984e-02 1.38618784059788779927657742518932e-01 4.47076793855018736478790231103631e-02
            1.41269815514411759688195857620485e-02 2.63897606352200997381629576921114e-01 4.36720952517550692340009277359059e-02
            1.53327744155534826525633107507929e-02 4.55911744930610901560541492472112e-02 2.45218573506195719469147320523916e-01
            1.91509883044683783259731768566780e-02 3.94010358537068061668406926401076e-01 5.92769337816446834077410699137545e-02
            1.95813758511073736368057751633387e-02 1.06867206940964756811673908032390e-01 1.28325526947980300684903909314016e-01
            2.25192148727883234560209757546545e-02 2.20575279425483411488428941993334e-01 1.13275821301684689879074596774444e-01
            2.37440880536187136351511384191326e-02 1.23653835041298731933778753955266e-01 2.42720437216092432830549796562991e-01
            2.45125802347510232670479979333322e-02 7.13348794100979594068334677103849e-02 3.87908478942486534268851983142667e-01
            2.46814736022687858385538106631429e-02 2.24126910324971617693989855979453e-01 2.13289800009618973897218552338018e-01
            2.69676629199526764202321515995209e-02 3.51619049955642692939505877802731e-01 1.37937509976456512683640198702051e-01
            3.23462108737914560974147093475040e-02 3.60762340567732431306779972146614e-01 4.65125819964767317493681275664130e-01
            3.39968545171754898959193269547541e-02 3.11300128982519408449292086515925e-01 2.70073629388671410112010562443174e-01
            ];
        
        
        
    otherwise
        R=[];
end




pointset_stats=[
    16   52 2.31e-06    0    0
    18   66 6.11e-16    0    0
    ];




