
function [xyw,pointset_stats]=set_papanicolopulos_A_III_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicoloupolos
% "New fully symmetric and rotationally symmetric cubature rules on the
% triangle using minimal orthonormal bases".
% JCAM 294 (2016), 39-48.
% ** Using file rotationalsymmetry.txt from archives.
%--------------------------------------------------------------------
% REMARK:
% Rules are not appropriate for cubature when deg = 16.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  16 |  52 |   0 |   0 | 2.31e-06 |PI|
% |  18 |  66 |   0 |   0 | 6.11e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

switch deg
    
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   52
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.3e-06
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.83162019033635374565260889312412e-02
            1.59610117131068415807781946114119e-02 1.68831254325296324647620593850661e-02 1.77215243852151004867734318537487e-03
            1.68831254325296324647620593850661e-02 9.67155862854363501668331082328223e-01 1.77215243852151004867734318537487e-03
            9.67155862854363501668331082328223e-01 1.59610117131068415807781946114119e-02 1.77215243852151004867734318537487e-03
            3.82193084171853891123360469350700e-03 9.93496727440693339072907974696136e-02 2.00879416852045578067986753012519e-03
            9.93496727440693339072907974696136e-02 8.96828396414212081211303484451491e-01 2.00879416852045578067986753012519e-03
            8.96828396414212081211303484451491e-01 3.82193084171853891123360469350700e-03 2.00879416852045578067986753012519e-03
            9.26217308054885085644158948525728e-02 4.71775047811925137691835274722507e-03 2.09536004564805011449180049964980e-03
            4.71775047811925137691835274722507e-03 9.02660518716392190619046687061200e-01 2.09536004564805011449180049964980e-03
            9.02660518716392190619046687061200e-01 9.26217308054885085644158948525728e-02 2.09536004564805011449180049964980e-03
            9.80984970538446680865529714310469e-03 2.46738918291675518590366777971212e-01 4.28139134257960775331586233960479e-03
            2.46738918291675518590366777971212e-01 7.43451232002940054499617872352246e-01 4.28139134257960775331586233960479e-03
            7.43451232002940054499617872352246e-01 9.80984970538446680865529714310469e-03 4.28139134257960775331586233960479e-03
            2.34453555493239956808437796098588e-01 1.25212213335406091080370671875244e-02 4.98950390852487355580757721895679e-03
            1.25212213335406091080370671875244e-02 7.53025223173219404593226045108167e-01 4.98950390852487355580757721895679e-03
            7.53025223173219404593226045108167e-01 2.34453555493239956808437796098588e-01 4.98950390852487355580757721895679e-03
            5.16573913793264283267347991568386e-02 5.77757850135847475514516702332912e-02 5.10628176988938732583367396955509e-03
            5.77757850135847475514516702332912e-02 8.90566823607088831060707434517099e-01 5.10628176988938732583367396955509e-03
            8.90566823607088831060707434517099e-01 5.16573913793264283267347991568386e-02 5.10628176988938732583367396955509e-03
            1.59791124093020334151482586548809e-02 4.13442936726308274408836496149888e-01 7.04073735531989507163697084024534e-03
            4.13442936726308274408836496149888e-01 5.70577950864389671359333533473546e-01 7.04073735531989507163697084024534e-03
            5.70577950864389671359333533473546e-01 1.59791124093020334151482586548809e-02 7.04073735531989507163697084024534e-03
            3.96856475222830962223952155909501e-01 1.67626402347665279246591296669067e-02 7.31496232782069544242631309316494e-03
            1.67626402347665279246591296669067e-02 5.86380884542402558423646041774191e-01 7.31496232782069544242631309316494e-03
            5.86380884542402558423646041774191e-01 3.96856475222830962223952155909501e-01 7.31496232782069544242631309316494e-03
            1.40368863416206357541682336886879e-01 5.04000292199502930579058102011913e-02 8.02823313423986668901921603946903e-03
            5.04000292199502930579058102011913e-02 8.09231107363843404911563084169757e-01 8.02823313423986668901921603946903e-03
            8.09231107363843404911563084169757e-01 1.40368863416206357541682336886879e-01 8.02823313423986668901921603946903e-03
            4.86460646955515496614452786161564e-02 1.53602469291318488586739476886578e-01 8.51217098551131437500494314463140e-03
            1.53602469291318488586739476886578e-01 7.97751466013129961751815244497266e-01 8.51217098551131437500494314463140e-03
            7.97751466013129961751815244497266e-01 4.86460646955515496614452786161564e-02 8.51217098551131437500494314463140e-03
            6.75456989279453468011382710756152e-02 2.93562718665030752962508131531649e-01 1.24778838195857538079236448425036e-02
            2.93562718665030752962508131531649e-01 6.38891582407023816969626750505995e-01 1.24778838195857538079236448425036e-02
            6.38891582407023816969626750505995e-01 6.75456989279453468011382710756152e-02 1.24778838195857538079236448425036e-02
            1.60476192471738526856839257561660e-01 2.76119726602889581368316385123762e-01 1.40995583585046997676659685794220e-02
            2.76119726602889581368316385123762e-01 5.63404080925371975041571204201318e-01 1.40995583585046997676659685794220e-02
            5.63404080925371975041571204201318e-01 1.60476192471738526856839257561660e-01 1.40995583585046997676659685794220e-02
            2.80462713730914248166925517580239e-01 7.72798343620785255225769105891231e-02 1.41352894930335450801583974111963e-02
            7.72798343620785255225769105891231e-02 6.42257451907007226310497571830638e-01 1.41352894930335450801583974111963e-02
            6.42257451907007226310497571830638e-01 2.80462713730914248166925517580239e-01 1.41352894930335450801583974111963e-02
            1.47356925256593940254390417976538e-01 1.48012388839049768840538945369190e-01 1.46130554585120996102798329729922e-02
            1.48012388839049768840538945369190e-01 7.04630685904356290905070636654273e-01 1.46130554585120996102798329729922e-02
            7.04630685904356290905070636654273e-01 1.47356925256593940254390417976538e-01 1.46130554585120996102798329729922e-02
            4.24740746647568945260076134218252e-01 2.08953636106141954487114276162174e-01 1.70034545014945519258997563838420e-02
            2.08953636106141954487114276162174e-01 3.66305617246289072497233973990660e-01 1.70034545014945519258997563838420e-02
            3.66305617246289072497233973990660e-01 4.24740746647568945260076134218252e-01 1.70034545014945519258997563838420e-02
            4.51724383070898127812142774928361e-01 8.70333245801910154737512925748888e-02 1.71178119000130225801914463090725e-02
            8.70333245801910154737512925748888e-02 4.61242292348910842836318124682293e-01 1.71178119000130225801914463090725e-02
            4.61242292348910842836318124682293e-01 4.51724383070898127812142774928361e-01 1.71178119000130225801914463090725e-02
            2.88318735917362067855407303795801e-01 1.90229119570889448898043383451295e-01 1.99646250244927860040267120211865e-02
            1.90229119570889448898043383451295e-01 5.21452144511748594268851775268558e-01 1.99646250244927860040267120211865e-02
            5.21452144511748594268851775268558e-01 2.88318735917362067855407303795801e-01 1.99646250244927860040267120211865e-02
            ];
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   66
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.1e-16
        
        xyw=[
            3.69780964055097839671137904815623e-03 7.43579235081241601834634025181003e-02 1.31889556344126353086554370719341e-03
            7.43579235081241601834634025181003e-02 9.21944266851324800704503559245495e-01 1.31889556344126353086554370719341e-03
            9.21944266851324800704503559245495e-01 3.69780964055097839671137904815623e-03 1.31889556344126353086554370719341e-03
            1.49143992279988854554595434365183e-02 1.36909130733626482889775388684939e-02 1.33745332549837559789340790672441e-03
            1.36909130733626482889775388684939e-02 9.71394687698638459316669013787759e-01 1.33745332549837559789340790672441e-03
            9.71394687698638459316669013787759e-01 1.49143992279988854554595434365183e-02 1.33745332549837559789340790672441e-03
            1.69739996219302907189130369403074e-03 2.08913690615461083988080304152390e-01 1.59651913688176050332145905485959e-03
            2.08913690615461083988080304152390e-01 7.89388909422345963484701769630192e-01 1.59651913688176050332145905485959e-03
            7.89388909422345963484701769630192e-01 1.69739996219302907189130369403074e-03 1.59651913688176050332145905485959e-03
            8.06620839466252737004481332405703e-02 8.24353269029142778079322084749947e-03 2.08534921880513396397205383436813e-03
            8.24353269029142778079322084749947e-03 9.11094383363083348825739449239336e-01 2.08534921880513396397205383436813e-03
            9.11094383363083348825739449239336e-01 8.06620839466252737004481332405703e-02 2.08534921880513396397205383436813e-03
            1.98747901402310800378359090245795e-01 6.97659509618316596435416698795962e-03 2.62960161883945544789020765108489e-03
            6.97659509618316596435416698795962e-03 7.94275503501505997228093747253297e-01 2.62960161883945544789020765108489e-03
            7.94275503501505997228093747253297e-01 1.98747901402310800378359090245795e-01 2.62960161883945544789020765108489e-03
            3.46702719147276405831092915832414e-01 9.05977135347985074176335729134735e-03 3.59422250399369291526396885672057e-03
            9.05977135347985074176335729134735e-03 6.44237509499243632404841264360584e-01 3.59422250399369291526396885672057e-03
            6.44237509499243632404841264360584e-01 3.46702719147276405831092915832414e-01 3.59422250399369291526396885672057e-03
            4.86346333871042757479585816327017e-02 5.57910529717466976973305747833365e-02 4.47939134603269999146402113865406e-03
            5.57910529717466976973305747833365e-02 8.95574313641149033493604747491190e-01 4.47939134603269999146402113865406e-03
            8.95574313641149033493604747491190e-01 4.86346333871042757479585816327017e-02 4.47939134603269999146402113865406e-03
            1.28318629849446304985738365189718e-02 3.44692548477970428510985811954015e-01 4.62436269356279738840242998776375e-03
            3.44692548477970428510985811954015e-01 6.42475588537084973950186395086348e-01 4.62436269356279738840242998776375e-03
            6.42475588537084973950186395086348e-01 1.28318629849446304985738365189718e-02 4.62436269356279738840242998776375e-03
            2.93595389942205159394816860185529e-02 1.39964110318391732334930566139519e-01 5.03712312424570499147513658044772e-03
            1.39964110318391732334930566139519e-01 8.30676350687387765603375555656385e-01 5.03712312424570499147513658044772e-03
            8.30676350687387765603375555656385e-01 2.93595389942205159394816860185529e-02 5.03712312424570499147513658044772e-03
            4.90788394693759288944789886954823e-01 4.95822517789664629628276770745288e-01 5.11503744322468461430686303970106e-03
            4.95822517789664629628276770745288e-01 1.33890875165761369380845735577168e-02 5.11503744322468461430686303970106e-03
            1.33890875165761369380845735577168e-02 4.90788394693759288944789886954823e-01 5.11503744322468461430686303970106e-03
            1.38618784059788779927657742518932e-01 4.47076793855018736478790231103631e-02 6.36860809368266795466029250860629e-03
            4.47076793855018736478790231103631e-02 8.16673536554709311729993714834563e-01 6.36860809368266795466029250860629e-03
            8.16673536554709311729993714834563e-01 1.38618784059788779927657742518932e-01 6.36860809368266795466029250860629e-03
            2.63897606352200997381629576921114e-01 4.36720952517550692340009277359059e-02 7.06349077572058971913326885783135e-03
            4.36720952517550692340009277359059e-02 6.92430298396043975017732918786351e-01 7.06349077572058971913326885783135e-03
            6.92430298396043975017732918786351e-01 2.63897606352200997381629576921114e-01 7.06349077572058971913326885783135e-03
            4.55911744930610901560541492472112e-02 2.45218573506195719469147320523916e-01 7.66638720777674306100513135220353e-03
            2.45218573506195719469147320523916e-01 7.09190252000743259763737569301156e-01 7.66638720777674306100513135220353e-03
            7.09190252000743259763737569301156e-01 4.55911744930610901560541492472112e-02 7.66638720777674306100513135220353e-03
            3.94010358537068061668406926401076e-01 5.92769337816446834077410699137545e-02 9.57549415223419089771006440514611e-03
            5.92769337816446834077410699137545e-02 5.46712707681287324312791042757453e-01 9.57549415223419089771006440514611e-03
            5.46712707681287324312791042757453e-01 3.94010358537068061668406926401076e-01 9.57549415223419089771006440514611e-03
            1.06867206940964756811673908032390e-01 1.28325526947980300684903909314016e-01 9.79068792555368855312636355847644e-03
            1.28325526947980300684903909314016e-01 7.64807266111054984136785606096964e-01 9.79068792555368855312636355847644e-03
            7.64807266111054984136785606096964e-01 1.06867206940964756811673908032390e-01 9.79068792555368855312636355847644e-03
            2.20575279425483411488428941993334e-01 1.13275821301684689879074596774444e-01 1.12596074363941634627339638541343e-02
            1.13275821301684689879074596774444e-01 6.66148899272831940265859884675592e-01 1.12596074363941634627339638541343e-02
            6.66148899272831940265859884675592e-01 2.20575279425483411488428941993334e-01 1.12596074363941634627339638541343e-02
            1.23653835041298731933778753955266e-01 2.42720437216092432830549796562991e-01 1.18720440268093602870225211631805e-02
            2.42720437216092432830549796562991e-01 6.33625727742608724213368986966088e-01 1.18720440268093602870225211631805e-02
            6.33625727742608724213368986966088e-01 1.23653835041298731933778753955266e-01 1.18720440268093602870225211631805e-02
            7.13348794100979594068334677103849e-02 3.87908478942486534268851983142667e-01 1.22562901173755151029709509202803e-02
            3.87908478942486534268851983142667e-01 5.40756641647415436935375510074664e-01 1.22562901173755151029709509202803e-02
            5.40756641647415436935375510074664e-01 7.13348794100979594068334677103849e-02 1.22562901173755151029709509202803e-02
            2.24126910324971617693989855979453e-01 2.13289800009618973897218552338018e-01 1.23407368011343963887238572851857e-02
            2.13289800009618973897218552338018e-01 5.62583289665409380653215976053616e-01 1.23407368011343963887238572851857e-02
            5.62583289665409380653215976053616e-01 2.24126910324971617693989855979453e-01 1.23407368011343963887238572851857e-02
            3.51619049955642692939505877802731e-01 1.37937509976456512683640198702051e-01 1.34838314599763416795630277533746e-02
            1.37937509976456512683640198702051e-01 5.10443440067900877643580770381959e-01 1.34838314599763416795630277533746e-02
            5.10443440067900877643580770381959e-01 3.51619049955642692939505877802731e-01 1.34838314599763416795630277533746e-02
            3.60762340567732431306779972146614e-01 4.65125819964767317493681275664130e-01 1.61731054368957315181543066273662e-02
            4.65125819964767317493681275664130e-01 1.74111839467500195688387520931428e-01 1.61731054368957315181543066273662e-02
            1.74111839467500195688387520931428e-01 3.60762340567732431306779972146614e-01 1.61731054368957315181543066273662e-02
            3.11300128982519408449292086515925e-01 2.70073629388671410112010562443174e-01 1.69984272585877484174066154309912e-02
            2.70073629388671410112010562443174e-01 4.18626241628809125927546119783074e-01 1.69984272585877484174066154309912e-02
            4.18626241628809125927546119783074e-01 3.11300128982519408449292086515925e-01 1.69984272585877484174066154309912e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    16   52 2.31e-06    0    0
    18   66 6.11e-16    0    0
    ];




