
function [xyw_bar,pointset_stats]=set_papanicolopulos_A_III_C_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicoloupolos
% "New fully symmetric and rotationally symmetric cubature rules on the
% triangle using minimal orthonormal bases".
% JCAM 294 (2016), 39-48.
% ** Using file rotationalsymmetry.txt from archives.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  16 |  52 |   0 |   0 | 5.67e-16 |PI|
% |  18 |  66 |   0 |   0 | 6.11e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   52
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.7e-16
        
        xyw_bar=[
            3.33333258825057543450753883007565e-01 3.33333416793498094055081537590013e-01 3.33333324381444418005315810660250e-01 3.66322713380085041023903613677248e-02
            1.59610022226682676804720983909647e-02 1.68831336617950890366390837016297e-02 9.67155864115536667569017481582705e-01 3.54430005936213652836808130075497e-03
            1.68831386831158891670412458552164e-02 9.67155848242693849670104100368917e-01 1.59610130741902889184302694047801e-02 3.54430344556864833360787514493495e-03
            9.67155874801573611776461802946869e-01 1.59610017505312264118888521124973e-02 1.68831234478951618116493449406335e-02 3.54429787059933141396550482227212e-03
            3.82175264537209027904118840979208e-03 9.93497988852496682898873814338003e-02 8.96828448469378258778306189924479e-01 4.01753559940491635632531242094956e-03
            9.93498059462007421238638471550075e-02 8.96828443482067250158706883667037e-01 3.82175057173195220627803792012855e-03 4.01753526200393940720489993623232e-03
            8.96828514177593794087783862778451e-01 3.82166009293576384650559241151768e-03 9.93498257294704451014766277694434e-02 4.01750856891472211962490490577693e-03
            9.26216384068819231778491030127043e-02 4.71767615382126959816533329217236e-03 9.02660685439296894827521100523882e-01 4.19069287166682746120782709908781e-03
            4.71771782160070388134620600339986e-03 9.02660618534333103468725312268361e-01 9.26216636440662099971632414963096e-02 4.19070619233738277109591052749238e-03
            9.02660635509004438681301962787984e-01 9.26216255989500553136295479816908e-02 4.71773889204550600506848923032521e-03 4.19071143098620566697087852503500e-03
            9.80978287005476561055683504264380e-03 2.46739276017129749440925934322877e-01 7.43450941112815510969369370286586e-01 8.56274282605716356708835945710234e-03
            2.46739291498785623391043486662966e-01 7.43450929200298094023935391305713e-01 9.80977930091631034059673766023479e-03 8.56274086903757204736198360706112e-03
            7.43450875758368434631506715959404e-01 9.80976558397046727311163749618572e-03 2.46739358657661111973169454358867e-01 8.56273072332908689874297891719834e-03
            2.34453465539761568559029569769336e-01 1.25212065221199080750080767643340e-02 7.53025327938118604897965724376263e-01 9.97899128345977604048755438270746e-03
            1.25212159624579367350749592446846e-02 7.53025327539010524979801175504690e-01 2.34453456498531553897635149041889e-01 9.97899863318809331180769817137843e-03
            7.53025384905626316012217102979776e-01 2.34453392434268298449850931319816e-01 1.25212226601053855379319657004089e-02 9.97900499538644653041430387929722e-03
            5.16571129743772089470965624968812e-02 5.77757501193756767277065478083387e-02 8.90567136906247114325196889694780e-01 1.02125452011529848500570594183046e-02
            5.77758193667164202111941051498434e-02 8.90567064125437068966562037530821e-01 5.16571165078465455167133768554777e-02 1.02125504951800193109701098137521e-02
            8.90567194917750382110455120709958e-01 5.16569496852326212610329037033807e-02 5.77758553970169966285119755866617e-02 1.02125396790015039727439472017068e-02
            1.59791125061900518566915252449689e-02 4.13443247683559167438005488293129e-01 5.70577639810250669683000523946248e-01 1.40814676453685817814065472930452e-02
            4.13443261309727971841709859290859e-01 5.70577625472078464596847879874986e-01 1.59791132181935635614422608341556e-02 1.40814686994148903498302871639680e-02
            5.70577597706886541217841113393661e-01 1.59791161057934658074053402287973e-02 4.13443286187320013791435258099227e-01 1.40814674476657034074555951974617e-02
            3.96856249731830756921624470123788e-01 1.67626482477742817789323481747488e-02 5.86381102020394950891102325840620e-01 1.46299200719831774819557068667564e-02
            1.67626502257961773612038314240635e-02 5.86381091244488561464720532967476e-01 3.96856258529715288929651251237374e-01 1.46299236505949836750772874438553e-02
            5.86381123891194455666209250921384e-01 3.96856228163050439583514616970206e-01 1.67626479457551047502761321084108e-02 1.46299240889223129691298908028330e-02
            1.40368578298825791295101339528628e-01 5.03998899802897762367770440050663e-02 8.09231531720884467162591136002447e-01 1.60564743547984868643485611983124e-02
            5.03999622891451101724946681770234e-02 8.09231429420804393437549606460379e-01 1.40368608290050489451061821455369e-01 1.60564833439335377662793291619892e-02
            8.09231545448009126353383635432692e-01 1.40368456667959051742400333750993e-01 5.03999978840318219042160308163147e-02 1.60564947748501468671733505289012e-02
            4.86458021470726476032098162249895e-02 1.53602435235486750597644345361914e-01 7.97751762617440629554721454042010e-01 1.70243454537556647421236988293458e-02
            1.53602501486405723651884613900620e-01 7.97751700040076339170980190829141e-01 4.86457984735179094215595796413254e-02 1.70243434461975380600495810767825e-02
            7.97751821638013391968513587926282e-01 4.86457042544259365968173369765282e-02 1.53602474107560671434669075097190e-01 1.70243367709258380804371313388401e-02
            6.75455296003345112554328011356120e-02 2.93562763267696591462652122572763e-01 6.38891707131968855648551652848255e-01 2.49557451615471069528151559779872e-02
            2.93562815361712137196548155770870e-01 6.38891644704477568161848921590718e-01 6.75455399338102946416029226384126e-02 2.49557532840810752938764949249162e-02
            6.38891715657272207806727237766609e-01 6.75455106829575269156151762217632e-02 2.93562773659770237522081970382715e-01 2.49557456673245581235676127107581e-02
            1.60475924195126878890604871230607e-01 2.76119726602889581368316385123762e-01 5.63404349201983567496654359274544e-01 2.81991515742029894009412771538337e-02
            2.76119919814122483092688753458788e-01 5.63404080925371975041571204201318e-01 1.60475999260505597376891273597721e-01 2.81991890494703127678643994613594e-02
            5.63404080925371975041571204201318e-01 1.60475943078972893562905710496125e-01 2.76119975995655131395523085302557e-01 2.81991766718340357289473985247241e-02
            2.80462494123582872784794517428963e-01 7.72798169129284839851123933840427e-02 6.42257688963488559963366242300253e-01 2.82705877589176333974929633541251e-02
            7.72798476080368140772591800669034e-02 6.42257629182079847751651868748013e-01 2.80462523209883296537725527741713e-01 2.82705967826424355016090572689791e-02
            6.42257731649287122444036413071444e-01 2.80462425269744686229245189679204e-01 7.72798430809681913267183972493513e-02 2.82705981152946671242087717246250e-02
            1.47356656075135344918791702184535e-01 1.48012282095027453143742945940176e-01 7.04631061829837146426314120617462e-01 2.92261282653642588680309444271188e-02
            1.48012388896020280482090925033845e-01 7.04630946772243804687718693458010e-01 1.47356664331735887074614765879232e-01 2.92261445283469485645344576596472e-02
            7.04630995778554591879583313129842e-01 1.47356574993519673366648703449755e-01 1.48012429227925734753767983420403e-01 2.92261465135742366794335822532958e-02
            4.24740426214290034412357499604695e-01 2.08953868767089018243510167849308e-01 3.66305705018621030610859179432737e-01 3.40069657117637244581054289938038e-02
            2.08953731775949336224584840238094e-01 3.66305584744693935039805410269764e-01 4.24740683479356728735609749492141e-01 3.40069753728283047378155856677040e-02
            3.66305807793043392006637759550358e-01 4.24740413497297630840421334141865e-01 2.08953778709658921641789675049949e-01 3.40069512873323667734304365239950e-02
            4.51724222556604049216844032343943e-01 8.70333698449567150223771250239224e-02 4.61242407598439263516354458261048e-01 3.42356589565166874455925949405355e-02
            8.70333625302085328589996038317622e-02 4.61242369666382878712340698257321e-01 4.51724267803408574550871890096460e-01 3.42356548016872139217348092188331e-02
            4.61242460733382209081554492513533e-01 4.51724181218181475294670690345811e-01 8.70333580484362601126235858828295e-02 3.42356567462431746196038773177861e-02
            2.88318499660714211429990427859593e-01 1.90229112412624801198290924730827e-01 5.21452387926661042882869878667407e-01 3.99292679477469200644002000899491e-02
            1.90229156603659105284620522979822e-01 5.21452304852625614373096141207498e-01 2.88318538543715252586707720183767e-01 3.99292818616593520042457043928152e-02
            5.21452426537516333659993961191503e-01 2.88318431951264997348260976650636e-01 1.90229141511218668991745062157861e-01 3.99292668485658405752580790704087e-02
            ];
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   66
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.1e-16
        
        xyw_bar=[
            3.69780964055097839671137904815623e-03 7.43579235081241601834634025181003e-02 9.21944266851324800704503559245495e-01 2.63779112688252706173108741438682e-03
            7.43579235081241601834634025181003e-02 9.21944266851324800704503559245495e-01 3.69780964055099747866961479303427e-03 2.63779112688252706173108741438682e-03
            9.21944266851324800704503559245495e-01 3.69780964055097839671137904815623e-03 7.43579235081242156946146337759274e-02 2.63779112688252706173108741438682e-03
            1.49143992279988854554595434365183e-02 1.36909130733626482889775388684939e-02 9.71394687698638459316669013787759e-01 2.67490665099675119578681581344881e-03
            1.36909130733626482889775388684939e-02 9.71394687698638459316669013787759e-01 1.49143992279988646387778317148332e-02 2.67490665099675119578681581344881e-03
            9.71394687698638459316669013787759e-01 1.49143992279988854554595434365183e-02 1.36909130733626552278714427757222e-02 2.67490665099675119578681581344881e-03
            1.69739996219302907189130369403074e-03 2.08913690615461083988080304152390e-01 7.89388909422345963484701769630192e-01 3.19303827376352100664291810971918e-03
            2.08913690615461083988080304152390e-01 7.89388909422345963484701769630192e-01 1.69739996219298028279354184633121e-03 3.19303827376352100664291810971918e-03
            7.89388909422345963484701769630192e-01 1.69739996219302907189130369403074e-03 2.08913690615461000721353457265650e-01 3.19303827376352100664291810971918e-03
            8.06620839466252737004481332405703e-02 8.24353269029142778079322084749947e-03 9.11094383363083348825739449239336e-01 4.17069843761026792794410766873625e-03
            8.24353269029142778079322084749947e-03 9.11094383363083348825739449239336e-01 8.06620839466252181892969019827433e-02 4.17069843761026792794410766873625e-03
            9.11094383363083348825739449239336e-01 8.06620839466252737004481332405703e-02 8.24353269029137747381241752009373e-03 4.17069843761026792794410766873625e-03
            1.98747901402310800378359090245795e-01 6.97659509618316596435416698795962e-03 7.94275503501505997228093747253297e-01 5.25920323767891089578041530216979e-03
            6.97659509618316596435416698795962e-03 7.94275503501505997228093747253297e-01 1.98747901402310800378359090245795e-01 5.25920323767891089578041530216979e-03
            7.94275503501505997228093747253297e-01 1.98747901402310800378359090245795e-01 6.97659509618320239354716250090860e-03 5.25920323767891089578041530216979e-03
            3.46702719147276405831092915832414e-01 9.05977135347985074176335729134735e-03 6.44237509499243632404841264360584e-01 7.18844500798738583052793771344113e-03
            9.05977135347985074176335729134735e-03 6.44237509499243632404841264360584e-01 3.46702719147276461342244147090241e-01 7.18844500798738583052793771344113e-03
            6.44237509499243632404841264360584e-01 3.46702719147276405831092915832414e-01 9.05977135347996176406581980700139e-03 7.18844500798738583052793771344113e-03
            4.86346333871042757479585816327017e-02 5.57910529717466976973305747833365e-02 8.95574313641149033493604747491190e-01 8.95878269206539998292804227730812e-03
            5.57910529717466976973305747833365e-02 8.95574313641149033493604747491190e-01 4.86346333871042757479585816327017e-02 8.95878269206539998292804227730812e-03
            8.95574313641149033493604747491190e-01 4.86346333871042757479585816327017e-02 5.57910529717466907584366708761081e-02 8.95878269206539998292804227730812e-03
            1.28318629849446304985738365189718e-02 3.44692548477970428510985811954015e-01 6.42475588537084973950186395086348e-01 9.24872538712559477680485997552751e-03
            3.44692548477970428510985811954015e-01 6.42475588537084973950186395086348e-01 1.28318629849446530499790242174640e-02 9.24872538712559477680485997552751e-03
            6.42475588537084973950186395086348e-01 1.28318629849446304985738365189718e-02 3.44692548477970372999834580696188e-01 9.24872538712559477680485997552751e-03
            2.93595389942205159394816860185529e-02 1.39964110318391732334930566139519e-01 8.30676350687387765603375555656385e-01 1.00742462484914099829502731608954e-02
            1.39964110318391732334930566139519e-01 8.30676350687387765603375555656385e-01 2.93595389942205020616938782040961e-02 1.00742462484914099829502731608954e-02
            8.30676350687387765603375555656385e-01 2.93595389942205159394816860185529e-02 1.39964110318391732334930566139519e-01 1.00742462484914099829502731608954e-02
            4.90788394693759288944789886954823e-01 4.95822517789664629628276770745288e-01 1.33890875165761369380845735577168e-02 1.02300748864493692286137260794021e-02
            4.95822517789664629628276770745288e-01 1.33890875165761369380845735577168e-02 4.90788394693759177922487424439169e-01 1.02300748864493692286137260794021e-02
            1.33890875165761369380845735577168e-02 4.90788394693759288944789886954823e-01 4.95822517789664629628276770745288e-01 1.02300748864493692286137260794021e-02
            1.38618784059788779927657742518932e-01 4.47076793855018736478790231103631e-02 8.16673536554709311729993714834563e-01 1.27372161873653359093205850172126e-02
            4.47076793855018736478790231103631e-02 8.16673536554709311729993714834563e-01 1.38618784059788779927657742518932e-01 1.27372161873653359093205850172126e-02
            8.16673536554709311729993714834563e-01 1.38618784059788779927657742518932e-01 4.47076793855019083423485426465049e-02 1.27372161873653359093205850172126e-02
            2.63897606352200997381629576921114e-01 4.36720952517550692340009277359059e-02 6.92430298396043975017732918786351e-01 1.41269815514411794382665377156627e-02
            4.36720952517550692340009277359059e-02 6.92430298396043975017732918786351e-01 2.63897606352200941870478345663287e-01 1.41269815514411794382665377156627e-02
            6.92430298396043975017732918786351e-01 2.63897606352200997381629576921114e-01 4.36720952517550276006375042925356e-02 1.41269815514411794382665377156627e-02
            4.55911744930610901560541492472112e-02 2.45218573506195719469147320523916e-01 7.09190252000743259763737569301156e-01 1.53327744155534861220102627044071e-02
            2.45218573506195719469147320523916e-01 7.09190252000743259763737569301156e-01 4.55911744930610485226907258038409e-02 1.53327744155534861220102627044071e-02
            7.09190252000743259763737569301156e-01 4.55911744930610901560541492472112e-02 2.45218573506195636202420473637176e-01 1.53327744155534861220102627044071e-02
            3.94010358537068061668406926401076e-01 5.92769337816446834077410699137545e-02 5.46712707681287324312791042757453e-01 1.91509883044683817954201288102922e-02
            5.92769337816446834077410699137545e-02 5.46712707681287324312791042757453e-01 3.94010358537068006157255695143249e-01 1.91509883044683817954201288102922e-02
            5.46712707681287324312791042757453e-01 3.94010358537068061668406926401076e-01 5.92769337816446140188020308414707e-02 1.91509883044683817954201288102922e-02
            1.06867206940964756811673908032390e-01 1.28325526947980300684903909314016e-01 7.64807266111054984136785606096964e-01 1.95813758511073771062527271169529e-02
            1.28325526947980300684903909314016e-01 7.64807266111054984136785606096964e-01 1.06867206940964742933886100217933e-01 1.95813758511073771062527271169529e-02
            7.64807266111054984136785606096964e-01 1.06867206940964756811673908032390e-01 1.28325526947980272929328293685103e-01 1.95813758511073771062527271169529e-02
            2.20575279425483411488428941993334e-01 1.13275821301684689879074596774444e-01 6.66148899272831940265859884675592e-01 2.25192148727883269254679277082687e-02
            1.13275821301684689879074596774444e-01 6.66148899272831940265859884675592e-01 2.20575279425483383732853326364420e-01 2.25192148727883269254679277082687e-02
            6.66148899272831940265859884675592e-01 2.20575279425483411488428941993334e-01 1.13275821301684648245711173331074e-01 2.25192148727883269254679277082687e-02
            1.23653835041298731933778753955266e-01 2.42720437216092432830549796562991e-01 6.33625727742608724213368986966088e-01 2.37440880536187205740450423263610e-02
            2.42720437216092432830549796562991e-01 6.33625727742608724213368986966088e-01 1.23653835041298787444929985213093e-01 2.37440880536187205740450423263610e-02
            6.33625727742608724213368986966088e-01 1.23653835041298731933778753955266e-01 2.42720437216092543852852259078645e-01 2.37440880536187205740450423263610e-02
            7.13348794100979594068334677103849e-02 3.87908478942486534268851983142667e-01 5.40756641647415436935375510074664e-01 2.45125802347510302059419018405606e-02
            3.87908478942486534268851983142667e-01 5.40756641647415436935375510074664e-01 7.13348794100980843069237380404957e-02 2.45125802347510302059419018405606e-02
            5.40756641647415436935375510074664e-01 7.13348794100979594068334677103849e-02 3.87908478942486589780003214400494e-01 2.45125802347510302059419018405606e-02
            2.24126910324971617693989855979453e-01 2.13289800009618973897218552338018e-01 5.62583289665409380653215976053616e-01 2.46814736022687927774477145703713e-02
            2.13289800009618973897218552338018e-01 5.62583289665409380653215976053616e-01 2.24126910324971673205141087237280e-01 2.46814736022687927774477145703713e-02
            5.62583289665409380653215976053616e-01 2.24126910324971617693989855979453e-01 2.13289800009619001652794167966931e-01 2.46814736022687927774477145703713e-02
            3.51619049955642692939505877802731e-01 1.37937509976456512683640198702051e-01 5.10443440067900877643580770381959e-01 2.69676629199526833591260555067493e-02
            1.37937509976456512683640198702051e-01 5.10443440067900877643580770381959e-01 3.51619049955642637428354646544904e-01 2.69676629199526833591260555067493e-02
            5.10443440067900877643580770381959e-01 3.51619049955642692939505877802731e-01 1.37937509976456429416913351815310e-01 2.69676629199526833591260555067493e-02
            3.60762340567732431306779972146614e-01 4.65125819964767317493681275664130e-01 1.74111839467500195688387520931428e-01 3.23462108737914630363086132547323e-02
            4.65125819964767317493681275664130e-01 1.74111839467500195688387520931428e-01 3.60762340567732486817931203404441e-01 3.23462108737914630363086132547323e-02
            1.74111839467500195688387520931428e-01 3.60762340567732431306779972146614e-01 4.65125819964767373004832506921957e-01 3.23462108737914630363086132547323e-02
            3.11300128982519408449292086515925e-01 2.70073629388671410112010562443174e-01 4.18626241628809125927546119783074e-01 3.39968545171754968348132308619824e-02
            2.70073629388671410112010562443174e-01 4.18626241628809125927546119783074e-01 3.11300128982519463960443317773752e-01 3.39968545171754968348132308619824e-02
            4.18626241628809125927546119783074e-01 3.11300128982519408449292086515925e-01 2.70073629388671465623161793701001e-01 3.39968545171754968348132308619824e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    16   52 5.67e-16    0    0
    18   66 6.11e-16    0    0
    ];





