
function [xyw,pointset_stats]=set_papanicolopulos_A_III_C_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicoloupolos
% "New fully symmetric and rotationally symmetric cubature rules on the
% triangle using minimal orthonormal bases".
% JCAM 294 (2016), 39-48.
% ** Using file rotationalsymmetry.txt from archives.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  16 |  52 |   0 |   0 | 5.67e-16 |PI|
% |  18 |  66 |   0 |   0 | 6.11e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   52
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.7e-16
        
        xyw=[
            3.33333258825057543450753883007565e-01 3.33333416793498094055081537590013e-01 1.83161356690042520511951806838624e-02
            1.59610022226682676804720983909647e-02 1.68831336617950890366390837016297e-02 1.77215002968106826418404065037748e-03
            1.68831386831158891670412458552164e-02 9.67155848242693849670104100368917e-01 1.77215172278432416680393757246748e-03
            9.67155874801573611776461802946869e-01 1.59610017505312264118888521124973e-02 1.77214893529966570698275241113606e-03
            3.82175264537209027904118840979208e-03 9.93497988852496682898873814338003e-02 2.00876779970245817816265621047478e-03
            9.93498059462007421238638471550075e-02 8.96828443482067250158706883667037e-01 2.00876763100196970360244996811616e-03
            8.96828514177593794087783862778451e-01 3.82166009293576384650559241151768e-03 2.00875428445736105981245245288846e-03
            9.26216384068819231778491030127043e-02 4.71767615382126959816533329217236e-03 2.09534643583341373060391354954390e-03
            4.71771782160070388134620600339986e-03 9.02660618534333103468725312268361e-01 2.09535309616869138554795526374619e-03
            9.02660635509004438681301962787984e-01 9.26216255989500553136295479816908e-02 2.09535571549310283348543926251750e-03
            9.80978287005476561055683504264380e-03 2.46739276017129749440925934322877e-01 4.28137141302858178354417972855117e-03
            2.46739291498785623391043486662966e-01 7.43450929200298094023935391305713e-01 4.28137043451878602368099180353056e-03
            7.43450875758368434631506715959404e-01 9.80976558397046727311163749618572e-03 4.28136536166454344937148945859917e-03
            2.34453465539761568559029569769336e-01 1.25212065221199080750080767643340e-02 4.98949564172988802024377719135373e-03
            1.25212159624579367350749592446846e-02 7.53025327539010524979801175504690e-01 4.98949931659404665590384908568922e-03
            7.53025384905626316012217102979776e-01 2.34453392434268298449850931319816e-01 4.98950249769322326520715193964861e-03
            5.16571129743772089470965624968812e-02 5.77757501193756767277065478083387e-02 5.10627260057649242502852970915228e-03
            5.77758193667164202111941051498434e-02 8.90567064125437068966562037530821e-01 5.10627524759000965548505490687603e-03
            8.90567194917750382110455120709958e-01 5.16569496852326212610329037033807e-02 5.10626983950075198637197360085338e-03
            1.59791125061900518566915252449689e-02 4.13443247683559167438005488293129e-01 7.04073382268429089070327364652258e-03
            4.13443261309727971841709859290859e-01 5.70577625472078464596847879874986e-01 7.04073434970744517491514358198401e-03
            5.70577597706886541217841113393661e-01 1.59791161057934658074053402287973e-02 7.04073372383285170372779759873083e-03
            3.96856249731830756921624470123788e-01 1.67626482477742817789323481747488e-02 7.31496003599158874097785343337819e-03
            1.67626502257961773612038314240635e-02 5.86381091244488561464720532967476e-01 7.31496182529749183753864372192766e-03
            5.86381123891194455666209250921384e-01 3.96856228163050439583514616970206e-01 7.31496204446115648456494540141648e-03
            1.40368578298825791295101339528628e-01 5.03998899802897762367770440050663e-02 8.02823717739924343217428059915619e-03
            5.03999622891451101724946681770234e-02 8.09231429420804393437549606460379e-01 8.02824167196676888313966458099458e-03
            8.09231545448009126353383635432692e-01 1.40368456667959051742400333750993e-01 8.02824738742507343358667526445061e-03
            4.86458021470726476032098162249895e-02 1.53602435235486750597644345361914e-01 8.51217272687783237106184941467291e-03
            1.53602501486405723651884613900620e-01 7.97751700040076339170980190829141e-01 8.51217172309876903002479053839124e-03
            7.97751821638013391968513587926282e-01 4.86457042544259365968173369765282e-02 8.51216838546291904021856566942006e-03
            6.75455296003345112554328011356120e-02 2.93562763267696591462652122572763e-01 1.24778725807735534764075779889936e-02
            2.93562815361712137196548155770870e-01 6.38891644704477568161848921590718e-01 1.24778766420405376469382474624581e-02
            6.38891715657272207806727237766609e-01 6.75455106829575269156151762217632e-02 1.24778728336622790617838063553791e-02
            1.60475924195126878890604871230607e-01 2.76119726602889581368316385123762e-01 1.40995757871014947004706385769168e-02
            2.76119919814122483092688753458788e-01 5.63404080925371975041571204201318e-01 1.40995945247351563839321997306797e-02
            5.63404080925371975041571204201318e-01 1.60475943078972893562905710496125e-01 1.40995883359170178644736992623621e-02
            2.80462494123582872784794517428963e-01 7.72798169129284839851123933840427e-02 1.41352938794588166987464816770625e-02
            7.72798476080368140772591800669034e-02 6.42257629182079847751651868748013e-01 1.41352983913212177508045286344895e-02
            6.42257731649287122444036413071444e-01 2.80462425269744686229245189679204e-01 1.41352990576473335621043858623125e-02
            1.47356656075135344918791702184535e-01 1.48012282095027453143742945940176e-01 1.46130641326821294340154722135594e-02
            1.48012388896020280482090925033845e-01 7.04630946772243804687718693458010e-01 1.46130722641734742822672288298236e-02
            7.04630995778554591879583313129842e-01 1.47356574993519673366648703449755e-01 1.46130732567871183397167911266479e-02
            4.24740426214290034412357499604695e-01 2.08953868767089018243510167849308e-01 1.70034828558818622290527144969019e-02
            2.08953731775949336224584840238094e-01 3.66305584744693935039805410269764e-01 1.70034876864141523689077928338520e-02
            3.66305807793043392006637759550358e-01 4.24740413497297630840421334141865e-01 1.70034756436661833867152182619975e-02
            4.51724222556604049216844032343943e-01 8.70333698449567150223771250239224e-02 1.71178294782583437227962974702677e-02
            8.70333625302085328589996038317622e-02 4.61242369666382878712340698257321e-01 1.71178274008436069608674046094166e-02
            4.61242460733382209081554492513533e-01 4.51724181218181475294670690345811e-01 1.71178283731215873098019386588931e-02
            2.88318499660714211429990427859593e-01 1.90229112412624801198290924730827e-01 1.99646339738734600322001000449745e-02
            1.90229156603659105284620522979822e-01 5.21452304852625614373096141207498e-01 1.99646409308296760021228521964076e-02
            5.21452426537516333659993961191503e-01 2.88318431951264997348260976650636e-01 1.99646334242829202876290395352044e-02
            ];
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   66
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.1e-16
        
        xyw=[
            3.69780964055097839671137904815623e-03 7.43579235081241601834634025181003e-02 1.31889556344126353086554370719341e-03
            7.43579235081241601834634025181003e-02 9.21944266851324800704503559245495e-01 1.31889556344126353086554370719341e-03
            9.21944266851324800704503559245495e-01 3.69780964055097839671137904815623e-03 1.31889556344126353086554370719341e-03
            1.49143992279988854554595434365183e-02 1.36909130733626482889775388684939e-02 1.33745332549837559789340790672441e-03
            1.36909130733626482889775388684939e-02 9.71394687698638459316669013787759e-01 1.33745332549837559789340790672441e-03
            9.71394687698638459316669013787759e-01 1.49143992279988854554595434365183e-02 1.33745332549837559789340790672441e-03
            1.69739996219302907189130369403074e-03 2.08913690615461083988080304152390e-01 1.59651913688176050332145905485959e-03
            2.08913690615461083988080304152390e-01 7.89388909422345963484701769630192e-01 1.59651913688176050332145905485959e-03
            7.89388909422345963484701769630192e-01 1.69739996219302907189130369403074e-03 1.59651913688176050332145905485959e-03
            8.06620839466252737004481332405703e-02 8.24353269029142778079322084749947e-03 2.08534921880513396397205383436813e-03
            8.24353269029142778079322084749947e-03 9.11094383363083348825739449239336e-01 2.08534921880513396397205383436813e-03
            9.11094383363083348825739449239336e-01 8.06620839466252737004481332405703e-02 2.08534921880513396397205383436813e-03
            1.98747901402310800378359090245795e-01 6.97659509618316596435416698795962e-03 2.62960161883945544789020765108489e-03
            6.97659509618316596435416698795962e-03 7.94275503501505997228093747253297e-01 2.62960161883945544789020765108489e-03
            7.94275503501505997228093747253297e-01 1.98747901402310800378359090245795e-01 2.62960161883945544789020765108489e-03
            3.46702719147276405831092915832414e-01 9.05977135347985074176335729134735e-03 3.59422250399369291526396885672057e-03
            9.05977135347985074176335729134735e-03 6.44237509499243632404841264360584e-01 3.59422250399369291526396885672057e-03
            6.44237509499243632404841264360584e-01 3.46702719147276405831092915832414e-01 3.59422250399369291526396885672057e-03
            4.86346333871042757479585816327017e-02 5.57910529717466976973305747833365e-02 4.47939134603269999146402113865406e-03
            5.57910529717466976973305747833365e-02 8.95574313641149033493604747491190e-01 4.47939134603269999146402113865406e-03
            8.95574313641149033493604747491190e-01 4.86346333871042757479585816327017e-02 4.47939134603269999146402113865406e-03
            1.28318629849446304985738365189718e-02 3.44692548477970428510985811954015e-01 4.62436269356279738840242998776375e-03
            3.44692548477970428510985811954015e-01 6.42475588537084973950186395086348e-01 4.62436269356279738840242998776375e-03
            6.42475588537084973950186395086348e-01 1.28318629849446304985738365189718e-02 4.62436269356279738840242998776375e-03
            2.93595389942205159394816860185529e-02 1.39964110318391732334930566139519e-01 5.03712312424570499147513658044772e-03
            1.39964110318391732334930566139519e-01 8.30676350687387765603375555656385e-01 5.03712312424570499147513658044772e-03
            8.30676350687387765603375555656385e-01 2.93595389942205159394816860185529e-02 5.03712312424570499147513658044772e-03
            4.90788394693759288944789886954823e-01 4.95822517789664629628276770745288e-01 5.11503744322468461430686303970106e-03
            4.95822517789664629628276770745288e-01 1.33890875165761369380845735577168e-02 5.11503744322468461430686303970106e-03
            1.33890875165761369380845735577168e-02 4.90788394693759288944789886954823e-01 5.11503744322468461430686303970106e-03
            1.38618784059788779927657742518932e-01 4.47076793855018736478790231103631e-02 6.36860809368266795466029250860629e-03
            4.47076793855018736478790231103631e-02 8.16673536554709311729993714834563e-01 6.36860809368266795466029250860629e-03
            8.16673536554709311729993714834563e-01 1.38618784059788779927657742518932e-01 6.36860809368266795466029250860629e-03
            2.63897606352200997381629576921114e-01 4.36720952517550692340009277359059e-02 7.06349077572058971913326885783135e-03
            4.36720952517550692340009277359059e-02 6.92430298396043975017732918786351e-01 7.06349077572058971913326885783135e-03
            6.92430298396043975017732918786351e-01 2.63897606352200997381629576921114e-01 7.06349077572058971913326885783135e-03
            4.55911744930610901560541492472112e-02 2.45218573506195719469147320523916e-01 7.66638720777674306100513135220353e-03
            2.45218573506195719469147320523916e-01 7.09190252000743259763737569301156e-01 7.66638720777674306100513135220353e-03
            7.09190252000743259763737569301156e-01 4.55911744930610901560541492472112e-02 7.66638720777674306100513135220353e-03
            3.94010358537068061668406926401076e-01 5.92769337816446834077410699137545e-02 9.57549415223419089771006440514611e-03
            5.92769337816446834077410699137545e-02 5.46712707681287324312791042757453e-01 9.57549415223419089771006440514611e-03
            5.46712707681287324312791042757453e-01 3.94010358537068061668406926401076e-01 9.57549415223419089771006440514611e-03
            1.06867206940964756811673908032390e-01 1.28325526947980300684903909314016e-01 9.79068792555368855312636355847644e-03
            1.28325526947980300684903909314016e-01 7.64807266111054984136785606096964e-01 9.79068792555368855312636355847644e-03
            7.64807266111054984136785606096964e-01 1.06867206940964756811673908032390e-01 9.79068792555368855312636355847644e-03
            2.20575279425483411488428941993334e-01 1.13275821301684689879074596774444e-01 1.12596074363941634627339638541343e-02
            1.13275821301684689879074596774444e-01 6.66148899272831940265859884675592e-01 1.12596074363941634627339638541343e-02
            6.66148899272831940265859884675592e-01 2.20575279425483411488428941993334e-01 1.12596074363941634627339638541343e-02
            1.23653835041298731933778753955266e-01 2.42720437216092432830549796562991e-01 1.18720440268093602870225211631805e-02
            2.42720437216092432830549796562991e-01 6.33625727742608724213368986966088e-01 1.18720440268093602870225211631805e-02
            6.33625727742608724213368986966088e-01 1.23653835041298731933778753955266e-01 1.18720440268093602870225211631805e-02
            7.13348794100979594068334677103849e-02 3.87908478942486534268851983142667e-01 1.22562901173755151029709509202803e-02
            3.87908478942486534268851983142667e-01 5.40756641647415436935375510074664e-01 1.22562901173755151029709509202803e-02
            5.40756641647415436935375510074664e-01 7.13348794100979594068334677103849e-02 1.22562901173755151029709509202803e-02
            2.24126910324971617693989855979453e-01 2.13289800009618973897218552338018e-01 1.23407368011343963887238572851857e-02
            2.13289800009618973897218552338018e-01 5.62583289665409380653215976053616e-01 1.23407368011343963887238572851857e-02
            5.62583289665409380653215976053616e-01 2.24126910324971617693989855979453e-01 1.23407368011343963887238572851857e-02
            3.51619049955642692939505877802731e-01 1.37937509976456512683640198702051e-01 1.34838314599763416795630277533746e-02
            1.37937509976456512683640198702051e-01 5.10443440067900877643580770381959e-01 1.34838314599763416795630277533746e-02
            5.10443440067900877643580770381959e-01 3.51619049955642692939505877802731e-01 1.34838314599763416795630277533746e-02
            3.60762340567732431306779972146614e-01 4.65125819964767317493681275664130e-01 1.61731054368957315181543066273662e-02
            4.65125819964767317493681275664130e-01 1.74111839467500195688387520931428e-01 1.61731054368957315181543066273662e-02
            1.74111839467500195688387520931428e-01 3.60762340567732431306779972146614e-01 1.61731054368957315181543066273662e-02
            3.11300128982519408449292086515925e-01 2.70073629388671410112010562443174e-01 1.69984272585877484174066154309912e-02
            2.70073629388671410112010562443174e-01 4.18626241628809125927546119783074e-01 1.69984272585877484174066154309912e-02
            4.18626241628809125927546119783074e-01 3.11300128982519408449292086515925e-01 1.69984272585877484174066154309912e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    16   52 5.67e-16    0    0
    18   66 6.11e-16    0    0
    ];

