
function [R]=set_papanicolopulos_II_pre(deg)

% # Rotationally symmetric cubature rules on the triangle
% # The first column is the weight, the remaining columns are the three areal coordinates of one point in the orbit
% # Note that only one point is given per orbit, the other are obtained by even permutation of the coordinates
% #

r=[]; R=[];
subcase=1;

switch deg
    case 10
        switch subcase
            case 1
                % degree: 10  points:  24  orbits: [0, 8]  quality: PI
                r=[1.4711143125265022e-02   1.4583457698929406e-01  1.1398571160097378e-02  8.4276685185060856e-01
                    1.4928593150681595e-02   4.8063935754816450e-01  3.9643706994449101e-03  5.1539627175239059e-01
                    1.4947323548874366e-02   2.8384362149153980e-03  2.3534170704269680e-01  7.6181985674238780e-01
                    1.5357000172646521e-02   2.7382456096225797e-02  4.3399288238870900e-02  9.2921825566490330e-01
                    5.1440501966811599e-02   2.9036991669239250e-01  5.9484989766216527e-02  6.5014509354139098e-01
                    5.5187392917754130e-02   1.0257910434962711e-01  1.4552326855517441e-01  7.5189762709519848e-01
                    7.1717980709822582e-02   8.9138718639893450e-02  3.6893474593389925e-01  5.4192653542620730e-01
                    9.5043397741477517e-02   2.8930618917096717e-01  2.2719614311462367e-01  4.8349766771440916e-01];
        end
    case 11
        switch subcase
            case 1
                % degree: 11  points:  27  orbits: [0, 9]  quality: PI
                r=[1.3807279155821188e-02   3.1732722526593853e-02  3.3815369341710836e-02  9.3445190813169531e-01
                    2.1703235273357904e-02   1.5983735591572859e-01  2.4724830394212861e-02  8.1543781369005855e-01
                    2.7034127752203152e-02   2.9507164313468276e-02  1.6940387614133596e-01  8.0108895954519577e-01
                    2.7331241653935741e-02   2.2822576496584327e-02  3.8290411387830003e-01  5.9427330962511565e-01
                    2.8336285167031157e-02   3.6037416692790262e-01  2.5154943482374846e-02  6.1447088958972253e-01
                    4.8543667126132535e-02   1.5264948856756949e-01  1.3099101797750153e-01  7.1635949345492898e-01
                    5.2887299088776355e-02   3.4869892349833943e-01  1.2098249664481753e-01  5.3031857985684304e-01
                    5.5162253899304421e-02   1.2126384660100323e-01  3.1955600650808107e-01  5.5918014689091570e-01
                    5.8527944216770879e-02   2.7990247037442649e-01  2.6967431411437986e-01  4.5042321551119365e-01];
        end
    case 12
        switch subcase
            case 1
                % degree: 12  points:  31  orbits: [1,10]  quality: PO
                r=[2.1409425726798500e-02   3.3333333333333333e-01  3.3333333333333333e-01  3.3333333333333333e-01
                8.3668178723688683e-05   3.0113195801207517e-02 -9.4716062682497796e-02  1.0646028668812903e+00
                1.2413637067984845e-02   3.2866530321445965e-01  8.0456452092608120e-03  6.6328905157627954e-01
                1.6239945629216765e-02   4.8124921152851294e-02  9.2386192680937782e-01  2.8013152037770881e-02
                2.4194039324984051e-02   1.4285084152736458e-01  3.1019238692720582e-02  8.2612991977991484e-01
                2.6967365586005655e-02   2.0819192514800809e-01  7.6483124674519466e-01  2.6976828106797243e-02
                2.7774427657215122e-02   4.2582582220396572e-01  5.5039569631163680e-01  2.3778481484397477e-02
                4.7016778451345782e-02   3.2386823359308329e-01  7.9851341494143672e-02  5.9628042491277303e-01
                4.8593414405827091e-02   1.5417640541334422e-01  7.0764795631132814e-01  1.3817563827532764e-01
                5.8505280711050841e-02   3.4938361803935480e-01  5.2486110031263145e-01  1.2575528164801375e-01
                6.4408301078713326e-02   2.9931586764275858e-01  2.2924961529379629e-01  4.7143451706344513e-01];
        end
    case 13
        switch subcase
            case 1
                % degree: 13  points:  36  orbits: [0,12]  quality: PI
                r=[8.0799718922462501e-03   2.6016776102192420e-02  2.4022213893300931e-02  9.4996101000450665e-01
                    1.2892029137773462e-02   1.8883631298672999e-02  1.2208083167169181e-01  8.5903553702963519e-01
                    1.6560237922093254e-02   1.3163917121880552e-01  2.2874705099001900e-02  8.4548612368219258e-01
                    1.9023135868897032e-02   2.0731528553134731e-02  2.8073779660838987e-01  6.9853067483847539e-01
                    1.9359657480323248e-02   4.7664289518446955e-01  5.0484945619579673e-01  1.8507648619733713e-02
                    1.9583798359223863e-02   3.0238695445079381e-01  1.9975752788321420e-02  6.7763729276088477e-01
                    3.0281493825968992e-02   1.0153977972399897e-01  1.1902821597585498e-01  7.7943200430014606e-01
                    3.8164066479861485e-02   2.4961442779733522e-01  1.0358996690547731e-01  6.4679560529718747e-01
                    3.8199338317111096e-02   1.0202924054306213e-01  2.7688825736351557e-01  6.2108250209342230e-01
                    4.0847152891851065e-02   2.2678927602203703e-01  2.3372837421755475e-01  5.3948234976040822e-01
                    4.1085695986564895e-02   4.3740951791107844e-01  9.5992093320339565e-02  4.6659838876858199e-01
                    4.9256755171418690e-02   3.8075857916224453e-01  2.2785535711866886e-01  3.9138606371908661e-01];
        end
    case 14
        switch subcase
            case 1
                % degree: 14  points:  40  orbits: [1,13]  quality: PO
                r=[1.7219601997330804e-02   3.3333333333333333e-01  3.3333333333333333e-01  3.3333333333333333e-01
                    1.2234370324430286e-03   1.2237951552984698e-01 -2.2116463863324700e-02  8.9973694833347772e-01
                    5.6258060653080681e-03   2.5691992957650386e-01  7.4296194517695190e-01  1.1812524654424182e-04
                    6.1803448724676207e-03   2.2412698148715271e-02  2.1296338767865062e-02  9.5629096308341967e-01
                    1.0957697357972611e-02   1.0798361586547704e-01  8.7360548159491952e-01  1.8410902539603444e-02
                    1.1462343010639779e-02   4.5439914870970863e-01  8.4021188904826007e-03  5.3719873239980877e-01
                    2.2295784039866406e-02   2.6093699885015353e-01  2.5735252088220618e-02  7.1332774906162586e-01
                    2.3382863187460198e-02   1.0865181340319861e-01  4.7317979503788451e-02  8.4403020709301294e-01
                    2.6558067295112076e-02   3.6315118499871290e-01  6.0034034591339777e-01  3.6508469087889329e-02
                    3.0850488270755880e-02   1.8807008851943477e-01  7.4193352129130693e-01  6.9996390189258298e-02
                    4.0681051448570317e-02   3.9396304707724486e-01  8.3219241365617293e-02  5.2281771155713784e-01
                    4.3652397747231077e-02   2.0428642734395071e-01  1.3728033930118570e-01  6.5843323335486358e-01
                    5.0893743280552757e-02   3.1551192268626972e-01  5.3337656735860289e-01  1.5111150995512739e-01
                    5.3829442392509915e-02   3.2402330092311278e-01  2.2810272652355670e-01  4.4787397255333052e-01];
        end
    case 15
        switch subcase
            case 1
                % degree: 15  points:  46  orbits: [1,15]  quality: PI
                r=[4.6749612087783112e-02   3.3333333333333333e-01  3.3333333333333333e-01  3.3333333333333333e-01
                    5.0278560972481463e-03   1.8434795476156616e-02  2.1020578568986589e-02  9.6054462595485680e-01
                    7.5986819401049491e-03   9.4469391541665798e-02  1.4008492164338544e-02  8.9152211629399566e-01
                    1.0732119583647835e-02   2.2105953725731282e-01  1.4600157192749056e-02  7.6434030554993812e-01
                    1.0830851965744705e-02   1.8316125580224018e-02  1.0683143253847732e-01  8.7485244188129866e-01
                    1.2248727250486568e-02   3.8411182081140653e-01  1.3506565318991916e-02  6.0238161386960155e-01
                    1.4397839583790738e-02   1.7609576799084838e-02  2.4686944042402646e-01  7.3552098277688870e-01
                    1.4983807152201953e-02   1.6211104266107674e-02  4.2002732343586756e-01  5.6376157229802477e-01
                    1.9232683397058455e-02   9.4583522597997614e-02  7.8193785237664135e-02  8.2722269216433825e-01
                    2.0834684882606197e-02   2.2302054118668645e-01  6.9024652212795669e-02  7.0795480660051788e-01
                    2.8576965678339240e-02   9.1368633556670844e-02  1.9744162005839791e-01  7.1118974638493124e-01
                    2.9031677885589069e-02   3.8453093605192732e-01  7.3097762126704492e-02  5.4237130182136819e-01
                    3.0240283270453857e-02   2.1503874179825227e-01  1.5589306185405327e-01  6.2906819634769445e-01
                    3.2511521853897151e-02   8.5318970181728559e-02  3.5900755344806651e-01  5.5567347637020493e-01
                    4.0187126563651816e-02   2.0423041220511114e-01  2.8615721494302878e-01  5.0961237285186008e-01
                    4.1315302199251619e-02   3.6389089896392433e-01  1.8108597386179941e-01  4.5502312717427626e-01];
        end
    case 16
        switch subcase
            case 1
                % degree: 16  points:  51  orbits: [0,17]  quality: PO
                r=[2.6584042558591993e-03   2.6023443494547536e-01 -7.7960753911714191e-03  7.4756164044569606e-01
                    3.3996223032543512e-03   8.7654435676472866e-02  9.0944387153089968e-01  2.9016927926274576e-03
                    3.5191090034989178e-03   3.0067304757784228e-01  7.0038809708394579e-01 -1.0611446617880644e-03
                    4.0441404117086600e-03   1.8849925360918681e-02  1.6472917542654607e-02  9.6467715709642671e-01
                    6.8294711512590654e-03   9.8416684250052989e-02  1.1941006711737949e-02  8.8964230903820906e-01
                    1.0440167558510118e-02   4.6040301696118247e-01  1.1787969349285804e-02  5.2780901368953173e-01
                    1.4730712491919611e-02   7.3829911003045558e-02  8.6868121096049366e-01  5.7488878036460780e-02
                    1.4997188989449286e-02   1.8610993333739586e-01  7.8796285305688458e-01  2.5927213605719563e-02
                    1.6563214492522717e-02   3.8320231828647306e-01  5.8855734984388638e-01  2.8240331869640557e-02
                    1.9748195843965540e-02   1.8610788752983732e-01  4.2129359575999841e-02  7.7176275289416284e-01
                    2.1203128918974853e-02   3.2943567008468773e-01  3.8398059357352491e-02  6.3216627055795978e-01
                    2.4448645222118130e-02   2.7205732589540689e-01  6.5105170913107424e-01  7.6890964973518874e-02
                    2.8149869751438747e-02   1.4123538065593751e-01  7.2939931701324416e-01  1.2936530233081833e-01
                    3.6902116480954728e-02   4.4901563513616993e-01  9.7621841960191711e-02  4.5336252290363835e-01
                    3.7047736203275152e-02   2.6679836751316865e-01  1.3739927089093514e-01  5.9580236159589621e-01
                    4.1332532979016103e-02   2.8238245710611228e-01  5.3491733004439061e-01  1.8270021284949711e-01
                    4.7319077275608154e-02   3.4974732138010475e-01  2.3813215085067586e-01  4.1212052776921939e-01];
                
            case 2
                % degree: 16  points:  52  orbits: [1,17]  quality: PI
                r=[3.6632403806727083e-02   3.3333333333333333e-01  3.3333333333333333e-01  3.3333333333333333e-01
                    3.5443048770430208e-03   1.5961011713106843e-02  1.6883125432529632e-02  9.6715586285436352e-01
                    4.0175883370409122e-03   3.8219308417185390e-03  9.9349672744069328e-02  8.9682839641421213e-01
                    4.1907200912961009e-03   9.2621730805488502e-02  4.7177504781192514e-03  9.0266051871639225e-01
                    8.5627826851592166e-03   9.8098497053844667e-03  2.4673891829167553e-01  7.4345123200294000e-01
                    9.9790078170497496e-03   2.3445355549323997e-01  1.2521221333540609e-02  7.5302522317321943e-01
                    1.0212563539778776e-02   5.1657391379326425e-02  5.7775785013584749e-02  8.9056682360708883e-01
                    1.4081474710639794e-02   1.5979112409302035e-02  4.1344293672630828e-01  5.7057795086438969e-01
                    1.4629924655641395e-02   3.9685647522283097e-01  1.6762640234766529e-02  5.8638088454240250e-01
                    1.6056466268479736e-02   1.4036886341620637e-01  5.0400029219950292e-02  8.0923110736384334e-01
                    1.7024341971022633e-02   4.8646064695551551e-02  1.5360246929131848e-01  7.9775146601312997e-01
                    2.4955767639171516e-02   6.7545698927945352e-02  2.9356271866503074e-01  6.3889158240702391e-01
                    2.8199116717009405e-02   1.6047619247173852e-01  2.7611972660288958e-01  5.6340408092537191e-01
                    2.8270578986067097e-02   2.8046271373091425e-01  7.7279834362078528e-02  6.4225745190700722e-01
                    2.9226110917024205e-02   1.4735692525659394e-01  1.4801238883904978e-01  7.0463068590435628e-01
                    3.4006909002989113e-02   4.2474074664756896e-01  2.0895363610614196e-01  3.6630561724628908e-01
                    3.4235623800026055e-02   4.5172438307089812e-01  8.7033324580191018e-02  4.6124229234891086e-01
                    3.9929250048985580e-02   2.8831873591736208e-01  1.9022911957088944e-01  5.2145214451174848e-01];
        end
    case 17
        switch subcase
            case 1
                % degree: 17  points:  57  orbits: [0,19]  quality: PI
                r=[3.3770360080995287e-03   1.4720966195626591e-02  1.7639984855506733e-02  9.6763904894886668e-01
                    3.8199256701939296e-03   7.5827872337699793e-02  7.6974758437722558e-03  9.1647465181852795e-01
                    6.6240260814413473e-03   3.1058551655846398e-01  8.3200919510460479e-03  6.8109439149048998e-01
                    7.2849007348734792e-03   1.4488314624940400e-02  9.0164039580071321e-02  8.9534764579498828e-01
                    9.9650024734054052e-03   1.7814385225301997e-01  1.6423858046515613e-02  8.0543228970046441e-01
                    1.0276345098595948e-02   4.6613355079593469e-01  1.2335581768737785e-02  5.2153086743532753e-01
                    1.0309491303777179e-02   1.4736566166282276e-02  2.0932517115745764e-01  7.7593826267626008e-01
                    1.1602229136800220e-02   1.4332535547880318e-02  3.5860231579542370e-01  6.2706514865669598e-01
                    1.2469743787482089e-02   7.5303349390642165e-02  5.5968132994742076e-02  8.6872851761461576e-01
                    1.9632479515531950e-02   3.1733939350172784e-01  5.1694878418799497e-02  6.3096572807947266e-01
                    2.0101507075145188e-02   7.5354265490354561e-02  1.5459821166573010e-01  7.7004752284391534e-01
                    2.0906045568565135e-02   1.8257077444087677e-01  2.6653005963514674e-01  5.5089916592397649e-01
                    2.1332247671603719e-02   1.7971003272207474e-01  8.1586227754905889e-02  7.3870373952301937e-01
                    2.3749377189184673e-02   1.7580794171567717e-01  1.8035364052078594e-01  6.4383841776353688e-01
                    2.4777024008132020e-02   4.5873149968878349e-01  4.7412600771932672e-01  6.7142492591889786e-02
                    2.5585570242272616e-02   7.5319692074374350e-02  2.9375410536296778e-01  6.3092620256265787e-01
                    3.1310858803301155e-02   1.6330517792538480e-01  3.8425118776594167e-01  4.5244363430867353e-01
                    3.1590362549437516e-02   3.1181356869961462e-01  1.3950152599660816e-01  5.4868490530377721e-01
                    3.8619160415490236e-02   3.0604825911202794e-01  2.6772065354596206e-01  4.2623108734201000e-01];
        end
    case 18
        switch subcase
            case 1
                % degree: 18  points:  64  orbits: [1,21]  quality: NI
                r=[-1.2584522158487324e-01   3.3333333333333333e-01  3.3333333333333333e-01  3.3333333333333333e-01
                    1.2972711052469131e-03   9.2243717701637303e-03  9.5403763890216923e-03  9.8123525184081458e-01
                    4.4043445159056776e-03   1.1588174868222537e-02  5.9910234445416971e-02  9.2850159068636049e-01
                    4.5538027787717870e-03   1.3710944923248681e-01  8.1342322238399217e-03  8.5475631854367326e-01
                    5.2522116874830075e-03   5.4074658130232204e-02  1.5964034865851205e-02  9.2996130700391659e-01
                    7.3746378722098512e-03   1.2356208531742393e-02  1.5632145821478534e-01  8.3132233325347227e-01
                    8.8347868725932359e-03   2.5444301078665216e-01  1.3228036080597975e-02  7.3232895313274987e-01
                    9.6477764248827312e-03   1.2200654548168253e-02  4.3851807730182484e-01  5.4928126815000691e-01
                    9.8670997804213447e-03   3.9559271713540309e-01  1.2905266057921207e-02  5.9150201680667570e-01
                    1.0260713189231745e-02   1.3989490384594665e-02  2.8757843019601676e-01  6.9843207941938858e-01
                    1.1796695983077324e-02   6.1242622253631033e-02  8.2131031407759842e-02  8.5662634633860912e-01
                    1.2985507535111396e-02   1.4018729428171406e-01  5.0988464618207705e-02  8.0882424110007823e-01
                    1.6318205824572777e-02   6.5953460657672494e-02  1.8230645755123918e-01  7.5174008179108833e-01
                    1.7525616506223077e-02   6.2413944208807554e-02  4.1171546934984561e-01  5.2587058644134683e-01
                    1.8411831442871156e-02   7.4301715278995184e-02  2.9370394461286521e-01  6.3199434010813960e-01
                    1.9068970594065069e-02   2.5575842907678069e-01  6.8183146863573470e-02  6.7605842405964584e-01
                    2.0582184685952944e-02   3.8974889800275021e-01  6.6997893569429194e-02  5.4325320842782059e-01
                    2.3589141249305486e-02   1.5516843299002956e-01  1.4008668235066955e-01  7.0474488465930089e-01
                    3.1090952263188075e-02   1.7047292786075018e-01  2.6125400206085544e-01  5.6827307007839437e-01
                    3.2039966987225443e-02   2.8646919654918206e-01  1.6305389426422914e-01  5.5047690918658880e-01
                    3.2660417772954837e-02   1.5507903214893105e-01  4.0849692015535077e-01  4.3642404769571818e-01
                    7.7719605456997205e-02   3.0640947365131940e-01  3.0433359769752270e-01  3.8925692865115790e-01];
                
            case 2
                % degree: 18 points:  66  orbits: [0,22]  quality: PI
                r=[2.6377911268825265e-03   3.6978096405509783e-03  7.4357923508124163e-02  9.2194426685132486e-01
                    2.6749066509967509e-03   1.4914399227998886e-02  1.3690913073362649e-02  9.7139468769863847e-01
                    3.1930382737635201e-03   1.6973999621930291e-03  2.0891369061546108e-01  7.8938890942234589e-01
                    4.1706984376102670e-03   8.0662083946625274e-02  8.2435326902914273e-03  9.1109438336308330e-01
                    5.2592032376789104e-03   1.9874790140231079e-01  6.9765950961831656e-03  7.9427550350150604e-01
                    7.1884450079873845e-03   3.4670271914727642e-01  9.0597713534798509e-03  6.4423750949924373e-01
                    8.9587826920653980e-03   4.8634633387104275e-02  5.5791052971746700e-02  8.9557431364114902e-01
                    9.2487253871255923e-03   1.2831862984944631e-02  3.4469254847797041e-01  6.4247558853708496e-01
                    1.0074246248491408e-02   2.9359538994220516e-02  1.3996411031839172e-01  8.3067635068738777e-01
                    1.0230074886449367e-02   4.9078839469375929e-01  4.9582251778966465e-01  1.3389087516576057e-02
                    1.2737216187365332e-02   1.3861878405978878e-01  4.4707679385501873e-02  8.1667353655470934e-01
                    1.4126981551441176e-02   2.6389760635220097e-01  4.3672095251755070e-02  6.9243029839604396e-01
                    1.5332774415553482e-02   4.5591174493061089e-02  2.4521857350619572e-01  7.0919025200074319e-01
                    1.9150988304468377e-02   3.9401035853706806e-01  5.9276933781644686e-02  5.4671270768128725e-01
                    1.9581375851107372e-02   1.0686720694096476e-01  1.2832552694798029e-01  7.6480726611105495e-01
                    2.2519214872788323e-02   2.2057527942548341e-01  1.1327582130168469e-01  6.6614889927283190e-01
                    2.3744088053618715e-02   1.2365383504129873e-01  2.4272043721609242e-01  6.3362572774260884e-01
                    2.4512580234751025e-02   7.1334879410097966e-02  3.8790847894248656e-01  5.4075664164741547e-01
                    2.4681473602268785e-02   2.2412691032497162e-01  2.1328980000961898e-01  5.6258328966540940e-01
                    2.6967662919952675e-02   3.5161904995564271e-01  1.3793750997645651e-01  5.1044344006790078e-01
                    3.2346210873791458e-02   3.6076234056773244e-01  4.6512581996476733e-01  1.7411183946750023e-01
                    3.3996854517175490e-02   3.1130012898251939e-01  2.7007362938867140e-01  4.1862624162880922e-01];
        end
    case 19
        switch subcase
            case 1
                % degree: 19  points:  70  orbits: [1,23]  quality: PI
                r=[ 3.0462961760147426e-02   3.3333333333333333e-01  3.3333333333333333e-01  3.3333333333333333e-01
                    1.9501819580656993e-03   1.0376656545701755e-02  1.4481047265899899e-02  9.7514229618839835e-01
                    2.7619446171731757e-03   5.2895640212959190e-02  8.9271173425645345e-03  9.3817724244447628e-01
                    3.5331794317329432e-03   1.3094057146527934e-01  6.3960635617080464e-03  8.6266336497301261e-01
                    5.1520290776901399e-03   1.2668186551090302e-02  7.2908235059904131e-02  9.1442357838900557e-01
                    7.3117101662705458e-03   2.4661396010476736e-01  1.1321028448271661e-02  7.4206501144696098e-01
                    7.3894730517619438e-03   1.2433000096283946e-02  1.7150720385727521e-01  8.1605979604644085e-01
                    7.5477860526761398e-03   9.4587086792603847e-03  4.5455308365694877e-01  5.3598820766379085e-01
                    7.6154684066760231e-03   3.8267712743290074e-01  1.0304127159604518e-02  6.0701874540749474e-01
                    7.9007581331291056e-03   1.0722190231133363e-02  3.0281941897786346e-01  6.8645839079100317e-01
                    8.2104395329240184e-03   6.3458887217335529e-02  4.7982682558826823e-02  8.8855843022383765e-01
                    1.0631666580804145e-02   1.4958534166780134e-01  4.1535364284310521e-02  8.0887929404788814e-01
                    1.4518063122052105e-02   6.5938374993168378e-02  1.2709830130649976e-01  8.0696332370033186e-01
                    1.4694113731911951e-02   4.1936034447469360e-01  4.8413394484357993e-02  5.3222626104094841e-01
                    1.6869911193356550e-02   5.1285971562743751e-02  3.8545151944759559e-01  5.6326250898966065e-01
                    1.7219169524637743e-02   5.9216171712594003e-02  2.4426337874091409e-01  6.9652044954649190e-01
                    1.7491674145470796e-02   1.5774435365253488e-01  1.0703910299909378e-01  7.3521654334837135e-01
                    1.8291477800298232e-02   2.7635637145129316e-01  5.9395829650746022e-02  6.6424779889796081e-01
                    2.1089355502457149e-02   4.0292543250410291e-01  1.1125969746384887e-01  4.8581487003204821e-01
                    2.3029171331062760e-02   1.4474120951067008e-01  2.0733708666187715e-01  6.4792170382745277e-01
                    2.4934188451324881e-02   1.2800219617071517e-01  3.3880397181433681e-01  5.3319383201494802e-01
                    2.5956134949103396e-02   2.6733402095713007e-01  1.4787228580357800e-01  5.8479369323929194e-01
                    2.8915516306229338e-02   3.8064039133743355e-01  2.0742134128256491e-01  4.1193826738000155e-01
                    3.0165599679808743e-02   2.4101907410276570e-01  2.6708311799129085e-01  4.9189780790594345e-01];
        end
    case 20
        switch subcase
            case 1
                % degree: 20  points:  78  orbits: [0,26]  quality: PI
                r=[1.1389906148975042e-03   7.9036813416234634e-03  1.0892617666329890e-02  9.8120370099204665e-01
                    1.5357670874582499e-03   3.7026142140495720e-03  5.6835913941912758e-02  9.3946147184403767e-01
                    1.9246855917865366e-03   1.0933739015022848e-01  3.0385925733436735e-03  8.8762401727642785e-01
                    2.5004373123559144e-03   4.2881075376943291e-02  9.8050570254988037e-03  9.4731386759755791e-01
                    2.6307512361876622e-03   1.7747325730732662e-03  2.3669301898277444e-01  7.6153224844415230e-01
                    3.1956256140281530e-03   3.1181457060113711e-01  2.5455197956388258e-03  6.8563990960322406e-01
                    3.6517689940788468e-03   2.9900066046955766e-03  4.6311944115593689e-01  5.3389055223936753e-01
                    5.3245378912169057e-03   3.2214232134941441e-02  5.2485418254685595e-02  9.1530034961037296e-01
                    5.8444560283889411e-03   1.2779960332488103e-02  1.3137953817800015e-01  8.5584050148951175e-01
                    7.3080059801419984e-03   1.9543072338191530e-01  1.4095340079167391e-02  7.9047393653891731e-01
                    7.9063353532919292e-03   9.7766916990501654e-02  3.5000751662894826e-02  8.6723233134660352e-01
                    9.6559578708891257e-03   1.6600662844177816e-02  3.3867675226583791e-01  6.4472258488998427e-01
                    1.0314589003859623e-02   4.1339508218073999e-01  1.8202587826948210e-02  5.6840232999231180e-01
                    1.2209838544262552e-02   6.8329374634159049e-02  1.0867508995456668e-01  8.2299553541127427e-01
                    1.2838682322099243e-02   3.9215307843232454e-02  2.1433843005455051e-01  7.4644626210221703e-01
                    1.4666797697723754e-02   2.8285140438768569e-01  4.3250599724609153e-02  6.7389799588770516e-01
                    1.5405053862365679e-02   1.6314907835570532e-01  7.4632420343531668e-02  7.6221850130076302e-01
                    1.6575593874878298e-02   4.3629058390662197e-01  5.1653707778068928e-01  4.7172338312688749e-02
                    1.9989220381195197e-02   1.2306908733084597e-01  1.7394646430224308e-01  7.0298444836691095e-01
                    2.0297417477507432e-02   8.3257905081074288e-02  2.9918522779730362e-01  6.1755686712162209e-01
                    2.1636690505780495e-02   3.7602894358398858e-01  8.6437944469363946e-02  5.3753311194664748e-01
                    2.3025477362951779e-02   2.3986629094495531e-01  1.3011561089713889e-01  6.3001809815790580e-01
                    2.6323493747772553e-02   1.3722114882399380e-01  3.9101320130295767e-01  4.7176564987304853e-01
                    2.7048097627035000e-02   1.8993213060838091e-01  2.5032134600889317e-01  5.5974652338272592e-01
                    2.8994339729606517e-02   3.2415825639563881e-01  1.9472448888111192e-01  4.8111725472324926e-01
                    3.1390721621573443e-02   3.3086291214705173e-01  4.0744532437685330e-01  2.6169176347609497e-01];
        end
    case 21
        switch subcase
            case 1
                % degree: 21  points:  85  orbits: [1,28]  quality: PI
                r=[1.5927243921705286e-02   3.3333333333333333e-01  3.3333333333333333e-01  3.3333333333333333e-01
                    1.5400248104137987e-03   1.0883381125829185e-02  1.0843736020090887e-02  9.7827288285407993e-01
                    2.9640382112354420e-03   1.3448308201330127e-01  5.8940179144611419e-03  8.5962290007223759e-01
                    3.1425704793797701e-03   5.6069791445608277e-02  9.3407202951554925e-01  9.8581790388424750e-03
                    3.3225577295111817e-03   5.6230797163851621e-02  1.0411168900746122e-02  9.3335803393540226e-01
                    4.0709421276751965e-03   4.9549225054526060e-01  5.3013935392908200e-03  4.9920635591544858e-01
                    4.7065803891413351e-03   1.3341354422143649e-01  8.5650220211325813e-01  1.0084253665305377e-02
                    5.1858802396272144e-03   2.3778885327379537e-01  7.5355383003485144e-01  8.6573166913531893e-03
                    6.0531722729463664e-03   2.3667582268756977e-01  1.0431599868322363e-02  7.5289257744410787e-01
                    6.4973731547806021e-03   3.5923743154358797e-01  9.7744131190851989e-03  6.3098815533732683e-01
                    6.9733241654343347e-03   3.6212379554213158e-01  6.2748273139455278e-01  1.0393473063315642e-02
                    7.2058755893463718e-03   5.4706462526630790e-02  8.9337625860348307e-01  5.1917278869886143e-02
                    8.3650128288707298e-03   1.2849784556464678e-01  3.6812842147870551e-02  8.3468931228748267e-01
                    1.0226596336837780e-02   1.3204562148598842e-01  8.1675054229140627e-01  5.1203836222605304e-02
                    1.1740928736597079e-02   4.8000288746551577e-01  3.4623316765578371e-02  4.8537379576890586e-01
                    1.2183249444133565e-02   2.3569865248618387e-01  7.1763978029460810e-01  4.6661567219208023e-02
                    1.2865489474875409e-02   1.2123545350512091e-01  9.8717289213207958e-02  7.8004725728167113e-01
                    1.3095298262016823e-02   2.2692131253456986e-01  5.3382695673250658e-02  7.1969599179217949e-01
                    1.4086719053342242e-02   3.5272595600222984e-01  5.9395602013861639e-01  5.3318023859153769e-02
                    1.4184030719574420e-02   3.4639476098063524e-01  5.1134367191086911e-02  6.0247087182827785e-01
                    1.7220831567602327e-02   2.0854537617999445e-01  1.2666187408877324e-01  6.6479274973123231e-01
                    1.7413623959356123e-02   1.1664118178749894e-01  1.9358351370774259e-01  6.8977530450475846e-01
                    1.8083675543648466e-02   3.0168173165951112e-01  5.7948556128572696e-01  1.1883270705476192e-01
                    1.9149138766673223e-02   3.5976650509436423e-01  4.6544957877641646e-01  1.7478391612921931e-01
                    1.9227819270612500e-02   3.1772789477972085e-01  1.2192276586456074e-01  5.6034933935571841e-01
                    2.0031676761421527e-02   4.5059923770816621e-01  9.8026080230645232e-02  4.5137468206118855e-01
                    2.0765122861493130e-02   2.6678020887821459e-01  3.0930467163940580e-01  4.2391511948237961e-01
                    2.3815052706389131e-02   2.1491332208551213e-01  2.2361527123160834e-01  5.6147140668287953e-01
                    2.3907646563162151e-02   3.4182082891498582e-01  2.0305957510273218e-01  4.5511959598228199e-01];
        end
    case 22
        switch subcase
            case 1
                % degree: 22  points:  93  orbits: [0,31]  quality: PI
                r=[9.7541204093973730e-04   1.1703384837887285e-03  4.7853691880759079e-02  9.5097596963545219e-01
                    1.3104452211497902e-03   1.0994365574026066e-02  9.1086717537202093e-03  9.7989696267225372e-01
                    1.8193840846492014e-03   1.0681692522528876e-03  2.0270906338792564e-01  7.9622276735982148e-01
                    2.4853897178983417e-03   2.2122835059211035e-03  4.2176907067146540e-01  5.7601864582261350e-01
                    2.7943057624271765e-03   5.7202598716253463e-02  8.5608709992095844e-03  9.3423653028453695e-01
                    3.5481485720115001e-03   3.5302421161527683e-01  6.0942412505558904e-03  6.4088154713416728e-01
                    3.7786266563183755e-03   1.3678895783915383e-01  7.8499806284800861e-03  8.5536106153236609e-01
                    4.0382662850397443e-03   2.4120956376003772e-01  7.0272635517203284e-03  7.5176317268824195e-01
                    4.6332135930233676e-03   1.1673747786687883e-02  1.1264121642953521e-01  8.7568503578377690e-01
                    4.9307263403021445e-03   3.0114899634799296e-02  4.6055896520382443e-02  9.2382920384481826e-01
                    6.4157039907774682e-03   4.5650015438745406e-01  1.1437907707031122e-02  5.3206193790551482e-01
                    6.6484250441469278e-03   1.1807594618901865e-02  3.0499692169056033e-01  6.8319548369053781e-01
                    7.9373544556883367e-03   9.6150558730147031e-02  4.2635231869026163e-02  8.6121420940082681e-01
                    9.3918256712032127e-03   3.0637657499207940e-02  1.9699058002570907e-01  7.7237176247508299e-01
                    9.7665846237909512e-03   1.9481524443080609e-01  3.8664167437872396e-02  7.6652058813132152e-01
                    9.9393122364192576e-03   6.0365503070241096e-02  1.0661022068914792e-01  8.3302427624061099e-01
                    1.0785717950341074e-02   3.1509089948205937e-01  3.6089820174339140e-02  6.4881928034360149e-01
                    1.1198713817120031e-02   4.1135836721581721e-01  5.5639035396185562e-01  3.2251278822327165e-02
                    1.3592449250673841e-02   1.4402035063048923e-01  9.7715590184512755e-02  7.5826405918499801e-01
                    1.4107287313162501e-02   4.2075770910212188e-01  5.5528837489452673e-02  5.2371345340842545e-01
                    1.4345498985919949e-02   6.0949899580789658e-02  2.9205601614107289e-01  6.4699408427813745e-01
                    1.5033144681114326e-02   9.6935106445587494e-02  1.8422415689190805e-01  7.1884073666250445e-01
                    1.5837677803805629e-02   2.5378346562064697e-01  9.2228684901440236e-02  6.5398784947791279e-01
                    1.7114505548266754e-02   3.4886710140216274e-01  1.1623555207070974e-01  5.3489734652712752e-01
                    1.7971291100638843e-02   1.9058155865307421e-01  1.7214824666674493e-01  6.3727019468018085e-01
                    1.8545033196902469e-02   9.6988114334812798e-02  3.9655213150862648e-01  5.0645975415656073e-01
                    1.9398111246358062e-02   1.4126633463063171e-01  2.7537965024518302e-01  5.8335401512418527e-01
                    1.9523670586401506e-02   4.1201810197995222e-01  1.6857388429008831e-01  4.1940801372995947e-01
                    2.0625531969637040e-02   2.7620933906532143e-01  1.9919935637318402e-01  5.2459130456149455e-01
                    2.1313822420182855e-02   2.1861061467249740e-01  3.0568565104773044e-01  4.7570373427977216e-01
                    2.3527753167022922e-02   3.3679904631184635e-01  2.6981434578199104e-01  3.9338660790616262e-01];
        end
    case 23
        switch subcase
            case 1
                % degree: 23  points:  100  orbits: [1,33]  quality: PI
                r=[2.5138871460293689e-02   3.3333333333333333e-01  3.3333333333333333e-01  3.3333333333333333e-01
                    1.0661176825060275e-03   9.4139490330046097e-03  8.6464444518944775e-03  9.8193960651510091e-01
                    1.1098731505548911e-03   4.8241021890889083e-04  1.0882142058056086e-01  8.9069616920053025e-01
                    1.6296239556456284e-03   4.9633556562943612e-01  5.0329473593098172e-01  3.6969843958216395e-04
                    2.2052916931377744e-03   8.6145275902432508e-03  4.4964858940933155e-02  9.4642061346882359e-01
                    2.3175543197966386e-03   4.9100663468775803e-02  8.2424970824296988e-03  9.4265683944879450e-01
                    2.3216387016154018e-03   2.6604160773538741e-03  2.9470448202172090e-01  7.0263510190092523e-01
                    3.0036615113955653e-03   3.3098446926941211e-01  3.8206684917989275e-03  6.6519486223878896e-01
                    3.5476219235374645e-03   1.1815450592101939e-01  8.4131574146606560e-03  8.7343233666431995e-01
                    3.8026516365470239e-03   2.1407309787902889e-01  7.2053975765022518e-03  7.7872150454446886e-01
                    4.7343247026569425e-03   4.4577412877333657e-02  4.3026357023085332e-02  9.1239623009958101e-01
                    4.7820455294484822e-03   1.9143139515349088e-01  3.1169269889860297e-02  7.7739933495664883e-01
                    5.0549201673000699e-03   1.0585098456769080e-02  1.9186490304827739e-01  7.9754999849495353e-01
                    6.0452061344839151e-03   2.5420226429005639e-02  1.0540760648009683e-01  8.6917216709089753e-01
                    6.3127024456898286e-03   5.9129291976109599e-01  1.2107289245252150e-02  3.9659979099365186e-01
                    6.7764054871379987e-03   1.0490365652094102e-01  4.3370975391949559e-02  8.5172536808710942e-01
                    7.8847924276325516e-03   4.2721744601873479e-01  1.6697078855470620e-02  5.5608547512579459e-01
                    8.7369076407474777e-03   1.7789929675087990e-01  6.4511068023700172e-02  7.5758963522541993e-01
                    9.4344058539933377e-03   8.0548215582571540e-02  1.0197699396951581e-01  8.1747479044791265e-01
                    9.4908794278192791e-03   3.1317311279855046e-02  2.8534297804565592e-01  6.8333971067448903e-01
                    1.0210962656217749e-02   2.9544675874255425e-01  3.2881012535433060e-02  6.7167222872201269e-01
                    1.0519253335485041e-02   5.4113217353947929e-02  1.8385958270294380e-01  7.6202719994310827e-01
                    1.1689120375277516e-02   4.2740065428049017e-02  4.4355898660390500e-01  5.1370094796804599e-01
                    1.3700400279401443e-02   1.4518767597337788e-01  1.2979545045100729e-01  7.2501687357561483e-01
                    1.4460451299082753e-02   7.4713978478763847e-02  3.2991396142531470e-01  5.9537206009592145e-01
                    1.5231395783588919e-02   3.8196804313044813e-01  6.7362527515130420e-02  5.5066942935442145e-01
                    1.5485873319445833e-02   2.2178354982181475e-01  6.6898098435814961e-01  1.0923546582003564e-01
                    1.5988957436554496e-02   2.5687081151314684e-01  9.6049121135374792e-02  6.4708006735147837e-01
                    1.8929035905891644e-02   1.1275130342695996e-01  4.2367418202458158e-01  4.6357451454845846e-01
                    1.9748081356734056e-02   2.1032305744103352e-01  1.8700110967233269e-01  6.0267583288663379e-01
                    2.0667781559665955e-02   1.6157520917947662e-01  2.9901294845569945e-01  5.3941184236482393e-01
                    2.0798342664795103e-02   3.3165622135557483e-01  1.5061623551001872e-01  5.1772754313440645e-01
                    2.3575574840744130e-02   2.1229476331689120e-01  3.8427148525251238e-01  4.0343375143059642e-01
                    2.3691854308704501e-02   2.7411374218935068e-01  2.5872672300217802e-01  4.6715953480847130e-01];
        end
    case 24
        switch subcase
            case 1
                % degree: 24  points:  109  orbits: [1,36]  quality: PI
                r=[1.0681776933386817e-02   3.3333333333333333e-01  3.3333333333333333e-01  3.3333333333333333e-01
                    3.4307213843404004e-04   7.2774421822864240e-03  1.8717806316108168e-03  9.9085077718610276e-01
                    1.2229997020374074e-03   9.3762141740159574e-02  2.2258417763076133e-03  9.0401201648353281e-01
                    1.6381602736491939e-03   2.7549956725481502e-02  9.6482583162780019e-01  7.6242116467183128e-03
                    2.2372259458701244e-03   3.8849156576576079e-02  9.9922146846804739e-03  9.5115862873874345e-01
                    2.8575018682782732e-03   8.4582464342299456e-02  9.0758335037465502e-01  7.8341852830455199e-03
                    3.6858296163274471e-03   1.6971197426176724e-01  8.5509476949102938e-03  8.2173707804332247e-01
                    3.6947954420524331e-03   2.6111425988892939e-01  7.3552353111519536e-03  7.3153050479991866e-01
                    3.9020320062079557e-03   1.6791970513108378e-01  8.2400508353903842e-01  8.0752113298778007e-03
                    4.0280690969310033e-03   3.6656244587496484e-01  7.0056601694997796e-03  6.2643189395553538e-01
                    4.5248807201616790e-03   2.7143135940818343e-01  7.2062829774608570e-01  7.9403428457308640e-03
                    4.5396029262674090e-03   4.8341512229719208e-01  7.3611935668400762e-03  5.0922368413596785e-01
                    4.7456954473118324e-03   3.8795737424569156e-01  6.0432990841865115e-01  7.7127173356572846e-03
                    5.1805365733744615e-03   5.2053611601207825e-02  9.0767212361002276e-01  4.0274264788769415e-02
                    5.3119232327232276e-03   2.2901890921372594e-01  8.9345256498108053e-02  6.8163583428816601e-01
                    5.3641950429667967e-03   9.4914195571636097e-02  2.6796719091792361e-02  8.7828908533657154e-01
                    7.8409659451889774e-03   1.2322801473641305e-01  8.3518445285919994e-01  4.1587532404387012e-02
                    8.6994022662133391e-03   1.7412650727485976e-01  4.4130628886304045e-02  7.8174286383883619e-01
                    8.8402036333678774e-03   2.7218074600568664e-01  3.7468721939442976e-02  6.9035053205487039e-01
                    9.6291322198899619e-03   9.9006351507515392e-02  8.1968796781302030e-02  8.1902485171118258e-01
                    9.8032526098839851e-03   2.1893278755063751e-01  7.3931441242151423e-01  4.1752800027848264e-02
                    9.9428173758288678e-03   3.8545785619529428e-01  3.7011409874506271e-02  5.7753073393019945e-01
                    1.0748240736700020e-02   4.5393153297369844e-01  5.0712412056704251e-01  3.8944346459259045e-02
                    1.0775272663604467e-02   3.3141406799249239e-01  6.2787210031926589e-01  4.0713831688241722e-02
                    1.1783097752825196e-02   1.7541847870022081e-01  1.0978899948538104e-01  7.1479252181439815e-01
                    1.2156767654104772e-02   2.9942460625822743e-01  8.9517741605650563e-02  6.1105765213612201e-01
                    1.2945705236132828e-02   1.6443828421427001e-01  7.3572041312406398e-01  9.9841302661666017e-02
                    1.3554899747479114e-02   3.6972475893928678e-01  4.6312780745367283e-01  1.6714743360704039e-01
                    1.4675832493069558e-02   4.0636906177728345e-01  9.0716786111306254e-02  5.0291415211141030e-01
                    1.5420454458399905e-02   2.6742066429926761e-01  6.3290272516985022e-01  9.9676610530882174e-02
                    1.5515997794155201e-02   3.8320410790975120e-01  5.2162372005069048e-01  9.5172172039558321e-02
                    1.5662589306009916e-02   1.7872449232024496e-01  1.9203113575777413e-01  6.2924437192198091e-01
                    1.5927537510847807e-02   2.8282912859335521e-01  5.3764243749031352e-01  1.7952843391633127e-01
                    1.6103533030079650e-02   2.7060647925422924e-01  1.6133995005265444e-01  5.6805357069311632e-01
                    1.6658080425731265e-02   3.7087434674492326e-01  1.6454857353822245e-01  4.6457707971685430e-01
                    1.9353079492362939e-02   3.6384081188928319e-01  3.8336719177004761e-01  2.5279199634066920e-01
                    2.0459358637735462e-02   2.7573532186277135e-01  2.5276044951208952e-01  4.7150422862513913e-01];
        end
    case 25
        switch subcase
            case 1
                % degree: 25  points:  117  orbits: [0,39]  quality: PI
                r=[5.2694781097104078e-04   1.3188177147405114e-02  3.0795638401191459e-03  9.8373225901247574e-01
                    5.3837857124899405e-04   2.7259621361305189e-03  1.7104304759574110e-02  9.8016973310429537e-01
                    1.7125572938820177e-03   6.2984002092478542e-02  9.3137198416881056e-01  5.6440137387108943e-03
                    1.9123328669705840e-03   5.2023800673153514e-02  7.4379149608617993e-03  9.4053828436598469e-01
                    1.9897445140067068e-03   2.2020020614167111e-01  7.7641433442449036e-01  3.3854594338385251e-03
                    2.7030017516124594e-03   3.0439556156815283e-02  9.4485645152778936e-01  2.4703992315395353e-02
                    2.8237621420648354e-03   1.1399317437752610e-01  7.4710293157794424e-03  8.7853579630669446e-01
                    2.9151491724731532e-03   3.4229521018802231e-01  6.5261356339758951e-01  5.0912264143881727e-03
                    3.1462287823001293e-03   1.3047399195055949e-01  8.6152496607629982e-01  8.0010419731406940e-03
                    3.2543977488675224e-03   2.0017930834386714e-01  6.5078186830295318e-03  7.9331287297310333e-01
                    3.7230657814978497e-03   3.0737236321543386e-01  6.3524070945921944e-03  6.8627522968997394e-01
                    4.3063147392815293e-03   2.7621732662271041e-01  7.0637055778341041e-01  1.7412115593879173e-02
                    4.5251341589623127e-03   4.2293548307742688e-01  7.5627546953375894e-03  5.6950176222723553e-01
                    4.5624992213178081e-03   4.5322700336667143e-01  5.3899804588538400e-01  7.7749507479445695e-03
                    4.6802766206098540e-03   1.9019520269362407e-01  7.8403651191039856e-01  2.5768285395977370e-02
                    5.6405559815438428e-03   3.6171829980612501e-02  8.4456400529242921e-02  8.7937176949014458e-01
                    5.7784230507748076e-03   7.6079438865903650e-02  4.0507632612955518e-02  8.8341292852114083e-01
                    6.5791413507152465e-03   1.4994597748785784e-01  3.5835058933034054e-02  8.1421896357910811e-01
                    6.7296531658427617e-03   1.5095534117900295e-01  7.9691370268293505e-01  5.2130956138062000e-02
                    7.5755424358683704e-03   2.4478331097657494e-01  3.2689779930828644e-02  7.2252690909259641e-01
                    8.1458350463336291e-03   1.7067443366794324e-01  7.8755869338188680e-02  7.5056969699386808e-01
                    9.0818352396265625e-03   3.7194261169194315e-01  5.9342856949177006e-01  3.4628818816286790e-02
                    9.4008953043083612e-03   3.5179201043222376e-01  3.6352873144138075e-02  6.1185511642363816e-01
                    9.5240045440707534e-03   9.8440061147214969e-02  9.6959138605557881e-02  8.0460080024722715e-01
                    1.0107208145267217e-02   2.6086502629810788e-01  6.8408965318422894e-01  5.5045320517663185e-02
                    1.0859126807714842e-02   3.6658214432706733e-01  5.5078190255175695e-01  8.2635953121175723e-02
                    1.1168984186287689e-02   4.6873598774383903e-01  4.1136822171029051e-02  4.9012719008513192e-01
                    1.1772296865232151e-02   2.5761793161354125e-01  8.2486517285323274e-02  6.5989555110113547e-01
                    1.2142404008477153e-02   1.8451795241283384e-01  7.1257592580373212e-01  1.0290612178343404e-01
                    1.2552698926699686e-02   2.8120911865122772e-01  6.0525730819752112e-01  1.1353357315125115e-01
                    1.2781441276098389e-02   1.7359149167563335e-01  1.4220931869919088e-01  6.8419918962517577e-01
                    1.3246841387624651e-02   4.4236202799582157e-01  4.5498832765797559e-01  1.0264964434620284e-01
                    1.3828241563512152e-02   3.5936822655579761e-01  9.0795315699793923e-02  5.4983645774440847e-01
                    1.5928212162150313e-02   1.8213426892674237e-01  2.2866704214072984e-01  5.8919868893252780e-01
                    1.6745957138503851e-02   2.6734304273628209e-01  1.5618441381865140e-01  5.7647254344506652e-01
                    1.8774610553793232e-02   3.6529032090656271e-01  1.7379280231853740e-01  4.6091687677489988e-01
                    1.9738005080186974e-02   3.4506482660138486e-01  4.8229912538917340e-01  1.7263604800944174e-01
                    2.0286284358686281e-02   2.6556222786287530e-01  2.5680262970384419e-01  4.7763514243328051e-01
                    2.1625343577947621e-02   3.6295638550177746e-01  3.7155094737369060e-01  2.6549266712453194e-01];
        end
end

if isempty(r) == 0
    R=r(:,[1:3]);
end