
function xyw=set_papanicolopulos_B_pre(deg)


% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
% --------------------------------------------------------------------
% SOURCE:
% S-A. Papanicolopulos
% "Efficient computation of cubature rules with application to new
%  asymmetric rules on the triangle"
% JCAM 204 (2016), pp. 77-83.
% --------------------------------------------------------------------

%----------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%----------------------------------------
% |  11 |  26 |   0 |   1 | 4.72e-16 |P0|
% |  20 |  77 |   0 |   8 | 1.45e-15 |P0|
% |  22 |  92 |   0 |  11 | 1.72e-15 |P0|
%---------------------------------------


%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

switch deg
    
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   26
        % NEG. W.  :    0
        % OUT PTS. :    1
        % M.E.INF. : 4.7e-16
        
        xyw=[
            6.25873806592363246537e-01 -4.44983835604058006186e-02 8.85171467578684131004e-04
            2.90632953572616987981e-02 9.40848476278976941778e-01 5.70359077139962269976e-03
            9.33058339148674420471e-01 3.34630956930927966897e-02 7.22507441601139433623e-03
            3.18590326985022029294e-02 3.55146752201139018212e-02 7.28585686093517759243e-03
            1.62482633218668293118e-01 1.39846877219226006783e-02 7.54135852518508700143e-03
            1.32184617612812003312e-02 6.42788826815432368100e-01 8.69075233270573399569e-03
            5.91829479333409902431e-01 3.93141694274107222906e-01 9.89402445689778475835e-03
            8.05575896789687551092e-01 2.46651880397084008467e-02 1.15173141588692500709e-02
            8.04321495466082558856e-01 1.70121715342375495750e-01 1.20371478059314272746e-02
            1.51797774113621691816e-01 8.18070855798455953689e-01 1.28911465692124402316e-02
            2.90692872577444014204e-02 1.77929391940772008152e-01 1.39272682985679754908e-02
            3.42125596440217977223e-02 8.14117937083535969656e-01 1.40137042789697831291e-02
            2.48467017693192009087e-02 3.97321198592043678399e-01 1.50668752675429656190e-02
            3.53270314298278487186e-01 6.15916760551632136433e-01 1.76628066224884493207e-02
            3.61781261878188875603e-01 3.48462422413524028353e-02 1.98131368401041306482e-02
            7.25512890517397424084e-01 1.34200454674975294678e-01 2.35245388361503549035e-02
            1.52687758377548998823e-01 1.08274570877667397628e-01 2.38133172897240230625e-02
            5.76760918709025127704e-01 3.29909545553079719404e-01 2.45618931531228074094e-02
            9.57812464558655957125e-02 5.53708279551195170498e-01 2.79462585433641365340e-02
            1.66286918287333995714e-01 6.79990236477728493547e-01 2.84631364026514885324e-02
            5.80931106721034651308e-01 5.93349142682009986216e-02 2.86634759350116799514e-02
            1.33154613412877709244e-01 2.98286541434518104321e-01 3.17355879594504453056e-02
            3.61350975086914882883e-01 4.88966240018430697845e-01 3.19030904898229203392e-02
            3.26342158377320279428e-01 1.74983427068089586465e-01 3.71279726469651571996e-02
            4.93348382710591615297e-01 2.37360633371601903452e-01 3.87948898840606848371e-02
            2.60838798471289823322e-01 4.01888923157516897433e-01 3.93106101872764054916e-02
            ];
        
    case  20
        
        % ALG. DEG.:   20
        % PTS CARD.:   77
        % NEG. W.  :    0
        % OUT PTS. :    8
        % M.E.INF. : 1.5e-15
        
        xyw=[
            -2.13972282618556192135e-01 8.85270494328899482106e-01 1.66360159499651539383e-09
            1.14219528684296989240e+00 -1.72274034387398494728e-01 5.76136533362556034533e-09
            5.99214262445217360487e-01 -1.26598687399647497065e-01 3.05967248822021297544e-08
            1.24379871889390994366e-01 -1.18785618275940599298e-01 3.35844918204880786895e-08
            6.53183349102199051206e-02 1.02882448539515780617e+00 4.27575998794168942087e-07
            -5.36667090855443978947e-02 1.64022325296424409391e-01 7.58761597286627490633e-06
            2.85608320415044192320e-01 -3.44098409098497967640e-02 3.82550785247731965546e-05
            9.36080843693492092861e-01 8.34052574449410943913e-02 1.08825949341505881464e-04
            8.03052528439718082964e-01 1.94561633923371501975e-01 7.15780721582912732824e-04
            1.20188880734230004593e-02 1.22773002304658995082e-02 9.65721327369129748514e-04
            1.17885985793459002052e-02 9.74683306669172688785e-01 1.04174298736482164561e-03
            9.72419471438029980881e-01 1.51595907332457008332e-02 1.22521697181916084350e-03
            2.59582889842235209343e-01 7.37406178647960541817e-01 1.58761716644119496231e-03
            1.13901722279699992718e-02 6.38319730537900004164e-02 2.06662469852545924165e-03
            6.24536748324725984882e-02 1.19686440555381006651e-02 2.11969494189601700279e-03
            5.36487886917886624971e-01 4.58640643576341988652e-01 2.12312324217830581882e-03
            1.15287726880495995652e-02 9.18451304554263936453e-01 2.28924968859105584795e-03
            9.21229627801570027934e-01 1.37267427812455006936e-02 2.53404913356604930344e-03
            6.09542503069403981963e-02 9.22060171859679145179e-01 2.86770876295222359662e-03
            1.49807778345135700349e-01 1.17795744693112991452e-02 3.05751425690990730200e-03
            7.07889807463940590182e-01 8.34091008803320051179e-03 3.07023309895339442666e-03
            8.32342815256551848968e-01 1.09109589105933994096e-02 3.07727716603990730793e-03
            1.19250456031763998888e-02 8.21808561973290996328e-01 3.44743576112243894222e-03
            1.45547229195401611745e-01 8.40701488801081198154e-01 3.51237288040826337032e-03
            9.53344909862949979606e-03 4.10486940081249973566e-01 3.58732751594219648195e-03
            6.79668341434463973982e-01 3.10086648021363597838e-01 3.62535896173821984428e-03
            9.89232730221640058077e-03 5.56673185362967171130e-01 3.64264492110160818458e-03
            5.53456071686292960798e-01 1.04547658690504995105e-02 4.02364113762561717569e-03
            8.09484224243874894711e-01 1.70682203625222100873e-01 4.14758715723231342898e-03
            9.02013507663122937608e-01 7.46138877131691941047e-02 4.18174795988518650802e-03
            1.29694574942774993459e-02 2.70557639318955600594e-01 4.31644382017153452336e-03
            5.86275629455060981465e-02 6.12222576866121026562e-02 4.31693301553582112207e-03
            3.92424909662620502449e-01 5.95206388831197807932e-01 4.40933875688406980153e-03
            1.37405978198458008505e-02 6.94659120250108452765e-01 4.72344274770221655285e-03
            1.87516304312781989516e-02 1.51227587577556388254e-01 4.78458370141701585382e-03
            4.02956369953581583498e-01 1.37359323322951993457e-02 5.07386245327565415381e-03
            1.37650638016870607849e-01 5.64581638297467006127e-02 5.30091835390772512376e-03
            5.98726536103752968176e-02 8.58559558597151051273e-01 5.59963632041089731661e-03
            6.24882352893667780691e-01 4.16470200265496998115e-02 6.00434586316846326259e-03
            2.62938174339716002059e-01 1.99626935996523001415e-02 6.03265328197354847722e-03
            8.38049083719112686275e-01 6.47623246114735068302e-02 6.56070996119526538004e-03
            2.57533995834666518121e-01 7.06047344861891468248e-01 6.73250620419756518747e-03
            5.35401647857205564840e-01 4.29012681315519783798e-01 6.89295964499913368234e-03
            7.43231502264049992412e-01 5.13341047302287994958e-02 7.06605556753119468799e-03
            4.88883387859557969057e-02 5.21869746031161985123e-01 7.20256640733827734752e-03
            6.24726931520614980897e-02 7.57815811962161856030e-01 7.63222095306962181049e-03
            1.43597231050559187571e-01 7.85973813626918538233e-01 7.65064327116702497245e-03
            6.69101112127524655371e-01 2.76326273581061820916e-01 8.23727570866368205560e-03
            7.65185966369098746753e-01 1.55100092624901292337e-01 8.26613224738697964511e-03
            8.85954672172785950846e-02 1.37178277163375605952e-01 8.31248729614306874902e-03
            5.27740002133011976149e-02 3.82366757870937379327e-01 8.41455674173875733945e-03
            6.80360399128474013786e-02 2.47691298374512897107e-01 8.96642456800924615712e-03
            6.98062102092747993609e-02 6.31595957662000828670e-01 9.39022442228483120163e-03
            2.07987112156463094248e-01 9.24058022638531012527e-02 9.41008369361130345143e-03
            3.90182931303222124697e-01 5.47411613364379934232e-01 9.43977840234197680680e-03
            4.76076386842712473424e-01 6.02551121213251023034e-02 9.44454791352718377173e-03
            3.34886348256971777548e-01 7.47904975261002996634e-02 1.02749806762301113677e-02
            5.86423015392367852350e-01 1.03489104558458305805e-01 1.03322814686045184873e-02
            1.46590103668047588847e-01 6.90221726784093880802e-01 1.05982962666915873223e-02
            6.89198424849254087654e-01 1.30677796659157713366e-01 1.06213117182280356726e-02
            2.56431003885450981006e-01 6.35951264400860249992e-01 1.07088283795729929254e-02
            5.19807965736053700923e-01 3.79116974478602319909e-01 1.09611174691016735605e-02
            1.18988935286532496183e-01 4.57943028819293218579e-01 1.15602906434758012644e-02
            6.13670324239234954433e-01 2.44024343068565796600e-01 1.20786916491884954022e-02
            1.56249773792297513841e-01 5.64568937312600049871e-01 1.21423009945660371339e-02
            2.55871503699490576711e-01 5.36571755735847366608e-01 1.22382465941862118852e-02
            1.70734103415520588332e-01 1.92078073276151894966e-01 1.23202765313036536471e-02
            3.79086896953479079997e-01 4.74425078234563923907e-01 1.24348593141310435894e-02
            1.37580605927453802906e-01 3.19431457488133119238e-01 1.24767019653194092405e-02
            2.18911141386702090550e-01 4.16189965552626772727e-01 1.32474680111841058155e-02
            4.34412095811269105550e-01 1.46976743935933906737e-01 1.34953322367008000937e-02
            2.96550157207215503430e-01 1.70010182348781513362e-01 1.35179486526194742035e-02
            3.23070720478415784882e-01 4.00096706715143080046e-01 1.36649065420444432856e-02
            5.30596277259844262275e-01 2.03039795210256696079e-01 1.38582676119359815559e-02
            2.48460261553608813268e-01 2.88066651277510521467e-01 1.41628628694416090067e-02
            4.58735528925298396974e-01 3.30663543143968396976e-01 1.42479948419349695954e-02
            3.76985663109379198765e-01 2.65396696108143426152e-01 1.58108659606200283032e-02
            ];
        
    case  22
        
        % ALG. DEG.:   22
        % PTS CARD.:   92
        % NEG. W.  :    0
        % OUT PTS. :   11
        % M.E.INF. : 1.7e-15
        
        xyw=[
            4.64982138245242704322e-01 7.11150575650459360055e-01 2.26978199506745439573e-09
            9.33241349802137354352e-01 2.07245322480992089087e-01 1.11356370438424581235e-08
            7.18814607014818252040e-01 -1.08592374847109193747e-01 6.82569325458580795530e-08
            -7.53425185865285035325e-02 3.65738826101051017758e-01 6.31016170429557378775e-07
            -7.29720466214083957057e-02 9.08780987704670639715e-01 6.38694342960375204872e-07
            1.61390053532476512865e-01 -5.67779747516548999320e-02 1.72577508804956678810e-06
            3.96473037509524617317e-01 -3.93347505474984995844e-02 8.63572710251500325182e-06
            3.25670755950673990187e-02 9.83615991855380511488e-01 5.05128244519665562003e-05
            5.11083489768881849002e-01 -1.67145669135699004304e-02 5.14494785752493843001e-05
            9.69815309580979389992e-01 -8.47386414977770001389e-03 1.29248937135777690463e-04
            4.56684802229330010642e-03 1.12732881898779998403e-02 3.46312443064557035251e-04
            9.78534773184665751522e-01 1.31017828795071001463e-02 7.07064175834716448360e-04
            -2.09366083091479986480e-03 6.11172971166304646040e-01 7.46505335726334600006e-04
            8.24465917969609968230e-03 9.77374814635139754770e-01 7.56488950967336057883e-04
            2.86161958663017010340e-02 8.39418112704680072222e-03 8.53440588185313403491e-04
            6.57626401564029988700e-03 5.28100601072915010192e-02 9.67496031083952775544e-04
            2.75866644961711204864e-01 4.21287699982659993164e-03 1.25441472966708058266e-03
            1.05868943093978096215e-01 8.86885891425699846025e-01 1.54424871060952415003e-03
            6.19226480612458551889e-01 3.76941832682914701458e-01 1.55306294629564039037e-03
            8.83776214104550317252e-01 8.37053232048790007980e-03 1.75307601426584729748e-03
            9.25410583696847699464e-01 6.44641060621398004349e-02 1.77825463455444517623e-03
            1.08650060510514998025e-02 9.20664143492036624039e-01 1.97483354002272624636e-03
            9.44141087572360031277e-03 1.22132342422849995978e-01 2.01880888975263959526e-03
            8.34379668080313940948e-02 1.14591516812569006040e-02 2.04689981400035976578e-03
            4.61305836421291026728e-02 9.33288093591807421667e-01 2.36701557911251237593e-03
            9.30132604326048717525e-01 2.32412078745275994807e-02 2.47965076916355003575e-03
            4.00920237531567025258e-01 5.85675939955597968378e-01 2.54205254822963827577e-03
            2.00298631844479407826e-01 7.90161352541371209135e-01 2.57687934330929051957e-03
            3.77632914144658965450e-02 4.88000038207256972567e-02 2.70876967508065519957e-03
            7.86993303590034054551e-01 1.02546720868124992959e-02 2.83422608606735335068e-03
            8.40737863810381957919e-01 1.47322288830840891771e-01 2.91706710568898335695e-03
            1.05197174565543997982e-02 2.19035042530801610239e-01 2.94795911073154935991e-03
            9.97901146028259966592e-03 7.27289788380431234671e-01 2.95144998158129289595e-03
            3.10283140029019188777e-01 6.78994359625208487863e-01 2.99205029840976044833e-03
            4.90189560074439811821e-01 4.99174527028812708984e-01 3.03832462794672696765e-03
            1.67966330536045205246e-01 1.41053909355621006488e-02 3.40401493685290419330e-03
            1.41127681947915001315e-02 8.32447463133275222802e-01 3.45923965337180958426e-03
            1.04234395787746996626e-02 4.68998077755451825421e-01 3.55162802586141438874e-03
            7.33146336217226024523e-01 2.54442450218429205844e-01 3.66731788406804599945e-03
            2.76872655309121973310e-01 2.38950051964319995501e-02 3.71875663858215431412e-03
            6.67893530919515643340e-01 1.20851625782620996502e-02 3.84182584069791416281e-03
            4.45015015162890034683e-02 6.96409123129440255084e-01 4.26494494693289722537e-03
            1.37349285317673996260e-02 3.36939397252163819196e-01 4.33303197421805365991e-03
            5.37547879908140235905e-01 1.38730562867831995477e-02 4.44524566642926985405e-03
            5.92835053410133872021e-01 3.77159114650097326837e-01 4.71759998468170536901e-03
            1.26630109374717497728e-01 8.30222658453748652008e-01 4.72165147467940200798e-03
            4.01366382406037780495e-01 1.50259944876660004459e-02 4.77793938479996460611e-03
            8.57954275672313304568e-01 8.62277341830808979894e-02 4.88396288451498072902e-03
            4.91710116722589990479e-02 1.23321540053355493960e-01 4.89684496886396130461e-03
            5.90361244964826975545e-02 8.59769883879450080855e-01 4.92250836067787723993e-03
            8.28552704610202916946e-01 4.72711454279717974147e-02 4.94738260967091201398e-03
            1.02888155475812897999e-01 6.05783796272693006446e-02 5.22282690249954890949e-03
            2.52668780123645984881e-02 5.90679259483232632633e-01 5.76369546572145629443e-03
            5.22224101343283023113e-02 4.46404157593296102569e-01 6.38364612656271580154e-03
            5.57922911259374973425e-02 2.21958351229682604444e-01 6.73945155672955268505e-03
            2.33057059900132507169e-01 7.14868759196109149201e-01 6.79401339346180632717e-03
            7.60238740904368159867e-01 1.78054468985292091432e-01 6.83642487485006285219e-03
            6.53782134850099616585e-01 2.84349895545913999850e-01 6.91907891983899701882e-03
            7.01192668918892009211e-02 7.61645772034410195594e-01 6.96241725033403674461e-03
            8.56752082434592970861e-02 6.20123951286305374886e-01 6.98850440498761937835e-03
            7.17456088900951804987e-01 5.55931048067861977025e-02 7.06188553686232321077e-03
            1.97548193096344609776e-01 6.85029623840039958438e-02 7.39933165875871542289e-03
            8.64145042160261028785e-02 5.13438219270665352489e-01 7.64560716445602302910e-03
            4.75509760996478514361e-01 4.64836327100429602677e-01 7.77699997071083781730e-03
            6.78714687817086048671e-02 3.31996502196124476658e-01 7.90134060606514573855e-03
            1.46979207784701609851e-01 7.41078729902387989270e-01 8.11730432367423204720e-03
            3.51221665184432485507e-01 5.87953585294961000862e-01 8.12896549348283807557e-03
            7.41261492762090412612e-01 1.20894088556726203576e-01 8.34370314724343711821e-03
            1.24040327659173499342e-01 1.42583601364923207022e-01 8.35558020646859876679e-03
            2.13880394121143901920e-01 2.70490112816105798821e-01 8.61238881498769745515e-03
            5.88770407739171108830e-01 6.28867829706775960386e-02 8.62472236313736873026e-03
            3.21270098954109073475e-01 7.16976174401817989423e-02 8.63862547850183064291e-03
            4.54559036809930927525e-01 6.48529251240834991865e-02 8.93313629439488644801e-03
            2.88845281940968090506e-01 2.38118396866765308362e-01 9.00509278571951822523e-03
            5.32163580900152477504e-01 3.57017738203314505263e-01 9.38422442686159125058e-03
            4.73641029272273195172e-01 3.35467115867110698968e-01 9.68975049682432691689e-03
            1.37215640807511696231e-01 2.43905972104074802997e-01 9.93133031363590580709e-03
            6.21391658733018270588e-01 1.35037461036809303128e-01 1.06473323149699362206e-02
            1.52603655913764513219e-01 6.34085174784072780341e-01 1.07634538251510751550e-02
            2.53542499404753318704e-01 6.14568220520721020250e-01 1.08165515377311761969e-02
            6.30459386519128472948e-01 2.25032882061072608826e-01 1.11185427993754516046e-02
            2.30848514163360801765e-01 1.50778181472718098011e-01 1.13180953597056700027e-02
            3.60607666765002221609e-01 1.47657125036602110413e-01 1.14605050959253797899e-02
            1.68825843777590689498e-01 4.96801767224627877084e-01 1.16809125567246402388e-02
            5.12950485421223789650e-01 2.34938455462988304845e-01 1.18272157420078599666e-02
            4.87479899308838782179e-01 1.44753653681138988452e-01 1.20912166371753004857e-02
            1.41411858661172812335e-01 3.79555454421125593178e-01 1.21678974927683664770e-02
            3.79920224601669520581e-01 4.77536434179863300553e-01 1.26881968317201117291e-02
            2.59931264032647602047e-01 5.04552912634035233275e-01 1.28339382548148285557e-02
            3.60690792192417675199e-01 3.78196347277973687895e-01 1.29740914380822563307e-02
            3.85985301830885418894e-01 2.56761175269934582843e-01 1.38185025071558449661e-02
            2.54967729527999675820e-01 3.69733046040209401006e-01 1.41803283504474460924e-02
            ];
        
        
    otherwise
        xyw=[];
end




