
function [xyw,pointset_stats]=set_papanicolopulos_B_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicolopulos
% "Efficient computation of cubature rules with application to new
%  asymmetric rules on the triangle"
% JCAM 204 (2016), pp. 77-83.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  11 |  26 |   0 |   1 | 4.72e-16 |P0|
% |  20 |  77 |   0 |   8 | 1.45e-15 |P0|
% |  22 |  92 |   0 |  11 | 1.72e-15 |P0|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   26
        % NEG. W.  :    0
        % OUT PTS. :    1
        % M.E.INF. : 4.7e-16
        
        xyw=[
            6.25873806592363246537047416495625e-01 -4.44983835604058006185645979257970e-02 8.85171467578684131004285173816015e-04
            2.90632953572616987980570257832369e-02 9.40848476278976941777898446161998e-01 5.70359077139962269975548281308875e-03
            9.33058339148674420471252233255655e-01 3.34630956930927966896938130503258e-02 7.22507441601139433623446350907216e-03
            3.18590326985022029293581624642684e-02 3.55146752201139018212394660167774e-02 7.28585686093517759243098907973035e-03
            1.62482633218668293118014389619930e-01 1.39846877219226006783259208532399e-02 7.54135852518508700143007317251431e-03
            1.32184617612812003312194875093155e-02 6.42788826815432368100289295398397e-01 8.69075233270573399568803552028839e-03
            5.91829479333409902430673810158623e-01 3.93141694274107222906167180553894e-01 9.89402445689778475834685877998709e-03
            8.05575896789687551091674322378822e-01 2.46651880397084008467167848266399e-02 1.15173141588692500708601684777932e-02
            8.04321495466082558856157902482664e-01 1.70121715342375495749749347851321e-01 1.20371478059314272746060936469803e-02
            1.51797774113621691816078396186640e-01 8.18070855798455953689085617952514e-01 1.28911465692124402315776876548625e-02
            2.90692872577444014203784661276586e-02 1.77929391940772008151583349899738e-01 1.39272682985679754907870631086553e-02
            3.42125596440217977223241518913710e-02 8.14117937083535969655656572285807e-01 1.40137042789697831290940399640021e-02
            2.48467017693192009086811111728821e-02 3.97321198592043678399221562358434e-01 1.50668752675429656190386751291044e-02
            3.53270314298278487186166785249952e-01 6.15916760551632136433397590735694e-01 1.76628066224884493207181179741383e-02
            3.61781261878188875602546659138170e-01 3.48462422413524028352860284485359e-02 1.98131368401041306481769055380937e-02
            7.25512890517397424083867463195929e-01 1.34200454674975294677707893242768e-01 2.35245388361503549035091964469757e-02
            1.52687758377548998822703651967458e-01 1.08274570877667397628130174780381e-01 2.38133172897240230625470758241136e-02
            5.76760918709025127704137503314996e-01 3.29909545553079719404365732771112e-01 2.45618931531228074094386215620034e-02
            9.57812464558655957125310465016810e-02 5.53708279551195170498090192268137e-01 2.79462585433641365340040607634364e-02
            1.66286918287333995714050161041087e-01 6.79990236477728493547090238280362e-01 2.84631364026514885323670966954523e-02
            5.80931106721034651307888907467714e-01 5.93349142682009986216051800056448e-02 2.86634759350116799514474053012236e-02
            1.33154613412877709244241941632936e-01 2.98286541434518104320972042842186e-01 3.17355879594504453056202919469797e-02
            3.61350975086914882883348809627932e-01 4.88966240018430697844564747356344e-01 3.19030904898229203392467923094955e-02
            3.26342158377320279427635796309914e-01 1.74983427068089586464694207279535e-01 3.71279726469651571996166694589192e-02
            4.93348382710591615296635836784844e-01 2.37360633371601903451875159589690e-01 3.87948898840606848370526904545841e-02
            2.60838798471289823321939138622838e-01 4.01888923157516897433083613577764e-01 3.93106101872764054916409293127799e-02
            ];
        
    case  20
        
        % ALG. DEG.:   20
        % PTS CARD.:   77
        % NEG. W.  :    0
        % OUT PTS. :    8
        % M.E.INF. : 1.5e-15
        
        xyw=[
            -2.13972282618556192135272908672050e-01 8.85270494328899482106010054849321e-01 1.66360159499651539382617296112697e-09
            1.14219528684296989240465336479247e+00 -1.72274034387398494727605680054694e-01 5.76136533362556034533079113088561e-09
            5.99214262445217360486537927499739e-01 -1.26598687399647497064947287981340e-01 3.05967248822021297544478904851389e-08
            1.24379871889390994366131337756087e-01 -1.18785618275940599297690880575828e-01 3.35844918204880786895056741462456e-08
            6.53183349102199051205985824708478e-02 1.02882448539515780616682150139241e+00 4.27575998794168942087066996940448e-07
            -5.36667090855443978947292293923965e-02 1.64022325296424409390994014756870e-01 7.58761597286627490632640938295062e-06
            2.85608320415044192319697913262644e-01 -3.44098409098497967639751493607037e-02 3.82550785247731965545842092168982e-05
            9.36080843693492092860708453372354e-01 8.34052574449410943913107985281385e-02 1.08825949341505881463529337160878e-04
            8.03052528439718082964304812776390e-01 1.94561633923371501975196906641941e-01 7.15780721582912732824099943940155e-04
            1.20188880734230004593277030267018e-02 1.22773002304658995081920735970016e-02 9.65721327369129748513509881036043e-04
            1.17885985793459002052285811146248e-02 9.74683306669172688785351965634618e-01 1.04174298736482164561001351188452e-03
            9.72419471438029980880912717111642e-01 1.51595907332457008331871861628315e-02 1.22521697181916084350150608628383e-03
            2.59582889842235209343357382749673e-01 7.37406178647960541816530621872516e-01 1.58761716644119496230636023881289e-03
            1.13901722279699992718127177226961e-02 6.38319730537900004163631706433080e-02 2.06662469852545924164921586907440e-03
            6.24536748324725984882199725234386e-02 1.19686440555381006650703668015012e-02 2.11969494189601700279146356820092e-03
            5.36487886917886624971174569509458e-01 4.58640643576341988651989822756150e-01 2.12312324217830581882249241232330e-03
            1.15287726880495995651632057388269e-02 9.18451304554263936452684902178589e-01 2.28924968859105584795265997399838e-03
            9.21229627801570027934019435633672e-01 1.37267427812455006935765666753468e-02 2.53404913356604930343984882767927e-03
            6.09542503069403981963425565027137e-02 9.22060171859679145178745329758385e-01 2.86770876295222359661507560701921e-03
            1.49807778345135700348578211560380e-01 1.17795744693112991452466076225392e-02 3.05751425690990730199558811364113e-03
            7.07889807463940590182005507813301e-01 8.34091008803320051179230887328231e-03 3.07023309895339442665562756928921e-03
            8.32342815256551848968058493483113e-01 1.09109589105933994096497841042037e-02 3.07727716603990730792617114275345e-03
            1.19250456031763998887562649997562e-02 8.21808561973290996327534685406135e-01 3.44743576112243894221665030386248e-03
            1.45547229195401611745452896684583e-01 8.40701488801081198154463436367223e-01 3.51237288040826337032207504762482e-03
            9.53344909862949979606483452698740e-03 4.10486940081249973566457356355386e-01 3.58732751594219648194616922864952e-03
            6.79668341434463973982360585068818e-01 3.10086648021363597838018222319079e-01 3.62535896173821984428409237466440e-03
            9.89232730221640058076992829683149e-03 5.56673185362967171130321730743162e-01 3.64264492110160818458264309072092e-03
            5.53456071686292960798425610846607e-01 1.04547658690504995104841867714640e-02 4.02364113762561717568821961776848e-03
            8.09484224243874894710870648850687e-01 1.70682203625222100873415342903172e-01 4.14758715723231342897836526617539e-03
            9.02013507663122937607624862721423e-01 7.46138877131691941047009208887175e-02 4.18174795988518650802223675100322e-03
            1.29694574942774993459027044195864e-02 2.70557639318955600593596955150133e-01 4.31644382017153452335556096386426e-03
            5.86275629455060981465308600490971e-02 6.12222576866121026561984308500541e-02 4.31693301553582112206619569860777e-03
            3.92424909662620502448504566928023e-01 5.95206388831197807931516763346735e-01 4.40933875688406980153377645592627e-03
            1.37405978198458008504578842234878e-02 6.94659120250108452765402944351081e-01 4.72344274770221655285196149520743e-03
            1.87516304312781989516167868714547e-02 1.51227587577556388254151897854172e-01 4.78458370141701585381843742084129e-03
            4.02956369953581583498447571400902e-01 1.37359323322951993456841890406395e-02 5.07386245327565415380588476068624e-03
            1.37650638016870607849284624535358e-01 5.64581638297467006126773014784703e-02 5.30091835390772512376367231468066e-03
            5.98726536103752968176472393224685e-02 8.58559558597151051273499433591496e-01 5.59963632041089731661287487440859e-03
            6.24882352893667780691089319589082e-01 4.16470200265496998115466453782574e-02 6.00434586316846326259355492993564e-03
            2.62938174339716002059219590591965e-01 1.99626935996523001415337006392292e-02 6.03265328197354847722388981878794e-03
            8.38049083719112686274854695511749e-01 6.47623246114735068301726528261497e-02 6.56070996119526538004063098696861e-03
            2.57533995834666518121025546861347e-01 7.06047344861891468248416003916645e-01 6.73250620419756518747478324371514e-03
            5.35401647857205564839944145205664e-01 4.29012681315519783797896025134833e-01 6.89295964499913368234151889168970e-03
            7.43231502264049992412253686779877e-01 5.13341047302287994957836758658232e-02 7.06605556753119468799129165859085e-03
            4.88883387859557969057355819586519e-02 5.21869746031161985122537316783564e-01 7.20256640733827734751626437059713e-03
            6.24726931520614980897221357736271e-02 7.57815811962161856030206763534807e-01 7.63222095306962181049392768272810e-03
            1.43597231050559187570669905653631e-01 7.85973813626918538233212530030869e-01 7.65064327116702497244560277067649e-03
            6.69101112127524655370791606401326e-01 2.76326273581061820916460192165687e-01 8.23727570866368205559915338653809e-03
            7.65185966369098746753252271446399e-01 1.55100092624901292337469271842565e-01 8.26613224738697964510958371420202e-03
            8.85954672172785950845508295969921e-02 1.37178277163375605951500801893417e-01 8.31248729614306874902140975791554e-03
            5.27740002133011976148679877951508e-02 3.82366757870937379326647942434647e-01 8.41455674173875733945493493592949e-03
            6.80360399128474013785705665213754e-02 2.47691298374512897106924924628402e-01 8.96642456800924615711867460277062e-03
            6.98062102092747993609123113856185e-02 6.31595957662000828669590646313736e-01 9.39022442228483120163495811993926e-03
            2.07987112156463094247982326123747e-01 9.24058022638531012526996732958651e-02 9.41008369361130345143173769884015e-03
            3.90182931303222124697072104027029e-01 5.47411613364379934232317737041740e-01 9.43977840234197680679972819461909e-03
            4.76076386842712473423944175010547e-01 6.02551121213251023034374043163552e-02 9.44454791352718377173136587998670e-03
            3.34886348256971777548329782803194e-01 7.47904975261002996633763473255385e-02 1.02749806762301113677304797988654e-02
            5.86423015392367852349764234531904e-01 1.03489104558458305804791166337964e-01 1.03322814686045184873197655406329e-02
            1.46590103668047588847400675149402e-01 6.90221726784093880802117837447440e-01 1.05982962666915873223283384163551e-02
            6.89198424849254087654060185741400e-01 1.30677796659157713365928543680639e-01 1.06213117182280356726176151482832e-02
            2.56431003885450981005789117261884e-01 6.35951264400860249992319950251840e-01 1.07088283795729929254170187391537e-02
            5.19807965736053700922525422356557e-01 3.79116974478602319909015250232187e-01 1.09611174691016735605053611379844e-02
            1.18988935286532496182765328285313e-01 4.57943028819293218578678761332412e-01 1.15602906434758012643726488022367e-02
            6.13670324239234954433186430833302e-01 2.44024343068565796599500572483521e-01 1.20786916491884954022451026389717e-02
            1.56249773792297513841376144227979e-01 5.64568937312600049871491592057282e-01 1.21423009945660371339259953060719e-02
            2.55871503699490576710928735337802e-01 5.36571755735847366608481934235897e-01 1.22382465941862118852245799871525e-02
            1.70734103415520588331588669461780e-01 1.92078073276151894965835253969999e-01 1.23202765313036536470869819481777e-02
            3.79086896953479079996895961812697e-01 4.74425078234563923906819127296330e-01 1.24348593141310435894464347938992e-02
            1.37580605927453802905802149325609e-01 3.19431457488133119237971868642489e-01 1.24767019653194092404513426686208e-02
            2.18911141386702090549931654095417e-01 4.16189965552626772726796389179071e-01 1.32474680111841058155475181479233e-02
            4.34412095811269105549712321590050e-01 1.46976743935933906737290044475230e-01 1.34953322367008000937094180926579e-02
            2.96550157207215503429864611462108e-01 1.70010182348781513361757333768765e-01 1.35179486526194742035400508939347e-02
            3.23070720478415784882031402958091e-01 4.00096706715143080046459544973914e-01 1.36649065420444432855662242332073e-02
            5.30596277259844262275123583094683e-01 2.03039795210256696078587879128463e-01 1.38582676119359815558595983020496e-02
            2.48460261553608813267501886912214e-01 2.88066651277510521467206672241446e-01 1.41628628694416090066932056856785e-02
            4.58735528925298396973886383420904e-01 3.30663543143968396975651558022946e-01 1.42479948419349695953872725340261e-02
            3.76985663109379198765225282841129e-01 2.65396696108143426151571020454867e-01 1.58108659606200283032073627964564e-02
            ];
        
    case  22
        
        % ALG. DEG.:   22
        % PTS CARD.:   92
        % NEG. W.  :    0
        % OUT PTS. :   11
        % M.E.INF. : 1.7e-15
        
        xyw=[
            4.64982138245242704321924520627363e-01 7.11150575650459360055322122207144e-01 2.26978199506745439573472527541257e-09
            9.33241349802137354352282727631973e-01 2.07245322480992089086981877699145e-01 1.11356370438424581234918505387270e-08
            7.18814607014818252039844992395956e-01 -1.08592374847109193747307642752276e-01 6.82569325458580795529887875160158e-08
            -7.53425185865285035324845352988632e-02 3.65738826101051017758436501026154e-01 6.31016170429557378774643779800746e-07
            -7.29720466214083957057212614927266e-02 9.08780987704670639715232027810998e-01 6.38694342960375204871657436878074e-07
            1.61390053532476512865301288002229e-01 -5.67779747516548999319851986911090e-02 1.72577508804956678810382537242463e-06
            3.96473037509524617316714056869387e-01 -3.93347505474984995843534818504850e-02 8.63572710251500325181941292163046e-06
            3.25670755950673990186672313029703e-02 9.83615991855380511488249339890899e-01 5.05128244519665562002608272251791e-05
            5.11083489768881849002468698017765e-01 -1.67145669135699004304029813283705e-02 5.14494785752493843000894557793146e-05
            9.69815309580979389991739481047262e-01 -8.47386414977770001388801546227114e-03 1.29248937135777690462731803755503e-04
            4.56684802229330010642227577477570e-03 1.12732881898779998403048452360053e-02 3.46312443064557035250772276668840e-04
            9.78534773184665751522004484286299e-01 1.31017828795071001463101723061300e-02 7.07064175834716448360017793106636e-04
            -2.09366083091479986480476505050774e-03 6.11172971166304646040146053564968e-01 7.46505335726334600006393049653752e-04
            8.24465917969609968229960372809728e-03 9.77374814635139754770420950080734e-01 7.56488950967336057883139144308871e-04
            2.86161958663017010340290369185823e-02 8.39418112704680072222451769903273e-03 8.53440588185313403490894756941998e-04
            6.57626401564029988699999762502557e-03 5.28100601072915010192332374572288e-02 9.67496031083952775543599589269661e-04
            2.75866644961711204864229785016505e-01 4.21287699982659993164224587758326e-03 1.25441472966708058266183112294812e-03
            1.05868943093978096214868855895475e-01 8.86885891425699846024599537486210e-01 1.54424871060952415002809345878632e-03
            6.19226480612458551888721558498219e-01 3.76941832682914701457832507003332e-01 1.55306294629564039036506706281671e-03
            8.83776214104550317252062541228952e-01 8.37053232048790007979732763487846e-03 1.75307601426584729747970570201687e-03
            9.25410583696847699464171910221921e-01 6.44641060621398004348847621258756e-02 1.77825463455444517622827671488039e-03
            1.08650060510514998024511612584320e-02 9.20664143492036624039087655546609e-01 1.97483354002272624636016296051366e-03
            9.44141087572360031276996750193575e-03 1.22132342422849995977607306940627e-01 2.01880888975263959525530133021221e-03
            8.34379668080313940947689843596891e-02 1.14591516812569006039668195739978e-02 2.04689981400035976577544971632960e-03
            4.61305836421291026727686812591855e-02 9.33288093591807421667283506394597e-01 2.36701557911251237592553664512707e-03
            9.30132604326048717524599851458333e-01 2.32412078745275994806629427102962e-02 2.47965076916355003575076487720708e-03
            4.00920237531567025257572822738439e-01 5.85675939955597968378242512699217e-01 2.54205254822963827576742801284126e-03
            2.00298631844479407826398187353334e-01 7.90161352541371209134979380905861e-01 2.57687934330929051957026487684743e-03
            3.77632914144658965449607990194636e-02 4.88000038207256972566661090695561e-02 2.70876967508065519957272115902924e-03
            7.86993303590034054550983455555979e-01 1.02546720868124992959158348071469e-02 2.83422608606735335068371739453141e-03
            8.40737863810381957918593798240181e-01 1.47322288830840891771245537711366e-01 2.91706710568898335694809631490898e-03
            1.05197174565543997981631463289887e-02 2.19035042530801610238810894770722e-01 2.94795911073154935991280645168899e-03
            9.97901146028259966591633656207705e-03 7.27289788380431234671164020255674e-01 2.95144998158129289594908684080110e-03
            3.10283140029019188776970850085490e-01 6.78994359625208487862835227133473e-01 2.99205029840976044833156244351358e-03
            4.90189560074439811820923296181718e-01 4.99174527028812708984162327396916e-01 3.03832462794672696765330144330619e-03
            1.67966330536045205246153955158661e-01 1.41053909355621006488368252007604e-02 3.40401493685290419330402578168560e-03
            1.41127681947915001314797223130881e-02 8.32447463133275222801898962643463e-01 3.45923965337180958426466226285356e-03
            1.04234395787746996625555695459298e-02 4.68998077755451825421317835207446e-01 3.55162802586141438873634790240885e-03
            7.33146336217226024523085925466148e-01 2.54442450218429205843762019867427e-01 3.66731788406804599944610600914530e-03
            2.76872655309121973310482189845061e-01 2.38950051964319995501107030122512e-02 3.71875663858215431412101992236785e-03
            6.67893530919515643340389488002984e-01 1.20851625782620996502059185218059e-02 3.84182584069791416281347551375802e-03
            4.45015015162890034683407236570929e-02 6.96409123129440255084432465082500e-01 4.26494494693289722536677643915937e-03
            1.37349285317673996259513202744529e-02 3.36939397252163819196368876873748e-01 4.33303197421805365990854497226792e-03
            5.37547879908140235905023018858628e-01 1.38730562867831995477185813570031e-02 4.44524566642926985404749018471193e-03
            5.92835053410133872020537637581583e-01 3.77159114650097326837396849441575e-01 4.71759998468170536900512246347716e-03
            1.26630109374717497727758086512040e-01 8.30222658453748652007675445929635e-01 4.72165147467940200798341976451411e-03
            4.01366382406037780494756361804320e-01 1.50259944876660004459134611920490e-02 4.77793938479996460610976782845682e-03
            8.57954275672313304568206149269827e-01 8.62277341830808979894484878059302e-02 4.88396288451498072902268177131191e-03
            4.91710116722589990478908816839976e-02 1.23321540053355493959941213688580e-01 4.89684496886396130460594733335711e-03
            5.90361244964826975545335585593421e-02 8.59769883879450080854667248786427e-01 4.92250836067787723993038895287100e-03
            8.28552704610202916946093409933383e-01 4.72711454279717974147345671553921e-02 4.94738260967091201397716204724020e-03
            1.02888155475812897998721950898471e-01 6.05783796272693006446097285788710e-02 5.22282690249954890948647090453960e-03
            2.52668780123645984880820236639920e-02 5.90679259483232632632621061929967e-01 5.76369546572145629442784908746944e-03
            5.22224101343283023113350793664722e-02 4.46404157593296102568558580969693e-01 6.38364612656271580154454525768415e-03
            5.57922911259374973425018140460452e-02 2.21958351229682604444093385609449e-01 6.73945155672955268505441850379611e-03
            2.33057059900132507168635243033350e-01 7.14868759196109149200992760597728e-01 6.79401339346180632716709624219220e-03
            7.60238740904368159867487975134281e-01 1.78054468985292091431915650900919e-01 6.83642487485006285219402144548440e-03
            6.53782134850099616585339390439913e-01 2.84349895545913999850284881176776e-01 6.91907891983899701882076982428771e-03
            7.01192668918892009211063509610540e-02 7.61645772034410195594489323411835e-01 6.96241725033403674460785737210244e-03
            8.56752082434592970860975924551894e-02 6.20123951286305374885898800130235e-01 6.98850440498761937835325852574897e-03
            7.17456088900951804987471405183896e-01 5.55931048067861977024506359157385e-02 7.06188553686232321077165252631858e-03
            1.97548193096344609775982803512306e-01 6.85029623840039958437841960403603e-02 7.39933165875871542288555460231692e-03
            8.64145042160261028785228631932114e-02 5.13438219270665352489402266655816e-01 7.64560716445602302909767544747410e-03
            4.75509760996478514361029965584748e-01 4.64836327100429602676712192987907e-01 7.77699997071083781730038708701613e-03
            6.78714687817086048671200160242734e-02 3.31996502196124476657956847702735e-01 7.90134060606514573854575189670868e-03
            1.46979207784701609851296666420239e-01 7.41078729902387989270096113614272e-01 8.11730432367423204720324747540872e-03
            3.51221665184432485506960119892028e-01 5.87953585294961000862201672134688e-01 8.12896549348283807556736491051197e-03
            7.41261492762090412611541978549212e-01 1.20894088556726203576019429419830e-01 8.34370314724343711820786495536595e-03
            1.24040327659173499341704882681370e-01 1.42583601364923207022172846336616e-01 8.35558020646859876678913536807158e-03
            2.13880394121143901919879226625198e-01 2.70490112816105798820842665008968e-01 8.61238881498769745514998419366748e-03
            5.88770407739171108829623335623182e-01 6.28867829706775960385556345499936e-02 8.62472236313736873025703744133352e-03
            3.21270098954109073474683100357652e-01 7.16976174401817989423335575338569e-02 8.63862547850183064290785495131786e-03
            4.54559036809930927525158494972857e-01 6.48529251240834991865114034226281e-02 8.93313629439488644801148353735698e-03
            2.88845281940968090506061116684577e-01 2.38118396866765308361735264952586e-01 9.00509278571951822522922981306692e-03
            5.32163580900152477504150283493800e-01 3.57017738203314505263108458166244e-01 9.38422442686159125058154018006462e-03
            4.73641029272273195172004989217385e-01 3.35467115867110698967934467873420e-01 9.68975049682432691688926951201211e-03
            1.37215640807511696230847064725822e-01 2.43905972104074802997430992945738e-01 9.93133031363590580709033162065680e-03
            6.21391658733018270588388531905366e-01 1.35037461036809303127625980778248e-01 1.06473323149699362205611308240805e-02
            1.52603655913764513218922047599335e-01 6.34085174784072780340693498146720e-01 1.07634538251510751549755440237277e-02
            2.53542499404753318703598097272334e-01 6.14568220520721020250221044989303e-01 1.08165515377311761968659453714281e-02
            6.30459386519128472947670616122195e-01 2.25032882061072608825824659106729e-01 1.11185427993754516046154279251823e-02
            2.30848514163360801765279006758647e-01 1.50778181472718098010687981513911e-01 1.13180953597056700027367881489226e-02
            3.60607666765002221609393018297851e-01 1.47657125036602110412786714732647e-01 1.14605050959253797898673710164985e-02
            1.68825843777590689498424580961000e-01 4.96801767224627877084230931359343e-01 1.16809125567246402388477122258337e-02
            5.12950485421223789650468916079262e-01 2.34938455462988304844884623889811e-01 1.18272157420078599665558272135968e-02
            4.87479899308838782179265081140329e-01 1.44753653681138988451593263562245e-01 1.20912166371753004856515190112987e-02
            1.41411858661172812334783088772383e-01 3.79555454421125593178487633849727e-01 1.21678974927683664769562099650102e-02
            3.79920224601669520581026517902501e-01 4.77536434179863300553137150927796e-01 1.26881968317201117291137535403323e-02
            2.59931264032647602046921520013711e-01 5.04552912634035233274687470839126e-01 1.28339382548148285556610659341459e-02
            3.60690792192417675199322957269032e-01 3.78196347277973687894814247556496e-01 1.29740914380822563306550065931333e-02
            3.85985301830885418894467875361443e-01 2.56761175269934582843234238680452e-01 1.38185025071558449660802381231406e-02
            2.54967729527999675820382208257797e-01 3.69733046040209401006393363786628e-01 1.41803283504474460924305034836834e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    11   26 4.72e-16    0    1
    20   77 1.45e-15    0    8
    22   92 1.72e-15    0   11
    ];




