
function [xyw_bar,pointset_stats]=set_papanicolopulos_C_I_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicolopulos
% "Computation of moderate-degree fully symmetric cubature rules on the
%   triangle using symmetric polynomials and algebraic solving."
% Computer and Mathematics with Applications, 69 (2015), pp. 650-666.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   7 |  15 |   0 |   0 | 2.50e-16 |PI|
% |  10 |  25 |   0 |   0 | 3.89e-16 |PI|
% |  11 |  28 |   1 |   0 | 2.78e-16 |NI|
% |  12 |  33 |   0 |   0 | 3.96e-16 |PI|
% |  13 |  37 |   0 |   0 | 5.55e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

switch deg
    
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.5e-16
        
        xyw_bar=[
            2.43259139835607540724993214098504e-01 2.43259139835607540724993214098504e-01 5.13481720328784918550013571802992e-01 1.25393607449303057244094361522002e-01
            2.43259139835607540724993214098504e-01 5.13481720328784918550013571802992e-01 2.43259139835607540724993214098504e-01 1.25393607449303057244094361522002e-01
            5.13481720328784918550013571802992e-01 2.43259139835607540724993214098504e-01 2.43259139835607540724993214098504e-01 1.25393607449303057244094361522002e-01
            5.07143843072070457655975417310401e-02 3.18644189847537062654225792357465e-01 6.30641425845255843007919338560896e-01 7.63063383405417072768983643982210e-02
            5.07143843072070457655975417310401e-02 6.30641425845255843007919338560896e-01 3.18644189847537062654225792357465e-01 7.63063383405417072768983643982210e-02
            3.18644189847537062654225792357465e-01 5.07143843072070457655975417310401e-02 6.30641425845255843007919338560896e-01 7.63063383405417072768983643982210e-02
            3.18644189847537062654225792357465e-01 6.30641425845255843007919338560896e-01 5.07143843072070457655975417310401e-02 7.63063383405417072768983643982210e-02
            6.30641425845255843007919338560896e-01 5.07143843072070457655975417310401e-02 3.18644189847537062654225792357465e-01 7.63063383405417072768983643982210e-02
            6.30641425845255843007919338560896e-01 3.18644189847537062654225792357465e-01 5.07143843072070457655975417310401e-02 7.63063383405417072768983643982210e-02
            4.57208298463203238748420176307263e-02 8.66366313417489958270678584995039e-02 8.67642538811930652542514508240856e-01 2.76635246014734284547564868717018e-02
            4.57208298463203238748420176307263e-02 8.67642538811930652542514508240856e-01 8.66366313417489958270678584995039e-02 2.76635246014734284547564868717018e-02
            8.66366313417489958270678584995039e-02 4.57208298463203238748420176307263e-02 8.67642538811930652542514508240856e-01 2.76635246014734284547564868717018e-02
            8.66366313417489958270678584995039e-02 8.67642538811930652542514508240856e-01 4.57208298463203238748420176307263e-02 2.76635246014734284547564868717018e-02
            8.67642538811930652542514508240856e-01 4.57208298463203238748420176307263e-02 8.66366313417489958270678584995039e-02 2.76635246014734284547564868717018e-02
            8.67642538811930652542514508240856e-01 8.66366313417489958270678584995039e-02 4.57208298463203238748420176307263e-02 2.76635246014734284547564868717018e-02
            ];
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 8.32197369864501462766170902796148e-02
            1.62913117874094764969683524213906e-01 1.62913117874094764969683524213906e-01 6.74173764251810414549481720314361e-01 5.26519494682445923783298269427178e-02
            1.62913117874094764969683524213906e-01 6.74173764251810414549481720314361e-01 1.62913117874094764969683524213906e-01 5.26519494682445923783298269427178e-02
            6.74173764251810414549481720314361e-01 1.62913117874094764969683524213906e-01 1.62913117874094764969683524213906e-01 5.26519494682445923783298269427178e-02
            2.85035002883878355040003782505664e-02 2.85035002883878355040003782505664e-02 9.42992999423224342869787051313324e-01 1.09512883402684106648461437316655e-02
            2.85035002883878355040003782505664e-02 9.42992999423224342869787051313324e-01 2.85035002883878355040003782505664e-02 1.09512883402684106648461437316655e-02
            9.42992999423224342869787051313324e-01 2.85035002883878355040003782505664e-02 2.85035002883878355040003782505664e-02 1.09512883402684106648461437316655e-02
            1.46811505393930397112001173809404e-01 3.36695875278231637750536719977390e-01 5.16492619327837965137462106213206e-01 5.62772797108111802466545725565084e-02
            1.46811505393930397112001173809404e-01 5.16492619327837965137462106213206e-01 3.36695875278231637750536719977390e-01 5.62772797108111802466545725565084e-02
            3.36695875278231637750536719977390e-01 1.46811505393930397112001173809404e-01 5.16492619327837965137462106213206e-01 5.62772797108111802466545725565084e-02
            3.36695875278231637750536719977390e-01 5.16492619327837965137462106213206e-01 1.46811505393930397112001173809404e-01 5.62772797108111802466545725565084e-02
            5.16492619327837965137462106213206e-01 1.46811505393930397112001173809404e-01 3.36695875278231637750536719977390e-01 5.62772797108111802466545725565084e-02
            5.16492619327837965137462106213206e-01 3.36695875278231637750536719977390e-01 1.46811505393930397112001173809404e-01 5.62772797108111802466545725565084e-02
            2.93076045045794729426713587372433e-02 3.63362616994570508666129171615466e-01 6.07329778500850014921752517693676e-01 3.53949477915383933779303049504961e-02
            2.93076045045794729426713587372433e-02 6.07329778500850014921752517693676e-01 3.63362616994570508666129171615466e-01 3.53949477915383933779303049504961e-02
            3.63362616994570508666129171615466e-01 2.93076045045794729426713587372433e-02 6.07329778500850014921752517693676e-01 3.53949477915383933779303049504961e-02
            3.63362616994570508666129171615466e-01 6.07329778500850014921752517693676e-01 2.93076045045794729426713587372433e-02 3.53949477915383933779303049504961e-02
            6.07329778500850014921752517693676e-01 2.93076045045794729426713587372433e-02 3.63362616994570508666129171615466e-01 3.53949477915383933779303049504961e-02
            6.07329778500850014921752517693676e-01 3.63362616994570508666129171615466e-01 2.93076045045794729426713587372433e-02 3.53949477915383933779303049504961e-02
            3.36856986806102903786452884560276e-02 1.53303055169561358583862897830841e-01 8.13011246149828337159704005898675e-01 2.93228640956522366989300820705466e-02
            3.36856986806102903786452884560276e-02 8.13011246149828337159704005898675e-01 1.53303055169561358583862897830841e-01 2.93228640956522366989300820705466e-02
            1.53303055169561358583862897830841e-01 3.36856986806102903786452884560276e-02 8.13011246149828337159704005898675e-01 2.93228640956522366989300820705466e-02
            1.53303055169561358583862897830841e-01 8.13011246149828337159704005898675e-01 3.36856986806102903786452884560276e-02 2.93228640956522366989300820705466e-02
            8.13011246149828337159704005898675e-01 3.36856986806102903786452884560276e-02 1.53303055169561358583862897830841e-01 2.93228640956522366989300820705466e-02
            8.13011246149828337159704005898675e-01 1.53303055169561358583862897830841e-01 3.36856986806102903786452884560276e-02 2.93228640956522366989300820705466e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -6.24016294334824306311304553673835e-02
            2.83643552750009630969429963442963e-01 2.83643552750009630969429963442963e-01 4.32712894499980738061140073114075e-01 8.17271708386495682185923783436010e-02
            2.83643552750009630969429963442963e-01 4.32712894499980738061140073114075e-01 2.83643552750009630969429963442963e-01 8.17271708386495682185923783436010e-02
            4.32712894499980738061140073114075e-01 2.83643552750009630969429963442963e-01 2.83643552750009630969429963442963e-01 8.17271708386495682185923783436010e-02
            1.44395126496050241193813690188108e-01 1.44395126496050241193813690188108e-01 7.11209747007899517612372619623784e-01 4.89646525058673315333734876730887e-02
            1.44395126496050241193813690188108e-01 7.11209747007899517612372619623784e-01 1.44395126496050241193813690188108e-01 4.89646525058673315333734876730887e-02
            7.11209747007899517612372619623784e-01 1.44395126496050241193813690188108e-01 1.44395126496050241193813690188108e-01 4.89646525058673315333734876730887e-02
            3.27306469664559104848500226125907e-02 3.27306469664559104848500226125907e-02 9.34538706067088220663663378218189e-01 1.38013538862702556803130349294406e-02
            3.27306469664559104848500226125907e-02 9.34538706067088220663663378218189e-01 3.27306469664559104848500226125907e-02 1.38013538862702556803130349294406e-02
            9.34538706067088220663663378218189e-01 3.27306469664559104848500226125907e-02 3.27306469664559104848500226125907e-02 1.38013538862702556803130349294406e-02
            1.16396413400493350942532799763285e-01 3.35350078525060657508305439478136e-01 5.48253508074445949915798337315209e-01 5.34023517959382465480899782050983e-02
            1.16396413400493350942532799763285e-01 5.48253508074445949915798337315209e-01 3.35350078525060657508305439478136e-01 5.34023517959382465480899782050983e-02
            3.35350078525060657508305439478136e-01 1.16396413400493350942532799763285e-01 5.48253508074445949915798337315209e-01 5.34023517959382465480899782050983e-02
            3.35350078525060657508305439478136e-01 5.48253508074445949915798337315209e-01 1.16396413400493350942532799763285e-01 5.34023517959382465480899782050983e-02
            5.48253508074445949915798337315209e-01 1.16396413400493350942532799763285e-01 3.35350078525060657508305439478136e-01 5.34023517959382465480899782050983e-02
            5.48253508074445949915798337315209e-01 3.35350078525060657508305439478136e-01 1.16396413400493350942532799763285e-01 5.34023517959382465480899782050983e-02
            2.26115133003882071149881483052013e-02 3.72494921891071029129705038940301e-01 6.04893564808540729060837293218356e-01 2.63250587353120457656530106760329e-02
            2.26115133003882071149881483052013e-02 6.04893564808540729060837293218356e-01 3.72494921891071029129705038940301e-01 2.63250587353120457656530106760329e-02
            3.72494921891071029129705038940301e-01 2.26115133003882071149881483052013e-02 6.04893564808540729060837293218356e-01 2.63250587353120457656530106760329e-02
            3.72494921891071029129705038940301e-01 6.04893564808540729060837293218356e-01 2.26115133003882071149881483052013e-02 2.63250587353120457656530106760329e-02
            6.04893564808540729060837293218356e-01 2.26115133003882071149881483052013e-02 3.72494921891071029129705038940301e-01 2.63250587353120457656530106760329e-02
            6.04893564808540729060837293218356e-01 3.72494921891071029129705038940301e-01 2.26115133003882071149881483052013e-02 2.63250587353120457656530106760329e-02
            2.79902256820809824944262800272554e-02 1.64901310471914669397719421795045e-01 8.07108463846004320352278682548786e-01 2.50929390922698704324833585133092e-02
            2.79902256820809824944262800272554e-02 8.07108463846004320352278682548786e-01 1.64901310471914669397719421795045e-01 2.50929390922698704324833585133092e-02
            1.64901310471914669397719421795045e-01 2.79902256820809824944262800272554e-02 8.07108463846004320352278682548786e-01 2.50929390922698704324833585133092e-02
            1.64901310471914669397719421795045e-01 8.07108463846004320352278682548786e-01 2.79902256820809824944262800272554e-02 2.50929390922698704324833585133092e-02
            8.07108463846004320352278682548786e-01 2.79902256820809824944262800272554e-02 1.64901310471914669397719421795045e-01 2.50929390922698704324833585133092e-02
            8.07108463846004320352278682548786e-01 1.64901310471914669397719421795045e-01 2.79902256820809824944262800272554e-02 2.50929390922698704324833585133092e-02
            ];
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   33
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.0e-16
        
        xyw_bar=[
            2.71462507014926079929040270144469e-01 2.71462507014926079929040270144469e-01 4.57074985970147840141919459711062e-01 6.25412131959027506322712497421890e-02
            2.71462507014926079929040270144469e-01 4.57074985970147840141919459711062e-01 2.71462507014926079929040270144469e-01 6.25412131959027506322712497421890e-02
            4.57074985970147840141919459711062e-01 2.71462507014926079929040270144469e-01 2.71462507014926079929040270144469e-01 6.25412131959027506322712497421890e-02
            4.40111648658593090921442581020528e-01 4.40111648658593090921442581020528e-01 1.19776702682813818157114837958943e-01 4.99183349280609284237542055961967e-02
            4.40111648658593090921442581020528e-01 1.19776702682813818157114837958943e-01 4.40111648658593090921442581020528e-01 4.99183349280609284237542055961967e-02
            1.19776702682813818157114837958943e-01 4.40111648658593090921442581020528e-01 4.40111648658593090921442581020528e-01 4.99183349280609284237542055961967e-02
            4.88203750945541525840809526926023e-01 4.88203750945541525840809526926023e-01 2.35924981089169483183809461479541e-02 2.42668380814520245891685590322595e-02
            4.88203750945541525840809526926023e-01 2.35924981089169483183809461479541e-02 4.88203750945541525840809526926023e-01 2.42668380814520245891685590322595e-02
            2.35924981089169483183809461479541e-02 4.88203750945541525840809526926023e-01 4.88203750945541525840809526926023e-01 2.42668380814520245891685590322595e-02
            1.09257827659354295191107553364418e-01 1.09257827659354295191107553364418e-01 7.81484344681291354106633662013337e-01 2.84860520688775369080314447955971e-02
            1.09257827659354295191107553364418e-01 7.81484344681291354106633662013337e-01 1.09257827659354295191107553364418e-01 2.84860520688775369080314447955971e-02
            7.81484344681291354106633662013337e-01 1.09257827659354295191107553364418e-01 1.09257827659354295191107553364418e-01 2.84860520688775369080314447955971e-02
            2.46463634363355936496287057480004e-02 2.46463634363355936496287057480004e-02 9.50707273127328833517424300225684e-01 7.93164250997363713679977337278615e-03
            2.46463634363355936496287057480004e-02 9.50707273127328833517424300225684e-01 2.46463634363355936496287057480004e-02 7.93164250997363713679977337278615e-03
            9.50707273127328833517424300225684e-01 2.46463634363355936496287057480004e-02 2.46463634363355936496287057480004e-02 7.93164250997363713679977337278615e-03
            1.16296019677926590341066059863806e-01 2.55454228638517355509662820622907e-01 6.28249751683556123538210158585571e-01 4.32273636594142016131847583437775e-02
            1.16296019677926590341066059863806e-01 6.28249751683556123538210158585571e-01 2.55454228638517355509662820622907e-01 4.32273636594142016131847583437775e-02
            2.55454228638517355509662820622907e-01 1.16296019677926590341066059863806e-01 6.28249751683556123538210158585571e-01 4.32273636594142016131847583437775e-02
            2.55454228638517355509662820622907e-01 6.28249751683556123538210158585571e-01 1.16296019677926590341066059863806e-01 4.32273636594142016131847583437775e-02
            6.28249751683556123538210158585571e-01 1.16296019677926590341066059863806e-01 2.55454228638517355509662820622907e-01 4.32273636594142016131847583437775e-02
            6.28249751683556123538210158585571e-01 2.55454228638517355509662820622907e-01 1.16296019677926590341066059863806e-01 4.32273636594142016131847583437775e-02
            2.30341563552671386994052937779998e-02 2.91655679738340944950891753251199e-01 6.85310163906391878185786481481045e-01 2.17835850386075557949538961111102e-02
            2.30341563552671386994052937779998e-02 6.85310163906391878185786481481045e-01 2.91655679738340944950891753251199e-01 2.17835850386075557949538961111102e-02
            2.91655679738340944950891753251199e-01 2.30341563552671386994052937779998e-02 6.85310163906391878185786481481045e-01 2.17835850386075557949538961111102e-02
            2.91655679738340944950891753251199e-01 6.85310163906391878185786481481045e-01 2.30341563552671386994052937779998e-02 2.17835850386075557949538961111102e-02
            6.85310163906391878185786481481045e-01 2.30341563552671386994052937779998e-02 2.91655679738340944950891753251199e-01 2.17835850386075557949538961111102e-02
            6.85310163906391878185786481481045e-01 2.91655679738340944950891753251199e-01 2.30341563552671386994052937779998e-02 2.17835850386075557949538961111102e-02
            2.13824902561705887382714763589320e-02 1.27279717233589356739642539650958e-01 8.51337792510240110033237215247937e-01 1.50836775765114360081664557355907e-02
            2.13824902561705887382714763589320e-02 8.51337792510240110033237215247937e-01 1.27279717233589356739642539650958e-01 1.50836775765114360081664557355907e-02
            1.27279717233589356739642539650958e-01 2.13824902561705887382714763589320e-02 8.51337792510240110033237215247937e-01 1.50836775765114360081664557355907e-02
            1.27279717233589356739642539650958e-01 8.51337792510240110033237215247937e-01 2.13824902561705887382714763589320e-02 1.50836775765114360081664557355907e-02
            8.51337792510240110033237215247937e-01 2.13824902561705887382714763589320e-02 1.27279717233589356739642539650958e-01 1.50836775765114360081664557355907e-02
            8.51337792510240110033237215247937e-01 1.27279717233589356739642539650958e-01 2.13824902561705887382714763589320e-02 1.50836775765114360081664557355907e-02
            ];
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.6e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 6.66653118396432209369351085115341e-02
            4.29159612543110746685215417528525e-01 4.29159612543110746685215417528525e-01 1.41680774913778506629569164942950e-01 5.63713831790753280848171868910867e-02
            4.29159612543110746685215417528525e-01 1.41680774913778506629569164942950e-01 4.29159612543110746685215417528525e-01 5.63713831790753280848171868910867e-02
            1.41680774913778506629569164942950e-01 4.29159612543110746685215417528525e-01 4.29159612543110746685215417528525e-01 5.63713831790753280848171868910867e-02
            2.25840072867902030839815097351675e-01 2.25840072867902030839815097351675e-01 5.48319854264195938320369805296650e-01 5.70368795313359183696277909803030e-02
            2.25840072867902030839815097351675e-01 5.48319854264195938320369805296650e-01 2.25840072867902030839815097351675e-01 5.70368795313359183696277909803030e-02
            5.48319854264195938320369805296650e-01 2.25840072867902030839815097351675e-01 2.25840072867902030839815097351675e-01 5.70368795313359183696277909803030e-02
            4.87428645297366236466274358463124e-01 4.87428645297366236466274358463124e-01 2.51427094052675270674512830737513e-02 2.70477028810601170805139048525234e-02
            4.87428645297366236466274358463124e-01 2.51427094052675270674512830737513e-02 4.87428645297366236466274358463124e-01 2.70477028810601170805139048525234e-02
            2.51427094052675270674512830737513e-02 4.87428645297366236466274358463124e-01 4.87428645297366236466274358463124e-01 2.70477028810601170805139048525234e-02
            1.24457822063999259953881448836910e-01 1.24457822063999259953881448836910e-01 7.51084355872001507847812717955094e-01 3.25457771010621010887575721426401e-02
            1.24457822063999259953881448836910e-01 7.51084355872001507847812717955094e-01 1.24457822063999259953881448836910e-01 3.25457771010621010887575721426401e-02
            7.51084355872001507847812717955094e-01 1.24457822063999259953881448836910e-01 1.24457822063999259953881448836910e-01 3.25457771010621010887575721426401e-02
            7.12744715119110472389962751549319e-02 2.84520764019818239720649444279843e-01 6.44204764468270685284778664936312e-01 3.84621038070676393716418317580974e-02
            7.12744715119110472389962751549319e-02 6.44204764468270685284778664936312e-01 2.84520764019818239720649444279843e-01 3.84621038070676393716418317580974e-02
            2.84520764019818239720649444279843e-01 7.12744715119110472389962751549319e-02 6.44204764468270685284778664936312e-01 3.84621038070676393716418317580974e-02
            2.84520764019818239720649444279843e-01 6.44204764468270685284778664936312e-01 7.12744715119110472389962751549319e-02 3.84621038070676393716418317580974e-02
            6.44204764468270685284778664936312e-01 7.12744715119110472389962751549319e-02 2.84520764019818239720649444279843e-01 3.84621038070676393716418317580974e-02
            6.44204764468270685284778664936312e-01 2.84520764019818239720649444279843e-01 7.12744715119110472389962751549319e-02 3.84621038070676393716418317580974e-02
            4.93532348954305553900834269143161e-03 2.86214753544342004332179385528434e-01 7.08849922966114931455194891896099e-01 9.13843881437103461307103202670987e-03
            4.93532348954305553900834269143161e-03 7.08849922966114931455194891896099e-01 2.86214753544342004332179385528434e-01 9.13843881437103461307103202670987e-03
            2.86214753544342004332179385528434e-01 4.93532348954305553900834269143161e-03 7.08849922966114931455194891896099e-01 9.13843881437103461307103202670987e-03
            2.86214753544342004332179385528434e-01 7.08849922966114931455194891896099e-01 4.93532348954305553900834269143161e-03 9.13843881437103461307103202670987e-03
            7.08849922966114931455194891896099e-01 4.93532348954305553900834269143161e-03 2.86214753544342004332179385528434e-01 9.13843881437103461307103202670987e-03
            7.08849922966114931455194891896099e-01 2.86214753544342004332179385528434e-01 4.93532348954305553900834269143161e-03 9.13843881437103461307103202670987e-03
            2.67328097943362943955669663864683e-02 1.24525415851328244420948010429129e-01 8.48741774354335398733439888019348e-01 1.75134020509193320813690064596813e-02
            2.67328097943362943955669663864683e-02 8.48741774354335398733439888019348e-01 1.24525415851328244420948010429129e-01 1.75134020509193320813690064596813e-02
            1.24525415851328244420948010429129e-01 2.67328097943362943955669663864683e-02 8.48741774354335398733439888019348e-01 1.75134020509193320813690064596813e-02
            1.24525415851328244420948010429129e-01 8.48741774354335398733439888019348e-01 2.67328097943362943955669663864683e-02 1.75134020509193320813690064596813e-02
            8.48741774354335398733439888019348e-01 2.67328097943362943955669663864683e-02 1.24525415851328244420948010429129e-01 1.75134020509193320813690064596813e-02
            8.48741774354335398733439888019348e-01 1.24525415851328244420948010429129e-01 2.67328097943362943955669663864683e-02 1.75134020509193320813690064596813e-02
            1.63507805075914468273534652098533e-02 3.28542486808598085956667489426763e-02 9.50794970811548734168638929986628e-01 3.94096534143476180667153840886385e-03
            1.63507805075914468273534652098533e-02 9.50794970811548734168638929986628e-01 3.28542486808598085956667489426763e-02 3.94096534143476180667153840886385e-03
            3.28542486808598085956667489426763e-02 1.63507805075914468273534652098533e-02 9.50794970811548734168638929986628e-01 3.94096534143476180667153840886385e-03
            3.28542486808598085956667489426763e-02 9.50794970811548734168638929986628e-01 1.63507805075914468273534652098533e-02 3.94096534143476180667153840886385e-03
            9.50794970811548734168638929986628e-01 1.63507805075914468273534652098533e-02 3.28542486808598085956667489426763e-02 3.94096534143476180667153840886385e-03
            9.50794970811548734168638929986628e-01 3.28542486808598085956667489426763e-02 1.63507805075914468273534652098533e-02 3.94096534143476180667153840886385e-03
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    7   15 2.50e-16    0    0
    10   25 3.89e-16    0    0
    11   28 2.78e-16    1    0
    12   33 3.96e-16    0    0
    13   37 5.55e-16    0    0
    ];





