
function [xyw,pointset_stats]=set_papanicolopulos_C_I_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% S-A. Papanicolopulos
% "Computation of moderate-degree fully symmetric cubature rules on the
%   triangle using symmetric polynomials and algebraic solving."
% Computer and Mathematics with Applications, 69 (2015), pp. 650-666.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   7 |  15 |   0 |   0 | 2.50e-16 |PI|
% |  10 |  25 |   0 |   0 | 3.89e-16 |PI|
% |  11 |  28 |   1 |   0 | 2.78e-16 |NI|
% |  12 |  33 |   0 |   0 | 3.96e-16 |PI|
% |  13 |  37 |   0 |   0 | 5.55e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.5e-16
        
        xyw=[
            2.43259139835607540724993214098504e-01 2.43259139835607540724993214098504e-01 6.26968037246515286220471807610011e-02
            2.43259139835607540724993214098504e-01 5.13481720328784918550013571802992e-01 6.26968037246515286220471807610011e-02
            5.13481720328784918550013571802992e-01 2.43259139835607540724993214098504e-01 6.26968037246515286220471807610011e-02
            5.07143843072070457655975417310401e-02 3.18644189847537062654225792357465e-01 3.81531691702708536384491821991105e-02
            5.07143843072070457655975417310401e-02 6.30641425845255843007919338560896e-01 3.81531691702708536384491821991105e-02
            3.18644189847537062654225792357465e-01 5.07143843072070457655975417310401e-02 3.81531691702708536384491821991105e-02
            3.18644189847537062654225792357465e-01 6.30641425845255843007919338560896e-01 3.81531691702708536384491821991105e-02
            6.30641425845255843007919338560896e-01 5.07143843072070457655975417310401e-02 3.81531691702708536384491821991105e-02
            6.30641425845255843007919338560896e-01 3.18644189847537062654225792357465e-01 3.81531691702708536384491821991105e-02
            4.57208298463203238748420176307263e-02 8.66366313417489958270678584995039e-02 1.38317623007367142273782434358509e-02
            4.57208298463203238748420176307263e-02 8.67642538811930652542514508240856e-01 1.38317623007367142273782434358509e-02
            8.66366313417489958270678584995039e-02 4.57208298463203238748420176307263e-02 1.38317623007367142273782434358509e-02
            8.66366313417489958270678584995039e-02 8.67642538811930652542514508240856e-01 1.38317623007367142273782434358509e-02
            8.67642538811930652542514508240856e-01 4.57208298463203238748420176307263e-02 1.38317623007367142273782434358509e-02
            8.67642538811930652542514508240856e-01 8.66366313417489958270678584995039e-02 1.38317623007367142273782434358509e-02
            ];
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.16098684932250731383085451398074e-02
            1.62913117874094764969683524213906e-01 1.62913117874094764969683524213906e-01 2.63259747341222961891649134713589e-02
            1.62913117874094764969683524213906e-01 6.74173764251810414549481720314361e-01 2.63259747341222961891649134713589e-02
            6.74173764251810414549481720314361e-01 1.62913117874094764969683524213906e-01 2.63259747341222961891649134713589e-02
            2.85035002883878355040003782505664e-02 2.85035002883878355040003782505664e-02 5.47564417013420533242307186583275e-03
            2.85035002883878355040003782505664e-02 9.42992999423224342869787051313324e-01 5.47564417013420533242307186583275e-03
            9.42992999423224342869787051313324e-01 2.85035002883878355040003782505664e-02 5.47564417013420533242307186583275e-03
            1.46811505393930397112001173809404e-01 3.36695875278231637750536719977390e-01 2.81386398554055901233272862782542e-02
            1.46811505393930397112001173809404e-01 5.16492619327837965137462106213206e-01 2.81386398554055901233272862782542e-02
            3.36695875278231637750536719977390e-01 1.46811505393930397112001173809404e-01 2.81386398554055901233272862782542e-02
            3.36695875278231637750536719977390e-01 5.16492619327837965137462106213206e-01 2.81386398554055901233272862782542e-02
            5.16492619327837965137462106213206e-01 1.46811505393930397112001173809404e-01 2.81386398554055901233272862782542e-02
            5.16492619327837965137462106213206e-01 3.36695875278231637750536719977390e-01 2.81386398554055901233272862782542e-02
            2.93076045045794729426713587372433e-02 3.63362616994570508666129171615466e-01 1.76974738957691966889651524752480e-02
            2.93076045045794729426713587372433e-02 6.07329778500850014921752517693676e-01 1.76974738957691966889651524752480e-02
            3.63362616994570508666129171615466e-01 2.93076045045794729426713587372433e-02 1.76974738957691966889651524752480e-02
            3.63362616994570508666129171615466e-01 6.07329778500850014921752517693676e-01 1.76974738957691966889651524752480e-02
            6.07329778500850014921752517693676e-01 2.93076045045794729426713587372433e-02 1.76974738957691966889651524752480e-02
            6.07329778500850014921752517693676e-01 3.63362616994570508666129171615466e-01 1.76974738957691966889651524752480e-02
            3.36856986806102903786452884560276e-02 1.53303055169561358583862897830841e-01 1.46614320478261183494650410352733e-02
            3.36856986806102903786452884560276e-02 8.13011246149828337159704005898675e-01 1.46614320478261183494650410352733e-02
            1.53303055169561358583862897830841e-01 3.36856986806102903786452884560276e-02 1.46614320478261183494650410352733e-02
            1.53303055169561358583862897830841e-01 8.13011246149828337159704005898675e-01 1.46614320478261183494650410352733e-02
            8.13011246149828337159704005898675e-01 3.36856986806102903786452884560276e-02 1.46614320478261183494650410352733e-02
            8.13011246149828337159704005898675e-01 1.53303055169561358583862897830841e-01 1.46614320478261183494650410352733e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -3.12008147167412153155652276836918e-02
            2.83643552750009630969429963442963e-01 2.83643552750009630969429963442963e-01 4.08635854193247841092961891718005e-02
            2.83643552750009630969429963442963e-01 4.32712894499980738061140073114075e-01 4.08635854193247841092961891718005e-02
            4.32712894499980738061140073114075e-01 2.83643552750009630969429963442963e-01 4.08635854193247841092961891718005e-02
            1.44395126496050241193813690188108e-01 1.44395126496050241193813690188108e-01 2.44823262529336657666867438365443e-02
            1.44395126496050241193813690188108e-01 7.11209747007899517612372619623784e-01 2.44823262529336657666867438365443e-02
            7.11209747007899517612372619623784e-01 1.44395126496050241193813690188108e-01 2.44823262529336657666867438365443e-02
            3.27306469664559104848500226125907e-02 3.27306469664559104848500226125907e-02 6.90067694313512784015651746472031e-03
            3.27306469664559104848500226125907e-02 9.34538706067088220663663378218189e-01 6.90067694313512784015651746472031e-03
            9.34538706067088220663663378218189e-01 3.27306469664559104848500226125907e-02 6.90067694313512784015651746472031e-03
            1.16396413400493350942532799763285e-01 3.35350078525060657508305439478136e-01 2.67011758979691232740449891025492e-02
            1.16396413400493350942532799763285e-01 5.48253508074445949915798337315209e-01 2.67011758979691232740449891025492e-02
            3.35350078525060657508305439478136e-01 1.16396413400493350942532799763285e-01 2.67011758979691232740449891025492e-02
            3.35350078525060657508305439478136e-01 5.48253508074445949915798337315209e-01 2.67011758979691232740449891025492e-02
            5.48253508074445949915798337315209e-01 1.16396413400493350942532799763285e-01 2.67011758979691232740449891025492e-02
            5.48253508074445949915798337315209e-01 3.35350078525060657508305439478136e-01 2.67011758979691232740449891025492e-02
            2.26115133003882071149881483052013e-02 3.72494921891071029129705038940301e-01 1.31625293676560228828265053380164e-02
            2.26115133003882071149881483052013e-02 6.04893564808540729060837293218356e-01 1.31625293676560228828265053380164e-02
            3.72494921891071029129705038940301e-01 2.26115133003882071149881483052013e-02 1.31625293676560228828265053380164e-02
            3.72494921891071029129705038940301e-01 6.04893564808540729060837293218356e-01 1.31625293676560228828265053380164e-02
            6.04893564808540729060837293218356e-01 2.26115133003882071149881483052013e-02 1.31625293676560228828265053380164e-02
            6.04893564808540729060837293218356e-01 3.72494921891071029129705038940301e-01 1.31625293676560228828265053380164e-02
            2.79902256820809824944262800272554e-02 1.64901310471914669397719421795045e-01 1.25464695461349352162416792566546e-02
            2.79902256820809824944262800272554e-02 8.07108463846004320352278682548786e-01 1.25464695461349352162416792566546e-02
            1.64901310471914669397719421795045e-01 2.79902256820809824944262800272554e-02 1.25464695461349352162416792566546e-02
            1.64901310471914669397719421795045e-01 8.07108463846004320352278682548786e-01 1.25464695461349352162416792566546e-02
            8.07108463846004320352278682548786e-01 2.79902256820809824944262800272554e-02 1.25464695461349352162416792566546e-02
            8.07108463846004320352278682548786e-01 1.64901310471914669397719421795045e-01 1.25464695461349352162416792566546e-02
            ];
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   33
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.0e-16
        
        xyw=[
            2.71462507014926079929040270144469e-01 2.71462507014926079929040270144469e-01 3.12706065979513753161356248710945e-02
            2.71462507014926079929040270144469e-01 4.57074985970147840141919459711062e-01 3.12706065979513753161356248710945e-02
            4.57074985970147840141919459711062e-01 2.71462507014926079929040270144469e-01 3.12706065979513753161356248710945e-02
            4.40111648658593090921442581020528e-01 4.40111648658593090921442581020528e-01 2.49591674640304642118771027980983e-02
            4.40111648658593090921442581020528e-01 1.19776702682813818157114837958943e-01 2.49591674640304642118771027980983e-02
            1.19776702682813818157114837958943e-01 4.40111648658593090921442581020528e-01 2.49591674640304642118771027980983e-02
            4.88203750945541525840809526926023e-01 4.88203750945541525840809526926023e-01 1.21334190407260122945842795161298e-02
            4.88203750945541525840809526926023e-01 2.35924981089169483183809461479541e-02 1.21334190407260122945842795161298e-02
            2.35924981089169483183809461479541e-02 4.88203750945541525840809526926023e-01 1.21334190407260122945842795161298e-02
            1.09257827659354295191107553364418e-01 1.09257827659354295191107553364418e-01 1.42430260344387684540157223977985e-02
            1.09257827659354295191107553364418e-01 7.81484344681291354106633662013337e-01 1.42430260344387684540157223977985e-02
            7.81484344681291354106633662013337e-01 1.09257827659354295191107553364418e-01 1.42430260344387684540157223977985e-02
            2.46463634363355936496287057480004e-02 2.46463634363355936496287057480004e-02 3.96582125498681856839988668639307e-03
            2.46463634363355936496287057480004e-02 9.50707273127328833517424300225684e-01 3.96582125498681856839988668639307e-03
            9.50707273127328833517424300225684e-01 2.46463634363355936496287057480004e-02 3.96582125498681856839988668639307e-03
            1.16296019677926590341066059863806e-01 2.55454228638517355509662820622907e-01 2.16136818297071008065923791718888e-02
            1.16296019677926590341066059863806e-01 6.28249751683556123538210158585571e-01 2.16136818297071008065923791718888e-02
            2.55454228638517355509662820622907e-01 1.16296019677926590341066059863806e-01 2.16136818297071008065923791718888e-02
            2.55454228638517355509662820622907e-01 6.28249751683556123538210158585571e-01 2.16136818297071008065923791718888e-02
            6.28249751683556123538210158585571e-01 1.16296019677926590341066059863806e-01 2.16136818297071008065923791718888e-02
            6.28249751683556123538210158585571e-01 2.55454228638517355509662820622907e-01 2.16136818297071008065923791718888e-02
            2.30341563552671386994052937779998e-02 2.91655679738340944950891753251199e-01 1.08917925193037778974769480555551e-02
            2.30341563552671386994052937779998e-02 6.85310163906391878185786481481045e-01 1.08917925193037778974769480555551e-02
            2.91655679738340944950891753251199e-01 2.30341563552671386994052937779998e-02 1.08917925193037778974769480555551e-02
            2.91655679738340944950891753251199e-01 6.85310163906391878185786481481045e-01 1.08917925193037778974769480555551e-02
            6.85310163906391878185786481481045e-01 2.30341563552671386994052937779998e-02 1.08917925193037778974769480555551e-02
            6.85310163906391878185786481481045e-01 2.91655679738340944950891753251199e-01 1.08917925193037778974769480555551e-02
            2.13824902561705887382714763589320e-02 1.27279717233589356739642539650958e-01 7.54183878825571800408322786779536e-03
            2.13824902561705887382714763589320e-02 8.51337792510240110033237215247937e-01 7.54183878825571800408322786779536e-03
            1.27279717233589356739642539650958e-01 2.13824902561705887382714763589320e-02 7.54183878825571800408322786779536e-03
            1.27279717233589356739642539650958e-01 8.51337792510240110033237215247937e-01 7.54183878825571800408322786779536e-03
            8.51337792510240110033237215247937e-01 2.13824902561705887382714763589320e-02 7.54183878825571800408322786779536e-03
            8.51337792510240110033237215247937e-01 1.27279717233589356739642539650958e-01 7.54183878825571800408322786779536e-03
            ];
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.6e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33326559198216104684675542557670e-02
            4.29159612543110746685215417528525e-01 4.29159612543110746685215417528525e-01 2.81856915895376640424085934455434e-02
            4.29159612543110746685215417528525e-01 1.41680774913778506629569164942950e-01 2.81856915895376640424085934455434e-02
            1.41680774913778506629569164942950e-01 4.29159612543110746685215417528525e-01 2.81856915895376640424085934455434e-02
            2.25840072867902030839815097351675e-01 2.25840072867902030839815097351675e-01 2.85184397656679591848138954901515e-02
            2.25840072867902030839815097351675e-01 5.48319854264195938320369805296650e-01 2.85184397656679591848138954901515e-02
            5.48319854264195938320369805296650e-01 2.25840072867902030839815097351675e-01 2.85184397656679591848138954901515e-02
            4.87428645297366236466274358463124e-01 4.87428645297366236466274358463124e-01 1.35238514405300585402569524262617e-02
            4.87428645297366236466274358463124e-01 2.51427094052675270674512830737513e-02 1.35238514405300585402569524262617e-02
            2.51427094052675270674512830737513e-02 4.87428645297366236466274358463124e-01 1.35238514405300585402569524262617e-02
            1.24457822063999259953881448836910e-01 1.24457822063999259953881448836910e-01 1.62728885505310505443787860713201e-02
            1.24457822063999259953881448836910e-01 7.51084355872001507847812717955094e-01 1.62728885505310505443787860713201e-02
            7.51084355872001507847812717955094e-01 1.24457822063999259953881448836910e-01 1.62728885505310505443787860713201e-02
            7.12744715119110472389962751549319e-02 2.84520764019818239720649444279843e-01 1.92310519035338196858209158790487e-02
            7.12744715119110472389962751549319e-02 6.44204764468270685284778664936312e-01 1.92310519035338196858209158790487e-02
            2.84520764019818239720649444279843e-01 7.12744715119110472389962751549319e-02 1.92310519035338196858209158790487e-02
            2.84520764019818239720649444279843e-01 6.44204764468270685284778664936312e-01 1.92310519035338196858209158790487e-02
            6.44204764468270685284778664936312e-01 7.12744715119110472389962751549319e-02 1.92310519035338196858209158790487e-02
            6.44204764468270685284778664936312e-01 2.84520764019818239720649444279843e-01 1.92310519035338196858209158790487e-02
            4.93532348954305553900834269143161e-03 2.86214753544342004332179385528434e-01 4.56921940718551730653551601335494e-03
            4.93532348954305553900834269143161e-03 7.08849922966114931455194891896099e-01 4.56921940718551730653551601335494e-03
            2.86214753544342004332179385528434e-01 4.93532348954305553900834269143161e-03 4.56921940718551730653551601335494e-03
            2.86214753544342004332179385528434e-01 7.08849922966114931455194891896099e-01 4.56921940718551730653551601335494e-03
            7.08849922966114931455194891896099e-01 4.93532348954305553900834269143161e-03 4.56921940718551730653551601335494e-03
            7.08849922966114931455194891896099e-01 2.86214753544342004332179385528434e-01 4.56921940718551730653551601335494e-03
            2.67328097943362943955669663864683e-02 1.24525415851328244420948010429129e-01 8.75670102545966604068450322984063e-03
            2.67328097943362943955669663864683e-02 8.48741774354335398733439888019348e-01 8.75670102545966604068450322984063e-03
            1.24525415851328244420948010429129e-01 2.67328097943362943955669663864683e-02 8.75670102545966604068450322984063e-03
            1.24525415851328244420948010429129e-01 8.48741774354335398733439888019348e-01 8.75670102545966604068450322984063e-03
            8.48741774354335398733439888019348e-01 2.67328097943362943955669663864683e-02 8.75670102545966604068450322984063e-03
            8.48741774354335398733439888019348e-01 1.24525415851328244420948010429129e-01 8.75670102545966604068450322984063e-03
            1.63507805075914468273534652098533e-02 3.28542486808598085956667489426763e-02 1.97048267071738090333576920443193e-03
            1.63507805075914468273534652098533e-02 9.50794970811548734168638929986628e-01 1.97048267071738090333576920443193e-03
            3.28542486808598085956667489426763e-02 1.63507805075914468273534652098533e-02 1.97048267071738090333576920443193e-03
            3.28542486808598085956667489426763e-02 9.50794970811548734168638929986628e-01 1.97048267071738090333576920443193e-03
            9.50794970811548734168638929986628e-01 1.63507805075914468273534652098533e-02 1.97048267071738090333576920443193e-03
            9.50794970811548734168638929986628e-01 3.28542486808598085956667489426763e-02 1.97048267071738090333576920443193e-03
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    7   15 2.50e-16    0    0
    10   25 3.89e-16    0    0
    11   28 2.78e-16    1    0
    12   33 3.96e-16    0    0
    13   37 5.55e-16    0    0
    ];




