
function [S1,S2,S3,pointset_stats]=set_papanicolopulos_C_II_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  S-A. Papanicolopulos,
%  "Computation of moderate-degree fully symmetric cubature rules on the
%    triangle using symmetric polynomials and algebraic solving."
%  Computer and Mathematics with Applications, 69 (2015), pp. 650-666.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  11 |  28 |   3 |   0 | 1.60e-14 |NI|
% |  12 |  33 |   3 |   0 | 1.17e-15 |NI|
% |  13 |  37 |   0 |   0 | 7.49e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 1.6e-14
        
        S1=[
            2.03493750703026110571158824313898e+00 2.27311897192939399436895087092125e-01 2.53974429391883249618189211105346e-01
            3.40151935747453199043732752215874e-02 3.06550389238404094593981596972299e-02 2.51252055660424522542939484992530e-01
            7.20470251861257942466165715700299e-03 1.50093732875763866477236696539421e-03 6.56115533034295206338271100321435e-02
            ];
        
        S2=[
            4.49467364188643470068740271017305e-02 4.81906832436432119859404110684409e-01
            4.11001288751976431856682836496475e-02 9.44764784815316227550852090644184e-02
            -3.96899083454612799926053412491456e+00 2.41628110011529895206905393933994e-01
            ];
        
        S3=[
            1.91887489014483408888978033246531e-01
            ];
        
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   33
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 1.2e-15
        
        S1=[
            5.49181083878229475692123173757864e-02 1.20224131616567170288689681001415e-01 3.31934664120596079062153194172424e-01
            2.54455519405798295806686581954636e-02 2.40569154717877979610118899245208e-02 2.63369080790401555169921721244464e-01
            6.83308723631566444778329127984762e-02 4.34670171673780317278534823799419e-02 7.88721647784638990597017027539550e-02
            ];
        
        S2=[
            5.99215793004098037921600905519881e-02 2.73514430547067755039591929744347e-01
            2.80787564395475197631668606845778e-02 4.88155411146674322875327334259055e-01
            5.25289960177231299298661326702131e-02 1.33917689670119299805151058535557e-01
            1.61735562762316633679537947188010e-03 3.62394469687571819244142901084160e-03
            -1.06202419435089137622618693512777e-01 6.27332053037413378548947662238788e-02
            ];
        
        S3=[];
        
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.5e-16
        
        S1=[
            3.46412761408483732550322997667536e-02 6.80122435542066527958127153397072e-02 3.08441760892117777803633771327441e-01
            2.41790398115938193202012485016894e-02 8.78954830321973246132216672776849e-02 1.63597401067850478639797984214965e-01
            9.59068100354326311118846604131249e-03 5.12638910238236850114290632518532e-03 2.72515817773429647186134161529480e-01
            1.49654011051656675446164257436976e-02 2.43701869010938300397217659565285e-02 1.10922042803463405391539708944038e-01
            ];
        
        S2=[
            5.56019675304533292359288054740318e-02 4.26941414259800422481561099630198e-01
            5.82784851191999811459432123683655e-02 2.21372286291832892635156326832657e-01
            2.39944019288947305024173317633540e-02 4.89076946452539351728461269885884e-01
            6.05233710353917167545922950466775e-03 2.15096811088431837111212274749050e-02
            ];
        
        S3=[
            6.79600365868316402817583821160952e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    11   28 1.60e-14    3    0
    12   33 1.17e-15    3    0
    13   37 7.49e-16    0    0
    ];




