
function [xyw,pointset_stats]=set_papanicolopulos_C_II_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  S-A. Papanicolopulos,
%  "Computation of moderate-degree fully symmetric cubature rules on the
%    triangle using symmetric polynomials and algebraic solving."
%  Computer and Mathematics with Applications, 69 (2015), pp. 650-666.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  11 |  28 |   3 |   0 | 1.60e-14 |NI|
% |  12 |  33 |   3 |   0 | 1.17e-15 |NI|
% |  13 |  37 |   0 |   0 | 7.49e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 1.6e-14
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 9.59437445072418987335183260256599e-02
            4.81906832436432119859404110684409e-01 4.81906832436432119859404110684409e-01 2.24733682094322186062473889478497e-02
            4.81906832436432119859404110684409e-01 3.61863351271357602811917786311824e-02 2.24733682094322186062473889478497e-02
            3.61863351271357602811917786311824e-02 4.81906832436432119859404110684409e-01 2.24733682094322186062473889478497e-02
            9.44764784815316227550852090644184e-02 9.44764784815316227550852090644184e-02 2.05500644375988632261975652681940e-02
            9.44764784815316227550852090644184e-02 8.11047043036936754489829581871163e-01 2.05500644375988632261975652681940e-02
            8.11047043036936754489829581871163e-01 9.44764784815316227550852090644184e-02 2.05500644375988632261975652681940e-02
            2.41628110011529895206905393933994e-01 2.41628110011529895206905393933994e-01 -1.98449541727306799643315571302082e+00
            2.41628110011529895206905393933994e-01 5.16743779976940209586189212132012e-01 -1.98449541727306799643315571302082e+00
            5.16743779976940209586189212132012e-01 2.41628110011529895206905393933994e-01 -1.98449541727306799643315571302082e+00
            2.27311897192939399436895087092125e-01 2.53974429391883249618189211105346e-01 1.01746875351513255125723844685126e+00
            2.27311897192939399436895087092125e-01 5.18713673415177378700491317431442e-01 1.01746875351513255125723844685126e+00
            2.53974429391883249618189211105346e-01 2.27311897192939399436895087092125e-01 1.01746875351513255125723844685126e+00
            2.53974429391883249618189211105346e-01 5.18713673415177378700491317431442e-01 1.01746875351513255125723844685126e+00
            5.18713673415177378700491317431442e-01 2.27311897192939399436895087092125e-01 1.01746875351513255125723844685126e+00
            5.18713673415177378700491317431442e-01 2.53974429391883249618189211105346e-01 1.01746875351513255125723844685126e+00
            3.06550389238404094593981596972299e-02 2.51252055660424522542939484992530e-01 1.70075967873726946466561571469356e-02
            3.06550389238404094593981596972299e-02 7.18092905415735116569919682660839e-01 1.70075967873726946466561571469356e-02
            2.51252055660424522542939484992530e-01 3.06550389238404094593981596972299e-02 1.70075967873726946466561571469356e-02
            2.51252055660424522542939484992530e-01 7.18092905415735116569919682660839e-01 1.70075967873726946466561571469356e-02
            7.18092905415735116569919682660839e-01 3.06550389238404094593981596972299e-02 1.70075967873726946466561571469356e-02
            7.18092905415735116569919682660839e-01 2.51252055660424522542939484992530e-01 1.70075967873726946466561571469356e-02
            1.50093732875763866477236696539421e-03 6.56115533034295206338271100321435e-02 3.60235125930629708490560147993165e-03
            1.50093732875763866477236696539421e-03 9.32887509367812839400357916019857e-01 3.60235125930629708490560147993165e-03
            6.56115533034295206338271100321435e-02 1.50093732875763866477236696539421e-03 3.60235125930629708490560147993165e-03
            6.56115533034295206338271100321435e-02 9.32887509367812839400357916019857e-01 3.60235125930629708490560147993165e-03
            9.32887509367812839400357916019857e-01 1.50093732875763866477236696539421e-03 3.60235125930629708490560147993165e-03
            9.32887509367812839400357916019857e-01 6.56115533034295206338271100321435e-02 3.60235125930629708490560147993165e-03
            ];
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   33
        % NEG. W.  :    3
        % OUT PTS. :    0
        % M.E.INF. : 1.2e-15
        
        xyw=[
            2.73514430547067755039591929744347e-01 2.73514430547067755039591929744347e-01 2.99607896502049088349739491832224e-02
            2.73514430547067755039591929744347e-01 4.52971138905864489920816140511306e-01 2.99607896502049088349739491832224e-02
            4.52971138905864489920816140511306e-01 2.73514430547067755039591929744347e-01 2.99607896502049088349739491832224e-02
            4.88155411146674322875327334259055e-01 4.88155411146674322875327334259055e-01 1.40393782197737633510303822959031e-02
            4.88155411146674322875327334259055e-01 2.36891777066513542493453314818908e-02 1.40393782197737633510303822959031e-02
            2.36891777066513542493453314818908e-02 4.88155411146674322875327334259055e-01 1.40393782197737633510303822959031e-02
            1.33917689670119299805151058535557e-01 1.33917689670119299805151058535557e-01 2.62644980088615719038269702423349e-02
            1.33917689670119299805151058535557e-01 7.32164620659761400389697882928886e-01 2.62644980088615719038269702423349e-02
            7.32164620659761400389697882928886e-01 1.33917689670119299805151058535557e-01 2.62644980088615719038269702423349e-02
            3.62394469687571819244142901084160e-03 3.62394469687571819244142901084160e-03 8.08677813811583385238124233040935e-04
            3.62394469687571819244142901084160e-03 9.92752110606248572288734521862352e-01 8.08677813811583385238124233040935e-04
            9.92752110606248572288734521862352e-01 3.62394469687571819244142901084160e-03 8.08677813811583385238124233040935e-04
            6.27332053037413378548947662238788e-02 6.27332053037413378548947662238788e-02 -5.31012097175445826890971545708453e-02
            6.27332053037413378548947662238788e-02 8.74533589392517352045786083181156e-01 -5.31012097175445826890971545708453e-02
            8.74533589392517352045786083181156e-01 6.27332053037413378548947662238788e-02 -5.31012097175445826890971545708453e-02
            1.20224131616567170288689681001415e-01 3.31934664120596079062153194172424e-01 2.74590541939114807235000625951216e-02
            1.20224131616567170288689681001415e-01 5.47841204262836667382430277939420e-01 2.74590541939114807235000625951216e-02
            3.31934664120596079062153194172424e-01 1.20224131616567170288689681001415e-01 2.74590541939114807235000625951216e-02
            3.31934664120596079062153194172424e-01 5.47841204262836667382430277939420e-01 2.74590541939114807235000625951216e-02
            5.47841204262836667382430277939420e-01 1.20224131616567170288689681001415e-01 2.74590541939114807235000625951216e-02
            5.47841204262836667382430277939420e-01 3.31934664120596079062153194172424e-01 2.74590541939114807235000625951216e-02
            2.40569154717877979610118899245208e-02 2.63369080790401555169921721244464e-01 1.27227759702899182597812810513460e-02
            2.40569154717877979610118899245208e-02 7.12574003737810657277407244691858e-01 1.27227759702899182597812810513460e-02
            2.63369080790401555169921721244464e-01 2.40569154717877979610118899245208e-02 1.27227759702899182597812810513460e-02
            2.63369080790401555169921721244464e-01 7.12574003737810657277407244691858e-01 1.27227759702899182597812810513460e-02
            7.12574003737810657277407244691858e-01 2.40569154717877979610118899245208e-02 1.27227759702899182597812810513460e-02
            7.12574003737810657277407244691858e-01 2.63369080790401555169921721244464e-01 1.27227759702899182597812810513460e-02
            4.34670171673780317278534823799419e-02 7.88721647784638990597017027539550e-02 3.41654361815783291778103603064665e-02
            4.34670171673780317278534823799419e-02 8.77660818054158076151338718773331e-01 3.41654361815783291778103603064665e-02
            7.88721647784638990597017027539550e-02 4.34670171673780317278534823799419e-02 3.41654361815783291778103603064665e-02
            7.88721647784638990597017027539550e-02 8.77660818054158076151338718773331e-01 3.41654361815783291778103603064665e-02
            8.77660818054158076151338718773331e-01 4.34670171673780317278534823799419e-02 3.41654361815783291778103603064665e-02
            8.77660818054158076151338718773331e-01 7.88721647784638990597017027539550e-02 3.41654361815783291778103603064665e-02
            ];
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.5e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.39800182934158340186669988725043e-02
            4.26941414259800422481561099630198e-01 4.26941414259800422481561099630198e-01 2.78009837652266784957522105514727e-02
            4.26941414259800422481561099630198e-01 1.46117171480399155036877800739603e-01 2.78009837652266784957522105514727e-02
            1.46117171480399155036877800739603e-01 4.26941414259800422481561099630198e-01 2.78009837652266784957522105514727e-02
            2.21372286291832892635156326832657e-01 2.21372286291832892635156326832657e-01 2.91392425596000044507594139986395e-02
            2.21372286291832892635156326832657e-01 5.57255427416334159218536115076859e-01 2.91392425596000044507594139986395e-02
            5.57255427416334159218536115076859e-01 2.21372286291832892635156326832657e-01 2.91392425596000044507594139986395e-02
            4.89076946452539351728461269885884e-01 4.89076946452539351728461269885884e-01 1.19972009644473704553790938120983e-02
            4.89076946452539351728461269885884e-01 2.18461070949212965430774602282327e-02 1.19972009644473704553790938120983e-02
            2.18461070949212965430774602282327e-02 4.89076946452539351728461269885884e-01 1.19972009644473704553790938120983e-02
            2.15096811088431837111212274749050e-02 2.15096811088431837111212274749050e-02 3.02616855176958713877222173493919e-03
            2.15096811088431837111212274749050e-02 9.56980637782313681150014872400789e-01 3.02616855176958713877222173493919e-03
            9.56980637782313681150014872400789e-01 2.15096811088431837111212274749050e-02 3.02616855176958713877222173493919e-03
            6.80122435542066527958127153397072e-02 3.08441760892117777803633771327441e-01 1.73206380704241935664100537906052e-02
            6.80122435542066527958127153397072e-02 6.23545995553675513889402282075025e-01 1.73206380704241935664100537906052e-02
            3.08441760892117777803633771327441e-01 6.80122435542066527958127153397072e-02 1.73206380704241935664100537906052e-02
            3.08441760892117777803633771327441e-01 6.23545995553675513889402282075025e-01 1.73206380704241935664100537906052e-02
            6.23545995553675513889402282075025e-01 6.80122435542066527958127153397072e-02 1.73206380704241935664100537906052e-02
            6.23545995553675513889402282075025e-01 3.08441760892117777803633771327441e-01 1.73206380704241935664100537906052e-02
            8.78954830321973246132216672776849e-02 1.63597401067850478639797984214965e-01 1.20895199057969148642710521812660e-02
            8.78954830321973246132216672776849e-02 7.48507115899952224502555964136263e-01 1.20895199057969148642710521812660e-02
            1.63597401067850478639797984214965e-01 8.78954830321973246132216672776849e-02 1.20895199057969148642710521812660e-02
            1.63597401067850478639797984214965e-01 7.48507115899952224502555964136263e-01 1.20895199057969148642710521812660e-02
            7.48507115899952224502555964136263e-01 8.78954830321973246132216672776849e-02 1.20895199057969148642710521812660e-02
            7.48507115899952224502555964136263e-01 1.63597401067850478639797984214965e-01 1.20895199057969148642710521812660e-02
            5.12638910238236850114290632518532e-03 2.72515817773429647186134161529480e-01 4.79534050177163329031770899746334e-03
            5.12638910238236850114290632518532e-03 7.22357793124188019007192451681476e-01 4.79534050177163329031770899746334e-03
            2.72515817773429647186134161529480e-01 5.12638910238236850114290632518532e-03 4.79534050177163329031770899746334e-03
            2.72515817773429647186134161529480e-01 7.22357793124188019007192451681476e-01 4.79534050177163329031770899746334e-03
            7.22357793124188019007192451681476e-01 5.12638910238236850114290632518532e-03 4.79534050177163329031770899746334e-03
            7.22357793124188019007192451681476e-01 2.72515817773429647186134161529480e-01 4.79534050177163329031770899746334e-03
            2.43701869010938300397217659565285e-02 1.10922042803463405391539708944038e-01 7.48270055258283724175516482546300e-03
            2.43701869010938300397217659565285e-02 8.64707770295442768038185477053048e-01 7.48270055258283724175516482546300e-03
            1.10922042803463405391539708944038e-01 2.43701869010938300397217659565285e-02 7.48270055258283724175516482546300e-03
            1.10922042803463405391539708944038e-01 8.64707770295442768038185477053048e-01 7.48270055258283724175516482546300e-03
            8.64707770295442768038185477053048e-01 2.43701869010938300397217659565285e-02 7.48270055258283724175516482546300e-03
            8.64707770295442768038185477053048e-01 1.10922042803463405391539708944038e-01 7.48270055258283724175516482546300e-03
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    11   28 1.60e-14    3    0
    12   33 1.17e-15    3    0
    13   37 7.49e-16    0    0
    ];




