
function [xyw_bar,pointset_stats]=set_papanicolopulos_C_III_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  S-A. Papanicolopulos,
%  "Computation of moderate-degree fully symmetric cubature rules on the
%    triangle using symmetric polynomials and algebraic solving."
%  Computer and Mathematics with Applications, 69 (2015), pp. 650-666.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  11 |  30 |   0 |   0 | 4.58e-16 |PI|
% |  13 |  37 |   1 |   0 | 7.08e-16 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   30
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.6e-16
        
        xyw_bar=[
            2.76470649143987168283587152473046e-01 2.76470649143987168283587152473046e-01 4.47058701712025663432825695053907e-01 5.62316591746811131335981315260142e-02
            2.76470649143987168283587152473046e-01 4.47058701712025663432825695053907e-01 2.76470649143987168283587152473046e-01 5.62316591746811131335981315260142e-02
            4.47058701712025663432825695053907e-01 2.76470649143987168283587152473046e-01 2.76470649143987168283587152473046e-01 5.62316591746811131335981315260142e-02
            1.41982249790406911404971879164805e-01 1.41982249790406911404971879164805e-01 7.16035500419186177190056241670391e-01 4.77614055330858738868116120102059e-02
            1.41982249790406911404971879164805e-01 7.16035500419186177190056241670391e-01 1.41982249790406911404971879164805e-01 4.77614055330858738868116120102059e-02
            7.16035500419186177190056241670391e-01 1.41982249790406911404971879164805e-01 1.41982249790406911404971879164805e-01 4.77614055330858738868116120102059e-02
            1.23023037225988590703806835335854e-01 3.32241271814157690389635035899119e-01 5.44735690959853746662133744393941e-01 5.47342561651127379462877797777764e-02
            1.23023037225988590703806835335854e-01 5.44735690959853746662133744393941e-01 3.32241271814157690389635035899119e-01 5.47342561651127379462877797777764e-02
            3.32241271814157690389635035899119e-01 1.23023037225988590703806835335854e-01 5.44735690959853746662133744393941e-01 5.47342561651127379462877797777764e-02
            3.32241271814157690389635035899119e-01 5.44735690959853746662133744393941e-01 1.23023037225988590703806835335854e-01 5.47342561651127379462877797777764e-02
            5.44735690959853746662133744393941e-01 1.23023037225988590703806835335854e-01 3.32241271814157690389635035899119e-01 5.47342561651127379462877797777764e-02
            5.44735690959853746662133744393941e-01 3.32241271814157690389635035899119e-01 1.23023037225988590703806835335854e-01 5.47342561651127379462877797777764e-02
            2.44039971907914522708527016447988e-02 3.72697460791578227823350744074560e-01 6.02898542017630267864092274976429e-01 2.80140589180386985479476180671554e-02
            2.44039971907914522708527016447988e-02 6.02898542017630267864092274976429e-01 3.72697460791578227823350744074560e-01 2.80140589180386985479476180671554e-02
            3.72697460791578227823350744074560e-01 2.44039971907914522708527016447988e-02 6.02898542017630267864092274976429e-01 2.80140589180386985479476180671554e-02
            3.72697460791578227823350744074560e-01 6.02898542017630267864092274976429e-01 2.44039971907914522708527016447988e-02 2.80140589180386985479476180671554e-02
            6.02898542017630267864092274976429e-01 2.44039971907914522708527016447988e-02 3.72697460791578227823350744074560e-01 2.80140589180386985479476180671554e-02
            6.02898542017630267864092274976429e-01 3.72697460791578227823350744074560e-01 2.44039971907914522708527016447988e-02 2.80140589180386985479476180671554e-02
            2.78538648084660986348204403384443e-02 1.67115163279521417027950747069553e-01 8.05030971912012560665061755571514e-01 2.47987378181990895942288233300133e-02
            2.78538648084660986348204403384443e-02 8.05030971912012560665061755571514e-01 1.67115163279521417027950747069553e-01 2.47987378181990895942288233300133e-02
            1.67115163279521417027950747069553e-01 2.78538648084660986348204403384443e-02 8.05030971912012560665061755571514e-01 2.47987378181990895942288233300133e-02
            1.67115163279521417027950747069553e-01 8.05030971912012560665061755571514e-01 2.78538648084660986348204403384443e-02 2.47987378181990895942288233300133e-02
            8.05030971912012560665061755571514e-01 2.78538648084660986348204403384443e-02 1.67115163279521417027950747069553e-01 2.47987378181990895942288233300133e-02
            8.05030971912012560665061755571514e-01 1.67115163279521417027950747069553e-01 2.78538648084660986348204403384443e-02 2.47987378181990895942288233300133e-02
            2.71509417095036932610074842386894e-02 3.93450946960296893406550111649267e-02 9.33503963594466634745572264364455e-01 7.12308141143264909184162902988646e-03
            2.71509417095036932610074842386894e-02 9.33503963594466634745572264364455e-01 3.93450946960296893406550111649267e-02 7.12308141143264909184162902988646e-03
            3.93450946960296893406550111649267e-02 2.71509417095036932610074842386894e-02 9.33503963594466634745572264364455e-01 7.12308141143264909184162902988646e-03
            3.93450946960296893406550111649267e-02 9.33503963594466634745572264364455e-01 2.71509417095036932610074842386894e-02 7.12308141143264909184162902988646e-03
            9.33503963594466634745572264364455e-01 2.71509417095036932610074842386894e-02 3.93450946960296893406550111649267e-02 7.12308141143264909184162902988646e-03
            9.33503963594466634745572264364455e-01 3.93450946960296893406550111649267e-02 2.71509417095036932610074842386894e-02 7.12308141143264909184162902988646e-03
            ];
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 7.1e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -1.05636073845640138246793071630236e-01
            2.87859326513836777383659182305564e-01 2.87859326513836777383659182305564e-01 4.24281346972326445232681635388872e-01 9.69003472780408381392902583684190e-02
            2.87859326513836777383659182305564e-01 4.24281346972326445232681635388872e-01 2.87859326513836777383659182305564e-01 9.69003472780408381392902583684190e-02
            4.24281346972326445232681635388872e-01 2.87859326513836777383659182305564e-01 2.87859326513836777383659182305564e-01 9.69003472780408381392902583684190e-02
            4.43401008512209926504255008694599e-01 4.43401008512209926504255008694599e-01 1.13197982975580146991489982610801e-01 5.01821663522732733242470715140371e-02
            4.43401008512209926504255008694599e-01 1.13197982975580146991489982610801e-01 4.43401008512209926504255008694599e-01 5.01821663522732733242470715140371e-02
            1.13197982975580146991489982610801e-01 4.43401008512209926504255008694599e-01 4.43401008512209926504255008694599e-01 5.01821663522732733242470715140371e-02
            4.89260803767147589571351318227244e-01 4.89260803767147589571351318227244e-01 2.14783924657048208572973635455128e-02 2.10285597369451252025562837388861e-02
            4.89260803767147589571351318227244e-01 2.14783924657048208572973635455128e-02 4.89260803767147589571351318227244e-01 2.10285597369451252025562837388861e-02
            2.14783924657048208572973635455128e-02 4.89260803767147589571351318227244e-01 4.89260803767147589571351318227244e-01 2.10285597369451252025562837388861e-02
            9.99540132004466397308561909085256e-02 9.99540132004466397308561909085256e-02 8.00091973599106776049438849440776e-01 2.67259906734938525174616330559729e-02
            9.99540132004466397308561909085256e-02 8.00091973599106776049438849440776e-01 9.99540132004466397308561909085256e-02 2.67259906734938525174616330559729e-02
            8.00091973599106776049438849440776e-01 9.99540132004466397308561909085256e-02 9.99540132004466397308561909085256e-02 2.67259906734938525174616330559729e-02
            1.19264420939040244329376605492143e-01 2.49505468944335256908928499797184e-01 6.31230110116624554272846125968499e-01 4.60789126137384069670233088800160e-02
            1.19264420939040244329376605492143e-01 6.31230110116624554272846125968499e-01 2.49505468944335256908928499797184e-01 4.60789126137384069670233088800160e-02
            2.49505468944335256908928499797184e-01 1.19264420939040244329376605492143e-01 6.31230110116624554272846125968499e-01 4.60789126137384069670233088800160e-02
            2.49505468944335256908928499797184e-01 6.31230110116624554272846125968499e-01 1.19264420939040244329376605492143e-01 4.60789126137384069670233088800160e-02
            6.31230110116624554272846125968499e-01 1.19264420939040244329376605492143e-01 2.49505468944335256908928499797184e-01 4.60789126137384069670233088800160e-02
            6.31230110116624554272846125968499e-01 2.49505468944335256908928499797184e-01 1.19264420939040244329376605492143e-01 4.60789126137384069670233088800160e-02
            2.36151596685485846982555102613333e-02 3.01734693237281692557161250078934e-01 6.74650147094169705397348479891662e-01 2.13529036278768714895992530955482e-02
            2.36151596685485846982555102613333e-02 6.74650147094169705397348479891662e-01 3.01734693237281692557161250078934e-01 2.13529036278768714895992530955482e-02
            3.01734693237281692557161250078934e-01 2.36151596685485846982555102613333e-02 6.74650147094169705397348479891662e-01 2.13529036278768714895992530955482e-02
            3.01734693237281692557161250078934e-01 6.74650147094169705397348479891662e-01 2.36151596685485846982555102613333e-02 2.13529036278768714895992530955482e-02
            6.74650147094169705397348479891662e-01 2.36151596685485846982555102613333e-02 3.01734693237281692557161250078934e-01 2.13529036278768714895992530955482e-02
            6.74650147094169705397348479891662e-01 3.01734693237281692557161250078934e-01 2.36151596685485846982555102613333e-02 2.13529036278768714895992530955482e-02
            2.08977446417789522459251827513071e-02 1.43025766381978031160926434495195e-01 8.36076488976242981898678863217356e-01 1.45039424863792551501084915344109e-02
            2.08977446417789522459251827513071e-02 8.36076488976242981898678863217356e-01 1.43025766381978031160926434495195e-01 1.45039424863792551501084915344109e-02
            1.43025766381978031160926434495195e-01 2.08977446417789522459251827513071e-02 8.36076488976242981898678863217356e-01 1.45039424863792551501084915344109e-02
            1.43025766381978031160926434495195e-01 8.36076488976242981898678863217356e-01 2.08977446417789522459251827513071e-02 1.45039424863792551501084915344109e-02
            8.36076488976242981898678863217356e-01 2.08977446417789522459251827513071e-02 1.43025766381978031160926434495195e-01 1.45039424863792551501084915344109e-02
            8.36076488976242981898678863217356e-01 1.43025766381978031160926434495195e-01 2.08977446417789522459251827513071e-02 1.45039424863792551501084915344109e-02
            1.49739108721680235641882106278899e-02 3.98533069007699983221648665221437e-02 9.45172782227061913928878311708104e-01 4.91838822590227788683625576027225e-03
            1.49739108721680235641882106278899e-02 9.45172782227061913928878311708104e-01 3.98533069007699983221648665221437e-02 4.91838822590227788683625576027225e-03
            3.98533069007699983221648665221437e-02 1.49739108721680235641882106278899e-02 9.45172782227061913928878311708104e-01 4.91838822590227788683625576027225e-03
            3.98533069007699983221648665221437e-02 9.45172782227061913928878311708104e-01 1.49739108721680235641882106278899e-02 4.91838822590227788683625576027225e-03
            9.45172782227061913928878311708104e-01 1.49739108721680235641882106278899e-02 3.98533069007699983221648665221437e-02 4.91838822590227788683625576027225e-03
            9.45172782227061913928878311708104e-01 3.98533069007699983221648665221437e-02 1.49739108721680235641882106278899e-02 4.91838822590227788683625576027225e-03
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    11   30 4.58e-16    0    0
    13   37 7.08e-16    1    0
    ];





