
function [S1,S2,S3,pointset_stats]=set_papanicolopulos_C_IV_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  S-A. Papanicolopulos,
%  "Computation of moderate-degree fully symmetric cubature rules on the
%    triangle using symmetric polynomials and algebraic solving."
%  Computer and Mathematics with Applications, 69 (2015), pp. 650-666.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  11 |  30 |   0 |   0 | 7.25e-16 |PI|
% |  13 |  37 |   1 |   0 | 1.94e-15 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   30
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.3e-16
        
        S1=[
            5.81737103221630219573867748295015e-02 1.25399563536620878290150926659408e-01 2.65976201903301567863735499486211e-01
            1.69758483229834021555060274977222e-02 1.24099701536985324024087162797514e-02 2.85364185386964619439709167636465e-01
            2.75914641564495924375144397799886e-02 5.27920579882177123942632590569701e-02 1.37235367478170861010866588003410e-01
            6.22890485878559597293646632465425e-03 5.10034456458280643226244066568142e-03 5.68171557885724445857711373264465e-02
            ];
        
        S2=[
            7.21780423972092632922681332274806e-02 3.93550796299479699325019055322628e-01
            4.32154356153608421031719899474410e-02 4.79790658088974475425914079096401e-01
            ];
        
        S3=[];
        
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-15
        
        S1=[
            4.68687175571588093836439270489791e-02 1.28074854562105128197302406078961e-01 2.55906050471402635171358497245819e-01
            2.32145822719833951064405397346491e-02 2.46657588834265258104228024649274e-02 2.93727563742226804865964595592231e-01
            1.86588654149388126490816119940064e-02 7.66050470865419635968507350298751e-02 1.30375294536257818611701964073291e-01
            1.09999353690334901456626681692796e-02 1.51715577063571485649795533845463e-02 1.29537263326082147107953801423719e-01
            ];
        
        S2=[
            3.85184324819689616337115012356662e-01 3.13414251245748620711140119965421e-01
            4.70707437513937232420602185811731e-02 4.48163430652607663873254750797059e-01
            1.94715986002323634962429821371188e-02 4.90619528151925610170991376435268e-01
            8.59855929509804363386482606301797e-03 2.58537863776017451389321877286420e-02
            ];
        
        S3=[
            -9.79428283077928174549242612556554e-01
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    11   30 7.25e-16    0    0
    13   37 1.94e-15    1    0
    ];




