
function [xyw_bar,pointset_stats]=set_papanicolopulos_C_V_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  S-A. Papanicolopulos,
%  "Computation of moderate-degree fully symmetric cubature rules on the
%    triangle using symmetric polynomials and algebraic solving."
%  Computer and Mathematics with Applications, 69 (2015), pp. 650-666.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  11 |  30 |   0 |   0 | 4.16e-16 |PI|
% |  13 |  37 |   1 |   0 | 1.44e-15 |NI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   30
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.2e-16
        
        xyw_bar=[
            2.74772817912116995575644295968232e-01 2.74772817912116995575644295968232e-01 4.50454364175766008848711408063537e-01 5.83256621274495928863856875068450e-02
            2.74772817912116995575644295968232e-01 4.50454364175766008848711408063537e-01 2.74772817912116995575644295968232e-01 5.83256621274495928863856875068450e-02
            4.50454364175766008848711408063537e-01 2.74772817912116995575644295968232e-01 2.74772817912116995575644295968232e-01 5.83256621274495928863856875068450e-02
            3.28418726441058461684718849937781e-02 3.28418726441058461684718849937781e-02 9.34316254711788252151904998754617e-01 1.38759956314945427646723175030274e-02
            3.28418726441058461684718849937781e-02 9.34316254711788252151904998754617e-01 3.28418726441058461684718849937781e-02 1.38759956314945427646723175030274e-02
            9.34316254711788252151904998754617e-01 3.28418726441058461684718849937781e-02 3.28418726441058461684718849937781e-02 1.38759956314945427646723175030274e-02
            1.21424993858757324094455043450580e-01 3.34795359249270896295769261996611e-01 5.43779646891971779609775694552809e-01 5.33635423933404642871103362722351e-02
            1.21424993858757324094455043450580e-01 5.43779646891971779609775694552809e-01 3.34795359249270896295769261996611e-01 5.33635423933404642871103362722351e-02
            3.34795359249270896295769261996611e-01 1.21424993858757324094455043450580e-01 5.43779646891971779609775694552809e-01 5.33635423933404642871103362722351e-02
            3.34795359249270896295769261996611e-01 5.43779646891971779609775694552809e-01 1.21424993858757324094455043450580e-01 5.33635423933404642871103362722351e-02
            5.43779646891971779609775694552809e-01 1.21424993858757324094455043450580e-01 3.34795359249270896295769261996611e-01 5.33635423933404642871103362722351e-02
            5.43779646891971779609775694552809e-01 3.34795359249270896295769261996611e-01 1.21424993858757324094455043450580e-01 5.33635423933404642871103362722351e-02
            2.40004676258309089520448509347261e-02 3.71859995090367934089670143293915e-01 6.04139537283801208999989285075571e-01 2.78123209045511091130897796119825e-02
            2.40004676258309089520448509347261e-02 6.04139537283801208999989285075571e-01 3.71859995090367934089670143293915e-01 2.78123209045511091130897796119825e-02
            3.71859995090367934089670143293915e-01 2.40004676258309089520448509347261e-02 6.04139537283801208999989285075571e-01 2.78123209045511091130897796119825e-02
            3.71859995090367934089670143293915e-01 6.04139537283801208999989285075571e-01 2.40004676258309089520448509347261e-02 2.78123209045511091130897796119825e-02
            6.04139537283801208999989285075571e-01 2.40004676258309089520448509347261e-02 3.71859995090367934089670143293915e-01 2.78123209045511091130897796119825e-02
            6.04139537283801208999989285075571e-01 3.71859995090367934089670143293915e-01 2.40004676258309089520448509347261e-02 2.78123209045511091130897796119825e-02
            1.27000688875782696829475071353954e-01 1.58040009552358612365807744026824e-01 7.14959301571858718560292800248135e-01 2.52534126299313876895524799692794e-02
            1.27000688875782696829475071353954e-01 7.14959301571858718560292800248135e-01 1.58040009552358612365807744026824e-01 2.52534126299313876895524799692794e-02
            1.58040009552358612365807744026824e-01 1.27000688875782696829475071353954e-01 7.14959301571858718560292800248135e-01 2.52534126299313876895524799692794e-02
            1.58040009552358612365807744026824e-01 7.14959301571858718560292800248135e-01 1.27000688875782696829475071353954e-01 2.52534126299313876895524799692794e-02
            7.14959301571858718560292800248135e-01 1.27000688875782696829475071353954e-01 1.58040009552358612365807744026824e-01 2.52534126299313876895524799692794e-02
            7.14959301571858718560292800248135e-01 1.58040009552358612365807744026824e-01 1.27000688875782696829475071353954e-01 2.52534126299313876895524799692794e-02
            2.70397125648199725123088654754611e-02 1.64922343261641457523580811539432e-01 8.08037944173538580372451178845949e-01 2.41365618593715643147579186233997e-02
            2.70397125648199725123088654754611e-02 8.08037944173538580372451178845949e-01 1.64922343261641457523580811539432e-01 2.41365618593715643147579186233997e-02
            1.64922343261641457523580811539432e-01 2.70397125648199725123088654754611e-02 8.08037944173538580372451178845949e-01 2.41365618593715643147579186233997e-02
            1.64922343261641457523580811539432e-01 8.08037944173538580372451178845949e-01 2.70397125648199725123088654754611e-02 2.41365618593715643147579186233997e-02
            8.08037944173538580372451178845949e-01 2.70397125648199725123088654754611e-02 1.64922343261641457523580811539432e-01 2.41365618593715643147579186233997e-02
            8.08037944173538580372451178845949e-01 1.64922343261641457523580811539432e-01 2.70397125648199725123088654754611e-02 2.41365618593715643147579186233997e-02
            ];
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    1
        % OUT PTS. :    0
        % M.E.INF. : 1.4e-15
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 -6.96193891817351695472382289153757e-01
            3.09879507790336128358887890499318e-01 3.09879507790336128358887890499318e-01 3.80240984419327743282224219001364e-01 2.91646504849546683857397511019371e-01
            3.09879507790336128358887890499318e-01 3.80240984419327743282224219001364e-01 3.09879507790336128358887890499318e-01 2.91646504849546683857397511019371e-01
            3.80240984419327743282224219001364e-01 3.09879507790336128358887890499318e-01 3.09879507790336128358887890499318e-01 2.91646504849546683857397511019371e-01
            4.47614454276368201046665262765600e-01 4.47614454276368201046665262765600e-01 1.04771091447263597906669474468799e-01 4.70228459896395167838534234761028e-02
            4.47614454276368201046665262765600e-01 1.04771091447263597906669474468799e-01 4.47614454276368201046665262765600e-01 4.70228459896395167838534234761028e-02
            1.04771091447263597906669474468799e-01 4.47614454276368201046665262765600e-01 4.47614454276368201046665262765600e-01 4.70228459896395167838534234761028e-02
            1.01031310404861976448565030750615e-01 1.01031310404861976448565030750615e-01 7.97937379190276074858445554127684e-01 2.94370772107612893586647828669811e-02
            1.01031310404861976448565030750615e-01 7.97937379190276074858445554127684e-01 1.01031310404861976448565030750615e-01 2.94370772107612893586647828669811e-02
            7.97937379190276074858445554127684e-01 1.01031310404861976448565030750615e-01 1.01031310404861976448565030750615e-01 2.94370772107612893586647828669811e-02
            2.36586513317136766521020518894147e-02 2.36586513317136766521020518894147e-02 9.52682697336572625879114184499485e-01 7.06047845203092855337345667976479e-03
            2.36586513317136766521020518894147e-02 9.52682697336572625879114184499485e-01 2.36586513317136766521020518894147e-02 7.06047845203092855337345667976479e-03
            9.52682697336572625879114184499485e-01 2.36586513317136766521020518894147e-02 2.36586513317136766521020518894147e-02 7.06047845203092855337345667976479e-03
            1.25541274501919292161389307693753e-01 2.55267294562517677025681450686534e-01 6.19191430935563058568504857248627e-01 4.74821392721029716943448306665232e-02
            1.25541274501919292161389307693753e-01 6.19191430935563058568504857248627e-01 2.55267294562517677025681450686534e-01 4.74821392721029716943448306665232e-02
            2.55267294562517677025681450686534e-01 1.25541274501919292161389307693753e-01 6.19191430935563058568504857248627e-01 4.74821392721029716943448306665232e-02
            2.55267294562517677025681450686534e-01 6.19191430935563058568504857248627e-01 1.25541274501919292161389307693753e-01 4.74821392721029716943448306665232e-02
            6.19191430935563058568504857248627e-01 1.25541274501919292161389307693753e-01 2.55267294562517677025681450686534e-01 4.74821392721029716943448306665232e-02
            6.19191430935563058568504857248627e-01 2.55267294562517677025681450686534e-01 1.25541274501919292161389307693753e-01 4.74821392721029716943448306665232e-02
            2.03504435417887451220675387730807e-02 3.99087880301877473421257036534371e-01 5.80561676156333805742804088367848e-01 1.83747988199562534150643955399573e-02
            2.03504435417887451220675387730807e-02 5.80561676156333805742804088367848e-01 3.99087880301877473421257036534371e-01 1.83747988199562534150643955399573e-02
            3.99087880301877473421257036534371e-01 2.03504435417887451220675387730807e-02 5.80561676156333805742804088367848e-01 1.83747988199562534150643955399573e-02
            3.99087880301877473421257036534371e-01 5.80561676156333805742804088367848e-01 2.03504435417887451220675387730807e-02 1.83747988199562534150643955399573e-02
            5.80561676156333805742804088367848e-01 2.03504435417887451220675387730807e-02 3.99087880301877473421257036534371e-01 1.83747988199562534150643955399573e-02
            5.80561676156333805742804088367848e-01 3.99087880301877473421257036534371e-01 2.03504435417887451220675387730807e-02 1.83747988199562534150643955399573e-02
            2.67964826640274406122088635129330e-02 2.40789896143364989811175291833933e-01 7.32413621192607555698828036838677e-01 1.90729069366082880365720342297209e-02
            2.67964826640274406122088635129330e-02 7.32413621192607555698828036838677e-01 2.40789896143364989811175291833933e-01 1.90729069366082880365720342297209e-02
            2.40789896143364989811175291833933e-01 2.67964826640274406122088635129330e-02 7.32413621192607555698828036838677e-01 1.90729069366082880365720342297209e-02
            2.40789896143364989811175291833933e-01 7.32413621192607555698828036838677e-01 2.67964826640274406122088635129330e-02 1.90729069366082880365720342297209e-02
            7.32413621192607555698828036838677e-01 2.67964826640274406122088635129330e-02 2.40789896143364989811175291833933e-01 1.90729069366082880365720342297209e-02
            7.32413621192607555698828036838677e-01 2.40789896143364989811175291833933e-01 2.67964826640274406122088635129330e-02 1.90729069366082880365720342297209e-02
            1.64352959354110601808418579139470e-02 1.13983680191240513424055791347200e-01 8.69581023873348457620124918321380e-01 1.01856836899018813463735355639983e-02
            1.64352959354110601808418579139470e-02 8.69581023873348457620124918321380e-01 1.13983680191240513424055791347200e-01 1.01856836899018813463735355639983e-02
            1.13983680191240513424055791347200e-01 1.64352959354110601808418579139470e-02 8.69581023873348457620124918321380e-01 1.01856836899018813463735355639983e-02
            1.13983680191240513424055791347200e-01 8.69581023873348457620124918321380e-01 1.64352959354110601808418579139470e-02 1.01856836899018813463735355639983e-02
            8.69581023873348457620124918321380e-01 1.64352959354110601808418579139470e-02 1.13983680191240513424055791347200e-01 1.01856836899018813463735355639983e-02
            8.69581023873348457620124918321380e-01 1.13983680191240513424055791347200e-01 1.64352959354110601808418579139470e-02 1.01856836899018813463735355639983e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    11   30 4.16e-16    0    0
    13   37 1.44e-15    1    0
    ];





