
function [V1,V2,V3]=set_papanicolopulos_C_pre(deg)

% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
% --------------------------------------------------------------------
% REMARK:
% In this set of rules, there are several sets at degree 11 and 13.
% To choose a set in particular, set the variable "subcase" below.
% Default settings are for a rule of type PI with fewer nodes and better
% errors.
% --------------------------------------------------------------------
% SOURCE:
% S-A. Papanicolopulos
% "Computation of moderate-degree fully symmetric cubature rules on the
%   triangle using symmetric polynomials and algebraic solving."
% Computer and Mathematics with Applications, 69 (2015), pp. 650-666.
% --------------------------------------------------------------------

%----------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%----------------------------------------
% |   7 |  15 |   0 |   0 | 3.00e-16 |PI|
% |  10 |  25 |   0 |   0 | 3.61e-16 |PI|
% |  11 |  28 |   1 |   0 | 2.91e-16 |NI| (subcase=1)
% |  11 |  28 |   3 |   0 | 1.60e-14 |NI| (subcase=2)
% |  11 |  30 |   0 |   0 | 4.30e-16 |PI| (subcase=3)
% |  11 |  30 |   0 |   0 | 3.05e-16 |PI| (subcase=4)
% |  11 |  30 |   0 |   0 | 2.98e-16 |PI| (subcase=5, default)
% |  11 |  30 |   0 |   0 | 4.16e-16 |PI| (subcase=6)
% |  12 |  33 |   0 |   0 | 4.37e-16 |PI|
% |  13 |  37 |   0 |   0 | 3.89e-16 |PI| (subcase=1, default)
% |  13 |  37 |   0 |   0 | 6.94e-16 |PI| (subcase=2)
% |  13 |  37 |   1 |   0 | 6.73e-16 |NI| (subcase=3)
% |  13 |  37 |   1 |   0 | 1.83e-15 |NI| (subcase=4)
% |  13 |  37 |   1 |   0 | 1.26e-15 |NI| (subcase=5)
%---------------------------------------


%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

xyw=[];

subcase=5;

switch deg
    case 7
        switch subcase
            case 1
                xyw=[3 1.2539360744930307e-01 5.1348172032878493e-01 2.4325913983560754e-01 2.4325913983560754e-01
                    6 7.6306338340541706e-02 5.0714384307207043e-02 3.1864418984753705e-01 6.3064142584525590e-01
                    6 2.7663524601473427e-02 4.5720829846320324e-02 8.6636631341749002e-02 8.6764253881193067e-01];
        end
    case 10
        % d = 10, nK = 25, type [1; 2; 3], quality PI, e = 1
        switch subcase
            case 1
                xyw=[1 8.3219736986450142e-02 3.3333333333333333e-01 3.3333333333333333e-01 3.3333333333333333e-01
                    3 5.2651949468244594e-02 6.7417376425181049e-01 1.6291311787409476e-01 1.6291311787409476e-01
                    3 1.0951288340268411e-02 9.4299299942322433e-01 2.8503500288387836e-02 2.8503500288387836e-02
                    6 5.6277279710811180e-02 1.4681150539393041e-01 3.3669587527823165e-01 5.1649261932783794e-01
                    6 3.5394947791538391e-02 2.9307604504579472e-02 3.6336261699457053e-01 6.0732977850085000e-01
                    6 2.9322864095652236e-02 3.3685698680610287e-02 1.5330305516956137e-01 8.1301124614982834e-01];
        end
    case 11
        switch subcase
            case 1
                % d = 11, nK = 28, type [1; 3; 3], quality NI, e = 2,  = 1:125
                xyw=[1 -6.2401629433482428e-02 3.3333333333333333e-01 3.3333333333333333e-01 3.3333333333333333e-01
                    3 8.1727170838649564e-02 4.3271289449998075e-01 2.8364355275000962e-01 2.8364355275000962e-01
                    3 4.8964652505867335e-02 7.1120974700789952e-01 1.4439512649605024e-01 1.4439512649605024e-01
                    3 1.3801353886270255e-02 9.3453870606708818e-01 3.2730646966455908e-02 3.2730646966455908e-02
                    6 5.3402351795938245e-02 1.1639641340049335e-01 3.3535007852506066e-01 5.4825350807444599e-01
                    6 2.6325058735312046e-02 2.2611513300388206e-02 3.7249492189107103e-01 6.0489356480854077e-01
                    6 2.5092939092269870e-02 2.7990225682080982e-02 1.6490131047191468e-01 8.0710846384600434e-01];
                
            case 2
                %d = 11, nK = 28, type [1; 3; 3], quality NI, e = 16,  = 24:81
                xyw=[1 1.9188748901448341e-01 3.3333333333333333e-01 3.3333333333333333e-01 3.3333333333333333e-01
                    3 4.4946736418864346e-02 3.6186335127135712e-02 4.8190683243643214e-01 4.8190683243643214e-01
                    3 4.1100128875197643e-02 8.1104704303693675e-01 9.4476478481531623e-02 9.4476478481531623e-02
                    3 -3.9689908345461279e+00 5.1674377997694020e-01 2.4162811001152990e-01 2.4162811001152990e-01
                    6 2.0349375070302612e+00 2.2731189719293939e-01 2.5397442939188326e-01 5.1871367341517734e-01
                    6 3.4015193574745321e-02 3.0655038923840410e-02 2.5125205566042453e-01 7.1809290541573506e-01
                    6 7.2047025186125795e-03 1.5009373287576387e-03 6.5611553303429522e-02 9.3288750936781284e-01];
                
            case 3
                %d = 11, nK = 30, type [0; 2; 4], quality PI, e = 2:5
                xyw=[3 5.6231659174681110e-02 4.4705870171202569e-01 2.7647064914398715e-01 2.7647064914398715e-01
                    3 4.7761405533085872e-02 7.1603550041918619e-01 1.4198224979040690e-01 1.4198224979040690e-01
                    6 5.4734256165112738e-02 1.2302303722598859e-01 3.3224127181415769e-01 5.4473569095985372e-01
                    6 2.8014058918038700e-02 2.4403997190791452e-02 3.7269746079157825e-01 6.0289854201763030e-01
                    6 2.4798737818199088e-02 2.7853864808466097e-02 1.6711516327952143e-01 8.0503097191201248e-01
                    6 7.1230814114326493e-03 2.7150941709503694e-02 3.9345094696029689e-02 9.3350396359446662e-01];
                
            case 4
                % d = 11, nK = 30, type [0; 2; 4], quality PI, e = 2
                xyw=[3 7.2178042397209270e-02 2.1289840740104060e-01 3.9355079629947970e-01 3.9355079629947970e-01
                    3 4.3215435615360841e-02 4.0418683822051027e-02 4.7979065808897449e-01 4.7979065808897449e-01
                    6 5.8173710322163019e-02 1.2539956353662088e-01 2.6597620190330159e-01 6.0862423456007753e-01
                    6 1.6975848322983403e-02 1.2409970153698532e-02 2.8536418538696462e-01 7.0222584445933685e-01
                    6 2.7591464156449593e-02 5.2792057988217709e-02 1.3723536747817085e-01 8.0997257453361144e-01
                    6 6.2289048587855958e-03 5.1003445645828061e-03 5.6817155788572447e-02 9.3808249964684475e-01];
                
            case 5
                % d = 11, nK = 30, type [0; 2; 4], quality PI, e = 2
                xyw=[3 5.8325662127449619e-02 4.5045436417576603e-01 2.7477281791211699e-01 2.7477281791211699e-01
                    3 1.3875995631494550e-02 9.3431625471178831e-01 3.2841872644105845e-02 3.2841872644105845e-02
                    6 5.3363542393340484e-02 1.2142499385875732e-01 3.3479535924927089e-01 5.4377964689197179e-01
                    6 2.7812320904551124e-02 2.4000467625830910e-02 3.7185999509036796e-01 6.0413953728380113e-01
                    6 2.5253412629931399e-02 1.2700068887578271e-01 1.5804000955235862e-01 7.1495930157185867e-01
                    6 2.4136561859371575e-02 2.7039712564819973e-02 1.6492234326164145e-01 8.0803794417353858e-01];
                
            case 6
                % d = 11, nK = 30, type [0; 2; 4], quality PI, e = 2:5
                xyw=[3 4.8883135862392292e-02 7.1187870201519159e-01 1.4406064899240421e-01 1.4406064899240421e-01
                    3 1.3814368459654939e-02 9.3450946869957339e-01 3.2745265650213304e-02 3.2745265650213304e-02
                    6 3.5111950829892619e-02 2.4046986824731959e-01 3.0207587109553998e-01 4.5745426065714043e-01
                    6 5.0153096874909698e-02 1.1000518620988445e-01 3.3722210801729928e-01 5.5277270577281628e-01
                    6 2.5039771321642791e-02 2.1520759771076191e-02 3.7311327681727726e-01 6.0536596341164655e-01
                    6 2.5013095479197943e-02 2.7875756416958290e-02 1.6500707013095728e-01 8.0711717345208443e-01];
        end
        
    case 12
        switch subcase
            case 1
                % d = 12, nK = 33, type [0; 5; 3], quality PI, e = 2
                xyw=[3 6.2541213195902760e-02 4.5707498597014783e-01 2.7146250701492608e-01 2.7146250701492608e-01
                    3 4.9918334928060942e-02 1.1977670268281378e-01 4.4011164865859311e-01 4.4011164865859311e-01
                    3 2.4266838081452033e-02 2.3592498108916896e-02 4.8820375094554155e-01 4.8820375094554155e-01
                    3 2.8486052068877545e-02 7.8148434468129142e-01 1.0925782765935429e-01 1.0925782765935429e-01
                    3 7.9316425099736385e-03 9.5070727312732881e-01 2.4646363436335595e-02 2.4646363436335595e-02
                    6 4.3227363659414211e-02 1.1629601967792659e-01 2.5545422863851735e-01 6.2824975168355607e-01
                    6 2.1783585038607558e-02 2.3034156355267139e-02 2.9165567973834096e-01 6.8531016390639190e-01
                    6 1.5083677576511439e-02 2.1382490256170590e-02 1.2727971723358937e-01 8.5133779251024004e-01];
            case 2
                %d = 12, nK = 33, type [0; 5; 3], quality NI, e = 2:5,  = 1:637
                xyw=[3 5.9921579300409806e-02 4.5297113890586446e-01 2.7351443054706777e-01 2.7351443054706777e-01
                    3 2.8078756439547521e-02 2.3689177706651337e-02 4.8815541114667433e-01 4.8815541114667433e-01
                    3 5.2528996017723132e-02 7.3216462065976138e-01 1.3391768967011931e-01 1.3391768967011931e-01
                    3 1.6173556276231663e-03 9.9275211060624856e-01 3.6239446968757181e-03 3.6239446968757181e-03
                    3 -1.0620241943508914e-01 8.7453358939251732e-01 6.2733205303741339e-02 6.2733205303741339e-02
                    6 5.4918108387822948e-02 1.2022413161656717e-01 3.3193466412059610e-01 5.4784120426283674e-01
                    6 2.5445551940579828e-02 2.4056915471787798e-02 2.6336908079040157e-01 7.1257400373781064e-01
                    6 6.8330872363156647e-02 4.3467017167378031e-02 7.8872164778463905e-02 8.7766081805415806e-01];
        end
    case 13
        switch subcase
            case 1
                %d = 13, nK = 37, type [1; 4; 4], quality PI, e = 2
                xyw=[1 6.6665311839643211e-02 3.3333333333333333e-01 3.3333333333333333e-01 3.3333333333333333e-01
                    3 5.6371383179075312e-02 1.4168077491377855e-01 4.2915961254311073e-01 4.2915961254311073e-01
                    3 5.7036879531335907e-02 5.4831985426419597e-01 2.2584007286790202e-01 2.2584007286790202e-01
                    3 2.7047702881060109e-02 2.5142709405267532e-02 4.8742864529736623e-01 4.8742864529736623e-01
                    3 3.2545777101062094e-02 7.5108435587200148e-01 1.2445782206399926e-01 1.2445782206399926e-01
                    6 3.8462103807067631e-02 7.1274471511911043e-02 2.8452076401981823e-01 6.4420476446827072e-01
                    6 9.1384388143710323e-03 4.9353234895430553e-03 2.8621475354434202e-01 7.0884992296611493e-01
                    6 1.7513402050919330e-02 2.6732809794336294e-02 1.2452541585132824e-01 8.4874177435433547e-01
                    6 3.9409653414347608e-03 1.6350780507591448e-02 3.2854248680859809e-02 9.5079497081154874e-01];
            case 2
                % d = 13, nK = 37, type [1; 4; 4], quality PI, e = 3
                xyw=[1 6.7960036586831644e-02 3.3333333333333333e-01 3.3333333333333333e-01 3.3333333333333333e-01
                    3 5.5601967530453329e-02 1.4611717148039919e-01 4.2694141425980041e-01 4.2694141425980041e-01
                    3 5.8278485119199981e-02 5.5725542741633420e-01 2.2137228629183290e-01 2.2137228629183290e-01
                    3 2.3994401928894731e-02 2.1846107094921300e-02 4.8907694645253935e-01 4.8907694645253935e-01
                    3 6.0523371035391718e-03 9.5698063778231363e-01 2.1509681108843184e-02 2.1509681108843184e-02
                    6 3.4641276140848370e-02 6.8012243554206655e-02 3.0844176089211777e-01 6.2354599555367557e-01
                    6 2.4179039811593819e-02 8.7895483032197325e-02 1.6359740106785048e-01 7.4850711589995220e-01
                    6 9.5906810035432627e-03 5.1263891023823686e-03 2.7251581777342967e-01 7.2235779312418797e-01
                    6 1.4965401105165667e-02 2.4370186901093829e-02 1.1092204280346340e-01 8.6470777029544278e-01];
            case 3
                % d = 13, nK = 37, type [1; 4; 4], quality NI, e = 3,  = 1:211
                xyw=[1 -1.0563607384564014e-01 3.3333333333333333e-01 3.3333333333333333e-01 3.3333333333333333e-01
                    3 9.6900347278040834e-02 4.2428134697232641e-01 2.8785932651383680e-01 2.8785932651383680e-01
                    3 5.0182166352273275e-02 1.1319798297558010e-01 4.4340100851220995e-01 4.4340100851220995e-01
                    3 2.1028559736945124e-02 2.1478392465704778e-02 4.8926080376714761e-01 4.8926080376714761e-01
                    3 2.6725990673493854e-02 8.0009197359910671e-01 9.9954013200446643e-02 9.9954013200446643e-02
                    6 4.6078912613738408e-02 1.1926442093904025e-01 2.4950546894433526e-01 6.3123011011662449e-01
                    6 2.1352903627876872e-02 2.3615159668548583e-02 3.0173469323728171e-01 6.7465014709416971e-01
                    6 1.4503942486379255e-02 2.0897744641778951e-02 1.4302576638197802e-01 8.3607648897624303e-01
                    6 4.9183882259022780e-03 1.4973910872168023e-02 3.9853306900769997e-02 9.4517278222706198e-01];
            case 4
                % d = 13, nK = 37, type [1; 4; 4], quality NI, e = 3,  = 2:959
                xyw=[1 -9.7942828307792821e-01 3.3333333333333333e-01 3.3333333333333333e-01 3.3333333333333333e-01
                    3 3.8518432481968960e-01 3.7317149750850276e-01 3.1341425124574862e-01 3.1341425124574862e-01
                    3 4.7070743751393722e-02 1.0367313869478466e-01 4.4816343065260767e-01 4.4816343065260767e-01
                    3 1.9471598600232362e-02 1.8760943696148778e-02 4.9061952815192561e-01 4.9061952815192561e-01
                    3 8.5985592950980431e-03 9.4829242724479651e-01 2.5853786377601744e-02 2.5853786377601744e-02
                    6 4.6868717557158807e-02 1.2807485456210513e-01 2.5590605047140265e-01 6.1601909496649222e-01
                    6 2.3214582271983394e-02 2.4665758883426525e-02 2.9372756374222683e-01 6.8160667737434664e-01
                    6 1.8658865414938813e-02 7.6605047086541962e-02 1.3037529453625783e-01 7.9301965837720021e-01
                    6 1.0999935369033491e-02 1.5171557706357148e-02 1.2953726332608215e-01 8.5529117896756070e-01];
            case 5
                % d = 13, nK = 37, type [1; 4; 4], quality NI, e = 2,  = 2:392
                xyw=[1 -6.9619389181735170e-01 3.3333333333333333e-01 3.3333333333333333e-01 3.3333333333333333e-01
                    3 2.9164650484954670e-01 3.8024098441932774e-01 3.0987950779033613e-01 3.0987950779033613e-01
                    3 4.7022845989639519e-02 1.0477109144726357e-01 4.4761445427636821e-01 4.4761445427636821e-01
                    3 2.9437077210761288e-02 7.9793737919027607e-01 1.0103131040486197e-01 1.0103131040486197e-01
                    3 7.0604784520309286e-03 9.5268269733657265e-01 2.3658651331713676e-02 2.3658651331713676e-02
                    6 4.7482139272102975e-02 1.2554127450191929e-01 2.5526729456251767e-01 6.1919143093556304e-01
                    6 1.8374798819956253e-02 2.0350443541788744e-02 3.9908788030187748e-01 5.8056167615633377e-01
                    6 1.9072906936608289e-02 2.6796482664027441e-02 2.4078989614336499e-01 7.3241362119260757e-01
                    6 1.0185683689901881e-02 1.6435295935411060e-02 1.1398368019124052e-01 8.6958102387334842e-01];
                
        end
end

V1=[]; V2=[]; V3=[];

if isempty(xyw) == 0
    i3=find(xyw(:,1) == 1);
    if length(i3) > 0
        V3=xyw(i3,2);
    end
    
    i2=find(xyw(:,1) == 3);
    if length(i2) > 0
        V2=xyw(i2,[2 4]);
    end
    
    i1=find(xyw(:,1) == 6);
    if length(i2) > 0
        V1=xyw(i1,2:4);
    end

end
