
function [xyw,pointset_stats]=set_radon_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% J. RADON.
%  "Zur mechanischen Kubatur"
%  Monatshefte fr Mathematik, 52 (1948), pp.286-300.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   5 |   7 |   0 |   0 | 2.78e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.12500000000000002775557561562891e-01
            4.70142064105115053962435922585428e-01 5.97158717897698018695074040351756e-02 6.61970763942530820989063045090006e-02
            5.97158717897698018695074040351756e-02 4.70142064105115053962435922585428e-01 6.61970763942530820989063045090006e-02
            4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 6.61970763942530820989063045090006e-02
            1.01286507323456329010546994595643e-01 7.97426985353087203201027932664147e-01 6.29695902724135836425745083033689e-02
            7.97426985353087203201027932664147e-01 1.01286507323456329010546994595643e-01 6.29695902724135836425745083033689e-02
            1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 6.29695902724135836425745083033689e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    5    7 2.78e-16    0    0
    ];




