
 	function [xyw_bar,pointset_stats]=set_stroud_barycentric(deg)
 	
 	 %--------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
 	 %--------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 %--------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
 	 %      REMARK: The sum of the weights makes 1.
 	 % 
 	 % pointset_stats:
 	 %    statistics of the pointset stored in a matrix. Each rows contains
 	 %    degree, cardinality of the full pointset, moment error w.r.t. 
 	 %    orthn. Dubiner basis, number of points with negative weights,
 	 %    number of points outside the domain.
 	 %--------------------------------------------------------------------
 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
     % REMARK:
     % We remark that the rules for even degrees and their successive
     % integer are the same.
     %--------------------------------------
  	 % (  1) deg:   1 cub.err.: 1.92e-16
 	 % (  1) deg:   2 cub.err.: 6.80e-01
 	 %--------------------------------------
 	 % (  2) deg:   2 cub.err.: 2.15e-16
 	 % (  2) deg:   3 cub.err.: 2.15e-16
 	 % (  2) deg:   4 cub.err.: 5.30e-01
 	 %--------------------------------------
 	 % (  3) deg:   3 cub.err.: 2.15e-16
 	 % (  3) deg:   4 cub.err.: 5.30e-01
 	 %--------------------------------------
 	 % (  4) deg:   4 cub.err.: 4.72e-16
 	 % (  4) deg:   5 cub.err.: 6.66e-16
 	 % (  4) deg:   6 cub.err.: 4.76e-01
 	 %--------------------------------------
 	 % (  5) deg:   5 cub.err.: 6.66e-16
 	 % (  5) deg:   6 cub.err.: 4.76e-01
 	 %--------------------------------------------------------------------
 
 
 	 switch deg
 
 	 case   1 

 	 % ALG. DEG.:    1
 	 % PTS CARD.:    1
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.9e-16  

 	 xyw_bar=[
 	 3.33333333333333425851918718763045e-01 3.33333333333333314829616256247391e-01 3.33333333333333203807313793731737e-01 1.00000000000000000000000000000000e+00
 	 ];
 
 	 case   2 

 	 % ALG. DEG.:    2
 	 % PTS CARD.:    4
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.2e-16  

 	 xyw_bar=[
 	 6.44948974278317765929102733934997e-01 2.80019915499074123488298937445506e-01 7.50311102226081105825983286194969e-02 1.81958618256022774950508846814046e-01
 	 1.55051025721682167457515788555611e-01 6.66390246014701426169324349757517e-01 1.78558728263616406373159861686872e-01 3.18041381743977169538339921928127e-01
 	 6.44948974278317765929102733934997e-01 7.50311102226081105825983286194969e-02 2.80019915499074123488298937445506e-01 1.81958618256022774950508846814046e-01
 	 1.55051025721682167457515788555611e-01 1.78558728263616406373159861686872e-01 6.66390246014701426169324349757517e-01 3.18041381743977169538339921928127e-01
 	 ];
 
 	 case   3 

 	 % ALG. DEG.:    3
 	 % PTS CARD.:    4
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.2e-16  

 	 xyw_bar=[
 	 6.44948974278317765929102733934997e-01 2.80019915499074123488298937445506e-01 7.50311102226081105825983286194969e-02 1.81958618256022774950508846814046e-01
 	 1.55051025721682167457515788555611e-01 6.66390246014701426169324349757517e-01 1.78558728263616406373159861686872e-01 3.18041381743977169538339921928127e-01
 	 6.44948974278317765929102733934997e-01 7.50311102226081105825983286194969e-02 2.80019915499074123488298937445506e-01 1.81958618256022774950508846814046e-01
 	 1.55051025721682167457515788555611e-01 1.78558728263616406373159861686872e-01 6.66390246014701426169324349757517e-01 3.18041381743977169538339921928127e-01
 	 ];
 
 	 case   4 

 	 % ALG. DEG.:    4
 	 % PTS CARD.:    9
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.7e-16  

 	 xyw_bar=[
 	 7.87659461760847112721251050970750e-01 1.88409405952072228629390338028315e-01 2.39311322870806586493586110009346e-02 3.87927666119190425741969363571116e-02
 	 4.09466864440734656938047919538803e-01 5.23979067720100832872276441776194e-01 6.65540678391645101896756386850029e-02 1.27356170199770274420458804343070e-01
 	 8.85879595127039287660863919882104e-02 8.08694385677669824730173786520027e-01 1.02717654809626246503739821491763e-01 1.11628840966088660469068827296724e-01
 	 7.87659461760847223743553513486404e-01 1.06170269119576415883798858885712e-01 1.06170269119576360372647627627885e-01 6.20684265790704126075638669135515e-02
 	 4.09466864440734656938047919538803e-01 2.95266567779632671530976040230598e-01 2.95266567779632671530976040230598e-01 2.03769872319632255885935023798083e-01
 	 8.85879595127039287660863919882104e-02 4.55706020243648035616956804005895e-01 4.55706020243648035616956804005895e-01 1.78606145545741695768171553027059e-01
 	 7.87659461760847223743553513486404e-01 2.39311322870806031382073797431076e-02 1.88409405952072173118239106770488e-01 3.87927666119190425741969363571116e-02
 	 4.09466864440734656938047919538803e-01 6.65540678391645101896756386850029e-02 5.23979067720100832872276441776194e-01 1.27356170199770274420458804343070e-01
 	 8.85879595127039287660863919882104e-02 1.02717654809626246503739821491763e-01 8.08694385677669824730173786520027e-01 1.11628840966088660469068827296724e-01
 	 ];
 
 	 case   5 

 	 % ALG. DEG.:    5
 	 % PTS CARD.:    9
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 6.7e-16  

 	 xyw_bar=[
 	 7.87659461760847112721251050970750e-01 1.88409405952072228629390338028315e-01 2.39311322870806586493586110009346e-02 3.87927666119190425741969363571116e-02
 	 4.09466864440734656938047919538803e-01 5.23979067720100832872276441776194e-01 6.65540678391645101896756386850029e-02 1.27356170199770274420458804343070e-01
 	 8.85879595127039287660863919882104e-02 8.08694385677669824730173786520027e-01 1.02717654809626246503739821491763e-01 1.11628840966088660469068827296724e-01
 	 7.87659461760847223743553513486404e-01 1.06170269119576415883798858885712e-01 1.06170269119576360372647627627885e-01 6.20684265790704126075638669135515e-02
 	 4.09466864440734656938047919538803e-01 2.95266567779632671530976040230598e-01 2.95266567779632671530976040230598e-01 2.03769872319632255885935023798083e-01
 	 8.85879595127039287660863919882104e-02 4.55706020243648035616956804005895e-01 4.55706020243648035616956804005895e-01 1.78606145545741695768171553027059e-01
 	 7.87659461760847223743553513486404e-01 2.39311322870806031382073797431076e-02 1.88409405952072173118239106770488e-01 3.87927666119190425741969363571116e-02
 	 4.09466864440734656938047919538803e-01 6.65540678391645101896756386850029e-02 5.23979067720100832872276441776194e-01 1.27356170199770274420458804343070e-01
 	 8.85879595127039287660863919882104e-02 1.02717654809626246503739821491763e-01 8.08694385677669824730173786520027e-01 1.11628840966088660469068827296724e-01
 	 ];
 
 	 case   6 

 	 % ALG. DEG.:    6
 	 % PTS CARD.:   16
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.2e-16  

 	 xyw_bar=[
 	 8.60240135656219373494479896180565e-01 1.30056079216834458156526466154901e-01 9.70378512694616834899363766453462e-03 1.08464518210505105749730248021478e-02
 	 5.83590432368916722793983353767544e-01 3.87497483406694154250970996145043e-01 2.89120842243891229550456500874134e-02 4.51680985647398905435956351084315e-02
 	 2.76843013638123802699908537761075e-01 6.72946863150506446871190746605862e-01 5.02101232113697504289007156330626e-02 7.07761357961719378417697612349002e-02
 	 5.71041961145177801029149122769013e-02 8.77428809330467740501546813902678e-01 6.54669945550144793955382738204207e-02 4.71367363867646743669226339079614e-02
 	 8.60240135656219484516782358696219e-01 9.36377844373285223023017920240818e-02 4.61220799064519931809158492796996e-02 2.03345191289575656645727264049128e-02
 	 5.83590432368916833816285816283198e-01 2.78990463496508800389506177452859e-01 1.37419104134574365794208006263943e-01 8.46794490434925883892702813682263e-02
 	 2.76843013638123802699908537761075e-01 4.84508326630433305837186708231457e-01 2.38648659731442891462904754007468e-01 1.32688432214099510941807125163905e-01
 	 5.71041961145177801029149122769013e-02 6.31731251641125313156521769997198e-01 3.11164552244356906740563317725901e-01 8.83701770447234274952208465947479e-02
 	 8.60240135656219484516782358696219e-01 4.61220799064520348142792727230699e-02 9.36377844373284806689383685807115e-02 2.03345191289575552562318705440703e-02
 	 5.83590432368916944838588278798852e-01 1.37419104134574310283056775006116e-01 2.78990463496508744878354946195032e-01 8.46794490434925467559068579248560e-02
 	 2.76843013638123858211059769018902e-01 2.38648659731442835951753522749641e-01 4.84508326630433250326035476973630e-01 1.32688432214099427675080278277164e-01
 	 5.71041961145177801029149122769013e-02 3.11164552244356906740563317725901e-01 6.31731251641125313156521769997198e-01 8.83701770447233858618574231513776e-02
 	 8.60240135656219373494479896180565e-01 9.70378512694611283784240640670760e-03 1.30056079216834513667677697412728e-01 1.08464518210505157791434527325691e-02
 	 5.83590432368916722793983353767544e-01 2.89120842243890119327431875717593e-02 3.87497483406694265273273458660697e-01 4.51680985647399113602773468301166e-02
 	 2.76843013638123802699908537761075e-01 5.02101232113698614512031781487167e-02 6.72946863150506335848888284090208e-01 7.07761357961719794751331846782705e-02
 	 5.71041961145177801029149122769013e-02 6.54669945550144793955382738204207e-02 8.77428809330467740501546813902678e-01 4.71367363867647021224982495368749e-02
 	 ];
 
 	 case   7 

 	 % ALG. DEG.:    7
 	 % PTS CARD.:   16
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.2e-16  

 	 xyw_bar=[
 	 8.60240135656219373494479896180565e-01 1.30056079216834458156526466154901e-01 9.70378512694616834899363766453462e-03 1.08464518210505105749730248021478e-02
 	 5.83590432368916722793983353767544e-01 3.87497483406694154250970996145043e-01 2.89120842243891229550456500874134e-02 4.51680985647398905435956351084315e-02
 	 2.76843013638123802699908537761075e-01 6.72946863150506446871190746605862e-01 5.02101232113697504289007156330626e-02 7.07761357961719378417697612349002e-02
 	 5.71041961145177801029149122769013e-02 8.77428809330467740501546813902678e-01 6.54669945550144793955382738204207e-02 4.71367363867646743669226339079614e-02
 	 8.60240135656219484516782358696219e-01 9.36377844373285223023017920240818e-02 4.61220799064519931809158492796996e-02 2.03345191289575656645727264049128e-02
 	 5.83590432368916833816285816283198e-01 2.78990463496508800389506177452859e-01 1.37419104134574365794208006263943e-01 8.46794490434925883892702813682263e-02
 	 2.76843013638123802699908537761075e-01 4.84508326630433305837186708231457e-01 2.38648659731442891462904754007468e-01 1.32688432214099510941807125163905e-01
 	 5.71041961145177801029149122769013e-02 6.31731251641125313156521769997198e-01 3.11164552244356906740563317725901e-01 8.83701770447234274952208465947479e-02
 	 8.60240135656219484516782358696219e-01 4.61220799064520348142792727230699e-02 9.36377844373284806689383685807115e-02 2.03345191289575552562318705440703e-02
 	 5.83590432368916944838588278798852e-01 1.37419104134574310283056775006116e-01 2.78990463496508744878354946195032e-01 8.46794490434925467559068579248560e-02
 	 2.76843013638123858211059769018902e-01 2.38648659731442835951753522749641e-01 4.84508326630433250326035476973630e-01 1.32688432214099427675080278277164e-01
 	 5.71041961145177801029149122769013e-02 3.11164552244356906740563317725901e-01 6.31731251641125313156521769997198e-01 8.83701770447233858618574231513776e-02
 	 8.60240135656219373494479896180565e-01 9.70378512694611283784240640670760e-03 1.30056079216834513667677697412728e-01 1.08464518210505157791434527325691e-02
 	 5.83590432368916722793983353767544e-01 2.89120842243890119327431875717593e-02 3.87497483406694265273273458660697e-01 4.51680985647399113602773468301166e-02
 	 2.76843013638123802699908537761075e-01 5.02101232113698614512031781487167e-02 6.72946863150506335848888284090208e-01 7.07761357961719794751331846782705e-02
 	 5.71041961145177801029149122769013e-02 6.54669945550144793955382738204207e-02 8.77428809330467740501546813902678e-01 4.71367363867647021224982495368749e-02
 	 ];
 
 	 case   8 

 	 % ALG. DEG.:    8
 	 % PTS CARD.:   25
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 9.01464914201173583840898118069163e-01 9.39127973337799820674476336535008e-02 4.62228846504643409165424827733659e-03 3.73110433375567051433874254939838e-03
 	 6.95464273353636031060887034982443e-01 2.90249932250792541665873613965232e-01 1.42857943955714272732393510523252e-02 1.75109983643276338749483755918845e-02
 	 4.37974810247386159289817442186177e-01 5.35660544808142846662235569965560e-01 2.63646449444709940479469878482632e-02 3.46830128627313299949364022722875e-02
 	 1.98013417873607933117341417528223e-01 7.64365329781280800069964698195690e-01 3.76212523451112668126938842760865e-02 3.96081662640947115838763181727700e-02
 	 3.98098570514688887556076224427670e-02 9.15147549378727331870209127373528e-01 4.50425935698037793741832501837052e-02 2.29301607031849943862944485317712e-02
 	 9.01464914201173583840898118069163e-01 7.57966027350623905434190419327933e-02 2.27384830637640256156828399980441e-02 7.53740339065523366757215484312837e-03
 	 6.95464273353636031060887034982443e-01 2.34259434638082242319256920382031e-01 7.02762920082817266198560446355259e-02 3.53749042209669031788799031801318e-02
 	 4.37974810247386159289817442186177e-01 4.32329252970359734220551217731554e-01 1.29695936782254106489631340082269e-01 7.00650090067433534146701390454837e-02
 	 1.98013417873607933117341417528223e-01 6.16915871859002651333980793424416e-01 1.85070710267389415548677789047360e-01 8.00145747723209205259919940544933e-02
 	 3.98098570514688887556076224427670e-02 7.38611533396152042385551794723142e-01 2.21578609552379068858840582834091e-01 4.63224438589966078239079649847554e-02
 	 9.01464914201173694863200580584817e-01 4.92675428994132080795509409654187e-02 4.92675428994130970572484784497647e-02 8.95881359456271973706886768695767e-03
 	 6.95464273353636031060887034982443e-01 1.52267863323181984469556482508779e-01 1.52267863323181984469556482508779e-01 4.20459349746441640727212529782264e-02
 	 4.37974810247386159289817442186177e-01 2.81012594876306920355091278906912e-01 2.81012594876306920355091278906912e-01 8.32779304303899320371940007134981e-02
 	 1.98013417873607933117341417528223e-01 4.00993291063196033441329291235888e-01 4.00993291063196033441329291235888e-01 9.51037941159082189646056804122054e-02
 	 3.98098570514688887556076224427670e-02 4.80095071474265555622196188778616e-01 4.80095071474265555622196188778616e-01 5.50579713289394839792478819617827e-02
 	 9.01464914201173583840898118069163e-01 2.27384830637640394934706478125008e-02 7.57966027350623766656312341183366e-02 7.53740339065524060646605875035675e-03
 	 6.95464273353636031060887034982443e-01 7.02762920082817543754316602644394e-02 2.34259434638082214563681304753118e-01 3.53749042209669378733494227162737e-02
 	 4.37974810247386103778666210928350e-01 1.29695936782254162000782571340096e-01 4.32329252970359678709399986473727e-01 7.00650090067434228036091781177674e-02
 	 1.98013417873607933117341417528223e-01 1.85070710267389526570980251563014e-01 6.16915871859002540311678330908762e-01 8.00145747723209899149310331267770e-02
 	 3.98098570514688887556076224427670e-02 2.21578609552379179881143045349745e-01 7.38611533396151931363249332207488e-01 4.63224438589966494572713884281256e-02
 	 9.01464914201173583840898118069163e-01 4.62228846504643409165424827733659e-03 9.39127973337799820674476336535008e-02 3.73110433375566964697700456099483e-03
 	 6.95464273353636031060887034982443e-01 1.42857943955714272732393510523252e-02 2.90249932250792541665873613965232e-01 1.75109983643276304055014236382704e-02
 	 4.37974810247386159289817442186177e-01 2.63646449444709940479469878482632e-02 5.35660544808142846662235569965560e-01 3.46830128627313230560424983650591e-02
 	 1.98013417873607933117341417528223e-01 3.76212523451112668126938842760865e-02 7.64365329781280800069964698195690e-01 3.96081662640947046449824142655416e-02
 	 3.98098570514688887556076224427670e-02 4.50425935698037793741832501837052e-02 9.15147549378727331870209127373528e-01 2.29301607031849874474005446245428e-02
 	 ];
 
 	 case   9 

 	 % ALG. DEG.:    9
 	 % PTS CARD.:   25
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 9.01464914201173583840898118069163e-01 9.39127973337799820674476336535008e-02 4.62228846504643409165424827733659e-03 3.73110433375567051433874254939838e-03
 	 6.95464273353636031060887034982443e-01 2.90249932250792541665873613965232e-01 1.42857943955714272732393510523252e-02 1.75109983643276338749483755918845e-02
 	 4.37974810247386159289817442186177e-01 5.35660544808142846662235569965560e-01 2.63646449444709940479469878482632e-02 3.46830128627313299949364022722875e-02
 	 1.98013417873607933117341417528223e-01 7.64365329781280800069964698195690e-01 3.76212523451112668126938842760865e-02 3.96081662640947115838763181727700e-02
 	 3.98098570514688887556076224427670e-02 9.15147549378727331870209127373528e-01 4.50425935698037793741832501837052e-02 2.29301607031849943862944485317712e-02
 	 9.01464914201173583840898118069163e-01 7.57966027350623905434190419327933e-02 2.27384830637640256156828399980441e-02 7.53740339065523366757215484312837e-03
 	 6.95464273353636031060887034982443e-01 2.34259434638082242319256920382031e-01 7.02762920082817266198560446355259e-02 3.53749042209669031788799031801318e-02
 	 4.37974810247386159289817442186177e-01 4.32329252970359734220551217731554e-01 1.29695936782254106489631340082269e-01 7.00650090067433534146701390454837e-02
 	 1.98013417873607933117341417528223e-01 6.16915871859002651333980793424416e-01 1.85070710267389415548677789047360e-01 8.00145747723209205259919940544933e-02
 	 3.98098570514688887556076224427670e-02 7.38611533396152042385551794723142e-01 2.21578609552379068858840582834091e-01 4.63224438589966078239079649847554e-02
 	 9.01464914201173694863200580584817e-01 4.92675428994132080795509409654187e-02 4.92675428994130970572484784497647e-02 8.95881359456271973706886768695767e-03
 	 6.95464273353636031060887034982443e-01 1.52267863323181984469556482508779e-01 1.52267863323181984469556482508779e-01 4.20459349746441640727212529782264e-02
 	 4.37974810247386159289817442186177e-01 2.81012594876306920355091278906912e-01 2.81012594876306920355091278906912e-01 8.32779304303899320371940007134981e-02
 	 1.98013417873607933117341417528223e-01 4.00993291063196033441329291235888e-01 4.00993291063196033441329291235888e-01 9.51037941159082189646056804122054e-02
 	 3.98098570514688887556076224427670e-02 4.80095071474265555622196188778616e-01 4.80095071474265555622196188778616e-01 5.50579713289394839792478819617827e-02
 	 9.01464914201173583840898118069163e-01 2.27384830637640394934706478125008e-02 7.57966027350623766656312341183366e-02 7.53740339065524060646605875035675e-03
 	 6.95464273353636031060887034982443e-01 7.02762920082817543754316602644394e-02 2.34259434638082214563681304753118e-01 3.53749042209669378733494227162737e-02
 	 4.37974810247386103778666210928350e-01 1.29695936782254162000782571340096e-01 4.32329252970359678709399986473727e-01 7.00650090067434228036091781177674e-02
 	 1.98013417873607933117341417528223e-01 1.85070710267389526570980251563014e-01 6.16915871859002540311678330908762e-01 8.00145747723209899149310331267770e-02
 	 3.98098570514688887556076224427670e-02 2.21578609552379179881143045349745e-01 7.38611533396151931363249332207488e-01 4.63224438589966494572713884281256e-02
 	 9.01464914201173583840898118069163e-01 4.62228846504643409165424827733659e-03 9.39127973337799820674476336535008e-02 3.73110433375566964697700456099483e-03
 	 6.95464273353636031060887034982443e-01 1.42857943955714272732393510523252e-02 2.90249932250792541665873613965232e-01 1.75109983643276304055014236382704e-02
 	 4.37974810247386159289817442186177e-01 2.63646449444709940479469878482632e-02 5.35660544808142846662235569965560e-01 3.46830128627313230560424983650591e-02
 	 1.98013417873607933117341417528223e-01 3.76212523451112668126938842760865e-02 7.64365329781280800069964698195690e-01 3.96081662640947046449824142655416e-02
 	 3.98098570514688887556076224427670e-02 4.50425935698037793741832501837052e-02 9.15147549378727331870209127373528e-01 2.29301607031849874474005446245428e-02
 	 ];
 
 	 case  10 

 	 % ALG. DEG.:   10
 	 % PTS CARD.:   36
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 9.26945671319741149041249173023971e-01 7.05876315275886512257130789294024e-02 2.46669715267019973303774804662680e-03 1.49708512247263879693659482938983e-03
 	 7.69233862030054504899112544080708e-01 2.22974263268659017578343650711759e-01 7.79187470128647752254380520753330e-03 7.53059642538334624711771070337818e-03
 	 5.58671518771550079662802090751939e-01 4.26426917861778609353251567881671e-01 1.49015633666713109839463413663907e-02 1.69030715938862582947699308988376e-02
 	 3.36984690281154297686327936389716e-01 6.40628436740814932726095776160946e-01 2.23868729780307695875762874493375e-02 2.41212128085302041080595358835126e-02
 	 1.48078599668484356399744683585595e-01 8.23156067318956408129793089756276e-01 2.87653330125592354704622266581282e-02 2.32217495339950459609656974180325e-02
 	 2.93164271597847747585774413892068e-02 9.37908206225755214369144141528523e-01 3.27753666144600108722784170822706e-02 1.23885307053177087799333833117998e-02
 	 9.26945671319741038018946710508317e-01 6.06792682628188653759515602814645e-02 1.23750604174400966051017292102188e-02 3.15244350804718027891926368511122e-03
 	 7.69233862030054504899112544080708e-01 1.91675437237121243372328649456904e-01 3.90907007328242517285588064623880e-02 1.58573346675929642557445475858913e-02
 	 5.58671518771550079662802090751939e-01 3.66569507765800772780551142204786e-01 7.47589734626491475566467670432758e-02 3.55931519940525728507019209700957e-02
 	 3.36984690281154297686327936389716e-01 5.50703627937891959653882167913252e-01 1.12311681780953742659789895697031e-01 5.07925431780952632565551141397009e-02
 	 1.48078599668484356399744683585595e-01 7.07609913381099020490694329055259e-01 1.44311486950416623109560987359146e-01 4.88985245161156489857035012391862e-02
 	 2.93164271597847747585774413892068e-02 8.06254331245387700910498551820638e-01 1.64429241594827524330924006790156e-01 2.60867886601656717715513877919875e-02
 	 9.26945671319741149041249173023971e-01 4.52432465648983095363178108527791e-02 2.78110821153605414224330161232501e-02 4.08877318308972434457437827859394e-03
 	 7.69233862030054504899112544080708e-01 1.42915682993948300882891544461017e-01 8.78504549759971942179959114582743e-02 2.05672344575326647431179338809670e-02
 	 5.58671518771550079662802090751939e-01 2.73318962107257978910723750232137e-01 1.68009519121191941426474159015925e-01 4.61649273027165060745424796095904e-02
 	 3.36984690281154353197479167647543e-01 4.10611741642327665591238883280312e-01 2.52403568076517925700130717814318e-01 6.58787978015733660663855175698700e-02
 	 1.48078599668484356399744683585595e-01 5.27603095742739558460243642912246e-01 3.24318304588776085140011673502158e-01 6.34222231814080134038036362653656e-02
 	 2.93164271597847747585774413892068e-02 6.01153648467838364055637612182181e-01 3.69529924372376861185784946428612e-01 3.38350113600253479817503432514059e-02
 	 9.26945671319741038018946710508317e-01 2.78110821153605969335842473810771e-02 4.52432465648983650474690421106061e-02 4.08877318308972694665959224380458e-03
 	 7.69233862030054504899112544080708e-01 8.78504549759971942179959114582743e-02 1.42915682993948300882891544461017e-01 2.05672344575326786209057416954238e-02
 	 5.58671518771550079662802090751939e-01 1.68009519121191885915322927758098e-01 2.73318962107258034421874981489964e-01 4.61649273027165407690119991457323e-02
 	 3.36984690281154353197479167647543e-01 2.52403568076518036722433180329972e-01 4.10611741642327554568936420764658e-01 6.58787978015734076997489410132403e-02
 	 1.48078599668484356399744683585595e-01 3.24318304588776085140011673502158e-01 5.27603095742739558460243642912246e-01 6.34222231814080550371670597087359e-02
 	 2.93164271597847747585774413892068e-02 3.69529924372376861185784946428612e-01 6.01153648467838364055637612182181e-01 3.38350113600253687984320549730910e-02
 	 9.26945671319741038018946710508317e-01 1.23750604174400341550565940451634e-02 6.06792682628189278259966954465199e-02 3.15244350804717550842970474889171e-03
 	 7.69233862030054504899112544080708e-01 3.90907007328242239729831908334745e-02 1.91675437237121271127904265085817e-01 1.58573346675929399696158839105919e-02
 	 5.58671518771550079662802090751939e-01 7.47589734626490365343443045276217e-02 3.66569507765800883802853604720440e-01 3.55931519940525173395506897122686e-02
 	 3.36984690281154297686327936389716e-01 1.12311681780953631637487433181377e-01 5.50703627937892070676184630428907e-01 5.07925431780951799898282672529604e-02
 	 1.48078599668484356399744683585595e-01 1.44311486950416512087258524843492e-01 7.07609913381099131512996791570913e-01 4.88985245161155726578705582596740e-02
 	 2.93164271597847747585774413892068e-02 1.64429241594827413308621544274502e-01 8.06254331245387811932801014336292e-01 2.60867886601656301381879643486172e-02
 	 9.26945671319741149041249173023971e-01 2.46669715267025524418897930445382e-03 7.05876315275885957145618476715754e-02 1.49708512247264031481963630909604e-03
 	 7.69233862030054504899112544080708e-01 7.79187470128644976696818957861979e-03 2.22974263268659045333919266340672e-01 7.53059642538335492073509058741365e-03
 	 5.58671518771550079662802090751939e-01 1.49015633666711999616438788507367e-02 4.26426917861778720375554030397325e-01 1.69030715938862756420046906669086e-02
 	 3.36984690281154297686327936389716e-01 2.23868729780306585652738249336835e-02 6.40628436740815043748398238676600e-01 2.41212128085302318636351515124261e-02
 	 1.48078599668484356399744683585595e-01 2.87653330125592354704622266581282e-02 8.23156067318956408129793089756276e-01 2.32217495339950737165413130469460e-02
 	 2.93164271597847747585774413892068e-02 3.27753666144600108722784170822706e-02 9.37908206225755214369144141528523e-01 1.23885307053177226577211911262566e-02
 	 ];
 
 	 case  11 

 	 % ALG. DEG.:   11
 	 % PTS CARD.:   36
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 9.26945671319741149041249173023971e-01 7.05876315275886512257130789294024e-02 2.46669715267019973303774804662680e-03 1.49708512247263879693659482938983e-03
 	 7.69233862030054504899112544080708e-01 2.22974263268659017578343650711759e-01 7.79187470128647752254380520753330e-03 7.53059642538334624711771070337818e-03
 	 5.58671518771550079662802090751939e-01 4.26426917861778609353251567881671e-01 1.49015633666713109839463413663907e-02 1.69030715938862582947699308988376e-02
 	 3.36984690281154297686327936389716e-01 6.40628436740814932726095776160946e-01 2.23868729780307695875762874493375e-02 2.41212128085302041080595358835126e-02
 	 1.48078599668484356399744683585595e-01 8.23156067318956408129793089756276e-01 2.87653330125592354704622266581282e-02 2.32217495339950459609656974180325e-02
 	 2.93164271597847747585774413892068e-02 9.37908206225755214369144141528523e-01 3.27753666144600108722784170822706e-02 1.23885307053177087799333833117998e-02
 	 9.26945671319741038018946710508317e-01 6.06792682628188653759515602814645e-02 1.23750604174400966051017292102188e-02 3.15244350804718027891926368511122e-03
 	 7.69233862030054504899112544080708e-01 1.91675437237121243372328649456904e-01 3.90907007328242517285588064623880e-02 1.58573346675929642557445475858913e-02
 	 5.58671518771550079662802090751939e-01 3.66569507765800772780551142204786e-01 7.47589734626491475566467670432758e-02 3.55931519940525728507019209700957e-02
 	 3.36984690281154297686327936389716e-01 5.50703627937891959653882167913252e-01 1.12311681780953742659789895697031e-01 5.07925431780952632565551141397009e-02
 	 1.48078599668484356399744683585595e-01 7.07609913381099020490694329055259e-01 1.44311486950416623109560987359146e-01 4.88985245161156489857035012391862e-02
 	 2.93164271597847747585774413892068e-02 8.06254331245387700910498551820638e-01 1.64429241594827524330924006790156e-01 2.60867886601656717715513877919875e-02
 	 9.26945671319741149041249173023971e-01 4.52432465648983095363178108527791e-02 2.78110821153605414224330161232501e-02 4.08877318308972434457437827859394e-03
 	 7.69233862030054504899112544080708e-01 1.42915682993948300882891544461017e-01 8.78504549759971942179959114582743e-02 2.05672344575326647431179338809670e-02
 	 5.58671518771550079662802090751939e-01 2.73318962107257978910723750232137e-01 1.68009519121191941426474159015925e-01 4.61649273027165060745424796095904e-02
 	 3.36984690281154353197479167647543e-01 4.10611741642327665591238883280312e-01 2.52403568076517925700130717814318e-01 6.58787978015733660663855175698700e-02
 	 1.48078599668484356399744683585595e-01 5.27603095742739558460243642912246e-01 3.24318304588776085140011673502158e-01 6.34222231814080134038036362653656e-02
 	 2.93164271597847747585774413892068e-02 6.01153648467838364055637612182181e-01 3.69529924372376861185784946428612e-01 3.38350113600253479817503432514059e-02
 	 9.26945671319741038018946710508317e-01 2.78110821153605969335842473810771e-02 4.52432465648983650474690421106061e-02 4.08877318308972694665959224380458e-03
 	 7.69233862030054504899112544080708e-01 8.78504549759971942179959114582743e-02 1.42915682993948300882891544461017e-01 2.05672344575326786209057416954238e-02
 	 5.58671518771550079662802090751939e-01 1.68009519121191885915322927758098e-01 2.73318962107258034421874981489964e-01 4.61649273027165407690119991457323e-02
 	 3.36984690281154353197479167647543e-01 2.52403568076518036722433180329972e-01 4.10611741642327554568936420764658e-01 6.58787978015734076997489410132403e-02
 	 1.48078599668484356399744683585595e-01 3.24318304588776085140011673502158e-01 5.27603095742739558460243642912246e-01 6.34222231814080550371670597087359e-02
 	 2.93164271597847747585774413892068e-02 3.69529924372376861185784946428612e-01 6.01153648467838364055637612182181e-01 3.38350113600253687984320549730910e-02
 	 9.26945671319741038018946710508317e-01 1.23750604174400341550565940451634e-02 6.06792682628189278259966954465199e-02 3.15244350804717550842970474889171e-03
 	 7.69233862030054504899112544080708e-01 3.90907007328242239729831908334745e-02 1.91675437237121271127904265085817e-01 1.58573346675929399696158839105919e-02
 	 5.58671518771550079662802090751939e-01 7.47589734626490365343443045276217e-02 3.66569507765800883802853604720440e-01 3.55931519940525173395506897122686e-02
 	 3.36984690281154297686327936389716e-01 1.12311681780953631637487433181377e-01 5.50703627937892070676184630428907e-01 5.07925431780951799898282672529604e-02
 	 1.48078599668484356399744683585595e-01 1.44311486950416512087258524843492e-01 7.07609913381099131512996791570913e-01 4.88985245161155726578705582596740e-02
 	 2.93164271597847747585774413892068e-02 1.64429241594827413308621544274502e-01 8.06254331245387811932801014336292e-01 2.60867886601656301381879643486172e-02
 	 9.26945671319741149041249173023971e-01 2.46669715267025524418897930445382e-03 7.05876315275885957145618476715754e-02 1.49708512247264031481963630909604e-03
 	 7.69233862030054504899112544080708e-01 7.79187470128644976696818957861979e-03 2.22974263268659045333919266340672e-01 7.53059642538335492073509058741365e-03
 	 5.58671518771550079662802090751939e-01 1.49015633666711999616438788507367e-02 4.26426917861778720375554030397325e-01 1.69030715938862756420046906669086e-02
 	 3.36984690281154297686327936389716e-01 2.23868729780306585652738249336835e-02 6.40628436740815043748398238676600e-01 2.41212128085302318636351515124261e-02
 	 1.48078599668484356399744683585595e-01 2.87653330125592354704622266581282e-02 8.23156067318956408129793089756276e-01 2.32217495339950737165413130469460e-02
 	 2.93164271597847747585774413892068e-02 3.27753666144600108722784170822706e-02 9.37908206225755214369144141528523e-01 1.23885307053177226577211911262566e-02
 	 ];
 
 	 case  12 

 	 % ALG. DEG.:   12
 	 % PTS CARD.:   49
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.9e-16  

 	 xyw_bar=[
 	 9.43737439463077754098208060895558e-01 5.48309009555892484799599628786382e-02 1.43165958133299742183197622580337e-03 6.75181513422745249036749370930011e-04
 	 8.19759308263107611125519724737387e-01 1.75654279195254586776187011309958e-01 4.58641254163780209829326395265525e-03 3.54897014287608360966208564946101e-03
 	 6.47375282886830327733207468554610e-01 3.43651813106452985735472793749068e-01 8.97290400671668653131973769632168e-03 8.59582017596482832189064282601976e-03
 	 4.52846373669444579590503963117953e-01 5.33230731173959360269520857400494e-01 1.39228951565960601399751794815529e-02 1.38710855074681057436114528513826e-02
 	 2.65789822784589513382513814576669e-01 7.15527432866567836278193226462463e-01 1.86827443488426503392929589608684e-02 1.64952060270591380208848875099648e-02
 	 1.14679053160904209640591489005601e-01 8.62793031223432205223389246384613e-01 2.25279156156635851360192646097858e-02 1.43092875581922445576976699044280e-02
 	 2.24793864387125008619250365882181e-02 9.52646581185226826171685843291925e-01 2.48740323760606729663891201198567e-02 7.24693215945156413160255226557638e-03
 	 9.43737439463077865120510523411212e-01 4.89915018783618969044901803044922e-02 7.27105865856023797499929628429527e-03 1.45848522130312494710091542060582e-03
 	 8.19759308263107611125519724737387e-01 1.56947392786902617523026037815725e-01 2.32932989499897713514542374468874e-02 7.66626514696934577980380609574240e-03
 	 6.47375282886830327733207468554610e-01 3.07053470832874708662529883440584e-01 4.55712462802949636042626480048057e-02 1.85681575137770851768870272735512e-02
 	 4.52846373669444579590503963117953e-01 4.76442551784230117206675458874088e-01 7.07110745463253032028205780079588e-02 2.99634584387787894499410867865663e-02
 	 2.65789822784589513382513814576669e-01 6.39324960202547587506671789014945e-01 9.48852170128628991108143964083865e-02 3.56319208013516283695132358388946e-02
 	 1.14679053160904209640591489005601e-01 7.70907019092334389043230657989625e-01 1.14413927746761401316177853004774e-01 3.09100353254680992876046730089001e-02
 	 2.24793864387125008619250365882181e-02 8.51191316541618170354865924309706e-01 1.26329297019669328783209039102076e-01 1.56543732969901920604183231944262e-02
 	 9.43737439463077754098208060895558e-01 3.95482239674546792729259436782741e-02 1.67143365694675666288659954261675e-02 1.99100018324992449753052525807107e-03
 	 8.19759308263107611125519724737387e-01 1.26695251279609177874618808345986e-01 5.35454404572832109998614669166273e-02 1.04653342313752346914856872217570e-02
 	 6.47375282886830327733207468554610e-01 2.47867874404687937861524460458895e-01 1.04756842708481734405268070986494e-01 2.53476720041855875520386831567521e-02
 	 4.52846373669444579590503963117953e-01 3.84606636317685768311491756321630e-01 1.62546990012869652098004280560417e-01 4.09035692450195748071095636078098e-02
 	 2.65789822784589402360211352061015e-01 5.16092908865112276473041674762499e-01 2.18117268350298321166746973176487e-01 4.86416727497942791291762887340155e-02
 	 1.14679053160904209640591489005601e-01 6.22312080263294653548200585646555e-01 2.63008866575801136811207925347844e-01 4.21957556363048297276563403102045e-02
 	 2.24793864387125008619250365882181e-02 6.87121307473297249224231109110406e-01 2.90399306087990249913843854301376e-01 2.13700212026299400658313487610940e-02
 	 9.43737439463077754098208060895558e-01 2.81312802684610882564264500160789e-02 2.81312802684611576453654890883627e-02 2.17939056966316583099918524624172e-03
 	 8.19759308263107611125519724737387e-01 9.01203458684462083150279454457632e-02 9.01203458684461805594523298168497e-02 1.14555744013054537633333751500686e-02
 	 6.47375282886830327733207468554610e-01 1.76312358556584808377820650093781e-01 1.76312358556584863888971881351608e-01 2.77460935431278546414723962243443e-02
 	 4.52846373669444524079352731860126e-01 2.73576813165277654693596787183196e-01 2.73576813165277765715899249698850e-01 4.47739050092140836167864392791671e-02
 	 2.65789822784589513382513814576669e-01 3.67105088607705187797591861453839e-01 3.67105088607705298819894323969493e-01 5.32441954427667757387965252746653e-02
 	 1.14679053160904154129440257747774e-01 4.42660473419547784157401792981545e-01 4.42660473419548117224309180528508e-01 4.61883593418185578460821716362261e-02
 	 2.24793864387125008619250365882181e-02 4.88760306780643638546735019190237e-01 4.88760306780643860591339944221545e-01 2.33920735288387152128741774959053e-02
 	 9.43737439463077754098208060895558e-01 1.67143365694675180566086680755689e-02 3.95482239674547278451832710288727e-02 1.99100018324992406384965626386929e-03
 	 8.19759308263107611125519724737387e-01 5.35454404572832942665883138033678e-02 1.26695251279609094607891961459245e-01 1.04653342313752329567622112449499e-02
 	 6.47375282886830327733207468554610e-01 1.04756842708481762160843686615408e-01 2.47867874404687910105948844829982e-01 2.53476720041855806131447792495237e-02
 	 4.52846373669444635101655194375780e-01 1.62546990012869707609155511818244e-01 3.84606636317685712800340525063802e-01 4.09035692450195609293217557933531e-02
 	 2.65789822784589513382513814576669e-01 2.18117268350298321166746973176487e-01 5.16092908865112165450739212246845e-01 4.86416727497942652513884809195588e-02
 	 1.14679053160904209640591489005601e-01 2.63008866575801247833510387863498e-01 6.22312080263294542525898123130901e-01 4.21957556363048158498685324957478e-02
 	 2.24793864387125008619250365882181e-02 2.90399306087990360936146316817030e-01 6.87121307473297138201928646594752e-01 2.13700212026299331269374448538656e-02
 	 9.43737439463077865120510523411212e-01 7.27105865856028654725662363489391e-03 4.89915018783618483322328529538936e-02 1.45848522130312256185613595249606e-03
 	 8.19759308263107611125519724737387e-01 2.32932989499897991070298530758009e-02 1.56947392786902589767450422186812e-01 7.66626514696933363673947425809274e-03
 	 6.47375282886830327733207468554610e-01 4.55712462802949636042626480048057e-02 3.07053470832874708662529883440584e-01 1.85681575137770539518644596910235e-02
 	 4.52846373669444579590503963117953e-01 7.07110745463253032028205780079588e-02 4.76442551784230117206675458874088e-01 2.99634584387787408776837594359677e-02
 	 2.65789822784589513382513814576669e-01 9.48852170128627880885119338927325e-02 6.39324960202547698528974251530599e-01 3.56319208013515728583620045810676e-02
 	 1.14679053160904209640591489005601e-01 1.14413927746761290293875390489120e-01 7.70907019092334500065533120505279e-01 3.09100353254680472459003937046873e-02
 	 2.24793864387125008619250365882181e-02 1.26329297019669217760906576586422e-01 8.51191316541618281377168386825360e-01 1.56543732969901677742896595191269e-02
 	 9.43737439463077754098208060895558e-01 1.43165958133294884957464887520473e-03 5.48309009555892970522172902292368e-02 6.75181513422745465877183868030897e-04
 	 8.19759308263107611125519724737387e-01 4.58641254163788536502011083939578e-03 1.75654279195254503509460164423217e-01 3.54897014287608491070469263206633e-03
 	 6.47375282886830327733207468554610e-01 8.97290400671668653131973769632168e-03 3.43651813106452985735472793749068e-01 8.59582017596483179133759477963395e-03
 	 4.52846373669444579590503963117953e-01 1.39228951565960601399751794815529e-02 5.33230731173959360269520857400494e-01 1.38710855074681126825053567586110e-02
 	 2.65789822784589513382513814576669e-01 1.86827443488427613615954214765225e-02 7.15527432866567725255890763946809e-01 1.64952060270591449597787914171931e-02
 	 1.14679053160904209640591489005601e-01 2.25279156156635851360192646097858e-02 8.62793031223432205223389246384613e-01 1.43092875581922497618680978348493e-02
 	 2.24793864387125008619250365882181e-02 2.48740323760606729663891201198567e-02 9.52646581185226826171685843291925e-01 7.24693215945156673368776623078702e-03
 	 ];
 
 	 case  13 

 	 % ALG. DEG.:   13
 	 % PTS CARD.:   49
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.9e-16  

 	 xyw_bar=[
 	 9.43737439463077754098208060895558e-01 5.48309009555892484799599628786382e-02 1.43165958133299742183197622580337e-03 6.75181513422745249036749370930011e-04
 	 8.19759308263107611125519724737387e-01 1.75654279195254586776187011309958e-01 4.58641254163780209829326395265525e-03 3.54897014287608360966208564946101e-03
 	 6.47375282886830327733207468554610e-01 3.43651813106452985735472793749068e-01 8.97290400671668653131973769632168e-03 8.59582017596482832189064282601976e-03
 	 4.52846373669444579590503963117953e-01 5.33230731173959360269520857400494e-01 1.39228951565960601399751794815529e-02 1.38710855074681057436114528513826e-02
 	 2.65789822784589513382513814576669e-01 7.15527432866567836278193226462463e-01 1.86827443488426503392929589608684e-02 1.64952060270591380208848875099648e-02
 	 1.14679053160904209640591489005601e-01 8.62793031223432205223389246384613e-01 2.25279156156635851360192646097858e-02 1.43092875581922445576976699044280e-02
 	 2.24793864387125008619250365882181e-02 9.52646581185226826171685843291925e-01 2.48740323760606729663891201198567e-02 7.24693215945156413160255226557638e-03
 	 9.43737439463077865120510523411212e-01 4.89915018783618969044901803044922e-02 7.27105865856023797499929628429527e-03 1.45848522130312494710091542060582e-03
 	 8.19759308263107611125519724737387e-01 1.56947392786902617523026037815725e-01 2.32932989499897713514542374468874e-02 7.66626514696934577980380609574240e-03
 	 6.47375282886830327733207468554610e-01 3.07053470832874708662529883440584e-01 4.55712462802949636042626480048057e-02 1.85681575137770851768870272735512e-02
 	 4.52846373669444579590503963117953e-01 4.76442551784230117206675458874088e-01 7.07110745463253032028205780079588e-02 2.99634584387787894499410867865663e-02
 	 2.65789822784589513382513814576669e-01 6.39324960202547587506671789014945e-01 9.48852170128628991108143964083865e-02 3.56319208013516283695132358388946e-02
 	 1.14679053160904209640591489005601e-01 7.70907019092334389043230657989625e-01 1.14413927746761401316177853004774e-01 3.09100353254680992876046730089001e-02
 	 2.24793864387125008619250365882181e-02 8.51191316541618170354865924309706e-01 1.26329297019669328783209039102076e-01 1.56543732969901920604183231944262e-02
 	 9.43737439463077754098208060895558e-01 3.95482239674546792729259436782741e-02 1.67143365694675666288659954261675e-02 1.99100018324992449753052525807107e-03
 	 8.19759308263107611125519724737387e-01 1.26695251279609177874618808345986e-01 5.35454404572832109998614669166273e-02 1.04653342313752346914856872217570e-02
 	 6.47375282886830327733207468554610e-01 2.47867874404687937861524460458895e-01 1.04756842708481734405268070986494e-01 2.53476720041855875520386831567521e-02
 	 4.52846373669444579590503963117953e-01 3.84606636317685768311491756321630e-01 1.62546990012869652098004280560417e-01 4.09035692450195748071095636078098e-02
 	 2.65789822784589402360211352061015e-01 5.16092908865112276473041674762499e-01 2.18117268350298321166746973176487e-01 4.86416727497942791291762887340155e-02
 	 1.14679053160904209640591489005601e-01 6.22312080263294653548200585646555e-01 2.63008866575801136811207925347844e-01 4.21957556363048297276563403102045e-02
 	 2.24793864387125008619250365882181e-02 6.87121307473297249224231109110406e-01 2.90399306087990249913843854301376e-01 2.13700212026299400658313487610940e-02
 	 9.43737439463077754098208060895558e-01 2.81312802684610882564264500160789e-02 2.81312802684611576453654890883627e-02 2.17939056966316583099918524624172e-03
 	 8.19759308263107611125519724737387e-01 9.01203458684462083150279454457632e-02 9.01203458684461805594523298168497e-02 1.14555744013054537633333751500686e-02
 	 6.47375282886830327733207468554610e-01 1.76312358556584808377820650093781e-01 1.76312358556584863888971881351608e-01 2.77460935431278546414723962243443e-02
 	 4.52846373669444524079352731860126e-01 2.73576813165277654693596787183196e-01 2.73576813165277765715899249698850e-01 4.47739050092140836167864392791671e-02
 	 2.65789822784589513382513814576669e-01 3.67105088607705187797591861453839e-01 3.67105088607705298819894323969493e-01 5.32441954427667757387965252746653e-02
 	 1.14679053160904154129440257747774e-01 4.42660473419547784157401792981545e-01 4.42660473419548117224309180528508e-01 4.61883593418185578460821716362261e-02
 	 2.24793864387125008619250365882181e-02 4.88760306780643638546735019190237e-01 4.88760306780643860591339944221545e-01 2.33920735288387152128741774959053e-02
 	 9.43737439463077754098208060895558e-01 1.67143365694675180566086680755689e-02 3.95482239674547278451832710288727e-02 1.99100018324992406384965626386929e-03
 	 8.19759308263107611125519724737387e-01 5.35454404572832942665883138033678e-02 1.26695251279609094607891961459245e-01 1.04653342313752329567622112449499e-02
 	 6.47375282886830327733207468554610e-01 1.04756842708481762160843686615408e-01 2.47867874404687910105948844829982e-01 2.53476720041855806131447792495237e-02
 	 4.52846373669444635101655194375780e-01 1.62546990012869707609155511818244e-01 3.84606636317685712800340525063802e-01 4.09035692450195609293217557933531e-02
 	 2.65789822784589513382513814576669e-01 2.18117268350298321166746973176487e-01 5.16092908865112165450739212246845e-01 4.86416727497942652513884809195588e-02
 	 1.14679053160904209640591489005601e-01 2.63008866575801247833510387863498e-01 6.22312080263294542525898123130901e-01 4.21957556363048158498685324957478e-02
 	 2.24793864387125008619250365882181e-02 2.90399306087990360936146316817030e-01 6.87121307473297138201928646594752e-01 2.13700212026299331269374448538656e-02
 	 9.43737439463077865120510523411212e-01 7.27105865856028654725662363489391e-03 4.89915018783618483322328529538936e-02 1.45848522130312256185613595249606e-03
 	 8.19759308263107611125519724737387e-01 2.32932989499897991070298530758009e-02 1.56947392786902589767450422186812e-01 7.66626514696933363673947425809274e-03
 	 6.47375282886830327733207468554610e-01 4.55712462802949636042626480048057e-02 3.07053470832874708662529883440584e-01 1.85681575137770539518644596910235e-02
 	 4.52846373669444579590503963117953e-01 7.07110745463253032028205780079588e-02 4.76442551784230117206675458874088e-01 2.99634584387787408776837594359677e-02
 	 2.65789822784589513382513814576669e-01 9.48852170128627880885119338927325e-02 6.39324960202547698528974251530599e-01 3.56319208013515728583620045810676e-02
 	 1.14679053160904209640591489005601e-01 1.14413927746761290293875390489120e-01 7.70907019092334500065533120505279e-01 3.09100353254680472459003937046873e-02
 	 2.24793864387125008619250365882181e-02 1.26329297019669217760906576586422e-01 8.51191316541618281377168386825360e-01 1.56543732969901677742896595191269e-02
 	 9.43737439463077754098208060895558e-01 1.43165958133294884957464887520473e-03 5.48309009555892970522172902292368e-02 6.75181513422745465877183868030897e-04
 	 8.19759308263107611125519724737387e-01 4.58641254163788536502011083939578e-03 1.75654279195254503509460164423217e-01 3.54897014287608491070469263206633e-03
 	 6.47375282886830327733207468554610e-01 8.97290400671668653131973769632168e-03 3.43651813106452985735472793749068e-01 8.59582017596483179133759477963395e-03
 	 4.52846373669444579590503963117953e-01 1.39228951565960601399751794815529e-02 5.33230731173959360269520857400494e-01 1.38710855074681126825053567586110e-02
 	 2.65789822784589513382513814576669e-01 1.86827443488427613615954214765225e-02 7.15527432866567725255890763946809e-01 1.64952060270591449597787914171931e-02
 	 1.14679053160904209640591489005601e-01 2.25279156156635851360192646097858e-02 8.62793031223432205223389246384613e-01 1.43092875581922497618680978348493e-02
 	 2.24793864387125008619250365882181e-02 2.48740323760606729663891201198567e-02 9.52646581185226826171685843291925e-01 7.24693215945156673368776623078702e-03
 	 ];
 
 	 case  14 

 	 % ALG. DEG.:   14
 	 % PTS CARD.:   64
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 9.55366044710030171138726018398302e-01 4.37477449051462061180295393114648e-02 8.86210384823622743244442290233565e-04 3.33567406495419410249886338348801e-04
 	 8.55633742957854437349851650651544e-01 1.41499854650116940746329419198446e-01 2.86640239202862190381893015000969e-03 1.80621091903714514788348299845211e-03
 	 7.13175242855569546662763968924992e-01 2.81129831011298236820294960125466e-01 5.69492613313221651694107094954234e-03 4.59975580349140933389406882270123e-03
 	 5.45186684803426580003815615782514e-01 4.45782964189929742371276688572834e-01 9.03035100664367762490769564465154e-03 8.01725953139149558057674482824950e-03
 	 3.71932164583272273361558291071560e-01 6.15597503479887731003827866516076e-01 1.24703319368399956346138424123637e-02 1.07350189731585821811821190863157e-02
 	 2.14308479395630691044516424881294e-01 7.70091559088435184676768585632090e-01 1.55999615159341242787149894866161e-02 1.13887974046164956731796991107331e-02
 	 9.13236078997941014279149385401979e-02 8.90634557136405824451230728300288e-01 1.80418349638000741208543331595138e-02 9.22384539091830428503282490737547e-03
 	 1.77799151473633232356519329186995e-02 9.62718034592386584513690195308300e-01 1.95020502602500922506578717730008e-02 4.50981271607919873695147217063095e-03
 	 9.55366044710030171138726018398302e-01 4.00961656119337012116332630284887e-02 4.53778967803612764964071857320960e-03 7.32788081649194626004950592346177e-04
 	 8.55633742957854548372154113167198e-01 1.29689007248650872705653114280722e-01 1.46772497934945789221927725520800e-02 3.96792315028906671797725991268635e-03
 	 7.13175242855569435640461506409338e-01 2.57664213026851496302072064281674e-01 2.91605441175790680574664293089882e-02 1.01048428763123362278397721070178e-02
 	 5.45186684803426691026118078298168e-01 4.08573918447520445518250653549330e-01 4.62393967490528634556312681525014e-02 1.76124888633949032434866666108064e-02
 	 3.71932164583272273361558291071560e-01 5.64214212717486840453773311310215e-01 6.38536226992408861846683976182248e-02 2.35829214924108826467730182230298e-02
 	 2.14308479395630691044516424881294e-01 7.05812808329004059970657181111164e-01 7.98787122753652489848263940075412e-02 2.50191560683398206421657050668728e-02
 	 9.13236078997941014279149385401979e-02 8.16294206251800158469222878920846e-01 9.23821858484057401028621825389564e-02 2.02631427346382751719655601618797e-02
 	 1.77799151473633232356519329186995e-02 8.82360949948550188359774892887799e-01 9.98591349040864884045731741935015e-02 9.90725395965268325337849120160172e-03
 	 9.55366044710030171138726018398302e-01 3.40452726888026829810129925135698e-02 1.05886826011671458802609890881286e-02 1.03372345487339097058754333602337e-03
 	 8.55633742957854437349851650651544e-01 1.10117702008052237294677411227894e-01 3.42485550340933253554709381205612e-02 5.59743714493508154328438308766636e-03
 	 7.13175242855569435640461506409338e-01 2.18780231495104532379869510805293e-01 6.80445256493260319796689827853697e-02 1.42546165127927886018266434575708e-02
 	 5.45186684803426691026118078298168e-01 3.46916226396931759445863008295419e-01 1.07897088799641549528018913406413e-01 2.48454407116075540185029524309357e-02
 	 3.71932164583272273361558291071560e-01 4.79068919277106597398585563496454e-01 1.48998916139621129239856145431986e-01 3.32677614328523302278384221608576e-02
 	 2.14308479395630691044516424881294e-01 5.99298939439204425561058542371029e-01 1.86392581165164883394425032747677e-01 3.52938169938223147981126714967104e-02
 	 9.13236078997941014279149385401979e-02 6.93107643137351292494940935284831e-01 2.15568748962854606077144126174971e-01 2.85846432806348138555563309637364e-02
 	 1.77799151473634342579543954343535e-02 7.49204286556732101942657209292520e-01 2.33015798295904463799388395273127e-01 1.39758834074256519525158992678371e-02
 	 9.55366044710030171138726018398302e-01 2.64106844608761291703924456442110e-02 1.82232708290936996908815359574874e-02 1.19511249923079550250282210299702e-03
 	 8.55633742957854437349851650651544e-01 8.54240148955532629937437150147161e-02 5.89422421465922996564046343337395e-02 6.47133144172488961043399058326031e-03
 	 7.13175242855569435640461506409338e-01 1.69719176965060364326021158376534e-01 1.17105580179370200033517335214128e-01 1.64801043121023983728523631953067e-02
 	 5.45186684803426802048420540813822e-01 2.69120916535958987214627313733217e-01 1.85692398660614210736952145452960e-01 2.87244103859253460675482472197473e-02
 	 3.71932164583272328872709522329387e-01 3.71638617134705862010690680108382e-01 2.56429218282021864627751028820057e-01 3.84616575375080552157136537516635e-02
 	 2.14308479395630635533365193623467e-01 4.64907281899147595272125954579678e-01 3.20784238705221713683357620539027e-01 4.08040290041087189143453883843904e-02
 	 9.13236078997941014279149385401979e-02 5.37679560614672036322758685855661e-01 3.70996831485533862249326375604142e-01 3.30473922301824374336831624532351e-02
 	 1.77799151473632122133494704030454e-02 5.81196637484813427576568756194320e-01 4.01023447367823360210081773402635e-01 1.61578542783982863351166514576107e-02
 	 9.55366044710030171138726018398302e-01 1.82232708290936962214345840038732e-02 2.64106844608761326398393975978252e-02 1.19511249923079571934325660009790e-03
 	 8.55633742957854437349851650651544e-01 5.89422421465922302674655952614557e-02 8.54240148955533323826827540869999e-02 6.47133144172489047779572857166386e-03
 	 7.13175242855569546662763968924992e-01 1.17105580179370172277941719585215e-01 1.69719176965060281059294311489793e-01 1.64801043121023983728523631953067e-02
 	 5.45186684803426691026118078298168e-01 1.85692398660614266248103376710787e-01 2.69120916535959042725778544991044e-01 2.87244103859253495369951991733615e-02
 	 3.71932164583272273361558291071560e-01 2.56429218282021809116599797562230e-01 3.71638617134705917521841911366209e-01 3.84616575375080621546075576588919e-02
 	 2.14308479395630691044516424881294e-01 3.20784238705221658172206389281200e-01 4.64907281899147650783277185837505e-01 4.08040290041087258532392922916188e-02
 	 9.13236078997941014279149385401979e-02 3.70996831485533862249326375604142e-01 5.37679560614672036322758685855661e-01 3.30473922301824374336831624532351e-02
 	 1.77799151473633232356519329186995e-02 4.01023447367823138165476848371327e-01 5.81196637484813538598871218709974e-01 1.61578542783982898045636034112249e-02
 	 9.55366044710030171138726018398302e-01 1.05886826011671528191548929953569e-02 3.40452726888026760421190886063414e-02 1.03372345487338793482146037661096e-03
 	 8.55633742957854437349851650651544e-01 3.42485550340932837221075146771909e-02 1.10117702008052278928040834671265e-01 5.59743714493506593077309929640251e-03
 	 7.13175242855569435640461506409338e-01 6.80445256493260874908202140431968e-02 2.18780231495104476868718279547465e-01 1.42546165127927469684632200142005e-02
 	 5.45186684803426802048420540813822e-01 1.07897088799641605039170144664240e-01 3.46916226396931592912409314521938e-01 2.48454407116074811601169614050377e-02
 	 3.71932164583272273361558291071560e-01 1.48998916139621240262158607947640e-01 4.79068919277106486376283100980800e-01 3.32677614328522330833237674596603e-02
 	 2.14308479395630691044516424881294e-01 1.86392581165164994416727495263331e-01 5.99298939439204314538756079855375e-01 3.52938169938222176535980167955131e-02
 	 9.13236078997941014279149385401979e-02 2.15568748962854828121749051206280e-01 6.93107643137351070450336010253523e-01 2.85846432806347340582764360306101e-02
 	 1.77799151473633232356519329186995e-02 2.33015798295904685843993320304435e-01 7.49204286556731990920354746776866e-01 1.39758834074256120538759518012739e-02
 	 9.55366044710030171138726018398302e-01 4.53778967803612071074681466598122e-03 4.00961656119337081505271669357171e-02 7.32788081649194626004950592346177e-04
 	 8.55633742957854437349851650651544e-01 1.46772497934946066777683881809935e-02 1.29689007248650955972379961167462e-01 3.96792315028906671797725991268635e-03
 	 7.13175242855569324618159043893684e-01 2.91605441175790125463151980511611e-02 2.57664213026851662835525758055155e-01 1.01048428763123362278397721070178e-02
 	 5.45186684803426580003815615782514e-01 4.62393967490528079444800368946744e-02 4.08573918447520612051704347322811e-01 1.76124888633949032434866666108064e-02
 	 3.71932164583272273361558291071560e-01 6.38536226992407751623659351025708e-02 5.64214212717486951476075773825869e-01 2.35829214924108826467730182230298e-02
 	 2.14308479395630691044516424881294e-01 7.98787122753651379625239314918872e-02 7.05812808329004170992959643626818e-01 2.50191560683398206421657050668728e-02
 	 9.13236078997941014279149385401979e-02 9.23821858484056290805597200233024e-02 8.16294206251800269491525341436500e-01 2.02631427346382751719655601618797e-02
 	 1.77799151473633232356519329186995e-02 9.98591349040863773822707116778474e-02 8.82360949948550299382077355403453e-01 9.90725395965268325337849120160172e-03
 	 9.55366044710030171138726018398302e-01 8.86210384823622743244442290233565e-04 4.37477449051462061180295393114648e-02 3.33567406495418597098256974220476e-04
 	 8.55633742957854437349851650651544e-01 2.86640239202856639266769889218267e-03 1.41499854650116996257480650456273e-01 1.80621091903714081107479305643437e-03
 	 7.13175242855569546662763968924992e-01 5.69492613313232753924353346519638e-03 2.81129831011298125797992497609812e-01 4.59975580349139805819147497345512e-03
 	 5.45186684803426580003815615782514e-01 9.03035100664356660260523312899750e-03 4.45782964189929853393579151088488e-01 8.01725953139147476389503310656437e-03
 	 3.71932164583272273361558291071560e-01 1.24703319368399956346138424123637e-02 6.15597503479887731003827866516076e-01 1.07350189731585544256065034574021e-02
 	 2.14308479395630691044516424881294e-01 1.55999615159341242787149894866161e-02 7.70091559088435184676768585632090e-01 1.13887974046164679176040834818195e-02
 	 9.13236078997941014279149385401979e-02 1.80418349638000741208543331595138e-02 8.90634557136405824451230728300288e-01 9.22384539091828173362763720888324e-03
 	 1.77799151473633232356519329186995e-02 1.95020502602500922506578717730008e-02 9.62718034592386584513690195308300e-01 4.50981271607918746124887832138484e-03
 	 ];
 
 	 case  15 

 	 % ALG. DEG.:   15
 	 % PTS CARD.:   64
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 9.55366044710030171138726018398302e-01 4.37477449051462061180295393114648e-02 8.86210384823622743244442290233565e-04 3.33567406495419410249886338348801e-04
 	 8.55633742957854437349851650651544e-01 1.41499854650116940746329419198446e-01 2.86640239202862190381893015000969e-03 1.80621091903714514788348299845211e-03
 	 7.13175242855569546662763968924992e-01 2.81129831011298236820294960125466e-01 5.69492613313221651694107094954234e-03 4.59975580349140933389406882270123e-03
 	 5.45186684803426580003815615782514e-01 4.45782964189929742371276688572834e-01 9.03035100664367762490769564465154e-03 8.01725953139149558057674482824950e-03
 	 3.71932164583272273361558291071560e-01 6.15597503479887731003827866516076e-01 1.24703319368399956346138424123637e-02 1.07350189731585821811821190863157e-02
 	 2.14308479395630691044516424881294e-01 7.70091559088435184676768585632090e-01 1.55999615159341242787149894866161e-02 1.13887974046164956731796991107331e-02
 	 9.13236078997941014279149385401979e-02 8.90634557136405824451230728300288e-01 1.80418349638000741208543331595138e-02 9.22384539091830428503282490737547e-03
 	 1.77799151473633232356519329186995e-02 9.62718034592386584513690195308300e-01 1.95020502602500922506578717730008e-02 4.50981271607919873695147217063095e-03
 	 9.55366044710030171138726018398302e-01 4.00961656119337012116332630284887e-02 4.53778967803612764964071857320960e-03 7.32788081649194626004950592346177e-04
 	 8.55633742957854548372154113167198e-01 1.29689007248650872705653114280722e-01 1.46772497934945789221927725520800e-02 3.96792315028906671797725991268635e-03
 	 7.13175242855569435640461506409338e-01 2.57664213026851496302072064281674e-01 2.91605441175790680574664293089882e-02 1.01048428763123362278397721070178e-02
 	 5.45186684803426691026118078298168e-01 4.08573918447520445518250653549330e-01 4.62393967490528634556312681525014e-02 1.76124888633949032434866666108064e-02
 	 3.71932164583272273361558291071560e-01 5.64214212717486840453773311310215e-01 6.38536226992408861846683976182248e-02 2.35829214924108826467730182230298e-02
 	 2.14308479395630691044516424881294e-01 7.05812808329004059970657181111164e-01 7.98787122753652489848263940075412e-02 2.50191560683398206421657050668728e-02
 	 9.13236078997941014279149385401979e-02 8.16294206251800158469222878920846e-01 9.23821858484057401028621825389564e-02 2.02631427346382751719655601618797e-02
 	 1.77799151473633232356519329186995e-02 8.82360949948550188359774892887799e-01 9.98591349040864884045731741935015e-02 9.90725395965268325337849120160172e-03
 	 9.55366044710030171138726018398302e-01 3.40452726888026829810129925135698e-02 1.05886826011671458802609890881286e-02 1.03372345487339097058754333602337e-03
 	 8.55633742957854437349851650651544e-01 1.10117702008052237294677411227894e-01 3.42485550340933253554709381205612e-02 5.59743714493508154328438308766636e-03
 	 7.13175242855569435640461506409338e-01 2.18780231495104532379869510805293e-01 6.80445256493260319796689827853697e-02 1.42546165127927886018266434575708e-02
 	 5.45186684803426691026118078298168e-01 3.46916226396931759445863008295419e-01 1.07897088799641549528018913406413e-01 2.48454407116075540185029524309357e-02
 	 3.71932164583272273361558291071560e-01 4.79068919277106597398585563496454e-01 1.48998916139621129239856145431986e-01 3.32677614328523302278384221608576e-02
 	 2.14308479395630691044516424881294e-01 5.99298939439204425561058542371029e-01 1.86392581165164883394425032747677e-01 3.52938169938223147981126714967104e-02
 	 9.13236078997941014279149385401979e-02 6.93107643137351292494940935284831e-01 2.15568748962854606077144126174971e-01 2.85846432806348138555563309637364e-02
 	 1.77799151473634342579543954343535e-02 7.49204286556732101942657209292520e-01 2.33015798295904463799388395273127e-01 1.39758834074256519525158992678371e-02
 	 9.55366044710030171138726018398302e-01 2.64106844608761291703924456442110e-02 1.82232708290936996908815359574874e-02 1.19511249923079550250282210299702e-03
 	 8.55633742957854437349851650651544e-01 8.54240148955532629937437150147161e-02 5.89422421465922996564046343337395e-02 6.47133144172488961043399058326031e-03
 	 7.13175242855569435640461506409338e-01 1.69719176965060364326021158376534e-01 1.17105580179370200033517335214128e-01 1.64801043121023983728523631953067e-02
 	 5.45186684803426802048420540813822e-01 2.69120916535958987214627313733217e-01 1.85692398660614210736952145452960e-01 2.87244103859253460675482472197473e-02
 	 3.71932164583272328872709522329387e-01 3.71638617134705862010690680108382e-01 2.56429218282021864627751028820057e-01 3.84616575375080552157136537516635e-02
 	 2.14308479395630635533365193623467e-01 4.64907281899147595272125954579678e-01 3.20784238705221713683357620539027e-01 4.08040290041087189143453883843904e-02
 	 9.13236078997941014279149385401979e-02 5.37679560614672036322758685855661e-01 3.70996831485533862249326375604142e-01 3.30473922301824374336831624532351e-02
 	 1.77799151473632122133494704030454e-02 5.81196637484813427576568756194320e-01 4.01023447367823360210081773402635e-01 1.61578542783982863351166514576107e-02
 	 9.55366044710030171138726018398302e-01 1.82232708290936962214345840038732e-02 2.64106844608761326398393975978252e-02 1.19511249923079571934325660009790e-03
 	 8.55633742957854437349851650651544e-01 5.89422421465922302674655952614557e-02 8.54240148955533323826827540869999e-02 6.47133144172489047779572857166386e-03
 	 7.13175242855569546662763968924992e-01 1.17105580179370172277941719585215e-01 1.69719176965060281059294311489793e-01 1.64801043121023983728523631953067e-02
 	 5.45186684803426691026118078298168e-01 1.85692398660614266248103376710787e-01 2.69120916535959042725778544991044e-01 2.87244103859253495369951991733615e-02
 	 3.71932164583272273361558291071560e-01 2.56429218282021809116599797562230e-01 3.71638617134705917521841911366209e-01 3.84616575375080621546075576588919e-02
 	 2.14308479395630691044516424881294e-01 3.20784238705221658172206389281200e-01 4.64907281899147650783277185837505e-01 4.08040290041087258532392922916188e-02
 	 9.13236078997941014279149385401979e-02 3.70996831485533862249326375604142e-01 5.37679560614672036322758685855661e-01 3.30473922301824374336831624532351e-02
 	 1.77799151473633232356519329186995e-02 4.01023447367823138165476848371327e-01 5.81196637484813538598871218709974e-01 1.61578542783982898045636034112249e-02
 	 9.55366044710030171138726018398302e-01 1.05886826011671528191548929953569e-02 3.40452726888026760421190886063414e-02 1.03372345487338793482146037661096e-03
 	 8.55633742957854437349851650651544e-01 3.42485550340932837221075146771909e-02 1.10117702008052278928040834671265e-01 5.59743714493506593077309929640251e-03
 	 7.13175242855569435640461506409338e-01 6.80445256493260874908202140431968e-02 2.18780231495104476868718279547465e-01 1.42546165127927469684632200142005e-02
 	 5.45186684803426802048420540813822e-01 1.07897088799641605039170144664240e-01 3.46916226396931592912409314521938e-01 2.48454407116074811601169614050377e-02
 	 3.71932164583272273361558291071560e-01 1.48998916139621240262158607947640e-01 4.79068919277106486376283100980800e-01 3.32677614328522330833237674596603e-02
 	 2.14308479395630691044516424881294e-01 1.86392581165164994416727495263331e-01 5.99298939439204314538756079855375e-01 3.52938169938222176535980167955131e-02
 	 9.13236078997941014279149385401979e-02 2.15568748962854828121749051206280e-01 6.93107643137351070450336010253523e-01 2.85846432806347340582764360306101e-02
 	 1.77799151473633232356519329186995e-02 2.33015798295904685843993320304435e-01 7.49204286556731990920354746776866e-01 1.39758834074256120538759518012739e-02
 	 9.55366044710030171138726018398302e-01 4.53778967803612071074681466598122e-03 4.00961656119337081505271669357171e-02 7.32788081649194626004950592346177e-04
 	 8.55633742957854437349851650651544e-01 1.46772497934946066777683881809935e-02 1.29689007248650955972379961167462e-01 3.96792315028906671797725991268635e-03
 	 7.13175242855569324618159043893684e-01 2.91605441175790125463151980511611e-02 2.57664213026851662835525758055155e-01 1.01048428763123362278397721070178e-02
 	 5.45186684803426580003815615782514e-01 4.62393967490528079444800368946744e-02 4.08573918447520612051704347322811e-01 1.76124888633949032434866666108064e-02
 	 3.71932164583272273361558291071560e-01 6.38536226992407751623659351025708e-02 5.64214212717486951476075773825869e-01 2.35829214924108826467730182230298e-02
 	 2.14308479395630691044516424881294e-01 7.98787122753651379625239314918872e-02 7.05812808329004170992959643626818e-01 2.50191560683398206421657050668728e-02
 	 9.13236078997941014279149385401979e-02 9.23821858484056290805597200233024e-02 8.16294206251800269491525341436500e-01 2.02631427346382751719655601618797e-02
 	 1.77799151473633232356519329186995e-02 9.98591349040863773822707116778474e-02 8.82360949948550299382077355403453e-01 9.90725395965268325337849120160172e-03
 	 9.55366044710030171138726018398302e-01 8.86210384823622743244442290233565e-04 4.37477449051462061180295393114648e-02 3.33567406495418597098256974220476e-04
 	 8.55633742957854437349851650651544e-01 2.86640239202856639266769889218267e-03 1.41499854650116996257480650456273e-01 1.80621091903714081107479305643437e-03
 	 7.13175242855569546662763968924992e-01 5.69492613313232753924353346519638e-03 2.81129831011298125797992497609812e-01 4.59975580349139805819147497345512e-03
 	 5.45186684803426580003815615782514e-01 9.03035100664356660260523312899750e-03 4.45782964189929853393579151088488e-01 8.01725953139147476389503310656437e-03
 	 3.71932164583272273361558291071560e-01 1.24703319368399956346138424123637e-02 6.15597503479887731003827866516076e-01 1.07350189731585544256065034574021e-02
 	 2.14308479395630691044516424881294e-01 1.55999615159341242787149894866161e-02 7.70091559088435184676768585632090e-01 1.13887974046164679176040834818195e-02
 	 9.13236078997941014279149385401979e-02 1.80418349638000741208543331595138e-02 8.90634557136405824451230728300288e-01 9.22384539091828173362763720888324e-03
 	 1.77799151473633232356519329186995e-02 1.95020502602500922506578717730008e-02 9.62718034592386584513690195308300e-01 4.50981271607918746124887832138484e-03
 	 ];
 
 	 case  16 

 	 % ALG. DEG.:   16
 	 % PTS CARD.:   81
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 9.63742187116790494094686891912716e-01 3.56805928441202152567868211008317e-02 5.77220039089290648526286986452760e-04 1.77247013006332588885491374774972e-04
 	 8.81921021210001376822162910684710e-01 1.16199175588069802955715204006992e-01 1.87980320192882022212188530829735e-03 9.80169471883893207372895339801744e-04
 	 7.62823015185039587926496551517630e-01 2.33401155619554573350526993635867e-01 3.77582919540583872297645484650275e-03 2.58491741363445822615707569980259e-03
 	 6.18117234695294004431787016073940e-01 3.75803237412972390707466274761828e-01 6.07952789173360486074670916423202e-03 4.74652142719937924358886149889258e-03
 	 4.61970401081011061705794418230653e-01 5.29464232135294698977645566628780e-01 8.56536678369423931656001514056697e-03 6.85617101115470681249597362239001e-03
 	 3.09667579927637937053930272668367e-01 6.79342410614749758757113795581972e-01 1.09900094576123041889559317496605e-02 8.15253711446882467495100854648626e-03
 	 1.76116656162995433021478675073013e-01 8.10767219666291505397737182647688e-01 1.31161241707130615807841422792990e-02 8.00826962803442496396932881452813e-03
 	 7.43873897091960056826565050869249e-02 9.10876968380613938336409773910418e-01 1.47356419101900559809337210026570e-02 6.18288855407136007241719610760811e-03
 	 1.44124096488764674717231173417531e-02 9.69897153940605827315835085755680e-01 1.56904364105177052124417969025671e-02 2.94847254733360568043631921852921e-03
 	 9.63742187116790494094686891912716e-01 3.32852361686006084640077062886121e-02 2.97257671460889744130540179867239e-03 3.93966014801657501021719953726574e-04
 	 8.81921021210001265799860448169056e-01 1.08398339089899764520197322781314e-01 9.68063970009896967994222904962953e-03 2.17861759201858290815878582691312e-03
 	 7.62823015185039587926496551517630e-01 2.17732161031102239290291322504345e-01 1.94448237838581727832121259780251e-02 5.74548250358719158475961918952635e-03
 	 6.18117234695293893409484553558286e-01 3.50574318225678582816584594183951e-01 3.13084470790275237739308522577630e-02 1.05500685124527652375414632501816e-02
 	 4.61970401081011061705794418230653e-01 4.93919540138868518042158939351793e-01 4.41100587801204202520466424175538e-02 1.52391756805897050225384603550083e-02
 	 3.09667579927637937053930272668367e-01 6.33735898824467680512384504254442e-01 5.65965212478943824336852230771910e-02 1.81206018822733933015811658151506e-02
 	 1.76116656162995433021478675073013e-01 7.56337724046513448783457533863839e-01 6.75456197904911181950637910631485e-02 1.77999392898155923969927272310088e-02
 	 7.43873897091960056826565050869249e-02 8.49726772913861339020513696596026e-01 7.58858373769426552968297983170487e-02 1.37426742617278961622329092051586e-02
 	 1.44124096488764674717231173417531e-02 9.04784737439882080778374984220136e-01 8.08028529112414517499018984381109e-02 6.55355461016209756008876752275683e-03
 	 9.63742187116790494094686891912716e-01 2.92486597589868627111719945332879e-02 7.00915312422264319414111355399655e-03 5.68352077771648979756524688866648e-04
 	 8.81921021210001376822162910684710e-01 9.52526255911213398652748196582252e-02 2.28263531988772833125622696570645e-02 3.14296611528030404164590905224941e-03
 	 7.62823015185039698948799014033284e-01 1.91327285897259391500568881383515e-01 4.58496989177009095506321045832010e-02 8.28867667775463543011760236822738e-03
 	 6.18117234695293893409484553558286e-01 3.08059372091658401071612161103985e-01 7.38233932130477055189032853377284e-02 1.52199761766368298065987829659207e-02
 	 4.61970401081011117216945649488480e-01 4.34020792421626555590563611985999e-01 1.04008806497362382703641969783348e-01 2.19846810033876606527147856695592e-02
 	 3.09667579927637826031627810152713e-01 5.56881302805906308606154198059812e-01 1.33451117266455865362217991787475e-01 2.61415486192328495873571370111677e-02
 	 1.76116656162995433021478675073013e-01 6.64614925412230550527681316452799e-01 1.59268418424774016450840008474188e-01 2.56789471667223066775331830058349e-02
 	 7.43873897091960056826565050869249e-02 7.46678471595303760999229325534543e-01 1.78934138695500233318114169378532e-01 1.98257646023713603178340036947702e-02
 	 1.44124096488764674717231173417531e-02 7.95059431348357326108100551209645e-01 1.90528159002766206420176331448602e-01 9.45443576231014271016306338424329e-03
 	 9.63742187116790383072384429397061e-01 2.40072664178624939346207156631863e-02 1.22505464653471229929948549397523e-02 6.81181212712447044406449681019922e-04
 	 8.81921021210001376822162910684710e-01 7.81832459473407181960169509693515e-02 3.98957328426579049818201383459382e-02 3.76690708744262421625581538364713e-03
 	 7.62823015185039698948799014033284e-01 1.57041217046902270570996051901602e-01 8.01357677680580304802049340651138e-02 9.93414302850978772618795176185813e-03
 	 6.18117234695294004431787016073940e-01 2.52854779646835114981229253316997e-01 1.29027985657870880586983730609063e-01 1.82414426460872011737102127426624e-02
 	 4.61970401081011061705794418230653e-01 3.56243769130524690069705684436485e-01 1.81785829788464248224499897332862e-01 2.63490752522606980212671601293550e-02
 	 3.09667579927637937053930272668367e-01 4.57087535283730916901845375832636e-01 2.33244884788631146044224351498997e-01 3.13311633529119101804205627104238e-02
 	 1.76116656162995433021478675073013e-01 5.45515169280765377379793790169060e-01 2.78368174556239189598727534757927e-01 3.07767263573454422087571913380089e-02
 	 7.43873897091960056826565050869249e-02 6.12872833961666474422713690728415e-01 3.12739776329137519894629804184660e-01 2.37615712213878928216193031630610e-02
 	 1.44124096488764674717231173417531e-02 6.52583870293393153438898934837198e-01 3.33003720057730379089377947821049e-01 1.13313283613434272883990772129437e-02
 	 9.63742187116790383072384429397061e-01 1.81289064416047807082321696725558e-02 1.81289064416048362193834009303828e-02 7.20201534962096822332922041454140e-04
 	 8.81921021210001487844465373200364e-01 5.90394893949993115889185446576448e-02 5.90394893949992005666160821419908e-02 3.98268803631995123998299490608588e-03
 	 7.62823015185039476904194089001976e-01 1.18588492407480206036751724241185e-01 1.18588492407480317059054186756839e-01 1.05032037351358784049715211494913e-02
 	 6.18117234695294115454089478589594e-01 1.90941382652352997784106491963030e-01 1.90941382652352886761804029447376e-01 1.92863730655779379297154463301922e-02
 	 4.61970401081011061705794418230653e-01 2.69014799459494469147102790884674e-01 2.69014799459494469147102790884674e-01 2.78584377950551707880944007911239e-02
 	 3.09667579927637992565081503926194e-01 3.45166210036181031473034863665816e-01 3.45166210036180920450732401150162e-01 3.31259164489623170180010447438690e-02
 	 1.76116656162995433021478675073013e-01 4.11941671918502283489260662463494e-01 4.11941671918502283489260662463494e-01 3.25397194608558620876337386107480e-02
 	 7.43873897091960056826565050869249e-02 4.62806305145401997158671747456538e-01 4.62806305145401997158671747456538e-01 2.51227129394991886834898053848519e-02
 	 1.44124096488764674717231173417531e-02 4.92793795175561766264138441329123e-01 4.92793795175561766264138441329123e-01 1.19804244842614034810557299692846e-02
 	 9.63742187116790383072384429397061e-01 1.22505464653470674818436236819252e-02 2.40072664178625494457719469210133e-02 6.81181212712446610725580686818148e-04
 	 8.81921021210001376822162910684710e-01 3.98957328426579188596079461603949e-02 7.81832459473407043182291431548947e-02 3.76690708744262118048973242423472e-03
 	 7.62823015185039587926496551517630e-01 8.01357677680581692580830122096813e-02 1.57041217046902242815420436272689e-01 9.93414302850978078729404785462975e-03
 	 6.18117234695294004431787016073940e-01 1.29027985657870880586983730609063e-01 2.52854779646835114981229253316997e-01 1.82414426460871907653693568818198e-02
 	 4.61970401081011006194643186972826e-01 1.81785829788464303735651128590689e-01 3.56243769130524634558554453178658e-01 2.63490752522606806740324003612841e-02
 	 3.09667579927637881542779041410540e-01 2.33244884788631201555375582756824e-01 4.57087535283730972412996607090463e-01 3.13311633529118824248449470815103e-02
 	 1.76116656162995433021478675073013e-01 2.78368174556239300621029997273581e-01 5.45515169280765266357491327653406e-01 3.07767263573454213920754796163237e-02
 	 7.43873897091960056826565050869249e-02 3.12739776329137630916932266700314e-01 6.12872833961666363400411228212761e-01 2.37615712213878754743845433949900e-02
 	 1.44124096488764674717231173417531e-02 3.33003720057730490111680410336703e-01 6.52583870293393042416596472321544e-01 1.13313283613434186147816973289082e-02
 	 9.63742187116790494094686891912716e-01 7.00915312422269176639844090459519e-03 2.92486597589868141389146671826893e-02 5.68352077771648329235221197563988e-04
 	 8.81921021210001376822162910684710e-01 2.28263531988772555569866540281510e-02 9.52526255911213676208504352871387e-02 3.14296611528030013851808810443345e-03
 	 7.62823015185039587926496551517630e-01 4.58496989177009650617833358410280e-02 1.91327285897259447011720112641342e-01 8.28867667775462502177674650738481e-03
 	 6.18117234695294004431787016073940e-01 7.38233932130475389854495915642474e-02 3.08059372091658456582763392361812e-01 1.52199761766368089899170712442356e-02
 	 4.61970401081011117216945649488480e-01 1.04008806497362271681339507267694e-01 4.34020792421626666612866074501653e-01 2.19846810033876328971391700406457e-02
 	 3.09667579927637937053930272668367e-01 1.33451117266455754339915529271821e-01 5.56881302805906308606154198059812e-01 2.61415486192328148928876174750258e-02
 	 1.76116656162995433021478675073013e-01 1.59268418424773905428537545958534e-01 6.64614925412230661549983778968453e-01 2.56789471667222754525106154233072e-02
 	 7.43873897091960056826565050869249e-02 1.78934138695500122295811706862878e-01 7.46678471595303872021531788050197e-01 1.98257646023713325622583880658567e-02
 	 1.44124096488764674717231173417531e-02 1.90528159002766095397873868932948e-01 7.95059431348357437130403013725299e-01 9.45443576231013056709873154659363e-03
 	 9.63742187116790494094686891912716e-01 2.97257671460896683024444087095617e-03 3.32852361686005390750686672163283e-02 3.93966014801656687870090589598249e-04
 	 8.81921021210001376822162910684710e-01 9.68063970009890029100318997734576e-03 1.08398339089899722886833899337944e-01 2.17861759201857813766922689069361e-03
 	 7.62823015185039587926496551517630e-01 1.94448237838582560499389728647657e-02 2.17732161031102156023564475617604e-01 5.74548250358717944169528735187669e-03
 	 6.18117234695294115454089478589594e-01 3.13084470790275237739308522577630e-02 3.50574318225678360771979669152643e-01 1.05500685124527426861362755516893e-02
 	 4.61970401081011117216945649488480e-01 4.41100587801205867855003361910349e-02 4.93919540138868351508705245578312e-01 1.52391756805896720627924167956735e-02
 	 3.09667579927637937053930272668367e-01 5.65965212478946044782901481084991e-02 6.33735898824467458467779579223134e-01 1.81206018822733551376646943253945e-02
 	 1.76116656162995433021478675073013e-01 6.75456197904913402396687160944566e-02 7.56337724046513226738852608832531e-01 1.77999392898155542330762557412527e-02
 	 7.43873897091960056826565050869249e-02 7.58858373769428773414347233483568e-02 8.49726772913861116975908771564718e-01 1.37426742617278666719338175994380e-02
 	 1.44124096488764674717231173417531e-02 8.08028529112417848168092859850731e-02 9.04784737439881747711467596673174e-01 6.55355461016208368230095970830007e-03
 	 9.63742187116790494094686891912716e-01 5.77220039089346159677518244279781e-04 3.56805928441201597456355898430047e-02 1.77247013006332670200654311187805e-04
 	 8.81921021210001376822162910684710e-01 1.87980320192882022212188530829735e-03 1.16199175588069802955715204006992e-01 9.80169471883893641053764334003517e-04
 	 7.62823015185039587926496551517630e-01 3.77582919540583872297645484650275e-03 2.33401155619554573350526993635867e-01 2.58491741363445952719968268240791e-03
 	 6.18117234695294004431787016073940e-01 6.07952789173360486074670916423202e-03 3.75803237412972390707466274761828e-01 4.74652142719938184567407546410323e-03
 	 4.61970401081011061705794418230653e-01 8.56536678369423931656001514056697e-03 5.29464232135294698977645566628780e-01 6.85617101115471028194292557600420e-03
 	 3.09667579927637937053930272668367e-01 1.09900094576123041889559317496605e-02 6.79342410614749758757113795581972e-01 8.15253711446882814439796050010045e-03
 	 1.76116656162995433021478675073013e-01 1.31161241707130615807841422792990e-02 8.10767219666291505397737182647688e-01 8.00826962803442843341628076814231e-03
 	 7.43873897091960056826565050869249e-02 1.47356419101900559809337210026570e-02 9.10876968380613938336409773910418e-01 6.18288855407136354186414806122229e-03
 	 1.44124096488764674717231173417531e-02 1.56904364105177052124417969025671e-02 9.69897153940605827315835085755680e-01 2.94847254733360741515979519533630e-03
 	 ];
 
 	 case  17 

 	 % ALG. DEG.:   17
 	 % PTS CARD.:   81
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 9.63742187116790494094686891912716e-01 3.56805928441202152567868211008317e-02 5.77220039089290648526286986452760e-04 1.77247013006332588885491374774972e-04
 	 8.81921021210001376822162910684710e-01 1.16199175588069802955715204006992e-01 1.87980320192882022212188530829735e-03 9.80169471883893207372895339801744e-04
 	 7.62823015185039587926496551517630e-01 2.33401155619554573350526993635867e-01 3.77582919540583872297645484650275e-03 2.58491741363445822615707569980259e-03
 	 6.18117234695294004431787016073940e-01 3.75803237412972390707466274761828e-01 6.07952789173360486074670916423202e-03 4.74652142719937924358886149889258e-03
 	 4.61970401081011061705794418230653e-01 5.29464232135294698977645566628780e-01 8.56536678369423931656001514056697e-03 6.85617101115470681249597362239001e-03
 	 3.09667579927637937053930272668367e-01 6.79342410614749758757113795581972e-01 1.09900094576123041889559317496605e-02 8.15253711446882467495100854648626e-03
 	 1.76116656162995433021478675073013e-01 8.10767219666291505397737182647688e-01 1.31161241707130615807841422792990e-02 8.00826962803442496396932881452813e-03
 	 7.43873897091960056826565050869249e-02 9.10876968380613938336409773910418e-01 1.47356419101900559809337210026570e-02 6.18288855407136007241719610760811e-03
 	 1.44124096488764674717231173417531e-02 9.69897153940605827315835085755680e-01 1.56904364105177052124417969025671e-02 2.94847254733360568043631921852921e-03
 	 9.63742187116790494094686891912716e-01 3.32852361686006084640077062886121e-02 2.97257671460889744130540179867239e-03 3.93966014801657501021719953726574e-04
 	 8.81921021210001265799860448169056e-01 1.08398339089899764520197322781314e-01 9.68063970009896967994222904962953e-03 2.17861759201858290815878582691312e-03
 	 7.62823015185039587926496551517630e-01 2.17732161031102239290291322504345e-01 1.94448237838581727832121259780251e-02 5.74548250358719158475961918952635e-03
 	 6.18117234695293893409484553558286e-01 3.50574318225678582816584594183951e-01 3.13084470790275237739308522577630e-02 1.05500685124527652375414632501816e-02
 	 4.61970401081011061705794418230653e-01 4.93919540138868518042158939351793e-01 4.41100587801204202520466424175538e-02 1.52391756805897050225384603550083e-02
 	 3.09667579927637937053930272668367e-01 6.33735898824467680512384504254442e-01 5.65965212478943824336852230771910e-02 1.81206018822733933015811658151506e-02
 	 1.76116656162995433021478675073013e-01 7.56337724046513448783457533863839e-01 6.75456197904911181950637910631485e-02 1.77999392898155923969927272310088e-02
 	 7.43873897091960056826565050869249e-02 8.49726772913861339020513696596026e-01 7.58858373769426552968297983170487e-02 1.37426742617278961622329092051586e-02
 	 1.44124096488764674717231173417531e-02 9.04784737439882080778374984220136e-01 8.08028529112414517499018984381109e-02 6.55355461016209756008876752275683e-03
 	 9.63742187116790494094686891912716e-01 2.92486597589868627111719945332879e-02 7.00915312422264319414111355399655e-03 5.68352077771648979756524688866648e-04
 	 8.81921021210001376822162910684710e-01 9.52526255911213398652748196582252e-02 2.28263531988772833125622696570645e-02 3.14296611528030404164590905224941e-03
 	 7.62823015185039698948799014033284e-01 1.91327285897259391500568881383515e-01 4.58496989177009095506321045832010e-02 8.28867667775463543011760236822738e-03
 	 6.18117234695293893409484553558286e-01 3.08059372091658401071612161103985e-01 7.38233932130477055189032853377284e-02 1.52199761766368298065987829659207e-02
 	 4.61970401081011117216945649488480e-01 4.34020792421626555590563611985999e-01 1.04008806497362382703641969783348e-01 2.19846810033876606527147856695592e-02
 	 3.09667579927637826031627810152713e-01 5.56881302805906308606154198059812e-01 1.33451117266455865362217991787475e-01 2.61415486192328495873571370111677e-02
 	 1.76116656162995433021478675073013e-01 6.64614925412230550527681316452799e-01 1.59268418424774016450840008474188e-01 2.56789471667223066775331830058349e-02
 	 7.43873897091960056826565050869249e-02 7.46678471595303760999229325534543e-01 1.78934138695500233318114169378532e-01 1.98257646023713603178340036947702e-02
 	 1.44124096488764674717231173417531e-02 7.95059431348357326108100551209645e-01 1.90528159002766206420176331448602e-01 9.45443576231014271016306338424329e-03
 	 9.63742187116790383072384429397061e-01 2.40072664178624939346207156631863e-02 1.22505464653471229929948549397523e-02 6.81181212712447044406449681019922e-04
 	 8.81921021210001376822162910684710e-01 7.81832459473407181960169509693515e-02 3.98957328426579049818201383459382e-02 3.76690708744262421625581538364713e-03
 	 7.62823015185039698948799014033284e-01 1.57041217046902270570996051901602e-01 8.01357677680580304802049340651138e-02 9.93414302850978772618795176185813e-03
 	 6.18117234695294004431787016073940e-01 2.52854779646835114981229253316997e-01 1.29027985657870880586983730609063e-01 1.82414426460872011737102127426624e-02
 	 4.61970401081011061705794418230653e-01 3.56243769130524690069705684436485e-01 1.81785829788464248224499897332862e-01 2.63490752522606980212671601293550e-02
 	 3.09667579927637937053930272668367e-01 4.57087535283730916901845375832636e-01 2.33244884788631146044224351498997e-01 3.13311633529119101804205627104238e-02
 	 1.76116656162995433021478675073013e-01 5.45515169280765377379793790169060e-01 2.78368174556239189598727534757927e-01 3.07767263573454422087571913380089e-02
 	 7.43873897091960056826565050869249e-02 6.12872833961666474422713690728415e-01 3.12739776329137519894629804184660e-01 2.37615712213878928216193031630610e-02
 	 1.44124096488764674717231173417531e-02 6.52583870293393153438898934837198e-01 3.33003720057730379089377947821049e-01 1.13313283613434272883990772129437e-02
 	 9.63742187116790383072384429397061e-01 1.81289064416047807082321696725558e-02 1.81289064416048362193834009303828e-02 7.20201534962096822332922041454140e-04
 	 8.81921021210001487844465373200364e-01 5.90394893949993115889185446576448e-02 5.90394893949992005666160821419908e-02 3.98268803631995123998299490608588e-03
 	 7.62823015185039476904194089001976e-01 1.18588492407480206036751724241185e-01 1.18588492407480317059054186756839e-01 1.05032037351358784049715211494913e-02
 	 6.18117234695294115454089478589594e-01 1.90941382652352997784106491963030e-01 1.90941382652352886761804029447376e-01 1.92863730655779379297154463301922e-02
 	 4.61970401081011061705794418230653e-01 2.69014799459494469147102790884674e-01 2.69014799459494469147102790884674e-01 2.78584377950551707880944007911239e-02
 	 3.09667579927637992565081503926194e-01 3.45166210036181031473034863665816e-01 3.45166210036180920450732401150162e-01 3.31259164489623170180010447438690e-02
 	 1.76116656162995433021478675073013e-01 4.11941671918502283489260662463494e-01 4.11941671918502283489260662463494e-01 3.25397194608558620876337386107480e-02
 	 7.43873897091960056826565050869249e-02 4.62806305145401997158671747456538e-01 4.62806305145401997158671747456538e-01 2.51227129394991886834898053848519e-02
 	 1.44124096488764674717231173417531e-02 4.92793795175561766264138441329123e-01 4.92793795175561766264138441329123e-01 1.19804244842614034810557299692846e-02
 	 9.63742187116790383072384429397061e-01 1.22505464653470674818436236819252e-02 2.40072664178625494457719469210133e-02 6.81181212712446610725580686818148e-04
 	 8.81921021210001376822162910684710e-01 3.98957328426579188596079461603949e-02 7.81832459473407043182291431548947e-02 3.76690708744262118048973242423472e-03
 	 7.62823015185039587926496551517630e-01 8.01357677680581692580830122096813e-02 1.57041217046902242815420436272689e-01 9.93414302850978078729404785462975e-03
 	 6.18117234695294004431787016073940e-01 1.29027985657870880586983730609063e-01 2.52854779646835114981229253316997e-01 1.82414426460871907653693568818198e-02
 	 4.61970401081011006194643186972826e-01 1.81785829788464303735651128590689e-01 3.56243769130524634558554453178658e-01 2.63490752522606806740324003612841e-02
 	 3.09667579927637881542779041410540e-01 2.33244884788631201555375582756824e-01 4.57087535283730972412996607090463e-01 3.13311633529118824248449470815103e-02
 	 1.76116656162995433021478675073013e-01 2.78368174556239300621029997273581e-01 5.45515169280765266357491327653406e-01 3.07767263573454213920754796163237e-02
 	 7.43873897091960056826565050869249e-02 3.12739776329137630916932266700314e-01 6.12872833961666363400411228212761e-01 2.37615712213878754743845433949900e-02
 	 1.44124096488764674717231173417531e-02 3.33003720057730490111680410336703e-01 6.52583870293393042416596472321544e-01 1.13313283613434186147816973289082e-02
 	 9.63742187116790494094686891912716e-01 7.00915312422269176639844090459519e-03 2.92486597589868141389146671826893e-02 5.68352077771648329235221197563988e-04
 	 8.81921021210001376822162910684710e-01 2.28263531988772555569866540281510e-02 9.52526255911213676208504352871387e-02 3.14296611528030013851808810443345e-03
 	 7.62823015185039587926496551517630e-01 4.58496989177009650617833358410280e-02 1.91327285897259447011720112641342e-01 8.28867667775462502177674650738481e-03
 	 6.18117234695294004431787016073940e-01 7.38233932130475389854495915642474e-02 3.08059372091658456582763392361812e-01 1.52199761766368089899170712442356e-02
 	 4.61970401081011117216945649488480e-01 1.04008806497362271681339507267694e-01 4.34020792421626666612866074501653e-01 2.19846810033876328971391700406457e-02
 	 3.09667579927637937053930272668367e-01 1.33451117266455754339915529271821e-01 5.56881302805906308606154198059812e-01 2.61415486192328148928876174750258e-02
 	 1.76116656162995433021478675073013e-01 1.59268418424773905428537545958534e-01 6.64614925412230661549983778968453e-01 2.56789471667222754525106154233072e-02
 	 7.43873897091960056826565050869249e-02 1.78934138695500122295811706862878e-01 7.46678471595303872021531788050197e-01 1.98257646023713325622583880658567e-02
 	 1.44124096488764674717231173417531e-02 1.90528159002766095397873868932948e-01 7.95059431348357437130403013725299e-01 9.45443576231013056709873154659363e-03
 	 9.63742187116790494094686891912716e-01 2.97257671460896683024444087095617e-03 3.32852361686005390750686672163283e-02 3.93966014801656687870090589598249e-04
 	 8.81921021210001376822162910684710e-01 9.68063970009890029100318997734576e-03 1.08398339089899722886833899337944e-01 2.17861759201857813766922689069361e-03
 	 7.62823015185039587926496551517630e-01 1.94448237838582560499389728647657e-02 2.17732161031102156023564475617604e-01 5.74548250358717944169528735187669e-03
 	 6.18117234695294115454089478589594e-01 3.13084470790275237739308522577630e-02 3.50574318225678360771979669152643e-01 1.05500685124527426861362755516893e-02
 	 4.61970401081011117216945649488480e-01 4.41100587801205867855003361910349e-02 4.93919540138868351508705245578312e-01 1.52391756805896720627924167956735e-02
 	 3.09667579927637937053930272668367e-01 5.65965212478946044782901481084991e-02 6.33735898824467458467779579223134e-01 1.81206018822733551376646943253945e-02
 	 1.76116656162995433021478675073013e-01 6.75456197904913402396687160944566e-02 7.56337724046513226738852608832531e-01 1.77999392898155542330762557412527e-02
 	 7.43873897091960056826565050869249e-02 7.58858373769428773414347233483568e-02 8.49726772913861116975908771564718e-01 1.37426742617278666719338175994380e-02
 	 1.44124096488764674717231173417531e-02 8.08028529112417848168092859850731e-02 9.04784737439881747711467596673174e-01 6.55355461016208368230095970830007e-03
 	 9.63742187116790494094686891912716e-01 5.77220039089346159677518244279781e-04 3.56805928441201597456355898430047e-02 1.77247013006332670200654311187805e-04
 	 8.81921021210001376822162910684710e-01 1.87980320192882022212188530829735e-03 1.16199175588069802955715204006992e-01 9.80169471883893641053764334003517e-04
 	 7.62823015185039587926496551517630e-01 3.77582919540583872297645484650275e-03 2.33401155619554573350526993635867e-01 2.58491741363445952719968268240791e-03
 	 6.18117234695294004431787016073940e-01 6.07952789173360486074670916423202e-03 3.75803237412972390707466274761828e-01 4.74652142719938184567407546410323e-03
 	 4.61970401081011061705794418230653e-01 8.56536678369423931656001514056697e-03 5.29464232135294698977645566628780e-01 6.85617101115471028194292557600420e-03
 	 3.09667579927637937053930272668367e-01 1.09900094576123041889559317496605e-02 6.79342410614749758757113795581972e-01 8.15253711446882814439796050010045e-03
 	 1.76116656162995433021478675073013e-01 1.31161241707130615807841422792990e-02 8.10767219666291505397737182647688e-01 8.00826962803442843341628076814231e-03
 	 7.43873897091960056826565050869249e-02 1.47356419101900559809337210026570e-02 9.10876968380613938336409773910418e-01 6.18288855407136354186414806122229e-03
 	 1.44124096488764674717231173417531e-02 1.56904364105177052124417969025671e-02 9.69897153940605827315835085755680e-01 2.94847254733360741515979519533630e-03
 	 ];
 
 	 case  18 

 	 % ALG. DEG.:   18
 	 % PTS CARD.:  100
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 9.69970967838513442593750824016752e-01 2.96372513143052136730393186780930e-02 3.91780847181343733209857305155310e-04 9.99497192701704435455201114280044e-05
 	 9.01710987790146689668802082451293e-01 9.70066614412667116429389579934650e-02 1.28235076858659868825895955524174e-03 5.61327368096220091081560710222220e-04
 	 8.00978921036898716678820164815988e-01 1.96424503538898509447108153835870e-01 2.59657542420277387407168134814128e-03 1.51841262827020736028704739339901e-03
 	 6.75944461676665109273187681537820e-01 3.19827671349288578106495606334647e-01 4.22786697404631262031671212753281e-03 2.89366344572460207004716004064448e-03
 	 5.36738765715660592903191172808874e-01 4.57217187381390277600701210758416e-01 6.04404690294912949610761643270962e-03 4.40384734353193706829499021182528e-03
 	 3.94639846885786793606598621408921e-01 5.97462179168150031571826730214525e-01 7.89797394606317482157464837655425e-03 5.63753617394467318457706994649925e-03
 	 2.61159676008456353990538900688989e-01 7.29200869529325057527557873982005e-01 9.63945446221858848190322532900609e-03 6.18022651473337444882893976227933e-03
 	 1.47111449643070324455607078562025e-01 8.41761138823544974307822030823445e-01 1.11274115333847012365708906145301e-02 5.74782328487936228222920931330009e-03
 	 6.17320718771483534226263145683333e-02 9.26026594409988579315040624351241e-01 1.22413337128630672623330610804260e-02 4.28611101290088218618290483163946e-03
 	 1.19176134324154858745714591350406e-02 9.75191136779291367631117282144260e-01 1.28912497882931464943112587206997e-02 2.00677466299269916666370150437615e-03
 	 9.69970967838513442593750824016752e-01 2.80030239107569543788311960952342e-02 2.02600825072960302741797988801409e-03 2.24048585596048398325269568331919e-04
 	 9.01710987790146800691104544966947e-01 9.16576180103218507433382455928950e-02 6.63139419953134856555720944015775e-03 1.25827870049700506378809183871681e-03
 	 8.00978921036898716678820164815988e-01 1.85593461786497881949031807380379e-01 1.34276171766034013721480278036324e-02 3.40369341904343987448289254871270e-03
 	 6.75944461676665109273187681537820e-01 3.02192056649765117271044800872914e-01 2.18634816735697734557675175892655e-02 6.48647346825588933666439928060754e-03
 	 5.36738765715660592903191172808874e-01 4.32005778635422277300648374875891e-01 3.12554556489171297961604523152346e-02 9.87172125848796364055992569319642e-03
 	 3.94639846885786793606598621408921e-01 5.64517522613276812037952367973048e-01 4.08426305009363943554490106180310e-02 1.26371741235677854942043296659904e-02
 	 2.61159676008456465012841363204643e-01 6.88992011054624153842951272963546e-01 4.98483129369193811442073638318107e-02 1.38536758222037072185717221373125e-02
 	 1.47111449643070324455607078562025e-01 7.95345595569591390372465866676066e-01 5.75429547873382851719270547619089e-02 1.28843951402431780572932495942950e-02
 	 6.17320718771483534226263145683333e-02 8.74964570440551869801026896311669e-01 6.33033576822997767763467891199980e-02 9.60780197443421475622660210547110e-03
 	 1.19176134324154858745714591350406e-02 9.21418131228912917762841061630752e-01 6.66642553386715963625874792342074e-02 4.49841208296106360997601569806648e-03
 	 9.69970967838513442593750824016752e-01 2.52155219693798310354182490300445e-02 4.81351019210672637083092695320374e-03 3.28441261481232562452481360537604e-04
 	 9.01710987790146689668802082451293e-01 8.25337537819436500852177118758846e-02 1.57552584279096602459802056728222e-02 1.84455814611262270026614817908239e-03
 	 8.00978921036898716678820164815988e-01 1.67118952151913968684482370008482e-01 3.19021268111873146366974651755299e-02 4.98960239928296009348507311642607e-03
 	 6.75944461676665109273187681537820e-01 2.72110985860249954271239403169602e-01 5.19445524630849364555729152925778e-02 9.50876580100171175935486189700896e-03
 	 5.36738765715660592903191172808874e-01 3.89002674739567899653280846905545e-01 7.42585595447715074435279802855803e-02 1.44713280581677192215828142707323e-02
 	 3.94639846885786793606598621408921e-01 5.08323816703486142110079981648596e-01 9.70363364107270642833213969424833e-02 1.85253095870282422086283702356013e-02
 	 2.61159676008456242968236438173335e-01 6.20407754778274922458081164222676e-01 1.18432569213268834573682397603989e-01 2.03086252523831528593589723641344e-02
 	 1.47111449643070324455607078562025e-01 7.16174596081056047403023967490299e-01 1.36713954275873628141368953947676e-01 1.88877201881285511353425476954726e-02
 	 6.17320718771483534226263145683333e-02 7.87868068058809267739661663654260e-01 1.50399860064042378837712021777406e-01 1.40844388378977836140393264940940e-02
 	 1.19176134324154858745714591350406e-02 8.29697507134668499340079961257288e-01 1.58384879432916014785348579607671e-01 6.59439172650688222587778142269599e-03
 	 9.69970967838513442593750824016752e-01 2.15217381952169314884848461133515e-02 8.50729396626962591776432986989676e-03 4.03668671794378465956382173729367e-04
 	 9.01710987790146689668802082451293e-01 7.04435086975585406099398255719279e-02 2.78455035122947697212580919767788e-02 2.26704261678561990248081947640912e-03
 	 8.00978921036898827701122627331642e-01 1.42637948960171262458018759389233e-01 5.63831300029299098408586132791243e-02 6.13243952424560607311621041048966e-03
 	 6.75944461676665109273187681537820e-01 2.32249858037370998653514675424958e-01 9.18056802859638920732976430372219e-02 1.16866889500529449325005870718996e-02
 	 5.36738765715660592903191172808874e-01 3.32018259750901156834856919886079e-01 1.31242974533438250261951907305047e-01 1.77858949572786279036407108833373e-02
 	 3.94639846885786793606598621408921e-01 4.33860227631644557177992282959167e-01 1.71499925482568649215409095631912e-01 2.27684155207845614898864994302130e-02
 	 2.61159676008456353990538900688989e-01 5.29525158703219700484510212845635e-01 2.09315165288323945524950886465376e-01 2.49601884508281260388606881406304e-02
 	 1.47111449643070324455607078562025e-01 6.11263259893596755389921781898011e-01 2.41625290463332920154471139539964e-01 2.32138339963153042533328118679492e-02
 	 6.17320718771483534226263145683333e-02 6.72454463315243611276628143968992e-01 2.65813464807608035300745541462675e-01 1.73103911884354699779464681341778e-02
 	 1.19176134324154858745714591350406e-02 7.08156370963105019633587744465331e-01 2.79926015604479494491840796399629e-01 8.10479577847735693785224952989665e-03
 	 9.69970967838513442593750824016752e-01 1.72497922373930079320558661493124e-02 1.27792399240935494741933098339359e-02 4.43032364264553792185946656800866e-04
 	 9.01710987790146689668802082451293e-01 5.64608619658763452586747177974758e-02 4.18281502439769650725231997512310e-02 2.48811295149167213333618597914665e-03
 	 8.00978921036898716678820164815988e-01 1.14325105268571966532498151991604e-01 8.46959736945293167886816831924079e-02 6.73044348242077782040748701319899e-03
 	 6.75944461676665109273187681537820e-01 1.86149546192278997347457902833412e-01 1.37905992131055893379354415628768e-01 1.28263147421154299898660156031838e-02
 	 5.36738765715660592903191172808874e-01 2.66114472157117532002956750147860e-01 1.97146762127221875093852077043266e-01 1.95202839458840787800752991643094e-02
 	 3.94639846885786849117749852666748e-01 3.47741372877455379164501891864347e-01 2.57618780236757827228899486726732e-01 2.49886742855020341225191771172831e-02
 	 2.61159676008456298479387669431162e-01 4.24417344419379449771412282643723e-01 3.14422979572164307260351279182942e-01 2.73941776375750782601681265759908e-02
 	 1.47111449643070324455607078562025e-01 4.89930884758159601588545228878502e-01 3.62957665598770073955847692559473e-01 2.54775276796094102271794668013172e-02
 	 6.17320718771483534226263145683333e-02 5.38975972854902840580848533136304e-01 3.99291955267948805996525152295362e-01 1.89984114954141088127403946828053e-02
 	 1.19176134324154858745714591350406e-02 5.67591249363613048473098388058133e-01 4.20491137203971465652330152806826e-01 8.89513377309901660805468992521128e-03
 	 9.69970967838513442593750824016752e-01 1.27792399240935494741933098339359e-02 1.72497922373930079320558661493124e-02 4.43032364264553304294969038323870e-04
 	 9.01710987790146689668802082451293e-01 4.18281502439769511947353919367742e-02 5.64608619658763591364625256119325e-02 2.48811295149166909757010301973423e-03
 	 8.00978921036898827701122627331642e-01 8.46959736945292335219548363056674e-02 1.14325105268571938776922536362690e-01 6.73044348242077001415184511756706e-03
 	 6.75944461676665109273187681537820e-01 1.37905992131055837868203184370941e-01 1.86149546192279052858609134091239e-01 1.28263147421154161120782077887270e-02
 	 5.36738765715660592903191172808874e-01 1.97146762127221875093852077043266e-01 2.66114472157117532002956750147860e-01 1.95202839458840579633935874426243e-02
 	 3.94639846885786793606598621408921e-01 2.57618780236757771717748255468905e-01 3.47741372877455434675653123122174e-01 2.49886742855020063669435614883696e-02
 	 2.61159676008456409501690131946816e-01 3.14422979572164085215746354151634e-01 4.24417344419379449771412282643723e-01 2.73941776375750470351455589934631e-02
 	 1.47111449643070324455607078562025e-01 3.62957665598769962933545230043819e-01 4.89930884758159712610847691394156e-01 2.54775276796093824716038511724037e-02
 	 6.17320718771483534226263145683333e-02 3.99291955267948694974222689779708e-01 5.38975972854902951603150995651959e-01 1.89984114954140879960586829611202e-02
 	 1.19176134324154858745714591350406e-02 4.20491137203971354630027690291172e-01 5.67591249363613159495400850573787e-01 8.89513377309900619971383406436871e-03
 	 9.69970967838513442593750824016752e-01 8.50729396626962938721128182351094e-03 2.15217381952169280190378941597373e-02 4.03668671794378791217033919380697e-04
 	 9.01710987790146689668802082451293e-01 2.78455035122947835990458997912356e-02 7.04435086975585267321520177574712e-02 2.26704261678562207088516444741799e-03
 	 8.00978921036898716678820164815988e-01 5.63831300029299931075854601658648e-02 1.42637948960171290213594375018147e-01 6.13243952424561127728663834091094e-03
 	 6.75944461676665109273187681537820e-01 9.18056802859639198288732586661354e-02 2.32249858037370970897939059796045e-01 1.16866889500529536061179669559351e-02
 	 5.36738765715660481880888710293220e-01 1.31242974533438361284254369820701e-01 3.32018259750901156834856919886079e-01 1.77858949572786417814285186977941e-02
 	 3.94639846885786793606598621408921e-01 1.71499925482568760237711558147566e-01 4.33860227631644446155689820443513e-01 2.27684155207845788371212591982840e-02
 	 2.61159676008456353990538900688989e-01 2.09315165288324056547253348981030e-01 5.29525158703219589462207750329981e-01 2.49601884508281468555423998623155e-02
 	 1.47111449643070324455607078562025e-01 2.41625290463333031176773602055619e-01 6.11263259893596644367619319382356e-01 2.32138339963153216005675716360201e-02
 	 6.17320718771483534226263145683333e-02 2.65813464807608146323048003978329e-01 6.72454463315243500254325681453338e-01 1.73103911884354838557342759486346e-02
 	 1.19176134324154858745714591350406e-02 2.79926015604479605514143258915283e-01 7.08156370963104908611285281949677e-01 8.10479577847736387674615343712503e-03
 	 9.69970967838513442593750824016752e-01 4.81351019210672637083092695320374e-03 2.52155219693798310354182490300445e-02 3.28441261481232291401938239161495e-04
 	 9.01710987790146689668802082451293e-01 1.57552584279096602459802056728222e-02 8.25337537819436500852177118758846e-02 1.84455814611262139922354119647707e-03
 	 8.00978921036898716678820164815988e-01 3.19021268111872868811218495466164e-02 1.67118952151913996440057985637395e-01 4.98960239928295662403812116281188e-03
 	 6.75944461676664998250885219022166e-01 5.19445524630849919667241465504048e-02 2.72110985860250009782390634427429e-01 9.50876580100170482046095798978058e-03
 	 5.36738765715660592903191172808874e-01 7.42585595447715629546792115434073e-02 3.89002674739567844142129615647718e-01 1.44713280581677088132419584098898e-02
 	 3.94639846885786793606598621408921e-01 9.70363364107271753056238594581373e-02 5.08323816703486031087777519132942e-01 1.85253095870282283308405624211446e-02
 	 2.61159676008456353990538900688989e-01 1.18432569213268834573682397603989e-01 6.20407754778274811435778701707022e-01 2.03086252523831389815711645496776e-02
 	 1.47111449643070324455607078562025e-01 1.36713954275873628141368953947676e-01 7.16174596081056047403023967490299e-01 1.88877201881285372575547398810158e-02
 	 6.17320718771483534226263145683333e-02 1.50399860064042489860014484293060e-01 7.87868068058809156717359201138606e-01 1.40844388378977732056984706332514e-02
 	 1.19176134324154858745714591350406e-02 1.58384879432916014785348579607671e-01 8.29697507134668499340079961257288e-01 6.59439172650687702170735349227471e-03
 	 9.69970967838513442593750824016752e-01 2.02600825072960649686493184162828e-03 2.80030239107569509093842441416200e-02 2.24048585596048859111192874671303e-04
 	 9.01710987790146578646499619935639e-01 6.63139419953145958785967195581179e-03 9.16576180103219617656407081085490e-02 1.25827870049700766587330580392745e-03
 	 8.00978921036898827701122627331642e-01 1.34276171766033458609967965458054e-02 1.85593461786497826437880576122552e-01 3.40369341904344681337679645594108e-03
 	 6.75944461676664998250885219022166e-01 2.18634816735698289669187488470925e-02 3.02192056649765172782196032130742e-01 6.48647346825590234709046910666075e-03
 	 5.36738765715660592903191172808874e-01 3.12554556489172408184629148308886e-02 4.32005778635422166278345912360237e-01 9.87172125848798445724163741488155e-03
 	 3.94639846885786793606598621408921e-01 4.08426305009365053777514731336851e-02 5.64517522613276701015649905457394e-01 1.26371741235678115150564693180968e-02
 	 2.61159676008456353990538900688989e-01 4.98483129369194921665098263474647e-02 6.88992011054624153842951272963546e-01 1.38536758222037367088708137430331e-02
 	 1.47111449643070324455607078562025e-01 5.75429547873383961942295172775630e-02 7.95345595569591279350163404160412e-01 1.28843951402432040781453892464015e-02
 	 6.17320718771483534226263145683333e-02 6.33033576822998877986492516356520e-02 8.74964570440551758778724433796015e-01 9.60780197443423383818483785034914e-03
 	 1.19176134324154858745714591350406e-02 6.66642553386717073848899417498615e-02 9.21418131228912806740538599115098e-01 4.49841208296107228359339558210195e-03
 	 9.69970967838513442593750824016752e-01 3.91780847181340263762905351541121e-04 2.96372513143052171424862706317072e-02 9.99497192701704842031015796344207e-05
 	 9.01710987790146689668802082451293e-01 1.28235076858658481047115174078499e-03 9.70066614412667255207267658079218e-02 5.61327368096220307921995207323107e-04
 	 8.00978921036898827701122627331642e-01 2.59657542420269060734483446140075e-03 1.96424503538898481691532538206957e-01 1.51841262827020801080835088470167e-03
 	 6.75944461676664998250885219022166e-01 4.22786697404625710916548086970579e-03 3.19827671349288744639949300108128e-01 2.89366344572460337108976702324981e-03
 	 5.36738765715660481880888710293220e-01 6.04404690294912949610761643270962e-03 4.57217187381390388623003673274070e-01 4.40384734353193880301846618863237e-03
 	 3.94639846885786793606598621408921e-01 7.89797394606317482157464837655425e-03 5.97462179168150031571826730214525e-01 5.63753617394467578666228391170989e-03
 	 2.61159676008456353990538900688989e-01 9.63945446221847745960076281335205e-03 7.29200869529325168549860336497659e-01 6.18022651473337618355241573908643e-03
 	 1.47111449643070324455607078562025e-01 1.11274115333845902142684280988760e-02 8.41761138823545085330124493339099e-01 5.74782328487936488431442327851073e-03
 	 6.17320718771483534226263145683333e-02 1.22413337128629562400305985647719e-02 9.26026594409988690337343086866895e-01 4.28611101290088392090638080844656e-03
 	 1.19176134324154858745714591350406e-02 1.28912497882930354720087962050457e-02 9.75191136779291478653419744659914e-01 2.00677466299270003402543949277970e-03
 	 ];
 
 	 case  19 

 	 % ALG. DEG.:   19
 	 % PTS CARD.:  100
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 9.69970967838513442593750824016752e-01 2.96372513143052136730393186780930e-02 3.91780847181343733209857305155310e-04 9.99497192701704435455201114280044e-05
 	 9.01710987790146689668802082451293e-01 9.70066614412667116429389579934650e-02 1.28235076858659868825895955524174e-03 5.61327368096220091081560710222220e-04
 	 8.00978921036898716678820164815988e-01 1.96424503538898509447108153835870e-01 2.59657542420277387407168134814128e-03 1.51841262827020736028704739339901e-03
 	 6.75944461676665109273187681537820e-01 3.19827671349288578106495606334647e-01 4.22786697404631262031671212753281e-03 2.89366344572460207004716004064448e-03
 	 5.36738765715660592903191172808874e-01 4.57217187381390277600701210758416e-01 6.04404690294912949610761643270962e-03 4.40384734353193706829499021182528e-03
 	 3.94639846885786793606598621408921e-01 5.97462179168150031571826730214525e-01 7.89797394606317482157464837655425e-03 5.63753617394467318457706994649925e-03
 	 2.61159676008456353990538900688989e-01 7.29200869529325057527557873982005e-01 9.63945446221858848190322532900609e-03 6.18022651473337444882893976227933e-03
 	 1.47111449643070324455607078562025e-01 8.41761138823544974307822030823445e-01 1.11274115333847012365708906145301e-02 5.74782328487936228222920931330009e-03
 	 6.17320718771483534226263145683333e-02 9.26026594409988579315040624351241e-01 1.22413337128630672623330610804260e-02 4.28611101290088218618290483163946e-03
 	 1.19176134324154858745714591350406e-02 9.75191136779291367631117282144260e-01 1.28912497882931464943112587206997e-02 2.00677466299269916666370150437615e-03
 	 9.69970967838513442593750824016752e-01 2.80030239107569543788311960952342e-02 2.02600825072960302741797988801409e-03 2.24048585596048398325269568331919e-04
 	 9.01710987790146800691104544966947e-01 9.16576180103218507433382455928950e-02 6.63139419953134856555720944015775e-03 1.25827870049700506378809183871681e-03
 	 8.00978921036898716678820164815988e-01 1.85593461786497881949031807380379e-01 1.34276171766034013721480278036324e-02 3.40369341904343987448289254871270e-03
 	 6.75944461676665109273187681537820e-01 3.02192056649765117271044800872914e-01 2.18634816735697734557675175892655e-02 6.48647346825588933666439928060754e-03
 	 5.36738765715660592903191172808874e-01 4.32005778635422277300648374875891e-01 3.12554556489171297961604523152346e-02 9.87172125848796364055992569319642e-03
 	 3.94639846885786793606598621408921e-01 5.64517522613276812037952367973048e-01 4.08426305009363943554490106180310e-02 1.26371741235677854942043296659904e-02
 	 2.61159676008456465012841363204643e-01 6.88992011054624153842951272963546e-01 4.98483129369193811442073638318107e-02 1.38536758222037072185717221373125e-02
 	 1.47111449643070324455607078562025e-01 7.95345595569591390372465866676066e-01 5.75429547873382851719270547619089e-02 1.28843951402431780572932495942950e-02
 	 6.17320718771483534226263145683333e-02 8.74964570440551869801026896311669e-01 6.33033576822997767763467891199980e-02 9.60780197443421475622660210547110e-03
 	 1.19176134324154858745714591350406e-02 9.21418131228912917762841061630752e-01 6.66642553386715963625874792342074e-02 4.49841208296106360997601569806648e-03
 	 9.69970967838513442593750824016752e-01 2.52155219693798310354182490300445e-02 4.81351019210672637083092695320374e-03 3.28441261481232562452481360537604e-04
 	 9.01710987790146689668802082451293e-01 8.25337537819436500852177118758846e-02 1.57552584279096602459802056728222e-02 1.84455814611262270026614817908239e-03
 	 8.00978921036898716678820164815988e-01 1.67118952151913968684482370008482e-01 3.19021268111873146366974651755299e-02 4.98960239928296009348507311642607e-03
 	 6.75944461676665109273187681537820e-01 2.72110985860249954271239403169602e-01 5.19445524630849364555729152925778e-02 9.50876580100171175935486189700896e-03
 	 5.36738765715660592903191172808874e-01 3.89002674739567899653280846905545e-01 7.42585595447715074435279802855803e-02 1.44713280581677192215828142707323e-02
 	 3.94639846885786793606598621408921e-01 5.08323816703486142110079981648596e-01 9.70363364107270642833213969424833e-02 1.85253095870282422086283702356013e-02
 	 2.61159676008456242968236438173335e-01 6.20407754778274922458081164222676e-01 1.18432569213268834573682397603989e-01 2.03086252523831528593589723641344e-02
 	 1.47111449643070324455607078562025e-01 7.16174596081056047403023967490299e-01 1.36713954275873628141368953947676e-01 1.88877201881285511353425476954726e-02
 	 6.17320718771483534226263145683333e-02 7.87868068058809267739661663654260e-01 1.50399860064042378837712021777406e-01 1.40844388378977836140393264940940e-02
 	 1.19176134324154858745714591350406e-02 8.29697507134668499340079961257288e-01 1.58384879432916014785348579607671e-01 6.59439172650688222587778142269599e-03
 	 9.69970967838513442593750824016752e-01 2.15217381952169314884848461133515e-02 8.50729396626962591776432986989676e-03 4.03668671794378465956382173729367e-04
 	 9.01710987790146689668802082451293e-01 7.04435086975585406099398255719279e-02 2.78455035122947697212580919767788e-02 2.26704261678561990248081947640912e-03
 	 8.00978921036898827701122627331642e-01 1.42637948960171262458018759389233e-01 5.63831300029299098408586132791243e-02 6.13243952424560607311621041048966e-03
 	 6.75944461676665109273187681537820e-01 2.32249858037370998653514675424958e-01 9.18056802859638920732976430372219e-02 1.16866889500529449325005870718996e-02
 	 5.36738765715660592903191172808874e-01 3.32018259750901156834856919886079e-01 1.31242974533438250261951907305047e-01 1.77858949572786279036407108833373e-02
 	 3.94639846885786793606598621408921e-01 4.33860227631644557177992282959167e-01 1.71499925482568649215409095631912e-01 2.27684155207845614898864994302130e-02
 	 2.61159676008456353990538900688989e-01 5.29525158703219700484510212845635e-01 2.09315165288323945524950886465376e-01 2.49601884508281260388606881406304e-02
 	 1.47111449643070324455607078562025e-01 6.11263259893596755389921781898011e-01 2.41625290463332920154471139539964e-01 2.32138339963153042533328118679492e-02
 	 6.17320718771483534226263145683333e-02 6.72454463315243611276628143968992e-01 2.65813464807608035300745541462675e-01 1.73103911884354699779464681341778e-02
 	 1.19176134324154858745714591350406e-02 7.08156370963105019633587744465331e-01 2.79926015604479494491840796399629e-01 8.10479577847735693785224952989665e-03
 	 9.69970967838513442593750824016752e-01 1.72497922373930079320558661493124e-02 1.27792399240935494741933098339359e-02 4.43032364264553792185946656800866e-04
 	 9.01710987790146689668802082451293e-01 5.64608619658763452586747177974758e-02 4.18281502439769650725231997512310e-02 2.48811295149167213333618597914665e-03
 	 8.00978921036898716678820164815988e-01 1.14325105268571966532498151991604e-01 8.46959736945293167886816831924079e-02 6.73044348242077782040748701319899e-03
 	 6.75944461676665109273187681537820e-01 1.86149546192278997347457902833412e-01 1.37905992131055893379354415628768e-01 1.28263147421154299898660156031838e-02
 	 5.36738765715660592903191172808874e-01 2.66114472157117532002956750147860e-01 1.97146762127221875093852077043266e-01 1.95202839458840787800752991643094e-02
 	 3.94639846885786849117749852666748e-01 3.47741372877455379164501891864347e-01 2.57618780236757827228899486726732e-01 2.49886742855020341225191771172831e-02
 	 2.61159676008456298479387669431162e-01 4.24417344419379449771412282643723e-01 3.14422979572164307260351279182942e-01 2.73941776375750782601681265759908e-02
 	 1.47111449643070324455607078562025e-01 4.89930884758159601588545228878502e-01 3.62957665598770073955847692559473e-01 2.54775276796094102271794668013172e-02
 	 6.17320718771483534226263145683333e-02 5.38975972854902840580848533136304e-01 3.99291955267948805996525152295362e-01 1.89984114954141088127403946828053e-02
 	 1.19176134324154858745714591350406e-02 5.67591249363613048473098388058133e-01 4.20491137203971465652330152806826e-01 8.89513377309901660805468992521128e-03
 	 9.69970967838513442593750824016752e-01 1.27792399240935494741933098339359e-02 1.72497922373930079320558661493124e-02 4.43032364264553304294969038323870e-04
 	 9.01710987790146689668802082451293e-01 4.18281502439769511947353919367742e-02 5.64608619658763591364625256119325e-02 2.48811295149166909757010301973423e-03
 	 8.00978921036898827701122627331642e-01 8.46959736945292335219548363056674e-02 1.14325105268571938776922536362690e-01 6.73044348242077001415184511756706e-03
 	 6.75944461676665109273187681537820e-01 1.37905992131055837868203184370941e-01 1.86149546192279052858609134091239e-01 1.28263147421154161120782077887270e-02
 	 5.36738765715660592903191172808874e-01 1.97146762127221875093852077043266e-01 2.66114472157117532002956750147860e-01 1.95202839458840579633935874426243e-02
 	 3.94639846885786793606598621408921e-01 2.57618780236757771717748255468905e-01 3.47741372877455434675653123122174e-01 2.49886742855020063669435614883696e-02
 	 2.61159676008456409501690131946816e-01 3.14422979572164085215746354151634e-01 4.24417344419379449771412282643723e-01 2.73941776375750470351455589934631e-02
 	 1.47111449643070324455607078562025e-01 3.62957665598769962933545230043819e-01 4.89930884758159712610847691394156e-01 2.54775276796093824716038511724037e-02
 	 6.17320718771483534226263145683333e-02 3.99291955267948694974222689779708e-01 5.38975972854902951603150995651959e-01 1.89984114954140879960586829611202e-02
 	 1.19176134324154858745714591350406e-02 4.20491137203971354630027690291172e-01 5.67591249363613159495400850573787e-01 8.89513377309900619971383406436871e-03
 	 9.69970967838513442593750824016752e-01 8.50729396626962938721128182351094e-03 2.15217381952169280190378941597373e-02 4.03668671794378791217033919380697e-04
 	 9.01710987790146689668802082451293e-01 2.78455035122947835990458997912356e-02 7.04435086975585267321520177574712e-02 2.26704261678562207088516444741799e-03
 	 8.00978921036898716678820164815988e-01 5.63831300029299931075854601658648e-02 1.42637948960171290213594375018147e-01 6.13243952424561127728663834091094e-03
 	 6.75944461676665109273187681537820e-01 9.18056802859639198288732586661354e-02 2.32249858037370970897939059796045e-01 1.16866889500529536061179669559351e-02
 	 5.36738765715660481880888710293220e-01 1.31242974533438361284254369820701e-01 3.32018259750901156834856919886079e-01 1.77858949572786417814285186977941e-02
 	 3.94639846885786793606598621408921e-01 1.71499925482568760237711558147566e-01 4.33860227631644446155689820443513e-01 2.27684155207845788371212591982840e-02
 	 2.61159676008456353990538900688989e-01 2.09315165288324056547253348981030e-01 5.29525158703219589462207750329981e-01 2.49601884508281468555423998623155e-02
 	 1.47111449643070324455607078562025e-01 2.41625290463333031176773602055619e-01 6.11263259893596644367619319382356e-01 2.32138339963153216005675716360201e-02
 	 6.17320718771483534226263145683333e-02 2.65813464807608146323048003978329e-01 6.72454463315243500254325681453338e-01 1.73103911884354838557342759486346e-02
 	 1.19176134324154858745714591350406e-02 2.79926015604479605514143258915283e-01 7.08156370963104908611285281949677e-01 8.10479577847736387674615343712503e-03
 	 9.69970967838513442593750824016752e-01 4.81351019210672637083092695320374e-03 2.52155219693798310354182490300445e-02 3.28441261481232291401938239161495e-04
 	 9.01710987790146689668802082451293e-01 1.57552584279096602459802056728222e-02 8.25337537819436500852177118758846e-02 1.84455814611262139922354119647707e-03
 	 8.00978921036898716678820164815988e-01 3.19021268111872868811218495466164e-02 1.67118952151913996440057985637395e-01 4.98960239928295662403812116281188e-03
 	 6.75944461676664998250885219022166e-01 5.19445524630849919667241465504048e-02 2.72110985860250009782390634427429e-01 9.50876580100170482046095798978058e-03
 	 5.36738765715660592903191172808874e-01 7.42585595447715629546792115434073e-02 3.89002674739567844142129615647718e-01 1.44713280581677088132419584098898e-02
 	 3.94639846885786793606598621408921e-01 9.70363364107271753056238594581373e-02 5.08323816703486031087777519132942e-01 1.85253095870282283308405624211446e-02
 	 2.61159676008456353990538900688989e-01 1.18432569213268834573682397603989e-01 6.20407754778274811435778701707022e-01 2.03086252523831389815711645496776e-02
 	 1.47111449643070324455607078562025e-01 1.36713954275873628141368953947676e-01 7.16174596081056047403023967490299e-01 1.88877201881285372575547398810158e-02
 	 6.17320718771483534226263145683333e-02 1.50399860064042489860014484293060e-01 7.87868068058809156717359201138606e-01 1.40844388378977732056984706332514e-02
 	 1.19176134324154858745714591350406e-02 1.58384879432916014785348579607671e-01 8.29697507134668499340079961257288e-01 6.59439172650687702170735349227471e-03
 	 9.69970967838513442593750824016752e-01 2.02600825072960649686493184162828e-03 2.80030239107569509093842441416200e-02 2.24048585596048859111192874671303e-04
 	 9.01710987790146578646499619935639e-01 6.63139419953145958785967195581179e-03 9.16576180103219617656407081085490e-02 1.25827870049700766587330580392745e-03
 	 8.00978921036898827701122627331642e-01 1.34276171766033458609967965458054e-02 1.85593461786497826437880576122552e-01 3.40369341904344681337679645594108e-03
 	 6.75944461676664998250885219022166e-01 2.18634816735698289669187488470925e-02 3.02192056649765172782196032130742e-01 6.48647346825590234709046910666075e-03
 	 5.36738765715660592903191172808874e-01 3.12554556489172408184629148308886e-02 4.32005778635422166278345912360237e-01 9.87172125848798445724163741488155e-03
 	 3.94639846885786793606598621408921e-01 4.08426305009365053777514731336851e-02 5.64517522613276701015649905457394e-01 1.26371741235678115150564693180968e-02
 	 2.61159676008456353990538900688989e-01 4.98483129369194921665098263474647e-02 6.88992011054624153842951272963546e-01 1.38536758222037367088708137430331e-02
 	 1.47111449643070324455607078562025e-01 5.75429547873383961942295172775630e-02 7.95345595569591279350163404160412e-01 1.28843951402432040781453892464015e-02
 	 6.17320718771483534226263145683333e-02 6.33033576822998877986492516356520e-02 8.74964570440551758778724433796015e-01 9.60780197443423383818483785034914e-03
 	 1.19176134324154858745714591350406e-02 6.66642553386717073848899417498615e-02 9.21418131228912806740538599115098e-01 4.49841208296107228359339558210195e-03
 	 9.69970967838513442593750824016752e-01 3.91780847181340263762905351541121e-04 2.96372513143052171424862706317072e-02 9.99497192701704842031015796344207e-05
 	 9.01710987790146689668802082451293e-01 1.28235076858658481047115174078499e-03 9.70066614412667255207267658079218e-02 5.61327368096220307921995207323107e-04
 	 8.00978921036898827701122627331642e-01 2.59657542420269060734483446140075e-03 1.96424503538898481691532538206957e-01 1.51841262827020801080835088470167e-03
 	 6.75944461676664998250885219022166e-01 4.22786697404625710916548086970579e-03 3.19827671349288744639949300108128e-01 2.89366344572460337108976702324981e-03
 	 5.36738765715660481880888710293220e-01 6.04404690294912949610761643270962e-03 4.57217187381390388623003673274070e-01 4.40384734353193880301846618863237e-03
 	 3.94639846885786793606598621408921e-01 7.89797394606317482157464837655425e-03 5.97462179168150031571826730214525e-01 5.63753617394467578666228391170989e-03
 	 2.61159676008456353990538900688989e-01 9.63945446221847745960076281335205e-03 7.29200869529325168549860336497659e-01 6.18022651473337618355241573908643e-03
 	 1.47111449643070324455607078562025e-01 1.11274115333845902142684280988760e-02 8.41761138823545085330124493339099e-01 5.74782328487936488431442327851073e-03
 	 6.17320718771483534226263145683333e-02 1.22413337128629562400305985647719e-02 9.26026594409988690337343086866895e-01 4.28611101290088392090638080844656e-03
 	 1.19176134324154858745714591350406e-02 1.28912497882930354720087962050457e-02 9.75191136779291478653419744659914e-01 2.00677466299270003402543949277970e-03
 	 ];
 
 	 case  20 

 	 % ALG. DEG.:   20
 	 % PTS CARD.:  121
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 9.74726379602479653385671554133296e-01 2.49985000827397454981060320733377e-02 2.75120314780601116222413793366286e-04 5.92128341032636463289046124813808e-05
 	 9.16958386552594983953667906462215e-01 8.21376497701717944721622188808396e-02 9.03963677233221574169874656945467e-04 3.36456419633320122537789576000478e-04
 	 8.30824899622818469069329694320913e-01 1.67333515905438101611935053369962e-01 1.84158447174342931873525230912492e-03 9.27640040518543248192206984725772e-04
 	 7.22203284890968078002515539992601e-01 2.74772711483761422623928183384123e-01 3.02400362527049937355627662327606e-03 1.81710813401476847100957101588392e-03
 	 5.98497279767139067629955206939485e-01 3.97132093744122061096391007595230e-01 4.37062648873887127365378546528518e-03 2.87201712420054886334974675321519e-03
 	 4.68137613089584014858246518997476e-01 5.26072707988075594087717945512850e-01 5.78967892234039105403553548967466e-03 3.87073985895676139779020275000221e-03
 	 3.40008157914665209986537774966564e-01 6.52807388077908057333331726113101e-01 7.18445400742673268013049892033450e-03 4.55809234010316408070018212583818e-03
 	 2.22840607043837790612883509311359e-01 7.68699491546636415328919156308984e-01 8.45990140952579405819733437965624e-03 4.71286876483551810113059588047690e-03
 	 1.24619225144442902220021096582059e-01 8.65851667804682145757055877766106e-01 9.52910705087495202292302565183491e-03 4.20965972059983341985178739719231e-03
 	 5.20354511271805542094170959899202e-02 9.37645318743354883039842206926551e-01 1.03192301294645627507406970835291e-02 3.05832481346475677785878843906175e-03
 	 1.00182804616806286901464773109183e-02 9.79205104315707730577855727460701e-01 1.07766152226116407319977952283807e-02 1.41216350765665599534259833092165e-03
 	 9.74726379602479653385671554133296e-01 2.38464519064483515542463010206120e-02 1.42716849107199506008214484609198e-03 1.33575731673385650691288084601638e-04
 	 9.16958386552594983953667906462215e-01 7.83523614804986640036688072541438e-02 4.68925196690635204266328628364136e-03 7.58997827233729945896334445620823e-04
 	 8.30824899622818469069329694320913e-01 1.59622002366896276193131143372739e-01 9.55309801028525473753916230634786e-03 2.09262398968611349620028150297912e-03
 	 7.22203284890968078002515539992601e-01 2.62109895710343432373434779947274e-01 1.56868193986884896240496800601250e-02 4.09913749622913426567949457535178e-03
 	 5.98497279767139067629955206939485e-01 3.78830383528292347072863321955083e-01 2.26723367045685852971814711054321e-02 6.47886213442427569275672283310996e-03
 	 4.68137613089584014858246518997476e-01 5.01828809281017029775284754578024e-01 3.00335776293989553664687264245003e-02 8.73183857195224816249989885363902e-03
 	 3.40008157914665209986537774966564e-01 6.22722960675643033567894235602580e-01 3.72688814096917564455679894308560e-02 1.02824080046960055628835206675831e-02
 	 2.22840607043837790612883509311359e-01 7.33274212253025026164721111854305e-01 4.38851807031371832223953788343351e-02 1.06315616044605435602798948480086e-02
 	 1.24619225144442902220021096582059e-01 8.25949160392968617649955831439001e-01 4.94316144625884801300230719789397e-02 9.49639357397537645089080626803479e-03
 	 5.20354511271805542094170959899202e-02 8.94434223041966069978059294953709e-01 5.35303258308533758125236090563703e-02 6.89914578216260700876949485405021e-03
 	 1.00182804616806286901464773109183e-02 9.34078738697435073667918459250359e-01 5.59029808408842976419350634387229e-02 3.18564001595890130061339284850419e-03
 	 9.74726379602479653385671554133296e-01 2.18636025094435144933147086021563e-02 3.41001788807683212101373726454767e-03 1.98150804415459690565812223006503e-04
 	 9.16958386552594983953667906462215e-01 7.18373070260663604269524284973159e-02 1.12043064213386556193796650404693e-02 1.12592331055833103255203742065760e-03
 	 8.30824899622818469069329694320913e-01 1.46349319605385830289634441214730e-01 2.28257807717957006410358644643566e-02 3.10426992763394339613913786024568e-03
 	 7.22203284890968078002515539992601e-01 2.40315271893887294485381289632642e-01 3.74814432151446275121031703747576e-02 6.08080062232751149264853296472211e-03
 	 5.98497279767139067629955206939485e-01 3.47330368327160410313325655806693e-01 5.41723519057005220567191372538218e-02 9.61096546169113580271314845049346e-03
 	 4.68137613089584070369397750255303e-01 4.60101387701228603521741433723946e-01 7.17609992091873816200120472785784e-02 1.29531076894188173359578897247957e-02
 	 3.40008157914665209986537774966564e-01 5.70943104623226616034514790953835e-01 8.90487374621081739789474340796005e-02 1.52532753662200683264504874614431e-02
 	 2.22840607043837790612883509311359e-01 6.72301941186907336955869141092990e-01 1.04857451769254872431247349595651e-01 1.57712217460839292104690656515231e-02
 	 1.24619225144442902220021096582059e-01 7.57270901628653736459284573356854e-01 1.18109873226903361320694330061087e-01 1.40872747029387717504489430098147e-02
 	 5.20354511271805542094170959899202e-02 8.20061382722703680059339603758417e-01 1.27903166150115765731243300251663e-01 1.02344285851097369782758406131506e-02
 	 1.00182804616806286901464773109183e-02 8.56409428770434688615864615712781e-01 1.33572290767884682693988906976301e-01 4.72568724746955711596418936437658e-03
 	 9.74726379602479653385671554133296e-01 1.91965294584577408909531470726506e-02 6.07709093906260572337529879405338e-03 2.48040580385069041845225168430034e-04
 	 9.16958386552594983953667906462215e-01 6.30740967755206438649651090599946e-02 1.99675166718843721813669844777905e-02 1.40940468167071331767603581397452e-03
 	 8.30824899622818469069329694320913e-01 1.28496620070575107153132421444752e-01 4.06784803066064237775378842343343e-02 3.88585308444079971512685744983173e-03
 	 7.22203284890968078002515539992601e-01 2.10999957314248975936976648881682e-01 6.67967577947829460605078111257171e-02 7.61180516030410259098459846427431e-03
 	 5.98497279767139067629955206939485e-01 3.04960614085872272482902189949527e-01 9.65421061469886598871426031109877e-02 1.20307836155962143837028222037588e-02
 	 4.68137613089584014858246518997476e-01 4.03975046613154309405047115433263e-01 1.27887340297261675736706365569262e-01 1.62143997272769825601645976576037e-02
 	 3.40008157914665209986537774966564e-01 5.01295526309952665933167281764327e-01 1.58696315775382124080294943269109e-01 1.90936962672018303854848397804744e-02
 	 2.22840607043837790612883509311359e-01 5.90289912808210748274007073632674e-01 1.86869480147951461113109417055966e-01 1.97420495305093701698950781064923e-02
 	 1.24619225144442902220021096582059e-01 6.64893773332568160938649270974565e-01 2.10487001522988936841329632443376e-01 1.76341236850826345305964792942177e-02
 	 5.20354511271805542094170959899202e-02 7.20024638408990780291674127511214e-01 2.27939910463828665498908776498865e-01 1.28112202907721475786395615159563e-02
 	 1.00182804616806286901464773109183e-02 7.51938699068082194720830102596665e-01 2.38043020470237176589023420092417e-01 5.91550567275525313731820986618004e-03
 	 9.74726379602479653385671554133296e-01 1.60429759009047684381599196967727e-02 9.23064449661557817616852616993128e-03 2.79536598511580833097134313192100e-04
 	 9.16958386552594983953667906462215e-01 5.27124560056966284804502720362507e-02 3.03291574417083875658818215015344e-02 1.58836989507481598019045243574965e-03
 	 8.30824899622818580091632156836567e-01 1.07387545420700850073991716726596e-01 6.17875549564805698343761264368368e-02 4.37927597110921232315128293066664e-03
 	 7.22203284890967966980213077476947e-01 1.76337459206357488605831917993783e-01 1.01459255902674544413955004529271e-01 8.57834681623890343837857130893099e-03
 	 5.98497279767139067629955206939485e-01 2.54862515283938828591914216303849e-01 1.46640204948922103778130576756666e-01 1.35584440421470005244675149924660e-02
 	 4.68137613089584014858246518997476e-01 3.37611126605298350611406021926086e-01 1.94251260305117634530347459076438e-01 1.82732927798896147009166668340185e-02
 	 3.40008157914665209986537774966564e-01 4.18944063051908788253285820246674e-01 2.41047779033426001760176404786762e-01 2.15182003656856218887227782943228e-02
 	 2.22840607043837846124034740569186e-01 4.93318694205787389162054523694678e-01 2.83840698750374820225061966993962e-01 2.22488810695346123091908907554171e-02
 	 1.24619225144442902220021096582059e-01 5.55666835785066481889771239366382e-01 3.19713939070490615890207664051559e-01 1.98732922855119620297870142167085e-02
 	 5.20354511271805542094170959899202e-02 6.01740952553470043184802307223435e-01 3.46223596319349402605780596786644e-01 1.44379800164367144005295173769809e-02
 	 1.00182804616806286901464773109183e-02 6.28412258278903568253781486419030e-01 3.61569461259415803056072036270052e-01 6.66665241498323561664118841463278e-03
 	 9.74726379602479653385671554133296e-01 1.26368101987601767766111748869662e-02 1.26368101987601698377172709797378e-02 2.90301488311583034008372949941190e-04
 	 9.16958386552594983953667906462215e-01 4.15208067237025149620599506761209e-02 4.15208067237025010842721428616642e-02 1.64953765261770918769401728098956e-03
 	 8.30824899622818469069329694320913e-01 8.45875501885907515875473450250865e-02 8.45875501885907793431229606540001e-02 4.54792087658421103485428815815794e-03
 	 7.22203284890967966980213077476947e-01 1.38898357554516044265469076890440e-01 1.38898357554515988754317845632613e-01 8.90869696943784490639206552486939e-03
 	 5.98497279767139067629955206939485e-01 2.00751360116430521696173627788085e-01 2.00751360116430410673871165272431e-01 1.40805765884767508655528445160598e-02
 	 4.68137613089583959347095287739648e-01 2.65931193455208048082027971759089e-01 2.65931193455207937059725509243435e-01 1.89769930613772203065181543024664e-02
 	 3.40008157914665265497689006224391e-01 3.29995921042667450517882343774545e-01 3.29995921042667339495579881258891e-01 2.23468612883138857683196221159960e-02
 	 2.22840607043837790612883509311359e-01 3.88579696478081215715860707859974e-01 3.88579696478080993671255782828666e-01 2.31056803371874758257220605628390e-02
 	 1.24619225144442902220021096582059e-01 4.37690387427778659912291914224625e-01 4.37690387427778437867686989193317e-01 2.06386081781567212733996541373926e-02
 	 5.20354511271805542094170959899202e-02 4.73982274436409833917593914520694e-01 4.73982274436409611872988989489386e-01 1.49939832898511489489568049293666e-02
 	 1.00182804616806286901464773109183e-02 4.94990859769159796677229223860195e-01 4.94990859769159574632624298828887e-01 6.92338365863554017209935409482569e-03
 	 9.74726379602479653385671554133296e-01 9.23064449661557817616852616993128e-03 1.60429759009047684381599196967727e-02 2.79536598511580507836482567540770e-04
 	 9.16958386552594983953667906462215e-01 3.03291574417083945047757254087628e-02 5.27124560056966215415563681290223e-02 1.58836989507481424546697645894255e-03
 	 8.30824899622818580091632156836567e-01 6.17875549564806253455273576946638e-02 1.07387545420700794562840485468769e-01 4.37927597110920711898085500024536e-03
 	 7.22203284890967966980213077476947e-01 1.01459255902674544413955004529271e-01 1.76337459206357488605831917993783e-01 8.57834681623889476476119142489551e-03
 	 5.98497279767139067629955206939485e-01 1.46640204948922103778130576756666e-01 2.54862515283938828591914216303849e-01 1.35584440421469866466797071780093e-02
 	 4.68137613089584014858246518997476e-01 1.94251260305117634530347459076438e-01 3.37611126605298350611406021926086e-01 1.82732927798895938842349551123334e-02
 	 3.40008157914665209986537774966564e-01 2.41047779033426001760176404786762e-01 4.18944063051908788253285820246674e-01 2.15182003656856010720410665726376e-02
 	 2.22840607043837735101732278053532e-01 2.83840698750374820225061966993962e-01 4.93318694205787389162054523694678e-01 2.22488810695345880230622270801177e-02
 	 1.24619225144442902220021096582059e-01 3.19713939070490615890207664051559e-01 5.55666835785066481889771239366382e-01 1.98732922855119412131053024950234e-02
 	 5.20354511271805542094170959899202e-02 3.46223596319349402605780596786644e-01 6.01740952553470043184802307223435e-01 1.44379800164367005227417095625242e-02
 	 1.00182804616806286901464773109183e-02 3.61569461259415803056072036270052e-01 6.28412258278903568253781486419030e-01 6.66665241498322867774728450740440e-03
 	 9.74726379602479653385671554133296e-01 6.07709093906260225392834684043919e-03 1.91965294584577443604000990262648e-02 2.48040580385070071837289029659246e-04
 	 9.16958386552594983953667906462215e-01 1.99675166718843721813669844777905e-02 6.30740967755206438649651090599946e-02 1.40940468167071917236776723569847e-03
 	 8.30824899622818469069329694320913e-01 4.06784803066063405108110373475938e-02 1.28496620070575190419859268331493e-01 3.88585308444081576131901023529736e-03
 	 7.22203284890967966980213077476947e-01 6.67967577947830015716590423835441e-02 2.10999957314249031448127880139509e-01 7.61180516030413381600716604680201e-03
 	 5.98497279767139067629955206939485e-01 9.65421061469886598871426031109877e-02 3.04960614085872272482902189949527e-01 1.20307836155962646906836255311646e-02
 	 4.68137613089584014858246518997476e-01 1.27887340297261675736706365569262e-01 4.03975046613154309405047115433263e-01 1.62143997272770519491036367298875e-02
 	 3.40008157914665209986537774966564e-01 1.58696315775382013057992480753455e-01 5.01295526309952776955469744279981e-01 1.90936962672019067133177827599866e-02
 	 2.22840607043837790612883509311359e-01 1.86869480147951350090806954540312e-01 5.90289912808210859296309536148328e-01 1.97420495305094534366219249932328e-02
 	 1.24619225144442902220021096582059e-01 2.10487001522988825819027169927722e-01 6.64893773332568271960951733490219e-01 1.76341236850827073889824703201157e-02
 	 5.20354511271805542094170959899202e-02 2.27939910463828554476606313983211e-01 7.20024638408990891313976590026869e-01 1.28112202907722013550673167969762e-02
 	 1.00182804616806286901464773109183e-02 2.38043020470237065566720957576763e-01 7.51938699068082305743132565112319e-01 5.91550567275527829080861152988291e-03
 	 9.74726379602479653385671554133296e-01 3.41001788807683212101373726454767e-03 2.18636025094435144933147086021563e-02 1.98150804415458823204074234602956e-04
 	 9.16958386552594983953667906462215e-01 1.12043064213386417415918572260125e-02 7.18373070260663743047402363117726e-02 1.12592331055832604522204398733720e-03
 	 8.30824899622818580091632156836567e-01 2.28257807717956451298846332065295e-02 1.46349319605385774778483209956903e-01 3.10426992763392995203219903999070e-03
 	 7.22203284890968078002515539992601e-01 3.74814432151447385344056328904117e-02 2.40315271893887183463078827116988e-01 6.08080062232748547179639331261569e-03
 	 5.98497279767139067629955206939485e-01 5.41723519057005220567191372538218e-02 3.47330368327160410313325655806693e-01 9.61096546169109416934972500712320e-03
 	 4.68137613089584070369397750255303e-01 7.17609992091873816200120472785784e-02 4.60101387701228603521741433723946e-01 1.29531076894187618248066584669687e-02
 	 3.40008157914665209986537774966564e-01 8.90487374621081739789474340796005e-02 5.70943104623226616034514790953835e-01 1.52532753662200024069584003427735e-02
 	 2.22840607043837790612883509311359e-01 1.04857451769254872431247349595651e-01 6.72301941186907336955869141092990e-01 1.57712217460838632909769785328535e-02
 	 1.24619225144442902220021096582059e-01 1.18109873226903361320694330061087e-01 7.57270901628653736459284573356854e-01 1.40872747029387110351272838215664e-02
 	 5.20354511271805542094170959899202e-02 1.27903166150115654708940837736009e-01 8.20061382722703791081642066274071e-01 1.02344285851096936101889411929733e-02
 	 1.00182804616806286901464773109183e-02 1.33572290767884682693988906976301e-01 8.56409428770434688615864615712781e-01 4.72568724746953716664421563109499e-03
 	 9.74726379602479653385671554133296e-01 1.42716849107199852952909679970617e-03 2.38464519064483480847993490669978e-02 1.33575731673385894636776893840135e-04
 	 9.16958386552594983953667906462215e-01 4.68925196690636592045109409809811e-03 7.83523614804986501258809994396870e-02 7.58997827233731355359158676776588e-04
 	 8.30824899622818469069329694320913e-01 9.55309801028522698196354667743435e-03 1.59622002366896303948706759001652e-01 2.09262398968611696564723345659331e-03
 	 7.22203284890968078002515539992601e-01 1.56868193986886006463521425757790e-02 2.62109895710343321351132317431620e-01 4.09913749622914120457339848258016e-03
 	 5.98497279767139067629955206939485e-01 2.26723367045685852971814711054321e-02 3.78830383528292347072863321955083e-01 6.47886213442428696845931668235608e-03
 	 4.68137613089584014858246518997476e-01 3.00335776293989553664687264245003e-02 5.01828809281017029775284754578024e-01 8.73183857195226377501118264490287e-03
 	 3.40008157914665209986537774966564e-01 3.72688814096918674678704519465100e-02 6.22722960675642922545591773086926e-01 1.02824080046960229101182804356540e-02
 	 2.22840607043837790612883509311359e-01 4.38851807031371832223953788343351e-02 7.33274212253025026164721111854305e-01 1.06315616044605626422381305928866e-02
 	 1.24619225144442902220021096582059e-01 4.94316144625885911523255344945937e-02 8.25949160392968506627653368923347e-01 9.49639357397539379812556603610574e-03
 	 5.20354511271805542094170959899202e-02 5.35303258308534868348260715720244e-02 8.94434223041965958955756832438055e-01 6.89914578216261915183382669169987e-03
 	 1.00182804616806286901464773109183e-02 5.59029808408844086642375259543769e-02 9.34078738697434962645615996734705e-01 3.18564001595890693846468977312725e-03
 	 9.74726379602479653385671554133296e-01 2.75120314780604585669365746980475e-04 2.49985000827397420286590801197235e-02 5.92128341032634159359429593116886e-05
 	 9.16958386552594983953667906462215e-01 9.03963677233221574169874656945467e-04 8.21376497701717944721622188808396e-02 3.36456419633318767285073969119935e-04
 	 8.30824899622818469069329694320913e-01 1.84158447174337380758402105129790e-03 1.67333515905438157123086284627789e-01 9.27640040518539561904820534010696e-04
 	 7.22203284890967855957910614961293e-01 3.02400362527061039585873913893010e-03 2.74772711483761533646230645899777e-01 1.81710813401476109843479811445377e-03
 	 5.98497279767139067629955206939485e-01 4.37062648873887127365378546528518e-03 3.97132093744122061096391007595230e-01 2.87201712420053715396628390976730e-03
 	 4.68137613089584014858246518997476e-01 5.78967892234039105403553548967466e-03 5.26072707988075594087717945512850e-01 3.87073985895674578527891895873836e-03
 	 3.40008157914665209986537774966564e-01 7.18445400742673268013049892033450e-03 6.52807388077908057333331726113101e-01 4.55809234010314586610368436936369e-03
 	 2.22840607043837790612883509311359e-01 8.45990140952579405819733437965624e-03 7.68699491546636415328919156308984e-01 4.71286876483549901917236013559886e-03
 	 1.24619225144442902220021096582059e-01 9.52910705087495202292302565183491e-03 8.65851667804682145757055877766106e-01 4.20965972059981607261702762912137e-03
 	 5.20354511271805542094170959899202e-02 1.03192301294645627507406970835291e-02 9.37645318743354883039842206926551e-01 3.05832481346474463479445660141209e-03
 	 1.00182804616806286901464773109183e-02 1.07766152226116407319977952283807e-02 9.79205104315707730577855727460701e-01 1.41216350765665035749130140629859e-03
 	 ];
 
 	 case  21 

 	 % ALG. DEG.:   21
 	 % PTS CARD.:  121
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw_bar=[
 	 9.74726379602479653385671554133296e-01 2.49985000827397454981060320733377e-02 2.75120314780601116222413793366286e-04 5.92128341032636463289046124813808e-05
 	 9.16958386552594983953667906462215e-01 8.21376497701717944721622188808396e-02 9.03963677233221574169874656945467e-04 3.36456419633320122537789576000478e-04
 	 8.30824899622818469069329694320913e-01 1.67333515905438101611935053369962e-01 1.84158447174342931873525230912492e-03 9.27640040518543248192206984725772e-04
 	 7.22203284890968078002515539992601e-01 2.74772711483761422623928183384123e-01 3.02400362527049937355627662327606e-03 1.81710813401476847100957101588392e-03
 	 5.98497279767139067629955206939485e-01 3.97132093744122061096391007595230e-01 4.37062648873887127365378546528518e-03 2.87201712420054886334974675321519e-03
 	 4.68137613089584014858246518997476e-01 5.26072707988075594087717945512850e-01 5.78967892234039105403553548967466e-03 3.87073985895676139779020275000221e-03
 	 3.40008157914665209986537774966564e-01 6.52807388077908057333331726113101e-01 7.18445400742673268013049892033450e-03 4.55809234010316408070018212583818e-03
 	 2.22840607043837790612883509311359e-01 7.68699491546636415328919156308984e-01 8.45990140952579405819733437965624e-03 4.71286876483551810113059588047690e-03
 	 1.24619225144442902220021096582059e-01 8.65851667804682145757055877766106e-01 9.52910705087495202292302565183491e-03 4.20965972059983341985178739719231e-03
 	 5.20354511271805542094170959899202e-02 9.37645318743354883039842206926551e-01 1.03192301294645627507406970835291e-02 3.05832481346475677785878843906175e-03
 	 1.00182804616806286901464773109183e-02 9.79205104315707730577855727460701e-01 1.07766152226116407319977952283807e-02 1.41216350765665599534259833092165e-03
 	 9.74726379602479653385671554133296e-01 2.38464519064483515542463010206120e-02 1.42716849107199506008214484609198e-03 1.33575731673385650691288084601638e-04
 	 9.16958386552594983953667906462215e-01 7.83523614804986640036688072541438e-02 4.68925196690635204266328628364136e-03 7.58997827233729945896334445620823e-04
 	 8.30824899622818469069329694320913e-01 1.59622002366896276193131143372739e-01 9.55309801028525473753916230634786e-03 2.09262398968611349620028150297912e-03
 	 7.22203284890968078002515539992601e-01 2.62109895710343432373434779947274e-01 1.56868193986884896240496800601250e-02 4.09913749622913426567949457535178e-03
 	 5.98497279767139067629955206939485e-01 3.78830383528292347072863321955083e-01 2.26723367045685852971814711054321e-02 6.47886213442427569275672283310996e-03
 	 4.68137613089584014858246518997476e-01 5.01828809281017029775284754578024e-01 3.00335776293989553664687264245003e-02 8.73183857195224816249989885363902e-03
 	 3.40008157914665209986537774966564e-01 6.22722960675643033567894235602580e-01 3.72688814096917564455679894308560e-02 1.02824080046960055628835206675831e-02
 	 2.22840607043837790612883509311359e-01 7.33274212253025026164721111854305e-01 4.38851807031371832223953788343351e-02 1.06315616044605435602798948480086e-02
 	 1.24619225144442902220021096582059e-01 8.25949160392968617649955831439001e-01 4.94316144625884801300230719789397e-02 9.49639357397537645089080626803479e-03
 	 5.20354511271805542094170959899202e-02 8.94434223041966069978059294953709e-01 5.35303258308533758125236090563703e-02 6.89914578216260700876949485405021e-03
 	 1.00182804616806286901464773109183e-02 9.34078738697435073667918459250359e-01 5.59029808408842976419350634387229e-02 3.18564001595890130061339284850419e-03
 	 9.74726379602479653385671554133296e-01 2.18636025094435144933147086021563e-02 3.41001788807683212101373726454767e-03 1.98150804415459690565812223006503e-04
 	 9.16958386552594983953667906462215e-01 7.18373070260663604269524284973159e-02 1.12043064213386556193796650404693e-02 1.12592331055833103255203742065760e-03
 	 8.30824899622818469069329694320913e-01 1.46349319605385830289634441214730e-01 2.28257807717957006410358644643566e-02 3.10426992763394339613913786024568e-03
 	 7.22203284890968078002515539992601e-01 2.40315271893887294485381289632642e-01 3.74814432151446275121031703747576e-02 6.08080062232751149264853296472211e-03
 	 5.98497279767139067629955206939485e-01 3.47330368327160410313325655806693e-01 5.41723519057005220567191372538218e-02 9.61096546169113580271314845049346e-03
 	 4.68137613089584070369397750255303e-01 4.60101387701228603521741433723946e-01 7.17609992091873816200120472785784e-02 1.29531076894188173359578897247957e-02
 	 3.40008157914665209986537774966564e-01 5.70943104623226616034514790953835e-01 8.90487374621081739789474340796005e-02 1.52532753662200683264504874614431e-02
 	 2.22840607043837790612883509311359e-01 6.72301941186907336955869141092990e-01 1.04857451769254872431247349595651e-01 1.57712217460839292104690656515231e-02
 	 1.24619225144442902220021096582059e-01 7.57270901628653736459284573356854e-01 1.18109873226903361320694330061087e-01 1.40872747029387717504489430098147e-02
 	 5.20354511271805542094170959899202e-02 8.20061382722703680059339603758417e-01 1.27903166150115765731243300251663e-01 1.02344285851097369782758406131506e-02
 	 1.00182804616806286901464773109183e-02 8.56409428770434688615864615712781e-01 1.33572290767884682693988906976301e-01 4.72568724746955711596418936437658e-03
 	 9.74726379602479653385671554133296e-01 1.91965294584577408909531470726506e-02 6.07709093906260572337529879405338e-03 2.48040580385069041845225168430034e-04
 	 9.16958386552594983953667906462215e-01 6.30740967755206438649651090599946e-02 1.99675166718843721813669844777905e-02 1.40940468167071331767603581397452e-03
 	 8.30824899622818469069329694320913e-01 1.28496620070575107153132421444752e-01 4.06784803066064237775378842343343e-02 3.88585308444079971512685744983173e-03
 	 7.22203284890968078002515539992601e-01 2.10999957314248975936976648881682e-01 6.67967577947829460605078111257171e-02 7.61180516030410259098459846427431e-03
 	 5.98497279767139067629955206939485e-01 3.04960614085872272482902189949527e-01 9.65421061469886598871426031109877e-02 1.20307836155962143837028222037588e-02
 	 4.68137613089584014858246518997476e-01 4.03975046613154309405047115433263e-01 1.27887340297261675736706365569262e-01 1.62143997272769825601645976576037e-02
 	 3.40008157914665209986537774966564e-01 5.01295526309952665933167281764327e-01 1.58696315775382124080294943269109e-01 1.90936962672018303854848397804744e-02
 	 2.22840607043837790612883509311359e-01 5.90289912808210748274007073632674e-01 1.86869480147951461113109417055966e-01 1.97420495305093701698950781064923e-02
 	 1.24619225144442902220021096582059e-01 6.64893773332568160938649270974565e-01 2.10487001522988936841329632443376e-01 1.76341236850826345305964792942177e-02
 	 5.20354511271805542094170959899202e-02 7.20024638408990780291674127511214e-01 2.27939910463828665498908776498865e-01 1.28112202907721475786395615159563e-02
 	 1.00182804616806286901464773109183e-02 7.51938699068082194720830102596665e-01 2.38043020470237176589023420092417e-01 5.91550567275525313731820986618004e-03
 	 9.74726379602479653385671554133296e-01 1.60429759009047684381599196967727e-02 9.23064449661557817616852616993128e-03 2.79536598511580833097134313192100e-04
 	 9.16958386552594983953667906462215e-01 5.27124560056966284804502720362507e-02 3.03291574417083875658818215015344e-02 1.58836989507481598019045243574965e-03
 	 8.30824899622818580091632156836567e-01 1.07387545420700850073991716726596e-01 6.17875549564805698343761264368368e-02 4.37927597110921232315128293066664e-03
 	 7.22203284890967966980213077476947e-01 1.76337459206357488605831917993783e-01 1.01459255902674544413955004529271e-01 8.57834681623890343837857130893099e-03
 	 5.98497279767139067629955206939485e-01 2.54862515283938828591914216303849e-01 1.46640204948922103778130576756666e-01 1.35584440421470005244675149924660e-02
 	 4.68137613089584014858246518997476e-01 3.37611126605298350611406021926086e-01 1.94251260305117634530347459076438e-01 1.82732927798896147009166668340185e-02
 	 3.40008157914665209986537774966564e-01 4.18944063051908788253285820246674e-01 2.41047779033426001760176404786762e-01 2.15182003656856218887227782943228e-02
 	 2.22840607043837846124034740569186e-01 4.93318694205787389162054523694678e-01 2.83840698750374820225061966993962e-01 2.22488810695346123091908907554171e-02
 	 1.24619225144442902220021096582059e-01 5.55666835785066481889771239366382e-01 3.19713939070490615890207664051559e-01 1.98732922855119620297870142167085e-02
 	 5.20354511271805542094170959899202e-02 6.01740952553470043184802307223435e-01 3.46223596319349402605780596786644e-01 1.44379800164367144005295173769809e-02
 	 1.00182804616806286901464773109183e-02 6.28412258278903568253781486419030e-01 3.61569461259415803056072036270052e-01 6.66665241498323561664118841463278e-03
 	 9.74726379602479653385671554133296e-01 1.26368101987601767766111748869662e-02 1.26368101987601698377172709797378e-02 2.90301488311583034008372949941190e-04
 	 9.16958386552594983953667906462215e-01 4.15208067237025149620599506761209e-02 4.15208067237025010842721428616642e-02 1.64953765261770918769401728098956e-03
 	 8.30824899622818469069329694320913e-01 8.45875501885907515875473450250865e-02 8.45875501885907793431229606540001e-02 4.54792087658421103485428815815794e-03
 	 7.22203284890967966980213077476947e-01 1.38898357554516044265469076890440e-01 1.38898357554515988754317845632613e-01 8.90869696943784490639206552486939e-03
 	 5.98497279767139067629955206939485e-01 2.00751360116430521696173627788085e-01 2.00751360116430410673871165272431e-01 1.40805765884767508655528445160598e-02
 	 4.68137613089583959347095287739648e-01 2.65931193455208048082027971759089e-01 2.65931193455207937059725509243435e-01 1.89769930613772203065181543024664e-02
 	 3.40008157914665265497689006224391e-01 3.29995921042667450517882343774545e-01 3.29995921042667339495579881258891e-01 2.23468612883138857683196221159960e-02
 	 2.22840607043837790612883509311359e-01 3.88579696478081215715860707859974e-01 3.88579696478080993671255782828666e-01 2.31056803371874758257220605628390e-02
 	 1.24619225144442902220021096582059e-01 4.37690387427778659912291914224625e-01 4.37690387427778437867686989193317e-01 2.06386081781567212733996541373926e-02
 	 5.20354511271805542094170959899202e-02 4.73982274436409833917593914520694e-01 4.73982274436409611872988989489386e-01 1.49939832898511489489568049293666e-02
 	 1.00182804616806286901464773109183e-02 4.94990859769159796677229223860195e-01 4.94990859769159574632624298828887e-01 6.92338365863554017209935409482569e-03
 	 9.74726379602479653385671554133296e-01 9.23064449661557817616852616993128e-03 1.60429759009047684381599196967727e-02 2.79536598511580507836482567540770e-04
 	 9.16958386552594983953667906462215e-01 3.03291574417083945047757254087628e-02 5.27124560056966215415563681290223e-02 1.58836989507481424546697645894255e-03
 	 8.30824899622818580091632156836567e-01 6.17875549564806253455273576946638e-02 1.07387545420700794562840485468769e-01 4.37927597110920711898085500024536e-03
 	 7.22203284890967966980213077476947e-01 1.01459255902674544413955004529271e-01 1.76337459206357488605831917993783e-01 8.57834681623889476476119142489551e-03
 	 5.98497279767139067629955206939485e-01 1.46640204948922103778130576756666e-01 2.54862515283938828591914216303849e-01 1.35584440421469866466797071780093e-02
 	 4.68137613089584014858246518997476e-01 1.94251260305117634530347459076438e-01 3.37611126605298350611406021926086e-01 1.82732927798895938842349551123334e-02
 	 3.40008157914665209986537774966564e-01 2.41047779033426001760176404786762e-01 4.18944063051908788253285820246674e-01 2.15182003656856010720410665726376e-02
 	 2.22840607043837735101732278053532e-01 2.83840698750374820225061966993962e-01 4.93318694205787389162054523694678e-01 2.22488810695345880230622270801177e-02
 	 1.24619225144442902220021096582059e-01 3.19713939070490615890207664051559e-01 5.55666835785066481889771239366382e-01 1.98732922855119412131053024950234e-02
 	 5.20354511271805542094170959899202e-02 3.46223596319349402605780596786644e-01 6.01740952553470043184802307223435e-01 1.44379800164367005227417095625242e-02
 	 1.00182804616806286901464773109183e-02 3.61569461259415803056072036270052e-01 6.28412258278903568253781486419030e-01 6.66665241498322867774728450740440e-03
 	 9.74726379602479653385671554133296e-01 6.07709093906260225392834684043919e-03 1.91965294584577443604000990262648e-02 2.48040580385070071837289029659246e-04
 	 9.16958386552594983953667906462215e-01 1.99675166718843721813669844777905e-02 6.30740967755206438649651090599946e-02 1.40940468167071917236776723569847e-03
 	 8.30824899622818469069329694320913e-01 4.06784803066063405108110373475938e-02 1.28496620070575190419859268331493e-01 3.88585308444081576131901023529736e-03
 	 7.22203284890967966980213077476947e-01 6.67967577947830015716590423835441e-02 2.10999957314249031448127880139509e-01 7.61180516030413381600716604680201e-03
 	 5.98497279767139067629955206939485e-01 9.65421061469886598871426031109877e-02 3.04960614085872272482902189949527e-01 1.20307836155962646906836255311646e-02
 	 4.68137613089584014858246518997476e-01 1.27887340297261675736706365569262e-01 4.03975046613154309405047115433263e-01 1.62143997272770519491036367298875e-02
 	 3.40008157914665209986537774966564e-01 1.58696315775382013057992480753455e-01 5.01295526309952776955469744279981e-01 1.90936962672019067133177827599866e-02
 	 2.22840607043837790612883509311359e-01 1.86869480147951350090806954540312e-01 5.90289912808210859296309536148328e-01 1.97420495305094534366219249932328e-02
 	 1.24619225144442902220021096582059e-01 2.10487001522988825819027169927722e-01 6.64893773332568271960951733490219e-01 1.76341236850827073889824703201157e-02
 	 5.20354511271805542094170959899202e-02 2.27939910463828554476606313983211e-01 7.20024638408990891313976590026869e-01 1.28112202907722013550673167969762e-02
 	 1.00182804616806286901464773109183e-02 2.38043020470237065566720957576763e-01 7.51938699068082305743132565112319e-01 5.91550567275527829080861152988291e-03
 	 9.74726379602479653385671554133296e-01 3.41001788807683212101373726454767e-03 2.18636025094435144933147086021563e-02 1.98150804415458823204074234602956e-04
 	 9.16958386552594983953667906462215e-01 1.12043064213386417415918572260125e-02 7.18373070260663743047402363117726e-02 1.12592331055832604522204398733720e-03
 	 8.30824899622818580091632156836567e-01 2.28257807717956451298846332065295e-02 1.46349319605385774778483209956903e-01 3.10426992763392995203219903999070e-03
 	 7.22203284890968078002515539992601e-01 3.74814432151447385344056328904117e-02 2.40315271893887183463078827116988e-01 6.08080062232748547179639331261569e-03
 	 5.98497279767139067629955206939485e-01 5.41723519057005220567191372538218e-02 3.47330368327160410313325655806693e-01 9.61096546169109416934972500712320e-03
 	 4.68137613089584070369397750255303e-01 7.17609992091873816200120472785784e-02 4.60101387701228603521741433723946e-01 1.29531076894187618248066584669687e-02
 	 3.40008157914665209986537774966564e-01 8.90487374621081739789474340796005e-02 5.70943104623226616034514790953835e-01 1.52532753662200024069584003427735e-02
 	 2.22840607043837790612883509311359e-01 1.04857451769254872431247349595651e-01 6.72301941186907336955869141092990e-01 1.57712217460838632909769785328535e-02
 	 1.24619225144442902220021096582059e-01 1.18109873226903361320694330061087e-01 7.57270901628653736459284573356854e-01 1.40872747029387110351272838215664e-02
 	 5.20354511271805542094170959899202e-02 1.27903166150115654708940837736009e-01 8.20061382722703791081642066274071e-01 1.02344285851096936101889411929733e-02
 	 1.00182804616806286901464773109183e-02 1.33572290767884682693988906976301e-01 8.56409428770434688615864615712781e-01 4.72568724746953716664421563109499e-03
 	 9.74726379602479653385671554133296e-01 1.42716849107199852952909679970617e-03 2.38464519064483480847993490669978e-02 1.33575731673385894636776893840135e-04
 	 9.16958386552594983953667906462215e-01 4.68925196690636592045109409809811e-03 7.83523614804986501258809994396870e-02 7.58997827233731355359158676776588e-04
 	 8.30824899622818469069329694320913e-01 9.55309801028522698196354667743435e-03 1.59622002366896303948706759001652e-01 2.09262398968611696564723345659331e-03
 	 7.22203284890968078002515539992601e-01 1.56868193986886006463521425757790e-02 2.62109895710343321351132317431620e-01 4.09913749622914120457339848258016e-03
 	 5.98497279767139067629955206939485e-01 2.26723367045685852971814711054321e-02 3.78830383528292347072863321955083e-01 6.47886213442428696845931668235608e-03
 	 4.68137613089584014858246518997476e-01 3.00335776293989553664687264245003e-02 5.01828809281017029775284754578024e-01 8.73183857195226377501118264490287e-03
 	 3.40008157914665209986537774966564e-01 3.72688814096918674678704519465100e-02 6.22722960675642922545591773086926e-01 1.02824080046960229101182804356540e-02
 	 2.22840607043837790612883509311359e-01 4.38851807031371832223953788343351e-02 7.33274212253025026164721111854305e-01 1.06315616044605626422381305928866e-02
 	 1.24619225144442902220021096582059e-01 4.94316144625885911523255344945937e-02 8.25949160392968506627653368923347e-01 9.49639357397539379812556603610574e-03
 	 5.20354511271805542094170959899202e-02 5.35303258308534868348260715720244e-02 8.94434223041965958955756832438055e-01 6.89914578216261915183382669169987e-03
 	 1.00182804616806286901464773109183e-02 5.59029808408844086642375259543769e-02 9.34078738697434962645615996734705e-01 3.18564001595890693846468977312725e-03
 	 9.74726379602479653385671554133296e-01 2.75120314780604585669365746980475e-04 2.49985000827397420286590801197235e-02 5.92128341032634159359429593116886e-05
 	 9.16958386552594983953667906462215e-01 9.03963677233221574169874656945467e-04 8.21376497701717944721622188808396e-02 3.36456419633318767285073969119935e-04
 	 8.30824899622818469069329694320913e-01 1.84158447174337380758402105129790e-03 1.67333515905438157123086284627789e-01 9.27640040518539561904820534010696e-04
 	 7.22203284890967855957910614961293e-01 3.02400362527061039585873913893010e-03 2.74772711483761533646230645899777e-01 1.81710813401476109843479811445377e-03
 	 5.98497279767139067629955206939485e-01 4.37062648873887127365378546528518e-03 3.97132093744122061096391007595230e-01 2.87201712420053715396628390976730e-03
 	 4.68137613089584014858246518997476e-01 5.78967892234039105403553548967466e-03 5.26072707988075594087717945512850e-01 3.87073985895674578527891895873836e-03
 	 3.40008157914665209986537774966564e-01 7.18445400742673268013049892033450e-03 6.52807388077908057333331726113101e-01 4.55809234010314586610368436936369e-03
 	 2.22840607043837790612883509311359e-01 8.45990140952579405819733437965624e-03 7.68699491546636415328919156308984e-01 4.71286876483549901917236013559886e-03
 	 1.24619225144442902220021096582059e-01 9.52910705087495202292302565183491e-03 8.65851667804682145757055877766106e-01 4.20965972059981607261702762912137e-03
 	 5.20354511271805542094170959899202e-02 1.03192301294645627507406970835291e-02 9.37645318743354883039842206926551e-01 3.05832481346474463479445660141209e-03
 	 1.00182804616806286901464773109183e-02 1.07766152226116407319977952283807e-02 9.79205104315707730577855727460701e-01 1.41216350765665035749130140629859e-03
 	 ];
 
 	 case  22 

 	 % ALG. DEG.:   22
 	 % PTS CARD.:  144
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.0e-16  

 	 xyw_bar=[
 	 9.78437936834149701859075776155805e-01 2.13632677812950685924953120320424e-02 1.98795384555229548428911812152364e-04 3.65694820335950887307992218655528e-05
 	 9.28942101264410902139445624925429e-01 7.04027674433664873987481769290753e-02 6.55131292222610461806198145495728e-04 2.09685302934051117111288742300701e-04
 	 8.54552543764935834680329662660370e-01 1.44106476813362832656295609012886e-01 1.34097942170133266337472832674393e-03 5.86672915731718531799632199152938e-04
 	 7.59598889525226916852318481687689e-01 2.38184688473003419728613039296761e-01 2.21642200176966341906847901555011e-03 1.17357048402049021947057827475192e-03
 	 6.49600650277254998421483378479024e-01 3.47168778838120251073462441127049e-01 3.23057088462475050505418039392680e-03 1.90832037101434774141461847563050e-03
 	 5.30950849312817774183770325180376e-01 4.64724666264288877037813563219970e-01 4.32448442289334877841611159965396e-03 2.67077712132569476330412605591391e-03
 	 4.10545081201457717767766553151887e-01 5.84020331377143930851048025942873e-01 5.43458742139835138118542090523988e-03 3.30743169822454111811405041976286e-03
 	 2.95380884262580245547269441885874e-01 6.98122750941501890586948775307974e-01 6.49636479591786386578178280615248e-03 3.66534988176569218390477011837447e-03
 	 1.92151054529854037333791438868502e-01 8.00400834380682879576340837957105e-01 7.44811108946308308986772317439318e-03 3.62762309841088573594825028578725e-03
 	 1.06854490883476538343188622093294e-01 8.84910990759773530278664566139923e-01 8.23451835674993137814681176678278e-03 3.14219586642582992402905617268516e-03
 	 4.44464631554077893582643810077570e-02 9.46743636263232879457518720300868e-01 8.80990058135933118421689869137481e-03 2.23742487126401884064974545651694e-03
 	 8.53905498842744137277804838959128e-03 9.82319989513991576046691989176907e-01 9.14095549758098258052996243350208e-03 1.02204710010515842366629613024998e-03
 	 9.78437936834149701859075776155805e-01 2.05283482785228732492299741352326e-02 1.03371488732742489169424970896216e-03 8.28974642306667822491683672581075e-05
 	 9.28942101264410902139445624925429e-01 6.76512855919304129104219214241311e-02 3.40661314365868495013245365043986e-03 4.75324749847521970096825283391695e-04
 	 8.54552543764935834680329662660370e-01 1.38474505656187546476232341774448e-01 6.97295057887661884343799556518206e-03 1.32989843832879766835630697130455e-03
 	 7.59598889525226916852318481687689e-01 2.28875951452820108888985828343721e-01 1.15251590219529742586956899685902e-02 2.66030612990038198631403965066511e-03
 	 6.49600650277254998421483378479024e-01 3.33600724214035859738203271263046e-01 1.67986255087091418403133502579294e-02 4.32587258281335804155354196609551e-03
 	 5.30950849312817885206072787696030e-01 4.46562290954689411481837169048958e-01 2.24868597324927033120900432550116e-02 6.05424628874390562821572459029085e-03
 	 4.10545081201457717767766553151887e-01 5.61195641368380626623491025384283e-01 2.82592774301616556087424214638304e-02 7.49744556532315822861001208821108e-03
 	 2.95380884262580245547269441885874e-01 6.70838708722062859735046913556289e-01 3.37804070153568947176836445578374e-02 8.30879175257160165757319703061512e-03
 	 1.92151054529854037333791438868502e-01 7.69119558805197778283968546020333e-01 3.87293866649481843822400151111651e-02 8.22327086193333327279741951087999e-03
 	 1.06854490883476538343188622093294e-01 8.50326888179282813773340876650764e-01 4.28186209372406478834705012559425e-02 7.12288101875466726775609771493691e-03
 	 4.44464631554077893582643810077570e-02 9.09742989445814109750187981262570e-01 4.58105473987781008915476377296727e-02 5.07190252418730520150846885485407e-03
 	 8.53905498842744137277804838959128e-03 9.43928947206956858728688075643731e-01 4.75319978046156998985338759666774e-02 2.31682562102438665066483913790307e-03
 	 9.78437936834149701859075776155805e-01 1.90813766291924764850751472522461e-02 2.48068653665782165584907659194869e-03 1.24089874244278855356174440238703e-04
 	 9.28942101264411013161748087441083e-01 6.28827824973735710623046202272235e-02 8.17511623821541577594729233169346e-03 7.11517402627043736573764221020610e-04
 	 8.54552543764935834680329662660370e-01 1.28713920872599585365492202981841e-01 1.67335353624645799541781343577895e-02 1.99073556111061195431077841533352e-03
 	 7.59598889525227027874620944203343e-01 2.12743284154290612786297742786701e-01 2.76578263204823593390813130099559e-02 3.98223342745507302709029318066314e-03
 	 6.49600650277254998421483378479024e-01 3.10086373055115882557686290965648e-01 4.03129766676291190208303305553272e-02 6.47543311221699096486004165740269e-03
 	 5.30950849312817885206072787696030e-01 4.15085673064905569251692440957413e-01 5.39634776222765455422347713465570e-02 9.06264947409815731227400448233311e-03
 	 4.10545081201457717767766553151887e-01 5.21638918549263363999557441275101e-01 6.78160002492789182326760055730119e-02 1.12229859620977881484726879079972e-02
 	 2.95380884262580245547269441885874e-01 6.23553628616042687760057106061140e-01 8.10654871213770666926734520529862e-02 1.24374965298045050965392022135347e-02
 	 1.92151054529854037333791438868502e-01 7.14907004466330153746866926667280e-01 9.29419410038158089193416344642173e-02 1.23094796276827216779947704594633e-02
 	 1.06854490883476538343188622093294e-01 7.90390312514984261227368733671028e-01 1.02755196601539200429442644235678e-01 1.06622973100213239844302748338123e-02
 	 4.44464631554077893582643810077570e-02 8.45618380098534849764746468281373e-01 1.09935156746057360876989150710870e-01 7.59217127142009385459830994591357e-03
 	 8.53905498842744137277804838959128e-03 8.77394688967597313755675259017153e-01 1.14066256043975244871546692593256e-01 3.46807471889453355559651548389866e-03
 	 9.78437936834149701859075776155805e-01 1.71129249973081612457015410200256e-02 4.44913816854213689522268282416917e-03 1.57491777069450859674951126443432e-04
 	 9.28942101264410902139445624925429e-01 5.63957392284404127047459098776017e-02 1.46621595071486851558084651969693e-02 9.03040162124586136098425281915070e-04
 	 8.54552543764935834680329662660370e-01 1.15435679343617189629433994468855e-01 3.00117768914469756902363428707758e-02 2.52659198104647660099164596658738e-03
 	 7.59598889525226916852318481687689e-01 1.90796499443523920325205267545243e-01 4.96046110312491628224762507670675e-02 5.05415146090524083910544561604183e-03
 	 6.49600650277254998421483378479024e-01 2.78097589492634300611939579539467e-01 7.23017602301107009665770419815090e-02 8.21845839032621719444371422014228e-03
 	 5.30950849312817885206072787696030e-01 3.72265069164326722894742260905332e-01 9.67840815228553918991849513986381e-02 1.15020889442076952591254013213984e-02
 	 4.10545081201457717767766553151887e-01 4.67826187925743153250834893697174e-01 1.21628730872799128981398553150939e-01 1.42439341965710213749884971434767e-02
 	 2.95380884262580245547269441885874e-01 5.59227286671783230254106911161216e-01 1.45391829065636524198623646952910e-01 1.57853607532715371764009404387252e-02
 	 1.92151054529854037333791438868502e-01 6.41156567748136674289582970232004e-01 1.66692377722009288376625590899494e-01 1.56228848902498981821018730897777e-02
 	 1.06854490883476538343188622093294e-01 7.08852951205559689284996238711756e-01 1.84292557910963772371815139194950e-01 1.35323221272061564729449756327995e-02
 	 4.44464631554077893582643810077570e-02 7.58383642657750045579234665638069e-01 1.97169894186842165062500953354174e-01 9.63579464185580422674881617695064e-03
 	 8.53905498842744137277804838959128e-03 7.86881879495422986714459057111526e-01 2.04579065516149571912762894498883e-01 4.40159403669891646782019734018832e-03
 	 9.78437936834149701859075776155805e-01 1.47466345908192283942206302072009e-02 6.81542857503106974670359363699390e-03 1.80999263046255912589996284189908e-04
 	 9.28942101264410902139445624925429e-01 4.85976160715808208623300856743299e-02 2.24602826640082769982242894002411e-02 1.03782944663608324778469871318975e-03
 	 8.54552543764935834680329662660370e-01 9.94738060437400095636917285446543e-02 4.59736501913241557559786087949760e-02 2.90371532468216772548963433564495e-03
 	 7.59598889525226916852318481687689e-01 1.64414105650767944366563710900664e-01 7.59870048240051387811178074116469e-02 5.80854255866703438060394404374165e-03
 	 6.49600650277254998421483378479024e-01 2.39643633889624924071526379520947e-01 1.10755715833120077506990242000029e-01 9.44515923119839881372250545155111e-03
 	 5.30950849312817774183770325180376e-01 3.20790101444135888897335462388583e-01 1.48259049243046336918894212431042e-01 1.32189099718902532132336347103774e-02
 	 4.10545081201457717767766553151887e-01 4.03137502586030316287235564232105e-01 1.86317416212511965944997882616008e-01 1.63700076310765545162251299871059e-02
 	 2.95380884262580245547269441885874e-01 4.81900110650943513945776430773549e-01 2.22719005086476240506954127340578e-01 1.81415100929459699452550580645038e-02
 	 1.92151054529853926311488976352848e-01 5.52500617023264473104404714831617e-01 2.55348328446881600584106308815535e-01 1.79547828109447478450722002207840e-02
 	 1.06854490883476538343188622093294e-01 6.10836280279173582385965346475132e-01 2.82309228837349879270846031431574e-01 1.55521791543995601542205164946608e-02
 	 4.44464631554077893582643810077570e-02 6.53518113337575590193750940670725e-01 3.02035423507016620447984678321518e-01 1.10740494614640083703704931394896e-02
 	 8.53905498842744137277804838959128e-03 6.78075755306665750588024366152240e-01 3.13385189704906808039197585458169e-01 5.05858332222625019930495327002973e-03
 	 9.78437936834149701859075776155805e-01 1.21311769153246654801003856505304e-02 9.43088625052563266082383819366441e-03 1.93134360313782741259275299583464e-04
 	 9.28942101264411013161748087441083e-01 3.99783607979548316624374137973064e-02 3.10795379376341551758144987616106e-02 1.10741073149918161852567344283216e-03
 	 8.54552543764935834680329662660370e-01 8.18311684693519975075659544927476e-02 6.36162877657121678121043828468828e-02 3.09839494552250922093650231659012e-03
 	 7.59598889525227027874620944203343e-01 1.35253680474735543670661286341783e-01 1.05147430000037428454717769454874e-01 6.19797634831721708931207004411590e-03
 	 6.49600650277254887399180915963370e-01 1.97140527314363322997081695575616e-01 1.53258822408381789603737388461013e-01 1.00784100193443137971627265869756e-02
 	 5.30950849312817774183770325180376e-01 2.63894887293573909836652546800906e-01 2.05154263393608315979577128018718e-01 1.41051719134019908769017703775717e-02
 	 4.10545081201457773278917784409714e-01 3.31637183721767481170417113389703e-01 2.57817735076774801061816333458410e-01 1.74675349443369591628805181926509e-02
 	 2.95380884262580245547269441885874e-01 3.96430484651777104154746211861493e-01 3.08188631085642650297984346252633e-01 1.93578078051717811236542843289499e-02
 	 1.92151054529854092844942670126329e-01 4.54509311236884150364545575939701e-01 3.53339634233261701279360522676143e-01 1.91585613908191385035273412995593e-02
 	 1.06854490883476538343188622093294e-01 5.02498582759948630993562801450025e-01 3.90646926356574830663248576456681e-01 1.65948751498656357772354397184245e-02
 	 4.44464631554077893582643810077570e-02 5.37610381639415102483781083719805e-01 4.17943155205177108157954535272438e-01 1.18165092101864422496904083459413e-02
 	 8.53905498842744137277804838959128e-03 5.57812489280687051618201621749904e-01 4.33648455730885507009020329860505e-01 5.39773608792241087195318272051736e-03
 	 9.78437936834149701859075776155805e-01 9.43088625052563613027079014727860e-03 1.21311769153246620106534336969162e-02 1.93134360313782551523895114620188e-04
 	 9.28942101264411013161748087441083e-01 3.10795379376342176258596339266660e-02 3.99783607979547692123922786322510e-02 1.10741073149918053432350095732772e-03
 	 8.54552543764935834680329662660370e-01 6.36162877657121955676799984757963e-02 8.18311684693519697519903388638340e-02 3.09839494552250618517041935717771e-03
 	 7.59598889525227027874620944203343e-01 1.05147430000037511721444616341614e-01 1.35253680474735460403934439455043e-01 6.19797634831721101777990412529107e-03
 	 6.49600650277254998421483378479024e-01 1.53258822408381734092586157203186e-01 1.97140527314363267485930464317789e-01 1.00784100193443033888218707261331e-02
 	 5.30950849312817774183770325180376e-01 2.05154263393608427001879590534372e-01 2.63894887293573798814350084285252e-01 1.41051719134019769991139625631149e-02
 	 4.10545081201457717767766553151887e-01 2.57817735076774856572967564716237e-01 3.31637183721767425659265882131876e-01 1.74675349443369418156457584245800e-02
 	 2.95380884262580245547269441885874e-01 3.08188631085642761320286808768287e-01 3.96430484651776993132443749345839e-01 1.93578078051717603069725726072647e-02
 	 1.92151054529853981822640207610675e-01 3.53339634233261923323965447707451e-01 4.54509311236884150364545575939701e-01 1.91585613908191176868456295778742e-02
 	 1.06854490883476538343188622093294e-01 3.90646926356575052707853501487989e-01 5.02498582759948408948957876418717e-01 1.65948751498656184300006799503535e-02
 	 4.44464631554077893582643810077570e-02 4.17943155205177219180256997788092e-01 5.37610381639414991461478621204151e-01 1.18165092101864301066260765082916e-02
 	 8.53905498842744137277804838959128e-03 4.33648455730885729053625254891813e-01 5.57812489280686829573596696718596e-01 5.39773608792240480042101680169253e-03
 	 9.78437936834149701859075776155805e-01 6.81542857503106627725664168337971e-03 1.47466345908192318636675821608151e-02 1.80999263046256779951734272593455e-04
 	 9.28942101264410902139445624925429e-01 2.24602826640082076092852503279573e-02 4.85976160715808902512691247466137e-02 1.03782944663608823511469214651015e-03
 	 8.54552543764935834680329662660370e-01 4.59736501913241418781908009805193e-02 9.94738060437400234414795363591111e-02 2.90371532468218160327744215010171e-03
 	 7.59598889525227027874620944203343e-01 7.59870048240050555143909605249064e-02 1.64414105650767916610988095271750e-01 5.80854255866706300354129766105871e-03
 	 6.49600650277254998421483378479024e-01 1.10755715833120049751414626371115e-01 2.39643633889624951827101995149860e-01 9.44515923119844391653288084853557e-03
 	 5.30950849312817885206072787696030e-01 1.48259049243046281407742981173215e-01 3.20790101444135833386184231130756e-01 1.32189099718903173980022458522399e-02
 	 4.10545081201457662256615321894060e-01 1.86317416212511910433846651358181e-01 4.03137502586030371798386795489932e-01 1.63700076310766343135050249202322e-02
 	 2.95380884262580301058420673143701e-01 2.22719005086476184995802896082751e-01 4.81900110650943569456927662031376e-01 1.81415100929460566814288569048585e-02
 	 1.92151054529854037333791438868502e-01 2.55348328446881489561803846299881e-01 5.52500617023264473104404714831617e-01 1.79547828109448345812459990611387e-02
 	 1.06854490883476538343188622093294e-01 2.82309228837349879270846031431574e-01 6.10836280279173582385965346475132e-01 1.55521791543996364820534594741730e-02
 	 4.44464631554077893582643810077570e-02 3.02035423507016398403379753290210e-01 6.53518113337575812238355865702033e-01 1.10740494614640621467982484205095e-02
 	 8.53905498842744137277804838959128e-03 3.13385189704906697016895122942515e-01 6.78075755306665861610326828667894e-01 5.05858332222627448543361694532905e-03
 	 9.78437936834149701859075776155805e-01 4.44913816854213342577573087055498e-03 1.71129249973081647151484929736398e-02 1.57491777069450236258701947278382e-04
 	 9.28942101264410902139445624925429e-01 1.46621595071486227057633300319139e-02 5.63957392284404751547910450426571e-02 9.03040162124582666651473328300881e-04
 	 8.54552543764935834680329662660370e-01 3.00117768914469479346607272418623e-02 1.15435679343617217385009610097768e-01 2.52659198104646662633165909994659e-03
 	 7.59598889525227027874620944203343e-01 4.96046110312490518001737882514135e-02 1.90796499443523920325205267545243e-01 5.05415146090522175714720987116380e-03
 	 6.49600650277255109443785840994678e-01 7.23017602301106454554258107236819e-02 2.78097589492634245100788348281640e-01 8.21845839032618596942114663761458e-03
 	 5.30950849312817885206072787696030e-01 9.67840815228553918991849513986381e-02 3.72265069164326722894742260905332e-01 1.15020889442076501563150259244139e-02
 	 4.10545081201457717767766553151887e-01 1.21628730872799017959096090635285e-01 4.67826187925743264273137356212828e-01 1.42439341965709658638372658856497e-02
 	 2.95380884262580245547269441885874e-01 1.45391829065636413176321184437256e-01 5.59227286671783341276409373676870e-01 1.57853607532714747263558052736698e-02
 	 1.92151054529854037333791438868502e-01 1.66692377722009177354323128383840e-01 6.41156567748136785311885432747658e-01 1.56228848902498374667802139015294e-02
 	 1.06854490883476538343188622093294e-01 1.84292557910963550327210214163642e-01 7.08852951205559911329601163743064e-01 1.35323221272061044312406963285866e-02
 	 4.44464631554077893582643810077570e-02 1.97169894186842054040198490838520e-01 7.58383642657750156601537128153723e-01 9.63579464185576606283234468719456e-03
 	 8.53905498842744137277804838959128e-03 2.04579065516149460890460431983229e-01 7.86881879495423097736761519627180e-01 4.40159403669889998794717556052092e-03
 	 9.78437936834149701859075776155805e-01 2.48068653665782165584907659194869e-03 1.90813766291924764850751472522461e-02 1.24089874244278611410685631000206e-04
 	 9.28942101264411013161748087441083e-01 8.17511623821547128709852358952048e-03 6.28827824973735155511533889693965e-02 7.11517402627042435531157238415290e-04
 	 8.54552543764935834680329662660370e-01 1.67335353624646077097537499867030e-02 1.28713920872599557609916587352927e-01 1.99073556111060805118295746751755e-03
 	 7.59598889525226916852318481687689e-01 2.76578263204824148502325442677829e-02 2.12743284154290668297448974044528e-01 3.98223342745506522083465128503121e-03
 	 6.49600650277255109443785840994678e-01 4.03129766676291745319815618131543e-02 3.10086373055115716024232597192167e-01 6.47543311221697882179570981975303e-03
 	 5.30950849312817885206072787696030e-01 5.39634776222766565645372338622110e-02 4.15085673064905458229389978441759e-01 9.06264947409813996503924471426217e-03
 	 4.10545081201457717767766553151887e-01 6.78160002492790292549784680886660e-02 5.21638918549263252977254978759447e-01 1.12229859620977655970675002095049e-02
 	 2.95380884262580245547269441885874e-01 8.10654871213770666926734520529862e-02 6.23553628616042687760057106061140e-01 1.24374965298044825451340145150425e-02
 	 1.92151054529854037333791438868502e-01 9.29419410038159199416440969798714e-02 7.14907004466330042724564464151626e-01 1.23094796276826973918661067841640e-02
 	 1.06854490883476538343188622093294e-01 1.02755196601539200429442644235678e-01 7.90390312514984261227368733671028e-01 1.06622973100213049024720390889343e-02
 	 4.44464631554077893582643810077570e-02 1.09935156746057360876989150710870e-01 8.45618380098534849764746468281373e-01 7.59217127142007910944876414305327e-03
 	 8.53905498842744137277804838959128e-03 1.14066256043975244871546692593256e-01 8.77394688967597313755675259017153e-01 3.46807471889452705038348057087205e-03
 	 9.78437936834149701859075776155805e-01 1.03371488732742489169424970896216e-03 2.05283482785228732492299741352326e-02 8.28974642306672565876188296662974e-05
 	 9.28942101264410902139445624925429e-01 3.40661314365861556119341457815608e-03 6.76512855919304822993609604964149e-02 4.75324749847524572182039248602337e-04
 	 8.54552543764935834680329662660370e-01 6.97295057887661884343799556518206e-03 1.38474505656187546476232341774448e-01 1.32989843832880504093107987273470e-03
 	 7.59598889525227027874620944203343e-01 1.15251590219528909919688430818496e-02 2.28875951452820081133410212714807e-01 2.66030612990039673146358545352541e-03
 	 6.49600650277254998421483378479024e-01 1.67986255087091418403133502579294e-02 3.33600724214035859738203271263046e-01 4.32587258281338232768220564139483e-03
 	 5.30950849312817885206072787696030e-01 2.24868597324928143343925057706656e-02 4.46562290954689300459534706533304e-01 6.05424628874393945532350613802919e-03
 	 4.10545081201457717767766553151887e-01 2.82592774301615445864399589481764e-02 5.61195641368380737645793487899937e-01 7.49744556532319986197343553158134e-03
 	 2.95380884262580245547269441885874e-01 3.37804070153568947176836445578374e-02 6.70838708722062859735046913556289e-01 8.30879175257164849510704840440667e-03
 	 1.92151054529854037333791438868502e-01 3.87293866649480733599375525955111e-02 7.69119558805197889306271008535987e-01 8.22327086193338011033127088467154e-03
 	 1.06854490883476538343188622093294e-01 4.28186209372406478834705012559425e-02 8.50326888179282813773340876650764e-01 7.12288101875470716639604518150009e-03
 	 4.44464631554077893582643810077570e-02 4.58105473987779898692451752140187e-02 9.09742989445814220772490443778224e-01 5.07190252418733382444582247217113e-03
 	 8.53905498842744137277804838959128e-03 4.75319978046155888762314134510234e-02 9.43928947206956969750990538159385e-01 2.31682562102439922741003996975451e-03
 	 9.78437936834149701859075776155805e-01 1.98795384555229548428911812152364e-04 2.13632677812950685924953120320424e-02 3.65694820335948515615739906614579e-05
 	 9.28942101264411013161748087441083e-01 6.55131292222554950654966887668706e-04 7.04027674433664318875969456712482e-02 2.09685302934049761858573135420158e-04
 	 8.54552543764935834680329662660370e-01 1.34097942170133266337472832674393e-03 1.44106476813362832656295609012886e-01 5.86672915731714737092028499887419e-04
 	 7.59598889525226916852318481687689e-01 2.21642200176960790791724775772309e-03 2.38184688473003475239764270554588e-01 1.17357048402048263005537087622088e-03
 	 6.49600650277254998421483378479024e-01 3.23057088462475050505418039392680e-03 3.47168778838120251073462441127049e-01 1.90832037101433559835028663798084e-03
 	 5.30950849312817774183770325180376e-01 4.32448442289334877841611159965396e-03 4.64724666264288877037813563219970e-01 2.67077712132567741606936628784297e-03
 	 4.10545081201457717767766553151887e-01 5.43458742139835138118542090523988e-03 5.84020331377143930851048025942873e-01 3.30743169822451943407060070967418e-03
 	 2.95380884262580245547269441885874e-01 6.49636479591786386578178280615248e-03 6.98122750941501890586948775307974e-01 3.66534988176566876513784443147870e-03
 	 1.92151054529854037333791438868502e-01 7.44811108946308308986772317439318e-03 8.00400834380682879576340837957105e-01 3.62762309841086231718132459889148e-03
 	 1.06854490883476538343188622093294e-01 8.23451835674993137814681176678278e-03 8.84910990759773530278664566139923e-01 3.14219586642580954102821344520180e-03
 	 4.44464631554077893582643810077570e-02 8.80990058135933118421689869137481e-03 9.46743636263232879457518720300868e-01 2.23742487126400452918106864785841e-03
 	 8.53905498842744137277804838959128e-03 9.14095549758098258052996243350208e-03 9.82319989513991576046691989176907e-01 1.02204710010515170161282672012248e-03
 	 ];
 
 	 case  23 

 	 % ALG. DEG.:   23
 	 % PTS CARD.:  144
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 9.6e-16  

 	 xyw_bar=[
 	 9.78437936834149701859075776155805e-01 2.13632677812950685924953120320424e-02 1.98795384555229548428911812152364e-04 3.65694820335950887307992218655528e-05
 	 9.28942101264410902139445624925429e-01 7.04027674433664873987481769290753e-02 6.55131292222610461806198145495728e-04 2.09685302934051117111288742300701e-04
 	 8.54552543764935834680329662660370e-01 1.44106476813362832656295609012886e-01 1.34097942170133266337472832674393e-03 5.86672915731718531799632199152938e-04
 	 7.59598889525226916852318481687689e-01 2.38184688473003419728613039296761e-01 2.21642200176966341906847901555011e-03 1.17357048402049021947057827475192e-03
 	 6.49600650277254998421483378479024e-01 3.47168778838120251073462441127049e-01 3.23057088462475050505418039392680e-03 1.90832037101434774141461847563050e-03
 	 5.30950849312817774183770325180376e-01 4.64724666264288877037813563219970e-01 4.32448442289334877841611159965396e-03 2.67077712132569476330412605591391e-03
 	 4.10545081201457717767766553151887e-01 5.84020331377143930851048025942873e-01 5.43458742139835138118542090523988e-03 3.30743169822454111811405041976286e-03
 	 2.95380884262580245547269441885874e-01 6.98122750941501890586948775307974e-01 6.49636479591786386578178280615248e-03 3.66534988176569218390477011837447e-03
 	 1.92151054529854037333791438868502e-01 8.00400834380682879576340837957105e-01 7.44811108946308308986772317439318e-03 3.62762309841088573594825028578725e-03
 	 1.06854490883476538343188622093294e-01 8.84910990759773530278664566139923e-01 8.23451835674993137814681176678278e-03 3.14219586642582992402905617268516e-03
 	 4.44464631554077893582643810077570e-02 9.46743636263232879457518720300868e-01 8.80990058135933118421689869137481e-03 2.23742487126401884064974545651694e-03
 	 8.53905498842744137277804838959128e-03 9.82319989513991576046691989176907e-01 9.14095549758098258052996243350208e-03 1.02204710010515842366629613024998e-03
 	 9.78437936834149701859075776155805e-01 2.05283482785228732492299741352326e-02 1.03371488732742489169424970896216e-03 8.28974642306667822491683672581075e-05
 	 9.28942101264410902139445624925429e-01 6.76512855919304129104219214241311e-02 3.40661314365868495013245365043986e-03 4.75324749847521970096825283391695e-04
 	 8.54552543764935834680329662660370e-01 1.38474505656187546476232341774448e-01 6.97295057887661884343799556518206e-03 1.32989843832879766835630697130455e-03
 	 7.59598889525226916852318481687689e-01 2.28875951452820108888985828343721e-01 1.15251590219529742586956899685902e-02 2.66030612990038198631403965066511e-03
 	 6.49600650277254998421483378479024e-01 3.33600724214035859738203271263046e-01 1.67986255087091418403133502579294e-02 4.32587258281335804155354196609551e-03
 	 5.30950849312817885206072787696030e-01 4.46562290954689411481837169048958e-01 2.24868597324927033120900432550116e-02 6.05424628874390562821572459029085e-03
 	 4.10545081201457717767766553151887e-01 5.61195641368380626623491025384283e-01 2.82592774301616556087424214638304e-02 7.49744556532315822861001208821108e-03
 	 2.95380884262580245547269441885874e-01 6.70838708722062859735046913556289e-01 3.37804070153568947176836445578374e-02 8.30879175257160165757319703061512e-03
 	 1.92151054529854037333791438868502e-01 7.69119558805197778283968546020333e-01 3.87293866649481843822400151111651e-02 8.22327086193333327279741951087999e-03
 	 1.06854490883476538343188622093294e-01 8.50326888179282813773340876650764e-01 4.28186209372406478834705012559425e-02 7.12288101875466726775609771493691e-03
 	 4.44464631554077893582643810077570e-02 9.09742989445814109750187981262570e-01 4.58105473987781008915476377296727e-02 5.07190252418730520150846885485407e-03
 	 8.53905498842744137277804838959128e-03 9.43928947206956858728688075643731e-01 4.75319978046156998985338759666774e-02 2.31682562102438665066483913790307e-03
 	 9.78437936834149701859075776155805e-01 1.90813766291924764850751472522461e-02 2.48068653665782165584907659194869e-03 1.24089874244278855356174440238703e-04
 	 9.28942101264411013161748087441083e-01 6.28827824973735710623046202272235e-02 8.17511623821541577594729233169346e-03 7.11517402627043736573764221020610e-04
 	 8.54552543764935834680329662660370e-01 1.28713920872599585365492202981841e-01 1.67335353624645799541781343577895e-02 1.99073556111061195431077841533352e-03
 	 7.59598889525227027874620944203343e-01 2.12743284154290612786297742786701e-01 2.76578263204823593390813130099559e-02 3.98223342745507302709029318066314e-03
 	 6.49600650277254998421483378479024e-01 3.10086373055115882557686290965648e-01 4.03129766676291190208303305553272e-02 6.47543311221699096486004165740269e-03
 	 5.30950849312817885206072787696030e-01 4.15085673064905569251692440957413e-01 5.39634776222765455422347713465570e-02 9.06264947409815731227400448233311e-03
 	 4.10545081201457717767766553151887e-01 5.21638918549263363999557441275101e-01 6.78160002492789182326760055730119e-02 1.12229859620977881484726879079972e-02
 	 2.95380884262580245547269441885874e-01 6.23553628616042687760057106061140e-01 8.10654871213770666926734520529862e-02 1.24374965298045050965392022135347e-02
 	 1.92151054529854037333791438868502e-01 7.14907004466330153746866926667280e-01 9.29419410038158089193416344642173e-02 1.23094796276827216779947704594633e-02
 	 1.06854490883476538343188622093294e-01 7.90390312514984261227368733671028e-01 1.02755196601539200429442644235678e-01 1.06622973100213239844302748338123e-02
 	 4.44464631554077893582643810077570e-02 8.45618380098534849764746468281373e-01 1.09935156746057360876989150710870e-01 7.59217127142009385459830994591357e-03
 	 8.53905498842744137277804838959128e-03 8.77394688967597313755675259017153e-01 1.14066256043975244871546692593256e-01 3.46807471889453355559651548389866e-03
 	 9.78437936834149701859075776155805e-01 1.71129249973081612457015410200256e-02 4.44913816854213689522268282416917e-03 1.57491777069450859674951126443432e-04
 	 9.28942101264410902139445624925429e-01 5.63957392284404127047459098776017e-02 1.46621595071486851558084651969693e-02 9.03040162124586136098425281915070e-04
 	 8.54552543764935834680329662660370e-01 1.15435679343617189629433994468855e-01 3.00117768914469756902363428707758e-02 2.52659198104647660099164596658738e-03
 	 7.59598889525226916852318481687689e-01 1.90796499443523920325205267545243e-01 4.96046110312491628224762507670675e-02 5.05415146090524083910544561604183e-03
 	 6.49600650277254998421483378479024e-01 2.78097589492634300611939579539467e-01 7.23017602301107009665770419815090e-02 8.21845839032621719444371422014228e-03
 	 5.30950849312817885206072787696030e-01 3.72265069164326722894742260905332e-01 9.67840815228553918991849513986381e-02 1.15020889442076952591254013213984e-02
 	 4.10545081201457717767766553151887e-01 4.67826187925743153250834893697174e-01 1.21628730872799128981398553150939e-01 1.42439341965710213749884971434767e-02
 	 2.95380884262580245547269441885874e-01 5.59227286671783230254106911161216e-01 1.45391829065636524198623646952910e-01 1.57853607532715371764009404387252e-02
 	 1.92151054529854037333791438868502e-01 6.41156567748136674289582970232004e-01 1.66692377722009288376625590899494e-01 1.56228848902498981821018730897777e-02
 	 1.06854490883476538343188622093294e-01 7.08852951205559689284996238711756e-01 1.84292557910963772371815139194950e-01 1.35323221272061564729449756327995e-02
 	 4.44464631554077893582643810077570e-02 7.58383642657750045579234665638069e-01 1.97169894186842165062500953354174e-01 9.63579464185580422674881617695064e-03
 	 8.53905498842744137277804838959128e-03 7.86881879495422986714459057111526e-01 2.04579065516149571912762894498883e-01 4.40159403669891646782019734018832e-03
 	 9.78437936834149701859075776155805e-01 1.47466345908192283942206302072009e-02 6.81542857503106974670359363699390e-03 1.80999263046255912589996284189908e-04
 	 9.28942101264410902139445624925429e-01 4.85976160715808208623300856743299e-02 2.24602826640082769982242894002411e-02 1.03782944663608324778469871318975e-03
 	 8.54552543764935834680329662660370e-01 9.94738060437400095636917285446543e-02 4.59736501913241557559786087949760e-02 2.90371532468216772548963433564495e-03
 	 7.59598889525226916852318481687689e-01 1.64414105650767944366563710900664e-01 7.59870048240051387811178074116469e-02 5.80854255866703438060394404374165e-03
 	 6.49600650277254998421483378479024e-01 2.39643633889624924071526379520947e-01 1.10755715833120077506990242000029e-01 9.44515923119839881372250545155111e-03
 	 5.30950849312817774183770325180376e-01 3.20790101444135888897335462388583e-01 1.48259049243046336918894212431042e-01 1.32189099718902532132336347103774e-02
 	 4.10545081201457717767766553151887e-01 4.03137502586030316287235564232105e-01 1.86317416212511965944997882616008e-01 1.63700076310765545162251299871059e-02
 	 2.95380884262580245547269441885874e-01 4.81900110650943513945776430773549e-01 2.22719005086476240506954127340578e-01 1.81415100929459699452550580645038e-02
 	 1.92151054529853926311488976352848e-01 5.52500617023264473104404714831617e-01 2.55348328446881600584106308815535e-01 1.79547828109447478450722002207840e-02
 	 1.06854490883476538343188622093294e-01 6.10836280279173582385965346475132e-01 2.82309228837349879270846031431574e-01 1.55521791543995601542205164946608e-02
 	 4.44464631554077893582643810077570e-02 6.53518113337575590193750940670725e-01 3.02035423507016620447984678321518e-01 1.10740494614640083703704931394896e-02
 	 8.53905498842744137277804838959128e-03 6.78075755306665750588024366152240e-01 3.13385189704906808039197585458169e-01 5.05858332222625019930495327002973e-03
 	 9.78437936834149701859075776155805e-01 1.21311769153246654801003856505304e-02 9.43088625052563266082383819366441e-03 1.93134360313782741259275299583464e-04
 	 9.28942101264411013161748087441083e-01 3.99783607979548316624374137973064e-02 3.10795379376341551758144987616106e-02 1.10741073149918161852567344283216e-03
 	 8.54552543764935834680329662660370e-01 8.18311684693519975075659544927476e-02 6.36162877657121678121043828468828e-02 3.09839494552250922093650231659012e-03
 	 7.59598889525227027874620944203343e-01 1.35253680474735543670661286341783e-01 1.05147430000037428454717769454874e-01 6.19797634831721708931207004411590e-03
 	 6.49600650277254887399180915963370e-01 1.97140527314363322997081695575616e-01 1.53258822408381789603737388461013e-01 1.00784100193443137971627265869756e-02
 	 5.30950849312817774183770325180376e-01 2.63894887293573909836652546800906e-01 2.05154263393608315979577128018718e-01 1.41051719134019908769017703775717e-02
 	 4.10545081201457773278917784409714e-01 3.31637183721767481170417113389703e-01 2.57817735076774801061816333458410e-01 1.74675349443369591628805181926509e-02
 	 2.95380884262580245547269441885874e-01 3.96430484651777104154746211861493e-01 3.08188631085642650297984346252633e-01 1.93578078051717811236542843289499e-02
 	 1.92151054529854092844942670126329e-01 4.54509311236884150364545575939701e-01 3.53339634233261701279360522676143e-01 1.91585613908191385035273412995593e-02
 	 1.06854490883476538343188622093294e-01 5.02498582759948630993562801450025e-01 3.90646926356574830663248576456681e-01 1.65948751498656357772354397184245e-02
 	 4.44464631554077893582643810077570e-02 5.37610381639415102483781083719805e-01 4.17943155205177108157954535272438e-01 1.18165092101864422496904083459413e-02
 	 8.53905498842744137277804838959128e-03 5.57812489280687051618201621749904e-01 4.33648455730885507009020329860505e-01 5.39773608792241087195318272051736e-03
 	 9.78437936834149701859075776155805e-01 9.43088625052563613027079014727860e-03 1.21311769153246620106534336969162e-02 1.93134360313782551523895114620188e-04
 	 9.28942101264411013161748087441083e-01 3.10795379376342176258596339266660e-02 3.99783607979547692123922786322510e-02 1.10741073149918053432350095732772e-03
 	 8.54552543764935834680329662660370e-01 6.36162877657121955676799984757963e-02 8.18311684693519697519903388638340e-02 3.09839494552250618517041935717771e-03
 	 7.59598889525227027874620944203343e-01 1.05147430000037511721444616341614e-01 1.35253680474735460403934439455043e-01 6.19797634831721101777990412529107e-03
 	 6.49600650277254998421483378479024e-01 1.53258822408381734092586157203186e-01 1.97140527314363267485930464317789e-01 1.00784100193443033888218707261331e-02
 	 5.30950849312817774183770325180376e-01 2.05154263393608427001879590534372e-01 2.63894887293573798814350084285252e-01 1.41051719134019769991139625631149e-02
 	 4.10545081201457717767766553151887e-01 2.57817735076774856572967564716237e-01 3.31637183721767425659265882131876e-01 1.74675349443369418156457584245800e-02
 	 2.95380884262580245547269441885874e-01 3.08188631085642761320286808768287e-01 3.96430484651776993132443749345839e-01 1.93578078051717603069725726072647e-02
 	 1.92151054529853981822640207610675e-01 3.53339634233261923323965447707451e-01 4.54509311236884150364545575939701e-01 1.91585613908191176868456295778742e-02
 	 1.06854490883476538343188622093294e-01 3.90646926356575052707853501487989e-01 5.02498582759948408948957876418717e-01 1.65948751498656184300006799503535e-02
 	 4.44464631554077893582643810077570e-02 4.17943155205177219180256997788092e-01 5.37610381639414991461478621204151e-01 1.18165092101864301066260765082916e-02
 	 8.53905498842744137277804838959128e-03 4.33648455730885729053625254891813e-01 5.57812489280686829573596696718596e-01 5.39773608792240480042101680169253e-03
 	 9.78437936834149701859075776155805e-01 6.81542857503106627725664168337971e-03 1.47466345908192318636675821608151e-02 1.80999263046256779951734272593455e-04
 	 9.28942101264410902139445624925429e-01 2.24602826640082076092852503279573e-02 4.85976160715808902512691247466137e-02 1.03782944663608823511469214651015e-03
 	 8.54552543764935834680329662660370e-01 4.59736501913241418781908009805193e-02 9.94738060437400234414795363591111e-02 2.90371532468218160327744215010171e-03
 	 7.59598889525227027874620944203343e-01 7.59870048240050555143909605249064e-02 1.64414105650767916610988095271750e-01 5.80854255866706300354129766105871e-03
 	 6.49600650277254998421483378479024e-01 1.10755715833120049751414626371115e-01 2.39643633889624951827101995149860e-01 9.44515923119844391653288084853557e-03
 	 5.30950849312817885206072787696030e-01 1.48259049243046281407742981173215e-01 3.20790101444135833386184231130756e-01 1.32189099718903173980022458522399e-02
 	 4.10545081201457662256615321894060e-01 1.86317416212511910433846651358181e-01 4.03137502586030371798386795489932e-01 1.63700076310766343135050249202322e-02
 	 2.95380884262580301058420673143701e-01 2.22719005086476184995802896082751e-01 4.81900110650943569456927662031376e-01 1.81415100929460566814288569048585e-02
 	 1.92151054529854037333791438868502e-01 2.55348328446881489561803846299881e-01 5.52500617023264473104404714831617e-01 1.79547828109448345812459990611387e-02
 	 1.06854490883476538343188622093294e-01 2.82309228837349879270846031431574e-01 6.10836280279173582385965346475132e-01 1.55521791543996364820534594741730e-02
 	 4.44464631554077893582643810077570e-02 3.02035423507016398403379753290210e-01 6.53518113337575812238355865702033e-01 1.10740494614640621467982484205095e-02
 	 8.53905498842744137277804838959128e-03 3.13385189704906697016895122942515e-01 6.78075755306665861610326828667894e-01 5.05858332222627448543361694532905e-03
 	 9.78437936834149701859075776155805e-01 4.44913816854213342577573087055498e-03 1.71129249973081647151484929736398e-02 1.57491777069450236258701947278382e-04
 	 9.28942101264410902139445624925429e-01 1.46621595071486227057633300319139e-02 5.63957392284404751547910450426571e-02 9.03040162124582666651473328300881e-04
 	 8.54552543764935834680329662660370e-01 3.00117768914469479346607272418623e-02 1.15435679343617217385009610097768e-01 2.52659198104646662633165909994659e-03
 	 7.59598889525227027874620944203343e-01 4.96046110312490518001737882514135e-02 1.90796499443523920325205267545243e-01 5.05415146090522175714720987116380e-03
 	 6.49600650277255109443785840994678e-01 7.23017602301106454554258107236819e-02 2.78097589492634245100788348281640e-01 8.21845839032618596942114663761458e-03
 	 5.30950849312817885206072787696030e-01 9.67840815228553918991849513986381e-02 3.72265069164326722894742260905332e-01 1.15020889442076501563150259244139e-02
 	 4.10545081201457717767766553151887e-01 1.21628730872799017959096090635285e-01 4.67826187925743264273137356212828e-01 1.42439341965709658638372658856497e-02
 	 2.95380884262580245547269441885874e-01 1.45391829065636413176321184437256e-01 5.59227286671783341276409373676870e-01 1.57853607532714747263558052736698e-02
 	 1.92151054529854037333791438868502e-01 1.66692377722009177354323128383840e-01 6.41156567748136785311885432747658e-01 1.56228848902498374667802139015294e-02
 	 1.06854490883476538343188622093294e-01 1.84292557910963550327210214163642e-01 7.08852951205559911329601163743064e-01 1.35323221272061044312406963285866e-02
 	 4.44464631554077893582643810077570e-02 1.97169894186842054040198490838520e-01 7.58383642657750156601537128153723e-01 9.63579464185576606283234468719456e-03
 	 8.53905498842744137277804838959128e-03 2.04579065516149460890460431983229e-01 7.86881879495423097736761519627180e-01 4.40159403669889998794717556052092e-03
 	 9.78437936834149701859075776155805e-01 2.48068653665782165584907659194869e-03 1.90813766291924764850751472522461e-02 1.24089874244278611410685631000206e-04
 	 9.28942101264411013161748087441083e-01 8.17511623821547128709852358952048e-03 6.28827824973735155511533889693965e-02 7.11517402627042435531157238415290e-04
 	 8.54552543764935834680329662660370e-01 1.67335353624646077097537499867030e-02 1.28713920872599557609916587352927e-01 1.99073556111060805118295746751755e-03
 	 7.59598889525226916852318481687689e-01 2.76578263204824148502325442677829e-02 2.12743284154290668297448974044528e-01 3.98223342745506522083465128503121e-03
 	 6.49600650277255109443785840994678e-01 4.03129766676291745319815618131543e-02 3.10086373055115716024232597192167e-01 6.47543311221697882179570981975303e-03
 	 5.30950849312817885206072787696030e-01 5.39634776222766565645372338622110e-02 4.15085673064905458229389978441759e-01 9.06264947409813996503924471426217e-03
 	 4.10545081201457717767766553151887e-01 6.78160002492790292549784680886660e-02 5.21638918549263252977254978759447e-01 1.12229859620977655970675002095049e-02
 	 2.95380884262580245547269441885874e-01 8.10654871213770666926734520529862e-02 6.23553628616042687760057106061140e-01 1.24374965298044825451340145150425e-02
 	 1.92151054529854037333791438868502e-01 9.29419410038159199416440969798714e-02 7.14907004466330042724564464151626e-01 1.23094796276826973918661067841640e-02
 	 1.06854490883476538343188622093294e-01 1.02755196601539200429442644235678e-01 7.90390312514984261227368733671028e-01 1.06622973100213049024720390889343e-02
 	 4.44464631554077893582643810077570e-02 1.09935156746057360876989150710870e-01 8.45618380098534849764746468281373e-01 7.59217127142007910944876414305327e-03
 	 8.53905498842744137277804838959128e-03 1.14066256043975244871546692593256e-01 8.77394688967597313755675259017153e-01 3.46807471889452705038348057087205e-03
 	 9.78437936834149701859075776155805e-01 1.03371488732742489169424970896216e-03 2.05283482785228732492299741352326e-02 8.28974642306672565876188296662974e-05
 	 9.28942101264410902139445624925429e-01 3.40661314365861556119341457815608e-03 6.76512855919304822993609604964149e-02 4.75324749847524572182039248602337e-04
 	 8.54552543764935834680329662660370e-01 6.97295057887661884343799556518206e-03 1.38474505656187546476232341774448e-01 1.32989843832880504093107987273470e-03
 	 7.59598889525227027874620944203343e-01 1.15251590219528909919688430818496e-02 2.28875951452820081133410212714807e-01 2.66030612990039673146358545352541e-03
 	 6.49600650277254998421483378479024e-01 1.67986255087091418403133502579294e-02 3.33600724214035859738203271263046e-01 4.32587258281338232768220564139483e-03
 	 5.30950849312817885206072787696030e-01 2.24868597324928143343925057706656e-02 4.46562290954689300459534706533304e-01 6.05424628874393945532350613802919e-03
 	 4.10545081201457717767766553151887e-01 2.82592774301615445864399589481764e-02 5.61195641368380737645793487899937e-01 7.49744556532319986197343553158134e-03
 	 2.95380884262580245547269441885874e-01 3.37804070153568947176836445578374e-02 6.70838708722062859735046913556289e-01 8.30879175257164849510704840440667e-03
 	 1.92151054529854037333791438868502e-01 3.87293866649480733599375525955111e-02 7.69119558805197889306271008535987e-01 8.22327086193338011033127088467154e-03
 	 1.06854490883476538343188622093294e-01 4.28186209372406478834705012559425e-02 8.50326888179282813773340876650764e-01 7.12288101875470716639604518150009e-03
 	 4.44464631554077893582643810077570e-02 4.58105473987779898692451752140187e-02 9.09742989445814220772490443778224e-01 5.07190252418733382444582247217113e-03
 	 8.53905498842744137277804838959128e-03 4.75319978046155888762314134510234e-02 9.43928947206956969750990538159385e-01 2.31682562102439922741003996975451e-03
 	 9.78437936834149701859075776155805e-01 1.98795384555229548428911812152364e-04 2.13632677812950685924953120320424e-02 3.65694820335948515615739906614579e-05
 	 9.28942101264411013161748087441083e-01 6.55131292222554950654966887668706e-04 7.04027674433664318875969456712482e-02 2.09685302934049761858573135420158e-04
 	 8.54552543764935834680329662660370e-01 1.34097942170133266337472832674393e-03 1.44106476813362832656295609012886e-01 5.86672915731714737092028499887419e-04
 	 7.59598889525226916852318481687689e-01 2.21642200176960790791724775772309e-03 2.38184688473003475239764270554588e-01 1.17357048402048263005537087622088e-03
 	 6.49600650277254998421483378479024e-01 3.23057088462475050505418039392680e-03 3.47168778838120251073462441127049e-01 1.90832037101433559835028663798084e-03
 	 5.30950849312817774183770325180376e-01 4.32448442289334877841611159965396e-03 4.64724666264288877037813563219970e-01 2.67077712132567741606936628784297e-03
 	 4.10545081201457717767766553151887e-01 5.43458742139835138118542090523988e-03 5.84020331377143930851048025942873e-01 3.30743169822451943407060070967418e-03
 	 2.95380884262580245547269441885874e-01 6.49636479591786386578178280615248e-03 6.98122750941501890586948775307974e-01 3.66534988176566876513784443147870e-03
 	 1.92151054529854037333791438868502e-01 7.44811108946308308986772317439318e-03 8.00400834380682879576340837957105e-01 3.62762309841086231718132459889148e-03
 	 1.06854490883476538343188622093294e-01 8.23451835674993137814681176678278e-03 8.84910990759773530278664566139923e-01 3.14219586642580954102821344520180e-03
 	 4.44464631554077893582643810077570e-02 8.80990058135933118421689869137481e-03 9.46743636263232879457518720300868e-01 2.23742487126400452918106864785841e-03
 	 8.53905498842744137277804838959128e-03 9.14095549758098258052996243350208e-03 9.82319989513991576046691989176907e-01 1.02204710010515170161282672012248e-03
 	 ];
 
 	 case  24 

 	 % ALG. DEG.:   24
 	 % PTS CARD.:  169
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 9.81389634989011994115060133481165e-01 1.84631854484650567704839829730190e-02 1.47179562522949114455883545815595e-04 2.34020503972595879697230630833715e-05
 	 9.38524459100730901184306276263669e-01 6.09893632659945228446929377241759e-02 4.86177633274575971000786012155004e-04 1.35150151816662382735917402598602e-04
 	 8.73694821306689517470545069954824e-01 1.25306297643234920702326462560450e-01 9.98881050075561827128467484726571e-04 3.82530303658942512443769112806535e-04
 	 7.90157028273437589405148173682392e-01 2.08183434325818456089862706903659e-01 1.65953740074395450498911941394908e-03 7.77857933417090761755996464188456e-04
 	 6.92101001719601649497803919075523e-01 3.05463987476396969800163105901447e-01 2.43501080400138070203297502303030e-03 1.29292904366350830912268943251320e-03
 	 5.84443964021340578440799617965240e-01 4.12269622437441973783478488257970e-01 3.28641354121744777572189377679024e-03 1.86209340407372456183132669593761e-03
 	 4.72584386004117895652143488405272e-01 5.23244562042314509398011068697087e-01 4.17105195356759494984544289764017e-03 2.39343384724747133135425158911858e-03
 	 3.62131397282238864931969146709889e-01 6.32824036324802441377812556311255e-01 5.04456639295869369021829697885551e-03 2.78592822370231970457998826873336e-03
 	 2.58623540705762433589143256540410e-01 7.35513303849445687632169210701250e-01 5.86315544479187877868753275834024e-03 2.94924746089819059952086277576200e-03
 	 1.67251011391557513618977282021660e-01 8.26163216015457058105653231905308e-01 6.58577259298542827536948607303202e-03 2.82228038214101884309514822746223e-03
 	 9.25952246990027205697515455540270e-02 9.00228589461483430511634651338682e-01 7.17618583951384891861380310729146e-03 2.38669150517102331490737476826780e-03
 	 3.83981387396783446774861658923328e-02 9.53997059249292456151181340828771e-01 7.60480201102919917133249327889644e-03 1.67281079377700121237071417823472e-03
 	 7.36465102608929722549646612606011e-03 9.84785119474352987900545031152433e-01 7.85022949955771487395850272150710e-03 7.57647282693648836324196160774136e-04
 	 9.81389634989011994115060133481165e-01 1.78436030770129580580452000049263e-02 7.66761933975047826894666513908305e-04 5.32514506499773252498446118874398e-05
 	 9.38524459100731012206608738779323e-01 5.89426994099024534334851921357767e-02 2.53284148936653435990606908490008e-03 3.07534661178437182093431401241901e-04
 	 8.73694821306689628492847532470478e-01 1.21101304237932111407261004387692e-01 5.20387445537826009989146314183017e-03 8.70449094913512515236941879948063e-04
 	 7.90157028273437589405148173682392e-01 2.01197273335524312587452300249424e-01 8.64569839103809800739952606818406e-03 1.77001855183185705794324249495730e-03
 	 6.92101001719601871542408844106831e-01 2.95213313112424990958260195839102e-01 1.26856851679731374993309600540670e-02 2.94206473338046257254285720250664e-03
 	 5.84443964021340578440799617965240e-01 3.98434794690061711008866041083820e-01 1.71212412885977105503343409509398e-02 4.23720030208514942399178337950616e-03
 	 4.72584386004117895652143488405272e-01 5.05685668561853707281272818363504e-01 2.17299454340283970665836932312232e-02 5.44626740978256668190837785914482e-03
 	 3.62131397282238864931969146709889e-01 6.11587905743088189325362691306509e-01 2.62806969746729457426681619836017e-02 6.33938978852193260604686031456367e-03
 	 2.58623540705762433589143256540410e-01 7.10831155782114532115656402311288e-01 3.05453035121230342952003411483020e-02 6.71102330576050197519233364573665e-03
 	 1.67251011391557513618977282021660e-01 7.98439063755051470216983489081031e-01 3.43099248533910161640392288973089e-02 6.42210925704103392092081392661385e-03
 	 9.25952246990027205697515455540270e-02 8.70018972282239122506553030689247e-01 3.73858030187581569236954237567261e-02 5.43092518590669419420446928370438e-03
 	 3.83981387396783446774861658923328e-02 9.21983094921314361158692918252200e-01 3.96187663390072941638209158554673e-02 3.80648703508461435859877575182963e-03
 	 7.36465102608929722549646612606011e-03 9.51737978102256465540165208949475e-01 4.08973708716542372343383249244653e-02 1.72402914272737415972425178978256e-03
 	 9.81389634989011994115060133481165e-01 1.67640129321728822975323680566362e-02 1.84635207881512358740749846219842e-03 8.02767637205731938911806855330155e-05
 	 9.38524459100731012206608738779323e-01 5.53764938000512602078728718879574e-02 6.09904709921772758551838933271938e-03 4.63609667529657227397210661479221e-04
 	 8.73694821306689628492847532470478e-01 1.13774321340011863590291341097327e-01 1.25308573532985079168611264321953e-02 1.31220531028272734477835292921100e-03
 	 7.90157028273437589405148173682392e-01 1.89024250178472130734519396355608e-01 2.08187215480902798603324299619999e-02 2.66830967667727996656124034302593e-03
 	 6.92101001719601760520106381591177e-01 2.77352044730349245327261087368242e-01 3.05469535500489941526325310405809e-02 4.43517373835740098125812735929685e-03
 	 5.84443964021340578440799617965240e-01 3.74328324945567947334978953222162e-01 4.12277110330914742242214288125979e-02 6.38759551778287151813096045316342e-03
 	 4.72584386004117895652143488405272e-01 4.75090207442818823757590962486574e-01 5.23254065530632805902655491081532e-02 8.21026876597134511182041194388148e-03
 	 3.62131397282238864931969146709889e-01 5.74585049711494155744162526389118e-01 6.32835530062669793238683269009925e-02 9.55665413757148668461027796183771e-03
 	 2.58623540705762433589143256540410e-01 6.67823793024966971820788330660434e-01 7.35526662692705945900684127991553e-02 1.01168930735978986751311126113251e-02
 	 1.67251011391557513618977282021660e-01 7.50131166478646305151301021396648e-01 8.26178221297961812297216965816915e-02 9.68135404993720159738668229465475e-03
 	 9.25952246990027205697515455540270e-02 8.17380281304529332508934658108046e-01 9.00244939964679469213137963379268e-02 8.18714030531912662080884501847322e-03
 	 3.83981387396783446774861658923328e-02 8.66200422627483757054278612486087e-01 9.54014386328378982682352216215804e-02 5.73829363503063419327254734980670e-03
 	 7.36465102608929722549646612606011e-03 8.94155048399405405490369957988150e-01 9.84803005745052972841335758857895e-02 2.59898046811550499299303673694794e-03
 	 9.81389634989011994115060133481165e-01 1.52823603412698873910136043718921e-02 3.32800466971811849392626214694246e-03 1.02978478636877286505300899133175e-04
 	 9.38524459100731123228911201294977e-01 5.04821569938260217291770004521823e-02 1.09933839054428550419117982528405e-02 5.94715282864814796630337223604101e-04
 	 8.73694821306689517470545069954824e-01 1.03718613397426259736811005041091e-01 2.25865652958842227926439250040858e-02 1.68328791856261843727649019086812e-03
 	 7.90157028273437589405148173682392e-01 1.72317733000658890318845806177706e-01 3.75252387259035202760060201399028e-02 3.42288924342704255210367847439556e-03
 	 6.92101001719601649497803919075523e-01 2.52838858220077289384875030009425e-01 5.50601400603210611173210509150522e-02 5.68941027139622298308685444112598e-03
 	 5.84443964021340578440799617965240e-01 3.41244090594998827903339133627014e-01 7.43119453836605936558612484077457e-02 8.19396345944674135697294303781746e-03
 	 4.72584386004117951163294719663099e-01 4.33100342628329249006213785833097e-01 9.43152713675528553416427257616306e-02 1.05320761268172871649717592390516e-02
 	 3.62131397282238864931969146709889e-01 5.23801539161623974649728552321903e-01 1.14067063556137160418302300968207e-01 1.22592099922149595780940245504098e-02
 	 2.58623540705762433589143256540410e-01 6.08799569099254700432766185258515e-01 1.32576890194982865978090558201075e-01 1.29778806340205832281498032898526e-02
 	 1.67251011391557513618977282021660e-01 6.83832375680343496071600384311751e-01 1.48916612928098990309422333666589e-01 1.24191741794394405751233989576576e-02
 	 9.25952246990027205697515455540270e-02 7.45137816660301655069531534536509e-01 1.62266958640695624360716919909464e-01 1.05024070970658051082935457998246e-02
 	 3.83981387396783446774861658923328e-02 7.89643090822745530310555750475032e-01 1.71958770437576125011958083632635e-01 7.36104348406475296473505665062476e-03
 	 7.36465102608940824779892864171416e-03 8.15127004846216918210188850935083e-01 1.77508344127693673542012220423203e-01 3.33395421301598601088178597251499e-03
 	 9.81389634989011994115060133481165e-01 1.34784894062792252877880372352593e-02 5.13187560470878059715182928357535e-03 1.20129459672037238208638920688998e-04
 	 9.38524459100731012206608738779323e-01 4.45234376793178648901161409412452e-02 1.69521032199511229032751202794316e-02 6.93764624754019602718979609079497e-04
 	 8.73694821306689628492847532470478e-01 9.14760678778116093079475490412733e-02 3.48291108154987621992049184882489e-02 1.96363813882352231110495210941735e-03
 	 7.90157028273437589405148173682392e-01 1.51978011700935833339087821514113e-01 5.78649600256265772557640048034955e-02 3.99296863551515997942109592599991e-03
 	 6.92101001719601760520106381591177e-01 2.22994733530270106136583763145609e-01 8.49042647501281333433098552632146e-02 6.63697687907590944816904610092934e-03
 	 5.84443964021340578440799617965240e-01 3.00964952882264491496044911400531e-01 1.14591083096394930063155470634229e-01 9.55866134347081383704214374574804e-03
 	 4.72584386004117840140992257147445e-01 3.81978846828235962806985526185599e-01 1.45436767167646141540870985409128e-01 1.22861847551731292321752775364985e-02
 	 3.62131397282238920443120377967716e-01 4.61974023575212056069716481943033e-01 1.75894579142549078998314371347078e-01 1.43009713472640291598292350272459e-02
 	 2.58623540705762433589143256540410e-01 5.36939213538385251567319755849894e-01 2.04437245755852314843536987609696e-01 1.51393359941791854489379076653677e-02
 	 1.67251011391557513618977282021660e-01 6.03115436716130770555821527523221e-01 2.29633551892311715825201190455118e-01 1.44875774384834801744581511684373e-02
 	 9.25952246990027205697515455540270e-02 6.57184619639675116076205085846595e-01 2.50220155661322163354043368599378e-01 1.22515743728853210292584208218614e-02
 	 3.83981387396783446774861658923328e-02 6.96436662709365439383191187516786e-01 2.65165198550956215939322646590881e-01 8.58701923031132512142971080493226e-03
 	 7.36465102608940824779892864171416e-03 7.18912553705621570898642858082894e-01 2.73722795268289020853558213275392e-01 3.88922154883630799560023660887964e-03
 	 9.81389634989011994115060133481165e-01 1.14496391953653325890272185461072e-02 7.16072581562267329591264797272743e-03 1.30804509565253317907723706881029e-04
 	 9.38524459100731012206608738779323e-01 3.78215452636727622603984855231829e-02 2.36539956355962255329927756974939e-02 7.55414548125159126916450258448776e-04
 	 8.73694821306689517470545069954824e-01 7.77066287356915491590925171294657e-02 4.85985499576189333703624129157106e-02 2.13813268130619727608321412049008e-03
 	 7.90157028273437589405148173682392e-01 1.29101514802843458928904851745756e-01 8.07414569237189516659469745718525e-02 4.34779533266789215001368873458887e-03
 	 6.92101001719601871542408844106831e-01 1.89428441454185858550118837229093e-01 1.18470556826212269907472318664077e-01 7.22675776644261455561313312045968e-03
 	 5.84443964021340578440799617965240e-01 2.55662190107646347669856368156616e-01 1.59893845871013073889344013878144e-01 1.04080715300518718280375907170310e-02
 	 4.72584386004117895652143488405272e-01 3.24481464102908234714561785949627e-01 2.02934149892973869633294725645101e-01 1.33779705304260029125051900678045e-02
 	 3.62131397282238920443120377967716e-01 3.92435363350375598923136521989363e-01 2.45433239367385536144894331300748e-01 1.55717968639214800891101830870866e-02
 	 2.58623540705762378077992025282583e-01 4.56116414795984026486763696084381e-01 2.85260044498253539924093047375209e-01 1.64846610087862714688622389758166e-02
 	 1.67251011391557513618977282021660e-01 5.12331459068242844878682262788061e-01 3.20417529540199641502340455190279e-01 1.57749853100402556704828782585537e-02
 	 9.25952246990027205697515455540270e-02 5.58261875853256261947876737394836e-01 3.49142899447741017482371717051137e-01 1.33402845698516164113511806021961e-02
 	 3.83981387396783446774861658923328e-02 5.91605503412849231814618633507052e-01 3.69996357847472423507895200600615e-01 9.35008649930460164489964824952040e-03
 	 7.36465102608918620319400361040607e-03 6.10698209927987845091479357506614e-01 3.81937139045922968705326638882980e-01 4.23482898095949543415539295665440e-03
 	 9.81389634989012105137362595996819e-01 9.30518250549400294246993325941730e-03 9.30518250549389192016747074376326e-03 1.34427984588433141986685281921154e-04
 	 9.38524459100730901184306276263669e-01 3.07377704496344938966956306103384e-02 3.07377704496346049189980931259925e-02 7.76340629010105107675465685446170e-04
 	 8.73694821306689517470545069954824e-01 6.31525893466552135091518493936746e-02 6.31525893466552690203030806515017e-02 2.19736206409053150614973937138075e-03
 	 7.90157028273437589405148173682392e-01 1.04921485863281205297425913158804e-01 1.04921485863281205297425913158804e-01 4.46823558236708693464089847680043e-03
 	 6.92101001719601871542408844106831e-01 1.53949499140199119739946809204412e-01 1.53949499140199008717644346688758e-01 7.42694945977419914567851932929443e-03
 	 5.84443964021340578440799617965240e-01 2.07778017989329710779600191017380e-01 2.07778017989329710779600191017380e-01 1.06963902382826315379249493275893e-02
 	 4.72584386004117895652143488405272e-01 2.63707806997941052173928255797364e-01 2.63707806997941052173928255797364e-01 1.37485597573490398587425787013672e-02
 	 3.62131397282238864931969146709889e-01 3.18934301358880567534015426645055e-01 3.18934301358880567534015426645055e-01 1.60031582687383475138709343355004e-02
 	 2.58623540705762433589143256540410e-01 3.70688229647118783205428371729795e-01 3.70688229647118783205428371729795e-01 1.69413100771513454312344748586838e-02
 	 1.67251011391557513618977282021660e-01 4.16374494304221243190511358989170e-01 4.16374494304221243190511358989170e-01 1.62119753301239628850982654739710e-02
 	 9.25952246990027205697515455540270e-02 4.53702387650498639715124227222987e-01 4.53702387650498639715124227222987e-01 1.37098298408948465754164658392256e-02
 	 3.83981387396783446774861658923328e-02 4.80800930630160827661256917053834e-01 4.80800930630160827661256917053834e-01 9.60909748453290385450387134369521e-03
 	 7.36465102608935273664769738388713e-03 4.96317674486955351387251766936970e-01 4.96317674486955240364949304421316e-01 4.35213989853370803589927007237748e-03
 	 9.81389634989011994115060133481165e-01 7.16072581562267503063612394953452e-03 1.14496391953653308543037425693001e-02 1.30804509565252884226854712679255e-04
 	 9.38524459100731012206608738779323e-01 2.36539956355962324718866796047223e-02 3.78215452636727553215045816159545e-02 7.55414548125156633251453541788578e-04
 	 8.73694821306689517470545069954824e-01 4.85985499576188778592111816578836e-02 7.77066287356916046702437483872927e-02 2.13813268130618990350844121905993e-03
 	 7.90157028273437589405148173682392e-01 8.07414569237189516659469745718525e-02 1.29101514802843458928904851745756e-01 4.34779533266787740486414293172857e-03
 	 6.92101001719601760520106381591177e-01 1.18470556826212408685350396808644e-01 1.89428441454185830794543221600179e-01 7.22675776644259026948446944516036e-03
 	 5.84443964021340578440799617965240e-01 1.59893845871013129400495245135971e-01 2.55662190107646292158705136898789e-01 1.04080715300518371335680711808891e-02
 	 4.72584386004117951163294719663099e-01 2.02934149892973925144445956902928e-01 3.24481464102908179203410554691800e-01 1.33779705304259578096948146708201e-02
 	 3.62131397282238864931969146709889e-01 2.45433239367385591656045562558575e-01 3.92435363350375543411985290731536e-01 1.55717968639214280474059037828738e-02
 	 2.58623540705762433589143256540410e-01 2.85260044498253595435244278633036e-01 4.56116414795983970975612464826554e-01 1.64846610087862194271579596716037e-02
 	 1.67251011391557513618977282021660e-01 3.20417529540199641502340455190279e-01 5.12331459068242844878682262788061e-01 1.57749853100402036287785989543409e-02
 	 9.25952246990027205697515455540270e-02 3.49142899447741128504674179566791e-01 5.58261875853256150925574274879182e-01 1.33402845698515730432642811820187e-02
 	 3.83981387396783446774861658923328e-02 3.69996357847472534530197663116269e-01 5.91605503412849120792316170991398e-01 9.35008649930457041987708066699270e-03
 	 7.36465102608929722549646612606011e-03 3.81937139045922968705326638882980e-01 6.10698209927987734069176894990960e-01 4.23482898095948155636758514219764e-03
 	 9.81389634989011994115060133481165e-01 5.13187560470877886242835330676826e-03 1.34784894062792270225115132120663e-02 1.20129459672037129788421672138554e-04
 	 9.38524459100731012206608738779323e-01 1.69521032199511159643812163722032e-02 4.45234376793178718290100448484736e-02 6.93764624754018952197676117776837e-04
 	 8.73694821306689628492847532470478e-01 3.48291108154988038325683419316192e-02 9.14760678778115676745841255979030e-02 1.96363813882352057638147613261026e-03
 	 7.90157028273437589405148173682392e-01 5.78649600256265495001883891745820e-02 1.51978011700935861094663437143026e-01 3.99296863551515650997414397238572e-03
 	 6.92101001719601760520106381591177e-01 8.49042647501281055877342396343010e-02 2.22994733530270133892159378774522e-01 6.63697687907590337663688018210451e-03
 	 5.84443964021340578440799617965240e-01 1.14591083096394874552004239376402e-01 3.00964952882264547007196142658358e-01 9.55866134347080516342476386171256e-03
 	 4.72584386004117895652143488405272e-01 1.45436767167646086029719754151301e-01 3.81978846828236018318136757443426e-01 1.22861847551731170891109456988488e-02
 	 3.62131397282238864931969146709889e-01 1.75894579142549023487163140089251e-01 4.61974023575212111580867713200860e-01 1.43009713472640152820414272127891e-02
 	 2.58623540705762433589143256540410e-01 2.04437245755852314843536987609696e-01 5.36939213538385251567319755849894e-01 1.51393359941791715711500998509109e-02
 	 1.67251011391557513618977282021660e-01 2.29633551892311604802898727939464e-01 6.03115436716130881578123990038875e-01 1.44875774384834662966703433539806e-02
 	 9.25952246990027205697515455540270e-02 2.50220155661322052331740906083724e-01 6.57184619639675227098507548362250e-01 1.22515743728853088861940889842117e-02
 	 3.83981387396783446774861658923328e-02 2.65165198550956104917020184075227e-01 6.96436662709365550405493650032440e-01 8.58701923031131818253580689770388e-03
 	 7.36465102608929722549646612606011e-03 2.73722795268289020853558213275392e-01 7.18912553705621681920945320598548e-01 3.88922154883630452615328465526545e-03
 	 9.81389634989011994115060133481165e-01 3.32800466971812196337321410055665e-03 1.52823603412698839215666524182780e-02 1.02978478636877462688153928027646e-04
 	 9.38524459100731012206608738779323e-01 1.09933839054429730031081646757229e-02 5.04821569938260147902830965449539e-02 5.94715282864815880832509709108535e-04
 	 8.73694821306689517470545069954824e-01 2.25865652958841811592805015607155e-02 1.03718613397426301370174428484461e-01 1.68328791856262125620213865317965e-03
 	 7.90157028273437589405148173682392e-01 3.75252387259035480315816357688163e-02 1.72317733000658862563270190548792e-01 3.42288924342704818995497539901862e-03
 	 6.92101001719601760520106381591177e-01 5.50601400603210056061698196572252e-02 2.52838858220077233873723798751598e-01 5.68941027139623252406597231356500e-03
 	 5.84443964021340578440799617965240e-01 7.43119453836606491670124796655728e-02 3.41244090594998772392187902369187e-01 8.19396345944675523476075085227421e-03
 	 4.72584386004117895652143488405272e-01 9.43152713675529108527939570194576e-02 4.33100342628329193495062554575270e-01 1.05320761268173062469299949839296e-02
 	 3.62131397282238864931969146709889e-01 1.14067063556137271440604763483861e-01 5.23801539161623863627426089806249e-01 1.22592099922149803947757362720949e-02
 	 2.58623540705762433589143256540410e-01 1.32576890194982977000393020716729e-01 6.08799569099254589410463722742861e-01 1.29778806340206057795549909883448e-02
 	 1.67251011391557513618977282021660e-01 1.48916612928099101331724796182243e-01 6.83832375680343385049297921796096e-01 1.24191741794394631265285866561499e-02
 	 9.25952246990027205697515455540270e-02 1.62266958640695735383019382425118e-01 7.45137816660301544047229072020855e-01 1.05024070970658224555283055678956e-02
 	 3.83981387396783446774861658923328e-02 1.71958770437576236034260546148289e-01 7.89643090822745419288253287959378e-01 7.36104348406476597516112647667796e-03
 	 7.36465102608929722549646612606011e-03 1.77508344127693784564314682938857e-01 8.15127004846216918210188850935083e-01 3.33395421301599208241395189133982e-03
 	 9.81389634989011994115060133481165e-01 1.84635207881512358740749846219842e-03 1.67640129321728822975323680566362e-02 8.02767637205732887588707780146535e-05
 	 9.38524459100731012206608738779323e-01 6.09904709921772758551838933271938e-03 5.53764938000512602078728718879574e-02 4.63609667529657823708405528506660e-04
 	 8.73694821306689517470545069954824e-01 1.25308573532985634280123576900223e-02 1.13774321340011919101442572355154e-01 1.31220531028272886266139440891720e-03
 	 7.90157028273437589405148173682392e-01 2.08187215480902798603324299619999e-02 1.89024250178472130734519396355608e-01 2.66830967667728343600819229664012e-03
 	 6.92101001719601760520106381591177e-01 3.05469535500489941526325310405809e-02 2.77352044730349245327261087368242e-01 4.43517373835740618542855528971813e-03
 	 5.84443964021340578440799617965240e-01 4.12277110330914742242214288125979e-02 3.74328324945567947334978953222162e-01 6.38759551778287932438660234879535e-03
 	 4.72584386004117895652143488405272e-01 5.23254065530632805902655491081532e-02 4.75090207442818823757590962486574e-01 8.21026876597135552016126780472405e-03
 	 3.62131397282238864931969146709889e-01 6.32835530062669793238683269009925e-02 5.74585049711494155744162526389118e-01 9.55665413757149882767460979948737e-03
 	 2.58623540705762433589143256540410e-01 7.35526662692705945900684127991553e-02 6.67823793024966971820788330660434e-01 1.01168930735979108181954444489747e-02
 	 1.67251011391557513618977282021660e-01 8.26178221297961812297216965816915e-02 7.50131166478646305151301021396648e-01 9.68135404993721200572753815549731e-03
 	 9.25952246990027205697515455540270e-02 9.00244939964679469213137963379268e-02 8.17380281304529332508934658108046e-01 8.18714030531913529442622490250869e-03
 	 3.83981387396783446774861658923328e-02 9.54014386328378982682352216215804e-02 8.66200422627483757054278612486087e-01 5.73829363503064113216645125703508e-03
 	 7.36465102608929722549646612606011e-03 9.84803005745052972841335758857895e-02 8.94155048399405405490369957988150e-01 2.59898046811550802875911969636036e-03
 	 9.81389634989011994115060133481165e-01 7.66761933975044357447714560294116e-04 1.78436030770129615274921519585405e-02 5.32514506499774201175347043690778e-05
 	 9.38524459100731012206608738779323e-01 2.53284148936652048211826127044333e-03 5.89426994099024673112729999502335e-02 3.07534661178437778404626268269340e-04
 	 8.73694821306689628492847532470478e-01 5.20387445537828785546707877074368e-03 1.21101304237932083651685388758779e-01 8.70449094913514141540200608204714e-04
 	 7.90157028273437589405148173682392e-01 8.64569839103804249624829481035704e-03 2.01197273335524368098603531507251e-01 1.77001855183186031054975995147061e-03
 	 6.92101001719601871542408844106831e-01 1.26856851679731374993309600540670e-02 2.95213313112424990958260195839102e-01 2.94206473338046821039415412712970e-03
 	 5.84443964021340578440799617965240e-01 1.71212412885975995280318784352858e-02 3.98434794690061822031168503599474e-01 4.23720030208515723024742527513808e-03
 	 4.72584386004117895652143488405272e-01 2.17299454340282860442812307155691e-02 5.05685668561853818303575280879159e-01 5.44626740978257709024923371998739e-03
 	 3.62131397282238864931969146709889e-01 2.62806969746728347203656994679477e-02 6.11587905743088300347665153822163e-01 6.33938978852194388174945416380979e-03
 	 2.58623540705762433589143256540410e-01 3.05453035121229232728978786326479e-02 7.10831155782114643137958864826942e-01 6.71102330576051411825666548338631e-03
 	 1.67251011391557513618977282021660e-01 3.43099248533907941194343038660008e-02 7.98439063755051692261588414112339e-01 6.42210925704104606398514576426351e-03
 	 9.25952246990027205697515455540270e-02 3.73858030187580459013929612410720e-02 8.70018972282239233528855493204901e-01 5.43092518590670373518358715614340e-03
 	 3.83981387396783446774861658923328e-02 3.96187663390070721192159908241592e-02 9.21983094921314583203297843283508e-01 3.80648703508462129749267965905801e-03
 	 7.36465102608929722549646612606011e-03 4.08973708716540151897333998931572e-02 9.51737978102256687584770133980783e-01 1.72402914272737741233076924629586e-03
 	 9.81389634989011994115060133481165e-01 1.47179562522949114455883545815595e-04 1.84631854484650567704839829730190e-02 2.34020503972596828374131555650095e-05
 	 9.38524459100730901184306276263669e-01 4.86177633274464948698323496500961e-04 6.09893632659946338669954002398299e-02 1.35150151816662897731949333213208e-04
 	 8.73694821306689628492847532470478e-01 9.98881050075506315977236226899549e-04 1.25306297643234865191175231302623e-01 3.82530303658943976116701968237521e-04
 	 7.90157028273437589405148173682392e-01 1.65953740074395450498911941394908e-03 2.08183434325818456089862706903659e-01 7.77857933417093797522079423600871e-04
 	 6.92101001719601871542408844106831e-01 2.43501080400126967973051250737626e-03 3.05463987476396858777860643385793e-01 1.29292904366351329645268286583359e-03
 	 5.84443964021340578440799617965240e-01 3.28641354121744777572189377679024e-03 4.12269622437441973783478488257970e-01 1.86209340407373193440609959736776e-03
 	 4.72584386004117895652143488405272e-01 4.17105195356759494984544289764017e-03 5.23244562042314509398011068697087e-01 2.39343384724748043865250046735582e-03
 	 3.62131397282238864931969146709889e-01 5.04456639295869369021829697885551e-03 6.32824036324802441377812556311255e-01 2.78592822370233098028258211797947e-03
 	 2.58623540705762433589143256540410e-01 5.86315544479187877868753275834024e-03 7.35513303849445687632169210701250e-01 2.94924746089820230890432561920989e-03
 	 1.67251011391557513618977282021660e-01 6.58577259298542827536948607303202e-03 8.26163216015457058105653231905308e-01 2.82228038214103011879774207670835e-03
 	 9.25952246990027205697515455540270e-02 7.17618583951384891861380310729146e-03 9.00228589461483430511634651338682e-01 2.38669150517103285588649264070682e-03
 	 3.83981387396783446774861658923328e-02 7.60480201102919917133249327889644e-03 9.53997059249292456151181340828771e-01 1.67281079377700793442418358836221e-03
 	 7.36465102608929722549646612606011e-03 7.85022949955771487395850272150710e-03 9.84785119474352987900545031152433e-01 7.57647282693651763670061871636108e-04
 	 ];
 
 	 case  25 

 	 % ALG. DEG.:   25
 	 % PTS CARD.:  169
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 9.81389634989011994115060133481165e-01 1.84631854484650567704839829730190e-02 1.47179562522949114455883545815595e-04 2.34020503972595879697230630833715e-05
 	 9.38524459100730901184306276263669e-01 6.09893632659945228446929377241759e-02 4.86177633274575971000786012155004e-04 1.35150151816662382735917402598602e-04
 	 8.73694821306689517470545069954824e-01 1.25306297643234920702326462560450e-01 9.98881050075561827128467484726571e-04 3.82530303658942512443769112806535e-04
 	 7.90157028273437589405148173682392e-01 2.08183434325818456089862706903659e-01 1.65953740074395450498911941394908e-03 7.77857933417090761755996464188456e-04
 	 6.92101001719601649497803919075523e-01 3.05463987476396969800163105901447e-01 2.43501080400138070203297502303030e-03 1.29292904366350830912268943251320e-03
 	 5.84443964021340578440799617965240e-01 4.12269622437441973783478488257970e-01 3.28641354121744777572189377679024e-03 1.86209340407372456183132669593761e-03
 	 4.72584386004117895652143488405272e-01 5.23244562042314509398011068697087e-01 4.17105195356759494984544289764017e-03 2.39343384724747133135425158911858e-03
 	 3.62131397282238864931969146709889e-01 6.32824036324802441377812556311255e-01 5.04456639295869369021829697885551e-03 2.78592822370231970457998826873336e-03
 	 2.58623540705762433589143256540410e-01 7.35513303849445687632169210701250e-01 5.86315544479187877868753275834024e-03 2.94924746089819059952086277576200e-03
 	 1.67251011391557513618977282021660e-01 8.26163216015457058105653231905308e-01 6.58577259298542827536948607303202e-03 2.82228038214101884309514822746223e-03
 	 9.25952246990027205697515455540270e-02 9.00228589461483430511634651338682e-01 7.17618583951384891861380310729146e-03 2.38669150517102331490737476826780e-03
 	 3.83981387396783446774861658923328e-02 9.53997059249292456151181340828771e-01 7.60480201102919917133249327889644e-03 1.67281079377700121237071417823472e-03
 	 7.36465102608929722549646612606011e-03 9.84785119474352987900545031152433e-01 7.85022949955771487395850272150710e-03 7.57647282693648836324196160774136e-04
 	 9.81389634989011994115060133481165e-01 1.78436030770129580580452000049263e-02 7.66761933975047826894666513908305e-04 5.32514506499773252498446118874398e-05
 	 9.38524459100731012206608738779323e-01 5.89426994099024534334851921357767e-02 2.53284148936653435990606908490008e-03 3.07534661178437182093431401241901e-04
 	 8.73694821306689628492847532470478e-01 1.21101304237932111407261004387692e-01 5.20387445537826009989146314183017e-03 8.70449094913512515236941879948063e-04
 	 7.90157028273437589405148173682392e-01 2.01197273335524312587452300249424e-01 8.64569839103809800739952606818406e-03 1.77001855183185705794324249495730e-03
 	 6.92101001719601871542408844106831e-01 2.95213313112424990958260195839102e-01 1.26856851679731374993309600540670e-02 2.94206473338046257254285720250664e-03
 	 5.84443964021340578440799617965240e-01 3.98434794690061711008866041083820e-01 1.71212412885977105503343409509398e-02 4.23720030208514942399178337950616e-03
 	 4.72584386004117895652143488405272e-01 5.05685668561853707281272818363504e-01 2.17299454340283970665836932312232e-02 5.44626740978256668190837785914482e-03
 	 3.62131397282238864931969146709889e-01 6.11587905743088189325362691306509e-01 2.62806969746729457426681619836017e-02 6.33938978852193260604686031456367e-03
 	 2.58623540705762433589143256540410e-01 7.10831155782114532115656402311288e-01 3.05453035121230342952003411483020e-02 6.71102330576050197519233364573665e-03
 	 1.67251011391557513618977282021660e-01 7.98439063755051470216983489081031e-01 3.43099248533910161640392288973089e-02 6.42210925704103392092081392661385e-03
 	 9.25952246990027205697515455540270e-02 8.70018972282239122506553030689247e-01 3.73858030187581569236954237567261e-02 5.43092518590669419420446928370438e-03
 	 3.83981387396783446774861658923328e-02 9.21983094921314361158692918252200e-01 3.96187663390072941638209158554673e-02 3.80648703508461435859877575182963e-03
 	 7.36465102608929722549646612606011e-03 9.51737978102256465540165208949475e-01 4.08973708716542372343383249244653e-02 1.72402914272737415972425178978256e-03
 	 9.81389634989011994115060133481165e-01 1.67640129321728822975323680566362e-02 1.84635207881512358740749846219842e-03 8.02767637205731938911806855330155e-05
 	 9.38524459100731012206608738779323e-01 5.53764938000512602078728718879574e-02 6.09904709921772758551838933271938e-03 4.63609667529657227397210661479221e-04
 	 8.73694821306689628492847532470478e-01 1.13774321340011863590291341097327e-01 1.25308573532985079168611264321953e-02 1.31220531028272734477835292921100e-03
 	 7.90157028273437589405148173682392e-01 1.89024250178472130734519396355608e-01 2.08187215480902798603324299619999e-02 2.66830967667727996656124034302593e-03
 	 6.92101001719601760520106381591177e-01 2.77352044730349245327261087368242e-01 3.05469535500489941526325310405809e-02 4.43517373835740098125812735929685e-03
 	 5.84443964021340578440799617965240e-01 3.74328324945567947334978953222162e-01 4.12277110330914742242214288125979e-02 6.38759551778287151813096045316342e-03
 	 4.72584386004117895652143488405272e-01 4.75090207442818823757590962486574e-01 5.23254065530632805902655491081532e-02 8.21026876597134511182041194388148e-03
 	 3.62131397282238864931969146709889e-01 5.74585049711494155744162526389118e-01 6.32835530062669793238683269009925e-02 9.55665413757148668461027796183771e-03
 	 2.58623540705762433589143256540410e-01 6.67823793024966971820788330660434e-01 7.35526662692705945900684127991553e-02 1.01168930735978986751311126113251e-02
 	 1.67251011391557513618977282021660e-01 7.50131166478646305151301021396648e-01 8.26178221297961812297216965816915e-02 9.68135404993720159738668229465475e-03
 	 9.25952246990027205697515455540270e-02 8.17380281304529332508934658108046e-01 9.00244939964679469213137963379268e-02 8.18714030531912662080884501847322e-03
 	 3.83981387396783446774861658923328e-02 8.66200422627483757054278612486087e-01 9.54014386328378982682352216215804e-02 5.73829363503063419327254734980670e-03
 	 7.36465102608929722549646612606011e-03 8.94155048399405405490369957988150e-01 9.84803005745052972841335758857895e-02 2.59898046811550499299303673694794e-03
 	 9.81389634989011994115060133481165e-01 1.52823603412698873910136043718921e-02 3.32800466971811849392626214694246e-03 1.02978478636877286505300899133175e-04
 	 9.38524459100731123228911201294977e-01 5.04821569938260217291770004521823e-02 1.09933839054428550419117982528405e-02 5.94715282864814796630337223604101e-04
 	 8.73694821306689517470545069954824e-01 1.03718613397426259736811005041091e-01 2.25865652958842227926439250040858e-02 1.68328791856261843727649019086812e-03
 	 7.90157028273437589405148173682392e-01 1.72317733000658890318845806177706e-01 3.75252387259035202760060201399028e-02 3.42288924342704255210367847439556e-03
 	 6.92101001719601649497803919075523e-01 2.52838858220077289384875030009425e-01 5.50601400603210611173210509150522e-02 5.68941027139622298308685444112598e-03
 	 5.84443964021340578440799617965240e-01 3.41244090594998827903339133627014e-01 7.43119453836605936558612484077457e-02 8.19396345944674135697294303781746e-03
 	 4.72584386004117951163294719663099e-01 4.33100342628329249006213785833097e-01 9.43152713675528553416427257616306e-02 1.05320761268172871649717592390516e-02
 	 3.62131397282238864931969146709889e-01 5.23801539161623974649728552321903e-01 1.14067063556137160418302300968207e-01 1.22592099922149595780940245504098e-02
 	 2.58623540705762433589143256540410e-01 6.08799569099254700432766185258515e-01 1.32576890194982865978090558201075e-01 1.29778806340205832281498032898526e-02
 	 1.67251011391557513618977282021660e-01 6.83832375680343496071600384311751e-01 1.48916612928098990309422333666589e-01 1.24191741794394405751233989576576e-02
 	 9.25952246990027205697515455540270e-02 7.45137816660301655069531534536509e-01 1.62266958640695624360716919909464e-01 1.05024070970658051082935457998246e-02
 	 3.83981387396783446774861658923328e-02 7.89643090822745530310555750475032e-01 1.71958770437576125011958083632635e-01 7.36104348406475296473505665062476e-03
 	 7.36465102608940824779892864171416e-03 8.15127004846216918210188850935083e-01 1.77508344127693673542012220423203e-01 3.33395421301598601088178597251499e-03
 	 9.81389634989011994115060133481165e-01 1.34784894062792252877880372352593e-02 5.13187560470878059715182928357535e-03 1.20129459672037238208638920688998e-04
 	 9.38524459100731012206608738779323e-01 4.45234376793178648901161409412452e-02 1.69521032199511229032751202794316e-02 6.93764624754019602718979609079497e-04
 	 8.73694821306689628492847532470478e-01 9.14760678778116093079475490412733e-02 3.48291108154987621992049184882489e-02 1.96363813882352231110495210941735e-03
 	 7.90157028273437589405148173682392e-01 1.51978011700935833339087821514113e-01 5.78649600256265772557640048034955e-02 3.99296863551515997942109592599991e-03
 	 6.92101001719601760520106381591177e-01 2.22994733530270106136583763145609e-01 8.49042647501281333433098552632146e-02 6.63697687907590944816904610092934e-03
 	 5.84443964021340578440799617965240e-01 3.00964952882264491496044911400531e-01 1.14591083096394930063155470634229e-01 9.55866134347081383704214374574804e-03
 	 4.72584386004117840140992257147445e-01 3.81978846828235962806985526185599e-01 1.45436767167646141540870985409128e-01 1.22861847551731292321752775364985e-02
 	 3.62131397282238920443120377967716e-01 4.61974023575212056069716481943033e-01 1.75894579142549078998314371347078e-01 1.43009713472640291598292350272459e-02
 	 2.58623540705762433589143256540410e-01 5.36939213538385251567319755849894e-01 2.04437245755852314843536987609696e-01 1.51393359941791854489379076653677e-02
 	 1.67251011391557513618977282021660e-01 6.03115436716130770555821527523221e-01 2.29633551892311715825201190455118e-01 1.44875774384834801744581511684373e-02
 	 9.25952246990027205697515455540270e-02 6.57184619639675116076205085846595e-01 2.50220155661322163354043368599378e-01 1.22515743728853210292584208218614e-02
 	 3.83981387396783446774861658923328e-02 6.96436662709365439383191187516786e-01 2.65165198550956215939322646590881e-01 8.58701923031132512142971080493226e-03
 	 7.36465102608940824779892864171416e-03 7.18912553705621570898642858082894e-01 2.73722795268289020853558213275392e-01 3.88922154883630799560023660887964e-03
 	 9.81389634989011994115060133481165e-01 1.14496391953653325890272185461072e-02 7.16072581562267329591264797272743e-03 1.30804509565253317907723706881029e-04
 	 9.38524459100731012206608738779323e-01 3.78215452636727622603984855231829e-02 2.36539956355962255329927756974939e-02 7.55414548125159126916450258448776e-04
 	 8.73694821306689517470545069954824e-01 7.77066287356915491590925171294657e-02 4.85985499576189333703624129157106e-02 2.13813268130619727608321412049008e-03
 	 7.90157028273437589405148173682392e-01 1.29101514802843458928904851745756e-01 8.07414569237189516659469745718525e-02 4.34779533266789215001368873458887e-03
 	 6.92101001719601871542408844106831e-01 1.89428441454185858550118837229093e-01 1.18470556826212269907472318664077e-01 7.22675776644261455561313312045968e-03
 	 5.84443964021340578440799617965240e-01 2.55662190107646347669856368156616e-01 1.59893845871013073889344013878144e-01 1.04080715300518718280375907170310e-02
 	 4.72584386004117895652143488405272e-01 3.24481464102908234714561785949627e-01 2.02934149892973869633294725645101e-01 1.33779705304260029125051900678045e-02
 	 3.62131397282238920443120377967716e-01 3.92435363350375598923136521989363e-01 2.45433239367385536144894331300748e-01 1.55717968639214800891101830870866e-02
 	 2.58623540705762378077992025282583e-01 4.56116414795984026486763696084381e-01 2.85260044498253539924093047375209e-01 1.64846610087862714688622389758166e-02
 	 1.67251011391557513618977282021660e-01 5.12331459068242844878682262788061e-01 3.20417529540199641502340455190279e-01 1.57749853100402556704828782585537e-02
 	 9.25952246990027205697515455540270e-02 5.58261875853256261947876737394836e-01 3.49142899447741017482371717051137e-01 1.33402845698516164113511806021961e-02
 	 3.83981387396783446774861658923328e-02 5.91605503412849231814618633507052e-01 3.69996357847472423507895200600615e-01 9.35008649930460164489964824952040e-03
 	 7.36465102608918620319400361040607e-03 6.10698209927987845091479357506614e-01 3.81937139045922968705326638882980e-01 4.23482898095949543415539295665440e-03
 	 9.81389634989012105137362595996819e-01 9.30518250549400294246993325941730e-03 9.30518250549389192016747074376326e-03 1.34427984588433141986685281921154e-04
 	 9.38524459100730901184306276263669e-01 3.07377704496344938966956306103384e-02 3.07377704496346049189980931259925e-02 7.76340629010105107675465685446170e-04
 	 8.73694821306689517470545069954824e-01 6.31525893466552135091518493936746e-02 6.31525893466552690203030806515017e-02 2.19736206409053150614973937138075e-03
 	 7.90157028273437589405148173682392e-01 1.04921485863281205297425913158804e-01 1.04921485863281205297425913158804e-01 4.46823558236708693464089847680043e-03
 	 6.92101001719601871542408844106831e-01 1.53949499140199119739946809204412e-01 1.53949499140199008717644346688758e-01 7.42694945977419914567851932929443e-03
 	 5.84443964021340578440799617965240e-01 2.07778017989329710779600191017380e-01 2.07778017989329710779600191017380e-01 1.06963902382826315379249493275893e-02
 	 4.72584386004117895652143488405272e-01 2.63707806997941052173928255797364e-01 2.63707806997941052173928255797364e-01 1.37485597573490398587425787013672e-02
 	 3.62131397282238864931969146709889e-01 3.18934301358880567534015426645055e-01 3.18934301358880567534015426645055e-01 1.60031582687383475138709343355004e-02
 	 2.58623540705762433589143256540410e-01 3.70688229647118783205428371729795e-01 3.70688229647118783205428371729795e-01 1.69413100771513454312344748586838e-02
 	 1.67251011391557513618977282021660e-01 4.16374494304221243190511358989170e-01 4.16374494304221243190511358989170e-01 1.62119753301239628850982654739710e-02
 	 9.25952246990027205697515455540270e-02 4.53702387650498639715124227222987e-01 4.53702387650498639715124227222987e-01 1.37098298408948465754164658392256e-02
 	 3.83981387396783446774861658923328e-02 4.80800930630160827661256917053834e-01 4.80800930630160827661256917053834e-01 9.60909748453290385450387134369521e-03
 	 7.36465102608935273664769738388713e-03 4.96317674486955351387251766936970e-01 4.96317674486955240364949304421316e-01 4.35213989853370803589927007237748e-03
 	 9.81389634989011994115060133481165e-01 7.16072581562267503063612394953452e-03 1.14496391953653308543037425693001e-02 1.30804509565252884226854712679255e-04
 	 9.38524459100731012206608738779323e-01 2.36539956355962324718866796047223e-02 3.78215452636727553215045816159545e-02 7.55414548125156633251453541788578e-04
 	 8.73694821306689517470545069954824e-01 4.85985499576188778592111816578836e-02 7.77066287356916046702437483872927e-02 2.13813268130618990350844121905993e-03
 	 7.90157028273437589405148173682392e-01 8.07414569237189516659469745718525e-02 1.29101514802843458928904851745756e-01 4.34779533266787740486414293172857e-03
 	 6.92101001719601760520106381591177e-01 1.18470556826212408685350396808644e-01 1.89428441454185830794543221600179e-01 7.22675776644259026948446944516036e-03
 	 5.84443964021340578440799617965240e-01 1.59893845871013129400495245135971e-01 2.55662190107646292158705136898789e-01 1.04080715300518371335680711808891e-02
 	 4.72584386004117951163294719663099e-01 2.02934149892973925144445956902928e-01 3.24481464102908179203410554691800e-01 1.33779705304259578096948146708201e-02
 	 3.62131397282238864931969146709889e-01 2.45433239367385591656045562558575e-01 3.92435363350375543411985290731536e-01 1.55717968639214280474059037828738e-02
 	 2.58623540705762433589143256540410e-01 2.85260044498253595435244278633036e-01 4.56116414795983970975612464826554e-01 1.64846610087862194271579596716037e-02
 	 1.67251011391557513618977282021660e-01 3.20417529540199641502340455190279e-01 5.12331459068242844878682262788061e-01 1.57749853100402036287785989543409e-02
 	 9.25952246990027205697515455540270e-02 3.49142899447741128504674179566791e-01 5.58261875853256150925574274879182e-01 1.33402845698515730432642811820187e-02
 	 3.83981387396783446774861658923328e-02 3.69996357847472534530197663116269e-01 5.91605503412849120792316170991398e-01 9.35008649930457041987708066699270e-03
 	 7.36465102608929722549646612606011e-03 3.81937139045922968705326638882980e-01 6.10698209927987734069176894990960e-01 4.23482898095948155636758514219764e-03
 	 9.81389634989011994115060133481165e-01 5.13187560470877886242835330676826e-03 1.34784894062792270225115132120663e-02 1.20129459672037129788421672138554e-04
 	 9.38524459100731012206608738779323e-01 1.69521032199511159643812163722032e-02 4.45234376793178718290100448484736e-02 6.93764624754018952197676117776837e-04
 	 8.73694821306689628492847532470478e-01 3.48291108154988038325683419316192e-02 9.14760678778115676745841255979030e-02 1.96363813882352057638147613261026e-03
 	 7.90157028273437589405148173682392e-01 5.78649600256265495001883891745820e-02 1.51978011700935861094663437143026e-01 3.99296863551515650997414397238572e-03
 	 6.92101001719601760520106381591177e-01 8.49042647501281055877342396343010e-02 2.22994733530270133892159378774522e-01 6.63697687907590337663688018210451e-03
 	 5.84443964021340578440799617965240e-01 1.14591083096394874552004239376402e-01 3.00964952882264547007196142658358e-01 9.55866134347080516342476386171256e-03
 	 4.72584386004117895652143488405272e-01 1.45436767167646086029719754151301e-01 3.81978846828236018318136757443426e-01 1.22861847551731170891109456988488e-02
 	 3.62131397282238864931969146709889e-01 1.75894579142549023487163140089251e-01 4.61974023575212111580867713200860e-01 1.43009713472640152820414272127891e-02
 	 2.58623540705762433589143256540410e-01 2.04437245755852314843536987609696e-01 5.36939213538385251567319755849894e-01 1.51393359941791715711500998509109e-02
 	 1.67251011391557513618977282021660e-01 2.29633551892311604802898727939464e-01 6.03115436716130881578123990038875e-01 1.44875774384834662966703433539806e-02
 	 9.25952246990027205697515455540270e-02 2.50220155661322052331740906083724e-01 6.57184619639675227098507548362250e-01 1.22515743728853088861940889842117e-02
 	 3.83981387396783446774861658923328e-02 2.65165198550956104917020184075227e-01 6.96436662709365550405493650032440e-01 8.58701923031131818253580689770388e-03
 	 7.36465102608929722549646612606011e-03 2.73722795268289020853558213275392e-01 7.18912553705621681920945320598548e-01 3.88922154883630452615328465526545e-03
 	 9.81389634989011994115060133481165e-01 3.32800466971812196337321410055665e-03 1.52823603412698839215666524182780e-02 1.02978478636877462688153928027646e-04
 	 9.38524459100731012206608738779323e-01 1.09933839054429730031081646757229e-02 5.04821569938260147902830965449539e-02 5.94715282864815880832509709108535e-04
 	 8.73694821306689517470545069954824e-01 2.25865652958841811592805015607155e-02 1.03718613397426301370174428484461e-01 1.68328791856262125620213865317965e-03
 	 7.90157028273437589405148173682392e-01 3.75252387259035480315816357688163e-02 1.72317733000658862563270190548792e-01 3.42288924342704818995497539901862e-03
 	 6.92101001719601760520106381591177e-01 5.50601400603210056061698196572252e-02 2.52838858220077233873723798751598e-01 5.68941027139623252406597231356500e-03
 	 5.84443964021340578440799617965240e-01 7.43119453836606491670124796655728e-02 3.41244090594998772392187902369187e-01 8.19396345944675523476075085227421e-03
 	 4.72584386004117895652143488405272e-01 9.43152713675529108527939570194576e-02 4.33100342628329193495062554575270e-01 1.05320761268173062469299949839296e-02
 	 3.62131397282238864931969146709889e-01 1.14067063556137271440604763483861e-01 5.23801539161623863627426089806249e-01 1.22592099922149803947757362720949e-02
 	 2.58623540705762433589143256540410e-01 1.32576890194982977000393020716729e-01 6.08799569099254589410463722742861e-01 1.29778806340206057795549909883448e-02
 	 1.67251011391557513618977282021660e-01 1.48916612928099101331724796182243e-01 6.83832375680343385049297921796096e-01 1.24191741794394631265285866561499e-02
 	 9.25952246990027205697515455540270e-02 1.62266958640695735383019382425118e-01 7.45137816660301544047229072020855e-01 1.05024070970658224555283055678956e-02
 	 3.83981387396783446774861658923328e-02 1.71958770437576236034260546148289e-01 7.89643090822745419288253287959378e-01 7.36104348406476597516112647667796e-03
 	 7.36465102608929722549646612606011e-03 1.77508344127693784564314682938857e-01 8.15127004846216918210188850935083e-01 3.33395421301599208241395189133982e-03
 	 9.81389634989011994115060133481165e-01 1.84635207881512358740749846219842e-03 1.67640129321728822975323680566362e-02 8.02767637205732887588707780146535e-05
 	 9.38524459100731012206608738779323e-01 6.09904709921772758551838933271938e-03 5.53764938000512602078728718879574e-02 4.63609667529657823708405528506660e-04
 	 8.73694821306689517470545069954824e-01 1.25308573532985634280123576900223e-02 1.13774321340011919101442572355154e-01 1.31220531028272886266139440891720e-03
 	 7.90157028273437589405148173682392e-01 2.08187215480902798603324299619999e-02 1.89024250178472130734519396355608e-01 2.66830967667728343600819229664012e-03
 	 6.92101001719601760520106381591177e-01 3.05469535500489941526325310405809e-02 2.77352044730349245327261087368242e-01 4.43517373835740618542855528971813e-03
 	 5.84443964021340578440799617965240e-01 4.12277110330914742242214288125979e-02 3.74328324945567947334978953222162e-01 6.38759551778287932438660234879535e-03
 	 4.72584386004117895652143488405272e-01 5.23254065530632805902655491081532e-02 4.75090207442818823757590962486574e-01 8.21026876597135552016126780472405e-03
 	 3.62131397282238864931969146709889e-01 6.32835530062669793238683269009925e-02 5.74585049711494155744162526389118e-01 9.55665413757149882767460979948737e-03
 	 2.58623540705762433589143256540410e-01 7.35526662692705945900684127991553e-02 6.67823793024966971820788330660434e-01 1.01168930735979108181954444489747e-02
 	 1.67251011391557513618977282021660e-01 8.26178221297961812297216965816915e-02 7.50131166478646305151301021396648e-01 9.68135404993721200572753815549731e-03
 	 9.25952246990027205697515455540270e-02 9.00244939964679469213137963379268e-02 8.17380281304529332508934658108046e-01 8.18714030531913529442622490250869e-03
 	 3.83981387396783446774861658923328e-02 9.54014386328378982682352216215804e-02 8.66200422627483757054278612486087e-01 5.73829363503064113216645125703508e-03
 	 7.36465102608929722549646612606011e-03 9.84803005745052972841335758857895e-02 8.94155048399405405490369957988150e-01 2.59898046811550802875911969636036e-03
 	 9.81389634989011994115060133481165e-01 7.66761933975044357447714560294116e-04 1.78436030770129615274921519585405e-02 5.32514506499774201175347043690778e-05
 	 9.38524459100731012206608738779323e-01 2.53284148936652048211826127044333e-03 5.89426994099024673112729999502335e-02 3.07534661178437778404626268269340e-04
 	 8.73694821306689628492847532470478e-01 5.20387445537828785546707877074368e-03 1.21101304237932083651685388758779e-01 8.70449094913514141540200608204714e-04
 	 7.90157028273437589405148173682392e-01 8.64569839103804249624829481035704e-03 2.01197273335524368098603531507251e-01 1.77001855183186031054975995147061e-03
 	 6.92101001719601871542408844106831e-01 1.26856851679731374993309600540670e-02 2.95213313112424990958260195839102e-01 2.94206473338046821039415412712970e-03
 	 5.84443964021340578440799617965240e-01 1.71212412885975995280318784352858e-02 3.98434794690061822031168503599474e-01 4.23720030208515723024742527513808e-03
 	 4.72584386004117895652143488405272e-01 2.17299454340282860442812307155691e-02 5.05685668561853818303575280879159e-01 5.44626740978257709024923371998739e-03
 	 3.62131397282238864931969146709889e-01 2.62806969746728347203656994679477e-02 6.11587905743088300347665153822163e-01 6.33938978852194388174945416380979e-03
 	 2.58623540705762433589143256540410e-01 3.05453035121229232728978786326479e-02 7.10831155782114643137958864826942e-01 6.71102330576051411825666548338631e-03
 	 1.67251011391557513618977282021660e-01 3.43099248533907941194343038660008e-02 7.98439063755051692261588414112339e-01 6.42210925704104606398514576426351e-03
 	 9.25952246990027205697515455540270e-02 3.73858030187580459013929612410720e-02 8.70018972282239233528855493204901e-01 5.43092518590670373518358715614340e-03
 	 3.83981387396783446774861658923328e-02 3.96187663390070721192159908241592e-02 9.21983094921314583203297843283508e-01 3.80648703508462129749267965905801e-03
 	 7.36465102608929722549646612606011e-03 4.08973708716540151897333998931572e-02 9.51737978102256687584770133980783e-01 1.72402914272737741233076924629586e-03
 	 9.81389634989011994115060133481165e-01 1.47179562522949114455883545815595e-04 1.84631854484650567704839829730190e-02 2.34020503972596828374131555650095e-05
 	 9.38524459100730901184306276263669e-01 4.86177633274464948698323496500961e-04 6.09893632659946338669954002398299e-02 1.35150151816662897731949333213208e-04
 	 8.73694821306689628492847532470478e-01 9.98881050075506315977236226899549e-04 1.25306297643234865191175231302623e-01 3.82530303658943976116701968237521e-04
 	 7.90157028273437589405148173682392e-01 1.65953740074395450498911941394908e-03 2.08183434325818456089862706903659e-01 7.77857933417093797522079423600871e-04
 	 6.92101001719601871542408844106831e-01 2.43501080400126967973051250737626e-03 3.05463987476396858777860643385793e-01 1.29292904366351329645268286583359e-03
 	 5.84443964021340578440799617965240e-01 3.28641354121744777572189377679024e-03 4.12269622437441973783478488257970e-01 1.86209340407373193440609959736776e-03
 	 4.72584386004117895652143488405272e-01 4.17105195356759494984544289764017e-03 5.23244562042314509398011068697087e-01 2.39343384724748043865250046735582e-03
 	 3.62131397282238864931969146709889e-01 5.04456639295869369021829697885551e-03 6.32824036324802441377812556311255e-01 2.78592822370233098028258211797947e-03
 	 2.58623540705762433589143256540410e-01 5.86315544479187877868753275834024e-03 7.35513303849445687632169210701250e-01 2.94924746089820230890432561920989e-03
 	 1.67251011391557513618977282021660e-01 6.58577259298542827536948607303202e-03 8.26163216015457058105653231905308e-01 2.82228038214103011879774207670835e-03
 	 9.25952246990027205697515455540270e-02 7.17618583951384891861380310729146e-03 9.00228589461483430511634651338682e-01 2.38669150517103285588649264070682e-03
 	 3.83981387396783446774861658923328e-02 7.60480201102919917133249327889644e-03 9.53997059249292456151181340828771e-01 1.67281079377700793442418358836221e-03
 	 7.36465102608929722549646612606011e-03 7.85022949955771487395850272150710e-03 9.84785119474352987900545031152433e-01 7.57647282693651763670061871636108e-04
 	 ];
 
 	 case  26 

 	 % ALG. DEG.:   26
 	 % PTS CARD.:  196
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 9.83775234098600237508946975140134e-01 1.61134949049231875062293539713210e-02 1.11270996476574984823670888545166e-04 1.54425081516734449620879138231899e-05
 	 9.46302700060275281401800384628586e-01 5.33290387205057545005892905010114e-02 3.68261219218964097610324870402110e-04 8.96986599098077279921051307987057e-05
 	 8.89342808819515551199685887695523e-01 1.09898293578831962591380033700261e-01 7.58897601652486208934078604215756e-04 2.56248585077621215521509467905048e-04
 	 8.15389739443474703683989446290070e-01 1.83344185731363018554418431449449e-01 1.26607482516227776159212226048112e-03 5.27926395029755394019965741847500e-04
 	 7.27676452889264746559661034552846e-01 2.70455926176468575139466565815383e-01 1.86762093426667830087239963177126e-03 8.92858384862040086599188626337309e-04
 	 6.30036688370404052150774987239856e-01 3.67426067850859738861402092879871e-01 2.53724377873620898782291988027282e-03 1.31498134078933143903400448948560e-03
 	 5.26737861339873214561180247983430e-01 4.70016461644917726836467863904545e-01 3.24567701520905860235188811202534e-03 1.73909651877764744737353552750392e-03
 	 4.22294657307570209248126502643572e-01 5.73743384193808214632781528052874e-01 3.96195849862157611909196930355392e-03 2.09963656850344418391962619807600e-03
 	 3.21271743988936209213136407925049e-01 6.74073472709900367583202296373202e-01 4.65478330116342320366129570174962e-03 2.33166352414460606792823149646665e-03
 	 2.28084270649258069596498899045400e-01 7.66621857443884668903422152652638e-01 5.29387190685726150007894830196165e-03 2.38221127870602523632359570626704e-03
 	 1.46804867681213702113041108532343e-01 8.47343838491869671969425326096825e-01 5.85129382691662591753356537083164e-03 2.22000734410771061178024865512270e-03
 	 8.09854996819552308551237729261629e-02 9.12711810969661807568797939893557e-01 6.30268934838296157607828718028031e-03 1.84187358357148795590108036890342e-03
 	 3.35014045320132236582821860793047e-02 9.59870255653136106310796549223596e-01 6.62833981485067003092126469709910e-03 1.27469867346634941826510889484325e-03
 	 6.41676079281838784851288437494077e-03 9.86769150314878218388514596881578e-01 6.81408889230339376297251874348149e-03 5.73386800778709782716591192297528e-04
 	 9.83775234098600348531249437655788e-01 1.56442022717672296616697735771595e-02 5.80563629632421807080788767052582e-04 3.52466097910955692947346240551099e-05
 	 9.46302700060275281401800384628586e-01 5.17758731811555211743680615654739e-02 1.92142675856919742383155380593962e-03 2.04731876038062718045629218011072e-04
 	 8.89342808819515662221988350211177e-01 1.06697593800337664493582678915118e-01 3.95959738014667328442897087370511e-03 5.84872211109859038886960025394046e-04
 	 8.15389739443474592661686983774416e-01 1.78004433169712483753244214312872e-01 6.60582738681292358506880191271193e-03 1.20496071371781220994690020376083e-03
 	 7.27676452889264746559661034552846e-01 2.62579113945671294150230323793949e-01 9.74443316506395929010864165320527e-03 2.03789635600936085840784173228712e-03
 	 6.30036688370404052150774987239856e-01 3.56725077911105081795994919957593e-01 1.32382337184908660532300928025506e-02 3.00136698949066832442511554290832e-03
 	 5.26737861339873214561180247983430e-01 4.56327608654707783664150611002697e-01 1.69345300054190017746691410138737e-02 3.96938475177465929788489518159622e-03
 	 4.22294657307570209248126502643572e-01 5.57033567663450357443366556253750e-01 2.06717750289794333085069411026780e-02 4.79229605102304313801742097211900e-03
 	 3.21271743988936209213136407925049e-01 6.54441622709937886881448321219068e-01 2.42866333011259039054152708558831e-02 5.32188382822707493902125719387186e-03
 	 2.28084270649258069596498899045400e-01 7.44294609864290190870406149770133e-01 2.76211194864517395330949511844665e-02 5.43725608274321300927844902162178e-03
 	 1.46804867681213702113041108532343e-01 8.22665627867752879964768908394035e-01 3.05295044510334179221899830736220e-02 5.06703521361920143639689939618620e-03
 	 8.09854996819552308551237729261629e-02 8.86129810502982895314971756306477e-01 3.28846898150618738299044707673602e-02 4.20396731198331794626676938264609e-03
 	 3.35014045320132236582821860793047e-02 9.31914803256157053823471869691275e-01 3.45837922118297225182459442294203e-02 2.90942418832570342049348433022260e-03
 	 6.41676079281838784851288437494077e-03 9.58030289155288872215976425650297e-01 3.55529500518927399355106899747625e-02 1.30872139602670480539037267675440e-03
 	 9.83775234098600348531249437655788e-01 1.48229567958683139394793215615209e-02 1.40180910553133752927124078269117e-03 5.34333813988313149337047724962702e-05
 	 9.46302700060275281401800384628586e-01 4.90578885327803138061142362857936e-02 4.63941140694440479208537908561993e-03 3.10370741517492941194400479787419e-04
 	 8.89342808819515551199685887695523e-01 1.01096482623453803872948242315033e-01 9.56070855703064492736586998944404e-03 8.86658322914962260079263511869385e-04
 	 8.15389739443474592661686983774416e-01 1.68660055432127559127408744643617e-01 1.59502051243978482109042715819669e-02 1.82670406510862808231732135055836e-03
 	 7.27676452889264746559661034552846e-01 2.48794971702599398977184819159447e-01 2.35285754081358544631541462877067e-02 3.08942317821007126146803933863794e-03
 	 6.30036688370404052150774987239856e-01 3.37998724768581559896318822211470e-01 3.19645868610143879529061905486742e-02 4.55003156382525249940007583404622e-03
 	 5.26737861339873214561180247983430e-01 4.32372601066256634361195665405830e-01 4.08895375938701510776240866107401e-02 6.01753333490426776941628617123570e-03
 	 4.22294657307570209248126502643572e-01 5.27791980945218508480820673867129e-01 4.99133617472112822710528234892990e-02 7.26505568019533611717752918934821e-03
 	 3.21271743988936209213136407925049e-01 6.20086580979211987596499966457486e-01 5.86416750318518031903636256174650e-02 8.06790355269203403321132128667159e-03
 	 2.28084270649258069596498899045400e-01 7.05222717896356376954258848854806e-01 6.66930114543855534492422520997934e-02 8.24280632248867127509495134063400e-03
 	 1.46804867681213702113041108532343e-01 7.79479633892004364348338185664034e-01 7.37154984267819335386207058036234e-02 7.68155651665038650965922073510228e-03
 	 8.09854996819552308551237729261629e-02 8.39612251774657258884815291821724e-01 7.94022485433875102600609352521133e-02 6.37315730791713358494021690603404e-03
 	 3.35014045320132236582821860793047e-02 8.82993752326093228610659480182221e-01 8.35048431418935477310583337384742e-02 4.41064752687411222586977288528942e-03
 	 6.41676079281838784851288437494077e-03 9.07738300655319685361632764397655e-01 8.58449385518619267898543512274045e-02 1.98400384925452632003950448336127e-03
 	 9.83775234098600237508946975140134e-01 1.36879661938311466412576677953439e-02 2.53679970756861584979535706452225e-03 6.91243876579281893868939024017095e-05
 	 9.46302700060275281401800384628586e-01 4.53015365979212297764533445842972e-02 8.39576334180348882174627078711637e-03 4.01512816383412559761295623772526e-04
 	 8.89342808819515551199685887695523e-01 9.33555467726108062498369122295117e-02 1.73016444078736425504772000749654e-02 1.14703041486052836374354146897758e-03
 	 8.15389739443474592661686983774416e-01 1.55745791396230875980322139184864e-01 2.88644691602945313579908770407201e-02 2.36312575822955183574292092885116e-03
 	 7.27676452889264635537358572037192e-01 2.29744794426547271903871205722680e-01 4.25787526841880925587702222401276e-02 3.99664928214055279603877934846423e-03
 	 6.30036688370404052150774987239856e-01 3.12118235376625863253252646245528e-01 5.78450762529700845959723665146157e-02 5.88617335156230679638067471159957e-03
 	 5.26737861339873214561180247983430e-01 3.99265924338617961275588186254026e-01 7.39962143215088241632315657625441e-02 7.78461508699364746616256027778036e-03
 	 4.22294657307570153736975271385745e-01 4.87379062898370019052407542403671e-01 9.03262797940598827217684174684109e-02 9.39847922866508811434727022060542e-03
 	 3.21271743988936209213136407925049e-01 5.72606685331338516320442977303173e-01 1.06121570679725274466420614771778e-01 1.04370877934979022078065824530313e-02
 	 2.28084270649258069596498899045400e-01 6.51223966623022065824955006974051e-01 1.20691762727719864578546093980549e-01 1.06633517233740027913002634818440e-02
 	 1.46804867681213702113041108532343e-01 7.19795046590677611852981954143615e-01 1.33400085728108686033976937324042e-01 9.93728782593645415532890297072299e-03
 	 8.09854996819552308551237729261629e-02 7.75323322902846667759035881317686e-01 1.43691177415198101385840345756151e-01 8.24466999513261827869925468803558e-03
 	 3.35014045320132236582821860793047e-02 8.15383111321796638648606858623680e-01 1.51115484146190137693110955297016e-01 5.70585842573677511080365576390250e-03
 	 6.41676079281838784851288437494077e-03 8.38232974927044516277874208753929e-01 1.55350264280137095873612906871131e-01 2.56661748892596068560845168349260e-03
 	 9.83775234098600237508946975140134e-01 1.22922772036630923581101981767461e-02 3.93248869773667013294282668312007e-03 8.15837768700279647058823395688876e-05
 	 9.46302700060275281401800384628586e-01 4.06823802548913343590797353499511e-02 1.30149196848333842391198800214624e-02 4.73883865480055274654880292928283e-04
 	 8.89342808819515551199685887695523e-01 8.38365790197263122118798150950170e-02 2.68206121607581365884342972094601e-02 1.35377797329947033473651618606937e-03
 	 8.15389739443474592661686983774416e-01 1.39865222782999287787220055179205e-01 4.47450377735261195510929610463791e-02 2.78906954705013081230458027448549e-03
 	 7.27676452889264635537358572037192e-01 2.06318941703878655502535366395023e-01 6.60046054068567089601060615677852e-02 4.71702902997817377639400149291760e-03
 	 6.30036688370404052150774987239856e-01 2.80293201724646057204637372706202e-01 8.96701099049498906445876400539419e-02 6.94713211361208671235090150730684e-03
 	 5.26737861339873214561180247983430e-01 3.58554905122350386914575892660650e-01 1.14707233537776398524243859355920e-01 9.18776023621672988106467983016046e-03
 	 4.22294657307570153736975271385745e-01 4.37683616365762195865585226783878e-01 1.40021726326667705908590733088204e-01 1.10925168133632120331943937685537e-02
 	 3.21271743988936209213136407925049e-01 5.14221032189256299638202563073719e-01 1.64507223821807491148661029001232e-01 1.23183303399572799396999300824973e-02
 	 2.28084270649258069596498899045400e-01 5.84822128141060826322927823639475e-01 1.87093601209681104080573277315125e-01 1.25853774212290395184687952223612e-02
 	 1.46804867681213702113041108532343e-01 6.46401380396727898158815150964074e-01 2.06793751922058399728143740503583e-01 1.17284434647929869388605084168375e-02
 	 8.09854996819552308551237729261629e-02 6.96267734200143872946853207395179e-01 2.22746766117900896198023019678658e-01 9.73073816694804312465993945124865e-03
 	 3.35014045320132236582821860793047e-02 7.32242839412469148641093852347694e-01 2.34255756055517627700623961573001e-01 6.73431615714120777177464916007921e-03
 	 6.41676079281838784851288437494077e-03 7.52762824158499821436407728469931e-01 2.40820415048681790715079387155129e-01 3.02923983303063186489634261988613e-03
 	 9.83775234098600348531249437655788e-01 1.07011446917479081941682039769148e-02 5.52362120965174327458235836729727e-03 9.02285775121094003707600261776633e-05
 	 9.46302700060275281401800384628586e-01 3.54163862642608573416680428636028e-02 1.82809136754638612565315725078108e-02 5.24097666578040872337185263063475e-04
 	 8.89342808819515551199685887695523e-01 7.29846347984976218103980727391900e-02 3.76725563819868269899160395652871e-02 1.49722733470203676550691618274413e-03
 	 8.15389739443474703683989446290070e-01 1.21760839065556569771331396623282e-01 6.28494214909687265446791570866480e-02 3.08460563444603761903972660718409e-03
 	 7.27676452889264635537358572037192e-01 1.79612679672043973333472877129680e-01 9.27108674386913911291685508331284e-02 5.21685604401842407257250400220983e-03
 	 6.30036688370404052150774987239856e-01 2.44011590210061718453360413150222e-01 1.25951721419534229395864599609922e-01 7.68326587035216956173000468766077e-03
 	 5.26737861339873214561180247983430e-01 3.12142970425919652477375620946987e-01 1.61119168234207132961444131069584e-01 1.01613159924778262421796171111055e-02
 	 4.22294657307570209248126502643572e-01 3.81029131570654766569816729315789e-01 1.96676211121775024182056768040638e-01 1.22679048641423406318384792257348e-02
 	 3.21271743988936209213136407925049e-01 4.47659418822524801662154914083658e-01 2.31068837188538989124708677991293e-01 1.36236083513183326570983311398777e-02
 	 2.28084270649258069596498899045400e-01 5.09121793178278547742365844896995e-01 2.62793936172463382661135256057605e-01 1.39189523424441425475395206490248e-02
 	 1.46804867681213702113041108532343e-01 5.62730126075389303075269253895385e-01 2.90465006243396994811689637572272e-01 1.29712157350273492306680367391891e-02
 	 8.09854996819552308551237729261629e-02 6.06141697296808557027247843507212e-01 3.12872803021236212117628383566625e-01 1.07618290869917650198761549518167e-02
 	 3.35014045320132236582821860793047e-02 6.37460125916627151632098957634298e-01 3.29038469551359624709618856286397e-01 7.44789945608530581933059977473022e-03
 	 6.41676079281827682621042185928673e-03 6.55323970198815830556782202620525e-01 3.38259269008365892617007375520188e-01 3.35022490455190924060757673430544e-03
 	 9.83775234098600237508946975140134e-01 8.98896607433205541148879547108663e-03 7.23579982706770707956422938877949e-03 9.46544673654892105641237010082989e-05
 	 9.46302700060275281401800384628586e-01 2.97497794652172575791126973854261e-02 2.39475204745074610190869179859874e-02 5.49805691780770903684394390609214e-04
 	 8.89342808819515551199685887695523e-01 6.13071241487952028892394196191162e-02 4.93500670316892459110746926853608e-02 1.57066929124813564958018652362171e-03
 	 8.15389739443474703683989446290070e-01 1.02279156395905013177127784729237e-01 8.23311041606202831388827689806931e-02 3.23591163034673461387780157849647e-03
 	 7.27676452889264524515056109521538e-01 1.50874727012793863334394472985878e-01 1.21448820097941612150549417492584e-01 5.47275313193012862000852436494824e-03
 	 6.30036688370404052150774987239856e-01 2.04969839145665438939758473679831e-01 1.64993472483930508909466539080313e-01 8.06014522935400400116545682749347e-03
 	 5.26737861339873214561180247983430e-01 2.62200227389087214824314742145361e-01 2.11061911271039570614505009871209e-01 1.06597486020582887800145499568316e-02
 	 4.22294657307570209248126502643572e-01 3.20064631932509335854319942882285e-01 2.57640710759920454897553554474143e-01 1.28696698166392304446548067176082e-02
 	 3.21271743988936209213136407925049e-01 3.76034101450282043366257767047500e-01 3.02694154560781747420605825027451e-01 1.42918732362482536757397610927001e-02
 	 2.28084270649258069596498899045400e-01 4.27662521946064022593247955228435e-01 3.44253207404677907810253145726165e-01 1.46017044331975733711947995629998e-02
 	 1.46804867681213757624192339790170e-01 4.72693544289423950299777743566665e-01 3.80501588029362347587181147900992e-01 1.36074794741952807136664560516692e-02
 	 8.09854996819552308551237729261629e-02 5.09159282505608046243139597208938e-01 4.09855217812436722901736629864899e-01 1.12897180493721389915595665343062e-02
 	 3.35014045320132236582821860793047e-02 5.35466775813499884506541093287524e-01 4.31031819654486891835176720633171e-01 7.81323362781440218516326723374732e-03
 	 6.41676079281849887081534689059481e-03 5.50472412578094871804523791070096e-01 4.43110826629086629324660862039309e-01 3.51456005002848169763152164080111e-03
 	 9.83775234098600237508946975140134e-01 7.23579982706764983368952215414538e-03 8.98896607433211265736350270572075e-03 9.46544673654893460893952616963531e-05
 	 9.46302700060275281401800384628586e-01 2.39475204745074506107460621251448e-02 2.97497794652172679874535532462687e-02 5.49805691780771662625915130462317e-04
 	 8.89342808819515551199685887695523e-01 4.93500670316892250943929809636757e-02 6.13071241487952237059211313408014e-02 1.57066929124813781798453149463057e-03
 	 8.15389739443474703683989446290070e-01 8.23311041606203108944583846096066e-02 1.02279156395904985421552169100323e-01 3.23591163034673895068649152051421e-03
 	 7.27676452889264635537358572037192e-01 1.21448820097941445617095723719103e-01 1.50874727012793918845545704243705e-01 5.47275313193013642626416626058017e-03
 	 6.30036688370404052150774987239856e-01 1.64993472483930425642739692193572e-01 2.04969839145665522206485320566571e-01 8.06014522935401614422978866514313e-03
 	 5.26737861339873214561180247983430e-01 2.11061911271039459592202547355555e-01 2.62200227389087325846617204661015e-01 1.06597486020583043925258337480955e-02
 	 4.22294657307570264759277733901399e-01 2.57640710759920399386402323216316e-01 3.20064631932509280343168711624458e-01 1.28696698166392495266130424624862e-02
 	 3.21271743988936209213136407925049e-01 3.02694154560781636398303362511797e-01 3.76034101450282154388560229563154e-01 1.42918732362482744924214728143852e-02
 	 2.28084270649258069596498899045400e-01 3.44253207404677796787950683210511e-01 4.27662521946064133615550417744089e-01 1.46017044331975941878765112846850e-02
 	 1.46804867681213702113041108532343e-01 3.80501588029362181053727454127511e-01 4.72693544289424116833231437340146e-01 1.36074794741952997956246917965473e-02
 	 8.09854996819552308551237729261629e-02 4.09855217812436611879434167349245e-01 5.09159282505608157265442059724592e-01 1.12897180493721546040708503255701e-02
 	 3.35014045320132236582821860793047e-02 4.31031819654486780812874258117517e-01 5.35466775813499995528843555803178e-01 7.81323362781441259350412309458989e-03
 	 6.41676079281838784851288437494077e-03 4.43110826629086518302358399523655e-01 5.50472412578095093849128716101404e-01 3.51456005002848646812108057702062e-03
 	 9.83775234098600348531249437655788e-01 5.52362120965179705101011364831720e-03 1.07011446917478544177404486958949e-02 9.02285775121089937949453441135006e-05
 	 9.46302700060275281401800384628586e-01 1.82809136754638543176376686005824e-02 3.54163862642608642805619467708311e-02 5.24097666578038487092405794953720e-04
 	 8.89342808819515551199685887695523e-01 3.76725563819868131121282317508303e-02 7.29846347984976356881858805536467e-02 1.49722733470203004345344677261664e-03
 	 8.15389739443474703683989446290070e-01 6.28494214909687543002547727155616e-02 1.21760839065556542015755780994368e-01 3.08460563444602374125191879272734e-03
 	 7.27676452889264635537358572037192e-01 9.27108674386913633735929352042149e-02 1.79612679672044001089048492758593e-01 5.21685604401840065380557831531405e-03
 	 6.30036688370404052150774987239856e-01 1.25951721419534173884713368352095e-01 2.44011590210061773964511644408049e-01 7.68326587035213486726048515151888e-03
 	 5.26737861339873214561180247983430e-01 1.61119168234207077450292899811757e-01 3.12142970425919707988526852204814e-01 1.01613159924777811393692417141210e-02
 	 4.22294657307570153736975271385745e-01 1.96676211121774968670905536782811e-01 3.81029131570654933103270423089270e-01 1.22679048641422851206872479679078e-02
 	 3.21271743988936209213136407925049e-01 2.31068837188538878102406215475639e-01 4.47659418822524912684457376599312e-01 1.36236083513182719417766719516294e-02
 	 2.28084270649258069596498899045400e-01 2.62793936172463271638832793541951e-01 5.09121793178278658764668307412649e-01 1.39189523424440800974943854839694e-02
 	 1.46804867681213702113041108532343e-01 2.90465006243396883789387175056618e-01 5.62730126075389414097571716411039e-01 1.29712157350272919847933295045550e-02
 	 8.09854996819552308551237729261629e-02 3.12872803021236212117628383566625e-01 6.06141697296808557027247843507212e-01 1.07618290869917164476188276012181e-02
 	 3.35014045320132236582821860793047e-02 3.29038469551359513687316393770743e-01 6.37460125916627262654401420149952e-01 7.44789945608527199222281822699188e-03
 	 6.41676079281838784851288437494077e-03 3.38259269008365670572402450488880e-01 6.55323970198815941579084665136179e-01 3.35022490455189449545803093144514e-03
 	 9.83775234098600237508946975140134e-01 3.93248869773661288706811944848596e-03 1.22922772036631496039849054113802e-02 8.15837768700281002311539002569418e-05
 	 9.46302700060275281401800384628586e-01 1.30149196848333773002259761142341e-02 4.06823802548913412979736392571795e-02 4.73883865480056142016618281331830e-04
 	 8.89342808819515551199685887695523e-01 2.68206121607581227106464893950033e-02 8.38365790197263260896676229094737e-02 1.35377797329947293682173015128001e-03
 	 8.15389739443474592661686983774416e-01 4.47450377735260640399417297885520e-02 1.39865222782999343298371286437032e-01 2.78906954705013558279413921070500e-03
 	 7.27676452889264635537358572037192e-01 6.60046054068566812045304459388717e-02 2.06318941703878683258110982023936e-01 4.71702902997818245001138137695307e-03
 	 6.30036688370404052150774987239856e-01 8.96701099049498906445876400539419e-02 2.80293201724646057204637372706202e-01 6.94713211361209885541523334495650e-03
 	 5.26737861339873214561180247983430e-01 1.14707233537776343013092628098093e-01 3.58554905122350442425727123918477e-01 9.18776023621674549357596362142431e-03
 	 4.22294657307570209248126502643572e-01 1.40021726326667539375137039314723e-01 4.37683616365762251376736458041705e-01 1.10925168133632328498761054902388e-02
 	 3.21271743988936209213136407925049e-01 1.64507223821807491148661029001232e-01 5.14221032189256299638202563073719e-01 1.23183303399573007563816418041824e-02
 	 2.28084270649258069596498899045400e-01 1.87093601209680993058270814799471e-01 5.84822128141060937345230286155129e-01 1.25853774212290620698739829208535e-02
 	 1.46804867681213702113041108532343e-01 2.06793751922058288705841277987929e-01 6.46401380396728009181117613479728e-01 1.17284434647930094902656961153298e-02
 	 8.09854996819552308551237729261629e-02 2.22746766117900785175720557163004e-01 6.96267734200143983969155669910833e-01 9.73073816694806047189469921931959e-03
 	 3.35014045320132236582821860793047e-02 2.34255756055517627700623961573001e-01 7.32242839412469148641093852347694e-01 6.73431615714121991483898099772887e-03
 	 6.41676079281838784851288437494077e-03 2.40820415048681679692776924639475e-01 7.52762824158499932458710190985585e-01 3.02923983303063750274763954450918e-03
 	 9.83775234098600237508946975140134e-01 2.53679970756856033864412580669523e-03 1.36879661938312021524088990531709e-02 6.91243876579281893868939024017095e-05
 	 9.46302700060275281401800384628586e-01 8.39576334180348882174627078711637e-03 4.53015365979212297764533445842972e-02 4.01512816383412559761295623772526e-04
 	 8.89342808819515551199685887695523e-01 1.73016444078736425504772000749654e-02 9.33555467726108062498369122295117e-02 1.14703041486052836374354146897758e-03
 	 8.15389739443474592661686983774416e-01 2.88644691602944758468396457828931e-02 1.55745791396230931491473370442691e-01 2.36312575822955183574292092885116e-03
 	 7.27676452889264635537358572037192e-01 4.25787526841880925587702222401276e-02 2.29744794426547271903871205722680e-01 3.99664928214055279603877934846423e-03
 	 6.30036688370404052150774987239856e-01 5.78450762529700845959723665146157e-02 3.12118235376625863253252646245528e-01 5.88617335156230679638067471159957e-03
 	 5.26737861339873214561180247983430e-01 7.39962143215088241632315657625441e-02 3.99265924338617961275588186254026e-01 7.78461508699364746616256027778036e-03
 	 4.22294657307570153736975271385745e-01 9.03262797940597716994659549527569e-02 4.87379062898370130074710004919325e-01 9.39847922866508811434727022060542e-03
 	 3.21271743988936209213136407925049e-01 1.06121570679725274466420614771778e-01 5.72606685331338516320442977303173e-01 1.04370877934979022078065824530313e-02
 	 2.28084270649258069596498899045400e-01 1.20691762727719864578546093980549e-01 6.51223966623022065824955006974051e-01 1.06633517233740027913002634818440e-02
 	 1.46804867681213702113041108532343e-01 1.33400085728108686033976937324042e-01 7.19795046590677611852981954143615e-01 9.93728782593645415532890297072299e-03
 	 8.09854996819552308551237729261629e-02 1.43691177415198101385840345756151e-01 7.75323322902846667759035881317686e-01 8.24466999513261827869925468803558e-03
 	 3.35014045320132236582821860793047e-02 1.51115484146190026670808492781362e-01 8.15383111321796749670909321139334e-01 5.70585842573677511080365576390250e-03
 	 6.41676079281838784851288437494077e-03 1.55350264280137095873612906871131e-01 8.38232974927044516277874208753929e-01 2.56661748892596068560845168349260e-03
 	 9.83775234098600237508946975140134e-01 1.40180910553139650986942399413238e-03 1.48229567958683659811836008657338e-02 5.34333813988310980932702753953834e-05
 	 9.46302700060275281401800384628586e-01 4.63941140694441173097928299284831e-03 4.90578885327803068672203323785652e-02 3.10370741517491694361902121457319e-04
 	 8.89342808819515662221988350211177e-01 9.56070855703067268294148561835755e-03 1.01096482623453665095070164170465e-01 8.86658322914958682212094309704753e-04
 	 8.15389739443474592661686983774416e-01 1.59502051243978204553286559530534e-02 1.68660055432127586882984360272530e-01 1.82670406510862049290211395202732e-03
 	 7.27676452889264635537358572037192e-01 2.35285754081360209966078400611877e-02 2.48794971702599343466033587901620e-01 3.08942317821005868472283850678650e-03
 	 6.30036688370404052150774987239856e-01 3.19645868610144989752086530643282e-02 3.37998724768581448874016359695815e-01 4.55003156382523341744184008916818e-03
 	 5.26737861339873214561180247983430e-01 4.08895375938702620999265491263941e-02 4.32372601066256523338893202890176e-01 6.01753333490424348328762249593638e-03
 	 4.22294657307570209248126502643572e-01 4.99133617472113932933552860049531e-02 5.27791980945218397458518211351475e-01 7.26505568019530662687843758362760e-03
 	 3.21271743988936209213136407925049e-01 5.86416750318519142126660881331190e-02 6.20086580979211876574197503941832e-01 8.06790355269200107346527772733680e-03
 	 2.28084270649258069596498899045400e-01 6.66930114543857754938471771311015e-02 7.05222717896356154909653923823498e-01 8.24280632248863658062543180449211e-03
 	 1.46804867681213702113041108532343e-01 7.37154984267821555832256308349315e-02 7.79479633892004142303733260632725e-01 7.68155651665035528463665315257458e-03
 	 8.09854996819552308551237729261629e-02 7.94022485433877323046658602834214e-02 8.39612251774657036840210366790416e-01 6.37315730791710756408807725392762e-03
 	 3.35014045320132236582821860793047e-02 8.35048431418937697756632587697823e-02 8.82993752326093006566054555150913e-01 4.41064752687409401127327512881493e-03
 	 6.41676079281838784851288437494077e-03 8.58449385518621488344592762587126e-02 9.07738300655319463317027839366347e-01 1.98400384925451808010299359352757e-03
 	 9.83775234098600348531249437655788e-01 5.80563629632477318232020024879603e-04 1.56442022717671741505185423193325e-02 3.52466097910960368569215084288970e-05
 	 9.46302700060275281401800384628586e-01 1.92142675856919048493764989871124e-03 5.17758731811555281132619654727023e-02 2.04731876038065428551060431772157e-04
 	 8.89342808819515551199685887695523e-01 3.95959738014677042894362557490240e-03 1.06697593800337678371370486729575e-01 5.84872211109866736722384672475528e-04
 	 8.15389739443474592661686983774416e-01 6.60582738681286807391757065488491e-03 1.78004433169712539264395445570699e-01 1.20496071371782803929861849212557e-03
 	 7.27676452889264635537358572037192e-01 9.74443316506401480125987291103229e-03 2.62579113945671349661381555051776e-01 2.03789635600938731294085037859531e-03
 	 6.30036688370404052150774987239856e-01 1.32382337184908105420788615447236e-02 3.56725077911105137307146151215420e-01 3.00136698949070778938419401526971e-03
 	 5.26737861339873214561180247983430e-01 1.69345300054189462635179097560467e-02 4.56327608654707839175301842260524e-01 3.96938475177471133958917448580905e-03
 	 4.22294657307570209248126502643572e-01 2.06717750289794333085069411026780e-02 5.57033567663450357443366556253750e-01 4.79229605102310558806255613717440e-03
 	 3.21271743988936209213136407925049e-01 2.42866333011257928831128083402291e-02 6.54441622709937997903750783734722e-01 5.32188382822714432796029626615564e-03
 	 2.28084270649258069596498899045400e-01 2.76211194864516285107924886688124e-02 7.44294609864290301892708612285787e-01 5.43725608274328500030270205911620e-03
 	 1.46804867681213702113041108532343e-01 3.05295044510333068998875205579679e-02 8.22665627867752990987071370909689e-01 5.06703521361926822325072450325933e-03
 	 8.09854996819552308551237729261629e-02 3.28846898150617628076020082517061e-02 8.86129810502983006337274218822131e-01 4.20396731198337345741800064047311e-03
 	 3.35014045320132236582821860793047e-02 3.45837922118296114959434817137662e-02 9.31914803256157164845774332206929e-01 2.90942418832574158440995581997868e-03
 	 6.41676079281838784851288437494077e-03 3.55529500518926289132082274591085e-02 9.58030289155288983238278888165951e-01 1.30872139602672193578469794772445e-03
 	 9.83775234098600237508946975140134e-01 1.11270996476519473672439630718145e-04 1.61134949049232430173805852291480e-02 1.54425081516732891080256190319275e-05
 	 9.46302700060275281401800384628586e-01 3.68261219218964097610324870402110e-04 5.33290387205057545005892905010114e-02 8.96986599098068199727856741887422e-05
 	 8.89342808819515551199685887695523e-01 7.58897601652486208934078604215756e-04 1.09898293578831962591380033700261e-01 2.56248585077618667646404126969628e-04
 	 8.15389739443474592661686983774416e-01 1.26607482516233327274335351830814e-03 1.83344185731363074065569662707276e-01 5.27926395029750081429320562875773e-04
 	 7.27676452889264746559661034552846e-01 1.86762093426678932317486214742530e-03 2.70455926176468464117164103299729e-01 8.92858384862031087721156996650507e-04
 	 6.30036688370404052150774987239856e-01 2.53724377873626449897415113809984e-03 3.67426067850859683350250861622044e-01 1.31498134078931821176750016633150e-03
 	 5.26737861339873214561180247983430e-01 3.24567701520911411350311936985236e-03 4.70016461644917671325316632646718e-01 1.73909651877762988329834126233209e-03
 	 4.22294657307570209248126502643572e-01 3.96195849862157611909196930355392e-03 5.73743384193808214632781528052874e-01 2.09963656850342293355704548218910e-03
 	 3.21271743988936209213136407925049e-01 4.65478330116342320366129570174962e-03 6.74073472709900367583202296373202e-01 2.33166352414458264916130580957088e-03
 	 2.28084270649258069596498899045400e-01 5.29387190685737252238141081761569e-03 7.66621857443884557881119690136984e-01 2.38221127870600138387580102516949e-03
 	 1.46804867681213702113041108532343e-01 5.85129382691662591753356537083164e-03 8.47343838491869671969425326096825e-01 2.22000734410768849405592995083225e-03
 	 8.09854996819552308551237729261629e-02 6.30268934838307259838074969593436e-03 9.12711810969661696546495477377903e-01 1.84187358357146930762371361822716e-03
 	 3.35014045320132236582821860793047e-02 6.62833981485067003092126469709910e-03 9.59870255653136106310796549223596e-01 1.27469867346633662467947356589093e-03
 	 6.41676079281838784851288437494077e-03 6.81408889230350478527498125913553e-03 9.86769150314878107366212134365924e-01 5.73386800778704036445077019124028e-04
 	 ];
 
 	 case  27 

 	 % ALG. DEG.:   27
 	 % PTS CARD.:  196
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 9.83775234098600237508946975140134e-01 1.61134949049231875062293539713210e-02 1.11270996476574984823670888545166e-04 1.54425081516734449620879138231899e-05
 	 9.46302700060275281401800384628586e-01 5.33290387205057545005892905010114e-02 3.68261219218964097610324870402110e-04 8.96986599098077279921051307987057e-05
 	 8.89342808819515551199685887695523e-01 1.09898293578831962591380033700261e-01 7.58897601652486208934078604215756e-04 2.56248585077621215521509467905048e-04
 	 8.15389739443474703683989446290070e-01 1.83344185731363018554418431449449e-01 1.26607482516227776159212226048112e-03 5.27926395029755394019965741847500e-04
 	 7.27676452889264746559661034552846e-01 2.70455926176468575139466565815383e-01 1.86762093426667830087239963177126e-03 8.92858384862040086599188626337309e-04
 	 6.30036688370404052150774987239856e-01 3.67426067850859738861402092879871e-01 2.53724377873620898782291988027282e-03 1.31498134078933143903400448948560e-03
 	 5.26737861339873214561180247983430e-01 4.70016461644917726836467863904545e-01 3.24567701520905860235188811202534e-03 1.73909651877764744737353552750392e-03
 	 4.22294657307570209248126502643572e-01 5.73743384193808214632781528052874e-01 3.96195849862157611909196930355392e-03 2.09963656850344418391962619807600e-03
 	 3.21271743988936209213136407925049e-01 6.74073472709900367583202296373202e-01 4.65478330116342320366129570174962e-03 2.33166352414460606792823149646665e-03
 	 2.28084270649258069596498899045400e-01 7.66621857443884668903422152652638e-01 5.29387190685726150007894830196165e-03 2.38221127870602523632359570626704e-03
 	 1.46804867681213702113041108532343e-01 8.47343838491869671969425326096825e-01 5.85129382691662591753356537083164e-03 2.22000734410771061178024865512270e-03
 	 8.09854996819552308551237729261629e-02 9.12711810969661807568797939893557e-01 6.30268934838296157607828718028031e-03 1.84187358357148795590108036890342e-03
 	 3.35014045320132236582821860793047e-02 9.59870255653136106310796549223596e-01 6.62833981485067003092126469709910e-03 1.27469867346634941826510889484325e-03
 	 6.41676079281838784851288437494077e-03 9.86769150314878218388514596881578e-01 6.81408889230339376297251874348149e-03 5.73386800778709782716591192297528e-04
 	 9.83775234098600348531249437655788e-01 1.56442022717672296616697735771595e-02 5.80563629632421807080788767052582e-04 3.52466097910955692947346240551099e-05
 	 9.46302700060275281401800384628586e-01 5.17758731811555211743680615654739e-02 1.92142675856919742383155380593962e-03 2.04731876038062718045629218011072e-04
 	 8.89342808819515662221988350211177e-01 1.06697593800337664493582678915118e-01 3.95959738014667328442897087370511e-03 5.84872211109859038886960025394046e-04
 	 8.15389739443474592661686983774416e-01 1.78004433169712483753244214312872e-01 6.60582738681292358506880191271193e-03 1.20496071371781220994690020376083e-03
 	 7.27676452889264746559661034552846e-01 2.62579113945671294150230323793949e-01 9.74443316506395929010864165320527e-03 2.03789635600936085840784173228712e-03
 	 6.30036688370404052150774987239856e-01 3.56725077911105081795994919957593e-01 1.32382337184908660532300928025506e-02 3.00136698949066832442511554290832e-03
 	 5.26737861339873214561180247983430e-01 4.56327608654707783664150611002697e-01 1.69345300054190017746691410138737e-02 3.96938475177465929788489518159622e-03
 	 4.22294657307570209248126502643572e-01 5.57033567663450357443366556253750e-01 2.06717750289794333085069411026780e-02 4.79229605102304313801742097211900e-03
 	 3.21271743988936209213136407925049e-01 6.54441622709937886881448321219068e-01 2.42866333011259039054152708558831e-02 5.32188382822707493902125719387186e-03
 	 2.28084270649258069596498899045400e-01 7.44294609864290190870406149770133e-01 2.76211194864517395330949511844665e-02 5.43725608274321300927844902162178e-03
 	 1.46804867681213702113041108532343e-01 8.22665627867752879964768908394035e-01 3.05295044510334179221899830736220e-02 5.06703521361920143639689939618620e-03
 	 8.09854996819552308551237729261629e-02 8.86129810502982895314971756306477e-01 3.28846898150618738299044707673602e-02 4.20396731198331794626676938264609e-03
 	 3.35014045320132236582821860793047e-02 9.31914803256157053823471869691275e-01 3.45837922118297225182459442294203e-02 2.90942418832570342049348433022260e-03
 	 6.41676079281838784851288437494077e-03 9.58030289155288872215976425650297e-01 3.55529500518927399355106899747625e-02 1.30872139602670480539037267675440e-03
 	 9.83775234098600348531249437655788e-01 1.48229567958683139394793215615209e-02 1.40180910553133752927124078269117e-03 5.34333813988313149337047724962702e-05
 	 9.46302700060275281401800384628586e-01 4.90578885327803138061142362857936e-02 4.63941140694440479208537908561993e-03 3.10370741517492941194400479787419e-04
 	 8.89342808819515551199685887695523e-01 1.01096482623453803872948242315033e-01 9.56070855703064492736586998944404e-03 8.86658322914962260079263511869385e-04
 	 8.15389739443474592661686983774416e-01 1.68660055432127559127408744643617e-01 1.59502051243978482109042715819669e-02 1.82670406510862808231732135055836e-03
 	 7.27676452889264746559661034552846e-01 2.48794971702599398977184819159447e-01 2.35285754081358544631541462877067e-02 3.08942317821007126146803933863794e-03
 	 6.30036688370404052150774987239856e-01 3.37998724768581559896318822211470e-01 3.19645868610143879529061905486742e-02 4.55003156382525249940007583404622e-03
 	 5.26737861339873214561180247983430e-01 4.32372601066256634361195665405830e-01 4.08895375938701510776240866107401e-02 6.01753333490426776941628617123570e-03
 	 4.22294657307570209248126502643572e-01 5.27791980945218508480820673867129e-01 4.99133617472112822710528234892990e-02 7.26505568019533611717752918934821e-03
 	 3.21271743988936209213136407925049e-01 6.20086580979211987596499966457486e-01 5.86416750318518031903636256174650e-02 8.06790355269203403321132128667159e-03
 	 2.28084270649258069596498899045400e-01 7.05222717896356376954258848854806e-01 6.66930114543855534492422520997934e-02 8.24280632248867127509495134063400e-03
 	 1.46804867681213702113041108532343e-01 7.79479633892004364348338185664034e-01 7.37154984267819335386207058036234e-02 7.68155651665038650965922073510228e-03
 	 8.09854996819552308551237729261629e-02 8.39612251774657258884815291821724e-01 7.94022485433875102600609352521133e-02 6.37315730791713358494021690603404e-03
 	 3.35014045320132236582821860793047e-02 8.82993752326093228610659480182221e-01 8.35048431418935477310583337384742e-02 4.41064752687411222586977288528942e-03
 	 6.41676079281838784851288437494077e-03 9.07738300655319685361632764397655e-01 8.58449385518619267898543512274045e-02 1.98400384925452632003950448336127e-03
 	 9.83775234098600237508946975140134e-01 1.36879661938311466412576677953439e-02 2.53679970756861584979535706452225e-03 6.91243876579281893868939024017095e-05
 	 9.46302700060275281401800384628586e-01 4.53015365979212297764533445842972e-02 8.39576334180348882174627078711637e-03 4.01512816383412559761295623772526e-04
 	 8.89342808819515551199685887695523e-01 9.33555467726108062498369122295117e-02 1.73016444078736425504772000749654e-02 1.14703041486052836374354146897758e-03
 	 8.15389739443474592661686983774416e-01 1.55745791396230875980322139184864e-01 2.88644691602945313579908770407201e-02 2.36312575822955183574292092885116e-03
 	 7.27676452889264635537358572037192e-01 2.29744794426547271903871205722680e-01 4.25787526841880925587702222401276e-02 3.99664928214055279603877934846423e-03
 	 6.30036688370404052150774987239856e-01 3.12118235376625863253252646245528e-01 5.78450762529700845959723665146157e-02 5.88617335156230679638067471159957e-03
 	 5.26737861339873214561180247983430e-01 3.99265924338617961275588186254026e-01 7.39962143215088241632315657625441e-02 7.78461508699364746616256027778036e-03
 	 4.22294657307570153736975271385745e-01 4.87379062898370019052407542403671e-01 9.03262797940598827217684174684109e-02 9.39847922866508811434727022060542e-03
 	 3.21271743988936209213136407925049e-01 5.72606685331338516320442977303173e-01 1.06121570679725274466420614771778e-01 1.04370877934979022078065824530313e-02
 	 2.28084270649258069596498899045400e-01 6.51223966623022065824955006974051e-01 1.20691762727719864578546093980549e-01 1.06633517233740027913002634818440e-02
 	 1.46804867681213702113041108532343e-01 7.19795046590677611852981954143615e-01 1.33400085728108686033976937324042e-01 9.93728782593645415532890297072299e-03
 	 8.09854996819552308551237729261629e-02 7.75323322902846667759035881317686e-01 1.43691177415198101385840345756151e-01 8.24466999513261827869925468803558e-03
 	 3.35014045320132236582821860793047e-02 8.15383111321796638648606858623680e-01 1.51115484146190137693110955297016e-01 5.70585842573677511080365576390250e-03
 	 6.41676079281838784851288437494077e-03 8.38232974927044516277874208753929e-01 1.55350264280137095873612906871131e-01 2.56661748892596068560845168349260e-03
 	 9.83775234098600237508946975140134e-01 1.22922772036630923581101981767461e-02 3.93248869773667013294282668312007e-03 8.15837768700279647058823395688876e-05
 	 9.46302700060275281401800384628586e-01 4.06823802548913343590797353499511e-02 1.30149196848333842391198800214624e-02 4.73883865480055274654880292928283e-04
 	 8.89342808819515551199685887695523e-01 8.38365790197263122118798150950170e-02 2.68206121607581365884342972094601e-02 1.35377797329947033473651618606937e-03
 	 8.15389739443474592661686983774416e-01 1.39865222782999287787220055179205e-01 4.47450377735261195510929610463791e-02 2.78906954705013081230458027448549e-03
 	 7.27676452889264635537358572037192e-01 2.06318941703878655502535366395023e-01 6.60046054068567089601060615677852e-02 4.71702902997817377639400149291760e-03
 	 6.30036688370404052150774987239856e-01 2.80293201724646057204637372706202e-01 8.96701099049498906445876400539419e-02 6.94713211361208671235090150730684e-03
 	 5.26737861339873214561180247983430e-01 3.58554905122350386914575892660650e-01 1.14707233537776398524243859355920e-01 9.18776023621672988106467983016046e-03
 	 4.22294657307570153736975271385745e-01 4.37683616365762195865585226783878e-01 1.40021726326667705908590733088204e-01 1.10925168133632120331943937685537e-02
 	 3.21271743988936209213136407925049e-01 5.14221032189256299638202563073719e-01 1.64507223821807491148661029001232e-01 1.23183303399572799396999300824973e-02
 	 2.28084270649258069596498899045400e-01 5.84822128141060826322927823639475e-01 1.87093601209681104080573277315125e-01 1.25853774212290395184687952223612e-02
 	 1.46804867681213702113041108532343e-01 6.46401380396727898158815150964074e-01 2.06793751922058399728143740503583e-01 1.17284434647929869388605084168375e-02
 	 8.09854996819552308551237729261629e-02 6.96267734200143872946853207395179e-01 2.22746766117900896198023019678658e-01 9.73073816694804312465993945124865e-03
 	 3.35014045320132236582821860793047e-02 7.32242839412469148641093852347694e-01 2.34255756055517627700623961573001e-01 6.73431615714120777177464916007921e-03
 	 6.41676079281838784851288437494077e-03 7.52762824158499821436407728469931e-01 2.40820415048681790715079387155129e-01 3.02923983303063186489634261988613e-03
 	 9.83775234098600348531249437655788e-01 1.07011446917479081941682039769148e-02 5.52362120965174327458235836729727e-03 9.02285775121094003707600261776633e-05
 	 9.46302700060275281401800384628586e-01 3.54163862642608573416680428636028e-02 1.82809136754638612565315725078108e-02 5.24097666578040872337185263063475e-04
 	 8.89342808819515551199685887695523e-01 7.29846347984976218103980727391900e-02 3.76725563819868269899160395652871e-02 1.49722733470203676550691618274413e-03
 	 8.15389739443474703683989446290070e-01 1.21760839065556569771331396623282e-01 6.28494214909687265446791570866480e-02 3.08460563444603761903972660718409e-03
 	 7.27676452889264635537358572037192e-01 1.79612679672043973333472877129680e-01 9.27108674386913911291685508331284e-02 5.21685604401842407257250400220983e-03
 	 6.30036688370404052150774987239856e-01 2.44011590210061718453360413150222e-01 1.25951721419534229395864599609922e-01 7.68326587035216956173000468766077e-03
 	 5.26737861339873214561180247983430e-01 3.12142970425919652477375620946987e-01 1.61119168234207132961444131069584e-01 1.01613159924778262421796171111055e-02
 	 4.22294657307570209248126502643572e-01 3.81029131570654766569816729315789e-01 1.96676211121775024182056768040638e-01 1.22679048641423406318384792257348e-02
 	 3.21271743988936209213136407925049e-01 4.47659418822524801662154914083658e-01 2.31068837188538989124708677991293e-01 1.36236083513183326570983311398777e-02
 	 2.28084270649258069596498899045400e-01 5.09121793178278547742365844896995e-01 2.62793936172463382661135256057605e-01 1.39189523424441425475395206490248e-02
 	 1.46804867681213702113041108532343e-01 5.62730126075389303075269253895385e-01 2.90465006243396994811689637572272e-01 1.29712157350273492306680367391891e-02
 	 8.09854996819552308551237729261629e-02 6.06141697296808557027247843507212e-01 3.12872803021236212117628383566625e-01 1.07618290869917650198761549518167e-02
 	 3.35014045320132236582821860793047e-02 6.37460125916627151632098957634298e-01 3.29038469551359624709618856286397e-01 7.44789945608530581933059977473022e-03
 	 6.41676079281827682621042185928673e-03 6.55323970198815830556782202620525e-01 3.38259269008365892617007375520188e-01 3.35022490455190924060757673430544e-03
 	 9.83775234098600237508946975140134e-01 8.98896607433205541148879547108663e-03 7.23579982706770707956422938877949e-03 9.46544673654892105641237010082989e-05
 	 9.46302700060275281401800384628586e-01 2.97497794652172575791126973854261e-02 2.39475204745074610190869179859874e-02 5.49805691780770903684394390609214e-04
 	 8.89342808819515551199685887695523e-01 6.13071241487952028892394196191162e-02 4.93500670316892459110746926853608e-02 1.57066929124813564958018652362171e-03
 	 8.15389739443474703683989446290070e-01 1.02279156395905013177127784729237e-01 8.23311041606202831388827689806931e-02 3.23591163034673461387780157849647e-03
 	 7.27676452889264524515056109521538e-01 1.50874727012793863334394472985878e-01 1.21448820097941612150549417492584e-01 5.47275313193012862000852436494824e-03
 	 6.30036688370404052150774987239856e-01 2.04969839145665438939758473679831e-01 1.64993472483930508909466539080313e-01 8.06014522935400400116545682749347e-03
 	 5.26737861339873214561180247983430e-01 2.62200227389087214824314742145361e-01 2.11061911271039570614505009871209e-01 1.06597486020582887800145499568316e-02
 	 4.22294657307570209248126502643572e-01 3.20064631932509335854319942882285e-01 2.57640710759920454897553554474143e-01 1.28696698166392304446548067176082e-02
 	 3.21271743988936209213136407925049e-01 3.76034101450282043366257767047500e-01 3.02694154560781747420605825027451e-01 1.42918732362482536757397610927001e-02
 	 2.28084270649258069596498899045400e-01 4.27662521946064022593247955228435e-01 3.44253207404677907810253145726165e-01 1.46017044331975733711947995629998e-02
 	 1.46804867681213757624192339790170e-01 4.72693544289423950299777743566665e-01 3.80501588029362347587181147900992e-01 1.36074794741952807136664560516692e-02
 	 8.09854996819552308551237729261629e-02 5.09159282505608046243139597208938e-01 4.09855217812436722901736629864899e-01 1.12897180493721389915595665343062e-02
 	 3.35014045320132236582821860793047e-02 5.35466775813499884506541093287524e-01 4.31031819654486891835176720633171e-01 7.81323362781440218516326723374732e-03
 	 6.41676079281849887081534689059481e-03 5.50472412578094871804523791070096e-01 4.43110826629086629324660862039309e-01 3.51456005002848169763152164080111e-03
 	 9.83775234098600237508946975140134e-01 7.23579982706764983368952215414538e-03 8.98896607433211265736350270572075e-03 9.46544673654893460893952616963531e-05
 	 9.46302700060275281401800384628586e-01 2.39475204745074506107460621251448e-02 2.97497794652172679874535532462687e-02 5.49805691780771662625915130462317e-04
 	 8.89342808819515551199685887695523e-01 4.93500670316892250943929809636757e-02 6.13071241487952237059211313408014e-02 1.57066929124813781798453149463057e-03
 	 8.15389739443474703683989446290070e-01 8.23311041606203108944583846096066e-02 1.02279156395904985421552169100323e-01 3.23591163034673895068649152051421e-03
 	 7.27676452889264635537358572037192e-01 1.21448820097941445617095723719103e-01 1.50874727012793918845545704243705e-01 5.47275313193013642626416626058017e-03
 	 6.30036688370404052150774987239856e-01 1.64993472483930425642739692193572e-01 2.04969839145665522206485320566571e-01 8.06014522935401614422978866514313e-03
 	 5.26737861339873214561180247983430e-01 2.11061911271039459592202547355555e-01 2.62200227389087325846617204661015e-01 1.06597486020583043925258337480955e-02
 	 4.22294657307570264759277733901399e-01 2.57640710759920399386402323216316e-01 3.20064631932509280343168711624458e-01 1.28696698166392495266130424624862e-02
 	 3.21271743988936209213136407925049e-01 3.02694154560781636398303362511797e-01 3.76034101450282154388560229563154e-01 1.42918732362482744924214728143852e-02
 	 2.28084270649258069596498899045400e-01 3.44253207404677796787950683210511e-01 4.27662521946064133615550417744089e-01 1.46017044331975941878765112846850e-02
 	 1.46804867681213702113041108532343e-01 3.80501588029362181053727454127511e-01 4.72693544289424116833231437340146e-01 1.36074794741952997956246917965473e-02
 	 8.09854996819552308551237729261629e-02 4.09855217812436611879434167349245e-01 5.09159282505608157265442059724592e-01 1.12897180493721546040708503255701e-02
 	 3.35014045320132236582821860793047e-02 4.31031819654486780812874258117517e-01 5.35466775813499995528843555803178e-01 7.81323362781441259350412309458989e-03
 	 6.41676079281838784851288437494077e-03 4.43110826629086518302358399523655e-01 5.50472412578095093849128716101404e-01 3.51456005002848646812108057702062e-03
 	 9.83775234098600348531249437655788e-01 5.52362120965179705101011364831720e-03 1.07011446917478544177404486958949e-02 9.02285775121089937949453441135006e-05
 	 9.46302700060275281401800384628586e-01 1.82809136754638543176376686005824e-02 3.54163862642608642805619467708311e-02 5.24097666578038487092405794953720e-04
 	 8.89342808819515551199685887695523e-01 3.76725563819868131121282317508303e-02 7.29846347984976356881858805536467e-02 1.49722733470203004345344677261664e-03
 	 8.15389739443474703683989446290070e-01 6.28494214909687543002547727155616e-02 1.21760839065556542015755780994368e-01 3.08460563444602374125191879272734e-03
 	 7.27676452889264635537358572037192e-01 9.27108674386913633735929352042149e-02 1.79612679672044001089048492758593e-01 5.21685604401840065380557831531405e-03
 	 6.30036688370404052150774987239856e-01 1.25951721419534173884713368352095e-01 2.44011590210061773964511644408049e-01 7.68326587035213486726048515151888e-03
 	 5.26737861339873214561180247983430e-01 1.61119168234207077450292899811757e-01 3.12142970425919707988526852204814e-01 1.01613159924777811393692417141210e-02
 	 4.22294657307570153736975271385745e-01 1.96676211121774968670905536782811e-01 3.81029131570654933103270423089270e-01 1.22679048641422851206872479679078e-02
 	 3.21271743988936209213136407925049e-01 2.31068837188538878102406215475639e-01 4.47659418822524912684457376599312e-01 1.36236083513182719417766719516294e-02
 	 2.28084270649258069596498899045400e-01 2.62793936172463271638832793541951e-01 5.09121793178278658764668307412649e-01 1.39189523424440800974943854839694e-02
 	 1.46804867681213702113041108532343e-01 2.90465006243396883789387175056618e-01 5.62730126075389414097571716411039e-01 1.29712157350272919847933295045550e-02
 	 8.09854996819552308551237729261629e-02 3.12872803021236212117628383566625e-01 6.06141697296808557027247843507212e-01 1.07618290869917164476188276012181e-02
 	 3.35014045320132236582821860793047e-02 3.29038469551359513687316393770743e-01 6.37460125916627262654401420149952e-01 7.44789945608527199222281822699188e-03
 	 6.41676079281838784851288437494077e-03 3.38259269008365670572402450488880e-01 6.55323970198815941579084665136179e-01 3.35022490455189449545803093144514e-03
 	 9.83775234098600237508946975140134e-01 3.93248869773661288706811944848596e-03 1.22922772036631496039849054113802e-02 8.15837768700281002311539002569418e-05
 	 9.46302700060275281401800384628586e-01 1.30149196848333773002259761142341e-02 4.06823802548913412979736392571795e-02 4.73883865480056142016618281331830e-04
 	 8.89342808819515551199685887695523e-01 2.68206121607581227106464893950033e-02 8.38365790197263260896676229094737e-02 1.35377797329947293682173015128001e-03
 	 8.15389739443474592661686983774416e-01 4.47450377735260640399417297885520e-02 1.39865222782999343298371286437032e-01 2.78906954705013558279413921070500e-03
 	 7.27676452889264635537358572037192e-01 6.60046054068566812045304459388717e-02 2.06318941703878683258110982023936e-01 4.71702902997818245001138137695307e-03
 	 6.30036688370404052150774987239856e-01 8.96701099049498906445876400539419e-02 2.80293201724646057204637372706202e-01 6.94713211361209885541523334495650e-03
 	 5.26737861339873214561180247983430e-01 1.14707233537776343013092628098093e-01 3.58554905122350442425727123918477e-01 9.18776023621674549357596362142431e-03
 	 4.22294657307570209248126502643572e-01 1.40021726326667539375137039314723e-01 4.37683616365762251376736458041705e-01 1.10925168133632328498761054902388e-02
 	 3.21271743988936209213136407925049e-01 1.64507223821807491148661029001232e-01 5.14221032189256299638202563073719e-01 1.23183303399573007563816418041824e-02
 	 2.28084270649258069596498899045400e-01 1.87093601209680993058270814799471e-01 5.84822128141060937345230286155129e-01 1.25853774212290620698739829208535e-02
 	 1.46804867681213702113041108532343e-01 2.06793751922058288705841277987929e-01 6.46401380396728009181117613479728e-01 1.17284434647930094902656961153298e-02
 	 8.09854996819552308551237729261629e-02 2.22746766117900785175720557163004e-01 6.96267734200143983969155669910833e-01 9.73073816694806047189469921931959e-03
 	 3.35014045320132236582821860793047e-02 2.34255756055517627700623961573001e-01 7.32242839412469148641093852347694e-01 6.73431615714121991483898099772887e-03
 	 6.41676079281838784851288437494077e-03 2.40820415048681679692776924639475e-01 7.52762824158499932458710190985585e-01 3.02923983303063750274763954450918e-03
 	 9.83775234098600237508946975140134e-01 2.53679970756856033864412580669523e-03 1.36879661938312021524088990531709e-02 6.91243876579281893868939024017095e-05
 	 9.46302700060275281401800384628586e-01 8.39576334180348882174627078711637e-03 4.53015365979212297764533445842972e-02 4.01512816383412559761295623772526e-04
 	 8.89342808819515551199685887695523e-01 1.73016444078736425504772000749654e-02 9.33555467726108062498369122295117e-02 1.14703041486052836374354146897758e-03
 	 8.15389739443474592661686983774416e-01 2.88644691602944758468396457828931e-02 1.55745791396230931491473370442691e-01 2.36312575822955183574292092885116e-03
 	 7.27676452889264635537358572037192e-01 4.25787526841880925587702222401276e-02 2.29744794426547271903871205722680e-01 3.99664928214055279603877934846423e-03
 	 6.30036688370404052150774987239856e-01 5.78450762529700845959723665146157e-02 3.12118235376625863253252646245528e-01 5.88617335156230679638067471159957e-03
 	 5.26737861339873214561180247983430e-01 7.39962143215088241632315657625441e-02 3.99265924338617961275588186254026e-01 7.78461508699364746616256027778036e-03
 	 4.22294657307570153736975271385745e-01 9.03262797940597716994659549527569e-02 4.87379062898370130074710004919325e-01 9.39847922866508811434727022060542e-03
 	 3.21271743988936209213136407925049e-01 1.06121570679725274466420614771778e-01 5.72606685331338516320442977303173e-01 1.04370877934979022078065824530313e-02
 	 2.28084270649258069596498899045400e-01 1.20691762727719864578546093980549e-01 6.51223966623022065824955006974051e-01 1.06633517233740027913002634818440e-02
 	 1.46804867681213702113041108532343e-01 1.33400085728108686033976937324042e-01 7.19795046590677611852981954143615e-01 9.93728782593645415532890297072299e-03
 	 8.09854996819552308551237729261629e-02 1.43691177415198101385840345756151e-01 7.75323322902846667759035881317686e-01 8.24466999513261827869925468803558e-03
 	 3.35014045320132236582821860793047e-02 1.51115484146190026670808492781362e-01 8.15383111321796749670909321139334e-01 5.70585842573677511080365576390250e-03
 	 6.41676079281838784851288437494077e-03 1.55350264280137095873612906871131e-01 8.38232974927044516277874208753929e-01 2.56661748892596068560845168349260e-03
 	 9.83775234098600237508946975140134e-01 1.40180910553139650986942399413238e-03 1.48229567958683659811836008657338e-02 5.34333813988310980932702753953834e-05
 	 9.46302700060275281401800384628586e-01 4.63941140694441173097928299284831e-03 4.90578885327803068672203323785652e-02 3.10370741517491694361902121457319e-04
 	 8.89342808819515662221988350211177e-01 9.56070855703067268294148561835755e-03 1.01096482623453665095070164170465e-01 8.86658322914958682212094309704753e-04
 	 8.15389739443474592661686983774416e-01 1.59502051243978204553286559530534e-02 1.68660055432127586882984360272530e-01 1.82670406510862049290211395202732e-03
 	 7.27676452889264635537358572037192e-01 2.35285754081360209966078400611877e-02 2.48794971702599343466033587901620e-01 3.08942317821005868472283850678650e-03
 	 6.30036688370404052150774987239856e-01 3.19645868610144989752086530643282e-02 3.37998724768581448874016359695815e-01 4.55003156382523341744184008916818e-03
 	 5.26737861339873214561180247983430e-01 4.08895375938702620999265491263941e-02 4.32372601066256523338893202890176e-01 6.01753333490424348328762249593638e-03
 	 4.22294657307570209248126502643572e-01 4.99133617472113932933552860049531e-02 5.27791980945218397458518211351475e-01 7.26505568019530662687843758362760e-03
 	 3.21271743988936209213136407925049e-01 5.86416750318519142126660881331190e-02 6.20086580979211876574197503941832e-01 8.06790355269200107346527772733680e-03
 	 2.28084270649258069596498899045400e-01 6.66930114543857754938471771311015e-02 7.05222717896356154909653923823498e-01 8.24280632248863658062543180449211e-03
 	 1.46804867681213702113041108532343e-01 7.37154984267821555832256308349315e-02 7.79479633892004142303733260632725e-01 7.68155651665035528463665315257458e-03
 	 8.09854996819552308551237729261629e-02 7.94022485433877323046658602834214e-02 8.39612251774657036840210366790416e-01 6.37315730791710756408807725392762e-03
 	 3.35014045320132236582821860793047e-02 8.35048431418937697756632587697823e-02 8.82993752326093006566054555150913e-01 4.41064752687409401127327512881493e-03
 	 6.41676079281838784851288437494077e-03 8.58449385518621488344592762587126e-02 9.07738300655319463317027839366347e-01 1.98400384925451808010299359352757e-03
 	 9.83775234098600348531249437655788e-01 5.80563629632477318232020024879603e-04 1.56442022717671741505185423193325e-02 3.52466097910960368569215084288970e-05
 	 9.46302700060275281401800384628586e-01 1.92142675856919048493764989871124e-03 5.17758731811555281132619654727023e-02 2.04731876038065428551060431772157e-04
 	 8.89342808819515551199685887695523e-01 3.95959738014677042894362557490240e-03 1.06697593800337678371370486729575e-01 5.84872211109866736722384672475528e-04
 	 8.15389739443474592661686983774416e-01 6.60582738681286807391757065488491e-03 1.78004433169712539264395445570699e-01 1.20496071371782803929861849212557e-03
 	 7.27676452889264635537358572037192e-01 9.74443316506401480125987291103229e-03 2.62579113945671349661381555051776e-01 2.03789635600938731294085037859531e-03
 	 6.30036688370404052150774987239856e-01 1.32382337184908105420788615447236e-02 3.56725077911105137307146151215420e-01 3.00136698949070778938419401526971e-03
 	 5.26737861339873214561180247983430e-01 1.69345300054189462635179097560467e-02 4.56327608654707839175301842260524e-01 3.96938475177471133958917448580905e-03
 	 4.22294657307570209248126502643572e-01 2.06717750289794333085069411026780e-02 5.57033567663450357443366556253750e-01 4.79229605102310558806255613717440e-03
 	 3.21271743988936209213136407925049e-01 2.42866333011257928831128083402291e-02 6.54441622709937997903750783734722e-01 5.32188382822714432796029626615564e-03
 	 2.28084270649258069596498899045400e-01 2.76211194864516285107924886688124e-02 7.44294609864290301892708612285787e-01 5.43725608274328500030270205911620e-03
 	 1.46804867681213702113041108532343e-01 3.05295044510333068998875205579679e-02 8.22665627867752990987071370909689e-01 5.06703521361926822325072450325933e-03
 	 8.09854996819552308551237729261629e-02 3.28846898150617628076020082517061e-02 8.86129810502983006337274218822131e-01 4.20396731198337345741800064047311e-03
 	 3.35014045320132236582821860793047e-02 3.45837922118296114959434817137662e-02 9.31914803256157164845774332206929e-01 2.90942418832574158440995581997868e-03
 	 6.41676079281838784851288437494077e-03 3.55529500518926289132082274591085e-02 9.58030289155288983238278888165951e-01 1.30872139602672193578469794772445e-03
 	 9.83775234098600237508946975140134e-01 1.11270996476519473672439630718145e-04 1.61134949049232430173805852291480e-02 1.54425081516732891080256190319275e-05
 	 9.46302700060275281401800384628586e-01 3.68261219218964097610324870402110e-04 5.33290387205057545005892905010114e-02 8.96986599098068199727856741887422e-05
 	 8.89342808819515551199685887695523e-01 7.58897601652486208934078604215756e-04 1.09898293578831962591380033700261e-01 2.56248585077618667646404126969628e-04
 	 8.15389739443474592661686983774416e-01 1.26607482516233327274335351830814e-03 1.83344185731363074065569662707276e-01 5.27926395029750081429320562875773e-04
 	 7.27676452889264746559661034552846e-01 1.86762093426678932317486214742530e-03 2.70455926176468464117164103299729e-01 8.92858384862031087721156996650507e-04
 	 6.30036688370404052150774987239856e-01 2.53724377873626449897415113809984e-03 3.67426067850859683350250861622044e-01 1.31498134078931821176750016633150e-03
 	 5.26737861339873214561180247983430e-01 3.24567701520911411350311936985236e-03 4.70016461644917671325316632646718e-01 1.73909651877762988329834126233209e-03
 	 4.22294657307570209248126502643572e-01 3.96195849862157611909196930355392e-03 5.73743384193808214632781528052874e-01 2.09963656850342293355704548218910e-03
 	 3.21271743988936209213136407925049e-01 4.65478330116342320366129570174962e-03 6.74073472709900367583202296373202e-01 2.33166352414458264916130580957088e-03
 	 2.28084270649258069596498899045400e-01 5.29387190685737252238141081761569e-03 7.66621857443884557881119690136984e-01 2.38221127870600138387580102516949e-03
 	 1.46804867681213702113041108532343e-01 5.85129382691662591753356537083164e-03 8.47343838491869671969425326096825e-01 2.22000734410768849405592995083225e-03
 	 8.09854996819552308551237729261629e-02 6.30268934838307259838074969593436e-03 9.12711810969661696546495477377903e-01 1.84187358357146930762371361822716e-03
 	 3.35014045320132236582821860793047e-02 6.62833981485067003092126469709910e-03 9.59870255653136106310796549223596e-01 1.27469867346633662467947356589093e-03
 	 6.41676079281838784851288437494077e-03 6.81408889230350478527498125913553e-03 9.86769150314878107366212134365924e-01 5.73386800778704036445077019124028e-04
 	 ];
 
 	 case  28 

 	 % ALG. DEG.:   28
 	 % PTS CARD.:  225
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-15  

 	 xyw_bar=[
 	 9.85730545263174495751457016012864e-01 1.41837846265205382023655289458475e-02 8.56701103049660461774550412883400e-05 1.04666317009286073951446899288342e-05
 	 9.52700409905833267565355981787434e-01 4.70156156063196647987290077708167e-02 2.83974487847067635915010441749473e-04 6.10831561793741999524809394017666e-05
 	 9.02286700679377995371055476425681e-01 9.71266539802462941510796667898830e-02 5.86645340375710477864856784435688e-04 1.75823123850481682689181339718232e-04
 	 8.36430960605610174241064669331536e-01 1.62587013247922435033032684259524e-01 9.82026146467390725902646408940200e-04 3.66092446758164687461989394989814e-04
 	 7.57664739031342682196168425434735e-01 2.40880342829116134151234973614919e-01 1.45491813954118365259660095034633e-03 6.27867699728457085914246071922662e-04
 	 6.69015195029960096917420742101967e-01 3.28997657929454512260036835868959e-01 1.98714704058539082254242202907335e-03 9.41349651538067383124697151686178e-04
 	 5.73889160906685846796904115763027e-01 4.23552579982469701302960629618610e-01 2.55825911084445190013525461836252e-03 1.27320682794373096942408540854785e-03
 	 4.75942308463234819981835244107060e-01 5.20911384893088302838748404610669e-01 3.14630664367687717941635128227063e-03 1.58109681976951977830370132949156e-03
 	 3.78938688646978105722951113421004e-01 6.17332620100899287507445478695445e-01 3.72869125212260676960340788355097e-03 1.81979824833709575432338922951203e-03
 	 2.86606086257527037375325562607031e-01 7.09110881460693898148406333348248e-01 4.28303228177906447626810404472053e-03 1.94803198207317844643793325332126e-03
 	 2.02492755050103889757906472368632e-01 7.92719218013761994789945219963556e-01 4.78802693613411545214830766781233e-03 1.93493575970182579357170560285795e-03
 	 1.29831025553591050680779517279007e-01 8.64944705306509908915302276000148e-01 5.22426913989904040391820672084577e-03 1.76519997110789143152098645828119e-03
 	 7.14129531151586061099578728317283e-02 9.23012050768901137764999020873802e-01 5.57499611594025612504310629446991e-03 1.44206995079449373439728354640010e-03
 	 2.94822986479423843064751054043882e-02 9.64690964447165177908516398019856e-01 5.82673690489243778500849657575600e-03 9.87764759723985894673825569611836e-04
 	 5.64068897251168710482716051046737e-03 9.88389435273325678288358631107258e-01 5.96987575416263460681420838227496e-03 4.41833968851592523170018766975886e-04
 	 9.85730545263174495751457016012864e-01 1.38219174928591332501826016709856e-02 4.47537243966370998360382316150208e-04 2.39485483644636379027808431585456e-05
 	 9.52700409905833156543053519271780e-01 4.58161186804446063369766761752544e-02 1.48347141372223711996980455296580e-03 1.39763484740371943552614264483225e-04
 	 9.02286700679378106393357938941335e-01 9.46486874287634366575971966994985e-02 3.06461189185845694904486435916624e-03 4.02298342527019757875611505326674e-04
 	 8.36430960605610174241064669331536e-01 1.58438973919647091426199381203332e-01 5.13006547474273433273594946513185e-03 8.37650823834270121838463385444129e-04
 	 7.57664739031342793218470887950389e-01 2.34734826557530446011767821801186e-01 7.60043441112676076976129024842521e-03 1.43661498780906144757951725665635e-03
 	 6.69015195029959985895118279586313e-01 3.20604027978697692091714088746812e-01 1.03807769913423220131676316668745e-02 2.15388850032148179702851109595940e-03
 	 5.73889160906685846796904115763027e-01 4.12746595394508031251490365320933e-01 1.33642436988061219516055189160397e-02 2.91320609802966012588654187709380e-03
 	 4.75942308463234819981835244107060e-01 5.07621510948555898501410865719663e-01 1.64361805882092815167538901732769e-02 3.61768472791400329605093766360824e-03
 	 3.78938688646978105722951113421004e-01 6.01582776766849902649880732496968e-01 1.94785345861719916271681540820282e-02 4.16385400854417733751411390130670e-03
 	 2.86606086257527037375325562607031e-01 6.91019523696948523294736332900357e-01 2.23743900455244393299381044926122e-02 4.45726375697947079651539681321992e-03
 	 2.02492755050103889757906472368632e-01 7.72494782944113000944241775869159e-01 2.50124620057831092978517517622095e-02 4.42729848029697545253036139456526e-03
 	 1.29831025553591050680779517279007e-01 8.42877600543818883416236076300265e-01 2.72913739025900659029844064207282e-02 4.03892848138303912214341906405934e-03
 	 7.14129531151586061099578728317283e-02 8.99463489228975010547628698986955e-01 2.91235576558663833424134281813167e-02 3.29957936309898227159043138101424e-03
 	 2.94822986479423843064751054043882e-02 9.40079059841617881154718361358391e-01 3.04386415104397345388065332372207e-02 2.26009023694451237698754830773851e-03
 	 5.64068897251168710482716051046737e-03 9.63172917869725475625841681903694e-01 3.11863931577628372693311575858388e-02 1.01095390326636836754448101061143e-03
 	 9.85730545263174495751457016012864e-01 1.31864500931389988513942057579698e-02 1.08300464368650539714877822916606e-03 3.64708245761568070454974876959398e-05
 	 9.52700409905833267565355981787434e-01 4.37097069023267836840318523172755e-02 3.58988319183994875061216589529067e-03 2.12843361382277071122692824189926e-04
 	 9.02286700679377995371055476425681e-01 9.02971815455635429259473312413320e-02 7.41611777505846170299719233298674e-03 6.12653095055775646221585262196641e-04
 	 8.36430960605610285263367131847190e-01 1.51154687725415320942445873697579e-01 1.24143516689743937941869944552309e-02 1.27564375874508685766717253073921e-03
 	 7.57664739031342682196168425434735e-01 2.23942812357378062682045083420235e-01 1.83924486112792551217864911450306e-02 2.18779578647064184074300108306943e-03
 	 6.69015195029959985895118279586313e-01 3.05864147777222039614741788682295e-01 2.51206571928179744901399317313917e-02 3.28011904756572757538291007506359e-03
 	 5.73889160906685846796904115763027e-01 3.93770429037402169836212806330877e-01 3.23404100559119833668830779060954e-02 4.43647050913056721632710122094068e-03
 	 4.75942308463234875492986475364887e-01 4.84283437792560056411872437820421e-01 3.97742537442051236062923180725193e-02 5.50930866771757923178176596934463e-03
 	 3.78938688646978105722951113421004e-01 5.73924802172083969864502250857186e-01 4.71365091809379244125466357218102e-02 6.34106029289358691380940058479609e-03
 	 2.86606086257527037375325562607031e-01 6.59249663971884336532980341871735e-01 5.41442497705886260916940955212340e-02 6.78788885641506360008046172538343e-03
 	 2.02492755050103889757906472368632e-01 7.36979070216954967875722104508895e-01 6.05281747329411423663714231224731e-02 6.74225526173401895624337498702516e-03
 	 1.29831025553591050680779517279007e-01 8.04126013625676261398211863706820e-01 6.60429608207326879210086190141737e-02 6.15081339705507001286433066411519e-03
 	 7.14129531151586061099578728317283e-02 8.58110346661105305443584256863687e-01 7.04767002237360884464578703045845e-02 5.02487158283279611303839828906348e-03
 	 2.94822986479423843064751054043882e-02 8.96858602477613731096539595455397e-01 7.36590988744438845969852991402149e-02 3.44185181095146754820524037654650e-03
 	 5.64068897251168710482716051046737e-03 9.18890712458230063397479625564301e-01 7.54685985692582494976932139252312e-02 1.53956398106029753933277071098473e-03
 	 9.85730545263174495751457016012864e-01 1.23032503825116368983971781858600e-02 1.96620435431386735014580580127586e-03 4.75018172811309530973421233479570e-05
 	 9.52700409905833267565355981787434e-01 4.07821259222244936193391140477615e-02 6.51746417194223881530490416480461e-03 2.77220122642701718041619018961796e-04
 	 9.02286700679377995371055476425681e-01 8.42492729690920982843493902691989e-02 1.34640263515299063445951333051198e-02 7.97956605485817356201994066111638e-04
 	 8.36430960605610174241064669331536e-01 1.41030675916617970200306331207685e-01 2.25383634777718555586289994607796e-02 1.66147591802295315974169476191946e-03
 	 7.57664739031342793218470887950389e-01 2.08943610474073365734781759783800e-01 3.33916504945838410467473522658111e-02 2.84951812592957503048052281258151e-03
 	 6.69015195029959985895118279586313e-01 2.85378033250562435085839751991443e-01 4.56067717194775790190419684222434e-02 4.27222629234678703130656529651787e-03
 	 5.73889160906685846796904115763027e-01 3.67396543228635685807148547610268e-01 5.87142958646784673959473366267048e-02 5.77832867633105377175306571757574e-03
 	 4.75942308463234819981835244107060e-01 4.51847187770838321085875577409752e-01 7.22105037659268589322891784831882e-02 7.17565826165504627720537200730178e-03
 	 3.78938688646978105722951113421004e-01 5.35484568779475256228295165783493e-01 8.55767425735466380487537207955029e-02 8.25898210150659457806643359845111e-03
 	 2.86606086257527037375325562607031e-01 6.15094557150974163839407538034720e-01 9.82993565914987987852668993582483e-02 8.84095876441603686912706905332016e-03
 	 2.02492755050103889757906472368632e-01 6.87617817039899770215072294377023e-01 1.09889427909996340027021233254345e-01 8.78152279877468695812314791737663e-03
 	 1.29831025553591050680779517279007e-01 7.50267404407441329539096841472201e-01 1.19901570038967619780123641248792e-01 8.01119298816881618419127875085906e-03
 	 7.14129531151586061099578728317283e-02 8.00635984379799214849526833859272e-01 1.27951062505042179040515293308999e-01 6.54469797606159128799951929522649e-03
 	 2.94822986479423843064751054043882e-02 8.36788966405201284359804958512541e-01 1.33728734946856331333719936083071e-01 4.48287686753955083585054808281711e-03
 	 5.64068897251168710482716051046737e-03 8.57345413639441722430944992083823e-01 1.37013897388046590464227847405709e-01 2.00522164691466046881895834985698e-03
 	 9.85730545263174495751457016012864e-01 1.12084581549249870380258187196887e-02 3.06099658190051721051716526744713e-03 5.65884579164717844155033099617924e-05
 	 9.52700409905833267565355981787434e-01 3.71531699068632231819364619695989e-02 1.01464201873035092527075562429673e-02 3.30249664995388902879319692473814e-04
 	 9.02286700679377995371055476425681e-01 7.67524370632329810959504357015248e-02 2.09608622573890235329940878727939e-02 9.50598027049414230453538987575257e-04
 	 8.36430960605610174241064669331536e-01 1.28481204594448117362048833456356e-01 3.50878347999417083968864972121082e-02 1.97930027623639381156861460908658e-03
 	 7.57664739031342793218470887950389e-01 1.90350975711794379030550317111192e-01 5.19842852568628277509787949384190e-02 3.39460352847263018352674812661007e-03
 	 6.69015195029959985895118279586313e-01 2.59983959082098703419205776299350e-01 7.10008458879413106856759441143367e-02 5.08946207938330234116230954555249e-03
 	 5.73889160906685846796904115763027e-01 3.34704135331235663741722419217695e-01 9.14067037620784894613734650192782e-02 6.88366735935364189302720916430189e-03
 	 4.75942308463234819981835244107060e-01 4.11640025122863795203898007457610e-01 1.12417666413901384814266748435330e-01 8.54829265077291546026660995494240e-03
 	 3.78938688646978105722951113421004e-01 4.87835018809682607887623362330487e-01 1.33226292543339286389425524248509e-01 9.83884591863076404805177332946187e-03
 	 2.86606086257527037375325562607031e-01 5.60360993298860798894622803345555e-01 1.53032920443612163730051634047413e-01 1.05321491180117611519140297104968e-02
 	 2.02492755050103889757906472368632e-01 6.26430844634994321573628894839203e-01 1.71076400314901788668464632792166e-01 1.04613436239710862890595066687638e-02
 	 1.29831025553591050680779517279007e-01 6.83505622161309722706334923714167e-01 1.86663352285099226612885559006827e-01 9.54365713186734222761575807680856e-03
 	 7.14129531151586061099578728317283e-02 7.29392205250413372397133571212180e-01 1.99194841634428021492908555956092e-01 7.79663573295530463319602532124009e-03
 	 2.94822986479423843064751054043882e-02 7.62328150924043601577295703464188e-01 2.08189550428014014116229191131424e-01 5.34040808296096757012971778522115e-03
 	 5.64068897251179812712962302612141e-03 7.81055403599191677699309366289526e-01 2.13303907428296524173561010684352e-01 2.38880125591958963199301635427219e-03
 	 9.85730545263174495751457016012864e-01 9.94688977170379851067139043152565e-03 4.32256496512170573787159355561016e-03 6.33584785787931980237386309084968e-05
 	 9.52700409905833267565355981787434e-01 3.29713936229995632776201830438367e-02 1.43281964711671691570238351687294e-02 3.69759436741487533626543404707832e-04
 	 9.02286700679377995371055476425681e-01 6.81135639376191370786273182602599e-02 2.95997353830028675503172053140588e-02 1.06432383831265480259031797061198e-03
 	 8.36430960605610174241064669331536e-01 1.14019998305935774118857750636380e-01 4.95490410884540516400775800320844e-02 2.21609598088058114273568577345941e-03
 	 7.57664739031342793218470887950389e-01 1.68926015261923190280413109576330e-01 7.34092457067340165011160024732817e-02 3.80072055081791346925479402329984e-03
 	 6.69015195029960096917420742101967e-01 2.30721455855592949557575366270612e-01 1.00263349114446953525003891627421e-01 5.69834531646294141504771602058099e-03
 	 5.73889160906685846796904115763027e-01 2.97031500163147388349216271308251e-01 1.29079338930166764853879612928722e-01 7.70720226331161970684258122332722e-03
 	 4.75942308463234819981835244107060e-01 3.65307868301169680336215606075712e-01 1.58749823235595499681949149817228e-01 9.57097678114321101516814849219372e-03
 	 3.78938688646978105722951113421004e-01 4.32926731920286744781378729385324e-01 1.88134579432735149495670157193672e-01 1.10159267689491531527767875786594e-02
 	 2.86606086257527037375325562607031e-01 4.97289542920501870248983777855756e-01 2.16104370821971092375690659537213e-01 1.17921740378079068639616266978010e-02
 	 2.02492755050103889757906472368632e-01 5.55922899925507030260973806434777e-01 2.41584345024389079981119721196592e-01 1.17128976527885644148829769051190e-02
 	 1.29831025553591050680779517279007e-01 6.06573623954781426803606336761732e-01 2.63595350491627522515614145959262e-01 1.06854227560909727928750712067085e-02
 	 7.14129531151586061099578728317283e-02 6.47295441146639172202981171722058e-01 2.81291605738202221687060955446213e-01 8.72939458435593139407071561208795e-03
 	 2.94822986479423843064751054043882e-02 6.76524280351295859148308409203310e-01 2.93993421000761756545216485392302e-01 5.97931351346838151766815983023662e-03
 	 5.64068897251157608252469799481332e-03 6.93143686474045450651715327694546e-01 3.01215624553442973265759974310640e-01 2.67458804807120141197596119297941e-03
 	 9.85730545263174495751457016012864e-01 8.57019237721925487838436907850337e-03 5.69926235960624937015861490863244e-03 6.75346448042547976451863145364030e-05
 	 9.52700409905833267565355981787434e-01 2.84079941348063143291557963721061e-02 1.88915959593604181054882218404600e-02 3.94131500369012159005338569173205e-04
 	 9.02286700679377995371055476425681e-01 5.86863190244673038620248917140998e-02 3.90269802961547007669196318602189e-02 1.13447693172993727475650338476498e-03
 	 8.36430960605610285263367131847190e-01 9.82390820406873338521691607638786e-02 6.53299573537023808844637073889317e-02 2.36216617377868476346236548124580e-03
 	 7.57664739031342682196168425434735e-01 1.45545842121439006344729705233476e-01 9.67894188472183114591018693317892e-02 4.05123857386362890009579018624208e-03
 	 6.69015195029959985895118279586313e-01 1.98788496466452357935850159265101e-01 1.32196308503587656169031561148586e-01 6.07394204456359210891891464711989e-03
 	 5.73889160906685846796904115763027e-01 2.55920911653589988610235650412505e-01 1.70189927439724164592860233824467e-01 8.21520937627939241976182671578499e-03
 	 4.75942308463234875492986475364887e-01 3.14747501993945799636520632702741e-01 2.09310189542819380381644123190199e-01 1.02018314177232290174135442839543e-02
 	 3.78938688646978105722951113421004e-01 3.73007589603775779885097563237650e-01 2.48053721749246114391951323341345e-01 1.17420228234406190392924429488630e-02
 	 2.86606086257527092886476793864858e-01 4.28462277940586833135938604755211e-01 2.84931635801886129488735832637758e-01 1.25694351091926257574238334768779e-02
 	 2.02492755050103889757906472368632e-01 4.78980496276990241888427135563688e-01 3.18526748672905868353666392067680e-01 1.24849333562506194239549728308702e-02
 	 1.29831025553591050680779517279007e-01 5.22620916442415373026619818119798e-01 3.47548058003993576292600664601196e-01 1.13897342013740375532560022975304e-02
 	 7.14129531151586061099578728317283e-02 5.57706638240295093922327396285255e-01 3.70880408644546299967714730883017e-01 9.30477776352394564396419696095109e-03
 	 2.94822986479423843064751054043882e-02 5.82890065492028708327154618018540e-01 3.87627635860028907366370276577072e-01 6.37342978182762077282719204163186e-03
 	 5.64068897251168710482716051046737e-03 5.97209265858788418412927967438009e-01 3.97150045168699894482244872051524e-01 2.85087896483442052378287634439857e-03
 	 9.85730545263174495751457016012864e-01 7.13472736841275299163322998197145e-03 7.13472736841275125690975400516436e-03 6.89459618314110104023151315288942e-05
 	 9.52700409905833267565355981787434e-01 2.36497950470833696867689610598973e-02 2.36497950470833627478750571526689e-02 4.02367932188882663178952636684471e-04
 	 9.02286700679377995371055476425681e-01 4.88566496603109814977905500654742e-02 4.88566496603110231311539735088445e-02 1.15818486142005576573776881588174e-03
 	 8.36430960605610174241064669331536e-01 8.17845196971948990016798575197754e-02 8.17845196971949267572554731486889e-02 2.41152995368289560507157887059293e-03
 	 7.57664739031342793218470887950389e-01 1.21167630484328617268552363839262e-01 1.21167630484328589512976748210349e-01 4.13590003905587016291844904003483e-03
 	 6.69015195029959985895118279586313e-01 1.65492402485020034808016475835757e-01 1.65492402485019979296865244577930e-01 6.20087330857332832273476341811147e-03
 	 5.73889160906685846796904115763027e-01 2.13055419546657104357123557747400e-01 2.13055419546657048845972326489573e-01 8.38688814808609753304047274014010e-03
 	 4.75942308463234764470684012849233e-01 2.62028845768382645520233609204297e-01 2.62028845768382534497931146688643e-01 1.04150259703819705880967205757770e-02
 	 3.78938688646978161234102344678831e-01 3.10530655676511002649675674547325e-01 3.10530655676510891627373212031671e-01 1.19874037948222104260631581951202e-02
 	 2.86606086257527092886476793864858e-01 3.56696956871236536823488449954311e-01 3.56696956871236425801185987438657e-01 1.28321070732305714950927111317469e-02
 	 2.02492755050103945269057703626459e-01 3.98753622474948110632197995073511e-01 3.98753622474947999609895532557857e-01 1.27458394301576960483401990131824e-02
 	 1.29831025553590995169628286021180e-01 4.35084487223204530170761472618324e-01 4.35084487223204419148459010102670e-01 1.16277531597882531622101254242807e-02
 	 7.14129531151586616211091040895553e-02 4.64293523442420752456172294841963e-01 4.64293523442420641433869832326309e-01 9.49922598087414062073552400988774e-03
 	 2.94822986479424398176263366622152e-02 4.85258850676028863357913678555633e-01 4.85258850676028752335611216039979e-01 6.50661964309881199475249502484075e-03
 	 5.64068897251168710482716051046737e-03 4.97179655513744211958737651002593e-01 4.97179655513744100936435188486939e-01 2.91045570558865363680611793029129e-03
 	 9.85730545263174495751457016012864e-01 5.69926235960624590071166295501826e-03 8.57019237721925834783132103211756e-03 6.75346448042550958007837480501223e-05
 	 9.52700409905833267565355981787434e-01 1.88915959593604076971473659796175e-02 2.84079941348063247374966522329487e-02 3.94131500369013893728814545980299e-04
 	 9.02286700679378106393357938941335e-01 3.90269802961546244390866888807068e-02 5.86863190244672691675553721779579e-02 1.13447693172994204524606232098449e-03
 	 8.36430960605610285263367131847190e-01 6.53299573537023947622515152033884e-02 9.82390820406873199743813529494219e-02 2.36216617377869473812235234788659e-03
 	 7.57664739031342793218470887950389e-01 9.67894188472181449256481755583081e-02 1.45545842121439061855880936491303e-01 4.05123857386364624733054995431303e-03
 	 6.69015195029959985895118279586313e-01 1.32196308503587572902304714261845e-01 1.98788496466452441202577006151841e-01 6.07394204456361812977105429922631e-03
 	 5.73889160906685846796904115763027e-01 1.70189927439724053570557771308813e-01 2.55920911653590099632538112928160e-01 8.21520937627942711423134625192688e-03
 	 4.75942308463234875492986475364887e-01 2.09310189542819269359341660674545e-01 3.14747501993945910658823095218395e-01 1.02018314177232723855004437041316e-02
 	 3.78938688646978161234102344678831e-01 2.48053721749245947858497629567864e-01 3.73007589603775946418551257011131e-01 1.17420228234406710809967222530759e-02
 	 2.86606086257527037375325562607031e-01 2.84931635801885962955282138864277e-01 4.28462277940586999669392298528692e-01 1.25694351091926795338515887578978e-02
 	 2.02492755050103945269057703626459e-01 3.18526748672905701820212698294199e-01 4.78980496276990408421880829337169e-01 1.24849333562506732003827281118902e-02
 	 1.29831025553591050680779517279007e-01 3.47548058003993354247995739569888e-01 5.22620916442415595071224743151106e-01 1.13897342013740878602368056249361e-02
 	 7.14129531151586061099578728317283e-02 3.70880408644546077923109805851709e-01 5.57706638240295315966932321316563e-01 9.30477776352398727732762040432135e-03
 	 2.94822986479423843064751054043882e-02 3.87627635860028685321765351545764e-01 5.82890065492028930371759543049848e-01 6.37342978182764852840280767054537e-03
 	 5.64068897251168710482716051046737e-03 3.97150045168699672437639947020216e-01 5.97209265858788640457532892469317e-01 2.85087896483443310052807717625001e-03
 	 9.85730545263174495751457016012864e-01 4.32256496512170920731854550922435e-03 9.94688977170379504122443847791146e-03 6.33584785787931709186843187708860e-05
 	 9.52700409905833156543053519271780e-01 1.43281964711671760959177390759578e-02 3.29713936229996673610287416522624e-02 3.69759436741487370996217531882166e-04
 	 9.02286700679377995371055476425681e-01 2.95997353830028397947415896851453e-02 6.81135639376191648342029338891734e-02 1.06432383831265436890944897641020e-03
 	 8.36430960605610174241064669331536e-01 4.95490410884540377622897722176276e-02 1.14019998305935787996645558450837e-01 2.21609598088058027537394778505586e-03
 	 7.57664739031342793218470887950389e-01 7.34092457067340997678428493600222e-02 1.68926015261923107013686262689589e-01 3.80072055081791173453131804649274e-03
 	 6.69015195029959985895118279586313e-01 1.00263349114447120058457585400902e-01 2.30721455855592894046424135012785e-01 5.69834531646293881296250205537035e-03
 	 5.73889160906685846796904115763027e-01 1.29079338930166820365030844186549e-01 2.97031500163147332838065040050424e-01 7.70720226331161623739562926971303e-03
 	 4.75942308463234819981835244107060e-01 1.58749823235595610704251612332882e-01 3.65307868301169569313913143560058e-01 9.57097678114320581099772056177244e-03
 	 3.78938688646978105722951113421004e-01 1.88134579432735260517972619709326e-01 4.32926731920286633759076266869670e-01 1.10159267689491479486063596482381e-02
 	 2.86606086257527037375325562607031e-01 2.16104370821971203397993122052867e-01 4.97289542920501759226681315340102e-01 1.17921740378079016597911987673797e-02
 	 2.02492755050103889757906472368632e-01 2.41584345024389302025724646227900e-01 5.55922899925506808216368881403469e-01 1.17128976527885592107125489746977e-02
 	 1.29831025553591050680779517279007e-01 2.63595350491627633537916608474916e-01 6.06573623954781315781303874246078e-01 1.06854227560909675887046432762872e-02
 	 7.14129531151586061099578728317283e-02 2.81291605738202443731665880477522e-01 6.47295441146638950158376246690750e-01 8.72939458435592618990028768166667e-03
 	 2.94822986479423843064751054043882e-02 2.93993421000762089612123872939264e-01 6.76524280351295526081401021656347e-01 5.97931351346837804822120787662243e-03
 	 5.64068897251168710482716051046737e-03 3.01215624553443195310364899341948e-01 6.93143686474045117584807940147584e-01 2.67458804807120054461422320457586e-03
 	 9.85730545263174495751457016012864e-01 3.06099658190051894524064124425422e-03 1.12084581549249853033023427428816e-02 5.65884579164720012559378070626792e-05
 	 9.52700409905833267565355981787434e-01 1.01464201873035092527075562429673e-02 3.71531699068632231819364619695989e-02 3.30249664995390149711818050803913e-04
 	 9.02286700679377995371055476425681e-01 2.09608622573889818996306644294236e-02 7.67524370632330227293138591448951e-02 9.50598027049417808320708189739889e-04
 	 8.36430960605610174241064669331536e-01 3.50878347999416528857352659542812e-02 1.28481204594448172873200064714183e-01 1.97930027623640161782425650471851e-03
 	 7.57664739031342793218470887950389e-01 5.19842852568628555065544105673325e-02 1.90350975711794351274974701482279e-01 3.39460352847264319395281795266328e-03
 	 6.69015195029959874872815817070659e-01 7.10008458879413661968271753721638e-02 2.59983959082098758930357007557177e-01 5.08946207938332229048228327883407e-03
 	 5.73889160906685846796904115763027e-01 9.14067037620784894613734650192782e-02 3.34704135331235663741722419217695e-01 6.88366735935366878124108680481186e-03
 	 4.75942308463234819981835244107060e-01 1.12417666413901384814266748435330e-01 4.11640025122863795203898007457610e-01 8.54829265077294842001265351427719e-03
 	 3.78938688646978161234102344678831e-01 1.33226292543339341900576755506336e-01 4.87835018809682552376472131072660e-01 9.83884591863080221196824481921794e-03
 	 2.86606086257527037375325562607031e-01 1.53032920443612274752354096563067e-01 5.60360993298860687872320340829901e-01 1.05321491180118027852774531538671e-02
 	 2.02492755050103889757906472368632e-01 1.71076400314901788668464632792166e-01 6.26430844634994321573628894839203e-01 1.04613436239711261876994541353270e-02
 	 1.29831025553591050680779517279007e-01 1.86663352285099226612885559006827e-01 6.83505622161309722706334923714167e-01 9.54365713186737865680875358975754e-03
 	 7.14129531151586061099578728317283e-02 1.99194841634428132515211018471746e-01 7.29392205250413261374831108696526e-01 7.79663573295533499085685491536424e-03
 	 2.94822986479423843064751054043882e-02 2.08189550428014014116229191131424e-01 7.62328150924043601577295703464188e-01 5.34040808296098838681142950690628e-03
 	 5.64068897251168710482716051046737e-03 2.13303907428296635195863473200006e-01 7.81055403599191677699309366289526e-01 2.38880125591959873929126523250943e-03
 	 9.85730545263174495751457016012864e-01 1.96620435431386908486928177808295e-03 1.23032503825116351636737022090529e-02 4.75018172811310140837143256575814e-05
 	 9.52700409905833267565355981787434e-01 6.51746417194224575419880807203299e-03 4.07821259222244866804452101405332e-02 2.77220122642702043302270764613127e-04
 	 9.02286700679378106393357938941335e-01 1.34640263515298785890195176762063e-02 8.42492729690920150176225433824584e-02 7.97956605485818331983949303065629e-04
 	 8.36430960605610174241064669331536e-01 2.25383634777718278030533838318661e-02 1.41030675916617997955881946836598e-01 1.66147591802295511130560523582744e-03
 	 7.57664739031342793218470887950389e-01 3.33916504945838965578985835236381e-02 2.08943610474073310223630528525973e-01 2.84951812592957849992747476619570e-03
 	 6.69015195029959874872815817070659e-01 4.56067717194776345301931996800704e-02 2.85378033250562490596990983249270e-01 4.27222629234679223547699322693916e-03
 	 5.73889160906685846796904115763027e-01 5.87142958646785229070985678845318e-02 3.67396543228635630295997316352441e-01 5.77832867633106071064696962480411e-03
 	 4.75942308463234819981835244107060e-01 7.22105037659269699545916409988422e-02 4.51847187770838210063573114894098e-01 7.17565826165505495082275189133725e-03
 	 3.78938688646978105722951113421004e-01 8.55767425735467490710561833111569e-02 5.35484568779475145205992703267839e-01 8.25898210150660498640728945929368e-03
 	 2.86606086257527037375325562607031e-01 9.82993565914989098075693618739024e-02 6.15094557150974052817105075519066e-01 8.84095876441604727746792491416272e-03
 	 2.02492755050103889757906472368632e-01 1.09889427909996451049323695769999e-01 6.87617817039899659192769831861369e-01 8.78152279877469736646400377821919e-03
 	 1.29831025553591050680779517279007e-01 1.19901570038967841824728566280100e-01 7.50267404407441107494491916440893e-01 8.01119298816882485780865863489453e-03
 	 7.14129531151586061099578728317283e-02 1.27951062505042401085120218340307e-01 8.00635984379798992804921908827964e-01 6.54469797606159909425516119085842e-03
 	 2.94822986479423843064751054043882e-02 1.33728734946856442356022398598725e-01 8.36788966405201173337502495996887e-01 4.48287686753955690738271400164194e-03
 	 5.64068897251168710482716051046737e-03 1.37013897388046701486530309921363e-01 8.57345413639441611408642529568169e-01 2.00522164691466263722330332086585e-03
 	 9.85730545263174495751457016012864e-01 1.08300464368650192770182627555187e-03 1.31864500931390023208411577115839e-02 3.64708245761565766525358345262475e-05
 	 9.52700409905833267565355981787434e-01 3.58988319183993487282435808083392e-03 4.37097069023267975618196601317322e-02 2.12843361382275742975031529446994e-04
 	 9.02286700679378106393357938941335e-01 7.41611777505839231405815326070297e-03 9.02971815455635012925839077979617e-02 6.12653095055771851513981562931122e-04
 	 8.36430960605610285263367131847190e-01 1.24143516689744215497626100841444e-02 1.51154687725415293186870258068666e-01 1.27564375874507883457109613800640e-03
 	 7.57664739031342793218470887950389e-01 1.83924486112790885883327973715495e-02 2.23942812357378118193196314678062e-01 2.18779578647062839663606226281445e-03
 	 6.69015195029959985895118279586313e-01 2.51206571928178634678374692157377e-02 3.05864147777222150637044251197949e-01 3.28011904756570719238206734758023e-03
 	 5.73889160906685846796904115763027e-01 3.23404100559119278557318466482684e-02 3.93770429037402225347364037588704e-01 4.43647050913053946075148559202717e-03
 	 4.75942308463234764470684012849233e-01 3.97742537442050125839898555568652e-02 4.84283437792560167434174900336075e-01 5.50930866771754540467398442160629e-03
 	 3.78938688646978105722951113421004e-01 4.71365091809378133902441732061561e-02 5.73924802172084080886804713372840e-01 6.34106029289354701516945311823292e-03
 	 2.86606086257527037375325562607031e-01 5.41442497705884040470891704899259e-02 6.59249663971884558577585266903043e-01 6.78788885641502109935530029360962e-03
 	 2.02492755050103889757906472368632e-01 6.05281747329410313440689606068190e-02 7.36979070216955078898024567024549e-01 6.74225526173397732287995154365490e-03
 	 1.29831025553591050680779517279007e-01 6.60429608207324658764036939828657e-02 8.04126013625676483442816788738128e-01 6.15081339705503184894785917435911e-03
 	 7.14129531151586061099578728317283e-02 7.04767002237358664018529452732764e-02 8.58110346661105527488189181894995e-01 5.02487158283276488801583070653578e-03
 	 2.94822986479423843064751054043882e-02 7.36590988744436625523803741089068e-02 8.96858602477613953141144520486705e-01 3.44185181095144629784265966065959e-03
 	 5.64068897251168710482716051046737e-03 7.54685985692580274530882888939232e-02 9.18890712458230285442084550595609e-01 1.53956398106028799835365283854571e-03
 	 9.85730545263174495751457016012864e-01 4.47537243966370998360382316150208e-04 1.38219174928591332501826016709856e-02 2.39485483644636412909126321757469e-05
 	 9.52700409905833156543053519271780e-01 1.48347141372212609766734203731176e-03 4.58161186804447173592791386909084e-02 1.39763484740371970657668576620836e-04
 	 9.02286700679378106393357938941335e-01 3.06461189185851246019609561699326e-03 9.46486874287633811464459654416714e-02 4.02298342527019812085720129601896e-04
 	 8.36430960605610174241064669331536e-01 5.13006547474267882158471820730483e-03 1.58438973919647146937350612461159e-01 8.37650823834270338678897882545016e-04
 	 7.57664739031342904240773350466043e-01 7.60043441112673301418567461951170e-03 2.34734826557530362745040974914446e-01 1.43661498780906188126038625085812e-03
 	 6.69015195029960096917420742101967e-01 1.03807769913422665020164004090475e-02 3.20604027978697636580562857488985e-01 2.15388850032148223070938009016118e-03
 	 5.73889160906685846796904115763027e-01 1.33642436988061219516055189160397e-02 4.12746595394508031251490365320933e-01 2.91320609802966055956741087129558e-03
 	 4.75942308463234819981835244107060e-01 1.64361805882092815167538901732769e-02 5.07621510948555898501410865719663e-01 3.61768472791400416341267565201179e-03
 	 3.78938688646978105722951113421004e-01 1.94785345861719916271681540820282e-02 6.01582776766849902649880732496968e-01 4.16385400854417820487585188971025e-03
 	 2.86606086257527037375325562607031e-01 2.23743900455243283076356419769581e-02 6.91019523696948634317038795416011e-01 4.45726375697947166387713480162347e-03
 	 2.02492755050103889757906472368632e-01 2.50124620057831092978517517622095e-02 7.72494782944113000944241775869159e-01 4.42729848029697631989209938296881e-03
 	 1.29831025553591050680779517279007e-01 2.72913739025900659029844064207282e-02 8.42877600543818883416236076300265e-01 4.03892848138303998950515705246289e-03
 	 7.14129531151586061099578728317283e-02 2.91235576558663833424134281813167e-02 8.99463489228975010547628698986955e-01 3.29957936309898270527130037521601e-03
 	 2.94822986479423843064751054043882e-02 3.04386415104397345388065332372207e-02 9.40079059841617881154718361358391e-01 2.26009023694451281066841730194028e-03
 	 5.64068897251168710482716051046737e-03 3.11863931577628372693311575858388e-02 9.63172917869725475625841681903694e-01 1.01095390326636858438491550771232e-03
 	 9.85730545263174495751457016012864e-01 8.56701103049660461774550412883400e-05 1.41837846265205382023655289458475e-02 1.04666317009286040070129009116329e-05
 	 9.52700409905833267565355981787434e-01 2.83974487847067635915010441749473e-04 4.70156156063196647987290077708167e-02 6.10831561793741863999537833329612e-05
 	 9.02286700679377995371055476425681e-01 5.86645340375641088925817712151911e-04 9.71266539802463635400187058621668e-02 1.75823123850481628479072715443010e-04
 	 8.36430960605610174241064669331536e-01 9.82026146467335214751415151113179e-04 1.62587013247922490544183915517351e-01 3.66092446758164633251880770714592e-04
 	 7.57664739031342682196168425434735e-01 1.45491813954107263029413843469229e-03 2.40880342829116245173537436130573e-01 6.27867699728456977494028823372219e-04
 	 6.69015195029959985895118279586313e-01 1.98714704058544633369365328690037e-03 3.28997657929454567771188067126786e-01 9.41349651538067166284262654585291e-04
 	 5.73889160906685846796904115763027e-01 2.55825911084439638898402336053550e-03 4.23552579982469756814111860876437e-01 1.27320682794373053574321641434608e-03
 	 4.75942308463234819981835244107060e-01 3.14630664367687717941635128227063e-03 5.20911384893088302838748404610669e-01 1.58109681976951934462283233528979e-03
 	 3.78938688646978105722951113421004e-01 3.72869125212260676960340788355097e-03 6.17332620100899287507445478695445e-01 1.81979824833709532064252023531026e-03
 	 2.86606086257527037375325562607031e-01 4.28303228177906447626810404472053e-03 7.09110881460693898148406333348248e-01 1.94803198207317801275706425911949e-03
 	 2.02492755050103889757906472368632e-01 4.78802693613411545214830766781233e-03 7.92719218013761994789945219963556e-01 1.93493575970182535989083660865617e-03
 	 1.29831025553591050680779517279007e-01 5.22426913989904040391820672084577e-03 8.64944705306509908915302276000148e-01 1.76519997110789099784011746407941e-03
 	 7.14129531151586061099578728317283e-02 5.57499611594025612504310629446991e-03 9.23012050768901137764999020873802e-01 1.44206995079449330071641455219833e-03
 	 2.94822986479423843064751054043882e-02 5.82673690489243778500849657575600e-03 9.64690964447165177908516398019856e-01 9.87764759723985677833391072510949e-04
 	 5.64068897251168710482716051046737e-03 5.96987575416252358451174586662091e-03 9.88389435273325789310661093622912e-01 4.41833968851592414749801518425443e-04
 	 ];
 
 	 case  29 

 	 % ALG. DEG.:   29
 	 % PTS CARD.:  225
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-15  

 	 xyw_bar=[
 	 9.85730545263174495751457016012864e-01 1.41837846265205382023655289458475e-02 8.56701103049660461774550412883400e-05 1.04666317009286073951446899288342e-05
 	 9.52700409905833267565355981787434e-01 4.70156156063196647987290077708167e-02 2.83974487847067635915010441749473e-04 6.10831561793741999524809394017666e-05
 	 9.02286700679377995371055476425681e-01 9.71266539802462941510796667898830e-02 5.86645340375710477864856784435688e-04 1.75823123850481682689181339718232e-04
 	 8.36430960605610174241064669331536e-01 1.62587013247922435033032684259524e-01 9.82026146467390725902646408940200e-04 3.66092446758164687461989394989814e-04
 	 7.57664739031342682196168425434735e-01 2.40880342829116134151234973614919e-01 1.45491813954118365259660095034633e-03 6.27867699728457085914246071922662e-04
 	 6.69015195029960096917420742101967e-01 3.28997657929454512260036835868959e-01 1.98714704058539082254242202907335e-03 9.41349651538067383124697151686178e-04
 	 5.73889160906685846796904115763027e-01 4.23552579982469701302960629618610e-01 2.55825911084445190013525461836252e-03 1.27320682794373096942408540854785e-03
 	 4.75942308463234819981835244107060e-01 5.20911384893088302838748404610669e-01 3.14630664367687717941635128227063e-03 1.58109681976951977830370132949156e-03
 	 3.78938688646978105722951113421004e-01 6.17332620100899287507445478695445e-01 3.72869125212260676960340788355097e-03 1.81979824833709575432338922951203e-03
 	 2.86606086257527037375325562607031e-01 7.09110881460693898148406333348248e-01 4.28303228177906447626810404472053e-03 1.94803198207317844643793325332126e-03
 	 2.02492755050103889757906472368632e-01 7.92719218013761994789945219963556e-01 4.78802693613411545214830766781233e-03 1.93493575970182579357170560285795e-03
 	 1.29831025553591050680779517279007e-01 8.64944705306509908915302276000148e-01 5.22426913989904040391820672084577e-03 1.76519997110789143152098645828119e-03
 	 7.14129531151586061099578728317283e-02 9.23012050768901137764999020873802e-01 5.57499611594025612504310629446991e-03 1.44206995079449373439728354640010e-03
 	 2.94822986479423843064751054043882e-02 9.64690964447165177908516398019856e-01 5.82673690489243778500849657575600e-03 9.87764759723985894673825569611836e-04
 	 5.64068897251168710482716051046737e-03 9.88389435273325678288358631107258e-01 5.96987575416263460681420838227496e-03 4.41833968851592523170018766975886e-04
 	 9.85730545263174495751457016012864e-01 1.38219174928591332501826016709856e-02 4.47537243966370998360382316150208e-04 2.39485483644636379027808431585456e-05
 	 9.52700409905833156543053519271780e-01 4.58161186804446063369766761752544e-02 1.48347141372223711996980455296580e-03 1.39763484740371943552614264483225e-04
 	 9.02286700679378106393357938941335e-01 9.46486874287634366575971966994985e-02 3.06461189185845694904486435916624e-03 4.02298342527019757875611505326674e-04
 	 8.36430960605610174241064669331536e-01 1.58438973919647091426199381203332e-01 5.13006547474273433273594946513185e-03 8.37650823834270121838463385444129e-04
 	 7.57664739031342793218470887950389e-01 2.34734826557530446011767821801186e-01 7.60043441112676076976129024842521e-03 1.43661498780906144757951725665635e-03
 	 6.69015195029959985895118279586313e-01 3.20604027978697692091714088746812e-01 1.03807769913423220131676316668745e-02 2.15388850032148179702851109595940e-03
 	 5.73889160906685846796904115763027e-01 4.12746595394508031251490365320933e-01 1.33642436988061219516055189160397e-02 2.91320609802966012588654187709380e-03
 	 4.75942308463234819981835244107060e-01 5.07621510948555898501410865719663e-01 1.64361805882092815167538901732769e-02 3.61768472791400329605093766360824e-03
 	 3.78938688646978105722951113421004e-01 6.01582776766849902649880732496968e-01 1.94785345861719916271681540820282e-02 4.16385400854417733751411390130670e-03
 	 2.86606086257527037375325562607031e-01 6.91019523696948523294736332900357e-01 2.23743900455244393299381044926122e-02 4.45726375697947079651539681321992e-03
 	 2.02492755050103889757906472368632e-01 7.72494782944113000944241775869159e-01 2.50124620057831092978517517622095e-02 4.42729848029697545253036139456526e-03
 	 1.29831025553591050680779517279007e-01 8.42877600543818883416236076300265e-01 2.72913739025900659029844064207282e-02 4.03892848138303912214341906405934e-03
 	 7.14129531151586061099578728317283e-02 8.99463489228975010547628698986955e-01 2.91235576558663833424134281813167e-02 3.29957936309898227159043138101424e-03
 	 2.94822986479423843064751054043882e-02 9.40079059841617881154718361358391e-01 3.04386415104397345388065332372207e-02 2.26009023694451237698754830773851e-03
 	 5.64068897251168710482716051046737e-03 9.63172917869725475625841681903694e-01 3.11863931577628372693311575858388e-02 1.01095390326636836754448101061143e-03
 	 9.85730545263174495751457016012864e-01 1.31864500931389988513942057579698e-02 1.08300464368650539714877822916606e-03 3.64708245761568070454974876959398e-05
 	 9.52700409905833267565355981787434e-01 4.37097069023267836840318523172755e-02 3.58988319183994875061216589529067e-03 2.12843361382277071122692824189926e-04
 	 9.02286700679377995371055476425681e-01 9.02971815455635429259473312413320e-02 7.41611777505846170299719233298674e-03 6.12653095055775646221585262196641e-04
 	 8.36430960605610285263367131847190e-01 1.51154687725415320942445873697579e-01 1.24143516689743937941869944552309e-02 1.27564375874508685766717253073921e-03
 	 7.57664739031342682196168425434735e-01 2.23942812357378062682045083420235e-01 1.83924486112792551217864911450306e-02 2.18779578647064184074300108306943e-03
 	 6.69015195029959985895118279586313e-01 3.05864147777222039614741788682295e-01 2.51206571928179744901399317313917e-02 3.28011904756572757538291007506359e-03
 	 5.73889160906685846796904115763027e-01 3.93770429037402169836212806330877e-01 3.23404100559119833668830779060954e-02 4.43647050913056721632710122094068e-03
 	 4.75942308463234875492986475364887e-01 4.84283437792560056411872437820421e-01 3.97742537442051236062923180725193e-02 5.50930866771757923178176596934463e-03
 	 3.78938688646978105722951113421004e-01 5.73924802172083969864502250857186e-01 4.71365091809379244125466357218102e-02 6.34106029289358691380940058479609e-03
 	 2.86606086257527037375325562607031e-01 6.59249663971884336532980341871735e-01 5.41442497705886260916940955212340e-02 6.78788885641506360008046172538343e-03
 	 2.02492755050103889757906472368632e-01 7.36979070216954967875722104508895e-01 6.05281747329411423663714231224731e-02 6.74225526173401895624337498702516e-03
 	 1.29831025553591050680779517279007e-01 8.04126013625676261398211863706820e-01 6.60429608207326879210086190141737e-02 6.15081339705507001286433066411519e-03
 	 7.14129531151586061099578728317283e-02 8.58110346661105305443584256863687e-01 7.04767002237360884464578703045845e-02 5.02487158283279611303839828906348e-03
 	 2.94822986479423843064751054043882e-02 8.96858602477613731096539595455397e-01 7.36590988744438845969852991402149e-02 3.44185181095146754820524037654650e-03
 	 5.64068897251168710482716051046737e-03 9.18890712458230063397479625564301e-01 7.54685985692582494976932139252312e-02 1.53956398106029753933277071098473e-03
 	 9.85730545263174495751457016012864e-01 1.23032503825116368983971781858600e-02 1.96620435431386735014580580127586e-03 4.75018172811309530973421233479570e-05
 	 9.52700409905833267565355981787434e-01 4.07821259222244936193391140477615e-02 6.51746417194223881530490416480461e-03 2.77220122642701718041619018961796e-04
 	 9.02286700679377995371055476425681e-01 8.42492729690920982843493902691989e-02 1.34640263515299063445951333051198e-02 7.97956605485817356201994066111638e-04
 	 8.36430960605610174241064669331536e-01 1.41030675916617970200306331207685e-01 2.25383634777718555586289994607796e-02 1.66147591802295315974169476191946e-03
 	 7.57664739031342793218470887950389e-01 2.08943610474073365734781759783800e-01 3.33916504945838410467473522658111e-02 2.84951812592957503048052281258151e-03
 	 6.69015195029959985895118279586313e-01 2.85378033250562435085839751991443e-01 4.56067717194775790190419684222434e-02 4.27222629234678703130656529651787e-03
 	 5.73889160906685846796904115763027e-01 3.67396543228635685807148547610268e-01 5.87142958646784673959473366267048e-02 5.77832867633105377175306571757574e-03
 	 4.75942308463234819981835244107060e-01 4.51847187770838321085875577409752e-01 7.22105037659268589322891784831882e-02 7.17565826165504627720537200730178e-03
 	 3.78938688646978105722951113421004e-01 5.35484568779475256228295165783493e-01 8.55767425735466380487537207955029e-02 8.25898210150659457806643359845111e-03
 	 2.86606086257527037375325562607031e-01 6.15094557150974163839407538034720e-01 9.82993565914987987852668993582483e-02 8.84095876441603686912706905332016e-03
 	 2.02492755050103889757906472368632e-01 6.87617817039899770215072294377023e-01 1.09889427909996340027021233254345e-01 8.78152279877468695812314791737663e-03
 	 1.29831025553591050680779517279007e-01 7.50267404407441329539096841472201e-01 1.19901570038967619780123641248792e-01 8.01119298816881618419127875085906e-03
 	 7.14129531151586061099578728317283e-02 8.00635984379799214849526833859272e-01 1.27951062505042179040515293308999e-01 6.54469797606159128799951929522649e-03
 	 2.94822986479423843064751054043882e-02 8.36788966405201284359804958512541e-01 1.33728734946856331333719936083071e-01 4.48287686753955083585054808281711e-03
 	 5.64068897251168710482716051046737e-03 8.57345413639441722430944992083823e-01 1.37013897388046590464227847405709e-01 2.00522164691466046881895834985698e-03
 	 9.85730545263174495751457016012864e-01 1.12084581549249870380258187196887e-02 3.06099658190051721051716526744713e-03 5.65884579164717844155033099617924e-05
 	 9.52700409905833267565355981787434e-01 3.71531699068632231819364619695989e-02 1.01464201873035092527075562429673e-02 3.30249664995388902879319692473814e-04
 	 9.02286700679377995371055476425681e-01 7.67524370632329810959504357015248e-02 2.09608622573890235329940878727939e-02 9.50598027049414230453538987575257e-04
 	 8.36430960605610174241064669331536e-01 1.28481204594448117362048833456356e-01 3.50878347999417083968864972121082e-02 1.97930027623639381156861460908658e-03
 	 7.57664739031342793218470887950389e-01 1.90350975711794379030550317111192e-01 5.19842852568628277509787949384190e-02 3.39460352847263018352674812661007e-03
 	 6.69015195029959985895118279586313e-01 2.59983959082098703419205776299350e-01 7.10008458879413106856759441143367e-02 5.08946207938330234116230954555249e-03
 	 5.73889160906685846796904115763027e-01 3.34704135331235663741722419217695e-01 9.14067037620784894613734650192782e-02 6.88366735935364189302720916430189e-03
 	 4.75942308463234819981835244107060e-01 4.11640025122863795203898007457610e-01 1.12417666413901384814266748435330e-01 8.54829265077291546026660995494240e-03
 	 3.78938688646978105722951113421004e-01 4.87835018809682607887623362330487e-01 1.33226292543339286389425524248509e-01 9.83884591863076404805177332946187e-03
 	 2.86606086257527037375325562607031e-01 5.60360993298860798894622803345555e-01 1.53032920443612163730051634047413e-01 1.05321491180117611519140297104968e-02
 	 2.02492755050103889757906472368632e-01 6.26430844634994321573628894839203e-01 1.71076400314901788668464632792166e-01 1.04613436239710862890595066687638e-02
 	 1.29831025553591050680779517279007e-01 6.83505622161309722706334923714167e-01 1.86663352285099226612885559006827e-01 9.54365713186734222761575807680856e-03
 	 7.14129531151586061099578728317283e-02 7.29392205250413372397133571212180e-01 1.99194841634428021492908555956092e-01 7.79663573295530463319602532124009e-03
 	 2.94822986479423843064751054043882e-02 7.62328150924043601577295703464188e-01 2.08189550428014014116229191131424e-01 5.34040808296096757012971778522115e-03
 	 5.64068897251179812712962302612141e-03 7.81055403599191677699309366289526e-01 2.13303907428296524173561010684352e-01 2.38880125591958963199301635427219e-03
 	 9.85730545263174495751457016012864e-01 9.94688977170379851067139043152565e-03 4.32256496512170573787159355561016e-03 6.33584785787931980237386309084968e-05
 	 9.52700409905833267565355981787434e-01 3.29713936229995632776201830438367e-02 1.43281964711671691570238351687294e-02 3.69759436741487533626543404707832e-04
 	 9.02286700679377995371055476425681e-01 6.81135639376191370786273182602599e-02 2.95997353830028675503172053140588e-02 1.06432383831265480259031797061198e-03
 	 8.36430960605610174241064669331536e-01 1.14019998305935774118857750636380e-01 4.95490410884540516400775800320844e-02 2.21609598088058114273568577345941e-03
 	 7.57664739031342793218470887950389e-01 1.68926015261923190280413109576330e-01 7.34092457067340165011160024732817e-02 3.80072055081791346925479402329984e-03
 	 6.69015195029960096917420742101967e-01 2.30721455855592949557575366270612e-01 1.00263349114446953525003891627421e-01 5.69834531646294141504771602058099e-03
 	 5.73889160906685846796904115763027e-01 2.97031500163147388349216271308251e-01 1.29079338930166764853879612928722e-01 7.70720226331161970684258122332722e-03
 	 4.75942308463234819981835244107060e-01 3.65307868301169680336215606075712e-01 1.58749823235595499681949149817228e-01 9.57097678114321101516814849219372e-03
 	 3.78938688646978105722951113421004e-01 4.32926731920286744781378729385324e-01 1.88134579432735149495670157193672e-01 1.10159267689491531527767875786594e-02
 	 2.86606086257527037375325562607031e-01 4.97289542920501870248983777855756e-01 2.16104370821971092375690659537213e-01 1.17921740378079068639616266978010e-02
 	 2.02492755050103889757906472368632e-01 5.55922899925507030260973806434777e-01 2.41584345024389079981119721196592e-01 1.17128976527885644148829769051190e-02
 	 1.29831025553591050680779517279007e-01 6.06573623954781426803606336761732e-01 2.63595350491627522515614145959262e-01 1.06854227560909727928750712067085e-02
 	 7.14129531151586061099578728317283e-02 6.47295441146639172202981171722058e-01 2.81291605738202221687060955446213e-01 8.72939458435593139407071561208795e-03
 	 2.94822986479423843064751054043882e-02 6.76524280351295859148308409203310e-01 2.93993421000761756545216485392302e-01 5.97931351346838151766815983023662e-03
 	 5.64068897251157608252469799481332e-03 6.93143686474045450651715327694546e-01 3.01215624553442973265759974310640e-01 2.67458804807120141197596119297941e-03
 	 9.85730545263174495751457016012864e-01 8.57019237721925487838436907850337e-03 5.69926235960624937015861490863244e-03 6.75346448042547976451863145364030e-05
 	 9.52700409905833267565355981787434e-01 2.84079941348063143291557963721061e-02 1.88915959593604181054882218404600e-02 3.94131500369012159005338569173205e-04
 	 9.02286700679377995371055476425681e-01 5.86863190244673038620248917140998e-02 3.90269802961547007669196318602189e-02 1.13447693172993727475650338476498e-03
 	 8.36430960605610285263367131847190e-01 9.82390820406873338521691607638786e-02 6.53299573537023808844637073889317e-02 2.36216617377868476346236548124580e-03
 	 7.57664739031342682196168425434735e-01 1.45545842121439006344729705233476e-01 9.67894188472183114591018693317892e-02 4.05123857386362890009579018624208e-03
 	 6.69015195029959985895118279586313e-01 1.98788496466452357935850159265101e-01 1.32196308503587656169031561148586e-01 6.07394204456359210891891464711989e-03
 	 5.73889160906685846796904115763027e-01 2.55920911653589988610235650412505e-01 1.70189927439724164592860233824467e-01 8.21520937627939241976182671578499e-03
 	 4.75942308463234875492986475364887e-01 3.14747501993945799636520632702741e-01 2.09310189542819380381644123190199e-01 1.02018314177232290174135442839543e-02
 	 3.78938688646978105722951113421004e-01 3.73007589603775779885097563237650e-01 2.48053721749246114391951323341345e-01 1.17420228234406190392924429488630e-02
 	 2.86606086257527092886476793864858e-01 4.28462277940586833135938604755211e-01 2.84931635801886129488735832637758e-01 1.25694351091926257574238334768779e-02
 	 2.02492755050103889757906472368632e-01 4.78980496276990241888427135563688e-01 3.18526748672905868353666392067680e-01 1.24849333562506194239549728308702e-02
 	 1.29831025553591050680779517279007e-01 5.22620916442415373026619818119798e-01 3.47548058003993576292600664601196e-01 1.13897342013740375532560022975304e-02
 	 7.14129531151586061099578728317283e-02 5.57706638240295093922327396285255e-01 3.70880408644546299967714730883017e-01 9.30477776352394564396419696095109e-03
 	 2.94822986479423843064751054043882e-02 5.82890065492028708327154618018540e-01 3.87627635860028907366370276577072e-01 6.37342978182762077282719204163186e-03
 	 5.64068897251168710482716051046737e-03 5.97209265858788418412927967438009e-01 3.97150045168699894482244872051524e-01 2.85087896483442052378287634439857e-03
 	 9.85730545263174495751457016012864e-01 7.13472736841275299163322998197145e-03 7.13472736841275125690975400516436e-03 6.89459618314110104023151315288942e-05
 	 9.52700409905833267565355981787434e-01 2.36497950470833696867689610598973e-02 2.36497950470833627478750571526689e-02 4.02367932188882663178952636684471e-04
 	 9.02286700679377995371055476425681e-01 4.88566496603109814977905500654742e-02 4.88566496603110231311539735088445e-02 1.15818486142005576573776881588174e-03
 	 8.36430960605610174241064669331536e-01 8.17845196971948990016798575197754e-02 8.17845196971949267572554731486889e-02 2.41152995368289560507157887059293e-03
 	 7.57664739031342793218470887950389e-01 1.21167630484328617268552363839262e-01 1.21167630484328589512976748210349e-01 4.13590003905587016291844904003483e-03
 	 6.69015195029959985895118279586313e-01 1.65492402485020034808016475835757e-01 1.65492402485019979296865244577930e-01 6.20087330857332832273476341811147e-03
 	 5.73889160906685846796904115763027e-01 2.13055419546657104357123557747400e-01 2.13055419546657048845972326489573e-01 8.38688814808609753304047274014010e-03
 	 4.75942308463234764470684012849233e-01 2.62028845768382645520233609204297e-01 2.62028845768382534497931146688643e-01 1.04150259703819705880967205757770e-02
 	 3.78938688646978161234102344678831e-01 3.10530655676511002649675674547325e-01 3.10530655676510891627373212031671e-01 1.19874037948222104260631581951202e-02
 	 2.86606086257527092886476793864858e-01 3.56696956871236536823488449954311e-01 3.56696956871236425801185987438657e-01 1.28321070732305714950927111317469e-02
 	 2.02492755050103945269057703626459e-01 3.98753622474948110632197995073511e-01 3.98753622474947999609895532557857e-01 1.27458394301576960483401990131824e-02
 	 1.29831025553590995169628286021180e-01 4.35084487223204530170761472618324e-01 4.35084487223204419148459010102670e-01 1.16277531597882531622101254242807e-02
 	 7.14129531151586616211091040895553e-02 4.64293523442420752456172294841963e-01 4.64293523442420641433869832326309e-01 9.49922598087414062073552400988774e-03
 	 2.94822986479424398176263366622152e-02 4.85258850676028863357913678555633e-01 4.85258850676028752335611216039979e-01 6.50661964309881199475249502484075e-03
 	 5.64068897251168710482716051046737e-03 4.97179655513744211958737651002593e-01 4.97179655513744100936435188486939e-01 2.91045570558865363680611793029129e-03
 	 9.85730545263174495751457016012864e-01 5.69926235960624590071166295501826e-03 8.57019237721925834783132103211756e-03 6.75346448042550958007837480501223e-05
 	 9.52700409905833267565355981787434e-01 1.88915959593604076971473659796175e-02 2.84079941348063247374966522329487e-02 3.94131500369013893728814545980299e-04
 	 9.02286700679378106393357938941335e-01 3.90269802961546244390866888807068e-02 5.86863190244672691675553721779579e-02 1.13447693172994204524606232098449e-03
 	 8.36430960605610285263367131847190e-01 6.53299573537023947622515152033884e-02 9.82390820406873199743813529494219e-02 2.36216617377869473812235234788659e-03
 	 7.57664739031342793218470887950389e-01 9.67894188472181449256481755583081e-02 1.45545842121439061855880936491303e-01 4.05123857386364624733054995431303e-03
 	 6.69015195029959985895118279586313e-01 1.32196308503587572902304714261845e-01 1.98788496466452441202577006151841e-01 6.07394204456361812977105429922631e-03
 	 5.73889160906685846796904115763027e-01 1.70189927439724053570557771308813e-01 2.55920911653590099632538112928160e-01 8.21520937627942711423134625192688e-03
 	 4.75942308463234875492986475364887e-01 2.09310189542819269359341660674545e-01 3.14747501993945910658823095218395e-01 1.02018314177232723855004437041316e-02
 	 3.78938688646978161234102344678831e-01 2.48053721749245947858497629567864e-01 3.73007589603775946418551257011131e-01 1.17420228234406710809967222530759e-02
 	 2.86606086257527037375325562607031e-01 2.84931635801885962955282138864277e-01 4.28462277940586999669392298528692e-01 1.25694351091926795338515887578978e-02
 	 2.02492755050103945269057703626459e-01 3.18526748672905701820212698294199e-01 4.78980496276990408421880829337169e-01 1.24849333562506732003827281118902e-02
 	 1.29831025553591050680779517279007e-01 3.47548058003993354247995739569888e-01 5.22620916442415595071224743151106e-01 1.13897342013740878602368056249361e-02
 	 7.14129531151586061099578728317283e-02 3.70880408644546077923109805851709e-01 5.57706638240295315966932321316563e-01 9.30477776352398727732762040432135e-03
 	 2.94822986479423843064751054043882e-02 3.87627635860028685321765351545764e-01 5.82890065492028930371759543049848e-01 6.37342978182764852840280767054537e-03
 	 5.64068897251168710482716051046737e-03 3.97150045168699672437639947020216e-01 5.97209265858788640457532892469317e-01 2.85087896483443310052807717625001e-03
 	 9.85730545263174495751457016012864e-01 4.32256496512170920731854550922435e-03 9.94688977170379504122443847791146e-03 6.33584785787931709186843187708860e-05
 	 9.52700409905833156543053519271780e-01 1.43281964711671760959177390759578e-02 3.29713936229996673610287416522624e-02 3.69759436741487370996217531882166e-04
 	 9.02286700679377995371055476425681e-01 2.95997353830028397947415896851453e-02 6.81135639376191648342029338891734e-02 1.06432383831265436890944897641020e-03
 	 8.36430960605610174241064669331536e-01 4.95490410884540377622897722176276e-02 1.14019998305935787996645558450837e-01 2.21609598088058027537394778505586e-03
 	 7.57664739031342793218470887950389e-01 7.34092457067340997678428493600222e-02 1.68926015261923107013686262689589e-01 3.80072055081791173453131804649274e-03
 	 6.69015195029959985895118279586313e-01 1.00263349114447120058457585400902e-01 2.30721455855592894046424135012785e-01 5.69834531646293881296250205537035e-03
 	 5.73889160906685846796904115763027e-01 1.29079338930166820365030844186549e-01 2.97031500163147332838065040050424e-01 7.70720226331161623739562926971303e-03
 	 4.75942308463234819981835244107060e-01 1.58749823235595610704251612332882e-01 3.65307868301169569313913143560058e-01 9.57097678114320581099772056177244e-03
 	 3.78938688646978105722951113421004e-01 1.88134579432735260517972619709326e-01 4.32926731920286633759076266869670e-01 1.10159267689491479486063596482381e-02
 	 2.86606086257527037375325562607031e-01 2.16104370821971203397993122052867e-01 4.97289542920501759226681315340102e-01 1.17921740378079016597911987673797e-02
 	 2.02492755050103889757906472368632e-01 2.41584345024389302025724646227900e-01 5.55922899925506808216368881403469e-01 1.17128976527885592107125489746977e-02
 	 1.29831025553591050680779517279007e-01 2.63595350491627633537916608474916e-01 6.06573623954781315781303874246078e-01 1.06854227560909675887046432762872e-02
 	 7.14129531151586061099578728317283e-02 2.81291605738202443731665880477522e-01 6.47295441146638950158376246690750e-01 8.72939458435592618990028768166667e-03
 	 2.94822986479423843064751054043882e-02 2.93993421000762089612123872939264e-01 6.76524280351295526081401021656347e-01 5.97931351346837804822120787662243e-03
 	 5.64068897251168710482716051046737e-03 3.01215624553443195310364899341948e-01 6.93143686474045117584807940147584e-01 2.67458804807120054461422320457586e-03
 	 9.85730545263174495751457016012864e-01 3.06099658190051894524064124425422e-03 1.12084581549249853033023427428816e-02 5.65884579164720012559378070626792e-05
 	 9.52700409905833267565355981787434e-01 1.01464201873035092527075562429673e-02 3.71531699068632231819364619695989e-02 3.30249664995390149711818050803913e-04
 	 9.02286700679377995371055476425681e-01 2.09608622573889818996306644294236e-02 7.67524370632330227293138591448951e-02 9.50598027049417808320708189739889e-04
 	 8.36430960605610174241064669331536e-01 3.50878347999416528857352659542812e-02 1.28481204594448172873200064714183e-01 1.97930027623640161782425650471851e-03
 	 7.57664739031342793218470887950389e-01 5.19842852568628555065544105673325e-02 1.90350975711794351274974701482279e-01 3.39460352847264319395281795266328e-03
 	 6.69015195029959874872815817070659e-01 7.10008458879413661968271753721638e-02 2.59983959082098758930357007557177e-01 5.08946207938332229048228327883407e-03
 	 5.73889160906685846796904115763027e-01 9.14067037620784894613734650192782e-02 3.34704135331235663741722419217695e-01 6.88366735935366878124108680481186e-03
 	 4.75942308463234819981835244107060e-01 1.12417666413901384814266748435330e-01 4.11640025122863795203898007457610e-01 8.54829265077294842001265351427719e-03
 	 3.78938688646978161234102344678831e-01 1.33226292543339341900576755506336e-01 4.87835018809682552376472131072660e-01 9.83884591863080221196824481921794e-03
 	 2.86606086257527037375325562607031e-01 1.53032920443612274752354096563067e-01 5.60360993298860687872320340829901e-01 1.05321491180118027852774531538671e-02
 	 2.02492755050103889757906472368632e-01 1.71076400314901788668464632792166e-01 6.26430844634994321573628894839203e-01 1.04613436239711261876994541353270e-02
 	 1.29831025553591050680779517279007e-01 1.86663352285099226612885559006827e-01 6.83505622161309722706334923714167e-01 9.54365713186737865680875358975754e-03
 	 7.14129531151586061099578728317283e-02 1.99194841634428132515211018471746e-01 7.29392205250413261374831108696526e-01 7.79663573295533499085685491536424e-03
 	 2.94822986479423843064751054043882e-02 2.08189550428014014116229191131424e-01 7.62328150924043601577295703464188e-01 5.34040808296098838681142950690628e-03
 	 5.64068897251168710482716051046737e-03 2.13303907428296635195863473200006e-01 7.81055403599191677699309366289526e-01 2.38880125591959873929126523250943e-03
 	 9.85730545263174495751457016012864e-01 1.96620435431386908486928177808295e-03 1.23032503825116351636737022090529e-02 4.75018172811310140837143256575814e-05
 	 9.52700409905833267565355981787434e-01 6.51746417194224575419880807203299e-03 4.07821259222244866804452101405332e-02 2.77220122642702043302270764613127e-04
 	 9.02286700679378106393357938941335e-01 1.34640263515298785890195176762063e-02 8.42492729690920150176225433824584e-02 7.97956605485818331983949303065629e-04
 	 8.36430960605610174241064669331536e-01 2.25383634777718278030533838318661e-02 1.41030675916617997955881946836598e-01 1.66147591802295511130560523582744e-03
 	 7.57664739031342793218470887950389e-01 3.33916504945838965578985835236381e-02 2.08943610474073310223630528525973e-01 2.84951812592957849992747476619570e-03
 	 6.69015195029959874872815817070659e-01 4.56067717194776345301931996800704e-02 2.85378033250562490596990983249270e-01 4.27222629234679223547699322693916e-03
 	 5.73889160906685846796904115763027e-01 5.87142958646785229070985678845318e-02 3.67396543228635630295997316352441e-01 5.77832867633106071064696962480411e-03
 	 4.75942308463234819981835244107060e-01 7.22105037659269699545916409988422e-02 4.51847187770838210063573114894098e-01 7.17565826165505495082275189133725e-03
 	 3.78938688646978105722951113421004e-01 8.55767425735467490710561833111569e-02 5.35484568779475145205992703267839e-01 8.25898210150660498640728945929368e-03
 	 2.86606086257527037375325562607031e-01 9.82993565914989098075693618739024e-02 6.15094557150974052817105075519066e-01 8.84095876441604727746792491416272e-03
 	 2.02492755050103889757906472368632e-01 1.09889427909996451049323695769999e-01 6.87617817039899659192769831861369e-01 8.78152279877469736646400377821919e-03
 	 1.29831025553591050680779517279007e-01 1.19901570038967841824728566280100e-01 7.50267404407441107494491916440893e-01 8.01119298816882485780865863489453e-03
 	 7.14129531151586061099578728317283e-02 1.27951062505042401085120218340307e-01 8.00635984379798992804921908827964e-01 6.54469797606159909425516119085842e-03
 	 2.94822986479423843064751054043882e-02 1.33728734946856442356022398598725e-01 8.36788966405201173337502495996887e-01 4.48287686753955690738271400164194e-03
 	 5.64068897251168710482716051046737e-03 1.37013897388046701486530309921363e-01 8.57345413639441611408642529568169e-01 2.00522164691466263722330332086585e-03
 	 9.85730545263174495751457016012864e-01 1.08300464368650192770182627555187e-03 1.31864500931390023208411577115839e-02 3.64708245761565766525358345262475e-05
 	 9.52700409905833267565355981787434e-01 3.58988319183993487282435808083392e-03 4.37097069023267975618196601317322e-02 2.12843361382275742975031529446994e-04
 	 9.02286700679378106393357938941335e-01 7.41611777505839231405815326070297e-03 9.02971815455635012925839077979617e-02 6.12653095055771851513981562931122e-04
 	 8.36430960605610285263367131847190e-01 1.24143516689744215497626100841444e-02 1.51154687725415293186870258068666e-01 1.27564375874507883457109613800640e-03
 	 7.57664739031342793218470887950389e-01 1.83924486112790885883327973715495e-02 2.23942812357378118193196314678062e-01 2.18779578647062839663606226281445e-03
 	 6.69015195029959985895118279586313e-01 2.51206571928178634678374692157377e-02 3.05864147777222150637044251197949e-01 3.28011904756570719238206734758023e-03
 	 5.73889160906685846796904115763027e-01 3.23404100559119278557318466482684e-02 3.93770429037402225347364037588704e-01 4.43647050913053946075148559202717e-03
 	 4.75942308463234764470684012849233e-01 3.97742537442050125839898555568652e-02 4.84283437792560167434174900336075e-01 5.50930866771754540467398442160629e-03
 	 3.78938688646978105722951113421004e-01 4.71365091809378133902441732061561e-02 5.73924802172084080886804713372840e-01 6.34106029289354701516945311823292e-03
 	 2.86606086257527037375325562607031e-01 5.41442497705884040470891704899259e-02 6.59249663971884558577585266903043e-01 6.78788885641502109935530029360962e-03
 	 2.02492755050103889757906472368632e-01 6.05281747329410313440689606068190e-02 7.36979070216955078898024567024549e-01 6.74225526173397732287995154365490e-03
 	 1.29831025553591050680779517279007e-01 6.60429608207324658764036939828657e-02 8.04126013625676483442816788738128e-01 6.15081339705503184894785917435911e-03
 	 7.14129531151586061099578728317283e-02 7.04767002237358664018529452732764e-02 8.58110346661105527488189181894995e-01 5.02487158283276488801583070653578e-03
 	 2.94822986479423843064751054043882e-02 7.36590988744436625523803741089068e-02 8.96858602477613953141144520486705e-01 3.44185181095144629784265966065959e-03
 	 5.64068897251168710482716051046737e-03 7.54685985692580274530882888939232e-02 9.18890712458230285442084550595609e-01 1.53956398106028799835365283854571e-03
 	 9.85730545263174495751457016012864e-01 4.47537243966370998360382316150208e-04 1.38219174928591332501826016709856e-02 2.39485483644636412909126321757469e-05
 	 9.52700409905833156543053519271780e-01 1.48347141372212609766734203731176e-03 4.58161186804447173592791386909084e-02 1.39763484740371970657668576620836e-04
 	 9.02286700679378106393357938941335e-01 3.06461189185851246019609561699326e-03 9.46486874287633811464459654416714e-02 4.02298342527019812085720129601896e-04
 	 8.36430960605610174241064669331536e-01 5.13006547474267882158471820730483e-03 1.58438973919647146937350612461159e-01 8.37650823834270338678897882545016e-04
 	 7.57664739031342904240773350466043e-01 7.60043441112673301418567461951170e-03 2.34734826557530362745040974914446e-01 1.43661498780906188126038625085812e-03
 	 6.69015195029960096917420742101967e-01 1.03807769913422665020164004090475e-02 3.20604027978697636580562857488985e-01 2.15388850032148223070938009016118e-03
 	 5.73889160906685846796904115763027e-01 1.33642436988061219516055189160397e-02 4.12746595394508031251490365320933e-01 2.91320609802966055956741087129558e-03
 	 4.75942308463234819981835244107060e-01 1.64361805882092815167538901732769e-02 5.07621510948555898501410865719663e-01 3.61768472791400416341267565201179e-03
 	 3.78938688646978105722951113421004e-01 1.94785345861719916271681540820282e-02 6.01582776766849902649880732496968e-01 4.16385400854417820487585188971025e-03
 	 2.86606086257527037375325562607031e-01 2.23743900455243283076356419769581e-02 6.91019523696948634317038795416011e-01 4.45726375697947166387713480162347e-03
 	 2.02492755050103889757906472368632e-01 2.50124620057831092978517517622095e-02 7.72494782944113000944241775869159e-01 4.42729848029697631989209938296881e-03
 	 1.29831025553591050680779517279007e-01 2.72913739025900659029844064207282e-02 8.42877600543818883416236076300265e-01 4.03892848138303998950515705246289e-03
 	 7.14129531151586061099578728317283e-02 2.91235576558663833424134281813167e-02 8.99463489228975010547628698986955e-01 3.29957936309898270527130037521601e-03
 	 2.94822986479423843064751054043882e-02 3.04386415104397345388065332372207e-02 9.40079059841617881154718361358391e-01 2.26009023694451281066841730194028e-03
 	 5.64068897251168710482716051046737e-03 3.11863931577628372693311575858388e-02 9.63172917869725475625841681903694e-01 1.01095390326636858438491550771232e-03
 	 9.85730545263174495751457016012864e-01 8.56701103049660461774550412883400e-05 1.41837846265205382023655289458475e-02 1.04666317009286040070129009116329e-05
 	 9.52700409905833267565355981787434e-01 2.83974487847067635915010441749473e-04 4.70156156063196647987290077708167e-02 6.10831561793741863999537833329612e-05
 	 9.02286700679377995371055476425681e-01 5.86645340375641088925817712151911e-04 9.71266539802463635400187058621668e-02 1.75823123850481628479072715443010e-04
 	 8.36430960605610174241064669331536e-01 9.82026146467335214751415151113179e-04 1.62587013247922490544183915517351e-01 3.66092446758164633251880770714592e-04
 	 7.57664739031342682196168425434735e-01 1.45491813954107263029413843469229e-03 2.40880342829116245173537436130573e-01 6.27867699728456977494028823372219e-04
 	 6.69015195029959985895118279586313e-01 1.98714704058544633369365328690037e-03 3.28997657929454567771188067126786e-01 9.41349651538067166284262654585291e-04
 	 5.73889160906685846796904115763027e-01 2.55825911084439638898402336053550e-03 4.23552579982469756814111860876437e-01 1.27320682794373053574321641434608e-03
 	 4.75942308463234819981835244107060e-01 3.14630664367687717941635128227063e-03 5.20911384893088302838748404610669e-01 1.58109681976951934462283233528979e-03
 	 3.78938688646978105722951113421004e-01 3.72869125212260676960340788355097e-03 6.17332620100899287507445478695445e-01 1.81979824833709532064252023531026e-03
 	 2.86606086257527037375325562607031e-01 4.28303228177906447626810404472053e-03 7.09110881460693898148406333348248e-01 1.94803198207317801275706425911949e-03
 	 2.02492755050103889757906472368632e-01 4.78802693613411545214830766781233e-03 7.92719218013761994789945219963556e-01 1.93493575970182535989083660865617e-03
 	 1.29831025553591050680779517279007e-01 5.22426913989904040391820672084577e-03 8.64944705306509908915302276000148e-01 1.76519997110789099784011746407941e-03
 	 7.14129531151586061099578728317283e-02 5.57499611594025612504310629446991e-03 9.23012050768901137764999020873802e-01 1.44206995079449330071641455219833e-03
 	 2.94822986479423843064751054043882e-02 5.82673690489243778500849657575600e-03 9.64690964447165177908516398019856e-01 9.87764759723985677833391072510949e-04
 	 5.64068897251168710482716051046737e-03 5.96987575416252358451174586662091e-03 9.88389435273325789310661093622912e-01 4.41833968851592414749801518425443e-04
 	 ];
 
 	 case  30 

 	 % ALG. DEG.:   30
 	 % PTS CARD.:  256
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 9.87353020626041910645653842948377e-01 1.25799562956861680357301125354752e-02 6.70230782719213186160445161476673e-05 7.26311088332201032757027073238909e-06
 	 9.58024417690475416087281246291241e-01 4.17531313466935269373969674688851e-02 2.22450962831056975321786239874200e-04 4.25530214198786718802353101764879e-05
 	 9.13108376537141497308880389027763e-01 8.64311384799765491937506567410310e-02 4.60484982881953497368954231205862e-04 1.23251323125149117717822000450667e-04
 	 8.54138147775210576639892678940669e-01 1.45088852597804990329777297120017e-01 7.72999626984433030330023939313833e-04 2.58876106513241267120806199386607e-04
 	 7.83122553964867962328355588397244e-01 2.15728096960446341645578627321811e-01 1.14934907468569602606578428094508e-03 4.49090392903684168003641818955884e-04
 	 7.02480137925040937219023362558801e-01 2.95943145895255110833232947697979e-01 1.57671617970395194774368974321987e-03 6.83135055754288634741189234489411e-04
 	 6.14957151876489360731170563667547e-01 3.83002301034379877275881653986289e-01 2.04054708913076199294778234616388e-03 9.40773433374962435304933450197495e-04
 	 5.23534116025168305696979587082751e-01 4.73940837535576642292056703809067e-01 2.52504643925505201096370910818223e-03 1.19463713411688092491669266337340e-03
 	 4.31324343595625214753397358435905e-01 5.65661941278926772014301604940556e-01 3.01371512544801323230103662353940e-03 1.41366938961193103554969674462427e-03
 	 3.41467927547823069112098437472014e-01 6.55042160329174838473420550144510e-01 3.48991212300209241448101238347590e-03 1.56720953588257395569516283728717e-03
 	 2.57024807845170899511799689207692e-01 7.39037770974208862995169511123095e-01 3.93742118062023749303079966921359e-03 1.62917077702005668425611073502068e-03
 	 1.80870559657883900328556592285167e-01 8.14788437247896402126912107632961e-01 4.34100309421969754453130008187145e-03 1.58174589286067782296918426965249e-03
 	 1.15598437579815915832170958310599e-01 8.79714647593395127067594785330584e-01 4.68691482678895710023425635881722e-03 1.41813478968647109328127253746743e-03
 	 6.34309455838367730606819350214209e-02 9.31605676269880333961737051140517e-01 4.96337814628289297758101383806206e-03 1.14391766954236571464387228758142e-03
 	 2.61435136813938928668221706175245e-02 9.68695502214958925613075280125486e-01 5.16098410364718152010254925698973e-03 7.76898457624593859888184610440476e-04
 	 4.99729966377193690618696564342827e-03 9.89729651184054315393723300076090e-01 5.27304915217374770008973428048193e-03 3.45903615556999305402641198270430e-04
 	 9.87353020626041910645653842948377e-01 1.22965001039606249694235984293300e-02 3.50479269997464384922558622292854e-04 1.66524232809719141567596223385550e-05
 	 9.58024417690475527109583708806895e-01 4.08123344690280165369955511778244e-02 1.16324784049645635342074001528090e-03 9.75630051573684296557092965329616e-05
 	 9.13108376537141497308880389027763e-01 8.44836403500793670096058463059308e-02 2.40798311277913568151376466630609e-03 2.82583212013566413035869917536047e-04
 	 8.54138147775210576639892678940669e-01 1.41819657327762166376672325895925e-01 4.04219489702725698343499516340671e-03 5.93535548643136308573364789964444e-04
 	 7.83122553964868073350658050912898e-01 2.10867232313915270447424177291396e-01 6.01021372121665620191777179570636e-03 1.02964741061885517794949329584142e-03
 	 7.02480137925040937219023362558801e-01 2.89274846329579227166561850026483e-01 8.24501574537983561441478741471656e-03 1.56625092047165065736735733992191e-03
 	 6.14957151876489360731170563667547e-01 3.74372352636979377482617792338715e-01 1.06704954865312617862116439937381e-02 2.15694867884044967631940181718164e-03
 	 5.23534116025168305696979587082751e-01 4.63261828661983343646824096140335e-01 1.32040553128483506561963167769136e-02 2.73899208535593107968764137183371e-03
 	 4.31324343595625214753397358435905e-01 5.52916238836861473338046835124260e-01 1.57594175675133119085558064398356e-02 3.24117605160446822093467389436228e-03
 	 3.41467927547823069112098437472014e-01 6.40282509991577875041457446059212e-01 1.82495624605990558464441164687742e-02 3.59320365346749333312903473824917e-03
 	 2.57024807845170899511799689207692e-01 7.22385500713658146310081065166742e-01 2.05896914411709541781192456255667e-02 3.73526465611651340911758545360044e-03
 	 1.80870559657883900328556592285167e-01 7.96429325176617353143626587552717e-01 2.27001151654987465278168201621156e-02 3.62653173743197497144730157003778e-03
 	 1.15598437579815915832170958310599e-01 8.59892594324616288403717589972075e-01 2.45089680955677957641114517173264e-02 3.25141405200879548761938586665110e-03
 	 6.34309455838367730606819350214209e-02 9.10614395300493151275134096067632e-01 2.59546591156700756641839689109474e-02 2.62270555108058212381849649830201e-03
 	 2.61435136813938928668221706175245e-02 9.46868499676510433360476781672332e-01 2.69879866420956737727010477101430e-02 1.78122600226388212718564574288393e-03
 	 4.99729966377193690618696564342827e-03 9.67428699482124732078602846740978e-01 2.75740008541033310152101876155939e-02 7.93066980968237236412909929583748e-04
 	 9.87353020626041910645653842948377e-01 1.17972996680057694296461789917885e-02 8.49679705952319924699978059834393e-04 2.54542990511806903558642695140080e-05
 	 9.58024417690475416087281246291241e-01 3.91554780475238256576275830411760e-02 2.82010426200075825509117066758336e-03 1.49131322673332707053756029935698e-04
 	 9.13108376537141497308880389027763e-01 8.10538619792217224224728511217108e-02 5.83776148363678026864675985052600e-03 4.31946598045921217098180866500456e-04
 	 8.54138147775210576639892678940669e-01 1.36062211374325059409784444142133e-01 9.79964085046436395032287691719830e-03 9.07257226035826521391702836893955e-04
 	 7.83122553964868073350658050912898e-01 2.02306665208662694865893172391225e-01 1.45707808264692317834487766958773e-02 1.57388223112933656189227349386783e-03
 	 7.02480137925040937219023362558801e-01 2.77531169008583822321867273785756e-01 1.99886930663752404591093636554433e-02 2.39411517748457959575691944564824e-03
 	 6.14957151876489471753473026183201e-01 3.59173975857750127360645819862839e-01 2.58688722657604008858811539539602e-02 3.29703465873283250650582765217678e-03
 	 5.23534116025168194674677124567097e-01 4.44454810008373280005855576746399e-01 3.20110739664585253194672986865044e-02 4.18672540705425626911262426688154e-03
 	 4.31324343595625214753397358435905e-01 5.30469524313191609365958356647752e-01 3.82061320911831758806442849163432e-02 4.95434586924876647212601099568019e-03
 	 3.41467927547823069112098437472014e-01 6.14288991069952827750455526256701e-01 4.42430813822241031374460362712853e-02 5.49244267959890768854291920320065e-03
 	 2.57024807845170899511799689207692e-01 6.93058850542072168998686265695142e-01 4.99163416127569314895140450971667e-02 5.70959205083010085807204703201023e-03
 	 1.80870559657883900328556592285167e-01 7.64096721348366925141704086854588e-01 5.50327189937491745297393208602443e-02 5.54338679756425766614880146221367e-03
 	 1.15598437579815915832170958310599e-01 8.24983575145822545238161183078773e-01 5.94179872743615389296678586106282e-02 4.96999531074931045343534563585308e-03
 	 6.34309455838367730606819350214209e-02 8.73646225554830624382418591267196e-01 6.29228288613326025568994737113826e-02 4.00897396697091554229608334480872e-03
 	 2.61435136813938928668221706175245e-02 9.08428523761885098330992605042411e-01 6.54279625567210088021852243400645e-02 2.72271840406387161115375761255564e-03
 	 4.99729966377193690618696564342827e-03 9.28154042103708332156486449093791e-01 6.68486582325197309373265852627810e-02 1.21225384201285651605828341814686e-03
 	 9.87353020626041910645653842948377e-01 1.11002816727104151872662640698763e-02 1.54669770124767416707989298174653e-03 3.33374602932448200489322365225320e-05
 	 9.58024417690475527109583708806895e-01 3.68420611147038251642626960347116e-02 5.13352119482064772615359515839373e-03 1.95317087227774266152205417945709e-04
 	 9.13108376537141497308880389027763e-01 7.62649694379124165610761565403664e-02 1.06266540249460861300434544318705e-02 5.65719862574260942168768995230721e-04
 	 8.54138147775210576639892678940669e-01 1.28023269203110690028779572458006e-01 1.78385830216787333313277486013249e-02 1.18823353524346512870291103780573e-03
 	 7.83122553964868073350658050912898e-01 1.90353812421422491363287576859875e-01 2.65236336137094352860543722272268e-02 2.06131138323701170247947977998138e-03
 	 7.02480137925040937219023362558801e-01 2.61133838729777800757858585711801e-01 3.63860233451812620231180517293978e-02 3.13556933963753461935830557649751e-03
 	 6.14957151876489471753473026183201e-01 3.37952956500788159743819960567635e-01 4.70898916227223685027070132491644e-02 4.31812173652683806840402169768822e-03
 	 5.23534116025168305696979587082751e-01 4.18195156580091542686261618655408e-01 5.82707273947401516167587942618411e-02 5.48334848018202942326881910162228e-03
 	 4.31324343595625159242246127178078e-01 4.99127877088207327904711974042584e-01 6.95477793161675683641931300371652e-02 6.48869993877993368053269662709681e-03
 	 3.41467927547823069112098437472014e-01 5.77995051512853907915712170506595e-01 8.05370209393230229721893920213915e-02 7.19344458772509624810975736863838e-03
 	 2.57024807845170899511799689207692e-01 6.52110963803496312962693082226906e-01 9.08642283513327875255072285654023e-02 7.47784481915818918101868106873553e-03
 	 1.80870559657883900328556592285167e-01 7.18951715294958604296482462814311e-01 1.00177725047157495374960944900522e-01 7.26016602862705837800882946453385e-03
 	 1.15598437579815915832170958310599e-01 7.76241200714221868395270576002076e-01 1.08160361705962215772558465687325e-01 6.50919599068797583713008592098959e-03
 	 6.34309455838367730606819350214209e-02 8.22028723425504925792495214409428e-01 1.14540330990658301146822850569151e-01 5.25054766473114897101792664102504e-03
 	 2.61435136813938928668221706175245e-02 8.54755984594397499876095025683753e-01 1.19100501724208607257082803698722e-01 3.56594053140724641381975601461818e-03
 	 4.99729966377193690618696564342827e-03 8.73316063247673524116976295772474e-01 1.21686637088554538976836738584097e-01 1.58768718172824785384023016376887e-03
 	 9.87353020626041910645653842948377e-01 1.02306237462885078748353606670207e-02 2.41635562766958147951079638460214e-03 4.00159793261540414066601556442038e-05
 	 9.58024417690475416087281246291241e-01 3.39556487317738062148286815045140e-02 8.01993357775077769789007220424537e-03 2.34445109369502802760740212129065e-04
 	 9.13108376537141497308880389027763e-01 7.02899467190691018547710200436995e-02 1.66016767437894008363485909285373e-02 6.79050957272634260822319340888953e-04
 	 8.54138147775210576639892678940669e-01 1.17993212839527877866530047867855e-01 2.78686393852615454935772731914767e-02 1.42627327224984076434188828841343e-03
 	 7.83122553964868073350658050912898e-01 1.75440433943478218958844649932871e-01 4.14370120916537076904972991542309e-02 2.47425547629650383063548702011758e-03
 	 7.02480137925040937219023362558801e-01 2.40675158544513656533325729469652e-01 5.68447035304454062476509079715470e-02 3.76372035442911791192077686218909e-03
 	 6.14957151876489471753473026183201e-01 3.11475838528081472311725974577712e-01 7.35670095954290559348009992390871e-02 5.18317438151362670784028097159535e-03
 	 5.23534116025168194674677124567097e-01 3.85431417475593396382294031354832e-01 9.10344664992384089430288440780714e-02 6.58183189394075454647925482731807e-03
 	 4.31324343595625214753397358435905e-01 4.60023417633359188450015153648565e-01 1.08652238771015596796587487915531e-01 7.78858618262675758692203942246124e-03
 	 3.41467927547823180134400899987668e-01 5.32711698098808916768120980123058e-01 1.25820374353367903097478119889274e-01 8.63451286853335331361591897803009e-03
 	 2.57024807845170899511799689207692e-01 6.01020956783893889330272486404283e-01 1.41954235370935211157927824388025e-01 8.97588721682724896555605198500416e-03
 	 1.80870559657883900328556592285167e-01 6.62625031310171253018381776200840e-01 1.56504409031944846653061631513992e-01 8.71460066695167387407217063355347e-03
 	 1.15598437579815915832170958310599e-01 7.15426139176098985217322479002178e-01 1.68975423244085098950506562687224e-01 7.81318822436015761323524486670067e-03
 	 6.34309455838367730606819350214209e-02 7.57626412191278908458968999184435e-01 1.78942642224884318480349065794144e-01 6.30239391227536884659832239208299e-03
 	 2.61435136813938928668221706175245e-02 7.87789637336150705415604988957057e-01 1.86066848982455401717572840425419e-01 4.28030813768982137945684485202946e-03
 	 4.99729966377193690618696564342827e-03 8.04895615995233071338077479595086e-01 1.90107084340994991755735554761486e-01 1.90574977462548375041484494119004e-03
 	 9.87353020626041910645653842948377e-01 9.21975405695789514137761244683134e-03 3.42722531700019421296854460479153e-03 4.52482973410085767226353203884770e-05
 	 9.58024417690475527109583708806895e-01 3.06005516296093335593120343673945e-02 1.13750306799151393311042568257108e-02 2.65100147429431990796916407404638e-04
 	 9.13108376537141497308880389027763e-01 6.33447224233610328703036884689936e-02 2.35469010394974698208159225032432e-02 7.67840751164286148232329676233121e-04
 	 8.54138147775210576639892678940669e-01 1.06334513881951073233089744007884e-01 3.95273383428383501270175770514470e-02 1.61276665469770714121666710383352e-03
 	 7.83122553964867962328355588397244e-01 1.58105477507336167342089083831524e-01 5.87719685277958703295553277712315e-02 2.79777852183939364227871493540079e-03
 	 7.02480137925041048241325825074455e-01 2.16894475295777211520942273637047e-01 8.06253867791817402377319012884982e-02 4.25584830293800325112796301141316e-03
 	 6.14957151876489582775775488698855e-01 2.80699466340500969341320569583331e-01 1.04343381783009447882903941717814e-01 5.86090405718848583144220398821744e-03
 	 5.23534116025168305696979587082751e-01 3.47347626408293252975312270791619e-01 1.29118257566538441327708142125630e-01 7.44244403362421050318609161422501e-03
 	 4.31324343595625214753397358435905e-01 4.14569324041407560876848492625868e-01 1.54106332362967224369754148938227e-01 8.80698834295998676802152971276882e-03
 	 3.41467927547823124623249668729841e-01 4.80075405130329369018937768487376e-01 1.78456667321847450846661331524956e-01 9.76352477808299992756424501294532e-03
 	 2.57024807845170899511799689207692e-01 5.41635147772421610135040737077361e-01 2.01340044382407490353159573714947e-01 1.01495357735979715996244010511873e-02
 	 1.80870559657883900328556592285167e-01 5.97152233545890087640373167232610e-01 2.21977206796226012031070240482222e-01 9.85408451389959728905498792528306e-03
 	 1.15598437579815915832170958310599e-01 6.44736158097446998560542397171957e-01 2.39665404322737085607286644517444e-01 8.83480724226707453405893488707079e-03
 	 6.34309455838368840829843975370750e-02 6.82766697386665288860285727423616e-01 2.53802357029497827056729875039309e-01 7.12646793868199242283356653615556e-03
 	 2.61435136813938928668221706175245e-02 7.09949548041421851785059971007286e-01 2.63906938277184255348117858375190e-01 4.83998289150311053474773359539540e-03
 	 4.99729966377193690618696564342827e-03 7.25365315452233483384247847425286e-01 2.69637384883994579709565186931286e-01 2.15493745028635724433896392326915e-03
 	 9.87353020626041910645653842948377e-01 8.10420683614836503960709990224132e-03 4.54277253780972431473905714938155e-03 4.88452567420252133372111924547454e-05
 	 9.58024417690475527109583708806895e-01 2.68980276669568349467986934087094e-02 1.50775546425676379436175977843959e-02 2.86173967297632535385087937385151e-04
 	 9.13108376537141497308880389027763e-01 5.56803065814868991534325459724641e-02 3.12113168813716035376870649997727e-02 8.28879335391431238191928265734987e-04
 	 8.54138147775210576639892678940669e-01 9.34685338672648080571292439344688e-02 5.23933183575246153029780771248625e-02 1.74097161535163164058914730958350e-03
 	 7.83122553964868073350658050912898e-01 1.38975452461281095972722710030212e-01 7.79019935738508306766192390568904e-02 3.02018458676268312240731361839607e-03
 	 7.02480137925040937219023362558801e-01 1.90651255831311372546110760595184e-01 1.06868606243647690234865876846015e-01 4.59416188515272740783279559195762e-03
 	 6.14957151876489471753473026183201e-01 2.46736140678624926714235243707662e-01 1.38306707444885601532291730109137e-01 6.32680963122772294787710123387114e-03
 	 5.23534116025168305696979587082751e-01 3.05320184363661317750171519946889e-01 1.71145699611170376552848892970360e-01 8.03407224079263730665001475017561e-03
 	 4.31324343595625159242246127178078e-01 3.64408370244786172786888300834107e-01 2.04267286159588723482016803245642e-01 9.50708937164872203151588792024995e-03
 	 3.41467927547823069112098437472014e-01 4.21988521178366937647297163493931e-01 2.36543551273809993240604399034055e-01 1.05396645292191414033933227756279e-02
 	 2.57024807845170955022950920465519e-01 4.76099822203265465869748140903539e-01 2.66875369951563634618452169888769e-01 1.09563610081844491767055771447303e-02
 	 1.80870559657883900328556592285167e-01 5.24899599645141434756112630566349e-01 2.94229840696974664915330777148483e-01 1.06374232031669173348387147370886e-02
 	 1.15598437579815915832170958310599e-01 5.66726091356215988525946158915758e-01 3.17675471063968095641882882773643e-01 9.53711970115912743839459153605276e-03
 	 6.34309455838368840829843975370750e-02 6.00155112844863669607775591430254e-01 3.36413941571299446309240011032671e-01 7.69297800324643572811300629155085e-03
 	 2.61435136813938928668221706175245e-02 6.24048965407669076199681512662210e-01 3.49807520910937030933496316720266e-01 5.22473155577105399793857998247404e-03
 	 4.99729966377193690618696564342827e-03 6.37599496892930162061929877381772e-01 3.57403203443297901031883156974800e-01 2.32624163134745104083989097887297e-03
 	 9.87353020626041910645653842948377e-01 6.92430031307133663637243259358911e-03 5.72267906088675271797372445803376e-03 5.06768381376365855436709473291756e-05
 	 9.58024417690475416087281246291241e-01 2.29818938683243809140144264802075e-02 1.89936884412002029987043272285518e-02 2.96904813020870857187549773925639e-04
 	 9.13108376537141497308880389027763e-01 4.75737073459657905383224374418205e-02 3.93179161168927121527971735304163e-02 8.59960346551384377002114067778393e-04
 	 8.54138147775210576639892678940669e-01 7.98602764471165876836167285546253e-02 6.60015757776728356764905925047060e-02 1.80625392593107450371625599672143e-03
 	 7.83122553964867962328355588397244e-01 1.18741758255053259096811757444812e-01 9.81356877800787785748326541579445e-02 3.13343435284830964387969842732673e-03
 	 7.02480137925040937219023362558801e-01 1.62893985448624212253321275056805e-01 1.34625876626334850527655362384394e-01 4.76643207060213451586871968856940e-03
 	 6.14957151876489471753473026183201e-01 2.10813367759378644805678959528450e-01 1.74229480364131883440848014288349e-01 6.56405000188097897256822577105595e-03
 	 5.23534116025168305696979587082751e-01 2.60868051731644401414200729050208e-01 2.15597832243187292888819683867041e-01 8.33533091417725489902235125327934e-03
 	 4.31324343595625214753397358435905e-01 3.11353478901460034578008162498008e-01 2.57322177502914750668594479066087e-01 9.86358269732602599422222056091414e-03
 	 3.41467927547823013600947206214187e-01 3.60550428732219374605705297653913e-01 2.97981643719957667304498727389728e-01 1.09348769767584740736365844782085e-02
 	 2.57024807845170844000648457949865e-01 4.06783564954279974745787740175729e-01 3.36191627200549125742412570616580e-01 1.13671985863791590032345624194932e-02
 	 1.80870559657883844817405361027340e-01 4.48478492175459708679596815272816e-01 3.70650948166656390991846592442016e-01 1.10363013693533639630883769200409e-02
 	 1.15598437579815971343322189568426e-01 4.84215387285026610530991320047178e-01 4.00186175135157362614535259126569e-01 9.89473909304027822442240136524561e-03
 	 6.34309455838368840829843975370750e-02 5.12777415456252549930127315747086e-01 4.23791638959910565986888286715839e-01 7.98144645089962807837924430032217e-03
 	 2.61435136813938928668221706175245e-02 5.33192517652699593533327515615383e-01 4.40663968665906513599850313767092e-01 5.42064660981929173633186991310140e-03
 	 4.99729966377193690618696564342827e-03 5.44770202095199662650770733307581e-01 4.50232498241028400443042301048990e-01 2.41347018080877119203253577950363e-03
 	 9.87353020626041910645653842948377e-01 5.72267906088674577907982055080538e-03 6.92430031307134357526633650081749e-03 5.06768381376364703471901207443295e-05
 	 9.58024417690475527109583708806895e-01 1.89936884412001232014244322954255e-02 2.29818938683243496889918588976798e-02 2.96904813020870206666246282622978e-04
 	 9.13108376537141497308880389027763e-01 3.93179161168926635805398461798177e-02 4.75737073459658391105797647924192e-02 8.59960346551382425438203593870412e-04
 	 8.54138147775210576639892678940669e-01 6.60015757776727662875515534324222e-02 7.98602764471166570725557676269091e-02 1.80625392593107060058843504890547e-03
 	 7.83122553964867962328355588397244e-01 9.81356877800785981635911525700067e-02 1.18741758255053439508053259032749e-01 3.13343435284830270498579452009835e-03
 	 7.02480137925040937219023362558801e-01 1.34625876626334628483050437353086e-01 1.62893985448624434297926200088114e-01 4.76643207060212410752786382772683e-03
 	 6.14957151876489471753473026183201e-01 1.74229480364131661396243089257041e-01 2.10813367759378866850283884559758e-01 6.56405000188096509478041795659919e-03
 	 5.23534116025168305696979587082751e-01 2.15597832243187070844214758835733e-01 2.60868051731644623458805654081516e-01 8.33533091417723581706411550840130e-03
 	 4.31324343595625214753397358435905e-01 2.57322177502914417601687091519125e-01 3.11353478901460367644915550044971e-01 9.86358269732600517754050883922901e-03
 	 3.41467927547823069112098437472014e-01 2.97981643719957167704137646069285e-01 3.60550428732219763183763916458702e-01 1.09348769767584497875079208029092e-02
 	 2.57024807845170899511799689207692e-01 3.36191627200548737164353951811790e-01 4.06783564954280363323846358980518e-01 1.13671985863791329823824227673867e-02
 	 1.80870559657883955839707823542994e-01 3.70650948166655946902636742379400e-01 4.48478492175460152768806665335433e-01 1.10363013693533396769597132447416e-02
 	 1.15598437579815915832170958310599e-01 4.00186175135156974036476640321780e-01 4.84215387285027110131352401367621e-01 9.89473909304025567301721366675338e-03
 	 6.34309455838367730606819350214209e-02 4.23791638959910121897678436653223e-01 5.12777415456253105041639628325356e-01 7.98144645089961073114448453225123e-03
 	 2.61435136813938928668221706175245e-02 4.40663968665905958488338001188822e-01 5.33192517652700148644839828193653e-01 5.42064660981927959326753807545174e-03
 	 4.99729966377193690618696564342827e-03 4.50232498241027956353832450986374e-01 5.44770202095200106739980583370198e-01 2.41347018080876598786210784908235e-03
 	 9.87353020626041910645653842948377e-01 4.54277253780972084529210519576736e-03 8.10420683614836850905405185585550e-03 4.88452567420251794558933022827318e-05
 	 9.58024417690475527109583708806895e-01 1.50775546425676865158749251349946e-02 2.68980276669567863745413660581107e-02 2.86173967297632318544653440284264e-04
 	 9.13108376537141497308880389027763e-01 3.12113168813715896598992571853159e-02 5.56803065814869130312203537869209e-02 8.28879335391430587670624774432326e-04
 	 8.54138147775210576639892678940669e-01 5.23933183575245875474024614959490e-02 9.34685338672648358127048595633823e-02 1.74097161535163033954654032697817e-03
 	 7.83122553964867962328355588397244e-01 7.79019935738508584321948546858039e-02 1.38975452461281179239449556916952e-01 3.02018458676268095400296864738721e-03
 	 7.02480137925041048241325825074455e-01 1.06868606243647579212563414330361e-01 1.90651255831311372546110760595184e-01 4.59416188515272393838584363834343e-03
 	 6.14957151876489471753473026183201e-01 1.38306707444885518265564883222396e-01 2.46736140678625009980962090594403e-01 6.32680963122771861106841129185341e-03
 	 5.23534116025168305696979587082751e-01 1.71145699611170376552848892970360e-01 3.05320184363661317750171519946889e-01 8.03407224079263210247958681975433e-03
 	 4.31324343595625270264548589693732e-01 2.04267286159588501437411878214334e-01 3.64408370244786172786888300834107e-01 9.50708937164871509262198401302157e-03
 	 3.41467927547823069112098437472014e-01 2.36543551273809882218301936518401e-01 4.21988521178367048669599626009585e-01 1.05396645292191344644994188683995e-02
 	 2.57024807845170955022950920465519e-01 2.66875369951563523596149707373115e-01 4.76099822203265576892050603419193e-01 1.09563610081844405030881972606949e-02
 	 1.80870559657883900328556592285167e-01 2.94229840696974553893028314632829e-01 5.24899599645141545778415093082003e-01 1.06374232031669086612213348530531e-02
 	 1.15598437579815915832170958310599e-01 3.17675471063967873597277957742335e-01 5.66726091356216210570551083947066e-01 9.53711970115912049950068762882438e-03
 	 6.34309455838367730606819350214209e-02 3.36413941571299335286937548517017e-01 6.00155112844863891652380516461562e-01 7.69297800324642965658084037272602e-03
 	 2.61435136813938928668221706175245e-02 3.49807520910936919911193854204612e-01 6.24048965407669187221983975177864e-01 5.22473155577105052849162802885985e-03
 	 4.99729966377193690618696564342827e-03 3.57403203443297678987278231943492e-01 6.37599496892930384106534802413080e-01 2.32624163134744930611641500206588e-03
 	 9.87353020626041910645653842948377e-01 3.42722531700019074352159265117734e-03 9.21975405695789861082456440044552e-03 4.52482973410083666584644013219929e-05
 	 9.58024417690475416087281246291241e-01 1.13750306799151844339146322226952e-02 3.06005516296093994788041214860641e-02 2.65100147429430743964418049074538e-04
 	 9.13108376537141497308880389027763e-01 2.35469010394974420652403068743297e-02 6.33447224233610606258793040979072e-02 7.67840751164282570365160474068489e-04
 	 8.54138147775210576639892678940669e-01 3.95273383428383223714419614225335e-02 1.06334513881951100988665359636798e-01 1.61276665469769976864189420240336e-03
 	 7.83122553964867962328355588397244e-01 5.87719685277957593072528652555775e-02 1.58105477507336278364391546347179e-01 2.79777852183938106553351410354935e-03
 	 7.02480137925040937219023362558801e-01 8.06253867791817402377319012884982e-02 2.16894475295777322543244736152701e-01 4.25584830293798416916972726653512e-03
 	 6.14957151876489360731170563667547e-01 1.04343381783009447882903941717814e-01 2.80699466340501191385925494614639e-01 5.86090405718845894322832634770748e-03
 	 5.23534116025168305696979587082751e-01 1.29118257566538385816556910867803e-01 3.47347626408293308486463502049446e-01 7.44244403362417580871657207808312e-03
 	 4.31324343595625214753397358435905e-01 1.54106332362967113347451686422573e-01 4.14569324041407671899150955141522e-01 8.80698834295994513465810626939856e-03
 	 3.41467927547823069112098437472014e-01 1.78456667321847395335510100267129e-01 4.80075405130329535552391462260857e-01 9.76352477808295482475386961596087e-03
 	 2.57024807845170899511799689207692e-01 2.01340044382407379330857111199293e-01 5.41635147772421721157343199593015e-01 1.01495357735979247620905496773958e-02
 	 1.80870559657883900328556592285167e-01 2.21977206796225901008767777966568e-01 5.97152233545890198662675629748264e-01 9.85408451389955218624461252829860e-03
 	 1.15598437579815915832170958310599e-01 2.39665404322736974584984182001790e-01 6.44736158097447109582844859687611e-01 8.83480724226703463541898742050762e-03
 	 6.34309455838367730606819350214209e-02 2.53802357029497716034427412523655e-01 6.82766697386665510904890652454924e-01 7.12646793868195946308752297682076e-03
 	 2.61435136813938928668221706175245e-02 2.63906938277184033303512933343882e-01 7.09949548041422073829664896038594e-01 4.83998289150308798334254589690318e-03
 	 4.99729966377193690618696564342827e-03 2.69637384883994357664960261899978e-01 7.25365315452233705428852772456594e-01 2.15493745028634726967897705662836e-03
 	 9.87353020626041910645653842948377e-01 2.41635562766958321423427236140924e-03 1.02306237462885061401118846902136e-02 4.00159793261541091692959359882309e-05
 	 9.58024417690475416087281246291241e-01 8.01993357775072912563274485364673e-03 3.39556487317738547870860088551126e-02 2.34445109369503209336554894193227e-04
 	 9.13108376537141497308880389027763e-01 1.66016767437894285919242065574508e-02 7.02899467190690740991954044147860e-02 6.79050957272635345024491826393387e-04
 	 8.54138147775210576639892678940669e-01 2.78686393852615593713650810059335e-02 1.17993212839527863988742240053398e-01 1.42627327224984293274623325942230e-03
 	 7.83122553964868073350658050912898e-01 4.14370120916537909572241460409714e-02 1.75440433943478135692117803046131e-01 2.47425547629650773376330796793354e-03
 	 7.02480137925041048241325825074455e-01 5.68447035304453784920752923426335e-02 2.40675158544513573266598882582912e-01 3.76372035442912441713381177521569e-03
 	 6.14957151876489471753473026183201e-01 7.35670095954291669571034617547411e-02 3.11475838528081361289423512062058e-01 5.18317438151363538145766085563082e-03
 	 5.23534116025168305696979587082751e-01 9.10344664992384644541800753358984e-02 3.85431417475593229848840337581350e-01 6.58183189394076582218184867656419e-03
 	 4.31324343595625214753397358435905e-01 1.08652238771015707818889950431185e-01 4.60023417633359077427712691132911e-01 7.78858618262677059734810924851445e-03
 	 3.41467927547823069112098437472014e-01 1.25820374353368125142083044920582e-01 5.32711698098808805745818517607404e-01 8.63451286853336719140372679248685e-03
 	 2.57024807845170899511799689207692e-01 1.41954235370935322180230286903679e-01 6.01020956783893778307970023888629e-01 8.97588721682726457806733577626801e-03
 	 1.80870559657883900328556592285167e-01 1.56504409031944957675364094029646e-01 6.62625031310171141996079313685186e-01 8.71460066695168775185997844801022e-03
 	 1.15598437579815915832170958310599e-01 1.68975423244085209972809025202878e-01 7.15426139176098874195020016486524e-01 7.81318822436017149102305268115742e-03
 	 6.34309455838367730606819350214209e-02 1.78942642224884540524953990825452e-01 7.57626412191278686414364074153127e-01 6.30239391227537925493917825292556e-03
 	 2.61435136813938928668221706175245e-02 1.86066848982455512739875302941073e-01 7.87789637336150594393302526441403e-01 4.28030813768982831835074875925784e-03
 	 4.99729966377193690618696564342827e-03 1.90107084340995102778038017277140e-01 8.04895615995232960315775017079432e-01 1.90574977462548700302136239770334e-03
 	 9.87353020626041910645653842948377e-01 1.54669770124767590180336895855362e-03 1.11002816727104134525427880930692e-02 3.33374602932448132726686584881293e-05
 	 9.58024417690475527109583708806895e-01 5.13352119482071017619873032344913e-03 3.68420611147037627142175608696562e-02 1.95317087227774211942096793670487e-04
 	 9.13108376537141497308880389027763e-01 1.06266540249460861300434544318705e-02 7.62649694379124165610761565403664e-02 5.65719862574260833748551746680278e-04
 	 8.54138147775210576639892678940669e-01 1.78385830216787333313277486013249e-02 1.28023269203110690028779572458006e-01 1.18823353524346491186247654070485e-03
 	 7.83122553964868073350658050912898e-01 2.65236336137094907972056034850539e-02 1.90353812421422435852136345602048e-01 2.06131138323701126879861078577960e-03
 	 7.02480137925041048241325825074455e-01 3.63860233451812620231180517293978e-02 2.61133838729777689735556123196147e-01 3.13556933963753375199656758809397e-03
 	 6.14957151876489471753473026183201e-01 4.70898916227223685027070132491644e-02 3.37952956500788159743819960567635e-01 4.31812173652683633368054572088113e-03
 	 5.23534116025168305696979587082751e-01 5.82707273947402071279100255196681e-02 4.18195156580091487175110387397581e-01 5.48334848018202855590708111321874e-03
 	 4.31324343595625214753397358435905e-01 6.95477793161675128530418987793382e-02 4.99127877088207272393560742784757e-01 6.48869993877993194580922065028972e-03
 	 3.41467927547823069112098437472014e-01 8.05370209393231339944918545370456e-02 5.77995051512853796893409707990941e-01 7.19344458772509451338628139183129e-03
 	 2.57024807845170899511799689207692e-01 9.08642283513327875255072285654023e-02 6.52110963803496312962693082226906e-01 7.47784481915818831365694308033198e-03
 	 1.80870559657883900328556592285167e-01 1.00177725047157495374960944900522e-01 7.18951715294958604296482462814311e-01 7.26016602862705664328535348772675e-03
 	 1.15598437579815915832170958310599e-01 1.08160361705962326794860928202979e-01 7.76241200714221757372968113486422e-01 6.50919599068797410240660994418249e-03
 	 6.34309455838367730606819350214209e-02 1.14540330990658412169125313084805e-01 8.22028723425504814770192751893774e-01 5.25054766473114723629445066421795e-03
 	 2.61435136813938928668221706175245e-02 1.19100501724208607257082803698722e-01 8.54755984594397499876095025683753e-01 3.56594053140724554645801802621463e-03
 	 4.99729966377193690618696564342827e-03 1.21686637088554649999139201099752e-01 8.73316063247673413094673833256820e-01 1.58768718172824742015936116956709e-03
 	 9.87353020626041910645653842948377e-01 8.49679705952321659423454036641488e-04 1.17972996680057676949227030149814e-02 2.54542990511808529861901423396731e-05
 	 9.58024417690475416087281246291241e-01 2.82010426200070968283384331698471e-03 3.91554780475238742298849103917746e-02 1.49131322673333655730656954752078e-04
 	 9.13108376537141497308880389027763e-01 5.83776148363679414643456766498275e-03 8.10538619792217085446850433072541e-02 4.31946598045923981813720704536763e-04
 	 8.54138147775210576639892678940669e-01 9.79964085046439170589849254611181e-03 1.36062211374325031654208828513219e-01 9.07257226035832376083434258617899e-04
 	 7.83122553964867962328355588397244e-01 1.45707808264693428057512392115314e-02 2.02306665208662694865893172391225e-01 1.57388223112934653655226036050863e-03
 	 7.02480137925040937219023362558801e-01 1.99886930663752404591093636554433e-02 2.77531169008583822321867273785756e-01 2.39411517748459520826820323691209e-03
 	 6.14957151876489360731170563667547e-01 2.58688722657604563970323852117872e-02 3.59173975857750182871797051120666e-01 3.29703465873285375686840836806368e-03
 	 5.23534116025168305696979587082751e-01 3.20110739664585808306185299443314e-02 4.44454810008373113472401882972918e-01 4.18672540705428315732650190739150e-03
 	 4.31324343595625214753397358435905e-01 3.82061320911832869029467474319972e-02 5.30469524313191498343655894132098e-01 4.95434586924879856451031656661144e-03
 	 3.41467927547823069112098437472014e-01 4.42430813822242141597484987869393e-02 6.14288991069952716728153063741047e-01 5.49244267959894325037417672774609e-03
 	 2.57024807845170899511799689207692e-01 4.99163416127571535341189701284748e-02 6.93058850542071946954081340663834e-01 5.70959205083013728726504254495921e-03
 	 1.80870559657883900328556592285167e-01 5.50327189937493965743442458915524e-02 7.64096721348366703097099161823280e-01 5.54338679756429322798005898675910e-03
 	 1.15598437579815915832170958310599e-01 5.94179872743616499519703211262822e-02 8.24983575145822434215858720563119e-01 4.96999531074934167845791321838078e-03
 	 6.34309455838367730606819350214209e-02 6.29228288613327135792019362270366e-02 8.73646225554830513360116128751542e-01 4.00897396697094069578648500851159e-03
 	 2.61435136813938928668221706175245e-02 6.54279625567212308467901493713725e-02 9.08428523761884876286387680011103e-01 2.72271840406388939206938637482835e-03
 	 4.99729966377193690618696564342827e-03 6.68486582325199529819315102940891e-02 9.28154042103708110111881524062483e-01 1.21225384201286410547349081667790e-03
 	 9.87353020626041910645653842948377e-01 3.50479269997467854369510575907043e-04 1.22965001039606214999766464757158e-02 1.66524232809717549145655385300913e-05
 	 9.58024417690475527109583708806895e-01 1.16324784049651880346587518033630e-03 4.08123344690279540869504160127690e-02 9.75630051573675080838626838541927e-05
 	 9.13108376537141497308880389027763e-01 2.40798311277916343708938029521960e-03 8.44836403500793392540302306770172e-02 2.82583212013563756740547328050184e-04
 	 8.54138147775210576639892678940669e-01 4.04219489702728473901061079232022e-03 1.41819657327762138621096710267011e-01 5.93535548643130670722067865341387e-04
 	 7.83122553964867962328355588397244e-01 6.01021372121676722422023431136040e-03 2.10867232313915270447424177291396e-01 1.02964741061884542012994092630151e-03
 	 7.02480137925040937219023362558801e-01 8.24501574537989112556601867254358e-03 2.89274846329579171655410618768656e-01 1.56625092047163569537737703996072e-03
 	 6.14957151876489360731170563667547e-01 1.06704954865312617862116439937381e-02 3.74372352636979377482617792338715e-01 2.15694867884042929331855908969828e-03
 	 5.23534116025168305696979587082751e-01 1.32040553128485727008012418082217e-02 4.63261828661983121602219171109027e-01 2.73899208535590505883550171972729e-03
 	 4.31324343595625214753397358435905e-01 1.57594175675135339531607314711437e-02 5.52916238836861251293441910092952e-01 3.24117605160443742959297530603635e-03
 	 3.41467927547823069112098437472014e-01 1.82495624605992778910490415000822e-02 6.40282509991577652996852521027904e-01 3.59320365346745950602125319051083e-03
 	 2.57024807845170899511799689207692e-01 2.05896914411711762227241706568748e-02 7.22385500713657924265476140135434e-01 3.73526465611647784728632792905501e-03
 	 1.80870559657883900328556592285167e-01 2.27001151654989685724217451934237e-02 7.96429325176617131099021662521409e-01 3.62653173743194071065865102809767e-03
 	 1.15598437579815915832170958310599e-01 2.45089680955680178087163767486345e-02 8.59892594324616066359112664940767e-01 3.25141405200876469627768727832517e-03
 	 6.34309455838367730606819350214209e-02 2.59546591156702977087888939422555e-02 9.10614395300492929230529171036324e-01 2.62270555108055740400896382880092e-03
 	 2.61435136813938928668221706175245e-02 2.69879866420960068396084352571052e-02 9.46868499676510100293569394125370e-01 1.78122600226386521363175496901476e-03
 	 4.99729966377193690618696564342827e-03 2.75740008541035530598151126469020e-02 9.67428699482124510033997921709670e-01 7.93066980968229755417919779603153e-04
 	 9.87353020626041910645653842948377e-01 6.70230782719230533395204929547617e-05 1.25799562956861663010066365586681e-02 7.26311088332198491658185310337892e-06
 	 9.58024417690475416087281246291241e-01 2.22450962831001464170554982047179e-04 4.17531313466935824485481987267121e-02 4.25530214198785228024365934196283e-05
 	 9.13108376537141497308880389027763e-01 4.60484982881967375156762045662617e-04 8.64311384799765353159628489265742e-02 1.23251323125148711142007318386504e-04
 	 8.54138147775210576639892678940669e-01 7.72999626984460785905639568227343e-04 1.45088852597804962574201681491104e-01 2.58876106513240399759068210983060e-04
 	 7.83122553964868073350658050912898e-01 1.14934907468566827049016865203157e-03 2.15728096960446258378851780435070e-01 4.49090392903682595910491714974455e-04
 	 7.02480137925040937219023362558801e-01 1.57671617970395194774368974321987e-03 2.95943145895255110833232947697979e-01 6.83135055754286249496409766379657e-04
 	 6.14957151876489471753473026183201e-01 2.04054708913070648179655108833686e-03 3.83002301034379821764730422728462e-01 9.40773433374959182698415993684193e-04
 	 5.23534116025168305696979587082751e-01 2.52504643925516303326617162383627e-03 4.73940837535576531269754241293413e-01 1.19463713411687680494843721845655e-03
 	 4.31324343595625214753397358435905e-01 3.01371512544812425460349913919345e-03 5.65661941278926660991999142424902e-01 1.41366938961192604821970331130387e-03
 	 3.41467927547823069112098437472014e-01 3.48991212300209241448101238347590e-03 6.55042160329174838473420550144510e-01 1.56720953588256853468430040976500e-03
 	 2.57024807845170899511799689207692e-01 3.93742118062023749303079966921359e-03 7.39037770974208862995169511123095e-01 1.62917077702005104640481381039763e-03
 	 1.80870559657883900328556592285167e-01 4.34100309421980856683376259752549e-03 8.14788437247896291104609645117307e-01 1.58174589286067240195832184213032e-03
 	 1.15598437579815915832170958310599e-01 4.68691482678906812253671887447126e-03 8.79714647593395016045292322814930e-01 1.41813478968646632279171360124792e-03
 	 6.34309455838367730606819350214209e-02 4.96337814628300399988347635371611e-03 9.31605676269880222939434588624863e-01 1.14391766954236181151605133976545e-03
 	 2.61435136813938928668221706175245e-02 5.16098410364729254240501177264377e-03 9.68695502214958814590772817609832e-01 7.76898457624591149382753396679391e-04
 	 4.99729966377193690618696564342827e-03 5.27304915217385872239219679613598e-03 9.89729651184054204371420837560436e-01 3.45903615556998112780251464215553e-04
 	 ];
 
 	 case  31 

 	 % ALG. DEG.:   31
 	 % PTS CARD.:  256
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-15  

 	 xyw_bar=[
 	 9.87353020626041910645653842948377e-01 1.25799562956861680357301125354752e-02 6.70230782719213186160445161476673e-05 7.26311088332201032757027073238909e-06
 	 9.58024417690475416087281246291241e-01 4.17531313466935269373969674688851e-02 2.22450962831056975321786239874200e-04 4.25530214198786718802353101764879e-05
 	 9.13108376537141497308880389027763e-01 8.64311384799765491937506567410310e-02 4.60484982881953497368954231205862e-04 1.23251323125149117717822000450667e-04
 	 8.54138147775210576639892678940669e-01 1.45088852597804990329777297120017e-01 7.72999626984433030330023939313833e-04 2.58876106513241267120806199386607e-04
 	 7.83122553964867962328355588397244e-01 2.15728096960446341645578627321811e-01 1.14934907468569602606578428094508e-03 4.49090392903684168003641818955884e-04
 	 7.02480137925040937219023362558801e-01 2.95943145895255110833232947697979e-01 1.57671617970395194774368974321987e-03 6.83135055754288634741189234489411e-04
 	 6.14957151876489360731170563667547e-01 3.83002301034379877275881653986289e-01 2.04054708913076199294778234616388e-03 9.40773433374962435304933450197495e-04
 	 5.23534116025168305696979587082751e-01 4.73940837535576642292056703809067e-01 2.52504643925505201096370910818223e-03 1.19463713411688092491669266337340e-03
 	 4.31324343595625214753397358435905e-01 5.65661941278926772014301604940556e-01 3.01371512544801323230103662353940e-03 1.41366938961193103554969674462427e-03
 	 3.41467927547823069112098437472014e-01 6.55042160329174838473420550144510e-01 3.48991212300209241448101238347590e-03 1.56720953588257395569516283728717e-03
 	 2.57024807845170899511799689207692e-01 7.39037770974208862995169511123095e-01 3.93742118062023749303079966921359e-03 1.62917077702005668425611073502068e-03
 	 1.80870559657883900328556592285167e-01 8.14788437247896402126912107632961e-01 4.34100309421969754453130008187145e-03 1.58174589286067782296918426965249e-03
 	 1.15598437579815915832170958310599e-01 8.79714647593395127067594785330584e-01 4.68691482678895710023425635881722e-03 1.41813478968647109328127253746743e-03
 	 6.34309455838367730606819350214209e-02 9.31605676269880333961737051140517e-01 4.96337814628289297758101383806206e-03 1.14391766954236571464387228758142e-03
 	 2.61435136813938928668221706175245e-02 9.68695502214958925613075280125486e-01 5.16098410364718152010254925698973e-03 7.76898457624593859888184610440476e-04
 	 4.99729966377193690618696564342827e-03 9.89729651184054315393723300076090e-01 5.27304915217374770008973428048193e-03 3.45903615556999305402641198270430e-04
 	 9.87353020626041910645653842948377e-01 1.22965001039606249694235984293300e-02 3.50479269997464384922558622292854e-04 1.66524232809719141567596223385550e-05
 	 9.58024417690475527109583708806895e-01 4.08123344690280165369955511778244e-02 1.16324784049645635342074001528090e-03 9.75630051573684296557092965329616e-05
 	 9.13108376537141497308880389027763e-01 8.44836403500793670096058463059308e-02 2.40798311277913568151376466630609e-03 2.82583212013566413035869917536047e-04
 	 8.54138147775210576639892678940669e-01 1.41819657327762166376672325895925e-01 4.04219489702725698343499516340671e-03 5.93535548643136308573364789964444e-04
 	 7.83122553964868073350658050912898e-01 2.10867232313915270447424177291396e-01 6.01021372121665620191777179570636e-03 1.02964741061885517794949329584142e-03
 	 7.02480137925040937219023362558801e-01 2.89274846329579227166561850026483e-01 8.24501574537983561441478741471656e-03 1.56625092047165065736735733992191e-03
 	 6.14957151876489360731170563667547e-01 3.74372352636979377482617792338715e-01 1.06704954865312617862116439937381e-02 2.15694867884044967631940181718164e-03
 	 5.23534116025168305696979587082751e-01 4.63261828661983343646824096140335e-01 1.32040553128483506561963167769136e-02 2.73899208535593107968764137183371e-03
 	 4.31324343595625214753397358435905e-01 5.52916238836861473338046835124260e-01 1.57594175675133119085558064398356e-02 3.24117605160446822093467389436228e-03
 	 3.41467927547823069112098437472014e-01 6.40282509991577875041457446059212e-01 1.82495624605990558464441164687742e-02 3.59320365346749333312903473824917e-03
 	 2.57024807845170899511799689207692e-01 7.22385500713658146310081065166742e-01 2.05896914411709541781192456255667e-02 3.73526465611651340911758545360044e-03
 	 1.80870559657883900328556592285167e-01 7.96429325176617353143626587552717e-01 2.27001151654987465278168201621156e-02 3.62653173743197497144730157003778e-03
 	 1.15598437579815915832170958310599e-01 8.59892594324616288403717589972075e-01 2.45089680955677957641114517173264e-02 3.25141405200879548761938586665110e-03
 	 6.34309455838367730606819350214209e-02 9.10614395300493151275134096067632e-01 2.59546591156700756641839689109474e-02 2.62270555108058212381849649830201e-03
 	 2.61435136813938928668221706175245e-02 9.46868499676510433360476781672332e-01 2.69879866420956737727010477101430e-02 1.78122600226388212718564574288393e-03
 	 4.99729966377193690618696564342827e-03 9.67428699482124732078602846740978e-01 2.75740008541033310152101876155939e-02 7.93066980968237236412909929583748e-04
 	 9.87353020626041910645653842948377e-01 1.17972996680057694296461789917885e-02 8.49679705952319924699978059834393e-04 2.54542990511806903558642695140080e-05
 	 9.58024417690475416087281246291241e-01 3.91554780475238256576275830411760e-02 2.82010426200075825509117066758336e-03 1.49131322673332707053756029935698e-04
 	 9.13108376537141497308880389027763e-01 8.10538619792217224224728511217108e-02 5.83776148363678026864675985052600e-03 4.31946598045921217098180866500456e-04
 	 8.54138147775210576639892678940669e-01 1.36062211374325059409784444142133e-01 9.79964085046436395032287691719830e-03 9.07257226035826521391702836893955e-04
 	 7.83122553964868073350658050912898e-01 2.02306665208662694865893172391225e-01 1.45707808264692317834487766958773e-02 1.57388223112933656189227349386783e-03
 	 7.02480137925040937219023362558801e-01 2.77531169008583822321867273785756e-01 1.99886930663752404591093636554433e-02 2.39411517748457959575691944564824e-03
 	 6.14957151876489471753473026183201e-01 3.59173975857750127360645819862839e-01 2.58688722657604008858811539539602e-02 3.29703465873283250650582765217678e-03
 	 5.23534116025168194674677124567097e-01 4.44454810008373280005855576746399e-01 3.20110739664585253194672986865044e-02 4.18672540705425626911262426688154e-03
 	 4.31324343595625214753397358435905e-01 5.30469524313191609365958356647752e-01 3.82061320911831758806442849163432e-02 4.95434586924876647212601099568019e-03
 	 3.41467927547823069112098437472014e-01 6.14288991069952827750455526256701e-01 4.42430813822241031374460362712853e-02 5.49244267959890768854291920320065e-03
 	 2.57024807845170899511799689207692e-01 6.93058850542072168998686265695142e-01 4.99163416127569314895140450971667e-02 5.70959205083010085807204703201023e-03
 	 1.80870559657883900328556592285167e-01 7.64096721348366925141704086854588e-01 5.50327189937491745297393208602443e-02 5.54338679756425766614880146221367e-03
 	 1.15598437579815915832170958310599e-01 8.24983575145822545238161183078773e-01 5.94179872743615389296678586106282e-02 4.96999531074931045343534563585308e-03
 	 6.34309455838367730606819350214209e-02 8.73646225554830624382418591267196e-01 6.29228288613326025568994737113826e-02 4.00897396697091554229608334480872e-03
 	 2.61435136813938928668221706175245e-02 9.08428523761885098330992605042411e-01 6.54279625567210088021852243400645e-02 2.72271840406387161115375761255564e-03
 	 4.99729966377193690618696564342827e-03 9.28154042103708332156486449093791e-01 6.68486582325197309373265852627810e-02 1.21225384201285651605828341814686e-03
 	 9.87353020626041910645653842948377e-01 1.11002816727104151872662640698763e-02 1.54669770124767416707989298174653e-03 3.33374602932448200489322365225320e-05
 	 9.58024417690475527109583708806895e-01 3.68420611147038251642626960347116e-02 5.13352119482064772615359515839373e-03 1.95317087227774266152205417945709e-04
 	 9.13108376537141497308880389027763e-01 7.62649694379124165610761565403664e-02 1.06266540249460861300434544318705e-02 5.65719862574260942168768995230721e-04
 	 8.54138147775210576639892678940669e-01 1.28023269203110690028779572458006e-01 1.78385830216787333313277486013249e-02 1.18823353524346512870291103780573e-03
 	 7.83122553964868073350658050912898e-01 1.90353812421422491363287576859875e-01 2.65236336137094352860543722272268e-02 2.06131138323701170247947977998138e-03
 	 7.02480137925040937219023362558801e-01 2.61133838729777800757858585711801e-01 3.63860233451812620231180517293978e-02 3.13556933963753461935830557649751e-03
 	 6.14957151876489471753473026183201e-01 3.37952956500788159743819960567635e-01 4.70898916227223685027070132491644e-02 4.31812173652683806840402169768822e-03
 	 5.23534116025168305696979587082751e-01 4.18195156580091542686261618655408e-01 5.82707273947401516167587942618411e-02 5.48334848018202942326881910162228e-03
 	 4.31324343595625159242246127178078e-01 4.99127877088207327904711974042584e-01 6.95477793161675683641931300371652e-02 6.48869993877993368053269662709681e-03
 	 3.41467927547823069112098437472014e-01 5.77995051512853907915712170506595e-01 8.05370209393230229721893920213915e-02 7.19344458772509624810975736863838e-03
 	 2.57024807845170899511799689207692e-01 6.52110963803496312962693082226906e-01 9.08642283513327875255072285654023e-02 7.47784481915818918101868106873553e-03
 	 1.80870559657883900328556592285167e-01 7.18951715294958604296482462814311e-01 1.00177725047157495374960944900522e-01 7.26016602862705837800882946453385e-03
 	 1.15598437579815915832170958310599e-01 7.76241200714221868395270576002076e-01 1.08160361705962215772558465687325e-01 6.50919599068797583713008592098959e-03
 	 6.34309455838367730606819350214209e-02 8.22028723425504925792495214409428e-01 1.14540330990658301146822850569151e-01 5.25054766473114897101792664102504e-03
 	 2.61435136813938928668221706175245e-02 8.54755984594397499876095025683753e-01 1.19100501724208607257082803698722e-01 3.56594053140724641381975601461818e-03
 	 4.99729966377193690618696564342827e-03 8.73316063247673524116976295772474e-01 1.21686637088554538976836738584097e-01 1.58768718172824785384023016376887e-03
 	 9.87353020626041910645653842948377e-01 1.02306237462885078748353606670207e-02 2.41635562766958147951079638460214e-03 4.00159793261540414066601556442038e-05
 	 9.58024417690475416087281246291241e-01 3.39556487317738062148286815045140e-02 8.01993357775077769789007220424537e-03 2.34445109369502802760740212129065e-04
 	 9.13108376537141497308880389027763e-01 7.02899467190691018547710200436995e-02 1.66016767437894008363485909285373e-02 6.79050957272634260822319340888953e-04
 	 8.54138147775210576639892678940669e-01 1.17993212839527877866530047867855e-01 2.78686393852615454935772731914767e-02 1.42627327224984076434188828841343e-03
 	 7.83122553964868073350658050912898e-01 1.75440433943478218958844649932871e-01 4.14370120916537076904972991542309e-02 2.47425547629650383063548702011758e-03
 	 7.02480137925040937219023362558801e-01 2.40675158544513656533325729469652e-01 5.68447035304454062476509079715470e-02 3.76372035442911791192077686218909e-03
 	 6.14957151876489471753473026183201e-01 3.11475838528081472311725974577712e-01 7.35670095954290559348009992390871e-02 5.18317438151362670784028097159535e-03
 	 5.23534116025168194674677124567097e-01 3.85431417475593396382294031354832e-01 9.10344664992384089430288440780714e-02 6.58183189394075454647925482731807e-03
 	 4.31324343595625214753397358435905e-01 4.60023417633359188450015153648565e-01 1.08652238771015596796587487915531e-01 7.78858618262675758692203942246124e-03
 	 3.41467927547823180134400899987668e-01 5.32711698098808916768120980123058e-01 1.25820374353367903097478119889274e-01 8.63451286853335331361591897803009e-03
 	 2.57024807845170899511799689207692e-01 6.01020956783893889330272486404283e-01 1.41954235370935211157927824388025e-01 8.97588721682724896555605198500416e-03
 	 1.80870559657883900328556592285167e-01 6.62625031310171253018381776200840e-01 1.56504409031944846653061631513992e-01 8.71460066695167387407217063355347e-03
 	 1.15598437579815915832170958310599e-01 7.15426139176098985217322479002178e-01 1.68975423244085098950506562687224e-01 7.81318822436015761323524486670067e-03
 	 6.34309455838367730606819350214209e-02 7.57626412191278908458968999184435e-01 1.78942642224884318480349065794144e-01 6.30239391227536884659832239208299e-03
 	 2.61435136813938928668221706175245e-02 7.87789637336150705415604988957057e-01 1.86066848982455401717572840425419e-01 4.28030813768982137945684485202946e-03
 	 4.99729966377193690618696564342827e-03 8.04895615995233071338077479595086e-01 1.90107084340994991755735554761486e-01 1.90574977462548375041484494119004e-03
 	 9.87353020626041910645653842948377e-01 9.21975405695789514137761244683134e-03 3.42722531700019421296854460479153e-03 4.52482973410085767226353203884770e-05
 	 9.58024417690475527109583708806895e-01 3.06005516296093335593120343673945e-02 1.13750306799151393311042568257108e-02 2.65100147429431990796916407404638e-04
 	 9.13108376537141497308880389027763e-01 6.33447224233610328703036884689936e-02 2.35469010394974698208159225032432e-02 7.67840751164286148232329676233121e-04
 	 8.54138147775210576639892678940669e-01 1.06334513881951073233089744007884e-01 3.95273383428383501270175770514470e-02 1.61276665469770714121666710383352e-03
 	 7.83122553964867962328355588397244e-01 1.58105477507336167342089083831524e-01 5.87719685277958703295553277712315e-02 2.79777852183939364227871493540079e-03
 	 7.02480137925041048241325825074455e-01 2.16894475295777211520942273637047e-01 8.06253867791817402377319012884982e-02 4.25584830293800325112796301141316e-03
 	 6.14957151876489582775775488698855e-01 2.80699466340500969341320569583331e-01 1.04343381783009447882903941717814e-01 5.86090405718848583144220398821744e-03
 	 5.23534116025168305696979587082751e-01 3.47347626408293252975312270791619e-01 1.29118257566538441327708142125630e-01 7.44244403362421050318609161422501e-03
 	 4.31324343595625214753397358435905e-01 4.14569324041407560876848492625868e-01 1.54106332362967224369754148938227e-01 8.80698834295998676802152971276882e-03
 	 3.41467927547823124623249668729841e-01 4.80075405130329369018937768487376e-01 1.78456667321847450846661331524956e-01 9.76352477808299992756424501294532e-03
 	 2.57024807845170899511799689207692e-01 5.41635147772421610135040737077361e-01 2.01340044382407490353159573714947e-01 1.01495357735979715996244010511873e-02
 	 1.80870559657883900328556592285167e-01 5.97152233545890087640373167232610e-01 2.21977206796226012031070240482222e-01 9.85408451389959728905498792528306e-03
 	 1.15598437579815915832170958310599e-01 6.44736158097446998560542397171957e-01 2.39665404322737085607286644517444e-01 8.83480724226707453405893488707079e-03
 	 6.34309455838368840829843975370750e-02 6.82766697386665288860285727423616e-01 2.53802357029497827056729875039309e-01 7.12646793868199242283356653615556e-03
 	 2.61435136813938928668221706175245e-02 7.09949548041421851785059971007286e-01 2.63906938277184255348117858375190e-01 4.83998289150311053474773359539540e-03
 	 4.99729966377193690618696564342827e-03 7.25365315452233483384247847425286e-01 2.69637384883994579709565186931286e-01 2.15493745028635724433896392326915e-03
 	 9.87353020626041910645653842948377e-01 8.10420683614836503960709990224132e-03 4.54277253780972431473905714938155e-03 4.88452567420252133372111924547454e-05
 	 9.58024417690475527109583708806895e-01 2.68980276669568349467986934087094e-02 1.50775546425676379436175977843959e-02 2.86173967297632535385087937385151e-04
 	 9.13108376537141497308880389027763e-01 5.56803065814868991534325459724641e-02 3.12113168813716035376870649997727e-02 8.28879335391431238191928265734987e-04
 	 8.54138147775210576639892678940669e-01 9.34685338672648080571292439344688e-02 5.23933183575246153029780771248625e-02 1.74097161535163164058914730958350e-03
 	 7.83122553964868073350658050912898e-01 1.38975452461281095972722710030212e-01 7.79019935738508306766192390568904e-02 3.02018458676268312240731361839607e-03
 	 7.02480137925040937219023362558801e-01 1.90651255831311372546110760595184e-01 1.06868606243647690234865876846015e-01 4.59416188515272740783279559195762e-03
 	 6.14957151876489471753473026183201e-01 2.46736140678624926714235243707662e-01 1.38306707444885601532291730109137e-01 6.32680963122772294787710123387114e-03
 	 5.23534116025168305696979587082751e-01 3.05320184363661317750171519946889e-01 1.71145699611170376552848892970360e-01 8.03407224079263730665001475017561e-03
 	 4.31324343595625159242246127178078e-01 3.64408370244786172786888300834107e-01 2.04267286159588723482016803245642e-01 9.50708937164872203151588792024995e-03
 	 3.41467927547823069112098437472014e-01 4.21988521178366937647297163493931e-01 2.36543551273809993240604399034055e-01 1.05396645292191414033933227756279e-02
 	 2.57024807845170955022950920465519e-01 4.76099822203265465869748140903539e-01 2.66875369951563634618452169888769e-01 1.09563610081844491767055771447303e-02
 	 1.80870559657883900328556592285167e-01 5.24899599645141434756112630566349e-01 2.94229840696974664915330777148483e-01 1.06374232031669173348387147370886e-02
 	 1.15598437579815915832170958310599e-01 5.66726091356215988525946158915758e-01 3.17675471063968095641882882773643e-01 9.53711970115912743839459153605276e-03
 	 6.34309455838368840829843975370750e-02 6.00155112844863669607775591430254e-01 3.36413941571299446309240011032671e-01 7.69297800324643572811300629155085e-03
 	 2.61435136813938928668221706175245e-02 6.24048965407669076199681512662210e-01 3.49807520910937030933496316720266e-01 5.22473155577105399793857998247404e-03
 	 4.99729966377193690618696564342827e-03 6.37599496892930162061929877381772e-01 3.57403203443297901031883156974800e-01 2.32624163134745104083989097887297e-03
 	 9.87353020626041910645653842948377e-01 6.92430031307133663637243259358911e-03 5.72267906088675271797372445803376e-03 5.06768381376365855436709473291756e-05
 	 9.58024417690475416087281246291241e-01 2.29818938683243809140144264802075e-02 1.89936884412002029987043272285518e-02 2.96904813020870857187549773925639e-04
 	 9.13108376537141497308880389027763e-01 4.75737073459657905383224374418205e-02 3.93179161168927121527971735304163e-02 8.59960346551384377002114067778393e-04
 	 8.54138147775210576639892678940669e-01 7.98602764471165876836167285546253e-02 6.60015757776728356764905925047060e-02 1.80625392593107450371625599672143e-03
 	 7.83122553964867962328355588397244e-01 1.18741758255053259096811757444812e-01 9.81356877800787785748326541579445e-02 3.13343435284830964387969842732673e-03
 	 7.02480137925040937219023362558801e-01 1.62893985448624212253321275056805e-01 1.34625876626334850527655362384394e-01 4.76643207060213451586871968856940e-03
 	 6.14957151876489471753473026183201e-01 2.10813367759378644805678959528450e-01 1.74229480364131883440848014288349e-01 6.56405000188097897256822577105595e-03
 	 5.23534116025168305696979587082751e-01 2.60868051731644401414200729050208e-01 2.15597832243187292888819683867041e-01 8.33533091417725489902235125327934e-03
 	 4.31324343595625214753397358435905e-01 3.11353478901460034578008162498008e-01 2.57322177502914750668594479066087e-01 9.86358269732602599422222056091414e-03
 	 3.41467927547823013600947206214187e-01 3.60550428732219374605705297653913e-01 2.97981643719957667304498727389728e-01 1.09348769767584740736365844782085e-02
 	 2.57024807845170844000648457949865e-01 4.06783564954279974745787740175729e-01 3.36191627200549125742412570616580e-01 1.13671985863791590032345624194932e-02
 	 1.80870559657883844817405361027340e-01 4.48478492175459708679596815272816e-01 3.70650948166656390991846592442016e-01 1.10363013693533639630883769200409e-02
 	 1.15598437579815971343322189568426e-01 4.84215387285026610530991320047178e-01 4.00186175135157362614535259126569e-01 9.89473909304027822442240136524561e-03
 	 6.34309455838368840829843975370750e-02 5.12777415456252549930127315747086e-01 4.23791638959910565986888286715839e-01 7.98144645089962807837924430032217e-03
 	 2.61435136813938928668221706175245e-02 5.33192517652699593533327515615383e-01 4.40663968665906513599850313767092e-01 5.42064660981929173633186991310140e-03
 	 4.99729966377193690618696564342827e-03 5.44770202095199662650770733307581e-01 4.50232498241028400443042301048990e-01 2.41347018080877119203253577950363e-03
 	 9.87353020626041910645653842948377e-01 5.72267906088674577907982055080538e-03 6.92430031307134357526633650081749e-03 5.06768381376364703471901207443295e-05
 	 9.58024417690475527109583708806895e-01 1.89936884412001232014244322954255e-02 2.29818938683243496889918588976798e-02 2.96904813020870206666246282622978e-04
 	 9.13108376537141497308880389027763e-01 3.93179161168926635805398461798177e-02 4.75737073459658391105797647924192e-02 8.59960346551382425438203593870412e-04
 	 8.54138147775210576639892678940669e-01 6.60015757776727662875515534324222e-02 7.98602764471166570725557676269091e-02 1.80625392593107060058843504890547e-03
 	 7.83122553964867962328355588397244e-01 9.81356877800785981635911525700067e-02 1.18741758255053439508053259032749e-01 3.13343435284830270498579452009835e-03
 	 7.02480137925040937219023362558801e-01 1.34625876626334628483050437353086e-01 1.62893985448624434297926200088114e-01 4.76643207060212410752786382772683e-03
 	 6.14957151876489471753473026183201e-01 1.74229480364131661396243089257041e-01 2.10813367759378866850283884559758e-01 6.56405000188096509478041795659919e-03
 	 5.23534116025168305696979587082751e-01 2.15597832243187070844214758835733e-01 2.60868051731644623458805654081516e-01 8.33533091417723581706411550840130e-03
 	 4.31324343595625214753397358435905e-01 2.57322177502914417601687091519125e-01 3.11353478901460367644915550044971e-01 9.86358269732600517754050883922901e-03
 	 3.41467927547823069112098437472014e-01 2.97981643719957167704137646069285e-01 3.60550428732219763183763916458702e-01 1.09348769767584497875079208029092e-02
 	 2.57024807845170899511799689207692e-01 3.36191627200548737164353951811790e-01 4.06783564954280363323846358980518e-01 1.13671985863791329823824227673867e-02
 	 1.80870559657883955839707823542994e-01 3.70650948166655946902636742379400e-01 4.48478492175460152768806665335433e-01 1.10363013693533396769597132447416e-02
 	 1.15598437579815915832170958310599e-01 4.00186175135156974036476640321780e-01 4.84215387285027110131352401367621e-01 9.89473909304025567301721366675338e-03
 	 6.34309455838367730606819350214209e-02 4.23791638959910121897678436653223e-01 5.12777415456253105041639628325356e-01 7.98144645089961073114448453225123e-03
 	 2.61435136813938928668221706175245e-02 4.40663968665905958488338001188822e-01 5.33192517652700148644839828193653e-01 5.42064660981927959326753807545174e-03
 	 4.99729966377193690618696564342827e-03 4.50232498241027956353832450986374e-01 5.44770202095200106739980583370198e-01 2.41347018080876598786210784908235e-03
 	 9.87353020626041910645653842948377e-01 4.54277253780972084529210519576736e-03 8.10420683614836850905405185585550e-03 4.88452567420251794558933022827318e-05
 	 9.58024417690475527109583708806895e-01 1.50775546425676865158749251349946e-02 2.68980276669567863745413660581107e-02 2.86173967297632318544653440284264e-04
 	 9.13108376537141497308880389027763e-01 3.12113168813715896598992571853159e-02 5.56803065814869130312203537869209e-02 8.28879335391430587670624774432326e-04
 	 8.54138147775210576639892678940669e-01 5.23933183575245875474024614959490e-02 9.34685338672648358127048595633823e-02 1.74097161535163033954654032697817e-03
 	 7.83122553964867962328355588397244e-01 7.79019935738508584321948546858039e-02 1.38975452461281179239449556916952e-01 3.02018458676268095400296864738721e-03
 	 7.02480137925041048241325825074455e-01 1.06868606243647579212563414330361e-01 1.90651255831311372546110760595184e-01 4.59416188515272393838584363834343e-03
 	 6.14957151876489471753473026183201e-01 1.38306707444885518265564883222396e-01 2.46736140678625009980962090594403e-01 6.32680963122771861106841129185341e-03
 	 5.23534116025168305696979587082751e-01 1.71145699611170376552848892970360e-01 3.05320184363661317750171519946889e-01 8.03407224079263210247958681975433e-03
 	 4.31324343595625270264548589693732e-01 2.04267286159588501437411878214334e-01 3.64408370244786172786888300834107e-01 9.50708937164871509262198401302157e-03
 	 3.41467927547823069112098437472014e-01 2.36543551273809882218301936518401e-01 4.21988521178367048669599626009585e-01 1.05396645292191344644994188683995e-02
 	 2.57024807845170955022950920465519e-01 2.66875369951563523596149707373115e-01 4.76099822203265576892050603419193e-01 1.09563610081844405030881972606949e-02
 	 1.80870559657883900328556592285167e-01 2.94229840696974553893028314632829e-01 5.24899599645141545778415093082003e-01 1.06374232031669086612213348530531e-02
 	 1.15598437579815915832170958310599e-01 3.17675471063967873597277957742335e-01 5.66726091356216210570551083947066e-01 9.53711970115912049950068762882438e-03
 	 6.34309455838367730606819350214209e-02 3.36413941571299335286937548517017e-01 6.00155112844863891652380516461562e-01 7.69297800324642965658084037272602e-03
 	 2.61435136813938928668221706175245e-02 3.49807520910936919911193854204612e-01 6.24048965407669187221983975177864e-01 5.22473155577105052849162802885985e-03
 	 4.99729966377193690618696564342827e-03 3.57403203443297678987278231943492e-01 6.37599496892930384106534802413080e-01 2.32624163134744930611641500206588e-03
 	 9.87353020626041910645653842948377e-01 3.42722531700019074352159265117734e-03 9.21975405695789861082456440044552e-03 4.52482973410083666584644013219929e-05
 	 9.58024417690475416087281246291241e-01 1.13750306799151844339146322226952e-02 3.06005516296093994788041214860641e-02 2.65100147429430743964418049074538e-04
 	 9.13108376537141497308880389027763e-01 2.35469010394974420652403068743297e-02 6.33447224233610606258793040979072e-02 7.67840751164282570365160474068489e-04
 	 8.54138147775210576639892678940669e-01 3.95273383428383223714419614225335e-02 1.06334513881951100988665359636798e-01 1.61276665469769976864189420240336e-03
 	 7.83122553964867962328355588397244e-01 5.87719685277957593072528652555775e-02 1.58105477507336278364391546347179e-01 2.79777852183938106553351410354935e-03
 	 7.02480137925040937219023362558801e-01 8.06253867791817402377319012884982e-02 2.16894475295777322543244736152701e-01 4.25584830293798416916972726653512e-03
 	 6.14957151876489360731170563667547e-01 1.04343381783009447882903941717814e-01 2.80699466340501191385925494614639e-01 5.86090405718845894322832634770748e-03
 	 5.23534116025168305696979587082751e-01 1.29118257566538385816556910867803e-01 3.47347626408293308486463502049446e-01 7.44244403362417580871657207808312e-03
 	 4.31324343595625214753397358435905e-01 1.54106332362967113347451686422573e-01 4.14569324041407671899150955141522e-01 8.80698834295994513465810626939856e-03
 	 3.41467927547823069112098437472014e-01 1.78456667321847395335510100267129e-01 4.80075405130329535552391462260857e-01 9.76352477808295482475386961596087e-03
 	 2.57024807845170899511799689207692e-01 2.01340044382407379330857111199293e-01 5.41635147772421721157343199593015e-01 1.01495357735979247620905496773958e-02
 	 1.80870559657883900328556592285167e-01 2.21977206796225901008767777966568e-01 5.97152233545890198662675629748264e-01 9.85408451389955218624461252829860e-03
 	 1.15598437579815915832170958310599e-01 2.39665404322736974584984182001790e-01 6.44736158097447109582844859687611e-01 8.83480724226703463541898742050762e-03
 	 6.34309455838367730606819350214209e-02 2.53802357029497716034427412523655e-01 6.82766697386665510904890652454924e-01 7.12646793868195946308752297682076e-03
 	 2.61435136813938928668221706175245e-02 2.63906938277184033303512933343882e-01 7.09949548041422073829664896038594e-01 4.83998289150308798334254589690318e-03
 	 4.99729966377193690618696564342827e-03 2.69637384883994357664960261899978e-01 7.25365315452233705428852772456594e-01 2.15493745028634726967897705662836e-03
 	 9.87353020626041910645653842948377e-01 2.41635562766958321423427236140924e-03 1.02306237462885061401118846902136e-02 4.00159793261541091692959359882309e-05
 	 9.58024417690475416087281246291241e-01 8.01993357775072912563274485364673e-03 3.39556487317738547870860088551126e-02 2.34445109369503209336554894193227e-04
 	 9.13108376537141497308880389027763e-01 1.66016767437894285919242065574508e-02 7.02899467190690740991954044147860e-02 6.79050957272635345024491826393387e-04
 	 8.54138147775210576639892678940669e-01 2.78686393852615593713650810059335e-02 1.17993212839527863988742240053398e-01 1.42627327224984293274623325942230e-03
 	 7.83122553964868073350658050912898e-01 4.14370120916537909572241460409714e-02 1.75440433943478135692117803046131e-01 2.47425547629650773376330796793354e-03
 	 7.02480137925041048241325825074455e-01 5.68447035304453784920752923426335e-02 2.40675158544513573266598882582912e-01 3.76372035442912441713381177521569e-03
 	 6.14957151876489471753473026183201e-01 7.35670095954291669571034617547411e-02 3.11475838528081361289423512062058e-01 5.18317438151363538145766085563082e-03
 	 5.23534116025168305696979587082751e-01 9.10344664992384644541800753358984e-02 3.85431417475593229848840337581350e-01 6.58183189394076582218184867656419e-03
 	 4.31324343595625214753397358435905e-01 1.08652238771015707818889950431185e-01 4.60023417633359077427712691132911e-01 7.78858618262677059734810924851445e-03
 	 3.41467927547823069112098437472014e-01 1.25820374353368125142083044920582e-01 5.32711698098808805745818517607404e-01 8.63451286853336719140372679248685e-03
 	 2.57024807845170899511799689207692e-01 1.41954235370935322180230286903679e-01 6.01020956783893778307970023888629e-01 8.97588721682726457806733577626801e-03
 	 1.80870559657883900328556592285167e-01 1.56504409031944957675364094029646e-01 6.62625031310171141996079313685186e-01 8.71460066695168775185997844801022e-03
 	 1.15598437579815915832170958310599e-01 1.68975423244085209972809025202878e-01 7.15426139176098874195020016486524e-01 7.81318822436017149102305268115742e-03
 	 6.34309455838367730606819350214209e-02 1.78942642224884540524953990825452e-01 7.57626412191278686414364074153127e-01 6.30239391227537925493917825292556e-03
 	 2.61435136813938928668221706175245e-02 1.86066848982455512739875302941073e-01 7.87789637336150594393302526441403e-01 4.28030813768982831835074875925784e-03
 	 4.99729966377193690618696564342827e-03 1.90107084340995102778038017277140e-01 8.04895615995232960315775017079432e-01 1.90574977462548700302136239770334e-03
 	 9.87353020626041910645653842948377e-01 1.54669770124767590180336895855362e-03 1.11002816727104134525427880930692e-02 3.33374602932448132726686584881293e-05
 	 9.58024417690475527109583708806895e-01 5.13352119482071017619873032344913e-03 3.68420611147037627142175608696562e-02 1.95317087227774211942096793670487e-04
 	 9.13108376537141497308880389027763e-01 1.06266540249460861300434544318705e-02 7.62649694379124165610761565403664e-02 5.65719862574260833748551746680278e-04
 	 8.54138147775210576639892678940669e-01 1.78385830216787333313277486013249e-02 1.28023269203110690028779572458006e-01 1.18823353524346491186247654070485e-03
 	 7.83122553964868073350658050912898e-01 2.65236336137094907972056034850539e-02 1.90353812421422435852136345602048e-01 2.06131138323701126879861078577960e-03
 	 7.02480137925041048241325825074455e-01 3.63860233451812620231180517293978e-02 2.61133838729777689735556123196147e-01 3.13556933963753375199656758809397e-03
 	 6.14957151876489471753473026183201e-01 4.70898916227223685027070132491644e-02 3.37952956500788159743819960567635e-01 4.31812173652683633368054572088113e-03
 	 5.23534116025168305696979587082751e-01 5.82707273947402071279100255196681e-02 4.18195156580091487175110387397581e-01 5.48334848018202855590708111321874e-03
 	 4.31324343595625214753397358435905e-01 6.95477793161675128530418987793382e-02 4.99127877088207272393560742784757e-01 6.48869993877993194580922065028972e-03
 	 3.41467927547823069112098437472014e-01 8.05370209393231339944918545370456e-02 5.77995051512853796893409707990941e-01 7.19344458772509451338628139183129e-03
 	 2.57024807845170899511799689207692e-01 9.08642283513327875255072285654023e-02 6.52110963803496312962693082226906e-01 7.47784481915818831365694308033198e-03
 	 1.80870559657883900328556592285167e-01 1.00177725047157495374960944900522e-01 7.18951715294958604296482462814311e-01 7.26016602862705664328535348772675e-03
 	 1.15598437579815915832170958310599e-01 1.08160361705962326794860928202979e-01 7.76241200714221757372968113486422e-01 6.50919599068797410240660994418249e-03
 	 6.34309455838367730606819350214209e-02 1.14540330990658412169125313084805e-01 8.22028723425504814770192751893774e-01 5.25054766473114723629445066421795e-03
 	 2.61435136813938928668221706175245e-02 1.19100501724208607257082803698722e-01 8.54755984594397499876095025683753e-01 3.56594053140724554645801802621463e-03
 	 4.99729966377193690618696564342827e-03 1.21686637088554649999139201099752e-01 8.73316063247673413094673833256820e-01 1.58768718172824742015936116956709e-03
 	 9.87353020626041910645653842948377e-01 8.49679705952321659423454036641488e-04 1.17972996680057676949227030149814e-02 2.54542990511808529861901423396731e-05
 	 9.58024417690475416087281246291241e-01 2.82010426200070968283384331698471e-03 3.91554780475238742298849103917746e-02 1.49131322673333655730656954752078e-04
 	 9.13108376537141497308880389027763e-01 5.83776148363679414643456766498275e-03 8.10538619792217085446850433072541e-02 4.31946598045923981813720704536763e-04
 	 8.54138147775210576639892678940669e-01 9.79964085046439170589849254611181e-03 1.36062211374325031654208828513219e-01 9.07257226035832376083434258617899e-04
 	 7.83122553964867962328355588397244e-01 1.45707808264693428057512392115314e-02 2.02306665208662694865893172391225e-01 1.57388223112934653655226036050863e-03
 	 7.02480137925040937219023362558801e-01 1.99886930663752404591093636554433e-02 2.77531169008583822321867273785756e-01 2.39411517748459520826820323691209e-03
 	 6.14957151876489360731170563667547e-01 2.58688722657604563970323852117872e-02 3.59173975857750182871797051120666e-01 3.29703465873285375686840836806368e-03
 	 5.23534116025168305696979587082751e-01 3.20110739664585808306185299443314e-02 4.44454810008373113472401882972918e-01 4.18672540705428315732650190739150e-03
 	 4.31324343595625214753397358435905e-01 3.82061320911832869029467474319972e-02 5.30469524313191498343655894132098e-01 4.95434586924879856451031656661144e-03
 	 3.41467927547823069112098437472014e-01 4.42430813822242141597484987869393e-02 6.14288991069952716728153063741047e-01 5.49244267959894325037417672774609e-03
 	 2.57024807845170899511799689207692e-01 4.99163416127571535341189701284748e-02 6.93058850542071946954081340663834e-01 5.70959205083013728726504254495921e-03
 	 1.80870559657883900328556592285167e-01 5.50327189937493965743442458915524e-02 7.64096721348366703097099161823280e-01 5.54338679756429322798005898675910e-03
 	 1.15598437579815915832170958310599e-01 5.94179872743616499519703211262822e-02 8.24983575145822434215858720563119e-01 4.96999531074934167845791321838078e-03
 	 6.34309455838367730606819350214209e-02 6.29228288613327135792019362270366e-02 8.73646225554830513360116128751542e-01 4.00897396697094069578648500851159e-03
 	 2.61435136813938928668221706175245e-02 6.54279625567212308467901493713725e-02 9.08428523761884876286387680011103e-01 2.72271840406388939206938637482835e-03
 	 4.99729966377193690618696564342827e-03 6.68486582325199529819315102940891e-02 9.28154042103708110111881524062483e-01 1.21225384201286410547349081667790e-03
 	 9.87353020626041910645653842948377e-01 3.50479269997467854369510575907043e-04 1.22965001039606214999766464757158e-02 1.66524232809717549145655385300913e-05
 	 9.58024417690475527109583708806895e-01 1.16324784049651880346587518033630e-03 4.08123344690279540869504160127690e-02 9.75630051573675080838626838541927e-05
 	 9.13108376537141497308880389027763e-01 2.40798311277916343708938029521960e-03 8.44836403500793392540302306770172e-02 2.82583212013563756740547328050184e-04
 	 8.54138147775210576639892678940669e-01 4.04219489702728473901061079232022e-03 1.41819657327762138621096710267011e-01 5.93535548643130670722067865341387e-04
 	 7.83122553964867962328355588397244e-01 6.01021372121676722422023431136040e-03 2.10867232313915270447424177291396e-01 1.02964741061884542012994092630151e-03
 	 7.02480137925040937219023362558801e-01 8.24501574537989112556601867254358e-03 2.89274846329579171655410618768656e-01 1.56625092047163569537737703996072e-03
 	 6.14957151876489360731170563667547e-01 1.06704954865312617862116439937381e-02 3.74372352636979377482617792338715e-01 2.15694867884042929331855908969828e-03
 	 5.23534116025168305696979587082751e-01 1.32040553128485727008012418082217e-02 4.63261828661983121602219171109027e-01 2.73899208535590505883550171972729e-03
 	 4.31324343595625214753397358435905e-01 1.57594175675135339531607314711437e-02 5.52916238836861251293441910092952e-01 3.24117605160443742959297530603635e-03
 	 3.41467927547823069112098437472014e-01 1.82495624605992778910490415000822e-02 6.40282509991577652996852521027904e-01 3.59320365346745950602125319051083e-03
 	 2.57024807845170899511799689207692e-01 2.05896914411711762227241706568748e-02 7.22385500713657924265476140135434e-01 3.73526465611647784728632792905501e-03
 	 1.80870559657883900328556592285167e-01 2.27001151654989685724217451934237e-02 7.96429325176617131099021662521409e-01 3.62653173743194071065865102809767e-03
 	 1.15598437579815915832170958310599e-01 2.45089680955680178087163767486345e-02 8.59892594324616066359112664940767e-01 3.25141405200876469627768727832517e-03
 	 6.34309455838367730606819350214209e-02 2.59546591156702977087888939422555e-02 9.10614395300492929230529171036324e-01 2.62270555108055740400896382880092e-03
 	 2.61435136813938928668221706175245e-02 2.69879866420960068396084352571052e-02 9.46868499676510100293569394125370e-01 1.78122600226386521363175496901476e-03
 	 4.99729966377193690618696564342827e-03 2.75740008541035530598151126469020e-02 9.67428699482124510033997921709670e-01 7.93066980968229755417919779603153e-04
 	 9.87353020626041910645653842948377e-01 6.70230782719230533395204929547617e-05 1.25799562956861663010066365586681e-02 7.26311088332198491658185310337892e-06
 	 9.58024417690475416087281246291241e-01 2.22450962831001464170554982047179e-04 4.17531313466935824485481987267121e-02 4.25530214198785228024365934196283e-05
 	 9.13108376537141497308880389027763e-01 4.60484982881967375156762045662617e-04 8.64311384799765353159628489265742e-02 1.23251323125148711142007318386504e-04
 	 8.54138147775210576639892678940669e-01 7.72999626984460785905639568227343e-04 1.45088852597804962574201681491104e-01 2.58876106513240399759068210983060e-04
 	 7.83122553964868073350658050912898e-01 1.14934907468566827049016865203157e-03 2.15728096960446258378851780435070e-01 4.49090392903682595910491714974455e-04
 	 7.02480137925040937219023362558801e-01 1.57671617970395194774368974321987e-03 2.95943145895255110833232947697979e-01 6.83135055754286249496409766379657e-04
 	 6.14957151876489471753473026183201e-01 2.04054708913070648179655108833686e-03 3.83002301034379821764730422728462e-01 9.40773433374959182698415993684193e-04
 	 5.23534116025168305696979587082751e-01 2.52504643925516303326617162383627e-03 4.73940837535576531269754241293413e-01 1.19463713411687680494843721845655e-03
 	 4.31324343595625214753397358435905e-01 3.01371512544812425460349913919345e-03 5.65661941278926660991999142424902e-01 1.41366938961192604821970331130387e-03
 	 3.41467927547823069112098437472014e-01 3.48991212300209241448101238347590e-03 6.55042160329174838473420550144510e-01 1.56720953588256853468430040976500e-03
 	 2.57024807845170899511799689207692e-01 3.93742118062023749303079966921359e-03 7.39037770974208862995169511123095e-01 1.62917077702005104640481381039763e-03
 	 1.80870559657883900328556592285167e-01 4.34100309421980856683376259752549e-03 8.14788437247896291104609645117307e-01 1.58174589286067240195832184213032e-03
 	 1.15598437579815915832170958310599e-01 4.68691482678906812253671887447126e-03 8.79714647593395016045292322814930e-01 1.41813478968646632279171360124792e-03
 	 6.34309455838367730606819350214209e-02 4.96337814628300399988347635371611e-03 9.31605676269880222939434588624863e-01 1.14391766954236181151605133976545e-03
 	 2.61435136813938928668221706175245e-02 5.16098410364729254240501177264377e-03 9.68695502214958814590772817609832e-01 7.76898457624591149382753396679391e-04
 	 4.99729966377193690618696564342827e-03 5.27304915217385872239219679613598e-03 9.89729651184054204371420837560436e-01 3.45903615556998112780251464215553e-04
 	 ];
 
 	 case  32 

 	 % ALG. DEG.:   32
 	 % PTS CARD.:  289
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.9e-16  

 	 xyw_bar=[
 	 9.88714040632243662543032769463025e-01 1.12327769664254950576776082016295e-02 5.31824013308423992896223353454843e-05 5.14639669799014653090449625261193e-06
 	 9.62501197823349974314055543800350e-01 3.73220979832532134823352976127353e-02 1.76704193396812203609158586914418e-04 3.02501790928336282686817587661565e-05
 	 9.22243034592298283058653396437876e-01 7.73905541877212693746557192753244e-02 3.66411219980447566690884286799701e-04 8.80744263450604494359100216094305e-05
 	 8.69166059567413662456658585142577e-01 1.30217416581926842544802980228269e-01 6.16523850659494998538434629153926e-04 1.86338500704725623354288122079936e-04
 	 8.04883578524966614153868249559309e-01 1.94196981709656407710795633647649e-01 9.19439765376978135336116793041583e-04 3.26332858952083863096627069921851e-04
 	 7.31348952734051316326713276794180e-01 2.67385093052565858684488375729416e-01 1.26595421338282498879834747640416e-03 5.02363858051214635762338200919430e-04
 	 6.50796558453382356645988693344407e-01 3.47557903319044347867361466342118e-01 1.64553822757329548664984031347558e-03 7.02100413428792275577494663707512e-04
 	 5.65673966886634405071276887611020e-01 4.32279374903031476939929689251585e-01 2.04665821033411798879342313739471e-03 9.07790861395817855195033985182818e-04
 	 4.78567596853079701979538640443934e-01 5.18975276869259816159285492176423e-01 2.45712627766048186117586737964302e-03 1.09821145635082884940703085163705e-03
 	 3.92124134722095840643873998487834e-01 6.05011394728863338698943152849097e-01 2.86447054904082065718284866306931e-03 1.25111733964995046688994939643180e-03
 	 3.08970117752195960747485514730215e-01 6.87773568155944148294622664252529e-01 3.25631409185989095789182101725601e-03 1.34590367837179891198629011483945e-03
 	 2.31632125777172293012995396566112e-01 7.64747123223716740447741813113680e-01 3.62075099911096653926279032020830e-03 1.36615670203144739559830700414977e-03
 	 1.62460003428136490200017760798801e-01 8.33593288385436226306524076790083e-01 3.94670818642728349345816241111606e-03 1.30178506092443473270148235343413e-03
 	 1.03555432935197089250323188025504e-01 8.92220285089023512625772127648816e-01 4.22428197577939812390468432568014e-03 1.15047029088208383612590424149857e-03
 	 5.67079687690783540432448717183433e-02 9.38846991713896961151419873203849e-01 4.44503951702468480533525507780723e-03 9.18256816481300211507665665067179e-04
 	 2.33400941237742465261817415012047e-02 9.72057628180051036537179243168794e-01 4.60227769617471693663901533000171e-03 6.19221115702019782485454602038999e-04
 	 4.45799356778742161822037814999931e-03 9.90850751324635070638180422974983e-01 4.69125510757750774359919887501746e-03 2.74631479211557270360410942799945e-04
 	 9.88714040632243551520730306947371e-01 1.10076223391797102524325424610652e-02 2.78337028576738226837150591563841e-04 1.18193291013472480041873041711753e-05
 	 9.62501197823349974314055543800350e-01 3.65739977508202918077273579910980e-02 9.24804425829733878217098208551761e-04 6.94732340032251259251405706152127e-05
 	 9.22243034592298283058653396437876e-01 7.58393045339122856551838935956766e-02 1.91766087378943128616270996644744e-03 2.02273686129011021767043487784576e-04
 	 8.69166059567413662456658585142577e-01 1.27607282509199615461170651542488e-01 3.22665792338672208217076331493445e-03 4.27949144484119010142103567417848e-04
 	 8.04883578524966614153868249559309e-01 1.90304413633232805125317099737003e-01 4.81200784180058072081465070368722e-03 7.49463300807052569540989139795784e-04
 	 7.31348952734051316326713276794180e-01 2.62025510899615121651606841624016e-01 6.62553636633356202167988158180378e-03 1.15374000788719750960897858504950e-03
 	 6.50796558453382356645988693344407e-01 3.40591302771198867205271199054550e-01 8.61213877541877614874010760104284e-03 1.61245942267677607254161564753758e-03
 	 5.65673966886634405071276887611020e-01 4.23614580630586712306495655866456e-01 1.07114524827788826222274565225234e-02 2.08485267958898783449694924740925e-03
 	 4.78567596853079701979538640443934e-01 5.08572712537880611272100850328570e-01 1.28596906090396867483605092274956e-02 2.52217685250526830673112321790086e-03
 	 3.92124134722095840643873998487834e-01 5.92884285335808391970147113170242e-01 1.49915799420957673859788883419242e-02 2.87334390438650187638014443791690e-03
 	 3.08970117752195960747485514730215e-01 6.73987538055772605893878335336922e-01 1.70423441920314333586361499328632e-02 3.09103231773847318686332386050708e-03
 	 2.31632125777172293012995396566112e-01 7.49418201979986653427090459445026e-01 1.89496722428410535599141439888626e-02 3.13754586225870870860865657903105e-03
 	 1.62460003428136490200017760798801e-01 8.16884384907515803675437382480595e-01 2.06556116643477061245448567206040e-02 2.98970851980612890505528689288894e-03
 	 1.03555432935197089250323188025504e-01 8.74336236797955690391859207011294e-01 2.21083302668472203578176049632020e-02 2.64219565401331612022883810197982e-03
 	 5.67079687690783540432448717183433e-02 9.20028337600849344113385086529888e-01 2.32636936300723018433700417517684e-02 2.10888902477853476882807548520304e-03
 	 2.33400941237742465261817415012047e-02 9.52573285742871034287304610188585e-01 2.40866201333547191865136483102106e-02 1.42211698446096084652578994678152e-03
 	 4.45799356778742161822037814999931e-03 9.70989711419941059489246981684119e-01 2.45522950122715188925326401658822e-02 6.30724762367981610887424093192521e-04
 	 9.88714040632243551520730306947371e-01 1.06101513453137653864022382776966e-02 6.75808022442683092867454774932412e-04 1.81225883778079216337823786897587e-05
 	 9.62501197823349974314055543800350e-01 3.52533580352000497359910013983608e-02 2.24544414144997594995345480128890e-03 1.06523374746546697390547908668168e-04
 	 9.22243034592298283058653396437876e-01 7.31008454172777932811300161120016e-02 4.65611999042392366021658745012246e-03 3.10146432335160098566623210203375e-04
 	 8.69166059567413662456658585142577e-01 1.22999548718866508201230658414715e-01 7.83439171371982934211075644270750e-03 6.56174823936217250369695719314223e-04
 	 8.04883578524966503131565787043655e-01 1.83432767596227369599759526863636e-01 1.16836538788061272686746860927087e-02 1.14915278086733874465807936360306e-03
 	 7.31348952734051316326713276794180e-01 2.52564108879597903900560140755260e-01 1.60869383863507797727265824505594e-02 1.76903063436698970538329955815016e-03
 	 6.50796558453382356645988693344407e-01 3.28292991706081671576811231716420e-01 2.09104498405359717772000749391736e-02 2.47238554257348669418448139367683e-03
 	 5.65673966886634405071276887611020e-01 4.08318406471336659002702162979404e-01 2.60076266420289359260209494095761e-02 3.19670656570975259339051355311767e-03
 	 4.78567596853079757490689871701761e-01 4.90208810209396939061576858875924e-01 3.12235929375232479365820381644880e-02 3.86725612951905987901835004549866e-03
 	 3.92124134722095840643873998487834e-01 5.71476001250592835489783283264842e-01 3.63998640273113238663427182473242e-02 4.40570089897441685006240774669095e-03
 	 3.08970117752195960747485514730215e-01 6.49650720498834877147942279407289e-01 4.13791617489691621045722058624960e-02 4.73948274699370879908810749725490e-03
 	 2.31632125777172293012995396566112e-01 7.22357680789866285486766628309852e-01 4.60101934329614215002379751240369e-02 4.81080200835829786820685427528588e-03
 	 1.62460003428136490200017760798801e-01 7.87387747183391661920381920936052e-01 5.01522493884718478796003182651475e-02 4.58412287275222155719101024828888e-03
 	 1.03555432935197089250323188025504e-01 8.42765087070539653524292589281686e-01 5.36794799942632572253842226928100e-02 4.05128107024773937566708426061268e-03
 	 5.67079687690783540432448717183433e-02 8.86807305259518785511829719325760e-01 5.64847259714028604449254089558963e-02 3.23356151629467262684225481450540e-03
 	 2.33400941237742465261817415012047e-02 9.18177097451896129243209543346893e-01 5.84828084243296242306087151519023e-02 2.18053330383513382581539552518279e-03
 	 4.45799356778742161822037814999931e-03 9.35928529836884459669477109855507e-01 5.96134765953281187123025119944941e-02 9.67090868701061482509695466092126e-04
 	 9.88714040632243551520730306947371e-01 1.00530473305342014228580538315327e-02 1.23291203722224705641163922109627e-03 2.38442703360542191033145942302696e-05
 	 9.62501197823349974314055543800350e-01 3.34023206035289413340372277616552e-02 4.09648157312108435190722843799449e-03 1.40155042514556154708421642496319e-04
 	 9.22243034592298283058653396437876e-01 6.92625613871698797563425387124880e-02 8.49440402053183718500406484963605e-03 4.08066178086246330713321439631613e-04
 	 8.69166059567413662456658585142577e-01 1.16541248532826241524062993448752e-01 1.42926918997600960192784214086714e-02 8.63343003961140474829261126643587e-04
 	 8.04883578524966614153868249559309e-01 1.73801318624001333024153836959158e-01 2.13151028510320528219779134815326e-02 1.51196446077111893227518102378326e-03
 	 7.31348952734051316326713276794180e-01 2.39302801432914546975183611721150e-01 2.93482458330341366981031114846701e-02 2.32755077802579120674342227914622e-03
 	 6.50796558453382356645988693344407e-01 3.11055410662128717369512287405087e-01 3.81480308844889259844990192505065e-02 3.25296961024973971601803590658619e-03
 	 5.65673966886634405071276887611020e-01 3.86878955124203338655775041843299e-01 4.74470779891622562729480705456808e-02 4.20597400044477737202086586876248e-03
 	 4.78567596853079757490689871701761e-01 4.64469564145900515317322287955903e-01 5.69628390010196716808366090845084e-02 5.08823015171130672157362440088946e-03
 	 3.92124134722095840643873998487834e-01 5.41469683311735838771028284099884e-01 6.64061819661683205850977174122818e-02 5.79667324914708795985385236804177e-03
 	 3.08970117752195960747485514730215e-01 6.15539706167810285464270236843731e-01 7.54901760799937537882442484260537e-02 6.23583704029657525519381167100619e-03
 	 2.31632125777172293012995396566112e-01 6.84429064036191858733104709244799e-01 8.39388101866358482538998941890895e-02 6.32967329109546117393847453058697e-03
 	 1.62460003428136490200017760798801e-01 7.46044616358226941876807813969208e-01 9.14953802136365679231744252319913e-02 6.03142678920210676546398431696616e-03
 	 1.03555432935197089250323188025504e-01 7.98514274971575899186859714973252e-01 9.79302920932270115628170970012434e-02 5.33035563311793931379201083586850e-03
 	 5.67079687690783540432448717183433e-02 8.40243981701072950585285070701502e-01 1.03048049529848695371470057580154e-01 4.25446483335719174978528656083654e-03
 	 2.33400941237742465261817415012047e-02 8.69966649681514048175756670389092e-01 1.06693256194711705298061588109704e-01 2.86897348709210138484326790830892e-03
 	 4.45799356778742161822037814999931e-03 8.86786012963253100771510162303457e-01 1.08755993468959477610269459546544e-01 1.27242177729287885869224883350626e-03
 	 9.88714040632243551520730306947371e-01 9.35420467401065075518928892961412e-03 1.93175469374579772408040412301489e-03 2.87997613849133450960367935911322e-05
 	 9.62501197823349974314055543800350e-01 3.10803414367024077868961740023224e-02 6.41846073994761789904828219732735e-03 1.69283090839992400719257736874113e-04
 	 9.22243034592298283058653396437876e-01 6.44477394922785135067400119623926e-02 1.33092259154232034346065915997315e-02 4.92873482497272288362089032176527e-04
 	 8.69166059567413662456658585142577e-01 1.08439824850886434859376095118932e-01 2.23941155816999026839653197384905e-02 1.04276927567873226032624245362967e-03
 	 8.04883578524966503131565787043655e-01 1.61719432284365555174687756334606e-01 3.33969891906679416937464566217386e-02 1.82619199828629131740487245849636e-03
 	 7.31348952734051316326713276794180e-01 2.22667546473061583878205738074030e-01 4.59835007928870997950809851317899e-02 2.81127944255244030177798286729285e-03
 	 6.50796558453382356645988693344407e-01 2.89432236875519777186127612367272e-01 5.97712046710978661678836942883208e-02 3.92902560016311803992028472976017e-03
 	 5.65673966886634405071276887611020e-01 3.59984869394509798823378332599532e-01 7.43411637188557961053447797894478e-02 5.08009034861512612929468346578687e-03
 	 4.78567596853079701979538640443934e-01 4.32181728088850136693110925989458e-01 8.92506750580701613273504335666075e-02 6.14570344051285598341305416170144e-03
 	 3.92124134722095840643873998487834e-01 5.03829145127536182080518756265519e-01 1.04046720150367977275607245246647e-01 7.00138037561657579355145486488254e-03
 	 3.08970117752195960747485514730215e-01 5.72750152979545346099143898754846e-01 1.18279729268258693153370586514939e-01 7.53181440508128834804280060666315e-03
 	 2.31632125777172293012995396566112e-01 6.36850632383909598388527228962630e-01 1.31517241838918108598477374471258e-01 7.64515239337680303083333299696278e-03
 	 1.62460003428136490200017760798801e-01 6.94182948503812125018441747670295e-01 1.43357048068051384781540491530905e-01 7.28492211719905437966593453325004e-03
 	 1.03555432935197089250323188025504e-01 7.43005152329908158392868244845886e-01 1.53439414734894752356808567128610e-01 6.43814921433779035336852913928851e-03
 	 5.67079687690783540432448717183433e-02 7.81833997445214423649417767592240e-01 1.61458033785707222307337360689417e-01 5.13865890187974877489907044036954e-03
 	 2.33400941237742465261817415012047e-02 8.09490479167153664796785506041488e-01 1.67169426709072088677032752457308e-01 3.46522458785242497975032094359449e-03
 	 4.45799356778742161822037814999931e-03 8.25140635925698084918167296564206e-01 1.70401370506514493463612325285794e-01 1.53686579838812524892444066892949e-03
 	 9.88714040632243551520730306947371e-01 8.53608196877382943701384476753447e-03 2.74987739898261904225584828509454e-03 3.28296609687482265319165286587832e-05
 	 9.62501197823349974314055543800350e-01 2.83620416023481411449402855851076e-02 9.13676057430188454100417061454209e-03 1.92970573809338549363043280315821e-04
 	 9.22243034592298283058653396437876e-01 5.88111128823954679156749136836879e-02 1.89458525253062490256716898784362e-02 5.61840395641194584666622269253367e-04
 	 8.69166059567413662456658585142577e-01 9.89556318110546007105199350917246e-02 3.18783086215317368328214797656983e-02 1.18868213286979431016210373428521e-03
 	 8.04883578524966503131565787043655e-01 1.47575382197729892963522502213891e-01 4.75410392773036039049117107424536e-02 2.08172780900143508317490237402581e-03
 	 7.31348952734051316326713276794180e-01 2.03192948488786218064205968403257e-01 6.54580987771624656090807548025623e-02 3.20465679398842769390332030354784e-03
 	 6.50796558453382356645988693344407e-01 2.64118370772799648804607386409771e-01 8.50850707738179945494039202458225e-02 4.47880719103658717084037732547586e-03
 	 5.65673966886634405071276887611020e-01 3.28500440150448047571529741617269e-01 1.05825592962917547357193370771711e-01 5.79093839030938879047782918974008e-03
 	 4.78567596853079701979538640443934e-01 3.94382930985303636894911960553145e-01 1.27049472161616661125549399002921e-01 7.00566083412755644804770227551671e-03
 	 3.92124134722095840643873998487834e-01 4.59764034564569934460109834617469e-01 1.48111830713334224896016166894697e-01 7.98107112669159055040601913333376e-03
 	 3.08970117752195960747485514730215e-01 5.22657181860117892036043940606760e-01 1.68372700387686147216470544663025e-01 8.58572785008846449394948052713517e-03
 	 2.31632125777172293012995396566112e-01 5.81151406169062023643334669031901e-01 1.87216468053765683343669934401987e-01 8.71492502227652447721606421282559e-03
 	 1.62460003428136490200017760798801e-01 6.33469413622849253364677224453771e-01 2.04070582949014256435305014747428e-01 8.30428836180095546193324906880662e-03
 	 1.03555432935197089250323188025504e-01 6.78021606810755628202969091944396e-01 2.18422960254047282546707720030099e-01 7.33902802693510436515822448200197e-03
 	 5.67079687690783540432448717183433e-02 7.13454464676048449867096223897533e-01 2.29837566554873196089658904384123e-01 5.85770233746191193446861689153593e-03
 	 2.33400941237742465261817415012047e-02 7.38692098785368123081696012377506e-01 2.37967807090857630392122246121289e-01 3.95010732482524440367654960937216e-03
 	 4.45799356778731059591791563434526e-03 7.52973486201046426913308096118271e-01 2.42568520231166262490773988247383e-01 1.75191670657303712188568312058123e-03
 	 9.88714040632243551520730306947371e-01 7.62497338938117157070006868480050e-03 3.66098597837527690856962436782851e-03 3.58044108231257265429793579247786e-05
 	 9.62501197823349974314055543800350e-01 2.53347862962814349141460468217701e-02 1.21640158803685907717984093778796e-02 2.10455956521177141608711091969042e-04
 	 9.22243034592298283058653396437876e-01 5.25338407443354249437561520608142e-02 2.52231246633662919975904515013099e-02 6.12749682724848874874890025665763e-04
 	 8.69166059567413662456658585142577e-01 8.83934880251715238141940744753811e-02 4.24404524074148137291473403820419e-02 1.29639058605856291941926805577623e-03
 	 8.04883578524966503131565787043655e-01 1.31823753134259619157475640349730e-01 6.32926683407738777109585726066143e-02 2.27035660728770434871326422410220e-03
 	 7.31348952734051316326713276794180e-01 1.81504914175449283408880774004501e-01 8.71461330904994002644059492013184e-02 3.49503604403069356373889853273340e-03
 	 6.50796558453382356645988693344407e-01 2.35927391062599411952760419808328e-01 1.13276050484018231401250886847265e-01 4.88463931498096717159773660910105e-03
 	 5.65673966886634405071276887611020e-01 2.93437565818849832588455228687963e-01 1.40888467294515762340267883701017e-01 6.31566489143532434208383463669634e-03
 	 4.78567596853079701979538640443934e-01 3.52288012813102846543245050270343e-01 1.69144390333817451477216309285723e-01 7.64045534406713761771401394184977e-03
 	 3.92124134722095896155025229745661e-01 4.10690588700256709042690772548667e-01 1.97185276577647450313435228963499e-01 8.70424917578880436019872490760463e-03
 	 3.08970117752195960747485514730215e-01 4.66870763194512372606936878582928e-01 2.24159119053291666645577606686857e-01 9.36369484451123230972502398117285e-03
 	 2.31632125777172293012995396566112e-01 5.19121538833708928706300866906531e-01 2.49246335389118778280703736527357e-01 9.50459878606003255585576994235453e-03
 	 1.62460003428136490200017760798801e-01 5.65855323265476384264616172004025e-01 2.71684673306387125535366067197174e-01 9.05675365891419996422495586330115e-03
 	 1.03555432935197089250323188025504e-01 6.05652186596810193641715613921406e-01 2.90792380467992717107961198053090e-01 8.00402948933765824579555925311070e-03
 	 5.67079687690783540432448717183433e-02 6.37303077406073725796886719763279e-01 3.05988953824847920159868408518378e-01 6.38847843021350236120126098171568e-03
 	 2.33400941237742465261817415012047e-02 6.59846943455914658471783695858903e-01 3.16812962420311095002034562639892e-01 4.30803307984553573994901398691582e-03
 	 4.45799356778731059591791563434526e-03 6.72603990471904555903392974869348e-01 3.22938015960308133500689109496307e-01 1.91066077562451752669403504114598e-03
 	 9.88714040632243551520730306947371e-01 6.65016229395292649689830355441700e-03 4.63579707380352198237138949821201e-03 3.76283885801511895391642525954268e-05
 	 9.62501197823349974314055543800350e-01 2.20958725951120593666843205937766e-02 1.54029295815379663192601356058731e-02 2.21177177027344741902514790865553e-04
 	 9.22243034592298283058653396437876e-01 4.58176768670481501799507384475874e-02 3.19392885406535667613958651145367e-02 6.43964881249848935217128254038244e-04
 	 8.69166059567413662456658585142577e-01 7.70928646012865037562278303084895e-02 5.37410758312998337871135845489334e-02 1.36243238200010538530015935521078e-03
 	 8.04883578524966614153868249559309e-01 1.14970808129201809699715397528053e-01 8.01456133458315761464163529126381e-02 2.38601498168927034226882710754580e-03
 	 7.31348952734051316326713276794180e-01 1.58300504772606903669540656665049e-01 1.10350542493341780003746066540771e-01 3.67308304599942231707943030016850e-03
 	 6.50796558453382356645988693344407e-01 2.05765365993299392810556014410395e-01 1.43438075553318250543455292245199e-01 5.13347663018300440218588676088984e-03
 	 5.65673966886634405071276887611020e-01 2.55923179817971524485642476065550e-01 1.78402853295394070443080636323430e-01 6.63740268904109385894596329080741e-03
 	 4.78567596853079701979538640443934e-01 3.07249919414005590034832948731491e-01 2.14182483732914707985628410824575e-01 8.02968170698563181442164449208576e-03
 	 3.92124134722095840643873998487834e-01 3.58186045771555550132347889302764e-01 2.49689819506348609223778112209402e-01 9.14766819940227536578358780161579e-03
 	 3.08970117752195960747485514730215e-01 4.07183892584987661145135007245699e-01 2.83845989662816378107379478024086e-01 9.84070789199115864009925758182362e-03
 	 2.31632125777172293012995396566112e-01 4.52754692670596758929946190619376e-01 3.15613181552230948057058412814513e-01 9.98878987807005382093539225252243e-03
 	 1.62460003428136545711168992056628e-01 4.93513818665013814790398782861303e-01 3.44026177906849695009583456339897e-01 9.51813025595762279840172936928866e-03
 	 1.03555432935197089250323188025504e-01 5.28222870936881916392735547560733e-01 3.68221696127920994356941264413763e-01 8.41177734552353041641570285946727e-03
 	 5.67079687690783540432448717183433e-02 5.55827368668364130144254886545241e-01 3.87464662562557515812500241736416e-01 6.71392555502473269840590930357394e-03
 	 2.33400941237742465261817415012047e-02 5.75489124888177716599102495820262e-01 4.01170780988048036874715762678534e-01 4.52749644576951569552303311638752e-03
 	 4.45799356778742161822037814999931e-03 5.86615253297499972262585288262926e-01 4.08926753134712606119194333587075e-01 2.00799522900167509362190365607148e-03
 	 9.88714040632243662543032769463025e-01 5.64297968387822423963484652631450e-03 5.64297968387811321733238401066046e-03 3.82429658735971918941988489937245e-05
 	 9.62501197823349974314055543800350e-01 1.87494010883250128429722280998249e-02 1.87494010883250128429722280998249e-02 2.24789621672428385117450955199558e-04
 	 9.22243034592298283058653396437876e-01 3.88784827038508584706733017810620e-02 3.88784827038508584706733017810620e-02 6.54482636825530852443810747587349e-04
 	 8.69166059567413551434356122626923e-01 6.54169702162931687716707074287115e-02 6.54169702162932797939731699443655e-02 1.38468473022515005388388686924372e-03
 	 8.04883578524966614153868249559309e-01 9.75582107375167206786414908492588e-02 9.75582107375166651674902595914318e-02 2.42498530927703556669960960334720e-03
 	 7.31348952734051316326713276794180e-01 1.34325523632974341836643361602910e-01 1.34325523632974341836643361602910e-01 3.73307481078638146373971373748191e-03
 	 6.50796558453382356645988693344407e-01 1.74601720773308821677005653327797e-01 1.74601720773308821677005653327797e-01 5.21732072482516441580546739942292e-03
 	 5.65673966886634405071276887611020e-01 2.17163016556682797464361556194490e-01 2.17163016556682797464361556194490e-01 6.74581012114393568229742115249792e-03
 	 4.78567596853079757490689871701761e-01 2.60716201573460149010230679778033e-01 2.60716201573460037987928217262379e-01 8.16082896672545507477103399196494e-03
 	 3.92124134722095840643873998487834e-01 3.03937932638952079678063000756083e-01 3.03937932638952079678063000756083e-01 9.29707531927815092331890411969653e-03
 	 3.08970117752195960747485514730215e-01 3.45514941123902019626257242634892e-01 3.45514941123902019626257242634892e-01 1.00014342969757964035837360938785e-02
 	 2.31632125777172293012995396566112e-01 3.84183937111413853493502301716944e-01 3.84183937111413853493502301716944e-01 1.01519348778881801642626214743359e-02
 	 1.62460003428136490200017760798801e-01 4.18769998285931754899991119600600e-01 4.18769998285931754899991119600600e-01 9.67358806194133780120836263449746e-03
 	 1.03555432935197089250323188025504e-01 4.48222283532401455374838405987248e-01 4.48222283532401455374838405987248e-01 8.54916530044672572097308460570275e-03
 	 5.67079687690783540432448717183433e-02 4.71646015615460822978377564140828e-01 4.71646015615460822978377564140828e-01 6.82358282050172463423232116497275e-03
 	 2.33400941237742465261817415012047e-02 4.88329952938112876736909129249398e-01 4.88329952938112876736909129249398e-01 4.60144318164422676947777901546033e-03
 	 4.45799356778747712937160940782633e-03 4.97771003216106289190889810925000e-01 4.97771003216106178168587348409346e-01 2.04079143207222882261397955971916e-03
 	 9.88714040632243551520730306947371e-01 4.63579707380352371709486547501911e-03 6.65016229395292476217482757760990e-03 3.76283885801510743426834260105807e-05
 	 9.62501197823349974314055543800350e-01 1.54029295815379732581540395131015e-02 2.20958725951120524277904166865483e-02 2.21177177027344091381211299562892e-04
 	 9.22243034592298283058653396437876e-01 3.19392885406535806391836729289935e-02 4.58176768670481363021629306331306e-02 6.43964881249847092073435028680706e-04
 	 8.69166059567413662456658585142577e-01 5.37410758312998615426892001778469e-02 7.70928646012864760006522146795760e-02 1.36243238200010126533190391029393e-03
 	 8.04883578524966503131565787043655e-01 8.01456133458316594131431997993786e-02 1.14970808129201837455291013156966e-01 2.38601498168926340337492320031743e-03
 	 7.31348952734051316326713276794180e-01 1.10350542493341807759321682169684e-01 1.58300504772606875913965041036136e-01 3.67308304599941147505770544512416e-03
 	 6.50796558453382356645988693344407e-01 1.43438075553318306054606523503026e-01 2.05765365993299337299404783152568e-01 5.13347663018298878967460296962599e-03
 	 5.65673966886634405071276887611020e-01 1.78402853295394125954231867581257e-01 2.55923179817971468974491244807723e-01 6.63740268904107390962598955752583e-03
 	 4.78567596853079757490689871701761e-01 2.14182483732914763496779642082402e-01 3.07249919414005423501379254958010e-01 8.02968170698560752829298081678644e-03
 	 3.92124134722095840643873998487834e-01 2.49689819506348720246080574725056e-01 3.58186045771555439110045426787110e-01 9.14766819940224761020797217270228e-03
 	 3.08970117752195960747485514730215e-01 2.83845989662816489129681940539740e-01 4.07183892584987550122832544730045e-01 9.84070789199112914980016597610302e-03
 	 2.31632125777172293012995396566112e-01 3.15613181552231059079360875330167e-01 4.52754692670596647907643728103722e-01 9.98878987807002433063630064680183e-03
 	 1.62460003428136490200017760798801e-01 3.44026177906849861543037150113378e-01 4.93513818665013648256945089087822e-01 9.51813025595759504282611374037515e-03
 	 1.03555432935197089250323188025504e-01 3.68221696127921216401546189445071e-01 5.28222870936881694348130622529425e-01 8.41177734552350613028703918416795e-03
 	 5.67079687690783540432448717183433e-02 3.87464662562557626834802704252070e-01 5.55827368668364019121952424029587e-01 6.71392555502471274908593557029235e-03
 	 2.33400941237742465261817415012047e-02 4.01170780988048147897018225194188e-01 5.75489124888177605576800033304607e-01 4.52749644576950181773522530193077e-03
 	 4.45799356778742161822037814999931e-03 4.08926753134712717141496796102729e-01 5.86615253297499861240282825747272e-01 2.00799522900166945577060673144842e-03
 	 9.88714040632243551520730306947371e-01 3.66098597837527864329310034463560e-03 7.62497338938116983597659270799340e-03 3.58044108231256994379250457871677e-05
 	 9.62501197823349974314055543800350e-01 1.21640158803685942412453613314938e-02 2.53347862962814314446990948681560e-02 2.10455956521176978978385219143377e-04
 	 9.22243034592298283058653396437876e-01 2.52231246633662989364843554085382e-02 5.25338407443354180048622481535858e-02 6.12749682724848332773803782913546e-04
 	 8.69166059567413662456658585142577e-01 4.24404524074148276069351481964986e-02 8.83934880251715099364062666609243e-02 1.29639058605856183521709557027179e-03
 	 8.04883578524966503131565787043655e-01 6.32926683407738499553829569777008e-02 1.31823753134259646913051255978644e-01 2.27035660728770218030891925309334e-03
 	 7.31348952734051316326713276794180e-01 8.71461330904994557755571804591455e-02 1.81504914175449227897729542746674e-01 3.49503604403069052797281557332099e-03
 	 6.50796558453382356645988693344407e-01 1.13276050484018286912402118105092e-01 2.35927391062599356441609188550501e-01 4.88463931498096283478904666708331e-03
 	 5.65673966886634405071276887611020e-01 1.40888467294515762340267883701017e-01 2.93437565818849832588455228687963e-01 6.31566489143531913791340670627505e-03
 	 4.78567596853079757490689871701761e-01 1.69144390333817506988367540543550e-01 3.52288012813102680009791356496862e-01 7.64045534406713067882011003462139e-03
 	 3.92124134722095840643873998487834e-01 1.97185276577647505824586460221326e-01 4.10690588700256653531539541290840e-01 8.70424917578879742130482100037625e-03
 	 3.08970117752195905236334283472388e-01 2.24159119053291722156728837944684e-01 4.66870763194512317095785647325101e-01 9.36369484451122537083112007394448e-03
 	 2.31632125777172293012995396566112e-01 2.49246335389118889303006199043011e-01 5.19121538833708817683998404390877e-01 9.50459878606002388223839005831906e-03
 	 1.62460003428136490200017760798801e-01 2.71684673306387236557668529712828e-01 5.65855323265476273242313709488371e-01 9.05675365891419302533105195607277e-03
 	 1.03555432935197089250323188025504e-01 2.90792380467992828130263660568744e-01 6.05652186596810082619413151405752e-01 8.00402948933765130690165534588232e-03
 	 5.67079687690783540432448717183433e-02 3.05988953824848142204473333549686e-01 6.37303077406073503752281794731971e-01 6.38847843021349715703083305129439e-03
 	 2.33400941237742465261817415012047e-02 3.16812962420311095002034562639892e-01 6.59846943455914658471783695858903e-01 4.30803307984553227050206203330163e-03
 	 4.45799356778742161822037814999931e-03 3.22938015960308244522991572011961e-01 6.72603990471904333858788049838040e-01 1.91066077562451579197055906433889e-03
 	 9.88714040632243551520730306947371e-01 2.74987739898261904225584828509454e-03 8.53608196877382943701384476753447e-03 3.28296609687482807420251529340050e-05
 	 9.62501197823349974314055543800350e-01 9.13676057430188107155721866092790e-03 2.83620416023481446143872375387218e-02 1.92970573809338847518640713829541e-04
 	 9.22243034592298283058653396437876e-01 1.89458525253062490256716898784362e-02 5.88111128823954679156749136836879e-02 5.61840395641195452028360257656914e-04
 	 8.69166059567413662456658585142577e-01 3.18783086215317507106092875801551e-02 9.89556318110545868327321272772679e-02 1.18868213286979626172601420819319e-03
 	 8.04883578524966503131565787043655e-01 4.75410392773035483937604794846266e-02 1.47575382197729948474673733471718e-01 2.08172780900143811894098533343822e-03
 	 7.31348952734051316326713276794180e-01 6.54580987771624378535051391736488e-02 2.03192948488786245819781584032171e-01 3.20465679398843289807374823396913e-03
 	 6.50796558453382356645988693344407e-01 8.50850707738179945494039202458225e-02 2.64118370772799648804607386409771e-01 4.47880719103659410973428123270423e-03
 	 5.65673966886634405071276887611020e-01 1.05825592962917547357193370771711e-01 3.28500440150448047571529741617269e-01 5.79093839030939833145694706217910e-03
 	 4.78567596853079646468387409186107e-01 1.27049472161616605614398167745094e-01 3.94382930985303803428365654326626e-01 7.00566083412756772375029612476283e-03
 	 3.92124134722095840643873998487834e-01 1.48111830713334224896016166894697e-01 4.59764034564569934460109834617469e-01 7.98107112669160269347035097098342e-03
 	 3.08970117752195960747485514730215e-01 1.68372700387686147216470544663025e-01 5.22657181860117892036043940606760e-01 8.58572785008847837173728834159192e-03
 	 2.31632125777172293012995396566112e-01 1.87216468053765683343669934401987e-01 5.81151406169062023643334669031901e-01 8.71492502227653835500387202728234e-03
 	 1.62460003428136490200017760798801e-01 2.04070582949014256435305014747428e-01 6.33469413622849253364677224453771e-01 8.30428836180096933972105688326337e-03
 	 1.03555432935197089250323188025504e-01 2.18422960254047282546707720030099e-01 6.78021606810755628202969091944396e-01 7.33902802693511650822255631965163e-03
 	 5.67079687690783540432448717183433e-02 2.29837566554873196089658904384123e-01 7.13454464676048449867096223897533e-01 5.85770233746192060808599677557140e-03
 	 2.33400941237742465261817415012047e-02 2.37967807090857630392122246121289e-01 7.38692098785368123081696012377506e-01 3.95010732482525047520871552819699e-03
 	 4.45799356778742161822037814999931e-03 2.42568520231166151468471525731729e-01 7.52973486201046426913308096118271e-01 1.75191670657303994081133158289276e-03
 	 9.88714040632243551520730306947371e-01 1.93175469374579772408040412301489e-03 9.35420467401065075518928892961412e-03 2.87997613849133146028506924363199e-05
 	 9.62501197823349974314055543800350e-01 6.41846073994761789904828219732735e-03 3.10803414367024077868961740023224e-02 1.69283090839992210983877551910837e-04
 	 9.22243034592298283058653396437876e-01 1.33092259154232034346065915997315e-02 6.44477394922785135067400119623926e-02 4.92873482497271746261002789424310e-04
 	 8.69166059567413662456658585142577e-01 2.23941155816999026839653197384905e-02 1.08439824850886434859376095118932e-01 1.04276927567873139296450446522613e-03
 	 8.04883578524966503131565787043655e-01 3.33969891906678861825952253639116e-02 1.61719432284365610685838987592433e-01 1.82619199828628958268139648168926e-03
 	 7.31348952734051316326713276794180e-01 4.59835007928870997950809851317899e-02 2.22667546473061583878205738074030e-01 2.81127944255243726601189990788043e-03
 	 6.50796558453382356645988693344407e-01 5.97712046710978661678836942883208e-02 2.89432236875519777186127612367272e-01 3.92902560016311457047333277614598e-03
 	 5.65673966886634405071276887611020e-01 7.43411637188557961053447797894478e-02 3.59984869394509798823378332599532e-01 5.08009034861512092512425553536559e-03
 	 4.78567596853079701979538640443934e-01 8.92506750580701613273504335666075e-02 4.32181728088850136693110925989458e-01 6.14570344051284991188088824287661e-03
 	 3.92124134722095840643873998487834e-01 1.04046720150367977275607245246647e-01 5.03829145127536182080518756265519e-01 7.00138037561656885465755095765417e-03
 	 3.08970117752195960747485514730215e-01 1.18279729268258693153370586514939e-01 5.72750152979545346099143898754846e-01 7.53181440508128054178715871103122e-03
 	 2.31632125777172293012995396566112e-01 1.31517241838918108598477374471258e-01 6.36850632383909598388527228962630e-01 7.64515239337679522457769110133086e-03
 	 1.62460003428136490200017760798801e-01 1.43357048068051384781540491530905e-01 6.94182948503812125018441747670295e-01 7.28492211719904657341029263761811e-03
 	 1.03555432935197089250323188025504e-01 1.53439414734894752356808567128610e-01 7.43005152329908158392868244845886e-01 6.43814921433778341447462523206013e-03
 	 5.67079687690783540432448717183433e-02 1.61458033785707222307337360689417e-01 7.81833997445214423649417767592240e-01 5.13865890187974357072864250994826e-03
 	 2.33400941237742465261817415012047e-02 1.67169426709072088677032752457308e-01 8.09490479167153664796785506041488e-01 3.46522458785242151030336898998030e-03
 	 4.45799356778742161822037814999931e-03 1.70401370506514493463612325285794e-01 8.25140635925698084918167296564206e-01 1.53686579838812373104139918922328e-03
 	 9.88714040632243551520730306947371e-01 1.23291203722224532168816324428917e-03 1.00530473305342031575815298083398e-02 2.38442703360542292677099612818736e-05
 	 9.62501197823349974314055543800350e-01 4.09648157312108435190722843799449e-03 3.34023206035289413340372277616552e-02 1.40155042514556208918530266771540e-04
 	 9.22243034592298283058653396437876e-01 8.49440402053182330721625703517930e-03 6.92625613871698936341303465269448e-02 4.08066178086246439133538688182057e-04
 	 8.69166059567413662456658585142577e-01 1.42926918997600821414906135942147e-02 1.16541248532826255401850801263208e-01 8.63343003961140800089912872294917e-04
 	 8.04883578524966503131565787043655e-01 2.13151028510320805775535291104461e-02 1.73801318624001416290880683845899e-01 1.51196446077111936595605001798504e-03
 	 7.31348952734051316326713276794180e-01 2.93482458330341089425274958557566e-02 2.39302801432914574730759227350063e-01 2.32755077802579207410516026754976e-03
 	 6.50796558453382356645988693344407e-01 3.81480308844888704733477879926795e-02 3.11055410662128772880663518662914e-01 3.25296961024974101706064288919151e-03
 	 5.65673966886634405071276887611020e-01 4.74470779891622007617968392878538e-02 3.86878955124203394166926273101126e-01 4.20597400044477823938260385716603e-03
 	 4.78567596853079701979538640443934e-01 5.69628390010197271919878403423354e-02 4.64469564145900570828473519213730e-01 5.08823015171130845629710037769655e-03
 	 3.92124134722095840643873998487834e-01 6.64061819661682095627952548966277e-02 5.41469683311735949793330746615538e-01 5.79667324914708969457732834484887e-03
 	 3.08970117752195960747485514730215e-01 7.54901760799936427659417859103996e-02 6.15539706167810396486572699359385e-01 6.23583704029657785727902563621683e-03
 	 2.31632125777172293012995396566112e-01 8.39388101866357372315974316734355e-02 6.84429064036191969755407171760453e-01 6.32967329109546377602368849579761e-03
 	 1.62460003428136490200017760798801e-01 9.14953802136364569008719627163373e-02 7.46044616358227052899110276484862e-01 6.03142678920210850018746029377326e-03
 	 1.03555432935197089250323188025504e-01 9.79302920932270115628170970012434e-02 7.98514274971575899186859714973252e-01 5.33035563311794104851548681267559e-03
 	 5.67079687690783540432448717183433e-02 1.03048049529848584349167595064500e-01 8.40243981701073061607587533217156e-01 4.25446483335719348450876253764363e-03
 	 2.33400941237742465261817415012047e-02 1.06693256194711594275759125594050e-01 8.69966649681514159198059132904746e-01 2.86897348709210268588587489091424e-03
 	 4.45799356778742161822037814999931e-03 1.08755993468959366587966997030890e-01 8.86786012963253211793812624819111e-01 1.27242177729287929237311782770803e-03
 	 9.88714040632243551520730306947371e-01 6.75808022442681358143978798125318e-04 1.06101513453137671211257142545037e-02 1.81225883778079555151002688617723e-05
 	 9.62501197823349974314055543800350e-01 2.24544414144997594995345480128890e-03 3.52533580352000497359910013983608e-02 1.06523374746546887125928093631444e-04
 	 9.22243034592298283058653396437876e-01 4.65611999042390978242877963566571e-03 7.31008454172778071589178239264584e-02 3.10146432335160640667709452955592e-04
 	 8.69166059567413662456658585142577e-01 7.83439171371981546432294862825074e-03 1.22999548718866522079018466229172e-01 6.56174823936218334571868204818657e-04
 	 8.04883578524966614153868249559309e-01 1.16836538788060440019478392059682e-02 1.83432767596227341844183911234722e-01 1.14915278086734091306242433461193e-03
 	 7.31348952734051316326713276794180e-01 1.60869383863507242615753511927323e-02 2.52564108879597959411711372013087e-01 1.76903063436699295798981701466346e-03
 	 6.50796558453382356645988693344407e-01 2.09104498405359717772000749391736e-02 3.28292991706081671576811231716420e-01 2.47238554257349103099317133569457e-03
 	 5.65673966886634405071276887611020e-01 2.60076266420288804148697181517491e-02 4.08318406471336714513853394237231e-01 3.19670656570975823124181047774073e-03
 	 4.78567596853079701979538640443934e-01 3.12235929375233034477332694223151e-02 4.90208810209396994572728090133751e-01 3.86725612951906681791225395272704e-03
 	 3.92124134722095840643873998487834e-01 3.63998640273112128440402557316702e-02 5.71476001250592946512085745780496e-01 4.40570089897442465631804964232288e-03
 	 3.08970117752195960747485514730215e-01 4.13791617489690510822697433468420e-02 6.49650720498834988170244741922943e-01 4.73948274699371747270548738129037e-03
 	 2.31632125777172293012995396566112e-01 4.60101934329613104779355126083829e-02 7.22357680789866396509069090825506e-01 4.81080200835830654182423415932135e-03
 	 1.62460003428136490200017760798801e-01 5.01522493884718478796003182651475e-02 7.87387747183391661920381920936052e-01 4.58412287275223023080839013232435e-03
 	 1.03555432935197089250323188025504e-01 5.36794799942632572253842226928100e-02 8.42765087070539653524292589281686e-01 4.05128107024774631456098816784106e-03
 	 5.67079687690783540432448717183433e-02 5.64847259714027494226229464402422e-02 8.86807305259518896534132181841414e-01 3.23356151629467826469355173912845e-03
 	 2.33400941237742465261817415012047e-02 5.84828084243295132083062526362482e-02 9.18177097451896240265512005862547e-01 2.18053330383513772894321647299876e-03
 	 4.45799356778742161822037814999931e-03 5.96134765953280076900000494788401e-02 9.35928529836884570691779572371161e-01 9.67090868701063325653388691449663e-04
 	 9.88714040632243551520730306947371e-01 2.78337028576738226837150591563841e-04 1.10076223391797102524325424610652e-02 1.18193291013472276753965700679672e-05
 	 9.62501197823349974314055543800350e-01 9.24804425829733878217098208551761e-04 3.65739977508202918077273579910980e-02 6.94732340032250175049233220647693e-05
 	 9.22243034592298283058653396437876e-01 1.91766087378943128616270996644744e-03 7.58393045339122856551838935956766e-02 2.02273686129010696506391742133246e-04
 	 8.69166059567413662456658585142577e-01 3.22665792338672208217076331493445e-03 1.27607282509199615461170651542488e-01 4.27949144484118305410691451839966e-04
 	 8.04883578524966614153868249559309e-01 4.81200784180060847639026633260073e-03 1.90304413633232777369741484108090e-01 7.49463300807051376918599405740906e-04
 	 7.31348952734051316326713276794180e-01 6.62553636633350651052865032397676e-03 2.62025510899615177162758072881843e-01 1.15374000788719555804506811114152e-03
 	 6.50796558453382356645988693344407e-01 8.61213877541877614874010760104284e-03 3.40591302771198867205271199054550e-01 1.61245942267677347045640168232694e-03
 	 5.65673966886634405071276887611020e-01 1.07114524827788271110762252646964e-02 4.23614580630586767817646887124283e-01 2.08485267958898436504999729379506e-03
 	 4.78567596853079701979538640443934e-01 1.28596906090396867483605092274956e-02 5.08572712537880611272100850328570e-01 2.52217685250526440360330227008490e-03
 	 3.92124134722095840643873998487834e-01 1.49915799420957673859788883419242e-02 5.92884285335808391970147113170242e-01 2.87334390438649710589058550169739e-03
 	 3.08970117752195960747485514730215e-01 1.70423441920314333586361499328632e-02 6.73987538055772605893878335336922e-01 3.09103231773846841637376492428757e-03
 	 2.31632125777172293012995396566112e-01 1.89496722428410535599141439888626e-02 7.49418201979986653427090459445026e-01 3.13754586225870393811909764281154e-03
 	 1.62460003428136490200017760798801e-01 2.06556116643475951022423942049500e-02 8.16884384907515914697739844996249e-01 2.98970851980612413456572795666943e-03
 	 1.03555432935197089250323188025504e-01 2.21083302668472203578176049632020e-02 8.74336236797955690391859207011294e-01 2.64219565401331178342014815996208e-03
 	 5.67079687690783540432448717183433e-02 2.32636936300723018433700417517684e-02 9.20028337600849344113385086529888e-01 2.10888902477853129938112353158886e-03
 	 2.33400941237742465261817415012047e-02 2.40866201333546081642111857945565e-02 9.52573285742871145309607072704239e-01 1.42211698446095846128101047867176e-03
 	 4.45799356778742161822037814999931e-03 2.45522950122715188925326401658822e-02 9.70989711419941059489246981684119e-01 6.30724762367980526685251607688087e-04
 	 9.88714040632243551520730306947371e-01 5.31824013309516868686088741924323e-05 1.12327769664254967924010841784366e-02 5.14639669799019396474954249343092e-06
 	 9.62501197823349974314055543800350e-01 1.76704193396812203609158586914418e-04 3.73220979832532134823352976127353e-02 3.02501790928339060954884581766677e-05
 	 9.22243034592298283058653396437876e-01 3.66411219980433688903076472342946e-04 7.73905541877212832524435270897811e-02 8.80744263450612625875393857377560e-05
 	 8.69166059567413662456658585142577e-01 6.16523850659467242962819000240415e-04 1.30217416581926870300378595857183e-01 1.86338500704727330972709786749419e-04
 	 8.04883578524966503131565787043655e-01 9.19439765377005890911732421955094e-04 1.94196981709656490977522480534390e-01 3.26332858952086844652601405059045e-04
 	 7.31348952734051316326713276794180e-01 1.26595421338276947764711621857714e-03 2.67385093052565914195639606987243e-01 5.02363858051219189411462640038053e-04
 	 6.50796558453382356645988693344407e-01 1.64553822757323997549860905564856e-03 3.47557903319044403378512697599945e-01 7.02100413428798780790529576734116e-04
 	 5.65673966886634405071276887611020e-01 2.04665821033406247764219187956769e-03 4.32279374903031532451080920509412e-01 9.07790861395826203551762123566959e-04
 	 4.78567596853079701979538640443934e-01 2.45712627766037083887340486398898e-03 5.18975276869259927181587954692077e-01 1.09821145635083904090745221537873e-03
 	 3.92124134722095840643873998487834e-01 2.86447054904070963488038614741527e-03 6.05011394728863449721245615364751e-01 1.25111733964996195943297774277880e-03
 	 3.08970117752195960747485514730215e-01 3.25631409185989095789182101725601e-03 6.87773568155944148294622664252529e-01 1.34590367837181127189105644959000e-03
 	 2.31632125777172293012995396566112e-01 3.62075099911085551696032780455425e-03 7.64747123223716851470044275629334e-01 1.36615670203145997234350783600121e-03
 	 1.62460003428136490200017760798801e-01 3.94670818642717247115569989546202e-03 8.33593288385436337328826539305737e-01 1.30178506092444665892537969398290e-03
 	 1.03555432935197089250323188025504e-01 4.22428197577928710160222181002609e-03 8.92220285089023623648074590164470e-01 1.15047029088209424446676010234114e-03
 	 5.67079687690783540432448717183433e-02 4.44503951702457378303279256215319e-03 9.38846991713897072173722335719503e-01 9.18256816481308668284611052001765e-04
 	 2.33400941237742465261817415012047e-02 4.60227769617460591433655281434767e-03 9.72057628180051147559481705684448e-01 6.19221115702025420336751526662056e-04
 	 4.45799356778742161822037814999931e-03 4.69125510757739672129673635936342e-03 9.90850751324635181660482885490637e-01 2.74631479211559764025407659460143e-04
 	 ];
 
 	 case  33 

 	 % ALG. DEG.:   33
 	 % PTS CARD.:  289
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 9.88714040632243662543032769463025e-01 1.12327769664254950576776082016295e-02 5.31824013308423992896223353454843e-05 5.14639669799014653090449625261193e-06
 	 9.62501197823349974314055543800350e-01 3.73220979832532134823352976127353e-02 1.76704193396812203609158586914418e-04 3.02501790928336282686817587661565e-05
 	 9.22243034592298283058653396437876e-01 7.73905541877212693746557192753244e-02 3.66411219980447566690884286799701e-04 8.80744263450604494359100216094305e-05
 	 8.69166059567413662456658585142577e-01 1.30217416581926842544802980228269e-01 6.16523850659494998538434629153926e-04 1.86338500704725623354288122079936e-04
 	 8.04883578524966614153868249559309e-01 1.94196981709656407710795633647649e-01 9.19439765376978135336116793041583e-04 3.26332858952083863096627069921851e-04
 	 7.31348952734051316326713276794180e-01 2.67385093052565858684488375729416e-01 1.26595421338282498879834747640416e-03 5.02363858051214635762338200919430e-04
 	 6.50796558453382356645988693344407e-01 3.47557903319044347867361466342118e-01 1.64553822757329548664984031347558e-03 7.02100413428792275577494663707512e-04
 	 5.65673966886634405071276887611020e-01 4.32279374903031476939929689251585e-01 2.04665821033411798879342313739471e-03 9.07790861395817855195033985182818e-04
 	 4.78567596853079701979538640443934e-01 5.18975276869259816159285492176423e-01 2.45712627766048186117586737964302e-03 1.09821145635082884940703085163705e-03
 	 3.92124134722095840643873998487834e-01 6.05011394728863338698943152849097e-01 2.86447054904082065718284866306931e-03 1.25111733964995046688994939643180e-03
 	 3.08970117752195960747485514730215e-01 6.87773568155944148294622664252529e-01 3.25631409185989095789182101725601e-03 1.34590367837179891198629011483945e-03
 	 2.31632125777172293012995396566112e-01 7.64747123223716740447741813113680e-01 3.62075099911096653926279032020830e-03 1.36615670203144739559830700414977e-03
 	 1.62460003428136490200017760798801e-01 8.33593288385436226306524076790083e-01 3.94670818642728349345816241111606e-03 1.30178506092443473270148235343413e-03
 	 1.03555432935197089250323188025504e-01 8.92220285089023512625772127648816e-01 4.22428197577939812390468432568014e-03 1.15047029088208383612590424149857e-03
 	 5.67079687690783540432448717183433e-02 9.38846991713896961151419873203849e-01 4.44503951702468480533525507780723e-03 9.18256816481300211507665665067179e-04
 	 2.33400941237742465261817415012047e-02 9.72057628180051036537179243168794e-01 4.60227769617471693663901533000171e-03 6.19221115702019782485454602038999e-04
 	 4.45799356778742161822037814999931e-03 9.90850751324635070638180422974983e-01 4.69125510757750774359919887501746e-03 2.74631479211557270360410942799945e-04
 	 9.88714040632243551520730306947371e-01 1.10076223391797102524325424610652e-02 2.78337028576738226837150591563841e-04 1.18193291013472480041873041711753e-05
 	 9.62501197823349974314055543800350e-01 3.65739977508202918077273579910980e-02 9.24804425829733878217098208551761e-04 6.94732340032251259251405706152127e-05
 	 9.22243034592298283058653396437876e-01 7.58393045339122856551838935956766e-02 1.91766087378943128616270996644744e-03 2.02273686129011021767043487784576e-04
 	 8.69166059567413662456658585142577e-01 1.27607282509199615461170651542488e-01 3.22665792338672208217076331493445e-03 4.27949144484119010142103567417848e-04
 	 8.04883578524966614153868249559309e-01 1.90304413633232805125317099737003e-01 4.81200784180058072081465070368722e-03 7.49463300807052569540989139795784e-04
 	 7.31348952734051316326713276794180e-01 2.62025510899615121651606841624016e-01 6.62553636633356202167988158180378e-03 1.15374000788719750960897858504950e-03
 	 6.50796558453382356645988693344407e-01 3.40591302771198867205271199054550e-01 8.61213877541877614874010760104284e-03 1.61245942267677607254161564753758e-03
 	 5.65673966886634405071276887611020e-01 4.23614580630586712306495655866456e-01 1.07114524827788826222274565225234e-02 2.08485267958898783449694924740925e-03
 	 4.78567596853079701979538640443934e-01 5.08572712537880611272100850328570e-01 1.28596906090396867483605092274956e-02 2.52217685250526830673112321790086e-03
 	 3.92124134722095840643873998487834e-01 5.92884285335808391970147113170242e-01 1.49915799420957673859788883419242e-02 2.87334390438650187638014443791690e-03
 	 3.08970117752195960747485514730215e-01 6.73987538055772605893878335336922e-01 1.70423441920314333586361499328632e-02 3.09103231773847318686332386050708e-03
 	 2.31632125777172293012995396566112e-01 7.49418201979986653427090459445026e-01 1.89496722428410535599141439888626e-02 3.13754586225870870860865657903105e-03
 	 1.62460003428136490200017760798801e-01 8.16884384907515803675437382480595e-01 2.06556116643477061245448567206040e-02 2.98970851980612890505528689288894e-03
 	 1.03555432935197089250323188025504e-01 8.74336236797955690391859207011294e-01 2.21083302668472203578176049632020e-02 2.64219565401331612022883810197982e-03
 	 5.67079687690783540432448717183433e-02 9.20028337600849344113385086529888e-01 2.32636936300723018433700417517684e-02 2.10888902477853476882807548520304e-03
 	 2.33400941237742465261817415012047e-02 9.52573285742871034287304610188585e-01 2.40866201333547191865136483102106e-02 1.42211698446096084652578994678152e-03
 	 4.45799356778742161822037814999931e-03 9.70989711419941059489246981684119e-01 2.45522950122715188925326401658822e-02 6.30724762367981610887424093192521e-04
 	 9.88714040632243551520730306947371e-01 1.06101513453137653864022382776966e-02 6.75808022442683092867454774932412e-04 1.81225883778079216337823786897587e-05
 	 9.62501197823349974314055543800350e-01 3.52533580352000497359910013983608e-02 2.24544414144997594995345480128890e-03 1.06523374746546697390547908668168e-04
 	 9.22243034592298283058653396437876e-01 7.31008454172777932811300161120016e-02 4.65611999042392366021658745012246e-03 3.10146432335160098566623210203375e-04
 	 8.69166059567413662456658585142577e-01 1.22999548718866508201230658414715e-01 7.83439171371982934211075644270750e-03 6.56174823936217250369695719314223e-04
 	 8.04883578524966503131565787043655e-01 1.83432767596227369599759526863636e-01 1.16836538788061272686746860927087e-02 1.14915278086733874465807936360306e-03
 	 7.31348952734051316326713276794180e-01 2.52564108879597903900560140755260e-01 1.60869383863507797727265824505594e-02 1.76903063436698970538329955815016e-03
 	 6.50796558453382356645988693344407e-01 3.28292991706081671576811231716420e-01 2.09104498405359717772000749391736e-02 2.47238554257348669418448139367683e-03
 	 5.65673966886634405071276887611020e-01 4.08318406471336659002702162979404e-01 2.60076266420289359260209494095761e-02 3.19670656570975259339051355311767e-03
 	 4.78567596853079757490689871701761e-01 4.90208810209396939061576858875924e-01 3.12235929375232479365820381644880e-02 3.86725612951905987901835004549866e-03
 	 3.92124134722095840643873998487834e-01 5.71476001250592835489783283264842e-01 3.63998640273113238663427182473242e-02 4.40570089897441685006240774669095e-03
 	 3.08970117752195960747485514730215e-01 6.49650720498834877147942279407289e-01 4.13791617489691621045722058624960e-02 4.73948274699370879908810749725490e-03
 	 2.31632125777172293012995396566112e-01 7.22357680789866285486766628309852e-01 4.60101934329614215002379751240369e-02 4.81080200835829786820685427528588e-03
 	 1.62460003428136490200017760798801e-01 7.87387747183391661920381920936052e-01 5.01522493884718478796003182651475e-02 4.58412287275222155719101024828888e-03
 	 1.03555432935197089250323188025504e-01 8.42765087070539653524292589281686e-01 5.36794799942632572253842226928100e-02 4.05128107024773937566708426061268e-03
 	 5.67079687690783540432448717183433e-02 8.86807305259518785511829719325760e-01 5.64847259714028604449254089558963e-02 3.23356151629467262684225481450540e-03
 	 2.33400941237742465261817415012047e-02 9.18177097451896129243209543346893e-01 5.84828084243296242306087151519023e-02 2.18053330383513382581539552518279e-03
 	 4.45799356778742161822037814999931e-03 9.35928529836884459669477109855507e-01 5.96134765953281187123025119944941e-02 9.67090868701061482509695466092126e-04
 	 9.88714040632243551520730306947371e-01 1.00530473305342014228580538315327e-02 1.23291203722224705641163922109627e-03 2.38442703360542191033145942302696e-05
 	 9.62501197823349974314055543800350e-01 3.34023206035289413340372277616552e-02 4.09648157312108435190722843799449e-03 1.40155042514556154708421642496319e-04
 	 9.22243034592298283058653396437876e-01 6.92625613871698797563425387124880e-02 8.49440402053183718500406484963605e-03 4.08066178086246330713321439631613e-04
 	 8.69166059567413662456658585142577e-01 1.16541248532826241524062993448752e-01 1.42926918997600960192784214086714e-02 8.63343003961140474829261126643587e-04
 	 8.04883578524966614153868249559309e-01 1.73801318624001333024153836959158e-01 2.13151028510320528219779134815326e-02 1.51196446077111893227518102378326e-03
 	 7.31348952734051316326713276794180e-01 2.39302801432914546975183611721150e-01 2.93482458330341366981031114846701e-02 2.32755077802579120674342227914622e-03
 	 6.50796558453382356645988693344407e-01 3.11055410662128717369512287405087e-01 3.81480308844889259844990192505065e-02 3.25296961024973971601803590658619e-03
 	 5.65673966886634405071276887611020e-01 3.86878955124203338655775041843299e-01 4.74470779891622562729480705456808e-02 4.20597400044477737202086586876248e-03
 	 4.78567596853079757490689871701761e-01 4.64469564145900515317322287955903e-01 5.69628390010196716808366090845084e-02 5.08823015171130672157362440088946e-03
 	 3.92124134722095840643873998487834e-01 5.41469683311735838771028284099884e-01 6.64061819661683205850977174122818e-02 5.79667324914708795985385236804177e-03
 	 3.08970117752195960747485514730215e-01 6.15539706167810285464270236843731e-01 7.54901760799937537882442484260537e-02 6.23583704029657525519381167100619e-03
 	 2.31632125777172293012995396566112e-01 6.84429064036191858733104709244799e-01 8.39388101866358482538998941890895e-02 6.32967329109546117393847453058697e-03
 	 1.62460003428136490200017760798801e-01 7.46044616358226941876807813969208e-01 9.14953802136365679231744252319913e-02 6.03142678920210676546398431696616e-03
 	 1.03555432935197089250323188025504e-01 7.98514274971575899186859714973252e-01 9.79302920932270115628170970012434e-02 5.33035563311793931379201083586850e-03
 	 5.67079687690783540432448717183433e-02 8.40243981701072950585285070701502e-01 1.03048049529848695371470057580154e-01 4.25446483335719174978528656083654e-03
 	 2.33400941237742465261817415012047e-02 8.69966649681514048175756670389092e-01 1.06693256194711705298061588109704e-01 2.86897348709210138484326790830892e-03
 	 4.45799356778742161822037814999931e-03 8.86786012963253100771510162303457e-01 1.08755993468959477610269459546544e-01 1.27242177729287885869224883350626e-03
 	 9.88714040632243551520730306947371e-01 9.35420467401065075518928892961412e-03 1.93175469374579772408040412301489e-03 2.87997613849133450960367935911322e-05
 	 9.62501197823349974314055543800350e-01 3.10803414367024077868961740023224e-02 6.41846073994761789904828219732735e-03 1.69283090839992400719257736874113e-04
 	 9.22243034592298283058653396437876e-01 6.44477394922785135067400119623926e-02 1.33092259154232034346065915997315e-02 4.92873482497272288362089032176527e-04
 	 8.69166059567413662456658585142577e-01 1.08439824850886434859376095118932e-01 2.23941155816999026839653197384905e-02 1.04276927567873226032624245362967e-03
 	 8.04883578524966503131565787043655e-01 1.61719432284365555174687756334606e-01 3.33969891906679416937464566217386e-02 1.82619199828629131740487245849636e-03
 	 7.31348952734051316326713276794180e-01 2.22667546473061583878205738074030e-01 4.59835007928870997950809851317899e-02 2.81127944255244030177798286729285e-03
 	 6.50796558453382356645988693344407e-01 2.89432236875519777186127612367272e-01 5.97712046710978661678836942883208e-02 3.92902560016311803992028472976017e-03
 	 5.65673966886634405071276887611020e-01 3.59984869394509798823378332599532e-01 7.43411637188557961053447797894478e-02 5.08009034861512612929468346578687e-03
 	 4.78567596853079701979538640443934e-01 4.32181728088850136693110925989458e-01 8.92506750580701613273504335666075e-02 6.14570344051285598341305416170144e-03
 	 3.92124134722095840643873998487834e-01 5.03829145127536182080518756265519e-01 1.04046720150367977275607245246647e-01 7.00138037561657579355145486488254e-03
 	 3.08970117752195960747485514730215e-01 5.72750152979545346099143898754846e-01 1.18279729268258693153370586514939e-01 7.53181440508128834804280060666315e-03
 	 2.31632125777172293012995396566112e-01 6.36850632383909598388527228962630e-01 1.31517241838918108598477374471258e-01 7.64515239337680303083333299696278e-03
 	 1.62460003428136490200017760798801e-01 6.94182948503812125018441747670295e-01 1.43357048068051384781540491530905e-01 7.28492211719905437966593453325004e-03
 	 1.03555432935197089250323188025504e-01 7.43005152329908158392868244845886e-01 1.53439414734894752356808567128610e-01 6.43814921433779035336852913928851e-03
 	 5.67079687690783540432448717183433e-02 7.81833997445214423649417767592240e-01 1.61458033785707222307337360689417e-01 5.13865890187974877489907044036954e-03
 	 2.33400941237742465261817415012047e-02 8.09490479167153664796785506041488e-01 1.67169426709072088677032752457308e-01 3.46522458785242497975032094359449e-03
 	 4.45799356778742161822037814999931e-03 8.25140635925698084918167296564206e-01 1.70401370506514493463612325285794e-01 1.53686579838812524892444066892949e-03
 	 9.88714040632243551520730306947371e-01 8.53608196877382943701384476753447e-03 2.74987739898261904225584828509454e-03 3.28296609687482265319165286587832e-05
 	 9.62501197823349974314055543800350e-01 2.83620416023481411449402855851076e-02 9.13676057430188454100417061454209e-03 1.92970573809338549363043280315821e-04
 	 9.22243034592298283058653396437876e-01 5.88111128823954679156749136836879e-02 1.89458525253062490256716898784362e-02 5.61840395641194584666622269253367e-04
 	 8.69166059567413662456658585142577e-01 9.89556318110546007105199350917246e-02 3.18783086215317368328214797656983e-02 1.18868213286979431016210373428521e-03
 	 8.04883578524966503131565787043655e-01 1.47575382197729892963522502213891e-01 4.75410392773036039049117107424536e-02 2.08172780900143508317490237402581e-03
 	 7.31348952734051316326713276794180e-01 2.03192948488786218064205968403257e-01 6.54580987771624656090807548025623e-02 3.20465679398842769390332030354784e-03
 	 6.50796558453382356645988693344407e-01 2.64118370772799648804607386409771e-01 8.50850707738179945494039202458225e-02 4.47880719103658717084037732547586e-03
 	 5.65673966886634405071276887611020e-01 3.28500440150448047571529741617269e-01 1.05825592962917547357193370771711e-01 5.79093839030938879047782918974008e-03
 	 4.78567596853079701979538640443934e-01 3.94382930985303636894911960553145e-01 1.27049472161616661125549399002921e-01 7.00566083412755644804770227551671e-03
 	 3.92124134722095840643873998487834e-01 4.59764034564569934460109834617469e-01 1.48111830713334224896016166894697e-01 7.98107112669159055040601913333376e-03
 	 3.08970117752195960747485514730215e-01 5.22657181860117892036043940606760e-01 1.68372700387686147216470544663025e-01 8.58572785008846449394948052713517e-03
 	 2.31632125777172293012995396566112e-01 5.81151406169062023643334669031901e-01 1.87216468053765683343669934401987e-01 8.71492502227652447721606421282559e-03
 	 1.62460003428136490200017760798801e-01 6.33469413622849253364677224453771e-01 2.04070582949014256435305014747428e-01 8.30428836180095546193324906880662e-03
 	 1.03555432935197089250323188025504e-01 6.78021606810755628202969091944396e-01 2.18422960254047282546707720030099e-01 7.33902802693510436515822448200197e-03
 	 5.67079687690783540432448717183433e-02 7.13454464676048449867096223897533e-01 2.29837566554873196089658904384123e-01 5.85770233746191193446861689153593e-03
 	 2.33400941237742465261817415012047e-02 7.38692098785368123081696012377506e-01 2.37967807090857630392122246121289e-01 3.95010732482524440367654960937216e-03
 	 4.45799356778731059591791563434526e-03 7.52973486201046426913308096118271e-01 2.42568520231166262490773988247383e-01 1.75191670657303712188568312058123e-03
 	 9.88714040632243551520730306947371e-01 7.62497338938117157070006868480050e-03 3.66098597837527690856962436782851e-03 3.58044108231257265429793579247786e-05
 	 9.62501197823349974314055543800350e-01 2.53347862962814349141460468217701e-02 1.21640158803685907717984093778796e-02 2.10455956521177141608711091969042e-04
 	 9.22243034592298283058653396437876e-01 5.25338407443354249437561520608142e-02 2.52231246633662919975904515013099e-02 6.12749682724848874874890025665763e-04
 	 8.69166059567413662456658585142577e-01 8.83934880251715238141940744753811e-02 4.24404524074148137291473403820419e-02 1.29639058605856291941926805577623e-03
 	 8.04883578524966503131565787043655e-01 1.31823753134259619157475640349730e-01 6.32926683407738777109585726066143e-02 2.27035660728770434871326422410220e-03
 	 7.31348952734051316326713276794180e-01 1.81504914175449283408880774004501e-01 8.71461330904994002644059492013184e-02 3.49503604403069356373889853273340e-03
 	 6.50796558453382356645988693344407e-01 2.35927391062599411952760419808328e-01 1.13276050484018231401250886847265e-01 4.88463931498096717159773660910105e-03
 	 5.65673966886634405071276887611020e-01 2.93437565818849832588455228687963e-01 1.40888467294515762340267883701017e-01 6.31566489143532434208383463669634e-03
 	 4.78567596853079701979538640443934e-01 3.52288012813102846543245050270343e-01 1.69144390333817451477216309285723e-01 7.64045534406713761771401394184977e-03
 	 3.92124134722095896155025229745661e-01 4.10690588700256709042690772548667e-01 1.97185276577647450313435228963499e-01 8.70424917578880436019872490760463e-03
 	 3.08970117752195960747485514730215e-01 4.66870763194512372606936878582928e-01 2.24159119053291666645577606686857e-01 9.36369484451123230972502398117285e-03
 	 2.31632125777172293012995396566112e-01 5.19121538833708928706300866906531e-01 2.49246335389118778280703736527357e-01 9.50459878606003255585576994235453e-03
 	 1.62460003428136490200017760798801e-01 5.65855323265476384264616172004025e-01 2.71684673306387125535366067197174e-01 9.05675365891419996422495586330115e-03
 	 1.03555432935197089250323188025504e-01 6.05652186596810193641715613921406e-01 2.90792380467992717107961198053090e-01 8.00402948933765824579555925311070e-03
 	 5.67079687690783540432448717183433e-02 6.37303077406073725796886719763279e-01 3.05988953824847920159868408518378e-01 6.38847843021350236120126098171568e-03
 	 2.33400941237742465261817415012047e-02 6.59846943455914658471783695858903e-01 3.16812962420311095002034562639892e-01 4.30803307984553573994901398691582e-03
 	 4.45799356778731059591791563434526e-03 6.72603990471904555903392974869348e-01 3.22938015960308133500689109496307e-01 1.91066077562451752669403504114598e-03
 	 9.88714040632243551520730306947371e-01 6.65016229395292649689830355441700e-03 4.63579707380352198237138949821201e-03 3.76283885801511895391642525954268e-05
 	 9.62501197823349974314055543800350e-01 2.20958725951120593666843205937766e-02 1.54029295815379663192601356058731e-02 2.21177177027344741902514790865553e-04
 	 9.22243034592298283058653396437876e-01 4.58176768670481501799507384475874e-02 3.19392885406535667613958651145367e-02 6.43964881249848935217128254038244e-04
 	 8.69166059567413662456658585142577e-01 7.70928646012865037562278303084895e-02 5.37410758312998337871135845489334e-02 1.36243238200010538530015935521078e-03
 	 8.04883578524966614153868249559309e-01 1.14970808129201809699715397528053e-01 8.01456133458315761464163529126381e-02 2.38601498168927034226882710754580e-03
 	 7.31348952734051316326713276794180e-01 1.58300504772606903669540656665049e-01 1.10350542493341780003746066540771e-01 3.67308304599942231707943030016850e-03
 	 6.50796558453382356645988693344407e-01 2.05765365993299392810556014410395e-01 1.43438075553318250543455292245199e-01 5.13347663018300440218588676088984e-03
 	 5.65673966886634405071276887611020e-01 2.55923179817971524485642476065550e-01 1.78402853295394070443080636323430e-01 6.63740268904109385894596329080741e-03
 	 4.78567596853079701979538640443934e-01 3.07249919414005590034832948731491e-01 2.14182483732914707985628410824575e-01 8.02968170698563181442164449208576e-03
 	 3.92124134722095840643873998487834e-01 3.58186045771555550132347889302764e-01 2.49689819506348609223778112209402e-01 9.14766819940227536578358780161579e-03
 	 3.08970117752195960747485514730215e-01 4.07183892584987661145135007245699e-01 2.83845989662816378107379478024086e-01 9.84070789199115864009925758182362e-03
 	 2.31632125777172293012995396566112e-01 4.52754692670596758929946190619376e-01 3.15613181552230948057058412814513e-01 9.98878987807005382093539225252243e-03
 	 1.62460003428136545711168992056628e-01 4.93513818665013814790398782861303e-01 3.44026177906849695009583456339897e-01 9.51813025595762279840172936928866e-03
 	 1.03555432935197089250323188025504e-01 5.28222870936881916392735547560733e-01 3.68221696127920994356941264413763e-01 8.41177734552353041641570285946727e-03
 	 5.67079687690783540432448717183433e-02 5.55827368668364130144254886545241e-01 3.87464662562557515812500241736416e-01 6.71392555502473269840590930357394e-03
 	 2.33400941237742465261817415012047e-02 5.75489124888177716599102495820262e-01 4.01170780988048036874715762678534e-01 4.52749644576951569552303311638752e-03
 	 4.45799356778742161822037814999931e-03 5.86615253297499972262585288262926e-01 4.08926753134712606119194333587075e-01 2.00799522900167509362190365607148e-03
 	 9.88714040632243662543032769463025e-01 5.64297968387822423963484652631450e-03 5.64297968387811321733238401066046e-03 3.82429658735971918941988489937245e-05
 	 9.62501197823349974314055543800350e-01 1.87494010883250128429722280998249e-02 1.87494010883250128429722280998249e-02 2.24789621672428385117450955199558e-04
 	 9.22243034592298283058653396437876e-01 3.88784827038508584706733017810620e-02 3.88784827038508584706733017810620e-02 6.54482636825530852443810747587349e-04
 	 8.69166059567413551434356122626923e-01 6.54169702162931687716707074287115e-02 6.54169702162932797939731699443655e-02 1.38468473022515005388388686924372e-03
 	 8.04883578524966614153868249559309e-01 9.75582107375167206786414908492588e-02 9.75582107375166651674902595914318e-02 2.42498530927703556669960960334720e-03
 	 7.31348952734051316326713276794180e-01 1.34325523632974341836643361602910e-01 1.34325523632974341836643361602910e-01 3.73307481078638146373971373748191e-03
 	 6.50796558453382356645988693344407e-01 1.74601720773308821677005653327797e-01 1.74601720773308821677005653327797e-01 5.21732072482516441580546739942292e-03
 	 5.65673966886634405071276887611020e-01 2.17163016556682797464361556194490e-01 2.17163016556682797464361556194490e-01 6.74581012114393568229742115249792e-03
 	 4.78567596853079757490689871701761e-01 2.60716201573460149010230679778033e-01 2.60716201573460037987928217262379e-01 8.16082896672545507477103399196494e-03
 	 3.92124134722095840643873998487834e-01 3.03937932638952079678063000756083e-01 3.03937932638952079678063000756083e-01 9.29707531927815092331890411969653e-03
 	 3.08970117752195960747485514730215e-01 3.45514941123902019626257242634892e-01 3.45514941123902019626257242634892e-01 1.00014342969757964035837360938785e-02
 	 2.31632125777172293012995396566112e-01 3.84183937111413853493502301716944e-01 3.84183937111413853493502301716944e-01 1.01519348778881801642626214743359e-02
 	 1.62460003428136490200017760798801e-01 4.18769998285931754899991119600600e-01 4.18769998285931754899991119600600e-01 9.67358806194133780120836263449746e-03
 	 1.03555432935197089250323188025504e-01 4.48222283532401455374838405987248e-01 4.48222283532401455374838405987248e-01 8.54916530044672572097308460570275e-03
 	 5.67079687690783540432448717183433e-02 4.71646015615460822978377564140828e-01 4.71646015615460822978377564140828e-01 6.82358282050172463423232116497275e-03
 	 2.33400941237742465261817415012047e-02 4.88329952938112876736909129249398e-01 4.88329952938112876736909129249398e-01 4.60144318164422676947777901546033e-03
 	 4.45799356778747712937160940782633e-03 4.97771003216106289190889810925000e-01 4.97771003216106178168587348409346e-01 2.04079143207222882261397955971916e-03
 	 9.88714040632243551520730306947371e-01 4.63579707380352371709486547501911e-03 6.65016229395292476217482757760990e-03 3.76283885801510743426834260105807e-05
 	 9.62501197823349974314055543800350e-01 1.54029295815379732581540395131015e-02 2.20958725951120524277904166865483e-02 2.21177177027344091381211299562892e-04
 	 9.22243034592298283058653396437876e-01 3.19392885406535806391836729289935e-02 4.58176768670481363021629306331306e-02 6.43964881249847092073435028680706e-04
 	 8.69166059567413662456658585142577e-01 5.37410758312998615426892001778469e-02 7.70928646012864760006522146795760e-02 1.36243238200010126533190391029393e-03
 	 8.04883578524966503131565787043655e-01 8.01456133458316594131431997993786e-02 1.14970808129201837455291013156966e-01 2.38601498168926340337492320031743e-03
 	 7.31348952734051316326713276794180e-01 1.10350542493341807759321682169684e-01 1.58300504772606875913965041036136e-01 3.67308304599941147505770544512416e-03
 	 6.50796558453382356645988693344407e-01 1.43438075553318306054606523503026e-01 2.05765365993299337299404783152568e-01 5.13347663018298878967460296962599e-03
 	 5.65673966886634405071276887611020e-01 1.78402853295394125954231867581257e-01 2.55923179817971468974491244807723e-01 6.63740268904107390962598955752583e-03
 	 4.78567596853079757490689871701761e-01 2.14182483732914763496779642082402e-01 3.07249919414005423501379254958010e-01 8.02968170698560752829298081678644e-03
 	 3.92124134722095840643873998487834e-01 2.49689819506348720246080574725056e-01 3.58186045771555439110045426787110e-01 9.14766819940224761020797217270228e-03
 	 3.08970117752195960747485514730215e-01 2.83845989662816489129681940539740e-01 4.07183892584987550122832544730045e-01 9.84070789199112914980016597610302e-03
 	 2.31632125777172293012995396566112e-01 3.15613181552231059079360875330167e-01 4.52754692670596647907643728103722e-01 9.98878987807002433063630064680183e-03
 	 1.62460003428136490200017760798801e-01 3.44026177906849861543037150113378e-01 4.93513818665013648256945089087822e-01 9.51813025595759504282611374037515e-03
 	 1.03555432935197089250323188025504e-01 3.68221696127921216401546189445071e-01 5.28222870936881694348130622529425e-01 8.41177734552350613028703918416795e-03
 	 5.67079687690783540432448717183433e-02 3.87464662562557626834802704252070e-01 5.55827368668364019121952424029587e-01 6.71392555502471274908593557029235e-03
 	 2.33400941237742465261817415012047e-02 4.01170780988048147897018225194188e-01 5.75489124888177605576800033304607e-01 4.52749644576950181773522530193077e-03
 	 4.45799356778742161822037814999931e-03 4.08926753134712717141496796102729e-01 5.86615253297499861240282825747272e-01 2.00799522900166945577060673144842e-03
 	 9.88714040632243551520730306947371e-01 3.66098597837527864329310034463560e-03 7.62497338938116983597659270799340e-03 3.58044108231256994379250457871677e-05
 	 9.62501197823349974314055543800350e-01 1.21640158803685942412453613314938e-02 2.53347862962814314446990948681560e-02 2.10455956521176978978385219143377e-04
 	 9.22243034592298283058653396437876e-01 2.52231246633662989364843554085382e-02 5.25338407443354180048622481535858e-02 6.12749682724848332773803782913546e-04
 	 8.69166059567413662456658585142577e-01 4.24404524074148276069351481964986e-02 8.83934880251715099364062666609243e-02 1.29639058605856183521709557027179e-03
 	 8.04883578524966503131565787043655e-01 6.32926683407738499553829569777008e-02 1.31823753134259646913051255978644e-01 2.27035660728770218030891925309334e-03
 	 7.31348952734051316326713276794180e-01 8.71461330904994557755571804591455e-02 1.81504914175449227897729542746674e-01 3.49503604403069052797281557332099e-03
 	 6.50796558453382356645988693344407e-01 1.13276050484018286912402118105092e-01 2.35927391062599356441609188550501e-01 4.88463931498096283478904666708331e-03
 	 5.65673966886634405071276887611020e-01 1.40888467294515762340267883701017e-01 2.93437565818849832588455228687963e-01 6.31566489143531913791340670627505e-03
 	 4.78567596853079757490689871701761e-01 1.69144390333817506988367540543550e-01 3.52288012813102680009791356496862e-01 7.64045534406713067882011003462139e-03
 	 3.92124134722095840643873998487834e-01 1.97185276577647505824586460221326e-01 4.10690588700256653531539541290840e-01 8.70424917578879742130482100037625e-03
 	 3.08970117752195905236334283472388e-01 2.24159119053291722156728837944684e-01 4.66870763194512317095785647325101e-01 9.36369484451122537083112007394448e-03
 	 2.31632125777172293012995396566112e-01 2.49246335389118889303006199043011e-01 5.19121538833708817683998404390877e-01 9.50459878606002388223839005831906e-03
 	 1.62460003428136490200017760798801e-01 2.71684673306387236557668529712828e-01 5.65855323265476273242313709488371e-01 9.05675365891419302533105195607277e-03
 	 1.03555432935197089250323188025504e-01 2.90792380467992828130263660568744e-01 6.05652186596810082619413151405752e-01 8.00402948933765130690165534588232e-03
 	 5.67079687690783540432448717183433e-02 3.05988953824848142204473333549686e-01 6.37303077406073503752281794731971e-01 6.38847843021349715703083305129439e-03
 	 2.33400941237742465261817415012047e-02 3.16812962420311095002034562639892e-01 6.59846943455914658471783695858903e-01 4.30803307984553227050206203330163e-03
 	 4.45799356778742161822037814999931e-03 3.22938015960308244522991572011961e-01 6.72603990471904333858788049838040e-01 1.91066077562451579197055906433889e-03
 	 9.88714040632243551520730306947371e-01 2.74987739898261904225584828509454e-03 8.53608196877382943701384476753447e-03 3.28296609687482807420251529340050e-05
 	 9.62501197823349974314055543800350e-01 9.13676057430188107155721866092790e-03 2.83620416023481446143872375387218e-02 1.92970573809338847518640713829541e-04
 	 9.22243034592298283058653396437876e-01 1.89458525253062490256716898784362e-02 5.88111128823954679156749136836879e-02 5.61840395641195452028360257656914e-04
 	 8.69166059567413662456658585142577e-01 3.18783086215317507106092875801551e-02 9.89556318110545868327321272772679e-02 1.18868213286979626172601420819319e-03
 	 8.04883578524966503131565787043655e-01 4.75410392773035483937604794846266e-02 1.47575382197729948474673733471718e-01 2.08172780900143811894098533343822e-03
 	 7.31348952734051316326713276794180e-01 6.54580987771624378535051391736488e-02 2.03192948488786245819781584032171e-01 3.20465679398843289807374823396913e-03
 	 6.50796558453382356645988693344407e-01 8.50850707738179945494039202458225e-02 2.64118370772799648804607386409771e-01 4.47880719103659410973428123270423e-03
 	 5.65673966886634405071276887611020e-01 1.05825592962917547357193370771711e-01 3.28500440150448047571529741617269e-01 5.79093839030939833145694706217910e-03
 	 4.78567596853079646468387409186107e-01 1.27049472161616605614398167745094e-01 3.94382930985303803428365654326626e-01 7.00566083412756772375029612476283e-03
 	 3.92124134722095840643873998487834e-01 1.48111830713334224896016166894697e-01 4.59764034564569934460109834617469e-01 7.98107112669160269347035097098342e-03
 	 3.08970117752195960747485514730215e-01 1.68372700387686147216470544663025e-01 5.22657181860117892036043940606760e-01 8.58572785008847837173728834159192e-03
 	 2.31632125777172293012995396566112e-01 1.87216468053765683343669934401987e-01 5.81151406169062023643334669031901e-01 8.71492502227653835500387202728234e-03
 	 1.62460003428136490200017760798801e-01 2.04070582949014256435305014747428e-01 6.33469413622849253364677224453771e-01 8.30428836180096933972105688326337e-03
 	 1.03555432935197089250323188025504e-01 2.18422960254047282546707720030099e-01 6.78021606810755628202969091944396e-01 7.33902802693511650822255631965163e-03
 	 5.67079687690783540432448717183433e-02 2.29837566554873196089658904384123e-01 7.13454464676048449867096223897533e-01 5.85770233746192060808599677557140e-03
 	 2.33400941237742465261817415012047e-02 2.37967807090857630392122246121289e-01 7.38692098785368123081696012377506e-01 3.95010732482525047520871552819699e-03
 	 4.45799356778742161822037814999931e-03 2.42568520231166151468471525731729e-01 7.52973486201046426913308096118271e-01 1.75191670657303994081133158289276e-03
 	 9.88714040632243551520730306947371e-01 1.93175469374579772408040412301489e-03 9.35420467401065075518928892961412e-03 2.87997613849133146028506924363199e-05
 	 9.62501197823349974314055543800350e-01 6.41846073994761789904828219732735e-03 3.10803414367024077868961740023224e-02 1.69283090839992210983877551910837e-04
 	 9.22243034592298283058653396437876e-01 1.33092259154232034346065915997315e-02 6.44477394922785135067400119623926e-02 4.92873482497271746261002789424310e-04
 	 8.69166059567413662456658585142577e-01 2.23941155816999026839653197384905e-02 1.08439824850886434859376095118932e-01 1.04276927567873139296450446522613e-03
 	 8.04883578524966503131565787043655e-01 3.33969891906678861825952253639116e-02 1.61719432284365610685838987592433e-01 1.82619199828628958268139648168926e-03
 	 7.31348952734051316326713276794180e-01 4.59835007928870997950809851317899e-02 2.22667546473061583878205738074030e-01 2.81127944255243726601189990788043e-03
 	 6.50796558453382356645988693344407e-01 5.97712046710978661678836942883208e-02 2.89432236875519777186127612367272e-01 3.92902560016311457047333277614598e-03
 	 5.65673966886634405071276887611020e-01 7.43411637188557961053447797894478e-02 3.59984869394509798823378332599532e-01 5.08009034861512092512425553536559e-03
 	 4.78567596853079701979538640443934e-01 8.92506750580701613273504335666075e-02 4.32181728088850136693110925989458e-01 6.14570344051284991188088824287661e-03
 	 3.92124134722095840643873998487834e-01 1.04046720150367977275607245246647e-01 5.03829145127536182080518756265519e-01 7.00138037561656885465755095765417e-03
 	 3.08970117752195960747485514730215e-01 1.18279729268258693153370586514939e-01 5.72750152979545346099143898754846e-01 7.53181440508128054178715871103122e-03
 	 2.31632125777172293012995396566112e-01 1.31517241838918108598477374471258e-01 6.36850632383909598388527228962630e-01 7.64515239337679522457769110133086e-03
 	 1.62460003428136490200017760798801e-01 1.43357048068051384781540491530905e-01 6.94182948503812125018441747670295e-01 7.28492211719904657341029263761811e-03
 	 1.03555432935197089250323188025504e-01 1.53439414734894752356808567128610e-01 7.43005152329908158392868244845886e-01 6.43814921433778341447462523206013e-03
 	 5.67079687690783540432448717183433e-02 1.61458033785707222307337360689417e-01 7.81833997445214423649417767592240e-01 5.13865890187974357072864250994826e-03
 	 2.33400941237742465261817415012047e-02 1.67169426709072088677032752457308e-01 8.09490479167153664796785506041488e-01 3.46522458785242151030336898998030e-03
 	 4.45799356778742161822037814999931e-03 1.70401370506514493463612325285794e-01 8.25140635925698084918167296564206e-01 1.53686579838812373104139918922328e-03
 	 9.88714040632243551520730306947371e-01 1.23291203722224532168816324428917e-03 1.00530473305342031575815298083398e-02 2.38442703360542292677099612818736e-05
 	 9.62501197823349974314055543800350e-01 4.09648157312108435190722843799449e-03 3.34023206035289413340372277616552e-02 1.40155042514556208918530266771540e-04
 	 9.22243034592298283058653396437876e-01 8.49440402053182330721625703517930e-03 6.92625613871698936341303465269448e-02 4.08066178086246439133538688182057e-04
 	 8.69166059567413662456658585142577e-01 1.42926918997600821414906135942147e-02 1.16541248532826255401850801263208e-01 8.63343003961140800089912872294917e-04
 	 8.04883578524966503131565787043655e-01 2.13151028510320805775535291104461e-02 1.73801318624001416290880683845899e-01 1.51196446077111936595605001798504e-03
 	 7.31348952734051316326713276794180e-01 2.93482458330341089425274958557566e-02 2.39302801432914574730759227350063e-01 2.32755077802579207410516026754976e-03
 	 6.50796558453382356645988693344407e-01 3.81480308844888704733477879926795e-02 3.11055410662128772880663518662914e-01 3.25296961024974101706064288919151e-03
 	 5.65673966886634405071276887611020e-01 4.74470779891622007617968392878538e-02 3.86878955124203394166926273101126e-01 4.20597400044477823938260385716603e-03
 	 4.78567596853079701979538640443934e-01 5.69628390010197271919878403423354e-02 4.64469564145900570828473519213730e-01 5.08823015171130845629710037769655e-03
 	 3.92124134722095840643873998487834e-01 6.64061819661682095627952548966277e-02 5.41469683311735949793330746615538e-01 5.79667324914708969457732834484887e-03
 	 3.08970117752195960747485514730215e-01 7.54901760799936427659417859103996e-02 6.15539706167810396486572699359385e-01 6.23583704029657785727902563621683e-03
 	 2.31632125777172293012995396566112e-01 8.39388101866357372315974316734355e-02 6.84429064036191969755407171760453e-01 6.32967329109546377602368849579761e-03
 	 1.62460003428136490200017760798801e-01 9.14953802136364569008719627163373e-02 7.46044616358227052899110276484862e-01 6.03142678920210850018746029377326e-03
 	 1.03555432935197089250323188025504e-01 9.79302920932270115628170970012434e-02 7.98514274971575899186859714973252e-01 5.33035563311794104851548681267559e-03
 	 5.67079687690783540432448717183433e-02 1.03048049529848584349167595064500e-01 8.40243981701073061607587533217156e-01 4.25446483335719348450876253764363e-03
 	 2.33400941237742465261817415012047e-02 1.06693256194711594275759125594050e-01 8.69966649681514159198059132904746e-01 2.86897348709210268588587489091424e-03
 	 4.45799356778742161822037814999931e-03 1.08755993468959366587966997030890e-01 8.86786012963253211793812624819111e-01 1.27242177729287929237311782770803e-03
 	 9.88714040632243551520730306947371e-01 6.75808022442681358143978798125318e-04 1.06101513453137671211257142545037e-02 1.81225883778079555151002688617723e-05
 	 9.62501197823349974314055543800350e-01 2.24544414144997594995345480128890e-03 3.52533580352000497359910013983608e-02 1.06523374746546887125928093631444e-04
 	 9.22243034592298283058653396437876e-01 4.65611999042390978242877963566571e-03 7.31008454172778071589178239264584e-02 3.10146432335160640667709452955592e-04
 	 8.69166059567413662456658585142577e-01 7.83439171371981546432294862825074e-03 1.22999548718866522079018466229172e-01 6.56174823936218334571868204818657e-04
 	 8.04883578524966614153868249559309e-01 1.16836538788060440019478392059682e-02 1.83432767596227341844183911234722e-01 1.14915278086734091306242433461193e-03
 	 7.31348952734051316326713276794180e-01 1.60869383863507242615753511927323e-02 2.52564108879597959411711372013087e-01 1.76903063436699295798981701466346e-03
 	 6.50796558453382356645988693344407e-01 2.09104498405359717772000749391736e-02 3.28292991706081671576811231716420e-01 2.47238554257349103099317133569457e-03
 	 5.65673966886634405071276887611020e-01 2.60076266420288804148697181517491e-02 4.08318406471336714513853394237231e-01 3.19670656570975823124181047774073e-03
 	 4.78567596853079701979538640443934e-01 3.12235929375233034477332694223151e-02 4.90208810209396994572728090133751e-01 3.86725612951906681791225395272704e-03
 	 3.92124134722095840643873998487834e-01 3.63998640273112128440402557316702e-02 5.71476001250592946512085745780496e-01 4.40570089897442465631804964232288e-03
 	 3.08970117752195960747485514730215e-01 4.13791617489690510822697433468420e-02 6.49650720498834988170244741922943e-01 4.73948274699371747270548738129037e-03
 	 2.31632125777172293012995396566112e-01 4.60101934329613104779355126083829e-02 7.22357680789866396509069090825506e-01 4.81080200835830654182423415932135e-03
 	 1.62460003428136490200017760798801e-01 5.01522493884718478796003182651475e-02 7.87387747183391661920381920936052e-01 4.58412287275223023080839013232435e-03
 	 1.03555432935197089250323188025504e-01 5.36794799942632572253842226928100e-02 8.42765087070539653524292589281686e-01 4.05128107024774631456098816784106e-03
 	 5.67079687690783540432448717183433e-02 5.64847259714027494226229464402422e-02 8.86807305259518896534132181841414e-01 3.23356151629467826469355173912845e-03
 	 2.33400941237742465261817415012047e-02 5.84828084243295132083062526362482e-02 9.18177097451896240265512005862547e-01 2.18053330383513772894321647299876e-03
 	 4.45799356778742161822037814999931e-03 5.96134765953280076900000494788401e-02 9.35928529836884570691779572371161e-01 9.67090868701063325653388691449663e-04
 	 9.88714040632243551520730306947371e-01 2.78337028576738226837150591563841e-04 1.10076223391797102524325424610652e-02 1.18193291013472276753965700679672e-05
 	 9.62501197823349974314055543800350e-01 9.24804425829733878217098208551761e-04 3.65739977508202918077273579910980e-02 6.94732340032250175049233220647693e-05
 	 9.22243034592298283058653396437876e-01 1.91766087378943128616270996644744e-03 7.58393045339122856551838935956766e-02 2.02273686129010696506391742133246e-04
 	 8.69166059567413662456658585142577e-01 3.22665792338672208217076331493445e-03 1.27607282509199615461170651542488e-01 4.27949144484118305410691451839966e-04
 	 8.04883578524966614153868249559309e-01 4.81200784180060847639026633260073e-03 1.90304413633232777369741484108090e-01 7.49463300807051376918599405740906e-04
 	 7.31348952734051316326713276794180e-01 6.62553636633350651052865032397676e-03 2.62025510899615177162758072881843e-01 1.15374000788719555804506811114152e-03
 	 6.50796558453382356645988693344407e-01 8.61213877541877614874010760104284e-03 3.40591302771198867205271199054550e-01 1.61245942267677347045640168232694e-03
 	 5.65673966886634405071276887611020e-01 1.07114524827788271110762252646964e-02 4.23614580630586767817646887124283e-01 2.08485267958898436504999729379506e-03
 	 4.78567596853079701979538640443934e-01 1.28596906090396867483605092274956e-02 5.08572712537880611272100850328570e-01 2.52217685250526440360330227008490e-03
 	 3.92124134722095840643873998487834e-01 1.49915799420957673859788883419242e-02 5.92884285335808391970147113170242e-01 2.87334390438649710589058550169739e-03
 	 3.08970117752195960747485514730215e-01 1.70423441920314333586361499328632e-02 6.73987538055772605893878335336922e-01 3.09103231773846841637376492428757e-03
 	 2.31632125777172293012995396566112e-01 1.89496722428410535599141439888626e-02 7.49418201979986653427090459445026e-01 3.13754586225870393811909764281154e-03
 	 1.62460003428136490200017760798801e-01 2.06556116643475951022423942049500e-02 8.16884384907515914697739844996249e-01 2.98970851980612413456572795666943e-03
 	 1.03555432935197089250323188025504e-01 2.21083302668472203578176049632020e-02 8.74336236797955690391859207011294e-01 2.64219565401331178342014815996208e-03
 	 5.67079687690783540432448717183433e-02 2.32636936300723018433700417517684e-02 9.20028337600849344113385086529888e-01 2.10888902477853129938112353158886e-03
 	 2.33400941237742465261817415012047e-02 2.40866201333546081642111857945565e-02 9.52573285742871145309607072704239e-01 1.42211698446095846128101047867176e-03
 	 4.45799356778742161822037814999931e-03 2.45522950122715188925326401658822e-02 9.70989711419941059489246981684119e-01 6.30724762367980526685251607688087e-04
 	 9.88714040632243551520730306947371e-01 5.31824013309516868686088741924323e-05 1.12327769664254967924010841784366e-02 5.14639669799019396474954249343092e-06
 	 9.62501197823349974314055543800350e-01 1.76704193396812203609158586914418e-04 3.73220979832532134823352976127353e-02 3.02501790928339060954884581766677e-05
 	 9.22243034592298283058653396437876e-01 3.66411219980433688903076472342946e-04 7.73905541877212832524435270897811e-02 8.80744263450612625875393857377560e-05
 	 8.69166059567413662456658585142577e-01 6.16523850659467242962819000240415e-04 1.30217416581926870300378595857183e-01 1.86338500704727330972709786749419e-04
 	 8.04883578524966503131565787043655e-01 9.19439765377005890911732421955094e-04 1.94196981709656490977522480534390e-01 3.26332858952086844652601405059045e-04
 	 7.31348952734051316326713276794180e-01 1.26595421338276947764711621857714e-03 2.67385093052565914195639606987243e-01 5.02363858051219189411462640038053e-04
 	 6.50796558453382356645988693344407e-01 1.64553822757323997549860905564856e-03 3.47557903319044403378512697599945e-01 7.02100413428798780790529576734116e-04
 	 5.65673966886634405071276887611020e-01 2.04665821033406247764219187956769e-03 4.32279374903031532451080920509412e-01 9.07790861395826203551762123566959e-04
 	 4.78567596853079701979538640443934e-01 2.45712627766037083887340486398898e-03 5.18975276869259927181587954692077e-01 1.09821145635083904090745221537873e-03
 	 3.92124134722095840643873998487834e-01 2.86447054904070963488038614741527e-03 6.05011394728863449721245615364751e-01 1.25111733964996195943297774277880e-03
 	 3.08970117752195960747485514730215e-01 3.25631409185989095789182101725601e-03 6.87773568155944148294622664252529e-01 1.34590367837181127189105644959000e-03
 	 2.31632125777172293012995396566112e-01 3.62075099911085551696032780455425e-03 7.64747123223716851470044275629334e-01 1.36615670203145997234350783600121e-03
 	 1.62460003428136490200017760798801e-01 3.94670818642717247115569989546202e-03 8.33593288385436337328826539305737e-01 1.30178506092444665892537969398290e-03
 	 1.03555432935197089250323188025504e-01 4.22428197577928710160222181002609e-03 8.92220285089023623648074590164470e-01 1.15047029088209424446676010234114e-03
 	 5.67079687690783540432448717183433e-02 4.44503951702457378303279256215319e-03 9.38846991713897072173722335719503e-01 9.18256816481308668284611052001765e-04
 	 2.33400941237742465261817415012047e-02 4.60227769617460591433655281434767e-03 9.72057628180051147559481705684448e-01 6.19221115702025420336751526662056e-04
 	 4.45799356778742161822037814999931e-03 4.69125510757739672129673635936342e-03 9.90850751324635181660482885490637e-01 2.74631479211559764025407659460143e-04
 	 ];
 
 	 case  34 

 	 % ALG. DEG.:   34
 	 % PTS CARD.:  324
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 9.89866848202597293671090028510662e-01 1.00904160830146451266475793318023e-02 4.27357143880612022623921575359418e-05 3.71512444665076500233493773939220e-06
 	 9.66300751945632585560019833792467e-01 3.35571243135274824287428430125146e-02 1.42123740839932011237323195018689e-04 2.18975659784398254915568915457413e-05
 	 9.30020889699693320551432407228276e-01 6.96839792955885328762377639577608e-02 2.95131004718146572329828813963104e-04 6.40362093522176310063029336383522e-05
 	 8.82019825362079235020473788608797e-01 1.17482603186550751961370053777500e-01 4.97571451370013018156157613702817e-04 1.36311421780068597496213267383780e-04
 	 8.23607429774869448380059111514129e-01 1.75648649414306495808446584305784e-01 7.43920810824055811494304180087056e-04 2.40626654600658180247277351249124e-04
 	 7.56377193406150505339269329851959e-01 2.42595347922629794856774765321461e-01 1.02745867121969980395590482658008e-03 3.74136457315560973149043411112302e-04
 	 6.82163039113651503697610678500496e-01 3.16496510269008712867844224092551e-01 1.34045061733978343454509740695357e-03 5.29324076698905543816864316397641e-04
 	 6.02989360559832099362154167465633e-01 3.95336280500779735369576428638538e-01 1.67435893938816526826940389582887e-03 6.94626403925746203557589630861457e-04
 	 5.21015820870776247275557579996530e-01 4.76964103689226870397277480151388e-01 2.02007543999688232716493985208217e-03 8.55543707397436368165821729547815e-04
 	 4.38478449224138033812891990237404e-01 5.59153380921455833707511828833958e-01 2.36816985440613247959618092863820e-03 9.96117803137897906209929921317325e-04
 	 3.57628649976634571672207130177412e-01 6.39662202949032199228440731531009e-01 2.70914707433322909935213829157874e-03 1.10062102288638308765500450903119e-03
 	 2.80671790060171733038885122368811e-01 7.16294503789370318180829144694144e-01 3.03370615045794878028573293704540e-03 1.15527406407243699720810425901618e-03
 	 2.09707039588842958366399216174614e-01 7.86959966401560961912764469161630e-01 3.33299400959607972083631466375664e-03 1.14980622490699793507296089245528e-03
 	 1.46670103677618013371386496146442e-01 8.49731049343950051166984849260189e-01 3.59884697843193546162865459336899e-03 1.07868721205472300507521854484594e-03
 	 9.32803959285448680560648426762782e-02 9.02895590496563649196559708798304e-01 3.82401357489148274737544852541760e-03 9.41894164727222508656789834446954e-04
 	 5.09940415878905595192804867110681e-02 9.45003605698739757023929541901452e-01 4.00235271336968345678997138747945e-03 7.45128172889284335483894849971875e-04
 	 2.09636483937665207832878877525218e-02 9.74907348238440940590976424573455e-01 4.12900336779253862573568767402321e-03 4.99467177679234898383942020672066e-04
 	 4.00147938386741230942789115943015e-03 9.91797980728932992988688965851907e-01 4.20053988719959470188314298866317e-03 2.20793299391925095399163980758317e-04
 	 9.89866848202597182648787565995008e-01 9.90933048500138892455968431249858e-03 2.23821312401428426652749692493671e-04 8.54439398493292301558187096244268e-06
 	 9.66300751945632585560019833792467e-01 3.29548982136395607334122814791044e-02 7.44349840727853706567884728428908e-04 5.03620898081967441946987795731161e-05
 	 9.30020889699693320551432407228276e-01 6.84334099475190915651268142028130e-02 1.54570035278758788344077856891090e-03 1.47276520575308694305585732742259e-04
 	 8.82019825362079235020473788608797e-01 1.15374225565730723075397179400170e-01 2.60594907219004190412903199103312e-03 3.13501878351683316899917164377598e-04
 	 8.23607429774869448380059111514129e-01 1.72496406686382469652940585547185e-01 3.89616353874808196700030293868622e-03 5.53415900250102139185104377361313e-04
 	 7.56377193406150616361571792367613e-01 2.38241659899025681745854399196105e-01 5.38114669482370189257380843628198e-03 8.60474350546486656081401900308947e-04
 	 6.82163039113651503697610678500496e-01 3.10816570080253984365015185176162e-01 7.02039080609451193737413632334210e-03 1.21738949043917639436518385309682e-03
 	 6.02989360559831988339851704949979e-01 3.88241458425867713710744055788382e-01 8.76918101430029794940423926163930e-03 1.59756739046234674112012541513650e-03
 	 5.21015820870776247275557579996530e-01 4.68404364503366144045770624870784e-01 1.05798146258576086786717951326864e-02 1.96766019881891834203413438331154e-03
 	 4.38478449224138033812891990237404e-01 5.49118648603951209352658224815968e-01 1.24029021719107568344497849466279e-02 2.29096577722693412956789238421607e-03
 	 3.57628649976634571672207130177412e-01 6.28182635447104620318725665129023e-01 1.41887145762608080090672046935651e-02 2.53131214921187676705760516426835e-03
 	 2.80671790060171733038885122368811e-01 7.03439670301319264211770132533275e-01 1.58885396385090027493447450979147e-02 2.65700837367870363117661192120522e-03
 	 2.09707039588842958366399216174614e-01 7.72836949574910669902294557687128e-01 1.74560108362463717313062261382584e-02 2.64443292089195335081708293500924e-03
 	 1.46670103677618013371386496146442e-01 8.34481524056296275482225155428750e-01 1.88483722660857111463883484248072e-02 2.48086670006800093929433259631878e-03
 	 9.32803959285448680560648426762782e-02 8.86691958594423734751899246475659e-01 2.00276454770313971920359108480625e-02 2.16625713380718754388909452757161e-03
 	 5.09940415878905595192804867110681e-02 9.28044290874180721750974498718278e-01 2.09616675379287187297450145706534e-02 1.71371612710817760975856582916776e-03
 	 2.09636483937665207832878877525218e-02 9.57411371986237602627056730852928e-01 2.16249796199958765896553813945502e-02 1.14872177498151289108674344419114e-03
 	 4.00147938386741230942789115943015e-03 9.73998880179356762987197271286277e-01 2.19996404367758247033748375542928e-02 5.07801277273121887644025118646596e-04
 	 9.89866848202597293671090028510662e-01 9.58901404257930453645109025728743e-03 5.44137754823401792458881232050771e-04 1.31352202604428841466741376131644e-05
 	 9.66300751945632585560019833792467e-01 3.18896399934043631163582688259339e-02 1.80960806096305132362189738159941e-03 7.74211890946720118333174154301446e-05
 	 9.30020889699693431573734869743930e-01 6.62213183788324111223033696660423e-02 3.75779192147415730396176059002755e-03 2.26406874537810184552788506096022e-04
 	 8.82019825362079235020473788608797e-01 1.11644784758770612698164370613085e-01 6.33538987915015228136184077811777e-03 4.81943626601654003492603006719719e-04
 	 8.23607429774869448380059111514129e-01 1.66920506739962698494750270583609e-01 9.47206348516785312519061790226260e-03 8.50761301297068791606170723440528e-04
 	 7.56377193406150505339269329851959e-01 2.30540562327288228727795171835169e-01 1.30822442665612659329354983128724e-02 1.32279950372377096481923963722238e-03
 	 6.82163039113651503697610678500496e-01 3.00769508058795154159525964132627e-01 1.70674528275533421428633573668776e-02 1.87148194803103315973780151892925e-03
 	 6.02989360559831988339851704949979e-01 3.75691657715116866800286743455217e-01 2.13189817250511448598615515948040e-02 2.45592602490328883527159753441538e-03
 	 5.21015820870776247275557579996530e-01 4.53263319416637999736963138275314e-01 2.57208597125857529874792817281559e-02 3.02486638078361402826033099699998e-03
 	 4.38478449224138033812891990237404e-01 5.31368535994964474866719683632255e-01 3.01530147808974913203883261303417e-02 3.52188114757781035868422492285390e-03
 	 3.57628649976634571672207130177412e-01 6.07876800730793087623737847025041e-01 3.44945492925723407040550227975473e-02 3.89136347018460750785129320661326e-03
 	 2.80671790060171733038885122368811e-01 6.80701172176695346038854950165842e-01 3.86270377631329209222599274653476e-02 4.08459514901276989767842096057393e-03
 	 2.09707039588842958366399216174614e-01 7.47855203064905493803848912648391e-01 4.24377573462515478297518711769953e-02 4.06526301820044500684447896787788e-03
 	 1.46670103677618013371386496146442e-01 8.07507133257921894120556771667907e-01 4.58227630644600925080567321856506e-02 3.81381413353063013563226668622974e-03
 	 9.32803959285448680560648426762782e-02 8.58029879543661611052129956078716e-01 4.86897245277935208918052012450062e-02 3.33016766823826223034576976544940e-03
 	 5.09940415878905595192804867110681e-02 8.98045508805817571662544196442468e-01 5.09604496062918688181753168464638e-02 2.63448043631098584652083793855581e-03
 	 2.09636483937665207832878877525218e-02 9.26463306920362938967627997044474e-01 5.25730446858705402490841152030043e-02 1.76591968476129835413646063102533e-03
 	 4.00147938386741230942789115943015e-03 9.42514628373004592631900777632836e-01 5.34838922431279950586713312077336e-02 7.80638350394261297179876457619230e-04
 	 9.89866848202597293671090028510662e-01 9.13860807349834922130860093147930e-03 9.94543723904357107601370557858900e-04 1.73488166675464347457179953293505e-05
 	 9.66300751945632585560019833792467e-01 3.03917504146538307308045290255905e-02 3.30749763971358370917563718194288e-03 1.02256832329785556697648862822803e-04
 	 9.30020889699693320551432407228276e-01 6.31108341365741176698378467335715e-02 6.86827616373256177872974603815237e-03 2.99035058472344004044246590368061e-04
 	 8.82019825362079235020473788608797e-01 1.06400713027430995905042721005884e-01 1.15794616104897690744834903853189e-02 6.36544455001216346809456148037043e-04
 	 8.23607429774869448380059111514129e-01 1.59080076820488525157770709483884e-01 1.73124934046420264621701790019870e-02 1.12367372235815284053916940365525e-03
 	 7.56377193406150616361571792367613e-01 2.19711832186065075811498559232859e-01 2.39109744077843078269296483995277e-02 1.74713523054780754499570871729475e-03
 	 6.82163039113651503697610678500496e-01 2.86642051247731344254532359627774e-01 3.11949096386171520478569618717302e-02 2.47182738996706624287624798341767e-03
 	 6.02989360559831988339851704949979e-01 3.58045029561541661156098825813388e-01 3.89656098786263505040494692366337e-02 3.24375301748207117355504713884784e-03
 	 5.21015820870776247275557579996530e-01 4.31973069582382129816267024580156e-01 4.70111095468416229081753954233136e-02 3.99520154542655579060772552679737e-03
 	 4.38478449224138033812891990237404e-01 5.06409602852181839338641111680772e-01 5.51119479236801268484668980818242e-02 4.65165175328056002684862235696528e-03
 	 3.57628649976634571672207130177412e-01 5.79324194769509359659309666312765e-01 6.30471552538560686684832035098225e-02 5.13965887837679758637365878826131e-03
 	 2.80671790060171733038885122368811e-01 6.48727929698648231315871726110345e-01 7.06002802411800356452431515208445e-02 5.39487659866487445636806796755991e-03
 	 2.09707039588842958366399216174614e-01 7.12727665867339932326274265506072e-01 7.75652945438171093073265183193143e-02 5.36934298852313317967910322181524e-03
 	 1.46670103677618013371386496146442e-01 7.69577682818094799266361860645702e-01 8.37522135042871873622516432078555e-02 5.03723279052874055305988321151744e-03
 	 9.32803959285448680560648426762782e-02 8.17727323130643224402547275531106e-01 8.89922809408119075413878817926161e-02 4.39843924981188003076049142237025e-03
 	 5.09940415878905595192804867110681e-02 8.55863376641196937910649467085022e-01 9.31425817709125025700700462039094e-02 3.47958520660969711571497420266041e-03
 	 2.09636483937665207832878877525218e-02 8.82946361203265084327540535014123e-01 9.60899904029683948891715772333555e-02 2.33240221732697273690493311448790e-03
 	 4.00147938386741230942789115943015e-03 8.98243735382307617598485194321256e-01 9.77547852338249700920869145193137e-02 1.03105630176842386416802277437910e-03
 	 9.89866848202597293671090028510662e-01 8.57106080051498950278521249401820e-03 1.56209099688771682612475899532001e-03 2.10634511289658231446373509720971e-05
 	 9.66300751945632585560019833792467e-01 2.85042906472250841265481113850910e-02 5.19495740714233031343205482244230e-03 1.24151510253171879372829922161259e-04
 	 9.30020889699693320551432407228276e-01 5.91913770899600080732660956073232e-02 1.07877332103466713753014971644006e-02 3.63062822132551423284785307998845e-04
 	 8.82019825362079235020473788608797e-01 9.97927663864841274499184464730206e-02 1.81874082514366375296077649181825e-02 7.72837898760763797149919707152321e-04
 	 8.23607429774869448380059111514129e-01 1.49200512770983395594015519236564e-01 2.71920574541471560259253692493076e-02 1.36426864087332497255111718459375e-03
 	 7.56377193406150505339269329851959e-01 2.06066772654406732412368796758528e-01 3.75560339394427622483618733895128e-02 2.12122234326099024306899742953192e-03
 	 6.82163039113651503697610678500496e-01 2.68840334268558023289585889870068e-01 4.89966266177904730128034316294361e-02 3.00108165447423485064359915952537e-03
 	 6.02989360559831988339851704949979e-01 3.35808877349018874980401960783638e-01 6.12017620911491366797463342663832e-02 3.93828780760479765787884787187068e-03
 	 5.21015820870776247275557579996530e-01 4.05145664831903506986066076933639e-01 7.38385142973202457383763430698309e-02 4.85063241574748473666778281199186e-03
 	 4.38478449224137978301740758979577e-01 4.74959365923340925963458403202822e-01 8.65621848525210402236496065597748e-02 5.64763817912026545864367932381356e-03
 	 3.57628649976634571672207130177412e-01 5.43345644833857055466808105848031e-01 9.90257051895083728609847639745567e-02 6.24013474110655507604006331234814e-03
 	 2.80671790060171844061187584884465e-01 6.08439106231502435662150674033910e-01 1.10889103708325720276661741081625e-01 6.54999829442833025883174968839739e-03
 	 2.09707039588842958366399216174614e-01 6.68464180674681496263644930877490e-01 1.21828779736475545369955852947896e-01 6.51899756627073202752686853500563e-03
 	 1.46670103677617902349084033630788e-01 7.21783564532304078298352578713093e-01 1.31546331790078019352563387656119e-01 6.11577773526220114241880310146371e-03
 	 9.32803959285448680560648426762782e-02 7.66942902948247073879883828340098e-01 1.39776701123208058064051328983624e-01 5.34020918875962626037878777651713e-03
 	 5.09940415878906705415829492267221e-02 8.02710541816418876592820197402034e-01 1.46295416595690452865596853371244e-01 4.22461510505207048227216404256978e-03
 	 2.09636483937665207832878877525218e-02 8.28111555348672645493479649303481e-01 1.50924796257560833723232462943997e-01 2.83180352062053488845783100202880e-03
 	 4.00147938386741230942789115943015e-03 8.42458896116795807884614077920560e-01 1.53539624499336779805958030920010e-01 1.25182048088256473068746732479894e-03
 	 9.89866848202597293671090028510662e-01 7.90269730021668503905374336682144e-03 2.23045449718602128985622812251677e-03 2.41721689293442594330917072564802e-05
 	 9.66300751945632585560019833792467e-01 2.62815520721638856693758157234697e-02 7.41769598220352877060435048406362e-03 1.42474813851657308976655924581678e-04
 	 9.30020889699693320551432407228276e-01 5.45756875154623510848495016034576e-02 1.54034227848443283637180911682663e-02 4.16646627127687950355866552953898e-04
 	 8.82019825362079235020473788608797e-01 9.20110175226195592390610045185895e-02 2.59691571153012057404652068726136e-02 8.86899688444447737573073098360510e-04
 	 8.23607429774869448380059111514129e-01 1.37565992927660751821150597606902e-01 3.88265772974697997987902908789692e-02 1.56561865623470759106838912089188e-03
 	 7.56377193406150505339269329851959e-01 1.89997873754728041628681012298330e-01 5.36249328391214530320496578497114e-02 2.43428982762909770429238243139025e-03
 	 6.82163039113651503697610678500496e-01 2.47876410313858763778682714473689e-01 6.99605505724897325237066070258152e-02 3.44400603104154682740367654503189e-03
 	 6.02989360559832099362154167465633e-01 3.09622807512395015194783809420187e-01 8.73878319277728854430620231141802e-02 4.51953279616596273471351707939903e-03
 	 5.21015820870776247275557579996530e-01 3.73552775575830886545247722096974e-01 1.05431403553392866179194697906496e-01 5.56652874449250871513594773887235e-03
 	 4.38478449224138089324043221495231e-01 4.37922467959798999981302358719404e-01 1.23599082816062966205805651043192e-01 6.48116319028922346912047203204565e-03
 	 3.57628649976634571672207130177412e-01 5.00976047242019162375470386905363e-01 1.41395302781346265952322482917225e-01 7.16110528043860036784273859211680e-03
 	 2.80671790060171733038885122368811e-01 5.60993579916390427975159127527149e-01 1.58334630023437838985955750104040e-01 7.51670105199954419195051968927146e-03
 	 2.09707039588842958366399216174614e-01 6.16337953826200379836564025026746e-01 1.73955006584956661797036758798640e-01 7.48112498075793885821127560120658e-03
 	 1.46670103677618013371386496146442e-01 6.65499540783503595875458813679870e-01 1.87830355538878390753154690173687e-01 7.01839464226196047685890633260897e-03
 	 9.32803959285448680560648426762782e-02 7.07137395196787088558210143673932e-01 1.99582208874668043385725013649790e-01 6.12836129456588007274886464870178e-03
 	 5.09940415878905595192804867110681e-02 7.40115906223291930565721941093216e-01 2.08890052188817509914997572195716e-01 4.84811863713768918110469385851502e-03
 	 2.09636483937665207832878877525218e-02 7.63536171898230087151659972732887e-01 2.15500179708003392065052139514592e-01 3.24974443437808053689042075973248e-03
 	 4.00147938386741230942789115943015e-03 7.76764720124923702115893320296891e-01 2.19233800491208885574678788543679e-01 1.43657446957942995166557231812021e-03
 	 9.89866848202597293671090028510662e-01 7.15274440963131925841356206774435e-03 2.98040738777138707049640942159385e-03 2.65855134379769391826317526117407e-05
 	 9.66300751945632585560019833792467e-01 2.37874762905888187392022814492520e-02 9.91177176377859570077788475828129e-03 1.56699470754908875636327025837602e-04
 	 9.30020889699693431573734869743930e-01 4.93965451222971169142894609649375e-02 2.05825651780094515119756692911324e-02 4.58244543001851557372655632249803e-04
 	 8.82019825362079235020473788608797e-01 8.32793242873368089185248663852690e-02 3.47008503505839560610013450059341e-02 9.75447575854628359283415850455867e-04
 	 8.23607429774869448380059111514129e-01 1.24511207944372037648150808308856e-01 5.18813622807585139717900801770156e-02 1.72192970956555179568026048286811e-03
 	 7.56377193406150616361571792367613e-01 1.71967390083852200710623492341256e-01 7.16554165099971829278047152911313e-02 2.67732883687568949324098177555697e-03
 	 6.82163039113651503697610678500496e-01 2.24353349343561270234914672982995e-01 9.34836115427872260674746485165088e-02 3.78785490397499490650146114489871e-03
 	 6.02989360559831988339851704949979e-01 2.80240115671381462281175345196971e-01 1.16770523768786549378972949853051e-01 4.97076204609774811166156283093187e-03
 	 5.21015820870776247275557579996530e-01 3.38103235604003904413161762931850e-01 1.40880943525219848311280657071620e-01 6.12228986038304643507723667994469e-03
 	 4.38478449224138033812891990237404e-01 3.96364350747119842388599408877781e-01 1.65157200028742123798508600884816e-01 7.12824122621378338665598661805234e-03
 	 3.57628649976634627183358361435239e-01 4.53434249742970141294762242978322e-01 1.88937100280395287033030626844265e-01 7.87606859857539060021380805665103e-03
 	 2.80671790060171844061187584884465e-01 5.07756217927769926134828892827500e-01 2.11571992012058229803983522288036e-01 8.26716698080805570403306603566307e-03
 	 2.09707039588842958366399216174614e-01 5.57848502378179622596121589594986e-01 2.32444458032977419037479194230400e-01 8.22803900173308191967613822725980e-03
 	 1.46670103677618013371386496146442e-01 6.02344736122044865922475764818955e-01 2.50985160200337120706137739034602e-01 7.71910975884208469532943297508609e-03
 	 9.32803959285448680560648426762782e-02 6.40031227084502774005159153603017e-01 2.66688376986952357938776003720704e-01 6.74021565982324110527512672774719e-03
 	 5.09940415878906705415829492267221e-02 6.69880132011726692198294585978147e-01 2.79125826400382637260122464795131e-01 5.33215383167632769878530041296472e-03
 	 2.09636483937665207832878877525218e-02 6.91077853247221929322563482855912e-01 2.87958498359011549894148629391566e-01 3.57419826837578578915266547255669e-03
 	 4.00147938386741230942789115943015e-03 7.03051034147549103181518148630857e-01 2.92947486468583484509053960209712e-01 1.58000177713860621986352583689950e-03
 	 9.89866848202597182648787565995008e-01 6.34277657900481940667081204310307e-03 3.79037521839799794454162196188918e-03 2.82340488002669460327557354739625e-05
 	 9.66300751945632585560019833792467e-01 2.10938122277119152747637542688608e-02 1.26054358266554991652164119386725e-02 1.66416214401566610065624773895365e-04
 	 9.30020889699693320551432407228276e-01 4.38029421355502074364451914334495e-02 2.61761681647564720121224013382744e-02 4.86659729922253624697509044594312e-04
 	 8.82019825362079235020473788608797e-01 7.38488777669456530894365187123185e-02 4.41312968709751118900896926788846e-02 1.03593389396196776906788894478950e-03
 	 8.23607429774869448380059111514129e-01 1.10411714489581258558104082112550e-01 6.59808557355492930618368063733215e-02 1.82870447711777801835797419016671e-03
 	 7.56377193406150505339269329851959e-01 1.52494017919572899533164900276461e-01 9.11287886742765951275657698715804e-02 2.84334674261842732315153092770288e-03
 	 6.82163039113651503697610678500496e-01 1.98947856674634743212592979944020e-01 1.18889104211713753089796341555484e-01 4.02273518082179714488999522359336e-03
 	 6.02989360559831988339851704949979e-01 2.48506075484061506042365863322630e-01 1.48504563956106505617782431727392e-01 5.27899295650083658082429849400796e-03
 	 5.21015820870776247275557579996530e-01 2.99816848088013954143349337755353e-01 1.79167331041209798581093082248117e-01 6.50192561037813993723988303941042e-03
 	 4.38478449224138033812891990237404e-01 3.51480547422617473074524241383187e-01 2.10041003353244493112583768379409e-01 7.57025479724230364320103348063640e-03
 	 3.57628649976634571672207130177412e-01 4.02087922436554001670572233706480e-01 2.40283427586811426657220636116108e-01 8.36445403566181584775751645111086e-03
 	 2.80671790060171677527733891110984e-01 4.50258538887499282221682506133220e-01 2.69069671052329095761734834013623e-01 8.77980395303030319853476726166264e-03
 	 2.09707039588842902855247984916787e-01 4.94678435699844876172193153252010e-01 2.95614524711312165461407630573376e-01 8.73824969554959189721454748678298e-03
 	 1.46670103677617902349084033630788e-01 5.34135971588375335628029461076949e-01 3.19193924734006762022886505292263e-01 8.19776236912687569780011642706086e-03
 	 9.32803959285448680560648426762782e-02 5.67554891450755105708481096371543e-01 3.39164712620700026235454060952179e-01 7.15816823728999528791971940222538e-03
 	 5.09940415878905595192804867110681e-02 5.94023743717642771500209164514672e-01 3.54982214694466668980510348774260e-01 5.66279420727772066918026538928643e-03
 	 2.09636483937665207832878877525218e-02 6.12821061513554754540678004559595e-01 3.66215290092678724676034107687883e-01 3.79582995703959397149063192955509e-03
 	 4.00147938386741230942789115943015e-03 6.23438414384226646802744653541595e-01 3.72560106231905940887827455298975e-01 1.67797576617480410920979494449057e-03
 	 9.89866848202597182648787565995008e-01 5.49609493659073376770063390495125e-03 4.63705686081208358351180010004100e-03 2.90703464420603941505312495241498e-05
 	 9.66300751945632585560019833792467e-01 1.82780511238365486748058685861906e-02 1.54211969305308657651742976213427e-02 1.71345492828644613498081938907092e-04
 	 9.30020889699693320551432407228276e-01 3.79557951443320884532539594147238e-02 3.20233151559745909953136333570001e-02 5.01074679310807807701422245116873e-04
 	 8.82019825362079235020473788608797e-01 6.39909727407583783787003994802944e-02 5.39892018971623866008258119109087e-02 1.06661844362408025910227138410846e-03
 	 8.23607429774869448380059111514129e-01 9.56731263332156328660360600224521e-02 8.07194438919149187539048284634191e-02 1.88287103511197749863836925499072e-03
 	 7.56377193406150616361571792367613e-01 1.32137966600053613497323112824233e-01 1.11484839993795770141105094808154e-01 2.92756718838143095706705310021789e-03
 	 6.82163039113651503697610678500496e-01 1.72390796695317150000192896186491e-01 1.45446164191031346302196425313014e-01 4.14188932584293179051115885158652e-03
 	 6.02989360559831988339851704949979e-01 2.15333610788208007491562057111878e-01 1.81677028651960004168586237938143e-01 5.43535768448572768202220473199304e-03
 	 5.21015820870776247275557579996530e-01 2.59795034580844352856132672968670e-01 2.19189144548379399868309747034800e-01 6.69451382518012911432281342172246e-03
 	 4.38478449224138089324043221495231e-01 3.04562273783050618813916798899299e-01 2.56959276992811347373191210863297e-01 7.79448711615256251139527421400999e-03
 	 3.57628649976634571672207130177412e-01 3.48414194799616772080241844378179e-01 2.93957155223748656247551025444409e-01 8.61221067993196177925430134791895e-03
 	 2.80671790060171733038885122368811e-01 3.90154634159382784908132180134999e-01 3.29173575780445482052982697496191e-01 9.03986333711901540732824855695071e-03
 	 2.09707039588843013877550447432441e-01 4.28645028218402390773889010233688e-01 3.61647932192754650859711773591698e-01 8.99707823500162096053145432961173e-03
 	 1.46670103677618013371386496146442e-01 4.62835474706007388157047444110503e-01 3.90494421616374598471566059743054e-01 8.44058157602783909467802914150525e-03
 	 9.32803959285449235672160739341052e-02 4.91793385165905039269063081519562e-01 4.14926218905550092674872075804160e-01 7.37019447761971292776284059300451e-03
 	 5.09940415878904484969780241954140e-02 5.14728975456590465142880930216052e-01 4.34276982955519086360141045588534e-01 5.83052719785975837041291924833786e-03
 	 2.09636483937665207832878877525218e-02 5.31017085540992583858610487368423e-01 4.48019266065240895358101624879055e-01 3.90826312821450274487267151357628e-03
 	 4.00147938386741230942789115943015e-03 5.40217154095457230411625459964853e-01 4.55781366520675357278946648875717e-01 1.72767771243712269652048618695517e-03
 	 9.89866848202597182648787565995008e-01 4.63705686081203067444578280742462e-03 5.49609493659078667676665119756763e-03 2.90703464420604178674537726445593e-05
 	 9.66300751945632585560019833792467e-01 1.54211969305308761735151534821853e-02 1.82780511238365382664650127253481e-02 1.71345492828644749023353499595146e-04
 	 9.30020889699693320551432407228276e-01 3.20233151559745563008441138208582e-02 3.79557951443321231477234789508657e-02 5.01074679310808241382291239318647e-04
 	 8.82019825362079235020473788608797e-01 5.39892018971624282341892353542789e-02 6.39909727407583367453369760369242e-02 1.06661844362408112646400937251201e-03
 	 8.23607429774869448380059111514129e-01 8.07194438919149742650560597212461e-02 9.56731263332155773548848287646251e-02 1.88287103511197923336184523179782e-03
 	 7.56377193406150616361571792367613e-01 1.11484839993795881163407557323808e-01 1.32137966600053502475020650308579e-01 2.92756718838143312547139807122676e-03
 	 6.82163039113651503697610678500496e-01 1.45446164191031429568923272199754e-01 1.72390796695317066733466049299750e-01 4.14188932584293525995811080520070e-03
 	 6.02989360559831988339851704949979e-01 1.81677028651960059679737469195970e-01 2.15333610788207951980410825854051e-01 5.43535768448573201883089467401078e-03
 	 5.21015820870776247275557579996530e-01 2.19189144548379510890612209550454e-01 2.59795034580844241833830210453016e-01 6.69451382518013518585497934054729e-03
 	 4.38478449224138089324043221495231e-01 2.56959276992811458395493673378951e-01 3.04562273783050507791614336383645e-01 7.79448711615256945028917812123836e-03
 	 3.57628649976634516161055898919585e-01 2.93957155223748822781004719217890e-01 3.48414194799616605546788150604698e-01 8.61221067993196871814820525514733e-03
 	 2.80671790060171733038885122368811e-01 3.29173575780445704097587622527499e-01 3.90154634159382562863527255103691e-01 9.03986333711902234622215246417909e-03
 	 2.09707039588842902855247984916787e-01 3.61647932192754872904316698623006e-01 4.28645028218402168729284085202380e-01 8.99707823500162963414883421364721e-03
 	 1.46670103677618013371386496146442e-01 3.90494421616374820516170984774362e-01 4.62835474706007166112442519079195e-01 8.44058157602784603357193304873363e-03
 	 9.32803959285448125449136114184512e-02 4.14926218905550314719477000835468e-01 4.91793385165904817224458156488254e-01 7.37019447761971899929500651182934e-03
 	 5.09940415878905595192804867110681e-02 4.34276982955519308404745970619842e-01 5.14728975456590132075973542669090e-01 5.83052719785976357458334717875914e-03
 	 2.09636483937665207832878877525218e-02 4.48019266065241117402706549910363e-01 5.31017085540992361814005562337115e-01 3.90826312821450621431962346719047e-03
 	 4.00147938386741230942789115943015e-03 4.55781366520675579323551573907025e-01 5.40217154095457008367020534933545e-01 1.72767771243712399756309316956049e-03
 	 9.89866848202597182648787565995008e-01 3.79037521839794243339039070406216e-03 6.34277657900487491782204330093009e-03 2.82340488002670883342908741964195e-05
 	 9.66300751945632585560019833792467e-01 1.26054358266554991652164119386725e-02 2.10938122277119152747637542688608e-02 1.66416214401567450322308450161302e-04
 	 9.30020889699693320551432407228276e-01 2.61761681647564165009711700804473e-02 4.38029421355502629475964226912765e-02 4.86659729922256064152397136979289e-04
 	 8.82019825362079235020473788608797e-01 4.41312968709751118900896926788846e-02 7.38488777669456530894365187123185e-02 1.03593389396197297323831687521078e-03
 	 8.23607429774869448380059111514129e-01 6.59808557355492930618368063733215e-02 1.10411714489581258558104082112550e-01 1.82870447711778734249665756550485e-03
 	 7.56377193406150616361571792367613e-01 9.11287886742765396164145386137534e-02 1.52494017919572844022013669018634e-01 2.84334674261844163462020773636141e-03
 	 6.82163039113651503697610678500496e-01 1.18889104211713753089796341555484e-01 1.98947856674634743212592979944020e-01 4.02273518082181709420996895687495e-03
 	 6.02989360559831988339851704949979e-01 1.48504563956106450106631200469565e-01 2.48506075484061561553517094580457e-01 5.27899295650086346903817613451793e-03
 	 5.21015820870776247275557579996530e-01 1.79167331041209798581093082248117e-01 2.99816848088013954143349337755353e-01 6.50192561037817289698592659874521e-03
 	 4.38478449224138033812891990237404e-01 2.10041003353244493112583768379409e-01 3.51480547422617473074524241383187e-01 7.57025479724234180711750497039247e-03
 	 3.57628649976634571672207130177412e-01 2.40283427586811426657220636116108e-01 4.02087922436554001670572233706480e-01 8.36445403566185921584441587128822e-03
 	 2.80671790060171677527733891110984e-01 2.69069671052328984739432371497969e-01 4.50258538887499393243984968648874e-01 8.77980395303034830134514265864709e-03
 	 2.09707039588843013877550447432441e-01 2.95614524711312165461407630573376e-01 4.94678435699844876172193153252010e-01 8.73824969554963526530144690696034e-03
 	 1.46670103677618013371386496146442e-01 3.19193924734006762022886505292263e-01 5.34135971588375224605726998561295e-01 8.19776236912691733116353987043112e-03
 	 9.32803959285448680560648426762782e-02 3.39164712620700026235454060952179e-01 5.67554891450755105708481096371543e-01 7.15816823729003084975097692677082e-03
 	 5.09940415878905595192804867110681e-02 3.54982214694466668980510348774260e-01 5.94023743717642771500209164514672e-01 5.66279420727774929211761900660349e-03
 	 2.09636483937665207832878877525218e-02 3.66215290092678835698336570203537e-01 6.12821061513554643518375542043941e-01 3.79582995703961305344886767443313e-03
 	 4.00147938386741230942789115943015e-03 3.72560106231905940887827455298975e-01 6.23438414384226646802744653541595e-01 1.67797576617481278282717482852604e-03
 	 9.89866848202597293671090028510662e-01 2.98040738777144344900937866782442e-03 7.15274440963126287990059282151378e-03 2.65855134379770069452675329557678e-05
 	 9.66300751945632585560019833792467e-01 9.91177176377860263967178866550967e-03 2.37874762905888118003083775420237e-02 1.56699470754909282212141707901765e-04
 	 9.30020889699693431573734869743930e-01 2.05825651780095139620208044561878e-02 4.93965451222970544642443257998821e-02 4.58244543001852695784936742029458e-04
 	 8.82019825362079235020473788608797e-01 3.47008503505839699387891528203909e-02 8.32793242873367950407370585708122e-02 9.75447575854630852948412567116065e-04
 	 8.23607429774869448380059111514129e-01 5.18813622807585417273656958059291e-02 1.24511207944372009892575192679942e-01 1.72192970956555613248895042488584e-03
 	 7.56377193406150616361571792367613e-01 7.16554165099972939501071778067853e-02 1.71967390083852089688321029825602e-01 2.67732883687569599845401668858358e-03
 	 6.82163039113651503697610678500496e-01 9.34836115427872815786258797743358e-02 2.24353349343561214723763441725168e-01 3.78785490397500444748057901733773e-03
 	 6.02989360559831988339851704949979e-01 1.16770523768786549378972949853051e-01 2.80240115671381462281175345196971e-01 4.97076204609776112208763265698508e-03
 	 5.21015820870776247275557579996530e-01 1.40880943525219903822431888329447e-01 3.38103235604003848902010531674023e-01 6.12228986038306204758852047120854e-03
 	 4.38478449224138033812891990237404e-01 1.65157200028742234820811063400470e-01 3.96364350747119731366296946362127e-01 7.12824122621380073389074638612328e-03
 	 3.57628649976634627183358361435239e-01 1.88937100280395398055333089359920e-01 4.53434249742970030272459780462668e-01 7.87606859857540968217204380152907e-03
 	 2.80671790060171733038885122368811e-01 2.11571992012058451848588447319344e-01 5.07756217927769815112526430311846e-01 8.26716698080807652071477775734820e-03
 	 2.09707039588842958366399216174614e-01 2.32444458032977641082084119261708e-01 5.57848502378179400551516664563678e-01 8.22803900173310273635784994894493e-03
 	 1.46670103677618013371386496146442e-01 2.50985160200337231728440201550256e-01 6.02344736122044754900173302303301e-01 7.71910975884210464464940670836768e-03
 	 9.32803959285448680560648426762782e-02 2.66688376986952579983380928752013e-01 6.40031227084502551960554228571709e-01 6.74021565982325758514814850741459e-03
 	 5.09940415878905595192804867110681e-02 2.79125826400382859304727389826439e-01 6.69880132011726581175992123462493e-01 5.33215383167634070921137023901792e-03
 	 2.09636483937665207832878877525218e-02 2.87958498359011660916451091907220e-01 6.91077853247221818300261020340258e-01 3.57419826837579489645091435079394e-03
 	 4.00147938386741230942789115943015e-03 2.92947486468583706553658885241020e-01 7.03051034147548881136913223599549e-01 1.58000177713861012299134678471546e-03
 	 9.89866848202597293671090028510662e-01 2.23045449718607680100745938034379e-03 7.90269730021662952790251210899442e-03 2.41721689293443509126500107209168e-05
 	 9.66300751945632585560019833792467e-01 7.41769598220353224005130243767780e-03 2.62815520721638821999288637698555e-02 1.42474813851657823972687855196284e-04
 	 9.30020889699693320551432407228276e-01 1.54034227848442797914607638176676e-02 5.45756875154623996571068289540563e-02 4.16646627127689522449016656935328e-04
 	 8.82019825362079235020473788608797e-01 2.59691571153012057404652068726136e-02 9.20110175226195592390610045185895e-02 8.86899688444451098599807803424255e-04
 	 8.23607429774869448380059111514129e-01 3.88265772974697997987902908789692e-02 1.37565992927660751821150597606902e-01 1.56561865623471344576012054261582e-03
 	 7.56377193406150505339269329851959e-01 5.36249328391213975208984265918843e-02 1.89997873754728097139832243556157e-01 2.43428982762910681159063130962750e-03
 	 6.82163039113651503697610678500496e-01 6.99605505724897602792822226547287e-02 2.47876410313858736023107098844775e-01 3.44400603104155940414887737688332e-03
 	 6.02989360559831988339851704949979e-01 8.73878319277729409542132543720072e-02 3.09622807512395070705935040678014e-01 4.51953279616598008194827684746997e-03
 	 5.21015820870776247275557579996530e-01 1.05431403553392866179194697906496e-01 3.73552775575830886545247722096974e-01 5.56652874449252953181765946055748e-03
 	 4.38478449224138033812891990237404e-01 1.23599082816063021716956882301020e-01 4.37922467959798944470151127461577e-01 6.48116319028924775524913570734498e-03
 	 3.57628649976634571672207130177412e-01 1.41395302781346376974624945432879e-01 5.00976047242019051353167924389709e-01 7.16110528043862725605661623262677e-03
 	 2.80671790060171733038885122368811e-01 1.58334630023437838985955750104040e-01 5.60993579916390427975159127527149e-01 7.51670105199957194752613531818497e-03
 	 2.09707039588842958366399216174614e-01 1.73955006584956772819339221314294e-01 6.16337953826200268814261562511092e-01 7.48112498075796748114862921852364e-03
 	 1.46670103677618013371386496146442e-01 1.87830355538878501775457152689341e-01 6.65499540783503484853156351164216e-01 7.01839464226198736507278397311893e-03
 	 9.32803959285448680560648426762782e-02 1.99582208874668154408027476165444e-01 7.07137395196786977535907681158278e-01 6.12836129456590349151579033559756e-03
 	 5.09940415878905595192804867110681e-02 2.08890052188817509914997572195716e-01 7.40115906223291930565721941093216e-01 4.84811863713770739570119161498951e-03
 	 2.09636483937665207832878877525218e-02 2.15500179708003392065052139514592e-01 7.63536171898230087151659972732887e-01 3.24974443437809267995475259738214e-03
 	 4.00147938386741230942789115943015e-03 2.19233800491208996596981251059333e-01 7.76764720124923591093590857781237e-01 1.43657446957943537267643474564238e-03
 	 9.89866848202597293671090028510662e-01 1.56209099688777233727599025314703e-03 8.57106080051493399163398123619118e-03 2.10634511289657587701333596452713e-05
 	 9.66300751945632585560019833792467e-01 5.19495740714233031343205482244230e-03 2.85042906472250841265481113850910e-02 1.24151510253171499902069552234707e-04
 	 9.30020889699693320551432407228276e-01 1.07877332103466228030441698138020e-02 5.91913770899600566455234229579219e-02 3.63062822132550393292721446769633e-04
 	 8.82019825362079235020473788608797e-01 1.81874082514366514073955727326393e-02 9.97927663864841135721306386585638e-02 7.72837898760761520325357487593010e-04
 	 8.23607429774869448380059111514129e-01 2.71920574541471560259253692493076e-02 1.49200512770983395594015519236564e-01 1.36426864087332085258286173967690e-03
 	 7.56377193406150505339269329851959e-01 3.75560339394427344927862577605993e-02 2.06066772654406760167944412387442e-01 2.12122234326098417153683151070709e-03
 	 6.82163039113651503697610678500496e-01 4.89966266177905285239546628872631e-02 2.68840334268557967778434658612241e-01 3.00108165447422617702621927548989e-03
 	 6.02989360559831988339851704949979e-01 6.12017620911491366797463342663832e-02 3.35808877349018874980401960783638e-01 3.93828780760478551481451603422101e-03
 	 5.21015820870776247275557579996530e-01 7.38385142973202457383763430698309e-02 4.05145664831903506986066076933639e-01 4.85063241574746999151823700913155e-03
 	 4.38478449224138089324043221495231e-01 8.65621848525210402236496065597748e-02 4.74959365923340925963458403202822e-01 5.64763817912024897877065754414616e-03
 	 3.57628649976634571672207130177412e-01 9.90257051895083728609847639745567e-02 5.43345644833857055466808105848031e-01 6.24013474110653599408182756747010e-03
 	 2.80671790060171733038885122368811e-01 1.10889103708325831298964203597279e-01 6.08439106231502435662150674033910e-01 6.54999829442831117687351394351936e-03
 	 2.09707039588842958366399216174614e-01 1.21828779736475656392258315463550e-01 6.68464180674681385241342468361836e-01 6.51899756627071294556863279012759e-03
 	 1.46670103677618013371386496146442e-01 1.31546331790078019352563387656119e-01 7.21783564532303967276050116197439e-01 6.11577773526218292782230534498922e-03
 	 9.32803959285448680560648426762782e-02 1.39776701123208169086353791499278e-01 7.66942902948246962857581365824444e-01 5.34020918875961064786750398525328e-03
 	 5.09940415878905595192804867110681e-02 1.46295416595690563887899315886898e-01 8.02710541816418876592820197402034e-01 4.22461510505205833920783220492012e-03
 	 2.09636483937665207832878877525218e-02 1.50924796257560833723232462943997e-01 8.28111555348672645493479649303481e-01 2.83180352062052621484045111799333e-03
 	 4.00147938386741230942789115943015e-03 1.53539624499336890828260493435664e-01 8.42458896116795696862311615404906e-01 1.25182048088256104440008087408387e-03
 	 9.89866848202597293671090028510662e-01 9.94543723904412618752601815685921e-04 9.13860807349829371015736967365228e-03 1.73488166675462788916557005380881e-05
 	 9.66300751945632585560019833792467e-01 3.30749763971358023972868522832869e-03 3.03917504146538342002514809792046e-02 1.02256832329784621573275094075228e-04
 	 9.30020889699693320551432407228276e-01 6.86827616373250626757851478032535e-03 6.31108341365741731809890779913985e-02 2.99035058472341293538815376606976e-04
 	 8.82019825362079235020473788608797e-01 1.15794616104897551966956825708621e-02 1.06400713027431009782830528820341e-01 6.36544455001210492117724726313099e-04
 	 8.23607429774869448380059111514129e-01 1.73124934046420264621701790019870e-02 1.59080076820488525157770709483884e-01 1.12367372235814264903874803991357e-03
 	 7.56377193406150505339269329851959e-01 2.39109744077843355825052640284412e-02 2.19711832186065159078225406119600e-01 1.74713523054779171564399042893001e-03
 	 6.82163039113651503697610678500496e-01 3.11949096386171520478569618717302e-02 2.86642051247731344254532359627774e-01 2.47182738996704369147106028492544e-03
 	 6.02989360559831988339851704949979e-01 3.89656098786262394817470067209797e-02 3.58045029561541772178401288329042e-01 3.24375301748204168325595553312723e-03
 	 5.21015820870776247275557579996530e-01 4.70111095468416229081753954233136e-02 4.31973069582382129816267024580156e-01 3.99520154542652022877646800225193e-03
 	 4.38478449224138033812891990237404e-01 5.51119479236800158261644355661701e-02 5.06409602852181950360943574196426e-01 4.65165175328051839348519891359501e-03
 	 3.57628649976634571672207130177412e-01 6.30471552538560686684832035098225e-02 5.79324194769509359659309666312765e-01 5.13965887837675074883980741446976e-03
 	 2.80671790060171733038885122368811e-01 7.06002802411799246229406890051905e-02 6.48727929698648342338174188625999e-01 5.39487659866482501674900262855772e-03
 	 2.09707039588842958366399216174614e-01 7.75652945438169982850240558036603e-02 7.12727665867340043348576728021726e-01 5.36934298852308460742177587121660e-03
 	 1.46670103677618013371386496146442e-01 8.37522135042871873622516432078555e-02 7.69577682818094799266361860645702e-01 5.03723279052869458288776982612944e-03
 	 9.32803959285448680560648426762782e-02 8.89922809408117965190854192769621e-02 8.17727323130643335424849738046760e-01 4.39843924981184013212054395580708e-03
 	 5.09940415878905595192804867110681e-02 9.31425817709123915477675836882554e-02 8.55863376641197048932951929600677e-01 3.47958520660966545701153762593094e-03
 	 2.09636483937665207832878877525218e-02 9.60899904029682838668691147177014e-02 8.82946361203265195349842997529777e-01 2.33240221732695148654235239860100e-03
 	 4.00147938386741230942789115943015e-03 9.77547852338248590697844520036597e-02 8.98243735382307728620787656836910e-01 1.03105630176841454002933939904096e-03
 	 9.89866848202597293671090028510662e-01 5.44137754823457303610112489877793e-04 9.58901404257924902529985899946041e-03 1.31352202604429231101897113109800e-05
 	 9.66300751945632585560019833792467e-01 1.80960806096305132362189738159941e-03 3.18896399934043631163582688259339e-02 7.74211890946722422262790685998368e-05
 	 9.30020889699693431573734869743930e-01 3.75779192147421281511299184785457e-03 6.62213183788323556111521384082153e-02 2.26406874537810835074091997398682e-04
 	 8.82019825362079235020473788608797e-01 6.33538987915015228136184077811777e-03 1.11644784758770612698164370613085e-01 4.81943626601655412955427237875483e-04
 	 8.23607429774869448380059111514129e-01 9.47206348516785312519061790226260e-03 1.66920506739962698494750270583609e-01 8.50761301297071285271167440100726e-04
 	 7.56377193406150505339269329851959e-01 1.30822442665612104217842670550453e-02 2.30540562327288284238946403092996e-01 1.32279950372377486794706058503834e-03
 	 6.82163039113651503697610678500496e-01 1.70674528275533421428633573668776e-02 3.00769508058795154159525964132627e-01 1.87148194803103858074866394645142e-03
 	 6.02989360559832099362154167465633e-01 2.13189817250510893487103203369770e-02 3.75691657715116811289135512197390e-01 2.45592602490329620784637043584553e-03
 	 5.21015820870776247275557579996530e-01 2.57208597125857529874792817281559e-02 4.53263319416637999736963138275314e-01 3.02486638078362270187771088103545e-03
 	 4.38478449224138033812891990237404e-01 3.01530147808974913203883261303417e-02 5.31368535994964474866719683632255e-01 3.52188114757782033334421178949469e-03
 	 3.57628649976634571672207130177412e-01 3.44945492925723407040550227975473e-02 6.07876800730793087623737847025041e-01 3.89136347018461878355388705585938e-03
 	 2.80671790060171733038885122368811e-01 3.86270377631329209222599274653476e-02 6.80701172176695346038854950165842e-01 4.08459514901278117338101480982004e-03
 	 2.09707039588842958366399216174614e-01 4.24377573462515478297518711769953e-02 7.47855203064905493803848912648391e-01 4.06526301820045714990881080552754e-03
 	 1.46670103677618013371386496146442e-01 4.58227630644600925080567321856506e-02 8.07507133257921894120556771667907e-01 3.81381413353064141133486053547585e-03
 	 9.32803959285448680560648426762782e-02 4.86897245277935208918052012450062e-02 8.58029879543661611052129956078716e-01 3.33016766823827177132488763788842e-03
 	 5.09940415878905595192804867110681e-02 5.09604496062918688181753168464638e-02 8.98045508805817571662544196442468e-01 2.63448043631099321909561083998597e-03
 	 2.09636483937665207832878877525218e-02 5.25730446858705402490841152030043e-02 9.26463306920362938967627997044474e-01 1.76591968476130355830688856144661e-03
 	 4.00147938386741230942789115943015e-03 5.34838922431279950586713312077336e-02 9.42514628373004592631900777632836e-01 7.80638350394263574004438677178541e-04
 	 9.89866848202597182648787565995008e-01 2.23821312401371180778042457859556e-04 9.90933048500144617043439154713269e-03 8.54439398493299247228354581507048e-06
 	 9.66300751945632585560019833792467e-01 7.44349840727853706567884728428908e-04 3.29548982136395607334122814791044e-02 5.03620898081971507705134616372789e-05
 	 9.30020889699693320551432407228276e-01 1.54570035278751849450173949662712e-03 6.84334099475191609540658532750967e-02 1.47276520575309886927975466797136e-04
 	 8.82019825362079235020473788608797e-01 2.60594907219002802634122417657636e-03 1.15374225565730736953184987214627e-01 3.13501878351685864775022505313018e-04
 	 8.23607429774869448380059111514129e-01 3.89616353874802645584907168085920e-03 1.72496406686382525164091816805012e-01 5.53415900250106692834228816479936e-04
 	 7.56377193406150616361571792367613e-01 5.38114669482372964814942406519549e-03 2.38241659899025653990278783567192e-01 8.60474350546493594975305807537325e-04
 	 6.82163039113651503697610678500496e-01 7.02039080609445642622290506551508e-03 3.10816570080254039876166416433989e-01 1.21738949043918636902517071973762e-03
 	 6.02989360559831988339851704949979e-01 8.76918101430018692710177674598526e-03 3.88241458425867824733046518304036e-01 1.59756739046235975154619524118971e-03
 	 5.21015820870776247275557579996530e-01 1.05798146258575531675205638748594e-02 4.68404364503366199556921856128611e-01 1.96766019881893438822628716877716e-03
 	 4.38478449224138033812891990237404e-01 1.24029021719106458121473224309739e-02 5.49118648603951320374960687331622e-01 2.29096577722695234416439014069056e-03
 	 3.57628649976634571672207130177412e-01 1.41887145762606969867647421779111e-02 6.28182635447104731341028127644677e-01 2.53131214921189758373931688595349e-03
 	 2.80671790060171733038885122368811e-01 1.58885396385088917270422825822607e-02 7.03439670301319375234072595048929e-01 2.65700837367872488153919263709213e-03
 	 2.09707039588842958366399216174614e-01 1.74560108362461496867013011069503e-02 7.72836949574910891946899482718436e-01 2.64443292089197503486053264509792e-03
 	 1.46670103677618013371386496146442e-01 1.88483722660856001240858859091531e-02 8.34481524056296386504527617944404e-01 2.48086670006802088861430632960037e-03
 	 9.32803959285448680560648426762782e-02 2.00276454770312861697334483324084e-02 8.86691958594423845774201708991313e-01 2.16625713380720532480472328984433e-03
 	 5.09940415878905595192804867110681e-02 2.09616675379284966851400895393454e-02 9.28044290874180943795579423749587e-01 1.71371612710819148754637364362452e-03
 	 2.09636483937665207832878877525218e-02 2.16249796199957655673529188788962e-02 9.57411371986237713649359193368582e-01 1.14872177498152221522542681952928e-03
 	 4.00147938386741230942789115943015e-03 2.19996404367756026587699125229847e-02 9.73998880179356985031802196317585e-01 5.07801277273126007612280563563445e-04
 	 9.89866848202597293671090028510662e-01 4.27357143881167134136234153629630e-05 1.00904160830145896154963480739752e-02 3.71512444665073832079709922893151e-06
 	 9.66300751945632585560019833792467e-01 1.42123740839932011237323195018689e-04 3.35571243135274824287428430125146e-02 2.18975659784396662493628077372776e-05
 	 9.30020889699693320551432407228276e-01 2.95131004718091061178597556136083e-04 6.96839792955885883873889952155878e-02 6.40362093522171702203796272989678e-05
 	 8.82019825362079235020473788608797e-01 4.97571451369999140368349799246062e-04 1.17482603186550765839157861591957e-01 1.36311421780067621714258030429789e-04
 	 8.23607429774869448380059111514129e-01 7.43920810824028055918688551173545e-04 1.75648649414306523564022199934698e-01 2.40626654600656445523801374442030e-04
 	 7.56377193406150505339269329851959e-01 1.02745867121961653722905793983955e-03 2.42595347922629878123501612208202e-01 3.74136457315558262643612197351217e-04
 	 6.82163039113651503697610678500496e-01 1.34045061733972792339386614912655e-03 3.16496510269008768378995455350378e-01 5.29324076698901749109260617132122e-04
 	 6.02989360559831988339851704949979e-01 1.67435893938816526826940389582887e-03 3.95336280500779846391878891154192e-01 6.94626403925741107807378948990618e-04
 	 5.21015820870776247275557579996530e-01 2.02007543999682681601370859425515e-03 4.76964103689226925908428711409215e-01 8.55543707397430188213438562172541e-04
 	 4.38478449224138033812891990237404e-01 2.36816985440602145729371841298416e-03 5.59153380921455944729814291349612e-01 9.96117803137890750475591516988061e-04
 	 3.57628649976634571672207130177412e-01 2.70914707433311807704967577592470e-03 6.39662202949032310250743194046663e-01 1.10062102288637506455892811629838e-03
 	 2.80671790060171733038885122368811e-01 3.03370615045783775798327042139135e-03 7.16294503789370429203131607209798e-01 1.15527406407242854043115887208160e-03
 	 2.09707039588842958366399216174614e-01 3.33299400959596869853385214810260e-03 7.86959966401561072935066931677284e-01 1.14980622490698969513645000262159e-03
 	 1.46670103677618013371386496146442e-01 3.59884697843182443932619207771495e-03 8.49731049343950162189287311775843e-01 1.07868721205471519881957664921401e-03
 	 9.32803959285448680560648426762782e-02 3.82401357489137172507298600976355e-03 9.02895590496563760218862171313958e-01 9.41894164727215786603320424319463e-04
 	 5.09940415878905595192804867110681e-02 4.00235271336957243448750887182541e-03 9.45003605698739868046232004417107e-01 7.45128172889279022893249671000149e-04
 	 2.09636483937665207832878877525218e-02 4.12900336779242760343322515836917e-03 9.74907348238441051613278887089109e-01 4.99467177679231212096555569956990e-04
 	 4.00147938386741230942789115943015e-03 4.20053988719948367958068047300912e-03 9.91797980728933104010991428367561e-01 2.20793299391923496200959564639277e-04
 	 ];
 
 	 case  35 

 	 % ALG. DEG.:   35
 	 % PTS CARD.:  324
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 9.89866848202597293671090028510662e-01 1.00904160830146451266475793318023e-02 4.27357143880612022623921575359418e-05 3.71512444665076500233493773939220e-06
 	 9.66300751945632585560019833792467e-01 3.35571243135274824287428430125146e-02 1.42123740839932011237323195018689e-04 2.18975659784398254915568915457413e-05
 	 9.30020889699693320551432407228276e-01 6.96839792955885328762377639577608e-02 2.95131004718146572329828813963104e-04 6.40362093522176310063029336383522e-05
 	 8.82019825362079235020473788608797e-01 1.17482603186550751961370053777500e-01 4.97571451370013018156157613702817e-04 1.36311421780068597496213267383780e-04
 	 8.23607429774869448380059111514129e-01 1.75648649414306495808446584305784e-01 7.43920810824055811494304180087056e-04 2.40626654600658180247277351249124e-04
 	 7.56377193406150505339269329851959e-01 2.42595347922629794856774765321461e-01 1.02745867121969980395590482658008e-03 3.74136457315560973149043411112302e-04
 	 6.82163039113651503697610678500496e-01 3.16496510269008712867844224092551e-01 1.34045061733978343454509740695357e-03 5.29324076698905543816864316397641e-04
 	 6.02989360559832099362154167465633e-01 3.95336280500779735369576428638538e-01 1.67435893938816526826940389582887e-03 6.94626403925746203557589630861457e-04
 	 5.21015820870776247275557579996530e-01 4.76964103689226870397277480151388e-01 2.02007543999688232716493985208217e-03 8.55543707397436368165821729547815e-04
 	 4.38478449224138033812891990237404e-01 5.59153380921455833707511828833958e-01 2.36816985440613247959618092863820e-03 9.96117803137897906209929921317325e-04
 	 3.57628649976634571672207130177412e-01 6.39662202949032199228440731531009e-01 2.70914707433322909935213829157874e-03 1.10062102288638308765500450903119e-03
 	 2.80671790060171733038885122368811e-01 7.16294503789370318180829144694144e-01 3.03370615045794878028573293704540e-03 1.15527406407243699720810425901618e-03
 	 2.09707039588842958366399216174614e-01 7.86959966401560961912764469161630e-01 3.33299400959607972083631466375664e-03 1.14980622490699793507296089245528e-03
 	 1.46670103677618013371386496146442e-01 8.49731049343950051166984849260189e-01 3.59884697843193546162865459336899e-03 1.07868721205472300507521854484594e-03
 	 9.32803959285448680560648426762782e-02 9.02895590496563649196559708798304e-01 3.82401357489148274737544852541760e-03 9.41894164727222508656789834446954e-04
 	 5.09940415878905595192804867110681e-02 9.45003605698739757023929541901452e-01 4.00235271336968345678997138747945e-03 7.45128172889284335483894849971875e-04
 	 2.09636483937665207832878877525218e-02 9.74907348238440940590976424573455e-01 4.12900336779253862573568767402321e-03 4.99467177679234898383942020672066e-04
 	 4.00147938386741230942789115943015e-03 9.91797980728932992988688965851907e-01 4.20053988719959470188314298866317e-03 2.20793299391925095399163980758317e-04
 	 9.89866848202597182648787565995008e-01 9.90933048500138892455968431249858e-03 2.23821312401428426652749692493671e-04 8.54439398493292301558187096244268e-06
 	 9.66300751945632585560019833792467e-01 3.29548982136395607334122814791044e-02 7.44349840727853706567884728428908e-04 5.03620898081967441946987795731161e-05
 	 9.30020889699693320551432407228276e-01 6.84334099475190915651268142028130e-02 1.54570035278758788344077856891090e-03 1.47276520575308694305585732742259e-04
 	 8.82019825362079235020473788608797e-01 1.15374225565730723075397179400170e-01 2.60594907219004190412903199103312e-03 3.13501878351683316899917164377598e-04
 	 8.23607429774869448380059111514129e-01 1.72496406686382469652940585547185e-01 3.89616353874808196700030293868622e-03 5.53415900250102139185104377361313e-04
 	 7.56377193406150616361571792367613e-01 2.38241659899025681745854399196105e-01 5.38114669482370189257380843628198e-03 8.60474350546486656081401900308947e-04
 	 6.82163039113651503697610678500496e-01 3.10816570080253984365015185176162e-01 7.02039080609451193737413632334210e-03 1.21738949043917639436518385309682e-03
 	 6.02989360559831988339851704949979e-01 3.88241458425867713710744055788382e-01 8.76918101430029794940423926163930e-03 1.59756739046234674112012541513650e-03
 	 5.21015820870776247275557579996530e-01 4.68404364503366144045770624870784e-01 1.05798146258576086786717951326864e-02 1.96766019881891834203413438331154e-03
 	 4.38478449224138033812891990237404e-01 5.49118648603951209352658224815968e-01 1.24029021719107568344497849466279e-02 2.29096577722693412956789238421607e-03
 	 3.57628649976634571672207130177412e-01 6.28182635447104620318725665129023e-01 1.41887145762608080090672046935651e-02 2.53131214921187676705760516426835e-03
 	 2.80671790060171733038885122368811e-01 7.03439670301319264211770132533275e-01 1.58885396385090027493447450979147e-02 2.65700837367870363117661192120522e-03
 	 2.09707039588842958366399216174614e-01 7.72836949574910669902294557687128e-01 1.74560108362463717313062261382584e-02 2.64443292089195335081708293500924e-03
 	 1.46670103677618013371386496146442e-01 8.34481524056296275482225155428750e-01 1.88483722660857111463883484248072e-02 2.48086670006800093929433259631878e-03
 	 9.32803959285448680560648426762782e-02 8.86691958594423734751899246475659e-01 2.00276454770313971920359108480625e-02 2.16625713380718754388909452757161e-03
 	 5.09940415878905595192804867110681e-02 9.28044290874180721750974498718278e-01 2.09616675379287187297450145706534e-02 1.71371612710817760975856582916776e-03
 	 2.09636483937665207832878877525218e-02 9.57411371986237602627056730852928e-01 2.16249796199958765896553813945502e-02 1.14872177498151289108674344419114e-03
 	 4.00147938386741230942789115943015e-03 9.73998880179356762987197271286277e-01 2.19996404367758247033748375542928e-02 5.07801277273121887644025118646596e-04
 	 9.89866848202597293671090028510662e-01 9.58901404257930453645109025728743e-03 5.44137754823401792458881232050771e-04 1.31352202604428841466741376131644e-05
 	 9.66300751945632585560019833792467e-01 3.18896399934043631163582688259339e-02 1.80960806096305132362189738159941e-03 7.74211890946720118333174154301446e-05
 	 9.30020889699693431573734869743930e-01 6.62213183788324111223033696660423e-02 3.75779192147415730396176059002755e-03 2.26406874537810184552788506096022e-04
 	 8.82019825362079235020473788608797e-01 1.11644784758770612698164370613085e-01 6.33538987915015228136184077811777e-03 4.81943626601654003492603006719719e-04
 	 8.23607429774869448380059111514129e-01 1.66920506739962698494750270583609e-01 9.47206348516785312519061790226260e-03 8.50761301297068791606170723440528e-04
 	 7.56377193406150505339269329851959e-01 2.30540562327288228727795171835169e-01 1.30822442665612659329354983128724e-02 1.32279950372377096481923963722238e-03
 	 6.82163039113651503697610678500496e-01 3.00769508058795154159525964132627e-01 1.70674528275533421428633573668776e-02 1.87148194803103315973780151892925e-03
 	 6.02989360559831988339851704949979e-01 3.75691657715116866800286743455217e-01 2.13189817250511448598615515948040e-02 2.45592602490328883527159753441538e-03
 	 5.21015820870776247275557579996530e-01 4.53263319416637999736963138275314e-01 2.57208597125857529874792817281559e-02 3.02486638078361402826033099699998e-03
 	 4.38478449224138033812891990237404e-01 5.31368535994964474866719683632255e-01 3.01530147808974913203883261303417e-02 3.52188114757781035868422492285390e-03
 	 3.57628649976634571672207130177412e-01 6.07876800730793087623737847025041e-01 3.44945492925723407040550227975473e-02 3.89136347018460750785129320661326e-03
 	 2.80671790060171733038885122368811e-01 6.80701172176695346038854950165842e-01 3.86270377631329209222599274653476e-02 4.08459514901276989767842096057393e-03
 	 2.09707039588842958366399216174614e-01 7.47855203064905493803848912648391e-01 4.24377573462515478297518711769953e-02 4.06526301820044500684447896787788e-03
 	 1.46670103677618013371386496146442e-01 8.07507133257921894120556771667907e-01 4.58227630644600925080567321856506e-02 3.81381413353063013563226668622974e-03
 	 9.32803959285448680560648426762782e-02 8.58029879543661611052129956078716e-01 4.86897245277935208918052012450062e-02 3.33016766823826223034576976544940e-03
 	 5.09940415878905595192804867110681e-02 8.98045508805817571662544196442468e-01 5.09604496062918688181753168464638e-02 2.63448043631098584652083793855581e-03
 	 2.09636483937665207832878877525218e-02 9.26463306920362938967627997044474e-01 5.25730446858705402490841152030043e-02 1.76591968476129835413646063102533e-03
 	 4.00147938386741230942789115943015e-03 9.42514628373004592631900777632836e-01 5.34838922431279950586713312077336e-02 7.80638350394261297179876457619230e-04
 	 9.89866848202597293671090028510662e-01 9.13860807349834922130860093147930e-03 9.94543723904357107601370557858900e-04 1.73488166675464347457179953293505e-05
 	 9.66300751945632585560019833792467e-01 3.03917504146538307308045290255905e-02 3.30749763971358370917563718194288e-03 1.02256832329785556697648862822803e-04
 	 9.30020889699693320551432407228276e-01 6.31108341365741176698378467335715e-02 6.86827616373256177872974603815237e-03 2.99035058472344004044246590368061e-04
 	 8.82019825362079235020473788608797e-01 1.06400713027430995905042721005884e-01 1.15794616104897690744834903853189e-02 6.36544455001216346809456148037043e-04
 	 8.23607429774869448380059111514129e-01 1.59080076820488525157770709483884e-01 1.73124934046420264621701790019870e-02 1.12367372235815284053916940365525e-03
 	 7.56377193406150616361571792367613e-01 2.19711832186065075811498559232859e-01 2.39109744077843078269296483995277e-02 1.74713523054780754499570871729475e-03
 	 6.82163039113651503697610678500496e-01 2.86642051247731344254532359627774e-01 3.11949096386171520478569618717302e-02 2.47182738996706624287624798341767e-03
 	 6.02989360559831988339851704949979e-01 3.58045029561541661156098825813388e-01 3.89656098786263505040494692366337e-02 3.24375301748207117355504713884784e-03
 	 5.21015820870776247275557579996530e-01 4.31973069582382129816267024580156e-01 4.70111095468416229081753954233136e-02 3.99520154542655579060772552679737e-03
 	 4.38478449224138033812891990237404e-01 5.06409602852181839338641111680772e-01 5.51119479236801268484668980818242e-02 4.65165175328056002684862235696528e-03
 	 3.57628649976634571672207130177412e-01 5.79324194769509359659309666312765e-01 6.30471552538560686684832035098225e-02 5.13965887837679758637365878826131e-03
 	 2.80671790060171733038885122368811e-01 6.48727929698648231315871726110345e-01 7.06002802411800356452431515208445e-02 5.39487659866487445636806796755991e-03
 	 2.09707039588842958366399216174614e-01 7.12727665867339932326274265506072e-01 7.75652945438171093073265183193143e-02 5.36934298852313317967910322181524e-03
 	 1.46670103677618013371386496146442e-01 7.69577682818094799266361860645702e-01 8.37522135042871873622516432078555e-02 5.03723279052874055305988321151744e-03
 	 9.32803959285448680560648426762782e-02 8.17727323130643224402547275531106e-01 8.89922809408119075413878817926161e-02 4.39843924981188003076049142237025e-03
 	 5.09940415878905595192804867110681e-02 8.55863376641196937910649467085022e-01 9.31425817709125025700700462039094e-02 3.47958520660969711571497420266041e-03
 	 2.09636483937665207832878877525218e-02 8.82946361203265084327540535014123e-01 9.60899904029683948891715772333555e-02 2.33240221732697273690493311448790e-03
 	 4.00147938386741230942789115943015e-03 8.98243735382307617598485194321256e-01 9.77547852338249700920869145193137e-02 1.03105630176842386416802277437910e-03
 	 9.89866848202597293671090028510662e-01 8.57106080051498950278521249401820e-03 1.56209099688771682612475899532001e-03 2.10634511289658231446373509720971e-05
 	 9.66300751945632585560019833792467e-01 2.85042906472250841265481113850910e-02 5.19495740714233031343205482244230e-03 1.24151510253171879372829922161259e-04
 	 9.30020889699693320551432407228276e-01 5.91913770899600080732660956073232e-02 1.07877332103466713753014971644006e-02 3.63062822132551423284785307998845e-04
 	 8.82019825362079235020473788608797e-01 9.97927663864841274499184464730206e-02 1.81874082514366375296077649181825e-02 7.72837898760763797149919707152321e-04
 	 8.23607429774869448380059111514129e-01 1.49200512770983395594015519236564e-01 2.71920574541471560259253692493076e-02 1.36426864087332497255111718459375e-03
 	 7.56377193406150505339269329851959e-01 2.06066772654406732412368796758528e-01 3.75560339394427622483618733895128e-02 2.12122234326099024306899742953192e-03
 	 6.82163039113651503697610678500496e-01 2.68840334268558023289585889870068e-01 4.89966266177904730128034316294361e-02 3.00108165447423485064359915952537e-03
 	 6.02989360559831988339851704949979e-01 3.35808877349018874980401960783638e-01 6.12017620911491366797463342663832e-02 3.93828780760479765787884787187068e-03
 	 5.21015820870776247275557579996530e-01 4.05145664831903506986066076933639e-01 7.38385142973202457383763430698309e-02 4.85063241574748473666778281199186e-03
 	 4.38478449224137978301740758979577e-01 4.74959365923340925963458403202822e-01 8.65621848525210402236496065597748e-02 5.64763817912026545864367932381356e-03
 	 3.57628649976634571672207130177412e-01 5.43345644833857055466808105848031e-01 9.90257051895083728609847639745567e-02 6.24013474110655507604006331234814e-03
 	 2.80671790060171844061187584884465e-01 6.08439106231502435662150674033910e-01 1.10889103708325720276661741081625e-01 6.54999829442833025883174968839739e-03
 	 2.09707039588842958366399216174614e-01 6.68464180674681496263644930877490e-01 1.21828779736475545369955852947896e-01 6.51899756627073202752686853500563e-03
 	 1.46670103677617902349084033630788e-01 7.21783564532304078298352578713093e-01 1.31546331790078019352563387656119e-01 6.11577773526220114241880310146371e-03
 	 9.32803959285448680560648426762782e-02 7.66942902948247073879883828340098e-01 1.39776701123208058064051328983624e-01 5.34020918875962626037878777651713e-03
 	 5.09940415878906705415829492267221e-02 8.02710541816418876592820197402034e-01 1.46295416595690452865596853371244e-01 4.22461510505207048227216404256978e-03
 	 2.09636483937665207832878877525218e-02 8.28111555348672645493479649303481e-01 1.50924796257560833723232462943997e-01 2.83180352062053488845783100202880e-03
 	 4.00147938386741230942789115943015e-03 8.42458896116795807884614077920560e-01 1.53539624499336779805958030920010e-01 1.25182048088256473068746732479894e-03
 	 9.89866848202597293671090028510662e-01 7.90269730021668503905374336682144e-03 2.23045449718602128985622812251677e-03 2.41721689293442594330917072564802e-05
 	 9.66300751945632585560019833792467e-01 2.62815520721638856693758157234697e-02 7.41769598220352877060435048406362e-03 1.42474813851657308976655924581678e-04
 	 9.30020889699693320551432407228276e-01 5.45756875154623510848495016034576e-02 1.54034227848443283637180911682663e-02 4.16646627127687950355866552953898e-04
 	 8.82019825362079235020473788608797e-01 9.20110175226195592390610045185895e-02 2.59691571153012057404652068726136e-02 8.86899688444447737573073098360510e-04
 	 8.23607429774869448380059111514129e-01 1.37565992927660751821150597606902e-01 3.88265772974697997987902908789692e-02 1.56561865623470759106838912089188e-03
 	 7.56377193406150505339269329851959e-01 1.89997873754728041628681012298330e-01 5.36249328391214530320496578497114e-02 2.43428982762909770429238243139025e-03
 	 6.82163039113651503697610678500496e-01 2.47876410313858763778682714473689e-01 6.99605505724897325237066070258152e-02 3.44400603104154682740367654503189e-03
 	 6.02989360559832099362154167465633e-01 3.09622807512395015194783809420187e-01 8.73878319277728854430620231141802e-02 4.51953279616596273471351707939903e-03
 	 5.21015820870776247275557579996530e-01 3.73552775575830886545247722096974e-01 1.05431403553392866179194697906496e-01 5.56652874449250871513594773887235e-03
 	 4.38478449224138089324043221495231e-01 4.37922467959798999981302358719404e-01 1.23599082816062966205805651043192e-01 6.48116319028922346912047203204565e-03
 	 3.57628649976634571672207130177412e-01 5.00976047242019162375470386905363e-01 1.41395302781346265952322482917225e-01 7.16110528043860036784273859211680e-03
 	 2.80671790060171733038885122368811e-01 5.60993579916390427975159127527149e-01 1.58334630023437838985955750104040e-01 7.51670105199954419195051968927146e-03
 	 2.09707039588842958366399216174614e-01 6.16337953826200379836564025026746e-01 1.73955006584956661797036758798640e-01 7.48112498075793885821127560120658e-03
 	 1.46670103677618013371386496146442e-01 6.65499540783503595875458813679870e-01 1.87830355538878390753154690173687e-01 7.01839464226196047685890633260897e-03
 	 9.32803959285448680560648426762782e-02 7.07137395196787088558210143673932e-01 1.99582208874668043385725013649790e-01 6.12836129456588007274886464870178e-03
 	 5.09940415878905595192804867110681e-02 7.40115906223291930565721941093216e-01 2.08890052188817509914997572195716e-01 4.84811863713768918110469385851502e-03
 	 2.09636483937665207832878877525218e-02 7.63536171898230087151659972732887e-01 2.15500179708003392065052139514592e-01 3.24974443437808053689042075973248e-03
 	 4.00147938386741230942789115943015e-03 7.76764720124923702115893320296891e-01 2.19233800491208885574678788543679e-01 1.43657446957942995166557231812021e-03
 	 9.89866848202597293671090028510662e-01 7.15274440963131925841356206774435e-03 2.98040738777138707049640942159385e-03 2.65855134379769391826317526117407e-05
 	 9.66300751945632585560019833792467e-01 2.37874762905888187392022814492520e-02 9.91177176377859570077788475828129e-03 1.56699470754908875636327025837602e-04
 	 9.30020889699693431573734869743930e-01 4.93965451222971169142894609649375e-02 2.05825651780094515119756692911324e-02 4.58244543001851557372655632249803e-04
 	 8.82019825362079235020473788608797e-01 8.32793242873368089185248663852690e-02 3.47008503505839560610013450059341e-02 9.75447575854628359283415850455867e-04
 	 8.23607429774869448380059111514129e-01 1.24511207944372037648150808308856e-01 5.18813622807585139717900801770156e-02 1.72192970956555179568026048286811e-03
 	 7.56377193406150616361571792367613e-01 1.71967390083852200710623492341256e-01 7.16554165099971829278047152911313e-02 2.67732883687568949324098177555697e-03
 	 6.82163039113651503697610678500496e-01 2.24353349343561270234914672982995e-01 9.34836115427872260674746485165088e-02 3.78785490397499490650146114489871e-03
 	 6.02989360559831988339851704949979e-01 2.80240115671381462281175345196971e-01 1.16770523768786549378972949853051e-01 4.97076204609774811166156283093187e-03
 	 5.21015820870776247275557579996530e-01 3.38103235604003904413161762931850e-01 1.40880943525219848311280657071620e-01 6.12228986038304643507723667994469e-03
 	 4.38478449224138033812891990237404e-01 3.96364350747119842388599408877781e-01 1.65157200028742123798508600884816e-01 7.12824122621378338665598661805234e-03
 	 3.57628649976634627183358361435239e-01 4.53434249742970141294762242978322e-01 1.88937100280395287033030626844265e-01 7.87606859857539060021380805665103e-03
 	 2.80671790060171844061187584884465e-01 5.07756217927769926134828892827500e-01 2.11571992012058229803983522288036e-01 8.26716698080805570403306603566307e-03
 	 2.09707039588842958366399216174614e-01 5.57848502378179622596121589594986e-01 2.32444458032977419037479194230400e-01 8.22803900173308191967613822725980e-03
 	 1.46670103677618013371386496146442e-01 6.02344736122044865922475764818955e-01 2.50985160200337120706137739034602e-01 7.71910975884208469532943297508609e-03
 	 9.32803959285448680560648426762782e-02 6.40031227084502774005159153603017e-01 2.66688376986952357938776003720704e-01 6.74021565982324110527512672774719e-03
 	 5.09940415878906705415829492267221e-02 6.69880132011726692198294585978147e-01 2.79125826400382637260122464795131e-01 5.33215383167632769878530041296472e-03
 	 2.09636483937665207832878877525218e-02 6.91077853247221929322563482855912e-01 2.87958498359011549894148629391566e-01 3.57419826837578578915266547255669e-03
 	 4.00147938386741230942789115943015e-03 7.03051034147549103181518148630857e-01 2.92947486468583484509053960209712e-01 1.58000177713860621986352583689950e-03
 	 9.89866848202597182648787565995008e-01 6.34277657900481940667081204310307e-03 3.79037521839799794454162196188918e-03 2.82340488002669460327557354739625e-05
 	 9.66300751945632585560019833792467e-01 2.10938122277119152747637542688608e-02 1.26054358266554991652164119386725e-02 1.66416214401566610065624773895365e-04
 	 9.30020889699693320551432407228276e-01 4.38029421355502074364451914334495e-02 2.61761681647564720121224013382744e-02 4.86659729922253624697509044594312e-04
 	 8.82019825362079235020473788608797e-01 7.38488777669456530894365187123185e-02 4.41312968709751118900896926788846e-02 1.03593389396196776906788894478950e-03
 	 8.23607429774869448380059111514129e-01 1.10411714489581258558104082112550e-01 6.59808557355492930618368063733215e-02 1.82870447711777801835797419016671e-03
 	 7.56377193406150505339269329851959e-01 1.52494017919572899533164900276461e-01 9.11287886742765951275657698715804e-02 2.84334674261842732315153092770288e-03
 	 6.82163039113651503697610678500496e-01 1.98947856674634743212592979944020e-01 1.18889104211713753089796341555484e-01 4.02273518082179714488999522359336e-03
 	 6.02989360559831988339851704949979e-01 2.48506075484061506042365863322630e-01 1.48504563956106505617782431727392e-01 5.27899295650083658082429849400796e-03
 	 5.21015820870776247275557579996530e-01 2.99816848088013954143349337755353e-01 1.79167331041209798581093082248117e-01 6.50192561037813993723988303941042e-03
 	 4.38478449224138033812891990237404e-01 3.51480547422617473074524241383187e-01 2.10041003353244493112583768379409e-01 7.57025479724230364320103348063640e-03
 	 3.57628649976634571672207130177412e-01 4.02087922436554001670572233706480e-01 2.40283427586811426657220636116108e-01 8.36445403566181584775751645111086e-03
 	 2.80671790060171677527733891110984e-01 4.50258538887499282221682506133220e-01 2.69069671052329095761734834013623e-01 8.77980395303030319853476726166264e-03
 	 2.09707039588842902855247984916787e-01 4.94678435699844876172193153252010e-01 2.95614524711312165461407630573376e-01 8.73824969554959189721454748678298e-03
 	 1.46670103677617902349084033630788e-01 5.34135971588375335628029461076949e-01 3.19193924734006762022886505292263e-01 8.19776236912687569780011642706086e-03
 	 9.32803959285448680560648426762782e-02 5.67554891450755105708481096371543e-01 3.39164712620700026235454060952179e-01 7.15816823728999528791971940222538e-03
 	 5.09940415878905595192804867110681e-02 5.94023743717642771500209164514672e-01 3.54982214694466668980510348774260e-01 5.66279420727772066918026538928643e-03
 	 2.09636483937665207832878877525218e-02 6.12821061513554754540678004559595e-01 3.66215290092678724676034107687883e-01 3.79582995703959397149063192955509e-03
 	 4.00147938386741230942789115943015e-03 6.23438414384226646802744653541595e-01 3.72560106231905940887827455298975e-01 1.67797576617480410920979494449057e-03
 	 9.89866848202597182648787565995008e-01 5.49609493659073376770063390495125e-03 4.63705686081208358351180010004100e-03 2.90703464420603941505312495241498e-05
 	 9.66300751945632585560019833792467e-01 1.82780511238365486748058685861906e-02 1.54211969305308657651742976213427e-02 1.71345492828644613498081938907092e-04
 	 9.30020889699693320551432407228276e-01 3.79557951443320884532539594147238e-02 3.20233151559745909953136333570001e-02 5.01074679310807807701422245116873e-04
 	 8.82019825362079235020473788608797e-01 6.39909727407583783787003994802944e-02 5.39892018971623866008258119109087e-02 1.06661844362408025910227138410846e-03
 	 8.23607429774869448380059111514129e-01 9.56731263332156328660360600224521e-02 8.07194438919149187539048284634191e-02 1.88287103511197749863836925499072e-03
 	 7.56377193406150616361571792367613e-01 1.32137966600053613497323112824233e-01 1.11484839993795770141105094808154e-01 2.92756718838143095706705310021789e-03
 	 6.82163039113651503697610678500496e-01 1.72390796695317150000192896186491e-01 1.45446164191031346302196425313014e-01 4.14188932584293179051115885158652e-03
 	 6.02989360559831988339851704949979e-01 2.15333610788208007491562057111878e-01 1.81677028651960004168586237938143e-01 5.43535768448572768202220473199304e-03
 	 5.21015820870776247275557579996530e-01 2.59795034580844352856132672968670e-01 2.19189144548379399868309747034800e-01 6.69451382518012911432281342172246e-03
 	 4.38478449224138089324043221495231e-01 3.04562273783050618813916798899299e-01 2.56959276992811347373191210863297e-01 7.79448711615256251139527421400999e-03
 	 3.57628649976634571672207130177412e-01 3.48414194799616772080241844378179e-01 2.93957155223748656247551025444409e-01 8.61221067993196177925430134791895e-03
 	 2.80671790060171733038885122368811e-01 3.90154634159382784908132180134999e-01 3.29173575780445482052982697496191e-01 9.03986333711901540732824855695071e-03
 	 2.09707039588843013877550447432441e-01 4.28645028218402390773889010233688e-01 3.61647932192754650859711773591698e-01 8.99707823500162096053145432961173e-03
 	 1.46670103677618013371386496146442e-01 4.62835474706007388157047444110503e-01 3.90494421616374598471566059743054e-01 8.44058157602783909467802914150525e-03
 	 9.32803959285449235672160739341052e-02 4.91793385165905039269063081519562e-01 4.14926218905550092674872075804160e-01 7.37019447761971292776284059300451e-03
 	 5.09940415878904484969780241954140e-02 5.14728975456590465142880930216052e-01 4.34276982955519086360141045588534e-01 5.83052719785975837041291924833786e-03
 	 2.09636483937665207832878877525218e-02 5.31017085540992583858610487368423e-01 4.48019266065240895358101624879055e-01 3.90826312821450274487267151357628e-03
 	 4.00147938386741230942789115943015e-03 5.40217154095457230411625459964853e-01 4.55781366520675357278946648875717e-01 1.72767771243712269652048618695517e-03
 	 9.89866848202597182648787565995008e-01 4.63705686081203067444578280742462e-03 5.49609493659078667676665119756763e-03 2.90703464420604178674537726445593e-05
 	 9.66300751945632585560019833792467e-01 1.54211969305308761735151534821853e-02 1.82780511238365382664650127253481e-02 1.71345492828644749023353499595146e-04
 	 9.30020889699693320551432407228276e-01 3.20233151559745563008441138208582e-02 3.79557951443321231477234789508657e-02 5.01074679310808241382291239318647e-04
 	 8.82019825362079235020473788608797e-01 5.39892018971624282341892353542789e-02 6.39909727407583367453369760369242e-02 1.06661844362408112646400937251201e-03
 	 8.23607429774869448380059111514129e-01 8.07194438919149742650560597212461e-02 9.56731263332155773548848287646251e-02 1.88287103511197923336184523179782e-03
 	 7.56377193406150616361571792367613e-01 1.11484839993795881163407557323808e-01 1.32137966600053502475020650308579e-01 2.92756718838143312547139807122676e-03
 	 6.82163039113651503697610678500496e-01 1.45446164191031429568923272199754e-01 1.72390796695317066733466049299750e-01 4.14188932584293525995811080520070e-03
 	 6.02989360559831988339851704949979e-01 1.81677028651960059679737469195970e-01 2.15333610788207951980410825854051e-01 5.43535768448573201883089467401078e-03
 	 5.21015820870776247275557579996530e-01 2.19189144548379510890612209550454e-01 2.59795034580844241833830210453016e-01 6.69451382518013518585497934054729e-03
 	 4.38478449224138089324043221495231e-01 2.56959276992811458395493673378951e-01 3.04562273783050507791614336383645e-01 7.79448711615256945028917812123836e-03
 	 3.57628649976634516161055898919585e-01 2.93957155223748822781004719217890e-01 3.48414194799616605546788150604698e-01 8.61221067993196871814820525514733e-03
 	 2.80671790060171733038885122368811e-01 3.29173575780445704097587622527499e-01 3.90154634159382562863527255103691e-01 9.03986333711902234622215246417909e-03
 	 2.09707039588842902855247984916787e-01 3.61647932192754872904316698623006e-01 4.28645028218402168729284085202380e-01 8.99707823500162963414883421364721e-03
 	 1.46670103677618013371386496146442e-01 3.90494421616374820516170984774362e-01 4.62835474706007166112442519079195e-01 8.44058157602784603357193304873363e-03
 	 9.32803959285448125449136114184512e-02 4.14926218905550314719477000835468e-01 4.91793385165904817224458156488254e-01 7.37019447761971899929500651182934e-03
 	 5.09940415878905595192804867110681e-02 4.34276982955519308404745970619842e-01 5.14728975456590132075973542669090e-01 5.83052719785976357458334717875914e-03
 	 2.09636483937665207832878877525218e-02 4.48019266065241117402706549910363e-01 5.31017085540992361814005562337115e-01 3.90826312821450621431962346719047e-03
 	 4.00147938386741230942789115943015e-03 4.55781366520675579323551573907025e-01 5.40217154095457008367020534933545e-01 1.72767771243712399756309316956049e-03
 	 9.89866848202597182648787565995008e-01 3.79037521839794243339039070406216e-03 6.34277657900487491782204330093009e-03 2.82340488002670883342908741964195e-05
 	 9.66300751945632585560019833792467e-01 1.26054358266554991652164119386725e-02 2.10938122277119152747637542688608e-02 1.66416214401567450322308450161302e-04
 	 9.30020889699693320551432407228276e-01 2.61761681647564165009711700804473e-02 4.38029421355502629475964226912765e-02 4.86659729922256064152397136979289e-04
 	 8.82019825362079235020473788608797e-01 4.41312968709751118900896926788846e-02 7.38488777669456530894365187123185e-02 1.03593389396197297323831687521078e-03
 	 8.23607429774869448380059111514129e-01 6.59808557355492930618368063733215e-02 1.10411714489581258558104082112550e-01 1.82870447711778734249665756550485e-03
 	 7.56377193406150616361571792367613e-01 9.11287886742765396164145386137534e-02 1.52494017919572844022013669018634e-01 2.84334674261844163462020773636141e-03
 	 6.82163039113651503697610678500496e-01 1.18889104211713753089796341555484e-01 1.98947856674634743212592979944020e-01 4.02273518082181709420996895687495e-03
 	 6.02989360559831988339851704949979e-01 1.48504563956106450106631200469565e-01 2.48506075484061561553517094580457e-01 5.27899295650086346903817613451793e-03
 	 5.21015820870776247275557579996530e-01 1.79167331041209798581093082248117e-01 2.99816848088013954143349337755353e-01 6.50192561037817289698592659874521e-03
 	 4.38478449224138033812891990237404e-01 2.10041003353244493112583768379409e-01 3.51480547422617473074524241383187e-01 7.57025479724234180711750497039247e-03
 	 3.57628649976634571672207130177412e-01 2.40283427586811426657220636116108e-01 4.02087922436554001670572233706480e-01 8.36445403566185921584441587128822e-03
 	 2.80671790060171677527733891110984e-01 2.69069671052328984739432371497969e-01 4.50258538887499393243984968648874e-01 8.77980395303034830134514265864709e-03
 	 2.09707039588843013877550447432441e-01 2.95614524711312165461407630573376e-01 4.94678435699844876172193153252010e-01 8.73824969554963526530144690696034e-03
 	 1.46670103677618013371386496146442e-01 3.19193924734006762022886505292263e-01 5.34135971588375224605726998561295e-01 8.19776236912691733116353987043112e-03
 	 9.32803959285448680560648426762782e-02 3.39164712620700026235454060952179e-01 5.67554891450755105708481096371543e-01 7.15816823729003084975097692677082e-03
 	 5.09940415878905595192804867110681e-02 3.54982214694466668980510348774260e-01 5.94023743717642771500209164514672e-01 5.66279420727774929211761900660349e-03
 	 2.09636483937665207832878877525218e-02 3.66215290092678835698336570203537e-01 6.12821061513554643518375542043941e-01 3.79582995703961305344886767443313e-03
 	 4.00147938386741230942789115943015e-03 3.72560106231905940887827455298975e-01 6.23438414384226646802744653541595e-01 1.67797576617481278282717482852604e-03
 	 9.89866848202597293671090028510662e-01 2.98040738777144344900937866782442e-03 7.15274440963126287990059282151378e-03 2.65855134379770069452675329557678e-05
 	 9.66300751945632585560019833792467e-01 9.91177176377860263967178866550967e-03 2.37874762905888118003083775420237e-02 1.56699470754909282212141707901765e-04
 	 9.30020889699693431573734869743930e-01 2.05825651780095139620208044561878e-02 4.93965451222970544642443257998821e-02 4.58244543001852695784936742029458e-04
 	 8.82019825362079235020473788608797e-01 3.47008503505839699387891528203909e-02 8.32793242873367950407370585708122e-02 9.75447575854630852948412567116065e-04
 	 8.23607429774869448380059111514129e-01 5.18813622807585417273656958059291e-02 1.24511207944372009892575192679942e-01 1.72192970956555613248895042488584e-03
 	 7.56377193406150616361571792367613e-01 7.16554165099972939501071778067853e-02 1.71967390083852089688321029825602e-01 2.67732883687569599845401668858358e-03
 	 6.82163039113651503697610678500496e-01 9.34836115427872815786258797743358e-02 2.24353349343561214723763441725168e-01 3.78785490397500444748057901733773e-03
 	 6.02989360559831988339851704949979e-01 1.16770523768786549378972949853051e-01 2.80240115671381462281175345196971e-01 4.97076204609776112208763265698508e-03
 	 5.21015820870776247275557579996530e-01 1.40880943525219903822431888329447e-01 3.38103235604003848902010531674023e-01 6.12228986038306204758852047120854e-03
 	 4.38478449224138033812891990237404e-01 1.65157200028742234820811063400470e-01 3.96364350747119731366296946362127e-01 7.12824122621380073389074638612328e-03
 	 3.57628649976634627183358361435239e-01 1.88937100280395398055333089359920e-01 4.53434249742970030272459780462668e-01 7.87606859857540968217204380152907e-03
 	 2.80671790060171733038885122368811e-01 2.11571992012058451848588447319344e-01 5.07756217927769815112526430311846e-01 8.26716698080807652071477775734820e-03
 	 2.09707039588842958366399216174614e-01 2.32444458032977641082084119261708e-01 5.57848502378179400551516664563678e-01 8.22803900173310273635784994894493e-03
 	 1.46670103677618013371386496146442e-01 2.50985160200337231728440201550256e-01 6.02344736122044754900173302303301e-01 7.71910975884210464464940670836768e-03
 	 9.32803959285448680560648426762782e-02 2.66688376986952579983380928752013e-01 6.40031227084502551960554228571709e-01 6.74021565982325758514814850741459e-03
 	 5.09940415878905595192804867110681e-02 2.79125826400382859304727389826439e-01 6.69880132011726581175992123462493e-01 5.33215383167634070921137023901792e-03
 	 2.09636483937665207832878877525218e-02 2.87958498359011660916451091907220e-01 6.91077853247221818300261020340258e-01 3.57419826837579489645091435079394e-03
 	 4.00147938386741230942789115943015e-03 2.92947486468583706553658885241020e-01 7.03051034147548881136913223599549e-01 1.58000177713861012299134678471546e-03
 	 9.89866848202597293671090028510662e-01 2.23045449718607680100745938034379e-03 7.90269730021662952790251210899442e-03 2.41721689293443509126500107209168e-05
 	 9.66300751945632585560019833792467e-01 7.41769598220353224005130243767780e-03 2.62815520721638821999288637698555e-02 1.42474813851657823972687855196284e-04
 	 9.30020889699693320551432407228276e-01 1.54034227848442797914607638176676e-02 5.45756875154623996571068289540563e-02 4.16646627127689522449016656935328e-04
 	 8.82019825362079235020473788608797e-01 2.59691571153012057404652068726136e-02 9.20110175226195592390610045185895e-02 8.86899688444451098599807803424255e-04
 	 8.23607429774869448380059111514129e-01 3.88265772974697997987902908789692e-02 1.37565992927660751821150597606902e-01 1.56561865623471344576012054261582e-03
 	 7.56377193406150505339269329851959e-01 5.36249328391213975208984265918843e-02 1.89997873754728097139832243556157e-01 2.43428982762910681159063130962750e-03
 	 6.82163039113651503697610678500496e-01 6.99605505724897602792822226547287e-02 2.47876410313858736023107098844775e-01 3.44400603104155940414887737688332e-03
 	 6.02989360559831988339851704949979e-01 8.73878319277729409542132543720072e-02 3.09622807512395070705935040678014e-01 4.51953279616598008194827684746997e-03
 	 5.21015820870776247275557579996530e-01 1.05431403553392866179194697906496e-01 3.73552775575830886545247722096974e-01 5.56652874449252953181765946055748e-03
 	 4.38478449224138033812891990237404e-01 1.23599082816063021716956882301020e-01 4.37922467959798944470151127461577e-01 6.48116319028924775524913570734498e-03
 	 3.57628649976634571672207130177412e-01 1.41395302781346376974624945432879e-01 5.00976047242019051353167924389709e-01 7.16110528043862725605661623262677e-03
 	 2.80671790060171733038885122368811e-01 1.58334630023437838985955750104040e-01 5.60993579916390427975159127527149e-01 7.51670105199957194752613531818497e-03
 	 2.09707039588842958366399216174614e-01 1.73955006584956772819339221314294e-01 6.16337953826200268814261562511092e-01 7.48112498075796748114862921852364e-03
 	 1.46670103677618013371386496146442e-01 1.87830355538878501775457152689341e-01 6.65499540783503484853156351164216e-01 7.01839464226198736507278397311893e-03
 	 9.32803959285448680560648426762782e-02 1.99582208874668154408027476165444e-01 7.07137395196786977535907681158278e-01 6.12836129456590349151579033559756e-03
 	 5.09940415878905595192804867110681e-02 2.08890052188817509914997572195716e-01 7.40115906223291930565721941093216e-01 4.84811863713770739570119161498951e-03
 	 2.09636483937665207832878877525218e-02 2.15500179708003392065052139514592e-01 7.63536171898230087151659972732887e-01 3.24974443437809267995475259738214e-03
 	 4.00147938386741230942789115943015e-03 2.19233800491208996596981251059333e-01 7.76764720124923591093590857781237e-01 1.43657446957943537267643474564238e-03
 	 9.89866848202597293671090028510662e-01 1.56209099688777233727599025314703e-03 8.57106080051493399163398123619118e-03 2.10634511289657587701333596452713e-05
 	 9.66300751945632585560019833792467e-01 5.19495740714233031343205482244230e-03 2.85042906472250841265481113850910e-02 1.24151510253171499902069552234707e-04
 	 9.30020889699693320551432407228276e-01 1.07877332103466228030441698138020e-02 5.91913770899600566455234229579219e-02 3.63062822132550393292721446769633e-04
 	 8.82019825362079235020473788608797e-01 1.81874082514366514073955727326393e-02 9.97927663864841135721306386585638e-02 7.72837898760761520325357487593010e-04
 	 8.23607429774869448380059111514129e-01 2.71920574541471560259253692493076e-02 1.49200512770983395594015519236564e-01 1.36426864087332085258286173967690e-03
 	 7.56377193406150505339269329851959e-01 3.75560339394427344927862577605993e-02 2.06066772654406760167944412387442e-01 2.12122234326098417153683151070709e-03
 	 6.82163039113651503697610678500496e-01 4.89966266177905285239546628872631e-02 2.68840334268557967778434658612241e-01 3.00108165447422617702621927548989e-03
 	 6.02989360559831988339851704949979e-01 6.12017620911491366797463342663832e-02 3.35808877349018874980401960783638e-01 3.93828780760478551481451603422101e-03
 	 5.21015820870776247275557579996530e-01 7.38385142973202457383763430698309e-02 4.05145664831903506986066076933639e-01 4.85063241574746999151823700913155e-03
 	 4.38478449224138089324043221495231e-01 8.65621848525210402236496065597748e-02 4.74959365923340925963458403202822e-01 5.64763817912024897877065754414616e-03
 	 3.57628649976634571672207130177412e-01 9.90257051895083728609847639745567e-02 5.43345644833857055466808105848031e-01 6.24013474110653599408182756747010e-03
 	 2.80671790060171733038885122368811e-01 1.10889103708325831298964203597279e-01 6.08439106231502435662150674033910e-01 6.54999829442831117687351394351936e-03
 	 2.09707039588842958366399216174614e-01 1.21828779736475656392258315463550e-01 6.68464180674681385241342468361836e-01 6.51899756627071294556863279012759e-03
 	 1.46670103677618013371386496146442e-01 1.31546331790078019352563387656119e-01 7.21783564532303967276050116197439e-01 6.11577773526218292782230534498922e-03
 	 9.32803959285448680560648426762782e-02 1.39776701123208169086353791499278e-01 7.66942902948246962857581365824444e-01 5.34020918875961064786750398525328e-03
 	 5.09940415878905595192804867110681e-02 1.46295416595690563887899315886898e-01 8.02710541816418876592820197402034e-01 4.22461510505205833920783220492012e-03
 	 2.09636483937665207832878877525218e-02 1.50924796257560833723232462943997e-01 8.28111555348672645493479649303481e-01 2.83180352062052621484045111799333e-03
 	 4.00147938386741230942789115943015e-03 1.53539624499336890828260493435664e-01 8.42458896116795696862311615404906e-01 1.25182048088256104440008087408387e-03
 	 9.89866848202597293671090028510662e-01 9.94543723904412618752601815685921e-04 9.13860807349829371015736967365228e-03 1.73488166675462788916557005380881e-05
 	 9.66300751945632585560019833792467e-01 3.30749763971358023972868522832869e-03 3.03917504146538342002514809792046e-02 1.02256832329784621573275094075228e-04
 	 9.30020889699693320551432407228276e-01 6.86827616373250626757851478032535e-03 6.31108341365741731809890779913985e-02 2.99035058472341293538815376606976e-04
 	 8.82019825362079235020473788608797e-01 1.15794616104897551966956825708621e-02 1.06400713027431009782830528820341e-01 6.36544455001210492117724726313099e-04
 	 8.23607429774869448380059111514129e-01 1.73124934046420264621701790019870e-02 1.59080076820488525157770709483884e-01 1.12367372235814264903874803991357e-03
 	 7.56377193406150505339269329851959e-01 2.39109744077843355825052640284412e-02 2.19711832186065159078225406119600e-01 1.74713523054779171564399042893001e-03
 	 6.82163039113651503697610678500496e-01 3.11949096386171520478569618717302e-02 2.86642051247731344254532359627774e-01 2.47182738996704369147106028492544e-03
 	 6.02989360559831988339851704949979e-01 3.89656098786262394817470067209797e-02 3.58045029561541772178401288329042e-01 3.24375301748204168325595553312723e-03
 	 5.21015820870776247275557579996530e-01 4.70111095468416229081753954233136e-02 4.31973069582382129816267024580156e-01 3.99520154542652022877646800225193e-03
 	 4.38478449224138033812891990237404e-01 5.51119479236800158261644355661701e-02 5.06409602852181950360943574196426e-01 4.65165175328051839348519891359501e-03
 	 3.57628649976634571672207130177412e-01 6.30471552538560686684832035098225e-02 5.79324194769509359659309666312765e-01 5.13965887837675074883980741446976e-03
 	 2.80671790060171733038885122368811e-01 7.06002802411799246229406890051905e-02 6.48727929698648342338174188625999e-01 5.39487659866482501674900262855772e-03
 	 2.09707039588842958366399216174614e-01 7.75652945438169982850240558036603e-02 7.12727665867340043348576728021726e-01 5.36934298852308460742177587121660e-03
 	 1.46670103677618013371386496146442e-01 8.37522135042871873622516432078555e-02 7.69577682818094799266361860645702e-01 5.03723279052869458288776982612944e-03
 	 9.32803959285448680560648426762782e-02 8.89922809408117965190854192769621e-02 8.17727323130643335424849738046760e-01 4.39843924981184013212054395580708e-03
 	 5.09940415878905595192804867110681e-02 9.31425817709123915477675836882554e-02 8.55863376641197048932951929600677e-01 3.47958520660966545701153762593094e-03
 	 2.09636483937665207832878877525218e-02 9.60899904029682838668691147177014e-02 8.82946361203265195349842997529777e-01 2.33240221732695148654235239860100e-03
 	 4.00147938386741230942789115943015e-03 9.77547852338248590697844520036597e-02 8.98243735382307728620787656836910e-01 1.03105630176841454002933939904096e-03
 	 9.89866848202597293671090028510662e-01 5.44137754823457303610112489877793e-04 9.58901404257924902529985899946041e-03 1.31352202604429231101897113109800e-05
 	 9.66300751945632585560019833792467e-01 1.80960806096305132362189738159941e-03 3.18896399934043631163582688259339e-02 7.74211890946722422262790685998368e-05
 	 9.30020889699693431573734869743930e-01 3.75779192147421281511299184785457e-03 6.62213183788323556111521384082153e-02 2.26406874537810835074091997398682e-04
 	 8.82019825362079235020473788608797e-01 6.33538987915015228136184077811777e-03 1.11644784758770612698164370613085e-01 4.81943626601655412955427237875483e-04
 	 8.23607429774869448380059111514129e-01 9.47206348516785312519061790226260e-03 1.66920506739962698494750270583609e-01 8.50761301297071285271167440100726e-04
 	 7.56377193406150505339269329851959e-01 1.30822442665612104217842670550453e-02 2.30540562327288284238946403092996e-01 1.32279950372377486794706058503834e-03
 	 6.82163039113651503697610678500496e-01 1.70674528275533421428633573668776e-02 3.00769508058795154159525964132627e-01 1.87148194803103858074866394645142e-03
 	 6.02989360559832099362154167465633e-01 2.13189817250510893487103203369770e-02 3.75691657715116811289135512197390e-01 2.45592602490329620784637043584553e-03
 	 5.21015820870776247275557579996530e-01 2.57208597125857529874792817281559e-02 4.53263319416637999736963138275314e-01 3.02486638078362270187771088103545e-03
 	 4.38478449224138033812891990237404e-01 3.01530147808974913203883261303417e-02 5.31368535994964474866719683632255e-01 3.52188114757782033334421178949469e-03
 	 3.57628649976634571672207130177412e-01 3.44945492925723407040550227975473e-02 6.07876800730793087623737847025041e-01 3.89136347018461878355388705585938e-03
 	 2.80671790060171733038885122368811e-01 3.86270377631329209222599274653476e-02 6.80701172176695346038854950165842e-01 4.08459514901278117338101480982004e-03
 	 2.09707039588842958366399216174614e-01 4.24377573462515478297518711769953e-02 7.47855203064905493803848912648391e-01 4.06526301820045714990881080552754e-03
 	 1.46670103677618013371386496146442e-01 4.58227630644600925080567321856506e-02 8.07507133257921894120556771667907e-01 3.81381413353064141133486053547585e-03
 	 9.32803959285448680560648426762782e-02 4.86897245277935208918052012450062e-02 8.58029879543661611052129956078716e-01 3.33016766823827177132488763788842e-03
 	 5.09940415878905595192804867110681e-02 5.09604496062918688181753168464638e-02 8.98045508805817571662544196442468e-01 2.63448043631099321909561083998597e-03
 	 2.09636483937665207832878877525218e-02 5.25730446858705402490841152030043e-02 9.26463306920362938967627997044474e-01 1.76591968476130355830688856144661e-03
 	 4.00147938386741230942789115943015e-03 5.34838922431279950586713312077336e-02 9.42514628373004592631900777632836e-01 7.80638350394263574004438677178541e-04
 	 9.89866848202597182648787565995008e-01 2.23821312401371180778042457859556e-04 9.90933048500144617043439154713269e-03 8.54439398493299247228354581507048e-06
 	 9.66300751945632585560019833792467e-01 7.44349840727853706567884728428908e-04 3.29548982136395607334122814791044e-02 5.03620898081971507705134616372789e-05
 	 9.30020889699693320551432407228276e-01 1.54570035278751849450173949662712e-03 6.84334099475191609540658532750967e-02 1.47276520575309886927975466797136e-04
 	 8.82019825362079235020473788608797e-01 2.60594907219002802634122417657636e-03 1.15374225565730736953184987214627e-01 3.13501878351685864775022505313018e-04
 	 8.23607429774869448380059111514129e-01 3.89616353874802645584907168085920e-03 1.72496406686382525164091816805012e-01 5.53415900250106692834228816479936e-04
 	 7.56377193406150616361571792367613e-01 5.38114669482372964814942406519549e-03 2.38241659899025653990278783567192e-01 8.60474350546493594975305807537325e-04
 	 6.82163039113651503697610678500496e-01 7.02039080609445642622290506551508e-03 3.10816570080254039876166416433989e-01 1.21738949043918636902517071973762e-03
 	 6.02989360559831988339851704949979e-01 8.76918101430018692710177674598526e-03 3.88241458425867824733046518304036e-01 1.59756739046235975154619524118971e-03
 	 5.21015820870776247275557579996530e-01 1.05798146258575531675205638748594e-02 4.68404364503366199556921856128611e-01 1.96766019881893438822628716877716e-03
 	 4.38478449224138033812891990237404e-01 1.24029021719106458121473224309739e-02 5.49118648603951320374960687331622e-01 2.29096577722695234416439014069056e-03
 	 3.57628649976634571672207130177412e-01 1.41887145762606969867647421779111e-02 6.28182635447104731341028127644677e-01 2.53131214921189758373931688595349e-03
 	 2.80671790060171733038885122368811e-01 1.58885396385088917270422825822607e-02 7.03439670301319375234072595048929e-01 2.65700837367872488153919263709213e-03
 	 2.09707039588842958366399216174614e-01 1.74560108362461496867013011069503e-02 7.72836949574910891946899482718436e-01 2.64443292089197503486053264509792e-03
 	 1.46670103677618013371386496146442e-01 1.88483722660856001240858859091531e-02 8.34481524056296386504527617944404e-01 2.48086670006802088861430632960037e-03
 	 9.32803959285448680560648426762782e-02 2.00276454770312861697334483324084e-02 8.86691958594423845774201708991313e-01 2.16625713380720532480472328984433e-03
 	 5.09940415878905595192804867110681e-02 2.09616675379284966851400895393454e-02 9.28044290874180943795579423749587e-01 1.71371612710819148754637364362452e-03
 	 2.09636483937665207832878877525218e-02 2.16249796199957655673529188788962e-02 9.57411371986237713649359193368582e-01 1.14872177498152221522542681952928e-03
 	 4.00147938386741230942789115943015e-03 2.19996404367756026587699125229847e-02 9.73998880179356985031802196317585e-01 5.07801277273126007612280563563445e-04
 	 9.89866848202597293671090028510662e-01 4.27357143881167134136234153629630e-05 1.00904160830145896154963480739752e-02 3.71512444665073832079709922893151e-06
 	 9.66300751945632585560019833792467e-01 1.42123740839932011237323195018689e-04 3.35571243135274824287428430125146e-02 2.18975659784396662493628077372776e-05
 	 9.30020889699693320551432407228276e-01 2.95131004718091061178597556136083e-04 6.96839792955885883873889952155878e-02 6.40362093522171702203796272989678e-05
 	 8.82019825362079235020473788608797e-01 4.97571451369999140368349799246062e-04 1.17482603186550765839157861591957e-01 1.36311421780067621714258030429789e-04
 	 8.23607429774869448380059111514129e-01 7.43920810824028055918688551173545e-04 1.75648649414306523564022199934698e-01 2.40626654600656445523801374442030e-04
 	 7.56377193406150505339269329851959e-01 1.02745867121961653722905793983955e-03 2.42595347922629878123501612208202e-01 3.74136457315558262643612197351217e-04
 	 6.82163039113651503697610678500496e-01 1.34045061733972792339386614912655e-03 3.16496510269008768378995455350378e-01 5.29324076698901749109260617132122e-04
 	 6.02989360559831988339851704949979e-01 1.67435893938816526826940389582887e-03 3.95336280500779846391878891154192e-01 6.94626403925741107807378948990618e-04
 	 5.21015820870776247275557579996530e-01 2.02007543999682681601370859425515e-03 4.76964103689226925908428711409215e-01 8.55543707397430188213438562172541e-04
 	 4.38478449224138033812891990237404e-01 2.36816985440602145729371841298416e-03 5.59153380921455944729814291349612e-01 9.96117803137890750475591516988061e-04
 	 3.57628649976634571672207130177412e-01 2.70914707433311807704967577592470e-03 6.39662202949032310250743194046663e-01 1.10062102288637506455892811629838e-03
 	 2.80671790060171733038885122368811e-01 3.03370615045783775798327042139135e-03 7.16294503789370429203131607209798e-01 1.15527406407242854043115887208160e-03
 	 2.09707039588842958366399216174614e-01 3.33299400959596869853385214810260e-03 7.86959966401561072935066931677284e-01 1.14980622490698969513645000262159e-03
 	 1.46670103677618013371386496146442e-01 3.59884697843182443932619207771495e-03 8.49731049343950162189287311775843e-01 1.07868721205471519881957664921401e-03
 	 9.32803959285448680560648426762782e-02 3.82401357489137172507298600976355e-03 9.02895590496563760218862171313958e-01 9.41894164727215786603320424319463e-04
 	 5.09940415878905595192804867110681e-02 4.00235271336957243448750887182541e-03 9.45003605698739868046232004417107e-01 7.45128172889279022893249671000149e-04
 	 2.09636483937665207832878877525218e-02 4.12900336779242760343322515836917e-03 9.74907348238441051613278887089109e-01 4.99467177679231212096555569956990e-04
 	 4.00147938386741230942789115943015e-03 4.20053988719948367958068047300912e-03 9.91797980728933104010991428367561e-01 2.20793299391923496200959564639277e-04
 	 ];
 
 	 case  36 

 	 % ALG. DEG.:   36
 	 % PTS CARD.:  361
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw_bar=[
 	 9.90851805270955621196549145679455e-01 9.11346289348091351256719860884914e-03 3.47318355634652908836557116956101e-05 2.72713356304074948111828766150744e-06
 	 9.69552637080220991450119072396774e-01 3.03317671291784864140428368273206e-02 1.15595790600522135838090775905584e-04 1.61120400485667722662117690157757e-05
 	 9.36695848074365122748474732361501e-01 6.30638127701744766184788204554934e-02 2.40339155460400633046447183005512e-04 4.72939302785981623643805915602201e-05
 	 8.93093134981844949393803290149663e-01 1.06500984758017155917819707156013e-01 4.05880260137894688377002694323892e-04 1.01197043051835805374874532880369e-04
 	 8.39818615708710969336436846788274e-01 1.59573243159151750836244332276692e-01 6.08141132137279827318820935033727e-04 1.79848174139787147542135503641703e-04
 	 7.78184222976761708068238476698752e-01 2.20973636106791188060682884497510e-01 8.42140916447103871078638803737704e-04 2.81998335976982881026509097921462e-04
 	 7.09707651653902482635771775676403e-01 2.89190230780095314244704240991268e-01 1.10211756600220311952398333232850e-03 4.03086185299812097947852462809237e-04
 	 6.36075044879270912190349918091670e-01 3.62543285614004950900834955973551e-01 1.38166950672413690881512593477964e-03 5.35550620098578476768746980951619e-04
 	 5.59099492649031803992443201423157e-01 4.39226594150088744950011232504039e-01 1.67391320087945105754556607280392e-03 6.69465234983261745643767781643874e-04
 	 4.80676393578551852669988875277340e-01 5.17351953801812758371170275495388e-01 1.97165261963538895884084922727197e-03 7.93435131272715349522173244878331e-04
 	 4.02736786165077020882563374470919e-01 5.94995657410357425831648470193613e-01 2.26755642456555328578815533546731e-03 8.95670139918948926202602045520962e-04
 	 3.27199800763811721182605651847553e-01 6.70245860748754362923307326127542e-01 2.55433848743391589408702202490531e-03 9.65130444464458751505087086286494e-04
 	 2.55925403482102797880770594929345e-01 7.41249659216206113754310536023695e-01 2.82493730169108836491886904696003e-03 9.92632678958622416756640838286785e-04
 	 1.90668594904763288866433867951855e-01 8.06258715224647093400278663466452e-01 3.07268987058961773328746858169325e-03 9.71807623868887310823738712173281e-04
 	 1.33036188558098733558665571763413e-01 8.63672315640781507184442489233334e-01 3.29149580111975925689193900325336e-03 8.99814380833453939141641786392256e-04
 	 8.44472227842097966643564177502412e-02 9.12076809612370587032614821509924e-01 3.47596760341961630302876073983498e-03 7.77739183051407746705141477150391e-04
 	 4.60979330484310168003503349609673e-02 9.50280503275423682474354336591205e-01 3.62156367614530072529532844782807e-03 6.10638425048518453455703713927960e-04
 	 1.89318370315880724064072637702338e-02 9.77343461087658571528891116031446e-01 3.72470188075335606470162019832060e-03 4.07231141177786994805876119585264e-04
 	 3.61164281855697044676389850792475e-03 9.92605490987186533935471288714325e-01 3.78286619425649561776481277775019e-03 1.79516268827594550937590267558619e-04
 	 9.90851805270955621196549145679455e-01 8.96618294259483687713707666944174e-03 1.82011786449541926313777651103010e-04 6.27970978164236945915938764573028e-06
 	 9.69552637080221102472421534912428e-01 2.98415845031792213715160499987178e-02 6.05778416599676156062415088854323e-04 3.71008361550081210773928408475086e-05
 	 9.36695848074365122748474732361501e-01 6.20446573343056417826346660149284e-02 1.25949459132923546889060162357055e-03 1.08902681044957444001820834333927e-04
 	 8.93093134981844949393803290149663e-01 1.04779854163882649165095983789797e-01 2.12701085427240144110072606054018e-03 2.33024179577522797934124865193439e-04
 	 8.39818615708710969336436846788274e-01 1.56994427654013363193641339421447e-01 3.18695663727566746992181379027897e-03 4.14132389283078860761633244180757e-04
 	 7.78184222976761819090540939214407e-01 2.17402547196536649609655000858766e-01 4.41322982670153129980405992682790e-03 6.49351294282417171137289368942902e-04
 	 7.09707651653902482635771775676403e-01 2.84516713865192061305720017116982e-01 5.77563448090545605850820720661432e-03 9.28177590924363451509171429876233e-04
 	 6.36075044879270912190349918091670e-01 3.56684331896477579970650140239741e-01 7.24062322425150783899994166858960e-03 1.23320049783253956644790694241465e-03
 	 5.59099492649032026037048126454465e-01 4.32128384394875053597928626913927e-01 8.77212295609292036502324663160834e-03 1.54156270216057557018163315376569e-03
 	 4.80676393578551852669988875277340e-01 5.08991183451691253658566438389244e-01 1.03324229697568936714446863334160e-02 1.82702542423204285747251329752316e-03
 	 4.02736786165077020882563374470919e-01 5.85380110364732031413836921274196e-01 1.18831034701909477035997042548843e-02 2.06243970409085864564646684016225e-03
 	 3.27199800763811721182605651847553e-01 6.59414217650357015187978504400235e-01 1.33859815858312636294158437522128e-02 2.22238440199701639543583553404460e-03
 	 2.55925403482102797880770594929345e-01 7.29270544945408216719329175248276e-01 1.48040515724889853999002298223786e-02 2.28571318548991377420098736195087e-03
 	 1.90668594904763288866433867951855e-01 7.93229009023209696849221472803038e-01 1.61023960720270142843446592451073e-02 2.23775979445598295972108537910117e-03
 	 1.33036188558098733558665571763413e-01 8.49714765397149185410796690121060e-01 1.72490460447520810305377381155267e-02 2.07198255544254784921154310950442e-03
 	 8.44472227842097966643564177502412e-02 8.97337008804037883358262206456857e-01 1.82157684117523199773813757929020e-02 1.79088271347034588831803603170556e-03
 	 4.60979330484310168003503349609673e-02 9.34923303988364873262639775930438e-01 1.89787629632041099370098891085945e-02 1.40610351571789668305434428674516e-03
 	 1.89318370315880724064072637702338e-02 9.61548905425311462025206310499925e-01 1.95192575431004655683864257298410e-02 9.37722088606527813710311836103983e-04
 	 3.61164281855697044676389850792475e-03 9.76564290219647634927468971000053e-01 1.98240669617953946257671304920223e-02 4.13368118305008046264870102959321e-04
 	 9.90851805270955621196549145679455e-01 8.70522040299938522356359982268259e-03 4.42974326044993579887254497862159e-04 9.67504566497260998583513497139919e-06
 	 9.69552637080220991450119072396774e-01 2.89730392451401086439943810546538e-02 1.47432367463889990588654654857237e-03 5.71606485792869718981848436989424e-05
 	 9.36695848074365122748474732361501e-01 6.02388352303006857635381265936303e-02 3.06531669533419148798714104486862e-03 1.67784571068560771399738595910378e-04
 	 8.93093134981844949393803290149663e-01 1.01730215648127078620355234761519e-01 5.17664937002797198584147508881870e-03 3.59016524146705618206198984410094e-04
 	 8.39818615708710969336436846788274e-01 1.52425073581580305948079967492959e-01 7.75631070970872471548318571876734e-03 6.38046966656171310114387118517243e-04
 	 7.78184222976761708068238476698752e-01 2.11075002778341985765209187775326e-01 1.07407742448963061665523355259211e-02 1.00044486819394909740688071053683e-03
 	 7.09707651653902482635771775676403e-01 2.76235798264542364854889910930069e-01 1.40565500815551525093383133935276e-02 1.43002796142735911361087985937957e-03
 	 6.36075044879271023212652380607324e-01 3.46302963405386576845046420203289e-01 1.76219917153423999423011991893873e-02 1.89997174160432620755589727679080e-03
 	 5.59099492649031915014745663938811e-01 4.19551201735881673648975720425369e-01 2.13493056150864113362786156358197e-02 2.37506032244079500273525873410563e-03
 	 4.80676393578551852669988875277340e-01 4.94176893723758614562768798350589e-01 2.51467126976895327672423263720702e-02 2.81486804727589141894572577484723e-03
 	 4.02736786165077020882563374470919e-01 5.68342505710946577224262910021935e-01 2.89207081239764018931737155071460e-02 3.17756695964903617540597835500193e-03
 	 3.27199800763811721182605651847553e-01 6.40221835564788732675367555202683e-01 3.25783636713995461420267929497641e-02 3.42399112731297649431239094042212e-03
 	 2.55925403482102797880770594929345e-01 7.08044980546424840284203128248919e-01 3.60296159714723618350262768217362e-02 3.52156074334715896850811489571242e-03
 	 1.90668594904763288866433867951855e-01 7.70141920793937728717537538614124e-01 3.91894843012989824160285934340209e-02 3.44767974180790800348139768516376e-03
 	 1.33036188558098733558665571763413e-01 8.24983647983029144690192424604902e-01 4.19801634588721217511420036316849e-02 3.19226947390718581235025119724469e-03
 	 8.44472227842097966643564177502412e-02 8.71219836514586676301519219123293e-01 4.43329407012035270341243631264661e-02 2.75918356674503166894862893343543e-03
 	 4.60979330484310168003503349609673e-02 9.07712175094627982119277476158459e-01 4.61898918569410010803721888805740e-02 2.16636057991380923462565455395179e-03
 	 1.89318370315880724064072637702338e-02 9.33562833100938793684520078386413e-01 4.75053298674731339090726578433532e-02 1.44473301215981733518212148936755e-03
 	 3.61164281855697044676389850792475e-03 9.48141192131466636894288058101665e-01 4.82471650499763926589480433904100e-02 6.36869466919660464493402329821947e-04
 	 9.90851805270955621196549145679455e-01 8.33727430674251202002977834126796e-03 8.10920422301866783421075979276793e-04 1.28202766212826012087646482262571e-05
 	 9.69552637080220991450119072396774e-01 2.77484273233933147195795498873849e-02 2.69893559638569383030137771584123e-03 7.57428287177451645172457372900965e-05
 	 9.36695848074365122748474732361501e-01 5.76927027672543418779227408776933e-02 5.61144915838053537360252676080563e-03 2.22329143279375755293605920748234e-04
 	 8.93093134981845060416105752665317e-01 9.74303548765145244203722540987656e-02 9.47651014164041516352199323591776e-03 4.75728106156197679335595474015008e-04
 	 8.39818615708710969336436846788274e-01 1.45982478426070483301657532138051e-01 1.41989058652185473619056210736744e-02 8.45467700428218058190943384744287e-04
 	 7.78184222976761708068238476698752e-01 2.02153433915715552426917156481068e-01 1.96623431075227395048443668201799e-02 1.32567642559290707789110275172106e-03
 	 7.09707651653902482635771775676403e-01 2.64560059005508885210389280473464e-01 2.57322893405886321538389438501326e-02 1.89491137060379850887148478477684e-03
 	 6.36075044879270912190349918091670e-01 3.31665674789087372431595213129185e-01 3.22592803316417153780548687791452e-02 2.51762773463421038119824935108682e-03
 	 5.59099492649031915014745663938811e-01 4.01817908411635893450863932230277e-01 3.90825989393321915343904038309120e-02 3.14716140680973638713013862400203e-03
 	 4.80676393578551797158837644019513e-01 4.73289374455050093626340412811260e-01 4.60342319663980537036707119113998e-02 3.72994487758716722694551926053919e-03
 	 4.02736786165077020882563374470919e-01 5.44320206833695863224420463666320e-01 5.29430070012271158930161618627608e-02 4.21055246827756451261093317839368e-03
 	 3.27199800763811721182605651847553e-01 6.13161392034455077215682194946567e-01 5.96388072017332016017121532058809e-02 4.53708591370187343944087032809875e-03
 	 2.55925403482102797880770594929345e-01 6.78117836315066058183731456665555e-01 6.59567602028311439354979484051000e-02 4.66637413731400396005311037583851e-03
 	 1.90668594904763288866433867951855e-01 7.37590107031443786844704391114647e-01 7.17412980637929242888617409334984e-02 4.56847538731432797204368156940291e-03
 	 1.33036188558098844580968034279067e-01 7.90113822901228557427089072007220e-01 7.68499885406725979919428937137127e-02 4.23003457785563457410615839648926e-03
 	 8.44472227842097966643564177502412e-02 8.34395732932253109126463641587179e-01 8.11570442835370942091799406625796e-02 3.65615809986656126531756605402279e-03
 	 4.60979330484310168003503349609673e-02 8.69345639166849815104853860248113e-01 8.45564277847191680947958047909196e-02 2.87061610432366373646395629748440e-03
 	 1.89318370315880724064072637702338e-02 8.94103659852247267814107090089237e-01 8.69645031161646597794856461405288e-02 1.91439684123084004514769862481671e-03
 	 3.61164281855697044676389850792475e-03 9.08065831118790911524740749882767e-01 8.83225260626521180284953516093083e-02 8.43907410909563939112321140356698e-04
 	 9.90851805270955621196549145679455e-01 7.87186685618089868055058389018086e-03 1.27632787286348012290027043036389e-03 1.56335656311009926560610244772320e-05
 	 9.69552637080220991450119072396774e-01 2.61994408869951969642819733508077e-02 4.24792203278381158559895425241848e-03 9.23638794094634729692216978946817e-05
 	 9.36695848074365122748474732361501e-01 5.44721521744542247489562214468606e-02 8.83199975118065250256904619163834e-03 2.71117180685048438700673889556469e-04
 	 8.93093134981844949393803290149663e-01 9.19915494105937869839806353411404e-02 1.49153156075612636222160745091969e-02 5.80122160375680807203879751909881e-04
 	 8.39818615708710969336436846788274e-01 1.37833372302022527655651629174827e-01 2.23480119892665030079115240368992e-02 1.03099762774839565949991371240912e-03
 	 7.78184222976761708068238476698752e-01 1.90868724928162952769739035829843e-01 3.09470520950753391620224874714040e-02 1.61658363679181285230135323160994e-03
 	 7.09707651653902482635771775676403e-01 2.49791656521425126102897706914518e-01 4.05006918246723912613305174090783e-02 2.31073183150164130836290432569058e-03
 	 6.36075044879271023212652380607324e-01 3.13151269425507972066213824291481e-01 5.07736856952210047211337951011956e-02 3.07009743914139765497139933358994e-03
 	 5.59099492649031915014745663938811e-01 3.79387430360479394053641044592950e-01 6.15130769904886909316132914682385e-02 3.83777634901810759185392107895041e-03
 	 4.80676393578551852669988875277340e-01 4.46869180871532378773736127186567e-01 7.24544255499157685562749975360930e-02 4.54844616592321986797697874749247e-03
 	 4.02736786165077020882563374470919e-01 5.13934894988220536404810445674229e-01 8.33283188467024427126261798548512e-02 5.13451856777689692040711477716286e-03
 	 3.27199800763811721182605651847553e-01 5.78933193494941877865755941456882e-01 9.38670057412464009516384066955652e-02 5.53270670369558712625712715293957e-03
 	 2.55925403482102797880770594929345e-01 6.40263607010829405297158700705040e-01 1.03810989507067796822070704365615e-01 5.69036601081329002083109003251593e-03
 	 1.90668594904763288866433867951855e-01 6.96415987212049780730183101695729e-01 1.12915417883186930403383030352416e-01 5.57098430178043415444966157679119e-03
 	 1.33036188558098733558665571763413e-01 7.46007698232574734120703396911267e-01 1.20956113209326532320631031325320e-01 5.15827584289024754227170888043474e-03
 	 8.44472227842097966643564177502412e-02 7.87817681576855721736762916407315e-01 1.27735095638934481598880665842444e-01 4.45846757448724578115628602859033e-03
 	 4.60979330484310168003503349609673e-02 8.20816596856907887413967728207354e-01 1.33085470094661095785681936831679e-01 3.50054578339898921426898148467899e-03
 	 1.89318370315880724064072637702338e-02 8.44192563064521839244491729914444e-01 1.36875599903890088349101006315323e-01 2.33449320521451723908779030125515e-03
 	 3.61164281855697044676389850792475e-03 8.57375331099938575718510946899187e-01 1.39013026081504453834725154592888e-01 1.02909494738400299033986851071631e-03
 	 9.90851805270955621196549145679455e-01 7.32105005985136080004505032547968e-03 1.82714466919301800340580399506507e-03 1.80419830115715521098775780961532e-05
 	 9.69552637080220991450119072396774e-01 2.43661918802911894865736996962369e-02 6.08117103948781906330722790698928e-03 1.06592928479043688489054375612142e-04
 	 9.36695848074365122748474732361501e-01 5.06605815650823104734357116285537e-02 1.26435703605525667780895560099452e-02 3.12883937259572923912653852340782e-04
 	 8.93093134981845060416105752665317e-01 8.55546404204540617000063207342464e-02 2.13522245977008778838879266004369e-02 6.69492450353893764347645856105373e-04
 	 8.39818615708711080358739309303928e-01 1.28188781260815509721595617520506e-01 3.19926030304734099196650731755653e-02 1.18982720408979006192218275117511e-03
 	 7.78184222976761708068238476698752e-01 1.77513100207213198045153035309340e-01 4.43026768160250938866084879919072e-02 1.86562523227328577041239654477067e-03
 	 7.09707651653902482635771775676403e-01 2.32313027562279783566623336810153e-01 5.79793207838177337976048875134438e-02 2.66670991327230605047460265666359e-03
 	 6.36075044879271023212652380607324e-01 2.91239189083847938022131529578473e-01 7.26857660368810387652160898142029e-02 3.54305902747264339636146246448334e-03
 	 5.59099492649031915014745663938811e-01 3.52840618431772501395471408613957e-01 8.80598889191955835897829274472315e-02 4.42900214353208337980660758148588e-03
 	 4.80676393578551908181140106535167e-01 4.15600479928909860571906165205291e-01 1.03723126492538286758104959517368e-01 5.24915367300346404760835739011782e-03
 	 4.02736786165077076393714605728746e-01 4.77973416275315809986778958773357e-01 1.19289797559607169130657666755724e-01 5.92551302488155025305349710151859e-03
 	 3.27199800763811721182605651847553e-01 5.38423599931462382173208425228950e-01 1.34376599304725896644185922923498e-01 6.38504373931834349337188783124475e-03
 	 2.55925403482102797880770594929345e-01 5.95462550887377650710163834446575e-01 1.48612045630519551409065570624080e-01 6.56699113428593772567865016753785e-03
 	 1.90668594904763288866433867951855e-01 6.47685790170211106442366144619882e-01 1.61645614925025604691199987428263e-01 6.42921816444096041326394797010835e-03
 	 1.33036188558098622536363109247759e-01 6.93807428857465158245076963794418e-01 1.73156382584436219218559926957823e-01 5.95293020942604025197431028004758e-03
 	 8.44472227842096856420539552345872e-02 7.32691849371347680985877559578512e-01 1.82860927844442633372068485186901e-01 5.14531349627094392734649730414276e-03
 	 4.60979330484310168003503349609673e-02 7.63381737183203235019846033537760e-01 1.90520329768365748179803631501272e-01 4.03981977276320070036064180385438e-03
 	 1.89318370315880724064072637702338e-02 7.85122020896076411311526044300990e-01 1.95946142072335516282066691928776e-01 2.69413182782303819995384230878699e-03
 	 3.61164281855708146906636102357879e-03 7.97382353353162320885871849895921e-01 1.99006003828280597645061789080501e-01 1.18763140771032966319653567666137e-03
 	 9.90851805270955621196549145679455e-01 6.69908916828409160826307555680614e-03 2.44910556076028719518777876373861e-03 1.99831340893015399571425172453587e-05
 	 9.69552637080221102472421534912428e-01 2.22961584421818015400162948935758e-02 8.15120447759709598756217019399628e-03 1.18061345108345661916379731870563e-04
 	 9.36695848074365122748474732361501e-01 4.63567043589517696622337439293915e-02 1.69474475666831075892915237091074e-02 3.46547365033908103763155006404872e-04
 	 8.93093134981844949393803290149663e-01 7.82863332789095200947571129290736e-02 2.86205317392455305114395969212637e-02 7.41523667249677177412681139401229e-04
 	 8.39818615708710969336436846788274e-01 1.17298484373060452057302427419927e-01 4.28828999182285786062607257917989e-02 1.31784164452297442200745525298089e-03
 	 7.78184222976761819090540939214407e-01 1.62432448501904441728882488860108e-01 5.93833285213337391805765719254850e-02 2.06634931165773335151603085080296e-03
 	 7.09707651653902482635771775676403e-01 2.12576839916506388217243284088909e-01 7.77155084295911291469849402346881e-02 2.95362332067446034869484527973782e-03
 	 6.36075044879270912190349918091670e-01 2.66496920663189751365962365525775e-01 9.74280344575393364436877163825557e-02 3.92425952218702130819272255735086e-03
 	 5.59099492649031803992443201423157e-01 3.22864991462022354884453534396016e-01 1.18035515888945841123103264180827e-01 4.90552195173008659390134766908886e-03
 	 4.80676393578551852669988875277340e-01 3.80293079635349084988149570563110e-01 1.39030526786099062341861554159550e-01 5.81391422637422394109618650759330e-03
 	 4.02736786165077020882563374470919e-01 4.37367113941401153276444802031619e-01 1.59896099893521825840991823497461e-01 6.56304361045934817747715683822207e-03
 	 3.27199800763811721182605651847553e-01 4.92681743296619290006788105529267e-01 1.80118455939568988810606242623180e-01 7.07201559424036532014445910476752e-03
 	 2.55925403482102797880770594929345e-01 5.44874941730617901036737293907208e-01 1.99199654787279301082492111163447e-01 7.27353885188364128466798064209797e-03
 	 1.90668594904763288866433867951855e-01 5.92661547989589587714931440132204e-01 2.16669857105647123418634691915940e-01 7.12094278034717392822372517002805e-03
 	 1.33036188558098733558665571763413e-01 6.34864916034797110988563417777186e-01 2.32098895407104155452771010459401e-01 6.59341063135457199073652390097777e-03
 	 8.44472227842097966643564177502412e-02 6.70445904847874918353056727937656e-01 2.45106872367915284982586854312103e-01 5.69890180372800789904141893771339e-03
 	 4.60979330484310168003503349609673e-02 6.98528528697660466839636228542076e-01 2.55373538253908516360013436496956e-01 4.47446714498967151180108814401137e-03
 	 1.89318370315880724064072637702338e-02 7.18421863389499648633318429347128e-01 2.62646299578912278960274306882638e-01 2.98399558048100151108616984174660e-03
 	 3.61164281855685942446143599227071e-03 7.29640617487800957619015207455959e-01 2.66747739693642182956523356551770e-01 1.31540960069190466033561826009191e-03
 	 9.90851805270955621196549145679455e-01 6.02209237986816876136986209644419e-03 3.12610234917621004208099222410056e-03 2.14067379468434751616304212440411e-05
 	 9.69552637080221102472421534912428e-01 2.00429524793723917719390215097519e-02 1.04044104404065057556394435778202e-02 1.26472067148829416102437384061830e-04
 	 9.36695848074365122748474732361501e-01 4.16719869019671895760126290042535e-02 2.16321650236676876755126386342454e-02 3.71235492705902748403895552442577e-04
 	 8.93093134981844949393803290149663e-01 7.03748702612802534694935729930876e-02 3.65319947568747971367031368572498e-02 7.94350013129047744474264813874242e-04
 	 8.39818615708710858314134384272620e-01 1.05444530020194660036025879890076e-01 5.47368542710944816498397358373040e-02 1.41172503840845714635776619871876e-03
 	 7.78184222976761708068238476698752e-01 1.46017344417166461401080823634402e-01 7.57984326060718305306806996668456e-02 2.21355659345643610708131987507841e-03
 	 7.09707651653902482635771775676403e-01 1.91094242163304228743214707719744e-01 9.91981061827932886210135166038526e-02 3.16404024197656586273041945389650e-03
 	 6.36075044879270912190349918091670e-01 2.39565265496413548618193090078421e-01 1.24359689624315539191456991829909e-01 4.20382482805023091620988395789027e-03
 	 5.59099492649031915014745663938811e-01 2.90236889817017562620549142593518e-01 1.50663617533950522364705193467671e-01 5.25499265750283082315741367551709e-03
 	 4.80676393578551852669988875277340e-01 3.41861408239060193814395915978821e-01 1.77462198182387953515615208743839e-01 6.22809904258458078840643423745860e-03
 	 4.02736786165077020882563374470919e-01 3.93167652781980292431285306520294e-01 2.04095561052942686686151319008786e-01 7.03059660586600760484587979703974e-03
 	 3.27199800763811665671454420589725e-01 4.42892294381371620648479847659473e-01 2.29907904854816658168914500492974e-01 7.57582789092846667355907186447439e-03
 	 2.55925403482102853391921826187172e-01 4.89810950735193262328692753726500e-01 2.54263645782703939790536651344155e-01 7.79170771975238544287956088396641e-03
 	 1.90668594904763288866433867951855e-01 5.32768336460755165262526134029031e-01 2.76563068634481545871039998019114e-01 7.62824066295833720652286302765788e-03
 	 1.33036188558098733558665571763413e-01 5.70706715056022551024739186686929e-01 2.96257096385878715416595241549658e-01 7.06312698151305949634259917502277e-03
 	 8.44472227842096856420539552345872e-02 6.02691959052154446752069816284347e-01 3.12860818163635867605876228481065e-01 6.10489310395570094341932687598273e-03
 	 4.60979330484310168003503349609673e-02 6.27936608114769478916628031583969e-01 3.25965458836799504283021633455064e-01 4.79322939017033135267187304862091e-03
 	 1.89318370315880724064072637702338e-02 6.45819561490739602049870882183313e-01 3.35248601477672325543721854046453e-01 3.19657622975638841186785121806224e-03
 	 3.61164281855708146906636102357879e-03 6.55904570343413206856553188117687e-01 3.40483786838029711674380450858735e-01 1.40911973511947908807573348610731e-03
 	 9.90851805270955621196549145679455e-01 5.30759342292349417524732757556194e-03 3.84060130612088462820352674498281e-03 2.22759215741158403856388148245316e-05
 	 9.69552637080220991450119072396774e-01 1.76649304004555668390352707319835e-02 1.27824325193234417108456568712427e-02 1.31607247032192420073751226716752e-04
 	 9.36695848074365122748474732361501e-01 3.67277599959163897347380611790868e-02 2.65763919297184875167872064594121e-02 3.86308868804755814636842092824054e-04
 	 8.93093134981845060416105752665317e-01 6.20251525510543758046289042340504e-02 4.48817124671005637792653431006329e-02 8.26603223657892743556074854893723e-04
 	 8.39818615708710969336436846788274e-01 9.29339270665083400091432963563420e-02 6.72474572247806906544198568553838e-02 1.46904569570066351365256185346198e-03
 	 7.78184222976761819090540939214407e-01 1.28692927304159515644599309780460e-01 9.31228497190786652648597510051331e-02 2.30343423636731377962538758197297e-03
 	 7.09707651653902482635771775676403e-01 1.68421618083299168278088586703234e-01 1.21870730262798349086139637620363e-01 3.29251063205589352897439958667292e-03
 	 6.36075044879270912190349918091670e-01 2.11141734019284543766303841039189e-01 1.52783221101444544043346240869141e-01 4.37451387565456796535645622725497e-03
 	 5.59099492649031915014745663938811e-01 2.55801357785928829002841666806489e-01 1.85099149565039255982412669254700e-01 5.46836255957198168198285515018142e-03
 	 4.80676393578551852669988875277340e-01 3.01300818298094630343086919310736e-01 2.18022788123353516986924205411924e-01 6.48098024897331235344433153500177e-03
 	 4.02736786165077076393714605728746e-01 3.46519766948109875226435860895435e-01 2.50743446886813103891000764633645e-01 7.31606183998760768727454006921107e-03
 	 3.27199800763811721182605651847553e-01 3.90344763986088749696534705435624e-01 2.82455435250099529120859642716823e-01 7.88343129982614632123016917830682e-03
 	 2.55925403482102742369619363671518e-01 4.31696695535402297227989265593351e-01 3.12377900982494904891240139477304e-01 8.10807655629896921467558712492973e-03
 	 1.90668594904763288866433867951855e-01 4.69557346545204867815925808827160e-01 3.39774058550031843317640323220985e-01 7.93797220195325420322163267883298e-03
 	 1.33036188558098622536363109247759e-01 5.02994477031906361830237983667757e-01 3.63969334409995015633398907084484e-01 7.34991305536146152799226172191993e-03
 	 8.44472227842096856420539552345872e-02 5.31184790291130859429813426686451e-01 3.84367986924659454928132618078962e-01 6.35277174596938186412753424292532e-03
 	 4.60979330484310168003503349609673e-02 5.53434255240667249964303664455656e-01 4.00467811710901733235346000583377e-01 4.98785019218332941609572728225430e-03
 	 1.89318370315880724064072637702338e-02 5.69195462431385301727004843996838e-01 4.11872700537026625866587892232928e-01 3.32636768743347797580578451004385e-03
 	 3.61164281855685942446143599227071e-03 5.78083922335374422729614707350265e-01 4.18304434846068717845923856657464e-01 1.46633460857070610852681546987242e-03
 	 9.90851805270955621196549145679455e-01 4.57409736452219026908716514867592e-03 4.57409736452218853436368917186883e-03 2.25681725890340352297293996519656e-05
 	 9.69552637080220991450119072396774e-01 1.52236814598894799888118001263138e-02 1.52236814598895285610691274769124e-02 1.33333880491004724399423109204577e-04
 	 9.36695848074365122748474732361501e-01 3.16520759628174455646565377264778e-02 3.16520759628174316868687299120211e-02 3.91377083765221257631583551273025e-04
 	 8.93093134981844949393803290149663e-01 5.34534325090775114253105471107119e-02 5.34534325090775391808861627396254e-02 8.37447921159852667200018672133410e-04
 	 8.39818615708710969336436846788274e-01 8.00906921456445292095693844203197e-02 8.00906921456445014539937687914062e-02 1.48831897667812008273502399902100e-03
 	 7.78184222976761819090540939214407e-01 1.10907888511619145965880761650624e-01 1.10907888511619034943578299134970e-01 2.33365435503382406476347021850870e-03
 	 7.09707651653902482635771775676403e-01 1.45146174173048786437689727790712e-01 1.45146174173048730926538496532885e-01 3.33570703004309847272690348063406e-03
 	 6.36075044879270912190349918091670e-01 1.81962477560364543904825040954165e-01 1.81962477560364543904825040954165e-01 4.43190571534479629128844280216981e-03
 	 5.59099492649031915014745663938811e-01 2.20450253675484098003778399288421e-01 2.20450253675483986981475936772767e-01 5.54010524831589218353045112053223e-03
 	 4.80676393578551797158837644019513e-01 2.59661803210724129176156793619157e-01 2.59661803210724018153854331103503e-01 6.56600806921972968838163708937827e-03
 	 4.02736786165076965371412143213092e-01 2.98631606917461545069869544022367e-01 2.98631606917461434047567081506713e-01 7.41204559046126226773409939596604e-03
 	 3.27199800763811776693756883105380e-01 3.36400099618094194919848405334051e-01 3.36400099618094083897545942818397e-01 7.98685870644303720633505605519531e-03
 	 2.55925403482102742369619363671518e-01 3.72037298258948656570765933793155e-01 3.72037298258948545548463471277501e-01 8.21445121715098924841669258967158e-03
 	 1.90668594904763288866433867951855e-01 4.04665702547618466589085528539727e-01 4.04665702547618244544480603508418e-01 8.04211516298382507461628421197020e-03
 	 1.33036188558098789069816803021240e-01 4.33481905720950744242969676633948e-01 4.33481905720950411176062289086985e-01 7.44634091998843186677170535858750e-03
 	 8.44472227842098521755076490080683e-02 4.57776388607895212690124253640533e-01 4.57776388607894879623216866093571e-01 6.43611752289384789205151093938184e-03
 	 4.60979330484310168003503349609673e-02 4.76951033475784602622127295035170e-01 4.76951033475784380577522370003862e-01 5.05328875444776594305640315951678e-03
 	 1.89318370315880724064072637702338e-02 4.90534081484206074819098830630537e-01 4.90534081484205852774493905599229e-01 3.37000827619246849306544611124536e-03
 	 3.61164281855702595791512976575177e-03 4.98194178590721625798920513261692e-01 4.98194178590721292732013125714730e-01 1.48557232118962686921725957489571e-03
 	 9.90851805270955621196549145679455e-01 3.84060130612088549556526473338636e-03 5.30759342292349330788558958715839e-03 2.22759215741159386414606963233709e-05
 	 9.69552637080220991450119072396774e-01 1.27824325193233861996944256134157e-02 1.76649304004556223501865019898105e-02 1.31607247032192989279891781606580e-04
 	 9.36695848074365122748474732361501e-01 2.65763919297184875167872064594121e-02 3.67277599959163897347380611790868e-02 3.86308868804757495150209445355927e-04
 	 8.93093134981845060416105752665317e-01 4.48817124671006192904165743584599e-02 6.20251525510543202934776729762234e-02 8.26603223657896321423244057058355e-04
 	 8.39818615708710969336436846788274e-01 6.72474572247806906544198568553838e-02 9.29339270665083400091432963563420e-02 1.46904569570067001886559676648858e-03
 	 7.78184222976761819090540939214407e-01 9.31228497190787207760109822629602e-02 1.28692927304159460133448078522633e-01 2.30343423636732375428537444861377e-03
 	 7.09707651653902482635771775676403e-01 1.21870730262798349086139637620363e-01 1.68421618083299168278088586703234e-01 3.29251063205590784044307639533145e-03
 	 6.36075044879271023212652380607324e-01 1.52783221101444488532195009611314e-01 2.11141734019284488255152609781362e-01 4.37451387565458704731469197213301e-03
 	 5.59099492649032026037048126454465e-01 1.85099149565039200471261437996873e-01 2.55801357785928773491690435548662e-01 5.46836255957200596811151882548074e-03
 	 4.80676393578551908181140106535167e-01 2.18022788123353572498075436669751e-01 3.01300818298094574831935688052909e-01 6.48098024897334097638168515231882e-03
 	 4.02736786165076965371412143213092e-01 2.50743446886813103891000764633645e-01 3.46519766948109875226435860895435e-01 7.31606183998763977965884564014232e-03
 	 3.27199800763811721182605651847553e-01 2.82455435250099529120859642716823e-01 3.90344763986088749696534705435624e-01 7.88343129982618101569968871444871e-03
 	 2.55925403482102853391921826187172e-01 3.12377900982494904891240139477304e-01 4.31696695535402297227989265593351e-01 8.10807655629900390914510666107162e-03
 	 1.90668594904763288866433867951855e-01 3.39774058550031843317640323220985e-01 4.69557346545204867815925808827160e-01 7.93797220195328889769115221497486e-03
 	 1.33036188558098733558665571763413e-01 3.63969334409995015633398907084484e-01 5.02994477031906250807935521152103e-01 7.34991305536149362037656729285118e-03
 	 8.44472227842097966643564177502412e-02 3.84367986924659343905830155563308e-01 5.31184790291130859429813426686451e-01 6.35277174596940961970314987183883e-03
 	 4.60979330484310168003503349609673e-02 4.00467811710901733235346000583377e-01 5.53434255240667249964303664455656e-01 4.98785019218335196750091498074653e-03
 	 1.89318370315880724064072637702338e-02 4.11872700537026514844285429717274e-01 5.69195462431385412749307306512492e-01 3.32636768743349228727446131870238e-03
 	 3.61164281855697044676389850792475e-03 4.18304434846068717845923856657464e-01 5.78083922335374311707312244834611e-01 1.46633460857071239689941588579813e-03
 	 9.90851805270955621196549145679455e-01 3.12610234917621004208099222410056e-03 6.02209237986816876136986209644419e-03 2.14067379468435090429483114160547e-05
 	 9.69552637080221102472421534912428e-01 1.04044104404065612667906748356472e-02 2.00429524793723362607877902519249e-02 1.26472067148829632942871881162716e-04
 	 9.36695848074365122748474732361501e-01 2.16321650236676876755126386342454e-02 4.16719869019671895760126290042535e-02 3.71235492705903398925199043745238e-04
 	 8.93093134981844949393803290149663e-01 3.65319947568747277477640977849660e-02 7.03748702612803228584326120653714e-02 7.94350013129049045516871796479563e-04
 	 8.39818615708710969336436846788274e-01 5.47368542710943845053250811361067e-02 1.05444530020194646158238072075619e-01 1.41172503840845953160254566682852e-03
 	 7.78184222976761819090540939214407e-01 7.57984326060717750195294684090186e-02 1.46017344417166405889929592376575e-01 2.21355659345643957652827182869260e-03
 	 7.09707651653902482635771775676403e-01 9.91981061827932886210135166038526e-02 1.91094242163304228743214707719744e-01 3.16404024197657106690084738431779e-03
 	 6.36075044879270912190349918091670e-01 1.24359689624315483680305760572082e-01 2.39565265496413604129344321336248e-01 4.20382482805023785510378786511865e-03
 	 5.59099492649031915014745663938811e-01 1.50663617533950522364705193467671e-01 2.90236889817017562620549142593518e-01 5.25499265750283949677479355955256e-03
 	 4.80676393578551852669988875277340e-01 1.77462198182387953515615208743839e-01 3.41861408239060193814395915978821e-01 6.22809904258459119674729009830116e-03
 	 4.02736786165076965371412143213092e-01 2.04095561052942742197302550266613e-01 3.93167652781980236920134075262467e-01 7.03059660586601974791021163468940e-03
 	 3.27199800763811776693756883105380e-01 2.29907904854816658168914500492974e-01 4.42892294381371620648479847659473e-01 7.57582789092847881662340370212405e-03
 	 2.55925403482102742369619363671518e-01 2.54263645782703939790536651344155e-01 4.89810950735193262328692753726500e-01 7.79170771975239758594389272161607e-03
 	 1.90668594904763288866433867951855e-01 2.76563068634481545871039998019114e-01 5.32768336460755165262526134029031e-01 7.62824066295835021694893285371109e-03
 	 1.33036188558098733558665571763413e-01 2.96257096385878715416595241549658e-01 5.70706715056022551024739186686929e-01 7.06312698151307077204519302426888e-03
 	 8.44472227842097966643564177502412e-02 3.12860818163635867605876228481065e-01 6.02691959052154335729767353768693e-01 6.10489310395571135176018273682530e-03
 	 4.60979330484310168003503349609673e-02 3.25965458836799615305324095970718e-01 6.27936608114769367894325569068315e-01 4.79322939017033915892751494425283e-03
 	 1.89318370315880724064072637702338e-02 3.35248601477672325543721854046453e-01 6.45819561490739602049870882183313e-01 3.19657622975639361603827914848353e-03
 	 3.61164281855697044676389850792475e-03 3.40483786838029711674380450858735e-01 6.55904570343413317878855650633341e-01 1.40911973511948147332051295421707e-03
 	 9.90851805270955621196549145679455e-01 2.44910556076028719518777876373861e-03 6.69908916828409160826307555680614e-03 1.99831340893015907791193525033790e-05
 	 9.69552637080220991450119072396774e-01 8.15120447759715496816035340543749e-03 2.22961584421818535817205741977887e-02 1.18061345108345960071977165384283e-04
 	 9.36695848074365122748474732361501e-01 1.69474475666831145281854276163358e-02 4.63567043589517627233398400221631e-02 3.46547365033909025335001619083641e-04
 	 8.93093134981844949393803290149663e-01 2.86205317392454750002883656634367e-02 7.82863332789095756059083441869006e-02 7.41523667249679128976591613309211e-04
 	 8.39818615708710969336436846788274e-01 4.28828999182286063618363414207124e-02 1.17298484373060424301726811791013e-01 1.31784164452297789145440720659508e-03
 	 7.78184222976761708068238476698752e-01 5.93833285213338224473034188122256e-02 1.62432448501904469484458104489022e-01 2.06634931165773855568645878122425e-03
 	 7.09707651653902482635771775676403e-01 7.77155084295911569025605558636016e-02 2.12576839916506360461667668459995e-01 2.95362332067446772126961818116797e-03
 	 6.36075044879270912190349918091670e-01 9.74280344575393364436877163825557e-02 2.66496920663189751365962365525775e-01 3.92425952218703084917184042978988e-03
 	 5.59099492649031915014745663938811e-01 1.18035515888945785611952032923000e-01 3.22864991462022299373302303138189e-01 4.90552195173009960432741749514207e-03
 	 4.80676393578551852669988875277340e-01 1.39030526786099173364164016675204e-01 3.80293079635348973965847108047456e-01 5.81391422637423868624573231045360e-03
 	 4.02736786165077020882563374470919e-01 1.59896099893521936863294286013115e-01 4.37367113941401042254142339515965e-01 6.56304361045936465735017861788947e-03
 	 3.27199800763811721182605651847553e-01 1.80118455939569099832908705138834e-01 4.92681743296619178984485643013613e-01 7.07201559424038266737921887283846e-03
 	 2.55925403482102797880770594929345e-01 1.99199654787279412104794573679101e-01 5.44874941730617790014434831391554e-01 7.27353885188365949926447839857246e-03
 	 1.90668594904763288866433867951855e-01 2.16669857105647234440937154431595e-01 5.92661547989589476692628977616550e-01 7.12094278034719214282022292650254e-03
 	 1.33036188558098733558665571763413e-01 2.32098895407104266475073472975055e-01 6.34864916034796999966260955261532e-01 6.59341063135458847060954568064517e-03
 	 8.44472227842097966643564177502412e-02 2.45106872367915396004889316827757e-01 6.70445904847874807330754265422001e-01 5.69890180372802177682922675217014e-03
 	 4.60979330484310168003503349609673e-02 2.55373538253908627382315899012610e-01 6.98528528697660355817333766026422e-01 4.47446714498968278750368199325749e-03
 	 1.89318370315880724064072637702338e-02 2.62646299578912501004879231913947e-01 7.18421863389499426588713504315820e-01 2.98399558048100888366094274317675e-03
 	 3.61164281855697044676389850792475e-03 2.66747739693642182956523356551770e-01 7.29640617487800846596712744940305e-01 1.31540960069190812978257021370609e-03
 	 9.90851805270955621196549145679455e-01 1.82714466919302060549101796027571e-03 7.32105005985135819795983636026904e-03 1.80419830115715995437226243369722e-05
 	 9.69552637080220991450119072396774e-01 6.08117103948777049104990055639064e-03 2.43661918802912380588310270468355e-02 1.06592928479043959539597496988250e-04
 	 9.36695848074365233770777194877155e-01 1.26435703605525806558773638244020e-02 5.06605815650821855733454412984429e-02 3.12883937259573737064283216469107e-04
 	 8.93093134981845060416105752665317e-01 2.13522245977009611506147734871774e-02 8.55546404204539784332794738475059e-02 6.69492450353895499071121832912468e-04
 	 8.39818615708710969336436846788274e-01 3.19926030304735486975431513201329e-02 1.28188781260815481966020001891593e-01 1.18982720408979309768826571058753e-03
 	 7.78184222976761819090540939214407e-01 4.43026768160250938866084879919072e-02 1.77513100207213087022850572793686e-01 1.86562523227329054090195548099018e-03
 	 7.09707651653902482635771775676403e-01 5.79793207838178170643317344001844e-02 2.32313027562279700299896489923412e-01 2.66670991327231298936850656389197e-03
 	 6.36075044879270912190349918091670e-01 7.26857660368812052986697835876839e-02 2.91239189083847882510980298320646e-01 3.54305902747265250365971134272058e-03
 	 5.59099492649031915014745663938811e-01 8.80598889191956946120853899628855e-02 3.52840618431772390373168946098303e-01 4.42900214353209465550920143073199e-03
 	 4.80676393578551908181140106535167e-01 1.03723126492538397780407422033022e-01 4.15600479928909749549603702689637e-01 5.24915367300347792539616520457457e-03
 	 4.02736786165077020882563374470919e-01 1.19289797559607335664111360529205e-01 4.77973416275315643453325264999876e-01 5.92551302488156499820304290437889e-03
 	 3.27199800763811721182605651847553e-01 1.34376599304726118688790847954806e-01 5.38423599931462160128603500197642e-01 6.38504373931835997324490961091215e-03
 	 2.55925403482102797880770594929345e-01 1.48612045630519773453670495655388e-01 5.95462550887377428665558909415267e-01 6.56699113428595507291340993560880e-03
 	 1.90668594904763288866433867951855e-01 1.61645614925025826735804912459571e-01 6.47685790170210884397761219588574e-01 6.42921816444097689313696974977574e-03
 	 1.33036188558098733558665571763413e-01 1.73156382584436441263164851989131e-01 6.93807428857464825178169576247456e-01 5.95293020942605499712385608290788e-03
 	 8.44472227842097966643564177502412e-02 1.82860927844442855416673410218209e-01 7.32691849371347347918970172031550e-01 5.14531349627095780513430511859951e-03
 	 4.60979330484310168003503349609673e-02 1.90520329768366081246711019048234e-01 7.63381737183202901952938645990798e-01 4.03981977276321110870149766469694e-03
 	 1.89318370315880724064072637702338e-02 1.95946142072335849348974079475738e-01 7.85122020896076078244618656754028e-01 2.69413182782304513884774621601537e-03
 	 3.61164281855697044676389850792475e-03 1.99006003828280930711969176627463e-01 7.97382353353162098841266924864613e-01 1.18763140771033291580305313317467e-03
 	 9.90851805270955621196549145679455e-01 1.27632787286347665345331847674970e-03 7.87186685618090214999753584379505e-03 1.56335656311009248934252441332049e-05
 	 9.69552637080220991450119072396774e-01 4.24792203278374913555381908736308e-03 2.61994408869952594143271085158631e-02 9.23638794094630799459341718993244e-05
 	 9.36695848074365122748474732361501e-01 8.83199975118063862478123837718158e-03 5.44721521744542386267440292613173e-02 2.71117180685047246078284155501592e-04
 	 8.93093134981844949393803290149663e-01 1.49153156075611942332770354369131e-02 9.19915494105938563729196744134242e-02 5.80122160375678421959100283800126e-04
 	 8.39818615708710969336436846788274e-01 2.23480119892664752523359084079857e-02 1.37833372302022555411227244803740e-01 1.03099762774839132269122377039139e-03
 	 7.78184222976761819090540939214407e-01 3.09470520950752281397200249557500e-02 1.90868724928162952769739035829843e-01 1.61658363679180613024788382148245e-03
 	 7.09707651653902482635771775676403e-01 4.05006918246723357501792861512513e-02 2.49791656521425181614048938172346e-01 2.31073183150163176738378645325156e-03
 	 6.36075044879270912190349918091670e-01 5.07736856952209492099825638433686e-02 3.13151269425508138599667518064962e-01 3.07009743914138464454532950753674e-03
 	 5.59099492649032026037048126454465e-01 6.15130769904886354204620602104114e-02 3.79387430360479338542489813335123e-01 3.83777634901809154566176829348478e-03
 	 4.80676393578551852669988875277340e-01 7.24544255499156575339725350204390e-02 4.46869180871532489796038589702221e-01 4.54844616592320078601874300261443e-03
 	 4.02736786165077020882563374470919e-01 8.33283188467023316903237173391972e-02 5.13934894988220647427112908189883e-01 5.13451856777687523636366506707418e-03
 	 3.27199800763811721182605651847553e-01 9.38670057412462899293359441799112e-02 5.78933193494941988888058403972536e-01 5.53270670369556370749020146604380e-03
 	 2.55925403482102797880770594929345e-01 1.03810989507067685799768241849961e-01 6.40263607010829516319461163220694e-01 5.69036601081326573470242635721661e-03
 	 1.90668594904763288866433867951855e-01 1.12915417883186819381080567836761e-01 6.96415987212049891752485564211383e-01 5.57098430178041073568273588989541e-03
 	 1.33036188558098733558665571763413e-01 1.20956113209326310276026106294012e-01 7.46007698232574956165308321942575e-01 5.15827584289022499086652118194252e-03
 	 8.44472227842097966643564177502412e-02 1.27735095638934370576578203326790e-01 7.87817681576855832759065378922969e-01 4.45846757448722669919805028371229e-03
 	 4.60979330484310168003503349609673e-02 1.33085470094660873741077011800371e-01 8.20816596856908109458572653238662e-01 3.50054578339897446911943568181869e-03
 	 1.89318370315880724064072637702338e-02 1.36875599903889866304496081284015e-01 8.44192563064522061289096654945752e-01 2.33449320521450769810867242881613e-03
 	 3.61164281855697044676389850792475e-03 1.39013026081504231790120229561580e-01 8.57375331099938797763115871930495e-01 1.02909494738399843669074407159769e-03
 	 9.90851805270955621196549145679455e-01 8.10920422301865048697600002469699e-04 8.33727430674251375475325431807505e-03 1.28202766212825757977762305972469e-05
 	 9.69552637080220991450119072396774e-01 2.69893559638563484970319450440002e-03 2.77484273233933737001777330988261e-02 7.57428287177450154394470205332368e-05
 	 9.36695848074365122748474732361501e-01 5.61144915838052843470862285357725e-03 5.76927027672543488168166447849217e-02 2.22329143279375321612736926546461e-04
 	 8.93093134981845060416105752665317e-01 9.47651014164044291909760886483127e-03 9.74303548765144966647966384698520e-02 4.75728106156196757763748861336239e-04
 	 8.39818615708710969336436846788274e-01 1.41989058652185196063300054447609e-02 1.45982478426070511057233147766965e-01 8.45467700428216323467467407937193e-04
 	 7.78184222976761708068238476698752e-01 1.96623431075226562381175199334393e-02 2.02153433915715635693644003367808e-01 1.32567642559290447580588878651042e-03
 	 7.09707651653902482635771775676403e-01 2.57322893405886321538389438501326e-02 2.64560059005508885210389280473464e-01 1.89491137060379482258409833406176e-03
 	 6.36075044879271023212652380607324e-01 3.22592803316416043557524062634911e-02 3.31665674789087372431595213129185e-01 2.51762773463420561070869041486731e-03
 	 5.59099492649031803992443201423157e-01 3.90825989393321360232391725730849e-02 4.01817908411636059984317626003758e-01 3.14716140680972988191710371097543e-03
 	 4.80676393578551852669988875277340e-01 4.60342319663979981925194806535728e-02 4.73289374455050149137491644069087e-01 3.72994487758715985437074635910903e-03
 	 4.02736786165077020882563374470919e-01 5.29430070012270048707136993471067e-02 5.44320206833695974246722926181974e-01 4.21055246827755583899355329435821e-03
 	 3.27199800763811721182605651847553e-01 5.96388072017330905794096906902269e-02 6.13161392034455188237984657462221e-01 4.53708591370186476582349044406328e-03
 	 2.55925403482102797880770594929345e-01 6.59567602028310329131954858894460e-02 6.78117836315066169206033919181209e-01 4.66637413731399441907399250339950e-03
 	 1.90668594904763288866433867951855e-01 7.17412980637928132665592784178443e-02 7.37590107031443897867006853630301e-01 4.56847538731431929842630168536743e-03
 	 1.33036188558098733558665571763413e-01 7.68499885406724869696404311980586e-02 7.90113822901228779471693997038528e-01 4.23003457785562590048877851245379e-03
 	 8.44472227842097966643564177502412e-02 8.11570442835369831868774781469256e-02 8.34395732932253220148766104102833e-01 3.65615809986655389274279315259264e-03
 	 4.60979330484310168003503349609673e-02 8.45564277847190570724933422752656e-02 8.69345639166849926127156322763767e-01 2.87061610432365809861265937286134e-03
 	 1.89318370315880724064072637702338e-02 8.69645031161645487571831836248748e-02 8.94103659852247378836409552604891e-01 1.91439684123083614201987767700075e-03
 	 3.61164281855697044676389850792475e-03 8.83225260626520070061928890936542e-02 9.08065831118791022547043212398421e-01 8.43907410909562204388845163549604e-04
 	 9.90851805270955621196549145679455e-01 4.42974326044993579887254497862159e-04 8.70522040299938522356359982268259e-03 9.67504566497260151550566242839579e-06
 	 9.69552637080220991450119072396774e-01 1.47432367463884439473531529074535e-03 2.89730392451401641551456123124808e-02 5.71606485792869109118126413893179e-05
 	 9.36695848074365122748474732361501e-01 3.06531669533419148798714104486862e-03 6.02388352303006857635381265936303e-02 1.67784571068560608769412723084713e-04
 	 8.93093134981844949393803290149663e-01 5.17664937002791647469024383099168e-03 1.01730215648127134131506466019346e-01 3.59016524146705238735438614483542e-04
 	 8.39818615708710969336436846788274e-01 7.75631070970872471548318571876734e-03 1.52425073581580305948079967492959e-01 6.38046966656170659593083627214583e-04
 	 7.78184222976761708068238476698752e-01 1.07407742448962506554011042680941e-02 2.11075002778342041276360419033153e-01 1.00044486819394823004514272213328e-03
 	 7.09707651653902482635771775676403e-01 1.40565500815551525093383133935276e-02 2.76235798264542364854889910930069e-01 1.43002796142735759572783837967336e-03
 	 6.36075044879270912190349918091670e-01 1.76219917153424554534524304472143e-02 3.46302963405386632356197651461116e-01 1.89997174160432425599198680288282e-03
 	 5.59099492649031915014745663938811e-01 2.13493056150864113362786156358197e-02 4.19551201735881673648975720425369e-01 2.37506032244079283433091376309676e-03
 	 4.80676393578551852669988875277340e-01 2.51467126976895327672423263720702e-02 4.94176893723758614562768798350589e-01 2.81486804727588838317964281543482e-03
 	 4.02736786165077020882563374470919e-01 2.89207081239764018931737155071460e-02 5.68342505710946577224262910021935e-01 3.17756695964903313963989539558952e-03
 	 3.27199800763811721182605651847553e-01 3.25783636713995461420267929497641e-02 6.40221835564788732675367555202683e-01 3.42399112731297302486543898680793e-03
 	 2.55925403482102797880770594929345e-01 3.60296159714723618350262768217362e-02 7.08044980546424840284203128248919e-01 3.52156074334715506538029394789646e-03
 	 1.90668594904763288866433867951855e-01 3.91894843012989824160285934340209e-02 7.70141920793937728717537538614124e-01 3.44767974180790453403444573154957e-03
 	 1.33036188558098733558665571763413e-01 4.19801634588721217511420036316849e-02 8.24983647983029144690192424604902e-01 3.19226947390718234290329924363050e-03
 	 8.44472227842097966643564177502412e-02 4.43329407012035270341243631264661e-02 8.71219836514586676301519219123293e-01 2.75918356674502863318254597402301e-03
 	 4.60979330484310168003503349609673e-02 4.61898918569410010803721888805740e-02 9.07712175094627982119277476158459e-01 2.16636057991380706622130958294292e-03
 	 1.89318370315880724064072637702338e-02 4.75053298674731339090726578433532e-02 9.33562833100938793684520078386413e-01 1.44473301215981581729908000966134e-03
 	 3.61164281855697044676389850792475e-03 4.82471650499763926589480433904100e-02 9.48141192131466636894288058101665e-01 6.36869466919659813972098838519287e-04
 	 9.90851805270955621196549145679455e-01 1.82011786449540191590301674295915e-04 8.96618294259483861186055264624883e-03 6.27970978164217887674625542815399e-06
 	 9.69552637080221102472421534912428e-01 6.05778416599728197766694393067155e-04 2.98415845031791693298117706945050e-02 3.71008361550069894413753091022556e-05
 	 9.36695848074365122748474732361501e-01 1.25949459132922852999669771634217e-03 6.20446573343056487215285699221567e-02 1.08902681044954137185194753545403e-04
 	 8.93093134981844949393803290149663e-01 2.12701085427233205216168698825641e-03 1.04779854163882718554035022862081e-01 2.33024179577515723514949397277007e-04
 	 8.39818615708710969336436846788274e-01 3.18695663727563971434619816136546e-03 1.56994427654013390949216955050360e-01 4.14132389283066284016432412329323e-04
 	 7.78184222976761819090540939214407e-01 4.41322982670155905537967555574141e-03 2.17402547196536621854079385229852e-01 6.49351294282397438657750132762203e-04
 	 7.09707651653902482635771775676403e-01 5.77563448090540054735697594878729e-03 2.84516713865192116816871248374810e-01 9.28177590924335262252686806760948e-04
 	 6.36075044879270912190349918091670e-01 7.24062322425139681669747915293556e-03 3.56684331896477690992952602755395e-01 1.23320049783250205305273894396123e-03
 	 5.59099492649032026037048126454465e-01 8.77212295609292036502324663160834e-03 4.32128384394875053597928626913927e-01 1.54156270216052873264778177997414e-03
 	 4.80676393578551852669988875277340e-01 1.03324229697567826491422238177620e-02 5.08991183451691364680868900904898e-01 1.82702542423198734632128203969614e-03
 	 4.02736786165077020882563374470919e-01 1.18831034701908366812972417392302e-02 5.85380110364732142436139383789850e-01 2.06243970409079619560133167510685e-03
 	 3.27199800763811721182605651847553e-01 1.33859815858311526071133812365588e-02 6.59414217650357126210280966915889e-01 2.22238440199694874122027243856792e-03
 	 2.55925403482102797880770594929345e-01 1.48040515724888743775977673067246e-02 7.29270544945408327741631637763930e-01 2.28571318548984438526194828966709e-03
 	 1.90668594904763288866433867951855e-01 1.61023960720269032620421967294533e-02 7.93229009023209807871523935318692e-01 2.23775979445591530550552228362449e-03
 	 1.33036188558098733558665571763413e-01 1.72490460447519700082352755998727e-02 8.49714765397149296433099152636714e-01 2.07198255544248496548553895024725e-03
 	 8.44472227842097966643564177502412e-02 1.82157684117522089550789132772479e-02 8.97337008804037994380564668972511e-01 1.79088271347029167820941175648386e-03
 	 4.60979330484310168003503349609673e-02 1.89787629632038878924049640772864e-02 9.34923303988365095307244700961746e-01 1.40610351571785396548874835787046e-03
 	 1.89318370315880724064072637702338e-02 1.95192575431003545460839632141870e-02 9.61548905425311573047508773015579e-01 9.37722088606499299193175467337369e-04
 	 3.61164281855697044676389850792475e-03 1.98240669617951725811622054607142e-02 9.76564290219647856972073896031361e-01 4.13368118304995469519669271107887e-04
 	 9.90851805270955621196549145679455e-01 3.47318355634652908836557116956101e-05 9.11346289348091351256719860884914e-03 2.72713356304095319254210232073898e-06
 	 9.69552637080220991450119072396774e-01 1.15595790600466624686859518078563e-04 3.03317671291785419251940680851476e-02 1.61120400485679750529968701222572e-05
 	 9.36695848074365122748474732361501e-01 2.40339155460386755258639368548756e-04 6.30638127701744904962666282699502e-02 4.72939302786016927977047474840333e-05
 	 8.93093134981844949393803290149663e-01 4.05880260137839177225771436496871e-04 1.06500984758017211428970938413840e-01 1.01197043051843354132500463204991e-04
 	 8.39818615708710969336436846788274e-01 6.08141132137252071743205306120217e-04 1.59573243159151778591819947905606e-01 1.79848174139800591649074323896684e-04
 	 7.78184222976761708068238476698752e-01 8.42140916447020604351791916997172e-04 2.20973636106791271327409731384250e-01 2.81998335977003914548655316707482e-04
 	 7.09707651653902482635771775676403e-01 1.10211756600220311952398333232850e-03 2.89190230780095314244704240991268e-01 4.03086185299842184558138935557281e-04
 	 6.36075044879270912190349918091670e-01 1.38166950672408139766389467695262e-03 3.62543285614005006411986187231378e-01 5.35550620098618483828911696065234e-04
 	 5.59099492649031803992443201423157e-01 1.67391320087934003524310355714988e-03 4.39226594150088855972313695019693e-01 6.69465234983311835784136611948725e-04
 	 4.80676393578551852669988875277340e-01 1.97165261963538895884084922727197e-03 5.17351953801812758371170275495388e-01 7.93435131272774655381008201970872e-04
 	 4.02736786165077020882563374470919e-01 2.26755642456555328578815533546731e-03 5.94995657410357425831648470193613e-01 8.95670139919015821476644401144540e-04
 	 3.27199800763811721182605651847553e-01 2.55433848743380487178455950925127e-03 6.70245860748754473945609788643196e-01 9.65130444464530850949557372331356e-04
 	 2.55925403482102797880770594929345e-01 2.82493730169108836491886904696003e-03 7.41249659216206113754310536023695e-01 9.92632678958696576185238846790071e-04
 	 1.90668594904763288866433867951855e-01 3.07268987058961773328746858169325e-03 8.06258715224647093400278663466452e-01 9.71807623868959952369295240970359e-04
 	 1.33036188558098733558665571763413e-01 3.29149580111964823458947648759931e-03 8.63672315640781618206744951748988e-01 8.99814380833521159676335887667165e-04
 	 8.44472227842097966643564177502412e-02 3.47596760341961630302876073983498e-03 9.12076809612370587032614821509924e-01 7.77739183051465859941586700188054e-04
 	 4.60979330484310168003503349609673e-02 3.62156367614530072529532844782807e-03 9.50280503275423682474354336591205e-01 6.10638425048564098367165353664632e-04
 	 1.89318370315880724064072637702338e-02 3.72470188075335606470162019832060e-03 9.77343461087658571528891116031446e-01 4.07231141177817406676814337984638e-04
 	 3.61164281855697044676389850792475e-03 3.78286619425638459546235026209615e-03 9.92605490987186644957773751229979e-01 1.79516268827607967939474775675990e-04
 	 ];
 
 	 case  37 

 	 % ALG. DEG.:   37
 	 % PTS CARD.:  361
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw_bar=[
 	 9.90851805270955621196549145679455e-01 9.11346289348091351256719860884914e-03 3.47318355634652908836557116956101e-05 2.72713356304074948111828766150744e-06
 	 9.69552637080220991450119072396774e-01 3.03317671291784864140428368273206e-02 1.15595790600522135838090775905584e-04 1.61120400485667722662117690157757e-05
 	 9.36695848074365122748474732361501e-01 6.30638127701744766184788204554934e-02 2.40339155460400633046447183005512e-04 4.72939302785981623643805915602201e-05
 	 8.93093134981844949393803290149663e-01 1.06500984758017155917819707156013e-01 4.05880260137894688377002694323892e-04 1.01197043051835805374874532880369e-04
 	 8.39818615708710969336436846788274e-01 1.59573243159151750836244332276692e-01 6.08141132137279827318820935033727e-04 1.79848174139787147542135503641703e-04
 	 7.78184222976761708068238476698752e-01 2.20973636106791188060682884497510e-01 8.42140916447103871078638803737704e-04 2.81998335976982881026509097921462e-04
 	 7.09707651653902482635771775676403e-01 2.89190230780095314244704240991268e-01 1.10211756600220311952398333232850e-03 4.03086185299812097947852462809237e-04
 	 6.36075044879270912190349918091670e-01 3.62543285614004950900834955973551e-01 1.38166950672413690881512593477964e-03 5.35550620098578476768746980951619e-04
 	 5.59099492649031803992443201423157e-01 4.39226594150088744950011232504039e-01 1.67391320087945105754556607280392e-03 6.69465234983261745643767781643874e-04
 	 4.80676393578551852669988875277340e-01 5.17351953801812758371170275495388e-01 1.97165261963538895884084922727197e-03 7.93435131272715349522173244878331e-04
 	 4.02736786165077020882563374470919e-01 5.94995657410357425831648470193613e-01 2.26755642456555328578815533546731e-03 8.95670139918948926202602045520962e-04
 	 3.27199800763811721182605651847553e-01 6.70245860748754362923307326127542e-01 2.55433848743391589408702202490531e-03 9.65130444464458751505087086286494e-04
 	 2.55925403482102797880770594929345e-01 7.41249659216206113754310536023695e-01 2.82493730169108836491886904696003e-03 9.92632678958622416756640838286785e-04
 	 1.90668594904763288866433867951855e-01 8.06258715224647093400278663466452e-01 3.07268987058961773328746858169325e-03 9.71807623868887310823738712173281e-04
 	 1.33036188558098733558665571763413e-01 8.63672315640781507184442489233334e-01 3.29149580111975925689193900325336e-03 8.99814380833453939141641786392256e-04
 	 8.44472227842097966643564177502412e-02 9.12076809612370587032614821509924e-01 3.47596760341961630302876073983498e-03 7.77739183051407746705141477150391e-04
 	 4.60979330484310168003503349609673e-02 9.50280503275423682474354336591205e-01 3.62156367614530072529532844782807e-03 6.10638425048518453455703713927960e-04
 	 1.89318370315880724064072637702338e-02 9.77343461087658571528891116031446e-01 3.72470188075335606470162019832060e-03 4.07231141177786994805876119585264e-04
 	 3.61164281855697044676389850792475e-03 9.92605490987186533935471288714325e-01 3.78286619425649561776481277775019e-03 1.79516268827594550937590267558619e-04
 	 9.90851805270955621196549145679455e-01 8.96618294259483687713707666944174e-03 1.82011786449541926313777651103010e-04 6.27970978164236945915938764573028e-06
 	 9.69552637080221102472421534912428e-01 2.98415845031792213715160499987178e-02 6.05778416599676156062415088854323e-04 3.71008361550081210773928408475086e-05
 	 9.36695848074365122748474732361501e-01 6.20446573343056417826346660149284e-02 1.25949459132923546889060162357055e-03 1.08902681044957444001820834333927e-04
 	 8.93093134981844949393803290149663e-01 1.04779854163882649165095983789797e-01 2.12701085427240144110072606054018e-03 2.33024179577522797934124865193439e-04
 	 8.39818615708710969336436846788274e-01 1.56994427654013363193641339421447e-01 3.18695663727566746992181379027897e-03 4.14132389283078860761633244180757e-04
 	 7.78184222976761819090540939214407e-01 2.17402547196536649609655000858766e-01 4.41322982670153129980405992682790e-03 6.49351294282417171137289368942902e-04
 	 7.09707651653902482635771775676403e-01 2.84516713865192061305720017116982e-01 5.77563448090545605850820720661432e-03 9.28177590924363451509171429876233e-04
 	 6.36075044879270912190349918091670e-01 3.56684331896477579970650140239741e-01 7.24062322425150783899994166858960e-03 1.23320049783253956644790694241465e-03
 	 5.59099492649032026037048126454465e-01 4.32128384394875053597928626913927e-01 8.77212295609292036502324663160834e-03 1.54156270216057557018163315376569e-03
 	 4.80676393578551852669988875277340e-01 5.08991183451691253658566438389244e-01 1.03324229697568936714446863334160e-02 1.82702542423204285747251329752316e-03
 	 4.02736786165077020882563374470919e-01 5.85380110364732031413836921274196e-01 1.18831034701909477035997042548843e-02 2.06243970409085864564646684016225e-03
 	 3.27199800763811721182605651847553e-01 6.59414217650357015187978504400235e-01 1.33859815858312636294158437522128e-02 2.22238440199701639543583553404460e-03
 	 2.55925403482102797880770594929345e-01 7.29270544945408216719329175248276e-01 1.48040515724889853999002298223786e-02 2.28571318548991377420098736195087e-03
 	 1.90668594904763288866433867951855e-01 7.93229009023209696849221472803038e-01 1.61023960720270142843446592451073e-02 2.23775979445598295972108537910117e-03
 	 1.33036188558098733558665571763413e-01 8.49714765397149185410796690121060e-01 1.72490460447520810305377381155267e-02 2.07198255544254784921154310950442e-03
 	 8.44472227842097966643564177502412e-02 8.97337008804037883358262206456857e-01 1.82157684117523199773813757929020e-02 1.79088271347034588831803603170556e-03
 	 4.60979330484310168003503349609673e-02 9.34923303988364873262639775930438e-01 1.89787629632041099370098891085945e-02 1.40610351571789668305434428674516e-03
 	 1.89318370315880724064072637702338e-02 9.61548905425311462025206310499925e-01 1.95192575431004655683864257298410e-02 9.37722088606527813710311836103983e-04
 	 3.61164281855697044676389850792475e-03 9.76564290219647634927468971000053e-01 1.98240669617953946257671304920223e-02 4.13368118305008046264870102959321e-04
 	 9.90851805270955621196549145679455e-01 8.70522040299938522356359982268259e-03 4.42974326044993579887254497862159e-04 9.67504566497260998583513497139919e-06
 	 9.69552637080220991450119072396774e-01 2.89730392451401086439943810546538e-02 1.47432367463889990588654654857237e-03 5.71606485792869718981848436989424e-05
 	 9.36695848074365122748474732361501e-01 6.02388352303006857635381265936303e-02 3.06531669533419148798714104486862e-03 1.67784571068560771399738595910378e-04
 	 8.93093134981844949393803290149663e-01 1.01730215648127078620355234761519e-01 5.17664937002797198584147508881870e-03 3.59016524146705618206198984410094e-04
 	 8.39818615708710969336436846788274e-01 1.52425073581580305948079967492959e-01 7.75631070970872471548318571876734e-03 6.38046966656171310114387118517243e-04
 	 7.78184222976761708068238476698752e-01 2.11075002778341985765209187775326e-01 1.07407742448963061665523355259211e-02 1.00044486819394909740688071053683e-03
 	 7.09707651653902482635771775676403e-01 2.76235798264542364854889910930069e-01 1.40565500815551525093383133935276e-02 1.43002796142735911361087985937957e-03
 	 6.36075044879271023212652380607324e-01 3.46302963405386576845046420203289e-01 1.76219917153423999423011991893873e-02 1.89997174160432620755589727679080e-03
 	 5.59099492649031915014745663938811e-01 4.19551201735881673648975720425369e-01 2.13493056150864113362786156358197e-02 2.37506032244079500273525873410563e-03
 	 4.80676393578551852669988875277340e-01 4.94176893723758614562768798350589e-01 2.51467126976895327672423263720702e-02 2.81486804727589141894572577484723e-03
 	 4.02736786165077020882563374470919e-01 5.68342505710946577224262910021935e-01 2.89207081239764018931737155071460e-02 3.17756695964903617540597835500193e-03
 	 3.27199800763811721182605651847553e-01 6.40221835564788732675367555202683e-01 3.25783636713995461420267929497641e-02 3.42399112731297649431239094042212e-03
 	 2.55925403482102797880770594929345e-01 7.08044980546424840284203128248919e-01 3.60296159714723618350262768217362e-02 3.52156074334715896850811489571242e-03
 	 1.90668594904763288866433867951855e-01 7.70141920793937728717537538614124e-01 3.91894843012989824160285934340209e-02 3.44767974180790800348139768516376e-03
 	 1.33036188558098733558665571763413e-01 8.24983647983029144690192424604902e-01 4.19801634588721217511420036316849e-02 3.19226947390718581235025119724469e-03
 	 8.44472227842097966643564177502412e-02 8.71219836514586676301519219123293e-01 4.43329407012035270341243631264661e-02 2.75918356674503166894862893343543e-03
 	 4.60979330484310168003503349609673e-02 9.07712175094627982119277476158459e-01 4.61898918569410010803721888805740e-02 2.16636057991380923462565455395179e-03
 	 1.89318370315880724064072637702338e-02 9.33562833100938793684520078386413e-01 4.75053298674731339090726578433532e-02 1.44473301215981733518212148936755e-03
 	 3.61164281855697044676389850792475e-03 9.48141192131466636894288058101665e-01 4.82471650499763926589480433904100e-02 6.36869466919660464493402329821947e-04
 	 9.90851805270955621196549145679455e-01 8.33727430674251202002977834126796e-03 8.10920422301866783421075979276793e-04 1.28202766212826012087646482262571e-05
 	 9.69552637080220991450119072396774e-01 2.77484273233933147195795498873849e-02 2.69893559638569383030137771584123e-03 7.57428287177451645172457372900965e-05
 	 9.36695848074365122748474732361501e-01 5.76927027672543418779227408776933e-02 5.61144915838053537360252676080563e-03 2.22329143279375755293605920748234e-04
 	 8.93093134981845060416105752665317e-01 9.74303548765145244203722540987656e-02 9.47651014164041516352199323591776e-03 4.75728106156197679335595474015008e-04
 	 8.39818615708710969336436846788274e-01 1.45982478426070483301657532138051e-01 1.41989058652185473619056210736744e-02 8.45467700428218058190943384744287e-04
 	 7.78184222976761708068238476698752e-01 2.02153433915715552426917156481068e-01 1.96623431075227395048443668201799e-02 1.32567642559290707789110275172106e-03
 	 7.09707651653902482635771775676403e-01 2.64560059005508885210389280473464e-01 2.57322893405886321538389438501326e-02 1.89491137060379850887148478477684e-03
 	 6.36075044879270912190349918091670e-01 3.31665674789087372431595213129185e-01 3.22592803316417153780548687791452e-02 2.51762773463421038119824935108682e-03
 	 5.59099492649031915014745663938811e-01 4.01817908411635893450863932230277e-01 3.90825989393321915343904038309120e-02 3.14716140680973638713013862400203e-03
 	 4.80676393578551797158837644019513e-01 4.73289374455050093626340412811260e-01 4.60342319663980537036707119113998e-02 3.72994487758716722694551926053919e-03
 	 4.02736786165077020882563374470919e-01 5.44320206833695863224420463666320e-01 5.29430070012271158930161618627608e-02 4.21055246827756451261093317839368e-03
 	 3.27199800763811721182605651847553e-01 6.13161392034455077215682194946567e-01 5.96388072017332016017121532058809e-02 4.53708591370187343944087032809875e-03
 	 2.55925403482102797880770594929345e-01 6.78117836315066058183731456665555e-01 6.59567602028311439354979484051000e-02 4.66637413731400396005311037583851e-03
 	 1.90668594904763288866433867951855e-01 7.37590107031443786844704391114647e-01 7.17412980637929242888617409334984e-02 4.56847538731432797204368156940291e-03
 	 1.33036188558098844580968034279067e-01 7.90113822901228557427089072007220e-01 7.68499885406725979919428937137127e-02 4.23003457785563457410615839648926e-03
 	 8.44472227842097966643564177502412e-02 8.34395732932253109126463641587179e-01 8.11570442835370942091799406625796e-02 3.65615809986656126531756605402279e-03
 	 4.60979330484310168003503349609673e-02 8.69345639166849815104853860248113e-01 8.45564277847191680947958047909196e-02 2.87061610432366373646395629748440e-03
 	 1.89318370315880724064072637702338e-02 8.94103659852247267814107090089237e-01 8.69645031161646597794856461405288e-02 1.91439684123084004514769862481671e-03
 	 3.61164281855697044676389850792475e-03 9.08065831118790911524740749882767e-01 8.83225260626521180284953516093083e-02 8.43907410909563939112321140356698e-04
 	 9.90851805270955621196549145679455e-01 7.87186685618089868055058389018086e-03 1.27632787286348012290027043036389e-03 1.56335656311009926560610244772320e-05
 	 9.69552637080220991450119072396774e-01 2.61994408869951969642819733508077e-02 4.24792203278381158559895425241848e-03 9.23638794094634729692216978946817e-05
 	 9.36695848074365122748474732361501e-01 5.44721521744542247489562214468606e-02 8.83199975118065250256904619163834e-03 2.71117180685048438700673889556469e-04
 	 8.93093134981844949393803290149663e-01 9.19915494105937869839806353411404e-02 1.49153156075612636222160745091969e-02 5.80122160375680807203879751909881e-04
 	 8.39818615708710969336436846788274e-01 1.37833372302022527655651629174827e-01 2.23480119892665030079115240368992e-02 1.03099762774839565949991371240912e-03
 	 7.78184222976761708068238476698752e-01 1.90868724928162952769739035829843e-01 3.09470520950753391620224874714040e-02 1.61658363679181285230135323160994e-03
 	 7.09707651653902482635771775676403e-01 2.49791656521425126102897706914518e-01 4.05006918246723912613305174090783e-02 2.31073183150164130836290432569058e-03
 	 6.36075044879271023212652380607324e-01 3.13151269425507972066213824291481e-01 5.07736856952210047211337951011956e-02 3.07009743914139765497139933358994e-03
 	 5.59099492649031915014745663938811e-01 3.79387430360479394053641044592950e-01 6.15130769904886909316132914682385e-02 3.83777634901810759185392107895041e-03
 	 4.80676393578551852669988875277340e-01 4.46869180871532378773736127186567e-01 7.24544255499157685562749975360930e-02 4.54844616592321986797697874749247e-03
 	 4.02736786165077020882563374470919e-01 5.13934894988220536404810445674229e-01 8.33283188467024427126261798548512e-02 5.13451856777689692040711477716286e-03
 	 3.27199800763811721182605651847553e-01 5.78933193494941877865755941456882e-01 9.38670057412464009516384066955652e-02 5.53270670369558712625712715293957e-03
 	 2.55925403482102797880770594929345e-01 6.40263607010829405297158700705040e-01 1.03810989507067796822070704365615e-01 5.69036601081329002083109003251593e-03
 	 1.90668594904763288866433867951855e-01 6.96415987212049780730183101695729e-01 1.12915417883186930403383030352416e-01 5.57098430178043415444966157679119e-03
 	 1.33036188558098733558665571763413e-01 7.46007698232574734120703396911267e-01 1.20956113209326532320631031325320e-01 5.15827584289024754227170888043474e-03
 	 8.44472227842097966643564177502412e-02 7.87817681576855721736762916407315e-01 1.27735095638934481598880665842444e-01 4.45846757448724578115628602859033e-03
 	 4.60979330484310168003503349609673e-02 8.20816596856907887413967728207354e-01 1.33085470094661095785681936831679e-01 3.50054578339898921426898148467899e-03
 	 1.89318370315880724064072637702338e-02 8.44192563064521839244491729914444e-01 1.36875599903890088349101006315323e-01 2.33449320521451723908779030125515e-03
 	 3.61164281855697044676389850792475e-03 8.57375331099938575718510946899187e-01 1.39013026081504453834725154592888e-01 1.02909494738400299033986851071631e-03
 	 9.90851805270955621196549145679455e-01 7.32105005985136080004505032547968e-03 1.82714466919301800340580399506507e-03 1.80419830115715521098775780961532e-05
 	 9.69552637080220991450119072396774e-01 2.43661918802911894865736996962369e-02 6.08117103948781906330722790698928e-03 1.06592928479043688489054375612142e-04
 	 9.36695848074365122748474732361501e-01 5.06605815650823104734357116285537e-02 1.26435703605525667780895560099452e-02 3.12883937259572923912653852340782e-04
 	 8.93093134981845060416105752665317e-01 8.55546404204540617000063207342464e-02 2.13522245977008778838879266004369e-02 6.69492450353893764347645856105373e-04
 	 8.39818615708711080358739309303928e-01 1.28188781260815509721595617520506e-01 3.19926030304734099196650731755653e-02 1.18982720408979006192218275117511e-03
 	 7.78184222976761708068238476698752e-01 1.77513100207213198045153035309340e-01 4.43026768160250938866084879919072e-02 1.86562523227328577041239654477067e-03
 	 7.09707651653902482635771775676403e-01 2.32313027562279783566623336810153e-01 5.79793207838177337976048875134438e-02 2.66670991327230605047460265666359e-03
 	 6.36075044879271023212652380607324e-01 2.91239189083847938022131529578473e-01 7.26857660368810387652160898142029e-02 3.54305902747264339636146246448334e-03
 	 5.59099492649031915014745663938811e-01 3.52840618431772501395471408613957e-01 8.80598889191955835897829274472315e-02 4.42900214353208337980660758148588e-03
 	 4.80676393578551908181140106535167e-01 4.15600479928909860571906165205291e-01 1.03723126492538286758104959517368e-01 5.24915367300346404760835739011782e-03
 	 4.02736786165077076393714605728746e-01 4.77973416275315809986778958773357e-01 1.19289797559607169130657666755724e-01 5.92551302488155025305349710151859e-03
 	 3.27199800763811721182605651847553e-01 5.38423599931462382173208425228950e-01 1.34376599304725896644185922923498e-01 6.38504373931834349337188783124475e-03
 	 2.55925403482102797880770594929345e-01 5.95462550887377650710163834446575e-01 1.48612045630519551409065570624080e-01 6.56699113428593772567865016753785e-03
 	 1.90668594904763288866433867951855e-01 6.47685790170211106442366144619882e-01 1.61645614925025604691199987428263e-01 6.42921816444096041326394797010835e-03
 	 1.33036188558098622536363109247759e-01 6.93807428857465158245076963794418e-01 1.73156382584436219218559926957823e-01 5.95293020942604025197431028004758e-03
 	 8.44472227842096856420539552345872e-02 7.32691849371347680985877559578512e-01 1.82860927844442633372068485186901e-01 5.14531349627094392734649730414276e-03
 	 4.60979330484310168003503349609673e-02 7.63381737183203235019846033537760e-01 1.90520329768365748179803631501272e-01 4.03981977276320070036064180385438e-03
 	 1.89318370315880724064072637702338e-02 7.85122020896076411311526044300990e-01 1.95946142072335516282066691928776e-01 2.69413182782303819995384230878699e-03
 	 3.61164281855708146906636102357879e-03 7.97382353353162320885871849895921e-01 1.99006003828280597645061789080501e-01 1.18763140771032966319653567666137e-03
 	 9.90851805270955621196549145679455e-01 6.69908916828409160826307555680614e-03 2.44910556076028719518777876373861e-03 1.99831340893015399571425172453587e-05
 	 9.69552637080221102472421534912428e-01 2.22961584421818015400162948935758e-02 8.15120447759709598756217019399628e-03 1.18061345108345661916379731870563e-04
 	 9.36695848074365122748474732361501e-01 4.63567043589517696622337439293915e-02 1.69474475666831075892915237091074e-02 3.46547365033908103763155006404872e-04
 	 8.93093134981844949393803290149663e-01 7.82863332789095200947571129290736e-02 2.86205317392455305114395969212637e-02 7.41523667249677177412681139401229e-04
 	 8.39818615708710969336436846788274e-01 1.17298484373060452057302427419927e-01 4.28828999182285786062607257917989e-02 1.31784164452297442200745525298089e-03
 	 7.78184222976761819090540939214407e-01 1.62432448501904441728882488860108e-01 5.93833285213337391805765719254850e-02 2.06634931165773335151603085080296e-03
 	 7.09707651653902482635771775676403e-01 2.12576839916506388217243284088909e-01 7.77155084295911291469849402346881e-02 2.95362332067446034869484527973782e-03
 	 6.36075044879270912190349918091670e-01 2.66496920663189751365962365525775e-01 9.74280344575393364436877163825557e-02 3.92425952218702130819272255735086e-03
 	 5.59099492649031803992443201423157e-01 3.22864991462022354884453534396016e-01 1.18035515888945841123103264180827e-01 4.90552195173008659390134766908886e-03
 	 4.80676393578551852669988875277340e-01 3.80293079635349084988149570563110e-01 1.39030526786099062341861554159550e-01 5.81391422637422394109618650759330e-03
 	 4.02736786165077020882563374470919e-01 4.37367113941401153276444802031619e-01 1.59896099893521825840991823497461e-01 6.56304361045934817747715683822207e-03
 	 3.27199800763811721182605651847553e-01 4.92681743296619290006788105529267e-01 1.80118455939568988810606242623180e-01 7.07201559424036532014445910476752e-03
 	 2.55925403482102797880770594929345e-01 5.44874941730617901036737293907208e-01 1.99199654787279301082492111163447e-01 7.27353885188364128466798064209797e-03
 	 1.90668594904763288866433867951855e-01 5.92661547989589587714931440132204e-01 2.16669857105647123418634691915940e-01 7.12094278034717392822372517002805e-03
 	 1.33036188558098733558665571763413e-01 6.34864916034797110988563417777186e-01 2.32098895407104155452771010459401e-01 6.59341063135457199073652390097777e-03
 	 8.44472227842097966643564177502412e-02 6.70445904847874918353056727937656e-01 2.45106872367915284982586854312103e-01 5.69890180372800789904141893771339e-03
 	 4.60979330484310168003503349609673e-02 6.98528528697660466839636228542076e-01 2.55373538253908516360013436496956e-01 4.47446714498967151180108814401137e-03
 	 1.89318370315880724064072637702338e-02 7.18421863389499648633318429347128e-01 2.62646299578912278960274306882638e-01 2.98399558048100151108616984174660e-03
 	 3.61164281855685942446143599227071e-03 7.29640617487800957619015207455959e-01 2.66747739693642182956523356551770e-01 1.31540960069190466033561826009191e-03
 	 9.90851805270955621196549145679455e-01 6.02209237986816876136986209644419e-03 3.12610234917621004208099222410056e-03 2.14067379468434751616304212440411e-05
 	 9.69552637080221102472421534912428e-01 2.00429524793723917719390215097519e-02 1.04044104404065057556394435778202e-02 1.26472067148829416102437384061830e-04
 	 9.36695848074365122748474732361501e-01 4.16719869019671895760126290042535e-02 2.16321650236676876755126386342454e-02 3.71235492705902748403895552442577e-04
 	 8.93093134981844949393803290149663e-01 7.03748702612802534694935729930876e-02 3.65319947568747971367031368572498e-02 7.94350013129047744474264813874242e-04
 	 8.39818615708710858314134384272620e-01 1.05444530020194660036025879890076e-01 5.47368542710944816498397358373040e-02 1.41172503840845714635776619871876e-03
 	 7.78184222976761708068238476698752e-01 1.46017344417166461401080823634402e-01 7.57984326060718305306806996668456e-02 2.21355659345643610708131987507841e-03
 	 7.09707651653902482635771775676403e-01 1.91094242163304228743214707719744e-01 9.91981061827932886210135166038526e-02 3.16404024197656586273041945389650e-03
 	 6.36075044879270912190349918091670e-01 2.39565265496413548618193090078421e-01 1.24359689624315539191456991829909e-01 4.20382482805023091620988395789027e-03
 	 5.59099492649031915014745663938811e-01 2.90236889817017562620549142593518e-01 1.50663617533950522364705193467671e-01 5.25499265750283082315741367551709e-03
 	 4.80676393578551852669988875277340e-01 3.41861408239060193814395915978821e-01 1.77462198182387953515615208743839e-01 6.22809904258458078840643423745860e-03
 	 4.02736786165077020882563374470919e-01 3.93167652781980292431285306520294e-01 2.04095561052942686686151319008786e-01 7.03059660586600760484587979703974e-03
 	 3.27199800763811665671454420589725e-01 4.42892294381371620648479847659473e-01 2.29907904854816658168914500492974e-01 7.57582789092846667355907186447439e-03
 	 2.55925403482102853391921826187172e-01 4.89810950735193262328692753726500e-01 2.54263645782703939790536651344155e-01 7.79170771975238544287956088396641e-03
 	 1.90668594904763288866433867951855e-01 5.32768336460755165262526134029031e-01 2.76563068634481545871039998019114e-01 7.62824066295833720652286302765788e-03
 	 1.33036188558098733558665571763413e-01 5.70706715056022551024739186686929e-01 2.96257096385878715416595241549658e-01 7.06312698151305949634259917502277e-03
 	 8.44472227842096856420539552345872e-02 6.02691959052154446752069816284347e-01 3.12860818163635867605876228481065e-01 6.10489310395570094341932687598273e-03
 	 4.60979330484310168003503349609673e-02 6.27936608114769478916628031583969e-01 3.25965458836799504283021633455064e-01 4.79322939017033135267187304862091e-03
 	 1.89318370315880724064072637702338e-02 6.45819561490739602049870882183313e-01 3.35248601477672325543721854046453e-01 3.19657622975638841186785121806224e-03
 	 3.61164281855708146906636102357879e-03 6.55904570343413206856553188117687e-01 3.40483786838029711674380450858735e-01 1.40911973511947908807573348610731e-03
 	 9.90851805270955621196549145679455e-01 5.30759342292349417524732757556194e-03 3.84060130612088462820352674498281e-03 2.22759215741158403856388148245316e-05
 	 9.69552637080220991450119072396774e-01 1.76649304004555668390352707319835e-02 1.27824325193234417108456568712427e-02 1.31607247032192420073751226716752e-04
 	 9.36695848074365122748474732361501e-01 3.67277599959163897347380611790868e-02 2.65763919297184875167872064594121e-02 3.86308868804755814636842092824054e-04
 	 8.93093134981845060416105752665317e-01 6.20251525510543758046289042340504e-02 4.48817124671005637792653431006329e-02 8.26603223657892743556074854893723e-04
 	 8.39818615708710969336436846788274e-01 9.29339270665083400091432963563420e-02 6.72474572247806906544198568553838e-02 1.46904569570066351365256185346198e-03
 	 7.78184222976761819090540939214407e-01 1.28692927304159515644599309780460e-01 9.31228497190786652648597510051331e-02 2.30343423636731377962538758197297e-03
 	 7.09707651653902482635771775676403e-01 1.68421618083299168278088586703234e-01 1.21870730262798349086139637620363e-01 3.29251063205589352897439958667292e-03
 	 6.36075044879270912190349918091670e-01 2.11141734019284543766303841039189e-01 1.52783221101444544043346240869141e-01 4.37451387565456796535645622725497e-03
 	 5.59099492649031915014745663938811e-01 2.55801357785928829002841666806489e-01 1.85099149565039255982412669254700e-01 5.46836255957198168198285515018142e-03
 	 4.80676393578551852669988875277340e-01 3.01300818298094630343086919310736e-01 2.18022788123353516986924205411924e-01 6.48098024897331235344433153500177e-03
 	 4.02736786165077076393714605728746e-01 3.46519766948109875226435860895435e-01 2.50743446886813103891000764633645e-01 7.31606183998760768727454006921107e-03
 	 3.27199800763811721182605651847553e-01 3.90344763986088749696534705435624e-01 2.82455435250099529120859642716823e-01 7.88343129982614632123016917830682e-03
 	 2.55925403482102742369619363671518e-01 4.31696695535402297227989265593351e-01 3.12377900982494904891240139477304e-01 8.10807655629896921467558712492973e-03
 	 1.90668594904763288866433867951855e-01 4.69557346545204867815925808827160e-01 3.39774058550031843317640323220985e-01 7.93797220195325420322163267883298e-03
 	 1.33036188558098622536363109247759e-01 5.02994477031906361830237983667757e-01 3.63969334409995015633398907084484e-01 7.34991305536146152799226172191993e-03
 	 8.44472227842096856420539552345872e-02 5.31184790291130859429813426686451e-01 3.84367986924659454928132618078962e-01 6.35277174596938186412753424292532e-03
 	 4.60979330484310168003503349609673e-02 5.53434255240667249964303664455656e-01 4.00467811710901733235346000583377e-01 4.98785019218332941609572728225430e-03
 	 1.89318370315880724064072637702338e-02 5.69195462431385301727004843996838e-01 4.11872700537026625866587892232928e-01 3.32636768743347797580578451004385e-03
 	 3.61164281855685942446143599227071e-03 5.78083922335374422729614707350265e-01 4.18304434846068717845923856657464e-01 1.46633460857070610852681546987242e-03
 	 9.90851805270955621196549145679455e-01 4.57409736452219026908716514867592e-03 4.57409736452218853436368917186883e-03 2.25681725890340352297293996519656e-05
 	 9.69552637080220991450119072396774e-01 1.52236814598894799888118001263138e-02 1.52236814598895285610691274769124e-02 1.33333880491004724399423109204577e-04
 	 9.36695848074365122748474732361501e-01 3.16520759628174455646565377264778e-02 3.16520759628174316868687299120211e-02 3.91377083765221257631583551273025e-04
 	 8.93093134981844949393803290149663e-01 5.34534325090775114253105471107119e-02 5.34534325090775391808861627396254e-02 8.37447921159852667200018672133410e-04
 	 8.39818615708710969336436846788274e-01 8.00906921456445292095693844203197e-02 8.00906921456445014539937687914062e-02 1.48831897667812008273502399902100e-03
 	 7.78184222976761819090540939214407e-01 1.10907888511619145965880761650624e-01 1.10907888511619034943578299134970e-01 2.33365435503382406476347021850870e-03
 	 7.09707651653902482635771775676403e-01 1.45146174173048786437689727790712e-01 1.45146174173048730926538496532885e-01 3.33570703004309847272690348063406e-03
 	 6.36075044879270912190349918091670e-01 1.81962477560364543904825040954165e-01 1.81962477560364543904825040954165e-01 4.43190571534479629128844280216981e-03
 	 5.59099492649031915014745663938811e-01 2.20450253675484098003778399288421e-01 2.20450253675483986981475936772767e-01 5.54010524831589218353045112053223e-03
 	 4.80676393578551797158837644019513e-01 2.59661803210724129176156793619157e-01 2.59661803210724018153854331103503e-01 6.56600806921972968838163708937827e-03
 	 4.02736786165076965371412143213092e-01 2.98631606917461545069869544022367e-01 2.98631606917461434047567081506713e-01 7.41204559046126226773409939596604e-03
 	 3.27199800763811776693756883105380e-01 3.36400099618094194919848405334051e-01 3.36400099618094083897545942818397e-01 7.98685870644303720633505605519531e-03
 	 2.55925403482102742369619363671518e-01 3.72037298258948656570765933793155e-01 3.72037298258948545548463471277501e-01 8.21445121715098924841669258967158e-03
 	 1.90668594904763288866433867951855e-01 4.04665702547618466589085528539727e-01 4.04665702547618244544480603508418e-01 8.04211516298382507461628421197020e-03
 	 1.33036188558098789069816803021240e-01 4.33481905720950744242969676633948e-01 4.33481905720950411176062289086985e-01 7.44634091998843186677170535858750e-03
 	 8.44472227842098521755076490080683e-02 4.57776388607895212690124253640533e-01 4.57776388607894879623216866093571e-01 6.43611752289384789205151093938184e-03
 	 4.60979330484310168003503349609673e-02 4.76951033475784602622127295035170e-01 4.76951033475784380577522370003862e-01 5.05328875444776594305640315951678e-03
 	 1.89318370315880724064072637702338e-02 4.90534081484206074819098830630537e-01 4.90534081484205852774493905599229e-01 3.37000827619246849306544611124536e-03
 	 3.61164281855702595791512976575177e-03 4.98194178590721625798920513261692e-01 4.98194178590721292732013125714730e-01 1.48557232118962686921725957489571e-03
 	 9.90851805270955621196549145679455e-01 3.84060130612088549556526473338636e-03 5.30759342292349330788558958715839e-03 2.22759215741159386414606963233709e-05
 	 9.69552637080220991450119072396774e-01 1.27824325193233861996944256134157e-02 1.76649304004556223501865019898105e-02 1.31607247032192989279891781606580e-04
 	 9.36695848074365122748474732361501e-01 2.65763919297184875167872064594121e-02 3.67277599959163897347380611790868e-02 3.86308868804757495150209445355927e-04
 	 8.93093134981845060416105752665317e-01 4.48817124671006192904165743584599e-02 6.20251525510543202934776729762234e-02 8.26603223657896321423244057058355e-04
 	 8.39818615708710969336436846788274e-01 6.72474572247806906544198568553838e-02 9.29339270665083400091432963563420e-02 1.46904569570067001886559676648858e-03
 	 7.78184222976761819090540939214407e-01 9.31228497190787207760109822629602e-02 1.28692927304159460133448078522633e-01 2.30343423636732375428537444861377e-03
 	 7.09707651653902482635771775676403e-01 1.21870730262798349086139637620363e-01 1.68421618083299168278088586703234e-01 3.29251063205590784044307639533145e-03
 	 6.36075044879271023212652380607324e-01 1.52783221101444488532195009611314e-01 2.11141734019284488255152609781362e-01 4.37451387565458704731469197213301e-03
 	 5.59099492649032026037048126454465e-01 1.85099149565039200471261437996873e-01 2.55801357785928773491690435548662e-01 5.46836255957200596811151882548074e-03
 	 4.80676393578551908181140106535167e-01 2.18022788123353572498075436669751e-01 3.01300818298094574831935688052909e-01 6.48098024897334097638168515231882e-03
 	 4.02736786165076965371412143213092e-01 2.50743446886813103891000764633645e-01 3.46519766948109875226435860895435e-01 7.31606183998763977965884564014232e-03
 	 3.27199800763811721182605651847553e-01 2.82455435250099529120859642716823e-01 3.90344763986088749696534705435624e-01 7.88343129982618101569968871444871e-03
 	 2.55925403482102853391921826187172e-01 3.12377900982494904891240139477304e-01 4.31696695535402297227989265593351e-01 8.10807655629900390914510666107162e-03
 	 1.90668594904763288866433867951855e-01 3.39774058550031843317640323220985e-01 4.69557346545204867815925808827160e-01 7.93797220195328889769115221497486e-03
 	 1.33036188558098733558665571763413e-01 3.63969334409995015633398907084484e-01 5.02994477031906250807935521152103e-01 7.34991305536149362037656729285118e-03
 	 8.44472227842097966643564177502412e-02 3.84367986924659343905830155563308e-01 5.31184790291130859429813426686451e-01 6.35277174596940961970314987183883e-03
 	 4.60979330484310168003503349609673e-02 4.00467811710901733235346000583377e-01 5.53434255240667249964303664455656e-01 4.98785019218335196750091498074653e-03
 	 1.89318370315880724064072637702338e-02 4.11872700537026514844285429717274e-01 5.69195462431385412749307306512492e-01 3.32636768743349228727446131870238e-03
 	 3.61164281855697044676389850792475e-03 4.18304434846068717845923856657464e-01 5.78083922335374311707312244834611e-01 1.46633460857071239689941588579813e-03
 	 9.90851805270955621196549145679455e-01 3.12610234917621004208099222410056e-03 6.02209237986816876136986209644419e-03 2.14067379468435090429483114160547e-05
 	 9.69552637080221102472421534912428e-01 1.04044104404065612667906748356472e-02 2.00429524793723362607877902519249e-02 1.26472067148829632942871881162716e-04
 	 9.36695848074365122748474732361501e-01 2.16321650236676876755126386342454e-02 4.16719869019671895760126290042535e-02 3.71235492705903398925199043745238e-04
 	 8.93093134981844949393803290149663e-01 3.65319947568747277477640977849660e-02 7.03748702612803228584326120653714e-02 7.94350013129049045516871796479563e-04
 	 8.39818615708710969336436846788274e-01 5.47368542710943845053250811361067e-02 1.05444530020194646158238072075619e-01 1.41172503840845953160254566682852e-03
 	 7.78184222976761819090540939214407e-01 7.57984326060717750195294684090186e-02 1.46017344417166405889929592376575e-01 2.21355659345643957652827182869260e-03
 	 7.09707651653902482635771775676403e-01 9.91981061827932886210135166038526e-02 1.91094242163304228743214707719744e-01 3.16404024197657106690084738431779e-03
 	 6.36075044879270912190349918091670e-01 1.24359689624315483680305760572082e-01 2.39565265496413604129344321336248e-01 4.20382482805023785510378786511865e-03
 	 5.59099492649031915014745663938811e-01 1.50663617533950522364705193467671e-01 2.90236889817017562620549142593518e-01 5.25499265750283949677479355955256e-03
 	 4.80676393578551852669988875277340e-01 1.77462198182387953515615208743839e-01 3.41861408239060193814395915978821e-01 6.22809904258459119674729009830116e-03
 	 4.02736786165076965371412143213092e-01 2.04095561052942742197302550266613e-01 3.93167652781980236920134075262467e-01 7.03059660586601974791021163468940e-03
 	 3.27199800763811776693756883105380e-01 2.29907904854816658168914500492974e-01 4.42892294381371620648479847659473e-01 7.57582789092847881662340370212405e-03
 	 2.55925403482102742369619363671518e-01 2.54263645782703939790536651344155e-01 4.89810950735193262328692753726500e-01 7.79170771975239758594389272161607e-03
 	 1.90668594904763288866433867951855e-01 2.76563068634481545871039998019114e-01 5.32768336460755165262526134029031e-01 7.62824066295835021694893285371109e-03
 	 1.33036188558098733558665571763413e-01 2.96257096385878715416595241549658e-01 5.70706715056022551024739186686929e-01 7.06312698151307077204519302426888e-03
 	 8.44472227842097966643564177502412e-02 3.12860818163635867605876228481065e-01 6.02691959052154335729767353768693e-01 6.10489310395571135176018273682530e-03
 	 4.60979330484310168003503349609673e-02 3.25965458836799615305324095970718e-01 6.27936608114769367894325569068315e-01 4.79322939017033915892751494425283e-03
 	 1.89318370315880724064072637702338e-02 3.35248601477672325543721854046453e-01 6.45819561490739602049870882183313e-01 3.19657622975639361603827914848353e-03
 	 3.61164281855697044676389850792475e-03 3.40483786838029711674380450858735e-01 6.55904570343413317878855650633341e-01 1.40911973511948147332051295421707e-03
 	 9.90851805270955621196549145679455e-01 2.44910556076028719518777876373861e-03 6.69908916828409160826307555680614e-03 1.99831340893015907791193525033790e-05
 	 9.69552637080220991450119072396774e-01 8.15120447759715496816035340543749e-03 2.22961584421818535817205741977887e-02 1.18061345108345960071977165384283e-04
 	 9.36695848074365122748474732361501e-01 1.69474475666831145281854276163358e-02 4.63567043589517627233398400221631e-02 3.46547365033909025335001619083641e-04
 	 8.93093134981844949393803290149663e-01 2.86205317392454750002883656634367e-02 7.82863332789095756059083441869006e-02 7.41523667249679128976591613309211e-04
 	 8.39818615708710969336436846788274e-01 4.28828999182286063618363414207124e-02 1.17298484373060424301726811791013e-01 1.31784164452297789145440720659508e-03
 	 7.78184222976761708068238476698752e-01 5.93833285213338224473034188122256e-02 1.62432448501904469484458104489022e-01 2.06634931165773855568645878122425e-03
 	 7.09707651653902482635771775676403e-01 7.77155084295911569025605558636016e-02 2.12576839916506360461667668459995e-01 2.95362332067446772126961818116797e-03
 	 6.36075044879270912190349918091670e-01 9.74280344575393364436877163825557e-02 2.66496920663189751365962365525775e-01 3.92425952218703084917184042978988e-03
 	 5.59099492649031915014745663938811e-01 1.18035515888945785611952032923000e-01 3.22864991462022299373302303138189e-01 4.90552195173009960432741749514207e-03
 	 4.80676393578551852669988875277340e-01 1.39030526786099173364164016675204e-01 3.80293079635348973965847108047456e-01 5.81391422637423868624573231045360e-03
 	 4.02736786165077020882563374470919e-01 1.59896099893521936863294286013115e-01 4.37367113941401042254142339515965e-01 6.56304361045936465735017861788947e-03
 	 3.27199800763811721182605651847553e-01 1.80118455939569099832908705138834e-01 4.92681743296619178984485643013613e-01 7.07201559424038266737921887283846e-03
 	 2.55925403482102797880770594929345e-01 1.99199654787279412104794573679101e-01 5.44874941730617790014434831391554e-01 7.27353885188365949926447839857246e-03
 	 1.90668594904763288866433867951855e-01 2.16669857105647234440937154431595e-01 5.92661547989589476692628977616550e-01 7.12094278034719214282022292650254e-03
 	 1.33036188558098733558665571763413e-01 2.32098895407104266475073472975055e-01 6.34864916034796999966260955261532e-01 6.59341063135458847060954568064517e-03
 	 8.44472227842097966643564177502412e-02 2.45106872367915396004889316827757e-01 6.70445904847874807330754265422001e-01 5.69890180372802177682922675217014e-03
 	 4.60979330484310168003503349609673e-02 2.55373538253908627382315899012610e-01 6.98528528697660355817333766026422e-01 4.47446714498968278750368199325749e-03
 	 1.89318370315880724064072637702338e-02 2.62646299578912501004879231913947e-01 7.18421863389499426588713504315820e-01 2.98399558048100888366094274317675e-03
 	 3.61164281855697044676389850792475e-03 2.66747739693642182956523356551770e-01 7.29640617487800846596712744940305e-01 1.31540960069190812978257021370609e-03
 	 9.90851805270955621196549145679455e-01 1.82714466919302060549101796027571e-03 7.32105005985135819795983636026904e-03 1.80419830115715995437226243369722e-05
 	 9.69552637080220991450119072396774e-01 6.08117103948777049104990055639064e-03 2.43661918802912380588310270468355e-02 1.06592928479043959539597496988250e-04
 	 9.36695848074365233770777194877155e-01 1.26435703605525806558773638244020e-02 5.06605815650821855733454412984429e-02 3.12883937259573737064283216469107e-04
 	 8.93093134981845060416105752665317e-01 2.13522245977009611506147734871774e-02 8.55546404204539784332794738475059e-02 6.69492450353895499071121832912468e-04
 	 8.39818615708710969336436846788274e-01 3.19926030304735486975431513201329e-02 1.28188781260815481966020001891593e-01 1.18982720408979309768826571058753e-03
 	 7.78184222976761819090540939214407e-01 4.43026768160250938866084879919072e-02 1.77513100207213087022850572793686e-01 1.86562523227329054090195548099018e-03
 	 7.09707651653902482635771775676403e-01 5.79793207838178170643317344001844e-02 2.32313027562279700299896489923412e-01 2.66670991327231298936850656389197e-03
 	 6.36075044879270912190349918091670e-01 7.26857660368812052986697835876839e-02 2.91239189083847882510980298320646e-01 3.54305902747265250365971134272058e-03
 	 5.59099492649031915014745663938811e-01 8.80598889191956946120853899628855e-02 3.52840618431772390373168946098303e-01 4.42900214353209465550920143073199e-03
 	 4.80676393578551908181140106535167e-01 1.03723126492538397780407422033022e-01 4.15600479928909749549603702689637e-01 5.24915367300347792539616520457457e-03
 	 4.02736786165077020882563374470919e-01 1.19289797559607335664111360529205e-01 4.77973416275315643453325264999876e-01 5.92551302488156499820304290437889e-03
 	 3.27199800763811721182605651847553e-01 1.34376599304726118688790847954806e-01 5.38423599931462160128603500197642e-01 6.38504373931835997324490961091215e-03
 	 2.55925403482102797880770594929345e-01 1.48612045630519773453670495655388e-01 5.95462550887377428665558909415267e-01 6.56699113428595507291340993560880e-03
 	 1.90668594904763288866433867951855e-01 1.61645614925025826735804912459571e-01 6.47685790170210884397761219588574e-01 6.42921816444097689313696974977574e-03
 	 1.33036188558098733558665571763413e-01 1.73156382584436441263164851989131e-01 6.93807428857464825178169576247456e-01 5.95293020942605499712385608290788e-03
 	 8.44472227842097966643564177502412e-02 1.82860927844442855416673410218209e-01 7.32691849371347347918970172031550e-01 5.14531349627095780513430511859951e-03
 	 4.60979330484310168003503349609673e-02 1.90520329768366081246711019048234e-01 7.63381737183202901952938645990798e-01 4.03981977276321110870149766469694e-03
 	 1.89318370315880724064072637702338e-02 1.95946142072335849348974079475738e-01 7.85122020896076078244618656754028e-01 2.69413182782304513884774621601537e-03
 	 3.61164281855697044676389850792475e-03 1.99006003828280930711969176627463e-01 7.97382353353162098841266924864613e-01 1.18763140771033291580305313317467e-03
 	 9.90851805270955621196549145679455e-01 1.27632787286347665345331847674970e-03 7.87186685618090214999753584379505e-03 1.56335656311009248934252441332049e-05
 	 9.69552637080220991450119072396774e-01 4.24792203278374913555381908736308e-03 2.61994408869952594143271085158631e-02 9.23638794094630799459341718993244e-05
 	 9.36695848074365122748474732361501e-01 8.83199975118063862478123837718158e-03 5.44721521744542386267440292613173e-02 2.71117180685047246078284155501592e-04
 	 8.93093134981844949393803290149663e-01 1.49153156075611942332770354369131e-02 9.19915494105938563729196744134242e-02 5.80122160375678421959100283800126e-04
 	 8.39818615708710969336436846788274e-01 2.23480119892664752523359084079857e-02 1.37833372302022555411227244803740e-01 1.03099762774839132269122377039139e-03
 	 7.78184222976761819090540939214407e-01 3.09470520950752281397200249557500e-02 1.90868724928162952769739035829843e-01 1.61658363679180613024788382148245e-03
 	 7.09707651653902482635771775676403e-01 4.05006918246723357501792861512513e-02 2.49791656521425181614048938172346e-01 2.31073183150163176738378645325156e-03
 	 6.36075044879270912190349918091670e-01 5.07736856952209492099825638433686e-02 3.13151269425508138599667518064962e-01 3.07009743914138464454532950753674e-03
 	 5.59099492649032026037048126454465e-01 6.15130769904886354204620602104114e-02 3.79387430360479338542489813335123e-01 3.83777634901809154566176829348478e-03
 	 4.80676393578551852669988875277340e-01 7.24544255499156575339725350204390e-02 4.46869180871532489796038589702221e-01 4.54844616592320078601874300261443e-03
 	 4.02736786165077020882563374470919e-01 8.33283188467023316903237173391972e-02 5.13934894988220647427112908189883e-01 5.13451856777687523636366506707418e-03
 	 3.27199800763811721182605651847553e-01 9.38670057412462899293359441799112e-02 5.78933193494941988888058403972536e-01 5.53270670369556370749020146604380e-03
 	 2.55925403482102797880770594929345e-01 1.03810989507067685799768241849961e-01 6.40263607010829516319461163220694e-01 5.69036601081326573470242635721661e-03
 	 1.90668594904763288866433867951855e-01 1.12915417883186819381080567836761e-01 6.96415987212049891752485564211383e-01 5.57098430178041073568273588989541e-03
 	 1.33036188558098733558665571763413e-01 1.20956113209326310276026106294012e-01 7.46007698232574956165308321942575e-01 5.15827584289022499086652118194252e-03
 	 8.44472227842097966643564177502412e-02 1.27735095638934370576578203326790e-01 7.87817681576855832759065378922969e-01 4.45846757448722669919805028371229e-03
 	 4.60979330484310168003503349609673e-02 1.33085470094660873741077011800371e-01 8.20816596856908109458572653238662e-01 3.50054578339897446911943568181869e-03
 	 1.89318370315880724064072637702338e-02 1.36875599903889866304496081284015e-01 8.44192563064522061289096654945752e-01 2.33449320521450769810867242881613e-03
 	 3.61164281855697044676389850792475e-03 1.39013026081504231790120229561580e-01 8.57375331099938797763115871930495e-01 1.02909494738399843669074407159769e-03
 	 9.90851805270955621196549145679455e-01 8.10920422301865048697600002469699e-04 8.33727430674251375475325431807505e-03 1.28202766212825757977762305972469e-05
 	 9.69552637080220991450119072396774e-01 2.69893559638563484970319450440002e-03 2.77484273233933737001777330988261e-02 7.57428287177450154394470205332368e-05
 	 9.36695848074365122748474732361501e-01 5.61144915838052843470862285357725e-03 5.76927027672543488168166447849217e-02 2.22329143279375321612736926546461e-04
 	 8.93093134981845060416105752665317e-01 9.47651014164044291909760886483127e-03 9.74303548765144966647966384698520e-02 4.75728106156196757763748861336239e-04
 	 8.39818615708710969336436846788274e-01 1.41989058652185196063300054447609e-02 1.45982478426070511057233147766965e-01 8.45467700428216323467467407937193e-04
 	 7.78184222976761708068238476698752e-01 1.96623431075226562381175199334393e-02 2.02153433915715635693644003367808e-01 1.32567642559290447580588878651042e-03
 	 7.09707651653902482635771775676403e-01 2.57322893405886321538389438501326e-02 2.64560059005508885210389280473464e-01 1.89491137060379482258409833406176e-03
 	 6.36075044879271023212652380607324e-01 3.22592803316416043557524062634911e-02 3.31665674789087372431595213129185e-01 2.51762773463420561070869041486731e-03
 	 5.59099492649031803992443201423157e-01 3.90825989393321360232391725730849e-02 4.01817908411636059984317626003758e-01 3.14716140680972988191710371097543e-03
 	 4.80676393578551852669988875277340e-01 4.60342319663979981925194806535728e-02 4.73289374455050149137491644069087e-01 3.72994487758715985437074635910903e-03
 	 4.02736786165077020882563374470919e-01 5.29430070012270048707136993471067e-02 5.44320206833695974246722926181974e-01 4.21055246827755583899355329435821e-03
 	 3.27199800763811721182605651847553e-01 5.96388072017330905794096906902269e-02 6.13161392034455188237984657462221e-01 4.53708591370186476582349044406328e-03
 	 2.55925403482102797880770594929345e-01 6.59567602028310329131954858894460e-02 6.78117836315066169206033919181209e-01 4.66637413731399441907399250339950e-03
 	 1.90668594904763288866433867951855e-01 7.17412980637928132665592784178443e-02 7.37590107031443897867006853630301e-01 4.56847538731431929842630168536743e-03
 	 1.33036188558098733558665571763413e-01 7.68499885406724869696404311980586e-02 7.90113822901228779471693997038528e-01 4.23003457785562590048877851245379e-03
 	 8.44472227842097966643564177502412e-02 8.11570442835369831868774781469256e-02 8.34395732932253220148766104102833e-01 3.65615809986655389274279315259264e-03
 	 4.60979330484310168003503349609673e-02 8.45564277847190570724933422752656e-02 8.69345639166849926127156322763767e-01 2.87061610432365809861265937286134e-03
 	 1.89318370315880724064072637702338e-02 8.69645031161645487571831836248748e-02 8.94103659852247378836409552604891e-01 1.91439684123083614201987767700075e-03
 	 3.61164281855697044676389850792475e-03 8.83225260626520070061928890936542e-02 9.08065831118791022547043212398421e-01 8.43907410909562204388845163549604e-04
 	 9.90851805270955621196549145679455e-01 4.42974326044993579887254497862159e-04 8.70522040299938522356359982268259e-03 9.67504566497260151550566242839579e-06
 	 9.69552637080220991450119072396774e-01 1.47432367463884439473531529074535e-03 2.89730392451401641551456123124808e-02 5.71606485792869109118126413893179e-05
 	 9.36695848074365122748474732361501e-01 3.06531669533419148798714104486862e-03 6.02388352303006857635381265936303e-02 1.67784571068560608769412723084713e-04
 	 8.93093134981844949393803290149663e-01 5.17664937002791647469024383099168e-03 1.01730215648127134131506466019346e-01 3.59016524146705238735438614483542e-04
 	 8.39818615708710969336436846788274e-01 7.75631070970872471548318571876734e-03 1.52425073581580305948079967492959e-01 6.38046966656170659593083627214583e-04
 	 7.78184222976761708068238476698752e-01 1.07407742448962506554011042680941e-02 2.11075002778342041276360419033153e-01 1.00044486819394823004514272213328e-03
 	 7.09707651653902482635771775676403e-01 1.40565500815551525093383133935276e-02 2.76235798264542364854889910930069e-01 1.43002796142735759572783837967336e-03
 	 6.36075044879270912190349918091670e-01 1.76219917153424554534524304472143e-02 3.46302963405386632356197651461116e-01 1.89997174160432425599198680288282e-03
 	 5.59099492649031915014745663938811e-01 2.13493056150864113362786156358197e-02 4.19551201735881673648975720425369e-01 2.37506032244079283433091376309676e-03
 	 4.80676393578551852669988875277340e-01 2.51467126976895327672423263720702e-02 4.94176893723758614562768798350589e-01 2.81486804727588838317964281543482e-03
 	 4.02736786165077020882563374470919e-01 2.89207081239764018931737155071460e-02 5.68342505710946577224262910021935e-01 3.17756695964903313963989539558952e-03
 	 3.27199800763811721182605651847553e-01 3.25783636713995461420267929497641e-02 6.40221835564788732675367555202683e-01 3.42399112731297302486543898680793e-03
 	 2.55925403482102797880770594929345e-01 3.60296159714723618350262768217362e-02 7.08044980546424840284203128248919e-01 3.52156074334715506538029394789646e-03
 	 1.90668594904763288866433867951855e-01 3.91894843012989824160285934340209e-02 7.70141920793937728717537538614124e-01 3.44767974180790453403444573154957e-03
 	 1.33036188558098733558665571763413e-01 4.19801634588721217511420036316849e-02 8.24983647983029144690192424604902e-01 3.19226947390718234290329924363050e-03
 	 8.44472227842097966643564177502412e-02 4.43329407012035270341243631264661e-02 8.71219836514586676301519219123293e-01 2.75918356674502863318254597402301e-03
 	 4.60979330484310168003503349609673e-02 4.61898918569410010803721888805740e-02 9.07712175094627982119277476158459e-01 2.16636057991380706622130958294292e-03
 	 1.89318370315880724064072637702338e-02 4.75053298674731339090726578433532e-02 9.33562833100938793684520078386413e-01 1.44473301215981581729908000966134e-03
 	 3.61164281855697044676389850792475e-03 4.82471650499763926589480433904100e-02 9.48141192131466636894288058101665e-01 6.36869466919659813972098838519287e-04
 	 9.90851805270955621196549145679455e-01 1.82011786449540191590301674295915e-04 8.96618294259483861186055264624883e-03 6.27970978164217887674625542815399e-06
 	 9.69552637080221102472421534912428e-01 6.05778416599728197766694393067155e-04 2.98415845031791693298117706945050e-02 3.71008361550069894413753091022556e-05
 	 9.36695848074365122748474732361501e-01 1.25949459132922852999669771634217e-03 6.20446573343056487215285699221567e-02 1.08902681044954137185194753545403e-04
 	 8.93093134981844949393803290149663e-01 2.12701085427233205216168698825641e-03 1.04779854163882718554035022862081e-01 2.33024179577515723514949397277007e-04
 	 8.39818615708710969336436846788274e-01 3.18695663727563971434619816136546e-03 1.56994427654013390949216955050360e-01 4.14132389283066284016432412329323e-04
 	 7.78184222976761819090540939214407e-01 4.41322982670155905537967555574141e-03 2.17402547196536621854079385229852e-01 6.49351294282397438657750132762203e-04
 	 7.09707651653902482635771775676403e-01 5.77563448090540054735697594878729e-03 2.84516713865192116816871248374810e-01 9.28177590924335262252686806760948e-04
 	 6.36075044879270912190349918091670e-01 7.24062322425139681669747915293556e-03 3.56684331896477690992952602755395e-01 1.23320049783250205305273894396123e-03
 	 5.59099492649032026037048126454465e-01 8.77212295609292036502324663160834e-03 4.32128384394875053597928626913927e-01 1.54156270216052873264778177997414e-03
 	 4.80676393578551852669988875277340e-01 1.03324229697567826491422238177620e-02 5.08991183451691364680868900904898e-01 1.82702542423198734632128203969614e-03
 	 4.02736786165077020882563374470919e-01 1.18831034701908366812972417392302e-02 5.85380110364732142436139383789850e-01 2.06243970409079619560133167510685e-03
 	 3.27199800763811721182605651847553e-01 1.33859815858311526071133812365588e-02 6.59414217650357126210280966915889e-01 2.22238440199694874122027243856792e-03
 	 2.55925403482102797880770594929345e-01 1.48040515724888743775977673067246e-02 7.29270544945408327741631637763930e-01 2.28571318548984438526194828966709e-03
 	 1.90668594904763288866433867951855e-01 1.61023960720269032620421967294533e-02 7.93229009023209807871523935318692e-01 2.23775979445591530550552228362449e-03
 	 1.33036188558098733558665571763413e-01 1.72490460447519700082352755998727e-02 8.49714765397149296433099152636714e-01 2.07198255544248496548553895024725e-03
 	 8.44472227842097966643564177502412e-02 1.82157684117522089550789132772479e-02 8.97337008804037994380564668972511e-01 1.79088271347029167820941175648386e-03
 	 4.60979330484310168003503349609673e-02 1.89787629632038878924049640772864e-02 9.34923303988365095307244700961746e-01 1.40610351571785396548874835787046e-03
 	 1.89318370315880724064072637702338e-02 1.95192575431003545460839632141870e-02 9.61548905425311573047508773015579e-01 9.37722088606499299193175467337369e-04
 	 3.61164281855697044676389850792475e-03 1.98240669617951725811622054607142e-02 9.76564290219647856972073896031361e-01 4.13368118304995469519669271107887e-04
 	 9.90851805270955621196549145679455e-01 3.47318355634652908836557116956101e-05 9.11346289348091351256719860884914e-03 2.72713356304095319254210232073898e-06
 	 9.69552637080220991450119072396774e-01 1.15595790600466624686859518078563e-04 3.03317671291785419251940680851476e-02 1.61120400485679750529968701222572e-05
 	 9.36695848074365122748474732361501e-01 2.40339155460386755258639368548756e-04 6.30638127701744904962666282699502e-02 4.72939302786016927977047474840333e-05
 	 8.93093134981844949393803290149663e-01 4.05880260137839177225771436496871e-04 1.06500984758017211428970938413840e-01 1.01197043051843354132500463204991e-04
 	 8.39818615708710969336436846788274e-01 6.08141132137252071743205306120217e-04 1.59573243159151778591819947905606e-01 1.79848174139800591649074323896684e-04
 	 7.78184222976761708068238476698752e-01 8.42140916447020604351791916997172e-04 2.20973636106791271327409731384250e-01 2.81998335977003914548655316707482e-04
 	 7.09707651653902482635771775676403e-01 1.10211756600220311952398333232850e-03 2.89190230780095314244704240991268e-01 4.03086185299842184558138935557281e-04
 	 6.36075044879270912190349918091670e-01 1.38166950672408139766389467695262e-03 3.62543285614005006411986187231378e-01 5.35550620098618483828911696065234e-04
 	 5.59099492649031803992443201423157e-01 1.67391320087934003524310355714988e-03 4.39226594150088855972313695019693e-01 6.69465234983311835784136611948725e-04
 	 4.80676393578551852669988875277340e-01 1.97165261963538895884084922727197e-03 5.17351953801812758371170275495388e-01 7.93435131272774655381008201970872e-04
 	 4.02736786165077020882563374470919e-01 2.26755642456555328578815533546731e-03 5.94995657410357425831648470193613e-01 8.95670139919015821476644401144540e-04
 	 3.27199800763811721182605651847553e-01 2.55433848743380487178455950925127e-03 6.70245860748754473945609788643196e-01 9.65130444464530850949557372331356e-04
 	 2.55925403482102797880770594929345e-01 2.82493730169108836491886904696003e-03 7.41249659216206113754310536023695e-01 9.92632678958696576185238846790071e-04
 	 1.90668594904763288866433867951855e-01 3.07268987058961773328746858169325e-03 8.06258715224647093400278663466452e-01 9.71807623868959952369295240970359e-04
 	 1.33036188558098733558665571763413e-01 3.29149580111964823458947648759931e-03 8.63672315640781618206744951748988e-01 8.99814380833521159676335887667165e-04
 	 8.44472227842097966643564177502412e-02 3.47596760341961630302876073983498e-03 9.12076809612370587032614821509924e-01 7.77739183051465859941586700188054e-04
 	 4.60979330484310168003503349609673e-02 3.62156367614530072529532844782807e-03 9.50280503275423682474354336591205e-01 6.10638425048564098367165353664632e-04
 	 1.89318370315880724064072637702338e-02 3.72470188075335606470162019832060e-03 9.77343461087658571528891116031446e-01 4.07231141177817406676814337984638e-04
 	 3.61164281855697044676389850792475e-03 3.78286619425638459546235026209615e-03 9.92605490987186644957773751229979e-01 1.79516268827607967939474775675990e-04
 	 ];
 
 	 case  38 

 	 % ALG. DEG.:   38
 	 % PTS CARD.:  400
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 9.91699955792932685838536599476356e-01 8.27152774180316303909155095652750e-03 2.85164652641511223718495671164419e-05 2.03233773672144092916811396187793e-06
 	 9.72356946647436659603158659592737e-01 2.75480801028966520993535027628241e-02 9.49732496666882974878376444394235e-05 1.20314638074630005147667294318481e-05
 	 9.42465542363186470353753065865021e-01 5.73367864772681701257539543803432e-02 1.97671159545359520492979754635599e-04 3.54298287724655680346573516370512e-05
 	 9.02695871793453896714254369726405e-01 9.69698203736200636804198893514695e-02 3.34307832926039605325740922125988e-04 7.61492123150434680693005029539222e-05
 	 8.53936753035890561136511678341776e-01 1.45561417407001070234429107586038e-01 5.01829557108368629059214072185569e-04 1.36115198088923838306771307848919e-04
 	 7.97277508336594831206411981838755e-01 2.02025997916197463943888124049408e-01 6.96493747207704849699894111836329e-04 2.14962155601885020802382930682484e-04
 	 7.33983858235659480939716559078079e-01 2.65102189997691861655937373143388e-01 9.13951766648657404346067778533325e-04 3.09954861638473658409786981593470e-04
 	 6.65469698905513773468101135222241e-01 3.33380955202710660412179777267738e-01 1.14934589177556611971908751002047e-03 4.16136135465475101927190770823017e-04
 	 5.93265533483506524170536522433395e-01 4.05337048744157768531692909164121e-01 1.39741777233570729777056840248406e-03 5.26689494289153659588309519534732e-04
 	 5.18984288703573826140313940413762e-01 4.79363085421133983121677601957344e-01 1.65262587529219073800845762889367e-03 6.33486342735167340216306808287072e-04
 	 4.44285286963011172289839123550337e-01 5.53805443770980287965244315273594e-01 1.90926926600853974491656117606908e-03 7.27770382842145876871320364642770e-04
 	 3.70837180584396741700459187995875e-01 6.27001204460583050348532196949236e-01 2.16161495502020795100861505488865e-03 8.00919278234454769943573282375837e-04
 	 3.00280676835950277592246493441053e-01 6.97315297200352568474102099571610e-01 2.40402596369715393365140698733740e-03 8.45216263373066282495182921508103e-04
 	 2.34191886313592112500714392808732e-01 7.63177026438184968881728309497703e-01 2.63108724822291861755729769356549e-03 8.54563020888123936816271886129925e-04
 	 1.74047112635542067238247909699567e-01 8.23115160692803216058166526636342e-01 2.83772667165471670358556366409175e-03 8.25069894877062748675400349895881e-04
 	 1.21189867323676092603079723630799e-01 8.75790804345414453102591778588248e-01 3.01932833090945429432849778095260e-03 7.55469977090494275266674417679269e-04
 	 7.68008370896219316747988159477245e-02 9.20027327170207076534325096872635e-01 3.17183574017099179087608717964031e-03 6.47318986848269576836467642522166e-04
 	 4.18714311177650344575340568553656e-02 9.54836726167734295422917512041749e-01 3.29184271450067011954843110288493e-03 5.04962537862918233767806075462659e-04
 	 1.71812181452557499738986734882928e-02 9.79442110965473844430562166962773e-01 3.37667088927040559553915954893455e-03 3.35282088027186728814571514689646e-04
 	 3.27610666905009395577508257701993e-03 9.93299448644515026174417471338529e-01 3.42444468643487986980744608445093e-03 1.47444109081593143547456170594501e-04
 	 9.91699955792932685838536599476356e-01 8.15052690892288309032487347849383e-03 1.49517298144431071138527045150113e-04 4.68467040442822599320780302400991e-06
 	 9.72356946647436659603158659592737e-01 2.71450903843399524162371960755991e-02 4.97962968223387980604144331664429e-04 2.77333050517954493650700509288498e-05
 	 9.42465542363186470353753065865021e-01 5.64980298249310661229394270321791e-02 1.03642781188246352330750710279972e-03 8.16680551098178370396721281743169e-05
 	 9.02695871793453896714254369726405e-01 9.55512881029537686217167902213987e-02 1.75284010359233466402884005219676e-03 1.75528877315582070061175667952114e-04
 	 8.53936753035890450114209215826122e-01 1.43432058322285976847965116576233e-01 2.63118864182357303782566759764450e-03 3.13754366982689210201218354967523e-04
 	 7.97277508336594720184109519323101e-01 1.99070641327379366236627333819342e-01 3.65185033602591357926314685755642e-03 4.95501722093089503468066325808650e-04
 	 7.33983858235659369917414096562425e-01 2.61224117313973325238407596771140e-01 4.79202445036730484417830666643567e-03 7.14466075588805803533998250998138e-04
 	 6.65469698905513773468101135222241e-01 3.28504060086699412046584711788455e-01 6.02624100778681448531415298930369e-03 9.59220804103705923862599469487122e-04
 	 5.93265533483506635192838984949049e-01 3.99407537047375804650783948090975e-01 7.32692946911756015637706695997622e-03 1.21405347233280880986372451957322e-03
 	 5.18984288703573826140313940413762e-01 4.72350676782899270289561854951899e-01 8.66503451352690357012420463433955e-03 1.46022714030216022029762257261609e-03
 	 4.44285286963011172289839123550337e-01 5.45704047989973739518632100953255e-01 1.00106650470150881915287754964083e-02 1.67755797282983739639183884406748e-03
 	 3.70837180584396741700459187995875e-01 6.17829057509634127498543421097565e-01 1.13337619059691308009973909065593e-02 1.84617092488463399937992370780648e-03
 	 3.00280676835950277592246493441053e-01 6.87114553834047958602582184539642e-01 1.26047693300017638051713220193051e-02 1.94827835099532341994743589452810e-03
 	 2.34191886313592112500714392808732e-01 7.52012818480878975080372583761346e-01 1.37952952055289124189130234299228e-02 1.96982323377587614787742609223642e-03
 	 1.74047112635542067238247909699567e-01 8.11074142018965882350300944381161e-01 1.48787453454920504114511459192727e-02 1.90183966388902340322042405773573e-03
 	 1.21189867323676092603079723630799e-01 8.62979214991839382875582487031352e-01 1.58309176844845245213377893378492e-02 1.74140733558351165459476828090146e-03
 	 7.68008370896219316747988159477245e-02 9.06568619621225812998943638376659e-01 1.66305432891522553262575456756167e-02 1.49211228287505571002413695680389e-03
 	 4.18714311177650344575340568553656e-02 9.40868806003836044560273421666352e-01 1.72597628783989209821925214782823e-02 1.16397142744961777476031539180212e-03
 	 1.71812181452557499738986734882928e-02 9.65114248582096601047908279724652e-01 1.77045332726476489781930467870552e-02 7.72846976433004431532303168950193e-04
 	 3.27610666905009395577508257701993e-03 9.78768872874565598607432548305951e-01 1.79550204563843074367923691170290e-02 3.39868242192906686374720415244610e-04
 	 9.91699955792932685838536599476356e-01 7.93581514438099384911584621704606e-03 3.64229062686320312347554306597885e-04 7.23122046339593931897366668737348e-06
 	 9.72356946647436659603158659592737e-01 2.64299991613798739009677518652097e-02 1.21305419118346649587358854205377e-03 4.28089119820633884024897730657955e-05
 	 9.42465542363186470353753065865021e-01 5.50096853519411177479980779025936e-02 2.52477228487241189824885623238515e-03 1.26062168804368893593875755598788e-04
 	 9.02695871793453896714254369726405e-01 9.30341519837691866001705420785584e-02 4.26997622277691668557508819503710e-03 2.70944997189460033953228856873352e-04
 	 8.53936753035890561136511678341776e-01 1.39653584773473060653969923805562e-01 6.40966219063637820951839785266202e-03 4.84308778022127868652380033864802e-04
 	 7.97277508336594720184109519323101e-01 1.93826463969827916811183854406408e-01 8.89602769357736300470662627049023e-03 7.64852568722985699106731161123207e-04
 	 7.33983858235659369917414096562425e-01 2.54342612376178722755071248684544e-01 1.16735293881619073275146547530312e-02 1.10284422599214639720832664693262e-03
 	 6.65469698905513773468101135222241e-01 3.19850179523079369836580099217827e-01 1.46801215714068566953187655599322e-02 1.48064570369629247732767840517454e-03
 	 5.93265533483506524170536522433395e-01 3.88885825014637420693475178268272e-01 1.78486415018560551359882992983330e-02 1.87400341003529148121986569464070e-03
 	 5.18984288703573826140313940413762e-01 4.59907401835413121027329452772392e-01 2.11083094610130528323566068138462e-02 2.25399515154319374926616958987324e-03
 	 4.44285286963011172289839123550337e-01 5.31328403277567917761814442201285e-01 2.43863097594209099483464342483785e-02 2.58946531866860755674575322871078e-03
 	 3.70837180584396741700459187995875e-01 6.01553402131094094862362453568494e-01 2.76094172845091634371783584356308e-02 2.84973494791289968380842978490364e-03
 	 3.00280676835950277592246493441053e-01 6.69013689933505628637533391156467e-01 3.07056332305440937702201154024806e-02 3.00734716935293191000799772893970e-03
 	 2.34191886313592112500714392808732e-01 7.32202320212677171262782849225914e-01 3.36057934737307162365027579653542e-02 3.04060368129386443536432693690585e-03
 	 1.74047112635542067238247909699567e-01 7.89707773665952905695064600877231e-01 3.62451136985050270666874894232024e-02 2.93566477646166378370762295446639e-03
 	 1.21189867323676092603079723630799e-01 8.40245495799890940169518671609694e-01 3.85646368764329672274016047595069e-02 2.68802269382198552247209555332574e-03
 	 7.68008370896219316747988159477245e-02 8.82686611725014613760720294521889e-01 4.05125511853634545644808895303868e-02 2.30321280733248321195838492769781e-03
 	 4.18714311177650344575340568553656e-02 9.16083218053890813159512163110776e-01 4.20453508283441523829537800338585e-02 1.79669715867858642392718149238817e-03
 	 1.71812181452557499738986734882928e-02 9.39689955697335599360542346403236e-01 4.31288261574086506655589801084716e-02 1.19296052626740234012259200824246e-03
 	 3.27610666905009395577508257701993e-03 9.52984872144072125976776987954509e-01 4.37390211868777800674479294684716e-02 5.24617950812639351199084813970330e-04
 	 9.91699955792932796860839061992010e-01 7.63237608404604243872437763229755e-03 6.67668123021160700436560375692352e-04 9.60862926649655767826364166639408e-06
 	 9.72356946647436770625461122108391e-01 2.54194042868431079040814069003318e-02 2.22364906572012147045747099127766e-03 5.68832006464034065237010684423780e-05
 	 9.42465542363186470353753065865021e-01 5.29062987522251129690609161571047e-02 4.62815888458841667718601797787414e-03 1.67507635910583556901679025408214e-04
 	 9.02695871793453896714254369726405e-01 8.94768368065120001109136183004011e-02 7.82729140003410317483201197319431e-03 3.60023600826969562317680928487107e-04
 	 8.53936753035890561136511678341776e-01 1.34313698225576955147531066359079e-01 1.17495487385324837159572552991449e-02 6.43535005201486686073064635849050e-04
 	 7.97277508336594831206411981838755e-01 1.86415187494128387069025620803586e-01 1.63073041692767817245623973576585e-02 1.01631319548172263135532578104403e-03
 	 7.33983858235659369917414096562425e-01 2.44617400548732044640587446338031e-01 2.13987412156085854419984570995439e-02 1.46542639100763656678783064535310e-03
 	 6.65469698905513773468101135222241e-01 3.07620177165833286192508921885747e-01 2.69101239286529403393899428920122e-02 1.96743768411774969454008932245870e-03
 	 5.93265533483506635192838984949049e-01 3.74016130197769525178586036417983e-01 3.27183363187238396285749786329689e-02 2.49011962812196660510544177213887e-03
 	 5.18984288703573826140313940413762e-01 4.42322079179196969711540532443905e-01 3.86936321172292041481455271423329e-02 2.99504127820330581441488071448020e-03
 	 4.44285286963011172289839123550337e-01 5.11012180118820102947552186378743e-01 4.47025329181687247626086900709197e-02 3.44080399311352987112844203920758e-03
 	 3.70837180584396741700459187995875e-01 5.78552009613376827523723022750346e-01 5.06108098022264307758177892537788e-02 3.78664248460967552481482023551962e-03
 	 3.00280676835950277592246493441053e-01 6.43432841371479824488233134616166e-01 5.62864817925698979195203719427809e-02 3.99607288593020401612498915255856e-03
 	 2.34191886313592112500714392808732e-01 7.04205349519915868583552764903288e-01 6.16027641664920189157328422879800e-02 4.04026314337772342322185892271591e-03
 	 1.74047112635542067238247909699567e-01 7.59511986538769945376259329350432e-01 6.64409008256879873854927609500010e-02 3.90082346825388562999714636703175e-03
 	 1.21189867323676092603079723630799e-01 8.08117315007181535868596711225109e-01 7.06928176691423715283235651440918e-02 3.57176408264772357603611396825727e-03
 	 7.68008370896219316747988159477245e-02 8.48935624440270819590637074725237e-01 7.42635384701072487345641093270388e-02 3.06044022575845033745656209589470e-03
 	 4.18714311177650344575340568553656e-02 8.81055256109525952723515729303472e-01 7.70733127727090128189502138411626e-02 2.38739739568150522580625150226297e-03
 	 1.71812181452557499738986734882928e-02 9.03759350967349495142855175799923e-01 7.90594308873947548832461507117841e-02 1.58517023294916310945101844964711e-03
 	 3.27610666905009395577508257701993e-03 9.16545914222834379181392705504550e-01 8.01779791081155268628322119184304e-02 6.97096627246305807282245048384084e-04
 	 9.91699955792932796860839061992010e-01 7.24731601191564833025493541640571e-03 1.05272819515155480890600259158418e-03 1.17608916231588459108334254743511e-05
 	 9.72356946647436659603158659592737e-01 2.41369730307807520142127089002315e-02 3.50608032178258838262863150703197e-03 6.96246196440749383523016735608735e-05
 	 9.42465542363186470353753065865021e-01 5.02371295460236760854755289074092e-02 7.29732809078985356077140522756963e-03 2.05028115598659987396656934066641e-04
 	 9.02695871793453896714254369726405e-01 8.49626518586902995666676474684209e-02 1.23414763478558037190779828051745e-02 4.40666242152689378603486192176319e-04
 	 8.53936753035890561136511678341776e-01 1.27537454267296568310996462969342e-01 1.85257926968128705524918586888816e-02 7.87682118017989422141533761845267e-04
 	 7.97277508336594720184109519323101e-01 1.77010377674453239782437208305055e-01 2.57121139889520400334532723718439e-02 1.24395988394762277429173025211639e-03
 	 7.33983858235659480939716559078079e-01 2.32276237998247314653355033442494e-01 3.37399037660932044069284074794268e-02 1.79367113542945925096228076967009e-03
 	 6.65469698905513773468101135222241e-01 2.92100469239511217889315730644739e-01 4.24298318549750086425831341330195e-02 2.40812926968762310020455430503716e-03
 	 5.93265533483506635192838984949049e-01 3.55146688167400192970291072924738e-01 5.15877783490931718368699421262136e-02 3.04788812876336055041059935888370e-03
 	 5.18984288703573826140313940413762e-01 4.20006542072786703823084053510684e-01 6.10091692236394700366020060755545e-02 3.66590851857057043947096808267361e-03
 	 4.44285286963011172289839123550337e-01 4.85231167132920138129748011124320e-01 7.04835459040686895804128653253429e-02 4.21151880639632908431835289775336e-03
 	 3.70837180584396741700459187995875e-01 5.49363552951947053948345001117559e-01 7.97992664636562043511958108865656e-02 4.63482257895263434488430931423864e-03
 	 3.00280676835950277592246493441053e-01 6.10971089804040690118824841192691e-01 8.87482333600090322889286653662566e-02 4.89116385138716434910488572995746e-03
 	 2.34191886313592112500714392808732e-01 6.68677571578318308276323023164878e-01 9.71305421080895792229625840263907e-02 4.94525240181671599248858228747849e-03
 	 1.74047112635542067238247909699567e-01 7.21193940218719964363458529987838e-01 1.04758947145737968398293560312595e-01 4.77457926399277397117026922046534e-03
 	 1.21189867323676092603079723630799e-01 7.67347087206571409900845992524410e-01 1.11463045469752497496074283844791e-01 4.37181299376197558120837882711385e-03
 	 7.68008370896219316747988159477245e-02 8.06106077103847962206373267690651e-01 1.17093085806530106118827916361624e-01 3.74595634986182217732175736557565e-03
 	 4.18714311177650344575340568553656e-02 8.36605245165024657971741817164002e-01 1.21523323717210307570724125980632e-01 2.92215687100387706831572387500273e-03
 	 1.71812181452557499738986734882928e-02 8.58163898510619249648812001396436e-01 1.24654883344125000377289325115271e-01 1.94023671815262734041684922203785e-03
 	 3.27610666905009395577508257701993e-03 8.70305368427510828155391209293157e-01 1.26418524903439077888833708129823e-01 8.53241149858895825928983835950703e-04
 	 9.91699955792932796860839061992010e-01 6.78965893758258932227933613035020e-03 1.51038526948461381688160187763970e-03 1.36375105154570009616428472032368e-05
 	 9.72356946647436770625461122108391e-01 2.26127595919903001675521636570920e-02 5.03029376057292920698671423451742e-03 8.07342260225453147619648075483667e-05
 	 9.42465542363186470353753065865021e-01 4.70647305926562703470850124176650e-02 1.04697270441572592991619217173138e-02 2.37743291242918945629231108895851e-04
 	 9.02695871793453896714254369726405e-01 7.95973885511022383187906825696700e-02 1.77067396554438649669549477039254e-02 5.10980859591503733946327159287648e-04
 	 8.53936753035890450114209215826122e-01 1.19483656407248672870480277197203e-01 2.65795905568608770153105069766752e-02 9.13368094146469497278395532902096e-04
 	 7.97277508336594720184109519323101e-01 1.65832439325982211597576565509371e-01 3.68900523374230682183139151675277e-02 1.44245151997973220826809725991779e-03
 	 7.33983858235659480939716559078079e-01 2.17608343933107933887427520858182e-01 4.84077978312325851728559200637392e-02 2.07987708368329807934182795747802e-03
 	 6.65469698905513773468101135222241e-01 2.73654765210091799332303708069958e-01 6.08755358843944271995951567078009e-02 2.79238082368486696324683116188226e-03
 	 5.93265533483506413148234059917741e-01 3.32719710511322375179332766492735e-01 7.40147560051712116724331735895248e-02 3.53422238192369541839865654253572e-03
 	 5.18984288703573826140313940413762e-01 3.93483762476900422733194773172727e-01 8.75319488195257511264912864135113e-02 4.25085678642464579596316198717432e-03
 	 4.44285286963011227800990354808164e-01 4.54589550849022361322937513250508e-01 1.01125162187966466387223363199155e-01 4.88352701891904203423955266316625e-03
 	 3.70837180584396741700459187995875e-01 5.14672073240584726505630897008814e-01 1.14490746175018531793909914995311e-01 5.37437497793787685024247124943031e-03
 	 3.00280676835950277592246493441053e-01 5.72389187069004767849378367827740e-01 1.27330136095044954558375138731208e-01 5.67161917594474502407608795806482e-03
 	 2.34191886313592112500714392808732e-01 6.26451591563438658916140866494970e-01 1.39356522122969228583144740696298e-01 5.73433833014529333038655778409520e-03
 	 1.74047112635542067238247909699567e-01 6.75651630739657171886847208952531e-01 1.50301256624800760874904881347902e-01 5.53643184598071047552991785778431e-03
 	 1.21189867323676092603079723630799e-01 7.18890276112428505683737967046909e-01 1.59919856563895401713182309322292e-01 5.06939844226088082851378047166691e-03
 	 7.68008370896219316747988159477245e-02 7.55201694261580902534092274436262e-01 1.67997468648797165791108909616014e-01 4.34367739696614203054325642483491e-03
 	 4.18714311177650344575340568553656e-02 7.83774885864504500254668073466746e-01 1.74353683017730465287797869677888e-01 3.38842889918806837445952595544441e-03
 	 1.71812181452557499738986734882928e-02 8.03972142770302156122852466069162e-01 1.78846639084442093903248860442545e-01 2.24982930666402757002853007861631e-03
 	 3.27610666905009395577508257701993e-03 8.15346897176081553126891776628327e-01 1.81376996154868352917333140794653e-01 9.89388009537323738148972829264949e-04
 	 9.91699955792932685838536599476356e-01 6.27013145359552048763163156763767e-03 2.02991275347179367383176895600627e-03 1.51944862576347524888006543242192e-05
 	 9.72356946647436770625461122108391e-01 2.08824885717770261650549912246788e-02 6.76056478078620320948388666693063e-03 8.99515411137510629158847708097824e-05
 	 9.42465542363186470353753065865021e-01 4.34634567592996692853013485091651e-02 1.40710008775138603609455856258137e-02 2.64886114481161622467852989615267e-04
 	 9.02695871793453896714254369726405e-01 7.35067982304316164254842647096666e-02 2.37973299761144868602613655639288e-02 5.69318838667624469405958986811811e-04
 	 8.53936753035890450114209215826122e-01 1.10341070017933695623923995299265e-01 3.57221769461758542618667888746131e-02 1.01764606809584632479692700712803e-03
 	 7.97277508336594720184109519323101e-01 1.53143361603745309373891814175295e-01 4.95791300596599704419986665016040e-02 1.60713421799344737504744440315108e-03
 	 7.33983858235659480939716559078079e-01 2.00957505289007742899087816113024e-01 6.50586364753327761611956248088973e-02 2.31733377802175030332754168682641e-03
 	 6.65469698905513773468101135222241e-01 2.52715396538166992002061306266114e-01 8.18149045563192345298375585116446e-02 3.11118308605320362941748513208040e-03
 	 5.93265533483506524170536522433395e-01 3.07260842007921808338721803011140e-01 9.94736245085716674907416745554656e-02 3.93771967051460142217322868418705e-03
 	 5.18984288703573826140313940413762e-01 3.63375382808838021109210103531950e-01 1.17640328487588152750475956054288e-01 4.73617123530689198424026287170818e-03
 	 4.44285286963011227800990354808164e-01 4.19805511213079796117852993120323e-01 1.35909201823909031592307883329340e-01 5.44107255452897647929333402316843e-03
 	 3.70837180584396686189307956738048e-01 4.75290671354691107719503406769945e-01 1.53872148060912261602339867749834e-01 5.98795994716904127902479260114887e-03
 	 3.00280676835950277592246493441053e-01 5.28591417997964940767019470513333e-01 1.71127905166084781640734036045615e-01 6.31914010476877091582181833473442e-03
 	 2.34191886313592112500714392808732e-01 5.78517104397500703250045717140893e-01 1.87291009288907184249239890050376e-01 6.38901981818938181911793350309381e-03
 	 1.74047112635542067238247909699567e-01 6.23952481342483933346443336631637e-01 2.02000406021973999415308753668796e-01 6.16851862403614784741145982138733e-03
 	 1.21189867323676092603079723630799e-01 6.63882615220343086370746732427506e-01 2.14927517455980821026173543941695e-01 5.64816466158572609568278011238363e-03
 	 7.68008370896219316747988159477245e-02 6.97415575734958159692666868068045e-01 2.25783587175419908632534315984230e-01 4.83958904676885272311270824729945e-03
 	 4.18714311177650344575340568553656e-02 7.23802419175269440287934230582323e-01 2.34326149706965525254531712562311e-01 3.77528114719552628994470033774178e-03
 	 1.71812181452557499738986734882928e-02 7.42454233200920743485085040447302e-01 2.40364548653823506541016286064405e-01 2.50668921159654441849218287075018e-03
 	 3.27610666905009395577508257701993e-03 7.52958620244844167856967942498159e-01 2.43765273086105738187256974924821e-01 1.10234507224353885969370114850108e-03
 	 9.91699955792932796860839061992010e-01 5.70091063192771849155171537404385e-03 2.59913357513948464760922263394605e-03 1.63953200953990475049332209422914e-05
 	 9.72356946647436659603158659592737e-01 1.89867153505506869315411222487455e-02 8.65633800201265346530021815851796e-03 9.70604918539686551629680488773033e-05
 	 9.42465542363186470353753065865021e-01 3.95177173833150541248926401749486e-02 1.80167402534984755213542939600302e-02 2.85820301003134958142681831816390e-04
 	 9.02695871793453896714254369726405e-01 6.68336366872390730264896774315275e-02 3.04704915193070302592559528420679e-02 6.14312615644140480770929446663331e-04
 	 8.53936753035890450114209215826122e-01 1.00323985846070606875457542628283e-01 4.57392611180389430103332415455952e-02 1.09807154696475207933392681525220e-03
 	 7.97277508336594720184109519323101e-01 1.39240560558790305023535438522231e-01 6.34819311046149747923550421546679e-02 1.73414747254331254137926787706192e-03
 	 7.33983858235659480939716559078079e-01 1.82713996819129392834568648140703e-01 8.33021449452111262257147927812184e-02 2.50047473895055171605461552530869e-03
 	 6.65469698905513773468101135222241e-01 2.29773155736649137281801813514903e-01 1.04757145357837089250097051262856e-01 3.35706266775577044994549602563438e-03
 	 5.93265533483506524170536522433395e-01 2.79366806572062476021756083355285e-01 1.27367659944430999807707394211320e-01 4.24892117768027252622253797653684e-03
 	 5.18984288703573826140313940413762e-01 3.30387105687839466305888436181704e-01 1.50628605608586707553797623404535e-01 5.11047508371405539290277530994899e-03
 	 4.44285286963011227800990354808164e-01 3.81694342443826772903747723830747e-01 1.74020370593162054806413152618916e-01 5.87108538460580538231869951459885e-03
 	 3.70837180584396741700459187995875e-01 4.32142397912287035133260815200629e-01 1.97020421503316223166279996803496e-01 6.46119377698180490793289365569763e-03
 	 3.00280676835950277592246493441053e-01 4.80604347311143653698195521428715e-01 2.19114975852906068709557985130232e-01 6.81854739861965063185689217561958e-03
 	 2.34191886313592112500714392808732e-01 5.25997634279344317143056741770124e-01 2.39810479407063570356228865421144e-01 6.89394976828713434285900163445149e-03
 	 1.74047112635542067238247909699567e-01 5.67308255182318421638854033517418e-01 2.58644632182139511122898056783015e-01 6.65602216756002850600593134799965e-03
 	 1.21189867323675981580777261115145e-01 6.03613415041135858984944206895307e-01 2.75196717635188159434278531989548e-01 6.09454416609109695529555850157521e-03
 	 7.68008370896220426971012784633785e-02 6.34102155593482263995497305586468e-01 2.89097007316895693307401415950153e-01 5.22206609730508676536775425347514e-03
 	 4.18714311177650344575340568553656e-02 6.58093524422858622280330109788338e-01 3.00035044459376343262135833356297e-01 4.07364499259030288236260730627691e-03
 	 1.71812181452557499738986734882928e-02 6.75052072368866884488625146332197e-01 3.07766709485877365537476180179510e-01 2.70479510178624074981379443727292e-03
 	 3.27610666905009395577508257701993e-03 6.84602840518432009808691418584203e-01 3.12121052812517896235533498838777e-01 1.18946438915875436943825338431679e-03
 	 9.91699955792932685838536599476356e-01 5.09533842064367747948239184552222e-03 3.20470578642363668198100867812173e-03 1.72118636783011338367739562205116e-05
 	 9.72356946647436659603158659592737e-01 1.69698748943154092971852264781774e-02 1.06731784582479310996561139290861e-02 1.01894439670511678902413421621276e-04
 	 9.42465542363186470353753065865021e-01 3.53199965197940057848313699651044e-02 2.22144611170195238614155641698744e-02 3.00055139438082363583654155192448e-04
 	 9.02695871793453896714254369726405e-01 5.97343159348349833637215056114655e-02 3.75698122717111199220241246621299e-02 6.44907506215431237245327977802845e-04
 	 8.53936753035890561136511678341776e-01 8.96671939971707410155232764736866e-02 5.63960529669386978479650451845373e-02 1.15275930359434340341517888361977e-03
 	 7.97277508336594831206411981838755e-01 1.24449903486254509488162511843257e-01 7.82725881771506593054255063179880e-02 1.82051400776628009674229513592536e-03
 	 7.33983858235659480939716559078079e-01 1.63305427516773710161501753646007e-01 1.02710714247566808898781687275914e-01 2.62500701952931301055849111492080e-03
 	 6.65469698905513773468101135222241e-01 2.05365785230982283993128589827393e-01 1.29164515863503942538770274950366e-01 3.52425598650807575876187094365832e-03
 	 5.93265533483506524170536522433395e-01 2.49691411580297950578710697300266e-01 1.57043054936195525250752780266339e-01 4.46053213139780291990321714479251e-03
 	 5.18984288703573826140313940413762e-01 2.95292142253293199427588433536584e-01 1.85723569043132974432097626049654e-01 5.36499439842744955259101757860662e-03
 	 4.44285286963011172289839123550337e-01 3.41149330969027220206157835491467e-01 2.14565382067961607504003040958196e-01 6.16348572004148977099280415359317e-03
 	 3.70837180584396741700459187995875e-01 3.86238603871431829261950952059124e-01 2.42924215544171429037589859945001e-01 6.78298354904986657704091257414802e-03
 	 3.00280676835950222081095262183226e-01 4.29552742375614304837228019096074e-01 2.70166580788435417570525487462874e-01 7.15813461562183738634557172986206e-03
 	 2.34191886313592056989563161550905e-01 4.70124183336821988010711947936215e-01 2.95683930349585899488573659255053e-01 7.23729228379702514695193116267546e-03
 	 1.74047112635542067238247909699567e-01 5.07046634407835150604171303712064e-01 3.18906252956622782157580786588369e-01 6.98751506656724880733877469651816e-03
 	 1.21189867323676092603079723630799e-01 5.39495323369951207403971693565836e-01 3.39314809306372699992948582803365e-01 6.39807352084468573816256053987672e-03
 	 7.68008370896220426971012784633785e-02 5.66745435003586317534995941969100e-01 3.56453727906791639767902779567521e-01 5.48214303001722143282581356515948e-03
 	 4.18714311177650344575340568553656e-02 5.88188350224100542362748456071131e-01 3.69940218658134423179717487073503e-01 4.27652658675047297326399231565119e-03
 	 1.71812181452557499738986734882928e-02 6.03345497298760968796216275222832e-01 3.79473284555983281229885051288875e-01 2.83950324231521580159443018942511e-03
 	 3.27610666905009395577508257701993e-03 6.11881746863277342640685674268752e-01 3.84842146467672563403539243154228e-01 1.24870382507136484101506468391563e-03
 	 9.91699955792932685838536599476356e-01 4.46760885774417654953127865269380e-03 3.83243534932313761193212187095014e-03 1.76249771346883608922999353563199e-05
 	 9.72356946647436770625461122108391e-01 1.48792400295713073826719963221876e-02 1.27638133229919219918668815694218e-02 1.04340076293348300970516284724710e-04
 	 9.42465542363186470353753065865021e-01 3.09686847625307223874635553784174e-02 2.65657728742828072587833787565614e-02 3.07256963602904717598740536033119e-04
 	 9.02695871793453896714254369726405e-01 5.23752373150604411122799319855403e-02 4.49288908914856621734656982880551e-02 6.60386362771714363617547860485502e-04
 	 8.53936753035890450114209215826122e-01 7.86204795598678257695368642998801e-02 6.74427674042417241162539198739978e-02 1.18042745093685117960258246228022e-03
 	 7.97277508336594831206411981838755e-01 1.09118069352960020412801611655595e-01 9.36044223104451483807864065056492e-02 1.86420938255000157718344055979287e-03
 	 7.33983858235659480939716559078079e-01 1.43186715829460409210582838568371e-01 1.22829425934880109849700602353550e-01 2.68801156936464627489336010057741e-03
 	 6.65469698905513773468101135222241e-01 1.80065370625494325373949777713278e-01 1.54464930468991901157949087064480e-01 3.60884401247618669117400713730603e-03
 	 5.93265533483506413148234059917741e-01 2.18930220132044828229567201560712e-01 1.87804246384448758622198738521547e-01 4.56759234757015807754099157023120e-03
 	 5.18984288703573826140313940413762e-01 2.58913085146248223011866684828419e-01 2.22102626150177950847819374757819e-01 5.49376321863525793331994862001011e-03
 	 4.44285286963011227800990354808164e-01 2.99120813384204653484488289905130e-01 2.56593899652784174225672586544533e-01 6.31141966471998779042440474995601e-03
 	 3.70837180584396741700459187995875e-01 3.38655230606011103944297246925998e-01 2.90507588809592154355243565078126e-01 6.94578647562070147780666218295664e-03
 	 3.00280676835950333103397724698880e-01 3.76633204367839924397998174754321e-01 3.23086118796209798009755331804627e-01 7.32994179395038761293257323359285e-03
 	 2.34191886313592056989563161550905e-01 4.12206372241317231530643994119600e-01 3.53601741445090655968641613071668e-01 7.41099937828286221136453448821158e-03
 	 1.74047112635542122749399140957394e-01 4.44580094227313649124511130139581e-01 3.81372793137144283637240960160852e-01 7.15522709093951818359879979425386e-03
 	 1.21189867323676148114230954888626e-01 4.73031207433455114230724802837358e-01 4.05778925242868682143893011016189e-01 6.55163796429004702953635685958034e-03
 	 7.68008370896219316747988159477245e-02 4.96924191580633056730675889411941e-01 4.26274971329745011594525294640334e-01 5.61372361291451182907508155039977e-03
 	 4.18714311177650344575340568553656e-02 5.15725407528704438142597155092517e-01 4.42403161353530527399868788052117e-01 4.37917036272992155759853361018941e-03
 	 1.71812181452557499738986734882928e-02 5.29015242067374713563765453727683e-01 4.53803539787369536462335872784024e-01 2.90765605951039335722030365616320e-03
 	 3.27610666905009395577508257701993e-03 5.36499852709101276992953444278101e-01 4.60224040621848629051271473144880e-01 1.27867480106913077725350191826692e-03
 	 9.91699955792932685838536599476356e-01 3.83243534932308123341915262471957e-03 4.46760885774423292804424789892437e-03 1.76249771346882660246098428746819e-05
 	 9.72356946647436770625461122108391e-01 1.27638133229919757682946368504417e-02 1.48792400295712536062442410411677e-02 1.04340076293347758869430041972493e-04
 	 9.42465542363186470353753065865021e-01 2.65657728742828003198894748493331e-02 3.09686847625307293263574592856457e-02 3.07256963602903091295481807776468e-04
 	 9.02695871793453896714254369726405e-01 4.49288908914856482956778904735984e-02 5.23752373150604549900677397999971e-02 6.60386362771710894170595906871313e-04
 	 8.53936753035890561136511678341776e-01 6.74427674042416547273148808017140e-02 7.86204795598677841361734408565098e-02 1.18042745093684489122998204635451e-03
 	 7.97277508336594720184109519323101e-01 9.36044223104451761363620221345627e-02 1.09118069352960103679528458542336e-01 1.86420938254999181936388819025296e-03
 	 7.33983858235659480939716559078079e-01 1.22829425934880137605276217982464e-01 1.43186715829460381455007222939457e-01 2.68801156936463196342468329191888e-03
 	 6.65469698905513773468101135222241e-01 1.54464930468991873402373471435567e-01 1.80065370625494353129525393342192e-01 3.60884401247616760921577139242800e-03
 	 5.93265533483506524170536522433395e-01 1.87804246384448592088745044748066e-01 2.18930220132044883740718432818539e-01 4.56759234757013465877406588333542e-03
 	 5.18984288703573826140313940413762e-01 2.22102626150177950847819374757819e-01 2.58913085146248223011866684828419e-01 5.49376321863522931038259500269305e-03
 	 4.44285286963011227800990354808164e-01 2.56593899652784063203370124028879e-01 2.99120813384204764506790752420784e-01 6.31141966471995483067836119062122e-03
 	 3.70837180584396797211610419253702e-01 2.90507588809592098844092333820299e-01 3.38655230606011048433146015668171e-01 6.94578647562066504861366667000766e-03
 	 3.00280676835950277592246493441053e-01 3.23086118796209742498604100546800e-01 3.76633204367839979909149406012148e-01 7.32994179395034944901610174383677e-03
 	 2.34191886313592056989563161550905e-01 3.53601741445090544946339150556014e-01 4.12206372241317342552946456635254e-01 7.41099937828282318008632501005195e-03
 	 1.74047112635542067238247909699567e-01 3.81372793137144228126089728903025e-01 4.44580094227313704635662361397408e-01 7.15522709093948088704406629290133e-03
 	 1.21189867323676037091928492372972e-01 4.05778925242868682143893011016189e-01 4.73031207433455336275329727868666e-01 6.55163796429001233506683732343845e-03
 	 7.68008370896219316747988159477245e-02 4.26274971329744900572222832124680e-01 4.96924191580633167752978351927595e-01 5.61372361291448147141425195627562e-03
 	 4.18714311177650344575340568553656e-02 4.42403161353530416377566325536463e-01 5.15725407528704549164899617608171e-01 4.37917036272989900619334591169718e-03
 	 1.71812181452557499738986734882928e-02 4.53803539787369425440033410268370e-01 5.29015242067374824586067916243337e-01 2.90765605951037817838988885910112e-03
 	 3.27610666905009395577508257701993e-03 4.60224040621848518028969010629226e-01 5.36499852709101388015255906793755e-01 1.27867480106912405520003250813943e-03
 	 9.91699955792932685838536599476356e-01 3.20470578642358203819151540869825e-03 5.09533842064373212327188511494569e-03 1.72118636783010423572156527560750e-05
 	 9.72356946647436659603158659592737e-01 1.06731784582478790579518346248733e-02 1.69698748943154613388895057823902e-02 1.01894439670511123248800022800253e-04
 	 9.42465542363186470353753065865021e-01 2.22144611170195238614155641698744e-02 3.53199965197940057848313699651044e-02 3.00055139438080737280395426935797e-04
 	 9.02695871793453896714254369726405e-01 3.75698122717111337998119324765867e-02 5.97343159348349694859336977970088e-02 6.44907506215427767798376024188656e-04
 	 8.53936753035890561136511678341776e-01 5.63960529669387672369040842568211e-02 8.96671939971706716265842374014028e-02 1.15275930359433733188301296479494e-03
 	 7.97277508336594720184109519323101e-01 7.82725881771507286943645453902718e-02 1.24449903486254551121525935286627e-01 1.82051400776627033892274276638545e-03
 	 7.33983858235659480939716559078079e-01 1.02710714247566892165508534162655e-01 1.63305427516773626894774906759267e-01 2.62500701952929869908981430626227e-03
 	 6.65469698905513773468101135222241e-01 1.29164515863503970294345890579280e-01 2.05365785230982256237552974198479e-01 3.52425598650805667680363519878028e-03
 	 5.93265533483506413148234059917741e-01 1.57043054936195580761904011524166e-01 2.49691411580298006089861928558093e-01 4.46053213139777950113629145789673e-03
 	 5.18984288703573826140313940413762e-01 1.85723569043133029943248857307481e-01 2.95292142253293143916437202278757e-01 5.36499439842742006229192597288602e-03
 	 4.44285286963011172289839123550337e-01 2.14565382067961718526305503473850e-01 3.41149330969027109183855372975813e-01 6.16348572004145594388502260585483e-03
 	 3.70837180584396741700459187995875e-01 2.42924215544171540059892322460655e-01 3.86238603871431718239648489543470e-01 6.78298354904983014784791706119904e-03
 	 3.00280676835950222081095262183226e-01 2.70166580788435528592827949978528e-01 4.29552742375614193814925556580420e-01 7.15813461562179835506736225170243e-03
 	 2.34191886313592112500714392808732e-01 2.95683930349585954999724890512880e-01 4.70124183336821932499560716678388e-01 7.23729228379698611567372168451584e-03
 	 1.74047112635542067238247909699567e-01 3.18906252956622893179883249104023e-01 5.07046634407835039581868841196410e-01 6.98751506656721151078404119516563e-03
 	 1.21189867323676092603079723630799e-01 3.39314809306372811015251045319019e-01 5.39495323369951096381669231050182e-01 6.39807352084465104369304100373483e-03
 	 7.68008370896219316747988159477245e-02 3.56453727906791750790205242083175e-01 5.66745435003586317534995941969100e-01 5.48214303001719194252672195943887e-03
 	 4.18714311177650344575340568553656e-02 3.69940218658134534202019949589157e-01 5.88188350224100431340445993555477e-01 4.27652658675044955449706662875542e-03
 	 1.71812181452557499738986734882928e-02 3.79473284555983392252187513804529e-01 6.03345497298760857773913812707178e-01 2.83950324231520062276401539236304e-03
 	 3.27610666905009395577508257701993e-03 3.84842146467672674425841705669882e-01 6.11881746863277231618383211753098e-01 1.24870382507135811896159527378813e-03
 	 9.91699955792932796860839061992010e-01 2.59913357513953842403697791496597e-03 5.70091063192766471512396009302392e-03 1.63953200953990915506464781659091e-05
 	 9.72356946647436659603158659592737e-01 8.65633800201259795414898690069094e-03 1.89867153505507424426923535065725e-02 9.70604918539688991084568581158010e-05
 	 9.42465542363186470353753065865021e-01 1.80167402534984755213542939600302e-02 3.95177173833150541248926401749486e-02 2.85820301003135662874093947394272e-04
 	 9.02695871793453896714254369726405e-01 3.04704915193070163814681450276112e-02 6.68336366872390869042774852459843e-02 6.14312615644142107074188174919982e-04
 	 8.53936753035890561136511678341776e-01 4.57392611180388736213942024733115e-02 1.00323985846070565242094119184912e-01 1.09807154696475489825957527756373e-03
 	 7.97277508336594831206411981838755e-01 6.34819311046149192812038108968409e-02 1.39240560558790249512384207264404e-01 1.73414747254331687818795781907966e-03
 	 7.33983858235659480939716559078079e-01 8.33021449452111539812904084101319e-02 1.82713996819129365078993032511789e-01 2.50047473895055778758678144413352e-03
 	 6.65469698905513773468101135222241e-01 1.04757145357837061494521435633942e-01 2.29773155736649165037377429143817e-01 3.35706266775577912356287590966986e-03
 	 5.93265533483506635192838984949049e-01 1.27367659944430944296556162953493e-01 2.79366806572062420510604852097458e-01 4.24892117768028293456339383737941e-03
 	 5.18984288703573826140313940413762e-01 1.50628605608586652042646392146708e-01 3.30387105687839521817039667439531e-01 5.11047508371406840332884513600220e-03
 	 4.44285286963011172289839123550337e-01 1.74020370593161999295261921361089e-01 3.81694342443826828414898955088574e-01 5.87108538460582099482998330586270e-03
 	 3.70837180584396686189307956738048e-01 1.97020421503316167655128765545669e-01 4.32142397912287201666714508974110e-01 6.46119377698182052044417744696148e-03
 	 3.00280676835950333103397724698880e-01 2.19114975852906013198406753872405e-01 4.80604347311143709209346752686542e-01 6.81854739861966797909165194369052e-03
 	 2.34191886313592112500714392808732e-01 2.39810479407063570356228865421144e-01 5.25997634279344317143056741770124e-01 6.89394976828715169009376140252243e-03
 	 1.74047112635542067238247909699567e-01 2.58644632182139400100595594267361e-01 5.67308255182318532661156496033072e-01 6.65602216756004585324069111607059e-03
 	 1.21189867323676092603079723630799e-01 2.75196717635187937389673606958240e-01 6.03613415041135970007246669410961e-01 6.09454416609111256780684229283906e-03
 	 7.68008370896219316747988159477245e-02 2.89097007316895582285098953434499e-01 6.34102155593482486040102230617777e-01 5.22206609730510064315556206793190e-03
 	 4.18714311177650344575340568553656e-02 3.00035044459376232239833370840643e-01 6.58093524422858733302632572303992e-01 4.07364499259031329070346316711948e-03
 	 1.71812181452557499738986734882928e-02 3.07766709485877365537476180179510e-01 6.75052072368866884488625146332197e-01 2.70479510178624768870769834450130e-03
 	 3.27610666905009395577508257701993e-03 3.12121052812517785213231036323123e-01 6.84602840518432120830993881099857e-01 1.18946438915875718836390184662832e-03
 	 9.91699955792932685838536599476356e-01 2.02991275347174249948922764019699e-03 6.27013145359557166197417288344695e-03 1.51944862576347474066029707984171e-05
 	 9.72356946647436770625461122108391e-01 6.76056478078626912897597378560022e-03 2.08824885717769602455629041060092e-02 8.99515411137510358108304586721715e-05
 	 9.42465542363186470353753065865021e-01 1.40710008775138881165212012547272e-02 4.34634567592996415297257328802516e-02 2.64886114481161514047635741064823e-04
 	 9.02695871793453896714254369726405e-01 2.37973299761145284936247890072991e-02 7.35067982304315747921208412662963e-02 5.69318838667624252565524489710924e-04
 	 8.53936753035890561136511678341776e-01 3.57221769461758681396545966890699e-02 1.10341070017933570723833724969154e-01 1.01764606809584589111605801292626e-03
 	 7.97277508336594831206411981838755e-01 4.95791300596599981975742821305175e-02 1.53143361603745170596013736030727e-01 1.60713421799344672452614091184842e-03
 	 7.33983858235659480939716559078079e-01 6.50586364753329426946493185823783e-02 2.00957505289007576365634122339543e-01 2.31733377802174943596580369842286e-03
 	 6.65469698905513773468101135222241e-01 8.18149045563194010632912522851257e-02 2.52715396538166825468607612492633e-01 3.11118308605320232837487814947508e-03
 	 5.93265533483506413148234059917741e-01 9.94736245085718340241953683289466e-02 3.07260842007921752827570571753313e-01 3.93771967051459968744975270737996e-03
 	 5.18984288703573826140313940413762e-01 1.17640328487588374795080881085596e-01 3.63375382808837799064605178500642e-01 4.73617123530689024951678689490109e-03
 	 4.44285286963011116778687892292510e-01 1.35909201823909253636912808360648e-01 4.19805511213079574073248068089015e-01 5.44107255452897387720812005795779e-03
 	 3.70837180584396741700459187995875e-01 1.53872148060912428135793561523315e-01 4.75290671354690830163747250480810e-01 5.98795994716903867693957863593823e-03
 	 3.00280676835950277592246493441053e-01 1.71127905166085114707641423592577e-01 5.28591417997964607700112082966371e-01 6.31914010476876831373660436952377e-03
 	 2.34191886313592112500714392808732e-01 1.87291009288907517316147277597338e-01 5.78517104397500370183138329593930e-01 6.38901981818937921703271953788317e-03
 	 1.74047112635542067238247909699567e-01 2.02000406021974332482216141215758e-01 6.23952481342483600279535949084675e-01 6.16851862403614524532624585617668e-03
 	 1.21189867323676092603079723630799e-01 2.14927517455981154093080931488657e-01 6.63882615220342753303839344880544e-01 5.64816466158572436095930413557653e-03
 	 7.68008370896219316747988159477245e-02 2.25783587175420352721744166046847e-01 6.97415575734957715603457018005429e-01 4.83958904676885012102749428208881e-03
 	 4.18714311177650344575340568553656e-02 2.34326149706965858321439100109274e-01 7.23802419175269107221026843035361e-01 3.77528114719552498890209335513646e-03
 	 1.71812181452557499738986734882928e-02 2.40364548653823950630226136127021e-01 7.42454233200920299395875190384686e-01 2.50668921159654355113044488234664e-03
 	 3.27610666905009395577508257701993e-03 2.43765273086106182276466824987438e-01 7.52958620244843723767758092435542e-01 1.10234507224353842601283215429930e-03
 	 9.91699955792932796860839061992010e-01 1.51038526948466932803283313546672e-03 6.78965893758253381112810487252318e-03 1.36375105154569789387862185914280e-05
 	 9.72356946647436770625461122108391e-01 5.03029376057298818758489744595863e-03 2.26127595919902411869539804456508e-02 8.07342260225451927892204029291179e-05
 	 9.42465542363186470353753065865021e-01 1.04697270441572662380558256245422e-02 4.70647305926562634081911085104366e-02 2.37743291242918593263525051106910e-04
 	 9.02695871793453896714254369726405e-01 1.77067396554438649669549477039254e-02 7.95973885511022383187906825696700e-02 5.10980859591502975004806419434544e-04
 	 8.53936753035890450114209215826122e-01 2.65795905568608353819470835333050e-02 1.19483656407248714503843700640573e-01 9.13368094146468087815571301746331e-04
 	 7.97277508336594720184109519323101e-01 3.68900523374230127071626839097007e-02 1.65832439325982267108727796767198e-01 1.44245151997973003986375228890893e-03
 	 7.33983858235659480939716559078079e-01 4.84077978312326406840071513215662e-02 2.17608343933107878376276289600355e-01 2.07987708368329460989487600386383e-03
 	 6.65469698905513773468101135222241e-01 6.08755358843944271995951567078009e-02 2.73654765210091799332303708069958e-01 2.79238082368486262643814121986452e-03
 	 5.93265533483506524170536522433395e-01 7.40147560051711561612819423316978e-02 3.32719710511322319668181535234908e-01 3.53422238192368978054735961791266e-03
 	 5.18984288703573826140313940413762e-01 8.75319488195257511264912864135113e-02 3.93483762476900422733194773172727e-01 4.25085678642463972443099606834949e-03
 	 4.44285286963011227800990354808164e-01 1.01125162187966466387223363199155e-01 4.54589550849022361322937513250508e-01 4.88352701891903509534564875593787e-03
 	 3.70837180584396741700459187995875e-01 1.14490746175018531793909914995311e-01 5.14672073240584726505630897008814e-01 5.37437497793786817662509136539484e-03
 	 3.00280676835950277592246493441053e-01 1.27330136095044954558375138731208e-01 5.72389187069004767849378367827740e-01 5.67161917594473635045870807402935e-03
 	 2.34191886313592112500714392808732e-01 1.39356522122969339605447203211952e-01 6.26451591563438547893838403979316e-01 5.73433833014528378940743991165618e-03
 	 1.74047112635542067238247909699567e-01 1.50301256624800871897207343863556e-01 6.75651630739657060864544746436877e-01 5.53643184598070180191253797374884e-03
 	 1.21189867323676092603079723630799e-01 1.59919856563895512735484771837946e-01 7.18890276112428394661435504531255e-01 5.06939844226087302225813857603498e-03
 	 7.68008370896219316747988159477245e-02 1.67997468648797165791108909616014e-01 7.55201694261580902534092274436262e-01 4.34367739696613595901109050601008e-03
 	 4.18714311177650344575340568553656e-02 1.74353683017730465287797869677888e-01 7.83774885864504500254668073466746e-01 3.38842889918806317028909802502312e-03
 	 1.71812181452557499738986734882928e-02 1.78846639084442093903248860442545e-01 8.03972142770302156122852466069162e-01 2.24982930666402453426244711920390e-03
 	 3.27610666905009395577508257701993e-03 1.81376996154868352917333140794653e-01 8.15346897176081553126891776628327e-01 9.89388009537322220265931349558741e-04
 	 9.91699955792932796860839061992010e-01 1.05272819515161032005723384941120e-03 7.24731601191559281910370415857869e-03 1.17608916231590187055546653516203e-05
 	 9.72356946647436659603158659592737e-01 3.50608032178253287147740024920495e-03 2.41369730307808075253639401580585e-02 6.96246196440759683443655347900858e-05
 	 9.42465542363186470353753065865021e-01 7.29732809078985356077140522756963e-03 5.02371295460236760854755289074092e-02 2.05028115598662996057685581341445e-04
 	 9.02695871793453896714254369726405e-01 1.23414763478558037190779828051745e-02 8.49626518586902995666676474684209e-02 4.40666242152695829606412480927702e-04
 	 8.53936753035890561136511678341776e-01 1.85257926968128983080674743177951e-02 1.27537454267296540555420847340429e-01 7.87682118018000914684562108192267e-04
 	 7.97277508336594720184109519323101e-01 2.57121139889519845223020411140169e-02 1.77010377674453295293588439562882e-01 1.24395988394764098888822800859089e-03
 	 7.33983858235659480939716559078079e-01 3.37399037660932599180796387372538e-02 2.32276237998247259142203802184667e-01 1.79367113542948570549528941597828e-03
 	 6.65469698905513773468101135222241e-01 4.24298318549750086425831341330195e-02 2.92100469239511217889315730644739e-01 2.40812926968765866203581182958260e-03
 	 5.93265533483506635192838984949049e-01 5.15877783490932828591724046418676e-02 3.55146688167400081947988610409084e-01 3.04788812876340521954010576166638e-03
 	 5.18984288703573826140313940413762e-01 6.10091692236394700366020060755545e-02 4.20006542072786703823084053510684e-01 3.66590851857062421589872336369353e-03
 	 4.44285286963011172289839123550337e-01 7.04835459040686895804128653253429e-02 4.85231167132920138129748011124320e-01 4.21151880639639066700175007440521e-03
 	 3.70837180584396741700459187995875e-01 7.97992664636562043511958108865656e-02 5.49363552951947053948345001117559e-01 4.63482257895270199909987240971532e-03
 	 3.00280676835950277592246493441053e-01 8.87482333600090322889286653662566e-02 6.10971089804040690118824841192691e-01 4.89116385138723634012913876745188e-03
 	 2.34191886313592112500714392808732e-01 9.71305421080895792229625840263907e-02 6.68677571578318308276323023164878e-01 4.94525240181678885087457331337646e-03
 	 1.74047112635542067238247909699567e-01 1.04758947145737968398293560312595e-01 7.21193940218719964363458529987838e-01 4.77457926399284422747104628115267e-03
 	 1.21189867323676092603079723630799e-01 1.11463045469752497496074283844791e-01 7.67347087206571409900845992524410e-01 4.37181299376203976597698996897634e-03
 	 7.68008370896219316747988159477245e-02 1.17093085806530106118827916361624e-01 8.06106077103847962206373267690651e-01 3.74595634986187725479211962920090e-03
 	 4.18714311177650344575340568553656e-02 1.21523323717210307570724125980632e-01 8.36605245165024657971741817164002e-01 2.92215687100392000272175430097832e-03
 	 1.71812181452557499738986734882928e-02 1.24654883344125000377289325115271e-01 8.58163898510619249648812001396436e-01 1.94023671815265596335420283935491e-03
 	 3.27610666905009395577508257701993e-03 1.26418524903439077888833708129823e-01 8.70305368427510828155391209293157e-01 8.53241149858908402674184667802137e-04
 	 9.91699955792932796860839061992010e-01 6.67668123021216211587791633519373e-04 7.63237608404598692757314637447053e-03 9.60862926649648822156196681376628e-06
 	 9.72356946647436770625461122108391e-01 2.22364906572017698160870224910468e-03 2.54194042868430523929301756425048e-02 5.68832006464029999478863863782152e-05
 	 9.42465542363186470353753065865021e-01 4.62815888458841667718601797787414e-03 5.29062987522251129690609161571047e-02 1.67507635910582337174234979215726e-04
 	 9.02695871793453896714254369726405e-01 7.82729140003410317483201197319431e-03 8.94768368065120001109136183004011e-02 3.60023600826966960232466963276465e-04
 	 8.53936753035890561136511678341776e-01 1.17495487385325392271084865569719e-02 1.34313698225576899636379835101252e-01 6.43535005201482024003722948179984e-04
 	 7.97277508336594720184109519323101e-01 1.63073041692768372357136286154855e-02 1.86415187494128442580176852061413e-01 1.01631319548171525878055287961388e-03
 	 7.33983858235659480939716559078079e-01 2.13987412156085299308472258417169e-02 2.44617400548731989129436215080204e-01 1.46542639100762615844697478451053e-03
 	 6.65469698905513773468101135222241e-01 2.69101239286529403393899428920122e-02 3.07620177165833286192508921885747e-01 1.96743768411773538307141251380017e-03
 	 5.93265533483506413148234059917741e-01 3.27183363187239506508774411486229e-02 3.74016130197769636200888498933637e-01 2.49011962812194882418981300986616e-03
 	 5.18984288703573826140313940413762e-01 3.86936321172292041481455271423329e-02 4.42322079179196969711540532443905e-01 2.99504127820328456405229999859330e-03
 	 4.44285286963011172289839123550337e-01 4.47025329181687247626086900709197e-02 5.11012180118820102947552186378743e-01 3.44080399311350515131890936970649e-03
 	 3.70837180584396741700459187995875e-01 5.06108098022264307758177892537788e-02 5.78552009613376827523723022750346e-01 3.78664248460964863660094259500966e-03
 	 3.00280676835950277592246493441053e-01 5.62864817925698979195203719427809e-02 6.43432841371479824488233134616166e-01 3.99607288593017539318763553524150e-03
 	 2.34191886313592112500714392808732e-01 6.16027641664920189157328422879800e-02 7.04205349519915868583552764903288e-01 4.04026314337769480028450530539885e-03
 	 1.74047112635542067238247909699567e-01 6.64409008256879873854927609500010e-02 7.59511986538769945376259329350432e-01 3.90082346825385787442153073811824e-03
 	 1.21189867323676092603079723630799e-01 7.06928176691423715283235651440918e-02 8.08117315007181535868596711225109e-01 3.57176408264769798886484331035263e-03
 	 7.68008370896219316747988159477245e-02 7.42635384701072487345641093270388e-02 8.48935624440270819590637074725237e-01 3.06044022575842821973224339160424e-03
 	 4.18714311177650344575340568553656e-02 7.70733127727089017966477513255086e-02 8.81055256109526063745818191819126e-01 2.38739739568148831225236072839380e-03
 	 1.71812181452557499738986734882928e-02 7.90594308873947548832461507117841e-02 9.03759350967349495142855175799923e-01 1.58517023294915183374842460040099e-03
 	 3.27610666905009395577508257701993e-03 8.01779791081155268628322119184304e-02 9.16545914222834379181392705504550e-01 6.97096627246300711532034366513244e-04
 	 9.91699955792932685838536599476356e-01 3.64229062686263066472847071963770e-04 7.93581514438105109499055345168017e-03 7.23122046339592491941356336426772e-06
 	 9.72356946647436659603158659592737e-01 1.21305419118340751527540533061256e-03 2.64299991613799328815659350766509e-02 4.28089119820633070873268366529629e-05
 	 9.42465542363186470353753065865021e-01 2.52477228487239802046104841792840e-03 5.50096853519411316257858857170504e-02 1.26062168804368622543332634222679e-04
 	 9.02695871793453896714254369726405e-01 4.26997622277688892999947256612359e-03 9.30341519837692143557461577074719e-02 2.70944997189459491852142614121135e-04
 	 8.53936753035890450114209215826122e-01 6.40966219063640596509401348157553e-03 1.39653584773473143920696770692302e-01 4.84308778022126892870424796910811e-04
 	 7.97277508336594831206411981838755e-01 8.89602769357725198240416375483619e-03 1.93826463969827916811183854406408e-01 7.64852568722984181223689681417000e-04
 	 7.33983858235659480939716559078079e-01 1.16735293881617963052121922373772e-02 2.54342612376178722755071248684544e-01 1.10284422599214422880398167592375e-03
 	 6.65469698905513773468101135222241e-01 1.46801215714068011841675343021052e-02 3.19850179523079425347731330475654e-01 1.48064570369628965840202994286301e-03
 	 5.93265533483506524170536522433395e-01 1.78486415018559441136858367826790e-02 3.88885825014637531715777640783926e-01 1.87400341003528779493247924392563e-03
 	 5.18984288703573826140313940413762e-01 2.11083094610129418100541442981921e-02 4.59907401835413232049631915288046e-01 2.25399515154318941245747964785551e-03
 	 4.44285286963011172289839123550337e-01 2.43863097594207989260439717327245e-02 5.31328403277568028784116904716939e-01 2.58946531866860235257532529828950e-03
 	 3.70837180584396741700459187995875e-01 2.76094172845090524148758959199768e-02 6.01553402131094205884664916084148e-01 2.84973494791289404595713286028058e-03
 	 3.00280676835950277592246493441053e-01 3.07056332305439827479176528868265e-02 6.69013689933505739659835853672121e-01 3.00734716935292583847583181011487e-03
 	 2.34191886313592112500714392808732e-01 3.36057934737304941918978329340462e-02 7.32202320212677393307387774257222e-01 3.04060368129385836383216101808102e-03
 	 1.74047112635542067238247909699567e-01 3.62451136985048050220825643918943e-02 7.89707773665953127739669525908539e-01 2.93566477646165814585632602984333e-03
 	 1.21189867323676092603079723630799e-01 3.85646368764327451827966797281988e-02 8.40245495799891162214123596641002e-01 2.68802269382197988462079862870269e-03
 	 7.68008370896219316747988159477245e-02 4.05125511853632325198759644990787e-02 8.82686611725014835805325219553197e-01 2.30321280733247844146882599147830e-03
 	 4.18714311177650344575340568553656e-02 4.20453508283439303383488550025504e-02 9.16083218053891035204117088142084e-01 1.79669715867858273763979504167310e-03
 	 1.71812181452557499738986734882928e-02 4.31288261574084286209540550771635e-02 9.39689955697335821405147271434544e-01 1.19296052626739995487781254013271e-03
 	 3.27610666905009395577508257701993e-03 4.37390211868775580228430044371635e-02 9.52984872144072348021381912985817e-01 5.24617950812638266996912328465896e-04
 	 9.91699955792932685838536599476356e-01 1.49517298144375559987295787323092e-04 8.15052690892293860147610473632085e-03 4.68467040442820227628527990360041e-06
 	 9.72356946647436659603158659592737e-01 4.97962968223332469452913073837408e-04 2.71450903843400079273884273334261e-02 2.77333050517953070635349122063928e-05
 	 9.42465542363186470353753065865021e-01 1.03642781188245658441360319557134e-03 5.64980298249310730618333309394075e-02 8.16680551098174169113302900413487e-05
 	 9.02695871793453896714254369726405e-01 1.75284010359232078624103223774000e-03 9.55512881029537824995045980358555e-02 1.75528877315581175594383367410956e-04
 	 8.53936753035890561136511678341776e-01 2.63118864182348977109882071090396e-03 1.43432058322285949092389500947320e-01 3.13754366982687638108068250986094e-04
 	 7.97277508336594720184109519323101e-01 3.65185033602585806811191559972940e-03 1.99070641327379421747778565077169e-01 4.95501722093087009803069609148451e-04
 	 7.33983858235659480939716559078079e-01 4.79202445036724933302707540860865e-03 2.61224117313973269727256365513313e-01 7.14466075588802117246611800283063e-04
 	 6.65469698905513773468101135222241e-01 6.02624100778681448531415298930369e-03 3.28504060086699412046584711788455e-01 9.59220804103700936532606036166726e-04
 	 5.93265533483506524170536522433395e-01 7.32692946911761566752829821780324e-03 3.99407537047375860161935179348802e-01 1.21405347233280273833155860074839e-03
 	 5.18984288703573826140313940413762e-01 8.66503451352684805897297337651253e-03 4.72350676782899325800713086209726e-01 1.46022714030215284772284967118594e-03
 	 4.44285286963011172289839123550337e-01 1.00106650470149771692263129807543e-02 5.45704047989973850540934563468909e-01 1.67755797282982893961489345713289e-03
 	 3.70837180584396741700459187995875e-01 1.13337619059691308009973909065593e-02 6.17829057509634127498543421097565e-01 1.84617092488462445840080583536746e-03
 	 3.00280676835950277592246493441053e-01 1.26047693300016527828688595036510e-02 6.87114553834048069624884647055296e-01 1.94827835099531344528744902788731e-03
 	 2.34191886313592112500714392808732e-01 1.37952952055288013966105609142687e-02 7.52012818480879086102675046277000e-01 1.96982323377586617321743922559563e-03
 	 1.74047112635542067238247909699567e-01 1.48787453454919393891486834036186e-02 8.11074142018965993372603406896815e-01 1.90183966388901364540087168819582e-03
 	 1.21189867323676092603079723630799e-01 1.58309176844844134990353268221952e-02 8.62979214991839493897884949547006e-01 1.74140733558350276413695389976510e-03
 	 7.68008370896219316747988159477245e-02 1.66305432891521443039550831599627e-02 9.06568619621225924021246100892313e-01 1.49211228287504790376849506117196e-03
 	 4.18714311177650344575340568553656e-02 1.72597628783988099598900589626282e-02 9.40868806003836155582575884182006e-01 1.16397142744961170322814947297729e-03
 	 1.71812181452557499738986734882928e-02 1.77045332726475379558905842714012e-02 9.65114248582096712070210742240306e-01 7.72846976433000419984264972583787e-04
 	 3.27610666905009395577508257701993e-03 1.79550204563841964144899066013750e-02 9.78768872874565709629735010821605e-01 3.39868242192904951651244438437516e-04
 	 9.91699955792932685838536599476356e-01 2.85164652640956112206183092894207e-05 8.27152774180321855024278221435452e-03 2.03233773672140111861959300976199e-06
 	 9.72356946647436659603158659592737e-01 9.49732496666327863366063866124023e-05 2.75480801028967076105047340206511e-02 1.20314638074627667336732872449545e-05
 	 9.42465542363186470353753065865021e-01 1.97671159545359520492979754635599e-04 5.73367864772681701257539543803432e-02 3.54298287724648768557723921279745e-05
 	 9.02695871793453896714254369726405e-01 3.34307832926039605325740922125988e-04 9.69698203736200636804198893514695e-02 7.61492123150419772913133353853254e-05
 	 8.53936753035890561136511678341776e-01 5.01829557108424140210445330012590e-04 1.45561417407001014723277876328211e-01 1.36115198088921182011448718363056e-04
 	 7.97277508336594831206411981838755e-01 6.96493747207760360851125369663350e-04 2.02025997916197408432736892791581e-01 2.14962155601880819518964549352802e-04
 	 7.33983858235659480939716559078079e-01 9.13951766648712915497299036360346e-04 2.65102189997691806144786141885561e-01 3.09954861638467641087729687043861e-04
 	 6.65469698905513773468101135222241e-01 1.14934589177556611971908751002047e-03 3.33380955202710660412179777267738e-01 4.16136135465466970410897129539762e-04
 	 5.93265533483506524170536522433395e-01 1.39741777233570729777056840248406e-03 4.05337048744157768531692909164121e-01 5.26689494289143359667670907242609e-04
 	 5.18984288703573826140313940413762e-01 1.65262587529219073800845762889367e-03 4.79363085421133983121677601957344e-01 6.33486342735154980311540473536525e-04
 	 4.44285286963011172289839123550337e-01 1.90926926600853974491656117606908e-03 5.53805443770980287965244315273594e-01 7.27770382842131673822860804534685e-04
 	 3.70837180584396741700459187995875e-01 2.16161495502020795100861505488865e-03 6.27001204460583050348532196949236e-01 8.00919278234439157432289491111987e-04
 	 3.00280676835950277592246493441053e-01 2.40402596369715393365140698733740e-03 6.97315297200352568474102099571610e-01 8.45216263373049802622161141840706e-04
 	 2.34191886313592112500714392808732e-01 2.63108724822291861755729769356549e-03 7.63177026438184968881728309497703e-01 8.54563020888107240102815609361642e-04
 	 1.74047112635542067238247909699567e-01 2.83772667165471670358556366409175e-03 8.23115160692803216058166526636342e-01 8.25069894877046594063030315879814e-04
 	 1.21189867323676092603079723630799e-01 3.01932833090945429432849778095260e-03 8.75790804345414453102591778588248e-01 7.55469977090479530117128614818967e-04
 	 7.68008370896219316747988159477245e-02 3.17183574017099179087608717964031e-03 9.20027327170207076534325096872635e-01 6.47318986848257000091266810670732e-04
 	 4.18714311177650344575340568553656e-02 3.29184271450067011954843110288493e-03 9.54836726167734295422917512041749e-01 5.04962537862908475948253705922752e-04
 	 1.71812181452557499738986734882928e-02 3.37667088927040559553915954893455e-03 9.79442110965473844430562166962773e-01 3.35282088027180169391427977387821e-04
 	 3.27610666905009395577508257701993e-03 3.42444468643487986980744608445093e-03 9.93299448644515026174417471338529e-01 1.47444109081590270411699084007751e-04
 	 ];
 
 	 case  39 

 	 % ALG. DEG.:   39
 	 % PTS CARD.:  400
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 9.91699955792932685838536599476356e-01 8.27152774180316303909155095652750e-03 2.85164652641511223718495671164419e-05 2.03233773672144092916811396187793e-06
 	 9.72356946647436659603158659592737e-01 2.75480801028966520993535027628241e-02 9.49732496666882974878376444394235e-05 1.20314638074630005147667294318481e-05
 	 9.42465542363186470353753065865021e-01 5.73367864772681701257539543803432e-02 1.97671159545359520492979754635599e-04 3.54298287724655680346573516370512e-05
 	 9.02695871793453896714254369726405e-01 9.69698203736200636804198893514695e-02 3.34307832926039605325740922125988e-04 7.61492123150434680693005029539222e-05
 	 8.53936753035890561136511678341776e-01 1.45561417407001070234429107586038e-01 5.01829557108368629059214072185569e-04 1.36115198088923838306771307848919e-04
 	 7.97277508336594831206411981838755e-01 2.02025997916197463943888124049408e-01 6.96493747207704849699894111836329e-04 2.14962155601885020802382930682484e-04
 	 7.33983858235659480939716559078079e-01 2.65102189997691861655937373143388e-01 9.13951766648657404346067778533325e-04 3.09954861638473658409786981593470e-04
 	 6.65469698905513773468101135222241e-01 3.33380955202710660412179777267738e-01 1.14934589177556611971908751002047e-03 4.16136135465475101927190770823017e-04
 	 5.93265533483506524170536522433395e-01 4.05337048744157768531692909164121e-01 1.39741777233570729777056840248406e-03 5.26689494289153659588309519534732e-04
 	 5.18984288703573826140313940413762e-01 4.79363085421133983121677601957344e-01 1.65262587529219073800845762889367e-03 6.33486342735167340216306808287072e-04
 	 4.44285286963011172289839123550337e-01 5.53805443770980287965244315273594e-01 1.90926926600853974491656117606908e-03 7.27770382842145876871320364642770e-04
 	 3.70837180584396741700459187995875e-01 6.27001204460583050348532196949236e-01 2.16161495502020795100861505488865e-03 8.00919278234454769943573282375837e-04
 	 3.00280676835950277592246493441053e-01 6.97315297200352568474102099571610e-01 2.40402596369715393365140698733740e-03 8.45216263373066282495182921508103e-04
 	 2.34191886313592112500714392808732e-01 7.63177026438184968881728309497703e-01 2.63108724822291861755729769356549e-03 8.54563020888123936816271886129925e-04
 	 1.74047112635542067238247909699567e-01 8.23115160692803216058166526636342e-01 2.83772667165471670358556366409175e-03 8.25069894877062748675400349895881e-04
 	 1.21189867323676092603079723630799e-01 8.75790804345414453102591778588248e-01 3.01932833090945429432849778095260e-03 7.55469977090494275266674417679269e-04
 	 7.68008370896219316747988159477245e-02 9.20027327170207076534325096872635e-01 3.17183574017099179087608717964031e-03 6.47318986848269576836467642522166e-04
 	 4.18714311177650344575340568553656e-02 9.54836726167734295422917512041749e-01 3.29184271450067011954843110288493e-03 5.04962537862918233767806075462659e-04
 	 1.71812181452557499738986734882928e-02 9.79442110965473844430562166962773e-01 3.37667088927040559553915954893455e-03 3.35282088027186728814571514689646e-04
 	 3.27610666905009395577508257701993e-03 9.93299448644515026174417471338529e-01 3.42444468643487986980744608445093e-03 1.47444109081593143547456170594501e-04
 	 9.91699955792932685838536599476356e-01 8.15052690892288309032487347849383e-03 1.49517298144431071138527045150113e-04 4.68467040442822599320780302400991e-06
 	 9.72356946647436659603158659592737e-01 2.71450903843399524162371960755991e-02 4.97962968223387980604144331664429e-04 2.77333050517954493650700509288498e-05
 	 9.42465542363186470353753065865021e-01 5.64980298249310661229394270321791e-02 1.03642781188246352330750710279972e-03 8.16680551098178370396721281743169e-05
 	 9.02695871793453896714254369726405e-01 9.55512881029537686217167902213987e-02 1.75284010359233466402884005219676e-03 1.75528877315582070061175667952114e-04
 	 8.53936753035890450114209215826122e-01 1.43432058322285976847965116576233e-01 2.63118864182357303782566759764450e-03 3.13754366982689210201218354967523e-04
 	 7.97277508336594720184109519323101e-01 1.99070641327379366236627333819342e-01 3.65185033602591357926314685755642e-03 4.95501722093089503468066325808650e-04
 	 7.33983858235659369917414096562425e-01 2.61224117313973325238407596771140e-01 4.79202445036730484417830666643567e-03 7.14466075588805803533998250998138e-04
 	 6.65469698905513773468101135222241e-01 3.28504060086699412046584711788455e-01 6.02624100778681448531415298930369e-03 9.59220804103705923862599469487122e-04
 	 5.93265533483506635192838984949049e-01 3.99407537047375804650783948090975e-01 7.32692946911756015637706695997622e-03 1.21405347233280880986372451957322e-03
 	 5.18984288703573826140313940413762e-01 4.72350676782899270289561854951899e-01 8.66503451352690357012420463433955e-03 1.46022714030216022029762257261609e-03
 	 4.44285286963011172289839123550337e-01 5.45704047989973739518632100953255e-01 1.00106650470150881915287754964083e-02 1.67755797282983739639183884406748e-03
 	 3.70837180584396741700459187995875e-01 6.17829057509634127498543421097565e-01 1.13337619059691308009973909065593e-02 1.84617092488463399937992370780648e-03
 	 3.00280676835950277592246493441053e-01 6.87114553834047958602582184539642e-01 1.26047693300017638051713220193051e-02 1.94827835099532341994743589452810e-03
 	 2.34191886313592112500714392808732e-01 7.52012818480878975080372583761346e-01 1.37952952055289124189130234299228e-02 1.96982323377587614787742609223642e-03
 	 1.74047112635542067238247909699567e-01 8.11074142018965882350300944381161e-01 1.48787453454920504114511459192727e-02 1.90183966388902340322042405773573e-03
 	 1.21189867323676092603079723630799e-01 8.62979214991839382875582487031352e-01 1.58309176844845245213377893378492e-02 1.74140733558351165459476828090146e-03
 	 7.68008370896219316747988159477245e-02 9.06568619621225812998943638376659e-01 1.66305432891522553262575456756167e-02 1.49211228287505571002413695680389e-03
 	 4.18714311177650344575340568553656e-02 9.40868806003836044560273421666352e-01 1.72597628783989209821925214782823e-02 1.16397142744961777476031539180212e-03
 	 1.71812181452557499738986734882928e-02 9.65114248582096601047908279724652e-01 1.77045332726476489781930467870552e-02 7.72846976433004431532303168950193e-04
 	 3.27610666905009395577508257701993e-03 9.78768872874565598607432548305951e-01 1.79550204563843074367923691170290e-02 3.39868242192906686374720415244610e-04
 	 9.91699955792932685838536599476356e-01 7.93581514438099384911584621704606e-03 3.64229062686320312347554306597885e-04 7.23122046339593931897366668737348e-06
 	 9.72356946647436659603158659592737e-01 2.64299991613798739009677518652097e-02 1.21305419118346649587358854205377e-03 4.28089119820633884024897730657955e-05
 	 9.42465542363186470353753065865021e-01 5.50096853519411177479980779025936e-02 2.52477228487241189824885623238515e-03 1.26062168804368893593875755598788e-04
 	 9.02695871793453896714254369726405e-01 9.30341519837691866001705420785584e-02 4.26997622277691668557508819503710e-03 2.70944997189460033953228856873352e-04
 	 8.53936753035890561136511678341776e-01 1.39653584773473060653969923805562e-01 6.40966219063637820951839785266202e-03 4.84308778022127868652380033864802e-04
 	 7.97277508336594720184109519323101e-01 1.93826463969827916811183854406408e-01 8.89602769357736300470662627049023e-03 7.64852568722985699106731161123207e-04
 	 7.33983858235659369917414096562425e-01 2.54342612376178722755071248684544e-01 1.16735293881619073275146547530312e-02 1.10284422599214639720832664693262e-03
 	 6.65469698905513773468101135222241e-01 3.19850179523079369836580099217827e-01 1.46801215714068566953187655599322e-02 1.48064570369629247732767840517454e-03
 	 5.93265533483506524170536522433395e-01 3.88885825014637420693475178268272e-01 1.78486415018560551359882992983330e-02 1.87400341003529148121986569464070e-03
 	 5.18984288703573826140313940413762e-01 4.59907401835413121027329452772392e-01 2.11083094610130528323566068138462e-02 2.25399515154319374926616958987324e-03
 	 4.44285286963011172289839123550337e-01 5.31328403277567917761814442201285e-01 2.43863097594209099483464342483785e-02 2.58946531866860755674575322871078e-03
 	 3.70837180584396741700459187995875e-01 6.01553402131094094862362453568494e-01 2.76094172845091634371783584356308e-02 2.84973494791289968380842978490364e-03
 	 3.00280676835950277592246493441053e-01 6.69013689933505628637533391156467e-01 3.07056332305440937702201154024806e-02 3.00734716935293191000799772893970e-03
 	 2.34191886313592112500714392808732e-01 7.32202320212677171262782849225914e-01 3.36057934737307162365027579653542e-02 3.04060368129386443536432693690585e-03
 	 1.74047112635542067238247909699567e-01 7.89707773665952905695064600877231e-01 3.62451136985050270666874894232024e-02 2.93566477646166378370762295446639e-03
 	 1.21189867323676092603079723630799e-01 8.40245495799890940169518671609694e-01 3.85646368764329672274016047595069e-02 2.68802269382198552247209555332574e-03
 	 7.68008370896219316747988159477245e-02 8.82686611725014613760720294521889e-01 4.05125511853634545644808895303868e-02 2.30321280733248321195838492769781e-03
 	 4.18714311177650344575340568553656e-02 9.16083218053890813159512163110776e-01 4.20453508283441523829537800338585e-02 1.79669715867858642392718149238817e-03
 	 1.71812181452557499738986734882928e-02 9.39689955697335599360542346403236e-01 4.31288261574086506655589801084716e-02 1.19296052626740234012259200824246e-03
 	 3.27610666905009395577508257701993e-03 9.52984872144072125976776987954509e-01 4.37390211868777800674479294684716e-02 5.24617950812639351199084813970330e-04
 	 9.91699955792932796860839061992010e-01 7.63237608404604243872437763229755e-03 6.67668123021160700436560375692352e-04 9.60862926649655767826364166639408e-06
 	 9.72356946647436770625461122108391e-01 2.54194042868431079040814069003318e-02 2.22364906572012147045747099127766e-03 5.68832006464034065237010684423780e-05
 	 9.42465542363186470353753065865021e-01 5.29062987522251129690609161571047e-02 4.62815888458841667718601797787414e-03 1.67507635910583556901679025408214e-04
 	 9.02695871793453896714254369726405e-01 8.94768368065120001109136183004011e-02 7.82729140003410317483201197319431e-03 3.60023600826969562317680928487107e-04
 	 8.53936753035890561136511678341776e-01 1.34313698225576955147531066359079e-01 1.17495487385324837159572552991449e-02 6.43535005201486686073064635849050e-04
 	 7.97277508336594831206411981838755e-01 1.86415187494128387069025620803586e-01 1.63073041692767817245623973576585e-02 1.01631319548172263135532578104403e-03
 	 7.33983858235659369917414096562425e-01 2.44617400548732044640587446338031e-01 2.13987412156085854419984570995439e-02 1.46542639100763656678783064535310e-03
 	 6.65469698905513773468101135222241e-01 3.07620177165833286192508921885747e-01 2.69101239286529403393899428920122e-02 1.96743768411774969454008932245870e-03
 	 5.93265533483506635192838984949049e-01 3.74016130197769525178586036417983e-01 3.27183363187238396285749786329689e-02 2.49011962812196660510544177213887e-03
 	 5.18984288703573826140313940413762e-01 4.42322079179196969711540532443905e-01 3.86936321172292041481455271423329e-02 2.99504127820330581441488071448020e-03
 	 4.44285286963011172289839123550337e-01 5.11012180118820102947552186378743e-01 4.47025329181687247626086900709197e-02 3.44080399311352987112844203920758e-03
 	 3.70837180584396741700459187995875e-01 5.78552009613376827523723022750346e-01 5.06108098022264307758177892537788e-02 3.78664248460967552481482023551962e-03
 	 3.00280676835950277592246493441053e-01 6.43432841371479824488233134616166e-01 5.62864817925698979195203719427809e-02 3.99607288593020401612498915255856e-03
 	 2.34191886313592112500714392808732e-01 7.04205349519915868583552764903288e-01 6.16027641664920189157328422879800e-02 4.04026314337772342322185892271591e-03
 	 1.74047112635542067238247909699567e-01 7.59511986538769945376259329350432e-01 6.64409008256879873854927609500010e-02 3.90082346825388562999714636703175e-03
 	 1.21189867323676092603079723630799e-01 8.08117315007181535868596711225109e-01 7.06928176691423715283235651440918e-02 3.57176408264772357603611396825727e-03
 	 7.68008370896219316747988159477245e-02 8.48935624440270819590637074725237e-01 7.42635384701072487345641093270388e-02 3.06044022575845033745656209589470e-03
 	 4.18714311177650344575340568553656e-02 8.81055256109525952723515729303472e-01 7.70733127727090128189502138411626e-02 2.38739739568150522580625150226297e-03
 	 1.71812181452557499738986734882928e-02 9.03759350967349495142855175799923e-01 7.90594308873947548832461507117841e-02 1.58517023294916310945101844964711e-03
 	 3.27610666905009395577508257701993e-03 9.16545914222834379181392705504550e-01 8.01779791081155268628322119184304e-02 6.97096627246305807282245048384084e-04
 	 9.91699955792932796860839061992010e-01 7.24731601191564833025493541640571e-03 1.05272819515155480890600259158418e-03 1.17608916231588459108334254743511e-05
 	 9.72356946647436659603158659592737e-01 2.41369730307807520142127089002315e-02 3.50608032178258838262863150703197e-03 6.96246196440749383523016735608735e-05
 	 9.42465542363186470353753065865021e-01 5.02371295460236760854755289074092e-02 7.29732809078985356077140522756963e-03 2.05028115598659987396656934066641e-04
 	 9.02695871793453896714254369726405e-01 8.49626518586902995666676474684209e-02 1.23414763478558037190779828051745e-02 4.40666242152689378603486192176319e-04
 	 8.53936753035890561136511678341776e-01 1.27537454267296568310996462969342e-01 1.85257926968128705524918586888816e-02 7.87682118017989422141533761845267e-04
 	 7.97277508336594720184109519323101e-01 1.77010377674453239782437208305055e-01 2.57121139889520400334532723718439e-02 1.24395988394762277429173025211639e-03
 	 7.33983858235659480939716559078079e-01 2.32276237998247314653355033442494e-01 3.37399037660932044069284074794268e-02 1.79367113542945925096228076967009e-03
 	 6.65469698905513773468101135222241e-01 2.92100469239511217889315730644739e-01 4.24298318549750086425831341330195e-02 2.40812926968762310020455430503716e-03
 	 5.93265533483506635192838984949049e-01 3.55146688167400192970291072924738e-01 5.15877783490931718368699421262136e-02 3.04788812876336055041059935888370e-03
 	 5.18984288703573826140313940413762e-01 4.20006542072786703823084053510684e-01 6.10091692236394700366020060755545e-02 3.66590851857057043947096808267361e-03
 	 4.44285286963011172289839123550337e-01 4.85231167132920138129748011124320e-01 7.04835459040686895804128653253429e-02 4.21151880639632908431835289775336e-03
 	 3.70837180584396741700459187995875e-01 5.49363552951947053948345001117559e-01 7.97992664636562043511958108865656e-02 4.63482257895263434488430931423864e-03
 	 3.00280676835950277592246493441053e-01 6.10971089804040690118824841192691e-01 8.87482333600090322889286653662566e-02 4.89116385138716434910488572995746e-03
 	 2.34191886313592112500714392808732e-01 6.68677571578318308276323023164878e-01 9.71305421080895792229625840263907e-02 4.94525240181671599248858228747849e-03
 	 1.74047112635542067238247909699567e-01 7.21193940218719964363458529987838e-01 1.04758947145737968398293560312595e-01 4.77457926399277397117026922046534e-03
 	 1.21189867323676092603079723630799e-01 7.67347087206571409900845992524410e-01 1.11463045469752497496074283844791e-01 4.37181299376197558120837882711385e-03
 	 7.68008370896219316747988159477245e-02 8.06106077103847962206373267690651e-01 1.17093085806530106118827916361624e-01 3.74595634986182217732175736557565e-03
 	 4.18714311177650344575340568553656e-02 8.36605245165024657971741817164002e-01 1.21523323717210307570724125980632e-01 2.92215687100387706831572387500273e-03
 	 1.71812181452557499738986734882928e-02 8.58163898510619249648812001396436e-01 1.24654883344125000377289325115271e-01 1.94023671815262734041684922203785e-03
 	 3.27610666905009395577508257701993e-03 8.70305368427510828155391209293157e-01 1.26418524903439077888833708129823e-01 8.53241149858895825928983835950703e-04
 	 9.91699955792932796860839061992010e-01 6.78965893758258932227933613035020e-03 1.51038526948461381688160187763970e-03 1.36375105154570009616428472032368e-05
 	 9.72356946647436770625461122108391e-01 2.26127595919903001675521636570920e-02 5.03029376057292920698671423451742e-03 8.07342260225453147619648075483667e-05
 	 9.42465542363186470353753065865021e-01 4.70647305926562703470850124176650e-02 1.04697270441572592991619217173138e-02 2.37743291242918945629231108895851e-04
 	 9.02695871793453896714254369726405e-01 7.95973885511022383187906825696700e-02 1.77067396554438649669549477039254e-02 5.10980859591503733946327159287648e-04
 	 8.53936753035890450114209215826122e-01 1.19483656407248672870480277197203e-01 2.65795905568608770153105069766752e-02 9.13368094146469497278395532902096e-04
 	 7.97277508336594720184109519323101e-01 1.65832439325982211597576565509371e-01 3.68900523374230682183139151675277e-02 1.44245151997973220826809725991779e-03
 	 7.33983858235659480939716559078079e-01 2.17608343933107933887427520858182e-01 4.84077978312325851728559200637392e-02 2.07987708368329807934182795747802e-03
 	 6.65469698905513773468101135222241e-01 2.73654765210091799332303708069958e-01 6.08755358843944271995951567078009e-02 2.79238082368486696324683116188226e-03
 	 5.93265533483506413148234059917741e-01 3.32719710511322375179332766492735e-01 7.40147560051712116724331735895248e-02 3.53422238192369541839865654253572e-03
 	 5.18984288703573826140313940413762e-01 3.93483762476900422733194773172727e-01 8.75319488195257511264912864135113e-02 4.25085678642464579596316198717432e-03
 	 4.44285286963011227800990354808164e-01 4.54589550849022361322937513250508e-01 1.01125162187966466387223363199155e-01 4.88352701891904203423955266316625e-03
 	 3.70837180584396741700459187995875e-01 5.14672073240584726505630897008814e-01 1.14490746175018531793909914995311e-01 5.37437497793787685024247124943031e-03
 	 3.00280676835950277592246493441053e-01 5.72389187069004767849378367827740e-01 1.27330136095044954558375138731208e-01 5.67161917594474502407608795806482e-03
 	 2.34191886313592112500714392808732e-01 6.26451591563438658916140866494970e-01 1.39356522122969228583144740696298e-01 5.73433833014529333038655778409520e-03
 	 1.74047112635542067238247909699567e-01 6.75651630739657171886847208952531e-01 1.50301256624800760874904881347902e-01 5.53643184598071047552991785778431e-03
 	 1.21189867323676092603079723630799e-01 7.18890276112428505683737967046909e-01 1.59919856563895401713182309322292e-01 5.06939844226088082851378047166691e-03
 	 7.68008370896219316747988159477245e-02 7.55201694261580902534092274436262e-01 1.67997468648797165791108909616014e-01 4.34367739696614203054325642483491e-03
 	 4.18714311177650344575340568553656e-02 7.83774885864504500254668073466746e-01 1.74353683017730465287797869677888e-01 3.38842889918806837445952595544441e-03
 	 1.71812181452557499738986734882928e-02 8.03972142770302156122852466069162e-01 1.78846639084442093903248860442545e-01 2.24982930666402757002853007861631e-03
 	 3.27610666905009395577508257701993e-03 8.15346897176081553126891776628327e-01 1.81376996154868352917333140794653e-01 9.89388009537323738148972829264949e-04
 	 9.91699955792932685838536599476356e-01 6.27013145359552048763163156763767e-03 2.02991275347179367383176895600627e-03 1.51944862576347524888006543242192e-05
 	 9.72356946647436770625461122108391e-01 2.08824885717770261650549912246788e-02 6.76056478078620320948388666693063e-03 8.99515411137510629158847708097824e-05
 	 9.42465542363186470353753065865021e-01 4.34634567592996692853013485091651e-02 1.40710008775138603609455856258137e-02 2.64886114481161622467852989615267e-04
 	 9.02695871793453896714254369726405e-01 7.35067982304316164254842647096666e-02 2.37973299761144868602613655639288e-02 5.69318838667624469405958986811811e-04
 	 8.53936753035890450114209215826122e-01 1.10341070017933695623923995299265e-01 3.57221769461758542618667888746131e-02 1.01764606809584632479692700712803e-03
 	 7.97277508336594720184109519323101e-01 1.53143361603745309373891814175295e-01 4.95791300596599704419986665016040e-02 1.60713421799344737504744440315108e-03
 	 7.33983858235659480939716559078079e-01 2.00957505289007742899087816113024e-01 6.50586364753327761611956248088973e-02 2.31733377802175030332754168682641e-03
 	 6.65469698905513773468101135222241e-01 2.52715396538166992002061306266114e-01 8.18149045563192345298375585116446e-02 3.11118308605320362941748513208040e-03
 	 5.93265533483506524170536522433395e-01 3.07260842007921808338721803011140e-01 9.94736245085716674907416745554656e-02 3.93771967051460142217322868418705e-03
 	 5.18984288703573826140313940413762e-01 3.63375382808838021109210103531950e-01 1.17640328487588152750475956054288e-01 4.73617123530689198424026287170818e-03
 	 4.44285286963011227800990354808164e-01 4.19805511213079796117852993120323e-01 1.35909201823909031592307883329340e-01 5.44107255452897647929333402316843e-03
 	 3.70837180584396686189307956738048e-01 4.75290671354691107719503406769945e-01 1.53872148060912261602339867749834e-01 5.98795994716904127902479260114887e-03
 	 3.00280676835950277592246493441053e-01 5.28591417997964940767019470513333e-01 1.71127905166084781640734036045615e-01 6.31914010476877091582181833473442e-03
 	 2.34191886313592112500714392808732e-01 5.78517104397500703250045717140893e-01 1.87291009288907184249239890050376e-01 6.38901981818938181911793350309381e-03
 	 1.74047112635542067238247909699567e-01 6.23952481342483933346443336631637e-01 2.02000406021973999415308753668796e-01 6.16851862403614784741145982138733e-03
 	 1.21189867323676092603079723630799e-01 6.63882615220343086370746732427506e-01 2.14927517455980821026173543941695e-01 5.64816466158572609568278011238363e-03
 	 7.68008370896219316747988159477245e-02 6.97415575734958159692666868068045e-01 2.25783587175419908632534315984230e-01 4.83958904676885272311270824729945e-03
 	 4.18714311177650344575340568553656e-02 7.23802419175269440287934230582323e-01 2.34326149706965525254531712562311e-01 3.77528114719552628994470033774178e-03
 	 1.71812181452557499738986734882928e-02 7.42454233200920743485085040447302e-01 2.40364548653823506541016286064405e-01 2.50668921159654441849218287075018e-03
 	 3.27610666905009395577508257701993e-03 7.52958620244844167856967942498159e-01 2.43765273086105738187256974924821e-01 1.10234507224353885969370114850108e-03
 	 9.91699955792932796860839061992010e-01 5.70091063192771849155171537404385e-03 2.59913357513948464760922263394605e-03 1.63953200953990475049332209422914e-05
 	 9.72356946647436659603158659592737e-01 1.89867153505506869315411222487455e-02 8.65633800201265346530021815851796e-03 9.70604918539686551629680488773033e-05
 	 9.42465542363186470353753065865021e-01 3.95177173833150541248926401749486e-02 1.80167402534984755213542939600302e-02 2.85820301003134958142681831816390e-04
 	 9.02695871793453896714254369726405e-01 6.68336366872390730264896774315275e-02 3.04704915193070302592559528420679e-02 6.14312615644140480770929446663331e-04
 	 8.53936753035890450114209215826122e-01 1.00323985846070606875457542628283e-01 4.57392611180389430103332415455952e-02 1.09807154696475207933392681525220e-03
 	 7.97277508336594720184109519323101e-01 1.39240560558790305023535438522231e-01 6.34819311046149747923550421546679e-02 1.73414747254331254137926787706192e-03
 	 7.33983858235659480939716559078079e-01 1.82713996819129392834568648140703e-01 8.33021449452111262257147927812184e-02 2.50047473895055171605461552530869e-03
 	 6.65469698905513773468101135222241e-01 2.29773155736649137281801813514903e-01 1.04757145357837089250097051262856e-01 3.35706266775577044994549602563438e-03
 	 5.93265533483506524170536522433395e-01 2.79366806572062476021756083355285e-01 1.27367659944430999807707394211320e-01 4.24892117768027252622253797653684e-03
 	 5.18984288703573826140313940413762e-01 3.30387105687839466305888436181704e-01 1.50628605608586707553797623404535e-01 5.11047508371405539290277530994899e-03
 	 4.44285286963011227800990354808164e-01 3.81694342443826772903747723830747e-01 1.74020370593162054806413152618916e-01 5.87108538460580538231869951459885e-03
 	 3.70837180584396741700459187995875e-01 4.32142397912287035133260815200629e-01 1.97020421503316223166279996803496e-01 6.46119377698180490793289365569763e-03
 	 3.00280676835950277592246493441053e-01 4.80604347311143653698195521428715e-01 2.19114975852906068709557985130232e-01 6.81854739861965063185689217561958e-03
 	 2.34191886313592112500714392808732e-01 5.25997634279344317143056741770124e-01 2.39810479407063570356228865421144e-01 6.89394976828713434285900163445149e-03
 	 1.74047112635542067238247909699567e-01 5.67308255182318421638854033517418e-01 2.58644632182139511122898056783015e-01 6.65602216756002850600593134799965e-03
 	 1.21189867323675981580777261115145e-01 6.03613415041135858984944206895307e-01 2.75196717635188159434278531989548e-01 6.09454416609109695529555850157521e-03
 	 7.68008370896220426971012784633785e-02 6.34102155593482263995497305586468e-01 2.89097007316895693307401415950153e-01 5.22206609730508676536775425347514e-03
 	 4.18714311177650344575340568553656e-02 6.58093524422858622280330109788338e-01 3.00035044459376343262135833356297e-01 4.07364499259030288236260730627691e-03
 	 1.71812181452557499738986734882928e-02 6.75052072368866884488625146332197e-01 3.07766709485877365537476180179510e-01 2.70479510178624074981379443727292e-03
 	 3.27610666905009395577508257701993e-03 6.84602840518432009808691418584203e-01 3.12121052812517896235533498838777e-01 1.18946438915875436943825338431679e-03
 	 9.91699955792932685838536599476356e-01 5.09533842064367747948239184552222e-03 3.20470578642363668198100867812173e-03 1.72118636783011338367739562205116e-05
 	 9.72356946647436659603158659592737e-01 1.69698748943154092971852264781774e-02 1.06731784582479310996561139290861e-02 1.01894439670511678902413421621276e-04
 	 9.42465542363186470353753065865021e-01 3.53199965197940057848313699651044e-02 2.22144611170195238614155641698744e-02 3.00055139438082363583654155192448e-04
 	 9.02695871793453896714254369726405e-01 5.97343159348349833637215056114655e-02 3.75698122717111199220241246621299e-02 6.44907506215431237245327977802845e-04
 	 8.53936753035890561136511678341776e-01 8.96671939971707410155232764736866e-02 5.63960529669386978479650451845373e-02 1.15275930359434340341517888361977e-03
 	 7.97277508336594831206411981838755e-01 1.24449903486254509488162511843257e-01 7.82725881771506593054255063179880e-02 1.82051400776628009674229513592536e-03
 	 7.33983858235659480939716559078079e-01 1.63305427516773710161501753646007e-01 1.02710714247566808898781687275914e-01 2.62500701952931301055849111492080e-03
 	 6.65469698905513773468101135222241e-01 2.05365785230982283993128589827393e-01 1.29164515863503942538770274950366e-01 3.52425598650807575876187094365832e-03
 	 5.93265533483506524170536522433395e-01 2.49691411580297950578710697300266e-01 1.57043054936195525250752780266339e-01 4.46053213139780291990321714479251e-03
 	 5.18984288703573826140313940413762e-01 2.95292142253293199427588433536584e-01 1.85723569043132974432097626049654e-01 5.36499439842744955259101757860662e-03
 	 4.44285286963011172289839123550337e-01 3.41149330969027220206157835491467e-01 2.14565382067961607504003040958196e-01 6.16348572004148977099280415359317e-03
 	 3.70837180584396741700459187995875e-01 3.86238603871431829261950952059124e-01 2.42924215544171429037589859945001e-01 6.78298354904986657704091257414802e-03
 	 3.00280676835950222081095262183226e-01 4.29552742375614304837228019096074e-01 2.70166580788435417570525487462874e-01 7.15813461562183738634557172986206e-03
 	 2.34191886313592056989563161550905e-01 4.70124183336821988010711947936215e-01 2.95683930349585899488573659255053e-01 7.23729228379702514695193116267546e-03
 	 1.74047112635542067238247909699567e-01 5.07046634407835150604171303712064e-01 3.18906252956622782157580786588369e-01 6.98751506656724880733877469651816e-03
 	 1.21189867323676092603079723630799e-01 5.39495323369951207403971693565836e-01 3.39314809306372699992948582803365e-01 6.39807352084468573816256053987672e-03
 	 7.68008370896220426971012784633785e-02 5.66745435003586317534995941969100e-01 3.56453727906791639767902779567521e-01 5.48214303001722143282581356515948e-03
 	 4.18714311177650344575340568553656e-02 5.88188350224100542362748456071131e-01 3.69940218658134423179717487073503e-01 4.27652658675047297326399231565119e-03
 	 1.71812181452557499738986734882928e-02 6.03345497298760968796216275222832e-01 3.79473284555983281229885051288875e-01 2.83950324231521580159443018942511e-03
 	 3.27610666905009395577508257701993e-03 6.11881746863277342640685674268752e-01 3.84842146467672563403539243154228e-01 1.24870382507136484101506468391563e-03
 	 9.91699955792932685838536599476356e-01 4.46760885774417654953127865269380e-03 3.83243534932313761193212187095014e-03 1.76249771346883608922999353563199e-05
 	 9.72356946647436770625461122108391e-01 1.48792400295713073826719963221876e-02 1.27638133229919219918668815694218e-02 1.04340076293348300970516284724710e-04
 	 9.42465542363186470353753065865021e-01 3.09686847625307223874635553784174e-02 2.65657728742828072587833787565614e-02 3.07256963602904717598740536033119e-04
 	 9.02695871793453896714254369726405e-01 5.23752373150604411122799319855403e-02 4.49288908914856621734656982880551e-02 6.60386362771714363617547860485502e-04
 	 8.53936753035890450114209215826122e-01 7.86204795598678257695368642998801e-02 6.74427674042417241162539198739978e-02 1.18042745093685117960258246228022e-03
 	 7.97277508336594831206411981838755e-01 1.09118069352960020412801611655595e-01 9.36044223104451483807864065056492e-02 1.86420938255000157718344055979287e-03
 	 7.33983858235659480939716559078079e-01 1.43186715829460409210582838568371e-01 1.22829425934880109849700602353550e-01 2.68801156936464627489336010057741e-03
 	 6.65469698905513773468101135222241e-01 1.80065370625494325373949777713278e-01 1.54464930468991901157949087064480e-01 3.60884401247618669117400713730603e-03
 	 5.93265533483506413148234059917741e-01 2.18930220132044828229567201560712e-01 1.87804246384448758622198738521547e-01 4.56759234757015807754099157023120e-03
 	 5.18984288703573826140313940413762e-01 2.58913085146248223011866684828419e-01 2.22102626150177950847819374757819e-01 5.49376321863525793331994862001011e-03
 	 4.44285286963011227800990354808164e-01 2.99120813384204653484488289905130e-01 2.56593899652784174225672586544533e-01 6.31141966471998779042440474995601e-03
 	 3.70837180584396741700459187995875e-01 3.38655230606011103944297246925998e-01 2.90507588809592154355243565078126e-01 6.94578647562070147780666218295664e-03
 	 3.00280676835950333103397724698880e-01 3.76633204367839924397998174754321e-01 3.23086118796209798009755331804627e-01 7.32994179395038761293257323359285e-03
 	 2.34191886313592056989563161550905e-01 4.12206372241317231530643994119600e-01 3.53601741445090655968641613071668e-01 7.41099937828286221136453448821158e-03
 	 1.74047112635542122749399140957394e-01 4.44580094227313649124511130139581e-01 3.81372793137144283637240960160852e-01 7.15522709093951818359879979425386e-03
 	 1.21189867323676148114230954888626e-01 4.73031207433455114230724802837358e-01 4.05778925242868682143893011016189e-01 6.55163796429004702953635685958034e-03
 	 7.68008370896219316747988159477245e-02 4.96924191580633056730675889411941e-01 4.26274971329745011594525294640334e-01 5.61372361291451182907508155039977e-03
 	 4.18714311177650344575340568553656e-02 5.15725407528704438142597155092517e-01 4.42403161353530527399868788052117e-01 4.37917036272992155759853361018941e-03
 	 1.71812181452557499738986734882928e-02 5.29015242067374713563765453727683e-01 4.53803539787369536462335872784024e-01 2.90765605951039335722030365616320e-03
 	 3.27610666905009395577508257701993e-03 5.36499852709101276992953444278101e-01 4.60224040621848629051271473144880e-01 1.27867480106913077725350191826692e-03
 	 9.91699955792932685838536599476356e-01 3.83243534932308123341915262471957e-03 4.46760885774423292804424789892437e-03 1.76249771346882660246098428746819e-05
 	 9.72356946647436770625461122108391e-01 1.27638133229919757682946368504417e-02 1.48792400295712536062442410411677e-02 1.04340076293347758869430041972493e-04
 	 9.42465542363186470353753065865021e-01 2.65657728742828003198894748493331e-02 3.09686847625307293263574592856457e-02 3.07256963602903091295481807776468e-04
 	 9.02695871793453896714254369726405e-01 4.49288908914856482956778904735984e-02 5.23752373150604549900677397999971e-02 6.60386362771710894170595906871313e-04
 	 8.53936753035890561136511678341776e-01 6.74427674042416547273148808017140e-02 7.86204795598677841361734408565098e-02 1.18042745093684489122998204635451e-03
 	 7.97277508336594720184109519323101e-01 9.36044223104451761363620221345627e-02 1.09118069352960103679528458542336e-01 1.86420938254999181936388819025296e-03
 	 7.33983858235659480939716559078079e-01 1.22829425934880137605276217982464e-01 1.43186715829460381455007222939457e-01 2.68801156936463196342468329191888e-03
 	 6.65469698905513773468101135222241e-01 1.54464930468991873402373471435567e-01 1.80065370625494353129525393342192e-01 3.60884401247616760921577139242800e-03
 	 5.93265533483506524170536522433395e-01 1.87804246384448592088745044748066e-01 2.18930220132044883740718432818539e-01 4.56759234757013465877406588333542e-03
 	 5.18984288703573826140313940413762e-01 2.22102626150177950847819374757819e-01 2.58913085146248223011866684828419e-01 5.49376321863522931038259500269305e-03
 	 4.44285286963011227800990354808164e-01 2.56593899652784063203370124028879e-01 2.99120813384204764506790752420784e-01 6.31141966471995483067836119062122e-03
 	 3.70837180584396797211610419253702e-01 2.90507588809592098844092333820299e-01 3.38655230606011048433146015668171e-01 6.94578647562066504861366667000766e-03
 	 3.00280676835950277592246493441053e-01 3.23086118796209742498604100546800e-01 3.76633204367839979909149406012148e-01 7.32994179395034944901610174383677e-03
 	 2.34191886313592056989563161550905e-01 3.53601741445090544946339150556014e-01 4.12206372241317342552946456635254e-01 7.41099937828282318008632501005195e-03
 	 1.74047112635542067238247909699567e-01 3.81372793137144228126089728903025e-01 4.44580094227313704635662361397408e-01 7.15522709093948088704406629290133e-03
 	 1.21189867323676037091928492372972e-01 4.05778925242868682143893011016189e-01 4.73031207433455336275329727868666e-01 6.55163796429001233506683732343845e-03
 	 7.68008370896219316747988159477245e-02 4.26274971329744900572222832124680e-01 4.96924191580633167752978351927595e-01 5.61372361291448147141425195627562e-03
 	 4.18714311177650344575340568553656e-02 4.42403161353530416377566325536463e-01 5.15725407528704549164899617608171e-01 4.37917036272989900619334591169718e-03
 	 1.71812181452557499738986734882928e-02 4.53803539787369425440033410268370e-01 5.29015242067374824586067916243337e-01 2.90765605951037817838988885910112e-03
 	 3.27610666905009395577508257701993e-03 4.60224040621848518028969010629226e-01 5.36499852709101388015255906793755e-01 1.27867480106912405520003250813943e-03
 	 9.91699955792932685838536599476356e-01 3.20470578642358203819151540869825e-03 5.09533842064373212327188511494569e-03 1.72118636783010423572156527560750e-05
 	 9.72356946647436659603158659592737e-01 1.06731784582478790579518346248733e-02 1.69698748943154613388895057823902e-02 1.01894439670511123248800022800253e-04
 	 9.42465542363186470353753065865021e-01 2.22144611170195238614155641698744e-02 3.53199965197940057848313699651044e-02 3.00055139438080737280395426935797e-04
 	 9.02695871793453896714254369726405e-01 3.75698122717111337998119324765867e-02 5.97343159348349694859336977970088e-02 6.44907506215427767798376024188656e-04
 	 8.53936753035890561136511678341776e-01 5.63960529669387672369040842568211e-02 8.96671939971706716265842374014028e-02 1.15275930359433733188301296479494e-03
 	 7.97277508336594720184109519323101e-01 7.82725881771507286943645453902718e-02 1.24449903486254551121525935286627e-01 1.82051400776627033892274276638545e-03
 	 7.33983858235659480939716559078079e-01 1.02710714247566892165508534162655e-01 1.63305427516773626894774906759267e-01 2.62500701952929869908981430626227e-03
 	 6.65469698905513773468101135222241e-01 1.29164515863503970294345890579280e-01 2.05365785230982256237552974198479e-01 3.52425598650805667680363519878028e-03
 	 5.93265533483506413148234059917741e-01 1.57043054936195580761904011524166e-01 2.49691411580298006089861928558093e-01 4.46053213139777950113629145789673e-03
 	 5.18984288703573826140313940413762e-01 1.85723569043133029943248857307481e-01 2.95292142253293143916437202278757e-01 5.36499439842742006229192597288602e-03
 	 4.44285286963011172289839123550337e-01 2.14565382067961718526305503473850e-01 3.41149330969027109183855372975813e-01 6.16348572004145594388502260585483e-03
 	 3.70837180584396741700459187995875e-01 2.42924215544171540059892322460655e-01 3.86238603871431718239648489543470e-01 6.78298354904983014784791706119904e-03
 	 3.00280676835950222081095262183226e-01 2.70166580788435528592827949978528e-01 4.29552742375614193814925556580420e-01 7.15813461562179835506736225170243e-03
 	 2.34191886313592112500714392808732e-01 2.95683930349585954999724890512880e-01 4.70124183336821932499560716678388e-01 7.23729228379698611567372168451584e-03
 	 1.74047112635542067238247909699567e-01 3.18906252956622893179883249104023e-01 5.07046634407835039581868841196410e-01 6.98751506656721151078404119516563e-03
 	 1.21189867323676092603079723630799e-01 3.39314809306372811015251045319019e-01 5.39495323369951096381669231050182e-01 6.39807352084465104369304100373483e-03
 	 7.68008370896219316747988159477245e-02 3.56453727906791750790205242083175e-01 5.66745435003586317534995941969100e-01 5.48214303001719194252672195943887e-03
 	 4.18714311177650344575340568553656e-02 3.69940218658134534202019949589157e-01 5.88188350224100431340445993555477e-01 4.27652658675044955449706662875542e-03
 	 1.71812181452557499738986734882928e-02 3.79473284555983392252187513804529e-01 6.03345497298760857773913812707178e-01 2.83950324231520062276401539236304e-03
 	 3.27610666905009395577508257701993e-03 3.84842146467672674425841705669882e-01 6.11881746863277231618383211753098e-01 1.24870382507135811896159527378813e-03
 	 9.91699955792932796860839061992010e-01 2.59913357513953842403697791496597e-03 5.70091063192766471512396009302392e-03 1.63953200953990915506464781659091e-05
 	 9.72356946647436659603158659592737e-01 8.65633800201259795414898690069094e-03 1.89867153505507424426923535065725e-02 9.70604918539688991084568581158010e-05
 	 9.42465542363186470353753065865021e-01 1.80167402534984755213542939600302e-02 3.95177173833150541248926401749486e-02 2.85820301003135662874093947394272e-04
 	 9.02695871793453896714254369726405e-01 3.04704915193070163814681450276112e-02 6.68336366872390869042774852459843e-02 6.14312615644142107074188174919982e-04
 	 8.53936753035890561136511678341776e-01 4.57392611180388736213942024733115e-02 1.00323985846070565242094119184912e-01 1.09807154696475489825957527756373e-03
 	 7.97277508336594831206411981838755e-01 6.34819311046149192812038108968409e-02 1.39240560558790249512384207264404e-01 1.73414747254331687818795781907966e-03
 	 7.33983858235659480939716559078079e-01 8.33021449452111539812904084101319e-02 1.82713996819129365078993032511789e-01 2.50047473895055778758678144413352e-03
 	 6.65469698905513773468101135222241e-01 1.04757145357837061494521435633942e-01 2.29773155736649165037377429143817e-01 3.35706266775577912356287590966986e-03
 	 5.93265533483506635192838984949049e-01 1.27367659944430944296556162953493e-01 2.79366806572062420510604852097458e-01 4.24892117768028293456339383737941e-03
 	 5.18984288703573826140313940413762e-01 1.50628605608586652042646392146708e-01 3.30387105687839521817039667439531e-01 5.11047508371406840332884513600220e-03
 	 4.44285286963011172289839123550337e-01 1.74020370593161999295261921361089e-01 3.81694342443826828414898955088574e-01 5.87108538460582099482998330586270e-03
 	 3.70837180584396686189307956738048e-01 1.97020421503316167655128765545669e-01 4.32142397912287201666714508974110e-01 6.46119377698182052044417744696148e-03
 	 3.00280676835950333103397724698880e-01 2.19114975852906013198406753872405e-01 4.80604347311143709209346752686542e-01 6.81854739861966797909165194369052e-03
 	 2.34191886313592112500714392808732e-01 2.39810479407063570356228865421144e-01 5.25997634279344317143056741770124e-01 6.89394976828715169009376140252243e-03
 	 1.74047112635542067238247909699567e-01 2.58644632182139400100595594267361e-01 5.67308255182318532661156496033072e-01 6.65602216756004585324069111607059e-03
 	 1.21189867323676092603079723630799e-01 2.75196717635187937389673606958240e-01 6.03613415041135970007246669410961e-01 6.09454416609111256780684229283906e-03
 	 7.68008370896219316747988159477245e-02 2.89097007316895582285098953434499e-01 6.34102155593482486040102230617777e-01 5.22206609730510064315556206793190e-03
 	 4.18714311177650344575340568553656e-02 3.00035044459376232239833370840643e-01 6.58093524422858733302632572303992e-01 4.07364499259031329070346316711948e-03
 	 1.71812181452557499738986734882928e-02 3.07766709485877365537476180179510e-01 6.75052072368866884488625146332197e-01 2.70479510178624768870769834450130e-03
 	 3.27610666905009395577508257701993e-03 3.12121052812517785213231036323123e-01 6.84602840518432120830993881099857e-01 1.18946438915875718836390184662832e-03
 	 9.91699955792932685838536599476356e-01 2.02991275347174249948922764019699e-03 6.27013145359557166197417288344695e-03 1.51944862576347474066029707984171e-05
 	 9.72356946647436770625461122108391e-01 6.76056478078626912897597378560022e-03 2.08824885717769602455629041060092e-02 8.99515411137510358108304586721715e-05
 	 9.42465542363186470353753065865021e-01 1.40710008775138881165212012547272e-02 4.34634567592996415297257328802516e-02 2.64886114481161514047635741064823e-04
 	 9.02695871793453896714254369726405e-01 2.37973299761145284936247890072991e-02 7.35067982304315747921208412662963e-02 5.69318838667624252565524489710924e-04
 	 8.53936753035890561136511678341776e-01 3.57221769461758681396545966890699e-02 1.10341070017933570723833724969154e-01 1.01764606809584589111605801292626e-03
 	 7.97277508336594831206411981838755e-01 4.95791300596599981975742821305175e-02 1.53143361603745170596013736030727e-01 1.60713421799344672452614091184842e-03
 	 7.33983858235659480939716559078079e-01 6.50586364753329426946493185823783e-02 2.00957505289007576365634122339543e-01 2.31733377802174943596580369842286e-03
 	 6.65469698905513773468101135222241e-01 8.18149045563194010632912522851257e-02 2.52715396538166825468607612492633e-01 3.11118308605320232837487814947508e-03
 	 5.93265533483506413148234059917741e-01 9.94736245085718340241953683289466e-02 3.07260842007921752827570571753313e-01 3.93771967051459968744975270737996e-03
 	 5.18984288703573826140313940413762e-01 1.17640328487588374795080881085596e-01 3.63375382808837799064605178500642e-01 4.73617123530689024951678689490109e-03
 	 4.44285286963011116778687892292510e-01 1.35909201823909253636912808360648e-01 4.19805511213079574073248068089015e-01 5.44107255452897387720812005795779e-03
 	 3.70837180584396741700459187995875e-01 1.53872148060912428135793561523315e-01 4.75290671354690830163747250480810e-01 5.98795994716903867693957863593823e-03
 	 3.00280676835950277592246493441053e-01 1.71127905166085114707641423592577e-01 5.28591417997964607700112082966371e-01 6.31914010476876831373660436952377e-03
 	 2.34191886313592112500714392808732e-01 1.87291009288907517316147277597338e-01 5.78517104397500370183138329593930e-01 6.38901981818937921703271953788317e-03
 	 1.74047112635542067238247909699567e-01 2.02000406021974332482216141215758e-01 6.23952481342483600279535949084675e-01 6.16851862403614524532624585617668e-03
 	 1.21189867323676092603079723630799e-01 2.14927517455981154093080931488657e-01 6.63882615220342753303839344880544e-01 5.64816466158572436095930413557653e-03
 	 7.68008370896219316747988159477245e-02 2.25783587175420352721744166046847e-01 6.97415575734957715603457018005429e-01 4.83958904676885012102749428208881e-03
 	 4.18714311177650344575340568553656e-02 2.34326149706965858321439100109274e-01 7.23802419175269107221026843035361e-01 3.77528114719552498890209335513646e-03
 	 1.71812181452557499738986734882928e-02 2.40364548653823950630226136127021e-01 7.42454233200920299395875190384686e-01 2.50668921159654355113044488234664e-03
 	 3.27610666905009395577508257701993e-03 2.43765273086106182276466824987438e-01 7.52958620244843723767758092435542e-01 1.10234507224353842601283215429930e-03
 	 9.91699955792932796860839061992010e-01 1.51038526948466932803283313546672e-03 6.78965893758253381112810487252318e-03 1.36375105154569789387862185914280e-05
 	 9.72356946647436770625461122108391e-01 5.03029376057298818758489744595863e-03 2.26127595919902411869539804456508e-02 8.07342260225451927892204029291179e-05
 	 9.42465542363186470353753065865021e-01 1.04697270441572662380558256245422e-02 4.70647305926562634081911085104366e-02 2.37743291242918593263525051106910e-04
 	 9.02695871793453896714254369726405e-01 1.77067396554438649669549477039254e-02 7.95973885511022383187906825696700e-02 5.10980859591502975004806419434544e-04
 	 8.53936753035890450114209215826122e-01 2.65795905568608353819470835333050e-02 1.19483656407248714503843700640573e-01 9.13368094146468087815571301746331e-04
 	 7.97277508336594720184109519323101e-01 3.68900523374230127071626839097007e-02 1.65832439325982267108727796767198e-01 1.44245151997973003986375228890893e-03
 	 7.33983858235659480939716559078079e-01 4.84077978312326406840071513215662e-02 2.17608343933107878376276289600355e-01 2.07987708368329460989487600386383e-03
 	 6.65469698905513773468101135222241e-01 6.08755358843944271995951567078009e-02 2.73654765210091799332303708069958e-01 2.79238082368486262643814121986452e-03
 	 5.93265533483506524170536522433395e-01 7.40147560051711561612819423316978e-02 3.32719710511322319668181535234908e-01 3.53422238192368978054735961791266e-03
 	 5.18984288703573826140313940413762e-01 8.75319488195257511264912864135113e-02 3.93483762476900422733194773172727e-01 4.25085678642463972443099606834949e-03
 	 4.44285286963011227800990354808164e-01 1.01125162187966466387223363199155e-01 4.54589550849022361322937513250508e-01 4.88352701891903509534564875593787e-03
 	 3.70837180584396741700459187995875e-01 1.14490746175018531793909914995311e-01 5.14672073240584726505630897008814e-01 5.37437497793786817662509136539484e-03
 	 3.00280676835950277592246493441053e-01 1.27330136095044954558375138731208e-01 5.72389187069004767849378367827740e-01 5.67161917594473635045870807402935e-03
 	 2.34191886313592112500714392808732e-01 1.39356522122969339605447203211952e-01 6.26451591563438547893838403979316e-01 5.73433833014528378940743991165618e-03
 	 1.74047112635542067238247909699567e-01 1.50301256624800871897207343863556e-01 6.75651630739657060864544746436877e-01 5.53643184598070180191253797374884e-03
 	 1.21189867323676092603079723630799e-01 1.59919856563895512735484771837946e-01 7.18890276112428394661435504531255e-01 5.06939844226087302225813857603498e-03
 	 7.68008370896219316747988159477245e-02 1.67997468648797165791108909616014e-01 7.55201694261580902534092274436262e-01 4.34367739696613595901109050601008e-03
 	 4.18714311177650344575340568553656e-02 1.74353683017730465287797869677888e-01 7.83774885864504500254668073466746e-01 3.38842889918806317028909802502312e-03
 	 1.71812181452557499738986734882928e-02 1.78846639084442093903248860442545e-01 8.03972142770302156122852466069162e-01 2.24982930666402453426244711920390e-03
 	 3.27610666905009395577508257701993e-03 1.81376996154868352917333140794653e-01 8.15346897176081553126891776628327e-01 9.89388009537322220265931349558741e-04
 	 9.91699955792932796860839061992010e-01 1.05272819515161032005723384941120e-03 7.24731601191559281910370415857869e-03 1.17608916231590187055546653516203e-05
 	 9.72356946647436659603158659592737e-01 3.50608032178253287147740024920495e-03 2.41369730307808075253639401580585e-02 6.96246196440759683443655347900858e-05
 	 9.42465542363186470353753065865021e-01 7.29732809078985356077140522756963e-03 5.02371295460236760854755289074092e-02 2.05028115598662996057685581341445e-04
 	 9.02695871793453896714254369726405e-01 1.23414763478558037190779828051745e-02 8.49626518586902995666676474684209e-02 4.40666242152695829606412480927702e-04
 	 8.53936753035890561136511678341776e-01 1.85257926968128983080674743177951e-02 1.27537454267296540555420847340429e-01 7.87682118018000914684562108192267e-04
 	 7.97277508336594720184109519323101e-01 2.57121139889519845223020411140169e-02 1.77010377674453295293588439562882e-01 1.24395988394764098888822800859089e-03
 	 7.33983858235659480939716559078079e-01 3.37399037660932599180796387372538e-02 2.32276237998247259142203802184667e-01 1.79367113542948570549528941597828e-03
 	 6.65469698905513773468101135222241e-01 4.24298318549750086425831341330195e-02 2.92100469239511217889315730644739e-01 2.40812926968765866203581182958260e-03
 	 5.93265533483506635192838984949049e-01 5.15877783490932828591724046418676e-02 3.55146688167400081947988610409084e-01 3.04788812876340521954010576166638e-03
 	 5.18984288703573826140313940413762e-01 6.10091692236394700366020060755545e-02 4.20006542072786703823084053510684e-01 3.66590851857062421589872336369353e-03
 	 4.44285286963011172289839123550337e-01 7.04835459040686895804128653253429e-02 4.85231167132920138129748011124320e-01 4.21151880639639066700175007440521e-03
 	 3.70837180584396741700459187995875e-01 7.97992664636562043511958108865656e-02 5.49363552951947053948345001117559e-01 4.63482257895270199909987240971532e-03
 	 3.00280676835950277592246493441053e-01 8.87482333600090322889286653662566e-02 6.10971089804040690118824841192691e-01 4.89116385138723634012913876745188e-03
 	 2.34191886313592112500714392808732e-01 9.71305421080895792229625840263907e-02 6.68677571578318308276323023164878e-01 4.94525240181678885087457331337646e-03
 	 1.74047112635542067238247909699567e-01 1.04758947145737968398293560312595e-01 7.21193940218719964363458529987838e-01 4.77457926399284422747104628115267e-03
 	 1.21189867323676092603079723630799e-01 1.11463045469752497496074283844791e-01 7.67347087206571409900845992524410e-01 4.37181299376203976597698996897634e-03
 	 7.68008370896219316747988159477245e-02 1.17093085806530106118827916361624e-01 8.06106077103847962206373267690651e-01 3.74595634986187725479211962920090e-03
 	 4.18714311177650344575340568553656e-02 1.21523323717210307570724125980632e-01 8.36605245165024657971741817164002e-01 2.92215687100392000272175430097832e-03
 	 1.71812181452557499738986734882928e-02 1.24654883344125000377289325115271e-01 8.58163898510619249648812001396436e-01 1.94023671815265596335420283935491e-03
 	 3.27610666905009395577508257701993e-03 1.26418524903439077888833708129823e-01 8.70305368427510828155391209293157e-01 8.53241149858908402674184667802137e-04
 	 9.91699955792932796860839061992010e-01 6.67668123021216211587791633519373e-04 7.63237608404598692757314637447053e-03 9.60862926649648822156196681376628e-06
 	 9.72356946647436770625461122108391e-01 2.22364906572017698160870224910468e-03 2.54194042868430523929301756425048e-02 5.68832006464029999478863863782152e-05
 	 9.42465542363186470353753065865021e-01 4.62815888458841667718601797787414e-03 5.29062987522251129690609161571047e-02 1.67507635910582337174234979215726e-04
 	 9.02695871793453896714254369726405e-01 7.82729140003410317483201197319431e-03 8.94768368065120001109136183004011e-02 3.60023600826966960232466963276465e-04
 	 8.53936753035890561136511678341776e-01 1.17495487385325392271084865569719e-02 1.34313698225576899636379835101252e-01 6.43535005201482024003722948179984e-04
 	 7.97277508336594720184109519323101e-01 1.63073041692768372357136286154855e-02 1.86415187494128442580176852061413e-01 1.01631319548171525878055287961388e-03
 	 7.33983858235659480939716559078079e-01 2.13987412156085299308472258417169e-02 2.44617400548731989129436215080204e-01 1.46542639100762615844697478451053e-03
 	 6.65469698905513773468101135222241e-01 2.69101239286529403393899428920122e-02 3.07620177165833286192508921885747e-01 1.96743768411773538307141251380017e-03
 	 5.93265533483506413148234059917741e-01 3.27183363187239506508774411486229e-02 3.74016130197769636200888498933637e-01 2.49011962812194882418981300986616e-03
 	 5.18984288703573826140313940413762e-01 3.86936321172292041481455271423329e-02 4.42322079179196969711540532443905e-01 2.99504127820328456405229999859330e-03
 	 4.44285286963011172289839123550337e-01 4.47025329181687247626086900709197e-02 5.11012180118820102947552186378743e-01 3.44080399311350515131890936970649e-03
 	 3.70837180584396741700459187995875e-01 5.06108098022264307758177892537788e-02 5.78552009613376827523723022750346e-01 3.78664248460964863660094259500966e-03
 	 3.00280676835950277592246493441053e-01 5.62864817925698979195203719427809e-02 6.43432841371479824488233134616166e-01 3.99607288593017539318763553524150e-03
 	 2.34191886313592112500714392808732e-01 6.16027641664920189157328422879800e-02 7.04205349519915868583552764903288e-01 4.04026314337769480028450530539885e-03
 	 1.74047112635542067238247909699567e-01 6.64409008256879873854927609500010e-02 7.59511986538769945376259329350432e-01 3.90082346825385787442153073811824e-03
 	 1.21189867323676092603079723630799e-01 7.06928176691423715283235651440918e-02 8.08117315007181535868596711225109e-01 3.57176408264769798886484331035263e-03
 	 7.68008370896219316747988159477245e-02 7.42635384701072487345641093270388e-02 8.48935624440270819590637074725237e-01 3.06044022575842821973224339160424e-03
 	 4.18714311177650344575340568553656e-02 7.70733127727089017966477513255086e-02 8.81055256109526063745818191819126e-01 2.38739739568148831225236072839380e-03
 	 1.71812181452557499738986734882928e-02 7.90594308873947548832461507117841e-02 9.03759350967349495142855175799923e-01 1.58517023294915183374842460040099e-03
 	 3.27610666905009395577508257701993e-03 8.01779791081155268628322119184304e-02 9.16545914222834379181392705504550e-01 6.97096627246300711532034366513244e-04
 	 9.91699955792932685838536599476356e-01 3.64229062686263066472847071963770e-04 7.93581514438105109499055345168017e-03 7.23122046339592491941356336426772e-06
 	 9.72356946647436659603158659592737e-01 1.21305419118340751527540533061256e-03 2.64299991613799328815659350766509e-02 4.28089119820633070873268366529629e-05
 	 9.42465542363186470353753065865021e-01 2.52477228487239802046104841792840e-03 5.50096853519411316257858857170504e-02 1.26062168804368622543332634222679e-04
 	 9.02695871793453896714254369726405e-01 4.26997622277688892999947256612359e-03 9.30341519837692143557461577074719e-02 2.70944997189459491852142614121135e-04
 	 8.53936753035890450114209215826122e-01 6.40966219063640596509401348157553e-03 1.39653584773473143920696770692302e-01 4.84308778022126892870424796910811e-04
 	 7.97277508336594831206411981838755e-01 8.89602769357725198240416375483619e-03 1.93826463969827916811183854406408e-01 7.64852568722984181223689681417000e-04
 	 7.33983858235659480939716559078079e-01 1.16735293881617963052121922373772e-02 2.54342612376178722755071248684544e-01 1.10284422599214422880398167592375e-03
 	 6.65469698905513773468101135222241e-01 1.46801215714068011841675343021052e-02 3.19850179523079425347731330475654e-01 1.48064570369628965840202994286301e-03
 	 5.93265533483506524170536522433395e-01 1.78486415018559441136858367826790e-02 3.88885825014637531715777640783926e-01 1.87400341003528779493247924392563e-03
 	 5.18984288703573826140313940413762e-01 2.11083094610129418100541442981921e-02 4.59907401835413232049631915288046e-01 2.25399515154318941245747964785551e-03
 	 4.44285286963011172289839123550337e-01 2.43863097594207989260439717327245e-02 5.31328403277568028784116904716939e-01 2.58946531866860235257532529828950e-03
 	 3.70837180584396741700459187995875e-01 2.76094172845090524148758959199768e-02 6.01553402131094205884664916084148e-01 2.84973494791289404595713286028058e-03
 	 3.00280676835950277592246493441053e-01 3.07056332305439827479176528868265e-02 6.69013689933505739659835853672121e-01 3.00734716935292583847583181011487e-03
 	 2.34191886313592112500714392808732e-01 3.36057934737304941918978329340462e-02 7.32202320212677393307387774257222e-01 3.04060368129385836383216101808102e-03
 	 1.74047112635542067238247909699567e-01 3.62451136985048050220825643918943e-02 7.89707773665953127739669525908539e-01 2.93566477646165814585632602984333e-03
 	 1.21189867323676092603079723630799e-01 3.85646368764327451827966797281988e-02 8.40245495799891162214123596641002e-01 2.68802269382197988462079862870269e-03
 	 7.68008370896219316747988159477245e-02 4.05125511853632325198759644990787e-02 8.82686611725014835805325219553197e-01 2.30321280733247844146882599147830e-03
 	 4.18714311177650344575340568553656e-02 4.20453508283439303383488550025504e-02 9.16083218053891035204117088142084e-01 1.79669715867858273763979504167310e-03
 	 1.71812181452557499738986734882928e-02 4.31288261574084286209540550771635e-02 9.39689955697335821405147271434544e-01 1.19296052626739995487781254013271e-03
 	 3.27610666905009395577508257701993e-03 4.37390211868775580228430044371635e-02 9.52984872144072348021381912985817e-01 5.24617950812638266996912328465896e-04
 	 9.91699955792932685838536599476356e-01 1.49517298144375559987295787323092e-04 8.15052690892293860147610473632085e-03 4.68467040442820227628527990360041e-06
 	 9.72356946647436659603158659592737e-01 4.97962968223332469452913073837408e-04 2.71450903843400079273884273334261e-02 2.77333050517953070635349122063928e-05
 	 9.42465542363186470353753065865021e-01 1.03642781188245658441360319557134e-03 5.64980298249310730618333309394075e-02 8.16680551098174169113302900413487e-05
 	 9.02695871793453896714254369726405e-01 1.75284010359232078624103223774000e-03 9.55512881029537824995045980358555e-02 1.75528877315581175594383367410956e-04
 	 8.53936753035890561136511678341776e-01 2.63118864182348977109882071090396e-03 1.43432058322285949092389500947320e-01 3.13754366982687638108068250986094e-04
 	 7.97277508336594720184109519323101e-01 3.65185033602585806811191559972940e-03 1.99070641327379421747778565077169e-01 4.95501722093087009803069609148451e-04
 	 7.33983858235659480939716559078079e-01 4.79202445036724933302707540860865e-03 2.61224117313973269727256365513313e-01 7.14466075588802117246611800283063e-04
 	 6.65469698905513773468101135222241e-01 6.02624100778681448531415298930369e-03 3.28504060086699412046584711788455e-01 9.59220804103700936532606036166726e-04
 	 5.93265533483506524170536522433395e-01 7.32692946911761566752829821780324e-03 3.99407537047375860161935179348802e-01 1.21405347233280273833155860074839e-03
 	 5.18984288703573826140313940413762e-01 8.66503451352684805897297337651253e-03 4.72350676782899325800713086209726e-01 1.46022714030215284772284967118594e-03
 	 4.44285286963011172289839123550337e-01 1.00106650470149771692263129807543e-02 5.45704047989973850540934563468909e-01 1.67755797282982893961489345713289e-03
 	 3.70837180584396741700459187995875e-01 1.13337619059691308009973909065593e-02 6.17829057509634127498543421097565e-01 1.84617092488462445840080583536746e-03
 	 3.00280676835950277592246493441053e-01 1.26047693300016527828688595036510e-02 6.87114553834048069624884647055296e-01 1.94827835099531344528744902788731e-03
 	 2.34191886313592112500714392808732e-01 1.37952952055288013966105609142687e-02 7.52012818480879086102675046277000e-01 1.96982323377586617321743922559563e-03
 	 1.74047112635542067238247909699567e-01 1.48787453454919393891486834036186e-02 8.11074142018965993372603406896815e-01 1.90183966388901364540087168819582e-03
 	 1.21189867323676092603079723630799e-01 1.58309176844844134990353268221952e-02 8.62979214991839493897884949547006e-01 1.74140733558350276413695389976510e-03
 	 7.68008370896219316747988159477245e-02 1.66305432891521443039550831599627e-02 9.06568619621225924021246100892313e-01 1.49211228287504790376849506117196e-03
 	 4.18714311177650344575340568553656e-02 1.72597628783988099598900589626282e-02 9.40868806003836155582575884182006e-01 1.16397142744961170322814947297729e-03
 	 1.71812181452557499738986734882928e-02 1.77045332726475379558905842714012e-02 9.65114248582096712070210742240306e-01 7.72846976433000419984264972583787e-04
 	 3.27610666905009395577508257701993e-03 1.79550204563841964144899066013750e-02 9.78768872874565709629735010821605e-01 3.39868242192904951651244438437516e-04
 	 9.91699955792932685838536599476356e-01 2.85164652640956112206183092894207e-05 8.27152774180321855024278221435452e-03 2.03233773672140111861959300976199e-06
 	 9.72356946647436659603158659592737e-01 9.49732496666327863366063866124023e-05 2.75480801028967076105047340206511e-02 1.20314638074627667336732872449545e-05
 	 9.42465542363186470353753065865021e-01 1.97671159545359520492979754635599e-04 5.73367864772681701257539543803432e-02 3.54298287724648768557723921279745e-05
 	 9.02695871793453896714254369726405e-01 3.34307832926039605325740922125988e-04 9.69698203736200636804198893514695e-02 7.61492123150419772913133353853254e-05
 	 8.53936753035890561136511678341776e-01 5.01829557108424140210445330012590e-04 1.45561417407001014723277876328211e-01 1.36115198088921182011448718363056e-04
 	 7.97277508336594831206411981838755e-01 6.96493747207760360851125369663350e-04 2.02025997916197408432736892791581e-01 2.14962155601880819518964549352802e-04
 	 7.33983858235659480939716559078079e-01 9.13951766648712915497299036360346e-04 2.65102189997691806144786141885561e-01 3.09954861638467641087729687043861e-04
 	 6.65469698905513773468101135222241e-01 1.14934589177556611971908751002047e-03 3.33380955202710660412179777267738e-01 4.16136135465466970410897129539762e-04
 	 5.93265533483506524170536522433395e-01 1.39741777233570729777056840248406e-03 4.05337048744157768531692909164121e-01 5.26689494289143359667670907242609e-04
 	 5.18984288703573826140313940413762e-01 1.65262587529219073800845762889367e-03 4.79363085421133983121677601957344e-01 6.33486342735154980311540473536525e-04
 	 4.44285286963011172289839123550337e-01 1.90926926600853974491656117606908e-03 5.53805443770980287965244315273594e-01 7.27770382842131673822860804534685e-04
 	 3.70837180584396741700459187995875e-01 2.16161495502020795100861505488865e-03 6.27001204460583050348532196949236e-01 8.00919278234439157432289491111987e-04
 	 3.00280676835950277592246493441053e-01 2.40402596369715393365140698733740e-03 6.97315297200352568474102099571610e-01 8.45216263373049802622161141840706e-04
 	 2.34191886313592112500714392808732e-01 2.63108724822291861755729769356549e-03 7.63177026438184968881728309497703e-01 8.54563020888107240102815609361642e-04
 	 1.74047112635542067238247909699567e-01 2.83772667165471670358556366409175e-03 8.23115160692803216058166526636342e-01 8.25069894877046594063030315879814e-04
 	 1.21189867323676092603079723630799e-01 3.01932833090945429432849778095260e-03 8.75790804345414453102591778588248e-01 7.55469977090479530117128614818967e-04
 	 7.68008370896219316747988159477245e-02 3.17183574017099179087608717964031e-03 9.20027327170207076534325096872635e-01 6.47318986848257000091266810670732e-04
 	 4.18714311177650344575340568553656e-02 3.29184271450067011954843110288493e-03 9.54836726167734295422917512041749e-01 5.04962537862908475948253705922752e-04
 	 1.71812181452557499738986734882928e-02 3.37667088927040559553915954893455e-03 9.79442110965473844430562166962773e-01 3.35282088027180169391427977387821e-04
 	 3.27610666905009395577508257701993e-03 3.42444468643487986980744608445093e-03 9.93299448644515026174417471338529e-01 1.47444109081590270411699084007751e-04
 	 ];
 
 	 case  40 

 	 % ALG. DEG.:   40
 	 % PTS CARD.:  441
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 9.92435490725621538565803803066956e-01 7.54087839273511698762186838962407e-03 2.36308816433444465743285434200516e-05 1.53544142945723091170330196209015e-06
 	 9.74791975660365683786778845387744e-01 2.51292766220987638658979079764322e-02 7.87477175355523473232466358240345e-05 9.10577066635841883882572511677012e-06
 	 9.47485544406397428573995966871735e-01 5.23504049143466432258975373770227e-02 1.64050679255928200106495751242619e-04 2.68890183865504129798185140032274e-05
 	 9.11074265802615856912893832486589e-01 8.86479377900232096143540161392593e-02 2.77796407360933472752151374152163e-04 5.80152475764312181190363038041369e-05
 	 8.66299758970956568226995386794442e-01 1.33282572882062244623568858514773e-01 4.17668146981187149435754690784961e-04 1.04217656115977841250509750015141e-04
 	 8.14073616512697384450802928768098e-01 1.85345565326704209141439605446067e-01 5.80818160598406407757465785834938e-04 1.65605482698418329280676264403382e-04
 	 7.55459054449687084087372568319552e-01 2.43777020498249508140276020640158e-01 7.63925052063407772351411040290259e-04 2.40576728048201880305959066141952e-04
 	 6.91649315012962340176727593643591e-01 3.07387423752595090320482995593920e-01 9.63261234442569502789410762488842e-04 3.25879308606591075458958073340909e-04
 	 6.23943389721281937987384935695445e-01 3.74881841509669966328033297031652e-01 1.17476876904809568458176727290265e-03 4.16817080492601073175851222885058e-04
 	 5.53719580728293414573215613927459e-01 4.44886277314171185714997136528837e-01 1.39414195753539971178724954370409e-03 5.07585211482041256426944730861806e-04
 	 4.82407444612438895958916873496491e-01 5.15975640400452073563997146266047e-01 1.61691498710903047708598023746163e-03 5.91708648892600276927855595943129e-04
 	 4.11458691561905287592537661112146e-01 5.86702755599107672601633112208219e-01 1.83855283898703980582922667963430e-03 6.62548809106855299613791920876338e-04
 	 3.42317632958730744263675660477020e-01 6.55627823433643119876990112970816e-01 2.05454360762613585933422655216418e-03 7.13837804583759795093444999736221e-04
 	 2.76391779093783207521539679873968e-01 7.21347730555263910723340359254507e-01 2.26049035095288175511996087152511e-03 7.40197003545149255672452870413736e-04
 	 2.15023185358020230140141393349040e-01 7.82524614039563082279471473157173e-01 2.45220060241668758038713349378668e-03 7.37597697506709392388513091276536e-04
 	 1.59461129444065097260363472742029e-01 8.37913098830852853815542857773835e-01 2.62577172508204892409366948413663e-03 7.03726063498771783194518647519544e-04
 	 1.10836673320363510164554554648930e-01 8.86385656301785784805247203621548e-01 2.77767037785070503019824172952212e-03 6.38222117915249100711383434259005e-04
 	 7.01396190623257975715887369005941e-02 9.26955576434195016588546423008665e-01 2.90480450347918583986484009074047e-03 5.42772455869645919536436995400663e-04
 	 3.81982882450735417023679474368691e-02 9.58797125258895377442058816086501e-01 3.00458649603108085557323647662997e-03 4.21049045024146195281139481991772e-04
 	 1.56622805575734602712145715486258e-02 9.81262732380930868814061796001624e-01 3.07498706149567091472363244974986e-03 2.78506380891723305873175497993088e-04
 	 2.98523728321309356203983043087646e-03 9.93900173653583185462423443823354e-01 3.11458906320372097553672574576922e-03 1.22221156549900803779673541527018e-04
 	 9.92435490725621427543501340551302e-01 7.44055283257057629986430669077890e-03 1.23956441807996156634352757919260e-04 3.54245933668821326204228898404391e-06
 	 9.74791975660365683786778845387744e-01 2.47949510140806558822212934956042e-02 4.13073325553660330999861116652028e-04 2.10081750407018895843852535065821e-05
 	 9.47485544406397317551693504356081e-01 5.16539232282167831700192550670181e-02 8.60532365385899278287240576901240e-04 6.20363970975356537754588637234576e-05
 	 9.11074265802615856912893832486589e-01 8.74685454761538333512405074543494e-02 1.45718872123030973586566005906207e-03 1.33848580287465509499819638072893e-04
 	 8.66299758970956679249297849310096e-01 1.31509351237559052316683505523542e-01 2.19088979148426843401864516636124e-03 2.40443433316966335153500033960938e-04
 	 8.14073616512697495473105391283752e-01 1.82879685796896424010427040229843e-01 3.04669769040608051646756848640507e-03 3.82072983792776637440580245197452e-04
 	 7.55459054449686862042767643288244e-01 2.40533755607478749727334843555582e-01 4.00718994283438822989751315617468e-03 5.55041214932902463377595303484213e-04
 	 6.91649315012962340176727593643591e-01 3.03297871598402490889156979392283e-01 5.05281338863516893411542696412653e-03 7.51845154923946835598402849143440e-04
 	 6.23943389721281937987384935695445e-01 3.69894328280282014276281188358553e-01 6.16228199843604773633387594600208e-03 9.61650200492565349758011805647584e-04
 	 5.53719580728293525595518076443113e-01 4.38967409158962429405193006459740e-01 7.31301011274404499928891709714662e-03 1.17106386286257475870531408190800e-03
 	 4.82407444612438895958916873496491e-01 5.09110983200263711445643366459990e-01 8.48157218729739259543976004351862e-03 1.36514736912479923459928787821127e-03
 	 4.11458691561905287592537661112146e-01 5.78897128782175141026300480007194e-01 9.64417965591957138116185888065957e-03 1.52858465963231484815998406645576e-03
 	 3.42317632958730744263675660477020e-01 6.46905201847700506156968458526535e-01 1.07771651935687495793558809964452e-02 1.64691491789605449352906774151961e-03
 	 2.76391779093783207521539679873968e-01 7.11750756386963057131822552037193e-01 1.18574645192537353466377680888399e-02 1.70772895396215486710222997146502e-03
 	 2.15023185358020230140141393349040e-01 7.72113728707995550237797033332754e-01 1.28630859339842196220615733182058e-02 1.70173202319805769514027282696134e-03
 	 1.59461129444065097260363472742029e-01 8.26765312507922733864518249902176e-01 1.37735580480121688751182773557957e-02 1.62358584071376713803269709046617e-03
 	 1.10836673320363510164554554648930e-01 8.74592980056540514333107694255887e-01 1.45703466230959755023377510951832e-02 1.47245987838754994331269543295093e-03
 	 7.01396190623257975715887369005941e-02 9.14623148750040915189174484112300e-01 1.52372321876332872392367789871059e-02 1.25224532639600476258134875706673e-03
 	 3.81982882450735417023679474368691e-02 9.46041070371652748072222038899781e-01 1.57606413832737102254100136633497e-02 9.71413882766401608204187567707777e-04
 	 1.56622805575734602712145715486258e-02 9.68207789950146113788775892317062e-01 1.61299294922804259400095361343119e-02 6.42549764770828876238317750591023e-04
 	 2.98523728321309356203983043087646e-03 9.80677099831640308735813960083760e-01 1.63376628851465977021462094853632e-02 2.81979806493874414832778718675854e-04
 	 9.92435490725621427543501340551302e-01 7.26230461045436134770447722530662e-03 3.02204663924211108794182223391545e-04 5.47701277879045602873077716599148e-06
 	 9.74791975660365683786778845387744e-01 2.42009553748894733204988227726062e-02 1.00706896474484289272233183965000e-03 3.24808366790063312678875362404796e-05
 	 9.47485544406397428573995966871735e-01 5.04164856092736007875387826970837e-02 2.09796998432897063846525043118163e-03 9.59147607241050639435495095419526e-05
 	 9.11074265802615856912893832486589e-01 8.53731215106164065264948703770642e-02 3.55261268676773656061129713634728e-03 2.06943909578581955455156560219621e-04
 	 8.66299758970956568226995386794442e-01 1.28358871887807146627835663821315e-01 5.34136914123628514516894938424230e-03 3.71750705283870541088125927231545e-04
 	 8.14073616512697384450802928768098e-01 1.78498562567480867357971874298528e-01 7.42782091982174819122519693337381e-03 5.90724808889405914036352385210193e-04
 	 7.55459054449686973065070105803898e-01 2.34771453361832721506985421910940e-01 9.76949218848030542794447228516219e-03 8.58151791739380359613775794969115e-04
 	 6.91649315012962340176727593643591e-01 2.96031972464215475948634548331029e-01 1.23187125228221838746378580253804e-02 1.16243127438122456629443490783160e-03
 	 6.23943389721281826965082473179791e-01 3.61033023499511662723904237282113e-01 1.50235867792065103110132895380957e-02 1.48681182653974744423130971426872e-03
 	 5.53719580728293525595518076443113e-01 4.28451367943982697195082209873362e-01 1.78290513277237772093997136835242e-02 1.81058725932315561779617496540595e-03
 	 4.82407444612438895958916873496491e-01 4.96914560480430256284023471380351e-01 2.06779949071308477570596551231574e-02 2.11066066678375872933681733911726e-03
 	 4.11458691561905287592537661112146e-01 5.65028887225995646303999819792807e-01 2.35124212120990661034625190950464e-02 2.36335181820214370457255981250455e-03
 	 3.42317632958730744263675660477020e-01 6.31407737519200318310197417304153e-01 2.62746295220689374261269222188275e-02 2.54630277826424890677547985262663e-03
 	 2.76391779093783207521539679873968e-01 6.94699831573891479763460665708408e-01 2.89083893323253127149996544176247e-02 2.64032764093924138953939362295387e-03
 	 2.15023185358020230140141393349040e-01 7.53616729558784004261440259142546e-01 3.13600850831957655984183475084137e-02 2.63105575852458318727999930786154e-03
 	 1.59461129444065097260363472742029e-01 8.06959062840990282161612867639633e-01 3.35798077149446205780236596183386e-02 2.51023358404048931719065862466778e-03
 	 1.10836673320363510164554554648930e-01 8.53640955754262686916433722217334e-01 3.55223709253738029190117231337354e-02 2.27657703411336545876175740943381e-03
 	 7.01396190623257975715887369005941e-02 8.92712149145633127034216158790514e-01 3.71482317920410753941951043088920e-02 1.93610229588789066988707698868666e-03
 	 3.81982882450735417023679474368691e-02 9.23377413162674964830500812240643e-01 3.84242985922514934671312403224874e-02 1.50190750090021716244004235107923e-03
 	 1.56622805575734602712145715486258e-02 9.45013099840263604001222574879648e-01 3.93246196021629357275628535717260e-02 9.93449165728102013064870767777848e-04
 	 2.98523728321309356203983043087646e-03 9.57183691015311199912218853569357e-01 3.98310717014757065257413159997668e-02 4.35970284127989678776143867011683e-04
 	 9.92435490725621427543501340551302e-01 7.00989218009193722908056756182305e-03 5.54617094286635227418091886875118e-04 7.29509908774019711816781474933435e-06
 	 9.74791975660365683786778845387744e-01 2.33598144023014035741692140391024e-02 1.84820993733291263905194057315384e-03 4.32628024794175656468457613623713e-05
 	 9.47485544406397317551693504356081e-01 4.86641840541102779771343023185182e-02 3.85027153949240447117219332540117e-03 1.27753523995567810174131540001952e-04
 	 9.11074265802615856912893832486589e-01 8.24058489650528053216405055536598e-02 6.51988523233133776546566195975174e-03 2.75638634955586135383970303180945e-04
 	 8.66299758970956679249297849310096e-01 1.23897564279594141201101820115582e-01 9.80267674944917954960033057432156e-03 4.95152803273547943707644236610577e-04
 	 8.14073616512697384450802928768098e-01 1.72294573832417585723675301778712e-01 1.36318096548850298255217694531893e-02 7.86815037409186813013861616639133e-04
 	 7.55459054449686973065070105803898e-01 2.26611614811756956200383683608379e-01 1.79293307385560707345462105877232e-02 1.14301401254774770248345827639014e-03
 	 6.91649315012962340176727593643591e-01 2.85742931499573304954253671894548e-01 2.26077534874643548690187344618607e-02 1.54829862039720868478742676899174e-03
 	 6.23943389721281937987384935695445e-01 3.48484772249981089586867710750084e-01 2.75718380287369724257473535544705e-02 1.98035681812427227788120376317238e-03
 	 5.53719580728293414573215613927459e-01 4.13559889704531724596847652719589e-01 3.27205295671748608299367333529517e-02 2.41160902799268661578224737240816e-03
 	 4.82407444612438840447765642238664e-01 4.79643539968183596489126330197905e-01 3.79490154193775075519567963056033e-02 2.81129136021181528712342689857451e-03
 	 4.11458691561905287592537661112146e-01 5.45390449801547494423914486105787e-01 4.31508586365472179835478527820669e-02 3.14786296642219484351321590054340e-03
 	 3.42317632958730744263675660477020e-01 6.09462202303363453914641922892770e-01 4.82201647379058018216824166302104e-02 3.39154422767807975716558566148251e-03
 	 2.76391779093783207521539679873968e-01 6.70554483469447015764330899401102e-01 5.30537374367697767141294207249302e-02 3.51678050475624174447952796640493e-03
 	 2.15023185358020230140141393349040e-01 7.27423635152377179302618515066570e-01 5.75531794896025905572400915843900e-02 3.50443083465747226221131960244293e-03
 	 1.59461129444065097260363472742029e-01 7.78911974598304412964466791891027e-01 6.16268959576304897751697353669442e-02 3.34350191766262256481967440890912e-03
 	 1.10836673320363510164554554648930e-01 8.23971367399533138886624783481238e-01 6.51919592801033509488206618698314e-02 3.03228342081728269655216401190501e-03
 	 7.01396190623257975715887369005941e-02 8.61684582103686369514150555914966e-01 6.81757988339878329142607071844395e-02 2.57878859571012515258803254880604e-03
 	 3.81982882450735417023679474368691e-02 8.91284028280052043058390154328663e-01 7.05176834748744152392418982344680e-02 2.00046347931051972726668175539544e-03
 	 1.56622805575734602712145715486258e-02 9.12167733796042434768480688944692e-01 7.21699856463841049603047395066824e-02 1.32322315016030205188368729096737e-03
 	 2.98523728321309356203983043087646e-03 9.23915317584010908902314440638293e-01 7.30994451327759975356457289308310e-02 5.80689976539784918213582542989570e-04
 	 9.92435490725621538565803803066956e-01 6.68869025244668569118999812417314e-03 8.75819021931775743006198808870977e-04 8.95775703617753770683241471006752e-06
 	 9.74791975660365683786778845387744e-01 2.22894388212384539360577662137075e-02 2.91858551839586227716338839854870e-03 5.31230170630635334231596511589402e-05
 	 9.47485544406397428573995966871735e-01 4.64343309659478661877152205761377e-02 6.08012462765470523828881255212764e-03 1.56870388558665854392137894990356e-04
 	 9.11074265802615856912893832486589e-01 7.86299110680349216950801860548381e-02 1.02958231293492213920259814585734e-02 3.38460642140589191683569536550635e-04
 	 8.66299758970956568226995386794442e-01 1.18220424681045405135293435705535e-01 1.54798163479980266377111775000230e-02 6.08005244913078753479784843705147e-04
 	 8.14073616512697495473105391283752e-01 1.64399823411725098942781642108457e-01 2.15265600755774055841129666077904e-02 9.66141494824537794793017919658951e-04
 	 7.55459054449687084087372568319552e-01 2.16227990408651649101301472910563e-01 2.83129551416612668113259587698849e-02 1.40352333672287294535907520298679e-03
 	 6.91649315012962340176727593643591e-01 2.72649837048088539148693598690443e-01 3.57008479389491206745788076659665e-02 1.90117813262812821069325242007153e-03
 	 6.23943389721281937987384935695445e-01 3.32516769073041729143369593657553e-01 4.35398412056763328692454706470016e-02 2.43170860441184813471870995726931e-03
 	 5.53719580728293525595518076443113e-01 3.94610064178383457278442847382394e-01 5.16703550933230171260390761744929e-02 2.96124939211793534316052856070201e-03
 	 4.82407444612438895958916873496491e-01 4.57665679872430675168004654551623e-01 5.99268755151304288730784719518851e-02 3.45202507324453723019930251325604e-03
 	 4.11458691561905287592537661112146e-01 5.20399984999095899240728613222018e-01 6.81413234389988131667337256658357e-02 3.86530618669443486179471136665597e-03
 	 3.42317632958730744263675660477020e-01 5.81535890574529812369064529775642e-01 7.61464764667394433672598097473383e-02 4.16452591028501541842166133733372e-03
 	 2.76391779093783207521539679873968e-01 6.39828847875045125803694645583164e-01 8.37793730311716666747656745428685e-02 4.31830533516861913428952490789925e-03
 	 2.15023185358020230140141393349040e-01 6.94092184707358339501581667718710e-01 9.08846299346214303582769389322493e-02 4.30314099772903090740383547085912e-03
 	 1.59461129444065097260363472742029e-01 7.43221264772912504348312268120935e-01 9.73176057830223983913242591370363e-02 4.10553406721349267716192343868897e-03
 	 1.10836673320363510164554554648930e-01 7.86215980478624287819400251464685e-01 1.02947346201012202016045193886384e-01 3.72338440120141295902600475642430e-03
 	 7.01396190623257975715887369005941e-02 8.22201129051450263496292336640181e-01 1.07659251886223938932118926459225e-01 3.16653158650823801645302069118770e-03
 	 3.81982882450735417023679474368691e-02 8.50444292003363355725298333709361e-01 1.11357419751563102572333718853770e-01 2.45639786271374411380508107072274e-03
 	 1.56622805575734602712145715486258e-02 8.70371080309248368322982969402801e-01 1.13966639133178171405802459048573e-01 1.62480472728619121554338722290822e-03
 	 2.98523728321309356203983043087646e-03 8.81580375281793116037931667960947e-01 1.15434387434993790400028501608176e-01 7.13037569555254871142557782093263e-04
 	 9.92435490725621427543501340551302e-01 6.30554347301381760970695466994584e-03 1.25896580136475484679170477875232e-03 1.04295123891495146499714188892405e-05
 	 9.74791975660365683786778845387744e-01 2.10126377768786072597340108814024e-02 4.19538656275570895348714373085386e-03 6.18511042854368140071763537690686e-05
 	 9.47485544406397428573995966871735e-01 4.37744433506983970927350924284838e-02 8.74001224290417433326894069978152e-03 1.82644121107068365447018143399305e-04
 	 9.11074265802615856912893832486589e-01 7.41257710861019658565851386811119e-02 1.47999631112821772305210288322996e-02 3.94069569668870111397301903011225e-04
 	 8.66299758970956679249297849310096e-01 1.11448429975032584082761388799554e-01 2.22518110540107366679407618903497e-02 7.07900226460569719985627124003713e-04
 	 8.14073616512697384450802928768098e-01 1.54982544317885551077296213406953e-01 3.09438391694170644719008578249486e-02 1.12487809718980194192972099642702e-03
 	 7.55459054449686973065070105803898e-01 2.03841849771026678572738433103950e-01 4.06990957792863483621914610921522e-02 1.63412157414999934315624763314645e-03
 	 6.91649315012962340176727593643591e-01 2.57031696121371444618830537365284e-01 5.13189888656662152044418689911254e-02 2.21354082368440535644182887153875e-03
 	 6.23943389721281937987384935695445e-01 3.13469283785297148092752195225330e-01 6.25873264934209139198628690792248e-02 2.83123720749375732200214805800442e-03
 	 5.53719580728293414573215613927459e-01 3.72005702260676307524533967807656e-01 7.42747170110302779022504182648845e-02 3.44778130258760516849148025642080e-03
 	 4.82407444612438895958916873496491e-01 4.31449316925150760937412997009233e-01 8.61432384624103431036701294942759e-02 4.01919120195538045331451471042783e-03
 	 4.11458691561905232081386429854319e-01 4.90590026585132787939613763228408e-01 9.79512818529620354901510381750995e-02 4.50037421188958543238900489313892e-03
 	 3.42317632958730744263675660477020e-01 5.48223897465452636446059386798879e-01 1.09458469575816619290264952724101e-01 4.84875559817437521564764679737891e-03
 	 2.76391779093783207521539679873968e-01 6.03177672054503566378969026118284e-01 1.20430548851713226099491294007748e-01 5.02780091169900082009869279886516e-03
 	 2.15023185358020230140141393349040e-01 6.54332654042461880905534599150997e-01 1.30644160599517888954324007499963e-01 5.01014508060638585201784778178080e-03
 	 1.59461129444065097260363472742029e-01 7.00647483770032386551918079931056e-01 1.39891386785902516187718447326915e-01 4.78007142247186510297662920265793e-03
 	 1.10836673320363510164554554648930e-01 7.41179342588441092409823340858566e-01 1.47983984091195397425622104492504e-01 4.33513474244296651699537292756759e-03
 	 7.01396190623257975715887369005941e-02 7.75103161773492255193218625208829e-01 1.54757219164181947235192637890577e-01 3.68679126691446408178864935223373e-03
 	 3.81982882450735417023679474368691e-02 8.01728477805066175321258015173953e-01 1.60073233949860282976374037389178e-01 2.85998289955691426325601334212934e-03
 	 1.56622805575734602712145715486258e-02 8.20513804258827361692851809493732e-01 1.63823915183599178035933618957642e-01 1.89175939520806746241277096487465e-03
 	 2.98523728321309356203983043087646e-03 8.31080999641415463230487148393877e-01 1.65933763075371443207473021175247e-01 8.30189313638602234372843025056454e-04
 	 9.92435490725621538565803803066956e-01 5.86861753718463489970513791149642e-03 1.69589173719382653449105902154770e-03 1.16789871885318096518448921505851e-05
 	 9.74791975660365683786778845387744e-01 1.95566226904400480846035748072609e-02 5.65140164919426812861757980499533e-03 6.92609805322899494068114578659845e-05
 	 9.47485544406397317551693504356081e-01 4.07412092276984022509722649374453e-02 1.17732463659042801973342307064740e-02 2.04525223316221523711666563372091e-04
 	 9.11074265802615856912893832486589e-01 6.89894220878807529206966364654363e-02 1.99363121095033901664095310479752e-02 4.41279830142498078957014051582064e-04
 	 8.66299758970956679249297849310096e-01 1.03725906171662482502249247318105e-01 2.99743348573808382484529033717990e-02 7.92707977814286488330020041814805e-04
 	 8.14073616512697495473105391283752e-01 1.44243439353644586908842484263005e-01 4.16829441336579176180521244532429e-02 1.25964056569005558409990452872762e-03
 	 7.55459054449687084087372568319552e-01 1.89717168630768318049462095586932e-01 5.48237769195445978631653360935161e-02 1.82989234941189531438721083134169e-03
 	 6.91649315012962340176727593643591e-01 2.39221365442307071225158665583876e-01 6.91293195447305885981137407725328e-02 2.47872709255302385231156669931352e-03
 	 6.23943389721281937987384935695445e-01 2.91748259934179188235248147975653e-01 8.43083503445388737773669163289014e-02 3.17042464117639997966957565722623e-03
 	 5.53719580728293525595518076443113e-01 3.46228552314812754175932241196278e-01 1.00051866956893720228549682360608e-01 3.86083185477319656628281130394953e-03
 	 4.82407444612438895958916873496491e-01 4.01553179127169368456407028133981e-01 1.16039376260391735584676098369528e-01 4.50069771284143660405874243224389e-03
 	 4.11458691561905287592537661112146e-01 4.56595889935128784742346397251822e-01 1.31945418502965927665115941636031e-01 5.03952733388942763353979259477455e-03
 	 3.42317632958730744263675660477020e-01 5.10236174366062611440497676085215e-01 1.47446192675206644295826663437765e-01 5.42964545210327439311859265558269e-03
 	 2.76391779093783318543842142389622e-01 5.61382072680463029001884933677502e-01 1.62226148225753652454272923932876e-01 5.63014072405829211348526897040756e-03
 	 2.15023185358020230140141393349040e-01 6.08992405666623159987693725270219e-01 1.75984408975356609872164881380741e-01 5.61036969187196903757763877251818e-03
 	 1.59461129444065097260363472742029e-01 6.52097971924979091795648855622858e-01 1.88440898630955810943987671635114e-01 5.35273278560900647032871901842555e-03
 	 1.10836673320363621186857017164584e-01 6.89821282928132495371187360433396e-01 1.99342043751503883441955622402020e-01 4.85449187156862180247962612611445e-03
 	 7.01396190623257975715887369005941e-02 7.21394440904080336274262208462460e-01 2.08465940033593866154149054636946e-01 4.12847565317444285815096094438559e-03
 	 3.81982882450735417023679474368691e-02 7.46174826173757077540926729852799e-01 2.15626885581169380756705322710332e-01 3.20261412010931388258394569845677e-03
 	 1.56622805575734602712145715486258e-02 7.63658473180569230542857894761255e-01 2.20679246261857309185927533690119e-01 2.11839565610040655649348728672976e-03
 	 2.98523728321309356203983043087646e-03 7.73493442744496717544677721889457e-01 2.23521319972290188893282447679667e-01 9.29647522939651459530918664597721e-04
 	 9.92435490725621427543501340551302e-01 5.38722458909856542069727325383610e-03 2.17728468528000703580138619486206e-03 1.26795476058342318449387309264864e-05
 	 9.74791975660365683786778845387744e-01 1.79524254170777310124496040089070e-02 7.25559892255658520077155060334917e-03 7.51946967411930592903313019803591e-05
 	 9.47485544406397428573995966871735e-01 3.73992755108656788065601972448349e-02 1.51151800827368926194438358834304e-02 2.22047277196980630308356663427105e-04
 	 9.11074265802615856912893832486589e-01 6.33303343938526330791916052476154e-02 2.55953998035315100079145622657961e-02 4.79085088754998113594330000353239e-04
 	 8.66299758970956679249297849310096e-01 9.52174423897766131208442175193341e-02 3.84827986392667076298579331705696e-02 8.60620735340012605295301195695856e-04
 	 8.14073616512697495473105391283752e-01 1.32411389629402936884972064035537e-01 5.35149938578995676419225446807104e-02 1.36755630099418359381380216888147e-03
 	 7.55459054449686973065070105803898e-01 1.74154984431332343630671743994753e-01 7.03859611189806833042581502013491e-02 1.98666260895494434582375653519648e-03
 	 6.91649315012962340176727593643591e-01 2.19598434210926646281691887452325e-01 8.87522507761110135415805189040839e-02 2.69108422370383350633038510579809e-03
 	 6.23943389721281937987384935695445e-01 2.67816634801205877280949607666116e-01 1.08239975477512184731665456638439e-01 3.44204077969877857492986272802682e-03
 	 5.53719580728293525595518076443113e-01 3.17827999296263596917810900777113e-01 1.28452419975442877486671022779774e-01 4.19159645528064707387105869429433e-03
 	 4.82407444612438895958916873496491e-01 3.68614438872152505588530857494334e-01 1.48978116515408598452552269009175e-01 4.88628080399634671937558749732489e-03
 	 4.11458691561905287592537661112146e-01 4.19142087545188002373208746575983e-01 1.69399220892906710034253592311870e-01 5.47127295453320346141357077840439e-03
 	 3.42317632958730744263675660477020e-01 4.68382348547304205865771109529305e-01 1.89300018493965049870553229993675e-01 5.89481321294261194354557886754264e-03
 	 2.76391779093783207521539679873968e-01 5.15332833782546795298173947230680e-01 2.08275387123669997180286372895353e-01 6.11248528539720236557597488058491e-03
 	 2.15023185358020230140141393349040e-01 5.59037770240419562561839939007768e-01 2.25939044401560207298018667643191e-01 6.09102043234306753799467415433355e-03
 	 1.59461129444065097260363472742029e-01 5.98607458502203093608784456591820e-01 2.41931412053731809130852070666151e-01 5.81131129616139184557166430522557e-03
 	 1.10836673320363510164554554648930e-01 6.33236388966786467591418841038831e-01 2.55926937712850022244026604312239e-01 5.27038516217668596974821326739402e-03
 	 7.01396190623257975715887369005941e-02 6.62219653240831762630591583729256e-01 2.67640727696842439797819679370150e-01 4.48216979254462220133570227176278e-03
 	 3.81982882450735417023679474368691e-02 6.84967344670077915580463923106436e-01 2.76834367084848542717168129456695e-01 3.47698799078379958138462768602039e-03
 	 1.56622805575734602712145715486258e-02 7.01016837155390426516987645300105e-01 2.83320882287036113211797783151269e-01 2.29988252713326330953225173914234e-03
 	 2.98523728321309356203983043087646e-03 7.10045060503072367197319181286730e-01 2.86969702213714539240640988282394e-01 1.00929214438508305790032082427388e-03
 	 9.92435490725621427543501340551302e-01 4.87162459827449826482714811959340e-03 2.69288467610407419167151132910476e-03 1.34098670484264777366840981631668e-05
 	 9.74791975660365683786778845387744e-01 1.62342363519613896993831758663873e-02 8.97378798767292651383797874586890e-03 7.95257778425923470997857545050636e-05
 	 9.47485544406397428573995966871735e-01 3.38198691224166486657409791405371e-02 1.86945864711859227602630539877282e-02 2.34836806346822523326733911375186e-04
 	 9.11074265802615856912893832486589e-01 5.72691206292675336619879544741707e-02 3.16566135681166094251182130392408e-02 5.06679539744149661992245192720929e-04
 	 8.66299758970956679249297849310096e-01 8.61043802535134683573403435730143e-02 4.75958607755298523933618071168894e-02 9.10190962548090777735343426257941e-04
 	 8.14073616512697495473105391283752e-01 1.19738572643811866380580966051639e-01 6.61878108434906381463136426646088e-02 1.44632511724091081424525828680316e-03
 	 7.55459054449686973065070105803898e-01 1.57486975349909269494830255098350e-01 8.70539702004037574400996390977525e-02 2.10109084995332420428559849767680e-03
 	 6.91649315012962340176727593643591e-01 1.98581127656963368766085409333755e-01 1.09769557330074291057186997022654e-01 2.84608589973522852975551522547448e-03
 	 6.23943389721281937987384935695445e-01 2.42184465181720987025926206115400e-01 1.33872145096997074986688858189154e-01 3.64029622080400561828783523310449e-03
 	 5.53719580728293414573215613927459e-01 2.87409346646735675001593790511834e-01 1.58871072624970910425190595560707e-01 4.43302497323373647514221929100131e-03
 	 4.82407444612438895958916873496491e-01 3.33335122378703219148121661419282e-01 1.84257433008857884892961465084227e-01 5.16772190773744609371131986108594e-03
 	 4.11458691561905287592537661112146e-01 3.79026875543521546418901380093303e-01 2.09514432894573165988560958794551e-01 5.78640856809296052348789984876021e-03
 	 3.42317632958730744263675660477020e-01 4.23554454217108022895388330653077e-01 2.34127912824161232840936008869903e-01 6.23434399382636738468077552965951e-03
 	 2.76391779093783152010388448616141e-01 4.66011406770334202231964582097135e-01 2.57596814135882701268798200544552e-01 6.46455359140131729372980018410999e-03
 	 2.15023185358020230140141393349040e-01 5.05533435227258687305607054440770e-01 2.79443379414721082554251552210189e-01 6.44185240090004718194194310854073e-03
 	 1.59461129444065097260363472742029e-01 5.41315991438529264812018482189160e-01 2.99222879117405637927618045068812e-01 6.14603251481037320819167391050541e-03
 	 1.10836673320363510164554554648930e-01 5.72630659441154654665240286703920e-01 3.16532667238481835170205158647150e-01 5.57394999536649574101154769323330e-03
 	 7.01396190623257975715887369005941e-02 5.98839996148862852010097412858158e-01 3.31020384788811350418313850241248e-01 4.74033481910982826962319691688208e-03
 	 3.81982882450735417023679474368691e-02 6.19410553638692018552092122263275e-01 3.42391158116234439745539930299856e-01 3.67725632923467191798261310964335e-03
 	 1.56622805575734602712145715486258e-02 6.33923982787253592618981201667339e-01 3.50413736655172947109804226784036e-01 2.43235167961870042338534680936846e-03
 	 2.98523728321309356203983043087646e-03 6.42088133772954927636078537034336e-01 3.54926628943831978801881632534787e-01 1.06742558094088577612390533744247e-03
 	 9.92435490725621427543501340551302e-01 4.33280663508716842868828678092541e-03 3.23170263929140402781037266777275e-03 1.38543794146222328818708960374018e-05
 	 9.74791975660365683786778845387744e-01 1.44386755511222240194735277896143e-02 1.07693487885120921937476268226419e-02 8.21619107404585139473388033515278e-05
 	 9.47485544406397428573995966871735e-01 3.00792785600286945169035135450031e-02 2.24351770335738769091005195832622e-02 2.42621213461532080849641923592230e-04
 	 9.11074265802615856912893832486589e-01 5.09349644748871288602032336712000e-02 3.79907697224970142269029338422115e-02 5.23475032220048377799848093872015e-04
 	 8.66299758970956679249297849310096e-01 7.65809480074947229732984510519600e-02 5.71192930215485977774036996379436e-02 9.40362114655055015242923754925641e-04
 	 8.14073616512697384450802928768098e-01 1.06495086302571928538185375145986e-01 7.94312971847306870110116960859159e-02 1.49426812799794491055938028267747e-03
 	 7.55459054449687084087372568319552e-01 1.40068389501437462474342510176939e-01 1.04472556048875453438284921503509e-01 2.17073813742696061779291483162524e-03
 	 6.91649315012962340176727593643591e-01 1.76617391212766400299116753558337e-01 1.31733293774271259524155652798072e-01 2.94042839941244422974353511790468e-03
 	 6.23943389721281937987384935695445e-01 2.15398053870174605028964265329705e-01 1.60658556408543456983650798974850e-01 3.76096532817990101757454901587607e-03
 	 5.53719580728293525595518076443113e-01 2.55620912288298751668946806603344e-01 1.90659506983407722735535116953542e-01 4.57997157703979133891447617088488e-03
 	 4.82407444612438840447765642238664e-01 2.96467143724825021866564611627837e-01 2.21125411662736082174518514875672e-01 5.33902236021430772611173765085368e-03
 	 4.11458691561905287592537661112146e-01 3.37105236272311370449017431383254e-01 2.51436072165783341958444907504600e-01 5.97821734256401022405968959105849e-03
 	 3.42317632958730799774826891734847e-01 3.76707915918361224694166367044090e-01 2.80974451122908031042157972478890e-01 6.44100100171215647626432598826796e-03
 	 2.76391779093783207521539679873968e-01 4.14468987613695993843521137023345e-01 3.09139233292520798634939183102688e-01 6.67884162296314073947733902514301e-03
 	 2.15023185358020230140141393349040e-01 4.49619747627289623181923161610030e-01 3.35357067014690146677935445040930e-01 6.65538792985548820213548282254123e-03
 	 1.59461129444065041749212241484202e-01 4.81444633524180487516019866234274e-01 3.59094237031754415223616661023698e-01 6.34976216000435623315611977091066e-03
 	 1.10836673320363399142252092133276e-01 5.09295794581496874542381192441098e-01 3.79867532098139726315366715425625e-01 5.75871615990411565150219885822480e-03
 	 7.01396190623257975715887369005941e-02 5.32606291048858926373554822930600e-01 3.97254089888815276054856440168805e-01 4.89746817765791993271040638546765e-03
 	 3.81982882450735417023679474368691e-02 5.50901676126547945600009370537009e-01 4.10900035628378512697622682026122e-01 3.79915059605428389113979115165876e-03
 	 1.56622805575734602712145715486258e-02 5.63809871502486292804690037883120e-01 4.20527847939940246924095390568255e-01 2.51297965278375872583138672666792e-03
 	 2.98523728321309356203983043087646e-03 5.71071040101813420797327580658020e-01 4.25943722614973485640632588911103e-01 1.10280877072259126010778107485066e-03
 	 9.92435490725621427543501340551302e-01 3.78225463718926020739719007224267e-03 3.78225463718931224910146937645550e-03 1.40036104285987169634298057929733e-05
 	 9.74791975660365683786778845387744e-01 1.26040121698171633107810052365494e-02 1.26040121698171529024401493757068e-02 8.30469092584797108618638317167893e-05
 	 9.47485544406397428573995966871735e-01 2.62572277968013238769184880538887e-02 2.62572277968012475490855450743766e-02 2.45234582751740516626259847043912e-04
 	 9.11074265802615856912893832486589e-01 4.44628670986920923602347954783909e-02 4.44628670986920507268713720350206e-02 5.29113589351457827732183591962212e-04
 	 8.66299758970956679249297849310096e-01 6.68501205145217158865023066027788e-02 6.68501205145216048641998440871248e-02 9.50491127848308251652165168366082e-04
 	 8.14073616512697495473105391283752e-01 9.29631917436513216523863434304076e-02 9.29631917436511828745082652858400e-02 1.51036348248625388462906826703147e-03
 	 7.55459054449686973065070105803898e-01 1.22270472775156568978616178355878e-01 1.22270472775156457956313715840224e-01 2.19412001860914886858244798872875e-03
 	 6.91649315012962340176727593643591e-01 1.54175342493518885422787434436032e-01 1.54175342493518774400484971920378e-01 2.97210091959089744290123391579073e-03
 	 6.23943389721281937987384935695445e-01 1.88028305139359114273034379039018e-01 1.88028305139358947739580685265537e-01 3.80147617696337866005640293565193e-03
 	 5.53719580728293525595518076443113e-01 2.23140209635853375980119039923011e-01 2.23140209635853098424362883633876e-01 4.62930426686809001063371837858540e-03
 	 4.82407444612438895958916873496491e-01 2.58796277693780663042844025767408e-01 2.58796277693780440998239100736100e-01 5.39653108699401484055213629176251e-03
 	 4.11458691561905343103688892369973e-01 2.94270654219047467226033631959581e-01 2.94270654219047134159126244412619e-01 6.04261109194126778271227706795798e-03
 	 3.42317632958730799774826891734847e-01 3.28841183520634794401615863534971e-01 3.28841183520634461334708475988009e-01 6.51037957737716100475866554120330e-03
 	 2.76391779093783207521539679873968e-01 3.61804110453108562772683853836497e-01 3.61804110453108229705776466289535e-01 6.75078207426413508251972217522052e-03
 	 2.15023185358020174628990162091213e-01 3.92488407320990051463382997098961e-01 3.92488407320989718396475609551999e-01 6.72707575212856331847710578131228e-03
 	 1.59461129444065152771514703999856e-01 4.20269435277967617903271957402467e-01 4.20269435277967284836364569855505e-01 6.41815796592886105703668064847989e-03
 	 1.10836673320363454653403323391103e-01 4.44581663339818466962327647706843e-01 4.44581663339818133895420260159881e-01 5.82074557501008945509246572669326e-03
 	 7.01396190623257975715887369005941e-02 4.64930190468837323258810556581011e-01 4.64930190468836879169600706518395e-01 4.95022074925979826964805852185236e-03
 	 3.81982882450735417023679474368691e-02 4.80900855877463451193420951312874e-01 4.80900855877463007104211101250257e-01 3.84007275349860588767314517610885e-03
 	 1.56622805575734602712145715486258e-02 4.92168859721213491908997639256995e-01 4.92168859721213047819787789194379e-01 2.54004795302760748992865202922076e-03
 	 2.98523728321309356203983043087646e-03 4.98507381358393675263585009815870e-01 4.98507381358393231174375159753254e-01 1.11468756125891787014947631462292e-03
 	 9.92435490725621427543501340551302e-01 3.23170263929134678193566543313864e-03 4.33280663508722567456299401555952e-03 1.38543794146222227174755289857977e-05
 	 9.74791975660365683786778845387744e-01 1.07693487885120869895771988922206e-02 1.44386755511222292236439557200356e-02 8.21619107404584597372301790763061e-05
 	 9.47485544406397428573995966871735e-01 2.24351770335739220119108949802467e-02 3.00792785600286494140931381480186e-02 2.42621213461531891114261738628954e-04
 	 9.11074265802615856912893832486589e-01 3.79907697224970003491151260277547e-02 5.09349644748871427379910414856568e-02 5.23475032220047944118979099670241e-04
 	 8.66299758970956679249297849310096e-01 5.71192930215486255329793152668572e-02 7.65809480074946952177228354230465e-02 9.40362114655054364721620263622981e-04
 	 8.14073616512697384450802928768098e-01 7.94312971847306037442848491991754e-02 1.06495086302572011804912222032726e-01 1.49426812799794382635720779717303e-03
 	 7.55459054449686973065070105803898e-01 1.04472556048875508949436152761336e-01 1.40068389501437517985493741434766e-01 2.17073813742695888306943885481815e-03
 	 6.91649315012962340176727593643591e-01 1.31733293774271204013004421540245e-01 1.76617391212766455810267984816164e-01 2.94042839941244206133919014689582e-03
 	 6.23943389721281937987384935695445e-01 1.60658556408543401472499567717023e-01 2.15398053870174660540115496587532e-01 3.76096532817989798180846605646366e-03
 	 5.53719580728293525595518076443113e-01 1.90659506983407667224383885695715e-01 2.55620912288298807180098037861171e-01 4.57997157703978786946752421727069e-03
 	 4.82407444612438840447765642238664e-01 2.21125411662735971152216052360018e-01 2.96467143724825132888867074143491e-01 5.33902236021430338930304770883595e-03
 	 4.11458691561905287592537661112146e-01 2.51436072165783230936142444988945e-01 3.37105236272311481471319893898908e-01 5.97821734256400501988926166063720e-03
 	 3.42317632958730799774826891734847e-01 2.80974451122907920019855509963236e-01 3.76707915918361335716468829559744e-01 6.44100100171215127209389805784667e-03
 	 2.76391779093783207521539679873968e-01 3.09139233292520687612636720587034e-01 4.14468987613696104865823599538999e-01 6.67884162296313553530691109472173e-03
 	 2.15023185358020230140141393349040e-01 3.35357067014690035655632982525276e-01 4.49619747627289734204225624125684e-01 6.65538792985548299796505489211995e-03
 	 1.59461129444065097260363472742029e-01 3.59094237031754248690162967250217e-01 4.81444633524180654049473560007755e-01 6.34976216000435102898569184048938e-03
 	 1.10836673320363510164554554648930e-01 3.79867532098139504270761790394317e-01 5.09295794581496985564683654956752e-01 5.75871615990411131469350891620707e-03
 	 7.01396190623257975715887369005941e-02 3.97254089888815165032553977653151e-01 5.32606291048859037395857285446255e-01 4.89746817765791646326345443185346e-03
 	 3.81982882450735417023679474368691e-02 4.10900035628378401675320219510468e-01 5.50901676126548056622311833052663e-01 3.79915059605428128905457718644811e-03
 	 1.56622805575734602712145715486258e-02 4.20527847939940024879490465536946e-01 5.63809871502486514849294962914428e-01 2.51297965278375655742704175565905e-03
 	 2.98523728321309356203983043087646e-03 4.25943722614973374618330126395449e-01 5.71071040101813531819630043173674e-01 1.10280877072259039274604308644712e-03
 	 9.92435490725621427543501340551302e-01 2.69288467610402128260549403648838e-03 4.87162459827455117389316541220978e-03 1.34098670484264726544864146373648e-05
 	 9.74791975660365683786778845387744e-01 8.97378798767293345273188265309727e-03 1.62342363519613827604892719591589e-02 7.95257778425923064422042862986473e-05
 	 9.47485544406397317551693504356081e-01 1.86945864711859990880959969672404e-02 3.38198691224166833602104986766790e-02 2.34836806346822414906516662824743e-04
 	 9.11074265802615856912893832486589e-01 3.16566135681166371806938286681543e-02 5.72691206292675059064123388452572e-02 5.06679539744149553572027944170486e-04
 	 8.66299758970956679249297849310096e-01 4.75958607755299634156642696325434e-02 8.61043802535133573350378810573602e-02 9.10190962548090452474691680606611e-04
 	 8.14073616512697384450802928768098e-01 6.61878108434907630464039129947196e-02 1.19738572643811852502793158237182e-01 1.44632511724091016372395479550050e-03
 	 7.55459054449686973065070105803898e-01 8.70539702004038407068264859844930e-02 1.57486975349909186228103408211609e-01 2.10109084995332333692386050927325e-03
 	 6.91649315012962340176727593643591e-01 1.09769557330074402079489459538308e-01 1.98581127656963257743782946818101e-01 2.84608589973522766239377723707094e-03
 	 6.23943389721281937987384935695445e-01 1.33872145096997213764566936333722e-01 2.42184465181720848248048127970833e-01 3.64029622080400431724522825049917e-03
 	 5.53719580728293414573215613927459e-01 1.58871072624971021447493058076361e-01 2.87409346646735563979291327996179e-01 4.43302497323373474041874331419422e-03
 	 4.82407444612438895958916873496491e-01 1.84257433008858106937566390115535e-01 3.33335122378702997103516736387974e-01 5.16772190773744435898784388427885e-03
 	 4.11458691561905287592537661112146e-01 2.09514432894573388033165883825859e-01 3.79026875543521324374296455061994e-01 5.78640856809295792140268588354957e-03
 	 3.42317632958730799774826891734847e-01 2.34127912824161510396692165159038e-01 4.23554454217107745339632174363942e-01 6.23434399382636478259556156444887e-03
 	 2.76391779093783152010388448616141e-01 2.57596814135882812291100663060206e-01 4.66011406770334091209662119581481e-01 6.46455359140131469164458621889935e-03
 	 2.15023185358020230140141393349040e-01 2.79443379414721304598856477241497e-01 5.05533435227258465261002129409462e-01 6.44185240090004544721846713173363e-03
 	 1.59461129444065097260363472742029e-01 2.99222879117405859972222970100120e-01 5.41315991438529042767413557157852e-01 6.14603251481037147346819793369832e-03
 	 1.10836673320363510164554554648930e-01 3.16532667238482168237112546194112e-01 5.72630659441154321598332899156958e-01 5.57394999536649400628807171642620e-03
 	 7.01396190623257975715887369005941e-02 3.31020384788811572462918775272556e-01 5.98839996148862629965492487826850e-01 4.74033481910982653489972094007499e-03
 	 3.81982882450735417023679474368691e-02 3.42391158116234661790144855331164e-01 6.19410553638691796507487197231967e-01 3.67725632923467061694000612703803e-03
 	 1.56622805575734602712145715486258e-02 3.50413736655173280176711614330998e-01 6.33923982787253259552073814120376e-01 2.43235167961869955602360882096491e-03
 	 2.98523728321309356203983043087646e-03 3.54926628943832311868789020081749e-01 6.42088133772954594569171149487374e-01 1.06742558094088534244303634324069e-03
 	 9.92435490725621427543501340551302e-01 2.17728468527995065728841694863149e-03 5.38722458909862179921024250006667e-03 1.26795476058342691143884101157013e-05
 	 9.74791975660365683786778845387744e-01 7.25559892255658173132459864973498e-03 1.79524254170777344818965559625212e-02 7.51946967411932761307657990812459e-05
 	 9.47485544406397428573995966871735e-01 1.51151800827369481305950671412575e-02 3.73992755108656232954089659870078e-02 2.22047277196981280829660154729766e-04
 	 9.11074265802615856912893832486589e-01 2.55953998035314961301267544513394e-02 6.33303343938526469569794130620721e-02 4.79085088754999523057154231509003e-04
 	 8.66299758970956679249297849310096e-01 3.84827986392667492632213566139399e-02 9.52174423897765714874807940759638e-02 8.60620735340015098960297912356054e-04
 	 8.14073616512697495473105391283752e-01 5.35149938578996231530737759385374e-02 1.32411389629402881373820832777710e-01 1.36755630099418749694162311669743e-03
 	 7.55459054449686973065070105803898e-01 7.03859611189806555486825345724355e-02 1.74154984431332371386247359623667e-01 1.98666260895494998367505345981954e-03
 	 6.91649315012962340176727593643591e-01 8.87522507761110135415805189040839e-02 2.19598434210926646281691887452325e-01 2.69108422370384131258602700143001e-03
 	 6.23943389721282049009687398211099e-01 1.08239975477512129220514225380612e-01 2.67816634801205821769798376408289e-01 3.44204077969878854958984959466761e-03
 	 5.53719580728293525595518076443113e-01 1.28452419975442932997822254037601e-01 3.17827999296263541406659669519286e-01 4.19159645528065921693539053194399e-03
 	 4.82407444612438895958916873496491e-01 1.48978116515408598452552269009175e-01 3.68614438872152505588530857494334e-01 4.88628080399636059716339531178164e-03
 	 4.11458691561905232081386429854319e-01 1.69399220892906654523102361054043e-01 4.19142087545188168906662440349464e-01 5.47127295453321907392485456966824e-03
 	 3.42317632958730799774826891734847e-01 1.89300018493964994359401998735848e-01 4.68382348547304261376922340787132e-01 5.89481321294262929078033863561359e-03
 	 2.76391779093783207521539679873968e-01 2.08275387123669997180286372895353e-01 5.15332833782546795298173947230680e-01 6.11248528539722058017247263705940e-03
 	 2.15023185358020230140141393349040e-01 2.25939044401560207298018667643191e-01 5.59037770240419562561839939007768e-01 6.09102043234308488522943392240450e-03
 	 1.59461129444065097260363472742029e-01 2.41931412053731698108549608150497e-01 5.98607458502203204631086919107474e-01 5.81131129616140919280642407329651e-03
 	 1.10836673320363510164554554648930e-01 2.55926937712849911221724141796585e-01 6.33236388966786578613721303554485e-01 5.27038516217670158225949705865787e-03
 	 7.01396190623257975715887369005941e-02 2.67640727696842328775517216854496e-01 6.62219653240831873652894046244910e-01 4.48216979254463521176177209781599e-03
 	 3.81982882450735417023679474368691e-02 2.76834367084848431694865666941041e-01 6.84967344670078026602766385622090e-01 3.47698799078380998972548354686296e-03
 	 1.56622805575734602712145715486258e-02 2.83320882287036113211797783151269e-01 7.01016837155390426516987645300105e-01 2.29988252713327024842615564637072e-03
 	 2.98523728321309356203983043087646e-03 2.86969702213714428218338525766740e-01 7.10045060503072478219621643802384e-01 1.00929214438508587682596928658540e-03
 	 9.92435490725621538565803803066956e-01 1.69589173719388031091881430256763e-03 5.86861753718458112327738263047650e-03 1.16789871885318181221743646935884e-05
 	 9.74791975660365683786778845387744e-01 5.65140164919426465917062785138114e-03 1.95566226904400515540505267608751e-02 6.92609805322900036169200821412062e-05
 	 9.47485544406397317551693504356081e-01 1.17732463659042246861829994486470e-02 4.07412092276984577621234961952723e-02 2.04525223316221659236938124060146e-04
 	 9.11074265802615856912893832486589e-01 1.99363121095033901664095310479752e-02 6.89894220878807529206966364654363e-02 4.41279830142498350007557172958172e-04
 	 8.66299758970956679249297849310096e-01 2.99743348573808798818163268151693e-02 1.03725906171662440868885823874734e-01 7.92707977814287030431106284567022e-04
 	 8.14073616512697495473105391283752e-01 4.16829441336579453736277400821564e-02 1.44243439353644559153266868634091e-01 1.25964056569005645146164251713117e-03
 	 7.55459054449686973065070105803898e-01 5.48237769195446811298921829802566e-02 1.89717168630768345805037711215846e-01 1.82989234941189661542981781394701e-03
 	 6.91649315012962340176727593643591e-01 6.91293195447305608425381251436193e-02 2.39221365442307098980734281212790e-01 2.47872709255302558703504267612061e-03
 	 6.23943389721281937987384935695445e-01 8.43083503445388737773669163289014e-02 2.91748259934179188235248147975653e-01 3.17042464117640214807392062823510e-03
 	 5.53719580728293525595518076443113e-01 1.00051866956893720228549682360608e-01 3.46228552314812754175932241196278e-01 3.86083185477319916836802526916017e-03
 	 4.82407444612438895958916873496491e-01 1.16039376260391624562373635853874e-01 4.01553179127169479478709490649635e-01 4.50069771284144007350569438585808e-03
 	 4.11458691561905343103688892369973e-01 1.31945418502965872153964710378204e-01 4.56595889935128729231195165993995e-01 5.03952733388943110298674454838874e-03
 	 3.42317632958730744263675660477020e-01 1.47446192675206533273524200922111e-01 5.10236174366062722462800138600869e-01 5.42964545210327786256554460919688e-03
 	 2.76391779093783207521539679873968e-01 1.62226148225753652454272923932876e-01 5.61382072680463140024187396193156e-01 5.63014072405829645029395891242530e-03
 	 2.15023185358020230140141393349040e-01 1.75984408975356498849862418865087e-01 6.08992405666623271009996187785873e-01 5.61036969187197337438632871453592e-03
 	 1.59461129444065097260363472742029e-01 1.88440898630955810943987671635114e-01 6.52097971924979091795648855622858e-01 5.35273278560901080713740896044328e-03
 	 1.10836673320363510164554554648930e-01 1.99342043751503883441955622402020e-01 6.89821282928132606393489822949050e-01 4.85449187156862527192657807972864e-03
 	 7.01396190623257975715887369005941e-02 2.08465940033593755131846592121292e-01 7.21394440904080447296564670978114e-01 4.12847565317444546023617490959623e-03
 	 3.81982882450735417023679474368691e-02 2.15626885581169269734402860194677e-01 7.46174826173757188563229192368453e-01 3.20261412010931605098829066946564e-03
 	 1.56622805575734602712145715486258e-02 2.20679246261857198163625071174465e-01 7.63658473180569341565160357276909e-01 2.11839565610040785753609426933508e-03
 	 2.98523728321309356203983043087646e-03 2.23521319972290077870979985164013e-01 7.73493442744496828566980184405111e-01 9.29647522939652110052222155900381e-04
 	 9.92435490725621427543501340551302e-01 1.25896580136469933564047352092530e-03 6.30554347301387312085818592777287e-03 1.04295123891495502253552035698547e-05
 	 9.74791975660365683786778845387744e-01 4.19538656275570895348714373085386e-03 2.10126377768786072597340108814024e-02 6.18511042854370172950836948011499e-05
 	 9.47485544406397428573995966871735e-01 8.74001224290422984442017195760855e-03 4.37744433506983415815838611706567e-02 1.82644121107068961758213010426743e-04
 	 9.11074265802615856912893832486589e-01 1.47999631112821772305210288322996e-02 7.41257710861019658565851386811119e-02 3.94069569668871412439908885616546e-04
 	 8.66299758970956679249297849310096e-01 2.22518110540107921790919931481767e-02 1.11448429975032528571610157541727e-01 7.07900226460571996810189343563025e-04
 	 8.14073616512697384450802928768098e-01 3.09438391694170089607496265671216e-02 1.54982544317885606588447444664780e-01 1.12487809718980562821710744714210e-03
 	 7.55459054449686973065070105803898e-01 4.06990957792863483621914610921522e-02 2.03841849771026678572738433103950e-01 1.63412157415000476416711006066862e-03
 	 6.91649315012962340176727593643591e-01 5.13189888656662152044418689911254e-02 2.57031696121371444618830537365284e-01 2.21354082368441272901660177296890e-03
 	 6.23943389721281937987384935695445e-01 6.25873264934209139198628690792248e-02 3.13469283785297148092752195225330e-01 2.83123720749376686298126593044344e-03
 	 5.53719580728293525595518076443113e-01 7.42747170110302223910991870070575e-02 3.72005702260676252013382736549829e-01 3.44778130258761644419407410566691e-03
 	 4.82407444612438895958916873496491e-01 8.61432384624103431036701294942759e-02 4.31449316925150760937412997009233e-01 4.01919120195539346374058453648104e-03
 	 4.11458691561905232081386429854319e-01 9.79512818529619244678485756594455e-02 4.90590026585132898961916225744062e-01 4.50037421188960104490028868440277e-03
 	 3.42317632958730744263675660477020e-01 1.09458469575816619290264952724101e-01 5.48223897465452636446059386798879e-01 4.84875559817439082815893058864276e-03
 	 2.76391779093783207521539679873968e-01 1.20430548851713226099491294007748e-01 6.03177672054503566378969026118284e-01 5.02780091169901729997171457853256e-03
 	 2.15023185358020230140141393349040e-01 1.30644160599517888954324007499963e-01 6.54332654042461880905534599150997e-01 5.01014508060640233189086956144820e-03
 	 1.59461129444065097260363472742029e-01 1.39891386785902516187718447326915e-01 7.00647483770032386551918079931056e-01 4.78007142247188071548791299392178e-03
 	 1.10836673320363510164554554648930e-01 1.47983984091195397425622104492504e-01 7.41179342588441092409823340858566e-01 4.33513474244298126214491873042789e-03
 	 7.01396190623257975715887369005941e-02 1.54757219164182058257495100406231e-01 7.75103161773492144170916162693175e-01 3.68679126691447622485298118988339e-03
 	 3.81982882450735417023679474368691e-02 1.60073233949860282976374037389178e-01 8.01728477805066175321258015173953e-01 2.85998289955692380423513121456836e-03
 	 1.56622805575734602712145715486258e-02 1.63823915183599178035933618957642e-01 8.20513804258827361692851809493732e-01 1.89175939520807375078537138080037e-03
 	 2.98523728321309356203983043087646e-03 1.65933763075371443207473021175247e-01 8.31080999641415463230487148393877e-01 8.30189313638605053298491487367983e-04
 	 9.92435490725621538565803803066956e-01 8.75819021931832121519168055101545e-04 6.68869025244662931267702887794258e-03 8.95775703617757328221619939068177e-06
 	 9.74791975660365683786778845387744e-01 2.91858551839586227716338839854870e-03 2.22894388212384539360577662137075e-02 5.31230170630637502635941482598270e-05
 	 9.47485544406397428573995966871735e-01 6.08012462765476074944004380995466e-03 4.64343309659478106765639893183106e-02 1.56870388558666477808387074155405e-04
 	 9.11074265802615856912893832486589e-01 1.02958231293492213920259814585734e-02 7.86299110680349216950801860548381e-02 3.38460642140590546936285143431178e-04
 	 8.66299758970956568226995386794442e-01 1.54798163479979850043477540566528e-02 1.18220424681045446768656859148905e-01 6.08005244913081247144781560365345e-04
 	 8.14073616512697384450802928768098e-01 2.15265600755774610952641978656175e-02 1.64399823411725154453932873366284e-01 9.66141494824541697920838867474913e-04
 	 7.55459054449686862042767643288244e-01 2.83129551416613778336284212855389e-02 2.16227990408651760123603935426218e-01 1.40352333672287858321037212760984e-03
 	 6.91649315012962340176727593643591e-01 3.57008479389491206745788076659665e-02 2.72649837048088539148693598690443e-01 1.90117813262813580010845981860257e-03
 	 6.23943389721281826965082473179791e-01 4.35398412056763883803967019048287e-02 3.32516769073041784654520824915380e-01 2.43170860441185810937869682391010e-03
 	 5.53719580728293525595518076443113e-01 5.16703550933230726371903074323200e-02 3.94610064178383401767291616124567e-01 2.96124939211794705254399140414989e-03
 	 4.82407444612438951470068104754318e-01 5.99268755151304843842297032097122e-02 4.57665679872430619656853423293796e-01 3.45202507324455067430624133351103e-03
 	 4.11458691561905287592537661112146e-01 6.81413234389988131667337256658357e-02 5.20399984999095899240728613222018e-01 3.86530618669445047430599515791982e-03
 	 3.42317632958730744263675660477020e-01 7.61464764667395543895622722629923e-02 5.81535890574529701346762067259988e-01 4.16452591028503276565642110540466e-03
 	 2.76391779093783207521539679873968e-01 8.37793730311716666747656745428685e-02 6.39828847875045125803694645583164e-01 4.31830533516863648152428467597019e-03
 	 2.15023185358020230140141393349040e-01 9.08846299346214303582769389322493e-02 6.94092184707358339501581667718710e-01 4.30314099772904738727685725052652e-03
 	 1.59461129444065097260363472742029e-01 9.73176057830223983913242591370363e-02 7.43221264772912504348312268120935e-01 4.10553406721350915703494521835637e-03
 	 1.10836673320363510164554554648930e-01 1.02947346201012202016045193886384e-01 7.86215980478624287819400251464685e-01 3.72338440120142770417555055928460e-03
 	 7.01396190623257975715887369005941e-02 1.07659251886224049954421388974879e-01 8.22201129051450152473989874124527e-01 3.16653158650825059319822152303914e-03
 	 3.81982882450735417023679474368691e-02 1.11357419751563213594636181369424e-01 8.50444292003363244702995871193707e-01 2.45639786271375408846506793736353e-03
 	 1.56622805575734602712145715486258e-02 1.13966639133178171405802459048573e-01 8.70371080309248368322982969402801e-01 1.62480472728619772075642213593483e-03
 	 2.98523728321309356203983043087646e-03 1.15434387434993790400028501608176e-01 8.81580375281793116037931667960947e-01 7.13037569555257798488423492955235e-04
 	 9.92435490725621427543501340551302e-01 5.54617094286578848905122640644549e-04 7.00989218009199360759353680805361e-03 7.29509908774020728256318180093842e-06
 	 9.74791975660365683786778845387744e-01 1.84820993733291263905194057315384e-03 2.33598144023014035741692140391024e-02 4.32628024794176266332179636719957e-05
 	 9.47485544406397317551693504356081e-01 3.85027153949234202112705816034577e-03 4.86641840541103404271794374835736e-02 1.27753523995567999909511724965228e-04
 	 9.11074265802615856912893832486589e-01 6.51988523233133776546566195975174e-03 8.24058489650528053216405055536598e-02 2.75638634955586514854730673107497e-04
 	 8.66299758970956568226995386794442e-01 9.80267674944922118296375401769183e-03 1.23897564279594210590040859187866e-01 4.95152803273548702649164976463680e-04
 	 8.14073616512697495473105391283752e-01 1.36318096548849743143705381953623e-02 1.72294573832417530212524070520885e-01 7.86815037409188005636251350694010e-04
 	 7.55459054449686973065070105803898e-01 1.79293307385560707345462105877232e-02 2.26611614811756956200383683608379e-01 1.14301401254774943720693425319723e-03
 	 6.91649315012962340176727593643591e-01 2.26077534874642993578675032040337e-02 2.85742931499573360465404903152375e-01 1.54829862039721085319177174000060e-03
 	 6.23943389721281937987384935695445e-01 2.75718380287369724257473535544705e-02 3.48484772249981089586867710750084e-01 1.98035681812427531364728672258479e-03
 	 5.53719580728293525595518076443113e-01 3.27205295671748053187855020951247e-02 4.13559889704531669085696421461762e-01 2.41160902799269051891006832022413e-03
 	 4.82407444612438951470068104754318e-01 3.79490154193775075519567963056033e-02 4.79643539968183596489126330197905e-01 2.81129136021181919025124784639047e-03
 	 4.11458691561905287592537661112146e-01 4.31508586365472179835478527820669e-02 5.45390449801547494423914486105787e-01 3.14786296642219961400277483676291e-03
 	 3.42317632958730744263675660477020e-01 4.82201647379058018216824166302104e-02 6.09462202303363453914641922892770e-01 3.39154422767808452765514459770202e-03
 	 2.76391779093783207521539679873968e-01 5.30537374367696656918269582092762e-02 6.70554483469447126786633361916756e-01 3.51678050475624694864995589682621e-03
 	 2.15023185358020230140141393349040e-01 5.75531794896024795349376290687360e-02 7.27423635152377290324920977582224e-01 3.50443083465747703270087853866244e-03
 	 1.59461129444065097260363472742029e-01 6.16268959576304897751697353669442e-02 7.78911974598304412964466791891027e-01 3.34350191766262776899010233933041e-03
 	 1.10836673320363510164554554648930e-01 6.51919592801033509488206618698314e-02 8.23971367399533138886624783481238e-01 3.03228342081728703336085395392274e-03
 	 7.01396190623257975715887369005941e-02 6.81757988339877218919582446687855e-02 8.61684582103686480536453018430620e-01 2.57878859571012905571585349662200e-03
 	 3.81982882450735417023679474368691e-02 7.05176834748743042169394357188139e-02 8.91284028280052154080692616844317e-01 2.00046347931052276303276471480785e-03
 	 1.56622805575734602712145715486258e-02 7.21699856463841049603047395066824e-02 9.12167733796042434768480688944692e-01 1.32322315016030400344759776487535e-03
 	 2.98523728321309356203983043087646e-03 7.30994451327759975356457289308310e-02 9.23915317584010908902314440638293e-01 5.80689976539785785575320531393118e-04
 	 9.92435490725621427543501340551302e-01 3.02204663924155597642950965564523e-04 7.26230461045441685885570848313364e-03 5.47701277879032727972279451233995e-06
 	 9.74791975660365683786778845387744e-01 1.00706896474484289272233183965000e-03 2.42009553748894733204988227726062e-02 3.24808366790055655501032183529730e-05
 	 9.47485544406397428573995966871735e-01 2.09796998432902614961648168900865e-03 5.04164856092735452763875514392566e-02 9.59147607241028006715144460514466e-05
 	 9.11074265802615856912893832486589e-01 3.55261268676772268282348932189052e-03 8.53731215106164204042826781915210e-02 2.06943909578577076545380375449668e-04
 	 8.66299758970956679249297849310096e-01 5.34136914123622963401771812641528e-03 1.28358871887807091116684432563488e-01 3.71750705283861813260637418920851e-04
 	 8.14073616512697384450802928768098e-01 7.42782091982169268007396567554679e-03 1.78498562567480922869123105556355e-01 5.90724808889391927828327322202995e-04
 	 7.55459054449686862042767643288244e-01 9.76949218848027767236885665624868e-03 2.34771453361832860284863500055508e-01 8.58151791739360193453367564586642e-04
 	 6.91649315012962340176727593643591e-01 1.23187125228221283634866267675534e-02 2.96031972464215531459785779588856e-01 1.16243127438119702755925377601898e-03
 	 6.23943389721282049009687398211099e-01 1.50235867792063992887108270224417e-02 3.61033023499511551701601774766459e-01 1.48681182653971231608092118392506e-03
 	 5.53719580728293525595518076443113e-01 1.78290513277237772093997136835242e-02 4.28451367943982697195082209873362e-01 1.81058725932311311707101353363214e-03
 	 4.82407444612438840447765642238664e-01 2.06779949071307922459084238653304e-02 4.96914560480430311795174702638178e-01 2.11066066678370928971775200011507e-03
 	 4.11458691561905287592537661112146e-01 2.35124212120990661034625190950464e-02 5.65028887225995646303999819792807e-01 2.36335181820208775974045956047576e-03
 	 3.42317632958730744263675660477020e-01 2.62746295220689374261269222188275e-02 6.31407737519200318310197417304153e-01 2.54630277826418905881555865278187e-03
 	 2.76391779093783207521539679873968e-01 2.89083893323252016926971919019707e-02 6.94699831573891590785763128224062e-01 2.64032764093917937317512745210024e-03
 	 2.15023185358020230140141393349040e-01 3.13600850831957655984183475084137e-02 7.53616729558784004261440259142546e-01 2.63105575852452117091573313700792e-03
 	 1.59461129444065097260363472742029e-01 3.35798077149446205780236596183386e-02 8.06959062840990282161612867639633e-01 2.51023358404043033659247541322657e-03
 	 1.10836673320363510164554554648930e-01 3.55223709253738029190117231337354e-02 8.53640955754262686916433722217334e-01 2.27657703411331168233400212841389e-03
 	 7.01396190623257975715887369005941e-02 3.71482317920409643718926417932380e-02 8.92712149145633238056518621306168e-01 1.93610229588784491655539810039954e-03
 	 3.81982882450735417023679474368691e-02 3.84242985922513824448287778068334e-02 9.23377413162675075852803274756297e-01 1.50190750090018181744921932363468e-03
 	 1.56622805575734602712145715486258e-02 3.93246196021628247052603910560720e-02 9.45013099840263715023525037395302e-01 9.93449165728078811138379577982960e-04
 	 2.98523728321309356203983043087646e-03 3.98310717014757065257413159997668e-02 9.57183691015311199912218853569357e-01 4.35970284127979433065613878994782e-04
 	 9.92435490725621427543501340551302e-01 1.23956441807939778121383511688691e-04 7.44055283257063267837727593700947e-03 3.54245933668828271874396383667172e-06
 	 9.74791975660365683786778845387744e-01 4.13073325553656861552909163037839e-04 2.47949510140806593516682454492184e-02 2.10081750407023029364635136051476e-05
 	 9.47485544406397317551693504356081e-01 8.60532365385836828242105411845841e-04 5.16539232282168456200643902320735e-02 6.20363970975368599503757538471405e-05
 	 9.11074265802615856912893832486589e-01 1.45718872123030973586566005906207e-03 8.74685454761538333512405074543494e-02 1.33848580287468138690087915421145e-04
 	 8.66299758970956568226995386794442e-01 2.19088979148429618959426079527475e-03 1.31509351237559135583410352410283e-01 2.40443433316971024327896033767615e-04
 	 8.14073616512697495473105391283752e-01 3.04669769040610827204318411531858e-03 1.82879685796896396254851424600929e-01 3.82072983792784064225461770902825e-04
 	 7.55459054449686973065070105803898e-01 4.00718994283424945201943501160713e-03 2.40533755607478777482910459184495e-01 5.55041214932913305399320158528553e-04
 	 6.91649315012962340176727593643591e-01 5.05281338863511342296419570629951e-03 3.03297871598402546400308210650110e-01 7.51845154923961472327731403453299e-04
 	 6.23943389721281937987384935695445e-01 6.16228199843604773633387594600208e-03 3.69894328280282014276281188358553e-01 9.61650200492584106455595804874292e-04
 	 5.53719580728293525595518076443113e-01 7.31301011274404499928891709714662e-03 4.38967409158962429405193006459740e-01 1.17106386286259752695093627750111e-03
 	 4.82407444612438895958916873496491e-01 8.48157218729728157313729752786458e-03 5.09110983200263822467945828975644e-01 1.36514736912482590597273102162035e-03
 	 4.11458691561905287592537661112146e-01 9.64417965591946035885939636500552e-03 5.78897128782175252048602942522848e-01 1.52858465963234477213994466637814e-03
 	 3.42317632958730744263675660477020e-01 1.07771651935686385570534184807912e-02 6.46905201847700617179270921042189e-01 1.64691491789608680275380780955174e-03
 	 2.76391779093783207521539679873968e-01 1.18574645192536243243353055731859e-02 7.11750756386963168154125014552847e-01 1.70772895396218826052914252500159e-03
 	 2.15023185358020230140141393349040e-01 1.28630859339841085997591108025517e-02 7.72113728707995661260099495848408e-01 1.70173202319809087172675088339702e-03
 	 1.59461129444065097260363472742029e-01 1.37735580480120578528158148401417e-02 8.26765312507922844886820712417830e-01 1.62358584071379879673613366719565e-03
 	 1.10836673320363510164554554648930e-01 1.45703466230959755023377510951832e-02 8.74592980056540514333107694255887e-01 1.47245987838757878309048354736888e-03
 	 7.01396190623257975715887369005941e-02 1.52372321876331762169343164714519e-02 9.14623148750041026211476946627954e-01 1.25224532639602926555044692946694e-03
 	 3.81982882450735417023679474368691e-02 1.57606413832735992031075511476956e-02 9.46041070371652859094524501415435e-01 9.71413882766420581742206064035372e-04
 	 1.56622805575734602712145715486258e-02 1.61299294922803149177070736186579e-02 9.68207789950146224811078354832716e-01 6.42549764770841452983518582442457e-04
 	 2.98523728321309356203983043087646e-03 1.63376628851464866798437469697092e-02 9.80677099831640419758116422599414e-01 2.81979806493879944263858394748468e-04
 	 9.92435490725621538565803803066956e-01 2.36308816433999577255598012470728e-05 7.54087839273506147647063713179705e-03 1.53544142945726775763650752415490e-06
 	 9.74791975660365683786778845387744e-01 7.87477175355523473232466358240345e-05 2.51292766220987638658979079764322e-02 9.10577066635863737332611672625760e-06
 	 9.47485544406397428573995966871735e-01 1.64050679255983711257727009069640e-04 5.23504049143465877147463061191957e-02 2.68890183865510601129902162886864e-05
 	 9.11074265802615856912893832486589e-01 2.77796407360933472752151374152163e-04 8.86479377900232096143540161392593e-02 5.80152475764326072530698008566930e-05
 	 8.66299758970956679249297849310096e-01 4.17668146981131638284523432957940e-04 1.33282572882062189112417627256946e-01 1.04217656115980348468033622744144e-04
 	 8.14073616512697384450802928768098e-01 5.80818160598350896606234528007917e-04 1.85345565326704264652590836703894e-01 1.65605482698422286618605836494567e-04
 	 7.55459054449687084087372568319552e-01 7.63925052063518794653873555944301e-04 2.43777020498249397117973558124504e-01 2.40576728048207680787581863590674e-04
 	 6.91649315012962340176727593643591e-01 9.63261234442569502789410762488842e-04 3.07387423752595090320482995593920e-01 3.25879308606598881714599968972834e-04
 	 6.23943389721281937987384935695445e-01 1.17476876904809568458176727290265e-03 3.74881841509669966328033297031652e-01 4.16817080492611102045946713801072e-04
 	 5.53719580728293525595518076443113e-01 1.39414195753534420063601828587707e-03 4.44886277314171130203845905271010e-01 5.07585211482053507911493817061910e-04
 	 4.82407444612438895958916873496491e-01 1.61691498710903047708598023746163e-03 5.15975640400452073563997146266047e-01 5.91708648892614479976315156051214e-04
 	 4.11458691561905287592537661112146e-01 1.83855283898703980582922667963430e-03 5.86702755599107672601633112208219e-01 6.62548809106871237385727457791518e-04
 	 3.42317632958730744263675660477020e-01 2.05454360762613585933422655216418e-03 6.55627823433643119876990112970816e-01 7.13837804583776925487770270706278e-04
 	 2.76391779093783207521539679873968e-01 2.26049035095288175511996087152511e-03 7.21347730555263910723340359254507e-01 7.40197003545167145008298881236897e-04
 	 2.15023185358020230140141393349040e-01 2.45220060241668758038713349378668e-03 7.82524614039563082279471473157173e-01 7.37597697506727173304141853549254e-04
 	 1.59461129444065097260363472742029e-01 2.62577172508204892409366948413663e-03 8.37913098830852853815542857773835e-01 7.03726063498788696748409421388715e-04
 	 1.10836673320363510164554554648930e-01 2.77767037785070503019824172952212e-03 8.86385656301785784805247203621548e-01 6.38222117915264496382232728421968e-04
 	 7.01396190623257975715887369005941e-02 2.90480450347918583986484009074047e-03 9.26955576434195016588546423008665e-01 5.42772455869658929962506821453871e-04
 	 3.81982882450735417023679474368691e-02 3.00458649603108085557323647662997e-03 9.58797125258895377442058816086501e-01 4.21049045024156332571452221458230e-04
 	 1.56622805575734602712145715486258e-02 3.07498706149567091472363244974986e-03 9.81262732380930868814061796001624e-01 2.78506380891729973716536283845358e-04
 	 2.98523728321309356203983043087646e-03 3.11458906320372097553672574576922e-03 9.93900173653583185462423443823354e-01 1.22221156549903758230593564526600e-04
 	 ];
 
 	 case  41 

 	 % ALG. DEG.:   41
 	 % PTS CARD.:  441
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 9.92435490725621538565803803066956e-01 7.54087839273511698762186838962407e-03 2.36308816433444465743285434200516e-05 1.53544142945723091170330196209015e-06
 	 9.74791975660365683786778845387744e-01 2.51292766220987638658979079764322e-02 7.87477175355523473232466358240345e-05 9.10577066635841883882572511677012e-06
 	 9.47485544406397428573995966871735e-01 5.23504049143466432258975373770227e-02 1.64050679255928200106495751242619e-04 2.68890183865504129798185140032274e-05
 	 9.11074265802615856912893832486589e-01 8.86479377900232096143540161392593e-02 2.77796407360933472752151374152163e-04 5.80152475764312181190363038041369e-05
 	 8.66299758970956568226995386794442e-01 1.33282572882062244623568858514773e-01 4.17668146981187149435754690784961e-04 1.04217656115977841250509750015141e-04
 	 8.14073616512697384450802928768098e-01 1.85345565326704209141439605446067e-01 5.80818160598406407757465785834938e-04 1.65605482698418329280676264403382e-04
 	 7.55459054449687084087372568319552e-01 2.43777020498249508140276020640158e-01 7.63925052063407772351411040290259e-04 2.40576728048201880305959066141952e-04
 	 6.91649315012962340176727593643591e-01 3.07387423752595090320482995593920e-01 9.63261234442569502789410762488842e-04 3.25879308606591075458958073340909e-04
 	 6.23943389721281937987384935695445e-01 3.74881841509669966328033297031652e-01 1.17476876904809568458176727290265e-03 4.16817080492601073175851222885058e-04
 	 5.53719580728293414573215613927459e-01 4.44886277314171185714997136528837e-01 1.39414195753539971178724954370409e-03 5.07585211482041256426944730861806e-04
 	 4.82407444612438895958916873496491e-01 5.15975640400452073563997146266047e-01 1.61691498710903047708598023746163e-03 5.91708648892600276927855595943129e-04
 	 4.11458691561905287592537661112146e-01 5.86702755599107672601633112208219e-01 1.83855283898703980582922667963430e-03 6.62548809106855299613791920876338e-04
 	 3.42317632958730744263675660477020e-01 6.55627823433643119876990112970816e-01 2.05454360762613585933422655216418e-03 7.13837804583759795093444999736221e-04
 	 2.76391779093783207521539679873968e-01 7.21347730555263910723340359254507e-01 2.26049035095288175511996087152511e-03 7.40197003545149255672452870413736e-04
 	 2.15023185358020230140141393349040e-01 7.82524614039563082279471473157173e-01 2.45220060241668758038713349378668e-03 7.37597697506709392388513091276536e-04
 	 1.59461129444065097260363472742029e-01 8.37913098830852853815542857773835e-01 2.62577172508204892409366948413663e-03 7.03726063498771783194518647519544e-04
 	 1.10836673320363510164554554648930e-01 8.86385656301785784805247203621548e-01 2.77767037785070503019824172952212e-03 6.38222117915249100711383434259005e-04
 	 7.01396190623257975715887369005941e-02 9.26955576434195016588546423008665e-01 2.90480450347918583986484009074047e-03 5.42772455869645919536436995400663e-04
 	 3.81982882450735417023679474368691e-02 9.58797125258895377442058816086501e-01 3.00458649603108085557323647662997e-03 4.21049045024146195281139481991772e-04
 	 1.56622805575734602712145715486258e-02 9.81262732380930868814061796001624e-01 3.07498706149567091472363244974986e-03 2.78506380891723305873175497993088e-04
 	 2.98523728321309356203983043087646e-03 9.93900173653583185462423443823354e-01 3.11458906320372097553672574576922e-03 1.22221156549900803779673541527018e-04
 	 9.92435490725621427543501340551302e-01 7.44055283257057629986430669077890e-03 1.23956441807996156634352757919260e-04 3.54245933668821326204228898404391e-06
 	 9.74791975660365683786778845387744e-01 2.47949510140806558822212934956042e-02 4.13073325553660330999861116652028e-04 2.10081750407018895843852535065821e-05
 	 9.47485544406397317551693504356081e-01 5.16539232282167831700192550670181e-02 8.60532365385899278287240576901240e-04 6.20363970975356537754588637234576e-05
 	 9.11074265802615856912893832486589e-01 8.74685454761538333512405074543494e-02 1.45718872123030973586566005906207e-03 1.33848580287465509499819638072893e-04
 	 8.66299758970956679249297849310096e-01 1.31509351237559052316683505523542e-01 2.19088979148426843401864516636124e-03 2.40443433316966335153500033960938e-04
 	 8.14073616512697495473105391283752e-01 1.82879685796896424010427040229843e-01 3.04669769040608051646756848640507e-03 3.82072983792776637440580245197452e-04
 	 7.55459054449686862042767643288244e-01 2.40533755607478749727334843555582e-01 4.00718994283438822989751315617468e-03 5.55041214932902463377595303484213e-04
 	 6.91649315012962340176727593643591e-01 3.03297871598402490889156979392283e-01 5.05281338863516893411542696412653e-03 7.51845154923946835598402849143440e-04
 	 6.23943389721281937987384935695445e-01 3.69894328280282014276281188358553e-01 6.16228199843604773633387594600208e-03 9.61650200492565349758011805647584e-04
 	 5.53719580728293525595518076443113e-01 4.38967409158962429405193006459740e-01 7.31301011274404499928891709714662e-03 1.17106386286257475870531408190800e-03
 	 4.82407444612438895958916873496491e-01 5.09110983200263711445643366459990e-01 8.48157218729739259543976004351862e-03 1.36514736912479923459928787821127e-03
 	 4.11458691561905287592537661112146e-01 5.78897128782175141026300480007194e-01 9.64417965591957138116185888065957e-03 1.52858465963231484815998406645576e-03
 	 3.42317632958730744263675660477020e-01 6.46905201847700506156968458526535e-01 1.07771651935687495793558809964452e-02 1.64691491789605449352906774151961e-03
 	 2.76391779093783207521539679873968e-01 7.11750756386963057131822552037193e-01 1.18574645192537353466377680888399e-02 1.70772895396215486710222997146502e-03
 	 2.15023185358020230140141393349040e-01 7.72113728707995550237797033332754e-01 1.28630859339842196220615733182058e-02 1.70173202319805769514027282696134e-03
 	 1.59461129444065097260363472742029e-01 8.26765312507922733864518249902176e-01 1.37735580480121688751182773557957e-02 1.62358584071376713803269709046617e-03
 	 1.10836673320363510164554554648930e-01 8.74592980056540514333107694255887e-01 1.45703466230959755023377510951832e-02 1.47245987838754994331269543295093e-03
 	 7.01396190623257975715887369005941e-02 9.14623148750040915189174484112300e-01 1.52372321876332872392367789871059e-02 1.25224532639600476258134875706673e-03
 	 3.81982882450735417023679474368691e-02 9.46041070371652748072222038899781e-01 1.57606413832737102254100136633497e-02 9.71413882766401608204187567707777e-04
 	 1.56622805575734602712145715486258e-02 9.68207789950146113788775892317062e-01 1.61299294922804259400095361343119e-02 6.42549764770828876238317750591023e-04
 	 2.98523728321309356203983043087646e-03 9.80677099831640308735813960083760e-01 1.63376628851465977021462094853632e-02 2.81979806493874414832778718675854e-04
 	 9.92435490725621427543501340551302e-01 7.26230461045436134770447722530662e-03 3.02204663924211108794182223391545e-04 5.47701277879045602873077716599148e-06
 	 9.74791975660365683786778845387744e-01 2.42009553748894733204988227726062e-02 1.00706896474484289272233183965000e-03 3.24808366790063312678875362404796e-05
 	 9.47485544406397428573995966871735e-01 5.04164856092736007875387826970837e-02 2.09796998432897063846525043118163e-03 9.59147607241050639435495095419526e-05
 	 9.11074265802615856912893832486589e-01 8.53731215106164065264948703770642e-02 3.55261268676773656061129713634728e-03 2.06943909578581955455156560219621e-04
 	 8.66299758970956568226995386794442e-01 1.28358871887807146627835663821315e-01 5.34136914123628514516894938424230e-03 3.71750705283870541088125927231545e-04
 	 8.14073616512697384450802928768098e-01 1.78498562567480867357971874298528e-01 7.42782091982174819122519693337381e-03 5.90724808889405914036352385210193e-04
 	 7.55459054449686973065070105803898e-01 2.34771453361832721506985421910940e-01 9.76949218848030542794447228516219e-03 8.58151791739380359613775794969115e-04
 	 6.91649315012962340176727593643591e-01 2.96031972464215475948634548331029e-01 1.23187125228221838746378580253804e-02 1.16243127438122456629443490783160e-03
 	 6.23943389721281826965082473179791e-01 3.61033023499511662723904237282113e-01 1.50235867792065103110132895380957e-02 1.48681182653974744423130971426872e-03
 	 5.53719580728293525595518076443113e-01 4.28451367943982697195082209873362e-01 1.78290513277237772093997136835242e-02 1.81058725932315561779617496540595e-03
 	 4.82407444612438895958916873496491e-01 4.96914560480430256284023471380351e-01 2.06779949071308477570596551231574e-02 2.11066066678375872933681733911726e-03
 	 4.11458691561905287592537661112146e-01 5.65028887225995646303999819792807e-01 2.35124212120990661034625190950464e-02 2.36335181820214370457255981250455e-03
 	 3.42317632958730744263675660477020e-01 6.31407737519200318310197417304153e-01 2.62746295220689374261269222188275e-02 2.54630277826424890677547985262663e-03
 	 2.76391779093783207521539679873968e-01 6.94699831573891479763460665708408e-01 2.89083893323253127149996544176247e-02 2.6403276409392