
 	function [xyw,pointset_stats]=set_stroud_standard(deg)
 	
 	 %--------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
 	 %--------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 %--------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
 	 %      REMARK: The sum of the weights makes 1/2.
 	 % 
 	 % pointset_stats:
 	 %    statistics of the pointset stored in a matrix. Each rows contains
 	 %    degree, cardinality of the full pointset, moment error w.r.t. orthn. 
 	 %    Dubiner basis,number of points with negative weights, number of
 	 %    points outside the domain.
 	 %--------------------------------------------------------------------
     % SOURCE:
  	 % A.H. Stroud,
  	 % "Approximate calculation of multiple intregrals",
  	 % Prentice Hall, Englewoods Cliffs, N.J., 1971
 	 %--------------------------------------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %--------------------------------------------------------------------
 	 % |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
 	 % |   2 |   4 |   0 |   0 | 2.15e-16 |PI|
 	 % |   3 |   4 |   0 |   0 | 2.15e-16 |PI|
 	 % |   4 |   9 |   0 |   0 | 4.72e-16 |PI|
 	 % |   5 |   9 |   0 |   0 | 6.66e-16 |PI|
 	 % |   6 |  16 |   0 |   0 | 4.16e-16 |PI|
 	 % |   7 |  16 |   0 |   0 | 4.16e-16 |PI|
 	 % |   8 |  25 |   0 |   0 | 1.01e-15 |PI|
 	 % |   9 |  25 |   0 |   0 | 1.01e-15 |PI|
 	 % |  10 |  36 |   0 |   0 | 9.99e-16 |PI|
 	 % |  11 |  36 |   0 |   0 | 9.99e-16 |PI|
 	 % |  12 |  49 |   0 |   0 | 7.91e-16 |PI|
 	 % |  13 |  49 |   0 |   0 | 7.91e-16 |PI|
 	 % |  14 |  64 |   0 |   0 | 1.09e-15 |PI|
 	 % |  15 |  64 |   0 |   0 | 1.09e-15 |PI|
 	 % |  16 |  81 |   0 |   0 | 1.12e-15 |PI|
 	 % |  17 |  81 |   0 |   0 | 1.12e-15 |PI|
 	 % |  18 | 100 |   0 |   0 | 1.01e-15 |PI|
 	 % |  19 | 100 |   0 |   0 | 1.01e-15 |PI|
 	 % |  20 | 121 |   0 |   0 | 1.09e-15 |PI|
 	 % |  21 | 121 |   0 |   0 | 1.36e-15 |PI|
 	 % |  22 | 144 |   0 |   0 | 7.95e-16 |PI|
 	 % |  23 | 144 |   0 |   0 | 9.60e-16 |PI|
 	 % |  24 | 169 |   0 |   0 | 1.32e-15 |PI|
 	 % |  25 | 169 |   0 |   0 | 1.32e-15 |PI|
 	 % |  26 | 196 |   0 |   0 | 1.31e-15 |PI|
 	 % |  27 | 196 |   0 |   0 | 1.31e-15 |PI|
 	 % |  28 | 225 |   0 |   0 | 1.24e-15 |PI|
 	 % |  29 | 225 |   0 |   0 | 1.24e-15 |PI|
 	 % |  30 | 256 |   0 |   0 | 1.28e-15 |PI|
 	 % |  31 | 256 |   0 |   0 | 1.60e-15 |PI|
 	 % |  32 | 289 |   0 |   0 | 8.88e-16 |PI|
 	 % |  33 | 289 |   0 |   0 | 1.02e-15 |PI|
 	 % |  34 | 324 |   0 |   0 | 1.33e-15 |PI|
 	 % |  35 | 324 |   0 |   0 | 1.33e-15 |PI|
 	 % |  36 | 361 |   0 |   0 | 1.55e-15 |PI|
 	 % |  37 | 361 |   0 |   0 | 1.55e-15 |PI|
 	 % |  38 | 400 |   0 |   0 | 1.14e-15 |PI|
 	 % |  39 | 400 |   0 |   0 | 1.14e-15 |PI|
 	 % |  40 | 441 |   0 |   0 | 1.27e-15 |PI|
 	 % |  41 | 441 |   0 |   0 | 1.27e-15 |PI|
 	 % |  42 | 484 |   0 |   0 | 1.52e-15 |PI|
 	 % |  43 | 484 |   0 |   0 | 1.52e-15 |PI|
 	 % |  44 | 529 |   0 |   0 | 1.33e-15 |PI|
 	 % |  45 | 529 |   0 |   0 | 1.33e-15 |PI|
 	 % |  46 | 576 |   0 |   0 | 1.75e-15 |PI|
 	 % |  47 | 576 |   0 |   0 | 2.05e-15 |PI|
 	 % |  48 | 625 |   0 |   0 | 1.86e-15 |PI|
 	 % |  49 | 625 |   0 |   0 | 1.86e-15 |PI|
 	 % |  50 | 676 |   0 |   0 | 1.08e-15 |PI|
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
     % REMARK:
     % We remark that the rules for even degrees and their successive
     % integer are the same.
     %--------------------------------------
  	 % (  1) deg:   1 cub.err.: 1.92e-16
 	 % (  1) deg:   2 cub.err.: 6.80e-01
 	 %--------------------------------------
 	 % (  2) deg:   2 cub.err.: 2.15e-16
 	 % (  2) deg:   3 cub.err.: 2.15e-16
 	 % (  2) deg:   4 cub.err.: 5.30e-01
 	 %--------------------------------------
 	 % (  3) deg:   3 cub.err.: 2.15e-16
 	 % (  3) deg:   4 cub.err.: 5.30e-01
 	 %--------------------------------------
 	 % (  4) deg:   4 cub.err.: 4.72e-16
 	 % (  4) deg:   5 cub.err.: 6.66e-16
 	 % (  4) deg:   6 cub.err.: 4.76e-01
 	 %--------------------------------------
 	 % (  5) deg:   5 cub.err.: 6.66e-16
 	 % (  5) deg:   6 cub.err.: 4.76e-01
 	 %--------------------------------------------------------------------
 
 
 	 switch deg
 
 	 case   1 

 	 % ALG. DEG.:    1
 	 % PTS CARD.:    1
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.9e-16  

 	 xyw=[
 	 3.33333333333333425851918718763045e-01 3.33333333333333314829616256247391e-01 5.00000000000000000000000000000000e-01
 	 ];
 
 	 case   2 

 	 % ALG. DEG.:    2
 	 % PTS CARD.:    4
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.2e-16  

 	 xyw=[
 	 6.44948974278317765929102733934997e-01 2.80019915499074123488298937445506e-01 9.09793091280113874752544234070228e-02
 	 1.55051025721682167457515788555611e-01 6.66390246014701426169324349757517e-01 1.59020690871988584769169960964064e-01
 	 6.44948974278317765929102733934997e-01 7.50311102226081105825983286194969e-02 9.09793091280113874752544234070228e-02
 	 1.55051025721682167457515788555611e-01 1.78558728263616406373159861686872e-01 1.59020690871988584769169960964064e-01
 	 ];
 
 	 case   3 

 	 % ALG. DEG.:    3
 	 % PTS CARD.:    4
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.2e-16  

 	 xyw=[
 	 6.44948974278317765929102733934997e-01 2.80019915499074123488298937445506e-01 9.09793091280113874752544234070228e-02
 	 1.55051025721682167457515788555611e-01 6.66390246014701426169324349757517e-01 1.59020690871988584769169960964064e-01
 	 6.44948974278317765929102733934997e-01 7.50311102226081105825983286194969e-02 9.09793091280113874752544234070228e-02
 	 1.55051025721682167457515788555611e-01 1.78558728263616406373159861686872e-01 1.59020690871988584769169960964064e-01
 	 ];
 
 	 case   4 

 	 % ALG. DEG.:    4
 	 % PTS CARD.:    9
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.7e-16  

 	 xyw=[
 	 7.87659461760847112721251050970750e-01 1.88409405952072228629390338028315e-01 1.93963833059595212870984681785558e-02
 	 4.09466864440734656938047919538803e-01 5.23979067720100832872276441776194e-01 6.36780850998851372102294021715352e-02
 	 8.85879595127039287660863919882104e-02 8.08694385677669824730173786520027e-01 5.58144204830443302345344136483618e-02
 	 7.87659461760847223743553513486404e-01 1.06170269119576415883798858885712e-01 3.10342132895352063037819334567757e-02
 	 4.09466864440734656938047919538803e-01 2.95266567779632671530976040230598e-01 1.01884936159816127942967511899042e-01
 	 8.85879595127039287660863919882104e-02 4.55706020243648035616956804005895e-01 8.93030727728708478840857765135297e-02
 	 7.87659461760847223743553513486404e-01 2.39311322870806031382073797431076e-02 1.93963833059595212870984681785558e-02
 	 4.09466864440734656938047919538803e-01 6.65540678391645101896756386850029e-02 6.36780850998851372102294021715352e-02
 	 8.85879595127039287660863919882104e-02 1.02717654809626246503739821491763e-01 5.58144204830443302345344136483618e-02
 	 ];
 
 	 case   5 

 	 % ALG. DEG.:    5
 	 % PTS CARD.:    9
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 6.7e-16  

 	 xyw=[
 	 7.87659461760847112721251050970750e-01 1.88409405952072228629390338028315e-01 1.93963833059595212870984681785558e-02
 	 4.09466864440734656938047919538803e-01 5.23979067720100832872276441776194e-01 6.36780850998851372102294021715352e-02
 	 8.85879595127039287660863919882104e-02 8.08694385677669824730173786520027e-01 5.58144204830443302345344136483618e-02
 	 7.87659461760847223743553513486404e-01 1.06170269119576415883798858885712e-01 3.10342132895352063037819334567757e-02
 	 4.09466864440734656938047919538803e-01 2.95266567779632671530976040230598e-01 1.01884936159816127942967511899042e-01
 	 8.85879595127039287660863919882104e-02 4.55706020243648035616956804005895e-01 8.93030727728708478840857765135297e-02
 	 7.87659461760847223743553513486404e-01 2.39311322870806031382073797431076e-02 1.93963833059595212870984681785558e-02
 	 4.09466864440734656938047919538803e-01 6.65540678391645101896756386850029e-02 6.36780850998851372102294021715352e-02
 	 8.85879595127039287660863919882104e-02 1.02717654809626246503739821491763e-01 5.58144204830443302345344136483618e-02
 	 ];
 
 	 case   6 

 	 % ALG. DEG.:    6
 	 % PTS CARD.:   16
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.2e-16  

 	 xyw=[
 	 8.60240135656219373494479896180565e-01 1.30056079216834458156526466154901e-01 5.42322591052525528748651240107392e-03
 	 5.83590432368916722793983353767544e-01 3.87497483406694154250970996145043e-01 2.25840492823699452717978175542157e-02
 	 2.76843013638123802699908537761075e-01 6.72946863150506446871190746605862e-01 3.53880678980859689208848806174501e-02
 	 5.71041961145177801029149122769013e-02 8.77428809330467740501546813902678e-01 2.35683681933823371834613169539807e-02
 	 8.60240135656219484516782358696219e-01 9.36377844373285223023017920240818e-02 1.01672595644787828322863632024564e-02
 	 5.83590432368916833816285816283198e-01 2.78990463496508800389506177452859e-01 4.23397245217462941946351406841131e-02
 	 2.76843013638123802699908537761075e-01 4.84508326630433305837186708231457e-01 6.63442161070497554709035625819524e-02
 	 5.71041961145177801029149122769013e-02 6.31731251641125313156521769997198e-01 4.41850885223617137476104232973739e-02
 	 8.60240135656219484516782358696219e-01 4.61220799064520348142792727230699e-02 1.01672595644787776281159352720351e-02
 	 5.83590432368916944838588278798852e-01 1.37419104134574310283056775006116e-01 4.23397245217462733779534289624280e-02
 	 2.76843013638123858211059769018902e-01 2.38648659731442835951753522749641e-01 6.63442161070497138375401391385822e-02
 	 5.71041961145177801029149122769013e-02 3.11164552244356906740563317725901e-01 4.41850885223616929309287115756888e-02
 	 8.60240135656219373494479896180565e-01 9.70378512694611283784240640670760e-03 5.42322591052525788957172636628457e-03
 	 5.83590432368916722793983353767544e-01 2.89120842243890119327431875717593e-02 2.25840492823699556801386734150583e-02
 	 2.76843013638123802699908537761075e-01 5.02101232113698614512031781487167e-02 3.53880678980859897375665923391352e-02
 	 5.71041961145177801029149122769013e-02 6.54669945550144793955382738204207e-02 2.35683681933823510612491247684375e-02
 	 ];
 
 	 case   7 

 	 % ALG. DEG.:    7
 	 % PTS CARD.:   16
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.2e-16  

 	 xyw=[
 	 8.60240135656219373494479896180565e-01 1.30056079216834458156526466154901e-01 5.42322591052525528748651240107392e-03
 	 5.83590432368916722793983353767544e-01 3.87497483406694154250970996145043e-01 2.25840492823699452717978175542157e-02
 	 2.76843013638123802699908537761075e-01 6.72946863150506446871190746605862e-01 3.53880678980859689208848806174501e-02
 	 5.71041961145177801029149122769013e-02 8.77428809330467740501546813902678e-01 2.35683681933823371834613169539807e-02
 	 8.60240135656219484516782358696219e-01 9.36377844373285223023017920240818e-02 1.01672595644787828322863632024564e-02
 	 5.83590432368916833816285816283198e-01 2.78990463496508800389506177452859e-01 4.23397245217462941946351406841131e-02
 	 2.76843013638123802699908537761075e-01 4.84508326630433305837186708231457e-01 6.63442161070497554709035625819524e-02
 	 5.71041961145177801029149122769013e-02 6.31731251641125313156521769997198e-01 4.41850885223617137476104232973739e-02
 	 8.60240135656219484516782358696219e-01 4.61220799064520348142792727230699e-02 1.01672595644787776281159352720351e-02
 	 5.83590432368916944838588278798852e-01 1.37419104134574310283056775006116e-01 4.23397245217462733779534289624280e-02
 	 2.76843013638123858211059769018902e-01 2.38648659731442835951753522749641e-01 6.63442161070497138375401391385822e-02
 	 5.71041961145177801029149122769013e-02 3.11164552244356906740563317725901e-01 4.41850885223616929309287115756888e-02
 	 8.60240135656219373494479896180565e-01 9.70378512694611283784240640670760e-03 5.42322591052525788957172636628457e-03
 	 5.83590432368916722793983353767544e-01 2.89120842243890119327431875717593e-02 2.25840492823699556801386734150583e-02
 	 2.76843013638123802699908537761075e-01 5.02101232113698614512031781487167e-02 3.53880678980859897375665923391352e-02
 	 5.71041961145177801029149122769013e-02 6.54669945550144793955382738204207e-02 2.35683681933823510612491247684375e-02
 	 ];
 
 	 case   8 

 	 % ALG. DEG.:    8
 	 % PTS CARD.:   25
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw=[
 	 9.01464914201173583840898118069163e-01 9.39127973337799820674476336535008e-02 1.86555216687783525716937127469919e-03
 	 6.95464273353636031060887034982443e-01 2.90249932250792541665873613965232e-01 8.75549918216381693747418779594227e-03
 	 4.37974810247386159289817442186177e-01 5.35660544808142846662235569965560e-01 1.73415064313656649974682011361438e-02
 	 1.98013417873607933117341417528223e-01 7.64365329781280800069964698195690e-01 1.98040831320473557919381590863850e-02
 	 3.98098570514688887556076224427670e-02 9.15147549378727331870209127373528e-01 1.14650803515924971931472242658856e-02
 	 9.01464914201173583840898118069163e-01 7.57966027350623905434190419327933e-02 3.76870169532761683378607742156419e-03
 	 6.95464273353636031060887034982443e-01 2.34259434638082242319256920382031e-01 1.76874521104834515894399515900659e-02
 	 4.37974810247386159289817442186177e-01 4.32329252970359734220551217731554e-01 3.50325045033716767073350695227418e-02
 	 1.98013417873607933117341417528223e-01 6.16915871859002651333980793424416e-01 4.00072873861604602629959970272466e-02
 	 3.98098570514688887556076224427670e-02 7.38611533396152042385551794723142e-01 2.31612219294983039119539824923777e-02
 	 9.01464914201173694863200580584817e-01 4.92675428994132080795509409654187e-02 4.47940679728135986853443384347884e-03
 	 6.95464273353636031060887034982443e-01 1.52267863323181984469556482508779e-01 2.10229674873220820363606264891132e-02
 	 4.37974810247386159289817442186177e-01 2.81012594876306920355091278906912e-01 4.16389652151949660185970003567490e-02
 	 1.98013417873607933117341417528223e-01 4.00993291063196033441329291235888e-01 4.75518970579541094823028402061027e-02
 	 3.98098570514688887556076224427670e-02 4.80095071474265555622196188778616e-01 2.75289856644697419896239409808913e-02
 	 9.01464914201173583840898118069163e-01 2.27384830637640394934706478125008e-02 3.76870169532762030323302937517838e-03
 	 6.95464273353636031060887034982443e-01 7.02762920082817543754316602644394e-02 1.76874521104834689366747113581368e-02
 	 4.37974810247386103778666210928350e-01 1.29695936782254162000782571340096e-01 3.50325045033717114018045890588837e-02
 	 1.98013417873607933117341417528223e-01 1.85070710267389526570980251563014e-01 4.00072873861604949574655165633885e-02
 	 3.98098570514688887556076224427670e-02 2.21578609552379179881143045349745e-01 2.31612219294983247286356942140628e-02
 	 9.01464914201173583840898118069163e-01 4.62228846504643409165424827733659e-03 1.86555216687783482348850228049741e-03
 	 6.95464273353636031060887034982443e-01 1.42857943955714272732393510523252e-02 8.75549918216381520275071181913518e-03
 	 4.37974810247386159289817442186177e-01 2.63646449444709940479469878482632e-02 1.73415064313656615280212491825296e-02
 	 1.98013417873607933117341417528223e-01 3.76212523451112668126938842760865e-02 1.98040831320473523224912071327708e-02
 	 3.98098570514688887556076224427670e-02 4.50425935698037793741832501837052e-02 1.14650803515924937237002723122714e-02
 	 ];
 
 	 case   9 

 	 % ALG. DEG.:    9
 	 % PTS CARD.:   25
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw=[
 	 9.01464914201173583840898118069163e-01 9.39127973337799820674476336535008e-02 1.86555216687783525716937127469919e-03
 	 6.95464273353636031060887034982443e-01 2.90249932250792541665873613965232e-01 8.75549918216381693747418779594227e-03
 	 4.37974810247386159289817442186177e-01 5.35660544808142846662235569965560e-01 1.73415064313656649974682011361438e-02
 	 1.98013417873607933117341417528223e-01 7.64365329781280800069964698195690e-01 1.98040831320473557919381590863850e-02
 	 3.98098570514688887556076224427670e-02 9.15147549378727331870209127373528e-01 1.14650803515924971931472242658856e-02
 	 9.01464914201173583840898118069163e-01 7.57966027350623905434190419327933e-02 3.76870169532761683378607742156419e-03
 	 6.95464273353636031060887034982443e-01 2.34259434638082242319256920382031e-01 1.76874521104834515894399515900659e-02
 	 4.37974810247386159289817442186177e-01 4.32329252970359734220551217731554e-01 3.50325045033716767073350695227418e-02
 	 1.98013417873607933117341417528223e-01 6.16915871859002651333980793424416e-01 4.00072873861604602629959970272466e-02
 	 3.98098570514688887556076224427670e-02 7.38611533396152042385551794723142e-01 2.31612219294983039119539824923777e-02
 	 9.01464914201173694863200580584817e-01 4.92675428994132080795509409654187e-02 4.47940679728135986853443384347884e-03
 	 6.95464273353636031060887034982443e-01 1.52267863323181984469556482508779e-01 2.10229674873220820363606264891132e-02
 	 4.37974810247386159289817442186177e-01 2.81012594876306920355091278906912e-01 4.16389652151949660185970003567490e-02
 	 1.98013417873607933117341417528223e-01 4.00993291063196033441329291235888e-01 4.75518970579541094823028402061027e-02
 	 3.98098570514688887556076224427670e-02 4.80095071474265555622196188778616e-01 2.75289856644697419896239409808913e-02
 	 9.01464914201173583840898118069163e-01 2.27384830637640394934706478125008e-02 3.76870169532762030323302937517838e-03
 	 6.95464273353636031060887034982443e-01 7.02762920082817543754316602644394e-02 1.76874521104834689366747113581368e-02
 	 4.37974810247386103778666210928350e-01 1.29695936782254162000782571340096e-01 3.50325045033717114018045890588837e-02
 	 1.98013417873607933117341417528223e-01 1.85070710267389526570980251563014e-01 4.00072873861604949574655165633885e-02
 	 3.98098570514688887556076224427670e-02 2.21578609552379179881143045349745e-01 2.31612219294983247286356942140628e-02
 	 9.01464914201173583840898118069163e-01 4.62228846504643409165424827733659e-03 1.86555216687783482348850228049741e-03
 	 6.95464273353636031060887034982443e-01 1.42857943955714272732393510523252e-02 8.75549918216381520275071181913518e-03
 	 4.37974810247386159289817442186177e-01 2.63646449444709940479469878482632e-02 1.73415064313656615280212491825296e-02
 	 1.98013417873607933117341417528223e-01 3.76212523451112668126938842760865e-02 1.98040831320473523224912071327708e-02
 	 3.98098570514688887556076224427670e-02 4.50425935698037793741832501837052e-02 1.14650803515924937237002723122714e-02
 	 ];
 
 	 case  10 

 	 % ALG. DEG.:   10
 	 % PTS CARD.:   36
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw=[
 	 9.26945671319741149041249173023971e-01 7.05876315275886512257130789294024e-02 7.48542561236319398468297414694916e-04
 	 7.69233862030054504899112544080708e-01 2.22974263268659017578343650711759e-01 3.76529821269167312355885535168909e-03
 	 5.58671518771550079662802090751939e-01 4.26426917861778609353251567881671e-01 8.45153579694312914738496544941881e-03
 	 3.36984690281154297686327936389716e-01 6.40628436740814932726095776160946e-01 1.20606064042651020540297679417563e-02
 	 1.48078599668484356399744683585595e-01 8.23156067318956408129793089756276e-01 1.16108747669975229804828487090163e-02
 	 2.93164271597847747585774413892068e-02 9.37908206225755214369144141528523e-01 6.19426535265885438996669165589992e-03
 	 9.26945671319741038018946710508317e-01 6.06792682628188653759515602814645e-02 1.57622175402359013945963184255561e-03
 	 7.69233862030054504899112544080708e-01 1.91675437237121243372328649456904e-01 7.92866733379648212787227379294563e-03
 	 5.58671518771550079662802090751939e-01 3.66569507765800772780551142204786e-01 1.77965759970262864253509604850478e-02
 	 3.36984690281154297686327936389716e-01 5.50703627937891959653882167913252e-01 2.53962715890476316282775570698504e-02
 	 1.48078599668484356399744683585595e-01 7.07609913381099020490694329055259e-01 2.44492622580578244928517506195931e-02
 	 2.93164271597847747585774413892068e-02 8.06254331245387700910498551820638e-01 1.30433943300828358857756938959938e-02
 	 9.26945671319741149041249173023971e-01 4.52432465648983095363178108527791e-02 2.04438659154486217228718913929697e-03
 	 7.69233862030054504899112544080708e-01 1.42915682993948300882891544461017e-01 1.02836172287663323715589669404835e-02
 	 5.58671518771550079662802090751939e-01 2.73318962107257978910723750232137e-01 2.30824636513582530372712398047952e-02
 	 3.36984690281154353197479167647543e-01 4.10611741642327665591238883280312e-01 3.29393989007866830331927587849350e-02
 	 1.48078599668484356399744683585595e-01 5.27603095742739558460243642912246e-01 3.17111115907040067019018181326828e-02
 	 2.93164271597847747585774413892068e-02 6.01153648467838364055637612182181e-01 1.69175056800126739908751716257029e-02
 	 9.26945671319741038018946710508317e-01 2.78110821153605969335842473810771e-02 2.04438659154486347332979612190229e-03
 	 7.69233862030054504899112544080708e-01 8.78504549759971942179959114582743e-02 1.02836172287663393104528708477119e-02
 	 5.58671518771550079662802090751939e-01 1.68009519121191885915322927758098e-01 2.30824636513582703845059995728661e-02
 	 3.36984690281154353197479167647543e-01 2.52403568076518036722433180329972e-01 3.29393989007867038498744705066201e-02
 	 1.48078599668484356399744683585595e-01 3.24318304588776085140011673502158e-01 3.17111115907040275185835298543680e-02
 	 2.93164271597847747585774413892068e-02 3.69529924372376861185784946428612e-01 1.69175056800126843992160274865455e-02
 	 9.26945671319741038018946710508317e-01 1.23750604174400341550565940451634e-02 1.57622175402358775421485237444585e-03
 	 7.69233862030054504899112544080708e-01 3.90907007328242239729831908334745e-02 7.92866733379646998480794195529597e-03
 	 5.58671518771550079662802090751939e-01 7.47589734626490365343443045276217e-02 1.77965759970262586697753448561343e-02
 	 3.36984690281154297686327936389716e-01 1.12311681780953631637487433181377e-01 2.53962715890475899949141336264802e-02
 	 1.48078599668484356399744683585595e-01 1.44311486950416512087258524843492e-01 2.44492622580577863289352791298370e-02
 	 2.93164271597847747585774413892068e-02 1.64429241594827413308621544274502e-01 1.30433943300828150690939821743086e-02
 	 9.26945671319741149041249173023971e-01 2.46669715267025524418897930445382e-03 7.48542561236320157409818154548020e-04
 	 7.69233862030054504899112544080708e-01 7.79187470128644976696818957861979e-03 3.76529821269167746036754529370683e-03
 	 5.58671518771550079662802090751939e-01 1.49015633666711999616438788507367e-02 8.45153579694313782100234533345429e-03
 	 3.36984690281154297686327936389716e-01 2.23868729780306585652738249336835e-02 1.20606064042651159318175757562130e-02
 	 1.48078599668484356399744683585595e-01 2.87653330125592354704622266581282e-02 1.16108747669975368582706565234730e-02
 	 2.93164271597847747585774413892068e-02 3.27753666144600108722784170822706e-02 6.19426535265886132886059556312830e-03
 	 ];
 
 	 case  11 

 	 % ALG. DEG.:   11
 	 % PTS CARD.:   36
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw=[
 	 9.26945671319741149041249173023971e-01 7.05876315275886512257130789294024e-02 7.48542561236319398468297414694916e-04
 	 7.69233862030054504899112544080708e-01 2.22974263268659017578343650711759e-01 3.76529821269167312355885535168909e-03
 	 5.58671518771550079662802090751939e-01 4.26426917861778609353251567881671e-01 8.45153579694312914738496544941881e-03
 	 3.36984690281154297686327936389716e-01 6.40628436740814932726095776160946e-01 1.20606064042651020540297679417563e-02
 	 1.48078599668484356399744683585595e-01 8.23156067318956408129793089756276e-01 1.16108747669975229804828487090163e-02
 	 2.93164271597847747585774413892068e-02 9.37908206225755214369144141528523e-01 6.19426535265885438996669165589992e-03
 	 9.26945671319741038018946710508317e-01 6.06792682628188653759515602814645e-02 1.57622175402359013945963184255561e-03
 	 7.69233862030054504899112544080708e-01 1.91675437237121243372328649456904e-01 7.92866733379648212787227379294563e-03
 	 5.58671518771550079662802090751939e-01 3.66569507765800772780551142204786e-01 1.77965759970262864253509604850478e-02
 	 3.36984690281154297686327936389716e-01 5.50703627937891959653882167913252e-01 2.53962715890476316282775570698504e-02
 	 1.48078599668484356399744683585595e-01 7.07609913381099020490694329055259e-01 2.44492622580578244928517506195931e-02
 	 2.93164271597847747585774413892068e-02 8.06254331245387700910498551820638e-01 1.30433943300828358857756938959938e-02
 	 9.26945671319741149041249173023971e-01 4.52432465648983095363178108527791e-02 2.04438659154486217228718913929697e-03
 	 7.69233862030054504899112544080708e-01 1.42915682993948300882891544461017e-01 1.02836172287663323715589669404835e-02
 	 5.58671518771550079662802090751939e-01 2.73318962107257978910723750232137e-01 2.30824636513582530372712398047952e-02
 	 3.36984690281154353197479167647543e-01 4.10611741642327665591238883280312e-01 3.29393989007866830331927587849350e-02
 	 1.48078599668484356399744683585595e-01 5.27603095742739558460243642912246e-01 3.17111115907040067019018181326828e-02
 	 2.93164271597847747585774413892068e-02 6.01153648467838364055637612182181e-01 1.69175056800126739908751716257029e-02
 	 9.26945671319741038018946710508317e-01 2.78110821153605969335842473810771e-02 2.04438659154486347332979612190229e-03
 	 7.69233862030054504899112544080708e-01 8.78504549759971942179959114582743e-02 1.02836172287663393104528708477119e-02
 	 5.58671518771550079662802090751939e-01 1.68009519121191885915322927758098e-01 2.30824636513582703845059995728661e-02
 	 3.36984690281154353197479167647543e-01 2.52403568076518036722433180329972e-01 3.29393989007867038498744705066201e-02
 	 1.48078599668484356399744683585595e-01 3.24318304588776085140011673502158e-01 3.17111115907040275185835298543680e-02
 	 2.93164271597847747585774413892068e-02 3.69529924372376861185784946428612e-01 1.69175056800126843992160274865455e-02
 	 9.26945671319741038018946710508317e-01 1.23750604174400341550565940451634e-02 1.57622175402358775421485237444585e-03
 	 7.69233862030054504899112544080708e-01 3.90907007328242239729831908334745e-02 7.92866733379646998480794195529597e-03
 	 5.58671518771550079662802090751939e-01 7.47589734626490365343443045276217e-02 1.77965759970262586697753448561343e-02
 	 3.36984690281154297686327936389716e-01 1.12311681780953631637487433181377e-01 2.53962715890475899949141336264802e-02
 	 1.48078599668484356399744683585595e-01 1.44311486950416512087258524843492e-01 2.44492622580577863289352791298370e-02
 	 2.93164271597847747585774413892068e-02 1.64429241594827413308621544274502e-01 1.30433943300828150690939821743086e-02
 	 9.26945671319741149041249173023971e-01 2.46669715267025524418897930445382e-03 7.48542561236320157409818154548020e-04
 	 7.69233862030054504899112544080708e-01 7.79187470128644976696818957861979e-03 3.76529821269167746036754529370683e-03
 	 5.58671518771550079662802090751939e-01 1.49015633666711999616438788507367e-02 8.45153579694313782100234533345429e-03
 	 3.36984690281154297686327936389716e-01 2.23868729780306585652738249336835e-02 1.20606064042651159318175757562130e-02
 	 1.48078599668484356399744683585595e-01 2.87653330125592354704622266581282e-02 1.16108747669975368582706565234730e-02
 	 2.93164271597847747585774413892068e-02 3.27753666144600108722784170822706e-02 6.19426535265886132886059556312830e-03
 	 ];
 
 	 case  12 

 	 % ALG. DEG.:   12
 	 % PTS CARD.:   49
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.9e-16  

 	 xyw=[
 	 9.43737439463077754098208060895558e-01 5.48309009555892484799599628786382e-02 3.37590756711372624518374685465005e-04
 	 8.19759308263107611125519724737387e-01 1.75654279195254586776187011309958e-01 1.77448507143804180483104282473050e-03
 	 6.47375282886830327733207468554610e-01 3.43651813106452985735472793749068e-01 4.29791008798241416094532141300988e-03
 	 4.52846373669444579590503963117953e-01 5.33230731173959360269520857400494e-01 6.93554275373405287180572642569132e-03
 	 2.65789822784589513382513814576669e-01 7.15527432866567836278193226462463e-01 8.24760301352956901044244375498238e-03
 	 1.14679053160904209640591489005601e-01 8.62793031223432205223389246384613e-01 7.15464377909612227884883495221402e-03
 	 2.24793864387125008619250365882181e-02 9.52646581185226826171685843291925e-01 3.62346607972578206580127613278819e-03
 	 9.43737439463077865120510523411212e-01 4.89915018783618969044901803044922e-02 7.29242610651562473550457710302908e-04
 	 8.19759308263107611125519724737387e-01 1.56947392786902617523026037815725e-01 3.83313257348467288990190304787120e-03
 	 6.47375282886830327733207468554610e-01 3.07053470832874708662529883440584e-01 9.28407875688854258844351363677561e-03
 	 4.52846373669444579590503963117953e-01 4.76442551784230117206675458874088e-01 1.49817292193893947249705433932832e-02
 	 2.65789822784589513382513814576669e-01 6.39324960202547587506671789014945e-01 1.78159604006758141847566179194473e-02
 	 1.14679053160904209640591489005601e-01 7.70907019092334389043230657989625e-01 1.54550176627340496438023365044501e-02
 	 2.24793864387125008619250365882181e-02 8.51191316541618170354865924309706e-01 7.82718664849509603020916159721310e-03
 	 9.43737439463077754098208060895558e-01 3.95482239674546792729259436782741e-02 9.95500091624962248765262629035533e-04
 	 8.19759308263107611125519724737387e-01 1.26695251279609177874618808345986e-01 5.23266711568761734574284361087848e-03
 	 6.47375282886830327733207468554610e-01 2.47867874404687937861524460458895e-01 1.26738360020927937760193415783760e-02
 	 4.52846373669444579590503963117953e-01 3.84606636317685768311491756321630e-01 2.04517846225097874035547818039049e-02
 	 2.65789822784589402360211352061015e-01 5.16092908865112276473041674762499e-01 2.43208363748971395645881443670078e-02
 	 1.14679053160904209640591489005601e-01 6.22312080263294653548200585646555e-01 2.10978778181524148638281701551023e-02
 	 2.24793864387125008619250365882181e-02 6.87121307473297249224231109110406e-01 1.06850106013149700329156743805470e-02
 	 9.43737439463077754098208060895558e-01 2.81312802684610882564264500160789e-02 1.08969528483158291549959262312086e-03
 	 8.19759308263107611125519724737387e-01 9.01203458684462083150279454457632e-02 5.72778720065272688166668757503430e-03
 	 6.47375282886830327733207468554610e-01 1.76312358556584808377820650093781e-01 1.38730467715639273207361981121721e-02
 	 4.52846373669444524079352731860126e-01 2.73576813165277654693596787183196e-01 2.23869525046070418083932196395835e-02
 	 2.65789822784589513382513814576669e-01 3.67105088607705187797591861453839e-01 2.66220977213833878693982626373327e-02
 	 1.14679053160904154129440257747774e-01 4.42660473419547784157401792981545e-01 2.30941796709092789230410858181131e-02
 	 2.24793864387125008619250365882181e-02 4.88760306780643638546735019190237e-01 1.16960367644193576064370887479527e-02
 	 9.43737439463077754098208060895558e-01 1.67143365694675180566086680755689e-02 9.95500091624962031924828131934646e-04
 	 8.19759308263107611125519724737387e-01 5.35454404572832942665883138033678e-02 5.23266711568761647838110562247493e-03
 	 6.47375282886830327733207468554610e-01 1.04756842708481762160843686615408e-01 1.26738360020927903065723896247619e-02
 	 4.52846373669444635101655194375780e-01 1.62546990012869707609155511818244e-01 2.04517846225097804646608778966765e-02
 	 2.65789822784589513382513814576669e-01 2.18117268350298321166746973176487e-01 2.43208363748971326256942404597794e-02
 	 1.14679053160904209640591489005601e-01 2.63008866575801247833510387863498e-01 2.10978778181524079249342662478739e-02
 	 2.24793864387125008619250365882181e-02 2.90399306087990360936146316817030e-01 1.06850106013149665634687224269328e-02
 	 9.43737439463077865120510523411212e-01 7.27105865856028654725662363489391e-03 7.29242610651561280928067976248030e-04
 	 8.19759308263107611125519724737387e-01 2.32932989499897991070298530758009e-02 3.83313257348466681836973712904637e-03
 	 6.47375282886830327733207468554610e-01 4.55712462802949636042626480048057e-02 9.28407875688852697593222984551176e-03
 	 4.52846373669444579590503963117953e-01 7.07110745463253032028205780079588e-02 1.49817292193893704388418797179838e-02
 	 2.65789822784589513382513814576669e-01 9.48852170128627880885119338927325e-02 1.78159604006757864291810022905338e-02
 	 1.14679053160904209640591489005601e-01 1.14413927746761290293875390489120e-01 1.54550176627340236229501968523437e-02
 	 2.24793864387125008619250365882181e-02 1.26329297019669217760906576586422e-01 7.82718664849508388714482975956344e-03
 	 9.43737439463077754098208060895558e-01 1.43165958133294884957464887520473e-03 3.37590756711372732938591934015449e-04
 	 8.19759308263107611125519724737387e-01 4.58641254163788536502011083939578e-03 1.77448507143804245535234631603316e-03
 	 6.47375282886830327733207468554610e-01 8.97290400671668653131973769632168e-03 4.29791008798241589566879738981697e-03
 	 4.52846373669444579590503963117953e-01 1.39228951565960601399751794815529e-02 6.93554275373405634125267837930551e-03
 	 2.65789822784589513382513814576669e-01 1.86827443488427613615954214765225e-02 8.24760301352957247988939570859657e-03
 	 1.14679053160904209640591489005601e-01 2.25279156156635851360192646097858e-02 7.15464377909612488093404891742466e-03
 	 2.24793864387125008619250365882181e-02 2.48740323760606729663891201198567e-02 3.62346607972578336684388311539351e-03
 	 ];
 
 	 case  13 

 	 % ALG. DEG.:   13
 	 % PTS CARD.:   49
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.9e-16  

 	 xyw=[
 	 9.43737439463077754098208060895558e-01 5.48309009555892484799599628786382e-02 3.37590756711372624518374685465005e-04
 	 8.19759308263107611125519724737387e-01 1.75654279195254586776187011309958e-01 1.77448507143804180483104282473050e-03
 	 6.47375282886830327733207468554610e-01 3.43651813106452985735472793749068e-01 4.29791008798241416094532141300988e-03
 	 4.52846373669444579590503963117953e-01 5.33230731173959360269520857400494e-01 6.93554275373405287180572642569132e-03
 	 2.65789822784589513382513814576669e-01 7.15527432866567836278193226462463e-01 8.24760301352956901044244375498238e-03
 	 1.14679053160904209640591489005601e-01 8.62793031223432205223389246384613e-01 7.15464377909612227884883495221402e-03
 	 2.24793864387125008619250365882181e-02 9.52646581185226826171685843291925e-01 3.62346607972578206580127613278819e-03
 	 9.43737439463077865120510523411212e-01 4.89915018783618969044901803044922e-02 7.29242610651562473550457710302908e-04
 	 8.19759308263107611125519724737387e-01 1.56947392786902617523026037815725e-01 3.83313257348467288990190304787120e-03
 	 6.47375282886830327733207468554610e-01 3.07053470832874708662529883440584e-01 9.28407875688854258844351363677561e-03
 	 4.52846373669444579590503963117953e-01 4.76442551784230117206675458874088e-01 1.49817292193893947249705433932832e-02
 	 2.65789822784589513382513814576669e-01 6.39324960202547587506671789014945e-01 1.78159604006758141847566179194473e-02
 	 1.14679053160904209640591489005601e-01 7.70907019092334389043230657989625e-01 1.54550176627340496438023365044501e-02
 	 2.24793864387125008619250365882181e-02 8.51191316541618170354865924309706e-01 7.82718664849509603020916159721310e-03
 	 9.43737439463077754098208060895558e-01 3.95482239674546792729259436782741e-02 9.95500091624962248765262629035533e-04
 	 8.19759308263107611125519724737387e-01 1.26695251279609177874618808345986e-01 5.23266711568761734574284361087848e-03
 	 6.47375282886830327733207468554610e-01 2.47867874404687937861524460458895e-01 1.26738360020927937760193415783760e-02
 	 4.52846373669444579590503963117953e-01 3.84606636317685768311491756321630e-01 2.04517846225097874035547818039049e-02
 	 2.65789822784589402360211352061015e-01 5.16092908865112276473041674762499e-01 2.43208363748971395645881443670078e-02
 	 1.14679053160904209640591489005601e-01 6.22312080263294653548200585646555e-01 2.10978778181524148638281701551023e-02
 	 2.24793864387125008619250365882181e-02 6.87121307473297249224231109110406e-01 1.06850106013149700329156743805470e-02
 	 9.43737439463077754098208060895558e-01 2.81312802684610882564264500160789e-02 1.08969528483158291549959262312086e-03
 	 8.19759308263107611125519724737387e-01 9.01203458684462083150279454457632e-02 5.72778720065272688166668757503430e-03
 	 6.47375282886830327733207468554610e-01 1.76312358556584808377820650093781e-01 1.38730467715639273207361981121721e-02
 	 4.52846373669444524079352731860126e-01 2.73576813165277654693596787183196e-01 2.23869525046070418083932196395835e-02
 	 2.65789822784589513382513814576669e-01 3.67105088607705187797591861453839e-01 2.66220977213833878693982626373327e-02
 	 1.14679053160904154129440257747774e-01 4.42660473419547784157401792981545e-01 2.30941796709092789230410858181131e-02
 	 2.24793864387125008619250365882181e-02 4.88760306780643638546735019190237e-01 1.16960367644193576064370887479527e-02
 	 9.43737439463077754098208060895558e-01 1.67143365694675180566086680755689e-02 9.95500091624962031924828131934646e-04
 	 8.19759308263107611125519724737387e-01 5.35454404572832942665883138033678e-02 5.23266711568761647838110562247493e-03
 	 6.47375282886830327733207468554610e-01 1.04756842708481762160843686615408e-01 1.26738360020927903065723896247619e-02
 	 4.52846373669444635101655194375780e-01 1.62546990012869707609155511818244e-01 2.04517846225097804646608778966765e-02
 	 2.65789822784589513382513814576669e-01 2.18117268350298321166746973176487e-01 2.43208363748971326256942404597794e-02
 	 1.14679053160904209640591489005601e-01 2.63008866575801247833510387863498e-01 2.10978778181524079249342662478739e-02
 	 2.24793864387125008619250365882181e-02 2.90399306087990360936146316817030e-01 1.06850106013149665634687224269328e-02
 	 9.43737439463077865120510523411212e-01 7.27105865856028654725662363489391e-03 7.29242610651561280928067976248030e-04
 	 8.19759308263107611125519724737387e-01 2.32932989499897991070298530758009e-02 3.83313257348466681836973712904637e-03
 	 6.47375282886830327733207468554610e-01 4.55712462802949636042626480048057e-02 9.28407875688852697593222984551176e-03
 	 4.52846373669444579590503963117953e-01 7.07110745463253032028205780079588e-02 1.49817292193893704388418797179838e-02
 	 2.65789822784589513382513814576669e-01 9.48852170128627880885119338927325e-02 1.78159604006757864291810022905338e-02
 	 1.14679053160904209640591489005601e-01 1.14413927746761290293875390489120e-01 1.54550176627340236229501968523437e-02
 	 2.24793864387125008619250365882181e-02 1.26329297019669217760906576586422e-01 7.82718664849508388714482975956344e-03
 	 9.43737439463077754098208060895558e-01 1.43165958133294884957464887520473e-03 3.37590756711372732938591934015449e-04
 	 8.19759308263107611125519724737387e-01 4.58641254163788536502011083939578e-03 1.77448507143804245535234631603316e-03
 	 6.47375282886830327733207468554610e-01 8.97290400671668653131973769632168e-03 4.29791008798241589566879738981697e-03
 	 4.52846373669444579590503963117953e-01 1.39228951565960601399751794815529e-02 6.93554275373405634125267837930551e-03
 	 2.65789822784589513382513814576669e-01 1.86827443488427613615954214765225e-02 8.24760301352957247988939570859657e-03
 	 1.14679053160904209640591489005601e-01 2.25279156156635851360192646097858e-02 7.15464377909612488093404891742466e-03
 	 2.24793864387125008619250365882181e-02 2.48740323760606729663891201198567e-02 3.62346607972578336684388311539351e-03
 	 ];
 
 	 case  14 

 	 % ALG. DEG.:   14
 	 % PTS CARD.:   64
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw=[
 	 9.55366044710030171138726018398302e-01 4.37477449051462061180295393114648e-02 1.66783703247709705124943169174401e-04
 	 8.55633742957854437349851650651544e-01 1.41499854650116940746329419198446e-01 9.03105459518572573941741499226055e-04
 	 7.13175242855569546662763968924992e-01 2.81129831011298236820294960125466e-01 2.29987790174570466694703441135061e-03
 	 5.45186684803426580003815615782514e-01 4.45782964189929742371276688572834e-01 4.00862976569574779028837241412475e-03
 	 3.71932164583272273361558291071560e-01 6.15597503479887731003827866516076e-01 5.36750948657929109059105954315783e-03
 	 2.14308479395630691044516424881294e-01 7.70091559088435184676768585632090e-01 5.69439870230824783658984955536653e-03
 	 9.13236078997941014279149385401979e-02 8.90634557136405824451230728300288e-01 4.61192269545915214251641245368774e-03
 	 1.77799151473633232356519329186995e-02 9.62718034592386584513690195308300e-01 2.25490635803959936847573608531548e-03
 	 9.55366044710030171138726018398302e-01 4.00961656119337012116332630284887e-02 3.66394040824597313002475296173088e-04
 	 8.55633742957854548372154113167198e-01 1.29689007248650872705653114280722e-01 1.98396157514453335898862995634317e-03
 	 7.13175242855569435640461506409338e-01 2.57664213026851496302072064281674e-01 5.05242143815616811391988605350889e-03
 	 5.45186684803426691026118078298168e-01 4.08573918447520445518250653549330e-01 8.80624443169745162174333330540321e-03
 	 3.71932164583272273361558291071560e-01 5.64214212717486840453773311310215e-01 1.17914607462054413233865091115149e-02
 	 2.14308479395630691044516424881294e-01 7.05812808329004059970657181111164e-01 1.25095780341699103210828525334364e-02
 	 9.13236078997941014279149385401979e-02 8.16294206251800158469222878920846e-01 1.01315713673191375859827800809398e-02
 	 1.77799151473633232356519329186995e-02 8.82360949948550188359774892887799e-01 4.95362697982634162668924560080086e-03
 	 9.55366044710030171138726018398302e-01 3.40452726888026829810129925135698e-02 5.16861727436695485293771668011686e-04
 	 8.55633742957854437349851650651544e-01 1.10117702008052237294677411227894e-01 2.79871857246754077164219154383318e-03
 	 7.13175242855569435640461506409338e-01 2.18780231495104532379869510805293e-01 7.12730825639639430091332172878538e-03
 	 5.45186684803426691026118078298168e-01 3.46916226396931759445863008295419e-01 1.24227203558037770092514762154678e-02
 	 3.71932164583272273361558291071560e-01 4.79068919277106597398585563496454e-01 1.66338807164261651139192110804288e-02
 	 2.14308479395630691044516424881294e-01 5.99298939439204425561058542371029e-01 1.76469084969111573990563357483552e-02
 	 9.13236078997941014279149385401979e-02 6.93107643137351292494940935284831e-01 1.42923216403174069277781654818682e-02
 	 1.77799151473634342579543954343535e-02 7.49204286556732101942657209292520e-01 6.98794170371282597625794963391854e-03
 	 9.55366044710030171138726018398302e-01 2.64106844608761291703924456442110e-02 5.97556249615397751251411051498508e-04
 	 8.55633742957854437349851650651544e-01 8.54240148955532629937437150147161e-02 3.23566572086244480521699529163016e-03
 	 7.13175242855569435640461506409338e-01 1.69719176965060364326021158376534e-01 8.24005215605119918642618159765334e-03
 	 5.45186684803426802048420540813822e-01 2.69120916535958987214627313733217e-01 1.43622051929626730337741236098736e-02
 	 3.71932164583272328872709522329387e-01 3.71638617134705862010690680108382e-01 1.92308287687540276078568268758318e-02
 	 2.14308479395630635533365193623467e-01 4.64907281899147595272125954579678e-01 2.04020145020543594571726941921952e-02
 	 9.13236078997941014279149385401979e-02 5.37679560614672036322758685855661e-01 1.65236961150912187168415812266176e-02
 	 1.77799151473632122133494704030454e-02 5.81196637484813427576568756194320e-01 8.07892713919914316755832572880536e-03
 	 9.55366044710030171138726018398302e-01 1.82232708290936962214345840038732e-02 5.97556249615397859671628300048951e-04
 	 8.55633742957854437349851650651544e-01 5.89422421465922302674655952614557e-02 3.23566572086244523889786428583193e-03
 	 7.13175242855569546662763968924992e-01 1.17105580179370172277941719585215e-01 8.24005215605119918642618159765334e-03
 	 5.45186684803426691026118078298168e-01 1.85692398660614266248103376710787e-01 1.43622051929626747684975995866807e-02
 	 3.71932164583272273361558291071560e-01 2.56429218282021809116599797562230e-01 1.92308287687540310773037788294459e-02
 	 2.14308479395630691044516424881294e-01 3.20784238705221658172206389281200e-01 2.04020145020543629266196461458094e-02
 	 9.13236078997941014279149385401979e-02 3.70996831485533862249326375604142e-01 1.65236961150912187168415812266176e-02
 	 1.77799151473633232356519329186995e-02 4.01023447367823138165476848371327e-01 8.07892713919914490228180170561245e-03
 	 9.55366044710030171138726018398302e-01 1.05886826011671528191548929953569e-02 5.16861727436693967410730188305479e-04
 	 8.55633742957854437349851650651544e-01 3.42485550340932837221075146771909e-02 2.79871857246753296538654964820125e-03
 	 7.13175242855569435640461506409338e-01 6.80445256493260874908202140431968e-02 7.12730825639637348423161000710024e-03
 	 5.45186684803426802048420540813822e-01 1.07897088799641605039170144664240e-01 1.24227203558037405800584807025189e-02
 	 3.71932164583272273361558291071560e-01 1.48998916139621240262158607947640e-01 1.66338807164261165416618837298302e-02
 	 2.14308479395630691044516424881294e-01 1.86392581165164994416727495263331e-01 1.76469084969111088267990083977566e-02
 	 9.13236078997941014279149385401979e-02 2.15568748962854828121749051206280e-01 1.42923216403173670291382180153050e-02
 	 1.77799151473633232356519329186995e-02 2.33015798295904685843993320304435e-01 6.98794170371280602693797590063696e-03
 	 9.55366044710030171138726018398302e-01 4.53778967803612071074681466598122e-03 3.66394040824597313002475296173088e-04
 	 8.55633742957854437349851650651544e-01 1.46772497934946066777683881809935e-02 1.98396157514453335898862995634317e-03
 	 7.13175242855569324618159043893684e-01 2.91605441175790125463151980511611e-02 5.05242143815616811391988605350889e-03
 	 5.45186684803426580003815615782514e-01 4.62393967490528079444800368946744e-02 8.80624443169745162174333330540321e-03
 	 3.71932164583272273361558291071560e-01 6.38536226992407751623659351025708e-02 1.17914607462054413233865091115149e-02
 	 2.14308479395630691044516424881294e-01 7.98787122753651379625239314918872e-02 1.25095780341699103210828525334364e-02
 	 9.13236078997941014279149385401979e-02 9.23821858484056290805597200233024e-02 1.01315713673191375859827800809398e-02
 	 1.77799151473633232356519329186995e-02 9.98591349040863773822707116778474e-02 4.95362697982634162668924560080086e-03
 	 9.55366044710030171138726018398302e-01 8.86210384823622743244442290233565e-04 1.66783703247709298549128487110238e-04
 	 8.55633742957854437349851650651544e-01 2.86640239202856639266769889218267e-03 9.03105459518570405537396528217187e-04
 	 7.13175242855569546662763968924992e-01 5.69492613313232753924353346519638e-03 2.29987790174569902909573748672756e-03
 	 5.45186684803426580003815615782514e-01 9.03035100664356660260523312899750e-03 4.00862976569573738194751655328218e-03
 	 3.71932164583272273361558291071560e-01 1.24703319368399956346138424123637e-02 5.36750948657927721280325172870107e-03
 	 2.14308479395630691044516424881294e-01 1.55999615159341242787149894866161e-02 5.69439870230823395880204174090977e-03
 	 9.13236078997941014279149385401979e-02 1.80418349638000741208543331595138e-02 4.61192269545914086681381860444162e-03
 	 1.77799151473633232356519329186995e-02 1.95020502602500922506578717730008e-02 2.25490635803959373062443916069242e-03
 	 ];
 
 	 case  15 

 	 % ALG. DEG.:   15
 	 % PTS CARD.:   64
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw=[
 	 9.55366044710030171138726018398302e-01 4.37477449051462061180295393114648e-02 1.66783703247709705124943169174401e-04
 	 8.55633742957854437349851650651544e-01 1.41499854650116940746329419198446e-01 9.03105459518572573941741499226055e-04
 	 7.13175242855569546662763968924992e-01 2.81129831011298236820294960125466e-01 2.29987790174570466694703441135061e-03
 	 5.45186684803426580003815615782514e-01 4.45782964189929742371276688572834e-01 4.00862976569574779028837241412475e-03
 	 3.71932164583272273361558291071560e-01 6.15597503479887731003827866516076e-01 5.36750948657929109059105954315783e-03
 	 2.14308479395630691044516424881294e-01 7.70091559088435184676768585632090e-01 5.69439870230824783658984955536653e-03
 	 9.13236078997941014279149385401979e-02 8.90634557136405824451230728300288e-01 4.61192269545915214251641245368774e-03
 	 1.77799151473633232356519329186995e-02 9.62718034592386584513690195308300e-01 2.25490635803959936847573608531548e-03
 	 9.55366044710030171138726018398302e-01 4.00961656119337012116332630284887e-02 3.66394040824597313002475296173088e-04
 	 8.55633742957854548372154113167198e-01 1.29689007248650872705653114280722e-01 1.98396157514453335898862995634317e-03
 	 7.13175242855569435640461506409338e-01 2.57664213026851496302072064281674e-01 5.05242143815616811391988605350889e-03
 	 5.45186684803426691026118078298168e-01 4.08573918447520445518250653549330e-01 8.80624443169745162174333330540321e-03
 	 3.71932164583272273361558291071560e-01 5.64214212717486840453773311310215e-01 1.17914607462054413233865091115149e-02
 	 2.14308479395630691044516424881294e-01 7.05812808329004059970657181111164e-01 1.25095780341699103210828525334364e-02
 	 9.13236078997941014279149385401979e-02 8.16294206251800158469222878920846e-01 1.01315713673191375859827800809398e-02
 	 1.77799151473633232356519329186995e-02 8.82360949948550188359774892887799e-01 4.95362697982634162668924560080086e-03
 	 9.55366044710030171138726018398302e-01 3.40452726888026829810129925135698e-02 5.16861727436695485293771668011686e-04
 	 8.55633742957854437349851650651544e-01 1.10117702008052237294677411227894e-01 2.79871857246754077164219154383318e-03
 	 7.13175242855569435640461506409338e-01 2.18780231495104532379869510805293e-01 7.12730825639639430091332172878538e-03
 	 5.45186684803426691026118078298168e-01 3.46916226396931759445863008295419e-01 1.24227203558037770092514762154678e-02
 	 3.71932164583272273361558291071560e-01 4.79068919277106597398585563496454e-01 1.66338807164261651139192110804288e-02
 	 2.14308479395630691044516424881294e-01 5.99298939439204425561058542371029e-01 1.76469084969111573990563357483552e-02
 	 9.13236078997941014279149385401979e-02 6.93107643137351292494940935284831e-01 1.42923216403174069277781654818682e-02
 	 1.77799151473634342579543954343535e-02 7.49204286556732101942657209292520e-01 6.98794170371282597625794963391854e-03
 	 9.55366044710030171138726018398302e-01 2.64106844608761291703924456442110e-02 5.97556249615397751251411051498508e-04
 	 8.55633742957854437349851650651544e-01 8.54240148955532629937437150147161e-02 3.23566572086244480521699529163016e-03
 	 7.13175242855569435640461506409338e-01 1.69719176965060364326021158376534e-01 8.24005215605119918642618159765334e-03
 	 5.45186684803426802048420540813822e-01 2.69120916535958987214627313733217e-01 1.43622051929626730337741236098736e-02
 	 3.71932164583272328872709522329387e-01 3.71638617134705862010690680108382e-01 1.92308287687540276078568268758318e-02
 	 2.14308479395630635533365193623467e-01 4.64907281899147595272125954579678e-01 2.04020145020543594571726941921952e-02
 	 9.13236078997941014279149385401979e-02 5.37679560614672036322758685855661e-01 1.65236961150912187168415812266176e-02
 	 1.77799151473632122133494704030454e-02 5.81196637484813427576568756194320e-01 8.07892713919914316755832572880536e-03
 	 9.55366044710030171138726018398302e-01 1.82232708290936962214345840038732e-02 5.97556249615397859671628300048951e-04
 	 8.55633742957854437349851650651544e-01 5.89422421465922302674655952614557e-02 3.23566572086244523889786428583193e-03
 	 7.13175242855569546662763968924992e-01 1.17105580179370172277941719585215e-01 8.24005215605119918642618159765334e-03
 	 5.45186684803426691026118078298168e-01 1.85692398660614266248103376710787e-01 1.43622051929626747684975995866807e-02
 	 3.71932164583272273361558291071560e-01 2.56429218282021809116599797562230e-01 1.92308287687540310773037788294459e-02
 	 2.14308479395630691044516424881294e-01 3.20784238705221658172206389281200e-01 2.04020145020543629266196461458094e-02
 	 9.13236078997941014279149385401979e-02 3.70996831485533862249326375604142e-01 1.65236961150912187168415812266176e-02
 	 1.77799151473633232356519329186995e-02 4.01023447367823138165476848371327e-01 8.07892713919914490228180170561245e-03
 	 9.55366044710030171138726018398302e-01 1.05886826011671528191548929953569e-02 5.16861727436693967410730188305479e-04
 	 8.55633742957854437349851650651544e-01 3.42485550340932837221075146771909e-02 2.79871857246753296538654964820125e-03
 	 7.13175242855569435640461506409338e-01 6.80445256493260874908202140431968e-02 7.12730825639637348423161000710024e-03
 	 5.45186684803426802048420540813822e-01 1.07897088799641605039170144664240e-01 1.24227203558037405800584807025189e-02
 	 3.71932164583272273361558291071560e-01 1.48998916139621240262158607947640e-01 1.66338807164261165416618837298302e-02
 	 2.14308479395630691044516424881294e-01 1.86392581165164994416727495263331e-01 1.76469084969111088267990083977566e-02
 	 9.13236078997941014279149385401979e-02 2.15568748962854828121749051206280e-01 1.42923216403173670291382180153050e-02
 	 1.77799151473633232356519329186995e-02 2.33015798295904685843993320304435e-01 6.98794170371280602693797590063696e-03
 	 9.55366044710030171138726018398302e-01 4.53778967803612071074681466598122e-03 3.66394040824597313002475296173088e-04
 	 8.55633742957854437349851650651544e-01 1.46772497934946066777683881809935e-02 1.98396157514453335898862995634317e-03
 	 7.13175242855569324618159043893684e-01 2.91605441175790125463151980511611e-02 5.05242143815616811391988605350889e-03
 	 5.45186684803426580003815615782514e-01 4.62393967490528079444800368946744e-02 8.80624443169745162174333330540321e-03
 	 3.71932164583272273361558291071560e-01 6.38536226992407751623659351025708e-02 1.17914607462054413233865091115149e-02
 	 2.14308479395630691044516424881294e-01 7.98787122753651379625239314918872e-02 1.25095780341699103210828525334364e-02
 	 9.13236078997941014279149385401979e-02 9.23821858484056290805597200233024e-02 1.01315713673191375859827800809398e-02
 	 1.77799151473633232356519329186995e-02 9.98591349040863773822707116778474e-02 4.95362697982634162668924560080086e-03
 	 9.55366044710030171138726018398302e-01 8.86210384823622743244442290233565e-04 1.66783703247709298549128487110238e-04
 	 8.55633742957854437349851650651544e-01 2.86640239202856639266769889218267e-03 9.03105459518570405537396528217187e-04
 	 7.13175242855569546662763968924992e-01 5.69492613313232753924353346519638e-03 2.29987790174569902909573748672756e-03
 	 5.45186684803426580003815615782514e-01 9.03035100664356660260523312899750e-03 4.00862976569573738194751655328218e-03
 	 3.71932164583272273361558291071560e-01 1.24703319368399956346138424123637e-02 5.36750948657927721280325172870107e-03
 	 2.14308479395630691044516424881294e-01 1.55999615159341242787149894866161e-02 5.69439870230823395880204174090977e-03
 	 9.13236078997941014279149385401979e-02 1.80418349638000741208543331595138e-02 4.61192269545914086681381860444162e-03
 	 1.77799151473633232356519329186995e-02 1.95020502602500922506578717730008e-02 2.25490635803959373062443916069242e-03
 	 ];
 
 	 case  16 

 	 % ALG. DEG.:   16
 	 % PTS CARD.:   81
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw=[
 	 9.63742187116790494094686891912716e-01 3.56805928441202152567868211008317e-02 8.86235065031662944427456873874860e-05
 	 8.81921021210001376822162910684710e-01 1.16199175588069802955715204006992e-01 4.90084735941946603686447669900872e-04
 	 7.62823015185039587926496551517630e-01 2.33401155619554573350526993635867e-01 1.29245870681722911307853784990129e-03
 	 6.18117234695294004431787016073940e-01 3.75803237412972390707466274761828e-01 2.37326071359968962179443074944629e-03
 	 4.61970401081011061705794418230653e-01 5.29464232135294698977645566628780e-01 3.42808550557735340624798681119501e-03
 	 3.09667579927637937053930272668367e-01 6.79342410614749758757113795581972e-01 4.07626855723441233747550427324313e-03
 	 1.76116656162995433021478675073013e-01 8.10767219666291505397737182647688e-01 4.00413481401721248198466440726406e-03
 	 7.43873897091960056826565050869249e-02 9.10876968380613938336409773910418e-01 3.09144427703568003620859805380405e-03
 	 1.44124096488764674717231173417531e-02 9.69897153940605827315835085755680e-01 1.47423627366680284021815960926460e-03
 	 9.63742187116790494094686891912716e-01 3.32852361686006084640077062886121e-02 1.96983007400828750510859976863287e-04
 	 8.81921021210001265799860448169056e-01 1.08398339089899764520197322781314e-01 1.08930879600929145407939291345656e-03
 	 7.62823015185039587926496551517630e-01 2.17732161031102239290291322504345e-01 2.87274125179359579237980959476317e-03
 	 6.18117234695293893409484553558286e-01 3.50574318225678582816584594183951e-01 5.27503425622638261877073162509078e-03
 	 4.61970401081011061705794418230653e-01 4.93919540138868518042158939351793e-01 7.61958784029485251126923017750414e-03
 	 3.09667579927637937053930272668367e-01 6.33735898824467680512384504254442e-01 9.06030094113669665079058290757530e-03
 	 1.76116656162995433021478675073013e-01 7.56337724046513448783457533863839e-01 8.89996964490779619849636361550438e-03
 	 7.43873897091960056826565050869249e-02 8.49726772913861339020513696596026e-01 6.87133713086394808111645460257932e-03
 	 1.44124096488764674717231173417531e-02 9.04784737439882080778374984220136e-01 3.27677730508104878004438376137841e-03
 	 9.63742187116790494094686891912716e-01 2.92486597589868627111719945332879e-02 2.84176038885824489878262344433324e-04
 	 8.81921021210001376822162910684710e-01 9.52526255911213398652748196582252e-02 1.57148305764015202082295452612470e-03
 	 7.62823015185039698948799014033284e-01 1.91327285897259391500568881383515e-01 4.14433833887731771505880118411369e-03
 	 6.18117234695293893409484553558286e-01 3.08059372091658401071612161103985e-01 7.60998808831841490329939148296035e-03
 	 4.61970401081011117216945649488480e-01 4.34020792421626555590563611985999e-01 1.09923405016938303263573928347796e-02
 	 3.09667579927637826031627810152713e-01 5.56881302805906308606154198059812e-01 1.30707743096164247936785685055838e-02
 	 1.76116656162995433021478675073013e-01 6.64614925412230550527681316452799e-01 1.28394735833611533387665915029174e-02
 	 7.43873897091960056826565050869249e-02 7.46678471595303760999229325534543e-01 9.91288230118568015891700184738511e-03
 	 1.44124096488764674717231173417531e-02 7.95059431348357326108100551209645e-01 4.72721788115507135508153169212164e-03
 	 9.63742187116790383072384429397061e-01 2.40072664178624939346207156631863e-02 3.40590606356223522203224840509961e-04
 	 8.81921021210001376822162910684710e-01 7.81832459473407181960169509693515e-02 1.88345354372131210812790769182357e-03
 	 7.62823015185039698948799014033284e-01 1.57041217046902270570996051901602e-01 4.96707151425489386309397588092907e-03
 	 6.18117234695294004431787016073940e-01 2.52854779646835114981229253316997e-01 9.12072132304360058685510637133120e-03
 	 4.61970401081011061705794418230653e-01 3.56243769130524690069705684436485e-01 1.31745376261303490106335800646775e-02
 	 3.09667579927637937053930272668367e-01 4.57087535283730916901845375832636e-01 1.56655816764559550902102813552119e-02
 	 1.76116656162995433021478675073013e-01 5.45515169280765377379793790169060e-01 1.53883631786727211043785956690044e-02
 	 7.43873897091960056826565050869249e-02 6.12872833961666474422713690728415e-01 1.18807856106939464108096515815305e-02
 	 1.44124096488764674717231173417531e-02 6.52583870293393153438898934837198e-01 5.66566418067171364419953860647183e-03
 	 9.63742187116790383072384429397061e-01 1.81289064416047807082321696725558e-02 3.60100767481048411166461020727070e-04
 	 8.81921021210001487844465373200364e-01 5.90394893949993115889185446576448e-02 1.99134401815997561999149745304294e-03
 	 7.62823015185039476904194089001976e-01 1.18588492407480206036751724241185e-01 5.25160186756793920248576057474565e-03
 	 6.18117234695294115454089478589594e-01 1.90941382652352997784106491963030e-01 9.64318653278896896485772316509610e-03
 	 4.61970401081011061705794418230653e-01 2.69014799459494469147102790884674e-01 1.39292188975275853940472003955620e-02
 	 3.09667579927637992565081503926194e-01 3.45166210036181031473034863665816e-01 1.65629582244811585090005223719345e-02
 	 1.76116656162995433021478675073013e-01 4.11941671918502283489260662463494e-01 1.62698597304279310438168693053740e-02
 	 7.43873897091960056826565050869249e-02 4.62806305145401997158671747456538e-01 1.25613564697495943417449026924260e-02
 	 1.44124096488764674717231173417531e-02 4.92793795175561766264138441329123e-01 5.99021224213070174052786498464229e-03
 	 9.63742187116790383072384429397061e-01 1.22505464653470674818436236819252e-02 3.40590606356223305362790343409074e-04
 	 8.81921021210001376822162910684710e-01 3.98957328426579188596079461603949e-02 1.88345354372131059024486621211736e-03
 	 7.62823015185039587926496551517630e-01 8.01357677680581692580830122096813e-02 4.96707151425489039364702392731488e-03
 	 6.18117234695294004431787016073940e-01 1.29027985657870880586983730609063e-01 9.12072132304359538268467844090992e-03
 	 4.61970401081011006194643186972826e-01 1.81785829788464303735651128590689e-01 1.31745376261303403370162001806420e-02
 	 3.09667579927637881542779041410540e-01 2.33244884788631201555375582756824e-01 1.56655816764559412124224735407552e-02
 	 1.76116656162995433021478675073013e-01 2.78368174556239300621029997273581e-01 1.53883631786727106960377398081619e-02
 	 7.43873897091960056826565050869249e-02 3.12739776329137630916932266700314e-01 1.18807856106939377371922716974950e-02
 	 1.44124096488764674717231173417531e-02 3.33003720057730490111680410336703e-01 5.66566418067170930739084866445410e-03
 	 9.63742187116790494094686891912716e-01 7.00915312422269176639844090459519e-03 2.84176038885824164617610598781994e-04
 	 8.81921021210001376822162910684710e-01 2.28263531988772555569866540281510e-02 1.57148305764015006925904405221672e-03
 	 7.62823015185039587926496551517630e-01 4.58496989177009650617833358410280e-02 4.14433833887731251088837325369241e-03
 	 6.18117234695294004431787016073940e-01 7.38233932130475389854495915642474e-02 7.60998808831840449495853562211778e-03
 	 4.61970401081011117216945649488480e-01 1.04008806497362271681339507267694e-01 1.09923405016938164485695850203228e-02
 	 3.09667579927637937053930272668367e-01 1.33451117266455754339915529271821e-01 1.30707743096164074464438087375129e-02
 	 1.76116656162995433021478675073013e-01 1.59268418424773905428537545958534e-01 1.28394735833611377262553077116536e-02
 	 7.43873897091960056826565050869249e-02 1.78934138695500122295811706862878e-01 9.91288230118566628112919403292835e-03
 	 1.44124096488764674717231173417531e-02 1.90528159002766095397873868932948e-01 4.72721788115506528354936577329681e-03
 	 9.63742187116790494094686891912716e-01 2.97257671460896683024444087095617e-03 1.96983007400828343935045294799124e-04
 	 8.81921021210001376822162910684710e-01 9.68063970009890029100318997734576e-03 1.08930879600928906883461344534680e-03
 	 7.62823015185039587926496551517630e-01 1.94448237838582560499389728647657e-02 2.87274125179358972084764367593834e-03
 	 6.18117234695294115454089478589594e-01 3.13084470790275237739308522577630e-02 5.27503425622637134306813777584466e-03
 	 4.61970401081011117216945649488480e-01 4.41100587801205867855003361910349e-02 7.61958784029483603139620839783674e-03
 	 3.09667579927637937053930272668367e-01 5.65965212478946044782901481084991e-02 9.06030094113667756883234716269726e-03
 	 1.76116656162995433021478675073013e-01 6.75456197904913402396687160944566e-02 8.89996964490777711653812787062634e-03
 	 7.43873897091960056826565050869249e-02 7.58858373769428773414347233483568e-02 6.87133713086393333596690879971902e-03
 	 1.44124096488764674717231173417531e-02 8.08028529112417848168092859850731e-02 3.27677730508104184115047985415003e-03
 	 9.63742187116790494094686891912716e-01 5.77220039089346159677518244279781e-04 8.86235065031663351003271555939023e-05
 	 8.81921021210001376822162910684710e-01 1.87980320192882022212188530829735e-03 4.90084735941946820526882167001759e-04
 	 7.62823015185039587926496551517630e-01 3.77582919540583872297645484650275e-03 1.29245870681722976359984134120396e-03
 	 6.18117234695294004431787016073940e-01 6.07952789173360486074670916423202e-03 2.37326071359969092283703773205161e-03
 	 4.61970401081011061705794418230653e-01 8.56536678369423931656001514056697e-03 3.42808550557735514097146278800210e-03
 	 3.09667579927637937053930272668367e-01 1.09900094576123041889559317496605e-02 4.07626855723441407219898025005023e-03
 	 1.76116656162995433021478675073013e-01 1.31161241707130615807841422792990e-02 4.00413481401721421670814038407116e-03
 	 7.43873897091960056826565050869249e-02 1.47356419101900559809337210026570e-02 3.09144427703568177093207403061115e-03
 	 1.44124096488764674717231173417531e-02 1.56904364105177052124417969025671e-02 1.47423627366680370757989759766815e-03
 	 ];
 
 	 case  17 

 	 % ALG. DEG.:   17
 	 % PTS CARD.:   81
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw=[
 	 9.63742187116790494094686891912716e-01 3.56805928441202152567868211008317e-02 8.86235065031662944427456873874860e-05
 	 8.81921021210001376822162910684710e-01 1.16199175588069802955715204006992e-01 4.90084735941946603686447669900872e-04
 	 7.62823015185039587926496551517630e-01 2.33401155619554573350526993635867e-01 1.29245870681722911307853784990129e-03
 	 6.18117234695294004431787016073940e-01 3.75803237412972390707466274761828e-01 2.37326071359968962179443074944629e-03
 	 4.61970401081011061705794418230653e-01 5.29464232135294698977645566628780e-01 3.42808550557735340624798681119501e-03
 	 3.09667579927637937053930272668367e-01 6.79342410614749758757113795581972e-01 4.07626855723441233747550427324313e-03
 	 1.76116656162995433021478675073013e-01 8.10767219666291505397737182647688e-01 4.00413481401721248198466440726406e-03
 	 7.43873897091960056826565050869249e-02 9.10876968380613938336409773910418e-01 3.09144427703568003620859805380405e-03
 	 1.44124096488764674717231173417531e-02 9.69897153940605827315835085755680e-01 1.47423627366680284021815960926460e-03
 	 9.63742187116790494094686891912716e-01 3.32852361686006084640077062886121e-02 1.96983007400828750510859976863287e-04
 	 8.81921021210001265799860448169056e-01 1.08398339089899764520197322781314e-01 1.08930879600929145407939291345656e-03
 	 7.62823015185039587926496551517630e-01 2.17732161031102239290291322504345e-01 2.87274125179359579237980959476317e-03
 	 6.18117234695293893409484553558286e-01 3.50574318225678582816584594183951e-01 5.27503425622638261877073162509078e-03
 	 4.61970401081011061705794418230653e-01 4.93919540138868518042158939351793e-01 7.61958784029485251126923017750414e-03
 	 3.09667579927637937053930272668367e-01 6.33735898824467680512384504254442e-01 9.06030094113669665079058290757530e-03
 	 1.76116656162995433021478675073013e-01 7.56337724046513448783457533863839e-01 8.89996964490779619849636361550438e-03
 	 7.43873897091960056826565050869249e-02 8.49726772913861339020513696596026e-01 6.87133713086394808111645460257932e-03
 	 1.44124096488764674717231173417531e-02 9.04784737439882080778374984220136e-01 3.27677730508104878004438376137841e-03
 	 9.63742187116790494094686891912716e-01 2.92486597589868627111719945332879e-02 2.84176038885824489878262344433324e-04
 	 8.81921021210001376822162910684710e-01 9.52526255911213398652748196582252e-02 1.57148305764015202082295452612470e-03
 	 7.62823015185039698948799014033284e-01 1.91327285897259391500568881383515e-01 4.14433833887731771505880118411369e-03
 	 6.18117234695293893409484553558286e-01 3.08059372091658401071612161103985e-01 7.60998808831841490329939148296035e-03
 	 4.61970401081011117216945649488480e-01 4.34020792421626555590563611985999e-01 1.09923405016938303263573928347796e-02
 	 3.09667579927637826031627810152713e-01 5.56881302805906308606154198059812e-01 1.30707743096164247936785685055838e-02
 	 1.76116656162995433021478675073013e-01 6.64614925412230550527681316452799e-01 1.28394735833611533387665915029174e-02
 	 7.43873897091960056826565050869249e-02 7.46678471595303760999229325534543e-01 9.91288230118568015891700184738511e-03
 	 1.44124096488764674717231173417531e-02 7.95059431348357326108100551209645e-01 4.72721788115507135508153169212164e-03
 	 9.63742187116790383072384429397061e-01 2.40072664178624939346207156631863e-02 3.40590606356223522203224840509961e-04
 	 8.81921021210001376822162910684710e-01 7.81832459473407181960169509693515e-02 1.88345354372131210812790769182357e-03
 	 7.62823015185039698948799014033284e-01 1.57041217046902270570996051901602e-01 4.96707151425489386309397588092907e-03
 	 6.18117234695294004431787016073940e-01 2.52854779646835114981229253316997e-01 9.12072132304360058685510637133120e-03
 	 4.61970401081011061705794418230653e-01 3.56243769130524690069705684436485e-01 1.31745376261303490106335800646775e-02
 	 3.09667579927637937053930272668367e-01 4.57087535283730916901845375832636e-01 1.56655816764559550902102813552119e-02
 	 1.76116656162995433021478675073013e-01 5.45515169280765377379793790169060e-01 1.53883631786727211043785956690044e-02
 	 7.43873897091960056826565050869249e-02 6.12872833961666474422713690728415e-01 1.18807856106939464108096515815305e-02
 	 1.44124096488764674717231173417531e-02 6.52583870293393153438898934837198e-01 5.66566418067171364419953860647183e-03
 	 9.63742187116790383072384429397061e-01 1.81289064416047807082321696725558e-02 3.60100767481048411166461020727070e-04
 	 8.81921021210001487844465373200364e-01 5.90394893949993115889185446576448e-02 1.99134401815997561999149745304294e-03
 	 7.62823015185039476904194089001976e-01 1.18588492407480206036751724241185e-01 5.25160186756793920248576057474565e-03
 	 6.18117234695294115454089478589594e-01 1.90941382652352997784106491963030e-01 9.64318653278896896485772316509610e-03
 	 4.61970401081011061705794418230653e-01 2.69014799459494469147102790884674e-01 1.39292188975275853940472003955620e-02
 	 3.09667579927637992565081503926194e-01 3.45166210036181031473034863665816e-01 1.65629582244811585090005223719345e-02
 	 1.76116656162995433021478675073013e-01 4.11941671918502283489260662463494e-01 1.62698597304279310438168693053740e-02
 	 7.43873897091960056826565050869249e-02 4.62806305145401997158671747456538e-01 1.25613564697495943417449026924260e-02
 	 1.44124096488764674717231173417531e-02 4.92793795175561766264138441329123e-01 5.99021224213070174052786498464229e-03
 	 9.63742187116790383072384429397061e-01 1.22505464653470674818436236819252e-02 3.40590606356223305362790343409074e-04
 	 8.81921021210001376822162910684710e-01 3.98957328426579188596079461603949e-02 1.88345354372131059024486621211736e-03
 	 7.62823015185039587926496551517630e-01 8.01357677680581692580830122096813e-02 4.96707151425489039364702392731488e-03
 	 6.18117234695294004431787016073940e-01 1.29027985657870880586983730609063e-01 9.12072132304359538268467844090992e-03
 	 4.61970401081011006194643186972826e-01 1.81785829788464303735651128590689e-01 1.31745376261303403370162001806420e-02
 	 3.09667579927637881542779041410540e-01 2.33244884788631201555375582756824e-01 1.56655816764559412124224735407552e-02
 	 1.76116656162995433021478675073013e-01 2.78368174556239300621029997273581e-01 1.53883631786727106960377398081619e-02
 	 7.43873897091960056826565050869249e-02 3.12739776329137630916932266700314e-01 1.18807856106939377371922716974950e-02
 	 1.44124096488764674717231173417531e-02 3.33003720057730490111680410336703e-01 5.66566418067170930739084866445410e-03
 	 9.63742187116790494094686891912716e-01 7.00915312422269176639844090459519e-03 2.84176038885824164617610598781994e-04
 	 8.81921021210001376822162910684710e-01 2.28263531988772555569866540281510e-02 1.57148305764015006925904405221672e-03
 	 7.62823015185039587926496551517630e-01 4.58496989177009650617833358410280e-02 4.14433833887731251088837325369241e-03
 	 6.18117234695294004431787016073940e-01 7.38233932130475389854495915642474e-02 7.60998808831840449495853562211778e-03
 	 4.61970401081011117216945649488480e-01 1.04008806497362271681339507267694e-01 1.09923405016938164485695850203228e-02
 	 3.09667579927637937053930272668367e-01 1.33451117266455754339915529271821e-01 1.30707743096164074464438087375129e-02
 	 1.76116656162995433021478675073013e-01 1.59268418424773905428537545958534e-01 1.28394735833611377262553077116536e-02
 	 7.43873897091960056826565050869249e-02 1.78934138695500122295811706862878e-01 9.91288230118566628112919403292835e-03
 	 1.44124096488764674717231173417531e-02 1.90528159002766095397873868932948e-01 4.72721788115506528354936577329681e-03
 	 9.63742187116790494094686891912716e-01 2.97257671460896683024444087095617e-03 1.96983007400828343935045294799124e-04
 	 8.81921021210001376822162910684710e-01 9.68063970009890029100318997734576e-03 1.08930879600928906883461344534680e-03
 	 7.62823015185039587926496551517630e-01 1.94448237838582560499389728647657e-02 2.87274125179358972084764367593834e-03
 	 6.18117234695294115454089478589594e-01 3.13084470790275237739308522577630e-02 5.27503425622637134306813777584466e-03
 	 4.61970401081011117216945649488480e-01 4.41100587801205867855003361910349e-02 7.61958784029483603139620839783674e-03
 	 3.09667579927637937053930272668367e-01 5.65965212478946044782901481084991e-02 9.06030094113667756883234716269726e-03
 	 1.76116656162995433021478675073013e-01 6.75456197904913402396687160944566e-02 8.89996964490777711653812787062634e-03
 	 7.43873897091960056826565050869249e-02 7.58858373769428773414347233483568e-02 6.87133713086393333596690879971902e-03
 	 1.44124096488764674717231173417531e-02 8.08028529112417848168092859850731e-02 3.27677730508104184115047985415003e-03
 	 9.63742187116790494094686891912716e-01 5.77220039089346159677518244279781e-04 8.86235065031663351003271555939023e-05
 	 8.81921021210001376822162910684710e-01 1.87980320192882022212188530829735e-03 4.90084735941946820526882167001759e-04
 	 7.62823015185039587926496551517630e-01 3.77582919540583872297645484650275e-03 1.29245870681722976359984134120396e-03
 	 6.18117234695294004431787016073940e-01 6.07952789173360486074670916423202e-03 2.37326071359969092283703773205161e-03
 	 4.61970401081011061705794418230653e-01 8.56536678369423931656001514056697e-03 3.42808550557735514097146278800210e-03
 	 3.09667579927637937053930272668367e-01 1.09900094576123041889559317496605e-02 4.07626855723441407219898025005023e-03
 	 1.76116656162995433021478675073013e-01 1.31161241707130615807841422792990e-02 4.00413481401721421670814038407116e-03
 	 7.43873897091960056826565050869249e-02 1.47356419101900559809337210026570e-02 3.09144427703568177093207403061115e-03
 	 1.44124096488764674717231173417531e-02 1.56904364105177052124417969025671e-02 1.47423627366680370757989759766815e-03
 	 ];
 
 	 case  18 

 	 % ALG. DEG.:   18
 	 % PTS CARD.:  100
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw=[
 	 9.69970967838513442593750824016752e-01 2.96372513143052136730393186780930e-02 4.99748596350852217727600557140022e-05
 	 9.01710987790146689668802082451293e-01 9.70066614412667116429389579934650e-02 2.80663684048110045540780355111110e-04
 	 8.00978921036898716678820164815988e-01 1.96424503538898509447108153835870e-01 7.59206314135103680143523696699503e-04
 	 6.75944461676665109273187681537820e-01 3.19827671349288578106495606334647e-01 1.44683172286230103502358002032224e-03
 	 5.36738765715660592903191172808874e-01 4.57217187381390277600701210758416e-01 2.20192367176596853414749510591264e-03
 	 3.94639846885786793606598621408921e-01 5.97462179168150031571826730214525e-01 2.81876808697233659228853497324963e-03
 	 2.61159676008456353990538900688989e-01 7.29200869529325057527557873982005e-01 3.09011325736668722441446988113967e-03
 	 1.47111449643070324455607078562025e-01 8.41761138823544974307822030823445e-01 2.87391164243968114111460465665004e-03
 	 6.17320718771483534226263145683333e-02 9.26026594409988579315040624351241e-01 2.14305550645044109309145241581973e-03
 	 1.19176134324154858745714591350406e-02 9.75191136779291367631117282144260e-01 1.00338733149634958333185075218807e-03
 	 9.69970967838513442593750824016752e-01 2.80030239107569543788311960952342e-02 1.12024292798024199162634784165959e-04
 	 9.01710987790146800691104544966947e-01 9.16576180103218507433382455928950e-02 6.29139350248502531894045919358405e-04
 	 8.00978921036898716678820164815988e-01 1.85593461786497881949031807380379e-01 1.70184670952171993724144627435635e-03
 	 6.75944461676665109273187681537820e-01 3.02192056649765117271044800872914e-01 3.24323673412794466833219964030377e-03
 	 5.36738765715660592903191172808874e-01 4.32005778635422277300648374875891e-01 4.93586062924398182027996284659821e-03
 	 3.94639846885786793606598621408921e-01 5.64517522613276812037952367973048e-01 6.31858706178389274710216483299519e-03
 	 2.61159676008456465012841363204643e-01 6.88992011054624153842951272963546e-01 6.92683791110185360928586106865623e-03
 	 1.47111449643070324455607078562025e-01 7.95345595569591390372465866676066e-01 6.44219757012158902864662479714752e-03
 	 6.17320718771483534226263145683333e-02 8.74964570440551869801026896311669e-01 4.80390098721710737811330105273555e-03
 	 1.19176134324154858745714591350406e-02 9.21418131228912917762841061630752e-01 2.24920604148053180498800784903324e-03
 	 9.69970967838513442593750824016752e-01 2.52155219693798310354182490300445e-02 1.64220630740616281226240680268802e-04
 	 9.01710987790146689668802082451293e-01 8.25337537819436500852177118758846e-02 9.22279073056311350133074089541196e-04
 	 8.00978921036898716678820164815988e-01 1.67118952151913968684482370008482e-01 2.49480119964148004674253655821303e-03
 	 6.75944461676665109273187681537820e-01 2.72110985860249954271239403169602e-01 4.75438290050085587967743094850448e-03
 	 5.36738765715660592903191172808874e-01 3.89002674739567899653280846905545e-01 7.23566402908385961079140713536617e-03
 	 3.94639846885786793606598621408921e-01 5.08323816703486142110079981648596e-01 9.26265479351412110431418511780066e-03
 	 2.61159676008456242968236438173335e-01 6.20407754778274922458081164222676e-01 1.01543126261915764296794861820672e-02
 	 1.47111449643070324455607078562025e-01 7.16174596081056047403023967490299e-01 9.44386009406427556767127384773630e-03
 	 6.17320718771483534226263145683333e-02 7.87868068058809267739661663654260e-01 7.04221941894889180701966324704699e-03
 	 1.19176134324154858745714591350406e-02 8.29697507134668499340079961257288e-01 3.29719586325344111293889071134799e-03
 	 9.69970967838513442593750824016752e-01 2.15217381952169314884848461133515e-02 2.01834335897189232978191086864683e-04
 	 9.01710987790146689668802082451293e-01 7.04435086975585406099398255719279e-02 1.13352130839280995124040973820456e-03
 	 8.00978921036898827701122627331642e-01 1.42637948960171262458018759389233e-01 3.06621976212280303655810520524483e-03
 	 6.75944461676665109273187681537820e-01 2.32249858037370998653514675424958e-01 5.84334447502647246625029353594982e-03
 	 5.36738765715660592903191172808874e-01 3.32018259750901156834856919886079e-01 8.89294747863931395182035544166865e-03
 	 3.94639846885786793606598621408921e-01 4.33860227631644557177992282959167e-01 1.13842077603922807449432497151065e-02
 	 2.61159676008456353990538900688989e-01 5.29525158703219700484510212845635e-01 1.24800942254140630194303440703152e-02
 	 1.47111449643070324455607078562025e-01 6.11263259893596755389921781898011e-01 1.16069169981576521266664059339746e-02
 	 6.17320718771483534226263145683333e-02 6.72454463315243611276628143968992e-01 8.65519559421773498897323406708892e-03
 	 1.19176134324154858745714591350406e-02 7.08156370963105019633587744465331e-01 4.05239788923867846892612476494833e-03
 	 9.69970967838513442593750824016752e-01 1.72497922373930079320558661493124e-02 2.21516182132276896092973328400433e-04
 	 9.01710987790146689668802082451293e-01 5.64608619658763452586747177974758e-02 1.24405647574583606666809298957332e-03
 	 8.00978921036898716678820164815988e-01 1.14325105268571966532498151991604e-01 3.36522174121038891020374350659949e-03
 	 6.75944461676665109273187681537820e-01 1.86149546192278997347457902833412e-01 6.41315737105771499493300780159188e-03
 	 5.36738765715660592903191172808874e-01 2.66114472157117532002956750147860e-01 9.76014197294203939003764958215470e-03
 	 3.94639846885786849117749852666748e-01 3.47741372877455379164501891864347e-01 1.24943371427510170612595885586416e-02
 	 2.61159676008456298479387669431162e-01 4.24417344419379449771412282643723e-01 1.36970888187875391300840632879954e-02
 	 1.47111449643070324455607078562025e-01 4.89930884758159601588545228878502e-01 1.27387638398047051135897334006586e-02
 	 6.17320718771483534226263145683333e-02 5.38975972854902840580848533136304e-01 9.49920574770705440637019734140267e-03
 	 1.19176134324154858745714591350406e-02 5.67591249363613048473098388058133e-01 4.44756688654950830402734496260564e-03
 	 9.69970967838513442593750824016752e-01 1.27792399240935494741933098339359e-02 2.21516182132276652147484519161935e-04
 	 9.01710987790146689668802082451293e-01 4.18281502439769511947353919367742e-02 1.24405647574583454878505150986712e-03
 	 8.00978921036898827701122627331642e-01 8.46959736945292335219548363056674e-02 3.36522174121038500707592255878353e-03
 	 6.75944461676665109273187681537820e-01 1.37905992131055837868203184370941e-01 6.41315737105770805603910389436351e-03
 	 5.36738765715660592903191172808874e-01 1.97146762127221875093852077043266e-01 9.76014197294202898169679372131213e-03
 	 3.94639846885786793606598621408921e-01 2.57618780236757771717748255468905e-01 1.24943371427510031834717807441848e-02
 	 2.61159676008456409501690131946816e-01 3.14422979572164085215746354151634e-01 1.36970888187875235175727794967315e-02
 	 1.47111449643070324455607078562025e-01 3.62957665598769962933545230043819e-01 1.27387638398046912358019255862018e-02
 	 6.17320718771483534226263145683333e-02 3.99291955267948694974222689779708e-01 9.49920574770704399802934148056011e-03
 	 1.19176134324154858745714591350406e-02 4.20491137203971354630027690291172e-01 4.44756688654950309985691703218436e-03
 	 9.69970967838513442593750824016752e-01 8.50729396626962938721128182351094e-03 2.01834335897189395608516959690348e-04
 	 9.01710987790146689668802082451293e-01 2.78455035122947835990458997912356e-02 1.13352130839281103544258222370900e-03
 	 8.00978921036898716678820164815988e-01 5.63831300029299931075854601658648e-02 3.06621976212280563864331917045547e-03
 	 6.75944461676665109273187681537820e-01 9.18056802859639198288732586661354e-02 5.84334447502647680305898347796756e-03
 	 5.36738765715660481880888710293220e-01 1.31242974533438361284254369820701e-01 8.89294747863932089071425934889703e-03
 	 3.94639846885786793606598621408921e-01 1.71499925482568760237711558147566e-01 1.13842077603922894185606295991420e-02
 	 2.61159676008456353990538900688989e-01 2.09315165288324056547253348981030e-01 1.24800942254140734277711999311578e-02
 	 1.47111449643070324455607078562025e-01 2.41625290463333031176773602055619e-01 1.16069169981576608002837858180101e-02
 	 6.17320718771483534226263145683333e-02 2.65813464807608146323048003978329e-01 8.65519559421774192786713797431730e-03
 	 1.19176134324154858745714591350406e-02 2.79926015604479605514143258915283e-01 4.05239788923868193837307671856252e-03
 	 9.69970967838513442593750824016752e-01 4.81351019210672637083092695320374e-03 1.64220630740616145700969119580748e-04
 	 9.01710987790146689668802082451293e-01 1.57552584279096602459802056728222e-02 9.22279073056310699611770598238536e-04
 	 8.00978921036898716678820164815988e-01 3.19021268111872868811218495466164e-02 2.49480119964147831201906058140594e-03
 	 6.75944461676664998250885219022166e-01 5.19445524630849919667241465504048e-02 4.75438290050085241023047899489029e-03
 	 5.36738765715660592903191172808874e-01 7.42585595447715629546792115434073e-02 7.23566402908385440662097920494489e-03
 	 3.94639846885786793606598621408921e-01 9.70363364107271753056238594581373e-02 9.26265479351411416542028121057228e-03
 	 2.61159676008456353990538900688989e-01 1.18432569213268834573682397603989e-01 1.01543126261915694907855822748388e-02
 	 1.47111449643070324455607078562025e-01 1.36713954275873628141368953947676e-01 9.44386009406426862877736994050792e-03
 	 6.17320718771483534226263145683333e-02 1.50399860064042489860014484293060e-01 7.04221941894888660284923531662571e-03
 	 1.19176134324154858745714591350406e-02 1.58384879432916014785348579607671e-01 3.29719586325343851085367674613735e-03
 	 9.69970967838513442593750824016752e-01 2.02600825072960649686493184162828e-03 1.12024292798024429555596437335652e-04
 	 9.01710987790146578646499619935639e-01 6.63139419953145958785967195581179e-03 6.29139350248503832936652901963726e-04
 	 8.00978921036898827701122627331642e-01 1.34276171766033458609967965458054e-02 1.70184670952172340668839822797054e-03
 	 6.75944461676664998250885219022166e-01 2.18634816735698289669187488470925e-02 3.24323673412795117354523455333037e-03
 	 5.36738765715660592903191172808874e-01 3.12554556489172408184629148308886e-02 4.93586062924399222862081870744078e-03
 	 3.94639846885786793606598621408921e-01 4.08426305009365053777514731336851e-02 6.31858706178390575752823465904839e-03
 	 2.61159676008456353990538900688989e-01 4.98483129369194921665098263474647e-02 6.92683791110186835443540687151653e-03
 	 1.47111449643070324455607078562025e-01 5.75429547873383961942295172775630e-02 6.44219757012160203907269462320073e-03
 	 6.17320718771483534226263145683333e-02 6.33033576822998877986492516356520e-02 4.80390098721711691909241892517457e-03
 	 1.19176134324154858745714591350406e-02 6.66642553386717073848899417498615e-02 2.24920604148053614179669779105097e-03
 	 9.69970967838513442593750824016752e-01 3.91780847181340263762905351541121e-04 4.99748596350852421015507898172103e-05
 	 9.01710987790146689668802082451293e-01 1.28235076858658481047115174078499e-03 2.80663684048110153960997603661554e-04
 	 8.00978921036898827701122627331642e-01 2.59657542420269060734483446140075e-03 7.59206314135104005404175442350834e-04
 	 6.75944461676664998250885219022166e-01 4.22786697404625710916548086970579e-03 1.44683172286230168554488351162490e-03
 	 5.36738765715660481880888710293220e-01 6.04404690294912949610761643270962e-03 2.20192367176596940150923309431619e-03
 	 3.94639846885786793606598621408921e-01 7.89797394606317482157464837655425e-03 2.81876808697233789333114195585495e-03
 	 2.61159676008456353990538900688989e-01 9.63945446221847745960076281335205e-03 3.09011325736668809177620786954321e-03
 	 1.47111449643070324455607078562025e-01 1.11274115333845902142684280988760e-02 2.87391164243968244215721163925537e-03
 	 6.17320718771483534226263145683333e-02 1.22413337128629562400305985647719e-02 2.14305550645044196045319040422328e-03
 	 1.19176134324154858745714591350406e-02 1.28912497882930354720087962050457e-02 1.00338733149635001701271974638985e-03
 	 ];
 
 	 case  19 

 	 % ALG. DEG.:   19
 	 % PTS CARD.:  100
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw=[
 	 9.69970967838513442593750824016752e-01 2.96372513143052136730393186780930e-02 4.99748596350852217727600557140022e-05
 	 9.01710987790146689668802082451293e-01 9.70066614412667116429389579934650e-02 2.80663684048110045540780355111110e-04
 	 8.00978921036898716678820164815988e-01 1.96424503538898509447108153835870e-01 7.59206314135103680143523696699503e-04
 	 6.75944461676665109273187681537820e-01 3.19827671349288578106495606334647e-01 1.44683172286230103502358002032224e-03
 	 5.36738765715660592903191172808874e-01 4.57217187381390277600701210758416e-01 2.20192367176596853414749510591264e-03
 	 3.94639846885786793606598621408921e-01 5.97462179168150031571826730214525e-01 2.81876808697233659228853497324963e-03
 	 2.61159676008456353990538900688989e-01 7.29200869529325057527557873982005e-01 3.09011325736668722441446988113967e-03
 	 1.47111449643070324455607078562025e-01 8.41761138823544974307822030823445e-01 2.87391164243968114111460465665004e-03
 	 6.17320718771483534226263145683333e-02 9.26026594409988579315040624351241e-01 2.14305550645044109309145241581973e-03
 	 1.19176134324154858745714591350406e-02 9.75191136779291367631117282144260e-01 1.00338733149634958333185075218807e-03
 	 9.69970967838513442593750824016752e-01 2.80030239107569543788311960952342e-02 1.12024292798024199162634784165959e-04
 	 9.01710987790146800691104544966947e-01 9.16576180103218507433382455928950e-02 6.29139350248502531894045919358405e-04
 	 8.00978921036898716678820164815988e-01 1.85593461786497881949031807380379e-01 1.70184670952171993724144627435635e-03
 	 6.75944461676665109273187681537820e-01 3.02192056649765117271044800872914e-01 3.24323673412794466833219964030377e-03
 	 5.36738765715660592903191172808874e-01 4.32005778635422277300648374875891e-01 4.93586062924398182027996284659821e-03
 	 3.94639846885786793606598621408921e-01 5.64517522613276812037952367973048e-01 6.31858706178389274710216483299519e-03
 	 2.61159676008456465012841363204643e-01 6.88992011054624153842951272963546e-01 6.92683791110185360928586106865623e-03
 	 1.47111449643070324455607078562025e-01 7.95345595569591390372465866676066e-01 6.44219757012158902864662479714752e-03
 	 6.17320718771483534226263145683333e-02 8.74964570440551869801026896311669e-01 4.80390098721710737811330105273555e-03
 	 1.19176134324154858745714591350406e-02 9.21418131228912917762841061630752e-01 2.24920604148053180498800784903324e-03
 	 9.69970967838513442593750824016752e-01 2.52155219693798310354182490300445e-02 1.64220630740616281226240680268802e-04
 	 9.01710987790146689668802082451293e-01 8.25337537819436500852177118758846e-02 9.22279073056311350133074089541196e-04
 	 8.00978921036898716678820164815988e-01 1.67118952151913968684482370008482e-01 2.49480119964148004674253655821303e-03
 	 6.75944461676665109273187681537820e-01 2.72110985860249954271239403169602e-01 4.75438290050085587967743094850448e-03
 	 5.36738765715660592903191172808874e-01 3.89002674739567899653280846905545e-01 7.23566402908385961079140713536617e-03
 	 3.94639846885786793606598621408921e-01 5.08323816703486142110079981648596e-01 9.26265479351412110431418511780066e-03
 	 2.61159676008456242968236438173335e-01 6.20407754778274922458081164222676e-01 1.01543126261915764296794861820672e-02
 	 1.47111449643070324455607078562025e-01 7.16174596081056047403023967490299e-01 9.44386009406427556767127384773630e-03
 	 6.17320718771483534226263145683333e-02 7.87868068058809267739661663654260e-01 7.04221941894889180701966324704699e-03
 	 1.19176134324154858745714591350406e-02 8.29697507134668499340079961257288e-01 3.29719586325344111293889071134799e-03
 	 9.69970967838513442593750824016752e-01 2.15217381952169314884848461133515e-02 2.01834335897189232978191086864683e-04
 	 9.01710987790146689668802082451293e-01 7.04435086975585406099398255719279e-02 1.13352130839280995124040973820456e-03
 	 8.00978921036898827701122627331642e-01 1.42637948960171262458018759389233e-01 3.06621976212280303655810520524483e-03
 	 6.75944461676665109273187681537820e-01 2.32249858037370998653514675424958e-01 5.84334447502647246625029353594982e-03
 	 5.36738765715660592903191172808874e-01 3.32018259750901156834856919886079e-01 8.89294747863931395182035544166865e-03
 	 3.94639846885786793606598621408921e-01 4.33860227631644557177992282959167e-01 1.13842077603922807449432497151065e-02
 	 2.61159676008456353990538900688989e-01 5.29525158703219700484510212845635e-01 1.24800942254140630194303440703152e-02
 	 1.47111449643070324455607078562025e-01 6.11263259893596755389921781898011e-01 1.16069169981576521266664059339746e-02
 	 6.17320718771483534226263145683333e-02 6.72454463315243611276628143968992e-01 8.65519559421773498897323406708892e-03
 	 1.19176134324154858745714591350406e-02 7.08156370963105019633587744465331e-01 4.05239788923867846892612476494833e-03
 	 9.69970967838513442593750824016752e-01 1.72497922373930079320558661493124e-02 2.21516182132276896092973328400433e-04
 	 9.01710987790146689668802082451293e-01 5.64608619658763452586747177974758e-02 1.24405647574583606666809298957332e-03
 	 8.00978921036898716678820164815988e-01 1.14325105268571966532498151991604e-01 3.36522174121038891020374350659949e-03
 	 6.75944461676665109273187681537820e-01 1.86149546192278997347457902833412e-01 6.41315737105771499493300780159188e-03
 	 5.36738765715660592903191172808874e-01 2.66114472157117532002956750147860e-01 9.76014197294203939003764958215470e-03
 	 3.94639846885786849117749852666748e-01 3.47741372877455379164501891864347e-01 1.24943371427510170612595885586416e-02
 	 2.61159676008456298479387669431162e-01 4.24417344419379449771412282643723e-01 1.36970888187875391300840632879954e-02
 	 1.47111449643070324455607078562025e-01 4.89930884758159601588545228878502e-01 1.27387638398047051135897334006586e-02
 	 6.17320718771483534226263145683333e-02 5.38975972854902840580848533136304e-01 9.49920574770705440637019734140267e-03
 	 1.19176134324154858745714591350406e-02 5.67591249363613048473098388058133e-01 4.44756688654950830402734496260564e-03
 	 9.69970967838513442593750824016752e-01 1.27792399240935494741933098339359e-02 2.21516182132276652147484519161935e-04
 	 9.01710987790146689668802082451293e-01 4.18281502439769511947353919367742e-02 1.24405647574583454878505150986712e-03
 	 8.00978921036898827701122627331642e-01 8.46959736945292335219548363056674e-02 3.36522174121038500707592255878353e-03
 	 6.75944461676665109273187681537820e-01 1.37905992131055837868203184370941e-01 6.41315737105770805603910389436351e-03
 	 5.36738765715660592903191172808874e-01 1.97146762127221875093852077043266e-01 9.76014197294202898169679372131213e-03
 	 3.94639846885786793606598621408921e-01 2.57618780236757771717748255468905e-01 1.24943371427510031834717807441848e-02
 	 2.61159676008456409501690131946816e-01 3.14422979572164085215746354151634e-01 1.36970888187875235175727794967315e-02
 	 1.47111449643070324455607078562025e-01 3.62957665598769962933545230043819e-01 1.27387638398046912358019255862018e-02
 	 6.17320718771483534226263145683333e-02 3.99291955267948694974222689779708e-01 9.49920574770704399802934148056011e-03
 	 1.19176134324154858745714591350406e-02 4.20491137203971354630027690291172e-01 4.44756688654950309985691703218436e-03
 	 9.69970967838513442593750824016752e-01 8.50729396626962938721128182351094e-03 2.01834335897189395608516959690348e-04
 	 9.01710987790146689668802082451293e-01 2.78455035122947835990458997912356e-02 1.13352130839281103544258222370900e-03
 	 8.00978921036898716678820164815988e-01 5.63831300029299931075854601658648e-02 3.06621976212280563864331917045547e-03
 	 6.75944461676665109273187681537820e-01 9.18056802859639198288732586661354e-02 5.84334447502647680305898347796756e-03
 	 5.36738765715660481880888710293220e-01 1.31242974533438361284254369820701e-01 8.89294747863932089071425934889703e-03
 	 3.94639846885786793606598621408921e-01 1.71499925482568760237711558147566e-01 1.13842077603922894185606295991420e-02
 	 2.61159676008456353990538900688989e-01 2.09315165288324056547253348981030e-01 1.24800942254140734277711999311578e-02
 	 1.47111449643070324455607078562025e-01 2.41625290463333031176773602055619e-01 1.16069169981576608002837858180101e-02
 	 6.17320718771483534226263145683333e-02 2.65813464807608146323048003978329e-01 8.65519559421774192786713797431730e-03
 	 1.19176134324154858745714591350406e-02 2.79926015604479605514143258915283e-01 4.05239788923868193837307671856252e-03
 	 9.69970967838513442593750824016752e-01 4.81351019210672637083092695320374e-03 1.64220630740616145700969119580748e-04
 	 9.01710987790146689668802082451293e-01 1.57552584279096602459802056728222e-02 9.22279073056310699611770598238536e-04
 	 8.00978921036898716678820164815988e-01 3.19021268111872868811218495466164e-02 2.49480119964147831201906058140594e-03
 	 6.75944461676664998250885219022166e-01 5.19445524630849919667241465504048e-02 4.75438290050085241023047899489029e-03
 	 5.36738765715660592903191172808874e-01 7.42585595447715629546792115434073e-02 7.23566402908385440662097920494489e-03
 	 3.94639846885786793606598621408921e-01 9.70363364107271753056238594581373e-02 9.26265479351411416542028121057228e-03
 	 2.61159676008456353990538900688989e-01 1.18432569213268834573682397603989e-01 1.01543126261915694907855822748388e-02
 	 1.47111449643070324455607078562025e-01 1.36713954275873628141368953947676e-01 9.44386009406426862877736994050792e-03
 	 6.17320718771483534226263145683333e-02 1.50399860064042489860014484293060e-01 7.04221941894888660284923531662571e-03
 	 1.19176134324154858745714591350406e-02 1.58384879432916014785348579607671e-01 3.29719586325343851085367674613735e-03
 	 9.69970967838513442593750824016752e-01 2.02600825072960649686493184162828e-03 1.12024292798024429555596437335652e-04
 	 9.01710987790146578646499619935639e-01 6.63139419953145958785967195581179e-03 6.29139350248503832936652901963726e-04
 	 8.00978921036898827701122627331642e-01 1.34276171766033458609967965458054e-02 1.70184670952172340668839822797054e-03
 	 6.75944461676664998250885219022166e-01 2.18634816735698289669187488470925e-02 3.24323673412795117354523455333037e-03
 	 5.36738765715660592903191172808874e-01 3.12554556489172408184629148308886e-02 4.93586062924399222862081870744078e-03
 	 3.94639846885786793606598621408921e-01 4.08426305009365053777514731336851e-02 6.31858706178390575752823465904839e-03
 	 2.61159676008456353990538900688989e-01 4.98483129369194921665098263474647e-02 6.92683791110186835443540687151653e-03
 	 1.47111449643070324455607078562025e-01 5.75429547873383961942295172775630e-02 6.44219757012160203907269462320073e-03
 	 6.17320718771483534226263145683333e-02 6.33033576822998877986492516356520e-02 4.80390098721711691909241892517457e-03
 	 1.19176134324154858745714591350406e-02 6.66642553386717073848899417498615e-02 2.24920604148053614179669779105097e-03
 	 9.69970967838513442593750824016752e-01 3.91780847181340263762905351541121e-04 4.99748596350852421015507898172103e-05
 	 9.01710987790146689668802082451293e-01 1.28235076858658481047115174078499e-03 2.80663684048110153960997603661554e-04
 	 8.00978921036898827701122627331642e-01 2.59657542420269060734483446140075e-03 7.59206314135104005404175442350834e-04
 	 6.75944461676664998250885219022166e-01 4.22786697404625710916548086970579e-03 1.44683172286230168554488351162490e-03
 	 5.36738765715660481880888710293220e-01 6.04404690294912949610761643270962e-03 2.20192367176596940150923309431619e-03
 	 3.94639846885786793606598621408921e-01 7.89797394606317482157464837655425e-03 2.81876808697233789333114195585495e-03
 	 2.61159676008456353990538900688989e-01 9.63945446221847745960076281335205e-03 3.09011325736668809177620786954321e-03
 	 1.47111449643070324455607078562025e-01 1.11274115333845902142684280988760e-02 2.87391164243968244215721163925537e-03
 	 6.17320718771483534226263145683333e-02 1.22413337128629562400305985647719e-02 2.14305550645044196045319040422328e-03
 	 1.19176134324154858745714591350406e-02 1.28912497882930354720087962050457e-02 1.00338733149635001701271974638985e-03
 	 ];
 
 	 case  20 

 	 % ALG. DEG.:   20
 	 % PTS CARD.:  121
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw=[
 	 9.74726379602479653385671554133296e-01 2.49985000827397454981060320733377e-02 2.96064170516318231644523062406904e-05
 	 9.16958386552594983953667906462215e-01 8.21376497701717944721622188808396e-02 1.68228209816660061268894788000239e-04
 	 8.30824899622818469069329694320913e-01 1.67333515905438101611935053369962e-01 4.63820020259271624096103492362886e-04
 	 7.22203284890968078002515539992601e-01 2.74772711483761422623928183384123e-01 9.08554067007384235504785507941961e-04
 	 5.98497279767139067629955206939485e-01 3.97132093744122061096391007595230e-01 1.43600856210027443167487337660759e-03
 	 4.68137613089584014858246518997476e-01 5.26072707988075594087717945512850e-01 1.93536992947838069889510137500110e-03
 	 3.40008157914665209986537774966564e-01 6.52807388077908057333331726113101e-01 2.27904617005158204035009106291909e-03
 	 2.22840607043837790612883509311359e-01 7.68699491546636415328919156308984e-01 2.35643438241775905056529794023845e-03
 	 1.24619225144442902220021096582059e-01 8.65851667804682145757055877766106e-01 2.10482986029991670992589369859616e-03
 	 5.20354511271805542094170959899202e-02 9.37645318743354883039842206926551e-01 1.52916240673237838892939421953088e-03
 	 1.00182804616806286901464773109183e-02 9.79205104315707730577855727460701e-01 7.06081753828327997671299165460823e-04
 	 9.74726379602479653385671554133296e-01 2.38464519064483515542463010206120e-02 6.67878658366928253456440423008189e-05
 	 9.16958386552594983953667906462215e-01 7.83523614804986640036688072541438e-02 3.79498913616864972948167222810412e-04
 	 8.30824899622818469069329694320913e-01 1.59622002366896276193131143372739e-01 1.04631199484305674810014075148956e-03
 	 7.22203284890968078002515539992601e-01 2.62109895710343432373434779947274e-01 2.04956874811456713283974728767589e-03
 	 5.98497279767139067629955206939485e-01 3.78830383528292347072863321955083e-01 3.23943106721213784637836141655498e-03
 	 4.68137613089584014858246518997476e-01 5.01828809281017029775284754578024e-01 4.36591928597612408124994942681951e-03
 	 3.40008157914665209986537774966564e-01 6.22722960675643033567894235602580e-01 5.14120400234800278144176033379154e-03
 	 2.22840607043837790612883509311359e-01 7.33274212253025026164721111854305e-01 5.31578080223027178013994742400428e-03
 	 1.24619225144442902220021096582059e-01 8.25949160392968617649955831439001e-01 4.74819678698768822544540313401740e-03
 	 5.20354511271805542094170959899202e-02 8.94434223041966069978059294953709e-01 3.44957289108130350438474742702510e-03
 	 1.00182804616806286901464773109183e-02 9.34078738697435073667918459250359e-01 1.59282000797945065030669642425210e-03
 	 9.74726379602479653385671554133296e-01 2.18636025094435144933147086021563e-02 9.90754022077298452829061115032516e-05
 	 9.16958386552594983953667906462215e-01 7.18373070260663604269524284973159e-02 5.62961655279165516276018710328799e-04
 	 8.30824899622818469069329694320913e-01 1.46349319605385830289634441214730e-01 1.55213496381697169806956893012284e-03
 	 7.22203284890968078002515539992601e-01 2.40315271893887294485381289632642e-01 3.04040031116375574632426648236105e-03
 	 5.98497279767139067629955206939485e-01 3.47330368327160410313325655806693e-01 4.80548273084556790135657422524673e-03
 	 4.68137613089584070369397750255303e-01 4.60101387701228603521741433723946e-01 6.47655384470940866797894486239784e-03
 	 3.40008157914665209986537774966564e-01 5.70943104623226616034514790953835e-01 7.62663768311003416322524373072156e-03
 	 2.22840607043837790612883509311359e-01 6.72301941186907336955869141092990e-01 7.88561087304196460523453282576156e-03
 	 1.24619225144442902220021096582059e-01 7.57270901628653736459284573356854e-01 7.04363735146938587522447150490734e-03
 	 5.20354511271805542094170959899202e-02 8.20061382722703680059339603758417e-01 5.11721429255486848913792030657532e-03
 	 1.00182804616806286901464773109183e-02 8.56409428770434688615864615712781e-01 2.36284362373477855798209468218829e-03
 	 9.74726379602479653385671554133296e-01 1.91965294584577408909531470726506e-02 1.24020290192534520922612584215017e-04
 	 9.16958386552594983953667906462215e-01 6.30740967755206438649651090599946e-02 7.04702340835356658838017906987261e-04
 	 8.30824899622818469069329694320913e-01 1.28496620070575107153132421444752e-01 1.94292654222039985756342872491587e-03
 	 7.22203284890968078002515539992601e-01 2.10999957314248975936976648881682e-01 3.80590258015205129549229923213716e-03
 	 5.98497279767139067629955206939485e-01 3.04960614085872272482902189949527e-01 6.01539180779810719185141110187942e-03
 	 4.68137613089584014858246518997476e-01 4.03975046613154309405047115433263e-01 8.10719986363849128008229882880187e-03
 	 3.40008157914665209986537774966564e-01 5.01295526309952665933167281764327e-01 9.54684813360091519274241989023722e-03
 	 2.22840607043837790612883509311359e-01 5.90289912808210748274007073632674e-01 9.87102476525468508494753905324615e-03
 	 1.24619225144442902220021096582059e-01 6.64893773332568160938649270974565e-01 8.81706184254131726529823964710886e-03
 	 5.20354511271805542094170959899202e-02 7.20024638408990780291674127511214e-01 6.40561014538607378931978075797815e-03
 	 1.00182804616806286901464773109183e-02 7.51938699068082194720830102596665e-01 2.95775283637762656865910493309002e-03
 	 9.74726379602479653385671554133296e-01 1.60429759009047684381599196967727e-02 1.39768299255790416548567156596050e-04
 	 9.16958386552594983953667906462215e-01 5.27124560056966284804502720362507e-02 7.94184947537407990095226217874824e-04
 	 8.30824899622818580091632156836567e-01 1.07387545420700850073991716726596e-01 2.18963798555460616157564146533332e-03
 	 7.22203284890967966980213077476947e-01 1.76337459206357488605831917993783e-01 4.28917340811945171918928565446549e-03
 	 5.98497279767139067629955206939485e-01 2.54862515283938828591914216303849e-01 6.77922202107350026223375749623301e-03
 	 4.68137613089584014858246518997476e-01 3.37611126605298350611406021926086e-01 9.13664638994480735045833341700927e-03
 	 3.40008157914665209986537774966564e-01 4.18944063051908788253285820246674e-01 1.07591001828428109443613891471614e-02
 	 2.22840607043837846124034740569186e-01 4.93318694205787389162054523694678e-01 1.11244405347673061545954453777085e-02
 	 1.24619225144442902220021096582059e-01 5.55666835785066481889771239366382e-01 9.93664614275598101489350710835424e-03
 	 5.20354511271805542094170959899202e-02 6.01740952553470043184802307223435e-01 7.21899000821835720026475868849047e-03
 	 1.00182804616806286901464773109183e-02 6.28412258278903568253781486419030e-01 3.33332620749161780832059420731639e-03
 	 9.74726379602479653385671554133296e-01 1.26368101987601767766111748869662e-02 1.45150744155791517004186474970595e-04
 	 9.16958386552594983953667906462215e-01 4.15208067237025149620599506761209e-02 8.24768826308854593847008640494778e-04
 	 8.30824899622818469069329694320913e-01 8.45875501885907515875473450250865e-02 2.27396043829210551742714407907897e-03
 	 7.22203284890967966980213077476947e-01 1.38898357554516044265469076890440e-01 4.45434848471892245319603276243470e-03
 	 5.98497279767139067629955206939485e-01 2.00751360116430521696173627788085e-01 7.04028829423837543277642225802992e-03
 	 4.68137613089583959347095287739648e-01 2.65931193455208048082027971759089e-01 9.48849653068861015325907715123321e-03
 	 3.40008157914665265497689006224391e-01 3.29995921042667450517882343774545e-01 1.11734306441569428841598110579980e-02
 	 2.22840607043837790612883509311359e-01 3.88579696478081215715860707859974e-01 1.15528401685937379128610302814195e-02
 	 1.24619225144442902220021096582059e-01 4.37690387427778659912291914224625e-01 1.03193040890783606366998270686963e-02
 	 5.20354511271805542094170959899202e-02 4.73982274436409833917593914520694e-01 7.49699164492557447447840246468331e-03
 	 1.00182804616806286901464773109183e-02 4.94990859769159796677229223860195e-01 3.46169182931777008604967704741284e-03
 	 9.74726379602479653385671554133296e-01 9.23064449661557817616852616993128e-03 1.39768299255790253918241283770385e-04
 	 9.16958386552594983953667906462215e-01 3.03291574417083945047757254087628e-02 7.94184947537407122733488229471277e-04
 	 8.30824899622818580091632156836567e-01 6.17875549564806253455273576946638e-02 2.18963798555460355949042750012268e-03
 	 7.22203284890967966980213077476947e-01 1.01459255902674544413955004529271e-01 4.28917340811944738238059571244776e-03
 	 5.98497279767139067629955206939485e-01 1.46640204948922103778130576756666e-01 6.77922202107349332333985358900463e-03
 	 4.68137613089584014858246518997476e-01 1.94251260305117634530347459076438e-01 9.13664638994479694211747755616670e-03
 	 3.40008157914665209986537774966564e-01 2.41047779033426001760176404786762e-01 1.07591001828428005360205332863188e-02
 	 2.22840607043837735101732278053532e-01 2.83840698750374820225061966993962e-01 1.11244405347672940115311135400589e-02
 	 1.24619225144442902220021096582059e-01 3.19713939070490615890207664051559e-01 9.93664614275597060655265124751168e-03
 	 5.20354511271805542094170959899202e-02 3.46223596319349402605780596786644e-01 7.21899000821835026137085478126210e-03
 	 1.00182804616806286901464773109183e-02 3.61569461259415803056072036270052e-01 3.33332620749161433887364225370220e-03
 	 9.74726379602479653385671554133296e-01 6.07709093906260225392834684043919e-03 1.24020290192535035918644514829623e-04
 	 9.16958386552594983953667906462215e-01 1.99675166718843721813669844777905e-02 7.04702340835359586183883617849233e-04
 	 8.30824899622818469069329694320913e-01 4.06784803066063405108110373475938e-02 1.94292654222040788065950511764868e-03
 	 7.22203284890967966980213077476947e-01 6.67967577947830015716590423835441e-02 3.80590258015206690800358302340101e-03
 	 5.98497279767139067629955206939485e-01 9.65421061469886598871426031109877e-02 6.01539180779813234534181276558229e-03
 	 4.68137613089584014858246518997476e-01 1.27887340297261675736706365569262e-01 8.10719986363852597455181836494376e-03
 	 3.40008157914665209986537774966564e-01 1.58696315775382013057992480753455e-01 9.54684813360095335665889137999329e-03
 	 2.22840607043837790612883509311359e-01 1.86869480147951350090806954540312e-01 9.87102476525472671831096249661641e-03
 	 1.24619225144442902220021096582059e-01 2.10487001522988825819027169927722e-01 8.81706184254135369449123516005784e-03
 	 5.20354511271805542094170959899202e-02 2.27939910463828554476606313983211e-01 6.40561014538610067753365839848811e-03
 	 1.00182804616806286901464773109183e-02 2.38043020470237065566720957576763e-01 2.95775283637763914540430576494145e-03
 	 9.74726379602479653385671554133296e-01 3.41001788807683212101373726454767e-03 9.90754022077294116020371173014780e-05
 	 9.16958386552594983953667906462215e-01 1.12043064213386417415918572260125e-02 5.62961655279163022611021993668601e-04
 	 8.30824899622818580091632156836567e-01 2.28257807717956451298846332065295e-02 1.55213496381696497601609951999535e-03
 	 7.22203284890968078002515539992601e-01 3.74814432151447385344056328904117e-02 3.04040031116374273589819665630785e-03
 	 5.98497279767139067629955206939485e-01 5.41723519057005220567191372538218e-02 4.80548273084554708467486250356160e-03
 	 4.68137613089584070369397750255303e-01 7.17609992091873816200120472785784e-02 6.47655384470938091240332923348433e-03
 	 3.40008157914665209986537774966564e-01 8.90487374621081739789474340796005e-02 7.62663768311000120347920017138676e-03
 	 2.22840607043837790612883509311359e-01 1.04857451769254872431247349595651e-01 7.88561087304193164548848926642677e-03
 	 1.24619225144442902220021096582059e-01 1.18109873226903361320694330061087e-01 7.04363735146935551756364191078319e-03
 	 5.20354511271805542094170959899202e-02 1.27903166150115654708940837736009e-01 5.11721429255484680509447059648664e-03
 	 1.00182804616806286901464773109183e-02 1.33572290767884682693988906976301e-01 2.36284362373476858332210781554750e-03
 	 9.74726379602479653385671554133296e-01 1.42716849107199852952909679970617e-03 6.67878658366929473183884469200677e-05
 	 9.16958386552594983953667906462215e-01 4.68925196690636592045109409809811e-03 3.79498913616865677679579338388294e-04
 	 8.30824899622818469069329694320913e-01 9.55309801028522698196354667743435e-03 1.04631199484305848282361672829666e-03
 	 7.22203284890968078002515539992601e-01 1.56868193986886006463521425757790e-02 2.04956874811457060228669924129008e-03
 	 5.98497279767139067629955206939485e-01 2.26723367045685852971814711054321e-02 3.23943106721214348422965834117804e-03
 	 4.68137613089584014858246518997476e-01 3.00335776293989553664687264245003e-02 4.36591928597613188750559132245144e-03
 	 3.40008157914665209986537774966564e-01 3.72688814096918674678704519465100e-02 5.14120400234801145505914021782701e-03
 	 2.22840607043837790612883509311359e-01 4.38851807031371832223953788343351e-02 5.31578080223028132111906529644330e-03
 	 1.24619225144442902220021096582059e-01 4.94316144625885911523255344945937e-02 4.74819678698769689906278301805287e-03
 	 5.20354511271805542094170959899202e-02 5.35303258308534868348260715720244e-02 3.44957289108130957591691334584993e-03
 	 1.00182804616806286901464773109183e-02 5.59029808408844086642375259543769e-02 1.59282000797945346923234488656362e-03
 	 9.74726379602479653385671554133296e-01 2.75120314780604585669365746980475e-04 2.96064170516317079679714796558443e-05
 	 9.16958386552594983953667906462215e-01 9.03963677233221574169874656945467e-04 1.68228209816659383642536984559968e-04
 	 8.30824899622818469069329694320913e-01 1.84158447174337380758402105129790e-03 4.63820020259269780952410267005348e-04
 	 7.22203284890967855957910614961293e-01 3.02400362527061039585873913893010e-03 9.08554067007380549217399057226885e-04
 	 5.98497279767139067629955206939485e-01 4.37062648873887127365378546528518e-03 1.43600856210026857698314195488365e-03
 	 4.68137613089584014858246518997476e-01 5.78967892234039105403553548967466e-03 1.93536992947837289263945947936918e-03
 	 3.40008157914665209986537774966564e-01 7.18445400742673268013049892033450e-03 2.27904617005157293305184218468185e-03
 	 2.22840607043837790612883509311359e-01 8.45990140952579405819733437965624e-03 2.35643438241774950958618006779943e-03
 	 1.24619225144442902220021096582059e-01 9.52910705087495202292302565183491e-03 2.10482986029990803630851381456068e-03
 	 5.20354511271805542094170959899202e-02 1.03192301294645627507406970835291e-02 1.52916240673237231739722830070605e-03
 	 1.00182804616806286901464773109183e-02 1.07766152226116407319977952283807e-02 7.06081753828325178745650703149295e-04
 	 ];
 
 	 case  21 

 	 % ALG. DEG.:   21
 	 % PTS CARD.:  121
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw=[
 	 9.74726379602479653385671554133296e-01 2.49985000827397454981060320733377e-02 2.96064170516318231644523062406904e-05
 	 9.16958386552594983953667906462215e-01 8.21376497701717944721622188808396e-02 1.68228209816660061268894788000239e-04
 	 8.30824899622818469069329694320913e-01 1.67333515905438101611935053369962e-01 4.63820020259271624096103492362886e-04
 	 7.22203284890968078002515539992601e-01 2.74772711483761422623928183384123e-01 9.08554067007384235504785507941961e-04
 	 5.98497279767139067629955206939485e-01 3.97132093744122061096391007595230e-01 1.43600856210027443167487337660759e-03
 	 4.68137613089584014858246518997476e-01 5.26072707988075594087717945512850e-01 1.93536992947838069889510137500110e-03
 	 3.40008157914665209986537774966564e-01 6.52807388077908057333331726113101e-01 2.27904617005158204035009106291909e-03
 	 2.22840607043837790612883509311359e-01 7.68699491546636415328919156308984e-01 2.35643438241775905056529794023845e-03
 	 1.24619225144442902220021096582059e-01 8.65851667804682145757055877766106e-01 2.10482986029991670992589369859616e-03
 	 5.20354511271805542094170959899202e-02 9.37645318743354883039842206926551e-01 1.52916240673237838892939421953088e-03
 	 1.00182804616806286901464773109183e-02 9.79205104315707730577855727460701e-01 7.06081753828327997671299165460823e-04
 	 9.74726379602479653385671554133296e-01 2.38464519064483515542463010206120e-02 6.67878658366928253456440423008189e-05
 	 9.16958386552594983953667906462215e-01 7.83523614804986640036688072541438e-02 3.79498913616864972948167222810412e-04
 	 8.30824899622818469069329694320913e-01 1.59622002366896276193131143372739e-01 1.04631199484305674810014075148956e-03
 	 7.22203284890968078002515539992601e-01 2.62109895710343432373434779947274e-01 2.04956874811456713283974728767589e-03
 	 5.98497279767139067629955206939485e-01 3.78830383528292347072863321955083e-01 3.23943106721213784637836141655498e-03
 	 4.68137613089584014858246518997476e-01 5.01828809281017029775284754578024e-01 4.36591928597612408124994942681951e-03
 	 3.40008157914665209986537774966564e-01 6.22722960675643033567894235602580e-01 5.14120400234800278144176033379154e-03
 	 2.22840607043837790612883509311359e-01 7.33274212253025026164721111854305e-01 5.31578080223027178013994742400428e-03
 	 1.24619225144442902220021096582059e-01 8.25949160392968617649955831439001e-01 4.74819678698768822544540313401740e-03
 	 5.20354511271805542094170959899202e-02 8.94434223041966069978059294953709e-01 3.44957289108130350438474742702510e-03
 	 1.00182804616806286901464773109183e-02 9.34078738697435073667918459250359e-01 1.59282000797945065030669642425210e-03
 	 9.74726379602479653385671554133296e-01 2.18636025094435144933147086021563e-02 9.90754022077298452829061115032516e-05
 	 9.16958386552594983953667906462215e-01 7.18373070260663604269524284973159e-02 5.62961655279165516276018710328799e-04
 	 8.30824899622818469069329694320913e-01 1.46349319605385830289634441214730e-01 1.55213496381697169806956893012284e-03
 	 7.22203284890968078002515539992601e-01 2.40315271893887294485381289632642e-01 3.04040031116375574632426648236105e-03
 	 5.98497279767139067629955206939485e-01 3.47330368327160410313325655806693e-01 4.80548273084556790135657422524673e-03
 	 4.68137613089584070369397750255303e-01 4.60101387701228603521741433723946e-01 6.47655384470940866797894486239784e-03
 	 3.40008157914665209986537774966564e-01 5.70943104623226616034514790953835e-01 7.62663768311003416322524373072156e-03
 	 2.22840607043837790612883509311359e-01 6.72301941186907336955869141092990e-01 7.88561087304196460523453282576156e-03
 	 1.24619225144442902220021096582059e-01 7.57270901628653736459284573356854e-01 7.04363735146938587522447150490734e-03
 	 5.20354511271805542094170959899202e-02 8.20061382722703680059339603758417e-01 5.11721429255486848913792030657532e-03
 	 1.00182804616806286901464773109183e-02 8.56409428770434688615864615712781e-01 2.36284362373477855798209468218829e-03
 	 9.74726379602479653385671554133296e-01 1.91965294584577408909531470726506e-02 1.24020290192534520922612584215017e-04
 	 9.16958386552594983953667906462215e-01 6.30740967755206438649651090599946e-02 7.04702340835356658838017906987261e-04
 	 8.30824899622818469069329694320913e-01 1.28496620070575107153132421444752e-01 1.94292654222039985756342872491587e-03
 	 7.22203284890968078002515539992601e-01 2.10999957314248975936976648881682e-01 3.80590258015205129549229923213716e-03
 	 5.98497279767139067629955206939485e-01 3.04960614085872272482902189949527e-01 6.01539180779810719185141110187942e-03
 	 4.68137613089584014858246518997476e-01 4.03975046613154309405047115433263e-01 8.10719986363849128008229882880187e-03
 	 3.40008157914665209986537774966564e-01 5.01295526309952665933167281764327e-01 9.54684813360091519274241989023722e-03
 	 2.22840607043837790612883509311359e-01 5.90289912808210748274007073632674e-01 9.87102476525468508494753905324615e-03
 	 1.24619225144442902220021096582059e-01 6.64893773332568160938649270974565e-01 8.81706184254131726529823964710886e-03
 	 5.20354511271805542094170959899202e-02 7.20024638408990780291674127511214e-01 6.40561014538607378931978075797815e-03
 	 1.00182804616806286901464773109183e-02 7.51938699068082194720830102596665e-01 2.95775283637762656865910493309002e-03
 	 9.74726379602479653385671554133296e-01 1.60429759009047684381599196967727e-02 1.39768299255790416548567156596050e-04
 	 9.16958386552594983953667906462215e-01 5.27124560056966284804502720362507e-02 7.94184947537407990095226217874824e-04
 	 8.30824899622818580091632156836567e-01 1.07387545420700850073991716726596e-01 2.18963798555460616157564146533332e-03
 	 7.22203284890967966980213077476947e-01 1.76337459206357488605831917993783e-01 4.28917340811945171918928565446549e-03
 	 5.98497279767139067629955206939485e-01 2.54862515283938828591914216303849e-01 6.77922202107350026223375749623301e-03
 	 4.68137613089584014858246518997476e-01 3.37611126605298350611406021926086e-01 9.13664638994480735045833341700927e-03
 	 3.40008157914665209986537774966564e-01 4.18944063051908788253285820246674e-01 1.07591001828428109443613891471614e-02
 	 2.22840607043837846124034740569186e-01 4.93318694205787389162054523694678e-01 1.11244405347673061545954453777085e-02
 	 1.24619225144442902220021096582059e-01 5.55666835785066481889771239366382e-01 9.93664614275598101489350710835424e-03
 	 5.20354511271805542094170959899202e-02 6.01740952553470043184802307223435e-01 7.21899000821835720026475868849047e-03
 	 1.00182804616806286901464773109183e-02 6.28412258278903568253781486419030e-01 3.33332620749161780832059420731639e-03
 	 9.74726379602479653385671554133296e-01 1.26368101987601767766111748869662e-02 1.45150744155791517004186474970595e-04
 	 9.16958386552594983953667906462215e-01 4.15208067237025149620599506761209e-02 8.24768826308854593847008640494778e-04
 	 8.30824899622818469069329694320913e-01 8.45875501885907515875473450250865e-02 2.27396043829210551742714407907897e-03
 	 7.22203284890967966980213077476947e-01 1.38898357554516044265469076890440e-01 4.45434848471892245319603276243470e-03
 	 5.98497279767139067629955206939485e-01 2.00751360116430521696173627788085e-01 7.04028829423837543277642225802992e-03
 	 4.68137613089583959347095287739648e-01 2.65931193455208048082027971759089e-01 9.48849653068861015325907715123321e-03
 	 3.40008157914665265497689006224391e-01 3.29995921042667450517882343774545e-01 1.11734306441569428841598110579980e-02
 	 2.22840607043837790612883509311359e-01 3.88579696478081215715860707859974e-01 1.15528401685937379128610302814195e-02
 	 1.24619225144442902220021096582059e-01 4.37690387427778659912291914224625e-01 1.03193040890783606366998270686963e-02
 	 5.20354511271805542094170959899202e-02 4.73982274436409833917593914520694e-01 7.49699164492557447447840246468331e-03
 	 1.00182804616806286901464773109183e-02 4.94990859769159796677229223860195e-01 3.46169182931777008604967704741284e-03
 	 9.74726379602479653385671554133296e-01 9.23064449661557817616852616993128e-03 1.39768299255790253918241283770385e-04
 	 9.16958386552594983953667906462215e-01 3.03291574417083945047757254087628e-02 7.94184947537407122733488229471277e-04
 	 8.30824899622818580091632156836567e-01 6.17875549564806253455273576946638e-02 2.18963798555460355949042750012268e-03
 	 7.22203284890967966980213077476947e-01 1.01459255902674544413955004529271e-01 4.28917340811944738238059571244776e-03
 	 5.98497279767139067629955206939485e-01 1.46640204948922103778130576756666e-01 6.77922202107349332333985358900463e-03
 	 4.68137613089584014858246518997476e-01 1.94251260305117634530347459076438e-01 9.13664638994479694211747755616670e-03
 	 3.40008157914665209986537774966564e-01 2.41047779033426001760176404786762e-01 1.07591001828428005360205332863188e-02
 	 2.22840607043837735101732278053532e-01 2.83840698750374820225061966993962e-01 1.11244405347672940115311135400589e-02
 	 1.24619225144442902220021096582059e-01 3.19713939070490615890207664051559e-01 9.93664614275597060655265124751168e-03
 	 5.20354511271805542094170959899202e-02 3.46223596319349402605780596786644e-01 7.21899000821835026137085478126210e-03
 	 1.00182804616806286901464773109183e-02 3.61569461259415803056072036270052e-01 3.33332620749161433887364225370220e-03
 	 9.74726379602479653385671554133296e-01 6.07709093906260225392834684043919e-03 1.24020290192535035918644514829623e-04
 	 9.16958386552594983953667906462215e-01 1.99675166718843721813669844777905e-02 7.04702340835359586183883617849233e-04
 	 8.30824899622818469069329694320913e-01 4.06784803066063405108110373475938e-02 1.94292654222040788065950511764868e-03
 	 7.22203284890967966980213077476947e-01 6.67967577947830015716590423835441e-02 3.80590258015206690800358302340101e-03
 	 5.98497279767139067629955206939485e-01 9.65421061469886598871426031109877e-02 6.01539180779813234534181276558229e-03
 	 4.68137613089584014858246518997476e-01 1.27887340297261675736706365569262e-01 8.10719986363852597455181836494376e-03
 	 3.40008157914665209986537774966564e-01 1.58696315775382013057992480753455e-01 9.54684813360095335665889137999329e-03
 	 2.22840607043837790612883509311359e-01 1.86869480147951350090806954540312e-01 9.87102476525472671831096249661641e-03
 	 1.24619225144442902220021096582059e-01 2.10487001522988825819027169927722e-01 8.81706184254135369449123516005784e-03
 	 5.20354511271805542094170959899202e-02 2.27939910463828554476606313983211e-01 6.40561014538610067753365839848811e-03
 	 1.00182804616806286901464773109183e-02 2.38043020470237065566720957576763e-01 2.95775283637763914540430576494145e-03
 	 9.74726379602479653385671554133296e-01 3.41001788807683212101373726454767e-03 9.90754022077294116020371173014780e-05
 	 9.16958386552594983953667906462215e-01 1.12043064213386417415918572260125e-02 5.62961655279163022611021993668601e-04
 	 8.30824899622818580091632156836567e-01 2.28257807717956451298846332065295e-02 1.55213496381696497601609951999535e-03
 	 7.22203284890968078002515539992601e-01 3.74814432151447385344056328904117e-02 3.04040031116374273589819665630785e-03
 	 5.98497279767139067629955206939485e-01 5.41723519057005220567191372538218e-02 4.80548273084554708467486250356160e-03
 	 4.68137613089584070369397750255303e-01 7.17609992091873816200120472785784e-02 6.47655384470938091240332923348433e-03
 	 3.40008157914665209986537774966564e-01 8.90487374621081739789474340796005e-02 7.62663768311000120347920017138676e-03
 	 2.22840607043837790612883509311359e-01 1.04857451769254872431247349595651e-01 7.88561087304193164548848926642677e-03
 	 1.24619225144442902220021096582059e-01 1.18109873226903361320694330061087e-01 7.04363735146935551756364191078319e-03
 	 5.20354511271805542094170959899202e-02 1.27903166150115654708940837736009e-01 5.11721429255484680509447059648664e-03
 	 1.00182804616806286901464773109183e-02 1.33572290767884682693988906976301e-01 2.36284362373476858332210781554750e-03
 	 9.74726379602479653385671554133296e-01 1.42716849107199852952909679970617e-03 6.67878658366929473183884469200677e-05
 	 9.16958386552594983953667906462215e-01 4.68925196690636592045109409809811e-03 3.79498913616865677679579338388294e-04
 	 8.30824899622818469069329694320913e-01 9.55309801028522698196354667743435e-03 1.04631199484305848282361672829666e-03
 	 7.22203284890968078002515539992601e-01 1.56868193986886006463521425757790e-02 2.04956874811457060228669924129008e-03
 	 5.98497279767139067629955206939485e-01 2.26723367045685852971814711054321e-02 3.23943106721214348422965834117804e-03
 	 4.68137613089584014858246518997476e-01 3.00335776293989553664687264245003e-02 4.36591928597613188750559132245144e-03
 	 3.40008157914665209986537774966564e-01 3.72688814096918674678704519465100e-02 5.14120400234801145505914021782701e-03
 	 2.22840607043837790612883509311359e-01 4.38851807031371832223953788343351e-02 5.31578080223028132111906529644330e-03
 	 1.24619225144442902220021096582059e-01 4.94316144625885911523255344945937e-02 4.74819678698769689906278301805287e-03
 	 5.20354511271805542094170959899202e-02 5.35303258308534868348260715720244e-02 3.44957289108130957591691334584993e-03
 	 1.00182804616806286901464773109183e-02 5.59029808408844086642375259543769e-02 1.59282000797945346923234488656362e-03
 	 9.74726379602479653385671554133296e-01 2.75120314780604585669365746980475e-04 2.96064170516317079679714796558443e-05
 	 9.16958386552594983953667906462215e-01 9.03963677233221574169874656945467e-04 1.68228209816659383642536984559968e-04
 	 8.30824899622818469069329694320913e-01 1.84158447174337380758402105129790e-03 4.63820020259269780952410267005348e-04
 	 7.22203284890967855957910614961293e-01 3.02400362527061039585873913893010e-03 9.08554067007380549217399057226885e-04
 	 5.98497279767139067629955206939485e-01 4.37062648873887127365378546528518e-03 1.43600856210026857698314195488365e-03
 	 4.68137613089584014858246518997476e-01 5.78967892234039105403553548967466e-03 1.93536992947837289263945947936918e-03
 	 3.40008157914665209986537774966564e-01 7.18445400742673268013049892033450e-03 2.27904617005157293305184218468185e-03
 	 2.22840607043837790612883509311359e-01 8.45990140952579405819733437965624e-03 2.35643438241774950958618006779943e-03
 	 1.24619225144442902220021096582059e-01 9.52910705087495202292302565183491e-03 2.10482986029990803630851381456068e-03
 	 5.20354511271805542094170959899202e-02 1.03192301294645627507406970835291e-02 1.52916240673237231739722830070605e-03
 	 1.00182804616806286901464773109183e-02 1.07766152226116407319977952283807e-02 7.06081753828325178745650703149295e-04
 	 ];
 
 	 case  22 

 	 % ALG. DEG.:   22
 	 % PTS CARD.:  144
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.0e-16  

 	 xyw=[
 	 9.78437936834149701859075776155805e-01 2.13632677812950685924953120320424e-02 1.82847410167975443653996109327764e-05
 	 9.28942101264410902139445624925429e-01 7.04027674433664873987481769290753e-02 1.04842651467025558555644371150350e-04
 	 8.54552543764935834680329662660370e-01 1.44106476813362832656295609012886e-01 2.93336457865859265899816099576469e-04
 	 7.59598889525226916852318481687689e-01 2.38184688473003419728613039296761e-01 5.86785242010245109735289137375958e-04
 	 6.49600650277254998421483378479024e-01 3.47168778838120251073462441127049e-01 9.54160185507173870707309237815252e-04
 	 5.30950849312817774183770325180376e-01 4.64724666264288877037813563219970e-01 1.33538856066284738165206302795696e-03
 	 4.10545081201457717767766553151887e-01 5.84020331377143930851048025942873e-01 1.65371584911227055905702520988143e-03
 	 2.95380884262580245547269441885874e-01 6.98122750941501890586948775307974e-01 1.83267494088284609195238505918724e-03
 	 1.92151054529854037333791438868502e-01 8.00400834380682879576340837957105e-01 1.81381154920544286797412514289363e-03
 	 1.06854490883476538343188622093294e-01 8.84910990759773530278664566139923e-01 1.57109793321291496201452808634258e-03
 	 4.44464631554077893582643810077570e-02 9.46743636263232879457518720300868e-01 1.11871243563200942032487272825847e-03
 	 8.53905498842744137277804838959128e-03 9.82319989513991576046691989176907e-01 5.11023550052579211833148065124988e-04
 	 9.78437936834149701859075776155805e-01 2.05283482785228732492299741352326e-02 4.14487321153333911245841836290538e-05
 	 9.28942101264410902139445624925429e-01 6.76512855919304129104219214241311e-02 2.37662374923760985048412641695847e-04
 	 8.54552543764935834680329662660370e-01 1.38474505656187546476232341774448e-01 6.64949219164398834178153485652274e-04
 	 7.59598889525226916852318481687689e-01 2.28875951452820108888985828343721e-01 1.33015306495019099315701982533255e-03
 	 6.49600650277254998421483378479024e-01 3.33600724214035859738203271263046e-01 2.16293629140667902077677098304775e-03
 	 5.30950849312817885206072787696030e-01 4.46562290954689411481837169048958e-01 3.02712314437195281410786229514542e-03
 	 4.10545081201457717767766553151887e-01 5.61195641368380626623491025384283e-01 3.74872278266157911430500604410554e-03
 	 2.95380884262580245547269441885874e-01 6.70838708722062859735046913556289e-01 4.15439587628580082878659851530756e-03
 	 1.92151054529854037333791438868502e-01 7.69119558805197778283968546020333e-01 4.11163543096666663639870975544000e-03
 	 1.06854490883476538343188622093294e-01 8.50326888179282813773340876650764e-01 3.56144050937733363387804885746846e-03
 	 4.44464631554077893582643810077570e-02 9.09742989445814109750187981262570e-01 2.53595126209365260075423442742704e-03
 	 8.53905498842744137277804838959128e-03 9.43928947206956858728688075643731e-01 1.15841281051219332533241956895154e-03
 	 9.78437936834149701859075776155805e-01 1.90813766291924764850751472522461e-02 6.20449371221394276780872201193517e-05
 	 9.28942101264411013161748087441083e-01 6.28827824973735710623046202272235e-02 3.55758701313521868286882110510305e-04
 	 8.54552543764935834680329662660370e-01 1.28713920872599585365492202981841e-01 9.95367780555305977155389207666758e-04
 	 7.59598889525227027874620944203343e-01 2.12743284154290612786297742786701e-01 1.99111671372753651354514659033157e-03
 	 6.49600650277254998421483378479024e-01 3.10086373055115882557686290965648e-01 3.23771655610849548243002082870134e-03
 	 5.30950849312817885206072787696030e-01 4.15085673064905569251692440957413e-01 4.53132473704907865613700224116656e-03
 	 4.10545081201457717767766553151887e-01 5.21638918549263363999557441275101e-01 5.61149298104889407423634395399858e-03
 	 2.95380884262580245547269441885874e-01 6.23553628616042687760057106061140e-01 6.21874826490225254826960110676737e-03
 	 1.92151054529854037333791438868502e-01 7.14907004466330153746866926667280e-01 6.15473981384136083899738522973166e-03
 	 1.06854490883476538343188622093294e-01 7.90390312514984261227368733671028e-01 5.33114865501066199221513741690615e-03
 	 4.44464631554077893582643810077570e-02 8.45618380098534849764746468281373e-01 3.79608563571004692729915497295679e-03
 	 8.53905498842744137277804838959128e-03 8.77394688967597313755675259017153e-01 1.73403735944726677779825774194933e-03
 	 9.78437936834149701859075776155805e-01 1.71129249973081612457015410200256e-02 7.87458885347254298374755632217159e-05
 	 9.28942101264410902139445624925429e-01 5.63957392284404127047459098776017e-02 4.51520081062293068049212640957535e-04
 	 8.54552543764935834680329662660370e-01 1.15435679343617189629433994468855e-01 1.26329599052323830049582298329369e-03
 	 7.59598889525226916852318481687689e-01 1.90796499443523920325205267545243e-01 2.52707573045262041955272280802092e-03
 	 6.49600650277254998421483378479024e-01 2.78097589492634300611939579539467e-01 4.10922919516310859722185711007114e-03
 	 5.30950849312817885206072787696030e-01 3.72265069164326722894742260905332e-01 5.75104447210384762956270066069919e-03
 	 4.10545081201457717767766553151887e-01 4.67826187925743153250834893697174e-01 7.12196709828551068749424857173835e-03
 	 2.95380884262580245547269441885874e-01 5.59227286671783230254106911161216e-01 7.89268037663576858820047021936261e-03
 	 1.92151054529854037333791438868502e-01 6.41156567748136674289582970232004e-01 7.81144244512494909105093654488883e-03
 	 1.06854490883476538343188622093294e-01 7.08852951205559689284996238711756e-01 6.76616106360307823647248781639973e-03
 	 4.44464631554077893582643810077570e-02 7.58383642657750045579234665638069e-01 4.81789732092790211337440808847532e-03
 	 8.53905498842744137277804838959128e-03 7.86881879495422986714459057111526e-01 2.20079701834945823391009867009416e-03
 	 9.78437936834149701859075776155805e-01 1.47466345908192283942206302072009e-02 9.04996315231279562949981420949541e-05
 	 9.28942101264410902139445624925429e-01 4.85976160715808208623300856743299e-02 5.18914723318041623892349356594877e-04
 	 8.54552543764935834680329662660370e-01 9.94738060437400095636917285446543e-02 1.45185766234108386274481716782248e-03
 	 7.59598889525226916852318481687689e-01 1.64414105650767944366563710900664e-01 2.90427127933351719030197202187082e-03
 	 6.49600650277254998421483378479024e-01 2.39643633889624924071526379520947e-01 4.72257961559919940686125272577556e-03
 	 5.30950849312817774183770325180376e-01 3.20790101444135888897335462388583e-01 6.60945498594512660661681735518869e-03
 	 4.10545081201457717767766553151887e-01 4.03137502586030316287235564232105e-01 8.18500381553827725811256499355295e-03
 	 2.95380884262580245547269441885874e-01 4.81900110650943513945776430773549e-01 9.07075504647298497262752903225191e-03
 	 1.92151054529853926311488976352848e-01 5.52500617023264473104404714831617e-01 8.97739140547237392253610011039200e-03
 	 1.06854490883476538343188622093294e-01 6.10836280279173582385965346475132e-01 7.77608957719978007711025824733042e-03
 	 4.44464631554077893582643810077570e-02 6.53518113337575590193750940670725e-01 5.53702473073200418518524656974478e-03
 	 8.53905498842744137277804838959128e-03 6.78075755306665750588024366152240e-01 2.52929166111312509965247663501486e-03
 	 9.78437936834149701859075776155805e-01 1.21311769153246654801003856505304e-02 9.65671801568913706296376497917322e-05
 	 9.28942101264411013161748087441083e-01 3.99783607979548316624374137973064e-02 5.53705365749590809262836721416079e-04
 	 8.54552543764935834680329662660370e-01 8.18311684693519975075659544927476e-02 1.54919747276125461046825115829506e-03
 	 7.59598889525227027874620944203343e-01 1.35253680474735543670661286341783e-01 3.09898817415860854465603502205795e-03
 	 6.49600650277254887399180915963370e-01 1.97140527314363322997081695575616e-01 5.03920500967215689858136329348781e-03
 	 5.30950849312817774183770325180376e-01 2.63894887293573909836652546800906e-01 7.05258595670099543845088518878583e-03
 	 4.10545081201457773278917784409714e-01 3.31637183721767481170417113389703e-01 8.73376747216847958144025909632546e-03
 	 2.95380884262580245547269441885874e-01 3.96430484651777104154746211861493e-01 9.67890390258589056182714216447494e-03
 	 1.92151054529854092844942670126329e-01 4.54509311236884150364545575939701e-01 9.57928069540956925176367064977967e-03
 	 1.06854490883476538343188622093294e-01 5.02498582759948630993562801450025e-01 8.29743757493281788861771985921223e-03
 	 4.44464631554077893582643810077570e-02 5.37610381639415102483781083719805e-01 5.90825460509322112484520417297063e-03
 	 8.53905498842744137277804838959128e-03 5.57812489280687051618201621749904e-01 2.69886804396120543597659136025868e-03
 	 9.78437936834149701859075776155805e-01 9.43088625052563613027079014727860e-03 9.65671801568912757619475573100942e-05
 	 9.28942101264411013161748087441083e-01 3.10795379376342176258596339266660e-02 5.53705365749590267161750478663862e-04
 	 8.54552543764935834680329662660370e-01 6.36162877657121955676799984757963e-02 1.54919747276125309258520967858885e-03
 	 7.59598889525227027874620944203343e-01 1.05147430000037511721444616341614e-01 3.09898817415860550888995206264553e-03
 	 6.49600650277254998421483378479024e-01 1.53258822408381734092586157203186e-01 5.03920500967215169441093536306653e-03
 	 5.30950849312817774183770325180376e-01 2.05154263393608427001879590534372e-01 7.05258595670098849955698128155746e-03
 	 4.10545081201457717767766553151887e-01 2.57817735076774856572967564716237e-01 8.73376747216847090782287921228999e-03
 	 2.95380884262580245547269441885874e-01 3.08188631085642761320286808768287e-01 9.67890390258588015348628630363237e-03
 	 1.92151054529853981822640207610675e-01 3.53339634233261923323965447707451e-01 9.57928069540955884342281478893710e-03
 	 1.06854490883476538343188622093294e-01 3.90646926356575052707853501487989e-01 8.29743757493280921500033997517676e-03
 	 4.44464631554077893582643810077570e-02 4.17943155205177219180256997788092e-01 5.90825460509321505331303825414579e-03
 	 8.53905498842744137277804838959128e-03 4.33648455730885729053625254891813e-01 2.69886804396120240021050840084627e-03
 	 9.78437936834149701859075776155805e-01 6.81542857503106627725664168337971e-03 9.04996315231283899758671362967277e-05
 	 9.28942101264410902139445624925429e-01 2.24602826640082076092852503279573e-02 5.18914723318044117557346073255076e-04
 	 8.54552543764935834680329662660370e-01 4.59736501913241418781908009805193e-02 1.45185766234109080163872107505085e-03
 	 7.59598889525227027874620944203343e-01 7.59870048240050555143909605249064e-02 2.90427127933353150177064883052935e-03
 	 6.49600650277254998421483378479024e-01 1.10755715833120049751414626371115e-01 4.72257961559922195826644042426778e-03
 	 5.30950849312817885206072787696030e-01 1.48259049243046281407742981173215e-01 6.60945498594515869900112292611993e-03
 	 4.10545081201457662256615321894060e-01 1.86317416212511910433846651358181e-01 8.18500381553831715675251246011612e-03
 	 2.95380884262580301058420673143701e-01 2.22719005086476184995802896082751e-01 9.07075504647302834071442845242927e-03
 	 1.92151054529854037333791438868502e-01 2.55348328446881489561803846299881e-01 8.97739140547241729062299953056936e-03
 	 1.06854490883476538343188622093294e-01 2.82309228837349879270846031431574e-01 7.77608957719981824102672973708650e-03
 	 4.44464631554077893582643810077570e-02 3.02035423507016398403379753290210e-01 5.53702473073203107339912421025474e-03
 	 8.53905498842744137277804838959128e-03 3.13385189704906697016895122942515e-01 2.52929166111313724271680847266452e-03
 	 9.78437936834149701859075776155805e-01 4.44913816854213342577573087055498e-03 7.87458885347251181293509736391911e-05
 	 9.28942101264410902139445624925429e-01 1.46621595071486227057633300319139e-02 4.51520081062291333325736664150440e-04
 	 8.54552543764935834680329662660370e-01 3.00117768914469479346607272418623e-02 1.26329599052323331316582954997330e-03
 	 7.59598889525227027874620944203343e-01 4.96046110312490518001737882514135e-02 2.52707573045261087857360493558190e-03
 	 6.49600650277255109443785840994678e-01 7.23017602301106454554258107236819e-02 4.10922919516309298471057331880729e-03
 	 5.30950849312817885206072787696030e-01 9.67840815228553918991849513986381e-02 5.75104447210382507815751296220697e-03
 	 4.10545081201457717767766553151887e-01 1.21628730872799017959096090635285e-01 7.12196709828548293191863294282484e-03
 	 2.95380884262580245547269441885874e-01 1.45391829065636413176321184437256e-01 7.89268037663573736317790263683492e-03
 	 1.92151054529854037333791438868502e-01 1.66692377722009177354323128383840e-01 7.81144244512491873339010695076468e-03
 	 1.06854490883476538343188622093294e-01 1.84292557910963550327210214163642e-01 6.76616106360305221562034816429332e-03
 	 4.44464631554077893582643810077570e-02 1.97169894186842054040198490838520e-01 4.81789732092788303141617234359728e-03
 	 8.53905498842744137277804838959128e-03 2.04579065516149460890460431983229e-01 2.20079701834944999397358778026046e-03
 	 9.78437936834149701859075776155805e-01 2.48068653665782165584907659194869e-03 6.20449371221393057053428155001029e-05
 	 9.28942101264411013161748087441083e-01 8.17511623821547128709852358952048e-03 3.55758701313521217765578619207645e-04
 	 8.54552543764935834680329662660370e-01 1.67335353624646077097537499867030e-02 9.95367780555304025591478733758777e-04
 	 7.59598889525226916852318481687689e-01 2.76578263204824148502325442677829e-02 1.99111671372753261041732564251561e-03
 	 6.49600650277255109443785840994678e-01 4.03129766676291745319815618131543e-02 3.23771655610848941089785490987651e-03
 	 5.30950849312817885206072787696030e-01 5.39634776222766565645372338622110e-02 4.53132473704906998251962235713108e-03
 	 4.10545081201457717767766553151887e-01 6.78160002492790292549784680886660e-02 5.61149298104888279853375010475247e-03
 	 2.95380884262580245547269441885874e-01 8.10654871213770666926734520529862e-02 6.21874826490224127256700725752125e-03
 	 1.92151054529854037333791438868502e-01 9.29419410038159199416440969798714e-02 6.15473981384134869593305339208200e-03
 	 1.06854490883476538343188622093294e-01 1.02755196601539200429442644235678e-01 5.33114865501065245123601954446713e-03
 	 4.44464631554077893582643810077570e-02 1.09935156746057360876989150710870e-01 3.79608563571003955472438207152663e-03
 	 8.53905498842744137277804838959128e-03 1.14066256043975244871546692593256e-01 1.73403735944726352519174028543603e-03
 	 9.78437936834149701859075776155805e-01 1.03371488732742489169424970896216e-03 4.14487321153336282938094148331487e-05
 	 9.28942101264410902139445624925429e-01 3.40661314365861556119341457815608e-03 2.37662374923762286091019624301168e-04
 	 8.54552543764935834680329662660370e-01 6.97295057887661884343799556518206e-03 6.64949219164402520465539936367350e-04
 	 7.59598889525227027874620944203343e-01 1.15251590219528909919688430818496e-02 1.33015306495019836573179272676271e-03
 	 6.49600650277254998421483378479024e-01 1.67986255087091418403133502579294e-02 2.16293629140669116384110282069742e-03
 	 5.30950849312817885206072787696030e-01 2.24868597324928143343925057706656e-02 3.02712314437196972766175306901459e-03
 	 4.10545081201457717767766553151887e-01 2.82592774301615445864399589481764e-02 3.74872278266159993098671776579067e-03
 	 2.95380884262580245547269441885874e-01 3.37804070153568947176836445578374e-02 4.15439587628582424755352420220333e-03
 	 1.92151054529854037333791438868502e-01 3.87293866649480733599375525955111e-02 4.11163543096669005516563544233577e-03
 	 1.06854490883476538343188622093294e-01 4.28186209372406478834705012559425e-02 3.56144050937735358319802259075004e-03
 	 4.44464631554077893582643810077570e-02 4.58105473987779898692451752140187e-02 2.53595126209366691222291123608557e-03
 	 8.53905498842744137277804838959128e-03 4.75319978046155888762314134510234e-02 1.15841281051219961370501998487725e-03
 	 9.78437936834149701859075776155805e-01 1.98795384555229548428911812152364e-04 1.82847410167974257807869953307289e-05
 	 9.28942101264411013161748087441083e-01 6.55131292222554950654966887668706e-04 1.04842651467024880929286567710079e-04
 	 8.54552543764935834680329662660370e-01 1.34097942170133266337472832674393e-03 2.93336457865857368546014249943710e-04
 	 7.59598889525226916852318481687689e-01 2.21642200176960790791724775772309e-03 5.86785242010241315027685438110439e-04
 	 6.49600650277254998421483378479024e-01 3.23057088462475050505418039392680e-03 9.54160185507167799175143318990422e-04
 	 5.30950849312817774183770325180376e-01 4.32448442289334877841611159965396e-03 1.33538856066283870803468314392148e-03
 	 4.10545081201457717767766553151887e-01 5.43458742139835138118542090523988e-03 1.65371584911225971703530035483709e-03
 	 2.95380884262580245547269441885874e-01 6.49636479591786386578178280615248e-03 1.83267494088283438256892221573935e-03
 	 1.92151054529854037333791438868502e-01 7.44811108946308308986772317439318e-03 1.81381154920543115859066229944574e-03
 	 1.06854490883476538343188622093294e-01 8.23451835674993137814681176678278e-03 1.57109793321290477051410672260090e-03
 	 4.44464631554077893582643810077570e-02 8.80990058135933118421689869137481e-03 1.11871243563200226459053432392921e-03
 	 8.53905498842744137277804838959128e-03 9.14095549758098258052996243350208e-03 5.11023550052575850806413360061242e-04
 	 ];
 
 	 case  23 

 	 % ALG. DEG.:   23
 	 % PTS CARD.:  144
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 9.6e-16  

 	 xyw=[
 	 9.78437936834149701859075776155805e-01 2.13632677812950685924953120320424e-02 1.82847410167975443653996109327764e-05
 	 9.28942101264410902139445624925429e-01 7.04027674433664873987481769290753e-02 1.04842651467025558555644371150350e-04
 	 8.54552543764935834680329662660370e-01 1.44106476813362832656295609012886e-01 2.93336457865859265899816099576469e-04
 	 7.59598889525226916852318481687689e-01 2.38184688473003419728613039296761e-01 5.86785242010245109735289137375958e-04
 	 6.49600650277254998421483378479024e-01 3.47168778838120251073462441127049e-01 9.54160185507173870707309237815252e-04
 	 5.30950849312817774183770325180376e-01 4.64724666264288877037813563219970e-01 1.33538856066284738165206302795696e-03
 	 4.10545081201457717767766553151887e-01 5.84020331377143930851048025942873e-01 1.65371584911227055905702520988143e-03
 	 2.95380884262580245547269441885874e-01 6.98122750941501890586948775307974e-01 1.83267494088284609195238505918724e-03
 	 1.92151054529854037333791438868502e-01 8.00400834380682879576340837957105e-01 1.81381154920544286797412514289363e-03
 	 1.06854490883476538343188622093294e-01 8.84910990759773530278664566139923e-01 1.57109793321291496201452808634258e-03
 	 4.44464631554077893582643810077570e-02 9.46743636263232879457518720300868e-01 1.11871243563200942032487272825847e-03
 	 8.53905498842744137277804838959128e-03 9.82319989513991576046691989176907e-01 5.11023550052579211833148065124988e-04
 	 9.78437936834149701859075776155805e-01 2.05283482785228732492299741352326e-02 4.14487321153333911245841836290538e-05
 	 9.28942101264410902139445624925429e-01 6.76512855919304129104219214241311e-02 2.37662374923760985048412641695847e-04
 	 8.54552543764935834680329662660370e-01 1.38474505656187546476232341774448e-01 6.64949219164398834178153485652274e-04
 	 7.59598889525226916852318481687689e-01 2.28875951452820108888985828343721e-01 1.33015306495019099315701982533255e-03
 	 6.49600650277254998421483378479024e-01 3.33600724214035859738203271263046e-01 2.16293629140667902077677098304775e-03
 	 5.30950849312817885206072787696030e-01 4.46562290954689411481837169048958e-01 3.02712314437195281410786229514542e-03
 	 4.10545081201457717767766553151887e-01 5.61195641368380626623491025384283e-01 3.74872278266157911430500604410554e-03
 	 2.95380884262580245547269441885874e-01 6.70838708722062859735046913556289e-01 4.15439587628580082878659851530756e-03
 	 1.92151054529854037333791438868502e-01 7.69119558805197778283968546020333e-01 4.11163543096666663639870975544000e-03
 	 1.06854490883476538343188622093294e-01 8.50326888179282813773340876650764e-01 3.56144050937733363387804885746846e-03
 	 4.44464631554077893582643810077570e-02 9.09742989445814109750187981262570e-01 2.53595126209365260075423442742704e-03
 	 8.53905498842744137277804838959128e-03 9.43928947206956858728688075643731e-01 1.15841281051219332533241956895154e-03
 	 9.78437936834149701859075776155805e-01 1.90813766291924764850751472522461e-02 6.20449371221394276780872201193517e-05
 	 9.28942101264411013161748087441083e-01 6.28827824973735710623046202272235e-02 3.55758701313521868286882110510305e-04
 	 8.54552543764935834680329662660370e-01 1.28713920872599585365492202981841e-01 9.95367780555305977155389207666758e-04
 	 7.59598889525227027874620944203343e-01 2.12743284154290612786297742786701e-01 1.99111671372753651354514659033157e-03
 	 6.49600650277254998421483378479024e-01 3.10086373055115882557686290965648e-01 3.23771655610849548243002082870134e-03
 	 5.30950849312817885206072787696030e-01 4.15085673064905569251692440957413e-01 4.53132473704907865613700224116656e-03
 	 4.10545081201457717767766553151887e-01 5.21638918549263363999557441275101e-01 5.61149298104889407423634395399858e-03
 	 2.95380884262580245547269441885874e-01 6.23553628616042687760057106061140e-01 6.21874826490225254826960110676737e-03
 	 1.92151054529854037333791438868502e-01 7.14907004466330153746866926667280e-01 6.15473981384136083899738522973166e-03
 	 1.06854490883476538343188622093294e-01 7.90390312514984261227368733671028e-01 5.33114865501066199221513741690615e-03
 	 4.44464631554077893582643810077570e-02 8.45618380098534849764746468281373e-01 3.79608563571004692729915497295679e-03
 	 8.53905498842744137277804838959128e-03 8.77394688967597313755675259017153e-01 1.73403735944726677779825774194933e-03
 	 9.78437936834149701859075776155805e-01 1.71129249973081612457015410200256e-02 7.87458885347254298374755632217159e-05
 	 9.28942101264410902139445624925429e-01 5.63957392284404127047459098776017e-02 4.51520081062293068049212640957535e-04
 	 8.54552543764935834680329662660370e-01 1.15435679343617189629433994468855e-01 1.26329599052323830049582298329369e-03
 	 7.59598889525226916852318481687689e-01 1.90796499443523920325205267545243e-01 2.52707573045262041955272280802092e-03
 	 6.49600650277254998421483378479024e-01 2.78097589492634300611939579539467e-01 4.10922919516310859722185711007114e-03
 	 5.30950849312817885206072787696030e-01 3.72265069164326722894742260905332e-01 5.75104447210384762956270066069919e-03
 	 4.10545081201457717767766553151887e-01 4.67826187925743153250834893697174e-01 7.12196709828551068749424857173835e-03
 	 2.95380884262580245547269441885874e-01 5.59227286671783230254106911161216e-01 7.89268037663576858820047021936261e-03
 	 1.92151054529854037333791438868502e-01 6.41156567748136674289582970232004e-01 7.81144244512494909105093654488883e-03
 	 1.06854490883476538343188622093294e-01 7.08852951205559689284996238711756e-01 6.76616106360307823647248781639973e-03
 	 4.44464631554077893582643810077570e-02 7.58383642657750045579234665638069e-01 4.81789732092790211337440808847532e-03
 	 8.53905498842744137277804838959128e-03 7.86881879495422986714459057111526e-01 2.20079701834945823391009867009416e-03
 	 9.78437936834149701859075776155805e-01 1.47466345908192283942206302072009e-02 9.04996315231279562949981420949541e-05
 	 9.28942101264410902139445624925429e-01 4.85976160715808208623300856743299e-02 5.18914723318041623892349356594877e-04
 	 8.54552543764935834680329662660370e-01 9.94738060437400095636917285446543e-02 1.45185766234108386274481716782248e-03
 	 7.59598889525226916852318481687689e-01 1.64414105650767944366563710900664e-01 2.90427127933351719030197202187082e-03
 	 6.49600650277254998421483378479024e-01 2.39643633889624924071526379520947e-01 4.72257961559919940686125272577556e-03
 	 5.30950849312817774183770325180376e-01 3.20790101444135888897335462388583e-01 6.60945498594512660661681735518869e-03
 	 4.10545081201457717767766553151887e-01 4.03137502586030316287235564232105e-01 8.18500381553827725811256499355295e-03
 	 2.95380884262580245547269441885874e-01 4.81900110650943513945776430773549e-01 9.07075504647298497262752903225191e-03
 	 1.92151054529853926311488976352848e-01 5.52500617023264473104404714831617e-01 8.97739140547237392253610011039200e-03
 	 1.06854490883476538343188622093294e-01 6.10836280279173582385965346475132e-01 7.77608957719978007711025824733042e-03
 	 4.44464631554077893582643810077570e-02 6.53518113337575590193750940670725e-01 5.53702473073200418518524656974478e-03
 	 8.53905498842744137277804838959128e-03 6.78075755306665750588024366152240e-01 2.52929166111312509965247663501486e-03
 	 9.78437936834149701859075776155805e-01 1.21311769153246654801003856505304e-02 9.65671801568913706296376497917322e-05
 	 9.28942101264411013161748087441083e-01 3.99783607979548316624374137973064e-02 5.53705365749590809262836721416079e-04
 	 8.54552543764935834680329662660370e-01 8.18311684693519975075659544927476e-02 1.54919747276125461046825115829506e-03
 	 7.59598889525227027874620944203343e-01 1.35253680474735543670661286341783e-01 3.09898817415860854465603502205795e-03
 	 6.49600650277254887399180915963370e-01 1.97140527314363322997081695575616e-01 5.03920500967215689858136329348781e-03
 	 5.30950849312817774183770325180376e-01 2.63894887293573909836652546800906e-01 7.05258595670099543845088518878583e-03
 	 4.10545081201457773278917784409714e-01 3.31637183721767481170417113389703e-01 8.73376747216847958144025909632546e-03
 	 2.95380884262580245547269441885874e-01 3.96430484651777104154746211861493e-01 9.67890390258589056182714216447494e-03
 	 1.92151054529854092844942670126329e-01 4.54509311236884150364545575939701e-01 9.57928069540956925176367064977967e-03
 	 1.06854490883476538343188622093294e-01 5.02498582759948630993562801450025e-01 8.29743757493281788861771985921223e-03
 	 4.44464631554077893582643810077570e-02 5.37610381639415102483781083719805e-01 5.90825460509322112484520417297063e-03
 	 8.53905498842744137277804838959128e-03 5.57812489280687051618201621749904e-01 2.69886804396120543597659136025868e-03
 	 9.78437936834149701859075776155805e-01 9.43088625052563613027079014727860e-03 9.65671801568912757619475573100942e-05
 	 9.28942101264411013161748087441083e-01 3.10795379376342176258596339266660e-02 5.53705365749590267161750478663862e-04
 	 8.54552543764935834680329662660370e-01 6.36162877657121955676799984757963e-02 1.54919747276125309258520967858885e-03
 	 7.59598889525227027874620944203343e-01 1.05147430000037511721444616341614e-01 3.09898817415860550888995206264553e-03
 	 6.49600650277254998421483378479024e-01 1.53258822408381734092586157203186e-01 5.03920500967215169441093536306653e-03
 	 5.30950849312817774183770325180376e-01 2.05154263393608427001879590534372e-01 7.05258595670098849955698128155746e-03
 	 4.10545081201457717767766553151887e-01 2.57817735076774856572967564716237e-01 8.73376747216847090782287921228999e-03
 	 2.95380884262580245547269441885874e-01 3.08188631085642761320286808768287e-01 9.67890390258588015348628630363237e-03
 	 1.92151054529853981822640207610675e-01 3.53339634233261923323965447707451e-01 9.57928069540955884342281478893710e-03
 	 1.06854490883476538343188622093294e-01 3.90646926356575052707853501487989e-01 8.29743757493280921500033997517676e-03
 	 4.44464631554077893582643810077570e-02 4.17943155205177219180256997788092e-01 5.90825460509321505331303825414579e-03
 	 8.53905498842744137277804838959128e-03 4.33648455730885729053625254891813e-01 2.69886804396120240021050840084627e-03
 	 9.78437936834149701859075776155805e-01 6.81542857503106627725664168337971e-03 9.04996315231283899758671362967277e-05
 	 9.28942101264410902139445624925429e-01 2.24602826640082076092852503279573e-02 5.18914723318044117557346073255076e-04
 	 8.54552543764935834680329662660370e-01 4.59736501913241418781908009805193e-02 1.45185766234109080163872107505085e-03
 	 7.59598889525227027874620944203343e-01 7.59870048240050555143909605249064e-02 2.90427127933353150177064883052935e-03
 	 6.49600650277254998421483378479024e-01 1.10755715833120049751414626371115e-01 4.72257961559922195826644042426778e-03
 	 5.30950849312817885206072787696030e-01 1.48259049243046281407742981173215e-01 6.60945498594515869900112292611993e-03
 	 4.10545081201457662256615321894060e-01 1.86317416212511910433846651358181e-01 8.18500381553831715675251246011612e-03
 	 2.95380884262580301058420673143701e-01 2.22719005086476184995802896082751e-01 9.07075504647302834071442845242927e-03
 	 1.92151054529854037333791438868502e-01 2.55348328446881489561803846299881e-01 8.97739140547241729062299953056936e-03
 	 1.06854490883476538343188622093294e-01 2.82309228837349879270846031431574e-01 7.77608957719981824102672973708650e-03
 	 4.44464631554077893582643810077570e-02 3.02035423507016398403379753290210e-01 5.53702473073203107339912421025474e-03
 	 8.53905498842744137277804838959128e-03 3.13385189704906697016895122942515e-01 2.52929166111313724271680847266452e-03
 	 9.78437936834149701859075776155805e-01 4.44913816854213342577573087055498e-03 7.87458885347251181293509736391911e-05
 	 9.28942101264410902139445624925429e-01 1.46621595071486227057633300319139e-02 4.51520081062291333325736664150440e-04
 	 8.54552543764935834680329662660370e-01 3.00117768914469479346607272418623e-02 1.26329599052323331316582954997330e-03
 	 7.59598889525227027874620944203343e-01 4.96046110312490518001737882514135e-02 2.52707573045261087857360493558190e-03
 	 6.49600650277255109443785840994678e-01 7.23017602301106454554258107236819e-02 4.10922919516309298471057331880729e-03
 	 5.30950849312817885206072787696030e-01 9.67840815228553918991849513986381e-02 5.75104447210382507815751296220697e-03
 	 4.10545081201457717767766553151887e-01 1.21628730872799017959096090635285e-01 7.12196709828548293191863294282484e-03
 	 2.95380884262580245547269441885874e-01 1.45391829065636413176321184437256e-01 7.89268037663573736317790263683492e-03
 	 1.92151054529854037333791438868502e-01 1.66692377722009177354323128383840e-01 7.81144244512491873339010695076468e-03
 	 1.06854490883476538343188622093294e-01 1.84292557910963550327210214163642e-01 6.76616106360305221562034816429332e-03
 	 4.44464631554077893582643810077570e-02 1.97169894186842054040198490838520e-01 4.81789732092788303141617234359728e-03
 	 8.53905498842744137277804838959128e-03 2.04579065516149460890460431983229e-01 2.20079701834944999397358778026046e-03
 	 9.78437936834149701859075776155805e-01 2.48068653665782165584907659194869e-03 6.20449371221393057053428155001029e-05
 	 9.28942101264411013161748087441083e-01 8.17511623821547128709852358952048e-03 3.55758701313521217765578619207645e-04
 	 8.54552543764935834680329662660370e-01 1.67335353624646077097537499867030e-02 9.95367780555304025591478733758777e-04
 	 7.59598889525226916852318481687689e-01 2.76578263204824148502325442677829e-02 1.99111671372753261041732564251561e-03
 	 6.49600650277255109443785840994678e-01 4.03129766676291745319815618131543e-02 3.23771655610848941089785490987651e-03
 	 5.30950849312817885206072787696030e-01 5.39634776222766565645372338622110e-02 4.53132473704906998251962235713108e-03
 	 4.10545081201457717767766553151887e-01 6.78160002492790292549784680886660e-02 5.61149298104888279853375010475247e-03
 	 2.95380884262580245547269441885874e-01 8.10654871213770666926734520529862e-02 6.21874826490224127256700725752125e-03
 	 1.92151054529854037333791438868502e-01 9.29419410038159199416440969798714e-02 6.15473981384134869593305339208200e-03
 	 1.06854490883476538343188622093294e-01 1.02755196601539200429442644235678e-01 5.33114865501065245123601954446713e-03
 	 4.44464631554077893582643810077570e-02 1.09935156746057360876989150710870e-01 3.79608563571003955472438207152663e-03
 	 8.53905498842744137277804838959128e-03 1.14066256043975244871546692593256e-01 1.73403735944726352519174028543603e-03
 	 9.78437936834149701859075776155805e-01 1.03371488732742489169424970896216e-03 4.14487321153336282938094148331487e-05
 	 9.28942101264410902139445624925429e-01 3.40661314365861556119341457815608e-03 2.37662374923762286091019624301168e-04
 	 8.54552543764935834680329662660370e-01 6.97295057887661884343799556518206e-03 6.64949219164402520465539936367350e-04
 	 7.59598889525227027874620944203343e-01 1.15251590219528909919688430818496e-02 1.33015306495019836573179272676271e-03
 	 6.49600650277254998421483378479024e-01 1.67986255087091418403133502579294e-02 2.16293629140669116384110282069742e-03
 	 5.30950849312817885206072787696030e-01 2.24868597324928143343925057706656e-02 3.02712314437196972766175306901459e-03
 	 4.10545081201457717767766553151887e-01 2.82592774301615445864399589481764e-02 3.74872278266159993098671776579067e-03
 	 2.95380884262580245547269441885874e-01 3.37804070153568947176836445578374e-02 4.15439587628582424755352420220333e-03
 	 1.92151054529854037333791438868502e-01 3.87293866649480733599375525955111e-02 4.11163543096669005516563544233577e-03
 	 1.06854490883476538343188622093294e-01 4.28186209372406478834705012559425e-02 3.56144050937735358319802259075004e-03
 	 4.44464631554077893582643810077570e-02 4.58105473987779898692451752140187e-02 2.53595126209366691222291123608557e-03
 	 8.53905498842744137277804838959128e-03 4.75319978046155888762314134510234e-02 1.15841281051219961370501998487725e-03
 	 9.78437936834149701859075776155805e-01 1.98795384555229548428911812152364e-04 1.82847410167974257807869953307289e-05
 	 9.28942101264411013161748087441083e-01 6.55131292222554950654966887668706e-04 1.04842651467024880929286567710079e-04
 	 8.54552543764935834680329662660370e-01 1.34097942170133266337472832674393e-03 2.93336457865857368546014249943710e-04
 	 7.59598889525226916852318481687689e-01 2.21642200176960790791724775772309e-03 5.86785242010241315027685438110439e-04
 	 6.49600650277254998421483378479024e-01 3.23057088462475050505418039392680e-03 9.54160185507167799175143318990422e-04
 	 5.30950849312817774183770325180376e-01 4.32448442289334877841611159965396e-03 1.33538856066283870803468314392148e-03
 	 4.10545081201457717767766553151887e-01 5.43458742139835138118542090523988e-03 1.65371584911225971703530035483709e-03
 	 2.95380884262580245547269441885874e-01 6.49636479591786386578178280615248e-03 1.83267494088283438256892221573935e-03
 	 1.92151054529854037333791438868502e-01 7.44811108946308308986772317439318e-03 1.81381154920543115859066229944574e-03
 	 1.06854490883476538343188622093294e-01 8.23451835674993137814681176678278e-03 1.57109793321290477051410672260090e-03
 	 4.44464631554077893582643810077570e-02 8.80990058135933118421689869137481e-03 1.11871243563200226459053432392921e-03
 	 8.53905498842744137277804838959128e-03 9.14095549758098258052996243350208e-03 5.11023550052575850806413360061242e-04
 	 ];
 
 	 case  24 

 	 % ALG. DEG.:   24
 	 % PTS CARD.:  169
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.81389634989011994115060133481165e-01 1.84631854484650567704839829730190e-02 1.17010251986297939848615315416858e-05
 	 9.38524459100730901184306276263669e-01 6.09893632659945228446929377241759e-02 6.75750759083311913679587012993011e-05
 	 8.73694821306689517470545069954824e-01 1.25306297643234920702326462560450e-01 1.91265151829471256221884556403268e-04
 	 7.90157028273437589405148173682392e-01 2.08183434325818456089862706903659e-01 3.88928966708545380877998232094228e-04
 	 6.92101001719601649497803919075523e-01 3.05463987476396969800163105901447e-01 6.46464521831754154561344716256599e-04
 	 5.84443964021340578440799617965240e-01 4.12269622437441973783478488257970e-01 9.31046702036862280915663347968803e-04
 	 4.72584386004117895652143488405272e-01 5.23244562042314509398011068697087e-01 1.19671692362373566567712579455929e-03
 	 3.62131397282238864931969146709889e-01 6.32824036324802441377812556311255e-01 1.39296411185115985228999413436668e-03
 	 2.58623540705762433589143256540410e-01 7.35513303849445687632169210701250e-01 1.47462373044909529976043138788100e-03
 	 1.67251011391557513618977282021660e-01 8.26163216015457058105653231905308e-01 1.41114019107050942154757411373112e-03
 	 9.25952246990027205697515455540270e-02 9.00228589461483430511634651338682e-01 1.19334575258551165745368738413390e-03
 	 3.83981387396783446774861658923328e-02 9.53997059249292456151181340828771e-01 8.36405396888500606185357089117360e-04
 	 7.36465102608929722549646612606011e-03 9.84785119474352987900545031152433e-01 3.78823641346824418162098080387068e-04
 	 9.81389634989011994115060133481165e-01 1.78436030770129580580452000049263e-02 2.66257253249886626249223059437199e-05
 	 9.38524459100731012206608738779323e-01 5.89426994099024534334851921357767e-02 1.53767330589218591046715700620950e-04
 	 8.73694821306689628492847532470478e-01 1.21101304237932111407261004387692e-01 4.35224547456756257618470939974031e-04
 	 7.90157028273437589405148173682392e-01 2.01197273335524312587452300249424e-01 8.85009275915928528971621247478652e-04
 	 6.92101001719601871542408844106831e-01 2.95213313112424990958260195839102e-01 1.47103236669023128627142860125332e-03
 	 5.84443964021340578440799617965240e-01 3.98434794690061711008866041083820e-01 2.11860015104257471199589168975308e-03
 	 4.72584386004117895652143488405272e-01 5.05685668561853707281272818363504e-01 2.72313370489128334095418892957241e-03
 	 3.62131397282238864931969146709889e-01 6.11587905743088189325362691306509e-01 3.16969489426096630302343015728184e-03
 	 2.58623540705762433589143256540410e-01 7.10831155782114532115656402311288e-01 3.35551165288025098759616682286833e-03
 	 1.67251011391557513618977282021660e-01 7.98439063755051470216983489081031e-01 3.21105462852051696046040696330692e-03
 	 9.25952246990027205697515455540270e-02 8.70018972282239122506553030689247e-01 2.71546259295334709710223464185219e-03
 	 3.83981387396783446774861658923328e-02 9.21983094921314361158692918252200e-01 1.90324351754230717929938787591482e-03
 	 7.36465102608929722549646612606011e-03 9.51737978102256465540165208949475e-01 8.62014571363687079862125894891278e-04
 	 9.81389634989011994115060133481165e-01 1.67640129321728822975323680566362e-02 4.01383818602865969455903427665078e-05
 	 9.38524459100731012206608738779323e-01 5.53764938000512602078728718879574e-02 2.31804833764828613698605330739611e-04
 	 8.73694821306689628492847532470478e-01 1.13774321340011863590291341097327e-01 6.56102655141363672389176464605498e-04
 	 7.90157028273437589405148173682392e-01 1.89024250178472130734519396355608e-01 1.33415483833863998328062017151296e-03
 	 6.92101001719601760520106381591177e-01 2.77352044730349245327261087368242e-01 2.21758686917870049062906367964843e-03
 	 5.84443964021340578440799617965240e-01 3.74328324945567947334978953222162e-01 3.19379775889143575906548022658171e-03
 	 4.72584386004117895652143488405272e-01 4.75090207442818823757590962486574e-01 4.10513438298567255591020597194074e-03
 	 3.62131397282238864931969146709889e-01 5.74585049711494155744162526389118e-01 4.77832706878574334230513898091885e-03
 	 2.58623540705762433589143256540410e-01 6.67823793024966971820788330660434e-01 5.05844653679894933756555630566254e-03
 	 1.67251011391557513618977282021660e-01 7.50131166478646305151301021396648e-01 4.84067702496860079869334114732737e-03
 	 9.25952246990027205697515455540270e-02 8.17380281304529332508934658108046e-01 4.09357015265956331040442250923661e-03
 	 3.83981387396783446774861658923328e-02 8.66200422627483757054278612486087e-01 2.86914681751531709663627367490335e-03
 	 7.36465102608929722549646612606011e-03 8.94155048399405405490369957988150e-01 1.29949023405775249649651836847397e-03
 	 9.81389634989011994115060133481165e-01 1.52823603412698873910136043718921e-02 5.14892393184386432526504495665876e-05
 	 9.38524459100731123228911201294977e-01 5.04821569938260217291770004521823e-02 2.97357641432407398315168611802051e-04
 	 8.73694821306689517470545069954824e-01 1.03718613397426259736811005041091e-01 8.41643959281309218638245095434058e-04
 	 7.90157028273437589405148173682392e-01 1.72317733000658890318845806177706e-01 1.71144462171352127605183923719778e-03
 	 6.92101001719601649497803919075523e-01 2.52838858220077289384875030009425e-01 2.84470513569811149154342722056299e-03
 	 5.84443964021340578440799617965240e-01 3.41244090594998827903339133627014e-01 4.09698172972337067848647151890873e-03
 	 4.72584386004117951163294719663099e-01 4.33100342628329249006213785833097e-01 5.26603806340864358248587961952580e-03
 	 3.62131397282238864931969146709889e-01 5.23801539161623974649728552321903e-01 6.12960499610747978904701227520491e-03
 	 2.58623540705762433589143256540410e-01 6.08799569099254700432766185258515e-01 6.48894031701029161407490164492629e-03
 	 1.67251011391557513618977282021660e-01 6.83832375680343496071600384311751e-01 6.20958708971972028756169947882881e-03
 	 9.25952246990027205697515455540270e-02 7.45137816660301655069531534536509e-01 5.25120354853290255414677289991232e-03
 	 3.83981387396783446774861658923328e-02 7.89643090822745530310555750475032e-01 3.68052174203237648236752832531238e-03
 	 7.36465102608940824779892864171416e-03 8.15127004846216918210188850935083e-01 1.66697710650799300544089298625750e-03
 	 9.81389634989011994115060133481165e-01 1.34784894062792252877880372352593e-02 6.00647298360186191043194603444988e-05
 	 9.38524459100731012206608738779323e-01 4.45234376793178648901161409412452e-02 3.46882312377009801359489804539749e-04
 	 8.73694821306689628492847532470478e-01 9.14760678778116093079475490412733e-02 9.81819069411761155552476054708677e-04
 	 7.90157028273437589405148173682392e-01 1.51978011700935833339087821514113e-01 1.99648431775757998971054796299995e-03
 	 6.92101001719601760520106381591177e-01 2.22994733530270106136583763145609e-01 3.31848843953795472408452305046467e-03
 	 5.84443964021340578440799617965240e-01 3.00964952882264491496044911400531e-01 4.77933067173540691852107187287402e-03
 	 4.72584386004117840140992257147445e-01 3.81978846828235962806985526185599e-01 6.14309237758656461608763876824923e-03
 	 3.62131397282238920443120377967716e-01 4.61974023575212056069716481943033e-01 7.15048567363201457991461751362294e-03
 	 2.58623540705762433589143256540410e-01 5.36939213538385251567319755849894e-01 7.56966799708959272446895383268384e-03
 	 1.67251011391557513618977282021660e-01 6.03115436716130770555821527523221e-01 7.24378871924174008722907558421866e-03
 	 9.25952246990027205697515455540270e-02 6.57184619639675116076205085846595e-01 6.12578718644266051462921041093068e-03
 	 3.83981387396783446774861658923328e-02 6.96436662709365439383191187516786e-01 4.29350961515566256071485540246613e-03
 	 7.36465102608940824779892864171416e-03 7.18912553705621570898642858082894e-01 1.94461077441815399780011830443982e-03
 	 9.81389634989011994115060133481165e-01 1.14496391953653325890272185461072e-02 6.54022547826266589538618534405146e-05
 	 9.38524459100731012206608738779323e-01 3.78215452636727622603984855231829e-02 3.77707274062579563458225129224388e-04
 	 8.73694821306689517470545069954824e-01 7.77066287356915491590925171294657e-02 1.06906634065309863804160706024504e-03
 	 7.90157028273437589405148173682392e-01 1.29101514802843458928904851745756e-01 2.17389766633394607500684436729443e-03
 	 6.92101001719601871542408844106831e-01 1.89428441454185858550118837229093e-01 3.61337888322130727780656656022984e-03
 	 5.84443964021340578440799617965240e-01 2.55662190107646347669856368156616e-01 5.20403576502593591401879535851549e-03
 	 4.72584386004117895652143488405272e-01 3.24481464102908234714561785949627e-01 6.68898526521300145625259503390225e-03
 	 3.62131397282238920443120377967716e-01 3.92435363350375598923136521989363e-01 7.78589843196074004455509154354331e-03
 	 2.58623540705762378077992025282583e-01 4.56116414795984026486763696084381e-01 8.24233050439313573443111948790829e-03
 	 1.67251011391557513618977282021660e-01 5.12331459068242844878682262788061e-01 7.88749265502012783524143912927684e-03
 	 9.25952246990027205697515455540270e-02 5.58261875853256261947876737394836e-01 6.67014228492580820567559030109805e-03
 	 3.83981387396783446774861658923328e-02 5.91605503412849231814618633507052e-01 4.67504324965230082244982412476020e-03
 	 7.36465102608918620319400361040607e-03 6.10698209927987845091479357506614e-01 2.11741449047974771707769647832720e-03
 	 9.81389634989012105137362595996819e-01 9.30518250549400294246993325941730e-03 6.72139922942165709933426409605772e-05
 	 9.38524459100730901184306276263669e-01 3.07377704496344938966956306103384e-02 3.88170314505052553837732842723085e-04
 	 8.73694821306689517470545069954824e-01 6.31525893466552135091518493936746e-02 1.09868103204526575307486968569037e-03
 	 7.90157028273437589405148173682392e-01 1.04921485863281205297425913158804e-01 2.23411779118354346732044923840022e-03
 	 6.92101001719601871542408844106831e-01 1.53949499140199119739946809204412e-01 3.71347472988709957283925966464722e-03
 	 5.84443964021340578440799617965240e-01 2.07778017989329710779600191017380e-01 5.34819511914131576896247466379464e-03
 	 4.72584386004117895652143488405272e-01 2.63707806997941052173928255797364e-01 6.87427987867451992937128935068358e-03
 	 3.62131397282238864931969146709889e-01 3.18934301358880567534015426645055e-01 8.00157913436917375693546716775018e-03
 	 2.58623540705762433589143256540410e-01 3.70688229647118783205428371729795e-01 8.47065503857567271561723742934191e-03
 	 1.67251011391557513618977282021660e-01 4.16374494304221243190511358989170e-01 8.10598766506198144254913273698548e-03
 	 9.25952246990027205697515455540270e-02 4.53702387650498639715124227222987e-01 6.85491492044742328770823291961278e-03
 	 3.83981387396783446774861658923328e-02 4.80800930630160827661256917053834e-01 4.80454874226645192725193567184760e-03
 	 7.36465102608935273664769738388713e-03 4.96317674486955351387251766936970e-01 2.17606994926685401794963503618874e-03
 	 9.81389634989011994115060133481165e-01 7.16072581562267503063612394953452e-03 6.54022547826264421134273563396277e-05
 	 9.38524459100731012206608738779323e-01 2.36539956355962324718866796047223e-02 3.77707274062578316625726770894289e-04
 	 8.73694821306689517470545069954824e-01 4.85985499576188778592111816578836e-02 1.06906634065309495175422060952997e-03
 	 7.90157028273437589405148173682392e-01 8.07414569237189516659469745718525e-02 2.17389766633393870243207146586428e-03
 	 6.92101001719601760520106381591177e-01 1.18470556826212408685350396808644e-01 3.61337888322129513474223472258018e-03
 	 5.84443964021340578440799617965240e-01 1.59893845871013129400495245135971e-01 5.20403576502591856678403559044455e-03
 	 4.72584386004117951163294719663099e-01 2.02934149892973925144445956902928e-01 6.68898526521297890484740733541003e-03
 	 3.62131397282238864931969146709889e-01 2.45433239367385591656045562558575e-01 7.78589843196071402370295189143690e-03
 	 2.58623540705762433589143256540410e-01 2.85260044498253595435244278633036e-01 8.24233050439310971357897983580187e-03
 	 1.67251011391557513618977282021660e-01 3.20417529540199641502340455190279e-01 7.88749265502010181438929947717043e-03
 	 9.25952246990027205697515455540270e-02 3.49142899447741128504674179566791e-01 6.67014228492578652163214059100937e-03
 	 3.83981387396783446774861658923328e-02 3.69996357847472534530197663116269e-01 4.67504324965228520993854033349635e-03
 	 7.36465102608929722549646612606011e-03 3.81937139045922968705326638882980e-01 2.11741449047974077818379257109882e-03
 	 9.81389634989011994115060133481165e-01 5.13187560470877886242835330676826e-03 6.00647298360185648942108360692771e-05
 	 9.38524459100731012206608738779323e-01 1.69521032199511159643812163722032e-02 3.46882312377009476098838058888418e-04
 	 8.73694821306689628492847532470478e-01 3.48291108154988038325683419316192e-02 9.81819069411760288190738066305130e-04
 	 7.90157028273437589405148173682392e-01 5.78649600256265495001883891745820e-02 1.99648431775757825498707198619286e-03
 	 6.92101001719601760520106381591177e-01 8.49042647501281055877342396343010e-02 3.31848843953795168831844009105225e-03
 	 5.84443964021340578440799617965240e-01 1.14591083096394874552004239376402e-01 4.77933067173540258171238193085628e-03
 	 4.72584386004117895652143488405272e-01 1.45436767167646086029719754151301e-01 6.14309237758655854455547284942440e-03
 	 3.62131397282238864931969146709889e-01 1.75894579142549023487163140089251e-01 7.15048567363200764102071360639457e-03
 	 2.58623540705762433589143256540410e-01 2.04437245755852314843536987609696e-01 7.56966799708958578557504992545546e-03
 	 1.67251011391557513618977282021660e-01 2.29633551892311604802898727939464e-01 7.24378871924173314833517167699029e-03
 	 9.25952246990027205697515455540270e-02 2.50220155661322052331740906083724e-01 6.12578718644265444309704449210585e-03
 	 3.83981387396783446774861658923328e-02 2.65165198550956104917020184075227e-01 4.29350961515565909126790344885194e-03
 	 7.36465102608929722549646612606011e-03 2.73722795268289020853558213275392e-01 1.94461077441815226307664232763273e-03
 	 9.81389634989011994115060133481165e-01 3.32800466971812196337321410055665e-03 5.14892393184387313440769640138228e-05
 	 9.38524459100731012206608738779323e-01 1.09933839054429730031081646757229e-02 2.97357641432407940416254854554268e-04
 	 8.73694821306689517470545069954824e-01 2.25865652958841811592805015607155e-02 8.41643959281310628101069326589823e-04
 	 7.90157028273437589405148173682392e-01 3.75252387259035480315816357688163e-02 1.71144462171352409497748769950931e-03
 	 6.92101001719601760520106381591177e-01 5.50601400603210056061698196572252e-02 2.84470513569811626203298615678250e-03
 	 5.84443964021340578440799617965240e-01 7.43119453836606491670124796655728e-02 4.09698172972337761738037542613711e-03
 	 4.72584386004117895652143488405272e-01 9.43152713675529108527939570194576e-02 5.26603806340865312346499749196482e-03
 	 3.62131397282238864931969146709889e-01 1.14067063556137271440604763483861e-01 6.12960499610749019738786813604747e-03
 	 2.58623540705762433589143256540410e-01 1.32576890194982977000393020716729e-01 6.48894031701030288977749549417240e-03
 	 1.67251011391557513618977282021660e-01 1.48916612928099101331724796182243e-01 6.20958708971973156326429332807493e-03
 	 9.25952246990027205697515455540270e-02 1.62266958640695735383019382425118e-01 5.25120354853291122776415278394779e-03
 	 3.83981387396783446774861658923328e-02 1.71958770437576236034260546148289e-01 3.68052174203238298758056323833898e-03
 	 7.36465102608929722549646612606011e-03 1.77508344127693784564314682938857e-01 1.66697710650799604120697594566991e-03
 	 9.81389634989011994115060133481165e-01 1.84635207881512358740749846219842e-03 4.01383818602866443794353890073268e-05
 	 9.38524459100731012206608738779323e-01 6.09904709921772758551838933271938e-03 2.31804833764828911854202764253330e-04
 	 8.73694821306689517470545069954824e-01 1.25308573532985634280123576900223e-02 6.56102655141364431330697204458602e-04
 	 7.90157028273437589405148173682392e-01 2.08187215480902798603324299619999e-02 1.33415483833864171800409614832006e-03
 	 6.92101001719601760520106381591177e-01 3.05469535500489941526325310405809e-02 2.21758686917870309271427764485907e-03
 	 5.84443964021340578440799617965240e-01 4.12277110330914742242214288125979e-02 3.19379775889143966219330117439767e-03
 	 4.72584386004117895652143488405272e-01 5.23254065530632805902655491081532e-02 4.10513438298567776008063390236202e-03
 	 3.62131397282238864931969146709889e-01 6.32835530062669793238683269009925e-02 4.77832706878574941383730489974369e-03
 	 2.58623540705762433589143256540410e-01 7.35526662692705945900684127991553e-02 5.05844653679895540909772222448737e-03
 	 1.67251011391557513618977282021660e-01 8.26178221297961812297216965816915e-02 4.84067702496860600286376907774866e-03
 	 9.25952246990027205697515455540270e-02 9.00244939964679469213137963379268e-02 4.09357015265956764721311245125435e-03
 	 3.83981387396783446774861658923328e-02 9.54014386328378982682352216215804e-02 2.86914681751532056608322562851754e-03
 	 7.36465102608929722549646612606011e-03 9.84803005745052972841335758857895e-02 1.29949023405775401437955984818018e-03
 	 9.81389634989011994115060133481165e-01 7.66761933975044357447714560294116e-04 2.66257253249887100587673521845389e-05
 	 9.38524459100731012206608738779323e-01 2.53284148936652048211826127044333e-03 1.53767330589218889202313134134670e-04
 	 8.73694821306689628492847532470478e-01 5.20387445537828785546707877074368e-03 4.35224547456757070770100304102357e-04
 	 7.90157028273437589405148173682392e-01 8.64569839103804249624829481035704e-03 8.85009275915930155274879975735303e-04
 	 6.92101001719601871542408844106831e-01 1.26856851679731374993309600540670e-02 1.47103236669023410519707706356485e-03
 	 5.84443964021340578440799617965240e-01 1.71212412885975995280318784352858e-02 2.11860015104257861512371263756904e-03
 	 4.72584386004117895652143488405272e-01 2.17299454340282860442812307155691e-02 2.72313370489128854512461685999369e-03
 	 3.62131397282238864931969146709889e-01 2.62806969746728347203656994679477e-02 3.16969489426097194087472708190489e-03
 	 2.58623540705762433589143256540410e-01 3.05453035121229232728978786326479e-02 3.35551165288025705912833274169316e-03
 	 1.67251011391557513618977282021660e-01 3.43099248533907941194343038660008e-02 3.21105462852052303199257288213175e-03
 	 9.25952246990027205697515455540270e-02 3.73858030187580459013929612410720e-02 2.71546259295335186759179357807170e-03
 	 3.83981387396783446774861658923328e-02 3.96187663390070721192159908241592e-02 1.90324351754231064874633982952901e-03
 	 7.36465102608929722549646612606011e-03 4.08973708716540151897333998931572e-02 8.62014571363688706165384623147929e-04
 	 9.81389634989011994115060133481165e-01 1.47179562522949114455883545815595e-04 1.17010251986298414187065777825048e-05
 	 9.38524459100730901184306276263669e-01 4.86177633274464948698323496500961e-04 6.75750759083314488659746666066042e-05
 	 8.73694821306689628492847532470478e-01 9.98881050075506315977236226899549e-04 1.91265151829471988058350984118761e-04
 	 7.90157028273437589405148173682392e-01 1.65953740074395450498911941394908e-03 3.88928966708546898761039711800436e-04
 	 6.92101001719601871542408844106831e-01 2.43501080400126967973051250737626e-03 6.46464521831756648226341432916797e-04
 	 5.84443964021340578440799617965240e-01 3.28641354121744777572189377679024e-03 9.31046702036865967203049798683878e-04
 	 4.72584386004117895652143488405272e-01 4.17105195356759494984544289764017e-03 1.19671692362374021932625023367791e-03
 	 3.62131397282238864931969146709889e-01 5.04456639295869369021829697885551e-03 1.39296411185116549014129105898974e-03
 	 2.58623540705762433589143256540410e-01 5.86315544479187877868753275834024e-03 1.47462373044910115445216280960494e-03
 	 1.67251011391557513618977282021660e-01 6.58577259298542827536948607303202e-03 1.41114019107051505939887103835417e-03
 	 9.25952246990027205697515455540270e-02 7.17618583951384891861380310729146e-03 1.19334575258551642794324632035341e-03
 	 3.83981387396783446774861658923328e-02 7.60480201102919917133249327889644e-03 8.36405396888503967212091794181106e-04
 	 7.36465102608929722549646612606011e-03 7.85022949955771487395850272150710e-03 3.78823641346825881835030935818054e-04
 	 ];
 
 	 case  25 

 	 % ALG. DEG.:   25
 	 % PTS CARD.:  169
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.81389634989011994115060133481165e-01 1.84631854484650567704839829730190e-02 1.17010251986297939848615315416858e-05
 	 9.38524459100730901184306276263669e-01 6.09893632659945228446929377241759e-02 6.75750759083311913679587012993011e-05
 	 8.73694821306689517470545069954824e-01 1.25306297643234920702326462560450e-01 1.91265151829471256221884556403268e-04
 	 7.90157028273437589405148173682392e-01 2.08183434325818456089862706903659e-01 3.88928966708545380877998232094228e-04
 	 6.92101001719601649497803919075523e-01 3.05463987476396969800163105901447e-01 6.46464521831754154561344716256599e-04
 	 5.84443964021340578440799617965240e-01 4.12269622437441973783478488257970e-01 9.31046702036862280915663347968803e-04
 	 4.72584386004117895652143488405272e-01 5.23244562042314509398011068697087e-01 1.19671692362373566567712579455929e-03
 	 3.62131397282238864931969146709889e-01 6.32824036324802441377812556311255e-01 1.39296411185115985228999413436668e-03
 	 2.58623540705762433589143256540410e-01 7.35513303849445687632169210701250e-01 1.47462373044909529976043138788100e-03
 	 1.67251011391557513618977282021660e-01 8.26163216015457058105653231905308e-01 1.41114019107050942154757411373112e-03
 	 9.25952246990027205697515455540270e-02 9.00228589461483430511634651338682e-01 1.19334575258551165745368738413390e-03
 	 3.83981387396783446774861658923328e-02 9.53997059249292456151181340828771e-01 8.36405396888500606185357089117360e-04
 	 7.36465102608929722549646612606011e-03 9.84785119474352987900545031152433e-01 3.78823641346824418162098080387068e-04
 	 9.81389634989011994115060133481165e-01 1.78436030770129580580452000049263e-02 2.66257253249886626249223059437199e-05
 	 9.38524459100731012206608738779323e-01 5.89426994099024534334851921357767e-02 1.53767330589218591046715700620950e-04
 	 8.73694821306689628492847532470478e-01 1.21101304237932111407261004387692e-01 4.35224547456756257618470939974031e-04
 	 7.90157028273437589405148173682392e-01 2.01197273335524312587452300249424e-01 8.85009275915928528971621247478652e-04
 	 6.92101001719601871542408844106831e-01 2.95213313112424990958260195839102e-01 1.47103236669023128627142860125332e-03
 	 5.84443964021340578440799617965240e-01 3.98434794690061711008866041083820e-01 2.11860015104257471199589168975308e-03
 	 4.72584386004117895652143488405272e-01 5.05685668561853707281272818363504e-01 2.72313370489128334095418892957241e-03
 	 3.62131397282238864931969146709889e-01 6.11587905743088189325362691306509e-01 3.16969489426096630302343015728184e-03
 	 2.58623540705762433589143256540410e-01 7.10831155782114532115656402311288e-01 3.35551165288025098759616682286833e-03
 	 1.67251011391557513618977282021660e-01 7.98439063755051470216983489081031e-01 3.21105462852051696046040696330692e-03
 	 9.25952246990027205697515455540270e-02 8.70018972282239122506553030689247e-01 2.71546259295334709710223464185219e-03
 	 3.83981387396783446774861658923328e-02 9.21983094921314361158692918252200e-01 1.90324351754230717929938787591482e-03
 	 7.36465102608929722549646612606011e-03 9.51737978102256465540165208949475e-01 8.62014571363687079862125894891278e-04
 	 9.81389634989011994115060133481165e-01 1.67640129321728822975323680566362e-02 4.01383818602865969455903427665078e-05
 	 9.38524459100731012206608738779323e-01 5.53764938000512602078728718879574e-02 2.31804833764828613698605330739611e-04
 	 8.73694821306689628492847532470478e-01 1.13774321340011863590291341097327e-01 6.56102655141363672389176464605498e-04
 	 7.90157028273437589405148173682392e-01 1.89024250178472130734519396355608e-01 1.33415483833863998328062017151296e-03
 	 6.92101001719601760520106381591177e-01 2.77352044730349245327261087368242e-01 2.21758686917870049062906367964843e-03
 	 5.84443964021340578440799617965240e-01 3.74328324945567947334978953222162e-01 3.19379775889143575906548022658171e-03
 	 4.72584386004117895652143488405272e-01 4.75090207442818823757590962486574e-01 4.10513438298567255591020597194074e-03
 	 3.62131397282238864931969146709889e-01 5.74585049711494155744162526389118e-01 4.77832706878574334230513898091885e-03
 	 2.58623540705762433589143256540410e-01 6.67823793024966971820788330660434e-01 5.05844653679894933756555630566254e-03
 	 1.67251011391557513618977282021660e-01 7.50131166478646305151301021396648e-01 4.84067702496860079869334114732737e-03
 	 9.25952246990027205697515455540270e-02 8.17380281304529332508934658108046e-01 4.09357015265956331040442250923661e-03
 	 3.83981387396783446774861658923328e-02 8.66200422627483757054278612486087e-01 2.86914681751531709663627367490335e-03
 	 7.36465102608929722549646612606011e-03 8.94155048399405405490369957988150e-01 1.29949023405775249649651836847397e-03
 	 9.81389634989011994115060133481165e-01 1.52823603412698873910136043718921e-02 5.14892393184386432526504495665876e-05
 	 9.38524459100731123228911201294977e-01 5.04821569938260217291770004521823e-02 2.97357641432407398315168611802051e-04
 	 8.73694821306689517470545069954824e-01 1.03718613397426259736811005041091e-01 8.41643959281309218638245095434058e-04
 	 7.90157028273437589405148173682392e-01 1.72317733000658890318845806177706e-01 1.71144462171352127605183923719778e-03
 	 6.92101001719601649497803919075523e-01 2.52838858220077289384875030009425e-01 2.84470513569811149154342722056299e-03
 	 5.84443964021340578440799617965240e-01 3.41244090594998827903339133627014e-01 4.09698172972337067848647151890873e-03
 	 4.72584386004117951163294719663099e-01 4.33100342628329249006213785833097e-01 5.26603806340864358248587961952580e-03
 	 3.62131397282238864931969146709889e-01 5.23801539161623974649728552321903e-01 6.12960499610747978904701227520491e-03
 	 2.58623540705762433589143256540410e-01 6.08799569099254700432766185258515e-01 6.48894031701029161407490164492629e-03
 	 1.67251011391557513618977282021660e-01 6.83832375680343496071600384311751e-01 6.20958708971972028756169947882881e-03
 	 9.25952246990027205697515455540270e-02 7.45137816660301655069531534536509e-01 5.25120354853290255414677289991232e-03
 	 3.83981387396783446774861658923328e-02 7.89643090822745530310555750475032e-01 3.68052174203237648236752832531238e-03
 	 7.36465102608940824779892864171416e-03 8.15127004846216918210188850935083e-01 1.66697710650799300544089298625750e-03
 	 9.81389634989011994115060133481165e-01 1.34784894062792252877880372352593e-02 6.00647298360186191043194603444988e-05
 	 9.38524459100731012206608738779323e-01 4.45234376793178648901161409412452e-02 3.46882312377009801359489804539749e-04
 	 8.73694821306689628492847532470478e-01 9.14760678778116093079475490412733e-02 9.81819069411761155552476054708677e-04
 	 7.90157028273437589405148173682392e-01 1.51978011700935833339087821514113e-01 1.99648431775757998971054796299995e-03
 	 6.92101001719601760520106381591177e-01 2.22994733530270106136583763145609e-01 3.31848843953795472408452305046467e-03
 	 5.84443964021340578440799617965240e-01 3.00964952882264491496044911400531e-01 4.77933067173540691852107187287402e-03
 	 4.72584386004117840140992257147445e-01 3.81978846828235962806985526185599e-01 6.14309237758656461608763876824923e-03
 	 3.62131397282238920443120377967716e-01 4.61974023575212056069716481943033e-01 7.15048567363201457991461751362294e-03
 	 2.58623540705762433589143256540410e-01 5.36939213538385251567319755849894e-01 7.56966799708959272446895383268384e-03
 	 1.67251011391557513618977282021660e-01 6.03115436716130770555821527523221e-01 7.24378871924174008722907558421866e-03
 	 9.25952246990027205697515455540270e-02 6.57184619639675116076205085846595e-01 6.12578718644266051462921041093068e-03
 	 3.83981387396783446774861658923328e-02 6.96436662709365439383191187516786e-01 4.29350961515566256071485540246613e-03
 	 7.36465102608940824779892864171416e-03 7.18912553705621570898642858082894e-01 1.94461077441815399780011830443982e-03
 	 9.81389634989011994115060133481165e-01 1.14496391953653325890272185461072e-02 6.54022547826266589538618534405146e-05
 	 9.38524459100731012206608738779323e-01 3.78215452636727622603984855231829e-02 3.77707274062579563458225129224388e-04
 	 8.73694821306689517470545069954824e-01 7.77066287356915491590925171294657e-02 1.06906634065309863804160706024504e-03
 	 7.90157028273437589405148173682392e-01 1.29101514802843458928904851745756e-01 2.17389766633394607500684436729443e-03
 	 6.92101001719601871542408844106831e-01 1.89428441454185858550118837229093e-01 3.61337888322130727780656656022984e-03
 	 5.84443964021340578440799617965240e-01 2.55662190107646347669856368156616e-01 5.20403576502593591401879535851549e-03
 	 4.72584386004117895652143488405272e-01 3.24481464102908234714561785949627e-01 6.68898526521300145625259503390225e-03
 	 3.62131397282238920443120377967716e-01 3.92435363350375598923136521989363e-01 7.78589843196074004455509154354331e-03
 	 2.58623540705762378077992025282583e-01 4.56116414795984026486763696084381e-01 8.24233050439313573443111948790829e-03
 	 1.67251011391557513618977282021660e-01 5.12331459068242844878682262788061e-01 7.88749265502012783524143912927684e-03
 	 9.25952246990027205697515455540270e-02 5.58261875853256261947876737394836e-01 6.67014228492580820567559030109805e-03
 	 3.83981387396783446774861658923328e-02 5.91605503412849231814618633507052e-01 4.67504324965230082244982412476020e-03
 	 7.36465102608918620319400361040607e-03 6.10698209927987845091479357506614e-01 2.11741449047974771707769647832720e-03
 	 9.81389634989012105137362595996819e-01 9.30518250549400294246993325941730e-03 6.72139922942165709933426409605772e-05
 	 9.38524459100730901184306276263669e-01 3.07377704496344938966956306103384e-02 3.88170314505052553837732842723085e-04
 	 8.73694821306689517470545069954824e-01 6.31525893466552135091518493936746e-02 1.09868103204526575307486968569037e-03
 	 7.90157028273437589405148173682392e-01 1.04921485863281205297425913158804e-01 2.23411779118354346732044923840022e-03
 	 6.92101001719601871542408844106831e-01 1.53949499140199119739946809204412e-01 3.71347472988709957283925966464722e-03
 	 5.84443964021340578440799617965240e-01 2.07778017989329710779600191017380e-01 5.34819511914131576896247466379464e-03
 	 4.72584386004117895652143488405272e-01 2.63707806997941052173928255797364e-01 6.87427987867451992937128935068358e-03
 	 3.62131397282238864931969146709889e-01 3.18934301358880567534015426645055e-01 8.00157913436917375693546716775018e-03
 	 2.58623540705762433589143256540410e-01 3.70688229647118783205428371729795e-01 8.47065503857567271561723742934191e-03
 	 1.67251011391557513618977282021660e-01 4.16374494304221243190511358989170e-01 8.10598766506198144254913273698548e-03
 	 9.25952246990027205697515455540270e-02 4.53702387650498639715124227222987e-01 6.85491492044742328770823291961278e-03
 	 3.83981387396783446774861658923328e-02 4.80800930630160827661256917053834e-01 4.80454874226645192725193567184760e-03
 	 7.36465102608935273664769738388713e-03 4.96317674486955351387251766936970e-01 2.17606994926685401794963503618874e-03
 	 9.81389634989011994115060133481165e-01 7.16072581562267503063612394953452e-03 6.54022547826264421134273563396277e-05
 	 9.38524459100731012206608738779323e-01 2.36539956355962324718866796047223e-02 3.77707274062578316625726770894289e-04
 	 8.73694821306689517470545069954824e-01 4.85985499576188778592111816578836e-02 1.06906634065309495175422060952997e-03
 	 7.90157028273437589405148173682392e-01 8.07414569237189516659469745718525e-02 2.17389766633393870243207146586428e-03
 	 6.92101001719601760520106381591177e-01 1.18470556826212408685350396808644e-01 3.61337888322129513474223472258018e-03
 	 5.84443964021340578440799617965240e-01 1.59893845871013129400495245135971e-01 5.20403576502591856678403559044455e-03
 	 4.72584386004117951163294719663099e-01 2.02934149892973925144445956902928e-01 6.68898526521297890484740733541003e-03
 	 3.62131397282238864931969146709889e-01 2.45433239367385591656045562558575e-01 7.78589843196071402370295189143690e-03
 	 2.58623540705762433589143256540410e-01 2.85260044498253595435244278633036e-01 8.24233050439310971357897983580187e-03
 	 1.67251011391557513618977282021660e-01 3.20417529540199641502340455190279e-01 7.88749265502010181438929947717043e-03
 	 9.25952246990027205697515455540270e-02 3.49142899447741128504674179566791e-01 6.67014228492578652163214059100937e-03
 	 3.83981387396783446774861658923328e-02 3.69996357847472534530197663116269e-01 4.67504324965228520993854033349635e-03
 	 7.36465102608929722549646612606011e-03 3.81937139045922968705326638882980e-01 2.11741449047974077818379257109882e-03
 	 9.81389634989011994115060133481165e-01 5.13187560470877886242835330676826e-03 6.00647298360185648942108360692771e-05
 	 9.38524459100731012206608738779323e-01 1.69521032199511159643812163722032e-02 3.46882312377009476098838058888418e-04
 	 8.73694821306689628492847532470478e-01 3.48291108154988038325683419316192e-02 9.81819069411760288190738066305130e-04
 	 7.90157028273437589405148173682392e-01 5.78649600256265495001883891745820e-02 1.99648431775757825498707198619286e-03
 	 6.92101001719601760520106381591177e-01 8.49042647501281055877342396343010e-02 3.31848843953795168831844009105225e-03
 	 5.84443964021340578440799617965240e-01 1.14591083096394874552004239376402e-01 4.77933067173540258171238193085628e-03
 	 4.72584386004117895652143488405272e-01 1.45436767167646086029719754151301e-01 6.14309237758655854455547284942440e-03
 	 3.62131397282238864931969146709889e-01 1.75894579142549023487163140089251e-01 7.15048567363200764102071360639457e-03
 	 2.58623540705762433589143256540410e-01 2.04437245755852314843536987609696e-01 7.56966799708958578557504992545546e-03
 	 1.67251011391557513618977282021660e-01 2.29633551892311604802898727939464e-01 7.24378871924173314833517167699029e-03
 	 9.25952246990027205697515455540270e-02 2.50220155661322052331740906083724e-01 6.12578718644265444309704449210585e-03
 	 3.83981387396783446774861658923328e-02 2.65165198550956104917020184075227e-01 4.29350961515565909126790344885194e-03
 	 7.36465102608929722549646612606011e-03 2.73722795268289020853558213275392e-01 1.94461077441815226307664232763273e-03
 	 9.81389634989011994115060133481165e-01 3.32800466971812196337321410055665e-03 5.14892393184387313440769640138228e-05
 	 9.38524459100731012206608738779323e-01 1.09933839054429730031081646757229e-02 2.97357641432407940416254854554268e-04
 	 8.73694821306689517470545069954824e-01 2.25865652958841811592805015607155e-02 8.41643959281310628101069326589823e-04
 	 7.90157028273437589405148173682392e-01 3.75252387259035480315816357688163e-02 1.71144462171352409497748769950931e-03
 	 6.92101001719601760520106381591177e-01 5.50601400603210056061698196572252e-02 2.84470513569811626203298615678250e-03
 	 5.84443964021340578440799617965240e-01 7.43119453836606491670124796655728e-02 4.09698172972337761738037542613711e-03
 	 4.72584386004117895652143488405272e-01 9.43152713675529108527939570194576e-02 5.26603806340865312346499749196482e-03
 	 3.62131397282238864931969146709889e-01 1.14067063556137271440604763483861e-01 6.12960499610749019738786813604747e-03
 	 2.58623540705762433589143256540410e-01 1.32576890194982977000393020716729e-01 6.48894031701030288977749549417240e-03
 	 1.67251011391557513618977282021660e-01 1.48916612928099101331724796182243e-01 6.20958708971973156326429332807493e-03
 	 9.25952246990027205697515455540270e-02 1.62266958640695735383019382425118e-01 5.25120354853291122776415278394779e-03
 	 3.83981387396783446774861658923328e-02 1.71958770437576236034260546148289e-01 3.68052174203238298758056323833898e-03
 	 7.36465102608929722549646612606011e-03 1.77508344127693784564314682938857e-01 1.66697710650799604120697594566991e-03
 	 9.81389634989011994115060133481165e-01 1.84635207881512358740749846219842e-03 4.01383818602866443794353890073268e-05
 	 9.38524459100731012206608738779323e-01 6.09904709921772758551838933271938e-03 2.31804833764828911854202764253330e-04
 	 8.73694821306689517470545069954824e-01 1.25308573532985634280123576900223e-02 6.56102655141364431330697204458602e-04
 	 7.90157028273437589405148173682392e-01 2.08187215480902798603324299619999e-02 1.33415483833864171800409614832006e-03
 	 6.92101001719601760520106381591177e-01 3.05469535500489941526325310405809e-02 2.21758686917870309271427764485907e-03
 	 5.84443964021340578440799617965240e-01 4.12277110330914742242214288125979e-02 3.19379775889143966219330117439767e-03
 	 4.72584386004117895652143488405272e-01 5.23254065530632805902655491081532e-02 4.10513438298567776008063390236202e-03
 	 3.62131397282238864931969146709889e-01 6.32835530062669793238683269009925e-02 4.77832706878574941383730489974369e-03
 	 2.58623540705762433589143256540410e-01 7.35526662692705945900684127991553e-02 5.05844653679895540909772222448737e-03
 	 1.67251011391557513618977282021660e-01 8.26178221297961812297216965816915e-02 4.84067702496860600286376907774866e-03
 	 9.25952246990027205697515455540270e-02 9.00244939964679469213137963379268e-02 4.09357015265956764721311245125435e-03
 	 3.83981387396783446774861658923328e-02 9.54014386328378982682352216215804e-02 2.86914681751532056608322562851754e-03
 	 7.36465102608929722549646612606011e-03 9.84803005745052972841335758857895e-02 1.29949023405775401437955984818018e-03
 	 9.81389634989011994115060133481165e-01 7.66761933975044357447714560294116e-04 2.66257253249887100587673521845389e-05
 	 9.38524459100731012206608738779323e-01 2.53284148936652048211826127044333e-03 1.53767330589218889202313134134670e-04
 	 8.73694821306689628492847532470478e-01 5.20387445537828785546707877074368e-03 4.35224547456757070770100304102357e-04
 	 7.90157028273437589405148173682392e-01 8.64569839103804249624829481035704e-03 8.85009275915930155274879975735303e-04
 	 6.92101001719601871542408844106831e-01 1.26856851679731374993309600540670e-02 1.47103236669023410519707706356485e-03
 	 5.84443964021340578440799617965240e-01 1.71212412885975995280318784352858e-02 2.11860015104257861512371263756904e-03
 	 4.72584386004117895652143488405272e-01 2.17299454340282860442812307155691e-02 2.72313370489128854512461685999369e-03
 	 3.62131397282238864931969146709889e-01 2.62806969746728347203656994679477e-02 3.16969489426097194087472708190489e-03
 	 2.58623540705762433589143256540410e-01 3.05453035121229232728978786326479e-02 3.35551165288025705912833274169316e-03
 	 1.67251011391557513618977282021660e-01 3.43099248533907941194343038660008e-02 3.21105462852052303199257288213175e-03
 	 9.25952246990027205697515455540270e-02 3.73858030187580459013929612410720e-02 2.71546259295335186759179357807170e-03
 	 3.83981387396783446774861658923328e-02 3.96187663390070721192159908241592e-02 1.90324351754231064874633982952901e-03
 	 7.36465102608929722549646612606011e-03 4.08973708716540151897333998931572e-02 8.62014571363688706165384623147929e-04
 	 9.81389634989011994115060133481165e-01 1.47179562522949114455883545815595e-04 1.17010251986298414187065777825048e-05
 	 9.38524459100730901184306276263669e-01 4.86177633274464948698323496500961e-04 6.75750759083314488659746666066042e-05
 	 8.73694821306689628492847532470478e-01 9.98881050075506315977236226899549e-04 1.91265151829471988058350984118761e-04
 	 7.90157028273437589405148173682392e-01 1.65953740074395450498911941394908e-03 3.88928966708546898761039711800436e-04
 	 6.92101001719601871542408844106831e-01 2.43501080400126967973051250737626e-03 6.46464521831756648226341432916797e-04
 	 5.84443964021340578440799617965240e-01 3.28641354121744777572189377679024e-03 9.31046702036865967203049798683878e-04
 	 4.72584386004117895652143488405272e-01 4.17105195356759494984544289764017e-03 1.19671692362374021932625023367791e-03
 	 3.62131397282238864931969146709889e-01 5.04456639295869369021829697885551e-03 1.39296411185116549014129105898974e-03
 	 2.58623540705762433589143256540410e-01 5.86315544479187877868753275834024e-03 1.47462373044910115445216280960494e-03
 	 1.67251011391557513618977282021660e-01 6.58577259298542827536948607303202e-03 1.41114019107051505939887103835417e-03
 	 9.25952246990027205697515455540270e-02 7.17618583951384891861380310729146e-03 1.19334575258551642794324632035341e-03
 	 3.83981387396783446774861658923328e-02 7.60480201102919917133249327889644e-03 8.36405396888503967212091794181106e-04
 	 7.36465102608929722549646612606011e-03 7.85022949955771487395850272150710e-03 3.78823641346825881835030935818054e-04
 	 ];
 
 	 case  26 

 	 % ALG. DEG.:   26
 	 % PTS CARD.:  196
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.83775234098600237508946975140134e-01 1.61134949049231875062293539713210e-02 7.72125407583672248104395691159496e-06
 	 9.46302700060275281401800384628586e-01 5.33290387205057545005892905010114e-02 4.48493299549038639960525653993528e-05
 	 8.89342808819515551199685887695523e-01 1.09898293578831962591380033700261e-01 1.28124292538810607760754733952524e-04
 	 8.15389739443474703683989446290070e-01 1.83344185731363018554418431449449e-01 2.63963197514877697009982870923750e-04
 	 7.27676452889264746559661034552846e-01 2.70455926176468575139466565815383e-01 4.46429192431020043299594313168654e-04
 	 6.30036688370404052150774987239856e-01 3.67426067850859738861402092879871e-01 6.57490670394665719517002244742798e-04
 	 5.26737861339873214561180247983430e-01 4.70016461644917726836467863904545e-01 8.69548259388823723686767763751959e-04
 	 4.22294657307570209248126502643572e-01 5.73743384193808214632781528052874e-01 1.04981828425172209195981309903800e-03
 	 3.21271743988936209213136407925049e-01 6.74073472709900367583202296373202e-01 1.16583176207230303396411574823333e-03
 	 2.28084270649258069596498899045400e-01 7.66621857443884668903422152652638e-01 1.19110563935301261816179785313352e-03
 	 1.46804867681213702113041108532343e-01 8.47343838491869671969425326096825e-01 1.11000367205385530589012432756135e-03
 	 8.09854996819552308551237729261629e-02 9.12711810969661807568797939893557e-01 9.20936791785743977950540184451711e-04
 	 3.35014045320132236582821860793047e-02 9.59870255653136106310796549223596e-01 6.37349336733174709132554447421626e-04
 	 6.41676079281838784851288437494077e-03 9.86769150314878218388514596881578e-01 2.86693400389354891358295596148764e-04
 	 9.83775234098600348531249437655788e-01 1.56442022717672296616697735771595e-02 1.76233048955477846473673120275549e-05
 	 9.46302700060275281401800384628586e-01 5.17758731811555211743680615654739e-02 1.02365938019031359022814609005536e-04
 	 8.89342808819515662221988350211177e-01 1.06697593800337664493582678915118e-01 2.92436105554929519443480012697023e-04
 	 8.15389739443474592661686983774416e-01 1.78004433169712483753244214312872e-01 6.02480356858906104973450101880417e-04
 	 7.27676452889264746559661034552846e-01 2.62579113945671294150230323793949e-01 1.01894817800468042920392086614356e-03
 	 6.30036688370404052150774987239856e-01 3.56725077911105081795994919957593e-01 1.50068349474533416221255777145416e-03
 	 5.26737861339873214561180247983430e-01 4.56327608654707783664150611002697e-01 1.98469237588732964894244759079811e-03
 	 4.22294657307570209248126502643572e-01 5.57033567663450357443366556253750e-01 2.39614802551152156900871048605950e-03
 	 3.21271743988936209213136407925049e-01 6.54441622709937886881448321219068e-01 2.66094191411353746951062859693593e-03
 	 2.28084270649258069596498899045400e-01 7.44294609864290190870406149770133e-01 2.71862804137160650463922451081089e-03
 	 1.46804867681213702113041108532343e-01 8.22665627867752879964768908394035e-01 2.53351760680960071819844969809310e-03
 	 8.09854996819552308551237729261629e-02 8.86129810502982895314971756306477e-01 2.10198365599165897313338469132304e-03
 	 3.35014045320132236582821860793047e-02 9.31914803256157053823471869691275e-01 1.45471209416285171024674216511130e-03
 	 6.41676079281838784851288437494077e-03 9.58030289155288872215976425650297e-01 6.54360698013352402695186338377198e-04
 	 9.83775234098600348531249437655788e-01 1.48229567958683139394793215615209e-02 2.67166906994156574668523862481351e-05
 	 9.46302700060275281401800384628586e-01 4.90578885327803138061142362857936e-02 1.55185370758746470597200239893709e-04
 	 8.89342808819515551199685887695523e-01 1.01096482623453803872948242315033e-01 4.43329161457481130039631755934693e-04
 	 8.15389739443474592661686983774416e-01 1.68660055432127559127408744643617e-01 9.13352032554314041158660675279179e-04
 	 7.27676452889264746559661034552846e-01 2.48794971702599398977184819159447e-01 1.54471158910503563073401966931897e-03
 	 6.30036688370404052150774987239856e-01 3.37998724768581559896318822211470e-01 2.27501578191262624970003791702311e-03
 	 5.26737861339873214561180247983430e-01 4.32372601066256634361195665405830e-01 3.00876666745213388470814308561785e-03
 	 4.22294657307570209248126502643572e-01 5.27791980945218508480820673867129e-01 3.63252784009766805858876459467410e-03
 	 3.21271743988936209213136407925049e-01 6.20086580979211987596499966457486e-01 4.03395177634601701660566064333580e-03
 	 2.28084270649258069596498899045400e-01 7.05222717896356376954258848854806e-01 4.12140316124433563754747567031700e-03
 	 1.46804867681213702113041108532343e-01 7.79479633892004364348338185664034e-01 3.84077825832519325482961036755114e-03
 	 8.09854996819552308551237729261629e-02 8.39612251774657258884815291821724e-01 3.18657865395856679247010845301702e-03
 	 3.35014045320132236582821860793047e-02 8.82993752326093228610659480182221e-01 2.20532376343705611293488644264471e-03
 	 6.41676079281838784851288437494077e-03 9.07738300655319685361632764397655e-01 9.92001924627263160019752241680635e-04
 	 9.83775234098600237508946975140134e-01 1.36879661938311466412576677953439e-02 3.45621938289640946934469512008548e-05
 	 9.46302700060275281401800384628586e-01 4.53015365979212297764533445842972e-02 2.00756408191706279880647811886263e-04
 	 8.89342808819515551199685887695523e-01 9.33555467726108062498369122295117e-02 5.73515207430264181871770734488791e-04
 	 8.15389739443474592661686983774416e-01 1.55745791396230875980322139184864e-01 1.18156287911477591787146046442558e-03
 	 7.27676452889264635537358572037192e-01 2.29744794426547271903871205722680e-01 1.99832464107027639801938967423212e-03
 	 6.30036688370404052150774987239856e-01 3.12118235376625863253252646245528e-01 2.94308667578115339819033735579978e-03
 	 5.26737861339873214561180247983430e-01 3.99265924338617961275588186254026e-01 3.89230754349682373308128013889018e-03
 	 4.22294657307570153736975271385745e-01 4.87379062898370019052407542403671e-01 4.69923961433254405717363511030271e-03
 	 3.21271743988936209213136407925049e-01 5.72606685331338516320442977303173e-01 5.21854389674895110390329122651565e-03
 	 2.28084270649258069596498899045400e-01 6.51223966623022065824955006974051e-01 5.33167586168700139565013174092201e-03
 	 1.46804867681213702113041108532343e-01 7.19795046590677611852981954143615e-01 4.96864391296822707766445148536150e-03
 	 8.09854996819552308551237729261629e-02 7.75323322902846667759035881317686e-01 4.12233499756630913934962734401779e-03
 	 3.35014045320132236582821860793047e-02 8.15383111321796638648606858623680e-01 2.85292921286838755540182788195125e-03
 	 6.41676079281838784851288437494077e-03 8.38232974927044516277874208753929e-01 1.28330874446298034280422584174630e-03
 	 9.83775234098600237508946975140134e-01 1.22922772036630923581101981767461e-02 4.07918884350139823529411697844438e-05
 	 9.46302700060275281401800384628586e-01 4.06823802548913343590797353499511e-02 2.36941932740027637327440146464141e-04
 	 8.89342808819515551199685887695523e-01 8.38365790197263122118798150950170e-02 6.76888986649735167368258093034683e-04
 	 8.15389739443474592661686983774416e-01 1.39865222782999287787220055179205e-01 1.39453477352506540615229013724274e-03
 	 7.27676452889264635537358572037192e-01 2.06318941703878655502535366395023e-01 2.35851451498908688819700074645880e-03
 	 6.30036688370404052150774987239856e-01 2.80293201724646057204637372706202e-01 3.47356605680604335617545075365342e-03
 	 5.26737861339873214561180247983430e-01 3.58554905122350386914575892660650e-01 4.59388011810836494053233991508023e-03
 	 4.22294657307570153736975271385745e-01 4.37683616365762195865585226783878e-01 5.54625840668160601659719688427685e-03
 	 3.21271743988936209213136407925049e-01 5.14221032189256299638202563073719e-01 6.15916516997863996984996504124865e-03
 	 2.28084270649258069596498899045400e-01 5.84822128141060826322927823639475e-01 6.29268871061451975923439761118061e-03
 	 1.46804867681213702113041108532343e-01 6.46401380396727898158815150964074e-01 5.86422173239649346943025420841877e-03
 	 8.09854996819552308551237729261629e-02 6.96267734200143872946853207395179e-01 4.86536908347402156232996972562432e-03
 	 3.35014045320132236582821860793047e-02 7.32242839412469148641093852347694e-01 3.36715807857060388588732458003960e-03
 	 6.41676079281838784851288437494077e-03 7.52762824158499821436407728469931e-01 1.51461991651531593244817130994306e-03
 	 9.83775234098600348531249437655788e-01 1.07011446917479081941682039769148e-02 4.51142887560547001853800130888317e-05
 	 9.46302700060275281401800384628586e-01 3.54163862642608573416680428636028e-02 2.62048833289020436168592631531737e-04
 	 8.89342808819515551199685887695523e-01 7.29846347984976218103980727391900e-02 7.48613667351018382753458091372067e-04
 	 8.15389739443474703683989446290070e-01 1.21760839065556569771331396623282e-01 1.54230281722301880951986330359205e-03
 	 7.27676452889264635537358572037192e-01 1.79612679672043973333472877129680e-01 2.60842802200921203628625200110491e-03
 	 6.30036688370404052150774987239856e-01 2.44011590210061718453360413150222e-01 3.84163293517608478086500234383038e-03
 	 5.26737861339873214561180247983430e-01 3.12142970425919652477375620946987e-01 5.08065799623891312108980855555274e-03
 	 4.22294657307570209248126502643572e-01 3.81029131570654766569816729315789e-01 6.13395243207117031591923961286739e-03
 	 3.21271743988936209213136407925049e-01 4.47659418822524801662154914083658e-01 6.81180417565916632854916556993885e-03
 	 2.28084270649258069596498899045400e-01 5.09121793178278547742365844896995e-01 6.95947617122207127376976032451239e-03
 	 1.46804867681213702113041108532343e-01 5.62730126075389303075269253895385e-01 6.48560786751367461533401836959456e-03
 	 8.09854996819552308551237729261629e-02 6.06141697296808557027247843507212e-01 5.38091454349588250993807747590836e-03
 	 3.35014045320132236582821860793047e-02 6.37460125916627151632098957634298e-01 3.72394972804265290966529988736511e-03
 	 6.41676079281827682621042185928673e-03 6.55323970198815830556782202620525e-01 1.67511245227595462030378836715272e-03
 	 9.83775234098600237508946975140134e-01 8.98896607433205541148879547108663e-03 4.73272336827446052820618505041494e-05
 	 9.46302700060275281401800384628586e-01 2.97497794652172575791126973854261e-02 2.74902845890385451842197195304607e-04
 	 8.89342808819515551199685887695523e-01 6.13071241487952028892394196191162e-02 7.85334645624067824790093261810853e-04
 	 8.15389739443474703683989446290070e-01 1.02279156395905013177127784729237e-01 1.61795581517336730693890078924824e-03
 	 7.27676452889264524515056109521538e-01 1.50874727012793863334394472985878e-01 2.73637656596506431000426218247412e-03
 	 6.30036688370404052150774987239856e-01 2.04969839145665438939758473679831e-01 4.03007261467700200058272841374674e-03
 	 5.26737861339873214561180247983430e-01 2.62200227389087214824314742145361e-01 5.32987430102914439000727497841581e-03
 	 4.22294657307570209248126502643572e-01 3.20064631932509335854319942882285e-01 6.43483490831961522232740335880408e-03
 	 3.21271743988936209213136407925049e-01 3.76034101450282043366257767047500e-01 7.14593661812412683786988054635003e-03
 	 2.28084270649258069596498899045400e-01 4.27662521946064022593247955228435e-01 7.30085221659878668559739978149992e-03
 	 1.46804867681213757624192339790170e-01 4.72693544289423950299777743566665e-01 6.80373973709764035683322802583461e-03
 	 8.09854996819552308551237729261629e-02 5.09159282505608046243139597208938e-01 5.64485902468606949577978326715311e-03
 	 3.35014045320132236582821860793047e-02 5.35466775813499884506541093287524e-01 3.90661681390720109258163361687366e-03
 	 6.41676079281849887081534689059481e-03 5.50472412578094871804523791070096e-01 1.75728002501424084881576082040056e-03
 	 9.83775234098600237508946975140134e-01 7.23579982706764983368952215414538e-03 4.73272336827446730446976308481766e-05
 	 9.46302700060275281401800384628586e-01 2.39475204745074506107460621251448e-02 2.74902845890385831312957565231159e-04
 	 8.89342808819515551199685887695523e-01 4.93500670316892250943929809636757e-02 7.85334645624068908992265747315287e-04
 	 8.15389739443474703683989446290070e-01 8.23311041606203108944583846096066e-02 1.61795581517336947534324576025710e-03
 	 7.27676452889264635537358572037192e-01 1.21448820097941445617095723719103e-01 2.73637656596506821313208313029008e-03
 	 6.30036688370404052150774987239856e-01 1.64993472483930425642739692193572e-01 4.03007261467700807211489433257157e-03
 	 5.26737861339873214561180247983430e-01 2.11061911271039459592202547355555e-01 5.32987430102915219626291687404773e-03
 	 4.22294657307570264759277733901399e-01 2.57640710759920399386402323216316e-01 6.43483490831962476330652123124310e-03
 	 3.21271743988936209213136407925049e-01 3.02694154560781636398303362511797e-01 7.14593661812413724621073640719260e-03
 	 2.28084270649258069596498899045400e-01 3.44253207404677796787950683210511e-01 7.30085221659879709393825564234248e-03
 	 1.46804867681213702113041108532343e-01 3.80501588029362181053727454127511e-01 6.80373973709764989781234589827363e-03
 	 8.09854996819552308551237729261629e-02 4.09855217812436611879434167349245e-01 5.64485902468607730203542516278503e-03
 	 3.35014045320132236582821860793047e-02 4.31031819654486780812874258117517e-01 3.90661681390720629675206154729494e-03
 	 6.41676079281838784851288437494077e-03 4.43110826629086518302358399523655e-01 1.75728002501424323406054028851031e-03
 	 9.83775234098600348531249437655788e-01 5.52362120965179705101011364831720e-03 4.51142887560544968974726720567503e-05
 	 9.46302700060275281401800384628586e-01 1.82809136754638543176376686005824e-02 2.62048833289019243546202897476860e-04
 	 8.89342808819515551199685887695523e-01 3.76725563819868131121282317508303e-02 7.48613667351015021726723386308322e-04
 	 8.15389739443474703683989446290070e-01 6.28494214909687543002547727155616e-02 1.54230281722301187062595939636367e-03
 	 7.27676452889264635537358572037192e-01 9.27108674386913633735929352042149e-02 2.60842802200920032690278915765703e-03
 	 6.30036688370404052150774987239856e-01 1.25951721419534173884713368352095e-01 3.84163293517606743363024257575944e-03
 	 5.26737861339873214561180247983430e-01 1.61119168234207077450292899811757e-01 5.08065799623889056968462085706051e-03
 	 4.22294657307570153736975271385745e-01 1.96676211121774968670905536782811e-01 6.13395243207114256034362398395388e-03
 	 3.21271743988936209213136407925049e-01 2.31068837188538878102406215475639e-01 6.81180417565913597088833597581470e-03
 	 2.28084270649258069596498899045400e-01 2.62793936172463271638832793541951e-01 6.95947617122204004874719274198469e-03
 	 1.46804867681213702113041108532343e-01 2.90465006243396883789387175056618e-01 6.48560786751364599239666475227750e-03
 	 8.09854996819552308551237729261629e-02 3.12872803021236212117628383566625e-01 5.38091454349585822380941380060904e-03
 	 3.35014045320132236582821860793047e-02 3.29038469551359513687316393770743e-01 3.72394972804263599611140911349594e-03
 	 6.41676079281838784851288437494077e-03 3.38259269008365670572402450488880e-01 1.67511245227594724772901546572257e-03
 	 9.83775234098600237508946975140134e-01 3.93248869773661288706811944848596e-03 4.07918884350140501155769501284709e-05
 	 9.46302700060275281401800384628586e-01 1.30149196848333773002259761142341e-02 2.36941932740028071008309140665915e-04
 	 8.89342808819515551199685887695523e-01 2.68206121607581227106464893950033e-02 6.76888986649736468410865075640004e-04
 	 8.15389739443474592661686983774416e-01 4.47450377735260640399417297885520e-02 1.39453477352506779139706960535250e-03
 	 7.27676452889264635537358572037192e-01 6.60046054068566812045304459388717e-02 2.35851451498909122500569068847653e-03
 	 6.30036688370404052150774987239856e-01 8.96701099049498906445876400539419e-02 3.47356605680604942770761667247825e-03
 	 5.26737861339873214561180247983430e-01 1.14707233537776343013092628098093e-01 4.59388011810837274678798181071215e-03
 	 4.22294657307570209248126502643572e-01 1.40021726326667539375137039314723e-01 5.54625840668161642493805274511942e-03
 	 3.21271743988936209213136407925049e-01 1.64507223821807491148661029001232e-01 6.15916516997865037819082090209122e-03
 	 2.28084270649258069596498899045400e-01 1.87093601209680993058270814799471e-01 6.29268871061453103493699146042673e-03
 	 1.46804867681213702113041108532343e-01 2.06793751922058288705841277987929e-01 5.86422173239650474513284805766489e-03
 	 8.09854996819552308551237729261629e-02 2.22746766117900785175720557163004e-01 4.86536908347403023594734960965980e-03
 	 3.35014045320132236582821860793047e-02 2.34255756055517627700623961573001e-01 3.36715807857060995741949049886443e-03
 	 6.41676079281838784851288437494077e-03 2.40820415048681679692776924639475e-01 1.51461991651531875137381977225459e-03
 	 9.83775234098600237508946975140134e-01 2.53679970756856033864412580669523e-03 3.45621938289640946934469512008548e-05
 	 9.46302700060275281401800384628586e-01 8.39576334180348882174627078711637e-03 2.00756408191706279880647811886263e-04
 	 8.89342808819515551199685887695523e-01 1.73016444078736425504772000749654e-02 5.73515207430264181871770734488791e-04
 	 8.15389739443474592661686983774416e-01 2.88644691602944758468396457828931e-02 1.18156287911477591787146046442558e-03
 	 7.27676452889264635537358572037192e-01 4.25787526841880925587702222401276e-02 1.99832464107027639801938967423212e-03
 	 6.30036688370404052150774987239856e-01 5.78450762529700845959723665146157e-02 2.94308667578115339819033735579978e-03
 	 5.26737861339873214561180247983430e-01 7.39962143215088241632315657625441e-02 3.89230754349682373308128013889018e-03
 	 4.22294657307570153736975271385745e-01 9.03262797940597716994659549527569e-02 4.69923961433254405717363511030271e-03
 	 3.21271743988936209213136407925049e-01 1.06121570679725274466420614771778e-01 5.21854389674895110390329122651565e-03
 	 2.28084270649258069596498899045400e-01 1.20691762727719864578546093980549e-01 5.33167586168700139565013174092201e-03
 	 1.46804867681213702113041108532343e-01 1.33400085728108686033976937324042e-01 4.96864391296822707766445148536150e-03
 	 8.09854996819552308551237729261629e-02 1.43691177415198101385840345756151e-01 4.12233499756630913934962734401779e-03
 	 3.35014045320132236582821860793047e-02 1.51115484146190026670808492781362e-01 2.85292921286838755540182788195125e-03
 	 6.41676079281838784851288437494077e-03 1.55350264280137095873612906871131e-01 1.28330874446298034280422584174630e-03
 	 9.83775234098600237508946975140134e-01 1.40180910553139650986942399413238e-03 2.67166906994155490466351376976917e-05
 	 9.46302700060275281401800384628586e-01 4.63941140694441173097928299284831e-03 1.55185370758745847180951060728660e-04
 	 8.89342808819515662221988350211177e-01 9.56070855703067268294148561835755e-03 4.43329161457479341106047154852376e-04
 	 8.15389739443474592661686983774416e-01 1.59502051243978204553286559530534e-02 9.13352032554310246451056976013660e-04
 	 7.27676452889264635537358572037192e-01 2.35285754081360209966078400611877e-02 1.54471158910502934236141925339325e-03
 	 6.30036688370404052150774987239856e-01 3.19645868610144989752086530643282e-02 2.27501578191261670872092004458409e-03
 	 5.26737861339873214561180247983430e-01 4.08895375938702620999265491263941e-02 3.00876666745212174164381124796819e-03
 	 4.22294657307570209248126502643572e-01 4.99133617472113932933552860049531e-02 3.63252784009765331343921879181380e-03
 	 3.21271743988936209213136407925049e-01 5.86416750318519142126660881331190e-02 4.03395177634600053673263886366840e-03
 	 2.28084270649258069596498899045400e-01 6.66930114543857754938471771311015e-02 4.12140316124431829031271590224605e-03
 	 1.46804867681213702113041108532343e-01 7.37154984267821555832256308349315e-02 3.84077825832517764231832657628729e-03
 	 8.09854996819552308551237729261629e-02 7.94022485433877323046658602834214e-02 3.18657865395855378204403862696381e-03
 	 3.35014045320132236582821860793047e-02 8.35048431418937697756632587697823e-02 2.20532376343704700563663756440747e-03
 	 6.41676079281838784851288437494077e-03 8.58449385518621488344592762587126e-02 9.92001924627259040051496796763786e-04
 	 9.83775234098600348531249437655788e-01 5.80563629632477318232020024879603e-04 1.76233048955480184284607542144485e-05
 	 9.46302700060275281401800384628586e-01 1.92142675856919048493764989871124e-03 1.02365938019032714275530215886079e-04
 	 8.89342808819515551199685887695523e-01 3.95959738014677042894362557490240e-03 2.92436105554933368361192336237764e-04
 	 8.15389739443474592661686983774416e-01 6.60582738681286807391757065488491e-03 6.02480356858914019649309246062785e-04
 	 7.27676452889264635537358572037192e-01 9.74443316506401480125987291103229e-03 1.01894817800469365647042518929766e-03
 	 6.30036688370404052150774987239856e-01 1.32382337184908105420788615447236e-02 1.50068349474535389469209700763486e-03
 	 5.26737861339873214561180247983430e-01 1.69345300054189462635179097560467e-02 1.98469237588735566979458724290453e-03
 	 4.22294657307570209248126502643572e-01 2.06717750289794333085069411026780e-02 2.39614802551155279403127806858720e-03
 	 3.21271743988936209213136407925049e-01 2.42866333011257928831128083402291e-02 2.66094191411357216398014813307782e-03
 	 2.28084270649258069596498899045400e-01 2.76211194864516285107924886688124e-02 2.71862804137164250015135102955810e-03
 	 1.46804867681213702113041108532343e-01 3.05295044510333068998875205579679e-02 2.53351760680963411162536225162967e-03
 	 8.09854996819552308551237729261629e-02 3.28846898150617628076020082517061e-02 2.10198365599168672870900032023656e-03
 	 3.35014045320132236582821860793047e-02 3.45837922118296114959434817137662e-02 1.45471209416287079220497790998934e-03
 	 6.41676079281838784851288437494077e-03 3.55529500518926289132082274591085e-02 6.54360698013360967892348973862227e-04
 	 9.83775234098600237508946975140134e-01 1.11270996476519473672439630718145e-04 7.72125407583664455401280951596377e-06
 	 9.46302700060275281401800384628586e-01 3.68261219218964097610324870402110e-04 4.48493299549034099863928370943711e-05
 	 8.89342808819515551199685887695523e-01 7.58897601652486208934078604215756e-04 1.28124292538809333823202063484814e-04
 	 8.15389739443474592661686983774416e-01 1.26607482516233327274335351830814e-03 2.63963197514875040714660281437887e-04
 	 7.27676452889264746559661034552846e-01 1.86762093426678932317486214742530e-03 4.46429192431015543860578498325253e-04
 	 6.30036688370404052150774987239856e-01 2.53724377873626449897415113809984e-03 6.57490670394659105883750083165751e-04
 	 5.26737861339873214561180247983430e-01 3.24567701520911411350311936985236e-03 8.69548259388814941649170631166044e-04
 	 4.22294657307570209248126502643572e-01 3.96195849862157611909196930355392e-03 1.04981828425171146677852274109455e-03
 	 3.21271743988936209213136407925049e-01 4.65478330116342320366129570174962e-03 1.16583176207229132458065290478544e-03
 	 2.28084270649258069596498899045400e-01 5.29387190685737252238141081761569e-03 1.19110563935300069193790051258475e-03
 	 1.46804867681213702113041108532343e-01 5.85129382691662591753356537083164e-03 1.11000367205384424702796497541613e-03
 	 8.09854996819552308551237729261629e-02 6.30268934838307259838074969593436e-03 9.20936791785734653811856809113578e-04
 	 3.35014045320132236582821860793047e-02 6.62833981485067003092126469709910e-03 6.37349336733168312339736782945465e-04
 	 6.41676079281838784851288437494077e-03 6.81408889230350478527498125913553e-03 2.86693400389352018222538509562014e-04
 	 ];
 
 	 case  27 

 	 % ALG. DEG.:   27
 	 % PTS CARD.:  196
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.83775234098600237508946975140134e-01 1.61134949049231875062293539713210e-02 7.72125407583672248104395691159496e-06
 	 9.46302700060275281401800384628586e-01 5.33290387205057545005892905010114e-02 4.48493299549038639960525653993528e-05
 	 8.89342808819515551199685887695523e-01 1.09898293578831962591380033700261e-01 1.28124292538810607760754733952524e-04
 	 8.15389739443474703683989446290070e-01 1.83344185731363018554418431449449e-01 2.63963197514877697009982870923750e-04
 	 7.27676452889264746559661034552846e-01 2.70455926176468575139466565815383e-01 4.46429192431020043299594313168654e-04
 	 6.30036688370404052150774987239856e-01 3.67426067850859738861402092879871e-01 6.57490670394665719517002244742798e-04
 	 5.26737861339873214561180247983430e-01 4.70016461644917726836467863904545e-01 8.69548259388823723686767763751959e-04
 	 4.22294657307570209248126502643572e-01 5.73743384193808214632781528052874e-01 1.04981828425172209195981309903800e-03
 	 3.21271743988936209213136407925049e-01 6.74073472709900367583202296373202e-01 1.16583176207230303396411574823333e-03
 	 2.28084270649258069596498899045400e-01 7.66621857443884668903422152652638e-01 1.19110563935301261816179785313352e-03
 	 1.46804867681213702113041108532343e-01 8.47343838491869671969425326096825e-01 1.11000367205385530589012432756135e-03
 	 8.09854996819552308551237729261629e-02 9.12711810969661807568797939893557e-01 9.20936791785743977950540184451711e-04
 	 3.35014045320132236582821860793047e-02 9.59870255653136106310796549223596e-01 6.37349336733174709132554447421626e-04
 	 6.41676079281838784851288437494077e-03 9.86769150314878218388514596881578e-01 2.86693400389354891358295596148764e-04
 	 9.83775234098600348531249437655788e-01 1.56442022717672296616697735771595e-02 1.76233048955477846473673120275549e-05
 	 9.46302700060275281401800384628586e-01 5.17758731811555211743680615654739e-02 1.02365938019031359022814609005536e-04
 	 8.89342808819515662221988350211177e-01 1.06697593800337664493582678915118e-01 2.92436105554929519443480012697023e-04
 	 8.15389739443474592661686983774416e-01 1.78004433169712483753244214312872e-01 6.02480356858906104973450101880417e-04
 	 7.27676452889264746559661034552846e-01 2.62579113945671294150230323793949e-01 1.01894817800468042920392086614356e-03
 	 6.30036688370404052150774987239856e-01 3.56725077911105081795994919957593e-01 1.50068349474533416221255777145416e-03
 	 5.26737861339873214561180247983430e-01 4.56327608654707783664150611002697e-01 1.98469237588732964894244759079811e-03
 	 4.22294657307570209248126502643572e-01 5.57033567663450357443366556253750e-01 2.39614802551152156900871048605950e-03
 	 3.21271743988936209213136407925049e-01 6.54441622709937886881448321219068e-01 2.66094191411353746951062859693593e-03
 	 2.28084270649258069596498899045400e-01 7.44294609864290190870406149770133e-01 2.71862804137160650463922451081089e-03
 	 1.46804867681213702113041108532343e-01 8.22665627867752879964768908394035e-01 2.53351760680960071819844969809310e-03
 	 8.09854996819552308551237729261629e-02 8.86129810502982895314971756306477e-01 2.10198365599165897313338469132304e-03
 	 3.35014045320132236582821860793047e-02 9.31914803256157053823471869691275e-01 1.45471209416285171024674216511130e-03
 	 6.41676079281838784851288437494077e-03 9.58030289155288872215976425650297e-01 6.54360698013352402695186338377198e-04
 	 9.83775234098600348531249437655788e-01 1.48229567958683139394793215615209e-02 2.67166906994156574668523862481351e-05
 	 9.46302700060275281401800384628586e-01 4.90578885327803138061142362857936e-02 1.55185370758746470597200239893709e-04
 	 8.89342808819515551199685887695523e-01 1.01096482623453803872948242315033e-01 4.43329161457481130039631755934693e-04
 	 8.15389739443474592661686983774416e-01 1.68660055432127559127408744643617e-01 9.13352032554314041158660675279179e-04
 	 7.27676452889264746559661034552846e-01 2.48794971702599398977184819159447e-01 1.54471158910503563073401966931897e-03
 	 6.30036688370404052150774987239856e-01 3.37998724768581559896318822211470e-01 2.27501578191262624970003791702311e-03
 	 5.26737861339873214561180247983430e-01 4.32372601066256634361195665405830e-01 3.00876666745213388470814308561785e-03
 	 4.22294657307570209248126502643572e-01 5.27791980945218508480820673867129e-01 3.63252784009766805858876459467410e-03
 	 3.21271743988936209213136407925049e-01 6.20086580979211987596499966457486e-01 4.03395177634601701660566064333580e-03
 	 2.28084270649258069596498899045400e-01 7.05222717896356376954258848854806e-01 4.12140316124433563754747567031700e-03
 	 1.46804867681213702113041108532343e-01 7.79479633892004364348338185664034e-01 3.84077825832519325482961036755114e-03
 	 8.09854996819552308551237729261629e-02 8.39612251774657258884815291821724e-01 3.18657865395856679247010845301702e-03
 	 3.35014045320132236582821860793047e-02 8.82993752326093228610659480182221e-01 2.20532376343705611293488644264471e-03
 	 6.41676079281838784851288437494077e-03 9.07738300655319685361632764397655e-01 9.92001924627263160019752241680635e-04
 	 9.83775234098600237508946975140134e-01 1.36879661938311466412576677953439e-02 3.45621938289640946934469512008548e-05
 	 9.46302700060275281401800384628586e-01 4.53015365979212297764533445842972e-02 2.00756408191706279880647811886263e-04
 	 8.89342808819515551199685887695523e-01 9.33555467726108062498369122295117e-02 5.73515207430264181871770734488791e-04
 	 8.15389739443474592661686983774416e-01 1.55745791396230875980322139184864e-01 1.18156287911477591787146046442558e-03
 	 7.27676452889264635537358572037192e-01 2.29744794426547271903871205722680e-01 1.99832464107027639801938967423212e-03
 	 6.30036688370404052150774987239856e-01 3.12118235376625863253252646245528e-01 2.94308667578115339819033735579978e-03
 	 5.26737861339873214561180247983430e-01 3.99265924338617961275588186254026e-01 3.89230754349682373308128013889018e-03
 	 4.22294657307570153736975271385745e-01 4.87379062898370019052407542403671e-01 4.69923961433254405717363511030271e-03
 	 3.21271743988936209213136407925049e-01 5.72606685331338516320442977303173e-01 5.21854389674895110390329122651565e-03
 	 2.28084270649258069596498899045400e-01 6.51223966623022065824955006974051e-01 5.33167586168700139565013174092201e-03
 	 1.46804867681213702113041108532343e-01 7.19795046590677611852981954143615e-01 4.96864391296822707766445148536150e-03
 	 8.09854996819552308551237729261629e-02 7.75323322902846667759035881317686e-01 4.12233499756630913934962734401779e-03
 	 3.35014045320132236582821860793047e-02 8.15383111321796638648606858623680e-01 2.85292921286838755540182788195125e-03
 	 6.41676079281838784851288437494077e-03 8.38232974927044516277874208753929e-01 1.28330874446298034280422584174630e-03
 	 9.83775234098600237508946975140134e-01 1.22922772036630923581101981767461e-02 4.07918884350139823529411697844438e-05
 	 9.46302700060275281401800384628586e-01 4.06823802548913343590797353499511e-02 2.36941932740027637327440146464141e-04
 	 8.89342808819515551199685887695523e-01 8.38365790197263122118798150950170e-02 6.76888986649735167368258093034683e-04
 	 8.15389739443474592661686983774416e-01 1.39865222782999287787220055179205e-01 1.39453477352506540615229013724274e-03
 	 7.27676452889264635537358572037192e-01 2.06318941703878655502535366395023e-01 2.35851451498908688819700074645880e-03
 	 6.30036688370404052150774987239856e-01 2.80293201724646057204637372706202e-01 3.47356605680604335617545075365342e-03
 	 5.26737861339873214561180247983430e-01 3.58554905122350386914575892660650e-01 4.59388011810836494053233991508023e-03
 	 4.22294657307570153736975271385745e-01 4.37683616365762195865585226783878e-01 5.54625840668160601659719688427685e-03
 	 3.21271743988936209213136407925049e-01 5.14221032189256299638202563073719e-01 6.15916516997863996984996504124865e-03
 	 2.28084270649258069596498899045400e-01 5.84822128141060826322927823639475e-01 6.29268871061451975923439761118061e-03
 	 1.46804867681213702113041108532343e-01 6.46401380396727898158815150964074e-01 5.86422173239649346943025420841877e-03
 	 8.09854996819552308551237729261629e-02 6.96267734200143872946853207395179e-01 4.86536908347402156232996972562432e-03
 	 3.35014045320132236582821860793047e-02 7.32242839412469148641093852347694e-01 3.36715807857060388588732458003960e-03
 	 6.41676079281838784851288437494077e-03 7.52762824158499821436407728469931e-01 1.51461991651531593244817130994306e-03
 	 9.83775234098600348531249437655788e-01 1.07011446917479081941682039769148e-02 4.51142887560547001853800130888317e-05
 	 9.46302700060275281401800384628586e-01 3.54163862642608573416680428636028e-02 2.62048833289020436168592631531737e-04
 	 8.89342808819515551199685887695523e-01 7.29846347984976218103980727391900e-02 7.48613667351018382753458091372067e-04
 	 8.15389739443474703683989446290070e-01 1.21760839065556569771331396623282e-01 1.54230281722301880951986330359205e-03
 	 7.27676452889264635537358572037192e-01 1.79612679672043973333472877129680e-01 2.60842802200921203628625200110491e-03
 	 6.30036688370404052150774987239856e-01 2.44011590210061718453360413150222e-01 3.84163293517608478086500234383038e-03
 	 5.26737861339873214561180247983430e-01 3.12142970425919652477375620946987e-01 5.08065799623891312108980855555274e-03
 	 4.22294657307570209248126502643572e-01 3.81029131570654766569816729315789e-01 6.13395243207117031591923961286739e-03
 	 3.21271743988936209213136407925049e-01 4.47659418822524801662154914083658e-01 6.81180417565916632854916556993885e-03
 	 2.28084270649258069596498899045400e-01 5.09121793178278547742365844896995e-01 6.95947617122207127376976032451239e-03
 	 1.46804867681213702113041108532343e-01 5.62730126075389303075269253895385e-01 6.48560786751367461533401836959456e-03
 	 8.09854996819552308551237729261629e-02 6.06141697296808557027247843507212e-01 5.38091454349588250993807747590836e-03
 	 3.35014045320132236582821860793047e-02 6.37460125916627151632098957634298e-01 3.72394972804265290966529988736511e-03
 	 6.41676079281827682621042185928673e-03 6.55323970198815830556782202620525e-01 1.67511245227595462030378836715272e-03
 	 9.83775234098600237508946975140134e-01 8.98896607433205541148879547108663e-03 4.73272336827446052820618505041494e-05
 	 9.46302700060275281401800384628586e-01 2.97497794652172575791126973854261e-02 2.74902845890385451842197195304607e-04
 	 8.89342808819515551199685887695523e-01 6.13071241487952028892394196191162e-02 7.85334645624067824790093261810853e-04
 	 8.15389739443474703683989446290070e-01 1.02279156395905013177127784729237e-01 1.61795581517336730693890078924824e-03
 	 7.27676452889264524515056109521538e-01 1.50874727012793863334394472985878e-01 2.73637656596506431000426218247412e-03
 	 6.30036688370404052150774987239856e-01 2.04969839145665438939758473679831e-01 4.03007261467700200058272841374674e-03
 	 5.26737861339873214561180247983430e-01 2.62200227389087214824314742145361e-01 5.32987430102914439000727497841581e-03
 	 4.22294657307570209248126502643572e-01 3.20064631932509335854319942882285e-01 6.43483490831961522232740335880408e-03
 	 3.21271743988936209213136407925049e-01 3.76034101450282043366257767047500e-01 7.14593661812412683786988054635003e-03
 	 2.28084270649258069596498899045400e-01 4.27662521946064022593247955228435e-01 7.30085221659878668559739978149992e-03
 	 1.46804867681213757624192339790170e-01 4.72693544289423950299777743566665e-01 6.80373973709764035683322802583461e-03
 	 8.09854996819552308551237729261629e-02 5.09159282505608046243139597208938e-01 5.64485902468606949577978326715311e-03
 	 3.35014045320132236582821860793047e-02 5.35466775813499884506541093287524e-01 3.90661681390720109258163361687366e-03
 	 6.41676079281849887081534689059481e-03 5.50472412578094871804523791070096e-01 1.75728002501424084881576082040056e-03
 	 9.83775234098600237508946975140134e-01 7.23579982706764983368952215414538e-03 4.73272336827446730446976308481766e-05
 	 9.46302700060275281401800384628586e-01 2.39475204745074506107460621251448e-02 2.74902845890385831312957565231159e-04
 	 8.89342808819515551199685887695523e-01 4.93500670316892250943929809636757e-02 7.85334645624068908992265747315287e-04
 	 8.15389739443474703683989446290070e-01 8.23311041606203108944583846096066e-02 1.61795581517336947534324576025710e-03
 	 7.27676452889264635537358572037192e-01 1.21448820097941445617095723719103e-01 2.73637656596506821313208313029008e-03
 	 6.30036688370404052150774987239856e-01 1.64993472483930425642739692193572e-01 4.03007261467700807211489433257157e-03
 	 5.26737861339873214561180247983430e-01 2.11061911271039459592202547355555e-01 5.32987430102915219626291687404773e-03
 	 4.22294657307570264759277733901399e-01 2.57640710759920399386402323216316e-01 6.43483490831962476330652123124310e-03
 	 3.21271743988936209213136407925049e-01 3.02694154560781636398303362511797e-01 7.14593661812413724621073640719260e-03
 	 2.28084270649258069596498899045400e-01 3.44253207404677796787950683210511e-01 7.30085221659879709393825564234248e-03
 	 1.46804867681213702113041108532343e-01 3.80501588029362181053727454127511e-01 6.80373973709764989781234589827363e-03
 	 8.09854996819552308551237729261629e-02 4.09855217812436611879434167349245e-01 5.64485902468607730203542516278503e-03
 	 3.35014045320132236582821860793047e-02 4.31031819654486780812874258117517e-01 3.90661681390720629675206154729494e-03
 	 6.41676079281838784851288437494077e-03 4.43110826629086518302358399523655e-01 1.75728002501424323406054028851031e-03
 	 9.83775234098600348531249437655788e-01 5.52362120965179705101011364831720e-03 4.51142887560544968974726720567503e-05
 	 9.46302700060275281401800384628586e-01 1.82809136754638543176376686005824e-02 2.62048833289019243546202897476860e-04
 	 8.89342808819515551199685887695523e-01 3.76725563819868131121282317508303e-02 7.48613667351015021726723386308322e-04
 	 8.15389739443474703683989446290070e-01 6.28494214909687543002547727155616e-02 1.54230281722301187062595939636367e-03
 	 7.27676452889264635537358572037192e-01 9.27108674386913633735929352042149e-02 2.60842802200920032690278915765703e-03
 	 6.30036688370404052150774987239856e-01 1.25951721419534173884713368352095e-01 3.84163293517606743363024257575944e-03
 	 5.26737861339873214561180247983430e-01 1.61119168234207077450292899811757e-01 5.08065799623889056968462085706051e-03
 	 4.22294657307570153736975271385745e-01 1.96676211121774968670905536782811e-01 6.13395243207114256034362398395388e-03
 	 3.21271743988936209213136407925049e-01 2.31068837188538878102406215475639e-01 6.81180417565913597088833597581470e-03
 	 2.28084270649258069596498899045400e-01 2.62793936172463271638832793541951e-01 6.95947617122204004874719274198469e-03
 	 1.46804867681213702113041108532343e-01 2.90465006243396883789387175056618e-01 6.48560786751364599239666475227750e-03
 	 8.09854996819552308551237729261629e-02 3.12872803021236212117628383566625e-01 5.38091454349585822380941380060904e-03
 	 3.35014045320132236582821860793047e-02 3.29038469551359513687316393770743e-01 3.72394972804263599611140911349594e-03
 	 6.41676079281838784851288437494077e-03 3.38259269008365670572402450488880e-01 1.67511245227594724772901546572257e-03
 	 9.83775234098600237508946975140134e-01 3.93248869773661288706811944848596e-03 4.07918884350140501155769501284709e-05
 	 9.46302700060275281401800384628586e-01 1.30149196848333773002259761142341e-02 2.36941932740028071008309140665915e-04
 	 8.89342808819515551199685887695523e-01 2.68206121607581227106464893950033e-02 6.76888986649736468410865075640004e-04
 	 8.15389739443474592661686983774416e-01 4.47450377735260640399417297885520e-02 1.39453477352506779139706960535250e-03
 	 7.27676452889264635537358572037192e-01 6.60046054068566812045304459388717e-02 2.35851451498909122500569068847653e-03
 	 6.30036688370404052150774987239856e-01 8.96701099049498906445876400539419e-02 3.47356605680604942770761667247825e-03
 	 5.26737861339873214561180247983430e-01 1.14707233537776343013092628098093e-01 4.59388011810837274678798181071215e-03
 	 4.22294657307570209248126502643572e-01 1.40021726326667539375137039314723e-01 5.54625840668161642493805274511942e-03
 	 3.21271743988936209213136407925049e-01 1.64507223821807491148661029001232e-01 6.15916516997865037819082090209122e-03
 	 2.28084270649258069596498899045400e-01 1.87093601209680993058270814799471e-01 6.29268871061453103493699146042673e-03
 	 1.46804867681213702113041108532343e-01 2.06793751922058288705841277987929e-01 5.86422173239650474513284805766489e-03
 	 8.09854996819552308551237729261629e-02 2.22746766117900785175720557163004e-01 4.86536908347403023594734960965980e-03
 	 3.35014045320132236582821860793047e-02 2.34255756055517627700623961573001e-01 3.36715807857060995741949049886443e-03
 	 6.41676079281838784851288437494077e-03 2.40820415048681679692776924639475e-01 1.51461991651531875137381977225459e-03
 	 9.83775234098600237508946975140134e-01 2.53679970756856033864412580669523e-03 3.45621938289640946934469512008548e-05
 	 9.46302700060275281401800384628586e-01 8.39576334180348882174627078711637e-03 2.00756408191706279880647811886263e-04
 	 8.89342808819515551199685887695523e-01 1.73016444078736425504772000749654e-02 5.73515207430264181871770734488791e-04
 	 8.15389739443474592661686983774416e-01 2.88644691602944758468396457828931e-02 1.18156287911477591787146046442558e-03
 	 7.27676452889264635537358572037192e-01 4.25787526841880925587702222401276e-02 1.99832464107027639801938967423212e-03
 	 6.30036688370404052150774987239856e-01 5.78450762529700845959723665146157e-02 2.94308667578115339819033735579978e-03
 	 5.26737861339873214561180247983430e-01 7.39962143215088241632315657625441e-02 3.89230754349682373308128013889018e-03
 	 4.22294657307570153736975271385745e-01 9.03262797940597716994659549527569e-02 4.69923961433254405717363511030271e-03
 	 3.21271743988936209213136407925049e-01 1.06121570679725274466420614771778e-01 5.21854389674895110390329122651565e-03
 	 2.28084270649258069596498899045400e-01 1.20691762727719864578546093980549e-01 5.33167586168700139565013174092201e-03
 	 1.46804867681213702113041108532343e-01 1.33400085728108686033976937324042e-01 4.96864391296822707766445148536150e-03
 	 8.09854996819552308551237729261629e-02 1.43691177415198101385840345756151e-01 4.12233499756630913934962734401779e-03
 	 3.35014045320132236582821860793047e-02 1.51115484146190026670808492781362e-01 2.85292921286838755540182788195125e-03
 	 6.41676079281838784851288437494077e-03 1.55350264280137095873612906871131e-01 1.28330874446298034280422584174630e-03
 	 9.83775234098600237508946975140134e-01 1.40180910553139650986942399413238e-03 2.67166906994155490466351376976917e-05
 	 9.46302700060275281401800384628586e-01 4.63941140694441173097928299284831e-03 1.55185370758745847180951060728660e-04
 	 8.89342808819515662221988350211177e-01 9.56070855703067268294148561835755e-03 4.43329161457479341106047154852376e-04
 	 8.15389739443474592661686983774416e-01 1.59502051243978204553286559530534e-02 9.13352032554310246451056976013660e-04
 	 7.27676452889264635537358572037192e-01 2.35285754081360209966078400611877e-02 1.54471158910502934236141925339325e-03
 	 6.30036688370404052150774987239856e-01 3.19645868610144989752086530643282e-02 2.27501578191261670872092004458409e-03
 	 5.26737861339873214561180247983430e-01 4.08895375938702620999265491263941e-02 3.00876666745212174164381124796819e-03
 	 4.22294657307570209248126502643572e-01 4.99133617472113932933552860049531e-02 3.63252784009765331343921879181380e-03
 	 3.21271743988936209213136407925049e-01 5.86416750318519142126660881331190e-02 4.03395177634600053673263886366840e-03
 	 2.28084270649258069596498899045400e-01 6.66930114543857754938471771311015e-02 4.12140316124431829031271590224605e-03
 	 1.46804867681213702113041108532343e-01 7.37154984267821555832256308349315e-02 3.84077825832517764231832657628729e-03
 	 8.09854996819552308551237729261629e-02 7.94022485433877323046658602834214e-02 3.18657865395855378204403862696381e-03
 	 3.35014045320132236582821860793047e-02 8.35048431418937697756632587697823e-02 2.20532376343704700563663756440747e-03
 	 6.41676079281838784851288437494077e-03 8.58449385518621488344592762587126e-02 9.92001924627259040051496796763786e-04
 	 9.83775234098600348531249437655788e-01 5.80563629632477318232020024879603e-04 1.76233048955480184284607542144485e-05
 	 9.46302700060275281401800384628586e-01 1.92142675856919048493764989871124e-03 1.02365938019032714275530215886079e-04
 	 8.89342808819515551199685887695523e-01 3.95959738014677042894362557490240e-03 2.92436105554933368361192336237764e-04
 	 8.15389739443474592661686983774416e-01 6.60582738681286807391757065488491e-03 6.02480356858914019649309246062785e-04
 	 7.27676452889264635537358572037192e-01 9.74443316506401480125987291103229e-03 1.01894817800469365647042518929766e-03
 	 6.30036688370404052150774987239856e-01 1.32382337184908105420788615447236e-02 1.50068349474535389469209700763486e-03
 	 5.26737861339873214561180247983430e-01 1.69345300054189462635179097560467e-02 1.98469237588735566979458724290453e-03
 	 4.22294657307570209248126502643572e-01 2.06717750289794333085069411026780e-02 2.39614802551155279403127806858720e-03
 	 3.21271743988936209213136407925049e-01 2.42866333011257928831128083402291e-02 2.66094191411357216398014813307782e-03
 	 2.28084270649258069596498899045400e-01 2.76211194864516285107924886688124e-02 2.71862804137164250015135102955810e-03
 	 1.46804867681213702113041108532343e-01 3.05295044510333068998875205579679e-02 2.53351760680963411162536225162967e-03
 	 8.09854996819552308551237729261629e-02 3.28846898150617628076020082517061e-02 2.10198365599168672870900032023656e-03
 	 3.35014045320132236582821860793047e-02 3.45837922118296114959434817137662e-02 1.45471209416287079220497790998934e-03
 	 6.41676079281838784851288437494077e-03 3.55529500518926289132082274591085e-02 6.54360698013360967892348973862227e-04
 	 9.83775234098600237508946975140134e-01 1.11270996476519473672439630718145e-04 7.72125407583664455401280951596377e-06
 	 9.46302700060275281401800384628586e-01 3.68261219218964097610324870402110e-04 4.48493299549034099863928370943711e-05
 	 8.89342808819515551199685887695523e-01 7.58897601652486208934078604215756e-04 1.28124292538809333823202063484814e-04
 	 8.15389739443474592661686983774416e-01 1.26607482516233327274335351830814e-03 2.63963197514875040714660281437887e-04
 	 7.27676452889264746559661034552846e-01 1.86762093426678932317486214742530e-03 4.46429192431015543860578498325253e-04
 	 6.30036688370404052150774987239856e-01 2.53724377873626449897415113809984e-03 6.57490670394659105883750083165751e-04
 	 5.26737861339873214561180247983430e-01 3.24567701520911411350311936985236e-03 8.69548259388814941649170631166044e-04
 	 4.22294657307570209248126502643572e-01 3.96195849862157611909196930355392e-03 1.04981828425171146677852274109455e-03
 	 3.21271743988936209213136407925049e-01 4.65478330116342320366129570174962e-03 1.16583176207229132458065290478544e-03
 	 2.28084270649258069596498899045400e-01 5.29387190685737252238141081761569e-03 1.19110563935300069193790051258475e-03
 	 1.46804867681213702113041108532343e-01 5.85129382691662591753356537083164e-03 1.11000367205384424702796497541613e-03
 	 8.09854996819552308551237729261629e-02 6.30268934838307259838074969593436e-03 9.20936791785734653811856809113578e-04
 	 3.35014045320132236582821860793047e-02 6.62833981485067003092126469709910e-03 6.37349336733168312339736782945465e-04
 	 6.41676079281838784851288437494077e-03 6.81408889230350478527498125913553e-03 2.86693400389352018222538509562014e-04
 	 ];
 
 	 case  28 

 	 % ALG. DEG.:   28
 	 % PTS CARD.:  225
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-15  

 	 xyw=[
 	 9.85730545263174495751457016012864e-01 1.41837846265205382023655289458475e-02 5.23331585046430369757234496441711e-06
 	 9.52700409905833267565355981787434e-01 4.70156156063196647987290077708167e-02 3.05415780896870999762404697008833e-05
 	 9.02286700679377995371055476425681e-01 9.71266539802462941510796667898830e-02 8.79115619252408413445906698591159e-05
 	 8.36430960605610174241064669331536e-01 1.62587013247922435033032684259524e-01 1.83046223379082343730994697494907e-04
 	 7.57664739031342682196168425434735e-01 2.40880342829116134151234973614919e-01 3.13933849864228542957123035961331e-04
 	 6.69015195029960096917420742101967e-01 3.28997657929454512260036835868959e-01 4.70674825769033691562348575843089e-04
 	 5.73889160906685846796904115763027e-01 4.23552579982469701302960629618610e-01 6.36603413971865484712042704273927e-04
 	 4.75942308463234819981835244107060e-01 5.20911384893088302838748404610669e-01 7.90548409884759889151850664745780e-04
 	 3.78938688646978105722951113421004e-01 6.17332620100899287507445478695445e-01 9.09899124168547877161694614756016e-04
 	 2.86606086257527037375325562607031e-01 7.09110881460693898148406333348248e-01 9.74015991036589223218966626660631e-04
 	 2.02492755050103889757906472368632e-01 7.92719218013761994789945219963556e-01 9.67467879850912896785852801428973e-04
 	 1.29831025553591050680779517279007e-01 8.64944705306509908915302276000148e-01 8.82599985553945715760493229140593e-04
 	 7.14129531151586061099578728317283e-02 9.23012050768901137764999020873802e-01 7.21034975397246867198641773200052e-04
 	 2.94822986479423843064751054043882e-02 9.64690964447165177908516398019856e-01 4.93882379861992947336912784805918e-04
 	 5.64068897251168710482716051046737e-03 9.88389435273325678288358631107258e-01 2.20916984425796261585009383487943e-04
 	 9.85730545263174495751457016012864e-01 1.38219174928591332501826016709856e-02 1.19742741822318189513904215792728e-05
 	 9.52700409905833156543053519271780e-01 4.58161186804446063369766761752544e-02 6.98817423701859717763071322416124e-05
 	 9.02286700679378106393357938941335e-01 9.46486874287634366575971966994985e-02 2.01149171263509878937805752663337e-04
 	 8.36430960605610174241064669331536e-01 1.58438973919647091426199381203332e-01 4.18825411917135060919231692722065e-04
 	 7.57664739031342793218470887950389e-01 2.34734826557530446011767821801186e-01 7.18307493904530723789758628328173e-04
 	 6.69015195029959985895118279586313e-01 3.20604027978697692091714088746812e-01 1.07694425016074089851425554797970e-03
 	 5.73889160906685846796904115763027e-01 4.12746595394508031251490365320933e-01 1.45660304901483006294327093854690e-03
 	 4.75942308463234819981835244107060e-01 5.07621510948555898501410865719663e-01 1.80884236395700164802546883180412e-03
 	 3.78938688646978105722951113421004e-01 6.01582776766849902649880732496968e-01 2.08192700427208866875705695065335e-03
 	 2.86606086257527037375325562607031e-01 6.91019523696948523294736332900357e-01 2.22863187848973539825769840660996e-03
 	 2.02492755050103889757906472368632e-01 7.72494782944113000944241775869159e-01 2.21364924014848772626518069728263e-03
 	 1.29831025553591050680779517279007e-01 8.42877600543818883416236076300265e-01 2.01946424069151956107170953202967e-03
 	 7.14129531151586061099578728317283e-02 8.99463489228975010547628698986955e-01 1.64978968154949113579521569050712e-03
 	 2.94822986479423843064751054043882e-02 9.40079059841617881154718361358391e-01 1.13004511847225618849377415386925e-03
 	 5.64068897251168710482716051046737e-03 9.63172917869725475625841681903694e-01 5.05476951633184183772240505305717e-04
 	 9.85730545263174495751457016012864e-01 1.31864500931389988513942057579698e-02 1.82354122880784035227487438479699e-05
 	 9.52700409905833267565355981787434e-01 4.37097069023267836840318523172755e-02 1.06421680691138535561346412094963e-04
 	 9.02286700679377995371055476425681e-01 9.02971815455635429259473312413320e-02 3.06326547527887823110792631098320e-04
 	 8.36430960605610285263367131847190e-01 1.51154687725415320942445873697579e-01 6.37821879372543428833586265369604e-04
 	 7.57664739031342682196168425434735e-01 2.23942812357378062682045083420235e-01 1.09389789323532092037150054153472e-03
 	 6.69015195029959985895118279586313e-01 3.05864147777222039614741788682295e-01 1.64005952378286378769145503753180e-03
 	 5.73889160906685846796904115763027e-01 3.93770429037402169836212806330877e-01 2.21823525456528360816355061047034e-03
 	 4.75942308463234875492986475364887e-01 4.84283437792560056411872437820421e-01 2.75465433385878961589088298467232e-03
 	 3.78938688646978105722951113421004e-01 5.73924802172083969864502250857186e-01 3.17053014644679345690470029239805e-03
 	 2.86606086257527037375325562607031e-01 6.59249663971884336532980341871735e-01 3.39394442820753180004023086269171e-03
 	 2.02492755050103889757906472368632e-01 7.36979070216954967875722104508895e-01 3.37112763086700947812168749351258e-03
 	 1.29831025553591050680779517279007e-01 8.04126013625676261398211863706820e-01 3.07540669852753500643216533205759e-03
 	 7.14129531151586061099578728317283e-02 8.58110346661105305443584256863687e-01 2.51243579141639805651919914453174e-03
 	 2.94822986479423843064751054043882e-02 8.96858602477613731096539595455397e-01 1.72092590547573377410262018827325e-03
 	 5.64068897251168710482716051046737e-03 9.18890712458230063397479625564301e-01 7.69781990530148769666385355492366e-04
 	 9.85730545263174495751457016012864e-01 1.23032503825116368983971781858600e-02 2.37509086405654765486710616739785e-05
 	 9.52700409905833267565355981787434e-01 4.07821259222244936193391140477615e-02 1.38610061321350859020809509480898e-04
 	 9.02286700679377995371055476425681e-01 8.42492729690920982843493902691989e-02 3.98978302742908678100997033055819e-04
 	 8.36430960605610174241064669331536e-01 1.41030675916617970200306331207685e-01 8.30737959011476579870847380959731e-04
 	 7.57664739031342793218470887950389e-01 2.08943610474073365734781759783800e-01 1.42475906296478751524026140629076e-03
 	 6.69015195029959985895118279586313e-01 2.85378033250562435085839751991443e-01 2.13611314617339351565328264825894e-03
 	 5.73889160906685846796904115763027e-01 3.67396543228635685807148547610268e-01 2.88916433816552688587653285878787e-03
 	 4.75942308463234819981835244107060e-01 4.51847187770838321085875577409752e-01 3.58782913082752313860268600365089e-03
 	 3.78938688646978105722951113421004e-01 5.35484568779475256228295165783493e-01 4.12949105075329728903321679922556e-03
 	 2.86606086257527037375325562607031e-01 6.15094557150974163839407538034720e-01 4.42047938220801843456353452666008e-03
 	 2.02492755050103889757906472368632e-01 6.87617817039899770215072294377023e-01 4.39076139938734347906157395868831e-03
 	 1.29831025553591050680779517279007e-01 7.50267404407441329539096841472201e-01 4.00559649408440809209563937542953e-03
 	 7.14129531151586061099578728317283e-02 8.00635984379799214849526833859272e-01 3.27234898803079564399975964761325e-03
 	 2.94822986479423843064751054043882e-02 8.36788966405201284359804958512541e-01 2.24143843376977541792527404140856e-03
 	 5.64068897251168710482716051046737e-03 8.57345413639441722430944992083823e-01 1.00261082345733023440947917492849e-03
 	 9.85730545263174495751457016012864e-01 1.12084581549249870380258187196887e-02 2.82942289582358922077516549808962e-05
 	 9.52700409905833267565355981787434e-01 3.71531699068632231819364619695989e-02 1.65124832497694451439659846236907e-04
 	 9.02286700679377995371055476425681e-01 7.67524370632329810959504357015248e-02 4.75299013524707115226769493787629e-04
 	 8.36430960605610174241064669331536e-01 1.28481204594448117362048833456356e-01 9.89650138118196905784307304543290e-04
 	 7.57664739031342793218470887950389e-01 1.90350975711794379030550317111192e-01 1.69730176423631509176337406330504e-03
 	 6.69015195029959985895118279586313e-01 2.59983959082098703419205776299350e-01 2.54473103969165117058115477277624e-03
 	 5.73889160906685846796904115763027e-01 3.34704135331235663741722419217695e-01 3.44183367967682094651360458215095e-03
 	 4.75942308463234819981835244107060e-01 4.11640025122863795203898007457610e-01 4.27414632538645773013330497747120e-03
 	 3.78938688646978105722951113421004e-01 4.87835018809682607887623362330487e-01 4.91942295931538202402588666473093e-03
 	 2.86606086257527037375325562607031e-01 5.60360993298860798894622803345555e-01 5.26607455900588057595701485524842e-03
 	 2.02492755050103889757906472368632e-01 6.26430844634994321573628894839203e-01 5.23067181198554314452975333438189e-03
 	 1.29831025553591050680779517279007e-01 6.83505622161309722706334923714167e-01 4.77182856593367111380787903840428e-03
 	 7.14129531151586061099578728317283e-02 7.29392205250413372397133571212180e-01 3.89831786647765231659801266062004e-03
 	 2.94822986479423843064751054043882e-02 7.62328150924043601577295703464188e-01 2.67020404148048378506485889261057e-03
 	 5.64068897251179812712962302612141e-03 7.81055403599191677699309366289526e-01 1.19440062795979481599650817713609e-03
 	 9.85730545263174495751457016012864e-01 9.94688977170379851067139043152565e-03 3.16792392893965990118693154542484e-05
 	 9.52700409905833267565355981787434e-01 3.29713936229995632776201830438367e-02 1.84879718370743766813271702353916e-04
 	 9.02286700679377995371055476425681e-01 6.81135639376191370786273182602599e-02 5.32161919156327401295158985305989e-04
 	 8.36430960605610174241064669331536e-01 1.14019998305935774118857750636380e-01 1.10804799044029057136784288672970e-03
 	 7.57664739031342793218470887950389e-01 1.68926015261923190280413109576330e-01 1.90036027540895673462739701164992e-03
 	 6.69015195029960096917420742101967e-01 2.30721455855592949557575366270612e-01 2.84917265823147070752385801029050e-03
 	 5.73889160906685846796904115763027e-01 2.97031500163147388349216271308251e-01 3.85360113165580985342129061166361e-03
 	 4.75942308463234819981835244107060e-01 3.65307868301169680336215606075712e-01 4.78548839057160550758407424609686e-03
 	 3.78938688646978105722951113421004e-01 4.32926731920286744781378729385324e-01 5.50796338447457657638839378932971e-03
 	 2.86606086257527037375325562607031e-01 4.97289542920501870248983777855756e-01 5.89608701890395343198081334890048e-03
 	 2.02492755050103889757906472368632e-01 5.55922899925507030260973806434777e-01 5.85644882639428220744148845255950e-03
 	 1.29831025553591050680779517279007e-01 6.06573623954781426803606336761732e-01 5.34271137804548639643753560335426e-03
 	 7.14129531151586061099578728317283e-02 6.47295441146639172202981171722058e-01 4.36469729217796569703535780604398e-03
 	 2.94822986479423843064751054043882e-02 6.76524280351295859148308409203310e-01 2.98965675673419075883407991511831e-03
 	 5.64068897251157608252469799481332e-03 6.93143686474045450651715327694546e-01 1.33729402403560070598798059648971e-03
 	 9.85730545263174495751457016012864e-01 8.57019237721925487838436907850337e-03 3.37673224021273988225931572682015e-05
 	 9.52700409905833267565355981787434e-01 2.84079941348063143291557963721061e-02 1.97065750184506079502669284586602e-04
 	 9.02286700679377995371055476425681e-01 5.86863190244673038620248917140998e-02 5.67238465864968637378251692382491e-04
 	 8.36430960605610285263367131847190e-01 9.82390820406873338521691607638786e-02 1.18108308688934238173118274062290e-03
 	 7.57664739031342682196168425434735e-01 1.45545842121439006344729705233476e-01 2.02561928693181445004789509312104e-03
 	 6.69015195029959985895118279586313e-01 1.98788496466452357935850159265101e-01 3.03697102228179605445945732355995e-03
 	 5.73889160906685846796904115763027e-01 2.55920911653589988610235650412505e-01 4.10760468813969620988091335789250e-03
 	 4.75942308463234875492986475364887e-01 3.14747501993945799636520632702741e-01 5.10091570886161450870677214197713e-03
 	 3.78938688646978105722951113421004e-01 3.73007589603775779885097563237650e-01 5.87101141172030951964622147443151e-03
 	 2.86606086257527092886476793864858e-01 4.28462277940586833135938604755211e-01 6.28471755459631287871191673843896e-03
 	 2.02492755050103889757906472368632e-01 4.78980496276990241888427135563688e-01 6.24246667812530971197748641543512e-03
 	 1.29831025553591050680779517279007e-01 5.22620916442415373026619818119798e-01 5.69486710068701877662800114876518e-03
 	 7.14129531151586061099578728317283e-02 5.57706638240295093922327396285255e-01 4.65238888176197282198209848047554e-03
 	 2.94822986479423843064751054043882e-02 5.82890065492028708327154618018540e-01 3.18671489091381038641359602081593e-03
 	 5.64068897251168710482716051046737e-03 5.97209265858788418412927967438009e-01 1.42543948241721026189143817219929e-03
 	 9.85730545263174495751457016012864e-01 7.13472736841275299163322998197145e-03 3.44729809157055052011575657644471e-05
 	 9.52700409905833267565355981787434e-01 2.36497950470833696867689610598973e-02 2.01183966094441331589476318342236e-04
 	 9.02286700679377995371055476425681e-01 4.88566496603109814977905500654742e-02 5.79092430710027882868884407940868e-04
 	 8.36430960605610174241064669331536e-01 8.17845196971948990016798575197754e-02 1.20576497684144780253578943529646e-03
 	 7.57664739031342793218470887950389e-01 1.21167630484328617268552363839262e-01 2.06795001952793508145922452001741e-03
 	 6.69015195029959985895118279586313e-01 1.65492402485020034808016475835757e-01 3.10043665428666416136738170905573e-03
 	 5.73889160906685846796904115763027e-01 2.13055419546657104357123557747400e-01 4.19344407404304876652023637007005e-03
 	 4.75942308463234764470684012849233e-01 2.62028845768382645520233609204297e-01 5.20751298519098529404836028788850e-03
 	 3.78938688646978161234102344678831e-01 3.10530655676511002649675674547325e-01 5.99370189741110521303157909756010e-03
 	 2.86606086257527092886476793864858e-01 3.56696956871236536823488449954311e-01 6.41605353661528574754635556587345e-03
 	 2.02492755050103945269057703626459e-01 3.98753622474948110632197995073511e-01 6.37291971507884802417009950659121e-03
 	 1.29831025553590995169628286021180e-01 4.35084487223204530170761472618324e-01 5.81387657989412658110506271214035e-03
 	 7.14129531151586616211091040895553e-02 4.64293523442420752456172294841963e-01 4.74961299043707031036776200494387e-03
 	 2.94822986479424398176263366622152e-02 4.85258850676028863357913678555633e-01 3.25330982154940599737624751242038e-03
 	 5.64068897251168710482716051046737e-03 4.97179655513744211958737651002593e-01 1.45522785279432681840305896514565e-03
 	 9.85730545263174495751457016012864e-01 5.69926235960624590071166295501826e-03 3.37673224021275479003918740250612e-05
 	 9.52700409905833267565355981787434e-01 1.88915959593604076971473659796175e-02 1.97065750184506946864407272990150e-04
 	 9.02286700679378106393357938941335e-01 3.90269802961546244390866888807068e-02 5.67238465864971022623031160492246e-04
 	 8.36430960605610285263367131847190e-01 6.53299573537023947622515152033884e-02 1.18108308688934736906117617394329e-03
 	 7.57664739031342793218470887950389e-01 9.67894188472181449256481755583081e-02 2.02561928693182312366527497715651e-03
 	 6.69015195029959985895118279586313e-01 1.32196308503587572902304714261845e-01 3.03697102228180906488552714961315e-03
 	 5.73889160906685846796904115763027e-01 1.70189927439724053570557771308813e-01 4.10760468813971355711567312596344e-03
 	 4.75942308463234875492986475364887e-01 2.09310189542819269359341660674545e-01 5.10091570886163619275022185206581e-03
 	 3.78938688646978161234102344678831e-01 2.48053721749245947858497629567864e-01 5.87101141172033554049836112653793e-03
 	 2.86606086257527037375325562607031e-01 2.84931635801885962955282138864277e-01 6.28471755459633976692579437894892e-03
 	 2.02492755050103945269057703626459e-01 3.18526748672905701820212698294199e-01 6.24246667812533660019136405594509e-03
 	 1.29831025553591050680779517279007e-01 3.47548058003993354247995739569888e-01 5.69486710068704393011840281246805e-03
 	 7.14129531151586061099578728317283e-02 3.70880408644546077923109805851709e-01 4.65238888176199363866381020216068e-03
 	 2.94822986479423843064751054043882e-02 3.87627635860028685321765351545764e-01 3.18671489091382426420140383527269e-03
 	 5.64068897251168710482716051046737e-03 3.97150045168699672437639947020216e-01 1.42543948241721655026403858812500e-03
 	 9.85730545263174495751457016012864e-01 4.32256496512170920731854550922435e-03 3.16792392893965854593421593854430e-05
 	 9.52700409905833156543053519271780e-01 1.43281964711671760959177390759578e-02 1.84879718370743685498108765941083e-04
 	 9.02286700679377995371055476425681e-01 2.95997353830028397947415896851453e-02 5.32161919156327184454724488205102e-04
 	 8.36430960605610174241064669331536e-01 4.95490410884540377622897722176276e-02 1.10804799044029013768697389252793e-03
 	 7.57664739031342793218470887950389e-01 7.34092457067340997678428493600222e-02 1.90036027540895586726565902324637e-03
 	 6.69015195029959985895118279586313e-01 1.00263349114447120058457585400902e-01 2.84917265823146940648125102768518e-03
 	 5.73889160906685846796904115763027e-01 1.29079338930166820365030844186549e-01 3.85360113165580811869781463485651e-03
 	 4.75942308463234819981835244107060e-01 1.58749823235595610704251612332882e-01 4.78548839057160290549886028088622e-03
 	 3.78938688646978105722951113421004e-01 1.88134579432735260517972619709326e-01 5.50796338447457397430317982411907e-03
 	 2.86606086257527037375325562607031e-01 2.16104370821971203397993122052867e-01 5.89608701890395082989559938368984e-03
 	 2.02492755050103889757906472368632e-01 2.41584345024389302025724646227900e-01 5.85644882639427960535627448734886e-03
 	 1.29831025553591050680779517279007e-01 2.63595350491627633537916608474916e-01 5.34271137804548379435232163814362e-03
 	 7.14129531151586061099578728317283e-02 2.81291605738202443731665880477522e-01 4.36469729217796309495014384083333e-03
 	 2.94822986479423843064751054043882e-02 2.93993421000762089612123872939264e-01 2.98965675673418902411060393831121e-03
 	 5.64068897251168710482716051046737e-03 3.01215624553443195310364899341948e-01 1.33729402403560027230711160228793e-03
 	 9.85730545263174495751457016012864e-01 3.06099658190051894524064124425422e-03 2.82942289582360006279689035313396e-05
 	 9.52700409905833267565355981787434e-01 1.01464201873035092527075562429673e-02 1.65124832497695074855909025401957e-04
 	 9.02286700679377995371055476425681e-01 2.09608622573889818996306644294236e-02 4.75299013524708904160354094869945e-04
 	 8.36430960605610174241064669331536e-01 3.50878347999416528857352659542812e-02 9.89650138118200808912128252359253e-04
 	 7.57664739031342793218470887950389e-01 5.19842852568628555065544105673325e-02 1.69730176423632159697640897633164e-03
 	 6.69015195029959874872815817070659e-01 7.10008458879413661968271753721638e-02 2.54473103969166114524114163941704e-03
 	 5.73889160906685846796904115763027e-01 9.14067037620784894613734650192782e-02 3.44183367967683439062054340240593e-03
 	 4.75942308463234819981835244107060e-01 1.12417666413901384814266748435330e-01 4.27414632538647421000632675713859e-03
 	 3.78938688646978161234102344678831e-01 1.33226292543339341900576755506336e-01 4.91942295931540110598412240960897e-03
 	 2.86606086257527037375325562607031e-01 1.53032920443612274752354096563067e-01 5.26607455900590139263872657693355e-03
 	 2.02492755050103889757906472368632e-01 1.71076400314901788668464632792166e-01 5.23067181198556309384972706766348e-03
 	 1.29831025553591050680779517279007e-01 1.86663352285099226612885559006827e-01 4.77182856593368932840437679487877e-03
 	 7.14129531151586061099578728317283e-02 1.99194841634428132515211018471746e-01 3.89831786647766749542842745768212e-03
 	 2.94822986479423843064751054043882e-02 2.08189550428014014116229191131424e-01 2.67020404148049419340571475345314e-03
 	 5.64068897251168710482716051046737e-03 2.13303907428296635195863473200006e-01 1.19440062795979936964563261625472e-03
 	 9.85730545263174495751457016012864e-01 1.96620435431386908486928177808295e-03 2.37509086405655070418571628287907e-05
 	 9.52700409905833267565355981787434e-01 6.51746417194224575419880807203299e-03 1.38610061321351021651135382306563e-04
 	 9.02286700679378106393357938941335e-01 1.34640263515298785890195176762063e-02 3.98978302742909165991974651532814e-04
 	 8.36430960605610174241064669331536e-01 2.25383634777718278030533838318661e-02 8.30737959011477555652802617913721e-04
 	 7.57664739031342793218470887950389e-01 3.33916504945838965578985835236381e-02 1.42475906296478924996373738309785e-03
 	 6.69015195029959874872815817070659e-01 4.56067717194776345301931996800704e-02 2.13611314617339611773849661346958e-03
 	 5.73889160906685846796904115763027e-01 5.87142958646785229070985678845318e-02 2.88916433816553035532348481240206e-03
 	 4.75942308463234819981835244107060e-01 7.22105037659269699545916409988422e-02 3.58782913082752747541137594566862e-03
 	 3.78938688646978105722951113421004e-01 8.55767425735467490710561833111569e-02 4.12949105075330249320364472964684e-03
 	 2.86606086257527037375325562607031e-01 9.82993565914989098075693618739024e-02 4.42047938220802363873396245708136e-03
 	 2.02492755050103889757906472368632e-01 1.09889427909996451049323695769999e-01 4.39076139938734868323200188910960e-03
 	 1.29831025553591050680779517279007e-01 1.19901570038967841824728566280100e-01 4.00559649408441242890432931744726e-03
 	 7.14129531151586061099578728317283e-02 1.27951062505042401085120218340307e-01 3.27234898803079954712758059542921e-03
 	 2.94822986479423843064751054043882e-02 1.33728734946856442356022398598725e-01 2.24143843376977845369135700082097e-03
 	 5.64068897251168710482716051046737e-03 1.37013897388046701486530309921363e-01 1.00261082345733131861165166043293e-03
 	 9.85730545263174495751457016012864e-01 1.08300464368650192770182627555187e-03 1.82354122880782883262679172631238e-05
 	 9.52700409905833267565355981787434e-01 3.58988319183993487282435808083392e-03 1.06421680691137871487515764723497e-04
 	 9.02286700679378106393357938941335e-01 7.41611777505839231405815326070297e-03 3.06326547527885925756990781465561e-04
 	 8.36430960605610285263367131847190e-01 1.24143516689744215497626100841444e-02 6.37821879372539417285548069003198e-04
 	 7.57664739031342793218470887950389e-01 1.83924486112790885883327973715495e-02 1.09389789323531419831803113140722e-03
 	 6.69015195029959985895118279586313e-01 2.51206571928178634678374692157377e-02 1.64005952378285359619103367379012e-03
 	 5.73889160906685846796904115763027e-01 3.23404100559119278557318466482684e-02 2.21823525456526973037574279601358e-03
 	 4.75942308463234764470684012849233e-01 3.97742537442050125839898555568652e-02 2.75465433385877270233699221080315e-03
 	 3.78938688646978105722951113421004e-01 4.71365091809378133902441732061561e-02 3.17053014644677350758472655911646e-03
 	 2.86606086257527037375325562607031e-01 5.41442497705884040470891704899259e-02 3.39394442820751054967765014680481e-03
 	 2.02492755050103889757906472368632e-01 6.05281747329410313440689606068190e-02 3.37112763086698866143997577182745e-03
 	 1.29831025553591050680779517279007e-01 6.60429608207324658764036939828657e-02 3.07540669852751592447392958717955e-03
 	 7.14129531151586061099578728317283e-02 7.04767002237358664018529452732764e-02 2.51243579141638244400791535326789e-03
 	 2.94822986479423843064751054043882e-02 7.36590988744436625523803741089068e-02 1.72092590547572314892132983032980e-03
 	 5.64068897251168710482716051046737e-03 7.54685985692580274530882888939232e-02 7.69781990530143999176826419272857e-04
 	 9.85730545263174495751457016012864e-01 4.47537243966370998360382316150208e-04 1.19742741822318206454563160878735e-05
 	 9.52700409905833156543053519271780e-01 1.48347141372212609766734203731176e-03 6.98817423701859853288342883104178e-05
 	 9.02286700679378106393357938941335e-01 3.06461189185851246019609561699326e-03 2.01149171263509906042860064800948e-04
 	 8.36430960605610174241064669331536e-01 5.13006547474267882158471820730483e-03 4.18825411917135169339448941272508e-04
 	 7.57664739031342904240773350466043e-01 7.60043441112673301418567461951170e-03 7.18307493904530940630193125429059e-04
 	 6.69015195029960096917420742101967e-01 1.03807769913422665020164004090475e-02 1.07694425016074111535469004508059e-03
 	 5.73889160906685846796904115763027e-01 1.33642436988061219516055189160397e-02 1.45660304901483027978370543564779e-03
 	 4.75942308463234819981835244107060e-01 1.64361805882092815167538901732769e-02 1.80884236395700208170633782600589e-03
 	 3.78938688646978105722951113421004e-01 1.94785345861719916271681540820282e-02 2.08192700427208910243792594485512e-03
 	 2.86606086257527037375325562607031e-01 2.23743900455243283076356419769581e-02 2.22863187848973583193856740081173e-03
 	 2.02492755050103889757906472368632e-01 2.50124620057831092978517517622095e-02 2.21364924014848815994604969148440e-03
 	 1.29831025553591050680779517279007e-01 2.72913739025900659029844064207282e-02 2.01946424069151999475257852623145e-03
 	 7.14129531151586061099578728317283e-02 2.91235576558663833424134281813167e-02 1.64978968154949135263565018760801e-03
 	 2.94822986479423843064751054043882e-02 3.04386415104397345388065332372207e-02 1.13004511847225640533420865097014e-03
 	 5.64068897251168710482716051046737e-03 3.11863931577628372693311575858388e-02 5.05476951633184292192457753856161e-04
 	 9.85730545263174495751457016012864e-01 8.56701103049660461774550412883400e-05 5.23331585046430200350645045581643e-06
 	 9.52700409905833267565355981787434e-01 2.83974487847067635915010441749473e-04 3.05415780896870931999768916664806e-05
 	 9.02286700679377995371055476425681e-01 5.86645340375641088925817712151911e-04 8.79115619252408142395363577215051e-05
 	 8.36430960605610174241064669331536e-01 9.82026146467335214751415151113179e-04 1.83046223379082316625940385357296e-04
 	 7.57664739031342682196168425434735e-01 1.45491813954107263029413843469229e-03 3.13933849864228488747014411686109e-04
 	 6.69015195029959985895118279586313e-01 1.98714704058544633369365328690037e-03 4.70674825769033583142131327292645e-04
 	 5.73889160906685846796904115763027e-01 2.55825911084439638898402336053550e-03 6.36603413971865267871608207173040e-04
 	 4.75942308463234819981835244107060e-01 3.14630664367687717941635128227063e-03 7.90548409884759672311416167644893e-04
 	 3.78938688646978105722951113421004e-01 3.72869125212260676960340788355097e-03 9.09899124168547660321260117655129e-04
 	 2.86606086257527037375325562607031e-01 4.28303228177906447626810404472053e-03 9.74015991036589006378532129559744e-04
 	 2.02492755050103889757906472368632e-01 4.78802693613411545214830766781233e-03 9.67467879850912679945418304328086e-04
 	 1.29831025553591050680779517279007e-01 5.22426913989904040391820672084577e-03 8.82599985553945498920058732039706e-04
 	 7.14129531151586061099578728317283e-02 5.57499611594025612504310629446991e-03 7.21034975397246650358207276099165e-04
 	 2.94822986479423843064751054043882e-02 5.82673690489243778500849657575600e-03 4.93882379861992838916695536255475e-04
 	 5.64068897251168710482716051046737e-03 5.96987575416252358451174586662091e-03 2.20916984425796207374900759212721e-04
 	 ];
 
 	 case  29 

 	 % ALG. DEG.:   29
 	 % PTS CARD.:  225
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-15  

 	 xyw=[
 	 9.85730545263174495751457016012864e-01 1.41837846265205382023655289458475e-02 5.23331585046430369757234496441711e-06
 	 9.52700409905833267565355981787434e-01 4.70156156063196647987290077708167e-02 3.05415780896870999762404697008833e-05
 	 9.02286700679377995371055476425681e-01 9.71266539802462941510796667898830e-02 8.79115619252408413445906698591159e-05
 	 8.36430960605610174241064669331536e-01 1.62587013247922435033032684259524e-01 1.83046223379082343730994697494907e-04
 	 7.57664739031342682196168425434735e-01 2.40880342829116134151234973614919e-01 3.13933849864228542957123035961331e-04
 	 6.69015195029960096917420742101967e-01 3.28997657929454512260036835868959e-01 4.70674825769033691562348575843089e-04
 	 5.73889160906685846796904115763027e-01 4.23552579982469701302960629618610e-01 6.36603413971865484712042704273927e-04
 	 4.75942308463234819981835244107060e-01 5.20911384893088302838748404610669e-01 7.90548409884759889151850664745780e-04
 	 3.78938688646978105722951113421004e-01 6.17332620100899287507445478695445e-01 9.09899124168547877161694614756016e-04
 	 2.86606086257527037375325562607031e-01 7.09110881460693898148406333348248e-01 9.74015991036589223218966626660631e-04
 	 2.02492755050103889757906472368632e-01 7.92719218013761994789945219963556e-01 9.67467879850912896785852801428973e-04
 	 1.29831025553591050680779517279007e-01 8.64944705306509908915302276000148e-01 8.82599985553945715760493229140593e-04
 	 7.14129531151586061099578728317283e-02 9.23012050768901137764999020873802e-01 7.21034975397246867198641773200052e-04
 	 2.94822986479423843064751054043882e-02 9.64690964447165177908516398019856e-01 4.93882379861992947336912784805918e-04
 	 5.64068897251168710482716051046737e-03 9.88389435273325678288358631107258e-01 2.20916984425796261585009383487943e-04
 	 9.85730545263174495751457016012864e-01 1.38219174928591332501826016709856e-02 1.19742741822318189513904215792728e-05
 	 9.52700409905833156543053519271780e-01 4.58161186804446063369766761752544e-02 6.98817423701859717763071322416124e-05
 	 9.02286700679378106393357938941335e-01 9.46486874287634366575971966994985e-02 2.01149171263509878937805752663337e-04
 	 8.36430960605610174241064669331536e-01 1.58438973919647091426199381203332e-01 4.18825411917135060919231692722065e-04
 	 7.57664739031342793218470887950389e-01 2.34734826557530446011767821801186e-01 7.18307493904530723789758628328173e-04
 	 6.69015195029959985895118279586313e-01 3.20604027978697692091714088746812e-01 1.07694425016074089851425554797970e-03
 	 5.73889160906685846796904115763027e-01 4.12746595394508031251490365320933e-01 1.45660304901483006294327093854690e-03
 	 4.75942308463234819981835244107060e-01 5.07621510948555898501410865719663e-01 1.80884236395700164802546883180412e-03
 	 3.78938688646978105722951113421004e-01 6.01582776766849902649880732496968e-01 2.08192700427208866875705695065335e-03
 	 2.86606086257527037375325562607031e-01 6.91019523696948523294736332900357e-01 2.22863187848973539825769840660996e-03
 	 2.02492755050103889757906472368632e-01 7.72494782944113000944241775869159e-01 2.21364924014848772626518069728263e-03
 	 1.29831025553591050680779517279007e-01 8.42877600543818883416236076300265e-01 2.01946424069151956107170953202967e-03
 	 7.14129531151586061099578728317283e-02 8.99463489228975010547628698986955e-01 1.64978968154949113579521569050712e-03
 	 2.94822986479423843064751054043882e-02 9.40079059841617881154718361358391e-01 1.13004511847225618849377415386925e-03
 	 5.64068897251168710482716051046737e-03 9.63172917869725475625841681903694e-01 5.05476951633184183772240505305717e-04
 	 9.85730545263174495751457016012864e-01 1.31864500931389988513942057579698e-02 1.82354122880784035227487438479699e-05
 	 9.52700409905833267565355981787434e-01 4.37097069023267836840318523172755e-02 1.06421680691138535561346412094963e-04
 	 9.02286700679377995371055476425681e-01 9.02971815455635429259473312413320e-02 3.06326547527887823110792631098320e-04
 	 8.36430960605610285263367131847190e-01 1.51154687725415320942445873697579e-01 6.37821879372543428833586265369604e-04
 	 7.57664739031342682196168425434735e-01 2.23942812357378062682045083420235e-01 1.09389789323532092037150054153472e-03
 	 6.69015195029959985895118279586313e-01 3.05864147777222039614741788682295e-01 1.64005952378286378769145503753180e-03
 	 5.73889160906685846796904115763027e-01 3.93770429037402169836212806330877e-01 2.21823525456528360816355061047034e-03
 	 4.75942308463234875492986475364887e-01 4.84283437792560056411872437820421e-01 2.75465433385878961589088298467232e-03
 	 3.78938688646978105722951113421004e-01 5.73924802172083969864502250857186e-01 3.17053014644679345690470029239805e-03
 	 2.86606086257527037375325562607031e-01 6.59249663971884336532980341871735e-01 3.39394442820753180004023086269171e-03
 	 2.02492755050103889757906472368632e-01 7.36979070216954967875722104508895e-01 3.37112763086700947812168749351258e-03
 	 1.29831025553591050680779517279007e-01 8.04126013625676261398211863706820e-01 3.07540669852753500643216533205759e-03
 	 7.14129531151586061099578728317283e-02 8.58110346661105305443584256863687e-01 2.51243579141639805651919914453174e-03
 	 2.94822986479423843064751054043882e-02 8.96858602477613731096539595455397e-01 1.72092590547573377410262018827325e-03
 	 5.64068897251168710482716051046737e-03 9.18890712458230063397479625564301e-01 7.69781990530148769666385355492366e-04
 	 9.85730545263174495751457016012864e-01 1.23032503825116368983971781858600e-02 2.37509086405654765486710616739785e-05
 	 9.52700409905833267565355981787434e-01 4.07821259222244936193391140477615e-02 1.38610061321350859020809509480898e-04
 	 9.02286700679377995371055476425681e-01 8.42492729690920982843493902691989e-02 3.98978302742908678100997033055819e-04
 	 8.36430960605610174241064669331536e-01 1.41030675916617970200306331207685e-01 8.30737959011476579870847380959731e-04
 	 7.57664739031342793218470887950389e-01 2.08943610474073365734781759783800e-01 1.42475906296478751524026140629076e-03
 	 6.69015195029959985895118279586313e-01 2.85378033250562435085839751991443e-01 2.13611314617339351565328264825894e-03
 	 5.73889160906685846796904115763027e-01 3.67396543228635685807148547610268e-01 2.88916433816552688587653285878787e-03
 	 4.75942308463234819981835244107060e-01 4.51847187770838321085875577409752e-01 3.58782913082752313860268600365089e-03
 	 3.78938688646978105722951113421004e-01 5.35484568779475256228295165783493e-01 4.12949105075329728903321679922556e-03
 	 2.86606086257527037375325562607031e-01 6.15094557150974163839407538034720e-01 4.42047938220801843456353452666008e-03
 	 2.02492755050103889757906472368632e-01 6.87617817039899770215072294377023e-01 4.39076139938734347906157395868831e-03
 	 1.29831025553591050680779517279007e-01 7.50267404407441329539096841472201e-01 4.00559649408440809209563937542953e-03
 	 7.14129531151586061099578728317283e-02 8.00635984379799214849526833859272e-01 3.27234898803079564399975964761325e-03
 	 2.94822986479423843064751054043882e-02 8.36788966405201284359804958512541e-01 2.24143843376977541792527404140856e-03
 	 5.64068897251168710482716051046737e-03 8.57345413639441722430944992083823e-01 1.00261082345733023440947917492849e-03
 	 9.85730545263174495751457016012864e-01 1.12084581549249870380258187196887e-02 2.82942289582358922077516549808962e-05
 	 9.52700409905833267565355981787434e-01 3.71531699068632231819364619695989e-02 1.65124832497694451439659846236907e-04
 	 9.02286700679377995371055476425681e-01 7.67524370632329810959504357015248e-02 4.75299013524707115226769493787629e-04
 	 8.36430960605610174241064669331536e-01 1.28481204594448117362048833456356e-01 9.89650138118196905784307304543290e-04
 	 7.57664739031342793218470887950389e-01 1.90350975711794379030550317111192e-01 1.69730176423631509176337406330504e-03
 	 6.69015195029959985895118279586313e-01 2.59983959082098703419205776299350e-01 2.54473103969165117058115477277624e-03
 	 5.73889160906685846796904115763027e-01 3.34704135331235663741722419217695e-01 3.44183367967682094651360458215095e-03
 	 4.75942308463234819981835244107060e-01 4.11640025122863795203898007457610e-01 4.27414632538645773013330497747120e-03
 	 3.78938688646978105722951113421004e-01 4.87835018809682607887623362330487e-01 4.91942295931538202402588666473093e-03
 	 2.86606086257527037375325562607031e-01 5.60360993298860798894622803345555e-01 5.26607455900588057595701485524842e-03
 	 2.02492755050103889757906472368632e-01 6.26430844634994321573628894839203e-01 5.23067181198554314452975333438189e-03
 	 1.29831025553591050680779517279007e-01 6.83505622161309722706334923714167e-01 4.77182856593367111380787903840428e-03
 	 7.14129531151586061099578728317283e-02 7.29392205250413372397133571212180e-01 3.89831786647765231659801266062004e-03
 	 2.94822986479423843064751054043882e-02 7.62328150924043601577295703464188e-01 2.67020404148048378506485889261057e-03
 	 5.64068897251179812712962302612141e-03 7.81055403599191677699309366289526e-01 1.19440062795979481599650817713609e-03
 	 9.85730545263174495751457016012864e-01 9.94688977170379851067139043152565e-03 3.16792392893965990118693154542484e-05
 	 9.52700409905833267565355981787434e-01 3.29713936229995632776201830438367e-02 1.84879718370743766813271702353916e-04
 	 9.02286700679377995371055476425681e-01 6.81135639376191370786273182602599e-02 5.32161919156327401295158985305989e-04
 	 8.36430960605610174241064669331536e-01 1.14019998305935774118857750636380e-01 1.10804799044029057136784288672970e-03
 	 7.57664739031342793218470887950389e-01 1.68926015261923190280413109576330e-01 1.90036027540895673462739701164992e-03
 	 6.69015195029960096917420742101967e-01 2.30721455855592949557575366270612e-01 2.84917265823147070752385801029050e-03
 	 5.73889160906685846796904115763027e-01 2.97031500163147388349216271308251e-01 3.85360113165580985342129061166361e-03
 	 4.75942308463234819981835244107060e-01 3.65307868301169680336215606075712e-01 4.78548839057160550758407424609686e-03
 	 3.78938688646978105722951113421004e-01 4.32926731920286744781378729385324e-01 5.50796338447457657638839378932971e-03
 	 2.86606086257527037375325562607031e-01 4.97289542920501870248983777855756e-01 5.89608701890395343198081334890048e-03
 	 2.02492755050103889757906472368632e-01 5.55922899925507030260973806434777e-01 5.85644882639428220744148845255950e-03
 	 1.29831025553591050680779517279007e-01 6.06573623954781426803606336761732e-01 5.34271137804548639643753560335426e-03
 	 7.14129531151586061099578728317283e-02 6.47295441146639172202981171722058e-01 4.36469729217796569703535780604398e-03
 	 2.94822986479423843064751054043882e-02 6.76524280351295859148308409203310e-01 2.98965675673419075883407991511831e-03
 	 5.64068897251157608252469799481332e-03 6.93143686474045450651715327694546e-01 1.33729402403560070598798059648971e-03
 	 9.85730545263174495751457016012864e-01 8.57019237721925487838436907850337e-03 3.37673224021273988225931572682015e-05
 	 9.52700409905833267565355981787434e-01 2.84079941348063143291557963721061e-02 1.97065750184506079502669284586602e-04
 	 9.02286700679377995371055476425681e-01 5.86863190244673038620248917140998e-02 5.67238465864968637378251692382491e-04
 	 8.36430960605610285263367131847190e-01 9.82390820406873338521691607638786e-02 1.18108308688934238173118274062290e-03
 	 7.57664739031342682196168425434735e-01 1.45545842121439006344729705233476e-01 2.02561928693181445004789509312104e-03
 	 6.69015195029959985895118279586313e-01 1.98788496466452357935850159265101e-01 3.03697102228179605445945732355995e-03
 	 5.73889160906685846796904115763027e-01 2.55920911653589988610235650412505e-01 4.10760468813969620988091335789250e-03
 	 4.75942308463234875492986475364887e-01 3.14747501993945799636520632702741e-01 5.10091570886161450870677214197713e-03
 	 3.78938688646978105722951113421004e-01 3.73007589603775779885097563237650e-01 5.87101141172030951964622147443151e-03
 	 2.86606086257527092886476793864858e-01 4.28462277940586833135938604755211e-01 6.28471755459631287871191673843896e-03
 	 2.02492755050103889757906472368632e-01 4.78980496276990241888427135563688e-01 6.24246667812530971197748641543512e-03
 	 1.29831025553591050680779517279007e-01 5.22620916442415373026619818119798e-01 5.69486710068701877662800114876518e-03
 	 7.14129531151586061099578728317283e-02 5.57706638240295093922327396285255e-01 4.65238888176197282198209848047554e-03
 	 2.94822986479423843064751054043882e-02 5.82890065492028708327154618018540e-01 3.18671489091381038641359602081593e-03
 	 5.64068897251168710482716051046737e-03 5.97209265858788418412927967438009e-01 1.42543948241721026189143817219929e-03
 	 9.85730545263174495751457016012864e-01 7.13472736841275299163322998197145e-03 3.44729809157055052011575657644471e-05
 	 9.52700409905833267565355981787434e-01 2.36497950470833696867689610598973e-02 2.01183966094441331589476318342236e-04
 	 9.02286700679377995371055476425681e-01 4.88566496603109814977905500654742e-02 5.79092430710027882868884407940868e-04
 	 8.36430960605610174241064669331536e-01 8.17845196971948990016798575197754e-02 1.20576497684144780253578943529646e-03
 	 7.57664739031342793218470887950389e-01 1.21167630484328617268552363839262e-01 2.06795001952793508145922452001741e-03
 	 6.69015195029959985895118279586313e-01 1.65492402485020034808016475835757e-01 3.10043665428666416136738170905573e-03
 	 5.73889160906685846796904115763027e-01 2.13055419546657104357123557747400e-01 4.19344407404304876652023637007005e-03
 	 4.75942308463234764470684012849233e-01 2.62028845768382645520233609204297e-01 5.20751298519098529404836028788850e-03
 	 3.78938688646978161234102344678831e-01 3.10530655676511002649675674547325e-01 5.99370189741110521303157909756010e-03
 	 2.86606086257527092886476793864858e-01 3.56696956871236536823488449954311e-01 6.41605353661528574754635556587345e-03
 	 2.02492755050103945269057703626459e-01 3.98753622474948110632197995073511e-01 6.37291971507884802417009950659121e-03
 	 1.29831025553590995169628286021180e-01 4.35084487223204530170761472618324e-01 5.81387657989412658110506271214035e-03
 	 7.14129531151586616211091040895553e-02 4.64293523442420752456172294841963e-01 4.74961299043707031036776200494387e-03
 	 2.94822986479424398176263366622152e-02 4.85258850676028863357913678555633e-01 3.25330982154940599737624751242038e-03
 	 5.64068897251168710482716051046737e-03 4.97179655513744211958737651002593e-01 1.45522785279432681840305896514565e-03
 	 9.85730545263174495751457016012864e-01 5.69926235960624590071166295501826e-03 3.37673224021275479003918740250612e-05
 	 9.52700409905833267565355981787434e-01 1.88915959593604076971473659796175e-02 1.97065750184506946864407272990150e-04
 	 9.02286700679378106393357938941335e-01 3.90269802961546244390866888807068e-02 5.67238465864971022623031160492246e-04
 	 8.36430960605610285263367131847190e-01 6.53299573537023947622515152033884e-02 1.18108308688934736906117617394329e-03
 	 7.57664739031342793218470887950389e-01 9.67894188472181449256481755583081e-02 2.02561928693182312366527497715651e-03
 	 6.69015195029959985895118279586313e-01 1.32196308503587572902304714261845e-01 3.03697102228180906488552714961315e-03
 	 5.73889160906685846796904115763027e-01 1.70189927439724053570557771308813e-01 4.10760468813971355711567312596344e-03
 	 4.75942308463234875492986475364887e-01 2.09310189542819269359341660674545e-01 5.10091570886163619275022185206581e-03
 	 3.78938688646978161234102344678831e-01 2.48053721749245947858497629567864e-01 5.87101141172033554049836112653793e-03
 	 2.86606086257527037375325562607031e-01 2.84931635801885962955282138864277e-01 6.28471755459633976692579437894892e-03
 	 2.02492755050103945269057703626459e-01 3.18526748672905701820212698294199e-01 6.24246667812533660019136405594509e-03
 	 1.29831025553591050680779517279007e-01 3.47548058003993354247995739569888e-01 5.69486710068704393011840281246805e-03
 	 7.14129531151586061099578728317283e-02 3.70880408644546077923109805851709e-01 4.65238888176199363866381020216068e-03
 	 2.94822986479423843064751054043882e-02 3.87627635860028685321765351545764e-01 3.18671489091382426420140383527269e-03
 	 5.64068897251168710482716051046737e-03 3.97150045168699672437639947020216e-01 1.42543948241721655026403858812500e-03
 	 9.85730545263174495751457016012864e-01 4.32256496512170920731854550922435e-03 3.16792392893965854593421593854430e-05
 	 9.52700409905833156543053519271780e-01 1.43281964711671760959177390759578e-02 1.84879718370743685498108765941083e-04
 	 9.02286700679377995371055476425681e-01 2.95997353830028397947415896851453e-02 5.32161919156327184454724488205102e-04
 	 8.36430960605610174241064669331536e-01 4.95490410884540377622897722176276e-02 1.10804799044029013768697389252793e-03
 	 7.57664739031342793218470887950389e-01 7.34092457067340997678428493600222e-02 1.90036027540895586726565902324637e-03
 	 6.69015195029959985895118279586313e-01 1.00263349114447120058457585400902e-01 2.84917265823146940648125102768518e-03
 	 5.73889160906685846796904115763027e-01 1.29079338930166820365030844186549e-01 3.85360113165580811869781463485651e-03
 	 4.75942308463234819981835244107060e-01 1.58749823235595610704251612332882e-01 4.78548839057160290549886028088622e-03
 	 3.78938688646978105722951113421004e-01 1.88134579432735260517972619709326e-01 5.50796338447457397430317982411907e-03
 	 2.86606086257527037375325562607031e-01 2.16104370821971203397993122052867e-01 5.89608701890395082989559938368984e-03
 	 2.02492755050103889757906472368632e-01 2.41584345024389302025724646227900e-01 5.85644882639427960535627448734886e-03
 	 1.29831025553591050680779517279007e-01 2.63595350491627633537916608474916e-01 5.34271137804548379435232163814362e-03
 	 7.14129531151586061099578728317283e-02 2.81291605738202443731665880477522e-01 4.36469729217796309495014384083333e-03
 	 2.94822986479423843064751054043882e-02 2.93993421000762089612123872939264e-01 2.98965675673418902411060393831121e-03
 	 5.64068897251168710482716051046737e-03 3.01215624553443195310364899341948e-01 1.33729402403560027230711160228793e-03
 	 9.85730545263174495751457016012864e-01 3.06099658190051894524064124425422e-03 2.82942289582360006279689035313396e-05
 	 9.52700409905833267565355981787434e-01 1.01464201873035092527075562429673e-02 1.65124832497695074855909025401957e-04
 	 9.02286700679377995371055476425681e-01 2.09608622573889818996306644294236e-02 4.75299013524708904160354094869945e-04
 	 8.36430960605610174241064669331536e-01 3.50878347999416528857352659542812e-02 9.89650138118200808912128252359253e-04
 	 7.57664739031342793218470887950389e-01 5.19842852568628555065544105673325e-02 1.69730176423632159697640897633164e-03
 	 6.69015195029959874872815817070659e-01 7.10008458879413661968271753721638e-02 2.54473103969166114524114163941704e-03
 	 5.73889160906685846796904115763027e-01 9.14067037620784894613734650192782e-02 3.44183367967683439062054340240593e-03
 	 4.75942308463234819981835244107060e-01 1.12417666413901384814266748435330e-01 4.27414632538647421000632675713859e-03
 	 3.78938688646978161234102344678831e-01 1.33226292543339341900576755506336e-01 4.91942295931540110598412240960897e-03
 	 2.86606086257527037375325562607031e-01 1.53032920443612274752354096563067e-01 5.26607455900590139263872657693355e-03
 	 2.02492755050103889757906472368632e-01 1.71076400314901788668464632792166e-01 5.23067181198556309384972706766348e-03
 	 1.29831025553591050680779517279007e-01 1.86663352285099226612885559006827e-01 4.77182856593368932840437679487877e-03
 	 7.14129531151586061099578728317283e-02 1.99194841634428132515211018471746e-01 3.89831786647766749542842745768212e-03
 	 2.94822986479423843064751054043882e-02 2.08189550428014014116229191131424e-01 2.67020404148049419340571475345314e-03
 	 5.64068897251168710482716051046737e-03 2.13303907428296635195863473200006e-01 1.19440062795979936964563261625472e-03
 	 9.85730545263174495751457016012864e-01 1.96620435431386908486928177808295e-03 2.37509086405655070418571628287907e-05
 	 9.52700409905833267565355981787434e-01 6.51746417194224575419880807203299e-03 1.38610061321351021651135382306563e-04
 	 9.02286700679378106393357938941335e-01 1.34640263515298785890195176762063e-02 3.98978302742909165991974651532814e-04
 	 8.36430960605610174241064669331536e-01 2.25383634777718278030533838318661e-02 8.30737959011477555652802617913721e-04
 	 7.57664739031342793218470887950389e-01 3.33916504945838965578985835236381e-02 1.42475906296478924996373738309785e-03
 	 6.69015195029959874872815817070659e-01 4.56067717194776345301931996800704e-02 2.13611314617339611773849661346958e-03
 	 5.73889160906685846796904115763027e-01 5.87142958646785229070985678845318e-02 2.88916433816553035532348481240206e-03
 	 4.75942308463234819981835244107060e-01 7.22105037659269699545916409988422e-02 3.58782913082752747541137594566862e-03
 	 3.78938688646978105722951113421004e-01 8.55767425735467490710561833111569e-02 4.12949105075330249320364472964684e-03
 	 2.86606086257527037375325562607031e-01 9.82993565914989098075693618739024e-02 4.42047938220802363873396245708136e-03
 	 2.02492755050103889757906472368632e-01 1.09889427909996451049323695769999e-01 4.39076139938734868323200188910960e-03
 	 1.29831025553591050680779517279007e-01 1.19901570038967841824728566280100e-01 4.00559649408441242890432931744726e-03
 	 7.14129531151586061099578728317283e-02 1.27951062505042401085120218340307e-01 3.27234898803079954712758059542921e-03
 	 2.94822986479423843064751054043882e-02 1.33728734946856442356022398598725e-01 2.24143843376977845369135700082097e-03
 	 5.64068897251168710482716051046737e-03 1.37013897388046701486530309921363e-01 1.00261082345733131861165166043293e-03
 	 9.85730545263174495751457016012864e-01 1.08300464368650192770182627555187e-03 1.82354122880782883262679172631238e-05
 	 9.52700409905833267565355981787434e-01 3.58988319183993487282435808083392e-03 1.06421680691137871487515764723497e-04
 	 9.02286700679378106393357938941335e-01 7.41611777505839231405815326070297e-03 3.06326547527885925756990781465561e-04
 	 8.36430960605610285263367131847190e-01 1.24143516689744215497626100841444e-02 6.37821879372539417285548069003198e-04
 	 7.57664739031342793218470887950389e-01 1.83924486112790885883327973715495e-02 1.09389789323531419831803113140722e-03
 	 6.69015195029959985895118279586313e-01 2.51206571928178634678374692157377e-02 1.64005952378285359619103367379012e-03
 	 5.73889160906685846796904115763027e-01 3.23404100559119278557318466482684e-02 2.21823525456526973037574279601358e-03
 	 4.75942308463234764470684012849233e-01 3.97742537442050125839898555568652e-02 2.75465433385877270233699221080315e-03
 	 3.78938688646978105722951113421004e-01 4.71365091809378133902441732061561e-02 3.17053014644677350758472655911646e-03
 	 2.86606086257527037375325562607031e-01 5.41442497705884040470891704899259e-02 3.39394442820751054967765014680481e-03
 	 2.02492755050103889757906472368632e-01 6.05281747329410313440689606068190e-02 3.37112763086698866143997577182745e-03
 	 1.29831025553591050680779517279007e-01 6.60429608207324658764036939828657e-02 3.07540669852751592447392958717955e-03
 	 7.14129531151586061099578728317283e-02 7.04767002237358664018529452732764e-02 2.51243579141638244400791535326789e-03
 	 2.94822986479423843064751054043882e-02 7.36590988744436625523803741089068e-02 1.72092590547572314892132983032980e-03
 	 5.64068897251168710482716051046737e-03 7.54685985692580274530882888939232e-02 7.69781990530143999176826419272857e-04
 	 9.85730545263174495751457016012864e-01 4.47537243966370998360382316150208e-04 1.19742741822318206454563160878735e-05
 	 9.52700409905833156543053519271780e-01 1.48347141372212609766734203731176e-03 6.98817423701859853288342883104178e-05
 	 9.02286700679378106393357938941335e-01 3.06461189185851246019609561699326e-03 2.01149171263509906042860064800948e-04
 	 8.36430960605610174241064669331536e-01 5.13006547474267882158471820730483e-03 4.18825411917135169339448941272508e-04
 	 7.57664739031342904240773350466043e-01 7.60043441112673301418567461951170e-03 7.18307493904530940630193125429059e-04
 	 6.69015195029960096917420742101967e-01 1.03807769913422665020164004090475e-02 1.07694425016074111535469004508059e-03
 	 5.73889160906685846796904115763027e-01 1.33642436988061219516055189160397e-02 1.45660304901483027978370543564779e-03
 	 4.75942308463234819981835244107060e-01 1.64361805882092815167538901732769e-02 1.80884236395700208170633782600589e-03
 	 3.78938688646978105722951113421004e-01 1.94785345861719916271681540820282e-02 2.08192700427208910243792594485512e-03
 	 2.86606086257527037375325562607031e-01 2.23743900455243283076356419769581e-02 2.22863187848973583193856740081173e-03
 	 2.02492755050103889757906472368632e-01 2.50124620057831092978517517622095e-02 2.21364924014848815994604969148440e-03
 	 1.29831025553591050680779517279007e-01 2.72913739025900659029844064207282e-02 2.01946424069151999475257852623145e-03
 	 7.14129531151586061099578728317283e-02 2.91235576558663833424134281813167e-02 1.64978968154949135263565018760801e-03
 	 2.94822986479423843064751054043882e-02 3.04386415104397345388065332372207e-02 1.13004511847225640533420865097014e-03
 	 5.64068897251168710482716051046737e-03 3.11863931577628372693311575858388e-02 5.05476951633184292192457753856161e-04
 	 9.85730545263174495751457016012864e-01 8.56701103049660461774550412883400e-05 5.23331585046430200350645045581643e-06
 	 9.52700409905833267565355981787434e-01 2.83974487847067635915010441749473e-04 3.05415780896870931999768916664806e-05
 	 9.02286700679377995371055476425681e-01 5.86645340375641088925817712151911e-04 8.79115619252408142395363577215051e-05
 	 8.36430960605610174241064669331536e-01 9.82026146467335214751415151113179e-04 1.83046223379082316625940385357296e-04
 	 7.57664739031342682196168425434735e-01 1.45491813954107263029413843469229e-03 3.13933849864228488747014411686109e-04
 	 6.69015195029959985895118279586313e-01 1.98714704058544633369365328690037e-03 4.70674825769033583142131327292645e-04
 	 5.73889160906685846796904115763027e-01 2.55825911084439638898402336053550e-03 6.36603413971865267871608207173040e-04
 	 4.75942308463234819981835244107060e-01 3.14630664367687717941635128227063e-03 7.90548409884759672311416167644893e-04
 	 3.78938688646978105722951113421004e-01 3.72869125212260676960340788355097e-03 9.09899124168547660321260117655129e-04
 	 2.86606086257527037375325562607031e-01 4.28303228177906447626810404472053e-03 9.74015991036589006378532129559744e-04
 	 2.02492755050103889757906472368632e-01 4.78802693613411545214830766781233e-03 9.67467879850912679945418304328086e-04
 	 1.29831025553591050680779517279007e-01 5.22426913989904040391820672084577e-03 8.82599985553945498920058732039706e-04
 	 7.14129531151586061099578728317283e-02 5.57499611594025612504310629446991e-03 7.21034975397246650358207276099165e-04
 	 2.94822986479423843064751054043882e-02 5.82673690489243778500849657575600e-03 4.93882379861992838916695536255475e-04
 	 5.64068897251168710482716051046737e-03 5.96987575416252358451174586662091e-03 2.20916984425796207374900759212721e-04
 	 ];
 
 	 case  30 

 	 % ALG. DEG.:   30
 	 % PTS CARD.:  256
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.87353020626041910645653842948377e-01 1.25799562956861680357301125354752e-02 3.63155544166100516378513536619455e-06
 	 9.58024417690475416087281246291241e-01 4.17531313466935269373969674688851e-02 2.12765107099393359401176550882440e-05
 	 9.13108376537141497308880389027763e-01 8.64311384799765491937506567410310e-02 6.16256615625745588589110002253335e-05
 	 8.54138147775210576639892678940669e-01 1.45088852597804990329777297120017e-01 1.29438053256620633560403099693303e-04
 	 7.83122553964867962328355588397244e-01 2.15728096960446341645578627321811e-01 2.24545196451842084001820909477942e-04
 	 7.02480137925040937219023362558801e-01 2.95943145895255110833232947697979e-01 3.41567527877144317370594617244706e-04
 	 6.14957151876489360731170563667547e-01 3.83002301034379877275881653986289e-01 4.70386716687481217652466725098748e-04
 	 5.23534116025168305696979587082751e-01 4.73940837535576642292056703809067e-01 5.97318567058440462458346331686698e-04
 	 4.31324343595625214753397358435905e-01 5.65661941278926772014301604940556e-01 7.06834694805965517774848372312135e-04
 	 3.41467927547823069112098437472014e-01 6.55042160329174838473420550144510e-01 7.83604767941286977847581418643585e-04
 	 2.57024807845170899511799689207692e-01 7.39037770974208862995169511123095e-01 8.14585388510028342128055367510342e-04
 	 1.80870559657883900328556592285167e-01 8.14788437247896402126912107632961e-01 7.90872946430338911484592134826244e-04
 	 1.15598437579815915832170958310599e-01 8.79714647593395127067594785330584e-01 7.09067394843235546640636268733715e-04
 	 6.34309455838367730606819350214209e-02 9.31605676269880333961737051140517e-01 5.71958834771182857321936143790708e-04
 	 2.61435136813938928668221706175245e-02 9.68695502214958925613075280125486e-01 3.88449228812296929944092305220238e-04
 	 4.99729966377193690618696564342827e-03 9.89729651184054315393723300076090e-01 1.72951807778499652701320599135215e-04
 	 9.87353020626041910645653842948377e-01 1.22965001039606249694235984293300e-02 8.32621164048595707837981116927750e-06
 	 9.58024417690475527109583708806895e-01 4.08123344690280165369955511778244e-02 4.87815025786842148278546482664808e-05
 	 9.13108376537141497308880389027763e-01 8.44836403500793670096058463059308e-02 1.41291606006783206517934958768024e-04
 	 8.54138147775210576639892678940669e-01 1.41819657327762166376672325895925e-01 2.96767774321568154286682394982222e-04
 	 7.83122553964868073350658050912898e-01 2.10867232313915270447424177291396e-01 5.14823705309427588974746647920711e-04
 	 7.02480137925040937219023362558801e-01 2.89274846329579227166561850026483e-01 7.83125460235825328683678669960955e-04
 	 6.14957151876489360731170563667547e-01 3.74372352636979377482617792338715e-01 1.07847433942022483815970090859082e-03
 	 5.23534116025168305696979587082751e-01 4.63261828661983343646824096140335e-01 1.36949604267796553984382068591685e-03
 	 4.31324343595625214753397358435905e-01 5.52916238836861473338046835124260e-01 1.62058802580223411046733694718114e-03
 	 3.41467927547823069112098437472014e-01 6.40282509991577875041457446059212e-01 1.79660182673374666656451736912459e-03
 	 2.57024807845170899511799689207692e-01 7.22385500713658146310081065166742e-01 1.86763232805825670455879272680022e-03
 	 1.80870559657883900328556592285167e-01 7.96429325176617353143626587552717e-01 1.81326586871598748572365078501889e-03
 	 1.15598437579815915832170958310599e-01 8.59892594324616288403717589972075e-01 1.62570702600439774380969293332555e-03
 	 6.34309455838367730606819350214209e-02 9.10614395300493151275134096067632e-01 1.31135277554029106190924824915101e-03
 	 2.61435136813938928668221706175245e-02 9.46868499676510433360476781672332e-01 8.90613001131941063592822871441967e-04
 	 4.99729966377193690618696564342827e-03 9.67428699482124732078602846740978e-01 3.96533490484118618206454964791874e-04
 	 9.87353020626041910645653842948377e-01 1.17972996680057694296461789917885e-02 1.27271495255903451779321347570040e-05
 	 9.58024417690475416087281246291241e-01 3.91554780475238256576275830411760e-02 7.45656613366663535268780149678491e-05
 	 9.13108376537141497308880389027763e-01 8.10538619792217224224728511217108e-02 2.15973299022960608549090433250228e-04
 	 8.54138147775210576639892678940669e-01 1.36062211374325059409784444142133e-01 4.53628613017913260695851418446978e-04
 	 7.83122553964868073350658050912898e-01 2.02306665208662694865893172391225e-01 7.86941115564668280946136746933917e-04
 	 7.02480137925040937219023362558801e-01 2.77531169008583822321867273785756e-01 1.19705758874228979787845972282412e-03
 	 6.14957151876489471753473026183201e-01 3.59173975857750127360645819862839e-01 1.64851732936641625325291382608839e-03
 	 5.23534116025168194674677124567097e-01 4.44454810008373280005855576746399e-01 2.09336270352712813455631213344077e-03
 	 4.31324343595625214753397358435905e-01 5.30469524313191609365958356647752e-01 2.47717293462438323606300549784009e-03
 	 3.41467927547823069112098437472014e-01 6.14288991069952827750455526256701e-01 2.74622133979945384427145960160033e-03
 	 2.57024807845170899511799689207692e-01 6.93058850542072168998686265695142e-01 2.85479602541505042903602351600512e-03
 	 1.80870559657883900328556592285167e-01 7.64096721348366925141704086854588e-01 2.77169339878212883307440073110683e-03
 	 1.15598437579815915832170958310599e-01 8.24983575145822545238161183078773e-01 2.48499765537465522671767281792654e-03
 	 6.34309455838367730606819350214209e-02 8.73646225554830624382418591267196e-01 2.00448698348545777114804167240436e-03
 	 2.61435136813938928668221706175245e-02 9.08428523761885098330992605042411e-01 1.36135920203193580557687880627782e-03
 	 4.99729966377193690618696564342827e-03 9.28154042103708332156486449093791e-01 6.06126921006428258029141709073429e-04
 	 9.87353020626041910645653842948377e-01 1.11002816727104151872662640698763e-02 1.66687301466224100244661182612660e-05
 	 9.58024417690475527109583708806895e-01 3.68420611147038251642626960347116e-02 9.76585436138871330761027089728543e-05
 	 9.13108376537141497308880389027763e-01 7.62649694379124165610761565403664e-02 2.82859931287130471084384497615360e-04
 	 8.54138147775210576639892678940669e-01 1.28023269203110690028779572458006e-01 5.94116767621732564351455518902867e-04
 	 7.83122553964868073350658050912898e-01 1.90353812421422491363287576859875e-01 1.03065569161850585123973988999069e-03
 	 7.02480137925040937219023362558801e-01 2.61133838729777800757858585711801e-01 1.56778466981876730967915278824876e-03
 	 6.14957151876489471753473026183201e-01 3.37952956500788159743819960567635e-01 2.15906086826341903420201084884411e-03
 	 5.23534116025168305696979587082751e-01 4.18195156580091542686261618655408e-01 2.74167424009101471163440955081114e-03
 	 4.31324343595625159242246127178078e-01 4.99127877088207327904711974042584e-01 3.24434996938996684026634831354841e-03
 	 3.41467927547823069112098437472014e-01 5.77995051512853907915712170506595e-01 3.59672229386254812405487868431919e-03
 	 2.57024807845170899511799689207692e-01 6.52110963803496312962693082226906e-01 3.73892240957909459050934053436777e-03
 	 1.80870559657883900328556592285167e-01 7.18951715294958604296482462814311e-01 3.63008301431352918900441473226692e-03
 	 1.15598437579815915832170958310599e-01 7.76241200714221868395270576002076e-01 3.25459799534398791856504296049479e-03
 	 6.34309455838367730606819350214209e-02 8.22028723425504925792495214409428e-01 2.62527383236557448550896332051252e-03
 	 2.61435136813938928668221706175245e-02 8.54755984594397499876095025683753e-01 1.78297026570362320690987800730909e-03
 	 4.99729966377193690618696564342827e-03 8.73316063247673524116976295772474e-01 7.93843590864123926920115081884433e-04
 	 9.87353020626041910645653842948377e-01 1.02306237462885078748353606670207e-02 2.00079896630770207033300778221019e-05
 	 9.58024417690475416087281246291241e-01 3.39556487317738062148286815045140e-02 1.17222554684751401380370106064532e-04
 	 9.13108376537141497308880389027763e-01 7.02899467190691018547710200436995e-02 3.39525478636317130411159670444476e-04
 	 8.54138147775210576639892678940669e-01 1.17993212839527877866530047867855e-01 7.13136636124920382170944144206715e-04
 	 7.83122553964868073350658050912898e-01 1.75440433943478218958844649932871e-01 1.23712773814825191531774351005879e-03
 	 7.02480137925040937219023362558801e-01 2.40675158544513656533325729469652e-01 1.88186017721455895596038843109454e-03
 	 6.14957151876489471753473026183201e-01 3.11475838528081472311725974577712e-01 2.59158719075681335392014048579767e-03
 	 5.23534116025168194674677124567097e-01 3.85431417475593396382294031354832e-01 3.29091594697037727323962741365904e-03
 	 4.31324343595625214753397358435905e-01 4.60023417633359188450015153648565e-01 3.89429309131337879346101971123062e-03
 	 3.41467927547823180134400899987668e-01 5.32711698098808916768120980123058e-01 4.31725643426667665680795948901505e-03
 	 2.57024807845170899511799689207692e-01 6.01020956783893889330272486404283e-01 4.48794360841362448277802599250208e-03
 	 1.80870559657883900328556592285167e-01 6.62625031310171253018381776200840e-01 4.35730033347583693703608531677673e-03
 	 1.15598437579815915832170958310599e-01 7.15426139176098985217322479002178e-01 3.90659411218007880661762243335033e-03
 	 6.34309455838367730606819350214209e-02 7.57626412191278908458968999184435e-01 3.15119695613768442329916119604150e-03
 	 2.61435136813938928668221706175245e-02 7.87789637336150705415604988957057e-01 2.14015406884491068972842242601473e-03
 	 4.99729966377193690618696564342827e-03 8.04895615995233071338077479595086e-01 9.52874887312741875207422470595020e-04
 	 9.87353020626041910645653842948377e-01 9.21975405695789514137761244683134e-03 2.26241486705042883613176601942385e-05
 	 9.58024417690475527109583708806895e-01 3.06005516296093335593120343673945e-02 1.32550073714715995398458203702319e-04
 	 9.13108376537141497308880389027763e-01 6.33447224233610328703036884689936e-02 3.83920375582143074116164838116561e-04
 	 8.54138147775210576639892678940669e-01 1.06334513881951073233089744007884e-01 8.06383327348853570608333551916758e-04
 	 7.83122553964867962328355588397244e-01 1.58105477507336167342089083831524e-01 1.39888926091969682113935746770039e-03
 	 7.02480137925041048241325825074455e-01 2.16894475295777211520942273637047e-01 2.12792415146900162556398150570658e-03
 	 6.14957151876489582775775488698855e-01 2.80699466340500969341320569583331e-01 2.93045202859424291572110199410872e-03
 	 5.23534116025168305696979587082751e-01 3.47347626408293252975312270791619e-01 3.72122201681210525159304580711250e-03
 	 4.31324343595625214753397358435905e-01 4.14569324041407560876848492625868e-01 4.40349417147999338401076485638441e-03
 	 3.41467927547823124623249668729841e-01 4.80075405130329369018937768487376e-01 4.88176238904149996378212250647266e-03
 	 2.57024807845170899511799689207692e-01 5.41635147772421610135040737077361e-01 5.07476788679898579981220052559365e-03
 	 1.80870559657883900328556592285167e-01 5.97152233545890087640373167232610e-01 4.92704225694979864452749396264153e-03
 	 1.15598437579815915832170958310599e-01 6.44736158097446998560542397171957e-01 4.41740362113353726702946744353540e-03
 	 6.34309455838368840829843975370750e-02 6.82766697386665288860285727423616e-01 3.56323396934099621141678326807778e-03
 	 2.61435136813938928668221706175245e-02 7.09949548041421851785059971007286e-01 2.41999144575155526737386679769770e-03
 	 4.99729966377193690618696564342827e-03 7.25365315452233483384247847425286e-01 1.07746872514317862216948196163457e-03
 	 9.87353020626041910645653842948377e-01 8.10420683614836503960709990224132e-03 2.44226283710126066686055962273727e-05
 	 9.58024417690475527109583708806895e-01 2.68980276669568349467986934087094e-02 1.43086983648816267692543968692576e-04
 	 9.13108376537141497308880389027763e-01 5.56803065814868991534325459724641e-02 4.14439667695715619095964132867493e-04
 	 8.54138147775210576639892678940669e-01 9.34685338672648080571292439344688e-02 8.70485807675815820294573654791748e-04
 	 7.83122553964868073350658050912898e-01 1.38975452461281095972722710030212e-01 1.51009229338134156120365680919804e-03
 	 7.02480137925040937219023362558801e-01 1.90651255831311372546110760595184e-01 2.29708094257636370391639779597881e-03
 	 6.14957151876489471753473026183201e-01 2.46736140678624926714235243707662e-01 3.16340481561386147393855061693557e-03
 	 5.23534116025168305696979587082751e-01 3.05320184363661317750171519946889e-01 4.01703612039631865332500737508781e-03
 	 4.31324343595625159242246127178078e-01 3.64408370244786172786888300834107e-01 4.75354468582436101575794396012498e-03
 	 3.41467927547823069112098437472014e-01 4.21988521178366937647297163493931e-01 5.26983226460957070169666138781395e-03
 	 2.57024807845170955022950920465519e-01 4.76099822203265465869748140903539e-01 5.47818050409222458835278857236517e-03
 	 1.80870559657883900328556592285167e-01 5.24899599645141434756112630566349e-01 5.31871160158345866741935736854430e-03
 	 1.15598437579815915832170958310599e-01 5.66726091356215988525946158915758e-01 4.76855985057956371919729576802638e-03
 	 6.34309455838368840829843975370750e-02 6.00155112844863669607775591430254e-01 3.84648900162321786405650314577542e-03
 	 2.61435136813938928668221706175245e-02 6.24048965407669076199681512662210e-01 2.61236577788552699896928999123702e-03
 	 4.99729966377193690618696564342827e-03 6.37599496892930162061929877381772e-01 1.16312081567372552041994548943649e-03
 	 9.87353020626041910645653842948377e-01 6.92430031307133663637243259358911e-03 2.53384190688182927718354736645878e-05
 	 9.58024417690475416087281246291241e-01 2.29818938683243809140144264802075e-02 1.48452406510435428593774886962819e-04
 	 9.13108376537141497308880389027763e-01 4.75737073459657905383224374418205e-02 4.29980173275692188501057033889197e-04
 	 8.54138147775210576639892678940669e-01 7.98602764471165876836167285546253e-02 9.03126962965537251858127998360715e-04
 	 7.83122553964867962328355588397244e-01 1.18741758255053259096811757444812e-01 1.56671717642415482193984921366336e-03
 	 7.02480137925040937219023362558801e-01 1.62893985448624212253321275056805e-01 2.38321603530106725793435984428470e-03
 	 6.14957151876489471753473026183201e-01 2.10813367759378644805678959528450e-01 3.28202500094048948628411288552797e-03
 	 5.23534116025168305696979587082751e-01 2.60868051731644401414200729050208e-01 4.16766545708862744951117562663967e-03
 	 4.31324343595625214753397358435905e-01 3.11353478901460034578008162498008e-01 4.93179134866301299711111028045707e-03
 	 3.41467927547823013600947206214187e-01 3.60550428732219374605705297653913e-01 5.46743848837923703681829223910427e-03
 	 2.57024807845170844000648457949865e-01 4.06783564954279974745787740175729e-01 5.68359929318957950161728120974658e-03
 	 1.80870559657883844817405361027340e-01 4.48478492175459708679596815272816e-01 5.51815068467668198154418846002045e-03
 	 1.15598437579815971343322189568426e-01 4.84215387285026610530991320047178e-01 4.94736954652013911221120068262280e-03
 	 6.34309455838368840829843975370750e-02 5.12777415456252549930127315747086e-01 3.99072322544981403918962215016109e-03
 	 2.61435136813938928668221706175245e-02 5.33192517652699593533327515615383e-01 2.71032330490964586816593495655070e-03
 	 4.99729966377193690618696564342827e-03 5.44770202095199662650770733307581e-01 1.20673509040438559601626788975182e-03
 	 9.87353020626041910645653842948377e-01 5.72267906088674577907982055080538e-03 2.53384190688182351735950603721648e-05
 	 9.58024417690475527109583708806895e-01 1.89936884412001232014244322954255e-02 1.48452406510435103333123141311489e-04
 	 9.13108376537141497308880389027763e-01 3.93179161168926635805398461798177e-02 4.29980173275691212719101796935206e-04
 	 8.54138147775210576639892678940669e-01 6.60015757776727662875515534324222e-02 9.03126962965535300294217524452733e-04
 	 7.83122553964867962328355588397244e-01 9.81356877800785981635911525700067e-02 1.56671717642415135249289726004918e-03
 	 7.02480137925040937219023362558801e-01 1.34625876626334628483050437353086e-01 2.38321603530106205376393191386342e-03
 	 6.14957151876489471753473026183201e-01 1.74229480364131661396243089257041e-01 3.28202500094048254739020897829960e-03
 	 5.23534116025168305696979587082751e-01 2.15597832243187070844214758835733e-01 4.16766545708861790853205775420065e-03
 	 4.31324343595625214753397358435905e-01 2.57322177502914417601687091519125e-01 4.93179134866300258877025441961450e-03
 	 3.41467927547823069112098437472014e-01 2.97981643719957167704137646069285e-01 5.46743848837922489375396040145461e-03
 	 2.57024807845170899511799689207692e-01 3.36191627200548737164353951811790e-01 5.68359929318956649119121138369337e-03
 	 1.80870559657883955839707823542994e-01 3.70650948166655946902636742379400e-01 5.51815068467666983847985662237079e-03
 	 1.15598437579815915832170958310599e-01 4.00186175135156974036476640321780e-01 4.94736954652012783650860683337669e-03
 	 6.34309455838367730606819350214209e-02 4.23791638959910121897678436653223e-01 3.99072322544980536557224226612561e-03
 	 2.61435136813938928668221706175245e-02 4.40663968665905958488338001188822e-01 2.71032330490963979663376903772587e-03
 	 4.99729966377193690618696564342827e-03 4.50232498241027956353832450986374e-01 1.20673509040438299393105392454117e-03
 	 9.87353020626041910645653842948377e-01 4.54277253780972084529210519576736e-03 2.44226283710125897279466511413659e-05
 	 9.58024417690475527109583708806895e-01 1.50775546425676865158749251349946e-02 1.43086983648816159272326720142132e-04
 	 9.13108376537141497308880389027763e-01 3.12113168813715896598992571853159e-02 4.14439667695715293835312387216163e-04
 	 8.54138147775210576639892678940669e-01 5.23933183575245875474024614959490e-02 8.70485807675815169773270163489087e-04
 	 7.83122553964867962328355588397244e-01 7.79019935738508584321948546858039e-02 1.51009229338134047700148432369360e-03
 	 7.02480137925041048241325825074455e-01 1.06868606243647579212563414330361e-01 2.29708094257636196919292181917172e-03
 	 6.14957151876489471753473026183201e-01 1.38306707444885518265564883222396e-01 3.16340481561385930553420564592670e-03
 	 5.23534116025168305696979587082751e-01 1.71145699611170376552848892970360e-01 4.01703612039631605123979340987717e-03
 	 4.31324343595625270264548589693732e-01 2.04267286159588501437411878214334e-01 4.75354468582435754631099200651079e-03
 	 3.41467927547823069112098437472014e-01 2.36543551273809882218301936518401e-01 5.26983226460956723224970943419976e-03
 	 2.57024807845170955022950920465519e-01 2.66875369951563523596149707373115e-01 5.47818050409222025154409863034743e-03
 	 1.80870559657883900328556592285167e-01 2.94229840696974553893028314632829e-01 5.31871160158345433061066742652656e-03
 	 1.15598437579815915832170958310599e-01 3.17675471063967873597277957742335e-01 4.76855985057956024975034381441219e-03
 	 6.34309455838367730606819350214209e-02 3.36413941571299335286937548517017e-01 3.84648900162321482829042018636301e-03
 	 2.61435136813938928668221706175245e-02 3.49807520910936919911193854204612e-01 2.61236577788552526424581401442993e-03
 	 4.99729966377193690618696564342827e-03 3.57403203443297678987278231943492e-01 1.16312081567372465305820750103294e-03
 	 9.87353020626041910645653842948377e-01 3.42722531700019074352159265117734e-03 2.26241486705041833292322006609965e-05
 	 9.58024417690475416087281246291241e-01 1.13750306799151844339146322226952e-02 1.32550073714715371982209024537269e-04
 	 9.13108376537141497308880389027763e-01 2.35469010394974420652403068743297e-02 3.83920375582141285182580237034244e-04
 	 8.54138147775210576639892678940669e-01 3.95273383428383223714419614225335e-02 8.06383327348849884320947101201682e-04
 	 7.83122553964867962328355588397244e-01 5.87719685277957593072528652555775e-02 1.39888926091969053276675705177468e-03
 	 7.02480137925040937219023362558801e-01 8.06253867791817402377319012884982e-02 2.12792415146899208458486363326756e-03
 	 6.14957151876489360731170563667547e-01 1.04343381783009447882903941717814e-01 2.93045202859422947161416317385374e-03
 	 5.23534116025168305696979587082751e-01 1.29118257566538385816556910867803e-01 3.72122201681208790435828603904156e-03
 	 4.31324343595625214753397358435905e-01 1.54106332362967113347451686422573e-01 4.40349417147997256732905313469928e-03
 	 3.41467927547823069112098437472014e-01 1.78456667321847395335510100267129e-01 4.88176238904147741237693480798043e-03
 	 2.57024807845170899511799689207692e-01 2.01340044382407379330857111199293e-01 5.07476788679896238104527483869788e-03
 	 1.80870559657883900328556592285167e-01 2.21977206796225901008767777966568e-01 4.92704225694977609312230626414930e-03
 	 1.15598437579815915832170958310599e-01 2.39665404322736974584984182001790e-01 4.41740362113351731770949371025381e-03
 	 6.34309455838367730606819350214209e-02 2.53802357029497716034427412523655e-01 3.56323396934097973154376148841038e-03
 	 2.61435136813938928668221706175245e-02 2.63906938277184033303512933343882e-01 2.41999144575154399167127294845159e-03
 	 4.99729966377193690618696564342827e-03 2.69637384883994357664960261899978e-01 1.07746872514317363483948852831418e-03
 	 9.87353020626041910645653842948377e-01 2.41635562766958321423427236140924e-03 2.00079896630770545846479679941154e-05
 	 9.58024417690475416087281246291241e-01 8.01993357775072912563274485364673e-03 1.17222554684751604668277447096614e-04
 	 9.13108376537141497308880389027763e-01 1.66016767437894285919242065574508e-02 3.39525478636317672512245913196693e-04
 	 8.54138147775210576639892678940669e-01 2.78686393852615593713650810059335e-02 7.13136636124921466373116629711149e-04
 	 7.83122553964868073350658050912898e-01 4.14370120916537909572241460409714e-02 1.23712773814825386688165398396677e-03
 	 7.02480137925041048241325825074455e-01 5.68447035304453784920752923426335e-02 1.88186017721456220856690588760785e-03
 	 6.14957151876489471753473026183201e-01 7.35670095954291669571034617547411e-02 2.59158719075681769072883042781541e-03
 	 5.23534116025168305696979587082751e-01 9.10344664992384644541800753358984e-02 3.29091594697038291109092433828209e-03
 	 4.31324343595625214753397358435905e-01 1.08652238771015707818889950431185e-01 3.89429309131338529867405462425722e-03
 	 3.41467927547823069112098437472014e-01 1.25820374353368125142083044920582e-01 4.31725643426668359570186339624343e-03
 	 2.57024807845170899511799689207692e-01 1.41954235370935322180230286903679e-01 4.48794360841363228903366788813400e-03
 	 1.80870559657883900328556592285167e-01 1.56504409031944957675364094029646e-01 4.35730033347584387592998922400511e-03
 	 1.15598437579815915832170958310599e-01 1.68975423244085209972809025202878e-01 3.90659411218008574551152634057871e-03
 	 6.34309455838367730606819350214209e-02 1.78942642224884540524953990825452e-01 3.15119695613768962746958912646278e-03
 	 2.61435136813938928668221706175245e-02 1.86066848982455512739875302941073e-01 2.14015406884491415917537437962892e-03
 	 4.99729966377193690618696564342827e-03 1.90107084340995102778038017277140e-01 9.52874887312743501510681198851671e-04
 	 9.87353020626041910645653842948377e-01 1.54669770124767590180336895855362e-03 1.66687301466224066363343292440646e-05
 	 9.58024417690475527109583708806895e-01 5.13352119482071017619873032344913e-03 9.76585436138871059710483968352435e-05
 	 9.13108376537141497308880389027763e-01 1.06266540249460861300434544318705e-02 2.82859931287130416874275873340139e-04
 	 8.54138147775210576639892678940669e-01 1.78385830216787333313277486013249e-02 5.94116767621732455931238270352424e-04
 	 7.83122553964868073350658050912898e-01 2.65236336137094907972056034850539e-02 1.03065569161850563439930539288980e-03
 	 7.02480137925041048241325825074455e-01 3.63860233451812620231180517293978e-02 1.56778466981876687599828379404698e-03
 	 6.14957151876489471753473026183201e-01 4.70898916227223685027070132491644e-02 2.15906086826341816684027286044056e-03
 	 5.23534116025168305696979587082751e-01 5.82707273947402071279100255196681e-02 2.74167424009101427795354055660937e-03
 	 4.31324343595625214753397358435905e-01 6.95477793161675128530418987793382e-02 3.24434996938996597290461032514486e-03
 	 3.41467927547823069112098437472014e-01 8.05370209393231339944918545370456e-02 3.59672229386254725669314069591564e-03
 	 2.57024807845170899511799689207692e-01 9.08642283513327875255072285654023e-02 3.73892240957909415682847154016599e-03
 	 1.80870559657883900328556592285167e-01 1.00177725047157495374960944900522e-01 3.63008301431352832164267674386338e-03
 	 1.15598437579815915832170958310599e-01 1.08160361705962326794860928202979e-01 3.25459799534398705120330497209125e-03
 	 6.34309455838367730606819350214209e-02 1.14540330990658412169125313084805e-01 2.62527383236557361814722533210897e-03
 	 2.61435136813938928668221706175245e-02 1.19100501724208607257082803698722e-01 1.78297026570362277322900901310732e-03
 	 4.99729966377193690618696564342827e-03 1.21686637088554649999139201099752e-01 7.93843590864123710079680584783546e-04
 	 9.87353020626041910645653842948377e-01 8.49679705952321659423454036641488e-04 1.27271495255904264930950711698365e-05
 	 9.58024417690475416087281246291241e-01 2.82010426200070968283384331698471e-03 7.45656613366668278653284773760390e-05
 	 9.13108376537141497308880389027763e-01 5.83776148363679414643456766498275e-03 2.15973299022961990906860352268382e-04
 	 8.54138147775210576639892678940669e-01 9.79964085046439170589849254611181e-03 4.53628613017916188041717129308950e-04
 	 7.83122553964867962328355588397244e-01 1.45707808264693428057512392115314e-02 7.86941115564673268276130180254313e-04
 	 7.02480137925040937219023362558801e-01 1.99886930663752404591093636554433e-02 1.19705758874229760413410161845604e-03
 	 6.14957151876489360731170563667547e-01 2.58688722657604563970323852117872e-02 1.64851732936642687843420418403184e-03
 	 5.23534116025168305696979587082751e-01 3.20110739664585808306185299443314e-02 2.09336270352714157866325095369575e-03
 	 4.31324343595625214753397358435905e-01 3.82061320911832869029467474319972e-02 2.47717293462439928225515828330572e-03
 	 3.41467927547823069112098437472014e-01 4.42430813822242141597484987869393e-02 2.74622133979947162518708836387304e-03
 	 2.57024807845170899511799689207692e-01 4.99163416127571535341189701284748e-02 2.85479602541506864363252127247961e-03
 	 1.80870559657883900328556592285167e-01 5.50327189937493965743442458915524e-02 2.77169339878214661399002949337955e-03
 	 1.15598437579815915832170958310599e-01 5.94179872743616499519703211262822e-02 2.48499765537467083922895660919039e-03
 	 6.34309455838367730606819350214209e-02 6.29228288613327135792019362270366e-02 2.00448698348547034789324250425580e-03
 	 2.61435136813938928668221706175245e-02 6.54279625567212308467901493713725e-02 1.36135920203194469603469318741418e-03
 	 4.99729966377193690618696564342827e-03 6.68486582325199529819315102940891e-02 6.06126921006432052736745408338948e-04
 	 9.87353020626041910645653842948377e-01 3.50479269997467854369510575907043e-04 8.32621164048587745728276926504563e-06
 	 9.58024417690475527109583708806895e-01 1.16324784049651880346587518033630e-03 4.87815025786837540419313419270964e-05
 	 9.13108376537141497308880389027763e-01 2.40798311277916343708938029521960e-03 1.41291606006781878370273664025092e-04
 	 8.54138147775210576639892678940669e-01 4.04219489702728473901061079232022e-03 2.96767774321565335361033932670694e-04
 	 7.83122553964867962328355588397244e-01 6.01021372121676722422023431136040e-03 5.14823705309422710064970463150757e-04
 	 7.02480137925040937219023362558801e-01 8.24501574537989112556601867254358e-03 7.83125460235817847688688519980360e-04
 	 6.14957151876489360731170563667547e-01 1.06704954865312617862116439937381e-02 1.07847433942021464665927954484914e-03
 	 5.23534116025168305696979587082751e-01 1.32040553128485727008012418082217e-02 1.36949604267795252941775085986365e-03
 	 4.31324343595625214753397358435905e-01 1.57594175675135339531607314711437e-02 1.62058802580221871479648765301818e-03
 	 3.41467927547823069112098437472014e-01 1.82495624605992778910490415000822e-02 1.79660182673372975301062659525542e-03
 	 2.57024807845170899511799689207692e-01 2.05896914411711762227241706568748e-02 1.86763232805823892364316396452750e-03
 	 1.80870559657883900328556592285167e-01 2.27001151654989685724217451934237e-02 1.81326586871597035532932551404883e-03
 	 1.15598437579815915832170958310599e-01 2.45089680955680178087163767486345e-02 1.62570702600438234813884363916259e-03
 	 6.34309455838367730606819350214209e-02 2.59546591156702977087888939422555e-02 1.31135277554027870200448191440046e-03
 	 2.61435136813938928668221706175245e-02 2.69879866420960068396084352571052e-02 8.90613001131932606815877484507382e-04
 	 4.99729966377193690618696564342827e-03 2.75740008541035530598151126469020e-02 3.96533490484114877708959889801577e-04
 	 9.87353020626041910645653842948377e-01 6.70230782719230533395204929547617e-05 3.63155544166099245829092655168946e-06
 	 9.58024417690475416087281246291241e-01 2.22450962831001464170554982047179e-04 2.12765107099392614012182967098141e-05
 	 9.13108376537141497308880389027763e-01 4.60484982881967375156762045662617e-04 6.16256615625743555710036591932521e-05
 	 8.54138147775210576639892678940669e-01 7.72999626984460785905639568227343e-04 1.29438053256620199879534105491530e-04
 	 7.83122553964868073350658050912898e-01 1.14934907468566827049016865203157e-03 2.24545196451841297955245857487228e-04
 	 7.02480137925040937219023362558801e-01 1.57671617970395194774368974321987e-03 3.41567527877143124748204883189828e-04
 	 6.14957151876489471753473026183201e-01 2.04054708913070648179655108833686e-03 4.70386716687479591349207996842097e-04
 	 5.23534116025168305696979587082751e-01 2.52504643925516303326617162383627e-03 5.97318567058438402474218609228274e-04
 	 4.31324343595625214753397358435905e-01 3.01371512544812425460349913919345e-03 7.06834694805963024109851655651937e-04
 	 3.41467927547823069112098437472014e-01 3.48991212300209241448101238347590e-03 7.83604767941284267342150204882500e-04
 	 2.57024807845170899511799689207692e-01 3.93742118062023749303079966921359e-03 8.14585388510025523202406905198814e-04
 	 1.80870559657883900328556592285167e-01 4.34100309421980856683376259752549e-03 7.90872946430336200979160921065159e-04
 	 1.15598437579815915832170958310599e-01 4.68691482678906812253671887447126e-03 7.09067394843233161395856800623960e-04
 	 6.34309455838367730606819350214209e-02 4.96337814628300399988347635371611e-03 5.71958834771180905758025669882727e-04
 	 2.61435136813938928668221706175245e-02 5.16098410364729254240501177264377e-03 3.88449228812295574691376698339695e-04
 	 4.99729966377193690618696564342827e-03 5.27304915217385872239219679613598e-03 1.72951807778499056390125732107776e-04
 	 ];
 
 	 case  31 

 	 % ALG. DEG.:   31
 	 % PTS CARD.:  256
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-15  

 	 xyw=[
 	 9.87353020626041910645653842948377e-01 1.25799562956861680357301125354752e-02 3.63155544166100516378513536619455e-06
 	 9.58024417690475416087281246291241e-01 4.17531313466935269373969674688851e-02 2.12765107099393359401176550882440e-05
 	 9.13108376537141497308880389027763e-01 8.64311384799765491937506567410310e-02 6.16256615625745588589110002253335e-05
 	 8.54138147775210576639892678940669e-01 1.45088852597804990329777297120017e-01 1.29438053256620633560403099693303e-04
 	 7.83122553964867962328355588397244e-01 2.15728096960446341645578627321811e-01 2.24545196451842084001820909477942e-04
 	 7.02480137925040937219023362558801e-01 2.95943145895255110833232947697979e-01 3.41567527877144317370594617244706e-04
 	 6.14957151876489360731170563667547e-01 3.83002301034379877275881653986289e-01 4.70386716687481217652466725098748e-04
 	 5.23534116025168305696979587082751e-01 4.73940837535576642292056703809067e-01 5.97318567058440462458346331686698e-04
 	 4.31324343595625214753397358435905e-01 5.65661941278926772014301604940556e-01 7.06834694805965517774848372312135e-04
 	 3.41467927547823069112098437472014e-01 6.55042160329174838473420550144510e-01 7.83604767941286977847581418643585e-04
 	 2.57024807845170899511799689207692e-01 7.39037770974208862995169511123095e-01 8.14585388510028342128055367510342e-04
 	 1.80870559657883900328556592285167e-01 8.14788437247896402126912107632961e-01 7.90872946430338911484592134826244e-04
 	 1.15598437579815915832170958310599e-01 8.79714647593395127067594785330584e-01 7.09067394843235546640636268733715e-04
 	 6.34309455838367730606819350214209e-02 9.31605676269880333961737051140517e-01 5.71958834771182857321936143790708e-04
 	 2.61435136813938928668221706175245e-02 9.68695502214958925613075280125486e-01 3.88449228812296929944092305220238e-04
 	 4.99729966377193690618696564342827e-03 9.89729651184054315393723300076090e-01 1.72951807778499652701320599135215e-04
 	 9.87353020626041910645653842948377e-01 1.22965001039606249694235984293300e-02 8.32621164048595707837981116927750e-06
 	 9.58024417690475527109583708806895e-01 4.08123344690280165369955511778244e-02 4.87815025786842148278546482664808e-05
 	 9.13108376537141497308880389027763e-01 8.44836403500793670096058463059308e-02 1.41291606006783206517934958768024e-04
 	 8.54138147775210576639892678940669e-01 1.41819657327762166376672325895925e-01 2.96767774321568154286682394982222e-04
 	 7.83122553964868073350658050912898e-01 2.10867232313915270447424177291396e-01 5.14823705309427588974746647920711e-04
 	 7.02480137925040937219023362558801e-01 2.89274846329579227166561850026483e-01 7.83125460235825328683678669960955e-04
 	 6.14957151876489360731170563667547e-01 3.74372352636979377482617792338715e-01 1.07847433942022483815970090859082e-03
 	 5.23534116025168305696979587082751e-01 4.63261828661983343646824096140335e-01 1.36949604267796553984382068591685e-03
 	 4.31324343595625214753397358435905e-01 5.52916238836861473338046835124260e-01 1.62058802580223411046733694718114e-03
 	 3.41467927547823069112098437472014e-01 6.40282509991577875041457446059212e-01 1.79660182673374666656451736912459e-03
 	 2.57024807845170899511799689207692e-01 7.22385500713658146310081065166742e-01 1.86763232805825670455879272680022e-03
 	 1.80870559657883900328556592285167e-01 7.96429325176617353143626587552717e-01 1.81326586871598748572365078501889e-03
 	 1.15598437579815915832170958310599e-01 8.59892594324616288403717589972075e-01 1.62570702600439774380969293332555e-03
 	 6.34309455838367730606819350214209e-02 9.10614395300493151275134096067632e-01 1.31135277554029106190924824915101e-03
 	 2.61435136813938928668221706175245e-02 9.46868499676510433360476781672332e-01 8.90613001131941063592822871441967e-04
 	 4.99729966377193690618696564342827e-03 9.67428699482124732078602846740978e-01 3.96533490484118618206454964791874e-04
 	 9.87353020626041910645653842948377e-01 1.17972996680057694296461789917885e-02 1.27271495255903451779321347570040e-05
 	 9.58024417690475416087281246291241e-01 3.91554780475238256576275830411760e-02 7.45656613366663535268780149678491e-05
 	 9.13108376537141497308880389027763e-01 8.10538619792217224224728511217108e-02 2.15973299022960608549090433250228e-04
 	 8.54138147775210576639892678940669e-01 1.36062211374325059409784444142133e-01 4.53628613017913260695851418446978e-04
 	 7.83122553964868073350658050912898e-01 2.02306665208662694865893172391225e-01 7.86941115564668280946136746933917e-04
 	 7.02480137925040937219023362558801e-01 2.77531169008583822321867273785756e-01 1.19705758874228979787845972282412e-03
 	 6.14957151876489471753473026183201e-01 3.59173975857750127360645819862839e-01 1.64851732936641625325291382608839e-03
 	 5.23534116025168194674677124567097e-01 4.44454810008373280005855576746399e-01 2.09336270352712813455631213344077e-03
 	 4.31324343595625214753397358435905e-01 5.30469524313191609365958356647752e-01 2.47717293462438323606300549784009e-03
 	 3.41467927547823069112098437472014e-01 6.14288991069952827750455526256701e-01 2.74622133979945384427145960160033e-03
 	 2.57024807845170899511799689207692e-01 6.93058850542072168998686265695142e-01 2.85479602541505042903602351600512e-03
 	 1.80870559657883900328556592285167e-01 7.64096721348366925141704086854588e-01 2.77169339878212883307440073110683e-03
 	 1.15598437579815915832170958310599e-01 8.24983575145822545238161183078773e-01 2.48499765537465522671767281792654e-03
 	 6.34309455838367730606819350214209e-02 8.73646225554830624382418591267196e-01 2.00448698348545777114804167240436e-03
 	 2.61435136813938928668221706175245e-02 9.08428523761885098330992605042411e-01 1.36135920203193580557687880627782e-03
 	 4.99729966377193690618696564342827e-03 9.28154042103708332156486449093791e-01 6.06126921006428258029141709073429e-04
 	 9.87353020626041910645653842948377e-01 1.11002816727104151872662640698763e-02 1.66687301466224100244661182612660e-05
 	 9.58024417690475527109583708806895e-01 3.68420611147038251642626960347116e-02 9.76585436138871330761027089728543e-05
 	 9.13108376537141497308880389027763e-01 7.62649694379124165610761565403664e-02 2.82859931287130471084384497615360e-04
 	 8.54138147775210576639892678940669e-01 1.28023269203110690028779572458006e-01 5.94116767621732564351455518902867e-04
 	 7.83122553964868073350658050912898e-01 1.90353812421422491363287576859875e-01 1.03065569161850585123973988999069e-03
 	 7.02480137925040937219023362558801e-01 2.61133838729777800757858585711801e-01 1.56778466981876730967915278824876e-03
 	 6.14957151876489471753473026183201e-01 3.37952956500788159743819960567635e-01 2.15906086826341903420201084884411e-03
 	 5.23534116025168305696979587082751e-01 4.18195156580091542686261618655408e-01 2.74167424009101471163440955081114e-03
 	 4.31324343595625159242246127178078e-01 4.99127877088207327904711974042584e-01 3.24434996938996684026634831354841e-03
 	 3.41467927547823069112098437472014e-01 5.77995051512853907915712170506595e-01 3.59672229386254812405487868431919e-03
 	 2.57024807845170899511799689207692e-01 6.52110963803496312962693082226906e-01 3.73892240957909459050934053436777e-03
 	 1.80870559657883900328556592285167e-01 7.18951715294958604296482462814311e-01 3.63008301431352918900441473226692e-03
 	 1.15598437579815915832170958310599e-01 7.76241200714221868395270576002076e-01 3.25459799534398791856504296049479e-03
 	 6.34309455838367730606819350214209e-02 8.22028723425504925792495214409428e-01 2.62527383236557448550896332051252e-03
 	 2.61435136813938928668221706175245e-02 8.54755984594397499876095025683753e-01 1.78297026570362320690987800730909e-03
 	 4.99729966377193690618696564342827e-03 8.73316063247673524116976295772474e-01 7.93843590864123926920115081884433e-04
 	 9.87353020626041910645653842948377e-01 1.02306237462885078748353606670207e-02 2.00079896630770207033300778221019e-05
 	 9.58024417690475416087281246291241e-01 3.39556487317738062148286815045140e-02 1.17222554684751401380370106064532e-04
 	 9.13108376537141497308880389027763e-01 7.02899467190691018547710200436995e-02 3.39525478636317130411159670444476e-04
 	 8.54138147775210576639892678940669e-01 1.17993212839527877866530047867855e-01 7.13136636124920382170944144206715e-04
 	 7.83122553964868073350658050912898e-01 1.75440433943478218958844649932871e-01 1.23712773814825191531774351005879e-03
 	 7.02480137925040937219023362558801e-01 2.40675158544513656533325729469652e-01 1.88186017721455895596038843109454e-03
 	 6.14957151876489471753473026183201e-01 3.11475838528081472311725974577712e-01 2.59158719075681335392014048579767e-03
 	 5.23534116025168194674677124567097e-01 3.85431417475593396382294031354832e-01 3.29091594697037727323962741365904e-03
 	 4.31324343595625214753397358435905e-01 4.60023417633359188450015153648565e-01 3.89429309131337879346101971123062e-03
 	 3.41467927547823180134400899987668e-01 5.32711698098808916768120980123058e-01 4.31725643426667665680795948901505e-03
 	 2.57024807845170899511799689207692e-01 6.01020956783893889330272486404283e-01 4.48794360841362448277802599250208e-03
 	 1.80870559657883900328556592285167e-01 6.62625031310171253018381776200840e-01 4.35730033347583693703608531677673e-03
 	 1.15598437579815915832170958310599e-01 7.15426139176098985217322479002178e-01 3.90659411218007880661762243335033e-03
 	 6.34309455838367730606819350214209e-02 7.57626412191278908458968999184435e-01 3.15119695613768442329916119604150e-03
 	 2.61435136813938928668221706175245e-02 7.87789637336150705415604988957057e-01 2.14015406884491068972842242601473e-03
 	 4.99729966377193690618696564342827e-03 8.04895615995233071338077479595086e-01 9.52874887312741875207422470595020e-04
 	 9.87353020626041910645653842948377e-01 9.21975405695789514137761244683134e-03 2.26241486705042883613176601942385e-05
 	 9.58024417690475527109583708806895e-01 3.06005516296093335593120343673945e-02 1.32550073714715995398458203702319e-04
 	 9.13108376537141497308880389027763e-01 6.33447224233610328703036884689936e-02 3.83920375582143074116164838116561e-04
 	 8.54138147775210576639892678940669e-01 1.06334513881951073233089744007884e-01 8.06383327348853570608333551916758e-04
 	 7.83122553964867962328355588397244e-01 1.58105477507336167342089083831524e-01 1.39888926091969682113935746770039e-03
 	 7.02480137925041048241325825074455e-01 2.16894475295777211520942273637047e-01 2.12792415146900162556398150570658e-03
 	 6.14957151876489582775775488698855e-01 2.80699466340500969341320569583331e-01 2.93045202859424291572110199410872e-03
 	 5.23534116025168305696979587082751e-01 3.47347626408293252975312270791619e-01 3.72122201681210525159304580711250e-03
 	 4.31324343595625214753397358435905e-01 4.14569324041407560876848492625868e-01 4.40349417147999338401076485638441e-03
 	 3.41467927547823124623249668729841e-01 4.80075405130329369018937768487376e-01 4.88176238904149996378212250647266e-03
 	 2.57024807845170899511799689207692e-01 5.41635147772421610135040737077361e-01 5.07476788679898579981220052559365e-03
 	 1.80870559657883900328556592285167e-01 5.97152233545890087640373167232610e-01 4.92704225694979864452749396264153e-03
 	 1.15598437579815915832170958310599e-01 6.44736158097446998560542397171957e-01 4.41740362113353726702946744353540e-03
 	 6.34309455838368840829843975370750e-02 6.82766697386665288860285727423616e-01 3.56323396934099621141678326807778e-03
 	 2.61435136813938928668221706175245e-02 7.09949548041421851785059971007286e-01 2.41999144575155526737386679769770e-03
 	 4.99729966377193690618696564342827e-03 7.25365315452233483384247847425286e-01 1.07746872514317862216948196163457e-03
 	 9.87353020626041910645653842948377e-01 8.10420683614836503960709990224132e-03 2.44226283710126066686055962273727e-05
 	 9.58024417690475527109583708806895e-01 2.68980276669568349467986934087094e-02 1.43086983648816267692543968692576e-04
 	 9.13108376537141497308880389027763e-01 5.56803065814868991534325459724641e-02 4.14439667695715619095964132867493e-04
 	 8.54138147775210576639892678940669e-01 9.34685338672648080571292439344688e-02 8.70485807675815820294573654791748e-04
 	 7.83122553964868073350658050912898e-01 1.38975452461281095972722710030212e-01 1.51009229338134156120365680919804e-03
 	 7.02480137925040937219023362558801e-01 1.90651255831311372546110760595184e-01 2.29708094257636370391639779597881e-03
 	 6.14957151876489471753473026183201e-01 2.46736140678624926714235243707662e-01 3.16340481561386147393855061693557e-03
 	 5.23534116025168305696979587082751e-01 3.05320184363661317750171519946889e-01 4.01703612039631865332500737508781e-03
 	 4.31324343595625159242246127178078e-01 3.64408370244786172786888300834107e-01 4.75354468582436101575794396012498e-03
 	 3.41467927547823069112098437472014e-01 4.21988521178366937647297163493931e-01 5.26983226460957070169666138781395e-03
 	 2.57024807845170955022950920465519e-01 4.76099822203265465869748140903539e-01 5.47818050409222458835278857236517e-03
 	 1.80870559657883900328556592285167e-01 5.24899599645141434756112630566349e-01 5.31871160158345866741935736854430e-03
 	 1.15598437579815915832170958310599e-01 5.66726091356215988525946158915758e-01 4.76855985057956371919729576802638e-03
 	 6.34309455838368840829843975370750e-02 6.00155112844863669607775591430254e-01 3.84648900162321786405650314577542e-03
 	 2.61435136813938928668221706175245e-02 6.24048965407669076199681512662210e-01 2.61236577788552699896928999123702e-03
 	 4.99729966377193690618696564342827e-03 6.37599496892930162061929877381772e-01 1.16312081567372552041994548943649e-03
 	 9.87353020626041910645653842948377e-01 6.92430031307133663637243259358911e-03 2.53384190688182927718354736645878e-05
 	 9.58024417690475416087281246291241e-01 2.29818938683243809140144264802075e-02 1.48452406510435428593774886962819e-04
 	 9.13108376537141497308880389027763e-01 4.75737073459657905383224374418205e-02 4.29980173275692188501057033889197e-04
 	 8.54138147775210576639892678940669e-01 7.98602764471165876836167285546253e-02 9.03126962965537251858127998360715e-04
 	 7.83122553964867962328355588397244e-01 1.18741758255053259096811757444812e-01 1.56671717642415482193984921366336e-03
 	 7.02480137925040937219023362558801e-01 1.62893985448624212253321275056805e-01 2.38321603530106725793435984428470e-03
 	 6.14957151876489471753473026183201e-01 2.10813367759378644805678959528450e-01 3.28202500094048948628411288552797e-03
 	 5.23534116025168305696979587082751e-01 2.60868051731644401414200729050208e-01 4.16766545708862744951117562663967e-03
 	 4.31324343595625214753397358435905e-01 3.11353478901460034578008162498008e-01 4.93179134866301299711111028045707e-03
 	 3.41467927547823013600947206214187e-01 3.60550428732219374605705297653913e-01 5.46743848837923703681829223910427e-03
 	 2.57024807845170844000648457949865e-01 4.06783564954279974745787740175729e-01 5.68359929318957950161728120974658e-03
 	 1.80870559657883844817405361027340e-01 4.48478492175459708679596815272816e-01 5.51815068467668198154418846002045e-03
 	 1.15598437579815971343322189568426e-01 4.84215387285026610530991320047178e-01 4.94736954652013911221120068262280e-03
 	 6.34309455838368840829843975370750e-02 5.12777415456252549930127315747086e-01 3.99072322544981403918962215016109e-03
 	 2.61435136813938928668221706175245e-02 5.33192517652699593533327515615383e-01 2.71032330490964586816593495655070e-03
 	 4.99729966377193690618696564342827e-03 5.44770202095199662650770733307581e-01 1.20673509040438559601626788975182e-03
 	 9.87353020626041910645653842948377e-01 5.72267906088674577907982055080538e-03 2.53384190688182351735950603721648e-05
 	 9.58024417690475527109583708806895e-01 1.89936884412001232014244322954255e-02 1.48452406510435103333123141311489e-04
 	 9.13108376537141497308880389027763e-01 3.93179161168926635805398461798177e-02 4.29980173275691212719101796935206e-04
 	 8.54138147775210576639892678940669e-01 6.60015757776727662875515534324222e-02 9.03126962965535300294217524452733e-04
 	 7.83122553964867962328355588397244e-01 9.81356877800785981635911525700067e-02 1.56671717642415135249289726004918e-03
 	 7.02480137925040937219023362558801e-01 1.34625876626334628483050437353086e-01 2.38321603530106205376393191386342e-03
 	 6.14957151876489471753473026183201e-01 1.74229480364131661396243089257041e-01 3.28202500094048254739020897829960e-03
 	 5.23534116025168305696979587082751e-01 2.15597832243187070844214758835733e-01 4.16766545708861790853205775420065e-03
 	 4.31324343595625214753397358435905e-01 2.57322177502914417601687091519125e-01 4.93179134866300258877025441961450e-03
 	 3.41467927547823069112098437472014e-01 2.97981643719957167704137646069285e-01 5.46743848837922489375396040145461e-03
 	 2.57024807845170899511799689207692e-01 3.36191627200548737164353951811790e-01 5.68359929318956649119121138369337e-03
 	 1.80870559657883955839707823542994e-01 3.70650948166655946902636742379400e-01 5.51815068467666983847985662237079e-03
 	 1.15598437579815915832170958310599e-01 4.00186175135156974036476640321780e-01 4.94736954652012783650860683337669e-03
 	 6.34309455838367730606819350214209e-02 4.23791638959910121897678436653223e-01 3.99072322544980536557224226612561e-03
 	 2.61435136813938928668221706175245e-02 4.40663968665905958488338001188822e-01 2.71032330490963979663376903772587e-03
 	 4.99729966377193690618696564342827e-03 4.50232498241027956353832450986374e-01 1.20673509040438299393105392454117e-03
 	 9.87353020626041910645653842948377e-01 4.54277253780972084529210519576736e-03 2.44226283710125897279466511413659e-05
 	 9.58024417690475527109583708806895e-01 1.50775546425676865158749251349946e-02 1.43086983648816159272326720142132e-04
 	 9.13108376537141497308880389027763e-01 3.12113168813715896598992571853159e-02 4.14439667695715293835312387216163e-04
 	 8.54138147775210576639892678940669e-01 5.23933183575245875474024614959490e-02 8.70485807675815169773270163489087e-04
 	 7.83122553964867962328355588397244e-01 7.79019935738508584321948546858039e-02 1.51009229338134047700148432369360e-03
 	 7.02480137925041048241325825074455e-01 1.06868606243647579212563414330361e-01 2.29708094257636196919292181917172e-03
 	 6.14957151876489471753473026183201e-01 1.38306707444885518265564883222396e-01 3.16340481561385930553420564592670e-03
 	 5.23534116025168305696979587082751e-01 1.71145699611170376552848892970360e-01 4.01703612039631605123979340987717e-03
 	 4.31324343595625270264548589693732e-01 2.04267286159588501437411878214334e-01 4.75354468582435754631099200651079e-03
 	 3.41467927547823069112098437472014e-01 2.36543551273809882218301936518401e-01 5.26983226460956723224970943419976e-03
 	 2.57024807845170955022950920465519e-01 2.66875369951563523596149707373115e-01 5.47818050409222025154409863034743e-03
 	 1.80870559657883900328556592285167e-01 2.94229840696974553893028314632829e-01 5.31871160158345433061066742652656e-03
 	 1.15598437579815915832170958310599e-01 3.17675471063967873597277957742335e-01 4.76855985057956024975034381441219e-03
 	 6.34309455838367730606819350214209e-02 3.36413941571299335286937548517017e-01 3.84648900162321482829042018636301e-03
 	 2.61435136813938928668221706175245e-02 3.49807520910936919911193854204612e-01 2.61236577788552526424581401442993e-03
 	 4.99729966377193690618696564342827e-03 3.57403203443297678987278231943492e-01 1.16312081567372465305820750103294e-03
 	 9.87353020626041910645653842948377e-01 3.42722531700019074352159265117734e-03 2.26241486705041833292322006609965e-05
 	 9.58024417690475416087281246291241e-01 1.13750306799151844339146322226952e-02 1.32550073714715371982209024537269e-04
 	 9.13108376537141497308880389027763e-01 2.35469010394974420652403068743297e-02 3.83920375582141285182580237034244e-04
 	 8.54138147775210576639892678940669e-01 3.95273383428383223714419614225335e-02 8.06383327348849884320947101201682e-04
 	 7.83122553964867962328355588397244e-01 5.87719685277957593072528652555775e-02 1.39888926091969053276675705177468e-03
 	 7.02480137925040937219023362558801e-01 8.06253867791817402377319012884982e-02 2.12792415146899208458486363326756e-03
 	 6.14957151876489360731170563667547e-01 1.04343381783009447882903941717814e-01 2.93045202859422947161416317385374e-03
 	 5.23534116025168305696979587082751e-01 1.29118257566538385816556910867803e-01 3.72122201681208790435828603904156e-03
 	 4.31324343595625214753397358435905e-01 1.54106332362967113347451686422573e-01 4.40349417147997256732905313469928e-03
 	 3.41467927547823069112098437472014e-01 1.78456667321847395335510100267129e-01 4.88176238904147741237693480798043e-03
 	 2.57024807845170899511799689207692e-01 2.01340044382407379330857111199293e-01 5.07476788679896238104527483869788e-03
 	 1.80870559657883900328556592285167e-01 2.21977206796225901008767777966568e-01 4.92704225694977609312230626414930e-03
 	 1.15598437579815915832170958310599e-01 2.39665404322736974584984182001790e-01 4.41740362113351731770949371025381e-03
 	 6.34309455838367730606819350214209e-02 2.53802357029497716034427412523655e-01 3.56323396934097973154376148841038e-03
 	 2.61435136813938928668221706175245e-02 2.63906938277184033303512933343882e-01 2.41999144575154399167127294845159e-03
 	 4.99729966377193690618696564342827e-03 2.69637384883994357664960261899978e-01 1.07746872514317363483948852831418e-03
 	 9.87353020626041910645653842948377e-01 2.41635562766958321423427236140924e-03 2.00079896630770545846479679941154e-05
 	 9.58024417690475416087281246291241e-01 8.01993357775072912563274485364673e-03 1.17222554684751604668277447096614e-04
 	 9.13108376537141497308880389027763e-01 1.66016767437894285919242065574508e-02 3.39525478636317672512245913196693e-04
 	 8.54138147775210576639892678940669e-01 2.78686393852615593713650810059335e-02 7.13136636124921466373116629711149e-04
 	 7.83122553964868073350658050912898e-01 4.14370120916537909572241460409714e-02 1.23712773814825386688165398396677e-03
 	 7.02480137925041048241325825074455e-01 5.68447035304453784920752923426335e-02 1.88186017721456220856690588760785e-03
 	 6.14957151876489471753473026183201e-01 7.35670095954291669571034617547411e-02 2.59158719075681769072883042781541e-03
 	 5.23534116025168305696979587082751e-01 9.10344664992384644541800753358984e-02 3.29091594697038291109092433828209e-03
 	 4.31324343595625214753397358435905e-01 1.08652238771015707818889950431185e-01 3.89429309131338529867405462425722e-03
 	 3.41467927547823069112098437472014e-01 1.25820374353368125142083044920582e-01 4.31725643426668359570186339624343e-03
 	 2.57024807845170899511799689207692e-01 1.41954235370935322180230286903679e-01 4.48794360841363228903366788813400e-03
 	 1.80870559657883900328556592285167e-01 1.56504409031944957675364094029646e-01 4.35730033347584387592998922400511e-03
 	 1.15598437579815915832170958310599e-01 1.68975423244085209972809025202878e-01 3.90659411218008574551152634057871e-03
 	 6.34309455838367730606819350214209e-02 1.78942642224884540524953990825452e-01 3.15119695613768962746958912646278e-03
 	 2.61435136813938928668221706175245e-02 1.86066848982455512739875302941073e-01 2.14015406884491415917537437962892e-03
 	 4.99729966377193690618696564342827e-03 1.90107084340995102778038017277140e-01 9.52874887312743501510681198851671e-04
 	 9.87353020626041910645653842948377e-01 1.54669770124767590180336895855362e-03 1.66687301466224066363343292440646e-05
 	 9.58024417690475527109583708806895e-01 5.13352119482071017619873032344913e-03 9.76585436138871059710483968352435e-05
 	 9.13108376537141497308880389027763e-01 1.06266540249460861300434544318705e-02 2.82859931287130416874275873340139e-04
 	 8.54138147775210576639892678940669e-01 1.78385830216787333313277486013249e-02 5.94116767621732455931238270352424e-04
 	 7.83122553964868073350658050912898e-01 2.65236336137094907972056034850539e-02 1.03065569161850563439930539288980e-03
 	 7.02480137925041048241325825074455e-01 3.63860233451812620231180517293978e-02 1.56778466981876687599828379404698e-03
 	 6.14957151876489471753473026183201e-01 4.70898916227223685027070132491644e-02 2.15906086826341816684027286044056e-03
 	 5.23534116025168305696979587082751e-01 5.82707273947402071279100255196681e-02 2.74167424009101427795354055660937e-03
 	 4.31324343595625214753397358435905e-01 6.95477793161675128530418987793382e-02 3.24434996938996597290461032514486e-03
 	 3.41467927547823069112098437472014e-01 8.05370209393231339944918545370456e-02 3.59672229386254725669314069591564e-03
 	 2.57024807845170899511799689207692e-01 9.08642283513327875255072285654023e-02 3.73892240957909415682847154016599e-03
 	 1.80870559657883900328556592285167e-01 1.00177725047157495374960944900522e-01 3.63008301431352832164267674386338e-03
 	 1.15598437579815915832170958310599e-01 1.08160361705962326794860928202979e-01 3.25459799534398705120330497209125e-03
 	 6.34309455838367730606819350214209e-02 1.14540330990658412169125313084805e-01 2.62527383236557361814722533210897e-03
 	 2.61435136813938928668221706175245e-02 1.19100501724208607257082803698722e-01 1.78297026570362277322900901310732e-03
 	 4.99729966377193690618696564342827e-03 1.21686637088554649999139201099752e-01 7.93843590864123710079680584783546e-04
 	 9.87353020626041910645653842948377e-01 8.49679705952321659423454036641488e-04 1.27271495255904264930950711698365e-05
 	 9.58024417690475416087281246291241e-01 2.82010426200070968283384331698471e-03 7.45656613366668278653284773760390e-05
 	 9.13108376537141497308880389027763e-01 5.83776148363679414643456766498275e-03 2.15973299022961990906860352268382e-04
 	 8.54138147775210576639892678940669e-01 9.79964085046439170589849254611181e-03 4.53628613017916188041717129308950e-04
 	 7.83122553964867962328355588397244e-01 1.45707808264693428057512392115314e-02 7.86941115564673268276130180254313e-04
 	 7.02480137925040937219023362558801e-01 1.99886930663752404591093636554433e-02 1.19705758874229760413410161845604e-03
 	 6.14957151876489360731170563667547e-01 2.58688722657604563970323852117872e-02 1.64851732936642687843420418403184e-03
 	 5.23534116025168305696979587082751e-01 3.20110739664585808306185299443314e-02 2.09336270352714157866325095369575e-03
 	 4.31324343595625214753397358435905e-01 3.82061320911832869029467474319972e-02 2.47717293462439928225515828330572e-03
 	 3.41467927547823069112098437472014e-01 4.42430813822242141597484987869393e-02 2.74622133979947162518708836387304e-03
 	 2.57024807845170899511799689207692e-01 4.99163416127571535341189701284748e-02 2.85479602541506864363252127247961e-03
 	 1.80870559657883900328556592285167e-01 5.50327189937493965743442458915524e-02 2.77169339878214661399002949337955e-03
 	 1.15598437579815915832170958310599e-01 5.94179872743616499519703211262822e-02 2.48499765537467083922895660919039e-03
 	 6.34309455838367730606819350214209e-02 6.29228288613327135792019362270366e-02 2.00448698348547034789324250425580e-03
 	 2.61435136813938928668221706175245e-02 6.54279625567212308467901493713725e-02 1.36135920203194469603469318741418e-03
 	 4.99729966377193690618696564342827e-03 6.68486582325199529819315102940891e-02 6.06126921006432052736745408338948e-04
 	 9.87353020626041910645653842948377e-01 3.50479269997467854369510575907043e-04 8.32621164048587745728276926504563e-06
 	 9.58024417690475527109583708806895e-01 1.16324784049651880346587518033630e-03 4.87815025786837540419313419270964e-05
 	 9.13108376537141497308880389027763e-01 2.40798311277916343708938029521960e-03 1.41291606006781878370273664025092e-04
 	 8.54138147775210576639892678940669e-01 4.04219489702728473901061079232022e-03 2.96767774321565335361033932670694e-04
 	 7.83122553964867962328355588397244e-01 6.01021372121676722422023431136040e-03 5.14823705309422710064970463150757e-04
 	 7.02480137925040937219023362558801e-01 8.24501574537989112556601867254358e-03 7.83125460235817847688688519980360e-04
 	 6.14957151876489360731170563667547e-01 1.06704954865312617862116439937381e-02 1.07847433942021464665927954484914e-03
 	 5.23534116025168305696979587082751e-01 1.32040553128485727008012418082217e-02 1.36949604267795252941775085986365e-03
 	 4.31324343595625214753397358435905e-01 1.57594175675135339531607314711437e-02 1.62058802580221871479648765301818e-03
 	 3.41467927547823069112098437472014e-01 1.82495624605992778910490415000822e-02 1.79660182673372975301062659525542e-03
 	 2.57024807845170899511799689207692e-01 2.05896914411711762227241706568748e-02 1.86763232805823892364316396452750e-03
 	 1.80870559657883900328556592285167e-01 2.27001151654989685724217451934237e-02 1.81326586871597035532932551404883e-03
 	 1.15598437579815915832170958310599e-01 2.45089680955680178087163767486345e-02 1.62570702600438234813884363916259e-03
 	 6.34309455838367730606819350214209e-02 2.59546591156702977087888939422555e-02 1.31135277554027870200448191440046e-03
 	 2.61435136813938928668221706175245e-02 2.69879866420960068396084352571052e-02 8.90613001131932606815877484507382e-04
 	 4.99729966377193690618696564342827e-03 2.75740008541035530598151126469020e-02 3.96533490484114877708959889801577e-04
 	 9.87353020626041910645653842948377e-01 6.70230782719230533395204929547617e-05 3.63155544166099245829092655168946e-06
 	 9.58024417690475416087281246291241e-01 2.22450962831001464170554982047179e-04 2.12765107099392614012182967098141e-05
 	 9.13108376537141497308880389027763e-01 4.60484982881967375156762045662617e-04 6.16256615625743555710036591932521e-05
 	 8.54138147775210576639892678940669e-01 7.72999626984460785905639568227343e-04 1.29438053256620199879534105491530e-04
 	 7.83122553964868073350658050912898e-01 1.14934907468566827049016865203157e-03 2.24545196451841297955245857487228e-04
 	 7.02480137925040937219023362558801e-01 1.57671617970395194774368974321987e-03 3.41567527877143124748204883189828e-04
 	 6.14957151876489471753473026183201e-01 2.04054708913070648179655108833686e-03 4.70386716687479591349207996842097e-04
 	 5.23534116025168305696979587082751e-01 2.52504643925516303326617162383627e-03 5.97318567058438402474218609228274e-04
 	 4.31324343595625214753397358435905e-01 3.01371512544812425460349913919345e-03 7.06834694805963024109851655651937e-04
 	 3.41467927547823069112098437472014e-01 3.48991212300209241448101238347590e-03 7.83604767941284267342150204882500e-04
 	 2.57024807845170899511799689207692e-01 3.93742118062023749303079966921359e-03 8.14585388510025523202406905198814e-04
 	 1.80870559657883900328556592285167e-01 4.34100309421980856683376259752549e-03 7.90872946430336200979160921065159e-04
 	 1.15598437579815915832170958310599e-01 4.68691482678906812253671887447126e-03 7.09067394843233161395856800623960e-04
 	 6.34309455838367730606819350214209e-02 4.96337814628300399988347635371611e-03 5.71958834771180905758025669882727e-04
 	 2.61435136813938928668221706175245e-02 5.16098410364729254240501177264377e-03 3.88449228812295574691376698339695e-04
 	 4.99729966377193690618696564342827e-03 5.27304915217385872239219679613598e-03 1.72951807778499056390125732107776e-04
 	 ];
 
 	 case  32 

 	 % ALG. DEG.:   32
 	 % PTS CARD.:  289
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.9e-16  

 	 xyw=[
 	 9.88714040632243662543032769463025e-01 1.12327769664254950576776082016295e-02 2.57319834899507326545224812630597e-06
 	 9.62501197823349974314055543800350e-01 3.73220979832532134823352976127353e-02 1.51250895464168141343408793830783e-05
 	 9.22243034592298283058653396437876e-01 7.73905541877212693746557192753244e-02 4.40372131725302247179550108047152e-05
 	 8.69166059567413662456658585142577e-01 1.30217416581926842544802980228269e-01 9.31692503523628116771440610399679e-05
 	 8.04883578524966614153868249559309e-01 1.94196981709656407710795633647649e-01 1.63166429476041931548313534960926e-04
 	 7.31348952734051316326713276794180e-01 2.67385093052565858684488375729416e-01 2.51181929025607317881169100459715e-04
 	 6.50796558453382356645988693344407e-01 3.47557903319044347867361466342118e-01 3.51050206714396137788747331853756e-04
 	 5.65673966886634405071276887611020e-01 4.32279374903031476939929689251585e-01 4.53895430697908927597516992591409e-04
 	 4.78567596853079701979538640443934e-01 5.18975276869259816159285492176423e-01 5.49105728175414424703515425818523e-04
 	 3.92124134722095840643873998487834e-01 6.05011394728863338698943152849097e-01 6.25558669824975233444974698215901e-04
 	 3.08970117752195960747485514730215e-01 6.87773568155944148294622664252529e-01 6.72951839185899455993145057419724e-04
 	 2.31632125777172293012995396566112e-01 7.64747123223716740447741813113680e-01 6.83078351015723697799153502074887e-04
 	 1.62460003428136490200017760798801e-01 8.33593288385436226306524076790083e-01 6.50892530462217366350741176717065e-04
 	 1.03555432935197089250323188025504e-01 8.92220285089023512625772127648816e-01 5.75235145441041918062952120749287e-04
 	 5.67079687690783540432448717183433e-02 9.38846991713896961151419873203849e-01 4.59128408240650105753832832533590e-04
 	 2.33400941237742465261817415012047e-02 9.72057628180051036537179243168794e-01 3.09610557851009891242727301019499e-04
 	 4.45799356778742161822037814999931e-03 9.90850751324635070638180422974983e-01 1.37315739605778635180205471399972e-04
 	 9.88714040632243551520730306947371e-01 1.10076223391797102524325424610652e-02 5.90966455067362400209365208558765e-06
 	 9.62501197823349974314055543800350e-01 3.65739977508202918077273579910980e-02 3.47366170016125629625702853076064e-05
 	 9.22243034592298283058653396437876e-01 7.58393045339122856551838935956766e-02 1.01136843064505510883521743892288e-04
 	 8.69166059567413662456658585142577e-01 1.27607282509199615461170651542488e-01 2.13974572242059505071051783708924e-04
 	 8.04883578524966614153868249559309e-01 1.90304413633232805125317099737003e-01 3.74731650403526284770494569897892e-04
 	 7.31348952734051316326713276794180e-01 2.62025510899615121651606841624016e-01 5.76870003943598754804489292524750e-04
 	 6.50796558453382356645988693344407e-01 3.40591302771198867205271199054550e-01 8.06229711338388036270807823768791e-04
 	 5.65673966886634405071276887611020e-01 4.23614580630586712306495655866456e-01 1.04242633979449391724847462370462e-03
 	 4.78567596853079701979538640443934e-01 5.08572712537880611272100850328570e-01 1.26108842625263415336556160895043e-03
 	 3.92124134722095840643873998487834e-01 5.92884285335808391970147113170242e-01 1.43667195219325093819007221895845e-03
 	 3.08970117752195960747485514730215e-01 6.73987538055772605893878335336922e-01 1.54551615886923659343166193025354e-03
 	 2.31632125777172293012995396566112e-01 7.49418201979986653427090459445026e-01 1.56877293112935435430432828951552e-03
 	 1.62460003428136490200017760798801e-01 8.16884384907515803675437382480595e-01 1.49485425990306445252764344644447e-03
 	 1.03555432935197089250323188025504e-01 8.74336236797955690391859207011294e-01 1.32109782700665806011441905098991e-03
 	 5.67079687690783540432448717183433e-02 9.20028337600849344113385086529888e-01 1.05444451238926738441403774260152e-03
 	 2.33400941237742465261817415012047e-02 9.52573285742871034287304610188585e-01 7.11058492230480423262894973390758e-04
 	 4.45799356778742161822037814999931e-03 9.70989711419941059489246981684119e-01 3.15362381183990805443712046596261e-04
 	 9.88714040632243551520730306947371e-01 1.06101513453137653864022382776966e-02 9.06129418890396081689118934487936e-06
 	 9.62501197823349974314055543800350e-01 3.52533580352000497359910013983608e-02 5.32616873732733486952739543340840e-05
 	 9.22243034592298283058653396437876e-01 7.31008454172777932811300161120016e-02 1.55073216167580049283311605101687e-04
 	 8.69166059567413662456658585142577e-01 1.22999548718866508201230658414715e-01 3.28087411968108625184847859657111e-04
 	 8.04883578524966503131565787043655e-01 1.83432767596227369599759526863636e-01 5.74576390433669372329039681801532e-04
 	 7.31348952734051316326713276794180e-01 2.52564108879597903900560140755260e-01 8.84515317183494852691649779075078e-04
 	 6.50796558453382356645988693344407e-01 3.28292991706081671576811231716420e-01 1.23619277128674334709224069683842e-03
 	 5.65673966886634405071276887611020e-01 4.08318406471336659002702162979404e-01 1.59835328285487629669525677655884e-03
 	 4.78567596853079757490689871701761e-01 4.90208810209396939061576858875924e-01 1.93362806475952993950917502274933e-03
 	 3.92124134722095840643873998487834e-01 5.71476001250592835489783283264842e-01 2.20285044948720842503120387334548e-03
 	 3.08970117752195960747485514730215e-01 6.49650720498834877147942279407289e-01 2.36974137349685439954405374862745e-03
 	 2.31632125777172293012995396566112e-01 7.22357680789866285486766628309852e-01 2.40540100417914893410342713764294e-03
 	 1.62460003428136490200017760798801e-01 7.87387747183391661920381920936052e-01 2.29206143637611077859550512414444e-03
 	 1.03555432935197089250323188025504e-01 8.42765087070539653524292589281686e-01 2.02564053512386968783354213030634e-03
 	 5.67079687690783540432448717183433e-02 8.86807305259518785511829719325760e-01 1.61678075814733631342112740725270e-03
 	 2.33400941237742465261817415012047e-02 9.18177097451896129243209543346893e-01 1.09026665191756691290769776259140e-03
 	 4.45799356778742161822037814999931e-03 9.35928529836884459669477109855507e-01 4.83545434350530741254847733046063e-04
 	 9.88714040632243551520730306947371e-01 1.00530473305342014228580538315327e-02 1.19221351680271095516572971151348e-05
 	 9.62501197823349974314055543800350e-01 3.34023206035289413340372277616552e-02 7.00775212572780773542108212481594e-05
 	 9.22243034592298283058653396437876e-01 6.92625613871698797563425387124880e-02 2.04033089043123165356660719815807e-04
 	 8.69166059567413662456658585142577e-01 1.16541248532826241524062993448752e-01 4.31671501980570237414630563321793e-04
 	 8.04883578524966614153868249559309e-01 1.73801318624001333024153836959158e-01 7.55982230385559466137590511891631e-04
 	 7.31348952734051316326713276794180e-01 2.39302801432914546975183611721150e-01 1.16377538901289560337171113957311e-03
 	 6.50796558453382356645988693344407e-01 3.11055410662128717369512287405087e-01 1.62648480512486985800901795329310e-03
 	 5.65673966886634405071276887611020e-01 3.86878955124203338655775041843299e-01 2.10298700022238868601043293438124e-03
 	 4.78567596853079757490689871701761e-01 4.64469564145900515317322287955903e-01 2.54411507585565336078681220044473e-03
 	 3.92124134722095840643873998487834e-01 5.41469683311735838771028284099884e-01 2.89833662457354397992692618402089e-03
 	 3.08970117752195960747485514730215e-01 6.15539706167810285464270236843731e-01 3.11791852014828762759690583550309e-03
 	 2.31632125777172293012995396566112e-01 6.84429064036191858733104709244799e-01 3.16483664554773058696923726529349e-03
 	 1.62460003428136490200017760798801e-01 7.46044616358226941876807813969208e-01 3.01571339460105338273199215848308e-03
 	 1.03555432935197089250323188025504e-01 7.98514274971575899186859714973252e-01 2.66517781655896965689600541793425e-03
 	 5.67079687690783540432448717183433e-02 8.40243981701072950585285070701502e-01 2.12723241667859587489264328041827e-03
 	 2.33400941237742465261817415012047e-02 8.69966649681514048175756670389092e-01 1.43448674354605069242163395415446e-03
 	 4.45799356778742161822037814999931e-03 8.86786012963253100771510162303457e-01 6.36210888646439429346124416753128e-04
 	 9.88714040632243551520730306947371e-01 9.35420467401065075518928892961412e-03 1.43998806924566725480183967955661e-05
 	 9.62501197823349974314055543800350e-01 3.10803414367024077868961740023224e-02 8.46415454199962003596288684370563e-05
 	 9.22243034592298283058653396437876e-01 6.44477394922785135067400119623926e-02 2.46436741248636144181044516088264e-04
 	 8.69166059567413662456658585142577e-01 1.08439824850886434859376095118932e-01 5.21384637839366130163121226814837e-04
 	 8.04883578524966503131565787043655e-01 1.61719432284365555174687756334606e-01 9.13095999143145658702436229248178e-04
 	 7.31348952734051316326713276794180e-01 2.22667546473061583878205738074030e-01 1.40563972127622015088899143364642e-03
 	 6.50796558453382356645988693344407e-01 2.89432236875519777186127612367272e-01 1.96451280008155901996014236488008e-03
 	 5.65673966886634405071276887611020e-01 3.59984869394509798823378332599532e-01 2.54004517430756306464734173289344e-03
 	 4.78567596853079701979538640443934e-01 4.32181728088850136693110925989458e-01 3.07285172025642799170652708085072e-03
 	 3.92124134722095840643873998487834e-01 5.03829145127536182080518756265519e-01 3.50069018780828789677572743244127e-03
 	 3.08970117752195960747485514730215e-01 5.72750152979545346099143898754846e-01 3.76590720254064417402140030333157e-03
 	 2.31632125777172293012995396566112e-01 6.36850632383909598388527228962630e-01 3.82257619668840151541666649848139e-03
 	 1.62460003428136490200017760798801e-01 6.94182948503812125018441747670295e-01 3.64246105859952718983296726662502e-03
 	 1.03555432935197089250323188025504e-01 7.43005152329908158392868244845886e-01 3.21907460716889517668426456964426e-03
 	 5.67079687690783540432448717183433e-02 7.81833997445214423649417767592240e-01 2.56932945093987438744953522018477e-03
 	 2.33400941237742465261817415012047e-02 8.09490479167153664796785506041488e-01 1.73261229392621248987516047179724e-03
 	 4.45799356778742161822037814999931e-03 8.25140635925698084918167296564206e-01 7.68432899194062624462220334464746e-04
 	 9.88714040632243551520730306947371e-01 8.53608196877382943701384476753447e-03 1.64148304843741132659582643293916e-05
 	 9.62501197823349974314055543800350e-01 2.83620416023481411449402855851076e-02 9.64852869046692746815216401579107e-05
 	 9.22243034592298283058653396437876e-01 5.88111128823954679156749136836879e-02 2.80920197820597292333311134626683e-04
 	 8.69166059567413662456658585142577e-01 9.89556318110546007105199350917246e-02 5.94341066434897155081051867142605e-04
 	 8.04883578524966503131565787043655e-01 1.47575382197729892963522502213891e-01 1.04086390450071754158745118701290e-03
 	 7.31348952734051316326713276794180e-01 2.03192948488786218064205968403257e-01 1.60232839699421384695166015177392e-03
 	 6.50796558453382356645988693344407e-01 2.64118370772799648804607386409771e-01 2.23940359551829358542018866273793e-03
 	 5.65673966886634405071276887611020e-01 3.28500440150448047571529741617269e-01 2.89546919515469439523891459487004e-03
 	 4.78567596853079701979538640443934e-01 3.94382930985303636894911960553145e-01 3.50283041706377822402385113775836e-03
 	 3.92124134722095840643873998487834e-01 4.59764034564569934460109834617469e-01 3.99053556334579527520300956666688e-03
 	 3.08970117752195960747485514730215e-01 5.22657181860117892036043940606760e-01 4.29286392504423224697474026356758e-03
 	 2.31632125777172293012995396566112e-01 5.81151406169062023643334669031901e-01 4.35746251113826223860803210641279e-03
 	 1.62460003428136490200017760798801e-01 6.33469413622849253364677224453771e-01 4.15214418090047773096662453440331e-03
 	 1.03555432935197089250323188025504e-01 6.78021606810755628202969091944396e-01 3.66951401346755218257911224100098e-03
 	 5.67079687690783540432448717183433e-02 7.13454464676048449867096223897533e-01 2.92885116873095596723430844576797e-03
 	 2.33400941237742465261817415012047e-02 7.38692098785368123081696012377506e-01 1.97505366241262220183827480468608e-03
 	 4.45799356778731059591791563434526e-03 7.52973486201046426913308096118271e-01 8.75958353286518560942841560290617e-04
 	 9.88714040632243551520730306947371e-01 7.62497338938117157070006868480050e-03 1.79022054115628632714896789623893e-05
 	 9.62501197823349974314055543800350e-01 2.53347862962814349141460468217701e-02 1.05227978260588570804355545984521e-04
 	 9.22243034592298283058653396437876e-01 5.25338407443354249437561520608142e-02 3.06374841362424437437445012832882e-04
 	 8.69166059567413662456658585142577e-01 8.83934880251715238141940744753811e-02 6.48195293029281459709634027888114e-04
 	 8.04883578524966503131565787043655e-01 1.31823753134259619157475640349730e-01 1.13517830364385217435663211205110e-03
 	 7.31348952734051316326713276794180e-01 1.81504914175449283408880774004501e-01 1.74751802201534678186944926636670e-03
 	 6.50796558453382356645988693344407e-01 2.35927391062599411952760419808328e-01 2.44231965749048358579886830455052e-03
 	 5.65673966886634405071276887611020e-01 2.93437565818849832588455228687963e-01 3.15783244571766217104191731834817e-03
 	 4.78567596853079701979538640443934e-01 3.52288012813102846543245050270343e-01 3.82022767203356880885700697092489e-03
 	 3.92124134722095896155025229745661e-01 4.10690588700256709042690772548667e-01 4.35212458789440218009936245380231e-03
 	 3.08970117752195960747485514730215e-01 4.66870763194512372606936878582928e-01 4.68184742225561615486251199058643e-03
 	 2.31632125777172293012995396566112e-01 5.19121538833708928706300866906531e-01 4.75229939303001627792788497117726e-03
 	 1.62460003428136490200017760798801e-01 5.65855323265476384264616172004025e-01 4.52837682945709998211247793165057e-03
 	 1.03555432935197089250323188025504e-01 6.05652186596810193641715613921406e-01 4.00201474466882912289777962655535e-03
 	 5.67079687690783540432448717183433e-02 6.37303077406073725796886719763279e-01 3.19423921510675118060063049085784e-03
 	 2.33400941237742465261817415012047e-02 6.59846943455914658471783695858903e-01 2.15401653992276786997450699345791e-03
 	 4.45799356778731059591791563434526e-03 6.72603990471904555903392974869348e-01 9.55330387812258763347017520572990e-04
 	 9.88714040632243551520730306947371e-01 6.65016229395292649689830355441700e-03 1.88141942900755947695821262977134e-05
 	 9.62501197823349974314055543800350e-01 2.20958725951120593666843205937766e-02 1.10588588513672370951257395432776e-04
 	 9.22243034592298283058653396437876e-01 4.58176768670481501799507384475874e-02 3.21982440624924467608564127019122e-04
 	 8.69166059567413662456658585142577e-01 7.70928646012865037562278303084895e-02 6.81216191000052692650079677605390e-04
 	 8.04883578524966614153868249559309e-01 1.14970808129201809699715397528053e-01 1.19300749084463517113441355377290e-03
 	 7.31348952734051316326713276794180e-01 1.58300504772606903669540656665049e-01 1.83654152299971115853971515008425e-03
 	 6.50796558453382356645988693344407e-01 2.05765365993299392810556014410395e-01 2.56673831509150220109294338044492e-03
 	 5.65673966886634405071276887611020e-01 2.55923179817971524485642476065550e-01 3.31870134452054692947298164540371e-03
 	 4.78567596853079701979538640443934e-01 3.07249919414005590034832948731491e-01 4.01484085349281590721082224604288e-03
 	 3.92124134722095840643873998487834e-01 3.58186045771555550132347889302764e-01 4.57383409970113768289179390080790e-03
 	 3.08970117752195960747485514730215e-01 4.07183892584987661145135007245699e-01 4.92035394599557932004962879091181e-03
 	 2.31632125777172293012995396566112e-01 4.52754692670596758929946190619376e-01 4.99439493903502691046769612626122e-03
 	 1.62460003428136545711168992056628e-01 4.93513818665013814790398782861303e-01 4.75906512797881139920086468464433e-03
 	 1.03555432935197089250323188025504e-01 5.28222870936881916392735547560733e-01 4.20588867276176520820785142973364e-03
 	 5.67079687690783540432448717183433e-02 5.55827368668364130144254886545241e-01 3.35696277751236634920295465178697e-03
 	 2.33400941237742465261817415012047e-02 5.75489124888177716599102495820262e-01 2.26374822288475784776151655819376e-03
 	 4.45799356778742161822037814999931e-03 5.86615253297499972262585288262926e-01 1.00399761450083754681095182803574e-03
 	 9.88714040632243662543032769463025e-01 5.64297968387822423963484652631450e-03 1.91214829367985959470994244968622e-05
 	 9.62501197823349974314055543800350e-01 1.87494010883250128429722280998249e-02 1.12394810836214192558725477599779e-04
 	 9.22243034592298283058653396437876e-01 3.88784827038508584706733017810620e-02 3.27241318412765426221905373793675e-04
 	 8.69166059567413551434356122626923e-01 6.54169702162931687716707074287115e-02 6.92342365112575026941943434621862e-04
 	 8.04883578524966614153868249559309e-01 9.75582107375167206786414908492588e-02 1.21249265463851778334980480167360e-03
 	 7.31348952734051316326713276794180e-01 1.34325523632974341836643361602910e-01 1.86653740539319073186985686874095e-03
 	 6.50796558453382356645988693344407e-01 1.74601720773308821677005653327797e-01 2.60866036241258220790273369971146e-03
 	 5.65673966886634405071276887611020e-01 2.17163016556682797464361556194490e-01 3.37290506057196784114871057624896e-03
 	 4.78567596853079757490689871701761e-01 2.60716201573460149010230679778033e-01 4.08041448336272753738551699598247e-03
 	 3.92124134722095840643873998487834e-01 3.03937932638952079678063000756083e-01 4.64853765963907546165945205984826e-03
 	 3.08970117752195960747485514730215e-01 3.45514941123902019626257242634892e-01 5.00071714848789820179186804693927e-03
 	 2.31632125777172293012995396566112e-01 3.84183937111413853493502301716944e-01 5.07596743894409008213131073716795e-03
 	 1.62460003428136490200017760798801e-01 4.18769998285931754899991119600600e-01 4.83679403097066890060418131724873e-03
 	 1.03555432935197089250323188025504e-01 4.48222283532401455374838405987248e-01 4.27458265022336286048654230285138e-03
 	 5.67079687690783540432448717183433e-02 4.71646015615460822978377564140828e-01 3.41179141025086231711616058248637e-03
 	 2.33400941237742465261817415012047e-02 4.88329952938112876736909129249398e-01 2.30072159082211338473888950773016e-03
 	 4.45799356778747712937160940782633e-03 4.97771003216106289190889810925000e-01 1.02039571603611441130698977985958e-03
 	 9.88714040632243551520730306947371e-01 4.63579707380352371709486547501911e-03 1.88141942900755371713417130052903e-05
 	 9.62501197823349974314055543800350e-01 1.54029295815379732581540395131015e-02 1.10588588513672045690605649781446e-04
 	 9.22243034592298283058653396437876e-01 3.19392885406535806391836729289935e-02 3.21982440624923546036717514340353e-04
 	 8.69166059567413662456658585142577e-01 5.37410758312998615426892001778469e-02 6.81216191000050632665951955146966e-04
 	 8.04883578524966503131565787043655e-01 8.01456133458316594131431997993786e-02 1.19300749084463170168746160015871e-03
 	 7.31348952734051316326713276794180e-01 1.10350542493341807759321682169684e-01 1.83654152299970573752885272256208e-03
 	 6.50796558453382356645988693344407e-01 1.43438075553318306054606523503026e-01 2.56673831509149439483730148481300e-03
 	 5.65673966886634405071276887611020e-01 1.78402853295394125954231867581257e-01 3.31870134452053695481299477876291e-03
 	 4.78567596853079757490689871701761e-01 2.14182483732914763496779642082402e-01 4.01484085349280376414649040839322e-03
 	 3.92124134722095840643873998487834e-01 2.49689819506348720246080574725056e-01 4.57383409970112380510398608635114e-03
 	 3.08970117752195960747485514730215e-01 2.83845989662816489129681940539740e-01 4.92035394599556457490008298805151e-03
 	 2.31632125777172293012995396566112e-01 3.15613181552231059079360875330167e-01 4.99439493903501216531815032340091e-03
 	 1.62460003428136490200017760798801e-01 3.44026177906849861543037150113378e-01 4.75906512797879752141305687018757e-03
 	 1.03555432935197089250323188025504e-01 3.68221696127921216401546189445071e-01 4.20588867276175306514351959208398e-03
 	 5.67079687690783540432448717183433e-02 3.87464662562557626834802704252070e-01 3.35696277751235637454296778514617e-03
 	 2.33400941237742465261817415012047e-02 4.01170780988048147897018225194188e-01 2.26374822288475090886761265096538e-03
 	 4.45799356778742161822037814999931e-03 4.08926753134712717141496796102729e-01 1.00399761450083472788530336572421e-03
 	 9.88714040632243551520730306947371e-01 3.66098597837527864329310034463560e-03 1.79022054115628497189625228935839e-05
 	 9.62501197823349974314055543800350e-01 1.21640158803685942412453613314938e-02 1.05227978260588489489192609571688e-04
 	 9.22243034592298283058653396437876e-01 2.52231246633662989364843554085382e-02 3.06374841362424166386901891456773e-04
 	 8.69166059567413662456658585142577e-01 4.24404524074148276069351481964986e-02 6.48195293029280917608547785135897e-04
 	 8.04883578524966503131565787043655e-01 6.32926683407738499553829569777008e-02 1.13517830364385109015445962654667e-03
 	 7.31348952734051316326713276794180e-01 8.71461330904994557755571804591455e-02 1.74751802201534526398640778666049e-03
 	 6.50796558453382356645988693344407e-01 1.13276050484018286912402118105092e-01 2.44231965749048141739452333354166e-03
 	 5.65673966886634405071276887611020e-01 1.40888467294515762340267883701017e-01 3.15783244571765956895670335313753e-03
 	 4.78567596853079757490689871701761e-01 1.69144390333817506988367540543550e-01 3.82022767203356533941005501731070e-03
 	 3.92124134722095840643873998487834e-01 1.97185276577647505824586460221326e-01 4.35212458789439871065241050018813e-03
 	 3.08970117752195905236334283472388e-01 2.24159119053291722156728837944684e-01 4.68184742225561268541556003697224e-03
 	 2.31632125777172293012995396566112e-01 2.49246335389118889303006199043011e-01 4.75229939303001194111919502915953e-03
 	 1.62460003428136490200017760798801e-01 2.71684673306387236557668529712828e-01 4.52837682945709651266552597803638e-03
 	 1.03555432935197089250323188025504e-01 2.90792380467992828130263660568744e-01 4.00201474466882565345082767294116e-03
 	 5.67079687690783540432448717183433e-02 3.05988953824848142204473333549686e-01 3.19423921510674857851541652564720e-03
 	 2.33400941237742465261817415012047e-02 3.16812962420311095002034562639892e-01 2.15401653992276613525103101665081e-03
 	 4.45799356778742161822037814999931e-03 3.22938015960308244522991572011961e-01 9.55330387812257895985279532169443e-04
 	 9.88714040632243551520730306947371e-01 2.74987739898261904225584828509454e-03 1.64148304843741403710125764670025e-05
 	 9.62501197823349974314055543800350e-01 9.13676057430188107155721866092790e-03 9.64852869046694237593203569147704e-05
 	 9.22243034592298283058653396437876e-01 1.89458525253062490256716898784362e-02 2.80920197820597726014180128828457e-04
 	 8.69166059567413662456658585142577e-01 3.18783086215317507106092875801551e-02 5.94341066434898130863007104096596e-04
 	 8.04883578524966503131565787043655e-01 4.75410392773035483937604794846266e-02 1.04086390450071905947049266671911e-03
 	 7.31348952734051316326713276794180e-01 6.54580987771624378535051391736488e-02 1.60232839699421644903687411698456e-03
 	 6.50796558453382356645988693344407e-01 8.50850707738179945494039202458225e-02 2.23940359551829705486714061635212e-03
 	 5.65673966886634405071276887611020e-01 1.05825592962917547357193370771711e-01 2.89546919515469916572847353108955e-03
 	 4.78567596853079646468387409186107e-01 1.27049472161616605614398167745094e-01 3.50283041706378386187514806238141e-03
 	 3.92124134722095840643873998487834e-01 1.48111830713334224896016166894697e-01 3.99053556334580134673517548549171e-03
 	 3.08970117752195960747485514730215e-01 1.68372700387686147216470544663025e-01 4.29286392504423918586864417079596e-03
 	 2.31632125777172293012995396566112e-01 1.87216468053765683343669934401987e-01 4.35746251113826917750193601364117e-03
 	 1.62460003428136490200017760798801e-01 2.04070582949014256435305014747428e-01 4.15214418090048466986052844163169e-03
 	 1.03555432935197089250323188025504e-01 2.18422960254047282546707720030099e-01 3.66951401346755825411127815982582e-03
 	 5.67079687690783540432448717183433e-02 2.29837566554873196089658904384123e-01 2.92885116873096030404299838778570e-03
 	 2.33400941237742465261817415012047e-02 2.37967807090857630392122246121289e-01 1.97505366241262523760435776409849e-03
 	 4.45799356778742161822037814999931e-03 2.42568520231166151468471525731729e-01 8.75958353286519970405665791446381e-04
 	 9.88714040632243551520730306947371e-01 1.93175469374579772408040412301489e-03 1.43998806924566573014253462181600e-05
 	 9.62501197823349974314055543800350e-01 6.41846073994761789904828219732735e-03 8.46415454199961054919387759554184e-05
 	 9.22243034592298283058653396437876e-01 1.33092259154232034346065915997315e-02 2.46436741248635873130501394712155e-04
 	 8.69166059567413662456658585142577e-01 2.23941155816999026839653197384905e-02 5.21384637839365696482252232613064e-04
 	 8.04883578524966503131565787043655e-01 3.33969891906678861825952253639116e-02 9.13095999143144791340698240844631e-04
 	 7.31348952734051316326713276794180e-01 4.59835007928870997950809851317899e-02 1.40563972127621863300594995394022e-03
 	 6.50796558453382356645988693344407e-01 5.97712046710978661678836942883208e-02 1.96451280008155728523666638807299e-03
 	 5.65673966886634405071276887611020e-01 7.43411637188557961053447797894478e-02 2.54004517430756046256212776768280e-03
 	 4.78567596853079701979538640443934e-01 8.92506750580701613273504335666075e-02 3.07285172025642495594044412143830e-03
 	 3.92124134722095840643873998487834e-01 1.04046720150367977275607245246647e-01 3.50069018780828442732877547882708e-03
 	 3.08970117752195960747485514730215e-01 1.18279729268258693153370586514939e-01 3.76590720254064027089357935551561e-03
 	 2.31632125777172293012995396566112e-01 1.31517241838918108598477374471258e-01 3.82257619668839761228884555066543e-03
 	 1.62460003428136490200017760798801e-01 1.43357048068051384781540491530905e-01 3.64246105859952328670514631880906e-03
 	 1.03555432935197089250323188025504e-01 1.53439414734894752356808567128610e-01 3.21907460716889170723731261603007e-03
 	 5.67079687690783540432448717183433e-02 1.61458033785707222307337360689417e-01 2.56932945093987178536432125497413e-03
 	 2.33400941237742465261817415012047e-02 1.67169426709072088677032752457308e-01 1.73261229392621075515168449499015e-03
 	 4.45799356778742161822037814999931e-03 1.70401370506514493463612325285794e-01 7.68432899194061865520699594611642e-04
 	 9.88714040632243551520730306947371e-01 1.23291203722224532168816324428917e-03 1.19221351680271146338549806409368e-05
 	 9.62501197823349974314055543800350e-01 4.09648157312108435190722843799449e-03 7.00775212572781044592651333857702e-05
 	 9.22243034592298283058653396437876e-01 8.49440402053182330721625703517930e-03 2.04033089043123219566769344091028e-04
 	 8.69166059567413662456658585142577e-01 1.42926918997600821414906135942147e-02 4.31671501980570400044956436147459e-04
 	 8.04883578524966503131565787043655e-01 2.13151028510320805775535291104461e-02 7.55982230385559682978025008992518e-04
 	 7.31348952734051316326713276794180e-01 2.93482458330341089425274958557566e-02 1.16377538901289603705258013377488e-03
 	 6.50796558453382356645988693344407e-01 3.81480308844888704733477879926795e-02 1.62648480512487050853032144459576e-03
 	 5.65673966886634405071276887611020e-01 4.74470779891622007617968392878538e-02 2.10298700022238911969130192858302e-03
 	 4.78567596853079701979538640443934e-01 5.69628390010197271919878403423354e-02 2.54411507585565422814855018884828e-03
 	 3.92124134722095840643873998487834e-01 6.64061819661682095627952548966277e-02 2.89833662457354484728866417242443e-03
 	 3.08970117752195960747485514730215e-01 7.54901760799936427659417859103996e-02 3.11791852014828892863951281810841e-03
 	 2.31632125777172293012995396566112e-01 8.39388101866357372315974316734355e-02 3.16483664554773188801184424789881e-03
 	 1.62460003428136490200017760798801e-01 9.14953802136364569008719627163373e-02 3.01571339460105425009373014688663e-03
 	 1.03555432935197089250323188025504e-01 9.79302920932270115628170970012434e-02 2.66517781655897052425774340633780e-03
 	 5.67079687690783540432448717183433e-02 1.03048049529848584349167595064500e-01 2.12723241667859674225438126882182e-03
 	 2.33400941237742465261817415012047e-02 1.06693256194711594275759125594050e-01 1.43448674354605134294293744545712e-03
 	 4.45799356778742161822037814999931e-03 1.08755993468959366587966997030890e-01 6.36210888646439646186558913854014e-04
 	 9.88714040632243551520730306947371e-01 6.75808022442681358143978798125318e-04 9.06129418890397775755013443088615e-06
 	 9.62501197823349974314055543800350e-01 2.24544414144997594995345480128890e-03 5.32616873732734435629640468157220e-05
 	 9.22243034592298283058653396437876e-01 4.65611999042390978242877963566571e-03 1.55073216167580320333854726477796e-04
 	 8.69166059567413662456658585142577e-01 7.83439171371981546432294862825074e-03 3.28087411968109167285934102409328e-04
 	 8.04883578524966614153868249559309e-01 1.16836538788060440019478392059682e-02 5.74576390433670456531212167305966e-04
 	 7.31348952734051316326713276794180e-01 1.60869383863507242615753511927323e-02 8.84515317183496478994908507331729e-04
 	 6.50796558453382356645988693344407e-01 2.09104498405359717772000749391736e-02 1.23619277128674551549658566784728e-03
 	 5.65673966886634405071276887611020e-01 2.60076266420288804148697181517491e-02 1.59835328285487911562090523887036e-03
 	 4.78567596853079701979538640443934e-01 3.12235929375233034477332694223151e-02 1.93362806475953340895612697636352e-03
 	 3.92124134722095840643873998487834e-01 3.63998640273112128440402557316702e-02 2.20285044948721232815902482116144e-03
 	 3.08970117752195960747485514730215e-01 4.13791617489690510822697433468420e-02 2.36974137349685873635274369064518e-03
 	 2.31632125777172293012995396566112e-01 4.60101934329613104779355126083829e-02 2.40540100417915327091211707966067e-03
 	 1.62460003428136490200017760798801e-01 5.01522493884718478796003182651475e-02 2.29206143637611511540419506616217e-03
 	 1.03555432935197089250323188025504e-01 5.36794799942632572253842226928100e-02 2.02564053512387315728049408392053e-03
 	 5.67079687690783540432448717183433e-02 5.64847259714027494226229464402422e-02 1.61678075814733913234677586956423e-03
 	 2.33400941237742465261817415012047e-02 5.84828084243295132083062526362482e-02 1.09026665191756886447160823649938e-03
 	 4.45799356778742161822037814999931e-03 5.96134765953280076900000494788401e-02 4.83545434350531662826694345724832e-04
 	 9.88714040632243551520730306947371e-01 2.78337028576738226837150591563841e-04 5.90966455067361383769828503398358e-06
 	 9.62501197823349974314055543800350e-01 9.24804425829733878217098208551761e-04 3.47366170016125087524616610323847e-05
 	 9.22243034592298283058653396437876e-01 1.91766087378943128616270996644744e-03 1.01136843064505348253195871066623e-04
 	 8.69166059567413662456658585142577e-01 3.22665792338672208217076331493445e-03 2.13974572242059152705345725919983e-04
 	 8.04883578524966614153868249559309e-01 4.81200784180060847639026633260073e-03 3.74731650403525688459299702870453e-04
 	 7.31348952734051316326713276794180e-01 6.62553636633350651052865032397676e-03 5.76870003943597779022534055570759e-04
 	 6.50796558453382356645988693344407e-01 8.61213877541877614874010760104284e-03 8.06229711338386735228200841163471e-04
 	 5.65673966886634405071276887611020e-01 1.07114524827788271110762252646964e-02 1.04242633979449218252499864689753e-03
 	 4.78567596853079701979538640443934e-01 1.28596906090396867483605092274956e-02 1.26108842625263220180165113504245e-03
 	 3.92124134722095840643873998487834e-01 1.49915799420957673859788883419242e-02 1.43667195219324855294529275084869e-03
 	 3.08970117752195960747485514730215e-01 1.70423441920314333586361499328632e-02 1.54551615886923420818688246214379e-03
 	 2.31632125777172293012995396566112e-01 1.89496722428410535599141439888626e-02 1.56877293112935196905954882140577e-03
 	 1.62460003428136490200017760798801e-01 2.06556116643475951022423942049500e-02 1.49485425990306206728286397833472e-03
 	 1.03555432935197089250323188025504e-01 2.21083302668472203578176049632020e-02 1.32109782700665589171007407998104e-03
 	 5.67079687690783540432448717183433e-02 2.32636936300723018433700417517684e-02 1.05444451238926564969056176579443e-03
 	 2.33400941237742465261817415012047e-02 2.40866201333546081642111857945565e-02 7.11058492230479230640505239335880e-04
 	 4.45799356778742161822037814999931e-03 2.45522950122715188925326401658822e-02 3.15362381183990263342625803844044e-04
 	 9.88714040632243551520730306947371e-01 5.31824013309516868686088741924323e-05 2.57319834899509698237477124671546e-06
 	 9.62501197823349974314055543800350e-01 1.76704193396812203609158586914418e-04 1.51250895464169530477442290883339e-05
 	 9.22243034592298283058653396437876e-01 3.66411219980433688903076472342946e-04 4.40372131725306312937696928688780e-05
 	 8.69166059567413662456658585142577e-01 6.16523850659467242962819000240415e-04 9.31692503523636654863548933747097e-05
 	 8.04883578524966503131565787043655e-01 9.19439765377005890911732421955094e-04 1.63166429476043422326300702529522e-04
 	 7.31348952734051316326713276794180e-01 1.26595421338276947764711621857714e-03 2.51181929025609594705731320019026e-04
 	 6.50796558453382356645988693344407e-01 1.64553822757323997549860905564856e-03 3.51050206714399390395264788367058e-04
 	 5.65673966886634405071276887611020e-01 2.04665821033406247764219187956769e-03 4.53895430697913101775881061783480e-04
 	 4.78567596853079701979538640443934e-01 2.45712627766037083887340486398898e-03 5.49105728175419520453726107689363e-04
 	 3.92124134722095840643873998487834e-01 2.86447054904070963488038614741527e-03 6.25558669824980979716488871389402e-04
 	 3.08970117752195960747485514730215e-01 3.25631409185989095789182101725601e-03 6.72951839185905635945528224794998e-04
 	 2.31632125777172293012995396566112e-01 3.62075099911085551696032780455425e-03 6.83078351015729986171753918000604e-04
 	 1.62460003428136490200017760798801e-01 3.94670818642717247115569989546202e-03 6.50892530462223329462689846991452e-04
 	 1.03555432935197089250323188025504e-01 4.22428197577928710160222181002609e-03 5.75235145441047122233380051170570e-04
 	 5.67079687690783540432448717183433e-02 4.44503951702457378303279256215319e-03 4.59128408240654334142305526000882e-04
 	 2.33400941237742465261817415012047e-02 4.60227769617460591433655281434767e-03 3.09610557851012710168375763331028e-04
 	 4.45799356778742161822037814999931e-03 4.69125510757739672129673635936342e-03 1.37315739605779882012703829730071e-04
 	 ];
 
 	 case  33 

 	 % ALG. DEG.:   33
 	 % PTS CARD.:  289
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw=[
 	 9.88714040632243662543032769463025e-01 1.12327769664254950576776082016295e-02 2.57319834899507326545224812630597e-06
 	 9.62501197823349974314055543800350e-01 3.73220979832532134823352976127353e-02 1.51250895464168141343408793830783e-05
 	 9.22243034592298283058653396437876e-01 7.73905541877212693746557192753244e-02 4.40372131725302247179550108047152e-05
 	 8.69166059567413662456658585142577e-01 1.30217416581926842544802980228269e-01 9.31692503523628116771440610399679e-05
 	 8.04883578524966614153868249559309e-01 1.94196981709656407710795633647649e-01 1.63166429476041931548313534960926e-04
 	 7.31348952734051316326713276794180e-01 2.67385093052565858684488375729416e-01 2.51181929025607317881169100459715e-04
 	 6.50796558453382356645988693344407e-01 3.47557903319044347867361466342118e-01 3.51050206714396137788747331853756e-04
 	 5.65673966886634405071276887611020e-01 4.32279374903031476939929689251585e-01 4.53895430697908927597516992591409e-04
 	 4.78567596853079701979538640443934e-01 5.18975276869259816159285492176423e-01 5.49105728175414424703515425818523e-04
 	 3.92124134722095840643873998487834e-01 6.05011394728863338698943152849097e-01 6.25558669824975233444974698215901e-04
 	 3.08970117752195960747485514730215e-01 6.87773568155944148294622664252529e-01 6.72951839185899455993145057419724e-04
 	 2.31632125777172293012995396566112e-01 7.64747123223716740447741813113680e-01 6.83078351015723697799153502074887e-04
 	 1.62460003428136490200017760798801e-01 8.33593288385436226306524076790083e-01 6.50892530462217366350741176717065e-04
 	 1.03555432935197089250323188025504e-01 8.92220285089023512625772127648816e-01 5.75235145441041918062952120749287e-04
 	 5.67079687690783540432448717183433e-02 9.38846991713896961151419873203849e-01 4.59128408240650105753832832533590e-04
 	 2.33400941237742465261817415012047e-02 9.72057628180051036537179243168794e-01 3.09610557851009891242727301019499e-04
 	 4.45799356778742161822037814999931e-03 9.90850751324635070638180422974983e-01 1.37315739605778635180205471399972e-04
 	 9.88714040632243551520730306947371e-01 1.10076223391797102524325424610652e-02 5.90966455067362400209365208558765e-06
 	 9.62501197823349974314055543800350e-01 3.65739977508202918077273579910980e-02 3.47366170016125629625702853076064e-05
 	 9.22243034592298283058653396437876e-01 7.58393045339122856551838935956766e-02 1.01136843064505510883521743892288e-04
 	 8.69166059567413662456658585142577e-01 1.27607282509199615461170651542488e-01 2.13974572242059505071051783708924e-04
 	 8.04883578524966614153868249559309e-01 1.90304413633232805125317099737003e-01 3.74731650403526284770494569897892e-04
 	 7.31348952734051316326713276794180e-01 2.62025510899615121651606841624016e-01 5.76870003943598754804489292524750e-04
 	 6.50796558453382356645988693344407e-01 3.40591302771198867205271199054550e-01 8.06229711338388036270807823768791e-04
 	 5.65673966886634405071276887611020e-01 4.23614580630586712306495655866456e-01 1.04242633979449391724847462370462e-03
 	 4.78567596853079701979538640443934e-01 5.08572712537880611272100850328570e-01 1.26108842625263415336556160895043e-03
 	 3.92124134722095840643873998487834e-01 5.92884285335808391970147113170242e-01 1.43667195219325093819007221895845e-03
 	 3.08970117752195960747485514730215e-01 6.73987538055772605893878335336922e-01 1.54551615886923659343166193025354e-03
 	 2.31632125777172293012995396566112e-01 7.49418201979986653427090459445026e-01 1.56877293112935435430432828951552e-03
 	 1.62460003428136490200017760798801e-01 8.16884384907515803675437382480595e-01 1.49485425990306445252764344644447e-03
 	 1.03555432935197089250323188025504e-01 8.74336236797955690391859207011294e-01 1.32109782700665806011441905098991e-03
 	 5.67079687690783540432448717183433e-02 9.20028337600849344113385086529888e-01 1.05444451238926738441403774260152e-03
 	 2.33400941237742465261817415012047e-02 9.52573285742871034287304610188585e-01 7.11058492230480423262894973390758e-04
 	 4.45799356778742161822037814999931e-03 9.70989711419941059489246981684119e-01 3.15362381183990805443712046596261e-04
 	 9.88714040632243551520730306947371e-01 1.06101513453137653864022382776966e-02 9.06129418890396081689118934487936e-06
 	 9.62501197823349974314055543800350e-01 3.52533580352000497359910013983608e-02 5.32616873732733486952739543340840e-05
 	 9.22243034592298283058653396437876e-01 7.31008454172777932811300161120016e-02 1.55073216167580049283311605101687e-04
 	 8.69166059567413662456658585142577e-01 1.22999548718866508201230658414715e-01 3.28087411968108625184847859657111e-04
 	 8.04883578524966503131565787043655e-01 1.83432767596227369599759526863636e-01 5.74576390433669372329039681801532e-04
 	 7.31348952734051316326713276794180e-01 2.52564108879597903900560140755260e-01 8.84515317183494852691649779075078e-04
 	 6.50796558453382356645988693344407e-01 3.28292991706081671576811231716420e-01 1.23619277128674334709224069683842e-03
 	 5.65673966886634405071276887611020e-01 4.08318406471336659002702162979404e-01 1.59835328285487629669525677655884e-03
 	 4.78567596853079757490689871701761e-01 4.90208810209396939061576858875924e-01 1.93362806475952993950917502274933e-03
 	 3.92124134722095840643873998487834e-01 5.71476001250592835489783283264842e-01 2.20285044948720842503120387334548e-03
 	 3.08970117752195960747485514730215e-01 6.49650720498834877147942279407289e-01 2.36974137349685439954405374862745e-03
 	 2.31632125777172293012995396566112e-01 7.22357680789866285486766628309852e-01 2.40540100417914893410342713764294e-03
 	 1.62460003428136490200017760798801e-01 7.87387747183391661920381920936052e-01 2.29206143637611077859550512414444e-03
 	 1.03555432935197089250323188025504e-01 8.42765087070539653524292589281686e-01 2.02564053512386968783354213030634e-03
 	 5.67079687690783540432448717183433e-02 8.86807305259518785511829719325760e-01 1.61678075814733631342112740725270e-03
 	 2.33400941237742465261817415012047e-02 9.18177097451896129243209543346893e-01 1.09026665191756691290769776259140e-03
 	 4.45799356778742161822037814999931e-03 9.35928529836884459669477109855507e-01 4.83545434350530741254847733046063e-04
 	 9.88714040632243551520730306947371e-01 1.00530473305342014228580538315327e-02 1.19221351680271095516572971151348e-05
 	 9.62501197823349974314055543800350e-01 3.34023206035289413340372277616552e-02 7.00775212572780773542108212481594e-05
 	 9.22243034592298283058653396437876e-01 6.92625613871698797563425387124880e-02 2.04033089043123165356660719815807e-04
 	 8.69166059567413662456658585142577e-01 1.16541248532826241524062993448752e-01 4.31671501980570237414630563321793e-04
 	 8.04883578524966614153868249559309e-01 1.73801318624001333024153836959158e-01 7.55982230385559466137590511891631e-04
 	 7.31348952734051316326713276794180e-01 2.39302801432914546975183611721150e-01 1.16377538901289560337171113957311e-03
 	 6.50796558453382356645988693344407e-01 3.11055410662128717369512287405087e-01 1.62648480512486985800901795329310e-03
 	 5.65673966886634405071276887611020e-01 3.86878955124203338655775041843299e-01 2.10298700022238868601043293438124e-03
 	 4.78567596853079757490689871701761e-01 4.64469564145900515317322287955903e-01 2.54411507585565336078681220044473e-03
 	 3.92124134722095840643873998487834e-01 5.41469683311735838771028284099884e-01 2.89833662457354397992692618402089e-03
 	 3.08970117752195960747485514730215e-01 6.15539706167810285464270236843731e-01 3.11791852014828762759690583550309e-03
 	 2.31632125777172293012995396566112e-01 6.84429064036191858733104709244799e-01 3.16483664554773058696923726529349e-03
 	 1.62460003428136490200017760798801e-01 7.46044616358226941876807813969208e-01 3.01571339460105338273199215848308e-03
 	 1.03555432935197089250323188025504e-01 7.98514274971575899186859714973252e-01 2.66517781655896965689600541793425e-03
 	 5.67079687690783540432448717183433e-02 8.40243981701072950585285070701502e-01 2.12723241667859587489264328041827e-03
 	 2.33400941237742465261817415012047e-02 8.69966649681514048175756670389092e-01 1.43448674354605069242163395415446e-03
 	 4.45799356778742161822037814999931e-03 8.86786012963253100771510162303457e-01 6.36210888646439429346124416753128e-04
 	 9.88714040632243551520730306947371e-01 9.35420467401065075518928892961412e-03 1.43998806924566725480183967955661e-05
 	 9.62501197823349974314055543800350e-01 3.10803414367024077868961740023224e-02 8.46415454199962003596288684370563e-05
 	 9.22243034592298283058653396437876e-01 6.44477394922785135067400119623926e-02 2.46436741248636144181044516088264e-04
 	 8.69166059567413662456658585142577e-01 1.08439824850886434859376095118932e-01 5.21384637839366130163121226814837e-04
 	 8.04883578524966503131565787043655e-01 1.61719432284365555174687756334606e-01 9.13095999143145658702436229248178e-04
 	 7.31348952734051316326713276794180e-01 2.22667546473061583878205738074030e-01 1.40563972127622015088899143364642e-03
 	 6.50796558453382356645988693344407e-01 2.89432236875519777186127612367272e-01 1.96451280008155901996014236488008e-03
 	 5.65673966886634405071276887611020e-01 3.59984869394509798823378332599532e-01 2.54004517430756306464734173289344e-03
 	 4.78567596853079701979538640443934e-01 4.32181728088850136693110925989458e-01 3.07285172025642799170652708085072e-03
 	 3.92124134722095840643873998487834e-01 5.03829145127536182080518756265519e-01 3.50069018780828789677572743244127e-03
 	 3.08970117752195960747485514730215e-01 5.72750152979545346099143898754846e-01 3.76590720254064417402140030333157e-03
 	 2.31632125777172293012995396566112e-01 6.36850632383909598388527228962630e-01 3.82257619668840151541666649848139e-03
 	 1.62460003428136490200017760798801e-01 6.94182948503812125018441747670295e-01 3.64246105859952718983296726662502e-03
 	 1.03555432935197089250323188025504e-01 7.43005152329908158392868244845886e-01 3.21907460716889517668426456964426e-03
 	 5.67079687690783540432448717183433e-02 7.81833997445214423649417767592240e-01 2.56932945093987438744953522018477e-03
 	 2.33400941237742465261817415012047e-02 8.09490479167153664796785506041488e-01 1.73261229392621248987516047179724e-03
 	 4.45799356778742161822037814999931e-03 8.25140635925698084918167296564206e-01 7.68432899194062624462220334464746e-04
 	 9.88714040632243551520730306947371e-01 8.53608196877382943701384476753447e-03 1.64148304843741132659582643293916e-05
 	 9.62501197823349974314055543800350e-01 2.83620416023481411449402855851076e-02 9.64852869046692746815216401579107e-05
 	 9.22243034592298283058653396437876e-01 5.88111128823954679156749136836879e-02 2.80920197820597292333311134626683e-04
 	 8.69166059567413662456658585142577e-01 9.89556318110546007105199350917246e-02 5.94341066434897155081051867142605e-04
 	 8.04883578524966503131565787043655e-01 1.47575382197729892963522502213891e-01 1.04086390450071754158745118701290e-03
 	 7.31348952734051316326713276794180e-01 2.03192948488786218064205968403257e-01 1.60232839699421384695166015177392e-03
 	 6.50796558453382356645988693344407e-01 2.64118370772799648804607386409771e-01 2.23940359551829358542018866273793e-03
 	 5.65673966886634405071276887611020e-01 3.28500440150448047571529741617269e-01 2.89546919515469439523891459487004e-03
 	 4.78567596853079701979538640443934e-01 3.94382930985303636894911960553145e-01 3.50283041706377822402385113775836e-03
 	 3.92124134722095840643873998487834e-01 4.59764034564569934460109834617469e-01 3.99053556334579527520300956666688e-03
 	 3.08970117752195960747485514730215e-01 5.22657181860117892036043940606760e-01 4.29286392504423224697474026356758e-03
 	 2.31632125777172293012995396566112e-01 5.81151406169062023643334669031901e-01 4.35746251113826223860803210641279e-03
 	 1.62460003428136490200017760798801e-01 6.33469413622849253364677224453771e-01 4.15214418090047773096662453440331e-03
 	 1.03555432935197089250323188025504e-01 6.78021606810755628202969091944396e-01 3.66951401346755218257911224100098e-03
 	 5.67079687690783540432448717183433e-02 7.13454464676048449867096223897533e-01 2.92885116873095596723430844576797e-03
 	 2.33400941237742465261817415012047e-02 7.38692098785368123081696012377506e-01 1.97505366241262220183827480468608e-03
 	 4.45799356778731059591791563434526e-03 7.52973486201046426913308096118271e-01 8.75958353286518560942841560290617e-04
 	 9.88714040632243551520730306947371e-01 7.62497338938117157070006868480050e-03 1.79022054115628632714896789623893e-05
 	 9.62501197823349974314055543800350e-01 2.53347862962814349141460468217701e-02 1.05227978260588570804355545984521e-04
 	 9.22243034592298283058653396437876e-01 5.25338407443354249437561520608142e-02 3.06374841362424437437445012832882e-04
 	 8.69166059567413662456658585142577e-01 8.83934880251715238141940744753811e-02 6.48195293029281459709634027888114e-04
 	 8.04883578524966503131565787043655e-01 1.31823753134259619157475640349730e-01 1.13517830364385217435663211205110e-03
 	 7.31348952734051316326713276794180e-01 1.81504914175449283408880774004501e-01 1.74751802201534678186944926636670e-03
 	 6.50796558453382356645988693344407e-01 2.35927391062599411952760419808328e-01 2.44231965749048358579886830455052e-03
 	 5.65673966886634405071276887611020e-01 2.93437565818849832588455228687963e-01 3.15783244571766217104191731834817e-03
 	 4.78567596853079701979538640443934e-01 3.52288012813102846543245050270343e-01 3.82022767203356880885700697092489e-03
 	 3.92124134722095896155025229745661e-01 4.10690588700256709042690772548667e-01 4.35212458789440218009936245380231e-03
 	 3.08970117752195960747485514730215e-01 4.66870763194512372606936878582928e-01 4.68184742225561615486251199058643e-03
 	 2.31632125777172293012995396566112e-01 5.19121538833708928706300866906531e-01 4.75229939303001627792788497117726e-03
 	 1.62460003428136490200017760798801e-01 5.65855323265476384264616172004025e-01 4.52837682945709998211247793165057e-03
 	 1.03555432935197089250323188025504e-01 6.05652186596810193641715613921406e-01 4.00201474466882912289777962655535e-03
 	 5.67079687690783540432448717183433e-02 6.37303077406073725796886719763279e-01 3.19423921510675118060063049085784e-03
 	 2.33400941237742465261817415012047e-02 6.59846943455914658471783695858903e-01 2.15401653992276786997450699345791e-03
 	 4.45799356778731059591791563434526e-03 6.72603990471904555903392974869348e-01 9.55330387812258763347017520572990e-04
 	 9.88714040632243551520730306947371e-01 6.65016229395292649689830355441700e-03 1.88141942900755947695821262977134e-05
 	 9.62501197823349974314055543800350e-01 2.20958725951120593666843205937766e-02 1.10588588513672370951257395432776e-04
 	 9.22243034592298283058653396437876e-01 4.58176768670481501799507384475874e-02 3.21982440624924467608564127019122e-04
 	 8.69166059567413662456658585142577e-01 7.70928646012865037562278303084895e-02 6.81216191000052692650079677605390e-04
 	 8.04883578524966614153868249559309e-01 1.14970808129201809699715397528053e-01 1.19300749084463517113441355377290e-03
 	 7.31348952734051316326713276794180e-01 1.58300504772606903669540656665049e-01 1.83654152299971115853971515008425e-03
 	 6.50796558453382356645988693344407e-01 2.05765365993299392810556014410395e-01 2.56673831509150220109294338044492e-03
 	 5.65673966886634405071276887611020e-01 2.55923179817971524485642476065550e-01 3.31870134452054692947298164540371e-03
 	 4.78567596853079701979538640443934e-01 3.07249919414005590034832948731491e-01 4.01484085349281590721082224604288e-03
 	 3.92124134722095840643873998487834e-01 3.58186045771555550132347889302764e-01 4.57383409970113768289179390080790e-03
 	 3.08970117752195960747485514730215e-01 4.07183892584987661145135007245699e-01 4.92035394599557932004962879091181e-03
 	 2.31632125777172293012995396566112e-01 4.52754692670596758929946190619376e-01 4.99439493903502691046769612626122e-03
 	 1.62460003428136545711168992056628e-01 4.93513818665013814790398782861303e-01 4.75906512797881139920086468464433e-03
 	 1.03555432935197089250323188025504e-01 5.28222870936881916392735547560733e-01 4.20588867276176520820785142973364e-03
 	 5.67079687690783540432448717183433e-02 5.55827368668364130144254886545241e-01 3.35696277751236634920295465178697e-03
 	 2.33400941237742465261817415012047e-02 5.75489124888177716599102495820262e-01 2.26374822288475784776151655819376e-03
 	 4.45799356778742161822037814999931e-03 5.86615253297499972262585288262926e-01 1.00399761450083754681095182803574e-03
 	 9.88714040632243662543032769463025e-01 5.64297968387822423963484652631450e-03 1.91214829367985959470994244968622e-05
 	 9.62501197823349974314055543800350e-01 1.87494010883250128429722280998249e-02 1.12394810836214192558725477599779e-04
 	 9.22243034592298283058653396437876e-01 3.88784827038508584706733017810620e-02 3.27241318412765426221905373793675e-04
 	 8.69166059567413551434356122626923e-01 6.54169702162931687716707074287115e-02 6.92342365112575026941943434621862e-04
 	 8.04883578524966614153868249559309e-01 9.75582107375167206786414908492588e-02 1.21249265463851778334980480167360e-03
 	 7.31348952734051316326713276794180e-01 1.34325523632974341836643361602910e-01 1.86653740539319073186985686874095e-03
 	 6.50796558453382356645988693344407e-01 1.74601720773308821677005653327797e-01 2.60866036241258220790273369971146e-03
 	 5.65673966886634405071276887611020e-01 2.17163016556682797464361556194490e-01 3.37290506057196784114871057624896e-03
 	 4.78567596853079757490689871701761e-01 2.60716201573460149010230679778033e-01 4.08041448336272753738551699598247e-03
 	 3.92124134722095840643873998487834e-01 3.03937932638952079678063000756083e-01 4.64853765963907546165945205984826e-03
 	 3.08970117752195960747485514730215e-01 3.45514941123902019626257242634892e-01 5.00071714848789820179186804693927e-03
 	 2.31632125777172293012995396566112e-01 3.84183937111413853493502301716944e-01 5.07596743894409008213131073716795e-03
 	 1.62460003428136490200017760798801e-01 4.18769998285931754899991119600600e-01 4.83679403097066890060418131724873e-03
 	 1.03555432935197089250323188025504e-01 4.48222283532401455374838405987248e-01 4.27458265022336286048654230285138e-03
 	 5.67079687690783540432448717183433e-02 4.71646015615460822978377564140828e-01 3.41179141025086231711616058248637e-03
 	 2.33400941237742465261817415012047e-02 4.88329952938112876736909129249398e-01 2.30072159082211338473888950773016e-03
 	 4.45799356778747712937160940782633e-03 4.97771003216106289190889810925000e-01 1.02039571603611441130698977985958e-03
 	 9.88714040632243551520730306947371e-01 4.63579707380352371709486547501911e-03 1.88141942900755371713417130052903e-05
 	 9.62501197823349974314055543800350e-01 1.54029295815379732581540395131015e-02 1.10588588513672045690605649781446e-04
 	 9.22243034592298283058653396437876e-01 3.19392885406535806391836729289935e-02 3.21982440624923546036717514340353e-04
 	 8.69166059567413662456658585142577e-01 5.37410758312998615426892001778469e-02 6.81216191000050632665951955146966e-04
 	 8.04883578524966503131565787043655e-01 8.01456133458316594131431997993786e-02 1.19300749084463170168746160015871e-03
 	 7.31348952734051316326713276794180e-01 1.10350542493341807759321682169684e-01 1.83654152299970573752885272256208e-03
 	 6.50796558453382356645988693344407e-01 1.43438075553318306054606523503026e-01 2.56673831509149439483730148481300e-03
 	 5.65673966886634405071276887611020e-01 1.78402853295394125954231867581257e-01 3.31870134452053695481299477876291e-03
 	 4.78567596853079757490689871701761e-01 2.14182483732914763496779642082402e-01 4.01484085349280376414649040839322e-03
 	 3.92124134722095840643873998487834e-01 2.49689819506348720246080574725056e-01 4.57383409970112380510398608635114e-03
 	 3.08970117752195960747485514730215e-01 2.83845989662816489129681940539740e-01 4.92035394599556457490008298805151e-03
 	 2.31632125777172293012995396566112e-01 3.15613181552231059079360875330167e-01 4.99439493903501216531815032340091e-03
 	 1.62460003428136490200017760798801e-01 3.44026177906849861543037150113378e-01 4.75906512797879752141305687018757e-03
 	 1.03555432935197089250323188025504e-01 3.68221696127921216401546189445071e-01 4.20588867276175306514351959208398e-03
 	 5.67079687690783540432448717183433e-02 3.87464662562557626834802704252070e-01 3.35696277751235637454296778514617e-03
 	 2.33400941237742465261817415012047e-02 4.01170780988048147897018225194188e-01 2.26374822288475090886761265096538e-03
 	 4.45799356778742161822037814999931e-03 4.08926753134712717141496796102729e-01 1.00399761450083472788530336572421e-03
 	 9.88714040632243551520730306947371e-01 3.66098597837527864329310034463560e-03 1.79022054115628497189625228935839e-05
 	 9.62501197823349974314055543800350e-01 1.21640158803685942412453613314938e-02 1.05227978260588489489192609571688e-04
 	 9.22243034592298283058653396437876e-01 2.52231246633662989364843554085382e-02 3.06374841362424166386901891456773e-04
 	 8.69166059567413662456658585142577e-01 4.24404524074148276069351481964986e-02 6.48195293029280917608547785135897e-04
 	 8.04883578524966503131565787043655e-01 6.32926683407738499553829569777008e-02 1.13517830364385109015445962654667e-03
 	 7.31348952734051316326713276794180e-01 8.71461330904994557755571804591455e-02 1.74751802201534526398640778666049e-03
 	 6.50796558453382356645988693344407e-01 1.13276050484018286912402118105092e-01 2.44231965749048141739452333354166e-03
 	 5.65673966886634405071276887611020e-01 1.40888467294515762340267883701017e-01 3.15783244571765956895670335313753e-03
 	 4.78567596853079757490689871701761e-01 1.69144390333817506988367540543550e-01 3.82022767203356533941005501731070e-03
 	 3.92124134722095840643873998487834e-01 1.97185276577647505824586460221326e-01 4.35212458789439871065241050018813e-03
 	 3.08970117752195905236334283472388e-01 2.24159119053291722156728837944684e-01 4.68184742225561268541556003697224e-03
 	 2.31632125777172293012995396566112e-01 2.49246335389118889303006199043011e-01 4.75229939303001194111919502915953e-03
 	 1.62460003428136490200017760798801e-01 2.71684673306387236557668529712828e-01 4.52837682945709651266552597803638e-03
 	 1.03555432935197089250323188025504e-01 2.90792380467992828130263660568744e-01 4.00201474466882565345082767294116e-03
 	 5.67079687690783540432448717183433e-02 3.05988953824848142204473333549686e-01 3.19423921510674857851541652564720e-03
 	 2.33400941237742465261817415012047e-02 3.16812962420311095002034562639892e-01 2.15401653992276613525103101665081e-03
 	 4.45799356778742161822037814999931e-03 3.22938015960308244522991572011961e-01 9.55330387812257895985279532169443e-04
 	 9.88714040632243551520730306947371e-01 2.74987739898261904225584828509454e-03 1.64148304843741403710125764670025e-05
 	 9.62501197823349974314055543800350e-01 9.13676057430188107155721866092790e-03 9.64852869046694237593203569147704e-05
 	 9.22243034592298283058653396437876e-01 1.89458525253062490256716898784362e-02 2.80920197820597726014180128828457e-04
 	 8.69166059567413662456658585142577e-01 3.18783086215317507106092875801551e-02 5.94341066434898130863007104096596e-04
 	 8.04883578524966503131565787043655e-01 4.75410392773035483937604794846266e-02 1.04086390450071905947049266671911e-03
 	 7.31348952734051316326713276794180e-01 6.54580987771624378535051391736488e-02 1.60232839699421644903687411698456e-03
 	 6.50796558453382356645988693344407e-01 8.50850707738179945494039202458225e-02 2.23940359551829705486714061635212e-03
 	 5.65673966886634405071276887611020e-01 1.05825592962917547357193370771711e-01 2.89546919515469916572847353108955e-03
 	 4.78567596853079646468387409186107e-01 1.27049472161616605614398167745094e-01 3.50283041706378386187514806238141e-03
 	 3.92124134722095840643873998487834e-01 1.48111830713334224896016166894697e-01 3.99053556334580134673517548549171e-03
 	 3.08970117752195960747485514730215e-01 1.68372700387686147216470544663025e-01 4.29286392504423918586864417079596e-03
 	 2.31632125777172293012995396566112e-01 1.87216468053765683343669934401987e-01 4.35746251113826917750193601364117e-03
 	 1.62460003428136490200017760798801e-01 2.04070582949014256435305014747428e-01 4.15214418090048466986052844163169e-03
 	 1.03555432935197089250323188025504e-01 2.18422960254047282546707720030099e-01 3.66951401346755825411127815982582e-03
 	 5.67079687690783540432448717183433e-02 2.29837566554873196089658904384123e-01 2.92885116873096030404299838778570e-03
 	 2.33400941237742465261817415012047e-02 2.37967807090857630392122246121289e-01 1.97505366241262523760435776409849e-03
 	 4.45799356778742161822037814999931e-03 2.42568520231166151468471525731729e-01 8.75958353286519970405665791446381e-04
 	 9.88714040632243551520730306947371e-01 1.93175469374579772408040412301489e-03 1.43998806924566573014253462181600e-05
 	 9.62501197823349974314055543800350e-01 6.41846073994761789904828219732735e-03 8.46415454199961054919387759554184e-05
 	 9.22243034592298283058653396437876e-01 1.33092259154232034346065915997315e-02 2.46436741248635873130501394712155e-04
 	 8.69166059567413662456658585142577e-01 2.23941155816999026839653197384905e-02 5.21384637839365696482252232613064e-04
 	 8.04883578524966503131565787043655e-01 3.33969891906678861825952253639116e-02 9.13095999143144791340698240844631e-04
 	 7.31348952734051316326713276794180e-01 4.59835007928870997950809851317899e-02 1.40563972127621863300594995394022e-03
 	 6.50796558453382356645988693344407e-01 5.97712046710978661678836942883208e-02 1.96451280008155728523666638807299e-03
 	 5.65673966886634405071276887611020e-01 7.43411637188557961053447797894478e-02 2.54004517430756046256212776768280e-03
 	 4.78567596853079701979538640443934e-01 8.92506750580701613273504335666075e-02 3.07285172025642495594044412143830e-03
 	 3.92124134722095840643873998487834e-01 1.04046720150367977275607245246647e-01 3.50069018780828442732877547882708e-03
 	 3.08970117752195960747485514730215e-01 1.18279729268258693153370586514939e-01 3.76590720254064027089357935551561e-03
 	 2.31632125777172293012995396566112e-01 1.31517241838918108598477374471258e-01 3.82257619668839761228884555066543e-03
 	 1.62460003428136490200017760798801e-01 1.43357048068051384781540491530905e-01 3.64246105859952328670514631880906e-03
 	 1.03555432935197089250323188025504e-01 1.53439414734894752356808567128610e-01 3.21907460716889170723731261603007e-03
 	 5.67079687690783540432448717183433e-02 1.61458033785707222307337360689417e-01 2.56932945093987178536432125497413e-03
 	 2.33400941237742465261817415012047e-02 1.67169426709072088677032752457308e-01 1.73261229392621075515168449499015e-03
 	 4.45799356778742161822037814999931e-03 1.70401370506514493463612325285794e-01 7.68432899194061865520699594611642e-04
 	 9.88714040632243551520730306947371e-01 1.23291203722224532168816324428917e-03 1.19221351680271146338549806409368e-05
 	 9.62501197823349974314055543800350e-01 4.09648157312108435190722843799449e-03 7.00775212572781044592651333857702e-05
 	 9.22243034592298283058653396437876e-01 8.49440402053182330721625703517930e-03 2.04033089043123219566769344091028e-04
 	 8.69166059567413662456658585142577e-01 1.42926918997600821414906135942147e-02 4.31671501980570400044956436147459e-04
 	 8.04883578524966503131565787043655e-01 2.13151028510320805775535291104461e-02 7.55982230385559682978025008992518e-04
 	 7.31348952734051316326713276794180e-01 2.93482458330341089425274958557566e-02 1.16377538901289603705258013377488e-03
 	 6.50796558453382356645988693344407e-01 3.81480308844888704733477879926795e-02 1.62648480512487050853032144459576e-03
 	 5.65673966886634405071276887611020e-01 4.74470779891622007617968392878538e-02 2.10298700022238911969130192858302e-03
 	 4.78567596853079701979538640443934e-01 5.69628390010197271919878403423354e-02 2.54411507585565422814855018884828e-03
 	 3.92124134722095840643873998487834e-01 6.64061819661682095627952548966277e-02 2.89833662457354484728866417242443e-03
 	 3.08970117752195960747485514730215e-01 7.54901760799936427659417859103996e-02 3.11791852014828892863951281810841e-03
 	 2.31632125777172293012995396566112e-01 8.39388101866357372315974316734355e-02 3.16483664554773188801184424789881e-03
 	 1.62460003428136490200017760798801e-01 9.14953802136364569008719627163373e-02 3.01571339460105425009373014688663e-03
 	 1.03555432935197089250323188025504e-01 9.79302920932270115628170970012434e-02 2.66517781655897052425774340633780e-03
 	 5.67079687690783540432448717183433e-02 1.03048049529848584349167595064500e-01 2.12723241667859674225438126882182e-03
 	 2.33400941237742465261817415012047e-02 1.06693256194711594275759125594050e-01 1.43448674354605134294293744545712e-03
 	 4.45799356778742161822037814999931e-03 1.08755993468959366587966997030890e-01 6.36210888646439646186558913854014e-04
 	 9.88714040632243551520730306947371e-01 6.75808022442681358143978798125318e-04 9.06129418890397775755013443088615e-06
 	 9.62501197823349974314055543800350e-01 2.24544414144997594995345480128890e-03 5.32616873732734435629640468157220e-05
 	 9.22243034592298283058653396437876e-01 4.65611999042390978242877963566571e-03 1.55073216167580320333854726477796e-04
 	 8.69166059567413662456658585142577e-01 7.83439171371981546432294862825074e-03 3.28087411968109167285934102409328e-04
 	 8.04883578524966614153868249559309e-01 1.16836538788060440019478392059682e-02 5.74576390433670456531212167305966e-04
 	 7.31348952734051316326713276794180e-01 1.60869383863507242615753511927323e-02 8.84515317183496478994908507331729e-04
 	 6.50796558453382356645988693344407e-01 2.09104498405359717772000749391736e-02 1.23619277128674551549658566784728e-03
 	 5.65673966886634405071276887611020e-01 2.60076266420288804148697181517491e-02 1.59835328285487911562090523887036e-03
 	 4.78567596853079701979538640443934e-01 3.12235929375233034477332694223151e-02 1.93362806475953340895612697636352e-03
 	 3.92124134722095840643873998487834e-01 3.63998640273112128440402557316702e-02 2.20285044948721232815902482116144e-03
 	 3.08970117752195960747485514730215e-01 4.13791617489690510822697433468420e-02 2.36974137349685873635274369064518e-03
 	 2.31632125777172293012995396566112e-01 4.60101934329613104779355126083829e-02 2.40540100417915327091211707966067e-03
 	 1.62460003428136490200017760798801e-01 5.01522493884718478796003182651475e-02 2.29206143637611511540419506616217e-03
 	 1.03555432935197089250323188025504e-01 5.36794799942632572253842226928100e-02 2.02564053512387315728049408392053e-03
 	 5.67079687690783540432448717183433e-02 5.64847259714027494226229464402422e-02 1.61678075814733913234677586956423e-03
 	 2.33400941237742465261817415012047e-02 5.84828084243295132083062526362482e-02 1.09026665191756886447160823649938e-03
 	 4.45799356778742161822037814999931e-03 5.96134765953280076900000494788401e-02 4.83545434350531662826694345724832e-04
 	 9.88714040632243551520730306947371e-01 2.78337028576738226837150591563841e-04 5.90966455067361383769828503398358e-06
 	 9.62501197823349974314055543800350e-01 9.24804425829733878217098208551761e-04 3.47366170016125087524616610323847e-05
 	 9.22243034592298283058653396437876e-01 1.91766087378943128616270996644744e-03 1.01136843064505348253195871066623e-04
 	 8.69166059567413662456658585142577e-01 3.22665792338672208217076331493445e-03 2.13974572242059152705345725919983e-04
 	 8.04883578524966614153868249559309e-01 4.81200784180060847639026633260073e-03 3.74731650403525688459299702870453e-04
 	 7.31348952734051316326713276794180e-01 6.62553636633350651052865032397676e-03 5.76870003943597779022534055570759e-04
 	 6.50796558453382356645988693344407e-01 8.61213877541877614874010760104284e-03 8.06229711338386735228200841163471e-04
 	 5.65673966886634405071276887611020e-01 1.07114524827788271110762252646964e-02 1.04242633979449218252499864689753e-03
 	 4.78567596853079701979538640443934e-01 1.28596906090396867483605092274956e-02 1.26108842625263220180165113504245e-03
 	 3.92124134722095840643873998487834e-01 1.49915799420957673859788883419242e-02 1.43667195219324855294529275084869e-03
 	 3.08970117752195960747485514730215e-01 1.70423441920314333586361499328632e-02 1.54551615886923420818688246214379e-03
 	 2.31632125777172293012995396566112e-01 1.89496722428410535599141439888626e-02 1.56877293112935196905954882140577e-03
 	 1.62460003428136490200017760798801e-01 2.06556116643475951022423942049500e-02 1.49485425990306206728286397833472e-03
 	 1.03555432935197089250323188025504e-01 2.21083302668472203578176049632020e-02 1.32109782700665589171007407998104e-03
 	 5.67079687690783540432448717183433e-02 2.32636936300723018433700417517684e-02 1.05444451238926564969056176579443e-03
 	 2.33400941237742465261817415012047e-02 2.40866201333546081642111857945565e-02 7.11058492230479230640505239335880e-04
 	 4.45799356778742161822037814999931e-03 2.45522950122715188925326401658822e-02 3.15362381183990263342625803844044e-04
 	 9.88714040632243551520730306947371e-01 5.31824013309516868686088741924323e-05 2.57319834899509698237477124671546e-06
 	 9.62501197823349974314055543800350e-01 1.76704193396812203609158586914418e-04 1.51250895464169530477442290883339e-05
 	 9.22243034592298283058653396437876e-01 3.66411219980433688903076472342946e-04 4.40372131725306312937696928688780e-05
 	 8.69166059567413662456658585142577e-01 6.16523850659467242962819000240415e-04 9.31692503523636654863548933747097e-05
 	 8.04883578524966503131565787043655e-01 9.19439765377005890911732421955094e-04 1.63166429476043422326300702529522e-04
 	 7.31348952734051316326713276794180e-01 1.26595421338276947764711621857714e-03 2.51181929025609594705731320019026e-04
 	 6.50796558453382356645988693344407e-01 1.64553822757323997549860905564856e-03 3.51050206714399390395264788367058e-04
 	 5.65673966886634405071276887611020e-01 2.04665821033406247764219187956769e-03 4.53895430697913101775881061783480e-04
 	 4.78567596853079701979538640443934e-01 2.45712627766037083887340486398898e-03 5.49105728175419520453726107689363e-04
 	 3.92124134722095840643873998487834e-01 2.86447054904070963488038614741527e-03 6.25558669824980979716488871389402e-04
 	 3.08970117752195960747485514730215e-01 3.25631409185989095789182101725601e-03 6.72951839185905635945528224794998e-04
 	 2.31632125777172293012995396566112e-01 3.62075099911085551696032780455425e-03 6.83078351015729986171753918000604e-04
 	 1.62460003428136490200017760798801e-01 3.94670818642717247115569989546202e-03 6.50892530462223329462689846991452e-04
 	 1.03555432935197089250323188025504e-01 4.22428197577928710160222181002609e-03 5.75235145441047122233380051170570e-04
 	 5.67079687690783540432448717183433e-02 4.44503951702457378303279256215319e-03 4.59128408240654334142305526000882e-04
 	 2.33400941237742465261817415012047e-02 4.60227769617460591433655281434767e-03 3.09610557851012710168375763331028e-04
 	 4.45799356778742161822037814999931e-03 4.69125510757739672129673635936342e-03 1.37315739605779882012703829730071e-04
 	 ];
 
 	 case  34 

 	 % ALG. DEG.:   34
 	 % PTS CARD.:  324
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.89866848202597293671090028510662e-01 1.00904160830146451266475793318023e-02 1.85756222332538250116746886969610e-06
 	 9.66300751945632585560019833792467e-01 3.35571243135274824287428430125146e-02 1.09487829892199127457784457728707e-05
 	 9.30020889699693320551432407228276e-01 6.96839792955885328762377639577608e-02 3.20181046761088155031514668191761e-05
 	 8.82019825362079235020473788608797e-01 1.17482603186550751961370053777500e-01 6.81557108900342987481066336918900e-05
 	 8.23607429774869448380059111514129e-01 1.75648649414306495808446584305784e-01 1.20313327300329090123638675624562e-04
 	 7.56377193406150505339269329851959e-01 2.42595347922629794856774765321461e-01 1.87068228657780486574521705556151e-04
 	 6.82163039113651503697610678500496e-01 3.16496510269008712867844224092551e-01 2.64662038349452771908432158198821e-04
 	 6.02989360559832099362154167465633e-01 3.95336280500779735369576428638538e-01 3.47313201962873101778794815430729e-04
 	 5.21015820870776247275557579996530e-01 4.76964103689226870397277480151388e-01 4.27771853698718184082910864773908e-04
 	 4.38478449224138033812891990237404e-01 5.59153380921455833707511828833958e-01 4.98058901568948953104964960658663e-04
 	 3.57628649976634571672207130177412e-01 6.39662202949032199228440731531009e-01 5.50310511443191543827502254515593e-04
 	 2.80671790060171733038885122368811e-01 7.16294503789370318180829144694144e-01 5.77637032036218498604052129508091e-04
 	 2.09707039588842958366399216174614e-01 7.86959966401560961912764469161630e-01 5.74903112453498967536480446227642e-04
 	 1.46670103677618013371386496146442e-01 8.49731049343950051166984849260189e-01 5.39343606027361502537609272422969e-04
 	 9.32803959285448680560648426762782e-02 9.02895590496563649196559708798304e-01 4.70947082363611254328394917223477e-04
 	 5.09940415878905595192804867110681e-02 9.45003605698739757023929541901452e-01 3.72564086444642167741947424985938e-04
 	 2.09636483937665207832878877525218e-02 9.74907348238440940590976424573455e-01 2.49733588839617449191971010336033e-04
 	 4.00147938386741230942789115943015e-03 9.91797980728932992988688965851907e-01 1.10396649695962547699581990379158e-04
 	 9.89866848202597182648787565995008e-01 9.90933048500138892455968431249858e-03 4.27219699246646150779093548122134e-06
 	 9.66300751945632585560019833792467e-01 3.29548982136395607334122814791044e-02 2.51810449040983720973493897865580e-05
 	 9.30020889699693320551432407228276e-01 6.84334099475190915651268142028130e-02 7.36382602876543471527928663711293e-05
 	 8.82019825362079235020473788608797e-01 1.15374225565730723075397179400170e-01 1.56750939175841658449958582188799e-04
 	 8.23607429774869448380059111514129e-01 1.72496406686382469652940585547185e-01 2.76707950125051069592552188680656e-04
 	 7.56377193406150616361571792367613e-01 2.38241659899025681745854399196105e-01 4.30237175273243328040700950154474e-04
 	 6.82163039113651503697610678500496e-01 3.10816570080253984365015185176162e-01 6.08694745219588197182591926548412e-04
 	 6.02989360559831988339851704949979e-01 3.88241458425867713710744055788382e-01 7.98783695231173370560062707568250e-04
 	 5.21015820870776247275557579996530e-01 4.68404364503366144045770624870784e-01 9.83830099409459171017067191655769e-04
 	 4.38478449224138033812891990237404e-01 5.49118648603951209352658224815968e-01 1.14548288861346706478394619210803e-03
 	 3.57628649976634571672207130177412e-01 6.28182635447104620318725665129023e-01 1.26565607460593838352880258213418e-03
 	 2.80671790060171733038885122368811e-01 7.03439670301319264211770132533275e-01 1.32850418683935181558830596060261e-03
 	 2.09707039588842958366399216174614e-01 7.72836949574910669902294557687128e-01 1.32221646044597667540854146750462e-03
 	 1.46670103677618013371386496146442e-01 8.34481524056296275482225155428750e-01 1.24043335003400046964716629815939e-03
 	 9.32803959285448680560648426762782e-02 8.86691958594423734751899246475659e-01 1.08312856690359377194454726378581e-03
 	 5.09940415878905595192804867110681e-02 9.28044290874180721750974498718278e-01 8.56858063554088804879282914583882e-04
 	 2.09636483937665207832878877525218e-02 9.57411371986237602627056730852928e-01 5.74360887490756445543371722095571e-04
 	 4.00147938386741230942789115943015e-03 9.73998880179356762987197271286277e-01 2.53900638636560943822012559323298e-04
 	 9.89866848202597293671090028510662e-01 9.58901404257930453645109025728743e-03 6.56761013022144207333706880658220e-06
 	 9.66300751945632585560019833792467e-01 3.18896399934043631163582688259339e-02 3.87105945473360059166587077150723e-05
 	 9.30020889699693431573734869743930e-01 6.62213183788324111223033696660423e-02 1.13203437268905092276394253048011e-04
 	 8.82019825362079235020473788608797e-01 1.11644784758770612698164370613085e-01 2.40971813300827001746301503359859e-04
 	 8.23607429774869448380059111514129e-01 1.66920506739962698494750270583609e-01 4.25380650648534395803085361720264e-04
 	 7.56377193406150505339269329851959e-01 2.30540562327288228727795171835169e-01 6.61399751861885482409619818611191e-04
 	 6.82163039113651503697610678500496e-01 3.00769508058795154159525964132627e-01 9.35740974015516579868900759464623e-04
 	 6.02989360559831988339851704949979e-01 3.75691657715116866800286743455217e-01 1.22796301245164441763579876720769e-03
 	 5.21015820870776247275557579996530e-01 4.53263319416637999736963138275314e-01 1.51243319039180701413016549849999e-03
 	 4.38478449224138033812891990237404e-01 5.31368535994964474866719683632255e-01 1.76094057378890517934211246142695e-03
 	 3.57628649976634571672207130177412e-01 6.07876800730793087623737847025041e-01 1.94568173509230375392564660330663e-03
 	 2.80671790060171733038885122368811e-01 6.80701172176695346038854950165842e-01 2.04229757450638494883921048028697e-03
 	 2.09707039588842958366399216174614e-01 7.47855203064905493803848912648391e-01 2.03263150910022250342223948393894e-03
 	 1.46670103677618013371386496146442e-01 8.07507133257921894120556771667907e-01 1.90690706676531506781613334311487e-03
 	 9.32803959285448680560648426762782e-02 8.58029879543661611052129956078716e-01 1.66508383411913111517288488272470e-03
 	 5.09940415878905595192804867110681e-02 8.98045508805817571662544196442468e-01 1.31724021815549292326041896927791e-03
 	 2.09636483937665207832878877525218e-02 9.26463306920362938967627997044474e-01 8.82959842380649177068230315512665e-04
 	 4.00147938386741230942789115943015e-03 9.42514628373004592631900777632836e-01 3.90319175197130648589938228809615e-04
 	 9.89866848202597293671090028510662e-01 9.13860807349834922130860093147930e-03 8.67440833377321737285899766467523e-06
 	 9.66300751945632585560019833792467e-01 3.03917504146538307308045290255905e-02 5.11284161648927783488244314114013e-05
 	 9.30020889699693320551432407228276e-01 6.31108341365741176698378467335715e-02 1.49517529236172002022123295184031e-04
 	 8.82019825362079235020473788608797e-01 1.06400713027430995905042721005884e-01 3.18272227500608173404728074018522e-04
 	 8.23607429774869448380059111514129e-01 1.59080076820488525157770709483884e-01 5.61836861179076420269584701827625e-04
 	 7.56377193406150616361571792367613e-01 2.19711832186065075811498559232859e-01 8.73567615273903772497854358647373e-04
 	 6.82163039113651503697610678500496e-01 2.86642051247731344254532359627774e-01 1.23591369498353312143812399170884e-03
 	 6.02989360559831988339851704949979e-01 3.58045029561541661156098825813388e-01 1.62187650874103558677752356942392e-03
 	 5.21015820870776247275557579996530e-01 4.31973069582382129816267024580156e-01 1.99760077271327789530386276339868e-03
 	 4.38478449224138033812891990237404e-01 5.06409602852181839338641111680772e-01 2.32582587664028001342431117848264e-03
 	 3.57628649976634571672207130177412e-01 5.79324194769509359659309666312765e-01 2.56982943918839879318682939413065e-03
 	 2.80671790060171733038885122368811e-01 6.48727929698648231315871726110345e-01 2.69743829933243722818403398377995e-03
 	 2.09707039588842958366399216174614e-01 7.12727665867339932326274265506072e-01 2.68467149426156658983955161090762e-03
 	 1.46670103677618013371386496146442e-01 7.69577682818094799266361860645702e-01 2.51861639526437027652994160575872e-03
 	 9.32803959285448680560648426762782e-02 8.17727323130643224402547275531106e-01 2.19921962490594001538024571118513e-03
 	 5.09940415878905595192804867110681e-02 8.55863376641196937910649467085022e-01 1.73979260330484855785748710133021e-03
 	 2.09636483937665207832878877525218e-02 8.82946361203265084327540535014123e-01 1.16620110866348636845246655724395e-03
 	 4.00147938386741230942789115943015e-03 8.98243735382307617598485194321256e-01 5.15528150884211932084011387189548e-04
 	 9.89866848202597293671090028510662e-01 8.57106080051498950278521249401820e-03 1.05317255644829115723186754860485e-05
 	 9.66300751945632585560019833792467e-01 2.85042906472250841265481113850910e-02 6.20757551265859396864149610806294e-05
 	 9.30020889699693320551432407228276e-01 5.91913770899600080732660956073232e-02 1.81531411066275711642392653999423e-04
 	 8.82019825362079235020473788608797e-01 9.97927663864841274499184464730206e-02 3.86418949380381898574959853576161e-04
 	 8.23607429774869448380059111514129e-01 1.49200512770983395594015519236564e-01 6.82134320436662486275558592296875e-04
 	 7.56377193406150505339269329851959e-01 2.06066772654406732412368796758528e-01 1.06061117163049512153449871476596e-03
 	 6.82163039113651503697610678500496e-01 2.68840334268558023289585889870068e-01 1.50054082723711742532179957976268e-03
 	 6.02989360559831988339851704949979e-01 3.35808877349018874980401960783638e-01 1.96914390380239882893942393593534e-03
 	 5.21015820870776247275557579996530e-01 4.05145664831903506986066076933639e-01 2.42531620787374236833389140599593e-03
 	 4.38478449224137978301740758979577e-01 4.74959365923340925963458403202822e-01 2.82381908956013272932183966190678e-03
 	 3.57628649976634571672207130177412e-01 5.43345644833857055466808105848031e-01 3.12006737055327753802003165617407e-03
 	 2.80671790060171844061187584884465e-01 6.08439106231502435662150674033910e-01 3.27499914721416512941587484419870e-03
 	 2.09707039588842958366399216174614e-01 6.68464180674681496263644930877490e-01 3.25949878313536601376343426750282e-03
 	 1.46670103677617902349084033630788e-01 7.21783564532304078298352578713093e-01 3.05788886763110057120940155073185e-03
 	 9.32803959285448680560648426762782e-02 7.66942902948247073879883828340098e-01 2.67010459437981313018939388825856e-03
 	 5.09940415878906705415829492267221e-02 8.02710541816418876592820197402034e-01 2.11230755252603524113608202128489e-03
 	 2.09636483937665207832878877525218e-02 8.28111555348672645493479649303481e-01 1.41590176031026744422891550101440e-03
 	 4.00147938386741230942789115943015e-03 8.42458896116795807884614077920560e-01 6.25910240441282365343733662399472e-04
 	 9.89866848202597293671090028510662e-01 7.90269730021668503905374336682144e-03 1.20860844646721297165458536282401e-05
 	 9.66300751945632585560019833792467e-01 2.62815520721638856693758157234697e-02 7.12374069258286544883279622908390e-05
 	 9.30020889699693320551432407228276e-01 5.45756875154623510848495016034576e-02 2.08323313563843975177933276476949e-04
 	 8.82019825362079235020473788608797e-01 9.20110175226195592390610045185895e-02 4.43449844222223868786536549180255e-04
 	 8.23607429774869448380059111514129e-01 1.37565992927660751821150597606902e-01 7.82809328117353795534194560445940e-04
 	 7.56377193406150505339269329851959e-01 1.89997873754728041628681012298330e-01 1.21714491381454885214619121569513e-03
 	 6.82163039113651503697610678500496e-01 2.47876410313858763778682714473689e-01 1.72200301552077341370183827251594e-03
 	 6.02989360559832099362154167465633e-01 3.09622807512395015194783809420187e-01 2.25976639808298136735675853969951e-03
 	 5.21015820870776247275557579996530e-01 3.73552775575830886545247722096974e-01 2.78326437224625435756797386943617e-03
 	 4.38478449224138089324043221495231e-01 4.37922467959798999981302358719404e-01 3.24058159514461173456023601602283e-03
 	 3.57628649976634571672207130177412e-01 5.00976047242019162375470386905363e-01 3.58055264021930018392136929605840e-03
 	 2.80671790060171733038885122368811e-01 5.60993579916390427975159127527149e-01 3.75835052599977209597525984463573e-03
 	 2.09707039588842958366399216174614e-01 6.16337953826200379836564025026746e-01 3.74056249037896942910563780060329e-03
 	 1.46670103677618013371386496146442e-01 6.65499540783503595875458813679870e-01 3.50919732113098023842945316630448e-03
 	 9.32803959285448680560648426762782e-02 7.07137395196787088558210143673932e-01 3.06418064728294003637443232435089e-03
 	 5.09940415878905595192804867110681e-02 7.40115906223291930565721941093216e-01 2.42405931856884459055234692925751e-03
 	 2.09636483937665207832878877525218e-02 7.63536171898230087151659972732887e-01 1.62487221718904026844521037986624e-03
 	 4.00147938386741230942789115943015e-03 7.76764720124923702115893320296891e-01 7.18287234789714975832786159060106e-04
 	 9.89866848202597293671090028510662e-01 7.15274440963131925841356206774435e-03 1.32927567189884695913158763058703e-05
 	 9.66300751945632585560019833792467e-01 2.37874762905888187392022814492520e-02 7.83497353774544378181635129188010e-05
 	 9.30020889699693431573734869743930e-01 4.93965451222971169142894609649375e-02 2.29122271500925778686327816124901e-04
 	 8.82019825362079235020473788608797e-01 8.32793242873368089185248663852690e-02 4.87723787927314179641707925227934e-04
 	 8.23607429774869448380059111514129e-01 1.24511207944372037648150808308856e-01 8.60964854782775897840130241434053e-04
 	 7.56377193406150616361571792367613e-01 1.71967390083852200710623492341256e-01 1.33866441843784474662049088777849e-03
 	 6.82163039113651503697610678500496e-01 2.24353349343561270234914672982995e-01 1.89392745198749745325073057244936e-03
 	 6.02989360559831988339851704949979e-01 2.80240115671381462281175345196971e-01 2.48538102304887405583078141546594e-03
 	 5.21015820870776247275557579996530e-01 3.38103235604003904413161762931850e-01 3.06114493019152321753861833997234e-03
 	 4.38478449224138033812891990237404e-01 3.96364350747119842388599408877781e-01 3.56412061310689169332799330902617e-03
 	 3.57628649976634627183358361435239e-01 4.53434249742970141294762242978322e-01 3.93803429928769530010690402832552e-03
 	 2.80671790060171844061187584884465e-01 5.07756217927769926134828892827500e-01 4.13358349040402785201653301783153e-03
 	 2.09707039588842958366399216174614e-01 5.57848502378179622596121589594986e-01 4.11401950086654095983806911362990e-03
 	 1.46670103677618013371386496146442e-01 6.02344736122044865922475764818955e-01 3.85955487942104234766471648754305e-03
 	 9.32803959285448680560648426762782e-02 6.40031227084502774005159153603017e-01 3.37010782991162055263756336387360e-03
 	 5.09940415878906705415829492267221e-02 6.69880132011726692198294585978147e-01 2.66607691583816384939265020648236e-03
 	 2.09636483937665207832878877525218e-02 6.91077853247221929322563482855912e-01 1.78709913418789289457633273627835e-03
 	 4.00147938386741230942789115943015e-03 7.03051034147549103181518148630857e-01 7.90000888569303109931762918449749e-04
 	 9.89866848202597182648787565995008e-01 6.34277657900481940667081204310307e-03 1.41170244001334730163778677369812e-05
 	 9.66300751945632585560019833792467e-01 2.10938122277119152747637542688608e-02 8.32081072007833050328123869476826e-05
 	 9.30020889699693320551432407228276e-01 4.38029421355502074364451914334495e-02 2.43329864961126812348754522297156e-04
 	 8.82019825362079235020473788608797e-01 7.38488777669456530894365187123185e-02 5.17966946980983884533944472394751e-04
 	 8.23607429774869448380059111514129e-01 1.10411714489581258558104082112550e-01 9.14352238558889009178987095083357e-04
 	 7.56377193406150505339269329851959e-01 1.52494017919572899533164900276461e-01 1.42167337130921366157576546385144e-03
 	 6.82163039113651503697610678500496e-01 1.98947856674634743212592979944020e-01 2.01136759041089857244499761179668e-03
 	 6.02989360559831988339851704949979e-01 2.48506075484061506042365863322630e-01 2.63949647825041829041214924700398e-03
 	 5.21015820870776247275557579996530e-01 2.99816848088013954143349337755353e-01 3.25096280518906996861994151970521e-03
 	 4.38478449224138033812891990237404e-01 3.51480547422617473074524241383187e-01 3.78512739862115182160051674031820e-03
 	 3.57628649976634571672207130177412e-01 4.02087922436554001670572233706480e-01 4.18222701783090792387875822555543e-03
 	 2.80671790060171677527733891110984e-01 4.50258538887499282221682506133220e-01 4.38990197651515159926738363083132e-03
 	 2.09707039588842902855247984916787e-01 4.94678435699844876172193153252010e-01 4.36912484777479594860727374339149e-03
 	 1.46670103677617902349084033630788e-01 5.34135971588375335628029461076949e-01 4.09888118456343784890005821353043e-03
 	 9.32803959285448680560648426762782e-02 5.67554891450755105708481096371543e-01 3.57908411864499764395985970111269e-03
 	 5.09940415878905595192804867110681e-02 5.94023743717642771500209164514672e-01 2.83139710363886033459013269464322e-03
 	 2.09636483937665207832878877525218e-02 6.12821061513554754540678004559595e-01 1.89791497851979698574531596477755e-03
 	 4.00147938386741230942789115943015e-03 6.23438414384226646802744653541595e-01 8.38987883087402054604897472245284e-04
 	 9.89866848202597182648787565995008e-01 5.49609493659073376770063390495125e-03 1.45351732210301970752656247620749e-05
 	 9.66300751945632585560019833792467e-01 1.82780511238365486748058685861906e-02 8.56727464143223067490409694535458e-05
 	 9.30020889699693320551432407228276e-01 3.79557951443320884532539594147238e-02 2.50537339655403903850711122558437e-04
 	 8.82019825362079235020473788608797e-01 6.39909727407583783787003994802944e-02 5.33309221812040129551135692054231e-04
 	 8.23607429774869448380059111514129e-01 9.56731263332156328660360600224521e-02 9.41435517555988749319184627495360e-04
 	 7.56377193406150616361571792367613e-01 1.32137966600053613497323112824233e-01 1.46378359419071547853352655010895e-03
 	 6.82163039113651503697610678500496e-01 1.72390796695317150000192896186491e-01 2.07094466292146589525557942579326e-03
 	 6.02989360559831988339851704949979e-01 2.15333610788208007491562057111878e-01 2.71767884224286384101110236599652e-03
 	 5.21015820870776247275557579996530e-01 2.59795034580844352856132672968670e-01 3.34725691259006455716140671086123e-03
 	 4.38478449224138089324043221495231e-01 3.04562273783050618813916798899299e-01 3.89724355807628125569763710700499e-03
 	 3.57628649976634571672207130177412e-01 3.48414194799616772080241844378179e-01 4.30610533996598088962715067395948e-03
 	 2.80671790060171733038885122368811e-01 3.90154634159382784908132180134999e-01 4.51993166855950770366412427847536e-03
 	 2.09707039588843013877550447432441e-01 4.28645028218402390773889010233688e-01 4.49853911750081048026572716480587e-03
 	 1.46670103677618013371386496146442e-01 4.62835474706007388157047444110503e-01 4.22029078801391954733901457075262e-03
 	 9.32803959285449235672160739341052e-02 4.91793385165905039269063081519562e-01 3.68509723880985646388142029650226e-03
 	 5.09940415878904484969780241954140e-02 5.14728975456590465142880930216052e-01 2.91526359892987918520645962416893e-03
 	 2.09636483937665207832878877525218e-02 5.31017085540992583858610487368423e-01 1.95413156410725137243633575678814e-03
 	 4.00147938386741230942789115943015e-03 5.40217154095457230411625459964853e-01 8.63838856218561348260243093477584e-04
 	 9.89866848202597182648787565995008e-01 4.63705686081203067444578280742462e-03 1.45351732210302089337268863222796e-05
 	 9.66300751945632585560019833792467e-01 1.54211969305308761735151534821853e-02 8.56727464143223745116767497975729e-05
 	 9.30020889699693320551432407228276e-01 3.20233151559745563008441138208582e-02 2.50537339655404120691145619659324e-04
 	 8.82019825362079235020473788608797e-01 5.39892018971624282341892353542789e-02 5.33309221812040563232004686256005e-04
 	 8.23607429774869448380059111514129e-01 8.07194438919149742650560597212461e-02 9.41435517555989616680922615898908e-04
 	 7.56377193406150616361571792367613e-01 1.11484839993795881163407557323808e-01 1.46378359419071656273569903561338e-03
 	 6.82163039113651503697610678500496e-01 1.45446164191031429568923272199754e-01 2.07094466292146762997905540260035e-03
 	 6.02989360559831988339851704949979e-01 1.81677028651960059679737469195970e-01 2.71767884224286600941544733700539e-03
 	 5.21015820870776247275557579996530e-01 2.19189144548379510890612209550454e-01 3.34725691259006759292748967027364e-03
 	 4.38478449224138089324043221495231e-01 2.56959276992811458395493673378951e-01 3.89724355807628472514458906061918e-03
 	 3.57628649976634516161055898919585e-01 2.93957155223748822781004719217890e-01 4.30610533996598435907410262757367e-03
 	 2.80671790060171733038885122368811e-01 3.29173575780445704097587622527499e-01 4.51993166855951117311107623208954e-03
 	 2.09707039588842902855247984916787e-01 3.61647932192754872904316698623006e-01 4.49853911750081481707441710682360e-03
 	 1.46670103677618013371386496146442e-01 3.90494421616374820516170984774362e-01 4.22029078801392301678596652436681e-03
 	 9.32803959285448125449136114184512e-02 4.14926218905550314719477000835468e-01 3.68509723880985949964750325591467e-03
 	 5.09940415878905595192804867110681e-02 4.34276982955519308404745970619842e-01 2.91526359892988178729167358937957e-03
 	 2.09636483937665207832878877525218e-02 4.48019266065241117402706549910363e-01 1.95413156410725310715981173359523e-03
 	 4.00147938386741230942789115943015e-03 4.55781366520675579323551573907025e-01 8.63838856218561998781546584780244e-04
 	 9.89866848202597182648787565995008e-01 3.79037521839794243339039070406216e-03 1.41170244001335441671454370982097e-05
 	 9.66300751945632585560019833792467e-01 1.26054358266554991652164119386725e-02 8.32081072007837251611542250806508e-05
 	 9.30020889699693320551432407228276e-01 2.61761681647564165009711700804473e-02 2.43329864961128032076198568489644e-04
 	 8.82019825362079235020473788608797e-01 4.41312968709751118900896926788846e-02 5.17966946980986486619158437605392e-04
 	 8.23607429774869448380059111514129e-01 6.59808557355492930618368063733215e-02 9.14352238558893671248328782752424e-04
 	 7.56377193406150616361571792367613e-01 9.11287886742765396164145386137534e-02 1.42167337130922081731010386818070e-03
 	 6.82163039113651503697610678500496e-01 1.18889104211713753089796341555484e-01 2.01136759041090854710498447843747e-03
 	 6.02989360559831988339851704949979e-01 1.48504563956106450106631200469565e-01 2.63949647825043173451908806725896e-03
 	 5.21015820870776247275557579996530e-01 1.79167331041209798581093082248117e-01 3.25096280518908644849296329937260e-03
 	 4.38478449224138033812891990237404e-01 2.10041003353244493112583768379409e-01 3.78512739862117090355875248519624e-03
 	 3.57628649976634571672207130177412e-01 2.40283427586811426657220636116108e-01 4.18222701783092960792220793564411e-03
 	 2.80671790060171677527733891110984e-01 2.69069671052328984739432371497969e-01 4.38990197651517415067257132932355e-03
 	 2.09707039588843013877550447432441e-01 2.95614524711312165461407630573376e-01 4.36912484777481763265072345348017e-03
 	 1.46670103677618013371386496146442e-01 3.19193924734006762022886505292263e-01 4.09888118456345866558176993521556e-03
 	 9.32803959285448680560648426762782e-02 3.39164712620700026235454060952179e-01 3.57908411864501542487548846338541e-03
 	 5.09940415878905595192804867110681e-02 3.54982214694466668980510348774260e-01 2.83139710363887464605880950330175e-03
 	 2.09636483937665207832878877525218e-02 3.66215290092678835698336570203537e-01 1.89791497851980652672443383721657e-03
 	 4.00147938386741230942789115943015e-03 3.72560106231905940887827455298975e-01 8.38987883087406391413587414263020e-04
 	 9.89866848202597293671090028510662e-01 2.98040738777144344900937866782442e-03 1.32927567189885034726337664778839e-05
 	 9.66300751945632585560019833792467e-01 9.91177176377860263967178866550967e-03 7.83497353774546411060708539508823e-05
 	 9.30020889699693431573734869743930e-01 2.05825651780095139620208044561878e-02 2.29122271500926347892468371014729e-04
 	 8.82019825362079235020473788608797e-01 3.47008503505839699387891528203909e-02 4.87723787927315426474206283558033e-04
 	 8.23607429774869448380059111514129e-01 5.18813622807585417273656958059291e-02 8.60964854782778066244475212442921e-04
 	 7.56377193406150616361571792367613e-01 7.16554165099972939501071778067853e-02 1.33866441843784799922700834429179e-03
 	 6.82163039113651503697610678500496e-01 9.34836115427872815786258797743358e-02 1.89392745198750222374028950866887e-03
 	 6.02989360559831988339851704949979e-01 1.16770523768786549378972949853051e-01 2.48538102304888056104381632849254e-03
 	 5.21015820870776247275557579996530e-01 1.40880943525219903822431888329447e-01 3.06114493019153102379426023560427e-03
 	 4.38478449224138033812891990237404e-01 1.65157200028742234820811063400470e-01 3.56412061310690036694537319306164e-03
 	 3.57628649976634627183358361435239e-01 1.88937100280395398055333089359920e-01 3.93803429928770484108602190076454e-03
 	 2.80671790060171733038885122368811e-01 2.11571992012058451848588447319344e-01 4.13358349040403826035738887867410e-03
 	 2.09707039588842958366399216174614e-01 2.32444458032977641082084119261708e-01 4.11401950086655136817892497447247e-03
 	 1.46670103677618013371386496146442e-01 2.50985160200337231728440201550256e-01 3.85955487942105232232470335418384e-03
 	 9.32803959285448680560648426762782e-02 2.66688376986952579983380928752013e-01 3.37010782991162879257407425370729e-03
 	 5.09940415878905595192804867110681e-02 2.79125826400382859304727389826439e-01 2.66607691583817035460568511950896e-03
 	 2.09636483937665207832878877525218e-02 2.87958498359011660916451091907220e-01 1.78709913418789744822545717539697e-03
 	 4.00147938386741230942789115943015e-03 2.92947486468583706553658885241020e-01 7.90000888569305061495673392357730e-04
 	 9.89866848202597293671090028510662e-01 2.23045449718607680100745938034379e-03 1.20860844646721754563250053604584e-05
 	 9.66300751945632585560019833792467e-01 7.41769598220353224005130243767780e-03 7.12374069258289119863439275981420e-05
 	 9.30020889699693320551432407228276e-01 1.54034227848442797914607638176676e-02 2.08323313563844761224508328467664e-04
 	 8.82019825362079235020473788608797e-01 2.59691571153012057404652068726136e-02 4.43449844222225549299903901712128e-04
 	 8.23607429774869448380059111514129e-01 3.88265772974697997987902908789692e-02 7.82809328117356722880060271307912e-04
 	 7.56377193406150505339269329851959e-01 5.36249328391213975208984265918843e-02 1.21714491381455340579531565481375e-03
 	 6.82163039113651503697610678500496e-01 6.99605505724897602792822226547287e-02 1.72200301552077970207443868844166e-03
 	 6.02989360559831988339851704949979e-01 8.73878319277729409542132543720072e-02 2.25976639808299004097413842373498e-03
 	 5.21015820870776247275557579996530e-01 1.05431403553392866179194697906496e-01 2.78326437224626476590882973027874e-03
 	 4.38478449224138033812891990237404e-01 1.23599082816063021716956882301020e-01 3.24058159514462387762456785367249e-03
 	 3.57628649976634571672207130177412e-01 1.41395302781346376974624945432879e-01 3.58055264021931362802830811631338e-03
 	 2.80671790060171733038885122368811e-01 1.58334630023437838985955750104040e-01 3.75835052599978597376306765909248e-03
 	 2.09707039588842958366399216174614e-01 1.73955006584956772819339221314294e-01 3.74056249037898374057431460926182e-03
 	 1.46670103677618013371386496146442e-01 1.87830355538878501775457152689341e-01 3.50919732113099368253639198655947e-03
 	 9.32803959285448680560648426762782e-02 1.99582208874668154408027476165444e-01 3.06418064728295174575789516779878e-03
 	 5.09940415878905595192804867110681e-02 2.08890052188817509914997572195716e-01 2.42405931856885369785059580749476e-03
 	 2.09636483937665207832878877525218e-02 2.15500179708003392065052139514592e-01 1.62487221718904633997737629869107e-03
 	 4.00147938386741230942789115943015e-03 2.19233800491208996596981251059333e-01 7.18287234789717686338217372821191e-04
 	 9.89866848202597293671090028510662e-01 1.56209099688777233727599025314703e-03 1.05317255644828793850666798226356e-05
 	 9.66300751945632585560019833792467e-01 5.19495740714233031343205482244230e-03 6.20757551265857499510347761173534e-05
 	 9.30020889699693320551432407228276e-01 1.07877332103466228030441698138020e-02 1.81531411066275196646360723384817e-04
 	 8.82019825362079235020473788608797e-01 1.81874082514366514073955727326393e-02 3.86418949380380760162678743796505e-04
 	 8.23607429774869448380059111514129e-01 2.71920574541471560259253692493076e-02 6.82134320436660426291430869838450e-04
 	 7.56377193406150505339269329851959e-01 3.75560339394427344927862577605993e-02 1.06061117163049208576841575535354e-03
 	 6.82163039113651503697610678500496e-01 4.89966266177905285239546628872631e-02 1.50054082723711308851310963774495e-03
 	 6.02989360559831988339851704949979e-01 6.12017620911491366797463342663832e-02 1.96914390380239275740725801711051e-03
 	 5.21015820870776247275557579996530e-01 7.38385142973202457383763430698309e-02 2.42531620787373499575911850456578e-03
 	 4.38478449224138089324043221495231e-01 8.65621848525210402236496065597748e-02 2.82381908956012448938532877207308e-03
 	 3.57628649976634571672207130177412e-01 9.90257051895083728609847639745567e-02 3.12006737055326799704091378373505e-03
 	 2.80671790060171733038885122368811e-01 1.10889103708325831298964203597279e-01 3.27499914721415558843675697175968e-03
 	 2.09707039588842958366399216174614e-01 1.21828779736475656392258315463550e-01 3.25949878313535647278431639506380e-03
 	 1.46670103677618013371386496146442e-01 1.31546331790078019352563387656119e-01 3.05788886763109146391115267249461e-03
 	 9.32803959285448680560648426762782e-02 1.39776701123208169086353791499278e-01 2.67010459437980532393375199262664e-03
 	 5.09940415878905595192804867110681e-02 1.46295416595690563887899315886898e-01 2.11230755252602916960391610246006e-03
 	 2.09636483937665207832878877525218e-02 1.50924796257560833723232462943997e-01 1.41590176031026310742022555899666e-03
 	 4.00147938386741230942789115943015e-03 1.53539624499336890828260493435664e-01 6.25910240441280522200040437041935e-04
 	 9.89866848202597293671090028510662e-01 9.94543723904412618752601815685921e-04 8.67440833377313944582785026904403e-06
 	 9.66300751945632585560019833792467e-01 3.30749763971358023972868522832869e-03 5.11284161648923107866375470376141e-05
 	 9.30020889699693320551432407228276e-01 6.86827616373250626757851478032535e-03 1.49517529236170646769407688303488e-04
 	 8.82019825362079235020473788608797e-01 1.15794616104897551966956825708621e-02 3.18272227500605246058862363156550e-04
 	 8.23607429774869448380059111514129e-01 1.73124934046420264621701790019870e-02 5.61836861179071324519374019956786e-04
 	 7.56377193406150505339269329851959e-01 2.39109744077843355825052640284412e-02 8.73567615273895857821995214465005e-04
 	 6.82163039113651503697610678500496e-01 3.11949096386171520478569618717302e-02 1.23591369498352184573553014246272e-03
 	 6.02989360559831988339851704949979e-01 3.89656098786262394817470067209797e-02 1.62187650874102084162797776656362e-03
 	 5.21015820870776247275557579996530e-01 4.70111095468416229081753954233136e-02 1.99760077271326011438823400112597e-03
 	 4.38478449224138033812891990237404e-01 5.51119479236800158261644355661701e-02 2.32582587664025919674259945679751e-03
 	 3.57628649976634571672207130177412e-01 6.30471552538560686684832035098225e-02 2.56982943918837537441990370723488e-03
 	 2.80671790060171733038885122368811e-01 7.06002802411799246229406890051905e-02 2.69743829933241250837450131427886e-03
 	 2.09707039588842958366399216174614e-01 7.75652945438169982850240558036603e-02 2.68467149426154230371088793560830e-03
 	 1.46670103677618013371386496146442e-01 8.37522135042871873622516432078555e-02 2.51861639526434729144388491306472e-03
 	 9.32803959285448680560648426762782e-02 8.89922809408117965190854192769621e-02 2.19921962490592006606027197790354e-03
 	 5.09940415878905595192804867110681e-02 9.31425817709123915477675836882554e-02 1.73979260330483272850576881296547e-03
 	 2.09636483937665207832878877525218e-02 9.60899904029682838668691147177014e-02 1.16620110866347574327117619930050e-03
 	 4.00147938386741230942789115943015e-03 9.77547852338248590697844520036597e-02 5.15528150884207270014669699520482e-04
 	 9.89866848202597293671090028510662e-01 5.44137754823457303610112489877793e-04 6.56761013022146155509485565548999e-06
 	 9.66300751945632585560019833792467e-01 1.80960806096305132362189738159941e-03 3.87105945473361211131395342999184e-05
 	 9.30020889699693431573734869743930e-01 3.75779192147421281511299184785457e-03 1.13203437268905417537045998699341e-04
 	 8.82019825362079235020473788608797e-01 6.33538987915015228136184077811777e-03 2.40971813300827706477713618937742e-04
 	 8.23607429774869448380059111514129e-01 9.47206348516785312519061790226260e-03 4.25380650648535642635583720050363e-04
 	 7.56377193406150505339269329851959e-01 1.30822442665612104217842670550453e-02 6.61399751861887433973530292519172e-04
 	 6.82163039113651503697610678500496e-01 1.70674528275533421428633573668776e-02 9.35740974015519290374331973225708e-04
 	 6.02989360559832099362154167465633e-01 2.13189817250510893487103203369770e-02 1.22796301245164810392318521792276e-03
 	 5.21015820870776247275557579996530e-01 2.57208597125857529874792817281559e-02 1.51243319039181135093885544051773e-03
 	 4.38478449224138033812891990237404e-01 3.01530147808974913203883261303417e-02 1.76094057378891016667210589474735e-03
 	 3.57628649976634571672207130177412e-01 3.44945492925723407040550227975473e-02 1.94568173509230939177694352792969e-03
 	 2.80671790060171733038885122368811e-01 3.86270377631329209222599274653476e-02 2.04229757450639058669050740491002e-03
 	 2.09707039588842958366399216174614e-01 4.24377573462515478297518711769953e-02 2.03263150910022857495440540276377e-03
 	 1.46670103677618013371386496146442e-01 4.58227630644600925080567321856506e-02 1.90690706676532070566743026773793e-03
 	 9.32803959285448680560648426762782e-02 4.86897245277935208918052012450062e-02 1.66508383411913588566244381894421e-03
 	 5.09940415878905595192804867110681e-02 5.09604496062918688181753168464638e-02 1.31724021815549660954780541999298e-03
 	 2.09636483937665207832878877525218e-02 5.25730446858705402490841152030043e-02 8.82959842380651779153444280723306e-04
 	 4.00147938386741230942789115943015e-03 5.34838922431279950586713312077336e-02 3.90319175197131787002219338589271e-04
 	 9.89866848202597182648787565995008e-01 2.23821312401371180778042457859556e-04 4.27219699246649623614177290753524e-06
 	 9.66300751945632585560019833792467e-01 7.44349840727853706567884728428908e-04 2.51810449040985753852567308186394e-05
 	 9.30020889699693320551432407228276e-01 1.54570035278751849450173949662712e-03 7.36382602876549434639877333985680e-05
 	 8.82019825362079235020473788608797e-01 2.60594907219002802634122417657636e-03 1.56750939175842932387511252656509e-04
 	 8.23607429774869448380059111514129e-01 3.89616353874802645584907168085920e-03 2.76707950125053346417114408239968e-04
 	 7.56377193406150616361571792367613e-01 5.38114669482372964814942406519549e-03 4.30237175273246797487652903768662e-04
 	 6.82163039113651503697610678500496e-01 7.02039080609445642622290506551508e-03 6.08694745219593184512585359868808e-04
 	 6.02989360559831988339851704949979e-01 8.76918101430018692710177674598526e-03 7.98783695231179875773097620594854e-04
 	 5.21015820870776247275557579996530e-01 1.05798146258575531675205638748594e-02 9.83830099409467194113143584388581e-04
 	 4.38478449224138033812891990237404e-01 1.24029021719106458121473224309739e-02 1.14548288861347617208219507034528e-03
 	 3.57628649976634571672207130177412e-01 1.41887145762606969867647421779111e-02 1.26565607460594879186965844297674e-03
 	 2.80671790060171733038885122368811e-01 1.58885396385088917270422825822607e-02 1.32850418683936244076959631854606e-03
 	 2.09707039588842958366399216174614e-01 1.74560108362461496867013011069503e-02 1.32221646044598751743026632254896e-03
 	 1.46670103677618013371386496146442e-01 1.88483722660856001240858859091531e-02 1.24043335003401044430715316480018e-03
 	 9.32803959285448680560648426762782e-02 2.00276454770312861697334483324084e-02 1.08312856690360266240236164492217e-03
 	 5.09940415878905595192804867110681e-02 2.09616675379284966851400895393454e-02 8.56858063554095743773186821812260e-04
 	 2.09636483937665207832878877525218e-02 2.16249796199957655673529188788962e-02 5.74360887490761107612713409764638e-04
 	 4.00147938386741230942789115943015e-03 2.19996404367756026587699125229847e-02 2.53900638636563003806140281781722e-04
 	 9.89866848202597293671090028510662e-01 4.27357143881167134136234153629630e-05 1.85756222332536916039854961446576e-06
 	 9.66300751945632585560019833792467e-01 1.42123740839932011237323195018689e-04 1.09487829892198331246814038686388e-05
 	 9.30020889699693320551432407228276e-01 2.95131004718091061178597556136083e-04 3.20181046761085851101898136494839e-05
 	 8.82019825362079235020473788608797e-01 4.97571451369999140368349799246062e-04 6.81557108900338108571290152148947e-05
 	 8.23607429774869448380059111514129e-01 7.43920810824028055918688551173545e-04 1.20313327300328222761900687221015e-04
 	 7.56377193406150505339269329851959e-01 1.02745867121961653722905793983955e-03 1.87068228657779131321806098675609e-04
 	 6.82163039113651503697610678500496e-01 1.34045061733972792339386614912655e-03 2.64662038349450874554630308566061e-04
 	 6.02989360559831988339851704949979e-01 1.67435893938816526826940389582887e-03 3.47313201962870553903689474495309e-04
 	 5.21015820870776247275557579996530e-01 2.02007543999682681601370859425515e-03 4.27771853698715094106719281086271e-04
 	 4.38478449224138033812891990237404e-01 2.36816985440602145729371841298416e-03 4.98058901568945375237795758494030e-04
 	 3.57628649976634571672207130177412e-01 2.70914707433311807704967577592470e-03 5.50310511443187532279464058149188e-04
 	 2.80671790060171733038885122368811e-01 3.03370615045783775798327042139135e-03 5.77637032036214270215579436040798e-04
 	 2.09707039588842958366399216174614e-01 3.33299400959596869853385214810260e-03 5.74903112453494847568225001310793e-04
 	 1.46670103677618013371386496146442e-01 3.59884697843182443932619207771495e-03 5.39343606027357599409788324607007e-04
 	 9.32803959285448680560648426762782e-02 3.82401357489137172507298600976355e-03 4.70947082363607893301660212159732e-04
 	 5.09940415878905595192804867110681e-02 4.00235271336957243448750887182541e-03 3.72564086444639511446624835500074e-04
 	 2.09636483937665207832878877525218e-02 4.12900336779242760343322515836917e-03 2.49733588839615606048277784978495e-04
 	 4.00147938386741230942789115943015e-03 4.20053988719948367958068047300912e-03 1.10396649695961748100479782319638e-04
 	 ];
 
 	 case  35 

 	 % ALG. DEG.:   35
 	 % PTS CARD.:  324
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.89866848202597293671090028510662e-01 1.00904160830146451266475793318023e-02 1.85756222332538250116746886969610e-06
 	 9.66300751945632585560019833792467e-01 3.35571243135274824287428430125146e-02 1.09487829892199127457784457728707e-05
 	 9.30020889699693320551432407228276e-01 6.96839792955885328762377639577608e-02 3.20181046761088155031514668191761e-05
 	 8.82019825362079235020473788608797e-01 1.17482603186550751961370053777500e-01 6.81557108900342987481066336918900e-05
 	 8.23607429774869448380059111514129e-01 1.75648649414306495808446584305784e-01 1.20313327300329090123638675624562e-04
 	 7.56377193406150505339269329851959e-01 2.42595347922629794856774765321461e-01 1.87068228657780486574521705556151e-04
 	 6.82163039113651503697610678500496e-01 3.16496510269008712867844224092551e-01 2.64662038349452771908432158198821e-04
 	 6.02989360559832099362154167465633e-01 3.95336280500779735369576428638538e-01 3.47313201962873101778794815430729e-04
 	 5.21015820870776247275557579996530e-01 4.76964103689226870397277480151388e-01 4.27771853698718184082910864773908e-04
 	 4.38478449224138033812891990237404e-01 5.59153380921455833707511828833958e-01 4.98058901568948953104964960658663e-04
 	 3.57628649976634571672207130177412e-01 6.39662202949032199228440731531009e-01 5.50310511443191543827502254515593e-04
 	 2.80671790060171733038885122368811e-01 7.16294503789370318180829144694144e-01 5.77637032036218498604052129508091e-04
 	 2.09707039588842958366399216174614e-01 7.86959966401560961912764469161630e-01 5.74903112453498967536480446227642e-04
 	 1.46670103677618013371386496146442e-01 8.49731049343950051166984849260189e-01 5.39343606027361502537609272422969e-04
 	 9.32803959285448680560648426762782e-02 9.02895590496563649196559708798304e-01 4.70947082363611254328394917223477e-04
 	 5.09940415878905595192804867110681e-02 9.45003605698739757023929541901452e-01 3.72564086444642167741947424985938e-04
 	 2.09636483937665207832878877525218e-02 9.74907348238440940590976424573455e-01 2.49733588839617449191971010336033e-04
 	 4.00147938386741230942789115943015e-03 9.91797980728932992988688965851907e-01 1.10396649695962547699581990379158e-04
 	 9.89866848202597182648787565995008e-01 9.90933048500138892455968431249858e-03 4.27219699246646150779093548122134e-06
 	 9.66300751945632585560019833792467e-01 3.29548982136395607334122814791044e-02 2.51810449040983720973493897865580e-05
 	 9.30020889699693320551432407228276e-01 6.84334099475190915651268142028130e-02 7.36382602876543471527928663711293e-05
 	 8.82019825362079235020473788608797e-01 1.15374225565730723075397179400170e-01 1.56750939175841658449958582188799e-04
 	 8.23607429774869448380059111514129e-01 1.72496406686382469652940585547185e-01 2.76707950125051069592552188680656e-04
 	 7.56377193406150616361571792367613e-01 2.38241659899025681745854399196105e-01 4.30237175273243328040700950154474e-04
 	 6.82163039113651503697610678500496e-01 3.10816570080253984365015185176162e-01 6.08694745219588197182591926548412e-04
 	 6.02989360559831988339851704949979e-01 3.88241458425867713710744055788382e-01 7.98783695231173370560062707568250e-04
 	 5.21015820870776247275557579996530e-01 4.68404364503366144045770624870784e-01 9.83830099409459171017067191655769e-04
 	 4.38478449224138033812891990237404e-01 5.49118648603951209352658224815968e-01 1.14548288861346706478394619210803e-03
 	 3.57628649976634571672207130177412e-01 6.28182635447104620318725665129023e-01 1.26565607460593838352880258213418e-03
 	 2.80671790060171733038885122368811e-01 7.03439670301319264211770132533275e-01 1.32850418683935181558830596060261e-03
 	 2.09707039588842958366399216174614e-01 7.72836949574910669902294557687128e-01 1.32221646044597667540854146750462e-03
 	 1.46670103677618013371386496146442e-01 8.34481524056296275482225155428750e-01 1.24043335003400046964716629815939e-03
 	 9.32803959285448680560648426762782e-02 8.86691958594423734751899246475659e-01 1.08312856690359377194454726378581e-03
 	 5.09940415878905595192804867110681e-02 9.28044290874180721750974498718278e-01 8.56858063554088804879282914583882e-04
 	 2.09636483937665207832878877525218e-02 9.57411371986237602627056730852928e-01 5.74360887490756445543371722095571e-04
 	 4.00147938386741230942789115943015e-03 9.73998880179356762987197271286277e-01 2.53900638636560943822012559323298e-04
 	 9.89866848202597293671090028510662e-01 9.58901404257930453645109025728743e-03 6.56761013022144207333706880658220e-06
 	 9.66300751945632585560019833792467e-01 3.18896399934043631163582688259339e-02 3.87105945473360059166587077150723e-05
 	 9.30020889699693431573734869743930e-01 6.62213183788324111223033696660423e-02 1.13203437268905092276394253048011e-04
 	 8.82019825362079235020473788608797e-01 1.11644784758770612698164370613085e-01 2.40971813300827001746301503359859e-04
 	 8.23607429774869448380059111514129e-01 1.66920506739962698494750270583609e-01 4.25380650648534395803085361720264e-04
 	 7.56377193406150505339269329851959e-01 2.30540562327288228727795171835169e-01 6.61399751861885482409619818611191e-04
 	 6.82163039113651503697610678500496e-01 3.00769508058795154159525964132627e-01 9.35740974015516579868900759464623e-04
 	 6.02989360559831988339851704949979e-01 3.75691657715116866800286743455217e-01 1.22796301245164441763579876720769e-03
 	 5.21015820870776247275557579996530e-01 4.53263319416637999736963138275314e-01 1.51243319039180701413016549849999e-03
 	 4.38478449224138033812891990237404e-01 5.31368535994964474866719683632255e-01 1.76094057378890517934211246142695e-03
 	 3.57628649976634571672207130177412e-01 6.07876800730793087623737847025041e-01 1.94568173509230375392564660330663e-03
 	 2.80671790060171733038885122368811e-01 6.80701172176695346038854950165842e-01 2.04229757450638494883921048028697e-03
 	 2.09707039588842958366399216174614e-01 7.47855203064905493803848912648391e-01 2.03263150910022250342223948393894e-03
 	 1.46670103677618013371386496146442e-01 8.07507133257921894120556771667907e-01 1.90690706676531506781613334311487e-03
 	 9.32803959285448680560648426762782e-02 8.58029879543661611052129956078716e-01 1.66508383411913111517288488272470e-03
 	 5.09940415878905595192804867110681e-02 8.98045508805817571662544196442468e-01 1.31724021815549292326041896927791e-03
 	 2.09636483937665207832878877525218e-02 9.26463306920362938967627997044474e-01 8.82959842380649177068230315512665e-04
 	 4.00147938386741230942789115943015e-03 9.42514628373004592631900777632836e-01 3.90319175197130648589938228809615e-04
 	 9.89866848202597293671090028510662e-01 9.13860807349834922130860093147930e-03 8.67440833377321737285899766467523e-06
 	 9.66300751945632585560019833792467e-01 3.03917504146538307308045290255905e-02 5.11284161648927783488244314114013e-05
 	 9.30020889699693320551432407228276e-01 6.31108341365741176698378467335715e-02 1.49517529236172002022123295184031e-04
 	 8.82019825362079235020473788608797e-01 1.06400713027430995905042721005884e-01 3.18272227500608173404728074018522e-04
 	 8.23607429774869448380059111514129e-01 1.59080076820488525157770709483884e-01 5.61836861179076420269584701827625e-04
 	 7.56377193406150616361571792367613e-01 2.19711832186065075811498559232859e-01 8.73567615273903772497854358647373e-04
 	 6.82163039113651503697610678500496e-01 2.86642051247731344254532359627774e-01 1.23591369498353312143812399170884e-03
 	 6.02989360559831988339851704949979e-01 3.58045029561541661156098825813388e-01 1.62187650874103558677752356942392e-03
 	 5.21015820870776247275557579996530e-01 4.31973069582382129816267024580156e-01 1.99760077271327789530386276339868e-03
 	 4.38478449224138033812891990237404e-01 5.06409602852181839338641111680772e-01 2.32582587664028001342431117848264e-03
 	 3.57628649976634571672207130177412e-01 5.79324194769509359659309666312765e-01 2.56982943918839879318682939413065e-03
 	 2.80671790060171733038885122368811e-01 6.48727929698648231315871726110345e-01 2.69743829933243722818403398377995e-03
 	 2.09707039588842958366399216174614e-01 7.12727665867339932326274265506072e-01 2.68467149426156658983955161090762e-03
 	 1.46670103677618013371386496146442e-01 7.69577682818094799266361860645702e-01 2.51861639526437027652994160575872e-03
 	 9.32803959285448680560648426762782e-02 8.17727323130643224402547275531106e-01 2.19921962490594001538024571118513e-03
 	 5.09940415878905595192804867110681e-02 8.55863376641196937910649467085022e-01 1.73979260330484855785748710133021e-03
 	 2.09636483937665207832878877525218e-02 8.82946361203265084327540535014123e-01 1.16620110866348636845246655724395e-03
 	 4.00147938386741230942789115943015e-03 8.98243735382307617598485194321256e-01 5.15528150884211932084011387189548e-04
 	 9.89866848202597293671090028510662e-01 8.57106080051498950278521249401820e-03 1.05317255644829115723186754860485e-05
 	 9.66300751945632585560019833792467e-01 2.85042906472250841265481113850910e-02 6.20757551265859396864149610806294e-05
 	 9.30020889699693320551432407228276e-01 5.91913770899600080732660956073232e-02 1.81531411066275711642392653999423e-04
 	 8.82019825362079235020473788608797e-01 9.97927663864841274499184464730206e-02 3.86418949380381898574959853576161e-04
 	 8.23607429774869448380059111514129e-01 1.49200512770983395594015519236564e-01 6.82134320436662486275558592296875e-04
 	 7.56377193406150505339269329851959e-01 2.06066772654406732412368796758528e-01 1.06061117163049512153449871476596e-03
 	 6.82163039113651503697610678500496e-01 2.68840334268558023289585889870068e-01 1.50054082723711742532179957976268e-03
 	 6.02989360559831988339851704949979e-01 3.35808877349018874980401960783638e-01 1.96914390380239882893942393593534e-03
 	 5.21015820870776247275557579996530e-01 4.05145664831903506986066076933639e-01 2.42531620787374236833389140599593e-03
 	 4.38478449224137978301740758979577e-01 4.74959365923340925963458403202822e-01 2.82381908956013272932183966190678e-03
 	 3.57628649976634571672207130177412e-01 5.43345644833857055466808105848031e-01 3.12006737055327753802003165617407e-03
 	 2.80671790060171844061187584884465e-01 6.08439106231502435662150674033910e-01 3.27499914721416512941587484419870e-03
 	 2.09707039588842958366399216174614e-01 6.68464180674681496263644930877490e-01 3.25949878313536601376343426750282e-03
 	 1.46670103677617902349084033630788e-01 7.21783564532304078298352578713093e-01 3.05788886763110057120940155073185e-03
 	 9.32803959285448680560648426762782e-02 7.66942902948247073879883828340098e-01 2.67010459437981313018939388825856e-03
 	 5.09940415878906705415829492267221e-02 8.02710541816418876592820197402034e-01 2.11230755252603524113608202128489e-03
 	 2.09636483937665207832878877525218e-02 8.28111555348672645493479649303481e-01 1.41590176031026744422891550101440e-03
 	 4.00147938386741230942789115943015e-03 8.42458896116795807884614077920560e-01 6.25910240441282365343733662399472e-04
 	 9.89866848202597293671090028510662e-01 7.90269730021668503905374336682144e-03 1.20860844646721297165458536282401e-05
 	 9.66300751945632585560019833792467e-01 2.62815520721638856693758157234697e-02 7.12374069258286544883279622908390e-05
 	 9.30020889699693320551432407228276e-01 5.45756875154623510848495016034576e-02 2.08323313563843975177933276476949e-04
 	 8.82019825362079235020473788608797e-01 9.20110175226195592390610045185895e-02 4.43449844222223868786536549180255e-04
 	 8.23607429774869448380059111514129e-01 1.37565992927660751821150597606902e-01 7.82809328117353795534194560445940e-04
 	 7.56377193406150505339269329851959e-01 1.89997873754728041628681012298330e-01 1.21714491381454885214619121569513e-03
 	 6.82163039113651503697610678500496e-01 2.47876410313858763778682714473689e-01 1.72200301552077341370183827251594e-03
 	 6.02989360559832099362154167465633e-01 3.09622807512395015194783809420187e-01 2.25976639808298136735675853969951e-03
 	 5.21015820870776247275557579996530e-01 3.73552775575830886545247722096974e-01 2.78326437224625435756797386943617e-03
 	 4.38478449224138089324043221495231e-01 4.37922467959798999981302358719404e-01 3.24058159514461173456023601602283e-03
 	 3.57628649976634571672207130177412e-01 5.00976047242019162375470386905363e-01 3.58055264021930018392136929605840e-03
 	 2.80671790060171733038885122368811e-01 5.60993579916390427975159127527149e-01 3.75835052599977209597525984463573e-03
 	 2.09707039588842958366399216174614e-01 6.16337953826200379836564025026746e-01 3.74056249037896942910563780060329e-03
 	 1.46670103677618013371386496146442e-01 6.65499540783503595875458813679870e-01 3.50919732113098023842945316630448e-03
 	 9.32803959285448680560648426762782e-02 7.07137395196787088558210143673932e-01 3.06418064728294003637443232435089e-03
 	 5.09940415878905595192804867110681e-02 7.40115906223291930565721941093216e-01 2.42405931856884459055234692925751e-03
 	 2.09636483937665207832878877525218e-02 7.63536171898230087151659972732887e-01 1.62487221718904026844521037986624e-03
 	 4.00147938386741230942789115943015e-03 7.76764720124923702115893320296891e-01 7.18287234789714975832786159060106e-04
 	 9.89866848202597293671090028510662e-01 7.15274440963131925841356206774435e-03 1.32927567189884695913158763058703e-05
 	 9.66300751945632585560019833792467e-01 2.37874762905888187392022814492520e-02 7.83497353774544378181635129188010e-05
 	 9.30020889699693431573734869743930e-01 4.93965451222971169142894609649375e-02 2.29122271500925778686327816124901e-04
 	 8.82019825362079235020473788608797e-01 8.32793242873368089185248663852690e-02 4.87723787927314179641707925227934e-04
 	 8.23607429774869448380059111514129e-01 1.24511207944372037648150808308856e-01 8.60964854782775897840130241434053e-04
 	 7.56377193406150616361571792367613e-01 1.71967390083852200710623492341256e-01 1.33866441843784474662049088777849e-03
 	 6.82163039113651503697610678500496e-01 2.24353349343561270234914672982995e-01 1.89392745198749745325073057244936e-03
 	 6.02989360559831988339851704949979e-01 2.80240115671381462281175345196971e-01 2.48538102304887405583078141546594e-03
 	 5.21015820870776247275557579996530e-01 3.38103235604003904413161762931850e-01 3.06114493019152321753861833997234e-03
 	 4.38478449224138033812891990237404e-01 3.96364350747119842388599408877781e-01 3.56412061310689169332799330902617e-03
 	 3.57628649976634627183358361435239e-01 4.53434249742970141294762242978322e-01 3.93803429928769530010690402832552e-03
 	 2.80671790060171844061187584884465e-01 5.07756217927769926134828892827500e-01 4.13358349040402785201653301783153e-03
 	 2.09707039588842958366399216174614e-01 5.57848502378179622596121589594986e-01 4.11401950086654095983806911362990e-03
 	 1.46670103677618013371386496146442e-01 6.02344736122044865922475764818955e-01 3.85955487942104234766471648754305e-03
 	 9.32803959285448680560648426762782e-02 6.40031227084502774005159153603017e-01 3.37010782991162055263756336387360e-03
 	 5.09940415878906705415829492267221e-02 6.69880132011726692198294585978147e-01 2.66607691583816384939265020648236e-03
 	 2.09636483937665207832878877525218e-02 6.91077853247221929322563482855912e-01 1.78709913418789289457633273627835e-03
 	 4.00147938386741230942789115943015e-03 7.03051034147549103181518148630857e-01 7.90000888569303109931762918449749e-04
 	 9.89866848202597182648787565995008e-01 6.34277657900481940667081204310307e-03 1.41170244001334730163778677369812e-05
 	 9.66300751945632585560019833792467e-01 2.10938122277119152747637542688608e-02 8.32081072007833050328123869476826e-05
 	 9.30020889699693320551432407228276e-01 4.38029421355502074364451914334495e-02 2.43329864961126812348754522297156e-04
 	 8.82019825362079235020473788608797e-01 7.38488777669456530894365187123185e-02 5.17966946980983884533944472394751e-04
 	 8.23607429774869448380059111514129e-01 1.10411714489581258558104082112550e-01 9.14352238558889009178987095083357e-04
 	 7.56377193406150505339269329851959e-01 1.52494017919572899533164900276461e-01 1.42167337130921366157576546385144e-03
 	 6.82163039113651503697610678500496e-01 1.98947856674634743212592979944020e-01 2.01136759041089857244499761179668e-03
 	 6.02989360559831988339851704949979e-01 2.48506075484061506042365863322630e-01 2.63949647825041829041214924700398e-03
 	 5.21015820870776247275557579996530e-01 2.99816848088013954143349337755353e-01 3.25096280518906996861994151970521e-03
 	 4.38478449224138033812891990237404e-01 3.51480547422617473074524241383187e-01 3.78512739862115182160051674031820e-03
 	 3.57628649976634571672207130177412e-01 4.02087922436554001670572233706480e-01 4.18222701783090792387875822555543e-03
 	 2.80671790060171677527733891110984e-01 4.50258538887499282221682506133220e-01 4.38990197651515159926738363083132e-03
 	 2.09707039588842902855247984916787e-01 4.94678435699844876172193153252010e-01 4.36912484777479594860727374339149e-03
 	 1.46670103677617902349084033630788e-01 5.34135971588375335628029461076949e-01 4.09888118456343784890005821353043e-03
 	 9.32803959285448680560648426762782e-02 5.67554891450755105708481096371543e-01 3.57908411864499764395985970111269e-03
 	 5.09940415878905595192804867110681e-02 5.94023743717642771500209164514672e-01 2.83139710363886033459013269464322e-03
 	 2.09636483937665207832878877525218e-02 6.12821061513554754540678004559595e-01 1.89791497851979698574531596477755e-03
 	 4.00147938386741230942789115943015e-03 6.23438414384226646802744653541595e-01 8.38987883087402054604897472245284e-04
 	 9.89866848202597182648787565995008e-01 5.49609493659073376770063390495125e-03 1.45351732210301970752656247620749e-05
 	 9.66300751945632585560019833792467e-01 1.82780511238365486748058685861906e-02 8.56727464143223067490409694535458e-05
 	 9.30020889699693320551432407228276e-01 3.79557951443320884532539594147238e-02 2.50537339655403903850711122558437e-04
 	 8.82019825362079235020473788608797e-01 6.39909727407583783787003994802944e-02 5.33309221812040129551135692054231e-04
 	 8.23607429774869448380059111514129e-01 9.56731263332156328660360600224521e-02 9.41435517555988749319184627495360e-04
 	 7.56377193406150616361571792367613e-01 1.32137966600053613497323112824233e-01 1.46378359419071547853352655010895e-03
 	 6.82163039113651503697610678500496e-01 1.72390796695317150000192896186491e-01 2.07094466292146589525557942579326e-03
 	 6.02989360559831988339851704949979e-01 2.15333610788208007491562057111878e-01 2.71767884224286384101110236599652e-03
 	 5.21015820870776247275557579996530e-01 2.59795034580844352856132672968670e-01 3.34725691259006455716140671086123e-03
 	 4.38478449224138089324043221495231e-01 3.04562273783050618813916798899299e-01 3.89724355807628125569763710700499e-03
 	 3.57628649976634571672207130177412e-01 3.48414194799616772080241844378179e-01 4.30610533996598088962715067395948e-03
 	 2.80671790060171733038885122368811e-01 3.90154634159382784908132180134999e-01 4.51993166855950770366412427847536e-03
 	 2.09707039588843013877550447432441e-01 4.28645028218402390773889010233688e-01 4.49853911750081048026572716480587e-03
 	 1.46670103677618013371386496146442e-01 4.62835474706007388157047444110503e-01 4.22029078801391954733901457075262e-03
 	 9.32803959285449235672160739341052e-02 4.91793385165905039269063081519562e-01 3.68509723880985646388142029650226e-03
 	 5.09940415878904484969780241954140e-02 5.14728975456590465142880930216052e-01 2.91526359892987918520645962416893e-03
 	 2.09636483937665207832878877525218e-02 5.31017085540992583858610487368423e-01 1.95413156410725137243633575678814e-03
 	 4.00147938386741230942789115943015e-03 5.40217154095457230411625459964853e-01 8.63838856218561348260243093477584e-04
 	 9.89866848202597182648787565995008e-01 4.63705686081203067444578280742462e-03 1.45351732210302089337268863222796e-05
 	 9.66300751945632585560019833792467e-01 1.54211969305308761735151534821853e-02 8.56727464143223745116767497975729e-05
 	 9.30020889699693320551432407228276e-01 3.20233151559745563008441138208582e-02 2.50537339655404120691145619659324e-04
 	 8.82019825362079235020473788608797e-01 5.39892018971624282341892353542789e-02 5.33309221812040563232004686256005e-04
 	 8.23607429774869448380059111514129e-01 8.07194438919149742650560597212461e-02 9.41435517555989616680922615898908e-04
 	 7.56377193406150616361571792367613e-01 1.11484839993795881163407557323808e-01 1.46378359419071656273569903561338e-03
 	 6.82163039113651503697610678500496e-01 1.45446164191031429568923272199754e-01 2.07094466292146762997905540260035e-03
 	 6.02989360559831988339851704949979e-01 1.81677028651960059679737469195970e-01 2.71767884224286600941544733700539e-03
 	 5.21015820870776247275557579996530e-01 2.19189144548379510890612209550454e-01 3.34725691259006759292748967027364e-03
 	 4.38478449224138089324043221495231e-01 2.56959276992811458395493673378951e-01 3.89724355807628472514458906061918e-03
 	 3.57628649976634516161055898919585e-01 2.93957155223748822781004719217890e-01 4.30610533996598435907410262757367e-03
 	 2.80671790060171733038885122368811e-01 3.29173575780445704097587622527499e-01 4.51993166855951117311107623208954e-03
 	 2.09707039588842902855247984916787e-01 3.61647932192754872904316698623006e-01 4.49853911750081481707441710682360e-03
 	 1.46670103677618013371386496146442e-01 3.90494421616374820516170984774362e-01 4.22029078801392301678596652436681e-03
 	 9.32803959285448125449136114184512e-02 4.14926218905550314719477000835468e-01 3.68509723880985949964750325591467e-03
 	 5.09940415878905595192804867110681e-02 4.34276982955519308404745970619842e-01 2.91526359892988178729167358937957e-03
 	 2.09636483937665207832878877525218e-02 4.48019266065241117402706549910363e-01 1.95413156410725310715981173359523e-03
 	 4.00147938386741230942789115943015e-03 4.55781366520675579323551573907025e-01 8.63838856218561998781546584780244e-04
 	 9.89866848202597182648787565995008e-01 3.79037521839794243339039070406216e-03 1.41170244001335441671454370982097e-05
 	 9.66300751945632585560019833792467e-01 1.26054358266554991652164119386725e-02 8.32081072007837251611542250806508e-05
 	 9.30020889699693320551432407228276e-01 2.61761681647564165009711700804473e-02 2.43329864961128032076198568489644e-04
 	 8.82019825362079235020473788608797e-01 4.41312968709751118900896926788846e-02 5.17966946980986486619158437605392e-04
 	 8.23607429774869448380059111514129e-01 6.59808557355492930618368063733215e-02 9.14352238558893671248328782752424e-04
 	 7.56377193406150616361571792367613e-01 9.11287886742765396164145386137534e-02 1.42167337130922081731010386818070e-03
 	 6.82163039113651503697610678500496e-01 1.18889104211713753089796341555484e-01 2.01136759041090854710498447843747e-03
 	 6.02989360559831988339851704949979e-01 1.48504563956106450106631200469565e-01 2.63949647825043173451908806725896e-03
 	 5.21015820870776247275557579996530e-01 1.79167331041209798581093082248117e-01 3.25096280518908644849296329937260e-03
 	 4.38478449224138033812891990237404e-01 2.10041003353244493112583768379409e-01 3.78512739862117090355875248519624e-03
 	 3.57628649976634571672207130177412e-01 2.40283427586811426657220636116108e-01 4.18222701783092960792220793564411e-03
 	 2.80671790060171677527733891110984e-01 2.69069671052328984739432371497969e-01 4.38990197651517415067257132932355e-03
 	 2.09707039588843013877550447432441e-01 2.95614524711312165461407630573376e-01 4.36912484777481763265072345348017e-03
 	 1.46670103677618013371386496146442e-01 3.19193924734006762022886505292263e-01 4.09888118456345866558176993521556e-03
 	 9.32803959285448680560648426762782e-02 3.39164712620700026235454060952179e-01 3.57908411864501542487548846338541e-03
 	 5.09940415878905595192804867110681e-02 3.54982214694466668980510348774260e-01 2.83139710363887464605880950330175e-03
 	 2.09636483937665207832878877525218e-02 3.66215290092678835698336570203537e-01 1.89791497851980652672443383721657e-03
 	 4.00147938386741230942789115943015e-03 3.72560106231905940887827455298975e-01 8.38987883087406391413587414263020e-04
 	 9.89866848202597293671090028510662e-01 2.98040738777144344900937866782442e-03 1.32927567189885034726337664778839e-05
 	 9.66300751945632585560019833792467e-01 9.91177176377860263967178866550967e-03 7.83497353774546411060708539508823e-05
 	 9.30020889699693431573734869743930e-01 2.05825651780095139620208044561878e-02 2.29122271500926347892468371014729e-04
 	 8.82019825362079235020473788608797e-01 3.47008503505839699387891528203909e-02 4.87723787927315426474206283558033e-04
 	 8.23607429774869448380059111514129e-01 5.18813622807585417273656958059291e-02 8.60964854782778066244475212442921e-04
 	 7.56377193406150616361571792367613e-01 7.16554165099972939501071778067853e-02 1.33866441843784799922700834429179e-03
 	 6.82163039113651503697610678500496e-01 9.34836115427872815786258797743358e-02 1.89392745198750222374028950866887e-03
 	 6.02989360559831988339851704949979e-01 1.16770523768786549378972949853051e-01 2.48538102304888056104381632849254e-03
 	 5.21015820870776247275557579996530e-01 1.40880943525219903822431888329447e-01 3.06114493019153102379426023560427e-03
 	 4.38478449224138033812891990237404e-01 1.65157200028742234820811063400470e-01 3.56412061310690036694537319306164e-03
 	 3.57628649976634627183358361435239e-01 1.88937100280395398055333089359920e-01 3.93803429928770484108602190076454e-03
 	 2.80671790060171733038885122368811e-01 2.11571992012058451848588447319344e-01 4.13358349040403826035738887867410e-03
 	 2.09707039588842958366399216174614e-01 2.32444458032977641082084119261708e-01 4.11401950086655136817892497447247e-03
 	 1.46670103677618013371386496146442e-01 2.50985160200337231728440201550256e-01 3.85955487942105232232470335418384e-03
 	 9.32803959285448680560648426762782e-02 2.66688376986952579983380928752013e-01 3.37010782991162879257407425370729e-03
 	 5.09940415878905595192804867110681e-02 2.79125826400382859304727389826439e-01 2.66607691583817035460568511950896e-03
 	 2.09636483937665207832878877525218e-02 2.87958498359011660916451091907220e-01 1.78709913418789744822545717539697e-03
 	 4.00147938386741230942789115943015e-03 2.92947486468583706553658885241020e-01 7.90000888569305061495673392357730e-04
 	 9.89866848202597293671090028510662e-01 2.23045449718607680100745938034379e-03 1.20860844646721754563250053604584e-05
 	 9.66300751945632585560019833792467e-01 7.41769598220353224005130243767780e-03 7.12374069258289119863439275981420e-05
 	 9.30020889699693320551432407228276e-01 1.54034227848442797914607638176676e-02 2.08323313563844761224508328467664e-04
 	 8.82019825362079235020473788608797e-01 2.59691571153012057404652068726136e-02 4.43449844222225549299903901712128e-04
 	 8.23607429774869448380059111514129e-01 3.88265772974697997987902908789692e-02 7.82809328117356722880060271307912e-04
 	 7.56377193406150505339269329851959e-01 5.36249328391213975208984265918843e-02 1.21714491381455340579531565481375e-03
 	 6.82163039113651503697610678500496e-01 6.99605505724897602792822226547287e-02 1.72200301552077970207443868844166e-03
 	 6.02989360559831988339851704949979e-01 8.73878319277729409542132543720072e-02 2.25976639808299004097413842373498e-03
 	 5.21015820870776247275557579996530e-01 1.05431403553392866179194697906496e-01 2.78326437224626476590882973027874e-03
 	 4.38478449224138033812891990237404e-01 1.23599082816063021716956882301020e-01 3.24058159514462387762456785367249e-03
 	 3.57628649976634571672207130177412e-01 1.41395302781346376974624945432879e-01 3.58055264021931362802830811631338e-03
 	 2.80671790060171733038885122368811e-01 1.58334630023437838985955750104040e-01 3.75835052599978597376306765909248e-03
 	 2.09707039588842958366399216174614e-01 1.73955006584956772819339221314294e-01 3.74056249037898374057431460926182e-03
 	 1.46670103677618013371386496146442e-01 1.87830355538878501775457152689341e-01 3.50919732113099368253639198655947e-03
 	 9.32803959285448680560648426762782e-02 1.99582208874668154408027476165444e-01 3.06418064728295174575789516779878e-03
 	 5.09940415878905595192804867110681e-02 2.08890052188817509914997572195716e-01 2.42405931856885369785059580749476e-03
 	 2.09636483937665207832878877525218e-02 2.15500179708003392065052139514592e-01 1.62487221718904633997737629869107e-03
 	 4.00147938386741230942789115943015e-03 2.19233800491208996596981251059333e-01 7.18287234789717686338217372821191e-04
 	 9.89866848202597293671090028510662e-01 1.56209099688777233727599025314703e-03 1.05317255644828793850666798226356e-05
 	 9.66300751945632585560019833792467e-01 5.19495740714233031343205482244230e-03 6.20757551265857499510347761173534e-05
 	 9.30020889699693320551432407228276e-01 1.07877332103466228030441698138020e-02 1.81531411066275196646360723384817e-04
 	 8.82019825362079235020473788608797e-01 1.81874082514366514073955727326393e-02 3.86418949380380760162678743796505e-04
 	 8.23607429774869448380059111514129e-01 2.71920574541471560259253692493076e-02 6.82134320436660426291430869838450e-04
 	 7.56377193406150505339269329851959e-01 3.75560339394427344927862577605993e-02 1.06061117163049208576841575535354e-03
 	 6.82163039113651503697610678500496e-01 4.89966266177905285239546628872631e-02 1.50054082723711308851310963774495e-03
 	 6.02989360559831988339851704949979e-01 6.12017620911491366797463342663832e-02 1.96914390380239275740725801711051e-03
 	 5.21015820870776247275557579996530e-01 7.38385142973202457383763430698309e-02 2.42531620787373499575911850456578e-03
 	 4.38478449224138089324043221495231e-01 8.65621848525210402236496065597748e-02 2.82381908956012448938532877207308e-03
 	 3.57628649976634571672207130177412e-01 9.90257051895083728609847639745567e-02 3.12006737055326799704091378373505e-03
 	 2.80671790060171733038885122368811e-01 1.10889103708325831298964203597279e-01 3.27499914721415558843675697175968e-03
 	 2.09707039588842958366399216174614e-01 1.21828779736475656392258315463550e-01 3.25949878313535647278431639506380e-03
 	 1.46670103677618013371386496146442e-01 1.31546331790078019352563387656119e-01 3.05788886763109146391115267249461e-03
 	 9.32803959285448680560648426762782e-02 1.39776701123208169086353791499278e-01 2.67010459437980532393375199262664e-03
 	 5.09940415878905595192804867110681e-02 1.46295416595690563887899315886898e-01 2.11230755252602916960391610246006e-03
 	 2.09636483937665207832878877525218e-02 1.50924796257560833723232462943997e-01 1.41590176031026310742022555899666e-03
 	 4.00147938386741230942789115943015e-03 1.53539624499336890828260493435664e-01 6.25910240441280522200040437041935e-04
 	 9.89866848202597293671090028510662e-01 9.94543723904412618752601815685921e-04 8.67440833377313944582785026904403e-06
 	 9.66300751945632585560019833792467e-01 3.30749763971358023972868522832869e-03 5.11284161648923107866375470376141e-05
 	 9.30020889699693320551432407228276e-01 6.86827616373250626757851478032535e-03 1.49517529236170646769407688303488e-04
 	 8.82019825362079235020473788608797e-01 1.15794616104897551966956825708621e-02 3.18272227500605246058862363156550e-04
 	 8.23607429774869448380059111514129e-01 1.73124934046420264621701790019870e-02 5.61836861179071324519374019956786e-04
 	 7.56377193406150505339269329851959e-01 2.39109744077843355825052640284412e-02 8.73567615273895857821995214465005e-04
 	 6.82163039113651503697610678500496e-01 3.11949096386171520478569618717302e-02 1.23591369498352184573553014246272e-03
 	 6.02989360559831988339851704949979e-01 3.89656098786262394817470067209797e-02 1.62187650874102084162797776656362e-03
 	 5.21015820870776247275557579996530e-01 4.70111095468416229081753954233136e-02 1.99760077271326011438823400112597e-03
 	 4.38478449224138033812891990237404e-01 5.51119479236800158261644355661701e-02 2.32582587664025919674259945679751e-03
 	 3.57628649976634571672207130177412e-01 6.30471552538560686684832035098225e-02 2.56982943918837537441990370723488e-03
 	 2.80671790060171733038885122368811e-01 7.06002802411799246229406890051905e-02 2.69743829933241250837450131427886e-03
 	 2.09707039588842958366399216174614e-01 7.75652945438169982850240558036603e-02 2.68467149426154230371088793560830e-03
 	 1.46670103677618013371386496146442e-01 8.37522135042871873622516432078555e-02 2.51861639526434729144388491306472e-03
 	 9.32803959285448680560648426762782e-02 8.89922809408117965190854192769621e-02 2.19921962490592006606027197790354e-03
 	 5.09940415878905595192804867110681e-02 9.31425817709123915477675836882554e-02 1.73979260330483272850576881296547e-03
 	 2.09636483937665207832878877525218e-02 9.60899904029682838668691147177014e-02 1.16620110866347574327117619930050e-03
 	 4.00147938386741230942789115943015e-03 9.77547852338248590697844520036597e-02 5.15528150884207270014669699520482e-04
 	 9.89866848202597293671090028510662e-01 5.44137754823457303610112489877793e-04 6.56761013022146155509485565548999e-06
 	 9.66300751945632585560019833792467e-01 1.80960806096305132362189738159941e-03 3.87105945473361211131395342999184e-05
 	 9.30020889699693431573734869743930e-01 3.75779192147421281511299184785457e-03 1.13203437268905417537045998699341e-04
 	 8.82019825362079235020473788608797e-01 6.33538987915015228136184077811777e-03 2.40971813300827706477713618937742e-04
 	 8.23607429774869448380059111514129e-01 9.47206348516785312519061790226260e-03 4.25380650648535642635583720050363e-04
 	 7.56377193406150505339269329851959e-01 1.30822442665612104217842670550453e-02 6.61399751861887433973530292519172e-04
 	 6.82163039113651503697610678500496e-01 1.70674528275533421428633573668776e-02 9.35740974015519290374331973225708e-04
 	 6.02989360559832099362154167465633e-01 2.13189817250510893487103203369770e-02 1.22796301245164810392318521792276e-03
 	 5.21015820870776247275557579996530e-01 2.57208597125857529874792817281559e-02 1.51243319039181135093885544051773e-03
 	 4.38478449224138033812891990237404e-01 3.01530147808974913203883261303417e-02 1.76094057378891016667210589474735e-03
 	 3.57628649976634571672207130177412e-01 3.44945492925723407040550227975473e-02 1.94568173509230939177694352792969e-03
 	 2.80671790060171733038885122368811e-01 3.86270377631329209222599274653476e-02 2.04229757450639058669050740491002e-03
 	 2.09707039588842958366399216174614e-01 4.24377573462515478297518711769953e-02 2.03263150910022857495440540276377e-03
 	 1.46670103677618013371386496146442e-01 4.58227630644600925080567321856506e-02 1.90690706676532070566743026773793e-03
 	 9.32803959285448680560648426762782e-02 4.86897245277935208918052012450062e-02 1.66508383411913588566244381894421e-03
 	 5.09940415878905595192804867110681e-02 5.09604496062918688181753168464638e-02 1.31724021815549660954780541999298e-03
 	 2.09636483937665207832878877525218e-02 5.25730446858705402490841152030043e-02 8.82959842380651779153444280723306e-04
 	 4.00147938386741230942789115943015e-03 5.34838922431279950586713312077336e-02 3.90319175197131787002219338589271e-04
 	 9.89866848202597182648787565995008e-01 2.23821312401371180778042457859556e-04 4.27219699246649623614177290753524e-06
 	 9.66300751945632585560019833792467e-01 7.44349840727853706567884728428908e-04 2.51810449040985753852567308186394e-05
 	 9.30020889699693320551432407228276e-01 1.54570035278751849450173949662712e-03 7.36382602876549434639877333985680e-05
 	 8.82019825362079235020473788608797e-01 2.60594907219002802634122417657636e-03 1.56750939175842932387511252656509e-04
 	 8.23607429774869448380059111514129e-01 3.89616353874802645584907168085920e-03 2.76707950125053346417114408239968e-04
 	 7.56377193406150616361571792367613e-01 5.38114669482372964814942406519549e-03 4.30237175273246797487652903768662e-04
 	 6.82163039113651503697610678500496e-01 7.02039080609445642622290506551508e-03 6.08694745219593184512585359868808e-04
 	 6.02989360559831988339851704949979e-01 8.76918101430018692710177674598526e-03 7.98783695231179875773097620594854e-04
 	 5.21015820870776247275557579996530e-01 1.05798146258575531675205638748594e-02 9.83830099409467194113143584388581e-04
 	 4.38478449224138033812891990237404e-01 1.24029021719106458121473224309739e-02 1.14548288861347617208219507034528e-03
 	 3.57628649976634571672207130177412e-01 1.41887145762606969867647421779111e-02 1.26565607460594879186965844297674e-03
 	 2.80671790060171733038885122368811e-01 1.58885396385088917270422825822607e-02 1.32850418683936244076959631854606e-03
 	 2.09707039588842958366399216174614e-01 1.74560108362461496867013011069503e-02 1.32221646044598751743026632254896e-03
 	 1.46670103677618013371386496146442e-01 1.88483722660856001240858859091531e-02 1.24043335003401044430715316480018e-03
 	 9.32803959285448680560648426762782e-02 2.00276454770312861697334483324084e-02 1.08312856690360266240236164492217e-03
 	 5.09940415878905595192804867110681e-02 2.09616675379284966851400895393454e-02 8.56858063554095743773186821812260e-04
 	 2.09636483937665207832878877525218e-02 2.16249796199957655673529188788962e-02 5.74360887490761107612713409764638e-04
 	 4.00147938386741230942789115943015e-03 2.19996404367756026587699125229847e-02 2.53900638636563003806140281781722e-04
 	 9.89866848202597293671090028510662e-01 4.27357143881167134136234153629630e-05 1.85756222332536916039854961446576e-06
 	 9.66300751945632585560019833792467e-01 1.42123740839932011237323195018689e-04 1.09487829892198331246814038686388e-05
 	 9.30020889699693320551432407228276e-01 2.95131004718091061178597556136083e-04 3.20181046761085851101898136494839e-05
 	 8.82019825362079235020473788608797e-01 4.97571451369999140368349799246062e-04 6.81557108900338108571290152148947e-05
 	 8.23607429774869448380059111514129e-01 7.43920810824028055918688551173545e-04 1.20313327300328222761900687221015e-04
 	 7.56377193406150505339269329851959e-01 1.02745867121961653722905793983955e-03 1.87068228657779131321806098675609e-04
 	 6.82163039113651503697610678500496e-01 1.34045061733972792339386614912655e-03 2.64662038349450874554630308566061e-04
 	 6.02989360559831988339851704949979e-01 1.67435893938816526826940389582887e-03 3.47313201962870553903689474495309e-04
 	 5.21015820870776247275557579996530e-01 2.02007543999682681601370859425515e-03 4.27771853698715094106719281086271e-04
 	 4.38478449224138033812891990237404e-01 2.36816985440602145729371841298416e-03 4.98058901568945375237795758494030e-04
 	 3.57628649976634571672207130177412e-01 2.70914707433311807704967577592470e-03 5.50310511443187532279464058149188e-04
 	 2.80671790060171733038885122368811e-01 3.03370615045783775798327042139135e-03 5.77637032036214270215579436040798e-04
 	 2.09707039588842958366399216174614e-01 3.33299400959596869853385214810260e-03 5.74903112453494847568225001310793e-04
 	 1.46670103677618013371386496146442e-01 3.59884697843182443932619207771495e-03 5.39343606027357599409788324607007e-04
 	 9.32803959285448680560648426762782e-02 3.82401357489137172507298600976355e-03 4.70947082363607893301660212159732e-04
 	 5.09940415878905595192804867110681e-02 4.00235271336957243448750887182541e-03 3.72564086444639511446624835500074e-04
 	 2.09636483937665207832878877525218e-02 4.12900336779242760343322515836917e-03 2.49733588839615606048277784978495e-04
 	 4.00147938386741230942789115943015e-03 4.20053988719948367958068047300912e-03 1.10396649695961748100479782319638e-04
 	 ];
 
 	 case  36 

 	 % ALG. DEG.:   36
 	 % PTS CARD.:  361
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 9.90851805270955621196549145679455e-01 9.11346289348091351256719860884914e-03 1.36356678152037474055914383075372e-06
 	 9.69552637080220991450119072396774e-01 3.03317671291784864140428368273206e-02 8.05602002428338613310588450788785e-06
 	 9.36695848074365122748474732361501e-01 6.30638127701744766184788204554934e-02 2.36469651392990811821902957801100e-05
 	 8.93093134981844949393803290149663e-01 1.06500984758017155917819707156013e-01 5.05985215259179026874372664401847e-05
 	 8.39818615708710969336436846788274e-01 1.59573243159151750836244332276692e-01 8.99240870698935737710677518208513e-05
 	 7.78184222976761708068238476698752e-01 2.20973636106791188060682884497510e-01 1.40999167988491440513254548960731e-04
 	 7.09707651653902482635771775676403e-01 2.89190230780095314244704240991268e-01 2.01543092649906048973926231404619e-04
 	 6.36075044879270912190349918091670e-01 3.62543285614004950900834955973551e-01 2.67775310049289238384373490475809e-04
 	 5.59099492649031803992443201423157e-01 4.39226594150088744950011232504039e-01 3.34732617491630872821883890821937e-04
 	 4.80676393578551852669988875277340e-01 5.17351953801812758371170275495388e-01 3.96717565636357674761086622439166e-04
 	 4.02736786165077020882563374470919e-01 5.94995657410357425831648470193613e-01 4.47835069959474463101301022760481e-04
 	 3.27199800763811721182605651847553e-01 6.70245860748754362923307326127542e-01 4.82565222232229375752543543143247e-04
 	 2.55925403482102797880770594929345e-01 7.41249659216206113754310536023695e-01 4.96316339479311208378320419143392e-04
 	 1.90668594904763288866433867951855e-01 8.06258715224647093400278663466452e-01 4.85903811934443655411869356086640e-04
 	 1.33036188558098733558665571763413e-01 8.63672315640781507184442489233334e-01 4.49907190416726969570820893196128e-04
 	 8.44472227842097966643564177502412e-02 9.12076809612370587032614821509924e-01 3.88869591525703873352570738575196e-04
 	 4.60979330484310168003503349609673e-02 9.50280503275423682474354336591205e-01 3.05319212524259226727851856963980e-04
 	 1.89318370315880724064072637702338e-02 9.77343461087658571528891116031446e-01 2.03615570588893497402938059792632e-04
 	 3.61164281855697044676389850792475e-03 9.92605490987186533935471288714325e-01 8.97581344137972754687951337793095e-05
 	 9.90851805270955621196549145679455e-01 8.96618294259483687713707666944174e-03 3.13985489082118472957969382286514e-06
 	 9.69552637080221102472421534912428e-01 2.98415845031792213715160499987178e-02 1.85504180775040605386964204237543e-05
 	 9.36695848074365122748474732361501e-01 6.20446573343056417826346660149284e-02 5.44513405224787220009104171669634e-05
 	 8.93093134981844949393803290149663e-01 1.04779854163882649165095983789797e-01 1.16512089788761398967062432596720e-04
 	 8.39818615708710969336436846788274e-01 1.56994427654013363193641339421447e-01 2.07066194641539430380816622090379e-04
 	 7.78184222976761819090540939214407e-01 2.17402547196536649609655000858766e-01 3.24675647141208585568644684471451e-04
 	 7.09707651653902482635771775676403e-01 2.84516713865192061305720017116982e-01 4.64088795462181725754585714938116e-04
 	 6.36075044879270912190349918091670e-01 3.56684331896477579970650140239741e-01 6.16600248916269783223953471207324e-04
 	 5.59099492649032026037048126454465e-01 4.32128384394875053597928626913927e-01 7.70781351080287785090816576882844e-04
 	 4.80676393578551852669988875277340e-01 5.08991183451691253658566438389244e-01 9.13512712116021428736256648761582e-04
 	 4.02736786165077020882563374470919e-01 5.85380110364732031413836921274196e-01 1.03121985204542932282323342008112e-03
 	 3.27199800763811721182605651847553e-01 6.59414217650357015187978504400235e-01 1.11119220099850819771791776702230e-03
 	 2.55925403482102797880770594929345e-01 7.29270544945408216719329175248276e-01 1.14285659274495688710049368097543e-03
 	 1.90668594904763288866433867951855e-01 7.93229009023209696849221472803038e-01 1.11887989722799147986054268955058e-03
 	 1.33036188558098733558665571763413e-01 8.49714765397149185410796690121060e-01 1.03599127772127392460577155475221e-03
 	 8.44472227842097966643564177502412e-02 8.97337008804037883358262206456857e-01 8.95441356735172944159018015852780e-04
 	 4.60979330484310168003503349609673e-02 9.34923303988364873262639775930438e-01 7.03051757858948341527172143372582e-04
 	 1.89318370315880724064072637702338e-02 9.61548905425311462025206310499925e-01 4.68861044303263906855155918051992e-04
 	 3.61164281855697044676389850792475e-03 9.76564290219647634927468971000053e-01 2.06684059152504023132435051479661e-04
 	 9.90851805270955621196549145679455e-01 8.70522040299938522356359982268259e-03 4.83752283248630499291756748569959e-06
 	 9.69552637080220991450119072396774e-01 2.89730392451401086439943810546538e-02 2.85803242896434859490924218494712e-05
 	 9.36695848074365122748474732361501e-01 6.02388352303006857635381265936303e-02 8.38922855342803856998692979551890e-05
 	 8.93093134981844949393803290149663e-01 1.01730215648127078620355234761519e-01 1.79508262073352809103099492205047e-04
 	 8.39818615708710969336436846788274e-01 1.52425073581580305948079967492959e-01 3.19023483328085655057193559258621e-04
 	 7.78184222976761708068238476698752e-01 2.11075002778341985765209187775326e-01 5.00222434096974548703440355268413e-04
 	 7.09707651653902482635771775676403e-01 2.76235798264542364854889910930069e-01 7.15013980713679556805439929689783e-04
 	 6.36075044879271023212652380607324e-01 3.46302963405386576845046420203289e-01 9.49985870802163103777948638395401e-04
 	 5.59099492649031915014745663938811e-01 4.19551201735881673648975720425369e-01 1.18753016122039750136762936705281e-03
 	 4.80676393578551852669988875277340e-01 4.94176893723758614562768798350589e-01 1.40743402363794570947286288742362e-03
 	 4.02736786165077020882563374470919e-01 5.68342505710946577224262910021935e-01 1.58878347982451808770298917750097e-03
 	 3.27199800763811721182605651847553e-01 6.40221835564788732675367555202683e-01 1.71199556365648824715619547021106e-03
 	 2.55925403482102797880770594929345e-01 7.08044980546424840284203128248919e-01 1.76078037167357948425405744785621e-03
 	 1.90668594904763288866433867951855e-01 7.70141920793937728717537538614124e-01 1.72383987090395400174069884258188e-03
 	 1.33036188558098733558665571763413e-01 8.24983647983029144690192424604902e-01 1.59613473695359290617512559862234e-03
 	 8.44472227842097966643564177502412e-02 8.71219836514586676301519219123293e-01 1.37959178337251583447431446671771e-03
 	 4.60979330484310168003503349609673e-02 9.07712175094627982119277476158459e-01 1.08318028995690461731282727697590e-03
 	 1.89318370315880724064072637702338e-02 9.33562833100938793684520078386413e-01 7.22366506079908667591060744683773e-04
 	 3.61164281855697044676389850792475e-03 9.48141192131466636894288058101665e-01 3.18434733459830232246701164910974e-04
 	 9.90851805270955621196549145679455e-01 8.33727430674251202002977834126796e-03 6.41013831064130060438232411312853e-06
 	 9.69552637080220991450119072396774e-01 2.77484273233933147195795498873849e-02 3.78714143588725822586228686450482e-05
 	 9.36695848074365122748474732361501e-01 5.76927027672543418779227408776933e-02 1.11164571639687877646802960374117e-04
 	 8.93093134981845060416105752665317e-01 9.74303548765145244203722540987656e-02 2.37864053078098839667797737007504e-04
 	 8.39818615708710969336436846788274e-01 1.45982478426070483301657532138051e-01 4.22733850214109029095471692372143e-04
 	 7.78184222976761708068238476698752e-01 2.02153433915715552426917156481068e-01 6.62838212796453538945551375860532e-04
 	 7.09707651653902482635771775676403e-01 2.64560059005508885210389280473464e-01 9.47455685301899254435742392388420e-04
 	 6.36075044879270912190349918091670e-01 3.31665674789087372431595213129185e-01 1.25881386731710519059912467554341e-03
 	 5.59099492649031915014745663938811e-01 4.01817908411635893450863932230277e-01 1.57358070340486819356506931200101e-03
 	 4.80676393578551797158837644019513e-01 4.73289374455050093626340412811260e-01 1.86497243879358361347275963026959e-03
 	 4.02736786165077020882563374470919e-01 5.44320206833695863224420463666320e-01 2.10527623413878225630546658919684e-03
 	 3.27199800763811721182605651847553e-01 6.13161392034455077215682194946567e-01 2.26854295685093671972043516404938e-03
 	 2.55925403482102797880770594929345e-01 6.78117836315066058183731456665555e-01 2.33318706865700198002655518791926e-03
 	 1.90668594904763288866433867951855e-01 7.37590107031443786844704391114647e-01 2.28423769365716398602184078470145e-03
 	 1.33036188558098844580968034279067e-01 7.90113822901228557427089072007220e-01 2.11501728892781728705307919824463e-03
 	 8.44472227842097966643564177502412e-02 8.34395732932253109126463641587179e-01 1.82807904993328063265878302701140e-03
 	 4.60979330484310168003503349609673e-02 8.69345639166849815104853860248113e-01 1.43530805216183186823197814874220e-03
 	 1.89318370315880724064072637702338e-02 8.94103659852247267814107090089237e-01 9.57198420615420022573849312408356e-04
 	 3.61164281855697044676389850792475e-03 9.08065831118790911524740749882767e-01 4.21953705454781969556160570178349e-04
 	 9.90851805270955621196549145679455e-01 7.87186685618089868055058389018086e-03 7.81678281555049632803051223861601e-06
 	 9.69552637080220991450119072396774e-01 2.61994408869951969642819733508077e-02 4.61819397047317364846108489473409e-05
 	 9.36695848074365122748474732361501e-01 5.44721521744542247489562214468606e-02 1.35558590342524219350336944778235e-04
 	 8.93093134981844949393803290149663e-01 9.19915494105937869839806353411404e-02 2.90061080187840403601939875954940e-04
 	 8.39818615708710969336436846788274e-01 1.37833372302022527655651629174827e-01 5.15498813874197829749956856204562e-04
 	 7.78184222976761708068238476698752e-01 1.90868724928162952769739035829843e-01 8.08291818395906426150676615804969e-04
 	 7.09707651653902482635771775676403e-01 2.49791656521425126102897706914518e-01 1.15536591575082065418145216284529e-03
 	 6.36075044879271023212652380607324e-01 3.13151269425507972066213824291481e-01 1.53504871957069882748569966679497e-03
 	 5.59099492649031915014745663938811e-01 3.79387430360479394053641044592950e-01 1.91888817450905379592696053947520e-03
 	 4.80676393578551852669988875277340e-01 4.46869180871532378773736127186567e-01 2.27422308296160993398848937374623e-03
 	 4.02736786165077020882563374470919e-01 5.13934894988220536404810445674229e-01 2.56725928388844846020355738858143e-03
 	 3.27199800763811721182605651847553e-01 5.78933193494941877865755941456882e-01 2.76635335184779356312856357646979e-03
 	 2.55925403482102797880770594929345e-01 6.40263607010829405297158700705040e-01 2.84518300540664501041554501625797e-03
 	 1.90668594904763288866433867951855e-01 6.96415987212049780730183101695729e-01 2.78549215089021707722483078839559e-03
 	 1.33036188558098733558665571763413e-01 7.46007698232574734120703396911267e-01 2.57913792144512377113585444021737e-03
 	 8.44472227842097966643564177502412e-02 7.87817681576855721736762916407315e-01 2.22923378724362289057814301429516e-03
 	 4.60979330484310168003503349609673e-02 8.20816596856907887413967728207354e-01 1.75027289169949460713449074233949e-03
 	 1.89318370315880724064072637702338e-02 8.44192563064521839244491729914444e-01 1.16724660260725861954389515062758e-03
 	 3.61164281855697044676389850792475e-03 8.57375331099938575718510946899187e-01 5.14547473692001495169934255358157e-04
 	 9.90851805270955621196549145679455e-01 7.32105005985136080004505032547968e-03 9.02099150578577605493878904807659e-06
 	 9.69552637080220991450119072396774e-01 2.43661918802911894865736996962369e-02 5.32964642395218442445271878060709e-05
 	 9.36695848074365122748474732361501e-01 5.06605815650823104734357116285537e-02 1.56441968629786461956326926170391e-04
 	 8.93093134981845060416105752665317e-01 8.55546404204540617000063207342464e-02 3.34746225176946882173822928052687e-04
 	 8.39818615708711080358739309303928e-01 1.28188781260815509721595617520506e-01 5.94913602044895030961091375587557e-04
 	 7.78184222976761708068238476698752e-01 1.77513100207213198045153035309340e-01 9.32812616136642885206198272385336e-04
 	 7.09707651653902482635771775676403e-01 2.32313027562279783566623336810153e-01 1.33335495663615302523730132833180e-03
 	 6.36075044879271023212652380607324e-01 2.91239189083847938022131529578473e-01 1.77152951373632169818073123224167e-03
 	 5.59099492649031915014745663938811e-01 3.52840618431772501395471408613957e-01 2.21450107176604168990330379074294e-03
 	 4.80676393578551908181140106535167e-01 4.15600479928909860571906165205291e-01 2.62457683650173202380417869505891e-03
 	 4.02736786165077076393714605728746e-01 4.77973416275315809986778958773357e-01 2.96275651244077512652674855075929e-03
 	 3.27199800763811721182605651847553e-01 5.38423599931462382173208425228950e-01 3.19252186965917174668594391562237e-03
 	 2.55925403482102797880770594929345e-01 5.95462550887377650710163834446575e-01 3.28349556714296886283932508376893e-03
 	 1.90668594904763288866433867951855e-01 6.47685790170211106442366144619882e-01 3.21460908222048020663197398505417e-03
 	 1.33036188558098622536363109247759e-01 6.93807428857465158245076963794418e-01 2.97646510471302012598715514002379e-03
 	 8.44472227842096856420539552345872e-02 7.32691849371347680985877559578512e-01 2.57265674813547196367324865207138e-03
 	 4.60979330484310168003503349609673e-02 7.63381737183203235019846033537760e-01 2.01990988638160035018032090192719e-03
 	 1.89318370315880724064072637702338e-02 7.85122020896076411311526044300990e-01 1.34706591391151909997692115439349e-03
 	 3.61164281855708146906636102357879e-03 7.97382353353162320885871849895921e-01 5.93815703855164831598267838330685e-04
 	 9.90851805270955621196549145679455e-01 6.69908916828409160826307555680614e-03 9.99156704465076997857125862267935e-06
 	 9.69552637080221102472421534912428e-01 2.22961584421818015400162948935758e-02 5.90306725541728309581898659352817e-05
 	 9.36695848074365122748474732361501e-01 4.63567043589517696622337439293915e-02 1.73273682516954051881577503202436e-04
 	 8.93093134981844949393803290149663e-01 7.82863332789095200947571129290736e-02 3.70761833624838588706340569700615e-04
 	 8.39818615708710969336436846788274e-01 1.17298484373060452057302427419927e-01 6.58920822261487211003727626490445e-04
 	 7.78184222976761819090540939214407e-01 1.62432448501904441728882488860108e-01 1.03317465582886667575801542540148e-03
 	 7.09707651653902482635771775676403e-01 2.12576839916506388217243284088909e-01 1.47681166033723017434742263986891e-03
 	 6.36075044879270912190349918091670e-01 2.66496920663189751365962365525775e-01 1.96212976109351065409636127867543e-03
 	 5.59099492649031803992443201423157e-01 3.22864991462022354884453534396016e-01 2.45276097586504329695067383454443e-03
 	 4.80676393578551852669988875277340e-01 3.80293079635349084988149570563110e-01 2.90695711318711197054809325379665e-03
 	 4.02736786165077020882563374470919e-01 4.37367113941401153276444802031619e-01 3.28152180522967408873857841911104e-03
 	 3.27199800763811721182605651847553e-01 4.92681743296619290006788105529267e-01 3.53600779712018266007222955238376e-03
 	 2.55925403482102797880770594929345e-01 5.44874941730617901036737293907208e-01 3.63676942594182064233399032104899e-03
 	 1.90668594904763288866433867951855e-01 5.92661547989589587714931440132204e-01 3.56047139017358696411186258501402e-03
 	 1.33036188558098733558665571763413e-01 6.34864916034797110988563417777186e-01 3.29670531567728599536826195048889e-03
 	 8.44472227842097966643564177502412e-02 6.70445904847874918353056727937656e-01 2.84945090186400394952070946885669e-03
 	 4.60979330484310168003503349609673e-02 6.98528528697660466839636228542076e-01 2.23723357249483575590054407200569e-03
 	 1.89318370315880724064072637702338e-02 7.18421863389499648633318429347128e-01 1.49199779024050075554308492087330e-03
 	 3.61164281855685942446143599227071e-03 7.29640617487800957619015207455959e-01 6.57704800345952330167809130045953e-04
 	 9.90851805270955621196549145679455e-01 6.02209237986816876136986209644419e-03 1.07033689734217375808152106220206e-05
 	 9.69552637080221102472421534912428e-01 2.00429524793723917719390215097519e-02 6.32360335744147080512186920309148e-05
 	 9.36695848074365122748474732361501e-01 4.16719869019671895760126290042535e-02 1.85617746352951374201947776221289e-04
 	 8.93093134981844949393803290149663e-01 7.03748702612802534694935729930876e-02 3.97175006564523872237132406937121e-04
 	 8.39818615708710858314134384272620e-01 1.05444530020194660036025879890076e-01 7.05862519204228573178883099359382e-04
 	 7.78184222976761708068238476698752e-01 1.46017344417166461401080823634402e-01 1.10677829672821805354065993753920e-03
 	 7.09707651653902482635771775676403e-01 1.91094242163304228743214707719744e-01 1.58202012098828293136520972694825e-03
 	 6.36075044879270912190349918091670e-01 2.39565265496413548618193090078421e-01 2.10191241402511545810494197894513e-03
 	 5.59099492649031915014745663938811e-01 2.90236889817017562620549142593518e-01 2.62749632875141541157870683775855e-03
 	 4.80676393578551852669988875277340e-01 3.41861408239060193814395915978821e-01 3.11404952129229039420321711872930e-03
 	 4.02736786165077020882563374470919e-01 3.93167652781980292431285306520294e-01 3.51529830293300380242293989851987e-03
 	 3.27199800763811665671454420589725e-01 4.42892294381371620648479847659473e-01 3.78791394546423333677953593223720e-03
 	 2.55925403482102853391921826187172e-01 4.89810950735193262328692753726500e-01 3.89585385987619272143978044198320e-03
 	 1.90668594904763288866433867951855e-01 5.32768336460755165262526134029031e-01 3.81412033147916860326143151382894e-03
 	 1.33036188558098733558665571763413e-01 5.70706715056022551024739186686929e-01 3.53156349075652974817129958751138e-03
 	 8.44472227842096856420539552345872e-02 6.02691959052154446752069816284347e-01 3.05244655197785047170966343799137e-03
 	 4.60979330484310168003503349609673e-02 6.27936608114769478916628031583969e-01 2.39661469508516567633593652431045e-03
 	 1.89318370315880724064072637702338e-02 6.45819561490739602049870882183313e-01 1.59828811487819420593392560903112e-03
 	 3.61164281855708146906636102357879e-03 6.55904570343413206856553188117687e-01 7.04559867559739544037866743053655e-04
 	 9.90851805270955621196549145679455e-01 5.30759342292349417524732757556194e-03 1.11379607870579201928194074122658e-05
 	 9.69552637080220991450119072396774e-01 1.76649304004555668390352707319835e-02 6.58036235160962100368756133583759e-05
 	 9.36695848074365122748474732361501e-01 3.67277599959163897347380611790868e-02 1.93154434402377907318421046412027e-04
 	 8.93093134981845060416105752665317e-01 6.20251525510543758046289042340504e-02 4.13301611828946371778037427446861e-04
 	 8.39818615708710969336436846788274e-01 9.29339270665083400091432963563420e-02 7.34522847850331756826280926730988e-04
 	 7.78184222976761819090540939214407e-01 1.28692927304159515644599309780460e-01 1.15171711818365688981269379098649e-03
 	 7.09707651653902482635771775676403e-01 1.68421618083299168278088586703234e-01 1.64625531602794676448719979333646e-03
 	 6.36075044879270912190349918091670e-01 2.11141734019284543766303841039189e-01 2.18725693782728398267822811362748e-03
 	 5.59099492649031915014745663938811e-01 2.55801357785928829002841666806489e-01 2.73418127978599084099142757509071e-03
 	 4.80676393578551852669988875277340e-01 3.01300818298094630343086919310736e-01 3.24049012448665617672216576750088e-03
 	 4.02736786165077076393714605728746e-01 3.46519766948109875226435860895435e-01 3.65803091999380384363727003460554e-03
 	 3.27199800763811721182605651847553e-01 3.90344763986088749696534705435624e-01 3.94171564991307316061508458915341e-03
 	 2.55925403482102742369619363671518e-01 4.31696695535402297227989265593351e-01 4.05403827814948460733779356246487e-03
 	 1.90668594904763288866433867951855e-01 4.69557346545204867815925808827160e-01 3.96898610097662710161081633941649e-03
 	 1.33036188558098622536363109247759e-01 5.02994477031906361830237983667757e-01 3.67495652768073076399613086095997e-03
 	 8.44472227842096856420539552345872e-02 5.31184790291130859429813426686451e-01 3.17638587298469093206376712146266e-03
 	 4.60979330484310168003503349609673e-02 5.53434255240667249964303664455656e-01 2.49392509609166470804786364112715e-03
 	 1.89318370315880724064072637702338e-02 5.69195462431385301727004843996838e-01 1.66318384371673898790289225502192e-03
 	 3.61164281855685942446143599227071e-03 5.78083922335374422729614707350265e-01 7.33167304285353054263407734936209e-04
 	 9.90851805270955621196549145679455e-01 4.57409736452219026908716514867592e-03 1.12840862945170176148646998259828e-05
 	 9.69552637080220991450119072396774e-01 1.52236814598894799888118001263138e-02 6.66669402455023621997115546022883e-05
 	 9.36695848074365122748474732361501e-01 3.16520759628174455646565377264778e-02 1.95688541882610628815791775636512e-04
 	 8.93093134981844949393803290149663e-01 5.34534325090775114253105471107119e-02 4.18723960579926333600009336066705e-04
 	 8.39818615708710969336436846788274e-01 8.00906921456445292095693844203197e-02 7.44159488339060041367511999510498e-04
 	 7.78184222976761819090540939214407e-01 1.10907888511619145965880761650624e-01 1.16682717751691203238173510925435e-03
 	 7.09707651653902482635771775676403e-01 1.45146174173048786437689727790712e-01 1.66785351502154923636345174031703e-03
 	 6.36075044879270912190349918091670e-01 1.81962477560364543904825040954165e-01 2.21595285767239814564422140108491e-03
 	 5.59099492649031915014745663938811e-01 2.20450253675484098003778399288421e-01 2.77005262415794609176522556026612e-03
 	 4.80676393578551797158837644019513e-01 2.59661803210724129176156793619157e-01 3.28300403460986484419081854468914e-03
 	 4.02736786165076965371412143213092e-01 2.98631606917461545069869544022367e-01 3.70602279523063113386704969798302e-03
 	 3.27199800763811776693756883105380e-01 3.36400099618094194919848405334051e-01 3.99342935322151860316752802759765e-03
 	 2.55925403482102742369619363671518e-01 3.72037298258948656570765933793155e-01 4.10722560857549462420834629483579e-03
 	 1.90668594904763288866433867951855e-01 4.04665702547618466589085528539727e-01 4.02105758149191253730814210598510e-03
 	 1.33036188558098789069816803021240e-01 4.33481905720950744242969676633948e-01 3.72317045999421593338585267929375e-03
 	 8.44472227842098521755076490080683e-02 4.57776388607895212690124253640533e-01 3.21805876144692394602575546969092e-03
 	 4.60979330484310168003503349609673e-02 4.76951033475784602622127295035170e-01 2.52664437722388297152820157975839e-03
 	 1.89318370315880724064072637702338e-02 4.90534081484206074819098830630537e-01 1.68500413809623424653272305562268e-03
 	 3.61164281855702595791512976575177e-03 4.98194178590721625798920513261692e-01 7.42786160594813434608629787447853e-04
 	 9.90851805270955621196549145679455e-01 3.84060130612088549556526473338636e-03 1.11379607870579693207303481616854e-05
 	 9.69552637080220991450119072396774e-01 1.27824325193233861996944256134157e-02 6.58036235160964946399458908032898e-05
 	 9.36695848074365122748474732361501e-01 2.65763919297184875167872064594121e-02 1.93154434402378747575104722677963e-04
 	 8.93093134981845060416105752665317e-01 4.48817124671006192904165743584599e-02 4.13301611828948160711622028529177e-04
 	 8.39818615708710969336436846788274e-01 6.72474572247806906544198568553838e-02 7.34522847850335009432798383244290e-04
 	 7.78184222976761819090540939214407e-01 9.31228497190787207760109822629602e-02 1.15171711818366187714268722430688e-03
 	 7.09707651653902482635771775676403e-01 1.21870730262798349086139637620363e-01 1.64625531602795392022153819766572e-03
 	 6.36075044879271023212652380607324e-01 1.52783221101444488532195009611314e-01 2.18725693782729352365734598606650e-03
 	 5.59099492649032026037048126454465e-01 1.85099149565039200471261437996873e-01 2.73418127978600298405575941274037e-03
 	 4.80676393578551908181140106535167e-01 2.18022788123353572498075436669751e-01 3.24049012448667048819084257615941e-03
 	 4.02736786165076965371412143213092e-01 2.50743446886813103891000764633645e-01 3.65803091999381988982942282007116e-03
 	 3.27199800763811721182605651847553e-01 2.82455435250099529120859642716823e-01 3.94171564991309050784984435722436e-03
 	 2.55925403482102853391921826187172e-01 3.12377900982494904891240139477304e-01 4.05403827814950195457255333053581e-03
 	 1.90668594904763288866433867951855e-01 3.39774058550031843317640323220985e-01 3.96898610097664444884557610748743e-03
 	 1.33036188558098733558665571763413e-01 3.63969334409995015633398907084484e-01 3.67495652768074681018828364642559e-03
 	 8.44472227842097966643564177502412e-02 3.84367986924659343905830155563308e-01 3.17638587298470480985157493591942e-03
 	 4.60979330484310168003503349609673e-02 4.00467811710901733235346000583377e-01 2.49392509609167598375045749037326e-03
 	 1.89318370315880724064072637702338e-02 4.11872700537026514844285429717274e-01 1.66318384371674614363723065935119e-03
 	 3.61164281855697044676389850792475e-03 4.18304434846068717845923856657464e-01 7.33167304285356198449707942899067e-04
 	 9.90851805270955621196549145679455e-01 3.12610234917621004208099222410056e-03 1.07033689734217545214741557080274e-05
 	 9.69552637080221102472421534912428e-01 1.04044104404065612667906748356472e-02 6.32360335744148164714359405813582e-05
 	 9.36695848074365122748474732361501e-01 2.16321650236676876755126386342454e-02 1.85617746352951699462599521872619e-04
 	 8.93093134981844949393803290149663e-01 3.65319947568747277477640977849660e-02 3.97175006564524522758435898239782e-04
 	 8.39818615708710969336436846788274e-01 5.47368542710943845053250811361067e-02 7.05862519204229765801272833414259e-04
 	 7.78184222976761819090540939214407e-01 7.57984326060717750195294684090186e-02 1.10677829672821978826413591434630e-03
 	 7.09707651653902482635771775676403e-01 9.91981061827932886210135166038526e-02 1.58202012098828553345042369215889e-03
 	 6.36075044879270912190349918091670e-01 1.24359689624315483680305760572082e-01 2.10191241402511892755189393255932e-03
 	 5.59099492649031915014745663938811e-01 1.50663617533950522364705193467671e-01 2.62749632875141974838739677977628e-03
 	 4.80676393578551852669988875277340e-01 1.77462198182387953515615208743839e-01 3.11404952129229559837364504915058e-03
 	 4.02736786165076965371412143213092e-01 2.04095561052942742197302550266613e-01 3.51529830293300987395510581734470e-03
 	 3.27199800763811776693756883105380e-01 2.29907904854816658168914500492974e-01 3.78791394546423940831170185106203e-03
 	 2.55925403482102742369619363671518e-01 2.54263645782703939790536651344155e-01 3.89585385987619879297194636080803e-03
 	 1.90668594904763288866433867951855e-01 2.76563068634481545871039998019114e-01 3.81412033147917510847446642685554e-03
 	 1.33036188558098733558665571763413e-01 2.96257096385878715416595241549658e-01 3.53156349075653538602259651213444e-03
 	 8.44472227842097966643564177502412e-02 3.12860818163635867605876228481065e-01 3.05244655197785567588009136841265e-03
 	 4.60979330484310168003503349609673e-02 3.25965458836799615305324095970718e-01 2.39661469508516957946375747212642e-03
 	 1.89318370315880724064072637702338e-02 3.35248601477672325543721854046453e-01 1.59828811487819680801913957424176e-03
 	 3.61164281855697044676389850792475e-03 3.40483786838029711674380450858735e-01 7.04559867559740736660256477108533e-04
 	 9.90851805270955621196549145679455e-01 2.44910556076028719518777876373861e-03 9.99156704465079538955967625168952e-06
 	 9.69552637080220991450119072396774e-01 8.15120447759715496816035340543749e-03 5.90306725541729800359885826921413e-05
 	 9.36695848074365122748474732361501e-01 1.69474475666831145281854276163358e-02 1.73273682516954512667500809541821e-04
 	 8.93093134981844949393803290149663e-01 2.86205317392454750002883656634367e-02 3.70761833624839564488295806654605e-04
 	 8.39818615708710969336436846788274e-01 4.28828999182286063618363414207124e-02 6.58920822261488945727203603297539e-04
 	 7.78184222976761708068238476698752e-01 5.93833285213338224473034188122256e-02 1.03317465582886927784322939061212e-03
 	 7.09707651653902482635771775676403e-01 7.77155084295911569025605558636016e-02 1.47681166033723386063480909058399e-03
 	 6.36075044879270912190349918091670e-01 9.74280344575393364436877163825557e-02 1.96212976109351542458592021489494e-03
 	 5.59099492649031915014745663938811e-01 1.18035515888945785611952032923000e-01 2.45276097586504980216370874757104e-03
 	 4.80676393578551852669988875277340e-01 1.39030526786099173364164016675204e-01 2.90695711318711934312286615522680e-03
 	 4.02736786165077020882563374470919e-01 1.59896099893521936863294286013115e-01 3.28152180522968232867508930894473e-03
 	 3.27199800763811721182605651847553e-01 1.80118455939569099832908705138834e-01 3.53600779712019133368960943641923e-03
 	 2.55925403482102797880770594929345e-01 1.99199654787279412104794573679101e-01 3.63676942594182974963223919928623e-03
 	 1.90668594904763288866433867951855e-01 2.16669857105647234440937154431595e-01 3.56047139017359607141011146325127e-03
 	 1.33036188558098733558665571763413e-01 2.32098895407104266475073472975055e-01 3.29670531567729423530477284032258e-03
 	 8.44472227842097966643564177502412e-02 2.45106872367915396004889316827757e-01 2.84945090186401088841461337608507e-03
 	 4.60979330484310168003503349609673e-02 2.55373538253908627382315899012610e-01 2.23723357249484139375184099662874e-03
 	 1.89318370315880724064072637702338e-02 2.62646299578912501004879231913947e-01 1.49199779024050444183047137158837e-03
 	 3.61164281855697044676389850792475e-03 2.66747739693642182956523356551770e-01 6.57704800345954064891285106853047e-04
 	 9.90851805270955621196549145679455e-01 1.82714466919302060549101796027571e-03 9.02099150578579977186131216848608e-06
 	 9.69552637080220991450119072396774e-01 6.08117103948777049104990055639064e-03 5.32964642395219797697987484941251e-05
 	 9.36695848074365233770777194877155e-01 1.26435703605525806558773638244020e-02 1.56441968629786868532141608234554e-04
 	 8.93093134981845060416105752665317e-01 2.13522245977009611506147734871774e-02 3.34746225176947749535560916456234e-04
 	 8.39818615708710969336436846788274e-01 3.19926030304735486975431513201329e-02 5.94913602044896548844132855293765e-04
 	 7.78184222976761819090540939214407e-01 4.43026768160250938866084879919072e-02 9.32812616136645270450977740495091e-04
 	 7.09707651653902482635771775676403e-01 5.79793207838178170643317344001844e-02 1.33335495663615649468425328194598e-03
 	 6.36075044879270912190349918091670e-01 7.26857660368812052986697835876839e-02 1.77152951373632625182985567136029e-03
 	 5.59099492649031915014745663938811e-01 8.80598889191956946120853899628855e-02 2.21450107176604732775460071536600e-03
 	 4.80676393578551908181140106535167e-01 1.03723126492538397780407422033022e-01 2.62457683650173896269808260228729e-03
 	 4.02736786165077020882563374470919e-01 1.19289797559607335664111360529205e-01 2.96275651244078249910152145218944e-03
 	 3.27199800763811721182605651847553e-01 1.34376599304726118688790847954806e-01 3.19252186965917998662245480545607e-03
 	 2.55925403482102797880770594929345e-01 1.48612045630519773453670495655388e-01 3.28349556714297753645670496780440e-03
 	 1.90668594904763288866433867951855e-01 1.61645614925025826735804912459571e-01 3.21460908222048844656848487488787e-03
 	 1.33036188558098733558665571763413e-01 1.73156382584436441263164851989131e-01 2.97646510471302749856192804145394e-03
 	 8.44472227842097966643564177502412e-02 1.82860927844442855416673410218209e-01 2.57265674813547890256715255929976e-03
 	 4.60979330484310168003503349609673e-02 1.90520329768366081246711019048234e-01 2.01990988638160555435074883234847e-03
 	 1.89318370315880724064072637702338e-02 1.95946142072335849348974079475738e-01 1.34706591391152256942387310800768e-03
 	 3.61164281855697044676389850792475e-03 1.99006003828280930711969176627463e-01 5.93815703855166457901526566587336e-04
 	 9.90851805270955621196549145679455e-01 1.27632787286347665345331847674970e-03 7.81678281555046244671262206660245e-06
 	 9.69552637080220991450119072396774e-01 4.24792203278374913555381908736308e-03 4.61819397047315399729670859496622e-05
 	 9.36695848074365122748474732361501e-01 8.83199975118063862478123837718158e-03 1.35558590342523623039142077750796e-04
 	 8.93093134981844949393803290149663e-01 1.49153156075611942332770354369131e-02 2.90061080187839210979550141900063e-04
 	 8.39818615708710969336436846788274e-01 2.23480119892664752523359084079857e-02 5.15498813874195661345611885195694e-04
 	 7.78184222976761819090540939214407e-01 3.09470520950752281397200249557500e-02 8.08291818395903065123941910741223e-04
 	 7.09707651653902482635771775676403e-01 4.05006918246723357501792861512513e-02 1.15536591575081588369189322662578e-03
 	 6.36075044879270912190349918091670e-01 5.07736856952209492099825638433686e-02 1.53504871957069232227266475376837e-03
 	 5.59099492649032026037048126454465e-01 6.15130769904886354204620602104114e-02 1.91888817450904577283088414674239e-03
 	 4.80676393578551852669988875277340e-01 7.24544255499156575339725350204390e-02 2.27422308296160039300937150130721e-03
 	 4.02736786165077020882563374470919e-01 8.33283188467023316903237173391972e-02 2.56725928388843761818183253353709e-03
 	 3.27199800763811721182605651847553e-01 9.38670057412462899293359441799112e-02 2.76635335184778185374510073302190e-03
 	 2.55925403482102797880770594929345e-01 1.03810989507067685799768241849961e-01 2.84518300540663286735121317860830e-03
 	 1.90668594904763288866433867951855e-01 1.12915417883186819381080567836761e-01 2.78549215089020536784136794494771e-03
 	 1.33036188558098733558665571763413e-01 1.20956113209326310276026106294012e-01 2.57913792144511249543326059097126e-03
 	 8.44472227842097966643564177502412e-02 1.27735095638934370576578203326790e-01 2.22923378724361334959902514185615e-03
 	 4.60979330484310168003503349609673e-02 1.33085470094660873741077011800371e-01 1.75027289169948723455971784090934e-03
 	 1.89318370315880724064072637702338e-02 1.36875599903889866304496081284015e-01 1.16724660260725384905433621440807e-03
 	 3.61164281855697044676389850792475e-03 1.39013026081504231790120229561580e-01 5.14547473691999218345372035798846e-04
 	 9.90851805270955621196549145679455e-01 8.10920422301865048697600002469699e-04 6.41013831064128789888811529862345e-06
 	 9.69552637080220991450119072396774e-01 2.69893559638563484970319450440002e-03 3.78714143588725077197235102666184e-05
 	 9.36695848074365122748474732361501e-01 5.61144915838052843470862285357725e-03 1.11164571639687660806368463273230e-04
 	 8.93093134981845060416105752665317e-01 9.47651014164044291909760886483127e-03 2.37864053078098378881874430668120e-04
 	 8.39818615708710969336436846788274e-01 1.41989058652185196063300054447609e-02 4.22733850214108161733733703968596e-04
 	 7.78184222976761708068238476698752e-01 1.96623431075226562381175199334393e-02 6.62838212796452237902944393255211e-04
 	 7.09707651653902482635771775676403e-01 2.57322893405886321538389438501326e-02 9.47455685301897411292049167030882e-04
 	 6.36075044879271023212652380607324e-01 3.22592803316416043557524062634911e-02 1.25881386731710280535434520743365e-03
 	 5.59099492649031803992443201423157e-01 3.90825989393321360232391725730849e-02 1.57358070340486494095855185548771e-03
 	 4.80676393578551852669988875277340e-01 4.60342319663979981925194806535728e-02 1.86497243879357992718537317955452e-03
 	 4.02736786165077020882563374470919e-01 5.29430070012270048707136993471067e-02 2.10527623413877791949677664717910e-03
 	 3.27199800763811721182605651847553e-01 5.96388072017330905794096906902269e-02 2.26854295685093238291174522203164e-03
 	 2.55925403482102797880770594929345e-01 6.59567602028310329131954858894460e-02 2.33318706865699720953699625169975e-03
 	 1.90668594904763288866433867951855e-01 7.17412980637928132665592784178443e-02 2.28423769365715964921315084268372e-03
 	 1.33036188558098733558665571763413e-01 7.68499885406724869696404311980586e-02 2.11501728892781295024438925622690e-03
 	 8.44472227842097966643564177502412e-02 8.11570442835369831868774781469256e-02 1.82807904993327694637139657629632e-03
 	 4.60979330484310168003503349609673e-02 8.45564277847190570724933422752656e-02 1.43530805216182904930632968643067e-03
 	 1.89318370315880724064072637702338e-02 8.69645031161645487571831836248748e-02 9.57198420615418071009938838500375e-04
 	 3.61164281855697044676389850792475e-03 8.83225260626520070061928890936542e-02 4.21953705454781102194422581774802e-04
 	 9.90851805270955621196549145679455e-01 4.42974326044993579887254497862159e-04 4.83752283248630075775283121419790e-06
 	 9.69552637080220991450119072396774e-01 1.47432367463884439473531529074535e-03 2.85803242896434554559063206946590e-05
 	 9.36695848074365122748474732361501e-01 3.06531669533419148798714104486862e-03 8.38922855342803043847063615423565e-05
 	 8.93093134981844949393803290149663e-01 5.17664937002791647469024383099168e-03 1.79508262073352619367719307241771e-04
 	 8.39818615708710969336436846788274e-01 7.75631070970872471548318571876734e-03 3.19023483328085329796541813607291e-04
 	 7.78184222976761708068238476698752e-01 1.07407742448962506554011042680941e-02 5.00222434096974115022571361066639e-04
 	 7.09707651653902482635771775676403e-01 1.40565500815551525093383133935276e-02 7.15013980713678797863919189836679e-04
 	 6.36075044879270912190349918091670e-01 1.76219917153424554534524304472143e-02 9.49985870802162127995993401441410e-04
 	 5.59099492649031915014745663938811e-01 2.13493056150864113362786156358197e-02 1.18753016122039641716545688154838e-03
 	 4.80676393578551852669988875277340e-01 2.51467126976895327672423263720702e-02 1.40743402363794419158982140771741e-03
 	 4.02736786165077020882563374470919e-01 2.89207081239764018931737155071460e-02 1.58878347982451656981994769779476e-03
 	 3.27199800763811721182605651847553e-01 3.25783636713995461420267929497641e-02 1.71199556365648651243271949340397e-03
 	 2.55925403482102797880770594929345e-01 3.60296159714723618350262768217362e-02 1.76078037167357753269014697394823e-03
 	 1.90668594904763288866433867951855e-01 3.91894843012989824160285934340209e-02 1.72383987090395226701722286577478e-03
 	 1.33036188558098733558665571763413e-01 4.19801634588721217511420036316849e-02 1.59613473695359117145164962181525e-03
 	 8.44472227842097966643564177502412e-02 4.43329407012035270341243631264661e-02 1.37959178337251431659127298701151e-03
 	 4.60979330484310168003503349609673e-02 4.61898918569410010803721888805740e-02 1.08318028995690353311065479147146e-03
 	 1.89318370315880724064072637702338e-02 4.75053298674731339090726578433532e-02 7.22366506079907908649540004830669e-04
 	 3.61164281855697044676389850792475e-03 4.82471650499763926589480433904100e-02 3.18434733459829906986049419259643e-04
 	 9.90851805270955621196549145679455e-01 1.82011786449540191590301674295915e-04 3.13985489082108943837312771407699e-06
 	 9.69552637080221102472421534912428e-01 6.05778416599728197766694393067155e-04 1.85504180775034947206876545511278e-05
 	 9.36695848074365122748474732361501e-01 1.25949459132922852999669771634217e-03 5.44513405224770685925973767727015e-05
 	 8.93093134981844949393803290149663e-01 2.12701085427233205216168698825641e-03 1.16512089788757861757474698638504e-04
 	 8.39818615708710969336436846788274e-01 3.18695663727563971434619816136546e-03 2.07066194641533142008216206164661e-04
 	 7.78184222976761819090540939214407e-01 4.41322982670155905537967555574141e-03 3.24675647141198719328875066381102e-04
 	 7.09707651653902482635771775676403e-01 5.77563448090540054735697594878729e-03 4.64088795462167631126343403380474e-04
 	 6.36075044879270912190349918091670e-01 7.24062322425139681669747915293556e-03 6.16600248916251026526369471980615e-04
 	 5.59099492649032026037048126454465e-01 8.77212295609292036502324663160834e-03 7.70781351080264366323890889987069e-04
 	 4.80676393578551852669988875277340e-01 1.03324229697567826491422238177620e-02 9.13512712115993673160641019848072e-04
 	 4.02736786165077020882563374470919e-01 1.18831034701908366812972417392302e-02 1.03121985204539809780066583755342e-03
 	 3.27199800763811721182605651847553e-01 1.33859815858311526071133812365588e-02 1.11119220099847437061013621928396e-03
 	 2.55925403482102797880770594929345e-01 1.48040515724888743775977673067246e-02 1.14285659274492219263097414483354e-03
 	 1.90668594904763288866433867951855e-01 1.61023960720269032620421967294533e-02 1.11887989722795765275276114181224e-03
 	 1.33036188558098733558665571763413e-01 1.72490460447519700082352755998727e-02 1.03599127772124248274276947512362e-03
 	 8.44472227842097966643564177502412e-02 1.82157684117522089550789132772479e-02 8.95441356735145839104705878241930e-04
 	 4.60979330484310168003503349609673e-02 1.89787629632038878924049640772864e-02 7.03051757858926982744374178935232e-04
 	 1.89318370315880724064072637702338e-02 1.95192575431003545460839632141870e-02 4.68861044303249649596587733668684e-04
 	 3.61164281855697044676389850792475e-03 1.98240669617951725811622054607142e-02 2.06684059152497734759834635553943e-04
 	 9.90851805270955621196549145679455e-01 3.47318355634652908836557116956101e-05 1.36356678152047659627105116036949e-06
 	 9.69552637080220991450119072396774e-01 1.15595790600466624686859518078563e-04 8.05602002428398752649843506112859e-06
 	 9.36695848074365122748474732361501e-01 2.40339155460386755258639368548756e-04 2.36469651393008463988523737420167e-05
 	 8.93093134981844949393803290149663e-01 4.05880260137839177225771436496871e-04 5.05985215259216770662502316024955e-05
 	 8.39818615708710969336436846788274e-01 6.08141132137252071743205306120217e-04 8.99240870699002958245371619483421e-05
 	 7.78184222976761708068238476698752e-01 8.42140916447020604351791916997172e-04 1.40999167988501957274327658353741e-04
 	 7.09707651653902482635771775676403e-01 1.10211756600220311952398333232850e-03 2.01543092649921092279069467778641e-04
 	 6.36075044879270912190349918091670e-01 1.38166950672408139766389467695262e-03 2.67775310049309241914455848032617e-04
 	 5.59099492649031803992443201423157e-01 1.67391320087934003524310355714988e-03 3.34732617491655917892068305974362e-04
 	 4.80676393578551852669988875277340e-01 1.97165261963538895884084922727197e-03 3.96717565636387327690504100985436e-04
 	 4.02736786165077020882563374470919e-01 2.26755642456555328578815533546731e-03 4.47835069959507910738322200572270e-04
 	 3.27199800763811721182605651847553e-01 2.55433848743380487178455950925127e-03 4.82565222232265425474778686165678e-04
 	 2.55925403482102797880770594929345e-01 2.82493730169108836491886904696003e-03 4.96316339479348288092619423395035e-04
 	 1.90668594904763288866433867951855e-01 3.07268987058961773328746858169325e-03 4.85903811934479976184647620485180e-04
 	 1.33036188558098733558665571763413e-01 3.29149580111964823458947648759931e-03 4.49907190416760579838167943833582e-04
 	 8.44472227842097966643564177502412e-02 3.47596760341961630302876073983498e-03 3.88869591525732929970793350094027e-04
 	 4.60979330484310168003503349609673e-02 3.62156367614530072529532844782807e-03 3.05319212524282049183582676832316e-04
 	 1.89318370315880724064072637702338e-02 3.72470188075335606470162019832060e-03 2.03615570588908703338407168992319e-04
 	 3.61164281855697044676389850792475e-03 3.78286619425638459546235026209615e-03 8.97581344138039839697373878379949e-05
 	 ];
 
 	 case  37 

 	 % ALG. DEG.:   37
 	 % PTS CARD.:  361
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 9.90851805270955621196549145679455e-01 9.11346289348091351256719860884914e-03 1.36356678152037474055914383075372e-06
 	 9.69552637080220991450119072396774e-01 3.03317671291784864140428368273206e-02 8.05602002428338613310588450788785e-06
 	 9.36695848074365122748474732361501e-01 6.30638127701744766184788204554934e-02 2.36469651392990811821902957801100e-05
 	 8.93093134981844949393803290149663e-01 1.06500984758017155917819707156013e-01 5.05985215259179026874372664401847e-05
 	 8.39818615708710969336436846788274e-01 1.59573243159151750836244332276692e-01 8.99240870698935737710677518208513e-05
 	 7.78184222976761708068238476698752e-01 2.20973636106791188060682884497510e-01 1.40999167988491440513254548960731e-04
 	 7.09707651653902482635771775676403e-01 2.89190230780095314244704240991268e-01 2.01543092649906048973926231404619e-04
 	 6.36075044879270912190349918091670e-01 3.62543285614004950900834955973551e-01 2.67775310049289238384373490475809e-04
 	 5.59099492649031803992443201423157e-01 4.39226594150088744950011232504039e-01 3.34732617491630872821883890821937e-04
 	 4.80676393578551852669988875277340e-01 5.17351953801812758371170275495388e-01 3.96717565636357674761086622439166e-04
 	 4.02736786165077020882563374470919e-01 5.94995657410357425831648470193613e-01 4.47835069959474463101301022760481e-04
 	 3.27199800763811721182605651847553e-01 6.70245860748754362923307326127542e-01 4.82565222232229375752543543143247e-04
 	 2.55925403482102797880770594929345e-01 7.41249659216206113754310536023695e-01 4.96316339479311208378320419143392e-04
 	 1.90668594904763288866433867951855e-01 8.06258715224647093400278663466452e-01 4.85903811934443655411869356086640e-04
 	 1.33036188558098733558665571763413e-01 8.63672315640781507184442489233334e-01 4.49907190416726969570820893196128e-04
 	 8.44472227842097966643564177502412e-02 9.12076809612370587032614821509924e-01 3.88869591525703873352570738575196e-04
 	 4.60979330484310168003503349609673e-02 9.50280503275423682474354336591205e-01 3.05319212524259226727851856963980e-04
 	 1.89318370315880724064072637702338e-02 9.77343461087658571528891116031446e-01 2.03615570588893497402938059792632e-04
 	 3.61164281855697044676389850792475e-03 9.92605490987186533935471288714325e-01 8.97581344137972754687951337793095e-05
 	 9.90851805270955621196549145679455e-01 8.96618294259483687713707666944174e-03 3.13985489082118472957969382286514e-06
 	 9.69552637080221102472421534912428e-01 2.98415845031792213715160499987178e-02 1.85504180775040605386964204237543e-05
 	 9.36695848074365122748474732361501e-01 6.20446573343056417826346660149284e-02 5.44513405224787220009104171669634e-05
 	 8.93093134981844949393803290149663e-01 1.04779854163882649165095983789797e-01 1.16512089788761398967062432596720e-04
 	 8.39818615708710969336436846788274e-01 1.56994427654013363193641339421447e-01 2.07066194641539430380816622090379e-04
 	 7.78184222976761819090540939214407e-01 2.17402547196536649609655000858766e-01 3.24675647141208585568644684471451e-04
 	 7.09707651653902482635771775676403e-01 2.84516713865192061305720017116982e-01 4.64088795462181725754585714938116e-04
 	 6.36075044879270912190349918091670e-01 3.56684331896477579970650140239741e-01 6.16600248916269783223953471207324e-04
 	 5.59099492649032026037048126454465e-01 4.32128384394875053597928626913927e-01 7.70781351080287785090816576882844e-04
 	 4.80676393578551852669988875277340e-01 5.08991183451691253658566438389244e-01 9.13512712116021428736256648761582e-04
 	 4.02736786165077020882563374470919e-01 5.85380110364732031413836921274196e-01 1.03121985204542932282323342008112e-03
 	 3.27199800763811721182605651847553e-01 6.59414217650357015187978504400235e-01 1.11119220099850819771791776702230e-03
 	 2.55925403482102797880770594929345e-01 7.29270544945408216719329175248276e-01 1.14285659274495688710049368097543e-03
 	 1.90668594904763288866433867951855e-01 7.93229009023209696849221472803038e-01 1.11887989722799147986054268955058e-03
 	 1.33036188558098733558665571763413e-01 8.49714765397149185410796690121060e-01 1.03599127772127392460577155475221e-03
 	 8.44472227842097966643564177502412e-02 8.97337008804037883358262206456857e-01 8.95441356735172944159018015852780e-04
 	 4.60979330484310168003503349609673e-02 9.34923303988364873262639775930438e-01 7.03051757858948341527172143372582e-04
 	 1.89318370315880724064072637702338e-02 9.61548905425311462025206310499925e-01 4.68861044303263906855155918051992e-04
 	 3.61164281855697044676389850792475e-03 9.76564290219647634927468971000053e-01 2.06684059152504023132435051479661e-04
 	 9.90851805270955621196549145679455e-01 8.70522040299938522356359982268259e-03 4.83752283248630499291756748569959e-06
 	 9.69552637080220991450119072396774e-01 2.89730392451401086439943810546538e-02 2.85803242896434859490924218494712e-05
 	 9.36695848074365122748474732361501e-01 6.02388352303006857635381265936303e-02 8.38922855342803856998692979551890e-05
 	 8.93093134981844949393803290149663e-01 1.01730215648127078620355234761519e-01 1.79508262073352809103099492205047e-04
 	 8.39818615708710969336436846788274e-01 1.52425073581580305948079967492959e-01 3.19023483328085655057193559258621e-04
 	 7.78184222976761708068238476698752e-01 2.11075002778341985765209187775326e-01 5.00222434096974548703440355268413e-04
 	 7.09707651653902482635771775676403e-01 2.76235798264542364854889910930069e-01 7.15013980713679556805439929689783e-04
 	 6.36075044879271023212652380607324e-01 3.46302963405386576845046420203289e-01 9.49985870802163103777948638395401e-04
 	 5.59099492649031915014745663938811e-01 4.19551201735881673648975720425369e-01 1.18753016122039750136762936705281e-03
 	 4.80676393578551852669988875277340e-01 4.94176893723758614562768798350589e-01 1.40743402363794570947286288742362e-03
 	 4.02736786165077020882563374470919e-01 5.68342505710946577224262910021935e-01 1.58878347982451808770298917750097e-03
 	 3.27199800763811721182605651847553e-01 6.40221835564788732675367555202683e-01 1.71199556365648824715619547021106e-03
 	 2.55925403482102797880770594929345e-01 7.08044980546424840284203128248919e-01 1.76078037167357948425405744785621e-03
 	 1.90668594904763288866433867951855e-01 7.70141920793937728717537538614124e-01 1.72383987090395400174069884258188e-03
 	 1.33036188558098733558665571763413e-01 8.24983647983029144690192424604902e-01 1.59613473695359290617512559862234e-03
 	 8.44472227842097966643564177502412e-02 8.71219836514586676301519219123293e-01 1.37959178337251583447431446671771e-03
 	 4.60979330484310168003503349609673e-02 9.07712175094627982119277476158459e-01 1.08318028995690461731282727697590e-03
 	 1.89318370315880724064072637702338e-02 9.33562833100938793684520078386413e-01 7.22366506079908667591060744683773e-04
 	 3.61164281855697044676389850792475e-03 9.48141192131466636894288058101665e-01 3.18434733459830232246701164910974e-04
 	 9.90851805270955621196549145679455e-01 8.33727430674251202002977834126796e-03 6.41013831064130060438232411312853e-06
 	 9.69552637080220991450119072396774e-01 2.77484273233933147195795498873849e-02 3.78714143588725822586228686450482e-05
 	 9.36695848074365122748474732361501e-01 5.76927027672543418779227408776933e-02 1.11164571639687877646802960374117e-04
 	 8.93093134981845060416105752665317e-01 9.74303548765145244203722540987656e-02 2.37864053078098839667797737007504e-04
 	 8.39818615708710969336436846788274e-01 1.45982478426070483301657532138051e-01 4.22733850214109029095471692372143e-04
 	 7.78184222976761708068238476698752e-01 2.02153433915715552426917156481068e-01 6.62838212796453538945551375860532e-04
 	 7.09707651653902482635771775676403e-01 2.64560059005508885210389280473464e-01 9.47455685301899254435742392388420e-04
 	 6.36075044879270912190349918091670e-01 3.31665674789087372431595213129185e-01 1.25881386731710519059912467554341e-03
 	 5.59099492649031915014745663938811e-01 4.01817908411635893450863932230277e-01 1.57358070340486819356506931200101e-03
 	 4.80676393578551797158837644019513e-01 4.73289374455050093626340412811260e-01 1.86497243879358361347275963026959e-03
 	 4.02736786165077020882563374470919e-01 5.44320206833695863224420463666320e-01 2.10527623413878225630546658919684e-03
 	 3.27199800763811721182605651847553e-01 6.13161392034455077215682194946567e-01 2.26854295685093671972043516404938e-03
 	 2.55925403482102797880770594929345e-01 6.78117836315066058183731456665555e-01 2.33318706865700198002655518791926e-03
 	 1.90668594904763288866433867951855e-01 7.37590107031443786844704391114647e-01 2.28423769365716398602184078470145e-03
 	 1.33036188558098844580968034279067e-01 7.90113822901228557427089072007220e-01 2.11501728892781728705307919824463e-03
 	 8.44472227842097966643564177502412e-02 8.34395732932253109126463641587179e-01 1.82807904993328063265878302701140e-03
 	 4.60979330484310168003503349609673e-02 8.69345639166849815104853860248113e-01 1.43530805216183186823197814874220e-03
 	 1.89318370315880724064072637702338e-02 8.94103659852247267814107090089237e-01 9.57198420615420022573849312408356e-04
 	 3.61164281855697044676389850792475e-03 9.08065831118790911524740749882767e-01 4.21953705454781969556160570178349e-04
 	 9.90851805270955621196549145679455e-01 7.87186685618089868055058389018086e-03 7.81678281555049632803051223861601e-06
 	 9.69552637080220991450119072396774e-01 2.61994408869951969642819733508077e-02 4.61819397047317364846108489473409e-05
 	 9.36695848074365122748474732361501e-01 5.44721521744542247489562214468606e-02 1.35558590342524219350336944778235e-04
 	 8.93093134981844949393803290149663e-01 9.19915494105937869839806353411404e-02 2.90061080187840403601939875954940e-04
 	 8.39818615708710969336436846788274e-01 1.37833372302022527655651629174827e-01 5.15498813874197829749956856204562e-04
 	 7.78184222976761708068238476698752e-01 1.90868724928162952769739035829843e-01 8.08291818395906426150676615804969e-04
 	 7.09707651653902482635771775676403e-01 2.49791656521425126102897706914518e-01 1.15536591575082065418145216284529e-03
 	 6.36075044879271023212652380607324e-01 3.13151269425507972066213824291481e-01 1.53504871957069882748569966679497e-03
 	 5.59099492649031915014745663938811e-01 3.79387430360479394053641044592950e-01 1.91888817450905379592696053947520e-03
 	 4.80676393578551852669988875277340e-01 4.46869180871532378773736127186567e-01 2.27422308296160993398848937374623e-03
 	 4.02736786165077020882563374470919e-01 5.13934894988220536404810445674229e-01 2.56725928388844846020355738858143e-03
 	 3.27199800763811721182605651847553e-01 5.78933193494941877865755941456882e-01 2.76635335184779356312856357646979e-03
 	 2.55925403482102797880770594929345e-01 6.40263607010829405297158700705040e-01 2.84518300540664501041554501625797e-03
 	 1.90668594904763288866433867951855e-01 6.96415987212049780730183101695729e-01 2.78549215089021707722483078839559e-03
 	 1.33036188558098733558665571763413e-01 7.46007698232574734120703396911267e-01 2.57913792144512377113585444021737e-03
 	 8.44472227842097966643564177502412e-02 7.87817681576855721736762916407315e-01 2.22923378724362289057814301429516e-03
 	 4.60979330484310168003503349609673e-02 8.20816596856907887413967728207354e-01 1.75027289169949460713449074233949e-03
 	 1.89318370315880724064072637702338e-02 8.44192563064521839244491729914444e-01 1.16724660260725861954389515062758e-03
 	 3.61164281855697044676389850792475e-03 8.57375331099938575718510946899187e-01 5.14547473692001495169934255358157e-04
 	 9.90851805270955621196549145679455e-01 7.32105005985136080004505032547968e-03 9.02099150578577605493878904807659e-06
 	 9.69552637080220991450119072396774e-01 2.43661918802911894865736996962369e-02 5.32964642395218442445271878060709e-05
 	 9.36695848074365122748474732361501e-01 5.06605815650823104734357116285537e-02 1.56441968629786461956326926170391e-04
 	 8.93093134981845060416105752665317e-01 8.55546404204540617000063207342464e-02 3.34746225176946882173822928052687e-04
 	 8.39818615708711080358739309303928e-01 1.28188781260815509721595617520506e-01 5.94913602044895030961091375587557e-04
 	 7.78184222976761708068238476698752e-01 1.77513100207213198045153035309340e-01 9.32812616136642885206198272385336e-04
 	 7.09707651653902482635771775676403e-01 2.32313027562279783566623336810153e-01 1.33335495663615302523730132833180e-03
 	 6.36075044879271023212652380607324e-01 2.91239189083847938022131529578473e-01 1.77152951373632169818073123224167e-03
 	 5.59099492649031915014745663938811e-01 3.52840618431772501395471408613957e-01 2.21450107176604168990330379074294e-03
 	 4.80676393578551908181140106535167e-01 4.15600479928909860571906165205291e-01 2.62457683650173202380417869505891e-03
 	 4.02736786165077076393714605728746e-01 4.77973416275315809986778958773357e-01 2.96275651244077512652674855075929e-03
 	 3.27199800763811721182605651847553e-01 5.38423599931462382173208425228950e-01 3.19252186965917174668594391562237e-03
 	 2.55925403482102797880770594929345e-01 5.95462550887377650710163834446575e-01 3.28349556714296886283932508376893e-03
 	 1.90668594904763288866433867951855e-01 6.47685790170211106442366144619882e-01 3.21460908222048020663197398505417e-03
 	 1.33036188558098622536363109247759e-01 6.93807428857465158245076963794418e-01 2.97646510471302012598715514002379e-03
 	 8.44472227842096856420539552345872e-02 7.32691849371347680985877559578512e-01 2.57265674813547196367324865207138e-03
 	 4.60979330484310168003503349609673e-02 7.63381737183203235019846033537760e-01 2.01990988638160035018032090192719e-03
 	 1.89318370315880724064072637702338e-02 7.85122020896076411311526044300990e-01 1.34706591391151909997692115439349e-03
 	 3.61164281855708146906636102357879e-03 7.97382353353162320885871849895921e-01 5.93815703855164831598267838330685e-04
 	 9.90851805270955621196549145679455e-01 6.69908916828409160826307555680614e-03 9.99156704465076997857125862267935e-06
 	 9.69552637080221102472421534912428e-01 2.22961584421818015400162948935758e-02 5.90306725541728309581898659352817e-05
 	 9.36695848074365122748474732361501e-01 4.63567043589517696622337439293915e-02 1.73273682516954051881577503202436e-04
 	 8.93093134981844949393803290149663e-01 7.82863332789095200947571129290736e-02 3.70761833624838588706340569700615e-04
 	 8.39818615708710969336436846788274e-01 1.17298484373060452057302427419927e-01 6.58920822261487211003727626490445e-04
 	 7.78184222976761819090540939214407e-01 1.62432448501904441728882488860108e-01 1.03317465582886667575801542540148e-03
 	 7.09707651653902482635771775676403e-01 2.12576839916506388217243284088909e-01 1.47681166033723017434742263986891e-03
 	 6.36075044879270912190349918091670e-01 2.66496920663189751365962365525775e-01 1.96212976109351065409636127867543e-03
 	 5.59099492649031803992443201423157e-01 3.22864991462022354884453534396016e-01 2.45276097586504329695067383454443e-03
 	 4.80676393578551852669988875277340e-01 3.80293079635349084988149570563110e-01 2.90695711318711197054809325379665e-03
 	 4.02736786165077020882563374470919e-01 4.37367113941401153276444802031619e-01 3.28152180522967408873857841911104e-03
 	 3.27199800763811721182605651847553e-01 4.92681743296619290006788105529267e-01 3.53600779712018266007222955238376e-03
 	 2.55925403482102797880770594929345e-01 5.44874941730617901036737293907208e-01 3.63676942594182064233399032104899e-03
 	 1.90668594904763288866433867951855e-01 5.92661547989589587714931440132204e-01 3.56047139017358696411186258501402e-03
 	 1.33036188558098733558665571763413e-01 6.34864916034797110988563417777186e-01 3.29670531567728599536826195048889e-03
 	 8.44472227842097966643564177502412e-02 6.70445904847874918353056727937656e-01 2.84945090186400394952070946885669e-03
 	 4.60979330484310168003503349609673e-02 6.98528528697660466839636228542076e-01 2.23723357249483575590054407200569e-03
 	 1.89318370315880724064072637702338e-02 7.18421863389499648633318429347128e-01 1.49199779024050075554308492087330e-03
 	 3.61164281855685942446143599227071e-03 7.29640617487800957619015207455959e-01 6.57704800345952330167809130045953e-04
 	 9.90851805270955621196549145679455e-01 6.02209237986816876136986209644419e-03 1.07033689734217375808152106220206e-05
 	 9.69552637080221102472421534912428e-01 2.00429524793723917719390215097519e-02 6.32360335744147080512186920309148e-05
 	 9.36695848074365122748474732361501e-01 4.16719869019671895760126290042535e-02 1.85617746352951374201947776221289e-04
 	 8.93093134981844949393803290149663e-01 7.03748702612802534694935729930876e-02 3.97175006564523872237132406937121e-04
 	 8.39818615708710858314134384272620e-01 1.05444530020194660036025879890076e-01 7.05862519204228573178883099359382e-04
 	 7.78184222976761708068238476698752e-01 1.46017344417166461401080823634402e-01 1.10677829672821805354065993753920e-03
 	 7.09707651653902482635771775676403e-01 1.91094242163304228743214707719744e-01 1.58202012098828293136520972694825e-03
 	 6.36075044879270912190349918091670e-01 2.39565265496413548618193090078421e-01 2.10191241402511545810494197894513e-03
 	 5.59099492649031915014745663938811e-01 2.90236889817017562620549142593518e-01 2.62749632875141541157870683775855e-03
 	 4.80676393578551852669988875277340e-01 3.41861408239060193814395915978821e-01 3.11404952129229039420321711872930e-03
 	 4.02736786165077020882563374470919e-01 3.93167652781980292431285306520294e-01 3.51529830293300380242293989851987e-03
 	 3.27199800763811665671454420589725e-01 4.42892294381371620648479847659473e-01 3.78791394546423333677953593223720e-03
 	 2.55925403482102853391921826187172e-01 4.89810950735193262328692753726500e-01 3.89585385987619272143978044198320e-03
 	 1.90668594904763288866433867951855e-01 5.32768336460755165262526134029031e-01 3.81412033147916860326143151382894e-03
 	 1.33036188558098733558665571763413e-01 5.70706715056022551024739186686929e-01 3.53156349075652974817129958751138e-03
 	 8.44472227842096856420539552345872e-02 6.02691959052154446752069816284347e-01 3.05244655197785047170966343799137e-03
 	 4.60979330484310168003503349609673e-02 6.27936608114769478916628031583969e-01 2.39661469508516567633593652431045e-03
 	 1.89318370315880724064072637702338e-02 6.45819561490739602049870882183313e-01 1.59828811487819420593392560903112e-03
 	 3.61164281855708146906636102357879e-03 6.55904570343413206856553188117687e-01 7.04559867559739544037866743053655e-04
 	 9.90851805270955621196549145679455e-01 5.30759342292349417524732757556194e-03 1.11379607870579201928194074122658e-05
 	 9.69552637080220991450119072396774e-01 1.76649304004555668390352707319835e-02 6.58036235160962100368756133583759e-05
 	 9.36695848074365122748474732361501e-01 3.67277599959163897347380611790868e-02 1.93154434402377907318421046412027e-04
 	 8.93093134981845060416105752665317e-01 6.20251525510543758046289042340504e-02 4.13301611828946371778037427446861e-04
 	 8.39818615708710969336436846788274e-01 9.29339270665083400091432963563420e-02 7.34522847850331756826280926730988e-04
 	 7.78184222976761819090540939214407e-01 1.28692927304159515644599309780460e-01 1.15171711818365688981269379098649e-03
 	 7.09707651653902482635771775676403e-01 1.68421618083299168278088586703234e-01 1.64625531602794676448719979333646e-03
 	 6.36075044879270912190349918091670e-01 2.11141734019284543766303841039189e-01 2.18725693782728398267822811362748e-03
 	 5.59099492649031915014745663938811e-01 2.55801357785928829002841666806489e-01 2.73418127978599084099142757509071e-03
 	 4.80676393578551852669988875277340e-01 3.01300818298094630343086919310736e-01 3.24049012448665617672216576750088e-03
 	 4.02736786165077076393714605728746e-01 3.46519766948109875226435860895435e-01 3.65803091999380384363727003460554e-03
 	 3.27199800763811721182605651847553e-01 3.90344763986088749696534705435624e-01 3.94171564991307316061508458915341e-03
 	 2.55925403482102742369619363671518e-01 4.31696695535402297227989265593351e-01 4.05403827814948460733779356246487e-03
 	 1.90668594904763288866433867951855e-01 4.69557346545204867815925808827160e-01 3.96898610097662710161081633941649e-03
 	 1.33036188558098622536363109247759e-01 5.02994477031906361830237983667757e-01 3.67495652768073076399613086095997e-03
 	 8.44472227842096856420539552345872e-02 5.31184790291130859429813426686451e-01 3.17638587298469093206376712146266e-03
 	 4.60979330484310168003503349609673e-02 5.53434255240667249964303664455656e-01 2.49392509609166470804786364112715e-03
 	 1.89318370315880724064072637702338e-02 5.69195462431385301727004843996838e-01 1.66318384371673898790289225502192e-03
 	 3.61164281855685942446143599227071e-03 5.78083922335374422729614707350265e-01 7.33167304285353054263407734936209e-04
 	 9.90851805270955621196549145679455e-01 4.57409736452219026908716514867592e-03 1.12840862945170176148646998259828e-05
 	 9.69552637080220991450119072396774e-01 1.52236814598894799888118001263138e-02 6.66669402455023621997115546022883e-05
 	 9.36695848074365122748474732361501e-01 3.16520759628174455646565377264778e-02 1.95688541882610628815791775636512e-04
 	 8.93093134981844949393803290149663e-01 5.34534325090775114253105471107119e-02 4.18723960579926333600009336066705e-04
 	 8.39818615708710969336436846788274e-01 8.00906921456445292095693844203197e-02 7.44159488339060041367511999510498e-04
 	 7.78184222976761819090540939214407e-01 1.10907888511619145965880761650624e-01 1.16682717751691203238173510925435e-03
 	 7.09707651653902482635771775676403e-01 1.45146174173048786437689727790712e-01 1.66785351502154923636345174031703e-03
 	 6.36075044879270912190349918091670e-01 1.81962477560364543904825040954165e-01 2.21595285767239814564422140108491e-03
 	 5.59099492649031915014745663938811e-01 2.20450253675484098003778399288421e-01 2.77005262415794609176522556026612e-03
 	 4.80676393578551797158837644019513e-01 2.59661803210724129176156793619157e-01 3.28300403460986484419081854468914e-03
 	 4.02736786165076965371412143213092e-01 2.98631606917461545069869544022367e-01 3.70602279523063113386704969798302e-03
 	 3.27199800763811776693756883105380e-01 3.36400099618094194919848405334051e-01 3.99342935322151860316752802759765e-03
 	 2.55925403482102742369619363671518e-01 3.72037298258948656570765933793155e-01 4.10722560857549462420834629483579e-03
 	 1.90668594904763288866433867951855e-01 4.04665702547618466589085528539727e-01 4.02105758149191253730814210598510e-03
 	 1.33036188558098789069816803021240e-01 4.33481905720950744242969676633948e-01 3.72317045999421593338585267929375e-03
 	 8.44472227842098521755076490080683e-02 4.57776388607895212690124253640533e-01 3.21805876144692394602575546969092e-03
 	 4.60979330484310168003503349609673e-02 4.76951033475784602622127295035170e-01 2.52664437722388297152820157975839e-03
 	 1.89318370315880724064072637702338e-02 4.90534081484206074819098830630537e-01 1.68500413809623424653272305562268e-03
 	 3.61164281855702595791512976575177e-03 4.98194178590721625798920513261692e-01 7.42786160594813434608629787447853e-04
 	 9.90851805270955621196549145679455e-01 3.84060130612088549556526473338636e-03 1.11379607870579693207303481616854e-05
 	 9.69552637080220991450119072396774e-01 1.27824325193233861996944256134157e-02 6.58036235160964946399458908032898e-05
 	 9.36695848074365122748474732361501e-01 2.65763919297184875167872064594121e-02 1.93154434402378747575104722677963e-04
 	 8.93093134981845060416105752665317e-01 4.48817124671006192904165743584599e-02 4.13301611828948160711622028529177e-04
 	 8.39818615708710969336436846788274e-01 6.72474572247806906544198568553838e-02 7.34522847850335009432798383244290e-04
 	 7.78184222976761819090540939214407e-01 9.31228497190787207760109822629602e-02 1.15171711818366187714268722430688e-03
 	 7.09707651653902482635771775676403e-01 1.21870730262798349086139637620363e-01 1.64625531602795392022153819766572e-03
 	 6.36075044879271023212652380607324e-01 1.52783221101444488532195009611314e-01 2.18725693782729352365734598606650e-03
 	 5.59099492649032026037048126454465e-01 1.85099149565039200471261437996873e-01 2.73418127978600298405575941274037e-03
 	 4.80676393578551908181140106535167e-01 2.18022788123353572498075436669751e-01 3.24049012448667048819084257615941e-03
 	 4.02736786165076965371412143213092e-01 2.50743446886813103891000764633645e-01 3.65803091999381988982942282007116e-03
 	 3.27199800763811721182605651847553e-01 2.82455435250099529120859642716823e-01 3.94171564991309050784984435722436e-03
 	 2.55925403482102853391921826187172e-01 3.12377900982494904891240139477304e-01 4.05403827814950195457255333053581e-03
 	 1.90668594904763288866433867951855e-01 3.39774058550031843317640323220985e-01 3.96898610097664444884557610748743e-03
 	 1.33036188558098733558665571763413e-01 3.63969334409995015633398907084484e-01 3.67495652768074681018828364642559e-03
 	 8.44472227842097966643564177502412e-02 3.84367986924659343905830155563308e-01 3.17638587298470480985157493591942e-03
 	 4.60979330484310168003503349609673e-02 4.00467811710901733235346000583377e-01 2.49392509609167598375045749037326e-03
 	 1.89318370315880724064072637702338e-02 4.11872700537026514844285429717274e-01 1.66318384371674614363723065935119e-03
 	 3.61164281855697044676389850792475e-03 4.18304434846068717845923856657464e-01 7.33167304285356198449707942899067e-04
 	 9.90851805270955621196549145679455e-01 3.12610234917621004208099222410056e-03 1.07033689734217545214741557080274e-05
 	 9.69552637080221102472421534912428e-01 1.04044104404065612667906748356472e-02 6.32360335744148164714359405813582e-05
 	 9.36695848074365122748474732361501e-01 2.16321650236676876755126386342454e-02 1.85617746352951699462599521872619e-04
 	 8.93093134981844949393803290149663e-01 3.65319947568747277477640977849660e-02 3.97175006564524522758435898239782e-04
 	 8.39818615708710969336436846788274e-01 5.47368542710943845053250811361067e-02 7.05862519204229765801272833414259e-04
 	 7.78184222976761819090540939214407e-01 7.57984326060717750195294684090186e-02 1.10677829672821978826413591434630e-03
 	 7.09707651653902482635771775676403e-01 9.91981061827932886210135166038526e-02 1.58202012098828553345042369215889e-03
 	 6.36075044879270912190349918091670e-01 1.24359689624315483680305760572082e-01 2.10191241402511892755189393255932e-03
 	 5.59099492649031915014745663938811e-01 1.50663617533950522364705193467671e-01 2.62749632875141974838739677977628e-03
 	 4.80676393578551852669988875277340e-01 1.77462198182387953515615208743839e-01 3.11404952129229559837364504915058e-03
 	 4.02736786165076965371412143213092e-01 2.04095561052942742197302550266613e-01 3.51529830293300987395510581734470e-03
 	 3.27199800763811776693756883105380e-01 2.29907904854816658168914500492974e-01 3.78791394546423940831170185106203e-03
 	 2.55925403482102742369619363671518e-01 2.54263645782703939790536651344155e-01 3.89585385987619879297194636080803e-03
 	 1.90668594904763288866433867951855e-01 2.76563068634481545871039998019114e-01 3.81412033147917510847446642685554e-03
 	 1.33036188558098733558665571763413e-01 2.96257096385878715416595241549658e-01 3.53156349075653538602259651213444e-03
 	 8.44472227842097966643564177502412e-02 3.12860818163635867605876228481065e-01 3.05244655197785567588009136841265e-03
 	 4.60979330484310168003503349609673e-02 3.25965458836799615305324095970718e-01 2.39661469508516957946375747212642e-03
 	 1.89318370315880724064072637702338e-02 3.35248601477672325543721854046453e-01 1.59828811487819680801913957424176e-03
 	 3.61164281855697044676389850792475e-03 3.40483786838029711674380450858735e-01 7.04559867559740736660256477108533e-04
 	 9.90851805270955621196549145679455e-01 2.44910556076028719518777876373861e-03 9.99156704465079538955967625168952e-06
 	 9.69552637080220991450119072396774e-01 8.15120447759715496816035340543749e-03 5.90306725541729800359885826921413e-05
 	 9.36695848074365122748474732361501e-01 1.69474475666831145281854276163358e-02 1.73273682516954512667500809541821e-04
 	 8.93093134981844949393803290149663e-01 2.86205317392454750002883656634367e-02 3.70761833624839564488295806654605e-04
 	 8.39818615708710969336436846788274e-01 4.28828999182286063618363414207124e-02 6.58920822261488945727203603297539e-04
 	 7.78184222976761708068238476698752e-01 5.93833285213338224473034188122256e-02 1.03317465582886927784322939061212e-03
 	 7.09707651653902482635771775676403e-01 7.77155084295911569025605558636016e-02 1.47681166033723386063480909058399e-03
 	 6.36075044879270912190349918091670e-01 9.74280344575393364436877163825557e-02 1.96212976109351542458592021489494e-03
 	 5.59099492649031915014745663938811e-01 1.18035515888945785611952032923000e-01 2.45276097586504980216370874757104e-03
 	 4.80676393578551852669988875277340e-01 1.39030526786099173364164016675204e-01 2.90695711318711934312286615522680e-03
 	 4.02736786165077020882563374470919e-01 1.59896099893521936863294286013115e-01 3.28152180522968232867508930894473e-03
 	 3.27199800763811721182605651847553e-01 1.80118455939569099832908705138834e-01 3.53600779712019133368960943641923e-03
 	 2.55925403482102797880770594929345e-01 1.99199654787279412104794573679101e-01 3.63676942594182974963223919928623e-03
 	 1.90668594904763288866433867951855e-01 2.16669857105647234440937154431595e-01 3.56047139017359607141011146325127e-03
 	 1.33036188558098733558665571763413e-01 2.32098895407104266475073472975055e-01 3.29670531567729423530477284032258e-03
 	 8.44472227842097966643564177502412e-02 2.45106872367915396004889316827757e-01 2.84945090186401088841461337608507e-03
 	 4.60979330484310168003503349609673e-02 2.55373538253908627382315899012610e-01 2.23723357249484139375184099662874e-03
 	 1.89318370315880724064072637702338e-02 2.62646299578912501004879231913947e-01 1.49199779024050444183047137158837e-03
 	 3.61164281855697044676389850792475e-03 2.66747739693642182956523356551770e-01 6.57704800345954064891285106853047e-04
 	 9.90851805270955621196549145679455e-01 1.82714466919302060549101796027571e-03 9.02099150578579977186131216848608e-06
 	 9.69552637080220991450119072396774e-01 6.08117103948777049104990055639064e-03 5.32964642395219797697987484941251e-05
 	 9.36695848074365233770777194877155e-01 1.26435703605525806558773638244020e-02 1.56441968629786868532141608234554e-04
 	 8.93093134981845060416105752665317e-01 2.13522245977009611506147734871774e-02 3.34746225176947749535560916456234e-04
 	 8.39818615708710969336436846788274e-01 3.19926030304735486975431513201329e-02 5.94913602044896548844132855293765e-04
 	 7.78184222976761819090540939214407e-01 4.43026768160250938866084879919072e-02 9.32812616136645270450977740495091e-04
 	 7.09707651653902482635771775676403e-01 5.79793207838178170643317344001844e-02 1.33335495663615649468425328194598e-03
 	 6.36075044879270912190349918091670e-01 7.26857660368812052986697835876839e-02 1.77152951373632625182985567136029e-03
 	 5.59099492649031915014745663938811e-01 8.80598889191956946120853899628855e-02 2.21450107176604732775460071536600e-03
 	 4.80676393578551908181140106535167e-01 1.03723126492538397780407422033022e-01 2.62457683650173896269808260228729e-03
 	 4.02736786165077020882563374470919e-01 1.19289797559607335664111360529205e-01 2.96275651244078249910152145218944e-03
 	 3.27199800763811721182605651847553e-01 1.34376599304726118688790847954806e-01 3.19252186965917998662245480545607e-03
 	 2.55925403482102797880770594929345e-01 1.48612045630519773453670495655388e-01 3.28349556714297753645670496780440e-03
 	 1.90668594904763288866433867951855e-01 1.61645614925025826735804912459571e-01 3.21460908222048844656848487488787e-03
 	 1.33036188558098733558665571763413e-01 1.73156382584436441263164851989131e-01 2.97646510471302749856192804145394e-03
 	 8.44472227842097966643564177502412e-02 1.82860927844442855416673410218209e-01 2.57265674813547890256715255929976e-03
 	 4.60979330484310168003503349609673e-02 1.90520329768366081246711019048234e-01 2.01990988638160555435074883234847e-03
 	 1.89318370315880724064072637702338e-02 1.95946142072335849348974079475738e-01 1.34706591391152256942387310800768e-03
 	 3.61164281855697044676389850792475e-03 1.99006003828280930711969176627463e-01 5.93815703855166457901526566587336e-04
 	 9.90851805270955621196549145679455e-01 1.27632787286347665345331847674970e-03 7.81678281555046244671262206660245e-06
 	 9.69552637080220991450119072396774e-01 4.24792203278374913555381908736308e-03 4.61819397047315399729670859496622e-05
 	 9.36695848074365122748474732361501e-01 8.83199975118063862478123837718158e-03 1.35558590342523623039142077750796e-04
 	 8.93093134981844949393803290149663e-01 1.49153156075611942332770354369131e-02 2.90061080187839210979550141900063e-04
 	 8.39818615708710969336436846788274e-01 2.23480119892664752523359084079857e-02 5.15498813874195661345611885195694e-04
 	 7.78184222976761819090540939214407e-01 3.09470520950752281397200249557500e-02 8.08291818395903065123941910741223e-04
 	 7.09707651653902482635771775676403e-01 4.05006918246723357501792861512513e-02 1.15536591575081588369189322662578e-03
 	 6.36075044879270912190349918091670e-01 5.07736856952209492099825638433686e-02 1.53504871957069232227266475376837e-03
 	 5.59099492649032026037048126454465e-01 6.15130769904886354204620602104114e-02 1.91888817450904577283088414674239e-03
 	 4.80676393578551852669988875277340e-01 7.24544255499156575339725350204390e-02 2.27422308296160039300937150130721e-03
 	 4.02736786165077020882563374470919e-01 8.33283188467023316903237173391972e-02 2.56725928388843761818183253353709e-03
 	 3.27199800763811721182605651847553e-01 9.38670057412462899293359441799112e-02 2.76635335184778185374510073302190e-03
 	 2.55925403482102797880770594929345e-01 1.03810989507067685799768241849961e-01 2.84518300540663286735121317860830e-03
 	 1.90668594904763288866433867951855e-01 1.12915417883186819381080567836761e-01 2.78549215089020536784136794494771e-03
 	 1.33036188558098733558665571763413e-01 1.20956113209326310276026106294012e-01 2.57913792144511249543326059097126e-03
 	 8.44472227842097966643564177502412e-02 1.27735095638934370576578203326790e-01 2.22923378724361334959902514185615e-03
 	 4.60979330484310168003503349609673e-02 1.33085470094660873741077011800371e-01 1.75027289169948723455971784090934e-03
 	 1.89318370315880724064072637702338e-02 1.36875599903889866304496081284015e-01 1.16724660260725384905433621440807e-03
 	 3.61164281855697044676389850792475e-03 1.39013026081504231790120229561580e-01 5.14547473691999218345372035798846e-04
 	 9.90851805270955621196549145679455e-01 8.10920422301865048697600002469699e-04 6.41013831064128789888811529862345e-06
 	 9.69552637080220991450119072396774e-01 2.69893559638563484970319450440002e-03 3.78714143588725077197235102666184e-05
 	 9.36695848074365122748474732361501e-01 5.61144915838052843470862285357725e-03 1.11164571639687660806368463273230e-04
 	 8.93093134981845060416105752665317e-01 9.47651014164044291909760886483127e-03 2.37864053078098378881874430668120e-04
 	 8.39818615708710969336436846788274e-01 1.41989058652185196063300054447609e-02 4.22733850214108161733733703968596e-04
 	 7.78184222976761708068238476698752e-01 1.96623431075226562381175199334393e-02 6.62838212796452237902944393255211e-04
 	 7.09707651653902482635771775676403e-01 2.57322893405886321538389438501326e-02 9.47455685301897411292049167030882e-04
 	 6.36075044879271023212652380607324e-01 3.22592803316416043557524062634911e-02 1.25881386731710280535434520743365e-03
 	 5.59099492649031803992443201423157e-01 3.90825989393321360232391725730849e-02 1.57358070340486494095855185548771e-03
 	 4.80676393578551852669988875277340e-01 4.60342319663979981925194806535728e-02 1.86497243879357992718537317955452e-03
 	 4.02736786165077020882563374470919e-01 5.29430070012270048707136993471067e-02 2.10527623413877791949677664717910e-03
 	 3.27199800763811721182605651847553e-01 5.96388072017330905794096906902269e-02 2.26854295685093238291174522203164e-03
 	 2.55925403482102797880770594929345e-01 6.59567602028310329131954858894460e-02 2.33318706865699720953699625169975e-03
 	 1.90668594904763288866433867951855e-01 7.17412980637928132665592784178443e-02 2.28423769365715964921315084268372e-03
 	 1.33036188558098733558665571763413e-01 7.68499885406724869696404311980586e-02 2.11501728892781295024438925622690e-03
 	 8.44472227842097966643564177502412e-02 8.11570442835369831868774781469256e-02 1.82807904993327694637139657629632e-03
 	 4.60979330484310168003503349609673e-02 8.45564277847190570724933422752656e-02 1.43530805216182904930632968643067e-03
 	 1.89318370315880724064072637702338e-02 8.69645031161645487571831836248748e-02 9.57198420615418071009938838500375e-04
 	 3.61164281855697044676389850792475e-03 8.83225260626520070061928890936542e-02 4.21953705454781102194422581774802e-04
 	 9.90851805270955621196549145679455e-01 4.42974326044993579887254497862159e-04 4.83752283248630075775283121419790e-06
 	 9.69552637080220991450119072396774e-01 1.47432367463884439473531529074535e-03 2.85803242896434554559063206946590e-05
 	 9.36695848074365122748474732361501e-01 3.06531669533419148798714104486862e-03 8.38922855342803043847063615423565e-05
 	 8.93093134981844949393803290149663e-01 5.17664937002791647469024383099168e-03 1.79508262073352619367719307241771e-04
 	 8.39818615708710969336436846788274e-01 7.75631070970872471548318571876734e-03 3.19023483328085329796541813607291e-04
 	 7.78184222976761708068238476698752e-01 1.07407742448962506554011042680941e-02 5.00222434096974115022571361066639e-04
 	 7.09707651653902482635771775676403e-01 1.40565500815551525093383133935276e-02 7.15013980713678797863919189836679e-04
 	 6.36075044879270912190349918091670e-01 1.76219917153424554534524304472143e-02 9.49985870802162127995993401441410e-04
 	 5.59099492649031915014745663938811e-01 2.13493056150864113362786156358197e-02 1.18753016122039641716545688154838e-03
 	 4.80676393578551852669988875277340e-01 2.51467126976895327672423263720702e-02 1.40743402363794419158982140771741e-03
 	 4.02736786165077020882563374470919e-01 2.89207081239764018931737155071460e-02 1.58878347982451656981994769779476e-03
 	 3.27199800763811721182605651847553e-01 3.25783636713995461420267929497641e-02 1.71199556365648651243271949340397e-03
 	 2.55925403482102797880770594929345e-01 3.60296159714723618350262768217362e-02 1.76078037167357753269014697394823e-03
 	 1.90668594904763288866433867951855e-01 3.91894843012989824160285934340209e-02 1.72383987090395226701722286577478e-03
 	 1.33036188558098733558665571763413e-01 4.19801634588721217511420036316849e-02 1.59613473695359117145164962181525e-03
 	 8.44472227842097966643564177502412e-02 4.43329407012035270341243631264661e-02 1.37959178337251431659127298701151e-03
 	 4.60979330484310168003503349609673e-02 4.61898918569410010803721888805740e-02 1.08318028995690353311065479147146e-03
 	 1.89318370315880724064072637702338e-02 4.75053298674731339090726578433532e-02 7.22366506079907908649540004830669e-04
 	 3.61164281855697044676389850792475e-03 4.82471650499763926589480433904100e-02 3.18434733459829906986049419259643e-04
 	 9.90851805270955621196549145679455e-01 1.82011786449540191590301674295915e-04 3.13985489082108943837312771407699e-06
 	 9.69552637080221102472421534912428e-01 6.05778416599728197766694393067155e-04 1.85504180775034947206876545511278e-05
 	 9.36695848074365122748474732361501e-01 1.25949459132922852999669771634217e-03 5.44513405224770685925973767727015e-05
 	 8.93093134981844949393803290149663e-01 2.12701085427233205216168698825641e-03 1.16512089788757861757474698638504e-04
 	 8.39818615708710969336436846788274e-01 3.18695663727563971434619816136546e-03 2.07066194641533142008216206164661e-04
 	 7.78184222976761819090540939214407e-01 4.41322982670155905537967555574141e-03 3.24675647141198719328875066381102e-04
 	 7.09707651653902482635771775676403e-01 5.77563448090540054735697594878729e-03 4.64088795462167631126343403380474e-04
 	 6.36075044879270912190349918091670e-01 7.24062322425139681669747915293556e-03 6.16600248916251026526369471980615e-04
 	 5.59099492649032026037048126454465e-01 8.77212295609292036502324663160834e-03 7.70781351080264366323890889987069e-04
 	 4.80676393578551852669988875277340e-01 1.03324229697567826491422238177620e-02 9.13512712115993673160641019848072e-04
 	 4.02736786165077020882563374470919e-01 1.18831034701908366812972417392302e-02 1.03121985204539809780066583755342e-03
 	 3.27199800763811721182605651847553e-01 1.33859815858311526071133812365588e-02 1.11119220099847437061013621928396e-03
 	 2.55925403482102797880770594929345e-01 1.48040515724888743775977673067246e-02 1.14285659274492219263097414483354e-03
 	 1.90668594904763288866433867951855e-01 1.61023960720269032620421967294533e-02 1.11887989722795765275276114181224e-03
 	 1.33036188558098733558665571763413e-01 1.72490460447519700082352755998727e-02 1.03599127772124248274276947512362e-03
 	 8.44472227842097966643564177502412e-02 1.82157684117522089550789132772479e-02 8.95441356735145839104705878241930e-04
 	 4.60979330484310168003503349609673e-02 1.89787629632038878924049640772864e-02 7.03051757858926982744374178935232e-04
 	 1.89318370315880724064072637702338e-02 1.95192575431003545460839632141870e-02 4.68861044303249649596587733668684e-04
 	 3.61164281855697044676389850792475e-03 1.98240669617951725811622054607142e-02 2.06684059152497734759834635553943e-04
 	 9.90851805270955621196549145679455e-01 3.47318355634652908836557116956101e-05 1.36356678152047659627105116036949e-06
 	 9.69552637080220991450119072396774e-01 1.15595790600466624686859518078563e-04 8.05602002428398752649843506112859e-06
 	 9.36695848074365122748474732361501e-01 2.40339155460386755258639368548756e-04 2.36469651393008463988523737420167e-05
 	 8.93093134981844949393803290149663e-01 4.05880260137839177225771436496871e-04 5.05985215259216770662502316024955e-05
 	 8.39818615708710969336436846788274e-01 6.08141132137252071743205306120217e-04 8.99240870699002958245371619483421e-05
 	 7.78184222976761708068238476698752e-01 8.42140916447020604351791916997172e-04 1.40999167988501957274327658353741e-04
 	 7.09707651653902482635771775676403e-01 1.10211756600220311952398333232850e-03 2.01543092649921092279069467778641e-04
 	 6.36075044879270912190349918091670e-01 1.38166950672408139766389467695262e-03 2.67775310049309241914455848032617e-04
 	 5.59099492649031803992443201423157e-01 1.67391320087934003524310355714988e-03 3.34732617491655917892068305974362e-04
 	 4.80676393578551852669988875277340e-01 1.97165261963538895884084922727197e-03 3.96717565636387327690504100985436e-04
 	 4.02736786165077020882563374470919e-01 2.26755642456555328578815533546731e-03 4.47835069959507910738322200572270e-04
 	 3.27199800763811721182605651847553e-01 2.55433848743380487178455950925127e-03 4.82565222232265425474778686165678e-04
 	 2.55925403482102797880770594929345e-01 2.82493730169108836491886904696003e-03 4.96316339479348288092619423395035e-04
 	 1.90668594904763288866433867951855e-01 3.07268987058961773328746858169325e-03 4.85903811934479976184647620485180e-04
 	 1.33036188558098733558665571763413e-01 3.29149580111964823458947648759931e-03 4.49907190416760579838167943833582e-04
 	 8.44472227842097966643564177502412e-02 3.47596760341961630302876073983498e-03 3.88869591525732929970793350094027e-04
 	 4.60979330484310168003503349609673e-02 3.62156367614530072529532844782807e-03 3.05319212524282049183582676832316e-04
 	 1.89318370315880724064072637702338e-02 3.72470188075335606470162019832060e-03 2.03615570588908703338407168992319e-04
 	 3.61164281855697044676389850792475e-03 3.78286619425638459546235026209615e-03 8.97581344138039839697373878379949e-05
 	 ];
 
 	 case  38 

 	 % ALG. DEG.:   38
 	 % PTS CARD.:  400
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw=[
 	 9.91699955792932685838536599476356e-01 8.27152774180316303909155095652750e-03 1.01616886836072046458405698093896e-06
 	 9.72356946647436659603158659592737e-01 2.75480801028966520993535027628241e-02 6.01573190373150025738336471592405e-06
 	 9.42465542363186470353753065865021e-01 5.73367864772681701257539543803432e-02 1.77149143862327840173286758185256e-05
 	 9.02695871793453896714254369726405e-01 9.69698203736200636804198893514695e-02 3.80746061575217340346502514769611e-05
 	 8.53936753035890561136511678341776e-01 1.45561417407001070234429107586038e-01 6.80575990444619191533856539244596e-05
 	 7.97277508336594831206411981838755e-01 2.02025997916197463943888124049408e-01 1.07481077800942510401191465341242e-04
 	 7.33983858235659480939716559078079e-01 2.65102189997691861655937373143388e-01 1.54977430819236829204893490796735e-04
 	 6.65469698905513773468101135222241e-01 3.33380955202710660412179777267738e-01 2.08068067732737550963595385411509e-04
 	 5.93265533483506524170536522433395e-01 4.05337048744157768531692909164121e-01 2.63344747144576829794154759767366e-04
 	 5.18984288703573826140313940413762e-01 4.79363085421133983121677601957344e-01 3.16743171367583670108153404143536e-04
 	 4.44285286963011172289839123550337e-01 5.53805443770980287965244315273594e-01 3.63885191421072938435660182321385e-04
 	 3.70837180584396741700459187995875e-01 6.27001204460583050348532196949236e-01 4.00459639117227384971786641187919e-04
 	 3.00280676835950277592246493441053e-01 6.97315297200352568474102099571610e-01 4.22608131686533141247591460754052e-04
 	 2.34191886313592112500714392808732e-01 7.63177026438184968881728309497703e-01 4.27281510444061968408135943064963e-04
 	 1.74047112635542067238247909699567e-01 8.23115160692803216058166526636342e-01 4.12534947438531374337700174947940e-04
 	 1.21189867323676092603079723630799e-01 8.75790804345414453102591778588248e-01 3.77734988545247137633337208839635e-04
 	 7.68008370896219316747988159477245e-02 9.20027327170207076534325096872635e-01 3.23659493424134788418233821261083e-04
 	 4.18714311177650344575340568553656e-02 9.54836726167734295422917512041749e-01 2.52481268931459116883903037731329e-04
 	 1.71812181452557499738986734882928e-02 9.79442110965473844430562166962773e-01 1.67641044013593364407285757344823e-04
 	 3.27610666905009395577508257701993e-03 9.93299448644515026174417471338529e-01 7.37220545407965717737280852972503e-05
 	 9.91699955792932685838536599476356e-01 8.15052690892288309032487347849383e-03 2.34233520221411299660390151200495e-06
 	 9.72356946647436659603158659592737e-01 2.71450903843399524162371960755991e-02 1.38666525258977246825350254644249e-05
 	 9.42465542363186470353753065865021e-01 5.64980298249310661229394270321791e-02 4.08340275549089185198360640871584e-05
 	 9.02695871793453896714254369726405e-01 9.55512881029537686217167902213987e-02 8.77644386577910350305878339760568e-05
 	 8.53936753035890450114209215826122e-01 1.43432058322285976847965116576233e-01 1.56877183491344605100609177483761e-04
 	 7.97277508336594720184109519323101e-01 1.99070641327379366236627333819342e-01 2.47750861046544751734033162904325e-04
 	 7.33983858235659369917414096562425e-01 2.61224117313973325238407596771140e-01 3.57233037794402901766999125499069e-04
 	 6.65469698905513773468101135222241e-01 3.28504060086699412046584711788455e-01 4.79610402051852961931299734743561e-04
 	 5.93265533483506635192838984949049e-01 3.99407537047375804650783948090975e-01 6.07026736166404404931862259786612e-04
 	 5.18984288703573826140313940413762e-01 4.72350676782899270289561854951899e-01 7.30113570151080110148811286308046e-04
 	 4.44285286963011172289839123550337e-01 5.45704047989973739518632100953255e-01 8.38778986414918698195919422033739e-04
 	 3.70837180584396741700459187995875e-01 6.17829057509634127498543421097565e-01 9.23085462442316999689961853903242e-04
 	 3.00280676835950277592246493441053e-01 6.87114553834047958602582184539642e-01 9.74139175497661709973717947264049e-04
 	 2.34191886313592112500714392808732e-01 7.52012818480878975080372583761346e-01 9.84911616887938073938713046118210e-04
 	 1.74047112635542067238247909699567e-01 8.11074142018965882350300944381161e-01 9.50919831944511701610212028867863e-04
 	 1.21189867323676092603079723630799e-01 8.62979214991839382875582487031352e-01 8.70703667791755827297384140450731e-04
 	 7.68008370896219316747988159477245e-02 9.06568619621225812998943638376659e-01 7.46056141437527855012068478401943e-04
 	 4.18714311177650344575340568553656e-02 9.40868806003836044560273421666352e-01 5.81985713724808887380157695901062e-04
 	 1.71812181452557499738986734882928e-02 9.65114248582096601047908279724652e-01 3.86423488216502215766151584475097e-04
 	 3.27610666905009395577508257701993e-03 9.78768872874565598607432548305951e-01 1.69934121096453343187360207622305e-04
 	 9.91699955792932685838536599476356e-01 7.93581514438099384911584621704606e-03 3.61561023169796965948683334368674e-06
 	 9.72356946647436659603158659592737e-01 2.64299991613798739009677518652097e-02 2.14044559910316942012448865328977e-05
 	 9.42465542363186470353753065865021e-01 5.50096853519411177479980779025936e-02 6.30310844021844467969378777993938e-05
 	 9.02695871793453896714254369726405e-01 9.30341519837691866001705420785584e-02 1.35472498594730016976614428436676e-04
 	 8.53936753035890561136511678341776e-01 1.39653584773473060653969923805562e-01 2.42154389011063934326190016932401e-04
 	 7.97277508336594720184109519323101e-01 1.93826463969827916811183854406408e-01 3.82426284361492849553365580561604e-04
 	 7.33983858235659369917414096562425e-01 2.54342612376178722755071248684544e-01 5.51422112996073198604163323466310e-04
 	 6.65469698905513773468101135222241e-01 3.19850179523079369836580099217827e-01 7.40322851848146238663839202587269e-04
 	 5.93265533483506524170536522433395e-01 3.88885825014637420693475178268272e-01 9.37001705017645740609932847320351e-04
 	 5.18984288703573826140313940413762e-01 4.59907401835413121027329452772392e-01 1.12699757577159687463308479493662e-03
 	 4.44285286963011172289839123550337e-01 5.31328403277567917761814442201285e-01 1.29473265933430377837287661435539e-03
 	 3.70837180584396741700459187995875e-01 6.01553402131094094862362453568494e-01 1.42486747395644984190421489245182e-03
 	 3.00280676835950277592246493441053e-01 6.69013689933505628637533391156467e-01 1.50367358467646595500399886446985e-03
 	 2.34191886313592112500714392808732e-01 7.32202320212677171262782849225914e-01 1.52030184064693221768216346845293e-03
 	 1.74047112635542067238247909699567e-01 7.89707773665952905695064600877231e-01 1.46783238823083189185381147723319e-03
 	 1.21189867323676092603079723630799e-01 8.40245495799890940169518671609694e-01 1.34401134691099276123604777666287e-03
 	 7.68008370896219316747988159477245e-02 8.82686611725014613760720294521889e-01 1.15160640366624160597919246384890e-03
 	 4.18714311177650344575340568553656e-02 9.16083218053890813159512163110776e-01 8.98348579339293211963590746194086e-04
 	 1.71812181452557499738986734882928e-02 9.39689955697335599360542346403236e-01 5.96480263133701170061296004121232e-04
 	 3.27610666905009395577508257701993e-03 9.52984872144072125976776987954509e-01 2.62308975406319675599542406985165e-04
 	 9.91699955792932796860839061992010e-01 7.63237608404604243872437763229755e-03 4.80431463324827883913182083319704e-06
 	 9.72356946647436770625461122108391e-01 2.54194042868431079040814069003318e-02 2.84416003232017032618505342211890e-05
 	 9.42465542363186470353753065865021e-01 5.29062987522251129690609161571047e-02 8.37538179552917784508395127041069e-05
 	 9.02695871793453896714254369726405e-01 8.94768368065120001109136183004011e-02 1.80011800413484781158840464243553e-04
 	 8.53936753035890561136511678341776e-01 1.34313698225576955147531066359079e-01 3.21767502600743343036532317924525e-04
 	 7.97277508336594831206411981838755e-01 1.86415187494128387069025620803586e-01 5.08156597740861315677662890522015e-04
 	 7.33983858235659369917414096562425e-01 2.44617400548732044640587446338031e-01 7.32713195503818283393915322676548e-04
 	 6.65469698905513773468101135222241e-01 3.07620177165833286192508921885747e-01 9.83718842058874847270044661229349e-04
 	 5.93265533483506635192838984949049e-01 3.74016130197769525178586036417983e-01 1.24505981406098330255272088606944e-03
 	 5.18984288703573826140313940413762e-01 4.42322079179196969711540532443905e-01 1.49752063910165290720744035724010e-03
 	 4.44285286963011172289839123550337e-01 5.11012180118820102947552186378743e-01 1.72040199655676493556422101960379e-03
 	 3.70837180584396741700459187995875e-01 5.78552009613376827523723022750346e-01 1.89332124230483776240741011775981e-03
 	 3.00280676835950277592246493441053e-01 6.43432841371479824488233134616166e-01 1.99803644296510200806249457627928e-03
 	 2.34191886313592112500714392808732e-01 7.04205349519915868583552764903288e-01 2.02013157168886171161092946135796e-03
 	 1.74047112635542067238247909699567e-01 7.59511986538769945376259329350432e-01 1.95041173412694281499857318351587e-03
 	 1.21189867323676092603079723630799e-01 8.08117315007181535868596711225109e-01 1.78588204132386178801805698412863e-03
 	 7.68008370896219316747988159477245e-02 8.48935624440270819590637074725237e-01 1.53022011287922516872828104794735e-03
 	 4.18714311177650344575340568553656e-02 8.81055256109525952723515729303472e-01 1.19369869784075261290312575113148e-03
 	 1.71812181452557499738986734882928e-02 9.03759350967349495142855175799923e-01 7.92585116474581554725509224823554e-04
 	 3.27610666905009395577508257701993e-03 9.16545914222834379181392705504550e-01 3.48548313623152903641122524192042e-04
 	 9.91699955792932796860839061992010e-01 7.24731601191564833025493541640571e-03 5.88044581157942295541671273717554e-06
 	 9.72356946647436659603158659592737e-01 2.41369730307807520142127089002315e-02 3.48123098220374691761508367804367e-05
 	 9.42465542363186470353753065865021e-01 5.02371295460236760854755289074092e-02 1.02514057799329993698328467033321e-04
 	 9.02695871793453896714254369726405e-01 8.49626518586902995666676474684209e-02 2.20333121076344689301743096088160e-04
 	 8.53936753035890561136511678341776e-01 1.27537454267296568310996462969342e-01 3.93841059008994711070766880922633e-04
 	 7.97277508336594720184109519323101e-01 1.77010377674453239782437208305055e-01 6.21979941973811387145865126058197e-04
 	 7.33983858235659480939716559078079e-01 2.32276237998247314653355033442494e-01 8.96835567714729625481140384835044e-04
 	 6.65469698905513773468101135222241e-01 2.92100469239511217889315730644739e-01 1.20406463484381155010227715251858e-03
 	 5.93265533483506635192838984949049e-01 3.55146688167400192970291072924738e-01 1.52394406438168027520529967944185e-03
 	 5.18984288703573826140313940413762e-01 4.20006542072786703823084053510684e-01 1.83295425928528521973548404133680e-03
 	 4.44285286963011172289839123550337e-01 4.85231167132920138129748011124320e-01 2.10575940319816454215917644887668e-03
 	 3.70837180584396741700459187995875e-01 5.49363552951947053948345001117559e-01 2.31741128947631717244215465711932e-03
 	 3.00280676835950277592246493441053e-01 6.10971089804040690118824841192691e-01 2.44558192569358217455244286497873e-03
 	 2.34191886313592112500714392808732e-01 6.68677571578318308276323023164878e-01 2.47262620090835799624429114373925e-03
 	 1.74047112635542067238247909699567e-01 7.21193940218719964363458529987838e-01 2.38728963199638698558513461023267e-03
 	 1.21189867323676092603079723630799e-01 7.67347087206571409900845992524410e-01 2.18590649688098779060418941355692e-03
 	 7.68008370896219316747988159477245e-02 8.06106077103847962206373267690651e-01 1.87297817493091108866087868278782e-03
 	 4.18714311177650344575340568553656e-02 8.36605245165024657971741817164002e-01 1.46107843550193853415786193750137e-03
 	 1.71812181452557499738986734882928e-02 8.58163898510619249648812001396436e-01 9.70118359076313670208424611018927e-04
 	 3.27610666905009395577508257701993e-03 8.70305368427510828155391209293157e-01 4.26620574929447912964491917975351e-04
 	 9.91699955792932796860839061992010e-01 6.78965893758258932227933613035020e-03 6.81875525772850048082142360161839e-06
 	 9.72356946647436770625461122108391e-01 2.26127595919903001675521636570920e-02 4.03671130112726573809824037741834e-05
 	 9.42465542363186470353753065865021e-01 4.70647305926562703470850124176650e-02 1.18871645621459472814615554447926e-04
 	 9.02695871793453896714254369726405e-01 7.95973885511022383187906825696700e-02 2.55490429795751866973163579643824e-04
 	 8.53936753035890450114209215826122e-01 1.19483656407248672870480277197203e-01 4.56684047073234748639197766451048e-04
 	 7.97277508336594720184109519323101e-01 1.65832439325982211597576565509371e-01 7.21225759989866104134048629958897e-04
 	 7.33983858235659480939716559078079e-01 2.17608343933107933887427520858182e-01 1.03993854184164903967091397873901e-03
 	 6.65469698905513773468101135222241e-01 2.73654765210091799332303708069958e-01 1.39619041184243348162341558094113e-03
 	 5.93265533483506413148234059917741e-01 3.32719710511322375179332766492735e-01 1.76711119096184770919932827126786e-03
 	 5.18984288703573826140313940413762e-01 3.93483762476900422733194773172727e-01 2.12542839321232289798158099358716e-03
 	 4.44285286963011227800990354808164e-01 4.54589550849022361322937513250508e-01 2.44176350945952101711977633158313e-03
 	 3.70837180584396741700459187995875e-01 5.14672073240584726505630897008814e-01 2.68718748896893842512123562471515e-03
 	 3.00280676835950277592246493441053e-01 5.72389187069004767849378367827740e-01 2.83580958797237251203804397903241e-03
 	 2.34191886313592112500714392808732e-01 6.26451591563438658916140866494970e-01 2.86716916507264666519327889204760e-03
 	 1.74047112635542067238247909699567e-01 6.75651630739657171886847208952531e-01 2.76821592299035523776495892889216e-03
 	 1.21189867323676092603079723630799e-01 7.18890276112428505683737967046909e-01 2.53469922113044041425689023583345e-03
 	 7.68008370896219316747988159477245e-02 7.55201694261580902534092274436262e-01 2.17183869848307101527162821241745e-03
 	 4.18714311177650344575340568553656e-02 7.83774885864504500254668073466746e-01 1.69421444959403418722976297772220e-03
 	 1.71812181452557499738986734882928e-02 8.03972142770302156122852466069162e-01 1.12491465333201378501426503930816e-03
 	 3.27610666905009395577508257701993e-03 8.15346897176081553126891776628327e-01 4.94694004768661869074486414632474e-04
 	 9.91699955792932685838536599476356e-01 6.27013145359552048763163156763767e-03 7.59724312881737624440032716210958e-06
 	 9.72356946647436770625461122108391e-01 2.08824885717770261650549912246788e-02 4.49757705568755314579423854048912e-05
 	 9.42465542363186470353753065865021e-01 4.34634567592996692853013485091651e-02 1.32443057240580811233926494807633e-04
 	 9.02695871793453896714254369726405e-01 7.35067982304316164254842647096666e-02 2.84659419333812234702979493405905e-04
 	 8.53936753035890450114209215826122e-01 1.10341070017933695623923995299265e-01 5.08823034047923162398463503564017e-04
 	 7.97277508336594720184109519323101e-01 1.53143361603745309373891814175295e-01 8.03567108996723687523722201575538e-04
 	 7.33983858235659480939716559078079e-01 2.00957505289007742899087816113024e-01 1.15866688901087515166377084341320e-03
 	 6.65469698905513773468101135222241e-01 2.52715396538166992002061306266114e-01 1.55559154302660181470874256604020e-03
 	 5.93265533483506524170536522433395e-01 3.07260842007921808338721803011140e-01 1.96885983525730071108661434209353e-03
 	 5.18984288703573826140313940413762e-01 3.63375382808838021109210103531950e-01 2.36808561765344599212013143585409e-03
 	 4.44285286963011227800990354808164e-01 4.19805511213079796117852993120323e-01 2.72053627726448823964666701158421e-03
 	 3.70837180584396686189307956738048e-01 4.75290671354691107719503406769945e-01 2.99397997358452063951239630057444e-03
 	 3.00280676835950277592246493441053e-01 5.28591417997964940767019470513333e-01 3.15957005238438545791090916736721e-03
 	 2.34191886313592112500714392808732e-01 5.78517104397500703250045717140893e-01 3.19450990909469090955896675154690e-03
 	 1.74047112635542067238247909699567e-01 6.23952481342483933346443336631637e-01 3.08425931201807392370572991069366e-03
 	 1.21189867323676092603079723630799e-01 6.63882615220343086370746732427506e-01 2.82408233079286304784139005619181e-03
 	 7.68008370896219316747988159477245e-02 6.97415575734958159692666868068045e-01 2.41979452338442636155635412364973e-03
 	 4.18714311177650344575340568553656e-02 7.23802419175269440287934230582323e-01 1.88764057359776314497235016887089e-03
 	 1.71812181452557499738986734882928e-02 7.42454233200920743485085040447302e-01 1.25334460579827220924609143537509e-03
 	 3.27610666905009395577508257701993e-03 7.52958620244844167856967942498159e-01 5.51172536121769429846850574250539e-04
 	 9.91699955792932796860839061992010e-01 5.70091063192771849155171537404385e-03 8.19766004769952375246661047114571e-06
 	 9.72356946647436659603158659592737e-01 1.89867153505506869315411222487455e-02 4.85302459269843275814840244386517e-05
 	 9.42465542363186470353753065865021e-01 3.95177173833150541248926401749486e-02 1.42910150501567479071340915908195e-04
 	 9.02695871793453896714254369726405e-01 6.68336366872390730264896774315275e-02 3.07156307822070240385464723331665e-04
 	 8.53936753035890450114209215826122e-01 1.00323985846070606875457542628283e-01 5.49035773482376039666963407626099e-04
 	 7.97277508336594720184109519323101e-01 1.39240560558790305023535438522231e-01 8.67073736271656270689633938530960e-04
 	 7.33983858235659480939716559078079e-01 1.82713996819129392834568648140703e-01 1.25023736947527585802730776265435e-03
 	 6.65469698905513773468101135222241e-01 2.29773155736649137281801813514903e-01 1.67853133387788522497274801281719e-03
 	 5.93265533483506524170536522433395e-01 2.79366806572062476021756083355285e-01 2.12446058884013626311126898826842e-03
 	 5.18984288703573826140313940413762e-01 3.30387105687839466305888436181704e-01 2.55523754185702769645138765497450e-03
 	 4.44285286963011227800990354808164e-01 3.81694342443826772903747723830747e-01 2.93554269230290269115934975729942e-03
 	 3.70837180584396741700459187995875e-01 4.32142397912287035133260815200629e-01 3.23059688849090245396644682784881e-03
 	 3.00280676835950277592246493441053e-01 4.80604347311143653698195521428715e-01 3.40927369930982531592844608780979e-03
 	 2.34191886313592112500714392808732e-01 5.25997634279344317143056741770124e-01 3.44697488414356717142950081722574e-03
 	 1.74047112635542067238247909699567e-01 5.67308255182318421638854033517418e-01 3.32801108378001425300296567399982e-03
 	 1.21189867323675981580777261115145e-01 6.03613415041135858984944206895307e-01 3.04727208304554847764777925078761e-03
 	 7.68008370896220426971012784633785e-02 6.34102155593482263995497305586468e-01 2.61103304865254338268387712673757e-03
 	 4.18714311177650344575340568553656e-02 6.58093524422858622280330109788338e-01 2.03682249629515144118130365313846e-03
 	 1.71812181452557499738986734882928e-02 6.75052072368866884488625146332197e-01 1.35239755089312037490689721863646e-03
 	 3.27610666905009395577508257701993e-03 6.84602840518432009808691418584203e-01 5.94732194579377184719126692158397e-04
 	 9.91699955792932685838536599476356e-01 5.09533842064367747948239184552222e-03 8.60593183915056691838697811025582e-06
 	 9.72356946647436659603158659592737e-01 1.69698748943154092971852264781774e-02 5.09472198352558394512067108106379e-05
 	 9.42465542363186470353753065865021e-01 3.53199965197940057848313699651044e-02 1.50027569719041181791827077596224e-04
 	 9.02695871793453896714254369726405e-01 5.97343159348349833637215056114655e-02 3.22453753107715618622663988901422e-04
 	 8.53936753035890561136511678341776e-01 8.96671939971707410155232764736866e-02 5.76379651797171701707589441809887e-04
 	 7.97277508336594831206411981838755e-01 1.24449903486254509488162511843257e-01 9.10257003883140048371147567962680e-04
 	 7.33983858235659480939716559078079e-01 1.63305427516773710161501753646007e-01 1.31250350976465650527924555746040e-03
 	 6.65469698905513773468101135222241e-01 2.05365785230982283993128589827393e-01 1.76212799325403787938093547182916e-03
 	 5.93265533483506524170536522433395e-01 2.49691411580297950578710697300266e-01 2.23026606569890145995160857239625e-03
 	 5.18984288703573826140313940413762e-01 2.95292142253293199427588433536584e-01 2.68249719921372477629550878930331e-03
 	 4.44285286963011172289839123550337e-01 3.41149330969027220206157835491467e-01 3.08174286002074488549640207679658e-03
 	 3.70837180584396741700459187995875e-01 3.86238603871431829261950952059124e-01 3.39149177452493328852045628707401e-03
 	 3.00280676835950222081095262183226e-01 4.29552742375614304837228019096074e-01 3.57906730781091869317278586493103e-03
 	 2.34191886313592056989563161550905e-01 4.70124183336821988010711947936215e-01 3.61864614189851257347596558133773e-03
 	 1.74047112635542067238247909699567e-01 5.07046634407835150604171303712064e-01 3.49375753328362440366938734825908e-03
 	 1.21189867323676092603079723630799e-01 5.39495323369951207403971693565836e-01 3.19903676042234286908128026993836e-03
 	 7.68008370896220426971012784633785e-02 5.66745435003586317534995941969100e-01 2.74107151500861071641290678257974e-03
 	 4.18714311177650344575340568553656e-02 5.88188350224100542362748456071131e-01 2.13826329337523648663199615782560e-03
 	 1.71812181452557499738986734882928e-02 6.03345497298760968796216275222832e-01 1.41975162115760790079721509471256e-03
 	 3.27610666905009395577508257701993e-03 6.11881746863277342640685674268752e-01 6.24351912535682420507532341957813e-04
 	 9.91699955792932685838536599476356e-01 4.46760885774417654953127865269380e-03 8.81248856734418044614996767815995e-06
 	 9.72356946647436770625461122108391e-01 1.48792400295713073826719963221876e-02 5.21700381466741504852581423623548e-05
 	 9.42465542363186470353753065865021e-01 3.09686847625307223874635553784174e-02 1.53628481801452358799370268016560e-04
 	 9.02695871793453896714254369726405e-01 5.23752373150604411122799319855403e-02 3.30193181385857181808773930242751e-04
 	 8.53936753035890450114209215826122e-01 7.86204795598678257695368642998801e-02 5.90213725468425589801291231140112e-04
 	 7.97277508336594831206411981838755e-01 1.09118069352960020412801611655595e-01 9.32104691275000788591720279896435e-04
 	 7.33983858235659480939716559078079e-01 1.43186715829460409210582838568371e-01 1.34400578468232313744668005028871e-03
 	 6.65469698905513773468101135222241e-01 1.80065370625494325373949777713278e-01 1.80442200623809334558700356865302e-03
 	 5.93265533483506413148234059917741e-01 2.18930220132044828229567201560712e-01 2.28379617378507903877049578511560e-03
 	 5.18984288703573826140313940413762e-01 2.58913085146248223011866684828419e-01 2.74688160931762896665997431000505e-03
 	 4.44285286963011227800990354808164e-01 2.99120813384204653484488289905130e-01 3.15570983235999389521220237497801e-03
 	 3.70837180584396741700459187995875e-01 3.38655230606011103944297246925998e-01 3.47289323781035073890333109147832e-03
 	 3.00280676835950333103397724698880e-01 3.76633204367839924397998174754321e-01 3.66497089697519380646628661679642e-03
 	 2.34191886313592056989563161550905e-01 4.12206372241317231530643994119600e-01 3.70549968914143110568226724410579e-03
 	 1.74047112635542122749399140957394e-01 4.44580094227313649124511130139581e-01 3.57761354546975909179939989712693e-03
 	 1.21189867323676148114230954888626e-01 4.73031207433455114230724802837358e-01 3.27581898214502351476817842979017e-03
 	 7.68008370896219316747988159477245e-02 4.96924191580633056730675889411941e-01 2.80686180645725591453754077519989e-03
 	 4.18714311177650344575340568553656e-02 5.15725407528704438142597155092517e-01 2.18958518136496077879926680509470e-03
 	 1.71812181452557499738986734882928e-02 5.29015242067374713563765453727683e-01 1.45382802975519667861015182808160e-03
 	 3.27610666905009395577508257701993e-03 5.36499852709101276992953444278101e-01 6.39337400534565388626750959133460e-04
 	 9.91699955792932685838536599476356e-01 3.83243534932308123341915262471957e-03 8.81248856734413301230492143734097e-06
 	 9.72356946647436770625461122108391e-01 1.27638133229919757682946368504417e-02 5.21700381466738794347150209862463e-05
 	 9.42465542363186470353753065865021e-01 2.65657728742828003198894748493331e-02 1.53628481801451545647740903888234e-04
 	 9.02695871793453896714254369726405e-01 4.49288908914856482956778904735984e-02 3.30193181385855447085297953435656e-04
 	 8.53936753035890561136511678341776e-01 6.74427674042416547273148808017140e-02 5.90213725468422445614991023177254e-04
 	 7.97277508336594720184109519323101e-01 9.36044223104451761363620221345627e-02 9.32104691274995909681944095126482e-04
 	 7.33983858235659480939716559078079e-01 1.22829425934880137605276217982464e-01 1.34400578468231598171234164595944e-03
 	 6.65469698905513773468101135222241e-01 1.54464930468991873402373471435567e-01 1.80442200623808380460788569621400e-03
 	 5.93265533483506524170536522433395e-01 1.87804246384448592088745044748066e-01 2.28379617378506732938703294166771e-03
 	 5.18984288703573826140313940413762e-01 2.22102626150177950847819374757819e-01 2.74688160931761465519129750134653e-03
 	 4.44285286963011227800990354808164e-01 2.56593899652784063203370124028879e-01 3.15570983235997741533918059531061e-03
 	 3.70837180584396797211610419253702e-01 2.90507588809592098844092333820299e-01 3.47289323781033252430683333500383e-03
 	 3.00280676835950277592246493441053e-01 3.23086118796209742498604100546800e-01 3.66497089697517472450805087191839e-03
 	 2.34191886313592056989563161550905e-01 3.53601741445090544946339150556014e-01 3.70549968914141159004316250502598e-03
 	 1.74047112635542067238247909699567e-01 3.81372793137144228126089728903025e-01 3.57761354546974044352203314645067e-03
 	 1.21189867323676037091928492372972e-01 4.05778925242868682143893011016189e-01 3.27581898214500616753341866171922e-03
 	 7.68008370896219316747988159477245e-02 4.26274971329744900572222832124680e-01 2.80686180645724073570712597813781e-03
 	 4.18714311177650344575340568553656e-02 4.42403161353530416377566325536463e-01 2.18958518136494950309667295584859e-03
 	 1.71812181452557499738986734882928e-02 4.53803539787369425440033410268370e-01 1.45382802975518908919494442955056e-03
 	 3.27610666905009395577508257701993e-03 4.60224040621848518028969010629226e-01 6.39337400534562027600016254069715e-04
 	 9.91699955792932685838536599476356e-01 3.20470578642358203819151540869825e-03 8.60593183915052117860782637803752e-06
 	 9.72356946647436659603158659592737e-01 1.06731784582478790579518346248733e-02 5.09472198352555616244000114001267e-05
 	 9.42465542363186470353753065865021e-01 2.22144611170195238614155641698744e-02 1.50027569719040368640197713467899e-04
 	 9.02695871793453896714254369726405e-01 3.75698122717111337998119324765867e-02 3.22453753107713883899188012094328e-04
 	 8.53936753035890561136511678341776e-01 5.63960529669387672369040842568211e-02 5.76379651797168665941506482397472e-04
 	 7.97277508336594720184109519323101e-01 7.82725881771507286943645453902718e-02 9.10257003883135169461371383192727e-04
 	 7.33983858235659480939716559078079e-01 1.02710714247566892165508534162655e-01 1.31250350976464934954490715313113e-03
 	 6.65469698905513773468101135222241e-01 1.29164515863503970294345890579280e-01 1.76212799325402833840181759939014e-03
 	 5.93265533483506413148234059917741e-01 1.57043054936195580761904011524166e-01 2.23026606569888975056814572894837e-03
 	 5.18984288703573826140313940413762e-01 1.85723569043133029943248857307481e-01 2.68249719921371003114596298644301e-03
 	 4.44285286963011172289839123550337e-01 2.14565382067961718526305503473850e-01 3.08174286002072797194251130292741e-03
 	 3.70837180584396741700459187995875e-01 2.42924215544171540059892322460655e-01 3.39149177452491507392395853059952e-03
 	 3.00280676835950222081095262183226e-01 2.70166580788435528592827949978528e-01 3.57906730781089917753368112585122e-03
 	 2.34191886313592112500714392808732e-01 2.95683930349585954999724890512880e-01 3.61864614189849305783686084225792e-03
 	 1.74047112635542067238247909699567e-01 3.18906252956622893179883249104023e-01 3.49375753328360575539202059758281e-03
 	 1.21189867323676092603079723630799e-01 3.39314809306372811015251045319019e-01 3.19903676042232552184652050186742e-03
 	 7.68008370896219316747988159477245e-02 3.56453727906791750790205242083175e-01 2.74107151500859597126336097971944e-03
 	 4.18714311177650344575340568553656e-02 3.69940218658134534202019949589157e-01 2.13826329337522477724853331437771e-03
 	 1.71812181452557499738986734882928e-02 3.79473284555983392252187513804529e-01 1.41975162115760031138200769618152e-03
 	 3.27610666905009395577508257701993e-03 3.84842146467672674425841705669882e-01 6.24351912535679059480797636894067e-04
 	 9.91699955792932796860839061992010e-01 2.59913357513953842403697791496597e-03 8.19766004769954577532323908295453e-06
 	 9.72356946647436659603158659592737e-01 8.65633800201259795414898690069094e-03 4.85302459269844495542284290579005e-05
 	 9.42465542363186470353753065865021e-01 1.80167402534984755213542939600302e-02 1.42910150501567831437046973697136e-04
 	 9.02695871793453896714254369726405e-01 3.04704915193070163814681450276112e-02 3.07156307822071053537094087459991e-04
 	 8.53936753035890561136511678341776e-01 4.57392611180388736213942024733115e-02 5.49035773482377449129787638781863e-04
 	 7.97277508336594831206411981838755e-01 6.34819311046149192812038108968409e-02 8.67073736271658439093978909539828e-04
 	 7.33983858235659480939716559078079e-01 8.33021449452111539812904084101319e-02 1.25023736947527889379339072206676e-03
 	 6.65469698905513773468101135222241e-01 1.04757145357837061494521435633942e-01 1.67853133387788956178143795483493e-03
 	 5.93265533483506635192838984949049e-01 1.27367659944430944296556162953493e-01 2.12446058884014146728169691868970e-03
 	 5.18984288703573826140313940413762e-01 1.50628605608586652042646392146708e-01 2.55523754185703420166442256800110e-03
 	 4.44285286963011172289839123550337e-01 1.74020370593161999295261921361089e-01 2.93554269230291049741499165293135e-03
 	 3.70837180584396686189307956738048e-01 1.97020421503316167655128765545669e-01 3.23059688849091026022208872348074e-03
 	 3.00280676835950333103397724698880e-01 2.19114975852906013198406753872405e-01 3.40927369930983398954582597184526e-03
 	 2.34191886313592112500714392808732e-01 2.39810479407063570356228865421144e-01 3.44697488414357584504688070126122e-03
 	 1.74047112635542067238247909699567e-01 2.58644632182139400100595594267361e-01 3.32801108378002292662034555803530e-03
 	 1.21189867323676092603079723630799e-01 2.75196717635187937389673606958240e-01 3.04727208304555628390342114641953e-03
 	 7.68008370896219316747988159477245e-02 2.89097007316895582285098953434499e-01 2.61103304865255032157778103396595e-03
 	 4.18714311177650344575340568553656e-02 3.00035044459376232239833370840643e-01 2.03682249629515664535173158355974e-03
 	 1.71812181452557499738986734882928e-02 3.07766709485877365537476180179510e-01 1.35239755089312384435384917225065e-03
 	 3.27610666905009395577508257701993e-03 3.12121052812517785213231036323123e-01 5.94732194579378594181950923314162e-04
 	 9.91699955792932685838536599476356e-01 2.02991275347174249948922764019699e-03 7.59724312881737370330148539920856e-06
 	 9.72356946647436770625461122108391e-01 6.76056478078626912897597378560022e-03 4.49757705568755179054152293360858e-05
 	 9.42465542363186470353753065865021e-01 1.40710008775138881165212012547272e-02 1.32443057240580757023817870532412e-04
 	 9.02695871793453896714254369726405e-01 2.37973299761145284936247890072991e-02 2.84659419333812126282762244855462e-04
 	 8.53936753035890561136511678341776e-01 3.57221769461758681396545966890699e-02 5.08823034047922945558029006463130e-04
 	 7.97277508336594831206411981838755e-01 4.95791300596599981975742821305175e-02 8.03567108996723362263070455924208e-04
 	 7.33983858235659480939716559078079e-01 6.50586364753329426946493185823783e-02 1.15866688901087471798290184921143e-03
 	 6.65469698905513773468101135222241e-01 8.18149045563194010632912522851257e-02 1.55559154302660116418743907473754e-03
 	 5.93265533483506413148234059917741e-01 9.94736245085718340241953683289466e-02 1.96885983525729984372487635368998e-03
 	 5.18984288703573826140313940413762e-01 1.17640328487588374795080881085596e-01 2.36808561765344512475839344745054e-03
 	 4.44285286963011116778687892292510e-01 1.35909201823909253636912808360648e-01 2.72053627726448693860406002897889e-03
 	 3.70837180584396741700459187995875e-01 1.53872148060912428135793561523315e-01 2.99397997358451933846978931796912e-03
 	 3.00280676835950277592246493441053e-01 1.71127905166085114707641423592577e-01 3.15957005238438415686830218476189e-03
 	 2.34191886313592112500714392808732e-01 1.87291009288907517316147277597338e-01 3.19450990909468960851635976894158e-03
 	 1.74047112635542067238247909699567e-01 2.02000406021974332482216141215758e-01 3.08425931201807262266312292808834e-03
 	 1.21189867323676092603079723630799e-01 2.14927517455981154093080931488657e-01 2.82408233079286218047965206778827e-03
 	 7.68008370896219316747988159477245e-02 2.25783587175420352721744166046847e-01 2.41979452338442506051374714104440e-03
 	 4.18714311177650344575340568553656e-02 2.34326149706965858321439100109274e-01 1.88764057359776249445104667756823e-03
 	 1.71812181452557499738986734882928e-02 2.40364548653823950630226136127021e-01 1.25334460579827177556522244117332e-03
 	 3.27610666905009395577508257701993e-03 2.43765273086106182276466824987438e-01 5.51172536121769213006416077149652e-04
 	 9.91699955792932796860839061992010e-01 1.51038526948466932803283313546672e-03 6.81875525772848946939310929571398e-06
 	 9.72356946647436770625461122108391e-01 5.03029376057298818758489744595863e-03 4.03671130112725963946102014645589e-05
 	 9.42465542363186470353753065865021e-01 1.04697270441572662380558256245422e-02 1.18871645621459296631762525553455e-04
 	 9.02695871793453896714254369726405e-01 1.77067396554438649669549477039254e-02 2.55490429795751487502403209717272e-04
 	 8.53936753035890450114209215826122e-01 2.65795905568608353819470835333050e-02 4.56684047073234043907785650873166e-04
 	 7.97277508336594720184109519323101e-01 3.68900523374230127071626839097007e-02 7.21225759989865019931876144454463e-04
 	 7.33983858235659480939716559078079e-01 4.84077978312326406840071513215662e-02 1.03993854184164730494743800193191e-03
 	 6.65469698905513773468101135222241e-01 6.08755358843944271995951567078009e-02 1.39619041184243131321907060993226e-03
 	 5.93265533483506524170536522433395e-01 7.40147560051711561612819423316978e-02 1.76711119096184489027367980895633e-03
 	 5.18984288703573826140313940413762e-01 8.75319488195257511264912864135113e-02 2.12542839321231986221549803417474e-03
 	 4.44285286963011227800990354808164e-01 1.01125162187966466387223363199155e-01 2.44176350945951754767282437796894e-03
 	 3.70837180584396741700459187995875e-01 1.14490746175018531793909914995311e-01 2.68718748896893408831254568269742e-03
 	 3.00280676835950277592246493441053e-01 1.27330136095044954558375138731208e-01 2.83580958797236817522935403701467e-03
 	 2.34191886313592112500714392808732e-01 1.39356522122969339605447203211952e-01 2.86716916507264189470371995582809e-03
 	 1.74047112635542067238247909699567e-01 1.50301256624800871897207343863556e-01 2.76821592299035090095626898687442e-03
 	 1.21189867323676092603079723630799e-01 1.59919856563895512735484771837946e-01 2.53469922113043651112906928801749e-03
 	 7.68008370896219316747988159477245e-02 1.67997468648797165791108909616014e-01 2.17183869848306797950554525300504e-03
 	 4.18714311177650344575340568553656e-02 1.74353683017730465287797869677888e-01 1.69421444959403158514454901251156e-03
 	 1.71812181452557499738986734882928e-02 1.78846639084442093903248860442545e-01 1.12491465333201226713122355960195e-03
 	 3.27610666905009395577508257701993e-03 1.81376996154868352917333140794653e-01 4.94694004768661110132965674779371e-04
 	 9.91699955792932796860839061992010e-01 1.05272819515161032005723384941120e-03 5.88044581157950935277733267581013e-06
 	 9.72356946647436659603158659592737e-01 3.50608032178253287147740024920495e-03 3.48123098220379841721827673950429e-05
 	 9.42465542363186470353753065865021e-01 7.29732809078985356077140522756963e-03 1.02514057799331498028842790670723e-04
 	 9.02695871793453896714254369726405e-01 1.23414763478558037190779828051745e-02 2.20333121076347914803206240463851e-04
 	 8.53936753035890561136511678341776e-01 1.85257926968128983080674743177951e-02 3.93841059009000457342281054096134e-04
 	 7.97277508336594720184109519323101e-01 2.57121139889519845223020411140169e-02 6.21979941973820494444114004295443e-04
 	 7.33983858235659480939716559078079e-01 3.37399037660932599180796387372538e-02 8.96835567714742852747644707989139e-04
 	 6.65469698905513773468101135222241e-01 4.24298318549750086425831341330195e-02 1.20406463484382933101790591479130e-03
 	 5.93265533483506635192838984949049e-01 5.15877783490932828591724046418676e-02 1.52394406438170260977005288083319e-03
 	 5.18984288703573826140313940413762e-01 6.10091692236394700366020060755545e-02 1.83295425928531210794936168184677e-03
 	 4.44285286963011172289839123550337e-01 7.04835459040686895804128653253429e-02 2.10575940319819533350087503720260e-03
 	 3.70837180584396741700459187995875e-01 7.97992664636562043511958108865656e-02 2.31741128947635099954993620485766e-03
 	 3.00280676835950277592246493441053e-01 8.87482333600090322889286653662566e-02 2.44558192569361817006456938372594e-03
 	 2.34191886313592112500714392808732e-01 9.71305421080895792229625840263907e-02 2.47262620090839442543728665668823e-03
 	 1.74047112635542067238247909699567e-01 1.04758947145737968398293560312595e-01 2.38728963199642211373552314057633e-03
 	 1.21189867323676092603079723630799e-01 1.11463045469752497496074283844791e-01 2.18590649688101988298849498448817e-03
 	 7.68008370896219316747988159477245e-02 1.17093085806530106118827916361624e-01 1.87297817493093862739605981460045e-03
 	 4.18714311177650344575340568553656e-02 1.21523323717210307570724125980632e-01 1.46107843550196000136087715048916e-03
 	 1.71812181452557499738986734882928e-02 1.24654883344125000377289325115271e-01 9.70118359076327981677101419677456e-04
 	 3.27610666905009395577508257701993e-03 1.26418524903439077888833708129823e-01 4.26620574929454201337092333901069e-04
 	 9.91699955792932796860839061992010e-01 6.67668123021216211587791633519373e-04 4.80431463324824411078098340688314e-06
 	 9.72356946647436770625461122108391e-01 2.22364906572017698160870224910468e-03 2.84416003232014999739431931891076e-05
 	 9.42465542363186470353753065865021e-01 4.62815888458841667718601797787414e-03 8.37538179552911685871174896078628e-05
 	 9.02695871793453896714254369726405e-01 7.82729140003410317483201197319431e-03 1.80011800413483480116233481638233e-04
 	 8.53936753035890561136511678341776e-01 1.17495487385325392271084865569719e-02 3.21767502600741012001861474089992e-04
 	 7.97277508336594720184109519323101e-01 1.63073041692768372357136286154855e-02 5.08156597740857629390276439806939e-04
 	 7.33983858235659480939716559078079e-01 2.13987412156085299308472258417169e-02 7.32713195503813079223487392255265e-04
 	 6.65469698905513773468101135222241e-01 2.69101239286529403393899428920122e-02 9.83718842058867691535706256900085e-04
 	 5.93265533483506413148234059917741e-01 3.27183363187239506508774411486229e-02 1.24505981406097441209490650493308e-03
 	 5.18984288703573826140313940413762e-01 3.86936321172292041481455271423329e-02 1.49752063910164228202614999929665e-03
 	 4.44285286963011172289839123550337e-01 4.47025329181687247626086900709197e-02 1.72040199655675257565945468485324e-03
 	 3.70837180584396741700459187995875e-01 5.06108098022264307758177892537788e-02 1.89332124230482431830047129750483e-03
 	 3.00280676835950277592246493441053e-01 5.62864817925698979195203719427809e-02 1.99803644296508769659381776762075e-03
 	 2.34191886313592112500714392808732e-01 6.16027641664920189157328422879800e-02 2.02013157168884740014225265269943e-03
 	 1.74047112635542067238247909699567e-01 6.64409008256879873854927609500010e-02 1.95041173412692893721076536905912e-03
 	 1.21189867323676092603079723630799e-01 7.06928176691423715283235651440918e-02 1.78588204132384899443242165517631e-03
 	 7.68008370896219316747988159477245e-02 7.42635384701072487345641093270388e-02 1.53022011287921410986612169580212e-03
 	 4.18714311177650344575340568553656e-02 7.70733127727089017966477513255086e-02 1.19369869784074415612618036419690e-03
 	 1.71812181452557499738986734882928e-02 7.90594308873947548832461507117841e-02 7.92585116474575916874212300200497e-04
 	 3.27610666905009395577508257701993e-03 8.01779791081155268628322119184304e-02 3.48548313623150355766017183256622e-04
 	 9.91699955792932685838536599476356e-01 3.64229062686263066472847071963770e-04 3.61561023169796245970678168213386e-06
 	 9.72356946647436659603158659592737e-01 1.21305419118340751527540533061256e-03 2.14044559910316535436634183264815e-05
 	 9.42465542363186470353753065865021e-01 2.52477228487239802046104841792840e-03 6.30310844021843112716663171113396e-05
 	 9.02695871793453896714254369726405e-01 4.26997622277688892999947256612359e-03 1.35472498594729745926071307060568e-04
 	 8.53936753035890450114209215826122e-01 6.40966219063640596509401348157553e-03 2.42154389011063446435212398455405e-04
 	 7.97277508336594831206411981838755e-01 8.89602769357725198240416375483619e-03 3.82426284361492090611844840708500e-04
 	 7.33983858235659480939716559078079e-01 1.16735293881617963052121922373772e-02 5.51422112996072114401990837961876e-04
 	 6.65469698905513773468101135222241e-01 1.46801215714068011841675343021052e-02 7.40322851848144829201014971431505e-04
 	 5.93265533483506524170536522433395e-01 1.78486415018559441136858367826790e-02 9.37001705017643897466239621962814e-04
 	 5.18984288703573826140313940413762e-01 2.11083094610129418100541442981921e-02 1.12699757577159470622873982392775e-03
 	 4.44285286963011172289839123550337e-01 2.43863097594207989260439717327245e-02 1.29473265933430117628766264914475e-03
 	 3.70837180584396741700459187995875e-01 2.76094172845090524148758959199768e-02 1.42486747395644702297856643014029e-03
 	 3.00280676835950277592246493441053e-01 3.07056332305439827479176528868265e-02 1.50367358467646291923791590505743e-03
 	 2.34191886313592112500714392808732e-01 3.36057934737304941918978329340462e-02 1.52030184064692918191608050904051e-03
 	 1.74047112635542067238247909699567e-01 3.62451136985048050220825643918943e-02 1.46783238823082907292816301492167e-03
 	 1.21189867323676092603079723630799e-01 3.85646368764327451827966797281988e-02 1.34401134691098994231039931435134e-03
 	 7.68008370896219316747988159477245e-02 4.05125511853632325198759644990787e-02 1.15160640366623922073441299573915e-03
 	 4.18714311177650344575340568553656e-02 4.20453508283439303383488550025504e-02 8.98348579339291368819897520836548e-04
 	 1.71812181452557499738986734882928e-02 4.31288261574084286209540550771635e-02 5.96480263133699977438906270066354e-04
 	 3.27610666905009395577508257701993e-03 4.37390211868775580228430044371635e-02 2.62308975406319133498456164232948e-04
 	 9.91699955792932685838536599476356e-01 1.49517298144375559987295787323092e-04 2.34233520221410113814263995180021e-06
 	 9.72356946647436659603158659592737e-01 4.97962968223332469452913073837408e-04 1.38666525258976535317674561031964e-05
 	 9.42465542363186470353753065865021e-01 1.03642781188245658441360319557134e-03 4.08340275549087084556651450206743e-05
 	 9.02695871793453896714254369726405e-01 1.75284010359232078624103223774000e-03 8.77644386577905877971916837054778e-05
 	 8.53936753035890561136511678341776e-01 2.63118864182348977109882071090396e-03 1.56877183491343819054034125493047e-04
 	 7.97277508336594720184109519323101e-01 3.65185033602585806811191559972940e-03 2.47750861046543504901534804574226e-04
 	 7.33983858235659480939716559078079e-01 4.79202445036724933302707540860865e-03 3.57233037794401058623305900141531e-04
 	 6.65469698905513773468101135222241e-01 6.02624100778681448531415298930369e-03 4.79610402051850468266303018083363e-04
 	 5.93265533483506524170536522433395e-01 7.32692946911761566752829821780324e-03 6.07026736166401369165779300374197e-04
 	 5.18984288703573826140313940413762e-01 8.66503451352684805897297337651253e-03 7.30113570151076423861424835592970e-04
 	 4.44285286963011172289839123550337e-01 1.00106650470149771692263129807543e-02 8.38778986414914469807446728566447e-04
 	 3.70837180584396741700459187995875e-01 1.13337619059691308009973909065593e-02 9.23085462442312229200402917683732e-04
 	 3.00280676835950277592246493441053e-01 1.26047693300016527828688595036510e-02 9.74139175497656722643724513943653e-04
 	 2.34191886313592112500714392808732e-01 1.37952952055288013966105609142687e-02 9.84911616887933086608719612797813e-04
 	 1.74047112635542067238247909699567e-01 1.48787453454919393891486834036186e-02 9.50919831944506822700435844097910e-04
 	 1.21189867323676092603079723630799e-01 1.58309176844844134990353268221952e-02 8.70703667791751382068476949882552e-04
 	 7.68008370896219316747988159477245e-02 1.66305432891521443039550831599627e-02 7.46056141437523951884247530585981e-04
 	 4.18714311177650344575340568553656e-02 1.72597628783988099598900589626282e-02 5.81985713724805851614074736488647e-04
 	 1.71812181452557499738986734882928e-02 1.77045332726475379558905842714012e-02 3.86423488216500209992132486291894e-04
 	 3.27610666905009395577508257701993e-03 1.79550204563841964144899066013750e-02 1.69934121096452475825622219218758e-04
 	 9.91699955792932685838536599476356e-01 2.85164652640956112206183092894207e-05 1.01616886836070055930979650488100e-06
 	 9.72356946647436659603158659592737e-01 9.49732496666327863366063866124023e-05 6.01573190373138336683664362247725e-06
 	 9.42465542363186470353753065865021e-01 1.97671159545359520492979754635599e-04 1.77149143862324384278861960639873e-05
 	 9.02695871793453896714254369726405e-01 3.34307832926039605325740922125988e-04 3.80746061575209886456566676926627e-05
 	 8.53936753035890561136511678341776e-01 5.01829557108424140210445330012590e-04 6.80575990444605910057243591815279e-05
 	 7.97277508336594831206411981838755e-01 6.96493747207760360851125369663350e-04 1.07481077800940409759482274676401e-04
 	 7.33983858235659480939716559078079e-01 9.13951766648712915497299036360346e-04 1.54977430819233820543864843521931e-04
 	 6.65469698905513773468101135222241e-01 1.14934589177556611971908751002047e-03 2.08068067732733485205448564769881e-04
 	 5.93265533483506524170536522433395e-01 1.39741777233570729777056840248406e-03 2.63344747144571679833835453621305e-04
 	 5.18984288703573826140313940413762e-01 1.65262587529219073800845762889367e-03 3.16743171367577490155770236768262e-04
 	 4.44285286963011172289839123550337e-01 1.90926926600853974491656117606908e-03 3.63885191421065836911430402267342e-04
 	 3.70837180584396741700459187995875e-01 2.16161495502020795100861505488865e-03 4.00459639117219578716144745555994e-04
 	 3.00280676835950277592246493441053e-01 2.40402596369715393365140698733740e-03 4.22608131686524901311080570920353e-04
 	 2.34191886313592112500714392808732e-01 2.63108724822291861755729769356549e-03 4.27281510444053620051407804680821e-04
 	 1.74047112635542067238247909699567e-01 2.83772667165471670358556366409175e-03 4.12534947438523297031515157939907e-04
 	 1.21189867323676092603079723630799e-01 3.01932833090945429432849778095260e-03 3.77734988545239765058564307409483e-04
 	 7.68008370896219316747988159477245e-02 3.17183574017099179087608717964031e-03 3.23659493424128500045633405335366e-04
 	 4.18714311177650344575340568553656e-02 3.29184271450067011954843110288493e-03 2.52481268931454237974126852961376e-04
 	 1.71812181452557499738986734882928e-02 3.37667088927040559553915954893455e-03 1.67641044013590084695713988693910e-04
 	 3.27610666905009395577508257701993e-03 3.42444468643487986980744608445093e-03 7.37220545407951352058495420038753e-05
 	 ];
 
 	 case  39 

 	 % ALG. DEG.:   39
 	 % PTS CARD.:  400
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw=[
 	 9.91699955792932685838536599476356e-01 8.27152774180316303909155095652750e-03 1.01616886836072046458405698093896e-06
 	 9.72356946647436659603158659592737e-01 2.75480801028966520993535027628241e-02 6.01573190373150025738336471592405e-06
 	 9.42465542363186470353753065865021e-01 5.73367864772681701257539543803432e-02 1.77149143862327840173286758185256e-05
 	 9.02695871793453896714254369726405e-01 9.69698203736200636804198893514695e-02 3.80746061575217340346502514769611e-05
 	 8.53936753035890561136511678341776e-01 1.45561417407001070234429107586038e-01 6.80575990444619191533856539244596e-05
 	 7.97277508336594831206411981838755e-01 2.02025997916197463943888124049408e-01 1.07481077800942510401191465341242e-04
 	 7.33983858235659480939716559078079e-01 2.65102189997691861655937373143388e-01 1.54977430819236829204893490796735e-04
 	 6.65469698905513773468101135222241e-01 3.33380955202710660412179777267738e-01 2.08068067732737550963595385411509e-04
 	 5.93265533483506524170536522433395e-01 4.05337048744157768531692909164121e-01 2.63344747144576829794154759767366e-04
 	 5.18984288703573826140313940413762e-01 4.79363085421133983121677601957344e-01 3.16743171367583670108153404143536e-04
 	 4.44285286963011172289839123550337e-01 5.53805443770980287965244315273594e-01 3.63885191421072938435660182321385e-04
 	 3.70837180584396741700459187995875e-01 6.27001204460583050348532196949236e-01 4.00459639117227384971786641187919e-04
 	 3.00280676835950277592246493441053e-01 6.97315297200352568474102099571610e-01 4.22608131686533141247591460754052e-04
 	 2.34191886313592112500714392808732e-01 7.63177026438184968881728309497703e-01 4.27281510444061968408135943064963e-04
 	 1.74047112635542067238247909699567e-01 8.23115160692803216058166526636342e-01 4.12534947438531374337700174947940e-04
 	 1.21189867323676092603079723630799e-01 8.75790804345414453102591778588248e-01 3.77734988545247137633337208839635e-04
 	 7.68008370896219316747988159477245e-02 9.20027327170207076534325096872635e-01 3.23659493424134788418233821261083e-04
 	 4.18714311177650344575340568553656e-02 9.54836726167734295422917512041749e-01 2.52481268931459116883903037731329e-04
 	 1.71812181452557499738986734882928e-02 9.79442110965473844430562166962773e-01 1.67641044013593364407285757344823e-04
 	 3.27610666905009395577508257701993e-03 9.93299448644515026174417471338529e-01 7.37220545407965717737280852972503e-05
 	 9.91699955792932685838536599476356e-01 8.15052690892288309032487347849383e-03 2.34233520221411299660390151200495e-06
 	 9.72356946647436659603158659592737e-01 2.71450903843399524162371960755991e-02 1.38666525258977246825350254644249e-05
 	 9.42465542363186470353753065865021e-01 5.64980298249310661229394270321791e-02 4.08340275549089185198360640871584e-05
 	 9.02695871793453896714254369726405e-01 9.55512881029537686217167902213987e-02 8.77644386577910350305878339760568e-05
 	 8.53936753035890450114209215826122e-01 1.43432058322285976847965116576233e-01 1.56877183491344605100609177483761e-04
 	 7.97277508336594720184109519323101e-01 1.99070641327379366236627333819342e-01 2.47750861046544751734033162904325e-04
 	 7.33983858235659369917414096562425e-01 2.61224117313973325238407596771140e-01 3.57233037794402901766999125499069e-04
 	 6.65469698905513773468101135222241e-01 3.28504060086699412046584711788455e-01 4.79610402051852961931299734743561e-04
 	 5.93265533483506635192838984949049e-01 3.99407537047375804650783948090975e-01 6.07026736166404404931862259786612e-04
 	 5.18984288703573826140313940413762e-01 4.72350676782899270289561854951899e-01 7.30113570151080110148811286308046e-04
 	 4.44285286963011172289839123550337e-01 5.45704047989973739518632100953255e-01 8.38778986414918698195919422033739e-04
 	 3.70837180584396741700459187995875e-01 6.17829057509634127498543421097565e-01 9.23085462442316999689961853903242e-04
 	 3.00280676835950277592246493441053e-01 6.87114553834047958602582184539642e-01 9.74139175497661709973717947264049e-04
 	 2.34191886313592112500714392808732e-01 7.52012818480878975080372583761346e-01 9.84911616887938073938713046118210e-04
 	 1.74047112635542067238247909699567e-01 8.11074142018965882350300944381161e-01 9.50919831944511701610212028867863e-04
 	 1.21189867323676092603079723630799e-01 8.62979214991839382875582487031352e-01 8.70703667791755827297384140450731e-04
 	 7.68008370896219316747988159477245e-02 9.06568619621225812998943638376659e-01 7.46056141437527855012068478401943e-04
 	 4.18714311177650344575340568553656e-02 9.40868806003836044560273421666352e-01 5.81985713724808887380157695901062e-04
 	 1.71812181452557499738986734882928e-02 9.65114248582096601047908279724652e-01 3.86423488216502215766151584475097e-04
 	 3.27610666905009395577508257701993e-03 9.78768872874565598607432548305951e-01 1.69934121096453343187360207622305e-04
 	 9.91699955792932685838536599476356e-01 7.93581514438099384911584621704606e-03 3.61561023169796965948683334368674e-06
 	 9.72356946647436659603158659592737e-01 2.64299991613798739009677518652097e-02 2.14044559910316942012448865328977e-05
 	 9.42465542363186470353753065865021e-01 5.50096853519411177479980779025936e-02 6.30310844021844467969378777993938e-05
 	 9.02695871793453896714254369726405e-01 9.30341519837691866001705420785584e-02 1.35472498594730016976614428436676e-04
 	 8.53936753035890561136511678341776e-01 1.39653584773473060653969923805562e-01 2.42154389011063934326190016932401e-04
 	 7.97277508336594720184109519323101e-01 1.93826463969827916811183854406408e-01 3.82426284361492849553365580561604e-04
 	 7.33983858235659369917414096562425e-01 2.54342612376178722755071248684544e-01 5.51422112996073198604163323466310e-04
 	 6.65469698905513773468101135222241e-01 3.19850179523079369836580099217827e-01 7.40322851848146238663839202587269e-04
 	 5.93265533483506524170536522433395e-01 3.88885825014637420693475178268272e-01 9.37001705017645740609932847320351e-04
 	 5.18984288703573826140313940413762e-01 4.59907401835413121027329452772392e-01 1.12699757577159687463308479493662e-03
 	 4.44285286963011172289839123550337e-01 5.31328403277567917761814442201285e-01 1.29473265933430377837287661435539e-03
 	 3.70837180584396741700459187995875e-01 6.01553402131094094862362453568494e-01 1.42486747395644984190421489245182e-03
 	 3.00280676835950277592246493441053e-01 6.69013689933505628637533391156467e-01 1.50367358467646595500399886446985e-03
 	 2.34191886313592112500714392808732e-01 7.32202320212677171262782849225914e-01 1.52030184064693221768216346845293e-03
 	 1.74047112635542067238247909699567e-01 7.89707773665952905695064600877231e-01 1.46783238823083189185381147723319e-03
 	 1.21189867323676092603079723630799e-01 8.40245495799890940169518671609694e-01 1.34401134691099276123604777666287e-03
 	 7.68008370896219316747988159477245e-02 8.82686611725014613760720294521889e-01 1.15160640366624160597919246384890e-03
 	 4.18714311177650344575340568553656e-02 9.16083218053890813159512163110776e-01 8.98348579339293211963590746194086e-04
 	 1.71812181452557499738986734882928e-02 9.39689955697335599360542346403236e-01 5.96480263133701170061296004121232e-04
 	 3.27610666905009395577508257701993e-03 9.52984872144072125976776987954509e-01 2.62308975406319675599542406985165e-04
 	 9.91699955792932796860839061992010e-01 7.63237608404604243872437763229755e-03 4.80431463324827883913182083319704e-06
 	 9.72356946647436770625461122108391e-01 2.54194042868431079040814069003318e-02 2.84416003232017032618505342211890e-05
 	 9.42465542363186470353753065865021e-01 5.29062987522251129690609161571047e-02 8.37538179552917784508395127041069e-05
 	 9.02695871793453896714254369726405e-01 8.94768368065120001109136183004011e-02 1.80011800413484781158840464243553e-04
 	 8.53936753035890561136511678341776e-01 1.34313698225576955147531066359079e-01 3.21767502600743343036532317924525e-04
 	 7.97277508336594831206411981838755e-01 1.86415187494128387069025620803586e-01 5.08156597740861315677662890522015e-04
 	 7.33983858235659369917414096562425e-01 2.44617400548732044640587446338031e-01 7.32713195503818283393915322676548e-04
 	 6.65469698905513773468101135222241e-01 3.07620177165833286192508921885747e-01 9.83718842058874847270044661229349e-04
 	 5.93265533483506635192838984949049e-01 3.74016130197769525178586036417983e-01 1.24505981406098330255272088606944e-03
 	 5.18984288703573826140313940413762e-01 4.42322079179196969711540532443905e-01 1.49752063910165290720744035724010e-03
 	 4.44285286963011172289839123550337e-01 5.11012180118820102947552186378743e-01 1.72040199655676493556422101960379e-03
 	 3.70837180584396741700459187995875e-01 5.78552009613376827523723022750346e-01 1.89332124230483776240741011775981e-03
 	 3.00280676835950277592246493441053e-01 6.43432841371479824488233134616166e-01 1.99803644296510200806249457627928e-03
 	 2.34191886313592112500714392808732e-01 7.04205349519915868583552764903288e-01 2.02013157168886171161092946135796e-03
 	 1.74047112635542067238247909699567e-01 7.59511986538769945376259329350432e-01 1.95041173412694281499857318351587e-03
 	 1.21189867323676092603079723630799e-01 8.08117315007181535868596711225109e-01 1.78588204132386178801805698412863e-03
 	 7.68008370896219316747988159477245e-02 8.48935624440270819590637074725237e-01 1.53022011287922516872828104794735e-03
 	 4.18714311177650344575340568553656e-02 8.81055256109525952723515729303472e-01 1.19369869784075261290312575113148e-03
 	 1.71812181452557499738986734882928e-02 9.03759350967349495142855175799923e-01 7.92585116474581554725509224823554e-04
 	 3.27610666905009395577508257701993e-03 9.16545914222834379181392705504550e-01 3.48548313623152903641122524192042e-04
 	 9.91699955792932796860839061992010e-01 7.24731601191564833025493541640571e-03 5.88044581157942295541671273717554e-06
 	 9.72356946647436659603158659592737e-01 2.41369730307807520142127089002315e-02 3.48123098220374691761508367804367e-05
 	 9.42465542363186470353753065865021e-01 5.02371295460236760854755289074092e-02 1.02514057799329993698328467033321e-04
 	 9.02695871793453896714254369726405e-01 8.49626518586902995666676474684209e-02 2.20333121076344689301743096088160e-04
 	 8.53936753035890561136511678341776e-01 1.27537454267296568310996462969342e-01 3.93841059008994711070766880922633e-04
 	 7.97277508336594720184109519323101e-01 1.77010377674453239782437208305055e-01 6.21979941973811387145865126058197e-04
 	 7.33983858235659480939716559078079e-01 2.32276237998247314653355033442494e-01 8.96835567714729625481140384835044e-04
 	 6.65469698905513773468101135222241e-01 2.92100469239511217889315730644739e-01 1.20406463484381155010227715251858e-03
 	 5.93265533483506635192838984949049e-01 3.55146688167400192970291072924738e-01 1.52394406438168027520529967944185e-03
 	 5.18984288703573826140313940413762e-01 4.20006542072786703823084053510684e-01 1.83295425928528521973548404133680e-03
 	 4.44285286963011172289839123550337e-01 4.85231167132920138129748011124320e-01 2.10575940319816454215917644887668e-03
 	 3.70837180584396741700459187995875e-01 5.49363552951947053948345001117559e-01 2.31741128947631717244215465711932e-03
 	 3.00280676835950277592246493441053e-01 6.10971089804040690118824841192691e-01 2.44558192569358217455244286497873e-03
 	 2.34191886313592112500714392808732e-01 6.68677571578318308276323023164878e-01 2.47262620090835799624429114373925e-03
 	 1.74047112635542067238247909699567e-01 7.21193940218719964363458529987838e-01 2.38728963199638698558513461023267e-03
 	 1.21189867323676092603079723630799e-01 7.67347087206571409900845992524410e-01 2.18590649688098779060418941355692e-03
 	 7.68008370896219316747988159477245e-02 8.06106077103847962206373267690651e-01 1.87297817493091108866087868278782e-03
 	 4.18714311177650344575340568553656e-02 8.36605245165024657971741817164002e-01 1.46107843550193853415786193750137e-03
 	 1.71812181452557499738986734882928e-02 8.58163898510619249648812001396436e-01 9.70118359076313670208424611018927e-04
 	 3.27610666905009395577508257701993e-03 8.70305368427510828155391209293157e-01 4.26620574929447912964491917975351e-04
 	 9.91699955792932796860839061992010e-01 6.78965893758258932227933613035020e-03 6.81875525772850048082142360161839e-06
 	 9.72356946647436770625461122108391e-01 2.26127595919903001675521636570920e-02 4.03671130112726573809824037741834e-05
 	 9.42465542363186470353753065865021e-01 4.70647305926562703470850124176650e-02 1.18871645621459472814615554447926e-04
 	 9.02695871793453896714254369726405e-01 7.95973885511022383187906825696700e-02 2.55490429795751866973163579643824e-04
 	 8.53936753035890450114209215826122e-01 1.19483656407248672870480277197203e-01 4.56684047073234748639197766451048e-04
 	 7.97277508336594720184109519323101e-01 1.65832439325982211597576565509371e-01 7.21225759989866104134048629958897e-04
 	 7.33983858235659480939716559078079e-01 2.17608343933107933887427520858182e-01 1.03993854184164903967091397873901e-03
 	 6.65469698905513773468101135222241e-01 2.73654765210091799332303708069958e-01 1.39619041184243348162341558094113e-03
 	 5.93265533483506413148234059917741e-01 3.32719710511322375179332766492735e-01 1.76711119096184770919932827126786e-03
 	 5.18984288703573826140313940413762e-01 3.93483762476900422733194773172727e-01 2.12542839321232289798158099358716e-03
 	 4.44285286963011227800990354808164e-01 4.54589550849022361322937513250508e-01 2.44176350945952101711977633158313e-03
 	 3.70837180584396741700459187995875e-01 5.14672073240584726505630897008814e-01 2.68718748896893842512123562471515e-03
 	 3.00280676835950277592246493441053e-01 5.72389187069004767849378367827740e-01 2.83580958797237251203804397903241e-03
 	 2.34191886313592112500714392808732e-01 6.26451591563438658916140866494970e-01 2.86716916507264666519327889204760e-03
 	 1.74047112635542067238247909699567e-01 6.75651630739657171886847208952531e-01 2.76821592299035523776495892889216e-03
 	 1.21189867323676092603079723630799e-01 7.18890276112428505683737967046909e-01 2.53469922113044041425689023583345e-03
 	 7.68008370896219316747988159477245e-02 7.55201694261580902534092274436262e-01 2.17183869848307101527162821241745e-03
 	 4.18714311177650344575340568553656e-02 7.83774885864504500254668073466746e-01 1.69421444959403418722976297772220e-03
 	 1.71812181452557499738986734882928e-02 8.03972142770302156122852466069162e-01 1.12491465333201378501426503930816e-03
 	 3.27610666905009395577508257701993e-03 8.15346897176081553126891776628327e-01 4.94694004768661869074486414632474e-04
 	 9.91699955792932685838536599476356e-01 6.27013145359552048763163156763767e-03 7.59724312881737624440032716210958e-06
 	 9.72356946647436770625461122108391e-01 2.08824885717770261650549912246788e-02 4.49757705568755314579423854048912e-05
 	 9.42465542363186470353753065865021e-01 4.34634567592996692853013485091651e-02 1.32443057240580811233926494807633e-04
 	 9.02695871793453896714254369726405e-01 7.35067982304316164254842647096666e-02 2.84659419333812234702979493405905e-04
 	 8.53936753035890450114209215826122e-01 1.10341070017933695623923995299265e-01 5.08823034047923162398463503564017e-04
 	 7.97277508336594720184109519323101e-01 1.53143361603745309373891814175295e-01 8.03567108996723687523722201575538e-04
 	 7.33983858235659480939716559078079e-01 2.00957505289007742899087816113024e-01 1.15866688901087515166377084341320e-03
 	 6.65469698905513773468101135222241e-01 2.52715396538166992002061306266114e-01 1.55559154302660181470874256604020e-03
 	 5.93265533483506524170536522433395e-01 3.07260842007921808338721803011140e-01 1.96885983525730071108661434209353e-03
 	 5.18984288703573826140313940413762e-01 3.63375382808838021109210103531950e-01 2.36808561765344599212013143585409e-03
 	 4.44285286963011227800990354808164e-01 4.19805511213079796117852993120323e-01 2.72053627726448823964666701158421e-03
 	 3.70837180584396686189307956738048e-01 4.75290671354691107719503406769945e-01 2.99397997358452063951239630057444e-03
 	 3.00280676835950277592246493441053e-01 5.28591417997964940767019470513333e-01 3.15957005238438545791090916736721e-03
 	 2.34191886313592112500714392808732e-01 5.78517104397500703250045717140893e-01 3.19450990909469090955896675154690e-03
 	 1.74047112635542067238247909699567e-01 6.23952481342483933346443336631637e-01 3.08425931201807392370572991069366e-03
 	 1.21189867323676092603079723630799e-01 6.63882615220343086370746732427506e-01 2.82408233079286304784139005619181e-03
 	 7.68008370896219316747988159477245e-02 6.97415575734958159692666868068045e-01 2.41979452338442636155635412364973e-03
 	 4.18714311177650344575340568553656e-02 7.23802419175269440287934230582323e-01 1.88764057359776314497235016887089e-03
 	 1.71812181452557499738986734882928e-02 7.42454233200920743485085040447302e-01 1.25334460579827220924609143537509e-03
 	 3.27610666905009395577508257701993e-03 7.52958620244844167856967942498159e-01 5.51172536121769429846850574250539e-04
 	 9.91699955792932796860839061992010e-01 5.70091063192771849155171537404385e-03 8.19766004769952375246661047114571e-06
 	 9.72356946647436659603158659592737e-01 1.89867153505506869315411222487455e-02 4.85302459269843275814840244386517e-05
 	 9.42465542363186470353753065865021e-01 3.95177173833150541248926401749486e-02 1.42910150501567479071340915908195e-04
 	 9.02695871793453896714254369726405e-01 6.68336366872390730264896774315275e-02 3.07156307822070240385464723331665e-04
 	 8.53936753035890450114209215826122e-01 1.00323985846070606875457542628283e-01 5.49035773482376039666963407626099e-04
 	 7.97277508336594720184109519323101e-01 1.39240560558790305023535438522231e-01 8.67073736271656270689633938530960e-04
 	 7.33983858235659480939716559078079e-01 1.82713996819129392834568648140703e-01 1.25023736947527585802730776265435e-03
 	 6.65469698905513773468101135222241e-01 2.29773155736649137281801813514903e-01 1.67853133387788522497274801281719e-03
 	 5.93265533483506524170536522433395e-01 2.79366806572062476021756083355285e-01 2.12446058884013626311126898826842e-03
 	 5.18984288703573826140313940413762e-01 3.30387105687839466305888436181704e-01 2.55523754185702769645138765497450e-03
 	 4.44285286963011227800990354808164e-01 3.81694342443826772903747723830747e-01 2.93554269230290269115934975729942e-03
 	 3.70837180584396741700459187995875e-01 4.32142397912287035133260815200629e-01 3.23059688849090245396644682784881e-03
 	 3.00280676835950277592246493441053e-01 4.80604347311143653698195521428715e-01 3.40927369930982531592844608780979e-03
 	 2.34191886313592112500714392808732e-01 5.25997634279344317143056741770124e-01 3.44697488414356717142950081722574e-03
 	 1.74047112635542067238247909699567e-01 5.67308255182318421638854033517418e-01 3.32801108378001425300296567399982e-03
 	 1.21189867323675981580777261115145e-01 6.03613415041135858984944206895307e-01 3.04727208304554847764777925078761e-03
 	 7.68008370896220426971012784633785e-02 6.34102155593482263995497305586468e-01 2.61103304865254338268387712673757e-03
 	 4.18714311177650344575340568553656e-02 6.58093524422858622280330109788338e-01 2.03682249629515144118130365313846e-03
 	 1.71812181452557499738986734882928e-02 6.75052072368866884488625146332197e-01 1.35239755089312037490689721863646e-03
 	 3.27610666905009395577508257701993e-03 6.84602840518432009808691418584203e-01 5.94732194579377184719126692158397e-04
 	 9.91699955792932685838536599476356e-01 5.09533842064367747948239184552222e-03 8.60593183915056691838697811025582e-06
 	 9.72356946647436659603158659592737e-01 1.69698748943154092971852264781774e-02 5.09472198352558394512067108106379e-05
 	 9.42465542363186470353753065865021e-01 3.53199965197940057848313699651044e-02 1.50027569719041181791827077596224e-04
 	 9.02695871793453896714254369726405e-01 5.97343159348349833637215056114655e-02 3.22453753107715618622663988901422e-04
 	 8.53936753035890561136511678341776e-01 8.96671939971707410155232764736866e-02 5.76379651797171701707589441809887e-04
 	 7.97277508336594831206411981838755e-01 1.24449903486254509488162511843257e-01 9.10257003883140048371147567962680e-04
 	 7.33983858235659480939716559078079e-01 1.63305427516773710161501753646007e-01 1.31250350976465650527924555746040e-03
 	 6.65469698905513773468101135222241e-01 2.05365785230982283993128589827393e-01 1.76212799325403787938093547182916e-03
 	 5.93265533483506524170536522433395e-01 2.49691411580297950578710697300266e-01 2.23026606569890145995160857239625e-03
 	 5.18984288703573826140313940413762e-01 2.95292142253293199427588433536584e-01 2.68249719921372477629550878930331e-03
 	 4.44285286963011172289839123550337e-01 3.41149330969027220206157835491467e-01 3.08174286002074488549640207679658e-03
 	 3.70837180584396741700459187995875e-01 3.86238603871431829261950952059124e-01 3.39149177452493328852045628707401e-03
 	 3.00280676835950222081095262183226e-01 4.29552742375614304837228019096074e-01 3.57906730781091869317278586493103e-03
 	 2.34191886313592056989563161550905e-01 4.70124183336821988010711947936215e-01 3.61864614189851257347596558133773e-03
 	 1.74047112635542067238247909699567e-01 5.07046634407835150604171303712064e-01 3.49375753328362440366938734825908e-03
 	 1.21189867323676092603079723630799e-01 5.39495323369951207403971693565836e-01 3.19903676042234286908128026993836e-03
 	 7.68008370896220426971012784633785e-02 5.66745435003586317534995941969100e-01 2.74107151500861071641290678257974e-03
 	 4.18714311177650344575340568553656e-02 5.88188350224100542362748456071131e-01 2.13826329337523648663199615782560e-03
 	 1.71812181452557499738986734882928e-02 6.03345497298760968796216275222832e-01 1.41975162115760790079721509471256e-03
 	 3.27610666905009395577508257701993e-03 6.11881746863277342640685674268752e-01 6.24351912535682420507532341957813e-04
 	 9.91699955792932685838536599476356e-01 4.46760885774417654953127865269380e-03 8.81248856734418044614996767815995e-06
 	 9.72356946647436770625461122108391e-01 1.48792400295713073826719963221876e-02 5.21700381466741504852581423623548e-05
 	 9.42465542363186470353753065865021e-01 3.09686847625307223874635553784174e-02 1.53628481801452358799370268016560e-04
 	 9.02695871793453896714254369726405e-01 5.23752373150604411122799319855403e-02 3.30193181385857181808773930242751e-04
 	 8.53936753035890450114209215826122e-01 7.86204795598678257695368642998801e-02 5.90213725468425589801291231140112e-04
 	 7.97277508336594831206411981838755e-01 1.09118069352960020412801611655595e-01 9.32104691275000788591720279896435e-04
 	 7.33983858235659480939716559078079e-01 1.43186715829460409210582838568371e-01 1.34400578468232313744668005028871e-03
 	 6.65469698905513773468101135222241e-01 1.80065370625494325373949777713278e-01 1.80442200623809334558700356865302e-03
 	 5.93265533483506413148234059917741e-01 2.18930220132044828229567201560712e-01 2.28379617378507903877049578511560e-03
 	 5.18984288703573826140313940413762e-01 2.58913085146248223011866684828419e-01 2.74688160931762896665997431000505e-03
 	 4.44285286963011227800990354808164e-01 2.99120813384204653484488289905130e-01 3.15570983235999389521220237497801e-03
 	 3.70837180584396741700459187995875e-01 3.38655230606011103944297246925998e-01 3.47289323781035073890333109147832e-03
 	 3.00280676835950333103397724698880e-01 3.76633204367839924397998174754321e-01 3.66497089697519380646628661679642e-03
 	 2.34191886313592056989563161550905e-01 4.12206372241317231530643994119600e-01 3.70549968914143110568226724410579e-03
 	 1.74047112635542122749399140957394e-01 4.44580094227313649124511130139581e-01 3.57761354546975909179939989712693e-03
 	 1.21189867323676148114230954888626e-01 4.73031207433455114230724802837358e-01 3.27581898214502351476817842979017e-03
 	 7.68008370896219316747988159477245e-02 4.96924191580633056730675889411941e-01 2.80686180645725591453754077519989e-03
 	 4.18714311177650344575340568553656e-02 5.15725407528704438142597155092517e-01 2.18958518136496077879926680509470e-03
 	 1.71812181452557499738986734882928e-02 5.29015242067374713563765453727683e-01 1.45382802975519667861015182808160e-03
 	 3.27610666905009395577508257701993e-03 5.36499852709101276992953444278101e-01 6.39337400534565388626750959133460e-04
 	 9.91699955792932685838536599476356e-01 3.83243534932308123341915262471957e-03 8.81248856734413301230492143734097e-06
 	 9.72356946647436770625461122108391e-01 1.27638133229919757682946368504417e-02 5.21700381466738794347150209862463e-05
 	 9.42465542363186470353753065865021e-01 2.65657728742828003198894748493331e-02 1.53628481801451545647740903888234e-04
 	 9.02695871793453896714254369726405e-01 4.49288908914856482956778904735984e-02 3.30193181385855447085297953435656e-04
 	 8.53936753035890561136511678341776e-01 6.74427674042416547273148808017140e-02 5.90213725468422445614991023177254e-04
 	 7.97277508336594720184109519323101e-01 9.36044223104451761363620221345627e-02 9.32104691274995909681944095126482e-04
 	 7.33983858235659480939716559078079e-01 1.22829425934880137605276217982464e-01 1.34400578468231598171234164595944e-03
 	 6.65469698905513773468101135222241e-01 1.54464930468991873402373471435567e-01 1.80442200623808380460788569621400e-03
 	 5.93265533483506524170536522433395e-01 1.87804246384448592088745044748066e-01 2.28379617378506732938703294166771e-03
 	 5.18984288703573826140313940413762e-01 2.22102626150177950847819374757819e-01 2.74688160931761465519129750134653e-03
 	 4.44285286963011227800990354808164e-01 2.56593899652784063203370124028879e-01 3.15570983235997741533918059531061e-03
 	 3.70837180584396797211610419253702e-01 2.90507588809592098844092333820299e-01 3.47289323781033252430683333500383e-03
 	 3.00280676835950277592246493441053e-01 3.23086118796209742498604100546800e-01 3.66497089697517472450805087191839e-03
 	 2.34191886313592056989563161550905e-01 3.53601741445090544946339150556014e-01 3.70549968914141159004316250502598e-03
 	 1.74047112635542067238247909699567e-01 3.81372793137144228126089728903025e-01 3.57761354546974044352203314645067e-03
 	 1.21189867323676037091928492372972e-01 4.05778925242868682143893011016189e-01 3.27581898214500616753341866171922e-03
 	 7.68008370896219316747988159477245e-02 4.26274971329744900572222832124680e-01 2.80686180645724073570712597813781e-03
 	 4.18714311177650344575340568553656e-02 4.42403161353530416377566325536463e-01 2.18958518136494950309667295584859e-03
 	 1.71812181452557499738986734882928e-02 4.53803539787369425440033410268370e-01 1.45382802975518908919494442955056e-03
 	 3.27610666905009395577508257701993e-03 4.60224040621848518028969010629226e-01 6.39337400534562027600016254069715e-04
 	 9.91699955792932685838536599476356e-01 3.20470578642358203819151540869825e-03 8.60593183915052117860782637803752e-06
 	 9.72356946647436659603158659592737e-01 1.06731784582478790579518346248733e-02 5.09472198352555616244000114001267e-05
 	 9.42465542363186470353753065865021e-01 2.22144611170195238614155641698744e-02 1.50027569719040368640197713467899e-04
 	 9.02695871793453896714254369726405e-01 3.75698122717111337998119324765867e-02 3.22453753107713883899188012094328e-04
 	 8.53936753035890561136511678341776e-01 5.63960529669387672369040842568211e-02 5.76379651797168665941506482397472e-04
 	 7.97277508336594720184109519323101e-01 7.82725881771507286943645453902718e-02 9.10257003883135169461371383192727e-04
 	 7.33983858235659480939716559078079e-01 1.02710714247566892165508534162655e-01 1.31250350976464934954490715313113e-03
 	 6.65469698905513773468101135222241e-01 1.29164515863503970294345890579280e-01 1.76212799325402833840181759939014e-03
 	 5.93265533483506413148234059917741e-01 1.57043054936195580761904011524166e-01 2.23026606569888975056814572894837e-03
 	 5.18984288703573826140313940413762e-01 1.85723569043133029943248857307481e-01 2.68249719921371003114596298644301e-03
 	 4.44285286963011172289839123550337e-01 2.14565382067961718526305503473850e-01 3.08174286002072797194251130292741e-03
 	 3.70837180584396741700459187995875e-01 2.42924215544171540059892322460655e-01 3.39149177452491507392395853059952e-03
 	 3.00280676835950222081095262183226e-01 2.70166580788435528592827949978528e-01 3.57906730781089917753368112585122e-03
 	 2.34191886313592112500714392808732e-01 2.95683930349585954999724890512880e-01 3.61864614189849305783686084225792e-03
 	 1.74047112635542067238247909699567e-01 3.18906252956622893179883249104023e-01 3.49375753328360575539202059758281e-03
 	 1.21189867323676092603079723630799e-01 3.39314809306372811015251045319019e-01 3.19903676042232552184652050186742e-03
 	 7.68008370896219316747988159477245e-02 3.56453727906791750790205242083175e-01 2.74107151500859597126336097971944e-03
 	 4.18714311177650344575340568553656e-02 3.69940218658134534202019949589157e-01 2.13826329337522477724853331437771e-03
 	 1.71812181452557499738986734882928e-02 3.79473284555983392252187513804529e-01 1.41975162115760031138200769618152e-03
 	 3.27610666905009395577508257701993e-03 3.84842146467672674425841705669882e-01 6.24351912535679059480797636894067e-04
 	 9.91699955792932796860839061992010e-01 2.59913357513953842403697791496597e-03 8.19766004769954577532323908295453e-06
 	 9.72356946647436659603158659592737e-01 8.65633800201259795414898690069094e-03 4.85302459269844495542284290579005e-05
 	 9.42465542363186470353753065865021e-01 1.80167402534984755213542939600302e-02 1.42910150501567831437046973697136e-04
 	 9.02695871793453896714254369726405e-01 3.04704915193070163814681450276112e-02 3.07156307822071053537094087459991e-04
 	 8.53936753035890561136511678341776e-01 4.57392611180388736213942024733115e-02 5.49035773482377449129787638781863e-04
 	 7.97277508336594831206411981838755e-01 6.34819311046149192812038108968409e-02 8.67073736271658439093978909539828e-04
 	 7.33983858235659480939716559078079e-01 8.33021449452111539812904084101319e-02 1.25023736947527889379339072206676e-03
 	 6.65469698905513773468101135222241e-01 1.04757145357837061494521435633942e-01 1.67853133387788956178143795483493e-03
 	 5.93265533483506635192838984949049e-01 1.27367659944430944296556162953493e-01 2.12446058884014146728169691868970e-03
 	 5.18984288703573826140313940413762e-01 1.50628605608586652042646392146708e-01 2.55523754185703420166442256800110e-03
 	 4.44285286963011172289839123550337e-01 1.74020370593161999295261921361089e-01 2.93554269230291049741499165293135e-03
 	 3.70837180584396686189307956738048e-01 1.97020421503316167655128765545669e-01 3.23059688849091026022208872348074e-03
 	 3.00280676835950333103397724698880e-01 2.19114975852906013198406753872405e-01 3.40927369930983398954582597184526e-03
 	 2.34191886313592112500714392808732e-01 2.39810479407063570356228865421144e-01 3.44697488414357584504688070126122e-03
 	 1.74047112635542067238247909699567e-01 2.58644632182139400100595594267361e-01 3.32801108378002292662034555803530e-03
 	 1.21189867323676092603079723630799e-01 2.75196717635187937389673606958240e-01 3.04727208304555628390342114641953e-03
 	 7.68008370896219316747988159477245e-02 2.89097007316895582285098953434499e-01 2.61103304865255032157778103396595e-03
 	 4.18714311177650344575340568553656e-02 3.00035044459376232239833370840643e-01 2.03682249629515664535173158355974e-03
 	 1.71812181452557499738986734882928e-02 3.07766709485877365537476180179510e-01 1.35239755089312384435384917225065e-03
 	 3.27610666905009395577508257701993e-03 3.12121052812517785213231036323123e-01 5.94732194579378594181950923314162e-04
 	 9.91699955792932685838536599476356e-01 2.02991275347174249948922764019699e-03 7.59724312881737370330148539920856e-06
 	 9.72356946647436770625461122108391e-01 6.76056478078626912897597378560022e-03 4.49757705568755179054152293360858e-05
 	 9.42465542363186470353753065865021e-01 1.40710008775138881165212012547272e-02 1.32443057240580757023817870532412e-04
 	 9.02695871793453896714254369726405e-01 2.37973299761145284936247890072991e-02 2.84659419333812126282762244855462e-04
 	 8.53936753035890561136511678341776e-01 3.57221769461758681396545966890699e-02 5.08823034047922945558029006463130e-04
 	 7.97277508336594831206411981838755e-01 4.95791300596599981975742821305175e-02 8.03567108996723362263070455924208e-04
 	 7.33983858235659480939716559078079e-01 6.50586364753329426946493185823783e-02 1.15866688901087471798290184921143e-03
 	 6.65469698905513773468101135222241e-01 8.18149045563194010632912522851257e-02 1.55559154302660116418743907473754e-03
 	 5.93265533483506413148234059917741e-01 9.94736245085718340241953683289466e-02 1.96885983525729984372487635368998e-03
 	 5.18984288703573826140313940413762e-01 1.17640328487588374795080881085596e-01 2.36808561765344512475839344745054e-03
 	 4.44285286963011116778687892292510e-01 1.35909201823909253636912808360648e-01 2.72053627726448693860406002897889e-03
 	 3.70837180584396741700459187995875e-01 1.53872148060912428135793561523315e-01 2.99397997358451933846978931796912e-03
 	 3.00280676835950277592246493441053e-01 1.71127905166085114707641423592577e-01 3.15957005238438415686830218476189e-03
 	 2.34191886313592112500714392808732e-01 1.87291009288907517316147277597338e-01 3.19450990909468960851635976894158e-03
 	 1.74047112635542067238247909699567e-01 2.02000406021974332482216141215758e-01 3.08425931201807262266312292808834e-03
 	 1.21189867323676092603079723630799e-01 2.14927517455981154093080931488657e-01 2.82408233079286218047965206778827e-03
 	 7.68008370896219316747988159477245e-02 2.25783587175420352721744166046847e-01 2.41979452338442506051374714104440e-03
 	 4.18714311177650344575340568553656e-02 2.34326149706965858321439100109274e-01 1.88764057359776249445104667756823e-03
 	 1.71812181452557499738986734882928e-02 2.40364548653823950630226136127021e-01 1.25334460579827177556522244117332e-03
 	 3.27610666905009395577508257701993e-03 2.43765273086106182276466824987438e-01 5.51172536121769213006416077149652e-04
 	 9.91699955792932796860839061992010e-01 1.51038526948466932803283313546672e-03 6.81875525772848946939310929571398e-06
 	 9.72356946647436770625461122108391e-01 5.03029376057298818758489744595863e-03 4.03671130112725963946102014645589e-05
 	 9.42465542363186470353753065865021e-01 1.04697270441572662380558256245422e-02 1.18871645621459296631762525553455e-04
 	 9.02695871793453896714254369726405e-01 1.77067396554438649669549477039254e-02 2.55490429795751487502403209717272e-04
 	 8.53936753035890450114209215826122e-01 2.65795905568608353819470835333050e-02 4.56684047073234043907785650873166e-04
 	 7.97277508336594720184109519323101e-01 3.68900523374230127071626839097007e-02 7.21225759989865019931876144454463e-04
 	 7.33983858235659480939716559078079e-01 4.84077978312326406840071513215662e-02 1.03993854184164730494743800193191e-03
 	 6.65469698905513773468101135222241e-01 6.08755358843944271995951567078009e-02 1.39619041184243131321907060993226e-03
 	 5.93265533483506524170536522433395e-01 7.40147560051711561612819423316978e-02 1.76711119096184489027367980895633e-03
 	 5.18984288703573826140313940413762e-01 8.75319488195257511264912864135113e-02 2.12542839321231986221549803417474e-03
 	 4.44285286963011227800990354808164e-01 1.01125162187966466387223363199155e-01 2.44176350945951754767282437796894e-03
 	 3.70837180584396741700459187995875e-01 1.14490746175018531793909914995311e-01 2.68718748896893408831254568269742e-03
 	 3.00280676835950277592246493441053e-01 1.27330136095044954558375138731208e-01 2.83580958797236817522935403701467e-03
 	 2.34191886313592112500714392808732e-01 1.39356522122969339605447203211952e-01 2.86716916507264189470371995582809e-03
 	 1.74047112635542067238247909699567e-01 1.50301256624800871897207343863556e-01 2.76821592299035090095626898687442e-03
 	 1.21189867323676092603079723630799e-01 1.59919856563895512735484771837946e-01 2.53469922113043651112906928801749e-03
 	 7.68008370896219316747988159477245e-02 1.67997468648797165791108909616014e-01 2.17183869848306797950554525300504e-03
 	 4.18714311177650344575340568553656e-02 1.74353683017730465287797869677888e-01 1.69421444959403158514454901251156e-03
 	 1.71812181452557499738986734882928e-02 1.78846639084442093903248860442545e-01 1.12491465333201226713122355960195e-03
 	 3.27610666905009395577508257701993e-03 1.81376996154868352917333140794653e-01 4.94694004768661110132965674779371e-04
 	 9.91699955792932796860839061992010e-01 1.05272819515161032005723384941120e-03 5.88044581157950935277733267581013e-06
 	 9.72356946647436659603158659592737e-01 3.50608032178253287147740024920495e-03 3.48123098220379841721827673950429e-05
 	 9.42465542363186470353753065865021e-01 7.29732809078985356077140522756963e-03 1.02514057799331498028842790670723e-04
 	 9.02695871793453896714254369726405e-01 1.23414763478558037190779828051745e-02 2.20333121076347914803206240463851e-04
 	 8.53936753035890561136511678341776e-01 1.85257926968128983080674743177951e-02 3.93841059009000457342281054096134e-04
 	 7.97277508336594720184109519323101e-01 2.57121139889519845223020411140169e-02 6.21979941973820494444114004295443e-04
 	 7.33983858235659480939716559078079e-01 3.37399037660932599180796387372538e-02 8.96835567714742852747644707989139e-04
 	 6.65469698905513773468101135222241e-01 4.24298318549750086425831341330195e-02 1.20406463484382933101790591479130e-03
 	 5.93265533483506635192838984949049e-01 5.15877783490932828591724046418676e-02 1.52394406438170260977005288083319e-03
 	 5.18984288703573826140313940413762e-01 6.10091692236394700366020060755545e-02 1.83295425928531210794936168184677e-03
 	 4.44285286963011172289839123550337e-01 7.04835459040686895804128653253429e-02 2.10575940319819533350087503720260e-03
 	 3.70837180584396741700459187995875e-01 7.97992664636562043511958108865656e-02 2.31741128947635099954993620485766e-03
 	 3.00280676835950277592246493441053e-01 8.87482333600090322889286653662566e-02 2.44558192569361817006456938372594e-03
 	 2.34191886313592112500714392808732e-01 9.71305421080895792229625840263907e-02 2.47262620090839442543728665668823e-03
 	 1.74047112635542067238247909699567e-01 1.04758947145737968398293560312595e-01 2.38728963199642211373552314057633e-03
 	 1.21189867323676092603079723630799e-01 1.11463045469752497496074283844791e-01 2.18590649688101988298849498448817e-03
 	 7.68008370896219316747988159477245e-02 1.17093085806530106118827916361624e-01 1.87297817493093862739605981460045e-03
 	 4.18714311177650344575340568553656e-02 1.21523323717210307570724125980632e-01 1.46107843550196000136087715048916e-03
 	 1.71812181452557499738986734882928e-02 1.24654883344125000377289325115271e-01 9.70118359076327981677101419677456e-04
 	 3.27610666905009395577508257701993e-03 1.26418524903439077888833708129823e-01 4.26620574929454201337092333901069e-04
 	 9.91699955792932796860839061992010e-01 6.67668123021216211587791633519373e-04 4.80431463324824411078098340688314e-06
 	 9.72356946647436770625461122108391e-01 2.22364906572017698160870224910468e-03 2.84416003232014999739431931891076e-05
 	 9.42465542363186470353753065865021e-01 4.62815888458841667718601797787414e-03 8.37538179552911685871174896078628e-05
 	 9.02695871793453896714254369726405e-01 7.82729140003410317483201197319431e-03 1.80011800413483480116233481638233e-04
 	 8.53936753035890561136511678341776e-01 1.17495487385325392271084865569719e-02 3.21767502600741012001861474089992e-04
 	 7.97277508336594720184109519323101e-01 1.63073041692768372357136286154855e-02 5.08156597740857629390276439806939e-04
 	 7.33983858235659480939716559078079e-01 2.13987412156085299308472258417169e-02 7.32713195503813079223487392255265e-04
 	 6.65469698905513773468101135222241e-01 2.69101239286529403393899428920122e-02 9.83718842058867691535706256900085e-04
 	 5.93265533483506413148234059917741e-01 3.27183363187239506508774411486229e-02 1.24505981406097441209490650493308e-03
 	 5.18984288703573826140313940413762e-01 3.86936321172292041481455271423329e-02 1.49752063910164228202614999929665e-03
 	 4.44285286963011172289839123550337e-01 4.47025329181687247626086900709197e-02 1.72040199655675257565945468485324e-03
 	 3.70837180584396741700459187995875e-01 5.06108098022264307758177892537788e-02 1.89332124230482431830047129750483e-03
 	 3.00280676835950277592246493441053e-01 5.62864817925698979195203719427809e-02 1.99803644296508769659381776762075e-03
 	 2.34191886313592112500714392808732e-01 6.16027641664920189157328422879800e-02 2.02013157168884740014225265269943e-03
 	 1.74047112635542067238247909699567e-01 6.64409008256879873854927609500010e-02 1.95041173412692893721076536905912e-03
 	 1.21189867323676092603079723630799e-01 7.06928176691423715283235651440918e-02 1.78588204132384899443242165517631e-03
 	 7.68008370896219316747988159477245e-02 7.42635384701072487345641093270388e-02 1.53022011287921410986612169580212e-03
 	 4.18714311177650344575340568553656e-02 7.70733127727089017966477513255086e-02 1.19369869784074415612618036419690e-03
 	 1.71812181452557499738986734882928e-02 7.90594308873947548832461507117841e-02 7.92585116474575916874212300200497e-04
 	 3.27610666905009395577508257701993e-03 8.01779791081155268628322119184304e-02 3.48548313623150355766017183256622e-04
 	 9.91699955792932685838536599476356e-01 3.64229062686263066472847071963770e-04 3.61561023169796245970678168213386e-06
 	 9.72356946647436659603158659592737e-01 1.21305419118340751527540533061256e-03 2.14044559910316535436634183264815e-05
 	 9.42465542363186470353753065865021e-01 2.52477228487239802046104841792840e-03 6.30310844021843112716663171113396e-05
 	 9.02695871793453896714254369726405e-01 4.26997622277688892999947256612359e-03 1.35472498594729745926071307060568e-04
 	 8.53936753035890450114209215826122e-01 6.40966219063640596509401348157553e-03 2.42154389011063446435212398455405e-04
 	 7.97277508336594831206411981838755e-01 8.89602769357725198240416375483619e-03 3.82426284361492090611844840708500e-04
 	 7.33983858235659480939716559078079e-01 1.16735293881617963052121922373772e-02 5.51422112996072114401990837961876e-04
 	 6.65469698905513773468101135222241e-01 1.46801215714068011841675343021052e-02 7.40322851848144829201014971431505e-04
 	 5.93265533483506524170536522433395e-01 1.78486415018559441136858367826790e-02 9.37001705017643897466239621962814e-04
 	 5.18984288703573826140313940413762e-01 2.11083094610129418100541442981921e-02 1.12699757577159470622873982392775e-03
 	 4.44285286963011172289839123550337e-01 2.43863097594207989260439717327245e-02 1.29473265933430117628766264914475e-03
 	 3.70837180584396741700459187995875e-01 2.76094172845090524148758959199768e-02 1.42486747395644702297856643014029e-03
 	 3.00280676835950277592246493441053e-01 3.07056332305439827479176528868265e-02 1.50367358467646291923791590505743e-03
 	 2.34191886313592112500714392808732e-01 3.36057934737304941918978329340462e-02 1.52030184064692918191608050904051e-03
 	 1.74047112635542067238247909699567e-01 3.62451136985048050220825643918943e-02 1.46783238823082907292816301492167e-03
 	 1.21189867323676092603079723630799e-01 3.85646368764327451827966797281988e-02 1.34401134691098994231039931435134e-03
 	 7.68008370896219316747988159477245e-02 4.05125511853632325198759644990787e-02 1.15160640366623922073441299573915e-03
 	 4.18714311177650344575340568553656e-02 4.20453508283439303383488550025504e-02 8.98348579339291368819897520836548e-04
 	 1.71812181452557499738986734882928e-02 4.31288261574084286209540550771635e-02 5.96480263133699977438906270066354e-04
 	 3.27610666905009395577508257701993e-03 4.37390211868775580228430044371635e-02 2.62308975406319133498456164232948e-04
 	 9.91699955792932685838536599476356e-01 1.49517298144375559987295787323092e-04 2.34233520221410113814263995180021e-06
 	 9.72356946647436659603158659592737e-01 4.97962968223332469452913073837408e-04 1.38666525258976535317674561031964e-05
 	 9.42465542363186470353753065865021e-01 1.03642781188245658441360319557134e-03 4.08340275549087084556651450206743e-05
 	 9.02695871793453896714254369726405e-01 1.75284010359232078624103223774000e-03 8.77644386577905877971916837054778e-05
 	 8.53936753035890561136511678341776e-01 2.63118864182348977109882071090396e-03 1.56877183491343819054034125493047e-04
 	 7.97277508336594720184109519323101e-01 3.65185033602585806811191559972940e-03 2.47750861046543504901534804574226e-04
 	 7.33983858235659480939716559078079e-01 4.79202445036724933302707540860865e-03 3.57233037794401058623305900141531e-04
 	 6.65469698905513773468101135222241e-01 6.02624100778681448531415298930369e-03 4.79610402051850468266303018083363e-04
 	 5.93265533483506524170536522433395e-01 7.32692946911761566752829821780324e-03 6.07026736166401369165779300374197e-04
 	 5.18984288703573826140313940413762e-01 8.66503451352684805897297337651253e-03 7.30113570151076423861424835592970e-04
 	 4.44285286963011172289839123550337e-01 1.00106650470149771692263129807543e-02 8.38778986414914469807446728566447e-04
 	 3.70837180584396741700459187995875e-01 1.13337619059691308009973909065593e-02 9.23085462442312229200402917683732e-04
 	 3.00280676835950277592246493441053e-01 1.26047693300016527828688595036510e-02 9.74139175497656722643724513943653e-04
 	 2.34191886313592112500714392808732e-01 1.37952952055288013966105609142687e-02 9.84911616887933086608719612797813e-04
 	 1.74047112635542067238247909699567e-01 1.48787453454919393891486834036186e-02 9.50919831944506822700435844097910e-04
 	 1.21189867323676092603079723630799e-01 1.58309176844844134990353268221952e-02 8.70703667791751382068476949882552e-04
 	 7.68008370896219316747988159477245e-02 1.66305432891521443039550831599627e-02 7.46056141437523951884247530585981e-04
 	 4.18714311177650344575340568553656e-02 1.72597628783988099598900589626282e-02 5.81985713724805851614074736488647e-04
 	 1.71812181452557499738986734882928e-02 1.77045332726475379558905842714012e-02 3.86423488216500209992132486291894e-04
 	 3.27610666905009395577508257701993e-03 1.79550204563841964144899066013750e-02 1.69934121096452475825622219218758e-04
 	 9.91699955792932685838536599476356e-01 2.85164652640956112206183092894207e-05 1.01616886836070055930979650488100e-06
 	 9.72356946647436659603158659592737e-01 9.49732496666327863366063866124023e-05 6.01573190373138336683664362247725e-06
 	 9.42465542363186470353753065865021e-01 1.97671159545359520492979754635599e-04 1.77149143862324384278861960639873e-05
 	 9.02695871793453896714254369726405e-01 3.34307832926039605325740922125988e-04 3.80746061575209886456566676926627e-05
 	 8.53936753035890561136511678341776e-01 5.01829557108424140210445330012590e-04 6.80575990444605910057243591815279e-05
 	 7.97277508336594831206411981838755e-01 6.96493747207760360851125369663350e-04 1.07481077800940409759482274676401e-04
 	 7.33983858235659480939716559078079e-01 9.13951766648712915497299036360346e-04 1.54977430819233820543864843521931e-04
 	 6.65469698905513773468101135222241e-01 1.14934589177556611971908751002047e-03 2.08068067732733485205448564769881e-04
 	 5.93265533483506524170536522433395e-01 1.39741777233570729777056840248406e-03 2.63344747144571679833835453621305e-04
 	 5.18984288703573826140313940413762e-01 1.65262587529219073800845762889367e-03 3.16743171367577490155770236768262e-04
 	 4.44285286963011172289839123550337e-01 1.90926926600853974491656117606908e-03 3.63885191421065836911430402267342e-04
 	 3.70837180584396741700459187995875e-01 2.16161495502020795100861505488865e-03 4.00459639117219578716144745555994e-04
 	 3.00280676835950277592246493441053e-01 2.40402596369715393365140698733740e-03 4.22608131686524901311080570920353e-04
 	 2.34191886313592112500714392808732e-01 2.63108724822291861755729769356549e-03 4.27281510444053620051407804680821e-04
 	 1.74047112635542067238247909699567e-01 2.83772667165471670358556366409175e-03 4.12534947438523297031515157939907e-04
 	 1.21189867323676092603079723630799e-01 3.01932833090945429432849778095260e-03 3.77734988545239765058564307409483e-04
 	 7.68008370896219316747988159477245e-02 3.17183574017099179087608717964031e-03 3.23659493424128500045633405335366e-04
 	 4.18714311177650344575340568553656e-02 3.29184271450067011954843110288493e-03 2.52481268931454237974126852961376e-04
 	 1.71812181452557499738986734882928e-02 3.37667088927040559553915954893455e-03 1.67641044013590084695713988693910e-04
 	 3.27610666905009395577508257701993e-03 3.42444468643487986980744608445093e-03 7.37220545407951352058495420038753e-05
 	 ];
 
 	 case  40 

 	 % ALG. DEG.:   40
 	 % PTS CARD.:  441
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.92435490725621538565803803066956e-01 7.54087839273511698762186838962407e-03 7.67720714728615455851650981045076e-07
 	 9.74791975660365683786778845387744e-01 2.51292766220987638658979079764322e-02 4.55288533317920941941286255838506e-06
 	 9.47485544406397428573995966871735e-01 5.23504049143466432258975373770227e-02 1.34445091932752064899092570016137e-05
 	 9.11074265802615856912893832486589e-01 8.86479377900232096143540161392593e-02 2.90076237882156090595181519020684e-05
 	 8.66299758970956568226995386794442e-01 1.33282572882062244623568858514773e-01 5.21088280579889206252548750075704e-05
 	 8.14073616512697384450802928768098e-01 1.85345565326704209141439605446067e-01 8.28027413492091646403381322016912e-05
 	 7.55459054449687084087372568319552e-01 2.43777020498249508140276020640158e-01 1.20288364024100940152979533070976e-04
 	 6.91649315012962340176727593643591e-01 3.07387423752595090320482995593920e-01 1.62939654303295537729479036670455e-04
 	 6.23943389721281937987384935695445e-01 3.74881841509669966328033297031652e-01 2.08408540246300536587925611442529e-04
 	 5.53719580728293414573215613927459e-01 4.44886277314171185714997136528837e-01 2.53792605741020628213472365430903e-04
 	 4.82407444612438895958916873496491e-01 5.15975640400452073563997146266047e-01 2.95854324446300138463927797971564e-04
 	 4.11458691561905287592537661112146e-01 5.86702755599107672601633112208219e-01 3.31274404553427649806895960438169e-04
 	 3.42317632958730744263675660477020e-01 6.55627823433643119876990112970816e-01 3.56918902291879897546722499868110e-04
 	 2.76391779093783207521539679873968e-01 7.21347730555263910723340359254507e-01 3.70098501772574627836226435206868e-04
 	 2.15023185358020230140141393349040e-01 7.82524614039563082279471473157173e-01 3.68798848753354696194256545638268e-04
 	 1.59461129444065097260363472742029e-01 8.37913098830852853815542857773835e-01 3.51863031749385891597259323759772e-04
 	 1.10836673320363510164554554648930e-01 8.86385656301785784805247203621548e-01 3.19111058957624550355691717129503e-04
 	 7.01396190623257975715887369005941e-02 9.26955576434195016588546423008665e-01 2.71386227934822959768218497700332e-04
 	 3.81982882450735417023679474368691e-02 9.58797125258895377442058816086501e-01 2.10524522512073097640569740995886e-04
 	 1.56622805575734602712145715486258e-02 9.81262732380930868814061796001624e-01 1.39253190445861652936587748996544e-04
 	 2.98523728321309356203983043087646e-03 9.93900173653583185462423443823354e-01 6.11105782749504018898367707635089e-05
 	 9.92435490725621427543501340551302e-01 7.44055283257057629986430669077890e-03 1.77122966834410663102114449202196e-06
 	 9.74791975660365683786778845387744e-01 2.47949510140806558822212934956042e-02 1.05040875203509447921926267532911e-05
 	 9.47485544406397317551693504356081e-01 5.16539232282167831700192550670181e-02 3.10181985487678268877294318617288e-05
 	 9.11074265802615856912893832486589e-01 8.74685454761538333512405074543494e-02 6.69242901437327547499098190364464e-05
 	 8.66299758970956679249297849310096e-01 1.31509351237559052316683505523542e-01 1.20221716658483167576750016980469e-04
 	 8.14073616512697495473105391283752e-01 1.82879685796896424010427040229843e-01 1.91036491896388318720290122598726e-04
 	 7.55459054449686862042767643288244e-01 2.40533755607478749727334843555582e-01 2.77520607466451231688797651742107e-04
 	 6.91649315012962340176727593643591e-01 3.03297871598402490889156979392283e-01 3.75922577461973417799201424571720e-04
 	 6.23943389721281937987384935695445e-01 3.69894328280282014276281188358553e-01 4.80825100246282674879005902823792e-04
 	 5.53719580728293525595518076443113e-01 4.38967409158962429405193006459740e-01 5.85531931431287379352657040954000e-04
 	 4.82407444612438895958916873496491e-01 5.09110983200263711445643366459990e-01 6.82573684562399617299643939105636e-04
 	 4.11458691561905287592537661112146e-01 5.78897128782175141026300480007194e-01 7.64292329816157424079992033227882e-04
 	 3.42317632958730744263675660477020e-01 6.46905201847700506156968458526535e-01 8.23457458948027246764533870759806e-04
 	 2.76391779093783207521539679873968e-01 7.11750756386963057131822552037193e-01 8.53864476981077433551114985732511e-04
 	 2.15023185358020230140141393349040e-01 7.72113728707995550237797033332754e-01 8.50866011599028847570136413480668e-04
 	 1.59461129444065097260363472742029e-01 8.26765312507922733864518249902176e-01 8.11792920356883569016348545233086e-04
 	 1.10836673320363510164554554648930e-01 8.74592980056540514333107694255887e-01 7.36229939193774971656347716475466e-04
 	 7.01396190623257975715887369005941e-02 9.14623148750040915189174484112300e-01 6.26122663198002381290674378533367e-04
 	 3.81982882450735417023679474368691e-02 9.46041070371652748072222038899781e-01 4.85706941383200804102093783853888e-04
 	 1.56622805575734602712145715486258e-02 9.68207789950146113788775892317062e-01 3.21274882385414438119158875295511e-04
 	 2.98523728321309356203983043087646e-03 9.80677099831640308735813960083760e-01 1.40989903246937207416389359337927e-04
 	 9.92435490725621427543501340551302e-01 7.26230461045436134770447722530662e-03 2.73850638939522801436538858299574e-06
 	 9.74791975660365683786778845387744e-01 2.42009553748894733204988227726062e-02 1.62404183395031656339437681202398e-05
 	 9.47485544406397428573995966871735e-01 5.04164856092736007875387826970837e-02 4.79573803620525319717747547709763e-05
 	 9.11074265802615856912893832486589e-01 8.53731215106164065264948703770642e-02 1.03471954789290977727578280109810e-04
 	 8.66299758970956568226995386794442e-01 1.28358871887807146627835663821315e-01 1.85875352641935270544062963615772e-04
 	 8.14073616512697384450802928768098e-01 1.78498562567480867357971874298528e-01 2.95362404444702957018176192605097e-04
 	 7.55459054449686973065070105803898e-01 2.34771453361832721506985421910940e-01 4.29075895869690179806887897484557e-04
 	 6.91649315012962340176727593643591e-01 2.96031972464215475948634548331029e-01 5.81215637190612283147217453915800e-04
 	 6.23943389721281826965082473179791e-01 3.61033023499511662723904237282113e-01 7.43405913269873722115654857134359e-04
 	 5.53719580728293525595518076443113e-01 4.28451367943982697195082209873362e-01 9.05293629661577808898087482702977e-04
 	 4.82407444612438895958916873496491e-01 4.96914560480430256284023471380351e-01 1.05533033339187936466840866955863e-03
 	 4.11458691561905287592537661112146e-01 5.65028887225995646303999819792807e-01 1.18167590910107185228627990625228e-03
 	 3.42317632958730744263675660477020e-01 6.31407737519200318310197417304153e-01 1.27315138913212445338773992631332e-03
 	 2.76391779093783207521539679873968e-01 6.94699831573891479763460665708408e-01 1.32016382046962069476969681147693e-03
 	 2.15023185358020230140141393349040e-01 7.53616729558784004261440259142546e-01 1.31552787926229159363999965393077e-03
 	 1.59461129444065097260363472742029e-01 8.06959062840990282161612867639633e-01 1.25511679202024465859532931233389e-03
 	 1.10836673320363510164554554648930e-01 8.53640955754262686916433722217334e-01 1.13828851705668272938087870471691e-03
 	 7.01396190623257975715887369005941e-02 8.92712149145633127034216158790514e-01 9.68051147943945334943538494343329e-04
 	 3.81982882450735417023679474368691e-02 9.23377413162674964830500812240643e-01 7.50953750450108581220021175539614e-04
 	 1.56622805575734602712145715486258e-02 9.45013099840263604001222574879648e-01 4.96724582864051006532435383888924e-04
 	 2.98523728321309356203983043087646e-03 9.57183691015311199912218853569357e-01 2.17985142063994839388071933505842e-04
 	 9.92435490725621427543501340551302e-01 7.00989218009193722908056756182305e-03 3.64754954387009855908390737466718e-06
 	 9.74791975660365683786778845387744e-01 2.33598144023014035741692140391024e-02 2.16314012397087828234228806811856e-05
 	 9.47485544406397317551693504356081e-01 4.86641840541102779771343023185182e-02 6.38767619977839050870657700009758e-05
 	 9.11074265802615856912893832486589e-01 8.24058489650528053216405055536598e-02 1.37819317477793067691985151590472e-04
 	 8.66299758970956679249297849310096e-01 1.23897564279594141201101820115582e-01 2.47576401636773971853822118305288e-04
 	 8.14073616512697384450802928768098e-01 1.72294573832417585723675301778712e-01 3.93407518704593406506930808319566e-04
 	 7.55459054449686973065070105803898e-01 2.26611614811756956200383683608379e-01 5.71507006273873851241729138195069e-04
 	 6.91649315012962340176727593643591e-01 2.85742931499573304954253671894548e-01 7.74149310198604342393713384495868e-04
 	 6.23943389721281937987384935695445e-01 3.48484772249981089586867710750084e-01 9.90178409062136138940601881586190e-04
 	 5.53719580728293414573215613927459e-01 4.13559889704531724596847652719589e-01 1.20580451399634330789112368620408e-03
 	 4.82407444612438840447765642238664e-01 4.79643539968183596489126330197905e-01 1.40564568010590764356171344928725e-03
 	 4.11458691561905287592537661112146e-01 5.45390449801547494423914486105787e-01 1.57393148321109742175660795027170e-03
 	 3.42317632958730744263675660477020e-01 6.09462202303363453914641922892770e-01 1.69577211383903987858279283074125e-03
 	 2.76391779093783207521539679873968e-01 6.70554483469447015764330899401102e-01 1.75839025237812087223976398320247e-03
 	 2.15023185358020230140141393349040e-01 7.27423635152377179302618515066570e-01 1.75221541732873613110565980122146e-03
 	 1.59461129444065097260363472742029e-01 7.78911974598304412964466791891027e-01 1.67175095883131128240983720445456e-03
 	 1.10836673320363510164554554648930e-01 8.23971367399533138886624783481238e-01 1.51614171040864134827608200595250e-03
 	 7.01396190623257975715887369005941e-02 8.61684582103686369514150555914966e-01 1.28939429785506257629401627440302e-03
 	 3.81982882450735417023679474368691e-02 8.91284028280052043058390154328663e-01 1.00023173965525986363334087769772e-03
 	 1.56622805575734602712145715486258e-02 9.12167733796042434768480688944692e-01 6.61611575080151025941843645483686e-04
 	 2.98523728321309356203983043087646e-03 9.23915317584010908902314440638293e-01 2.90344988269892459106791271494785e-04
 	 9.92435490725621538565803803066956e-01 6.68869025244668569118999812417314e-03 4.47887851808876885341620735503376e-06
 	 9.74791975660365683786778845387744e-01 2.22894388212384539360577662137075e-02 2.65615085315317667115798255794701e-05
 	 9.47485544406397428573995966871735e-01 4.64343309659478661877152205761377e-02 7.84351942793329271960689474951778e-05
 	 9.11074265802615856912893832486589e-01 7.86299110680349216950801860548381e-02 1.69230321070294595841784768275318e-04
 	 8.66299758970956568226995386794442e-01 1.18220424681045405135293435705535e-01 3.04002622456539376739892421852574e-04
 	 8.14073616512697495473105391283752e-01 1.64399823411725098942781642108457e-01 4.83070747412268897396508959829475e-04
 	 7.55459054449687084087372568319552e-01 2.16227990408651649101301472910563e-01 7.01761668361436472679537601493394e-04
 	 6.91649315012962340176727593643591e-01 2.72649837048088539148693598690443e-01 9.50589066314064105346626210035765e-04
 	 6.23943389721281937987384935695445e-01 3.32516769073041729143369593657553e-01 1.21585430220592406735935497863466e-03
 	 5.53719580728293525595518076443113e-01 3.94610064178383457278442847382394e-01 1.48062469605896767158026428035100e-03
 	 4.82407444612438895958916873496491e-01 4.57665679872430675168004654551623e-01 1.72601253662226861509965125662802e-03
 	 4.11458691561905287592537661112146e-01 5.20399984999095899240728613222018e-01 1.93265309334721743089735568332799e-03
 	 3.42317632958730744263675660477020e-01 5.81535890574529812369064529775642e-01 2.08226295514250770921083066866686e-03
 	 2.76391779093783207521539679873968e-01 6.39828847875045125803694645583164e-01 2.15915266758430956714476245394962e-03
 	 2.15023185358020230140141393349040e-01 6.94092184707358339501581667718710e-01 2.15157049886451545370191773542956e-03
 	 1.59461129444065097260363472742029e-01 7.43221264772912504348312268120935e-01 2.05276703360674633858096171934449e-03
 	 1.10836673320363510164554554648930e-01 7.86215980478624287819400251464685e-01 1.86169220060070647951300237821215e-03
 	 7.01396190623257975715887369005941e-02 8.22201129051450263496292336640181e-01 1.58326579325411900822651034559385e-03
 	 3.81982882450735417023679474368691e-02 8.50444292003363355725298333709361e-01 1.22819893135687205690254053536137e-03
 	 1.56622805575734602712145715486258e-02 8.70371080309248368322982969402801e-01 8.12402363643095607771693611454111e-04
 	 2.98523728321309356203983043087646e-03 8.81580375281793116037931667960947e-01 3.56518784777627435571278891046632e-04
 	 9.92435490725621427543501340551302e-01 6.30554347301381760970695466994584e-03 5.21475619457475732498570944462024e-06
 	 9.74791975660365683786778845387744e-01 2.10126377768786072597340108814024e-02 3.09255521427184070035881768845343e-05
 	 9.47485544406397428573995966871735e-01 4.37744433506983970927350924284838e-02 9.13220605535341827235090716996524e-05
 	 9.11074265802615856912893832486589e-01 7.41257710861019658565851386811119e-02 1.97034784834435055698650951505613e-04
 	 8.66299758970956679249297849310096e-01 1.11448429975032584082761388799554e-01 3.53950113230284859992813562001857e-04
 	 8.14073616512697384450802928768098e-01 1.54982544317885551077296213406953e-01 5.62439048594900970964860498213511e-04
 	 7.55459054449686973065070105803898e-01 2.03841849771026678572738433103950e-01 8.17060787074999671578123816573225e-04
 	 6.91649315012962340176727593643591e-01 2.57031696121371444618830537365284e-01 1.10677041184220267822091443576937e-03
 	 6.23943389721281937987384935695445e-01 3.13469283785297148092752195225330e-01 1.41561860374687866100107402900221e-03
 	 5.53719580728293414573215613927459e-01 3.72005702260676307524533967807656e-01 1.72389065129380258424574012821040e-03
 	 4.82407444612438895958916873496491e-01 4.31449316925150760937412997009233e-01 2.00959560097769022665725735521391e-03
 	 4.11458691561905232081386429854319e-01 4.90590026585132787939613763228408e-01 2.25018710594479271619450244656946e-03
 	 3.42317632958730744263675660477020e-01 5.48223897465452636446059386798879e-01 2.42437779908718760782382339868946e-03
 	 2.76391779093783207521539679873968e-01 6.03177672054503566378969026118284e-01 2.51390045584950041004934639943258e-03
 	 2.15023185358020230140141393349040e-01 6.54332654042461880905534599150997e-01 2.50507254030319292600892389089040e-03
 	 1.59461129444065097260363472742029e-01 7.00647483770032386551918079931056e-01 2.39003571123593255148831460132897e-03
 	 1.10836673320363510164554554648930e-01 7.41179342588441092409823340858566e-01 2.16756737122148325849768646378379e-03
 	 7.01396190623257975715887369005941e-02 7.75103161773492255193218625208829e-01 1.84339563345723204089432467611687e-03
 	 3.81982882450735417023679474368691e-02 8.01728477805066175321258015173953e-01 1.42999144977845713162800667106467e-03
 	 1.56622805575734602712145715486258e-02 8.20513804258827361692851809493732e-01 9.45879697604033731206385482437327e-04
 	 2.98523728321309356203983043087646e-03 8.31080999641415463230487148393877e-01 4.15094656819301117186421512528227e-04
 	 9.92435490725621538565803803066956e-01 5.86861753718463489970513791149642e-03 5.83949359426590482592244607529253e-06
 	 9.74791975660365683786778845387744e-01 1.95566226904400480846035748072609e-02 3.46304902661449747034057289329922e-05
 	 9.47485544406397317551693504356081e-01 4.07412092276984022509722649374453e-02 1.02262611658110761855833281686046e-04
 	 9.11074265802615856912893832486589e-01 6.89894220878807529206966364654363e-02 2.20639915071249039478507025791032e-04
 	 8.66299758970956679249297849310096e-01 1.03725906171662482502249247318105e-01 3.96353988907143244165010020907403e-04
 	 8.14073616512697495473105391283752e-01 1.44243439353644586908842484263005e-01 6.29820282845027792049952264363810e-04
 	 7.55459054449687084087372568319552e-01 1.89717168630768318049462095586932e-01 9.14946174705947657193605415670845e-04
 	 6.91649315012962340176727593643591e-01 2.39221365442307071225158665583876e-01 1.23936354627651192615578334965676e-03
 	 6.23943389721281937987384935695445e-01 2.91748259934179188235248147975653e-01 1.58521232058819998983478782861312e-03
 	 5.53719580728293525595518076443113e-01 3.46228552314812754175932241196278e-01 1.93041592738659828314140565197476e-03
 	 4.82407444612438895958916873496491e-01 4.01553179127169368456407028133981e-01 2.25034885642071830202937121612194e-03
 	 4.11458691561905287592537661112146e-01 4.56595889935128784742346397251822e-01 2.51976366694471381676989629738728e-03
 	 3.42317632958730744263675660477020e-01 5.10236174366062611440497676085215e-01 2.71482272605163719655929632779134e-03
 	 2.76391779093783318543842142389622e-01 5.61382072680463029001884933677502e-01 2.81507036202914605674263448520378e-03
 	 2.15023185358020230140141393349040e-01 6.08992405666623159987693725270219e-01 2.80518484593598451878881938625909e-03
 	 1.59461129444065097260363472742029e-01 6.52097971924979091795648855622858e-01 2.67636639280450323516435950921277e-03
 	 1.10836673320363621186857017164584e-01 6.89821282928132495371187360433396e-01 2.42724593578431090123981306305723e-03
 	 7.01396190623257975715887369005941e-02 7.21394440904080336274262208462460e-01 2.06423782658722142907548047219279e-03
 	 3.81982882450735417023679474368691e-02 7.46174826173757077540926729852799e-01 1.60130706005465694129197284922839e-03
 	 1.56622805575734602712145715486258e-02 7.63658473180569230542857894761255e-01 1.05919782805020327824674364336488e-03
 	 2.98523728321309356203983043087646e-03 7.73493442744496717544677721889457e-01 4.64823761469825729765459332298860e-04
 	 9.92435490725621427543501340551302e-01 5.38722458909856542069727325383610e-03 6.33977380291711592246936546324321e-06
 	 9.74791975660365683786778845387744e-01 1.79524254170777310124496040089070e-02 3.75973483705965296451656509901795e-05
 	 9.47485544406397428573995966871735e-01 3.73992755108656788065601972448349e-02 1.11023638598490315154178331713553e-04
 	 9.11074265802615856912893832486589e-01 6.33303343938526330791916052476154e-02 2.39542544377499056797165000176619e-04
 	 8.66299758970956679249297849310096e-01 9.52174423897766131208442175193341e-02 4.30310367670006302647650597847928e-04
 	 8.14073616512697495473105391283752e-01 1.32411389629402936884972064035537e-01 6.83778150497091796906901084440733e-04
 	 7.55459054449686973065070105803898e-01 1.74154984431332343630671743994753e-01 9.93331304477472172911878267598240e-04
 	 6.91649315012962340176727593643591e-01 2.19598434210926646281691887452325e-01 1.34554211185191675316519255289904e-03
 	 6.23943389721281937987384935695445e-01 2.67816634801205877280949607666116e-01 1.72102038984938928746493136401341e-03
 	 5.53719580728293525595518076443113e-01 3.17827999296263596917810900777113e-01 2.09579822764032353693552934714717e-03
 	 4.82407444612438895958916873496491e-01 3.68614438872152505588530857494334e-01 2.44314040199817335968779374866244e-03
 	 4.11458691561905287592537661112146e-01 4.19142087545188002373208746575983e-01 2.73563647726660173070678538920220e-03
 	 3.42317632958730744263675660477020e-01 4.68382348547304205865771109529305e-01 2.94740660647130597177278943377132e-03
 	 2.76391779093783207521539679873968e-01 5.15332833782546795298173947230680e-01 3.05624264269860118278798744029245e-03
 	 2.15023185358020230140141393349040e-01 5.59037770240419562561839939007768e-01 3.04551021617153376899733707716678e-03
 	 1.59461129444065097260363472742029e-01 5.98607458502203093608784456591820e-01 2.90565564808069592278583215261278e-03
 	 1.10836673320363510164554554648930e-01 6.33236388966786467591418841038831e-01 2.63519258108834298487410663369701e-03
 	 7.01396190623257975715887369005941e-02 6.62219653240831762630591583729256e-01 2.24108489627231110066785113588139e-03
 	 3.81982882450735417023679474368691e-02 6.84967344670077915580463923106436e-01 1.73849399539189979069231384301020e-03
 	 1.56622805575734602712145715486258e-02 7.01016837155390426516987645300105e-01 1.14994126356663165476612586957117e-03
 	 2.98523728321309356203983043087646e-03 7.10045060503072367197319181286730e-01 5.04646072192541528950160412136938e-04
 	 9.92435490725621427543501340551302e-01 4.87162459827449826482714811959340e-03 6.70493352421323886834204908158341e-06
 	 9.74791975660365683786778845387744e-01 1.62342363519613896993831758663873e-02 3.97628889212961735498928772525318e-05
 	 9.47485544406397428573995966871735e-01 3.38198691224166486657409791405371e-02 1.17418403173411261663366955687593e-04
 	 9.11074265802615856912893832486589e-01 5.72691206292675336619879544741707e-02 2.53339769872074830996122596360465e-04
 	 8.66299758970956679249297849310096e-01 8.61043802535134683573403435730143e-02 4.55095481274045388867671713128971e-04
 	 8.14073616512697495473105391283752e-01 1.19738572643811866380580966051639e-01 7.23162558620455407122629143401582e-04
 	 7.55459054449686973065070105803898e-01 1.57486975349909269494830255098350e-01 1.05054542497666210214279924883840e-03
 	 6.91649315012962340176727593643591e-01 1.98581127656963368766085409333755e-01 1.42304294986761426487775761273724e-03
 	 6.23943389721281937987384935695445e-01 2.42184465181720987025926206115400e-01 1.82014811040200280914391761655224e-03
 	 5.53719580728293414573215613927459e-01 2.87409346646735675001593790511834e-01 2.21651248661686823757110964550066e-03
 	 4.82407444612438895958916873496491e-01 3.33335122378703219148121661419282e-01 2.58386095386872304685565993054297e-03
 	 4.11458691561905287592537661112146e-01 3.79026875543521546418901380093303e-01 2.89320428404648026174394992438010e-03
 	 3.42317632958730744263675660477020e-01 4.23554454217108022895388330653077e-01 3.11717199691318369234038776482976e-03
 	 2.76391779093783152010388448616141e-01 4.66011406770334202231964582097135e-01 3.23227679570065864686490009205500e-03
 	 2.15023185358020230140141393349040e-01 5.05533435227258687305607054440770e-01 3.22092620045002359097097155427036e-03
 	 1.59461129444065097260363472742029e-01 5.41315991438529264812018482189160e-01 3.07301625740518660409583695525271e-03
 	 1.10836673320363510164554554648930e-01 5.72630659441154654665240286703920e-01 2.78697499768324787050577384661665e-03
 	 7.01396190623257975715887369005941e-02 5.98839996148862852010097412858158e-01 2.37016740955491413481159845844104e-03
 	 3.81982882450735417023679474368691e-02 6.19410553638692018552092122263275e-01 1.83862816461733595899130655482168e-03
 	 1.56622805575734602712145715486258e-02 6.33923982787253592618981201667339e-01 1.21617583980935021169267340468423e-03
 	 2.98523728321309356203983043087646e-03 6.42088133772954927636078537034336e-01 5.33712790470442888061952668721233e-04
 	 9.92435490725621427543501340551302e-01 4.33280663508716842868828678092541e-03 6.92718970731111644093544801870088e-06
 	 9.74791975660365683786778845387744e-01 1.44386755511222240194735277896143e-02 4.10809553702292569736694016757639e-05
 	 9.47485544406397428573995966871735e-01 3.00792785600286945169035135450031e-02 1.21310606730766040424820961796115e-04
 	 9.11074265802615856912893832486589e-01 5.09349644748871288602032336712000e-02 2.61737516110024188899924046936007e-04
 	 8.66299758970956679249297849310096e-01 7.65809480074947229732984510519600e-02 4.70181057327527507621461877462821e-04
 	 8.14073616512697384450802928768098e-01 1.06495086302571928538185375145986e-01 7.47134063998972455279690141338733e-04
 	 7.55459054449687084087372568319552e-01 1.40068389501437462474342510176939e-01 1.08536906871348030889645741581262e-03
 	 6.91649315012962340176727593643591e-01 1.76617391212766400299116753558337e-01 1.47021419970622211487176755895234e-03
 	 6.23943389721281937987384935695445e-01 2.15398053870174605028964265329705e-01 1.88048266408995050878727450793804e-03
 	 5.53719580728293525595518076443113e-01 2.55620912288298751668946806603344e-01 2.28998578851989566945723808544244e-03
 	 4.82407444612438840447765642238664e-01 2.96467143724825021866564611627837e-01 2.66951118010715386305586882542684e-03
 	 4.11458691561905287592537661112146e-01 3.37105236272311370449017431383254e-01 2.98910867128200511202984479552924e-03
 	 3.42317632958730799774826891734847e-01 3.76707915918361224694166367044090e-01 3.22050050085607823813216299413398e-03
 	 2.76391779093783207521539679873968e-01 4.14468987613695993843521137023345e-01 3.33942081148157036973866951257151e-03
 	 2.15023185358020230140141393349040e-01 4.49619747627289623181923161610030e-01 3.32769396492774410106774141127062e-03
 	 1.59461129444065041749212241484202e-01 4.81444633524180487516019866234274e-01 3.17488108000217811657805988545533e-03
 	 1.10836673320363399142252092133276e-01 5.09295794581496874542381192441098e-01 2.87935807995205782575109942911240e-03
 	 7.01396190623257975715887369005941e-02 5.32606291048858926373554822930600e-01 2.44873408882895996635520319273382e-03
 	 3.81982882450735417023679474368691e-02 5.50901676126547945600009370537009e-01 1.89957529802714194556989557582938e-03
 	 1.56622805575734602712145715486258e-02 5.63809871502486292804690037883120e-01 1.25648982639187936291569336333396e-03
 	 2.98523728321309356203983043087646e-03 5.71071040101813420797327580658020e-01 5.51404385361295630053890537425332e-04
 	 9.92435490725621427543501340551302e-01 3.78225463718926020739719007224267e-03 7.00180521429935848171490289648666e-06
 	 9.74791975660365683786778845387744e-01 1.26040121698171633107810052365494e-02 4.15234546292398554309319158583946e-05
 	 9.47485544406397428573995966871735e-01 2.62572277968013238769184880538887e-02 1.22617291375870258313129923521956e-04
 	 9.11074265802615856912893832486589e-01 4.44628670986920923602347954783909e-02 2.64556794675728913866091795981106e-04
 	 8.66299758970956679249297849310096e-01 6.68501205145217158865023066027788e-02 4.75245563924154125826082584183041e-04
 	 8.14073616512697495473105391283752e-01 9.29631917436513216523863434304076e-02 7.55181741243126942314534133515735e-04
 	 7.55459054449686973065070105803898e-01 1.22270472775156568978616178355878e-01 1.09706000930457443429122399436437e-03
 	 6.91649315012962340176727593643591e-01 1.54175342493518885422787434436032e-01 1.48605045979544872145061695789536e-03
 	 6.23943389721281937987384935695445e-01 1.88028305139359114273034379039018e-01 1.90073808848168933002820146782597e-03
 	 5.53719580728293525595518076443113e-01 2.23140209635853375980119039923011e-01 2.31465213343404500531685918929270e-03
 	 4.82407444612438895958916873496491e-01 2.58796277693780663042844025767408e-01 2.69826554349700742027606814588125e-03
 	 4.11458691561905343103688892369973e-01 2.94270654219047467226033631959581e-01 3.02130554597063389135613853397899e-03
 	 3.42317632958730799774826891734847e-01 3.28841183520634794401615863534971e-01 3.25518978868858050237933277060165e-03
 	 2.76391779093783207521539679873968e-01 3.61804110453108562772683853836497e-01 3.37539103713206754125986108761026e-03
 	 2.15023185358020174628990162091213e-01 3.92488407320990051463382997098961e-01 3.36353787606428165923855289065614e-03
 	 1.59461129444065152771514703999856e-01 4.20269435277967617903271957402467e-01 3.20907898296443052851834032423994e-03
 	 1.10836673320363454653403323391103e-01 4.44581663339818466962327647706843e-01 2.91037278750504472754623286334663e-03
 	 7.01396190623257975715887369005941e-02 4.64930190468837323258810556581011e-01 2.47511037462989913482402926092618e-03
 	 3.81982882450735417023679474368691e-02 4.80900855877463451193420951312874e-01 1.92003637674930294383657258805442e-03
 	 1.56622805575734602712145715486258e-02 4.92168859721213491908997639256995e-01 1.27002397651380374496432601461038e-03
 	 2.98523728321309356203983043087646e-03 4.98507381358393675263585009815870e-01 5.57343780629458935074738157311458e-04
 	 9.92435490725621427543501340551302e-01 3.23170263929134678193566543313864e-03 6.92718970731111135873776449289885e-06
 	 9.74791975660365683786778845387744e-01 1.07693487885120869895771988922206e-02 4.10809553702292298686150895381530e-05
 	 9.47485544406397428573995966871735e-01 2.24351770335739220119108949802467e-02 1.21310606730765945557130869314477e-04
 	 9.11074265802615856912893832486589e-01 3.79907697224970003491151260277547e-02 2.61737516110023972059489549835121e-04
 	 8.66299758970956679249297849310096e-01 5.71192930215486255329793152668572e-02 4.70181057327527182360810131811490e-04
 	 8.14073616512697384450802928768098e-01 7.94312971847306037442848491991754e-02 7.47134063998971913178603898586516e-04
 	 7.55459054449686973065070105803898e-01 1.04472556048875508949436152761336e-01 1.08536906871347944153471942740907e-03
 	 6.91649315012962340176727593643591e-01 1.31733293774271204013004421540245e-01 1.47021419970622103066959507344791e-03
 	 6.23943389721281937987384935695445e-01 1.60658556408543401472499567717023e-01 1.88048266408994899090423302823183e-03
 	 5.53719580728293525595518076443113e-01 1.90659506983407667224383885695715e-01 2.28998578851989393473376210863535e-03
 	 4.82407444612438840447765642238664e-01 2.21125411662735971152216052360018e-01 2.66951118010715169465152385441797e-03
 	 4.11458691561905287592537661112146e-01 2.51436072165783230936142444988945e-01 2.98910867128200250994463083031860e-03
 	 3.42317632958730799774826891734847e-01 2.80974451122907920019855509963236e-01 3.22050050085607563604694902892334e-03
 	 2.76391779093783207521539679873968e-01 3.09139233292520687612636720587034e-01 3.33942081148156776765345554736086e-03
 	 2.15023185358020230140141393349040e-01 3.35357067014690035655632982525276e-01 3.32769396492774149898252744605998e-03
 	 1.59461129444065097260363472742029e-01 3.59094237031754248690162967250217e-01 3.17488108000217551449284592024469e-03
 	 1.10836673320363510164554554648930e-01 3.79867532098139504270761790394317e-01 2.87935807995205565734675445810353e-03
 	 7.01396190623257975715887369005941e-02 3.97254089888815165032553977653151e-01 2.44873408882895823163172721592673e-03
 	 3.81982882450735417023679474368691e-02 4.10900035628378401675320219510468e-01 1.89957529802714064452728859322406e-03
 	 1.56622805575734602712145715486258e-02 4.20527847939940024879490465536946e-01 1.25648982639187827871352087782952e-03
 	 2.98523728321309356203983043087646e-03 4.25943722614973374618330126395449e-01 5.51404385361295196373021543223558e-04
 	 9.92435490725621427543501340551302e-01 2.69288467610402128260549403648838e-03 6.70493352421323632724320731868239e-06
 	 9.74791975660365683786778845387744e-01 8.97378798767293345273188265309727e-03 3.97628889212961532211021431493236e-05
 	 9.47485544406397317551693504356081e-01 1.86945864711859990880959969672404e-02 1.17418403173411207453258331412371e-04
 	 9.11074265802615856912893832486589e-01 3.16566135681166371806938286681543e-02 2.53339769872074776786013972085243e-04
 	 8.66299758970956679249297849310096e-01 4.75958607755299634156642696325434e-02 4.55095481274045226237345840303306e-04
 	 8.14073616512697384450802928768098e-01 6.61878108434907630464039129947196e-02 7.23162558620455081861977397750252e-04
 	 7.55459054449686973065070105803898e-01 8.70539702004038407068264859844930e-02 1.05054542497666166846193025463663e-03
 	 6.91649315012962340176727593643591e-01 1.09769557330074402079489459538308e-01 1.42304294986761383119688861853547e-03
 	 6.23943389721281937987384935695445e-01 1.33872145096997213764566936333722e-01 1.82014811040200215862261412524958e-03
 	 5.53719580728293414573215613927459e-01 1.58871072624971021447493058076361e-01 2.21651248661686737020937165709711e-03
 	 4.82407444612438895958916873496491e-01 1.84257433008858106937566390115535e-01 2.58386095386872217949392194213942e-03
 	 4.11458691561905287592537661112146e-01 2.09514432894573388033165883825859e-01 2.89320428404647896070134294177478e-03
 	 3.42317632958730799774826891734847e-01 2.34127912824161510396692165159038e-01 3.11717199691318239129778078222444e-03
 	 2.76391779093783152010388448616141e-01 2.57596814135882812291100663060206e-01 3.23227679570065734582229310944967e-03
 	 2.15023185358020230140141393349040e-01 2.79443379414721304598856477241497e-01 3.22092620045002272360923356586682e-03
 	 1.59461129444065097260363472742029e-01 2.99222879117405859972222970100120e-01 3.07301625740518573673409896684916e-03
 	 1.10836673320363510164554554648930e-01 3.16532667238482168237112546194112e-01 2.78697499768324700314403585821310e-03
 	 7.01396190623257975715887369005941e-02 3.31020384788811572462918775272556e-01 2.37016740955491326744986047003749e-03
 	 3.81982882450735417023679474368691e-02 3.42391158116234661790144855331164e-01 1.83862816461733530847000306351902e-03
 	 1.56622805575734602712145715486258e-02 3.50413736655173280176711614330998e-01 1.21617583980934977801180441048245e-03
 	 2.98523728321309356203983043087646e-03 3.54926628943832311868789020081749e-01 5.33712790470442671221518171620346e-04
 	 9.92435490725621427543501340551302e-01 2.17728468527995065728841694863149e-03 6.33977380291713455719420505785067e-06
 	 9.74791975660365683786778845387744e-01 7.25559892255658173132459864973498e-03 3.75973483705966380653828995406229e-05
 	 9.47485544406397428573995966871735e-01 1.51151800827369481305950671412575e-02 1.11023638598490640414830077364883e-04
 	 9.11074265802615856912893832486589e-01 2.55953998035314961301267544513394e-02 2.39542544377499761528577115754501e-04
 	 8.66299758970956679249297849310096e-01 3.84827986392667492632213566139399e-02 4.30310367670007549480148956178027e-04
 	 8.14073616512697495473105391283752e-01 5.35149938578996231530737759385374e-02 6.83778150497093748470811558348714e-04
 	 7.55459054449686973065070105803898e-01 7.03859611189806555486825345724355e-02 9.93331304477474991837526729909769e-04
 	 6.91649315012962340176727593643591e-01 8.87522507761110135415805189040839e-02 1.34554211185192065629301350071501e-03
 	 6.23943389721282049009687398211099e-01 1.08239975477512129220514225380612e-01 1.72102038984939427479492479733381e-03
 	 5.53719580728293525595518076443113e-01 1.28452419975442932997822254037601e-01 2.09579822764032960846769526597200e-03
 	 4.82407444612438895958916873496491e-01 1.48978116515408598452552269009175e-01 2.44314040199818029858169765589082e-03
 	 4.11458691561905232081386429854319e-01 1.69399220892906654523102361054043e-01 2.73563647726660953696242728483412e-03
 	 3.42317632958730799774826891734847e-01 1.89300018493964994359401998735848e-01 2.94740660647131464539016931780679e-03
 	 2.76391779093783207521539679873968e-01 2.08275387123669997180286372895353e-01 3.05624264269861029008623631852970e-03
 	 2.15023185358020230140141393349040e-01 2.25939044401560207298018667643191e-01 3.04551021617154244261471696120225e-03
 	 1.59461129444065097260363472742029e-01 2.41931412053731698108549608150497e-01 2.90565564808070459640321203664826e-03
 	 1.10836673320363510164554554648930e-01 2.55926937712849911221724141796585e-01 2.63519258108835079112974852932894e-03
 	 7.01396190623257975715887369005941e-02 2.67640727696842328775517216854496e-01 2.24108489627231760588088604890800e-03
 	 3.81982882450735417023679474368691e-02 2.76834367084848431694865666941041e-01 1.73849399539190499486274177343148e-03
 	 1.56622805575734602712145715486258e-02 2.83320882287036113211797783151269e-01 1.14994126356663512421307782318536e-03
 	 2.98523728321309356203983043087646e-03 2.86969702213714428218338525766740e-01 5.04646072192542938412984643292702e-04
 	 9.92435490725621538565803803066956e-01 1.69589173719388031091881430256763e-03 5.83949359426590906108718234679422e-06
 	 9.74791975660365683786778845387744e-01 5.65140164919426465917062785138114e-03 3.46304902661450018084600410706031e-05
 	 9.47485544406397317551693504356081e-01 1.17732463659042246861829994486470e-02 1.02262611658110829618469062030073e-04
 	 9.11074265802615856912893832486589e-01 1.99363121095033901664095310479752e-02 2.20639915071249175003778586479086e-04
 	 8.66299758970956679249297849310096e-01 2.99743348573808798818163268151693e-02 3.96353988907143515215553142283511e-04
 	 8.14073616512697495473105391283752e-01 4.16829441336579453736277400821564e-02 6.29820282845028225730821258565584e-04
 	 7.55459054449686973065070105803898e-01 5.48237769195446811298921829802566e-02 9.14946174705948307714908906973506e-04
 	 6.91649315012962340176727593643591e-01 6.91293195447305608425381251436193e-02 1.23936354627651279351752133806031e-03
 	 6.23943389721281937987384935695445e-01 8.43083503445388737773669163289014e-02 1.58521232058820107403696031411755e-03
 	 5.53719580728293525595518076443113e-01 1.00051866956893720228549682360608e-01 1.93041592738659958418401263458009e-03
 	 4.82407444612438895958916873496491e-01 1.16039376260391624562373635853874e-01 2.25034885642072003675284719292904e-03
 	 4.11458691561905343103688892369973e-01 1.31945418502965872153964710378204e-01 2.51976366694471555149337227419437e-03
 	 3.42317632958730744263675660477020e-01 1.47446192675206533273524200922111e-01 2.71482272605163893128277230459844e-03
 	 2.76391779093783207521539679873968e-01 1.62226148225753652454272923932876e-01 2.81507036202914822514697945621265e-03
 	 2.15023185358020230140141393349040e-01 1.75984408975356498849862418865087e-01 2.80518484593598668719316435726796e-03
 	 1.59461129444065097260363472742029e-01 1.88440898630955810943987671635114e-01 2.67636639280450540356870448022164e-03
 	 1.10836673320363510164554554648930e-01 1.99342043751503883441955622402020e-01 2.42724593578431263596328903986432e-03
 	 7.01396190623257975715887369005941e-02 2.08465940033593755131846592121292e-01 2.06423782658722273011808745479811e-03
 	 3.81982882450735417023679474368691e-02 2.15626885581169269734402860194677e-01 1.60130706005465802549414533473282e-03
 	 1.56622805575734602712145715486258e-02 2.20679246261857198163625071174465e-01 1.05919782805020392876804713466754e-03
 	 2.98523728321309356203983043087646e-03 2.23521319972290077870979985164013e-01 4.64823761469826055026111077950191e-04
 	 9.92435490725621427543501340551302e-01 1.25896580136469933564047352092530e-03 5.21475619457477511267760178492736e-06
 	 9.74791975660365683786778845387744e-01 4.19538656275570895348714373085386e-03 3.09255521427185086475418474005750e-05
 	 9.47485544406397428573995966871735e-01 8.74001224290422984442017195760855e-03 9.13220605535344808791065052133717e-05
 	 9.11074265802615856912893832486589e-01 1.47999631112821772305210288322996e-02 1.97034784834435706219954442808273e-04
 	 8.66299758970956679249297849310096e-01 2.22518110540107921790919931481767e-02 3.53950113230285998405094671781512e-04
 	 8.14073616512697384450802928768098e-01 3.09438391694170089607496265671216e-02 5.62439048594902814108553723571049e-04
 	 7.55459054449686973065070105803898e-01 4.06990957792863483621914610921522e-02 8.17060787075002382083555030334310e-04
 	 6.91649315012962340176727593643591e-01 5.13189888656662152044418689911254e-02 1.10677041184220636450830088648445e-03
 	 6.23943389721281937987384935695445e-01 6.25873264934209139198628690792248e-02 1.41561860374688343149063296522172e-03
 	 5.53719580728293525595518076443113e-01 7.42747170110302223910991870070575e-02 1.72389065129380822209703705283346e-03
 	 4.82407444612438895958916873496491e-01 8.61432384624103431036701294942759e-02 2.00959560097769673187029226824052e-03
 	 4.11458691561905232081386429854319e-01 9.79512818529619244678485756594455e-02 2.25018710594480052245014434220138e-03
 	 3.42317632958730744263675660477020e-01 1.09458469575816619290264952724101e-01 2.42437779908719541407946529432138e-03
 	 2.76391779093783207521539679873968e-01 1.20430548851713226099491294007748e-01 2.51390045584950864998585728926628e-03
 	 2.15023185358020230140141393349040e-01 1.30644160599517888954324007499963e-01 2.50507254030320116594543478072410e-03
 	 1.59461129444065097260363472742029e-01 1.39891386785902516187718447326915e-01 2.39003571123594035774395649696089e-03
 	 1.10836673320363510164554554648930e-01 1.47983984091195397425622104492504e-01 2.16756737122149063107245936521394e-03
 	 7.01396190623257975715887369005941e-02 1.54757219164182058257495100406231e-01 1.84339563345723811242649059494170e-03
 	 3.81982882450735417023679474368691e-02 1.60073233949860282976374037389178e-01 1.42999144977846190211756560728418e-03
 	 1.56622805575734602712145715486258e-02 1.63823915183599178035933618957642e-01 9.45879697604036875392685690400185e-04
 	 2.98523728321309356203983043087646e-03 1.65933763075371443207473021175247e-01 4.15094656819302526649245743683991e-04
 	 9.92435490725621538565803803066956e-01 8.75819021931832121519168055101545e-04 4.47887851808878664110809969534088e-06
 	 9.74791975660365683786778845387744e-01 2.91858551839586227716338839854870e-03 2.65615085315318751317970741299135e-05
 	 9.47485544406397428573995966871735e-01 6.08012462765476074944004380995466e-03 7.84351942793332389041935370777026e-05
 	 9.11074265802615856912893832486589e-01 1.02958231293492213920259814585734e-02 1.69230321070295273468142571715589e-04
 	 8.66299758970956568226995386794442e-01 1.54798163479979850043477540566528e-02 3.04002622456540623572390780182673e-04
 	 8.14073616512697384450802928768098e-01 2.15265600755774610952641978656175e-02 4.83070747412270848960419433737457e-04
 	 7.55459054449686862042767643288244e-01 2.83129551416613778336284212855389e-02 7.01761668361439291605186063804922e-04
 	 6.91649315012962340176727593643591e-01 3.57008479389491206745788076659665e-02 9.50589066314067900054229909301284e-04
 	 6.23943389721281826965082473179791e-01 4.35398412056763883803967019048287e-02 1.21585430220592905468934841195505e-03
 	 5.53719580728293525595518076443113e-01 5.16703550933230726371903074323200e-02 1.48062469605897352627199570207495e-03
 	 4.82407444612438951470068104754318e-01 5.99268755151304843842297032097122e-02 1.72601253662227533715312066675551e-03
 	 4.11458691561905287592537661112146e-01 6.81413234389988131667337256658357e-02 1.93265309334722523715299757895991e-03
 	 3.42317632958730744263675660477020e-01 7.61464764667395543895622722629923e-02 2.08226295514251638282821055270233e-03
 	 2.76391779093783207521539679873968e-01 8.37793730311716666747656745428685e-02 2.15915266758431824076214233798510e-03
 	 2.15023185358020230140141393349040e-01 9.08846299346214303582769389322493e-02 2.15157049886452369363842862526326e-03
 	 1.59461129444065097260363472742029e-01 9.73176057830223983913242591370363e-02 2.05276703360675457851747260917818e-03
 	 1.10836673320363510164554554648930e-01 1.02947346201012202016045193886384e-01 1.86169220060071385208777527964230e-03
 	 7.01396190623257975715887369005941e-02 1.07659251886224049954421388974879e-01 1.58326579325412529659911076151957e-03
 	 3.81982882450735417023679474368691e-02 1.11357419751563213594636181369424e-01 1.22819893135687704423253396868176e-03
 	 1.56622805575734602712145715486258e-02 1.13966639133178171405802459048573e-01 8.12402363643098860378211067967413e-04
 	 2.98523728321309356203983043087646e-03 1.15434387434993790400028501608176e-01 3.56518784777628899244211746477617e-04
 	 9.92435490725621427543501340551302e-01 5.54617094286578848905122640644549e-04 3.64754954387010364128159090046921e-06
 	 9.74791975660365683786778845387744e-01 1.84820993733291263905194057315384e-03 2.16314012397088133166089818359978e-05
 	 9.47485544406397317551693504356081e-01 3.85027153949234202112705816034577e-03 6.38767619977839999547558624826138e-05
 	 9.11074265802615856912893832486589e-01 6.51988523233133776546566195975174e-03 1.37819317477793257427365336553748e-04
 	 8.66299758970956568226995386794442e-01 9.80267674944922118296375401769183e-03 2.47576401636774351324582488231840e-04
 	 8.14073616512697495473105391283752e-01 1.36318096548849743143705381953623e-02 3.93407518704594002818125675347005e-04
 	 7.55459054449686973065070105803898e-01 1.79293307385560707345462105877232e-02 5.71507006273874718603467126598616e-04
 	 6.91649315012962340176727593643591e-01 2.26077534874642993578675032040337e-02 7.74149310198605426595885870000302e-04
 	 6.23943389721281937987384935695445e-01 2.75718380287369724257473535544705e-02 9.90178409062137656823643361292397e-04
 	 5.53719580728293525595518076443113e-01 3.27205295671748053187855020951247e-02 1.20580451399634525945503416011206e-03
 	 4.82407444612438951470068104754318e-01 3.79490154193775075519567963056033e-02 1.40564568010590959512562392319523e-03
 	 4.11458691561905287592537661112146e-01 4.31508586365472179835478527820669e-02 1.57393148321109980700138741838146e-03
 	 3.42317632958730744263675660477020e-01 4.82201647379058018216824166302104e-02 1.69577211383904226382757229885101e-03
 	 2.76391779093783207521539679873968e-01 5.30537374367696656918269582092762e-02 1.75839025237812347432497794841311e-03
 	 2.15023185358020230140141393349040e-01 5.75531794896024795349376290687360e-02 1.75221541732873851635043926933122e-03
 	 1.59461129444065097260363472742029e-01 6.16268959576304897751697353669442e-02 1.67175095883131388449505116966520e-03
 	 1.10836673320363510164554554648930e-01 6.51919592801033509488206618698314e-02 1.51614171040864351668042697696137e-03
 	 7.01396190623257975715887369005941e-02 6.81757988339877218919582446687855e-02 1.28939429785506452785792674831100e-03
 	 3.81982882450735417023679474368691e-02 7.05176834748743042169394357188139e-02 1.00023173965526138151638235740393e-03
 	 1.56622805575734602712145715486258e-02 7.21699856463841049603047395066824e-02 6.61611575080152001723798882437677e-04
 	 2.98523728321309356203983043087646e-03 7.30994451327759975356457289308310e-02 2.90344988269892892787660265696559e-04
 	 9.92435490725621427543501340551302e-01 3.02204663924155597642950965564523e-04 2.73850638939516363986139725616997e-06
 	 9.74791975660365683786778845387744e-01 1.00706896474484289272233183965000e-03 1.62404183395027827750516091764865e-05
 	 9.47485544406397428573995966871735e-01 2.09796998432902614961648168900865e-03 4.79573803620514003357572230257233e-05
 	 9.11074265802615856912893832486589e-01 3.55261268676772268282348932189052e-03 1.03471954789288538272690187724834e-04
 	 8.66299758970956679249297849310096e-01 5.34136914123622963401771812641528e-03 1.85875352641930906630318709460425e-04
 	 8.14073616512697384450802928768098e-01 7.42782091982169268007396567554679e-03 2.95362404444695963914163661101497e-04
 	 7.55459054449686862042767643288244e-01 9.76949218848027767236885665624868e-03 4.29075895869680096726683782293321e-04
 	 6.91649315012962340176727593643591e-01 1.23187125228221283634866267675534e-02 5.81215637190598513779626888009489e-04
 	 6.23943389721282049009687398211099e-01 1.50235867792063992887108270224417e-02 7.43405913269856158040460591962528e-04
 	 5.53719580728293525595518076443113e-01 1.78290513277237772093997136835242e-02 9.05293629661556558535506766816070e-04
 	 4.82407444612438840447765642238664e-01 2.06779949071307922459084238653304e-02 1.05533033339185464485887600005753e-03
 	 4.11458691561905287592537661112146e-01 2.35124212120990661034625190950464e-02 1.18167590910104387987022978023788e-03
 	 3.42317632958730744263675660477020e-01 2.62746295220689374261269222188275e-02 1.27315138913209452940777932639094e-03
 	 2.76391779093783207521539679873968e-01 2.89083893323252016926971919019707e-02 1.32016382046958968658756372605012e-03
 	 2.15023185358020230140141393349040e-01 3.13600850831957655984183475084137e-02 1.31552787926226058545786656850396e-03
 	 1.59461129444065097260363472742029e-01 3.35798077149446205780236596183386e-02 1.25511679202021516829623770661328e-03
 	 1.10836673320363510164554554648930e-01 3.55223709253738029190117231337354e-02 1.13828851705665584116700106420694e-03
 	 7.01396190623257975715887369005941e-02 3.71482317920409643718926417932380e-02 9.68051147943922458277699050199772e-04
 	 3.81982882450735417023679474368691e-02 3.84242985922513824448287778068334e-02 7.50953750450090908724609661817340e-04
 	 1.56622805575734602712145715486258e-02 3.93246196021628247052603910560720e-02 4.96724582864039405569189788991480e-04
 	 2.98523728321309356203983043087646e-03 3.98310717014757065257413159997668e-02 2.17985142063989716532806939497391e-04
 	 9.92435490725621427543501340551302e-01 1.23956441807939778121383511688691e-04 1.77122966834414135937198191833586e-06
 	 9.74791975660365683786778845387744e-01 4.13073325553656861552909163037839e-04 1.05040875203511514682317568025738e-05
 	 9.47485544406397317551693504356081e-01 8.60532365385836828242105411845841e-04 3.10181985487684299751878769235702e-05
 	 9.11074265802615856912893832486589e-01 1.45718872123030973586566005906207e-03 6.69242901437340693450439577105726e-05
 	 8.66299758970956568226995386794442e-01 2.19088979148429618959426079527475e-03 1.20221716658485512163948016883808e-04
 	 8.14073616512697495473105391283752e-01 3.04669769040610827204318411531858e-03 1.91036491896392032112730885451413e-04
 	 7.55459054449686973065070105803898e-01 4.00718994283424945201943501160713e-03 2.77520607466456652699660079264277e-04
 	 6.91649315012962340176727593643591e-01 5.05281338863511342296419570629951e-03 3.75922577461980736163865701726650e-04
 	 6.23943389721281937987384935695445e-01 6.16228199843604773633387594600208e-03 4.80825100246292053227797902437146e-04
 	 5.53719580728293525595518076443113e-01 7.31301011274404499928891709714662e-03 5.85531931431298763475468138750557e-04
 	 4.82407444612438895958916873496491e-01 8.48157218729728157313729752786458e-03 6.82573684562412952986365510810174e-04
 	 4.11458691561905287592537661112146e-01 9.64417965591946035885939636500552e-03 7.64292329816172386069972333189071e-04
 	 3.42317632958730744263675660477020e-01 1.07771651935686385570534184807912e-02 8.23457458948043401376903904775872e-04
 	 2.76391779093783207521539679873968e-01 1.18574645192536243243353055731859e-02 8.53864476981094130264571262500795e-04
 	 2.15023185358020230140141393349040e-01 1.28630859339841085997591108025517e-02 8.50866011599045435863375441698508e-04
 	 1.59461129444065097260363472742029e-01 1.37735580480120578528158148401417e-02 8.11792920356899398368066833597823e-04
 	 1.10836673320363510164554554648930e-01 1.45703466230959755023377510951832e-02 7.36229939193789391545241773684438e-04
 	 7.01396190623257975715887369005941e-02 1.52372321876331762169343164714519e-02 6.26122663198014632775223464733472e-04
 	 3.81982882450735417023679474368691e-02 1.57606413832735992031075511476956e-02 4.85706941383210290871103032017686e-04
 	 1.56622805575734602712145715486258e-02 1.61299294922803149177070736186579e-02 3.21274882385420726491759291221229e-04
 	 2.98523728321309356203983043087646e-03 1.63376628851464866798437469697092e-02 1.40989903246939972131929197374234e-04
 	 9.92435490725621538565803803066956e-01 2.36308816433999577255598012470728e-05 7.67720714728633878818253762077450e-07
 	 9.74791975660365683786778845387744e-01 7.87477175355523473232466358240345e-05 4.55288533317931868666305836312880e-06
 	 9.47485544406397428573995966871735e-01 1.64050679255983711257727009069640e-04 1.34445091932755300564951081443432e-05
 	 9.11074265802615856912893832486589e-01 2.77796407360933472752151374152163e-04 2.90076237882163036265349004283465e-05
 	 8.66299758970956679249297849310096e-01 4.17668146981131638284523432957940e-04 5.21088280579901742340168113720722e-05
 	 8.14073616512697384450802928768098e-01 5.80818160598350896606234528007917e-04 8.28027413492111433093029182472833e-05
 	 7.55459054449687084087372568319552e-01 7.63925052063518794653873555944301e-04 1.20288364024103840393790931795337e-04
 	 6.91649315012962340176727593643591e-01 9.63261234442569502789410762488842e-04 1.62939654303299440857299984486417e-04
 	 6.23943389721281937987384935695445e-01 1.17476876904809568458176727290265e-03 2.08408540246305551022973356900536e-04
 	 5.53719580728293525595518076443113e-01 1.39414195753534420063601828587707e-03 2.53792605741026753955746908530955e-04
 	 4.82407444612438895958916873496491e-01 1.61691498710903047708598023746163e-03 2.95854324446307239988157578025607e-04
 	 4.11458691561905287592537661112146e-01 1.83855283898703980582922667963430e-03 3.31274404553435618692863728895759e-04
 	 3.42317632958730744263675660477020e-01 2.05454360762613585933422655216418e-03 3.56918902291888462743885135353139e-04
 	 2.76391779093783207521539679873968e-01 2.26049035095288175511996087152511e-03 3.70098501772583572504149440618448e-04
 	 2.15023185358020230140141393349040e-01 2.45220060241668758038713349378668e-03 3.68798848753363586652070926774627e-04
 	 1.59461129444065097260363472742029e-01 2.62577172508204892409366948413663e-03 3.51863031749394348374204710694357e-04
 	 1.10836673320363510164554554648930e-01 2.77767037785070503019824172952212e-03 3.19111058957632248191116364210984e-04
 	 7.01396190623257975715887369005941e-02 2.90480450347918583986484009074047e-03 2.71386227934829464981253410726936e-04
 	 3.81982882450735417023679474368691e-02 3.00458649603108085557323647662997e-03 2.10524522512078166285726110729115e-04
 	 1.56622805575734602712145715486258e-02 3.07498706149567091472363244974986e-03 1.39253190445864986858268141922679e-04
 	 2.98523728321309356203983043087646e-03 3.11458906320372097553672574576922e-03 6.11105782749518791152967822633002e-05
 	 ];
 
 	 case  41 

 	 % ALG. DEG.:   41
 	 % PTS CARD.:  441
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.92435490725621538565803803066956e-01 7.54087839273511698762186838962407e-03 7.67720714728615455851650981045076e-07
 	 9.74791975660365683786778845387744e-01 2.51292766220987638658979079764322e-02 4.55288533317920941941286255838506e-06
 	 9.47485544406397428573995966871735e-01 5.23504049143466432258975373770227e-02 1.34445091932752064899092570016137e-05
 	 9.11074265802615856912893832486589e-01 8.86479377900232096143540161392593e-02 2.90076237882156090595181519020684e-05
 	 8.66299758970956568226995386794442e-01 1.33282572882062244623568858514773e-01 5.21088280579889206252548750075704e-05
 	 8.14073616512697384450802928768098e-01 1.85345565326704209141439605446067e-01 8.28027413492091646403381322016912e-05
 	 7.55459054449687084087372568319552e-01 2.43777020498249508140276020640158e-01 1.20288364024100940152979533070976e-04
 	 6.91649315012962340176727593643591e-01 3.07387423752595090320482995593920e-01 1.62939654303295537729479036670455e-04
 	 6.23943389721281937987384935695445e-01 3.74881841509669966328033297031652e-01 2.08408540246300536587925611442529e-04
 	 5.53719580728293414573215613927459e-01 4.44886277314171185714997136528837e-01 2.53792605741020628213472365430903e-04
 	 4.82407444612438895958916873496491e-01 5.15975640400452073563997146266047e-01 2.95854324446300138463927797971564e-04
 	 4.11458691561905287592537661112146e-01 5.86702755599107672601633112208219e-01 3.31274404553427649806895960438169e-04
 	 3.42317632958730744263675660477020e-01 6.55627823433643119876990112970816e-01 3.56918902291879897546722499868110e-04
 	 2.76391779093783207521539679873968e-01 7.21347730555263910723340359254507e-01 3.70098501772574627836226435206868e-04
 	 2.15023185358020230140141393349040e-01 7.82524614039563082279471473157173e-01 3.68798848753354696194256545638268e-04
 	 1.59461129444065097260363472742029e-01 8.37913098830852853815542857773835e-01 3.51863031749385891597259323759772e-04
 	 1.10836673320363510164554554648930e-01 8.86385656301785784805247203621548e-01 3.19111058957624550355691717129503e-04
 	 7.01396190623257975715887369005941e-02 9.26955576434195016588546423008665e-01 2.71386227934822959768218497700332e-04
 	 3.81982882450735417023679474368691e-02 9.58797125258895377442058816086501e-01 2.10524522512073097640569740995886e-04
 	 1.56622805575734602712145715486258e-02 9.81262732380930868814061796001624e-01 1.39253190445861652936587748996544e-04
 	 2.98523728321309356203983043087646e-03 9.93900173653583185462423443823354e-01 6.11105782749504018898367707635089e-05
 	 9.92435490725621427543501340551302e-01 7.44055283257057629986430669077890e-03 1.77122966834410663102114449202196e-06
 	 9.74791975660365683786778845387744e-01 2.47949510140806558822212934956042e-02 1.05040875203509447921926267532911e-05
 	 9.47485544406397317551693504356081e-01 5.16539232282167831700192550670181e-02 3.10181985487678268877294318617288e-05
 	 9.11074265802615856912893832486589e-01 8.74685454761538333512405074543494e-02 6.69242901437327547499098190364464e-05
 	 8.66299758970956679249297849310096e-01 1.31509351237559052316683505523542e-01 1.20221716658483167576750016980469e-04
 	 8.14073616512697495473105391283752e-01 1.82879685796896424010427040229843e-01 1.91036491896388318720290122598726e-04
 	 7.55459054449686862042767643288244e-01 2.40533755607478749727334843555582e-01 2.77520607466451231688797651742107e-04
 	 6.91649315012962340176727593643591e-01 3.03297871598402490889156979392283e-01 3.75922577461973417799201424571720e-04
 	 6.23943389721281937987384935695445e-01 3.69894328280282014276281188358553e-01 4.80825100246282674879005902823792e-04
 	 5.53719580728293525595518076443113e-01 4.38967409158962429405193006459740e-01 5.85531931431287379352657040954000e-04
 	 4.82407444612438895958916873496491e-01 5.09110983200263711445643366459990e-01 6.82573684562399617299643939105636e-04
 	 4.11458691561905287592537661112146e-01 5.78897128782175141026300480007194e-01 7.64292329816157424079992033227882e-04
 	 3.42317632958730744263675660477020e-01 6.46905201847700506156968458526535e-01 8.23457458948027246764533870759806e-04
 	 2.76391779093783207521539679873968e-01 7.11750756386963057131822552037193e-01 8.53864476981077433551114985732511e-04
 	 2.15023185358020230140141393349040e-01 7.72113728707995550237797033332754e-01 8.50866011599028847570136413480668e-04
 	 1.59461129444065097260363472742029e-01 8.26765312507922733864518249902176e-01 8.11792920356883569016348545233086e-04
 	 1.10836673320363510164554554648930e-01 8.74592980056540514333107694255887e-01 7.36229939193774971656347716475466e-04
 	 7.01396190623257975715887369005941e-02 9.14623148750040915189174484112300e-01 6.26122663198002381290674378533367e-04
 	 3.81982882450735417023679474368691e-02 9.46041070371652748072222038899781e-01 4.85706941383200804102093783853888e-04
 	 1.56622805575734602712145715486258e-02 9.68207789950146113788775892317062e-01 3.21274882385414438119158875295511e-04
 	 2.98523728321309356203983043087646e-03 9.80677099831640308735813960083760e-01 1.40989903246937207416389359337927e-04
 	 9.92435490725621427543501340551302e-01 7.26230461045436134770447722530662e-03 2.73850638939522801436538858299574e-06
 	 9.74791975660365683786778845387744e-01 2.42009553748894733204988227726062e-02 1.62404183395031656339437681202398e-05
 	 9.47485544406397428573995966871735e-01 5.04164856092736007875387826970837e-02 4.79573803620525319717747547709763e-05
 	 9.11074265802615856912893832486589e-01 8.53731215106164065264948703770642e-02 1.03471954789290977727578280109810e-04
 	 8.66299758970956568226995386794442e-01 1.28358871887807146627835663821315e-01 1.85875352641935270544062963615772e-04
 	 8.14073616512697384450802928768098e-01 1.78498562567480867357971874298528e-01 2.95362404444702957018176192605097e-04
 	 7.55459054449686973065070105803898e-01 2.34771453361832721506985421910940e-01 4.29075895869690179806887897484557e-04
 	 6.91649315012962340176727593643591e-01 2.96031972464215475948634548331029e-01 5.81215637190612283147217453915800e-04
 	 6.23943389721281826965082473179791e-01 3.61033023499511662723904237282113e-01 7.43405913269873722115654857134359e-04
 	 5.53719580728293525595518076443113e-01 4.28451367943982697195082209873362e-01 9.05293629661577808898087482702977e-04
 	 4.82407444612438895958916873496491e-01 4.96914560480430256284023471380351e-01 1.05533033339187936466840866955863e-03
 	 4.11458691561905287592537661112146e-01 5.65028887225995646303999819792807e-01 1.18167590910107185228627990625228e-03
 	 3.42317632958730744263675660477020e-01 6.31407737519200318310197417304153e-01 1.27315138913212445338773992631332e-03
 	 2.76391779093783207521539679873968e-01 6.94699831573891479763460665708408e-01 1.32016382046962069476969681147693e-03
 	 2.15023185358020230140141393349040e-01 7.53616729558784004261440259142546e-01 1.31552787926229159363999965393077e-03
 	 1.59461129444065097260363472742029e-01 8.06959062840990282161612867639633e-01 1.25511679202024465859532931233389e-03
 	 1.10836673320363510164554554648930e-01 8.53640955754262686916433722217334e-01 1.13828851705668272938087870471691e-03
 	 7.01396190623257975715887369005941e-02 8.92712149145633127034216158790514e-01 9.68051147943945334943538494343329e-04
 	 3.81982882450735417023679474368691e-02 9.23377413162674964830500812240643e-01 7.50953750450108581220021175539614e-04
 	 1.56622805575734602712145715486258e-02 9.45013099840263604001222574879648e-01 4.96724582864051006532435383888924e-04
 	 2.98523728321309356203983043087646e-03 9.57183691015311199912218853569357e-01 2.17985142063994839388071933505842e-04
 	 9.92435490725621427543501340551302e-01 7.00989218009193722908056756182305e-03 3.64754954387009855908390737466718e-06
 	 9.74791975660365683786778845387744e-01 2.33598144023014035741692140391024e-02 2.16314012397087828234228806811856e-05
 	 9.47485544406397317551693504356081e-01 4.86641840541102779771343023185182e-02 6.38767619977839050870657700009758e-05
 	 9.11074265802615856912893832486589e-01 8.24058489650528053216405055536598e-02 1.37819317477793067691985151590472e-04
 	 8.66299758970956679249297849310096e-01 1.23897564279594141201101820115582e-01 2.47576401636773971853822118305288e-04
 	 8.14073616512697384450802928768098e-01 1.72294573832417585723675301778712e-01 3.93407518704593406506930808319566e-04
 	 7.55459054449686973065070105803898e-01 2.26611614811756956200383683608379e-01 5.71507006273873851241729138195069e-04
 	 6.91649315012962340176727593643591e-01 2.85742931499573304954253671894548e-01 7.74149310198604342393713384495868e-04
 	 6.23943389721281937987384935695445e-01 3.48484772249981089586867710750084e-01 9.90178409062136138940601881586190e-04
 	 5.53719580728293414573215613927459e-01 4.13559889704531724596847652719589e-01 1.20580451399634330789112368620408e-03
 	 4.82407444612438840447765642238664e-01 4.79643539968183596489126330197905e-01 1.40564568010590764356171344928725e-03
 	 4.11458691561905287592537661112146e-01 5.45390449801547494423914486105787e-01 1.57393148321109742175660795027170e-03
 	 3.42317632958730744263675660477020e-01 6.09462202303363453914641922892770e-01 1.69577211383903987858279283074125e-03
 	 2.76391779093783207521539679873968e-01 6.70554483469447015764330899401102e-01 1.75839025237812087223976398320247e-03
 	 2.15023185358020230140141393349040e-01 7.27423635152377179302618515066570e-01 1.75221541732873613110565980122146e-03
 	 1.59461129444065097260363472742029e-01 7.78911974598304412964466791891027e-01 1.67175095883131128240983720445456e-03
 	 1.10836673320363510164554554648930e-01 8.23971367399533138886624783481238e-01 1.51614171040864134827608200595250e-03
 	 7.01396190623257975715887369005941e-02 8.61684582103686369514150555914966e-01 1.28939429785506257629401627440302e-03
 	 3.81982882450735417023679474368691e-02 8.91284028280052043058390154328663e-01 1.00023173965525986363334087769772e-03
 	 1.56622805575734602712145715486258e-02 9.12167733796042434768480688944692e-01 6.61611575080151025941843645483686e-04
 	 2.98523728321309356203983043087646e-03 9.23915317584010908902314440638293e-01 2.90344988269892459106791271494785e-04
 	 9.92435490725621538565803803066956e-01 6.68869025244668569118999812417314e-03 4.47887851808876885341620735503376e-06
 	 9.74791975660365683786778845387744e-01 2.22894388212384539360577662137075e-02 2.65615085315317667115798255794701e-05
 	 9.47485544406397428573995966871735e-01 4.64343309659478661877152205761377e-02 7.84351942793329271960689474951778e-05
 	 9.11074265802615856912893832486589e-01 7.86299110680349216950801860548381e-02 1.69230321070294595841784768275318e-04
 	 8.66299758970956568226995386794442e-01 1.18220424681045405135293435705535e-01 3.04002622456539376739892421852574e-04
 	 8.14073616512697495473105391283752e-01 1.64399823411725098942781642108457e-01 4.83070747412268897396508959829475e-04
 	 7.55459054449687084087372568319552e-01 2.16227990408651649101301472910563e-01 7.01761668361436472679537601493394e-04
 	 6.91649315012962340176727593643591e-01 2.72649837048088539148693598690443e-01 9.50589066314064105346626210035765e-04
 	 6.23943389721281937987384935695445e-01 3.32516769073041729143369593657553e-01 1.21585430220592406735935497863466e-03
 	 5.53719580728293525595518076443113e-01 3.94610064178383457278442847382394e-01 1.48062469605896767158026428035100e-03
 	 4.82407444612438895958916873496491e-01 4.57665679872430675168004654551623e-01 1.72601253662226861509965125662802e-03
 	 4.11458691561905287592537661112146e-01 5.20399984999095899240728613222018e-01 1.93265309334721743089735568332799e-03
 	 3.42317632958730744263675660477020e-01 5.81535890574529812369064529775642e-01 2.08226295514250770921083066866686e-03
 	 2.76391779093783207521539679873968e-01 6.39828847875045125803694645583164e-01 2.15915266758430956714476245394962e-03
 	 2.15023185358020230140141393349040e-01 6.94092184707358339501581667718710e-01 2.15157049886451545370191773542956e-03
 	 1.59461129444065097260363472742029e-01 7.43221264772912504348312268120935e-01 2.05276703360674633858096171934449e-03
 	 1.10836673320363510164554554648930e-01 7.86215980478624287819400251464685e-01 1.86169220060070647951300237821215e-03
 	 7.01396190623257975715887369005941e-02 8.22201129051450263496292336640181e-01 1.58326579325411900822651034559385e-03
 	 3.81982882450735417023679474368691e-02 8.50444292003363355725298333709361e-01 1.22819893135687205690254053536137e-03
 	 1.56622805575734602712145715486258e-02 8.70371080309248368322982969402801e-01 8.12402363643095607771693611454111e-04
 	 2.98523728321309356203983043087646e-03 8.81580375281793116037931667960947e-01 3.56518784777627435571278891046632e-04
 	 9.92435490725621427543501340551302e-01 6.30554347301381760970695466994584e-03 5.21475619457475732498570944462024e-06
 	 9.74791975660365683786778845387744e-01 2.10126377768786072597340108814024e-02 3.09255521427184070035881768845343e-05
 	 9.47485544406397428573995966871735e-01 4.37744433506983970927350924284838e-02 9.13220605535341827235090716996524e-05
 	 9.11074265802615856912893832486589e-01 7.41257710861019658565851386811119e-02 1.97034784834435055698650951505613e-04
 	 8.66299758970956679249297849310096e-01 1.11448429975032584082761388799554e-01 3.53950113230284859992813562001857e-04
 	 8.14073616512697384450802928768098e-01 1.54982544317885551077296213406953e-01 5.62439048594900970964860498213511e-04
 	 7.55459054449686973065070105803898e-01 2.03841849771026678572738433103950e-01 8.17060787074999671578123816573225e-04
 	 6.91649315012962340176727593643591e-01 2.57031696121371444618830537365284e-01 1.10677041184220267822091443576937e-03
 	 6.23943389721281937987384935695445e-01 3.13469283785297148092752195225330e-01 1.41561860374687866100107402900221e-03
 	 5.53719580728293414573215613927459e-01 3.72005702260676307524533967807656e-01 1.72389065129380258424574012821040e-03
 	 4.82407444612438895958916873496491e-01 4.31449316925150760937412997009233e-01 2.00959560097769022665725735521391e-03
 	 4.11458691561905232081386429854319e-01 4.90590026585132787939613763228408e-01 2.25018710594479271619450244656946e-03
 	 3.42317632958730744263675660477020e-01 5.48223897465452636446059386798879e-01 2.42437779908718760782382339868946e-03
 	 2.76391779093783207521539679873968e-01 6.03177672054503566378969026118284e-01 2.51390045584950041004934639943258e-03
 	 2.15023185358020230140141393349040e-01 6.54332654042461880905534599150997e-01 2.50507254030319292600892389089040e-03
 	 1.59461129444065097260363472742029e-01 7.00647483770032386551918079931056e-01 2.39003571123593255148831460132897e-03
 	 1.10836673320363510164554554648930e-01 7.41179342588441092409823340858566e-01 2.16756737122148325849768646378379e-03
 	 7.01396190623257975715887369005941e-02 7.75103161773492255193218625208829e-01 1.84339563345723204089432467611687e-03
 	 3.81982882450735417023679474368691e-02 8.01728477805066175321258015173953e-01 1.42999144977845713162800667106467e-03
 	 1.56622805575734602712145715486258e-02 8.20513804258827361692851809493732e-01 9.45879697604033731206385482437327e-04
 	 2.98523728321309356203983043087646e-03 8.31080999641415463230487148393877e-01 4.15094656819301117186421512528227e-04
 	 9.92435490725621538565803803066956e-01 5.86861753718463489970513791149642e-03 5.83949359426590482592244607529253e-06
 	 9.74791975660365683786778845387744e-01 1.95566226904400480846035748072609e-02 3.46304902661449747034057289329922e-05
 	 9.47485544406397317551693504356081e-01 4.07412092276984022509722649374453e-02 1.02262611658110761855833281686046e-04
 	 9.11074265802615856912893832486589e-01 6.89894220878807529206966364654363e-02 2.20639915071249039478507025791032e-04
 	 8.66299758970956679249297849310096e-01 1.03725906171662482502249247318105e-01 3.96353988907143244165010020907403e-04
 	 8.14073616512697495473105391283752e-01 1.44243439353644586908842484263005e-01 6.29820282845027792049952264363810e-04
 	 7.55459054449687084087372568319552e-01 1.89717168630768318049462095586932e-01 9.14946174705947657193605415670845e-04
 	 6.91649315012962340176727593643591e-01 2.39221365442307071225158665583876e-01 1.23936354627651192615578334965676e-03
 	 6.23943389721281937987384935695445e-01 2.91748259934179188235248147975653e-01 1.58521232058819998983478782861312e-03
 	 5.53719580728293525595518076443113e-01 3.46228552314812754175932241196278e-01 1.93041592738659828314140565197476e-03
 	 4.82407444612438895958916873496491e-01 4.01553179127169368456407028133981e-01 2.25034885642071830202937121612194e-03
 	 4.11458691561905287592537661112146e-01 4.56595889935128784742346397251822e-01 2.51976366694471381676989629738728e-03
 	 3.42317632958730744263675660477020e-01 5.10236174366062611440497676085215e-01 2.71482272605163719655929632779134e-03
 	 2.76391779093783318543842142389622e-01 5.61382072680463029001884933677502e-01 2.81507036202914605674263448520378e-03
 	 2.15023185358020230140141393349040e-01 6.08992405666623159987693725270219e-01 2.80518484593598451878881938625909e-03
 	 1.59461129444065097260363472742029e-01 6.52097971924979091795648855622858e-01 2.67636639280450323516435950921277e-03
 	 1.10836673320363621186857017164584e-01 6.89821282928132495371187360433396e-01 2.42724593578431090123981306305723e-03
 	 7.01396190623257975715887369005941e-02 7.21394440904080336274262208462460e-01 2.06423782658722142907548047219279e-03
 	 3.81982882450735417023679474368691e-02 7.46174826173757077540926729852799e-01 1.60130706005465694129197284922839e-03
 	 1.56622805575734602712145715486258e-02 7.63658473180569230542857894761255e-01 1.05919782805020327824674364336488e-03
 	 2.98523728321309356203983043087646e-03 7.73493442744496717544677721889457e-01 4.64823761469825729765459332298860e-04
 	 9.92435490725621427543501340551302e-01 5.38722458909856542069727325383610e-03 6.33977380291711592246936546324321e-06
 	 9.74791975660365683786778845387744e-01 1.79524254170777310124496040089070e-02 3.75973483705965296451656509901795e-05
 	 9.47485544406397428573995966871735e-01 3.73992755108656788065601972448349e-02 1.11023638598490315154178331713553e-04
 	 9.11074265802615856912893832486589e-01 6.33303343938526330791916052476154e-02 2.39542544377499056797165000176619e-04
 	 8.66299758970956679249297849310096e-01 9.52174423897766131208442175193341e-02 4.30310367670006302647650597847928e-04
 	 8.14073616512697495473105391283752e-01 1.32411389629402936884972064035537e-01 6.83778150497091796906901084440733e-04
 	 7.55459054449686973065070105803898e-01 1.74154984431332343630671743994753e-01 9.93331304477472172911878267598240e-04
 	 6.91649315012962340176727593643591e-01 2.19598434210926646281691887452325e-01 1.34554211185191675316519255289904e-03
 	 6.23943389721281937987384935695445e-01 2.67816634801205877280949607666116e-01 1.72102038984938928746493136401341e-03
 	 5.53719580728293525595518076443113e-01 3.17827999296263596917810900777113e-01 2.09579822764032353693552934714717e-03
 	 4.82407444612438895958916873496491e-01 3.68614438872152505588530857494334e-01 2.44314040199817335968779374866244e-03
 	 4.11458691561905287592537661112146e-01 4.19142087545188002373208746575983e-01 2.73563647726660173070678538920220e-03
 	 3.42317632958730744263675660477020e-01 4.68382348547304205865771109529305e-01 2.94740660647130597177278943377132e-03
 	 2.76391779093783207521539679873968e-01 5.15332833782546795298173947230680e-01 3.05624264269860118278798744029245e-03
 	 2.15023185358020230140141393349040e-01 5.59037770240419562561839939007768e-01 3.04551021617153376899733707716678e-03
 	 1.59461129444065097260363472742029e-01 5.98607458502203093608784456591820e-01 2.90565564808069592278583215261278e-03
 	 1.10836673320363510164554554648930e-01 6.33236388966786467591418841038831e-01 2.63519258108834298487410663369701e-03
 	 7.01396190623257975715887369005941e-02 6.62219653240831762630591583729256e-01 2.24108489627231110066785113588139e-03
 	 3.81982882450735417023679474368691e-02 6.84967344670077915580463923106436e-01 1.73849399539189979069231384301020e-03
 	 1.56622805575734602712145715486258e-02 7.01016837155390426516987645300105e-01 1.14994126356663165476612586957117e-03
 	 2.98523728321309356203983043087646e-03 7.10045060503072367197319181286730e-01 5.04646072192541528950160412136938e-04
 	 9.92435490725621427543501340551302e-01 4.87162459827449826482714811959340e-03 6.70493352421323886834204908158341e-06
 	 9.74791975660365683786778845387744e-01 1.62342363519613896993831758663873e-02 3.97628889212961735498928772525318e-05
 	 9.47485544406397428573995966871735e-01 3.38198691224166486657409791405371e-02 1.17418403173411261663366955687593e-04
 	 9.11074265802615856912893832486589e-01 5.72691206292675336619879544741707e-02 2.53339769872074830996122596360465e-04
 	 8.66299758970956679249297849310096e-01 8.61043802535134683573403435730143e-02 4.55095481274045388867671713128971e-04
 	 8.14073616512697495473105391283752e-01 1.19738572643811866380580966051639e-01 7.23162558620455407122629143401582e-04
 	 7.55459054449686973065070105803898e-01 1.57486975349909269494830255098350e-01 1.05054542497666210214279924883840e-03
 	 6.91649315012962340176727593643591e-01 1.98581127656963368766085409333755e-01 1.42304294986761426487775761273724e-03
 	 6.23943389721281937987384935695445e-01 2.42184465181720987025926206115400e-01 1.82014811040200280914391761655224e-03
 	 5.53719580728293414573215613927459e-01 2.87409346646735675001593790511834e-01 2.21651248661686823757110964550066e-03
 	 4.82407444612438895958916873496491e-01 3.33335122378703219148121661419282e-01 2.58386095386872304685565993054297e-03
 	 4.11458691561905287592537661112146e-01 3.79026875543521546418901380093303e-01 2.89320428404648026174394992438010e-03
 	 3.42317632958730744263675660477020e-01 4.23554454217108022895388330653077e-01 3.11717199691318369234038776482976e-03
 	 2.76391779093783152010388448616141e-01 4.66011406770334202231964582097135e-01 3.23227679570065864686490009205500e-03
 	 2.15023185358020230140141393349040e-01 5.05533435227258687305607054440770e-01 3.22092620045002359097097155427036e-03
 	 1.59461129444065097260363472742029e-01 5.41315991438529264812018482189160e-01 3.07301625740518660409583695525271e-03
 	 1.10836673320363510164554554648930e-01 5.72630659441154654665240286703920e-01 2.78697499768324787050577384661665e-03
 	 7.01396190623257975715887369005941e-02 5.98839996148862852010097412858158e-01 2.37016740955491413481159845844104e-03
 	 3.81982882450735417023679474368691e-02 6.19410553638692018552092122263275e-01 1.83862816461733595899130655482168e-03
 	 1.56622805575734602712145715486258e-02 6.33923982787253592618981201667339e-01 1.21617583980935021169267340468423e-03
 	 2.98523728321309356203983043087646e-03 6.42088133772954927636078537034336e-01 5.33712790470442888061952668721233e-04
 	 9.92435490725621427543501340551302e-01 4.33280663508716842868828678092541e-03 6.92718970731111644093544801870088e-06
 	 9.74791975660365683786778845387744e-01 1.44386755511222240194735277896143e-02 4.10809553702292569736694016757639e-05
 	 9.47485544406397428573995966871735e-01 3.00792785600286945169035135450031e-02 1.21310606730766040424820961796115e-04
 	 9.11074265802615856912893832486589e-01 5.09349644748871288602032336712000e-02 2.61737516110024188899924046936007e-04
 	 8.66299758970956679249297849310096e-01 7.65809480074947229732984510519600e-02 4.70181057327527507621461877462821e-04
 	 8.14073616512697384450802928768098e-01 1.06495086302571928538185375145986e-01 7.47134063998972455279690141338733e-04
 	 7.55459054449687084087372568319552e-01 1.40068389501437462474342510176939e-01 1.08536906871348030889645741581262e-03
 	 6.91649315012962340176727593643591e-01 1.76617391212766400299116753558337e-01 1.47021419970622211487176755895234e-03
 	 6.23943389721281937987384935695445e-01 2.15398053870174605028964265329705e-01 1.88048266408995050878727450793804e-03
 	 5.53719580728293525595518076443113e-01 2.55620912288298751668946806603344e-01 2.28998578851989566945723808544244e-03
 	 4.82407444612438840447765642238664e-01 2.96467143724825021866564611627837e-01 2.66951118010715386305586882542684e-03
 	 4.11458691561905287592537661112146e-01 3.37105236272311370449017431383254e-01 2.98910867128200511202984479552924e-03
 	 3.42317632958730799774826891734847e-01 3.76707915918361224694166367044090e-01 3.22050050085607823813216299413398e-03
 	 2.76391779093783207521539679873968e-01 4.14468987613695993843521137023345e-01 3.33942081148157036973866951257151e-03
 	 2.15023185358020230140141393349040e-01 4.49619747627289623181923161610030e-01 3.32769396492774410106774141127062e-03
 	 1.59461129444065041749212241484202e-01 4.81444633524180487516019866234274e-01 3.17488108000217811657805988545533e-03
 	 1.10836673320363399142252092133276e-01 5.09295794581496874542381192441098e-01 2.87935807995205782575109942911240e-03
 	 7.01396190623257975715887369005941e-02 5.32606291048858926373554822930600e-01 2.44873408882895996635520319273382e-03
 	 3.81982882450735417023679474368691e-02 5.50901676126547945600009370537009e-01 1.89957529802714194556989557582938e-03
 	 1.56622805575734602712145715486258e-02 5.63809871502486292804690037883120e-01 1.25648982639187936291569336333396e-03
 	 2.98523728321309356203983043087646e-03 5.71071040101813420797327580658020e-01 5.51404385361295630053890537425332e-04
 	 9.92435490725621427543501340551302e-01 3.78225463718926020739719007224267e-03 7.00180521429935848171490289648666e-06
 	 9.74791975660365683786778845387744e-01 1.26040121698171633107810052365494e-02 4.15234546292398554309319158583946e-05
 	 9.47485544406397428573995966871735e-01 2.62572277968013238769184880538887e-02 1.22617291375870258313129923521956e-04
 	 9.11074265802615856912893832486589e-01 4.44628670986920923602347954783909e-02 2.64556794675728913866091795981106e-04
 	 8.66299758970956679249297849310096e-01 6.68501205145217158865023066027788e-02 4.75245563924154125826082584183041e-04
 	 8.14073616512697495473105391283752e-01 9.29631917436513216523863434304076e-02 7.55181741243126942314534133515735e-04
 	 7.55459054449686973065070105803898e-01 1.22270472775156568978616178355878e-01 1.09706000930457443429122399436437e-03
 	 6.91649315012962340176727593643591e-01 1.54175342493518885422787434436032e-01 1.48605045979544872145061695789536e-03
 	 6.23943389721281937987384935695445e-01 1.88028305139359114273034379039018e-01 1.90073808848168933002820146782597e-03
 	 5.53719580728293525595518076443113e-01 2.23140209635853375980119039923011e-01 2.31465213343404500531685918929270e-03
 	 4.82407444612438895958916873496491e-01 2.58796277693780663042844025767408e-01 2.69826554349700742027606814588125e-03
 	 4.11458691561905343103688892369973e-01 2.94270654219047467226033631959581e-01 3.02130554597063389135613853397899e-03
 	 3.42317632958730799774826891734847e-01 3.28841183520634794401615863534971e-01 3.25518978868858050237933277060165e-03
 	 2.76391779093783207521539679873968e-01 3.61804110453108562772683853836497e-01 3.37539103713206754125986108761026e-03
 	 2.15023185358020174628990162091213e-01 3.92488407320990051463382997098961e-01 3.36353787606428165923855289065614e-03
 	 1.59461129444065152771514703999856e-01 4.20269435277967617903271957402467e-01 3.20907898296443052851834032423994e-03
 	 1.10836673320363454653403323391103e-01 4.44581663339818466962327647706843e-01 2.91037278750504472754623286334663e-03
 	 7.01396190623257975715887369005941e-02 4.64930190468837323258810556581011e-01 2.47511037462989913482402926092618e-03
 	 3.81982882450735417023679474368691e-02 4.80900855877463451193420951312874e-01 1.92003637674930294383657258805442e-03
 	 1.56622805575734602712145715486258e-02 4.92168859721213491908997639256995e-01 1.27002397651380374496432601461038e-03
 	 2.98523728321309356203983043087646e-03 4.98507381358393675263585009815870e-01 5.57343780629458935074738157311458e-04
 	 9.92435490725621427543501340551302e-01 3.23170263929134678193566543313864e-03 6.92718970731111135873776449289885e-06
 	 9.74791975660365683786778845387744e-01 1.07693487885120869895771988922206e-02 4.10809553702292298686150895381530e-05
 	 9.47485544406397428573995966871735e-01 2.24351770335739220119108949802467e-02 1.21310606730765945557130869314477e-04
 	 9.11074265802615856912893832486589e-01 3.79907697224970003491151260277547e-02 2.61737516110023972059489549835121e-04
 	 8.66299758970956679249297849310096e-01 5.71192930215486255329793152668572e-02 4.70181057327527182360810131811490e-04
 	 8.14073616512697384450802928768098e-01 7.94312971847306037442848491991754e-02 7.47134063998971913178603898586516e-04
 	 7.55459054449686973065070105803898e-01 1.04472556048875508949436152761336e-01 1.08536906871347944153471942740907e-03
 	 6.91649315012962340176727593643591e-01 1.31733293774271204013004421540245e-01 1.47021419970622103066959507344791e-03
 	 6.23943389721281937987384935695445e-01 1.60658556408543401472499567717023e-01 1.88048266408994899090423302823183e-03
 	 5.53719580728293525595518076443113e-01 1.90659506983407667224383885695715e-01 2.28998578851989393473376210863535e-03
 	 4.82407444612438840447765642238664e-01 2.21125411662735971152216052360018e-01 2.66951118010715169465152385441797e-03
 	 4.11458691561905287592537661112146e-01 2.51436072165783230936142444988945e-01 2.98910867128200250994463083031860e-03
 	 3.42317632958730799774826891734847e-01 2.80974451122907920019855509963236e-01 3.22050050085607563604694902892334e-03
 	 2.76391779093783207521539679873968e-01 3.09139233292520687612636720587034e-01 3.33942081148156776765345554736086e-03
 	 2.15023185358020230140141393349040e-01 3.35357067014690035655632982525276e-01 3.32769396492774149898252744605998e-03
 	 1.59461129444065097260363472742029e-01 3.59094237031754248690162967250217e-01 3.17488108000217551449284592024469e-03
 	 1.10836673320363510164554554648930e-01 3.79867532098139504270761790394317e-01 2.87935807995205565734675445810353e-03
 	 7.01396190623257975715887369005941e-02 3.97254089888815165032553977653151e-01 2.44873408882895823163172721592673e-03
 	 3.81982882450735417023679474368691e-02 4.10900035628378401675320219510468e-01 1.89957529802714064452728859322406e-03
 	 1.56622805575734602712145715486258e-02 4.20527847939940024879490465536946e-01 1.25648982639187827871352087782952e-03
 	 2.98523728321309356203983043087646e-03 4.25943722614973374618330126395449e-01 5.51404385361295196373021543223558e-04
 	 9.92435490725621427543501340551302e-01 2.69288467610402128260549403648838e-03 6.70493352421323632724320731868239e-06
 	 9.74791975660365683786778845387744e-01 8.97378798767293345273188265309727e-03 3.97628889212961532211021431493236e-05
 	 9.47485544406397317551693504356081e-01 1.86945864711859990880959969672404e-02 1.17418403173411207453258331412371e-04
 	 9.11074265802615856912893832486589e-01 3.16566135681166371806938286681543e-02 2.53339769872074776786013972085243e-04
 	 8.66299758970956679249297849310096e-01 4.75958607755299634156642696325434e-02 4.55095481274045226237345840303306e-04
 	 8.14073616512697384450802928768098e-01 6.61878108434907630464039129947196e-02 7.23162558620455081861977397750252e-04
 	 7.55459054449686973065070105803898e-01 8.70539702004038407068264859844930e-02 1.05054542497666166846193025463663e-03
 	 6.91649315012962340176727593643591e-01 1.09769557330074402079489459538308e-01 1.42304294986761383119688861853547e-03
 	 6.23943389721281937987384935695445e-01 1.33872145096997213764566936333722e-01 1.82014811040200215862261412524958e-03
 	 5.53719580728293414573215613927459e-01 1.58871072624971021447493058076361e-01 2.21651248661686737020937165709711e-03
 	 4.82407444612438895958916873496491e-01 1.84257433008858106937566390115535e-01 2.58386095386872217949392194213942e-03
 	 4.11458691561905287592537661112146e-01 2.09514432894573388033165883825859e-01 2.89320428404647896070134294177478e-03
 	 3.42317632958730799774826891734847e-01 2.34127912824161510396692165159038e-01 3.11717199691318239129778078222444e-03
 	 2.76391779093783152010388448616141e-01 2.57596814135882812291100663060206e-01 3.23227679570065734582229310944967e-03
 	 2.15023185358020230140141393349040e-01 2.79443379414721304598856477241497e-01 3.22092620045002272360923356586682e-03
 	 1.59461129444065097260363472742029e-01 2.99222879117405859972222970100120e-01 3.07301625740518573673409896684916e-03
 	 1.10836673320363510164554554648930e-01 3.16532667238482168237112546194112e-01 2.78697499768324700314403585821310e-03
 	 7.01396190623257975715887369005941e-02 3.31020384788811572462918775272556e-01 2.37016740955491326744986047003749e-03
 	 3.81982882450735417023679474368691e-02 3.42391158116234661790144855331164e-01 1.83862816461733530847000306351902e-03
 	 1.56622805575734602712145715486258e-02 3.50413736655173280176711614330998e-01 1.21617583980934977801180441048245e-03
 	 2.98523728321309356203983043087646e-03 3.54926628943832311868789020081749e-01 5.33712790470442671221518171620346e-04
 	 9.92435490725621427543501340551302e-01 2.17728468527995065728841694863149e-03 6.33977380291713455719420505785067e-06
 	 9.74791975660365683786778845387744e-01 7.25559892255658173132459864973498e-03 3.75973483705966380653828995406229e-05
 	 9.47485544406397428573995966871735e-01 1.51151800827369481305950671412575e-02 1.11023638598490640414830077364883e-04
 	 9.11074265802615856912893832486589e-01 2.55953998035314961301267544513394e-02 2.39542544377499761528577115754501e-04
 	 8.66299758970956679249297849310096e-01 3.84827986392667492632213566139399e-02 4.30310367670007549480148956178027e-04
 	 8.14073616512697495473105391283752e-01 5.35149938578996231530737759385374e-02 6.83778150497093748470811558348714e-04
 	 7.55459054449686973065070105803898e-01 7.03859611189806555486825345724355e-02 9.93331304477474991837526729909769e-04
 	 6.91649315012962340176727593643591e-01 8.87522507761110135415805189040839e-02 1.34554211185192065629301350071501e-03
 	 6.23943389721282049009687398211099e-01 1.08239975477512129220514225380612e-01 1.72102038984939427479492479733381e-03
 	 5.53719580728293525595518076443113e-01 1.28452419975442932997822254037601e-01 2.09579822764032960846769526597200e-03
 	 4.82407444612438895958916873496491e-01 1.48978116515408598452552269009175e-01 2.44314040199818029858169765589082e-03
 	 4.11458691561905232081386429854319e-01 1.69399220892906654523102361054043e-01 2.73563647726660953696242728483412e-03
 	 3.42317632958730799774826891734847e-01 1.89300018493964994359401998735848e-01 2.94740660647131464539016931780679e-03
 	 2.76391779093783207521539679873968e-01 2.08275387123669997180286372895353e-01 3.05624264269861029008623631852970e-03
 	 2.15023185358020230140141393349040e-01 2.25939044401560207298018667643191e-01 3.04551021617154244261471696120225e-03
 	 1.59461129444065097260363472742029e-01 2.41931412053731698108549608150497e-01 2.90565564808070459640321203664826e-03
 	 1.10836673320363510164554554648930e-01 2.55926937712849911221724141796585e-01 2.63519258108835079112974852932894e-03
 	 7.01396190623257975715887369005941e-02 2.67640727696842328775517216854496e-01 2.24108489627231760588088604890800e-03
 	 3.81982882450735417023679474368691e-02 2.76834367084848431694865666941041e-01 1.73849399539190499486274177343148e-03
 	 1.56622805575734602712145715486258e-02 2.83320882287036113211797783151269e-01 1.14994126356663512421307782318536e-03
 	 2.98523728321309356203983043087646e-03 2.86969702213714428218338525766740e-01 5.04646072192542938412984643292702e-04
 	 9.92435490725621538565803803066956e-01 1.69589173719388031091881430256763e-03 5.83949359426590906108718234679422e-06
 	 9.74791975660365683786778845387744e-01 5.65140164919426465917062785138114e-03 3.46304902661450018084600410706031e-05
 	 9.47485544406397317551693504356081e-01 1.17732463659042246861829994486470e-02 1.02262611658110829618469062030073e-04
 	 9.11074265802615856912893832486589e-01 1.99363121095033901664095310479752e-02 2.20639915071249175003778586479086e-04
 	 8.66299758970956679249297849310096e-01 2.99743348573808798818163268151693e-02 3.96353988907143515215553142283511e-04
 	 8.14073616512697495473105391283752e-01 4.16829441336579453736277400821564e-02 6.29820282845028225730821258565584e-04
 	 7.55459054449686973065070105803898e-01 5.48237769195446811298921829802566e-02 9.14946174705948307714908906973506e-04
 	 6.91649315012962340176727593643591e-01 6.91293195447305608425381251436193e-02 1.23936354627651279351752133806031e-03
 	 6.23943389721281937987384935695445e-01 8.43083503445388737773669163289014e-02 1.58521232058820107403696031411755e-03
 	 5.53719580728293525595518076443113e-01 1.00051866956893720228549682360608e-01 1.93041592738659958418401263458009e-03
 	 4.82407444612438895958916873496491e-01 1.16039376260391624562373635853874e-01 2.25034885642072003675284719292904e-03
 	 4.11458691561905343103688892369973e-01 1.31945418502965872153964710378204e-01 2.51976366694471555149337227419437e-03
 	 3.42317632958730744263675660477020e-01 1.47446192675206533273524200922111e-01 2.71482272605163893128277230459844e-03
 	 2.76391779093783207521539679873968e-01 1.62226148225753652454272923932876e-01 2.81507036202914822514697945621265e-03
 	 2.15023185358020230140141393349040e-01 1.75984408975356498849862418865087e-01 2.80518484593598668719316435726796e-03
 	 1.59461129444065097260363472742029e-01 1.88440898630955810943987671635114e-01 2.67636639280450540356870448022164e-03
 	 1.10836673320363510164554554648930e-01 1.99342043751503883441955622402020e-01 2.42724593578431263596328903986432e-03
 	 7.01396190623257975715887369005941e-02 2.08465940033593755131846592121292e-01 2.06423782658722273011808745479811e-03
 	 3.81982882450735417023679474368691e-02 2.15626885581169269734402860194677e-01 1.60130706005465802549414533473282e-03
 	 1.56622805575734602712145715486258e-02 2.20679246261857198163625071174465e-01 1.05919782805020392876804713466754e-03
 	 2.98523728321309356203983043087646e-03 2.23521319972290077870979985164013e-01 4.64823761469826055026111077950191e-04
 	 9.92435490725621427543501340551302e-01 1.25896580136469933564047352092530e-03 5.21475619457477511267760178492736e-06
 	 9.74791975660365683786778845387744e-01 4.19538656275570895348714373085386e-03 3.09255521427185086475418474005750e-05
 	 9.47485544406397428573995966871735e-01 8.74001224290422984442017195760855e-03 9.13220605535344808791065052133717e-05
 	 9.11074265802615856912893832486589e-01 1.47999631112821772305210288322996e-02 1.97034784834435706219954442808273e-04
 	 8.66299758970956679249297849310096e-01 2.22518110540107921790919931481767e-02 3.53950113230285998405094671781512e-04
 	 8.14073616512697384450802928768098e-01 3.09438391694170089607496265671216e-02 5.62439048594902814108553723571049e-04
 	 7.55459054449686973065070105803898e-01 4.06990957792863483621914610921522e-02 8.17060787075002382083555030334310e-04
 	 6.91649315012962340176727593643591e-01 5.13189888656662152044418689911254e-02 1.10677041184220636450830088648445e-03
 	 6.23943389721281937987384935695445e-01 6.25873264934209139198628690792248e-02 1.41561860374688343149063296522172e-03
 	 5.53719580728293525595518076443113e-01 7.42747170110302223910991870070575e-02 1.72389065129380822209703705283346e-03
 	 4.82407444612438895958916873496491e-01 8.61432384624103431036701294942759e-02 2.00959560097769673187029226824052e-03
 	 4.11458691561905232081386429854319e-01 9.79512818529619244678485756594455e-02 2.25018710594480052245014434220138e-03
 	 3.42317632958730744263675660477020e-01 1.09458469575816619290264952724101e-01 2.42437779908719541407946529432138e-03
 	 2.76391779093783207521539679873968e-01 1.20430548851713226099491294007748e-01 2.51390045584950864998585728926628e-03
 	 2.15023185358020230140141393349040e-01 1.30644160599517888954324007499963e-01 2.50507254030320116594543478072410e-03
 	 1.59461129444065097260363472742029e-01 1.39891386785902516187718447326915e-01 2.39003571123594035774395649696089e-03
 	 1.10836673320363510164554554648930e-01 1.47983984091195397425622104492504e-01 2.16756737122149063107245936521394e-03
 	 7.01396190623257975715887369005941e-02 1.54757219164182058257495100406231e-01 1.84339563345723811242649059494170e-03
 	 3.81982882450735417023679474368691e-02 1.60073233949860282976374037389178e-01 1.42999144977846190211756560728418e-03
 	 1.56622805575734602712145715486258e-02 1.63823915183599178035933618957642e-01 9.45879697604036875392685690400185e-04
 	 2.98523728321309356203983043087646e-03 1.65933763075371443207473021175247e-01 4.15094656819302526649245743683991e-04
 	 9.92435490725621538565803803066956e-01 8.75819021931832121519168055101545e-04 4.47887851808878664110809969534088e-06
 	 9.74791975660365683786778845387744e-01 2.91858551839586227716338839854870e-03 2.65615085315318751317970741299135e-05
 	 9.47485544406397428573995966871735e-01 6.08012462765476074944004380995466e-03 7.84351942793332389041935370777026e-05
 	 9.11074265802615856912893832486589e-01 1.02958231293492213920259814585734e-02 1.69230321070295273468142571715589e-04
 	 8.66299758970956568226995386794442e-01 1.54798163479979850043477540566528e-02 3.04002622456540623572390780182673e-04
 	 8.14073616512697384450802928768098e-01 2.15265600755774610952641978656175e-02 4.83070747412270848960419433737457e-04
 	 7.55459054449686862042767643288244e-01 2.83129551416613778336284212855389e-02 7.01761668361439291605186063804922e-04
 	 6.91649315012962340176727593643591e-01 3.57008479389491206745788076659665e-02 9.50589066314067900054229909301284e-04
 	 6.23943389721281826965082473179791e-01 4.35398412056763883803967019048287e-02 1.21585430220592905468934841195505e-03
 	 5.53719580728293525595518076443113e-01 5.16703550933230726371903074323200e-02 1.48062469605897352627199570207495e-03
 	 4.82407444612438951470068104754318e-01 5.99268755151304843842297032097122e-02 1.72601253662227533715312066675551e-03
 	 4.11458691561905287592537661112146e-01 6.81413234389988131667337256658357e-02 1.93265309334722523715299757895991e-03
 	 3.42317632958730744263675660477020e-01 7.61464764667395543895622722629923e-02 2.08226295514251638282821055270233e-03
 	 2.76391779093783207521539679873968e-01 8.37793730311716666747656745428685e-02 2.15915266758431824076214233798510e-03
 	 2.15023185358020230140141393349040e-01 9.08846299346214303582769389322493e-02 2.15157049886452369363842862526326e-03
 	 1.59461129444065097260363472742029e-01 9.73176057830223983913242591370363e-02 2.05276703360675457851747260917818e-03
 	 1.10836673320363510164554554648930e-01 1.02947346201012202016045193886384e-01 1.86169220060071385208777527964230e-03
 	 7.01396190623257975715887369005941e-02 1.07659251886224049954421388974879e-01 1.58326579325412529659911076151957e-03
 	 3.81982882450735417023679474368691e-02 1.11357419751563213594636181369424e-01 1.22819893135687704423253396868176e-03
 	 1.56622805575734602712145715486258e-02 1.13966639133178171405802459048573e-01 8.12402363643098860378211067967413e-04
 	 2.98523728321309356203983043087646e-03 1.15434387434993790400028501608176e-01 3.56518784777628899244211746477617e-04
 	 9.92435490725621427543501340551302e-01 5.54617094286578848905122640644549e-04 3.64754954387010364128159090046921e-06
 	 9.74791975660365683786778845387744e-01 1.84820993733291263905194057315384e-03 2.16314012397088133166089818359978e-05
 	 9.47485544406397317551693504356081e-01 3.85027153949234202112705816034577e-03 6.38767619977839999547558624826138e-05
 	 9.11074265802615856912893832486589e-01 6.51988523233133776546566195975174e-03 1.37819317477793257427365336553748e-04
 	 8.66299758970956568226995386794442e-01 9.80267674944922118296375401769183e-03 2.47576401636774351324582488231840e-04
 	 8.14073616512697495473105391283752e-01 1.36318096548849743143705381953623e-02 3.93407518704594002818125675347005e-04
 	 7.55459054449686973065070105803898e-01 1.79293307385560707345462105877232e-02 5.71507006273874718603467126598616e-04
 	 6.91649315012962340176727593643591e-01 2.26077534874642993578675032040337e-02 7.74149310198605426595885870000302e-04
 	 6.23943389721281937987384935695445e-01 2.75718380287369724257473535544705e-02 9.90178409062137656823643361292397e-04
 	 5.53719580728293525595518076443113e-01 3.27205295671748053187855020951247e-02 1.20580451399634525945503416011206e-03
 	 4.82407444612438951470068104754318e-01 3.79490154193775075519567963056033e-02 1.40564568010590959512562392319523e-03
 	 4.11458691561905287592537661112146e-01 4.31508586365472179835478527820669e-02 1.57393148321109980700138741838146e-03
 	 3.42317632958730744263675660477020e-01 4.82201647379058018216824166302104e-02 1.69577211383904226382757229885101e-03
 	 2.76391779093783207521539679873968e-01 5.30537374367696656918269582092762e-02 1.75839025237812347432497794841311e-03
 	 2.15023185358020230140141393349040e-01 5.75531794896024795349376290687360e-02 1.75221541732873851635043926933122e-03
 	 1.59461129444065097260363472742029e-01 6.16268959576304897751697353669442e-02 1.67175095883131388449505116966520e-03
 	 1.10836673320363510164554554648930e-01 6.51919592801033509488206618698314e-02 1.51614171040864351668042697696137e-03
 	 7.01396190623257975715887369005941e-02 6.81757988339877218919582446687855e-02 1.28939429785506452785792674831100e-03
 	 3.81982882450735417023679474368691e-02 7.05176834748743042169394357188139e-02 1.00023173965526138151638235740393e-03
 	 1.56622805575734602712145715486258e-02 7.21699856463841049603047395066824e-02 6.61611575080152001723798882437677e-04
 	 2.98523728321309356203983043087646e-03 7.30994451327759975356457289308310e-02 2.90344988269892892787660265696559e-04
 	 9.92435490725621427543501340551302e-01 3.02204663924155597642950965564523e-04 2.73850638939516363986139725616997e-06
 	 9.74791975660365683786778845387744e-01 1.00706896474484289272233183965000e-03 1.62404183395027827750516091764865e-05
 	 9.47485544406397428573995966871735e-01 2.09796998432902614961648168900865e-03 4.79573803620514003357572230257233e-05
 	 9.11074265802615856912893832486589e-01 3.55261268676772268282348932189052e-03 1.03471954789288538272690187724834e-04
 	 8.66299758970956679249297849310096e-01 5.34136914123622963401771812641528e-03 1.85875352641930906630318709460425e-04
 	 8.14073616512697384450802928768098e-01 7.42782091982169268007396567554679e-03 2.95362404444695963914163661101497e-04
 	 7.55459054449686862042767643288244e-01 9.76949218848027767236885665624868e-03 4.29075895869680096726683782293321e-04
 	 6.91649315012962340176727593643591e-01 1.23187125228221283634866267675534e-02 5.81215637190598513779626888009489e-04
 	 6.23943389721282049009687398211099e-01 1.50235867792063992887108270224417e-02 7.43405913269856158040460591962528e-04
 	 5.53719580728293525595518076443113e-01 1.78290513277237772093997136835242e-02 9.05293629661556558535506766816070e-04
 	 4.82407444612438840447765642238664e-01 2.06779949071307922459084238653304e-02 1.05533033339185464485887600005753e-03
 	 4.11458691561905287592537661112146e-01 2.35124212120990661034625190950464e-02 1.18167590910104387987022978023788e-03
 	 3.42317632958730744263675660477020e-01 2.62746295220689374261269222188275e-02 1.27315138913209452940777932639094e-03
 	 2.76391779093783207521539679873968e-01 2.89083893323252016926971919019707e-02 1.32016382046958968658756372605012e-03
 	 2.15023185358020230140141393349040e-01 3.13600850831957655984183475084137e-02 1.31552787926226058545786656850396e-03
 	 1.59461129444065097260363472742029e-01 3.35798077149446205780236596183386e-02 1.25511679202021516829623770661328e-03
 	 1.10836673320363510164554554648930e-01 3.55223709253738029190117231337354e-02 1.13828851705665584116700106420694e-03
 	 7.01396190623257975715887369005941e-02 3.71482317920409643718926417932380e-02 9.68051147943922458277699050199772e-04
 	 3.81982882450735417023679474368691e-02 3.84242985922513824448287778068334e-02 7.50953750450090908724609661817340e-04
 	 1.56622805575734602712145715486258e-02 3.93246196021628247052603910560720e-02 4.96724582864039405569189788991480e-04
 	 2.98523728321309356203983043087646e-03 3.98310717014757065257413159997668e-02 2.17985142063989716532806939497391e-04
 	 9.92435490725621427543501340551302e-01 1.23956441807939778121383511688691e-04 1.77122966834414135937198191833586e-06
 	 9.74791975660365683786778845387744e-01 4.13073325553656861552909163037839e-04 1.05040875203511514682317568025738e-05
 	 9.47485544406397317551693504356081e-01 8.60532365385836828242105411845841e-04 3.10181985487684299751878769235702e-05
 	 9.11074265802615856912893832486589e-01 1.45718872123030973586566005906207e-03 6.69242901437340693450439577105726e-05
 	 8.66299758970956568226995386794442e-01 2.19088979148429618959426079527475e-03 1.20221716658485512163948016883808e-04
 	 8.14073616512697495473105391283752e-01 3.04669769040610827204318411531858e-03 1.91036491896392032112730885451413e-04
 	 7.55459054449686973065070105803898e-01 4.00718994283424945201943501160713e-03 2.77520607466456652699660079264277e-04
 	 6.91649315012962340176727593643591e-01 5.05281338863511342296419570629951e-03 3.75922577461980736163865701726650e-04
 	 6.23943389721281937987384935695445e-01 6.16228199843604773633387594600208e-03 4.80825100246292053227797902437146e-04
 	 5.53719580728293525595518076443113e-01 7.31301011274404499928891709714662e-03 5.85531931431298763475468138750557e-04
 	 4.82407444612438895958916873496491e-01 8.48157218729728157313729752786458e-03 6.82573684562412952986365510810174e-04
 	 4.11458691561905287592537661112146e-01 9.64417965591946035885939636500552e-03 7.64292329816172386069972333189071e-04
 	 3.42317632958730744263675660477020e-01 1.07771651935686385570534184807912e-02 8.23457458948043401376903904775872e-04
 	 2.76391779093783207521539679873968e-01 1.18574645192536243243353055731859e-02 8.53864476981094130264571262500795e-04
 	 2.15023185358020230140141393349040e-01 1.28630859339841085997591108025517e-02 8.50866011599045435863375441698508e-04
 	 1.59461129444065097260363472742029e-01 1.37735580480120578528158148401417e-02 8.11792920356899398368066833597823e-04
 	 1.10836673320363510164554554648930e-01 1.45703466230959755023377510951832e-02 7.36229939193789391545241773684438e-04
 	 7.01396190623257975715887369005941e-02 1.52372321876331762169343164714519e-02 6.26122663198014632775223464733472e-04
 	 3.81982882450735417023679474368691e-02 1.57606413832735992031075511476956e-02 4.85706941383210290871103032017686e-04
 	 1.56622805575734602712145715486258e-02 1.61299294922803149177070736186579e-02 3.21274882385420726491759291221229e-04
 	 2.98523728321309356203983043087646e-03 1.63376628851464866798437469697092e-02 1.40989903246939972131929197374234e-04
 	 9.92435490725621538565803803066956e-01 2.36308816433999577255598012470728e-05 7.67720714728633878818253762077450e-07
 	 9.74791975660365683786778845387744e-01 7.87477175355523473232466358240345e-05 4.55288533317931868666305836312880e-06
 	 9.47485544406397428573995966871735e-01 1.64050679255983711257727009069640e-04 1.34445091932755300564951081443432e-05
 	 9.11074265802615856912893832486589e-01 2.77796407360933472752151374152163e-04 2.90076237882163036265349004283465e-05
 	 8.66299758970956679249297849310096e-01 4.17668146981131638284523432957940e-04 5.21088280579901742340168113720722e-05
 	 8.14073616512697384450802928768098e-01 5.80818160598350896606234528007917e-04 8.28027413492111433093029182472833e-05
 	 7.55459054449687084087372568319552e-01 7.63925052063518794653873555944301e-04 1.20288364024103840393790931795337e-04
 	 6.91649315012962340176727593643591e-01 9.63261234442569502789410762488842e-04 1.62939654303299440857299984486417e-04
 	 6.23943389721281937987384935695445e-01 1.17476876904809568458176727290265e-03 2.08408540246305551022973356900536e-04
 	 5.53719580728293525595518076443113e-01 1.39414195753534420063601828587707e-03 2.53792605741026753955746908530955e-04
 	 4.82407444612438895958916873496491e-01 1.61691498710903047708598023746163e-03 2.95854324446307239988157578025607e-04
 	 4.11458691561905287592537661112146e-01 1.83855283898703980582922667963430e-03 3.31274404553435618692863728895759e-04
 	 3.42317632958730744263675660477020e-01 2.05454360762613585933422655216418e-03 3.56918902291888462743885135353139e-04
 	 2.76391779093783207521539679873968e-01 2.26049035095288175511996087152511e-03 3.70098501772583572504149440618448e-04
 	 2.15023185358020230140141393349040e-01 2.45220060241668758038713349378668e-03 3.68798848753363586652070926774627e-04
 	 1.59461129444065097260363472742029e-01 2.62577172508204892409366948413663e-03 3.51863031749394348374204710694357e-04
 	 1.10836673320363510164554554648930e-01 2.77767037785070503019824172952212e-03 3.19111058957632248191116364210984e-04
 	 7.01396190623257975715887369005941e-02 2.90480450347918583986484009074047e-03 2.71386227934829464981253410726936e-04
 	 3.81982882450735417023679474368691e-02 3.00458649603108085557323647662997e-03 2.10524522512078166285726110729115e-04
 	 1.56622805575734602712145715486258e-02 3.07498706149567091472363244974986e-03 1.39253190445864986858268141922679e-04
 	 2.98523728321309356203983043087646e-03 3.11458906320372097553672574576922e-03 6.11105782749518791152967822633002e-05
 	 ];
 
 	 case  42 

 	 % ALG. DEG.:   42
 	 % PTS CARD.:  484
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 9.93077485044348562404081803833833e-01 6.90276704698835133489076554269559e-03 5.87300969910343041122417415134116e-07
 	 9.76919663237129087818289008282591e-01 2.30144953186519653220987180475277e-02 3.48824958079729154910653479704230e-06
 	 9.51879593229720044611497087316820e-01 4.79831333365900031262540892385005e-02 1.03256594449899256432613345313420e-05
 	 9.18425724989849201485014873469481e-01 8.13415674836979601947106743864424e-02 2.23531428388382315134222388941510e-05
 	 8.77181597465419904402494921669131e-01 1.22468037586155417684175006343139e-01 4.03284695345906216970219282380583e-05
 	 8.28915613621726388160482201783452e-01 1.70596332707384779059367474474129e-01 6.44266095189805583151598789015679e-05
 	 7.74526916064822601448724981310079e-01 2.24829875231971398896746450191131e-01 9.41986600005873127815225753778350e-05
 	 7.15028680474762534657884316402487e-01 2.84158379773477964835848297298071e-01 1.28580207106723635752248968699973e-04
 	 6.51529254895814258219388648285531e-01 3.47476660080147436993058818188729e-01 1.65948964627658475997490361564246e-04
 	 5.85211517951299109441265500208829e-01 4.13605211935093752817493850670871e-01 2.04227811559786761414977962481032e-04
 	 5.17310845950990971786609406990465e-01 4.81312183195509224464814224120346e-01 2.41025908485800928211101323839216e-04
 	 4.49092100986817399643769022077322e-01 5.49336320050737181297506595001323e-01 2.73807667831907168825428255942711e-04
 	 3.81826069256750222358220980822807e-01 6.16410461483817284644715073227417e-01 3.00077201898346884300500247988452e-04
 	 3.16765788710447360188027232652530e-01 6.81285144095546080222902673995122e-01 3.17564636492008781337020861812448e-04
 	 2.55123206971686999899873171671061e-01 7.42751877593929132892469624493970e-01 3.24400450496930420341001877204690e-04
 	 1.98046604118182756337773753330112e-01 7.99665657608165436620595301064895e-01 3.19264801874981493049615588475376e-04
 	 1.46599200157665476851320818241220e-01 8.50966297185958175930409197462723e-01 3.01500572577226148059809096579897e-04
 	 1.01739343452164066050613655534107e-01 8.95698181852607078212713531684130e-01 2.71181486474575796433161833931536e-04
 	 6.43026411321589996816783241229132e-02 9.33028088220158258181413657439407e-01 2.29129970806509435489808912400633e-04
 	 3.49863283512164002786448691040277e-02 9.62260770142829402473694244690705e-01 1.76883450164352782263063601497777e-04
 	 1.43359334836996588080637593520805e-02 9.82852255479010450400778609036934e-01 1.16614769485951037179642664209922e-04
 	 2.73144600888430844065624114591628e-03 9.94423638748171745405102228687610e-01 5.10828327965497826766184952251848e-05
 	 9.93077485044348451381779341318179e-01 6.81888662990198790581075627414975e-03 1.35603218724930000016481741048624e-06
 	 9.76919663237129087818289008282591e-01 2.27348298666354559083302433464269e-02 8.05409653834236101432354770768285e-06
 	 9.51879593229719933589194624801166e-01 4.74000562589505722299598744484683e-02 2.38411432627441539325481578703858e-05
 	 9.18425724989849201485014873469481e-01 8.03531284185309002676689260624698e-02 5.16116654468886301427958673837537e-05
 	 8.77181597465419904402494921669131e-01 1.20979841620313430250455155601230e-01 9.31152944626604508939621274166143e-05
 	 8.28915613621726499182784664299106e-01 1.68523295700125114171541440555302e-01 1.48756022378809929290408020641223e-04
 	 7.74526916064822601448724981310079e-01 2.22097807992912427144105436127575e-01 2.17497367620642106543146776509445e-04
 	 7.15028680474762423635581853886833e-01 2.80705369806354188000341309816577e-01 2.96881681476732391111728048826990e-04
 	 6.51529254895814258219388648285531e-01 3.43254224790517370458076129580149e-01 3.83163231469128427904291545047499e-04
 	 5.85211517951298998418963037693175e-01 4.08579201720632667615973332431167e-01 4.71546107013637088786750517499513e-04
 	 5.17310845950990971786609406990465e-01 4.75463417562776213820541215682169e-01 5.56510046148306607854960859071980e-04
 	 4.49092100986817399643769022077322e-01 5.42660944895690056100079345924314e-01 6.32200574694116485159611773525512e-04
 	 3.81826069256750222358220980822807e-01 6.08920020874465062199476506066276e-01 6.92854882388470034830507682244161e-04
 	 3.16765788710447360188027232652530e-01 6.73006365215646051858300324965967e-01 7.33232006548579172931778824562343e-04
 	 2.55123206971686999899873171671061e-01 7.33726172849707647394268406060291e-01 7.49015368558245673603901426673701e-04
 	 1.98046604118182756337773753330112e-01 7.89948353165872529935143120383145e-01 7.37157555970555946299460625681377e-04
 	 1.46599200157665476851320818241220e-01 8.40625602295271057151637705828762e-01 6.96141334401722731116401998718857e-04
 	 1.01739343452164066050613655534107e-01 8.84813918112304031993176067771856e-01 6.26136926526399124719179933862279e-04
 	 6.43026411321589996816783241229132e-02 9.21690202317236972895386770687765e-01 5.29043252771320350776040886131568e-04
 	 3.49863283512164002786448691040277e-02 9.50567657193198467524553052498959e-01 4.08410106748481420684687703825944e-04
 	 1.43359334836996588080637593520805e-02 9.70908920789797513783980775770033e-01 2.69254418149092521021781276857610e-04
 	 2.73144600888430844065624114591628e-03 9.82339691975677387070220447640168e-01 1.17946281441643765434262869362669e-04
 	 9.93077485044348451381779341318179e-01 6.66969353717981796453306841954145e-03 2.09953078523652055296195781397550e-06
 	 9.76919663237129087818289008282591e-01 2.22374056147873998268149620116674e-02 1.24700754071465770258164348915919e-05
 	 9.51879593229720044611497087316820e-01 4.63629718531962942140722816475318e-02 3.69129986043341604931740385087124e-05
 	 9.18425724989849201485014873469481e-01 7.85950508335344910637587645396707e-02 7.99098144586660608795769533685416e-05
 	 8.77181597465419904402494921669131e-01 1.18332876256609723086832275384950e-01 1.44169459352794769330802227003119e-04
 	 8.28915613621726499182784664299106e-01 1.64836108473550568831456075713504e-01 2.30317430080460242708406681799715e-04
 	 7.74526916064822601448724981310079e-01 2.17238443017408550117508525545418e-01 3.36748952806008403516174753988821e-04
 	 7.15028680474762312613279391371179e-01 2.74563707019135738729431750471122e-01 4.59658875131545459607335102347747e-04
 	 6.51529254895814258219388648285531e-01 3.35744031093810513244335425042664e-01 5.93247717719730849501857949945816e-04
 	 5.85211517951298998418963037693175e-01 3.99639737254491089757379995717201e-01 7.30090021197671084837721444671388e-04
 	 5.17310845950990971786609406990465e-01 4.65060567128017965377040354724159e-01 8.61638820352691016737911589018495e-04
 	 4.49092100986817399643769022077322e-01 5.30787853427429845432072852418059e-01 9.78829692610014333656320850707289e-04
 	 3.81826069256750222358220980822807e-01 5.95597221117635022835656855022535e-01 1.07274013770042417510730548002584e-03
 	 3.16765788710447360188027232652530e-01 6.58281395217182874191053087997716e-01 1.13525562663245875756612424112291e-03
 	 2.55123206971686999899873171671061e-01 7.17672690385485645414576083567226e-01 1.15969284482345699575922548518747e-03
 	 1.98046604118182756337773753330112e-01 7.72664763586484504287454910809174e-01 1.14133351470761313685431392883629e-03
 	 1.46599200157665476851320818241220e-01 8.22233225323068528389569564751582e-01 1.07782851778528282471469879055803e-03
 	 1.01739343452164066050613655534107e-01 8.65454727662074652094759130704915e-01 9.69441408085006356247503855882997e-04
 	 6.43026411321589996816783241229132e-02 9.01524181194019114116144919535145e-01 8.19112264708248037983762124270015e-04
 	 3.49863283512164002786448691040277e-02 9.29769814918416481752672098082257e-01 6.32337196847473177394038934551190e-04
 	 1.43359334836996588080637593520805e-02 9.49666024037566836035750839073444e-01 4.16883865501518110618234258524240e-04
 	 2.73144600888430844065624114591628e-03 9.60846696901245134192492969305022e-01 1.82615022872887055064780592594786e-04
 	 9.93077485044348562404081803833833e-01 6.45805773685572022391188085066460e-03 2.80226598151009763195177192096619e-06
 	 9.76919663237129087818289008282591e-01 2.15317913150924432341692948966738e-02 1.66439417540504887304837061678953e-05
 	 9.51879593229720044611497087316820e-01 4.48918300985027621252676510721358e-02 4.92681702939651847876836865403050e-05
 	 9.18425724989849201485014873469481e-01 7.61011541661770485323046386838541e-02 1.06656475923536992909609888435796e-04
 	 8.77181597465419904402494921669131e-01 1.14578060112267149373010965973663e-01 1.92424504731197469663619981083968e-04
 	 8.28915613621726610205087126814760e-01 1.59605699978071113864785957048298e-01 3.07407113914072069836558309674501e-04
 	 7.74526916064822601448724981310079e-01 2.10345257971819438180816064232204e-01 4.49462394832719606702770009931669e-04
 	 7.15028680474762312613279391371179e-01 2.65851536129869392421909424228943e-01 6.13511570269839883080831288708623e-04
 	 6.51529254895814258219388648285531e-01 3.25090549591477206980982828099513e-01 7.91814013714129284055021074095748e-04
 	 5.85211517951299109441265500208829e-01 3.86958783449988519276274701041984e-01 9.74458885875179297436643466312489e-04
 	 5.17310845950990971786609406990465e-01 4.50303747376906315924571799769183e-01 1.15003846173697757415688158744160e-03
 	 4.49092100986817399643769022077322e-01 5.13945443572130455933688608638477e-01 1.30645436046036649523072181722227e-03
 	 3.81826069256750222358220980822807e-01 5.76698347599776561800410945579642e-01 1.43179762641094466060764922588078e-03
 	 3.16765788710447360188027232652530e-01 6.37393492476428180637526565988082e-01 1.51523771177838840681917353947483e-03
 	 2.55123206971686999899873171671061e-01 6.94900244642093545266448018082883e-01 1.54785432578610315616784998127287e-03
 	 1.98046604118182756337773753330112e-01 7.48147366390900847576972410024609e-01 1.52334993338151770611577084935107e-03
 	 1.46599200157665476851320818241220e-01 7.96142973091195971235833894752432e-01 1.43858914121656653560543670522520e-03
 	 1.01739343452164066050613655534107e-01 8.37993015529123419504742287244881e-01 1.29392371764523663076051906983821e-03
 	 6.43026411321589996816783241229132e-02 8.72917950557641542097542242117925e-01 1.09327781739148688182339252961128e-03
 	 3.49863283512164002786448691040277e-02 9.00267323117174056434919293678831e-01 8.43987155620348891357784815170362e-04
 	 1.43359334836996588080637593520805e-02 9.19532206356525771973053906549467e-01 5.56419311757665310466669517097671e-04
 	 2.73144600888430844065624114591628e-03 9.30358105700779813851397648249986e-01 2.43738205654236549796420874258729e-04
 	 9.93077485044348562404081803833833e-01 6.18809428867807525403987867207434e-03 3.45047886998562589868852490404549e-06
 	 9.76919663237128976795986545766937e-01 2.06317069761602321642524060507640e-02 2.04939751310383471880841727008615e-05
 	 9.51879593229720044611497087316820e-01 4.30152359672311274119138602145540e-02 6.06647554814088911610131527041290e-05
 	 9.18425724989849201485014873469481e-01 7.29199298993586653150345000540256e-02 1.31327974913707852967076350481079e-04
 	 8.77181597465419904402494921669131e-01 1.09788402067420826080379470113257e-01 2.36935641378571042788697686987121e-04
 	 8.28915613621726499182784664299106e-01 1.52933770603858820713583099859534e-01 3.78515729071575955655415413048104e-04
 	 7.74526916064822712471027443825733e-01 2.01552284377635337886403021911974e-01 5.53430868610017075333307179363374e-04
 	 7.15028680474762423635581853886833e-01 2.54738257134645262880212612799369e-01 7.55427473221872633479812009227317e-04
 	 6.51529254895814258219388648285531e-01 3.11500927244680037020430063421372e-01 9.74974374776089265301481923131632e-04
 	 5.85211517951298998418963037693175e-01 3.70782909566636287301832908269716e-01 1.19986818437917250497470877945716e-03
 	 5.17310845950990971786609406990465e-01 4.31479890836352630856254108948633e-01 1.41606237169386085274214170937057e-03
 	 4.49092100986817399643769022077322e-01 4.92461200201232074391555215697736e-01 1.60865998984858864229163799564049e-03
 	 3.81826069256750222358220980822807e-01 5.52590871200504429872069067641860e-01 1.76299733452291314782234277203088e-03
 	 3.16765788710447360188027232652530e-01 6.10748802681705615924556695972569e-01 1.86573856371737120847520419175680e-03
 	 2.55123206971686999899873171671061e-01 6.65851624479957049373979316442274e-01 1.90589996816173065131982955477952e-03
 	 1.98046604118182756337773753330112e-01 7.16872879384804928548646785202436e-01 1.87572728335174158595388682613248e-03
 	 1.46599200157665476851320818241220e-01 7.62862146097111892828479540185072e-01 1.77135984489366839385315888222294e-03
 	 1.01739343452164066050613655534107e-01 8.02962748963069183893992430967046e-01 1.59323079128348898611533535074614e-03
 	 6.43026411321589996816783241229132e-02 8.36427731747142022555863150046207e-01 1.34617200252364261660320554625514e-03
 	 3.49863283512164002786448691040277e-02 8.62633830086698250028121037757955e-01 1.03921607235797305336666429553816e-03
 	 1.43359334836996588080637593520805e-02 8.81093391583824825374904321506619e-01 6.85128781757239581004514938911143e-04
 	 2.73144600888430844065624114591628e-03 8.91466740449949890390257678518537e-01 3.00119094321283914721110175349850e-04
 	 9.93077485044348451381779341318179e-01 5.86505671078539018298281249030879e-03 4.03153837703158590786024079166694e-06
 	 9.76919663237129087818289008282591e-01 1.95546683373721066900863263526844e-02 2.39451538038417890844403168593146e-05
 	 9.51879593229720044611497087316820e-01 4.07697081858008555932393335297093e-02 7.08806803554070345837687106005376e-05
 	 9.18425724989849201485014873469481e-01 6.91132850041941276808543648257910e-02 1.53443562703127136951156139765828e-04
 	 8.77181597465420015424797384184785e-01 1.04057109389890489747898527639336e-01 2.76835525472521304900241911894909e-04
 	 8.28915613621726499182784664299106e-01 1.44950156824046855197352101640718e-01 4.42257653375662050220656906773797e-04
 	 7.74526916064822490426422518794425e-01 1.91030634459790016332902951035067e-01 6.46628444893071929917838236434591e-04
 	 7.15028680474762534657884316402487e-01 2.41440135654508780671534395878552e-01 8.82641211296757740960294835730338e-04
 	 6.51529254895814258219388648285531e-01 2.95239619586107948645548049171339e-01 1.13915973887663743956133455270674e-03
 	 5.85211517951299109441265500208829e-01 3.51426899874030918002887347029173e-01 1.40192559206252904090150845917151e-03
 	 5.17310845950990971786609406990465e-01 4.08955311807200294627051562201814e-01 1.65452680942745466302623569276875e-03
 	 4.49092100986817399643769022077322e-01 4.66753209033386684545519074163167e-01 1.87955780314540631635578105118611e-03
 	 3.81826069256750222358220980822807e-01 5.23743926039241691761105812474852e-01 2.05988550591040906617701367053996e-03
 	 3.16765788710447360188027232652530e-01 5.78865834401772971773425524588674e-01 2.17992832431566441533932199092760e-03
 	 2.55123206971686999899873171671061e-01 6.31092119214909708091454376699403e-01 2.22685289606172967524777561720839e-03
 	 1.98046604118182756337773753330112e-01 6.79449907495523475198240248573711e-01 2.19159914105176035353794716797893e-03
 	 1.46599200157665476851320818241220e-01 7.23038392863081802452995816565817e-01 2.06965626027766184946710126268954e-03
 	 1.01739343452164066050613655534107e-01 7.61045620771007791383055973710725e-01 1.86153033261570008578822399414321e-03
 	 6.43026411321589996816783241229132e-02 7.92763628399487663145350779814180e-01 1.57286692507180455267989938050732e-03
 	 3.49863283512164002786448691040277e-02 8.17601687704939794620884185860632e-01 1.21421971720599326804990170103338e-03
 	 1.43359334836996588080637593520805e-02 8.35097603246331199322582961031003e-01 8.00504243306586634430777049686867e-04
 	 2.73144600888430844065624114591628e-03 8.44929431357273164060472936398583e-01 3.50659051113464390915519519609234e-04
 	 9.93077485044348451381779341318179e-01 5.49523221873658273411988872680922e-03 4.53413100495989812788654935160615e-06
 	 9.76919663237128976795986545766937e-01 1.83216375856399341093272425951000e-02 2.69302817254768922430180344562700e-05
 	 9.51879593229720044611497087316820e-01 3.81989510108420304845822101924568e-02 7.97170361277166317735820566525717e-05
 	 9.18425724989849201485014873469481e-01 6.47553074464497779860749915314955e-02 1.72572638555911232402517718753643e-04
 	 8.77181597465419904402494921669131e-01 9.74957290790375019629010466815089e-02 3.11347287792292342755579026558621e-04
 	 8.28915613621726499182784664299106e-01 1.35810242111667228703808518730511e-01 4.97391802041547564927626012831752e-04
 	 7.74526916064822601448724981310079e-01 1.78985088979396356201334583602147e-01 7.27240523712298337320747432244161e-04
 	 7.15028680474762423635581853886833e-01 2.26215990359472596260559384973021e-01 9.92675874102099667015131068126266e-04
 	 6.51529254895814258219388648285531e-01 2.76623117183781741523773689550580e-01 1.28117334094327429798443329644897e-03
 	 5.85211517951299109441265500208829e-01 3.29267476504909395451647924346616e-01 1.57669695762582915549154805034959e-03
 	 5.17310845950990971786609406990465e-01 3.83168401651389212148046681249980e-01 1.86078876190333810172750084177551e-03
 	 4.49092100986817455154920253335149e-01 4.37321819542216994047834077719017e-01 2.11387329447444054578153505019600e-03
 	 3.81826069256750222358220980822807e-01 4.90718954421333286575190868461505e-01 2.31668159038901687665767958890228e-03
 	 3.16765788710447360188027232652530e-01 5.42365119450735844175426336732926e-01 2.45168957343463523104731827118030e-03
 	 2.55123206971686999899873171671061e-01 5.91298246123202475565960867243120e-01 2.50446400734811178492855709976084e-03
 	 1.98046604118182756337773753330112e-01 6.36606806515773060439755681727547e-01 2.46481533513339887142556960952788e-03
 	 1.46599200157665476851320818241220e-01 6.77446795107402466307178201532224e-01 2.32767041802136752035035094365867e-03
 	 1.01739343452164066050613655534107e-01 7.13057455607994716828557102417108e-01 2.09359842532388928937336913804756e-03
 	 6.43026411321589996816783241229132e-02 7.42775466196645139937970725441119e-01 1.76894872991261906634841150065540e-03
 	 3.49863283512164002786448691040277e-02 7.66047347523080457420974198612384e-01 1.36559068815586266525119452097670e-03
 	 1.43359334836996588080637593520805e-02 7.82440048143101085642570069467183e-01 9.00299282739512704738793491543447e-04
 	 2.73144600888430844065624114591628e-03 7.91651924731604506035864687873982e-01 3.94374039667220478971171315762945e-04
 	 9.93077485044348451381779341318179e-01 5.08581888181857972447419413697389e-03 4.94847304559358934158974641093209e-06
 	 9.76919663237129087818289008282591e-01 1.69566137826124146981143780976709e-02 2.93912489698657642235926634732834e-05
 	 9.51879593229720044611497087316820e-01 3.53530003071042056572714784579148e-02 8.70018100758659137638345582033139e-05
 	 9.18425724989849312507317335985135e-01 5.99308186078511551109215815813513e-02 1.88342826743808375647426522903061e-04
 	 8.77181597465419793380192459153477e-01 9.02319683881964151872523416386684e-02 3.39799105886764150116080562824550e-04
 	 8.28915613621726610205087126814760e-01 1.25691920956649105800551069478388e-01 5.42844907394463287338137735815735e-04
 	 7.74526916064822601448724981310079e-01 1.65650096094515530964486060838681e-01 7.93697871834098730298157065021769e-04
 	 7.15028680474762423635581853886833e-01 2.09362136001598697632175571925472e-01 1.08338947432965533763937759914597e-03
 	 6.51529254895814258219388648285531e-01 2.56013761843215281732710764117655e-01 1.39825067636018852967882963866941e-03
 	 5.85211517951299109441265500208829e-01 3.04735938813961992899237429810455e-01 1.72078009818109355956450290392468e-03
 	 5.17310845950990860764306944474811e-01 3.54621063217400389611100308684399e-01 2.03083303542606324193497968622069e-03
 	 4.49092100986817399643769022077322e-01 4.04739868804019353731860064726789e-01 2.30704516655213121706369250318858e-03
 	 3.81826069256750166847069749564980e-01 4.54158737014407731802378975771717e-01 2.52838667271025000632400647759823e-03
 	 3.16765788710447360188027232652530e-01 5.01957088535290862907345399435144e-01 2.67573207678224993938398412751667e-03
 	 2.55123206971686888877570709155407e-01 5.47244532208502665326932401512749e-01 2.73332919151749332425938021629008e-03
 	 1.98046604118182756337773753330112e-01 5.89177452016126590450539879384451e-01 2.69005730865097287402010195478397e-03
 	 1.46599200157665476851320818241220e-01 6.26974723695451152671864747389918e-01 2.54037969128026452914070887345588e-03
 	 1.01739343452164066050613655534107e-01 6.59932269866190135410022321593715e-01 2.28491752105960174018539632356806e-03
 	 6.43026411321589996816783241229132e-02 6.87436188420626037576255384919932e-01 1.93060039496742138001583732886957e-03
 	 3.49863283512164002786448691040277e-02 7.08974236087087872348888595297467e-01 1.49038232557919983305161348852153e-03
 	 1.43359334836996588080637593520805e-02 7.24145625214746679887412028620020e-01 9.82571242147672364863897342956989e-04
 	 2.73144600888430844065624114591628e-03 7.32671185923728707223290257388726e-01 4.30413083133304426655674213009206e-04
 	 9.93077485044348562404081803833833e-01 4.64478539482495855067467616095200e-03 5.26649927191877229558109735352289e-06
 	 9.76919663237128976795986545766937e-01 1.54861653301745019750690346427291e-02 3.12801524580222999158581054235384e-05
 	 9.51879593229719933589194624801166e-01 3.22872487804683611090084127681621e-02 9.25932030342504900407435419751323e-05
 	 9.18425724989849312507317335985135e-01 5.47337208497116756156231076602126e-02 2.00447158300810123398791318116707e-04
 	 8.77181597465419904402494921669131e-01 8.24072069129480888616257061585202e-02 3.61637161052097649924924605002730e-04
 	 8.28915613621726499182784664299106e-01 1.14792133238173485465516421299981e-01 5.77732218245278583527990701185217e-04
 	 7.74526916064822601448724981310079e-01 1.51285203989811045666158406675095e-01 8.44706887483177197920025669475308e-04
 	 7.15028680474762534657884316402487e-01 1.91206610798900056291671489816508e-01 1.15301625879163957381912108957067e-03
 	 6.51529254895814258219388648285531e-01 2.33812687694130882931631276733242e-01 1.48811281806780770775588962351321e-03
 	 5.85211517951298998418963037693175e-01 2.78309761077302542098266258108197e-01 1.83137041481367919895650864248182e-03
 	 5.17310845950990971786609406990465e-01 3.23868933087231358758373289674637e-01 2.16134969391896473306369230726887e-03
 	 4.49092100986817344132617790819495e-01 3.69641521849094323304285580888973e-01 2.45531330129192867234300123868707e-03
 	 3.81826069256750222358220980822807e-01 4.14774870603014655934259735658998e-01 2.69087988320251218082868049918943e-03
 	 3.16765788710447360188027232652530e-01 4.58428231094200833162233266193653e-01 2.84769481502410810522252226917317e-03
 	 2.55123206971686999899873171671061e-01 4.99788425357956200834053106518695e-01 2.90899355506430866077915986522839e-03
 	 1.98046604118182756337773753330112e-01 5.38084994309930619849069444171619e-01 2.86294069441186743371630107901638e-03
 	 1.46599200157665476851320818241220e-01 5.72604551443192333337606214627158e-01 2.70364366366269504374231225085623e-03
 	 1.01739343452164066050613655534107e-01 6.02704075759791457755909505067393e-01 2.43176356629247209656385919629429e-03
 	 6.43026411321589996816783241229132e-02 6.27822901689435663996619041427039e-01 2.05467534748234341088202192793233e-03
 	 3.49863283512164002786448691040277e-02 6.47493206818047339901056602684548e-01 1.58616554242581135614198473149372e-03
 	 1.43359334836996588080637593520805e-02 6.61348959112190715181611722073285e-01 1.04571868608780349160780609452104e-03
 	 2.73144600888430844065624114591628e-03 6.69135197824964889079524255066644e-01 4.58074676382106728278476026616772e-04
 	 9.93077485044348451381779341318179e-01 4.18071593404440410013389595178523e-03 5.48201942757658426972960583056782e-06
 	 9.76919663237128976795986545766937e-01 1.39389127052545868518107496925040e-02 3.25602254208534313000174276186982e-05
 	 9.51879593229719933589194624801166e-01 2.90613675269805991907556830255999e-02 9.63823807214481148184989645066878e-05
 	 9.18425724989849201485014873469481e-01 4.92651693102715351746390126663755e-02 2.08650027137895774723141961715100e-04
 	 8.77181597465419904402494921669131e-01 7.41737440452918395106252091864008e-02 3.76436384068642570111667966514801e-04
 	 8.28915613621726499182784664299106e-01 1.03323029965276994013301248287462e-01 6.01374666705998032166513578289369e-04
 	 7.74526916064822601448724981310079e-01 1.36170007684326299646215829852736e-01 8.79274700080495403946290178254230e-04
 	 7.15028680474762312613279391371179e-01 1.72102789797829502926873601609259e-01 1.20020096930622491987472599817011e-03
 	 6.51529254895814258219388648285531e-01 2.10452011434952152013622139747895e-01 1.54901063455407310247291530203029e-03
 	 5.85211517951299109441265500208829e-01 2.50503296456351831622555437206756e-01 1.90631531017753145205995135569310e-03
 	 5.17310845950990860764306944474811e-01 2.91510563783706433405029656569241e-01 2.24979828156961257981660828875192e-03
 	 4.49092100986817399643769022077322e-01 3.32709924983987215263425696321065e-01 2.55579171732526816071540132213613e-03
 	 3.81826069256750166847069749564980e-01 3.73333913877538392522836829812150e-01 2.80099835495025263967794337816031e-03
 	 3.16765788710447415699178463910357e-01 4.12625782988094769176967702151160e-01 2.96423060058329532542864548361194e-03
 	 2.55123206971686944388721940413234e-01 4.49853600528666131008748152453336e-01 3.02803785971995443118687241224052e-03
 	 1.98046604118182756337773753330112e-01 4.84323885466940051713891079998575e-01 2.98010038479456975529791051826578e-03
 	 1.46599200157665476851320818241220e-01 5.15394527116815881484512829047162e-01 2.81428446567377147508048906843214e-03
 	 1.01739343452164066050613655534107e-01 5.42486749947555635387175243522506e-01 2.53127826007109755709900689168990e-03
 	 6.43026411321589996816783241229132e-02 5.65095905566576184320126685634023e-01 2.13875851693739712014452614141646e-03
 	 3.49863283512164002786448691040277e-02 5.82800912598833598110559250926599e-01 1.65107595576725668315432038468771e-03
 	 1.43359334836996588080637593520805e-02 5.95272309976813129850370387430303e-01 1.08851247421222767537696274331438e-03
 	 2.73144600888430844065624114591628e-03 6.02280610573227348503166922455421e-01 4.76820397298309355503531659081773e-04
 	 9.93077485044348562404081803833833e-01 3.70264305910176843780745592482617e-03 5.59083854775404066498678892771501e-06
 	 9.76919663237129087818289008282591e-01 1.23449713383440295988435764229507e-02 3.32065520400648585145134128460143e-05
 	 9.51879593229719933589194624801166e-01 2.57381444851443909327404213627233e-02 9.82955891675832844336588300926394e-05
 	 9.18425724989849201485014873469481e-01 4.36316028354709409264877706391417e-02 2.12791769552001972746341218467592e-04
 	 8.77181597465419904402494921669131e-01 6.56918343388154246653698464797344e-02 3.83908717331649888132583114952467e-04
 	 8.28915613621726388160482201783452e-01 9.15078435803224343736417267791694e-02 6.13312067328616178363276389973180e-04
 	 7.74526916064822601448724981310079e-01 1.20598706480986694877799436653731e-01 8.96728468809540948947223171217047e-04
 	 7.15028680474762534657884316402487e-01 1.52422506132945001500189619036973e-01 1.22402518504304697044560157337401e-03
 	 6.51529254895814258219388648285531e-01 1.86386420820466885972521708936256e-01 1.57975878797172943242277387554395e-03
 	 5.85211517951298998418963037693175e-01 2.21857764684083996753471978991001e-01 1.94415602883511512075087601658652e-03
 	 5.17310845950990860764306944474811e-01 2.58175772445849216474300646950724e-01 2.29445720202976592705379488279505e-03
 	 4.49092100986817455154920253335149e-01 2.94663907778228428835376462302520e-01 2.60652466523076525861668528705195e-03
 	 3.81826069256750222358220980822807e-01 3.30642465729240164762359199812636e-01 2.85659870088681051847334657622923e-03
 	 3.16765788710447415699178463910357e-01 3.65441234346029764079588630920625e-01 3.02307113740006485474998143558878e-03
 	 2.55123206971686999899873171671061e-01 3.98411979643416347407480770925758e-01 3.08814498267198254619070318938157e-03
 	 1.98046604118182811848924984587939e-01 4.28940521473449354328266736047226e-01 3.03925593982280186841626878901934e-03
 	 1.46599200157665476851320818241220e-01 4.56458175736904281372119385196129e-01 2.87014854341548133337402859410759e-03
 	 1.01739343452164066050613655534107e-01 4.80452350993589294425589741877047e-01 2.58152461122403880169895451501816e-03
 	 6.43026411321589996816783241229132e-02 5.00476106361233741282035225594882e-01 2.18121327711471657898045783952057e-03
 	 3.49863283512164002786448691040277e-02 5.16156511926583405625024170149118e-01 1.68385012507226610248278753090290e-03
 	 1.43359334836996588080637593520805e-02 5.27201781126254709342049409315223e-01 1.11011965224412385150332127636830e-03
 	 2.73144600888430844065624114591628e-03 5.33408669125533085875190408842172e-01 4.86285372167908616289344614358470e-04
 	 9.93077485044348562404081803833833e-01 3.21987189654972466926197149916788e-03 5.59083854775407369927173184542823e-06
 	 9.76919663237129087818289008282591e-01 1.07353654245269380940186465522856e-02 3.32065520400650550261571758436929e-05
 	 9.51879593229719933589194624801166e-01 2.23822622851356199669137225782833e-02 9.82955891675838671923265410512727e-05
 	 9.18425724989849201485014873469481e-01 3.79426721746798575884973558913771e-02 2.12791769552003246683893888935302e-04
 	 8.77181597465419904402494921669131e-01 5.71265681957646709321352318511344e-02 3.83908717331652164957145334511779e-04
 	 8.28915613621726388160482201783452e-01 7.95765427979510664435736089217244e-02 6.13312067328619864650662840688256e-04
 	 7.74526916064822601448724981310079e-01 1.04874377454190703673475582036190e-01 8.96728468809546261537868350188774e-04
 	 7.15028680474762534657884316402487e-01 1.32548813392292574864228527076193e-01 1.22402518504305434302037447480416e-03
 	 6.51529254895814258219388648285531e-01 1.62084324283718855808089642778214e-01 1.57975878797173875656145725088209e-03
 	 5.85211517951298998418963037693175e-01 1.92930717364616949316413752057997e-01 1.94415602883512683013433886003440e-03
 	 5.17310845950990971786609406990465e-01 2.24513381603159867250241177316639e-01 2.29445720202977980484160269725180e-03
 	 4.49092100986817344132617790819495e-01 2.56243991234954171520854515620158e-01 2.60652466523078087112796907831580e-03
 	 3.81826069256750222358220980822807e-01 2.87531465014009612879419819364557e-01 2.85659870088682743202723735009840e-03
 	 3.16765788710447304676876001394703e-01 3.17792976943522875732384136426845e-01 3.02307113740008306934647919206327e-03
 	 2.55123206971686999899873171671061e-01 3.46464813384896652692646057403181e-01 3.08814498267200076078720094585606e-03
 	 1.98046604118182700826622522072284e-01 3.73012874408367889333959510622662e-01 3.03925593982282008301276654549383e-03
 	 1.46599200157665476851320818241220e-01 3.96942624105430241776559796562651e-01 2.87014854341549868060878836217853e-03
 	 1.01739343452164066050613655534107e-01 4.17808305554246639523796602588845e-01 2.58152461122405398052936931208023e-03
 	 6.43026411321589996816783241229132e-02 4.35221252506607259036286450282205e-01 2.18121327711472958940652766557378e-03
 	 3.49863283512164002786448691040277e-02 4.48857159722200194096330960746855e-01 1.68385012507227629398320889464458e-03
 	 1.43359334836996588080637593520805e-02 4.58462285390045631849886831332697e-01 1.11011965224413057355679068649579e-03
 	 2.73144600888430844065624114591628e-03 4.63859884865582605684153350011911e-01 4.86285372167911489425101700945220e-04
 	 9.93077485044348451381779341318179e-01 2.74179902160708987429726946061237e-03 5.48201942757657241126834427036307e-06
 	 9.76919663237128976795986545766937e-01 9.14142405761638257577494925953943e-03 3.25602254208533567611180692402684e-05
 	 9.51879593229719933589194624801166e-01 1.90590392432994151783454128690209e-02 9.63823807214478979780644674058010e-05
 	 9.18425724989849312507317335985135e-01 3.23091056998792702792400177713716e-02 2.08650027137895286832164343238105e-04
 	 8.77181597465419904402494921669131e-01 4.86446584892882699646676769589249e-02 3.76436384068641756960038602386476e-04
 	 8.28915613621726499182784664299106e-01 6.77613564129965206817018952278886e-02 6.01374666705996622703689347133604e-04
 	 7.74526916064822601448724981310079e-01 8.93030762508511266606348044660990e-02 8.79274700080493452382379704346249e-04
 	 7.15028680474762423635581853886833e-01 1.12868529727408101193120160132821e-01 1.20020096930622231778951203295946e-03
 	 6.51529254895814258219388648285531e-01 1.38018733669233645278140443224402e-01 1.54901063455406963302596334841610e-03
 	 5.85211517951298998418963037693175e-01 1.64285185592349169958481525100069e-01 1.90631531017752711525126141367537e-03
 	 5.17310845950990971786609406990465e-01 1.91178590265302705830663398955949e-01 2.24979828156960737564618035833064e-03
 	 4.49092100986817455154920253335149e-01 2.18197974029195440603956512859440e-01 2.55579171732526252286410439751307e-03
 	 3.81826069256750222358220980822807e-01 2.44840016865711440630093420622870e-01 2.80099835495024613446490846513370e-03
 	 3.16765788710447360188027232652530e-01 2.70608428301457926146156296454137e-01 2.96423060058328882021561057058534e-03
 	 2.55123206971687055411024402928888e-01 2.95023192499646980113681138391257e-01 3.02803785971994749229296850501214e-03
 	 1.98046604118182756337773753330112e-01 3.17629510414877302970637629186967e-01 2.98010038479456325008487560523918e-03
 	 1.46599200157665476851320818241220e-01 3.38006272725518752686468815227272e-01 2.81428446567376496986745415540554e-03
 	 1.01739343452164066050613655534107e-01 3.55773906600280409584513563459041e-01 2.53127826007109191924770996706684e-03
 	 6.43026411321589996816783241229132e-02 3.70601453301264927020497452758718e-01 2.13875851693739234965496720519695e-03
 	 3.49863283512164002786448691040277e-02 3.82212759049950112633098342485027e-01 1.65107595576725299686693393397263e-03
 	 1.43359334836996588080637593520805e-02 3.90391756539487433386170778248925e-01 1.08851247421222529013218327520462e-03
 	 2.73144600888430844065624114591628e-03 3.94987943417888454078479298914317e-01 4.76820397298308271301359173577339e-04
 	 9.93077485044348562404081803833833e-01 2.27772956082653368903301327463851e-03 5.26649927191876975448225559062188e-06
 	 9.76919663237128976795986545766937e-01 7.59417143269646224834623637889308e-03 3.12801524580222863633309493547330e-05
 	 9.51879593229719933589194624801166e-01 1.58331579898116428517518272656162e-02 9.25932030342504493831620737687160e-05
 	 9.18425724989849201485014873469481e-01 2.68405541604391090215742110558494e-02 2.00447158300810042083628381703875e-04
 	 8.77181597465419904402494921669131e-01 4.04111956216319789803037565434352e-02 3.61637161052097487294598732177064e-04
 	 8.28915613621726499182784664299106e-01 5.62922531400999875961232987719995e-02 5.77732218245278366687556204084331e-04
 	 7.74526916064822490426422518794425e-01 7.41878799453662973739653807569994e-02 8.44706887483176872659373923823978e-04
 	 7.15028680474762423635581853886833e-01 9.37647087263374645615954250388313e-02 1.15301625879163892329781759826801e-03
 	 6.51529254895814258219388648285531e-01 1.14658057410054803337828843723400e-01 1.48811281806780705723458613221055e-03
 	 5.85211517951298998418963037693175e-01 1.36478720971398348460468241682975e-01 1.83137041481367833159477065407827e-03
 	 5.17310845950990860764306944474811e-01 1.58820220961777613943866072077071e-01 2.16134969391896386570195431886532e-03
 	 4.49092100986817344132617790819495e-01 1.81266377164088166029642934518051e-01 2.45531330129192780498126325028352e-03
 	 3.81826069256750222358220980822807e-01 2.03399060140235010685216821002541e-01 2.69087988320251131346694251078588e-03
 	 3.16765788710447304676876001394703e-01 2.24805980195351751138588269895990e-01 2.84769481502410680417991528656785e-03
 	 2.55123206971686999899873171671061e-01 2.45088367670356688243771259294590e-01 2.90899355506430779341742187682485e-03
 	 1.98046604118182756337773753330112e-01 2.63868401571886623813156802498270e-01 2.86294069441186613267369409641105e-03
 	 1.46599200157665476851320818241220e-01 2.80796248399142078788770504615968e-01 2.70364366366269417638057426245268e-03
 	 1.01739343452164066050613655534107e-01 2.95556580788044365171174376882846e-01 2.43176356629247079552125221368897e-03
 	 6.43026411321589996816783241229132e-02 3.07874457178405114277097709418740e-01 2.05467534748234254352028393952878e-03
 	 3.49863283512164002786448691040277e-02 3.17520464830736037775693603180116e-01 1.58616554242581048878024674309017e-03
 	 1.43359334836996588080637593520805e-02 3.24315107404109403965719593543326e-01 1.04571868608780305792693710031926e-03
 	 2.73144600888430844065624114591628e-03 3.28133356166150691457517041271785e-01 4.58074676382106511438041529515885e-04
 	 9.93077485044348451381779341318179e-01 1.83669607383291598468044725223081e-03 4.94847304559365117499489597485685e-06
 	 9.76919663237129087818289008282591e-01 6.12372298025855993364174878479389e-03 2.93912489698661301418258773310299e-05
 	 9.51879593229719933589194624801166e-01 1.27674064631758191201704732975486e-02 8.70018100758669979660070437077479e-05
 	 9.18425724989849201485014873469481e-01 2.16434564022996642207452566708525e-02 1.88342826743810706682097366737594e-04
 	 8.77181597465419904402494921669131e-01 3.25864341463837359214039679500274e-02 3.39799105886768378504553256291842e-04
 	 8.28915613621726499182784664299106e-01 4.53924654216244505278154974803329e-02 5.42844907394470009391607145943226e-04
 	 7.74526916064822601448724981310079e-01 5.98229878406619508535158047379809e-02 7.93697871834108596537926683112119e-04
 	 7.15028680474762423635581853886833e-01 7.56091835236389619989694210744346e-02 1.08338947432966878174631641940096e-03
 	 6.51529254895814258219388648285531e-01 9.24569832609705710702030501124682e-02 1.39825067636020587691358940674036e-03
 	 5.85211517951299109441265500208829e-01 1.10052543234739064192950763754197e-01 1.72078009818111480992708361981158e-03
 	 5.17310845950990860764306944474811e-01 1.28068090831608860646895209356444e-01 2.03083303542608839542538134992355e-03
 	 4.49092100986817455154920253335149e-01 1.46168030209163413157824606969371e-01 2.30704516655215984000104612050563e-03
 	 3.81826069256750166847069749564980e-01 1.64015193728842267884004968436784e-01 2.52838667271028166502744305432770e-03
 	 3.16765788710447360188027232652530e-01 1.81277122754261998949232292943634e-01 2.67573207678228289913002768685146e-03
 	 2.55123206971686999899873171671061e-01 1.97632260819810667840101814363152e-01 2.73332919151752715136716176402842e-03
 	 1.98046604118182756337773753330112e-01 2.12775943865690875256291292316746e-01 2.69005730865100626744701450832054e-03
 	 1.46599200157665476851320818241220e-01 2.26426076146883592521419359400170e-01 2.54037969128029618784414545018535e-03
 	 1.01739343452164066050613655534107e-01 2.38328386681646131606271410419140e-01 2.28491752105962992944188094668334e-03
 	 6.43026411321589996816783241229132e-02 2.48261170447215295808973678504117e-01 1.93060039496744523246363200996711e-03
 	 3.49863283512164002786448691040277e-02 2.56039435561695949417071460629813e-01 1.49038232557921826448854574209690e-03
 	 1.43359334836996588080637593520805e-02 2.61518441301553994371431599574862e-01 9.82571242147684507928229180606650e-04
 	 2.73144600888430844065624114591628e-03 2.64597368067387317402960889012320e-01 4.30413083133309739246319391980933e-04
 	 9.93077485044348451381779341318179e-01 1.42728273691490950558780070878129e-03 4.53413100495991168041370542041157e-06
 	 9.76919663237128976795986545766937e-01 4.75869917723103358353498038013640e-03 2.69302817254769735581809708691026e-05
 	 9.51879593229720044611497087316820e-01 9.92145575943797347617802984132140e-03 7.97170361277168621665437098222640e-05
 	 9.18425724989849201485014873469481e-01 1.68189675637010066511223271845665e-02 1.72572638555911747398549649368249e-04
 	 8.77181597465419904402494921669131e-01 2.53226734555425797568162238349032e-02 3.11347287792293264327425639237390e-04
 	 8.28915613621726499182784664299106e-01 3.52741442666062443578312013414688e-02 4.97391802041549082810667492537959e-04
 	 7.74526916064822601448724981310079e-01 4.64879949557810145943648194588604e-02 7.27240523712300505725092403253029e-04
 	 7.15028680474762423635581853886833e-01 5.87553291657649523482831455112319e-02 9.92675874102102485940779530437794e-04
 	 6.51529254895814258219388648285531e-01 7.18476279204039447456864309060620e-02 1.28117334094327798427181974716405e-03
 	 5.85211517951298998418963037693175e-01 8.55210055437914951070865754445549e-02 1.57669695762583370914067248946822e-03
 	 5.17310845950990971786609406990465e-01 9.95207523976197605541926805017283e-02 1.86078876190334352273836326929768e-03
 	 4.49092100986817399643769022077322e-01 1.13586079470965550797245668945834e-01 2.11387329447444705099456996322260e-03
 	 3.81826069256750277869372212080634e-01 1.27454976321916435555436919457861e-01 2.31668159038902381555158349613066e-03
 	 3.16765788710447360188027232652530e-01 1.40869091838816684614243968098890e-01 2.45168957343464216994122217840868e-03
 	 2.55123206971686999899873171671061e-01 1.53578546905110413511863498570165e-01 2.50446400734811915750333000119099e-03
 	 1.98046604118182756337773753330112e-01 1.65346589366044072200168102426687e-01 2.46481533513340624400034251095803e-03
 	 1.46599200157665476851320818241220e-01 1.75954004734931945819198517710902e-01 2.32767041802137445924425485088705e-03
 	 1.01739343452164066050613655534107e-01 1.85203200939841106098526779533131e-01 2.09359842532389579458640405107417e-03
 	 6.43026411321589996816783241229132e-02 1.92921892671195749358048487920314e-01 1.76894872991262427051883943107669e-03
 	 3.49863283512164002786448691040277e-02 1.98966324125703031278078469767934e-01 1.36559068815586656837901546879266e-03
 	 1.43359334836996588080637593520805e-02 2.03224018373199144527063708665082e-01 9.00299282739515415244224705304532e-04
 	 2.73144600888430844065624114591628e-03 2.05616629259511074501176608464448e-01 3.94374039667221671593561049817822e-04
 	 9.93077485044348451381779341318179e-01 1.05745824486610552617182889889591e-03 4.03153837703159776632150235187169e-06
 	 9.76919663237129087818289008282591e-01 3.52566842549886794166980052978033e-03 2.39451538038418602352078862205431e-05
 	 9.51879593229719933589194624801166e-01 7.35069858447917612309652213298250e-03 7.08806803554072514242032077014244e-05
 	 9.18425724989849201485014873469481e-01 1.24609900059566985897063773336413e-02 1.53443562703127570632025133967602e-04
 	 8.77181597465419904402494921669131e-01 1.87612931446896336051821663204464e-02 2.76835525472522118051871276023235e-04
 	 8.28915613621726499182784664299106e-01 2.61342295542267011310144653180032e-02 4.42257653375663297053155265103896e-04
 	 7.74526916064822601448724981310079e-01 3.44424494753874654850989145415951e-02 6.46628444893073773061531461792129e-04
 	 7.15028680474762423635581853886833e-01 4.35311838707288789596105971213547e-02 8.82641211296760343045508800940979e-04
 	 6.51529254895814258219388648285531e-01 5.32311255180779041573657650587847e-02 1.13915973887664069216785200922004e-03
 	 5.85211517951298998418963037693175e-01 6.33615821746701390893008465354796e-02 1.40192559206253316086976390408836e-03
 	 5.17310845950990971786609406990465e-01 7.37338422418089556309439558390295e-02 1.65452680942745943351579462898826e-03
 	 4.49092100986817399643769022077322e-01 8.41546899797961378553168287908193e-02 1.87955780314541173736664347870828e-03
 	 3.81826069256750222358220980822807e-01 9.44300047040083079252781317336485e-02 2.05988550591041513770917958936479e-03
 	 3.16765788710447360188027232652530e-01 1.04368376887779890083152167790104e-01 2.17992832431567092055235690395421e-03
 	 2.55123206971686999899873171671061e-01 1.13784673813403514053277376660844e-01 2.22685289606173618046081053023499e-03
 	 1.98046604118182756337773753330112e-01 1.22503488386293990508590923127485e-01 2.19159914105176685875098208100553e-03
 	 1.46599200157665476851320818241220e-01 1.30362406979252942740288290224271e-01 2.06965626027766792099926718151437e-03
 	 1.01739343452164066050613655534107e-01 1.37215035776828475633237758302130e-01 1.86153033261570550679908642166538e-03
 	 6.43026411321589996816783241229132e-02 1.42933730468353559217575821094215e-01 1.57286692507180910632902381962595e-03
 	 3.49863283512164002786448691040277e-02 1.47411983943844138167378332582302e-01 1.21421971720599673749685365464757e-03
 	 1.43359334836996588080637593520805e-02 1.50566463269969474936260667163879e-01 8.00504243306588911255339269246178e-04
 	 2.73144600888430844065624114591628e-03 1.52339122633842860565778210002463e-01 3.50659051113465420907583380838446e-04
 	 9.93077485044348562404081803833833e-01 7.34420666973416985667810763516172e-04 3.45047886998561488726021059814109e-06
 	 9.76919663237129087818289008282591e-01 2.44862978671073205916286497085821e-03 2.04939751310382828135801813740358e-05
 	 9.51879593229720044611497087316820e-01 5.10517080304887654884637981922424e-03 6.06647554814086946493693897064503e-05
 	 9.18425724989849201485014873469481e-01 8.65434511079213319995062647649320e-03 1.31327974913707419286207356279306e-04
 	 8.77181597465419904402494921669131e-01 1.30300004671592695171256082176114e-02 2.36935641378570283847176947134017e-04
 	 8.28915613621726499182784664299106e-01 1.81506157744146523480566202124464e-02 3.78515729071574763033025678993226e-04
 	 7.74526916064822601448724981310079e-01 2.39207995575420329092963811490336e-02 5.53430868610015340609831202556279e-04
 	 7.15028680474762534657884316402487e-01 3.02330623905922579730543020559708e-02 7.55427473221870248235032541117562e-04
 	 6.51529254895814258219388648285531e-01 3.69698178595057047601812882930972e-02 9.74974374776086121115181715168774e-04
 	 5.85211517951299109441265500208829e-01 4.40055724820646587680528227792820e-02 1.19986818437916860184688783164120e-03
 	 5.17310845950990971786609406990465e-01 5.12092632126563973571364840609021e-02 1.41606237169385629909301727025195e-03
 	 4.49092100986817455154920253335149e-01 5.84466988119504704535245309671154e-02 1.60865998984858343812121006521920e-03
 	 3.81826069256750222358220980822807e-01 6.55830595427452367474074890196789e-02 1.76299733452290750997104584740782e-03
 	 3.16765788710447360188027232652530e-01 7.24854086078469128651136088592466e-02 1.86573856371736513694303827293197e-03
 	 2.55123206971686999899873171671061e-01 7.90251685483558397038450493710116e-02 1.90589996816172436294722913885380e-03
 	 1.98046604118182756337773753330112e-01 8.50805164970123151135794614674523e-02 1.87572728335173551442172090730764e-03
 	 1.46599200157665476851320818241220e-01 9.05386537452225192978971790580545e-02 1.77135984489366275600186195759989e-03
 	 1.01739343452164066050613655534107e-01 9.52979075847666390330914509831928e-02 1.59323079128348399878534191742574e-03
 	 6.43026411321589996816783241229132e-02 9.92696271206988667401560633152258e-02 1.34617200252363827979451560423740e-03
 	 3.49863283512164002786448691040277e-02 1.02379841562085349693234093138017e-01 1.03921607235796958391971234192397e-03
 	 1.43359334836996588080637593520805e-02 1.04570674932475404794729456625646e-01 6.85128781757237412600169967902275e-04
 	 2.73144600888430844065624114591628e-03 1.05801813541165690146783617819892e-01 3.00119094321282938939154938395859e-04
 	 9.93077485044348562404081803833833e-01 4.64457218795772883157546573329455e-04 2.80226598151010483173182358251907e-06
 	 9.76919663237129087818289008282591e-01 1.54854544777852445869292807856255e-03 1.66439417540505327761969633915129e-05
 	 9.51879593229720044611497087316820e-01 3.22857667177724877438649286887085e-03 4.92681702939653135366916691939565e-05
 	 9.18425724989849201485014873469481e-01 5.47312084397373610489268003220786e-03 1.06656475923537263960153009811904e-04
 	 8.77181597465419904402494921669131e-01 8.24034242231293234670630454274942e-03 1.92424504731197957554597599560964e-04
 	 8.28915613621726499182784664299106e-01 1.14786864002023591968537630236824e-02 3.07407113914072882988187673802827e-04
 	 7.74526916064822601448724981310079e-01 1.51278259633579326148833388288040e-02 4.49462394832720745115051119711325e-04
 	 7.15028680474762312613279391371179e-01 1.91197833953681839425087218842236e-02 6.13511570269841509384090016965274e-04
 	 6.51529254895814258219388648285531e-01 2.33801955127085347996285236149561e-02 7.91814013714131344039148796554173e-04
 	 5.85211517951299109441265500208829e-01 2.78296985987123712824597987491870e-02 9.74458885875181791101640182972687e-04
 	 5.17310845950990971786609406990465e-01 3.23854066721027677999700244981796e-02 1.15003846173698060992296454685402e-03
 	 4.49092100986817399643769022077322e-01 3.69624554410521444225423692842014e-02 1.30645436046036996467767377083646e-03
 	 3.81826069256750222358220980822807e-01 4.14755831434732158413680735975504e-02 1.43179762641094834689503567659585e-03
 	 3.16765788710447360188027232652530e-01 4.58407188131244591744462013593875e-02 1.51523771177839230994699448729079e-03
 	 2.55123206971686999899873171671061e-01 4.99765483862194548336788102460559e-02 1.54785432578610705929567092908883e-03
 	 1.98046604118182756337773753330112e-01 5.38060294909163960852538366452791e-02 1.52334993338152160924359179716703e-03
 	 1.46599200157665476851320818241220e-01 5.72578267511385519128452870063484e-02 1.43858914121657022189282315594028e-03
 	 1.01739343452164066050613655534107e-01 6.02676410187125144446440572210122e-02 1.29392371764524010020747102345240e-03
 	 6.43026411321589996816783241229132e-02 6.27794083101994582207794337591622e-02 1.09327781739148970074904099192281e-03
 	 3.49863283512164002786448691040277e-02 6.47463485316095432864358372171409e-02 8.43987155620351059762129786179230e-04
 	 1.43359334836996588080637593520805e-02 6.61318601597745692188823340984527e-02 5.56419311757666719929493748253435e-04
 	 2.73144600888430844065624114591628e-03 6.69104482903357666856436480884440e-02 2.43738205654237173212670053423778e-04
 	 9.93077485044348451381779341318179e-01 2.52821418471675142536359004452606e-04 2.09953078523653410548911388278093e-06
 	 9.76919663237129087818289008282591e-01 8.42931148083567866047260963568988e-04 1.24700754071466583409793713044245e-05
 	 9.51879593229720044611497087316820e-01 1.75743491708371668558186229347484e-03 3.69129986043343976623992697128074e-05
 	 9.18425724989849201485014873469481e-01 2.97922417661629357343855417639134e-03 7.99098144586665758756088839831477e-05
 	 8.77181597465419904402494921669131e-01 4.48552627797037251067280294591910e-03 1.44169459352795690902648839681888e-04
 	 8.28915613621726499182784664299106e-01 6.24827790472293198575925998738967e-03 2.30317430080461760591448161505923e-04
 	 7.74526916064822601448724981310079e-01 8.23464091776884843376649314450333e-03 3.36748952806010626130628349272911e-04
 	 7.15028680474762312613279391371179e-01 1.04076125061018376349863956420450e-02 4.59658875131548441163309437484941e-04
 	 6.51529254895814258219388648285531e-01 1.27267140103751730251246954139788e-02 5.93247717719734644209461649211335e-04
 	 5.85211517951299109441265500208829e-01 1.51487447942098563125057353317970e-02 7.30090021197675855327280380890898e-04
 	 5.17310845950990971786609406990465e-01 1.76285869209911183475014695432037e-02 8.61638820352696654589208513641552e-04
 	 4.49092100986817399643769022077322e-01 2.01200455857527549241581255046185e-02 9.78829692610020838869355763733893e-04
 	 3.81826069256750222358220980822807e-01 2.25767096256147548061221641546581e-02 1.07274013770043111400120938725422e-03
 	 3.16765788710447360188027232652530e-01 2.49528160723697656209196793497540e-02 1.13525562663246613014089714255306e-03
 	 2.55123206971686999899873171671061e-01 2.72041026428272436632482822460588e-02 1.15969284482346458517443288371851e-03
 	 1.98046604118182756337773753330112e-01 2.92886322953326283524688733450603e-02 1.14133351470762050942908683026644e-03
 	 1.46599200157665476851320818241220e-01 3.11675745192658837368071544915438e-02 1.07782851778528976360860269778641e-03
 	 1.01739343452164066050613655534107e-01 3.28059288857612818546272137609776e-02 9.69441408085012644620104271808714e-04
 	 6.43026411321589996816783241229132e-02 3.41731776738217751798742938262876e-02 8.19112264708253350574407303241742e-04
 	 3.49863283512164002786448691040277e-02 3.52438567303670069463805702980608e-02 6.32337196847477297362294379468040e-04
 	 1.43359334836996588080637593520805e-02 3.59980424787335051561854015744757e-02 4.16883865501520821123665472285325e-04
 	 2.73144600888430844065624114591628e-03 3.64218570898704463445483270334080e-02 1.82615022872888220582116014512053e-04
 	 9.93077485044348451381779341318179e-01 1.03628325749502599173457184633662e-04 1.35603218724924790763856127101539e-06
 	 9.76919663237129087818289008282591e-01 3.45506896235504845638075721581117e-04 8.05409653834205100026485263375875e-06
 	 9.51879593229719933589194624801166e-01 7.20350511329424791906461678081541e-04 2.38411432627432357488333342088183e-05
 	 9.18425724989849201485014873469481e-01 1.22114659161987049174058483913541e-03 5.16116654468866514738310813381617e-05
 	 8.77181597465419904402494921669131e-01 1.83856091426663759147430710072513e-03 9.31152944626568730267929252519821e-05
 	 8.28915613621726499182784664299106e-01 2.56109067814835889009827951667830e-03 1.48756022378804237229002471742945e-04
 	 7.74526916064822601448724981310079e-01 3.37527594226491589601835130451946e-03 2.17497367620633758186418638125303e-04
 	 7.15028680474762534657884316402487e-01 4.26594971888333285292560503876302e-03 2.96881681476720952778808326755211e-04
 	 6.51529254895814258219388648285531e-01 5.21652031366831581138399087649304e-03 3.83163231469113736964854366462419e-04
 	 5.85211517951299109441265500208829e-01 6.20928032806816743160993610217702e-03 4.71546107013618982610470009575465e-04
 	 5.17310845950990971786609406990465e-01 7.22573648623270337054691481171176e-03 5.56510046148285140651945646084187e-04
 	 4.49092100986817399643769022077322e-01 8.24695411749232221154670696705580e-03 6.32200574694092199030948098226190e-04
 	 3.81826069256750222358220980822807e-01 9.25390986878460442000005059526302e-03 6.92854882388443363457064538835084e-04
 	 3.16765788710447360188027232652530e-01 1.02278460739063659090675173501950e-02 7.33232006548550983675294201447059e-04
 	 2.55123206971686999899873171671061e-01 1.11506201786051306612534972373396e-02 7.49015368558216942246330560806200e-04
 	 1.98046604118182756337773753330112e-01 1.20050427159444916824782012554351e-02 7.37157555970527648622758754015649e-04
 	 1.46599200157665476851320818241220e-01 1.27751975470632439524365508987103e-02 6.96141334401696059742958855309780e-04
 	 1.01739343452164066050613655534107e-01 1.34467384355316799116053516627289e-02 6.26136926526375163851168004214287e-04
 	 6.43026411321589996816783241229132e-02 1.40071565506036943560275176423602e-02 5.29043252771300076195415407198652e-04
 	 3.49863283512164002786448691040277e-02 1.44460144555849101521971533657052e-02 4.08410106748465699753186664011650e-04
 	 1.43359334836996588080637593520805e-02 1.47551457265024943410480773309246e-02 2.69254418149082166891034040290265e-04
 	 2.73144600888430844065624114591628e-03 1.49288620154379714222159236669540e-02 1.17946281441639225337665586312852e-04
 	 9.93077485044348562404081803833833e-01 1.97479086631409048169238928949198e-05 5.87300969910334253155589651768098e-07
 	 9.76919663237129087818289008282591e-01 6.58414442189989013165529740945203e-05 3.48824958079723945658027865757145e-06
 	 9.51879593229720044611497087316820e-01 1.37273433690007773400054702506168e-04 1.03256594449897714832649342486803e-05
 	 9.18425724989849201485014873469481e-01 2.32707526452838320274452144076349e-04 2.23531428388378960883751261912167e-05
 	 8.77181597465419904402494921669131e-01 3.50364948424664035542264173272997e-04 4.03284695345900186095634831762169e-05
 	 8.28915613621726610205087126814760e-01 4.88053670888721757847861226764508e-04 6.44266095189795960857317980163828e-05
 	 7.74526916064822601448724981310079e-01 6.43208703205999654528568498790264e-04 9.41986600005859033186983442220708e-05
 	 7.15028680474762423635581853886833e-01 8.12939751759556017418617557268590e-04 1.28580207106721738398447119067214e-04
 	 6.51529254895814258219388648285531e-01 9.94085024038304787552533525740728e-04 1.65948964627655982332493644904048e-04
 	 5.85211517951299109441265500208829e-01 1.18327011360713774124064912030008e-03 2.04227811559783698543840690931006e-04
 	 5.17310845950990971786609406990465e-01 1.37697085349980374857636888918933e-03 2.41025908485797323238877809536973e-04
 	 4.49092100986817399643769022077322e-01 1.57157896244541905872438292135485e-03 2.73807667831903103067281435301084e-04
 	 3.81826069256750222358220980822807e-01 1.76346925943238197476148343412206e-03 3.00077201898342384861484433145051e-04
 	 3.16765788710447360188027232652530e-01 1.94906719400644856676763083669357e-03 3.17564636492004065057570549868160e-04
 	 2.55123206971686999899873171671061e-01 2.12491543438386720765720383496955e-03 3.24400450496925541431225692434737e-04
 	 1.98046604118182756337773753330112e-01 2.28773827365169601932848308933899e-03 3.19264801874976722560056652255867e-04
 	 1.46599200157665476851320818241220e-01 2.43450265637623619596752178040333e-03 3.01500572577221594410684657461275e-04
 	 1.01739343452164066050613655534107e-01 2.56247469522885573667281278176233e-03 2.71181486474571730675015013289908e-04
 	 6.43026411321589996816783241229132e-02 2.66927064768263111460555592202581e-03 2.29129970806506020252965583061666e-04
 	 3.49863283512164002786448691040277e-02 2.75290150595408622535842368961312e-03 1.76883450164350153072795324149524e-04
 	 1.43359334836996588080637593520805e-02 2.81181103728977976885516909533180e-03 1.16614769485949288903639531334022e-04
 	 2.73144600888430844065624114591628e-03 2.84491524294383513193906765081920e-03 5.10828327965490237350977553720810e-05
 	 ];
 
 	 case  43 

 	 % ALG. DEG.:   43
 	 % PTS CARD.:  484
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 9.93077485044348562404081803833833e-01 6.90276704698835133489076554269559e-03 5.87300969910343041122417415134116e-07
 	 9.76919663237129087818289008282591e-01 2.30144953186519653220987180475277e-02 3.48824958079729154910653479704230e-06
 	 9.51879593229720044611497087316820e-01 4.79831333365900031262540892385005e-02 1.03256594449899256432613345313420e-05
 	 9.18425724989849201485014873469481e-01 8.13415674836979601947106743864424e-02 2.23531428388382315134222388941510e-05
 	 8.77181597465419904402494921669131e-01 1.22468037586155417684175006343139e-01 4.03284695345906216970219282380583e-05
 	 8.28915613621726388160482201783452e-01 1.70596332707384779059367474474129e-01 6.44266095189805583151598789015679e-05
 	 7.74526916064822601448724981310079e-01 2.24829875231971398896746450191131e-01 9.41986600005873127815225753778350e-05
 	 7.15028680474762534657884316402487e-01 2.84158379773477964835848297298071e-01 1.28580207106723635752248968699973e-04
 	 6.51529254895814258219388648285531e-01 3.47476660080147436993058818188729e-01 1.65948964627658475997490361564246e-04
 	 5.85211517951299109441265500208829e-01 4.13605211935093752817493850670871e-01 2.04227811559786761414977962481032e-04
 	 5.17310845950990971786609406990465e-01 4.81312183195509224464814224120346e-01 2.41025908485800928211101323839216e-04
 	 4.49092100986817399643769022077322e-01 5.49336320050737181297506595001323e-01 2.73807667831907168825428255942711e-04
 	 3.81826069256750222358220980822807e-01 6.16410461483817284644715073227417e-01 3.00077201898346884300500247988452e-04
 	 3.16765788710447360188027232652530e-01 6.81285144095546080222902673995122e-01 3.17564636492008781337020861812448e-04
 	 2.55123206971686999899873171671061e-01 7.42751877593929132892469624493970e-01 3.24400450496930420341001877204690e-04
 	 1.98046604118182756337773753330112e-01 7.99665657608165436620595301064895e-01 3.19264801874981493049615588475376e-04
 	 1.46599200157665476851320818241220e-01 8.50966297185958175930409197462723e-01 3.01500572577226148059809096579897e-04
 	 1.01739343452164066050613655534107e-01 8.95698181852607078212713531684130e-01 2.71181486474575796433161833931536e-04
 	 6.43026411321589996816783241229132e-02 9.33028088220158258181413657439407e-01 2.29129970806509435489808912400633e-04
 	 3.49863283512164002786448691040277e-02 9.62260770142829402473694244690705e-01 1.76883450164352782263063601497777e-04
 	 1.43359334836996588080637593520805e-02 9.82852255479010450400778609036934e-01 1.16614769485951037179642664209922e-04
 	 2.73144600888430844065624114591628e-03 9.94423638748171745405102228687610e-01 5.10828327965497826766184952251848e-05
 	 9.93077485044348451381779341318179e-01 6.81888662990198790581075627414975e-03 1.35603218724930000016481741048624e-06
 	 9.76919663237129087818289008282591e-01 2.27348298666354559083302433464269e-02 8.05409653834236101432354770768285e-06
 	 9.51879593229719933589194624801166e-01 4.74000562589505722299598744484683e-02 2.38411432627441539325481578703858e-05
 	 9.18425724989849201485014873469481e-01 8.03531284185309002676689260624698e-02 5.16116654468886301427958673837537e-05
 	 8.77181597465419904402494921669131e-01 1.20979841620313430250455155601230e-01 9.31152944626604508939621274166143e-05
 	 8.28915613621726499182784664299106e-01 1.68523295700125114171541440555302e-01 1.48756022378809929290408020641223e-04
 	 7.74526916064822601448724981310079e-01 2.22097807992912427144105436127575e-01 2.17497367620642106543146776509445e-04
 	 7.15028680474762423635581853886833e-01 2.80705369806354188000341309816577e-01 2.96881681476732391111728048826990e-04
 	 6.51529254895814258219388648285531e-01 3.43254224790517370458076129580149e-01 3.83163231469128427904291545047499e-04
 	 5.85211517951298998418963037693175e-01 4.08579201720632667615973332431167e-01 4.71546107013637088786750517499513e-04
 	 5.17310845950990971786609406990465e-01 4.75463417562776213820541215682169e-01 5.56510046148306607854960859071980e-04
 	 4.49092100986817399643769022077322e-01 5.42660944895690056100079345924314e-01 6.32200574694116485159611773525512e-04
 	 3.81826069256750222358220980822807e-01 6.08920020874465062199476506066276e-01 6.92854882388470034830507682244161e-04
 	 3.16765788710447360188027232652530e-01 6.73006365215646051858300324965967e-01 7.33232006548579172931778824562343e-04
 	 2.55123206971686999899873171671061e-01 7.33726172849707647394268406060291e-01 7.49015368558245673603901426673701e-04
 	 1.98046604118182756337773753330112e-01 7.89948353165872529935143120383145e-01 7.37157555970555946299460625681377e-04
 	 1.46599200157665476851320818241220e-01 8.40625602295271057151637705828762e-01 6.96141334401722731116401998718857e-04
 	 1.01739343452164066050613655534107e-01 8.84813918112304031993176067771856e-01 6.26136926526399124719179933862279e-04
 	 6.43026411321589996816783241229132e-02 9.21690202317236972895386770687765e-01 5.29043252771320350776040886131568e-04
 	 3.49863283512164002786448691040277e-02 9.50567657193198467524553052498959e-01 4.08410106748481420684687703825944e-04
 	 1.43359334836996588080637593520805e-02 9.70908920789797513783980775770033e-01 2.69254418149092521021781276857610e-04
 	 2.73144600888430844065624114591628e-03 9.82339691975677387070220447640168e-01 1.17946281441643765434262869362669e-04
 	 9.93077485044348451381779341318179e-01 6.66969353717981796453306841954145e-03 2.09953078523652055296195781397550e-06
 	 9.76919663237129087818289008282591e-01 2.22374056147873998268149620116674e-02 1.24700754071465770258164348915919e-05
 	 9.51879593229720044611497087316820e-01 4.63629718531962942140722816475318e-02 3.69129986043341604931740385087124e-05
 	 9.18425724989849201485014873469481e-01 7.85950508335344910637587645396707e-02 7.99098144586660608795769533685416e-05
 	 8.77181597465419904402494921669131e-01 1.18332876256609723086832275384950e-01 1.44169459352794769330802227003119e-04
 	 8.28915613621726499182784664299106e-01 1.64836108473550568831456075713504e-01 2.30317430080460242708406681799715e-04
 	 7.74526916064822601448724981310079e-01 2.17238443017408550117508525545418e-01 3.36748952806008403516174753988821e-04
 	 7.15028680474762312613279391371179e-01 2.74563707019135738729431750471122e-01 4.59658875131545459607335102347747e-04
 	 6.51529254895814258219388648285531e-01 3.35744031093810513244335425042664e-01 5.93247717719730849501857949945816e-04
 	 5.85211517951298998418963037693175e-01 3.99639737254491089757379995717201e-01 7.30090021197671084837721444671388e-04
 	 5.17310845950990971786609406990465e-01 4.65060567128017965377040354724159e-01 8.61638820352691016737911589018495e-04
 	 4.49092100986817399643769022077322e-01 5.30787853427429845432072852418059e-01 9.78829692610014333656320850707289e-04
 	 3.81826069256750222358220980822807e-01 5.95597221117635022835656855022535e-01 1.07274013770042417510730548002584e-03
 	 3.16765788710447360188027232652530e-01 6.58281395217182874191053087997716e-01 1.13525562663245875756612424112291e-03
 	 2.55123206971686999899873171671061e-01 7.17672690385485645414576083567226e-01 1.15969284482345699575922548518747e-03
 	 1.98046604118182756337773753330112e-01 7.72664763586484504287454910809174e-01 1.14133351470761313685431392883629e-03
 	 1.46599200157665476851320818241220e-01 8.22233225323068528389569564751582e-01 1.07782851778528282471469879055803e-03
 	 1.01739343452164066050613655534107e-01 8.65454727662074652094759130704915e-01 9.69441408085006356247503855882997e-04
 	 6.43026411321589996816783241229132e-02 9.01524181194019114116144919535145e-01 8.19112264708248037983762124270015e-04
 	 3.49863283512164002786448691040277e-02 9.29769814918416481752672098082257e-01 6.32337196847473177394038934551190e-04
 	 1.43359334836996588080637593520805e-02 9.49666024037566836035750839073444e-01 4.16883865501518110618234258524240e-04
 	 2.73144600888430844065624114591628e-03 9.60846696901245134192492969305022e-01 1.82615022872887055064780592594786e-04
 	 9.93077485044348562404081803833833e-01 6.45805773685572022391188085066460e-03 2.80226598151009763195177192096619e-06
 	 9.76919663237129087818289008282591e-01 2.15317913150924432341692948966738e-02 1.66439417540504887304837061678953e-05
 	 9.51879593229720044611497087316820e-01 4.48918300985027621252676510721358e-02 4.92681702939651847876836865403050e-05
 	 9.18425724989849201485014873469481e-01 7.61011541661770485323046386838541e-02 1.06656475923536992909609888435796e-04
 	 8.77181597465419904402494921669131e-01 1.14578060112267149373010965973663e-01 1.92424504731197469663619981083968e-04
 	 8.28915613621726610205087126814760e-01 1.59605699978071113864785957048298e-01 3.07407113914072069836558309674501e-04
 	 7.74526916064822601448724981310079e-01 2.10345257971819438180816064232204e-01 4.49462394832719606702770009931669e-04
 	 7.15028680474762312613279391371179e-01 2.65851536129869392421909424228943e-01 6.13511570269839883080831288708623e-04
 	 6.51529254895814258219388648285531e-01 3.25090549591477206980982828099513e-01 7.91814013714129284055021074095748e-04
 	 5.85211517951299109441265500208829e-01 3.86958783449988519276274701041984e-01 9.74458885875179297436643466312489e-04
 	 5.17310845950990971786609406990465e-01 4.50303747376906315924571799769183e-01 1.15003846173697757415688158744160e-03
 	 4.49092100986817399643769022077322e-01 5.13945443572130455933688608638477e-01 1.30645436046036649523072181722227e-03
 	 3.81826069256750222358220980822807e-01 5.76698347599776561800410945579642e-01 1.43179762641094466060764922588078e-03
 	 3.16765788710447360188027232652530e-01 6.37393492476428180637526565988082e-01 1.51523771177838840681917353947483e-03
 	 2.55123206971686999899873171671061e-01 6.94900244642093545266448018082883e-01 1.54785432578610315616784998127287e-03
 	 1.98046604118182756337773753330112e-01 7.48147366390900847576972410024609e-01 1.52334993338151770611577084935107e-03
 	 1.46599200157665476851320818241220e-01 7.96142973091195971235833894752432e-01 1.43858914121656653560543670522520e-03
 	 1.01739343452164066050613655534107e-01 8.37993015529123419504742287244881e-01 1.29392371764523663076051906983821e-03
 	 6.43026411321589996816783241229132e-02 8.72917950557641542097542242117925e-01 1.09327781739148688182339252961128e-03
 	 3.49863283512164002786448691040277e-02 9.00267323117174056434919293678831e-01 8.43987155620348891357784815170362e-04
 	 1.43359334836996588080637593520805e-02 9.19532206356525771973053906549467e-01 5.56419311757665310466669517097671e-04
 	 2.73144600888430844065624114591628e-03 9.30358105700779813851397648249986e-01 2.43738205654236549796420874258729e-04
 	 9.93077485044348562404081803833833e-01 6.18809428867807525403987867207434e-03 3.45047886998562589868852490404549e-06
 	 9.76919663237128976795986545766937e-01 2.06317069761602321642524060507640e-02 2.04939751310383471880841727008615e-05
 	 9.51879593229720044611497087316820e-01 4.30152359672311274119138602145540e-02 6.06647554814088911610131527041290e-05
 	 9.18425724989849201485014873469481e-01 7.29199298993586653150345000540256e-02 1.31327974913707852967076350481079e-04
 	 8.77181597465419904402494921669131e-01 1.09788402067420826080379470113257e-01 2.36935641378571042788697686987121e-04
 	 8.28915613621726499182784664299106e-01 1.52933770603858820713583099859534e-01 3.78515729071575955655415413048104e-04
 	 7.74526916064822712471027443825733e-01 2.01552284377635337886403021911974e-01 5.53430868610017075333307179363374e-04
 	 7.15028680474762423635581853886833e-01 2.54738257134645262880212612799369e-01 7.55427473221872633479812009227317e-04
 	 6.51529254895814258219388648285531e-01 3.11500927244680037020430063421372e-01 9.74974374776089265301481923131632e-04
 	 5.85211517951298998418963037693175e-01 3.70782909566636287301832908269716e-01 1.19986818437917250497470877945716e-03
 	 5.17310845950990971786609406990465e-01 4.31479890836352630856254108948633e-01 1.41606237169386085274214170937057e-03
 	 4.49092100986817399643769022077322e-01 4.92461200201232074391555215697736e-01 1.60865998984858864229163799564049e-03
 	 3.81826069256750222358220980822807e-01 5.52590871200504429872069067641860e-01 1.76299733452291314782234277203088e-03
 	 3.16765788710447360188027232652530e-01 6.10748802681705615924556695972569e-01 1.86573856371737120847520419175680e-03
 	 2.55123206971686999899873171671061e-01 6.65851624479957049373979316442274e-01 1.90589996816173065131982955477952e-03
 	 1.98046604118182756337773753330112e-01 7.16872879384804928548646785202436e-01 1.87572728335174158595388682613248e-03
 	 1.46599200157665476851320818241220e-01 7.62862146097111892828479540185072e-01 1.77135984489366839385315888222294e-03
 	 1.01739343452164066050613655534107e-01 8.02962748963069183893992430967046e-01 1.59323079128348898611533535074614e-03
 	 6.43026411321589996816783241229132e-02 8.36427731747142022555863150046207e-01 1.34617200252364261660320554625514e-03
 	 3.49863283512164002786448691040277e-02 8.62633830086698250028121037757955e-01 1.03921607235797305336666429553816e-03
 	 1.43359334836996588080637593520805e-02 8.81093391583824825374904321506619e-01 6.85128781757239581004514938911143e-04
 	 2.73144600888430844065624114591628e-03 8.91466740449949890390257678518537e-01 3.00119094321283914721110175349850e-04
 	 9.93077485044348451381779341318179e-01 5.86505671078539018298281249030879e-03 4.03153837703158590786024079166694e-06
 	 9.76919663237129087818289008282591e-01 1.95546683373721066900863263526844e-02 2.39451538038417890844403168593146e-05
 	 9.51879593229720044611497087316820e-01 4.07697081858008555932393335297093e-02 7.08806803554070345837687106005376e-05
 	 9.18425724989849201485014873469481e-01 6.91132850041941276808543648257910e-02 1.53443562703127136951156139765828e-04
 	 8.77181597465420015424797384184785e-01 1.04057109389890489747898527639336e-01 2.76835525472521304900241911894909e-04
 	 8.28915613621726499182784664299106e-01 1.44950156824046855197352101640718e-01 4.42257653375662050220656906773797e-04
 	 7.74526916064822490426422518794425e-01 1.91030634459790016332902951035067e-01 6.46628444893071929917838236434591e-04
 	 7.15028680474762534657884316402487e-01 2.41440135654508780671534395878552e-01 8.82641211296757740960294835730338e-04
 	 6.51529254895814258219388648285531e-01 2.95239619586107948645548049171339e-01 1.13915973887663743956133455270674e-03
 	 5.85211517951299109441265500208829e-01 3.51426899874030918002887347029173e-01 1.40192559206252904090150845917151e-03
 	 5.17310845950990971786609406990465e-01 4.08955311807200294627051562201814e-01 1.65452680942745466302623569276875e-03
 	 4.49092100986817399643769022077322e-01 4.66753209033386684545519074163167e-01 1.87955780314540631635578105118611e-03
 	 3.81826069256750222358220980822807e-01 5.23743926039241691761105812474852e-01 2.05988550591040906617701367053996e-03
 	 3.16765788710447360188027232652530e-01 5.78865834401772971773425524588674e-01 2.17992832431566441533932199092760e-03
 	 2.55123206971686999899873171671061e-01 6.31092119214909708091454376699403e-01 2.22685289606172967524777561720839e-03
 	 1.98046604118182756337773753330112e-01 6.79449907495523475198240248573711e-01 2.19159914105176035353794716797893e-03
 	 1.46599200157665476851320818241220e-01 7.23038392863081802452995816565817e-01 2.06965626027766184946710126268954e-03
 	 1.01739343452164066050613655534107e-01 7.61045620771007791383055973710725e-01 1.86153033261570008578822399414321e-03
 	 6.43026411321589996816783241229132e-02 7.92763628399487663145350779814180e-01 1.57286692507180455267989938050732e-03
 	 3.49863283512164002786448691040277e-02 8.17601687704939794620884185860632e-01 1.21421971720599326804990170103338e-03
 	 1.43359334836996588080637593520805e-02 8.35097603246331199322582961031003e-01 8.00504243306586634430777049686867e-04
 	 2.73144600888430844065624114591628e-03 8.44929431357273164060472936398583e-01 3.50659051113464390915519519609234e-04
 	 9.93077485044348451381779341318179e-01 5.49523221873658273411988872680922e-03 4.53413100495989812788654935160615e-06
 	 9.76919663237128976795986545766937e-01 1.83216375856399341093272425951000e-02 2.69302817254768922430180344562700e-05
 	 9.51879593229720044611497087316820e-01 3.81989510108420304845822101924568e-02 7.97170361277166317735820566525717e-05
 	 9.18425724989849201485014873469481e-01 6.47553074464497779860749915314955e-02 1.72572638555911232402517718753643e-04
 	 8.77181597465419904402494921669131e-01 9.74957290790375019629010466815089e-02 3.11347287792292342755579026558621e-04
 	 8.28915613621726499182784664299106e-01 1.35810242111667228703808518730511e-01 4.97391802041547564927626012831752e-04
 	 7.74526916064822601448724981310079e-01 1.78985088979396356201334583602147e-01 7.27240523712298337320747432244161e-04
 	 7.15028680474762423635581853886833e-01 2.26215990359472596260559384973021e-01 9.92675874102099667015131068126266e-04
 	 6.51529254895814258219388648285531e-01 2.76623117183781741523773689550580e-01 1.28117334094327429798443329644897e-03
 	 5.85211517951299109441265500208829e-01 3.29267476504909395451647924346616e-01 1.57669695762582915549154805034959e-03
 	 5.17310845950990971786609406990465e-01 3.83168401651389212148046681249980e-01 1.86078876190333810172750084177551e-03
 	 4.49092100986817455154920253335149e-01 4.37321819542216994047834077719017e-01 2.11387329447444054578153505019600e-03
 	 3.81826069256750222358220980822807e-01 4.90718954421333286575190868461505e-01 2.31668159038901687665767958890228e-03
 	 3.16765788710447360188027232652530e-01 5.42365119450735844175426336732926e-01 2.45168957343463523104731827118030e-03
 	 2.55123206971686999899873171671061e-01 5.91298246123202475565960867243120e-01 2.50446400734811178492855709976084e-03
 	 1.98046604118182756337773753330112e-01 6.36606806515773060439755681727547e-01 2.46481533513339887142556960952788e-03
 	 1.46599200157665476851320818241220e-01 6.77446795107402466307178201532224e-01 2.32767041802136752035035094365867e-03
 	 1.01739343452164066050613655534107e-01 7.13057455607994716828557102417108e-01 2.09359842532388928937336913804756e-03
 	 6.43026411321589996816783241229132e-02 7.42775466196645139937970725441119e-01 1.76894872991261906634841150065540e-03
 	 3.49863283512164002786448691040277e-02 7.66047347523080457420974198612384e-01 1.36559068815586266525119452097670e-03
 	 1.43359334836996588080637593520805e-02 7.82440048143101085642570069467183e-01 9.00299282739512704738793491543447e-04
 	 2.73144600888430844065624114591628e-03 7.91651924731604506035864687873982e-01 3.94374039667220478971171315762945e-04
 	 9.93077485044348451381779341318179e-01 5.08581888181857972447419413697389e-03 4.94847304559358934158974641093209e-06
 	 9.76919663237129087818289008282591e-01 1.69566137826124146981143780976709e-02 2.93912489698657642235926634732834e-05
 	 9.51879593229720044611497087316820e-01 3.53530003071042056572714784579148e-02 8.70018100758659137638345582033139e-05
 	 9.18425724989849312507317335985135e-01 5.99308186078511551109215815813513e-02 1.88342826743808375647426522903061e-04
 	 8.77181597465419793380192459153477e-01 9.02319683881964151872523416386684e-02 3.39799105886764150116080562824550e-04
 	 8.28915613621726610205087126814760e-01 1.25691920956649105800551069478388e-01 5.42844907394463287338137735815735e-04
 	 7.74526916064822601448724981310079e-01 1.65650096094515530964486060838681e-01 7.93697871834098730298157065021769e-04
 	 7.15028680474762423635581853886833e-01 2.09362136001598697632175571925472e-01 1.08338947432965533763937759914597e-03
 	 6.51529254895814258219388648285531e-01 2.56013761843215281732710764117655e-01 1.39825067636018852967882963866941e-03
 	 5.85211517951299109441265500208829e-01 3.04735938813961992899237429810455e-01 1.72078009818109355956450290392468e-03
 	 5.17310845950990860764306944474811e-01 3.54621063217400389611100308684399e-01 2.03083303542606324193497968622069e-03
 	 4.49092100986817399643769022077322e-01 4.04739868804019353731860064726789e-01 2.30704516655213121706369250318858e-03
 	 3.81826069256750166847069749564980e-01 4.54158737014407731802378975771717e-01 2.52838667271025000632400647759823e-03
 	 3.16765788710447360188027232652530e-01 5.01957088535290862907345399435144e-01 2.67573207678224993938398412751667e-03
 	 2.55123206971686888877570709155407e-01 5.47244532208502665326932401512749e-01 2.73332919151749332425938021629008e-03
 	 1.98046604118182756337773753330112e-01 5.89177452016126590450539879384451e-01 2.69005730865097287402010195478397e-03
 	 1.46599200157665476851320818241220e-01 6.26974723695451152671864747389918e-01 2.54037969128026452914070887345588e-03
 	 1.01739343452164066050613655534107e-01 6.59932269866190135410022321593715e-01 2.28491752105960174018539632356806e-03
 	 6.43026411321589996816783241229132e-02 6.87436188420626037576255384919932e-01 1.93060039496742138001583732886957e-03
 	 3.49863283512164002786448691040277e-02 7.08974236087087872348888595297467e-01 1.49038232557919983305161348852153e-03
 	 1.43359334836996588080637593520805e-02 7.24145625214746679887412028620020e-01 9.82571242147672364863897342956989e-04
 	 2.73144600888430844065624114591628e-03 7.32671185923728707223290257388726e-01 4.30413083133304426655674213009206e-04
 	 9.93077485044348562404081803833833e-01 4.64478539482495855067467616095200e-03 5.26649927191877229558109735352289e-06
 	 9.76919663237128976795986545766937e-01 1.54861653301745019750690346427291e-02 3.12801524580222999158581054235384e-05
 	 9.51879593229719933589194624801166e-01 3.22872487804683611090084127681621e-02 9.25932030342504900407435419751323e-05
 	 9.18425724989849312507317335985135e-01 5.47337208497116756156231076602126e-02 2.00447158300810123398791318116707e-04
 	 8.77181597465419904402494921669131e-01 8.24072069129480888616257061585202e-02 3.61637161052097649924924605002730e-04
 	 8.28915613621726499182784664299106e-01 1.14792133238173485465516421299981e-01 5.77732218245278583527990701185217e-04
 	 7.74526916064822601448724981310079e-01 1.51285203989811045666158406675095e-01 8.44706887483177197920025669475308e-04
 	 7.15028680474762534657884316402487e-01 1.91206610798900056291671489816508e-01 1.15301625879163957381912108957067e-03
 	 6.51529254895814258219388648285531e-01 2.33812687694130882931631276733242e-01 1.48811281806780770775588962351321e-03
 	 5.85211517951298998418963037693175e-01 2.78309761077302542098266258108197e-01 1.83137041481367919895650864248182e-03
 	 5.17310845950990971786609406990465e-01 3.23868933087231358758373289674637e-01 2.16134969391896473306369230726887e-03
 	 4.49092100986817344132617790819495e-01 3.69641521849094323304285580888973e-01 2.45531330129192867234300123868707e-03
 	 3.81826069256750222358220980822807e-01 4.14774870603014655934259735658998e-01 2.69087988320251218082868049918943e-03
 	 3.16765788710447360188027232652530e-01 4.58428231094200833162233266193653e-01 2.84769481502410810522252226917317e-03
 	 2.55123206971686999899873171671061e-01 4.99788425357956200834053106518695e-01 2.90899355506430866077915986522839e-03
 	 1.98046604118182756337773753330112e-01 5.38084994309930619849069444171619e-01 2.86294069441186743371630107901638e-03
 	 1.46599200157665476851320818241220e-01 5.72604551443192333337606214627158e-01 2.70364366366269504374231225085623e-03
 	 1.01739343452164066050613655534107e-01 6.02704075759791457755909505067393e-01 2.43176356629247209656385919629429e-03
 	 6.43026411321589996816783241229132e-02 6.27822901689435663996619041427039e-01 2.05467534748234341088202192793233e-03
 	 3.49863283512164002786448691040277e-02 6.47493206818047339901056602684548e-01 1.58616554242581135614198473149372e-03
 	 1.43359334836996588080637593520805e-02 6.61348959112190715181611722073285e-01 1.04571868608780349160780609452104e-03
 	 2.73144600888430844065624114591628e-03 6.69135197824964889079524255066644e-01 4.58074676382106728278476026616772e-04
 	 9.93077485044348451381779341318179e-01 4.18071593404440410013389595178523e-03 5.48201942757658426972960583056782e-06
 	 9.76919663237128976795986545766937e-01 1.39389127052545868518107496925040e-02 3.25602254208534313000174276186982e-05
 	 9.51879593229719933589194624801166e-01 2.90613675269805991907556830255999e-02 9.63823807214481148184989645066878e-05
 	 9.18425724989849201485014873469481e-01 4.92651693102715351746390126663755e-02 2.08650027137895774723141961715100e-04
 	 8.77181597465419904402494921669131e-01 7.41737440452918395106252091864008e-02 3.76436384068642570111667966514801e-04
 	 8.28915613621726499182784664299106e-01 1.03323029965276994013301248287462e-01 6.01374666705998032166513578289369e-04
 	 7.74526916064822601448724981310079e-01 1.36170007684326299646215829852736e-01 8.79274700080495403946290178254230e-04
 	 7.15028680474762312613279391371179e-01 1.72102789797829502926873601609259e-01 1.20020096930622491987472599817011e-03
 	 6.51529254895814258219388648285531e-01 2.10452011434952152013622139747895e-01 1.54901063455407310247291530203029e-03
 	 5.85211517951299109441265500208829e-01 2.50503296456351831622555437206756e-01 1.90631531017753145205995135569310e-03
 	 5.17310845950990860764306944474811e-01 2.91510563783706433405029656569241e-01 2.24979828156961257981660828875192e-03
 	 4.49092100986817399643769022077322e-01 3.32709924983987215263425696321065e-01 2.55579171732526816071540132213613e-03
 	 3.81826069256750166847069749564980e-01 3.73333913877538392522836829812150e-01 2.80099835495025263967794337816031e-03
 	 3.16765788710447415699178463910357e-01 4.12625782988094769176967702151160e-01 2.96423060058329532542864548361194e-03
 	 2.55123206971686944388721940413234e-01 4.49853600528666131008748152453336e-01 3.02803785971995443118687241224052e-03
 	 1.98046604118182756337773753330112e-01 4.84323885466940051713891079998575e-01 2.98010038479456975529791051826578e-03
 	 1.46599200157665476851320818241220e-01 5.15394527116815881484512829047162e-01 2.81428446567377147508048906843214e-03
 	 1.01739343452164066050613655534107e-01 5.42486749947555635387175243522506e-01 2.53127826007109755709900689168990e-03
 	 6.43026411321589996816783241229132e-02 5.65095905566576184320126685634023e-01 2.13875851693739712014452614141646e-03
 	 3.49863283512164002786448691040277e-02 5.82800912598833598110559250926599e-01 1.65107595576725668315432038468771e-03
 	 1.43359334836996588080637593520805e-02 5.95272309976813129850370387430303e-01 1.08851247421222767537696274331438e-03
 	 2.73144600888430844065624114591628e-03 6.02280610573227348503166922455421e-01 4.76820397298309355503531659081773e-04
 	 9.93077485044348562404081803833833e-01 3.70264305910176843780745592482617e-03 5.59083854775404066498678892771501e-06
 	 9.76919663237129087818289008282591e-01 1.23449713383440295988435764229507e-02 3.32065520400648585145134128460143e-05
 	 9.51879593229719933589194624801166e-01 2.57381444851443909327404213627233e-02 9.82955891675832844336588300926394e-05
 	 9.18425724989849201485014873469481e-01 4.36316028354709409264877706391417e-02 2.12791769552001972746341218467592e-04
 	 8.77181597465419904402494921669131e-01 6.56918343388154246653698464797344e-02 3.83908717331649888132583114952467e-04
 	 8.28915613621726388160482201783452e-01 9.15078435803224343736417267791694e-02 6.13312067328616178363276389973180e-04
 	 7.74526916064822601448724981310079e-01 1.20598706480986694877799436653731e-01 8.96728468809540948947223171217047e-04
 	 7.15028680474762534657884316402487e-01 1.52422506132945001500189619036973e-01 1.22402518504304697044560157337401e-03
 	 6.51529254895814258219388648285531e-01 1.86386420820466885972521708936256e-01 1.57975878797172943242277387554395e-03
 	 5.85211517951298998418963037693175e-01 2.21857764684083996753471978991001e-01 1.94415602883511512075087601658652e-03
 	 5.17310845950990860764306944474811e-01 2.58175772445849216474300646950724e-01 2.29445720202976592705379488279505e-03
 	 4.49092100986817455154920253335149e-01 2.94663907778228428835376462302520e-01 2.60652466523076525861668528705195e-03
 	 3.81826069256750222358220980822807e-01 3.30642465729240164762359199812636e-01 2.85659870088681051847334657622923e-03
 	 3.16765788710447415699178463910357e-01 3.65441234346029764079588630920625e-01 3.02307113740006485474998143558878e-03
 	 2.55123206971686999899873171671061e-01 3.98411979643416347407480770925758e-01 3.08814498267198254619070318938157e-03
 	 1.98046604118182811848924984587939e-01 4.28940521473449354328266736047226e-01 3.03925593982280186841626878901934e-03
 	 1.46599200157665476851320818241220e-01 4.56458175736904281372119385196129e-01 2.87014854341548133337402859410759e-03
 	 1.01739343452164066050613655534107e-01 4.80452350993589294425589741877047e-01 2.58152461122403880169895451501816e-03
 	 6.43026411321589996816783241229132e-02 5.00476106361233741282035225594882e-01 2.18121327711471657898045783952057e-03
 	 3.49863283512164002786448691040277e-02 5.16156511926583405625024170149118e-01 1.68385012507226610248278753090290e-03
 	 1.43359334836996588080637593520805e-02 5.27201781126254709342049409315223e-01 1.11011965224412385150332127636830e-03
 	 2.73144600888430844065624114591628e-03 5.33408669125533085875190408842172e-01 4.86285372167908616289344614358470e-04
 	 9.93077485044348562404081803833833e-01 3.21987189654972466926197149916788e-03 5.59083854775407369927173184542823e-06
 	 9.76919663237129087818289008282591e-01 1.07353654245269380940186465522856e-02 3.32065520400650550261571758436929e-05
 	 9.51879593229719933589194624801166e-01 2.23822622851356199669137225782833e-02 9.82955891675838671923265410512727e-05
 	 9.18425724989849201485014873469481e-01 3.79426721746798575884973558913771e-02 2.12791769552003246683893888935302e-04
 	 8.77181597465419904402494921669131e-01 5.71265681957646709321352318511344e-02 3.83908717331652164957145334511779e-04
 	 8.28915613621726388160482201783452e-01 7.95765427979510664435736089217244e-02 6.13312067328619864650662840688256e-04
 	 7.74526916064822601448724981310079e-01 1.04874377454190703673475582036190e-01 8.96728468809546261537868350188774e-04
 	 7.15028680474762534657884316402487e-01 1.32548813392292574864228527076193e-01 1.22402518504305434302037447480416e-03
 	 6.51529254895814258219388648285531e-01 1.62084324283718855808089642778214e-01 1.57975878797173875656145725088209e-03
 	 5.85211517951298998418963037693175e-01 1.92930717364616949316413752057997e-01 1.94415602883512683013433886003440e-03
 	 5.17310845950990971786609406990465e-01 2.24513381603159867250241177316639e-01 2.29445720202977980484160269725180e-03
 	 4.49092100986817344132617790819495e-01 2.56243991234954171520854515620158e-01 2.60652466523078087112796907831580e-03
 	 3.81826069256750222358220980822807e-01 2.87531465014009612879419819364557e-01 2.85659870088682743202723735009840e-03
 	 3.16765788710447304676876001394703e-01 3.17792976943522875732384136426845e-01 3.02307113740008306934647919206327e-03
 	 2.55123206971686999899873171671061e-01 3.46464813384896652692646057403181e-01 3.08814498267200076078720094585606e-03
 	 1.98046604118182700826622522072284e-01 3.73012874408367889333959510622662e-01 3.03925593982282008301276654549383e-03
 	 1.46599200157665476851320818241220e-01 3.96942624105430241776559796562651e-01 2.87014854341549868060878836217853e-03
 	 1.01739343452164066050613655534107e-01 4.17808305554246639523796602588845e-01 2.58152461122405398052936931208023e-03
 	 6.43026411321589996816783241229132e-02 4.35221252506607259036286450282205e-01 2.18121327711472958940652766557378e-03
 	 3.49863283512164002786448691040277e-02 4.48857159722200194096330960746855e-01 1.68385012507227629398320889464458e-03
 	 1.43359334836996588080637593520805e-02 4.58462285390045631849886831332697e-01 1.11011965224413057355679068649579e-03
 	 2.73144600888430844065624114591628e-03 4.63859884865582605684153350011911e-01 4.86285372167911489425101700945220e-04
 	 9.93077485044348451381779341318179e-01 2.74179902160708987429726946061237e-03 5.48201942757657241126834427036307e-06
 	 9.76919663237128976795986545766937e-01 9.14142405761638257577494925953943e-03 3.25602254208533567611180692402684e-05
 	 9.51879593229719933589194624801166e-01 1.90590392432994151783454128690209e-02 9.63823807214478979780644674058010e-05
 	 9.18425724989849312507317335985135e-01 3.23091056998792702792400177713716e-02 2.08650027137895286832164343238105e-04
 	 8.77181597465419904402494921669131e-01 4.86446584892882699646676769589249e-02 3.76436384068641756960038602386476e-04
 	 8.28915613621726499182784664299106e-01 6.77613564129965206817018952278886e-02 6.01374666705996622703689347133604e-04
 	 7.74526916064822601448724981310079e-01 8.93030762508511266606348044660990e-02 8.79274700080493452382379704346249e-04
 	 7.15028680474762423635581853886833e-01 1.12868529727408101193120160132821e-01 1.20020096930622231778951203295946e-03
 	 6.51529254895814258219388648285531e-01 1.38018733669233645278140443224402e-01 1.54901063455406963302596334841610e-03
 	 5.85211517951298998418963037693175e-01 1.64285185592349169958481525100069e-01 1.90631531017752711525126141367537e-03
 	 5.17310845950990971786609406990465e-01 1.91178590265302705830663398955949e-01 2.24979828156960737564618035833064e-03
 	 4.49092100986817455154920253335149e-01 2.18197974029195440603956512859440e-01 2.55579171732526252286410439751307e-03
 	 3.81826069256750222358220980822807e-01 2.44840016865711440630093420622870e-01 2.80099835495024613446490846513370e-03
 	 3.16765788710447360188027232652530e-01 2.70608428301457926146156296454137e-01 2.96423060058328882021561057058534e-03
 	 2.55123206971687055411024402928888e-01 2.95023192499646980113681138391257e-01 3.02803785971994749229296850501214e-03
 	 1.98046604118182756337773753330112e-01 3.17629510414877302970637629186967e-01 2.98010038479456325008487560523918e-03
 	 1.46599200157665476851320818241220e-01 3.38006272725518752686468815227272e-01 2.81428446567376496986745415540554e-03
 	 1.01739343452164066050613655534107e-01 3.55773906600280409584513563459041e-01 2.53127826007109191924770996706684e-03
 	 6.43026411321589996816783241229132e-02 3.70601453301264927020497452758718e-01 2.13875851693739234965496720519695e-03
 	 3.49863283512164002786448691040277e-02 3.82212759049950112633098342485027e-01 1.65107595576725299686693393397263e-03
 	 1.43359334836996588080637593520805e-02 3.90391756539487433386170778248925e-01 1.08851247421222529013218327520462e-03
 	 2.73144600888430844065624114591628e-03 3.94987943417888454078479298914317e-01 4.76820397298308271301359173577339e-04
 	 9.93077485044348562404081803833833e-01 2.27772956082653368903301327463851e-03 5.26649927191876975448225559062188e-06
 	 9.76919663237128976795986545766937e-01 7.59417143269646224834623637889308e-03 3.12801524580222863633309493547330e-05
 	 9.51879593229719933589194624801166e-01 1.58331579898116428517518272656162e-02 9.25932030342504493831620737687160e-05
 	 9.18425724989849201485014873469481e-01 2.68405541604391090215742110558494e-02 2.00447158300810042083628381703875e-04
 	 8.77181597465419904402494921669131e-01 4.04111956216319789803037565434352e-02 3.61637161052097487294598732177064e-04
 	 8.28915613621726499182784664299106e-01 5.62922531400999875961232987719995e-02 5.77732218245278366687556204084331e-04
 	 7.74526916064822490426422518794425e-01 7.41878799453662973739653807569994e-02 8.44706887483176872659373923823978e-04
 	 7.15028680474762423635581853886833e-01 9.37647087263374645615954250388313e-02 1.15301625879163892329781759826801e-03
 	 6.51529254895814258219388648285531e-01 1.14658057410054803337828843723400e-01 1.48811281806780705723458613221055e-03
 	 5.85211517951298998418963037693175e-01 1.36478720971398348460468241682975e-01 1.83137041481367833159477065407827e-03
 	 5.17310845950990860764306944474811e-01 1.58820220961777613943866072077071e-01 2.16134969391896386570195431886532e-03
 	 4.49092100986817344132617790819495e-01 1.81266377164088166029642934518051e-01 2.45531330129192780498126325028352e-03
 	 3.81826069256750222358220980822807e-01 2.03399060140235010685216821002541e-01 2.69087988320251131346694251078588e-03
 	 3.16765788710447304676876001394703e-01 2.24805980195351751138588269895990e-01 2.84769481502410680417991528656785e-03
 	 2.55123206971686999899873171671061e-01 2.45088367670356688243771259294590e-01 2.90899355506430779341742187682485e-03
 	 1.98046604118182756337773753330112e-01 2.63868401571886623813156802498270e-01 2.86294069441186613267369409641105e-03
 	 1.46599200157665476851320818241220e-01 2.80796248399142078788770504615968e-01 2.70364366366269417638057426245268e-03
 	 1.01739343452164066050613655534107e-01 2.95556580788044365171174376882846e-01 2.43176356629247079552125221368897e-03
 	 6.43026411321589996816783241229132e-02 3.07874457178405114277097709418740e-01 2.05467534748234254352028393952878e-03
 	 3.49863283512164002786448691040277e-02 3.17520464830736037775693603180116e-01 1.58616554242581048878024674309017e-03
 	 1.43359334836996588080637593520805e-02 3.24315107404109403965719593543326e-01 1.04571868608780305792693710031926e-03
 	 2.73144600888430844065624114591628e-03 3.28133356166150691457517041271785e-01 4.58074676382106511438041529515885e-04
 	 9.93077485044348451381779341318179e-01 1.83669607383291598468044725223081e-03 4.94847304559365117499489597485685e-06
 	 9.76919663237129087818289008282591e-01 6.12372298025855993364174878479389e-03 2.93912489698661301418258773310299e-05
 	 9.51879593229719933589194624801166e-01 1.27674064631758191201704732975486e-02 8.70018100758669979660070437077479e-05
 	 9.18425724989849201485014873469481e-01 2.16434564022996642207452566708525e-02 1.88342826743810706682097366737594e-04
 	 8.77181597465419904402494921669131e-01 3.25864341463837359214039679500274e-02 3.39799105886768378504553256291842e-04
 	 8.28915613621726499182784664299106e-01 4.53924654216244505278154974803329e-02 5.42844907394470009391607145943226e-04
 	 7.74526916064822601448724981310079e-01 5.98229878406619508535158047379809e-02 7.93697871834108596537926683112119e-04
 	 7.15028680474762423635581853886833e-01 7.56091835236389619989694210744346e-02 1.08338947432966878174631641940096e-03
 	 6.51529254895814258219388648285531e-01 9.24569832609705710702030501124682e-02 1.39825067636020587691358940674036e-03
 	 5.85211517951299109441265500208829e-01 1.10052543234739064192950763754197e-01 1.72078009818111480992708361981158e-03
 	 5.17310845950990860764306944474811e-01 1.28068090831608860646895209356444e-01 2.03083303542608839542538134992355e-03
 	 4.49092100986817455154920253335149e-01 1.46168030209163413157824606969371e-01 2.30704516655215984000104612050563e-03
 	 3.81826069256750166847069749564980e-01 1.64015193728842267884004968436784e-01 2.52838667271028166502744305432770e-03
 	 3.16765788710447360188027232652530e-01 1.81277122754261998949232292943634e-01 2.67573207678228289913002768685146e-03
 	 2.55123206971686999899873171671061e-01 1.97632260819810667840101814363152e-01 2.73332919151752715136716176402842e-03
 	 1.98046604118182756337773753330112e-01 2.12775943865690875256291292316746e-01 2.69005730865100626744701450832054e-03
 	 1.46599200157665476851320818241220e-01 2.26426076146883592521419359400170e-01 2.54037969128029618784414545018535e-03
 	 1.01739343452164066050613655534107e-01 2.38328386681646131606271410419140e-01 2.28491752105962992944188094668334e-03
 	 6.43026411321589996816783241229132e-02 2.48261170447215295808973678504117e-01 1.93060039496744523246363200996711e-03
 	 3.49863283512164002786448691040277e-02 2.56039435561695949417071460629813e-01 1.49038232557921826448854574209690e-03
 	 1.43359334836996588080637593520805e-02 2.61518441301553994371431599574862e-01 9.82571242147684507928229180606650e-04
 	 2.73144600888430844065624114591628e-03 2.64597368067387317402960889012320e-01 4.30413083133309739246319391980933e-04
 	 9.93077485044348451381779341318179e-01 1.42728273691490950558780070878129e-03 4.53413100495991168041370542041157e-06
 	 9.76919663237128976795986545766937e-01 4.75869917723103358353498038013640e-03 2.69302817254769735581809708691026e-05
 	 9.51879593229720044611497087316820e-01 9.92145575943797347617802984132140e-03 7.97170361277168621665437098222640e-05
 	 9.18425724989849201485014873469481e-01 1.68189675637010066511223271845665e-02 1.72572638555911747398549649368249e-04
 	 8.77181597465419904402494921669131e-01 2.53226734555425797568162238349032e-02 3.11347287792293264327425639237390e-04
 	 8.28915613621726499182784664299106e-01 3.52741442666062443578312013414688e-02 4.97391802041549082810667492537959e-04
 	 7.74526916064822601448724981310079e-01 4.64879949557810145943648194588604e-02 7.27240523712300505725092403253029e-04
 	 7.15028680474762423635581853886833e-01 5.87553291657649523482831455112319e-02 9.92675874102102485940779530437794e-04
 	 6.51529254895814258219388648285531e-01 7.18476279204039447456864309060620e-02 1.28117334094327798427181974716405e-03
 	 5.85211517951298998418963037693175e-01 8.55210055437914951070865754445549e-02 1.57669695762583370914067248946822e-03
 	 5.17310845950990971786609406990465e-01 9.95207523976197605541926805017283e-02 1.86078876190334352273836326929768e-03
 	 4.49092100986817399643769022077322e-01 1.13586079470965550797245668945834e-01 2.11387329447444705099456996322260e-03
 	 3.81826069256750277869372212080634e-01 1.27454976321916435555436919457861e-01 2.31668159038902381555158349613066e-03
 	 3.16765788710447360188027232652530e-01 1.40869091838816684614243968098890e-01 2.45168957343464216994122217840868e-03
 	 2.55123206971686999899873171671061e-01 1.53578546905110413511863498570165e-01 2.50446400734811915750333000119099e-03
 	 1.98046604118182756337773753330112e-01 1.65346589366044072200168102426687e-01 2.46481533513340624400034251095803e-03
 	 1.46599200157665476851320818241220e-01 1.75954004734931945819198517710902e-01 2.32767041802137445924425485088705e-03
 	 1.01739343452164066050613655534107e-01 1.85203200939841106098526779533131e-01 2.09359842532389579458640405107417e-03
 	 6.43026411321589996816783241229132e-02 1.92921892671195749358048487920314e-01 1.76894872991262427051883943107669e-03
 	 3.49863283512164002786448691040277e-02 1.98966324125703031278078469767934e-01 1.36559068815586656837901546879266e-03
 	 1.43359334836996588080637593520805e-02 2.03224018373199144527063708665082e-01 9.00299282739515415244224705304532e-04
 	 2.73144600888430844065624114591628e-03 2.05616629259511074501176608464448e-01 3.94374039667221671593561049817822e-04
 	 9.93077485044348451381779341318179e-01 1.05745824486610552617182889889591e-03 4.03153837703159776632150235187169e-06
 	 9.76919663237129087818289008282591e-01 3.52566842549886794166980052978033e-03 2.39451538038418602352078862205431e-05
 	 9.51879593229719933589194624801166e-01 7.35069858447917612309652213298250e-03 7.08806803554072514242032077014244e-05
 	 9.18425724989849201485014873469481e-01 1.24609900059566985897063773336413e-02 1.53443562703127570632025133967602e-04
 	 8.77181597465419904402494921669131e-01 1.87612931446896336051821663204464e-02 2.76835525472522118051871276023235e-04
 	 8.28915613621726499182784664299106e-01 2.61342295542267011310144653180032e-02 4.42257653375663297053155265103896e-04
 	 7.74526916064822601448724981310079e-01 3.44424494753874654850989145415951e-02 6.46628444893073773061531461792129e-04
 	 7.15028680474762423635581853886833e-01 4.35311838707288789596105971213547e-02 8.82641211296760343045508800940979e-04
 	 6.51529254895814258219388648285531e-01 5.32311255180779041573657650587847e-02 1.13915973887664069216785200922004e-03
 	 5.85211517951298998418963037693175e-01 6.33615821746701390893008465354796e-02 1.40192559206253316086976390408836e-03
 	 5.17310845950990971786609406990465e-01 7.37338422418089556309439558390295e-02 1.65452680942745943351579462898826e-03
 	 4.49092100986817399643769022077322e-01 8.41546899797961378553168287908193e-02 1.87955780314541173736664347870828e-03
 	 3.81826069256750222358220980822807e-01 9.44300047040083079252781317336485e-02 2.05988550591041513770917958936479e-03
 	 3.16765788710447360188027232652530e-01 1.04368376887779890083152167790104e-01 2.17992832431567092055235690395421e-03
 	 2.55123206971686999899873171671061e-01 1.13784673813403514053277376660844e-01 2.22685289606173618046081053023499e-03
 	 1.98046604118182756337773753330112e-01 1.22503488386293990508590923127485e-01 2.19159914105176685875098208100553e-03
 	 1.46599200157665476851320818241220e-01 1.30362406979252942740288290224271e-01 2.06965626027766792099926718151437e-03
 	 1.01739343452164066050613655534107e-01 1.37215035776828475633237758302130e-01 1.86153033261570550679908642166538e-03
 	 6.43026411321589996816783241229132e-02 1.42933730468353559217575821094215e-01 1.57286692507180910632902381962595e-03
 	 3.49863283512164002786448691040277e-02 1.47411983943844138167378332582302e-01 1.21421971720599673749685365464757e-03
 	 1.43359334836996588080637593520805e-02 1.50566463269969474936260667163879e-01 8.00504243306588911255339269246178e-04
 	 2.73144600888430844065624114591628e-03 1.52339122633842860565778210002463e-01 3.50659051113465420907583380838446e-04
 	 9.93077485044348562404081803833833e-01 7.34420666973416985667810763516172e-04 3.45047886998561488726021059814109e-06
 	 9.76919663237129087818289008282591e-01 2.44862978671073205916286497085821e-03 2.04939751310382828135801813740358e-05
 	 9.51879593229720044611497087316820e-01 5.10517080304887654884637981922424e-03 6.06647554814086946493693897064503e-05
 	 9.18425724989849201485014873469481e-01 8.65434511079213319995062647649320e-03 1.31327974913707419286207356279306e-04
 	 8.77181597465419904402494921669131e-01 1.30300004671592695171256082176114e-02 2.36935641378570283847176947134017e-04
 	 8.28915613621726499182784664299106e-01 1.81506157744146523480566202124464e-02 3.78515729071574763033025678993226e-04
 	 7.74526916064822601448724981310079e-01 2.39207995575420329092963811490336e-02 5.53430868610015340609831202556279e-04
 	 7.15028680474762534657884316402487e-01 3.02330623905922579730543020559708e-02 7.55427473221870248235032541117562e-04
 	 6.51529254895814258219388648285531e-01 3.69698178595057047601812882930972e-02 9.74974374776086121115181715168774e-04
 	 5.85211517951299109441265500208829e-01 4.40055724820646587680528227792820e-02 1.19986818437916860184688783164120e-03
 	 5.17310845950990971786609406990465e-01 5.12092632126563973571364840609021e-02 1.41606237169385629909301727025195e-03
 	 4.49092100986817455154920253335149e-01 5.84466988119504704535245309671154e-02 1.60865998984858343812121006521920e-03
 	 3.81826069256750222358220980822807e-01 6.55830595427452367474074890196789e-02 1.76299733452290750997104584740782e-03
 	 3.16765788710447360188027232652530e-01 7.24854086078469128651136088592466e-02 1.86573856371736513694303827293197e-03
 	 2.55123206971686999899873171671061e-01 7.90251685483558397038450493710116e-02 1.90589996816172436294722913885380e-03
 	 1.98046604118182756337773753330112e-01 8.50805164970123151135794614674523e-02 1.87572728335173551442172090730764e-03
 	 1.46599200157665476851320818241220e-01 9.05386537452225192978971790580545e-02 1.77135984489366275600186195759989e-03
 	 1.01739343452164066050613655534107e-01 9.52979075847666390330914509831928e-02 1.59323079128348399878534191742574e-03
 	 6.43026411321589996816783241229132e-02 9.92696271206988667401560633152258e-02 1.34617200252363827979451560423740e-03
 	 3.49863283512164002786448691040277e-02 1.02379841562085349693234093138017e-01 1.03921607235796958391971234192397e-03
 	 1.43359334836996588080637593520805e-02 1.04570674932475404794729456625646e-01 6.85128781757237412600169967902275e-04
 	 2.73144600888430844065624114591628e-03 1.05801813541165690146783617819892e-01 3.00119094321282938939154938395859e-04
 	 9.93077485044348562404081803833833e-01 4.64457218795772883157546573329455e-04 2.80226598151010483173182358251907e-06
 	 9.76919663237129087818289008282591e-01 1.54854544777852445869292807856255e-03 1.66439417540505327761969633915129e-05
 	 9.51879593229720044611497087316820e-01 3.22857667177724877438649286887085e-03 4.92681702939653135366916691939565e-05
 	 9.18425724989849201485014873469481e-01 5.47312084397373610489268003220786e-03 1.06656475923537263960153009811904e-04
 	 8.77181597465419904402494921669131e-01 8.24034242231293234670630454274942e-03 1.92424504731197957554597599560964e-04
 	 8.28915613621726499182784664299106e-01 1.14786864002023591968537630236824e-02 3.07407113914072882988187673802827e-04
 	 7.74526916064822601448724981310079e-01 1.51278259633579326148833388288040e-02 4.49462394832720745115051119711325e-04
 	 7.15028680474762312613279391371179e-01 1.91197833953681839425087218842236e-02 6.13511570269841509384090016965274e-04
 	 6.51529254895814258219388648285531e-01 2.33801955127085347996285236149561e-02 7.91814013714131344039148796554173e-04
 	 5.85211517951299109441265500208829e-01 2.78296985987123712824597987491870e-02 9.74458885875181791101640182972687e-04
 	 5.17310845950990971786609406990465e-01 3.23854066721027677999700244981796e-02 1.15003846173698060992296454685402e-03
 	 4.49092100986817399643769022077322e-01 3.69624554410521444225423692842014e-02 1.30645436046036996467767377083646e-03
 	 3.81826069256750222358220980822807e-01 4.14755831434732158413680735975504e-02 1.43179762641094834689503567659585e-03
 	 3.16765788710447360188027232652530e-01 4.58407188131244591744462013593875e-02 1.51523771177839230994699448729079e-03
 	 2.55123206971686999899873171671061e-01 4.99765483862194548336788102460559e-02 1.54785432578610705929567092908883e-03
 	 1.98046604118182756337773753330112e-01 5.38060294909163960852538366452791e-02 1.52334993338152160924359179716703e-03
 	 1.46599200157665476851320818241220e-01 5.72578267511385519128452870063484e-02 1.43858914121657022189282315594028e-03
 	 1.01739343452164066050613655534107e-01 6.02676410187125144446440572210122e-02 1.29392371764524010020747102345240e-03
 	 6.43026411321589996816783241229132e-02 6.27794083101994582207794337591622e-02 1.09327781739148970074904099192281e-03
 	 3.49863283512164002786448691040277e-02 6.47463485316095432864358372171409e-02 8.43987155620351059762129786179230e-04
 	 1.43359334836996588080637593520805e-02 6.61318601597745692188823340984527e-02 5.56419311757666719929493748253435e-04
 	 2.73144600888430844065624114591628e-03 6.69104482903357666856436480884440e-02 2.43738205654237173212670053423778e-04
 	 9.93077485044348451381779341318179e-01 2.52821418471675142536359004452606e-04 2.09953078523653410548911388278093e-06
 	 9.76919663237129087818289008282591e-01 8.42931148083567866047260963568988e-04 1.24700754071466583409793713044245e-05
 	 9.51879593229720044611497087316820e-01 1.75743491708371668558186229347484e-03 3.69129986043343976623992697128074e-05
 	 9.18425724989849201485014873469481e-01 2.97922417661629357343855417639134e-03 7.99098144586665758756088839831477e-05
 	 8.77181597465419904402494921669131e-01 4.48552627797037251067280294591910e-03 1.44169459352795690902648839681888e-04
 	 8.28915613621726499182784664299106e-01 6.24827790472293198575925998738967e-03 2.30317430080461760591448161505923e-04
 	 7.74526916064822601448724981310079e-01 8.23464091776884843376649314450333e-03 3.36748952806010626130628349272911e-04
 	 7.15028680474762312613279391371179e-01 1.04076125061018376349863956420450e-02 4.59658875131548441163309437484941e-04
 	 6.51529254895814258219388648285531e-01 1.27267140103751730251246954139788e-02 5.93247717719734644209461649211335e-04
 	 5.85211517951299109441265500208829e-01 1.51487447942098563125057353317970e-02 7.30090021197675855327280380890898e-04
 	 5.17310845950990971786609406990465e-01 1.76285869209911183475014695432037e-02 8.61638820352696654589208513641552e-04
 	 4.49092100986817399643769022077322e-01 2.01200455857527549241581255046185e-02 9.78829692610020838869355763733893e-04
 	 3.81826069256750222358220980822807e-01 2.25767096256147548061221641546581e-02 1.07274013770043111400120938725422e-03
 	 3.16765788710447360188027232652530e-01 2.49528160723697656209196793497540e-02 1.13525562663246613014089714255306e-03
 	 2.55123206971686999899873171671061e-01 2.72041026428272436632482822460588e-02 1.15969284482346458517443288371851e-03
 	 1.98046604118182756337773753330112e-01 2.92886322953326283524688733450603e-02 1.14133351470762050942908683026644e-03
 	 1.46599200157665476851320818241220e-01 3.11675745192658837368071544915438e-02 1.07782851778528976360860269778641e-03
 	 1.01739343452164066050613655534107e-01 3.28059288857612818546272137609776e-02 9.69441408085012644620104271808714e-04
 	 6.43026411321589996816783241229132e-02 3.41731776738217751798742938262876e-02 8.19112264708253350574407303241742e-04
 	 3.49863283512164002786448691040277e-02 3.52438567303670069463805702980608e-02 6.32337196847477297362294379468040e-04
 	 1.43359334836996588080637593520805e-02 3.59980424787335051561854015744757e-02 4.16883865501520821123665472285325e-04
 	 2.73144600888430844065624114591628e-03 3.64218570898704463445483270334080e-02 1.82615022872888220582116014512053e-04
 	 9.93077485044348451381779341318179e-01 1.03628325749502599173457184633662e-04 1.35603218724924790763856127101539e-06
 	 9.76919663237129087818289008282591e-01 3.45506896235504845638075721581117e-04 8.05409653834205100026485263375875e-06
 	 9.51879593229719933589194624801166e-01 7.20350511329424791906461678081541e-04 2.38411432627432357488333342088183e-05
 	 9.18425724989849201485014873469481e-01 1.22114659161987049174058483913541e-03 5.16116654468866514738310813381617e-05
 	 8.77181597465419904402494921669131e-01 1.83856091426663759147430710072513e-03 9.31152944626568730267929252519821e-05
 	 8.28915613621726499182784664299106e-01 2.56109067814835889009827951667830e-03 1.48756022378804237229002471742945e-04
 	 7.74526916064822601448724981310079e-01 3.37527594226491589601835130451946e-03 2.17497367620633758186418638125303e-04
 	 7.15028680474762534657884316402487e-01 4.26594971888333285292560503876302e-03 2.96881681476720952778808326755211e-04
 	 6.51529254895814258219388648285531e-01 5.21652031366831581138399087649304e-03 3.83163231469113736964854366462419e-04
 	 5.85211517951299109441265500208829e-01 6.20928032806816743160993610217702e-03 4.71546107013618982610470009575465e-04
 	 5.17310845950990971786609406990465e-01 7.22573648623270337054691481171176e-03 5.56510046148285140651945646084187e-04
 	 4.49092100986817399643769022077322e-01 8.24695411749232221154670696705580e-03 6.32200574694092199030948098226190e-04
 	 3.81826069256750222358220980822807e-01 9.25390986878460442000005059526302e-03 6.92854882388443363457064538835084e-04
 	 3.16765788710447360188027232652530e-01 1.02278460739063659090675173501950e-02 7.33232006548550983675294201447059e-04
 	 2.55123206971686999899873171671061e-01 1.11506201786051306612534972373396e-02 7.49015368558216942246330560806200e-04
 	 1.98046604118182756337773753330112e-01 1.20050427159444916824782012554351e-02 7.37157555970527648622758754015649e-04
 	 1.46599200157665476851320818241220e-01 1.27751975470632439524365508987103e-02 6.96141334401696059742958855309780e-04
 	 1.01739343452164066050613655534107e-01 1.34467384355316799116053516627289e-02 6.26136926526375163851168004214287e-04
 	 6.43026411321589996816783241229132e-02 1.40071565506036943560275176423602e-02 5.29043252771300076195415407198652e-04
 	 3.49863283512164002786448691040277e-02 1.44460144555849101521971533657052e-02 4.08410106748465699753186664011650e-04
 	 1.43359334836996588080637593520805e-02 1.47551457265024943410480773309246e-02 2.69254418149082166891034040290265e-04
 	 2.73144600888430844065624114591628e-03 1.49288620154379714222159236669540e-02 1.17946281441639225337665586312852e-04
 	 9.93077485044348562404081803833833e-01 1.97479086631409048169238928949198e-05 5.87300969910334253155589651768098e-07
 	 9.76919663237129087818289008282591e-01 6.58414442189989013165529740945203e-05 3.48824958079723945658027865757145e-06
 	 9.51879593229720044611497087316820e-01 1.37273433690007773400054702506168e-04 1.03256594449897714832649342486803e-05
 	 9.18425724989849201485014873469481e-01 2.32707526452838320274452144076349e-04 2.23531428388378960883751261912167e-05
 	 8.77181597465419904402494921669131e-01 3.50364948424664035542264173272997e-04 4.03284695345900186095634831762169e-05
 	 8.28915613621726610205087126814760e-01 4.88053670888721757847861226764508e-04 6.44266095189795960857317980163828e-05
 	 7.74526916064822601448724981310079e-01 6.43208703205999654528568498790264e-04 9.41986600005859033186983442220708e-05
 	 7.15028680474762423635581853886833e-01 8.12939751759556017418617557268590e-04 1.28580207106721738398447119067214e-04
 	 6.51529254895814258219388648285531e-01 9.94085024038304787552533525740728e-04 1.65948964627655982332493644904048e-04
 	 5.85211517951299109441265500208829e-01 1.18327011360713774124064912030008e-03 2.04227811559783698543840690931006e-04
 	 5.17310845950990971786609406990465e-01 1.37697085349980374857636888918933e-03 2.41025908485797323238877809536973e-04
 	 4.49092100986817399643769022077322e-01 1.57157896244541905872438292135485e-03 2.73807667831903103067281435301084e-04
 	 3.81826069256750222358220980822807e-01 1.76346925943238197476148343412206e-03 3.00077201898342384861484433145051e-04
 	 3.16765788710447360188027232652530e-01 1.94906719400644856676763083669357e-03 3.17564636492004065057570549868160e-04
 	 2.55123206971686999899873171671061e-01 2.12491543438386720765720383496955e-03 3.24400450496925541431225692434737e-04
 	 1.98046604118182756337773753330112e-01 2.28773827365169601932848308933899e-03 3.19264801874976722560056652255867e-04
 	 1.46599200157665476851320818241220e-01 2.43450265637623619596752178040333e-03 3.01500572577221594410684657461275e-04
 	 1.01739343452164066050613655534107e-01 2.56247469522885573667281278176233e-03 2.71181486474571730675015013289908e-04
 	 6.43026411321589996816783241229132e-02 2.66927064768263111460555592202581e-03 2.29129970806506020252965583061666e-04
 	 3.49863283512164002786448691040277e-02 2.75290150595408622535842368961312e-03 1.76883450164350153072795324149524e-04
 	 1.43359334836996588080637593520805e-02 2.81181103728977976885516909533180e-03 1.16614769485949288903639531334022e-04
 	 2.73144600888430844065624114591628e-03 2.84491524294383513193906765081920e-03 5.10828327965490237350977553720810e-05
 	 ];
 
 	 case  44 

 	 % ALG. DEG.:   44
 	 % PTS CARD.:  529
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.93641142341365912749040489870822e-01 6.34222713152880410159006885351118e-03 4.54441028047938367323652520540778e-07
 	 9.78789517517072771290997934556799e-01 2.11550100187229868364813256675916e-02 2.70275228530836595313520051564460e-06
 	 9.55747055076380247484735264151823e-01 4.41372087584861322318019460908545e-02 8.01749222555837254907025457573155e-06
 	 9.24909854207592641017754431231879e-01 7.48937600935948299962774399318732e-02 1.74073209861343138808807001760570e-05
 	 8.86805875060793558084526466700481e-01 1.12898084665305389884260023336537e-01 3.15241353670005661712603950430633e-05
 	 8.42087181576014809358809998229844e-01 1.57499823897601115563205098624167e-01 5.05965212422297794616667110378927e-05
 	 7.91518958392199101226083257643040e-01 2.07935794363794890227126188619877e-01 7.43938016765777735848572116417188e-05
 	 7.35966457544997010309373308700742e-01 2.63343006950007119115753084770404e-01 1.02223464602952071622089802449551e-04
 	 6.76380205535952017115164380811621e-01 3.22773421097546642233311331438017e-01 1.32962456868259890335054462795483e-04
 	 6.13779743822228218697034662909573e-01 3.85210161789159011291872047877405e-01 1.65120483818082187032691421357811e-04
 	 5.49236185933714482487744135141838e-01 4.49584916812982349210159327412839e-01 1.96931227068385323372007311704124e-04
 	 4.83853891201996733073542600322980e-01 5.14796215104283527708162182534579e-01 2.26465441118763174607741994748267e-04
 	 4.18751569204530937895469833165407e-01 5.79728272883124229331031074252678e-01 2.51758345997146011294165468541451e-04
 	 3.55043138426673232643793198803905e-01 6.43270084931366614711123474990018e-01 2.70942704315384099832825226528144e-04
 	 2.93818666700587094453567260643467e-01 7.04334434306677303894161923381034e-01 2.82378528061695457506558026850030e-04
 	 2.36125719469965966723634664958809e-01 7.61876495297314715315906141768210e-01 2.84770534453048494195892548219717e-04
 	 1.82951434776206678378684955532663e-01 8.14911711556085105456759265507571e-01 2.77265250767508601367761222888930e-04
 	 1.35205630986380942459845755365677e-01 8.62532644193462205706168788310606e-01 2.59521004586317624238112067303064e-04
 	 9.37052342256400327968890451302286e-02 9.03924503617741126326734502072213e-01 2.31745844521755070240590090868693e-04
 	 5.91602846138907789708127893391065e-02 9.38379106700017562303628437803127e-01 1.94700626832075519498377325078309e-04
 	 3.21617276826355880103847084683366e-02 9.65307053427844397042179025447695e-01 1.49667138625979512711258734292130e-04
 	 1.31709850003689510344884183723480e-02 9.84248129003551630589186061115470e-01 9.83862031428663958874600292681123e-05
 	 2.50868963898276398083453386789188e-03 9.94882538917341574524755287711741e-01 4.30291521942911028278042073758058e-05
 	 9.93641142341365912749040489870822e-01 6.27155840004316005031892444776531e-03 1.04998275983301469622109309415281e-06
 	 9.78789517517072771290997934556799e-01 2.09192887663009093046628805723230e-02 6.24468991249114394899823524132110e-06
 	 9.55747055076380247484735264151823e-01 4.36454066691580253034565828329505e-02 1.85243587052256492183049257915783e-05
 	 9.24909854207592641017754431231879e-01 7.40592508727418857850111066909449e-02 4.02194912040213214390535489961565e-05
 	 8.86805875060793447062224004184827e-01 1.11640109467477224858278361807606e-01 7.28362903239034730927189964511115e-05
 	 8.42087181576014809358809998229844e-01 1.55744870545532682060141382862639e-01 1.16902902099460181354478871540437e-04
 	 7.91518958392199212248385720158694e-01 2.05618854507589016167301565474190e-01 1.71886349114154252798458699658113e-04
 	 7.35966457544997010309373308700742e-01 2.60408688159332379896682141406927e-01 2.36186587167428276891334437692649e-04
 	 6.76380205535952128137466843327275e-01 3.19176894553605761117864858533721e-01 3.07208809944833211025283503659011e-04
 	 6.13779743822228218697034662909573e-01 3.80917929277697742129760172247188e-01 3.81509702257745155970503070363975e-04
 	 5.49236185933714482487744135141838e-01 4.44575383867006956872813816517009e-01 4.55008198055464679280396333993508e-04
 	 4.83853891201996733073542600322980e-01 5.09060060479013753997890034952434e-01 5.23246789344901396846820862407412e-04
 	 4.18751569204530937895469833165407e-01 5.73268608036473059641480176651385e-01 5.81685865989180293095239804301855e-04
 	 3.55043138426673232643793198803905e-01 6.36102400778464915909182764153229e-01 6.26011189297101750331209224498252e-04
 	 2.93818666700587094453567260643467e-01 6.96486336157263630219915739871794e-01 6.52433578643622823570180635499582e-04
 	 2.36125719469965966723634664958809e-01 7.53387230508336558365556356875459e-01 6.57960292380539452788967835772382e-04
 	 1.82951434776206678378684955532663e-01 8.05831497975878274786509791738354e-01 6.40619387860269008140579050092356e-04
 	 1.35205630986380942459845755365677e-01 8.52921810874817332148722925921902e-01 5.99621433391866608293707674448569e-04
 	 9.37052342256400327968890451302286e-02 8.93852458466299459871606813976541e-01 5.35447123812766013865871439492139e-04
 	 5.91602846138907789708127893391065e-02 9.27923148603931990940907326148590e-01 4.49854412090616262269449077138006e-04
 	 3.21617276826355880103847084683366e-02 9.54551048708182525714960320328828e-01 3.45804858214164242448396269224986e-04
 	 1.31709850003689510344884183723480e-02 9.73281071958555288325953824823955e-01 2.27320621883949052898649112464113e-04
 	 2.50868963898276398083453386789188e-03 9.83796987179058390893260366283357e-01 9.94185497913947861239533643207267e-05
 	 9.93641142341365912749040489870822e-01 6.14574399969093371903783307175217e-03 1.62768547847024573944235172062722e-06
 	 9.78789517517072771290997934556799e-01 2.04996246885640123758243191787187e-02 9.68053141151381486362650918842121e-06
 	 9.55747055076380247484735264151823e-01 4.27698315221305552791264403822424e-02 2.87164997521148849786518791882273e-05
 	 9.24909854207592641017754431231879e-01 7.25735403611368345977439275884535e-02 6.23483396952713084249175778950303e-05
 	 8.86805875060793447062224004184827e-01 1.09400485353028917301365652292588e-01 1.12910970161752950377022364225610e-04
 	 8.42087181576014698336507535714190e-01 1.52620456126385056760952352306049e-01 1.81223124243089228624370434772572e-04
 	 7.91518958392199212248385720158694e-01 2.01493912789625279069483099192439e-01 2.66458579229310852948958698860338e-04
 	 7.35966457544997121331675771216396e-01 2.55184601758885076794314272774500e-01 3.66136943241819807527692720583445e-04
 	 6.76380205535952128137466843327275e-01 3.12773852911791272468633451353526e-01 4.76235742084808082522084937693307e-04
 	 6.13779743822228218697034662909573e-01 3.73276294169084921215073791245231e-01 5.91417141324488901399369922273763e-04
 	 5.49236185933714482487744135141838e-01 4.35656709788774132441346864652587e-01 7.05354663801886772045435236577759e-04
 	 4.83853891201996677562391369065153e-01 4.98847752442147795992610781468102e-01 8.11138271268686209675147225084402e-04
 	 4.18751569204530937895469833165407e-01 5.61768205495317141107136649225140e-01 9.01730650560923384026490445819491e-04
 	 3.55043138426673232643793198803905e-01 6.23341482835644944415776080859359e-01 9.70443859802831774834241951310787e-04
 	 2.93818666700587094453567260643467e-01 6.82514049662005684027121787949000e-01 1.01140390323502965021218447105866e-03
 	 2.36125719469965966723634664958809e-01 7.38273449117290536669599987362744e-01 1.01997142647195578220309375439001e-03
 	 1.82951434776206678378684955532663e-01 7.89665626555136501707465868094005e-01 9.93089519881725510744296947507337e-04
 	 1.35205630986380942459845755365677e-01 8.35811255676637054889965838810895e-01 9.29534404799821139739335329466030e-04
 	 9.37052342256400327968890451302286e-02 8.75920789191797166672870389447780e-01 8.30051255372331298586219272550579e-04
 	 5.91602846138907789708127893391065e-02 9.09307983589483614927928556426195e-01 6.97365253980089592859836766791659e-04
 	 3.21617276826355880103847084683366e-02 9.35401698556554861418987911747536e-01 5.36067417134708707783519177070275e-04
 	 1.31709850003689510344884183723480e-02 9.53755976817641903942046610609395e-01 3.52392905247486004118029345733021e-04
 	 2.50868963898276398083453386789188e-03 9.64060931144021249217246349871857e-01 1.54118844591086376523414447348159e-04
 	 9.93641142341365912749040489870822e-01 5.96700055337379044878565181875274e-03 2.17642062585612139276889168137963e-06
 	 9.78789517517072771290997934556799e-01 1.99034115099437809714988389941936e-02 1.29440905580038820884940242716965e-05
 	 9.55747055076380247484735264151823e-01 4.15259093729076628198626508492453e-02 3.83975793785626756606139953209578e-05
 	 9.24909854207592641017754431231879e-01 7.04628040993858922869108596387377e-02 8.33675880847719908165946445244288e-05
 	 8.86805875060793447062224004184827e-01 1.06218670461007386185414702595153e-01 1.50976197549185437492974548590041e-04
 	 8.42087181576014698336507535714190e-01 1.48181627189173159564461457193829e-01 2.42318157102091447227185105894876e-04
 	 7.91518958392199101226083257643040e-01 1.95633643246059085729626758620725e-01 3.56288702849412799739808876964275e-04
 	 7.35966457544997010309373308700742e-01 2.47762786732462797489873196354893e-01 4.89571238239670455949514860094496e-04
 	 6.76380205535952017115164380811621e-01 3.03677106221698689392241021778318e-01 6.36787208310908114765325205297586e-04
 	 6.13779743822228107674732200393919e-01 3.62419888296723613496652660614927e-01 7.90799255684956296091892014032965e-04
 	 5.49236185933714371465441672626184e-01 4.22986025535940113329047562729102e-01 9.43148083059032623330641964543020e-04
 	 4.83853891201996733073542600322980e-01 4.84339213449382244291996357787866e-01 1.08459409840628976696985663608075e-03
 	 4.18751569204530937895469833165407e-01 5.45429681618195050241126864420949e-01 1.20572752709689301302276032146210e-03
 	 3.55043138426673232643793198803905e-01 6.05212155470221779829387287463760e-01 1.29760574794543677434877082532694e-03
 	 2.93818666700587094453567260643467e-01 6.62663741318118892920097096066456e-01 1.35237448830772166892544294825029e-03
 	 2.36125719469965966723634664958809e-01 7.16801428703438991973939664603677e-01 1.36383034666118685591940096202279e-03
 	 1.82951434776206678378684955532663e-01 7.66698910802617317195029045251431e-01 1.32788584955828158247481685094726e-03
 	 1.35205630986380942459845755365677e-01 8.11502435732653903954769702977501e-01 1.24290465068875762011391117312087e-03
 	 9.37052342256400327968890451302286e-02 8.50445419477593667068049398949370e-01 1.10988314180203721977246988927845e-03
 	 5.91602846138907789708127893391065e-02 8.82861577302685662793635401612846e-01 9.32465235202628041875916320435635e-04
 	 3.21617276826355880103847084683366e-02 9.08196379998001623867764919850742e-01 7.16789698583481546360907099568749e-04
 	 1.31709850003689510344884183723480e-02 9.26016840555127229706045000057202e-01 4.71193727246864088337857667809772e-04
 	 2.50868963898276398083453386789188e-03 9.36022084537155962813415044365684e-01 2.06076319189380896372554285989054e-04
 	 9.93641142341365912749040489870822e-01 5.73851421780689849999612661690662e-03 2.68633341315916086600211823420814e-06
 	 9.78789517517072771290997934556799e-01 1.91412769130874654832652481672994e-02 1.59767567701881113648859633613597e-05
 	 9.55747055076380247484735264151823e-01 3.99358135150593082651759857526486e-02 4.73937341172225357933955880440635e-05
 	 9.24909854207592641017754431231879e-01 6.77646666082918902596077259659069e-02 1.02899749609989957840200380800866e-04
 	 8.86805875060793558084526466700481e-01 1.02151381617083841790716292052821e-01 1.86348355299453295741418656916721e-04
 	 8.42087181576014698336507535714190e-01 1.42507507220196422137448166722606e-01 2.99090788933522905464201802061552e-04
 	 7.91518958392199212248385720158694e-01 1.88142506977667212098026539024431e-01 4.39763451892035913976669592173607e-04
 	 7.35966457544997121331675771216396e-01 2.38275539207685238540790351180476e-01 6.04272703438288728665372939730105e-04
 	 6.76380205535952128137466843327275e-01 2.92048806781216474526274851086782e-01 7.85979848948105408457109888331615e-04
 	 6.13779743822228107674732200393919e-01 3.48542230422758725350007580345846e-01 9.76075322210408495744726753429177e-04
 	 5.49236185933714482487744135141838e-01 4.06789189938855100248105145510635e-01 1.16411790027116848061927711910357e-03
 	 4.83853891201996733073542600322980e-01 4.65793062655106004932292762532597e-01 1.33870325048861303976477366006748e-03
 	 4.18751569204530937895469833165407e-01 5.24544275600946519055867156566819e-01 1.48821698559857031052278131255662e-03
 	 3.55043138426673232643793198803905e-01 5.82037579499092627699496915738564e-01 1.60162132098983791238244744903341e-03
 	 2.93818666700587094453567260643467e-01 6.37289248955919318539997675543418e-01 1.66922180937152208994589397406116e-03
 	 2.36125719469965966723634664958809e-01 6.89353914611797291556172240234446e-01 1.68336165656178060948122698903262e-03
 	 1.82951434776206678378684955532663e-01 7.37340739465869421387367310671834e-01 1.63899573646361261178294732587801e-03
 	 1.35205630986380942459845755365677e-01 7.80428663208982076326947208144702e-01 1.53410432379207269104615107835343e-03
 	 9.37052342256400327968890451302286e-02 8.17880455597002731238376327382866e-01 1.36991725455278857970231598528699e-03
 	 5.91602846138907789708127893391065e-02 8.49055345041379472270648420817452e-01 1.15093217192278603026867056513538e-03
 	 3.21617276826355880103847084683366e-02 8.73420036174213709756486423430033e-01 8.84726093218151255631598317563657e-04
 	 1.31709850003689510344884183723480e-02 8.90558121776889199949778230802622e-01 5.81589532159641200634303537242431e-04
 	 2.50868963898276398083453386789188e-03 9.00180248393089299518976531544467e-01 2.54357864156670081343808442753129e-04
 	 9.93641142341365912749040489870822e-01 5.46436148577505130530251875597969e-03 3.14831334839637131859345353657176e-06
 	 9.78789517517072771290997934556799e-01 1.82268183683970338981872316708177e-02 1.87243461132816396317538748528264e-05
 	 9.55747055076380247484735264151823e-01 3.80279133225157189857057460358192e-02 5.55442317847385400530167698374129e-05
 	 9.24909854207592641017754431231879e-01 6.45272661626778570864715334209905e-02 1.20595847729412715713601111922060e-04
 	 8.86805875060793558084526466700481e-01 9.72711845332724645007971275845193e-02 2.18395457379593155387148550872212e-04
 	 8.42087181576014698336507535714190e-01 1.35699329884287317460334065799543e-01 3.50526676461371115064297176999730e-04
 	 7.91518958392199212248385720158694e-01 1.79154155578415880123444026139623e-01 5.15391402625766411986496517982914e-04
 	 7.35966457544996899287070846185088e-01 2.26892123994136551967670811791322e-01 7.08191994704422721554348818528979e-04
 	 6.76380205535952239159769305842929e-01 2.78096418545031032198977527514216e-01 9.21148074134189127556981979694228e-04
 	 6.13779743822228329719337125425227e-01 3.31890915975830147477410037026857e-01 1.14393505694493943618261777572798e-03
 	 5.49236185933714482487744135141838e-01 3.87355175566859666336227974170470e-01 1.36431609962397852077453652697159e-03
 	 4.83853891201996733073542600322980e-01 4.43540187461014090430921896768268e-01 1.56892561899024413768488628306841e-03
 	 4.18751569204530937895469833165407e-01 4.99484610194623979140260416897945e-01 1.74415185327279746198281262792307e-03
 	 3.55043138426673232643793198803905e-01 5.54231219436459143778961333737243e-01 1.87705880411121643971950057050435e-03
 	 2.93818666700587094453567260643467e-01 6.06843286453353503162588822306134e-01 1.95628482977415951368782565111815e-03
 	 2.36125719469965966723634664958809e-01 6.56420606118593097377811318438035e-01 1.97285636532343582744131182948877e-03
 	 1.82951434776206678378684955532663e-01 7.02114900426264454402769388252636e-01 1.92086065333372949318069267121700e-03
 	 1.35205630986380942459845755365677e-01 7.43144334538890616315143233805429e-01 1.79793062795850777657591379465885e-03
 	 9.37052342256401438191915076458827e-02 7.78806898772556488452778467035387e-01 1.60550762521879117686318672042489e-03
 	 5.91602846138907789708127893391065e-02 8.08492433867083359899652350577526e-01 1.34886276670402615630861564710585e-03
 	 3.21617276826355880103847084683366e-02 8.31693122196116574329494142148178e-01 1.03687612092708165978383050287448e-03
 	 1.31709850003689510344884183723480e-02 8.48012450048712840278142266470240e-01 6.81607904073415070585195696395431e-04
 	 2.50868963898276398083453386789188e-03 8.57174887588670553206782187771751e-01 2.98100844471232994704890106874018e-04
 	 9.93641142341365912749040489870822e-01 5.14943433124953262036704870752146e-03 3.55411342662406188694520191295734e-06
 	 9.78789517517072771290997934556799e-01 1.71763534495303835103463541145175e-02 2.11378101737768696441379517869663e-05
 	 9.55747055076380247484735264151823e-01 3.58362533149596332315844904314872e-02 6.27035742989850351748401524609733e-05
 	 9.24909854207592641017754431231879e-01 6.08083708489574881195238731379504e-02 1.36139981691636447738366633153362e-04
 	 8.86805875060793447062224004184827e-01 9.16651613149814525893788186294842e-02 2.46545417018888041085084017467466e-04
 	 8.42087181576014809358809998229844e-01 1.27878580114579004645136706130870e-01 3.95707615265118283626177841938443e-04
 	 7.91518958392199212248385720158694e-01 1.68828976948742909280909429980966e-01 5.81822487577950630231737871866926e-04
 	 7.35966457544997010309373308700742e-01 2.13815666446491414731667646265123e-01 7.99474003529135638854152823284949e-04
 	 6.76380205535952239159769305842929e-01 2.62068907553286656320068459535833e-01 1.03987893703680984655579599973407e-03
 	 6.13779743822228218697034662909573e-01 3.12763070562742329094874094153056e-01 1.29138192268722770336686345160615e-03
 	 5.49236185933714371465441672626184e-01 3.65030762449322088158965016191360e-01 1.54016885590591294692697221790922e-03
 	 4.83853891201996677562391369065153e-01 4.17977667573111777432615099314717e-01 1.77115140418534350308377156579809e-03
 	 4.18751569204530882384318601907580e-01 4.70697849394232037401053503344883e-01 1.96896332537724533598422205216139e-03
 	 3.55043138426673232643793198803905e-01 5.22289251222843531330397581768921e-01 2.11900124288856746279652298881047e-03
 	 2.93818666700587094453567260643467e-01 5.71869130745834119977644149912521e-01 2.20843906256752492076045335522849e-03
 	 2.36125719469965966723634664958809e-01 6.18589164294146565126197856443468e-01 2.22714657687052806911420788082978e-03
 	 1.82951434776206678378684955532663e-01 6.61649962607486763488395808963105e-01 2.16844890682964036229818383105794e-03
 	 1.35205630986380942459845755365677e-01 7.00314750279624309570181139861234e-01 2.02967388497742994707406793963855e-03
 	 9.37052342256400327968890451302286e-02 7.33921976500527040165877679100959e-01 1.81244862753064672755698438777472e-03
 	 5.91602846138907789708127893391065e-02 7.61896647275000393761956729576923e-01 1.52272367433119127852481078377878e-03
 	 3.21617276826355880103847084683366e-02 7.83760211993614341885461271886015e-01 1.17052368532817759050335126858045e-03
 	 1.31709850003689510344884183723480e-02 7.99139009191756954919583222363144e-01 7.69463371488846156406871124033842e-04
 	 2.50868963898276398083453386789188e-03 8.07773388624561938797796756261960e-01 3.36524385148270093782996159603726e-04
 	 9.93641142341365912749040489870822e-01 4.79935251656027957872785449922048e-03 3.89649112077520864180334853044130e-06
 	 9.78789517517072771290997934556799e-01 1.60086273269027558330268590225387e-02 2.31740745913637545062065820067332e-05
 	 9.55747055076380247484735264151823e-01 3.33999428806210016396072148836538e-02 6.87439851149993289263634421715210e-05
 	 9.24909854207592641017754431231879e-01 5.66743430226555461315385286980018e-02 1.49254727176176699978901729615188e-04
 	 8.86805875060793558084526466700481e-01 8.54333494396089243583247707647388e-02 2.70295827107133203575511926075592e-04
 	 8.42087181576014698336507535714190e-01 1.19184816390917006079241957650083e-01 4.33827237407062615056480003872252e-04
 	 7.91518958392199323270688182674348e-01 1.57351220204925146273211566949612e-01 6.37871076294895347248703476594756e-04
 	 7.35966457544997010309373308700742e-01 1.99279511268371817278577395882166e-01 8.76489571972062530592906259840902e-04
 	 6.76380205535952128137466843327275e-01 2.44252279001850758355374182428932e-01 1.14005338560447741502734686491749e-03
 	 6.13779743822228218697034662909573e-01 2.91500023737205071761025010346202e-01 1.41578435780537257963895836354595e-03
 	 5.49236185933714482487744135141838e-01 3.40214321746280579095156326729921e-01 1.68853763264170783804651865267488e-03
 	 4.83853891201996733073542600322980e-01 3.89561657007526096485605648922501e-01 1.94177137630411342575365019058609e-03
 	 4.18751569204530937895469833165407e-01 4.38697682640716735136265924666077e-01 2.15863907352892162375135320928621e-03
 	 3.55043138426673232643793198803905e-01 4.86781667845929910676261442858959e-01 2.32313056358183795541139105012007e-03
 	 2.93818666700587094453567260643467e-01 5.32990883121364000807318461738760e-01 2.42118417876191829862797533223784e-03
 	 2.36125719469965966723634664958809e-01 5.76534677674321205387286681798287e-01 2.44169384027901475997524016747775e-03
 	 1.82951434776206678378684955532663e-01 6.16668008338638107268536714400398e-01 2.37734165939159670932756540651098e-03
 	 1.35205630986380942459845755365677e-01 6.52704189029481907091678749566199e-01 2.22519805126084784310802611173585e-03
 	 9.37052342256400327968890451302286e-02 6.84026644150248941400604962836951e-01 1.98704687676288507466870747464327e-03
 	 5.91602846138907789708127893391065e-02 7.10099470395774590159021499857772e-01 1.66941190789780683281784412486104e-03
 	 3.21617276826355880103847084683366e-02 7.30476651189494230465015789377503e-01 1.28328350816608676397689858816875e-03
 	 1.31709850003689510344884183723480e-02 7.44809928261631615242777115781792e-01 8.43587931749253516072739600417663e-04
 	 2.50868963898276398083453386789188e-03 7.52857303564253177441401021496858e-01 3.68942721082511659348723842555273e-04
 	 9.93641142341365912749040489870822e-01 4.42036320174291931517362996828524e-03 4.16933628228950839352028381878945e-06
 	 9.78789517517072771290997934556799e-01 1.47444779065685170615918053727000e-02 2.47967997378712408438998504589534e-05
 	 9.55747055076380247484735264151823e-01 3.07624576316029227363024745045550e-02 7.35576657164597959466523224847379e-05
 	 9.24909854207592641017754431231879e-01 5.21989538205149261607118660322158e-02 1.59706035515114902218619663543109e-04
 	 8.86805875060793447062224004184827e-01 7.86869547009546310700756066580652e-02 2.89222832537858914100231677579700e-04
 	 8.42087181576014698336507535714190e-01 1.09773177686577794176514544233214e-01 4.64205251623115333799163284567157e-04
 	 7.91518958392199101226083257643040e-01 1.44925704278480893538727514169295e-01 6.82536913183125009373097835663202e-04
 	 7.35966457544997010309373308700742e-01 1.83543054075002820546558268688386e-01 9.37864263051234933049604691746026e-04
 	 6.76380205535952128137466843327275e-01 2.24964468085257607299354276619852e-01 1.21988368432418602463340739916475e-03
 	 6.13779743822228329719337125425227e-01 2.68481211536140518258974907439551e-01 1.51492224874402140084861390079141e-03
 	 5.49236185933714482487744135141838e-01 3.13348699301425004382082306619850e-01 1.80677460760738967278371536195891e-03
 	 4.83853891201996788584693831580807e-01 3.58799235418579776091263511261786e-01 2.07774061333554187214200936750785e-03
 	 4.18751569204530882384318601907580e-01 4.04055148344209247301961340781418e-01 2.30979410209495574987648147669006e-03
 	 3.55043138426673288154944430061732e-01 4.48342097065077493933671348713688e-01 2.48580382888448966210992452374740e-03
 	 2.93818666700587094453567260643467e-01 4.90902320361894406453018291358603e-01 2.59072348164597924743968171412689e-03
 	 2.36125719469965966723634664958809e-01 5.31007602572774128901755830156617e-01 2.61266929731710385170773136565003e-03
 	 1.82951434776206678378684955532663e-01 5.67971734175899967134171220095595e-01 2.54381096444735279107907111040277e-03
 	 1.35205630986380942459845755365677e-01 6.01162254461192535615055021480657e-01 2.38101375900376215077880459602966e-03
 	 9.37052342256400327968890451302286e-02 6.30011276808756126577293343871133e-01 2.12618645368536311052176657199198e-03
 	 5.91602846138907789708127893391065e-02 6.54025216460715652644353212963324e-01 1.78630963652746986916608484818880e-03
 	 3.21617276826355880103847084683366e-02 6.72793277324137628525591026118491e-01 1.37314325253644039029343737468025e-03
 	 1.31709850003689510344884183723480e-02 6.85994701956198382752916131721577e-01 9.02658741448377605585962069056905e-04
 	 2.50868963898276398083453386789188e-03 6.93406602110558711871135528781451e-01 3.94777307432924242942134940292931e-04
 	 9.93641142341365912749040489870822e-01 4.01922942824544694728761129454142e-03 4.36777979731871330963417082715594e-06
 	 9.78789517517072771290997934556799e-01 1.34064638586323912894382459626286e-02 2.59770269415057471294044910692378e-05
 	 9.55747055076380247484735264151823e-01 2.79708633329816096224629262678718e-02 7.70587125867069466095271579320070e-05
 	 9.24909854207592641017754431231879e-01 4.74620662927236758310556297146832e-02 1.67307395758859768237353238262699e-04
 	 8.86805875060793558084526466700481e-01 7.15463661059330402469669252241147e-02 3.02988667584390349192535740741050e-04
 	 8.42087181576014698336507535714190e-01 9.98116141261755074332029380457243e-02 4.86299540879275436940087917747633e-04
 	 7.91518958392199212248385720158694e-01 1.31774161751142010468029752701113e-01 7.15022904961861035209869097428736e-04
 	 7.35966457544997010309373308700742e-01 1.66887110995183829409427289647283e-01 9.82502802228497505374060771998757e-04
 	 6.76380205535952239159769305842929e-01 2.04549664625146065954908181083738e-01 1.27794520535629051519177501461400e-03
 	 6.13779743822228218697034662909573e-01 2.44117403273914262973320887795126e-01 1.58702641009788279757852791362893e-03
 	 5.49236185933714482487744135141838e-01 2.84913310525736873657365322287660e-01 1.89276975880738745905418340953474e-03
 	 4.83853891201996733073542600322980e-01 3.26239356362778787357115106715355e-01 2.17663264859320818023213917058456e-03
 	 4.18751569204530937895469833165407e-01 3.67388440438287333655864586035023e-01 2.41973094325609837385027134359916e-03
 	 3.55043138426673232643793198803905e-01 4.07656490700746942934529215563089e-01 2.60411801993986171191441947314615e-03
 	 2.93818666700587094453567260643467e-01 4.46354510329499687415477637841832e-01 2.71403142309228863002235065948753e-03
 	 2.36125719469966022234785896216636e-01 4.82820366896783370602719287489890e-01 2.73702177067619307343493417761238e-03
 	 1.82951434776206678378684955532663e-01 5.16430122192511609213738665857818e-01 2.66488606014041650923984683174695e-03
 	 1.35205630986380942459845755365677e-01 5.46608709286175553643261082470417e-01 2.49434036728831765375447027111022e-03
 	 9.37052342256400327968890451302286e-02 5.72839775446014831672414402419236e-01 2.22738431466603476957533125357713e-03
 	 5.91602846138907789708127893391065e-02 5.94674527146782261333157748595113e-01 1.87133073801760843948849277751378e-03
 	 3.21617276826355880103847084683366e-02 6.11739446722536772682587979943492e-01 1.43849930808644609590840612867169e-03
 	 1.31709850003689510344884183723480e-02 6.23742884438926559198534960160032e-01 9.45621640432023607275580090458789e-04
 	 2.50868963898276398083453386789188e-03 6.30482178442613006019712429406354e-01 4.13567107831978473739265034225809e-04
 	 9.93641142341365912749040489870822e-01 3.60310941819482312767353171523155e-03 4.48828034786000424559123181400544e-06
 	 9.78789517517072771290997934556799e-01 1.20184620102201794589191763407143e-02 2.66936944918705740443804624861812e-05
 	 9.55747055076380247484735264151823e-01 2.50749759149981252259742348087457e-02 7.91846478951676571635814871896741e-05
 	 9.24909854207592641017754431231879e-01 4.25482100784062011733510644262424e-02 1.71923158053229182748444792139253e-04
 	 8.86805875060793447062224004184827e-01 6.41390072789244924944540571232210e-02 3.11347674435904272355335464794734e-04
 	 8.42087181576014698336507535714190e-01 8.94778895615929159568224804388592e-02 4.99715822176217700639755392444386e-04
 	 7.91518958392199101226083257643040e-01 1.18131281569446355828034711521468e-01 7.34749323805235264941981832009787e-04
 	 7.35966457544997121331675771216396e-01 1.49608906915415451610584796071635e-01 1.00960859374517905422130592540952e-03
 	 6.76380205535952128137466843327275e-01 1.83372170277224633139212528476492e-01 1.31320181350800396780087453407759e-03
 	 6.13779743822228218697034662909573e-01 2.18843370497880856939687532758398e-01 1.63081010914282098153704758658478e-03
 	 5.49236185933714371465441672626184e-01 2.55415584218711577690896774583962e-01 1.94498846226038874657193744610595e-03
 	 4.83853891201996733073542600322980e-01 2.92463050065217888828783543431200e-01 2.23668270712469368852182149964847e-03
 	 4.18751569204530882384318601907580e-01 3.29351875405870020419030197444954e-01 2.48648772229590961369005697179091e-03
 	 3.55043138426673232643793198803905e-01 3.65450882378046904008783712924924e-01 2.67596176427648858864305481120027e-03
 	 2.93818666700587094453567260643467e-01 4.00142407576874692409774070256390e-01 2.78890751480134150425138628293098e-03
 	 2.36125719469966022234785896216636e-01 4.32832870658371005045950141720823e-01 2.81253213189276447120379387456524e-03
 	 1.82951434776206622867533724274836e-01 4.62962931161567115001531647067168e-01 2.73840630435553478508325930818046e-03
 	 1.35205630986380886948694524107850e-01 4.90017060149784910993986386529286e-01 2.56315550940700237828040464194146e-03
 	 9.37052342256399217745865826145746e-02 5.13532364069886781976492784451693e-01 2.28883453620629118141494018345838e-03
 	 5.91602846138907789708127893391065e-02 5.33106514016167487568509386619553e-01 1.92295797076280985948848467614880e-03
 	 3.21617276826355880103847084683366e-02 5.48404663460445251921271392347990e-01 1.47818536521874296756073885461547e-03
 	 1.31709850003689510344884183723480e-02 5.59165357832032694496149360929849e-01 9.71709935530088689432937076873031e-04
 	 2.50868963898276398083453386789188e-03 5.65206917322521040780713974527316e-01 4.24976809440588698413981960655406e-04
 	 9.93641142341365912749040489870822e-01 3.17942882931704405916062405879075e-03 4.52868755788813608239521540932415e-06
 	 9.78789517517072771290997934556799e-01 1.06052412414636160892245086984076e-02 2.69340131966221803998338263363976e-05
 	 9.55747055076380247484735264151823e-01 2.21264724618098797270793198777028e-02 7.98975335552689339873103091527184e-05
 	 9.24909854207592641017754431231879e-01 3.75450728962036864300166882912890e-02 1.73470952446123737435493272762699e-04
 	 8.86805875060793447062224004184827e-01 5.65970624696032556522062861859013e-02 3.14150683583650695927108609240008e-04
 	 8.42087181576014698336507535714190e-01 7.89564092119926369539584243284480e-02 5.04214677108638046482136374493166e-04
 	 7.91518958392199212248385720158694e-01 1.04240520803900407753594947735110e-01 7.41364144614987410041029303187088e-04
 	 7.35966457544997010309373308700742e-01 1.32016771227501522600888961278542e-01 1.01869792492145457875329928043584e-03
 	 6.76380205535952128137466843327275e-01 1.61809897232023963686842193965276e-01 1.32502434182066655687926015616540e-03
 	 6.13779743822228218697034662909573e-01 1.93110128088885918407058284174127e-01 1.64549200989074417486590640180566e-03
 	 5.49236185933714482487744135141838e-01 2.25381907033142814267279163686908e-01 1.96249885626559447335259811495689e-03
 	 4.83853891201996788584693831580807e-01 2.58073054399001688974379931096337e-01 2.25681917385769752193436232801105e-03
 	 4.18751569204530882384318601907580e-01 2.90624215397734586563416314675123e-01 2.50887314028235214671824770960029e-03
 	 3.55043138426673288154944430061732e-01 3.22478430786663439189254631855874e-01 2.70005298422176798212035464530345e-03
 	 2.93818666700587038942416029385640e-01 3.53090666649706508284367600936093e-01 2.81401556576196028996994513704522e-03
 	 2.36125719469966022234785896216636e-01 3.81937140265017072149333898778423e-01 2.83785287118625516311620771148228e-03
 	 1.82951434776206622867533724274836e-01 4.08524282611896716321808753491496e-01 2.76305970167177233562383342757585e-03
 	 1.35205630986380886948694524107850e-01 4.32397184506809584281228353574988e-01 2.58623115419214909954659376012387e-03
 	 9.37052342256400327968890451302286e-02 4.53147382887180039112706708692713e-01 2.30944051681715618873358408791319e-03
 	 5.91602846138908344819640205969336e-02 4.70419857693054666025744836588274e-01 1.94027002807155854804954664416528e-03
 	 3.21617276826356435215359397261636e-02 4.83919136158682261505958877023659e-01 1.49149321185122513307164116014292e-03
 	 1.31709850003688955233371871145209e-02 4.93414507499815579993907022071653e-01 9.80458071655343791836467737255134e-04
 	 2.50868963898281949198576512571890e-03 4.98745655180508673520733964323881e-01 4.28802801995697003938079472362688e-04
 	 9.93641142341365912749040489870822e-01 2.75574824043926368960510941974462e-03 4.48828034785999069306407574520001e-06
 	 9.78789517517072771290997934556799e-01 9.19202047270704751535941312567957e-03 2.66936944918704961173493150905500e-05
 	 9.55747055076380247484735264151823e-01 1.91779690086216203503965971322032e-02 7.91846478951674267706198340199819e-05
 	 9.24909854207592641017754431231879e-01 3.25419357140011508700006004346506e-02 1.71923158053228667752412861524647e-04
 	 8.86805875060793447062224004184827e-01 4.90551176602820049321707074341248e-02 3.11347674435903350783488852115966e-04
 	 8.42087181576014698336507535714190e-01 6.84349288623923024399431369602098e-02 4.99715822176216291176931161288621e-04
 	 7.91518958392199212248385720158694e-01 9.03497600383544041680039526909241e-02 7.34749323805233096537636861000919e-04
 	 7.35966457544997010309373308700742e-01 1.14424635539587482568890663969796e-01 1.00960859374517601845522296599711e-03
 	 6.76380205535952128137466843327275e-01 1.40247624186823210967745012567320e-01 1.31320181350800006467305358626163e-03
 	 6.13779743822228218697034662909573e-01 1.67376885679890868852126573074202e-01 1.63081010914281599420705415326438e-03
 	 5.49236185933714482487744135141838e-01 1.95348229847573995332510321532027e-01 1.94498846226038310872064052148289e-03
 	 4.83853891201996788584693831580807e-01 2.23683058732785322586522624987992e-01 2.23668270712468718330878658662186e-03
 	 4.18751569204530937895469833165407e-01 2.51896555389598986174348738131812e-01 2.48648772229590224111528407036076e-03
 	 3.55043138426673288154944430061732e-01 2.79505979195279807836271857013344e-01 2.67596176427648078238741291556835e-03
 	 2.93818666700587149964718491901294e-01 3.06038925722538157625507437842316e-01 2.78890751480133326431487539309728e-03
 	 2.36125719469966022234785896216636e-01 3.31041409871662917208112730804714e-01 2.81253213189275623126728298473154e-03
 	 1.82951434776206622867533724274836e-01 3.54085634062226095597480934884516e-01 2.73840630435552654514674841834676e-03
 	 1.35205630986380886948694524107850e-01 3.74777308863834035523865395589382e-01 2.56315550940699500570563174051131e-03
 	 9.37052342256400327968890451302286e-02 3.92762401704473185226618170418078e-01 2.28883453620628467620190527043178e-03
 	 5.91602846138907789708127893391065e-02 4.07733201369941622438375361525686e-01 1.92295797076280422163718775152574e-03
 	 3.21617276826355880103847084683366e-02 4.19433608856919049046041436668020e-01 1.47818536521873863075204891259773e-03
 	 1.31709850003689510344884183723480e-02 4.27663657167598243447059758182149e-01 9.71709935530085870507288614561503e-04
 	 2.50868963898276398083453386789188e-03 4.32284393038496084216149029089138e-01 4.24976809440587451581483602325306e-04
 	 9.93641142341365912749040489870822e-01 2.33962823038863856894842285782943e-03 4.36777979731870738040354004705357e-06
 	 9.78789517517072771290997934556799e-01 7.80401862429483395011686752695823e-03 2.59770269415057132480866008972242e-05
 	 9.55747055076380247484735264151823e-01 1.62820815906381324844609537194629e-02 7.70587125867068381893099093815636e-05
 	 9.24909854207592641017754431231879e-01 2.76280794996836692734021312389814e-02 1.67307395758859551396918741161812e-04
 	 8.86805875060793558084526466700481e-01 4.16477588332734294240822237043176e-02 3.02988667584389969721775370814498e-04
 	 8.42087181576014698336507535714190e-01 5.81012042978097109635626793533447e-02 4.86299540879274786418784426444972e-04
 	 7.91518958392199212248385720158694e-01 7.67068798566587217724332958823652e-02 7.15022904961860059427913860474746e-04
 	 7.35966457544996899287070846185088e-01 9.71464314598191047700481703941477e-02 9.82502802228496204331453789393436e-04
 	 6.76380205535952128137466843327275e-01 1.19070129838901722640898128702247e-01 1.27794520535628899730873353490779e-03
 	 6.13779743822228107674732200393919e-01 1.42102852903857435062917602408561e-01 1.58702641009788084601461743972095e-03
 	 5.49236185933714482487744135141838e-01 1.65850503540548588343739311312675e-01 1.89276975880738507380940394142499e-03
 	 4.83853891201996733073542600322980e-01 1.89906752435224368547039830446010e-01 2.17663264859320514446605621117214e-03
 	 4.18751569204530937895469833165407e-01 2.13859990357181617426363118283916e-01 2.41973094325609533808418838418675e-03
 	 3.55043138426673232643793198803905e-01 2.37300370872579713399375123117352e-01 2.60411801993985824246746751953197e-03
 	 2.93818666700587038942416029385640e-01 2.59826822969913051597501407741220e-01 2.71403142309228516057539870587334e-03
 	 2.36125719469965966723634664958809e-01 2.81053913633250496140192353777820e-01 2.73702177067618960398798222399819e-03
 	 1.82951434776206678378684955532663e-01 3.00618443031281601385273916093865e-01 2.66488606014041303979289487813276e-03
 	 1.35205630986380942459845755365677e-01 3.18185659727443392874590699648252e-01 2.49434036728831461798838731169781e-03
 	 9.37052342256400327968890451302286e-02 3.33454990328344913486091627419228e-01 2.22738431466603173380924829416472e-03
 	 5.91602846138907789708127893391065e-02 3.46165188239326737651424537034472e-01 1.87133073801760605424371330940403e-03
 	 3.21617276826355880103847084683366e-02 3.56098825594827417262422386556864e-01 1.43849930808644414434449565476370e-03
 	 1.31709850003689510344884183723480e-02 3.63086130560704267722371696436312e-01 9.45621640432022414653190356403911e-04
 	 2.50868963898276398083453386789188e-03 3.67009131918404007954848111694446e-01 4.13567107831977931638178791473592e-04
 	 9.93641142341365912749040489870822e-01 1.93849445689116880314761814929625e-03 4.16933628228950331132260029298742e-06
 	 9.78789517517072771290997934556799e-01 6.46600457635871511685721202411514e-03 2.47967997378712103507137493041412e-05
 	 9.55747055076380247484735264151823e-01 1.34904872920168332484092132972364e-02 7.35576657164597146314893860719053e-05
 	 9.24909854207592641017754431231879e-01 2.28911919718924397604276066431339e-02 1.59706035515114739588293790717444e-04
 	 8.86805875060793447062224004184827e-01 3.45071702382518802343369657137373e-02 2.89222832537858588839579931928370e-04
 	 8.42087181576014698336507535714190e-01 4.81396407374074797314023044236819e-02 4.64205251623114791698077041814940e-04
 	 7.91518958392199212248385720158694e-01 6.35553373293199219684623813009239e-02 6.82536913183124250431577095810098e-04
 	 7.35966457544997121331675771216396e-01 8.04904883800002246552196538686985e-02 9.37864263051233957267649454792036e-04
 	 6.76380205535952128137466843327275e-01 9.86553263787902923187544956817874e-02 1.21988368432418472359080041655943e-03
 	 6.13779743822228107674732200393919e-01 1.17739044641631263043990429650876e-01 1.51492224874401966612513792398431e-03
 	 5.49236185933714482487744135141838e-01 1.37415114764860624152476020753966e-01 1.80677460760738750437937039095004e-03
 	 4.83853891201996733073542600322980e-01 1.57346873379423546346345119673060e-01 2.07774061333553927005679540229721e-03
 	 4.18751569204530937895469833165407e-01 1.77193282451259870313720057311002e-01 2.30979410209495314779126751147942e-03
 	 3.55043138426673232643793198803905e-01 1.96614764508249328933686683740234e-01 2.48580382888448706002471055853675e-03
 	 2.93818666700587094453567260643467e-01 2.15279012937518610115716910513584e-01 2.59072348164597621167359875471448e-03
 	 2.36125719469965966723634664958809e-01 2.32866677957260015396911967400229e-01 2.61266929731710081594164840623762e-03
 	 1.82951434776206678378684955532663e-01 2.49076831047893465509446286887396e-01 2.54381096444734975531298815099035e-03
 	 1.35205630986380942459845755365677e-01 2.63632114552426521925099223153666e-01 2.38101375900375954869359063081902e-03
 	 9.37052342256400327968890451302286e-02 2.76283488965603951648120073514292e-01 2.12618645368536050843655260678133e-03
 	 5.91602846138907789708127893391065e-02 2.86814498925393679407136460213223e-01 1.78630963652746791760217437428082e-03
 	 3.21617276826355880103847084683366e-02 2.95044994993226894486326727928827e-01 1.37314325253643887241039589497404e-03
 	 1.31709850003689510344884183723480e-02 3.00834313043432777234897912421729e-01 9.02658741448376629804006832102914e-04
 	 2.50868963898276398083453386789188e-03 3.04084708250458524148029937350657e-01 3.94777307432923809261265946091157e-04
 	 9.93641142341365912749040489870822e-01 1.55950514207380680486991764155391e-03 3.89649112077519170114440344443452e-06
 	 9.78789517517072771290997934556799e-01 5.20185515602447287597520642066229e-03 2.31740745913636562503847005078939e-05
 	 9.55747055076380247484735264151823e-01 1.08530020429987508756575209645234e-02 6.87439851149990307707660086578016e-05
 	 9.24909854207592641017754431231879e-01 1.84158027697518128507070400701195e-02 1.49254727176176076562652550450139e-04
 	 8.86805875060793558084526466700481e-01 2.77607754995975730682999937926070e-02 2.70295827107132065163230816295936e-04
 	 8.42087181576014698336507535714190e-01 3.87280020330682261953114675634424e-02 4.33827237407060771912786778514715e-04
 	 7.91518958392199212248385720158694e-01 5.11298214028756137228270972627797e-02 6.37871076294892636743272262833671e-04
 	 7.35966457544997010309373308700742e-01 6.47540311866311446564736797881778e-02 8.76489571972058844305519809125826e-04
 	 6.76380205535952128137466843327275e-01 7.93675154621970857515833586148801e-02 1.14005338560447242769735343159709e-03
 	 6.13779743822228107674732200393919e-01 9.47202324405666540307890954863979e-02 1.41578435780536672494722694182201e-03
 	 5.49236185933714482487744135141838e-01 1.10549492320004993928250769386068e-01 1.68853763264170068231218024834561e-03
 	 4.83853891201996677562391369065153e-01 1.26584451790477114929700519496691e-01 1.94177137630410540265757379785327e-03
 	 4.18751569204530993406621064423234e-01 1.42550748154752271457113010910689e-01 2.15863907352891208277223533684719e-03
 	 3.55043138426673232643793198803905e-01 1.58175193727396856679945358337136e-01 2.32313056358182841443227317768105e-03
 	 2.93818666700587094453567260643467e-01 1.73190450178048904739114277617773e-01 2.42118417876190789028711947139527e-03
 	 2.36125719469965966723634664958809e-01 1.87339602855712827889078653242905e-01 2.44169384027900435163438430663518e-03
 	 1.82951434776206678378684955532663e-01 2.00380556885155103330475867551286e-01 2.37734165939158673466757853987019e-03
 	 1.35205630986380942459845755365677e-01 2.12090179984137150448475495068124e-01 2.22519805126083873580977723349861e-03
 	 9.37052342256400327968890451302286e-02 2.22268121624111025802505992032820e-01 1.98704687676287683473219658480957e-03
 	 5.91602846138907789708127893391065e-02 2.30740244990334630870165710803121e-01 1.66941190789779989392394021763266e-03
 	 3.21617276826355880103847084683366e-02 2.37361621127870070502297039638506e-01 1.28328350816608134296603616064658e-03
 	 1.31709850003689510344884183723480e-02 2.42019086737999433722734465845861e-01 8.43587931749249938205570398253030e-04
 	 2.50868963898276398083453386789188e-03 2.44634006796764058577764444635250e-01 3.68942721082510087255573738573844e-04
 	 9.93641142341365912749040489870822e-01 1.20942332738455376323072343325293e-03 3.55411342662404621683567770840106e-06
 	 9.78789517517072771290997934556799e-01 4.03412903339684172920875937506935e-03 2.11378101737767781645796483225297e-05
 	 9.55747055076380247484735264151823e-01 8.41669160866011234478634150946164e-03 6.27035742989847641242970310848648e-05
 	 9.24909854207592641017754431231879e-01 1.42817749434498639238277917229425e-02 1.36139981691635851427171766125923e-04
 	 8.86805875060793447062224004184827e-01 2.15289636242250309594581381134049e-02 2.46545417018886956882911531963032e-04
 	 8.42087181576014809358809998229844e-01 3.00342383094062415072045268971124e-02 3.95707615265116548902701865131348e-04
 	 7.91518958392199101226083257643040e-01 3.96520646590578507151292342314264e-02 5.81822487577948136566741155206728e-04
 	 7.35966457544997010309373308700742e-01 5.02178760085115472033834294052212e-02 7.99474003529132060986983621120316e-04
 	 6.76380205535952128137466843327275e-01 6.15508869107611600313134658790659e-02 1.03987893703680529290667156061545e-03
 	 6.13779743822228218697034662909573e-01 7.34571856150294522080912429373711e-02 1.29138192268722206551556652698309e-03
 	 5.49236185933714482487744135141838e-01 8.57330516169634293532908486668020e-02 1.54016885590590622487350280778173e-03
 	 4.83853891201996733073542600322980e-01 9.81684412248914339826910691044759e-02 1.77115140418533591366856416726705e-03
 	 4.18751569204530937895469833165407e-01 1.10550581401236969192325432231883e-01 1.96896332537723709604771116232769e-03
 	 3.55043138426673232643793198803905e-01 1.22667610350483236025809219427174e-01 2.11900124288855835549827411057322e-03
 	 2.93818666700587094453567260643467e-01 1.34312202553578674546486126928357e-01 2.20843906256751537978133548278947e-03
 	 2.36125719469965966723634664958809e-01 1.45285116235887357127865016082069e-01 2.22714657687051852813509000839076e-03
 	 1.82951434776206678378684955532663e-01 1.55398602616306558132919235504232e-01 2.16844890682963082131906595861892e-03
 	 1.35205630986380942459845755365677e-01 1.64479618733994747969973104773089e-01 2.02967388497742083977581906140131e-03
 	 9.37052342256400327968890451302286e-02 1.72372789273832816014930813253159e-01 1.81244862753063870446090799504191e-03
 	 5.91602846138907789708127893391065e-02 1.78943068111108716244928018568316e-01 1.52272367433118455647134137365128e-03
 	 3.21617276826355880103847084683366e-02 1.84078060323749959081851557129994e-01 1.17052368532817238633292333815916e-03
 	 1.31709850003689510344884183723480e-02 1.87690005807873983023625896748854e-01 7.69463371488842795380136418970096e-04
 	 2.50868963898276398083453386789188e-03 1.89717921736455186199066247354494e-01 3.36524385148268630110063304172741e-04
 	 9.93641142341365912749040489870822e-01 8.94496172859035945656991373198252e-04 3.14831334839638148298882058817583e-06
 	 9.78789517517072771290997934556799e-01 2.98366411453019828026178572599747e-03 1.87243461132816972299942881452495e-05
 	 9.55747055076380247484735264151823e-01 6.22503160110403352955898981235805e-03 5.55442317847387162358697987318834e-05
 	 9.24909854207592641017754431231879e-01 1.05628796297295018957740353471308e-02 1.20595847729413095184361481848612e-04
 	 8.86805875060793558084526466700481e-01 1.59229404059340329258276369728264e-02 2.18395457379593860118560666450094e-04
 	 8.42087181576014698336507535714190e-01 2.22134885396979286920071672284394e-02 3.50526676461372199266469662504164e-04
 	 7.91518958392199212248385720158694e-01 2.93268860293849076281702537016827e-02 5.15391402625767929869537997689122e-04
 	 7.35966457544996899287070846185088e-01 3.71414184608664377229558795079356e-02 7.08191994704424998378911038088290e-04
 	 6.76380205535952239159769305842929e-01 4.55233759190168396635556291585090e-02 9.21148074134192054902847690556200e-04
 	 6.13779743822228329719337125425227e-01 5.43293402019416338255553000635700e-02 1.14393505694494312247000422644305e-03
 	 5.49236185933714482487744135141838e-01 6.34086384994259066871791219455190e-02 1.36431609962398285758322646898932e-03
 	 4.83853891201996733073542600322980e-01 7.26059213369891764955355029087514e-02 1.56892561899024912501487971638880e-03
 	 4.18751569204530937895469833165407e-01 8.17638206008450829642697499366477e-02 1.74415185327280288299367505544524e-03
 	 3.55043138426673232643793198803905e-01 9.07256421368676235772454674588516e-02 1.87705880411122229441123199222829e-03
 	 2.93818666700587094453567260643467e-01 9.93380468460594023838439170503989e-02 1.95628482977416601890086056414475e-03
 	 2.36125719469965966723634664958809e-01 1.07453674411441046920856479118811e-01 1.97285636532344233265434674251537e-03
 	 1.82951434776206678378684955532663e-01 1.14933664797528867218545656214701e-01 1.92086065333373556471285859004183e-03
 	 1.35205630986380942459845755365677e-01 1.21650034474728330202708548313240e-01 1.79793062795851341442721071928190e-03
 	 9.37052342256400327968890451302286e-02 1.27487867001803367728030025318731e-01 1.60550762521879616419318015374529e-03
 	 5.91602846138907789708127893391065e-02 1.32347281519025861129534860083368e-01 1.34886276670403027627687109202270e-03
 	 3.21617276826355880103847084683366e-02 1.36145150121247837660121149383485e-01 1.03687612092708491239034795938778e-03
 	 1.31709850003689510344884183723480e-02 1.38816564950918208687369315157412e-01 6.81607904073417238989540667404299e-04
 	 2.50868963898276398083453386789188e-03 1.40316422772346682812383278360358e-01 2.98100844471233916276736719552787e-04
 	 9.93641142341365912749040489870822e-01 6.20343440827188750963383512271321e-04 2.68633341315918542995758860891797e-06
 	 9.78789517517072771290997934556799e-01 2.06920556983976322573681727590156e-03 1.59767567701882604426846801182194e-05
 	 9.55747055076380247484735264151823e-01 4.31713140856044425008875009552867e-03 4.73937341172229762505281602802398e-05
 	 9.24909854207592641017754431231879e-01 7.32547918411546872263784280221444e-03 1.02899749609990906517101305617246e-04
 	 8.86805875060793558084526466700481e-01 1.10427433221226556359084725045250e-02 1.86348355299455030464894633723816e-04
 	 8.42087181576014698336507535714190e-01 1.54053112037888240148930663053761e-02 2.99090788933525670179741640097859e-04
 	 7.91518958392199212248385720158694e-01 2.03385346301335756535877408168744e-02 4.39763451892039979734816412815235e-04
 	 7.35966457544997121331675771216396e-01 2.57580032473177511498363401187817e-02 6.04272703438294258096452615802718e-04
 	 6.76380205535952239159769305842929e-01 3.15709876828314528474095368437702e-02 7.85979848948112672611665541211323e-04
 	 6.13779743822228107674732200393919e-01 3.76780257550130559529577567445813e-02 9.76075322210417494622758383115979e-04
 	 5.49236185933714371465441672626184e-01 4.39746241274304727753019506053533e-02 1.16411790027117932264100197414791e-03
 	 4.83853891201996733073542600322980e-01 5.03530461428972619941646371444222e-02 1.33870325048862539966953999481802e-03
 	 4.18751569204530937895469833165407e-01 5.67041551945225430486630102677736e-02 1.48821698559858418831058912701337e-03
 	 3.55043138426673232643793198803905e-01 6.29192820742341396567098854575306e-02 1.60162132098985287437242774899460e-03
 	 2.93818666700587094453567260643467e-01 6.88920843434935870064350638131145e-02 1.66922180937153748561674326822413e-03
 	 2.36125719469965966723634664958809e-01 7.45203659182367417201930948067456e-02 1.68336165656179622199251078029647e-03
 	 1.82951434776206678378684955532663e-01 7.97078257579239002339477337955032e-02 1.63899573646362779061336212294009e-03
 	 1.35205630986380942459845755365677e-01 8.43657058046369812132070364896208e-02 1.53410432379208700251482788701196e-03
 	 9.37052342256400327968890451302286e-02 8.84143101773572359647346274869051e-02 1.36991725455280115644751681713842e-03
 	 5.91602846138907789708127893391065e-02 9.17843703447297487585387898434419e-02 1.15093217192279687229039542017972e-03
 	 3.21617276826355880103847084683366e-02 9.44182361431507022331288681016304e-02 8.84726093218159387147891958846913e-04
 	 1.31709850003689510344884183723480e-02 9.62708932227418490157333508250304e-02 5.81589532159646513224948716214158e-04
 	 2.50868963898276398083453386789188e-03 9.73110619679279365001889345876407e-02 2.54357864156672466588587910862884e-04
 	 9.93641142341365912749040489870822e-01 3.91857105260296802173858310425203e-04 2.17642062585610614617584110397353e-06
 	 9.78789517517072771290997934556799e-01 1.30707097298344426805627449539315e-03 1.29440905580037923030016153158606e-05
 	 9.55747055076380247484735264151823e-01 2.72703555071208275650818109170359e-03 3.83975793785624113863344519792520e-05
 	 9.24909854207592641017754431231879e-01 4.62734169302146669533470912938355e-03 8.33675880847714080579269335657955e-05
 	 8.86805875060793447062224004184827e-01 6.97545447819909736342225414773566e-03 1.50976197549184380395856375223218e-04
 	 8.42087181576014698336507535714190e-01 9.73119123481208658787977583415341e-03 2.42318157102089766713817753363003e-04
 	 7.91518958392199323270688182674348e-01 1.28473983617417020219875212205807e-02 3.56288702849410360284920784579299e-04
 	 7.35966457544997010309373308700742e-01 1.62707557225401922007534949443652e-02 4.89571238239667094922780155030750e-04
 	 6.76380205535952017115164380811621e-01 1.99426882423491824702921348944074e-02 6.36787208310903669536418014729406e-04
 	 6.13779743822228329719337125425227e-01 2.38003678810481678063126764754998e-02 7.90799255684950875081029586510795e-04
 	 5.49236185933714482487744135141838e-01 2.77777885303454596943595333868871e-02 9.43148083059026009697389802965972e-04
 	 4.83853891201996733073542600322980e-01 3.18068953486210226344610418891534e-02 1.08459409840628239439508373465060e-03
 	 4.18751569204530937895469833165407e-01 3.58187491772740118634033024136443e-02 1.20572752709688455624581493452752e-03
 	 3.55043138426673232643793198803905e-01 3.97447061031048765045170512166806e-02 1.29760574794542788389095644419058e-03
 	 2.93818666700587094453567260643467e-01 4.35175919812940126263356432900764e-02 1.35237448830771234478675957291216e-03
 	 2.36125719469965966723634664958809e-01 4.70728518265949302801232079218607e-02 1.36383034666117753178071758668466e-03
 	 1.82951434776206678378684955532663e-01 5.03496544211758934039835367002524e-02 1.32788584955827247517656797271002e-03
 	 1.35205630986380942459845755365677e-01 5.32919332809650425630820791411679e-02 1.24290465068874916333696578618628e-03
 	 9.37052342256400327968890451302286e-02 5.58493462967661891127590934047475e-02 1.10988314180202963035726249074742e-03
 	 5.91602846138907789708127893391065e-02 5.79781380834234472132493465323932e-02 9.32465235202621536662881407409031e-04
 	 3.21617276826355880103847084683366e-02 5.96418923193626770995479091652669e-02 7.16789698583476559030913666248352e-04
 	 1.31709850003689510344884183723480e-02 6.08121744445038192594665815704502e-02 4.71193727246860835731340211296470e-04
 	 2.50868963898276398083453386789188e-03 6.14692258238612732057504217664246e-02 2.06076319189379486909730054833290e-04
 	 9.93641142341365912749040489870822e-01 2.13113658943153531921677057425768e-04 1.62768547847023409273932697399756e-06
 	 9.78789517517072771290997934556799e-01 7.10857794363216333177746264482266e-04 9.68053141151374540692483433579341e-06
 	 9.55747055076380247484735264151823e-01 1.48311340148919723613829546593479e-03 2.87164997521146816907445381561459e-05
 	 9.24909854207592641017754431231879e-01 2.51660543127052438450164117966779e-03 6.23483396952708747440485836932567e-05
 	 8.86805875060793447062224004184827e-01 3.79363958617758012525911226475728e-03 1.12910970161752150777920156166090e-04
 	 8.42087181576014698336507535714190e-01 5.29236229760018939138888072193367e-03 1.81223124243087927581763452167252e-04
 	 7.91518958392199212248385720158694e-01 6.98712881817550868213118064886658e-03 2.66458579229309009805265473502800e-04
 	 7.35966457544997121331675771216396e-01 8.84894069611791289631241852475796e-03 3.66136943241817259652587379648025e-04
 	 6.76380205535952128137466843327275e-01 1.08459415522565993938997053191997e-02 4.76235742084804721495350232629562e-04
 	 6.13779743822228107674732200393919e-01 1.29439620086868045767403145873686e-02 5.91417141324484673010897228806471e-04
 	 5.49236185933714482487744135141838e-01 1.51071042775114405820602314634016e-02 7.05354663801881784715441803257363e-04
 	 4.83853891201996788584693831580807e-01 1.72983563558554709338466182089178e-02 8.11138271268680463403633051910901e-04
 	 4.18751569204530937895469833165407e-01 1.94802253001519209973935176094528e-02 9.01730650560916987233672781343330e-04
 	 3.55043138426673232643793198803905e-01 2.16153787376818229404307203367352e-02 9.70443859802824944360555292632853e-04
 	 2.93818666700587094453567260643467e-01 2.36672836374072215193109514075331e-02 1.01140390323502249447784606672940e-03
 	 2.36125719469965966723634664958809e-01 2.56008314127434966067653476784471e-02 1.01997142647194862646875535006075e-03
 	 1.82951434776206678378684955532663e-01 2.73829386686568199138491763733327e-02 9.93089519881718571850393040278959e-04
 	 1.35205630986380942459845755365677e-01 2.89831133369820026501884058234282e-02 9.29534404799814526106083167888983e-04
 	 9.37052342256400327968890451302286e-02 3.03739765825628005302405654219911e-02 8.30051255372325443894487850826636e-04
 	 5.91602846138907789708127893391065e-02 3.15317317966256061012586542346980e-02 6.97365253980084713950060582021706e-04
 	 3.21617276826355880103847084683366e-02 3.24365737608095505706273797841277e-02 5.36067417134704913075915477804756e-04
 	 1.31709850003689510344884183723480e-02 3.30730381819891450234649710182566e-02 3.52392905247483510453032629072823e-04
 	 2.50868963898276398083453386789188e-03 3.34303792169959868019191162602510e-02 1.54118844591085292321241961843725e-04
 	 9.93641142341365912749040489870822e-01 8.72992585909263332788476930090837e-05 1.04998275983301723731993485705383e-06
 	 9.78789517517072771290997934556799e-01 2.91193716626315934892232917263755e-04 6.24468991249115919559128581872720e-06
 	 9.55747055076380247484735264151823e-01 6.07538254461720272914249107998330e-04 1.85243587052256932640181830151960e-05
 	 9.24909854207592641017754431231879e-01 1.03089491966547319723446207717643e-03 4.02194912040214163067436414777944e-05
 	 8.86805875060793447062224004184827e-01 1.55401547172924481277078712082584e-03 7.28362903239036492755720253455820e-05
 	 8.42087181576014809358809998229844e-01 2.16794787845253633662423453642987e-03 1.16902902099460465957549148985350e-04
 	 7.91518958392199323270688182674348e-01 2.86218710021174382873709873820189e-03 1.71886349114154659374273381722276e-04
 	 7.35966457544997010309373308700742e-01 3.62485429567060979394454989233054e-03 2.36186587167428846097474992582477e-04
 	 6.76380205535952239159769305842929e-01 4.44289991044205523351706688117702e-03 3.07208809944833969966804243512115e-04
 	 6.13779743822228107674732200393919e-01 5.30232690007398366205393358541187e-03 3.81509702257746131752458307317966e-04
 	 5.49236185933714482487744135141838e-01 6.18843019927856063944204834115226e-03 4.55008198055465763482568819497942e-04
 	 4.83853891201996733073542600322980e-01 7.08604831898940190626490220893174e-03 5.23246789344902697889427845012733e-04
 	 4.18751569204530937895469833165407e-01 7.97982275899589144074752766755410e-03 5.81685865989181702558064035457619e-04
 	 3.55043138426673232643793198803905e-01 8.85446079486174042472157452721149e-03 6.26011189297103268214250704204460e-04
 	 2.93818666700587094453567260643467e-01 9.69499714214916430421453696908429e-03 6.52433578643624449873439363756233e-04
 	 2.36125719469965966723634664958809e-01 1.04870500216973638885065156500787e-02 6.57960292380541079092226564029033e-04
 	 1.82951434776206678378684955532663e-01 1.12170672479149358125027902133297e-02 6.40619387860270526023620529798563e-04
 	 1.35205630986380942459845755365677e-01 1.18725581388016143691288561967667e-02 5.99621433391868017756531905604334e-04
 	 9.37052342256400327968890451302286e-02 1.24423073080603963092016783775762e-02 5.35447123812767314908478422097460e-04
 	 5.91602846138907789708127893391065e-02 1.29165667821771190659774219966494e-02 4.49854412090617346471621562642440e-04
 	 3.21617276826355880103847084683366e-02 1.32872236091817752523525086871814e-02 3.45804858214165109810134257628533e-04
 	 1.31709850003689510344884183723480e-02 1.35479430410755385949528317723889e-02 2.27320621883949622104789667353941e-04
 	 2.50868963898276398083453386789188e-03 1.36943231819587341036026373330969e-02 9.94185497913950300694421735592243e-05
 	 9.93641142341365912749040489870822e-01 1.66305271052822820077032872632117e-05 4.54441028047960072542925911986966e-07
 	 9.78789517517072771290997934556799e-01 5.54724642042418725207397756093997e-05 2.70275228530849512565965679644631e-06
 	 9.55747055076380247484735264151823e-01 1.15736165133613344568885850094375e-04 8.01749222555875540796241351948481e-06
 	 9.24909854207592641017754431231879e-01 1.96385698812528985968128836248070e-04 1.74073209861351439731690093903893e-05
 	 8.86805875060793558084526466700481e-01 2.96040273901107542364741220808355e-04 3.15241353670020705017747186804655e-05
 	 8.42087181576014809358809998229844e-01 4.12994526384130589136134403815959e-04 5.05965212422321918115004912852584e-05
 	 7.91518958392199101226083257643040e-01 5.45247244005897524488091221428476e-04 7.43938016765813243469721016687402e-05
 	 7.35966457544997010309373308700742e-01 6.90535504995870574873606528853998e-04 1.02223464602956950531865987219504e-04
 	 6.76380205535952239159769305842929e-01 8.46373366501229629221825234708376e-04 1.32962456868266260022817815134033e-04
 	 6.13779743822228218697034662909573e-01 1.01009438861277001109328921302222e-03 1.65120483818090074603496253402568e-04
 	 5.49236185933714371465441672626184e-01 1.17889725330322381324776870314963e-03 1.96931227068394701720799311317478e-04
 	 4.83853891201996733073542600322980e-01 1.34989369371962819599275462678634e-03 2.26465441118773989524412537654996e-04
 	 4.18751569204530937895469833165407e-01 1.52015791234483277349909258191474e-03 2.51758345997158045938280057640668e-04
 	 3.55043138426673232643793198803905e-01 1.68677664196015264508332620607689e-03 2.70942704315397056048786428306130e-04
 	 2.93818666700587094453567260643467e-01 1.84689899273560165227081597549841e-03 2.82378528061708955823605471380233e-04
 	 2.36125719469965966723634664958809e-01 1.99778523271920693815673075732775e-03 2.84770534453062046723048617025142e-04
 	 1.82951434776206678378684955532663e-01 2.13685366770810514225331644411199e-03 2.77265250767521828634265546043025e-04
 	 1.35205630986380942459845755365677e-01 2.26172482015674081168299380806275e-03 2.59521004586329984142878402053611e-04
 	 9.37052342256400327968890451302286e-02 2.37026215661884087637645279755816e-03 2.31745844521766129102749443013920e-04
 	 5.91602846138907789708127893391065e-02 2.46060868609154770325631034211256e-03 1.94700626832084789426952076141220e-04
 	 3.21617276826355880103847084683366e-02 2.53121888952001494743626608396880e-03 1.49667138625986641340542826483784e-04
 	 1.31709850003689510344884183723480e-02 2.58088599607930735402305799652822e-03 9.83862031428710986143831851435948e-05
 	 2.50868963898276398083453386789188e-03 2.60877144367566149441017842036672e-03 4.30291521942931560356683517998277e-05
 	 ];
 
 	 case  45 

 	 % ALG. DEG.:   45
 	 % PTS CARD.:  529
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw=[
 	 9.93641142341365912749040489870822e-01 6.34222713152880410159006885351118e-03 4.54441028047938367323652520540778e-07
 	 9.78789517517072771290997934556799e-01 2.11550100187229868364813256675916e-02 2.70275228530836595313520051564460e-06
 	 9.55747055076380247484735264151823e-01 4.41372087584861322318019460908545e-02 8.01749222555837254907025457573155e-06
 	 9.24909854207592641017754431231879e-01 7.48937600935948299962774399318732e-02 1.74073209861343138808807001760570e-05
 	 8.86805875060793558084526466700481e-01 1.12898084665305389884260023336537e-01 3.15241353670005661712603950430633e-05
 	 8.42087181576014809358809998229844e-01 1.57499823897601115563205098624167e-01 5.05965212422297794616667110378927e-05
 	 7.91518958392199101226083257643040e-01 2.07935794363794890227126188619877e-01 7.43938016765777735848572116417188e-05
 	 7.35966457544997010309373308700742e-01 2.63343006950007119115753084770404e-01 1.02223464602952071622089802449551e-04
 	 6.76380205535952017115164380811621e-01 3.22773421097546642233311331438017e-01 1.32962456868259890335054462795483e-04
 	 6.13779743822228218697034662909573e-01 3.85210161789159011291872047877405e-01 1.65120483818082187032691421357811e-04
 	 5.49236185933714482487744135141838e-01 4.49584916812982349210159327412839e-01 1.96931227068385323372007311704124e-04
 	 4.83853891201996733073542600322980e-01 5.14796215104283527708162182534579e-01 2.26465441118763174607741994748267e-04
 	 4.18751569204530937895469833165407e-01 5.79728272883124229331031074252678e-01 2.51758345997146011294165468541451e-04
 	 3.55043138426673232643793198803905e-01 6.43270084931366614711123474990018e-01 2.70942704315384099832825226528144e-04
 	 2.93818666700587094453567260643467e-01 7.04334434306677303894161923381034e-01 2.82378528061695457506558026850030e-04
 	 2.36125719469965966723634664958809e-01 7.61876495297314715315906141768210e-01 2.84770534453048494195892548219717e-04
 	 1.82951434776206678378684955532663e-01 8.14911711556085105456759265507571e-01 2.77265250767508601367761222888930e-04
 	 1.35205630986380942459845755365677e-01 8.62532644193462205706168788310606e-01 2.59521004586317624238112067303064e-04
 	 9.37052342256400327968890451302286e-02 9.03924503617741126326734502072213e-01 2.31745844521755070240590090868693e-04
 	 5.91602846138907789708127893391065e-02 9.38379106700017562303628437803127e-01 1.94700626832075519498377325078309e-04
 	 3.21617276826355880103847084683366e-02 9.65307053427844397042179025447695e-01 1.49667138625979512711258734292130e-04
 	 1.31709850003689510344884183723480e-02 9.84248129003551630589186061115470e-01 9.83862031428663958874600292681123e-05
 	 2.50868963898276398083453386789188e-03 9.94882538917341574524755287711741e-01 4.30291521942911028278042073758058e-05
 	 9.93641142341365912749040489870822e-01 6.27155840004316005031892444776531e-03 1.04998275983301469622109309415281e-06
 	 9.78789517517072771290997934556799e-01 2.09192887663009093046628805723230e-02 6.24468991249114394899823524132110e-06
 	 9.55747055076380247484735264151823e-01 4.36454066691580253034565828329505e-02 1.85243587052256492183049257915783e-05
 	 9.24909854207592641017754431231879e-01 7.40592508727418857850111066909449e-02 4.02194912040213214390535489961565e-05
 	 8.86805875060793447062224004184827e-01 1.11640109467477224858278361807606e-01 7.28362903239034730927189964511115e-05
 	 8.42087181576014809358809998229844e-01 1.55744870545532682060141382862639e-01 1.16902902099460181354478871540437e-04
 	 7.91518958392199212248385720158694e-01 2.05618854507589016167301565474190e-01 1.71886349114154252798458699658113e-04
 	 7.35966457544997010309373308700742e-01 2.60408688159332379896682141406927e-01 2.36186587167428276891334437692649e-04
 	 6.76380205535952128137466843327275e-01 3.19176894553605761117864858533721e-01 3.07208809944833211025283503659011e-04
 	 6.13779743822228218697034662909573e-01 3.80917929277697742129760172247188e-01 3.81509702257745155970503070363975e-04
 	 5.49236185933714482487744135141838e-01 4.44575383867006956872813816517009e-01 4.55008198055464679280396333993508e-04
 	 4.83853891201996733073542600322980e-01 5.09060060479013753997890034952434e-01 5.23246789344901396846820862407412e-04
 	 4.18751569204530937895469833165407e-01 5.73268608036473059641480176651385e-01 5.81685865989180293095239804301855e-04
 	 3.55043138426673232643793198803905e-01 6.36102400778464915909182764153229e-01 6.26011189297101750331209224498252e-04
 	 2.93818666700587094453567260643467e-01 6.96486336157263630219915739871794e-01 6.52433578643622823570180635499582e-04
 	 2.36125719469965966723634664958809e-01 7.53387230508336558365556356875459e-01 6.57960292380539452788967835772382e-04
 	 1.82951434776206678378684955532663e-01 8.05831497975878274786509791738354e-01 6.40619387860269008140579050092356e-04
 	 1.35205630986380942459845755365677e-01 8.52921810874817332148722925921902e-01 5.99621433391866608293707674448569e-04
 	 9.37052342256400327968890451302286e-02 8.93852458466299459871606813976541e-01 5.35447123812766013865871439492139e-04
 	 5.91602846138907789708127893391065e-02 9.27923148603931990940907326148590e-01 4.49854412090616262269449077138006e-04
 	 3.21617276826355880103847084683366e-02 9.54551048708182525714960320328828e-01 3.45804858214164242448396269224986e-04
 	 1.31709850003689510344884183723480e-02 9.73281071958555288325953824823955e-01 2.27320621883949052898649112464113e-04
 	 2.50868963898276398083453386789188e-03 9.83796987179058390893260366283357e-01 9.94185497913947861239533643207267e-05
 	 9.93641142341365912749040489870822e-01 6.14574399969093371903783307175217e-03 1.62768547847024573944235172062722e-06
 	 9.78789517517072771290997934556799e-01 2.04996246885640123758243191787187e-02 9.68053141151381486362650918842121e-06
 	 9.55747055076380247484735264151823e-01 4.27698315221305552791264403822424e-02 2.87164997521148849786518791882273e-05
 	 9.24909854207592641017754431231879e-01 7.25735403611368345977439275884535e-02 6.23483396952713084249175778950303e-05
 	 8.86805875060793447062224004184827e-01 1.09400485353028917301365652292588e-01 1.12910970161752950377022364225610e-04
 	 8.42087181576014698336507535714190e-01 1.52620456126385056760952352306049e-01 1.81223124243089228624370434772572e-04
 	 7.91518958392199212248385720158694e-01 2.01493912789625279069483099192439e-01 2.66458579229310852948958698860338e-04
 	 7.35966457544997121331675771216396e-01 2.55184601758885076794314272774500e-01 3.66136943241819807527692720583445e-04
 	 6.76380205535952128137466843327275e-01 3.12773852911791272468633451353526e-01 4.76235742084808082522084937693307e-04
 	 6.13779743822228218697034662909573e-01 3.73276294169084921215073791245231e-01 5.91417141324488901399369922273763e-04
 	 5.49236185933714482487744135141838e-01 4.35656709788774132441346864652587e-01 7.05354663801886772045435236577759e-04
 	 4.83853891201996677562391369065153e-01 4.98847752442147795992610781468102e-01 8.11138271268686209675147225084402e-04
 	 4.18751569204530937895469833165407e-01 5.61768205495317141107136649225140e-01 9.01730650560923384026490445819491e-04
 	 3.55043138426673232643793198803905e-01 6.23341482835644944415776080859359e-01 9.70443859802831774834241951310787e-04
 	 2.93818666700587094453567260643467e-01 6.82514049662005684027121787949000e-01 1.01140390323502965021218447105866e-03
 	 2.36125719469965966723634664958809e-01 7.38273449117290536669599987362744e-01 1.01997142647195578220309375439001e-03
 	 1.82951434776206678378684955532663e-01 7.89665626555136501707465868094005e-01 9.93089519881725510744296947507337e-04
 	 1.35205630986380942459845755365677e-01 8.35811255676637054889965838810895e-01 9.29534404799821139739335329466030e-04
 	 9.37052342256400327968890451302286e-02 8.75920789191797166672870389447780e-01 8.30051255372331298586219272550579e-04
 	 5.91602846138907789708127893391065e-02 9.09307983589483614927928556426195e-01 6.97365253980089592859836766791659e-04
 	 3.21617276826355880103847084683366e-02 9.35401698556554861418987911747536e-01 5.36067417134708707783519177070275e-04
 	 1.31709850003689510344884183723480e-02 9.53755976817641903942046610609395e-01 3.52392905247486004118029345733021e-04
 	 2.50868963898276398083453386789188e-03 9.64060931144021249217246349871857e-01 1.54118844591086376523414447348159e-04
 	 9.93641142341365912749040489870822e-01 5.96700055337379044878565181875274e-03 2.17642062585612139276889168137963e-06
 	 9.78789517517072771290997934556799e-01 1.99034115099437809714988389941936e-02 1.29440905580038820884940242716965e-05
 	 9.55747055076380247484735264151823e-01 4.15259093729076628198626508492453e-02 3.83975793785626756606139953209578e-05
 	 9.24909854207592641017754431231879e-01 7.04628040993858922869108596387377e-02 8.33675880847719908165946445244288e-05
 	 8.86805875060793447062224004184827e-01 1.06218670461007386185414702595153e-01 1.50976197549185437492974548590041e-04
 	 8.42087181576014698336507535714190e-01 1.48181627189173159564461457193829e-01 2.42318157102091447227185105894876e-04
 	 7.91518958392199101226083257643040e-01 1.95633643246059085729626758620725e-01 3.56288702849412799739808876964275e-04
 	 7.35966457544997010309373308700742e-01 2.47762786732462797489873196354893e-01 4.89571238239670455949514860094496e-04
 	 6.76380205535952017115164380811621e-01 3.03677106221698689392241021778318e-01 6.36787208310908114765325205297586e-04
 	 6.13779743822228107674732200393919e-01 3.62419888296723613496652660614927e-01 7.90799255684956296091892014032965e-04
 	 5.49236185933714371465441672626184e-01 4.22986025535940113329047562729102e-01 9.43148083059032623330641964543020e-04
 	 4.83853891201996733073542600322980e-01 4.84339213449382244291996357787866e-01 1.08459409840628976696985663608075e-03
 	 4.18751569204530937895469833165407e-01 5.45429681618195050241126864420949e-01 1.20572752709689301302276032146210e-03
 	 3.55043138426673232643793198803905e-01 6.05212155470221779829387287463760e-01 1.29760574794543677434877082532694e-03
 	 2.93818666700587094453567260643467e-01 6.62663741318118892920097096066456e-01 1.35237448830772166892544294825029e-03
 	 2.36125719469965966723634664958809e-01 7.16801428703438991973939664603677e-01 1.36383034666118685591940096202279e-03
 	 1.82951434776206678378684955532663e-01 7.66698910802617317195029045251431e-01 1.32788584955828158247481685094726e-03
 	 1.35205630986380942459845755365677e-01 8.11502435732653903954769702977501e-01 1.24290465068875762011391117312087e-03
 	 9.37052342256400327968890451302286e-02 8.50445419477593667068049398949370e-01 1.10988314180203721977246988927845e-03
 	 5.91602846138907789708127893391065e-02 8.82861577302685662793635401612846e-01 9.32465235202628041875916320435635e-04
 	 3.21617276826355880103847084683366e-02 9.08196379998001623867764919850742e-01 7.16789698583481546360907099568749e-04
 	 1.31709850003689510344884183723480e-02 9.26016840555127229706045000057202e-01 4.71193727246864088337857667809772e-04
 	 2.50868963898276398083453386789188e-03 9.36022084537155962813415044365684e-01 2.06076319189380896372554285989054e-04
 	 9.93641142341365912749040489870822e-01 5.73851421780689849999612661690662e-03 2.68633341315916086600211823420814e-06
 	 9.78789517517072771290997934556799e-01 1.91412769130874654832652481672994e-02 1.59767567701881113648859633613597e-05
 	 9.55747055076380247484735264151823e-01 3.99358135150593082651759857526486e-02 4.73937341172225357933955880440635e-05
 	 9.24909854207592641017754431231879e-01 6.77646666082918902596077259659069e-02 1.02899749609989957840200380800866e-04
 	 8.86805875060793558084526466700481e-01 1.02151381617083841790716292052821e-01 1.86348355299453295741418656916721e-04
 	 8.42087181576014698336507535714190e-01 1.42507507220196422137448166722606e-01 2.99090788933522905464201802061552e-04
 	 7.91518958392199212248385720158694e-01 1.88142506977667212098026539024431e-01 4.39763451892035913976669592173607e-04
 	 7.35966457544997121331675771216396e-01 2.38275539207685238540790351180476e-01 6.04272703438288728665372939730105e-04
 	 6.76380205535952128137466843327275e-01 2.92048806781216474526274851086782e-01 7.85979848948105408457109888331615e-04
 	 6.13779743822228107674732200393919e-01 3.48542230422758725350007580345846e-01 9.76075322210408495744726753429177e-04
 	 5.49236185933714482487744135141838e-01 4.06789189938855100248105145510635e-01 1.16411790027116848061927711910357e-03
 	 4.83853891201996733073542600322980e-01 4.65793062655106004932292762532597e-01 1.33870325048861303976477366006748e-03
 	 4.18751569204530937895469833165407e-01 5.24544275600946519055867156566819e-01 1.48821698559857031052278131255662e-03
 	 3.55043138426673232643793198803905e-01 5.82037579499092627699496915738564e-01 1.60162132098983791238244744903341e-03
 	 2.93818666700587094453567260643467e-01 6.37289248955919318539997675543418e-01 1.66922180937152208994589397406116e-03
 	 2.36125719469965966723634664958809e-01 6.89353914611797291556172240234446e-01 1.68336165656178060948122698903262e-03
 	 1.82951434776206678378684955532663e-01 7.37340739465869421387367310671834e-01 1.63899573646361261178294732587801e-03
 	 1.35205630986380942459845755365677e-01 7.80428663208982076326947208144702e-01 1.53410432379207269104615107835343e-03
 	 9.37052342256400327968890451302286e-02 8.17880455597002731238376327382866e-01 1.36991725455278857970231598528699e-03
 	 5.91602846138907789708127893391065e-02 8.49055345041379472270648420817452e-01 1.15093217192278603026867056513538e-03
 	 3.21617276826355880103847084683366e-02 8.73420036174213709756486423430033e-01 8.84726093218151255631598317563657e-04
 	 1.31709850003689510344884183723480e-02 8.90558121776889199949778230802622e-01 5.81589532159641200634303537242431e-04
 	 2.50868963898276398083453386789188e-03 9.00180248393089299518976531544467e-01 2.54357864156670081343808442753129e-04
 	 9.93641142341365912749040489870822e-01 5.46436148577505130530251875597969e-03 3.14831334839637131859345353657176e-06
 	 9.78789517517072771290997934556799e-01 1.82268183683970338981872316708177e-02 1.87243461132816396317538748528264e-05
 	 9.55747055076380247484735264151823e-01 3.80279133225157189857057460358192e-02 5.55442317847385400530167698374129e-05
 	 9.24909854207592641017754431231879e-01 6.45272661626778570864715334209905e-02 1.20595847729412715713601111922060e-04
 	 8.868058750607935580845264667004