
function [xyw_bar,pointset_stats]=set_taylor_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  M.A. Taylor,
%  "Asymmetric cubature formulas for polynomial integration in the
%  triangle and square".
%  JCAM 218 (2008), pp. 184-191.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  10 |  24 |   0 |   0 | 7.22e-16 |PI|
% |  11 |  27 |   0 |   0 | 3.64e-15 |PI|
% |  12 |  32 |   0 |   0 | 1.61e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   24
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.2e-16
        
        xyw_bar=[
            5.05505073735290855196922166214790e-01 2.07761165754848264874965479975799e-01 2.86733760509860879928112353809411e-01 8.67240386276647151619911824127485e-02
            2.75423850244129797548708893373259e-01 4.81232890624642473120786689833039e-01 2.43343259131227784841655648051528e-01 9.52665572713499164692052545433398e-02
            2.64815316514967702410388028511079e-01 2.75863340893159669775513975764625e-01 4.59321342591872627814097995724296e-01 8.44144425597100761526903056619631e-02
            7.53294027762542395265654704417102e-01 1.09549598555854665882236531615490e-01 1.37156373681602938852108763967408e-01 5.27303814088390249148474708817957e-02
            5.24336825589244326373261628759792e-01 3.64197444303392625641890845145099e-01 1.11465730107363047984847526095109e-01 7.40796473367798385956106699268275e-02
            2.95304455358511019902323369024089e-01 6.42033653186626640518852582317777e-01 6.26618914548623395788240486581344e-02 5.49156043938543586557798903413641e-02
            1.06146429902899963604312461029622e-01 7.67776801700239541759174244361930e-01 1.26076768396860439125362063350622e-01 5.25366591024116619257355864647252e-02
            6.34918323792006522587882955122041e-01 3.60362667879077225308037668582983e-02 3.29045409420085754881313278019661e-01 4.29623293920793347666631234460510e-02
            3.87296579139603525110402415521094e-01 8.41985221155437391082898557215231e-02 5.28504898744852846803610191273037e-01 6.26879253009136189200845024060982e-02
            1.69299274889664619347939833460259e-01 1.09994390556304499906303817624575e-01 7.20706334554030769723453886399511e-01 5.79741405986992294763204824903369e-02
            8.04918946561055670407824891299242e-02 5.79663251054863493116897643631091e-01 3.39844854289030995353471098496811e-01 6.61861344752598806939758446787891e-02
            9.53792084877216894689411219587782e-02 3.39472903118005542300039678593748e-01 5.65147888394272879253321661963128e-01 6.17422458661954012826278415104753e-02
            9.28994869857879046470827688608551e-01 4.77683817720224168645870577165624e-02 2.32367483700985366645852536748862e-02 1.46083292231216892859135825233352e-02
            7.47265917288688186204126395750791e-01 2.23763587742758507381779509159969e-01 2.89704949685533064140940950892400e-02 3.23026020234572983080845176573348e-02
            5.03658250759439707344711223413469e-01 4.87984378053974987565766241459642e-01 8.35737118658530508952253512688912e-03 1.95594122175219049808436722059923e-02
            1.61346504998909567873965897888411e-01 8.38653495001090432126034102111589e-01 0.00000000000000000000000000000000e+00 1.10669467822470894008413111464506e-02
            2.95535928468228514809368334681494e-02 9.30498469002630890223315418552374e-01 3.99479381505462027845965167216491e-02 1.52030940260127062080286464151868e-02
            8.68543869430765447248177224537358e-01 3.81025708546434138668246305314824e-03 1.27645873483770211365140312409494e-01 1.06666912759125903642498656154203e-02
            3.93667744707220101929578959243372e-01 0.00000000000000000000000000000000e+00 6.06332255292779898070421040756628e-01 1.19003048142356029903687897331110e-02
            1.76907306255590313082137754463474e-01 1.09391420571199327049782823451096e-02 8.12153551687289754212883963191416e-01 1.48466236466804936411367776827319e-02
            3.53196562525860957570955633855192e-02 3.90997455504232815926002331252676e-02 9.25580598196990567139152972231386e-01 1.76558445929621936343334454022624e-02
            0.00000000000000000000000000000000e+00 7.77575184294291066322557526291348e-01 2.22424815705708933677442473708652e-01 1.33990807858568091587292414601507e-02
            0.00000000000000000000000000000000e+00 4.63743838674305408620313073697616e-01 5.36256161325694646890838157560211e-01 1.51562619175656786846273504920646e-02
            3.05734040930993322682240886933869e-02 1.93059032242519357236432142599369e-01 7.76367563664381199473041306191590e-01 3.14147023606688446939472214580746e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   27
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.6e-15
        
        xyw_bar=[
            4.64945647736939915439791093376698e-01 2.91338594369423609098390670624212e-01 2.43715757893636475461818235999090e-01 6.82413799574910218126433392171748e-02
            3.20819579094829943066713440202875e-01 5.36342281120847141906438082514796e-01 1.42838139784322915026848477282329e-01 6.21931501112548551502001714652579e-02
            5.13531434334472347558175897574984e-01 1.24544059105441029533523078498547e-01 3.61924506560086622908301023926469e-01 5.66458851226994825056593185763631e-02
            2.87903102248196485213327378005488e-01 2.27899558843475014136004119791323e-01 4.84197338908328500650668502203189e-01 6.61424458849612512123528063057165e-02
            2.66771680715777448344994127182872e-01 4.11324991789046578993804814672330e-01 3.21903327495176028172352289402625e-01 5.86117684074096700896916445344687e-02
            1.16989764133234419585249952433514e-01 3.19097378146818710931142959452700e-01 5.63912857719946813972455856855959e-01 5.49910127174223842261291395061562e-02
            8.16262337159688100562959789385786e-01 2.77195229186185665426478408335242e-02 1.56018139921693332894392369780689e-01 2.36420595657646885612290788003520e-02
            5.69384861953279974855490763729904e-01 3.49929143342886495027244109223830e-01 8.06859947038335301172651270462666e-02 5.49719980088437115695043644336693e-02
            3.72727698616290958888441764429444e-01 5.98954396299342106679830521898111e-01 2.83179050843669344317277136724442e-02 3.25968731449079868189855346827244e-02
            2.68071506267725800931600588228321e-02 8.15629696932682168863948390935548e-01 1.57563152440545195531740318983793e-01 2.31123803536210682685325679130983e-02
            7.00992679496452275600404391298071e-01 1.41181197309527994843136866620625e-01 1.57826123194019729556458742081304e-01 5.20605353381209737251289482173888e-02
            3.27198781575528951925946330447914e-01 8.17214048553817629105822106794221e-02 5.91079813569089340674622690130491e-01 4.25977048981152628392976566829020e-02
            1.36670835343905061609603990291362e-01 1.30354530319426897833068323961925e-01 7.32974634336668096068478917004541e-01 4.55382591201502207045592740541906e-02
            1.38280002042923177985045413151965e-01 7.10278681077615825500970458961092e-01 1.51441316879461052025135359144770e-01 4.91909949083745370868037127820571e-02
            2.25926510513065892382655874826014e-02 3.89139811133193569414601142852916e-01 5.88267537815499785835982038406655e-01 2.67227871747326151119494852537173e-02
            9.36148935146756233649512068950571e-01 3.28998222921862981671381476189708e-02 3.09512425610574681833497834304580e-02 1.31059348520882364141915132904614e-02
            8.04549747476155374670270248316228e-01 1.64292867157134647726479670382105e-01 3.11573853667099776032500813016668e-02 2.75959001501799097710865282806481e-02
            6.19484315331351953481942018697737e-01 3.78021638913369206758119389633066e-01 2.49404575527883975993859166919719e-03 1.12750712157103187560647228337984e-02
            1.66556144920605719850215109545388e-01 8.03648340539038774643643137096660e-01 2.97955145403555610172929846157786e-02 2.67566361632531578285121298677041e-02
            3.32685606226784114092254185379716e-02 9.35514342858970948668684286531061e-01 3.12170965183506954332415261887945e-02 1.33743092864627294291679504567583e-02
            6.19248732321101225117843114276184e-01 2.62971997137641522179762887390098e-02 3.54454067965134622664180596984806e-01 2.94345581064335247434282649692250e-02
            3.96597316695864954283479164587334e-01 1.43545320109308982559070955176139e-02 5.89048151293204202971764971152879e-01 1.83588843901363422961292570789738e-02
            1.68929709822902285321077897606301e-01 2.21205351961617502354329189984128e-02 8.08949754980935908932337952137459e-01 2.13778080979136822503683390550577e-02
            3.29164038789997448475332930684090e-02 3.42227718413591897039793821022613e-02 9.32860824279641009937336093571503e-01 1.45481086805620794810689488940625e-02
            2.56601868330524340855447462672601e-02 6.17588731712771510373727323894855e-01 3.56751081454176111051879161095712e-01 2.87217773675270890421096225963993e-02
            1.24171485868014852549379156698706e-01 5.31419601540799590999597512563923e-01 3.44408912591185556451023330737371e-01 5.41214764752547955461992046366504e-02
            2.52527046383044795341277222178178e-02 1.74005716730322557150856255248073e-01 8.00741578631372963315016022534110e-01 2.40703005006082312866588779343147e-02
            ];
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   32
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.6e-15
        
        xyw_bar=[
            3.79860210934019559836372081917943e-01 2.10785259391403911877205246128142e-01 4.09354529674576528286422671953915e-01 5.94378339511354158997136210018652e-02
            3.01417093209093045480528871848946e-01 4.09786577770025306488577143682051e-01 2.88796329020881648030893984469003e-01 7.52220626033244244013076240662485e-02
            5.58025289531202561832401443098206e-01 2.13777432530059596782479047760717e-01 2.28197277938737841385119509141077e-01 6.31645464226566893950476355712453e-02
            1.25122995058103869681076503184158e-01 6.19381257362555781575963465002133e-01 2.55495747579340348742960031813709e-01 5.09649248767876233978668665258738e-02
            2.11179399098049336291893496309058e-01 2.44982965093490157038047527748859e-01 5.43837635808460562181210207199911e-01 4.74995753253071584243372171840747e-02
            8.54314749475804324774230735783931e-01 7.18714961015891051765436259302078e-02 7.38137544226065700492256382858614e-02 2.24907461991582235949493906446151e-02
            7.17881858980523257507400103349937e-01 2.03768481077729768369266594163491e-01 7.83496599417469741233333024865715e-02 3.95736057929719289849579411111336e-02
            4.66317874623230710362520312628476e-01 4.08963804491244753425149838221841e-01 1.24718320885524536212329849149683e-01 5.99897073271061717636420951293985e-02
            2.50155003353392135778676674817689e-01 6.27682615680314026640473912266316e-01 1.22162380966293837580849412915995e-01 5.33520830488209280018097047104675e-02
            7.99553848413813161855046018899884e-02 8.26003314017559997495254719979130e-01 9.40413011410586863192406781308819e-02 3.05291724120723972912827548498171e-02
            7.10081259568365208423301737639122e-01 6.44132203822605498011455438245321e-02 2.25505520049374241775552718536346e-01 4.12818873954626242017695858521620e-02
            4.97320633777965981359159286512295e-01 7.05667243440368241458315878844587e-02 4.32112641877997194495009125603247e-01 4.81488050369073342094061729312671e-02
            2.60770682565628963978099363885121e-01 9.54285858105846096499647046584869e-02 6.43800731623786370860784700198565e-01 4.59378421657917201947896046476671e-02
            8.96027058005874343926677738636499e-02 1.16386499067277326968650186245213e-01 7.94010795132135127616379577375483e-01 3.05752776040389556699850004406471e-02
            2.30881487661157569490910645981785e-02 7.49189739790679487541069647704717e-01 2.27722111443204755509839287697105e-01 2.16850854170115049657230343882475e-02
            1.29532969004336195872895132197300e-01 4.22605657433460013550075018429197e-01 4.47861373562203790577029849373503e-01 5.41468726131675709423163311839744e-02
            9.34480876044409547453994946408784e-02 2.43458133948799726464784498602967e-01 6.63093778446759207767513544240501e-01 2.79437343198798565646612246382574e-02
            9.55269193570060348719152898411267e-01 2.35517332495787101720452483277768e-02 2.11790731803609411088018532609567e-02 6.67590002736735601412965124268339e-03
            8.45935398373143909722671196504962e-01 1.54064601626856090277328803495038e-01 0.00000000000000000000000000000000e+00 7.71449237362483494079290480271993e-03
            6.16009296172674969405136380373733e-01 3.61181591189672079877936994307674e-01 2.28091126376529507169266253185924e-02 2.50991734276851119478379814609070e-02
            3.93165103196048082434543857743847e-01 5.81689214740147453319707437913166e-01 2.51456820638044087345974730851594e-02 2.81455586052133319152623869285890e-02
            1.89206330617159357299073008107371e-01 7.88601719223131603087040275568143e-01 2.21919501597089841027354850666597e-02 2.06200041196821157174490224406327e-02
            4.30105601064054710036543838214129e-02 9.45475073220970907428295504359994e-01 1.15143666726236215680501118185930e-02 7.11975143608072503359496252528515e-03
            8.58158884215330819422717922861921e-01 0.00000000000000000000000000000000e+00 1.41841115784669180577282077138079e-01 6.84553465434369068365327848368906e-03
            6.27315319232411794381221170624485e-01 0.00000000000000000000000000000000e+00 3.72684680767588205618778829375515e-01 9.65470874243634473443886889754140e-03
            3.63846604460775102651837187295314e-01 1.45665147883469736633799129776889e-02 6.21586880750877979195934130984824e-01 1.85454804216065305411120789358392e-02
            1.55570668968979530788487863901537e-01 2.11522233831219486077657165878918e-02 8.23277107647898520603746419510571e-01 1.84836858112307732271428761805510e-02
            2.97541174968417587720637129677925e-02 2.71109713562557863575364081043517e-02 9.43134911146902510381551110185683e-01 1.05093267356025157899246380566183e-02
            0.00000000000000000000000000000000e+00 9.27348974483949817226857703644782e-01 7.26510255160501827731422963552177e-02 4.88804981466003842655032585184927e-03
            2.57162836236938807665808326419210e-02 5.44446676271925222856395976123167e-01 4.29837040104380840865871959977085e-01 2.81696544597299612655572076391763e-02
            2.45062866369900045349083939072443e-02 3.32129083947645065144627096742624e-01 6.43364629415364874809313278092304e-01 2.49040732015077016792137243328398e-02
            9.22969090596492680589335577678867e-03 1.46044961672175677147578198855626e-01 8.44725347421859451557679676625412e-01 1.06808436576282927282788293155136e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    10   24 7.22e-16    0    0
    11   27 3.64e-15    0    0
    12   32 1.61e-15    0    0
    ];





