
function xyw=set_taylor(deg)

% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%--------------------------------------------------------------------
% REMARK:
% We have modified the original weights so that their sum makes 1/2.
%--------------------------------------------------------------------
% SOURCE:
% M.A. Taylor
% "Asymmetric cubature formulas for polynomial integration in the
% triangle and square".
% JCAM 218 (2008), pp. 184-191.
%--------------------------------------------------------------------


%----------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%----------------------------------------
% |  10 |  24 |   0 |   0 | 7.22e-16 |PI|
% |  11 |  27 |   0 |   0 | 3.64e-15 |PI|
% |  12 |  32 |   0 |   0 | 1.61e-15 |PI|
%---------------------------------------

%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   24
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.2e-16
        
        xyw=[
            5.05505073735290855197e-01 2.07761165754848264875e-01 4.33620193138323575810e-02
            2.75423850244129797549e-01 4.81232890624642473121e-01 4.76332786356749582346e-02
            2.64815316514967702410e-01 2.75863340893159669776e-01 4.22072212798550380763e-02
            7.53294027762542395266e-01 1.09549598555854665882e-01 2.63651907044195124574e-02
            5.24336825589244326373e-01 3.64197444303392625642e-01 3.70398236683899192978e-02
            2.95304455358511019902e-01 6.42033653186626640519e-01 2.74578021969271793279e-02
            1.06146429902899963604e-01 7.67776801700239541759e-01 2.62683295512058309629e-02
            6.34918323792006522588e-01 3.60362667879077225308e-02 2.14811646960396673833e-02
            3.87296579139603525110e-01 8.41985221155437391083e-02 3.13439626504568094600e-02
            1.69299274889664619348e-01 1.09994390556304499906e-01 2.89870702993496147382e-02
            8.04918946561055670408e-02 5.79663251054863493117e-01 3.30930672376299403470e-02
            9.53792084877216894689e-02 3.39472903118005542300e-01 3.08711229330977006413e-02
            9.28994869857879046471e-01 4.77683817720224168646e-02 7.30416461156084464296e-03
            7.47265917288688186204e-01 2.23763587742758507382e-01 1.61513010117286491540e-02
            5.03658250759439707345e-01 4.87984378053974987566e-01 9.77970610876095249042e-03
            1.61346504998909567874e-01 8.38653495001090432126e-01 5.53347339112354470042e-03
            2.95535928468228514809e-02 9.30498469002630890223e-01 7.60154701300635310401e-03
            8.68543869430765447248e-01 3.81025708546434138668e-03 5.33334563795629518212e-03
            3.93667744707220101930e-01 0.00000000000000000000e+00 5.95015240711780149518e-03
            1.76907306255590313082e-01 1.09391420571199327050e-02 7.42331182334024682057e-03
            3.53196562525860957571e-02 3.90997455504232815926e-02 8.82792229648109681717e-03
            0.00000000000000000000e+00 7.77575184294291066323e-01 6.69954039292840457936e-03
            0.00000000000000000000e+00 4.63743838674305408620e-01 7.57813095878283934231e-03
            3.05734040930993322682e-02 1.93059032242519357236e-01 1.57073511803344223470e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   27
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.6e-15
        
        xyw=[
            4.64945647736939915440e-01 2.91338594369423609098e-01 3.41206899787455109063e-02
            3.20819579094829943067e-01 5.36342281120847141906e-01 3.10965750556274275751e-02
            5.13531434334472347558e-01 1.24544059105441029534e-01 2.83229425613497412528e-02
            2.87903102248196485213e-01 2.27899558843475014136e-01 3.30712229424806256062e-02
            2.66771680715777448345e-01 4.11324991789046578994e-01 2.93058842037048350448e-02
            1.16989764133234419585e-01 3.19097378146818710931e-01 2.74955063587111921131e-02
            8.16262337159688100563e-01 2.77195229186185665426e-02 1.18210297828823442806e-02
            5.69384861953279974855e-01 3.49929143342886495027e-01 2.74859990044218557848e-02
            3.72727698616290958888e-01 5.98954396299342106680e-01 1.62984365724539934095e-02
            2.68071506267725800932e-02 8.15629696932682168864e-01 1.15561901768105341343e-02
            7.00992679496452275600e-01 1.41181197309527994843e-01 2.60302676690604868626e-02
            3.27198781575528951926e-01 8.17214048553817629106e-02 2.12988524490576314196e-02
            1.36670835343905061610e-01 1.30354530319426897833e-01 2.27691295600751103523e-02
            1.38280002042923177985e-01 7.10278681077615825501e-01 2.45954974541872685434e-02
            2.25926510513065892383e-02 3.89139811133193569415e-01 1.33613935873663075560e-02
            9.36148935146756233650e-01 3.28998222921862981671e-02 6.55296742604411820710e-03
            8.04549747476155374670e-01 1.64292867157134647726e-01 1.37979500750899548855e-02
            6.19484315331351953482e-01 3.78021638913369206758e-01 5.63753560785515937803e-03
            1.66556144920605719850e-01 8.03648340539038774644e-01 1.33783180816265789143e-02
            3.32685606226784114092e-02 9.35514342858970948669e-01 6.68715464323136471458e-03
            6.19248732321101225118e-01 2.62971997137641522180e-02 1.47172790532167623717e-02
            3.96597316695864954283e-01 1.43545320109308982559e-02 9.17944219506817114806e-03
            1.68929709822902285321e-01 2.21205351961617502354e-02 1.06889040489568411252e-02
            3.29164038789997448475e-02 3.42227718413591897040e-02 7.27405434028103974053e-03
            2.56601868330524340855e-02 6.17588731712771510374e-01 1.43608886837635445211e-02
            1.24171485868014852549e-01 5.31419601540799591000e-01 2.70607382376273977731e-02
            2.52527046383044795341e-02 1.74005716730322557151e-01 1.20351502503041156433e-02
            ];
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   32
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.6e-15
        
        xyw=[
            3.79860210934019559836e-01 2.10785259391403911877e-01 2.97189169755677079499e-02
            3.01417093209093045481e-01 4.09786577770025306489e-01 3.76110313016622122007e-02
            5.58025289531202561832e-01 2.13777432530059596782e-01 3.15822732113283446975e-02
            1.25122995058103869681e-01 6.19381257362555781576e-01 2.54824624383938116989e-02
            2.11179399098049336292e-01 2.44982965093490157038e-01 2.37497876626535792122e-02
            8.54314749475804324774e-01 7.18714961015891051765e-02 1.12453730995791117975e-02
            7.17881858980523257507e-01 2.03768481077729768369e-01 1.97868028964859644925e-02
            4.66317874623230710363e-01 4.08963804491244753425e-01 2.99948536635530858818e-02
            2.50155003353392135779e-01 6.27682615680314026640e-01 2.66760415244104640009e-02
            7.99553848413813161855e-02 8.26003314017559997495e-01 1.52645862060361986456e-02
            7.10081259568365208423e-01 6.44132203822605498011e-02 2.06409436977313121009e-02
            4.97320633777965981359e-01 7.05667243440368241458e-02 2.40744025184536671047e-02
            2.60770682565628963978e-01 9.54285858105846096500e-02 2.29689210828958600974e-02
            8.96027058005874343927e-02 1.16386499067277326969e-01 1.52876388020194778350e-02
            2.30881487661157569491e-02 7.49189739790679487541e-01 1.08425427085057524829e-02
            1.29532969004336195873e-01 4.22605657433460013550e-01 2.70734363065837854712e-02
            9.34480876044409547454e-02 2.43458133948799726465e-01 1.39718671599399282823e-02
            9.55269193570060348719e-01 2.35517332495787101720e-02 3.33795001368367800706e-03
            8.45935398373143909723e-01 1.54064601626856090277e-01 3.85724618681241747040e-03
            6.16009296172674969405e-01 3.61181591189672079878e-01 1.25495867138425559739e-02
            3.93165103196048082435e-01 5.81689214740147453320e-01 1.40727793026066659576e-02
            1.89206330617159357299e-01 7.88601719223131603087e-01 1.03100020598410578587e-02
            4.30105601064054710037e-02 9.45475073220970907428e-01 3.55987571804036251680e-03
            8.58158884215330819423e-01 0.00000000000000000000e+00 3.42276732717184534183e-03
            6.27315319232411794381e-01 0.00000000000000000000e+00 4.82735437121817236722e-03
            3.63846604460775102652e-01 1.45665147883469736634e-02 9.27274021080326527056e-03
            1.55570668968979530788e-01 2.11522233831219486078e-02 9.24184290561538661357e-03
            2.97541174968417587721e-02 2.71109713562557863575e-02 5.25466336780125789496e-03
            0.00000000000000000000e+00 9.27348974483949817227e-01 2.44402490733001921328e-03
            2.57162836236938807666e-02 5.44446676271925222856e-01 1.40848272298649806328e-02
            2.45062866369900045349e-02 3.32129083947645065145e-01 1.24520366007538508396e-02
            9.22969090596492680589e-03 1.46044961672175677148e-01 5.34042182881414636414e-03
            ];
        
        
    otherwise
        xyw=[];
end




