
function [xyw,pointset_stats]=set_taylor_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  M.A. Taylor,
%  "Asymmetric cubature formulas for polynomial integration in the
%  triangle and square".
%  JCAM 218 (2008), pp. 184-191.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  10 |  24 |   0 |   0 | 7.22e-16 |PI|
% |  11 |  27 |   0 |   0 | 3.64e-15 |PI|
% |  12 |  32 |   0 |   0 | 1.61e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   24
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.2e-16
        
        xyw=[
            5.05505073735290855196922166214790e-01 2.07761165754848264874965479975799e-01 4.33620193138323575809955912063742e-02
            2.75423850244129797548708893373259e-01 4.81232890624642473120786689833039e-01 4.76332786356749582346026272716699e-02
            2.64815316514967702410388028511079e-01 2.75863340893159669775513975764625e-01 4.22072212798550380763451528309815e-02
            7.53294027762542395265654704417102e-01 1.09549598555854665882236531615490e-01 2.63651907044195124574237354408979e-02
            5.24336825589244326373261628759792e-01 3.64197444303392625641890845145099e-01 3.70398236683899192978053349634138e-02
            2.95304455358511019902323369024089e-01 6.42033653186626640518852582317777e-01 2.74578021969271793278899451706820e-02
            1.06146429902899963604312461029622e-01 7.67776801700239541759174244361930e-01 2.62683295512058309628677932323626e-02
            6.34918323792006522587882955122041e-01 3.60362667879077225308037668582983e-02 2.14811646960396673833315617230255e-02
            3.87296579139603525110402415521094e-01 8.41985221155437391082898557215231e-02 3.13439626504568094600422512030491e-02
            1.69299274889664619347939833460259e-01 1.09994390556304499906303817624575e-01 2.89870702993496147381602412451684e-02
            8.04918946561055670407824891299242e-02 5.79663251054863493116897643631091e-01 3.30930672376299403469879223393946e-02
            9.53792084877216894689411219587782e-02 3.39472903118005542300039678593748e-01 3.08711229330977006413139207552376e-02
            9.28994869857879046470827688608551e-01 4.77683817720224168645870577165624e-02 7.30416461156084464295679126166760e-03
            7.47265917288688186204126395750791e-01 2.23763587742758507381779509159969e-01 1.61513010117286491540422588286674e-02
            5.03658250759439707344711223413469e-01 4.87984378053974987565766241459642e-01 9.77970610876095249042183610299617e-03
            1.61346504998909567873965897888411e-01 8.38653495001090432126034102111589e-01 5.53347339112354470042065557322530e-03
            2.95535928468228514809368334681494e-02 9.30498469002630890223315418552374e-01 7.60154701300635310401432320759341e-03
            8.68543869430765447248177224537358e-01 3.81025708546434138668246305314824e-03 5.33334563795629518212493280771014e-03
            3.93667744707220101929578959243372e-01 0.00000000000000000000000000000000e+00 5.95015240711780149518439486655552e-03
            1.76907306255590313082137754463474e-01 1.09391420571199327049782823451096e-02 7.42331182334024682056838884136596e-03
            3.53196562525860957570955633855192e-02 3.90997455504232815926002331252676e-02 8.82792229648109681716672270113122e-03
            0.00000000000000000000000000000000e+00 7.77575184294291066322557526291348e-01 6.69954039292840457936462073007533e-03
            0.00000000000000000000000000000000e+00 4.63743838674305408620313073697616e-01 7.57813095878283934231367524603229e-03
            3.05734040930993322682240886933869e-02 1.93059032242519357236432142599369e-01 1.57073511803344223469736107290373e-02
            ];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   27
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.6e-15
        
        xyw=[
            4.64945647736939915439791093376698e-01 2.91338594369423609098390670624212e-01 3.41206899787455109063216696085874e-02
            3.20819579094829943066713440202875e-01 5.36342281120847141906438082514796e-01 3.10965750556274275751000857326289e-02
            5.13531434334472347558175897574984e-01 1.24544059105441029533523078498547e-01 2.83229425613497412528296592881816e-02
            2.87903102248196485213327378005488e-01 2.27899558843475014136004119791323e-01 3.30712229424806256061764031528583e-02
            2.66771680715777448344994127182872e-01 4.11324991789046578993804814672330e-01 2.93058842037048350448458222672343e-02
            1.16989764133234419585249952433514e-01 3.19097378146818710931142959452700e-01 2.74955063587111921130645697530781e-02
            8.16262337159688100562959789385786e-01 2.77195229186185665426478408335242e-02 1.18210297828823442806145394001760e-02
            5.69384861953279974855490763729904e-01 3.49929143342886495027244109223830e-01 2.74859990044218557847521822168346e-02
            3.72727698616290958888441764429444e-01 5.98954396299342106679830521898111e-01 1.62984365724539934094927673413622e-02
            2.68071506267725800931600588228321e-02 8.15629696932682168863948390935548e-01 1.15561901768105341342662839565492e-02
            7.00992679496452275600404391298071e-01 1.41181197309527994843136866620625e-01 2.60302676690604868625644741086944e-02
            3.27198781575528951925946330447914e-01 8.17214048553817629105822106794221e-02 2.12988524490576314196488283414510e-02
            1.36670835343905061609603990291362e-01 1.30354530319426897833068323961925e-01 2.27691295600751103522796370270953e-02
            1.38280002042923177985045413151965e-01 7.10278681077615825500970458961092e-01 2.45954974541872685434018563910286e-02
            2.25926510513065892382655874826014e-02 3.89139811133193569414601142852916e-01 1.33613935873663075559747426268586e-02
            9.36148935146756233649512068950571e-01 3.28998222921862981671381476189708e-02 6.55296742604411820709575664523072e-03
            8.04549747476155374670270248316228e-01 1.64292867157134647726479670382105e-01 1.37979500750899548855432641403240e-02
            6.19484315331351953481942018697737e-01 3.78021638913369206758119389633066e-01 5.63753560785515937803236141689922e-03
            1.66556144920605719850215109545388e-01 8.03648340539038774643643137096660e-01 1.33783180816265789142560649338520e-02
            3.32685606226784114092254185379716e-02 9.35514342858970948668684286531061e-01 6.68715464323136471458397522837913e-03
            6.19248732321101225117843114276184e-01 2.62971997137641522179762887390098e-02 1.47172790532167623717141324846125e-02
            3.96597316695864954283479164587334e-01 1.43545320109308982559070955176139e-02 9.17944219506817114806462853948688e-03
            1.68929709822902285321077897606301e-01 2.21205351961617502354329189984128e-02 1.06889040489568411251841695275289e-02
            3.29164038789997448475332930684090e-02 3.42227718413591897039793821022613e-02 7.27405434028103974053447444703124e-03
            2.56601868330524340855447462672601e-02 6.17588731712771510373727323894855e-01 1.43608886837635445210548112981996e-02
            1.24171485868014852549379156698706e-01 5.31419601540799590999597512563923e-01 2.70607382376273977730996023183252e-02
            2.52527046383044795341277222178178e-02 1.74005716730322557150856255248073e-01 1.20351502503041156433294389671573e-02
            ];
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   32
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.6e-15
        
        xyw=[
            3.79860210934019559836372081917943e-01 2.10785259391403911877205246128142e-01 2.97189169755677079498568105009326e-02
            3.01417093209093045480528871848946e-01 4.09786577770025306488577143682051e-01 3.76110313016622122006538120331243e-02
            5.58025289531202561832401443098206e-01 2.13777432530059596782479047760717e-01 3.15822732113283446975238177856227e-02
            1.25122995058103869681076503184158e-01 6.19381257362555781575963465002133e-01 2.54824624383938116989334332629369e-02
            2.11179399098049336291893496309058e-01 2.44982965093490157038047527748859e-01 2.37497876626535792121686085920373e-02
            8.54314749475804324774230735783931e-01 7.18714961015891051765436259302078e-02 1.12453730995791117974746953223075e-02
            7.17881858980523257507400103349937e-01 2.03768481077729768369266594163491e-01 1.97868028964859644924789705555668e-02
            4.66317874623230710362520312628476e-01 4.08963804491244753425149838221841e-01 2.99948536635530858818210475646993e-02
            2.50155003353392135778676674817689e-01 6.27682615680314026640473912266316e-01 2.66760415244104640009048523552337e-02
            7.99553848413813161855046018899884e-02 8.26003314017559997495254719979130e-01 1.52645862060361986456413774249086e-02
            7.10081259568365208423301737639122e-01 6.44132203822605498011455438245321e-02 2.06409436977313121008847929260810e-02
            4.97320633777965981359159286512295e-01 7.05667243440368241458315878844587e-02 2.40744025184536671047030864656335e-02
            2.60770682565628963978099363885121e-01 9.54285858105846096499647046584869e-02 2.29689210828958600973948023238336e-02
            8.96027058005874343926677738636499e-02 1.16386499067277326968650186245213e-01 1.52876388020194778349925002203236e-02
            2.30881487661157569490910645981785e-02 7.49189739790679487541069647704717e-01 1.08425427085057524828615171941237e-02
            1.29532969004336195872895132197300e-01 4.22605657433460013550075018429197e-01 2.70734363065837854711581655919872e-02
            9.34480876044409547453994946408784e-02 2.43458133948799726464784498602967e-01 1.39718671599399282823306123191287e-02
            9.55269193570060348719152898411267e-01 2.35517332495787101720452483277768e-02 3.33795001368367800706482562134170e-03
            8.45935398373143909722671196504962e-01 1.54064601626856090277328803495038e-01 3.85724618681241747039645240135997e-03
            6.16009296172674969405136380373733e-01 3.61181591189672079877936994307674e-01 1.25495867138425559739189907304535e-02
            3.93165103196048082434543857743847e-01 5.81689214740147453319707437913166e-01 1.40727793026066659576311934642945e-02
            1.89206330617159357299073008107371e-01 7.88601719223131603087040275568143e-01 1.03100020598410578587245112203163e-02
            4.30105601064054710036543838214129e-02 9.45475073220970907428295504359994e-01 3.55987571804036251679748126264258e-03
            8.58158884215330819422717922861921e-01 0.00000000000000000000000000000000e+00 3.42276732717184534182663924184453e-03
            6.27315319232411794381221170624485e-01 0.00000000000000000000000000000000e+00 4.82735437121817236721943444877070e-03
            3.63846604460775102651837187295314e-01 1.45665147883469736633799129776889e-02 9.27274021080326527055603946791962e-03
            1.55570668968979530788487863901537e-01 2.11522233831219486077657165878918e-02 9.24184290561538661357143809027548e-03
            2.97541174968417587720637129677925e-02 2.71109713562557863575364081043517e-02 5.25466336780125789496231902830914e-03
            0.00000000000000000000000000000000e+00 9.27348974483949817226857703644782e-01 2.44402490733001921327516292592463e-03
            2.57162836236938807665808326419210e-02 5.44446676271925222856395976123167e-01 1.40848272298649806327786038195882e-02
            2.45062866369900045349083939072443e-02 3.32129083947645065144627096742624e-01 1.24520366007538508396068621664199e-02
            9.22969090596492680589335577678867e-03 1.46044961672175677147578198855626e-01 5.34042182881414636413941465775679e-03
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    10   24 7.22e-16    0    0
    11   27 3.64e-15    0    0
    12   32 1.61e-15    0    0
    ];




