
function [xyw,pointset_stats]=set_taylor_wingate_bos_siam_C_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% M.A. Taylor, B.A. Wingate, L.P. Bos,
% "A cardinal algorithm for computing multivariate quadrature points",
% SIAM J. Numer. Anal.,
% Vol. 45, no.1, (2007),  pp.193-205.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  36 |   0 |   0 | 5.69e-16 |PI|
% |  16 |  55 |   0 |   0 | 7.82e-13 |PI|
% |  18 |  66 |   0 |   0 | 6.28e-16 |PI|
% |  20 |  78 |   0 |   0 | 6.59e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   36
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.7e-16
        
        xyw=[
            2.42935351590267065158279535808106e-02 9.49305929384640645452009266591631e-01 4.15602496892741694878292690873423e-03
            2.65193427721596430846062730779522e-02 2.42695130640411330102956810605974e-02 4.17029249443872686298195873177974e-03
            9.49212602355106627172176558815408e-01 2.65067966437244444122267594821096e-02 4.17076422666404645483995139443323e-03
            3.37757637490055826964829854830441e-03 4.76731641236311565190675310077495e-01 4.39202175206317331490613042888072e-03
            4.75767229810120817479202059985255e-01 5.19892182910199451839616813231260e-01 4.61186654611973542716718554856925e-03
            5.19078319347068384281840280891629e-01 5.59127062021519405377034672710579e-03 4.94856025469586017356826701529826e-03
            8.61683974532058805095857678679749e-01 1.33996048618149864173343388529247e-02 5.08850989636669241711341982181693e-03
            1.24920975992555069455924865451379e-01 8.61305432133411819073387505341088e-01 5.17132159850464123707070029922761e-03
            1.38565453861037562316438354059756e-02 1.24773371735846960728366639159503e-01 5.20678415216161045997456113809676e-03
            2.11887064221680555820004343559049e-02 8.43843835122266905379717627511127e-01 7.94549445696764861102323607155995e-03
            8.43229678721886810599528416787507e-01 1.35456364583034560844509996968554e-01 8.01180088101775822462258247469435e-03
            1.35423179786502895227684462042816e-01 2.13482820656213760635022680389739e-02 8.01519202864208260561618146766705e-03
            3.08885351067946345438031130470335e-01 2.21919663013588897015893053321633e-02 1.07691489795688211117408172867727e-02
            6.68505759516906161721294665767346e-01 3.08901287938941060406961014450644e-01 1.09618353834781030731182482895747e-02
            2.26545012557139990860832767793909e-02 6.69170994332103363788633032527287e-01 1.09802418183186784039762073916791e-02
            2.80851540877201766299720020469977e-01 6.92471815510625865464078287914163e-01 1.19987980922641249148519193568063e-02
            6.92244674905063805958604916668264e-01 2.68723345025942451924638731952655e-02 1.20951565183311949419620034973377e-02
            2.68617447119446836611977857955935e-02 2.81009397322192211454705557116540e-01 1.21216855843665465702896355537632e-02
            1.14177848547014307301061819543975e-01 7.97358141358575300827737919462379e-01 1.39241122006051373100055101872385e-02
            7.97480792206136435140706453239545e-01 8.79806508790785396501021864423819e-02 1.40256591089016040968528997723297e-02
            8.92807293894229969666298529773485e-02 1.14502056112754047045854122188757e-01 1.41297530923219869652962543682406e-02
            1.05248789245499130284855482386774e-01 6.68690411992204802871242463879753e-01 1.72322472667380058308772561304067e-02
            6.66302228074011737568582702806452e-01 2.27505163183173875207643277462921e-01 1.79303334022174465367527318448992e-02
            2.30780373754708834077575829724083e-01 1.05457256122134593323558249267080e-01 1.81863480244095591931152711140385e-02
            1.70505915754032344455737302268972e-01 5.17406439865800038546694850083441e-01 1.97201834184250850146025157982876e-02
            5.08659397304299987219167178409407e-01 3.17052385520937729523893722216599e-01 2.02528586378061328798771967285575e-02
            3.14182386228100019032183354283916e-01 1.81070636165945680895461578074901e-01 2.06431324763724430293443390382890e-02
            4.61746081786398032686946635294589e-01 4.67859453980425443742063862373470e-01 2.10511141832600105761041930918509e-02
            6.93087496081041115614240766262810e-02 4.62285604208458600350439837711747e-01 2.10896383326257957913085760992544e-02
            4.65195525926812680772570729459403e-01 7.24357805669118837155195933519281e-02 2.12992467121988250655650887210868e-02
            2.57862585789255804868957966391463e-01 6.13139503917723982517884451226564e-01 2.25711332013103851967805724143545e-02
            6.11262776677922614609883567027282e-01 1.30036083460934620559257268723741e-01 2.28570785871126912203177283799960e-02
            1.30518213593359244661940010701073e-01 2.58171382888366274244162923423573e-01 2.29069766352317967517127073051597e-02
            4.28143799182839956962709493382135e-01 2.36200596981703037080535523273284e-01 2.56393343723977616688269876021877e-02
            3.35699578373030105282737167726737e-01 4.31102630858835489391367445932701e-01 2.58289915353369370354386092003551e-02
            2.30542429883610316965203423933417e-01 3.45601394937618766611819864920108e-01 2.58963591798315739822555769933388e-02
            ];
        
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   55
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.8e-13
        
        xyw=[
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.55064996275000002885768868310379e-04
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 1.57879367799999994039297779302444e-04
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.77165038975000000819742806967838e-04
            9.39886358357699958077091650920920e-01 4.98487446340000004557646562375339e-03 1.37909290419999997802380509170916e-03
            5.43806683058000034369783293186629e-02 9.38640561861699973533745833265129e-01 1.56731019139999994300993524376509e-03
            9.39400491640000022408596436207517e-03 5.26424462697000009048231561337161e-02 1.96328522064999995075385008647118e-03
            1.64345086361999993818105991749690e-02 9.46903551735099990871447062090738e-01 2.36378709660000014061709272539247e-03
            9.46948726986200028932216810062528e-01 3.63373677167000003196406510141969e-02 2.44561278177499999073041259123329e-03
            4.26604005767999977516424792156613e-02 1.51224541798999998626351626285214e-02 2.49654108722499991704357746868936e-03
            1.22269495439000005360119516240047e-02 8.69377351066400017032265168381855e-01 3.43884547040000003795268135320384e-03
            8.67369652104699961903122584772063e-01 1.20491728577399995203656146713911e-01 3.52447945099999999929440974710815e-03
            8.45674402138899994341159072064329e-01 1.57763967870000014481757233397730e-02 3.74117160842499978448683073395387e-03
            1.39575963210299996974939062965859e-01 8.44812087037499992447919794358313e-01 3.90243759030000020651685055383950e-03
            1.31782174323099993129559948101814e-01 1.35009605583999992006738466443494e-02 3.94209233370000026314139418559535e-03
            1.57955126300000012196100840355939e-02 1.45527493853600004003467915936199e-01 4.39486365957500024065351951207958e-03
            7.36546288443600039030911830195691e-01 1.55697540907999993492483170598462e-02 5.10284600675000015596038949183821e-03
            1.39688430330000001866608272393933e-02 7.37983689445000035078692235401832e-01 5.23907196540000005130499616257111e-03
            2.54789518603899978188565000891685e-01 7.29761568977099983612788491882384e-01 5.26783532495000029333143132248551e-03
            7.31638652255499954968342990468955e-01 2.54307668331499980851617692678701e-01 5.44116900505000038873459899946283e-03
            1.57253728950999989433245929149052e-02 2.69623979579100003789449147006962e-01 5.55721021747499974163808644789242e-03
            2.66230284364699976151769078569487e-01 1.44783956308000005819280886498746e-02 5.60466734205000011170838547513995e-03
            8.67350406521400052461956420302158e-01 5.91679410399999980429974755224976e-02 5.75306542482499974622278671176900e-03
            7.41493666957000058248539176020131e-02 8.63478257506099966533952283498365e-01 5.92034756249999998684030444451309e-03
            1.59285948359999991741364766539846e-02 4.19123895523800027440586291049840e-01 6.43661608420000030950092195780599e-03
            1.56061028068000002405613102496318e-02 5.80922292114600002932434108515736e-01 6.44892004019999992570078006792755e-03
            5.91009481748399956302364444127306e-01 1.59251452650999991700331293031923e-02 6.45180819024999963051669737978955e-03
            4.03477149688900027513227541930974e-01 5.80670036810399969873230929806596e-01 6.50858080147500000361970862172711e-03
            5.69474562852600008078240989561891e-01 4.14949514630200022580197583010886e-01 6.64420354022499971835546972442899e-03
            6.78493700649999975649251382492366e-02 7.61218678590999953126328136931988e-02 6.64461904577500015595115101518786e-03
            4.26596859027200014935488070477732e-01 1.57509692312000001979122032480518e-02 6.68830823095000002315169140842954e-03
            6.70982507890000023920151761558373e-02 7.74189831242099946173595981235849e-01 9.39469516602500082091964372921211e-03
            7.52831023147999989220124916755594e-01 8.19119495638999939313151799069601e-02 9.57664735487499980959302803285027e-03
            7.75372778355699954211388558178442e-01 1.57712845729199996336333811086661e-01 9.62124237562500018994260386762107e-03
            1.68907315778699995689748902805150e-01 7.50394309974199980040054924756987e-01 9.74049564629999968523588194102558e-03
            1.68733583291899996714491294369509e-01 7.08311507268000045689504418078286e-02 9.86510278867499916521932590285360e-03
            8.21244708436000003803911795330350e-02 1.76299662677100010821362729984685e-01 1.03091194524499996099109466740629e-02
            6.28870536334499963260213917237706e-01 8.07744953317000025094785087276250e-02 1.28218109620750007199285747105932e-02
            8.11413015265999987279954552832351e-02 3.05437358977599993092866270671948e-01 1.29101410483750001639835502942333e-02
            2.96911206508000014014925227456843e-01 6.22748598887099991117111130733974e-01 1.29557510567249994232197352062030e-02
            7.67542314170999995237565372008248e-02 6.24724714954600024441333516733721e-01 1.32131997045249992284166040690252e-02
            6.22302233384499969837122534954688e-01 3.01148582116600005420536945166532e-01 1.34626393256749993243559515576635e-02
            3.10378628805099976428749641854665e-01 7.79098365078999960386951784130360e-02 1.35473832329750000502688322967515e-02
            8.19218215187000053933985554976971e-02 4.60363303835099990646284595641191e-01 1.46184286611000004152405296053985e-02
            4.71702266501299982692785306426231e-01 8.21554006796999941597547945093538e-02 1.48215792090750000248311479822405e-02
            4.54660341525000011309032288409071e-01 4.63756503388999985482143983972492e-01 1.48589569187250001430777857081011e-02
            1.70109133923700001078671562027012e-01 6.42227780818800053630468482879223e-01 1.57950063965749988581510621088455e-02
            6.40600432948699949342596937640337e-01 1.89829353725600002977813574034371e-01 1.58231711288249997371391231126836e-02
            1.91226758371700000793680374044925e-01 1.73995568534300010243853762403887e-01 1.60176840442999984803762458795973e-02
            1.88531576706999992598667859056150e-01 4.79891407040600015410092282763799e-01 2.03010148979500017196730965451934e-02
            4.77292995769100003577989355108002e-01 3.34835659811899999382944770331960e-01 2.03609378382499997539589742245880e-02
            3.12697462175999973954532151765306e-01 4.95797219725900017994746349359048e-01 2.03669800310249983488208869175651e-02
            4.96122594594600008210960595533834e-01 1.92755366890399987278570392845722e-01 2.03762637020999982928604055132382e-02
            1.92880531286699991033728451839124e-01 3.16101580726100006568657363459351e-01 2.03791166234749999974784628875568e-02
            3.36004145381600005659805674440577e-01 1.89489280128999987296012363913178e-01 2.04232764905750013850749269295193e-02
            3.33728055084800023788460521245725e-01 3.34357102181099985482859437979641e-01 2.30804583632749985011578530702536e-02
            ];
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   66
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.3e-16
        
        xyw=[
            1.16731059668422516850672110422238e-02 9.81256595128901731861503776599420e-01 6.29143924661215952869042222772578e-04
            9.81003085838795807482881627947791e-01 7.14625048632000492432325700065121e-03 6.31836300180492211470140162532516e-04
            1.06966317091656843568658885601508e-02 1.15153933375963680313391890308594e-02 8.31732383329291985636644302104514e-04
            9.38247698355050507856844888010528e-01 4.95570591340609920005810806742375e-02 2.03758730313529463559762966440303e-03
            1.26627518417216332335950568221961e-02 9.37012362061508063959536229958758e-01 2.15338814354033543721489429856319e-03
            5.98109409983654805031960677297320e-02 1.21364578921857504262282745344237e-02 2.19466865448245292136153494766404e-03
            1.37363297926713905788842495780955e-02 6.12783625596971526228173843264813e-02 2.42748963904181524683933979247286e-03
            9.22952795940536807606235925049987e-01 1.41128270602437471542556224335385e-02 2.56165529787217606527693902762621e-03
            6.33107354992724497000367023247236e-02 9.22019729172741220324382993567269e-01 2.70994220851850011605455037511092e-03
            1.17265100334620030186894013013443e-02 1.50052047522907017196303058881313e-01 3.23463475439669757502403335536201e-03
            1.55472058732349538434647229223629e-01 8.32514712158920922036031697643921e-01 3.40849558957417560559055580426957e-03
            8.34329388898202961577510450297268e-01 1.25228158758818562679149266614331e-02 3.46193320366632332693579421345476e-03
            8.50163803195680189972449625201989e-01 1.37199750873573778076064400011091e-01 3.48553850262133067122727325681808e-03
            1.28816350521985759775001056937072e-02 8.47762706347928718386697255482432e-01 3.60303499919002430743053544404120e-03
            1.51080160895852744218359475780744e-01 1.36526924039371434088652179639212e-02 3.84258638835028405386640137919585e-03
            1.01917879216608352199724407682879e-02 5.77043861834499960394850859302096e-01 4.06224505631519808290796902383590e-03
            2.81337239930328053549857258985867e-01 7.06685375962319506371045463311020e-01 4.24295760700374360169240262052881e-03
            7.12437462850067815267607329587918e-01 1.24569780989904569518111898673851e-02 4.25221331053354800744159547321033e-03
            2.76302525086301542511790785283665e-01 1.21741311385635160580154234821748e-02 4.27383801686572611933101484282815e-03
            1.09658368560643058875481159475385e-02 4.19430671246641517679876187685295e-01 4.34722136397842819771630828995512e-03
            4.28911051788389230399189955278416e-01 5.59961606746893991726210515480489e-01 4.36359906096797731805958520112654e-03
            4.21542055511432756098599838878727e-01 1.16475994784656037422942986836460e-02 4.46016893216582329534380946256533e-03
            5.71125859044400052688672531076008e-01 1.18218313988502580352824011811208e-02 4.46117159698410353091402313907565e-03
            5.82686827051092648410701713146409e-01 4.05788958117720421903129590646131e-01 4.47615843880835775209225957382841e-03
            1.30567806713243281940828310894176e-02 2.72502375086800530112896012724377e-01 4.53149390501767033306856902186155e-03
            1.30760400963916331024128325566380e-02 7.22471252323362289615715781110339e-01 4.61962097205037124786342062066069e-03
            7.26343706240680120345132309012115e-01 2.60298401925062650175135559038608e-01 4.64483910927785108996301843831134e-03
            6.87230068637360441696770863018173e-02 6.31417277209675720239800966737675e-02 5.08042879441407933815977315816781e-03
            8.65230210152928336242439399939030e-01 7.20611837337740562814403233460325e-02 5.34429154523021789080505783431363e-03
            6.48599071037404134587589510374528e-02 8.59043354390996882763431585772196e-01 5.79792135245707582896779186398817e-03
            1.48349494336221382484453101824329e-01 7.88878835223944530063988622714533e-01 6.86066777147932398139840159956293e-03
            6.24359898395993248576552048234589e-02 1.49393549935431552144748934551899e-01 7.25754805850911417081094967329591e-03
            7.87136901173496439376719990832498e-01 6.56382042756524786142335869953968e-02 7.36306846263517968814715786152192e-03
            5.19104921609671449145295696325775e-02 5.25563569560499987964874435419915e-01 7.48590629072921984882293955365640e-03
            1.54312992744386645593834828105173e-01 7.16383926916975000143139595820685e-02 7.67567370296963914083621105532984e-03
            2.61784274560300012080205078746076e-01 6.21479485288090535699545569059410e-02 8.13158414656713762758144525832904e-03
            7.66725787281275161788585137401242e-01 1.65821155483138527042541454648017e-01 8.19710521265222535891581401301664e-03
            2.58210367662758677465006940110470e-01 6.80011976613870916530402155331103e-01 8.28086687980062255420854455678636e-03
            6.79065925147462196020953228980943e-02 7.57151543778184943356279745785287e-01 8.65418817186469624402889166958630e-03
            5.29357827480447351575776337995194e-01 4.12150384110698153605767402041238e-01 8.67703434940211501547047134863533e-03
            6.66036150484166228347149285582418e-02 2.61251308788644442948623236588901e-01 8.68430123509580931262519243318820e-03
            5.85675461899543767230191804173955e-02 3.90223611453476837418463674111990e-01 8.71321906135589900610494140664741e-03
            6.44535360410797703023533244959253e-02 6.37362655976104086619216104736552e-01 8.71503902964948506948417161765974e-03
            6.74813842915122918952874897513539e-01 6.37583342061289193303252886835253e-02 8.88678924937163876307533172393960e-03
            3.91460231036899974910170385555830e-01 5.50323809056281976204161310306517e-01 9.00457490956722665653710890865113e-03
            6.48770149230724513245149864815176e-01 2.83672836026289454380844290426467e-01 9.07315714606773092432145944030708e-03
            3.94649822040804953982018332681037e-01 6.05175522553690892202382656250848e-02 9.54744255207920153316614175764698e-03
            5.39013715193328524222238229413051e-01 6.11990176936390989359537684322277e-02 9.80632000294656865080344942953161e-03
            1.62789508278483069370068392345274e-01 6.86132214103465032373208032367984e-01 1.20677531471879533053748190241095e-02
            6.81243632264075360538413406175096e-01 1.56796834589900763168301978112140e-01 1.22478030391557982103911683680053e-02
            1.54283287802026936041954741085647e-01 1.66751262401978794791546079068212e-01 1.24305208468046286124364385727858e-02
            2.52272775044500019436810589468223e-01 2.50480393339460316592948174729827e-01 1.26766434246480125258571547419706e-02
            2.54798153240699987165385209664237e-01 4.99409064904299981879631786796381e-01 1.27442998510756914237740389239661e-02
            1.48558054919430054807705232633452e-01 5.75602309608733819779047280462692e-01 1.30340015916796080064354868000009e-02
            2.93023960643626513178361392419902e-01 5.65689735416167960302402661909582e-01 1.30865218731192802653628959319576e-02
            2.80899127230993417292381764127640e-01 1.43792157424766281481609553338785e-01 1.31110170887910725684433188575895e-02
            4.82098959297124929346267663277104e-01 2.51855753586498309903873860093881e-01 1.31864911205621295614554000508178e-02
            5.64187824544361671286196724395268e-01 1.46296674315256031162491012764804e-01 1.32362265931905229848775107370784e-02
            1.30769964434412994114254047417489e-01 4.48957758611656820857405136848683e-01 1.35598898625217748059590405773633e-02
            1.47969222194773181167093412113900e-01 3.00117438682896475743433484240086e-01 1.35867550854841725310739874998944e-02
            5.63868422294612758882692560291616e-01 2.81377208929746214227662903795135e-01 1.36775137159699886751917929927913e-02
            4.36115742879062906478537797738682e-01 4.25205344642040350411349436399178e-01 1.39322086478155856420491076619328e-02
            3.60326393528605848359802621416748e-01 2.59919000488856577479879206293845e-01 1.44433566058263344877854450487575e-02
            4.22418833467427368155711064900970e-01 1.45323844330263962643101649518940e-01 1.46348445405671337415931532177638e-02
            3.71900183305260034760664211717085e-01 3.78012270356697988038519042675034e-01 1.52259812669901985898723850709757e-02
            2.41364500692874683895894349916489e-01 3.84756328493939425694492229013122e-01 1.59318491112365387407656669438438e-02
            ];
        
    case  20
        
        % ALG. DEG.:   20
        % PTS CARD.:   78
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.6e-16
        
        xyw=[
            8.94113371120544564440990598086501e-03 8.69832937019904967046457500146062e-03 5.43613634964998197751651076714552e-04
            9.79262262980672537615589590132004e-01 1.02644133743667025776558077154732e-02 7.24678381627867520924091149225887e-04
            1.05475382111858764777601038531429e-02 9.78551420251513315307079210469965e-01 7.71150733413382936942692680304390e-04
            2.37770619471535044411880654990910e-03 6.36551098603542475640182374263532e-02 8.60040827590116511991435999107125e-04
            6.30425115794741308672399782153661e-02 4.15063475086174891309775958347927e-03 1.04746180029397601904395109784218e-03
            9.30842249673007549048975306504872e-01 4.80534822625918074667783486120243e-03 1.11845128744861776678987119737485e-03
            6.29076555490187538932644883971079e-02 9.31679006948127330645093024941161e-01 1.17636052035514221403289525369473e-03
            9.31596224638061132239386097353417e-01 6.26264881801440048691986817175348e-02 1.22169839375744571433046736785855e-03
            6.19516894144997096183224982723914e-03 9.29358705856405231671146793814842e-01 1.29819108422282616759069195921938e-03
            2.87125819236767679254462848348339e-02 3.10202122997133844517492207160103e-02 1.85182647452015081319942613191643e-03
            9.29384447830515436628218139958335e-01 3.42152968218706818315233419980359e-02 1.99388525752322446141229228544489e-03
            3.75457566621084440350308852885064e-02 9.25786888466940460773457743925974e-01 2.08876307273982977572024388734917e-03
            8.68957390638383855852033832434245e-03 1.58497125150980022745272890460910e-01 2.40416652159353974246847052143039e-03
            1.54759705396456059833809604242560e-01 8.36360665768839717237881359324092e-01 2.40795644626127158458017696318620e-03
            8.33102529418505488578716722258832e-01 8.92572448244858054899886212751881e-03 2.46443651895837060467053802881310e-03
            8.37423107352594398022915811452549e-01 1.52916730407855333551125909252733e-01 2.56644700753416677915796917375246e-03
            1.55936250523392300193492587823130e-01 9.49662400580272500483225428524747e-03 2.57970257777745881275222039619166e-03
            9.85996420952242602631088175257901e-03 8.34221149359543612256118194636656e-01 2.65727504076161170909475828239010e-03
            4.05587373328940847816426185090677e-01 7.43893020079156377932783072992606e-03 2.67203267238413444753519776497797e-03
            5.96472789861799967958688739599893e-01 3.95633080931094838206263375468552e-01 2.67422552525793492950167973276621e-03
            8.07478004157673352747526251960153e-03 4.03131942590241598711742199157015e-01 2.72566154284044825581445614659515e-03
            7.50739777207006658832355583399476e-03 5.85160959468056462995377842162270e-01 2.74749458936238144524111248756526e-03
            3.93676451923723913495223314384930e-01 5.97489659289885399751085515163140e-01 2.83557638072564873257808137907432e-03
            5.84653072621227898331142114329850e-01 8.72504649681958392715142025508612e-03 3.01339107324613813404523554595471e-03
            4.87080411211974872998098362586461e-01 2.02129229911995021706783148829345e-02 3.49047984551459139143658738646536e-03
            2.68351281178442480079837650919217e-01 7.20234008866831532102992241561878e-01 3.52869978841008390471611910754746e-03
            7.22395628874778816808088777179364e-01 2.66239936645638886059117567128851e-01 3.54825867614600408417313559539252e-03
            2.71682674235740162504981753954780e-01 1.12882698808235495957497107610834e-02 3.60531690670822012670382328280994e-03
            1.12580842045890902602955918609950e-02 7.16969596332504788271933193755103e-01 3.61760867137254134989765574914600e-03
            1.15034734369742069892694757982099e-02 2.74006711016551163240251298702788e-01 3.62374424680139044577242835032393e-03
            7.14052590056392100237303566245828e-01 1.13511560497063096475400811868894e-02 3.63466939235189585855057003982438e-03
            4.90287105311137894059214659137069e-01 4.93649184146848718501843222838943e-01 3.64910477313937437263136054355073e-03
            2.01423425209245401945601372517558e-02 4.83257345960130813011801365064457e-01 3.68286446165710804404036515791176e-03
            3.61107464858593657508478713680233e-02 9.35679501581967443257781269494444e-02 4.18659908260371037974634234046789e-03
            8.60799881985092385505708989512641e-01 3.97379067075453590307532181213901e-02 4.22388751143841761209740681692892e-03
            1.00589152600109102420056217397359e-01 8.58634341935195832817839800554793e-01 4.23556657210420652720506140553880e-03
            9.18740717058512956771920698884060e-02 3.95513001973351110973631250544713e-02 4.32675430238720938602714483067757e-03
            8.60488829619093564815557328984141e-01 9.66224057079417136817411915217235e-02 4.36311366231689843481200696828637e-03
            4.39842178673168215929933921870543e-02 8.56188634910677426326230943232076e-01 4.43043055398302087349859945675234e-03
            2.01101760673522950151337340685131e-01 7.44911583562643420108884129149374e-01 7.07060060058183059705783080062247e-03
            7.44999372626340194969429830962326e-01 5.36865638165825095895478114016441e-02 7.12491781220322192152982765378511e-03
            5.32186641309854921444433273336472e-02 1.96375427593497520195597871861537e-01 7.12514116346794380840723448500285e-03
            7.45398464740035127107375956256874e-01 1.98206580555018274658607424498769e-01 7.51618058694254655843769441503355e-03
            1.95728993287614227991610960089019e-01 5.55713833156082359643335166765610e-02 7.55078192705701221887348850714261e-03
            1.09253205798743882604107113820646e-01 6.10003618241300005209382106841076e-01 7.59967840192289894457600141208786e-03
            5.67625702000490311993630143660994e-02 7.40912189495913087178280420630472e-01 7.64171990184990719552349247578604e-03
            4.83837933474769513186863889586675e-02 6.07513566097787727215973063721322e-01 7.65168532505687993411358505113640e-03
            1.08061280976018553312556491619034e-01 1.12208151043696344184574797964160e-01 7.73325170501491798713544767451822e-03
            6.18560590099037743705423508799868e-01 2.69875370303500006219366014192929e-01 7.74434552087148713600539551293878e-03
            7.72129601349661354170450522360625e-01 1.11411739533305520488681850110879e-01 7.82865626361630741192332294531298e-03
            6.11573480113249079437309774220921e-01 3.38936767793083126854014608397847e-01 7.83933733479476660410689703439857e-03
            3.38132610337598116245771961985156e-01 4.94693938787471934603878764846741e-02 7.85801173216685647227031097372674e-03
            1.17308412825418789671161334808858e-01 7.69645130979520919467518069723155e-01 7.87955359733825272394724947844225e-03
            2.67455126059624903600564493899583e-01 1.11571880815410764964390466502664e-01 8.10620344963786272629580054172038e-03
            6.54210016002574556992499310581479e-01 1.90654831469986768555102685240854e-01 8.68780380964839088475670791922312e-03
            5.38297481157757953806886064285209e-02 3.35861682684902573825524996209424e-01 8.75983637317068013217191690955588e-03
            1.84884032411679638530088709558186e-01 1.55183152385134193185223239197512e-01 8.76793550775802586760843126967302e-03
            3.37626710474410451912063990675961e-01 6.08140259629467938573554874892579e-01 8.80323038335373286855656260740943e-03
            6.06710203449961738009221789980074e-01 5.42632795598224151878419263539399e-02 8.81538762453738106161793552928430e-03
            4.61261408549577756055271038349019e-01 6.88176670721689642817864296375774e-02 9.16008050856753804069843027946263e-03
            1.52546536567121610028507916467788e-01 6.51024084574876482633953855838627e-01 9.19332769175813975526256882631060e-03
            7.00582543543041696976203525082383e-02 4.66190439274151768866971679017297e-01 9.29189157342165047981374925711862e-03
            4.70420137903155344272221327628358e-01 4.63482645535340020970238583686296e-01 9.33428929015709535343958691555599e-03
            1.21646169374595991552467921792413e-01 2.38149487551563648901620240394550e-01 1.00993336646966382769141645781019e-02
            6.37140405270220422373483870615019e-01 1.23839938451338629765707821661636e-01 1.03395010159411937511464429917396e-02
            2.37990451511855216626400988388923e-01 6.37021645232653477286532961443299e-01 1.05489447967511071335700023610116e-02
            1.48392985717712283522118354994745e-01 4.89418857778011029413534060950042e-01 1.23862751009288368786442902091949e-02
            3.59806957154975348700531867507380e-01 1.45288086625325107981154815206537e-01 1.25104815285276872727227015502649e-02
            4.94144105509497388872830470063491e-01 3.61021638381830600739164083279320e-01 1.26448646778648133431888211930527e-02
            1.44063068798082477561806058474758e-01 3.51350834188701499627427438099403e-01 1.30009302546985686110936342174682e-02
            5.01976444000366672781865418073721e-01 1.43549166329308974798806275430252e-01 1.30383391971379339335790348286537e-02
            3.55542383429807595796035002422286e-01 5.01649159950201317670348544197623e-01 1.31224788089477160252238618909360e-02
            2.44343954077136160663030750583857e-01 2.40605212910407650905852960931952e-01 1.49789940628951307594052266836115e-02
            2.43706498934185139537689224198402e-01 5.10901727705534658419139759644167e-01 1.49902499356569449129317206370615e-02
            5.12220080732083804520016201422550e-01 2.45273797354294331718449484469602e-01 1.49978818032193532416851411426251e-02
            2.52603831517775601067654633880011e-01 3.70031955509367738166304206970381e-01 1.58533295862338420578740993960309e-02
            3.75989565285068993993888852855889e-01 2.50540661163056177507257871184265e-01 1.58827965277093981211198325809164e-02
            3.72907798714407878737375767741469e-01 3.75375027754923540346254640098778e-01 1.59301651418000608795288997043826e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    13   36 5.69e-16    0    0
    16   55 7.82e-13    0    0
    18   66 6.28e-16    0    0
    20   78 6.59e-16    0    0
    ];




