
function [xyw,pointset_stats]=set_taylor_wingate_bos_siam_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% M.A. Taylor, B.A. Wingate, L.P. Bos,
% "A cardinal algorithm for computing multivariate quadrature points",
% SIAM J. Numer. Anal.,
% Vol. 45, no.1, (2007),  pp.193-205.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |  13 |  36 |   0 |   0 | 3.94e-13 |PI|
% |  16 |  55 |   0 |   0 | 7.82e-13 |PI|
% |  18 |  66 |   0 |   0 | 5.01e-13 |PI|
% |  20 |  78 |   0 |   0 | 7.68e-13 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------




switch deg
    
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   36
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-13
        
        xyw=[
            2.42935351589999987131918146587850e-02 9.49305929384600011289307985862251e-01 4.15602496892499961161915322804816e-03
            2.65193427721999996915513975181966e-02 2.42695130639999992472333190107747e-02 4.17029249444999996349059401268278e-03
            9.49212602355099965834028807876166e-01 2.65067966436999986890032943165352e-02 4.17076422667500036622900694283089e-03
            3.37757637490000012236990301062178e-03 4.76731641236300018871219208449475e-01 4.39202175207499979220360231124687e-03
            4.75767229810100000797490338300122e-01 5.19892182910200006951129125809530e-01 4.61186654612500031291677515810079e-03
            5.19078319347100025638042097853031e-01 5.59127062019999961084426587376583e-03 4.94856025470000009114368566542908e-03
            8.61683974532099994370071271987399e-01 1.33996048618000001412253752164361e-02 5.08850989637500000783987275099207e-03
            1.24920975992600005732846568662353e-01 8.61305432133400050709326478681760e-01 5.17132159849999998441072435184651e-03
            1.38565453861000005553183456186161e-02 1.24773371735799998294424995037843e-01 5.20678415214999995574984836821386e-03
            2.11887064221999987800870712817414e-02 8.43843835122299990025851457176032e-01 7.94549445697500036911442578002607e-03
            8.43229678721900022253521456150338e-01 1.35456364583000005152868538971234e-01 8.01180088102500069513478564431352e-03
            1.35423179786500008647820436635811e-01 2.13482820656000008008312818219565e-02 8.01519202864999988356053961524594e-03
            3.08885351067899993626753030184773e-01 2.21919663013999991785230037066867e-02 1.07691489795750001967622466736429e-02
            6.68505759516900055494659227406373e-01 3.08901287938899982155049883658648e-01 1.09618353834749996528197257816828e-02
            2.26545012556999998676321439461390e-02 6.69170994332100033119559157057665e-01 1.09802418183249997363226668767311e-02
            2.80851540877199989942880620219512e-01 6.92471815510599997267604521766771e-01 1.19987980922749998963228179604812e-02
            6.92244674905099999229207696771482e-01 2.68723345026000010049571642412047e-02 1.20951565183250002444292903192036e-02
            2.68617447119000006539035751984557e-02 2.81009397322199983015877933212323e-01 1.21216855843749998777880705347343e-02
            1.14177848546999999301831962839060e-01 7.97358141358599947778884597937576e-01 1.39241122006000007937931428614320e-02
            7.97480792206100019825498748105019e-01 8.79806508790999947100530675925256e-02 1.40256591088999994776376212257674e-02
            8.92807293894000014722323044225050e-02 1.14502056112799996401285795855074e-01 1.41297530923250001799740260821636e-02
            1.05248789245500004585487374697550e-01 6.68690411992200028912236575706629e-01 1.72322472667499997089901597746575e-02
            6.66302228073999969204521676147124e-01 2.27505163183199993204297584270535e-01 1.79303334022249995227671348629883e-02
            2.30780373754700007804530059729586e-01 1.05457256122099995998553367826389e-01 1.81863480244000008667626389069483e-02
            1.70505915754000009210145094584732e-01 5.17406439865800038546694850083441e-01 1.97201834184249982784287169579329e-02
            5.08659397304299987219167178409407e-01 3.17052385520899981941056466894224e-01 2.02528586377999988976661427386716e-02
            3.14182386228100019032183354283916e-01 1.81070636165899995217998252883262e-01 2.06431324763750000117479288519462e-02
            4.61746081786399975577239729318535e-01 4.67859453980400019634799946288695e-01 2.10511141832500012216478069149161e-02
            6.93087496081000037362329635470815e-02 4.62285604208500011669258356050705e-01 2.10896383326250012879565787216052e-02
            4.65195525926800024230090002674842e-01 7.24357805669000043291561041769455e-02 2.12992467122000012080818009962968e-02
            2.57862585789299991745338047621772e-01 6.13139503917700001700552547845291e-01 2.25711332013000011420533752470874e-02
            6.11262776677899966060181213833857e-01 1.30036083460900009356464579468593e-01 2.28570785871250008181032598031379e-02
            1.30518213593399989846943753946107e-01 2.58171382888400025024111528182402e-01 2.29069766352250001051338301749638e-02
            4.28143799182799988933822987746680e-01 2.36200596981700011722793419721711e-01 2.56393343723999994621109976833395e-02
            3.35699578373000018238769825984491e-01 4.31102630858800017765730672181235e-01 2.58289915353249986684769368139314e-02
            2.30542429883599991891074409977591e-01 3.45601394937600003842703699774574e-01 2.58963591798249993802816248944509e-02
            ];
        
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   55
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.8e-13
        
        xyw=[
            1.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.55064996275000002885768868310379e-04
            0.00000000000000000000000000000000e+00 1.00000000000000000000000000000000e+00 1.57879367799999994039297779302444e-04
            0.00000000000000000000000000000000e+00 0.00000000000000000000000000000000e+00 1.77165038975000000819742806967838e-04
            9.39886358357699958077091650920920e-01 4.98487446340000004557646562375339e-03 1.37909290419999997802380509170916e-03
            5.43806683058000034369783293186629e-02 9.38640561861699973533745833265129e-01 1.56731019139999994300993524376509e-03
            9.39400491640000022408596436207517e-03 5.26424462697000009048231561337161e-02 1.96328522064999995075385008647118e-03
            1.64345086361999993818105991749690e-02 9.46903551735099990871447062090738e-01 2.36378709660000014061709272539247e-03
            9.46948726986200028932216810062528e-01 3.63373677167000003196406510141969e-02 2.44561278177499999073041259123329e-03
            4.26604005767999977516424792156613e-02 1.51224541798999998626351626285214e-02 2.49654108722499991704357746868936e-03
            1.22269495439000005360119516240047e-02 8.69377351066400017032265168381855e-01 3.43884547040000003795268135320384e-03
            8.67369652104699961903122584772063e-01 1.20491728577399995203656146713911e-01 3.52447945099999999929440974710815e-03
            8.45674402138899994341159072064329e-01 1.57763967870000014481757233397730e-02 3.74117160842499978448683073395387e-03
            1.39575963210299996974939062965859e-01 8.44812087037499992447919794358313e-01 3.90243759030000020651685055383950e-03
            1.31782174323099993129559948101814e-01 1.35009605583999992006738466443494e-02 3.94209233370000026314139418559535e-03
            1.57955126300000012196100840355939e-02 1.45527493853600004003467915936199e-01 4.39486365957500024065351951207958e-03
            7.36546288443600039030911830195691e-01 1.55697540907999993492483170598462e-02 5.10284600675000015596038949183821e-03
            1.39688430330000001866608272393933e-02 7.37983689445000035078692235401832e-01 5.23907196540000005130499616257111e-03
            2.54789518603899978188565000891685e-01 7.29761568977099983612788491882384e-01 5.26783532495000029333143132248551e-03
            7.31638652255499954968342990468955e-01 2.54307668331499980851617692678701e-01 5.44116900505000038873459899946283e-03
            1.57253728950999989433245929149052e-02 2.69623979579100003789449147006962e-01 5.55721021747499974163808644789242e-03
            2.66230284364699976151769078569487e-01 1.44783956308000005819280886498746e-02 5.60466734205000011170838547513995e-03
            8.67350406521400052461956420302158e-01 5.91679410399999980429974755224976e-02 5.75306542482499974622278671176900e-03
            7.41493666957000058248539176020131e-02 8.63478257506099966533952283498365e-01 5.92034756249999998684030444451309e-03
            1.59285948359999991741364766539846e-02 4.19123895523800027440586291049840e-01 6.43661608420000030950092195780599e-03
            1.56061028068000002405613102496318e-02 5.80922292114600002932434108515736e-01 6.44892004019999992570078006792755e-03
            5.91009481748399956302364444127306e-01 1.59251452650999991700331293031923e-02 6.45180819024999963051669737978955e-03
            4.03477149688900027513227541930974e-01 5.80670036810399969873230929806596e-01 6.50858080147500000361970862172711e-03
            5.69474562852600008078240989561891e-01 4.14949514630200022580197583010886e-01 6.64420354022499971835546972442899e-03
            6.78493700649999975649251382492366e-02 7.61218678590999953126328136931988e-02 6.64461904577500015595115101518786e-03
            4.26596859027200014935488070477732e-01 1.57509692312000001979122032480518e-02 6.68830823095000002315169140842954e-03
            6.70982507890000023920151761558373e-02 7.74189831242099946173595981235849e-01 9.39469516602500082091964372921211e-03
            7.52831023147999989220124916755594e-01 8.19119495638999939313151799069601e-02 9.57664735487499980959302803285027e-03
            7.75372778355699954211388558178442e-01 1.57712845729199996336333811086661e-01 9.62124237562500018994260386762107e-03
            1.68907315778699995689748902805150e-01 7.50394309974199980040054924756987e-01 9.74049564629999968523588194102558e-03
            1.68733583291899996714491294369509e-01 7.08311507268000045689504418078286e-02 9.86510278867499916521932590285360e-03
            8.21244708436000003803911795330350e-02 1.76299662677100010821362729984685e-01 1.03091194524499996099109466740629e-02
            6.28870536334499963260213917237706e-01 8.07744953317000025094785087276250e-02 1.28218109620750007199285747105932e-02
            8.11413015265999987279954552832351e-02 3.05437358977599993092866270671948e-01 1.29101410483750001639835502942333e-02
            2.96911206508000014014925227456843e-01 6.22748598887099991117111130733974e-01 1.29557510567249994232197352062030e-02
            7.67542314170999995237565372008248e-02 6.24724714954600024441333516733721e-01 1.32131997045249992284166040690252e-02
            6.22302233384499969837122534954688e-01 3.01148582116600005420536945166532e-01 1.34626393256749993243559515576635e-02
            3.10378628805099976428749641854665e-01 7.79098365078999960386951784130360e-02 1.35473832329750000502688322967515e-02
            8.19218215187000053933985554976971e-02 4.60363303835099990646284595641191e-01 1.46184286611000004152405296053985e-02
            4.71702266501299982692785306426231e-01 8.21554006796999941597547945093538e-02 1.48215792090750000248311479822405e-02
            4.54660341525000011309032288409071e-01 4.63756503388999985482143983972492e-01 1.48589569187250001430777857081011e-02
            1.70109133923700001078671562027012e-01 6.42227780818800053630468482879223e-01 1.57950063965749988581510621088455e-02
            6.40600432948699949342596937640337e-01 1.89829353725600002977813574034371e-01 1.58231711288249997371391231126836e-02
            1.91226758371700000793680374044925e-01 1.73995568534300010243853762403887e-01 1.60176840442999984803762458795973e-02
            1.88531576706999992598667859056150e-01 4.79891407040600015410092282763799e-01 2.03010148979500017196730965451934e-02
            4.77292995769100003577989355108002e-01 3.34835659811899999382944770331960e-01 2.03609378382499997539589742245880e-02
            3.12697462175999973954532151765306e-01 4.95797219725900017994746349359048e-01 2.03669800310249983488208869175651e-02
            4.96122594594600008210960595533834e-01 1.92755366890399987278570392845722e-01 2.03762637020999982928604055132382e-02
            1.92880531286699991033728451839124e-01 3.16101580726100006568657363459351e-01 2.03791166234749999974784628875568e-02
            3.36004145381600005659805674440577e-01 1.89489280128999987296012363913178e-01 2.04232764905750013850749269295193e-02
            3.33728055084800023788460521245725e-01 3.34357102181099985482859437979641e-01 2.30804583632749985011578530702536e-02
            ];
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   66
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.0e-13
        
        xyw=[
            1.16731059668000007600863199286323e-02 9.81256595128899955504664376348956e-01 6.29143924649999989814896927953214e-04
            9.81003085838800026330375203542644e-01 7.14625048630000009319829246123845e-03 6.31836300174999968524980342721165e-04
            1.06966317092000006566676617580924e-02 1.15153933376000005422978844649151e-02 8.31732383324999954496425935701609e-04
            9.38247698355100023803743169992231e-01 4.95570591341000024621088471121766e-02 2.03758730312499991912944530270124e-03
            1.26627518416999994971261500609216e-02 9.37012362061499959331456466316013e-01 2.15338814355000001538043008508794e-03
            5.98109409984000015003680061909108e-02 1.21364578921999994448599480278972e-02 2.19466865447500011562786959018467e-03
            1.37363297926999996384500590806965e-02 6.12783625596999975693179862901161e-02 2.42748963905000010587986736254607e-03
            9.22952795940499948201818369852845e-01 1.41128270601999991629149633354245e-02 2.56165529787500019509582926957592e-03
            6.33107354992999971088352140213829e-02 9.22019729172700031050169400259620e-01 2.70994220852500012491903547129368e-03
            1.17265100335000004017071972839403e-02 1.50052047522899995035672304766194e-01 3.23463475440000005484142420186799e-03
            1.55472058732299994732173331613012e-01 8.32514712158900049843168744700961e-01 3.40849558957500003292251378184119e-03
            8.34329388898199963975343962374609e-01 1.25228158758999997407501680868336e-02 3.46193320367499998008176120833923e-03
            8.50163803195699951942287952988409e-01 1.37199750873600007095021169334359e-01 3.48553850262500004505983319802453e-03
            1.28816350522000001854738826523317e-02 8.47762706347899963610359463928035e-01 3.60303499919999983477914007323761e-03
            1.51080160895900011963632891820453e-01 1.36526924038999995097976025704156e-02 3.84258638834999999289721017703414e-03
            1.01917879217000000718895691420585e-02 5.77043861834499960394850859302096e-01 4.06224505632500013790897597232288e-03
            2.81337239930300020418485473783221e-01 7.06685375962299966445812060555909e-01 4.24295760700000006843124467081907e-03
            7.12437462850100011735321459127590e-01 1.24569780989999996656525382832115e-02 4.25221331052500015751371975625261e-03
            2.76302525086299988199556310064509e-01 1.21741311386000007621621676889845e-02 4.27383801687499995103358685355488e-03
            1.09658368560999995577898147303131e-02 4.19430671246599995338755206830683e-01 4.34722136397500038412777811913656e-03
            4.28911051788399999562528819296858e-01 5.59961606746899986930543491325807e-01 4.36359906097500034605207730464826e-03
            4.21542055511499980102740892107249e-01 1.16475994784999998393759668147140e-02 4.46016893217499998253172677209477e-03
            5.71125859044400052688672531076008e-01 1.18218313988999994962325601477460e-02 4.46117159697499970211209685544418e-03
            5.82686827051099975882664239179576e-01 4.05788958117699993799476487765787e-01 4.47615843879999985438500331724754e-03
            1.30567806713000004320557323467256e-02 2.72502375086799975001383700146107e-01 4.53149390502500040711630902023899e-03
            1.30760400963999996737374686972544e-02 7.22471252323300006104034309828421e-01 4.61962097205000001703956158394249e-03
            7.26343706240699993337273099314189e-01 2.60298401925100009179914195556194e-01 4.64483910927500007193025055585167e-03
            6.87230068637000035547401921576238e-02 6.31417277210000044140869590592047e-02 5.08042879442500028980278514723068e-03
            8.65230210152900025555311458447250e-01 7.20611837337999938668531285657082e-02 5.34429154522499984258931959857364e-03
            6.48599071037000013406625953393814e-02 8.59043354390999991387900536210509e-01 5.79792135244999989190928246785006e-03
            1.48349494336200010691229067560926e-01 7.88878835224000041215219880541554e-01 6.86066777147500018313452940788011e-03
            6.24359898395999979303638838246115e-02 1.49393549935399994055273964477237e-01 7.25754805849999993366816752882187e-03
            7.87136901173499992090398791333428e-01 6.56382042756999961596875436953269e-02 7.36306846262500033079012595749191e-03
            5.19104921610000005771645703589456e-02 5.25563569560499987964874435419915e-01 7.48590629072500013396762597039924e-03
            1.54312992744399996025705945612572e-01 7.16383926916999980161193661842844e-02 7.67567370297500030373871737765512e-03
            2.61784274560300012080205078746076e-01 6.21479485287999983134099579729082e-02 8.13158414657499939437457214808092e-03
            7.66725787281300030784336740907747e-01 1.65821155483100002303586961716064e-01 8.19710521264999970869613576951451e-03
            2.58210367662700002178155500587309e-01 6.80011976613900004373647334432462e-01 8.28086687979999978848066888303947e-03
            6.79065925147000065686953007570992e-02 7.57151543778200042389414647914236e-01 8.65418817187500050147619390372711e-03
            5.29357827480399945052624843810918e-01 4.12150384110699985473758033549530e-01 8.67703434940000038755325562078724e-03
            6.66036150483999972449211668390490e-02 2.61251308788599978516486999069457e-01 8.68430123510000040454315239912830e-03
            5.85675461898999966114942594685999e-02 3.90223611453499985568527108625858e-01 8.71321906134999921156314428571932e-03
            6.44535360411000041169771179738746e-02 6.37362655976099978794024991657352e-01 8.71503902965000028235653672936678e-03
            6.74813842915100048358567619288806e-01 6.37583342060999980205338033556473e-02 8.88678924937500065717177477608857e-03
            3.91460231036899974910170385555830e-01 5.50323809056299961817160237842472e-01 9.00457490957499995243296098124119e-03
            6.48770149230699977316305648855632e-01 2.83672836026300001499578229413601e-01 9.07315714607499941568580226203267e-03
            3.94649822040800013489558750734432e-01 6.05175522554000019925801723275072e-02 9.54744255207500003290732593086432e-03
            5.39013715193299991490505362889962e-01 6.11990176935999982688052512003196e-02 9.80632000294999993383893155396436e-03
            1.62789508278500000271193925982516e-01 6.86132214103500004398483724799007e-01 1.20677531471999992251920019725731e-02
            6.81243632264100007489560084650293e-01 1.56796834589900013767760356131475e-01 1.22478030391500007645344538786958e-02
            1.54283287802000013133607581039541e-01 1.66751262402000000051316419558134e-01 1.24305208468000003702025324514580e-02
            2.52272775044500019436810589468223e-01 2.50480393339500007066078524076147e-01 1.26766434246500005189606241629008e-02
            2.54798153240699987165385209664237e-01 4.99409064904299981879631786796381e-01 1.27442998510749992691071241779355e-02
            1.48558054919399995519313506520120e-01 5.75602309608699957976796213188209e-01 1.30340015916750005808832924003582e-02
            2.93023960643599978848072851178586e-01 5.65689735416200045747814328933600e-01 1.30865218731249996486631914649479e-02
            2.80899127231000023119378283809056e-01 1.43792157424800004505982542468701e-01 1.31110170887999994554506955068973e-02
            4.82098959297100004839364828512771e-01 2.51855753586499975238410797828692e-01 1.31864911205749994749236719826513e-02
            5.64187824544399973980546292295912e-01 1.46296674315299995994266168963804e-01 1.32362265931999997792267720342352e-02
            1.30769964434400004504865933085966e-01 4.48957758611700008533063055438106e-01 1.35598898625249996569008814617519e-02
            1.47969222194799993053138109644351e-01 3.00117438682899972945961053483188e-01 1.35867550854749993133330221439792e-02
            5.63868422294599991317909370991401e-01 2.81377208929800004533205992629519e-01 1.36775137159750002913138899884871e-02
            4.36115742879000012344192782620667e-01 4.25205344641999993804404311958933e-01 1.39322086478249999863532337940342e-02
            3.60326393528499988594404612740618e-01 2.59919000488899987200142049914575e-01 1.44433566058250004854324188841019e-02
            4.22418833467400001158154054792249e-01 1.45323844330299989380250735848676e-01 1.46348445405750007125567080379369e-02
            3.71900183305200027206183222006075e-01 3.78012270356699986439963367956807e-01 1.52259812669999997775116540310592e-02
            2.41364500692799993641912692510232e-01 3.84756328493999988360485531302402e-01 1.59318491112249993602034692230518e-02
            ];
        
    case  20
        
        % ALG. DEG.:   20
        % PTS CARD.:   78
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.7e-13
        
        xyw=[
            8.94113371120000034741881478339565e-03 8.69832937020000029892941029174835e-03 5.43613634974999962792829855118271e-04
            9.79262262980699960124297831498552e-01 1.02644133744000005947771825276504e-02 7.24678381625000023018301487098825e-04
            1.05475382112000005963015070165056e-02 9.78551420251499992630783708591480e-01 7.71150733424999946380440363213893e-04
            2.37770619469999987607988778393064e-03 6.36551098604000026304206016902754e-02 8.60040827599999990575596608977094e-04
            6.30425115794999990637137443627580e-02 4.15063475090000043310478616831460e-03 1.04746180030000006315471505757841e-03
            9.30842249672999999532407855440397e-01 4.80534822629999965742930712053749e-03 1.11845128744999990771935571842732e-03
            6.29076555490000050019361310660315e-02 9.31679006948100019158687246090267e-01 1.17636052035000005996923100326512e-03
            9.31596224638099990045247977832332e-01 6.26264881800999984040601020751637e-02 1.22169839375000006433114041470844e-03
            6.19516894150000038687942094384198e-03 9.29358705856400013622931055579102e-01 1.29819108422499999294652539560957e-03
            2.87125819236999993422365662354423e-02 3.10202122996999993254085836724698e-02 1.85182647452500001583608479904797e-03
            9.29384447830500004528175850282423e-01 3.42152968218999986582673500379315e-02 1.99388525752499995088995454750602e-03
            3.75457566620999994011498301915708e-02 9.25786888466900048655361388227902e-01 2.08876307275000002577902691314193e-03
            8.68957390639999924242253825923399e-03 1.58497125151000006759716143278638e-01 2.40416652159999985269300815104998e-03
            1.54759705396499996910009144812648e-01 8.36360665768799971253599778719945e-01 2.40795644624999978511414866488849e-03
            8.33102529418500048485896058991784e-01 8.92572448239999961805413164483980e-03 2.46443651895000013021808094038079e-03
            8.37423107352599949138038937235251e-01 1.52916730407799988933348345199192e-01 2.56644700752500006663003873086382e-03
            1.55936250523399988487938117032172e-01 9.49662400579999975425149472130215e-03 2.57970257777499984222502327213533e-03
            9.85996420949999952121345359046245e-03 8.34221149359600011585769152588909e-01 2.65727504074999990382743852990188e-03
            4.05587373328899991609119979329989e-01 7.43893020079999973959150594282619e-03 2.67203267237499982739157289302057e-03
            5.96472789861799967958688739599893e-01 3.95633080931100000743327882446465e-01 2.67422552524999987064169282291459e-03
            8.07478004159999963873506345635178e-03 4.03131942590299996442837482391042e-01 2.72566154285000007695405344065875e-03
            7.50739777210000010926327362881239e-03 5.85160959468099983737943148298655e-01 2.74749458937499982380536778237001e-03
            3.93676451923699988189042642261484e-01 5.97489659289900054695010567229474e-01 2.83557638072499994599806605322101e-03
            5.84653072621200031733224022900686e-01 8.72504649680000063383111807979731e-03 3.01339107325000006218362891274865e-03
            4.87080411212000019549606122382102e-01 2.02129229911999983015924442497635e-02 3.49047984552500016597331722323361e-03
            2.68351281178499989632513234028011e-01 7.20234008866800001769092887116130e-01 3.52869978839999995715026592790764e-03
            7.22395628874800022067859117669286e-01 2.66239936645599972742104455392109e-01 3.54825867615000001970004817053450e-03
            2.71682674235699972431490323288017e-01 1.12882698808000007245633256047768e-02 3.60531690670000013951290718239306e-03
            1.12580842045999999362360100008118e-02 7.16969596332500014312927305581979e-01 3.61760867137499988674398387900055e-03
            1.15034734370000005926337749428967e-02 2.74006711016600013053334805590566e-01 3.62374424680000006490643293943776e-03
            7.14052590056399982820778404857265e-01 1.13511560497000004582579535394871e-02 3.63466939234999980579132738967019e-03
            4.90287105311200011037442436645506e-01 4.93649184146799979711062178466818e-01 3.64910477314999998760258748120577e-03
            2.01423425209000007962689693385983e-02 4.83257345960100004322868016970460e-01 3.68286446165000001459755019084241e-03
            3.61107464858999999135491520974028e-02 9.35679501582000056059129633467819e-02 4.18659908259999980623122795009294e-03
            8.60799881985100046044578903092770e-01 3.97379067074999994813033765694854e-02 4.22388751145000036074650395789831e-03
            1.00589152600099998591254291113728e-01 8.58634341935200051665333376149647e-01 4.23556657209999982277581764833485e-03
            9.18740717058000033734543876562384e-02 3.95513001973000002942093544788804e-02 4.32675430237500040220322006234710e-03
            8.60488829619100004109100154892076e-01 9.66224057078999970515909012647171e-02 4.36311366232499959344481865741727e-03
            4.39842178673000017141703210654669e-02 8.56188634910699963853630833909847e-01 4.43043055397500037950742068915133e-03
            2.01101760673499996290303215573658e-01 7.44911583562600010388621285528643e-01 7.07060060057500012337117212268822e-03
            7.44999372626300004895938400295563e-01 5.36865638166000025410795615243842e-02 7.12491781219999967267320073460724e-03
            5.32186641310000013715963973481848e-02 1.96375427593499990441827662834839e-01 7.12514116347499979614577014785937e-03
            7.45398464740099964132014065398835e-01 1.98206580555000011489852340673679e-01 7.51618058694999979785222876671469e-03
            1.95728993287599989381320142456389e-01 5.55713833155999994972695787964767e-02 7.55078192704999959922185226446345e-03
            1.09253205798800004378001915483765e-01 6.10003618241300005209382106841076e-01 7.59967840192499969470540932547920e-03
            5.67625702000999973750872129585332e-02 7.40912189495899986546589843783295e-01 7.64171990185000000322945723496559e-03
            4.83837933475000023242351687713381e-02 6.07513566097800050691546402958920e-01 7.65168532505000002080786103419996e-03
            1.08061280975999998710257443690352e-01 1.12208151043699994042768253166287e-01 7.73325170502500019997782487735094e-03
            6.18560590099100027217104980081785e-01 2.69875370303500006219366014192929e-01 7.74434552087499995104424854730496e-03
            7.72129601349699989931707477808231e-01 1.11411739533299997129134339957091e-01 7.82865626362500011126144272566307e-03
            6.11573480113300038674140068906127e-01 3.38936767793100002243988910777261e-01 7.83933733480000026483391906140241e-03
            3.38132610337600003624913824751275e-01 4.94693938787000020429474034244777e-02 7.85801173217499926426654610622791e-03
            1.17308412825399999146469554034411e-01 7.69645130979500047274655116780195e-01 7.87955359735000027132656441608560e-03
            2.67455126059599979093661659135250e-01 1.11571880815399995801051602484222e-01 8.10620344962499975172143251711532e-03
            6.54210016002599981099763226666255e-01 1.90654831470000007964671340232599e-01 8.68780380965000070814241439620673e-03
            5.38297481157999982426254348411021e-02 3.35861682684900020312568358349381e-01 8.75983637317499959362709915922096e-03
            1.84884032411700011122590581180702e-01 1.55183152385099998316064784376067e-01 8.76793550774999930208508658324718e-03
            3.37626710474400015815632514204481e-01 6.08140259629399992924447815312305e-01 8.80323038334999974363626051854226e-03
            6.06710203449900009609052631276427e-01 5.42632795598000025605323060062801e-02 8.81538762452500034016988905705148e-03
            4.61261408549600016026914772737655e-01 6.88176670721999950153247027628822e-02 9.16008050857500082109208250358279e-03
            1.52546536567099988435103341544163e-01 6.51024084574900019362075909157284e-01 9.19332769175000043271328564742362e-03
            7.00582543543000063612780081712117e-02 4.66190439274200008057391642068978e-01 9.29189157342500023084586047161793e-03
            4.70420137903199975237811258921283e-01 4.63482645535299997430200846793014e-01 9.33428929015000033442284177453985e-03
            1.21646169374600002233144380170415e-01 2.38149487551600008705676714271249e-01 1.00993336647000001710106076302509e-02
            6.37140405270199994269830767734675e-01 1.23839938451299994004450866214029e-01 1.03395010159499992075105012645508e-02
            2.37990451511899986369868997826416e-01 6.37021645232599964536746028898051e-01 1.05489447967500003799923291580853e-02
            1.48392985717699987802120631386060e-01 4.89418857777999982694439040642465e-01 1.23862751009249996703154295119020e-02
            3.59806957154999995651678545982577e-01 1.45288086625299989185222671039810e-01 1.25104815285250001860584134760757e-02
            4.94144105509499997896938339181361e-01 3.61021638381800014094835660216631e-01 1.26448646778749996394397570043111e-02
            1.44063068798099991330019520319183e-01 3.51350834188700000826344194138073e-01 1.30009302546999997579613150833211e-02
            5.01976444000399979472604172769934e-01 1.43549166329300009747882427291188e-01 1.30383391971500006700779294988024e-02
            3.55542383429799990768316320099984e-01 5.01649159950199985402718994009774e-01 1.31224788089500006560417233458793e-02
            2.44343954077099995148003586109553e-01 2.40605212910399990366983047351823e-01 1.49789940629000001282022935811256e-02
            2.43706498934199988770643585667131e-01 5.10901727705500019460771454760106e-01 1.49902499356500008148573854782626e-02
            5.12220080732100013776175728708040e-01 2.45273797354299993855875072767958e-01 1.49978818032249997665994456497174e-02
            2.52603831517800025974196387323900e-01 3.70031955509399990145169567767880e-01 1.58533295862249984375935696334636e-02
            3.75989565285100024727427125981194e-01 2.50540661163099975805579333609785e-01 1.58827965276999993893269902400789e-02
            3.72907798714399996153900929130032e-01 3.75375027754900003618132586780121e-01 1.59301651417999984294837645393272e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    13   36 3.94e-13    0    0
    16   55 7.82e-13    0    0
    18   66 5.01e-13    0    0
    20   78 7.68e-13    0    0
    ];

