
 	function [xyw_bar,pointset_stats]=set_vioreanu_rokhlin_barycentric(deg)
 	
 	 %--------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
 	 %--------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 %--------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
 	 %      REMARK: The sum of the weights makes 1.
 	 % 
 	 % pointset_stats:
 	 %    statistics of the pointset stored in a matrix. Each rows contains
 	 %    degree, cardinality of the full pointset, moment error w.r.t. 
 	 %    orthn. Dubiner basis, number of points with negative weights,
 	 %    number of points outside the domain.
 	 %--------------------------------------------------------------------
       	 % SOURCE:
  	 %  B. Vioreanu and V. Rokhlin,
  	 %  "Spectra of Multiplication Operators as a Numerical Tool",
  	 %  Methods and Algorithms for Scientific Computing,
  	 %  SIAM J. Sci. Comput., 36,1 (2014), pp.267-288.
 	 %--------------------------------------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %--------------------------------------------------------------------
 	 % |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
 	 % |   2 |   3 |   0 |   0 | 4.20e-16 |PI|
 	 % |   4 |   6 |   0 |   0 | 1.53e-16 |PI|
 	 % |   5 |  10 |   0 |   0 | 4.43e-16 |PI|
 	 % |   7 |  15 |   0 |   0 | 6.11e-16 |PI|
 	 % |   8 |  21 |   0 |   0 | 5.27e-16 |PI|
 	 % |  10 |  28 |   0 |   0 | 7.42e-16 |PI|
 	 % |  12 |  36 |   0 |   0 | 7.49e-16 |PI|
 	 % |  14 |  45 |   0 |   0 | 1.03e-15 |PI|
 	 % |  15 |  55 |   0 |   0 | 1.62e-15 |PI|
 	 % |  17 |  66 |   0 |   0 | 1.55e-15 |PI|
 	 % |  19 |  78 |   0 |   0 | 1.40e-15 |PI|
 	 % |  20 |  91 |   0 |   0 | 5.97e-16 |PI|
 	 % |  22 | 105 |   0 |   0 | 3.03e-14 |PI|
 	 % |  24 | 120 |   0 |   0 | 2.02e-14 |PI|
 	 % |  25 | 136 |   0 |   0 | 2.12e-14 |PI|
 	 % |  27 | 153 |   0 |   0 | 2.52e-13 |PI|
 	 % |  28 | 171 |   0 |   0 | 2.86e-15 |PI|
 	 % |  30 | 190 |   0 |   0 | 2.90e-14 |PI|
 	 % |  32 | 210 |   0 |   0 | 4.08e-12 |PI|
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
     %--------------------------------------------------------------------
     % REMARK:
     % There are some issues about the degrees of precision of these rules.
     % Here we list for rules of degree ( X) the error at the actual degree
     % (first row) and at next one, so to show that the degrees of
     % precision are those written in the file.
     %--------------------------------------------------------------------
     % (  1) deg:   1 cub.err.: 1.92e-16
 	 % (  1) deg:   2 cub.err.: 6.80e-01
 	 %--------------------------------------
 	 % (  2) deg:   2 cub.err.: 4.20e-16
 	 % (  2) deg:   3 cub.err.: 2.05e-01
 	 %--------------------------------------
 	 % (  4) deg:   4 cub.err.: 1.53e-16
 	 % (  4) deg:   5 cub.err.: 3.01e-01
 	 %--------------------------------------
 	 % (  5) deg:   5 cub.err.: 4.43e-16
 	 % (  5) deg:   6 cub.err.: 1.77e-01
 	 %--------------------------------------
 	 % (  7) deg:   7 cub.err.: 6.11e-16
 	 % (  7) deg:   8 cub.err.: 2.42e-01
 	 %--------------------------------------
 	 % (  8) deg:   8 cub.err.: 5.27e-16
 	 % (  8) deg:   9 cub.err.: 1.52e-01
 	 %--------------------------------------
 	 % ( 10) deg:  10 cub.err.: 7.42e-16
 	 % ( 10) deg:  11 cub.err.: 1.91e-01
 	 %--------------------------------------
 	 % ( 12) deg:  12 cub.err.: 7.49e-16
 	 % ( 12) deg:  13 cub.err.: 1.92e-01
 	 %--------------------------------------
 	 % ( 14) deg:  14 cub.err.: 1.03e-15
 	 % ( 14) deg:  15 cub.err.: 1.65e-01
 	 %--------------------------------------
 	 % ( 15) deg:  15 cub.err.: 1.62e-15
 	 % ( 15) deg:  16 cub.err.: 2.66e-01
 	 %--------------------------------------
 	 % ( 17) deg:  17 cub.err.: 1.55e-15
 	 % ( 17) deg:  18 cub.err.: 2.35e-01
 	 %--------------------------------------
 	 % ( 19) deg:  19 cub.err.: 1.40e-15
 	 % ( 19) deg:  20 cub.err.: 3.26e-01
 	 %--------------------------------------
 	 % ( 20) deg:  20 cub.err.: 5.97e-16
 	 % ( 20) deg:  21 cub.err.: 1.73e-01
 	 %--------------------------------------
 	 % ( 22) deg:  22 cub.err.: 3.03e-14
 	 % ( 22) deg:  23 cub.err.: 1.09e-01
 	 %--------------------------------------
 	 % ( 24) deg:  24 cub.err.: 2.02e-14
 	 % ( 24) deg:  25 cub.err.: 1.62e-01
 	 %--------------------------------------
 	 % ( 25) deg:  25 cub.err.: 2.12e-14
 	 % ( 25) deg:  26 cub.err.: 6.77e-02
 	 %--------------------------------------
 	 % ( 27) deg:  27 cub.err.: 2.52e-13
 	 % ( 27) deg:  28 cub.err.: 1.31e-01
 	 %--------------------------------------
 	 % ( 28) deg:  28 cub.err.: 2.86e-15
 	 % ( 28) deg:  29 cub.err.: 5.42e-02
 	 %--------------------------------------
 	 % ( 30) deg:  30 cub.err.: 2.90e-14
 	 % ( 30) deg:  31 cub.err.: 7.90e-02
 	 %--------------------------------------
 	 % ( 32) deg:  32 cub.err.: 4.08e-12
 	 % ( 32) deg:  33 cub.err.: 1.04e-01
 	 %--------------------------------------------------------------------
 
 
 	 switch deg
 
 	 case   1 

 	 % ALG. DEG.:    1
 	 % PTS CARD.:    1
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.9e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.00000000000000000000000000000000e+00
 	 ];
 
 	 case   2 

 	 % ALG. DEG.:    2
 	 % PTS CARD.:    3
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.2e-16  

 	 xyw_bar=[
 	 1.66666666666666601903656896865868e-01 1.66666666666666601903656896865868e-01 6.66666666666666740681534975010436e-01 3.33333333333333370340767487505218e-01
 	 1.66666666666666601903656896865868e-01 6.66666666666666740681534975010436e-01 1.66666666666666601903656896865868e-01 3.33333333333333370340767487505218e-01
 	 6.66666666666666740681534975010436e-01 1.66666666666666601903656896865868e-01 1.66666666666666601903656896865868e-01 3.33333333333333370340767487505218e-01
 	 ];
 
 	 case   4 

 	 % ALG. DEG.:    4
 	 % PTS CARD.:    6
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-16  

 	 xyw_bar=[
 	 9.15762135097707430375635340169538e-02 9.15762135097707430375635340169538e-02 8.16847572980458513924872931966092e-01 1.09951743655321856896200927167229e-01
 	 9.15762135097707430375635340169538e-02 8.16847572980458513924872931966092e-01 9.15762135097707430375635340169538e-02 1.09951743655321856896200927167229e-01
 	 8.16847572980458513924872931966092e-01 9.15762135097707430375635340169538e-02 9.15762135097707430375635340169538e-02 1.09951743655321856896200927167229e-01
 	 4.45948490915964890213274429697776e-01 4.45948490915964890213274429697776e-01 1.08103018168070219573451140604448e-01 2.23381589678011444055627521265706e-01
 	 4.45948490915964890213274429697776e-01 1.08103018168070219573451140604448e-01 4.45948490915964890213274429697776e-01 2.23381589678011444055627521265706e-01
 	 1.08103018168070219573451140604448e-01 4.45948490915964890213274429697776e-01 4.45948490915964890213274429697776e-01 2.23381589678011444055627521265706e-01
 	 ];
 
 	 case   5 

 	 % ALG. DEG.:    5
 	 % PTS CARD.:   10
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.4e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.98965370459636609057341161133081e-01
 	 7.11129945334409985235879503306933e-02 7.11129945334409985235879503306933e-02 8.57774010933118002952824099338613e-01 6.02789804071405671548333771170292e-02
 	 7.11129945334409985235879503306933e-02 8.57774010933118002952824099338613e-01 7.11129945334409985235879503306933e-02 6.02789804071405671548333771170292e-02
 	 8.57774010933118002952824099338613e-01 7.11129945334409985235879503306933e-02 7.11129945334409985235879503306933e-02 6.02789804071405671548333771170292e-02
 	 6.14926166643125493571631068334682e-01 3.13979397676981020204323158395709e-01 7.10944356798934862240457732696086e-02 1.03366281386490330151950445269904e-01
 	 6.14926166643125493571631068334682e-01 7.10944356798934862240457732696086e-02 3.13979397676981020204323158395709e-01 1.03366281386490330151950445269904e-01
 	 3.13979397676981020204323158395709e-01 6.14926166643125493571631068334682e-01 7.10944356798934862240457732696086e-02 1.03366281386490330151950445269904e-01
 	 3.13979397676981020204323158395709e-01 7.10944356798934862240457732696086e-02 6.14926166643125493571631068334682e-01 1.03366281386490330151950445269904e-01
 	 7.10944356798934862240457732696086e-02 6.14926166643125493571631068334682e-01 3.13979397676981020204323158395709e-01 1.03366281386490330151950445269904e-01
 	 7.10944356798934862240457732696086e-02 3.13979397676981020204323158395709e-01 6.14926166643125493571631068334682e-01 1.03366281386490330151950445269904e-01
 	 ];
 
 	 case   7 

 	 % ALG. DEG.:    7
 	 % PTS CARD.:   15
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 6.1e-16  

 	 xyw_bar=[
 	 5.12530798414517832495285176719335e-02 5.12530798414517832495285176719335e-02 8.97493840317096447378730772470590e-01 3.20133347298796958058098027777305e-02
 	 5.12530798414517832495285176719335e-02 8.97493840317096447378730772470590e-01 5.12530798414517832495285176719335e-02 3.20133347298796958058098027777305e-02
 	 8.97493840317096447378730772470590e-01 5.12530798414517832495285176719335e-02 5.12530798414517832495285176719335e-02 3.20133347298796958058098027777305e-02
 	 4.74110794051135320259504624118563e-01 4.74110794051135320259504624118563e-01 5.17784118977293594809907517628744e-02 6.48798375470517052487906539681717e-02
 	 4.74110794051135320259504624118563e-01 5.17784118977293594809907517628744e-02 4.74110794051135320259504624118563e-01 6.48798375470517052487906539681717e-02
 	 5.17784118977293594809907517628744e-02 4.74110794051135320259504624118563e-01 4.74110794051135320259504624118563e-01 6.48798375470517052487906539681717e-02
 	 2.42184756344486107337843350251205e-01 2.42184756344486107337843350251205e-01 5.15630487311027785324313299497589e-01 1.27008925694331142874915485663223e-01
 	 2.42184756344486107337843350251205e-01 5.15630487311027785324313299497589e-01 2.42184756344486107337843350251205e-01 1.27008925694331142874915485663223e-01
 	 5.15630487311027785324313299497589e-01 2.42184756344486107337843350251205e-01 2.42184756344486107337843350251205e-01 1.27008925694331142874915485663223e-01
 	 7.18483300897606480539536732976558e-01 2.33346892984868908849094282231817e-01 4.81698061175246106113689847916248e-02 5.47156176810353472861336854293768e-02
 	 7.18483300897606480539536732976558e-01 4.81698061175246106113689847916248e-02 2.33346892984868908849094282231817e-01 5.47156176810353472861336854293768e-02
 	 2.33346892984868908849094282231817e-01 7.18483300897606480539536732976558e-01 4.81698061175246106113689847916248e-02 5.47156176810353472861336854293768e-02
 	 2.33346892984868908849094282231817e-01 4.81698061175246106113689847916248e-02 7.18483300897606480539536732976558e-01 5.47156176810353472861336854293768e-02
 	 4.81698061175246106113689847916248e-02 7.18483300897606480539536732976558e-01 2.33346892984868908849094282231817e-01 5.47156176810353472861336854293768e-02
 	 4.81698061175246106113689847916248e-02 2.33346892984868908849094282231817e-01 7.18483300897606480539536732976558e-01 5.47156176810353472861336854293768e-02
 	 ];
 
 	 case   8 

 	 % ALG. DEG.:    8
 	 % PTS CARD.:   21
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 5.3e-16  

 	 xyw_bar=[
 	 3.14057488009514829130353064101655e-02 3.14057488009514829130353064101655e-02 9.37188502398097034173929387179669e-01 1.37145072550597778987535590999869e-02
 	 3.14057488009514829130353064101655e-02 9.37188502398097034173929387179669e-01 3.14057488009514829130353064101655e-02 1.37145072550597778987535590999869e-02
 	 9.37188502398097034173929387179669e-01 3.14057488009514829130353064101655e-02 3.14057488009514829130353064101655e-02 1.37145072550597778987535590999869e-02
 	 1.96019357807156596740227882946783e-01 1.96019357807156596740227882946783e-01 6.07961284385686751008393002848607e-01 7.43976090198318201762717194469587e-02
 	 1.96019357807156596740227882946783e-01 6.07961284385686751008393002848607e-01 1.96019357807156596740227882946783e-01 7.43976090198318201762717194469587e-02
 	 6.07961284385686751008393002848607e-01 1.96019357807156596740227882946783e-01 1.96019357807156596740227882946783e-01 7.43976090198318201762717194469587e-02
 	 4.04461999739164801415114425253705e-01 4.04461999739164801415114425253705e-01 1.91076000521670397169771149492590e-01 8.50145322145201554064897209173068e-02
 	 4.04461999739164801415114425253705e-01 1.91076000521670397169771149492590e-01 4.04461999739164801415114425253705e-01 8.50145322145201554064897209173068e-02
 	 1.91076000521670397169771149492590e-01 4.04461999739164801415114425253705e-01 4.04461999739164801415114425253705e-01 8.50145322145201554064897209173068e-02
 	 7.87642410206076615253323325305246e-01 1.71130424662843894090258345386246e-01 4.12271651310794906564183293085080e-02 3.84058450381027302600323025671969e-02
 	 7.87642410206076615253323325305246e-01 4.12271651310794906564183293085080e-02 1.71130424662843894090258345386246e-01 3.84058450381027302600323025671969e-02
 	 1.71130424662843894090258345386246e-01 7.87642410206076615253323325305246e-01 4.12271651310794906564183293085080e-02 3.84058450381027302600323025671969e-02
 	 1.71130424662843894090258345386246e-01 4.12271651310794906564183293085080e-02 7.87642410206076615253323325305246e-01 3.84058450381027302600323025671969e-02
 	 4.12271651310794906564183293085080e-02 7.87642410206076615253323325305246e-01 1.71130424662843894090258345386246e-01 3.84058450381027302600323025671969e-02
 	 4.12271651310794906564183293085080e-02 1.71130424662843894090258345386246e-01 7.87642410206076615253323325305246e-01 3.84058450381027302600323025671969e-02
 	 5.84632756543619902522834763658466e-01 3.76058771577794381801851386626367e-01 3.93084718785857156753138497151667e-02 4.16974973838580426077626839287404e-02
 	 5.84632756543619902522834763658466e-01 3.93084718785857156753138497151667e-02 3.76058771577794381801851386626367e-01 4.16974973838580426077626839287404e-02
 	 3.76058771577794381801851386626367e-01 5.84632756543619902522834763658466e-01 3.93084718785857156753138497151667e-02 4.16974973838580426077626839287404e-02
 	 3.76058771577794381801851386626367e-01 3.93084718785857156753138497151667e-02 5.84632756543619902522834763658466e-01 4.16974973838580426077626839287404e-02
 	 3.93084718785857156753138497151667e-02 5.84632756543619902522834763658466e-01 3.76058771577794381801851386626367e-01 4.16974973838580426077626839287404e-02
 	 3.93084718785857156753138497151667e-02 3.76058771577794381801851386626367e-01 5.84632756543619902522834763658466e-01 4.16974973838580426077626839287404e-02
 	 ];
 
 	 case  10 

 	 % ALG. DEG.:   10
 	 % PTS CARD.:   28
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.4e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 8.08162600508437606317002632749791e-02
 	 2.27066403128516301757056083943098e-02 2.27066403128516301757056083943098e-02 9.54586719374296732709694879304152e-01 7.38163289619724136830791749730452e-03
 	 2.27066403128516301757056083943098e-02 9.54586719374296732709694879304152e-01 2.27066403128516301757056083943098e-02 7.38163289619724136830791749730452e-03
 	 9.54586719374296732709694879304152e-01 2.27066403128516301757056083943098e-02 2.27066403128516301757056083943098e-02 7.38163289619724136830791749730452e-03
 	 4.85348136374768979184324280140572e-01 4.85348136374768979184324280140572e-01 2.93037272504620416313514397188555e-02 2.64788860014971358380897470397031e-02
 	 4.85348136374768979184324280140572e-01 2.93037272504620416313514397188555e-02 4.85348136374768979184324280140572e-01 2.64788860014971358380897470397031e-02
 	 2.93037272504620416313514397188555e-02 4.85348136374768979184324280140572e-01 4.85348136374768979184324280140572e-01 2.64788860014971358380897470397031e-02
 	 1.55015517336223013211693455559725e-01 1.55015517336223013211693455559725e-01 6.89968965327554029087764320138376e-01 5.01093142308751612890027615776489e-02
 	 1.55015517336223013211693455559725e-01 6.89968965327554029087764320138376e-01 1.55015517336223013211693455559725e-01 5.01093142308751612890027615776489e-02
 	 6.89968965327554029087764320138376e-01 1.55015517336223013211693455559725e-01 1.55015517336223013211693455559725e-01 5.01093142308751612890027615776489e-02
 	 8.38551707380394306667881210159976e-01 1.30053450518161195503807903151028e-01 3.13948421014444978283108866889961e-02 2.35021042128849833030557192614651e-02
 	 8.38551707380394306667881210159976e-01 3.13948421014444978283108866889961e-02 1.30053450518161195503807903151028e-01 2.35021042128849833030557192614651e-02
 	 1.30053450518161195503807903151028e-01 8.38551707380394306667881210159976e-01 3.13948421014444978283108866889961e-02 2.35021042128849833030557192614651e-02
 	 1.30053450518161195503807903151028e-01 3.13948421014444978283108866889961e-02 8.38551707380394306667881210159976e-01 2.35021042128849833030557192614651e-02
 	 3.13948421014444978283108866889961e-02 8.38551707380394306667881210159976e-01 1.30053450518161195503807903151028e-01 2.35021042128849833030557192614651e-02
 	 3.13948421014444978283108866889961e-02 1.30053450518161195503807903151028e-01 8.38551707380394306667881210159976e-01 2.35021042128849833030557192614651e-02
 	 6.66920601059607931482275944290450e-01 3.02790097367536981121105554848327e-01 3.02893015728550873966185008612229e-02 2.85261227456073511443701562484421e-02
 	 6.66920601059607931482275944290450e-01 3.02893015728550873966185008612229e-02 3.02790097367536981121105554848327e-01 2.85261227456073511443701562484421e-02
 	 3.02790097367536981121105554848327e-01 6.66920601059607931482275944290450e-01 3.02893015728550873966185008612229e-02 2.85261227456073511443701562484421e-02
 	 3.02790097367536981121105554848327e-01 3.02893015728550873966185008612229e-02 6.66920601059607931482275944290450e-01 2.85261227456073511443701562484421e-02
 	 3.02893015728550873966185008612229e-02 6.66920601059607931482275944290450e-01 3.02790097367536981121105554848327e-01 2.85261227456073511443701562484421e-02
 	 3.02893015728550873966185008612229e-02 3.02790097367536981121105554848327e-01 6.66920601059607931482275944290450e-01 2.85261227456073511443701562484421e-02
 	 5.20560306058802990669676091783913e-01 3.30714245940923079469797585261404e-01 1.48725448000273929860526322954684e-01 5.91841464687489632323647015255119e-02
 	 5.20560306058802990669676091783913e-01 1.48725448000273929860526322954684e-01 3.30714245940923079469797585261404e-01 5.91841464687489632323647015255119e-02
 	 3.30714245940923079469797585261404e-01 5.20560306058802990669676091783913e-01 1.48725448000273929860526322954684e-01 5.91841464687489632323647015255119e-02
 	 3.30714245940923079469797585261404e-01 1.48725448000273929860526322954684e-01 5.20560306058802990669676091783913e-01 5.91841464687489632323647015255119e-02
 	 1.48725448000273929860526322954684e-01 5.20560306058802990669676091783913e-01 3.30714245940923079469797585261404e-01 5.91841464687489632323647015255119e-02
 	 1.48725448000273929860526322954684e-01 3.30714245940923079469797585261404e-01 5.20560306058802990669676091783913e-01 5.91841464687489632323647015255119e-02
 	 ];
 
 	 case  12 

 	 % ALG. DEG.:   12
 	 % PTS CARD.:   36
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.5e-16  

 	 xyw_bar=[
 	 1.93652109024277097049093754321802e-02 1.93652109024277097049093754321802e-02 9.61269578195144580590181249135640e-01 5.14135021968478451298567577509857e-03
 	 1.93652109024277097049093754321802e-02 9.61269578195144580590181249135640e-01 1.93652109024277097049093754321802e-02 5.14135021968478451298567577509857e-03
 	 9.61269578195144580590181249135640e-01 1.93652109024277097049093754321802e-02 1.93652109024277097049093754321802e-02 5.14135021968478451298567577509857e-03
 	 1.20430831569190502361443861900625e-01 1.20430831569190502361443861900625e-01 7.59138336861619023032687891827663e-01 3.16396426284812487539355174703815e-02
 	 1.20430831569190502361443861900625e-01 7.59138336861619023032687891827663e-01 1.20430831569190502361443861900625e-01 3.16396426284812487539355174703815e-02
 	 7.59138336861619023032687891827663e-01 1.20430831569190502361443861900625e-01 1.20430831569190502361443861900625e-01 3.16396426284812487539355174703815e-02
 	 4.40005690210435618237028165822267e-01 4.40005690210435618237028165822267e-01 1.19988619579128763525943668355467e-01 4.67416591710063458742219211217162e-02
 	 4.40005690210435618237028165822267e-01 1.19988619579128763525943668355467e-01 4.40005690210435618237028165822267e-01 4.67416591710063458742219211217162e-02
 	 1.19988619579128763525943668355467e-01 4.40005690210435618237028165822267e-01 4.40005690210435618237028165822267e-01 4.67416591710063458742219211217162e-02
 	 2.71524632000497700978769444191130e-01 2.71524632000497700978769444191130e-01 4.56950735999004598042461111617740e-01 6.24578255383044858572993973666598e-02
 	 2.71524632000497700978769444191130e-01 4.56950735999004598042461111617740e-01 2.71524632000497700978769444191130e-01 6.24578255383044858572993973666598e-02
 	 4.56950735999004598042461111617740e-01 2.71524632000497700978769444191130e-01 2.71524632000497700978769444191130e-01 6.24578255383044858572993973666598e-02
 	 8.69373866882279577872338904853677e-01 1.06407946399805095061275039824977e-01 2.42181867179153270663860553213453e-02 1.48143538290031913373656635712905e-02
 	 8.69373866882279577872338904853677e-01 2.42181867179153270663860553213453e-02 1.06407946399805095061275039824977e-01 1.48143538290031913373656635712905e-02
 	 1.06407946399805095061275039824977e-01 8.69373866882279577872338904853677e-01 2.42181867179153270663860553213453e-02 1.48143538290031913373656635712905e-02
 	 1.06407946399805095061275039824977e-01 2.42181867179153270663860553213453e-02 8.69373866882279577872338904853677e-01 1.48143538290031913373656635712905e-02
 	 2.42181867179153270663860553213453e-02 8.69373866882279577872338904853677e-01 1.06407946399805095061275039824977e-01 1.48143538290031913373656635712905e-02
 	 2.42181867179153270663860553213453e-02 1.06407946399805095061275039824977e-01 8.69373866882279577872338904853677e-01 1.48143538290031913373656635712905e-02
 	 5.62233442343925027273598971078172e-01 4.14262053470467184190795251197414e-01 2.35045041856077885356057777244132e-02 1.83093224679997355897054234219468e-02
 	 5.62233442343925027273598971078172e-01 2.35045041856077885356057777244132e-02 4.14262053470467184190795251197414e-01 1.83093224679997355897054234219468e-02
 	 4.14262053470467184190795251197414e-01 5.62233442343925027273598971078172e-01 2.35045041856077885356057777244132e-02 1.83093224679997355897054234219468e-02
 	 4.14262053470467184190795251197414e-01 2.35045041856077885356057777244132e-02 5.62233442343925027273598971078172e-01 1.83093224679997355897054234219468e-02
 	 2.35045041856077885356057777244132e-02 5.62233442343925027273598971078172e-01 4.14262053470467184190795251197414e-01 1.83093224679997355897054234219468e-02
 	 2.35045041856077885356057777244132e-02 4.14262053470467184190795251197414e-01 5.62233442343925027273598971078172e-01 1.83093224679997355897054234219468e-02
 	 7.25103351867971257505018911615480e-01 2.52014086602536824255338387956726e-01 2.28825615294919182396427004277939e-02 1.90258494711416613343057946394765e-02
 	 7.25103351867971257505018911615480e-01 2.28825615294919182396427004277939e-02 2.52014086602536824255338387956726e-01 1.90258494711416613343057946394765e-02
 	 2.52014086602536824255338387956726e-01 7.25103351867971257505018911615480e-01 2.28825615294919182396427004277939e-02 1.90258494711416613343057946394765e-02
 	 2.52014086602536824255338387956726e-01 2.28825615294919182396427004277939e-02 7.25103351867971257505018911615480e-01 1.90258494711416613343057946394765e-02
 	 2.28825615294919182396427004277939e-02 7.25103351867971257505018911615480e-01 2.52014086602536824255338387956726e-01 1.90258494711416613343057946394765e-02
 	 2.28825615294919182396427004277939e-02 2.52014086602536824255338387956726e-01 7.25103351867971257505018911615480e-01 1.90258494711416613343057946394765e-02
 	 6.17412891519986017918597553943982e-01 2.66109864468771106782440938332002e-01 1.16477244011242875298961507724016e-01 4.15269021197835694336752965227788e-02
 	 6.17412891519986017918597553943982e-01 1.16477244011242875298961507724016e-01 2.66109864468771106782440938332002e-01 4.15269021197835694336752965227788e-02
 	 2.66109864468771106782440938332002e-01 6.17412891519986017918597553943982e-01 1.16477244011242875298961507724016e-01 4.15269021197835694336752965227788e-02
 	 2.66109864468771106782440938332002e-01 1.16477244011242875298961507724016e-01 6.17412891519986017918597553943982e-01 4.15269021197835694336752965227788e-02
 	 1.16477244011242875298961507724016e-01 6.17412891519986017918597553943982e-01 2.66109864468771106782440938332002e-01 4.15269021197835694336752965227788e-02
 	 1.16477244011242875298961507724016e-01 2.66109864468771106782440938332002e-01 6.17412891519986017918597553943982e-01 4.15269021197835694336752965227788e-02
 	 ];
 
 	 case  14 

 	 % ALG. DEG.:   14
 	 % PTS CARD.:   45
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 1.88250991695915192991606090799905e-02 1.88250991695915192991606090799905e-02 9.62349801660816961401678781840019e-01 4.62291117115323259290082802408506e-03
 	 1.88250991695915192991606090799905e-02 9.62349801660816961401678781840019e-01 1.88250991695915192991606090799905e-02 4.62291117115323259290082802408506e-03
 	 9.62349801660816961401678781840019e-01 1.88250991695915192991606090799905e-02 1.88250991695915192991606090799905e-02 4.62291117115323259290082802408506e-03
 	 4.90249109938372285011354279049556e-01 4.90249109938372285011354279049556e-01 1.95017801232554299772914419008885e-02 1.43428868364703140242388812453100e-02
 	 4.90249109938372285011354279049556e-01 1.95017801232554299772914419008885e-02 4.90249109938372285011354279049556e-01 1.43428868364703140242388812453100e-02
 	 1.95017801232554299772914419008885e-02 4.90249109938372285011354279049556e-01 4.90249109938372285011354279049556e-01 1.43428868364703140242388812453100e-02
 	 8.19725416516456917292998696211725e-02 8.19725416516456917292998696211725e-02 8.36054916696708616541400260757655e-01 1.73982229394614301698496205972333e-02
 	 8.19725416516456917292998696211725e-02 8.36054916696708616541400260757655e-01 8.19725416516456917292998696211725e-02 1.73982229394614301698496205972333e-02
 	 8.36054916696708616541400260757655e-01 8.19725416516456917292998696211725e-02 8.19725416516456917292998696211725e-02 1.73982229394614301698496205972333e-02
 	 2.20530835565724586677660568057036e-01 2.20530835565724586677660568057036e-01 5.58938328868550771133527632628102e-01 4.53860877671218021500720851690858e-02
 	 2.20530835565724586677660568057036e-01 5.58938328868550771133527632628102e-01 2.20530835565724586677660568057036e-01 4.53860877671218021500720851690858e-02
 	 5.58938328868550771133527632628102e-01 2.20530835565724586677660568057036e-01 2.20530835565724586677660568057036e-01 4.53860877671218021500720851690858e-02
 	 3.86124189278291285454258741083322e-01 3.86124189278291285454258741083322e-01 2.27751621443417429091482517833356e-01 5.21922928761801158126232280665135e-02
 	 3.86124189278291285454258741083322e-01 2.27751621443417429091482517833356e-01 3.86124189278291285454258741083322e-01 5.21922928761801158126232280665135e-02
 	 2.27751621443417429091482517833356e-01 3.86124189278291285454258741083322e-01 3.86124189278291285454258741083322e-01 5.21922928761801158126232280665135e-02
 	 8.87822775364344285442541604425060e-01 9.67912764708029893512275521061383e-02 1.53859481648527252062308434688020e-02 8.20408190048361671276033746380563e-03
 	 8.87822775364344285442541604425060e-01 1.53859481648527252062308434688020e-02 9.67912764708029893512275521061383e-02 8.20408190048361671276033746380563e-03
 	 9.67912764708029893512275521061383e-02 8.87822775364344285442541604425060e-01 1.53859481648527252062308434688020e-02 8.20408190048361671276033746380563e-03
 	 9.67912764708029893512275521061383e-02 1.53859481648527252062308434688020e-02 8.87822775364344285442541604425060e-01 8.20408190048361671276033746380563e-03
 	 1.53859481648527252062308434688020e-02 8.87822775364344285442541604425060e-01 9.67912764708029893512275521061383e-02 8.20408190048361671276033746380563e-03
 	 1.53859481648527252062308434688020e-02 9.67912764708029893512275521061383e-02 8.87822775364344285442541604425060e-01 8.20408190048361671276033746380563e-03
 	 7.67286163241992502648258778208401e-01 2.14478157320871803959150270202372e-01 1.82356794371356933925909515892272e-02 1.18935919339511787795604647044456e-02
 	 7.67286163241992502648258778208401e-01 1.82356794371356933925909515892272e-02 2.14478157320871803959150270202372e-01 1.18935919339511787795604647044456e-02
 	 2.14478157320871803959150270202372e-01 7.67286163241992502648258778208401e-01 1.82356794371356933925909515892272e-02 1.18935919339511787795604647044456e-02
 	 2.14478157320871803959150270202372e-01 1.82356794371356933925909515892272e-02 7.67286163241992502648258778208401e-01 1.18935919339511787795604647044456e-02
 	 1.82356794371356933925909515892272e-02 7.67286163241992502648258778208401e-01 2.14478157320871803959150270202372e-01 1.18935919339511787795604647044456e-02
 	 1.82356794371356933925909515892272e-02 2.14478157320871803959150270202372e-01 7.67286163241992502648258778208401e-01 1.18935919339511787795604647044456e-02
 	 6.33349939282431551035301708907355e-01 3.48145146811778216644484018615913e-01 1.85049139057902323202142724767327e-02 1.31258507832268389581287237888318e-02
 	 6.33349939282431551035301708907355e-01 1.85049139057902323202142724767327e-02 3.48145146811778216644484018615913e-01 1.31258507832268389581287237888318e-02
 	 3.48145146811778216644484018615913e-01 6.33349939282431551035301708907355e-01 1.85049139057902323202142724767327e-02 1.31258507832268389581287237888318e-02
 	 3.48145146811778216644484018615913e-01 1.85049139057902323202142724767327e-02 6.33349939282431551035301708907355e-01 1.31258507832268389581287237888318e-02
 	 1.85049139057902323202142724767327e-02 6.33349939282431551035301708907355e-01 3.48145146811778216644484018615913e-01 1.31258507832268389581287237888318e-02
 	 1.85049139057902323202142724767327e-02 3.48145146811778216644484018615913e-01 6.33349939282431551035301708907355e-01 1.31258507832268389581287237888318e-02
 	 7.07553018466495098337531999277417e-01 2.00642015647370303144114700444334e-01 9.18049658861345985183533002782497e-02 2.89312304714396534288667339751555e-02
 	 7.07553018466495098337531999277417e-01 9.18049658861345985183533002782497e-02 2.00642015647370303144114700444334e-01 2.89312304714396534288667339751555e-02
 	 2.00642015647370303144114700444334e-01 7.07553018466495098337531999277417e-01 9.18049658861345985183533002782497e-02 2.89312304714396534288667339751555e-02
 	 2.00642015647370303144114700444334e-01 9.18049658861345985183533002782497e-02 7.07553018466495098337531999277417e-01 2.89312304714396534288667339751555e-02
 	 9.18049658861345985183533002782497e-02 7.07553018466495098337531999277417e-01 2.00642015647370303144114700444334e-01 2.89312304714396534288667339751555e-02
 	 9.18049658861345985183533002782497e-02 2.00642015647370303144114700444334e-01 7.07553018466495098337531999277417e-01 2.89312304714396534288667339751555e-02
 	 5.41383214828122349970840332389344e-01 3.61345725637031711663382793631172e-01 9.72710595348459383657768739794847e-02 3.75407107823719846106946818053984e-02
 	 5.41383214828122349970840332389344e-01 9.72710595348459383657768739794847e-02 3.61345725637031711663382793631172e-01 3.75407107823719846106946818053984e-02
 	 3.61345725637031711663382793631172e-01 5.41383214828122349970840332389344e-01 9.72710595348459383657768739794847e-02 3.75407107823719846106946818053984e-02
 	 3.61345725637031711663382793631172e-01 9.72710595348459383657768739794847e-02 5.41383214828122349970840332389344e-01 3.75407107823719846106946818053984e-02
 	 9.72710595348459383657768739794847e-02 5.41383214828122349970840332389344e-01 3.61345725637031711663382793631172e-01 3.75407107823719846106946818053984e-02
 	 9.72710595348459383657768739794847e-02 3.61345725637031711663382793631172e-01 5.41383214828122349970840332389344e-01 3.75407107823719846106946818053984e-02
 	 ];
 
 	 case  15 

 	 % ALG. DEG.:   15
 	 % PTS CARD.:   55
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.47752981925974916088684096848738e-02
 	 1.76519929574460200660812603246086e-02 1.76519929574460200660812603246086e-02 9.64696014085107966806731383258011e-01 3.91210040603463381908566631750546e-03
 	 1.76519929574460200660812603246086e-02 9.64696014085107966806731383258011e-01 1.76519929574460200660812603246086e-02 3.91210040603463381908566631750546e-03
 	 9.64696014085107966806731383258011e-01 1.76519929574460200660812603246086e-02 1.76519929574460200660812603246086e-02 3.91210040603463381908566631750546e-03
 	 7.71703842193709466101836369489320e-02 7.71703842193709466101836369489320e-02 8.45659231561258106779632726102136e-01 1.65337256371640324570382318825068e-02
 	 7.71703842193709466101836369489320e-02 8.45659231561258106779632726102136e-01 7.71703842193709466101836369489320e-02 1.65337256371640324570382318825068e-02
 	 8.45659231561258106779632726102136e-01 7.71703842193709466101836369489320e-02 7.71703842193709466101836369489320e-02 1.65337256371640324570382318825068e-02
 	 4.59371797617381893985566421179101e-01 4.59371797617381893985566421179101e-01 8.12564047652362120288671576417983e-02 2.06164703556393422156922667909384e-02
 	 4.59371797617381893985566421179101e-01 8.12564047652362120288671576417983e-02 4.59371797617381893985566421179101e-01 2.06164703556393422156922667909384e-02
 	 8.12564047652362120288671576417983e-02 4.59371797617381893985566421179101e-01 4.59371797617381893985566421179101e-01 2.06164703556393422156922667909384e-02
 	 2.04922897588778796240660540206591e-01 2.04922897588778796240660540206591e-01 5.90154204822442407518678919586819e-01 3.19653987298611566569839226303884e-02
 	 2.04922897588778796240660540206591e-01 5.90154204822442407518678919586819e-01 2.04922897588778796240660540206591e-01 3.19653987298611566569839226303884e-02
 	 5.90154204822442407518678919586819e-01 2.04922897588778796240660540206591e-01 2.04922897588778796240660540206591e-01 3.19653987298611566569839226303884e-02
 	 9.03429699782029027588237113377545e-01 8.35136443388274640753365929413121e-02 1.30566558791435083364262936811429e-02 5.67392893537030547357336018876595e-03
 	 9.03429699782029027588237113377545e-01 1.30566558791435083364262936811429e-02 8.35136443388274640753365929413121e-02 5.67392893537030547357336018876595e-03
 	 8.35136443388274640753365929413121e-02 9.03429699782029027588237113377545e-01 1.30566558791435083364262936811429e-02 5.67392893537030547357336018876595e-03
 	 8.35136443388274640753365929413121e-02 1.30566558791435083364262936811429e-02 9.03429699782029027588237113377545e-01 5.67392893537030547357336018876595e-03
 	 1.30566558791435083364262936811429e-02 9.03429699782029027588237113377545e-01 8.35136443388274640753365929413121e-02 5.67392893537030547357336018876595e-03
 	 1.30566558791435083364262936811429e-02 8.35136443388274640753365929413121e-02 9.03429699782029027588237113377545e-01 5.67392893537030547357336018876595e-03
 	 8.10386575943458420390186347503914e-01 1.70743649147708009827795194723876e-01 1.88697749088335697820184577722102e-02 8.97907823151040604403583245129994e-03
 	 8.10386575943458420390186347503914e-01 1.88697749088335697820184577722102e-02 1.70743649147708009827795194723876e-01 8.97907823151040604403583245129994e-03
 	 1.70743649147708009827795194723876e-01 8.10386575943458420390186347503914e-01 1.88697749088335697820184577722102e-02 8.97907823151040604403583245129994e-03
 	 1.70743649147708009827795194723876e-01 1.88697749088335697820184577722102e-02 8.10386575943458420390186347503914e-01 8.97907823151040604403583245129994e-03
 	 1.88697749088335697820184577722102e-02 8.10386575943458420390186347503914e-01 1.70743649147708009827795194723876e-01 8.97907823151040604403583245129994e-03
 	 1.88697749088335697820184577722102e-02 1.70743649147708009827795194723876e-01 8.10386575943458420390186347503914e-01 8.97907823151040604403583245129994e-03
 	 7.02894663916247330881503785349196e-01 2.80682296607787373776687900317484e-01 1.64230394759652953418083143333206e-02 1.07165968553832070819797905869564e-02
 	 7.02894663916247330881503785349196e-01 1.64230394759652953418083143333206e-02 2.80682296607787373776687900317484e-01 1.07165968553832070819797905869564e-02
 	 2.80682296607787373776687900317484e-01 7.02894663916247330881503785349196e-01 1.64230394759652953418083143333206e-02 1.07165968553832070819797905869564e-02
 	 2.80682296607787373776687900317484e-01 1.64230394759652953418083143333206e-02 7.02894663916247330881503785349196e-01 1.07165968553832070819797905869564e-02
 	 1.64230394759652953418083143333206e-02 7.02894663916247330881503785349196e-01 2.80682296607787373776687900317484e-01 1.07165968553832070819797905869564e-02
 	 1.64230394759652953418083143333206e-02 2.80682296607787373776687900317484e-01 7.02894663916247330881503785349196e-01 1.07165968553832070819797905869564e-02
 	 5.64636464683940575426390751090366e-01 4.19465101758231984074853926358628e-01 1.58984335578274404987553225510055e-02 1.17235804303089333894272172642559e-02
 	 5.64636464683940575426390751090366e-01 1.58984335578274404987553225510055e-02 4.19465101758231984074853926358628e-01 1.17235804303089333894272172642559e-02
 	 4.19465101758231984074853926358628e-01 5.64636464683940575426390751090366e-01 1.58984335578274404987553225510055e-02 1.17235804303089333894272172642559e-02
 	 4.19465101758231984074853926358628e-01 1.58984335578274404987553225510055e-02 5.64636464683940575426390751090366e-01 1.17235804303089333894272172642559e-02
 	 1.58984335578274404987553225510055e-02 5.64636464683940575426390751090366e-01 4.19465101758231984074853926358628e-01 1.17235804303089333894272172642559e-02
 	 1.58984335578274404987553225510055e-02 4.19465101758231984074853926358628e-01 5.64636464683940575426390751090366e-01 1.17235804303089333894272172642559e-02
 	 5.84478584036716264371591478266055e-01 3.33042061006166123515725985271274e-01 8.24793549571176121126825364626711e-02 2.52243533019002770523275813729924e-02
 	 5.84478584036716264371591478266055e-01 8.24793549571176121126825364626711e-02 3.33042061006166123515725985271274e-01 2.52243533019002770523275813729924e-02
 	 3.33042061006166123515725985271274e-01 5.84478584036716264371591478266055e-01 8.24793549571176121126825364626711e-02 2.52243533019002770523275813729924e-02
 	 3.33042061006166123515725985271274e-01 8.24793549571176121126825364626711e-02 5.84478584036716264371591478266055e-01 2.52243533019002770523275813729924e-02
 	 8.24793549571176121126825364626711e-02 5.84478584036716264371591478266055e-01 3.33042061006166123515725985271274e-01 2.52243533019002770523275813729924e-02
 	 8.24793549571176121126825364626711e-02 3.33042061006166123515725985271274e-01 5.84478584036716264371591478266055e-01 2.52243533019002770523275813729924e-02
 	 7.17030852299470722321927951270482e-01 1.92513233859061300146109374509251e-01 9.04559138414679775319626742202672e-02 2.58199751262594909273495602519688e-02
 	 7.17030852299470722321927951270482e-01 9.04559138414679775319626742202672e-02 1.92513233859061300146109374509251e-01 2.58199751262594909273495602519688e-02
 	 1.92513233859061300146109374509251e-01 7.17030852299470722321927951270482e-01 9.04559138414679775319626742202672e-02 2.58199751262594909273495602519688e-02
 	 1.92513233859061300146109374509251e-01 9.04559138414679775319626742202672e-02 7.17030852299470722321927951270482e-01 2.58199751262594909273495602519688e-02
 	 9.04559138414679775319626742202672e-02 7.17030852299470722321927951270482e-01 1.92513233859061300146109374509251e-01 2.58199751262594909273495602519688e-02
 	 9.04559138414679775319626742202672e-02 1.92513233859061300146109374509251e-01 7.17030852299470722321927951270482e-01 2.58199751262594909273495602519688e-02
 	 4.72245408246903919380343950251699e-01 3.36118950295532514793706013733754e-01 1.91635641457563621337101267272374e-01 3.45527565228181607337454295247881e-02
 	 4.72245408246903919380343950251699e-01 1.91635641457563621337101267272374e-01 3.36118950295532514793706013733754e-01 3.45527565228181607337454295247881e-02
 	 3.36118950295532514793706013733754e-01 4.72245408246903919380343950251699e-01 1.91635641457563621337101267272374e-01 3.45527565228181607337454295247881e-02
 	 3.36118950295532514793706013733754e-01 1.91635641457563621337101267272374e-01 4.72245408246903919380343950251699e-01 3.45527565228181607337454295247881e-02
 	 1.91635641457563621337101267272374e-01 4.72245408246903919380343950251699e-01 3.36118950295532514793706013733754e-01 3.45527565228181607337454295247881e-02
 	 1.91635641457563621337101267272374e-01 3.36118950295532514793706013733754e-01 4.72245408246903919380343950251699e-01 3.45527565228181607337454295247881e-02
 	 ];
 
 	 case  17 

 	 % ALG. DEG.:   17
 	 % PTS CARD.:   66
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-15  

 	 xyw_bar=[
 	 1.33804426737547093456681679413123e-02 1.33804426737547093456681679413123e-02 9.73239114652490577839216712163761e-01 2.26657506916946036371052208835408e-03
 	 1.33804426737547093456681679413123e-02 9.73239114652490577839216712163761e-01 1.33804426737547093456681679413123e-02 2.26657506916946036371052208835408e-03
 	 9.73239114652490577839216712163761e-01 1.33804426737547093456681679413123e-02 1.33804426737547093456681679413123e-02 2.26657506916946036371052208835408e-03
 	 4.92937508753781006287653099207091e-01 4.92937508753781006287653099207091e-01 1.41249824924379874246938015858177e-02 9.20461048313055835157214801256487e-03
 	 4.92937508753781006287653099207091e-01 1.41249824924379874246938015858177e-02 4.92937508753781006287653099207091e-01 9.20461048313055835157214801256487e-03
 	 1.41249824924379874246938015858177e-02 4.92937508753781006287653099207091e-01 4.92937508753781006287653099207091e-01 9.20461048313055835157214801256487e-03
 	 6.86030848984773289345184821286239e-02 6.86030848984773289345184821286239e-02 8.62793830203045342130963035742752e-01 1.20545682898303106733717271481510e-02
 	 6.86030848984773289345184821286239e-02 8.62793830203045342130963035742752e-01 6.86030848984773289345184821286239e-02 1.20545682898303106733717271481510e-02
 	 8.62793830203045342130963035742752e-01 6.86030848984773289345184821286239e-02 6.86030848984773289345184821286239e-02 1.20545682898303106733717271481510e-02
 	 1.63281281675213801873880470338918e-01 1.63281281675213801873880470338918e-01 6.73437436649572340741087828064337e-01 2.23442891612571671589027033633101e-02
 	 1.63281281675213801873880470338918e-01 6.73437436649572340741087828064337e-01 1.63281281675213801873880470338918e-01 2.23442891612571671589027033633101e-02
 	 6.73437436649572340741087828064337e-01 1.63281281675213801873880470338918e-01 1.63281281675213801873880470338918e-01 2.23442891612571671589027033633101e-02
 	 4.17510360602973917831803873923491e-01 4.17510360602973917831803873923491e-01 1.64979278794052164336392252153018e-01 3.12656695521544777949252136295399e-02
 	 4.17510360602973917831803873923491e-01 1.64979278794052164336392252153018e-01 4.17510360602973917831803873923491e-01 3.12656695521544777949252136295399e-02
 	 1.64979278794052164336392252153018e-01 4.17510360602973917831803873923491e-01 4.17510360602973917831803873923491e-01 3.12656695521544777949252136295399e-02
 	 2.86487437482899287566340262856102e-01 2.86487437482899287566340262856102e-01 4.27025125034201424867319474287797e-01 3.68126519077740105290175165464461e-02
 	 2.86487437482899287566340262856102e-01 4.27025125034201424867319474287797e-01 2.86487437482899287566340262856102e-01 3.68126519077740105290175165464461e-02
 	 4.27025125034201424867319474287797e-01 2.86487437482899287566340262856102e-01 2.86487437482899287566340262856102e-01 3.68126519077740105290175165464461e-02
 	 9.22032114610694453205042009358294e-01 6.50938297812631017080775563954376e-02 1.28740556080424450868804342462681e-02 4.45717468698361447138056590233646e-03
 	 9.22032114610694453205042009358294e-01 1.28740556080424450868804342462681e-02 6.50938297812631017080775563954376e-02 4.45717468698361447138056590233646e-03
 	 6.50938297812631017080775563954376e-02 9.22032114610694453205042009358294e-01 1.28740556080424450868804342462681e-02 4.45717468698361447138056590233646e-03
 	 6.50938297812631017080775563954376e-02 1.28740556080424450868804342462681e-02 9.22032114610694453205042009358294e-01 4.45717468698361447138056590233646e-03
 	 1.28740556080424450868804342462681e-02 9.22032114610694453205042009358294e-01 6.50938297812631017080775563954376e-02 4.45717468698361447138056590233646e-03
 	 1.28740556080424450868804342462681e-02 6.50938297812631017080775563954376e-02 9.22032114610694453205042009358294e-01 4.45717468698361447138056590233646e-03
 	 8.42560091151481893589902938401792e-01 1.43419095062200907531035909414641e-01 1.40208137863171988790611521835672e-02 6.31122674550475479260391864499979e-03
 	 8.42560091151481893589902938401792e-01 1.40208137863171988790611521835672e-02 1.43419095062200907531035909414641e-01 6.31122674550475479260391864499979e-03
 	 1.43419095062200907531035909414641e-01 8.42560091151481893589902938401792e-01 1.40208137863171988790611521835672e-02 6.31122674550475479260391864499979e-03
 	 1.43419095062200907531035909414641e-01 1.40208137863171988790611521835672e-02 8.42560091151481893589902938401792e-01 6.31122674550475479260391864499979e-03
 	 1.40208137863171988790611521835672e-02 8.42560091151481893589902938401792e-01 1.43419095062200907531035909414641e-01 6.31122674550475479260391864499979e-03
 	 1.40208137863171988790611521835672e-02 1.43419095062200907531035909414641e-01 8.42560091151481893589902938401792e-01 6.31122674550475479260391864499979e-03
 	 7.43449702189565297949513933417620e-01 2.43155281870591710724482936711865e-01 1.33950159398429913260031298705144e-02 7.64568774392990722910123935207594e-03
 	 7.43449702189565297949513933417620e-01 1.33950159398429913260031298705144e-02 2.43155281870591710724482936711865e-01 7.64568774392990722910123935207594e-03
 	 2.43155281870591710724482936711865e-01 7.43449702189565297949513933417620e-01 1.33950159398429913260031298705144e-02 7.64568774392990722910123935207594e-03
 	 2.43155281870591710724482936711865e-01 1.33950159398429913260031298705144e-02 7.43449702189565297949513933417620e-01 7.64568774392990722910123935207594e-03
 	 1.33950159398429913260031298705144e-02 7.43449702189565297949513933417620e-01 2.43155281870591710724482936711865e-01 7.64568774392990722910123935207594e-03
 	 1.33950159398429913260031298705144e-02 2.43155281870591710724482936711865e-01 7.43449702189565297949513933417620e-01 7.64568774392990722910123935207594e-03
 	 6.22112357616232181101167952874675e-01 3.65088603079598394973714903244399e-01 1.27990393041694239251171438809251e-02 8.41111285245295207946281124122834e-03
 	 6.22112357616232181101167952874675e-01 1.27990393041694239251171438809251e-02 3.65088603079598394973714903244399e-01 8.41111285245295207946281124122834e-03
 	 3.65088603079598394973714903244399e-01 6.22112357616232181101167952874675e-01 1.27990393041694239251171438809251e-02 8.41111285245295207946281124122834e-03
 	 3.65088603079598394973714903244399e-01 1.27990393041694239251171438809251e-02 6.22112357616232181101167952874675e-01 8.41111285245295207946281124122834e-03
 	 1.27990393041694239251171438809251e-02 6.22112357616232181101167952874675e-01 3.65088603079598394973714903244399e-01 8.41111285245295207946281124122834e-03
 	 1.27990393041694239251171438809251e-02 3.65088603079598394973714903244399e-01 6.22112357616232181101167952874675e-01 8.41111285245295207946281124122834e-03
 	 5.17329851757723613303596721380018e-01 4.12641979622127286209121166393743e-01 7.00281686201491004872821122262394e-02 1.68342619500367954299413497665228e-02
 	 5.17329851757723613303596721380018e-01 7.00281686201491004872821122262394e-02 4.12641979622127286209121166393743e-01 1.68342619500367954299413497665228e-02
 	 4.12641979622127286209121166393743e-01 5.17329851757723613303596721380018e-01 7.00281686201491004872821122262394e-02 1.68342619500367954299413497665228e-02
 	 4.12641979622127286209121166393743e-01 7.00281686201491004872821122262394e-02 5.17329851757723613303596721380018e-01 1.68342619500367954299413497665228e-02
 	 7.00281686201491004872821122262394e-02 5.17329851757723613303596721380018e-01 4.12641979622127286209121166393743e-01 1.68342619500367954299413497665228e-02
 	 7.00281686201491004872821122262394e-02 4.12641979622127286209121166393743e-01 5.17329851757723613303596721380018e-01 1.68342619500367954299413497665228e-02
 	 7.62594448273204661425950234843185e-01 1.66359403543997613761362686091161e-01 7.10461481827977248126870790656540e-02 1.77605299356818416289804929419915e-02
 	 7.62594448273204661425950234843185e-01 7.10461481827977248126870790656540e-02 1.66359403543997613761362686091161e-01 1.77605299356818416289804929419915e-02
 	 1.66359403543997613761362686091161e-01 7.62594448273204661425950234843185e-01 7.10461481827977248126870790656540e-02 1.77605299356818416289804929419915e-02
 	 1.66359403543997613761362686091161e-01 7.10461481827977248126870790656540e-02 7.62594448273204661425950234843185e-01 1.77605299356818416289804929419915e-02
 	 7.10461481827977248126870790656540e-02 7.62594448273204661425950234843185e-01 1.66359403543997613761362686091161e-01 1.77605299356818416289804929419915e-02
 	 7.10461481827977248126870790656540e-02 1.66359403543997613761362686091161e-01 7.62594448273204661425950234843185e-01 1.77605299356818416289804929419915e-02
 	 6.40898402664594746269699498952832e-01 2.92115957257160607785095862709568e-01 6.69856400782446459452046383376000e-02 1.93915333518244921429118932110214e-02
 	 6.40898402664594746269699498952832e-01 6.69856400782446459452046383376000e-02 2.92115957257160607785095862709568e-01 1.93915333518244921429118932110214e-02
 	 2.92115957257160607785095862709568e-01 6.40898402664594746269699498952832e-01 6.69856400782446459452046383376000e-02 1.93915333518244921429118932110214e-02
 	 2.92115957257160607785095862709568e-01 6.69856400782446459452046383376000e-02 6.40898402664594746269699498952832e-01 1.93915333518244921429118932110214e-02
 	 6.69856400782446459452046383376000e-02 6.40898402664594746269699498952832e-01 2.92115957257160607785095862709568e-01 1.93915333518244921429118932110214e-02
 	 6.69856400782446459452046383376000e-02 2.92115957257160607785095862709568e-01 6.40898402664594746269699498952832e-01 1.93915333518244921429118932110214e-02
 	 5.57643332782426282001608797145309e-01 2.81112663730934075889678069870570e-01 1.61244003486639642108713132984121e-01 2.88809571685944808938639738471466e-02
 	 5.57643332782426282001608797145309e-01 1.61244003486639642108713132984121e-01 2.81112663730934075889678069870570e-01 2.88809571685944808938639738471466e-02
 	 2.81112663730934075889678069870570e-01 5.57643332782426282001608797145309e-01 1.61244003486639642108713132984121e-01 2.88809571685944808938639738471466e-02
 	 2.81112663730934075889678069870570e-01 1.61244003486639642108713132984121e-01 5.57643332782426282001608797145309e-01 2.88809571685944808938639738471466e-02
 	 1.61244003486639642108713132984121e-01 5.57643332782426282001608797145309e-01 2.81112663730934075889678069870570e-01 2.88809571685944808938639738471466e-02
 	 1.61244003486639642108713132984121e-01 2.81112663730934075889678069870570e-01 5.57643332782426282001608797145309e-01 2.88809571685944808938639738471466e-02
 	 ];
 
 	 case  19 

 	 % ALG. DEG.:   19
 	 % PTS CARD.:   78
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw_bar=[
 	 1.19057700723167493583876108687036e-02 1.19057700723167493583876108687036e-02 9.76188459855366508222118682169821e-01 1.78549331856358108917837146378815e-03
 	 1.19057700723167493583876108687036e-02 9.76188459855366508222118682169821e-01 1.19057700723167493583876108687036e-02 1.78549331856358108917837146378815e-03
 	 9.76188459855366508222118682169821e-01 1.19057700723167493583876108687036e-02 1.19057700723167493583876108687036e-02 1.78549331856358108917837146378815e-03
 	 4.66749672319444475210303835410741e-01 4.66749672319444475210303835410741e-01 6.65006553611110495793923291785177e-02 7.21609522839577847974634750016776e-03
 	 4.66749672319444475210303835410741e-01 6.65006553611110495793923291785177e-02 4.66749672319444475210303835410741e-01 7.21609522839577847974634750016776e-03
 	 6.65006553611110495793923291785177e-02 4.66749672319444475210303835410741e-01 4.66749672319444475210303835410741e-01 7.21609522839577847974634750016776e-03
 	 5.44172191454610487681975428131409e-02 5.44172191454610487681975428131409e-02 8.91165561709077902463604914373718e-01 8.34902453149459836123646994110459e-03
 	 5.44172191454610487681975428131409e-02 8.91165561709077902463604914373718e-01 5.44172191454610487681975428131409e-02 8.34902453149459836123646994110459e-03
 	 8.91165561709077902463604914373718e-01 5.44172191454610487681975428131409e-02 5.44172191454610487681975428131409e-02 8.34902453149459836123646994110459e-03
 	 1.49494614598017605544555408414453e-01 1.49494614598017605544555408414453e-01 7.01010770803964788910889183171093e-01 1.88629245400943681976180243964336e-02
 	 1.49494614598017605544555408414453e-01 7.01010770803964788910889183171093e-01 1.49494614598017605544555408414453e-01 1.88629245400943681976180243964336e-02
 	 7.01010770803964788910889183171093e-01 1.49494614598017605544555408414453e-01 1.49494614598017605544555408414453e-01 1.88629245400943681976180243964336e-02
 	 2.45242132245316712957361460212269e-01 2.45242132245316712957361460212269e-01 5.09515735509366574085277079575462e-01 2.97327779925529722682142619305523e-02
 	 2.45242132245316712957361460212269e-01 5.09515735509366574085277079575462e-01 2.45242132245316712957361460212269e-01 2.97327779925529722682142619305523e-02
 	 5.09515735509366574085277079575462e-01 2.45242132245316712957361460212269e-01 2.45242132245316712957361460212269e-01 2.97327779925529722682142619305523e-02
 	 3.74619062916066780655199863758753e-01 3.74619062916066780655199863758753e-01 2.50761874167866438689600272482494e-01 3.18997491833587359932877802748408e-02
 	 3.74619062916066780655199863758753e-01 2.50761874167866438689600272482494e-01 3.74619062916066780655199863758753e-01 3.18997491833587359932877802748408e-02
 	 2.50761874167866438689600272482494e-01 3.74619062916066780655199863758753e-01 3.74619062916066780655199863758753e-01 3.18997491833587359932877802748408e-02
 	 9.33764288367549766256558996246895e-01 5.69009106573930001360395181109197e-02 9.33480097505723360740148564218543e-03 2.81688502938363212121930523323954e-03
 	 9.33764288367549766256558996246895e-01 9.33480097505723360740148564218543e-03 5.69009106573930001360395181109197e-02 2.81688502938363212121930523323954e-03
 	 5.69009106573930001360395181109197e-02 9.33764288367549766256558996246895e-01 9.33480097505723360740148564218543e-03 2.81688502938363212121930523323954e-03
 	 5.69009106573930001360395181109197e-02 9.33480097505723360740148564218543e-03 9.33764288367549766256558996246895e-01 2.81688502938363212121930523323954e-03
 	 9.33480097505723360740148564218543e-03 9.33764288367549766256558996246895e-01 5.69009106573930001360395181109197e-02 2.81688502938363212121930523323954e-03
 	 9.33480097505723360740148564218543e-03 5.69009106573930001360395181109197e-02 9.33764288367549766256558996246895e-01 2.81688502938363212121930523323954e-03
 	 8.65595106103016709298003661388066e-01 1.21539313278482399849345085840469e-01 1.28655806185008908526512527714658e-02 4.77873693712923056087227280386287e-03
 	 8.65595106103016709298003661388066e-01 1.28655806185008908526512527714658e-02 1.21539313278482399849345085840469e-01 4.77873693712923056087227280386287e-03
 	 1.21539313278482399849345085840469e-01 8.65595106103016709298003661388066e-01 1.28655806185008908526512527714658e-02 4.77873693712923056087227280386287e-03
 	 1.21539313278482399849345085840469e-01 1.28655806185008908526512527714658e-02 8.65595106103016709298003661388066e-01 4.77873693712923056087227280386287e-03
 	 1.28655806185008908526512527714658e-02 8.65595106103016709298003661388066e-01 1.21539313278482399849345085840469e-01 4.77873693712923056087227280386287e-03
 	 1.28655806185008908526512527714658e-02 1.21539313278482399849345085840469e-01 8.65595106103016709298003661388066e-01 4.77873693712923056087227280386287e-03
 	 7.80245213926672565030173700506566e-01 2.08294353280180588594561186255305e-01 1.14604327931468463752651132381288e-02 6.00142486301634848350206041800448e-03
 	 7.80245213926672565030173700506566e-01 1.14604327931468463752651132381288e-02 2.08294353280180588594561186255305e-01 6.00142486301634848350206041800448e-03
 	 2.08294353280180588594561186255305e-01 7.80245213926672565030173700506566e-01 1.14604327931468463752651132381288e-02 6.00142486301634848350206041800448e-03
 	 2.08294353280180588594561186255305e-01 1.14604327931468463752651132381288e-02 7.80245213926672565030173700506566e-01 6.00142486301634848350206041800448e-03
 	 1.14604327931468463752651132381288e-02 7.80245213926672565030173700506566e-01 2.08294353280180588594561186255305e-01 6.00142486301634848350206041800448e-03
 	 1.14604327931468463752651132381288e-02 2.08294353280180588594561186255305e-01 7.80245213926672565030173700506566e-01 6.00142486301634848350206041800448e-03
 	 5.47138472365763073312905362399761e-01 4.41297885394377475964944324005046e-01 1.15636422398594507221503135951934e-02 6.47131688392673862231241344034061e-03
 	 5.47138472365763073312905362399761e-01 1.15636422398594507221503135951934e-02 4.41297885394377475964944324005046e-01 6.47131688392673862231241344034061e-03
 	 4.41297885394377475964944324005046e-01 5.47138472365763073312905362399761e-01 1.15636422398594507221503135951934e-02 6.47131688392673862231241344034061e-03
 	 4.41297885394377475964944324005046e-01 1.15636422398594507221503135951934e-02 5.47138472365763073312905362399761e-01 6.47131688392673862231241344034061e-03
 	 1.15636422398594507221503135951934e-02 5.47138472365763073312905362399761e-01 4.41297885394377475964944324005046e-01 6.47131688392673862231241344034061e-03
 	 1.15636422398594507221503135951934e-02 4.41297885394377475964944324005046e-01 5.47138472365763073312905362399761e-01 6.47131688392673862231241344034061e-03
 	 6.65889139137802787971054385707248e-01 3.23322608813239320557642031417345e-01 1.07882520489578914713035828754073e-02 6.76709939308820299097568806701020e-03
 	 6.65889139137802787971054385707248e-01 1.07882520489578914713035828754073e-02 3.23322608813239320557642031417345e-01 6.76709939308820299097568806701020e-03
 	 3.23322608813239320557642031417345e-01 6.65889139137802787971054385707248e-01 1.07882520489578914713035828754073e-02 6.76709939308820299097568806701020e-03
 	 3.23322608813239320557642031417345e-01 1.07882520489578914713035828754073e-02 6.65889139137802787971054385707248e-01 6.76709939308820299097568806701020e-03
 	 1.07882520489578914713035828754073e-02 6.65889139137802787971054385707248e-01 3.23322608813239320557642031417345e-01 6.76709939308820299097568806701020e-03
 	 1.07882520489578914713035828754073e-02 3.23322608813239320557642031417345e-01 6.65889139137802787971054385707248e-01 6.76709939308820299097568806701020e-03
 	 7.97030463292363489102854146040045e-01 1.39071275726619897339375597766775e-01 6.38982609810166135577702561931801e-02 1.42554774818164364802441923529841e-02
 	 7.97030463292363489102854146040045e-01 6.38982609810166135577702561931801e-02 1.39071275726619897339375597766775e-01 1.42554774818164364802441923529841e-02
 	 1.39071275726619897339375597766775e-01 7.97030463292363489102854146040045e-01 6.38982609810166135577702561931801e-02 1.42554774818164364802441923529841e-02
 	 1.39071275726619897339375597766775e-01 6.38982609810166135577702561931801e-02 7.97030463292363489102854146040045e-01 1.42554774818164364802441923529841e-02
 	 6.38982609810166135577702561931801e-02 7.97030463292363489102854146040045e-01 1.39071275726619897339375597766775e-01 1.42554774818164364802441923529841e-02
 	 6.38982609810166135577702561931801e-02 1.39071275726619897339375597766775e-01 7.97030463292363489102854146040045e-01 1.42554774818164364802441923529841e-02
 	 6.88298973534612223978967904258752e-01 2.54674408859317413789113970778999e-01 5.70266176060703622319181249622488e-02 1.60037930469036325520360009022625e-02
 	 6.88298973534612223978967904258752e-01 5.70266176060703622319181249622488e-02 2.54674408859317413789113970778999e-01 1.60037930469036325520360009022625e-02
 	 2.54674408859317413789113970778999e-01 6.88298973534612223978967904258752e-01 5.70266176060703622319181249622488e-02 1.60037930469036325520360009022625e-02
 	 2.54674408859317413789113970778999e-01 5.70266176060703622319181249622488e-02 6.88298973534612223978967904258752e-01 1.60037930469036325520360009022625e-02
 	 5.70266176060703622319181249622488e-02 6.88298973534612223978967904258752e-01 2.54674408859317413789113970778999e-01 1.60037930469036325520360009022625e-02
 	 5.70266176060703622319181249622488e-02 2.54674408859317413789113970778999e-01 6.88298973534612223978967904258752e-01 1.60037930469036325520360009022625e-02
 	 5.57143388414403584185663476091577e-01 3.85518010456119386564211026779958e-01 5.73386011294770292501254971284652e-02 1.63620916871317079177572395565221e-02
 	 5.57143388414403584185663476091577e-01 5.73386011294770292501254971284652e-02 3.85518010456119386564211026779958e-01 1.63620916871317079177572395565221e-02
 	 3.85518010456119386564211026779958e-01 5.57143388414403584185663476091577e-01 5.73386011294770292501254971284652e-02 1.63620916871317079177572395565221e-02
 	 3.85518010456119386564211026779958e-01 5.73386011294770292501254971284652e-02 5.57143388414403584185663476091577e-01 1.63620916871317079177572395565221e-02
 	 5.73386011294770292501254971284652e-02 5.57143388414403584185663476091577e-01 3.85518010456119386564211026779958e-01 1.63620916871317079177572395565221e-02
 	 5.73386011294770292501254971284652e-02 3.85518010456119386564211026779958e-01 5.57143388414403584185663476091577e-01 1.63620916871317079177572395565221e-02
 	 6.12834567107272132346906801103614e-01 2.52827382426030589090970579491113e-01 1.34338050466697278562122619405272e-01 2.04886348693677361465503850013192e-02
 	 6.12834567107272132346906801103614e-01 1.34338050466697278562122619405272e-01 2.52827382426030589090970579491113e-01 2.04886348693677361465503850013192e-02
 	 2.52827382426030589090970579491113e-01 6.12834567107272132346906801103614e-01 1.34338050466697278562122619405272e-01 2.04886348693677361465503850013192e-02
 	 2.52827382426030589090970579491113e-01 1.34338050466697278562122619405272e-01 6.12834567107272132346906801103614e-01 2.04886348693677361465503850013192e-02
 	 1.34338050466697278562122619405272e-01 6.12834567107272132346906801103614e-01 2.52827382426030589090970579491113e-01 2.04886348693677361465503850013192e-02
 	 1.34338050466697278562122619405272e-01 2.52827382426030589090970579491113e-01 6.12834567107272132346906801103614e-01 2.04886348693677361465503850013192e-02
 	 4.92042973154920293410441445303150e-01 3.66154971066125323186923878893140e-01 1.41802055778954383402634675803711e-01 2.37981740776729636110964349882124e-02
 	 4.92042973154920293410441445303150e-01 1.41802055778954383402634675803711e-01 3.66154971066125323186923878893140e-01 2.37981740776729636110964349882124e-02
 	 3.66154971066125323186923878893140e-01 4.92042973154920293410441445303150e-01 1.41802055778954383402634675803711e-01 2.37981740776729636110964349882124e-02
 	 3.66154971066125323186923878893140e-01 1.41802055778954383402634675803711e-01 4.92042973154920293410441445303150e-01 2.37981740776729636110964349882124e-02
 	 1.41802055778954383402634675803711e-01 4.92042973154920293410441445303150e-01 3.66154971066125323186923878893140e-01 2.37981740776729636110964349882124e-02
 	 1.41802055778954383402634675803711e-01 3.66154971066125323186923878893140e-01 4.92042973154920293410441445303150e-01 2.37981740776729636110964349882124e-02
 	 ];
 
 	 case  20 

 	 % ALG. DEG.:   20
 	 % PTS CARD.:   91
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 6.0e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.79414564705804321920190602668299e-02
 	 8.57077238529913021380934878834523e-03 8.57077238529913021380934878834523e-03 9.82858455229401739572381302423310e-01 9.90558155838328025996619707882473e-04
 	 8.57077238529913021380934878834523e-03 9.82858455229401739572381302423310e-01 8.57077238529913021380934878834523e-03 9.90558155838328025996619707882473e-04
 	 9.82858455229401739572381302423310e-01 8.57077238529913021380934878834523e-03 8.57077238529913021380934878834523e-03 9.90558155838328025996619707882473e-04
 	 5.15305405051262876980899818590842e-02 5.15305405051262876980899818590842e-02 8.96938918989747424603820036281832e-01 6.40849365050742778709969016404102e-03
 	 5.15305405051262876980899818590842e-02 8.96938918989747424603820036281832e-01 5.15305405051262876980899818590842e-02 6.40849365050742778709969016404102e-03
 	 8.96938918989747424603820036281832e-01 5.15305405051262876980899818590842e-02 5.15305405051262876980899818590842e-02 6.40849365050742778709969016404102e-03
 	 4.94659340413900083799347839885741e-01 4.94659340413900083799347839885741e-01 1.06813191721998324013043202285189e-02 6.96401200751684858192280813682373e-03
 	 4.94659340413900083799347839885741e-01 1.06813191721998324013043202285189e-02 4.94659340413900083799347839885741e-01 6.96401200751684858192280813682373e-03
 	 1.06813191721998324013043202285189e-02 4.94659340413900083799347839885741e-01 4.94659340413900083799347839885741e-01 6.96401200751684858192280813682373e-03
 	 4.37325812915608291842062271825853e-01 4.37325812915608291842062271825853e-01 1.25348374168783416315875456348294e-01 1.66734061189873529473803870359916e-02
 	 4.37325812915608291842062271825853e-01 1.25348374168783416315875456348294e-01 4.37325812915608291842062271825853e-01 1.66734061189873529473803870359916e-02
 	 1.25348374168783416315875456348294e-01 4.37325812915608291842062271825853e-01 4.37325812915608291842062271825853e-01 1.66734061189873529473803870359916e-02
 	 1.32293995381116497034312828873226e-01 1.32293995381116497034312828873226e-01 7.35412009237766950420223110995721e-01 1.67514387916361563723999239527984e-02
 	 1.32293995381116497034312828873226e-01 7.35412009237766950420223110995721e-01 1.32293995381116497034312828873226e-01 1.67514387916361563723999239527984e-02
 	 7.35412009237766950420223110995721e-01 1.32293995381116497034312828873226e-01 1.32293995381116497034312828873226e-01 1.67514387916361563723999239527984e-02
 	 2.15238824344608503658093923149863e-01 2.15238824344608503658093923149863e-01 5.69522351310782992683812153700273e-01 2.24256979453981569738729717755632e-02
 	 2.15238824344608503658093923149863e-01 5.69522351310782992683812153700273e-01 2.15238824344608503658093923149863e-01 2.24256979453981569738729717755632e-02
 	 5.69522351310782992683812153700273e-01 2.15238824344608503658093923149863e-01 2.15238824344608503658093923149863e-01 2.24256979453981569738729717755632e-02
 	 9.43408146097875488500505980482558e-01 4.66217699188314904645835667906795e-02 9.97008398329302103491045272676274e-03 2.73385455951450891468046400234471e-03
 	 9.43408146097875488500505980482558e-01 9.97008398329302103491045272676274e-03 4.66217699188314904645835667906795e-02 2.73385455951450891468046400234471e-03
 	 4.66217699188314904645835667906795e-02 9.43408146097875488500505980482558e-01 9.97008398329302103491045272676274e-03 2.73385455951450891468046400234471e-03
 	 4.66217699188314904645835667906795e-02 9.97008398329302103491045272676274e-03 9.43408146097875488500505980482558e-01 2.73385455951450891468046400234471e-03
 	 9.97008398329302103491045272676274e-03 9.43408146097875488500505980482558e-01 4.66217699188314904645835667906795e-02 2.73385455951450891468046400234471e-03
 	 9.97008398329302103491045272676274e-03 4.66217699188314904645835667906795e-02 9.43408146097875488500505980482558e-01 2.73385455951450891468046400234471e-03
 	 7.95199869823192462270355918008136e-01 1.94613925044525598595512860811141e-01 1.01862051322819391341312211807235e-02 3.87123692869166882712939070643188e-03
 	 7.95199869823192462270355918008136e-01 1.01862051322819391341312211807235e-02 1.94613925044525598595512860811141e-01 3.87123692869166882712939070643188e-03
 	 1.94613925044525598595512860811141e-01 7.95199869823192462270355918008136e-01 1.01862051322819391341312211807235e-02 3.87123692869166882712939070643188e-03
 	 1.94613925044525598595512860811141e-01 1.01862051322819391341312211807235e-02 7.95199869823192462270355918008136e-01 3.87123692869166882712939070643188e-03
 	 1.01862051322819391341312211807235e-02 7.95199869823192462270355918008136e-01 1.94613925044525598595512860811141e-01 3.87123692869166882712939070643188e-03
 	 1.01862051322819391341312211807235e-02 1.94613925044525598595512860811141e-01 7.95199869823192462270355918008136e-01 3.87123692869166882712939070643188e-03
 	 7.24428132024519610965285210113507e-01 2.65496289314309075191289366557612e-01 1.00755786611713138434254233288812e-02 4.15623380054164302116470608439158e-03
 	 7.24428132024519610965285210113507e-01 1.00755786611713138434254233288812e-02 2.65496289314309075191289366557612e-01 4.15623380054164302116470608439158e-03
 	 2.65496289314309075191289366557612e-01 7.24428132024519610965285210113507e-01 1.00755786611713138434254233288812e-02 4.15623380054164302116470608439158e-03
 	 2.65496289314309075191289366557612e-01 1.00755786611713138434254233288812e-02 7.24428132024519610965285210113507e-01 4.15623380054164302116470608439158e-03
 	 1.00755786611713138434254233288812e-02 7.24428132024519610965285210113507e-01 2.65496289314309075191289366557612e-01 4.15623380054164302116470608439158e-03
 	 1.00755786611713138434254233288812e-02 2.65496289314309075191289366557612e-01 7.24428132024519610965285210113507e-01 4.15623380054164302116470608439158e-03
 	 8.75117681769159272420210982090794e-01 1.14200622336593296535234287603089e-01 1.06816958942474310445547303061176e-02 4.31374920999024087653328507485639e-03
 	 8.75117681769159272420210982090794e-01 1.06816958942474310445547303061176e-02 1.14200622336593296535234287603089e-01 4.31374920999024087653328507485639e-03
 	 1.14200622336593296535234287603089e-01 8.75117681769159272420210982090794e-01 1.06816958942474310445547303061176e-02 4.31374920999024087653328507485639e-03
 	 1.14200622336593296535234287603089e-01 1.06816958942474310445547303061176e-02 8.75117681769159272420210982090794e-01 4.31374920999024087653328507485639e-03
 	 1.06816958942474310445547303061176e-02 8.75117681769159272420210982090794e-01 1.14200622336593296535234287603089e-01 4.31374920999024087653328507485639e-03
 	 1.06816958942474310445547303061176e-02 1.14200622336593296535234287603089e-01 8.75117681769159272420210982090794e-01 4.31374920999024087653328507485639e-03
 	 6.21242229278482493981528023141436e-01 3.69462178934587326395444506488275e-01 9.29559178693017962302747037028894e-03 5.77437855793759297756695403336380e-03
 	 6.21242229278482493981528023141436e-01 9.29559178693017962302747037028894e-03 3.69462178934587326395444506488275e-01 5.77437855793759297756695403336380e-03
 	 3.69462178934587326395444506488275e-01 6.21242229278482493981528023141436e-01 9.29559178693017962302747037028894e-03 5.77437855793759297756695403336380e-03
 	 3.69462178934587326395444506488275e-01 9.29559178693017962302747037028894e-03 6.21242229278482493981528023141436e-01 5.77437855793759297756695403336380e-03
 	 9.29559178693017962302747037028894e-03 6.21242229278482493981528023141436e-01 3.69462178934587326395444506488275e-01 5.77437855793759297756695403336380e-03
 	 9.29559178693017962302747037028894e-03 3.69462178934587326395444506488275e-01 6.21242229278482493981528023141436e-01 5.77437855793759297756695403336380e-03
 	 8.23284162466894287035756860859692e-01 1.21432174389561095551037794848526e-01 5.52836631435446174132053442917822e-02 9.99979838740236090521840139899723e-03
 	 8.23284162466894287035756860859692e-01 5.52836631435446174132053442917822e-02 1.21432174389561095551037794848526e-01 9.99979838740236090521840139899723e-03
 	 1.21432174389561095551037794848526e-01 8.23284162466894287035756860859692e-01 5.52836631435446174132053442917822e-02 9.99979838740236090521840139899723e-03
 	 1.21432174389561095551037794848526e-01 5.52836631435446174132053442917822e-02 8.23284162466894287035756860859692e-01 9.99979838740236090521840139899723e-03
 	 5.52836631435446174132053442917822e-02 8.23284162466894287035756860859692e-01 1.21432174389561095551037794848526e-01 9.99979838740236090521840139899723e-03
 	 5.52836631435446174132053442917822e-02 1.21432174389561095551037794848526e-01 8.23284162466894287035756860859692e-01 9.99979838740236090521840139899723e-03
 	 7.35502973872642962227530460950220e-01 2.11973966375945788165324756846530e-01 5.25230597514112496071447822032496e-02 1.15386309756824300548627704188220e-02
 	 7.35502973872642962227530460950220e-01 5.25230597514112496071447822032496e-02 2.11973966375945788165324756846530e-01 1.15386309756824300548627704188220e-02
 	 2.11973966375945788165324756846530e-01 7.35502973872642962227530460950220e-01 5.25230597514112496071447822032496e-02 1.15386309756824300548627704188220e-02
 	 2.11973966375945788165324756846530e-01 5.25230597514112496071447822032496e-02 7.35502973872642962227530460950220e-01 1.15386309756824300548627704188220e-02
 	 5.25230597514112496071447822032496e-02 7.35502973872642962227530460950220e-01 2.11973966375945788165324756846530e-01 1.15386309756824300548627704188220e-02
 	 5.25230597514112496071447822032496e-02 2.11973966375945788165324756846530e-01 7.35502973872642962227530460950220e-01 1.15386309756824300548627704188220e-02
 	 5.24604158534802356150805735524045e-01 4.22476993945888390502574338825070e-01 5.29188475193092533466199256508844e-02 1.18484310488777208614230573857640e-02
 	 5.24604158534802356150805735524045e-01 5.29188475193092533466199256508844e-02 4.22476993945888390502574338825070e-01 1.18484310488777208614230573857640e-02
 	 4.22476993945888390502574338825070e-01 5.24604158534802356150805735524045e-01 5.29188475193092533466199256508844e-02 1.18484310488777208614230573857640e-02
 	 4.22476993945888390502574338825070e-01 5.29188475193092533466199256508844e-02 5.24604158534802356150805735524045e-01 1.18484310488777208614230573857640e-02
 	 5.29188475193092533466199256508844e-02 5.24604158534802356150805735524045e-01 4.22476993945888390502574338825070e-01 1.18484310488777208614230573857640e-02
 	 5.29188475193092533466199256508844e-02 4.22476993945888390502574338825070e-01 5.24604158534802356150805735524045e-01 1.18484310488777208614230573857640e-02
 	 6.30873630515175976007924418809125e-01 3.19958418028188418258395131488214e-01 4.91679514566356057336804497026606e-02 1.21077889838240252556866849431572e-02
 	 6.30873630515175976007924418809125e-01 4.91679514566356057336804497026606e-02 3.19958418028188418258395131488214e-01 1.21077889838240252556866849431572e-02
 	 3.19958418028188418258395131488214e-01 6.30873630515175976007924418809125e-01 4.91679514566356057336804497026606e-02 1.21077889838240252556866849431572e-02
 	 3.19958418028188418258395131488214e-01 4.91679514566356057336804497026606e-02 6.30873630515175976007924418809125e-01 1.21077889838240252556866849431572e-02
 	 4.91679514566356057336804497026606e-02 6.30873630515175976007924418809125e-01 3.19958418028188418258395131488214e-01 1.21077889838240252556866849431572e-02
 	 4.91679514566356057336804497026606e-02 3.19958418028188418258395131488214e-01 6.30873630515175976007924418809125e-01 1.21077889838240252556866849431572e-02
 	 6.45556379414073733258305765048135e-01 2.34468421561538797881496520858491e-01 1.19975199024387468860197714093374e-01 1.73003035754914734345444315977147e-02
 	 6.45556379414073733258305765048135e-01 1.19975199024387468860197714093374e-01 2.34468421561538797881496520858491e-01 1.73003035754914734345444315977147e-02
 	 2.34468421561538797881496520858491e-01 6.45556379414073733258305765048135e-01 1.19975199024387468860197714093374e-01 1.73003035754914734345444315977147e-02
 	 2.34468421561538797881496520858491e-01 1.19975199024387468860197714093374e-01 6.45556379414073733258305765048135e-01 1.73003035754914734345444315977147e-02
 	 1.19975199024387468860197714093374e-01 6.45556379414073733258305765048135e-01 2.34468421561538797881496520858491e-01 1.73003035754914734345444315977147e-02
 	 1.19975199024387468860197714093374e-01 2.34468421561538797881496520858491e-01 6.45556379414073733258305765048135e-01 1.73003035754914734345444315977147e-02
 	 5.39652455990818680220399983227253e-01 3.37729237107069923951030432363041e-01 1.22618306902111395828569584409706e-01 1.76675135330825079649219588873166e-02
 	 5.39652455990818680220399983227253e-01 1.22618306902111395828569584409706e-01 3.37729237107069923951030432363041e-01 1.76675135330825079649219588873166e-02
 	 3.37729237107069923951030432363041e-01 5.39652455990818680220399983227253e-01 1.22618306902111395828569584409706e-01 1.76675135330825079649219588873166e-02
 	 3.37729237107069923951030432363041e-01 1.22618306902111395828569584409706e-01 5.39652455990818680220399983227253e-01 1.76675135330825079649219588873166e-02
 	 1.22618306902111395828569584409706e-01 5.39652455990818680220399983227253e-01 3.37729237107069923951030432363041e-01 1.76675135330825079649219588873166e-02
 	 1.22618306902111395828569584409706e-01 3.37729237107069923951030432363041e-01 5.39652455990818680220399983227253e-01 1.76675135330825079649219588873166e-02
 	 4.51386500463364981339253745318274e-01 3.28819489995002378623922822953318e-01 2.19794009541632584525672200470581e-01 2.55910343589249821005804363949210e-02
 	 4.51386500463364981339253745318274e-01 2.19794009541632584525672200470581e-01 3.28819489995002378623922822953318e-01 2.55910343589249821005804363949210e-02
 	 3.28819489995002378623922822953318e-01 4.51386500463364981339253745318274e-01 2.19794009541632584525672200470581e-01 2.55910343589249821005804363949210e-02
 	 3.28819489995002378623922822953318e-01 2.19794009541632584525672200470581e-01 4.51386500463364981339253745318274e-01 2.55910343589249821005804363949210e-02
 	 2.19794009541632584525672200470581e-01 4.51386500463364981339253745318274e-01 3.28819489995002378623922822953318e-01 2.55910343589249821005804363949210e-02
 	 2.19794009541632584525672200470581e-01 3.28819489995002378623922822953318e-01 4.51386500463364981339253745318274e-01 2.55910343589249821005804363949210e-02
 	 ];
 
 	 case  22 

 	 % ALG. DEG.:   22
 	 % PTS CARD.:  105
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.0e-14  

 	 xyw_bar=[
 	 5.81913467083006175073478516424075e-03 5.81913467083006175073478516424075e-03 9.88361730658339876498530429671519e-01 4.68637034058313670364243064270227e-04
 	 5.81913467083006175073478516424075e-03 9.88361730658339876498530429671519e-01 5.81913467083006175073478516424075e-03 4.68637034058313670364243064270227e-04
 	 9.88361730658339876498530429671519e-01 5.81913467083006175073478516424075e-03 5.81913467083006175073478516424075e-03 4.68637034058313670364243064270227e-04
 	 3.70242529014878085646955696574878e-02 3.70242529014878085646955696574878e-02 9.25951494197024382870608860685024e-01 3.33907489813255534127911516861786e-03
 	 3.70242529014878085646955696574878e-02 9.25951494197024382870608860685024e-01 3.70242529014878085646955696574878e-02 3.33907489813255534127911516861786e-03
 	 9.25951494197024382870608860685024e-01 3.70242529014878085646955696574878e-02 3.70242529014878085646955696574878e-02 3.33907489813255534127911516861786e-03
 	 1.00139964243320195302899833222909e-01 1.00139964243320195302899833222909e-01 7.99720071513359664905351564812008e-01 1.00945212949185032097476621970600e-02
 	 1.00139964243320195302899833222909e-01 7.99720071513359664905351564812008e-01 1.00139964243320195302899833222909e-01 1.00945212949185032097476621970600e-02
 	 7.99720071513359664905351564812008e-01 1.00139964243320195302899833222909e-01 1.00139964243320195302899833222909e-01 1.00945212949185032097476621970600e-02
 	 4.77283361444093778835906505264575e-01 4.77283361444093778835906505264575e-01 4.54332771118124423281869894708507e-02 1.15798841292776826666921508035557e-02
 	 4.77283361444093778835906505264575e-01 4.54332771118124423281869894708507e-02 4.77283361444093778835906505264575e-01 1.15798841292776826666921508035557e-02
 	 4.54332771118124423281869894708507e-02 4.77283361444093778835906505264575e-01 4.77283361444093778835906505264575e-01 1.15798841292776826666921508035557e-02
 	 1.87840033887680113444673679623520e-01 1.87840033887680113444673679623520e-01 6.24319932224639773110652640752960e-01 1.72705278027764017045875277744926e-02
 	 1.87840033887680113444673679623520e-01 6.24319932224639773110652640752960e-01 1.87840033887680113444673679623520e-01 1.72705278027764017045875277744926e-02
 	 6.24319932224639773110652640752960e-01 1.87840033887680113444673679623520e-01 1.87840033887680113444673679623520e-01 1.72705278027764017045875277744926e-02
 	 4.02759919721537684722534322645515e-01 4.02759919721537684722534322645515e-01 1.94480160556924630554931354708970e-01 2.21456711367144370994353153037082e-02
 	 4.02759919721537684722534322645515e-01 1.94480160556924630554931354708970e-01 4.02759919721537684722534322645515e-01 2.21456711367144370994353153037082e-02
 	 1.94480160556924630554931354708970e-01 4.02759919721537684722534322645515e-01 4.02759919721537684722534322645515e-01 2.21456711367144370994353153037082e-02
 	 2.95819836686848580686870491263107e-01 2.95819836686848580686870491263107e-01 4.08360326626302838626259017473785e-01 2.40506213328563998865572415297720e-02
 	 2.95819836686848580686870491263107e-01 4.08360326626302838626259017473785e-01 2.95819836686848580686870491263107e-01 2.40506213328563998865572415297720e-02
 	 4.08360326626302838626259017473785e-01 2.95819836686848580686870491263107e-01 2.95819836686848580686870491263107e-01 2.40506213328563998865572415297720e-02
 	 9.60353805601490417842569513595663e-01 3.24378361207898827101026029140485e-02 7.20835827771969944732788349028851e-03 1.37243742238469797027622387730617e-03
 	 9.60353805601490417842569513595663e-01 7.20835827771969944732788349028851e-03 3.24378361207898827101026029140485e-02 1.37243742238469797027622387730617e-03
 	 3.24378361207898827101026029140485e-02 9.60353805601490417842569513595663e-01 7.20835827771969944732788349028851e-03 1.37243742238469797027622387730617e-03
 	 3.24378361207898827101026029140485e-02 7.20835827771969944732788349028851e-03 9.60353805601490417842569513595663e-01 1.37243742238469797027622387730617e-03
 	 7.20835827771969944732788349028851e-03 9.60353805601490417842569513595663e-01 3.24378361207898827101026029140485e-02 1.37243742238469797027622387730617e-03
 	 7.20835827771969944732788349028851e-03 3.24378361207898827101026029140485e-02 9.60353805601490417842569513595663e-01 1.37243742238469797027622387730617e-03
 	 9.12769702185126097226941510598408e-01 7.96405637940901245386271511961240e-02 7.58973402078377823443133820546791e-03 2.19970879574901603120684612235891e-03
 	 9.12769702185126097226941510598408e-01 7.58973402078377823443133820546791e-03 7.96405637940901245386271511961240e-02 2.19970879574901603120684612235891e-03
 	 7.96405637940901245386271511961240e-02 9.12769702185126097226941510598408e-01 7.58973402078377823443133820546791e-03 2.19970879574901603120684612235891e-03
 	 7.96405637940901245386271511961240e-02 7.58973402078377823443133820546791e-03 9.12769702185126097226941510598408e-01 2.19970879574901603120684612235891e-03
 	 7.58973402078377823443133820546791e-03 9.12769702185126097226941510598408e-01 7.96405637940901245386271511961240e-02 2.19970879574901603120684612235891e-03
 	 7.58973402078377823443133820546791e-03 7.96405637940901245386271511961240e-02 9.12769702185126097226941510598408e-01 2.19970879574901603120684612235891e-03
 	 8.46930929612685123863968783552991e-01 1.44767660510350892888453699924867e-01 8.30140987696398324757751652214210e-03 3.13791477014242932430665433685135e-03
 	 8.46930929612685123863968783552991e-01 8.30140987696398324757751652214210e-03 1.44767660510350892888453699924867e-01 3.13791477014242932430665433685135e-03
 	 1.44767660510350892888453699924867e-01 8.46930929612685123863968783552991e-01 8.30140987696398324757751652214210e-03 3.13791477014242932430665433685135e-03
 	 1.44767660510350892888453699924867e-01 8.30140987696398324757751652214210e-03 8.46930929612685123863968783552991e-01 3.13791477014242932430665433685135e-03
 	 8.30140987696398324757751652214210e-03 8.46930929612685123863968783552991e-01 1.44767660510350892888453699924867e-01 3.13791477014242932430665433685135e-03
 	 8.30140987696398324757751652214210e-03 1.44767660510350892888453699924867e-01 8.46930929612685123863968783552991e-01 3.13791477014242932430665433685135e-03
 	 7.63800852902583815584591775404988e-01 2.27743920492909590613805903558386e-01 8.45522660450659380160232103662565e-03 3.98030762304510486032649296816999e-03
 	 7.63800852902583815584591775404988e-01 8.45522660450659380160232103662565e-03 2.27743920492909590613805903558386e-01 3.98030762304510486032649296816999e-03
 	 2.27743920492909590613805903558386e-01 7.63800852902583815584591775404988e-01 8.45522660450659380160232103662565e-03 3.98030762304510486032649296816999e-03
 	 2.27743920492909590613805903558386e-01 8.45522660450659380160232103662565e-03 7.63800852902583815584591775404988e-01 3.98030762304510486032649296816999e-03
 	 8.45522660450659380160232103662565e-03 7.63800852902583815584591775404988e-01 2.27743920492909590613805903558386e-01 3.98030762304510486032649296816999e-03
 	 8.45522660450659380160232103662565e-03 2.27743920492909590613805903558386e-01 7.63800852902583815584591775404988e-01 3.98030762304510486032649296816999e-03
 	 6.63853996353002795416387016302906e-01 3.27598731749432103832475604576757e-01 8.54727189756510075113737912033685e-03 4.66500380307056754236594287021944e-03
 	 6.63853996353002795416387016302906e-01 8.54727189756510075113737912033685e-03 3.27598731749432103832475604576757e-01 4.66500380307056754236594287021944e-03
 	 3.27598731749432103832475604576757e-01 6.63853996353002795416387016302906e-01 8.54727189756510075113737912033685e-03 4.66500380307056754236594287021944e-03
 	 3.27598731749432103832475604576757e-01 8.54727189756510075113737912033685e-03 6.63853996353002795416387016302906e-01 4.66500380307056754236594287021944e-03
 	 8.54727189756510075113737912033685e-03 6.63853996353002795416387016302906e-01 3.27598731749432103832475604576757e-01 4.66500380307056754236594287021944e-03
 	 8.54727189756510075113737912033685e-03 3.27598731749432103832475604576757e-01 6.63853996353002795416387016302906e-01 4.66500380307056754236594287021944e-03
 	 5.52855567624573107643470848415745e-01 4.38428235397557819474911866564071e-01 8.71619697786907288161728502018377e-03 5.07671711159572019989028035524825e-03
 	 5.52855567624573107643470848415745e-01 8.71619697786907288161728502018377e-03 4.38428235397557819474911866564071e-01 5.07671711159572019989028035524825e-03
 	 4.38428235397557819474911866564071e-01 5.52855567624573107643470848415745e-01 8.71619697786907288161728502018377e-03 5.07671711159572019989028035524825e-03
 	 4.38428235397557819474911866564071e-01 8.71619697786907288161728502018377e-03 5.52855567624573107643470848415745e-01 5.07671711159572019989028035524825e-03
 	 8.71619697786907288161728502018377e-03 5.52855567624573107643470848415745e-01 4.38428235397557819474911866564071e-01 5.07671711159572019989028035524825e-03
 	 8.71619697786907288161728502018377e-03 4.38428235397557819474911866564071e-01 5.52855567624573107643470848415745e-01 5.07671711159572019989028035524825e-03
 	 8.69853922593129991192029137891950e-01 8.94784746607580894206535049306694e-02 4.06676027461119193873173571773805e-02 5.88628834180282382859683565357045e-03
 	 8.69853922593129991192029137891950e-01 4.06676027461119193873173571773805e-02 8.94784746607580894206535049306694e-02 5.88628834180282382859683565357045e-03
 	 8.94784746607580894206535049306694e-02 8.69853922593129991192029137891950e-01 4.06676027461119193873173571773805e-02 5.88628834180282382859683565357045e-03
 	 8.94784746607580894206535049306694e-02 4.06676027461119193873173571773805e-02 8.69853922593129991192029137891950e-01 5.88628834180282382859683565357045e-03
 	 4.06676027461119193873173571773805e-02 8.69853922593129991192029137891950e-01 8.94784746607580894206535049306694e-02 5.88628834180282382859683565357045e-03
 	 4.06676027461119193873173571773805e-02 8.94784746607580894206535049306694e-02 8.69853922593129991192029137891950e-01 5.88628834180282382859683565357045e-03
 	 7.92000836049181700104782066773623e-01 1.64479570130591612464598938458948e-01 4.35195938202266874306189947674284e-02 8.24419693056321727098190166316272e-03
 	 7.92000836049181700104782066773623e-01 4.35195938202266874306189947674284e-02 1.64479570130591612464598938458948e-01 8.24419693056321727098190166316272e-03
 	 1.64479570130591612464598938458948e-01 7.92000836049181700104782066773623e-01 4.35195938202266874306189947674284e-02 8.24419693056321727098190166316272e-03
 	 1.64479570130591612464598938458948e-01 4.35195938202266874306189947674284e-02 7.92000836049181700104782066773623e-01 8.24419693056321727098190166316272e-03
 	 4.35195938202266874306189947674284e-02 7.92000836049181700104782066773623e-01 1.64479570130591612464598938458948e-01 8.24419693056321727098190166316272e-03
 	 4.35195938202266874306189947674284e-02 1.64479570130591612464598938458948e-01 7.92000836049181700104782066773623e-01 8.24419693056321727098190166316272e-03
 	 6.98032087133780287935280739475274e-01 2.57896711320237226328089263915899e-01 4.40712015459824857366299966088263e-02 9.92585710656750629110600669946507e-03
 	 6.98032087133780287935280739475274e-01 4.40712015459824857366299966088263e-02 2.57896711320237226328089263915899e-01 9.92585710656750629110600669946507e-03
 	 2.57896711320237226328089263915899e-01 6.98032087133780287935280739475274e-01 4.40712015459824857366299966088263e-02 9.92585710656750629110600669946507e-03
 	 2.57896711320237226328089263915899e-01 4.40712015459824857366299966088263e-02 6.98032087133780287935280739475274e-01 9.92585710656750629110600669946507e-03
 	 4.40712015459824857366299966088263e-02 6.98032087133780287935280739475274e-01 2.57896711320237226328089263915899e-01 9.92585710656750629110600669946507e-03
 	 4.40712015459824857366299966088263e-02 2.57896711320237226328089263915899e-01 6.98032087133780287935280739475274e-01 9.92585710656750629110600669946507e-03
 	 5.90921636898512403490713040810078e-01 3.64207294093872813167678259560489e-01 4.48710690076147833416086996294325e-02 1.11149932478945522029700754274018e-02
 	 5.90921636898512403490713040810078e-01 4.48710690076147833416086996294325e-02 3.64207294093872813167678259560489e-01 1.11149932478945522029700754274018e-02
 	 3.64207294093872813167678259560489e-01 5.90921636898512403490713040810078e-01 4.48710690076147833416086996294325e-02 1.11149932478945522029700754274018e-02
 	 3.64207294093872813167678259560489e-01 4.48710690076147833416086996294325e-02 5.90921636898512403490713040810078e-01 1.11149932478945522029700754274018e-02
 	 4.48710690076147833416086996294325e-02 5.90921636898512403490713040810078e-01 3.64207294093872813167678259560489e-01 1.11149932478945522029700754274018e-02
 	 4.48710690076147833416086996294325e-02 3.64207294093872813167678259560489e-01 5.90921636898512403490713040810078e-01 1.11149932478945522029700754274018e-02
 	 7.13756998577424806029512183158658e-01 1.81577875343950506659140842202760e-01 1.04665126078624687311346974638582e-01 1.31075965603980413437534835452425e-02
 	 7.13756998577424806029512183158658e-01 1.04665126078624687311346974638582e-01 1.81577875343950506659140842202760e-01 1.31075965603980413437534835452425e-02
 	 1.81577875343950506659140842202760e-01 7.13756998577424806029512183158658e-01 1.04665126078624687311346974638582e-01 1.31075965603980413437534835452425e-02
 	 1.81577875343950506659140842202760e-01 1.04665126078624687311346974638582e-01 7.13756998577424806029512183158658e-01 1.31075965603980413437534835452425e-02
 	 1.04665126078624687311346974638582e-01 7.13756998577424806029512183158658e-01 1.81577875343950506659140842202760e-01 1.31075965603980413437534835452425e-02
 	 1.04665126078624687311346974638582e-01 1.81577875343950506659140842202760e-01 7.13756998577424806029512183158658e-01 1.31075965603980413437534835452425e-02
 	 6.14456089155397067180786052631447e-01 2.79145603763538918684616874088533e-01 1.06398307081064014134597073280020e-01 1.55304540973441179696479252925201e-02
 	 6.14456089155397067180786052631447e-01 1.06398307081064014134597073280020e-01 2.79145603763538918684616874088533e-01 1.55304540973441179696479252925201e-02
 	 2.79145603763538918684616874088533e-01 6.14456089155397067180786052631447e-01 1.06398307081064014134597073280020e-01 1.55304540973441179696479252925201e-02
 	 2.79145603763538918684616874088533e-01 1.06398307081064014134597073280020e-01 6.14456089155397067180786052631447e-01 1.55304540973441179696479252925201e-02
 	 1.06398307081064014134597073280020e-01 6.14456089155397067180786052631447e-01 2.79145603763538918684616874088533e-01 1.55304540973441179696479252925201e-02
 	 1.06398307081064014134597073280020e-01 2.79145603763538918684616874088533e-01 6.14456089155397067180786052631447e-01 1.55304540973441179696479252925201e-02
 	 5.03163853150140005787704922113335e-01 3.88410709745712179330467961335671e-01 1.08425437104147814881827116550994e-01 1.71351941586545784834694217124706e-02
 	 5.03163853150140005787704922113335e-01 1.08425437104147814881827116550994e-01 3.88410709745712179330467961335671e-01 1.71351941586545784834694217124706e-02
 	 3.88410709745712179330467961335671e-01 5.03163853150140005787704922113335e-01 1.08425437104147814881827116550994e-01 1.71351941586545784834694217124706e-02
 	 3.88410709745712179330467961335671e-01 1.08425437104147814881827116550994e-01 5.03163853150140005787704922113335e-01 1.71351941586545784834694217124706e-02
 	 1.08425437104147814881827116550994e-01 5.03163853150140005787704922113335e-01 3.88410709745712179330467961335671e-01 1.71351941586545784834694217124706e-02
 	 1.08425437104147814881827116550994e-01 3.88410709745712179330467961335671e-01 5.03163853150140005787704922113335e-01 1.71351941586545784834694217124706e-02
 	 5.18446604434296465235831874451833e-01 2.89296348423922711212696867733030e-01 1.92257047141780823551471257815138e-01 2.08155278830870656137097540749892e-02
 	 5.18446604434296465235831874451833e-01 1.92257047141780823551471257815138e-01 2.89296348423922711212696867733030e-01 2.08155278830870656137097540749892e-02
 	 2.89296348423922711212696867733030e-01 5.18446604434296465235831874451833e-01 1.92257047141780823551471257815138e-01 2.08155278830870656137097540749892e-02
 	 2.89296348423922711212696867733030e-01 1.92257047141780823551471257815138e-01 5.18446604434296465235831874451833e-01 2.08155278830870656137097540749892e-02
 	 1.92257047141780823551471257815138e-01 5.18446604434296465235831874451833e-01 2.89296348423922711212696867733030e-01 2.08155278830870656137097540749892e-02
 	 1.92257047141780823551471257815138e-01 2.89296348423922711212696867733030e-01 5.18446604434296465235831874451833e-01 2.08155278830870656137097540749892e-02
 	 ];
 
 	 case  24 

 	 % ALG. DEG.:   24
 	 % PTS CARD.:  120
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.0e-14  

 	 xyw_bar=[
 	 4.68044773847087203222372409072705e-03 4.68044773847087203222372409072705e-03 9.90639104523058255935552551818546e-01 3.37914317672483944035577430042849e-04
 	 4.68044773847087203222372409072705e-03 9.90639104523058255935552551818546e-01 4.68044773847087203222372409072705e-03 3.37914317672483944035577430042849e-04
 	 9.90639104523058255935552551818546e-01 4.68044773847087203222372409072705e-03 4.68044773847087203222372409072705e-03 3.37914317672483944035577430042849e-04
 	 3.58515749284044130118509485782852e-02 3.58515749284044130118509485782852e-02 9.28296850143191187854085910657886e-01 2.42500884253108242583074627418682e-03
 	 3.58515749284044130118509485782852e-02 9.28296850143191187854085910657886e-01 3.58515749284044130118509485782852e-02 2.42500884253108242583074627418682e-03
 	 9.28296850143191187854085910657886e-01 3.58515749284044130118509485782852e-02 3.58515749284044130118509485782852e-02 2.42500884253108242583074627418682e-03
 	 4.96163793331063474045805605783244e-01 4.96163793331063474045805605783244e-01 7.67241333787305190838878843351267e-03 4.16222957208837833487091728557061e-03
 	 4.96163793331063474045805605783244e-01 7.67241333787305190838878843351267e-03 4.96163793331063474045805605783244e-01 4.16222957208837833487091728557061e-03
 	 7.67241333787305190838878843351267e-03 4.96163793331063474045805605783244e-01 4.96163793331063474045805605783244e-01 4.16222957208837833487091728557061e-03
 	 8.10973021217386014214412170986179e-02 8.10973021217386014214412170986179e-02 8.37805395756522797157117565802764e-01 7.82875635292408326992852352077534e-03
 	 8.10973021217386014214412170986179e-02 8.37805395756522797157117565802764e-01 8.10973021217386014214412170986179e-02 7.82875635292408326992852352077534e-03
 	 8.37805395756522797157117565802764e-01 8.10973021217386014214412170986179e-02 8.10973021217386014214412170986179e-02 7.82875635292408326992852352077534e-03
 	 1.67282792916418010520374082261696e-01 1.67282792916418010520374082261696e-01 6.65434414167163978959251835476607e-01 1.36181651858832009766020476604353e-02
 	 1.67282792916418010520374082261696e-01 6.65434414167163978959251835476607e-01 1.67282792916418010520374082261696e-01 1.36181651858832009766020476604353e-02
 	 6.65434414167163978959251835476607e-01 1.67282792916418010520374082261696e-01 1.67282792916418010520374082261696e-01 1.36181651858832009766020476604353e-02
 	 4.51971022222129481527019834175007e-01 4.51971022222129481527019834175007e-01 9.60579555557410369459603316499852e-02 1.45966383712733405175754342053551e-02
 	 4.51971022222129481527019834175007e-01 9.60579555557410369459603316499852e-02 4.51971022222129481527019834175007e-01 1.45966383712733405175754342053551e-02
 	 9.60579555557410369459603316499852e-02 4.51971022222129481527019834175007e-01 4.51971022222129481527019834175007e-01 1.45966383712733405175754342053551e-02
 	 2.62525142845060011076441242039436e-01 2.62525142845060011076441242039436e-01 4.74949714309879977847117515921127e-01 2.00618272483957006679933243731284e-02
 	 2.62525142845060011076441242039436e-01 4.74949714309879977847117515921127e-01 2.62525142845060011076441242039436e-01 2.00618272483957006679933243731284e-02
 	 4.74949714309879977847117515921127e-01 2.62525142845060011076441242039436e-01 2.62525142845060011076441242039436e-01 2.00618272483957006679933243731284e-02
 	 3.67318860036334404739477577095386e-01 3.67318860036334404739477577095386e-01 2.65362279927331190521044845809229e-01 2.13423746045390202996649975375476e-02
 	 3.67318860036334404739477577095386e-01 2.65362279927331190521044845809229e-01 3.67318860036334404739477577095386e-01 2.13423746045390202996649975375476e-02
 	 2.65362279927331190521044845809229e-01 3.67318860036334404739477577095386e-01 3.67318860036334404739477577095386e-01 2.13423746045390202996649975375476e-02
 	 9.23455229698260882109650538041024e-01 7.19187624498160982255967610399239e-02 4.62600785192301966475270091905259e-03 1.26054005455738041274749150488788e-03
 	 9.23455229698260882109650538041024e-01 4.62600785192301966475270091905259e-03 7.19187624498160982255967610399239e-02 1.26054005455738041274749150488788e-03
 	 7.19187624498160982255967610399239e-02 9.23455229698260882109650538041024e-01 4.62600785192301966475270091905259e-03 1.26054005455738041274749150488788e-03
 	 7.19187624498160982255967610399239e-02 4.62600785192301966475270091905259e-03 9.23455229698260882109650538041024e-01 1.26054005455738041274749150488788e-03
 	 4.62600785192301966475270091905259e-03 9.23455229698260882109650538041024e-01 7.19187624498160982255967610399239e-02 1.26054005455738041274749150488788e-03
 	 4.62600785192301966475270091905259e-03 7.19187624498160982255967610399239e-02 9.23455229698260882109650538041024e-01 1.26054005455738041274749150488788e-03
 	 9.63258241935612047335268925962737e-01 2.93101710973713291963349547586404e-02 7.43158696701662346839611927862279e-03 1.30769133371004282057059597832449e-03
 	 9.63258241935612047335268925962737e-01 7.43158696701662346839611927862279e-03 2.93101710973713291963349547586404e-02 1.30769133371004282057059597832449e-03
 	 2.93101710973713291963349547586404e-02 9.63258241935612047335268925962737e-01 7.43158696701662346839611927862279e-03 1.30769133371004282057059597832449e-03
 	 2.93101710973713291963349547586404e-02 7.43158696701662346839611927862279e-03 9.63258241935612047335268925962737e-01 1.30769133371004282057059597832449e-03
 	 7.43158696701662346839611927862279e-03 9.63258241935612047335268925962737e-01 2.93101710973713291963349547586404e-02 1.30769133371004282057059597832449e-03
 	 7.43158696701662346839611927862279e-03 2.93101710973713291963349547586404e-02 9.63258241935612047335268925962737e-01 1.30769133371004282057059597832449e-03
 	 8.65062183147062846444441674975678e-01 1.27671748918951111217978677814244e-01 7.26606793398604233757964721007738e-03 2.32188188789948009999042355389065e-03
 	 8.65062183147062846444441674975678e-01 7.26606793398604233757964721007738e-03 1.27671748918951111217978677814244e-01 2.32188188789948009999042355389065e-03
 	 1.27671748918951111217978677814244e-01 8.65062183147062846444441674975678e-01 7.26606793398604233757964721007738e-03 2.32188188789948009999042355389065e-03
 	 1.27671748918951111217978677814244e-01 7.26606793398604233757964721007738e-03 8.65062183147062846444441674975678e-01 2.32188188789948009999042355389065e-03
 	 7.26606793398604233757964721007738e-03 8.65062183147062846444441674975678e-01 1.27671748918951111217978677814244e-01 2.32188188789948009999042355389065e-03
 	 7.26606793398604233757964721007738e-03 1.27671748918951111217978677814244e-01 8.65062183147062846444441674975678e-01 2.32188188789948009999042355389065e-03
 	 7.93149355629101493470045625144849e-01 1.99376854580637002944953906080627e-01 7.47378979026150358500046877452405e-03 3.11613040428298203321499926232718e-03
 	 7.93149355629101493470045625144849e-01 7.47378979026150358500046877452405e-03 1.99376854580637002944953906080627e-01 3.11613040428298203321499926232718e-03
 	 1.99376854580637002944953906080627e-01 7.93149355629101493470045625144849e-01 7.47378979026150358500046877452405e-03 3.11613040428298203321499926232718e-03
 	 1.99376854580637002944953906080627e-01 7.47378979026150358500046877452405e-03 7.93149355629101493470045625144849e-01 3.11613040428298203321499926232718e-03
 	 7.47378979026150358500046877452405e-03 7.93149355629101493470045625144849e-01 1.99376854580637002944953906080627e-01 3.11613040428298203321499926232718e-03
 	 7.47378979026150358500046877452405e-03 1.99376854580637002944953906080627e-01 7.93149355629101493470045625144849e-01 3.11613040428298203321499926232718e-03
 	 7.03167527087424915066549147013575e-01 2.89355487561616608882530954360845e-01 7.47698535095847605091989862557966e-03 3.71782953244760225319787139142136e-03
 	 7.03167527087424915066549147013575e-01 7.47698535095847605091989862557966e-03 2.89355487561616608882530954360845e-01 3.71782953244760225319787139142136e-03
 	 2.89355487561616608882530954360845e-01 7.03167527087424915066549147013575e-01 7.47698535095847605091989862557966e-03 3.71782953244760225319787139142136e-03
 	 2.89355487561616608882530954360845e-01 7.47698535095847605091989862557966e-03 7.03167527087424915066549147013575e-01 3.71782953244760225319787139142136e-03
 	 7.47698535095847605091989862557966e-03 7.03167527087424915066549147013575e-01 2.89355487561616608882530954360845e-01 3.71782953244760225319787139142136e-03
 	 7.47698535095847605091989862557966e-03 2.89355487561616608882530954360845e-01 7.03167527087424915066549147013575e-01 3.71782953244760225319787139142136e-03
 	 8.94987050429267849693815151113085e-01 7.57231791336101522915669193025678e-02 2.92897704371219980146179295843467e-02 3.79678202290735945095834225071485e-03
 	 8.94987050429267849693815151113085e-01 2.92897704371219980146179295843467e-02 7.57231791336101522915669193025678e-02 3.79678202290735945095834225071485e-03
 	 7.57231791336101522915669193025678e-02 8.94987050429267849693815151113085e-01 2.92897704371219980146179295843467e-02 3.79678202290735945095834225071485e-03
 	 7.57231791336101522915669193025678e-02 2.92897704371219980146179295843467e-02 8.94987050429267849693815151113085e-01 3.79678202290735945095834225071485e-03
 	 2.92897704371219980146179295843467e-02 8.94987050429267849693815151113085e-01 7.57231791336101522915669193025678e-02 3.79678202290735945095834225071485e-03
 	 2.92897704371219980146179295843467e-02 7.57231791336101522915669193025678e-02 8.94987050429267849693815151113085e-01 3.79678202290735945095834225071485e-03
 	 6.01693105035377984179945087817032e-01 3.90708026101555416786936802964192e-01 7.59886886306659903311810921877623e-03 4.05968654765331490863466967766726e-03
 	 6.01693105035377984179945087817032e-01 7.59886886306659903311810921877623e-03 3.90708026101555416786936802964192e-01 4.05968654765331490863466967766726e-03
 	 3.90708026101555416786936802964192e-01 6.01693105035377984179945087817032e-01 7.59886886306659903311810921877623e-03 4.05968654765331490863466967766726e-03
 	 3.90708026101555416786936802964192e-01 7.59886886306659903311810921877623e-03 6.01693105035377984179945087817032e-01 4.05968654765331490863466967766726e-03
 	 7.59886886306659903311810921877623e-03 6.01693105035377984179945087817032e-01 3.90708026101555416786936802964192e-01 4.05968654765331490863466967766726e-03
 	 7.59886886306659903311810921877623e-03 3.90708026101555416786936802964192e-01 6.01693105035377984179945087817032e-01 4.05968654765331490863466967766726e-03
 	 8.22015697438525094753458688501269e-01 1.39604852336156298742153580860759e-01 3.83794502253186065043877306379727e-02 6.42042675808828389866222963178188e-03
 	 8.22015697438525094753458688501269e-01 3.83794502253186065043877306379727e-02 1.39604852336156298742153580860759e-01 6.42042675808828389866222963178188e-03
 	 1.39604852336156298742153580860759e-01 8.22015697438525094753458688501269e-01 3.83794502253186065043877306379727e-02 6.42042675808828389866222963178188e-03
 	 1.39604852336156298742153580860759e-01 3.83794502253186065043877306379727e-02 8.22015697438525094753458688501269e-01 6.42042675808828389866222963178188e-03
 	 3.83794502253186065043877306379727e-02 8.22015697438525094753458688501269e-01 1.39604852336156298742153580860759e-01 6.42042675808828389866222963178188e-03
 	 3.83794502253186065043877306379727e-02 1.39604852336156298742153580860759e-01 8.22015697438525094753458688501269e-01 6.42042675808828389866222963178188e-03
 	 7.37522761587901753976836971560260e-01 2.23633835367293809515132352316868e-01 3.88434030448044365080306761228712e-02 7.98338599534560017234596784874157e-03
 	 7.37522761587901753976836971560260e-01 3.88434030448044365080306761228712e-02 2.23633835367293809515132352316868e-01 7.98338599534560017234596784874157e-03
 	 2.23633835367293809515132352316868e-01 7.37522761587901753976836971560260e-01 3.88434030448044365080306761228712e-02 7.98338599534560017234596784874157e-03
 	 2.23633835367293809515132352316868e-01 3.88434030448044365080306761228712e-02 7.37522761587901753976836971560260e-01 7.98338599534560017234596784874157e-03
 	 3.88434030448044365080306761228712e-02 7.37522761587901753976836971560260e-01 2.23633835367293809515132352316868e-01 7.98338599534560017234596784874157e-03
 	 3.88434030448044365080306761228712e-02 2.23633835367293809515132352316868e-01 7.37522761587901753976836971560260e-01 7.98338599534560017234596784874157e-03
 	 6.39399415339909515942906637064880e-01 3.21417139704213317141778816221631e-01 3.91834449558771669153145467134891e-02 8.99182029931192526583938473550006e-03
 	 6.39399415339909515942906637064880e-01 3.91834449558771669153145467134891e-02 3.21417139704213317141778816221631e-01 8.99182029931192526583938473550006e-03
 	 3.21417139704213317141778816221631e-01 6.39399415339909515942906637064880e-01 3.91834449558771669153145467134891e-02 8.99182029931192526583938473550006e-03
 	 3.21417139704213317141778816221631e-01 3.91834449558771669153145467134891e-02 6.39399415339909515942906637064880e-01 8.99182029931192526583938473550006e-03
 	 3.91834449558771669153145467134891e-02 6.39399415339909515942906637064880e-01 3.21417139704213317141778816221631e-01 8.99182029931192526583938473550006e-03
 	 3.91834449558771669153145467134891e-02 3.21417139704213317141778816221631e-01 6.39399415339909515942906637064880e-01 8.99182029931192526583938473550006e-03
 	 5.33728924897748924216500654438278e-01 4.26438949417778212502838641739800e-01 3.98321256844728632806607038219227e-02 9.52049141729482094331782349172499e-03
 	 5.33728924897748924216500654438278e-01 3.98321256844728632806607038219227e-02 4.26438949417778212502838641739800e-01 9.52049141729482094331782349172499e-03
 	 4.26438949417778212502838641739800e-01 5.33728924897748924216500654438278e-01 3.98321256844728632806607038219227e-02 9.52049141729482094331782349172499e-03
 	 4.26438949417778212502838641739800e-01 3.98321256844728632806607038219227e-02 5.33728924897748924216500654438278e-01 9.52049141729482094331782349172499e-03
 	 3.98321256844728632806607038219227e-02 5.33728924897748924216500654438278e-01 4.26438949417778212502838641739800e-01 9.52049141729482094331782349172499e-03
 	 3.98321256844728632806607038219227e-02 4.26438949417778212502838641739800e-01 5.33728924897748924216500654438278e-01 9.52049141729482094331782349172499e-03
 	 7.52006738431799326427551477536326e-01 1.55247740375081599850659586081747e-01 9.27455211931190737217889363819268e-02 1.06091068170761724381856438981231e-02
 	 7.52006738431799326427551477536326e-01 9.27455211931190737217889363819268e-02 1.55247740375081599850659586081747e-01 1.06091068170761724381856438981231e-02
 	 1.55247740375081599850659586081747e-01 7.52006738431799326427551477536326e-01 9.27455211931190737217889363819268e-02 1.06091068170761724381856438981231e-02
 	 1.55247740375081599850659586081747e-01 9.27455211931190737217889363819268e-02 7.52006738431799326427551477536326e-01 1.06091068170761724381856438981231e-02
 	 9.27455211931190737217889363819268e-02 7.52006738431799326427551477536326e-01 1.55247740375081599850659586081747e-01 1.06091068170761724381856438981231e-02
 	 9.27455211931190737217889363819268e-02 1.55247740375081599850659586081747e-01 7.52006738431799326427551477536326e-01 1.06091068170761724381856438981231e-02
 	 6.62157408951895787296848538971972e-01 2.44250018940709912040887274997658e-01 9.35925721073943006622641860303702e-02 1.25098769072566930182777156232987e-02
 	 6.62157408951895787296848538971972e-01 9.35925721073943006622641860303702e-02 2.44250018940709912040887274997658e-01 1.25098769072566930182777156232987e-02
 	 2.44250018940709912040887274997658e-01 6.62157408951895787296848538971972e-01 9.35925721073943006622641860303702e-02 1.25098769072566930182777156232987e-02
 	 2.44250018940709912040887274997658e-01 9.35925721073943006622641860303702e-02 6.62157408951895787296848538971972e-01 1.25098769072566930182777156232987e-02
 	 9.35925721073943006622641860303702e-02 6.62157408951895787296848538971972e-01 2.44250018940709912040887274997658e-01 1.25098769072566930182777156232987e-02
 	 9.35925721073943006622641860303702e-02 2.44250018940709912040887274997658e-01 6.62157408951895787296848538971972e-01 1.25098769072566930182777156232987e-02
 	 5.60254721210861617031184778170427e-01 3.44727467648918317610906569825602e-01 9.50178111402200653579086520039709e-02 1.40002051992718645756497153342934e-02
 	 5.60254721210861617031184778170427e-01 9.50178111402200653579086520039709e-02 3.44727467648918317610906569825602e-01 1.40002051992718645756497153342934e-02
 	 3.44727467648918317610906569825602e-01 5.60254721210861617031184778170427e-01 9.50178111402200653579086520039709e-02 1.40002051992718645756497153342934e-02
 	 3.44727467648918317610906569825602e-01 9.50178111402200653579086520039709e-02 5.60254721210861617031184778170427e-01 1.40002051992718645756497153342934e-02
 	 9.50178111402200653579086520039709e-02 5.60254721210861617031184778170427e-01 3.44727467648918317610906569825602e-01 1.40002051992718645756497153342934e-02
 	 9.50178111402200653579086520039709e-02 3.44727467648918317610906569825602e-01 5.60254721210861617031184778170427e-01 1.40002051992718645756497153342934e-02
 	 5.73642212535123152683524949679850e-01 2.57088626651901686059886742441449e-01 1.69269160812975161256588307878701e-01 1.64576033663149864927355281452037e-02
 	 5.73642212535123152683524949679850e-01 1.69269160812975161256588307878701e-01 2.57088626651901686059886742441449e-01 1.64576033663149864927355281452037e-02
 	 2.57088626651901686059886742441449e-01 5.73642212535123152683524949679850e-01 1.69269160812975161256588307878701e-01 1.64576033663149864927355281452037e-02
 	 2.57088626651901686059886742441449e-01 1.69269160812975161256588307878701e-01 5.73642212535123152683524949679850e-01 1.64576033663149864927355281452037e-02
 	 1.69269160812975161256588307878701e-01 5.73642212535123152683524949679850e-01 2.57088626651901686059886742441449e-01 1.64576033663149864927355281452037e-02
 	 1.69269160812975161256588307878701e-01 2.57088626651901686059886742441449e-01 5.73642212535123152683524949679850e-01 1.64576033663149864927355281452037e-02
 	 4.68278059755923625750995142880129e-01 3.59525370113814912720329175499501e-01 1.72196570130261461528675681620371e-01 1.84067508755945269394160845877195e-02
 	 4.68278059755923625750995142880129e-01 1.72196570130261461528675681620371e-01 3.59525370113814912720329175499501e-01 1.84067508755945269394160845877195e-02
 	 3.59525370113814912720329175499501e-01 4.68278059755923625750995142880129e-01 1.72196570130261461528675681620371e-01 1.84067508755945269394160845877195e-02
 	 3.59525370113814912720329175499501e-01 1.72196570130261461528675681620371e-01 4.68278059755923625750995142880129e-01 1.84067508755945269394160845877195e-02
 	 1.72196570130261461528675681620371e-01 4.68278059755923625750995142880129e-01 3.59525370113814912720329175499501e-01 1.84067508755945269394160845877195e-02
 	 1.72196570130261461528675681620371e-01 3.59525370113814912720329175499501e-01 4.68278059755923625750995142880129e-01 1.84067508755945269394160845877195e-02
 	 ];
 
 	 case  25 

 	 % ALG. DEG.:   25
 	 % PTS CARD.:  136
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.1e-14  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.91335092595679157057020347565413e-02
 	 5.71433885823602327747039453242905e-03 5.71433885823602327747039453242905e-03 9.88571322283527953445059210935142e-01 4.03376930733739911139751344038018e-04
 	 5.71433885823602327747039453242905e-03 9.88571322283527953445059210935142e-01 5.71433885823602327747039453242905e-03 4.03376930733739911139751344038018e-04
 	 9.88571322283527953445059210935142e-01 5.71433885823602327747039453242905e-03 5.71433885823602327747039453242905e-03 4.03376930733739911139751344038018e-04
 	 2.72494286004120213340318201744594e-02 2.72494286004120213340318201744594e-02 9.45501142799175964270830263558310e-01 2.04894605750166559562930324034369e-03
 	 2.72494286004120213340318201744594e-02 9.45501142799175964270830263558310e-01 2.72494286004120213340318201744594e-02 2.04894605750166559562930324034369e-03
 	 9.45501142799175964270830263558310e-01 2.72494286004120213340318201744594e-02 2.72494286004120213340318201744594e-02 2.04894605750166559562930324034369e-03
 	 7.66556657710376621039927158562932e-02 7.66556657710376621039927158562932e-02 8.46688668457924675792014568287414e-01 6.05556013297100549641616140661426e-03
 	 7.66556657710376621039927158562932e-02 8.46688668457924675792014568287414e-01 7.66556657710376621039927158562932e-02 6.05556013297100549641616140661426e-03
 	 8.46688668457924675792014568287414e-01 7.66556657710376621039927158562932e-02 7.66556657710376621039927158562932e-02 6.05556013297100549641616140661426e-03
 	 4.82135684364817795888313867180841e-01 4.82135684364817795888313867180841e-01 3.57286312703644082233722656383179e-02 7.72624379420824587000327099417518e-03
 	 4.82135684364817795888313867180841e-01 3.57286312703644082233722656383179e-02 4.82135684364817795888313867180841e-01 7.72624379420824587000327099417518e-03
 	 3.57286312703644082233722656383179e-02 4.82135684364817795888313867180841e-01 4.82135684364817795888313867180841e-01 7.72624379420824587000327099417518e-03
 	 1.49523257795368291755977452339721e-01 1.49523257795368291755977452339721e-01 7.00953484409263416488045095320558e-01 1.11579277905627435169000349901580e-02
 	 1.49523257795368291755977452339721e-01 7.00953484409263416488045095320558e-01 1.49523257795368291755977452339721e-01 1.11579277905627435169000349901580e-02
 	 7.00953484409263416488045095320558e-01 1.49523257795368291755977452339721e-01 1.49523257795368291755977452339721e-01 1.11579277905627435169000349901580e-02
 	 4.22530364706222016923931050769170e-01 4.22530364706222016923931050769170e-01 1.54939270587555966152137898461660e-01 1.56405465194086046309962512168568e-02
 	 4.22530364706222016923931050769170e-01 1.54939270587555966152137898461660e-01 4.22530364706222016923931050769170e-01 1.56405465194086046309962512168568e-02
 	 1.54939270587555966152137898461660e-01 4.22530364706222016923931050769170e-01 4.22530364706222016923931050769170e-01 1.56405465194086046309962512168568e-02
 	 2.35017663942217097661213642822986e-01 2.35017663942217097661213642822986e-01 5.29964672115565749166421483096201e-01 1.62235276308908236975181438310756e-02
 	 2.35017663942217097661213642822986e-01 5.29964672115565749166421483096201e-01 2.35017663942217097661213642822986e-01 1.62235276308908236975181438310756e-02
 	 5.29964672115565749166421483096201e-01 2.35017663942217097661213642822986e-01 2.35017663942217097661213642822986e-01 1.62235276308908236975181438310756e-02
 	 9.68738481181608435122143418993801e-01 2.64387673203308991298765562305562e-02 4.82275149806066574798002477564296e-03 6.55986048218140964036204643150541e-04
 	 9.68738481181608435122143418993801e-01 4.82275149806066574798002477564296e-03 2.64387673203308991298765562305562e-02 6.55986048218140964036204643150541e-04
 	 2.64387673203308991298765562305562e-02 9.68738481181608435122143418993801e-01 4.82275149806066574798002477564296e-03 6.55986048218140964036204643150541e-04
 	 2.64387673203308991298765562305562e-02 4.82275149806066574798002477564296e-03 9.68738481181608435122143418993801e-01 6.55986048218140964036204643150541e-04
 	 4.82275149806066574798002477564296e-03 9.68738481181608435122143418993801e-01 2.64387673203308991298765562305562e-02 6.55986048218140964036204643150541e-04
 	 4.82275149806066574798002477564296e-03 2.64387673203308991298765562305562e-02 9.68738481181608435122143418993801e-01 6.55986048218140964036204643150541e-04
 	 9.35914465591766275842644517979352e-01 5.82420655518003371753366081975400e-02 5.84346885643338698201887382310815e-03 1.18175318106912086504878267589902e-03
 	 9.35914465591766275842644517979352e-01 5.84346885643338698201887382310815e-03 5.82420655518003371753366081975400e-02 1.18175318106912086504878267589902e-03
 	 5.82420655518003371753366081975400e-02 9.35914465591766275842644517979352e-01 5.84346885643338698201887382310815e-03 1.18175318106912086504878267589902e-03
 	 5.82420655518003371753366081975400e-02 5.84346885643338698201887382310815e-03 9.35914465591766275842644517979352e-01 1.18175318106912086504878267589902e-03
 	 5.84346885643338698201887382310815e-03 9.35914465591766275842644517979352e-01 5.82420655518003371753366081975400e-02 1.18175318106912086504878267589902e-03
 	 5.84346885643338698201887382310815e-03 5.82420655518003371753366081975400e-02 9.35914465591766275842644517979352e-01 1.18175318106912086504878267589902e-03
 	 8.85737420571854561224256485729711e-01 1.07957673880294896529008497054747e-01 6.30490554785054224673501721554203e-03 1.93167760124459114007278159874659e-03
 	 8.85737420571854561224256485729711e-01 6.30490554785054224673501721554203e-03 1.07957673880294896529008497054747e-01 1.93167760124459114007278159874659e-03
 	 1.07957673880294896529008497054747e-01 8.85737420571854561224256485729711e-01 6.30490554785054224673501721554203e-03 1.93167760124459114007278159874659e-03
 	 1.07957673880294896529008497054747e-01 6.30490554785054224673501721554203e-03 8.85737420571854561224256485729711e-01 1.93167760124459114007278159874659e-03
 	 6.30490554785054224673501721554203e-03 8.85737420571854561224256485729711e-01 1.07957673880294896529008497054747e-01 1.93167760124459114007278159874659e-03
 	 6.30490554785054224673501721554203e-03 1.07957673880294896529008497054747e-01 8.85737420571854561224256485729711e-01 1.93167760124459114007278159874659e-03
 	 8.16939712186552924322313629090786e-01 1.76404098155251293222889330536418e-01 6.65618965819578245479704037279589e-03 2.60257074853619896695477997639045e-03
 	 8.16939712186552924322313629090786e-01 6.65618965819578245479704037279589e-03 1.76404098155251293222889330536418e-01 2.60257074853619896695477997639045e-03
 	 1.76404098155251293222889330536418e-01 8.16939712186552924322313629090786e-01 6.65618965819578245479704037279589e-03 2.60257074853619896695477997639045e-03
 	 1.76404098155251293222889330536418e-01 6.65618965819578245479704037279589e-03 8.16939712186552924322313629090786e-01 2.60257074853619896695477997639045e-03
 	 6.65618965819578245479704037279589e-03 8.16939712186552924322313629090786e-01 1.76404098155251293222889330536418e-01 2.60257074853619896695477997639045e-03
 	 6.65618965819578245479704037279589e-03 1.76404098155251293222889330536418e-01 8.16939712186552924322313629090786e-01 2.60257074853619896695477997639045e-03
 	 7.34078265782887817714197353780037e-01 2.59206444374597722024589074862888e-01 6.71528984251446026121357135707512e-03 3.03986398041138951298112402810148e-03
 	 7.34078265782887817714197353780037e-01 6.71528984251446026121357135707512e-03 2.59206444374597722024589074862888e-01 3.03986398041138951298112402810148e-03
 	 2.59206444374597722024589074862888e-01 7.34078265782887817714197353780037e-01 6.71528984251446026121357135707512e-03 3.03986398041138951298112402810148e-03
 	 2.59206444374597722024589074862888e-01 6.71528984251446026121357135707512e-03 7.34078265782887817714197353780037e-01 3.03986398041138951298112402810148e-03
 	 6.71528984251446026121357135707512e-03 7.34078265782887817714197353780037e-01 2.59206444374597722024589074862888e-01 3.03986398041138951298112402810148e-03
 	 6.71528984251446026121357135707512e-03 2.59206444374597722024589074862888e-01 7.34078265782887817714197353780037e-01 3.03986398041138951298112402810148e-03
 	 6.41753644337056394775231638050172e-01 3.51505881363440519926655269955518e-01 6.74047429950308529811309199430980e-03 3.28693081105045203232917216951137e-03
 	 6.41753644337056394775231638050172e-01 6.74047429950308529811309199430980e-03 3.51505881363440519926655269955518e-01 3.28693081105045203232917216951137e-03
 	 3.51505881363440519926655269955518e-01 6.41753644337056394775231638050172e-01 6.74047429950308529811309199430980e-03 3.28693081105045203232917216951137e-03
 	 3.51505881363440519926655269955518e-01 6.74047429950308529811309199430980e-03 6.41753644337056394775231638050172e-01 3.28693081105045203232917216951137e-03
 	 6.74047429950308529811309199430980e-03 6.41753644337056394775231638050172e-01 3.51505881363440519926655269955518e-01 3.28693081105045203232917216951137e-03
 	 6.74047429950308529811309199430980e-03 3.51505881363440519926655269955518e-01 6.41753644337056394775231638050172e-01 3.28693081105045203232917216951137e-03
 	 5.45201712627923384957284724805504e-01 4.47959453755785386164234296302311e-01 6.83883361629122887848097889218479e-03 3.40174363689320531645154943589660e-03
 	 5.45201712627923384957284724805504e-01 6.83883361629122887848097889218479e-03 4.47959453755785386164234296302311e-01 3.40174363689320531645154943589660e-03
 	 4.47959453755785386164234296302311e-01 5.45201712627923384957284724805504e-01 6.83883361629122887848097889218479e-03 3.40174363689320531645154943589660e-03
 	 4.47959453755785386164234296302311e-01 6.83883361629122887848097889218479e-03 5.45201712627923384957284724805504e-01 3.40174363689320531645154943589660e-03
 	 6.83883361629122887848097889218479e-03 5.45201712627923384957284724805504e-01 4.47959453755785386164234296302311e-01 3.40174363689320531645154943589660e-03
 	 6.83883361629122887848097889218479e-03 4.47959453755785386164234296302311e-01 5.45201712627923384957284724805504e-01 3.40174363689320531645154943589660e-03
 	 8.99672974696373417557992979709525e-01 6.92285554476964604120325930125546e-02 3.10984698559301220299744272779208e-02 3.59560620720547141973555405058960e-03
 	 8.99672974696373417557992979709525e-01 3.10984698559301220299744272779208e-02 6.92285554476964604120325930125546e-02 3.59560620720547141973555405058960e-03
 	 6.92285554476964604120325930125546e-02 8.99672974696373417557992979709525e-01 3.10984698559301220299744272779208e-02 3.59560620720547141973555405058960e-03
 	 6.92285554476964604120325930125546e-02 3.10984698559301220299744272779208e-02 8.99672974696373417557992979709525e-01 3.59560620720547141973555405058960e-03
 	 3.10984698559301220299744272779208e-02 8.99672974696373417557992979709525e-01 6.92285554476964604120325930125546e-02 3.59560620720547141973555405058960e-03
 	 3.10984698559301220299744272779208e-02 6.92285554476964604120325930125546e-02 8.99672974696373417557992979709525e-01 3.59560620720547141973555405058960e-03
 	 8.36754745906231556240584268380189e-01 1.29450436723384493253874438778439e-01 3.37948173703839505055412928413716e-02 5.20296994687261937090339003475492e-03
 	 8.36754745906231556240584268380189e-01 3.37948173703839505055412928413716e-02 1.29450436723384493253874438778439e-01 5.20296994687261937090339003475492e-03
 	 1.29450436723384493253874438778439e-01 8.36754745906231556240584268380189e-01 3.37948173703839505055412928413716e-02 5.20296994687261937090339003475492e-03
 	 1.29450436723384493253874438778439e-01 3.37948173703839505055412928413716e-02 8.36754745906231556240584268380189e-01 5.20296994687261937090339003475492e-03
 	 3.37948173703839505055412928413716e-02 8.36754745906231556240584268380189e-01 1.29450436723384493253874438778439e-01 5.20296994687261937090339003475492e-03
 	 3.37948173703839505055412928413716e-02 1.29450436723384493253874438778439e-01 8.36754745906231556240584268380189e-01 5.20296994687261937090339003475492e-03
 	 7.60018820808685102718982307123952e-01 2.05092818400489096397620869538514e-01 3.48883607908258008833968233375344e-02 6.39596396083765093149020586338338e-03
 	 7.60018820808685102718982307123952e-01 3.48883607908258008833968233375344e-02 2.05092818400489096397620869538514e-01 6.39596396083765093149020586338338e-03
 	 2.05092818400489096397620869538514e-01 7.60018820808685102718982307123952e-01 3.48883607908258008833968233375344e-02 6.39596396083765093149020586338338e-03
 	 2.05092818400489096397620869538514e-01 3.48883607908258008833968233375344e-02 7.60018820808685102718982307123952e-01 6.39596396083765093149020586338338e-03
 	 3.48883607908258008833968233375344e-02 7.60018820808685102718982307123952e-01 2.05092818400489096397620869538514e-01 6.39596396083765093149020586338338e-03
 	 3.48883607908258008833968233375344e-02 2.05092818400489096397620869538514e-01 7.60018820808685102718982307123952e-01 6.39596396083765093149020586338338e-03
 	 6.72878720973754451684101240971358e-01 2.92117203365807209802795796349528e-01 3.50040756604383385131029626791133e-02 7.14527129784485025981721761922927e-03
 	 6.72878720973754451684101240971358e-01 3.50040756604383385131029626791133e-02 2.92117203365807209802795796349528e-01 7.14527129784485025981721761922927e-03
 	 2.92117203365807209802795796349528e-01 6.72878720973754451684101240971358e-01 3.50040756604383385131029626791133e-02 7.14527129784485025981721761922927e-03
 	 2.92117203365807209802795796349528e-01 3.50040756604383385131029626791133e-02 6.72878720973754451684101240971358e-01 7.14527129784485025981721761922927e-03
 	 3.50040756604383385131029626791133e-02 6.72878720973754451684101240971358e-01 2.92117203365807209802795796349528e-01 7.14527129784485025981721761922927e-03
 	 3.50040756604383385131029626791133e-02 2.92117203365807209802795796349528e-01 6.72878720973754451684101240971358e-01 7.14527129784485025981721761922927e-03
 	 5.78766335729513636820797728432808e-01 3.85847444474734901920243146378198e-01 3.53862197957514612589591251889942e-02 7.58299009147876332259663456625276e-03
 	 5.78766335729513636820797728432808e-01 3.53862197957514612589591251889942e-02 3.85847444474734901920243146378198e-01 7.58299009147876332259663456625276e-03
 	 3.85847444474734901920243146378198e-01 5.78766335729513636820797728432808e-01 3.53862197957514612589591251889942e-02 7.58299009147876332259663456625276e-03
 	 3.85847444474734901920243146378198e-01 3.53862197957514612589591251889942e-02 5.78766335729513636820797728432808e-01 7.58299009147876332259663456625276e-03
 	 3.53862197957514612589591251889942e-02 5.78766335729513636820797728432808e-01 3.85847444474734901920243146378198e-01 7.58299009147876332259663456625276e-03
 	 3.53862197957514612589591251889942e-02 3.85847444474734901920243146378198e-01 5.78766335729513636820797728432808e-01 7.58299009147876332259663456625276e-03
 	 7.76386479467535695064839273982216e-01 1.41173270259469990639544789701176e-01 8.24402502729943142956159363166080e-02 8.44269504963679993936320755665292e-03
 	 7.76386479467535695064839273982216e-01 8.24402502729943142956159363166080e-02 1.41173270259469990639544789701176e-01 8.44269504963679993936320755665292e-03
 	 1.41173270259469990639544789701176e-01 7.76386479467535695064839273982216e-01 8.24402502729943142956159363166080e-02 8.44269504963679993936320755665292e-03
 	 1.41173270259469990639544789701176e-01 8.24402502729943142956159363166080e-02 7.76386479467535695064839273982216e-01 8.44269504963679993936320755665292e-03
 	 8.24402502729943142956159363166080e-02 7.76386479467535695064839273982216e-01 1.41173270259469990639544789701176e-01 8.44269504963679993936320755665292e-03
 	 8.24402502729943142956159363166080e-02 1.41173270259469990639544789701176e-01 7.76386479467535695064839273982216e-01 8.44269504963679993936320755665292e-03
 	 6.95281183841349070817727806570474e-01 2.20694701488698713509606363913917e-01 8.40241146699522156726658295156085e-02 1.00443207868063429794025509522726e-02
 	 6.95281183841349070817727806570474e-01 8.40241146699522156726658295156085e-02 2.20694701488698713509606363913917e-01 1.00443207868063429794025509522726e-02
 	 2.20694701488698713509606363913917e-01 6.95281183841349070817727806570474e-01 8.40241146699522156726658295156085e-02 1.00443207868063429794025509522726e-02
 	 2.20694701488698713509606363913917e-01 8.40241146699522156726658295156085e-02 6.95281183841349070817727806570474e-01 1.00443207868063429794025509522726e-02
 	 8.40241146699522156726658295156085e-02 6.95281183841349070817727806570474e-01 2.20694701488698713509606363913917e-01 1.00443207868063429794025509522726e-02
 	 8.40241146699522156726658295156085e-02 2.20694701488698713509606363913917e-01 6.95281183841349070817727806570474e-01 1.00443207868063429794025509522726e-02
 	 6.04556578856260240506514946901007e-01 3.10779394840667910759890446570353e-01 8.46640263030718487335946065286407e-02 1.12068990501472502685498255914354e-02
 	 6.04556578856260240506514946901007e-01 8.46640263030718487335946065286407e-02 3.10779394840667910759890446570353e-01 1.12068990501472502685498255914354e-02
 	 3.10779394840667910759890446570353e-01 6.04556578856260240506514946901007e-01 8.46640263030718487335946065286407e-02 1.12068990501472502685498255914354e-02
 	 3.10779394840667910759890446570353e-01 8.46640263030718487335946065286407e-02 6.04556578856260240506514946901007e-01 1.12068990501472502685498255914354e-02
 	 8.46640263030718487335946065286407e-02 6.04556578856260240506514946901007e-01 3.10779394840667910759890446570353e-01 1.12068990501472502685498255914354e-02
 	 8.46640263030718487335946065286407e-02 3.10779394840667910759890446570353e-01 6.04556578856260240506514946901007e-01 1.12068990501472502685498255914354e-02
 	 5.06851226677805466458437422261341e-01 4.07374461989678027240557867116877e-01 8.57743113325165063010047106217826e-02 1.18967987907206314279751069307167e-02
 	 5.06851226677805466458437422261341e-01 8.57743113325165063010047106217826e-02 4.07374461989678027240557867116877e-01 1.18967987907206314279751069307167e-02
 	 4.07374461989678027240557867116877e-01 5.06851226677805466458437422261341e-01 8.57743113325165063010047106217826e-02 1.18967987907206314279751069307167e-02
 	 4.07374461989678027240557867116877e-01 8.57743113325165063010047106217826e-02 5.06851226677805466458437422261341e-01 1.18967987907206314279751069307167e-02
 	 8.57743113325165063010047106217826e-02 5.06851226677805466458437422261341e-01 4.07374461989678027240557867116877e-01 1.18967987907206314279751069307167e-02
 	 8.57743113325165063010047106217826e-02 4.07374461989678027240557867116877e-01 5.06851226677805466458437422261341e-01 1.18967987907206314279751069307167e-02
 	 6.17605377498653074219703285052674e-01 2.30766928655943892589874621990020e-01 1.51627693845403033190422092957306e-01 1.32352995690808161732832104462432e-02
 	 6.17605377498653074219703285052674e-01 1.51627693845403033190422092957306e-01 2.30766928655943892589874621990020e-01 1.32352995690808161732832104462432e-02
 	 2.30766928655943892589874621990020e-01 6.17605377498653074219703285052674e-01 1.51627693845403033190422092957306e-01 1.32352995690808161732832104462432e-02
 	 2.30766928655943892589874621990020e-01 1.51627693845403033190422092957306e-01 6.17605377498653074219703285052674e-01 1.32352995690808161732832104462432e-02
 	 1.51627693845403033190422092957306e-01 6.17605377498653074219703285052674e-01 2.30766928655943892589874621990020e-01 1.32352995690808161732832104462432e-02
 	 1.51627693845403033190422092957306e-01 2.30766928655943892589874621990020e-01 6.17605377498653074219703285052674e-01 1.32352995690808161732832104462432e-02
 	 5.23270463532956031649234773794888e-01 3.23002638196491276278976556568523e-01 1.53726898270552692071788669636589e-01 1.49764780310986424238794967322974e-02
 	 5.23270463532956031649234773794888e-01 1.53726898270552692071788669636589e-01 3.23002638196491276278976556568523e-01 1.49764780310986424238794967322974e-02
 	 3.23002638196491276278976556568523e-01 5.23270463532956031649234773794888e-01 1.53726898270552692071788669636589e-01 1.49764780310986424238794967322974e-02
 	 3.23002638196491276278976556568523e-01 1.53726898270552692071788669636589e-01 5.23270463532956031649234773794888e-01 1.49764780310986424238794967322974e-02
 	 1.53726898270552692071788669636589e-01 5.23270463532956031649234773794888e-01 3.23002638196491276278976556568523e-01 1.49764780310986424238794967322974e-02
 	 1.53726898270552692071788669636589e-01 3.23002638196491276278976556568523e-01 5.23270463532956031649234773794888e-01 1.49764780310986424238794967322974e-02
 	 4.31308082067835607542605202979757e-01 3.30276680517265386338721100401017e-01 2.38415237414898950607522465361399e-01 1.80238652394474861695439216191517e-02
 	 4.31308082067835607542605202979757e-01 2.38415237414898950607522465361399e-01 3.30276680517265386338721100401017e-01 1.80238652394474861695439216191517e-02
 	 3.30276680517265386338721100401017e-01 4.31308082067835607542605202979757e-01 2.38415237414898950607522465361399e-01 1.80238652394474861695439216191517e-02
 	 3.30276680517265386338721100401017e-01 2.38415237414898950607522465361399e-01 4.31308082067835607542605202979757e-01 1.80238652394474861695439216191517e-02
 	 2.38415237414898950607522465361399e-01 4.31308082067835607542605202979757e-01 3.30276680517265386338721100401017e-01 1.80238652394474861695439216191517e-02
 	 2.38415237414898950607522465361399e-01 3.30276680517265386338721100401017e-01 4.31308082067835607542605202979757e-01 1.80238652394474861695439216191517e-02
 	 ];
 
 	 case  27 

 	 % ALG. DEG.:   27
 	 % PTS CARD.:  153
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.5e-13  

 	 xyw_bar=[
 	 6.02872510688590157457156237796880e-03 6.02872510688590157457156237796880e-03 9.87942549786228196850856875244062e-01 4.43235614293845440157804116410034e-04
 	 6.02872510688590157457156237796880e-03 9.87942549786228196850856875244062e-01 6.02872510688590157457156237796880e-03 4.43235614293845440157804116410034e-04
 	 9.87942549786228196850856875244062e-01 6.02872510688590157457156237796880e-03 6.02872510688590157457156237796880e-03 4.43235614293845440157804116410034e-04
 	 2.25804480640937610402829704980832e-02 2.25804480640937610402829704980832e-02 9.54839103871812477919434059003834e-01 1.70838802256778306623563601363003e-03
 	 2.25804480640937610402829704980832e-02 9.54839103871812477919434059003834e-01 2.25804480640937610402829704980832e-02 1.70838802256778306623563601363003e-03
 	 9.54839103871812477919434059003834e-01 2.25804480640937610402829704980832e-02 2.25804480640937610402829704980832e-02 1.70838802256778306623563601363003e-03
 	 4.96948162575856389189254969096510e-01 4.96948162575856389189254969096510e-01 6.10367484828722162149006180698052e-03 2.93659414161010238683569006923335e-03
 	 4.96948162575856389189254969096510e-01 6.10367484828722162149006180698052e-03 4.96948162575856389189254969096510e-01 2.93659414161010238683569006923335e-03
 	 6.10367484828722162149006180698052e-03 4.96948162575856389189254969096510e-01 4.96948162575856389189254969096510e-01 2.93659414161010238683569006923335e-03
 	 6.97453864825942071448139358835761e-02 6.97453864825942071448139358835761e-02 8.60509227034811585710372128232848e-01 4.52841537864393482715197336574420e-03
 	 6.97453864825942071448139358835761e-02 8.60509227034811585710372128232848e-01 6.97453864825942071448139358835761e-02 4.52841537864393482715197336574420e-03
 	 8.60509227034811585710372128232848e-01 6.97453864825942071448139358835761e-02 6.97453864825942071448139358835761e-02 4.52841537864393482715197336574420e-03
 	 1.33222990598772211834344147973752e-01 1.33222990598772211834344147973752e-01 7.33554018802455631842462935310323e-01 9.26039382719292571144453773968053e-03
 	 1.33222990598772211834344147973752e-01 7.33554018802455631842462935310323e-01 1.33222990598772211834344147973752e-01 9.26039382719292571144453773968053e-03
 	 7.33554018802455631842462935310323e-01 1.33222990598772211834344147973752e-01 1.33222990598772211834344147973752e-01 9.26039382719292571144453773968053e-03
 	 4.61535910661834414270288107218221e-01 4.61535910661834414270288107218221e-01 7.69281786763311714594237855635583e-02 1.03250177142082903009034922092724e-02
 	 4.61535910661834414270288107218221e-01 7.69281786763311714594237855635583e-02 4.61535910661834414270288107218221e-01 1.03250177142082903009034922092724e-02
 	 7.69281786763311714594237855635583e-02 4.61535910661834414270288107218221e-01 4.61535910661834414270288107218221e-01 1.03250177142082903009034922092724e-02
 	 2.11399010110215612723294498209725e-01 2.11399010110215612723294498209725e-01 5.77201979779568774553411003580550e-01 1.31536544265134346803902687383925e-02
 	 2.11399010110215612723294498209725e-01 5.77201979779568774553411003580550e-01 2.11399010110215612723294498209725e-01 1.31536544265134346803902687383925e-02
 	 5.77201979779568774553411003580550e-01 2.11399010110215612723294498209725e-01 2.11399010110215612723294498209725e-01 1.31536544265134346803902687383925e-02
 	 3.92179397457324996345562340138713e-01 3.92179397457324996345562340138713e-01 2.15641205085350007308875319722574e-01 1.58746081641998083855416012966089e-02
 	 3.92179397457324996345562340138713e-01 2.15641205085350007308875319722574e-01 3.92179397457324996345562340138713e-01 1.58746081641998083855416012966089e-02
 	 2.15641205085350007308875319722574e-01 3.92179397457324996345562340138713e-01 3.92179397457324996345562340138713e-01 1.58746081641998083855416012966089e-02
 	 3.02074000493973815473225386085687e-01 3.02074000493973815473225386085687e-01 3.95851999012052369053549227828626e-01 1.68896031376152624958741910177196e-02
 	 3.02074000493973815473225386085687e-01 3.95851999012052369053549227828626e-01 3.02074000493973815473225386085687e-01 1.68896031376152624958741910177196e-02
 	 3.95851999012052369053549227828626e-01 3.02074000493973815473225386085687e-01 3.02074000493973815473225386085687e-01 1.68896031376152624958741910177196e-02
 	 9.72577577219754130233297928498359e-01 2.56411289038599408962593173555433e-02 1.78129387638592887044275414609729e-03 3.01712733454340435376717088900023e-04
 	 9.72577577219754130233297928498359e-01 1.78129387638592887044275414609729e-03 2.56411289038599408962593173555433e-02 3.01712733454340435376717088900023e-04
 	 2.56411289038599408962593173555433e-02 9.72577577219754130233297928498359e-01 1.78129387638592887044275414609729e-03 3.01712733454340435376717088900023e-04
 	 2.56411289038599408962593173555433e-02 1.78129387638592887044275414609729e-03 9.72577577219754130233297928498359e-01 3.01712733454340435376717088900023e-04
 	 1.78129387638592887044275414609729e-03 9.72577577219754130233297928498359e-01 2.56411289038599408962593173555433e-02 3.01712733454340435376717088900023e-04
 	 1.78129387638592887044275414609729e-03 2.56411289038599408962593173555433e-02 9.72577577219754130233297928498359e-01 3.01712733454340435376717088900023e-04
 	 9.44757428656674114186841961782193e-01 4.89478566028448414115814557590056e-02 6.29471474048104440157658245880157e-03 1.03404277559127522230497664423865e-03
 	 9.44757428656674114186841961782193e-01 6.29471474048104440157658245880157e-03 4.89478566028448414115814557590056e-02 1.03404277559127522230497664423865e-03
 	 4.89478566028448414115814557590056e-02 9.44757428656674114186841961782193e-01 6.29471474048104440157658245880157e-03 1.03404277559127522230497664423865e-03
 	 4.89478566028448414115814557590056e-02 6.29471474048104440157658245880157e-03 9.44757428656674114186841961782193e-01 1.03404277559127522230497664423865e-03
 	 6.29471474048104440157658245880157e-03 9.44757428656674114186841961782193e-01 4.89478566028448414115814557590056e-02 1.03404277559127522230497664423865e-03
 	 6.29471474048104440157658245880157e-03 4.89478566028448414115814557590056e-02 9.44757428656674114186841961782193e-01 1.03404277559127522230497664423865e-03
 	 9.00140112535706693464021554973442e-01 9.43702253266816004639849779778160e-02 5.48966213761170607199346704874188e-03 1.59319950222357046079602049815094e-03
 	 9.00140112535706693464021554973442e-01 5.48966213761170607199346704874188e-03 9.43702253266816004639849779778160e-02 1.59319950222357046079602049815094e-03
 	 9.43702253266816004639849779778160e-02 9.00140112535706693464021554973442e-01 5.48966213761170607199346704874188e-03 1.59319950222357046079602049815094e-03
 	 9.43702253266816004639849779778160e-02 5.48966213761170607199346704874188e-03 9.00140112535706693464021554973442e-01 1.59319950222357046079602049815094e-03
 	 5.48966213761170607199346704874188e-03 9.00140112535706693464021554973442e-01 9.43702253266816004639849779778160e-02 1.59319950222357046079602049815094e-03
 	 5.48966213761170607199346704874188e-03 9.43702253266816004639849779778160e-02 9.00140112535706693464021554973442e-01 1.59319950222357046079602049815094e-03
 	 8.35926640580004987057805010408629e-01 1.58178278042216791110519125140854e-01 5.89508137777822183167586445051711e-03 2.10802503773826772209831759141707e-03
 	 8.35926640580004987057805010408629e-01 5.89508137777822183167586445051711e-03 1.58178278042216791110519125140854e-01 2.10802503773826772209831759141707e-03
 	 1.58178278042216791110519125140854e-01 8.35926640580004987057805010408629e-01 5.89508137777822183167586445051711e-03 2.10802503773826772209831759141707e-03
 	 1.58178278042216791110519125140854e-01 5.89508137777822183167586445051711e-03 8.35926640580004987057805010408629e-01 2.10802503773826772209831759141707e-03
 	 5.89508137777822183167586445051711e-03 8.35926640580004987057805010408629e-01 1.58178278042216791110519125140854e-01 2.10802503773826772209831759141707e-03
 	 5.89508137777822183167586445051711e-03 1.58178278042216791110519125140854e-01 8.35926640580004987057805010408629e-01 2.10802503773826772209831759141707e-03
 	 7.61488498658509094241253478685394e-01 2.32483150304507807382137229978980e-01 6.02835103698309837660929133562604e-03 2.42083798008727903161574346313500e-03
 	 7.61488498658509094241253478685394e-01 6.02835103698309837660929133562604e-03 2.32483150304507807382137229978980e-01 2.42083798008727903161574346313500e-03
 	 2.32483150304507807382137229978980e-01 7.61488498658509094241253478685394e-01 6.02835103698309837660929133562604e-03 2.42083798008727903161574346313500e-03
 	 2.32483150304507807382137229978980e-01 6.02835103698309837660929133562604e-03 7.61488498658509094241253478685394e-01 2.42083798008727903161574346313500e-03
 	 6.02835103698309837660929133562604e-03 7.61488498658509094241253478685394e-01 2.32483150304507807382137229978980e-01 2.42083798008727903161574346313500e-03
 	 6.02835103698309837660929133562604e-03 2.32483150304507807382137229978980e-01 7.61488498658509094241253478685394e-01 2.42083798008727903161574346313500e-03
 	 6.79274857925024622140597330144374e-01 3.14735969095626788583075494898367e-01 5.98917297934858927632717495725956e-03 2.63574074337360846065347885769370e-03
 	 6.79274857925024622140597330144374e-01 5.98917297934858927632717495725956e-03 3.14735969095626788583075494898367e-01 2.63574074337360846065347885769370e-03
 	 3.14735969095626788583075494898367e-01 6.79274857925024622140597330144374e-01 5.98917297934858927632717495725956e-03 2.63574074337360846065347885769370e-03
 	 3.14735969095626788583075494898367e-01 5.98917297934858927632717495725956e-03 6.79274857925024622140597330144374e-01 2.63574074337360846065347885769370e-03
 	 5.98917297934858927632717495725956e-03 6.79274857925024622140597330144374e-01 3.14735969095626788583075494898367e-01 2.63574074337360846065347885769370e-03
 	 5.98917297934858927632717495725956e-03 3.14735969095626788583075494898367e-01 6.79274857925024622140597330144374e-01 2.63574074337360846065347885769370e-03
 	 5.90173779527698449953732051653787e-01 4.03765902224754891225444453084492e-01 6.06031824754665882082349526172038e-03 2.84708688341685396683278241880544e-03
 	 5.90173779527698449953732051653787e-01 6.06031824754665882082349526172038e-03 4.03765902224754891225444453084492e-01 2.84708688341685396683278241880544e-03
 	 4.03765902224754891225444453084492e-01 5.90173779527698449953732051653787e-01 6.06031824754665882082349526172038e-03 2.84708688341685396683278241880544e-03
 	 4.03765902224754891225444453084492e-01 6.06031824754665882082349526172038e-03 5.90173779527698449953732051653787e-01 2.84708688341685396683278241880544e-03
 	 6.06031824754665882082349526172038e-03 5.90173779527698449953732051653787e-01 4.03765902224754891225444453084492e-01 2.84708688341685396683278241880544e-03
 	 6.06031824754665882082349526172038e-03 4.03765902224754891225444453084492e-01 5.90173779527698449953732051653787e-01 2.84708688341685396683278241880544e-03
 	 9.08147639531831196713085319061065e-01 6.24216082469765121132354579458479e-02 2.94307522211922911736792229930870e-02 3.04530716666332954001283894740482e-03
 	 9.08147639531831196713085319061065e-01 2.94307522211922911736792229930870e-02 6.24216082469765121132354579458479e-02 3.04530716666332954001283894740482e-03
 	 6.24216082469765121132354579458479e-02 9.08147639531831196713085319061065e-01 2.94307522211922911736792229930870e-02 3.04530716666332954001283894740482e-03
 	 6.24216082469765121132354579458479e-02 2.94307522211922911736792229930870e-02 9.08147639531831196713085319061065e-01 3.04530716666332954001283894740482e-03
 	 2.94307522211922911736792229930870e-02 9.08147639531831196713085319061065e-01 6.24216082469765121132354579458479e-02 3.04530716666332954001283894740482e-03
 	 2.94307522211922911736792229930870e-02 6.24216082469765121132354579458479e-02 9.08147639531831196713085319061065e-01 3.04530716666332954001283894740482e-03
 	 8.53441207153490366543735490267863e-01 1.17038555323194598534186638971732e-01 2.95202375233150349220778707604040e-02 4.11143575252609534687042724954154e-03
 	 8.53441207153490366543735490267863e-01 2.95202375233150349220778707604040e-02 1.17038555323194598534186638971732e-01 4.11143575252609534687042724954154e-03
 	 1.17038555323194598534186638971732e-01 8.53441207153490366543735490267863e-01 2.95202375233150349220778707604040e-02 4.11143575252609534687042724954154e-03
 	 1.17038555323194598534186638971732e-01 2.95202375233150349220778707604040e-02 8.53441207153490366543735490267863e-01 4.11143575252609534687042724954154e-03
 	 2.95202375233150349220778707604040e-02 8.53441207153490366543735490267863e-01 1.17038555323194598534186638971732e-01 4.11143575252609534687042724954154e-03
 	 2.95202375233150349220778707604040e-02 1.17038555323194598534186638971732e-01 8.53441207153490366543735490267863e-01 4.11143575252609534687042724954154e-03
 	 7.84561667827341380210270926909288e-01 1.84167433829062893169137282711745e-01 3.12708983435957266205917903789668e-02 5.02860503405238006696675867601698e-03
 	 7.84561667827341380210270926909288e-01 3.12708983435957266205917903789668e-02 1.84167433829062893169137282711745e-01 5.02860503405238006696675867601698e-03
 	 1.84167433829062893169137282711745e-01 7.84561667827341380210270926909288e-01 3.12708983435957266205917903789668e-02 5.02860503405238006696675867601698e-03
 	 1.84167433829062893169137282711745e-01 3.12708983435957266205917903789668e-02 7.84561667827341380210270926909288e-01 5.02860503405238006696675867601698e-03
 	 3.12708983435957266205917903789668e-02 7.84561667827341380210270926909288e-01 1.84167433829062893169137282711745e-01 5.02860503405238006696675867601698e-03
 	 3.12708983435957266205917903789668e-02 1.84167433829062893169137282711745e-01 7.84561667827341380210270926909288e-01 5.02860503405238006696675867601698e-03
 	 7.08519881821631503093783521762816e-01 2.60168754876502983375274880017969e-01 3.13113633018655135309415982192149e-02 5.62878756589557140144197688869099e-03
 	 7.08519881821631503093783521762816e-01 3.13113633018655135309415982192149e-02 2.60168754876502983375274880017969e-01 5.62878756589557140144197688869099e-03
 	 2.60168754876502983375274880017969e-01 7.08519881821631503093783521762816e-01 3.13113633018655135309415982192149e-02 5.62878756589557140144197688869099e-03
 	 2.60168754876502983375274880017969e-01 3.13113633018655135309415982192149e-02 7.08519881821631503093783521762816e-01 5.62878756589557140144197688869099e-03
 	 3.13113633018655135309415982192149e-02 7.08519881821631503093783521762816e-01 2.60168754876502983375274880017969e-01 5.62878756589557140144197688869099e-03
 	 3.13113633018655135309415982192149e-02 2.60168754876502983375274880017969e-01 7.08519881821631503093783521762816e-01 5.62878756589557140144197688869099e-03
 	 6.23662680919337741869412639061920e-01 3.44939109327520476711015362525359e-01 3.13982097531417814195719984127209e-02 6.27085339778746600480907602559455e-03
 	 6.23662680919337741869412639061920e-01 3.13982097531417814195719984127209e-02 3.44939109327520476711015362525359e-01 6.27085339778746600480907602559455e-03
 	 3.44939109327520476711015362525359e-01 6.23662680919337741869412639061920e-01 3.13982097531417814195719984127209e-02 6.27085339778746600480907602559455e-03
 	 3.44939109327520476711015362525359e-01 3.13982097531417814195719984127209e-02 6.23662680919337741869412639061920e-01 6.27085339778746600480907602559455e-03
 	 3.13982097531417814195719984127209e-02 6.23662680919337741869412639061920e-01 3.44939109327520476711015362525359e-01 6.27085339778746600480907602559455e-03
 	 3.13982097531417814195719984127209e-02 3.44939109327520476711015362525359e-01 6.23662680919337741869412639061920e-01 6.27085339778746600480907602559455e-03
 	 8.02460515514371586220931931165978e-01 1.25010019659924004331585933869064e-01 7.25294648257044094474821349649574e-02 6.53816728216681172791702181257278e-03
 	 8.02460515514371586220931931165978e-01 7.25294648257044094474821349649574e-02 1.25010019659924004331585933869064e-01 6.53816728216681172791702181257278e-03
 	 1.25010019659924004331585933869064e-01 8.02460515514371586220931931165978e-01 7.25294648257044094474821349649574e-02 6.53816728216681172791702181257278e-03
 	 1.25010019659924004331585933869064e-01 7.25294648257044094474821349649574e-02 8.02460515514371586220931931165978e-01 6.53816728216681172791702181257278e-03
 	 7.25294648257044094474821349649574e-02 8.02460515514371586220931931165978e-01 1.25010019659924004331585933869064e-01 6.53816728216681172791702181257278e-03
 	 7.25294648257044094474821349649574e-02 1.25010019659924004331585933869064e-01 8.02460515514371586220931931165978e-01 6.53816728216681172791702181257278e-03
 	 5.31386343848350817253844979859423e-01 4.36826791108323175816252614822588e-01 3.17868650433260069299024053179892e-02 6.70475295465805185002317045928066e-03
 	 5.31386343848350817253844979859423e-01 3.17868650433260069299024053179892e-02 4.36826791108323175816252614822588e-01 6.70475295465805185002317045928066e-03
 	 4.36826791108323175816252614822588e-01 5.31386343848350817253844979859423e-01 3.17868650433260069299024053179892e-02 6.70475295465805185002317045928066e-03
 	 4.36826791108323175816252614822588e-01 3.17868650433260069299024053179892e-02 5.31386343848350817253844979859423e-01 6.70475295465805185002317045928066e-03
 	 3.17868650433260069299024053179892e-02 5.31386343848350817253844979859423e-01 4.36826791108323175816252614822588e-01 6.70475295465805185002317045928066e-03
 	 3.17868650433260069299024053179892e-02 4.36826791108323175816252614822588e-01 5.31386343848350817253844979859423e-01 6.70475295465805185002317045928066e-03
 	 7.29210554614469153023037506500259e-01 1.95225741421016812937594409049780e-01 7.55637039645140340393680844499613e-02 8.10398375185309230439578698224068e-03
 	 7.29210554614469153023037506500259e-01 7.55637039645140340393680844499613e-02 1.95225741421016812937594409049780e-01 8.10398375185309230439578698224068e-03
 	 1.95225741421016812937594409049780e-01 7.29210554614469153023037506500259e-01 7.55637039645140340393680844499613e-02 8.10398375185309230439578698224068e-03
 	 1.95225741421016812937594409049780e-01 7.55637039645140340393680844499613e-02 7.29210554614469153023037506500259e-01 8.10398375185309230439578698224068e-03
 	 7.55637039645140340393680844499613e-02 7.29210554614469153023037506500259e-01 1.95225741421016812937594409049780e-01 8.10398375185309230439578698224068e-03
 	 7.55637039645140340393680844499613e-02 1.95225741421016812937594409049780e-01 7.29210554614469153023037506500259e-01 8.10398375185309230439578698224068e-03
 	 6.47395307940602737772906039026566e-01 2.77031342028357274731575898840674e-01 7.55733500310399874955180621327600e-02 9.21602869555018279490443688928281e-03
 	 6.47395307940602737772906039026566e-01 7.55733500310399874955180621327600e-02 2.77031342028357274731575898840674e-01 9.21602869555018279490443688928281e-03
 	 2.77031342028357274731575898840674e-01 6.47395307940602737772906039026566e-01 7.55733500310399874955180621327600e-02 9.21602869555018279490443688928281e-03
 	 2.77031342028357274731575898840674e-01 7.55733500310399874955180621327600e-02 6.47395307940602737772906039026566e-01 9.21602869555018279490443688928281e-03
 	 7.55733500310399874955180621327600e-02 6.47395307940602737772906039026566e-01 2.77031342028357274731575898840674e-01 9.21602869555018279490443688928281e-03
 	 7.55733500310399874955180621327600e-02 2.77031342028357274731575898840674e-01 6.47395307940602737772906039026566e-01 9.21602869555018279490443688928281e-03
 	 5.56614640862459930659156270849053e-01 3.67086174365103212746674898880883e-01 7.62991847724368565941688302700641e-02 1.00221108897944263804724585043004e-02
 	 5.56614640862459930659156270849053e-01 7.62991847724368565941688302700641e-02 3.67086174365103212746674898880883e-01 1.00221108897944263804724585043004e-02
 	 3.67086174365103212746674898880883e-01 5.56614640862459930659156270849053e-01 7.62991847724368565941688302700641e-02 1.00221108897944263804724585043004e-02
 	 3.67086174365103212746674898880883e-01 7.62991847724368565941688302700641e-02 5.56614640862459930659156270849053e-01 1.00221108897944263804724585043004e-02
 	 7.62991847724368565941688302700641e-02 5.56614640862459930659156270849053e-01 3.67086174365103212746674898880883e-01 1.00221108897944263804724585043004e-02
 	 7.62991847724368565941688302700641e-02 3.67086174365103212746674898880883e-01 5.56614640862459930659156270849053e-01 1.00221108897944263804724585043004e-02
 	 6.55804993103211053551149234408513e-01 2.07677817553239690839816944389895e-01 1.36517189343549255609033821201592e-01 1.08925884826701138696769532998587e-02
 	 6.55804993103211053551149234408513e-01 1.36517189343549255609033821201592e-01 2.07677817553239690839816944389895e-01 1.08925884826701138696769532998587e-02
 	 2.07677817553239690839816944389895e-01 6.55804993103211053551149234408513e-01 1.36517189343549255609033821201592e-01 1.08925884826701138696769532998587e-02
 	 2.07677817553239690839816944389895e-01 1.36517189343549255609033821201592e-01 6.55804993103211053551149234408513e-01 1.08925884826701138696769532998587e-02
 	 1.36517189343549255609033821201592e-01 6.55804993103211053551149234408513e-01 2.07677817553239690839816944389895e-01 1.08925884826701138696769532998587e-02
 	 1.36517189343549255609033821201592e-01 2.07677817553239690839816944389895e-01 6.55804993103211053551149234408513e-01 1.08925884826701138696769532998587e-02
 	 5.70923789561736949593750978237949e-01 2.91806857017890386440939209933276e-01 1.37269353420372663965309811828774e-01 1.22687734810434916771226809828477e-02
 	 5.70923789561736949593750978237949e-01 1.37269353420372663965309811828774e-01 2.91806857017890386440939209933276e-01 1.22687734810434916771226809828477e-02
 	 2.91806857017890386440939209933276e-01 5.70923789561736949593750978237949e-01 1.37269353420372663965309811828774e-01 1.22687734810434916771226809828477e-02
 	 2.91806857017890386440939209933276e-01 1.37269353420372663965309811828774e-01 5.70923789561736949593750978237949e-01 1.22687734810434916771226809828477e-02
 	 1.37269353420372663965309811828774e-01 5.70923789561736949593750978237949e-01 2.91806857017890386440939209933276e-01 1.22687734810434916771226809828477e-02
 	 1.37269353420372663965309811828774e-01 2.91806857017890386440939209933276e-01 5.70923789561736949593750978237949e-01 1.22687734810434916771226809828477e-02
 	 4.78028270406271715842194680590183e-01 3.83097780854546821061035188904498e-01 1.38873948739181463096770130505320e-01 1.31829715331283764401248959075019e-02
 	 4.78028270406271715842194680590183e-01 1.38873948739181463096770130505320e-01 3.83097780854546821061035188904498e-01 1.31829715331283764401248959075019e-02
 	 3.83097780854546821061035188904498e-01 4.78028270406271715842194680590183e-01 1.38873948739181463096770130505320e-01 1.31829715331283764401248959075019e-02
 	 3.83097780854546821061035188904498e-01 1.38873948739181463096770130505320e-01 4.78028270406271715842194680590183e-01 1.31829715331283764401248959075019e-02
 	 1.38873948739181463096770130505320e-01 4.78028270406271715842194680590183e-01 3.83097780854546821061035188904498e-01 1.31829715331283764401248959075019e-02
 	 1.38873948739181463096770130505320e-01 3.83097780854546821061035188904498e-01 4.78028270406271715842194680590183e-01 1.31829715331283764401248959075019e-02
 	 4.88026817278848390468937168407138e-01 2.97907118579965990434743616788182e-01 2.14066064141185563585167983546853e-01 1.51516998095694004761169182415870e-02
 	 4.88026817278848390468937168407138e-01 2.14066064141185563585167983546853e-01 2.97907118579965990434743616788182e-01 1.51516998095694004761169182415870e-02
 	 2.97907118579965990434743616788182e-01 4.88026817278848390468937168407138e-01 2.14066064141185563585167983546853e-01 1.51516998095694004761169182415870e-02
 	 2.97907118579965990434743616788182e-01 2.14066064141185563585167983546853e-01 4.88026817278848390468937168407138e-01 1.51516998095694004761169182415870e-02
 	 2.14066064141185563585167983546853e-01 4.88026817278848390468937168407138e-01 2.97907118579965990434743616788182e-01 1.51516998095694004761169182415870e-02
 	 2.14066064141185563585167983546853e-01 2.97907118579965990434743616788182e-01 4.88026817278848390468937168407138e-01 1.51516998095694004761169182415870e-02
 	 ];
 
 	 case  28 

 	 % ALG. DEG.:   28
 	 % PTS CARD.:  171
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.9e-15  

 	 xyw_bar=[
 	 3.52781468614782279732966507879155e-03 3.52781468614782279732966507879155e-03 9.92944370627704353537978931854013e-01 1.68828471789709015551256277021253e-04
 	 3.52781468614782279732966507879155e-03 9.92944370627704353537978931854013e-01 3.52781468614782279732966507879155e-03 1.68828471789709015551256277021253e-04
 	 9.92944370627704353537978931854013e-01 3.52781468614782279732966507879155e-03 3.52781468614782279732966507879155e-03 1.68828471789709015551256277021253e-04
 	 2.32544785996821011531121570214964e-02 2.32544785996821011531121570214964e-02 9.53491042800635790754881782049779e-01 1.29903671202050326194399332280227e-03
 	 2.32544785996821011531121570214964e-02 9.53491042800635790754881782049779e-01 2.32544785996821011531121570214964e-02 1.29903671202050326194399332280227e-03
 	 9.53491042800635790754881782049779e-01 2.32544785996821011531121570214964e-02 2.32544785996821011531121570214964e-02 1.29903671202050326194399332280227e-03
 	 6.13061711490491267895208693516906e-02 6.13061711490491267895208693516906e-02 8.77387657701901746420958261296619e-01 3.93842260805576504373304302930592e-03
 	 6.13061711490491267895208693516906e-02 8.77387657701901746420958261296619e-01 6.13061711490491267895208693516906e-02 3.93842260805576504373304302930592e-03
 	 8.77387657701901746420958261296619e-01 6.13061711490491267895208693516906e-02 6.13061711490491267895208693516906e-02 3.93842260805576504373304302930592e-03
 	 4.85597365316512985522479084465886e-01 4.85597365316512985522479084465886e-01 2.88052693669740289550418310682289e-02 5.79050543361941429110206769337310e-03
 	 4.85597365316512985522479084465886e-01 2.88052693669740289550418310682289e-02 4.85597365316512985522479084465886e-01 5.79050543361941429110206769337310e-03
 	 2.88052693669740289550418310682289e-02 4.85597365316512985522479084465886e-01 4.85597365316512985522479084465886e-01 5.79050543361941429110206769337310e-03
 	 1.19574379687203594113675819698983e-01 1.19574379687203594113675819698983e-01 7.60851240625592839528223976230947e-01 7.52896849588346843418218412580245e-03
 	 1.19574379687203594113675819698983e-01 7.60851240625592839528223976230947e-01 1.19574379687203594113675819698983e-01 7.52896849588346843418218412580245e-03
 	 7.60851240625592839528223976230947e-01 1.19574379687203594113675819698983e-01 1.19574379687203594113675819698983e-01 7.52896849588346843418218412580245e-03
 	 1.93832849735944889868477503114264e-01 1.93832849735944889868477503114264e-01 6.12334300528110220263044993771473e-01 1.09520031775945606705713331052721e-02
 	 1.93832849735944889868477503114264e-01 6.12334300528110220263044993771473e-01 1.93832849735944889868477503114264e-01 1.09520031775945606705713331052721e-02
 	 6.12334300528110220263044993771473e-01 1.93832849735944889868477503114264e-01 1.93832849735944889868477503114264e-01 1.09520031775945606705713331052721e-02
 	 4.36854825801192891976398868791875e-01 4.36854825801192891976398868791875e-01 1.26290348397614216047202262416249e-01 1.13144540852839030342646964300002e-02
 	 4.36854825801192891976398868791875e-01 1.26290348397614216047202262416249e-01 4.36854825801192891976398868791875e-01 1.13144540852839030342646964300002e-02
 	 1.26290348397614216047202262416249e-01 4.36854825801192891976398868791875e-01 4.36854825801192891976398868791875e-01 1.13144540852839030342646964300002e-02
 	 2.74786691854845999127832101294189e-01 2.74786691854845999127832101294189e-01 4.50426616290308001744335797411622e-01 1.42362905099712496598263200553447e-02
 	 2.74786691854845999127832101294189e-01 4.50426616290308001744335797411622e-01 2.74786691854845999127832101294189e-01 1.42362905099712496598263200553447e-02
 	 4.50426616290308001744335797411622e-01 2.74786691854845999127832101294189e-01 2.74786691854845999127832101294189e-01 1.42362905099712496598263200553447e-02
 	 3.61886974590005405794101989158662e-01 3.61886974590005405794101989158662e-01 2.76226050819989188411796021682676e-01 1.49105703269717861786380908029059e-02
 	 3.61886974590005405794101989158662e-01 2.76226050819989188411796021682676e-01 3.61886974590005405794101989158662e-01 1.49105703269717861786380908029059e-02
 	 2.76226050819989188411796021682676e-01 3.61886974590005405794101989158662e-01 3.61886974590005405794101989158662e-01 1.49105703269717861786380908029059e-02
 	 9.76405945543714515189037683740025e-01 1.90656116400246301856302721944303e-02 4.52844281626085462533204406554432e-03 4.89575022817267837930976792648607e-04
 	 9.76405945543714515189037683740025e-01 4.52844281626085462533204406554432e-03 1.90656116400246301856302721944303e-02 4.89575022817267837930976792648607e-04
 	 1.90656116400246301856302721944303e-02 9.76405945543714515189037683740025e-01 4.52844281626085462533204406554432e-03 4.89575022817267837930976792648607e-04
 	 1.90656116400246301856302721944303e-02 4.52844281626085462533204406554432e-03 9.76405945543714515189037683740025e-01 4.89575022817267837930976792648607e-04
 	 4.52844281626085462533204406554432e-03 9.76405945543714515189037683740025e-01 1.90656116400246301856302721944303e-02 4.89575022817267837930976792648607e-04
 	 4.52844281626085462533204406554432e-03 1.90656116400246301856302721944303e-02 9.76405945543714515189037683740025e-01 4.89575022817267837930976792648607e-04
 	 9.49626039031084334673948887939332e-01 4.57527920669597021330332609068137e-02 4.62116890195596319301785115385428e-03 7.70464298658064318005289639046396e-04
 	 9.49626039031084334673948887939332e-01 4.62116890195596319301785115385428e-03 4.57527920669597021330332609068137e-02 7.70464298658064318005289639046396e-04
 	 4.57527920669597021330332609068137e-02 9.49626039031084334673948887939332e-01 4.62116890195596319301785115385428e-03 7.70464298658064318005289639046396e-04
 	 4.57527920669597021330332609068137e-02 4.62116890195596319301785115385428e-03 9.49626039031084334673948887939332e-01 7.70464298658064318005289639046396e-04
 	 4.62116890195596319301785115385428e-03 9.49626039031084334673948887939332e-01 4.57527920669597021330332609068137e-02 7.70464298658064318005289639046396e-04
 	 4.62116890195596319301785115385428e-03 4.57527920669597021330332609068137e-02 9.49626039031084334673948887939332e-01 7.70464298658064318005289639046396e-04
 	 9.09575444421073298073565638333093e-01 8.55585301859539404389920491666999e-02 4.86602539297276148744231250020675e-03 1.19205191231305579133148420112320e-03
 	 9.09575444421073298073565638333093e-01 4.86602539297276148744231250020675e-03 8.55585301859539404389920491666999e-02 1.19205191231305579133148420112320e-03
 	 8.55585301859539404389920491666999e-02 9.09575444421073298073565638333093e-01 4.86602539297276148744231250020675e-03 1.19205191231305579133148420112320e-03
 	 8.55585301859539404389920491666999e-02 4.86602539297276148744231250020675e-03 9.09575444421073298073565638333093e-01 1.19205191231305579133148420112320e-03
 	 4.86602539297276148744231250020675e-03 9.09575444421073298073565638333093e-01 8.55585301859539404389920491666999e-02 1.19205191231305579133148420112320e-03
 	 4.86602539297276148744231250020675e-03 8.55585301859539404389920491666999e-02 9.09575444421073298073565638333093e-01 1.19205191231305579133148420112320e-03
 	 8.53928600117039415806630131555721e-01 1.40745793360055188037094353603607e-01 5.32560652290539615627551484067226e-03 1.69230236401777351870623355978296e-03
 	 8.53928600117039415806630131555721e-01 5.32560652290539615627551484067226e-03 1.40745793360055188037094353603607e-01 1.69230236401777351870623355978296e-03
 	 1.40745793360055188037094353603607e-01 8.53928600117039415806630131555721e-01 5.32560652290539615627551484067226e-03 1.69230236401777351870623355978296e-03
 	 1.40745793360055188037094353603607e-01 5.32560652290539615627551484067226e-03 8.53928600117039415806630131555721e-01 1.69230236401777351870623355978296e-03
 	 5.32560652290539615627551484067226e-03 8.53928600117039415806630131555721e-01 1.40745793360055188037094353603607e-01 1.69230236401777351870623355978296e-03
 	 5.32560652290539615627551484067226e-03 1.40745793360055188037094353603607e-01 8.53928600117039415806630131555721e-01 1.69230236401777351870623355978296e-03
 	 7.86232363633783681855504710256355e-01 2.08266834439757991814801130203705e-01 5.50080192645832632969415953994030e-03 2.03759884643627507683216748546329e-03
 	 7.86232363633783681855504710256355e-01 5.50080192645832632969415953994030e-03 2.08266834439757991814801130203705e-01 2.03759884643627507683216748546329e-03
 	 2.08266834439757991814801130203705e-01 7.86232363633783681855504710256355e-01 5.50080192645832632969415953994030e-03 2.03759884643627507683216748546329e-03
 	 2.08266834439757991814801130203705e-01 5.50080192645832632969415953994030e-03 7.86232363633783681855504710256355e-01 2.03759884643627507683216748546329e-03
 	 5.50080192645832632969415953994030e-03 7.86232363633783681855504710256355e-01 2.08266834439757991814801130203705e-01 2.03759884643627507683216748546329e-03
 	 5.50080192645832632969415953994030e-03 2.08266834439757991814801130203705e-01 7.86232363633783681855504710256355e-01 2.03759884643627507683216748546329e-03
 	 7.10218209945296274909765088523272e-01 2.84299186848130214233520973721170e-01 5.48260320657351085671393775555771e-03 2.22726029161565567196512382963647e-03
 	 7.10218209945296274909765088523272e-01 5.48260320657351085671393775555771e-03 2.84299186848130214233520973721170e-01 2.22726029161565567196512382963647e-03
 	 2.84299186848130214233520973721170e-01 7.10218209945296274909765088523272e-01 5.48260320657351085671393775555771e-03 2.22726029161565567196512382963647e-03
 	 2.84299186848130214233520973721170e-01 5.48260320657351085671393775555771e-03 7.10218209945296274909765088523272e-01 2.22726029161565567196512382963647e-03
 	 5.48260320657351085671393775555771e-03 7.10218209945296274909765088523272e-01 2.84299186848130214233520973721170e-01 2.22726029161565567196512382963647e-03
 	 5.48260320657351085671393775555771e-03 2.84299186848130214233520973721170e-01 7.10218209945296274909765088523272e-01 2.22726029161565567196512382963647e-03
 	 9.19615743255533413247349017183296e-01 5.56921540915347179634409258142114e-02 2.46921026529318687892100570024922e-02 2.22811737200649066098501194232995e-03
 	 9.19615743255533413247349017183296e-01 2.46921026529318687892100570024922e-02 5.56921540915347179634409258142114e-02 2.22811737200649066098501194232995e-03
 	 5.56921540915347179634409258142114e-02 9.19615743255533413247349017183296e-01 2.46921026529318687892100570024922e-02 2.22811737200649066098501194232995e-03
 	 5.56921540915347179634409258142114e-02 2.46921026529318687892100570024922e-02 9.19615743255533413247349017183296e-01 2.22811737200649066098501194232995e-03
 	 2.46921026529318687892100570024922e-02 9.19615743255533413247349017183296e-01 5.56921540915347179634409258142114e-02 2.22811737200649066098501194232995e-03
 	 2.46921026529318687892100570024922e-02 5.56921540915347179634409258142114e-02 9.19615743255533413247349017183296e-01 2.22811737200649066098501194232995e-03
 	 6.28121500758709094824894236808177e-01 3.66399643439952127366154854826164e-01 5.47885580133877780895090836565942e-03 2.37598555928126946301670585626198e-03
 	 6.28121500758709094824894236808177e-01 5.47885580133877780895090836565942e-03 3.66399643439952127366154854826164e-01 2.37598555928126946301670585626198e-03
 	 3.66399643439952127366154854826164e-01 6.28121500758709094824894236808177e-01 5.47885580133877780895090836565942e-03 2.37598555928126946301670585626198e-03
 	 3.66399643439952127366154854826164e-01 5.47885580133877780895090836565942e-03 6.28121500758709094824894236808177e-01 2.37598555928126946301670585626198e-03
 	 5.47885580133877780895090836565942e-03 6.28121500758709094824894236808177e-01 3.66399643439952127366154854826164e-01 2.37598555928126946301670585626198e-03
 	 5.47885580133877780895090836565942e-03 3.66399643439952127366154854826164e-01 6.28121500758709094824894236808177e-01 2.37598555928126946301670585626198e-03
 	 5.41474950946130295648117680684663e-01 4.53014671446368977214547157927882e-01 5.51037760750072713733516138745472e-03 2.48742263085012776241411458499897e-03
 	 5.41474950946130295648117680684663e-01 5.51037760750072713733516138745472e-03 4.53014671446368977214547157927882e-01 2.48742263085012776241411458499897e-03
 	 4.53014671446368977214547157927882e-01 5.41474950946130295648117680684663e-01 5.51037760750072713733516138745472e-03 2.48742263085012776241411458499897e-03
 	 4.53014671446368977214547157927882e-01 5.51037760750072713733516138745472e-03 5.41474950946130295648117680684663e-01 2.48742263085012776241411458499897e-03
 	 5.51037760750072713733516138745472e-03 5.41474950946130295648117680684663e-01 4.53014671446368977214547157927882e-01 2.48742263085012776241411458499897e-03
 	 5.51037760750072713733516138745472e-03 4.53014671446368977214547157927882e-01 5.41474950946130295648117680684663e-01 2.48742263085012776241411458499897e-03
 	 8.70847043597264058867324365564855e-01 1.02747376222606198736819749228744e-01 2.64055801801297423958558852064016e-02 3.24701241373823732208614423200288e-03
 	 8.70847043597264058867324365564855e-01 2.64055801801297423958558852064016e-02 1.02747376222606198736819749228744e-01 3.24701241373823732208614423200288e-03
 	 1.02747376222606198736819749228744e-01 8.70847043597264058867324365564855e-01 2.64055801801297423958558852064016e-02 3.24701241373823732208614423200288e-03
 	 1.02747376222606198736819749228744e-01 2.64055801801297423958558852064016e-02 8.70847043597264058867324365564855e-01 3.24701241373823732208614423200288e-03
 	 2.64055801801297423958558852064016e-02 8.70847043597264058867324365564855e-01 1.02747376222606198736819749228744e-01 3.24701241373823732208614423200288e-03
 	 2.64055801801297423958558852064016e-02 1.02747376222606198736819749228744e-01 8.70847043597264058867324365564855e-01 3.24701241373823732208614423200288e-03
 	 8.08055925125646168361015497794142e-01 1.63625151528200701855908505422121e-01 2.83189233461531297830759967837366e-02 4.21183327129197055543885497286283e-03
 	 8.08055925125646168361015497794142e-01 2.83189233461531297830759967837366e-02 1.63625151528200701855908505422121e-01 4.21183327129197055543885497286283e-03
 	 1.63625151528200701855908505422121e-01 8.08055925125646168361015497794142e-01 2.83189233461531297830759967837366e-02 4.21183327129197055543885497286283e-03
 	 1.63625151528200701855908505422121e-01 2.83189233461531297830759967837366e-02 8.08055925125646168361015497794142e-01 4.21183327129197055543885497286283e-03
 	 2.83189233461531297830759967837366e-02 8.08055925125646168361015497794142e-01 1.63625151528200701855908505422121e-01 4.21183327129197055543885497286283e-03
 	 2.83189233461531297830759967837366e-02 1.63625151528200701855908505422121e-01 8.08055925125646168361015497794142e-01 4.21183327129197055543885497286283e-03
 	 7.37116338815208438361992193676997e-01 2.34175394401963304913394381401304e-01 2.87082667828282567246134249216993e-02 4.78367400458558703069122941542446e-03
 	 7.37116338815208438361992193676997e-01 2.87082667828282567246134249216993e-02 2.34175394401963304913394381401304e-01 4.78367400458558703069122941542446e-03
 	 2.34175394401963304913394381401304e-01 7.37116338815208438361992193676997e-01 2.87082667828282567246134249216993e-02 4.78367400458558703069122941542446e-03
 	 2.34175394401963304913394381401304e-01 2.87082667828282567246134249216993e-02 7.37116338815208438361992193676997e-01 4.78367400458558703069122941542446e-03
 	 2.87082667828282567246134249216993e-02 7.37116338815208438361992193676997e-01 2.34175394401963304913394381401304e-01 4.78367400458558703069122941542446e-03
 	 2.87082667828282567246134249216993e-02 2.34175394401963304913394381401304e-01 7.37116338815208438361992193676997e-01 4.78367400458558703069122941542446e-03
 	 6.59255694951647930324156732240226e-01 3.12168255169341601895638405039790e-01 2.85760498790104677802048627199838e-02 5.22135104863136797342937356347647e-03
 	 6.59255694951647930324156732240226e-01 2.85760498790104677802048627199838e-02 3.12168255169341601895638405039790e-01 5.22135104863136797342937356347647e-03
 	 3.12168255169341601895638405039790e-01 6.59255694951647930324156732240226e-01 2.85760498790104677802048627199838e-02 5.22135104863136797342937356347647e-03
 	 3.12168255169341601895638405039790e-01 2.85760498790104677802048627199838e-02 6.59255694951647930324156732240226e-01 5.22135104863136797342937356347647e-03
 	 2.85760498790104677802048627199838e-02 6.59255694951647930324156732240226e-01 3.12168255169341601895638405039790e-01 5.22135104863136797342937356347647e-03
 	 2.85760498790104677802048627199838e-02 3.12168255169341601895638405039790e-01 6.59255694951647930324156732240226e-01 5.22135104863136797342937356347647e-03
 	 8.21610770110138166621993605076568e-01 1.13243304903654806725654680121806e-01 6.51459249862070266523517148016253e-02 5.46922489919740833358430265320749e-03
 	 8.21610770110138166621993605076568e-01 6.51459249862070266523517148016253e-02 1.13243304903654806725654680121806e-01 5.46922489919740833358430265320749e-03
 	 1.13243304903654806725654680121806e-01 8.21610770110138166621993605076568e-01 6.51459249862070266523517148016253e-02 5.46922489919740833358430265320749e-03
 	 1.13243304903654806725654680121806e-01 6.51459249862070266523517148016253e-02 8.21610770110138166621993605076568e-01 5.46922489919740833358430265320749e-03
 	 6.51459249862070266523517148016253e-02 8.21610770110138166621993605076568e-01 1.13243304903654806725654680121806e-01 5.46922489919740833358430265320749e-03
 	 6.51459249862070266523517148016253e-02 1.13243304903654806725654680121806e-01 8.21610770110138166621993605076568e-01 5.46922489919740833358430265320749e-03
 	 5.74541105959161524374678720050724e-01 3.96768611430950213225798961502733e-01 2.86902826098882623995223184465431e-02 5.62170007491160847457045690589439e-03
 	 5.74541105959161524374678720050724e-01 2.86902826098882623995223184465431e-02 3.96768611430950213225798961502733e-01 5.62170007491160847457045690589439e-03
 	 3.96768611430950213225798961502733e-01 5.74541105959161524374678720050724e-01 2.86902826098882623995223184465431e-02 5.62170007491160847457045690589439e-03
 	 3.96768611430950213225798961502733e-01 2.86902826098882623995223184465431e-02 5.74541105959161524374678720050724e-01 5.62170007491160847457045690589439e-03
 	 2.86902826098882623995223184465431e-02 5.74541105959161524374678720050724e-01 3.96768611430950213225798961502733e-01 5.62170007491160847457045690589439e-03
 	 2.86902826098882623995223184465431e-02 3.96768611430950213225798961502733e-01 5.74541105959161524374678720050724e-01 5.62170007491160847457045690589439e-03
 	 7.52736321001383545947760467242915e-01 1.78349437979342689830630774849851e-01 6.89142410192737642216087579072337e-02 6.82219197720222627484565336430933e-03
 	 7.52736321001383545947760467242915e-01 6.89142410192737642216087579072337e-02 1.78349437979342689830630774849851e-01 6.82219197720222627484565336430933e-03
 	 1.78349437979342689830630774849851e-01 7.52736321001383545947760467242915e-01 6.89142410192737642216087579072337e-02 6.82219197720222627484565336430933e-03
 	 1.78349437979342689830630774849851e-01 6.89142410192737642216087579072337e-02 7.52736321001383545947760467242915e-01 6.82219197720222627484565336430933e-03
 	 6.89142410192737642216087579072337e-02 7.52736321001383545947760467242915e-01 1.78349437979342689830630774849851e-01 6.82219197720222627484565336430933e-03
 	 6.89142410192737642216087579072337e-02 1.78349437979342689830630774849851e-01 7.52736321001383545947760467242915e-01 6.82219197720222627484565336430933e-03
 	 6.77869789721086690725826429115841e-01 2.52933135839176426173935396946035e-01 6.91970744397368831002381739381235e-02 7.63578348187657872381262080807574e-03
 	 6.77869789721086690725826429115841e-01 6.91970744397368831002381739381235e-02 2.52933135839176426173935396946035e-01 7.63578348187657872381262080807574e-03
 	 2.52933135839176426173935396946035e-01 6.77869789721086690725826429115841e-01 6.91970744397368831002381739381235e-02 7.63578348187657872381262080807574e-03
 	 2.52933135839176426173935396946035e-01 6.91970744397368831002381739381235e-02 6.77869789721086690725826429115841e-01 7.63578348187657872381262080807574e-03
 	 6.91970744397368831002381739381235e-02 6.77869789721086690725826429115841e-01 2.52933135839176426173935396946035e-01 7.63578348187657872381262080807574e-03
 	 6.91970744397368831002381739381235e-02 2.52933135839176426173935396946035e-01 6.77869789721086690725826429115841e-01 7.63578348187657872381262080807574e-03
 	 5.96181882441888189028134092950495e-01 3.34657518177714385920751283265417e-01 6.91605993803974250511146237840876e-02 8.25598265452896599991827741860106e-03
 	 5.96181882441888189028134092950495e-01 6.91605993803974250511146237840876e-02 3.34657518177714385920751283265417e-01 8.25598265452896599991827741860106e-03
 	 3.34657518177714385920751283265417e-01 5.96181882441888189028134092950495e-01 6.91605993803974250511146237840876e-02 8.25598265452896599991827741860106e-03
 	 3.34657518177714385920751283265417e-01 6.91605993803974250511146237840876e-02 5.96181882441888189028134092950495e-01 8.25598265452896599991827741860106e-03
 	 6.91605993803974250511146237840876e-02 5.96181882441888189028134092950495e-01 3.34657518177714385920751283265417e-01 8.25598265452896599991827741860106e-03
 	 6.91605993803974250511146237840876e-02 3.34657518177714385920751283265417e-01 5.96181882441888189028134092950495e-01 8.25598265452896599991827741860106e-03
 	 5.09343076403983130440167315100553e-01 4.21087880063123087825971424535965e-01 6.95690435328937817338612603634829e-02 8.62969827541782558144589643234212e-03
 	 5.09343076403983130440167315100553e-01 6.95690435328937817338612603634829e-02 4.21087880063123087825971424535965e-01 8.62969827541782558144589643234212e-03
 	 4.21087880063123087825971424535965e-01 5.09343076403983130440167315100553e-01 6.95690435328937817338612603634829e-02 8.62969827541782558144589643234212e-03
 	 4.21087880063123087825971424535965e-01 6.95690435328937817338612603634829e-02 5.09343076403983130440167315100553e-01 8.62969827541782558144589643234212e-03
 	 6.95690435328937817338612603634829e-02 5.09343076403983130440167315100553e-01 4.21087880063123087825971424535965e-01 8.62969827541782558144589643234212e-03
 	 6.95690435328937817338612603634829e-02 4.21087880063123087825971424535965e-01 5.09343076403983130440167315100553e-01 8.62969827541782558144589643234212e-03
 	 6.87533646543294296726855918677757e-01 1.87462735345927888896966351239826e-01 1.25003618110777814376177730082418e-01 9.19068281131947203976828575378022e-03
 	 6.87533646543294296726855918677757e-01 1.25003618110777814376177730082418e-01 1.87462735345927888896966351239826e-01 9.19068281131947203976828575378022e-03
 	 1.87462735345927888896966351239826e-01 6.87533646543294296726855918677757e-01 1.25003618110777814376177730082418e-01 9.19068281131947203976828575378022e-03
 	 1.87462735345927888896966351239826e-01 1.25003618110777814376177730082418e-01 6.87533646543294296726855918677757e-01 9.19068281131947203976828575378022e-03
 	 1.25003618110777814376177730082418e-01 6.87533646543294296726855918677757e-01 1.87462735345927888896966351239826e-01 9.19068281131947203976828575378022e-03
 	 1.25003618110777814376177730082418e-01 1.87462735345927888896966351239826e-01 6.87533646543294296726855918677757e-01 9.19068281131947203976828575378022e-03
 	 6.09882363677961891745837874623248e-01 2.64906647850885523798325493771699e-01 1.25210988471152584455836631605052e-01 1.02528112373970348852880718482083e-02
 	 6.09882363677961891745837874623248e-01 1.25210988471152584455836631605052e-01 2.64906647850885523798325493771699e-01 1.02528112373970348852880718482083e-02
 	 2.64906647850885523798325493771699e-01 6.09882363677961891745837874623248e-01 1.25210988471152584455836631605052e-01 1.02528112373970348852880718482083e-02
 	 2.64906647850885523798325493771699e-01 1.25210988471152584455836631605052e-01 6.09882363677961891745837874623248e-01 1.02528112373970348852880718482083e-02
 	 1.25210988471152584455836631605052e-01 6.09882363677961891745837874623248e-01 2.64906647850885523798325493771699e-01 1.02528112373970348852880718482083e-02
 	 1.25210988471152584455836631605052e-01 2.64906647850885523798325493771699e-01 6.09882363677961891745837874623248e-01 1.02528112373970348852880718482083e-02
 	 5.25254911987722561406144450302236e-01 3.49006616007701775394878040970070e-01 1.25738472004575663198977508727694e-01 1.10260746354601674168449676471937e-02
 	 5.25254911987722561406144450302236e-01 1.25738472004575663198977508727694e-01 3.49006616007701775394878040970070e-01 1.10260746354601674168449676471937e-02
 	 3.49006616007701775394878040970070e-01 5.25254911987722561406144450302236e-01 1.25738472004575663198977508727694e-01 1.10260746354601674168449676471937e-02
 	 3.49006616007701775394878040970070e-01 1.25738472004575663198977508727694e-01 5.25254911987722561406144450302236e-01 1.10260746354601674168449676471937e-02
 	 1.25738472004575663198977508727694e-01 5.25254911987722561406144450302236e-01 3.49006616007701775394878040970070e-01 1.10260746354601674168449676471937e-02
 	 1.25738472004575663198977508727694e-01 3.49006616007701775394878040970070e-01 5.25254911987722561406144450302236e-01 1.10260746354601674168449676471937e-02
 	 5.33207332734684902320054789015558e-01 2.72179046638476918040794316766551e-01 1.94613620626838179639150894217892e-01 1.23917534199639387676450397179906e-02
 	 5.33207332734684902320054789015558e-01 1.94613620626838179639150894217892e-01 2.72179046638476918040794316766551e-01 1.23917534199639387676450397179906e-02
 	 2.72179046638476918040794316766551e-01 5.33207332734684902320054789015558e-01 1.94613620626838179639150894217892e-01 1.23917534199639387676450397179906e-02
 	 2.72179046638476918040794316766551e-01 1.94613620626838179639150894217892e-01 5.33207332734684902320054789015558e-01 1.23917534199639387676450397179906e-02
 	 1.94613620626838179639150894217892e-01 5.33207332734684902320054789015558e-01 2.72179046638476918040794316766551e-01 1.23917534199639387676450397179906e-02
 	 1.94613620626838179639150894217892e-01 2.72179046638476918040794316766551e-01 5.33207332734684902320054789015558e-01 1.23917534199639387676450397179906e-02
 	 4.46455240965651312112782989061088e-01 3.57596143740140481881439882272389e-01 1.95948615294208261516928359924350e-01 1.33365742525531974504993115715479e-02
 	 4.46455240965651312112782989061088e-01 1.95948615294208261516928359924350e-01 3.57596143740140481881439882272389e-01 1.33365742525531974504993115715479e-02
 	 3.57596143740140481881439882272389e-01 4.46455240965651312112782989061088e-01 1.95948615294208261516928359924350e-01 1.33365742525531974504993115715479e-02
 	 3.57596143740140481881439882272389e-01 1.95948615294208261516928359924350e-01 4.46455240965651312112782989061088e-01 1.33365742525531974504993115715479e-02
 	 1.95948615294208261516928359924350e-01 4.46455240965651312112782989061088e-01 3.57596143740140481881439882272389e-01 1.33365742525531974504993115715479e-02
 	 1.95948615294208261516928359924350e-01 3.57596143740140481881439882272389e-01 4.46455240965651312112782989061088e-01 1.33365742525531974504993115715479e-02
 	 ];
 
 	 case  30 

 	 % ALG. DEG.:   30
 	 % PTS CARD.:  190
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.9e-14  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.37773483475030975031749846948514e-02
 	 2.60849100043125713480063332383452e-03 2.60849100043125713480063332383452e-03 9.94783017999137486597760471340735e-01 1.04046024904039713290110347188033e-04
 	 2.60849100043125713480063332383452e-03 9.94783017999137486597760471340735e-01 2.60849100043125713480063332383452e-03 1.04046024904039713290110347188033e-04
 	 9.94783017999137486597760471340735e-01 2.60849100043125713480063332383452e-03 2.60849100043125713480063332383452e-03 1.04046024904039713290110347188033e-04
 	 1.99081215329428608262762878666763e-02 1.99081215329428608262762878666763e-02 9.60183756934114285286341328173876e-01 9.38574375977555257904993979423125e-04
 	 1.99081215329428608262762878666763e-02 9.60183756934114285286341328173876e-01 1.99081215329428608262762878666763e-02 9.38574375977555257904993979423125e-04
 	 9.60183756934114285286341328173876e-01 1.99081215329428608262762878666763e-02 1.99081215329428608262762878666763e-02 9.38574375977555257904993979423125e-04
 	 4.97508711341201725897320784497424e-01 4.97508711341201725897320784497424e-01 4.98257731759654820535843100515194e-03 2.14981439621544662826879701356120e-03
 	 4.97508711341201725897320784497424e-01 4.98257731759654820535843100515194e-03 4.97508711341201725897320784497424e-01 2.14981439621544662826879701356120e-03
 	 4.98257731759654820535843100515194e-03 4.97508711341201725897320784497424e-01 4.97508711341201725897320784497424e-01 2.14981439621544662826879701356120e-03
 	 5.38543920770780878970462879351544e-02 5.38543920770780878970462879351544e-02 8.92291215845843810328119616315234e-01 3.20344050830294107753970500596097e-03
 	 5.38543920770780878970462879351544e-02 8.92291215845843810328119616315234e-01 5.38543920770780878970462879351544e-02 3.20344050830294107753970500596097e-03
 	 8.92291215845843810328119616315234e-01 5.38543920770780878970462879351544e-02 5.38543920770780878970462879351544e-02 3.20344050830294107753970500596097e-03
 	 1.10234628175723006759945121757482e-01 1.10234628175723006759945121757482e-01 7.79530743648554014235685372113949e-01 6.25977580797639626686290625912079e-03
 	 1.10234628175723006759945121757482e-01 7.79530743648554014235685372113949e-01 1.10234628175723006759945121757482e-01 6.25977580797639626686290625912079e-03
 	 7.79530743648554014235685372113949e-01 1.10234628175723006759945121757482e-01 1.10234628175723006759945121757482e-01 6.25977580797639626686290625912079e-03
 	 4.68466155978488285605010332801612e-01 4.68466155978488285605010332801612e-01 6.30676880430234287899793343967758e-02 7.53429356032112550189960842317305e-03
 	 4.68466155978488285605010332801612e-01 6.30676880430234287899793343967758e-02 4.68466155978488285605010332801612e-01 7.53429356032112550189960842317305e-03
 	 6.30676880430234287899793343967758e-02 4.68466155978488285605010332801612e-01 4.68466155978488285605010332801612e-01 7.53429356032112550189960842317305e-03
 	 1.73692667715930587624129088908376e-01 1.73692667715930587624129088908376e-01 6.52614664568138769240590590925422e-01 9.13427474706160133499643904997356e-03
 	 1.73692667715930587624129088908376e-01 6.52614664568138769240590590925422e-01 1.73692667715930587624129088908376e-01 9.13427474706160133499643904997356e-03
 	 6.52614664568138769240590590925422e-01 1.73692667715930587624129088908376e-01 1.73692667715930587624129088908376e-01 9.13427474706160133499643904997356e-03
 	 4.10668319049822594379861584457103e-01 4.10668319049822594379861584457103e-01 1.78663361900354811240276831085794e-01 1.19292674837909260660007149112971e-02
 	 4.10668319049822594379861584457103e-01 1.78663361900354811240276831085794e-01 4.10668319049822594379861584457103e-01 1.19292674837909260660007149112971e-02
 	 1.78663361900354811240276831085794e-01 4.10668319049822594379861584457103e-01 4.10668319049822594379861584457103e-01 1.19292674837909260660007149112971e-02
 	 2.49556756982748401130223214750004e-01 2.49556756982748401130223214750004e-01 5.00886486034503253250704801757820e-01 1.22658688223784874404831413130523e-02
 	 2.49556756982748401130223214750004e-01 5.00886486034503253250704801757820e-01 2.49556756982748401130223214750004e-01 1.22658688223784874404831413130523e-02
 	 5.00886486034503253250704801757820e-01 2.49556756982748401130223214750004e-01 2.49556756982748401130223214750004e-01 1.22658688223784874404831413130523e-02
 	 9.80030809579556794197685576364165e-01 1.60168116844335885196048963052817e-02 3.95237873600961728270952733055310e-03 3.75945691771694919577212479211425e-04
 	 9.80030809579556794197685576364165e-01 3.95237873600961728270952733055310e-03 1.60168116844335885196048963052817e-02 3.75945691771694919577212479211425e-04
 	 1.60168116844335885196048963052817e-02 9.80030809579556794197685576364165e-01 3.95237873600961728270952733055310e-03 3.75945691771694919577212479211425e-04
 	 1.60168116844335885196048963052817e-02 3.95237873600961728270952733055310e-03 9.80030809579556794197685576364165e-01 3.75945691771694919577212479211425e-04
 	 3.95237873600961728270952733055310e-03 9.80030809579556794197685576364165e-01 1.60168116844335885196048963052817e-02 3.75945691771694919577212479211425e-04
 	 3.95237873600961728270952733055310e-03 1.60168116844335885196048963052817e-02 9.80030809579556794197685576364165e-01 3.75945691771694919577212479211425e-04
 	 9.56210240585889215125803275441285e-01 4.00653234502971189456843603693414e-02 3.72443596381366592851236418937333e-03 5.77435002003110625645732056909765e-04
 	 9.56210240585889215125803275441285e-01 3.72443596381366592851236418937333e-03 4.00653234502971189456843603693414e-02 5.77435002003110625645732056909765e-04
 	 4.00653234502971189456843603693414e-02 9.56210240585889215125803275441285e-01 3.72443596381366592851236418937333e-03 5.77435002003110625645732056909765e-04
 	 4.00653234502971189456843603693414e-02 3.72443596381366592851236418937333e-03 9.56210240585889215125803275441285e-01 5.77435002003110625645732056909765e-04
 	 3.72443596381366592851236418937333e-03 9.56210240585889215125803275441285e-01 4.00653234502971189456843603693414e-02 5.77435002003110625645732056909765e-04
 	 3.72443596381366592851236418937333e-03 4.00653234502971189456843603693414e-02 9.56210240585889215125803275441285e-01 5.77435002003110625645732056909765e-04
 	 9.18991377915119755925843492150307e-01 7.64894022503812553992474931874312e-02 4.51921983449898867490901466226205e-03 9.95858515622032990782797057249809e-04
 	 9.18991377915119755925843492150307e-01 4.51921983449898867490901466226205e-03 7.64894022503812553992474931874312e-02 9.95858515622032990782797057249809e-04
 	 7.64894022503812553992474931874312e-02 9.18991377915119755925843492150307e-01 4.51921983449898867490901466226205e-03 9.95858515622032990782797057249809e-04
 	 7.64894022503812553992474931874312e-02 4.51921983449898867490901466226205e-03 9.18991377915119755925843492150307e-01 9.95858515622032990782797057249809e-04
 	 4.51921983449898867490901466226205e-03 9.18991377915119755925843492150307e-01 7.64894022503812553992474931874312e-02 9.95858515622032990782797057249809e-04
 	 4.51921983449898867490901466226205e-03 7.64894022503812553992474931874312e-02 9.18991377915119755925843492150307e-01 9.95858515622032990782797057249809e-04
 	 8.69266446632026346108546022151131e-01 1.25877991283982609838076882624591e-01 4.85556208399104405337709522427758e-03 1.38275956888946928435846217553262e-03
 	 8.69266446632026346108546022151131e-01 4.85556208399104405337709522427758e-03 1.25877991283982609838076882624591e-01 1.38275956888946928435846217553262e-03
 	 1.25877991283982609838076882624591e-01 8.69266446632026346108546022151131e-01 4.85556208399104405337709522427758e-03 1.38275956888946928435846217553262e-03
 	 1.25877991283982609838076882624591e-01 4.85556208399104405337709522427758e-03 8.69266446632026346108546022151131e-01 1.38275956888946928435846217553262e-03
 	 4.85556208399104405337709522427758e-03 8.69266446632026346108546022151131e-01 1.25877991283982609838076882624591e-01 1.38275956888946928435846217553262e-03
 	 4.85556208399104405337709522427758e-03 1.25877991283982609838076882624591e-01 8.69266446632026346108546022151131e-01 1.38275956888946928435846217553262e-03
 	 8.08161929939749557050276962399948e-01 1.86984740735145787970949982081947e-01 4.85332932510465497877305551810423e-03 1.64348980314674738938129916476782e-03
 	 8.08161929939749557050276962399948e-01 4.85332932510465497877305551810423e-03 1.86984740735145787970949982081947e-01 1.64348980314674738938129916476782e-03
 	 1.86984740735145787970949982081947e-01 8.08161929939749557050276962399948e-01 4.85332932510465497877305551810423e-03 1.64348980314674738938129916476782e-03
 	 1.86984740735145787970949982081947e-01 4.85332932510465497877305551810423e-03 8.08161929939749557050276962399948e-01 1.64348980314674738938129916476782e-03
 	 4.85332932510465497877305551810423e-03 8.08161929939749557050276962399948e-01 1.86984740735145787970949982081947e-01 1.64348980314674738938129916476782e-03
 	 4.85332932510465497877305551810423e-03 1.86984740735145787970949982081947e-01 8.08161929939749557050276962399948e-01 1.64348980314674738938129916476782e-03
 	 9.31015414728788681664184423425468e-01 4.79634591905694421254402470822242e-02 2.10211260806418762103753294923081e-02 1.73634746626696325443039992109107e-03
 	 9.31015414728788681664184423425468e-01 2.10211260806418762103753294923081e-02 4.79634591905694421254402470822242e-02 1.73634746626696325443039992109107e-03
 	 4.79634591905694421254402470822242e-02 9.31015414728788681664184423425468e-01 2.10211260806418762103753294923081e-02 1.73634746626696325443039992109107e-03
 	 4.79634591905694421254402470822242e-02 2.10211260806418762103753294923081e-02 9.31015414728788681664184423425468e-01 1.73634746626696325443039992109107e-03
 	 2.10211260806418762103753294923081e-02 9.31015414728788681664184423425468e-01 4.79634591905694421254402470822242e-02 1.73634746626696325443039992109107e-03
 	 2.10211260806418762103753294923081e-02 4.79634591905694421254402470822242e-02 9.31015414728788681664184423425468e-01 1.73634746626696325443039992109107e-03
 	 7.38140363468471782937285752268508e-01 2.56995801448648197862212327891029e-01 4.86383508288001920050191984046251e-03 1.82964695987906651557242110328616e-03
 	 7.38140363468471782937285752268508e-01 4.86383508288001920050191984046251e-03 2.56995801448648197862212327891029e-01 1.82964695987906651557242110328616e-03
 	 2.56995801448648197862212327891029e-01 7.38140363468471782937285752268508e-01 4.86383508288001920050191984046251e-03 1.82964695987906651557242110328616e-03
 	 2.56995801448648197862212327891029e-01 4.86383508288001920050191984046251e-03 7.38140363468471782937285752268508e-01 1.82964695987906651557242110328616e-03
 	 4.86383508288001920050191984046251e-03 7.38140363468471782937285752268508e-01 2.56995801448648197862212327891029e-01 1.82964695987906651557242110328616e-03
 	 4.86383508288001920050191984046251e-03 2.56995801448648197862212327891029e-01 7.38140363468471782937285752268508e-01 1.82964695987906651557242110328616e-03
 	 6.61964863274292047989888487791177e-01 3.33118225448962690382614937334438e-01 4.91691127674526162749657487438526e-03 1.98073891497663884253555011127901e-03
 	 6.61964863274292047989888487791177e-01 4.91691127674526162749657487438526e-03 3.33118225448962690382614937334438e-01 1.98073891497663884253555011127901e-03
 	 3.33118225448962690382614937334438e-01 6.61964863274292047989888487791177e-01 4.91691127674526162749657487438526e-03 1.98073891497663884253555011127901e-03
 	 3.33118225448962690382614937334438e-01 4.91691127674526162749657487438526e-03 6.61964863274292047989888487791177e-01 1.98073891497663884253555011127901e-03
 	 4.91691127674526162749657487438526e-03 6.61964863274292047989888487791177e-01 3.33118225448962690382614937334438e-01 1.98073891497663884253555011127901e-03
 	 4.91691127674526162749657487438526e-03 3.33118225448962690382614937334438e-01 6.61964863274292047989888487791177e-01 1.98073891497663884253555011127901e-03
 	 5.81189175108862587926239484659163e-01 4.13846657841551113232725356283481e-01 4.96416704958629884103515905735549e-03 2.10067434347353159188043214555819e-03
 	 5.81189175108862587926239484659163e-01 4.96416704958629884103515905735549e-03 4.13846657841551113232725356283481e-01 2.10067434347353159188043214555819e-03
 	 4.13846657841551113232725356283481e-01 5.81189175108862587926239484659163e-01 4.96416704958629884103515905735549e-03 2.10067434347353159188043214555819e-03
 	 4.13846657841551113232725356283481e-01 4.96416704958629884103515905735549e-03 5.81189175108862587926239484659163e-01 2.10067434347353159188043214555819e-03
 	 4.96416704958629884103515905735549e-03 5.81189175108862587926239484659163e-01 4.13846657841551113232725356283481e-01 2.10067434347353159188043214555819e-03
 	 4.96416704958629884103515905735549e-03 4.13846657841551113232725356283481e-01 5.81189175108862587926239484659163e-01 2.10067434347353159188043214555819e-03
 	 8.84274577566924291360805909789633e-01 9.11814742788630838710162151983241e-02 2.45439481542126247681778750120429e-02 2.76209123159389027118981729813640e-03
 	 8.84274577566924291360805909789633e-01 2.45439481542126247681778750120429e-02 9.11814742788630838710162151983241e-02 2.76209123159389027118981729813640e-03
 	 9.11814742788630838710162151983241e-02 8.84274577566924291360805909789633e-01 2.45439481542126247681778750120429e-02 2.76209123159389027118981729813640e-03
 	 9.11814742788630838710162151983241e-02 2.45439481542126247681778750120429e-02 8.84274577566924291360805909789633e-01 2.76209123159389027118981729813640e-03
 	 2.45439481542126247681778750120429e-02 8.84274577566924291360805909789633e-01 9.11814742788630838710162151983241e-02 2.76209123159389027118981729813640e-03
 	 2.45439481542126247681778750120429e-02 9.11814742788630838710162151983241e-02 8.84274577566924291360805909789633e-01 2.76209123159389027118981729813640e-03
 	 8.27639190276168834614622937806416e-01 1.46943421195845608240304613900662e-01 2.54173885279855571450724482929218e-02 3.46900940527538736296575549999943e-03
 	 8.27639190276168834614622937806416e-01 2.54173885279855571450724482929218e-02 1.46943421195845608240304613900662e-01 3.46900940527538736296575549999943e-03
 	 1.46943421195845608240304613900662e-01 8.27639190276168834614622937806416e-01 2.54173885279855571450724482929218e-02 3.46900940527538736296575549999943e-03
 	 1.46943421195845608240304613900662e-01 2.54173885279855571450724482929218e-02 8.27639190276168834614622937806416e-01 3.46900940527538736296575549999943e-03
 	 2.54173885279855571450724482929218e-02 8.27639190276168834614622937806416e-01 1.46943421195845608240304613900662e-01 3.46900940527538736296575549999943e-03
 	 2.54173885279855571450724482929218e-02 1.46943421195845608240304613900662e-01 8.27639190276168834614622937806416e-01 3.46900940527538736296575549999943e-03
 	 7.62587568566484019783047187956981e-01 2.12066839505368087692716017045313e-01 2.53455919281478925242367949977051e-02 3.92705197335924127699513519473840e-03
 	 7.62587568566484019783047187956981e-01 2.53455919281478925242367949977051e-02 2.12066839505368087692716017045313e-01 3.92705197335924127699513519473840e-03
 	 2.12066839505368087692716017045313e-01 7.62587568566484019783047187956981e-01 2.53455919281478925242367949977051e-02 3.92705197335924127699513519473840e-03
 	 2.12066839505368087692716017045313e-01 2.53455919281478925242367949977051e-02 7.62587568566484019783047187956981e-01 3.92705197335924127699513519473840e-03
 	 2.53455919281478925242367949977051e-02 7.62587568566484019783047187956981e-01 2.12066839505368087692716017045313e-01 3.92705197335924127699513519473840e-03
 	 2.53455919281478925242367949977051e-02 2.12066839505368087692716017045313e-01 7.62587568566484019783047187956981e-01 3.92705197335924127699513519473840e-03
 	 6.90118710560342352167140234087128e-01 2.84342556304586491222607946838252e-01 2.55387331350711566102518190746196e-02 4.32349605661387116628535665086019e-03
 	 6.90118710560342352167140234087128e-01 2.55387331350711566102518190746196e-02 2.84342556304586491222607946838252e-01 4.32349605661387116628535665086019e-03
 	 2.84342556304586491222607946838252e-01 6.90118710560342352167140234087128e-01 2.55387331350711566102518190746196e-02 4.32349605661387116628535665086019e-03
 	 2.84342556304586491222607946838252e-01 2.55387331350711566102518190746196e-02 6.90118710560342352167140234087128e-01 4.32349605661387116628535665086019e-03
 	 2.55387331350711566102518190746196e-02 6.90118710560342352167140234087128e-01 2.84342556304586491222607946838252e-01 4.32349605661387116628535665086019e-03
 	 2.55387331350711566102518190746196e-02 2.84342556304586491222607946838252e-01 6.90118710560342352167140234087128e-01 4.32349605661387116628535665086019e-03
 	 8.38318567454823804219188332353951e-01 1.01421462494414804655917805575882e-01 6.02599700507613911248938620701665e-02 4.55352437922785981821993672724602e-03
 	 8.38318567454823804219188332353951e-01 6.02599700507613911248938620701665e-02 1.01421462494414804655917805575882e-01 4.55352437922785981821993672724602e-03
 	 1.01421462494414804655917805575882e-01 8.38318567454823804219188332353951e-01 6.02599700507613911248938620701665e-02 4.55352437922785981821993672724602e-03
 	 1.01421462494414804655917805575882e-01 6.02599700507613911248938620701665e-02 8.38318567454823804219188332353951e-01 4.55352437922785981821993672724602e-03
 	 6.02599700507613911248938620701665e-02 8.38318567454823804219188332353951e-01 1.01421462494414804655917805575882e-01 4.55352437922785981821993672724602e-03
 	 6.02599700507613911248938620701665e-02 1.01421462494414804655917805575882e-01 8.38318567454823804219188332353951e-01 4.55352437922785981821993672724602e-03
 	 6.11809416665966332438131303206319e-01 3.62362307698883112649923532444518e-01 2.58282756351505549119451643491630e-02 4.67622936259784720974819194339034e-03
 	 6.11809416665966332438131303206319e-01 2.58282756351505549119451643491630e-02 3.62362307698883112649923532444518e-01 4.67622936259784720974819194339034e-03
 	 3.62362307698883112649923532444518e-01 6.11809416665966332438131303206319e-01 2.58282756351505549119451643491630e-02 4.67622936259784720974819194339034e-03
 	 3.62362307698883112649923532444518e-01 2.58282756351505549119451643491630e-02 6.11809416665966332438131303206319e-01 4.67622936259784720974819194339034e-03
 	 2.58282756351505549119451643491630e-02 6.11809416665966332438131303206319e-01 3.62362307698883112649923532444518e-01 4.67622936259784720974819194339034e-03
 	 2.58282756351505549119451643491630e-02 3.62362307698883112649923532444518e-01 6.11809416665966332438131303206319e-01 4.67622936259784720974819194339034e-03
 	 5.29148852224488042139682875131257e-01 4.44835853963697180901704086863901e-01 2.60152938118147769586130380048417e-02 4.90579532447954751867014167032721e-03
 	 5.29148852224488042139682875131257e-01 2.60152938118147769586130380048417e-02 4.44835853963697180901704086863901e-01 4.90579532447954751867014167032721e-03
 	 4.44835853963697180901704086863901e-01 5.29148852224488042139682875131257e-01 2.60152938118147769586130380048417e-02 4.90579532447954751867014167032721e-03
 	 4.44835853963697180901704086863901e-01 2.60152938118147769586130380048417e-02 5.29148852224488042139682875131257e-01 4.90579532447954751867014167032721e-03
 	 2.60152938118147769586130380048417e-02 5.29148852224488042139682875131257e-01 4.44835853963697180901704086863901e-01 4.90579532447954751867014167032721e-03
 	 2.60152938118147769586130380048417e-02 4.44835853963697180901704086863901e-01 5.29148852224488042139682875131257e-01 4.90579532447954751867014167032721e-03
 	 7.78589579815803345397284829232376e-01 1.59964054253387194526325743026973e-01 6.14463659308094600763894277406507e-02 5.49383485445365925964322784125216e-03
 	 7.78589579815803345397284829232376e-01 6.14463659308094600763894277406507e-02 1.59964054253387194526325743026973e-01 5.49383485445365925964322784125216e-03
 	 1.59964054253387194526325743026973e-01 7.78589579815803345397284829232376e-01 6.14463659308094600763894277406507e-02 5.49383485445365925964322784125216e-03
 	 1.59964054253387194526325743026973e-01 6.14463659308094600763894277406507e-02 7.78589579815803345397284829232376e-01 5.49383485445365925964322784125216e-03
 	 6.14463659308094600763894277406507e-02 7.78589579815803345397284829232376e-01 1.59964054253387194526325743026973e-01 5.49383485445365925964322784125216e-03
 	 6.14463659308094600763894277406507e-02 1.59964054253387194526325743026973e-01 7.78589579815803345397284829232376e-01 5.49383485445365925964322784125216e-03
 	 7.10623785618018422027830638398882e-01 2.27893984493791390555372800008627e-01 6.14822298881901874167965615924913e-02 6.28606573294139200913654974556266e-03
 	 7.10623785618018422027830638398882e-01 6.14822298881901874167965615924913e-02 2.27893984493791390555372800008627e-01 6.28606573294139200913654974556266e-03
 	 2.27893984493791390555372800008627e-01 7.10623785618018422027830638398882e-01 6.14822298881901874167965615924913e-02 6.28606573294139200913654974556266e-03
 	 2.27893984493791390555372800008627e-01 6.14822298881901874167965615924913e-02 7.10623785618018422027830638398882e-01 6.28606573294139200913654974556266e-03
 	 6.14822298881901874167965615924913e-02 7.10623785618018422027830638398882e-01 2.27893984493791390555372800008627e-01 6.28606573294139200913654974556266e-03
 	 6.14822298881901874167965615924913e-02 2.27893984493791390555372800008627e-01 7.10623785618018422027830638398882e-01 6.28606573294139200913654974556266e-03
 	 6.34277654844068061734674301987980e-01 3.03562715120035075955229331157170e-01 6.21596300358968623100963668548502e-02 6.94363231297645717987609970123231e-03
 	 6.34277654844068061734674301987980e-01 6.21596300358968623100963668548502e-02 3.03562715120035075955229331157170e-01 6.94363231297645717987609970123231e-03
 	 3.03562715120035075955229331157170e-01 6.34277654844068061734674301987980e-01 6.21596300358968623100963668548502e-02 6.94363231297645717987609970123231e-03
 	 3.03562715120035075955229331157170e-01 6.21596300358968623100963668548502e-02 6.34277654844068061734674301987980e-01 6.94363231297645717987609970123231e-03
 	 6.21596300358968623100963668548502e-02 6.34277654844068061734674301987980e-01 3.03562715120035075955229331157170e-01 6.94363231297645717987609970123231e-03
 	 6.21596300358968623100963668548502e-02 3.03562715120035075955229331157170e-01 6.34277654844068061734674301987980e-01 6.94363231297645717987609970123231e-03
 	 5.52626687887675771548856573645025e-01 3.84560072995415613839043089683400e-01 6.28132391169086146121003366715740e-02 7.37828444684602256786742913163835e-03
 	 5.52626687887675771548856573645025e-01 6.28132391169086146121003366715740e-02 3.84560072995415613839043089683400e-01 7.37828444684602256786742913163835e-03
 	 3.84560072995415613839043089683400e-01 5.52626687887675771548856573645025e-01 6.28132391169086146121003366715740e-02 7.37828444684602256786742913163835e-03
 	 3.84560072995415613839043089683400e-01 6.28132391169086146121003366715740e-02 5.52626687887675771548856573645025e-01 7.37828444684602256786742913163835e-03
 	 6.28132391169086146121003366715740e-02 5.52626687887675771548856573645025e-01 3.84560072995415613839043089683400e-01 7.37828444684602256786742913163835e-03
 	 6.28132391169086146121003366715740e-02 3.84560072995415613839043089683400e-01 5.52626687887675771548856573645025e-01 7.37828444684602256786742913163835e-03
 	 7.16871672741206555912185649503954e-01 1.71646103407863792611465214577038e-01 1.11482223850929651476349135919008e-01 7.49645973918371989752618134161821e-03
 	 7.16871672741206555912185649503954e-01 1.11482223850929651476349135919008e-01 1.71646103407863792611465214577038e-01 7.49645973918371989752618134161821e-03
 	 1.71646103407863792611465214577038e-01 7.16871672741206555912185649503954e-01 1.11482223850929651476349135919008e-01 7.49645973918371989752618134161821e-03
 	 1.71646103407863792611465214577038e-01 1.11482223850929651476349135919008e-01 7.16871672741206555912185649503954e-01 7.49645973918371989752618134161821e-03
 	 1.11482223850929651476349135919008e-01 7.16871672741206555912185649503954e-01 1.71646103407863792611465214577038e-01 7.49645973918371989752618134161821e-03
 	 1.11482223850929651476349135919008e-01 1.71646103407863792611465214577038e-01 7.16871672741206555912185649503954e-01 7.49645973918371989752618134161821e-03
 	 6.45570482899384456842994950420689e-01 2.42254408443608210133035640865273e-01 1.12175108657007333023969408714038e-01 8.52180142423136256779603314726046e-03
 	 6.45570482899384456842994950420689e-01 1.12175108657007333023969408714038e-01 2.42254408443608210133035640865273e-01 8.52180142423136256779603314726046e-03
 	 2.42254408443608210133035640865273e-01 6.45570482899384456842994950420689e-01 1.12175108657007333023969408714038e-01 8.52180142423136256779603314726046e-03
 	 2.42254408443608210133035640865273e-01 1.12175108657007333023969408714038e-01 6.45570482899384456842994950420689e-01 8.52180142423136256779603314726046e-03
 	 1.12175108657007333023969408714038e-01 6.45570482899384456842994950420689e-01 2.42254408443608210133035640865273e-01 8.52180142423136256779603314726046e-03
 	 1.12175108657007333023969408714038e-01 2.42254408443608210133035640865273e-01 6.45570482899384456842994950420689e-01 8.52180142423136256779603314726046e-03
 	 5.66843738230966565083690511528403e-01 3.19581218448555692823731533280807e-01 1.13575043320477742092577955190791e-01 9.26229049718128513712933624901780e-03
 	 5.66843738230966565083690511528403e-01 1.13575043320477742092577955190791e-01 3.19581218448555692823731533280807e-01 9.26229049718128513712933624901780e-03
 	 3.19581218448555692823731533280807e-01 5.66843738230966565083690511528403e-01 1.13575043320477742092577955190791e-01 9.26229049718128513712933624901780e-03
 	 3.19581218448555692823731533280807e-01 1.13575043320477742092577955190791e-01 5.66843738230966565083690511528403e-01 9.26229049718128513712933624901780e-03
 	 1.13575043320477742092577955190791e-01 5.66843738230966565083690511528403e-01 3.19581218448555692823731533280807e-01 9.26229049718128513712933624901780e-03
 	 1.13575043320477742092577955190791e-01 3.19581218448555692823731533280807e-01 5.66843738230966565083690511528403e-01 9.26229049718128513712933624901780e-03
 	 4.84400341724708916046893136808649e-01 4.01102153748808587518936974447570e-01 1.14497504526482496434169888743781e-01 9.65530625783580891130508661035492e-03
 	 4.84400341724708916046893136808649e-01 1.14497504526482496434169888743781e-01 4.01102153748808587518936974447570e-01 9.65530625783580891130508661035492e-03
 	 4.01102153748808587518936974447570e-01 4.84400341724708916046893136808649e-01 1.14497504526482496434169888743781e-01 9.65530625783580891130508661035492e-03
 	 4.01102153748808587518936974447570e-01 1.14497504526482496434169888743781e-01 4.84400341724708916046893136808649e-01 9.65530625783580891130508661035492e-03
 	 1.14497504526482496434169888743781e-01 4.84400341724708916046893136808649e-01 4.01102153748808587518936974447570e-01 9.65530625783580891130508661035492e-03
 	 1.14497504526482496434169888743781e-01 4.01102153748808587518936974447570e-01 4.84400341724708916046893136808649e-01 9.65530625783580891130508661035492e-03
 	 5.78477356973128076234047512116376e-01 2.45951501392227489528607975444174e-01 1.75571141634644434237344512439449e-01 1.05623976932279796392410986527466e-02
 	 5.78477356973128076234047512116376e-01 1.75571141634644434237344512439449e-01 2.45951501392227489528607975444174e-01 1.05623976932279796392410986527466e-02
 	 2.45951501392227489528607975444174e-01 5.78477356973128076234047512116376e-01 1.75571141634644434237344512439449e-01 1.05623976932279796392410986527466e-02
 	 2.45951501392227489528607975444174e-01 1.75571141634644434237344512439449e-01 5.78477356973128076234047512116376e-01 1.05623976932279796392410986527466e-02
 	 1.75571141634644434237344512439449e-01 5.78477356973128076234047512116376e-01 2.45951501392227489528607975444174e-01 1.05623976932279796392410986527466e-02
 	 1.75571141634644434237344512439449e-01 2.45951501392227489528607975444174e-01 5.78477356973128076234047512116376e-01 1.05623976932279796392410986527466e-02
 	 4.96282829301863182003273777809227e-01 3.25942627323928924010232321961666e-01 1.77774543374207893986493900229107e-01 1.15638068495021225506880213629302e-02
 	 4.96282829301863182003273777809227e-01 1.77774543374207893986493900229107e-01 3.25942627323928924010232321961666e-01 1.15638068495021225506880213629302e-02
 	 3.25942627323928924010232321961666e-01 4.96282829301863182003273777809227e-01 1.77774543374207893986493900229107e-01 1.15638068495021225506880213629302e-02
 	 3.25942627323928924010232321961666e-01 1.77774543374207893986493900229107e-01 4.96282829301863182003273777809227e-01 1.15638068495021225506880213629302e-02
 	 1.77774543374207893986493900229107e-01 4.96282829301863182003273777809227e-01 3.25942627323928924010232321961666e-01 1.15638068495021225506880213629302e-02
 	 1.77774543374207893986493900229107e-01 3.25942627323928924010232321961666e-01 4.96282829301863182003273777809227e-01 1.15638068495021225506880213629302e-02
 	 4.16568600024703472595177800030797e-01 3.31203743439010322990867507542134e-01 2.52227656536286148902803461169242e-01 1.32067902710617489370203969656359e-02
 	 4.16568600024703472595177800030797e-01 2.52227656536286148902803461169242e-01 3.31203743439010322990867507542134e-01 1.32067902710617489370203969656359e-02
 	 3.31203743439010322990867507542134e-01 4.16568600024703472595177800030797e-01 2.52227656536286148902803461169242e-01 1.32067902710617489370203969656359e-02
 	 3.31203743439010322990867507542134e-01 2.52227656536286148902803461169242e-01 4.16568600024703472595177800030797e-01 1.32067902710617489370203969656359e-02
 	 2.52227656536286148902803461169242e-01 4.16568600024703472595177800030797e-01 3.31203743439010322990867507542134e-01 1.32067902710617489370203969656359e-02
 	 2.52227656536286148902803461169242e-01 3.31203743439010322990867507542134e-01 4.16568600024703472595177800030797e-01 1.32067902710617489370203969656359e-02
 	 ];
 
 	 case  32 

 	 % ALG. DEG.:   32
 	 % PTS CARD.:  210
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.1e-12  

 	 xyw_bar=[
 	 3.19145350613714295917588970041834e-03 3.19145350613714295917588970041834e-03 9.93617092987725714081648220599163e-01 1.43085923905883374666891949544834e-04
 	 3.19145350613714295917588970041834e-03 9.93617092987725714081648220599163e-01 3.19145350613714295917588970041834e-03 1.43085923905883374666891949544834e-04
 	 9.93617092987725714081648220599163e-01 3.19145350613714295917588970041834e-03 3.19145350613714295917588970041834e-03 1.43085923905883374666891949544834e-04
 	 1.64655689217531008006201176385730e-02 1.64655689217531008006201176385730e-02 9.67068862156493791459865860815626e-01 5.54996635628749704523265950939503e-04
 	 1.64655689217531008006201176385730e-02 9.67068862156493791459865860815626e-01 1.64655689217531008006201176385730e-02 5.54996635628749704523265950939503e-04
 	 9.67068862156493791459865860815626e-01 1.64655689217531008006201176385730e-02 1.64655689217531008006201176385730e-02 5.54996635628749704523265950939503e-04
 	 4.98495116354507120104422313033865e-02 4.98495116354507120104422313033865e-02 9.00300976729098589856903345207684e-01 2.84820867499269289244145930695140e-03
 	 4.98495116354507120104422313033865e-02 9.00300976729098589856903345207684e-01 4.98495116354507120104422313033865e-02 2.84820867499269289244145930695140e-03
 	 9.00300976729098589856903345207684e-01 4.98495116354507120104422313033865e-02 4.98495116354507120104422313033865e-02 2.84820867499269289244145930695140e-03
 	 4.88219324361224116248791915495531e-01 4.88219324361224116248791915495531e-01 2.35613512775517675024161690089386e-02 4.23536581736003343856555858337742e-03
 	 4.88219324361224116248791915495531e-01 2.35613512775517675024161690089386e-02 4.88219324361224116248791915495531e-01 4.23536581736003343856555858337742e-03
 	 2.35613512775517675024161690089386e-02 4.88219324361224116248791915495531e-01 4.88219324361224116248791915495531e-01 4.23536581736003343856555858337742e-03
 	 9.41148599404452168570855974394362e-02 9.41148599404452168570855974394362e-02 8.11770280119109566285828805121128e-01 4.64365914462629755105060880282508e-03
 	 9.41148599404452168570855974394362e-02 8.11770280119109566285828805121128e-01 9.41148599404452168570855974394362e-02 4.64365914462629755105060880282508e-03
 	 8.11770280119109566285828805121128e-01 9.41148599404452168570855974394362e-02 9.41148599404452168570855974394362e-02 4.64365914462629755105060880282508e-03
 	 1.56836966605033101274102591560222e-01 1.56836966605033101274102591560222e-01 6.86326066789933797451794816879556e-01 7.75487814088178083887781255612026e-03
 	 1.56836966605033101274102591560222e-01 6.86326066789933797451794816879556e-01 1.56836966605033101274102591560222e-01 7.75487814088178083887781255612026e-03
 	 6.86326066789933797451794816879556e-01 1.56836966605033101274102591560222e-01 1.56836966605033101274102591560222e-01 7.75487814088178083887781255612026e-03
 	 4.47917974916259398199258612294216e-01 4.47917974916259398199258612294216e-01 1.04164050167481203601482775411569e-01 8.87199984568198471435174212729180e-03
 	 4.47917974916259398199258612294216e-01 1.04164050167481203601482775411569e-01 4.47917974916259398199258612294216e-01 8.87199984568198471435174212729180e-03
 	 1.04164050167481203601482775411569e-01 4.47917974916259398199258612294216e-01 4.47917974916259398199258612294216e-01 8.87199984568198471435174212729180e-03
 	 2.27359360510421992795926371400128e-01 2.27359360510421992795926371400128e-01 5.45281278979156014408147257199744e-01 1.03947593390418483588755194091391e-02
 	 2.27359360510421992795926371400128e-01 5.45281278979156014408147257199744e-01 2.27359360510421992795926371400128e-01 1.03947593390418483588755194091391e-02
 	 5.45281278979156014408147257199744e-01 2.27359360510421992795926371400128e-01 2.27359360510421992795926371400128e-01 1.03947593390418483588755194091391e-02
 	 3.84316624257353078863985729185515e-01 3.84316624257353078863985729185515e-01 2.31366751485293842272028541628970e-01 1.19592550228701938186404163388943e-02
 	 3.84316624257353078863985729185515e-01 2.31366751485293842272028541628970e-01 3.84316624257353078863985729185515e-01 1.19592550228701938186404163388943e-02
 	 2.31366751485293842272028541628970e-01 3.84316624257353078863985729185515e-01 3.84316624257353078863985729185515e-01 1.19592550228701938186404163388943e-02
 	 3.06547093374997525749847682163818e-01 3.06547093374997525749847682163818e-01 3.86905813250004948500304635672364e-01 1.24933120762862181346575241036589e-02
 	 3.06547093374997525749847682163818e-01 3.86905813250004948500304635672364e-01 3.06547093374997525749847682163818e-01 1.24933120762862181346575241036589e-02
 	 3.86905813250004948500304635672364e-01 3.06547093374997525749847682163818e-01 3.06547093374997525749847682163818e-01 1.24933120762862181346575241036589e-02
 	 9.78394604898897179978689564450178e-01 1.78715560661563098443505026580169e-02 3.73383903494651017695993289180478e-03 3.65304520957829444421233189288500e-04
 	 9.78394604898897179978689564450178e-01 3.73383903494651017695993289180478e-03 1.78715560661563098443505026580169e-02 3.65304520957829444421233189288500e-04
 	 1.78715560661563098443505026580169e-02 9.78394604898897179978689564450178e-01 3.73383903494651017695993289180478e-03 3.65304520957829444421233189288500e-04
 	 1.78715560661563098443505026580169e-02 3.73383903494651017695993289180478e-03 9.78394604898897179978689564450178e-01 3.65304520957829444421233189288500e-04
 	 3.73383903494651017695993289180478e-03 9.78394604898897179978689564450178e-01 1.78715560661563098443505026580169e-02 3.65304520957829444421233189288500e-04
 	 3.73383903494651017695993289180478e-03 1.78715560661563098443505026580169e-02 9.78394604898897179978689564450178e-01 3.65304520957829444421233189288500e-04
 	 9.57376599458149901700210193666862e-01 3.94715791578275077000625969958492e-02 3.15182138402259059972720933728851e-03 3.72432834557410660531601154232817e-04
 	 9.57376599458149901700210193666862e-01 3.15182138402259059972720933728851e-03 3.94715791578275077000625969958492e-02 3.72432834557410660531601154232817e-04
 	 3.94715791578275077000625969958492e-02 9.57376599458149901700210193666862e-01 3.15182138402259059972720933728851e-03 3.72432834557410660531601154232817e-04
 	 3.94715791578275077000625969958492e-02 3.15182138402259059972720933728851e-03 9.57376599458149901700210193666862e-01 3.72432834557410660531601154232817e-04
 	 3.15182138402259059972720933728851e-03 9.57376599458149901700210193666862e-01 3.94715791578275077000625969958492e-02 3.72432834557410660531601154232817e-04
 	 3.15182138402259059972720933728851e-03 3.94715791578275077000625969958492e-02 9.57376599458149901700210193666862e-01 3.72432834557410660531601154232817e-04
 	 9.29763016779499351649462823843351e-01 6.62735149105613263742498020292260e-02 3.96346830993932197628737412742339e-03 7.06032907776358523849191684007565e-04
 	 9.29763016779499351649462823843351e-01 3.96346830993932197628737412742339e-03 6.62735149105613263742498020292260e-02 7.06032907776358523849191684007565e-04
 	 6.62735149105613263742498020292260e-02 9.29763016779499351649462823843351e-01 3.96346830993932197628737412742339e-03 7.06032907776358523849191684007565e-04
 	 6.62735149105613263742498020292260e-02 3.96346830993932197628737412742339e-03 9.29763016779499351649462823843351e-01 7.06032907776358523849191684007565e-04
 	 3.96346830993932197628737412742339e-03 9.29763016779499351649462823843351e-01 6.62735149105613263742498020292260e-02 7.06032907776358523849191684007565e-04
 	 3.96346830993932197628737412742339e-03 6.62735149105613263742498020292260e-02 9.29763016779499351649462823843351e-01 7.06032907776358523849191684007565e-04
 	 8.85614537945915492045401151699480e-01 1.10207799879050105662514624782489e-01 4.17766217503440229208422351803165e-03 1.11236381582282607173584043636083e-03
 	 8.85614537945915492045401151699480e-01 4.17766217503440229208422351803165e-03 1.10207799879050105662514624782489e-01 1.11236381582282607173584043636083e-03
 	 1.10207799879050105662514624782489e-01 8.85614537945915492045401151699480e-01 4.17766217503440229208422351803165e-03 1.11236381582282607173584043636083e-03
 	 1.10207799879050105662514624782489e-01 4.17766217503440229208422351803165e-03 8.85614537945915492045401151699480e-01 1.11236381582282607173584043636083e-03
 	 4.17766217503440229208422351803165e-03 8.85614537945915492045401151699480e-01 1.10207799879050105662514624782489e-01 1.11236381582282607173584043636083e-03
 	 4.17766217503440229208422351803165e-03 1.10207799879050105662514624782489e-01 8.85614537945915492045401151699480e-01 1.11236381582282607173584043636083e-03
 	 8.27604925832203464075575993774692e-01 1.68070571855654687931647117693501e-01 4.32450231214184799277688853180734e-03 1.39183250065585593056860513883066e-03
 	 8.27604925832203464075575993774692e-01 4.32450231214184799277688853180734e-03 1.68070571855654687931647117693501e-01 1.39183250065585593056860513883066e-03
 	 1.68070571855654687931647117693501e-01 8.27604925832203464075575993774692e-01 4.32450231214184799277688853180734e-03 1.39183250065585593056860513883066e-03
 	 1.68070571855654687931647117693501e-01 4.32450231214184799277688853180734e-03 8.27604925832203464075575993774692e-01 1.39183250065585593056860513883066e-03
 	 4.32450231214184799277688853180734e-03 8.27604925832203464075575993774692e-01 1.68070571855654687931647117693501e-01 1.39183250065585593056860513883066e-03
 	 4.32450231214184799277688853180734e-03 1.68070571855654687931647117693501e-01 8.27604925832203464075575993774692e-01 1.39183250065585593056860513883066e-03
 	 9.40702526955874196445961388235446e-01 4.04066851818969396958891593385488e-02 1.88907878622288638581494524260052e-02 1.41436644369290968718810841409095e-03
 	 9.40702526955874196445961388235446e-01 1.88907878622288638581494524260052e-02 4.04066851818969396958891593385488e-02 1.41436644369290968718810841409095e-03
 	 4.04066851818969396958891593385488e-02 9.40702526955874196445961388235446e-01 1.88907878622288638581494524260052e-02 1.41436644369290968718810841409095e-03
 	 4.04066851818969396958891593385488e-02 1.88907878622288638581494524260052e-02 9.40702526955874196445961388235446e-01 1.41436644369290968718810841409095e-03
 	 1.88907878622288638581494524260052e-02 9.40702526955874196445961388235446e-01 4.04066851818969396958891593385488e-02 1.41436644369290968718810841409095e-03
 	 1.88907878622288638581494524260052e-02 4.04066851818969396958891593385488e-02 9.40702526955874196445961388235446e-01 1.41436644369290968718810841409095e-03
 	 7.61456947235597203516022091207560e-01 2.34130448558700909877927642810391e-01 4.41260420570188660605026598204859e-03 1.55161657663138849091999382778795e-03
 	 7.61456947235597203516022091207560e-01 4.41260420570188660605026598204859e-03 2.34130448558700909877927642810391e-01 1.55161657663138849091999382778795e-03
 	 2.34130448558700909877927642810391e-01 7.61456947235597203516022091207560e-01 4.41260420570188660605026598204859e-03 1.55161657663138849091999382778795e-03
 	 2.34130448558700909877927642810391e-01 4.41260420570188660605026598204859e-03 7.61456947235597203516022091207560e-01 1.55161657663138849091999382778795e-03
 	 4.41260420570188660605026598204859e-03 7.61456947235597203516022091207560e-01 2.34130448558700909877927642810391e-01 1.55161657663138849091999382778795e-03
 	 4.41260420570188660605026598204859e-03 2.34130448558700909877927642810391e-01 7.61456947235597203516022091207560e-01 1.55161657663138849091999382778795e-03
 	 6.91098245011027567663575155165745e-01 3.04467727385771491643851049957448e-01 4.43402760320094069257379487680737e-03 1.63602214654361578088925810448018e-03
 	 6.91098245011027567663575155165745e-01 4.43402760320094069257379487680737e-03 3.04467727385771491643851049957448e-01 1.63602214654361578088925810448018e-03
 	 3.04467727385771491643851049957448e-01 6.91098245011027567663575155165745e-01 4.43402760320094069257379487680737e-03 1.63602214654361578088925810448018e-03
 	 3.04467727385771491643851049957448e-01 4.43402760320094069257379487680737e-03 6.91098245011027567663575155165745e-01 1.63602214654361578088925810448018e-03
 	 4.43402760320094069257379487680737e-03 6.91098245011027567663575155165745e-01 3.04467727385771491643851049957448e-01 1.63602214654361578088925810448018e-03
 	 4.43402760320094069257379487680737e-03 3.04467727385771491643851049957448e-01 6.91098245011027567663575155165745e-01 1.63602214654361578088925810448018e-03
 	 6.16960568881680049280191724392353e-01 3.78576515897704413138313839226612e-01 4.46291522061553758149443638103548e-03 1.74911403514991354267438250502664e-03
 	 6.16960568881680049280191724392353e-01 4.46291522061553758149443638103548e-03 3.78576515897704413138313839226612e-01 1.74911403514991354267438250502664e-03
 	 3.78576515897704413138313839226612e-01 6.16960568881680049280191724392353e-01 4.46291522061553758149443638103548e-03 1.74911403514991354267438250502664e-03
 	 3.78576515897704413138313839226612e-01 4.46291522061553758149443638103548e-03 6.16960568881680049280191724392353e-01 1.74911403514991354267438250502664e-03
 	 4.46291522061553758149443638103548e-03 6.16960568881680049280191724392353e-01 3.78576515897704413138313839226612e-01 1.74911403514991354267438250502664e-03
 	 4.46291522061553758149443638103548e-03 3.78576515897704413138313839226612e-01 6.16960568881680049280191724392353e-01 1.74911403514991354267438250502664e-03
 	 5.38216147161168834145428263582289e-01 4.57285169383451983726729395129951e-01 4.49868345537918212784234128776006e-03 1.85624168262133164980509647534745e-03
 	 5.38216147161168834145428263582289e-01 4.49868345537918212784234128776006e-03 4.57285169383451983726729395129951e-01 1.85624168262133164980509647534745e-03
 	 4.57285169383451983726729395129951e-01 5.38216147161168834145428263582289e-01 4.49868345537918212784234128776006e-03 1.85624168262133164980509647534745e-03
 	 4.57285169383451983726729395129951e-01 4.49868345537918212784234128776006e-03 5.38216147161168834145428263582289e-01 1.85624168262133164980509647534745e-03
 	 4.49868345537918212784234128776006e-03 5.38216147161168834145428263582289e-01 4.57285169383451983726729395129951e-01 1.85624168262133164980509647534745e-03
 	 4.49868345537918212784234128776006e-03 4.57285169383451983726729395129951e-01 5.38216147161168834145428263582289e-01 1.85624168262133164980509647534745e-03
 	 8.99401392370100527529075407073833e-01 7.94579312680107063826540070294868e-02 2.11406763618887660882705858966801e-02 2.20979001484625193693633882219274e-03
 	 8.99401392370100527529075407073833e-01 2.11406763618887660882705858966801e-02 7.94579312680107063826540070294868e-02 2.20979001484625193693633882219274e-03
 	 7.94579312680107063826540070294868e-02 8.99401392370100527529075407073833e-01 2.11406763618887660882705858966801e-02 2.20979001484625193693633882219274e-03
 	 7.94579312680107063826540070294868e-02 2.11406763618887660882705858966801e-02 8.99401392370100527529075407073833e-01 2.20979001484625193693633882219274e-03
 	 2.11406763618887660882705858966801e-02 8.99401392370100527529075407073833e-01 7.94579312680107063826540070294868e-02 2.20979001484625193693633882219274e-03
 	 2.11406763618887660882705858966801e-02 7.94579312680107063826540070294868e-02 8.99401392370100527529075407073833e-01 2.20979001484625193693633882219274e-03
 	 8.45458162390093193039319885428995e-01 1.32357395968752789006117609460489e-01 2.21844416411540179545625051105162e-02 2.91512442539209985781223366529957e-03
 	 8.45458162390093193039319885428995e-01 2.21844416411540179545625051105162e-02 1.32357395968752789006117609460489e-01 2.91512442539209985781223366529957e-03
 	 1.32357395968752789006117609460489e-01 8.45458162390093193039319885428995e-01 2.21844416411540179545625051105162e-02 2.91512442539209985781223366529957e-03
 	 1.32357395968752789006117609460489e-01 2.21844416411540179545625051105162e-02 8.45458162390093193039319885428995e-01 2.91512442539209985781223366529957e-03
 	 2.21844416411540179545625051105162e-02 8.45458162390093193039319885428995e-01 1.32357395968752789006117609460489e-01 2.91512442539209985781223366529957e-03
 	 2.21844416411540179545625051105162e-02 1.32357395968752789006117609460489e-01 8.45458162390093193039319885428995e-01 2.91512442539209985781223366529957e-03
 	 7.82095750516363930060492748452816e-01 1.95018153176870295828493340195564e-01 2.28860963067657741110139113516198e-02 3.40299157381097200358865961788979e-03
 	 7.82095750516363930060492748452816e-01 2.28860963067657741110139113516198e-02 1.95018153176870295828493340195564e-01 3.40299157381097200358865961788979e-03
 	 1.95018153176870295828493340195564e-01 7.82095750516363930060492748452816e-01 2.28860963067657741110139113516198e-02 3.40299157381097200358865961788979e-03
 	 1.95018153176870295828493340195564e-01 2.28860963067657741110139113516198e-02 7.82095750516363930060492748452816e-01 3.40299157381097200358865961788979e-03
 	 2.28860963067657741110139113516198e-02 7.82095750516363930060492748452816e-01 1.95018153176870295828493340195564e-01 3.40299157381097200358865961788979e-03
 	 2.28860963067657741110139113516198e-02 1.95018153176870295828493340195564e-01 7.82095750516363930060492748452816e-01 3.40299157381097200358865961788979e-03
 	 7.13726302839667536836998351645889e-01 2.63119135268292392293432158112410e-01 2.31545618920400708695694902417017e-02 3.62237822462391613823062819221832e-03
 	 7.13726302839667536836998351645889e-01 2.31545618920400708695694902417017e-02 2.63119135268292392293432158112410e-01 3.62237822462391613823062819221832e-03
 	 2.63119135268292392293432158112410e-01 7.13726302839667536836998351645889e-01 2.31545618920400708695694902417017e-02 3.62237822462391613823062819221832e-03
 	 2.63119135268292392293432158112410e-01 2.31545618920400708695694902417017e-02 7.13726302839667536836998351645889e-01 3.62237822462391613823062819221832e-03
 	 2.31545618920400708695694902417017e-02 7.13726302839667536836998351645889e-01 2.63119135268292392293432158112410e-01 3.62237822462391613823062819221832e-03
 	 2.31545618920400708695694902417017e-02 2.63119135268292392293432158112410e-01 7.13726302839667536836998351645889e-01 3.62237822462391613823062819221832e-03
 	 8.53648252342922631008548250974854e-01 9.44179770163390830184368951449869e-02 5.19337706407382859730148538801586e-02 3.68262322223609226204410482807816e-03
 	 8.53648252342922631008548250974854e-01 5.19337706407382859730148538801586e-02 9.44179770163390830184368951449869e-02 3.68262322223609226204410482807816e-03
 	 9.44179770163390830184368951449869e-02 8.53648252342922631008548250974854e-01 5.19337706407382859730148538801586e-02 3.68262322223609226204410482807816e-03
 	 9.44179770163390830184368951449869e-02 5.19337706407382859730148538801586e-02 8.53648252342922631008548250974854e-01 3.68262322223609226204410482807816e-03
 	 5.19337706407382859730148538801586e-02 8.53648252342922631008548250974854e-01 9.44179770163390830184368951449869e-02 3.68262322223609226204410482807816e-03
 	 5.19337706407382859730148538801586e-02 9.44179770163390830184368951449869e-02 8.53648252342922631008548250974854e-01 3.68262322223609226204410482807816e-03
 	 6.42663057493850664592116572748637e-01 3.34082493247255973845000198707567e-01 2.32544492588933615628832285437966e-02 3.80110733979002355861775974688044e-03
 	 6.42663057493850664592116572748637e-01 2.32544492588933615628832285437966e-02 3.34082493247255973845000198707567e-01 3.80110733979002355861775974688044e-03
 	 3.34082493247255973845000198707567e-01 6.42663057493850664592116572748637e-01 2.32544492588933615628832285437966e-02 3.80110733979002355861775974688044e-03
 	 3.34082493247255973845000198707567e-01 2.32544492588933615628832285437966e-02 6.42663057493850664592116572748637e-01 3.80110733979002355861775974688044e-03
 	 2.32544492588933615628832285437966e-02 6.42663057493850664592116572748637e-01 3.34082493247255973845000198707567e-01 3.80110733979002355861775974688044e-03
 	 2.32544492588933615628832285437966e-02 3.34082493247255973845000198707567e-01 6.42663057493850664592116572748637e-01 3.80110733979002355861775974688044e-03
 	 5.67421425923325672968644539650995e-01 4.09119706855425480096499768478679e-01 2.34588672212488469348556918703252e-02 4.08979954757582916252678373325580e-03
 	 5.67421425923325672968644539650995e-01 2.34588672212488469348556918703252e-02 4.09119706855425480096499768478679e-01 4.08979954757582916252678373325580e-03
 	 4.09119706855425480096499768478679e-01 5.67421425923325672968644539650995e-01 2.34588672212488469348556918703252e-02 4.08979954757582916252678373325580e-03
 	 4.09119706855425480096499768478679e-01 2.34588672212488469348556918703252e-02 5.67421425923325672968644539650995e-01 4.08979954757582916252678373325580e-03
 	 2.34588672212488469348556918703252e-02 5.67421425923325672968644539650995e-01 4.09119706855425480096499768478679e-01 4.08979954757582916252678373325580e-03
 	 2.34588672212488469348556918703252e-02 4.09119706855425480096499768478679e-01 5.67421425923325672968644539650995e-01 4.08979954757582916252678373325580e-03
 	 7.95883644812847901306440689950250e-01 1.49641910458703203401498171842832e-01 5.44744447284488952920611382069183e-02 4.61385528120053858835980520325393e-03
 	 7.95883644812847901306440689950250e-01 5.44744447284488952920611382069183e-02 1.49641910458703203401498171842832e-01 4.61385528120053858835980520325393e-03
 	 1.49641910458703203401498171842832e-01 7.95883644812847901306440689950250e-01 5.44744447284488952920611382069183e-02 4.61385528120053858835980520325393e-03
 	 1.49641910458703203401498171842832e-01 5.44744447284488952920611382069183e-02 7.95883644812847901306440689950250e-01 4.61385528120053858835980520325393e-03
 	 5.44744447284488952920611382069183e-02 7.95883644812847901306440689950250e-01 1.49641910458703203401498171842832e-01 4.61385528120053858835980520325393e-03
 	 5.44744447284488952920611382069183e-02 1.49641910458703203401498171842832e-01 7.95883644812847901306440689950250e-01 4.61385528120053858835980520325393e-03
 	 7.31688847720892487913602053595241e-01 2.12466086260680087072216792876134e-01 5.58450660184274250141811535286251e-02 5.20268756995343091553696268647400e-03
 	 7.31688847720892487913602053595241e-01 5.58450660184274250141811535286251e-02 2.12466086260680087072216792876134e-01 5.20268756995343091553696268647400e-03
 	 2.12466086260680087072216792876134e-01 7.31688847720892487913602053595241e-01 5.58450660184274250141811535286251e-02 5.20268756995343091553696268647400e-03
 	 2.12466086260680087072216792876134e-01 5.58450660184274250141811535286251e-02 7.31688847720892487913602053595241e-01 5.20268756995343091553696268647400e-03
 	 5.58450660184274250141811535286251e-02 7.31688847720892487913602053595241e-01 2.12466086260680087072216792876134e-01 5.20268756995343091553696268647400e-03
 	 5.58450660184274250141811535286251e-02 2.12466086260680087072216792876134e-01 7.31688847720892487913602053595241e-01 5.20268756995343091553696268647400e-03
 	 6.63321124311019305608283502806444e-01 2.80443055765805193679796047945274e-01 5.62358199231755007119204492482822e-02 5.61787388307411362370347163164297e-03
 	 6.63321124311019305608283502806444e-01 5.62358199231755007119204492482822e-02 2.80443055765805193679796047945274e-01 5.61787388307411362370347163164297e-03
 	 2.80443055765805193679796047945274e-01 6.63321124311019305608283502806444e-01 5.62358199231755007119204492482822e-02 5.61787388307411362370347163164297e-03
 	 2.80443055765805193679796047945274e-01 5.62358199231755007119204492482822e-02 6.63321124311019305608283502806444e-01 5.61787388307411362370347163164297e-03
 	 5.62358199231755007119204492482822e-02 6.63321124311019305608283502806444e-01 2.80443055765805193679796047945274e-01 5.61787388307411362370347163164297e-03
 	 5.62358199231755007119204492482822e-02 2.80443055765805193679796047945274e-01 6.63321124311019305608283502806444e-01 5.61787388307411362370347163164297e-03
 	 7.52105512553738697612004671100294e-01 1.48431512855652897320268834846502e-01 9.94629745906084050677264940532041e-02 6.10585546227969573618299392592235e-03
 	 7.52105512553738697612004671100294e-01 9.94629745906084050677264940532041e-02 1.48431512855652897320268834846502e-01 6.10585546227969573618299392592235e-03
 	 1.48431512855652897320268834846502e-01 7.52105512553738697612004671100294e-01 9.94629745906084050677264940532041e-02 6.10585546227969573618299392592235e-03
 	 1.48431512855652897320268834846502e-01 9.94629745906084050677264940532041e-02 7.52105512553738697612004671100294e-01 6.10585546227969573618299392592235e-03
 	 9.94629745906084050677264940532041e-02 7.52105512553738697612004671100294e-01 1.48431512855652897320268834846502e-01 6.10585546227969573618299392592235e-03
 	 9.94629745906084050677264940532041e-02 1.48431512855652897320268834846502e-01 7.52105512553738697612004671100294e-01 6.10585546227969573618299392592235e-03
 	 5.89842412472838084624982002424076e-01 3.53507535982596321488813373434823e-01 5.66500515445655938862046241411008e-02 6.10669701055758292612685167455311e-03
 	 5.89842412472838084624982002424076e-01 5.66500515445655938862046241411008e-02 3.53507535982596321488813373434823e-01 6.10669701055758292612685167455311e-03
 	 3.53507535982596321488813373434823e-01 5.89842412472838084624982002424076e-01 5.66500515445655938862046241411008e-02 6.10669701055758292612685167455311e-03
 	 3.53507535982596321488813373434823e-01 5.66500515445655938862046241411008e-02 5.89842412472838084624982002424076e-01 6.10669701055758292612685167455311e-03
 	 5.66500515445655938862046241411008e-02 5.89842412472838084624982002424076e-01 3.53507535982596321488813373434823e-01 6.10669701055758292612685167455311e-03
 	 5.66500515445655938862046241411008e-02 3.53507535982596321488813373434823e-01 5.89842412472838084624982002424076e-01 6.10669701055758292612685167455311e-03
 	 5.11476044318667555366175747622037e-01 4.31429040442822320233773325526272e-01 5.70949152385101244000509268516907e-02 6.45456202138746434199267909548325e-03
 	 5.11476044318667555366175747622037e-01 5.70949152385101244000509268516907e-02 4.31429040442822320233773325526272e-01 6.45456202138746434199267909548325e-03
 	 4.31429040442822320233773325526272e-01 5.11476044318667555366175747622037e-01 5.70949152385101244000509268516907e-02 6.45456202138746434199267909548325e-03
 	 4.31429040442822320233773325526272e-01 5.70949152385101244000509268516907e-02 5.11476044318667555366175747622037e-01 6.45456202138746434199267909548325e-03
 	 5.70949152385101244000509268516907e-02 5.11476044318667555366175747622037e-01 4.31429040442822320233773325526272e-01 6.45456202138746434199267909548325e-03
 	 5.70949152385101244000509268516907e-02 4.31429040442822320233773325526272e-01 5.11476044318667555366175747622037e-01 6.45456202138746434199267909548325e-03
 	 6.85135741196404968178512717713602e-01 2.13046127940301810443912700065994e-01 1.01818130863293221377574582220404e-01 7.20439116716808415630257655948299e-03
 	 6.85135741196404968178512717713602e-01 1.01818130863293221377574582220404e-01 2.13046127940301810443912700065994e-01 7.20439116716808415630257655948299e-03
 	 2.13046127940301810443912700065994e-01 6.85135741196404968178512717713602e-01 1.01818130863293221377574582220404e-01 7.20439116716808415630257655948299e-03
 	 2.13046127940301810443912700065994e-01 1.01818130863293221377574582220404e-01 6.85135741196404968178512717713602e-01 7.20439116716808415630257655948299e-03
 	 1.01818130863293221377574582220404e-01 6.85135741196404968178512717713602e-01 2.13046127940301810443912700065994e-01 7.20439116716808415630257655948299e-03
 	 1.01818130863293221377574582220404e-01 2.13046127940301810443912700065994e-01 6.85135741196404968178512717713602e-01 7.20439116716808415630257655948299e-03
 	 6.11188722458039679352737039152998e-01 2.86145793841655393663359063793905e-01 1.02665483700304926983903897053096e-01 8.06068774085425682196515140276460e-03
 	 6.11188722458039679352737039152998e-01 1.02665483700304926983903897053096e-01 2.86145793841655393663359063793905e-01 8.06068774085425682196515140276460e-03
 	 2.86145793841655393663359063793905e-01 6.11188722458039679352737039152998e-01 1.02665483700304926983903897053096e-01 8.06068774085425682196515140276460e-03
 	 2.86145793841655393663359063793905e-01 1.02665483700304926983903897053096e-01 6.11188722458039679352737039152998e-01 8.06068774085425682196515140276460e-03
 	 1.02665483700304926983903897053096e-01 6.11188722458039679352737039152998e-01 2.86145793841655393663359063793905e-01 8.06068774085425682196515140276460e-03
 	 1.02665483700304926983903897053096e-01 2.86145793841655393663359063793905e-01 6.11188722458039679352737039152998e-01 8.06068774085425682196515140276460e-03
 	 5.31047050460635050583846350491513e-01 3.65311627705974806268329757585889e-01 1.03641321833390143147823891922599e-01 8.65648115906353203541367946627361e-03
 	 5.31047050460635050583846350491513e-01 1.03641321833390143147823891922599e-01 3.65311627705974806268329757585889e-01 8.65648115906353203541367946627361e-03
 	 3.65311627705974806268329757585889e-01 5.31047050460635050583846350491513e-01 1.03641321833390143147823891922599e-01 8.65648115906353203541367946627361e-03
 	 3.65311627705974806268329757585889e-01 1.03641321833390143147823891922599e-01 5.31047050460635050583846350491513e-01 8.65648115906353203541367946627361e-03
 	 1.03641321833390143147823891922599e-01 5.31047050460635050583846350491513e-01 3.65311627705974806268329757585889e-01 8.65648115906353203541367946627361e-03
 	 1.03641321833390143147823891922599e-01 3.65311627705974806268329757585889e-01 5.31047050460635050583846350491513e-01 8.65648115906353203541367946627361e-03
 	 6.16755405364404762913466129248263e-01 2.23611895415582712098867546046677e-01 1.59632699220012524987666324705060e-01 8.89974956583345841454324443020596e-03
 	 6.16755405364404762913466129248263e-01 1.59632699220012524987666324705060e-01 2.23611895415582712098867546046677e-01 8.89974956583345841454324443020596e-03
 	 2.23611895415582712098867546046677e-01 6.16755405364404762913466129248263e-01 1.59632699220012524987666324705060e-01 8.89974956583345841454324443020596e-03
 	 2.23611895415582712098867546046677e-01 1.59632699220012524987666324705060e-01 6.16755405364404762913466129248263e-01 8.89974956583345841454324443020596e-03
 	 1.59632699220012524987666324705060e-01 6.16755405364404762913466129248263e-01 2.23611895415582712098867546046677e-01 8.89974956583345841454324443020596e-03
 	 1.59632699220012524987666324705060e-01 2.23611895415582712098867546046677e-01 6.16755405364404762913466129248263e-01 8.89974956583345841454324443020596e-03
 	 5.40939115423052063746922613063361e-01 2.97770116248729010965945462885429e-01 1.61290768328218925287131924051209e-01 9.88439332083497143588424194149411e-03
 	 5.40939115423052063746922613063361e-01 1.61290768328218925287131924051209e-01 2.97770116248729010965945462885429e-01 9.88439332083497143588424194149411e-03
 	 2.97770116248729010965945462885429e-01 5.40939115423052063746922613063361e-01 1.61290768328218925287131924051209e-01 9.88439332083497143588424194149411e-03
 	 2.97770116248729010965945462885429e-01 1.61290768328218925287131924051209e-01 5.40939115423052063746922613063361e-01 9.88439332083497143588424194149411e-03
 	 1.61290768328218925287131924051209e-01 5.40939115423052063746922613063361e-01 2.97770116248729010965945462885429e-01 9.88439332083497143588424194149411e-03
 	 1.61290768328218925287131924051209e-01 2.97770116248729010965945462885429e-01 5.40939115423052063746922613063361e-01 9.88439332083497143588424194149411e-03
 	 4.59837236521221992546770707122050e-01 3.77459830224483983140970622116583e-01 1.62702933254294024312258670761366e-01 1.04835098306999777856285405164272e-02
 	 4.59837236521221992546770707122050e-01 1.62702933254294024312258670761366e-01 3.77459830224483983140970622116583e-01 1.04835098306999777856285405164272e-02
 	 3.77459830224483983140970622116583e-01 4.59837236521221992546770707122050e-01 1.62702933254294024312258670761366e-01 1.04835098306999777856285405164272e-02
 	 3.77459830224483983140970622116583e-01 1.62702933254294024312258670761366e-01 4.59837236521221992546770707122050e-01 1.04835098306999777856285405164272e-02
 	 1.62702933254294024312258670761366e-01 4.59837236521221992546770707122050e-01 3.77459830224483983140970622116583e-01 1.04835098306999777856285405164272e-02
 	 1.62702933254294024312258670761366e-01 3.77459830224483983140970622116583e-01 4.59837236521221992546770707122050e-01 1.04835098306999777856285405164272e-02
 	 4.66649539182707573381492238695500e-01 3.03210043229811321285893654930987e-01 2.30140417587481105332614106373512e-01 1.15470205304370829996196690103716e-02
 	 4.66649539182707573381492238695500e-01 2.30140417587481105332614106373512e-01 3.03210043229811321285893654930987e-01 1.15470205304370829996196690103716e-02
 	 3.03210043229811321285893654930987e-01 4.66649539182707573381492238695500e-01 2.30140417587481105332614106373512e-01 1.15470205304370829996196690103716e-02
 	 3.03210043229811321285893654930987e-01 2.30140417587481105332614106373512e-01 4.66649539182707573381492238695500e-01 1.15470205304370829996196690103716e-02
 	 2.30140417587481105332614106373512e-01 4.66649539182707573381492238695500e-01 3.03210043229811321285893654930987e-01 1.15470205304370829996196690103716e-02
 	 2.30140417587481105332614106373512e-01 3.03210043229811321285893654930987e-01 4.66649539182707573381492238695500e-01 1.15470205304370829996196690103716e-02
 	 ];
 

 	 otherwise
 	 xyw=[];
 	 end
 

 
 
 	 pointset_stats=[
 	   1    1 1.92e-16    0    0
 	   2    3 4.20e-16    0    0
 	   4    6 1.53e-16    0    0
 	   5   10 4.43e-16    0    0
 	   7   15 6.11e-16    0    0
 	   8   21 5.27e-16    0    0
 	  10   28 7.42e-16    0    0
 	  12   36 7.49e-16    0    0
 	  14   45 1.03e-15    0    0
 	  15   55 1.62e-15    0    0
 	  17   66 1.55e-15    0    0
 	  19   78 1.40e-15    0    0
 	  20   91 5.97e-16    0    0
 	  22  105 3.03e-14    0    0
 	  24  120 2.02e-14    0    0
 	  25  136 2.12e-14    0    0
 	  27  153 2.52e-13    0    0
 	  28  171 2.86e-15    0    0
 	  30  190 2.90e-14    0    0
 	  32  210 4.08e-12    0    0
 	 ];
 

 

 
