
function [S1,S2,S3]=set_vioreanu_rokhlin_pre(deg)

%     B. Vioreanu and V. Rokhlin,
%     Spectra of Multiplication Operators as a Numerical Tool,
%     Methods and Algorithms for Scientific Computing,
%     2014,
%     SIAM J. Sci. Comput., 36(1), pp.267-288.

S1=[];
S2=[];
S3=[];

switch deg
    case  1
        
        S3=2;
        
        % 1:
    case  2
        
        S2=[6.666666666666667e-01, 1.666666666666666e-01];
        
        % 2:
    case  4
        
        S2=[2.199034873106437e-01, 9.157621350977074e-02
            4.467631793560229e-01, 4.459484909159649e-01];
        
        % 3:
    case  5
        
        S3=[3.979307409192731e-01];
            S2=[1.205579608142811e-01, 7.111299453344100e-02];
            
            S1=[2.067325627729806e-01, 6.149261666431255e-01, 3.139793976769810e-01];
            
            
            % 4:
    case  7
    
    S2=[6.402666945975939e-02, 5.125307984145178e-02
        1.297596750941034e-01, 4.741107940511353e-01
        2.540178513886623e-01, 2.421847563444861e-01];
    
    S1=[1.094312353620707e-01, 7.184833008976065e-01, 2.333468929848689e-01];
    
    
    % 5:
    case  8
        
        S2=[2.742901451011957e-02, 3.140574880095148e-02
            1.487952180396637e-01, 1.960193578071566e-01
            1.700290644290404e-01, 4.044619997391648e-01];
        
        S1=[7.681169007620549e-02, 7.876424102060766e-01, 1.711304246628439e-01
            8.339499476771613e-02, 5.846327565436199e-01, 3.760587715777944e-01];
        
        
        % 6:
    case  10
        
        S3=1.616325201016875e-01;
        S2=[1.476326579239448e-02, 2.270664031285163e-02
            5.295777200299426e-02, 4.853481363747690e-01
            1.002186284617503e-01, 1.550155173362230e-01];
        
        S1=[4.700420842576995e-02, 8.385517073803943e-01, 1.300534505181612e-01
            5.705224549121469e-02, 6.669206010596079e-01, 3.027900973675370e-01
            1.183682929374979e-01, 5.205603060588030e-01, 3.307142459409231e-01];
        
        
        % 7:
    case  12
        
        S2=[1.028270043936957e-02, 1.936521090242771e-02
            6.327928525696251e-02, 1.204308315691905e-01
            9.348331834201271e-02, 4.400056902104356e-01
            1.249156510766090e-01, 2.715246320004977e-01];
        
        S1=[2.962870765800639e-02, 8.693738668822796e-01, 1.064079463998051e-01
            3.661864493599948e-02, 5.622334423439250e-01, 4.142620534704672e-01
            3.805169894228333e-02, 7.251033518679713e-01, 2.520140866025368e-01
            8.305380423956715e-02, 6.174128915199860e-01, 2.661098644687711e-01];
        
        
        % 8:
    case  14
        
        S2=[9.245822342306463e-03, 1.882509916959152e-02
            2.868577367294062e-02, 4.902491099383723e-01
            3.479644587892285e-02, 8.197254165164569e-02
            9.077217553424359e-02, 2.205308355657246e-01
            1.043845857523602e-01, 3.861241892782913e-01];
        
        S1=[1.640816380096723e-02, 8.878227753643443e-01, 9.679127647080299e-02
            2.378718386790235e-02, 7.672861632419925e-01, 2.144781573208718e-01
            2.625170156645367e-02, 6.333499392824316e-01, 3.481451468117782e-01
            5.786246094287929e-02, 7.075530184664951e-01, 2.006420156473703e-01
            7.508142156474396e-02, 5.413832148281223e-01, 3.613457256370317e-01];
        
        
        % 9:
    case  15
        
        S3=8.955059638519497e-02;
        S2=[7.824200812069266e-03, 1.765199295744602e-02
            3.306745127432806e-02, 7.717038421937095e-02
            4.123294071127868e-02, 4.593717976173819e-01
            6.393079745972230e-02, 2.049228975887788e-01];
        
        S1=[1.134785787074061e-02, 9.034296997820290e-01, 8.351364433882746e-02
            1.795815646302081e-02, 8.103865759434584e-01, 1.707436491477080e-01
            2.143319371076641e-02, 7.028946639162473e-01, 2.806822966077874e-01
            2.344716086061786e-02, 5.646364646839406e-01, 4.194651017582320e-01
            5.044870660380054e-02, 5.844785840367163e-01, 3.330420610061661e-01
            5.163995025251897e-02, 7.170308522994707e-01, 1.925132338590613e-01
            6.910551304563631e-02, 4.722454082469039e-01, 3.361189502955325e-01];
        
        
        % 10:
    case  17
        
        S2=[4.533150138338916e-03, 1.338044267375471e-02
            1.840922096626110e-02, 4.929375087537810e-01
            2.410913657966060e-02, 6.860308489847733e-02
            4.468857832251429e-02, 1.632812816752138e-01
            6.253133910430890e-02, 4.175103606029739e-01
            7.362530381554795e-02, 2.864874374828993e-01];
        
        S1=[
        8.914349373967220e-03, 9.220321146106945e-01, 6.509382978126310e-02
        1.262245349100950e-02, 8.425600911514819e-01, 1.434190950622009e-01
        1.529137548785980e-02, 7.434497021895653e-01, 2.431552818705917e-01
        1.682222570490589e-02, 6.221123576162322e-01, 3.650886030795984e-01
        3.366852390007356e-02, 5.173298517577236e-01, 4.126419796221273e-01
        3.552105987136365e-02, 7.625944482732047e-01, 1.663594035439976e-01
        3.878306670364895e-02, 6.408984026645947e-01, 2.921159572571606e-01
        5.776191433718891e-02, 5.576433327824263e-01, 2.811126637309341e-01];
        
        
        % 11:
        %  specifies degree 22
    case  19
        
        S2=[
            3.570986637127163e-03, 1.190577007231675e-02
            1.443219045679156e-02, 4.667496723194445e-01
            1.669804906298920e-02, 5.441721914546105e-02
            3.772584908018874e-02, 1.494946145980176e-01
            5.946555598510596e-02, 2.452421322453167e-01
            6.379949836671749e-02, 3.746190629160668e-01];
        
        S1=[
            5.633770058767265e-03, 9.337642883675498e-01, 5.690091065739300e-02
            9.557473874258463e-03, 8.655951061030167e-01, 1.215393132784824e-01
            1.200284972603270e-02, 7.802452139266726e-01, 2.082943532801806e-01
            1.294263376785348e-02, 5.471384723657631e-01, 4.412978853943775e-01
            1.353419878617641e-02, 6.658891391378028e-01, 3.233226088132393e-01
            2.851095496363288e-02, 7.970304632923635e-01, 1.390712757266199e-01
            3.200758609380727e-02, 6.882989735346122e-01, 2.546744088593174e-01
            3.272418337426342e-02, 5.571433884144036e-01, 3.855180104561194e-01
            4.097726973873548e-02, 6.128345671072721e-01, 2.528273824260306e-01
            4.759634815534594e-02, 4.920429731549203e-01, 3.661549710661253e-01];
        
        
        % 12:
        %  specifies degree 25
    case  20
        
        S3=5.588291294116084e-02;
        S2=[
            1.981116311676655e-03, 8.570772385299130e-03
            1.281698730101485e-02, 5.153054050512629e-02
            1.392802401503369e-02, 4.946593404139001e-01
            3.334681223797469e-02, 4.373258129156083e-01
            3.350287758327230e-02, 1.322939953811165e-01
            4.485139589079629e-02, 2.152388243446085e-01];
        
        S1=[
            5.467709119029015e-03, 9.434081460978755e-01, 4.662176991883149e-02
            7.742473857383334e-03, 7.951998698231925e-01, 1.946139250445256e-01
            8.312467601083283e-03, 7.244281320245196e-01, 2.654962893143091e-01
            8.627498419980478e-03, 8.751176817691593e-01, 1.142006223365933e-01
            1.154875711587518e-02, 6.212422292784825e-01, 3.694621789345873e-01
            1.999959677480471e-02, 8.232841624668943e-01, 1.214321743895611e-01
            2.307726195136485e-02, 7.355029738726430e-01, 2.119739663759458e-01
            2.369686209775543e-02, 5.246041585348024e-01, 4.224769939458884e-01
            2.421557796764804e-02, 6.308736305151760e-01, 3.199584180281884e-01
            3.460060715098293e-02, 6.455563794140737e-01, 2.344684215615388e-01
            3.533502706616500e-02, 5.396524559908187e-01, 3.377292371070699e-01
            5.118206871784994e-02, 4.513865004633650e-01, 3.288194899950024e-01];
        
        
        % 13:
        %  specifies degree 30
    case  22
        
        S2=[
            9.372740681166061e-04, 5.819134670830062e-03
            6.678149796264960e-03, 3.702425290148781e-02
            2.018904258983655e-02, 1.001399642433202e-01
            2.315976825855484e-02, 4.772833614440938e-01
            3.454105560555202e-02, 1.878400338876801e-01
            4.429134227342787e-02, 4.027599197215377e-01
            4.810124266571171e-02, 2.958198366868486e-01];
        
        S1=[
            2.744874844769334e-03, 9.603538056014904e-01, 3.243783612078988e-02
            4.399417591497932e-03, 9.127697021851261e-01, 7.964056379409012e-02
            6.275829540284716e-03, 8.469309296126851e-01, 1.447676605103509e-01
            7.960615246090029e-03, 7.638008529025838e-01, 2.277439204929096e-01
            9.330007606140923e-03, 6.638539963530028e-01, 3.275987317494321e-01
            1.015343422319121e-02, 5.528555676245731e-01, 4.384282353975578e-01
            1.177257668360538e-02, 8.698539225931300e-01, 8.947847466075809e-02
            1.648839386112606e-02, 7.920008360491817e-01, 1.644795701305916e-01
            1.985171421313456e-02, 6.980320871337803e-01, 2.578967113202372e-01
            2.222998649578860e-02, 5.909216368985124e-01, 3.642072940938728e-01
            2.621519312079549e-02, 7.137569985774248e-01, 1.815778753439505e-01
            3.106090819468753e-02, 6.144560891553971e-01, 2.791456037635389e-01
            3.427038831730838e-02, 5.031638531501400e-01, 3.884107097457122e-01
            4.163105576617319e-02, 5.184466044342965e-01, 2.892963484239227e-01];
        
        
        % 14:
        %  specifies degree 35
    case  24
        
        S2=[
            6.758286353449607e-04, 4.680447738470872e-03
            4.850017685062113e-03, 3.585157492840441e-02
            8.324459144176668e-03, 4.961637933310635e-01
            1.565751270584800e-02, 8.109730212173860e-02
            2.723633037176611e-02, 1.672827929164180e-01
            2.919327674254637e-02, 4.519710222221295e-01
            4.012365449679097e-02, 2.625251428450600e-01
            4.268474920907758e-02, 3.673188600363344e-01];
        
        S1=[
            2.521080109114734e-03, 9.234552296982609e-01, 7.191876244981610e-02
            2.615382667420058e-03, 9.632582419356120e-01, 2.931017109737133e-02
            4.643763775798911e-03, 8.650621831470628e-01, 1.276717489189511e-01
            6.232260808565897e-03, 7.931493556291015e-01, 1.993768545806370e-01
            7.435659064895126e-03, 7.031675270874249e-01, 2.893554875616166e-01
            7.593564045814638e-03, 8.949870504292678e-01, 7.572317913361015e-02
            8.119373095306543e-03, 6.016931050353780e-01, 3.907080261015554e-01
            1.284085351617643e-02, 8.220156974385251e-01, 1.396048523361563e-01
            1.596677199069103e-02, 7.375227615879018e-01, 2.236338353672938e-01
            1.798364059862366e-02, 6.393994153399095e-01, 3.214171397042133e-01
            1.904098283458944e-02, 5.337289248977489e-01, 4.264389494177782e-01
            2.121821363415212e-02, 7.520067384317993e-01, 1.552477403750816e-01
            2.501975381451312e-02, 6.621574089518958e-01, 2.442500189407099e-01
            2.800041039854343e-02, 5.602547212108616e-01, 3.447274676489183e-01
            3.291520673262962e-02, 5.736422125351232e-01, 2.570886266519017e-01
            3.681350175118866e-02, 4.682780597559236e-01, 3.595253701138149e-01];
        
        
        % 15:
        %  specifies degree 40
    case  25
        
        S3=3.826701851913514e-02;
        S2=[
            8.067538614674652e-04, 5.714338858236023e-03
            4.097892115003257e-03, 2.724942860041202e-02
            1.211112026594179e-02, 7.665566577103766e-02
            1.545248758841621e-02, 4.821356843648178e-01
            2.231585558112508e-02, 1.495232577953683e-01
            3.128109303881664e-02, 4.225303647062220e-01
            3.244705526178106e-02, 2.350176639422171e-01];
        
        S1=[
        1.311972096436258e-03, 9.687384811816084e-01, 2.643876732033090e-02
        2.363506362138199e-03, 9.359144655917663e-01, 5.824206555180034e-02
        3.863355202489112e-03, 8.857374205718546e-01, 1.079576738802949e-01
        5.205141497072303e-03, 8.169397121865529e-01, 1.764040981552513e-01
        6.079727960822668e-03, 7.340782657828878e-01, 2.592064443745977e-01
        6.573861622100784e-03, 6.417536443370564e-01, 3.515058813634405e-01
        6.803487273786287e-03, 5.452017126279234e-01, 4.479594537557854e-01
        7.191212414410812e-03, 8.996729746963734e-01, 6.922855544769646e-02
        1.040593989374505e-02, 8.367547459062316e-01, 1.294504367233845e-01
        1.279192792167507e-02, 7.600188208086851e-01, 2.050928184004891e-01
        1.429054259568944e-02, 6.728787209737545e-01, 2.921172033658072e-01
        1.516598018295725e-02, 5.787663357295136e-01, 3.858474444747349e-01
        1.688539009927329e-02, 7.763864794675357e-01, 1.411732702594700e-01
        2.008864157361232e-02, 6.952811838413491e-01, 2.206947014886987e-01
        2.241379810029409e-02, 6.045565788562602e-01, 3.107793948406679e-01
        2.379359758144083e-02, 5.068512266778055e-01, 4.073744619896780e-01
        2.647059913816115e-02, 6.176053774986531e-01, 2.307669286559439e-01
        2.995295606219674e-02, 5.232704635329560e-01, 3.230026381964913e-01
        3.604773047889431e-02, 4.313080820678356e-01, 3.302766805172654e-01];
        
        
        % 16:
        %  specifies degree 44
    case  27
        
        S2=[
            8.864712285876080e-04, 6.028725106885902e-03
            3.416776045135247e-03, 2.258044806409376e-02
            5.873188283219656e-03, 4.969481625758564e-01
            9.056830757287023e-03, 6.974538648259421e-02
            1.852078765438412e-02, 1.332229905987722e-01
            2.065003542841465e-02, 4.615359106618344e-01
            2.630730885302441e-02, 2.113990101102156e-01
            3.174921632839665e-02, 3.921793974573250e-01
            3.377920627522737e-02, 3.020740004939738e-01];
        
        S1=[
            6.034254669086245e-04, 9.725775772197541e-01, 2.564112890385994e-02
            2.068085551182357e-03, 9.447574286566741e-01, 4.894785660284484e-02
            3.186399004446843e-03, 9.001401125357067e-01, 9.437022532668160e-02
            4.216050075476142e-03, 8.359266405800050e-01, 1.581782780422168e-01
            4.841675960174105e-03, 7.614884986585091e-01, 2.324831503045078e-01
            5.271481486746724e-03, 6.792748579250246e-01, 3.147359690956268e-01
            5.694173766833175e-03, 5.901737795276984e-01, 4.037659022247549e-01
            6.090614333326090e-03, 9.081476395318312e-01, 6.242160824697651e-02
            8.222871505051422e-03, 8.534412071534904e-01, 1.170385553231946e-01
            1.005721006810382e-02, 7.845616678273414e-01, 1.841674338290629e-01
            1.125757513179009e-02, 7.085198818216315e-01, 2.601687548765030e-01
            1.254170679557376e-02, 6.236626809193377e-01, 3.449391093275205e-01
            1.307633456433240e-02, 8.024605155143716e-01, 1.250100196599240e-01
            1.340950590931485e-02, 5.313863438483508e-01, 4.368267911083232e-01
            1.620796750370467e-02, 7.292105546144692e-01, 1.952257414210168e-01
            1.843205739109864e-02, 6.473953079406027e-01, 2.770313420283573e-01
            2.004422177958698e-02, 5.566146408624599e-01, 3.670861743651032e-01
            2.178517696533819e-02, 6.558049931032111e-01, 2.076778175532397e-01
            2.453754696208469e-02, 5.709237895617369e-01, 2.918068570178904e-01
            2.636594306625429e-02, 4.780282704062717e-01, 3.830977808545468e-01
            3.030339961913597e-02, 4.880268172788484e-01, 2.979071185799660e-01];
        
        
        % 17:
        %  specifies degree 50
    case  28
        
        S2=[
            3.376569435794172e-04, 3.527814686147823e-03
            2.598073424041000e-03, 2.325447859968210e-02
            7.876845216111511e-03, 6.130617114904913e-02
            1.158101086723880e-02, 4.855973653165130e-01
            1.505793699176690e-02, 1.195743796872036e-01
            2.190400635518907e-02, 1.938328497359449e-01
            2.262890817056775e-02, 4.368548258011929e-01
            2.847258101994243e-02, 2.747866918548460e-01
            2.982114065394350e-02, 3.618869745900054e-01];
        
        S1=[
            9.791500456345333e-04, 9.764059455437145e-01, 1.906561164002463e-02
            1.540928597316125e-03, 9.496260390310843e-01, 4.575279206695970e-02
            2.384103824626106e-03, 9.095754444210733e-01, 8.555853018595394e-02
            3.384604728035539e-03, 8.539286001170394e-01, 1.407457933600552e-01
            4.075197692872541e-03, 7.862323636337837e-01, 2.082668344397580e-01
            4.454520583231300e-03, 7.102182099452963e-01, 2.842991868481302e-01
            4.456234744012970e-03, 9.196157432555334e-01, 5.569215409153472e-02
            4.751971118562528e-03, 6.281215007587091e-01, 3.663996434399521e-01
            4.974845261700243e-03, 5.414749509461303e-01, 4.530146714463690e-01
            6.494024827476459e-03, 8.708470435972641e-01, 1.027473762226062e-01
            8.423666542583920e-03, 8.080559251256462e-01, 1.636251515282007e-01
            9.567348009171152e-03, 7.371163388152084e-01, 2.341753944019633e-01
            1.044270209726271e-02, 6.592556949516479e-01, 3.121682551693416e-01
            1.093844979839479e-02, 8.216107701101382e-01, 1.132433049036548e-01
            1.124340014982319e-02, 5.745411059591615e-01, 3.967686114309502e-01
            1.364438395440442e-02, 7.527363210013835e-01, 1.783494379793427e-01
            1.527156696375312e-02, 6.778697897210867e-01, 2.529331358391764e-01
            1.651196530905789e-02, 5.961818824418882e-01, 3.346575181777144e-01
            1.725939655083561e-02, 5.093430764039831e-01, 4.210878800631231e-01
            1.838136562263890e-02, 6.875336465432943e-01, 1.874627353459279e-01
            2.050562247479402e-02, 6.098823636779619e-01, 2.649066478508855e-01
            2.205214927092028e-02, 5.252549119877226e-01, 3.490066160077018e-01
            2.478350683992782e-02, 5.332073327346849e-01, 2.721790466384769e-01
            2.667314850510633e-02, 4.464552409656513e-01, 3.575961437401405e-01];
        
        
        % 18:
        %  specifies degree 56
    case  30
        
        S3=2.755469669500557e-02;
        S2=[
            2.080920498080747e-04, 2.608491000431257e-03
            1.877148751955068e-03, 1.990812153294286e-02
            4.299628792430796e-03, 4.975087113412017e-01
            6.406881016605737e-03, 5.385439207707809e-02
            1.251955161595251e-02, 1.102346281757230e-01
            1.506858712064191e-02, 4.684661559784883e-01
            1.826854949412279e-02, 1.736926677159306e-01
            2.385853496758131e-02, 4.106683190498226e-01
            2.453173764475642e-02, 2.495567569827484e-01];
        
        S1=[
            7.518913835433728e-04, 9.800308095795568e-01, 1.601681168443359e-02
            1.154870004006195e-03, 9.562102405858892e-01, 4.006532345029712e-02
            1.991717031244021e-03, 9.189913779151198e-01, 7.648940225038126e-02
            2.765519137778876e-03, 8.692664466320263e-01, 1.258779912839826e-01
            3.286979606293420e-03, 8.081619299397496e-01, 1.869847407351458e-01
            3.472694932533848e-03, 9.310154147287887e-01, 4.796345919056944e-02
            3.659293919758050e-03, 7.381403634684718e-01, 2.569958014486482e-01
            3.961477829953188e-03, 6.619648632742920e-01, 3.331182254489627e-01
            4.201348686946968e-03, 5.811891751088626e-01, 4.138466578415511e-01
            5.524182463187656e-03, 8.842745775669243e-01, 9.118147427886308e-02
            6.938018810550618e-03, 8.276391902761688e-01, 1.469434211958456e-01
            7.854103946718304e-03, 7.625875685664840e-01, 2.120668395053681e-01
            8.646992113227546e-03, 6.901187105603424e-01, 2.843425563045865e-01
            9.107048758455513e-03, 8.383185674548238e-01, 1.014214624944148e-01
            9.352458725195483e-03, 6.118094166659663e-01, 3.623623076988831e-01
            9.811590648958873e-03, 5.291488522244880e-01, 4.448358539636972e-01
            1.098766970890707e-02, 7.785895798158033e-01, 1.599640542533872e-01
            1.257213146588250e-02, 7.106237856180184e-01, 2.278939844937914e-01
            1.388726462595260e-02, 6.342776548440681e-01, 3.035627151200351e-01
            1.475656889369171e-02, 5.526266878876758e-01, 3.845600729954156e-01
            1.499291947836710e-02, 7.168716727412066e-01, 1.716461034078638e-01
            1.704360284846234e-02, 6.455704828993845e-01, 2.422544084436082e-01
            1.852458099436215e-02, 5.668437382309666e-01, 3.195812184485557e-01
            1.931061251567118e-02, 4.844003417247089e-01, 4.011021537488086e-01
            2.112479538645548e-02, 5.784773569731281e-01, 2.459515013922275e-01
            2.312761369900372e-02, 4.962828293018632e-01, 3.259426273239289e-01
            2.641358054212290e-02, 4.165686000247035e-01, 3.312037434390103e-01];
        
        
        
        %  specifies degree 62
    case  32
        
        S2=[
            2.861718478111237e-04, 3.191453506137143e-03
            1.109993271255005e-03, 1.646556892175310e-02
            5.696417349972585e-03, 4.984951163545071e-02
            8.470731634701032e-03, 4.882193243612241e-01
            9.287318289231726e-03, 9.411485994044522e-02
            1.550975628172871e-02, 1.568369666050331e-01
            1.774399969132410e-02, 4.479179749162594e-01
            2.078951867803698e-02, 2.273593605104220e-01
            2.391851004568664e-02, 3.843166242573531e-01
            2.498662415251629e-02, 3.065470933749975e-01];
        
        S1=[
            7.306090419140172e-04, 9.783946048988972e-01, 1.787155606615631e-02
            7.448656691131475e-04, 9.573765994581499e-01, 3.947157915782751e-02
            1.412065815549544e-03, 9.297630167794994e-01, 6.627351491056133e-02
            2.224727631640653e-03, 8.856145379459155e-01, 1.102077998790501e-01
            2.783665001305457e-03, 8.276049258322035e-01, 1.680705718556547e-01
            2.828732887379463e-03, 9.407025269558742e-01, 4.040668518189694e-02
            3.103233153255804e-03, 7.614569472355972e-01, 2.341304485587009e-01
            3.272044293079879e-03, 6.910982450110276e-01, 3.044677273857715e-01
            3.498228070291966e-03, 6.169605688816800e-01, 3.785765158977044e-01
            3.712483365234321e-03, 5.382161471611688e-01, 4.572851693834520e-01
            4.419580029682573e-03, 8.994013923701005e-01, 7.945793126801071e-02
            5.830248850771098e-03, 8.454581623900932e-01, 1.323573959687528e-01
            6.805983147606651e-03, 7.820957505163639e-01, 1.950181531768703e-01
            7.244756449231553e-03, 7.137263028396675e-01, 2.631191352682924e-01
            7.365246444455634e-03, 8.536482523429226e-01, 9.441797701633908e-02
            7.602214679562964e-03, 6.426630574938507e-01, 3.340824932472560e-01
            8.179599095133277e-03, 5.674214259233257e-01, 4.091197068554255e-01
            9.227710562380342e-03, 7.958836448128479e-01, 1.496419104587032e-01
            1.040537513988348e-02, 7.316888477208925e-01, 2.124660862606801e-01
            1.123574776612298e-02, 6.633211243110193e-01, 2.804430557658052e-01
            1.221171092453195e-02, 7.521055125537387e-01, 1.484315128556529e-01
            1.221339402108772e-02, 5.898424124728381e-01, 3.535075359825963e-01
            1.290912404274592e-02, 5.114760443186676e-01, 4.314290404428223e-01
            1.440878233430379e-02, 6.851357411964050e-01, 2.130461279403018e-01
            1.612137548167229e-02, 6.111887224580397e-01, 2.861457938416554e-01
            1.731296231808816e-02, 5.310470504606351e-01, 3.653116277059748e-01
            1.779949913162692e-02, 6.167554053644048e-01, 2.236118954155827e-01
            1.976878664162552e-02, 5.409391154230521e-01, 2.977701162487290e-01
            2.096701966135284e-02, 4.598372365212220e-01, 3.774598302244840e-01
            2.309404106082227e-02, 4.666495391827076e-01, 3.032100432298113e-01];
        
        
        
        
end
