
function [xyw_bar,pointset_stats]=set_walkington_barycentric(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
%      REMARK: The sum of the weights makes 1.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t.
%    orthn. Dubiner basis, number of points with negative weights,
%    number of points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
% Walkington.
% Rule taken from: https://github.com/nschloe/quadpy#triangle
% Thanks to: Nico Schlmer.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   5 |   7 |   0 |   0 | 5.00e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.0e-16
        
        xyw_bar=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333425851918718763045e-01 2.25000000000000005551115123125783e-01
            5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 1.32394152788506164197812609018001e-01
            4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 1.32394152788506164197812609018001e-01
            4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 1.32394152788506164197812609018001e-01
            7.97426985353087314223330395179801e-01 1.01286507323456329010546994595643e-01 1.01286507323456356766122610224556e-01 1.25939180544827167285149016606738e-01
            1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 1.01286507323456342888334802410100e-01 1.25939180544827167285149016606738e-01
            1.01286507323456329010546994595643e-01 1.01286507323456329010546994595643e-01 7.97426985353087314223330395179801e-01 1.25939180544827167285149016606738e-01
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    5    7 5.00e-16    0    0
    ];





