
function [S1,S2,S3,pointset_stats]=set_wandzura_xiao_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  S. Wandzura, H. Xiao
%  "Symmetric Quadrature Rules on a Triangle",
%  Computers and Mathematics with Applications 45 (2003),
%  pp. 1829-1840.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   5 |   7 |   0 |   0 | 2.50e-16 |PI|
% |  10 |  25 |   0 |   0 | 8.85e-16 |PI|
% |  15 |  54 |   0 |   0 | 1.39e-15 |PI|
% |  20 |  85 |   0 |   0 | 7.67e-16 |PI|
% |  25 | 126 |   0 |   0 | 9.16e-16 |PI|
% |  30 | 175 |   0 |   0 | 1.75e-15 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.5e-16
        
        S1=[];
        
        S2=[
            1.32394152788506219708963840275828e-01 4.70142064105115109473587153843255e-01
            1.25939180544827139529573400977824e-01 1.01286507323456370643910418039013e-01
            ];
        
        S3=[
            2.25000000000000005551115123125783e-01
            ];
        
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.8e-16
        
        S1=[
            2.95183203347793993165382175902778e-02 1.36573576256033391018718248233199e-01 3.50029898972719771821360268404533e-02
            3.95793671960612408744495382961759e-02 3.32743600588638721582412927091355e-01 3.75490702584426669363715234339907e-02
            ];
        
        S2=[
            7.22985059205674338023150937715400e-03 4.97865432954474884663653710958897e-01
            7.44921779209805068333594135765452e-02 4.28012449729056221325862452431465e-01
            7.86464734031085271892536070481583e-02 1.84756412743224601724634226229682e-01
            6.92832308710750362223951270834732e-03 2.04812185716775514709997452200696e-02
            ];
        
        S3=[
            8.35233998051963799635899476925260e-02
            ];
        
        
    case  15
        
        % ALG. DEG.:   15
        % PTS CARD.:   54
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.4e-15
        
        S1=[
            8.52774810170943593778947189321116e-03 2.39534554154794410152362615917809e-01 9.91220330922478430613065114584970e-03
            1.39161765166919294128833328727524e-02 4.04878807318339972720622199631180e-01 1.58037706302280103742852190862322e-02
            4.29193294073483468803464901952793e-03 9.50021131130448365231799812136160e-02 5.14360881697066129464301909024471e-03
            1.62353292817748913468012261773765e-02 1.49753107322274009449714071706694e-01 4.89223257529887919914379779129376e-02
            2.56073409212623885611304075382577e-02 2.86919612441335014629828492616070e-01 6.87687486325192082192714337907091e-02
            3.30881955316456727311802410440578e-02 2.81835668099084613036353630377562e-01 1.68404418124699195580262767180102e-01
            ];
        
        S2=[
            3.26618188488052921258919525371311e-02 4.58280796369125109634978798567317e-01
            2.74128180313643610155338592448970e-02 4.03610464579130578943733098640223e-01
            2.65100365987032994541383601472262e-02 2.93197167913025413810146346804686e-01
            2.92159621364861087078335089017855e-02 1.46467786942772904001941469687154e-01
            1.05846080662439900182958396612776e-02 5.63628676656034027780961537246185e-02
            3.61464306409203491379789063842054e-03 1.65751268583703183223665433843053e-02
            ];
        
        S3=[];
        
        
    case  20
        
        % ALG. DEG.:   20
        % PTS CARD.:   85
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.7e-16
        
        S1=[
            2.34917090857558394367821108517091e-03 6.35496659083522041910896405170206e-02 5.34961818733725724683836233452894e-03
            4.46592575418179333485158011285421e-03 1.57106918940706996590250810186262e-01 7.95481706619893813581256836187094e-03
            6.09956680790797213520537667363897e-03 3.95642114364374075652364126653993e-01 1.04223982812637894213025901990477e-02
            6.89108132718820303591611420301888e-03 2.73167570712910479091561910536257e-01 1.09644147961233499877220509688414e-02
            7.99747507247816277753393876537302e-03 1.01785382485017103504354452070402e-01 3.85667120854623277081962839929474e-02
            7.38613428533602383446732275729119e-03 4.46658549176413788295292306429474e-01 3.55805078172181932227857714678976e-02
            1.27993318786482606491672342485799e-02 1.99010794149503095207265346289205e-01 4.96708163627641169357573858178512e-02
            1.72580711756965508862915470444932e-02 3.24261183692282684010166349253268e-01 5.85197250843317515189845323675399e-02
            1.86729459029354692700675144578781e-02 2.08531363210132908436733600865409e-01 1.21497787004394203203005986324570e-01
            2.28182240583952589130234400727204e-02 3.23170566536257475309668052432244e-01 1.40710844943938706563812957028858e-01
            ];
        
        S2=[
            1.77902954732674003363035453162411e-03 4.99249675337785525641720596468076e-01
            2.01123981139611704427316851706564e-02 4.52930124030524572376066316792276e-01
            2.68178472593315689320725425659475e-02 3.97763937955236790422475223749643e-01
            2.45231338015020096376961333817235e-02 2.64500202532787276332726378313964e-01
            1.63945784106953908187964685794213e-02 2.11018964092076793948038471171458e-01
            1.47959073986495999453172345283747e-02 1.07735607171271299820070055375254e-01
            4.57928227770425071152526896867130e-03 3.90690878378026629214048170979368e-02
            1.65182651557621703805600610337478e-03 1.11743797293295792777412245300184e-02
            ];
        
        S3=[
            2.76104269976995206348213685032533e-02
            ];
        
        
    case  25
        
        % ALG. DEG.:   25
        % PTS CARD.:  126
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 9.2e-16
        
        S1=[
            1.24828919927739696686674886194623e-03 2.27214452153364110387201435514726e-01 1.29235270444220495637821510825916e-03
            3.40475290880302202539686717841505e-03 4.35010554853571707045745142750093e-01 5.39970127211619656953933699128356e-03
            3.35965432606405087212486648695631e-03 3.20309599272204481579251478251535e-01 6.38400303397501558272386645853658e-03
            1.71615653949675405973152031435802e-03 9.17503222800051948526700584807259e-02 5.02821150199306288186562596820295e-03
            1.48085631671560601085868569271042e-03 3.80108358587243413961864746397623e-02 6.82675862178187386336558617472292e-03
            3.51131261072868501235677562988258e-03 1.57425218485311713134677802372607e-01 1.00161996399295398496587239378641e-02
            7.39355014970648379002415850891339e-03 2.39889659778533187450832997456018e-01 2.57578131733899907962470621214379e-02
            7.98308747737655824416869165816024e-03 3.61943118126060503492169573291903e-01 3.02278981199158094939072327633767e-02
            4.35596261315804138269935918970077e-03 8.35519609548285163702630029547436e-02 3.05049901071620804815509586660482e-02
            7.36505670141783183590966643805587e-03 1.48443220732418112994821512984345e-01 4.59565473625693429737815165481152e-02
            1.09635728464195503217837313059135e-02 2.83739708727535011600906500461861e-01 6.74428005402775559984362985233020e-02
            1.17499617435411207733153560184292e-02 4.06899375118787487437543859414291e-01 7.00450914159106013956446190604765e-02
            1.00156007137985701010984840308993e-02 1.94113987024892492572192281841126e-01 8.39115246401165998380022870151151e-02
            1.33096407876286803445564643766375e-02 3.24134347000703093577556046511745e-01 1.20375535677152700753111957965302e-01
            1.41544465052261397852717550449597e-02 2.29277483555980987617317623517010e-01 1.48066899157366704820049108093372e-01
            1.48813795611680097646933873534181e-02 3.25618122595983716660583695556852e-01 1.91771865867325086441042003571056e-01
            ];
        
        S2=[
            8.00558188002041710984446609700171e-03 4.86026758463412922317559150542365e-01
            1.59470768323905012775476564002020e-02 4.34410699336174321860681857288000e-01
            1.31091412307955297589234788802059e-02 3.89889135243963791399579577046097e-01
            1.95830009656356197889071069084821e-02 2.98443234019804382040064183456707e-01
            1.64708854415372696333719204631052e-02 2.34044172337371791936533327316283e-01
            8.54727907409210015121647785463210e-03 1.51468334609017596381619341627811e-01
            8.16188585722649184717170101066586e-03 1.12733893545993599238919102845102e-01
            6.12114653998377909738248803250826e-03 7.77156920915262616755825320069562e-02
            2.90849826493666486701417106530698e-03 3.48930936142970368751825560593716e-02
            6.92275245661996287659112336854150e-04 7.25818462093234025717114477060932e-03
            ];
        
        S3=[];
        
        
    case  30
        
        % ALG. DEG.:   30
        % PTS CARD.:  175
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.7e-15
        
        S1=[
            9.98905685078896408285453745179439e-04 4.15295270913311698190995002732961e-01 9.25371193346458120743136532837525e-04
            4.62850849173253309221109930149396e-04 6.11899097853490434029133382409782e-02 1.38592585556392600305841700247811e-03
            1.23445133638241293441706325495488e-03 1.64908690136906593837196055574168e-01 3.68241545591074803667197556933388e-03
            5.70719852243206150245458108116736e-04 2.50350622320024696065843272663187e-02 3.90322342415934907255969932293738e-03
            1.12694612587762406016866911784291e-03 3.06064465151095699280148210164043e-01 3.23324815501054496288957373906214e-03
            1.74786694940733708207580843208007e-03 1.07073283730218099529807318504027e-01 6.46743211223647484348076019955442e-03
            1.18281881503165694179136036012778e-03 2.29957549345584294497868427242793e-01 3.24747549133267820326009811537915e-03
            1.99083929467503382981785620131632e-03 3.37036633305782873382128173034289e-01 8.67509080675380774005933659509537e-03
            1.90041279503597995356733996175080e-03 5.62565761820607301846308700987720e-02 1.55970264673138698380272515464640e-02
            4.49836580881745121129888786981610e-03 4.02451375212400985770244687955710e-01 1.79767212536852093174299938027616e-02
            3.47871946027471885473647539299691e-03 2.43654702010828505542860966670560e-01 1.71242453538893411868482274940106e-02
            4.10239903672395336831080214778922e-03 1.65389585614532708124357895940193e-01 2.28834053465818802741704729442063e-02
            4.02176154974416208420784357713273e-03 9.93018744958468480010793655310408e-02 3.27375972877666718274802803989587e-02
            6.03316466079506594916148642937515e-03 3.08478333069055088433430000804947e-01 3.38210123423409170229092524095904e-02
            3.94629030212959811679818145080390e-03 4.60668318592112990828013607824687e-01 3.55476144600152671459980524559796e-02
            6.64404453768026835580595701458151e-03 2.18815299453929607009783353532839e-01 5.05397903068665402259718177901959e-02
            8.25430585607845809792415536776389e-03 3.79209551560274082948609475351986e-01 5.70147149157322133405934039274143e-02
            6.49605663340641070746528384916019e-03 1.42960819418185391960207653028192e-01 6.41528064212033982682825694610074e-02
            9.25277814414660233766074526329248e-03 2.83731282105925020076142573088873e-01 8.05011482876255984875157878377649e-02
            9.16492072629427993735173885170298e-03 1.96737441004440793967944500764133e-01 1.04367068134530505130186384121771e-01
            1.15695246280976705294252226963181e-02 3.55889141211662096697665447209147e-01 1.13844894428751300385904698941886e-01
            1.17611164676091704134330839792710e-02 2.59818685351911493608412229150417e-01 1.45363487715523709287168685477809e-01
            1.38247021821654002965429341998060e-02 3.21923181231298427551479335306794e-01 1.89945652821978699931193546035502e-01
            ];
        
        S2=[
            3.17723370053413396718600125723242e-03 4.96334941783617311639176250537275e-01
            1.04834266357307706596380114660860e-02 4.58502162098517684896137325267773e-01
            1.32094595777436304984142623197840e-02 4.24509521937294798110684723724262e-01
            1.49750069662714993534713414646831e-02 3.82047070053916693055384712351952e-01
            1.49879044433841902839166237981772e-02 2.80987845796075885740350486230454e-01
            1.33388647410216595878829082266748e-02 2.27348975854034407451109700559755e-01
            1.08891711139020106596797532461096e-02 1.74559111508729797312966525169031e-01
            8.18944066089346070502763552667602e-03 1.23258427201436593367844807289657e-01
            5.57538758860778513315459292698506e-03 8.00842288921968376014248747196689e-02
            3.19121647341197604494378303741087e-03 4.77744674078987782706029463497543e-02
            1.29671514432704504046767191027811e-03 2.17205146801415088786413321031432e-02
            2.98262826134917187655137826851615e-04 4.76467761543701399939987339848813e-03
            ];
        
        S3=[
            1.55799602028991995145146276513515e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    5    7 2.50e-16    0    0
    10   25 8.85e-16    0    0
    15   54 1.39e-15    0    0
    20   85 7.67e-16    0    0
    25  126 9.16e-16    0    0
    30  175 1.75e-15    0    0
    ];




