
function [S1,S2,S3,pointset_stats]=set_williams_shunn_jameson_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  D.M. Williams, L. Shunn, A. Jameson,
%  "Symmetric quadrature rules for simplexes based on sphere close packed
%  lattice arrangements",
%  Journal of Computational and Applied Mathematics,
%  266 (2014), pp.18-38,
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 3.68e-16 |PI|
% |   4 |   6 |   0 |   0 | 7.83e-14 |PI|
% |   5 |  10 |   0 |   0 | 3.94e-15 |PI|
% |   7 |  15 |   0 |   0 | 5.67e-14 |PI|
% |   8 |  21 |   0 |   0 | 1.14e-12 |PI|
% |  10 |  28 |   0 |   0 | 4.04e-13 |PI|
% |  12 |  36 |   0 |   0 | 1.32e-12 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        S1=[];
        
        S2=[];
        
        S3=[
            1.00000000000000000000000000000000e+00
            ];
        
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        S1=[];
        
        S2=[
            3.33333333333333314829616256247391e-01 1.66666666666666657414808128123695e-01
            ];
        
        S3=[];
        
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.8e-14
        
        S1=[];
        
        S2=[
            1.09951743655333000759810602176003e-01 9.15762135097799995220313462596096e-02
            2.23381589678000008758473882153339e-01 4.45948490915964002034854729572544e-01
            ];
        
        S3=[];
        
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:   10
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-15
        
        S1=[
            1.12098412070886999103436210134532e-01 2.95533711735892989924678886382026e-01 6.34210747745722946966395738854771e-01
            ];
        
        S2=[
            4.19555129966489998016854201523529e-02 5.55640526697930015043169760247110e-02
            ];
        
        S3=[
            2.01542988584729992895816508280404e-01
            ];
        
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.7e-14
        
        S1=[
            5.57498100271150015538879074483702e-02 2.01503881881799989939096917623829e-01 7.51183631106484006600965130928671e-01
            ];
        
        S2=[
            1.79154550123029991659517889956987e-02 3.58708776957340005897556522995728e-02
            1.27712195881265005992233341203246e-01 2.41729395767967009112098253353906e-01
            7.62060623855349977828765872800432e-02 4.74308787777079021719117690736311e-01
            ];
        
        S3=[];
        
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   21
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.1e-12
        
        S1=[
            2.89692693724729992410527046331481e-02 1.48565812270886998813779200645513e-01 8.17900980028498980622941871843068e-01
            4.60463665959350010314921064491500e-02 3.57196298615680973842501089166035e-01 6.04978911775131966699348140537040e-01
            ];
        
        S2=[
            1.03593746965380002073020548891691e-02 2.81129521826639985904172647224186e-02
            7.53948843267379931187832653449732e-02 1.77139098469316996764533200803271e-01
            9.75478023732419957658734688266122e-02 4.05508595867432986015188589590252e-01
            ];
        
        S3=[];
        
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.0e-13
        
        S1=[
            1.57104613401829983077018226822474e-02 1.07951981846010999777085714868008e-01 8.67911210117951026354887744673761e-01
            2.82051362806160013652068130340922e-02 2.70840772921566996789266568157473e-01 7.00872570380723036720382879138924e-01
            6.69959571278300053398524482872745e-02 3.16549598844616975057419949735049e-01 5.36654684206138044011424881318817e-01
            ];
        
        S2=[
            5.27217028049500012476524801741107e-03 1.99771871221929991913057733654568e-02
            4.45529366795040029924912516889890e-02 1.31721767529998007306701879315369e-01
            3.38157128041979976318387457467907e-02 4.85135346793460986436485882222769e-01
            ];
        
        S3=[
            8.36082122156369955678911765062367e-02
            ];
        
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   36
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.3e-12
        
        S1=[
            9.86675357464599986356823535516014e-03 1.01763679498020995217721917924791e-01 8.79979641427231951134046994411619e-01
            2.20082048001470007014823693225480e-02 3.94033271669986973062549395763199e-01 5.82562022863672979156035580672324e-01
            1.66445700767360003913264421271379e-02 2.26245530909228997895610291379853e-01 7.51530614542782027243106313108001e-01
            4.43262381189140006187976439377962e-02 6.35737183263105021246985870675417e-01 2.49079227621332000008891327524907e-01
            ];
        
        S2=[
            5.63912378691000006070144223713214e-03 2.11714227794650017289157517552667e-02
            2.71489681922780015654872443064960e-02 1.00584397395887994997032421906624e-01
            6.31009125333590048523291216042708e-02 2.71038307711931991672571484741638e-01
            5.17527956798990024234186080320796e-02 4.40191258403831997547683840821264e-01
            ];
        
        S3=[];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    2    3 3.68e-16    0    0
    4    6 7.83e-14    0    0
    5   10 3.94e-15    0    0
    7   15 5.67e-14    0    0
    8   21 1.14e-12    0    0
    10   28 4.04e-13    0    0
    12   36 1.32e-12    0    0
    ];




