
function [xyw,pointset_stats]=set_williams_shunn_jameson_standard(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN STANDARD FORM.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis,number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  D.M. Williams, L. Shunn, A. Jameson,
%  "Symmetric quadrature rules for simplexes based on sphere close packed
%  lattice arrangements",
%  Journal of Computational and Applied Mathematics,
%  266 (2014), pp.18-38,
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 3.68e-16 |PI|
% |   4 |   6 |   0 |   0 | 7.83e-14 |PI|
% |   5 |  10 |   0 |   0 | 3.94e-15 |PI|
% |   7 |  15 |   0 |   0 | 5.67e-14 |PI|
% |   8 |  21 |   0 |   0 | 1.14e-12 |PI|
% |  10 |  28 |   0 |   0 | 4.04e-13 |PI|
% |  12 |  36 |   0 |   0 | 1.32e-12 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------


switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 5.00000000000000000000000000000000e-01
            ];
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        xyw=[
            1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01
            1.66666666666666657414808128123695e-01 6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01
            6.66666666666666740681534975010436e-01 1.66666666666666657414808128123695e-01 1.66666666666666657414808128123695e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.8e-14
        
        xyw=[
            9.15762135097799995220313462596096e-02 9.15762135097799995220313462596096e-02 5.49758718276665489521626284386002e-02
            9.15762135097799995220313462596096e-02 8.16847572980439973200361691851867e-01 5.49758718276665489521626284386002e-02
            8.16847572980439973200361691851867e-01 9.15762135097799995220313462596096e-02 5.49758718276665489521626284386002e-02
            4.45948490915964002034854729572544e-01 4.45948490915964002034854729572544e-01 1.11690794839000101523751595777867e-01
            4.45948490915964002034854729572544e-01 1.08103018168071995930290540854912e-01 1.11690794839000101523751595777867e-01
            1.08103018168071995930290540854912e-01 4.45948490915964002034854729572544e-01 1.11690794839000101523751595777867e-01
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:   10
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-15
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.00771494292365107470210716655856e-01
            5.55640526697930015043169760247110e-02 5.55640526697930015043169760247110e-02 2.09777564983245241869713737514758e-02
            5.55640526697930015043169760247110e-02 8.88871894660413941480214816692751e-01 2.09777564983245241869713737514758e-02
            8.88871894660413941480214816692751e-01 5.55640526697930015043169760247110e-02 2.09777564983245241869713737514758e-02
            2.95533711735892989924678886382026e-01 6.34210747745722946966395738854771e-01 5.60492060354435620017632402323216e-02
            2.95533711735892989924678886382026e-01 7.02555405183841186200766060210299e-02 5.60492060354435620017632402323216e-02
            6.34210747745722946966395738854771e-01 2.95533711735892989924678886382026e-01 5.60492060354435620017632402323216e-02
            6.34210747745722946966395738854771e-01 7.02555405183841186200766060210299e-02 5.60492060354435620017632402323216e-02
            7.02555405183841186200766060210299e-02 2.95533711735892989924678886382026e-01 5.60492060354435620017632402323216e-02
            7.02555405183841186200766060210299e-02 6.34210747745722946966395738854771e-01 5.60492060354435620017632402323216e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.7e-14
        
        xyw=[
            3.58708776957340005897556522995728e-02 3.58708776957340005897556522995728e-02 8.95772750615151172604022633549903e-03
            3.58708776957340005897556522995728e-02 9.28258244608532012698276503215311e-01 8.95772750615151172604022633549903e-03
            9.28258244608532012698276503215311e-01 3.58708776957340005897556522995728e-02 8.95772750615151172604022633549903e-03
            2.41729395767967009112098253353906e-01 2.41729395767967009112098253353906e-01 6.38560979406325862628435174883634e-02
            2.41729395767967009112098253353906e-01 5.16541208464065926264652262034360e-01 6.38560979406325862628435174883634e-02
            5.16541208464065926264652262034360e-01 2.41729395767967009112098253353906e-01 6.38560979406325862628435174883634e-02
            4.74308787777079021719117690736311e-01 4.74308787777079021719117690736311e-01 3.81030311927675474636956209906202e-02
            4.74308787777079021719117690736311e-01 5.13824244458419565617646185273770e-02 3.81030311927675474636956209906202e-02
            5.13824244458419565617646185273770e-02 4.74308787777079021719117690736311e-01 3.81030311927675474636956209906202e-02
            2.01503881881799989939096917623829e-01 7.51183631106484006600965130928671e-01 2.78749050135575389408604252139412e-02
            2.01503881881799989939096917623829e-01 4.73124870117159757043623358185869e-02 2.78749050135575389408604252139412e-02
            7.51183631106484006600965130928671e-01 2.01503881881799989939096917623829e-01 2.78749050135575389408604252139412e-02
            7.51183631106484006600965130928671e-01 4.73124870117159757043623358185869e-02 2.78749050135575389408604252139412e-02
            4.73124870117159757043623358185869e-02 2.01503881881799989939096917623829e-01 2.78749050135575389408604252139412e-02
            4.73124870117159757043623358185869e-02 7.51183631106484006600965130928671e-01 2.78749050135575389408604252139412e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   21
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.1e-12
        
        xyw=[
            2.81129521826639985904172647224186e-02 2.81129521826639985904172647224186e-02 5.17968734826898969531017158374198e-03
            2.81129521826639985904172647224186e-02 9.43774095634671961185802047111792e-01 5.17968734826898969531017158374198e-03
            9.43774095634671961185802047111792e-01 2.81129521826639985904172647224186e-02 5.17968734826898969531017158374198e-03
            1.77139098469316996764533200803271e-01 1.77139098469316996764533200803271e-01 3.76974421633689202315586896929744e-02
            1.77139098469316996764533200803271e-01 6.45721803061366061982084829651285e-01 3.76974421633689202315586896929744e-02
            6.45721803061366061982084829651285e-01 1.77139098469316996764533200803271e-01 3.76974421633689202315586896929744e-02
            4.05508595867432986015188589590252e-01 4.05508595867432986015188589590252e-01 4.87739011866209007384220797121088e-02
            4.05508595867432986015188589590252e-01 1.88982808265134027969622820819495e-01 4.87739011866209007384220797121088e-02
            1.88982808265134027969622820819495e-01 4.05508595867432986015188589590252e-01 4.87739011866209007384220797121088e-02
            1.48565812270886998813779200645513e-01 8.17900980028498980622941871843068e-01 1.44846346862364701302272607108534e-02
            1.48565812270886998813779200645513e-01 3.35332077006139650521276962535921e-02 1.44846346862364701302272607108534e-02
            8.17900980028498980622941871843068e-01 1.48565812270886998813779200645513e-01 1.44846346862364701302272607108534e-02
            8.17900980028498980622941871843068e-01 3.35332077006139650521276962535921e-02 1.44846346862364701302272607108534e-02
            3.35332077006139650521276962535921e-02 1.48565812270886998813779200645513e-01 1.44846346862364701302272607108534e-02
            3.35332077006139650521276962535921e-02 8.17900980028498980622941871843068e-01 1.44846346862364701302272607108534e-02
            3.57196298615680973842501089166035e-01 6.04978911775131966699348140537040e-01 2.30231832979674554129356778275906e-02
            3.57196298615680973842501089166035e-01 3.78247896091871149693020015547518e-02 2.30231832979674554129356778275906e-02
            6.04978911775131966699348140537040e-01 3.57196298615680973842501089166035e-01 2.30231832979674554129356778275906e-02
            6.04978911775131966699348140537040e-01 3.78247896091871149693020015547518e-02 2.30231832979674554129356778275906e-02
            3.78247896091871149693020015547518e-02 3.57196298615680973842501089166035e-01 2.30231832979674554129356778275906e-02
            3.78247896091871149693020015547518e-02 6.04978911775131966699348140537040e-01 2.30231832979674554129356778275906e-02
            ];
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.0e-13
        
        xyw=[
            3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.18041061078184075783248374591494e-02
            1.99771871221929991913057733654568e-02 1.99771871221929991913057733654568e-02 2.63608514024749442453132708408248e-03
            1.99771871221929991913057733654568e-02 9.60045625755614029372964068898000e-01 2.63608514024749442453132708408248e-03
            9.60045625755614029372964068898000e-01 1.99771871221929991913057733654568e-02 2.63608514024749442453132708408248e-03
            1.31721767529998007306701879315369e-01 1.31721767529998007306701879315369e-01 2.22764683397519529239882984938959e-02
            1.31721767529998007306701879315369e-01 7.36556464940004040897747472627088e-01 2.22764683397519529239882984938959e-02
            7.36556464940004040897747472627088e-01 1.31721767529998007306701879315369e-01 2.22764683397519529239882984938959e-02
            4.85135346793460986436485882222769e-01 4.85135346793460986436485882222769e-01 1.69078564020989606520029013836393e-02
            4.85135346793460986436485882222769e-01 2.97293064130780271270282355544623e-02 1.69078564020989606520029013836393e-02
            2.97293064130780271270282355544623e-02 4.85135346793460986436485882222769e-01 1.69078564020989606520029013836393e-02
            1.07951981846010999777085714868008e-01 8.67911210117951026354887744673761e-01 7.85523067009148180661615157305278e-03
            1.07951981846010999777085714868008e-01 2.41368080360380155013899639016017e-02 7.85523067009148180661615157305278e-03
            8.67911210117951026354887744673761e-01 1.07951981846010999777085714868008e-01 7.85523067009148180661615157305278e-03
            8.67911210117951026354887744673761e-01 2.41368080360380155013899639016017e-02 7.85523067009148180661615157305278e-03
            2.41368080360380155013899639016017e-02 1.07951981846010999777085714868008e-01 7.85523067009148180661615157305278e-03
            2.41368080360380155013899639016017e-02 8.67911210117951026354887744673761e-01 7.85523067009148180661615157305278e-03
            2.70840772921566996789266568157473e-01 7.00872570380723036720382879138924e-01 1.41025681403079694575808389345184e-02
            2.70840772921566996789266568157473e-01 2.82866566977100220015017839614302e-02 1.41025681403079694575808389345184e-02
            7.00872570380723036720382879138924e-01 2.70840772921566996789266568157473e-01 1.41025681403079694575808389345184e-02
            7.00872570380723036720382879138924e-01 2.82866566977100220015017839614302e-02 1.41025681403079694575808389345184e-02
            2.82866566977100220015017839614302e-02 2.70840772921566996789266568157473e-01 1.41025681403079694575808389345184e-02
            2.82866566977100220015017839614302e-02 7.00872570380723036720382879138924e-01 1.41025681403079694575808389345184e-02
            3.16549598844616975057419949735049e-01 5.36654684206138044011424881318817e-01 3.34979785639149263420932811641251e-02
            3.16549598844616975057419949735049e-01 1.46795716949244980931155168946134e-01 3.34979785639149263420932811641251e-02
            5.36654684206138044011424881318817e-01 3.16549598844616975057419949735049e-01 3.34979785639149263420932811641251e-02
            5.36654684206138044011424881318817e-01 1.46795716949244980931155168946134e-01 3.34979785639149263420932811641251e-02
            1.46795716949244980931155168946134e-01 3.16549598844616975057419949735049e-01 3.34979785639149263420932811641251e-02
            1.46795716949244980931155168946134e-01 5.36654684206138044011424881318817e-01 3.34979785639149263420932811641251e-02
            ];
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   36
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.3e-12
        
        xyw=[
            2.11714227794650017289157517552667e-02 2.11714227794650017289157517552667e-02 2.81956189345501130605331496781218e-03
            2.11714227794650017289157517552667e-02 9.57657154441070024297744112118380e-01 2.81956189345501130605331496781218e-03
            9.57657154441070024297744112118380e-01 2.11714227794650017289157517552667e-02 2.81956189345501130605331496781218e-03
            1.00584397395887994997032421906624e-01 1.00584397395887994997032421906624e-01 1.35744840961390545591713774342679e-02
            1.00584397395887994997032421906624e-01 7.98831205208224037761510771815665e-01 1.35744840961390545591713774342679e-02
            7.98831205208224037761510771815665e-01 1.00584397395887994997032421906624e-01 1.35744840961390545591713774342679e-02
            2.71038307711931991672571484741638e-01 2.71038307711931991672571484741638e-01 3.15504562666796273262548311322462e-02
            2.71038307711931991672571484741638e-01 4.57923384576136016654857030516723e-01 3.15504562666796273262548311322462e-02
            4.57923384576136016654857030516723e-01 2.71038307711931991672571484741638e-01 3.15504562666796273262548311322462e-02
            4.40191258403831997547683840821264e-01 4.40191258403831997547683840821264e-01 2.58763978399496052951178626244655e-02
            4.40191258403831997547683840821264e-01 1.19617483192336004904632318357471e-01 2.58763978399496052951178626244655e-02
            1.19617483192336004904632318357471e-01 4.40191258403831997547683840821264e-01 2.58763978399496052951178626244655e-02
            1.01763679498020995217721917924791e-01 8.79979641427231951134046994411619e-01 4.93337678732301988110409141086166e-03
            1.01763679498020995217721917924791e-01 1.82566790747470397704432798491325e-02 4.93337678732301988110409141086166e-03
            8.79979641427231951134046994411619e-01 1.01763679498020995217721917924791e-01 4.93337678732301988110409141086166e-03
            8.79979641427231951134046994411619e-01 1.82566790747470397704432798491325e-02 4.93337678732301988110409141086166e-03
            1.82566790747470397704432798491325e-02 1.01763679498020995217721917924791e-01 4.93337678732301988110409141086166e-03
            1.82566790747470397704432798491325e-02 8.79979641427231951134046994411619e-01 4.93337678732301988110409141086166e-03
            3.94033271669986973062549395763199e-01 5.82562022863672979156035580672324e-01 1.10041024000735437188280840814514e-02
            3.94033271669986973062549395763199e-01 2.34047054663399922702637923066504e-02 1.10041024000735437188280840814514e-02
            5.82562022863672979156035580672324e-01 3.94033271669986973062549395763199e-01 1.10041024000735437188280840814514e-02
            5.82562022863672979156035580672324e-01 2.34047054663399922702637923066504e-02 1.10041024000735437188280840814514e-02
            2.34047054663399922702637923066504e-02 3.94033271669986973062549395763199e-01 1.10041024000735437188280840814514e-02
            2.34047054663399922702637923066504e-02 5.82562022863672979156035580672324e-01 1.10041024000735437188280840814514e-02
            2.26245530909228997895610291379853e-01 7.51530614542782027243106313108001e-01 8.32228503836803315540926462290372e-03
            2.26245530909228997895610291379853e-01 2.22238545479889193501321642543189e-02 8.32228503836803315540926462290372e-03
            7.51530614542782027243106313108001e-01 2.26245530909228997895610291379853e-01 8.32228503836803315540926462290372e-03
            7.51530614542782027243106313108001e-01 2.22238545479889193501321642543189e-02 8.32228503836803315540926462290372e-03
            2.22238545479889193501321642543189e-02 2.26245530909228997895610291379853e-01 8.32228503836803315540926462290372e-03
            2.22238545479889193501321642543189e-02 7.51530614542782027243106313108001e-01 8.32228503836803315540926462290372e-03
            6.35737183263105021246985870675417e-01 2.49079227621332000008891327524907e-01 2.21631190594570905150195727628670e-02
            6.35737183263105021246985870675417e-01 1.15183589115562978744122801799676e-01 2.21631190594570905150195727628670e-02
            2.49079227621332000008891327524907e-01 6.35737183263105021246985870675417e-01 2.21631190594570905150195727628670e-02
            2.49079227621332000008891327524907e-01 1.15183589115562978744122801799676e-01 2.21631190594570905150195727628670e-02
            1.15183589115562978744122801799676e-01 6.35737183263105021246985870675417e-01 2.21631190594570905150195727628670e-02
            1.15183589115562978744122801799676e-01 2.49079227621332000008891327524907e-01 2.21631190594570905150195727628670e-02
            ];
        
        
    otherwise
        xyw=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    2    3 3.68e-16    0    0
    4    6 7.83e-14    0    0
    5   10 3.94e-15    0    0
    7   15 5.67e-14    0    0
    8   21 1.14e-12    0    0
    10   28 4.04e-13    0    0
    12   36 1.32e-12    0    0
    ];



