
function [S1,S2,S3,pointset_stats]=set_witherden_vincent_compact(deg)

%--------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% THE CUBATURE RULE IS DESCRIBED IN COMPACT FORM VIA ITS ROTATIONS.
%--------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
%--------------------------------------------------------------------
% OUTPUT:
% S1,S2,S3,w:
%    S1 is a matrix N1 x 3,
%    S2 is a matrix N2 x 2,
%    S3 is a matrix N3 x 1,
%    with N1, N2, N3 possibly zero.
%    The pointset is written in terms of rotations of type s1, s2, s3
%    applied resp. to S1, S2, S3, where:
%    s1(w,a,b): [a b c w; a c b w; b a c w; b c a w; c a b w; c b a w];
%            with c=1-a-b.
%    s2(w,a): [a a c w; a c a w; c a a w];
%            with c=1-2*a.
%    s3(w): [1/3 1/3 1/3 w];
%    S1 gives points of which one has to consider all the rotations of
%    type s1.
%    S2 gives points of which one has to consider all the rotations of
%    type s2.
%    S3 gives points of which one has to consider all the rotations of
%    type s3.
%    REMARK: the sum of the weights of the set extracted from S1,S2,S3,
%            for each rule, makes 1/2.
%    REMARK: in S1, S2, S3, the first component is that of the weight w.
%
% pointset_stats:
%    statistics of the pointset stored in a matrix. Each rows contains
%    degree, cardinality of the full pointset, moment error w.r.t. orthn.
%    Dubiner basis, number of points with negative weights, number of
%    points outside the domain.
%--------------------------------------------------------------------
% SOURCE:
%  F.D: Witherden, P.E. Vincent.
%  "On the identification of symmetric quadrature rules for finite
%  element methods".
%  Computers and Mathematics with Applications 69 (2015) 1232-1241.
%--------------------------------------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%--------------------------------------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   4 |   6 |   0 |   0 | 1.39e-16 |PI|
% |   5 |   7 |   0 |   0 | 1.98e-16 |PI|
% |   6 |  12 |   0 |   0 | 2.36e-16 |PI|
% |   7 |  15 |   0 |   0 | 3.75e-16 |PI|
% |   8 |  16 |   0 |   0 | 8.05e-16 |PI|
% |   9 |  19 |   0 |   0 | 3.26e-16 |PI|
% |  10 |  25 |   0 |   0 | 4.86e-16 |PI|
% |  11 |  28 |   0 |   0 | 1.49e-15 |PI|
% |  12 |  33 |   0 |   0 | 6.52e-16 |PI|
% |  13 |  37 |   0 |   0 | 5.83e-16 |PI|
% |  14 |  42 |   0 |   0 | 4.37e-16 |PI|
% |  15 |  49 |   0 |   0 | 5.62e-16 |PI|
% |  16 |  55 |   0 |   0 | 6.11e-16 |PI|
% |  17 |  60 |   0 |   0 | 4.09e-16 |PI|
% |  18 |  67 |   0 |   0 | 9.00e-16 |PI|
% |  19 |  73 |   0 |   0 | 6.38e-16 |PI|
% |  20 |  79 |   0 |   0 | 7.46e-16 |PI|
%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------



switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        S1=[];
        
        S2=[];
        
        S3=[
            5.00000000000000000000000000000000e-01
            ];
        
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.4e-16
        
        S1=[];
        
        S2=[
            1.11690794839005735905601568447310e-01 4.45948490915964890213274429697776e-01
            5.49758718276609353869943674908427e-02 9.15762135097707430375635340169538e-02
            ];
        
        S3=[];
        
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.0e-16
        
        S1=[];
        
        S2=[
            6.29695902724135697647867004889122e-02 1.01286507323456342888334802410100e-01
            6.61970763942530959766941123234574e-02 4.70142064105115109473587153843255e-01
            ];
        
        S3=[
            1.12500000000000002775557561562891e-01
            ];
        
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.4e-16
        
        S1=[
            4.14255378091867854095653456170112e-02 5.31450498448169383891581674106419e-02 3.10352451033784393352732422499685e-01
            ];
        
        S2=[
            2.54224531851034094009911257217027e-02 6.30890144915022266225435032538371e-02
            5.83931378631896841335802150751988e-02 2.49286745170910428726074314909056e-01
            ];
        
        S3=[];
        
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        S1=[
            2.79393664515998896291648634360172e-02 4.70366446525952164314787751209224e-02 1.98683314797351573410821856668917e-01
            ];
        
        S2=[
            8.27252505539606552975584463638370e-03 3.37306485545878498299998682341538e-02
            6.39720856150777922310979306530498e-02 2.41577382595403566956093754924950e-01
            3.85433230929930342734124337766843e-02 4.74309692504718216632397798093734e-01
            ];
        
        S3=[];
        
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.0e-16
        
        S1=[
            1.36151570872174963733325370185412e-02 8.39477740995758781039626228448469e-03 2.63112829634638112352718053443823e-01
            ];
        
        S2=[
            4.75458171336423096597911808203207e-02 4.59292588292723125142913431773195e-01
            5.16086852673591223172877562319627e-02 1.70569307751760212976677166807349e-01
            1.62292488115990396480015078850556e-02 5.05472283170309566457945038564503e-02
            ];
        
        S3=[
            7.21578038388935860680817313550506e-02
            ];
        
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.3e-16
        
        S1=[
            2.16417696886446880855103813701135e-02 3.68384120547362581277184290229343e-02 2.21962989160765677976172582930303e-01
            ];
        
        S2=[
            3.89137705023871391385448248456669e-02 4.37089591492936635486188379218220e-01
            3.98238694636051243636032381800760e-02 1.88203535619032746861734040066949e-01
            1.56673501135695357466826038717045e-02 4.89682519198737620236272505280795e-01
            1.27888378293490156262235402095939e-02 4.47295133944526912550543329416541e-02
            ];
        
        S3=[
            4.85678981413994181881577105741599e-02
            ];
        
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.9e-16
        
        S1=[
            3.19524531982120219009146921962383e-02 3.21812995288835446139330542791868e-01 5.30054118927343997924594987125602e-01
            1.70923240814797143538594781375650e-02 2.96198894887297892175581637275172e-02 6.01233328683459244956566180917434e-01
            1.26488788536441923437969592214358e-02 2.83676653399384526288429242413258e-02 1.63701733737182497652185020342586e-01
            ];
        
        S2=[
            6.67648440657478327991958266807160e-03 3.20553732169435168231075294897892e-02
            2.29789818023723654838441632364265e-02 1.42161101056564376232671520483564e-01
            ];
        
        S3=[
            4.08716645731429864540906748970883e-02
            ];
        
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.5e-15
        
        S1=[
            5.14514478647663895533037603513549e-03 1.49324788652082374174057122218073e-01 8.43349783661853091842885987716727e-01
            2.01662383202502772105990658246810e-02 4.60105001654299572422246455971617e-02 2.89581125637705882880368335463572e-01
            ];
        
        S2=[
            5.21593525644734826857140674860602e-03 2.84854176143718995639630975347245e-02
            3.52578420558582877886166784264788e-02 2.10219956703178278978327853110386e-01
            1.93153796185096607307407623466133e-02 1.02635482712246428604885295499116e-01
            8.30313652729268436569753930598381e-03 4.95891900965890919383838308931445e-01
            3.36580770397341480504316280075727e-02 4.38465926764352198485852341036662e-01
            ];
        
        S3=[
            4.28805898661121093207171384165122e-02
            ];
        
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   33
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.5e-16
        
        S1=[
            1.08917925193037796322004240323622e-02 2.91655679738340944950891753251199e-01 6.85310163906391878185786481481045e-01
            2.16136818297071042760393311255029e-02 1.16296019677926576463278252049349e-01 2.55454228638517355509662820622907e-01
            7.54183878825571887144496585619891e-03 8.51337792510240110033237215247937e-01 1.27279717233589384495218155279872e-01
            ];
        
        S2=[
            1.21334190407260157640312314697439e-02 4.88203750945541525840809526926023e-01
            1.42430260344387719234626743514127e-02 1.09257827659354267435531937735504e-01
            3.12706065979513822550295287783229e-02 2.71462507014926079929040270144469e-01
            3.96582125498681943576162467479662e-03 2.46463634363355832412878498871578e-02
            2.49591674640304711507710067053267e-02 4.40111648658593090921442581020528e-01
            ];
        
        S3=[];
        
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.8e-16
        
        S1=[
            1.20895199057969096601006242508447e-02 8.78954830321972968576460516487714e-02 7.48507115899952224502555964136263e-01
            7.48270055258283377230821287184881e-03 1.10922042803463405391539708944038e-01 2.43701869010938265702748140029144e-02
            1.73206380704241866275161498833768e-02 3.08441760892117777803633771327441e-01 6.23545995553675513889402282075025e-01
            4.79534050177163155559423302065625e-03 5.12638910238238931782461804687046e-03 2.72515817773429702697285392787308e-01
            ];
        
        S2=[
            1.19972009644473652512086658816770e-02 4.89076946452539351728461269885884e-01
            2.91392425595999905729716061841827e-02 2.21372286291832920390731942461571e-01
            2.78009837652266646179644027370159e-02 4.26941414259800422481561099630198e-01
            3.02616855176958583772961475233387e-03 2.15096811088431594249925637996057e-02
            ];
        
        S3=[
            3.39800182934158201408791910580476e-02
            ];
        
        
    case  14
        
        % ALG. DEG.:   14
        % PTS CARD.:   42
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.4e-16
        
        S1=[
            7.21815405676692022074458776614847e-03 2.98372882136257788765476561820833e-01 6.86980167808087793801519183034543e-01
            1.23328766062818367954534437558323e-02 5.71247574036479188741566304088337e-02 1.72266687821355568566161764465505e-01
            1.92857553935303419057056828478380e-02 3.36861459796344964168213209632086e-01 5.70222290846683188547672216373030e-01
            2.50511441925033596228589161114542e-03 1.26833093287204157206815580138937e-03 1.18974497696956837966553166552330e-01
            ];
        
        S2=[
            2.10812943684965080348714394631315e-02 1.77205532412543442788432912493590e-01
            1.63941767720626740967304613150191e-02 4.17644719340453940414903399869218e-01
            7.21684983488833382142546568616126e-03 6.17998830908725871324804757023230e-02
            1.09417906847144447146646939472703e-02 4.88963910362178622026618768359185e-01
            2.58870522536457925433239779522410e-02 2.73477528308838646609046918456443e-01
            2.46170180120004094062591271097062e-03 1.93909612487010440950996326137101e-02
            ];
        
        S3=[];
        
        
    case  15
        
        % ALG. DEG.:   15
        % PTS CARD.:   49
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.6e-16
        
        S1=[
            7.80128641528798211224327019408520e-03 1.83761123856810981713749697519233e-02 6.66975644801868106092967991571641e-01
            2.01492668600904969652964915383109e-03 9.13923703730840086834064095455687e-03 7.09486052364555197513595885538962e-02
            1.43602934626006709800671856669396e-02 1.90535589476393929508901692315703e-01 7.15222356931450642392178451700602e-01
            5.83631059078792285843562126501638e-03 1.68068645222414381201758715178585e-01 1.86387137281663894938787962018978e-02
            1.56577381424846430457709089978380e-02 3.38950611475277163719965756172314e-01 5.65252664877114230357335600274382e-01
            ];
        
        S2=[
            2.13568907857302828223744484148483e-02 4.05362214133975495844453007521224e-01
            8.22236878131258133728387349492550e-03 7.01735528999860025400892027391819e-02
            8.69807400038170690226291270619186e-03 4.74170681438019769871061726007611e-01
            2.33916808643548149171387251499254e-02 2.26378713420349597651437534295837e-01
            4.78692309123004283710756112668605e-03 4.94996956769126195130326095750206e-01
            1.48038731895268772104090615471250e-03 1.58117262509886447041651535982965e-02
            ];
        
        S3=[
            2.21676936910920364953714312150623e-02
            ];
        
        
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   55
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.1e-16
        
        S1=[
            9.46913623220784969602981107072992e-03 5.47551749147031086017989309766563e-02 7.54170061444767725333804264664650e-01
            8.27233357417524097637828717211050e-04 2.32034277688137335893259205477079e-02 8.55220420022761995682003544061445e-03
            7.50430089214290316212974119025603e-03 1.89317782804059309142985512153246e-02 6.49303698245446425652005473239115e-01
            3.97379696669624901672612793390726e-03 1.90301297436974437005119398236275e-02 8.06961669858729524484886042046128e-02
            1.59918050396850343342070033259006e-02 1.02606190239398098462686448328895e-01 5.89148840564247877615855486510554e-01
            2.69559355842440570918960851543034e-03 5.93635001682224494601314290775917e-03 1.87441782483782071189182261150563e-01
            ];
        
        S2=[
            2.05464615718494759966095131176189e-02 2.45990070467141719312564873689553e-01
            2.03559166562126796218290536444329e-02 4.15584896885420496115415289750672e-01
            7.39081734511220188321711788148605e-03 8.53555665867003487967679120629327e-02
            1.47092048494940497854743810535183e-02 1.61918644191271221544070613163058e-01
            2.20927315607528452004459929014502e-03 5.00000000000000000000000000000000e-01
            1.29871666491385793357205002962473e-02 4.75280727545942083267505040566903e-01
            ];
        
        S3=[
            2.26322830369093952462833385652630e-02
            ];
        
        
    case  17
        
        % ALG. DEG.:   17
        % PTS CARD.:   60
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.1e-16
        
        S1=[
            3.98915010296479674578584706523543e-03 1.60176423621192776103328014869476e-02 8.24790070165088096132421924266964e-01
            1.12438862733455335191079527135116e-02 3.06281591746186521163508587051183e-01 6.73493778673611709351121135114226e-02
            5.19921997791976831654325863496524e-03 1.32296727600869079566336949937977e-02 5.71294867944684092719853651942685e-01
            1.02789491602272593101519149172418e-02 7.80423405682824089524274313589558e-02 1.68722513495259462956710194703192e-01
            4.34610725050059605589769518019239e-03 1.31358708340026941741029986587819e-02 7.15072259110642427515358576783910e-01
            2.29217420086793351868825752148950e-03 1.15751759031806344957260535011301e-02 7.25054707990024360775294098857557e-02
            1.30858129676684944303621804806426e-02 1.57505477926869918992025532133994e-01 5.43275579596159796658128016133560e-01
            ];
        
        S2=[
            1.36554632640510532209932037517319e-02 4.17103444361599184908584447839530e-01
            1.38694378881882109978695982732688e-03 1.47554916607539610140520380809903e-02
            1.25097254752486782697351586080003e-02 4.65597871618890324363349009217927e-01
            1.31563152940089925224675937442953e-02 1.80358116266370605007551830567536e-01
            6.22950040115272107854593741649296e-03 6.66540634795969033632445643888786e-02
            1.88581185763976415248333040608486e-02 2.85706502436586629034565021356684e-01
            ];
        
        S3=[];
        
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   67
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 9.0e-16
        
        S1=[
            6.87980811747110256731962962817306e-03 4.58049158598607952797010511858389e-02 7.70372376214675247396712620684411e-01
            1.18909554500764153006642231957812e-02 2.06349257433837918185304260987323e-01 1.22696757371927533952771227632184e-01
            2.26526725112853252741551557392086e-03 3.89761103347335824409469751117285e-03 6.00418954634256873958975120331161e-01
            3.42005505980359086892761411036190e-03 1.34620167414449820597610596450977e-02 1.08195793791033278985480592382373e-01
            8.87374455101020212510753992773971e-03 4.02602834699080647240521102503408e-02 6.39988092004714625993244681012584e-01
            2.50533043728986106260525623667945e-03 5.29833518660977054182126266823616e-03 2.35772184958191743930910888593644e-01
            6.11474063480544911125535989526725e-04 5.48360042042339568268971561337821e-04 9.72360728962795684005016028095270e-01
            1.27410876559122202694718239968097e-02 1.20587695163924646379882688052021e-01 3.33493529449880754533808158157626e-01
            ];
        
        S2=[
            1.66522350166950668104437482952562e-02 3.99955628067576229867086112790275e-01
            6.02332381699985548728637496651572e-03 4.87580301574869534597667097841622e-01
            9.47458575338943308208339288967181e-03 4.61809506406449243876011223619571e-01
            1.82375447044718190514611677599532e-02 2.42264702514271956790281592475367e-01
            3.56466300985948522303536911692845e-03 3.88302560886856218402840568160173e-02
            8.27957997600162372286991541159296e-03 9.19477421216431944905878026474966e-02
            ];
        
        S3=[
            1.81778676507133342410416076972979e-02
            ];
        
        
    case  19
        
        % ALG. DEG.:   19
        % PTS CARD.:   73
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.4e-16
        
        S1=[
            4.84774224342752330096928403690981e-03 1.30697676268032414448327926947968e-01 8.30156464400275351245284127799096e-01
            1.31731609886953666271880436511310e-02 3.11317629809541251972859754459932e-01 1.29312564470157820295526107656769e-01
            1.64103827591790965914619881971248e-03 2.06892589660478964930234724306501e-03 6.33313293128784149388366131461225e-01
            9.05397246560622585842548204482227e-03 7.45602946016266643347591980273137e-02 2.21434885432331196586375199331087e-01
            1.46315755173510018451177305820465e-03 5.00728825735446969602548961120192e-03 8.52566954376889230005076569796074e-01
            8.05108138201205379702596331981113e-03 4.08880111960168712847973893076414e-02 3.54028009735275150937638954928843e-01
            4.22794374976824798711971808984345e-03 2.41894578960579587079138264016365e-01 7.43181368957436361277757441712311e-01
            1.66360068142969402642250553725489e-03 6.00862753223067036500992799119558e-02 9.77602580088815509284927429689560e-03
            ];
        
        S2=[
            3.55462829889906543542887895625881e-03 5.25238903512089683189856259559747e-02
            5.16087757147214078873309617279119e-03 4.92512675041336889236731622077059e-01
            7.61717554650914990127530401764488e-03 1.11448873323021391268383695205557e-01
            1.14917950133708035576063366534072e-02 4.59194201039543670184173151938012e-01
            1.57687674465774863019618123871624e-02 4.03969722551901222473702546267305e-01
            1.23259574240954274115811273304644e-02 1.78170104781764315760028694057837e-01
            8.82661388221423837477375151649994e-04 1.16394611837894457195830000273418e-02
            1.58765096830015377260547637661148e-02 2.55161632913607716588444418448489e-01
            ];
        
        S3=[
            1.72346988520061666916305398444820e-02
            ];
        
        
    case  20
        
        % ALG. DEG.:   20
        % PTS CARD.:   79
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.5e-16
        
        S1=[
            2.20289741855849742491191278759288e-03 7.57078050469650598586213163798675e-03 8.33295511838236246937583473481936e-01
            5.98639857895469015836020787446614e-03 4.65603649076642978066331579611870e-02 1.98518132228788168891497889489983e-01
            1.12986960212586558596759012118582e-03 6.40905856084340586065195566334296e-02 9.31054476783942153161888199974783e-01
            8.66722556721933289070047834457000e-03 5.49874791429867948444609737634892e-02 3.33134817309587494271738705720054e-01
            4.14571152761385782609115935315458e-03 9.99522962881386756173185403895332e-02 8.61684018936486717521461287105922e-01
            7.72260782209923009322682929678194e-03 1.06227204720270029802975386701291e-01 2.15607057390094392079760154956602e-01
            3.69568150025529782928823685494990e-03 4.20023758816224113132875572773628e-01 5.70144692890973359133965914224973e-01
            1.16917457318277372146919645956586e-02 5.42331804172428100230263225967064e-01 1.39808071991799898192709861177718e-01
            3.57820023845768515197152126461333e-03 1.07372128560110913220171369175659e-02 2.80581411423665216808842615137110e-01
            ];
        
        S2=[
            1.40832013075202471669156167877190e-02 2.54579267673339104671725863227039e-01
            7.98840791066619858654118679908152e-04 1.09761410283977789426046456355834e-02
            7.83023077607453328596864849941994e-03 1.09383596711714603522125344170490e-01
            9.17346297425291473670583286548208e-03 1.86294997744540946627012090175413e-01
            9.45239993323244813427930210991690e-03 4.45551056955924784652722792088753e-01
            2.16127541066557732687969384244298e-03 3.73108805988847103130012783367420e-02
            1.37880506290704585303785734140547e-02 3.93425347817099868574786114550079e-01
            7.10182530340844071076178423140846e-03 4.76245611540498992031444913664018e-01
            ];
        
        S3=[
            1.39101107014531159139503202482047e-02
            ];
        
        
        
    otherwise
        S1=[]; S2=[]; S3=[];
end




pointset_stats=[
    1    1 1.92e-16    0    0
    4    6 1.39e-16    0    0
    5    7 1.98e-16    0    0
    6   12 2.36e-16    0    0
    7   15 3.75e-16    0    0
    8   16 8.05e-16    0    0
    9   19 3.26e-16    0    0
    10   25 4.86e-16    0    0
    11   28 1.49e-15    0    0
    12   33 6.52e-16    0    0
    13   37 5.83e-16    0    0
    14   42 4.37e-16    0    0
    15   49 5.62e-16    0    0
    16   55 6.11e-16    0    0
    17   60 4.09e-16    0    0
    18   67 9.00e-16    0    0
    19   73 6.38e-16    0    0
    20   79 7.46e-16    0    0
    ];



