
function [S1,S2,S3]=set_witherden_vincent_pre(deg)


% --------------------------------------------------------------------
% CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
% --------------------------------------------------------------------
% INPUT:
% deg: algebraic degree of precision (ADE) of the rule.
% --------------------------------------------------------------------
% OUTPUT:
% xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
%      REMARK: The sum of the weights makes 1/2.
% --------------------------------------------------------------------
% REMARK:
% The original set was in the interval [-1 -1; 1 -1; -1 1].
% Modified the weights so that their sum makes 1/2.
% --------------------------------------------------------------------
% SOURCE:
% F.D: Witherden, P.E. Vincent.
% "On the identification of symmetric quadrature rules for finite
% element methods".
% Computers and Mathematics with Applications 69 (2015) 1232-1241.
% --------------------------------------------------------------------


%----------------------------------------
% | DEG | CARD | W- | PT.O|   M.E.   |Q.|
%----------------------------------------
% |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
% |   2 |   3 |   0 |   0 | 1.18e-16 |PI|
% |   4 |   6 |   0 |   0 | 1.39e-16 |PI|
% |   5 |   7 |   0 |   0 | 1.72e-16 |PI|
% |   6 |  12 |   0 |   0 | 2.36e-16 |PI|
% |   7 |  15 |   0 |   0 | 3.61e-16 |PI|
% |   8 |  16 |   0 |   0 | 2.84e-16 |PI|
% |   9 |  19 |   0 |   0 | 3.89e-16 |PI|
% |  10 |  25 |   0 |   0 | 3.33e-16 |PI|
% |  11 |  28 |   0 |   0 | 4.58e-16 |PI|
% |  12 |  33 |   0 |   0 | 3.75e-16 |PI|
% |  13 |  37 |   0 |   0 | 8.53e-16 |PI|
% |  14 |  42 |   0 |   0 | 4.72e-16 |PI|
% |  15 |  49 |   0 |   0 | 4.58e-16 |PI|
% |  16 |  55 |   0 |   0 | 7.63e-16 |PI|
% |  17 |  60 |   0 |   0 | 4.02e-16 |PI|
% |  18 |  67 |   0 |   0 | 5.99e-16 |PI|
% |  19 |  73 |   0 |   0 | 5.33e-16 |PI|
% |  20 |  79 |   0 |   0 | 5.93e-16 |PI|
%---------------------------------------


%--------------------------------------------------------------------
% LEGEND:
%--------------------------------------------------------------------
% DEG  : algebraic degree of precision
% CARD : cardinality of the pointset
% W-   : negative weights
% PT.O : points outside the simplex [0 0; 1 0; 0 1].
% M.E. : maximum moment error in inf norm.
% Q.: quality of the rule.
%        PI: pos. weights, points in simplex
%        NI: some neg. weights, points in simplex
%        P0: pos. weights, some points out of the simplex
%        N0: some neg. weights, some points out of the simplex
%--------------------------------------------------------------------

S1=[];
S2=[];
S3=[];

switch deg
    
    case   1
        
        % ALG. DEG.:    1
        % PTS CARD.:    1
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.9e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 5.00000000000000000000e-01
            ];
        
    case   2
        
        % ALG. DEG.:    2
        % PTS CARD.:    3
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.2e-16
        
        S2=[
            1.66666666666666685170e-01 6.66666666666666629659e-01 1.66666666666666657415e-01
            ];
        
    case   4
        
        % ALG. DEG.:    4
        % PTS CARD.:    6
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.4e-16
        
        S2=[
            4.45948490915964890213e-01 1.08103018168070219573e-01 1.11690794839005735906e-01
            9.15762135097707430376e-02 9.15762135097707430376e-02 5.49758718276609353870e-02
            ];
        
    case   5
        
        % ALG. DEG.:    5
        % PTS CARD.:    7
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 1.7e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 1.12500000000000002776e-01];
        S2=[
            1.01286507323456342888e-01 7.97426985353087314223e-01 6.29695902724135697648e-02
            4.70142064105115109474e-01 4.70142064105115109474e-01 6.61970763942530959767e-02
            ];
        
    case   6
        
        % ALG. DEG.:    6
        % PTS CARD.:   12
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.4e-16
        
        S2=[
            6.30890144915022266225e-02 8.73821971016995546755e-01 2.54224531851034094010e-02
            2.49286745170910428726e-01 2.49286745170910428726e-01 5.83931378631896841336e-02];
        
        S1=[
            5.31450498448169383892e-02 3.10352451033784393353e-01 4.14255378091867854096e-02
            ];
        
    case   7
        
        % ALG. DEG.:    7
        % PTS CARD.:   15
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.6e-16
        
        S2=[
            3.37306485545878498300e-02 9.32538702890824300340e-01 8.27252505539606552976e-03
            2.41577382595403566956e-01 5.16845234809192866088e-01 6.39720856150777922311e-02
            4.74309692504718216632e-01 4.74309692504718216632e-01 3.85433230929930342734e-02];
        S1=[
            4.70366446525952164315e-02 1.98683314797351573411e-01 2.79393664515998896292e-02
            ];
        
    case   8
        
        % ALG. DEG.:    8
        % PTS CARD.:   16
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 2.8e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 7.21578038388935860681e-02];
        S2=[
            4.59292588292723125143e-01 8.14148234145536942030e-02 4.75458171336423096598e-02
            1.70569307751760212977e-01 6.58861384496479574047e-01 5.16086852673591223173e-02
            5.05472283170309566458e-02 5.05472283170309566458e-02 1.62292488115990396480e-02];
        S1=[
            8.39477740995758781040e-03 2.63112829634638112353e-01 1.36151570872174963733e-02
            ];
        
    case   9
        
        % ALG. DEG.:    9
        % PTS CARD.:   19
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.9e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 4.85678981413994181882e-02];
        S2=[
            4.37089591492936635486e-01 1.25820817014126729028e-01 3.89137705023871391385e-02
            1.88203535619032746862e-01 1.88203535619032746862e-01 3.98238694636051243636e-02
            4.89682519198737620236e-01 2.06349616025247595275e-02 1.56673501135695357467e-02
            4.47295133944526912551e-02 4.47295133944526912551e-02 1.27888378293490156262e-02];
        S1=[
            3.68384120547362581277e-02 2.21962989160765677976e-01 2.16417696886446880855e-02
            ];
        
    case  10
        
        % ALG. DEG.:   10
        % PTS CARD.:   25
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.3e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 4.08716645731429864541e-02];
        S2=[
            3.20553732169435168231e-02 9.35889253566112966354e-01 6.67648440657478327992e-03
            1.42161101056564376233e-01 1.42161101056564376233e-01 2.29789818023723654838e-02];
        S1=[
            3.21812995288835446139e-01 5.30054118927343997925e-01 3.19524531982120219009e-02
            2.96198894887297892176e-02 6.01233328683459244957e-01 1.70923240814797143539e-02
            2.83676653399384526288e-02 1.63701733737182497652e-01 1.26488788536441923438e-02];
        
    case  11
        
        % ALG. DEG.:   11
        % PTS CARD.:   28
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.6e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 4.28805898661121093207e-02];
        S2=[
            2.84854176143718995640e-02 9.43029164771256200872e-01 5.21593525644734826857e-03
            2.10219956703178278978e-01 5.79560086593643442043e-01 3.52578420558582877886e-02
            1.02635482712246428605e-01 1.02635482712246428605e-01 1.93153796185096607307e-02
            4.95891900965890919384e-01 8.21619806821816123232e-03 8.30313652729268436570e-03
            4.38465926764352198486e-01 4.38465926764352198486e-01 3.36580770397341480504e-02];
        S1=[
            1.49324788652082374174e-01 8.43349783661853091843e-01 5.14514478647663895533e-03
            4.60105001654299572422e-02 2.89581125637705882880e-01 2.01662383202502772106e-02
            ];
        
    case  12
        
        % ALG. DEG.:   12
        % PTS CARD.:   33
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 3.7e-16
        
        S2=[
            4.88203750945541525841e-01 2.35924981089168928072e-02 1.21334190407260157640e-02
            1.09257827659354267436e-01 1.09257827659354267436e-01 1.42430260344387719235e-02
            2.71462507014926079929e-01 4.57074985970147840142e-01 3.12706065979513822550e-02
            2.46463634363355832413e-02 9.50707273127328833517e-01 3.96582125498681943576e-03
            4.40111648658593090921e-01 1.19776702682813762646e-01 2.49591674640304711508e-02];
        S1=[
            2.91655679738340944951e-01 6.85310163906391878186e-01 1.08917925193037796322e-02
            1.16296019677926576463e-01 2.55454228638517355510e-01 2.16136818297071042760e-02
            8.51337792510240110033e-01 1.27279717233589384495e-01 7.54183878825571887144e-03
            ];
        
    case  13
        
        % ALG. DEG.:   13
        % PTS CARD.:   37
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 8.5e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 3.39800182934158201409e-02];
        S2=[
            4.89076946452539351728e-01 2.18461070949212965431e-02 1.19972009644473652512e-02
            2.21372286291832920391e-01 2.21372286291832920391e-01 2.91392425595999905730e-02
            4.26941414259800422482e-01 1.46117171480399210548e-01 2.78009837652266646180e-02
            2.15096811088431594250e-02 2.15096811088431594250e-02 3.02616855176958583773e-03];
        S1=[
            8.78954830321972968576e-02 7.48507115899952224503e-01 1.20895199057969096601e-02
            1.10922042803463405392e-01 2.43701869010938265703e-02 7.48270055258283377231e-03
            3.08441760892117777804e-01 6.23545995553675513889e-01 1.73206380704241866275e-02
            5.12638910238238931782e-03 2.72515817773429702697e-01 4.79534050177163155559e-03
            ];
        
    case  14
        
        % ALG. DEG.:   14
        % PTS CARD.:   42
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.7e-16
        
        S2=[
            1.77205532412543442788e-01 6.45588935174913114423e-01 2.10812943684965080349e-02
            4.17644719340453940415e-01 4.17644719340453940415e-01 1.63941767720626740967e-02
            6.17998830908725871325e-02 8.76400233818254825735e-01 7.21684983488833382143e-03
            4.88963910362178622027e-01 4.88963910362178622027e-01 1.09417906847144447147e-02
            2.73477528308838646609e-01 4.53044943382322706782e-01 2.58870522536457925433e-02
            1.93909612487010440951e-02 1.93909612487010440951e-02 2.46170180120004094063e-03];
        S1=[
            2.98372882136257788765e-01 6.86980167808087793802e-01 7.21815405676692022074e-03
            5.71247574036479188742e-02 1.72266687821355568566e-01 1.23328766062818367955e-02
            3.36861459796344964168e-01 5.70222290846683188548e-01 1.92857553935303419057e-02
            1.26833093287204157207e-03 1.18974497696956837967e-01 2.50511441925033596229e-03
            ];
        
    case  15
        
        % ALG. DEG.:   15
        % PTS CARD.:   49
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.6e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 2.21676936910920364954e-02];
        S2=[
            4.05362214133975495844e-01 1.89275571732049063822e-01 2.13568907857302828224e-02
            7.01735528999860025401e-02 7.01735528999860025401e-02 8.22236878131258133728e-03
            4.74170681438019769871e-01 5.16586371239604047467e-02 8.69807400038170690226e-03
            2.26378713420349597651e-01 2.26378713420349597651e-01 2.33916808643548149171e-02
            4.94996956769126195130e-01 1.00060864617476097393e-02 4.78692309123004283711e-03
            1.58117262509886447042e-02 1.58117262509886447042e-02 1.48038731895268772104e-03];
        S1=[
            1.83761123856810981714e-02 6.66975644801868106093e-01 7.80128641528798211224e-03
            9.13923703730840086834e-03 7.09486052364555197514e-02 2.01492668600904969653e-03
            1.90535589476393929509e-01 7.15222356931450642392e-01 1.43602934626006709801e-02
            1.68068645222414381202e-01 1.86387137281663894939e-02 5.83631059078792285844e-03
            3.38950611475277163720e-01 5.65252664877114230357e-01 1.56577381424846430458e-02
            ];
        
    case  16
        
        % ALG. DEG.:   16
        % PTS CARD.:   55
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 7.6e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 2.26322830369093952463e-02];
        S2=[
            2.45990070467141719313e-01 5.08019859065716561375e-01 2.05464615718494759966e-02
            4.15584896885420496115e-01 4.15584896885420496115e-01 2.03559166562126796218e-02
            8.53555665867003487968e-02 8.29288866826599413429e-01 7.39081734511220188322e-03
            1.61918644191271221544e-01 1.61918644191271221544e-01 1.47092048494940497855e-02
            5.00000000000000000000e-01 0.00000000000000000000e+00 2.20927315607528452004e-03
            4.75280727545942083268e-01 4.75280727545942083268e-01 1.29871666491385793357e-02];
        S1=[
            5.47551749147031086018e-02 7.54170061444767725334e-01 9.46913623220784969603e-03
            2.32034277688137335893e-02 8.55220420022761995682e-03 8.27233357417524097638e-04
            1.89317782804059309143e-02 6.49303698245446425652e-01 7.50430089214290316213e-03
            1.90301297436974437005e-02 8.06961669858729524485e-02 3.97379696669624901673e-03
            1.02606190239398098463e-01 5.89148840564247877616e-01 1.59918050396850343342e-02
            5.93635001682224494601e-03 1.87441782483782071189e-01 2.69559355842440570919e-03
            ];
        
    case  17
        
        % ALG. DEG.:   17
        % PTS CARD.:   60
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 4.0e-16
        
        S2=[
            4.17103444361599184909e-01 1.65793111276801574672e-01 1.36554632640510532210e-02
            1.47554916607539610141e-02 1.47554916607539610141e-02 1.38694378881882109979e-03
            4.65597871618890324363e-01 6.88042567622194067845e-02 1.25097254752486782697e-02
            1.80358116266370605008e-01 1.80358116266370605008e-01 1.31563152940089925225e-02
            6.66540634795969033632e-02 8.66691873040806193274e-01 6.22950040115272107855e-03
            2.85706502436586629035e-01 2.85706502436586629035e-01 1.88581185763976415248e-02];
        S1=[
            1.60176423621192776103e-02 8.24790070165088096132e-01 3.98915010296479674579e-03
            3.06281591746186521164e-01 6.73493778673611709351e-02 1.12438862733455335191e-02
            1.32296727600869079566e-02 5.71294867944684092720e-01 5.19921997791976831654e-03
            7.80423405682824089524e-02 1.68722513495259462957e-01 1.02789491602272593102e-02
            1.31358708340026941741e-02 7.15072259110642427515e-01 4.34610725050059605590e-03
            1.15751759031806344957e-02 7.25054707990024360775e-02 2.29217420086793351869e-03
            1.57505477926869918992e-01 5.43275579596159796658e-01 1.30858129676684944304e-02
            ];
        
    case  18
        
        % ALG. DEG.:   18
        % PTS CARD.:   67
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 6.0e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 1.81778676507133342410e-02];
        S2=[
            3.99955628067576229867e-01 3.99955628067576229867e-01 1.66522350166950668104e-02
            4.87580301574869534598e-01 2.48393968502608752935e-02 6.02332381699985548729e-03
            4.61809506406449243876e-01 4.61809506406449243876e-01 9.47458575338943308208e-03
            2.42264702514271956790e-01 5.15470594971456086419e-01 1.82375447044718190515e-02
            3.88302560886856218403e-02 3.88302560886856218403e-02 3.56466300985948522304e-03
            9.19477421216431944906e-02 8.16104515756713611019e-01 8.27957997600162372287e-03];
        S1=[
            4.58049158598607952797e-02 7.70372376214675247397e-01 6.87980811747110256732e-03
            2.06349257433837918185e-01 1.22696757371927533953e-01 1.18909554500764153007e-02
            3.89761103347335824409e-03 6.00418954634256873959e-01 2.26526725112853252742e-03
            1.34620167414449820598e-02 1.08195793791033278985e-01 3.42005505980359086893e-03
            4.02602834699080647241e-02 6.39988092004714625993e-01 8.87374455101020212511e-03
            5.29833518660977054182e-03 2.35772184958191743931e-01 2.50533043728986106261e-03
            5.48360042042339568269e-04 9.72360728962795684005e-01 6.11474063480544911126e-04
            1.20587695163924646380e-01 3.33493529449880754534e-01 1.27410876559122202695e-02
            ];
        
    case  19
        
        % ALG. DEG.:   19
        % PTS CARD.:   73
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.3e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 1.72346988520061666916e-02];
        S2=[
            5.25238903512089683190e-02 8.94952219297582063362e-01 3.55462829889906543543e-03
            4.92512675041336889237e-01 4.92512675041336889237e-01 5.16087757147214078873e-03
            1.11448873323021391268e-01 7.77102253353957328486e-01 7.61717554650914990128e-03
            4.59194201039543670184e-01 4.59194201039543670184e-01 1.14917950133708035576e-02
            4.03969722551901222474e-01 1.92060554896197610564e-01 1.57687674465774863020e-02
            1.78170104781764315760e-01 1.78170104781764315760e-01 1.23259574240954274116e-02
            1.16394611837894457196e-02 9.76721077632421108561e-01 8.82661388221423837477e-04
            2.55161632913607716588e-01 2.55161632913607716588e-01 1.58765096830015377261e-02];
        S1=[
            1.30697676268032414448e-01 8.30156464400275351245e-01 4.84774224342752330097e-03
            3.11317629809541251973e-01 1.29312564470157820296e-01 1.31731609886953666272e-02
            2.06892589660478964930e-03 6.33313293128784149388e-01 1.64103827591790965915e-03
            7.45602946016266643348e-02 2.21434885432331196586e-01 9.05397246560622585843e-03
            5.00728825735446969603e-03 8.52566954376889230005e-01 1.46315755173510018451e-03
            4.08880111960168712848e-02 3.54028009735275150938e-01 8.05108138201205379703e-03
            2.41894578960579587079e-01 7.43181368957436361278e-01 4.22794374976824798712e-03
            6.00862753223067036501e-02 9.77602580088815509285e-03 1.66360068142969402642e-03
            ];
        
    case  20
        
        % ALG. DEG.:   20
        % PTS CARD.:   79
        % NEG. W.  :    0
        % OUT PTS. :    0
        % M.E.INF. : 5.9e-16
        
        S3=[
            3.33333333333333370341e-01 3.33333333333333370341e-01 1.39101107014531159140e-02];
        S2=[
            2.54579267673339104672e-01 4.90841464653321790657e-01 1.40832013075202471669e-02
            1.09761410283977789426e-02 1.09761410283977789426e-02 7.98840791066619858654e-04
            1.09383596711714603522e-01 7.81232806576570792956e-01 7.83023077607453328597e-03
            1.86294997744540946627e-01 1.86294997744540946627e-01 9.17346297425291473671e-03
            4.45551056955924784653e-01 1.08897886088150375183e-01 9.45239993323244813428e-03
            3.73108805988847103130e-02 3.73108805988847103130e-02 2.16127541066557732688e-03
            3.93425347817099868575e-01 2.13149304365800262850e-01 1.37880506290704585304e-02
            4.76245611540498992031e-01 4.76245611540498992031e-01 7.10182530340844071076e-03];
        S1=[
            7.57078050469650598586e-03 8.33295511838236246938e-01 2.20289741855849742491e-03
            4.65603649076642978066e-02 1.98518132228788168891e-01 5.98639857895469015836e-03
            6.40905856084340586065e-02 9.31054476783942153162e-01 1.12986960212586558597e-03
            5.49874791429867948445e-02 3.33134817309587494272e-01 8.66722556721933289070e-03
            9.99522962881386756173e-02 8.61684018936486717521e-01 4.14571152761385782609e-03
            1.06227204720270029803e-01 2.15607057390094392080e-01 7.72260782209923009323e-03
            4.20023758816224113133e-01 5.70144692890973359134e-01 3.69568150025529782929e-03
            5.42331804172428100230e-01 1.39808071991799898193e-01 1.16917457318277372147e-02
            1.07372128560110913220e-02 2.80581411423665216809e-01 3.57820023845768515197e-03
            ];
        
        
    otherwise
        xyw=[];
end

if isempty(S1) == 0
    S1=S1(:,[3 1 2]);
end

if isempty(S2) == 0
    S2=S2(:,[3 1]);
end

if isempty(S3) == 0
    S3=S3(:,[3]);
end




