
 	function [xyw_bar,pointset_stats]=set_xiao_gimbutas_barycentric(deg)
 	
 	 %--------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % THE CUBATURE RULE IS DESCRIBED IN BARYCENTRICAL FORM.
 	 %--------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 %--------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw_bar: MATRIX OF NODES xyw(:,1:3) IN BARYCENTRICAL COOR. AND WEIGHTS xyw(:,4).
 	 %      REMARK: The sum of the weights makes 1.
 	 % 
 	 % pointset_stats:
 	 %    statistics of the pointset stored in a matrix. Each rows contains
 	 %    degree, cardinality of the full pointset, moment error w.r.t. 
 	 %    orthn. Dubiner basis, number of points with negative weights,
 	 %    number of points outside the domain.
 	 %--------------------------------------------------------------------
  	 % SOURCE:
  	 %  H. Xiao, Z. Gimbutas.
  	 %  "A numerical algorithm for the construction of efficient quadrature
  	 %  rules in two and higher dimensions".
  	 %  Computers and Mathematics with Applications 59 (2010) 663-676.
 	 %--------------------------------------------------------------------
  	 %  REMARK.
  	 %  In the original paper, Xiao and Gimbutas proposed three sets with
  	 %  different symmetries, but they do not suggest where to find them in
  	 %  terms of files.
  	 %  We downloaded this file from the url
  	 %          https://cims.nyu.edu/cmcl/quadratures/quadratures.html
  	 %  modifying it to be used directly as cubature rule.
  	 %  It is just one of the three, i.e. the pointset with fully symmetric
  	 %  rules.
 	 %--------------------------------------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %--------------------------------------------------------------------
 	 % |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
 	 % |   2 |   3 |   0 |   0 | 4.20e-16 |PI|
 	 % |   3 |   6 |   0 |   0 | 1.25e-15 |PI|
 	 % |   4 |   6 |   0 |   0 | 1.25e-15 |PI|
 	 % |   5 |   7 |   0 |   0 | 7.08e-16 |PI|
 	 % |   6 |  12 |   0 |   0 | 4.30e-16 |PI|
 	 % |   7 |  15 |   0 |   0 | 7.15e-16 |PI|
 	 % |   8 |  16 |   0 |   0 | 9.99e-16 |PI|
 	 % |   9 |  19 |   0 |   0 | 1.12e-15 |PI|
 	 % |  10 |  25 |   0 |   0 | 6.66e-16 |PI|
 	 % |  11 |  28 |   0 |   0 | 5.83e-16 |PI|
 	 % |  12 |  33 |   0 |   0 | 8.47e-16 |PI|
 	 % |  13 |  37 |   0 |   0 | 1.06e-15 |PI|
 	 % |  14 |  42 |   0 |   0 | 1.14e-15 |PI|
 	 % |  15 |  49 |   0 |   0 | 8.50e-16 |PI|
 	 % |  16 |  55 |   0 |   0 | 2.03e-15 |PI|
 	 % |  17 |  60 |   0 |   0 | 9.49e-16 |PI|
 	 % |  18 |  67 |   0 |   0 | 1.50e-15 |PI|
 	 % |  19 |  73 |   0 |   0 | 1.07e-15 |PI|
 	 % |  20 |  79 |   0 |   0 | 1.25e-15 |PI|
 	 % |  21 |  87 |   0 |   0 | 1.42e-15 |PI|
 	 % |  22 |  96 |   0 |   0 | 9.99e-16 |PI|
 	 % |  23 | 103 |   0 |   0 | 2.05e-15 |PI|
 	 % |  24 | 112 |   0 |   0 | 9.85e-16 |PI|
 	 % |  25 | 120 |   0 |   0 | 1.80e-15 |PI|
 	 % |  26 | 130 |   0 |   0 | 1.96e-15 |PI|
 	 % |  27 | 141 |   0 |   0 | 1.11e-15 |PI|
 	 % |  28 | 150 |   0 |   0 | 1.39e-15 |PI|
 	 % |  29 | 159 |   0 |   0 | 1.34e-15 |PI|
 	 % |  30 | 171 |   0 |   0 | 1.64e-15 |PI|
 	 % |  31 | 181 |   0 |   0 | 1.70e-15 |PI|
 	 % |  32 | 193 |   0 |   0 | 1.71e-15 |PI|
 	 % |  33 | 204 |   0 |   0 | 1.45e-15 |PI|
 	 % |  34 | 214 |   0 |   0 | 1.87e-15 |PI|
 	 % |  35 | 228 |   0 |   0 | 1.68e-15 |PI|
 	 % |  36 | 243 |   0 |   0 | 1.18e-15 |PI|
 	 % |  37 | 252 |   0 |   0 | 1.03e-15 |PI|
 	 % |  38 | 267 |   0 |   0 | 1.85e-15 |PI|
 	 % |  39 | 282 |   0 |   0 | 1.58e-15 |PI|
 	 % |  40 | 295 |   0 |   0 | 1.42e-15 |PI|
 	 % |  41 | 309 |   0 |   0 | 1.45e-15 |PI|
 	 % |  42 | 324 |   0 |   0 | 1.44e-15 |PI|
 	 % |  43 | 339 |   0 |   0 | 1.45e-15 |PI|
 	 % |  44 | 354 |   0 |   0 | 1.38e-15 |PI|
 	 % |  45 | 370 |   0 |   0 | 1.52e-15 |PI|
 	 % |  46 | 385 |   0 |   0 | 2.44e-15 |PI|
 	 % |  47 | 399 |   0 |   0 | 1.56e-15 |PI|
 	 % |  48 | 423 |   0 |   0 | 1.49e-15 |PI|
 	 % |  49 | 435 |   0 |   0 | 1.23e-15 |PI|
 	 % |  50 | 453 |   0 |   0 | 1.39e-15 |PI|
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
 
 
 
 	 switch deg
 
 	 case   1 

 	 % ALG. DEG.:    1
 	 % PTS CARD.:    1
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.9e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.00000000000000000000000000000000e+00
 	 ];
 
 	 case   2 

 	 % ALG. DEG.:    2
 	 % PTS CARD.:    3
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.2e-16  

 	 xyw_bar=[
 	 1.66666666666666601903656896865868e-01 1.66666666666666601903656896865868e-01 6.66666666666666740681534975010436e-01 3.33333333333333314829616256247391e-01
 	 1.66666666666666601903656896865868e-01 6.66666666666666740681534975010436e-01 1.66666666666666601903656896865868e-01 3.33333333333333314829616256247391e-01
 	 6.66666666666666740681534975010436e-01 1.66666666666666601903656896865868e-01 1.66666666666666601903656896865868e-01 3.33333333333333314829616256247391e-01
 	 ];
 
 	 case   3 

 	 % ALG. DEG.:    3
 	 % PTS CARD.:    6
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-15  

 	 xyw_bar=[
 	 4.45948490915964834702123198439949e-01 4.45948490915964834702123198439949e-01 1.08103018168070330595753603120102e-01 2.23381589678011444055627521265706e-01
 	 4.45948490915964834702123198439949e-01 1.08103018168070330595753603120102e-01 4.45948490915964834702123198439949e-01 2.23381589678011444055627521265706e-01
 	 1.08103018168070330595753603120102e-01 4.45948490915964834702123198439949e-01 4.45948490915964834702123198439949e-01 2.23381589678011444055627521265706e-01
 	 9.15762135097706597708366871302132e-02 9.15762135097706597708366871302132e-02 8.16847572980458735969477856997401e-01 1.09951743655321856896200927167229e-01
 	 9.15762135097706597708366871302132e-02 8.16847572980458735969477856997401e-01 9.15762135097706597708366871302132e-02 1.09951743655321856896200927167229e-01
 	 8.16847572980458735969477856997401e-01 9.15762135097706597708366871302132e-02 9.15762135097706597708366871302132e-02 1.09951743655321856896200927167229e-01
 	 ];
 
 	 case   4 

 	 % ALG. DEG.:    4
 	 % PTS CARD.:    6
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-15  

 	 xyw_bar=[
 	 4.45948490915964834702123198439949e-01 4.45948490915964834702123198439949e-01 1.08103018168070330595753603120102e-01 2.23381589678011444055627521265706e-01
 	 4.45948490915964834702123198439949e-01 1.08103018168070330595753603120102e-01 4.45948490915964834702123198439949e-01 2.23381589678011444055627521265706e-01
 	 1.08103018168070330595753603120102e-01 4.45948490915964834702123198439949e-01 4.45948490915964834702123198439949e-01 2.23381589678011444055627521265706e-01
 	 9.15762135097706597708366871302132e-02 9.15762135097706597708366871302132e-02 8.16847572980458735969477856997401e-01 1.09951743655321856896200927167229e-01
 	 9.15762135097706597708366871302132e-02 8.16847572980458735969477856997401e-01 9.15762135097706597708366871302132e-02 1.09951743655321856896200927167229e-01
 	 8.16847572980458735969477856997401e-01 9.15762135097706597708366871302132e-02 9.15762135097706597708366871302132e-02 1.09951743655321856896200927167229e-01
 	 ];
 
 	 case   5 

 	 % ALG. DEG.:    5
 	 % PTS CARD.:    7
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.1e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.25000000000000033306690738754696e-01
 	 1.01286507323456259621607955523359e-01 1.01286507323456259621607955523359e-01 7.97426985353087536267935320211109e-01 1.25939180544827167285149016606738e-01
 	 1.01286507323456259621607955523359e-01 7.97426985353087536267935320211109e-01 1.01286507323456259621607955523359e-01 1.25939180544827167285149016606738e-01
 	 7.97426985353087536267935320211109e-01 1.01286507323456259621607955523359e-01 1.01286507323456259621607955523359e-01 1.25939180544827167285149016606738e-01
 	 4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 1.32394152788506191953388224646915e-01
 	 4.70142064105115053962435922585428e-01 5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 1.32394152788506191953388224646915e-01
 	 5.97158717897698920751281548291445e-02 4.70142064105115053962435922585428e-01 4.70142064105115053962435922585428e-01 1.32394152788506191953388224646915e-01
 	 ];
 
 	 case   6 

 	 % ALG. DEG.:    6
 	 % PTS CARD.:   12
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.3e-16  

 	 xyw_bar=[
 	 2.19429982549782909284630250112968e-01 2.19429982549782909284630250112968e-01 5.61140034900434181430739499774063e-01 1.71333124152981075560830959148007e-01
 	 2.19429982549782909284630250112968e-01 5.61140034900434181430739499774063e-01 2.19429982549782909284630250112968e-01 1.71333124152981075560830959148007e-01
 	 5.61140034900434181430739499774063e-01 2.19429982549782909284630250112968e-01 2.19429982549782909284630250112968e-01 1.71333124152981075560830959148007e-01
 	 4.80137964112215043233078404227854e-01 4.80137964112215043233078404227854e-01 3.97240717755699135338431915442925e-02 8.07310895930310051804568161060160e-02
 	 4.80137964112215043233078404227854e-01 3.97240717755699135338431915442925e-02 4.80137964112215043233078404227854e-01 8.07310895930310051804568161060160e-02
 	 3.97240717755699135338431915442925e-02 4.80137964112215043233078404227854e-01 4.80137964112215043233078404227854e-01 8.07310895930310051804568161060160e-02
 	 1.41619015923968138981337006043759e-01 1.93717243612408114572520645424447e-02 8.39009259714791122419796920439694e-01 4.06345597936606725553154717545112e-02
 	 1.41619015923968138981337006043759e-01 8.39009259714791122419796920439694e-01 1.93717243612408114572520645424447e-02 4.06345597936606725553154717545112e-02
 	 1.93717243612408114572520645424447e-02 1.41619015923968138981337006043759e-01 8.39009259714791122419796920439694e-01 4.06345597936606725553154717545112e-02
 	 1.93717243612408114572520645424447e-02 8.39009259714791122419796920439694e-01 1.41619015923968138981337006043759e-01 4.06345597936606725553154717545112e-02
 	 8.39009259714791122419796920439694e-01 1.41619015923968138981337006043759e-01 1.93717243612408114572520645424447e-02 4.06345597936606725553154717545112e-02
 	 8.39009259714791122419796920439694e-01 1.93717243612408114572520645424447e-02 1.41619015923968138981337006043759e-01 4.06345597936606725553154717545112e-02
 	 ];
 
 	 case   7 

 	 % ALG. DEG.:    7
 	 % PTS CARD.:   15
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.1e-16  

 	 xyw_bar=[
 	 4.73195653689251038986895991911297e-01 4.73195653689251038986895991911297e-01 5.36086926214979220262080161774065e-02 5.31808332967604532881544798783580e-02
 	 4.73195653689251038986895991911297e-01 5.36086926214979220262080161774065e-02 4.73195653689251038986895991911297e-01 5.31808332967604532881544798783580e-02
 	 5.36086926214979220262080161774065e-02 4.73195653689251038986895991911297e-01 4.73195653689251038986895991911297e-01 5.31808332967604532881544798783580e-02
 	 5.77976400545063204172713255957206e-02 5.77976400545063204172713255957206e-02 8.84404719890987345287669540994102e-01 4.09181703940568672339672673388122e-02
 	 5.77976400545063204172713255957206e-02 8.84404719890987345287669540994102e-01 5.77976400545063204172713255957206e-02 4.09181703940568672339672673388122e-02
 	 8.84404719890987345287669540994102e-01 5.77976400545063204172713255957206e-02 5.77976400545063204172713255957206e-02 4.09181703940568672339672673388122e-02
 	 2.41663606397247349155676943155413e-01 2.41663606397247349155676943155413e-01 5.16672787205505246177494882431347e-01 1.27725248561133847280402164869884e-01
 	 2.41663606397247349155676943155413e-01 5.16672787205505246177494882431347e-01 2.41663606397247349155676943155413e-01 1.27725248561133847280402164869884e-01
 	 5.16672787205505246177494882431347e-01 2.41663606397247349155676943155413e-01 2.41663606397247349155676943155413e-01 1.27725248561133847280402164869884e-01
 	 2.59339011865785673549567036388908e-01 4.69712061300855548973132158607768e-02 6.93689782004128785430907555564772e-01 5.57545405406910873913339798946254e-02
 	 2.59339011865785673549567036388908e-01 6.93689782004128785430907555564772e-01 4.69712061300855548973132158607768e-02 5.57545405406910873913339798946254e-02
 	 4.69712061300855548973132158607768e-02 2.59339011865785673549567036388908e-01 6.93689782004128785430907555564772e-01 5.57545405406910873913339798946254e-02
 	 4.69712061300855548973132158607768e-02 6.93689782004128785430907555564772e-01 2.59339011865785673549567036388908e-01 5.57545405406910873913339798946254e-02
 	 6.93689782004128785430907555564772e-01 2.59339011865785673549567036388908e-01 4.69712061300855548973132158607768e-02 5.57545405406910873913339798946254e-02
 	 6.93689782004128785430907555564772e-01 4.69712061300855548973132158607768e-02 2.59339011865785673549567036388908e-01 5.57545405406910873913339798946254e-02
 	 ];
 
 	 case   8 

 	 % ALG. DEG.:    8
 	 % PTS CARD.:   16
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.44315607677787172136163462710101e-01
 	 1.70569307751760101954374704291695e-01 1.70569307751760101954374704291695e-01 6.58861384496479796091250591416610e-01 1.03217370534718244634575512463925e-01
 	 1.70569307751760101954374704291695e-01 6.58861384496479796091250591416610e-01 1.70569307751760101954374704291695e-01 1.03217370534718244634575512463925e-01
 	 6.58861384496479796091250591416610e-01 1.70569307751760101954374704291695e-01 1.70569307751760101954374704291695e-01 1.03217370534718244634575512463925e-01
 	 4.59292588292723125142913431773195e-01 4.59292588292723125142913431773195e-01 8.14148234145537497141731364536099e-02 9.50916342672846193195823616406415e-02
 	 4.59292588292723125142913431773195e-01 8.14148234145537497141731364536099e-02 4.59292588292723125142913431773195e-01 9.50916342672846193195823616406415e-02
 	 8.14148234145537497141731364536099e-02 4.59292588292723125142913431773195e-01 4.59292588292723125142913431773195e-01 9.50916342672846193195823616406415e-02
 	 5.05472283170308595012798491552530e-02 5.05472283170308595012798491552530e-02 8.98905543365938308753015917318407e-01 3.24584976231980792960030157701112e-02
 	 5.05472283170308595012798491552530e-02 8.98905543365938308753015917318407e-01 5.05472283170308595012798491552530e-02 3.24584976231980792960030157701112e-02
 	 8.98905543365938308753015917318407e-01 5.05472283170308595012798491552530e-02 5.05472283170308595012798491552530e-02 3.24584976231980792960030157701112e-02
 	 2.63112829634638056841566822185996e-01 8.39477740995767801601701307845360e-03 7.28492392955404244325734453013865e-01 2.72303141744349927466650740370824e-02
 	 2.63112829634638056841566822185996e-01 7.28492392955404244325734453013865e-01 8.39477740995767801601701307845360e-03 2.72303141744349927466650740370824e-02
 	 8.39477740995767801601701307845360e-03 2.63112829634638056841566822185996e-01 7.28492392955404244325734453013865e-01 2.72303141744349927466650740370824e-02
 	 8.39477740995767801601701307845360e-03 7.28492392955404244325734453013865e-01 2.63112829634638056841566822185996e-01 2.72303141744349927466650740370824e-02
 	 7.28492392955404244325734453013865e-01 2.63112829634638056841566822185996e-01 8.39477740995767801601701307845360e-03 2.72303141744349927466650740370824e-02
 	 7.28492392955404244325734453013865e-01 8.39477740995767801601701307845360e-03 2.63112829634638056841566822185996e-01 2.72303141744349927466650740370824e-02
 	 ];
 
 	 case   9 

 	 % ALG. DEG.:    9
 	 % PTS CARD.:   19
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 9.71357962827988502541032289627765e-02
 	 4.89682519198737620236272505280795e-01 4.89682519198737620236272505280795e-01 2.06349616025247595274549894384108e-02 3.13347002271390784322591116506374e-02
 	 4.89682519198737620236272505280795e-01 2.06349616025247595274549894384108e-02 4.89682519198737620236272505280795e-01 3.13347002271390784322591116506374e-02
 	 2.06349616025247595274549894384108e-02 4.89682519198737620236272505280795e-01 4.89682519198737620236272505280795e-01 3.13347002271390784322591116506374e-02
 	 1.88203535619032635839431577551295e-01 1.88203535619032635839431577551295e-01 6.23592928761934728321136844897410e-01 7.96477389272102764827820919890655e-02
 	 1.88203535619032635839431577551295e-01 6.23592928761934728321136844897410e-01 1.88203535619032635839431577551295e-01 7.96477389272102764827820919890655e-02
 	 6.23592928761934728321136844897410e-01 1.88203535619032635839431577551295e-01 1.88203535619032635839431577551295e-01 7.96477389272102764827820919890655e-02
 	 4.37089591492936579975037147960393e-01 4.37089591492936579975037147960393e-01 1.25820817014126840049925704079214e-01 7.78275410047742782770896496913338e-02
 	 4.37089591492936579975037147960393e-01 1.25820817014126840049925704079214e-01 4.37089591492936579975037147960393e-01 7.78275410047742782770896496913338e-02
 	 1.25820817014126840049925704079214e-01 4.37089591492936579975037147960393e-01 4.37089591492936579975037147960393e-01 7.78275410047742782770896496913338e-02
 	 4.47295133944525663549640626115433e-02 4.47295133944525663549640626115433e-02 9.10540973211094839534496259148000e-01 2.55776756586980347218940323728020e-02
 	 4.47295133944525663549640626115433e-02 9.10540973211094839534496259148000e-01 4.47295133944525663549640626115433e-02 2.55776756586980347218940323728020e-02
 	 9.10540973211094839534496259148000e-01 4.47295133944525663549640626115433e-02 4.47295133944525663549640626115433e-02 2.55776756586980347218940323728020e-02
 	 2.21962989160765705731748198559217e-01 3.68384120547363136388696602807613e-02 7.41198598784498008384957756788936e-01 4.32835393772893761710207627402269e-02
 	 2.21962989160765705731748198559217e-01 7.41198598784498008384957756788936e-01 3.68384120547363136388696602807613e-02 4.32835393772893761710207627402269e-02
 	 3.68384120547363136388696602807613e-02 2.21962989160765705731748198559217e-01 7.41198598784498008384957756788936e-01 4.32835393772893761710207627402269e-02
 	 3.68384120547363136388696602807613e-02 7.41198598784498008384957756788936e-01 2.21962989160765705731748198559217e-01 4.32835393772893761710207627402269e-02
 	 7.41198598784498008384957756788936e-01 2.21962989160765705731748198559217e-01 3.68384120547363136388696602807613e-02 4.32835393772893761710207627402269e-02
 	 7.41198598784498008384957756788936e-01 3.68384120547363136388696602807613e-02 2.21962989160765705731748198559217e-01 4.32835393772893761710207627402269e-02
 	 ];
 
 	 case  10 

 	 % ALG. DEG.:   10
 	 % PTS CARD.:   25
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 6.7e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 8.36148743739739408464828329670127e-02
 	 4.95173459801170445793161434266949e-01 4.95173459801170445793161434266949e-01 9.65308039765910841367713146610186e-03 9.79259049841830521432317624430652e-03
 	 4.95173459801170445793161434266949e-01 9.65308039765910841367713146610186e-03 4.95173459801170445793161434266949e-01 9.79259049841830521432317624430652e-03
 	 9.65308039765910841367713146610186e-03 4.95173459801170445793161434266949e-01 4.95173459801170445793161434266949e-01 9.79259049841830521432317624430652e-03
 	 1.91394152428411012945019820108428e-02 1.91394152428411012945019820108428e-02 9.61721169514317741899844804720487e-01 6.38535923011865694243205382463202e-03
 	 1.91394152428411012945019820108428e-02 9.61721169514317741899844804720487e-01 1.91394152428411012945019820108428e-02 6.38535923011865694243205382463202e-03
 	 9.61721169514317741899844804720487e-01 1.91394152428411012945019820108428e-02 1.91394152428411012945019820108428e-02 6.38535923011865694243205382463202e-03
 	 1.84485012685246418939755130850244e-01 1.84485012685246418939755130850244e-01 6.31029974629507162120489738299511e-01 7.86337697463772994366237867325253e-02
 	 1.84485012685246418939755130850244e-01 6.31029974629507162120489738299511e-01 1.84485012685246418939755130850244e-01 7.86337697463772994366237867325253e-02
 	 6.31029974629507162120489738299511e-01 1.84485012685246418939755130850244e-01 1.84485012685246418939755130850244e-01 7.86337697463772994366237867325253e-02
 	 4.28234820943718841323999413361889e-01 4.28234820943718841323999413361889e-01 1.43530358112562317352001173276221e-01 7.52473279685440116226757822914806e-02
 	 4.28234820943718841323999413361889e-01 1.43530358112562317352001173276221e-01 4.28234820943718841323999413361889e-01 7.52473279685440116226757822914806e-02
 	 1.43530358112562317352001173276221e-01 4.28234820943718841323999413361889e-01 4.28234820943718841323999413361889e-01 7.52473279685440116226757822914806e-02
 	 1.33734755100869129318397199313040e-01 3.47236204823274940967081647613668e-02 8.31541624416803348829319020296680e-01 2.89622814632563493897343676053424e-02
 	 1.33734755100869129318397199313040e-01 8.31541624416803348829319020296680e-01 3.47236204823274940967081647613668e-02 2.89622814632563493897343676053424e-02
 	 3.47236204823274940967081647613668e-02 1.33734755100869129318397199313040e-01 8.31541624416803348829319020296680e-01 2.89622814632563493897343676053424e-02
 	 3.47236204823274940967081647613668e-02 8.31541624416803348829319020296680e-01 1.33734755100869129318397199313040e-01 2.89622814632563493897343676053424e-02
 	 8.31541624416803348829319020296680e-01 1.33734755100869129318397199313040e-01 3.47236204823274940967081647613668e-02 2.89622814632563493897343676053424e-02
 	 8.31541624416803348829319020296680e-01 3.47236204823274940967081647613668e-02 1.33734755100869129318397199313040e-01 2.89622814632563493897343676053424e-02
 	 3.26693136281336893311788571736543e-01 3.75827273411917031631368502075929e-02 6.35724136377471382708392866334179e-01 3.87390490860189118382805872897734e-02
 	 3.26693136281336893311788571736543e-01 6.35724136377471382708392866334179e-01 3.75827273411917031631368502075929e-02 3.87390490860189118382805872897734e-02
 	 3.75827273411917031631368502075929e-02 3.26693136281336893311788571736543e-01 6.35724136377471382708392866334179e-01 3.87390490860189118382805872897734e-02
 	 3.75827273411917031631368502075929e-02 6.35724136377471382708392866334179e-01 3.26693136281336893311788571736543e-01 3.87390490860189118382805872897734e-02
 	 6.35724136377471382708392866334179e-01 3.26693136281336893311788571736543e-01 3.75827273411917031631368502075929e-02 3.87390490860189118382805872897734e-02
 	 6.35724136377471382708392866334179e-01 3.75827273411917031631368502075929e-02 3.26693136281336893311788571736543e-01 3.87390490860189118382805872897734e-02
 	 ];
 
 	 case  11 

 	 % ALG. DEG.:   11
 	 % PTS CARD.:   28
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 5.8e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 8.14451347093512328934039601335826e-02
 	 3.08468956355878905217782204317700e-02 3.08468956355878905217782204317700e-02 9.38306208728824198139761847414775e-01 1.22492969507079548646677480405742e-02
 	 3.08468956355878905217782204317700e-02 9.38306208728824198139761847414775e-01 3.08468956355878905217782204317700e-02 1.22492969507079548646677480405742e-02
 	 9.38306208728824198139761847414775e-01 3.08468956355878905217782204317700e-02 3.08468956355878905217782204317700e-02 1.22492969507079548646677480405742e-02
 	 4.98780165178460743735655569253140e-01 4.98780165178460743735655569253140e-01 2.43966964307851252868886149371974e-03 1.24654918738813739326198870571716e-02
 	 4.98780165178460743735655569253140e-01 2.43966964307851252868886149371974e-03 4.98780165178460743735655569253140e-01 1.24654918738813739326198870571716e-02
 	 2.43966964307851252868886149371974e-03 4.98780165178460743735655569253140e-01 4.98780165178460743735655569253140e-01 1.24654918738813739326198870571716e-02
 	 1.13207827286693873958256517653354e-01 1.13207827286693873958256517653354e-01 7.73584345426612252083486964693293e-01 4.01292423813082860251100214554754e-02
 	 1.13207827286693873958256517653354e-01 7.73584345426612252083486964693293e-01 1.13207827286693873958256517653354e-01 4.01292423813082860251100214554754e-02
 	 7.73584345426612252083486964693293e-01 1.13207827286693873958256517653354e-01 1.13207827286693873958256517653354e-01 4.01292423813082860251100214554754e-02
 	 4.36655016393176054201319402636727e-01 4.36655016393176054201319402636727e-01 1.26689967213647891597361194726545e-01 6.30948721598986461689406723962747e-02
 	 4.36655016393176054201319402636727e-01 1.26689967213647891597361194726545e-01 4.36655016393176054201319402636727e-01 6.30948721598986461689406723962747e-02
 	 1.26689967213647891597361194726545e-01 4.36655016393176054201319402636727e-01 4.36655016393176054201319402636727e-01 6.30948721598986461689406723962747e-02
 	 2.14483458619269262701578782071010e-01 2.14483458619269262701578782071010e-01 5.71033082761461474596842435857980e-01 6.78451077436951072163751064181270e-02
 	 2.14483458619269262701578782071010e-01 5.71033082761461474596842435857980e-01 2.14483458619269262701578782071010e-01 6.78451077436951072163751064181270e-02
 	 5.71033082761461474596842435857980e-01 2.14483458619269262701578782071010e-01 2.14483458619269262701578782071010e-01 6.78451077436951072163751064181270e-02
 	 1.59303619837693477556683774309931e-01 1.43666625695556288838661274098740e-02 8.26329717592750867538597958628088e-01 1.45576233378092376180568123800185e-02
 	 1.59303619837693477556683774309931e-01 8.26329717592750867538597958628088e-01 1.43666625695556288838661274098740e-02 1.45576233378092376180568123800185e-02
 	 1.43666625695556288838661274098740e-02 1.59303619837693477556683774309931e-01 8.26329717592750867538597958628088e-01 1.45576233378092376180568123800185e-02
 	 1.43666625695556288838661274098740e-02 8.26329717592750867538597958628088e-01 1.59303619837693477556683774309931e-01 1.45576233378092376180568123800185e-02
 	 8.26329717592750867538597958628088e-01 1.59303619837693477556683774309931e-01 1.43666625695556288838661274098740e-02 1.45576233378092376180568123800185e-02
 	 8.26329717592750867538597958628088e-01 1.43666625695556288838661274098740e-02 1.59303619837693477556683774309931e-01 1.45576233378092376180568123800185e-02
 	 3.10631216313463132117078657756792e-01 4.76640669721508022926848013867129e-02 6.41704716714386114162493868207093e-01 4.06428486558864446309691231817851e-02
 	 3.10631216313463132117078657756792e-01 6.41704716714386114162493868207093e-01 4.76640669721508022926848013867129e-02 4.06428486558864446309691231817851e-02
 	 4.76640669721508022926848013867129e-02 3.10631216313463132117078657756792e-01 6.41704716714386114162493868207093e-01 4.06428486558864446309691231817851e-02
 	 4.76640669721508022926848013867129e-02 6.41704716714386114162493868207093e-01 3.10631216313463132117078657756792e-01 4.06428486558864446309691231817851e-02
 	 6.41704716714386114162493868207093e-01 3.10631216313463132117078657756792e-01 4.76640669721508022926848013867129e-02 4.06428486558864446309691231817851e-02
 	 6.41704716714386114162493868207093e-01 4.76640669721508022926848013867129e-02 3.10631216313463132117078657756792e-01 4.06428486558864446309691231817851e-02
 	 ];
 
 	 case  12 

 	 % ALG. DEG.:   12
 	 % PTS CARD.:   33
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.5e-16  

 	 xyw_bar=[
 	 2.71462507014926024417889038886642e-01 2.71462507014926024417889038886642e-01 4.57074985970147951164221922226716e-01 6.25412131959027922656346731855592e-02
 	 2.71462507014926024417889038886642e-01 4.57074985970147951164221922226716e-01 2.71462507014926024417889038886642e-01 6.25412131959027922656346731855592e-02
 	 4.57074985970147951164221922226716e-01 2.71462507014926024417889038886642e-01 2.71462507014926024417889038886642e-01 6.25412131959027922656346731855592e-02
 	 1.09257827659354198046592898663221e-01 1.09257827659354198046592898663221e-01 7.81484344681291576151238587044645e-01 2.84860520688775577247131565172822e-02
 	 1.09257827659354198046592898663221e-01 7.81484344681291576151238587044645e-01 1.09257827659354198046592898663221e-01 2.84860520688775577247131565172822e-02
 	 7.81484344681291576151238587044645e-01 1.09257827659354198046592898663221e-01 1.09257827659354198046592898663221e-01 2.84860520688775577247131565172822e-02
 	 4.40111648658593090921442581020528e-01 4.40111648658593090921442581020528e-01 1.19776702682813818157114837958943e-01 4.99183349280609700571176290395670e-02
 	 4.40111648658593090921442581020528e-01 1.19776702682813818157114837958943e-01 4.40111648658593090921442581020528e-01 4.99183349280609700571176290395670e-02
 	 1.19776702682813818157114837958943e-01 4.40111648658593090921442581020528e-01 4.40111648658593090921442581020528e-01 4.99183349280609700571176290395670e-02
 	 4.88203750945541525840809526926023e-01 4.88203750945541525840809526926023e-01 2.35924981089169483183809461479541e-02 2.42668380814520454058502707539446e-02
 	 4.88203750945541525840809526926023e-01 2.35924981089169483183809461479541e-02 4.88203750945541525840809526926023e-01 2.42668380814520454058502707539446e-02
 	 2.35924981089169483183809461479541e-02 4.88203750945541525840809526926023e-01 4.88203750945541525840809526926023e-01 2.42668380814520454058502707539446e-02
 	 2.46463634363354618106445315106612e-02 2.46463634363354618106445315106612e-02 9.50707273127329055562029225256993e-01 7.93164250997364234097020130320743e-03
 	 2.46463634363354618106445315106612e-02 9.50707273127329055562029225256993e-01 2.46463634363354618106445315106612e-02 7.93164250997364234097020130320743e-03
 	 9.50707273127329055562029225256993e-01 2.46463634363354618106445315106612e-02 2.46463634363354618106445315106612e-02 7.93164250997364234097020130320743e-03
 	 2.55454228638517299998511589365080e-01 1.16296019677926645852217291121633e-01 6.28249751683556012515907696069917e-01 4.32273636594142293687603739726910e-02
 	 2.55454228638517299998511589365080e-01 6.28249751683556012515907696069917e-01 1.16296019677926645852217291121633e-01 4.32273636594142293687603739726910e-02
 	 1.16296019677926645852217291121633e-01 2.55454228638517299998511589365080e-01 6.28249751683556012515907696069917e-01 4.32273636594142293687603739726910e-02
 	 1.16296019677926645852217291121633e-01 6.28249751683556012515907696069917e-01 2.55454228638517299998511589365080e-01 4.32273636594142293687603739726910e-02
 	 6.28249751683556012515907696069917e-01 2.55454228638517299998511589365080e-01 1.16296019677926645852217291121633e-01 4.32273636594142293687603739726910e-02
 	 6.28249751683556012515907696069917e-01 1.16296019677926645852217291121633e-01 2.55454228638517299998511589365080e-01 4.32273636594142293687603739726910e-02
 	 1.27279717233589356739642539650958e-01 2.13824902561706338410818517559164e-02 8.51337792510239999010934752732283e-01 1.50836775765114481512307875732404e-02
 	 1.27279717233589356739642539650958e-01 8.51337792510239999010934752732283e-01 2.13824902561706338410818517559164e-02 1.50836775765114481512307875732404e-02
 	 2.13824902561706338410818517559164e-02 1.27279717233589356739642539650958e-01 8.51337792510239999010934752732283e-01 1.50836775765114481512307875732404e-02
 	 2.13824902561706338410818517559164e-02 8.51337792510239999010934752732283e-01 1.27279717233589356739642539650958e-01 1.50836775765114481512307875732404e-02
 	 8.51337792510239999010934752732283e-01 1.27279717233589356739642539650958e-01 2.13824902561706338410818517559164e-02 1.50836775765114481512307875732404e-02
 	 8.51337792510239999010934752732283e-01 2.13824902561706338410818517559164e-02 1.27279717233589356739642539650958e-01 1.50836775765114481512307875732404e-02
 	 2.91655679738340944950891753251199e-01 2.30341563552671768633217652677558e-02 6.85310163906391878185786481481045e-01 2.17835850386075662032947519719528e-02
 	 2.91655679738340944950891753251199e-01 6.85310163906391878185786481481045e-01 2.30341563552671768633217652677558e-02 2.17835850386075662032947519719528e-02
 	 2.30341563552671768633217652677558e-02 2.91655679738340944950891753251199e-01 6.85310163906391878185786481481045e-01 2.17835850386075662032947519719528e-02
 	 2.30341563552671768633217652677558e-02 6.85310163906391878185786481481045e-01 2.91655679738340944950891753251199e-01 2.17835850386075662032947519719528e-02
 	 6.85310163906391878185786481481045e-01 2.91655679738340944950891753251199e-01 2.30341563552671768633217652677558e-02 2.17835850386075662032947519719528e-02
 	 6.85310163906391878185786481481045e-01 2.30341563552671768633217652677558e-02 2.91655679738340944950891753251199e-01 2.17835850386075662032947519719528e-02
 	 ];
 
 	 case  13 

 	 % ALG. DEG.:   13
 	 % PTS CARD.:   37
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 5.16226466642908388138266673195176e-02
 	 4.96135894741046079570168103600736e-01 4.96135894741046079570168103600736e-01 7.72821051790784085966379279852845e-03 9.94147636107259313753559126780601e-03
 	 4.96135894741046079570168103600736e-01 7.72821051790784085966379279852845e-03 4.96135894741046079570168103600736e-01 9.94147636107259313753559126780601e-03
 	 7.72821051790784085966379279852845e-03 4.96135894741046079570168103600736e-01 4.96135894741046079570168103600736e-01 9.94147636107259313753559126780601e-03
 	 4.69608689653491895299453062762041e-01 4.69608689653491895299453062762041e-01 6.07826206930162094010938744759187e-02 3.27812416037229839571587319824175e-02
 	 4.69608689653491895299453062762041e-01 6.07826206930162094010938744759187e-02 4.69608689653491895299453062762041e-01 3.27812416037229839571587319824175e-02
 	 6.07826206930162094010938744759187e-02 4.69608689653491895299453062762041e-01 4.69608689653491895299453062762041e-01 3.27812416037229839571587319824175e-02
 	 2.31110284949082200878223147810786e-01 2.31110284949082200878223147810786e-01 5.37779430101835598243553704378428e-01 4.60624095927782625792268333952961e-02
 	 2.31110284949082200878223147810786e-01 5.37779430101835598243553704378428e-01 2.31110284949082200878223147810786e-01 4.60624095927782625792268333952961e-02
 	 5.37779430101835598243553704378428e-01 2.31110284949082200878223147810786e-01 2.31110284949082200878223147810786e-01 4.60624095927782625792268333952961e-02
 	 4.14477570279054519097883257927606e-01 4.14477570279054519097883257927606e-01 1.71044859441890961804233484144788e-01 4.69470955421552108011162829370733e-02
 	 4.14477570279054519097883257927606e-01 1.71044859441890961804233484144788e-01 4.14477570279054519097883257927606e-01 4.69470955421552108011162829370733e-02
 	 1.71044859441890961804233484144788e-01 4.14477570279054519097883257927606e-01 4.14477570279054519097883257927606e-01 4.69470955421552108011162829370733e-02
 	 1.13559912572133075991942519067379e-01 1.13559912572133075991942519067379e-01 7.72880174855733903527266193123069e-01 3.09030979757598071866464550794262e-02
 	 1.13559912572133075991942519067379e-01 7.72880174855733903527266193123069e-01 1.13559912572133075991942519067379e-01 3.09030979757598071866464550794262e-02
 	 7.72880174855733903527266193123069e-01 1.13559912572133075991942519067379e-01 1.13559912572133075991942519067379e-01 3.09030979757598071866464550794262e-02
 	 2.48959314912162443800269784333068e-02 2.48959314912162443800269784333068e-02 9.50208137017567455728794811875559e-01 8.02939979525842464913587548380747e-03
 	 2.48959314912162443800269784333068e-02 9.50208137017567455728794811875559e-01 2.48959314912162443800269784333068e-02 8.02939979525842464913587548380747e-03
 	 9.50208137017567455728794811875559e-01 2.48959314912162443800269784333068e-02 2.48959314912162443800269784333068e-02 8.02939979525842464913587548380747e-03
 	 2.92078688576636380513917856660555e-01 1.89880043837590481436983225194126e-02 6.88933307039604536647914301283890e-01 1.81254986462008882419638666760875e-02
 	 2.92078688576636380513917856660555e-01 6.88933307039604536647914301283890e-01 1.89880043837590481436983225194126e-02 1.81254986462008882419638666760875e-02
 	 1.89880043837590481436983225194126e-02 2.92078688576636380513917856660555e-01 6.88933307039604536647914301283890e-01 1.81254986462008882419638666760875e-02
 	 1.89880043837590481436983225194126e-02 6.88933307039604536647914301283890e-01 2.92078688576636380513917856660555e-01 1.81254986462008882419638666760875e-02
 	 6.88933307039604536647914301283890e-01 2.92078688576636380513917856660555e-01 1.89880043837590481436983225194126e-02 1.81254986462008882419638666760875e-02
 	 6.88933307039604536647914301283890e-01 1.89880043837590481436983225194126e-02 2.92078688576636380513917856660555e-01 1.81254986462008882419638666760875e-02
 	 2.66745253310351149167445328203030e-01 9.77360310660165543250599284874625e-02 6.35518715623632268751919127680594e-01 3.72119604572615503279564563854365e-02
 	 2.66745253310351149167445328203030e-01 6.35518715623632268751919127680594e-01 9.77360310660165543250599284874625e-02 3.72119604572615503279564563854365e-02
 	 9.77360310660165543250599284874625e-02 2.66745253310351149167445328203030e-01 6.35518715623632268751919127680594e-01 3.72119604572615503279564563854365e-02
 	 9.77360310660165543250599284874625e-02 6.35518715623632268751919127680594e-01 2.66745253310351149167445328203030e-01 3.72119604572615503279564563854365e-02
 	 6.35518715623632268751919127680594e-01 2.66745253310351149167445328203030e-01 9.77360310660165543250599284874625e-02 3.72119604572615503279564563854365e-02
 	 6.35518715623632268751919127680594e-01 9.77360310660165543250599284874625e-02 2.66745253310351149167445328203030e-01 3.72119604572615503279564563854365e-02
 	 1.26799775783837304077295016213611e-01 2.19663442065292507932028343020647e-02 8.51233880009633514518441188556608e-01 1.53930726837821826163965610589912e-02
 	 1.26799775783837304077295016213611e-01 8.51233880009633514518441188556608e-01 2.19663442065292507932028343020647e-02 1.53930726837821826163965610589912e-02
 	 2.19663442065292507932028343020647e-02 1.26799775783837304077295016213611e-01 8.51233880009633514518441188556608e-01 1.53930726837821826163965610589912e-02
 	 2.19663442065292507932028343020647e-02 8.51233880009633514518441188556608e-01 1.26799775783837304077295016213611e-01 1.53930726837821826163965610589912e-02
 	 8.51233880009633514518441188556608e-01 1.26799775783837304077295016213611e-01 2.19663442065292507932028343020647e-02 1.53930726837821826163965610589912e-02
 	 8.51233880009633514518441188556608e-01 2.19663442065292507932028343020647e-02 1.26799775783837304077295016213611e-01 1.53930726837821826163965610589912e-02
 	 ];
 
 	 case  14 

 	 % ALG. DEG.:   14
 	 % PTS CARD.:   42
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 4.17644719340453884903752168611391e-01 4.17644719340453884903752168611391e-01 1.64710561319092230192495662777219e-01 3.27883535441253690101426343517232e-02
 	 4.17644719340453884903752168611391e-01 1.64710561319092230192495662777219e-01 4.17644719340453884903752168611391e-01 3.27883535441253690101426343517232e-02
 	 1.64710561319092230192495662777219e-01 4.17644719340453884903752168611391e-01 4.17644719340453884903752168611391e-01 3.27883535441253690101426343517232e-02
 	 6.17998830908724830490719170938974e-02 6.17998830908724830490719170938974e-02 8.76400233818255047779643973626662e-01 1.44336996697766745817448352795509e-02
 	 6.17998830908724830490719170938974e-02 8.76400233818255047779643973626662e-01 6.17998830908724830490719170938974e-02 1.44336996697766745817448352795509e-02
 	 8.76400233818255047779643973626662e-01 6.17998830908724830490719170938974e-02 6.17998830908724830490719170938974e-02 1.44336996697766745817448352795509e-02
 	 2.73477528308838591097895687198616e-01 2.73477528308838591097895687198616e-01 4.53044943382322817804208625602769e-01 5.17741045072916128422235715333954e-02
 	 2.73477528308838591097895687198616e-01 4.53044943382322817804208625602769e-01 2.73477528308838591097895687198616e-01 5.17741045072916128422235715333954e-02
 	 4.53044943382322817804208625602769e-01 2.73477528308838591097895687198616e-01 2.73477528308838591097895687198616e-01 5.17741045072916128422235715333954e-02
 	 1.77205532412543387277281681235763e-01 1.77205532412543387277281681235763e-01 6.45588935174913225445436637528474e-01 4.21625887369930438253184945551766e-02
 	 1.77205532412543387277281681235763e-01 6.45588935174913225445436637528474e-01 1.77205532412543387277281681235763e-01 4.21625887369930438253184945551766e-02
 	 6.45588935174913225445436637528474e-01 1.77205532412543387277281681235763e-01 1.77205532412543387277281681235763e-01 4.21625887369930438253184945551766e-02
 	 1.93909612487008810310928907938433e-02 1.93909612487008810310928907938433e-02 9.61218077502598244876708122319542e-01 4.92340360240008448333703938715189e-03
 	 1.93909612487008810310928907938433e-02 9.61218077502598244876708122319542e-01 1.93909612487008810310928907938433e-02 4.92340360240008448333703938715189e-03
 	 9.61218077502598244876708122319542e-01 1.93909612487008810310928907938433e-02 1.93909612487008810310928907938433e-02 4.92340360240008448333703938715189e-03
 	 4.88963910362178622026618768359185e-01 4.88963910362178622026618768359185e-01 2.20721792756427559467624632816296e-02 2.18835813694289033071171957089973e-02
 	 4.88963910362178622026618768359185e-01 2.20721792756427559467624632816296e-02 4.88963910362178622026618768359185e-01 2.18835813694289033071171957089973e-02
 	 2.20721792756427559467624632816296e-02 4.88963910362178622026618768359185e-01 4.88963910362178622026618768359185e-01 2.18835813694289033071171957089973e-02
 	 2.98372882136257677743174099305179e-01 1.46469500556544764136024383560652e-02 6.86980167808087793801519183034543e-01 1.44363081135338473803830794395253e-02
 	 2.98372882136257677743174099305179e-01 6.86980167808087793801519183034543e-01 1.46469500556544764136024383560652e-02 1.44363081135338473803830794395253e-02
 	 1.46469500556544764136024383560652e-02 2.98372882136257677743174099305179e-01 6.86980167808087793801519183034543e-01 1.44363081135338473803830794395253e-02
 	 1.46469500556544764136024383560652e-02 6.86980167808087793801519183034543e-01 2.98372882136257677743174099305179e-01 1.44363081135338473803830794395253e-02
 	 6.86980167808087793801519183034543e-01 2.98372882136257677743174099305179e-01 1.46469500556544764136024383560652e-02 1.44363081135338473803830794395253e-02
 	 6.86980167808087793801519183034543e-01 1.46469500556544764136024383560652e-02 2.98372882136257677743174099305179e-01 1.44363081135338473803830794395253e-02
 	 3.36861459796345019679364440889913e-01 9.29162493569718889174779974382545e-02 5.70222290846683077525369753857376e-01 3.85715107870606976891991735101328e-02
 	 3.36861459796345019679364440889913e-01 5.70222290846683077525369753857376e-01 9.29162493569718889174779974382545e-02 3.85715107870606976891991735101328e-02
 	 9.29162493569718889174779974382545e-02 3.36861459796345019679364440889913e-01 5.70222290846683077525369753857376e-01 3.85715107870606976891991735101328e-02
 	 9.29162493569718889174779974382545e-02 5.70222290846683077525369753857376e-01 3.36861459796345019679364440889913e-01 3.85715107870606976891991735101328e-02
 	 5.70222290846683077525369753857376e-01 3.36861459796345019679364440889913e-01 9.29162493569718889174779974382545e-02 3.85715107870606976891991735101328e-02
 	 5.70222290846683077525369753857376e-01 9.29162493569718889174779974382545e-02 3.36861459796345019679364440889913e-01 3.85715107870606976891991735101328e-02
 	 1.72266687821355540810586148836592e-01 5.71247574036480090797773812028026e-02 7.70608554774996457048530373867834e-01 2.46657532125636909381416472797355e-02
 	 1.72266687821355540810586148836592e-01 7.70608554774996457048530373867834e-01 5.71247574036480090797773812028026e-02 2.46657532125636909381416472797355e-02
 	 5.71247574036480090797773812028026e-02 1.72266687821355540810586148836592e-01 7.70608554774996457048530373867834e-01 2.46657532125636909381416472797355e-02
 	 5.71247574036480090797773812028026e-02 7.70608554774996457048530373867834e-01 1.72266687821355540810586148836592e-01 2.46657532125636909381416472797355e-02
 	 7.70608554774996457048530373867834e-01 1.72266687821355540810586148836592e-01 5.71247574036480090797773812028026e-02 2.46657532125636909381416472797355e-02
 	 7.70608554774996457048530373867834e-01 5.71247574036480090797773812028026e-02 1.72266687821355540810586148836592e-01 2.46657532125636909381416472797355e-02
 	 1.18974497696956824088765358737874e-01 1.26833093287207670021854433173303e-03 8.79757171370171175972529908904107e-01 5.01022883850067452665699718750147e-03
 	 1.18974497696956824088765358737874e-01 8.79757171370171175972529908904107e-01 1.26833093287207670021854433173303e-03 5.01022883850067452665699718750147e-03
 	 1.26833093287207670021854433173303e-03 1.18974497696956824088765358737874e-01 8.79757171370171175972529908904107e-01 5.01022883850067452665699718750147e-03
 	 1.26833093287207670021854433173303e-03 8.79757171370171175972529908904107e-01 1.18974497696956824088765358737874e-01 5.01022883850067452665699718750147e-03
 	 8.79757171370171175972529908904107e-01 1.18974497696956824088765358737874e-01 1.26833093287207670021854433173303e-03 5.01022883850067452665699718750147e-03
 	 8.79757171370171175972529908904107e-01 1.26833093287207670021854433173303e-03 1.18974497696956824088765358737874e-01 5.01022883850067452665699718750147e-03
 	 ];
 
 	 case  15 

 	 % ALG. DEG.:   15
 	 % PTS CARD.:   49
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.5e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.97304197480713315593359169497489e-02
 	 1.29978229933077754632009259694314e-01 1.29978229933077754632009259694314e-01 7.40043540133844546247132711869199e-01 7.39750406704610223573848060141245e-03
 	 1.29978229933077754632009259694314e-01 7.40043540133844546247132711869199e-01 1.29978229933077754632009259694314e-01 7.39750406704610223573848060141245e-03
 	 7.40043540133844546247132711869199e-01 1.29978229933077754632009259694314e-01 1.29978229933077754632009259694314e-01 7.39750406704610223573848060141245e-03
 	 4.60076949297059667465248367079766e-01 4.60076949297059667465248367079766e-01 7.98461014058806650695032658404671e-02 2.15940879364384594185644061781204e-02
 	 4.60076949297059667465248367079766e-01 7.98461014058806650695032658404671e-02 4.60076949297059667465248367079766e-01 2.15940879364384594185644061781204e-02
 	 7.98461014058806650695032658404671e-02 4.60076949297059667465248367079766e-01 4.60076949297059667465248367079766e-01 2.15940879364384594185644061781204e-02
 	 4.91685816630297201079713431681739e-01 4.91685816630297201079713431681739e-01 1.66283667394055978405731366365217e-02 1.58322763500218025023436041465175e-02
 	 4.91685816630297201079713431681739e-01 1.66283667394055978405731366365217e-02 4.91685816630297201079713431681739e-01 1.58322763500218025023436041465175e-02
 	 1.66283667394055978405731366365217e-02 4.91685816630297201079713431681739e-01 4.91685816630297201079713431681739e-01 1.58322763500218025023436041465175e-02
 	 2.21532340795141918787791723843839e-01 2.21532340795141918787791723843839e-01 5.56935318409716106913265321054496e-01 4.62872861051980971636155004489410e-02
 	 2.21532340795141918787791723843839e-01 5.56935318409716106913265321054496e-01 2.21532340795141918787791723843839e-01 4.62872861051980971636155004489410e-02
 	 5.56935318409716106913265321054496e-01 2.21532340795141918787791723843839e-01 2.21532340795141918787791723843839e-01 4.62872861051980971636155004489410e-02
 	 3.96933737409060571899033220688580e-01 3.96933737409060571899033220688580e-01 2.06132525181878856201933558622841e-01 4.63360413912072485742577043765777e-02
 	 3.96933737409060571899033220688580e-01 2.06132525181878856201933558622841e-01 3.96933737409060571899033220688580e-01 4.63360413912072485742577043765777e-02
 	 2.06132525181878856201933558622841e-01 3.96933737409060571899033220688580e-01 3.96933737409060571899033220688580e-01 4.63360413912072485742577043765777e-02
 	 5.63419176960999884551384297992627e-02 5.63419176960999884551384297992627e-02 8.87316164607800050845298756030388e-01 1.50844742475970735456902716009608e-02
 	 5.63419176960999884551384297992627e-02 8.87316164607800050845298756030388e-01 5.63419176960999884551384297992627e-02 1.50844742475970735456902716009608e-02
 	 8.87316164607800050845298756030388e-01 5.63419176960999884551384297992627e-02 5.63419176960999884551384297992627e-02 1.50844742475970735456902716009608e-02
 	 1.82321783407191295722782342636492e-01 8.45942214821918392342325887511834e-02 7.33083995110616837287409452983411e-01 2.42300087831256172332672349511995e-02
 	 1.82321783407191295722782342636492e-01 7.33083995110616837287409452983411e-01 8.45942214821918392342325887511834e-02 2.42300087831256172332672349511995e-02
 	 8.45942214821918392342325887511834e-02 1.82321783407191295722782342636492e-01 7.33083995110616837287409452983411e-01 2.42300087831256172332672349511995e-02
 	 8.45942214821918392342325887511834e-02 7.33083995110616837287409452983411e-01 1.82321783407191295722782342636492e-01 2.42300087831256172332672349511995e-02
 	 7.33083995110616837287409452983411e-01 1.82321783407191295722782342636492e-01 8.45942214821918392342325887511834e-02 2.42300087831256172332672349511995e-02
 	 7.33083995110616837287409452983411e-01 8.45942214821918392342325887511834e-02 1.82321783407191295722782342636492e-01 2.42300087831256172332672349511995e-02
 	 1.50200384065238723430013578763464e-01 1.60270897863454761522739033807738e-02 8.33772526148415793478818613948533e-01 1.12285042988780631861844838681463e-02
 	 1.50200384065238723430013578763464e-01 8.33772526148415793478818613948533e-01 1.60270897863454761522739033807738e-02 1.12285042988780631861844838681463e-02
 	 1.60270897863454761522739033807738e-02 1.50200384065238723430013578763464e-01 8.33772526148415793478818613948533e-01 1.12285042988780631861844838681463e-02
 	 1.60270897863454761522739033807738e-02 8.33772526148415793478818613948533e-01 1.50200384065238723430013578763464e-01 1.12285042988780631861844838681463e-02
 	 8.33772526148415793478818613948533e-01 1.50200384065238723430013578763464e-01 1.60270897863454761522739033807738e-02 1.12285042988780631861844838681463e-02
 	 8.33772526148415793478818613948533e-01 1.60270897863454761522739033807738e-02 1.50200384065238723430013578763464e-01 1.12285042988780631861844838681463e-02
 	 3.23111315163712664588757661476848e-01 9.76504424302423873482936755863193e-02 5.79238242406045045207463317638030e-01 3.10752204705109606741597616519357e-02
 	 3.23111315163712664588757661476848e-01 5.79238242406045045207463317638030e-01 9.76504424302423873482936755863193e-02 3.10752204705109606741597616519357e-02
 	 9.76504424302423873482936755863193e-02 3.23111315163712664588757661476848e-01 5.79238242406045045207463317638030e-01 3.10752204705109606741597616519357e-02
 	 9.76504424302423873482936755863193e-02 5.79238242406045045207463317638030e-01 3.23111315163712664588757661476848e-01 3.10752204705109606741597616519357e-02
 	 5.79238242406045045207463317638030e-01 3.23111315163712664588757661476848e-01 9.76504424302423873482936755863193e-02 3.10752204705109606741597616519357e-02
 	 5.79238242406045045207463317638030e-01 9.76504424302423873482936755863193e-02 3.23111315163712664588757661476848e-01 3.10752204705109606741597616519357e-02
 	 3.07947681483672908164805903652450e-01 1.84542519046331753018730381654677e-02 6.73598066611693968575025337486295e-01 1.64367620928278987402215705060371e-02
 	 3.07947681483672908164805903652450e-01 6.73598066611693968575025337486295e-01 1.84542519046331753018730381654677e-02 1.64367620928278987402215705060371e-02
 	 1.84542519046331753018730381654677e-02 3.07947681483672908164805903652450e-01 6.73598066611693968575025337486295e-01 1.64367620928278987402215705060371e-02
 	 1.84542519046331753018730381654677e-02 6.73598066611693968575025337486295e-01 3.07947681483672908164805903652450e-01 1.64367620928278987402215705060371e-02
 	 6.73598066611693968575025337486295e-01 3.07947681483672908164805903652450e-01 1.84542519046331753018730381654677e-02 1.64367620928278987402215705060371e-02
 	 6.73598066611693968575025337486295e-01 1.84542519046331753018730381654677e-02 3.07947681483672908164805903652450e-01 1.64367620928278987402215705060371e-02
 	 3.80352293011092870700373680392659e-02 1.11353527401374216738993983000228e-03 9.60851235424877048174607807595748e-01 2.47526601455791677580675624881223e-03
 	 3.80352293011092870700373680392659e-02 9.60851235424877048174607807595748e-01 1.11353527401374216738993983000228e-03 2.47526601455791677580675624881223e-03
 	 1.11353527401374216738993983000228e-03 3.80352293011092870700373680392659e-02 9.60851235424877048174607807595748e-01 2.47526601455791677580675624881223e-03
 	 1.11353527401374216738993983000228e-03 9.60851235424877048174607807595748e-01 3.80352293011092870700373680392659e-02 2.47526601455791677580675624881223e-03
 	 9.60851235424877048174607807595748e-01 3.80352293011092870700373680392659e-02 1.11353527401374216738993983000228e-03 2.47526601455791677580675624881223e-03
 	 9.60851235424877048174607807595748e-01 1.11353527401374216738993983000228e-03 3.80352293011092870700373680392659e-02 2.47526601455791677580675624881223e-03
 	 ];
 
 	 case  16 

 	 % ALG. DEG.:   16
 	 % PTS CARD.:   55
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.0e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 4.62279103141913921826144928672875e-02
 	 6.66744722402381612136323951744998e-02 6.66744722402381612136323951744998e-02 8.66651055519523705328310825279914e-01 1.24254255955610209971595736533345e-02
 	 6.66744722402381612136323951744998e-02 8.66651055519523705328310825279914e-01 6.66744722402381612136323951744998e-02 1.24254255955610209971595736533345e-02
 	 8.66651055519523705328310825279914e-01 6.66744722402381612136323951744998e-02 6.66744722402381612136323951744998e-02 1.24254255955610209971595736533345e-02
 	 2.41321680701378271649559792422224e-01 2.41321680701378271649559792422224e-01 5.17356638597243456700880415155552e-01 4.11840410697925859984103169608716e-02
 	 2.41321680701378271649559792422224e-01 5.17356638597243456700880415155552e-01 2.41321680701378271649559792422224e-01 4.11840410697925859984103169608716e-02
 	 5.17356638597243456700880415155552e-01 2.41321680701378271649559792422224e-01 2.41321680701378271649559792422224e-01 4.11840410697925859984103169608716e-02
 	 4.12798095955223653952259610377951e-01 4.12798095955223653952259610377951e-01 1.74403808089552692095480779244099e-01 4.09852197868154077831093218264868e-02
 	 4.12798095955223653952259610377951e-01 1.74403808089552692095480779244099e-01 4.12798095955223653952259610377951e-01 4.09852197868154077831093218264868e-02
 	 1.74403808089552692095480779244099e-01 4.12798095955223653952259610377951e-01 4.12798095955223653952259610377951e-01 4.09852197868154077831093218264868e-02
 	 1.50063736587034979308441506873351e-01 1.50063736587034979308441506873351e-01 6.99872526825930041383116986253299e-01 2.87834967027489375956950112822597e-02
 	 1.50063736587034979308441506873351e-01 6.99872526825930041383116986253299e-01 1.50063736587034979308441506873351e-01 2.87834967027489375956950112822597e-02
 	 6.99872526825930041383116986253299e-01 1.50063736587034979308441506873351e-01 1.50063736587034979308441506873351e-01 2.87834967027489375956950112822597e-02
 	 4.69548030996684961912990274868207e-01 4.69548030996684961912990274868207e-01 6.09039380066300761740194502635859e-02 2.70936694677104787654098316806994e-02
 	 4.69548030996684961912990274868207e-01 6.09039380066300761740194502635859e-02 4.69548030996684961912990274868207e-01 2.70936694677104787654098316806994e-02
 	 6.09039380066300761740194502635859e-02 4.69548030996684961912990274868207e-01 4.69548030996684961912990274868207e-01 2.70936694677104787654098316806994e-02
 	 1.70416294057182740595557390861359e-02 1.70416294057182740595557390861359e-02 9.65916741188563410247525098384358e-01 3.78913523826422595636165269183948e-03
 	 1.70416294057182740595557390861359e-02 9.65916741188563410247525098384358e-01 1.70416294057182740595557390861359e-02 3.78913523826422595636165269183948e-03
 	 9.65916741188563410247525098384358e-01 1.70416294057182740595557390861359e-02 1.70416294057182740595557390861359e-02 3.78913523826422595636165269183948e-03
 	 4.13769485827085170548400583356852e-01 9.66495440366025790335235967631888e-03 5.76565559769254609712163528456585e-01 8.18221055322214570193484206583889e-03
 	 4.13769485827085170548400583356852e-01 5.76565559769254609712163528456585e-01 9.66495440366025790335235967631888e-03 8.18221055322214570193484206583889e-03
 	 9.66495440366025790335235967631888e-03 4.13769485827085170548400583356852e-01 5.76565559769254609712163528456585e-01 8.18221055322214570193484206583889e-03
 	 9.66495440366025790335235967631888e-03 5.76565559769254609712163528456585e-01 4.13769485827085170548400583356852e-01 8.18221055322214570193484206583889e-03
 	 5.76565559769254609712163528456585e-01 4.13769485827085170548400583356852e-01 9.66495440366025790335235967631888e-03 8.18221055322214570193484206583889e-03
 	 5.76565559769254609712163528456585e-01 9.66495440366025790335235967631888e-03 4.13769485827085170548400583356852e-01 8.18221055322214570193484206583889e-03
 	 3.04179448229479731935498421080410e-01 3.03059433551863786904245756659293e-02 6.65514608415333941415781282557873e-01 1.39836071246535794537768637724184e-02
 	 3.04179448229479731935498421080410e-01 6.65514608415333941415781282557873e-01 3.03059433551863786904245756659293e-02 1.39836071246535794537768637724184e-02
 	 3.03059433551863786904245756659293e-02 3.04179448229479731935498421080410e-01 6.65514608415333941415781282557873e-01 1.39836071246535794537768637724184e-02
 	 3.03059433551863786904245756659293e-02 6.65514608415333941415781282557873e-01 3.04179448229479731935498421080410e-01 1.39836071246535794537768637724184e-02
 	 6.65514608415333941415781282557873e-01 3.04179448229479731935498421080410e-01 3.03059433551863786904245756659293e-02 1.39836071246535794537768637724184e-02
 	 6.65514608415333941415781282557873e-01 3.03059433551863786904245756659293e-02 3.04179448229479731935498421080410e-01 1.39836071246535794537768637724184e-02
 	 8.96090890227058400885340461172746e-02 1.08129727761037564698343160785043e-02 8.99577938201190474565294152853312e-01 5.75186997049716500218785597553506e-03
 	 8.96090890227058400885340461172746e-02 8.99577938201190474565294152853312e-01 1.08129727761037564698343160785043e-02 5.75186997049716500218785597553506e-03
 	 1.08129727761037564698343160785043e-02 8.96090890227058400885340461172746e-02 8.99577938201190474565294152853312e-01 5.75186997049716500218785597553506e-03
 	 1.08129727761037564698343160785043e-02 8.99577938201190474565294152853312e-01 8.96090890227058400885340461172746e-02 5.75186997049716500218785597553506e-03
 	 8.99577938201190474565294152853312e-01 8.96090890227058400885340461172746e-02 1.08129727761037564698343160785043e-02 5.75186997049716500218785597553506e-03
 	 8.99577938201190474565294152853312e-01 1.08129727761037564698343160785043e-02 8.96090890227058400885340461172746e-02 5.75186997049716500218785597553506e-03
 	 2.96615372400382937279061934532365e-01 1.06653160536148483572560508036986e-01 5.96731467063468579148377557430649e-01 3.16460616819832785129307239913032e-02
 	 2.96615372400382937279061934532365e-01 5.96731467063468579148377557430649e-01 1.06653160536148483572560508036986e-01 3.16460616819832785129307239913032e-02
 	 1.06653160536148483572560508036986e-01 2.96615372400382937279061934532365e-01 5.96731467063468579148377557430649e-01 3.16460616819832785129307239913032e-02
 	 1.06653160536148483572560508036986e-01 5.96731467063468579148377557430649e-01 2.96615372400382937279061934532365e-01 3.16460616819832785129307239913032e-02
 	 5.96731467063468579148377557430649e-01 2.96615372400382937279061934532365e-01 1.06653160536148483572560508036986e-01 3.16460616819832785129307239913032e-02
 	 5.96731467063468579148377557430649e-01 1.06653160536148483572560508036986e-01 2.96615372400382937279061934532365e-01 3.16460616819832785129307239913032e-02
 	 1.69763355150289729778023684048094e-01 5.13543153440131280862424034694413e-02 7.78882329505697135196840008575236e-01 1.76530810471033049180444862713557e-02
 	 1.69763355150289729778023684048094e-01 7.78882329505697135196840008575236e-01 5.13543153440131280862424034694413e-02 1.76530810471033049180444862713557e-02
 	 5.13543153440131280862424034694413e-02 1.69763355150289729778023684048094e-01 7.78882329505697135196840008575236e-01 1.76530810471033049180444862713557e-02
 	 5.13543153440131280862424034694413e-02 7.78882329505697135196840008575236e-01 1.69763355150289729778023684048094e-01 1.76530810471033049180444862713557e-02
 	 7.78882329505697135196840008575236e-01 1.69763355150289729778023684048094e-01 5.13543153440131280862424034694413e-02 1.76530810471033049180444862713557e-02
 	 7.78882329505697135196840008575236e-01 5.13543153440131280862424034694413e-02 1.69763355150289729778023684048094e-01 1.76530810471033049180444862713557e-02
 	 2.14048779925847282301631935297337e-01 3.69694270735561368937394099987159e-03 7.82254277366797090564887184882537e-01 4.61469063972913887128335375109600e-03
 	 2.14048779925847282301631935297337e-01 7.82254277366797090564887184882537e-01 3.69694270735561368937394099987159e-03 4.61469063972913887128335375109600e-03
 	 3.69694270735561368937394099987159e-03 2.14048779925847282301631935297337e-01 7.82254277366797090564887184882537e-01 4.61469063972913887128335375109600e-03
 	 3.69694270735561368937394099987159e-03 7.82254277366797090564887184882537e-01 2.14048779925847282301631935297337e-01 4.61469063972913887128335375109600e-03
 	 7.82254277366797090564887184882537e-01 2.14048779925847282301631935297337e-01 3.69694270735561368937394099987159e-03 4.61469063972913887128335375109600e-03
 	 7.82254277366797090564887184882537e-01 3.69694270735561368937394099987159e-03 2.14048779925847282301631935297337e-01 4.61469063972913887128335375109600e-03
 	 ];
 
 	 case  17 

 	 % ALG. DEG.:   17
 	 % PTS CARD.:   60
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 9.5e-16  

 	 xyw_bar=[
 	 4.17103444361599184908584447839530e-01 4.17103444361599184908584447839530e-01 1.65793111276801630182831104320940e-01 2.73109265281020995030925035962355e-02
 	 4.17103444361599184908584447839530e-01 1.65793111276801630182831104320940e-01 4.17103444361599184908584447839530e-01 2.73109265281020995030925035962355e-02
 	 1.65793111276801630182831104320940e-01 4.17103444361599184908584447839530e-01 4.17103444361599184908584447839530e-01 2.73109265281020995030925035962355e-02
 	 1.80358116266370549496400599309709e-01 1.80358116266370549496400599309709e-01 6.39283767467258901007198801380582e-01 2.63126305880179781060412835813622e-02
 	 1.80358116266370549496400599309709e-01 6.39283767467258901007198801380582e-01 1.80358116266370549496400599309709e-01 2.63126305880179781060412835813622e-02
 	 6.39283767467258901007198801380582e-01 1.80358116266370549496400599309709e-01 1.80358116266370549496400599309709e-01 2.63126305880179781060412835813622e-02
 	 2.85706502436586573523413790098857e-01 2.85706502436586573523413790098857e-01 4.28586995126826852953172419802286e-01 3.77162371527952761107727042144688e-02
 	 2.85706502436586573523413790098857e-01 4.28586995126826852953172419802286e-01 2.85706502436586573523413790098857e-01 3.77162371527952761107727042144688e-02
 	 4.28586995126826852953172419802286e-01 2.85706502436586573523413790098857e-01 2.85706502436586573523413790098857e-01 3.77162371527952761107727042144688e-02
 	 6.66540634795968062187299096876814e-02 6.66540634795968062187299096876814e-02 8.66691873040806415318115796253551e-01 1.24590008023054386876449228793717e-02
 	 6.66540634795968062187299096876814e-02 8.66691873040806415318115796253551e-01 6.66540634795968062187299096876814e-02 1.24590008023054386876449228793717e-02
 	 8.66691873040806415318115796253551e-01 6.66540634795968062187299096876814e-02 6.66540634795968062187299096876814e-02 1.24590008023054386876449228793717e-02
 	 1.47554916607538222361739599364228e-02 1.47554916607538222361739599364228e-02 9.70489016678492300016500848869327e-01 2.77388757763764176589305066045199e-03
 	 1.47554916607538222361739599364228e-02 9.70489016678492300016500848869327e-01 1.47554916607538222361739599364228e-02 2.77388757763764176589305066045199e-03
 	 9.70489016678492300016500848869327e-01 1.47554916607538222361739599364228e-02 1.47554916607538222361739599364228e-02 2.77388757763764176589305066045199e-03
 	 4.65597871618890268852197777960100e-01 4.65597871618890268852197777960100e-01 6.88042567622194622956044440797996e-02 2.50194509504973496005764133087723e-02
 	 4.65597871618890268852197777960100e-01 6.88042567622194622956044440797996e-02 4.65597871618890268852197777960100e-01 2.50194509504973496005764133087723e-02
 	 6.88042567622194622956044440797996e-02 4.65597871618890268852197777960100e-01 4.65597871618890268852197777960100e-01 2.50194509504973496005764133087723e-02
 	 7.25054707990023805663781786279287e-02 1.15751759031806882721538087821500e-02 9.15919353297816929426744536613114e-01 4.58434840173586617001477705457546e-03
 	 7.25054707990023805663781786279287e-02 9.15919353297816929426744536613114e-01 1.15751759031806882721538087821500e-02 4.58434840173586617001477705457546e-03
 	 1.15751759031806882721538087821500e-02 7.25054707990023805663781786279287e-02 9.15919353297816929426744536613114e-01 4.58434840173586617001477705457546e-03
 	 1.15751759031806882721538087821500e-02 9.15919353297816929426744536613114e-01 7.25054707990023805663781786279287e-02 4.58434840173586617001477705457546e-03
 	 9.15919353297816929426744536613114e-01 7.25054707990023805663781786279287e-02 1.15751759031806882721538087821500e-02 4.58434840173586617001477705457546e-03
 	 9.15919353297816929426744536613114e-01 1.15751759031806882721538087821500e-02 7.25054707990023805663781786279287e-02 4.58434840173586617001477705457546e-03
 	 4.15475459295229054834663884321344e-01 1.32296727600869565288910223443963e-02 5.71294867944684092719853651942685e-01 1.03984399558395348983630412931234e-02
 	 4.15475459295229054834663884321344e-01 5.71294867944684092719853651942685e-01 1.32296727600869565288910223443963e-02 1.03984399558395348983630412931234e-02
 	 1.32296727600869565288910223443963e-02 4.15475459295229054834663884321344e-01 5.71294867944684092719853651942685e-01 1.03984399558395348983630412931234e-02
 	 1.32296727600869565288910223443963e-02 5.71294867944684092719853651942685e-01 4.15475459295229054834663884321344e-01 1.03984399558395348983630412931234e-02
 	 5.71294867944684092719853651942685e-01 4.15475459295229054834663884321344e-01 1.32296727600869565288910223443963e-02 1.03984399558395348983630412931234e-02
 	 5.71294867944684092719853651942685e-01 1.32296727600869565288910223443963e-02 4.15475459295229054834663884321344e-01 1.03984399558395348983630412931234e-02
 	 2.71791870055354767288235962041654e-01 1.31358708340027583588716098006444e-02 7.15072259110642427515358576783910e-01 8.69221450100118864234843840677058e-03
 	 2.71791870055354767288235962041654e-01 7.15072259110642427515358576783910e-01 1.31358708340027583588716098006444e-02 8.69221450100118864234843840677058e-03
 	 1.31358708340027583588716098006444e-02 2.71791870055354767288235962041654e-01 7.15072259110642427515358576783910e-01 8.69221450100118864234843840677058e-03
 	 1.31358708340027583588716098006444e-02 7.15072259110642427515358576783910e-01 2.71791870055354767288235962041654e-01 8.69221450100118864234843840677058e-03
 	 7.15072259110642427515358576783910e-01 2.71791870055354767288235962041654e-01 1.31358708340027583588716098006444e-02 8.69221450100118864234843840677058e-03
 	 7.15072259110642427515358576783910e-01 1.31358708340027583588716098006444e-02 2.71791870055354767288235962041654e-01 8.69221450100118864234843840677058e-03
 	 2.99218942476970284349846451732446e-01 1.57505477926869974503176763391821e-01 5.43275579596159796658128016133560e-01 2.61716259353369784523835051004426e-02
 	 2.99218942476970284349846451732446e-01 5.43275579596159796658128016133560e-01 1.57505477926869974503176763391821e-01 2.61716259353369784523835051004426e-02
 	 1.57505477926869974503176763391821e-01 2.99218942476970284349846451732446e-01 5.43275579596159796658128016133560e-01 2.61716259353369784523835051004426e-02
 	 1.57505477926869974503176763391821e-01 5.43275579596159796658128016133560e-01 2.99218942476970284349846451732446e-01 2.61716259353369784523835051004426e-02
 	 5.43275579596159796658128016133560e-01 2.99218942476970284349846451732446e-01 1.57505477926869974503176763391821e-01 2.61716259353369784523835051004426e-02
 	 5.43275579596159796658128016133560e-01 1.57505477926869974503176763391821e-01 2.99218942476970284349846451732446e-01 2.61716259353369784523835051004426e-02
 	 3.06281591746186521163508587051183e-01 6.73493778673612542018389603981632e-02 6.26369030386452196879076836921740e-01 2.24877725466910635687689534734091e-02
 	 3.06281591746186521163508587051183e-01 6.26369030386452196879076836921740e-01 6.73493778673612542018389603981632e-02 2.24877725466910635687689534734091e-02
 	 6.73493778673612542018389603981632e-02 3.06281591746186521163508587051183e-01 6.26369030386452196879076836921740e-01 2.24877725466910635687689534734091e-02
 	 6.73493778673612542018389603981632e-02 6.26369030386452196879076836921740e-01 3.06281591746186521163508587051183e-01 2.24877725466910635687689534734091e-02
 	 6.26369030386452196879076836921740e-01 3.06281591746186521163508587051183e-01 6.73493778673612542018389603981632e-02 2.24877725466910635687689534734091e-02
 	 6.26369030386452196879076836921740e-01 6.73493778673612542018389603981632e-02 3.06281591746186521163508587051183e-01 2.24877725466910635687689534734091e-02
 	 1.68722513495259435201134579074278e-01 7.80423405682824783413664704312396e-02 7.53235145936458017068559911422199e-01 2.05578983204545116814099259272552e-02
 	 1.68722513495259435201134579074278e-01 7.53235145936458017068559911422199e-01 7.80423405682824783413664704312396e-02 2.05578983204545116814099259272552e-02
 	 7.80423405682824783413664704312396e-02 1.68722513495259435201134579074278e-01 7.53235145936458017068559911422199e-01 2.05578983204545116814099259272552e-02
 	 7.80423405682824783413664704312396e-02 7.53235145936458017068559911422199e-01 1.68722513495259435201134579074278e-01 2.05578983204545116814099259272552e-02
 	 7.53235145936458017068559911422199e-01 1.68722513495259435201134579074278e-01 7.80423405682824783413664704312396e-02 2.05578983204545116814099259272552e-02
 	 7.53235145936458017068559911422199e-01 7.80423405682824783413664704312396e-02 1.68722513495259435201134579074278e-01 2.05578983204545116814099259272552e-02
 	 1.59192287472792681768396505503915e-01 1.60176423621193435298248886056172e-02 8.24790070165087985110119461751310e-01 7.97830020592959175684821815366377e-03
 	 1.59192287472792681768396505503915e-01 8.24790070165087985110119461751310e-01 1.60176423621193435298248886056172e-02 7.97830020592959175684821815366377e-03
 	 1.60176423621193435298248886056172e-02 1.59192287472792681768396505503915e-01 8.24790070165087985110119461751310e-01 7.97830020592959175684821815366377e-03
 	 1.60176423621193435298248886056172e-02 8.24790070165087985110119461751310e-01 1.59192287472792681768396505503915e-01 7.97830020592959175684821815366377e-03
 	 8.24790070165087985110119461751310e-01 1.59192287472792681768396505503915e-01 1.60176423621193435298248886056172e-02 7.97830020592959175684821815366377e-03
 	 8.24790070165087985110119461751310e-01 1.60176423621193435298248886056172e-02 1.59192287472792681768396505503915e-01 7.97830020592959175684821815366377e-03
 	 ];
 
 	 case  18 

 	 % ALG. DEG.:   18
 	 % PTS CARD.:   67
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.07485212391158460598639123872999e-02
 	 4.74918211324045713705999105513911e-01 4.74918211324045713705999105513911e-01 5.01635773519085725880017889721785e-02 1.31070274917387524088452366299862e-02
 	 4.74918211324045713705999105513911e-01 5.01635773519085725880017889721785e-02 4.74918211324045713705999105513911e-01 1.31070274917387524088452366299862e-02
 	 5.01635773519085725880017889721785e-02 4.74918211324045713705999105513911e-01 4.74918211324045713705999105513911e-01 1.31070274917387524088452366299862e-02
 	 1.51638506972604725220321597589646e-01 1.51638506972604725220321597589646e-01 6.96722986054790549559356804820709e-01 2.03183388454583925553098566751942e-02
 	 1.51638506972604725220321597589646e-01 6.96722986054790549559356804820709e-01 1.51638506972604725220321597589646e-01 2.03183388454583925553098566751942e-02
 	 6.96722986054790549559356804820709e-01 1.51638506972604725220321597589646e-01 1.51638506972604725220321597589646e-01 2.03183388454583925553098566751942e-02
 	 4.11067101875919438391804305865662e-01 4.11067101875919438391804305865662e-01 1.77865796248161123216391388268676e-01 3.34719940598478815640959282973199e-02
 	 4.11067101875919438391804305865662e-01 1.77865796248161123216391388268676e-01 4.11067101875919438391804305865662e-01 3.34719940598478815640959282973199e-02
 	 1.77865796248161123216391388268676e-01 4.11067101875919438391804305865662e-01 4.11067101875919438391804305865662e-01 3.34719940598478815640959282973199e-02
 	 2.65614609905374166043401373826782e-01 2.65614609905374166043401373826782e-01 4.68770780189251667913197252346436e-01 3.11163966020061195927315367271149e-02
 	 2.65614609905374166043401373826782e-01 4.68770780189251667913197252346436e-01 2.65614609905374166043401373826782e-01 3.11163966020061195927315367271149e-02
 	 4.68770780189251667913197252346436e-01 2.65614609905374166043401373826782e-01 2.65614609905374166043401373826782e-01 3.11163966020061195927315367271149e-02
 	 3.75894434106820423541206466211406e-03 3.75894434106820423541206466211406e-03 9.92482111317863568977770682977280e-01 5.32005616947780405993906338579791e-04
 	 3.75894434106820423541206466211406e-03 9.92482111317863568977770682977280e-01 3.75894434106820423541206466211406e-03 5.32005616947780405993906338579791e-04
 	 9.92482111317863568977770682977280e-01 3.75894434106820423541206466211406e-03 3.75894434106820423541206466211406e-03 5.32005616947780405993906338579791e-04
 	 7.24387055673327562299590454131248e-02 7.24387055673327562299590454131248e-02 8.55122588865334432028930677915923e-01 1.37902866047669350052506942461150e-02
 	 7.24387055673327562299590454131248e-02 8.55122588865334432028930677915923e-01 7.24387055673327562299590454131248e-02 1.37902866047669350052506942461150e-02
 	 8.55122588865334432028930677915923e-01 7.24387055673327562299590454131248e-02 7.24387055673327562299590454131248e-02 1.37902866047669350052506942461150e-02
 	 3.85044034413163649421818490736769e-01 9.04270403543406542379301527034841e-02 5.24528925232495724095826972188661e-01 1.53282581945531348743827493308345e-02
 	 3.85044034413163649421818490736769e-01 5.24528925232495724095826972188661e-01 9.04270403543406542379301527034841e-02 1.53282581945531348743827493308345e-02
 	 9.04270403543406542379301527034841e-02 3.85044034413163649421818490736769e-01 5.24528925232495724095826972188661e-01 1.53282581945531348743827493308345e-02
 	 9.04270403543406542379301527034841e-02 5.24528925232495724095826972188661e-01 3.85044034413163649421818490736769e-01 1.53282581945531348743827493308345e-02
 	 5.24528925232495724095826972188661e-01 3.85044034413163649421818490736769e-01 9.04270403543406542379301527034841e-02 1.53282581945531348743827493308345e-02
 	 5.24528925232495724095826972188661e-01 9.04270403543406542379301527034841e-02 3.85044034413163649421818490736769e-01 1.53282581945531348743827493308345e-02
 	 4.72761418326517468546654754391056e-02 1.24989324834954822901478266317099e-02 9.40224925683852852387190068839118e-01 4.21751677474444149062993147936140e-03
 	 4.72761418326517468546654754391056e-02 9.40224925683852852387190068839118e-01 1.24989324834954822901478266317099e-02 4.21751677474444149062993147936140e-03
 	 1.24989324834954822901478266317099e-02 4.72761418326517468546654754391056e-02 9.40224925683852852387190068839118e-01 4.21751677474444149062993147936140e-03
 	 1.24989324834954822901478266317099e-02 9.40224925683852852387190068839118e-01 4.72761418326517468546654754391056e-02 4.21751677474444149062993147936140e-03
 	 9.40224925683852852387190068839118e-01 4.72761418326517468546654754391056e-02 1.24989324834954822901478266317099e-02 4.21751677474444149062993147936140e-03
 	 9.40224925683852852387190068839118e-01 1.24989324834954822901478266317099e-02 4.72761418326517468546654754391056e-02 4.21751677474444149062993147936140e-03
 	 3.02061957712870754466649714231608e-01 5.40117353390242999067183404804382e-02 6.43926306948105042771146599989152e-01 1.63659084139865587670392699237709e-02
 	 3.02061957712870754466649714231608e-01 6.43926306948105042771146599989152e-01 5.40117353390242999067183404804382e-02 1.63659084139865587670392699237709e-02
 	 5.40117353390242999067183404804382e-02 3.02061957712870754466649714231608e-01 6.43926306948105042771146599989152e-01 1.63659084139865587670392699237709e-02
 	 5.40117353390242999067183404804382e-02 6.43926306948105042771146599989152e-01 3.02061957712870754466649714231608e-01 1.63659084139865587670392699237709e-02
 	 6.43926306948105042771146599989152e-01 3.02061957712870754466649714231608e-01 5.40117353390242999067183404804382e-02 1.63659084139865587670392699237709e-02
 	 6.43926306948105042771146599989152e-01 5.40117353390242999067183404804382e-02 3.02061957712870754466649714231608e-01 1.63659084139865587670392699237709e-02
 	 2.56506159774241515592052564898040e-01 1.05050188192419655802689604229272e-02 7.32988821406516555256871470191982e-01 7.72983528000622480830239524607350e-03
 	 2.56506159774241515592052564898040e-01 7.32988821406516555256871470191982e-01 1.05050188192419655802689604229272e-02 7.72983528000622480830239524607350e-03
 	 1.05050188192419655802689604229272e-02 2.56506159774241515592052564898040e-01 7.32988821406516555256871470191982e-01 7.72983528000622480830239524607350e-03
 	 1.05050188192419655802689604229272e-02 7.32988821406516555256871470191982e-01 2.56506159774241515592052564898040e-01 7.72983528000622480830239524607350e-03
 	 7.32988821406516555256871470191982e-01 2.56506159774241515592052564898040e-01 1.05050188192419655802689604229272e-02 7.72983528000622480830239524607350e-03
 	 7.32988821406516555256871470191982e-01 1.05050188192419655802689604229272e-02 2.56506159774241515592052564898040e-01 7.72983528000622480830239524607350e-03
 	 1.78479125565887630777694994321791e-01 6.61224580284034413324434353853576e-02 7.55398416405708927889861570292851e-01 1.69116539174800697975520336058253e-02
 	 1.78479125565887630777694994321791e-01 7.55398416405708927889861570292851e-01 6.61224580284034413324434353853576e-02 1.69116539174800697975520336058253e-02
 	 6.61224580284034413324434353853576e-02 1.78479125565887630777694994321791e-01 7.55398416405708927889861570292851e-01 1.69116539174800697975520336058253e-02
 	 6.61224580284034413324434353853576e-02 7.55398416405708927889861570292851e-01 1.78479125565887630777694994321791e-01 1.69116539174800697975520336058253e-02
 	 7.55398416405708927889861570292851e-01 1.78479125565887630777694994321791e-01 6.61224580284034413324434353853576e-02 1.69116539174800697975520336058253e-02
 	 7.55398416405708927889861570292851e-01 6.61224580284034413324434353853576e-02 1.78479125565887630777694994321791e-01 1.69116539174800697975520336058253e-02
 	 2.68573306396013788965859703239403e-01 1.49066910125773915973823591230030e-01 5.82359783478212267304741089901654e-01 2.75928864885794655759099214265007e-02
 	 2.68573306396013788965859703239403e-01 5.82359783478212267304741089901654e-01 1.49066910125773915973823591230030e-01 2.75928864885794655759099214265007e-02
 	 1.49066910125773915973823591230030e-01 2.68573306396013788965859703239403e-01 5.82359783478212267304741089901654e-01 2.75928864885794655759099214265007e-02
 	 1.49066910125773915973823591230030e-01 5.82359783478212267304741089901654e-01 2.68573306396013788965859703239403e-01 2.75928864885794655759099214265007e-02
 	 5.82359783478212267304741089901654e-01 2.68573306396013788965859703239403e-01 1.49066910125773915973823591230030e-01 2.75928864885794655759099214265007e-02
 	 5.82359783478212267304741089901654e-01 1.49066910125773915973823591230030e-01 2.68573306396013788965859703239403e-01 2.75928864885794655759099214265007e-02
 	 4.11065668674618356348560155311134e-01 1.16918246746671606467460335920805e-02 5.77242506650714526372780710516963e-01 9.58612447436150115487318856821730e-03
 	 4.11065668674618356348560155311134e-01 5.77242506650714526372780710516963e-01 1.16918246746671606467460335920805e-02 9.58612447436150115487318856821730e-03
 	 1.16918246746671606467460335920805e-02 4.11065668674618356348560155311134e-01 5.77242506650714526372780710516963e-01 9.58612447436150115487318856821730e-03
 	 1.16918246746671606467460335920805e-02 5.77242506650714526372780710516963e-01 4.11065668674618356348560155311134e-01 9.58612447436150115487318856821730e-03
 	 5.77242506650714526372780710516963e-01 4.11065668674618356348560155311134e-01 1.16918246746671606467460335920805e-02 9.58612447436150115487318856821730e-03
 	 5.77242506650714526372780710516963e-01 1.16918246746671606467460335920805e-02 4.11065668674618356348560155311134e-01 9.58612447436150115487318856821730e-03
 	 1.32778830271389286510341776192945e-01 1.43315247789419925039666736665822e-02 8.52889644949668790374630589212757e-01 7.64170497271963317098553147843631e-03
 	 1.32778830271389286510341776192945e-01 8.52889644949668790374630589212757e-01 1.43315247789419925039666736665822e-02 7.64170497271963317098553147843631e-03
 	 1.43315247789419925039666736665822e-02 1.32778830271389286510341776192945e-01 8.52889644949668790374630589212757e-01 7.64170497271963317098553147843631e-03
 	 1.43315247789419925039666736665822e-02 8.52889644949668790374630589212757e-01 1.32778830271389286510341776192945e-01 7.64170497271963317098553147843631e-03
 	 8.52889644949668790374630589212757e-01 1.32778830271389286510341776192945e-01 1.43315247789419925039666736665822e-02 7.64170497271963317098553147843631e-03
 	 8.52889644949668790374630589212757e-01 1.43315247789419925039666736665822e-02 1.32778830271389286510341776192945e-01 7.64170497271963317098553147843631e-03
 	 ];
 
 	 case  19 

 	 % ALG. DEG.:   19
 	 % PTS CARD.:   73
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.44691608509052477282708082384488e-02
 	 5.25262798541034220400902654546371e-02 5.25262798541034220400902654546371e-02 8.94947440291793183675395084719639e-01 7.10939362279494179580607848834006e-03
 	 5.25262798541034220400902654546371e-02 8.94947440291793183675395084719639e-01 5.25262798541034220400902654546371e-02 7.10939362279494179580607848834006e-03
 	 8.94947440291793183675395084719639e-01 5.25262798541034220400902654546371e-02 5.25262798541034220400902654546371e-02 7.10939362279494179580607848834006e-03
 	 1.11448055716998548070328922676708e-01 1.11448055716998548070328922676708e-01 7.77103888566002876103766539017670e-01 1.52349565170048252549239720110563e-02
 	 1.11448055716998548070328922676708e-01 7.77103888566002876103766539017670e-01 1.11448055716998548070328922676708e-01 1.52349565170048252549239720110563e-02
 	 7.77103888566002876103766539017670e-01 1.11448055716998548070328922676708e-01 1.11448055716998548070328922676708e-01 1.52349565170048252549239720110563e-02
 	 1.16390273279224441133061773712143e-02 1.16390273279224441133061773712143e-02 9.76721945344155129120622405025642e-01 1.76519241830853869552886425964289e-03
 	 1.16390273279224441133061773712143e-02 9.76721945344155129120622405025642e-01 1.16390273279224441133061773712143e-02 1.76519241830853869552886425964289e-03
 	 9.76721945344155129120622405025642e-01 1.16390273279224441133061773712143e-02 1.16390273279224441133061773712143e-02 1.76519241830853869552886425964289e-03
 	 2.55162133153124748297102541982895e-01 2.55162133153124748297102541982895e-01 4.89675733693750503405794916034210e-01 3.17528545875299592071705490070599e-02
 	 2.55162133153124748297102541982895e-01 4.89675733693750503405794916034210e-01 2.55162133153124748297102541982895e-01 3.17528545875299592071705490070599e-02
 	 4.89675733693750503405794916034210e-01 2.55162133153124748297102541982895e-01 2.55162133153124748297102541982895e-01 3.17528545875299592071705490070599e-02
 	 4.03969717966386032692582830350148e-01 4.03969717966386032692582830350148e-01 1.92060564067227934614834339299705e-01 3.15373586452395923696023771753971e-02
 	 4.03969717966386032692582830350148e-01 1.92060564067227934614834339299705e-01 4.03969717966386032692582830350148e-01 3.15373586452395923696023771753971e-02
 	 1.92060564067227934614834339299705e-01 4.03969717966386032692582830350148e-01 4.03969717966386032692582830350148e-01 3.15373586452395923696023771753971e-02
 	 1.78171006079627408658083709269704e-01 1.78171006079627408658083709269704e-01 6.43657987840745127172681350202765e-01 2.46519810535848135635283995270584e-02
 	 1.78171006079627408658083709269704e-01 6.43657987840745127172681350202765e-01 1.78171006079627408658083709269704e-01 2.46519810535848135635283995270584e-02
 	 6.43657987840745127172681350202765e-01 1.78171006079627408658083709269704e-01 1.78171006079627408658083709269704e-01 2.46519810535848135635283995270584e-02
 	 4.59194388956827626024903565848945e-01 4.59194388956827626024903565848945e-01 8.16112220863447479501928683021106e-02 2.29835709771232347964353692759687e-02
 	 4.59194388956827626024903565848945e-01 8.16112220863447479501928683021106e-02 4.59194388956827626024903565848945e-01 2.29835709771232347964353692759687e-02
 	 8.16112220863447479501928683021106e-02 4.59194388956827626024903565848945e-01 4.59194388956827626024903565848945e-01 2.29835709771232347964353692759687e-02
 	 4.92512449865874224474993070543860e-01 4.92512449865874224474993070543860e-01 1.49751002682515510500138589122798e-02 1.03218821824188535657418341884295e-02
 	 4.92512449865874224474993070543860e-01 1.49751002682515510500138589122798e-02 4.92512449865874224474993070543860e-01 1.03218821824188535657418341884295e-02
 	 1.49751002682515510500138589122798e-02 4.92512449865874224474993070543860e-01 4.92512449865874224474993070543860e-01 1.03218821824188535657418341884295e-02
 	 1.42422282571126906924874333526532e-01 5.00514235235043503796648067805108e-03 8.52572575076522731762906914809719e-01 2.92569248788006937983530164615331e-03
 	 1.42422282571126906924874333526532e-01 8.52572575076522731762906914809719e-01 5.00514235235043503796648067805108e-03 2.92569248788006937983530164615331e-03
 	 5.00514235235043503796648067805108e-03 1.42422282571126906924874333526532e-01 8.52572575076522731762906914809719e-01 2.92569248788006937983530164615331e-03
 	 5.00514235235043503796648067805108e-03 8.52572575076522731762906914809719e-01 1.42422282571126906924874333526532e-01 2.92569248788006937983530164615331e-03
 	 8.52572575076522731762906914809719e-01 1.42422282571126906924874333526532e-01 5.00514235235043503796648067805108e-03 2.92569248788006937983530164615331e-03
 	 8.52572575076522731762906914809719e-01 5.00514235235043503796648067805108e-03 1.42422282571126906924874333526532e-01 2.92569248788006937983530164615331e-03
 	 6.00838999627023515048840351937542e-02 9.77706143867685707748993451104980e-03 9.30139038598620793152349506272003e-01 3.32738884059390277805889901685532e-03
 	 6.00838999627023515048840351937542e-02 9.30139038598620793152349506272003e-01 9.77706143867685707748993451104980e-03 3.32738884059390277805889901685532e-03
 	 9.77706143867685707748993451104980e-03 6.00838999627023515048840351937542e-02 9.30139038598620793152349506272003e-01 3.32738884059390277805889901685532e-03
 	 9.77706143867685707748993451104980e-03 9.30139038598620793152349506272003e-01 6.00838999627023515048840351937542e-02 3.32738884059390277805889901685532e-03
 	 9.30139038598620793152349506272003e-01 6.00838999627023515048840351937542e-02 9.77706143867685707748993451104980e-03 3.32738884059390277805889901685532e-03
 	 9.30139038598620793152349506272003e-01 9.77706143867685707748993451104980e-03 6.00838999627023515048840351937542e-02 3.32738884059390277805889901685532e-03
 	 1.30700669960534532343388036679244e-01 3.91424494346088655549742441053240e-02 8.30156880604856595162743815308204e-01 9.69551908162419491532535431588258e-03
 	 1.30700669960534532343388036679244e-01 8.30156880604856595162743815308204e-01 3.91424494346088655549742441053240e-02 9.69551908162419491532535431588258e-03
 	 3.91424494346088655549742441053240e-02 1.30700669960534532343388036679244e-01 8.30156880604856595162743815308204e-01 9.69551908162419491532535431588258e-03
 	 3.91424494346088655549742441053240e-02 8.30156880604856595162743815308204e-01 1.30700669960534532343388036679244e-01 9.69551908162419491532535431588258e-03
 	 8.30156880604856595162743815308204e-01 1.30700669960534532343388036679244e-01 3.91424494346088655549742441053240e-02 9.69551908162419491532535431588258e-03
 	 8.30156880604856595162743815308204e-01 3.91424494346088655549742441053240e-02 1.30700669960534532343388036679244e-01 9.69551908162419491532535431588258e-03
 	 3.11318383223986860919296759675490e-01 1.29312809767979042252505905707949e-01 5.59368807008034041317046103358734e-01 2.63462647074453465423360398744990e-02
 	 3.11318383223986860919296759675490e-01 5.59368807008034041317046103358734e-01 1.29312809767979042252505905707949e-01 2.63462647074453465423360398744990e-02
 	 1.29312809767979042252505905707949e-01 3.11318383223986860919296759675490e-01 5.59368807008034041317046103358734e-01 2.63462647074453465423360398744990e-02
 	 1.29312809767979042252505905707949e-01 5.59368807008034041317046103358734e-01 3.11318383223986860919296759675490e-01 2.63462647074453465423360398744990e-02
 	 5.59368807008034041317046103358734e-01 3.11318383223986860919296759675490e-01 1.29312809767979042252505905707949e-01 2.63462647074453465423360398744990e-02
 	 5.59368807008034041317046103358734e-01 1.29312809767979042252505905707949e-01 3.11318383223986860919296759675490e-01 2.63462647074453465423360398744990e-02
 	 2.21433941889113417023082774903742e-01 7.45611893043551660076317944003677e-02 7.04004868806531458602648854139261e-01 1.81080745904304910021132002384547e-02
 	 2.21433941889113417023082774903742e-01 7.04004868806531458602648854139261e-01 7.45611893043551660076317944003677e-02 1.81080745904304910021132002384547e-02
 	 7.45611893043551660076317944003677e-02 2.21433941889113417023082774903742e-01 7.04004868806531458602648854139261e-01 1.81080745904304910021132002384547e-02
 	 7.45611893043551660076317944003677e-02 7.04004868806531458602648854139261e-01 2.21433941889113417023082774903742e-01 1.81080745904304910021132002384547e-02
 	 7.04004868806531458602648854139261e-01 2.21433941889113417023082774903742e-01 7.45611893043551660076317944003677e-02 1.81080745904304910021132002384547e-02
 	 7.04004868806531458602648854139261e-01 7.45611893043551660076317944003677e-02 2.21433941889113417023082774903742e-01 1.81080745904304910021132002384547e-02
 	 3.54025926999711915144075646821875e-01 4.08883144649781413160205545409553e-02 6.05085758535309992112161125987768e-01 1.61022094609394178510441975049616e-02
 	 3.54025926999711915144075646821875e-01 6.05085758535309992112161125987768e-01 4.08883144649781413160205545409553e-02 1.61022094609394178510441975049616e-02
 	 4.08883144649781413160205545409553e-02 3.54025926999711915144075646821875e-01 6.05085758535309992112161125987768e-01 1.61022094609394178510441975049616e-02
 	 4.08883144649781413160205545409553e-02 6.05085758535309992112161125987768e-01 3.54025926999711915144075646821875e-01 1.61022094609394178510441975049616e-02
 	 6.05085758535309992112161125987768e-01 3.54025926999711915144075646821875e-01 4.08883144649781413160205545409553e-02 1.61022094609394178510441975049616e-02
 	 6.05085758535309992112161125987768e-01 4.08883144649781413160205545409553e-02 3.54025926999711915144075646821875e-01 1.61022094609394178510441975049616e-02
 	 2.41894104006892624036950678600988e-01 1.49236389074384866865186083373374e-02 7.43182257085668873664019429270411e-01 8.45592483909347360226949064099244e-03
 	 2.41894104006892624036950678600988e-01 7.43182257085668873664019429270411e-01 1.49236389074384866865186083373374e-02 8.45592483909347360226949064099244e-03
 	 1.49236389074384866865186083373374e-02 2.41894104006892624036950678600988e-01 7.43182257085668873664019429270411e-01 8.45592483909347360226949064099244e-03
 	 1.49236389074384866865186083373374e-02 7.43182257085668873664019429270411e-01 2.41894104006892624036950678600988e-01 8.45592483909347360226949064099244e-03
 	 7.43182257085668873664019429270411e-01 2.41894104006892624036950678600988e-01 1.49236389074384866865186083373374e-02 8.45592483909347360226949064099244e-03
 	 7.43182257085668873664019429270411e-01 1.49236389074384866865186083373374e-02 2.41894104006892624036950678600988e-01 8.45592483909347360226949064099244e-03
 	 3.64620414338710008284039076897898e-01 2.06910384910238874869858882732387e-03 6.33310481812187631156518818897894e-01 3.28213751483973558906170886473319e-03
 	 3.64620414338710008284039076897898e-01 6.33310481812187631156518818897894e-01 2.06910384910238874869858882732387e-03 3.28213751483973558906170886473319e-03
 	 2.06910384910238874869858882732387e-03 3.64620414338710008284039076897898e-01 6.33310481812187631156518818897894e-01 3.28213751483973558906170886473319e-03
 	 2.06910384910238874869858882732387e-03 6.33310481812187631156518818897894e-01 3.64620414338710008284039076897898e-01 3.28213751483973558906170886473319e-03
 	 6.33310481812187631156518818897894e-01 3.64620414338710008284039076897898e-01 2.06910384910238874869858882732387e-03 3.28213751483973558906170886473319e-03
 	 6.33310481812187631156518818897894e-01 2.06910384910238874869858882732387e-03 3.64620414338710008284039076897898e-01 3.28213751483973558906170886473319e-03
 	 ];
 
 	 case  20 

 	 % ALG. DEG.:   20
 	 % PTS CARD.:   79
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.78202214029062526445823522180945e-02
 	 1.86294997744540891115860858917586e-01 1.86294997744540891115860858917586e-01 6.27410004510918217768278282164829e-01 1.83469259485058433511994735454209e-02
 	 1.86294997744540891115860858917586e-01 6.27410004510918217768278282164829e-01 1.86294997744540891115860858917586e-01 1.83469259485058433511994735454209e-02
 	 6.27410004510918217768278282164829e-01 1.86294997744540891115860858917586e-01 1.86294997744540891115860858917586e-01 1.83469259485058433511994735454209e-02
 	 3.73108805988845854129110080066312e-02 3.73108805988845854129110080066312e-02 9.25378238802230801418602368357824e-01 4.32255082133115812320633963850014e-03
 	 3.73108805988845854129110080066312e-02 9.25378238802230801418602368357824e-01 3.73108805988845854129110080066312e-02 4.32255082133115812320633963850014e-03
 	 9.25378238802230801418602368357824e-01 3.73108805988845854129110080066312e-02 3.73108805988845854129110080066312e-02 4.32255082133115812320633963850014e-03
 	 4.76245611540498992031444913664018e-01 4.76245611540498992031444913664018e-01 4.75087769190020159371101726719644e-02 1.42036506068168935645879003004666e-02
 	 4.76245611540498992031444913664018e-01 4.75087769190020159371101726719644e-02 4.76245611540498992031444913664018e-01 1.42036506068168935645879003004666e-02
 	 4.75087769190020159371101726719644e-02 4.76245611540498992031444913664018e-01 4.76245611540498992031444913664018e-01 1.42036506068168935645879003004666e-02
 	 4.45551056955924784652722792088753e-01 4.45551056955924784652722792088753e-01 1.08897886088150430694554415822495e-01 1.89047998664649136157933639879047e-02
 	 4.45551056955924784652722792088753e-01 1.08897886088150430694554415822495e-01 4.45551056955924784652722792088753e-01 1.89047998664649136157933639879047e-02
 	 1.08897886088150430694554415822495e-01 4.45551056955924784652722792088753e-01 4.45551056955924784652722792088753e-01 1.89047998664649136157933639879047e-02
 	 2.54579267673339049160574631969212e-01 2.54579267673339049160574631969212e-01 4.90841464653321901678850736061577e-01 2.81664026150405186199598972507374e-02
 	 2.54579267673339049160574631969212e-01 4.90841464653321901678850736061577e-01 2.54579267673339049160574631969212e-01 2.81664026150405186199598972507374e-02
 	 4.90841464653321901678850736061577e-01 2.54579267673339049160574631969212e-01 2.54579267673339049160574631969212e-01 2.81664026150405186199598972507374e-02
 	 3.93425347817099813063634883292252e-01 3.93425347817099813063634883292252e-01 2.13149304365800373872730233415496e-01 2.75761012581409378774388585497945e-02
 	 3.93425347817099813063634883292252e-01 2.13149304365800373872730233415496e-01 3.93425347817099813063634883292252e-01 2.75761012581409378774388585497945e-02
 	 2.13149304365800373872730233415496e-01 3.93425347817099813063634883292252e-01 3.93425347817099813063634883292252e-01 2.75761012581409378774388585497945e-02
 	 1.09761410283976314911091876069804e-02 1.09761410283976314911091876069804e-02 9.78047717943204775181698096275795e-01 1.59768158213324123519127883952251e-03
 	 1.09761410283976314911091876069804e-02 9.78047717943204775181698096275795e-01 1.09761410283976314911091876069804e-02 1.59768158213324123519127883952251e-03
 	 9.78047717943204775181698096275795e-01 1.09761410283976314911091876069804e-02 1.09761410283976314911091876069804e-02 1.59768158213324123519127883952251e-03
 	 1.09383596711714464744247266025923e-01 1.09383596711714464744247266025923e-01 7.81232806576571015000354236690328e-01 1.56604615521490804497251048132966e-02
 	 1.09383596711714464744247266025923e-01 7.81232806576571015000354236690328e-01 1.09383596711714464744247266025923e-01 1.56604615521490804497251048132966e-02
 	 7.81232806576571015000354236690328e-01 1.09383596711714464744247266025923e-01 1.09383596711714464744247266025923e-01 1.56604615521490804497251048132966e-02
 	 6.40905856084340308509439410045161e-02 4.85493760762382986495566683515790e-03 9.31054476783942153161888199974783e-01 2.25973920425173290665865621917874e-03
 	 6.40905856084340308509439410045161e-02 9.31054476783942153161888199974783e-01 4.85493760762382986495566683515790e-03 2.25973920425173290665865621917874e-03
 	 4.85493760762382986495566683515790e-03 6.40905856084340308509439410045161e-02 9.31054476783942153161888199974783e-01 2.25973920425173290665865621917874e-03
 	 4.85493760762382986495566683515790e-03 9.31054476783942153161888199974783e-01 6.40905856084340308509439410045161e-02 2.25973920425173290665865621917874e-03
 	 9.31054476783942153161888199974783e-01 6.40905856084340308509439410045161e-02 4.85493760762382986495566683515790e-03 2.25973920425173290665865621917874e-03
 	 9.31054476783942153161888199974783e-01 4.85493760762382986495566683515790e-03 6.40905856084340308509439410045161e-02 2.25973920425173290665865621917874e-03
 	 2.15607057390094364324184539327689e-01 1.06227204720270099191914425773575e-01 6.78165737889635522606113227084279e-01 1.54452156441984740642414664080206e-02
 	 2.15607057390094364324184539327689e-01 6.78165737889635522606113227084279e-01 1.06227204720270099191914425773575e-01 1.54452156441984740642414664080206e-02
 	 1.06227204720270099191914425773575e-01 2.15607057390094364324184539327689e-01 6.78165737889635522606113227084279e-01 1.54452156441984740642414664080206e-02
 	 1.06227204720270099191914425773575e-01 6.78165737889635522606113227084279e-01 2.15607057390094364324184539327689e-01 1.54452156441984740642414664080206e-02
 	 6.78165737889635522606113227084279e-01 2.15607057390094364324184539327689e-01 1.06227204720270099191914425773575e-01 1.54452156441984740642414664080206e-02
 	 6.78165737889635522606113227084279e-01 1.06227204720270099191914425773575e-01 2.15607057390094364324184539327689e-01 1.54452156441984740642414664080206e-02
 	 1.59133707657067219320978779251163e-01 7.57078050469658144633333662909536e-03 8.33295511838236135915281010966282e-01 4.40579483711699918663251551720350e-03
 	 1.59133707657067219320978779251163e-01 8.33295511838236135915281010966282e-01 7.57078050469658144633333662909536e-03 4.40579483711699918663251551720350e-03
 	 7.57078050469658144633333662909536e-03 1.59133707657067219320978779251163e-01 8.33295511838236135915281010966282e-01 4.40579483711699918663251551720350e-03
 	 7.57078050469658144633333662909536e-03 8.33295511838236135915281010966282e-01 1.59133707657067219320978779251163e-01 4.40579483711699918663251551720350e-03
 	 8.33295511838236135915281010966282e-01 1.59133707657067219320978779251163e-01 7.57078050469658144633333662909536e-03 4.40579483711699918663251551720350e-03
 	 8.33295511838236135915281010966282e-01 7.57078050469658144633333662909536e-03 1.59133707657067219320978779251163e-01 4.40579483711699918663251551720350e-03
 	 3.17860123835771946065875681597390e-01 1.39808071991799981459436708064459e-01 5.42331804172428100230263225967064e-01 2.33834914636554917766186889593882e-02
 	 3.17860123835771946065875681597390e-01 5.42331804172428100230263225967064e-01 1.39808071991799981459436708064459e-01 2.33834914636554917766186889593882e-02
 	 1.39808071991799981459436708064459e-01 3.17860123835771946065875681597390e-01 5.42331804172428100230263225967064e-01 2.33834914636554917766186889593882e-02
 	 1.39808071991799981459436708064459e-01 5.42331804172428100230263225967064e-01 3.17860123835771946065875681597390e-01 2.33834914636554917766186889593882e-02
 	 5.42331804172428100230263225967064e-01 3.17860123835771946065875681597390e-01 1.39808071991799981459436708064459e-01 2.33834914636554917766186889593882e-02
 	 5.42331804172428100230263225967064e-01 1.39808071991799981459436708064459e-01 3.17860123835771946065875681597390e-01 2.33834914636554917766186889593882e-02
 	 1.98518132228788168891497889489983e-01 4.65603649076643533177843892190140e-02 7.54921502863547533301868952548830e-01 1.19727971579093907250612716097748e-02
 	 1.98518132228788168891497889489983e-01 7.54921502863547533301868952548830e-01 4.65603649076643533177843892190140e-02 1.19727971579093907250612716097748e-02
 	 4.65603649076643533177843892190140e-02 1.98518132228788168891497889489983e-01 7.54921502863547533301868952548830e-01 1.19727971579093907250612716097748e-02
 	 4.65603649076643533177843892190140e-02 7.54921502863547533301868952548830e-01 1.98518132228788168891497889489983e-01 1.19727971579093907250612716097748e-02
 	 7.54921502863547533301868952548830e-01 1.98518132228788168891497889489983e-01 4.65603649076643533177843892190140e-02 1.19727971579093907250612716097748e-02
 	 7.54921502863547533301868952548830e-01 4.65603649076643533177843892190140e-02 1.98518132228788168891497889489983e-01 1.19727971579093907250612716097748e-02
 	 9.99522962881386201061673091317061e-02 3.83636847753746762501592115768290e-02 8.61684018936486717521461287105922e-01 8.29142305522772259107622261353754e-03
 	 9.99522962881386201061673091317061e-02 8.61684018936486717521461287105922e-01 3.83636847753746762501592115768290e-02 8.29142305522772259107622261353754e-03
 	 3.83636847753746762501592115768290e-02 9.99522962881386201061673091317061e-02 8.61684018936486717521461287105922e-01 8.29142305522772259107622261353754e-03
 	 3.83636847753746762501592115768290e-02 8.61684018936486717521461287105922e-01 9.99522962881386201061673091317061e-02 8.29142305522772259107622261353754e-03
 	 8.61684018936486717521461287105922e-01 9.99522962881386201061673091317061e-02 3.83636847753746762501592115768290e-02 8.29142305522772259107622261353754e-03
 	 8.61684018936486717521461287105922e-01 3.83636847753746762501592115768290e-02 9.99522962881386201061673091317061e-02 8.29142305522772259107622261353754e-03
 	 4.20023758816224057621724341515801e-01 9.83154829280259191792712414326161e-03 5.70144692890973248111663451709319e-01 7.39136300051060259747037761712818e-03
 	 4.20023758816224057621724341515801e-01 5.70144692890973248111663451709319e-01 9.83154829280259191792712414326161e-03 7.39136300051060259747037761712818e-03
 	 9.83154829280259191792712414326161e-03 4.20023758816224057621724341515801e-01 5.70144692890973248111663451709319e-01 7.39136300051060259747037761712818e-03
 	 9.83154829280259191792712414326161e-03 5.70144692890973248111663451709319e-01 4.20023758816224057621724341515801e-01 7.39136300051060259747037761712818e-03
 	 5.70144692890973248111663451709319e-01 4.20023758816224057621724341515801e-01 9.83154829280259191792712414326161e-03 7.39136300051060259747037761712818e-03
 	 5.70144692890973248111663451709319e-01 9.83154829280259191792712414326161e-03 4.20023758816224057621724341515801e-01 7.39136300051060259747037761712818e-03
 	 3.33134817309587438760587474462227e-01 5.49874791429868711722939167430013e-02 6.11877703547425766394951551774284e-01 1.73344511344386796591887645035968e-02
 	 3.33134817309587438760587474462227e-01 6.11877703547425766394951551774284e-01 5.49874791429868711722939167430013e-02 1.73344511344386796591887645035968e-02
 	 5.49874791429868711722939167430013e-02 3.33134817309587438760587474462227e-01 6.11877703547425766394951551774284e-01 1.73344511344386796591887645035968e-02
 	 5.49874791429868711722939167430013e-02 6.11877703547425766394951551774284e-01 3.33134817309587438760587474462227e-01 1.73344511344386796591887645035968e-02
 	 6.11877703547425766394951551774284e-01 3.33134817309587438760587474462227e-01 5.49874791429868711722939167430013e-02 1.73344511344386796591887645035968e-02
 	 6.11877703547425766394951551774284e-01 5.49874791429868711722939167430013e-02 3.33134817309587438760587474462227e-01 1.73344511344386796591887645035968e-02
 	 2.80581411423665216808842615137110e-01 1.07372128560111156081458005928653e-02 7.08681375720323636357989016687497e-01 7.15640047691537637547520844805149e-03
 	 2.80581411423665216808842615137110e-01 7.08681375720323636357989016687497e-01 1.07372128560111156081458005928653e-02 7.15640047691537637547520844805149e-03
 	 1.07372128560111156081458005928653e-02 2.80581411423665216808842615137110e-01 7.08681375720323636357989016687497e-01 7.15640047691537637547520844805149e-03
 	 1.07372128560111156081458005928653e-02 7.08681375720323636357989016687497e-01 2.80581411423665216808842615137110e-01 7.15640047691537637547520844805149e-03
 	 7.08681375720323636357989016687497e-01 2.80581411423665216808842615137110e-01 1.07372128560111156081458005928653e-02 7.15640047691537637547520844805149e-03
 	 7.08681375720323636357989016687497e-01 1.07372128560111156081458005928653e-02 2.80581411423665216808842615137110e-01 7.15640047691537637547520844805149e-03
 	 ];
 
 	 case  21 

 	 % ALG. DEG.:   21
 	 % PTS CARD.:   87
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw_bar=[
 	 2.98936235314982479138734561274759e-01 2.98936235314982479138734561274759e-01 4.02127529370035041722530877450481e-01 2.14511219291323440572227809752803e-02
 	 2.98936235314982479138734561274759e-01 4.02127529370035041722530877450481e-01 2.98936235314982479138734561274759e-01 2.14511219291323440572227809752803e-02
 	 4.02127529370035041722530877450481e-01 2.98936235314982479138734561274759e-01 2.98936235314982479138734561274759e-01 2.14511219291323440572227809752803e-02
 	 4.97007875468685578201899488703930e-01 4.97007875468685578201899488703930e-01 5.98424906262884359620102259214036e-03 4.43782969706587974989542288994926e-03
 	 4.97007875468685578201899488703930e-01 5.98424906262884359620102259214036e-03 4.97007875468685578201899488703930e-01 4.43782969706587974989542288994926e-03
 	 5.98424906262884359620102259214036e-03 4.97007875468685578201899488703930e-01 4.97007875468685578201899488703930e-01 4.43782969706587974989542288994926e-03
 	 4.03617586546385076484710907607223e-01 4.03617586546385076484710907607223e-01 1.92764826907229847030578184785554e-01 2.30007046532838682617594372459280e-02
 	 4.03617586546385076484710907607223e-01 1.92764826907229847030578184785554e-01 4.03617586546385076484710907607223e-01 2.30007046532838682617594372459280e-02
 	 1.92764826907229847030578184785554e-01 4.03617586546385076484710907607223e-01 4.03617586546385076484710907607223e-01 2.30007046532838682617594372459280e-02
 	 1.18988577622719290949326875761471e-01 1.18988577622719290949326875761471e-01 7.62022844754561390345770632848144e-01 1.36560324522301997085538260989779e-02
 	 1.18988577622719290949326875761471e-01 7.62022844754561390345770632848144e-01 1.18988577622719290949326875761471e-01 1.36560324522301997085538260989779e-02
 	 7.62022844754561390345770632848144e-01 1.18988577622719290949326875761471e-01 1.18988577622719290949326875761471e-01 1.36560324522301997085538260989779e-02
 	 1.90288718091278424848766803734179e-01 1.90288718091278424848766803734179e-01 6.19422563817443094791315161273815e-01 1.94552418607507153491820162116710e-02
 	 1.90288718091278424848766803734179e-01 6.19422563817443094791315161273815e-01 1.90288718091278424848766803734179e-01 1.94552418607507153491820162116710e-02
 	 6.19422563817443094791315161273815e-01 1.90288718091278424848766803734179e-01 1.90288718091278424848766803734179e-01 1.94552418607507153491820162116710e-02
 	 4.81597868653216576451114860901725e-01 4.81597868653216576451114860901725e-01 3.68042626935668470977702781965490e-02 1.22144101633843843446314281209197e-02
 	 4.81597868653216576451114860901725e-01 3.68042626935668470977702781965490e-02 4.81597868653216576451114860901725e-01 1.22144101633843843446314281209197e-02
 	 3.68042626935668470977702781965490e-02 4.81597868653216576451114860901725e-01 4.81597868653216576451114860901725e-01 1.22144101633843843446314281209197e-02
 	 4.49812791775362375013003202184336e-01 4.49812791775362375013003202184336e-01 1.00374416449275249973993595631327e-01 1.96144752278240228071659601027932e-02
 	 4.49812791775362375013003202184336e-01 1.00374416449275249973993595631327e-01 4.49812791775362375013003202184336e-01 1.96144752278240228071659601027932e-02
 	 1.00374416449275249973993595631327e-01 4.49812791775362375013003202184336e-01 4.49812791775362375013003202184336e-01 1.96144752278240228071659601027932e-02
 	 5.36275755461448552785519439112250e-02 5.36275755461448552785519439112250e-02 8.92744848907710331076259535620920e-01 7.15208510128365320540622107614581e-03
 	 5.36275755461448552785519439112250e-02 8.92744848907710331076259535620920e-01 5.36275755461448552785519439112250e-02 7.15208510128365320540622107614581e-03
 	 8.92744848907710331076259535620920e-01 5.36275755461448552785519439112250e-02 5.36275755461448552785519439112250e-02 7.15208510128365320540622107614581e-03
 	 1.07424564328282810821146853186292e-02 1.07424564328282810821146853186292e-02 9.78515087134343430896876725455513e-01 1.50869927237868932910769270705487e-03
 	 1.07424564328282810821146853186292e-02 9.78515087134343430896876725455513e-01 1.07424564328282810821146853186292e-02 1.50869927237868932910769270705487e-03
 	 9.78515087134343430896876725455513e-01 1.07424564328282810821146853186292e-02 1.07424564328282810821146853186292e-02 1.50869927237868932910769270705487e-03
 	 2.89189496078594676653494843776571e-01 2.05295559335161609260111958974448e-01 5.05514944586243686330817581620067e-01 1.74954161557631278356428339293416e-02
 	 2.89189496078594676653494843776571e-01 5.05514944586243686330817581620067e-01 2.05295559335161609260111958974448e-01 1.74954161557631278356428339293416e-02
 	 2.05295559335161609260111958974448e-01 2.89189496078594676653494843776571e-01 5.05514944586243686330817581620067e-01 1.74954161557631278356428339293416e-02
 	 2.05295559335161609260111958974448e-01 5.05514944586243686330817581620067e-01 2.89189496078594676653494843776571e-01 1.74954161557631278356428339293416e-02
 	 5.05514944586243686330817581620067e-01 2.89189496078594676653494843776571e-01 2.05295559335161609260111958974448e-01 1.74954161557631278356428339293416e-02
 	 5.05514944586243686330817581620067e-01 2.05295559335161609260111958974448e-01 2.89189496078594676653494843776571e-01 1.74954161557631278356428339293416e-02
 	 2.37873382597993981990569523077284e-01 6.93180903146811862314269347962181e-03 7.55194808370537873365435643790988e-01 4.20612028814972959550599895806045e-03
 	 2.37873382597993981990569523077284e-01 7.55194808370537873365435643790988e-01 6.93180903146811862314269347962181e-03 4.20612028814972959550599895806045e-03
 	 6.93180903146811862314269347962181e-03 2.37873382597993981990569523077284e-01 7.55194808370537873365435643790988e-01 4.20612028814972959550599895806045e-03
 	 6.93180903146811862314269347962181e-03 7.55194808370537873365435643790988e-01 2.37873382597993981990569523077284e-01 4.20612028814972959550599895806045e-03
 	 7.55194808370537873365435643790988e-01 2.37873382597993981990569523077284e-01 6.93180903146811862314269347962181e-03 4.20612028814972959550599895806045e-03
 	 7.55194808370537873365435643790988e-01 6.93180903146811862314269347962181e-03 2.37873382597993981990569523077284e-01 4.20612028814972959550599895806045e-03
 	 3.18865310794828216156560074523441e-01 1.23779400405492817638375413480389e-01 5.57355288799678882938337665109430e-01 1.84474848479328386308129239523623e-02
 	 3.18865310794828216156560074523441e-01 5.57355288799678882938337665109430e-01 1.23779400405492817638375413480389e-01 1.84474848479328386308129239523623e-02
 	 1.23779400405492817638375413480389e-01 3.18865310794828216156560074523441e-01 5.57355288799678882938337665109430e-01 1.84474848479328386308129239523623e-02
 	 1.23779400405492817638375413480389e-01 5.57355288799678882938337665109430e-01 3.18865310794828216156560074523441e-01 1.84474848479328386308129239523623e-02
 	 5.57355288799678882938337665109430e-01 3.18865310794828216156560074523441e-01 1.23779400405492817638375413480389e-01 1.84474848479328386308129239523623e-02
 	 5.57355288799678882938337665109430e-01 1.23779400405492817638375413480389e-01 3.18865310794828216156560074523441e-01 1.84474848479328386308129239523623e-02
 	 2.31873625370400959777583693721681e-01 3.89913626232203450183710913279356e-02 7.29135012006378646631787887599785e-01 1.04699041853248443756374541635523e-02
 	 2.31873625370400959777583693721681e-01 7.29135012006378646631787887599785e-01 3.89913626232203450183710913279356e-02 1.04699041853248443756374541635523e-02
 	 3.89913626232203450183710913279356e-02 2.31873625370400959777583693721681e-01 7.29135012006378646631787887599785e-01 1.04699041853248443756374541635523e-02
 	 3.89913626232203450183710913279356e-02 7.29135012006378646631787887599785e-01 2.31873625370400959777583693721681e-01 1.04699041853248443756374541635523e-02
 	 7.29135012006378646631787887599785e-01 2.31873625370400959777583693721681e-01 3.89913626232203450183710913279356e-02 1.04699041853248443756374541635523e-02
 	 7.29135012006378646631787887599785e-01 3.89913626232203450183710913279356e-02 2.31873625370400959777583693721681e-01 1.04699041853248443756374541635523e-02
 	 1.33167122941370286159923352897749e-01 9.53624752971060293815774855374912e-03 8.57296629528919162943623177852714e-01 4.48081312190147604962442429155089e-03
 	 1.33167122941370286159923352897749e-01 8.57296629528919162943623177852714e-01 9.53624752971060293815774855374912e-03 4.48081312190147604962442429155089e-03
 	 9.53624752971060293815774855374912e-03 1.33167122941370286159923352897749e-01 8.57296629528919162943623177852714e-01 4.48081312190147604962442429155089e-03
 	 9.53624752971060293815774855374912e-03 8.57296629528919162943623177852714e-01 1.33167122941370286159923352897749e-01 4.48081312190147604962442429155089e-03
 	 8.57296629528919162943623177852714e-01 1.33167122941370286159923352897749e-01 9.53624752971060293815774855374912e-03 4.48081312190147604962442429155089e-03
 	 8.57296629528919162943623177852714e-01 9.53624752971060293815774855374912e-03 1.33167122941370286159923352897749e-01 4.48081312190147604962442429155089e-03
 	 3.46807979809911015589563021421782e-01 5.30521917012168400806793044921505e-02 6.00139828488872040246349115477642e-01 1.45003059189710223342295591919537e-02
 	 3.46807979809911015589563021421782e-01 6.00139828488872040246349115477642e-01 5.30521917012168400806793044921505e-02 1.45003059189710223342295591919537e-02
 	 5.30521917012168400806793044921505e-02 3.46807979809911015589563021421782e-01 6.00139828488872040246349115477642e-01 1.45003059189710223342295591919537e-02
 	 5.30521917012168400806793044921505e-02 6.00139828488872040246349115477642e-01 3.46807979809911015589563021421782e-01 1.45003059189710223342295591919537e-02
 	 6.00139828488872040246349115477642e-01 3.46807979809911015589563021421782e-01 5.30521917012168400806793044921505e-02 1.45003059189710223342295591919537e-02
 	 6.00139828488872040246349115477642e-01 5.30521917012168400806793044921505e-02 3.46807979809911015589563021421782e-01 1.45003059189710223342295591919537e-02
 	 2.16599623189982493087768489203881e-01 1.00458020074114501296591583923146e-01 6.82942356735902977860064311244059e-01 1.59040367054279728475929545084000e-02
 	 2.16599623189982493087768489203881e-01 6.82942356735902977860064311244059e-01 1.00458020074114501296591583923146e-01 1.59040367054279728475929545084000e-02
 	 1.00458020074114501296591583923146e-01 2.16599623189982493087768489203881e-01 6.82942356735902977860064311244059e-01 1.59040367054279728475929545084000e-02
 	 1.00458020074114501296591583923146e-01 6.82942356735902977860064311244059e-01 2.16599623189982493087768489203881e-01 1.59040367054279728475929545084000e-02
 	 6.82942356735902977860064311244059e-01 2.16599623189982493087768489203881e-01 1.00458020074114501296591583923146e-01 1.59040367054279728475929545084000e-02
 	 6.82942356735902977860064311244059e-01 1.00458020074114501296591583923146e-01 2.16599623189982493087768489203881e-01 1.59040367054279728475929545084000e-02
 	 1.28829807962051540171088959141343e-01 4.94510655685405711712299137161608e-02 8.21719126469407812329848184162984e-01 9.81197182255041239207216108297871e-03
 	 1.28829807962051540171088959141343e-01 8.21719126469407812329848184162984e-01 4.94510655685405711712299137161608e-02 9.81197182255041239207216108297871e-03
 	 4.94510655685405711712299137161608e-02 1.28829807962051540171088959141343e-01 8.21719126469407812329848184162984e-01 9.81197182255041239207216108297871e-03
 	 4.94510655685405711712299137161608e-02 8.21719126469407812329848184162984e-01 1.28829807962051540171088959141343e-01 9.81197182255041239207216108297871e-03
 	 8.21719126469407812329848184162984e-01 1.28829807962051540171088959141343e-01 4.94510655685405711712299137161608e-02 9.81197182255041239207216108297871e-03
 	 8.21719126469407812329848184162984e-01 4.94510655685405711712299137161608e-02 1.28829807962051540171088959141343e-01 9.81197182255041239207216108297871e-03
 	 3.60953408018922172750819754583063e-01 1.02546358729245206536928591845026e-02 6.28791956108153304860763910255628e-01 6.83988485793430613102206194753307e-03
 	 3.60953408018922172750819754583063e-01 6.28791956108153304860763910255628e-01 1.02546358729245206536928591845026e-02 6.83988485793430613102206194753307e-03
 	 1.02546358729245206536928591845026e-02 3.60953408018922172750819754583063e-01 6.28791956108153304860763910255628e-01 6.83988485793430613102206194753307e-03
 	 1.02546358729245206536928591845026e-02 6.28791956108153304860763910255628e-01 3.60953408018922172750819754583063e-01 6.83988485793430613102206194753307e-03
 	 6.28791956108153304860763910255628e-01 3.60953408018922172750819754583063e-01 1.02546358729245206536928591845026e-02 6.83988485793430613102206194753307e-03
 	 6.28791956108153304860763910255628e-01 1.02546358729245206536928591845026e-02 3.60953408018922172750819754583063e-01 6.83988485793430613102206194753307e-03
 	 5.57195650723719473895734211055242e-02 1.03019036434239090460618371025703e-02 9.33978531284204160911599501559976e-01 3.26542858404408513697814164800093e-03
 	 5.57195650723719473895734211055242e-02 9.33978531284204160911599501559976e-01 1.03019036434239090460618371025703e-02 3.26542858404408513697814164800093e-03
 	 1.03019036434239090460618371025703e-02 5.57195650723719473895734211055242e-02 9.33978531284204160911599501559976e-01 3.26542858404408513697814164800093e-03
 	 1.03019036434239090460618371025703e-02 9.33978531284204160911599501559976e-01 5.57195650723719473895734211055242e-02 3.26542858404408513697814164800093e-03
 	 9.33978531284204160911599501559976e-01 5.57195650723719473895734211055242e-02 1.03019036434239090460618371025703e-02 3.26542858404408513697814164800093e-03
 	 9.33978531284204160911599501559976e-01 1.03019036434239090460618371025703e-02 5.57195650723719473895734211055242e-02 3.26542858404408513697814164800093e-03
 	 ];
 
 	 case  22 

 	 % ALG. DEG.:   22
 	 % PTS CARD.:   96
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 3.85184524627302127264272257889388e-01 3.85184524627302127264272257889388e-01 2.29630950745395745471455484221224e-01 1.34930838836106580663765086569583e-02
 	 3.85184524627302127264272257889388e-01 2.29630950745395745471455484221224e-01 3.85184524627302127264272257889388e-01 1.34930838836106580663765086569583e-02
 	 2.29630950745395745471455484221224e-01 3.85184524627302127264272257889388e-01 3.85184524627302127264272257889388e-01 1.34930838836106580663765086569583e-02
 	 4.57769411367672074408829985259217e-01 4.57769411367672074408829985259217e-01 8.44611772646558511823400294815656e-02 1.38613995242341872526914414720522e-02
 	 4.57769411367672074408829985259217e-01 8.44611772646558511823400294815656e-02 4.57769411367672074408829985259217e-01 1.38613995242341872526914414720522e-02
 	 8.44611772646558511823400294815656e-02 4.57769411367672074408829985259217e-01 4.57769411367672074408829985259217e-01 1.38613995242341872526914414720522e-02
 	 2.94558259029950031404609944729600e-01 2.94558259029950031404609944729600e-01 4.10883481940099937190780110540800e-01 2.10757639574521739300738687461489e-02
 	 2.94558259029950031404609944729600e-01 4.10883481940099937190780110540800e-01 2.94558259029950031404609944729600e-01 2.10757639574521739300738687461489e-02
 	 4.10883481940099937190780110540800e-01 2.94558259029950031404609944729600e-01 2.94558259029950031404609944729600e-01 2.10757639574521739300738687461489e-02
 	 1.88510523630283838292243103751389e-01 1.88510523630283838292243103751389e-01 6.22978952739432267904362561239395e-01 1.60212991251488870436681111186772e-02
 	 1.88510523630283838292243103751389e-01 6.22978952739432267904362561239395e-01 1.88510523630283838292243103751389e-01 1.60212991251488870436681111186772e-02
 	 6.22978952739432267904362561239395e-01 1.88510523630283838292243103751389e-01 1.88510523630283838292243103751389e-01 1.60212991251488870436681111186772e-02
 	 4.21981888793534931636486362549476e-01 4.21981888793534931636486362549476e-01 1.56036222412930136727027274901047e-01 1.88530925538412802433541060054267e-02
 	 4.21981888793534931636486362549476e-01 1.56036222412930136727027274901047e-01 4.21981888793534931636486362549476e-01 1.88530925538412802433541060054267e-02
 	 1.56036222412930136727027274901047e-01 4.21981888793534931636486362549476e-01 4.21981888793534931636486362549476e-01 1.88530925538412802433541060054267e-02
 	 4.96161178409708636394270797609352e-01 4.96161178409708636394270797609352e-01 7.67764318058272721145840478129685e-03 5.28933966598441659273666104468248e-03
 	 4.96161178409708636394270797609352e-01 7.67764318058272721145840478129685e-03 4.96161178409708636394270797609352e-01 5.28933966598441659273666104468248e-03
 	 7.67764318058272721145840478129685e-03 4.96161178409708636394270797609352e-01 4.96161178409708636394270797609352e-01 5.28933966598441659273666104468248e-03
 	 2.91084706708073584491280882957653e-02 2.91084706708073584491280882957653e-02 9.41783058658385296979531631222926e-01 3.56910916585637507172923399423325e-03
 	 2.91084706708073584491280882957653e-02 9.41783058658385296979531631222926e-01 2.91084706708073584491280882957653e-02 3.56910916585637507172923399423325e-03
 	 9.41783058658385296979531631222926e-01 2.91084706708073584491280882957653e-02 2.91084706708073584491280882957653e-02 3.56910916585637507172923399423325e-03
 	 1.15431538219204890549640651897789e-01 1.15431538219204890549640651897789e-01 7.69136923561590246656294311833335e-01 1.44157131281045982479360745287522e-02
 	 1.15431538219204890549640651897789e-01 7.69136923561590246656294311833335e-01 1.15431538219204890549640651897789e-01 1.44157131281045982479360745287522e-02
 	 7.69136923561590246656294311833335e-01 1.15431538219204890549640651897789e-01 1.15431538219204890549640651897789e-01 1.44157131281045982479360745287522e-02
 	 6.98421694674436210892309873088379e-02 7.87628222158237752126286324028115e-03 9.22281548310973975368654009798774e-01 2.59543847423127646903417975465800e-03
 	 6.98421694674436210892309873088379e-02 9.22281548310973975368654009798774e-01 7.87628222158237752126286324028115e-03 2.59543847423127646903417975465800e-03
 	 7.87628222158237752126286324028115e-03 6.98421694674436210892309873088379e-02 9.22281548310973975368654009798774e-01 2.59543847423127646903417975465800e-03
 	 7.87628222158237752126286324028115e-03 9.22281548310973975368654009798774e-01 6.98421694674436210892309873088379e-02 2.59543847423127646903417975465800e-03
 	 9.22281548310973975368654009798774e-01 6.98421694674436210892309873088379e-02 7.87628222158237752126286324028115e-03 2.59543847423127646903417975465800e-03
 	 9.22281548310973975368654009798774e-01 7.87628222158237752126286324028115e-03 6.98421694674436210892309873088379e-02 2.59543847423127646903417975465800e-03
 	 9.03988311664077337503897524584318e-02 4.47522843483358911953473580069840e-02 8.64848884485256430565414120792411e-01 7.51757781778837359115685856636446e-03
 	 9.03988311664077337503897524584318e-02 8.64848884485256430565414120792411e-01 4.47522843483358911953473580069840e-02 7.51757781778837359115685856636446e-03
 	 4.47522843483358911953473580069840e-02 9.03988311664077337503897524584318e-02 8.64848884485256430565414120792411e-01 7.51757781778837359115685856636446e-03
 	 4.47522843483358911953473580069840e-02 8.64848884485256430565414120792411e-01 9.03988311664077337503897524584318e-02 7.51757781778837359115685856636446e-03
 	 8.64848884485256430565414120792411e-01 9.03988311664077337503897524584318e-02 4.47522843483358911953473580069840e-02 7.51757781778837359115685856636446e-03
 	 8.64848884485256430565414120792411e-01 4.47522843483358911953473580069840e-02 9.03988311664077337503897524584318e-02 7.51757781778837359115685856636446e-03
 	 4.11341764020558720016396136998083e-01 3.82752347008638374448175056841137e-02 5.50383001278577421722104645596119e-01 1.11973134719627661487484360236522e-02
 	 4.11341764020558720016396136998083e-01 5.50383001278577421722104645596119e-01 3.82752347008638374448175056841137e-02 1.11973134719627661487484360236522e-02
 	 3.82752347008638374448175056841137e-02 4.11341764020558720016396136998083e-01 5.50383001278577421722104645596119e-01 1.11973134719627661487484360236522e-02
 	 3.82752347008638374448175056841137e-02 5.50383001278577421722104645596119e-01 4.11341764020558720016396136998083e-01 1.11973134719627661487484360236522e-02
 	 5.50383001278577421722104645596119e-01 4.11341764020558720016396136998083e-01 3.82752347008638374448175056841137e-02 1.11973134719627661487484360236522e-02
 	 5.50383001278577421722104645596119e-01 3.82752347008638374448175056841137e-02 4.11341764020558720016396136998083e-01 1.11973134719627661487484360236522e-02
 	 3.32106105007446361643275167807587e-01 1.02747075986931432622917270691687e-01 5.65146819005622247367170984944096e-01 1.77190934895102118751264441698368e-02
 	 3.32106105007446361643275167807587e-01 5.65146819005622247367170984944096e-01 1.02747075986931432622917270691687e-01 1.77190934895102118751264441698368e-02
 	 1.02747075986931432622917270691687e-01 3.32106105007446361643275167807587e-01 5.65146819005622247367170984944096e-01 1.77190934895102118751264441698368e-02
 	 1.02747075986931432622917270691687e-01 5.65146819005622247367170984944096e-01 3.32106105007446361643275167807587e-01 1.77190934895102118751264441698368e-02
 	 5.65146819005622247367170984944096e-01 3.32106105007446361643275167807587e-01 1.02747075986931432622917270691687e-01 1.77190934895102118751264441698368e-02
 	 5.65146819005622247367170984944096e-01 1.02747075986931432622917270691687e-01 3.32106105007446361643275167807587e-01 1.77190934895102118751264441698368e-02
 	 3.62576280432467257242024061270058e-01 7.40024123471075441493827185013288e-03 6.30023478332822017833336758485530e-01 4.90426039755696274030638548424577e-03
 	 3.62576280432467257242024061270058e-01 6.30023478332822017833336758485530e-01 7.40024123471075441493827185013288e-03 4.90426039755696274030638548424577e-03
 	 7.40024123471075441493827185013288e-03 3.62576280432467257242024061270058e-01 6.30023478332822017833336758485530e-01 4.90426039755696274030638548424577e-03
 	 7.40024123471075441493827185013288e-03 6.30023478332822017833336758485530e-01 3.62576280432467257242024061270058e-01 4.90426039755696274030638548424577e-03
 	 6.30023478332822017833336758485530e-01 3.62576280432467257242024061270058e-01 7.40024123471075441493827185013288e-03 4.90426039755696274030638548424577e-03
 	 6.30023478332822017833336758485530e-01 7.40024123471075441493827185013288e-03 3.62576280432467257242024061270058e-01 4.90426039755696274030638548424577e-03
 	 2.90066824116668786626149767471361e-01 1.91081297966720159431375236636086e-01 5.18851877916611026186899380263640e-01 2.17064195555089489708677774615353e-02
 	 2.90066824116668786626149767471361e-01 5.18851877916611026186899380263640e-01 1.91081297966720159431375236636086e-01 2.17064195555089489708677774615353e-02
 	 1.91081297966720159431375236636086e-01 2.90066824116668786626149767471361e-01 5.18851877916611026186899380263640e-01 2.17064195555089489708677774615353e-02
 	 1.91081297966720159431375236636086e-01 5.18851877916611026186899380263640e-01 2.90066824116668786626149767471361e-01 2.17064195555089489708677774615353e-02
 	 5.18851877916611026186899380263640e-01 2.90066824116668786626149767471361e-01 1.91081297966720159431375236636086e-01 2.17064195555089489708677774615353e-02
 	 5.18851877916611026186899380263640e-01 1.91081297966720159431375236636086e-01 2.90066824116668786626149767471361e-01 2.17064195555089489708677774615353e-02
 	 2.87931802824171800825325817640987e-01 4.39916453934558610017191426777572e-02 6.68076551782372352050742847495712e-01 1.16622228673429976369968485983009e-02
 	 2.87931802824171800825325817640987e-01 6.68076551782372352050742847495712e-01 4.39916453934558610017191426777572e-02 1.16622228673429976369968485983009e-02
 	 4.39916453934558610017191426777572e-02 2.87931802824171800825325817640987e-01 6.68076551782372352050742847495712e-01 1.16622228673429976369968485983009e-02
 	 4.39916453934558610017191426777572e-02 6.68076551782372352050742847495712e-01 2.87931802824171800825325817640987e-01 1.16622228673429976369968485983009e-02
 	 6.68076551782372352050742847495712e-01 2.87931802824171800825325817640987e-01 4.39916453934558610017191426777572e-02 1.16622228673429976369968485983009e-02
 	 6.68076551782372352050742847495712e-01 4.39916453934558610017191426777572e-02 2.87931802824171800825325817640987e-01 1.16622228673429976369968485983009e-02
 	 2.16786933364941147850402103358647e-01 1.08689941862672029282421704010630e-01 6.74523124772386850622751808259636e-01 1.57101626225703110140141660622248e-02
 	 2.16786933364941147850402103358647e-01 6.74523124772386850622751808259636e-01 1.08689941862672029282421704010630e-01 1.57101626225703110140141660622248e-02
 	 1.08689941862672029282421704010630e-01 2.16786933364941147850402103358647e-01 6.74523124772386850622751808259636e-01 1.57101626225703110140141660622248e-02
 	 1.08689941862672029282421704010630e-01 6.74523124772386850622751808259636e-01 2.16786933364941147850402103358647e-01 1.57101626225703110140141660622248e-02
 	 6.74523124772386850622751808259636e-01 2.16786933364941147850402103358647e-01 1.08689941862672029282421704010630e-01 1.57101626225703110140141660622248e-02
 	 6.74523124772386850622751808259636e-01 1.08689941862672029282421704010630e-01 2.16786933364941147850402103358647e-01 1.57101626225703110140141660622248e-02
 	 1.45873719873525181656148674846918e-01 9.14471137496405787892239658276594e-03 8.44981568751510758730205452593509e-01 4.10668707157555400166781822690609e-03
 	 1.45873719873525181656148674846918e-01 8.44981568751510758730205452593509e-01 9.14471137496405787892239658276594e-03 4.10668707157555400166781822690609e-03
 	 9.14471137496405787892239658276594e-03 1.45873719873525181656148674846918e-01 8.44981568751510758730205452593509e-01 4.10668707157555400166781822690609e-03
 	 9.14471137496405787892239658276594e-03 8.44981568751510758730205452593509e-01 1.45873719873525181656148674846918e-01 4.10668707157555400166781822690609e-03
 	 8.44981568751510758730205452593509e-01 1.45873719873525181656148674846918e-01 9.14471137496405787892239658276594e-03 4.10668707157555400166781822690609e-03
 	 8.44981568751510758730205452593509e-01 9.14471137496405787892239658276594e-03 1.45873719873525181656148674846918e-01 4.10668707157555400166781822690609e-03
 	 1.76297434824500054428852990895393e-01 4.82549241146414051306656745055079e-02 7.75447641060858505746011815062957e-01 1.05635849677468939000757330859415e-02
 	 1.76297434824500054428852990895393e-01 7.75447641060858505746011815062957e-01 4.82549241146414051306656745055079e-02 1.05635849677468939000757330859415e-02
 	 4.82549241146414051306656745055079e-02 1.76297434824500054428852990895393e-01 7.75447641060858505746011815062957e-01 1.05635849677468939000757330859415e-02
 	 4.82549241146414051306656745055079e-02 7.75447641060858505746011815062957e-01 1.76297434824500054428852990895393e-01 1.05635849677468939000757330859415e-02
 	 7.75447641060858505746011815062957e-01 1.76297434824500054428852990895393e-01 4.82549241146414051306656745055079e-02 1.05635849677468939000757330859415e-02
 	 7.75447641060858505746011815062957e-01 4.82549241146414051306656745055079e-02 1.76297434824500054428852990895393e-01 1.05635849677468939000757330859415e-02
 	 2.43990646039493053187641180556966e-01 9.16390924818523237849188234349640e-03 7.46845444712321726576931268937187e-01 5.05407689758459888890174127595856e-03
 	 2.43990646039493053187641180556966e-01 7.46845444712321726576931268937187e-01 9.16390924818523237849188234349640e-03 5.05407689758459888890174127595856e-03
 	 9.16390924818523237849188234349640e-03 2.43990646039493053187641180556966e-01 7.46845444712321726576931268937187e-01 5.05407689758459888890174127595856e-03
 	 9.16390924818523237849188234349640e-03 7.46845444712321726576931268937187e-01 2.43990646039493053187641180556966e-01 5.05407689758459888890174127595856e-03
 	 7.46845444712321726576931268937187e-01 2.43990646039493053187641180556966e-01 9.16390924818523237849188234349640e-03 5.05407689758459888890174127595856e-03
 	 7.46845444712321726576931268937187e-01 9.16390924818523237849188234349640e-03 2.43990646039493053187641180556966e-01 5.05407689758459888890174127595856e-03
 	 1.79343210529389861240812109599574e-02 1.79846498894837506649091452004541e-03 9.80267213958112559879509717575274e-01 6.40428531171425598211843777107788e-04
 	 1.79343210529389861240812109599574e-02 9.80267213958112559879509717575274e-01 1.79846498894837506649091452004541e-03 6.40428531171425598211843777107788e-04
 	 1.79846498894837506649091452004541e-03 1.79343210529389861240812109599574e-02 9.80267213958112559879509717575274e-01 6.40428531171425598211843777107788e-04
 	 1.79846498894837506649091452004541e-03 9.80267213958112559879509717575274e-01 1.79343210529389861240812109599574e-02 6.40428531171425598211843777107788e-04
 	 9.80267213958112559879509717575274e-01 1.79343210529389861240812109599574e-02 1.79846498894837506649091452004541e-03 6.40428531171425598211843777107788e-04
 	 9.80267213958112559879509717575274e-01 1.79846498894837506649091452004541e-03 1.79343210529389861240812109599574e-02 6.40428531171425598211843777107788e-04
 	 ];
 
 	 case  23 

 	 % ALG. DEG.:   23
 	 % PTS CARD.:  103
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.1e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.52530603230362166167211057654640e-02
 	 3.90072687570319903693771834696236e-02 3.90072687570319903693771834696236e-02 9.21985462485936047016821248689666e-01 3.91574025903293661265980318830771e-03
 	 3.90072687570319903693771834696236e-02 9.21985462485936047016821248689666e-01 3.90072687570319903693771834696236e-02 3.91574025903293661265980318830771e-03
 	 9.21985462485936047016821248689666e-01 3.90072687570319903693771834696236e-02 3.90072687570319903693771834696236e-02 3.91574025903293661265980318830771e-03
 	 4.80328877337308501882517930425820e-01 4.80328877337308501882517930425820e-01 3.93422453253829962349641391483601e-02 1.13978892678007637934145535041353e-02
 	 4.80328877337308501882517930425820e-01 3.93422453253829962349641391483601e-02 4.80328877337308501882517930425820e-01 1.13978892678007637934145535041353e-02
 	 3.93422453253829962349641391483601e-02 4.80328877337308501882517930425820e-01 4.80328877337308501882517930425820e-01 1.13978892678007637934145535041353e-02
 	 8.68410482076330536571617813024204e-02 8.68410482076330536571617813024204e-02 8.26317903584733892685676437395159e-01 8.95991702551354740613476224098122e-03
 	 8.68410482076330536571617813024204e-02 8.26317903584733892685676437395159e-01 8.68410482076330536571617813024204e-02 8.95991702551354740613476224098122e-03
 	 8.26317903584733892685676437395159e-01 8.68410482076330536571617813024204e-02 8.68410482076330536571617813024204e-02 8.95991702551354740613476224098122e-03
 	 3.94323506011541535798414770397358e-01 3.94323506011541535798414770397358e-01 2.11352987976916928403170459205285e-01 2.36746084631280287458032773884042e-02
 	 3.94323506011541535798414770397358e-01 2.11352987976916928403170459205285e-01 3.94323506011541535798414770397358e-01 2.36746084631280287458032773884042e-02
 	 2.11352987976916928403170459205285e-01 3.94323506011541535798414770397358e-01 3.94323506011541535798414770397358e-01 2.36746084631280287458032773884042e-02
 	 2.66251317877247206666879719705321e-01 2.66251317877247206666879719705321e-01 4.67497364245505586666240560589358e-01 2.38078628874997706710292533216489e-02
 	 2.66251317877247206666879719705321e-01 4.67497364245505586666240560589358e-01 2.66251317877247206666879719705321e-01 2.38078628874997706710292533216489e-02
 	 4.67497364245505586666240560589358e-01 2.66251317877247206666879719705321e-01 2.66251317877247206666879719705321e-01 2.38078628874997706710292533216489e-02
 	 1.37129387311647477076803625095636e-01 1.37129387311647477076803625095636e-01 7.25741225376705045846392749808729e-01 1.45594493927417509282484786581335e-02
 	 1.37129387311647477076803625095636e-01 7.25741225376705045846392749808729e-01 1.37129387311647477076803625095636e-01 1.45594493927417509282484786581335e-02
 	 7.25741225376705045846392749808729e-01 1.37129387311647477076803625095636e-01 1.37129387311647477076803625095636e-01 1.45594493927417509282484786581335e-02
 	 4.98959431209586301569913757703034e-01 4.98959431209586301569913757703034e-01 2.08113758082739686017248459393159e-03 2.40754460418141080779719231941272e-03
 	 4.98959431209586301569913757703034e-01 2.08113758082739686017248459393159e-03 4.98959431209586301569913757703034e-01 2.40754460418141080779719231941272e-03
 	 2.08113758082739686017248459393159e-03 4.98959431209586301569913757703034e-01 4.98959431209586301569913757703034e-01 2.40754460418141080779719231941272e-03
 	 4.44692442127727516343327351933112e-01 4.44692442127727516343327351933112e-01 1.10615115744544967313345296133775e-01 1.89519506693388919971177131174045e-02
 	 4.44692442127727516343327351933112e-01 1.10615115744544967313345296133775e-01 4.44692442127727516343327351933112e-01 1.89519506693388919971177131174045e-02
 	 1.10615115744544967313345296133775e-01 4.44692442127727516343327351933112e-01 4.44692442127727516343327351933112e-01 1.89519506693388919971177131174045e-02
 	 1.98749806396536110586481527207070e-01 1.98749806396536110586481527207070e-01 6.02500387206927778827036945585860e-01 1.99352778801050317669663058950391e-02
 	 1.98749806396536110586481527207070e-01 6.02500387206927778827036945585860e-01 1.98749806396536110586481527207070e-01 1.99352778801050317669663058950391e-02
 	 6.02500387206927778827036945585860e-01 1.98749806396536110586481527207070e-01 1.98749806396536110586481527207070e-01 1.99352778801050317669663058950391e-02
 	 9.01644020559819528437550673061196e-03 9.01644020559819528437550673061196e-03 9.81967119588803560858991659188177e-01 1.06536123282931541843276956882391e-03
 	 9.01644020559819528437550673061196e-03 9.81967119588803560858991659188177e-01 9.01644020559819528437550673061196e-03 1.06536123282931541843276956882391e-03
 	 9.81967119588803560858991659188177e-01 9.01644020559819528437550673061196e-03 9.01644020559819528437550673061196e-03 1.06536123282931541843276956882391e-03
 	 1.59503798924757217436720679870632e-01 2.38702536543536174284962925185027e-02 8.16625947420889231054275114729535e-01 2.52816605538226440649807180705011e-03
 	 1.59503798924757217436720679870632e-01 8.16625947420889231054275114729535e-01 2.38702536543536174284962925185027e-02 2.52816605538226440649807180705011e-03
 	 2.38702536543536174284962925185027e-02 1.59503798924757217436720679870632e-01 8.16625947420889231054275114729535e-01 2.52816605538226440649807180705011e-03
 	 2.38702536543536174284962925185027e-02 8.16625947420889231054275114729535e-01 1.59503798924757217436720679870632e-01 2.52816605538226440649807180705011e-03
 	 8.16625947420889231054275114729535e-01 1.59503798924757217436720679870632e-01 2.38702536543536174284962925185027e-02 2.52816605538226440649807180705011e-03
 	 8.16625947420889231054275114729535e-01 2.38702536543536174284962925185027e-02 1.59503798924757217436720679870632e-01 2.52816605538226440649807180705011e-03
 	 1.14101360322364536736827744789480e-01 5.18982176084453739051127740822267e-03 8.80708817916791009139387824689038e-01 2.22501972972451557766793150960893e-03
 	 1.14101360322364536736827744789480e-01 8.80708817916791009139387824689038e-01 5.18982176084453739051127740822267e-03 2.22501972972451557766793150960893e-03
 	 5.18982176084453739051127740822267e-03 1.14101360322364536736827744789480e-01 8.80708817916791009139387824689038e-01 2.22501972972451557766793150960893e-03
 	 5.18982176084453739051127740822267e-03 8.80708817916791009139387824689038e-01 1.14101360322364536736827744789480e-01 2.22501972972451557766793150960893e-03
 	 8.80708817916791009139387824689038e-01 1.14101360322364536736827744789480e-01 5.18982176084453739051127740822267e-03 2.22501972972451557766793150960893e-03
 	 8.80708817916791009139387824689038e-01 5.18982176084453739051127740822267e-03 1.14101360322364536736827744789480e-01 2.22501972972451557766793150960893e-03
 	 9.55398781717348988262727971232380e-02 3.27410291887064164306764268985717e-02 8.71719092639558601476323929091450e-01 5.32803043119478656614029787874642e-03
 	 9.55398781717348988262727971232380e-02 8.71719092639558601476323929091450e-01 3.27410291887064164306764268985717e-02 5.32803043119478656614029787874642e-03
 	 3.27410291887064164306764268985717e-02 9.55398781717348988262727971232380e-02 8.71719092639558601476323929091450e-01 5.32803043119478656614029787874642e-03
 	 3.27410291887064164306764268985717e-02 8.71719092639558601476323929091450e-01 9.55398781717348988262727971232380e-02 5.32803043119478656614029787874642e-03
 	 8.71719092639558601476323929091450e-01 9.55398781717348988262727971232380e-02 3.27410291887064164306764268985717e-02 5.32803043119478656614029787874642e-03
 	 8.71719092639558601476323929091450e-01 3.27410291887064164306764268985717e-02 9.55398781717348988262727971232380e-02 5.32803043119478656614029787874642e-03
 	 3.11162268051701940141384739035857e-01 2.44759985596638019594850632643102e-03 6.86390132092331683999475444579730e-01 2.28110367625583565498459392983932e-03
 	 3.11162268051701940141384739035857e-01 6.86390132092331683999475444579730e-01 2.44759985596638019594850632643102e-03 2.28110367625583565498459392983932e-03
 	 2.44759985596638019594850632643102e-03 3.11162268051701940141384739035857e-01 6.86390132092331683999475444579730e-01 2.28110367625583565498459392983932e-03
 	 2.44759985596638019594850632643102e-03 6.86390132092331683999475444579730e-01 3.11162268051701940141384739035857e-01 2.28110367625583565498459392983932e-03
 	 6.86390132092331683999475444579730e-01 3.11162268051701940141384739035857e-01 2.44759985596638019594850632643102e-03 2.28110367625583565498459392983932e-03
 	 6.86390132092331683999475444579730e-01 2.44759985596638019594850632643102e-03 3.11162268051701940141384739035857e-01 2.28110367625583565498459392983932e-03
 	 2.05617232058052074039622425516427e-01 8.72528958530853666897275644487308e-03 7.85657478356639460415067333087791e-01 4.11475034441609321955723999053589e-03
 	 2.05617232058052074039622425516427e-01 7.85657478356639460415067333087791e-01 8.72528958530853666897275644487308e-03 4.11475034441609321955723999053589e-03
 	 8.72528958530853666897275644487308e-03 2.05617232058052074039622425516427e-01 7.85657478356639460415067333087791e-01 4.11475034441609321955723999053589e-03
 	 8.72528958530853666897275644487308e-03 7.85657478356639460415067333087791e-01 2.05617232058052074039622425516427e-01 4.11475034441609321955723999053589e-03
 	 7.85657478356639460415067333087791e-01 2.05617232058052074039622425516427e-01 8.72528958530853666897275644487308e-03 4.11475034441609321955723999053589e-03
 	 7.85657478356639460415067333087791e-01 8.72528958530853666897275644487308e-03 2.05617232058052074039622425516427e-01 4.11475034441609321955723999053589e-03
 	 4.72616294497252981132717764012341e-02 7.16253991024448470603669392176016e-03 9.45575830640030146057029014627915e-01 1.95259132789072698856147614066003e-03
 	 4.72616294497252981132717764012341e-02 9.45575830640030146057029014627915e-01 7.16253991024448470603669392176016e-03 1.95259132789072698856147614066003e-03
 	 7.16253991024448470603669392176016e-03 4.72616294497252981132717764012341e-02 9.45575830640030146057029014627915e-01 1.95259132789072698856147614066003e-03
 	 7.16253991024448470603669392176016e-03 9.45575830640030146057029014627915e-01 4.72616294497252981132717764012341e-02 1.95259132789072698856147614066003e-03
 	 9.45575830640030146057029014627915e-01 4.72616294497252981132717764012341e-02 7.16253991024448470603669392176016e-03 1.95259132789072698856147614066003e-03
 	 9.45575830640030146057029014627915e-01 7.16253991024448470603669392176016e-03 4.72616294497252981132717764012341e-02 1.95259132789072698856147614066003e-03
 	 3.58509593569625084619190147350309e-01 6.85269541872130100168547528483032e-02 5.72963452243161919241742907615844e-01 1.49811133931991736362165923424072e-02
 	 3.58509593569625084619190147350309e-01 5.72963452243161919241742907615844e-01 6.85269541872130100168547528483032e-02 1.49811133931991736362165923424072e-02
 	 6.85269541872130100168547528483032e-02 3.58509593569625084619190147350309e-01 5.72963452243161919241742907615844e-01 1.49811133931991736362165923424072e-02
 	 6.85269541872130100168547528483032e-02 5.72963452243161919241742907615844e-01 3.58509593569625084619190147350309e-01 1.49811133931991736362165923424072e-02
 	 5.72963452243161919241742907615844e-01 3.58509593569625084619190147350309e-01 6.85269541872130100168547528483032e-02 1.49811133931991736362165923424072e-02
 	 5.72963452243161919241742907615844e-01 6.85269541872130100168547528483032e-02 3.58509593569625084619190147350309e-01 1.49811133931991736362165923424072e-02
 	 2.40482772035012670741593865386676e-01 1.01728329327284261474062532215612e-01 6.57788898637703067784343602397712e-01 1.61212416370171592039373109628286e-02
 	 2.40482772035012670741593865386676e-01 6.57788898637703067784343602397712e-01 1.01728329327284261474062532215612e-01 1.61212416370171592039373109628286e-02
 	 1.01728329327284261474062532215612e-01 2.40482772035012670741593865386676e-01 6.57788898637703067784343602397712e-01 1.61212416370171592039373109628286e-02
 	 1.01728329327284261474062532215612e-01 6.57788898637703067784343602397712e-01 2.40482772035012670741593865386676e-01 1.61212416370171592039373109628286e-02
 	 6.57788898637703067784343602397712e-01 2.40482772035012670741593865386676e-01 1.01728329327284261474062532215612e-01 1.61212416370171592039373109628286e-02
 	 6.57788898637703067784343602397712e-01 1.01728329327284261474062532215612e-01 2.40482772035012670741593865386676e-01 1.61212416370171592039373109628286e-02
 	 1.72932303129223974291761578570004e-01 5.83515752375154614361996152638312e-02 7.68716121633260529577569286630023e-01 1.04702564931300687312010211371671e-02
 	 1.72932303129223974291761578570004e-01 7.68716121633260529577569286630023e-01 5.83515752375154614361996152638312e-02 1.04702564931300687312010211371671e-02
 	 5.83515752375154614361996152638312e-02 1.72932303129223974291761578570004e-01 7.68716121633260529577569286630023e-01 1.04702564931300687312010211371671e-02
 	 5.83515752375154614361996152638312e-02 7.68716121633260529577569286630023e-01 1.72932303129223974291761578570004e-01 1.04702564931300687312010211371671e-02
 	 7.68716121633260529577569286630023e-01 1.72932303129223974291761578570004e-01 5.83515752375154614361996152638312e-02 1.04702564931300687312010211371671e-02
 	 7.68716121633260529577569286630023e-01 5.83515752375154614361996152638312e-02 1.72932303129223974291761578570004e-01 1.04702564931300687312010211371671e-02
 	 3.16304307653838101543897209921852e-01 1.54830155405516284305988961023104e-01 5.28865536940645641905689444683958e-01 2.08443958589688178861809575437292e-02
 	 3.16304307653838101543897209921852e-01 5.28865536940645641905689444683958e-01 1.54830155405516284305988961023104e-01 2.08443958589688178861809575437292e-02
 	 1.54830155405516284305988961023104e-01 3.16304307653838101543897209921852e-01 5.28865536940645641905689444683958e-01 2.08443958589688178861809575437292e-02
 	 1.54830155405516284305988961023104e-01 5.28865536940645641905689444683958e-01 3.16304307653838101543897209921852e-01 2.08443958589688178861809575437292e-02
 	 5.28865536940645641905689444683958e-01 3.16304307653838101543897209921852e-01 1.54830155405516284305988961023104e-01 2.08443958589688178861809575437292e-02
 	 5.28865536940645641905689444683958e-01 1.54830155405516284305988961023104e-01 3.16304307653838101543897209921852e-01 2.08443958589688178861809575437292e-02
 	 3.97758576803007635191988811129704e-01 1.47589697299451757389610051518503e-02 5.87482453467047194273220611648867e-01 7.09777883452182654228090896708636e-03
 	 3.97758576803007635191988811129704e-01 5.87482453467047194273220611648867e-01 1.47589697299451757389610051518503e-02 7.09777883452182654228090896708636e-03
 	 1.47589697299451757389610051518503e-02 3.97758576803007635191988811129704e-01 5.87482453467047194273220611648867e-01 7.09777883452182654228090896708636e-03
 	 1.47589697299451757389610051518503e-02 5.87482453467047194273220611648867e-01 3.97758576803007635191988811129704e-01 7.09777883452182654228090896708636e-03
 	 5.87482453467047194273220611648867e-01 3.97758576803007635191988811129704e-01 1.47589697299451757389610051518503e-02 7.09777883452182654228090896708636e-03
 	 5.87482453467047194273220611648867e-01 1.47589697299451757389610051518503e-02 3.97758576803007635191988811129704e-01 7.09777883452182654228090896708636e-03
 	 2.78794169814102266169442145837820e-01 3.29937081925328057341317844475270e-02 6.88212121993364900340850454085739e-01 1.01755746567070409075439485491188e-02
 	 2.78794169814102266169442145837820e-01 6.88212121993364900340850454085739e-01 3.29937081925328057341317844475270e-02 1.01755746567070409075439485491188e-02
 	 3.29937081925328057341317844475270e-02 2.78794169814102266169442145837820e-01 6.88212121993364900340850454085739e-01 1.01755746567070409075439485491188e-02
 	 3.29937081925328057341317844475270e-02 6.88212121993364900340850454085739e-01 2.78794169814102266169442145837820e-01 1.01755746567070409075439485491188e-02
 	 6.88212121993364900340850454085739e-01 2.78794169814102266169442145837820e-01 3.29937081925328057341317844475270e-02 1.01755746567070409075439485491188e-02
 	 6.88212121993364900340850454085739e-01 3.29937081925328057341317844475270e-02 2.78794169814102266169442145837820e-01 1.01755746567070409075439485491188e-02
 	 ];
 
 	 case  24 

 	 % ALG. DEG.:   24
 	 % PTS CARD.:  112
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 9.9e-16  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.25456898456003159564309257234527e-02
 	 4.18890974910602731373643337065005e-01 4.18890974910602731373643337065005e-01 1.62218050178794537252713325869991e-01 1.31105327018852368253787332719185e-02
 	 4.18890974910602731373643337065005e-01 1.62218050178794537252713325869991e-01 4.18890974910602731373643337065005e-01 1.31105327018852368253787332719185e-02
 	 1.62218050178794537252713325869991e-01 4.18890974910602731373643337065005e-01 4.18890974910602731373643337065005e-01 1.31105327018852368253787332719185e-02
 	 1.62360633716926272551717147507588e-01 1.62360633716926272551717147507588e-01 6.75278732566147454896565704984823e-01 1.03790160564001913978682267725162e-02
 	 1.62360633716926272551717147507588e-01 6.75278732566147454896565704984823e-01 1.62360633716926272551717147507588e-01 1.03790160564001913978682267725162e-02
 	 6.75278732566147454896565704984823e-01 1.62360633716926272551717147507588e-01 1.62360633716926272551717147507588e-01 1.03790160564001913978682267725162e-02
 	 4.09856290011169493991971535251650e-02 4.09856290011169493991971535251650e-02 9.18028741997766073446030077320756e-01 3.83369973092918250520688694393812e-03
 	 4.09856290011169493991971535251650e-02 9.18028741997766073446030077320756e-01 4.09856290011169493991971535251650e-02 3.83369973092918250520688694393812e-03
 	 9.18028741997766073446030077320756e-01 4.09856290011169493991971535251650e-02 4.09856290011169493991971535251650e-02 3.83369973092918250520688694393812e-03
 	 6.73127088788825697629469857474760e-03 6.73127088788825697629469857474760e-03 9.86537458224223451352941083314363e-01 6.17254505496643048056970570769408e-04
 	 6.73127088788825697629469857474760e-03 9.86537458224223451352941083314363e-01 6.73127088788825697629469857474760e-03 6.17254505496643048056970570769408e-04
 	 9.86537458224223451352941083314363e-01 6.73127088788825697629469857474760e-03 6.73127088788825697629469857474760e-03 6.17254505496643048056970570769408e-04
 	 4.96255277675735129161438408118556e-01 4.96255277675735129161438408118556e-01 7.48944464852974167712318376288749e-03 4.34324672217069676638523390010960e-03
 	 4.96255277675735129161438408118556e-01 7.48944464852974167712318376288749e-03 4.96255277675735129161438408118556e-01 4.34324672217069676638523390010960e-03
 	 7.48944464852974167712318376288749e-03 4.96255277675735129161438408118556e-01 4.96255277675735129161438408118556e-01 4.34324672217069676638523390010960e-03
 	 2.64231315438272496010085887974128e-01 2.64231315438272496010085887974128e-01 4.71537369123455007979828224051744e-01 2.05200086715098400924617294549535e-02
 	 2.64231315438272496010085887974128e-01 4.71537369123455007979828224051744e-01 2.64231315438272496010085887974128e-01 2.05200086715098400924617294549535e-02
 	 4.71537369123455007979828224051744e-01 2.64231315438272496010085887974128e-01 2.64231315438272496010085887974128e-01 2.05200086715098400924617294549535e-02
 	 4.80612561792503223401240575185511e-01 4.80612561792503223401240575185511e-01 3.87748764149935531975188496289775e-02 1.03524947708526007805751589785359e-02
 	 4.80612561792503223401240575185511e-01 3.87748764149935531975188496289775e-02 4.80612561792503223401240575185511e-01 1.03524947708526007805751589785359e-02
 	 3.87748764149935531975188496289775e-02 4.80612561792503223401240575185511e-01 4.80612561792503223401240575185511e-01 1.03524947708526007805751589785359e-02
 	 9.63284955992150526693507117670379e-02 9.63284955992150526693507117670379e-02 8.07343008801569839150147345208097e-01 1.00273930673889059839165582843634e-02
 	 9.63284955992150526693507117670379e-02 8.07343008801569839150147345208097e-01 9.63284955992150526693507117670379e-02 1.00273930673889059839165582843634e-02
 	 8.07343008801569839150147345208097e-01 9.63284955992150526693507117670379e-02 9.63284955992150526693507117670379e-02 1.00273930673889059839165582843634e-02
 	 3.75352926702086253651913239082205e-01 3.75352926702086253651913239082205e-01 2.49294146595827492696173521835590e-01 1.89945865173526545754967287393811e-02
 	 3.75352926702086253651913239082205e-01 2.49294146595827492696173521835590e-01 3.75352926702086253651913239082205e-01 1.89945865173526545754967287393811e-02
 	 2.49294146595827492696173521835590e-01 3.75352926702086253651913239082205e-01 3.75352926702086253651913239082205e-01 1.89945865173526545754967287393811e-02
 	 2.41479760073594007518948956203531e-01 1.70367282462443730972623257002851e-01 5.88152957463962233752852171164704e-01 1.41450458064848426376070023025022e-02
 	 2.41479760073594007518948956203531e-01 5.88152957463962233752852171164704e-01 1.70367282462443730972623257002851e-01 1.41450458064848426376070023025022e-02
 	 1.70367282462443730972623257002851e-01 2.41479760073594007518948956203531e-01 5.88152957463962233752852171164704e-01 1.41450458064848426376070023025022e-02
 	 1.70367282462443730972623257002851e-01 5.88152957463962233752852171164704e-01 2.41479760073594007518948956203531e-01 1.41450458064848426376070023025022e-02
 	 5.88152957463962233752852171164704e-01 2.41479760073594007518948956203531e-01 1.70367282462443730972623257002851e-01 1.41450458064848426376070023025022e-02
 	 5.88152957463962233752852171164704e-01 1.70367282462443730972623257002851e-01 2.41479760073594007518948956203531e-01 1.41450458064848426376070023025022e-02
 	 3.28975808924226342799812528028269e-01 1.69759795860736056871687083003053e-01 5.01264395215037628084076004597591e-01 1.52744426013246229617559279745365e-02
 	 3.28975808924226342799812528028269e-01 5.01264395215037628084076004597591e-01 1.69759795860736056871687083003053e-01 1.52744426013246229617559279745365e-02
 	 1.69759795860736056871687083003053e-01 3.28975808924226342799812528028269e-01 5.01264395215037628084076004597591e-01 1.52744426013246229617559279745365e-02
 	 1.69759795860736056871687083003053e-01 5.01264395215037628084076004597591e-01 3.28975808924226342799812528028269e-01 1.52744426013246229617559279745365e-02
 	 5.01264395215037628084076004597591e-01 3.28975808924226342799812528028269e-01 1.69759795860736056871687083003053e-01 1.52744426013246229617559279745365e-02
 	 5.01264395215037628084076004597591e-01 1.69759795860736056871687083003053e-01 3.28975808924226342799812528028269e-01 1.52744426013246229617559279745365e-02
 	 9.31674097798811384762984744156711e-02 3.83182258210193957270739417708683e-02 8.68514364399099458857733679906232e-01 5.36627145416776734493380374146909e-03
 	 9.31674097798811384762984744156711e-02 8.68514364399099458857733679906232e-01 3.83182258210193957270739417708683e-02 5.36627145416776734493380374146909e-03
 	 3.83182258210193957270739417708683e-02 9.31674097798811384762984744156711e-02 8.68514364399099458857733679906232e-01 5.36627145416776734493380374146909e-03
 	 3.83182258210193957270739417708683e-02 8.68514364399099458857733679906232e-01 9.31674097798811384762984744156711e-02 5.36627145416776734493380374146909e-03
 	 8.68514364399099458857733679906232e-01 9.31674097798811384762984744156711e-02 3.83182258210193957270739417708683e-02 5.36627145416776734493380374146909e-03
 	 8.68514364399099458857733679906232e-01 3.83182258210193957270739417708683e-02 9.31674097798811384762984744156711e-02 5.36627145416776734493380374146909e-03
 	 3.94520279800194328956308709166478e-01 9.26564815207575470656919947032293e-02 5.12823238679048110100211488315836e-01 1.50318543497413390636063823535551e-02
 	 3.94520279800194328956308709166478e-01 5.12823238679048110100211488315836e-01 9.26564815207575470656919947032293e-02 1.50318543497413390636063823535551e-02
 	 9.26564815207575470656919947032293e-02 3.94520279800194328956308709166478e-01 5.12823238679048110100211488315836e-01 1.50318543497413390636063823535551e-02
 	 9.26564815207575470656919947032293e-02 5.12823238679048110100211488315836e-01 3.94520279800194328956308709166478e-01 1.50318543497413390636063823535551e-02
 	 5.12823238679048110100211488315836e-01 3.94520279800194328956308709166478e-01 9.26564815207575470656919947032293e-02 1.50318543497413390636063823535551e-02
 	 5.12823238679048110100211488315836e-01 9.26564815207575470656919947032293e-02 3.94520279800194328956308709166478e-01 1.50318543497413390636063823535551e-02
 	 1.62677416394477414307573326368583e-01 4.11887142484753873694636183699913e-02 7.96133869357047219139644766983110e-01 7.20413417479742659160768525339336e-03
 	 1.62677416394477414307573326368583e-01 7.96133869357047219139644766983110e-01 4.11887142484753873694636183699913e-02 7.20413417479742659160768525339336e-03
 	 4.11887142484753873694636183699913e-02 1.62677416394477414307573326368583e-01 7.96133869357047219139644766983110e-01 7.20413417479742659160768525339336e-03
 	 4.11887142484753873694636183699913e-02 7.96133869357047219139644766983110e-01 1.62677416394477414307573326368583e-01 7.20413417479742659160768525339336e-03
 	 7.96133869357047219139644766983110e-01 1.62677416394477414307573326368583e-01 4.11887142484753873694636183699913e-02 7.20413417479742659160768525339336e-03
 	 7.96133869357047219139644766983110e-01 4.11887142484753873694636183699913e-02 1.62677416394477414307573326368583e-01 7.20413417479742659160768525339336e-03
 	 2.53589014218879471584955354046542e-01 3.95709049701580550806312430722755e-02 7.06840080810962501089989018510096e-01 8.90487692816356417313539139968270e-03
 	 2.53589014218879471584955354046542e-01 7.06840080810962501089989018510096e-01 3.95709049701580550806312430722755e-02 8.90487692816356417313539139968270e-03
 	 3.95709049701580550806312430722755e-02 2.53589014218879471584955354046542e-01 7.06840080810962501089989018510096e-01 8.90487692816356417313539139968270e-03
 	 3.95709049701580550806312430722755e-02 7.06840080810962501089989018510096e-01 2.53589014218879471584955354046542e-01 8.90487692816356417313539139968270e-03
 	 7.06840080810962501089989018510096e-01 2.53589014218879471584955354046542e-01 3.95709049701580550806312430722755e-02 8.90487692816356417313539139968270e-03
 	 7.06840080810962501089989018510096e-01 3.95709049701580550806312430722755e-02 2.53589014218879471584955354046542e-01 8.90487692816356417313539139968270e-03
 	 3.62252241317791268127024295608862e-01 3.85927001748961398530646249582787e-02 5.99155058507312543447653752082260e-01 9.94725187568241790703194027400968e-03
 	 3.62252241317791268127024295608862e-01 5.99155058507312543447653752082260e-01 3.85927001748961398530646249582787e-02 9.94725187568241790703194027400968e-03
 	 3.85927001748961398530646249582787e-02 3.62252241317791268127024295608862e-01 5.99155058507312543447653752082260e-01 9.94725187568241790703194027400968e-03
 	 3.85927001748961398530646249582787e-02 5.99155058507312543447653752082260e-01 3.62252241317791268127024295608862e-01 9.94725187568241790703194027400968e-03
 	 5.99155058507312543447653752082260e-01 3.62252241317791268127024295608862e-01 3.85927001748961398530646249582787e-02 9.94725187568241790703194027400968e-03
 	 5.99155058507312543447653752082260e-01 3.85927001748961398530646249582787e-02 3.62252241317791268127024295608862e-01 9.94725187568241790703194027400968e-03
 	 2.81622577706160837074378378019901e-01 9.45349617365990324557856183673721e-02 6.23842460557240130469836003612727e-01 1.43523515781574517724550332786748e-02
 	 2.81622577706160837074378378019901e-01 6.23842460557240130469836003612727e-01 9.45349617365990324557856183673721e-02 1.43523515781574517724550332786748e-02
 	 9.45349617365990324557856183673721e-02 2.81622577706160837074378378019901e-01 6.23842460557240130469836003612727e-01 1.43523515781574517724550332786748e-02
 	 9.45349617365990324557856183673721e-02 6.23842460557240130469836003612727e-01 2.81622577706160837074378378019901e-01 1.43523515781574517724550332786748e-02
 	 6.23842460557240130469836003612727e-01 2.81622577706160837074378378019901e-01 9.45349617365990324557856183673721e-02 1.43523515781574517724550332786748e-02
 	 6.23842460557240130469836003612727e-01 9.45349617365990324557856183673721e-02 2.81622577706160837074378378019901e-01 1.43523515781574517724550332786748e-02
 	 3.83272664992659217730874843255151e-01 7.38799463229424056148753052752909e-03 6.09339340375046556452787172020180e-01 4.24214926680376806095162933729625e-03
 	 3.83272664992659217730874843255151e-01 6.09339340375046556452787172020180e-01 7.38799463229424056148753052752909e-03 4.24214926680376806095162933729625e-03
 	 7.38799463229424056148753052752909e-03 3.83272664992659217730874843255151e-01 6.09339340375046556452787172020180e-01 4.24214926680376806095162933729625e-03
 	 7.38799463229424056148753052752909e-03 6.09339340375046556452787172020180e-01 3.83272664992659217730874843255151e-01 4.24214926680376806095162933729625e-03
 	 6.09339340375046556452787172020180e-01 3.83272664992659217730874843255151e-01 7.38799463229424056148753052752909e-03 4.24214926680376806095162933729625e-03
 	 6.09339340375046556452787172020180e-01 7.38799463229424056148753052752909e-03 3.83272664992659217730874843255151e-01 4.24214926680376806095162933729625e-03
 	 2.73750352516260508917156357711065e-01 7.54600316231281847967338194393960e-03 7.18703644321426637908700740808854e-01 4.08127507711645003823930366593231e-03
 	 2.73750352516260508917156357711065e-01 7.18703644321426637908700740808854e-01 7.54600316231281847967338194393960e-03 4.08127507711645003823930366593231e-03
 	 7.54600316231281847967338194393960e-03 2.73750352516260508917156357711065e-01 7.18703644321426637908700740808854e-01 4.08127507711645003823930366593231e-03
 	 7.54600316231281847967338194393960e-03 7.18703644321426637908700740808854e-01 2.73750352516260508917156357711065e-01 4.08127507711645003823930366593231e-03
 	 7.18703644321426637908700740808854e-01 2.73750352516260508917156357711065e-01 7.54600316231281847967338194393960e-03 4.08127507711645003823930366593231e-03
 	 7.18703644321426637908700740808854e-01 7.54600316231281847967338194393960e-03 2.73750352516260508917156357711065e-01 4.08127507711645003823930366593231e-03
 	 9.41213427973660310410508600398316e-02 7.23455845778213976066117751884121e-03 8.98644098744851849147607936174609e-01 2.58921238239798439523253748006937e-03
 	 9.41213427973660310410508600398316e-02 8.98644098744851849147607936174609e-01 7.23455845778213976066117751884121e-03 2.58921238239798439523253748006937e-03
 	 7.23455845778213976066117751884121e-03 9.41213427973660310410508600398316e-02 8.98644098744851849147607936174609e-01 2.58921238239798439523253748006937e-03
 	 7.23455845778213976066117751884121e-03 8.98644098744851849147607936174609e-01 9.41213427973660310410508600398316e-02 2.58921238239798439523253748006937e-03
 	 8.98644098744851849147607936174609e-01 9.41213427973660310410508600398316e-02 7.23455845778213976066117751884121e-03 2.58921238239798439523253748006937e-03
 	 8.98644098744851849147607936174609e-01 7.23455845778213976066117751884121e-03 9.41213427973660310410508600398316e-02 2.58921238239798439523253748006937e-03
 	 1.80396151886765720995242645585677e-01 9.55662695273652579297518627754471e-02 7.24037578585869034952793299453333e-01 1.18435621425431059777766407137278e-02
 	 1.80396151886765720995242645585677e-01 7.24037578585869034952793299453333e-01 9.55662695273652579297518627754471e-02 1.18435621425431059777766407137278e-02
 	 9.55662695273652579297518627754471e-02 1.80396151886765720995242645585677e-01 7.24037578585869034952793299453333e-01 1.18435621425431059777766407137278e-02
 	 9.55662695273652579297518627754471e-02 7.24037578585869034952793299453333e-01 1.80396151886765720995242645585677e-01 1.18435621425431059777766407137278e-02
 	 7.24037578585869034952793299453333e-01 1.80396151886765720995242645585677e-01 9.55662695273652579297518627754471e-02 1.18435621425431059777766407137278e-02
 	 7.24037578585869034952793299453333e-01 9.55662695273652579297518627754471e-02 1.80396151886765720995242645585677e-01 1.18435621425431059777766407137278e-02
 	 1.74737346282805683372885141579900e-01 7.98792188084796773994700203047614e-03 8.17274731836346357560785236273659e-01 3.70722676424630782909819259884898e-03
 	 1.74737346282805683372885141579900e-01 8.17274731836346357560785236273659e-01 7.98792188084796773994700203047614e-03 3.70722676424630782909819259884898e-03
 	 7.98792188084796773994700203047614e-03 1.74737346282805683372885141579900e-01 8.17274731836346357560785236273659e-01 3.70722676424630782909819259884898e-03
 	 7.98792188084796773994700203047614e-03 8.17274731836346357560785236273659e-01 1.74737346282805683372885141579900e-01 3.70722676424630782909819259884898e-03
 	 8.17274731836346357560785236273659e-01 1.74737346282805683372885141579900e-01 7.98792188084796773994700203047614e-03 3.70722676424630782909819259884898e-03
 	 8.17274731836346357560785236273659e-01 7.98792188084796773994700203047614e-03 1.74737346282805683372885141579900e-01 3.70722676424630782909819259884898e-03
 	 3.72914720512912134520178142338409e-02 8.07491087020877768010151953603781e-03 9.54633617078500029684562377951806e-01 1.79694758544657611117056905669642e-03
 	 3.72914720512912134520178142338409e-02 9.54633617078500029684562377951806e-01 8.07491087020877768010151953603781e-03 1.79694758544657611117056905669642e-03
 	 8.07491087020877768010151953603781e-03 3.72914720512912134520178142338409e-02 9.54633617078500029684562377951806e-01 1.79694758544657611117056905669642e-03
 	 8.07491087020877768010151953603781e-03 9.54633617078500029684562377951806e-01 3.72914720512912134520178142338409e-02 1.79694758544657611117056905669642e-03
 	 9.54633617078500029684562377951806e-01 3.72914720512912134520178142338409e-02 8.07491087020877768010151953603781e-03 1.79694758544657611117056905669642e-03
 	 9.54633617078500029684562377951806e-01 8.07491087020877768010151953603781e-03 3.72914720512912134520178142338409e-02 1.79694758544657611117056905669642e-03
 	 ];
 
 	 case  25 

 	 % ALG. DEG.:   25
 	 % PTS CARD.:  120
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.8e-15  

 	 xyw_bar=[
 	 3.87642030404563353584990181843750e-01 3.87642030404563353584990181843750e-01 2.24715939190873292830019636312500e-01 1.36898515482722377828439519475978e-02
 	 3.87642030404563353584990181843750e-01 2.24715939190873292830019636312500e-01 3.87642030404563353584990181843750e-01 1.36898515482722377828439519475978e-02
 	 2.24715939190873292830019636312500e-01 3.87642030404563353584990181843750e-01 3.87642030404563353584990181843750e-01 1.36898515482722377828439519475978e-02
 	 2.11004508061496565129999680721085e-01 2.11004508061496565129999680721085e-01 5.77990983877006869740000638557831e-01 1.15872632360105864979260559266550e-02
 	 2.11004508061496565129999680721085e-01 5.77990983877006869740000638557831e-01 2.11004508061496565129999680721085e-01 1.15872632360105864979260559266550e-02
 	 5.77990983877006869740000638557831e-01 2.11004508061496565129999680721085e-01 2.11004508061496565129999680721085e-01 1.15872632360105864979260559266550e-02
 	 2.99492315804508413279449996480253e-01 2.99492315804508413279449996480253e-01 4.01015368390983173441100007039495e-01 1.80176407017014657274689426458281e-02
 	 2.99492315804508413279449996480253e-01 4.01015368390983173441100007039495e-01 2.99492315804508413279449996480253e-01 1.80176407017014657274689426458281e-02
 	 4.01015368390983173441100007039495e-01 2.99492315804508413279449996480253e-01 2.99492315804508413279449996480253e-01 1.80176407017014657274689426458281e-02
 	 3.72229259924406336024205188550695e-02 3.72229259924406336024205188550695e-02 9.25554148015118705039583346660947e-01 3.39729772190473441884073224628082e-03
 	 3.72229259924406336024205188550695e-02 9.25554148015118705039583346660947e-01 3.72229259924406336024205188550695e-02 3.39729772190473441884073224628082e-03
 	 9.25554148015118705039583346660947e-01 3.72229259924406336024205188550695e-02 3.72229259924406336024205188550695e-02 3.39729772190473441884073224628082e-03
 	 1.45109243574500224038814621962956e-01 1.45109243574500224038814621962956e-01 7.09781512850999551922370756074088e-01 1.14915258625647928591995139413484e-02
 	 1.45109243574500224038814621962956e-01 7.09781512850999551922370756074088e-01 1.45109243574500224038814621962956e-01 1.14915258625647928591995139413484e-02
 	 7.09781512850999551922370756074088e-01 1.45109243574500224038814621962956e-01 1.45109243574500224038814621962956e-01 1.14915258625647928591995139413484e-02
 	 4.24759304540574700315147538276506e-01 4.24759304540574700315147538276506e-01 1.50481390918850599369704923446989e-01 1.59113101374584106628695678864460e-02
 	 4.24759304540574700315147538276506e-01 1.50481390918850599369704923446989e-01 4.24759304540574700315147538276506e-01 1.59113101374584106628695678864460e-02
 	 1.50481390918850599369704923446989e-01 4.24759304540574700315147538276506e-01 4.24759304540574700315147538276506e-01 1.59113101374584106628695678864460e-02
 	 4.62208708748706120772453687095549e-01 4.62208708748706120772453687095549e-01 7.55825825025877584550926258089021e-02 1.36542751875280074513874239983124e-02
 	 4.62208708748706120772453687095549e-01 7.55825825025877584550926258089021e-02 4.62208708748706120772453687095549e-01 1.36542751875280074513874239983124e-02
 	 7.55825825025877584550926258089021e-02 4.62208708748706120772453687095549e-01 4.62208708748706120772453687095549e-01 1.36542751875280074513874239983124e-02
 	 9.29497017007697989843251207275898e-02 9.29497017007697989843251207275898e-02 8.14100596598460457542500989802647e-01 9.18282125982003080699733743585966e-03
 	 9.29497017007697989843251207275898e-02 8.14100596598460457542500989802647e-01 9.29497017007697989843251207275898e-02 9.18282125982003080699733743585966e-03
 	 8.14100596598460457542500989802647e-01 9.29497017007697989843251207275898e-02 9.29497017007697989843251207275898e-02 9.18282125982003080699733743585966e-03
 	 7.83534428260363076390593306541632e-03 7.83534428260363076390593306541632e-03 9.84329311434792741941635085822782e-01 8.06510288324616326539884259005930e-04
 	 7.83534428260363076390593306541632e-03 9.84329311434792741941635085822782e-01 7.83534428260363076390593306541632e-03 8.06510288324616326539884259005930e-04
 	 9.84329311434792741941635085822782e-01 7.83534428260363076390593306541632e-03 7.83534428260363076390593306541632e-03 8.06510288324616326539884259005930e-04
 	 4.89039369660395462080515471825493e-01 4.89039369660395462080515471825493e-01 2.19212606792090758389690563490149e-02 8.44408594652107206968150165948828e-03
 	 4.89039369660395462080515471825493e-01 2.19212606792090758389690563490149e-02 4.89039369660395462080515471825493e-01 8.44408594652107206968150165948828e-03
 	 2.19212606792090758389690563490149e-02 4.89039369660395462080515471825493e-01 4.89039369660395462080515471825493e-01 8.44408594652107206968150165948828e-03
 	 4.40416927479343300877445699370583e-01 1.81886663427438814884251616632582e-03 5.57764205886382313792637432925403e-01 1.67481783193470417162029839630577e-03
 	 4.40416927479343300877445699370583e-01 5.57764205886382313792637432925403e-01 1.81886663427438814884251616632582e-03 1.67481783193470417162029839630577e-03
 	 1.81886663427438814884251616632582e-03 4.40416927479343300877445699370583e-01 5.57764205886382313792637432925403e-01 1.67481783193470417162029839630577e-03
 	 1.81886663427438814884251616632582e-03 5.57764205886382313792637432925403e-01 4.40416927479343300877445699370583e-01 1.67481783193470417162029839630577e-03
 	 5.57764205886382313792637432925403e-01 4.40416927479343300877445699370583e-01 1.81886663427438814884251616632582e-03 1.67481783193470417162029839630577e-03
 	 5.57764205886382313792637432925403e-01 1.81886663427438814884251616632582e-03 4.40416927479343300877445699370583e-01 1.67481783193470417162029839630577e-03
 	 1.59007906197327880670755462233501e-01 3.69601415796714863337690815114911e-02 8.04031952223000612178793744533323e-01 6.31147802475927072879402501826007e-03
 	 1.59007906197327880670755462233501e-01 8.04031952223000612178793744533323e-01 3.69601415796714863337690815114911e-02 6.31147802475927072879402501826007e-03
 	 3.69601415796714863337690815114911e-02 1.59007906197327880670755462233501e-01 8.04031952223000612178793744533323e-01 6.31147802475927072879402501826007e-03
 	 3.69601415796714863337690815114911e-02 8.04031952223000612178793744533323e-01 1.59007906197327880670755462233501e-01 6.31147802475927072879402501826007e-03
 	 8.04031952223000612178793744533323e-01 1.59007906197327880670755462233501e-01 3.69601415796714863337690815114911e-02 6.31147802475927072879402501826007e-03
 	 8.04031952223000612178793744533323e-01 3.69601415796714863337690815114911e-02 1.59007906197327880670755462233501e-01 6.31147802475927072879402501826007e-03
 	 1.77353796757252879512378740400891e-01 7.88580680056353011675440711769625e-02 7.43788135237111736053350341535406e-01 9.51502156745576491148064235403581e-03
 	 1.77353796757252879512378740400891e-01 7.43788135237111736053350341535406e-01 7.88580680056353011675440711769625e-02 9.51502156745576491148064235403581e-03
 	 7.88580680056353011675440711769625e-02 1.77353796757252879512378740400891e-01 7.43788135237111736053350341535406e-01 9.51502156745576491148064235403581e-03
 	 7.88580680056353011675440711769625e-02 7.43788135237111736053350341535406e-01 1.77353796757252879512378740400891e-01 9.51502156745576491148064235403581e-03
 	 7.43788135237111736053350341535406e-01 1.77353796757252879512378740400891e-01 7.88580680056353011675440711769625e-02 9.51502156745576491148064235403581e-03
 	 7.43788135237111736053350341535406e-01 7.88580680056353011675440711769625e-02 1.77353796757252879512378740400891e-01 9.51502156745576491148064235403581e-03
 	 2.70066735820959358260751059788163e-01 6.88475294314979391341324799213908e-02 6.61085734747542619338389613403706e-01 1.08843936124369145695967020515127e-02
 	 2.70066735820959358260751059788163e-01 6.61085734747542619338389613403706e-01 6.88475294314979391341324799213908e-02 1.08843936124369145695967020515127e-02
 	 6.88475294314979391341324799213908e-02 2.70066735820959358260751059788163e-01 6.61085734747542619338389613403706e-01 1.08843936124369145695967020515127e-02
 	 6.88475294314979391341324799213908e-02 6.61085734747542619338389613403706e-01 2.70066735820959358260751059788163e-01 1.08843936124369145695967020515127e-02
 	 6.61085734747542619338389613403706e-01 2.70066735820959358260751059788163e-01 6.88475294314979391341324799213908e-02 1.08843936124369145695967020515127e-02
 	 6.61085734747542619338389613403706e-01 6.88475294314979391341324799213908e-02 2.70066735820959358260751059788163e-01 1.08843936124369145695967020515127e-02
 	 3.41391033021149870041455187674728e-01 1.15999807640960211907454890933877e-01 5.42609159337890001317816768278135e-01 1.58403522878984258370760329626137e-02
 	 3.41391033021149870041455187674728e-01 5.42609159337890001317816768278135e-01 1.15999807640960211907454890933877e-01 1.58403522878984258370760329626137e-02
 	 1.15999807640960211907454890933877e-01 3.41391033021149870041455187674728e-01 5.42609159337890001317816768278135e-01 1.58403522878984258370760329626137e-02
 	 1.15999807640960211907454890933877e-01 5.42609159337890001317816768278135e-01 3.41391033021149870041455187674728e-01 1.58403522878984258370760329626137e-02
 	 5.42609159337890001317816768278135e-01 3.41391033021149870041455187674728e-01 1.15999807640960211907454890933877e-01 1.58403522878984258370760329626137e-02
 	 5.42609159337890001317816768278135e-01 1.15999807640960211907454890933877e-01 3.41391033021149870041455187674728e-01 1.58403522878984258370760329626137e-02
 	 3.73937979719584367988005624283687e-01 4.83174342873769688266882837979210e-02 5.77744585993038684001987803640077e-01 1.06401706955087799189030306479253e-02
 	 3.73937979719584367988005624283687e-01 5.77744585993038684001987803640077e-01 4.83174342873769688266882837979210e-02 1.06401706955087799189030306479253e-02
 	 4.83174342873769688266882837979210e-02 3.73937979719584367988005624283687e-01 5.77744585993038684001987803640077e-01 1.06401706955087799189030306479253e-02
 	 4.83174342873769688266882837979210e-02 5.77744585993038684001987803640077e-01 3.73937979719584367988005624283687e-01 1.06401706955087799189030306479253e-02
 	 5.77744585993038684001987803640077e-01 3.73937979719584367988005624283687e-01 4.83174342873769688266882837979210e-02 1.06401706955087799189030306479253e-02
 	 5.77744585993038684001987803640077e-01 4.83174342873769688266882837979210e-02 3.73937979719584367988005624283687e-01 1.06401706955087799189030306479253e-02
 	 9.91330633416821899173143606276426e-02 7.12831450125742636936276852566152e-03 8.93738622157060458306432337849401e-01 2.54527162534901301577106025320063e-03
 	 9.91330633416821899173143606276426e-02 8.93738622157060458306432337849401e-01 7.12831450125742636936276852566152e-03 2.54527162534901301577106025320063e-03
 	 7.12831450125742636936276852566152e-03 9.91330633416821899173143606276426e-02 8.93738622157060458306432337849401e-01 2.54527162534901301577106025320063e-03
 	 7.12831450125742636936276852566152e-03 8.93738622157060458306432337849401e-01 9.91330633416821899173143606276426e-02 2.54527162534901301577106025320063e-03
 	 8.93738622157060458306432337849401e-01 9.91330633416821899173143606276426e-02 7.12831450125742636936276852566152e-03 2.54527162534901301577106025320063e-03
 	 8.93738622157060458306432337849401e-01 7.12831450125742636936276852566152e-03 9.91330633416821899173143606276426e-02 2.54527162534901301577106025320063e-03
 	 2.99506418629674531217688127071597e-01 2.03692910584251041239411961214500e-01 4.96800670786074427542899911713903e-01 1.79138208922760486241365640580625e-02
 	 2.99506418629674531217688127071597e-01 4.96800670786074427542899911713903e-01 2.03692910584251041239411961214500e-01 1.79138208922760486241365640580625e-02
 	 2.03692910584251041239411961214500e-01 2.99506418629674531217688127071597e-01 4.96800670786074427542899911713903e-01 1.79138208922760486241365640580625e-02
 	 2.03692910584251041239411961214500e-01 4.96800670786074427542899911713903e-01 2.99506418629674531217688127071597e-01 1.79138208922760486241365640580625e-02
 	 4.96800670786074427542899911713903e-01 2.99506418629674531217688127071597e-01 2.03692910584251041239411961214500e-01 1.79138208922760486241365640580625e-02
 	 4.96800670786074427542899911713903e-01 2.03692910584251041239411961214500e-01 2.99506418629674531217688127071597e-01 1.79138208922760486241365640580625e-02
 	 1.78629848603616248059466897757375e-01 7.23616174794815877197029507783554e-03 8.14133989648435640873458396526985e-01 3.26373968204924074648642928764275e-03
 	 1.78629848603616248059466897757375e-01 8.14133989648435640873458396526985e-01 7.23616174794815877197029507783554e-03 3.26373968204924074648642928764275e-03
 	 7.23616174794815877197029507783554e-03 1.78629848603616248059466897757375e-01 8.14133989648435640873458396526985e-01 3.26373968204924074648642928764275e-03
 	 7.23616174794815877197029507783554e-03 8.14133989648435640873458396526985e-01 1.78629848603616248059466897757375e-01 3.26373968204924074648642928764275e-03
 	 8.14133989648435640873458396526985e-01 1.78629848603616248059466897757375e-01 7.23616174794815877197029507783554e-03 3.26373968204924074648642928764275e-03
 	 8.14133989648435640873458396526985e-01 7.23616174794815877197029507783554e-03 1.78629848603616248059466897757375e-01 3.26373968204924074648642928764275e-03
 	 3.62068801895972014470714839262655e-01 1.29138832500325321378520371240484e-02 6.25017314853995475942838311311789e-01 5.45463836797442473691699404980682e-03
 	 3.62068801895972014470714839262655e-01 6.25017314853995475942838311311789e-01 1.29138832500325321378520371240484e-02 5.45463836797442473691699404980682e-03
 	 1.29138832500325321378520371240484e-02 3.62068801895972014470714839262655e-01 6.25017314853995475942838311311789e-01 5.45463836797442473691699404980682e-03
 	 1.29138832500325321378520371240484e-02 6.25017314853995475942838311311789e-01 3.62068801895972014470714839262655e-01 5.45463836797442473691699404980682e-03
 	 6.25017314853995475942838311311789e-01 3.62068801895972014470714839262655e-01 1.29138832500325321378520371240484e-02 5.45463836797442473691699404980682e-03
 	 6.25017314853995475942838311311789e-01 1.29138832500325321378520371240484e-02 3.62068801895972014470714839262655e-01 5.45463836797442473691699404980682e-03
 	 8.87929154893665473213815175768104e-02 3.76879497842590865941403421857103e-02 8.73519134726374435473417179309763e-01 5.27256192142941653572263405180820e-03
 	 8.87929154893665473213815175768104e-02 8.73519134726374435473417179309763e-01 3.76879497842590865941403421857103e-02 5.27256192142941653572263405180820e-03
 	 3.76879497842590865941403421857103e-02 8.87929154893665473213815175768104e-02 8.73519134726374435473417179309763e-01 5.27256192142941653572263405180820e-03
 	 3.76879497842590865941403421857103e-02 8.73519134726374435473417179309763e-01 8.87929154893665473213815175768104e-02 5.27256192142941653572263405180820e-03
 	 8.73519134726374435473417179309763e-01 8.87929154893665473213815175768104e-02 3.76879497842590865941403421857103e-02 5.27256192142941653572263405180820e-03
 	 8.73519134726374435473417179309763e-01 3.76879497842590865941403421857103e-02 8.87929154893665473213815175768104e-02 5.27256192142941653572263405180820e-03
 	 2.33622810141715209208967962695169e-01 1.37006694087071001497690758696990e-01 6.29370495771213733782190047350014e-01 1.37400825920225445192501823044040e-02
 	 2.33622810141715209208967962695169e-01 6.29370495771213733782190047350014e-01 1.37006694087071001497690758696990e-01 1.37400825920225445192501823044040e-02
 	 1.37006694087071001497690758696990e-01 2.33622810141715209208967962695169e-01 6.29370495771213733782190047350014e-01 1.37400825920225445192501823044040e-02
 	 1.37006694087071001497690758696990e-01 6.29370495771213733782190047350014e-01 2.33622810141715209208967962695169e-01 1.37400825920225445192501823044040e-02
 	 6.29370495771213733782190047350014e-01 2.33622810141715209208967962695169e-01 1.37006694087071001497690758696990e-01 1.37400825920225445192501823044040e-02
 	 6.29370495771213733782190047350014e-01 1.37006694087071001497690758696990e-01 2.33622810141715209208967962695169e-01 1.37400825920225445192501823044040e-02
 	 2.56595409709019783850436624561553e-01 2.45400602475243957700801189503181e-02 7.18864530043455851604505824070657e-01 7.31434090793284252818295954057248e-03
 	 2.56595409709019783850436624561553e-01 7.18864530043455851604505824070657e-01 2.45400602475243957700801189503181e-02 7.31434090793284252818295954057248e-03
 	 2.45400602475243957700801189503181e-02 2.56595409709019783850436624561553e-01 7.18864530043455851604505824070657e-01 7.31434090793284252818295954057248e-03
 	 2.45400602475243957700801189503181e-02 7.18864530043455851604505824070657e-01 2.56595409709019783850436624561553e-01 7.31434090793284252818295954057248e-03
 	 7.18864530043455851604505824070657e-01 2.56595409709019783850436624561553e-01 2.45400602475243957700801189503181e-02 7.31434090793284252818295954057248e-03
 	 7.18864530043455851604505824070657e-01 2.45400602475243957700801189503181e-02 2.56595409709019783850436624561553e-01 7.31434090793284252818295954057248e-03
 	 4.10688191117846435052030074075446e-02 7.18882826169304090663247919223977e-03 9.51742352626522292169397587713320e-01 1.69298363412733127511544672927357e-03
 	 4.10688191117846435052030074075446e-02 9.51742352626522292169397587713320e-01 7.18882826169304090663247919223977e-03 1.69298363412733127511544672927357e-03
 	 7.18882826169304090663247919223977e-03 4.10688191117846435052030074075446e-02 9.51742352626522292169397587713320e-01 1.69298363412733127511544672927357e-03
 	 7.18882826169304090663247919223977e-03 9.51742352626522292169397587713320e-01 4.10688191117846435052030074075446e-02 1.69298363412733127511544672927357e-03
 	 9.51742352626522292169397587713320e-01 4.10688191117846435052030074075446e-02 7.18882826169304090663247919223977e-03 1.69298363412733127511544672927357e-03
 	 9.51742352626522292169397587713320e-01 7.18882826169304090663247919223977e-03 4.10688191117846435052030074075446e-02 1.69298363412733127511544672927357e-03
 	 2.79416188649260710530342066704179e-01 8.91464317498128172405358338181713e-04 7.19692347033241142106874121964211e-01 1.51170207845887933501005662151329e-03
 	 2.79416188649260710530342066704179e-01 7.19692347033241142106874121964211e-01 8.91464317498128172405358338181713e-04 1.51170207845887933501005662151329e-03
 	 8.91464317498128172405358338181713e-04 2.79416188649260710530342066704179e-01 7.19692347033241142106874121964211e-01 1.51170207845887933501005662151329e-03
 	 8.91464317498128172405358338181713e-04 7.19692347033241142106874121964211e-01 2.79416188649260710530342066704179e-01 1.51170207845887933501005662151329e-03
 	 7.19692347033241142106874121964211e-01 2.79416188649260710530342066704179e-01 8.91464317498128172405358338181713e-04 1.51170207845887933501005662151329e-03
 	 7.19692347033241142106874121964211e-01 8.91464317498128172405358338181713e-04 2.79416188649260710530342066704179e-01 1.51170207845887933501005662151329e-03
 	 ];
 
 	 case  26 

 	 % ALG. DEG.:   26
 	 % PTS CARD.:  130
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.0e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 2.04866625892232284700256172982336e-02
 	 6.67371225764660652712834121302876e-02 6.67371225764660652712834121302876e-02 8.66525754847067841701857560110511e-01 4.91382530296601525987565395325873e-03
 	 6.67371225764660652712834121302876e-02 8.66525754847067841701857560110511e-01 6.67371225764660652712834121302876e-02 4.91382530296601525987565395325873e-03
 	 8.66525754847067841701857560110511e-01 6.67371225764660652712834121302876e-02 6.67371225764660652712834121302876e-02 4.91382530296601525987565395325873e-03
 	 6.34011649207668302741236487918286e-03 6.34011649207668302741236487918286e-03 9.87319767015846672109091741731390e-01 5.26953116681871556667426936826359e-04
 	 6.34011649207668302741236487918286e-03 9.87319767015846672109091741731390e-01 6.34011649207668302741236487918286e-03 5.26953116681871556667426936826359e-04
 	 9.87319767015846672109091741731390e-01 6.34011649207668302741236487918286e-03 6.34011649207668302741236487918286e-03 5.26953116681871556667426936826359e-04
 	 4.93753032896384780325860219818424e-01 4.93753032896384780325860219818424e-01 1.24939342072304393482795603631530e-02 5.30215918186734309902607975573119e-03
 	 4.93753032896384780325860219818424e-01 1.24939342072304393482795603631530e-02 4.93753032896384780325860219818424e-01 5.30215918186734309902607975573119e-03
 	 1.24939342072304393482795603631530e-02 4.93753032896384780325860219818424e-01 4.93753032896384780325860219818424e-01 5.30215918186734309902607975573119e-03
 	 3.88787497107593971179539948934689e-01 3.88787497107593971179539948934689e-01 2.22425005784812057640920102130622e-01 1.94680678371828667916343391652845e-02
 	 3.88787497107593971179539948934689e-01 2.22425005784812057640920102130622e-01 3.88787497107593971179539948934689e-01 1.94680678371828667916343391652845e-02
 	 2.22425005784812057640920102130622e-01 3.88787497107593971179539948934689e-01 3.88787497107593971179539948934689e-01 1.94680678371828667916343391652845e-02
 	 2.73147100929078678888117792666890e-01 2.73147100929078678888117792666890e-01 4.53705798141842642223764414666221e-01 1.95356469232475307706842215793586e-02
 	 2.73147100929078678888117792666890e-01 4.53705798141842642223764414666221e-01 2.73147100929078678888117792666890e-01 1.95356469232475307706842215793586e-02
 	 4.53705798141842642223764414666221e-01 2.73147100929078678888117792666890e-01 2.73147100929078678888117792666890e-01 1.95356469232475307706842215793586e-02
 	 4.71828563321166016830687794936239e-01 4.71828563321166016830687794936239e-01 5.63428733576679663386244101275224e-02 1.15285036346568867809958547354654e-02
 	 4.71828563321166016830687794936239e-01 5.63428733576679663386244101275224e-02 4.71828563321166016830687794936239e-01 1.15285036346568867809958547354654e-02
 	 5.63428733576679663386244101275224e-02 4.71828563321166016830687794936239e-01 4.71828563321166016830687794936239e-01 1.15285036346568867809958547354654e-02
 	 1.54201430364544173068352961308847e-01 1.54201430364544173068352961308847e-01 6.91597139270911709374445308640134e-01 1.32552594485452618355836307273421e-02
 	 1.54201430364544173068352961308847e-01 6.91597139270911709374445308640134e-01 1.54201430364544173068352961308847e-01 1.32552594485452618355836307273421e-02
 	 6.91597139270911709374445308640134e-01 1.54201430364544173068352961308847e-01 1.54201430364544173068352961308847e-01 1.32552594485452618355836307273421e-02
 	 2.12043163302205517339871221338399e-01 2.12043163302205517339871221338399e-01 5.75913673395588965320257557323202e-01 1.69443450785280828874146408224988e-02
 	 2.12043163302205517339871221338399e-01 5.75913673395588965320257557323202e-01 2.12043163302205517339871221338399e-01 1.69443450785280828874146408224988e-02
 	 5.75913673395588965320257557323202e-01 2.12043163302205517339871221338399e-01 2.12043163302205517339871221338399e-01 1.69443450785280828874146408224988e-02
 	 4.35985419384383177110464657744160e-01 4.35985419384383177110464657744160e-01 1.28029161231233645779070684511680e-01 1.64124006025878933778816559652114e-02
 	 4.35985419384383177110464657744160e-01 1.28029161231233645779070684511680e-01 4.35985419384383177110464657744160e-01 1.64124006025878933778816559652114e-02
 	 1.28029161231233645779070684511680e-01 4.35985419384383177110464657744160e-01 4.35985419384383177110464657744160e-01 1.64124006025878933778816559652114e-02
 	 8.00716549403165389620085079513956e-02 4.79466097543667854607996048343921e-03 9.15133684084246779022464579611551e-01 1.39852644816027124261004210836745e-03
 	 8.00716549403165389620085079513956e-02 9.15133684084246779022464579611551e-01 4.79466097543667854607996048343921e-03 1.39852644816027124261004210836745e-03
 	 4.79466097543667854607996048343921e-03 8.00716549403165389620085079513956e-02 9.15133684084246779022464579611551e-01 1.39852644816027124261004210836745e-03
 	 4.79466097543667854607996048343921e-03 9.15133684084246779022464579611551e-01 8.00716549403165389620085079513956e-02 1.39852644816027124261004210836745e-03
 	 9.15133684084246779022464579611551e-01 8.00716549403165389620085079513956e-02 4.79466097543667854607996048343921e-03 1.39852644816027124261004210836745e-03
 	 9.15133684084246779022464579611551e-01 4.79466097543667854607996048343921e-03 8.00716549403165389620085079513956e-02 1.39852644816027124261004210836745e-03
 	 3.16436115715307691997892902691092e-02 2.91551962068358448687543926780563e-02 9.39201192221633451850948404171504e-01 1.20556477371688472964572635959257e-03
 	 3.16436115715307691997892902691092e-02 9.39201192221633451850948404171504e-01 2.91551962068358448687543926780563e-02 1.20556477371688472964572635959257e-03
 	 2.91551962068358448687543926780563e-02 3.16436115715307691997892902691092e-02 9.39201192221633451850948404171504e-01 1.20556477371688472964572635959257e-03
 	 2.91551962068358448687543926780563e-02 9.39201192221633451850948404171504e-01 3.16436115715307691997892902691092e-02 1.20556477371688472964572635959257e-03
 	 9.39201192221633451850948404171504e-01 3.16436115715307691997892902691092e-02 2.91551962068358448687543926780563e-02 1.20556477371688472964572635959257e-03
 	 9.39201192221633451850948404171504e-01 2.91551962068358448687543926780563e-02 3.16436115715307691997892902691092e-02 1.20556477371688472964572635959257e-03
 	 7.53800475153986598852995371089492e-02 2.62093640224986615394620059760200e-02 8.98410588462102754903071399894543e-01 3.30554471296766808063871678768919e-03
 	 7.53800475153986598852995371089492e-02 8.98410588462102754903071399894543e-01 2.62093640224986615394620059760200e-02 3.30554471296766808063871678768919e-03
 	 2.62093640224986615394620059760200e-02 7.53800475153986598852995371089492e-02 8.98410588462102754903071399894543e-01 3.30554471296766808063871678768919e-03
 	 2.62093640224986615394620059760200e-02 8.98410588462102754903071399894543e-01 7.53800475153986598852995371089492e-02 3.30554471296766808063871678768919e-03
 	 8.98410588462102754903071399894543e-01 7.53800475153986598852995371089492e-02 2.62093640224986615394620059760200e-02 3.30554471296766808063871678768919e-03
 	 8.98410588462102754903071399894543e-01 2.62093640224986615394620059760200e-02 7.53800475153986598852995371089492e-02 3.30554471296766808063871678768919e-03
 	 3.31000343360322718533339525492920e-02 5.69811791687521804888882925865801e-03 9.61201847747092497087351148365997e-01 1.08570734299675403754237290598894e-03
 	 3.31000343360322718533339525492920e-02 9.61201847747092497087351148365997e-01 5.69811791687521804888882925865801e-03 1.08570734299675403754237290598894e-03
 	 5.69811791687521804888882925865801e-03 3.31000343360322718533339525492920e-02 9.61201847747092497087351148365997e-01 1.08570734299675403754237290598894e-03
 	 5.69811791687521804888882925865801e-03 9.61201847747092497087351148365997e-01 3.31000343360322718533339525492920e-02 1.08570734299675403754237290598894e-03
 	 9.61201847747092497087351148365997e-01 3.31000343360322718533339525492920e-02 5.69811791687521804888882925865801e-03 1.08570734299675403754237290598894e-03
 	 9.61201847747092497087351148365997e-01 5.69811791687521804888882925865801e-03 3.31000343360322718533339525492920e-02 1.08570734299675403754237290598894e-03
 	 1.32486189614567290151470047021576e-01 4.17247227421209468389839969404420e-02 8.25789087643311825459591091203038e-01 6.40359789971281425507987350442818e-03
 	 1.32486189614567290151470047021576e-01 8.25789087643311825459591091203038e-01 4.17247227421209468389839969404420e-02 6.40359789971281425507987350442818e-03
 	 4.17247227421209468389839969404420e-02 1.32486189614567290151470047021576e-01 8.25789087643311825459591091203038e-01 6.40359789971281425507987350442818e-03
 	 4.17247227421209468389839969404420e-02 8.25789087643311825459591091203038e-01 1.32486189614567290151470047021576e-01 6.40359789971281425507987350442818e-03
 	 8.25789087643311825459591091203038e-01 1.32486189614567290151470047021576e-01 4.17247227421209468389839969404420e-02 6.40359789971281425507987350442818e-03
 	 8.25789087643311825459591091203038e-01 4.17247227421209468389839969404420e-02 1.32486189614567290151470047021576e-01 6.40359789971281425507987350442818e-03
 	 1.08687132914402101446782467064622e-01 1.00045659106527559667476623417315e-01 7.91267207979070352763528717332520e-01 4.61421107637831513781367931414934e-03
 	 1.08687132914402101446782467064622e-01 7.91267207979070352763528717332520e-01 1.00045659106527559667476623417315e-01 4.61421107637831513781367931414934e-03
 	 1.00045659106527559667476623417315e-01 1.08687132914402101446782467064622e-01 7.91267207979070352763528717332520e-01 4.61421107637831513781367931414934e-03
 	 1.00045659106527559667476623417315e-01 7.91267207979070352763528717332520e-01 1.08687132914402101446782467064622e-01 4.61421107637831513781367931414934e-03
 	 7.91267207979070352763528717332520e-01 1.08687132914402101446782467064622e-01 1.00045659106527559667476623417315e-01 4.61421107637831513781367931414934e-03
 	 7.91267207979070352763528717332520e-01 1.00045659106527559667476623417315e-01 1.08687132914402101446782467064622e-01 4.61421107637831513781367931414934e-03
 	 2.50272313290526460249907358956989e-01 1.20614402205249035548995095723512e-01 6.29113284504224545834460968762869e-01 1.43794732275987317826615452531769e-02
 	 2.50272313290526460249907358956989e-01 6.29113284504224545834460968762869e-01 1.20614402205249035548995095723512e-01 1.43794732275987317826615452531769e-02
 	 1.20614402205249035548995095723512e-01 2.50272313290526460249907358956989e-01 6.29113284504224545834460968762869e-01 1.43794732275987317826615452531769e-02
 	 1.20614402205249035548995095723512e-01 6.29113284504224545834460968762869e-01 2.50272313290526460249907358956989e-01 1.43794732275987317826615452531769e-02
 	 6.29113284504224545834460968762869e-01 2.50272313290526460249907358956989e-01 1.20614402205249035548995095723512e-01 1.43794732275987317826615452531769e-02
 	 6.29113284504224545834460968762869e-01 1.20614402205249035548995095723512e-01 2.50272313290526460249907358956989e-01 1.43794732275987317826615452531769e-02
 	 3.89022062042761740396912273354246e-01 2.95379425169078370372321984405062e-02 5.81439995440330315013000017643208e-01 8.25976721708683407630058326276412e-03
 	 3.89022062042761740396912273354246e-01 5.81439995440330315013000017643208e-01 2.95379425169078370372321984405062e-02 8.25976721708683407630058326276412e-03
 	 2.95379425169078370372321984405062e-02 3.89022062042761740396912273354246e-01 5.81439995440330315013000017643208e-01 8.25976721708683407630058326276412e-03
 	 2.95379425169078370372321984405062e-02 5.81439995440330315013000017643208e-01 3.89022062042761740396912273354246e-01 8.25976721708683407630058326276412e-03
 	 5.81439995440330315013000017643208e-01 3.89022062042761740396912273354246e-01 2.95379425169078370372321984405062e-02 8.25976721708683407630058326276412e-03
 	 5.81439995440330315013000017643208e-01 2.95379425169078370372321984405062e-02 3.89022062042761740396912273354246e-01 8.25976721708683407630058326276412e-03
 	 3.58509296427661550143994872996700e-01 8.73784651638445236665475590598362e-02 5.54112238408493995578396607015748e-01 1.37279582160856929162751072226456e-02
 	 3.58509296427661550143994872996700e-01 5.54112238408493995578396607015748e-01 8.73784651638445236665475590598362e-02 1.37279582160856929162751072226456e-02
 	 8.73784651638445236665475590598362e-02 3.58509296427661550143994872996700e-01 5.54112238408493995578396607015748e-01 1.37279582160856929162751072226456e-02
 	 8.73784651638445236665475590598362e-02 5.54112238408493995578396607015748e-01 3.58509296427661550143994872996700e-01 1.37279582160856929162751072226456e-02
 	 5.54112238408493995578396607015748e-01 3.58509296427661550143994872996700e-01 8.73784651638445236665475590598362e-02 1.37279582160856929162751072226456e-02
 	 5.54112238408493995578396607015748e-01 8.73784651638445236665475590598362e-02 3.58509296427661550143994872996700e-01 1.37279582160856929162751072226456e-02
 	 1.86869179476221558555693036396406e-01 7.63119015129594124857703718589619e-02 7.36818919010818973447385360486805e-01 1.03976455281743172809338915385524e-02
 	 1.86869179476221558555693036396406e-01 7.36818919010818973447385360486805e-01 7.63119015129594124857703718589619e-02 1.03976455281743172809338915385524e-02
 	 7.63119015129594124857703718589619e-02 1.86869179476221558555693036396406e-01 7.36818919010818973447385360486805e-01 1.03976455281743172809338915385524e-02
 	 7.63119015129594124857703718589619e-02 7.36818919010818973447385360486805e-01 1.86869179476221558555693036396406e-01 1.03976455281743172809338915385524e-02
 	 7.36818919010818973447385360486805e-01 1.86869179476221558555693036396406e-01 7.63119015129594124857703718589619e-02 1.03976455281743172809338915385524e-02
 	 7.36818919010818973447385360486805e-01 7.63119015129594124857703718589619e-02 1.86869179476221558555693036396406e-01 1.03976455281743172809338915385524e-02
 	 4.14705909590306287526573214563541e-01 2.05753096537086583445175236306568e-03 5.83236559444322844036889819108183e-01 1.85714747099808273091137156285413e-03
 	 4.14705909590306287526573214563541e-01 5.83236559444322844036889819108183e-01 2.05753096537086583445175236306568e-03 1.85714747099808273091137156285413e-03
 	 2.05753096537086583445175236306568e-03 4.14705909590306287526573214563541e-01 5.83236559444322844036889819108183e-01 1.85714747099808273091137156285413e-03
 	 2.05753096537086583445175236306568e-03 5.83236559444322844036889819108183e-01 4.14705909590306287526573214563541e-01 1.85714747099808273091137156285413e-03
 	 5.83236559444322844036889819108183e-01 4.14705909590306287526573214563541e-01 2.05753096537086583445175236306568e-03 1.85714747099808273091137156285413e-03
 	 5.83236559444322844036889819108183e-01 2.05753096537086583445175236306568e-03 4.14705909590306287526573214563541e-01 1.85714747099808273091137156285413e-03
 	 3.19415305383438707931276212548255e-01 1.70478728497248960271903683860728e-01 5.10105966119312248530093256704276e-01 1.75991671806951972822918861538710e-02
 	 3.19415305383438707931276212548255e-01 5.10105966119312248530093256704276e-01 1.70478728497248960271903683860728e-01 1.75991671806951972822918861538710e-02
 	 1.70478728497248960271903683860728e-01 3.19415305383438707931276212548255e-01 5.10105966119312248530093256704276e-01 1.75991671806951972822918861538710e-02
 	 1.70478728497248960271903683860728e-01 5.10105966119312248530093256704276e-01 3.19415305383438707931276212548255e-01 1.75991671806951972822918861538710e-02
 	 5.10105966119312248530093256704276e-01 3.19415305383438707931276212548255e-01 1.70478728497248960271903683860728e-01 1.75991671806951972822918861538710e-02
 	 5.10105966119312248530093256704276e-01 1.70478728497248960271903683860728e-01 3.19415305383438707931276212548255e-01 1.75991671806951972822918861538710e-02
 	 1.43737626199764018108950835994619e-01 7.99960809148430283810338181638144e-03 8.48262765708751698134904017933877e-01 2.96676166265650350511995370084151e-03
 	 1.43737626199764018108950835994619e-01 8.48262765708751698134904017933877e-01 7.99960809148430283810338181638144e-03 2.96676166265650350511995370084151e-03
 	 7.99960809148430283810338181638144e-03 1.43737626199764018108950835994619e-01 8.48262765708751698134904017933877e-01 2.96676166265650350511995370084151e-03
 	 7.99960809148430283810338181638144e-03 8.48262765708751698134904017933877e-01 1.43737626199764018108950835994619e-01 2.96676166265650350511995370084151e-03
 	 8.48262765708751698134904017933877e-01 1.43737626199764018108950835994619e-01 7.99960809148430283810338181638144e-03 2.96676166265650350511995370084151e-03
 	 8.48262765708751698134904017933877e-01 7.99960809148430283810338181638144e-03 1.43737626199764018108950835994619e-01 2.96676166265650350511995370084151e-03
 	 2.83788138859470406849538903770735e-01 5.11658736851377873855462041774445e-02 6.65045987455391784948233180330135e-01 1.01071244320886793888192300983064e-02
 	 2.83788138859470406849538903770735e-01 6.65045987455391784948233180330135e-01 5.11658736851377873855462041774445e-02 1.01071244320886793888192300983064e-02
 	 5.11658736851377873855462041774445e-02 2.83788138859470406849538903770735e-01 6.65045987455391784948233180330135e-01 1.01071244320886793888192300983064e-02
 	 5.11658736851377873855462041774445e-02 6.65045987455391784948233180330135e-01 2.83788138859470406849538903770735e-01 1.01071244320886793888192300983064e-02
 	 6.65045987455391784948233180330135e-01 2.83788138859470406849538903770735e-01 5.11658736851377873855462041774445e-02 1.01071244320886793888192300983064e-02
 	 6.65045987455391784948233180330135e-01 5.11658736851377873855462041774445e-02 2.83788138859470406849538903770735e-01 1.01071244320886793888192300983064e-02
 	 2.16546666473477117387247403712536e-01 2.27845992508956714239776175645602e-02 7.60668734275627200780434122862061e-01 6.26933784608056481058024900221426e-03
 	 2.16546666473477117387247403712536e-01 7.60668734275627200780434122862061e-01 2.27845992508956714239776175645602e-02 6.26933784608056481058024900221426e-03
 	 2.27845992508956714239776175645602e-02 2.16546666473477117387247403712536e-01 7.60668734275627200780434122862061e-01 6.26933784608056481058024900221426e-03
 	 2.27845992508956714239776175645602e-02 7.60668734275627200780434122862061e-01 2.16546666473477117387247403712536e-01 6.26933784608056481058024900221426e-03
 	 7.60668734275627200780434122862061e-01 2.16546666473477117387247403712536e-01 2.27845992508956714239776175645602e-02 6.26933784608056481058024900221426e-03
 	 7.60668734275627200780434122862061e-01 2.27845992508956714239776175645602e-02 2.16546666473477117387247403712536e-01 6.26933784608056481058024900221426e-03
 	 3.12898503074879985597078757564304e-01 9.47329791221356194708125286751965e-03 6.77628199012906495823926888988353e-01 4.59155838739863479680547442285388e-03
 	 3.12898503074879985597078757564304e-01 6.77628199012906495823926888988353e-01 9.47329791221356194708125286751965e-03 4.59155838739863479680547442285388e-03
 	 9.47329791221356194708125286751965e-03 3.12898503074879985597078757564304e-01 6.77628199012906495823926888988353e-01 4.59155838739863479680547442285388e-03
 	 9.47329791221356194708125286751965e-03 6.77628199012906495823926888988353e-01 3.12898503074879985597078757564304e-01 4.59155838739863479680547442285388e-03
 	 6.77628199012906495823926888988353e-01 3.12898503074879985597078757564304e-01 9.47329791221356194708125286751965e-03 4.59155838739863479680547442285388e-03
 	 6.77628199012906495823926888988353e-01 9.47329791221356194708125286751965e-03 3.12898503074879985597078757564304e-01 4.59155838739863479680547442285388e-03
 	 2.26434797407717519623915336524078e-01 4.64007732175652793521480887761754e-04 7.73101194860106755157858060556464e-01 1.13954891586821264320983360107675e-03
 	 2.26434797407717519623915336524078e-01 7.73101194860106755157858060556464e-01 4.64007732175652793521480887761754e-04 1.13954891586821264320983360107675e-03
 	 4.64007732175652793521480887761754e-04 2.26434797407717519623915336524078e-01 7.73101194860106755157858060556464e-01 1.13954891586821264320983360107675e-03
 	 4.64007732175652793521480887761754e-04 7.73101194860106755157858060556464e-01 2.26434797407717519623915336524078e-01 1.13954891586821264320983360107675e-03
 	 7.73101194860106755157858060556464e-01 2.26434797407717519623915336524078e-01 4.64007732175652793521480887761754e-04 1.13954891586821264320983360107675e-03
 	 7.73101194860106755157858060556464e-01 4.64007732175652793521480887761754e-04 2.26434797407717519623915336524078e-01 1.13954891586821264320983360107675e-03
 	 ];
 
 	 case  27 

 	 % ALG. DEG.:   27
 	 % PTS CARD.:  141
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.1e-15  

 	 xyw_bar=[
 	 3.80714021181187134423851148312679e-01 3.80714021181187134423851148312679e-01 2.38571957637625731152297703374643e-01 9.56008496745992981946660194125798e-03
 	 3.80714021181187134423851148312679e-01 2.38571957637625731152297703374643e-01 3.80714021181187134423851148312679e-01 9.56008496745992981946660194125798e-03
 	 2.38571957637625731152297703374643e-01 3.80714021181187134423851148312679e-01 3.80714021181187134423851148312679e-01 9.56008496745992981946660194125798e-03
 	 4.46667803703864552122837494607666e-01 4.46667803703864552122837494607666e-01 1.06664392592270895754325010784669e-01 9.41015980945423408110528384895588e-03
 	 4.46667803703864552122837494607666e-01 1.06664392592270895754325010784669e-01 4.46667803703864552122837494607666e-01 9.41015980945423408110528384895588e-03
 	 1.06664392592270895754325010784669e-01 4.46667803703864552122837494607666e-01 4.46667803703864552122837494607666e-01 9.41015980945423408110528384895588e-03
 	 4.16141378805412132102503619535128e-01 4.16141378805412132102503619535128e-01 1.67717242389175735794992760929745e-01 1.20502270241504439579616203559453e-02
 	 4.16141378805412132102503619535128e-01 1.67717242389175735794992760929745e-01 4.16141378805412132102503619535128e-01 1.20502270241504439579616203559453e-02
 	 1.67717242389175735794992760929745e-01 4.16141378805412132102503619535128e-01 4.16141378805412132102503619535128e-01 1.20502270241504439579616203559453e-02
 	 8.03046477884382658984918634814676e-02 8.03046477884382658984918634814676e-02 8.39390704423123468203016273037065e-01 5.21262187280188173110762051010170e-03
 	 8.03046477884382658984918634814676e-02 8.39390704423123468203016273037065e-01 8.03046477884382658984918634814676e-02 5.21262187280188173110762051010170e-03
 	 8.39390704423123468203016273037065e-01 8.03046477884382658984918634814676e-02 8.03046477884382658984918634814676e-02 5.21262187280188173110762051010170e-03
 	 2.33400406669870996712035093878512e-01 2.33400406669870996712035093878512e-01 5.33199186660258006575929812242975e-01 1.34713153980493879208202301356323e-02
 	 2.33400406669870996712035093878512e-01 5.33199186660258006575929812242975e-01 2.33400406669870996712035093878512e-01 1.34713153980493879208202301356323e-02
 	 5.33199186660258006575929812242975e-01 2.33400406669870996712035093878512e-01 2.33400406669870996712035093878512e-01 1.34713153980493879208202301356323e-02
 	 3.01165465166509105365832965617301e-01 3.01165465166509105365832965617301e-01 3.97669069666981789268334068765398e-01 1.57479657813626716666988158976892e-02
 	 3.01165465166509105365832965617301e-01 3.97669069666981789268334068765398e-01 3.01165465166509105365832965617301e-01 1.57479657813626716666988158976892e-02
 	 3.97669069666981789268334068765398e-01 3.01165465166509105365832965617301e-01 3.01165465166509105365832965617301e-01 1.57479657813626716666988158976892e-02
 	 1.74779966354899979341652738185076e-01 1.74779966354899979341652738185076e-01 6.50440067290199985805543292372022e-01 1.12824425446983907239673072808728e-02
 	 1.74779966354899979341652738185076e-01 6.50440067290199985805543292372022e-01 1.74779966354899979341652738185076e-01 1.12824425446983907239673072808728e-02
 	 6.50440067290199985805543292372022e-01 1.74779966354899979341652738185076e-01 1.74779966354899979341652738185076e-01 1.12824425446983907239673072808728e-02
 	 4.85565054185162769950778738348163e-01 4.85565054185162769950778738348163e-01 2.88698916296744600984425233036745e-02 7.11723741287464874843982087782024e-03
 	 4.85565054185162769950778738348163e-01 2.88698916296744600984425233036745e-02 4.85565054185162769950778738348163e-01 7.11723741287464874843982087782024e-03
 	 2.88698916296744600984425233036745e-02 4.85565054185162769950778738348163e-01 4.85565054185162769950778738348163e-01 7.11723741287464874843982087782024e-03
 	 3.25715201801814874249529907501710e-02 3.25715201801814874249529907501710e-02 9.34856959639636997394518402870744e-01 2.77733952895418360201640339823825e-03
 	 3.25715201801814874249529907501710e-02 9.34856959639636997394518402870744e-01 3.25715201801814874249529907501710e-02 2.77733952895418360201640339823825e-03
 	 9.34856959639636997394518402870744e-01 3.25715201801814874249529907501710e-02 3.25715201801814874249529907501710e-02 2.77733952895418360201640339823825e-03
 	 1.27570901904677458382764143607346e-01 1.27570901904677458382764143607346e-01 7.44858196190645083234471712785307e-01 9.74324492281774048874076754600537e-03
 	 1.27570901904677458382764143607346e-01 7.44858196190645083234471712785307e-01 1.27570901904677458382764143607346e-01 9.74324492281774048874076754600537e-03
 	 7.44858196190645083234471712785307e-01 1.27570901904677458382764143607346e-01 1.27570901904677458382764143607346e-01 9.74324492281774048874076754600537e-03
 	 6.63921918095859882325004974745752e-03 6.63921918095859882325004974745752e-03 9.86721561638082778067371236829786e-01 5.75442405670502951479938769097089e-04
 	 6.63921918095859882325004974745752e-03 9.86721561638082778067371236829786e-01 6.63921918095859882325004974745752e-03 5.75442405670502951479938769097089e-04
 	 9.86721561638082778067371236829786e-01 6.63921918095859882325004974745752e-03 6.63921918095859882325004974745752e-03 5.75442405670502951479938769097089e-04
 	 2.87042196593496612422313774004579e-01 3.07306047272728651009732203647218e-02 6.82227198679230539823947765398771e-01 5.53179483376673754302377261637957e-03
 	 2.87042196593496612422313774004579e-01 6.82227198679230539823947765398771e-01 3.07306047272728651009732203647218e-02 5.53179483376673754302377261637957e-03
 	 3.07306047272728651009732203647218e-02 2.87042196593496612422313774004579e-01 6.82227198679230539823947765398771e-01 5.53179483376673754302377261637957e-03
 	 3.07306047272728651009732203647218e-02 6.82227198679230539823947765398771e-01 2.87042196593496612422313774004579e-01 5.53179483376673754302377261637957e-03
 	 6.82227198679230539823947765398771e-01 2.87042196593496612422313774004579e-01 3.07306047272728651009732203647218e-02 5.53179483376673754302377261637957e-03
 	 6.82227198679230539823947765398771e-01 3.07306047272728651009732203647218e-02 2.87042196593496612422313774004579e-01 5.53179483376673754302377261637957e-03
 	 3.45087841715568388600843263702700e-01 1.29152640063449730689626449020579e-01 5.25759518220981880709530287276721e-01 1.25574362040365497539262662485271e-02
 	 3.45087841715568388600843263702700e-01 5.25759518220981880709530287276721e-01 1.29152640063449730689626449020579e-01 1.25574362040365497539262662485271e-02
 	 1.29152640063449730689626449020579e-01 3.45087841715568388600843263702700e-01 5.25759518220981880709530287276721e-01 1.25574362040365497539262662485271e-02
 	 1.29152640063449730689626449020579e-01 5.25759518220981880709530287276721e-01 3.45087841715568388600843263702700e-01 1.25574362040365497539262662485271e-02
 	 5.25759518220981880709530287276721e-01 3.45087841715568388600843263702700e-01 1.29152640063449730689626449020579e-01 1.25574362040365497539262662485271e-02
 	 5.25759518220981880709530287276721e-01 1.29152640063449730689626449020579e-01 3.45087841715568388600843263702700e-01 1.25574362040365497539262662485271e-02
 	 3.75930157048661783836251970569720e-01 2.80334860952500125597097735408170e-02 5.96036356856088245237401679332834e-01 6.39515269945440875676290204410179e-03
 	 3.75930157048661783836251970569720e-01 5.96036356856088245237401679332834e-01 2.80334860952500125597097735408170e-02 6.39515269945440875676290204410179e-03
 	 2.80334860952500125597097735408170e-02 3.75930157048661783836251970569720e-01 5.96036356856088245237401679332834e-01 6.39515269945440875676290204410179e-03
 	 2.80334860952500125597097735408170e-02 5.96036356856088245237401679332834e-01 3.75930157048661783836251970569720e-01 6.39515269945440875676290204410179e-03
 	 5.96036356856088245237401679332834e-01 3.75930157048661783836251970569720e-01 2.80334860952500125597097735408170e-02 6.39515269945440875676290204410179e-03
 	 5.96036356856088245237401679332834e-01 2.80334860952500125597097735408170e-02 3.75930157048661783836251970569720e-01 6.39515269945440875676290204410179e-03
 	 3.16945588933131960907019220030634e-01 2.09130921137668762677108702519035e-01 4.73923489929199304171447693079244e-01 1.37153932305508520494985447157887e-02
 	 3.16945588933131960907019220030634e-01 4.73923489929199304171447693079244e-01 2.09130921137668762677108702519035e-01 1.37153932305508520494985447157887e-02
 	 2.09130921137668762677108702519035e-01 3.16945588933131960907019220030634e-01 4.73923489929199304171447693079244e-01 1.37153932305508520494985447157887e-02
 	 2.09130921137668762677108702519035e-01 4.73923489929199304171447693079244e-01 3.16945588933131960907019220030634e-01 1.37153932305508520494985447157887e-02
 	 4.73923489929199304171447693079244e-01 3.16945588933131960907019220030634e-01 2.09130921137668762677108702519035e-01 1.37153932305508520494985447157887e-02
 	 4.73923489929199304171447693079244e-01 2.09130921137668762677108702519035e-01 3.16945588933131960907019220030634e-01 1.37153932305508520494985447157887e-02
 	 4.07228393042719849503896512032952e-01 6.60389128497386734828467069746694e-02 5.26732694107541421502105549734551e-01 9.86227011898957797719766915633954e-03
 	 4.07228393042719849503896512032952e-01 5.26732694107541421502105549734551e-01 6.60389128497386734828467069746694e-02 9.86227011898957797719766915633954e-03
 	 6.60389128497386734828467069746694e-02 4.07228393042719849503896512032952e-01 5.26732694107541421502105549734551e-01 9.86227011898957797719766915633954e-03
 	 6.60389128497386734828467069746694e-02 5.26732694107541421502105549734551e-01 4.07228393042719849503896512032952e-01 9.86227011898957797719766915633954e-03
 	 5.26732694107541421502105549734551e-01 4.07228393042719849503896512032952e-01 6.60389128497386734828467069746694e-02 9.86227011898957797719766915633954e-03
 	 5.26732694107541421502105549734551e-01 6.60389128497386734828467069746694e-02 4.07228393042719849503896512032952e-01 9.86227011898957797719766915633954e-03
 	 2.13553598457823928802312707375677e-01 4.10305768191818395762560101047711e-02 7.45415824722994169171386147354497e-01 6.45537290492969630106845357886414e-03
 	 2.13553598457823928802312707375677e-01 7.45415824722994169171386147354497e-01 4.10305768191818395762560101047711e-02 6.45537290492969630106845357886414e-03
 	 4.10305768191818395762560101047711e-02 2.13553598457823928802312707375677e-01 7.45415824722994169171386147354497e-01 6.45537290492969630106845357886414e-03
 	 4.10305768191818395762560101047711e-02 7.45415824722994169171386147354497e-01 2.13553598457823928802312707375677e-01 6.45537290492969630106845357886414e-03
 	 7.45415824722994169171386147354497e-01 2.13553598457823928802312707375677e-01 4.10305768191818395762560101047711e-02 6.45537290492969630106845357886414e-03
 	 7.45415824722994169171386147354497e-01 4.10305768191818395762560101047711e-02 2.13553598457823928802312707375677e-01 6.45537290492969630106845357886414e-03
 	 3.28852878068892628959929425036535e-01 5.29964037179903642987843781497759e-03 6.65847481559308285170573071809486e-01 2.92782636179910512458368643251561e-03
 	 3.28852878068892628959929425036535e-01 6.65847481559308285170573071809486e-01 5.29964037179903642987843781497759e-03 2.92782636179910512458368643251561e-03
 	 5.29964037179903642987843781497759e-03 3.28852878068892628959929425036535e-01 6.65847481559308285170573071809486e-01 2.92782636179910512458368643251561e-03
 	 5.29964037179903642987843781497759e-03 6.65847481559308285170573071809486e-01 3.28852878068892628959929425036535e-01 2.92782636179910512458368643251561e-03
 	 6.65847481559308285170573071809486e-01 3.28852878068892628959929425036535e-01 5.29964037179903642987843781497759e-03 2.92782636179910512458368643251561e-03
 	 6.65847481559308285170573071809486e-01 5.29964037179903642987843781497759e-03 3.28852878068892628959929425036535e-01 2.92782636179910512458368643251561e-03
 	 1.39295306142148717087891895971552e-01 6.30739954149509007841345464839833e-02 7.97630698442900465394700404431205e-01 7.13063531048703080211792482145938e-03
 	 1.39295306142148717087891895971552e-01 7.97630698442900465394700404431205e-01 6.30739954149509007841345464839833e-02 7.13063531048703080211792482145938e-03
 	 6.30739954149509007841345464839833e-02 1.39295306142148717087891895971552e-01 7.97630698442900465394700404431205e-01 7.13063531048703080211792482145938e-03
 	 6.30739954149509007841345464839833e-02 7.97630698442900465394700404431205e-01 1.39295306142148717087891895971552e-01 7.13063531048703080211792482145938e-03
 	 7.97630698442900465394700404431205e-01 1.39295306142148717087891895971552e-01 6.30739954149509007841345464839833e-02 7.13063531048703080211792482145938e-03
 	 7.97630698442900465394700404431205e-01 6.30739954149509007841345464839833e-02 1.39295306142148717087891895971552e-01 7.13063531048703080211792482145938e-03
 	 2.55246254696978036591303862223867e-01 1.48962850938240159992531630450685e-01 5.95790894364781831171740122954361e-01 1.23476631308613738619017752284890e-02
 	 2.55246254696978036591303862223867e-01 5.95790894364781831171740122954361e-01 1.48962850938240159992531630450685e-01 1.23476631308613738619017752284890e-02
 	 1.48962850938240159992531630450685e-01 2.55246254696978036591303862223867e-01 5.95790894364781831171740122954361e-01 1.23476631308613738619017752284890e-02
 	 1.48962850938240159992531630450685e-01 5.95790894364781831171740122954361e-01 2.55246254696978036591303862223867e-01 1.23476631308613738619017752284890e-02
 	 5.95790894364781831171740122954361e-01 2.55246254696978036591303862223867e-01 1.48962850938240159992531630450685e-01 1.23476631308613738619017752284890e-02
 	 5.95790894364781831171740122954361e-01 1.48962850938240159992531630450685e-01 2.55246254696978036591303862223867e-01 1.23476631308613738619017752284890e-02
 	 2.08376015600374053793331086126273e-01 9.46970824331307137189384093289846e-02 6.96926901966495315754457351431483e-01 1.06937005896162729001730440359097e-02
 	 2.08376015600374053793331086126273e-01 6.96926901966495315754457351431483e-01 9.46970824331307137189384093289846e-02 1.06937005896162729001730440359097e-02
 	 9.46970824331307137189384093289846e-02 2.08376015600374053793331086126273e-01 6.96926901966495315754457351431483e-01 1.06937005896162729001730440359097e-02
 	 9.46970824331307137189384093289846e-02 6.96926901966495315754457351431483e-01 2.08376015600374053793331086126273e-01 1.06937005896162729001730440359097e-02
 	 6.96926901966495315754457351431483e-01 2.08376015600374053793331086126273e-01 9.46970824331307137189384093289846e-02 1.06937005896162729001730440359097e-02
 	 6.96926901966495315754457351431483e-01 9.46970824331307137189384093289846e-02 2.08376015600374053793331086126273e-01 1.06937005896162729001730440359097e-02
 	 4.40010551946215466845302444198751e-01 5.58071701526011761801404631455625e-03 5.54408731038524504874942522292258e-01 3.24246759763934400827567472447299e-03
 	 4.40010551946215466845302444198751e-01 5.54408731038524504874942522292258e-01 5.58071701526011761801404631455625e-03 3.24246759763934400827567472447299e-03
 	 5.58071701526011761801404631455625e-03 4.40010551946215466845302444198751e-01 5.54408731038524504874942522292258e-01 3.24246759763934400827567472447299e-03
 	 5.58071701526011761801404631455625e-03 5.54408731038524504874942522292258e-01 4.40010551946215466845302444198751e-01 3.24246759763934400827567472447299e-03
 	 5.54408731038524504874942522292258e-01 4.40010551946215466845302444198751e-01 5.58071701526011761801404631455625e-03 3.24246759763934400827567472447299e-03
 	 5.54408731038524504874942522292258e-01 5.58071701526011761801404631455625e-03 4.40010551946215466845302444198751e-01 3.24246759763934400827567472447299e-03
 	 3.02220941227821116026319714364945e-01 7.50769024331962436802356819498527e-02 6.22702156338982626415656795870746e-01 1.09306110929132949127762231000816e-02
 	 3.02220941227821116026319714364945e-01 6.22702156338982626415656795870746e-01 7.50769024331962436802356819498527e-02 1.09306110929132949127762231000816e-02
 	 7.50769024331962436802356819498527e-02 3.02220941227821116026319714364945e-01 6.22702156338982626415656795870746e-01 1.09306110929132949127762231000816e-02
 	 7.50769024331962436802356819498527e-02 6.22702156338982626415656795870746e-01 3.02220941227821116026319714364945e-01 1.09306110929132949127762231000816e-02
 	 6.22702156338982626415656795870746e-01 3.02220941227821116026319714364945e-01 7.50769024331962436802356819498527e-02 1.09306110929132949127762231000816e-02
 	 6.22702156338982626415656795870746e-01 7.50769024331962436802356819498527e-02 3.02220941227821116026319714364945e-01 1.09306110929132949127762231000816e-02
 	 8.19468025835336788542662134204875e-02 6.98252932445901815239341914320903e-03 9.11070668092007318605851651227567e-01 2.01512312728970412536999567976181e-03
 	 8.19468025835336788542662134204875e-02 9.11070668092007318605851651227567e-01 6.98252932445901815239341914320903e-03 2.01512312728970412536999567976181e-03
 	 6.98252932445901815239341914320903e-03 8.19468025835336788542662134204875e-02 9.11070668092007318605851651227567e-01 2.01512312728970412536999567976181e-03
 	 6.98252932445901815239341914320903e-03 9.11070668092007318605851651227567e-01 8.19468025835336788542662134204875e-02 2.01512312728970412536999567976181e-03
 	 9.11070668092007318605851651227567e-01 8.19468025835336788542662134204875e-02 6.98252932445901815239341914320903e-03 2.01512312728970412536999567976181e-03
 	 9.11070668092007318605851651227567e-01 6.98252932445901815239341914320903e-03 8.19468025835336788542662134204875e-02 2.01512312728970412536999567976181e-03
 	 3.43649699121419890945894337619393e-02 6.09356940376483413590591453612433e-03 9.59541460684093183708398555609165e-01 1.19677360847316393253902955251533e-03
 	 3.43649699121419890945894337619393e-02 9.59541460684093183708398555609165e-01 6.09356940376483413590591453612433e-03 1.19677360847316393253902955251533e-03
 	 6.09356940376483413590591453612433e-03 3.43649699121419890945894337619393e-02 9.59541460684093183708398555609165e-01 1.19677360847316393253902955251533e-03
 	 6.09356940376483413590591453612433e-03 9.59541460684093183708398555609165e-01 3.43649699121419890945894337619393e-02 1.19677360847316393253902955251533e-03
 	 9.59541460684093183708398555609165e-01 3.43649699121419890945894337619393e-02 6.09356940376483413590591453612433e-03 1.19677360847316393253902955251533e-03
 	 9.59541460684093183708398555609165e-01 6.09356940376483413590591453612433e-03 3.43649699121419890945894337619393e-02 1.19677360847316393253902955251533e-03
 	 8.01120738471011173409408456791425e-02 3.50344225276973952887260566058103e-02 8.84853503625201542881484328972874e-01 4.32715803536071717816380299836965e-03
 	 8.01120738471011173409408456791425e-02 8.84853503625201542881484328972874e-01 3.50344225276973952887260566058103e-02 4.32715803536071717816380299836965e-03
 	 3.50344225276973952887260566058103e-02 8.01120738471011173409408456791425e-02 8.84853503625201542881484328972874e-01 4.32715803536071717816380299836965e-03
 	 3.50344225276973952887260566058103e-02 8.84853503625201542881484328972874e-01 8.01120738471011173409408456791425e-02 4.32715803536071717816380299836965e-03
 	 8.84853503625201542881484328972874e-01 8.01120738471011173409408456791425e-02 3.50344225276973952887260566058103e-02 4.32715803536071717816380299836965e-03
 	 8.84853503625201542881484328972874e-01 3.50344225276973952887260566058103e-02 8.01120738471011173409408456791425e-02 4.32715803536071717816380299836965e-03
 	 1.47213431898922469942547763821494e-01 1.93520013180389742479814429998441e-02 8.33434566783038621728962880297331e-01 4.62238711178111424948689034408744e-03
 	 1.47213431898922469942547763821494e-01 8.33434566783038621728962880297331e-01 1.93520013180389742479814429998441e-02 4.62238711178111424948689034408744e-03
 	 1.93520013180389742479814429998441e-02 1.47213431898922469942547763821494e-01 8.33434566783038621728962880297331e-01 4.62238711178111424948689034408744e-03
 	 1.93520013180389742479814429998441e-02 8.33434566783038621728962880297331e-01 1.47213431898922469942547763821494e-01 4.62238711178111424948689034408744e-03
 	 8.33434566783038621728962880297331e-01 1.47213431898922469942547763821494e-01 1.93520013180389742479814429998441e-02 4.62238711178111424948689034408744e-03
 	 8.33434566783038621728962880297331e-01 1.93520013180389742479814429998441e-02 1.47213431898922469942547763821494e-01 4.62238711178111424948689034408744e-03
 	 2.29719653257843214877453874578350e-01 7.33247254904045766416009755062078e-03 7.62947874193116382102175521140452e-01 3.39425373880703059800700849280020e-03
 	 2.29719653257843214877453874578350e-01 7.62947874193116382102175521140452e-01 7.33247254904045766416009755062078e-03 3.39425373880703059800700849280020e-03
 	 7.33247254904045766416009755062078e-03 2.29719653257843214877453874578350e-01 7.62947874193116382102175521140452e-01 3.39425373880703059800700849280020e-03
 	 7.33247254904045766416009755062078e-03 7.62947874193116382102175521140452e-01 2.29719653257843214877453874578350e-01 3.39425373880703059800700849280020e-03
 	 7.62947874193116382102175521140452e-01 2.29719653257843214877453874578350e-01 7.33247254904045766416009755062078e-03 3.39425373880703059800700849280020e-03
 	 7.62947874193116382102175521140452e-01 7.33247254904045766416009755062078e-03 2.29719653257843214877453874578350e-01 3.39425373880703059800700849280020e-03
 	 1.47655521119869792556755783152767e-01 4.90328443462974511261875942835786e-04 8.51854150436667234558285599632654e-01 8.46606135763851405835744845518320e-04
 	 1.47655521119869792556755783152767e-01 8.51854150436667234558285599632654e-01 4.90328443462974511261875942835786e-04 8.46606135763851405835744845518320e-04
 	 4.90328443462974511261875942835786e-04 1.47655521119869792556755783152767e-01 8.51854150436667234558285599632654e-01 8.46606135763851405835744845518320e-04
 	 4.90328443462974511261875942835786e-04 8.51854150436667234558285599632654e-01 1.47655521119869792556755783152767e-01 8.46606135763851405835744845518320e-04
 	 8.51854150436667234558285599632654e-01 1.47655521119869792556755783152767e-01 4.90328443462974511261875942835786e-04 8.46606135763851405835744845518320e-04
 	 8.51854150436667234558285599632654e-01 4.90328443462974511261875942835786e-04 1.47655521119869792556755783152767e-01 8.46606135763851405835744845518320e-04
 	 ];
 
 	 case  28 

 	 % ALG. DEG.:   28
 	 % PTS CARD.:  150
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw_bar=[
 	 3.03982922516484066477460146415979e-01 3.03982922516484066477460146415979e-01 3.92034154967031867045079707168043e-01 1.43624663006461355391207845855206e-02
 	 3.03982922516484066477460146415979e-01 3.92034154967031867045079707168043e-01 3.03982922516484066477460146415979e-01 1.43624663006461355391207845855206e-02
 	 3.92034154967031867045079707168043e-01 3.03982922516484066477460146415979e-01 3.03982922516484066477460146415979e-01 1.43624663006461355391207845855206e-02
 	 4.80412619665786157913123233242914e-03 4.80412619665786157913123233242914e-03 9.90391747606684247351438443729421e-01 3.11135208681496380940523227565109e-04
 	 4.80412619665786157913123233242914e-03 9.90391747606684247351438443729421e-01 4.80412619665786157913123233242914e-03 3.11135208681496380940523227565109e-04
 	 9.90391747606684247351438443729421e-01 4.80412619665786157913123233242914e-03 4.80412619665786157913123233242914e-03 3.11135208681496380940523227565109e-04
 	 4.58279904240411928295628740670509e-01 4.58279904240411928295628740670509e-01 8.34401915191761434087425186589826e-02 8.85170501089316275056262384168804e-03
 	 4.58279904240411928295628740670509e-01 8.34401915191761434087425186589826e-02 4.58279904240411928295628740670509e-01 8.85170501089316275056262384168804e-03
 	 8.34401915191761434087425186589826e-02 4.58279904240411928295628740670509e-01 4.58279904240411928295628740670509e-01 8.85170501089316275056262384168804e-03
 	 3.86267973570042055797557623009197e-01 3.86267973570042055797557623009197e-01 2.27464052859915888404884753981605e-01 1.42105863904481901499599061367007e-02
 	 3.86267973570042055797557623009197e-01 2.27464052859915888404884753981605e-01 3.86267973570042055797557623009197e-01 1.42105863904481901499599061367007e-02
 	 2.27464052859915888404884753981605e-01 3.86267973570042055797557623009197e-01 3.86267973570042055797557623009197e-01 1.42105863904481901499599061367007e-02
 	 2.58264072150462098420575784984976e-01 2.58264072150462098420575784984976e-01 4.83471855699075803158848430030048e-01 1.30927485890889698516570405217863e-02
 	 2.58264072150462098420575784984976e-01 4.83471855699075803158848430030048e-01 2.58264072150462098420575784984976e-01 1.30927485890889698516570405217863e-02
 	 4.83471855699075803158848430030048e-01 2.58264072150462098420575784984976e-01 2.58264072150462098420575784984976e-01 1.30927485890889698516570405217863e-02
 	 1.05895844178627504539313974873949e-01 1.05895844178627504539313974873949e-01 7.88208311642744963165796434623189e-01 7.80994337108634282401675719142986e-03
 	 1.05895844178627504539313974873949e-01 7.88208311642744963165796434623189e-01 1.05895844178627504539313974873949e-01 7.80994337108634282401675719142986e-03
 	 7.88208311642744963165796434623189e-01 1.05895844178627504539313974873949e-01 1.05895844178627504539313974873949e-01 7.80994337108634282401675719142986e-03
 	 4.29552202118899328908696588769089e-01 4.29552202118899328908696588769089e-01 1.40895595762201342182606822461821e-01 1.35475956033255118954317097745843e-02
 	 4.29552202118899328908696588769089e-01 1.40895595762201342182606822461821e-01 4.29552202118899328908696588769089e-01 1.35475956033255118954317097745843e-02
 	 1.40895595762201342182606822461821e-01 4.29552202118899328908696588769089e-01 4.29552202118899328908696588769089e-01 1.35475956033255118954317097745843e-02
 	 4.84841132562589427479338155535515e-01 4.84841132562589427479338155535515e-01 3.03177348748211450413236889289692e-02 7.68211057859502499667314623366110e-03
 	 4.84841132562589427479338155535515e-01 3.03177348748211450413236889289692e-02 4.84841132562589427479338155535515e-01 7.68211057859502499667314623366110e-03
 	 3.03177348748211450413236889289692e-02 4.84841132562589427479338155535515e-01 4.84841132562589427479338155535515e-01 7.68211057859502499667314623366110e-03
 	 1.58637688863059594934767915219709e-01 1.58637688863059594934767915219709e-01 6.82724622273880754619312938302755e-01 1.19426696402482306752501628466234e-02
 	 1.58637688863059594934767915219709e-01 6.82724622273880754619312938302755e-01 1.58637688863059594934767915219709e-01 1.19426696402482306752501628466234e-02
 	 6.82724622273880754619312938302755e-01 1.58637688863059594934767915219709e-01 1.58637688863059594934767915219709e-01 1.19426696402482306752501628466234e-02
 	 6.08391923927586036890957643663569e-02 6.08391923927586036890957643663569e-02 8.78321615214482820377384086896200e-01 5.12825200467806937426606950225505e-03
 	 6.08391923927586036890957643663569e-02 8.78321615214482820377384086896200e-01 6.08391923927586036890957643663569e-02 5.12825200467806937426606950225505e-03
 	 8.78321615214482820377384086896200e-01 6.08391923927586036890957643663569e-02 6.08391923927586036890957643663569e-02 5.12825200467806937426606950225505e-03
 	 4.55054005583463913597874750394112e-02 2.15243853694561254608075273608847e-02 9.32970214072197490118298901506932e-01 2.11753955768089873606951911710894e-03
 	 4.55054005583463913597874750394112e-02 9.32970214072197490118298901506932e-01 2.15243853694561254608075273608847e-02 2.11753955768089873606951911710894e-03
 	 2.15243853694561254608075273608847e-02 4.55054005583463913597874750394112e-02 9.32970214072197490118298901506932e-01 2.11753955768089873606951911710894e-03
 	 2.15243853694561254608075273608847e-02 9.32970214072197490118298901506932e-01 4.55054005583463913597874750394112e-02 2.11753955768089873606951911710894e-03
 	 9.32970214072197490118298901506932e-01 4.55054005583463913597874750394112e-02 2.15243853694561254608075273608847e-02 2.11753955768089873606951911710894e-03
 	 9.32970214072197490118298901506932e-01 2.15243853694561254608075273608847e-02 4.55054005583463913597874750394112e-02 2.11753955768089873606951911710894e-03
 	 2.13394454767087293767247047071578e-01 4.90696693575595060954341875003593e-02 7.37535875875353186259530957613606e-01 5.89567223451424680252808130376252e-03
 	 2.13394454767087293767247047071578e-01 7.37535875875353186259530957613606e-01 4.90696693575595060954341875003593e-02 5.89567223451424680252808130376252e-03
 	 4.90696693575595060954341875003593e-02 2.13394454767087293767247047071578e-01 7.37535875875353186259530957613606e-01 5.89567223451424680252808130376252e-03
 	 4.90696693575595060954341875003593e-02 7.37535875875353186259530957613606e-01 2.13394454767087293767247047071578e-01 5.89567223451424680252808130376252e-03
 	 7.37535875875353186259530957613606e-01 2.13394454767087293767247047071578e-01 4.90696693575595060954341875003593e-02 5.89567223451424680252808130376252e-03
 	 7.37535875875353186259530957613606e-01 4.90696693575595060954341875003593e-02 2.13394454767087293767247047071578e-01 5.89567223451424680252808130376252e-03
 	 2.42102511919319640654180147976149e-01 1.77658450296370312715410477721889e-01 5.80239037784310074385984989930876e-01 1.25572562166768805780314721687319e-02
 	 2.42102511919319640654180147976149e-01 5.80239037784310074385984989930876e-01 1.77658450296370312715410477721889e-01 1.25572562166768805780314721687319e-02
 	 1.77658450296370312715410477721889e-01 2.42102511919319640654180147976149e-01 5.80239037784310074385984989930876e-01 1.25572562166768805780314721687319e-02
 	 1.77658450296370312715410477721889e-01 5.80239037784310074385984989930876e-01 2.42102511919319640654180147976149e-01 1.25572562166768805780314721687319e-02
 	 5.80239037784310074385984989930876e-01 2.42102511919319640654180147976149e-01 1.77658450296370312715410477721889e-01 1.25572562166768805780314721687319e-02
 	 5.80239037784310074385984989930876e-01 1.77658450296370312715410477721889e-01 2.42102511919319640654180147976149e-01 1.25572562166768805780314721687319e-02
 	 3.27190732019169983058048956081620e-01 1.89812356292736877927396221821255e-01 4.82996911688093111258979206468211e-01 1.31061141240993873219311538491638e-02
 	 3.27190732019169983058048956081620e-01 4.82996911688093111258979206468211e-01 1.89812356292736877927396221821255e-01 1.31061141240993873219311538491638e-02
 	 1.89812356292736877927396221821255e-01 3.27190732019169983058048956081620e-01 4.82996911688093111258979206468211e-01 1.31061141240993873219311538491638e-02
 	 1.89812356292736877927396221821255e-01 4.82996911688093111258979206468211e-01 3.27190732019169983058048956081620e-01 1.31061141240993873219311538491638e-02
 	 4.82996911688093111258979206468211e-01 3.27190732019169983058048956081620e-01 1.89812356292736877927396221821255e-01 1.31061141240993873219311538491638e-02
 	 4.82996911688093111258979206468211e-01 1.89812356292736877927396221821255e-01 3.27190732019169983058048956081620e-01 1.31061141240993873219311538491638e-02
 	 1.41998166933174241322035413759295e-01 4.45838202328932217688439720859606e-03 8.53543451043536460787208852707408e-01 1.77889541925551372507363634412059e-03
 	 1.41998166933174241322035413759295e-01 8.53543451043536460787208852707408e-01 4.45838202328932217688439720859606e-03 1.77889541925551372507363634412059e-03
 	 4.45838202328932217688439720859606e-03 1.41998166933174241322035413759295e-01 8.53543451043536460787208852707408e-01 1.77889541925551372507363634412059e-03
 	 4.45838202328932217688439720859606e-03 8.53543451043536460787208852707408e-01 1.41998166933174241322035413759295e-01 1.77889541925551372507363634412059e-03
 	 8.53543451043536460787208852707408e-01 1.41998166933174241322035413759295e-01 4.45838202328932217688439720859606e-03 1.77889541925551372507363634412059e-03
 	 8.53543451043536460787208852707408e-01 4.45838202328932217688439720859606e-03 1.41998166933174241322035413759295e-01 1.77889541925551372507363634412059e-03
 	 1.75396393191461719140988861909136e-01 8.76779764843520492689776801853441e-02 7.36925630324186231590033457905520e-01 8.01192928669496387539261661459022e-03
 	 1.75396393191461719140988861909136e-01 7.36925630324186231590033457905520e-01 8.76779764843520492689776801853441e-02 8.01192928669496387539261661459022e-03
 	 8.76779764843520492689776801853441e-02 1.75396393191461719140988861909136e-01 7.36925630324186231590033457905520e-01 8.01192928669496387539261661459022e-03
 	 8.76779764843520492689776801853441e-02 7.36925630324186231590033457905520e-01 1.75396393191461719140988861909136e-01 8.01192928669496387539261661459022e-03
 	 7.36925630324186231590033457905520e-01 1.75396393191461719140988861909136e-01 8.76779764843520492689776801853441e-02 8.01192928669496387539261661459022e-03
 	 7.36925630324186231590033457905520e-01 8.76779764843520492689776801853441e-02 1.75396393191461719140988861909136e-01 8.01192928669496387539261661459022e-03
 	 3.92139613334414494083546287583886e-01 6.31803276344106712336667897034204e-02 5.44680059031174890193938153970521e-01 8.46469573427660604281186351727229e-03
 	 3.92139613334414494083546287583886e-01 5.44680059031174890193938153970521e-01 6.31803276344106712336667897034204e-02 8.46469573427660604281186351727229e-03
 	 6.31803276344106712336667897034204e-02 3.92139613334414494083546287583886e-01 5.44680059031174890193938153970521e-01 8.46469573427660604281186351727229e-03
 	 6.31803276344106712336667897034204e-02 5.44680059031174890193938153970521e-01 3.92139613334414494083546287583886e-01 8.46469573427660604281186351727229e-03
 	 5.44680059031174890193938153970521e-01 3.92139613334414494083546287583886e-01 6.31803276344106712336667897034204e-02 8.46469573427660604281186351727229e-03
 	 5.44680059031174890193938153970521e-01 6.31803276344106712336667897034204e-02 3.92139613334414494083546287583886e-01 8.46469573427660604281186351727229e-03
 	 3.34145615035921328406232078123139e-01 4.14946413392367364353363612394787e-03 6.61704920830154974531467360066017e-01 2.37676426768778379164381853172472e-03
 	 3.34145615035921328406232078123139e-01 6.61704920830154974531467360066017e-01 4.14946413392367364353363612394787e-03 2.37676426768778379164381853172472e-03
 	 4.14946413392367364353363612394787e-03 3.34145615035921328406232078123139e-01 6.61704920830154974531467360066017e-01 2.37676426768778379164381853172472e-03
 	 4.14946413392367364353363612394787e-03 6.61704920830154974531467360066017e-01 3.34145615035921328406232078123139e-01 2.37676426768778379164381853172472e-03
 	 6.61704920830154974531467360066017e-01 3.34145615035921328406232078123139e-01 4.14946413392367364353363612394787e-03 2.37676426768778379164381853172472e-03
 	 6.61704920830154974531467360066017e-01 4.14946413392367364353363612394787e-03 3.34145615035921328406232078123139e-01 2.37676426768778379164381853172472e-03
 	 1.74146196051182144959312836363097e-01 2.27948049259162482949037098478584e-02 8.03058999022901676134722492861329e-01 4.27694233501794539992202359712792e-03
 	 1.74146196051182144959312836363097e-01 8.03058999022901676134722492861329e-01 2.27948049259162482949037098478584e-02 4.27694233501794539992202359712792e-03
 	 2.27948049259162482949037098478584e-02 1.74146196051182144959312836363097e-01 8.03058999022901676134722492861329e-01 4.27694233501794539992202359712792e-03
 	 2.27948049259162482949037098478584e-02 8.03058999022901676134722492861329e-01 1.74146196051182144959312836363097e-01 4.27694233501794539992202359712792e-03
 	 8.03058999022901676134722492861329e-01 1.74146196051182144959312836363097e-01 2.27948049259162482949037098478584e-02 4.27694233501794539992202359712792e-03
 	 8.03058999022901676134722492861329e-01 2.27948049259162482949037098478584e-02 1.74146196051182144959312836363097e-01 4.27694233501794539992202359712792e-03
 	 2.75839008071824209888944778867881e-01 2.27008443717970145869777809366497e-02 7.01460147556378754707395728473784e-01 5.13127738203729769073113686772558e-03
 	 2.75839008071824209888944778867881e-01 7.01460147556378754707395728473784e-01 2.27008443717970145869777809366497e-02 5.13127738203729769073113686772558e-03
 	 2.27008443717970145869777809366497e-02 2.75839008071824209888944778867881e-01 7.01460147556378754707395728473784e-01 5.13127738203729769073113686772558e-03
 	 2.27008443717970145869777809366497e-02 7.01460147556378754707395728473784e-01 2.75839008071824209888944778867881e-01 5.13127738203729769073113686772558e-03
 	 7.01460147556378754707395728473784e-01 2.75839008071824209888944778867881e-01 2.27008443717970145869777809366497e-02 5.13127738203729769073113686772558e-03
 	 7.01460147556378754707395728473784e-01 2.27008443717970145869777809366497e-02 2.75839008071824209888944778867881e-01 5.13127738203729769073113686772558e-03
 	 2.62226671646522725700467759679668e-02 6.14964854266397079746164777702688e-03 9.67627684292683754030406362289796e-01 9.48540425889400672446183371278039e-04
 	 2.62226671646522725700467759679668e-02 9.67627684292683754030406362289796e-01 6.14964854266397079746164777702688e-03 9.48540425889400672446183371278039e-04
 	 6.14964854266397079746164777702688e-03 2.62226671646522725700467759679668e-02 9.67627684292683754030406362289796e-01 9.48540425889400672446183371278039e-04
 	 6.14964854266397079746164777702688e-03 9.67627684292683754030406362289796e-01 2.62226671646522725700467759679668e-02 9.48540425889400672446183371278039e-04
 	 9.67627684292683754030406362289796e-01 2.62226671646522725700467759679668e-02 6.14964854266397079746164777702688e-03 9.48540425889400672446183371278039e-04
 	 9.67627684292683754030406362289796e-01 6.14964854266397079746164777702688e-03 2.62226671646522725700467759679668e-02 9.48540425889400672446183371278039e-04
 	 2.43047202365926140466001470485935e-01 1.12033629342270985018714668512985e-01 6.44919168291802846759708245372167e-01 1.02459865617042025776051161756186e-02
 	 2.43047202365926140466001470485935e-01 6.44919168291802846759708245372167e-01 1.12033629342270985018714668512985e-01 1.02459865617042025776051161756186e-02
 	 1.12033629342270985018714668512985e-01 2.43047202365926140466001470485935e-01 6.44919168291802846759708245372167e-01 1.02459865617042025776051161756186e-02
 	 1.12033629342270985018714668512985e-01 6.44919168291802846759708245372167e-01 2.43047202365926140466001470485935e-01 1.02459865617042025776051161756186e-02
 	 6.44919168291802846759708245372167e-01 2.43047202365926140466001470485935e-01 1.12033629342270985018714668512985e-01 1.02459865617042025776051161756186e-02
 	 6.44919168291802846759708245372167e-01 1.12033629342270985018714668512985e-01 2.43047202365926140466001470485935e-01 1.02459865617042025776051161756186e-02
 	 2.29992984057907162709355475271877e-01 4.78148977298713338118796301046132e-03 7.65225526169105774165757338778349e-01 2.32454536446405086308475418377384e-03
 	 2.29992984057907162709355475271877e-01 7.65225526169105774165757338778349e-01 4.78148977298713338118796301046132e-03 2.32454536446405086308475418377384e-03
 	 4.78148977298713338118796301046132e-03 2.29992984057907162709355475271877e-01 7.65225526169105774165757338778349e-01 2.32454536446405086308475418377384e-03
 	 4.78148977298713338118796301046132e-03 7.65225526169105774165757338778349e-01 2.29992984057907162709355475271877e-01 2.32454536446405086308475418377384e-03
 	 7.65225526169105774165757338778349e-01 2.29992984057907162709355475271877e-01 4.78148977298713338118796301046132e-03 2.32454536446405086308475418377384e-03
 	 7.65225526169105774165757338778349e-01 4.78148977298713338118796301046132e-03 2.29992984057907162709355475271877e-01 2.32454536446405086308475418377384e-03
 	 2.95608280872401651961922652844805e-01 6.24487421796328864842529071665922e-02 6.41942976947965426859354920452461e-01 8.92511614027655282577189410631036e-03
 	 2.95608280872401651961922652844805e-01 6.41942976947965426859354920452461e-01 6.24487421796328864842529071665922e-02 8.92511614027655282577189410631036e-03
 	 6.24487421796328864842529071665922e-02 2.95608280872401651961922652844805e-01 6.41942976947965426859354920452461e-01 8.92511614027655282577189410631036e-03
 	 6.24487421796328864842529071665922e-02 6.41942976947965426859354920452461e-01 2.95608280872401651961922652844805e-01 8.92511614027655282577189410631036e-03
 	 6.41942976947965426859354920452461e-01 2.95608280872401651961922652844805e-01 6.24487421796328864842529071665922e-02 8.92511614027655282577189410631036e-03
 	 6.41942976947965426859354920452461e-01 6.24487421796328864842529071665922e-02 2.95608280872401651961922652844805e-01 8.92511614027655282577189410631036e-03
 	 1.21393450754091192234085383461206e-01 5.02111859134281163230539846153988e-02 8.28395363332480649809497208480025e-01 5.91788377235389143060650951611024e-03
 	 1.21393450754091192234085383461206e-01 8.28395363332480649809497208480025e-01 5.02111859134281163230539846153988e-02 5.91788377235389143060650951611024e-03
 	 5.02111859134281163230539846153988e-02 1.21393450754091192234085383461206e-01 8.28395363332480649809497208480025e-01 5.91788377235389143060650951611024e-03
 	 5.02111859134281163230539846153988e-02 8.28395363332480649809497208480025e-01 1.21393450754091192234085383461206e-01 5.91788377235389143060650951611024e-03
 	 8.28395363332480649809497208480025e-01 1.21393450754091192234085383461206e-01 5.02111859134281163230539846153988e-02 5.91788377235389143060650951611024e-03
 	 8.28395363332480649809497208480025e-01 5.02111859134281163230539846153988e-02 1.21393450754091192234085383461206e-01 5.91788377235389143060650951611024e-03
 	 3.73823800310209619635060107611935e-01 2.57279987428787430825405380119264e-02 6.00448200946911536668437747721327e-01 6.26053464296855328996560530185889e-03
 	 3.73823800310209619635060107611935e-01 6.00448200946911536668437747721327e-01 2.57279987428787430825405380119264e-02 6.26053464296855328996560530185889e-03
 	 2.57279987428787430825405380119264e-02 3.73823800310209619635060107611935e-01 6.00448200946911536668437747721327e-01 6.26053464296855328996560530185889e-03
 	 2.57279987428787430825405380119264e-02 6.00448200946911536668437747721327e-01 3.73823800310209619635060107611935e-01 6.26053464296855328996560530185889e-03
 	 6.00448200946911536668437747721327e-01 3.73823800310209619635060107611935e-01 2.57279987428787430825405380119264e-02 6.26053464296855328996560530185889e-03
 	 6.00448200946911536668437747721327e-01 2.57279987428787430825405380119264e-02 3.73823800310209619635060107611935e-01 6.26053464296855328996560530185889e-03
 	 4.42783406520243560944294358705520e-01 5.64656599346616185769454077103546e-03 5.51570027486290248575073746906128e-01 3.14017764348803636587081911102359e-03
 	 4.42783406520243560944294358705520e-01 5.51570027486290248575073746906128e-01 5.64656599346616185769454077103546e-03 3.14017764348803636587081911102359e-03
 	 5.64656599346616185769454077103546e-03 4.42783406520243560944294358705520e-01 5.51570027486290248575073746906128e-01 3.14017764348803636587081911102359e-03
 	 5.64656599346616185769454077103546e-03 5.51570027486290248575073746906128e-01 4.42783406520243560944294358705520e-01 3.14017764348803636587081911102359e-03
 	 5.51570027486290248575073746906128e-01 4.42783406520243560944294358705520e-01 5.64656599346616185769454077103546e-03 3.14017764348803636587081911102359e-03
 	 5.51570027486290248575073746906128e-01 5.64656599346616185769454077103546e-03 4.42783406520243560944294358705520e-01 3.14017764348803636587081911102359e-03
 	 3.37798663200582327537091487101861e-01 1.18089069715095071333443854655343e-01 5.44112267084322698273979312943993e-01 1.27871384229558057721298780506913e-02
 	 3.37798663200582327537091487101861e-01 5.44112267084322698273979312943993e-01 1.18089069715095071333443854655343e-01 1.27871384229558057721298780506913e-02
 	 1.18089069715095071333443854655343e-01 3.37798663200582327537091487101861e-01 5.44112267084322698273979312943993e-01 1.27871384229558057721298780506913e-02
 	 1.18089069715095071333443854655343e-01 5.44112267084322698273979312943993e-01 3.37798663200582327537091487101861e-01 1.27871384229558057721298780506913e-02
 	 5.44112267084322698273979312943993e-01 3.37798663200582327537091487101861e-01 1.18089069715095071333443854655343e-01 1.27871384229558057721298780506913e-02
 	 5.44112267084322698273979312943993e-01 1.18089069715095071333443854655343e-01 3.37798663200582327537091487101861e-01 1.27871384229558057721298780506913e-02
 	 9.22291891952822101563569390236808e-02 1.82422910122947215527666742218571e-02 8.89528519792423089107558098476147e-01 3.20491619079303581216211505022784e-03
 	 9.22291891952822101563569390236808e-02 8.89528519792423089107558098476147e-01 1.82422910122947215527666742218571e-02 3.20491619079303581216211505022784e-03
 	 1.82422910122947215527666742218571e-02 9.22291891952822101563569390236808e-02 8.89528519792423089107558098476147e-01 3.20491619079303581216211505022784e-03
 	 1.82422910122947215527666742218571e-02 8.89528519792423089107558098476147e-01 9.22291891952822101563569390236808e-02 3.20491619079303581216211505022784e-03
 	 8.89528519792423089107558098476147e-01 9.22291891952822101563569390236808e-02 1.82422910122947215527666742218571e-02 3.20491619079303581216211505022784e-03
 	 8.89528519792423089107558098476147e-01 1.82422910122947215527666742218571e-02 9.22291891952822101563569390236808e-02 3.20491619079303581216211505022784e-03
 	 7.02907404781327321829920151685656e-02 1.20025560148715230122939967571938e-03 9.28509003920380049379446063539945e-01 7.25134594986083188573877666982526e-04
 	 7.02907404781327321829920151685656e-02 9.28509003920380049379446063539945e-01 1.20025560148715230122939967571938e-03 7.25134594986083188573877666982526e-04
 	 1.20025560148715230122939967571938e-03 7.02907404781327321829920151685656e-02 9.28509003920380049379446063539945e-01 7.25134594986083188573877666982526e-04
 	 1.20025560148715230122939967571938e-03 9.28509003920380049379446063539945e-01 7.02907404781327321829920151685656e-02 7.25134594986083188573877666982526e-04
 	 9.28509003920380049379446063539945e-01 7.02907404781327321829920151685656e-02 1.20025560148715230122939967571938e-03 7.25134594986083188573877666982526e-04
 	 9.28509003920380049379446063539945e-01 1.20025560148715230122939967571938e-03 7.02907404781327321829920151685656e-02 7.25134594986083188573877666982526e-04
 	 ];
 
 	 case  29 

 	 % ALG. DEG.:   29
 	 % PTS CARD.:  159
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-15  

 	 xyw_bar=[
 	 4.98914824637686160624383546746685e-01 4.98914824637686160624383546746685e-01 2.17035072462767875123290650662966e-03 1.51646210315690196240856479903414e-03
 	 4.98914824637686160624383546746685e-01 2.17035072462767875123290650662966e-03 4.98914824637686160624383546746685e-01 1.51646210315690196240856479903414e-03
 	 2.17035072462767875123290650662966e-03 4.98914824637686160624383546746685e-01 4.98914824637686160624383546746685e-01 1.51646210315690196240856479903414e-03
 	 4.34380426761730609186429319379386e-01 4.34380426761730609186429319379386e-01 1.31239146476538781627141361241229e-01 1.11711002951678569500293392025014e-02
 	 4.34380426761730609186429319379386e-01 1.31239146476538781627141361241229e-01 4.34380426761730609186429319379386e-01 1.11711002951678569500293392025014e-02
 	 1.31239146476538781627141361241229e-01 4.34380426761730609186429319379386e-01 4.34380426761730609186429319379386e-01 1.11711002951678569500293392025014e-02
 	 4.10973356271179326992815106223134e-02 4.10973356271179326992815106223134e-02 9.17805328745764148479224786569830e-01 2.86049150615688696497329601697857e-03
 	 4.10973356271179326992815106223134e-02 9.17805328745764148479224786569830e-01 4.10973356271179326992815106223134e-02 2.86049150615688696497329601697857e-03
 	 9.17805328745764148479224786569830e-01 4.10973356271179326992815106223134e-02 4.10973356271179326992815106223134e-02 2.86049150615688696497329601697857e-03
 	 2.08405305132400797685221505162190e-01 2.08405305132400797685221505162190e-01 5.83189389735198404629556989675621e-01 1.25392034426232267668721576114876e-02
 	 2.08405305132400797685221505162190e-01 5.83189389735198404629556989675621e-01 2.08405305132400797685221505162190e-01 1.25392034426232267668721576114876e-02
 	 5.83189389735198404629556989675621e-01 2.08405305132400797685221505162190e-01 2.08405305132400797685221505162190e-01 1.25392034426232267668721576114876e-02
 	 1.60745884431963526051134749650373e-01 1.60745884431963526051134749650373e-01 6.78508231136072947897730500699254e-01 1.05714178582275754314512283826843e-02
 	 1.60745884431963526051134749650373e-01 6.78508231136072947897730500699254e-01 1.60745884431963526051134749650373e-01 1.05714178582275754314512283826843e-02
 	 6.78508231136072947897730500699254e-01 1.60745884431963526051134749650373e-01 1.60745884431963526051134749650373e-01 1.05714178582275754314512283826843e-02
 	 4.88401602932602707518583429191494e-01 4.88401602932602707518583429191494e-01 2.31967941347945849628331416170113e-02 6.13440116471890978244729808466218e-03
 	 4.88401602932602707518583429191494e-01 2.31967941347945849628331416170113e-02 4.88401602932602707518583429191494e-01 6.13440116471890978244729808466218e-03
 	 2.31967941347945849628331416170113e-02 4.88401602932602707518583429191494e-01 4.88401602932602707518583429191494e-01 6.13440116471890978244729808466218e-03
 	 3.02386411215128436680288359639235e-01 3.02386411215128436680288359639235e-01 3.95227177569743126639423280721530e-01 1.63102388077432033930413979305740e-02
 	 3.02386411215128436680288359639235e-01 3.95227177569743126639423280721530e-01 3.02386411215128436680288359639235e-01 1.63102388077432033930413979305740e-02
 	 3.95227177569743126639423280721530e-01 3.02386411215128436680288359639235e-01 3.02386411215128436680288359639235e-01 1.63102388077432033930413979305740e-02
 	 1.14426812994425419756083783795475e-01 1.14426812994425419756083783795475e-01 7.71146374011149160487832432409050e-01 8.17287844122713269534585833753226e-03
 	 1.14426812994425419756083783795475e-01 7.71146374011149160487832432409050e-01 1.14426812994425419756083783795475e-01 8.17287844122713269534585833753226e-03
 	 7.71146374011149160487832432409050e-01 1.14426812994425419756083783795475e-01 1.14426812994425419756083783795475e-01 8.17287844122713269534585833753226e-03
 	 4.64762431080738891431280990218511e-01 4.64762431080738891431280990218511e-01 7.04751378385222171374380195629783e-02 1.03131166352584992262908514248920e-02
 	 4.64762431080738891431280990218511e-01 7.04751378385222171374380195629783e-02 4.64762431080738891431280990218511e-01 1.03131166352584992262908514248920e-02
 	 7.04751378385222171374380195629783e-02 4.64762431080738891431280990218511e-01 4.64762431080738891431280990218511e-01 1.03131166352584992262908514248920e-02
 	 7.37218813900996500221296514610003e-02 7.37218813900996500221296514610003e-02 8.52556237219800672200165081449086e-01 5.60884713283130425381939332396541e-03
 	 7.37218813900996500221296514610003e-02 8.52556237219800672200165081449086e-01 7.37218813900996500221296514610003e-02 5.60884713283130425381939332396541e-03
 	 8.52556237219800672200165081449086e-01 7.37218813900996500221296514610003e-02 7.37218813900996500221296514610003e-02 5.60884713283130425381939332396541e-03
 	 3.90619178783263687471105640725000e-01 3.90619178783263687471105640725000e-01 2.18761642433472625057788718550000e-01 1.59132152840889030953608340723804e-02
 	 3.90619178783263687471105640725000e-01 2.18761642433472625057788718550000e-01 3.90619178783263687471105640725000e-01 1.59132152840889030953608340723804e-02
 	 2.18761642433472625057788718550000e-01 3.90619178783263687471105640725000e-01 3.90619178783263687471105640725000e-01 1.59132152840889030953608340723804e-02
 	 5.89421088402292056573905654204282e-02 2.72874324792107044584943409404332e-03 9.38329147911849736907186070311582e-01 7.69252971476248729489066935371966e-04
 	 5.89421088402292056573905654204282e-02 9.38329147911849736907186070311582e-01 2.72874324792107044584943409404332e-03 7.69252971476248729489066935371966e-04
 	 2.72874324792107044584943409404332e-03 5.89421088402292056573905654204282e-02 9.38329147911849736907186070311582e-01 7.69252971476248729489066935371966e-04
 	 2.72874324792107044584943409404332e-03 9.38329147911849736907186070311582e-01 5.89421088402292056573905654204282e-02 7.69252971476248729489066935371966e-04
 	 9.38329147911849736907186070311582e-01 5.89421088402292056573905654204282e-02 2.72874324792107044584943409404332e-03 7.69252971476248729489066935371966e-04
 	 9.38329147911849736907186070311582e-01 2.72874324792107044584943409404332e-03 5.89421088402292056573905654204282e-02 7.69252971476248729489066935371966e-04
 	 3.49788010009331795657772090635262e-01 1.57177699867193487737182522323565e-01 4.93034290123474716605045387041173e-01 1.04522146969224342949456030282818e-02
 	 3.49788010009331795657772090635262e-01 4.93034290123474716605045387041173e-01 1.57177699867193487737182522323565e-01 1.04522146969224342949456030282818e-02
 	 1.57177699867193487737182522323565e-01 3.49788010009331795657772090635262e-01 4.93034290123474716605045387041173e-01 1.04522146969224342949456030282818e-02
 	 1.57177699867193487737182522323565e-01 4.93034290123474716605045387041173e-01 3.49788010009331795657772090635262e-01 1.04522146969224342949456030282818e-02
 	 4.93034290123474716605045387041173e-01 3.49788010009331795657772090635262e-01 1.57177699867193487737182522323565e-01 1.04522146969224342949456030282818e-02
 	 4.93034290123474716605045387041173e-01 1.57177699867193487737182522323565e-01 3.49788010009331795657772090635262e-01 1.04522146969224342949456030282818e-02
 	 3.23001823543550170558802392406506e-01 2.10096664482755952213510752812908e-03 6.74897209811622378339279748615809e-01 1.35282394925240840796720753758109e-03
 	 3.23001823543550170558802392406506e-01 6.74897209811622378339279748615809e-01 2.10096664482755952213510752812908e-03 1.35282394925240840796720753758109e-03
 	 2.10096664482755952213510752812908e-03 3.23001823543550170558802392406506e-01 6.74897209811622378339279748615809e-01 1.35282394925240840796720753758109e-03
 	 2.10096664482755952213510752812908e-03 6.74897209811622378339279748615809e-01 3.23001823543550170558802392406506e-01 1.35282394925240840796720753758109e-03
 	 6.74897209811622378339279748615809e-01 3.23001823543550170558802392406506e-01 2.10096664482755952213510752812908e-03 1.35282394925240840796720753758109e-03
 	 6.74897209811622378339279748615809e-01 2.10096664482755952213510752812908e-03 3.23001823543550170558802392406506e-01 1.35282394925240840796720753758109e-03
 	 1.58145854249516104594874832400819e-01 6.81658088137464396316644865692069e-02 7.73688336936737441895672873215517e-01 6.43913670753380480010763520226647e-03
 	 1.58145854249516104594874832400819e-01 7.73688336936737441895672873215517e-01 6.81658088137464396316644865692069e-02 6.43913670753380480010763520226647e-03
 	 6.81658088137464396316644865692069e-02 1.58145854249516104594874832400819e-01 7.73688336936737441895672873215517e-01 6.43913670753380480010763520226647e-03
 	 6.81658088137464396316644865692069e-02 7.73688336936737441895672873215517e-01 1.58145854249516104594874832400819e-01 6.43913670753380480010763520226647e-03
 	 7.73688336936737441895672873215517e-01 1.58145854249516104594874832400819e-01 6.81658088137464396316644865692069e-02 6.43913670753380480010763520226647e-03
 	 7.73688336936737441895672873215517e-01 6.81658088137464396316644865692069e-02 1.58145854249516104594874832400819e-01 6.43913670753380480010763520226647e-03
 	 2.95494682613533683757101044875526e-02 1.08309586036093533772950436855353e-02 9.59619573135037207123332336777821e-01 1.27219443717163107308854019805722e-03
 	 2.95494682613533683757101044875526e-02 9.59619573135037207123332336777821e-01 1.08309586036093533772950436855353e-02 1.27219443717163107308854019805722e-03
 	 1.08309586036093533772950436855353e-02 2.95494682613533683757101044875526e-02 9.59619573135037207123332336777821e-01 1.27219443717163107308854019805722e-03
 	 1.08309586036093533772950436855353e-02 9.59619573135037207123332336777821e-01 2.95494682613533683757101044875526e-02 1.27219443717163107308854019805722e-03
 	 9.59619573135037207123332336777821e-01 2.95494682613533683757101044875526e-02 1.08309586036093533772950436855353e-02 1.27219443717163107308854019805722e-03
 	 9.59619573135037207123332336777821e-01 1.08309586036093533772950436855353e-02 2.95494682613533683757101044875526e-02 1.27219443717163107308854019805722e-03
 	 2.91819173426537070703545850847149e-01 2.18932341980172556761274904602033e-01 4.89248484593290400290754860179732e-01 1.35452465720075718863535385594332e-02
 	 2.91819173426537070703545850847149e-01 4.89248484593290400290754860179732e-01 2.18932341980172556761274904602033e-01 1.35452465720075718863535385594332e-02
 	 2.18932341980172556761274904602033e-01 2.91819173426537070703545850847149e-01 4.89248484593290400290754860179732e-01 1.35452465720075718863535385594332e-02
 	 2.18932341980172556761274904602033e-01 4.89248484593290400290754860179732e-01 2.91819173426537070703545850847149e-01 1.35452465720075718863535385594332e-02
 	 4.89248484593290400290754860179732e-01 2.91819173426537070703545850847149e-01 2.18932341980172556761274904602033e-01 1.35452465720075718863535385594332e-02
 	 4.89248484593290400290754860179732e-01 2.18932341980172556761274904602033e-01 2.91819173426537070703545850847149e-01 1.35452465720075718863535385594332e-02
 	 7.55221785129957801085964774756576e-02 2.12868962407332593111952689923783e-02 9.03190925246270981396889965253649e-01 2.76153074959044385686124378764816e-03
 	 7.55221785129957801085964774756576e-02 9.03190925246270981396889965253649e-01 2.12868962407332593111952689923783e-02 2.76153074959044385686124378764816e-03
 	 2.12868962407332593111952689923783e-02 7.55221785129957801085964774756576e-02 9.03190925246270981396889965253649e-01 2.76153074959044385686124378764816e-03
 	 2.12868962407332593111952689923783e-02 9.03190925246270981396889965253649e-01 7.55221785129957801085964774756576e-02 2.76153074959044385686124378764816e-03
 	 9.03190925246270981396889965253649e-01 7.55221785129957801085964774756576e-02 2.12868962407332593111952689923783e-02 2.76153074959044385686124378764816e-03
 	 9.03190925246270981396889965253649e-01 2.12868962407332593111952689923783e-02 7.55221785129957801085964774756576e-02 2.76153074959044385686124378764816e-03
 	 1.17116669508898874063618222862715e-01 4.08472165761024560981518050084560e-02 8.42036113914998662899336068221601e-01 4.51268684548732958161654238438132e-03
 	 1.17116669508898874063618222862715e-01 8.42036113914998662899336068221601e-01 4.08472165761024560981518050084560e-02 4.51268684548732958161654238438132e-03
 	 4.08472165761024560981518050084560e-02 1.17116669508898874063618222862715e-01 8.42036113914998662899336068221601e-01 4.51268684548732958161654238438132e-03
 	 4.08472165761024560981518050084560e-02 8.42036113914998662899336068221601e-01 1.17116669508898874063618222862715e-01 4.51268684548732958161654238438132e-03
 	 8.42036113914998662899336068221601e-01 1.17116669508898874063618222862715e-01 4.08472165761024560981518050084560e-02 4.51268684548732958161654238438132e-03
 	 8.42036113914998662899336068221601e-01 4.08472165761024560981518050084560e-02 1.17116669508898874063618222862715e-01 4.51268684548732958161654238438132e-03
 	 1.11662181081691909423359021502620e-02 1.60349649604376361805568862450855e-03 9.87230285395787054980587527097668e-01 2.69492231858701157543034554464612e-04
 	 1.11662181081691909423359021502620e-02 9.87230285395787054980587527097668e-01 1.60349649604376361805568862450855e-03 2.69492231858701157543034554464612e-04
 	 1.60349649604376361805568862450855e-03 1.11662181081691909423359021502620e-02 9.87230285395787054980587527097668e-01 2.69492231858701157543034554464612e-04
 	 1.60349649604376361805568862450855e-03 9.87230285395787054980587527097668e-01 1.11662181081691909423359021502620e-02 2.69492231858701157543034554464612e-04
 	 9.87230285395787054980587527097668e-01 1.11662181081691909423359021502620e-02 1.60349649604376361805568862450855e-03 2.69492231858701157543034554464612e-04
 	 9.87230285395787054980587527097668e-01 1.60349649604376361805568862450855e-03 1.11662181081691909423359021502620e-02 2.69492231858701157543034554464612e-04
 	 2.08045649279087141447774911284796e-01 1.01545985226834029058196051664709e-01 6.90408365494078801738453421421582e-01 9.38633067628366277168616704784654e-03
 	 2.08045649279087141447774911284796e-01 6.90408365494078801738453421421582e-01 1.01545985226834029058196051664709e-01 9.38633067628366277168616704784654e-03
 	 1.01545985226834029058196051664709e-01 2.08045649279087141447774911284796e-01 6.90408365494078801738453421421582e-01 9.38633067628366277168616704784654e-03
 	 1.01545985226834029058196051664709e-01 6.90408365494078801738453421421582e-01 2.08045649279087141447774911284796e-01 9.38633067628366277168616704784654e-03
 	 6.90408365494078801738453421421582e-01 2.08045649279087141447774911284796e-01 1.01545985226834029058196051664709e-01 9.38633067628366277168616704784654e-03
 	 6.90408365494078801738453421421582e-01 1.01545985226834029058196051664709e-01 2.08045649279087141447774911284796e-01 9.38633067628366277168616704784654e-03
 	 3.92210114980434843001688705044216e-01 4.15270612688226833930649206649832e-02 5.66262823750742438910776854754658e-01 7.82291845830647772364052627835918e-03
 	 3.92210114980434843001688705044216e-01 5.66262823750742438910776854754658e-01 4.15270612688226833930649206649832e-02 7.82291845830647772364052627835918e-03
 	 4.15270612688226833930649206649832e-02 3.92210114980434843001688705044216e-01 5.66262823750742438910776854754658e-01 7.82291845830647772364052627835918e-03
 	 4.15270612688226833930649206649832e-02 5.66262823750742438910776854754658e-01 3.92210114980434843001688705044216e-01 7.82291845830647772364052627835918e-03
 	 5.66262823750742438910776854754658e-01 3.92210114980434843001688705044216e-01 4.15270612688226833930649206649832e-02 7.82291845830647772364052627835918e-03
 	 5.66262823750742438910776854754658e-01 4.15270612688226833930649206649832e-02 3.92210114980434843001688705044216e-01 7.82291845830647772364052627835918e-03
 	 3.59711275509975836328635523386765e-01 9.38490411451324418878883193428919e-02 5.46439683344891680150112733826973e-01 1.06303963631966119640637202792277e-02
 	 3.59711275509975836328635523386765e-01 5.46439683344891680150112733826973e-01 9.38490411451324418878883193428919e-02 1.06303963631966119640637202792277e-02
 	 9.38490411451324418878883193428919e-02 3.59711275509975836328635523386765e-01 5.46439683344891680150112733826973e-01 1.06303963631966119640637202792277e-02
 	 9.38490411451324418878883193428919e-02 5.46439683344891680150112733826973e-01 3.59711275509975836328635523386765e-01 1.06303963631966119640637202792277e-02
 	 5.46439683344891680150112733826973e-01 3.59711275509975836328635523386765e-01 9.38490411451324418878883193428919e-02 1.06303963631966119640637202792277e-02
 	 5.46439683344891680150112733826973e-01 9.38490411451324418878883193428919e-02 3.59711275509975836328635523386765e-01 1.06303963631966119640637202792277e-02
 	 2.45874699482875436196138707600767e-01 8.68602980438413878327974515514143e-03 7.45439270712740409408070263452828e-01 3.05123882334519059070232493979802e-03
 	 2.45874699482875436196138707600767e-01 7.45439270712740409408070263452828e-01 8.68602980438413878327974515514143e-03 3.05123882334519059070232493979802e-03
 	 8.68602980438413878327974515514143e-03 2.45874699482875436196138707600767e-01 7.45439270712740409408070263452828e-01 3.05123882334519059070232493979802e-03
 	 8.68602980438413878327974515514143e-03 7.45439270712740409408070263452828e-01 2.45874699482875436196138707600767e-01 3.05123882334519059070232493979802e-03
 	 7.45439270712740409408070263452828e-01 2.45874699482875436196138707600767e-01 8.68602980438413878327974515514143e-03 3.05123882334519059070232493979802e-03
 	 7.45439270712740409408070263452828e-01 8.68602980438413878327974515514143e-03 2.45874699482875436196138707600767e-01 3.05123882334519059070232493979802e-03
 	 1.67002738174923143210648390777351e-01 1.75891240440456259053192411556665e-02 8.15408137781031161495093328994699e-01 3.82536667173001120739739278064917e-03
 	 1.67002738174923143210648390777351e-01 8.15408137781031161495093328994699e-01 1.75891240440456259053192411556665e-02 3.82536667173001120739739278064917e-03
 	 1.75891240440456259053192411556665e-02 1.67002738174923143210648390777351e-01 8.15408137781031161495093328994699e-01 3.82536667173001120739739278064917e-03
 	 1.75891240440456259053192411556665e-02 8.15408137781031161495093328994699e-01 1.67002738174923143210648390777351e-01 3.82536667173001120739739278064917e-03
 	 8.15408137781031161495093328994699e-01 1.67002738174923143210648390777351e-01 1.75891240440456259053192411556665e-02 3.82536667173001120739739278064917e-03
 	 8.15408137781031161495093328994699e-01 1.75891240440456259053192411556665e-02 1.67002738174923143210648390777351e-01 3.82536667173001120739739278064917e-03
 	 1.15008598631946429291517119963828e-01 5.52352451221255549840272180972534e-03 8.79467876855840935412800263293320e-01 1.74169523130174915687140568820723e-03
 	 1.15008598631946429291517119963828e-01 8.79467876855840935412800263293320e-01 5.52352451221255549840272180972534e-03 1.74169523130174915687140568820723e-03
 	 5.52352451221255549840272180972534e-03 1.15008598631946429291517119963828e-01 8.79467876855840935412800263293320e-01 1.74169523130174915687140568820723e-03
 	 5.52352451221255549840272180972534e-03 8.79467876855840935412800263293320e-01 1.15008598631946429291517119963828e-01 1.74169523130174915687140568820723e-03
 	 8.79467876855840935412800263293320e-01 1.15008598631946429291517119963828e-01 5.52352451221255549840272180972534e-03 1.74169523130174915687140568820723e-03
 	 8.79467876855840935412800263293320e-01 5.52352451221255549840272180972534e-03 1.15008598631946429291517119963828e-01 1.74169523130174915687140568820723e-03
 	 3.15395398117319147868187201311230e-01 2.38589269426556054021215658167421e-02 6.60745674940025229382456473103957e-01 5.66915348166545807889749042374206e-03
 	 3.15395398117319147868187201311230e-01 6.60745674940025229382456473103957e-01 2.38589269426556054021215658167421e-02 5.66915348166545807889749042374206e-03
 	 2.38589269426556054021215658167421e-02 3.15395398117319147868187201311230e-01 6.60745674940025229382456473103957e-01 5.66915348166545807889749042374206e-03
 	 2.38589269426556054021215658167421e-02 6.60745674940025229382456473103957e-01 3.15395398117319147868187201311230e-01 5.66915348166545807889749042374206e-03
 	 6.60745674940025229382456473103957e-01 3.15395398117319147868187201311230e-01 2.38589269426556054021215658167421e-02 5.66915348166545807889749042374206e-03
 	 6.60745674940025229382456473103957e-01 2.38589269426556054021215658167421e-02 3.15395398117319147868187201311230e-01 5.66915348166545807889749042374206e-03
 	 2.23222650224820601261299657380732e-01 4.02953345447718061511643838912278e-02 7.36482015230407571770854247006355e-01 6.58199776385220546720544732011149e-03
 	 2.23222650224820601261299657380732e-01 7.36482015230407571770854247006355e-01 4.02953345447718061511643838912278e-02 6.58199776385220546720544732011149e-03
 	 4.02953345447718061511643838912278e-02 2.23222650224820601261299657380732e-01 7.36482015230407571770854247006355e-01 6.58199776385220546720544732011149e-03
 	 4.02953345447718061511643838912278e-02 7.36482015230407571770854247006355e-01 2.23222650224820601261299657380732e-01 6.58199776385220546720544732011149e-03
 	 7.36482015230407571770854247006355e-01 2.23222650224820601261299657380732e-01 4.02953345447718061511643838912278e-02 6.58199776385220546720544732011149e-03
 	 7.36482015230407571770854247006355e-01 4.02953345447718061511643838912278e-02 2.23222650224820601261299657380732e-01 6.58199776385220546720544732011149e-03
 	 2.88395859918732400117846736975480e-01 6.78784043114470936330917538725771e-02 6.43725735769820506249061509151943e-01 9.17892416492759564972114816328030e-03
 	 2.88395859918732400117846736975480e-01 6.43725735769820506249061509151943e-01 6.78784043114470936330917538725771e-02 9.17892416492759564972114816328030e-03
 	 6.78784043114470936330917538725771e-02 2.88395859918732400117846736975480e-01 6.43725735769820506249061509151943e-01 9.17892416492759564972114816328030e-03
 	 6.78784043114470936330917538725771e-02 6.43725735769820506249061509151943e-01 2.88395859918732400117846736975480e-01 9.17892416492759564972114816328030e-03
 	 6.43725735769820506249061509151943e-01 2.88395859918732400117846736975480e-01 6.78784043114470936330917538725771e-02 9.17892416492759564972114816328030e-03
 	 6.43725735769820506249061509151943e-01 6.78784043114470936330917538725771e-02 2.88395859918732400117846736975480e-01 9.17892416492759564972114816328030e-03
 	 2.67366350272775554763882155384636e-01 1.39535607181082654815185151164769e-01 5.93098042546141845932083924708422e-01 1.25183664988344246771223566838671e-02
 	 2.67366350272775554763882155384636e-01 5.93098042546141845932083924708422e-01 1.39535607181082654815185151164769e-01 1.25183664988344246771223566838671e-02
 	 1.39535607181082654815185151164769e-01 2.67366350272775554763882155384636e-01 5.93098042546141845932083924708422e-01 1.25183664988344246771223566838671e-02
 	 1.39535607181082654815185151164769e-01 5.93098042546141845932083924708422e-01 2.67366350272775554763882155384636e-01 1.25183664988344246771223566838671e-02
 	 5.93098042546141845932083924708422e-01 2.67366350272775554763882155384636e-01 1.39535607181082654815185151164769e-01 1.25183664988344246771223566838671e-02
 	 5.93098042546141845932083924708422e-01 1.39535607181082654815185151164769e-01 2.67366350272775554763882155384636e-01 1.25183664988344246771223566838671e-02
 	 4.05765395298891551334463656530716e-01 8.06658570416661502289201735038660e-03 5.86168018996941819764856518304441e-01 3.64134041128073675241960671655761e-03
 	 4.05765395298891551334463656530716e-01 5.86168018996941819764856518304441e-01 8.06658570416661502289201735038660e-03 3.64134041128073675241960671655761e-03
 	 8.06658570416661502289201735038660e-03 4.05765395298891551334463656530716e-01 5.86168018996941819764856518304441e-01 3.64134041128073675241960671655761e-03
 	 8.06658570416661502289201735038660e-03 5.86168018996941819764856518304441e-01 4.05765395298891551334463656530716e-01 3.64134041128073675241960671655761e-03
 	 5.86168018996941819764856518304441e-01 4.05765395298891551334463656530716e-01 8.06658570416661502289201735038660e-03 3.64134041128073675241960671655761e-03
 	 5.86168018996941819764856518304441e-01 8.06658570416661502289201735038660e-03 4.05765395298891551334463656530716e-01 3.64134041128073675241960671655761e-03
 	 1.86320727675359537611754490171734e-01 1.23446812287404965226972342051681e-04 8.13555825512353059103531904838746e-01 6.88672625041760843971061500923270e-04
 	 1.86320727675359537611754490171734e-01 8.13555825512353059103531904838746e-01 1.23446812287404965226972342051681e-04 6.88672625041760843971061500923270e-04
 	 1.23446812287404965226972342051681e-04 1.86320727675359537611754490171734e-01 8.13555825512353059103531904838746e-01 6.88672625041760843971061500923270e-04
 	 1.23446812287404965226972342051681e-04 8.13555825512353059103531904838746e-01 1.86320727675359537611754490171734e-01 6.88672625041760843971061500923270e-04
 	 8.13555825512353059103531904838746e-01 1.86320727675359537611754490171734e-01 1.23446812287404965226972342051681e-04 6.88672625041760843971061500923270e-04
 	 8.13555825512353059103531904838746e-01 1.23446812287404965226972342051681e-04 1.86320727675359537611754490171734e-01 6.88672625041760843971061500923270e-04
 	 ];
 
 	 case  30 

 	 % ALG. DEG.:   30
 	 % PTS CARD.:  171
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-15  

 	 xyw_bar=[
 	 3.31872493664435528476497339056550e-03 3.31872493664435528476497339056550e-03 9.93362550126711263409617913566763e-01 1.71729901371049762000275951123740e-04
 	 3.31872493664435528476497339056550e-03 9.93362550126711263409617913566763e-01 3.31872493664435528476497339056550e-03 1.71729901371049762000275951123740e-04
 	 9.93362550126711263409617913566763e-01 3.31872493664435528476497339056550e-03 3.31872493664435528476497339056550e-03 1.71729901371049762000275951123740e-04
 	 7.23724072246778316053195112544927e-02 7.23724072246778316053195112544927e-02 8.55255185550644281278209746233188e-01 3.80193266841552437312889978215935e-03
 	 7.23724072246778316053195112544927e-02 8.55255185550644281278209746233188e-01 7.23724072246778316053195112544927e-02 3.80193266841552437312889978215935e-03
 	 8.55255185550644281278209746233188e-01 7.23724072246778316053195112544927e-02 7.23724072246778316053195112544927e-02 3.80193266841552437312889978215935e-03
 	 4.71579102421717660797995108623581e-02 4.71579102421717660797995108623581e-02 9.05684179515656495595976593904197e-01 2.84443366768750071846283411503009e-03
 	 4.71579102421717660797995108623581e-02 9.05684179515656495595976593904197e-01 4.71579102421717660797995108623581e-02 2.84443366768750071846283411503009e-03
 	 9.05684179515656495595976593904197e-01 4.71579102421717660797995108623581e-02 4.71579102421717660797995108623581e-02 2.84443366768750071846283411503009e-03
 	 4.68030173651125425138275204517413e-01 4.68030173651125425138275204517413e-01 6.39396526977491497234495909651741e-02 7.78412873233086215207787716963139e-03
 	 4.68030173651125425138275204517413e-01 6.39396526977491497234495909651741e-02 4.68030173651125425138275204517413e-01 7.78412873233086215207787716963139e-03
 	 6.39396526977491497234495909651741e-02 4.68030173651125425138275204517413e-01 4.68030173651125425138275204517413e-01 7.78412873233086215207787716963139e-03
 	 1.26866046744675987217876311774489e-02 1.26866046744675987217876311774489e-02 9.74626790651064833781447305227630e-01 8.46550145328890581847280927263455e-04
 	 1.26866046744675987217876311774489e-02 9.74626790651064833781447305227630e-01 1.26866046744675987217876311774489e-02 8.46550145328890581847280927263455e-04
 	 9.74626790651064833781447305227630e-01 1.26866046744675987217876311774489e-02 1.26866046744675987217876311774489e-02 8.46550145328890581847280927263455e-04
 	 1.21591508222727892607473165753618e-01 1.21591508222727892607473165753618e-01 7.56816983554544187029478052863851e-01 7.38691183491430210239503395541760e-03
 	 1.21591508222727892607473165753618e-01 7.56816983554544187029478052863851e-01 1.21591508222727892607473165753618e-01 7.38691183491430210239503395541760e-03
 	 7.56816983554544187029478052863851e-01 1.21591508222727892607473165753618e-01 1.21591508222727892607473165753618e-01 7.38691183491430210239503395541760e-03
 	 1.82409561517452856183041376425535e-01 1.82409561517452856183041376425535e-01 6.35180876965094287633917247148929e-01 1.07528509654328321976102245116635e-02
 	 1.82409561517452856183041376425535e-01 6.35180876965094287633917247148929e-01 1.82409561517452856183041376425535e-01 1.07528509654328321976102245116635e-02
 	 6.35180876965094287633917247148929e-01 1.82409561517452856183041376425535e-01 1.82409561517452856183041376425535e-01 1.07528509654328321976102245116635e-02
 	 3.62287279352949798116867441422073e-01 3.62287279352949798116867441422073e-01 2.75425441294100403766265117155854e-01 1.55960913258258258157207265526267e-02
 	 3.62287279352949798116867441422073e-01 2.75425441294100403766265117155854e-01 3.62287279352949798116867441422073e-01 1.55960913258258258157207265526267e-02
 	 2.75425441294100403766265117155854e-01 3.62287279352949798116867441422073e-01 3.62287279352949798116867441422073e-01 1.55960913258258258157207265526267e-02
 	 4.36743248548460194502496278801118e-01 4.36743248548460194502496278801118e-01 1.26513502903079610995007442397764e-01 1.24049590281460325041917869270947e-02
 	 4.36743248548460194502496278801118e-01 1.26513502903079610995007442397764e-01 4.36743248548460194502496278801118e-01 1.24049590281460325041917869270947e-02
 	 1.26513502903079610995007442397764e-01 4.36743248548460194502496278801118e-01 4.36743248548460194502496278801118e-01 1.24049590281460325041917869270947e-02
 	 2.72428040783928182566597797631402e-01 2.72428040783928182566597797631402e-01 4.55143918432143634866804404737195e-01 1.49145507626857881655624282757344e-02
 	 2.72428040783928182566597797631402e-01 4.55143918432143634866804404737195e-01 2.72428040783928182566597797631402e-01 1.49145507626857881655624282757344e-02
 	 4.55143918432143634866804404737195e-01 2.72428040783928182566597797631402e-01 2.72428040783928182566597797631402e-01 1.49145507626857881655624282757344e-02
 	 4.97319339000308557885432492184918e-01 4.97319339000308557885432492184918e-01 5.36132199938288422913501563016325e-03 2.79131811974077381766079497538158e-03
 	 4.97319339000308557885432492184918e-01 5.36132199938288422913501563016325e-03 4.97319339000308557885432492184918e-01 2.79131811974077381766079497538158e-03
 	 5.36132199938288422913501563016325e-03 4.97319339000308557885432492184918e-01 4.97319339000308557885432492184918e-01 2.79131811974077381766079497538158e-03
 	 2.59053884521067367963098604377592e-01 4.78351231407725743793868389275303e-02 6.93110992338160092351984076231020e-01 4.21475846391244218791527487155690e-03
 	 2.59053884521067367963098604377592e-01 6.93110992338160092351984076231020e-01 4.78351231407725743793868389275303e-02 4.21475846391244218791527487155690e-03
 	 4.78351231407725743793868389275303e-02 2.59053884521067367963098604377592e-01 6.93110992338160092351984076231020e-01 4.21475846391244218791527487155690e-03
 	 4.78351231407725743793868389275303e-02 6.93110992338160092351984076231020e-01 2.59053884521067367963098604377592e-01 4.21475846391244218791527487155690e-03
 	 6.93110992338160092351984076231020e-01 2.59053884521067367963098604377592e-01 4.78351231407725743793868389275303e-02 4.21475846391244218791527487155690e-03
 	 6.93110992338160092351984076231020e-01 4.78351231407725743793868389275303e-02 2.59053884521067367963098604377592e-01 4.21475846391244218791527487155690e-03
 	 3.91572188291256340075818798140972e-01 7.96595269316006521220785430159594e-02 5.28768284777142993924314851028612e-01 5.92492274509202540566654704434768e-03
 	 3.91572188291256340075818798140972e-01 5.28768284777142993924314851028612e-01 7.96595269316006521220785430159594e-02 5.92492274509202540566654704434768e-03
 	 7.96595269316006521220785430159594e-02 3.91572188291256340075818798140972e-01 5.28768284777142993924314851028612e-01 5.92492274509202540566654704434768e-03
 	 7.96595269316006521220785430159594e-02 5.28768284777142993924314851028612e-01 3.91572188291256340075818798140972e-01 5.92492274509202540566654704434768e-03
 	 5.28768284777142993924314851028612e-01 3.91572188291256340075818798140972e-01 7.96595269316006521220785430159594e-02 5.92492274509202540566654704434768e-03
 	 5.28768284777142993924314851028612e-01 7.96595269316006521220785430159594e-02 3.91572188291256340075818798140972e-01 5.92492274509202540566654704434768e-03
 	 3.56140283296233539633846021388308e-01 5.76934012738742479919906713803357e-02 5.86166315429892281763102346303640e-01 5.94422018442449830166740554204807e-03
 	 3.56140283296233539633846021388308e-01 5.86166315429892281763102346303640e-01 5.76934012738742479919906713803357e-02 5.94422018442449830166740554204807e-03
 	 5.76934012738742479919906713803357e-02 3.56140283296233539633846021388308e-01 5.86166315429892281763102346303640e-01 5.94422018442449830166740554204807e-03
 	 5.76934012738742479919906713803357e-02 5.86166315429892281763102346303640e-01 3.56140283296233539633846021388308e-01 5.94422018442449830166740554204807e-03
 	 5.86166315429892281763102346303640e-01 3.56140283296233539633846021388308e-01 5.76934012738742479919906713803357e-02 5.94422018442449830166740554204807e-03
 	 5.86166315429892281763102346303640e-01 5.76934012738742479919906713803357e-02 3.56140283296233539633846021388308e-01 5.94422018442449830166740554204807e-03
 	 2.83012497349588776351936303399270e-01 7.72614375768841260549990579420410e-02 6.39726065073527139226428062102059e-01 6.87718438753593883094872296624089e-03
 	 2.83012497349588776351936303399270e-01 6.39726065073527139226428062102059e-01 7.72614375768841260549990579420410e-02 6.87718438753593883094872296624089e-03
 	 7.72614375768841260549990579420410e-02 2.83012497349588776351936303399270e-01 6.39726065073527139226428062102059e-01 6.87718438753593883094872296624089e-03
 	 7.72614375768841260549990579420410e-02 6.39726065073527139226428062102059e-01 2.83012497349588776351936303399270e-01 6.87718438753593883094872296624089e-03
 	 6.39726065073527139226428062102059e-01 2.83012497349588776351936303399270e-01 7.72614375768841260549990579420410e-02 6.87718438753593883094872296624089e-03
 	 6.39726065073527139226428062102059e-01 7.72614375768841260549990579420410e-02 2.83012497349588776351936303399270e-01 6.87718438753593883094872296624089e-03
 	 2.41613762451524383134682238960522e-01 2.27583842950000725391390687946114e-02 7.35627853253475461059451845358126e-01 4.09249896834720707644583725937082e-03
 	 2.41613762451524383134682238960522e-01 7.35627853253475461059451845358126e-01 2.27583842950000725391390687946114e-02 4.09249896834720707644583725937082e-03
 	 2.27583842950000725391390687946114e-02 2.41613762451524383134682238960522e-01 7.35627853253475461059451845358126e-01 4.09249896834720707644583725937082e-03
 	 2.27583842950000725391390687946114e-02 7.35627853253475461059451845358126e-01 2.41613762451524383134682238960522e-01 4.09249896834720707644583725937082e-03
 	 7.35627853253475461059451845358126e-01 2.41613762451524383134682238960522e-01 2.27583842950000725391390687946114e-02 4.09249896834720707644583725937082e-03
 	 7.35627853253475461059451845358126e-01 2.27583842950000725391390687946114e-02 2.41613762451524383134682238960522e-01 4.09249896834720707644583725937082e-03
 	 2.52781247187932933684351155534387e-01 1.23811978770674652183814146155783e-01 6.23406774041392441887410313938744e-01 8.87265450601736060942670292206458e-03
 	 2.52781247187932933684351155534387e-01 6.23406774041392441887410313938744e-01 1.23811978770674652183814146155783e-01 8.87265450601736060942670292206458e-03
 	 1.23811978770674652183814146155783e-01 2.52781247187932933684351155534387e-01 6.23406774041392441887410313938744e-01 8.87265450601736060942670292206458e-03
 	 1.23811978770674652183814146155783e-01 6.23406774041392441887410313938744e-01 2.52781247187932933684351155534387e-01 8.87265450601736060942670292206458e-03
 	 6.23406774041392441887410313938744e-01 2.52781247187932933684351155534387e-01 1.23811978770674652183814146155783e-01 8.87265450601736060942670292206458e-03
 	 6.23406774041392441887410313938744e-01 1.23811978770674652183814146155783e-01 2.52781247187932933684351155534387e-01 8.87265450601736060942670292206458e-03
 	 1.84906106383917107072178964699560e-01 1.15881967236100599794035304057616e-01 6.99211926379982307011573539057281e-01 7.53432292954649661387289683034396e-03
 	 1.84906106383917107072178964699560e-01 6.99211926379982307011573539057281e-01 1.15881967236100599794035304057616e-01 7.53432292954649661387289683034396e-03
 	 1.15881967236100599794035304057616e-01 1.84906106383917107072178964699560e-01 6.99211926379982307011573539057281e-01 7.53432292954649661387289683034396e-03
 	 1.15881967236100599794035304057616e-01 6.99211926379982307011573539057281e-01 1.84906106383917107072178964699560e-01 7.53432292954649661387289683034396e-03
 	 6.99211926379982307011573539057281e-01 1.84906106383917107072178964699560e-01 1.15881967236100599794035304057616e-01 7.53432292954649661387289683034396e-03
 	 6.99211926379982307011573539057281e-01 1.15881967236100599794035304057616e-01 1.84906106383917107072178964699560e-01 7.53432292954649661387289683034396e-03
 	 1.93704377153640139308521384009509e-01 6.65174447818816239053063554820255e-02 7.39778178064478209030596644879552e-01 6.80400675610188729325322753993532e-03
 	 1.93704377153640139308521384009509e-01 7.39778178064478209030596644879552e-01 6.65174447818816239053063554820255e-02 6.80400675610188729325322753993532e-03
 	 6.65174447818816239053063554820255e-02 1.93704377153640139308521384009509e-01 7.39778178064478209030596644879552e-01 6.80400675610188729325322753993532e-03
 	 6.65174447818816239053063554820255e-02 7.39778178064478209030596644879552e-01 1.93704377153640139308521384009509e-01 6.80400675610188729325322753993532e-03
 	 7.39778178064478209030596644879552e-01 1.93704377153640139308521384009509e-01 6.65174447818816239053063554820255e-02 6.80400675610188729325322753993532e-03
 	 7.39778178064478209030596644879552e-01 6.65174447818816239053063554820255e-02 1.93704377153640139308521384009509e-01 6.80400675610188729325322753993532e-03
 	 7.64012484393875451749167382331507e-02 4.43878137706136145085311639491010e-03 9.19159970183551111588826643128414e-01 1.20669656854212022437100593208470e-03
 	 7.64012484393875451749167382331507e-02 9.19159970183551111588826643128414e-01 4.43878137706136145085311639491010e-03 1.20669656854212022437100593208470e-03
 	 4.43878137706136145085311639491010e-03 7.64012484393875451749167382331507e-02 9.19159970183551111588826643128414e-01 1.20669656854212022437100593208470e-03
 	 4.43878137706136145085311639491010e-03 9.19159970183551111588826643128414e-01 7.64012484393875451749167382331507e-02 1.20669656854212022437100593208470e-03
 	 9.19159970183551111588826643128414e-01 7.64012484393875451749167382331507e-02 4.43878137706136145085311639491010e-03 1.20669656854212022437100593208470e-03
 	 9.19159970183551111588826643128414e-01 4.43878137706136145085311639491010e-03 7.64012484393875451749167382331507e-02 1.20669656854212022437100593208470e-03
 	 2.09048087452689629328617115788802e-01 4.66357939268862656950753731166515e-03 7.86288333154621765785918796609621e-01 1.95894857789324699712252275674018e-03
 	 2.09048087452689629328617115788802e-01 7.86288333154621765785918796609621e-01 4.66357939268862656950753731166515e-03 1.95894857789324699712252275674018e-03
 	 4.66357939268862656950753731166515e-03 2.09048087452689629328617115788802e-01 7.86288333154621765785918796609621e-01 1.95894857789324699712252275674018e-03
 	 4.66357939268862656950753731166515e-03 7.86288333154621765785918796609621e-01 2.09048087452689629328617115788802e-01 1.95894857789324699712252275674018e-03
 	 7.86288333154621765785918796609621e-01 2.09048087452689629328617115788802e-01 4.66357939268862656950753731166515e-03 1.95894857789324699712252275674018e-03
 	 7.86288333154621765785918796609621e-01 4.66357939268862656950753731166515e-03 2.09048087452689629328617115788802e-01 1.95894857789324699712252275674018e-03
 	 2.98542994059242672300058529799571e-01 4.70368176447704539056005046404607e-03 6.96753324176280330881638747086981e-01 2.27444590099868271942940012309009e-03
 	 2.98542994059242672300058529799571e-01 6.96753324176280330881638747086981e-01 4.70368176447704539056005046404607e-03 2.27444590099868271942940012309009e-03
 	 4.70368176447704539056005046404607e-03 2.98542994059242672300058529799571e-01 6.96753324176280330881638747086981e-01 2.27444590099868271942940012309009e-03
 	 4.70368176447704539056005046404607e-03 6.96753324176280330881638747086981e-01 2.98542994059242672300058529799571e-01 2.27444590099868271942940012309009e-03
 	 6.96753324176280330881638747086981e-01 2.98542994059242672300058529799571e-01 4.70368176447704539056005046404607e-03 2.27444590099868271942940012309009e-03
 	 6.96753324176280330881638747086981e-01 4.70368176447704539056005046404607e-03 2.98542994059242672300058529799571e-01 2.27444590099868271942940012309009e-03
 	 3.34379040034031072003983808826888e-01 2.51820667038687127925467024169848e-02 6.40438893262100239489598152431427e-01 5.36468484618632043825492416999623e-03
 	 3.34379040034031072003983808826888e-01 6.40438893262100239489598152431427e-01 2.51820667038687127925467024169848e-02 5.36468484618632043825492416999623e-03
 	 2.51820667038687127925467024169848e-02 3.34379040034031072003983808826888e-01 6.40438893262100239489598152431427e-01 5.36468484618632043825492416999623e-03
 	 2.51820667038687127925467024169848e-02 6.40438893262100239489598152431427e-01 3.34379040034031072003983808826888e-01 5.36468484618632043825492416999623e-03
 	 6.40438893262100239489598152431427e-01 3.34379040034031072003983808826888e-01 2.51820667038687127925467024169848e-02 5.36468484618632043825492416999623e-03
 	 6.40438893262100239489598152431427e-01 2.51820667038687127925467024169848e-02 3.34379040034031072003983808826888e-01 5.36468484618632043825492416999623e-03
 	 1.23230802380695114717212845789618e-01 6.57765738247428899398983048740774e-02 8.10992623794561939831737618078478e-01 5.87006980306553714094031093395643e-03
 	 1.23230802380695114717212845789618e-01 8.10992623794561939831737618078478e-01 6.57765738247428899398983048740774e-02 5.87006980306553714094031093395643e-03
 	 6.57765738247428899398983048740774e-02 1.23230802380695114717212845789618e-01 8.10992623794561939831737618078478e-01 5.87006980306553714094031093395643e-03
 	 6.57765738247428899398983048740774e-02 8.10992623794561939831737618078478e-01 1.23230802380695114717212845789618e-01 5.87006980306553714094031093395643e-03
 	 8.10992623794561939831737618078478e-01 1.23230802380695114717212845789618e-01 6.57765738247428899398983048740774e-02 5.87006980306553714094031093395643e-03
 	 8.10992623794561939831737618078478e-01 6.57765738247428899398983048740774e-02 1.23230802380695114717212845789618e-01 5.87006980306553714094031093395643e-03
 	 3.38514162429845721913324041452142e-01 1.26124094984989471024405816024228e-01 5.35361742585164779306694526894717e-01 1.13030235429375063016532720894247e-02
 	 3.38514162429845721913324041452142e-01 5.35361742585164779306694526894717e-01 1.26124094984989471024405816024228e-01 1.13030235429375063016532720894247e-02
 	 1.26124094984989471024405816024228e-01 3.38514162429845721913324041452142e-01 5.35361742585164779306694526894717e-01 1.13030235429375063016532720894247e-02
 	 1.26124094984989471024405816024228e-01 5.35361742585164779306694526894717e-01 3.38514162429845721913324041452142e-01 1.13030235429375063016532720894247e-02
 	 5.35361742585164779306694526894717e-01 3.38514162429845721913324041452142e-01 1.26124094984989471024405816024228e-01 1.13030235429375063016532720894247e-02
 	 5.35361742585164779306694526894717e-01 1.26124094984989471024405816024228e-01 3.38514162429845721913324041452142e-01 1.13030235429375063016532720894247e-02
 	 3.54403602180687449241247577447211e-01 1.94870950923518471142870112089440e-01 4.50725446895794079615882310463348e-01 1.43164852696676166837752575133891e-02
 	 3.54403602180687449241247577447211e-01 4.50725446895794079615882310463348e-01 1.94870950923518471142870112089440e-01 1.43164852696676166837752575133891e-02
 	 1.94870950923518471142870112089440e-01 3.54403602180687449241247577447211e-01 4.50725446895794079615882310463348e-01 1.43164852696676166837752575133891e-02
 	 1.94870950923518471142870112089440e-01 4.50725446895794079615882310463348e-01 3.54403602180687449241247577447211e-01 1.43164852696676166837752575133891e-02
 	 4.50725446895794079615882310463348e-01 3.54403602180687449241247577447211e-01 1.94870950923518471142870112089440e-01 1.43164852696676166837752575133891e-02
 	 4.50725446895794079615882310463348e-01 1.94870950923518471142870112089440e-01 3.54403602180687449241247577447211e-01 1.43164852696676166837752575133891e-02
 	 2.63068297757808267078871722333133e-01 1.91001424572283140523865085924626e-01 5.45930277669908647908414423000067e-01 1.29260234501183211147656848538645e-02
 	 2.63068297757808267078871722333133e-01 5.45930277669908647908414423000067e-01 1.91001424572283140523865085924626e-01 1.29260234501183211147656848538645e-02
 	 1.91001424572283140523865085924626e-01 2.63068297757808267078871722333133e-01 5.45930277669908647908414423000067e-01 1.29260234501183211147656848538645e-02
 	 1.91001424572283140523865085924626e-01 5.45930277669908647908414423000067e-01 2.63068297757808267078871722333133e-01 1.29260234501183211147656848538645e-02
 	 5.45930277669908647908414423000067e-01 2.63068297757808267078871722333133e-01 1.91001424572283140523865085924626e-01 1.29260234501183211147656848538645e-02
 	 5.45930277669908647908414423000067e-01 1.91001424572283140523865085924626e-01 2.63068297757808267078871722333133e-01 1.29260234501183211147656848538645e-02
 	 4.34566173964669621998524462469504e-01 2.75334061245498980252666143542228e-02 5.37900419910780525079019298573257e-01 6.28159658089167544092745743000705e-03
 	 4.34566173964669621998524462469504e-01 5.37900419910780525079019298573257e-01 2.75334061245498980252666143542228e-02 6.28159658089167544092745743000705e-03
 	 2.75334061245498980252666143542228e-02 4.34566173964669621998524462469504e-01 5.37900419910780525079019298573257e-01 6.28159658089167544092745743000705e-03
 	 2.75334061245498980252666143542228e-02 5.37900419910780525079019298573257e-01 4.34566173964669621998524462469504e-01 6.28159658089167544092745743000705e-03
 	 5.37900419910780525079019298573257e-01 4.34566173964669621998524462469504e-01 2.75334061245498980252666143542228e-02 6.28159658089167544092745743000705e-03
 	 5.37900419910780525079019298573257e-01 2.75334061245498980252666143542228e-02 4.34566173964669621998524462469504e-01 6.28159658089167544092745743000705e-03
 	 1.64070987069878326813920921267709e-01 2.80639219813729780261812862818260e-02 8.07865090948748698629344744404079e-01 4.70193699410597579918524857589546e-03
 	 1.64070987069878326813920921267709e-01 8.07865090948748698629344744404079e-01 2.80639219813729780261812862818260e-02 4.70193699410597579918524857589546e-03
 	 2.80639219813729780261812862818260e-02 1.64070987069878326813920921267709e-01 8.07865090948748698629344744404079e-01 4.70193699410597579918524857589546e-03
 	 2.80639219813729780261812862818260e-02 8.07865090948748698629344744404079e-01 1.64070987069878326813920921267709e-01 4.70193699410597579918524857589546e-03
 	 8.07865090948748698629344744404079e-01 1.64070987069878326813920921267709e-01 2.80639219813729780261812862818260e-02 4.70193699410597579918524857589546e-03
 	 8.07865090948748698629344744404079e-01 2.80639219813729780261812862818260e-02 1.64070987069878326813920921267709e-01 4.70193699410597579918524857589546e-03
 	 4.26819997060804007249501523801882e-02 1.59024162689347069166156956043778e-02 9.41415584024984819500048160989536e-01 1.83050687614883141052235515644497e-03
 	 4.26819997060804007249501523801882e-02 9.41415584024984819500048160989536e-01 1.59024162689347069166156956043778e-02 1.83050687614883141052235515644497e-03
 	 1.59024162689347069166156956043778e-02 4.26819997060804007249501523801882e-02 9.41415584024984819500048160989536e-01 1.83050687614883141052235515644497e-03
 	 1.59024162689347069166156956043778e-02 9.41415584024984819500048160989536e-01 4.26819997060804007249501523801882e-02 1.83050687614883141052235515644497e-03
 	 9.41415584024984819500048160989536e-01 4.26819997060804007249501523801882e-02 1.59024162689347069166156956043778e-02 1.83050687614883141052235515644497e-03
 	 9.41415584024984819500048160989536e-01 1.59024162689347069166156956043778e-02 4.26819997060804007249501523801882e-02 1.83050687614883141052235515644497e-03
 	 9.39597946527298694130436729210487e-02 2.72942306520957758686485306043323e-02 8.78745974695174347779413892567391e-01 3.82188054709502785660779622389782e-03
 	 9.39597946527298694130436729210487e-02 8.78745974695174347779413892567391e-01 2.72942306520957758686485306043323e-02 3.82188054709502785660779622389782e-03
 	 2.72942306520957758686485306043323e-02 9.39597946527298694130436729210487e-02 8.78745974695174347779413892567391e-01 3.82188054709502785660779622389782e-03
 	 2.72942306520957758686485306043323e-02 8.78745974695174347779413892567391e-01 9.39597946527298694130436729210487e-02 3.82188054709502785660779622389782e-03
 	 8.78745974695174347779413892567391e-01 9.39597946527298694130436729210487e-02 2.72942306520957758686485306043323e-02 3.82188054709502785660779622389782e-03
 	 8.78745974695174347779413892567391e-01 2.72942306520957758686485306043323e-02 9.39597946527298694130436729210487e-02 3.82188054709502785660779622389782e-03
 	 1.35408853519934452291906268328603e-01 5.69121144541610401307307753882014e-03 8.58899935034649453235999772005016e-01 1.91988055746892117940649580276613e-03
 	 1.35408853519934452291906268328603e-01 8.58899935034649453235999772005016e-01 5.69121144541610401307307753882014e-03 1.91988055746892117940649580276613e-03
 	 5.69121144541610401307307753882014e-03 1.35408853519934452291906268328603e-01 8.58899935034649453235999772005016e-01 1.91988055746892117940649580276613e-03
 	 5.69121144541610401307307753882014e-03 8.58899935034649453235999772005016e-01 1.35408853519934452291906268328603e-01 1.91988055746892117940649580276613e-03
 	 8.58899935034649453235999772005016e-01 1.35408853519934452291906268328603e-01 5.69121144541610401307307753882014e-03 1.91988055746892117940649580276613e-03
 	 8.58899935034649453235999772005016e-01 5.69121144541610401307307753882014e-03 1.35408853519934452291906268328603e-01 1.91988055746892117940649580276613e-03
 	 3.96221514739659108617075844449573e-01 5.16234701662132353106038351597817e-03 5.98616138243719619893568051338661e-01 2.64256792316325652206221441531397e-03
 	 3.96221514739659108617075844449573e-01 5.98616138243719619893568051338661e-01 5.16234701662132353106038351597817e-03 2.64256792316325652206221441531397e-03
 	 5.16234701662132353106038351597817e-03 3.96221514739659108617075844449573e-01 5.98616138243719619893568051338661e-01 2.64256792316325652206221441531397e-03
 	 5.16234701662132353106038351597817e-03 5.98616138243719619893568051338661e-01 3.96221514739659108617075844449573e-01 2.64256792316325652206221441531397e-03
 	 5.98616138243719619893568051338661e-01 3.96221514739659108617075844449573e-01 5.16234701662132353106038351597817e-03 2.64256792316325652206221441531397e-03
 	 5.98616138243719619893568051338661e-01 5.16234701662132353106038351597817e-03 3.96221514739659108617075844449573e-01 2.64256792316325652206221441531397e-03
 	 2.94840425976739400892867593029223e-02 5.33708660694491229814495625305426e-04 9.69982248741631636335114308167249e-01 3.35621711466402967115330024938658e-04
 	 2.94840425976739400892867593029223e-02 9.69982248741631636335114308167249e-01 5.33708660694491229814495625305426e-04 3.35621711466402967115330024938658e-04
 	 5.33708660694491229814495625305426e-04 2.94840425976739400892867593029223e-02 9.69982248741631636335114308167249e-01 3.35621711466402967115330024938658e-04
 	 5.33708660694491229814495625305426e-04 9.69982248741631636335114308167249e-01 2.94840425976739400892867593029223e-02 3.35621711466402967115330024938658e-04
 	 9.69982248741631636335114308167249e-01 2.94840425976739400892867593029223e-02 5.33708660694491229814495625305426e-04 3.35621711466402967115330024938658e-04
 	 9.69982248741631636335114308167249e-01 5.33708660694491229814495625305426e-04 2.94840425976739400892867593029223e-02 3.35621711466402967115330024938658e-04
 	 ];
 
 	 case  31 

 	 % ALG. DEG.:   31
 	 % PTS CARD.:  181
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.7e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 8.34312081388637050149981178037706e-03
 	 4.86152467913059771476014248037245e-01 4.86152467913059771476014248037245e-01 2.76950641738804570479715039255098e-02 4.04398839651936518185815216952506e-03
 	 4.86152467913059771476014248037245e-01 2.76950641738804570479715039255098e-02 4.86152467913059771476014248037245e-01 4.04398839651936518185815216952506e-03
 	 2.76950641738804570479715039255098e-02 4.86152467913059771476014248037245e-01 4.86152467913059771476014248037245e-01 4.04398839651936518185815216952506e-03
 	 4.19588080864260470903559507860336e-01 4.19588080864260470903559507860336e-01 1.60823838271479058192880984279327e-01 8.84308264308831214195461001281728e-03
 	 4.19588080864260470903559507860336e-01 1.60823838271479058192880984279327e-01 4.19588080864260470903559507860336e-01 8.84308264308831214195461001281728e-03
 	 1.60823838271479058192880984279327e-01 4.19588080864260470903559507860336e-01 4.19588080864260470903559507860336e-01 8.84308264308831214195461001281728e-03
 	 7.92067965066985402167176744114840e-02 7.92067965066985402167176744114840e-02 8.41586406986602919566564651177032e-01 4.22372985110323027890810720919035e-03
 	 7.92067965066985402167176744114840e-02 8.41586406986602919566564651177032e-01 7.92067965066985402167176744114840e-02 4.22372985110323027890810720919035e-03
 	 8.41586406986602919566564651177032e-01 7.92067965066985402167176744114840e-02 7.92067965066985402167176744114840e-02 4.22372985110323027890810720919035e-03
 	 1.77313492497139200965161620615618e-02 1.77313492497139200965161620615618e-02 9.64537301500572152868073771969648e-01 9.86866145027083313187588053949639e-04
 	 1.77313492497139200965161620615618e-02 9.64537301500572152868073771969648e-01 1.77313492497139200965161620615618e-02 9.86866145027083313187588053949639e-04
 	 9.64537301500572152868073771969648e-01 1.77313492497139200965161620615618e-02 1.77313492497139200965161620615618e-02 9.86866145027083313187588053949639e-04
 	 2.18436496790928025291123049100861e-01 2.18436496790928025291123049100861e-01 5.63127006418143949417753901798278e-01 1.12370035080131738108866201741876e-02
 	 2.18436496790928025291123049100861e-01 5.63127006418143949417753901798278e-01 2.18436496790928025291123049100861e-01 1.12370035080131738108866201741876e-02
 	 5.63127006418143949417753901798278e-01 2.18436496790928025291123049100861e-01 2.18436496790928025291123049100861e-01 1.12370035080131738108866201741876e-02
 	 1.72450787183886011799671678090817e-01 1.72450787183886011799671678090817e-01 6.55098425632227976400656643818365e-01 9.55919596672841903606254732039815e-03
 	 1.72450787183886011799671678090817e-01 6.55098425632227976400656643818365e-01 1.72450787183886011799671678090817e-01 9.55919596672841903606254732039815e-03
 	 6.55098425632227976400656643818365e-01 1.72450787183886011799671678090817e-01 1.72450787183886011799671678090817e-01 9.55919596672841903606254732039815e-03
 	 5.10951808223812711795552843341284e-02 5.10951808223812711795552843341284e-02 8.97809638355237416007526007888373e-01 3.25908665018577112237885273771099e-03
 	 5.10951808223812711795552843341284e-02 8.97809638355237416007526007888373e-01 5.10951808223812711795552843341284e-02 3.25908665018577112237885273771099e-03
 	 8.97809638355237416007526007888373e-01 5.10951808223812711795552843341284e-02 5.10951808223812711795552843341284e-02 3.25908665018577112237885273771099e-03
 	 4.97748620626470295036369861918502e-01 4.97748620626470295036369861918502e-01 4.50275874705940992726027616299689e-03 2.32766064205643195134110001731642e-03
 	 4.97748620626470295036369861918502e-01 4.50275874705940992726027616299689e-03 4.97748620626470295036369861918502e-01 2.32766064205643195134110001731642e-03
 	 4.50275874705940992726027616299689e-03 4.97748620626470295036369861918502e-01 4.97748620626470295036369861918502e-01 2.32766064205643195134110001731642e-03
 	 3.85168469245680045176527528383303e-01 3.85168469245680045176527528383303e-01 2.29663061508639909646944943233393e-01 1.37393951965682631355392118166492e-02
 	 3.85168469245680045176527528383303e-01 2.29663061508639909646944943233393e-01 3.85168469245680045176527528383303e-01 1.37393951965682631355392118166492e-02
 	 2.29663061508639909646944943233393e-01 3.85168469245680045176527528383303e-01 3.85168469245680045176527528383303e-01 1.37393951965682631355392118166492e-02
 	 2.97491490367992827970056168851443e-01 2.97491490367992827970056168851443e-01 4.05017019264014344059887662297115e-01 1.23590405093469031527764201427999e-02
 	 2.97491490367992827970056168851443e-01 4.05017019264014344059887662297115e-01 2.97491490367992827970056168851443e-01 1.23590405093469031527764201427999e-02
 	 4.05017019264014344059887662297115e-01 2.97491490367992827970056168851443e-01 2.97491490367992827970056168851443e-01 1.23590405093469031527764201427999e-02
 	 5.08280946272773696825719724756709e-03 5.08280946272773696825719724756709e-03 9.89834381074544578105189884809079e-01 3.44401379272581099292432904590555e-04
 	 5.08280946272773696825719724756709e-03 9.89834381074544578105189884809079e-01 5.08280946272773696825719724756709e-03 3.44401379272581099292432904590555e-04
 	 9.89834381074544578105189884809079e-01 5.08280946272773696825719724756709e-03 5.08280946272773696825719724756709e-03 3.44401379272581099292432904590555e-04
 	 4.50340941739018174594377796893241e-01 4.50340941739018174594377796893241e-01 9.93181165219636508112444062135182e-02 1.04339772957805811126608119820958e-02
 	 4.50340941739018174594377796893241e-01 9.93181165219636508112444062135182e-02 4.50340941739018174594377796893241e-01 1.04339772957805811126608119820958e-02
 	 9.93181165219636508112444062135182e-02 4.50340941739018174594377796893241e-01 4.50340941739018174594377796893241e-01 1.04339772957805811126608119820958e-02
 	 1.39090628472094579581863627026905e-01 1.06669680864077562332248305665416e-01 7.54239690663827899719251490751049e-01 5.80629324836366700335332780014141e-03
 	 1.39090628472094579581863627026905e-01 7.54239690663827899719251490751049e-01 1.06669680864077562332248305665416e-01 5.80629324836366700335332780014141e-03
 	 1.06669680864077562332248305665416e-01 1.39090628472094579581863627026905e-01 7.54239690663827899719251490751049e-01 5.80629324836366700335332780014141e-03
 	 1.06669680864077562332248305665416e-01 7.54239690663827899719251490751049e-01 1.39090628472094579581863627026905e-01 5.80629324836366700335332780014141e-03
 	 7.54239690663827899719251490751049e-01 1.39090628472094579581863627026905e-01 1.06669680864077562332248305665416e-01 5.80629324836366700335332780014141e-03
 	 7.54239690663827899719251490751049e-01 1.06669680864077562332248305665416e-01 1.39090628472094579581863627026905e-01 5.80629324836366700335332780014141e-03
 	 1.97233130789653043901665796511224e-01 3.26115566372831879038418634308982e-03 7.99505713546618590470416165771894e-01 1.28385169876969610150418965588415e-03
 	 1.97233130789653043901665796511224e-01 7.99505713546618590470416165771894e-01 3.26115566372831879038418634308982e-03 1.28385169876969610150418965588415e-03
 	 3.26115566372831879038418634308982e-03 1.97233130789653043901665796511224e-01 7.99505713546618590470416165771894e-01 1.28385169876969610150418965588415e-03
 	 3.26115566372831879038418634308982e-03 7.99505713546618590470416165771894e-01 1.97233130789653043901665796511224e-01 1.28385169876969610150418965588415e-03
 	 7.99505713546618590470416165771894e-01 1.97233130789653043901665796511224e-01 3.26115566372831879038418634308982e-03 1.28385169876969610150418965588415e-03
 	 7.99505713546618590470416165771894e-01 3.26115566372831879038418634308982e-03 1.97233130789653043901665796511224e-01 1.28385169876969610150418965588415e-03
 	 2.38524150984310012724165517283836e-01 1.31398178404036562044732150411619e-02 7.48336031175286353622766455373494e-01 2.82651427592773858005203990728660e-03
 	 2.38524150984310012724165517283836e-01 7.48336031175286353622766455373494e-01 1.31398178404036562044732150411619e-02 2.82651427592773858005203990728660e-03
 	 1.31398178404036562044732150411619e-02 2.38524150984310012724165517283836e-01 7.48336031175286353622766455373494e-01 2.82651427592773858005203990728660e-03
 	 1.31398178404036562044732150411619e-02 7.48336031175286353622766455373494e-01 2.38524150984310012724165517283836e-01 2.82651427592773858005203990728660e-03
 	 7.48336031175286353622766455373494e-01 2.38524150984310012724165517283836e-01 1.31398178404036562044732150411619e-02 2.82651427592773858005203990728660e-03
 	 7.48336031175286353622766455373494e-01 1.31398178404036562044732150411619e-02 2.38524150984310012724165517283836e-01 2.82651427592773858005203990728660e-03
 	 2.97507293859899553389869453212668e-02 2.34422112868689367162766679086872e-03 9.67905049485323076829956789879361e-01 5.05509046872258259626431442512740e-04
 	 2.97507293859899553389869453212668e-02 9.67905049485323076829956789879361e-01 2.34422112868689367162766679086872e-03 5.05509046872258259626431442512740e-04
 	 2.34422112868689367162766679086872e-03 2.97507293859899553389869453212668e-02 9.67905049485323076829956789879361e-01 5.05509046872258259626431442512740e-04
 	 2.34422112868689367162766679086872e-03 9.67905049485323076829956789879361e-01 2.97507293859899553389869453212668e-02 5.05509046872258259626431442512740e-04
 	 9.67905049485323076829956789879361e-01 2.97507293859899553389869453212668e-02 2.34422112868689367162766679086872e-03 5.05509046872258259626431442512740e-04
 	 9.67905049485323076829956789879361e-01 2.34422112868689367162766679086872e-03 2.97507293859899553389869453212668e-02 5.05509046872258259626431442512740e-04
 	 3.95783933296885381825092053986737e-01 1.96140036989502072536928345414253e-03 6.02254666333219668139520308614010e-01 1.30269544897345149712941658748377e-03
 	 3.95783933296885381825092053986737e-01 6.02254666333219668139520308614010e-01 1.96140036989502072536928345414253e-03 1.30269544897345149712941658748377e-03
 	 1.96140036989502072536928345414253e-03 3.95783933296885381825092053986737e-01 6.02254666333219668139520308614010e-01 1.30269544897345149712941658748377e-03
 	 1.96140036989502072536928345414253e-03 6.02254666333219668139520308614010e-01 3.95783933296885381825092053986737e-01 1.30269544897345149712941658748377e-03
 	 6.02254666333219668139520308614010e-01 3.95783933296885381825092053986737e-01 1.96140036989502072536928345414253e-03 1.30269544897345149712941658748377e-03
 	 6.02254666333219668139520308614010e-01 1.96140036989502072536928345414253e-03 3.95783933296885381825092053986737e-01 1.30269544897345149712941658748377e-03
 	 3.51680058776080939342278952608467e-01 1.52636565775219751328606321294501e-01 4.95683375448699337084690341725945e-01 1.01925794443412758016886954237634e-02
 	 3.51680058776080939342278952608467e-01 4.95683375448699337084690341725945e-01 1.52636565775219751328606321294501e-01 1.01925794443412758016886954237634e-02
 	 1.52636565775219751328606321294501e-01 3.51680058776080939342278952608467e-01 4.95683375448699337084690341725945e-01 1.01925794443412758016886954237634e-02
 	 1.52636565775219751328606321294501e-01 4.95683375448699337084690341725945e-01 3.51680058776080939342278952608467e-01 1.01925794443412758016886954237634e-02
 	 4.95683375448699337084690341725945e-01 3.51680058776080939342278952608467e-01 1.52636565775219751328606321294501e-01 1.01925794443412758016886954237634e-02
 	 4.95683375448699337084690341725945e-01 1.52636565775219751328606321294501e-01 3.51680058776080939342278952608467e-01 1.01925794443412758016886954237634e-02
 	 2.02482194261758341458090626474586e-01 1.13425278347502905829102815005172e-01 6.84092527390738780468382174149156e-01 7.86687049573813780567466125148712e-03
 	 2.02482194261758341458090626474586e-01 6.84092527390738780468382174149156e-01 1.13425278347502905829102815005172e-01 7.86687049573813780567466125148712e-03
 	 1.13425278347502905829102815005172e-01 2.02482194261758341458090626474586e-01 6.84092527390738780468382174149156e-01 7.86687049573813780567466125148712e-03
 	 1.13425278347502905829102815005172e-01 6.84092527390738780468382174149156e-01 2.02482194261758341458090626474586e-01 7.86687049573813780567466125148712e-03
 	 6.84092527390738780468382174149156e-01 2.02482194261758341458090626474586e-01 1.13425278347502905829102815005172e-01 7.86687049573813780567466125148712e-03
 	 6.84092527390738780468382174149156e-01 1.13425278347502905829102815005172e-01 2.02482194261758341458090626474586e-01 7.86687049573813780567466125148712e-03
 	 4.22553955222215060771873140765820e-01 5.45213844446831366608030577936006e-02 5.22924660333101809506217705347808e-01 7.12080924141879172128977160127761e-03
 	 4.22553955222215060771873140765820e-01 5.22924660333101809506217705347808e-01 5.45213844446831366608030577936006e-02 7.12080924141879172128977160127761e-03
 	 5.45213844446831366608030577936006e-02 4.22553955222215060771873140765820e-01 5.22924660333101809506217705347808e-01 7.12080924141879172128977160127761e-03
 	 5.45213844446831366608030577936006e-02 5.22924660333101809506217705347808e-01 4.22553955222215060771873140765820e-01 7.12080924141879172128977160127761e-03
 	 5.22924660333101809506217705347808e-01 4.22553955222215060771873140765820e-01 5.45213844446831366608030577936006e-02 7.12080924141879172128977160127761e-03
 	 5.22924660333101809506217705347808e-01 5.45213844446831366608030577936006e-02 4.22553955222215060771873140765820e-01 7.12080924141879172128977160127761e-03
 	 1.24680508847443971554014296998503e-01 6.06049291607722168118144168147410e-02 8.14714561991783825511959094001213e-01 4.96411447650766963352042537849229e-03
 	 1.24680508847443971554014296998503e-01 8.14714561991783825511959094001213e-01 6.06049291607722168118144168147410e-02 4.96411447650766963352042537849229e-03
 	 6.06049291607722168118144168147410e-02 1.24680508847443971554014296998503e-01 8.14714561991783825511959094001213e-01 4.96411447650766963352042537849229e-03
 	 6.06049291607722168118144168147410e-02 8.14714561991783825511959094001213e-01 1.24680508847443971554014296998503e-01 4.96411447650766963352042537849229e-03
 	 8.14714561991783825511959094001213e-01 1.24680508847443971554014296998503e-01 6.06049291607722168118144168147410e-02 4.96411447650766963352042537849229e-03
 	 8.14714561991783825511959094001213e-01 6.06049291607722168118144168147410e-02 1.24680508847443971554014296998503e-01 4.96411447650766963352042537849229e-03
 	 2.55546236402857285252565588962170e-01 3.75889521575177576462323258965625e-02 7.06864811439624873834475238254527e-01 5.43643747301355336615236168995580e-03
 	 2.55546236402857285252565588962170e-01 7.06864811439624873834475238254527e-01 3.75889521575177576462323258965625e-02 5.43643747301355336615236168995580e-03
 	 3.75889521575177576462323258965625e-02 2.55546236402857285252565588962170e-01 7.06864811439624873834475238254527e-01 5.43643747301355336615236168995580e-03
 	 3.75889521575177576462323258965625e-02 7.06864811439624873834475238254527e-01 2.55546236402857285252565588962170e-01 5.43643747301355336615236168995580e-03
 	 7.06864811439624873834475238254527e-01 2.55546236402857285252565588962170e-01 3.75889521575177576462323258965625e-02 5.43643747301355336615236168995580e-03
 	 7.06864811439624873834475238254527e-01 3.75889521575177576462323258965625e-02 2.55546236402857285252565588962170e-01 5.43643747301355336615236168995580e-03
 	 7.45031299353863113443807719704637e-02 4.38633017006165564638520137918931e-03 9.21110539894552049489107048430014e-01 1.15258294008426160660862880291688e-03
 	 7.45031299353863113443807719704637e-02 9.21110539894552049489107048430014e-01 4.38633017006165564638520137918931e-03 1.15258294008426160660862880291688e-03
 	 4.38633017006165564638520137918931e-03 7.45031299353863113443807719704637e-02 9.21110539894552049489107048430014e-01 1.15258294008426160660862880291688e-03
 	 4.38633017006165564638520137918931e-03 9.21110539894552049489107048430014e-01 7.45031299353863113443807719704637e-02 1.15258294008426160660862880291688e-03
 	 9.21110539894552049489107048430014e-01 7.45031299353863113443807719704637e-02 4.38633017006165564638520137918931e-03 1.15258294008426160660862880291688e-03
 	 9.21110539894552049489107048430014e-01 4.38633017006165564638520137918931e-03 7.45031299353863113443807719704637e-02 1.15258294008426160660862880291688e-03
 	 4.16807275523650544446496724049211e-01 1.72734143249371197015307188848965e-02 5.65919310151412391363123788323719e-01 4.17833269182153049792205479207041e-03
 	 4.16807275523650544446496724049211e-01 5.65919310151412391363123788323719e-01 1.72734143249371197015307188848965e-02 4.17833269182153049792205479207041e-03
 	 1.72734143249371197015307188848965e-02 4.16807275523650544446496724049211e-01 5.65919310151412391363123788323719e-01 4.17833269182153049792205479207041e-03
 	 1.72734143249371197015307188848965e-02 5.65919310151412391363123788323719e-01 4.16807275523650544446496724049211e-01 4.17833269182153049792205479207041e-03
 	 5.65919310151412391363123788323719e-01 4.16807275523650544446496724049211e-01 1.72734143249371197015307188848965e-02 4.17833269182153049792205479207041e-03
 	 5.65919310151412391363123788323719e-01 1.72734143249371197015307188848965e-02 4.16807275523650544446496724049211e-01 4.17833269182153049792205479207041e-03
 	 1.92871723006198453331805353627715e-01 6.25780220143109106034629007808689e-02 7.44550254979490566675792706519132e-01 6.36242305286687740567552751258518e-03
 	 1.92871723006198453331805353627715e-01 7.44550254979490566675792706519132e-01 6.25780220143109106034629007808689e-02 6.36242305286687740567552751258518e-03
 	 6.25780220143109106034629007808689e-02 1.92871723006198453331805353627715e-01 7.44550254979490566675792706519132e-01 6.36242305286687740567552751258518e-03
 	 6.25780220143109106034629007808689e-02 7.44550254979490566675792706519132e-01 1.92871723006198453331805353627715e-01 6.36242305286687740567552751258518e-03
 	 7.44550254979490566675792706519132e-01 1.92871723006198453331805353627715e-01 6.25780220143109106034629007808689e-02 6.36242305286687740567552751258518e-03
 	 7.44550254979490566675792706519132e-01 6.25780220143109106034629007808689e-02 1.92871723006198453331805353627715e-01 6.36242305286687740567552751258518e-03
 	 4.73478189395524634575096456501342e-02 1.84079470312829319988967569088345e-02 9.34244234029164677401979588466929e-01 1.81276928828391073120207543922788e-03
 	 4.73478189395524634575096456501342e-02 9.34244234029164677401979588466929e-01 1.84079470312829319988967569088345e-02 1.81276928828391073120207543922788e-03
 	 1.84079470312829319988967569088345e-02 4.73478189395524634575096456501342e-02 9.34244234029164677401979588466929e-01 1.81276928828391073120207543922788e-03
 	 1.84079470312829319988967569088345e-02 9.34244234029164677401979588466929e-01 4.73478189395524634575096456501342e-02 1.81276928828391073120207543922788e-03
 	 9.34244234029164677401979588466929e-01 4.73478189395524634575096456501342e-02 1.84079470312829319988967569088345e-02 1.81276928828391073120207543922788e-03
 	 9.34244234029164677401979588466929e-01 1.84079470312829319988967569088345e-02 4.73478189395524634575096456501342e-02 1.81276928828391073120207543922788e-03
 	 3.41905005347527657377781906689052e-01 4.29032089427714424800797132775187e-02 6.15191785709700900142138380033430e-01 6.68995924504562581441868829301711e-03
 	 3.41905005347527657377781906689052e-01 6.15191785709700900142138380033430e-01 4.29032089427714424800797132775187e-02 6.68995924504562581441868829301711e-03
 	 4.29032089427714424800797132775187e-02 3.41905005347527657377781906689052e-01 6.15191785709700900142138380033430e-01 6.68995924504562581441868829301711e-03
 	 4.29032089427714424800797132775187e-02 6.15191785709700900142138380033430e-01 3.41905005347527657377781906689052e-01 6.68995924504562581441868829301711e-03
 	 6.15191785709700900142138380033430e-01 3.41905005347527657377781906689052e-01 4.29032089427714424800797132775187e-02 6.68995924504562581441868829301711e-03
 	 6.15191785709700900142138380033430e-01 4.29032089427714424800797132775187e-02 3.41905005347527657377781906689052e-01 6.68995924504562581441868829301711e-03
 	 3.25813953057509653188361653519678e-01 1.31890837790157033904137051649741e-02 6.60996963163474560154497794428607e-01 3.63971348494744042709192477502711e-03
 	 3.25813953057509653188361653519678e-01 6.60996963163474560154497794428607e-01 1.31890837790157033904137051649741e-02 3.63971348494744042709192477502711e-03
 	 1.31890837790157033904137051649741e-02 3.25813953057509653188361653519678e-01 6.60996963163474560154497794428607e-01 3.63971348494744042709192477502711e-03
 	 1.31890837790157033904137051649741e-02 6.60996963163474560154497794428607e-01 3.25813953057509653188361653519678e-01 3.63971348494744042709192477502711e-03
 	 6.60996963163474560154497794428607e-01 3.25813953057509653188361653519678e-01 1.31890837790157033904137051649741e-02 3.63971348494744042709192477502711e-03
 	 6.60996963163474560154497794428607e-01 1.31890837790157033904137051649741e-02 3.25813953057509653188361653519678e-01 3.63971348494744042709192477502711e-03
 	 2.89425948757137285749507782384171e-01 1.19688163070959881391364110214681e-03 7.09377169612153024580436522228410e-01 9.29370337693118044215812023622902e-04
 	 2.89425948757137285749507782384171e-01 7.09377169612153024580436522228410e-01 1.19688163070959881391364110214681e-03 9.29370337693118044215812023622902e-04
 	 1.19688163070959881391364110214681e-03 2.89425948757137285749507782384171e-01 7.09377169612153024580436522228410e-01 9.29370337693118044215812023622902e-04
 	 1.19688163070959881391364110214681e-03 7.09377169612153024580436522228410e-01 2.89425948757137285749507782384171e-01 9.29370337693118044215812023622902e-04
 	 7.09377169612153024580436522228410e-01 2.89425948757137285749507782384171e-01 1.19688163070959881391364110214681e-03 9.29370337693118044215812023622902e-04
 	 7.09377169612153024580436522228410e-01 1.19688163070959881391364110214681e-03 2.89425948757137285749507782384171e-01 9.29370337693118044215812023622902e-04
 	 2.98789795676013270053772430401295e-01 2.19132761430176847827766550835804e-01 4.82077442893809882118461018762900e-01 1.28955867879841940687457579883812e-02
 	 2.98789795676013270053772430401295e-01 4.82077442893809882118461018762900e-01 2.19132761430176847827766550835804e-01 1.28955867879841940687457579883812e-02
 	 2.19132761430176847827766550835804e-01 2.98789795676013270053772430401295e-01 4.82077442893809882118461018762900e-01 1.28955867879841940687457579883812e-02
 	 2.19132761430176847827766550835804e-01 4.82077442893809882118461018762900e-01 2.98789795676013270053772430401295e-01 1.28955867879841940687457579883812e-02
 	 4.82077442893809882118461018762900e-01 2.98789795676013270053772430401295e-01 2.19132761430176847827766550835804e-01 1.28955867879841940687457579883812e-02
 	 4.82077442893809882118461018762900e-01 2.19132761430176847827766550835804e-01 2.98789795676013270053772430401295e-01 1.28955867879841940687457579883812e-02
 	 2.74475747742794984329606222672737e-01 8.11298915693309669050492516362283e-02 6.44394360687874034887556717876578e-01 8.47589771713661878360657198072659e-03
 	 2.74475747742794984329606222672737e-01 6.44394360687874034887556717876578e-01 8.11298915693309669050492516362283e-02 8.47589771713661878360657198072659e-03
 	 8.11298915693309669050492516362283e-02 2.74475747742794984329606222672737e-01 6.44394360687874034887556717876578e-01 8.47589771713661878360657198072659e-03
 	 8.11298915693309669050492516362283e-02 6.44394360687874034887556717876578e-01 2.74475747742794984329606222672737e-01 8.47589771713661878360657198072659e-03
 	 6.44394360687874034887556717876578e-01 2.74475747742794984329606222672737e-01 8.11298915693309669050492516362283e-02 8.47589771713661878360657198072659e-03
 	 6.44394360687874034887556717876578e-01 8.11298915693309669050492516362283e-02 2.74475747742794984329606222672737e-01 8.47589771713661878360657198072659e-03
 	 3.53229873891415580011710062535712e-01 9.52781144820168263143145281901525e-02 5.51492011626567579796187601459678e-01 9.62227553169672442101578724305000e-03
 	 3.53229873891415580011710062535712e-01 5.51492011626567579796187601459678e-01 9.52781144820168263143145281901525e-02 9.62227553169672442101578724305000e-03
 	 9.52781144820168263143145281901525e-02 3.53229873891415580011710062535712e-01 5.51492011626567579796187601459678e-01 9.62227553169672442101578724305000e-03
 	 9.52781144820168263143145281901525e-02 5.51492011626567579796187601459678e-01 3.53229873891415580011710062535712e-01 9.62227553169672442101578724305000e-03
 	 5.51492011626567579796187601459678e-01 3.53229873891415580011710062535712e-01 9.52781144820168263143145281901525e-02 9.62227553169672442101578724305000e-03
 	 5.51492011626567579796187601459678e-01 9.52781144820168263143145281901525e-02 3.53229873891415580011710062535712e-01 9.62227553169672442101578724305000e-03
 	 2.66367882475071815484568560350453e-01 1.46888708002111900707831182444352e-01 5.86743409522816339318751488463022e-01 1.15996690313856214843424297100682e-02
 	 2.66367882475071815484568560350453e-01 5.86743409522816339318751488463022e-01 1.46888708002111900707831182444352e-01 1.15996690313856214843424297100682e-02
 	 1.46888708002111900707831182444352e-01 2.66367882475071815484568560350453e-01 5.86743409522816339318751488463022e-01 1.15996690313856214843424297100682e-02
 	 1.46888708002111900707831182444352e-01 5.86743409522816339318751488463022e-01 2.66367882475071815484568560350453e-01 1.15996690313856214843424297100682e-02
 	 5.86743409522816339318751488463022e-01 2.66367882475071815484568560350453e-01 1.46888708002111900707831182444352e-01 1.15996690313856214843424297100682e-02
 	 5.86743409522816339318751488463022e-01 1.46888708002111900707831182444352e-01 2.66367882475071815484568560350453e-01 1.15996690313856214843424297100682e-02
 	 9.60481521010510957969685819080041e-02 2.75306300785874945302733607377377e-02 8.76421217820361420081098913215101e-01 3.66658670492684595279553327884514e-03
 	 9.60481521010510957969685819080041e-02 8.76421217820361420081098913215101e-01 2.75306300785874945302733607377377e-02 3.66658670492684595279553327884514e-03
 	 2.75306300785874945302733607377377e-02 9.60481521010510957969685819080041e-02 8.76421217820361420081098913215101e-01 3.66658670492684595279553327884514e-03
 	 2.75306300785874945302733607377377e-02 8.76421217820361420081098913215101e-01 9.60481521010510957969685819080041e-02 3.66658670492684595279553327884514e-03
 	 8.76421217820361420081098913215101e-01 9.60481521010510957969685819080041e-02 2.75306300785874945302733607377377e-02 3.66658670492684595279553327884514e-03
 	 8.76421217820361420081098913215101e-01 2.75306300785874945302733607377377e-02 9.60481521010510957969685819080041e-02 3.66658670492684595279553327884514e-03
 	 1.67407824778356056905082027697063e-01 2.58751082199381692017237099889826e-02 8.06717067001705756545959502545884e-01 4.44533799125240106780987403567451e-03
 	 1.67407824778356056905082027697063e-01 8.06717067001705756545959502545884e-01 2.58751082199381692017237099889826e-02 4.44533799125240106780987403567451e-03
 	 2.58751082199381692017237099889826e-02 1.67407824778356056905082027697063e-01 8.06717067001705756545959502545884e-01 4.44533799125240106780987403567451e-03
 	 2.58751082199381692017237099889826e-02 8.06717067001705756545959502545884e-01 1.67407824778356056905082027697063e-01 4.44533799125240106780987403567451e-03
 	 8.06717067001705756545959502545884e-01 1.67407824778356056905082027697063e-01 2.58751082199381692017237099889826e-02 4.44533799125240106780987403567451e-03
 	 8.06717067001705756545959502545884e-01 2.58751082199381692017237099889826e-02 1.67407824778356056905082027697063e-01 4.44533799125240106780987403567451e-03
 	 1.30677633770288320613772725664603e-01 5.79731868473983870393428929901347e-03 8.63525047544971835478122557105962e-01 1.82125278412247244841370985568574e-03
 	 1.30677633770288320613772725664603e-01 8.63525047544971835478122557105962e-01 5.79731868473983870393428929901347e-03 1.82125278412247244841370985568574e-03
 	 5.79731868473983870393428929901347e-03 1.30677633770288320613772725664603e-01 8.63525047544971835478122557105962e-01 1.82125278412247244841370985568574e-03
 	 5.79731868473983870393428929901347e-03 8.63525047544971835478122557105962e-01 1.30677633770288320613772725664603e-01 1.82125278412247244841370985568574e-03
 	 8.63525047544971835478122557105962e-01 1.30677633770288320613772725664603e-01 5.79731868473983870393428929901347e-03 1.82125278412247244841370985568574e-03
 	 8.63525047544971835478122557105962e-01 5.79731868473983870393428929901347e-03 1.30677633770288320613772725664603e-01 1.82125278412247244841370985568574e-03
 	 ];
 
 	 case  32 

 	 % ALG. DEG.:   32
 	 % PTS CARD.:  193
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.7e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.30300709957625760609944975954022e-02
 	 1.45744546236985564845178853232710e-03 1.45744546236985564845178853232710e-03 9.97085109075260267452733842219459e-01 5.33239023334161204052336624492625e-05
 	 1.45744546236985564845178853232710e-03 9.97085109075260267452733842219459e-01 1.45744546236985564845178853232710e-03 5.33239023334161204052336624492625e-05
 	 9.97085109075260267452733842219459e-01 1.45744546236985564845178853232710e-03 1.45744546236985564845178853232710e-03 5.33239023334161204052336624492625e-05
 	 4.98650893578847342890725258257589e-01 4.98650893578847342890725258257589e-01 2.69821284230531421854948348482139e-03 1.41462724766283957054946451847854e-03
 	 4.98650893578847342890725258257589e-01 2.69821284230531421854948348482139e-03 4.98650893578847342890725258257589e-01 1.41462724766283957054946451847854e-03
 	 2.69821284230531421854948348482139e-03 4.98650893578847342890725258257589e-01 4.98650893578847342890725258257589e-01 1.41462724766283957054946451847854e-03
 	 4.81168115995836753739922642125748e-01 4.81168115995836753739922642125748e-01 3.76637680083264925201547157485038e-02 5.58001514241327021409455610978512e-03
 	 4.81168115995836753739922642125748e-01 3.76637680083264925201547157485038e-02 4.81168115995836753739922642125748e-01 5.58001514241327021409455610978512e-03
 	 3.76637680083264925201547157485038e-02 4.81168115995836753739922642125748e-01 4.81168115995836753739922642125748e-01 5.58001514241327021409455610978512e-03
 	 4.52285756511600522955518499657046e-01 4.52285756511600522955518499657046e-01 9.54284869767989540889630006859079e-02 8.37859070412624515333810393258318e-03
 	 4.52285756511600522955518499657046e-01 9.54284869767989540889630006859079e-02 4.52285756511600522955518499657046e-01 8.37859070412624515333810393258318e-03
 	 9.54284869767989540889630006859079e-02 4.52285756511600522955518499657046e-01 4.52285756511600522955518499657046e-01 8.37859070412624515333810393258318e-03
 	 3.76328758047918987550417568854755e-01 3.76328758047918987550417568854755e-01 2.47342483904162024899164862290490e-01 1.26612945604860326065388420602176e-02
 	 3.76328758047918987550417568854755e-01 2.47342483904162024899164862290490e-01 3.76328758047918987550417568854755e-01 1.26612945604860326065388420602176e-02
 	 2.47342483904162024899164862290490e-01 3.76328758047918987550417568854755e-01 3.76328758047918987550417568854755e-01 1.26612945604860326065388420602176e-02
 	 2.83018279849573173301280348823639e-01 2.83018279849573173301280348823639e-01 4.33963440300853653397439302352723e-01 1.28827331771753633010701989292102e-02
 	 2.83018279849573173301280348823639e-01 4.33963440300853653397439302352723e-01 2.83018279849573173301280348823639e-01 1.28827331771753633010701989292102e-02
 	 4.33963440300853653397439302352723e-01 2.83018279849573173301280348823639e-01 2.83018279849573173301280348823639e-01 1.28827331771753633010701989292102e-02
 	 4.13679784325413357759515520228888e-01 4.13679784325413357759515520228888e-01 1.72640431349173284480968959542224e-01 1.08804660269342500650280314289375e-02
 	 4.13679784325413357759515520228888e-01 1.72640431349173284480968959542224e-01 4.13679784325413357759515520228888e-01 1.08804660269342500650280314289375e-02
 	 1.72640431349173284480968959542224e-01 4.13679784325413357759515520228888e-01 4.13679784325413357759515520228888e-01 1.08804660269342500650280314289375e-02
 	 3.02691910404441627546745507970627e-02 3.02691910404441627546745507970627e-02 9.39461617919111646735075282776961e-01 1.85927825319389013192239445970699e-03
 	 3.02691910404441627546745507970627e-02 9.39461617919111646735075282776961e-01 3.02691910404441627546745507970627e-02 1.85927825319389013192239445970699e-03
 	 9.39461617919111646735075282776961e-01 3.02691910404441627546745507970627e-02 3.02691910404441627546745507970627e-02 1.85927825319389013192239445970699e-03
 	 1.28101964801118073378205508561223e-02 1.28101964801118073378205508561223e-02 9.74379607039776329813207667029928e-01 8.01741051673073826418225440448850e-04
 	 1.28101964801118073378205508561223e-02 9.74379607039776329813207667029928e-01 1.28101964801118073378205508561223e-02 8.01741051673073826418225440448850e-04
 	 9.74379607039776329813207667029928e-01 1.28101964801118073378205508561223e-02 1.28101964801118073378205508561223e-02 8.01741051673073826418225440448850e-04
 	 6.20106498262642247265574724224280e-02 6.20106498262642247265574724224280e-02 8.75978700347471495035733823897317e-01 3.97634859492536092001602199275112e-03
 	 6.20106498262642247265574724224280e-02 8.75978700347471495035733823897317e-01 6.20106498262642247265574724224280e-02 3.97634859492536092001602199275112e-03
 	 8.75978700347471495035733823897317e-01 6.20106498262642247265574724224280e-02 6.20106498262642247265574724224280e-02 3.97634859492536092001602199275112e-03
 	 2.29277996928069882631717746335198e-01 2.29277996928069882631717746335198e-01 5.41444006143860234736564507329604e-01 1.25355977256488837490167043142719e-02
 	 2.29277996928069882631717746335198e-01 5.41444006143860234736564507329604e-01 2.29277996928069882631717746335198e-01 1.25355977256488837490167043142719e-02
 	 5.41444006143860234736564507329604e-01 2.29277996928069882631717746335198e-01 2.29277996928069882631717746335198e-01 1.25355977256488837490167043142719e-02
 	 1.01958826900269583504154979891609e-01 1.01958826900269583504154979891609e-01 7.96082346199460832991690040216781e-01 6.62939911505915427381019355834724e-03
 	 1.01958826900269583504154979891609e-01 7.96082346199460832991690040216781e-01 1.01958826900269583504154979891609e-01 6.62939911505915427381019355834724e-03
 	 7.96082346199460832991690040216781e-01 1.01958826900269583504154979891609e-01 1.01958826900269583504154979891609e-01 6.62939911505915427381019355834724e-03
 	 2.06831686315902013584278051894216e-01 1.58867941229046738538244198934990e-01 6.34300372455051331144204596057534e-01 8.34921912953793914080602434069078e-03
 	 2.06831686315902013584278051894216e-01 6.34300372455051331144204596057534e-01 1.58867941229046738538244198934990e-01 8.34921912953793914080602434069078e-03
 	 1.58867941229046738538244198934990e-01 2.06831686315902013584278051894216e-01 6.34300372455051331144204596057534e-01 8.34921912953793914080602434069078e-03
 	 1.58867941229046738538244198934990e-01 6.34300372455051331144204596057534e-01 2.06831686315902013584278051894216e-01 8.34921912953793914080602434069078e-03
 	 6.34300372455051331144204596057534e-01 2.06831686315902013584278051894216e-01 1.58867941229046738538244198934990e-01 8.34921912953793914080602434069078e-03
 	 6.34300372455051331144204596057534e-01 1.58867941229046738538244198934990e-01 2.06831686315902013584278051894216e-01 8.34921912953793914080602434069078e-03
 	 4.46761426533167027574933172218152e-01 1.47664424308546586572798986480848e-02 5.38472131035978351931703400623519e-01 3.04065225777299871778858175730420e-03
 	 4.46761426533167027574933172218152e-01 5.38472131035978351931703400623519e-01 1.47664424308546586572798986480848e-02 3.04065225777299871778858175730420e-03
 	 1.47664424308546586572798986480848e-02 4.46761426533167027574933172218152e-01 5.38472131035978351931703400623519e-01 3.04065225777299871778858175730420e-03
 	 1.47664424308546586572798986480848e-02 5.38472131035978351931703400623519e-01 4.46761426533167027574933172218152e-01 3.04065225777299871778858175730420e-03
 	 5.38472131035978351931703400623519e-01 4.46761426533167027574933172218152e-01 1.47664424308546586572798986480848e-02 3.04065225777299871778858175730420e-03
 	 5.38472131035978351931703400623519e-01 1.47664424308546586572798986480848e-02 4.46761426533167027574933172218152e-01 3.04065225777299871778858175730420e-03
 	 2.32466207646378680840015817921085e-01 5.14311272402330696418282229842589e-02 7.16102665113388270334837670816341e-01 5.28604360253248119205782273866134e-03
 	 2.32466207646378680840015817921085e-01 7.16102665113388270334837670816341e-01 5.14311272402330696418282229842589e-02 5.28604360253248119205782273866134e-03
 	 5.14311272402330696418282229842589e-02 2.32466207646378680840015817921085e-01 7.16102665113388270334837670816341e-01 5.28604360253248119205782273866134e-03
 	 5.14311272402330696418282229842589e-02 7.16102665113388270334837670816341e-01 2.32466207646378680840015817921085e-01 5.28604360253248119205782273866134e-03
 	 7.16102665113388270334837670816341e-01 2.32466207646378680840015817921085e-01 5.14311272402330696418282229842589e-02 5.28604360253248119205782273866134e-03
 	 7.16102665113388270334837670816341e-01 5.14311272402330696418282229842589e-02 2.32466207646378680840015817921085e-01 5.28604360253248119205782273866134e-03
 	 1.16834926706957942244002879306208e-01 1.95597403645923935411321537003460e-02 8.63605332928449653806524111132603e-01 2.49326992466906939213688865208951e-03
 	 1.16834926706957942244002879306208e-01 8.63605332928449653806524111132603e-01 1.95597403645923935411321537003460e-02 2.49326992466906939213688865208951e-03
 	 1.95597403645923935411321537003460e-02 1.16834926706957942244002879306208e-01 8.63605332928449653806524111132603e-01 2.49326992466906939213688865208951e-03
 	 1.95597403645923935411321537003460e-02 8.63605332928449653806524111132603e-01 1.16834926706957942244002879306208e-01 2.49326992466906939213688865208951e-03
 	 8.63605332928449653806524111132603e-01 1.16834926706957942244002879306208e-01 1.95597403645923935411321537003460e-02 2.49326992466906939213688865208951e-03
 	 8.63605332928449653806524111132603e-01 1.95597403645923935411321537003460e-02 1.16834926706957942244002879306208e-01 2.49326992466906939213688865208951e-03
 	 3.28240545844934006325388509139884e-01 1.26185667501572066490078682932108e-02 6.59140887404908837332584425894311e-01 3.02058105671362689750858443460402e-03
 	 3.28240545844934006325388509139884e-01 6.59140887404908837332584425894311e-01 1.26185667501572066490078682932108e-02 3.02058105671362689750858443460402e-03
 	 1.26185667501572066490078682932108e-02 3.28240545844934006325388509139884e-01 6.59140887404908837332584425894311e-01 3.02058105671362689750858443460402e-03
 	 1.26185667501572066490078682932108e-02 6.59140887404908837332584425894311e-01 3.28240545844934006325388509139884e-01 3.02058105671362689750858443460402e-03
 	 6.59140887404908837332584425894311e-01 3.28240545844934006325388509139884e-01 1.26185667501572066490078682932108e-02 3.02058105671362689750858443460402e-03
 	 6.59140887404908837332584425894311e-01 1.26185667501572066490078682932108e-02 3.28240545844934006325388509139884e-01 3.02058105671362689750858443460402e-03
 	 2.59350932003120149271779837363283e-01 2.10621566756392201991143764416847e-02 7.19586911321240529915144179540221e-01 3.64417557687618217168723511178996e-03
 	 2.59350932003120149271779837363283e-01 7.19586911321240529915144179540221e-01 2.10621566756392201991143764416847e-02 3.64417557687618217168723511178996e-03
 	 2.10621566756392201991143764416847e-02 2.59350932003120149271779837363283e-01 7.19586911321240529915144179540221e-01 3.64417557687618217168723511178996e-03
 	 2.10621566756392201991143764416847e-02 7.19586911321240529915144179540221e-01 2.59350932003120149271779837363283e-01 3.64417557687618217168723511178996e-03
 	 7.19586911321240529915144179540221e-01 2.59350932003120149271779837363283e-01 2.10621566756392201991143764416847e-02 3.64417557687618217168723511178996e-03
 	 7.19586911321240529915144179540221e-01 2.10621566756392201991143764416847e-02 2.59350932003120149271779837363283e-01 3.64417557687618217168723511178996e-03
 	 1.65463998237349529940587444798439e-01 1.17543509254347977588395224302076e-01 7.16992492508302436959866099641658e-01 7.48108969916015664747277469359688e-03
 	 1.65463998237349529940587444798439e-01 7.16992492508302436959866099641658e-01 1.17543509254347977588395224302076e-01 7.48108969916015664747277469359688e-03
 	 1.17543509254347977588395224302076e-01 1.65463998237349529940587444798439e-01 7.16992492508302436959866099641658e-01 7.48108969916015664747277469359688e-03
 	 1.17543509254347977588395224302076e-01 7.16992492508302436959866099641658e-01 1.65463998237349529940587444798439e-01 7.48108969916015664747277469359688e-03
 	 7.16992492508302436959866099641658e-01 1.65463998237349529940587444798439e-01 1.17543509254347977588395224302076e-01 7.48108969916015664747277469359688e-03
 	 7.16992492508302436959866099641658e-01 1.17543509254347977588395224302076e-01 1.65463998237349529940587444798439e-01 7.48108969916015664747277469359688e-03
 	 3.82464907380937246816898777979077e-01 2.92988505404852273006355289908242e-02 5.88236242078577609149192539916839e-01 4.56815413557201503713667278816501e-03
 	 3.82464907380937246816898777979077e-01 5.88236242078577609149192539916839e-01 2.92988505404852273006355289908242e-02 4.56815413557201503713667278816501e-03
 	 2.92988505404852273006355289908242e-02 3.82464907380937246816898777979077e-01 5.88236242078577609149192539916839e-01 4.56815413557201503713667278816501e-03
 	 2.92988505404852273006355289908242e-02 5.88236242078577609149192539916839e-01 3.82464907380937246816898777979077e-01 4.56815413557201503713667278816501e-03
 	 5.88236242078577609149192539916839e-01 3.82464907380937246816898777979077e-01 2.92988505404852273006355289908242e-02 4.56815413557201503713667278816501e-03
 	 5.88236242078577609149192539916839e-01 2.92988505404852273006355289908242e-02 3.82464907380937246816898777979077e-01 4.56815413557201503713667278816501e-03
 	 3.97817072646720837347800170391565e-01 3.44282165227435561077884429437290e-03 5.98740105701004776683760155719938e-01 1.68520364053428807135648348491941e-03
 	 3.97817072646720837347800170391565e-01 5.98740105701004776683760155719938e-01 3.44282165227435561077884429437290e-03 1.68520364053428807135648348491941e-03
 	 3.44282165227435561077884429437290e-03 3.97817072646720837347800170391565e-01 5.98740105701004776683760155719938e-01 1.68520364053428807135648348491941e-03
 	 3.44282165227435561077884429437290e-03 5.98740105701004776683760155719938e-01 3.97817072646720837347800170391565e-01 1.68520364053428807135648348491941e-03
 	 5.98740105701004776683760155719938e-01 3.97817072646720837347800170391565e-01 3.44282165227435561077884429437290e-03 1.68520364053428807135648348491941e-03
 	 5.98740105701004776683760155719938e-01 3.44282165227435561077884429437290e-03 3.97817072646720837347800170391565e-01 1.68520364053428807135648348491941e-03
 	 3.25417469646690105111730417775107e-01 9.03702811448642562286437396323890e-02 5.84212249208445721926352689479245e-01 8.20920664647930772850337177715119e-03
 	 3.25417469646690105111730417775107e-01 5.84212249208445721926352689479245e-01 9.03702811448642562286437396323890e-02 8.20920664647930772850337177715119e-03
 	 9.03702811448642562286437396323890e-02 3.25417469646690105111730417775107e-01 5.84212249208445721926352689479245e-01 8.20920664647930772850337177715119e-03
 	 9.03702811448642562286437396323890e-02 5.84212249208445721926352689479245e-01 3.25417469646690105111730417775107e-01 8.20920664647930772850337177715119e-03
 	 5.84212249208445721926352689479245e-01 3.25417469646690105111730417775107e-01 9.03702811448642562286437396323890e-02 8.20920664647930772850337177715119e-03
 	 5.84212249208445721926352689479245e-01 9.03702811448642562286437396323890e-02 3.25417469646690105111730417775107e-01 8.20920664647930772850337177715119e-03
 	 1.13339191487603074826040483458200e-01 5.06976359267404738662143870442378e-02 8.35963172585656444368851225590333e-01 4.46567684761993346359565393299818e-03
 	 1.13339191487603074826040483458200e-01 8.35963172585656444368851225590333e-01 5.06976359267404738662143870442378e-02 4.46567684761993346359565393299818e-03
 	 5.06976359267404738662143870442378e-02 1.13339191487603074826040483458200e-01 8.35963172585656444368851225590333e-01 4.46567684761993346359565393299818e-03
 	 5.06976359267404738662143870442378e-02 8.35963172585656444368851225590333e-01 1.13339191487603074826040483458200e-01 4.46567684761993346359565393299818e-03
 	 8.35963172585656444368851225590333e-01 1.13339191487603074826040483458200e-01 5.06976359267404738662143870442378e-02 4.46567684761993346359565393299818e-03
 	 8.35963172585656444368851225590333e-01 5.06976359267404738662143870442378e-02 1.13339191487603074826040483458200e-01 4.46567684761993346359565393299818e-03
 	 3.11041632827641745251412430661730e-01 4.79444789155617986931012808327068e-02 6.41013888256796504627743615856161e-01 6.20283472152284316020187660001284e-03
 	 3.11041632827641745251412430661730e-01 6.41013888256796504627743615856161e-01 4.79444789155617986931012808327068e-02 6.20283472152284316020187660001284e-03
 	 4.79444789155617986931012808327068e-02 3.11041632827641745251412430661730e-01 6.41013888256796504627743615856161e-01 6.20283472152284316020187660001284e-03
 	 4.79444789155617986931012808327068e-02 6.41013888256796504627743615856161e-01 3.11041632827641745251412430661730e-01 6.20283472152284316020187660001284e-03
 	 6.41013888256796504627743615856161e-01 3.11041632827641745251412430661730e-01 4.79444789155617986931012808327068e-02 6.20283472152284316020187660001284e-03
 	 6.41013888256796504627743615856161e-01 4.79444789155617986931012808327068e-02 3.11041632827641745251412430661730e-01 6.20283472152284316020187660001284e-03
 	 2.98837135388912988887000210525002e-01 1.27665738027984911225065633999520e-03 6.99886207230807189105803445272613e-01 8.88892543151926931357942329725574e-04
 	 2.98837135388912988887000210525002e-01 6.99886207230807189105803445272613e-01 1.27665738027984911225065633999520e-03 8.88892543151926931357942329725574e-04
 	 1.27665738027984911225065633999520e-03 2.98837135388912988887000210525002e-01 6.99886207230807189105803445272613e-01 8.88892543151926931357942329725574e-04
 	 1.27665738027984911225065633999520e-03 6.99886207230807189105803445272613e-01 2.98837135388912988887000210525002e-01 8.88892543151926931357942329725574e-04
 	 6.99886207230807189105803445272613e-01 2.98837135388912988887000210525002e-01 1.27665738027984911225065633999520e-03 8.88892543151926931357942329725574e-04
 	 6.99886207230807189105803445272613e-01 1.27665738027984911225065633999520e-03 2.98837135388912988887000210525002e-01 8.88892543151926931357942329725574e-04
 	 1.52112280943783789721734933664266e-01 4.26256341511160007085035061891176e-03 8.43625155641104629289372951461701e-01 1.48522932918516764252969686310735e-03
 	 1.52112280943783789721734933664266e-01 8.43625155641104629289372951461701e-01 4.26256341511160007085035061891176e-03 1.48522932918516764252969686310735e-03
 	 4.26256341511160007085035061891176e-03 1.52112280943783789721734933664266e-01 8.43625155641104629289372951461701e-01 1.48522932918516764252969686310735e-03
 	 4.26256341511160007085035061891176e-03 8.43625155641104629289372951461701e-01 1.52112280943783789721734933664266e-01 1.48522932918516764252969686310735e-03
 	 8.43625155641104629289372951461701e-01 1.52112280943783789721734933664266e-01 4.26256341511160007085035061891176e-03 1.48522932918516764252969686310735e-03
 	 8.43625155641104629289372951461701e-01 4.26256341511160007085035061891176e-03 1.52112280943783789721734933664266e-01 1.48522932918516764252969686310735e-03
 	 8.86617050339115198021033847908257e-02 3.85251198871905528239856231209615e-03 9.07485782977369370705389428621856e-01 1.11270634559063660157240960302261e-03
 	 8.86617050339115198021033847908257e-02 9.07485782977369370705389428621856e-01 3.85251198871905528239856231209615e-03 1.11270634559063660157240960302261e-03
 	 3.85251198871905528239856231209615e-03 8.86617050339115198021033847908257e-02 9.07485782977369370705389428621856e-01 1.11270634559063660157240960302261e-03
 	 3.85251198871905528239856231209615e-03 9.07485782977369370705389428621856e-01 8.86617050339115198021033847908257e-02 1.11270634559063660157240960302261e-03
 	 9.07485782977369370705389428621856e-01 8.86617050339115198021033847908257e-02 3.85251198871905528239856231209615e-03 1.11270634559063660157240960302261e-03
 	 9.07485782977369370705389428621856e-01 3.85251198871905528239856231209615e-03 8.86617050339115198021033847908257e-02 1.11270634559063660157240960302261e-03
 	 3.19152580593060508640235184429912e-01 2.01900148632476683641101544708363e-01 4.78947270774462807718663270861725e-01 1.19733591024827768639626768276685e-02
 	 3.19152580593060508640235184429912e-01 4.78947270774462807718663270861725e-01 2.01900148632476683641101544708363e-01 1.19733591024827768639626768276685e-02
 	 2.01900148632476683641101544708363e-01 3.19152580593060508640235184429912e-01 4.78947270774462807718663270861725e-01 1.19733591024827768639626768276685e-02
 	 2.01900148632476683641101544708363e-01 4.78947270774462807718663270861725e-01 3.19152580593060508640235184429912e-01 1.19733591024827768639626768276685e-02
 	 4.78947270774462807718663270861725e-01 3.19152580593060508640235184429912e-01 2.01900148632476683641101544708363e-01 1.19733591024827768639626768276685e-02
 	 4.78947270774462807718663270861725e-01 2.01900148632476683641101544708363e-01 3.19152580593060508640235184429912e-01 1.19733591024827768639626768276685e-02
 	 1.66755693582133324159855192192481e-01 6.77103932212691633774070965046121e-02 7.65533913196597581851676750375191e-01 5.88231606281985723583272118730747e-03
 	 1.66755693582133324159855192192481e-01 7.65533913196597581851676750375191e-01 6.77103932212691633774070965046121e-02 5.88231606281985723583272118730747e-03
 	 6.77103932212691633774070965046121e-02 1.66755693582133324159855192192481e-01 7.65533913196597581851676750375191e-01 5.88231606281985723583272118730747e-03
 	 6.77103932212691633774070965046121e-02 7.65533913196597581851676750375191e-01 1.66755693582133324159855192192481e-01 5.88231606281985723583272118730747e-03
 	 7.65533913196597581851676750375191e-01 1.66755693582133324159855192192481e-01 6.77103932212691633774070965046121e-02 5.88231606281985723583272118730747e-03
 	 7.65533913196597581851676750375191e-01 6.77103932212691633774070965046121e-02 1.66755693582133324159855192192481e-01 5.88231606281985723583272118730747e-03
 	 2.42137924019432793087958089017775e-01 9.55724171106545339338111944016418e-02 6.62289658869912645222655100951670e-01 8.44874347195112562758367857895792e-03
 	 2.42137924019432793087958089017775e-01 6.62289658869912645222655100951670e-01 9.55724171106545339338111944016418e-02 8.44874347195112562758367857895792e-03
 	 9.55724171106545339338111944016418e-02 2.42137924019432793087958089017775e-01 6.62289658869912645222655100951670e-01 8.44874347195112562758367857895792e-03
 	 9.55724171106545339338111944016418e-02 6.62289658869912645222655100951670e-01 2.42137924019432793087958089017775e-01 8.44874347195112562758367857895792e-03
 	 6.62289658869912645222655100951670e-01 2.42137924019432793087958089017775e-01 9.55724171106545339338111944016418e-02 8.44874347195112562758367857895792e-03
 	 6.62289658869912645222655100951670e-01 9.55724171106545339338111944016418e-02 2.42137924019432793087958089017775e-01 8.44874347195112562758367857895792e-03
 	 2.79861747997829701795069468062138e-01 1.50370864573458273838468812755309e-01 5.69767387428712024366461719182553e-01 1.02114559163660814644636332104710e-02
 	 2.79861747997829701795069468062138e-01 5.69767387428712024366461719182553e-01 1.50370864573458273838468812755309e-01 1.02114559163660814644636332104710e-02
 	 1.50370864573458273838468812755309e-01 2.79861747997829701795069468062138e-01 5.69767387428712024366461719182553e-01 1.02114559163660814644636332104710e-02
 	 1.50370864573458273838468812755309e-01 5.69767387428712024366461719182553e-01 2.79861747997829701795069468062138e-01 1.02114559163660814644636332104710e-02
 	 5.69767387428712024366461719182553e-01 2.79861747997829701795069468062138e-01 1.50370864573458273838468812755309e-01 1.02114559163660814644636332104710e-02
 	 5.69767387428712024366461719182553e-01 1.50370864573458273838468812755309e-01 2.79861747997829701795069468062138e-01 1.02114559163660814644636332104710e-02
 	 6.73984002072566534824460404706770e-02 2.43498506845871223736033073237195e-02 9.08251749108156203327268940483918e-01 2.48995915321652662791085397486768e-03
 	 6.73984002072566534824460404706770e-02 9.08251749108156203327268940483918e-01 2.43498506845871223736033073237195e-02 2.48995915321652662791085397486768e-03
 	 2.43498506845871223736033073237195e-02 6.73984002072566534824460404706770e-02 9.08251749108156203327268940483918e-01 2.48995915321652662791085397486768e-03
 	 2.43498506845871223736033073237195e-02 9.08251749108156203327268940483918e-01 6.73984002072566534824460404706770e-02 2.48995915321652662791085397486768e-03
 	 9.08251749108156203327268940483918e-01 6.73984002072566534824460404706770e-02 2.43498506845871223736033073237195e-02 2.48995915321652662791085397486768e-03
 	 9.08251749108156203327268940483918e-01 2.43498506845871223736033073237195e-02 6.73984002072566534824460404706770e-02 2.48995915321652662791085397486768e-03
 	 3.71687966693420357433552680959110e-01 1.29387867366923425826996663090540e-01 4.98924165939656272250601887208177e-01 9.88850565502228349978874888392966e-03
 	 3.71687966693420357433552680959110e-01 4.98924165939656272250601887208177e-01 1.29387867366923425826996663090540e-01 9.88850565502228349978874888392966e-03
 	 1.29387867366923425826996663090540e-01 3.71687966693420357433552680959110e-01 4.98924165939656272250601887208177e-01 9.88850565502228349978874888392966e-03
 	 1.29387867366923425826996663090540e-01 4.98924165939656272250601887208177e-01 3.71687966693420357433552680959110e-01 9.88850565502228349978874888392966e-03
 	 4.98924165939656272250601887208177e-01 3.71687966693420357433552680959110e-01 1.29387867366923425826996663090540e-01 9.88850565502228349978874888392966e-03
 	 4.98924165939656272250601887208177e-01 1.29387867366923425826996663090540e-01 3.71687966693420357433552680959110e-01 9.88850565502228349978874888392966e-03
 	 4.05628149065882848134378946269862e-01 6.32274204565012321044292775695794e-02 5.31144430477615947516767391789472e-01 7.40911314293649439499667153086193e-03
 	 4.05628149065882848134378946269862e-01 5.31144430477615947516767391789472e-01 6.32274204565012321044292775695794e-02 7.40911314293649439499667153086193e-03
 	 6.32274204565012321044292775695794e-02 4.05628149065882848134378946269862e-01 5.31144430477615947516767391789472e-01 7.40911314293649439499667153086193e-03
 	 6.32274204565012321044292775695794e-02 5.31144430477615947516767391789472e-01 4.05628149065882848134378946269862e-01 7.40911314293649439499667153086193e-03
 	 5.31144430477615947516767391789472e-01 4.05628149065882848134378946269862e-01 6.32274204565012321044292775695794e-02 7.40911314293649439499667153086193e-03
 	 5.31144430477615947516767391789472e-01 6.32274204565012321044292775695794e-02 4.05628149065882848134378946269862e-01 7.40911314293649439499667153086193e-03
 	 2.21980165737481027754540718888165e-01 5.26663302076577251320532724321311e-03 7.72753201241753173711401814216515e-01 1.94559324098306728710594537545830e-03
 	 2.21980165737481027754540718888165e-01 7.72753201241753173711401814216515e-01 5.26663302076577251320532724321311e-03 1.94559324098306728710594537545830e-03
 	 5.26663302076577251320532724321311e-03 2.21980165737481027754540718888165e-01 7.72753201241753173711401814216515e-01 1.94559324098306728710594537545830e-03
 	 5.26663302076577251320532724321311e-03 7.72753201241753173711401814216515e-01 2.21980165737481027754540718888165e-01 1.94559324098306728710594537545830e-03
 	 7.72753201241753173711401814216515e-01 2.21980165737481027754540718888165e-01 5.26663302076577251320532724321311e-03 1.94559324098306728710594537545830e-03
 	 7.72753201241753173711401814216515e-01 5.26663302076577251320532724321311e-03 2.21980165737481027754540718888165e-01 1.94559324098306728710594537545830e-03
 	 1.78325682037862948137174612384115e-01 2.61588819796510496651364974241005e-02 7.95515435982486085464415737078525e-01 4.26083659650016485093138030038062e-03
 	 1.78325682037862948137174612384115e-01 7.95515435982486085464415737078525e-01 2.61588819796510496651364974241005e-02 4.26083659650016485093138030038062e-03
 	 2.61588819796510496651364974241005e-02 1.78325682037862948137174612384115e-01 7.95515435982486085464415737078525e-01 4.26083659650016485093138030038062e-03
 	 2.61588819796510496651364974241005e-02 7.95515435982486085464415737078525e-01 1.78325682037862948137174612384115e-01 4.26083659650016485093138030038062e-03
 	 7.95515435982486085464415737078525e-01 1.78325682037862948137174612384115e-01 2.61588819796510496651364974241005e-02 4.26083659650016485093138030038062e-03
 	 7.95515435982486085464415737078525e-01 2.61588819796510496651364974241005e-02 1.78325682037862948137174612384115e-01 4.26083659650016485093138030038062e-03
 	 4.26221905914095089418225370536675e-02 5.55476787043224142642605656305932e-03 9.51823041538158332031116515281610e-01 1.05537436961761709429408195859423e-03
 	 4.26221905914095089418225370536675e-02 9.51823041538158332031116515281610e-01 5.55476787043224142642605656305932e-03 1.05537436961761709429408195859423e-03
 	 5.55476787043224142642605656305932e-03 4.26221905914095089418225370536675e-02 9.51823041538158332031116515281610e-01 1.05537436961761709429408195859423e-03
 	 5.55476787043224142642605656305932e-03 9.51823041538158332031116515281610e-01 4.26221905914095089418225370536675e-02 1.05537436961761709429408195859423e-03
 	 9.51823041538158332031116515281610e-01 4.26221905914095089418225370536675e-02 5.55476787043224142642605656305932e-03 1.05537436961761709429408195859423e-03
 	 9.51823041538158332031116515281610e-01 5.55476787043224142642605656305932e-03 4.26221905914095089418225370536675e-02 1.05537436961761709429408195859423e-03
 	 1.43443003792803787377341251385587e-02 6.23098020345069585589070637610121e-04 9.85032601600374535522064434189815e-01 1.70088247742487943875086542355746e-04
 	 1.43443003792803787377341251385587e-02 9.85032601600374535522064434189815e-01 6.23098020345069585589070637610121e-04 1.70088247742487943875086542355746e-04
 	 6.23098020345069585589070637610121e-04 1.43443003792803787377341251385587e-02 9.85032601600374535522064434189815e-01 1.70088247742487943875086542355746e-04
 	 6.23098020345069585589070637610121e-04 9.85032601600374535522064434189815e-01 1.43443003792803787377341251385587e-02 1.70088247742487943875086542355746e-04
 	 9.85032601600374535522064434189815e-01 1.43443003792803787377341251385587e-02 6.23098020345069585589070637610121e-04 1.70088247742487943875086542355746e-04
 	 9.85032601600374535522064434189815e-01 6.23098020345069585589070637610121e-04 1.43443003792803787377341251385587e-02 1.70088247742487943875086542355746e-04
 	 ];
 
 	 case  33 

 	 % ALG. DEG.:   33
 	 % PTS CARD.:  204
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw_bar=[
 	 8.66842399345696401624650206940714e-02 8.66842399345696401624650206940714e-02 8.26631520130860719675069958611857e-01 3.20236401241420732752263056397624e-03
 	 8.66842399345696401624650206940714e-02 8.26631520130860719675069958611857e-01 8.66842399345696401624650206940714e-02 3.20236401241420732752263056397624e-03
 	 8.26631520130860719675069958611857e-01 8.66842399345696401624650206940714e-02 8.66842399345696401624650206940714e-02 3.20236401241420732752263056397624e-03
 	 4.09427960802643320370464152802015e-01 4.09427960802643320370464152802015e-01 1.81144078394713359259071694395971e-01 6.83467993446809033569744329383866e-03
 	 4.09427960802643320370464152802015e-01 1.81144078394713359259071694395971e-01 4.09427960802643320370464152802015e-01 6.83467993446809033569744329383866e-03
 	 1.81144078394713359259071694395971e-01 4.09427960802643320370464152802015e-01 4.09427960802643320370464152802015e-01 6.83467993446809033569744329383866e-03
 	 3.78333538296242721798989805392921e-01 3.78333538296242721798989805392921e-01 2.43332923407514556402020389214158e-01 8.93416180813674624949793923178731e-03
 	 3.78333538296242721798989805392921e-01 2.43332923407514556402020389214158e-01 3.78333538296242721798989805392921e-01 8.93416180813674624949793923178731e-03
 	 2.43332923407514556402020389214158e-01 3.78333538296242721798989805392921e-01 3.78333538296242721798989805392921e-01 8.93416180813674624949793923178731e-03
 	 4.98979717860051186217873464556760e-01 4.98979717860051186217873464556760e-01 2.04056427989762756425307088647969e-03 1.04109123728642147949097207515479e-03
 	 4.98979717860051186217873464556760e-01 2.04056427989762756425307088647969e-03 4.98979717860051186217873464556760e-01 1.04109123728642147949097207515479e-03
 	 2.04056427989762756425307088647969e-03 4.98979717860051186217873464556760e-01 4.98979717860051186217873464556760e-01 1.04109123728642147949097207515479e-03
 	 2.59660668008721118305004438298056e-01 2.59660668008721118305004438298056e-01 4.80678663982557763389991123403888e-01 9.73885723668537449382309745260500e-03
 	 2.59660668008721118305004438298056e-01 4.80678663982557763389991123403888e-01 2.59660668008721118305004438298056e-01 9.73885723668537449382309745260500e-03
 	 4.80678663982557763389991123403888e-01 2.59660668008721118305004438298056e-01 2.59660668008721118305004438298056e-01 9.73885723668537449382309745260500e-03
 	 4.78511973256382172614564751711441e-01 4.78511973256382172614564751711441e-01 4.29760534872356547708704965771176e-02 5.46432568404603847406209027326440e-03
 	 4.78511973256382172614564751711441e-01 4.29760534872356547708704965771176e-02 4.78511973256382172614564751711441e-01 5.46432568404603847406209027326440e-03
 	 4.29760534872356547708704965771176e-02 4.78511973256382172614564751711441e-01 4.78511973256382172614564751711441e-01 5.46432568404603847406209027326440e-03
 	 2.35174430579130483431882225886511e-02 2.35174430579130483431882225886511e-02 9.52965113884173931069199170451611e-01 1.38136906302790485670528575212757e-03
 	 2.35174430579130483431882225886511e-02 9.52965113884173931069199170451611e-01 2.35174430579130483431882225886511e-02 1.38136906302790485670528575212757e-03
 	 9.52965113884173931069199170451611e-01 2.35174430579130483431882225886511e-02 2.35174430579130483431882225886511e-02 1.38136906302790485670528575212757e-03
 	 3.06023861760360560424487630371004e-01 3.06023861760360560424487630371004e-01 3.87952276479278879151024739257991e-01 1.20887399809165678454814241149506e-02
 	 3.06023861760360560424487630371004e-01 3.87952276479278879151024739257991e-01 3.06023861760360560424487630371004e-01 1.20887399809165678454814241149506e-02
 	 3.87952276479278879151024739257991e-01 3.06023861760360560424487630371004e-01 3.06023861760360560424487630371004e-01 1.20887399809165678454814241149506e-02
 	 1.46489050716642699168090757666505e-01 1.46489050716642699168090757666505e-01 7.07021898566714601663818484666990e-01 7.37744649673419388563599952135519e-03
 	 1.46489050716642699168090757666505e-01 7.07021898566714601663818484666990e-01 1.46489050716642699168090757666505e-01 7.37744649673419388563599952135519e-03
 	 7.07021898566714601663818484666990e-01 1.46489050716642699168090757666505e-01 1.46489050716642699168090757666505e-01 7.37744649673419388563599952135519e-03
 	 5.43792032794962812425332288057689e-02 5.43792032794962812425332288057689e-02 8.91241593441007395881570118945092e-01 3.20935044394162144812399084514709e-03
 	 5.43792032794962812425332288057689e-02 8.91241593441007395881570118945092e-01 5.43792032794962812425332288057689e-02 3.20935044394162144812399084514709e-03
 	 8.91241593441007395881570118945092e-01 5.43792032794962812425332288057689e-02 5.43792032794962812425332288057689e-02 3.20935044394162144812399084514709e-03
 	 2.18192015863253874208282923063962e-01 2.18192015863253874208282923063962e-01 5.63615968273492251583434153872076e-01 9.92637617954420653498814886006585e-03
 	 2.18192015863253874208282923063962e-01 5.63615968273492251583434153872076e-01 2.18192015863253874208282923063962e-01 9.92637617954420653498814886006585e-03
 	 5.63615968273492251583434153872076e-01 2.18192015863253874208282923063962e-01 2.18192015863253874208282923063962e-01 9.92637617954420653498814886006585e-03
 	 4.91991344456553236774709603196243e-01 4.91991344456553236774709603196243e-01 1.60173110868935264505807936075144e-02 3.86236202996604292836391181253930e-03
 	 4.91991344456553236774709603196243e-01 1.60173110868935264505807936075144e-02 4.91991344456553236774709603196243e-01 3.86236202996604292836391181253930e-03
 	 1.60173110868935264505807936075144e-02 4.91991344456553236774709603196243e-01 4.91991344456553236774709603196243e-01 3.86236202996604292836391181253930e-03
 	 4.53399961617805269398218115384225e-01 4.53399961617805269398218115384225e-01 9.32000767643894612035637692315504e-02 9.33379776964658215698822374406518e-03
 	 4.53399961617805269398218115384225e-01 9.32000767643894612035637692315504e-02 4.53399961617805269398218115384225e-01 9.33379776964658215698822374406518e-03
 	 9.32000767643894612035637692315504e-02 4.53399961617805269398218115384225e-01 4.53399961617805269398218115384225e-01 9.33379776964658215698822374406518e-03
 	 4.72666051056800425728132708513840e-03 4.72666051056800425728132708513840e-03 9.90546678978863948117350446409546e-01 2.93482733578017578653790442544391e-04
 	 4.72666051056800425728132708513840e-03 9.90546678978863948117350446409546e-01 4.72666051056800425728132708513840e-03 2.93482733578017578653790442544391e-04
 	 9.90546678978863948117350446409546e-01 4.72666051056800425728132708513840e-03 4.72666051056800425728132708513840e-03 2.93482733578017578653790442544391e-04
 	 2.58152928789506741491521779607865e-01 8.69286359632870375691027220454998e-02 6.54918435247206165428224267088808e-01 5.01082345657489873491652332404556e-03
 	 2.58152928789506741491521779607865e-01 6.54918435247206165428224267088808e-01 8.69286359632870375691027220454998e-02 5.01082345657489873491652332404556e-03
 	 8.69286359632870375691027220454998e-02 2.58152928789506741491521779607865e-01 6.54918435247206165428224267088808e-01 5.01082345657489873491652332404556e-03
 	 8.69286359632870375691027220454998e-02 6.54918435247206165428224267088808e-01 2.58152928789506741491521779607865e-01 5.01082345657489873491652332404556e-03
 	 6.54918435247206165428224267088808e-01 2.58152928789506741491521779607865e-01 8.69286359632870375691027220454998e-02 5.01082345657489873491652332404556e-03
 	 6.54918435247206165428224267088808e-01 8.69286359632870375691027220454998e-02 2.58152928789506741491521779607865e-01 5.01082345657489873491652332404556e-03
 	 2.84962401972082890466708704479970e-01 1.14092035322831353294503742290544e-01 6.00945562705085700727636321971659e-01 6.26667151459795856299761496188694e-03
 	 2.84962401972082890466708704479970e-01 6.00945562705085700727636321971659e-01 1.14092035322831353294503742290544e-01 6.26667151459795856299761496188694e-03
 	 1.14092035322831353294503742290544e-01 2.84962401972082890466708704479970e-01 6.00945562705085700727636321971659e-01 6.26667151459795856299761496188694e-03
 	 1.14092035322831353294503742290544e-01 6.00945562705085700727636321971659e-01 2.84962401972082890466708704479970e-01 6.26667151459795856299761496188694e-03
 	 6.00945562705085700727636321971659e-01 2.84962401972082890466708704479970e-01 1.14092035322831353294503742290544e-01 6.26667151459795856299761496188694e-03
 	 6.00945562705085700727636321971659e-01 1.14092035322831353294503742290544e-01 2.84962401972082890466708704479970e-01 6.26667151459795856299761496188694e-03
 	 1.34067633841934125138450895065034e-01 9.16653314400512203574677982942376e-02 7.74267034718014723893020345713012e-01 5.10609230186331430195734171206823e-03
 	 1.34067633841934125138450895065034e-01 7.74267034718014723893020345713012e-01 9.16653314400512203574677982942376e-02 5.10609230186331430195734171206823e-03
 	 9.16653314400512203574677982942376e-02 1.34067633841934125138450895065034e-01 7.74267034718014723893020345713012e-01 5.10609230186331430195734171206823e-03
 	 9.16653314400512203574677982942376e-02 7.74267034718014723893020345713012e-01 1.34067633841934125138450895065034e-01 5.10609230186331430195734171206823e-03
 	 7.74267034718014723893020345713012e-01 1.34067633841934125138450895065034e-01 9.16653314400512203574677982942376e-02 5.10609230186331430195734171206823e-03
 	 7.74267034718014723893020345713012e-01 9.16653314400512203574677982942376e-02 1.34067633841934125138450895065034e-01 5.10609230186331430195734171206823e-03
 	 3.26913750209671560842394910650910e-01 2.15939391243415657051230027718702e-01 4.57146858546912837617526292888215e-01 9.63924685884078556730170106447986e-03
 	 3.26913750209671560842394910650910e-01 4.57146858546912837617526292888215e-01 2.15939391243415657051230027718702e-01 9.63924685884078556730170106447986e-03
 	 2.15939391243415657051230027718702e-01 3.26913750209671560842394910650910e-01 4.57146858546912837617526292888215e-01 9.63924685884078556730170106447986e-03
 	 2.15939391243415657051230027718702e-01 4.57146858546912837617526292888215e-01 3.26913750209671560842394910650910e-01 9.63924685884078556730170106447986e-03
 	 4.57146858546912837617526292888215e-01 3.26913750209671560842394910650910e-01 2.15939391243415657051230027718702e-01 9.63924685884078556730170106447986e-03
 	 4.57146858546912837617526292888215e-01 2.15939391243415657051230027718702e-01 3.26913750209671560842394910650910e-01 9.63924685884078556730170106447986e-03
 	 1.00845715982775571695206906497333e-01 2.23903162865835385353374675787563e-02 8.76763967730640914055584289599210e-01 2.42123803886849569763639600239458e-03
 	 1.00845715982775571695206906497333e-01 8.76763967730640914055584289599210e-01 2.23903162865835385353374675787563e-02 2.42123803886849569763639600239458e-03
 	 2.23903162865835385353374675787563e-02 1.00845715982775571695206906497333e-01 8.76763967730640914055584289599210e-01 2.42123803886849569763639600239458e-03
 	 2.23903162865835385353374675787563e-02 8.76763967730640914055584289599210e-01 1.00845715982775571695206906497333e-01 2.42123803886849569763639600239458e-03
 	 8.76763967730640914055584289599210e-01 1.00845715982775571695206906497333e-01 2.23903162865835385353374675787563e-02 2.42123803886849569763639600239458e-03
 	 8.76763967730640914055584289599210e-01 2.23903162865835385353374675787563e-02 1.00845715982775571695206906497333e-01 2.42123803886849569763639600239458e-03
 	 3.55232825404763974397326364851324e-01 9.92419378880282920807331947798957e-02 5.45525236707207761277516055997694e-01 7.69734672705493869898640824089853e-03
 	 3.55232825404763974397326364851324e-01 5.45525236707207761277516055997694e-01 9.92419378880282920807331947798957e-02 7.69734672705493869898640824089853e-03
 	 9.92419378880282920807331947798957e-02 3.55232825404763974397326364851324e-01 5.45525236707207761277516055997694e-01 7.69734672705493869898640824089853e-03
 	 9.92419378880282920807331947798957e-02 5.45525236707207761277516055997694e-01 3.55232825404763974397326364851324e-01 7.69734672705493869898640824089853e-03
 	 5.45525236707207761277516055997694e-01 3.55232825404763974397326364851324e-01 9.92419378880282920807331947798957e-02 7.69734672705493869898640824089853e-03
 	 5.45525236707207761277516055997694e-01 9.92419378880282920807331947798957e-02 3.55232825404763974397326364851324e-01 7.69734672705493869898640824089853e-03
 	 1.58402734195724786969705633055128e-01 2.04436751441748401636466780928458e-02 8.21153590660100296538814745872514e-01 2.98824469194903337074253890648379e-03
 	 1.58402734195724786969705633055128e-01 8.21153590660100296538814745872514e-01 2.04436751441748401636466780928458e-02 2.98824469194903337074253890648379e-03
 	 2.04436751441748401636466780928458e-02 1.58402734195724786969705633055128e-01 8.21153590660100296538814745872514e-01 2.98824469194903337074253890648379e-03
 	 2.04436751441748401636466780928458e-02 8.21153590660100296538814745872514e-01 1.58402734195724786969705633055128e-01 2.98824469194903337074253890648379e-03
 	 8.21153590660100296538814745872514e-01 1.58402734195724786969705633055128e-01 2.04436751441748401636466780928458e-02 2.98824469194903337074253890648379e-03
 	 8.21153590660100296538814745872514e-01 2.04436751441748401636466780928458e-02 1.58402734195724786969705633055128e-01 2.98824469194903337074253890648379e-03
 	 4.01239748458054656943261306878412e-01 5.86121184566509023650127119253739e-02 5.40148133085294412936150365567300e-01 6.19885402594336481357784052192983e-03
 	 4.01239748458054656943261306878412e-01 5.40148133085294412936150365567300e-01 5.86121184566509023650127119253739e-02 6.19885402594336481357784052192983e-03
 	 5.86121184566509023650127119253739e-02 4.01239748458054656943261306878412e-01 5.40148133085294412936150365567300e-01 6.19885402594336481357784052192983e-03
 	 5.86121184566509023650127119253739e-02 5.40148133085294412936150365567300e-01 4.01239748458054656943261306878412e-01 6.19885402594336481357784052192983e-03
 	 5.40148133085294412936150365567300e-01 4.01239748458054656943261306878412e-01 5.86121184566509023650127119253739e-02 6.19885402594336481357784052192983e-03
 	 5.40148133085294412936150365567300e-01 5.86121184566509023650127119253739e-02 4.01239748458054656943261306878412e-01 6.19885402594336481357784052192983e-03
 	 2.27322013164966585385684538778150e-01 1.94249101655772464514182473749315e-02 7.53253076669456178571238069707761e-01 3.31699729391307478187922441748015e-03
 	 2.27322013164966585385684538778150e-01 7.53253076669456178571238069707761e-01 1.94249101655772464514182473749315e-02 3.31699729391307478187922441748015e-03
 	 1.94249101655772464514182473749315e-02 2.27322013164966585385684538778150e-01 7.53253076669456178571238069707761e-01 3.31699729391307478187922441748015e-03
 	 1.94249101655772464514182473749315e-02 7.53253076669456178571238069707761e-01 2.27322013164966585385684538778150e-01 3.31699729391307478187922441748015e-03
 	 7.53253076669456178571238069707761e-01 2.27322013164966585385684538778150e-01 1.94249101655772464514182473749315e-02 3.31699729391307478187922441748015e-03
 	 7.53253076669456178571238069707761e-01 1.94249101655772464514182473749315e-02 2.27322013164966585385684538778150e-01 3.31699729391307478187922441748015e-03
 	 1.04004000131427021269558963467716e-01 5.08701921937649848004525665601250e-02 8.45125807674807938418837238714332e-01 3.70892961258926633777432968486210e-03
 	 1.04004000131427021269558963467716e-01 8.45125807674807938418837238714332e-01 5.08701921937649848004525665601250e-02 3.70892961258926633777432968486210e-03
 	 5.08701921937649848004525665601250e-02 1.04004000131427021269558963467716e-01 8.45125807674807938418837238714332e-01 3.70892961258926633777432968486210e-03
 	 5.08701921937649848004525665601250e-02 8.45125807674807938418837238714332e-01 1.04004000131427021269558963467716e-01 3.70892961258926633777432968486210e-03
 	 8.45125807674807938418837238714332e-01 1.04004000131427021269558963467716e-01 5.08701921937649848004525665601250e-02 3.70892961258926633777432968486210e-03
 	 8.45125807674807938418837238714332e-01 5.08701921937649848004525665601250e-02 1.04004000131427021269558963467716e-01 3.70892961258926633777432968486210e-03
 	 2.51619019363036655612120284786215e-01 3.80625212881914110410463969458306e-03 7.44574728508144212391073324397439e-01 1.54264651847056373859534694759077e-03
 	 2.51619019363036655612120284786215e-01 7.44574728508144212391073324397439e-01 3.80625212881914110410463969458306e-03 1.54264651847056373859534694759077e-03
 	 3.80625212881914110410463969458306e-03 2.51619019363036655612120284786215e-01 7.44574728508144212391073324397439e-01 1.54264651847056373859534694759077e-03
 	 3.80625212881914110410463969458306e-03 7.44574728508144212391073324397439e-01 2.51619019363036655612120284786215e-01 1.54264651847056373859534694759077e-03
 	 7.44574728508144212391073324397439e-01 2.51619019363036655612120284786215e-01 3.80625212881914110410463969458306e-03 1.54264651847056373859534694759077e-03
 	 7.44574728508144212391073324397439e-01 3.80625212881914110410463969458306e-03 2.51619019363036655612120284786215e-01 1.54264651847056373859534694759077e-03
 	 1.94671527372046238024694275736692e-01 9.39537103695899794564283524778148e-02 7.11374762258363713129938332713209e-01 6.61217241106842445325098012176568e-03
 	 1.94671527372046238024694275736692e-01 7.11374762258363713129938332713209e-01 9.39537103695899794564283524778148e-02 6.61217241106842445325098012176568e-03
 	 9.39537103695899794564283524778148e-02 1.94671527372046238024694275736692e-01 7.11374762258363713129938332713209e-01 6.61217241106842445325098012176568e-03
 	 9.39537103695899794564283524778148e-02 7.11374762258363713129938332713209e-01 1.94671527372046238024694275736692e-01 6.61217241106842445325098012176568e-03
 	 7.11374762258363713129938332713209e-01 1.94671527372046238024694275736692e-01 9.39537103695899794564283524778148e-02 6.61217241106842445325098012176568e-03
 	 7.11374762258363713129938332713209e-01 9.39537103695899794564283524778148e-02 1.94671527372046238024694275736692e-01 6.61217241106842445325098012176568e-03
 	 1.75639631458033129707274611064349e-01 3.66697762401211810323609086026408e-03 8.20693390917954790353405769565143e-01 1.35517819575065034953809117723722e-03
 	 1.75639631458033129707274611064349e-01 8.20693390917954790353405769565143e-01 3.66697762401211810323609086026408e-03 1.35517819575065034953809117723722e-03
 	 3.66697762401211810323609086026408e-03 1.75639631458033129707274611064349e-01 8.20693390917954790353405769565143e-01 1.35517819575065034953809117723722e-03
 	 3.66697762401211810323609086026408e-03 8.20693390917954790353405769565143e-01 1.75639631458033129707274611064349e-01 1.35517819575065034953809117723722e-03
 	 8.20693390917954790353405769565143e-01 1.75639631458033129707274611064349e-01 3.66697762401211810323609086026408e-03 1.35517819575065034953809117723722e-03
 	 8.20693390917954790353405769565143e-01 3.66697762401211810323609086026408e-03 1.75639631458033129707274611064349e-01 1.35517819575065034953809117723722e-03
 	 1.65422503950626270663448735831480e-01 5.04257035060658373448738700517424e-02 7.84151792543307912808359105838463e-01 4.90362834355291717092217851359237e-03
 	 1.65422503950626270663448735831480e-01 7.84151792543307912808359105838463e-01 5.04257035060658373448738700517424e-02 4.90362834355291717092217851359237e-03
 	 5.04257035060658373448738700517424e-02 1.65422503950626270663448735831480e-01 7.84151792543307912808359105838463e-01 4.90362834355291717092217851359237e-03
 	 5.04257035060658373448738700517424e-02 7.84151792543307912808359105838463e-01 1.65422503950626270663448735831480e-01 4.90362834355291717092217851359237e-03
 	 7.84151792543307912808359105838463e-01 1.65422503950626270663448735831480e-01 5.04257035060658373448738700517424e-02 4.90362834355291717092217851359237e-03
 	 7.84151792543307912808359105838463e-01 5.04257035060658373448738700517424e-02 1.65422503950626270663448735831480e-01 4.90362834355291717092217851359237e-03
 	 6.04829240909602813824896827554767e-02 4.11214828094120989770976493105081e-03 9.35404927628098570302483949490124e-01 9.15766157181008050476578308263242e-04
 	 6.04829240909602813824896827554767e-02 9.35404927628098570302483949490124e-01 4.11214828094120989770976493105081e-03 9.15766157181008050476578308263242e-04
 	 4.11214828094120989770976493105081e-03 6.04829240909602813824896827554767e-02 9.35404927628098570302483949490124e-01 9.15766157181008050476578308263242e-04
 	 4.11214828094120989770976493105081e-03 9.35404927628098570302483949490124e-01 6.04829240909602813824896827554767e-02 9.15766157181008050476578308263242e-04
 	 9.35404927628098570302483949490124e-01 6.04829240909602813824896827554767e-02 4.11214828094120989770976493105081e-03 9.15766157181008050476578308263242e-04
 	 9.35404927628098570302483949490124e-01 4.11214828094120989770976493105081e-03 6.04829240909602813824896827554767e-02 9.15766157181008050476578308263242e-04
 	 3.32103565357523278223084162164014e-01 4.33667086499291924012178256475636e-03 6.63559763777483824220837504981318e-01 1.82181626442652361969054553014757e-03
 	 3.32103565357523278223084162164014e-01 6.63559763777483824220837504981318e-01 4.33667086499291924012178256475636e-03 1.82181626442652361969054553014757e-03
 	 4.33667086499291924012178256475636e-03 3.32103565357523278223084162164014e-01 6.63559763777483824220837504981318e-01 1.82181626442652361969054553014757e-03
 	 4.33667086499291924012178256475636e-03 6.63559763777483824220837504981318e-01 3.32103565357523278223084162164014e-01 1.82181626442652361969054553014757e-03
 	 6.63559763777483824220837504981318e-01 3.32103565357523278223084162164014e-01 4.33667086499291924012178256475636e-03 1.82181626442652361969054553014757e-03
 	 6.63559763777483824220837504981318e-01 4.33667086499291924012178256475636e-03 3.32103565357523278223084162164014e-01 1.82181626442652361969054553014757e-03
 	 3.79413216845638723295763838905259e-01 1.43764176240543023466145200472965e-01 4.76822606913818169971364113735035e-01 9.24237990170961344615907506749863e-03
 	 3.79413216845638723295763838905259e-01 4.76822606913818169971364113735035e-01 1.43764176240543023466145200472965e-01 9.24237990170961344615907506749863e-03
 	 1.43764176240543023466145200472965e-01 3.79413216845638723295763838905259e-01 4.76822606913818169971364113735035e-01 9.24237990170961344615907506749863e-03
 	 1.43764176240543023466145200472965e-01 4.76822606913818169971364113735035e-01 3.79413216845638723295763838905259e-01 9.24237990170961344615907506749863e-03
 	 4.76822606913818169971364113735035e-01 3.79413216845638723295763838905259e-01 1.43764176240543023466145200472965e-01 9.24237990170961344615907506749863e-03
 	 4.76822606913818169971364113735035e-01 1.43764176240543023466145200472965e-01 3.79413216845638723295763838905259e-01 9.24237990170961344615907506749863e-03
 	 5.65688972489456487480197210970800e-02 2.18658180283708390712060776195358e-02 9.21565284722683508711327249329770e-01 1.96063123369321495870210014800250e-03
 	 5.65688972489456487480197210970800e-02 9.21565284722683508711327249329770e-01 2.18658180283708390712060776195358e-02 1.96063123369321495870210014800250e-03
 	 2.18658180283708390712060776195358e-02 5.65688972489456487480197210970800e-02 9.21565284722683508711327249329770e-01 1.96063123369321495870210014800250e-03
 	 2.18658180283708390712060776195358e-02 9.21565284722683508711327249329770e-01 5.65688972489456487480197210970800e-02 1.96063123369321495870210014800250e-03
 	 9.21565284722683508711327249329770e-01 5.65688972489456487480197210970800e-02 2.18658180283708390712060776195358e-02 1.96063123369321495870210014800250e-03
 	 9.21565284722683508711327249329770e-01 2.18658180283708390712060776195358e-02 5.65688972489456487480197210970800e-02 1.96063123369321495870210014800250e-03
 	 2.90984916269330096127987417276017e-01 1.68307331342502364268653991530300e-01 5.40707752388167595114509822451510e-01 1.02099177863965006468616181223297e-02
 	 2.90984916269330096127987417276017e-01 5.40707752388167595114509822451510e-01 1.68307331342502364268653991530300e-01 1.02099177863965006468616181223297e-02
 	 1.68307331342502364268653991530300e-01 2.90984916269330096127987417276017e-01 5.40707752388167595114509822451510e-01 1.02099177863965006468616181223297e-02
 	 1.68307331342502364268653991530300e-01 5.40707752388167595114509822451510e-01 2.90984916269330096127987417276017e-01 1.02099177863965006468616181223297e-02
 	 5.40707752388167595114509822451510e-01 2.90984916269330096127987417276017e-01 1.68307331342502364268653991530300e-01 1.02099177863965006468616181223297e-02
 	 5.40707752388167595114509822451510e-01 1.68307331342502364268653991530300e-01 2.90984916269330096127987417276017e-01 1.02099177863965006468616181223297e-02
 	 2.36845394483151533426834589590726e-01 4.85139799052083930952505852474133e-02 7.14640625611639990211187978275120e-01 5.46377043737215819380059755872026e-03
 	 2.36845394483151533426834589590726e-01 7.14640625611639990211187978275120e-01 4.85139799052083930952505852474133e-02 5.46377043737215819380059755872026e-03
 	 4.85139799052083930952505852474133e-02 2.36845394483151533426834589590726e-01 7.14640625611639990211187978275120e-01 5.46377043737215819380059755872026e-03
 	 4.85139799052083930952505852474133e-02 7.14640625611639990211187978275120e-01 2.36845394483151533426834589590726e-01 5.46377043737215819380059755872026e-03
 	 7.14640625611639990211187978275120e-01 2.36845394483151533426834589590726e-01 4.85139799052083930952505852474133e-02 5.46377043737215819380059755872026e-03
 	 7.14640625611639990211187978275120e-01 4.85139799052083930952505852474133e-02 2.36845394483151533426834589590726e-01 5.46377043737215819380059755872026e-03
 	 4.14549152976443013862706266081659e-01 4.73723988093216474837277019105386e-03 5.80713607142624876900072194985114e-01 2.01110200978472670324537219244121e-03
 	 4.14549152976443013862706266081659e-01 5.80713607142624876900072194985114e-01 4.73723988093216474837277019105386e-03 2.01110200978472670324537219244121e-03
 	 4.73723988093216474837277019105386e-03 4.14549152976443013862706266081659e-01 5.80713607142624876900072194985114e-01 2.01110200978472670324537219244121e-03
 	 4.73723988093216474837277019105386e-03 5.80713607142624876900072194985114e-01 4.14549152976443013862706266081659e-01 2.01110200978472670324537219244121e-03
 	 5.80713607142624876900072194985114e-01 4.14549152976443013862706266081659e-01 4.73723988093216474837277019105386e-03 2.01110200978472670324537219244121e-03
 	 5.80713607142624876900072194985114e-01 4.73723988093216474837277019105386e-03 4.14549152976443013862706266081659e-01 2.01110200978472670324537219244121e-03
 	 3.07536188240941033011921490469831e-01 2.21352139073682022130107327484438e-02 6.70328597851690743958386065060040e-01 4.26833470263448307852049978805553e-03
 	 3.07536188240941033011921490469831e-01 6.70328597851690743958386065060040e-01 2.21352139073682022130107327484438e-02 4.26833470263448307852049978805553e-03
 	 2.21352139073682022130107327484438e-02 3.07536188240941033011921490469831e-01 6.70328597851690743958386065060040e-01 4.26833470263448307852049978805553e-03
 	 2.21352139073682022130107327484438e-02 6.70328597851690743958386065060040e-01 3.07536188240941033011921490469831e-01 4.26833470263448307852049978805553e-03
 	 6.70328597851690743958386065060040e-01 3.07536188240941033011921490469831e-01 2.21352139073682022130107327484438e-02 4.26833470263448307852049978805553e-03
 	 6.70328597851690743958386065060040e-01 2.21352139073682022130107327484438e-02 3.07536188240941033011921490469831e-01 4.26833470263448307852049978805553e-03
 	 1.10926664433470392734371046117303e-01 4.39339510946666188945242126351332e-03 8.84679940457062885528216611419339e-01 1.28787640889536729969788719785129e-03
 	 1.10926664433470392734371046117303e-01 8.84679940457062885528216611419339e-01 4.39339510946666188945242126351332e-03 1.28787640889536729969788719785129e-03
 	 4.39339510946666188945242126351332e-03 1.10926664433470392734371046117303e-01 8.84679940457062885528216611419339e-01 1.28787640889536729969788719785129e-03
 	 4.39339510946666188945242126351332e-03 8.84679940457062885528216611419339e-01 1.10926664433470392734371046117303e-01 1.28787640889536729969788719785129e-03
 	 8.84679940457062885528216611419339e-01 1.10926664433470392734371046117303e-01 4.39339510946666188945242126351332e-03 1.28787640889536729969788719785129e-03
 	 8.84679940457062885528216611419339e-01 4.39339510946666188945242126351332e-03 1.10926664433470392734371046117303e-01 1.28787640889536729969788719785129e-03
 	 3.18863122056367798151654824323487e-01 5.51602053562473687575717917752627e-02 6.25976672587384874724136807344621e-01 6.59988332725677719764467710206191e-03
 	 3.18863122056367798151654824323487e-01 6.25976672587384874724136807344621e-01 5.51602053562473687575717917752627e-02 6.59988332725677719764467710206191e-03
 	 5.51602053562473687575717917752627e-02 3.18863122056367798151654824323487e-01 6.25976672587384874724136807344621e-01 6.59988332725677719764467710206191e-03
 	 5.51602053562473687575717917752627e-02 6.25976672587384874724136807344621e-01 3.18863122056367798151654824323487e-01 6.59988332725677719764467710206191e-03
 	 6.25976672587384874724136807344621e-01 3.18863122056367798151654824323487e-01 5.51602053562473687575717917752627e-02 6.59988332725677719764467710206191e-03
 	 6.25976672587384874724136807344621e-01 5.51602053562473687575717917752627e-02 3.18863122056367798151654824323487e-01 6.59988332725677719764467710206191e-03
 	 3.95367759101382776343314162659226e-01 2.43998884696386975079462899884675e-02 5.80232352428978526148739547352307e-01 4.94743280880819043254792433117473e-03
 	 3.95367759101382776343314162659226e-01 5.80232352428978526148739547352307e-01 2.43998884696386975079462899884675e-02 4.94743280880819043254792433117473e-03
 	 2.43998884696386975079462899884675e-02 3.95367759101382776343314162659226e-01 5.80232352428978526148739547352307e-01 4.94743280880819043254792433117473e-03
 	 2.43998884696386975079462899884675e-02 5.80232352428978526148739547352307e-01 3.95367759101382776343314162659226e-01 4.94743280880819043254792433117473e-03
 	 5.80232352428978526148739547352307e-01 3.95367759101382776343314162659226e-01 2.43998884696386975079462899884675e-02 4.94743280880819043254792433117473e-03
 	 5.80232352428978526148739547352307e-01 2.43998884696386975079462899884675e-02 3.95367759101382776343314162659226e-01 4.94743280880819043254792433117473e-03
 	 2.13757830297353068615962001786102e-01 1.50634941829186158601672218537715e-01 6.35607227873460800537941395305097e-01 9.18148155792710557454583408798499e-03
 	 2.13757830297353068615962001786102e-01 6.35607227873460800537941395305097e-01 1.50634941829186158601672218537715e-01 9.18148155792710557454583408798499e-03
 	 1.50634941829186158601672218537715e-01 2.13757830297353068615962001786102e-01 6.35607227873460800537941395305097e-01 9.18148155792710557454583408798499e-03
 	 1.50634941829186158601672218537715e-01 6.35607227873460800537941395305097e-01 2.13757830297353068615962001786102e-01 9.18148155792710557454583408798499e-03
 	 6.35607227873460800537941395305097e-01 2.13757830297353068615962001786102e-01 1.50634941829186158601672218537715e-01 9.18148155792710557454583408798499e-03
 	 6.35607227873460800537941395305097e-01 1.50634941829186158601672218537715e-01 2.13757830297353068615962001786102e-01 9.18148155792710557454583408798499e-03
 	 2.47793702175406298227056112182254e-02 4.50238528829736278646933556046861e-03 9.70718244494161996982484197360463e-01 6.44001774347432043993366690415314e-04
 	 2.47793702175406298227056112182254e-02 9.70718244494161996982484197360463e-01 4.50238528829736278646933556046861e-03 6.44001774347432043993366690415314e-04
 	 4.50238528829736278646933556046861e-03 2.47793702175406298227056112182254e-02 9.70718244494161996982484197360463e-01 6.44001774347432043993366690415314e-04
 	 4.50238528829736278646933556046861e-03 9.70718244494161996982484197360463e-01 2.47793702175406298227056112182254e-02 6.44001774347432043993366690415314e-04
 	 9.70718244494161996982484197360463e-01 2.47793702175406298227056112182254e-02 4.50238528829736278646933556046861e-03 6.44001774347432043993366690415314e-04
 	 9.70718244494161996982484197360463e-01 4.50238528829736278646933556046861e-03 2.47793702175406298227056112182254e-02 6.44001774347432043993366690415314e-04
 	 ];
 
 	 case  34 

 	 % ALG. DEG.:   34
 	 % PTS CARD.:  214
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.9e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 1.21009649301711177254992080065676e-02
 	 4.59825951541271496503249238685385e-02 4.59825951541271496503249238685385e-02 9.08034809691745659065986728819553e-01 2.29896656880910696396647097117238e-03
 	 4.59825951541271496503249238685385e-02 9.08034809691745659065986728819553e-01 4.59825951541271496503249238685385e-02 2.29896656880910696396647097117238e-03
 	 9.08034809691745659065986728819553e-01 4.59825951541271496503249238685385e-02 4.59825951541271496503249238685385e-02 2.29896656880910696396647097117238e-03
 	 2.08387475149684059383403678111790e-02 2.08387475149684059383403678111790e-02 9.58322504970063215878894880006555e-01 1.09968056646319711083803483120391e-03
 	 2.08387475149684059383403678111790e-02 9.58322504970063215878894880006555e-01 2.08387475149684059383403678111790e-02 1.09968056646319711083803483120391e-03
 	 9.58322504970063215878894880006555e-01 2.08387475149684059383403678111790e-02 2.08387475149684059383403678111790e-02 1.09968056646319711083803483120391e-03
 	 7.57621741867907788625657872216834e-02 7.57621741867907788625657872216834e-02 8.48475651626418470030444041185547e-01 3.99737345364934229530184950363036e-03
 	 7.57621741867907788625657872216834e-02 8.48475651626418470030444041185547e-01 7.57621741867907788625657872216834e-02 3.99737345364934229530184950363036e-03
 	 8.48475651626418470030444041185547e-01 7.57621741867907788625657872216834e-02 7.57621741867907788625657872216834e-02 3.99737345364934229530184950363036e-03
 	 3.76601980517545675830604068323737e-01 3.76601980517545675830604068323737e-01 2.46796038964908648338791863352526e-01 1.17400065912575766319259074066395e-02
 	 3.76601980517545675830604068323737e-01 2.46796038964908648338791863352526e-01 3.76601980517545675830604068323737e-01 1.17400065912575766319259074066395e-02
 	 2.46796038964908648338791863352526e-01 3.76601980517545675830604068323737e-01 3.76601980517545675830604068323737e-01 1.17400065912575766319259074066395e-02
 	 2.87355839822164893515576977733872e-01 2.87355839822164893515576977733872e-01 4.25288320355670212968846044532256e-01 1.17612076394136236962006947237569e-02
 	 2.87355839822164893515576977733872e-01 4.25288320355670212968846044532256e-01 2.87355839822164893515576977733872e-01 1.17612076394136236962006947237569e-02
 	 4.25288320355670212968846044532256e-01 2.87355839822164893515576977733872e-01 2.87355839822164893515576977733872e-01 1.17612076394136236962006947237569e-02
 	 4.74412498902845591874921638009255e-01 4.74412498902845591874921638009255e-01 5.11750021943088162501567239814904e-02 6.48422521383851778453699665760723e-03
 	 4.74412498902845591874921638009255e-01 5.11750021943088162501567239814904e-02 4.74412498902845591874921638009255e-01 6.48422521383851778453699665760723e-03
 	 5.11750021943088162501567239814904e-02 4.74412498902845591874921638009255e-01 4.74412498902845591874921638009255e-01 6.48422521383851778453699665760723e-03
 	 1.11172701285845609842084513729787e-01 1.11172701285845609842084513729787e-01 7.77654597428308780315830972540425e-01 5.83343367955422263670950400182846e-03
 	 1.11172701285845609842084513729787e-01 7.77654597428308780315830972540425e-01 1.11172701285845609842084513729787e-01 5.83343367955422263670950400182846e-03
 	 7.77654597428308780315830972540425e-01 1.11172701285845609842084513729787e-01 1.11172701285845609842084513729787e-01 5.83343367955422263670950400182846e-03
 	 4.91864961957689694749262798723066e-01 4.91864961957689694749262798723066e-01 1.62700760846206105014744025538675e-02 3.72937094341817178960729606274072e-03
 	 4.91864961957689694749262798723066e-01 1.62700760846206105014744025538675e-02 4.91864961957689694749262798723066e-01 3.72937094341817178960729606274072e-03
 	 1.62700760846206105014744025538675e-02 4.91864961957689694749262798723066e-01 4.91864961957689694749262798723066e-01 3.72937094341817178960729606274072e-03
 	 1.50887722762872905635234133114864e-01 1.50887722762872905635234133114864e-01 6.98224554474254244240682965028100e-01 7.68731068596367923817513911899368e-03
 	 1.50887722762872905635234133114864e-01 6.98224554474254244240682965028100e-01 1.50887722762872905635234133114864e-01 7.68731068596367923817513911899368e-03
 	 6.98224554474254244240682965028100e-01 1.50887722762872905635234133114864e-01 1.50887722762872905635234133114864e-01 7.68731068596367923817513911899368e-03
 	 4.15795739231892506199139702971479e-03 4.15795739231892506199139702971479e-03 9.91684085215362109977377258474007e-01 2.26961356770943298083106909324158e-04
 	 4.15795739231892506199139702971479e-03 9.91684085215362109977377258474007e-01 4.15795739231892506199139702971479e-03 2.26961356770943298083106909324158e-04
 	 9.91684085215362109977377258474007e-01 4.15795739231892506199139702971479e-03 4.15795739231892506199139702971479e-03 2.26961356770943298083106909324158e-04
 	 2.40434910413816760321736865080311e-01 2.40434910413816760321736865080311e-01 5.19130179172366479356526269839378e-01 1.08136993162696228715224933125683e-02
 	 2.40434910413816760321736865080311e-01 5.19130179172366479356526269839378e-01 2.40434910413816760321736865080311e-01 1.08136993162696228715224933125683e-02
 	 5.19130179172366479356526269839378e-01 2.40434910413816760321736865080311e-01 2.40434910413816760321736865080311e-01 1.08136993162696228715224933125683e-02
 	 4.15511596744837174988163042144151e-01 4.15511596744837174988163042144151e-01 1.68976806510325650023673915711697e-01 1.06474448424889300141016335032873e-02
 	 4.15511596744837174988163042144151e-01 1.68976806510325650023673915711697e-01 4.15511596744837174988163042144151e-01 1.06474448424889300141016335032873e-02
 	 1.68976806510325650023673915711697e-01 4.15511596744837174988163042144151e-01 4.15511596744837174988163042144151e-01 1.06474448424889300141016335032873e-02
 	 4.99542182661511791064157250730204e-01 4.99542182661511791064157250730204e-01 9.15634676976417871685498539591208e-04 7.60926166218100791943657057458950e-04
 	 4.99542182661511791064157250730204e-01 9.15634676976417871685498539591208e-04 4.99542182661511791064157250730204e-01 7.60926166218100791943657057458950e-04
 	 9.15634676976417871685498539591208e-04 4.99542182661511791064157250730204e-01 4.99542182661511791064157250730204e-01 7.60926166218100791943657057458950e-04
 	 4.48564265878708234858152081869775e-01 4.48564265878708234858152081869775e-01 1.02871468242583530283695836260449e-01 8.86093930015303607450327660899347e-03
 	 4.48564265878708234858152081869775e-01 1.02871468242583530283695836260449e-01 4.48564265878708234858152081869775e-01 8.86093930015303607450327660899347e-03
 	 1.02871468242583530283695836260449e-01 4.48564265878708234858152081869775e-01 4.48564265878708234858152081869775e-01 8.86093930015303607450327660899347e-03
 	 1.94386543578966120016104923706735e-01 1.94386543578966120016104923706735e-01 6.11226912842067759967790152586531e-01 9.40014103719835278361038888306211e-03
 	 1.94386543578966120016104923706735e-01 6.11226912842067759967790152586531e-01 1.94386543578966120016104923706735e-01 9.40014103719835278361038888306211e-03
 	 6.11226912842067759967790152586531e-01 1.94386543578966120016104923706735e-01 1.94386543578966120016104923706735e-01 9.40014103719835278361038888306211e-03
 	 3.85126251838280975192674304707907e-01 2.10967602701019364686008117359961e-02 5.93776987891617036297020604251884e-01 1.01685972367131298140299766608052e-04
 	 3.85126251838280975192674304707907e-01 5.93776987891617036297020604251884e-01 2.10967602701019364686008117359961e-02 1.01685972367131298140299766608052e-04
 	 2.10967602701019364686008117359961e-02 3.85126251838280975192674304707907e-01 5.93776987891617036297020604251884e-01 1.01685972367131298140299766608052e-04
 	 2.10967602701019364686008117359961e-02 5.93776987891617036297020604251884e-01 3.85126251838280975192674304707907e-01 1.01685972367131298140299766608052e-04
 	 5.93776987891617036297020604251884e-01 3.85126251838280975192674304707907e-01 2.10967602701019364686008117359961e-02 1.01685972367131298140299766608052e-04
 	 5.93776987891617036297020604251884e-01 2.10967602701019364686008117359961e-02 3.85126251838280975192674304707907e-01 1.01685972367131298140299766608052e-04
 	 5.28200673454987598698373574279685e-02 3.38811215039004848606496445029279e-03 9.43791820504111256262547158257803e-01 6.54047966587506589102030130078447e-04
 	 5.28200673454987598698373574279685e-02 9.43791820504111256262547158257803e-01 3.38811215039004848606496445029279e-03 6.54047966587506589102030130078447e-04
 	 3.38811215039004848606496445029279e-03 5.28200673454987598698373574279685e-02 9.43791820504111256262547158257803e-01 6.54047966587506589102030130078447e-04
 	 3.38811215039004848606496445029279e-03 9.43791820504111256262547158257803e-01 5.28200673454987598698373574279685e-02 6.54047966587506589102030130078447e-04
 	 9.43791820504111256262547158257803e-01 5.28200673454987598698373574279685e-02 3.38811215039004848606496445029279e-03 6.54047966587506589102030130078447e-04
 	 9.43791820504111256262547158257803e-01 3.38811215039004848606496445029279e-03 5.28200673454987598698373574279685e-02 6.54047966587506589102030130078447e-04
 	 5.08987652831316070289879860411020e-02 1.82083287994723903857607893996828e-02 9.30892905917395929726865233533317e-01 1.51981165826163750788568851390892e-03
 	 5.08987652831316070289879860411020e-02 9.30892905917395929726865233533317e-01 1.82083287994723903857607893996828e-02 1.51981165826163750788568851390892e-03
 	 1.82083287994723903857607893996828e-02 5.08987652831316070289879860411020e-02 9.30892905917395929726865233533317e-01 1.51981165826163750788568851390892e-03
 	 1.82083287994723903857607893996828e-02 9.30892905917395929726865233533317e-01 5.08987652831316070289879860411020e-02 1.51981165826163750788568851390892e-03
 	 9.30892905917395929726865233533317e-01 5.08987652831316070289879860411020e-02 1.82083287994723903857607893996828e-02 1.51981165826163750788568851390892e-03
 	 9.30892905917395929726865233533317e-01 1.82083287994723903857607893996828e-02 5.08987652831316070289879860411020e-02 1.51981165826163750788568851390892e-03
 	 1.29124372072608517569847208505962e-01 6.05107706433122560785164978369721e-02 8.10364857284079254107211909285979e-01 4.66963768394592065175130457532759e-03
 	 1.29124372072608517569847208505962e-01 8.10364857284079254107211909285979e-01 6.05107706433122560785164978369721e-02 4.66963768394592065175130457532759e-03
 	 6.05107706433122560785164978369721e-02 1.29124372072608517569847208505962e-01 8.10364857284079254107211909285979e-01 4.66963768394592065175130457532759e-03
 	 6.05107706433122560785164978369721e-02 8.10364857284079254107211909285979e-01 1.29124372072608517569847208505962e-01 4.66963768394592065175130457532759e-03
 	 8.10364857284079254107211909285979e-01 1.29124372072608517569847208505962e-01 6.05107706433122560785164978369721e-02 4.66963768394592065175130457532759e-03
 	 8.10364857284079254107211909285979e-01 6.05107706433122560785164978369721e-02 1.29124372072608517569847208505962e-01 4.66963768394592065175130457532759e-03
 	 8.78179027775244785969377403489489e-02 3.59198913635777883346378303031088e-02 8.76262205858897802457363468420226e-01 2.95211563056217707323725107926293e-03
 	 8.78179027775244785969377403489489e-02 8.76262205858897802457363468420226e-01 3.59198913635777883346378303031088e-02 2.95211563056217707323725107926293e-03
 	 3.59198913635777883346378303031088e-02 8.78179027775244785969377403489489e-02 8.76262205858897802457363468420226e-01 2.95211563056217707323725107926293e-03
 	 3.59198913635777883346378303031088e-02 8.76262205858897802457363468420226e-01 8.78179027775244785969377403489489e-02 2.95211563056217707323725107926293e-03
 	 8.76262205858897802457363468420226e-01 8.78179027775244785969377403489489e-02 3.59198913635777883346378303031088e-02 2.95211563056217707323725107926293e-03
 	 8.76262205858897802457363468420226e-01 3.59198913635777883346378303031088e-02 8.78179027775244785969377403489489e-02 2.95211563056217707323725107926293e-03
 	 2.73553738024819192986569760250859e-01 1.64061028670212660784955005510710e-01 5.62385233304968146228475234238431e-01 9.86093031290471641603367913830880e-03
 	 2.73553738024819192986569760250859e-01 5.62385233304968146228475234238431e-01 1.64061028670212660784955005510710e-01 9.86093031290471641603367913830880e-03
 	 1.64061028670212660784955005510710e-01 2.73553738024819192986569760250859e-01 5.62385233304968146228475234238431e-01 9.86093031290471641603367913830880e-03
 	 1.64061028670212660784955005510710e-01 5.62385233304968146228475234238431e-01 2.73553738024819192986569760250859e-01 9.86093031290471641603367913830880e-03
 	 5.62385233304968146228475234238431e-01 2.73553738024819192986569760250859e-01 1.64061028670212660784955005510710e-01 9.86093031290471641603367913830880e-03
 	 5.62385233304968146228475234238431e-01 1.64061028670212660784955005510710e-01 2.73553738024819192986569760250859e-01 9.86093031290471641603367913830880e-03
 	 9.44770656323741658821901978626556e-02 1.06832635235884227525859913043860e-02 8.94839670844037482488886325882049e-01 1.72627325884169738161311169477585e-03
 	 9.44770656323741658821901978626556e-02 8.94839670844037482488886325882049e-01 1.06832635235884227525859913043860e-02 1.72627325884169738161311169477585e-03
 	 1.06832635235884227525859913043860e-02 9.44770656323741658821901978626556e-02 8.94839670844037482488886325882049e-01 1.72627325884169738161311169477585e-03
 	 1.06832635235884227525859913043860e-02 8.94839670844037482488886325882049e-01 9.44770656323741658821901978626556e-02 1.72627325884169738161311169477585e-03
 	 8.94839670844037482488886325882049e-01 9.44770656323741658821901978626556e-02 1.06832635235884227525859913043860e-02 1.72627325884169738161311169477585e-03
 	 8.94839670844037482488886325882049e-01 1.06832635235884227525859913043860e-02 9.44770656323741658821901978626556e-02 1.72627325884169738161311169477585e-03
 	 4.11152233303600511682418527925620e-01 3.11326803063737105048414122165923e-02 5.57715086390025760465505300089717e-01 5.03618250133393459411212944587533e-03
 	 4.11152233303600511682418527925620e-01 5.57715086390025760465505300089717e-01 3.11326803063737105048414122165923e-02 5.03618250133393459411212944587533e-03
 	 3.11326803063737105048414122165923e-02 4.11152233303600511682418527925620e-01 5.57715086390025760465505300089717e-01 5.03618250133393459411212944587533e-03
 	 3.11326803063737105048414122165923e-02 5.57715086390025760465505300089717e-01 4.11152233303600511682418527925620e-01 5.03618250133393459411212944587533e-03
 	 5.57715086390025760465505300089717e-01 4.11152233303600511682418527925620e-01 3.11326803063737105048414122165923e-02 5.03618250133393459411212944587533e-03
 	 5.57715086390025760465505300089717e-01 3.11326803063737105048414122165923e-02 4.11152233303600511682418527925620e-01 5.03618250133393459411212944587533e-03
 	 3.59447569498255292685939821240027e-01 1.33192623221705830349748111984809e-01 5.07359807280038932475463298032992e-01 9.65788022944679726278227605007487e-03
 	 3.59447569498255292685939821240027e-01 5.07359807280038932475463298032992e-01 1.33192623221705830349748111984809e-01 9.65788022944679726278227605007487e-03
 	 1.33192623221705830349748111984809e-01 3.59447569498255292685939821240027e-01 5.07359807280038932475463298032992e-01 9.65788022944679726278227605007487e-03
 	 1.33192623221705830349748111984809e-01 5.07359807280038932475463298032992e-01 3.59447569498255292685939821240027e-01 9.65788022944679726278227605007487e-03
 	 5.07359807280038932475463298032992e-01 3.59447569498255292685939821240027e-01 1.33192623221705830349748111984809e-01 9.65788022944679726278227605007487e-03
 	 5.07359807280038932475463298032992e-01 1.33192623221705830349748111984809e-01 3.59447569498255292685939821240027e-01 9.65788022944679726278227605007487e-03
 	 3.88410085330437082618004751566332e-01 7.42973192372942126127099982113577e-02 5.37292595432268704769285250222310e-01 7.61191502088587063773461593996217e-03
 	 3.88410085330437082618004751566332e-01 5.37292595432268704769285250222310e-01 7.42973192372942126127099982113577e-02 7.61191502088587063773461593996217e-03
 	 7.42973192372942126127099982113577e-02 3.88410085330437082618004751566332e-01 5.37292595432268704769285250222310e-01 7.61191502088587063773461593996217e-03
 	 7.42973192372942126127099982113577e-02 5.37292595432268704769285250222310e-01 3.88410085330437082618004751566332e-01 7.61191502088587063773461593996217e-03
 	 5.37292595432268704769285250222310e-01 3.88410085330437082618004751566332e-01 7.42973192372942126127099982113577e-02 7.61191502088587063773461593996217e-03
 	 5.37292595432268704769285250222310e-01 7.42973192372942126127099982113577e-02 3.88410085330437082618004751566332e-01 7.61191502088587063773461593996217e-03
 	 3.25355043342057725919147515014629e-01 2.05166497814761955575946217322780e-01 4.69478458843180290749330652033677e-01 1.10658638875991179040259027033244e-02
 	 3.25355043342057725919147515014629e-01 4.69478458843180290749330652033677e-01 2.05166497814761955575946217322780e-01 1.10658638875991179040259027033244e-02
 	 2.05166497814761955575946217322780e-01 3.25355043342057725919147515014629e-01 4.69478458843180290749330652033677e-01 1.10658638875991179040259027033244e-02
 	 2.05166497814761955575946217322780e-01 4.69478458843180290749330652033677e-01 3.25355043342057725919147515014629e-01 1.10658638875991179040259027033244e-02
 	 4.69478458843180290749330652033677e-01 3.25355043342057725919147515014629e-01 2.05166497814761955575946217322780e-01 1.10658638875991179040259027033244e-02
 	 4.69478458843180290749330652033677e-01 2.05166497814761955575946217322780e-01 3.25355043342057725919147515014629e-01 1.10658638875991179040259027033244e-02
 	 1.74780479481068395930520864567370e-01 9.02196061251755165866228480808786e-02 7.34999914393756115238431902980665e-01 6.50383971264974040937811849971695e-03
 	 1.74780479481068395930520864567370e-01 7.34999914393756115238431902980665e-01 9.02196061251755165866228480808786e-02 6.50383971264974040937811849971695e-03
 	 9.02196061251755165866228480808786e-02 1.74780479481068395930520864567370e-01 7.34999914393756115238431902980665e-01 6.50383971264974040937811849971695e-03
 	 9.02196061251755165866228480808786e-02 7.34999914393756115238431902980665e-01 1.74780479481068395930520864567370e-01 6.50383971264974040937811849971695e-03
 	 7.34999914393756115238431902980665e-01 1.74780479481068395930520864567370e-01 9.02196061251755165866228480808786e-02 6.50383971264974040937811849971695e-03
 	 7.34999914393756115238431902980665e-01 9.02196061251755165866228480808786e-02 1.74780479481068395930520864567370e-01 6.50383971264974040937811849971695e-03
 	 1.94164618149563289462022908082872e-01 4.39158729045114326616783273493638e-02 7.61919508945925194609571917681023e-01 4.83268725348508666056490667983780e-03
 	 1.94164618149563289462022908082872e-01 7.61919508945925194609571917681023e-01 4.39158729045114326616783273493638e-02 4.83268725348508666056490667983780e-03
 	 4.39158729045114326616783273493638e-02 1.94164618149563289462022908082872e-01 7.61919508945925194609571917681023e-01 4.83268725348508666056490667983780e-03
 	 4.39158729045114326616783273493638e-02 7.61919508945925194609571917681023e-01 1.94164618149563289462022908082872e-01 4.83268725348508666056490667983780e-03
 	 7.61919508945925194609571917681023e-01 1.94164618149563289462022908082872e-01 4.39158729045114326616783273493638e-02 4.83268725348508666056490667983780e-03
 	 7.61919508945925194609571917681023e-01 4.39158729045114326616783273493638e-02 1.94164618149563289462022908082872e-01 4.83268725348508666056490667983780e-03
 	 2.48327873404578958194122151326155e-01 6.89638299646016944555171335196064e-02 6.82708296630819333472572907339782e-01 6.59351446774943724532525024528695e-03
 	 2.48327873404578958194122151326155e-01 6.82708296630819333472572907339782e-01 6.89638299646016944555171335196064e-02 6.59351446774943724532525024528695e-03
 	 6.89638299646016944555171335196064e-02 2.48327873404578958194122151326155e-01 6.82708296630819333472572907339782e-01 6.59351446774943724532525024528695e-03
 	 6.89638299646016944555171335196064e-02 6.82708296630819333472572907339782e-01 2.48327873404578958194122151326155e-01 6.59351446774943724532525024528695e-03
 	 6.82708296630819333472572907339782e-01 2.48327873404578958194122151326155e-01 6.89638299646016944555171335196064e-02 6.59351446774943724532525024528695e-03
 	 6.82708296630819333472572907339782e-01 6.89638299646016944555171335196064e-02 2.48327873404578958194122151326155e-01 6.59351446774943724532525024528695e-03
 	 2.22992041261200868440539579751203e-01 1.25181798142886657743133582698647e-01 6.51826160595912473816326837550150e-01 8.28526651310065344324673475284726e-03
 	 2.22992041261200868440539579751203e-01 6.51826160595912473816326837550150e-01 1.25181798142886657743133582698647e-01 8.28526651310065344324673475284726e-03
 	 1.25181798142886657743133582698647e-01 2.22992041261200868440539579751203e-01 6.51826160595912473816326837550150e-01 8.28526651310065344324673475284726e-03
 	 1.25181798142886657743133582698647e-01 6.51826160595912473816326837550150e-01 2.22992041261200868440539579751203e-01 8.28526651310065344324673475284726e-03
 	 6.51826160595912473816326837550150e-01 2.22992041261200868440539579751203e-01 1.25181798142886657743133582698647e-01 8.28526651310065344324673475284726e-03
 	 6.51826160595912473816326837550150e-01 1.25181798142886657743133582698647e-01 2.22992041261200868440539579751203e-01 8.28526651310065344324673475284726e-03
 	 1.49604423548951093181358373840339e-01 4.67029856128329395881237928733754e-03 8.45725277889765592043147535150638e-01 1.39942938540308639203124663197286e-03
 	 1.49604423548951093181358373840339e-01 8.45725277889765592043147535150638e-01 4.67029856128329395881237928733754e-03 1.39942938540308639203124663197286e-03
 	 4.67029856128329395881237928733754e-03 1.49604423548951093181358373840339e-01 8.45725277889765592043147535150638e-01 1.39942938540308639203124663197286e-03
 	 4.67029856128329395881237928733754e-03 8.45725277889765592043147535150638e-01 1.49604423548951093181358373840339e-01 1.39942938540308639203124663197286e-03
 	 8.45725277889765592043147535150638e-01 1.49604423548951093181358373840339e-01 4.67029856128329395881237928733754e-03 1.39942938540308639203124663197286e-03
 	 8.45725277889765592043147535150638e-01 4.67029856128329395881237928733754e-03 1.49604423548951093181358373840339e-01 1.39942938540308639203124663197286e-03
 	 3.28391413692126599155329813584103e-01 4.89259225038644121608122361521964e-02 6.22682663804008940111600622913102e-01 6.09526403248833881926005417994929e-03
 	 3.28391413692126599155329813584103e-01 6.22682663804008940111600622913102e-01 4.89259225038644121608122361521964e-02 6.09526403248833881926005417994929e-03
 	 4.89259225038644121608122361521964e-02 3.28391413692126599155329813584103e-01 6.22682663804008940111600622913102e-01 6.09526403248833881926005417994929e-03
 	 4.89259225038644121608122361521964e-02 6.22682663804008940111600622913102e-01 3.28391413692126599155329813584103e-01 6.09526403248833881926005417994929e-03
 	 6.22682663804008940111600622913102e-01 3.28391413692126599155329813584103e-01 4.89259225038644121608122361521964e-02 6.09526403248833881926005417994929e-03
 	 6.22682663804008940111600622913102e-01 4.89259225038644121608122361521964e-02 3.28391413692126599155329813584103e-01 6.09526403248833881926005417994929e-03
 	 1.42385500324542807470962202387454e-01 2.46582497782073459258178615982615e-02 8.32956249897249922931052878993796e-01 3.14320614815928774110620480541911e-03
 	 1.42385500324542807470962202387454e-01 8.32956249897249922931052878993796e-01 2.46582497782073459258178615982615e-02 3.14320614815928774110620480541911e-03
 	 2.46582497782073459258178615982615e-02 1.42385500324542807470962202387454e-01 8.32956249897249922931052878993796e-01 3.14320614815928774110620480541911e-03
 	 2.46582497782073459258178615982615e-02 8.32956249897249922931052878993796e-01 1.42385500324542807470962202387454e-01 3.14320614815928774110620480541911e-03
 	 8.32956249897249922931052878993796e-01 1.42385500324542807470962202387454e-01 2.46582497782073459258178615982615e-02 3.14320614815928774110620480541911e-03
 	 8.32956249897249922931052878993796e-01 2.46582497782073459258178615982615e-02 1.42385500324542807470962202387454e-01 3.14320614815928774110620480541911e-03
 	 4.23840299720368851588148118025856e-01 5.95994324974427527180642627513407e-03 5.70199757029886900028259333339520e-01 2.23133179335329974793400431565260e-03
 	 4.23840299720368851588148118025856e-01 5.70199757029886900028259333339520e-01 5.95994324974427527180642627513407e-03 2.23133179335329974793400431565260e-03
 	 5.95994324974427527180642627513407e-03 4.23840299720368851588148118025856e-01 5.70199757029886900028259333339520e-01 2.23133179335329974793400431565260e-03
 	 5.95994324974427527180642627513407e-03 5.70199757029886900028259333339520e-01 4.23840299720368851588148118025856e-01 2.23133179335329974793400431565260e-03
 	 5.70199757029886900028259333339520e-01 4.23840299720368851588148118025856e-01 5.95994324974427527180642627513407e-03 2.23133179335329974793400431565260e-03
 	 5.70199757029886900028259333339520e-01 5.95994324974427527180642627513407e-03 4.23840299720368851588148118025856e-01 2.23133179335329974793400431565260e-03
 	 2.67690419344305596816013803618262e-01 2.85187228422853940312808873613903e-02 7.03790857813408998744364453159506e-01 4.43573097344195348828987945921654e-03
 	 2.67690419344305596816013803618262e-01 7.03790857813408998744364453159506e-01 2.85187228422853940312808873613903e-02 4.43573097344195348828987945921654e-03
 	 2.85187228422853940312808873613903e-02 2.67690419344305596816013803618262e-01 7.03790857813408998744364453159506e-01 4.43573097344195348828987945921654e-03
 	 2.85187228422853940312808873613903e-02 7.03790857813408998744364453159506e-01 2.67690419344305596816013803618262e-01 4.43573097344195348828987945921654e-03
 	 7.03790857813408998744364453159506e-01 2.67690419344305596816013803618262e-01 2.85187228422853940312808873613903e-02 4.43573097344195348828987945921654e-03
 	 7.03790857813408998744364453159506e-01 2.85187228422853940312808873613903e-02 2.67690419344305596816013803618262e-01 4.43573097344195348828987945921654e-03
 	 3.45411378952901138017494986343081e-01 1.55626433010154947844672079781958e-02 6.39025977746083273522970102931140e-01 3.48832734574382706538298037912682e-03
 	 3.45411378952901138017494986343081e-01 6.39025977746083273522970102931140e-01 1.55626433010154947844672079781958e-02 3.48832734574382706538298037912682e-03
 	 1.55626433010154947844672079781958e-02 3.45411378952901138017494986343081e-01 6.39025977746083273522970102931140e-01 3.48832734574382706538298037912682e-03
 	 1.55626433010154947844672079781958e-02 6.39025977746083273522970102931140e-01 3.45411378952901138017494986343081e-01 3.48832734574382706538298037912682e-03
 	 6.39025977746083273522970102931140e-01 3.45411378952901138017494986343081e-01 1.55626433010154947844672079781958e-02 3.48832734574382706538298037912682e-03
 	 6.39025977746083273522970102931140e-01 1.55626433010154947844672079781958e-02 3.45411378952901138017494986343081e-01 3.48832734574382706538298037912682e-03
 	 3.53449519657663746574627339214203e-01 9.25718233933834830362563650396623e-04 6.45624762108402472371437852416420e-01 7.31845873670111148057149108581143e-04
 	 3.53449519657663746574627339214203e-01 6.45624762108402472371437852416420e-01 9.25718233933834830362563650396623e-04 7.31845873670111148057149108581143e-04
 	 9.25718233933834830362563650396623e-04 3.53449519657663746574627339214203e-01 6.45624762108402472371437852416420e-01 7.31845873670111148057149108581143e-04
 	 9.25718233933834830362563650396623e-04 6.45624762108402472371437852416420e-01 3.53449519657663746574627339214203e-01 7.31845873670111148057149108581143e-04
 	 6.45624762108402472371437852416420e-01 3.53449519657663746574627339214203e-01 9.25718233933834830362563650396623e-04 7.31845873670111148057149108581143e-04
 	 6.45624762108402472371437852416420e-01 9.25718233933834830362563650396623e-04 3.53449519657663746574627339214203e-01 7.31845873670111148057149108581143e-04
 	 3.03335639471789153542857775391894e-01 9.92862116185854320926651439549460e-02 5.97378148909625372731113657209789e-01 8.25079743075294615162196265600869e-03
 	 3.03335639471789153542857775391894e-01 5.97378148909625372731113657209789e-01 9.92862116185854320926651439549460e-02 8.25079743075294615162196265600869e-03
 	 9.92862116185854320926651439549460e-02 3.03335639471789153542857775391894e-01 5.97378148909625372731113657209789e-01 8.25079743075294615162196265600869e-03
 	 9.92862116185854320926651439549460e-02 5.97378148909625372731113657209789e-01 3.03335639471789153542857775391894e-01 8.25079743075294615162196265600869e-03
 	 5.97378148909625372731113657209789e-01 3.03335639471789153542857775391894e-01 9.92862116185854320926651439549460e-02 8.25079743075294615162196265600869e-03
 	 5.97378148909625372731113657209789e-01 9.92862116185854320926651439549460e-02 3.03335639471789153542857775391894e-01 8.25079743075294615162196265600869e-03
 	 2.17555603201839350968604946956475e-02 3.97450587251847731184994927389198e-03 9.74269933807297650041334691195516e-01 4.97967573197117684309642715589916e-04
 	 2.17555603201839350968604946956475e-02 9.74269933807297650041334691195516e-01 3.97450587251847731184994927389198e-03 4.97967573197117684309642715589916e-04
 	 3.97450587251847731184994927389198e-03 2.17555603201839350968604946956475e-02 9.74269933807297650041334691195516e-01 4.97967573197117684309642715589916e-04
 	 3.97450587251847731184994927389198e-03 9.74269933807297650041334691195516e-01 2.17555603201839350968604946956475e-02 4.97967573197117684309642715589916e-04
 	 9.74269933807297650041334691195516e-01 2.17555603201839350968604946956475e-02 3.97450587251847731184994927389198e-03 4.97967573197117684309642715589916e-04
 	 9.74269933807297650041334691195516e-01 3.97450587251847731184994927389198e-03 2.17555603201839350968604946956475e-02 4.97967573197117684309642715589916e-04
 	 2.07546868273520451753100246605754e-01 1.37796394053688077419028701342540e-02 7.78673492321110716218868219584692e-01 2.80581813731372534809205276928878e-03
 	 2.07546868273520451753100246605754e-01 7.78673492321110716218868219584692e-01 1.37796394053688077419028701342540e-02 2.80581813731372534809205276928878e-03
 	 1.37796394053688077419028701342540e-02 2.07546868273520451753100246605754e-01 7.78673492321110716218868219584692e-01 2.80581813731372534809205276928878e-03
 	 1.37796394053688077419028701342540e-02 7.78673492321110716218868219584692e-01 2.07546868273520451753100246605754e-01 2.80581813731372534809205276928878e-03
 	 7.78673492321110716218868219584692e-01 2.07546868273520451753100246605754e-01 1.37796394053688077419028701342540e-02 2.80581813731372534809205276928878e-03
 	 7.78673492321110716218868219584692e-01 1.37796394053688077419028701342540e-02 2.07546868273520451753100246605754e-01 2.80581813731372534809205276928878e-03
 	 2.13560239517947836329625488360762e-01 7.72139120327043496430641233985170e-04 7.85667621361725077022697405482177e-01 5.77650574234758241477794005191981e-04
 	 2.13560239517947836329625488360762e-01 7.85667621361725077022697405482177e-01 7.72139120327043496430641233985170e-04 5.77650574234758241477794005191981e-04
 	 7.72139120327043496430641233985170e-04 2.13560239517947836329625488360762e-01 7.85667621361725077022697405482177e-01 5.77650574234758241477794005191981e-04
 	 7.72139120327043496430641233985170e-04 7.85667621361725077022697405482177e-01 2.13560239517947836329625488360762e-01 5.77650574234758241477794005191981e-04
 	 7.85667621361725077022697405482177e-01 2.13560239517947836329625488360762e-01 7.72139120327043496430641233985170e-04 5.77650574234758241477794005191981e-04
 	 7.85667621361725077022697405482177e-01 7.72139120327043496430641233985170e-04 2.13560239517947836329625488360762e-01 5.77650574234758241477794005191981e-04
 	 2.79386431782223720876601191775990e-01 5.46179089429344854361714212132028e-03 7.15151777323482895631912015232956e-01 1.96262880548333596211763030225939e-03
 	 2.79386431782223720876601191775990e-01 7.15151777323482895631912015232956e-01 5.46179089429344854361714212132028e-03 1.96262880548333596211763030225939e-03
 	 5.46179089429344854361714212132028e-03 2.79386431782223720876601191775990e-01 7.15151777323482895631912015232956e-01 1.96262880548333596211763030225939e-03
 	 5.46179089429344854361714212132028e-03 7.15151777323482895631912015232956e-01 2.79386431782223720876601191775990e-01 1.96262880548333596211763030225939e-03
 	 7.15151777323482895631912015232956e-01 2.79386431782223720876601191775990e-01 5.46179089429344854361714212132028e-03 1.96262880548333596211763030225939e-03
 	 7.15151777323482895631912015232956e-01 5.46179089429344854361714212132028e-03 2.79386431782223720876601191775990e-01 1.96262880548333596211763030225939e-03
 	 9.68669225755471735572754710119625e-02 4.70969101854539203629197718914412e-06 9.03128367733434300745898326567840e-01 2.87345354608133974911449159961307e-04
 	 9.68669225755471735572754710119625e-02 9.03128367733434300745898326567840e-01 4.70969101854539203629197718914412e-06 2.87345354608133974911449159961307e-04
 	 4.70969101854539203629197718914412e-06 9.68669225755471735572754710119625e-02 9.03128367733434300745898326567840e-01 2.87345354608133974911449159961307e-04
 	 4.70969101854539203629197718914412e-06 9.03128367733434300745898326567840e-01 9.68669225755471735572754710119625e-02 2.87345354608133974911449159961307e-04
 	 9.03128367733434300745898326567840e-01 9.68669225755471735572754710119625e-02 4.70969101854539203629197718914412e-06 2.87345354608133974911449159961307e-04
 	 9.03128367733434300745898326567840e-01 4.70969101854539203629197718914412e-06 9.68669225755471735572754710119625e-02 2.87345354608133974911449159961307e-04
 	 ];
 
 	 case  35 

 	 % ALG. DEG.:   35
 	 % PTS CARD.:  228
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.7e-15  

 	 xyw_bar=[
 	 3.01435168617317950090495060067042e-01 3.01435168617317950090495060067042e-01 3.97129662765364099819009879865916e-01 5.74793402967018005750299280975923e-03
 	 3.01435168617317950090495060067042e-01 3.97129662765364099819009879865916e-01 3.01435168617317950090495060067042e-01 5.74793402967018005750299280975923e-03
 	 3.97129662765364099819009879865916e-01 3.01435168617317950090495060067042e-01 3.01435168617317950090495060067042e-01 5.74793402967018005750299280975923e-03
 	 4.91641403982890690116391851915978e-01 4.91641403982890690116391851915978e-01 1.67171920342186197672162961680442e-02 2.29636809209942923185043817113637e-03
 	 4.91641403982890690116391851915978e-01 1.67171920342186197672162961680442e-02 4.91641403982890690116391851915978e-01 2.29636809209942923185043817113637e-03
 	 1.67171920342186197672162961680442e-02 4.91641403982890690116391851915978e-01 4.91641403982890690116391851915978e-01 2.29636809209942923185043817113637e-03
 	 3.57793135798597061736359137285035e-01 3.57793135798597061736359137285035e-01 2.84413728402805876527281725429930e-01 7.99535084186430919372945425038779e-03
 	 3.57793135798597061736359137285035e-01 2.84413728402805876527281725429930e-01 3.57793135798597061736359137285035e-01 7.99535084186430919372945425038779e-03
 	 2.84413728402805876527281725429930e-01 3.57793135798597061736359137285035e-01 3.57793135798597061736359137285035e-01 7.99535084186430919372945425038779e-03
 	 2.62413960109345423266091756886453e-01 2.62413960109345423266091756886453e-01 4.75172079781309153467816486227093e-01 8.79018589332779265443917893207981e-03
 	 2.62413960109345423266091756886453e-01 4.75172079781309153467816486227093e-01 2.62413960109345423266091756886453e-01 8.79018589332779265443917893207981e-03
 	 4.75172079781309153467816486227093e-01 2.62413960109345423266091756886453e-01 2.62413960109345423266091756886453e-01 8.79018589332779265443917893207981e-03
 	 4.02816450585781860027623224596027e-01 4.02816450585781860027623224596027e-01 1.94367098828436279944753550807945e-01 8.32036661232562167744841730154803e-03
 	 4.02816450585781860027623224596027e-01 1.94367098828436279944753550807945e-01 4.02816450585781860027623224596027e-01 8.32036661232562167744841730154803e-03
 	 1.94367098828436279944753550807945e-01 4.02816450585781860027623224596027e-01 4.02816450585781860027623224596027e-01 8.32036661232562167744841730154803e-03
 	 4.73088965500664149210763298469828e-01 4.73088965500664149210763298469828e-01 5.38220689986717015784734030603431e-02 5.27518828516149087398678929616835e-03
 	 4.73088965500664149210763298469828e-01 5.38220689986717015784734030603431e-02 4.73088965500664149210763298469828e-01 5.27518828516149087398678929616835e-03
 	 5.38220689986717015784734030603431e-02 4.73088965500664149210763298469828e-01 4.73088965500664149210763298469828e-01 5.27518828516149087398678929616835e-03
 	 6.28680490440657047113148792050197e-02 6.28680490440657047113148792050197e-02 8.74263901911868535066219010332134e-01 2.96820663905160084250489660462335e-03
 	 6.28680490440657047113148792050197e-02 8.74263901911868535066219010332134e-01 6.28680490440657047113148792050197e-02 2.96820663905160084250489660462335e-03
 	 8.74263901911868535066219010332134e-01 6.28680490440657047113148792050197e-02 6.28680490440657047113148792050197e-02 2.96820663905160084250489660462335e-03
 	 4.41597433754930324134591046458809e-01 4.41597433754930324134591046458809e-01 1.16805132490139351730817907082383e-01 7.60518253053635295835022134269821e-03
 	 4.41597433754930324134591046458809e-01 1.16805132490139351730817907082383e-01 4.41597433754930324134591046458809e-01 7.60518253053635295835022134269821e-03
 	 1.16805132490139351730817907082383e-01 4.41597433754930324134591046458809e-01 4.41597433754930324134591046458809e-01 7.60518253053635295835022134269821e-03
 	 1.96271599834707231868602406166247e-02 1.96271599834707231868602406166247e-02 9.60745680033058602198536846117349e-01 1.01312103273807838088593769043655e-03
 	 1.96271599834707231868602406166247e-02 9.60745680033058602198536846117349e-01 1.96271599834707231868602406166247e-02 1.01312103273807838088593769043655e-03
 	 9.60745680033058602198536846117349e-01 1.96271599834707231868602406166247e-02 1.96271599834707231868602406166247e-02 1.01312103273807838088593769043655e-03
 	 4.02868688301933966511292339873762e-02 4.02868688301933966511292339873762e-02 9.19426262339613220575529339839704e-01 2.06483562659832541735793753900907e-03
 	 4.02868688301933966511292339873762e-02 9.19426262339613220575529339839704e-01 4.02868688301933966511292339873762e-02 2.06483562659832541735793753900907e-03
 	 9.19426262339613220575529339839704e-01 4.02868688301933966511292339873762e-02 4.02868688301933966511292339873762e-02 2.06483562659832541735793753900907e-03
 	 9.85261546687923595033709034396452e-02 9.85261546687923595033709034396452e-02 8.02947690662415336504409424378537e-01 5.00363961555733063185646969373011e-03
 	 9.85261546687923595033709034396452e-02 8.02947690662415336504409424378537e-01 9.85261546687923595033709034396452e-02 5.00363961555733063185646969373011e-03
 	 8.02947690662415336504409424378537e-01 9.85261546687923595033709034396452e-02 9.85261546687923595033709034396452e-02 5.00363961555733063185646969373011e-03
 	 1.39534462989307272984262908721576e-01 1.39534462989307272984262908721576e-01 7.20931074021385454031474182556849e-01 6.71907981241738963551490826375812e-03
 	 1.39534462989307272984262908721576e-01 7.20931074021385454031474182556849e-01 1.39534462989307272984262908721576e-01 6.71907981241738963551490826375812e-03
 	 7.20931074021385454031474182556849e-01 1.39534462989307272984262908721576e-01 1.39534462989307272984262908721576e-01 6.71907981241738963551490826375812e-03
 	 2.21536010509691960734812710143160e-01 2.21536010509691960734812710143160e-01 5.56927978980616078530374579713680e-01 9.16190894093729842062590051909865e-03
 	 2.21536010509691960734812710143160e-01 5.56927978980616078530374579713680e-01 2.21536010509691960734812710143160e-01 9.16190894093729842062590051909865e-03
 	 5.56927978980616078530374579713680e-01 2.21536010509691960734812710143160e-01 2.21536010509691960734812710143160e-01 9.16190894093729842062590051909865e-03
 	 1.80750322135299568149235938108177e-01 1.80750322135299568149235938108177e-01 6.38499355729400863701528123783646e-01 8.37190663701295988141648507507853e-03
 	 1.80750322135299568149235938108177e-01 6.38499355729400863701528123783646e-01 1.80750322135299568149235938108177e-01 8.37190663701295988141648507507853e-03
 	 6.38499355729400863701528123783646e-01 1.80750322135299568149235938108177e-01 1.80750322135299568149235938108177e-01 8.37190663701295988141648507507853e-03
 	 4.27720726848295623723217318001844e-03 4.27720726848295623723217318001844e-03 9.91445585463034073647747845825506e-01 2.40333737404841091614415837796059e-04
 	 4.27720726848295623723217318001844e-03 9.91445585463034073647747845825506e-01 4.27720726848295623723217318001844e-03 2.40333737404841091614415837796059e-04
 	 9.91445585463034073647747845825506e-01 4.27720726848295623723217318001844e-03 4.27720726848295623723217318001844e-03 2.40333737404841091614415837796059e-04
 	 4.99913222486225106155899311488611e-01 4.99913222486225106155899311488611e-01 1.73555027549787688201377022778615e-04 6.27584341070564627473871155416418e-04
 	 4.99913222486225106155899311488611e-01 1.73555027549787688201377022778615e-04 4.99913222486225106155899311488611e-01 6.27584341070564627473871155416418e-04
 	 1.73555027549787688201377022778615e-04 4.99913222486225106155899311488611e-01 4.99913222486225106155899311488611e-01 6.27584341070564627473871155416418e-04
 	 5.50454796915316388328243135674711e-02 2.06822021540594260316514585440473e-03 9.42886300093062401650456649804255e-01 4.54199382375397207271122690386278e-04
 	 5.50454796915316388328243135674711e-02 9.42886300093062401650456649804255e-01 2.06822021540594260316514585440473e-03 4.54199382375397207271122690386278e-04
 	 2.06822021540594260316514585440473e-03 5.50454796915316388328243135674711e-02 9.42886300093062401650456649804255e-01 4.54199382375397207271122690386278e-04
 	 2.06822021540594260316514585440473e-03 9.42886300093062401650456649804255e-01 5.50454796915316388328243135674711e-02 4.54199382375397207271122690386278e-04
 	 9.42886300093062401650456649804255e-01 5.50454796915316388328243135674711e-02 2.06822021540594260316514585440473e-03 4.54199382375397207271122690386278e-04
 	 9.42886300093062401650456649804255e-01 2.06822021540594260316514585440473e-03 5.50454796915316388328243135674711e-02 4.54199382375397207271122690386278e-04
 	 4.45376464915297476387934239028255e-01 8.90499418612781569459802000210402e-03 5.45718540898574744346660736482590e-01 1.97174933098416939672437031561003e-03
 	 4.45376464915297476387934239028255e-01 5.45718540898574744346660736482590e-01 8.90499418612781569459802000210402e-03 1.97174933098416939672437031561003e-03
 	 8.90499418612781569459802000210402e-03 4.45376464915297476387934239028255e-01 5.45718540898574744346660736482590e-01 1.97174933098416939672437031561003e-03
 	 8.90499418612781569459802000210402e-03 5.45718540898574744346660736482590e-01 4.45376464915297476387934239028255e-01 1.97174933098416939672437031561003e-03
 	 5.45718540898574744346660736482590e-01 4.45376464915297476387934239028255e-01 8.90499418612781569459802000210402e-03 1.97174933098416939672437031561003e-03
 	 5.45718540898574744346660736482590e-01 8.90499418612781569459802000210402e-03 4.45376464915297476387934239028255e-01 1.97174933098416939672437031561003e-03
 	 1.52384002524315248505715203464206e-01 2.11597756303986755596624469433209e-03 8.45500019912644895647702014684910e-01 7.82666305439353175883721025485329e-04
 	 1.52384002524315248505715203464206e-01 8.45500019912644895647702014684910e-01 2.11597756303986755596624469433209e-03 7.82666305439353175883721025485329e-04
 	 2.11597756303986755596624469433209e-03 1.52384002524315248505715203464206e-01 8.45500019912644895647702014684910e-01 7.82666305439353175883721025485329e-04
 	 2.11597756303986755596624469433209e-03 8.45500019912644895647702014684910e-01 1.52384002524315248505715203464206e-01 7.82666305439353175883721025485329e-04
 	 8.45500019912644895647702014684910e-01 1.52384002524315248505715203464206e-01 2.11597756303986755596624469433209e-03 7.82666305439353175883721025485329e-04
 	 8.45500019912644895647702014684910e-01 2.11597756303986755596624469433209e-03 1.52384002524315248505715203464206e-01 7.82666305439353175883721025485329e-04
 	 3.97516610028231298645806646163692e-01 3.26127342913124992906936938652507e-03 5.99222116542637461833464840310626e-01 1.26469310239717006374982055660894e-03
 	 3.97516610028231298645806646163692e-01 5.99222116542637461833464840310626e-01 3.26127342913124992906936938652507e-03 1.26469310239717006374982055660894e-03
 	 3.26127342913124992906936938652507e-03 3.97516610028231298645806646163692e-01 5.99222116542637461833464840310626e-01 1.26469310239717006374982055660894e-03
 	 3.26127342913124992906936938652507e-03 5.99222116542637461833464840310626e-01 3.97516610028231298645806646163692e-01 1.26469310239717006374982055660894e-03
 	 5.99222116542637461833464840310626e-01 3.97516610028231298645806646163692e-01 3.26127342913124992906936938652507e-03 1.26469310239717006374982055660894e-03
 	 5.99222116542637461833464840310626e-01 3.26127342913124992906936938652507e-03 3.97516610028231298645806646163692e-01 1.26469310239717006374982055660894e-03
 	 1.56078769403476091959248606144683e-01 4.51678948131286547851281909515819e-02 7.98753335783395246316729298996506e-01 3.55725626090951096980319334761589e-03
 	 1.56078769403476091959248606144683e-01 7.98753335783395246316729298996506e-01 4.51678948131286547851281909515819e-02 3.55725626090951096980319334761589e-03
 	 4.51678948131286547851281909515819e-02 1.56078769403476091959248606144683e-01 7.98753335783395246316729298996506e-01 3.55725626090951096980319334761589e-03
 	 4.51678948131286547851281909515819e-02 7.98753335783395246316729298996506e-01 1.56078769403476091959248606144683e-01 3.55725626090951096980319334761589e-03
 	 7.98753335783395246316729298996506e-01 1.56078769403476091959248606144683e-01 4.51678948131286547851281909515819e-02 3.55725626090951096980319334761589e-03
 	 7.98753335783395246316729298996506e-01 4.51678948131286547851281909515819e-02 1.56078769403476091959248606144683e-01 3.55725626090951096980319334761589e-03
 	 1.97295676276558723527543293130293e-01 8.60602170575682987041510330072924e-03 7.94098302017684387621443420357537e-01 1.84283266317550493973431713357058e-03
 	 1.97295676276558723527543293130293e-01 7.94098302017684387621443420357537e-01 8.60602170575682987041510330072924e-03 1.84283266317550493973431713357058e-03
 	 8.60602170575682987041510330072924e-03 1.97295676276558723527543293130293e-01 7.94098302017684387621443420357537e-01 1.84283266317550493973431713357058e-03
 	 8.60602170575682987041510330072924e-03 7.94098302017684387621443420357537e-01 1.97295676276558723527543293130293e-01 1.84283266317550493973431713357058e-03
 	 7.94098302017684387621443420357537e-01 1.97295676276558723527543293130293e-01 8.60602170575682987041510330072924e-03 1.84283266317550493973431713357058e-03
 	 7.94098302017684387621443420357537e-01 8.60602170575682987041510330072924e-03 1.97295676276558723527543293130293e-01 1.84283266317550493973431713357058e-03
 	 5.00938368999261987579707522399985e-02 1.39743532515683617500901192443052e-02 9.35931809848505436022492176562082e-01 1.32897993565415819920694229239189e-03
 	 5.00938368999261987579707522399985e-02 9.35931809848505436022492176562082e-01 1.39743532515683617500901192443052e-02 1.32897993565415819920694229239189e-03
 	 1.39743532515683617500901192443052e-02 5.00938368999261987579707522399985e-02 9.35931809848505436022492176562082e-01 1.32897993565415819920694229239189e-03
 	 1.39743532515683617500901192443052e-02 9.35931809848505436022492176562082e-01 5.00938368999261987579707522399985e-02 1.32897993565415819920694229239189e-03
 	 9.35931809848505436022492176562082e-01 5.00938368999261987579707522399985e-02 1.39743532515683617500901192443052e-02 1.32897993565415819920694229239189e-03
 	 9.35931809848505436022492176562082e-01 1.39743532515683617500901192443052e-02 5.00938368999261987579707522399985e-02 1.32897993565415819920694229239189e-03
 	 2.98859063014319081830194591020700e-01 1.87471332499894505208004602536676e-01 5.13669604485786468472952037700452e-01 9.02341285510621995968882913530251e-03
 	 2.98859063014319081830194591020700e-01 5.13669604485786468472952037700452e-01 1.87471332499894505208004602536676e-01 9.02341285510621995968882913530251e-03
 	 1.87471332499894505208004602536676e-01 2.98859063014319081830194591020700e-01 5.13669604485786468472952037700452e-01 9.02341285510621995968882913530251e-03
 	 1.87471332499894505208004602536676e-01 5.13669604485786468472952037700452e-01 2.98859063014319081830194591020700e-01 9.02341285510621995968882913530251e-03
 	 5.13669604485786468472952037700452e-01 2.98859063014319081830194591020700e-01 1.87471332499894505208004602536676e-01 9.02341285510621995968882913530251e-03
 	 5.13669604485786468472952037700452e-01 1.87471332499894505208004602536676e-01 2.98859063014319081830194591020700e-01 9.02341285510621995968882913530251e-03
 	 3.34763343265331358988845522617339e-01 2.32722344075948522901242654370435e-01 4.32514312658720090354336207383312e-01 8.60550449408384668381621906974033e-03
 	 3.34763343265331358988845522617339e-01 4.32514312658720090354336207383312e-01 2.32722344075948522901242654370435e-01 8.60550449408384668381621906974033e-03
 	 2.32722344075948522901242654370435e-01 3.34763343265331358988845522617339e-01 4.32514312658720090354336207383312e-01 8.60550449408384668381621906974033e-03
 	 2.32722344075948522901242654370435e-01 4.32514312658720090354336207383312e-01 3.34763343265331358988845522617339e-01 8.60550449408384668381621906974033e-03
 	 4.32514312658720090354336207383312e-01 3.34763343265331358988845522617339e-01 2.32722344075948522901242654370435e-01 8.60550449408384668381621906974033e-03
 	 4.32514312658720090354336207383312e-01 2.32722344075948522901242654370435e-01 3.34763343265331358988845522617339e-01 8.60550449408384668381621906974033e-03
 	 2.09372824976375354610880208383605e-01 2.90018846146845241107392610047100e-02 7.61625290408940114339486626704456e-01 3.61046799699383212656211838975651e-03
 	 2.09372824976375354610880208383605e-01 7.61625290408940114339486626704456e-01 2.90018846146845241107392610047100e-02 3.61046799699383212656211838975651e-03
 	 2.90018846146845241107392610047100e-02 2.09372824976375354610880208383605e-01 7.61625290408940114339486626704456e-01 3.61046799699383212656211838975651e-03
 	 2.90018846146845241107392610047100e-02 7.61625290408940114339486626704456e-01 2.09372824976375354610880208383605e-01 3.61046799699383212656211838975651e-03
 	 7.61625290408940114339486626704456e-01 2.09372824976375354610880208383605e-01 2.90018846146845241107392610047100e-02 3.61046799699383212656211838975651e-03
 	 7.61625290408940114339486626704456e-01 2.90018846146845241107392610047100e-02 2.09372824976375354610880208383605e-01 3.61046799699383212656211838975651e-03
 	 1.06564744861383425833523119763413e-01 5.35674828677535283527610943110631e-02 8.39867772270863066630397497647209e-01 3.52356076721079599506358803751027e-03
 	 1.06564744861383425833523119763413e-01 8.39867772270863066630397497647209e-01 5.35674828677535283527610943110631e-02 3.52356076721079599506358803751027e-03
 	 5.35674828677535283527610943110631e-02 1.06564744861383425833523119763413e-01 8.39867772270863066630397497647209e-01 3.52356076721079599506358803751027e-03
 	 5.35674828677535283527610943110631e-02 8.39867772270863066630397497647209e-01 1.06564744861383425833523119763413e-01 3.52356076721079599506358803751027e-03
 	 8.39867772270863066630397497647209e-01 1.06564744861383425833523119763413e-01 5.35674828677535283527610943110631e-02 3.52356076721079599506358803751027e-03
 	 8.39867772270863066630397497647209e-01 5.35674828677535283527610943110631e-02 1.06564744861383425833523119763413e-01 3.52356076721079599506358803751027e-03
 	 3.21362627669543321484724174297298e-01 3.49619434914352376561619273331871e-03 6.75141177981313123090956196392654e-01 1.37807652200636543068923423049910e-03
 	 3.21362627669543321484724174297298e-01 6.75141177981313123090956196392654e-01 3.49619434914352376561619273331871e-03 1.37807652200636543068923423049910e-03
 	 3.49619434914352376561619273331871e-03 3.21362627669543321484724174297298e-01 6.75141177981313123090956196392654e-01 1.37807652200636543068923423049910e-03
 	 3.49619434914352376561619273331871e-03 6.75141177981313123090956196392654e-01 3.21362627669543321484724174297298e-01 1.37807652200636543068923423049910e-03
 	 6.75141177981313123090956196392654e-01 3.21362627669543321484724174297298e-01 3.49619434914352376561619273331871e-03 1.37807652200636543068923423049910e-03
 	 6.75141177981313123090956196392654e-01 3.49619434914352376561619273331871e-03 3.21362627669543321484724174297298e-01 1.37807652200636543068923423049910e-03
 	 2.41587026347987537944206337670039e-01 1.17604279684175661371825505341349e-03 7.57236930855170631282646809268044e-01 6.95029585951856482620159205509935e-04
 	 2.41587026347987537944206337670039e-01 7.57236930855170631282646809268044e-01 1.17604279684175661371825505341349e-03 6.95029585951856482620159205509935e-04
 	 1.17604279684175661371825505341349e-03 2.41587026347987537944206337670039e-01 7.57236930855170631282646809268044e-01 6.95029585951856482620159205509935e-04
 	 1.17604279684175661371825505341349e-03 7.57236930855170631282646809268044e-01 2.41587026347987537944206337670039e-01 6.95029585951856482620159205509935e-04
 	 7.57236930855170631282646809268044e-01 2.41587026347987537944206337670039e-01 1.17604279684175661371825505341349e-03 6.95029585951856482620159205509935e-04
 	 7.57236930855170631282646809268044e-01 1.17604279684175661371825505341349e-03 2.41587026347987537944206337670039e-01 6.95029585951856482620159205509935e-04
 	 3.33153099720764844793308157022693e-01 1.13953928744148377805167626775074e-01 5.52892971535086874546038870903431e-01 8.12972059807798991259986109980673e-03
 	 3.33153099720764844793308157022693e-01 5.52892971535086874546038870903431e-01 1.13953928744148377805167626775074e-01 8.12972059807798991259986109980673e-03
 	 1.13953928744148377805167626775074e-01 3.33153099720764844793308157022693e-01 5.52892971535086874546038870903431e-01 8.12972059807798991259986109980673e-03
 	 1.13953928744148377805167626775074e-01 5.52892971535086874546038870903431e-01 3.33153099720764844793308157022693e-01 8.12972059807798991259986109980673e-03
 	 5.52892971535086874546038870903431e-01 3.33153099720764844793308157022693e-01 1.13953928744148377805167626775074e-01 8.12972059807798991259986109980673e-03
 	 5.52892971535086874546038870903431e-01 1.13953928744148377805167626775074e-01 3.33153099720764844793308157022693e-01 8.12972059807798991259986109980673e-03
 	 1.55116554813303442195149273175048e-01 8.49385995115550379574997919007728e-02 7.59944845675141533725138742738636e-01 5.48965635986670662249675700650187e-03
 	 1.55116554813303442195149273175048e-01 7.59944845675141533725138742738636e-01 8.49385995115550379574997919007728e-02 5.48965635986670662249675700650187e-03
 	 8.49385995115550379574997919007728e-02 1.55116554813303442195149273175048e-01 7.59944845675141533725138742738636e-01 5.48965635986670662249675700650187e-03
 	 8.49385995115550379574997919007728e-02 7.59944845675141533725138742738636e-01 1.55116554813303442195149273175048e-01 5.48965635986670662249675700650187e-03
 	 7.59944845675141533725138742738636e-01 1.55116554813303442195149273175048e-01 8.49385995115550379574997919007728e-02 5.48965635986670662249675700650187e-03
 	 7.59944845675141533725138742738636e-01 8.49385995115550379574997919007728e-02 1.55116554813303442195149273175048e-01 5.48965635986670662249675700650187e-03
 	 3.71014151677461878620079005486332e-01 1.52565186347216358297984584169171e-01 4.76420661975321735326360794715583e-01 8.23598732285824898513570957447882e-03
 	 3.71014151677461878620079005486332e-01 4.76420661975321735326360794715583e-01 1.52565186347216358297984584169171e-01 8.23598732285824898513570957447882e-03
 	 1.52565186347216358297984584169171e-01 3.71014151677461878620079005486332e-01 4.76420661975321735326360794715583e-01 8.23598732285824898513570957447882e-03
 	 1.52565186347216358297984584169171e-01 4.76420661975321735326360794715583e-01 3.71014151677461878620079005486332e-01 8.23598732285824898513570957447882e-03
 	 4.76420661975321735326360794715583e-01 3.71014151677461878620079005486332e-01 1.52565186347216358297984584169171e-01 8.23598732285824898513570957447882e-03
 	 4.76420661975321735326360794715583e-01 1.52565186347216358297984584169171e-01 3.71014151677461878620079005486332e-01 8.23598732285824898513570957447882e-03
 	 2.70883661807772069263222647350631e-01 1.36186781090766283186521690140580e-02 7.15497660083151298948678231681697e-01 2.77977351936256698167193590620627e-03
 	 2.70883661807772069263222647350631e-01 7.15497660083151298948678231681697e-01 1.36186781090766283186521690140580e-02 2.77977351936256698167193590620627e-03
 	 1.36186781090766283186521690140580e-02 2.70883661807772069263222647350631e-01 7.15497660083151298948678231681697e-01 2.77977351936256698167193590620627e-03
 	 1.36186781090766283186521690140580e-02 7.15497660083151298948678231681697e-01 2.70883661807772069263222647350631e-01 2.77977351936256698167193590620627e-03
 	 7.15497660083151298948678231681697e-01 2.70883661807772069263222647350631e-01 1.36186781090766283186521690140580e-02 2.77977351936256698167193590620627e-03
 	 7.15497660083151298948678231681697e-01 1.36186781090766283186521690140580e-02 2.70883661807772069263222647350631e-01 2.77977351936256698167193590620627e-03
 	 3.52506748415466475421453651506454e-01 5.62263874435523919315116359030071e-02 5.91266864140981174280398136033909e-01 6.33178188148339569224498646349275e-03
 	 3.52506748415466475421453651506454e-01 5.91266864140981174280398136033909e-01 5.62263874435523919315116359030071e-02 6.33178188148339569224498646349275e-03
 	 5.62263874435523919315116359030071e-02 3.52506748415466475421453651506454e-01 5.91266864140981174280398136033909e-01 6.33178188148339569224498646349275e-03
 	 5.62263874435523919315116359030071e-02 5.91266864140981174280398136033909e-01 3.52506748415466475421453651506454e-01 6.33178188148339569224498646349275e-03
 	 5.91266864140981174280398136033909e-01 3.52506748415466475421453651506454e-01 5.62263874435523919315116359030071e-02 6.33178188148339569224498646349275e-03
 	 5.91266864140981174280398136033909e-01 5.62263874435523919315116359030071e-02 3.52506748415466475421453651506454e-01 6.33178188148339569224498646349275e-03
 	 4.05720132778190467615075931462343e-01 8.17534894396882150235938979676575e-02 5.12526377782121289605754554941086e-01 6.94571071994158455165102594719428e-03
 	 4.05720132778190467615075931462343e-01 5.12526377782121289605754554941086e-01 8.17534894396882150235938979676575e-02 6.94571071994158455165102594719428e-03
 	 8.17534894396882150235938979676575e-02 4.05720132778190467615075931462343e-01 5.12526377782121289605754554941086e-01 6.94571071994158455165102594719428e-03
 	 8.17534894396882150235938979676575e-02 5.12526377782121289605754554941086e-01 4.05720132778190467615075931462343e-01 6.94571071994158455165102594719428e-03
 	 5.12526377782121289605754554941086e-01 4.05720132778190467615075931462343e-01 8.17534894396882150235938979676575e-02 6.94571071994158455165102594719428e-03
 	 5.12526377782121289605754554941086e-01 8.17534894396882150235938979676575e-02 4.05720132778190467615075931462343e-01 6.94571071994158455165102594719428e-03
 	 2.18949681014998343009381187584950e-01 6.36424301897473843059316322978702e-02 7.17407888795254300440262795746094e-01 5.56594111568608964496496227525313e-03
 	 2.18949681014998343009381187584950e-01 7.17407888795254300440262795746094e-01 6.36424301897473843059316322978702e-02 5.56594111568608964496496227525313e-03
 	 6.36424301897473843059316322978702e-02 2.18949681014998343009381187584950e-01 7.17407888795254300440262795746094e-01 5.56594111568608964496496227525313e-03
 	 6.36424301897473843059316322978702e-02 7.17407888795254300440262795746094e-01 2.18949681014998343009381187584950e-01 5.56594111568608964496496227525313e-03
 	 7.17407888795254300440262795746094e-01 2.18949681014998343009381187584950e-01 6.36424301897473843059316322978702e-02 5.56594111568608964496496227525313e-03
 	 7.17407888795254300440262795746094e-01 6.36424301897473843059316322978702e-02 2.18949681014998343009381187584950e-01 5.56594111568608964496496227525313e-03
 	 2.06709248085564512020795291391551e-01 1.15394220836074104519219929443352e-01 6.77896531078361341826621355721727e-01 7.33761015676267537577448507590816e-03
 	 2.06709248085564512020795291391551e-01 6.77896531078361341826621355721727e-01 1.15394220836074104519219929443352e-01 7.33761015676267537577448507590816e-03
 	 1.15394220836074104519219929443352e-01 2.06709248085564512020795291391551e-01 6.77896531078361341826621355721727e-01 7.33761015676267537577448507590816e-03
 	 1.15394220836074104519219929443352e-01 6.77896531078361341826621355721727e-01 2.06709248085564512020795291391551e-01 7.33761015676267537577448507590816e-03
 	 6.77896531078361341826621355721727e-01 2.06709248085564512020795291391551e-01 1.15394220836074104519219929443352e-01 7.33761015676267537577448507590816e-03
 	 6.77896531078361341826621355721727e-01 1.15394220836074104519219929443352e-01 2.06709248085564512020795291391551e-01 7.33761015676267537577448507590816e-03
 	 2.56601087879092248922319186021923e-01 1.48187116283310715836307736026356e-01 5.95211795837596979730221846693894e-01 8.71142662356086568131718905760863e-03
 	 2.56601087879092248922319186021923e-01 5.95211795837596979730221846693894e-01 1.48187116283310715836307736026356e-01 8.71142662356086568131718905760863e-03
 	 1.48187116283310715836307736026356e-01 2.56601087879092248922319186021923e-01 5.95211795837596979730221846693894e-01 8.71142662356086568131718905760863e-03
 	 1.48187116283310715836307736026356e-01 5.95211795837596979730221846693894e-01 2.56601087879092248922319186021923e-01 8.71142662356086568131718905760863e-03
 	 5.95211795837596979730221846693894e-01 2.56601087879092248922319186021923e-01 1.48187116283310715836307736026356e-01 8.71142662356086568131718905760863e-03
 	 5.95211795837596979730221846693894e-01 1.48187116283310715836307736026356e-01 2.56601087879092248922319186021923e-01 8.71142662356086568131718905760863e-03
 	 1.38206295211249968746258787177794e-01 1.85978710613813984220410446823735e-02 8.43195833727368615484465408371761e-01 2.73674943272201763241890937194967e-03
 	 1.38206295211249968746258787177794e-01 8.43195833727368615484465408371761e-01 1.85978710613813984220410446823735e-02 2.73674943272201763241890937194967e-03
 	 1.85978710613813984220410446823735e-02 1.38206295211249968746258787177794e-01 8.43195833727368615484465408371761e-01 2.73674943272201763241890937194967e-03
 	 1.85978710613813984220410446823735e-02 8.43195833727368615484465408371761e-01 1.38206295211249968746258787177794e-01 2.73674943272201763241890937194967e-03
 	 8.43195833727368615484465408371761e-01 1.38206295211249968746258787177794e-01 1.85978710613813984220410446823735e-02 2.73674943272201763241890937194967e-03
 	 8.43195833727368615484465408371761e-01 1.85978710613813984220410446823735e-02 1.38206295211249968746258787177794e-01 2.73674943272201763241890937194967e-03
 	 4.25810208585481020371332760987571e-01 3.29710199269463780091804494531971e-02 5.41218771487572580802805077837547e-01 4.70165758093218141139280064066952e-03
 	 4.25810208585481020371332760987571e-01 5.41218771487572580802805077837547e-01 3.29710199269463780091804494531971e-02 4.70165758093218141139280064066952e-03
 	 3.29710199269463780091804494531971e-02 4.25810208585481020371332760987571e-01 5.41218771487572580802805077837547e-01 4.70165758093218141139280064066952e-03
 	 3.29710199269463780091804494531971e-02 5.41218771487572580802805077837547e-01 4.25810208585481020371332760987571e-01 4.70165758093218141139280064066952e-03
 	 5.41218771487572580802805077837547e-01 4.25810208585481020371332760987571e-01 3.29710199269463780091804494531971e-02 4.70165758093218141139280064066952e-03
 	 5.41218771487572580802805077837547e-01 3.29710199269463780091804494531971e-02 4.25810208585481020371332760987571e-01 4.70165758093218141139280064066952e-03
 	 2.79725926952240189216070120892255e-01 8.53795515729538628812989031757752e-02 6.34894521474805961780418783746427e-01 7.17500895993271325945528360534809e-03
 	 2.79725926952240189216070120892255e-01 6.34894521474805961780418783746427e-01 8.53795515729538628812989031757752e-02 7.17500895993271325945528360534809e-03
 	 8.53795515729538628812989031757752e-02 2.79725926952240189216070120892255e-01 6.34894521474805961780418783746427e-01 7.17500895993271325945528360534809e-03
 	 8.53795515729538628812989031757752e-02 6.34894521474805961780418783746427e-01 2.79725926952240189216070120892255e-01 7.17500895993271325945528360534809e-03
 	 6.34894521474805961780418783746427e-01 2.79725926952240189216070120892255e-01 8.53795515729538628812989031757752e-02 7.17500895993271325945528360534809e-03
 	 6.34894521474805961780418783746427e-01 8.53795515729538628812989031757752e-02 2.79725926952240189216070120892255e-01 7.17500895993271325945528360534809e-03
 	 2.24666835802111858333418581423757e-02 3.63305584293396573516976566509129e-03 9.73900260576854859273510101047577e-01 4.73246973800488896985672049311233e-04
 	 2.24666835802111858333418581423757e-02 9.73900260576854859273510101047577e-01 3.63305584293396573516976566509129e-03 4.73246973800488896985672049311233e-04
 	 3.63305584293396573516976566509129e-03 2.24666835802111858333418581423757e-02 9.73900260576854859273510101047577e-01 4.73246973800488896985672049311233e-04
 	 3.63305584293396573516976566509129e-03 9.73900260576854859273510101047577e-01 2.24666835802111858333418581423757e-02 4.73246973800488896985672049311233e-04
 	 9.73900260576854859273510101047577e-01 2.24666835802111858333418581423757e-02 3.63305584293396573516976566509129e-03 4.73246973800488896985672049311233e-04
 	 9.73900260576854859273510101047577e-01 3.63305584293396573516976566509129e-03 2.24666835802111858333418581423757e-02 4.73246973800488896985672049311233e-04
 	 8.38622585244554186179044563687057e-02 2.60200776623639613849281460034035e-02 8.90117663813180692855553388653789e-01 2.53466211136778004145431175686554e-03
 	 8.38622585244554186179044563687057e-02 8.90117663813180692855553388653789e-01 2.60200776623639613849281460034035e-02 2.53466211136778004145431175686554e-03
 	 2.60200776623639613849281460034035e-02 8.38622585244554186179044563687057e-02 8.90117663813180692855553388653789e-01 2.53466211136778004145431175686554e-03
 	 2.60200776623639613849281460034035e-02 8.90117663813180692855553388653789e-01 8.38622585244554186179044563687057e-02 2.53466211136778004145431175686554e-03
 	 8.90117663813180692855553388653789e-01 8.38622585244554186179044563687057e-02 2.60200776623639613849281460034035e-02 2.53466211136778004145431175686554e-03
 	 8.90117663813180692855553388653789e-01 2.60200776623639613849281460034035e-02 8.38622585244554186179044563687057e-02 2.53466211136778004145431175686554e-03
 	 2.84800346414468275035858368937625e-01 3.94569261564381226770059640784893e-02 6.75742727429093581470453955262201e-01 5.07015730001139641736074281652691e-03
 	 2.84800346414468275035858368937625e-01 6.75742727429093581470453955262201e-01 3.94569261564381226770059640784893e-02 5.07015730001139641736074281652691e-03
 	 3.94569261564381226770059640784893e-02 2.84800346414468275035858368937625e-01 6.75742727429093581470453955262201e-01 5.07015730001139641736074281652691e-03
 	 3.94569261564381226770059640784893e-02 6.75742727429093581470453955262201e-01 2.84800346414468275035858368937625e-01 5.07015730001139641736074281652691e-03
 	 6.75742727429093581470453955262201e-01 2.84800346414468275035858368937625e-01 3.94569261564381226770059640784893e-02 5.07015730001139641736074281652691e-03
 	 6.75742727429093581470453955262201e-01 3.94569261564381226770059640784893e-02 2.84800346414468275035858368937625e-01 5.07015730001139641736074281652691e-03
 	 3.56594103536573836521483826800250e-01 1.97707177044081881811532497295048e-02 6.23635178759017971827915971516632e-01 4.05407208688402312390941517605825e-03
 	 3.56594103536573836521483826800250e-01 6.23635178759017971827915971516632e-01 1.97707177044081881811532497295048e-02 4.05407208688402312390941517605825e-03
 	 1.97707177044081881811532497295048e-02 3.56594103536573836521483826800250e-01 6.23635178759017971827915971516632e-01 4.05407208688402312390941517605825e-03
 	 1.97707177044081881811532497295048e-02 6.23635178759017971827915971516632e-01 3.56594103536573836521483826800250e-01 4.05407208688402312390941517605825e-03
 	 6.23635178759017971827915971516632e-01 3.56594103536573836521483826800250e-01 1.97707177044081881811532497295048e-02 4.05407208688402312390941517605825e-03
 	 6.23635178759017971827915971516632e-01 1.97707177044081881811532497295048e-02 3.56594103536573836521483826800250e-01 4.05407208688402312390941517605825e-03
 	 9.74242311151380380174202855414478e-02 5.02869741562738704898638530949029e-03 8.97547071469234514218271669960814e-01 1.25447838724101622294437863303074e-03
 	 9.74242311151380380174202855414478e-02 8.97547071469234514218271669960814e-01 5.02869741562738704898638530949029e-03 1.25447838724101622294437863303074e-03
 	 5.02869741562738704898638530949029e-03 9.74242311151380380174202855414478e-02 8.97547071469234514218271669960814e-01 1.25447838724101622294437863303074e-03
 	 5.02869741562738704898638530949029e-03 8.97547071469234514218271669960814e-01 9.74242311151380380174202855414478e-02 1.25447838724101622294437863303074e-03
 	 8.97547071469234514218271669960814e-01 9.74242311151380380174202855414478e-02 5.02869741562738704898638530949029e-03 1.25447838724101622294437863303074e-03
 	 8.97547071469234514218271669960814e-01 5.02869741562738704898638530949029e-03 9.74242311151380380174202855414478e-02 1.25447838724101622294437863303074e-03
 	 ];
 
 	 case  36 

 	 % ALG. DEG.:   36
 	 % PTS CARD.:  243
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.2e-15  

 	 xyw_bar=[
 	 4.12357340313630305050907054464915e-01 4.12357340313630305050907054464915e-01 1.75285319372739389898185891070170e-01 7.67049451790863343753068548380725e-03
 	 4.12357340313630305050907054464915e-01 1.75285319372739389898185891070170e-01 4.12357340313630305050907054464915e-01 7.67049451790863343753068548380725e-03
 	 1.75285319372739389898185891070170e-01 4.12357340313630305050907054464915e-01 4.12357340313630305050907054464915e-01 7.67049451790863343753068548380725e-03
 	 4.39048383245843498734473087097285e-01 4.39048383245843498734473087097285e-01 1.21903233508313002531053825805429e-01 6.87629570939615394897792555184424e-03
 	 4.39048383245843498734473087097285e-01 1.21903233508313002531053825805429e-01 4.39048383245843498734473087097285e-01 6.87629570939615394897792555184424e-03
 	 1.21903233508313002531053825805429e-01 4.39048383245843498734473087097285e-01 4.39048383245843498734473087097285e-01 6.87629570939615394897792555184424e-03
 	 2.35052325458213695608122861813172e-01 2.35052325458213695608122861813172e-01 5.29895349083572608783754276373656e-01 8.06799771663824390188768376219741e-03
 	 2.35052325458213695608122861813172e-01 5.29895349083572608783754276373656e-01 2.35052325458213695608122861813172e-01 8.06799771663824390188768376219741e-03
 	 5.29895349083572608783754276373656e-01 2.35052325458213695608122861813172e-01 2.35052325458213695608122861813172e-01 8.06799771663824390188768376219741e-03
 	 1.50821734779891525324302392618847e-01 1.50821734779891525324302392618847e-01 6.98356530440216949351395214762306e-01 6.17106068145151925863345354628109e-03
 	 1.50821734779891525324302392618847e-01 6.98356530440216949351395214762306e-01 1.50821734779891525324302392618847e-01 6.17106068145151925863345354628109e-03
 	 6.98356530440216949351395214762306e-01 1.50821734779891525324302392618847e-01 1.50821734779891525324302392618847e-01 6.17106068145151925863345354628109e-03
 	 4.64273777634669981839721231153817e-01 4.64273777634669981839721231153817e-01 7.14524447306600363205575376923662e-02 6.66123362124754377078250655586089e-03
 	 4.64273777634669981839721231153817e-01 7.14524447306600363205575376923662e-02 4.64273777634669981839721231153817e-01 6.66123362124754377078250655586089e-03
 	 7.14524447306600363205575376923662e-02 4.64273777634669981839721231153817e-01 4.64273777634669981839721231153817e-01 6.66123362124754377078250655586089e-03
 	 1.91161361877308921819462739222217e-01 1.91161361877308921819462739222217e-01 6.17677276245382156361074521555565e-01 8.09322507568908597330725740448543e-03
 	 1.91161361877308921819462739222217e-01 6.17677276245382156361074521555565e-01 1.91161361877308921819462739222217e-01 8.09322507568908597330725740448543e-03
 	 6.17677276245382156361074521555565e-01 1.91161361877308921819462739222217e-01 1.91161361877308921819462739222217e-01 8.09322507568908597330725740448543e-03
 	 2.93500490934269150922197866293573e-02 2.93500490934269150922197866293573e-02 9.41299901813146155937772618926829e-01 1.56742371115087416287570132311657e-03
 	 2.93500490934269150922197866293573e-02 9.41299901813146155937772618926829e-01 2.93500490934269150922197866293573e-02 1.56742371115087416287570132311657e-03
 	 9.41299901813146155937772618926829e-01 2.93500490934269150922197866293573e-02 2.93500490934269150922197866293573e-02 1.56742371115087416287570132311657e-03
 	 3.08145218991093261529101710038958e-01 3.08145218991093261529101710038958e-01 3.83709562017813476941796579922084e-01 1.10082761617136277304540570298741e-02
 	 3.08145218991093261529101710038958e-01 3.83709562017813476941796579922084e-01 3.08145218991093261529101710038958e-01 1.10082761617136277304540570298741e-02
 	 3.83709562017813476941796579922084e-01 3.08145218991093261529101710038958e-01 3.08145218991093261529101710038958e-01 1.10082761617136277304540570298741e-02
 	 1.11178264788380914973586754967982e-01 1.11178264788380914973586754967982e-01 7.77643470423238225563977721321862e-01 5.42354892413257280714411479038972e-03
 	 1.11178264788380914973586754967982e-01 7.77643470423238225563977721321862e-01 1.11178264788380914973586754967982e-01 5.42354892413257280714411479038972e-03
 	 7.77643470423238225563977721321862e-01 1.11178264788380914973586754967982e-01 1.11178264788380914973586754967982e-01 5.42354892413257280714411479038972e-03
 	 3.81002349603441869962949795080931e-01 3.81002349603441869962949795080931e-01 2.37995300793116260074100409838138e-01 1.05063460068171125871838711418604e-02
 	 3.81002349603441869962949795080931e-01 2.37995300793116260074100409838138e-01 3.81002349603441869962949795080931e-01 1.05063460068171125871838711418604e-02
 	 2.37995300793116260074100409838138e-01 3.81002349603441869962949795080931e-01 3.81002349603441869962949795080931e-01 1.05063460068171125871838711418604e-02
 	 4.94480996747700407567549518716987e-01 4.94480996747700407567549518716987e-01 1.10380065045991848649009625660256e-02 2.89591576346856722015687957139107e-03
 	 4.94480996747700407567549518716987e-01 1.10380065045991848649009625660256e-02 4.94480996747700407567549518716987e-01 2.89591576346856722015687957139107e-03
 	 1.10380065045991848649009625660256e-02 4.94480996747700407567549518716987e-01 4.94480996747700407567549518716987e-01 2.89591576346856722015687957139107e-03
 	 2.55002336075419500094341174190049e-01 3.22922639737693653594341469670326e-02 7.12705399950811169240694198379060e-01 3.06168316706818127714839761210897e-03
 	 2.55002336075419500094341174190049e-01 7.12705399950811169240694198379060e-01 3.22922639737693653594341469670326e-02 3.06168316706818127714839761210897e-03
 	 3.22922639737693653594341469670326e-02 2.55002336075419500094341174190049e-01 7.12705399950811169240694198379060e-01 3.06168316706818127714839761210897e-03
 	 3.22922639737693653594341469670326e-02 7.12705399950811169240694198379060e-01 2.55002336075419500094341174190049e-01 3.06168316706818127714839761210897e-03
 	 7.12705399950811169240694198379060e-01 2.55002336075419500094341174190049e-01 3.22922639737693653594341469670326e-02 3.06168316706818127714839761210897e-03
 	 7.12705399950811169240694198379060e-01 3.22922639737693653594341469670326e-02 2.55002336075419500094341174190049e-01 3.06168316706818127714839761210897e-03
 	 2.71121513603339969744610016277875e-01 9.41402098044081675487504412558337e-02 6.34738276592251793317700503394008e-01 4.92327197529004913917338726037087e-03
 	 2.71121513603339969744610016277875e-01 6.34738276592251793317700503394008e-01 9.41402098044081675487504412558337e-02 4.92327197529004913917338726037087e-03
 	 9.41402098044081675487504412558337e-02 2.71121513603339969744610016277875e-01 6.34738276592251793317700503394008e-01 4.92327197529004913917338726037087e-03
 	 9.41402098044081675487504412558337e-02 6.34738276592251793317700503394008e-01 2.71121513603339969744610016277875e-01 4.92327197529004913917338726037087e-03
 	 6.34738276592251793317700503394008e-01 2.71121513603339969744610016277875e-01 9.41402098044081675487504412558337e-02 4.92327197529004913917338726037087e-03
 	 6.34738276592251793317700503394008e-01 9.41402098044081675487504412558337e-02 2.71121513603339969744610016277875e-01 4.92327197529004913917338726037087e-03
 	 9.26886044848755363823045172466664e-02 6.49936721042402160142259504027606e-02 8.42317723410884178214530493278289e-01 3.32372084339523391968707066723709e-03
 	 9.26886044848755363823045172466664e-02 8.42317723410884178214530493278289e-01 6.49936721042402160142259504027606e-02 3.32372084339523391968707066723709e-03
 	 6.49936721042402160142259504027606e-02 9.26886044848755363823045172466664e-02 8.42317723410884178214530493278289e-01 3.32372084339523391968707066723709e-03
 	 6.49936721042402160142259504027606e-02 8.42317723410884178214530493278289e-01 9.26886044848755363823045172466664e-02 3.32372084339523391968707066723709e-03
 	 8.42317723410884178214530493278289e-01 9.26886044848755363823045172466664e-02 6.49936721042402160142259504027606e-02 3.32372084339523391968707066723709e-03
 	 8.42317723410884178214530493278289e-01 6.49936721042402160142259504027606e-02 9.26886044848755363823045172466664e-02 3.32372084339523391968707066723709e-03
 	 3.29454376584550512330196170296404e-01 7.37136644534187868149643918513902e-02 5.96831958962030673099263822223293e-01 4.74273649303375618296874094426130e-03
 	 3.29454376584550512330196170296404e-01 5.96831958962030673099263822223293e-01 7.37136644534187868149643918513902e-02 4.74273649303375618296874094426130e-03
 	 7.37136644534187868149643918513902e-02 3.29454376584550512330196170296404e-01 5.96831958962030673099263822223293e-01 4.74273649303375618296874094426130e-03
 	 7.37136644534187868149643918513902e-02 5.96831958962030673099263822223293e-01 3.29454376584550512330196170296404e-01 4.74273649303375618296874094426130e-03
 	 5.96831958962030673099263822223293e-01 3.29454376584550512330196170296404e-01 7.37136644534187868149643918513902e-02 4.74273649303375618296874094426130e-03
 	 5.96831958962030673099263822223293e-01 7.37136644534187868149643918513902e-02 3.29454376584550512330196170296404e-01 4.74273649303375618296874094426130e-03
 	 2.88378841130442042928194723572233e-01 5.00649881468919338844969502133608e-02 6.61556170722666037065096134028863e-01 4.11380129264975018255068306416433e-03
 	 2.88378841130442042928194723572233e-01 6.61556170722666037065096134028863e-01 5.00649881468919338844969502133608e-02 4.11380129264975018255068306416433e-03
 	 5.00649881468919338844969502133608e-02 2.88378841130442042928194723572233e-01 6.61556170722666037065096134028863e-01 4.11380129264975018255068306416433e-03
 	 5.00649881468919338844969502133608e-02 6.61556170722666037065096134028863e-01 2.88378841130442042928194723572233e-01 4.11380129264975018255068306416433e-03
 	 6.61556170722666037065096134028863e-01 2.88378841130442042928194723572233e-01 5.00649881468919338844969502133608e-02 4.11380129264975018255068306416433e-03
 	 6.61556170722666037065096134028863e-01 5.00649881468919338844969502133608e-02 2.88378841130442042928194723572233e-01 4.11380129264975018255068306416433e-03
 	 3.92172416405173862585797905921936e-01 6.58963384748946778834977067162981e-02 5.41931245119931404019553156103939e-01 5.23534252289378689709797853879536e-03
 	 3.92172416405173862585797905921936e-01 5.41931245119931404019553156103939e-01 6.58963384748946778834977067162981e-02 5.23534252289378689709797853879536e-03
 	 6.58963384748946778834977067162981e-02 3.92172416405173862585797905921936e-01 5.41931245119931404019553156103939e-01 5.23534252289378689709797853879536e-03
 	 6.58963384748946778834977067162981e-02 5.41931245119931404019553156103939e-01 3.92172416405173862585797905921936e-01 5.23534252289378689709797853879536e-03
 	 5.41931245119931404019553156103939e-01 3.92172416405173862585797905921936e-01 6.58963384748946778834977067162981e-02 5.23534252289378689709797853879536e-03
 	 5.41931245119931404019553156103939e-01 6.58963384748946778834977067162981e-02 3.92172416405173862585797905921936e-01 5.23534252289378689709797853879536e-03
 	 7.62225001558761768721828033790189e-03 1.23411852776327143031698252428896e-03 9.91143631456649187860818983608624e-01 1.30339928452650305988613776975171e-04
 	 7.62225001558761768721828033790189e-03 9.91143631456649187860818983608624e-01 1.23411852776327143031698252428896e-03 1.30339928452650305988613776975171e-04
 	 1.23411852776327143031698252428896e-03 7.62225001558761768721828033790189e-03 9.91143631456649187860818983608624e-01 1.30339928452650305988613776975171e-04
 	 1.23411852776327143031698252428896e-03 9.91143631456649187860818983608624e-01 7.62225001558761768721828033790189e-03 1.30339928452650305988613776975171e-04
 	 9.91143631456649187860818983608624e-01 7.62225001558761768721828033790189e-03 1.23411852776327143031698252428896e-03 1.30339928452650305988613776975171e-04
 	 9.91143631456649187860818983608624e-01 1.23411852776327143031698252428896e-03 7.62225001558761768721828033790189e-03 1.30339928452650305988613776975171e-04
 	 1.78207936627975682686297886903048e-01 1.05695827327609861989721196096070e-01 7.16096236044414524712919956073165e-01 5.22770428393836208980083313235809e-03
 	 1.78207936627975682686297886903048e-01 7.16096236044414524712919956073165e-01 1.05695827327609861989721196096070e-01 5.22770428393836208980083313235809e-03
 	 1.05695827327609861989721196096070e-01 1.78207936627975682686297886903048e-01 7.16096236044414524712919956073165e-01 5.22770428393836208980083313235809e-03
 	 1.05695827327609861989721196096070e-01 7.16096236044414524712919956073165e-01 1.78207936627975682686297886903048e-01 5.22770428393836208980083313235809e-03
 	 7.16096236044414524712919956073165e-01 1.78207936627975682686297886903048e-01 1.05695827327609861989721196096070e-01 5.22770428393836208980083313235809e-03
 	 7.16096236044414524712919956073165e-01 1.05695827327609861989721196096070e-01 1.78207936627975682686297886903048e-01 5.22770428393836208980083313235809e-03
 	 3.10248931459913612762591128557688e-01 1.23871670395550900756198586805112e-01 5.65879398144535472603422476822743e-01 6.63113754154853653893786358253237e-03
 	 3.10248931459913612762591128557688e-01 5.65879398144535472603422476822743e-01 1.23871670395550900756198586805112e-01 6.63113754154853653893786358253237e-03
 	 1.23871670395550900756198586805112e-01 3.10248931459913612762591128557688e-01 5.65879398144535472603422476822743e-01 6.63113754154853653893786358253237e-03
 	 1.23871670395550900756198586805112e-01 5.65879398144535472603422476822743e-01 3.10248931459913612762591128557688e-01 6.63113754154853653893786358253237e-03
 	 5.65879398144535472603422476822743e-01 3.10248931459913612762591128557688e-01 1.23871670395550900756198586805112e-01 6.63113754154853653893786358253237e-03
 	 5.65879398144535472603422476822743e-01 1.23871670395550900756198586805112e-01 3.10248931459913612762591128557688e-01 6.63113754154853653893786358253237e-03
 	 8.29157021331251853357713343939395e-02 2.80739761856614068735726874592729e-03 9.14276900248308654894913161115255e-01 6.95234639717074213126346560187585e-04
 	 8.29157021331251853357713343939395e-02 9.14276900248308654894913161115255e-01 2.80739761856614068735726874592729e-03 6.95234639717074213126346560187585e-04
 	 2.80739761856614068735726874592729e-03 8.29157021331251853357713343939395e-02 9.14276900248308654894913161115255e-01 6.95234639717074213126346560187585e-04
 	 2.80739761856614068735726874592729e-03 9.14276900248308654894913161115255e-01 8.29157021331251853357713343939395e-02 6.95234639717074213126346560187585e-04
 	 9.14276900248308654894913161115255e-01 8.29157021331251853357713343939395e-02 2.80739761856614068735726874592729e-03 6.95234639717074213126346560187585e-04
 	 9.14276900248308654894913161115255e-01 2.80739761856614068735726874592729e-03 8.29157021331251853357713343939395e-02 6.95234639717074213126346560187585e-04
 	 3.79638679346943119785606768346042e-01 1.10689778326021240340004681002029e-01 5.09671542327035709263327589724213e-01 6.91837248739255328972008740606725e-03
 	 3.79638679346943119785606768346042e-01 5.09671542327035709263327589724213e-01 1.10689778326021240340004681002029e-01 6.91837248739255328972008740606725e-03
 	 1.10689778326021240340004681002029e-01 3.79638679346943119785606768346042e-01 5.09671542327035709263327589724213e-01 6.91837248739255328972008740606725e-03
 	 1.10689778326021240340004681002029e-01 5.09671542327035709263327589724213e-01 3.79638679346943119785606768346042e-01 6.91837248739255328972008740606725e-03
 	 5.09671542327035709263327589724213e-01 3.79638679346943119785606768346042e-01 1.10689778326021240340004681002029e-01 6.91837248739255328972008740606725e-03
 	 5.09671542327035709263327589724213e-01 1.10689778326021240340004681002029e-01 3.79638679346943119785606768346042e-01 6.91837248739255328972008740606725e-03
 	 1.98068292114543353932276659179479e-01 2.75642261370565543054933499433901e-03 7.99175285271750968085768818127690e-01 1.01770684935491642630900344101974e-03
 	 1.98068292114543353932276659179479e-01 7.99175285271750968085768818127690e-01 2.75642261370565543054933499433901e-03 1.01770684935491642630900344101974e-03
 	 2.75642261370565543054933499433901e-03 1.98068292114543353932276659179479e-01 7.99175285271750968085768818127690e-01 1.01770684935491642630900344101974e-03
 	 2.75642261370565543054933499433901e-03 7.99175285271750968085768818127690e-01 1.98068292114543353932276659179479e-01 1.01770684935491642630900344101974e-03
 	 7.99175285271750968085768818127690e-01 1.98068292114543353932276659179479e-01 2.75642261370565543054933499433901e-03 1.01770684935491642630900344101974e-03
 	 7.99175285271750968085768818127690e-01 2.75642261370565543054933499433901e-03 1.98068292114543353932276659179479e-01 1.01770684935491642630900344101974e-03
 	 1.47947945322073032281551263622532e-01 7.20516990960159003920537656995293e-02 7.80000355581911053448607162863482e-01 4.53099129706453773724916800347273e-03
 	 1.47947945322073032281551263622532e-01 7.80000355581911053448607162863482e-01 7.20516990960159003920537656995293e-02 4.53099129706453773724916800347273e-03
 	 7.20516990960159003920537656995293e-02 1.47947945322073032281551263622532e-01 7.80000355581911053448607162863482e-01 4.53099129706453773724916800347273e-03
 	 7.20516990960159003920537656995293e-02 7.80000355581911053448607162863482e-01 1.47947945322073032281551263622532e-01 4.53099129706453773724916800347273e-03
 	 7.80000355581911053448607162863482e-01 1.47947945322073032281551263622532e-01 7.20516990960159003920537656995293e-02 4.53099129706453773724916800347273e-03
 	 7.80000355581911053448607162863482e-01 7.20516990960159003920537656995293e-02 1.47947945322073032281551263622532e-01 4.53099129706453773724916800347273e-03
 	 2.29202766553467329746496261577704e-01 1.44286115706842923978037163124100e-02 7.56368621875848412550169541646028e-01 2.37928049563856979300990879266919e-03
 	 2.29202766553467329746496261577704e-01 7.56368621875848412550169541646028e-01 1.44286115706842923978037163124100e-02 2.37928049563856979300990879266919e-03
 	 1.44286115706842923978037163124100e-02 2.29202766553467329746496261577704e-01 7.56368621875848412550169541646028e-01 2.37928049563856979300990879266919e-03
 	 1.44286115706842923978037163124100e-02 7.56368621875848412550169541646028e-01 2.29202766553467329746496261577704e-01 2.37928049563856979300990879266919e-03
 	 7.56368621875848412550169541646028e-01 2.29202766553467329746496261577704e-01 1.44286115706842923978037163124100e-02 2.37928049563856979300990879266919e-03
 	 7.56368621875848412550169541646028e-01 1.44286115706842923978037163124100e-02 2.29202766553467329746496261577704e-01 2.37928049563856979300990879266919e-03
 	 3.57473850344384502797367986204335e-01 2.74256669741186880767669364900030e-03 6.39783582958203589363677110668505e-01 1.21687910970544126663950290634375e-03
 	 3.57473850344384502797367986204335e-01 6.39783582958203589363677110668505e-01 2.74256669741186880767669364900030e-03 1.21687910970544126663950290634375e-03
 	 2.74256669741186880767669364900030e-03 3.57473850344384502797367986204335e-01 6.39783582958203589363677110668505e-01 1.21687910970544126663950290634375e-03
 	 2.74256669741186880767669364900030e-03 6.39783582958203589363677110668505e-01 3.57473850344384502797367986204335e-01 1.21687910970544126663950290634375e-03
 	 6.39783582958203589363677110668505e-01 3.57473850344384502797367986204335e-01 2.74256669741186880767669364900030e-03 1.21687910970544126663950290634375e-03
 	 6.39783582958203589363677110668505e-01 2.74256669741186880767669364900030e-03 3.57473850344384502797367986204335e-01 1.21687910970544126663950290634375e-03
 	 1.25249672229437725157197291991906e-01 3.90243298422159254346119894307776e-02 8.35725997928346342469296814670088e-01 3.11302724037831055406422287035184e-03
 	 1.25249672229437725157197291991906e-01 8.35725997928346342469296814670088e-01 3.90243298422159254346119894307776e-02 3.11302724037831055406422287035184e-03
 	 3.90243298422159254346119894307776e-02 1.25249672229437725157197291991906e-01 8.35725997928346342469296814670088e-01 3.11302724037831055406422287035184e-03
 	 3.90243298422159254346119894307776e-02 8.35725997928346342469296814670088e-01 1.25249672229437725157197291991906e-01 3.11302724037831055406422287035184e-03
 	 8.35725997928346342469296814670088e-01 1.25249672229437725157197291991906e-01 3.90243298422159254346119894307776e-02 3.11302724037831055406422287035184e-03
 	 8.35725997928346342469296814670088e-01 3.90243298422159254346119894307776e-02 1.25249672229437725157197291991906e-01 3.11302724037831055406422287035184e-03
 	 2.09805646004062387732780337046279e-02 7.47466346593332695708022939129478e-03 9.71544771933660511464836417871993e-01 6.48185332813125815280830277487212e-04
 	 2.09805646004062387732780337046279e-02 9.71544771933660511464836417871993e-01 7.47466346593332695708022939129478e-03 6.48185332813125815280830277487212e-04
 	 7.47466346593332695708022939129478e-03 2.09805646004062387732780337046279e-02 9.71544771933660511464836417871993e-01 6.48185332813125815280830277487212e-04
 	 7.47466346593332695708022939129478e-03 9.71544771933660511464836417871993e-01 2.09805646004062387732780337046279e-02 6.48185332813125815280830277487212e-04
 	 9.71544771933660511464836417871993e-01 2.09805646004062387732780337046279e-02 7.47466346593332695708022939129478e-03 6.48185332813125815280830277487212e-04
 	 9.71544771933660511464836417871993e-01 7.47466346593332695708022939129478e-03 2.09805646004062387732780337046279e-02 6.48185332813125815280830277487212e-04
 	 2.69131611744009735520677395470557e-01 1.75571778601519262741348370582273e-01 5.55296609654471029493549849576084e-01 8.34516474605456921864732322546843e-03
 	 2.69131611744009735520677395470557e-01 5.55296609654471029493549849576084e-01 1.75571778601519262741348370582273e-01 8.34516474605456921864732322546843e-03
 	 1.75571778601519262741348370582273e-01 2.69131611744009735520677395470557e-01 5.55296609654471029493549849576084e-01 8.34516474605456921864732322546843e-03
 	 1.75571778601519262741348370582273e-01 5.55296609654471029493549849576084e-01 2.69131611744009735520677395470557e-01 8.34516474605456921864732322546843e-03
 	 5.55296609654471029493549849576084e-01 2.69131611744009735520677395470557e-01 1.75571778601519262741348370582273e-01 8.34516474605456921864732322546843e-03
 	 5.55296609654471029493549849576084e-01 1.75571778601519262741348370582273e-01 2.69131611744009735520677395470557e-01 8.34516474605456921864732322546843e-03
 	 3.46219872421893559710781573812710e-01 1.71226758850752919238757954190078e-01 4.82553368727353548806036087626126e-01 8.90380284925181529620541454050908e-03
 	 3.46219872421893559710781573812710e-01 4.82553368727353548806036087626126e-01 1.71226758850752919238757954190078e-01 8.90380284925181529620541454050908e-03
 	 1.71226758850752919238757954190078e-01 3.46219872421893559710781573812710e-01 4.82553368727353548806036087626126e-01 8.90380284925181529620541454050908e-03
 	 1.71226758850752919238757954190078e-01 4.82553368727353548806036087626126e-01 3.46219872421893559710781573812710e-01 8.90380284925181529620541454050908e-03
 	 4.82553368727353548806036087626126e-01 3.46219872421893559710781573812710e-01 1.71226758850752919238757954190078e-01 8.90380284925181529620541454050908e-03
 	 4.82553368727353548806036087626126e-01 1.71226758850752919238757954190078e-01 3.46219872421893559710781573812710e-01 8.90380284925181529620541454050908e-03
 	 4.42387742658068516821145976791740e-01 3.43061434540936835424496109681058e-02 5.23306113887837875964237355219666e-01 4.76381396938828187426206994814493e-03
 	 4.42387742658068516821145976791740e-01 5.23306113887837875964237355219666e-01 3.43061434540936835424496109681058e-02 4.76381396938828187426206994814493e-03
 	 3.43061434540936835424496109681058e-02 4.42387742658068516821145976791740e-01 5.23306113887837875964237355219666e-01 4.76381396938828187426206994814493e-03
 	 3.43061434540936835424496109681058e-02 5.23306113887837875964237355219666e-01 4.42387742658068516821145976791740e-01 4.76381396938828187426206994814493e-03
 	 5.23306113887837875964237355219666e-01 4.42387742658068516821145976791740e-01 3.43061434540936835424496109681058e-02 4.76381396938828187426206994814493e-03
 	 5.23306113887837875964237355219666e-01 3.43061434540936835424496109681058e-02 4.42387742658068516821145976791740e-01 4.76381396938828187426206994814493e-03
 	 2.74633883722658844739328287687385e-01 3.02963551184710737362859589438813e-03 7.22336480765494060030107448255876e-01 1.23314349143744924133803131383047e-03
 	 2.74633883722658844739328287687385e-01 7.22336480765494060030107448255876e-01 3.02963551184710737362859589438813e-03 1.23314349143744924133803131383047e-03
 	 3.02963551184710737362859589438813e-03 2.74633883722658844739328287687385e-01 7.22336480765494060030107448255876e-01 1.23314349143744924133803131383047e-03
 	 3.02963551184710737362859589438813e-03 7.22336480765494060030107448255876e-01 2.74633883722658844739328287687385e-01 1.23314349143744924133803131383047e-03
 	 7.22336480765494060030107448255876e-01 2.74633883722658844739328287687385e-01 3.02963551184710737362859589438813e-03 1.23314349143744924133803131383047e-03
 	 7.22336480765494060030107448255876e-01 3.02963551184710737362859589438813e-03 2.74633883722658844739328287687385e-01 1.23314349143744924133803131383047e-03
 	 2.23701284655144105872892623665393e-01 7.24869584556441376443913782168238e-02 7.03811756889211825871655037190067e-01 5.28103623536607929417341367184235e-03
 	 2.23701284655144105872892623665393e-01 7.03811756889211825871655037190067e-01 7.24869584556441376443913782168238e-02 5.28103623536607929417341367184235e-03
 	 7.24869584556441376443913782168238e-02 2.23701284655144105872892623665393e-01 7.03811756889211825871655037190067e-01 5.28103623536607929417341367184235e-03
 	 7.24869584556441376443913782168238e-02 7.03811756889211825871655037190067e-01 2.23701284655144105872892623665393e-01 5.28103623536607929417341367184235e-03
 	 7.03811756889211825871655037190067e-01 2.23701284655144105872892623665393e-01 7.24869584556441376443913782168238e-02 5.28103623536607929417341367184235e-03
 	 7.03811756889211825871655037190067e-01 7.24869584556441376443913782168238e-02 2.23701284655144105872892623665393e-01 5.28103623536607929417341367184235e-03
 	 2.26472947511629774108854462610907e-01 1.33817023340663948660633764120576e-01 6.39710029147706249474936157639604e-01 7.20395816305098232734671626076306e-03
 	 2.26472947511629774108854462610907e-01 6.39710029147706249474936157639604e-01 1.33817023340663948660633764120576e-01 7.20395816305098232734671626076306e-03
 	 1.33817023340663948660633764120576e-01 2.26472947511629774108854462610907e-01 6.39710029147706249474936157639604e-01 7.20395816305098232734671626076306e-03
 	 1.33817023340663948660633764120576e-01 6.39710029147706249474936157639604e-01 2.26472947511629774108854462610907e-01 7.20395816305098232734671626076306e-03
 	 6.39710029147706249474936157639604e-01 2.26472947511629774108854462610907e-01 1.33817023340663948660633764120576e-01 7.20395816305098232734671626076306e-03
 	 6.39710029147706249474936157639604e-01 1.33817023340663948660633764120576e-01 2.26472947511629774108854462610907e-01 7.20395816305098232734671626076306e-03
 	 1.63361966829370430787093937397003e-01 1.76742202382502745783288133907263e-02 8.18963812932379298104024201165885e-01 2.55004646635130591963980251080102e-03
 	 1.63361966829370430787093937397003e-01 8.18963812932379298104024201165885e-01 1.76742202382502745783288133907263e-02 2.55004646635130591963980251080102e-03
 	 1.76742202382502745783288133907263e-02 1.63361966829370430787093937397003e-01 8.18963812932379298104024201165885e-01 2.55004646635130591963980251080102e-03
 	 1.76742202382502745783288133907263e-02 8.18963812932379298104024201165885e-01 1.63361966829370430787093937397003e-01 2.55004646635130591963980251080102e-03
 	 8.18963812932379298104024201165885e-01 1.63361966829370430787093937397003e-01 1.76742202382502745783288133907263e-02 2.55004646635130591963980251080102e-03
 	 8.18963812932379298104024201165885e-01 1.76742202382502745783288133907263e-02 1.63361966829370430787093937397003e-01 2.55004646635130591963980251080102e-03
 	 1.90791272854378857193324847685290e-01 4.22082170395821076880338296177797e-02 7.67000510106039090629792553954758e-01 4.09312115740266112967615796947030e-03
 	 1.90791272854378857193324847685290e-01 7.67000510106039090629792553954758e-01 4.22082170395821076880338296177797e-02 4.09312115740266112967615796947030e-03
 	 4.22082170395821076880338296177797e-02 1.90791272854378857193324847685290e-01 7.67000510106039090629792553954758e-01 4.09312115740266112967615796947030e-03
 	 4.22082170395821076880338296177797e-02 7.67000510106039090629792553954758e-01 1.90791272854378857193324847685290e-01 4.09312115740266112967615796947030e-03
 	 7.67000510106039090629792553954758e-01 1.90791272854378857193324847685290e-01 4.22082170395821076880338296177797e-02 4.09312115740266112967615796947030e-03
 	 7.67000510106039090629792553954758e-01 4.22082170395821076880338296177797e-02 1.90791272854378857193324847685290e-01 4.09312115740266112967615796947030e-03
 	 3.58165870631430682813345356407808e-01 3.44163203969896150380414212577307e-02 6.07417808971579709087507126241690e-01 4.46939174361263898832552499129633e-03
 	 3.58165870631430682813345356407808e-01 6.07417808971579709087507126241690e-01 3.44163203969896150380414212577307e-02 4.46939174361263898832552499129633e-03
 	 3.44163203969896150380414212577307e-02 3.58165870631430682813345356407808e-01 6.07417808971579709087507126241690e-01 4.46939174361263898832552499129633e-03
 	 3.44163203969896150380414212577307e-02 6.07417808971579709087507126241690e-01 3.58165870631430682813345356407808e-01 4.46939174361263898832552499129633e-03
 	 6.07417808971579709087507126241690e-01 3.58165870631430682813345356407808e-01 3.44163203969896150380414212577307e-02 4.46939174361263898832552499129633e-03
 	 6.07417808971579709087507126241690e-01 3.44163203969896150380414212577307e-02 3.58165870631430682813345356407808e-01 4.46939174361263898832552499129633e-03
 	 9.93849892050521904751647639386647e-02 1.74529902610205088497874470476745e-02 8.83162020533927227816661797987763e-01 2.10122242303524857029439765199186e-03
 	 9.93849892050521904751647639386647e-02 8.83162020533927227816661797987763e-01 1.74529902610205088497874470476745e-02 2.10122242303524857029439765199186e-03
 	 1.74529902610205088497874470476745e-02 9.93849892050521904751647639386647e-02 8.83162020533927227816661797987763e-01 2.10122242303524857029439765199186e-03
 	 1.74529902610205088497874470476745e-02 8.83162020533927227816661797987763e-01 9.93849892050521904751647639386647e-02 2.10122242303524857029439765199186e-03
 	 8.83162020533927227816661797987763e-01 9.93849892050521904751647639386647e-02 1.74529902610205088497874470476745e-02 2.10122242303524857029439765199186e-03
 	 8.83162020533927227816661797987763e-01 1.74529902610205088497874470476745e-02 9.93849892050521904751647639386647e-02 2.10122242303524857029439765199186e-03
 	 4.50232897891652383837168827085407e-01 1.22783484472307590634754248526406e-03 5.48539267263624563675250556116225e-01 8.22089107314220792106784774233574e-04
 	 4.50232897891652383837168827085407e-01 5.48539267263624563675250556116225e-01 1.22783484472307590634754248526406e-03 8.22089107314220792106784774233574e-04
 	 1.22783484472307590634754248526406e-03 4.50232897891652383837168827085407e-01 5.48539267263624563675250556116225e-01 8.22089107314220792106784774233574e-04
 	 1.22783484472307590634754248526406e-03 5.48539267263624563675250556116225e-01 4.50232897891652383837168827085407e-01 8.22089107314220792106784774233574e-04
 	 5.48539267263624563675250556116225e-01 4.50232897891652383837168827085407e-01 1.22783484472307590634754248526406e-03 8.22089107314220792106784774233574e-04
 	 5.48539267263624563675250556116225e-01 1.22783484472307590634754248526406e-03 4.50232897891652383837168827085407e-01 8.22089107314220792106784774233574e-04
 	 3.04860292986679271010075353842694e-01 2.36263190066308664816219220483617e-01 4.58876516947012036418129810044775e-01 1.02133456155291419548136744310796e-02
 	 3.04860292986679271010075353842694e-01 4.58876516947012036418129810044775e-01 2.36263190066308664816219220483617e-01 1.02133456155291419548136744310796e-02
 	 2.36263190066308664816219220483617e-01 3.04860292986679271010075353842694e-01 4.58876516947012036418129810044775e-01 1.02133456155291419548136744310796e-02
 	 2.36263190066308664816219220483617e-01 4.58876516947012036418129810044775e-01 3.04860292986679271010075353842694e-01 1.02133456155291419548136744310796e-02
 	 4.58876516947012036418129810044775e-01 3.04860292986679271010075353842694e-01 2.36263190066308664816219220483617e-01 1.02133456155291419548136744310796e-02
 	 4.58876516947012036418129810044775e-01 2.36263190066308664816219220483617e-01 3.04860292986679271010075353842694e-01 1.02133456155291419548136744310796e-02
 	 3.13583606270695147699711924360599e-01 1.55229285287317442243448795125005e-02 6.70893465200573135831518811755814e-01 3.04022135483009723136427204792653e-03
 	 3.13583606270695147699711924360599e-01 6.70893465200573135831518811755814e-01 1.55229285287317442243448795125005e-02 3.04022135483009723136427204792653e-03
 	 1.55229285287317442243448795125005e-02 3.13583606270695147699711924360599e-01 6.70893465200573135831518811755814e-01 3.04022135483009723136427204792653e-03
 	 1.55229285287317442243448795125005e-02 6.70893465200573135831518811755814e-01 3.13583606270695147699711924360599e-01 3.04022135483009723136427204792653e-03
 	 6.70893465200573135831518811755814e-01 3.13583606270695147699711924360599e-01 1.55229285287317442243448795125005e-02 3.04022135483009723136427204792653e-03
 	 6.70893465200573135831518811755814e-01 1.55229285287317442243448795125005e-02 3.13583606270695147699711924360599e-01 3.04022135483009723136427204792653e-03
 	 1.34806288266682894327885833263281e-01 3.84804577084505751438658904817203e-03 8.61345665962471973564618110685842e-01 1.10961015361706115227302671399912e-03
 	 1.34806288266682894327885833263281e-01 8.61345665962471973564618110685842e-01 3.84804577084505751438658904817203e-03 1.10961015361706115227302671399912e-03
 	 3.84804577084505751438658904817203e-03 1.34806288266682894327885833263281e-01 8.61345665962471973564618110685842e-01 1.10961015361706115227302671399912e-03
 	 3.84804577084505751438658904817203e-03 8.61345665962471973564618110685842e-01 1.34806288266682894327885833263281e-01 1.10961015361706115227302671399912e-03
 	 8.61345665962471973564618110685842e-01 1.34806288266682894327885833263281e-01 3.84804577084505751438658904817203e-03 1.10961015361706115227302671399912e-03
 	 8.61345665962471973564618110685842e-01 3.84804577084505751438658904817203e-03 1.34806288266682894327885833263281e-01 1.10961015361706115227302671399912e-03
 	 6.58281924328198569940084894369647e-02 3.80724693230130931120847037618660e-02 8.96099338244166987443861671636114e-01 2.66690116600345377209646535732190e-03
 	 6.58281924328198569940084894369647e-02 8.96099338244166987443861671636114e-01 3.80724693230130931120847037618660e-02 2.66690116600345377209646535732190e-03
 	 3.80724693230130931120847037618660e-02 6.58281924328198569940084894369647e-02 8.96099338244166987443861671636114e-01 2.66690116600345377209646535732190e-03
 	 3.80724693230130931120847037618660e-02 8.96099338244166987443861671636114e-01 6.58281924328198569940084894369647e-02 2.66690116600345377209646535732190e-03
 	 8.96099338244166987443861671636114e-01 6.58281924328198569940084894369647e-02 3.80724693230130931120847037618660e-02 2.66690116600345377209646535732190e-03
 	 8.96099338244166987443861671636114e-01 3.80724693230130931120847037618660e-02 6.58281924328198569940084894369647e-02 2.66690116600345377209646535732190e-03
 	 5.31928439194577426518684148959437e-02 1.21702541539402027404026540580162e-02 9.34636901926601981749342940020142e-01 1.33560876406502138623311193299514e-03
 	 5.31928439194577426518684148959437e-02 9.34636901926601981749342940020142e-01 1.21702541539402027404026540580162e-02 1.33560876406502138623311193299514e-03
 	 1.21702541539402027404026540580162e-02 5.31928439194577426518684148959437e-02 9.34636901926601981749342940020142e-01 1.33560876406502138623311193299514e-03
 	 1.21702541539402027404026540580162e-02 9.34636901926601981749342940020142e-01 5.31928439194577426518684148959437e-02 1.33560876406502138623311193299514e-03
 	 9.34636901926601981749342940020142e-01 5.31928439194577426518684148959437e-02 1.21702541539402027404026540580162e-02 1.33560876406502138623311193299514e-03
 	 9.34636901926601981749342940020142e-01 1.21702541539402027404026540580162e-02 5.31928439194577426518684148959437e-02 1.33560876406502138623311193299514e-03
 	 4.06479626359585802242158081298840e-02 8.58559044683948331504186324281136e-04 9.58493478319357494754626713984180e-01 2.66177823893442276354664999260535e-04
 	 4.06479626359585802242158081298840e-02 9.58493478319357494754626713984180e-01 8.58559044683948331504186324281136e-04 2.66177823893442276354664999260535e-04
 	 8.58559044683948331504186324281136e-04 4.06479626359585802242158081298840e-02 9.58493478319357494754626713984180e-01 2.66177823893442276354664999260535e-04
 	 8.58559044683948331504186324281136e-04 9.58493478319357494754626713984180e-01 4.06479626359585802242158081298840e-02 2.66177823893442276354664999260535e-04
 	 9.58493478319357494754626713984180e-01 4.06479626359585802242158081298840e-02 8.58559044683948331504186324281136e-04 2.66177823893442276354664999260535e-04
 	 9.58493478319357494754626713984180e-01 8.58559044683948331504186324281136e-04 4.06479626359585802242158081298840e-02 2.66177823893442276354664999260535e-04
 	 4.06447567212284865956206658665906e-01 1.23358378103272329356920877785342e-02 5.81216594977387868148355209996225e-01 2.88768699132152311878640738029844e-03
 	 4.06447567212284865956206658665906e-01 5.81216594977387868148355209996225e-01 1.23358378103272329356920877785342e-02 2.88768699132152311878640738029844e-03
 	 1.23358378103272329356920877785342e-02 4.06447567212284865956206658665906e-01 5.81216594977387868148355209996225e-01 2.88768699132152311878640738029844e-03
 	 1.23358378103272329356920877785342e-02 5.81216594977387868148355209996225e-01 4.06447567212284865956206658665906e-01 2.88768699132152311878640738029844e-03
 	 5.81216594977387868148355209996225e-01 4.06447567212284865956206658665906e-01 1.23358378103272329356920877785342e-02 2.88768699132152311878640738029844e-03
 	 5.81216594977387868148355209996225e-01 1.23358378103272329356920877785342e-02 4.06447567212284865956206658665906e-01 2.88768699132152311878640738029844e-03
 	 ];
 
 	 case  37 

 	 % ALG. DEG.:   37
 	 % PTS CARD.:  252
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.0e-15  

 	 xyw_bar=[
 	 1.02303932157760305021731994656875e-01 1.02303932157760305021731994656875e-01 7.95392135684479417712111626315163e-01 1.51398977185801530964681660407223e-03
 	 1.02303932157760305021731994656875e-01 7.95392135684479417712111626315163e-01 1.02303932157760305021731994656875e-01 1.51398977185801530964681660407223e-03
 	 7.95392135684479417712111626315163e-01 1.02303932157760305021731994656875e-01 1.02303932157760305021731994656875e-01 1.51398977185801530964681660407223e-03
 	 3.50202358754684098252063506606646e-02 3.50202358754684098252063506606646e-02 9.29959528249063138716223875235301e-01 1.10468366904461459850061988419156e-03
 	 3.50202358754684098252063506606646e-02 9.29959528249063138716223875235301e-01 3.50202358754684098252063506606646e-02 1.10468366904461459850061988419156e-03
 	 9.29959528249063138716223875235301e-01 3.50202358754684098252063506606646e-02 3.50202358754684098252063506606646e-02 1.10468366904461459850061988419156e-03
 	 2.59243490456549541267605718530831e-01 2.59243490456549541267605718530831e-01 4.81513019086900917464788562938338e-01 7.58509235637052497969179398751294e-03
 	 2.59243490456549541267605718530831e-01 4.81513019086900917464788562938338e-01 2.59243490456549541267605718530831e-01 7.58509235637052497969179398751294e-03
 	 4.81513019086900917464788562938338e-01 2.59243490456549541267605718530831e-01 2.59243490456549541267605718530831e-01 7.58509235637052497969179398751294e-03
 	 1.39441235872292679243145130385528e-01 1.39441235872292679243145130385528e-01 7.21117528255414641513709739228943e-01 5.25006015432877715803927642923554e-03
 	 1.39441235872292679243145130385528e-01 7.21117528255414641513709739228943e-01 1.39441235872292679243145130385528e-01 5.25006015432877715803927642923554e-03
 	 7.21117528255414641513709739228943e-01 1.39441235872292679243145130385528e-01 1.39441235872292679243145130385528e-01 5.25006015432877715803927642923554e-03
 	 4.61168458890810040173846573452465e-01 4.61168458890810040173846573452465e-01 7.76630822183799196523068530950695e-02 5.88083467927782901213396016260049e-03
 	 4.61168458890810040173846573452465e-01 7.76630822183799196523068530950695e-02 4.61168458890810040173846573452465e-01 5.88083467927782901213396016260049e-03
 	 7.76630822183799196523068530950695e-02 4.61168458890810040173846573452465e-01 4.61168458890810040173846573452465e-01 5.88083467927782901213396016260049e-03
 	 3.79153717955037827813669082388515e-01 3.79153717955037827813669082388515e-01 2.41692564089924344372661835222971e-01 8.64455657408533251206961267598672e-03
 	 3.79153717955037827813669082388515e-01 2.41692564089924344372661835222971e-01 3.79153717955037827813669082388515e-01 8.64455657408533251206961267598672e-03
 	 2.41692564089924344372661835222971e-01 3.79153717955037827813669082388515e-01 3.79153717955037827813669082388515e-01 8.64455657408533251206961267598672e-03
 	 1.73411753639024328321749379711036e-02 1.73411753639024328321749379711036e-02 9.65317649272195099641180604521651e-01 8.77587252150814753001717427594031e-04
 	 1.73411753639024328321749379711036e-02 9.65317649272195099641180604521651e-01 1.73411753639024328321749379711036e-02 8.77587252150814753001717427594031e-04
 	 9.65317649272195099641180604521651e-01 1.73411753639024328321749379711036e-02 1.73411753639024328321749379711036e-02 8.77587252150814753001717427594031e-04
 	 7.79889301806426238350411495048320e-02 7.79889301806426238350411495048320e-02 8.44022139638714752329917700990336e-01 3.58623360274968466798739541445684e-03
 	 7.79889301806426238350411495048320e-02 8.44022139638714752329917700990336e-01 7.79889301806426238350411495048320e-02 3.58623360274968466798739541445684e-03
 	 8.44022139638714752329917700990336e-01 7.79889301806426238350411495048320e-02 7.79889301806426238350411495048320e-02 3.58623360274968466798739541445684e-03
 	 4.79244935556920326202856585950940e-01 4.79244935556920326202856585950940e-01 4.15101288861593475942868280981202e-02 4.99924282847581842592621370613415e-03
 	 4.79244935556920326202856585950940e-01 4.15101288861593475942868280981202e-02 4.79244935556920326202856585950940e-01 4.99924282847581842592621370613415e-03
 	 4.15101288861593475942868280981202e-02 4.79244935556920326202856585950940e-01 4.79244935556920326202856585950940e-01 4.99924282847581842592621370613415e-03
 	 4.12061405479689502051598992693471e-01 4.12061405479689502051598992693471e-01 1.75877189040620995896802014613058e-01 9.07884250553964849972388151400082e-03
 	 4.12061405479689502051598992693471e-01 1.75877189040620995896802014613058e-01 4.12061405479689502051598992693471e-01 9.07884250553964849972388151400082e-03
 	 1.75877189040620995896802014613058e-01 4.12061405479689502051598992693471e-01 4.12061405479689502051598992693471e-01 9.07884250553964849972388151400082e-03
 	 4.98410574413956974915151931782020e-01 4.98410574413956974915151931782020e-01 3.17885117208605016969613643595949e-03 1.41567810919451136410229796780413e-03
 	 4.98410574413956974915151931782020e-01 3.17885117208605016969613643595949e-03 4.98410574413956974915151931782020e-01 1.41567810919451136410229796780413e-03
 	 3.17885117208605016969613643595949e-03 4.98410574413956974915151931782020e-01 4.98410574413956974915151931782020e-01 1.41567810919451136410229796780413e-03
 	 3.09125948685350482314504461101023e-01 3.09125948685350482314504461101023e-01 3.81748102629299035370991077797953e-01 1.02066366491735914523442119161700e-02
 	 3.09125948685350482314504461101023e-01 3.81748102629299035370991077797953e-01 3.09125948685350482314504461101023e-01 1.02066366491735914523442119161700e-02
 	 3.81748102629299035370991077797953e-01 3.09125948685350482314504461101023e-01 3.09125948685350482314504461101023e-01 1.02066366491735914523442119161700e-02
 	 3.67156682198311505940790944180208e-03 3.67156682198311505940790944180208e-03 9.92656866356033784626333726919256e-01 1.73295335780859185905583563780397e-04
 	 3.67156682198311505940790944180208e-03 9.92656866356033784626333726919256e-01 3.67156682198311505940790944180208e-03 1.73295335780859185905583563780397e-04
 	 9.92656866356033784626333726919256e-01 3.67156682198311505940790944180208e-03 3.67156682198311505940790944180208e-03 1.73295335780859185905583563780397e-04
 	 1.89364261200196171142096090989071e-01 1.89364261200196171142096090989071e-01 6.21271477599607657715807818021858e-01 8.29061325705372081928956617957738e-03
 	 1.89364261200196171142096090989071e-01 6.21271477599607657715807818021858e-01 1.89364261200196171142096090989071e-01 8.29061325705372081928956617957738e-03
 	 6.21271477599607657715807818021858e-01 1.89364261200196171142096090989071e-01 1.89364261200196171142096090989071e-01 8.29061325705372081928956617957738e-03
 	 3.16024096496639927966754157750984e-01 3.38290906827213161411904707165377e-02 6.50146812820638797525418794975849e-01 2.09919209734947325926568417742146e-03
 	 3.16024096496639927966754157750984e-01 6.50146812820638797525418794975849e-01 3.38290906827213161411904707165377e-02 2.09919209734947325926568417742146e-03
 	 3.38290906827213161411904707165377e-02 3.16024096496639927966754157750984e-01 6.50146812820638797525418794975849e-01 2.09919209734947325926568417742146e-03
 	 3.38290906827213161411904707165377e-02 6.50146812820638797525418794975849e-01 3.16024096496639927966754157750984e-01 2.09919209734947325926568417742146e-03
 	 6.50146812820638797525418794975849e-01 3.16024096496639927966754157750984e-01 3.38290906827213161411904707165377e-02 2.09919209734947325926568417742146e-03
 	 6.50146812820638797525418794975849e-01 3.38290906827213161411904707165377e-02 3.16024096496639927966754157750984e-01 2.09919209734947325926568417742146e-03
 	 1.05359411960281923459348263349966e-01 3.31459895561884293480048313540465e-02 8.61494598483529716581585944368271e-01 1.92262517218207769527371642226399e-03
 	 1.05359411960281923459348263349966e-01 8.61494598483529716581585944368271e-01 3.31459895561884293480048313540465e-02 1.92262517218207769527371642226399e-03
 	 3.31459895561884293480048313540465e-02 1.05359411960281923459348263349966e-01 8.61494598483529716581585944368271e-01 1.92262517218207769527371642226399e-03
 	 3.31459895561884293480048313540465e-02 8.61494598483529716581585944368271e-01 1.05359411960281923459348263349966e-01 1.92262517218207769527371642226399e-03
 	 8.61494598483529716581585944368271e-01 1.05359411960281923459348263349966e-01 3.31459895561884293480048313540465e-02 1.92262517218207769527371642226399e-03
 	 8.61494598483529716581585944368271e-01 3.31459895561884293480048313540465e-02 1.05359411960281923459348263349966e-01 1.92262517218207769527371642226399e-03
 	 7.49810217841138243466403423553857e-02 2.03347607611732879295818321452316e-03 9.22985502139768820839549334777985e-01 4.80443010001876708199575194413455e-04
 	 7.49810217841138243466403423553857e-02 9.22985502139768820839549334777985e-01 2.03347607611732879295818321452316e-03 4.80443010001876708199575194413455e-04
 	 2.03347607611732879295818321452316e-03 7.49810217841138243466403423553857e-02 9.22985502139768820839549334777985e-01 4.80443010001876708199575194413455e-04
 	 2.03347607611732879295818321452316e-03 9.22985502139768820839549334777985e-01 7.49810217841138243466403423553857e-02 4.80443010001876708199575194413455e-04
 	 9.22985502139768820839549334777985e-01 7.49810217841138243466403423553857e-02 2.03347607611732879295818321452316e-03 4.80443010001876708199575194413455e-04
 	 9.22985502139768820839549334777985e-01 2.03347607611732879295818321452316e-03 7.49810217841138243466403423553857e-02 4.80443010001876708199575194413455e-04
 	 1.19486593380355193838582295029482e-01 5.55104031624588586946167367841554e-02 8.25003003457186023794633911165874e-01 3.03254746008949126537257434677031e-03
 	 1.19486593380355193838582295029482e-01 8.25003003457186023794633911165874e-01 5.55104031624588586946167367841554e-02 3.03254746008949126537257434677031e-03
 	 5.55104031624588586946167367841554e-02 1.19486593380355193838582295029482e-01 8.25003003457186023794633911165874e-01 3.03254746008949126537257434677031e-03
 	 5.55104031624588586946167367841554e-02 8.25003003457186023794633911165874e-01 1.19486593380355193838582295029482e-01 3.03254746008949126537257434677031e-03
 	 8.25003003457186023794633911165874e-01 1.19486593380355193838582295029482e-01 5.55104031624588586946167367841554e-02 3.03254746008949126537257434677031e-03
 	 8.25003003457186023794633911165874e-01 5.55104031624588586946167367841554e-02 1.19486593380355193838582295029482e-01 3.03254746008949126537257434677031e-03
 	 3.19235165045989144338989262905670e-01 2.38060847117024854124878174843616e-01 4.42703987836986001536132562250714e-01 7.31890632924169729639496395634524e-03
 	 3.19235165045989144338989262905670e-01 4.42703987836986001536132562250714e-01 2.38060847117024854124878174843616e-01 7.31890632924169729639496395634524e-03
 	 2.38060847117024854124878174843616e-01 3.19235165045989144338989262905670e-01 4.42703987836986001536132562250714e-01 7.31890632924169729639496395634524e-03
 	 2.38060847117024854124878174843616e-01 4.42703987836986001536132562250714e-01 3.19235165045989144338989262905670e-01 7.31890632924169729639496395634524e-03
 	 4.42703987836986001536132562250714e-01 3.19235165045989144338989262905670e-01 2.38060847117024854124878174843616e-01 7.31890632924169729639496395634524e-03
 	 4.42703987836986001536132562250714e-01 2.38060847117024854124878174843616e-01 3.19235165045989144338989262905670e-01 7.31890632924169729639496395634524e-03
 	 3.91788257723670096943635599018307e-01 7.52705489375098402149433240992948e-02 5.32941193338820062841421076882398e-01 5.38831884298098234137297524171117e-03
 	 3.91788257723670096943635599018307e-01 5.32941193338820062841421076882398e-01 7.52705489375098402149433240992948e-02 5.38831884298098234137297524171117e-03
 	 7.52705489375098402149433240992948e-02 3.91788257723670096943635599018307e-01 5.32941193338820062841421076882398e-01 5.38831884298098234137297524171117e-03
 	 7.52705489375098402149433240992948e-02 5.32941193338820062841421076882398e-01 3.91788257723670096943635599018307e-01 5.38831884298098234137297524171117e-03
 	 5.32941193338820062841421076882398e-01 3.91788257723670096943635599018307e-01 7.52705489375098402149433240992948e-02 5.38831884298098234137297524171117e-03
 	 5.32941193338820062841421076882398e-01 7.52705489375098402149433240992948e-02 3.91788257723670096943635599018307e-01 5.38831884298098234137297524171117e-03
 	 3.17543407214198269983285172202159e-01 5.36208316291131165121086610270140e-02 6.28835761156688599626818358956371e-01 4.56921591898148179294869564159853e-03
 	 3.17543407214198269983285172202159e-01 6.28835761156688599626818358956371e-01 5.36208316291131165121086610270140e-02 4.56921591898148179294869564159853e-03
 	 5.36208316291131165121086610270140e-02 3.17543407214198269983285172202159e-01 6.28835761156688599626818358956371e-01 4.56921591898148179294869564159853e-03
 	 5.36208316291131165121086610270140e-02 6.28835761156688599626818358956371e-01 3.17543407214198269983285172202159e-01 4.56921591898148179294869564159853e-03
 	 6.28835761156688599626818358956371e-01 3.17543407214198269983285172202159e-01 5.36208316291131165121086610270140e-02 4.56921591898148179294869564159853e-03
 	 6.28835761156688599626818358956371e-01 5.36208316291131165121086610270140e-02 3.17543407214198269983285172202159e-01 4.56921591898148179294869564159853e-03
 	 3.26764524592731753216412471374497e-01 9.12947670950428336045234800621984e-02 5.81940708312225440934639664192218e-01 5.72035990645847636920651169134544e-03
 	 3.26764524592731753216412471374497e-01 5.81940708312225440934639664192218e-01 9.12947670950428336045234800621984e-02 5.72035990645847636920651169134544e-03
 	 9.12947670950428336045234800621984e-02 3.26764524592731753216412471374497e-01 5.81940708312225440934639664192218e-01 5.72035990645847636920651169134544e-03
 	 9.12947670950428336045234800621984e-02 5.81940708312225440934639664192218e-01 3.26764524592731753216412471374497e-01 5.72035990645847636920651169134544e-03
 	 5.81940708312225440934639664192218e-01 3.26764524592731753216412471374497e-01 9.12947670950428336045234800621984e-02 5.72035990645847636920651169134544e-03
 	 5.81940708312225440934639664192218e-01 9.12947670950428336045234800621984e-02 3.26764524592731753216412471374497e-01 5.72035990645847636920651169134544e-03
 	 3.18749666827180144768050240600132e-01 1.35115749070284674182573780854000e-01 5.46134584102535236560527209803695e-01 6.71200484908567041042459777600016e-03
 	 3.18749666827180144768050240600132e-01 5.46134584102535236560527209803695e-01 1.35115749070284674182573780854000e-01 6.71200484908567041042459777600016e-03
 	 1.35115749070284674182573780854000e-01 3.18749666827180144768050240600132e-01 5.46134584102535236560527209803695e-01 6.71200484908567041042459777600016e-03
 	 1.35115749070284674182573780854000e-01 5.46134584102535236560527209803695e-01 3.18749666827180144768050240600132e-01 6.71200484908567041042459777600016e-03
 	 5.46134584102535236560527209803695e-01 3.18749666827180144768050240600132e-01 1.35115749070284674182573780854000e-01 6.71200484908567041042459777600016e-03
 	 5.46134584102535236560527209803695e-01 1.35115749070284674182573780854000e-01 3.18749666827180144768050240600132e-01 6.71200484908567041042459777600016e-03
 	 6.74578790813868262032926281790424e-02 4.07701237566786764410231569399912e-02 8.91771997161934559805729350046022e-01 2.31707750931314749795464358328445e-03
 	 6.74578790813868262032926281790424e-02 8.91771997161934559805729350046022e-01 4.07701237566786764410231569399912e-02 2.31707750931314749795464358328445e-03
 	 4.07701237566786764410231569399912e-02 6.74578790813868262032926281790424e-02 8.91771997161934559805729350046022e-01 2.31707750931314749795464358328445e-03
 	 4.07701237566786764410231569399912e-02 8.91771997161934559805729350046022e-01 6.74578790813868262032926281790424e-02 2.31707750931314749795464358328445e-03
 	 8.91771997161934559805729350046022e-01 6.74578790813868262032926281790424e-02 4.07701237566786764410231569399912e-02 2.31707750931314749795464358328445e-03
 	 8.91771997161934559805729350046022e-01 4.07701237566786764410231569399912e-02 6.74578790813868262032926281790424e-02 2.31707750931314749795464358328445e-03
 	 1.83794409210811804378238321078243e-02 2.99027787656391775758524254058557e-03 9.78630281202354956882061287615215e-01 3.08669261970532420383261928975571e-04
 	 1.83794409210811804378238321078243e-02 9.78630281202354956882061287615215e-01 2.99027787656391775758524254058557e-03 3.08669261970532420383261928975571e-04
 	 2.99027787656391775758524254058557e-03 1.83794409210811804378238321078243e-02 9.78630281202354956882061287615215e-01 3.08669261970532420383261928975571e-04
 	 2.99027787656391775758524254058557e-03 9.78630281202354956882061287615215e-01 1.83794409210811804378238321078243e-02 3.08669261970532420383261928975571e-04
 	 9.78630281202354956882061287615215e-01 1.83794409210811804378238321078243e-02 2.99027787656391775758524254058557e-03 3.08669261970532420383261928975571e-04
 	 9.78630281202354956882061287615215e-01 2.99027787656391775758524254058557e-03 1.83794409210811804378238321078243e-02 3.08669261970532420383261928975571e-04
 	 4.76569358622159489069503024438745e-02 1.72509604538075254909212929987916e-02 9.35092103683976549888257068232633e-01 1.20470276944105989837263681607737e-03
 	 4.76569358622159489069503024438745e-02 9.35092103683976549888257068232633e-01 1.72509604538075254909212929987916e-02 1.20470276944105989837263681607737e-03
 	 1.72509604538075254909212929987916e-02 4.76569358622159489069503024438745e-02 9.35092103683976549888257068232633e-01 1.20470276944105989837263681607737e-03
 	 1.72509604538075254909212929987916e-02 9.35092103683976549888257068232633e-01 4.76569358622159489069503024438745e-02 1.20470276944105989837263681607737e-03
 	 9.35092103683976549888257068232633e-01 4.76569358622159489069503024438745e-02 1.72509604538075254909212929987916e-02 1.20470276944105989837263681607737e-03
 	 9.35092103683976549888257068232633e-01 1.72509604538075254909212929987916e-02 4.76569358622159489069503024438745e-02 1.20470276944105989837263681607737e-03
 	 3.35722787038010062055093385424698e-01 1.81116409195531985476534941881255e-01 4.83160803766457980223947288322961e-01 8.16374625214358849711882015753872e-03
 	 3.35722787038010062055093385424698e-01 4.83160803766457980223947288322961e-01 1.81116409195531985476534941881255e-01 8.16374625214358849711882015753872e-03
 	 1.81116409195531985476534941881255e-01 3.35722787038010062055093385424698e-01 4.83160803766457980223947288322961e-01 8.16374625214358849711882015753872e-03
 	 1.81116409195531985476534941881255e-01 4.83160803766457980223947288322961e-01 3.35722787038010062055093385424698e-01 8.16374625214358849711882015753872e-03
 	 4.83160803766457980223947288322961e-01 3.35722787038010062055093385424698e-01 1.81116409195531985476534941881255e-01 8.16374625214358849711882015753872e-03
 	 4.83160803766457980223947288322961e-01 1.81116409195531985476534941881255e-01 3.35722787038010062055093385424698e-01 8.16374625214358849711882015753872e-03
 	 1.35671607916117625824981018922699e-01 9.01302718482900888652409321366576e-02 7.74198120235592313065353664569557e-01 4.36452402818990857491510126919820e-03
 	 1.35671607916117625824981018922699e-01 7.74198120235592313065353664569557e-01 9.01302718482900888652409321366576e-02 4.36452402818990857491510126919820e-03
 	 9.01302718482900888652409321366576e-02 1.35671607916117625824981018922699e-01 7.74198120235592313065353664569557e-01 4.36452402818990857491510126919820e-03
 	 9.01302718482900888652409321366576e-02 7.74198120235592313065353664569557e-01 1.35671607916117625824981018922699e-01 4.36452402818990857491510126919820e-03
 	 7.74198120235592313065353664569557e-01 1.35671607916117625824981018922699e-01 9.01302718482900888652409321366576e-02 4.36452402818990857491510126919820e-03
 	 7.74198120235592313065353664569557e-01 9.01302718482900888652409321366576e-02 1.35671607916117625824981018922699e-01 4.36452402818990857491510126919820e-03
 	 4.17693614359697928950510004142416e-02 4.01709708723125332591186165132058e-03 9.54213541476798932094993688224349e-01 5.49796550647318397857243876813982e-04
 	 4.17693614359697928950510004142416e-02 9.54213541476798932094993688224349e-01 4.01709708723125332591186165132058e-03 5.49796550647318397857243876813982e-04
 	 4.01709708723125332591186165132058e-03 4.17693614359697928950510004142416e-02 9.54213541476798932094993688224349e-01 5.49796550647318397857243876813982e-04
 	 4.01709708723125332591186165132058e-03 9.54213541476798932094993688224349e-01 4.17693614359697928950510004142416e-02 5.49796550647318397857243876813982e-04
 	 9.54213541476798932094993688224349e-01 4.17693614359697928950510004142416e-02 4.01709708723125332591186165132058e-03 5.49796550647318397857243876813982e-04
 	 9.54213541476798932094993688224349e-01 4.01709708723125332591186165132058e-03 4.17693614359697928950510004142416e-02 5.49796550647318397857243876813982e-04
 	 1.91263737438076231178740727045806e-01 8.09653202292540813411747535610630e-02 7.27770942332669701357872327207588e-01 5.24643815869217308711647262953193e-03
 	 1.91263737438076231178740727045806e-01 7.27770942332669701357872327207588e-01 8.09653202292540813411747535610630e-02 5.24643815869217308711647262953193e-03
 	 8.09653202292540813411747535610630e-02 1.91263737438076231178740727045806e-01 7.27770942332669701357872327207588e-01 5.24643815869217308711647262953193e-03
 	 8.09653202292540813411747535610630e-02 7.27770942332669701357872327207588e-01 1.91263737438076231178740727045806e-01 5.24643815869217308711647262953193e-03
 	 7.27770942332669701357872327207588e-01 1.91263737438076231178740727045806e-01 8.09653202292540813411747535610630e-02 5.24643815869217308711647262953193e-03
 	 7.27770942332669701357872327207588e-01 8.09653202292540813411747535610630e-02 1.91263737438076231178740727045806e-01 5.24643815869217308711647262953193e-03
 	 4.48920329956642827351487312625977e-01 1.68814585101307729209096919475996e-02 5.34198211533226330338663956354139e-01 3.25848945639129220983032375613675e-03
 	 4.48920329956642827351487312625977e-01 5.34198211533226330338663956354139e-01 1.68814585101307729209096919475996e-02 3.25848945639129220983032375613675e-03
 	 1.68814585101307729209096919475996e-02 4.48920329956642827351487312625977e-01 5.34198211533226330338663956354139e-01 3.25848945639129220983032375613675e-03
 	 1.68814585101307729209096919475996e-02 5.34198211533226330338663956354139e-01 4.48920329956642827351487312625977e-01 3.25848945639129220983032375613675e-03
 	 5.34198211533226330338663956354139e-01 4.48920329956642827351487312625977e-01 1.68814585101307729209096919475996e-02 3.25848945639129220983032375613675e-03
 	 5.34198211533226330338663956354139e-01 1.68814585101307729209096919475996e-02 4.48920329956642827351487312625977e-01 3.25848945639129220983032375613675e-03
 	 3.97083379134988478931234112678794e-01 4.14766785336368876135892946876993e-02 5.61439942331374619577388784819050e-01 4.78123498838039281272349612095240e-03
 	 3.97083379134988478931234112678794e-01 5.61439942331374619577388784819050e-01 4.14766785336368876135892946876993e-02 4.78123498838039281272349612095240e-03
 	 4.14766785336368876135892946876993e-02 3.97083379134988478931234112678794e-01 5.61439942331374619577388784819050e-01 4.78123498838039281272349612095240e-03
 	 4.14766785336368876135892946876993e-02 5.61439942331374619577388784819050e-01 3.97083379134988478931234112678794e-01 4.78123498838039281272349612095240e-03
 	 5.61439942331374619577388784819050e-01 3.97083379134988478931234112678794e-01 4.14766785336368876135892946876993e-02 4.78123498838039281272349612095240e-03
 	 5.61439942331374619577388784819050e-01 4.14766785336368876135892946876993e-02 3.97083379134988478931234112678794e-01 4.78123498838039281272349612095240e-03
 	 8.62263440628871780102571165116387e-02 1.37345861622121794692885643485170e-02 9.00039069774900668541306458791951e-01 1.60877190288686005431584291613945e-03
 	 8.62263440628871780102571165116387e-02 9.00039069774900668541306458791951e-01 1.37345861622121794692885643485170e-02 1.60877190288686005431584291613945e-03
 	 1.37345861622121794692885643485170e-02 8.62263440628871780102571165116387e-02 9.00039069774900668541306458791951e-01 1.60877190288686005431584291613945e-03
 	 1.37345861622121794692885643485170e-02 9.00039069774900668541306458791951e-01 8.62263440628871780102571165116387e-02 1.60877190288686005431584291613945e-03
 	 9.00039069774900668541306458791951e-01 8.62263440628871780102571165116387e-02 1.37345861622121794692885643485170e-02 1.60877190288686005431584291613945e-03
 	 9.00039069774900668541306458791951e-01 1.37345861622121794692885643485170e-02 8.62263440628871780102571165116387e-02 1.60877190288686005431584291613945e-03
 	 2.81487959942281984471179612228298e-01 1.79186043302918159014769372561204e-02 7.00593435727426272485729441541480e-01 2.98256650529933088622502879161402e-03
 	 2.81487959942281984471179612228298e-01 7.00593435727426272485729441541480e-01 1.79186043302918159014769372561204e-02 2.98256650529933088622502879161402e-03
 	 1.79186043302918159014769372561204e-02 2.81487959942281984471179612228298e-01 7.00593435727426272485729441541480e-01 2.98256650529933088622502879161402e-03
 	 1.79186043302918159014769372561204e-02 7.00593435727426272485729441541480e-01 2.81487959942281984471179612228298e-01 2.98256650529933088622502879161402e-03
 	 7.00593435727426272485729441541480e-01 2.81487959942281984471179612228298e-01 1.79186043302918159014769372561204e-02 2.98256650529933088622502879161402e-03
 	 7.00593435727426272485729441541480e-01 1.79186043302918159014769372561204e-02 2.81487959942281984471179612228298e-01 2.98256650529933088622502879161402e-03
 	 1.92376834744259289644574550948164e-01 1.28471390056792922340633822386735e-01 6.79151775198947760259216011036187e-01 6.09394884355286218374780915496558e-03
 	 1.92376834744259289644574550948164e-01 6.79151775198947760259216011036187e-01 1.28471390056792922340633822386735e-01 6.09394884355286218374780915496558e-03
 	 1.28471390056792922340633822386735e-01 1.92376834744259289644574550948164e-01 6.79151775198947760259216011036187e-01 6.09394884355286218374780915496558e-03
 	 1.28471390056792922340633822386735e-01 6.79151775198947760259216011036187e-01 1.92376834744259289644574550948164e-01 6.09394884355286218374780915496558e-03
 	 6.79151775198947760259216011036187e-01 1.92376834744259289644574550948164e-01 1.28471390056792922340633822386735e-01 6.09394884355286218374780915496558e-03
 	 6.79151775198947760259216011036187e-01 1.28471390056792922340633822386735e-01 1.92376834744259289644574550948164e-01 6.09394884355286218374780915496558e-03
 	 2.51794247517433122940389012001106e-01 1.37321159731595615616228656108433e-01 6.10884592750971289198957947519375e-01 7.08734074605664367968449468548897e-03
 	 2.51794247517433122940389012001106e-01 6.10884592750971289198957947519375e-01 1.37321159731595615616228656108433e-01 7.08734074605664367968449468548897e-03
 	 1.37321159731595615616228656108433e-01 2.51794247517433122940389012001106e-01 6.10884592750971289198957947519375e-01 7.08734074605664367968449468548897e-03
 	 1.37321159731595615616228656108433e-01 6.10884592750971289198957947519375e-01 2.51794247517433122940389012001106e-01 7.08734074605664367968449468548897e-03
 	 6.10884592750971289198957947519375e-01 2.51794247517433122940389012001106e-01 1.37321159731595615616228656108433e-01 7.08734074605664367968449468548897e-03
 	 6.10884592750971289198957947519375e-01 1.37321159731595615616228656108433e-01 2.51794247517433122940389012001106e-01 7.08734074605664367968449468548897e-03
 	 3.65034794936327955383603693917394e-01 1.74418264943838295655265113737187e-02 6.17523378569288183825847227126360e-01 3.14975262808118950871860697304783e-03
 	 3.65034794936327955383603693917394e-01 6.17523378569288183825847227126360e-01 1.74418264943838295655265113737187e-02 3.14975262808118950871860697304783e-03
 	 1.74418264943838295655265113737187e-02 3.65034794936327955383603693917394e-01 6.17523378569288183825847227126360e-01 3.14975262808118950871860697304783e-03
 	 1.74418264943838295655265113737187e-02 6.17523378569288183825847227126360e-01 3.65034794936327955383603693917394e-01 3.14975262808118950871860697304783e-03
 	 6.17523378569288183825847227126360e-01 3.65034794936327955383603693917394e-01 1.74418264943838295655265113737187e-02 3.14975262808118950871860697304783e-03
 	 6.17523378569288183825847227126360e-01 1.74418264943838295655265113737187e-02 3.65034794936327955383603693917394e-01 3.14975262808118950871860697304783e-03
 	 2.57156635550253476196758128935471e-01 8.61981702781003389368663647474023e-02 6.56645194171646240377526737574954e-01 6.25186995312095906973670622619466e-03
 	 2.57156635550253476196758128935471e-01 6.56645194171646240377526737574954e-01 8.61981702781003389368663647474023e-02 6.25186995312095906973670622619466e-03
 	 8.61981702781003389368663647474023e-02 2.57156635550253476196758128935471e-01 6.56645194171646240377526737574954e-01 6.25186995312095906973670622619466e-03
 	 8.61981702781003389368663647474023e-02 6.56645194171646240377526737574954e-01 2.57156635550253476196758128935471e-01 6.25186995312095906973670622619466e-03
 	 6.56645194171646240377526737574954e-01 2.57156635550253476196758128935471e-01 8.61981702781003389368663647474023e-02 6.25186995312095906973670622619466e-03
 	 6.56645194171646240377526737574954e-01 8.61981702781003389368663647474023e-02 2.57156635550253476196758128935471e-01 6.25186995312095906973670622619466e-03
 	 1.24181611934111021944282526874304e-01 3.41126780083469841389764987127364e-03 8.72407120265054292218565024086274e-01 9.49305322547228840404653915641120e-04
 	 1.24181611934111021944282526874304e-01 8.72407120265054292218565024086274e-01 3.41126780083469841389764987127364e-03 9.49305322547228840404653915641120e-04
 	 3.41126780083469841389764987127364e-03 1.24181611934111021944282526874304e-01 8.72407120265054292218565024086274e-01 9.49305322547228840404653915641120e-04
 	 3.41126780083469841389764987127364e-03 8.72407120265054292218565024086274e-01 1.24181611934111021944282526874304e-01 9.49305322547228840404653915641120e-04
 	 8.72407120265054292218565024086274e-01 1.24181611934111021944282526874304e-01 3.41126780083469841389764987127364e-03 9.49305322547228840404653915641120e-04
 	 8.72407120265054292218565024086274e-01 3.41126780083469841389764987127364e-03 1.24181611934111021944282526874304e-01 9.49305322547228840404653915641120e-04
 	 1.71650727809369157972341213280743e-01 4.45555167117895126183135801056778e-02 7.83793755478841336348239110520808e-01 4.03125208429280356553503494865254e-03
 	 1.71650727809369157972341213280743e-01 7.83793755478841336348239110520808e-01 4.45555167117895126183135801056778e-02 4.03125208429280356553503494865254e-03
 	 4.45555167117895126183135801056778e-02 1.71650727809369157972341213280743e-01 7.83793755478841336348239110520808e-01 4.03125208429280356553503494865254e-03
 	 4.45555167117895126183135801056778e-02 7.83793755478841336348239110520808e-01 1.71650727809369157972341213280743e-01 4.03125208429280356553503494865254e-03
 	 7.83793755478841336348239110520808e-01 1.71650727809369157972341213280743e-01 4.45555167117895126183135801056778e-02 4.03125208429280356553503494865254e-03
 	 7.83793755478841336348239110520808e-01 4.45555167117895126183135801056778e-02 1.71650727809369157972341213280743e-01 4.03125208429280356553503494865254e-03
 	 3.97723109198285573739894971367903e-01 1.22097548884562687177002260341396e-01 4.80179341917151725205314960476244e-01 8.17221754823039756021607615821267e-03
 	 3.97723109198285573739894971367903e-01 4.80179341917151725205314960476244e-01 1.22097548884562687177002260341396e-01 8.17221754823039756021607615821267e-03
 	 1.22097548884562687177002260341396e-01 3.97723109198285573739894971367903e-01 4.80179341917151725205314960476244e-01 8.17221754823039756021607615821267e-03
 	 1.22097548884562687177002260341396e-01 4.80179341917151725205314960476244e-01 3.97723109198285573739894971367903e-01 8.17221754823039756021607615821267e-03
 	 4.80179341917151725205314960476244e-01 3.97723109198285573739894971367903e-01 1.22097548884562687177002260341396e-01 8.17221754823039756021607615821267e-03
 	 4.80179341917151725205314960476244e-01 1.22097548884562687177002260341396e-01 3.97723109198285573739894971367903e-01 8.17221754823039756021607615821267e-03
 	 2.57896645669856483529258639464388e-01 1.95710371236428148922215086713550e-01 5.46392983093715312037375042564236e-01 8.95865902872183643423920074155831e-03
 	 2.57896645669856483529258639464388e-01 5.46392983093715312037375042564236e-01 1.95710371236428148922215086713550e-01 8.95865902872183643423920074155831e-03
 	 1.95710371236428148922215086713550e-01 2.57896645669856483529258639464388e-01 5.46392983093715312037375042564236e-01 8.95865902872183643423920074155831e-03
 	 1.95710371236428148922215086713550e-01 5.46392983093715312037375042564236e-01 2.57896645669856483529258639464388e-01 8.95865902872183643423920074155831e-03
 	 5.46392983093715312037375042564236e-01 2.57896645669856483529258639464388e-01 1.95710371236428148922215086713550e-01 8.95865902872183643423920074155831e-03
 	 5.46392983093715312037375042564236e-01 1.95710371236428148922215086713550e-01 2.57896645669856483529258639464388e-01 8.95865902872183643423920074155831e-03
 	 1.44150074481193601894091216308880e-01 1.83113919798339880307125326908135e-02 8.37538533538972340686257211928023e-01 2.46209874149232177398261001144419e-03
 	 1.44150074481193601894091216308880e-01 8.37538533538972340686257211928023e-01 1.83113919798339880307125326908135e-02 2.46209874149232177398261001144419e-03
 	 1.83113919798339880307125326908135e-02 1.44150074481193601894091216308880e-01 8.37538533538972340686257211928023e-01 2.46209874149232177398261001144419e-03
 	 1.83113919798339880307125326908135e-02 8.37538533538972340686257211928023e-01 1.44150074481193601894091216308880e-01 2.46209874149232177398261001144419e-03
 	 8.37538533538972340686257211928023e-01 1.44150074481193601894091216308880e-01 1.83113919798339880307125326908135e-02 2.46209874149232177398261001144419e-03
 	 8.37538533538972340686257211928023e-01 1.83113919798339880307125326908135e-02 1.44150074481193601894091216308880e-01 2.46209874149232177398261001144419e-03
 	 4.12259561001791008383321468500071e-01 3.26225803520382127975718589141252e-03 5.84478180963005189418879581353394e-01 1.42129292132192803534140868038094e-03
 	 4.12259561001791008383321468500071e-01 5.84478180963005189418879581353394e-01 3.26225803520382127975718589141252e-03 1.42129292132192803534140868038094e-03
 	 3.26225803520382127975718589141252e-03 4.12259561001791008383321468500071e-01 5.84478180963005189418879581353394e-01 1.42129292132192803534140868038094e-03
 	 3.26225803520382127975718589141252e-03 5.84478180963005189418879581353394e-01 4.12259561001791008383321468500071e-01 1.42129292132192803534140868038094e-03
 	 5.84478180963005189418879581353394e-01 4.12259561001791008383321468500071e-01 3.26225803520382127975718589141252e-03 1.42129292132192803534140868038094e-03
 	 5.84478180963005189418879581353394e-01 3.26225803520382127975718589141252e-03 4.12259561001791008383321468500071e-01 1.42129292132192803534140868038094e-03
 	 2.52428464791436324432538640394341e-01 3.47544150731571212936676928961788e-03 7.44096093701247962570732852327637e-01 1.30515649591868071119349359321404e-03
 	 2.52428464791436324432538640394341e-01 7.44096093701247962570732852327637e-01 3.47544150731571212936676928961788e-03 1.30515649591868071119349359321404e-03
 	 3.47544150731571212936676928961788e-03 2.52428464791436324432538640394341e-01 7.44096093701247962570732852327637e-01 1.30515649591868071119349359321404e-03
 	 3.47544150731571212936676928961788e-03 7.44096093701247962570732852327637e-01 2.52428464791436324432538640394341e-01 1.30515649591868071119349359321404e-03
 	 7.44096093701247962570732852327637e-01 2.52428464791436324432538640394341e-01 3.47544150731571212936676928961788e-03 1.30515649591868071119349359321404e-03
 	 7.44096093701247962570732852327637e-01 3.47544150731571212936676928961788e-03 2.52428464791436324432538640394341e-01 1.30515649591868071119349359321404e-03
 	 3.29366927485774507733395921604824e-01 3.53879008258183198887270037857888e-03 6.67094282431643703645818277436774e-01 1.44590952778872721545821988797798e-03
 	 3.29366927485774507733395921604824e-01 6.67094282431643703645818277436774e-01 3.53879008258183198887270037857888e-03 1.44590952778872721545821988797798e-03
 	 3.53879008258183198887270037857888e-03 3.29366927485774507733395921604824e-01 6.67094282431643703645818277436774e-01 1.44590952778872721545821988797798e-03
 	 3.53879008258183198887270037857888e-03 6.67094282431643703645818277436774e-01 3.29366927485774507733395921604824e-01 1.44590952778872721545821988797798e-03
 	 6.67094282431643703645818277436774e-01 3.29366927485774507733395921604824e-01 3.53879008258183198887270037857888e-03 1.44590952778872721545821988797798e-03
 	 6.67094282431643703645818277436774e-01 3.53879008258183198887270037857888e-03 3.29366927485774507733395921604824e-01 1.44590952778872721545821988797798e-03
 	 2.09581481700515409594132165693736e-01 1.88449390557523001332729251089404e-02 7.71573579243732265986466245522024e-01 2.93459505807952027167662123474656e-03
 	 2.09581481700515409594132165693736e-01 7.71573579243732265986466245522024e-01 1.88449390557523001332729251089404e-02 2.93459505807952027167662123474656e-03
 	 1.88449390557523001332729251089404e-02 2.09581481700515409594132165693736e-01 7.71573579243732265986466245522024e-01 2.93459505807952027167662123474656e-03
 	 1.88449390557523001332729251089404e-02 7.71573579243732265986466245522024e-01 2.09581481700515409594132165693736e-01 2.93459505807952027167662123474656e-03
 	 7.71573579243732265986466245522024e-01 2.09581481700515409594132165693736e-01 1.88449390557523001332729251089404e-02 2.93459505807952027167662123474656e-03
 	 7.71573579243732265986466245522024e-01 1.88449390557523001332729251089404e-02 2.09581481700515409594132165693736e-01 2.93459505807952027167662123474656e-03
 	 1.83640169446232209837788218464993e-01 3.63810210869633648272936099488106e-03 8.12721728445071511792718865763163e-01 1.19645900526983098993705212365057e-03
 	 1.83640169446232209837788218464993e-01 8.12721728445071511792718865763163e-01 3.63810210869633648272936099488106e-03 1.19645900526983098993705212365057e-03
 	 3.63810210869633648272936099488106e-03 1.83640169446232209837788218464993e-01 8.12721728445071511792718865763163e-01 1.19645900526983098993705212365057e-03
 	 3.63810210869633648272936099488106e-03 8.12721728445071511792718865763163e-01 1.83640169446232209837788218464993e-01 1.19645900526983098993705212365057e-03
 	 8.12721728445071511792718865763163e-01 1.83640169446232209837788218464993e-01 3.63810210869633648272936099488106e-03 1.19645900526983098993705212365057e-03
 	 8.12721728445071511792718865763163e-01 3.63810210869633648272936099488106e-03 1.83640169446232209837788218464993e-01 1.19645900526983098993705212365057e-03
 	 2.41696232469337524140229334079777e-01 4.57532869613174186795845344022382e-02 7.12550480569345112691337362775812e-01 4.87350441992293048620865647535538e-03
 	 2.41696232469337524140229334079777e-01 7.12550480569345112691337362775812e-01 4.57532869613174186795845344022382e-02 4.87350441992293048620865647535538e-03
 	 4.57532869613174186795845344022382e-02 2.41696232469337524140229334079777e-01 7.12550480569345112691337362775812e-01 4.87350441992293048620865647535538e-03
 	 4.57532869613174186795845344022382e-02 7.12550480569345112691337362775812e-01 2.41696232469337524140229334079777e-01 4.87350441992293048620865647535538e-03
 	 7.12550480569345112691337362775812e-01 2.41696232469337524140229334079777e-01 4.57532869613174186795845344022382e-02 4.87350441992293048620865647535538e-03
 	 7.12550480569345112691337362775812e-01 4.57532869613174186795845344022382e-02 2.41696232469337524140229334079777e-01 4.87350441992293048620865647535538e-03
 	 ];
 
 	 case  38 

 	 % ALG. DEG.:   38
 	 % PTS CARD.:  267
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.8e-15  

 	 xyw_bar=[
 	 4.59072136031764554964240687695565e-01 4.59072136031764554964240687695565e-01 8.18557279364708900715186246088706e-02 3.16396444028392304775865184751638e-03
 	 4.59072136031764554964240687695565e-01 8.18557279364708900715186246088706e-02 4.59072136031764554964240687695565e-01 3.16396444028392304775865184751638e-03
 	 8.18557279364708900715186246088706e-02 4.59072136031764554964240687695565e-01 4.59072136031764554964240687695565e-01 3.16396444028392304775865184751638e-03
 	 3.93268006255360069722826210636413e-01 3.93268006255360069722826210636413e-01 2.13463987489279860554347578727175e-01 5.86165821910864404814534012189142e-03
 	 3.93268006255360069722826210636413e-01 2.13463987489279860554347578727175e-01 3.93268006255360069722826210636413e-01 5.86165821910864404814534012189142e-03
 	 2.13463987489279860554347578727175e-01 3.93268006255360069722826210636413e-01 3.93268006255360069722826210636413e-01 5.86165821910864404814534012189142e-03
 	 4.68182589206935673153964216908207e-01 4.68182589206935673153964216908207e-01 6.36348215861286536920715661835857e-02 3.93021690370114456375416622790908e-03
 	 4.68182589206935673153964216908207e-01 6.36348215861286536920715661835857e-02 4.68182589206935673153964216908207e-01 3.93021690370114456375416622790908e-03
 	 6.36348215861286536920715661835857e-02 4.68182589206935673153964216908207e-01 4.68182589206935673153964216908207e-01 3.93021690370114456375416622790908e-03
 	 1.75045040462672892023210380330056e-02 1.75045040462672892023210380330056e-02 9.64990991907465400778676212212304e-01 6.99469767329601206651279454717951e-04
 	 1.75045040462672892023210380330056e-02 9.64990991907465400778676212212304e-01 1.75045040462672892023210380330056e-02 6.99469767329601206651279454717951e-04
 	 9.64990991907465400778676212212304e-01 1.75045040462672892023210380330056e-02 1.75045040462672892023210380330056e-02 6.99469767329601206651279454717951e-04
 	 1.45480114652860703650105733686360e-01 1.45480114652860703650105733686360e-01 7.09039770694278592699788532627281e-01 5.20242251104386169147097973564087e-03
 	 1.45480114652860703650105733686360e-01 7.09039770694278592699788532627281e-01 1.45480114652860703650105733686360e-01 5.20242251104386169147097973564087e-03
 	 7.09039770694278592699788532627281e-01 1.45480114652860703650105733686360e-01 1.45480114652860703650105733686360e-01 5.20242251104386169147097973564087e-03
 	 3.04717426636049414090390285991816e-03 3.04717426636049414090390285991816e-03 9.93905651467279049882108665769920e-01 1.24046662653103610934185452308043e-04
 	 3.04717426636049414090390285991816e-03 9.93905651467279049882108665769920e-01 3.04717426636049414090390285991816e-03 1.24046662653103610934185452308043e-04
 	 9.93905651467279049882108665769920e-01 3.04717426636049414090390285991816e-03 3.04717426636049414090390285991816e-03 1.24046662653103610934185452308043e-04
 	 5.87361601120219983807047015034186e-02 5.87361601120219983807047015034186e-02 8.82527679775956030994166212622076e-01 2.50638221651448746957191460182912e-03
 	 5.87361601120219983807047015034186e-02 8.82527679775956030994166212622076e-01 5.87361601120219983807047015034186e-02 2.50638221651448746957191460182912e-03
 	 8.82527679775956030994166212622076e-01 5.87361601120219983807047015034186e-02 5.87361601120219983807047015034186e-02 2.50638221651448746957191460182912e-03
 	 3.73835575017464616376372532613459e-02 3.73835575017464616376372532613459e-02 9.25232884996507021213574262219481e-01 1.70755020391572844007388454201646e-03
 	 3.73835575017464616376372532613459e-02 9.25232884996507021213574262219481e-01 3.73835575017464616376372532613459e-02 1.70755020391572844007388454201646e-03
 	 9.25232884996507021213574262219481e-01 3.73835575017464616376372532613459e-02 3.73835575017464616376372532613459e-02 1.70755020391572844007388454201646e-03
 	 2.85504778291264027512141865372541e-01 2.85504778291264027512141865372541e-01 4.28990443417471944975716269254917e-01 8.98560951880498885724346536107987e-03
 	 2.85504778291264027512141865372541e-01 4.28990443417471944975716269254917e-01 2.85504778291264027512141865372541e-01 8.98560951880498885724346536107987e-03
 	 4.28990443417471944975716269254917e-01 2.85504778291264027512141865372541e-01 2.85504778291264027512141865372541e-01 8.98560951880498885724346536107987e-03
 	 4.20333501770014217324700211975141e-01 4.20333501770014217324700211975141e-01 1.59332996459971565350599576049717e-01 7.93770427512045621820657714806657e-03
 	 4.20333501770014217324700211975141e-01 1.59332996459971565350599576049717e-01 4.20333501770014217324700211975141e-01 7.93770427512045621820657714806657e-03
 	 1.59332996459971565350599576049717e-01 4.20333501770014217324700211975141e-01 4.20333501770014217324700211975141e-01 7.93770427512045621820657714806657e-03
 	 2.07689421653862921202104985241021e-01 2.07689421653862921202104985241021e-01 5.84621156692274102084638798260130e-01 7.74855319266747749606949469125539e-03
 	 2.07689421653862921202104985241021e-01 5.84621156692274102084638798260130e-01 2.07689421653862921202104985241021e-01 7.74855319266747749606949469125539e-03
 	 5.84621156692274102084638798260130e-01 2.07689421653862921202104985241021e-01 2.07689421653862921202104985241021e-01 7.74855319266747749606949469125539e-03
 	 4.92196272955310765162550978857325e-01 4.92196272955310765162550978857325e-01 1.56074540893784696748980422853492e-02 3.03589755453443363789056697044089e-03
 	 4.92196272955310765162550978857325e-01 1.56074540893784696748980422853492e-02 4.92196272955310765162550978857325e-01 3.03589755453443363789056697044089e-03
 	 1.56074540893784696748980422853492e-02 4.92196272955310765162550978857325e-01 4.92196272955310765162550978857325e-01 3.03589755453443363789056697044089e-03
 	 3.56565593983026118962698092218488e-01 3.56565593983026118962698092218488e-01 2.86868812033947762074603815563023e-01 9.97599361038256637890242473076796e-03
 	 3.56565593983026118962698092218488e-01 2.86868812033947762074603815563023e-01 3.56565593983026118962698092218488e-01 9.97599361038256637890242473076796e-03
 	 2.86868812033947762074603815563023e-01 3.56565593983026118962698092218488e-01 3.56565593983026118962698092218488e-01 9.97599361038256637890242473076796e-03
 	 2.83765514701740717562472582358168e-01 5.22971139020114439421860197398928e-02 6.63937371396247866250917013530852e-01 2.48500523114265165977587734857934e-03
 	 2.83765514701740717562472582358168e-01 6.63937371396247866250917013530852e-01 5.22971139020114439421860197398928e-02 2.48500523114265165977587734857934e-03
 	 5.22971139020114439421860197398928e-02 2.83765514701740717562472582358168e-01 6.63937371396247866250917013530852e-01 2.48500523114265165977587734857934e-03
 	 5.22971139020114439421860197398928e-02 6.63937371396247866250917013530852e-01 2.83765514701740717562472582358168e-01 2.48500523114265165977587734857934e-03
 	 6.63937371396247866250917013530852e-01 2.83765514701740717562472582358168e-01 5.22971139020114439421860197398928e-02 2.48500523114265165977587734857934e-03
 	 6.63937371396247866250917013530852e-01 5.22971139020114439421860197398928e-02 2.83765514701740717562472582358168e-01 2.48500523114265165977587734857934e-03
 	 1.28516564969693936060224359607673e-01 9.90797627018412813137970829302503e-02 7.72403672328464740992615134018706e-01 3.69648916070682833842631076493035e-03
 	 1.28516564969693936060224359607673e-01 7.72403672328464740992615134018706e-01 9.90797627018412813137970829302503e-02 3.69648916070682833842631076493035e-03
 	 9.90797627018412813137970829302503e-02 1.28516564969693936060224359607673e-01 7.72403672328464740992615134018706e-01 3.69648916070682833842631076493035e-03
 	 9.90797627018412813137970829302503e-02 7.72403672328464740992615134018706e-01 1.28516564969693936060224359607673e-01 3.69648916070682833842631076493035e-03
 	 7.72403672328464740992615134018706e-01 1.28516564969693936060224359607673e-01 9.90797627018412813137970829302503e-02 3.69648916070682833842631076493035e-03
 	 7.72403672328464740992615134018706e-01 9.90797627018412813137970829302503e-02 1.28516564969693936060224359607673e-01 3.69648916070682833842631076493035e-03
 	 4.13075041428614328498092334029934e-02 2.06440514930518719677321470840070e-03 9.56628090707833389494396669761045e-01 3.47704398993699411411772981495005e-04
 	 4.13075041428614328498092334029934e-02 9.56628090707833389494396669761045e-01 2.06440514930518719677321470840070e-03 3.47704398993699411411772981495005e-04
 	 2.06440514930518719677321470840070e-03 4.13075041428614328498092334029934e-02 9.56628090707833389494396669761045e-01 3.47704398993699411411772981495005e-04
 	 2.06440514930518719677321470840070e-03 9.56628090707833389494396669761045e-01 4.13075041428614328498092334029934e-02 3.47704398993699411411772981495005e-04
 	 9.56628090707833389494396669761045e-01 4.13075041428614328498092334029934e-02 2.06440514930518719677321470840070e-03 3.47704398993699411411772981495005e-04
 	 9.56628090707833389494396669761045e-01 2.06440514930518719677321470840070e-03 4.13075041428614328498092334029934e-02 3.47704398993699411411772981495005e-04
 	 8.92719800534144680703718677250436e-02 3.67301756493483427812307695603522e-02 8.73997844297237147515033939271234e-01 2.07382687394077865408736904839770e-03
 	 8.92719800534144680703718677250436e-02 8.73997844297237147515033939271234e-01 3.67301756493483427812307695603522e-02 2.07382687394077865408736904839770e-03
 	 3.67301756493483427812307695603522e-02 8.92719800534144680703718677250436e-02 8.73997844297237147515033939271234e-01 2.07382687394077865408736904839770e-03
 	 3.67301756493483427812307695603522e-02 8.73997844297237147515033939271234e-01 8.92719800534144680703718677250436e-02 2.07382687394077865408736904839770e-03
 	 8.73997844297237147515033939271234e-01 8.92719800534144680703718677250436e-02 3.67301756493483427812307695603522e-02 2.07382687394077865408736904839770e-03
 	 8.73997844297237147515033939271234e-01 3.67301756493483427812307695603522e-02 8.92719800534144680703718677250436e-02 2.07382687394077865408736904839770e-03
 	 3.37205292317987237460386040766025e-01 2.25945824487785718037713422745583e-01 4.36848883194227044501900536488392e-01 7.37104109001125197553339063460953e-03
 	 3.37205292317987237460386040766025e-01 4.36848883194227044501900536488392e-01 2.25945824487785718037713422745583e-01 7.37104109001125197553339063460953e-03
 	 2.25945824487785718037713422745583e-01 3.37205292317987237460386040766025e-01 4.36848883194227044501900536488392e-01 7.37104109001125197553339063460953e-03
 	 2.25945824487785718037713422745583e-01 4.36848883194227044501900536488392e-01 3.37205292317987237460386040766025e-01 7.37104109001125197553339063460953e-03
 	 4.36848883194227044501900536488392e-01 3.37205292317987237460386040766025e-01 2.25945824487785718037713422745583e-01 7.37104109001125197553339063460953e-03
 	 4.36848883194227044501900536488392e-01 2.25945824487785718037713422745583e-01 3.37205292317987237460386040766025e-01 7.37104109001125197553339063460953e-03
 	 2.73851374124178703617360497446498e-01 3.27011819900537709093768512502720e-02 6.93447443885767511595474843488773e-01 3.12539811443985314498572591901393e-03
 	 2.73851374124178703617360497446498e-01 6.93447443885767511595474843488773e-01 3.27011819900537709093768512502720e-02 3.12539811443985314498572591901393e-03
 	 3.27011819900537709093768512502720e-02 2.73851374124178703617360497446498e-01 6.93447443885767511595474843488773e-01 3.12539811443985314498572591901393e-03
 	 3.27011819900537709093768512502720e-02 6.93447443885767511595474843488773e-01 2.73851374124178703617360497446498e-01 3.12539811443985314498572591901393e-03
 	 6.93447443885767511595474843488773e-01 2.73851374124178703617360497446498e-01 3.27011819900537709093768512502720e-02 3.12539811443985314498572591901393e-03
 	 6.93447443885767511595474843488773e-01 3.27011819900537709093768512502720e-02 2.73851374124178703617360497446498e-01 3.12539811443985314498572591901393e-03
 	 3.99162626294194411435967140278080e-02 1.30695090443300153404404539969619e-02 9.47014228326250595557667111279443e-01 9.06176214452056880480079747997024e-04
 	 3.99162626294194411435967140278080e-02 9.47014228326250595557667111279443e-01 1.30695090443300153404404539969619e-02 9.06176214452056880480079747997024e-04
 	 1.30695090443300153404404539969619e-02 3.99162626294194411435967140278080e-02 9.47014228326250595557667111279443e-01 9.06176214452056880480079747997024e-04
 	 1.30695090443300153404404539969619e-02 9.47014228326250595557667111279443e-01 3.99162626294194411435967140278080e-02 9.06176214452056880480079747997024e-04
 	 9.47014228326250595557667111279443e-01 3.99162626294194411435967140278080e-02 1.30695090443300153404404539969619e-02 9.06176214452056880480079747997024e-04
 	 9.47014228326250595557667111279443e-01 1.30695090443300153404404539969619e-02 3.99162626294194411435967140278080e-02 9.06176214452056880480079747997024e-04
 	 3.08106832759384330344687441538554e-01 7.37176145710159158586094463316840e-02 6.18175552669599781552278727758676e-01 4.99562776974669334878464965754574e-03
 	 3.08106832759384330344687441538554e-01 6.18175552669599781552278727758676e-01 7.37176145710159158586094463316840e-02 4.99562776974669334878464965754574e-03
 	 7.37176145710159158586094463316840e-02 3.08106832759384330344687441538554e-01 6.18175552669599781552278727758676e-01 4.99562776974669334878464965754574e-03
 	 7.37176145710159158586094463316840e-02 6.18175552669599781552278727758676e-01 3.08106832759384330344687441538554e-01 4.99562776974669334878464965754574e-03
 	 6.18175552669599781552278727758676e-01 3.08106832759384330344687441538554e-01 7.37176145710159158586094463316840e-02 4.99562776974669334878464965754574e-03
 	 6.18175552669599781552278727758676e-01 7.37176145710159158586094463316840e-02 3.08106832759384330344687441538554e-01 4.99562776974669334878464965754574e-03
 	 2.19624713138435623260846796256374e-01 2.70388221454352780867558259103589e-03 7.77671404647020780842581189062912e-01 9.25668198849912381154236840075100e-04
 	 2.19624713138435623260846796256374e-01 7.77671404647020780842581189062912e-01 2.70388221454352780867558259103589e-03 9.25668198849912381154236840075100e-04
 	 2.70388221454352780867558259103589e-03 2.19624713138435623260846796256374e-01 7.77671404647020780842581189062912e-01 9.25668198849912381154236840075100e-04
 	 2.70388221454352780867558259103589e-03 7.77671404647020780842581189062912e-01 2.19624713138435623260846796256374e-01 9.25668198849912381154236840075100e-04
 	 7.77671404647020780842581189062912e-01 2.19624713138435623260846796256374e-01 2.70388221454352780867558259103589e-03 9.25668198849912381154236840075100e-04
 	 7.77671404647020780842581189062912e-01 2.70388221454352780867558259103589e-03 2.19624713138435623260846796256374e-01 9.25668198849912381154236840075100e-04
 	 2.73464607114281443855929865094367e-01 2.19158263446028789278585691135959e-01 5.07377129439689822376635675027501e-01 8.28216646269295218851791418046560e-03
 	 2.73464607114281443855929865094367e-01 5.07377129439689822376635675027501e-01 2.19158263446028789278585691135959e-01 8.28216646269295218851791418046560e-03
 	 2.19158263446028789278585691135959e-01 2.73464607114281443855929865094367e-01 5.07377129439689822376635675027501e-01 8.28216646269295218851791418046560e-03
 	 2.19158263446028789278585691135959e-01 5.07377129439689822376635675027501e-01 2.73464607114281443855929865094367e-01 8.28216646269295218851791418046560e-03
 	 5.07377129439689822376635675027501e-01 2.73464607114281443855929865094367e-01 2.19158263446028789278585691135959e-01 8.28216646269295218851791418046560e-03
 	 5.07377129439689822376635675027501e-01 2.19158263446028789278585691135959e-01 2.73464607114281443855929865094367e-01 8.28216646269295218851791418046560e-03
 	 6.86830028555526772571226956642931e-02 2.07228118815140395503338055505083e-02 9.10594185262933231150839219480986e-01 1.53684246580731097807370755248257e-03
 	 6.86830028555526772571226956642931e-02 9.10594185262933231150839219480986e-01 2.07228118815140395503338055505083e-02 1.53684246580731097807370755248257e-03
 	 2.07228118815140395503338055505083e-02 6.86830028555526772571226956642931e-02 9.10594185262933231150839219480986e-01 1.53684246580731097807370755248257e-03
 	 2.07228118815140395503338055505083e-02 9.10594185262933231150839219480986e-01 6.86830028555526772571226956642931e-02 1.53684246580731097807370755248257e-03
 	 9.10594185262933231150839219480986e-01 6.86830028555526772571226956642931e-02 2.07228118815140395503338055505083e-02 1.53684246580731097807370755248257e-03
 	 9.10594185262933231150839219480986e-01 2.07228118815140395503338055505083e-02 6.86830028555526772571226956642931e-02 1.53684246580731097807370755248257e-03
 	 1.83013599840179452815647209718009e-01 1.00621720892076091380396007934905e-01 7.16364679267744497437320205790456e-01 5.22274073881437341654310202443412e-03
 	 1.83013599840179452815647209718009e-01 7.16364679267744497437320205790456e-01 1.00621720892076091380396007934905e-01 5.22274073881437341654310202443412e-03
 	 1.00621720892076091380396007934905e-01 1.83013599840179452815647209718009e-01 7.16364679267744497437320205790456e-01 5.22274073881437341654310202443412e-03
 	 1.00621720892076091380396007934905e-01 7.16364679267744497437320205790456e-01 1.83013599840179452815647209718009e-01 5.22274073881437341654310202443412e-03
 	 7.16364679267744497437320205790456e-01 1.83013599840179452815647209718009e-01 1.00621720892076091380396007934905e-01 5.22274073881437341654310202443412e-03
 	 7.16364679267744497437320205790456e-01 1.00621720892076091380396007934905e-01 1.83013599840179452815647209718009e-01 5.22274073881437341654310202443412e-03
 	 2.28799483229925271210447590419790e-01 6.94898178335092570057085481494141e-02 7.01710698936565457906056053616339e-01 4.71839278841991015961410127488307e-03
 	 2.28799483229925271210447590419790e-01 7.01710698936565457906056053616339e-01 6.94898178335092570057085481494141e-02 4.71839278841991015961410127488307e-03
 	 6.94898178335092570057085481494141e-02 2.28799483229925271210447590419790e-01 7.01710698936565457906056053616339e-01 4.71839278841991015961410127488307e-03
 	 6.94898178335092570057085481494141e-02 7.01710698936565457906056053616339e-01 2.28799483229925271210447590419790e-01 4.71839278841991015961410127488307e-03
 	 7.01710698936565457906056053616339e-01 2.28799483229925271210447590419790e-01 6.94898178335092570057085481494141e-02 4.71839278841991015961410127488307e-03
 	 7.01710698936565457906056053616339e-01 6.94898178335092570057085481494141e-02 2.28799483229925271210447590419790e-01 4.71839278841991015961410127488307e-03
 	 1.01882711486939128708861801442254e-01 6.83773554225138580076048810951761e-02 8.29739933090546943894594278390286e-01 3.60211700495285686712820805155388e-03
 	 1.01882711486939128708861801442254e-01 8.29739933090546943894594278390286e-01 6.83773554225138580076048810951761e-02 3.60211700495285686712820805155388e-03
 	 6.83773554225138580076048810951761e-02 1.01882711486939128708861801442254e-01 8.29739933090546943894594278390286e-01 3.60211700495285686712820805155388e-03
 	 6.83773554225138580076048810951761e-02 8.29739933090546943894594278390286e-01 1.01882711486939128708861801442254e-01 3.60211700495285686712820805155388e-03
 	 8.29739933090546943894594278390286e-01 1.01882711486939128708861801442254e-01 6.83773554225138580076048810951761e-02 3.60211700495285686712820805155388e-03
 	 8.29739933090546943894594278390286e-01 6.83773554225138580076048810951761e-02 1.01882711486939128708861801442254e-01 3.60211700495285686712820805155388e-03
 	 2.43563673395817054112555410938512e-01 1.43204413633164825275789766578782e-02 7.42115885240866468564036040334031e-01 2.37029046739335204352361330393251e-03
 	 2.43563673395817054112555410938512e-01 7.42115885240866468564036040334031e-01 1.43204413633164825275789766578782e-02 2.37029046739335204352361330393251e-03
 	 1.43204413633164825275789766578782e-02 2.43563673395817054112555410938512e-01 7.42115885240866468564036040334031e-01 2.37029046739335204352361330393251e-03
 	 1.43204413633164825275789766578782e-02 7.42115885240866468564036040334031e-01 2.43563673395817054112555410938512e-01 2.37029046739335204352361330393251e-03
 	 7.42115885240866468564036040334031e-01 2.43563673395817054112555410938512e-01 1.43204413633164825275789766578782e-02 2.37029046739335204352361330393251e-03
 	 7.42115885240866468564036040334031e-01 1.43204413633164825275789766578782e-02 2.43563673395817054112555410938512e-01 2.37029046739335204352361330393251e-03
 	 2.05887716517901192547768118856766e-01 3.89678567422942698228460756126879e-02 7.55144426739804530690491901623318e-01 3.61048983337579733679523208422779e-03
 	 2.05887716517901192547768118856766e-01 7.55144426739804530690491901623318e-01 3.89678567422942698228460756126879e-02 3.61048983337579733679523208422779e-03
 	 3.89678567422942698228460756126879e-02 2.05887716517901192547768118856766e-01 7.55144426739804530690491901623318e-01 3.61048983337579733679523208422779e-03
 	 3.89678567422942698228460756126879e-02 7.55144426739804530690491901623318e-01 2.05887716517901192547768118856766e-01 3.61048983337579733679523208422779e-03
 	 7.55144426739804530690491901623318e-01 2.05887716517901192547768118856766e-01 3.89678567422942698228460756126879e-02 3.61048983337579733679523208422779e-03
 	 7.55144426739804530690491901623318e-01 3.89678567422942698228460756126879e-02 2.05887716517901192547768118856766e-01 3.61048983337579733679523208422779e-03
 	 2.01869508887603077429417908206233e-01 1.49396461917944173292127629792958e-01 6.48734029194452777034030077629723e-01 6.54045453074550333510961408478579e-03
 	 2.01869508887603077429417908206233e-01 6.48734029194452777034030077629723e-01 1.49396461917944173292127629792958e-01 6.54045453074550333510961408478579e-03
 	 1.49396461917944173292127629792958e-01 2.01869508887603077429417908206233e-01 6.48734029194452777034030077629723e-01 6.54045453074550333510961408478579e-03
 	 1.49396461917944173292127629792958e-01 6.48734029194452777034030077629723e-01 2.01869508887603077429417908206233e-01 6.54045453074550333510961408478579e-03
 	 6.48734029194452777034030077629723e-01 2.01869508887603077429417908206233e-01 1.49396461917944173292127629792958e-01 6.54045453074550333510961408478579e-03
 	 6.48734029194452777034030077629723e-01 1.49396461917944173292127629792958e-01 2.01869508887603077429417908206233e-01 6.54045453074550333510961408478579e-03
 	 1.59116021010545172220673748597619e-01 6.22282118189532995611301657845615e-02 7.78655767170501555973771701246733e-01 4.07922148031260312084356201012270e-03
 	 1.59116021010545172220673748597619e-01 7.78655767170501555973771701246733e-01 6.22282118189532995611301657845615e-02 4.07922148031260312084356201012270e-03
 	 6.22282118189532995611301657845615e-02 1.59116021010545172220673748597619e-01 7.78655767170501555973771701246733e-01 4.07922148031260312084356201012270e-03
 	 6.22282118189532995611301657845615e-02 7.78655767170501555973771701246733e-01 1.59116021010545172220673748597619e-01 4.07922148031260312084356201012270e-03
 	 7.78655767170501555973771701246733e-01 1.59116021010545172220673748597619e-01 6.22282118189532995611301657845615e-02 4.07922148031260312084356201012270e-03
 	 7.78655767170501555973771701246733e-01 6.22282118189532995611301657845615e-02 1.59116021010545172220673748597619e-01 4.07922148031260312084356201012270e-03
 	 1.77947635855591812514830962754786e-01 1.76192414704859877383480437629260e-02 8.04433122673922196277374041528674e-01 2.32563891810583537808621024112199e-03
 	 1.77947635855591812514830962754786e-01 8.04433122673922196277374041528674e-01 1.76192414704859877383480437629260e-02 2.32563891810583537808621024112199e-03
 	 1.76192414704859877383480437629260e-02 1.77947635855591812514830962754786e-01 8.04433122673922196277374041528674e-01 2.32563891810583537808621024112199e-03
 	 1.76192414704859877383480437629260e-02 8.04433122673922196277374041528674e-01 1.77947635855591812514830962754786e-01 2.32563891810583537808621024112199e-03
 	 8.04433122673922196277374041528674e-01 1.77947635855591812514830962754786e-01 1.76192414704859877383480437629260e-02 2.32563891810583537808621024112199e-03
 	 8.04433122673922196277374041528674e-01 1.76192414704859877383480437629260e-02 1.77947635855591812514830962754786e-01 2.32563891810583537808621024112199e-03
 	 1.62036747949692083725636848612339e-01 3.94772766521245526555317084671515e-03 8.34015524385095519122046425763983e-01 1.00574402208326320849740564966623e-03
 	 1.62036747949692083725636848612339e-01 8.34015524385095519122046425763983e-01 3.94772766521245526555317084671515e-03 1.00574402208326320849740564966623e-03
 	 3.94772766521245526555317084671515e-03 1.62036747949692083725636848612339e-01 8.34015524385095519122046425763983e-01 1.00574402208326320849740564966623e-03
 	 3.94772766521245526555317084671515e-03 8.34015524385095519122046425763983e-01 1.62036747949692083725636848612339e-01 1.00574402208326320849740564966623e-03
 	 8.34015524385095519122046425763983e-01 1.62036747949692083725636848612339e-01 3.94772766521245526555317084671515e-03 1.00574402208326320849740564966623e-03
 	 8.34015524385095519122046425763983e-01 3.94772766521245526555317084671515e-03 1.62036747949692083725636848612339e-01 1.00574402208326320849740564966623e-03
 	 2.91854983858524597017947144195205e-01 2.93117988617291056266389581708154e-03 7.05213836255302539690603680355707e-01 1.14316177141174650684629643393464e-03
 	 2.91854983858524597017947144195205e-01 7.05213836255302539690603680355707e-01 2.93117988617291056266389581708154e-03 1.14316177141174650684629643393464e-03
 	 2.93117988617291056266389581708154e-03 2.91854983858524597017947144195205e-01 7.05213836255302539690603680355707e-01 1.14316177141174650684629643393464e-03
 	 2.93117988617291056266389581708154e-03 7.05213836255302539690603680355707e-01 2.91854983858524597017947144195205e-01 1.14316177141174650684629643393464e-03
 	 7.05213836255302539690603680355707e-01 2.91854983858524597017947144195205e-01 2.93117988617291056266389581708154e-03 1.14316177141174650684629643393464e-03
 	 7.05213836255302539690603680355707e-01 2.93117988617291056266389581708154e-03 2.91854983858524597017947144195205e-01 1.14316177141174650684629643393464e-03
 	 3.71878691749589151971377987138112e-01 2.77798098243856299988108204956916e-03 6.25343327267972370897552991664270e-01 1.18846132250825515901115903005802e-03
 	 3.71878691749589151971377987138112e-01 6.25343327267972370897552991664270e-01 2.77798098243856299988108204956916e-03 1.18846132250825515901115903005802e-03
 	 2.77798098243856299988108204956916e-03 3.71878691749589151971377987138112e-01 6.25343327267972370897552991664270e-01 1.18846132250825515901115903005802e-03
 	 2.77798098243856299988108204956916e-03 6.25343327267972370897552991664270e-01 3.71878691749589151971377987138112e-01 1.18846132250825515901115903005802e-03
 	 6.25343327267972370897552991664270e-01 3.71878691749589151971377987138112e-01 2.77798098243856299988108204956916e-03 1.18846132250825515901115903005802e-03
 	 6.25343327267972370897552991664270e-01 2.77798098243856299988108204956916e-03 3.71878691749589151971377987138112e-01 1.18846132250825515901115903005802e-03
 	 1.34969372652465280371103517609299e-01 3.43221858358502412977841800056922e-02 8.30708441511684547720051341457292e-01 2.90521894521092146138063760929526e-03
 	 1.34969372652465280371103517609299e-01 8.30708441511684547720051341457292e-01 3.43221858358502412977841800056922e-02 2.90521894521092146138063760929526e-03
 	 3.43221858358502412977841800056922e-02 1.34969372652465280371103517609299e-01 8.30708441511684547720051341457292e-01 2.90521894521092146138063760929526e-03
 	 3.43221858358502412977841800056922e-02 8.30708441511684547720051341457292e-01 1.34969372652465280371103517609299e-01 2.90521894521092146138063760929526e-03
 	 8.30708441511684547720051341457292e-01 1.34969372652465280371103517609299e-01 3.43221858358502412977841800056922e-02 2.90521894521092146138063760929526e-03
 	 8.30708441511684547720051341457292e-01 3.43221858358502412977841800056922e-02 1.34969372652465280371103517609299e-01 2.90521894521092146138063760929526e-03
 	 2.52453429906421944473038365686079e-01 1.08724039341924899604308052403212e-01 6.38822530751653183678229197539622e-01 6.32671519758657308757365811402451e-03
 	 2.52453429906421944473038365686079e-01 6.38822530751653183678229197539622e-01 1.08724039341924899604308052403212e-01 6.32671519758657308757365811402451e-03
 	 1.08724039341924899604308052403212e-01 2.52453429906421944473038365686079e-01 6.38822530751653183678229197539622e-01 6.32671519758657308757365811402451e-03
 	 1.08724039341924899604308052403212e-01 6.38822530751653183678229197539622e-01 2.52453429906421944473038365686079e-01 6.32671519758657308757365811402451e-03
 	 6.38822530751653183678229197539622e-01 2.52453429906421944473038365686079e-01 1.08724039341924899604308052403212e-01 6.32671519758657308757365811402451e-03
 	 6.38822530751653183678229197539622e-01 1.08724039341924899604308052403212e-01 2.52453429906421944473038365686079e-01 6.32671519758657308757365811402451e-03
 	 3.24235164108304496632939617484226e-01 1.49491079080454249833342927900048e-02 6.60815727983650069710108709841734e-01 2.72568622072012073376257035306480e-03
 	 3.24235164108304496632939617484226e-01 6.60815727983650069710108709841734e-01 1.49491079080454249833342927900048e-02 2.72568622072012073376257035306480e-03
 	 1.49491079080454249833342927900048e-02 3.24235164108304496632939617484226e-01 6.60815727983650069710108709841734e-01 2.72568622072012073376257035306480e-03
 	 1.49491079080454249833342927900048e-02 6.60815727983650069710108709841734e-01 3.24235164108304496632939617484226e-01 2.72568622072012073376257035306480e-03
 	 6.60815727983650069710108709841734e-01 3.24235164108304496632939617484226e-01 1.49491079080454249833342927900048e-02 2.72568622072012073376257035306480e-03
 	 6.60815727983650069710108709841734e-01 1.49491079080454249833342927900048e-02 3.24235164108304496632939617484226e-01 2.72568622072012073376257035306480e-03
 	 4.37416190646625679949721643424709e-01 3.73240771592634676401267768142134e-02 5.25259732194110928737984522740589e-01 4.52159159980516315441301244959504e-03
 	 4.37416190646625679949721643424709e-01 5.25259732194110928737984522740589e-01 3.73240771592634676401267768142134e-02 4.52159159980516315441301244959504e-03
 	 3.73240771592634676401267768142134e-02 4.37416190646625679949721643424709e-01 5.25259732194110928737984522740589e-01 4.52159159980516315441301244959504e-03
 	 3.73240771592634676401267768142134e-02 5.25259732194110928737984522740589e-01 4.37416190646625679949721643424709e-01 4.52159159980516315441301244959504e-03
 	 5.25259732194110928737984522740589e-01 4.37416190646625679949721643424709e-01 3.73240771592634676401267768142134e-02 4.52159159980516315441301244959504e-03
 	 5.25259732194110928737984522740589e-01 3.73240771592634676401267768142134e-02 4.37416190646625679949721643424709e-01 4.52159159980516315441301244959504e-03
 	 4.55998803661209317628077997142100e-01 2.96327193163695200642249183431431e-03 5.41037924407153814065907226904528e-01 1.28917427742942223602151674555216e-03
 	 4.55998803661209317628077997142100e-01 5.41037924407153814065907226904528e-01 2.96327193163695200642249183431431e-03 1.28917427742942223602151674555216e-03
 	 2.96327193163695200642249183431431e-03 4.55998803661209317628077997142100e-01 5.41037924407153814065907226904528e-01 1.28917427742942223602151674555216e-03
 	 2.96327193163695200642249183431431e-03 5.41037924407153814065907226904528e-01 4.55998803661209317628077997142100e-01 1.28917427742942223602151674555216e-03
 	 5.41037924407153814065907226904528e-01 4.55998803661209317628077997142100e-01 2.96327193163695200642249183431431e-03 1.28917427742942223602151674555216e-03
 	 5.41037924407153814065907226904528e-01 2.96327193163695200642249183431431e-03 4.55998803661209317628077997142100e-01 1.28917427742942223602151674555216e-03
 	 7.54872857005682990072514826351835e-02 4.20297816077350953195557181629738e-03 9.20309736138658185389260779629694e-01 8.16683918172780658716047863521226e-04
 	 7.54872857005682990072514826351835e-02 9.20309736138658185389260779629694e-01 4.20297816077350953195557181629738e-03 8.16683918172780658716047863521226e-04
 	 4.20297816077350953195557181629738e-03 7.54872857005682990072514826351835e-02 9.20309736138658185389260779629694e-01 8.16683918172780658716047863521226e-04
 	 4.20297816077350953195557181629738e-03 9.20309736138658185389260779629694e-01 7.54872857005682990072514826351835e-02 8.16683918172780658716047863521226e-04
 	 9.20309736138658185389260779629694e-01 7.54872857005682990072514826351835e-02 4.20297816077350953195557181629738e-03 8.16683918172780658716047863521226e-04
 	 9.20309736138658185389260779629694e-01 4.20297816077350953195557181629738e-03 7.54872857005682990072514826351835e-02 8.16683918172780658716047863521226e-04
 	 3.26054126652946585362968789922888e-01 1.14274187380454431139931159577827e-01 5.59671685966598886352585395798087e-01 6.94777932355222175436759712852108e-03
 	 3.26054126652946585362968789922888e-01 5.59671685966598886352585395798087e-01 1.14274187380454431139931159577827e-01 6.94777932355222175436759712852108e-03
 	 1.14274187380454431139931159577827e-01 3.26054126652946585362968789922888e-01 5.59671685966598886352585395798087e-01 6.94777932355222175436759712852108e-03
 	 1.14274187380454431139931159577827e-01 5.59671685966598886352585395798087e-01 3.26054126652946585362968789922888e-01 6.94777932355222175436759712852108e-03
 	 5.59671685966598886352585395798087e-01 3.26054126652946585362968789922888e-01 1.14274187380454431139931159577827e-01 6.94777932355222175436759712852108e-03
 	 5.59671685966598886352585395798087e-01 1.14274187380454431139931159577827e-01 3.26054126652946585362968789922888e-01 6.94777932355222175436759712852108e-03
 	 4.01199588505488202727633506583516e-01 1.12888085312921521152773607354902e-01 4.85912326181590303875168501690496e-01 7.09861793949031778111491419736012e-03
 	 4.01199588505488202727633506583516e-01 4.85912326181590303875168501690496e-01 1.12888085312921521152773607354902e-01 7.09861793949031778111491419736012e-03
 	 1.12888085312921521152773607354902e-01 4.01199588505488202727633506583516e-01 4.85912326181590303875168501690496e-01 7.09861793949031778111491419736012e-03
 	 1.12888085312921521152773607354902e-01 4.85912326181590303875168501690496e-01 4.01199588505488202727633506583516e-01 7.09861793949031778111491419736012e-03
 	 4.85912326181590303875168501690496e-01 4.01199588505488202727633506583516e-01 1.12888085312921521152773607354902e-01 7.09861793949031778111491419736012e-03
 	 4.85912326181590303875168501690496e-01 1.12888085312921521152773607354902e-01 4.01199588505488202727633506583516e-01 7.09861793949031778111491419736012e-03
 	 2.68760660341264001615968481928576e-01 1.60196677899755890450705919647589e-01 5.71042661758980107933325598423835e-01 7.69192034857791619162359353367719e-03
 	 2.68760660341264001615968481928576e-01 5.71042661758980107933325598423835e-01 1.60196677899755890450705919647589e-01 7.69192034857791619162359353367719e-03
 	 1.60196677899755890450705919647589e-01 2.68760660341264001615968481928576e-01 5.71042661758980107933325598423835e-01 7.69192034857791619162359353367719e-03
 	 1.60196677899755890450705919647589e-01 5.71042661758980107933325598423835e-01 2.68760660341264001615968481928576e-01 7.69192034857791619162359353367719e-03
 	 5.71042661758980107933325598423835e-01 2.68760660341264001615968481928576e-01 1.60196677899755890450705919647589e-01 7.69192034857791619162359353367719e-03
 	 5.71042661758980107933325598423835e-01 1.60196677899755890450705919647589e-01 2.68760660341264001615968481928576e-01 7.69192034857791619162359353367719e-03
 	 4.06014702573877173108485294505954e-01 1.51551286402894190563639398305895e-02 5.78830168785833376610128198080929e-01 2.92521901872410490172415897802694e-03
 	 4.06014702573877173108485294505954e-01 5.78830168785833376610128198080929e-01 1.51551286402894190563639398305895e-02 2.92521901872410490172415897802694e-03
 	 1.51551286402894190563639398305895e-02 4.06014702573877173108485294505954e-01 5.78830168785833376610128198080929e-01 2.92521901872410490172415897802694e-03
 	 1.51551286402894190563639398305895e-02 5.78830168785833376610128198080929e-01 4.06014702573877173108485294505954e-01 2.92521901872410490172415897802694e-03
 	 5.78830168785833376610128198080929e-01 4.06014702573877173108485294505954e-01 1.51551286402894190563639398305895e-02 2.92521901872410490172415897802694e-03
 	 5.78830168785833376610128198080929e-01 1.51551286402894190563639398305895e-02 4.06014702573877173108485294505954e-01 2.92521901872410490172415897802694e-03
 	 3.83510346834340154487108520697802e-01 7.00421815004378944813367979804752e-02 5.46447471665221895520403450063895e-01 6.05669699648577267159232917492773e-03
 	 3.83510346834340154487108520697802e-01 5.46447471665221895520403450063895e-01 7.00421815004378944813367979804752e-02 6.05669699648577267159232917492773e-03
 	 7.00421815004378944813367979804752e-02 3.83510346834340154487108520697802e-01 5.46447471665221895520403450063895e-01 6.05669699648577267159232917492773e-03
 	 7.00421815004378944813367979804752e-02 5.46447471665221895520403450063895e-01 3.83510346834340154487108520697802e-01 6.05669699648577267159232917492773e-03
 	 5.46447471665221895520403450063895e-01 3.83510346834340154487108520697802e-01 7.00421815004378944813367979804752e-02 6.05669699648577267159232917492773e-03
 	 5.46447471665221895520403450063895e-01 7.00421815004378944813367979804752e-02 3.83510346834340154487108520697802e-01 6.05669699648577267159232917492773e-03
 	 1.64470646369431552913376037849957e-02 3.44298850158080132349835977834118e-03 9.80109946861476122315082193381386e-01 3.33705633118837362901393239766890e-04
 	 1.64470646369431552913376037849957e-02 9.80109946861476122315082193381386e-01 3.44298850158080132349835977834118e-03 3.33705633118837362901393239766890e-04
 	 3.44298850158080132349835977834118e-03 1.64470646369431552913376037849957e-02 9.80109946861476122315082193381386e-01 3.33705633118837362901393239766890e-04
 	 3.44298850158080132349835977834118e-03 9.80109946861476122315082193381386e-01 1.64470646369431552913376037849957e-02 3.33705633118837362901393239766890e-04
 	 9.80109946861476122315082193381386e-01 1.64470646369431552913376037849957e-02 3.44298850158080132349835977834118e-03 3.33705633118837362901393239766890e-04
 	 9.80109946861476122315082193381386e-01 3.44298850158080132349835977834118e-03 1.64470646369431552913376037849957e-02 3.33705633118837362901393239766890e-04
 	 3.54297786162694750000667909262120e-01 3.76676144786773081651887196130701e-02 6.08034599358627914078567755495897e-01 4.52946892094883285517781246198865e-03
 	 3.54297786162694750000667909262120e-01 6.08034599358627914078567755495897e-01 3.76676144786773081651887196130701e-02 4.52946892094883285517781246198865e-03
 	 3.76676144786773081651887196130701e-02 3.54297786162694750000667909262120e-01 6.08034599358627914078567755495897e-01 4.52946892094883285517781246198865e-03
 	 3.76676144786773081651887196130701e-02 6.08034599358627914078567755495897e-01 3.54297786162694750000667909262120e-01 4.52946892094883285517781246198865e-03
 	 6.08034599358627914078567755495897e-01 3.54297786162694750000667909262120e-01 3.76676144786773081651887196130701e-02 4.52946892094883285517781246198865e-03
 	 6.08034599358627914078567755495897e-01 3.76676144786773081651887196130701e-02 3.54297786162694750000667909262120e-01 4.52946892094883285517781246198865e-03
 	 3.41995175798316008997090875709546e-01 1.65998426676715687966279233478417e-01 4.92006397524968330792205506440951e-01 8.40253741431977452247537030416424e-03
 	 3.41995175798316008997090875709546e-01 4.92006397524968330792205506440951e-01 1.65998426676715687966279233478417e-01 8.40253741431977452247537030416424e-03
 	 1.65998426676715687966279233478417e-01 3.41995175798316008997090875709546e-01 4.92006397524968330792205506440951e-01 8.40253741431977452247537030416424e-03
 	 1.65998426676715687966279233478417e-01 4.92006397524968330792205506440951e-01 3.41995175798316008997090875709546e-01 8.40253741431977452247537030416424e-03
 	 4.92006397524968330792205506440951e-01 3.41995175798316008997090875709546e-01 1.65998426676715687966279233478417e-01 8.40253741431977452247537030416424e-03
 	 4.92006397524968330792205506440951e-01 1.65998426676715687966279233478417e-01 3.41995175798316008997090875709546e-01 8.40253741431977452247537030416424e-03
 	 1.15288891079278379980799229542754e-01 1.20325311111651837847613677467962e-02 8.72678577809556377253841219499009e-01 1.81097185240341237294492415799141e-03
 	 1.15288891079278379980799229542754e-01 8.72678577809556377253841219499009e-01 1.20325311111651837847613677467962e-02 1.81097185240341237294492415799141e-03
 	 1.20325311111651837847613677467962e-02 1.15288891079278379980799229542754e-01 8.72678577809556377253841219499009e-01 1.81097185240341237294492415799141e-03
 	 1.20325311111651837847613677467962e-02 8.72678577809556377253841219499009e-01 1.15288891079278379980799229542754e-01 1.81097185240341237294492415799141e-03
 	 8.72678577809556377253841219499009e-01 1.15288891079278379980799229542754e-01 1.20325311111651837847613677467962e-02 1.81097185240341237294492415799141e-03
 	 8.72678577809556377253841219499009e-01 1.20325311111651837847613677467962e-02 1.15288891079278379980799229542754e-01 1.81097185240341237294492415799141e-03
 	 1.16528101812402543058233561623638e-01 2.98221681520129382886308277988974e-04 8.83173676506077254266813270078273e-01 2.92285663182826564027161353465090e-04
 	 1.16528101812402543058233561623638e-01 8.83173676506077254266813270078273e-01 2.98221681520129382886308277988974e-04 2.92285663182826564027161353465090e-04
 	 2.98221681520129382886308277988974e-04 1.16528101812402543058233561623638e-01 8.83173676506077254266813270078273e-01 2.92285663182826564027161353465090e-04
 	 2.98221681520129382886308277988974e-04 8.83173676506077254266813270078273e-01 1.16528101812402543058233561623638e-01 2.92285663182826564027161353465090e-04
 	 8.83173676506077254266813270078273e-01 1.16528101812402543058233561623638e-01 2.98221681520129382886308277988974e-04 2.92285663182826564027161353465090e-04
 	 8.83173676506077254266813270078273e-01 2.98221681520129382886308277988974e-04 1.16528101812402543058233561623638e-01 2.92285663182826564027161353465090e-04
 	 ];
 
 	 case  39 

 	 % ALG. DEG.:   39
 	 % PTS CARD.:  282
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.6e-15  

 	 xyw_bar=[
 	 4.72409482150556669921570573933423e-01 4.72409482150556669921570573933423e-01 5.51810356988866601568588521331549e-02 3.80047297760065716162869442484862e-03
 	 4.72409482150556669921570573933423e-01 5.51810356988866601568588521331549e-02 4.72409482150556669921570573933423e-01 3.80047297760065716162869442484862e-03
 	 5.51810356988866601568588521331549e-02 4.72409482150556669921570573933423e-01 4.72409482150556669921570573933423e-01 3.80047297760065716162869442484862e-03
 	 4.57507968673824261252036649239017e-01 4.57507968673824261252036649239017e-01 8.49840626523514774959267015219666e-02 4.80903574016860405754281160284336e-03
 	 4.57507968673824261252036649239017e-01 8.49840626523514774959267015219666e-02 4.57507968673824261252036649239017e-01 4.80903574016860405754281160284336e-03
 	 8.49840626523514774959267015219666e-02 4.57507968673824261252036649239017e-01 4.57507968673824261252036649239017e-01 4.80903574016860405754281160284336e-03
 	 3.53847291916883299744966961952741e-01 3.53847291916883299744966961952741e-01 2.92305416166233400510066076094517e-01 8.07899454534733926780454282834398e-03
 	 3.53847291916883299744966961952741e-01 2.92305416166233400510066076094517e-01 3.53847291916883299744966961952741e-01 8.07899454534733926780454282834398e-03
 	 2.92305416166233400510066076094517e-01 3.53847291916883299744966961952741e-01 3.53847291916883299744966961952741e-01 8.07899454534733926780454282834398e-03
 	 4.99106149860298997644747487356653e-01 4.99106149860298997644747487356653e-01 1.78770027940200471050502528669313e-03 8.38476681829170055262889782454749e-04
 	 4.99106149860298997644747487356653e-01 1.78770027940200471050502528669313e-03 4.99106149860298997644747487356653e-01 8.38476681829170055262889782454749e-04
 	 1.78770027940200471050502528669313e-03 4.99106149860298997644747487356653e-01 4.99106149860298997644747487356653e-01 8.38476681829170055262889782454749e-04
 	 1.13331658196365314683617953050998e-01 1.13331658196365314683617953050998e-01 7.73336683607269370632764093898004e-01 3.70893562137618012022888258627518e-03
 	 1.13331658196365314683617953050998e-01 7.73336683607269370632764093898004e-01 1.13331658196365314683617953050998e-01 3.70893562137618012022888258627518e-03
 	 7.73336683607269370632764093898004e-01 1.13331658196365314683617953050998e-01 1.13331658196365314683617953050998e-01 3.70893562137618012022888258627518e-03
 	 1.57787047228343108029591235208500e-02 1.57787047228343108029591235208500e-02 9.68442590554331350638506137329387e-01 6.68606911689347362982849265478080e-04
 	 1.57787047228343108029591235208500e-02 9.68442590554331350638506137329387e-01 1.57787047228343108029591235208500e-02 6.68606911689347362982849265478080e-04
 	 9.68442590554331350638506137329387e-01 1.57787047228343108029591235208500e-02 1.57787047228343108029591235208500e-02 6.68606911689347362982849265478080e-04
 	 1.64009184766605586869303579078405e-01 1.64009184766605586869303579078405e-01 6.71981630466788826261392841843190e-01 5.80353791960355920587222300355279e-03
 	 1.64009184766605586869303579078405e-01 6.71981630466788826261392841843190e-01 1.64009184766605586869303579078405e-01 5.80353791960355920587222300355279e-03
 	 6.71981630466788826261392841843190e-01 1.64009184766605586869303579078405e-01 1.64009184766605586869303579078405e-01 5.80353791960355920587222300355279e-03
 	 4.08471560729133986722416693737614e-01 4.08471560729133986722416693737614e-01 1.83056878541732026555166612524772e-01 7.69920663227626964064675973986596e-03
 	 4.08471560729133986722416693737614e-01 1.83056878541732026555166612524772e-01 4.08471560729133986722416693737614e-01 7.69920663227626964064675973986596e-03
 	 1.83056878541732026555166612524772e-01 4.08471560729133986722416693737614e-01 4.08471560729133986722416693737614e-01 7.69920663227626964064675973986596e-03
 	 4.36541655107956616532760563131887e-01 4.36541655107956616532760563131887e-01 1.26916689784086766934478873736225e-01 6.77650321808550681196292586605523e-03
 	 4.36541655107956616532760563131887e-01 1.26916689784086766934478873736225e-01 4.36541655107956616532760563131887e-01 6.77650321808550681196292586605523e-03
 	 1.26916689784086766934478873736225e-01 4.36541655107956616532760563131887e-01 4.36541655107956616532760563131887e-01 6.77650321808550681196292586605523e-03
 	 3.70326513393935824458580441387312e-02 3.70326513393935824458580441387312e-02 9.25934697321212807352708296093624e-01 1.59204963206925577054451359515497e-03
 	 3.70326513393935824458580441387312e-02 9.25934697321212807352708296093624e-01 3.70326513393935824458580441387312e-02 1.59204963206925577054451359515497e-03
 	 9.25934697321212807352708296093624e-01 3.70326513393935824458580441387312e-02 3.70326513393935824458580441387312e-02 1.59204963206925577054451359515497e-03
 	 2.11731749565185534134315048504504e-01 2.11731749565185534134315048504504e-01 5.76536500869628931731369902990991e-01 7.12556383414926757663421241772994e-03
 	 2.11731749565185534134315048504504e-01 5.76536500869628931731369902990991e-01 2.11731749565185534134315048504504e-01 7.12556383414926757663421241772994e-03
 	 5.76536500869628931731369902990991e-01 2.11731749565185534134315048504504e-01 2.11731749565185534134315048504504e-01 7.12556383414926757663421241772994e-03
 	 2.86957288459068593500234101156821e-01 2.86957288459068593500234101156821e-01 4.26085423081862812999531797686359e-01 8.72872850981075767973216272821446e-03
 	 2.86957288459068593500234101156821e-01 4.26085423081862812999531797686359e-01 2.86957288459068593500234101156821e-01 8.72872850981075767973216272821446e-03
 	 4.26085423081862812999531797686359e-01 2.86957288459068593500234101156821e-01 2.86957288459068593500234101156821e-01 8.72872850981075767973216272821446e-03
 	 8.06765828829424935797476337029366e-02 8.06765828829424935797476337029366e-02 8.38646834234115012840504732594127e-01 3.70768536806530225533040656671346e-03
 	 8.06765828829424935797476337029366e-02 8.38646834234115012840504732594127e-01 8.06765828829424935797476337029366e-02 3.70768536806530225533040656671346e-03
 	 8.38646834234115012840504732594127e-01 8.06765828829424935797476337029366e-02 8.06765828829424935797476337029366e-02 3.70768536806530225533040656671346e-03
 	 3.64321992072988865701832494892187e-03 3.64321992072988865701832494892187e-03 9.92713560158540175848429498728365e-01 1.74907781553333848377496106962781e-04
 	 3.64321992072988865701832494892187e-03 9.92713560158540175848429498728365e-01 3.64321992072988865701832494892187e-03 1.74907781553333848377496106962781e-04
 	 9.92713560158540175848429498728365e-01 3.64321992072988865701832494892187e-03 3.64321992072988865701832494892187e-03 1.74907781553333848377496106962781e-04
 	 2.38275208584557002255976954074868e-01 4.37448243826125699601492513579615e-03 7.57350308977181807534861945896409e-01 7.82403032839563842074093180656291e-04
 	 2.38275208584557002255976954074868e-01 7.57350308977181807534861945896409e-01 4.37448243826125699601492513579615e-03 7.82403032839563842074093180656291e-04
 	 4.37448243826125699601492513579615e-03 2.38275208584557002255976954074868e-01 7.57350308977181807534861945896409e-01 7.82403032839563842074093180656291e-04
 	 4.37448243826125699601492513579615e-03 7.57350308977181807534861945896409e-01 2.38275208584557002255976954074868e-01 7.82403032839563842074093180656291e-04
 	 7.57350308977181807534861945896409e-01 2.38275208584557002255976954074868e-01 4.37448243826125699601492513579615e-03 7.82403032839563842074093180656291e-04
 	 7.57350308977181807534861945896409e-01 4.37448243826125699601492513579615e-03 2.38275208584557002255976954074868e-01 7.82403032839563842074093180656291e-04
 	 5.02290201314918416386490207514726e-01 2.31437075889000587469723768663243e-01 2.66272722796080996143786023822031e-01 5.42592587895245666990140520624664e-03
 	 5.02290201314918416386490207514726e-01 2.66272722796080996143786023822031e-01 2.31437075889000587469723768663243e-01 5.42592587895245666990140520624664e-03
 	 2.31437075889000587469723768663243e-01 5.02290201314918416386490207514726e-01 2.66272722796080996143786023822031e-01 5.42592587895245666990140520624664e-03
 	 2.31437075889000587469723768663243e-01 2.66272722796080996143786023822031e-01 5.02290201314918416386490207514726e-01 5.42592587895245666990140520624664e-03
 	 2.66272722796080996143786023822031e-01 5.02290201314918416386490207514726e-01 2.31437075889000587469723768663243e-01 5.42592587895245666990140520624664e-03
 	 2.66272722796080996143786023822031e-01 2.31437075889000587469723768663243e-01 5.02290201314918416386490207514726e-01 5.42592587895245666990140520624664e-03
 	 3.50682734157158282339850075004506e-01 2.36099447436519921383890618926671e-01 4.13217818406321768520683690439910e-01 6.43356498322091106129017035186735e-03
 	 3.50682734157158282339850075004506e-01 4.13217818406321768520683690439910e-01 2.36099447436519921383890618926671e-01 6.43356498322091106129017035186735e-03
 	 2.36099447436519921383890618926671e-01 3.50682734157158282339850075004506e-01 4.13217818406321768520683690439910e-01 6.43356498322091106129017035186735e-03
 	 2.36099447436519921383890618926671e-01 4.13217818406321768520683690439910e-01 3.50682734157158282339850075004506e-01 6.43356498322091106129017035186735e-03
 	 4.13217818406321768520683690439910e-01 3.50682734157158282339850075004506e-01 2.36099447436519921383890618926671e-01 6.43356498322091106129017035186735e-03
 	 4.13217818406321768520683690439910e-01 2.36099447436519921383890618926671e-01 3.50682734157158282339850075004506e-01 6.43356498322091106129017035186735e-03
 	 2.77808917719284009795188694624812e-01 2.66233974789171091296369198175853e-03 7.19528742532824283628656303335447e-01 7.64510637631669507340015368157538e-04
 	 2.77808917719284009795188694624812e-01 7.19528742532824283628656303335447e-01 2.66233974789171091296369198175853e-03 7.64510637631669507340015368157538e-04
 	 2.66233974789171091296369198175853e-03 2.77808917719284009795188694624812e-01 7.19528742532824283628656303335447e-01 7.64510637631669507340015368157538e-04
 	 2.66233974789171091296369198175853e-03 7.19528742532824283628656303335447e-01 2.77808917719284009795188694624812e-01 7.64510637631669507340015368157538e-04
 	 7.19528742532824283628656303335447e-01 2.77808917719284009795188694624812e-01 2.66233974789171091296369198175853e-03 7.64510637631669507340015368157538e-04
 	 7.19528742532824283628656303335447e-01 2.66233974789171091296369198175853e-03 2.77808917719284009795188694624812e-01 7.64510637631669507340015368157538e-04
 	 3.21203482682616781040962905535707e-01 2.07439611934945505877792015780869e-01 4.71356905382437685325669463054510e-01 6.25948868102638340815691009311195e-03
 	 3.21203482682616781040962905535707e-01 4.71356905382437685325669463054510e-01 2.07439611934945505877792015780869e-01 6.25948868102638340815691009311195e-03
 	 2.07439611934945505877792015780869e-01 3.21203482682616781040962905535707e-01 4.71356905382437685325669463054510e-01 6.25948868102638340815691009311195e-03
 	 2.07439611934945505877792015780869e-01 4.71356905382437685325669463054510e-01 3.21203482682616781040962905535707e-01 6.25948868102638340815691009311195e-03
 	 4.71356905382437685325669463054510e-01 3.21203482682616781040962905535707e-01 2.07439611934945505877792015780869e-01 6.25948868102638340815691009311195e-03
 	 4.71356905382437685325669463054510e-01 2.07439611934945505877792015780869e-01 3.21203482682616781040962905535707e-01 6.25948868102638340815691009311195e-03
 	 4.57424216852982068459709807939362e-01 1.19091524767886494662327834248572e-02 5.30666630670229233501800081285182e-01 2.16208740689454587124984641377523e-03
 	 4.57424216852982068459709807939362e-01 5.30666630670229233501800081285182e-01 1.19091524767886494662327834248572e-02 2.16208740689454587124984641377523e-03
 	 1.19091524767886494662327834248572e-02 4.57424216852982068459709807939362e-01 5.30666630670229233501800081285182e-01 2.16208740689454587124984641377523e-03
 	 1.19091524767886494662327834248572e-02 5.30666630670229233501800081285182e-01 4.57424216852982068459709807939362e-01 2.16208740689454587124984641377523e-03
 	 5.30666630670229233501800081285182e-01 4.57424216852982068459709807939362e-01 1.19091524767886494662327834248572e-02 2.16208740689454587124984641377523e-03
 	 5.30666630670229233501800081285182e-01 1.19091524767886494662327834248572e-02 4.57424216852982068459709807939362e-01 2.16208740689454587124984641377523e-03
 	 1.91038342852184600539899861360027e-01 2.15696233889989567519829272157494e-03 8.06804694808915479065092313248897e-01 6.90853978322279694765373214693227e-04
 	 1.91038342852184600539899861360027e-01 8.06804694808915479065092313248897e-01 2.15696233889989567519829272157494e-03 6.90853978322279694765373214693227e-04
 	 2.15696233889989567519829272157494e-03 1.91038342852184600539899861360027e-01 8.06804694808915479065092313248897e-01 6.90853978322279694765373214693227e-04
 	 2.15696233889989567519829272157494e-03 8.06804694808915479065092313248897e-01 1.91038342852184600539899861360027e-01 6.90853978322279694765373214693227e-04
 	 8.06804694808915479065092313248897e-01 1.91038342852184600539899861360027e-01 2.15696233889989567519829272157494e-03 6.90853978322279694765373214693227e-04
 	 8.06804694808915479065092313248897e-01 2.15696233889989567519829272157494e-03 1.91038342852184600539899861360027e-01 6.90853978322279694765373214693227e-04
 	 2.06351940732836303116215503905551e-01 1.07257493751645838209185512823751e-01 6.86390565515517914185750214528525e-01 4.38109608570821408568551902362742e-03
 	 2.06351940732836303116215503905551e-01 6.86390565515517914185750214528525e-01 1.07257493751645838209185512823751e-01 4.38109608570821408568551902362742e-03
 	 1.07257493751645838209185512823751e-01 2.06351940732836303116215503905551e-01 6.86390565515517914185750214528525e-01 4.38109608570821408568551902362742e-03
 	 1.07257493751645838209185512823751e-01 6.86390565515517914185750214528525e-01 2.06351940732836303116215503905551e-01 4.38109608570821408568551902362742e-03
 	 6.86390565515517914185750214528525e-01 2.06351940732836303116215503905551e-01 1.07257493751645838209185512823751e-01 4.38109608570821408568551902362742e-03
 	 6.86390565515517914185750214528525e-01 1.07257493751645838209185512823751e-01 2.06351940732836303116215503905551e-01 4.38109608570821408568551902362742e-03
 	 2.61238382787471912216403779893881e-01 1.12438393291482544023018874668196e-01 6.26323223921045557638365153252380e-01 4.89773907079152012733480603401404e-03
 	 2.61238382787471912216403779893881e-01 6.26323223921045557638365153252380e-01 1.12438393291482544023018874668196e-01 4.89773907079152012733480603401404e-03
 	 1.12438393291482544023018874668196e-01 2.61238382787471912216403779893881e-01 6.26323223921045557638365153252380e-01 4.89773907079152012733480603401404e-03
 	 1.12438393291482544023018874668196e-01 6.26323223921045557638365153252380e-01 2.61238382787471912216403779893881e-01 4.89773907079152012733480603401404e-03
 	 6.26323223921045557638365153252380e-01 2.61238382787471912216403779893881e-01 1.12438393291482544023018874668196e-01 4.89773907079152012733480603401404e-03
 	 6.26323223921045557638365153252380e-01 1.12438393291482544023018874668196e-01 2.61238382787471912216403779893881e-01 4.89773907079152012733480603401404e-03
 	 1.59388899623120305903967164340429e-01 1.14090324996719685857193837819068e-01 7.26520775380160022116626805654960e-01 4.43098965089405282674617225779912e-03
 	 1.59388899623120305903967164340429e-01 7.26520775380160022116626805654960e-01 1.14090324996719685857193837819068e-01 4.43098965089405282674617225779912e-03
 	 1.14090324996719685857193837819068e-01 1.59388899623120305903967164340429e-01 7.26520775380160022116626805654960e-01 4.43098965089405282674617225779912e-03
 	 1.14090324996719685857193837819068e-01 7.26520775380160022116626805654960e-01 1.59388899623120305903967164340429e-01 4.43098965089405282674617225779912e-03
 	 7.26520775380160022116626805654960e-01 1.59388899623120305903967164340429e-01 1.14090324996719685857193837819068e-01 4.43098965089405282674617225779912e-03
 	 7.26520775380160022116626805654960e-01 1.14090324996719685857193837819068e-01 1.59388899623120305903967164340429e-01 4.43098965089405282674617225779912e-03
 	 3.98869513224066885026530826507951e-01 6.19448419160624624835165263903036e-02 5.39185644859870638612164839287288e-01 4.69987842862794064774378810511735e-03
 	 3.98869513224066885026530826507951e-01 5.39185644859870638612164839287288e-01 6.19448419160624624835165263903036e-02 4.69987842862794064774378810511735e-03
 	 6.19448419160624624835165263903036e-02 3.98869513224066885026530826507951e-01 5.39185644859870638612164839287288e-01 4.69987842862794064774378810511735e-03
 	 6.19448419160624624835165263903036e-02 5.39185644859870638612164839287288e-01 3.98869513224066885026530826507951e-01 4.69987842862794064774378810511735e-03
 	 5.39185644859870638612164839287288e-01 3.98869513224066885026530826507951e-01 6.19448419160624624835165263903036e-02 4.69987842862794064774378810511735e-03
 	 5.39185644859870638612164839287288e-01 6.19448419160624624835165263903036e-02 3.98869513224066885026530826507951e-01 4.69987842862794064774378810511735e-03
 	 3.12272579273360884055676933712675e-01 1.21962883225284618449180129573506e-01 5.65764537501354469739567321084905e-01 5.69494715896686973244378293657064e-03
 	 3.12272579273360884055676933712675e-01 5.65764537501354469739567321084905e-01 1.21962883225284618449180129573506e-01 5.69494715896686973244378293657064e-03
 	 1.21962883225284618449180129573506e-01 3.12272579273360884055676933712675e-01 5.65764537501354469739567321084905e-01 5.69494715896686973244378293657064e-03
 	 1.21962883225284618449180129573506e-01 5.65764537501354469739567321084905e-01 3.12272579273360884055676933712675e-01 5.69494715896686973244378293657064e-03
 	 5.65764537501354469739567321084905e-01 3.12272579273360884055676933712675e-01 1.21962883225284618449180129573506e-01 5.69494715896686973244378293657064e-03
 	 5.65764537501354469739567321084905e-01 1.21962883225284618449180129573506e-01 3.12272579273360884055676933712675e-01 5.69494715896686973244378293657064e-03
 	 3.64436262358476370515347753098467e-01 3.86447963475402486710486016363575e-02 5.96918941293983373874709741357947e-01 3.72322998874882434353073001886969e-03
 	 3.64436262358476370515347753098467e-01 5.96918941293983373874709741357947e-01 3.86447963475402486710486016363575e-02 3.72322998874882434353073001886969e-03
 	 3.86447963475402486710486016363575e-02 3.64436262358476370515347753098467e-01 5.96918941293983373874709741357947e-01 3.72322998874882434353073001886969e-03
 	 3.86447963475402486710486016363575e-02 5.96918941293983373874709741357947e-01 3.64436262358476370515347753098467e-01 3.72322998874882434353073001886969e-03
 	 5.96918941293983373874709741357947e-01 3.64436262358476370515347753098467e-01 3.86447963475402486710486016363575e-02 3.72322998874882434353073001886969e-03
 	 5.96918941293983373874709741357947e-01 3.86447963475402486710486016363575e-02 3.64436262358476370515347753098467e-01 3.72322998874882434353073001886969e-03
 	 2.30564834240443161661460180766881e-01 1.72339717685665617941115357325543e-02 7.52201193990990280013875235454179e-01 2.27110662202624404709672134572429e-03
 	 2.30564834240443161661460180766881e-01 7.52201193990990280013875235454179e-01 1.72339717685665617941115357325543e-02 2.27110662202624404709672134572429e-03
 	 1.72339717685665617941115357325543e-02 2.30564834240443161661460180766881e-01 7.52201193990990280013875235454179e-01 2.27110662202624404709672134572429e-03
 	 1.72339717685665617941115357325543e-02 7.52201193990990280013875235454179e-01 2.30564834240443161661460180766881e-01 2.27110662202624404709672134572429e-03
 	 7.52201193990990280013875235454179e-01 2.30564834240443161661460180766881e-01 1.72339717685665617941115357325543e-02 2.27110662202624404709672134572429e-03
 	 7.52201193990990280013875235454179e-01 1.72339717685665617941115357325543e-02 2.30564834240443161661460180766881e-01 2.27110662202624404709672134572429e-03
 	 3.92682833818939619474619462380360e-02 1.45623703030592060309045265853456e-02 9.46169346315046899675849090272095e-01 9.50185655147837873561733612604030e-04
 	 3.92682833818939619474619462380360e-02 9.46169346315046899675849090272095e-01 1.45623703030592060309045265853456e-02 9.50185655147837873561733612604030e-04
 	 1.45623703030592060309045265853456e-02 3.92682833818939619474619462380360e-02 9.46169346315046899675849090272095e-01 9.50185655147837873561733612604030e-04
 	 1.45623703030592060309045265853456e-02 9.46169346315046899675849090272095e-01 3.92682833818939619474619462380360e-02 9.50185655147837873561733612604030e-04
 	 9.46169346315046899675849090272095e-01 3.92682833818939619474619462380360e-02 1.45623703030592060309045265853456e-02 9.50185655147837873561733612604030e-04
 	 9.46169346315046899675849090272095e-01 1.45623703030592060309045265853456e-02 3.92682833818939619474619462380360e-02 9.50185655147837873561733612604030e-04
 	 3.58257733547722723166373270942131e-01 1.54161109997349499156626961848815e-01 4.87581156454927777676999767209054e-01 7.43310063057054694335423761231141e-03
 	 3.58257733547722723166373270942131e-01 4.87581156454927777676999767209054e-01 1.54161109997349499156626961848815e-01 7.43310063057054694335423761231141e-03
 	 1.54161109997349499156626961848815e-01 3.58257733547722723166373270942131e-01 4.87581156454927777676999767209054e-01 7.43310063057054694335423761231141e-03
 	 1.54161109997349499156626961848815e-01 4.87581156454927777676999767209054e-01 3.58257733547722723166373270942131e-01 7.43310063057054694335423761231141e-03
 	 4.87581156454927777676999767209054e-01 3.58257733547722723166373270942131e-01 1.54161109997349499156626961848815e-01 7.43310063057054694335423761231141e-03
 	 4.87581156454927777676999767209054e-01 1.54161109997349499156626961848815e-01 3.58257733547722723166373270942131e-01 7.43310063057054694335423761231141e-03
 	 3.80507882548312525994305133281159e-01 1.01140130678948808595762898221437e-01 5.18351986772738637654356352868490e-01 6.18643053374187939369432953640171e-03
 	 3.80507882548312525994305133281159e-01 5.18351986772738637654356352868490e-01 1.01140130678948808595762898221437e-01 6.18643053374187939369432953640171e-03
 	 1.01140130678948808595762898221437e-01 3.80507882548312525994305133281159e-01 5.18351986772738637654356352868490e-01 6.18643053374187939369432953640171e-03
 	 1.01140130678948808595762898221437e-01 5.18351986772738637654356352868490e-01 3.80507882548312525994305133281159e-01 6.18643053374187939369432953640171e-03
 	 5.18351986772738637654356352868490e-01 3.80507882548312525994305133281159e-01 1.01140130678948808595762898221437e-01 6.18643053374187939369432953640171e-03
 	 5.18351986772738637654356352868490e-01 1.01140130678948808595762898221437e-01 3.80507882548312525994305133281159e-01 6.18643053374187939369432953640171e-03
 	 1.31886575586608933985388603105093e-01 7.32858166481221984245308931349427e-02 7.94827607765268839834504888131050e-01 3.83742228174385139466417982134772e-03
 	 1.31886575586608933985388603105093e-01 7.94827607765268839834504888131050e-01 7.32858166481221984245308931349427e-02 3.83742228174385139466417982134772e-03
 	 7.32858166481221984245308931349427e-02 1.31886575586608933985388603105093e-01 7.94827607765268839834504888131050e-01 3.83742228174385139466417982134772e-03
 	 7.32858166481221984245308931349427e-02 7.94827607765268839834504888131050e-01 1.31886575586608933985388603105093e-01 3.83742228174385139466417982134772e-03
 	 7.94827607765268839834504888131050e-01 1.31886575586608933985388603105093e-01 7.32858166481221984245308931349427e-02 3.83742228174385139466417982134772e-03
 	 7.94827607765268839834504888131050e-01 7.32858166481221984245308931349427e-02 1.31886575586608933985388603105093e-01 3.83742228174385139466417982134772e-03
 	 1.72630255068886018232632295621443e-01 1.35174633972146174959449993480121e-02 8.13852281533899324372782757563982e-01 1.89587296575307305036839355949496e-03
 	 1.72630255068886018232632295621443e-01 8.13852281533899324372782757563982e-01 1.35174633972146174959449993480121e-02 1.89587296575307305036839355949496e-03
 	 1.35174633972146174959449993480121e-02 1.72630255068886018232632295621443e-01 8.13852281533899324372782757563982e-01 1.89587296575307305036839355949496e-03
 	 1.35174633972146174959449993480121e-02 8.13852281533899324372782757563982e-01 1.72630255068886018232632295621443e-01 1.89587296575307305036839355949496e-03
 	 8.13852281533899324372782757563982e-01 1.72630255068886018232632295621443e-01 1.35174633972146174959449993480121e-02 1.89587296575307305036839355949496e-03
 	 8.13852281533899324372782757563982e-01 1.35174633972146174959449993480121e-02 1.72630255068886018232632295621443e-01 1.89587296575307305036839355949496e-03
 	 7.07756358900085702501314699475188e-02 4.31486463812221776592537025862839e-02 8.86075717728769252090614827466197e-01 2.31587716863235247924390769469483e-03
 	 7.07756358900085702501314699475188e-02 8.86075717728769252090614827466197e-01 4.31486463812221776592537025862839e-02 2.31587716863235247924390769469483e-03
 	 4.31486463812221776592537025862839e-02 7.07756358900085702501314699475188e-02 8.86075717728769252090614827466197e-01 2.31587716863235247924390769469483e-03
 	 4.31486463812221776592537025862839e-02 8.86075717728769252090614827466197e-01 7.07756358900085702501314699475188e-02 2.31587716863235247924390769469483e-03
 	 8.86075717728769252090614827466197e-01 7.07756358900085702501314699475188e-02 4.31486463812221776592537025862839e-02 2.31587716863235247924390769469483e-03
 	 8.86075717728769252090614827466197e-01 4.31486463812221776592537025862839e-02 7.07756358900085702501314699475188e-02 2.31587716863235247924390769469483e-03
 	 4.73824731204699201025931643016520e-02 2.84833883835317481364457492531983e-03 9.49769188041176826153844103828305e-01 4.88270762203796835406593990214219e-04
 	 4.73824731204699201025931643016520e-02 9.49769188041176826153844103828305e-01 2.84833883835317481364457492531983e-03 4.88270762203796835406593990214219e-04
 	 2.84833883835317481364457492531983e-03 4.73824731204699201025931643016520e-02 9.49769188041176826153844103828305e-01 4.88270762203796835406593990214219e-04
 	 2.84833883835317481364457492531983e-03 9.49769188041176826153844103828305e-01 4.73824731204699201025931643016520e-02 4.88270762203796835406593990214219e-04
 	 9.49769188041176826153844103828305e-01 4.73824731204699201025931643016520e-02 2.84833883835317481364457492531983e-03 4.88270762203796835406593990214219e-04
 	 9.49769188041176826153844103828305e-01 2.84833883835317481364457492531983e-03 4.73824731204699201025931643016520e-02 4.88270762203796835406593990214219e-04
 	 2.97193248295744893994196900166571e-01 4.03974541969813680242218367766327e-02 6.62409297507273731042687359149568e-01 3.93324700753489280707908548606611e-03
 	 2.97193248295744893994196900166571e-01 6.62409297507273731042687359149568e-01 4.03974541969813680242218367766327e-02 3.93324700753489280707908548606611e-03
 	 4.03974541969813680242218367766327e-02 2.97193248295744893994196900166571e-01 6.62409297507273731042687359149568e-01 3.93324700753489280707908548606611e-03
 	 4.03974541969813680242218367766327e-02 6.62409297507273731042687359149568e-01 2.97193248295744893994196900166571e-01 3.93324700753489280707908548606611e-03
 	 6.62409297507273731042687359149568e-01 2.97193248295744893994196900166571e-01 4.03974541969813680242218367766327e-02 3.93324700753489280707908548606611e-03
 	 6.62409297507273731042687359149568e-01 4.03974541969813680242218367766327e-02 2.97193248295744893994196900166571e-01 3.93324700753489280707908548606611e-03
 	 4.43765239953598289446290436899289e-01 3.10025483435276659471835358772296e-02 5.25232211702874041137079075269867e-01 3.73698318743427874630280705048335e-03
 	 4.43765239953598289446290436899289e-01 5.25232211702874041137079075269867e-01 3.10025483435276659471835358772296e-02 3.73698318743427874630280705048335e-03
 	 3.10025483435276659471835358772296e-02 4.43765239953598289446290436899289e-01 5.25232211702874041137079075269867e-01 3.73698318743427874630280705048335e-03
 	 3.10025483435276659471835358772296e-02 5.25232211702874041137079075269867e-01 4.43765239953598289446290436899289e-01 3.73698318743427874630280705048335e-03
 	 5.25232211702874041137079075269867e-01 4.43765239953598289446290436899289e-01 3.10025483435276659471835358772296e-02 3.73698318743427874630280705048335e-03
 	 5.25232211702874041137079075269867e-01 3.10025483435276659471835358772296e-02 4.43765239953598289446290436899289e-01 3.73698318743427874630280705048335e-03
 	 2.29854890249822918502076163349557e-01 3.92854639000807109860957666569448e-02 7.30859645850096328878464646550128e-01 3.53062687033555908100446174557874e-03
 	 2.29854890249822918502076163349557e-01 7.30859645850096328878464646550128e-01 3.92854639000807109860957666569448e-02 3.53062687033555908100446174557874e-03
 	 3.92854639000807109860957666569448e-02 2.29854890249822918502076163349557e-01 7.30859645850096328878464646550128e-01 3.53062687033555908100446174557874e-03
 	 3.92854639000807109860957666569448e-02 7.30859645850096328878464646550128e-01 2.29854890249822918502076163349557e-01 3.53062687033555908100446174557874e-03
 	 7.30859645850096328878464646550128e-01 2.29854890249822918502076163349557e-01 3.92854639000807109860957666569448e-02 3.53062687033555908100446174557874e-03
 	 7.30859645850096328878464646550128e-01 3.92854639000807109860957666569448e-02 2.29854890249822918502076163349557e-01 3.53062687033555908100446174557874e-03
 	 2.51525427138907131663358995865565e-01 7.15641320496676891504961304235621e-02 6.76910440811425151430569258081960e-01 4.87330149061389935466470646474590e-03
 	 2.51525427138907131663358995865565e-01 6.76910440811425151430569258081960e-01 7.15641320496676891504961304235621e-02 4.87330149061389935466470646474590e-03
 	 7.15641320496676891504961304235621e-02 2.51525427138907131663358995865565e-01 6.76910440811425151430569258081960e-01 4.87330149061389935466470646474590e-03
 	 7.15641320496676891504961304235621e-02 6.76910440811425151430569258081960e-01 2.51525427138907131663358995865565e-01 4.87330149061389935466470646474590e-03
 	 6.76910440811425151430569258081960e-01 2.51525427138907131663358995865565e-01 7.15641320496676891504961304235621e-02 4.87330149061389935466470646474590e-03
 	 6.76910440811425151430569258081960e-01 7.15641320496676891504961304235621e-02 2.51525427138907131663358995865565e-01 4.87330149061389935466470646474590e-03
 	 2.20628791932752477134016544368933e-01 1.54394591780774664835362841586175e-01 6.24976616286472830275044998415979e-01 6.06969242192606679708877237544584e-03
 	 2.20628791932752477134016544368933e-01 6.24976616286472830275044998415979e-01 1.54394591780774664835362841586175e-01 6.06969242192606679708877237544584e-03
 	 1.54394591780774664835362841586175e-01 2.20628791932752477134016544368933e-01 6.24976616286472830275044998415979e-01 6.06969242192606679708877237544584e-03
 	 1.54394591780774664835362841586175e-01 6.24976616286472830275044998415979e-01 2.20628791932752477134016544368933e-01 6.06969242192606679708877237544584e-03
 	 6.24976616286472830275044998415979e-01 2.20628791932752477134016544368933e-01 1.54394591780774664835362841586175e-01 6.06969242192606679708877237544584e-03
 	 6.24976616286472830275044998415979e-01 1.54394591780774664835362841586175e-01 2.20628791932752477134016544368933e-01 6.06969242192606679708877237544584e-03
 	 4.16403182046817754713430304036592e-01 2.77347337277504936772776211739711e-03 5.80823344580407296966484409495024e-01 1.10176358075083974039087841845230e-03
 	 4.16403182046817754713430304036592e-01 5.80823344580407296966484409495024e-01 2.77347337277504936772776211739711e-03 1.10176358075083974039087841845230e-03
 	 2.77347337277504936772776211739711e-03 4.16403182046817754713430304036592e-01 5.80823344580407296966484409495024e-01 1.10176358075083974039087841845230e-03
 	 2.77347337277504936772776211739711e-03 5.80823344580407296966484409495024e-01 4.16403182046817754713430304036592e-01 1.10176358075083974039087841845230e-03
 	 5.80823344580407296966484409495024e-01 4.16403182046817754713430304036592e-01 2.77347337277504936772776211739711e-03 1.10176358075083974039087841845230e-03
 	 5.80823344580407296966484409495024e-01 2.77347337277504936772776211739711e-03 4.16403182046817754713430304036592e-01 1.10176358075083974039087841845230e-03
 	 2.78037243584027538023661918487051e-01 1.71845869035243042910465760542138e-01 5.50116887380729502332599167857552e-01 7.30918281552229726766300998974657e-03
 	 2.78037243584027538023661918487051e-01 5.50116887380729502332599167857552e-01 1.71845869035243042910465760542138e-01 7.30918281552229726766300998974657e-03
 	 1.71845869035243042910465760542138e-01 2.78037243584027538023661918487051e-01 5.50116887380729502332599167857552e-01 7.30918281552229726766300998974657e-03
 	 1.71845869035243042910465760542138e-01 5.50116887380729502332599167857552e-01 2.78037243584027538023661918487051e-01 7.30918281552229726766300998974657e-03
 	 5.50116887380729502332599167857552e-01 2.78037243584027538023661918487051e-01 1.71845869035243042910465760542138e-01 7.30918281552229726766300998974657e-03
 	 5.50116887380729502332599167857552e-01 1.71845869035243042910465760542138e-01 2.78037243584027538023661918487051e-01 7.30918281552229726766300998974657e-03
 	 3.42075832214508490647375538173947e-01 3.25241025804930876733078726203985e-03 6.54671757527442110813353792764246e-01 1.17361952773900493456060711849887e-03
 	 3.42075832214508490647375538173947e-01 6.54671757527442110813353792764246e-01 3.25241025804930876733078726203985e-03 1.17361952773900493456060711849887e-03
 	 3.25241025804930876733078726203985e-03 3.42075832214508490647375538173947e-01 6.54671757527442110813353792764246e-01 1.17361952773900493456060711849887e-03
 	 3.25241025804930876733078726203985e-03 6.54671757527442110813353792764246e-01 3.42075832214508490647375538173947e-01 1.17361952773900493456060711849887e-03
 	 6.54671757527442110813353792764246e-01 3.42075832214508490647375538173947e-01 3.25241025804930876733078726203985e-03 1.17361952773900493456060711849887e-03
 	 6.54671757527442110813353792764246e-01 3.25241025804930876733078726203985e-03 3.42075832214508490647375538173947e-01 1.17361952773900493456060711849887e-03
 	 3.76651522742024291723339501913870e-01 1.60811994772276506404651286175067e-02 6.07267277780748071513983177283080e-01 2.82774642041020568550280245290196e-03
 	 3.76651522742024291723339501913870e-01 6.07267277780748071513983177283080e-01 1.60811994772276506404651286175067e-02 2.82774642041020568550280245290196e-03
 	 1.60811994772276506404651286175067e-02 3.76651522742024291723339501913870e-01 6.07267277780748071513983177283080e-01 2.82774642041020568550280245290196e-03
 	 1.60811994772276506404651286175067e-02 6.07267277780748071513983177283080e-01 3.76651522742024291723339501913870e-01 2.82774642041020568550280245290196e-03
 	 6.07267277780748071513983177283080e-01 3.76651522742024291723339501913870e-01 1.60811994772276506404651286175067e-02 2.82774642041020568550280245290196e-03
 	 6.07267277780748071513983177283080e-01 1.60811994772276506404651286175067e-02 3.76651522742024291723339501913870e-01 2.82774642041020568550280245290196e-03
 	 1.12297916741235570547985389566747e-01 4.36591987048875543320214376308286e-02 8.44042884553876882058887076709652e-01 2.81181955806291371258165412427843e-03
 	 1.12297916741235570547985389566747e-01 8.44042884553876882058887076709652e-01 4.36591987048875543320214376308286e-02 2.81181955806291371258165412427843e-03
 	 4.36591987048875543320214376308286e-02 1.12297916741235570547985389566747e-01 8.44042884553876882058887076709652e-01 2.81181955806291371258165412427843e-03
 	 4.36591987048875543320214376308286e-02 8.44042884553876882058887076709652e-01 1.12297916741235570547985389566747e-01 2.81181955806291371258165412427843e-03
 	 8.44042884553876882058887076709652e-01 1.12297916741235570547985389566747e-01 4.36591987048875543320214376308286e-02 2.81181955806291371258165412427843e-03
 	 8.44042884553876882058887076709652e-01 4.36591987048875543320214376308286e-02 1.12297916741235570547985389566747e-01 2.81181955806291371258165412427843e-03
 	 1.86141155841773708878861270932248e-01 6.82956923610527899537459006751305e-02 7.45563151797173473411817212763708e-01 4.37762177288439878475312383443452e-03
 	 1.86141155841773708878861270932248e-01 7.45563151797173473411817212763708e-01 6.82956923610527899537459006751305e-02 4.37762177288439878475312383443452e-03
 	 6.82956923610527899537459006751305e-02 1.86141155841773708878861270932248e-01 7.45563151797173473411817212763708e-01 4.37762177288439878475312383443452e-03
 	 6.82956923610527899537459006751305e-02 7.45563151797173473411817212763708e-01 1.86141155841773708878861270932248e-01 4.37762177288439878475312383443452e-03
 	 7.45563151797173473411817212763708e-01 1.86141155841773708878861270932248e-01 6.82956923610527899537459006751305e-02 4.37762177288439878475312383443452e-03
 	 7.45563151797173473411817212763708e-01 6.82956923610527899537459006751305e-02 1.86141155841773708878861270932248e-01 4.37762177288439878475312383443452e-03
 	 3.21703398275187124610852151818108e-01 7.47225031108798287693417705668253e-02 6.03574098613933074375381693243980e-01 5.77978517496892732485669341713219e-03
 	 3.21703398275187124610852151818108e-01 6.03574098613933074375381693243980e-01 7.47225031108798287693417705668253e-02 5.77978517496892732485669341713219e-03
 	 7.47225031108798287693417705668253e-02 3.21703398275187124610852151818108e-01 6.03574098613933074375381693243980e-01 5.77978517496892732485669341713219e-03
 	 7.47225031108798287693417705668253e-02 6.03574098613933074375381693243980e-01 3.21703398275187124610852151818108e-01 5.77978517496892732485669341713219e-03
 	 6.03574098613933074375381693243980e-01 3.21703398275187124610852151818108e-01 7.47225031108798287693417705668253e-02 5.77978517496892732485669341713219e-03
 	 6.03574098613933074375381693243980e-01 7.47225031108798287693417705668253e-02 3.21703398275187124610852151818108e-01 5.77978517496892732485669341713219e-03
 	 1.66012685178866747914838697397499e-01 3.61553743643339420277271756276605e-02 7.97831940456799282301858511345927e-01 3.32168831503308267794061237054848e-03
 	 1.66012685178866747914838697397499e-01 7.97831940456799282301858511345927e-01 3.61553743643339420277271756276605e-02 3.32168831503308267794061237054848e-03
 	 3.61553743643339420277271756276605e-02 1.66012685178866747914838697397499e-01 7.97831940456799282301858511345927e-01 3.32168831503308267794061237054848e-03
 	 3.61553743643339420277271756276605e-02 7.97831940456799282301858511345927e-01 1.66012685178866747914838697397499e-01 3.32168831503308267794061237054848e-03
 	 7.97831940456799282301858511345927e-01 1.66012685178866747914838697397499e-01 3.61553743643339420277271756276605e-02 3.32168831503308267794061237054848e-03
 	 7.97831940456799282301858511345927e-01 3.61553743643339420277271756276605e-02 1.66012685178866747914838697397499e-01 3.32168831503308267794061237054848e-03
 	 1.93576952354284764767911042326887e-02 2.83309069924117659308726580036364e-03 9.77809214065330278842225197877269e-01 3.23421438576733204488949935395681e-04
 	 1.93576952354284764767911042326887e-02 9.77809214065330278842225197877269e-01 2.83309069924117659308726580036364e-03 3.23421438576733204488949935395681e-04
 	 2.83309069924117659308726580036364e-03 1.93576952354284764767911042326887e-02 9.77809214065330278842225197877269e-01 3.23421438576733204488949935395681e-04
 	 2.83309069924117659308726580036364e-03 9.77809214065330278842225197877269e-01 1.93576952354284764767911042326887e-02 3.23421438576733204488949935395681e-04
 	 9.77809214065330278842225197877269e-01 1.93576952354284764767911042326887e-02 2.83309069924117659308726580036364e-03 3.23421438576733204488949935395681e-04
 	 9.77809214065330278842225197877269e-01 2.83309069924117659308726580036364e-03 1.93576952354284764767911042326887e-02 3.23421438576733204488949935395681e-04
 	 7.19904092251254096312962360570964e-02 1.79498835307187742937884422644856e-02 9.10059707244155746685976282606134e-01 1.55995851175891341901247333368019e-03
 	 7.19904092251254096312962360570964e-02 9.10059707244155746685976282606134e-01 1.79498835307187742937884422644856e-02 1.55995851175891341901247333368019e-03
 	 1.79498835307187742937884422644856e-02 7.19904092251254096312962360570964e-02 9.10059707244155746685976282606134e-01 1.55995851175891341901247333368019e-03
 	 1.79498835307187742937884422644856e-02 9.10059707244155746685976282606134e-01 7.19904092251254096312962360570964e-02 1.55995851175891341901247333368019e-03
 	 9.10059707244155746685976282606134e-01 7.19904092251254096312962360570964e-02 1.79498835307187742937884422644856e-02 1.55995851175891341901247333368019e-03
 	 9.10059707244155746685976282606134e-01 1.79498835307187742937884422644856e-02 7.19904092251254096312962360570964e-02 1.55995851175891341901247333368019e-03
 	 1.33332716879897866801840677908331e-01 3.19253987057180636452424771221104e-03 8.63474743249530329869401157338871e-01 8.68459657301683162280991901127436e-04
 	 1.33332716879897866801840677908331e-01 8.63474743249530329869401157338871e-01 3.19253987057180636452424771221104e-03 8.68459657301683162280991901127436e-04
 	 3.19253987057180636452424771221104e-03 1.33332716879897866801840677908331e-01 8.63474743249530329869401157338871e-01 8.68459657301683162280991901127436e-04
 	 3.19253987057180636452424771221104e-03 8.63474743249530329869401157338871e-01 1.33332716879897866801840677908331e-01 8.68459657301683162280991901127436e-04
 	 8.63474743249530329869401157338871e-01 1.33332716879897866801840677908331e-01 3.19253987057180636452424771221104e-03 8.68459657301683162280991901127436e-04
 	 8.63474743249530329869401157338871e-01 3.19253987057180636452424771221104e-03 1.33332716879897866801840677908331e-01 8.68459657301683162280991901127436e-04
 	 2.99445529172993885058673413368524e-01 1.62924574190147324059818600971994e-02 6.84262013407991420699261198024033e-01 2.75167825659652573455637991628464e-03
 	 2.99445529172993885058673413368524e-01 6.84262013407991420699261198024033e-01 1.62924574190147324059818600971994e-02 2.75167825659652573455637991628464e-03
 	 1.62924574190147324059818600971994e-02 2.99445529172993885058673413368524e-01 6.84262013407991420699261198024033e-01 2.75167825659652573455637991628464e-03
 	 1.62924574190147324059818600971994e-02 6.84262013407991420699261198024033e-01 2.99445529172993885058673413368524e-01 2.75167825659652573455637991628464e-03
 	 6.84262013407991420699261198024033e-01 2.99445529172993885058673413368524e-01 1.62924574190147324059818600971994e-02 2.75167825659652573455637991628464e-03
 	 6.84262013407991420699261198024033e-01 1.62924574190147324059818600971994e-02 2.99445529172993885058673413368524e-01 2.75167825659652573455637991628464e-03
 	 1.17107885189153299032582822292170e-01 1.79153991813487192819032145507663e-02 8.64976715629497960868832251435379e-01 2.05058624431324809309074019836316e-03
 	 1.17107885189153299032582822292170e-01 8.64976715629497960868832251435379e-01 1.79153991813487192819032145507663e-02 2.05058624431324809309074019836316e-03
 	 1.79153991813487192819032145507663e-02 1.17107885189153299032582822292170e-01 8.64976715629497960868832251435379e-01 2.05058624431324809309074019836316e-03
 	 1.79153991813487192819032145507663e-02 8.64976715629497960868832251435379e-01 1.17107885189153299032582822292170e-01 2.05058624431324809309074019836316e-03
 	 8.64976715629497960868832251435379e-01 1.17107885189153299032582822292170e-01 1.79153991813487192819032145507663e-02 2.05058624431324809309074019836316e-03
 	 8.64976715629497960868832251435379e-01 1.79153991813487192819032145507663e-02 1.17107885189153299032582822292170e-01 2.05058624431324809309074019836316e-03
 	 8.53676016562654599306725344831648e-02 3.56724930413417637767303780549355e-03 9.11065149039600341573930109007051e-01 7.84150125646033134031720468470894e-04
 	 8.53676016562654599306725344831648e-02 9.11065149039600341573930109007051e-01 3.56724930413417637767303780549355e-03 7.84150125646033134031720468470894e-04
 	 3.56724930413417637767303780549355e-03 8.53676016562654599306725344831648e-02 9.11065149039600341573930109007051e-01 7.84150125646033134031720468470894e-04
 	 3.56724930413417637767303780549355e-03 9.11065149039600341573930109007051e-01 8.53676016562654599306725344831648e-02 7.84150125646033134031720468470894e-04
 	 9.11065149039600341573930109007051e-01 8.53676016562654599306725344831648e-02 3.56724930413417637767303780549355e-03 7.84150125646033134031720468470894e-04
 	 9.11065149039600341573930109007051e-01 3.56724930413417637767303780549355e-03 8.53676016562654599306725344831648e-02 7.84150125646033134031720468470894e-04
 	 ];
 
 	 case  40 

 	 % ALG. DEG.:   40
 	 % PTS CARD.:  295
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 8.78548445286312165714015520734392e-03
 	 1.57037453637930216054918730606005e-02 1.57037453637930216054918730606005e-02 9.68592509272413915155652830435429e-01 6.25606619674852135193354740749783e-04
 	 1.57037453637930216054918730606005e-02 9.68592509272413915155652830435429e-01 1.57037453637930216054918730606005e-02 6.25606619674852135193354740749783e-04
 	 9.68592509272413915155652830435429e-01 1.57037453637930216054918730606005e-02 1.57037453637930216054918730606005e-02 6.25606619674852135193354740749783e-04
 	 2.93889962897443068889913320163032e-01 2.93889962897443068889913320163032e-01 4.12220074205113862220173359673936e-01 8.59452895898682109332433753934311e-03
 	 2.93889962897443068889913320163032e-01 4.12220074205113862220173359673936e-01 2.93889962897443068889913320163032e-01 8.59452895898682109332433753934311e-03
 	 4.12220074205113862220173359673936e-01 2.93889962897443068889913320163032e-01 2.93889962897443068889913320163032e-01 8.59452895898682109332433753934311e-03
 	 3.70102868423741626635603552131215e-01 3.70102868423741626635603552131215e-01 2.59794263152516746728792895737570e-01 8.59933234156201424525090004635786e-03
 	 3.70102868423741626635603552131215e-01 2.59794263152516746728792895737570e-01 3.70102868423741626635603552131215e-01 8.59933234156201424525090004635786e-03
 	 2.59794263152516746728792895737570e-01 3.70102868423741626635603552131215e-01 3.70102868423741626635603552131215e-01 8.59933234156201424525090004635786e-03
 	 2.52696314852206671552892203180818e-01 2.52696314852206671552892203180818e-01 4.94607370295586656894215593638364e-01 8.03913559932145291297977962585719e-03
 	 2.52696314852206671552892203180818e-01 4.94607370295586656894215593638364e-01 2.52696314852206671552892203180818e-01 8.03913559932145291297977962585719e-03
 	 4.94607370295586656894215593638364e-01 2.52696314852206671552892203180818e-01 2.52696314852206671552892203180818e-01 8.03913559932145291297977962585719e-03
 	 2.10577129514804201049216203500691e-01 2.10577129514804201049216203500691e-01 5.78845740970391542390416361740790e-01 7.21182359490887998909602885078129e-03
 	 2.10577129514804201049216203500691e-01 5.78845740970391542390416361740790e-01 2.10577129514804201049216203500691e-01 7.21182359490887998909602885078129e-03
 	 5.78845740970391542390416361740790e-01 2.10577129514804201049216203500691e-01 2.10577129514804201049216203500691e-01 7.21182359490887998909602885078129e-03
 	 3.05751062854184036537974478164870e-03 3.05751062854184036537974478164870e-03 9.93884978742916369576221313764108e-01 1.22963885133325732815570696665475e-04
 	 3.05751062854184036537974478164870e-03 9.93884978742916369576221313764108e-01 3.05751062854184036537974478164870e-03 1.22963885133325732815570696665475e-04
 	 9.93884978742916369576221313764108e-01 3.05751062854184036537974478164870e-03 3.05751062854184036537974478164870e-03 1.22963885133325732815570696665475e-04
 	 4.03292222274262812664602506629308e-01 4.03292222274262812664602506629308e-01 1.93415555451474374670794986741384e-01 8.06680496745191752405723661922821e-03
 	 4.03292222274262812664602506629308e-01 1.93415555451474374670794986741384e-01 4.03292222274262812664602506629308e-01 8.06680496745191752405723661922821e-03
 	 1.93415555451474374670794986741384e-01 4.03292222274262812664602506629308e-01 4.03292222274262812664602506629308e-01 8.06680496745191752405723661922821e-03
 	 4.76751646800292860906012037958135e-01 4.76751646800292860906012037958135e-01 4.64967063994142781879759240837302e-02 4.67897622845292113225035279810982e-03
 	 4.76751646800292860906012037958135e-01 4.64967063994142781879759240837302e-02 4.76751646800292860906012037958135e-01 4.67897622845292113225035279810982e-03
 	 4.64967063994142781879759240837302e-02 4.76751646800292860906012037958135e-01 4.76751646800292860906012037958135e-01 4.67897622845292113225035279810982e-03
 	 6.48562451597025496630166685463337e-02 6.48562451597025496630166685463337e-02 8.70287509680594872918391047278419e-01 2.71729857192477830540866534647648e-03
 	 6.48562451597025496630166685463337e-02 8.70287509680594872918391047278419e-01 6.48562451597025496630166685463337e-02 2.71729857192477830540866534647648e-03
 	 8.70287509680594872918391047278419e-01 6.48562451597025496630166685463337e-02 6.48562451597025496630166685463337e-02 2.71729857192477830540866534647648e-03
 	 1.68896379782961736371049710214720e-01 1.68896379782961736371049710214720e-01 6.62207240434076527257900579570560e-01 6.23994203053035260964076513801047e-03
 	 1.68896379782961736371049710214720e-01 6.62207240434076527257900579570560e-01 1.68896379782961736371049710214720e-01 6.23994203053035260964076513801047e-03
 	 6.62207240434076527257900579570560e-01 1.68896379782961736371049710214720e-01 1.68896379782961736371049710214720e-01 6.23994203053035260964076513801047e-03
 	 9.62980341591576360915638588267029e-02 9.62980341591576360915638588267029e-02 8.07403931681684783328023513604421e-01 3.89090937960496130107457268820781e-03
 	 9.62980341591576360915638588267029e-02 8.07403931681684783328023513604421e-01 9.62980341591576360915638588267029e-02 3.89090937960496130107457268820781e-03
 	 8.07403931681684783328023513604421e-01 9.62980341591576360915638588267029e-02 9.62980341591576360915638588267029e-02 3.89090937960496130107457268820781e-03
 	 4.90701569130203962831870967420400e-01 4.90701569130203962831870967420400e-01 1.85968617395920743362580651591998e-02 3.02896910627726938247672450188475e-03
 	 4.90701569130203962831870967420400e-01 1.85968617395920743362580651591998e-02 4.90701569130203962831870967420400e-01 3.02896910627726938247672450188475e-03
 	 1.85968617395920743362580651591998e-02 4.90701569130203962831870967420400e-01 4.90701569130203962831870967420400e-01 3.02896910627726938247672450188475e-03
 	 4.98464579236597593592250632354990e-01 4.98464579236597593592250632354990e-01 3.07084152680481281549873529002070e-03 1.20502806225552031547942899436521e-03
 	 4.98464579236597593592250632354990e-01 3.07084152680481281549873529002070e-03 4.98464579236597593592250632354990e-01 1.20502806225552031547942899436521e-03
 	 3.07084152680481281549873529002070e-03 4.98464579236597593592250632354990e-01 4.98464579236597593592250632354990e-01 1.20502806225552031547942899436521e-03
 	 4.32271977606806356853041961585404e-01 4.32271977606806356853041961585404e-01 1.35456044786387286293916076829191e-01 7.22488573495890309961176001252170e-03
 	 4.32271977606806356853041961585404e-01 1.35456044786387286293916076829191e-01 4.32271977606806356853041961585404e-01 7.22488573495890309961176001252170e-03
 	 1.35456044786387286293916076829191e-01 4.32271977606806356853041961585404e-01 4.32271977606806356853041961585404e-01 7.22488573495890309961176001252170e-03
 	 1.30241606990209146665904427209171e-01 1.30241606990209146665904427209171e-01 7.39516786019581706668191145581659e-01 5.13639172614044434844737807566162e-03
 	 1.30241606990209146665904427209171e-01 7.39516786019581706668191145581659e-01 1.30241606990209146665904427209171e-01 5.13639172614044434844737807566162e-03
 	 7.39516786019581706668191145581659e-01 1.30241606990209146665904427209171e-01 1.30241606990209146665904427209171e-01 5.13639172614044434844737807566162e-03
 	 4.56871737154322776763848423797754e-01 4.56871737154322776763848423797754e-01 8.62565256913544464723031524044927e-02 6.08445387549527792053760677504215e-03
 	 4.56871737154322776763848423797754e-01 8.62565256913544464723031524044927e-02 4.56871737154322776763848423797754e-01 6.08445387549527792053760677504215e-03
 	 8.62565256913544464723031524044927e-02 4.56871737154322776763848423797754e-01 4.56871737154322776763848423797754e-01 6.08445387549527792053760677504215e-03
 	 1.67177838355710456363922844502667e-01 1.52794904901324161625164599342952e-03 8.31294212595276360566742823721142e-01 3.77552367853570269851104512781603e-04
 	 1.67177838355710456363922844502667e-01 8.31294212595276360566742823721142e-01 1.52794904901324161625164599342952e-03 3.77552367853570269851104512781603e-04
 	 1.52794904901324161625164599342952e-03 1.67177838355710456363922844502667e-01 8.31294212595276360566742823721142e-01 3.77552367853570269851104512781603e-04
 	 1.52794904901324161625164599342952e-03 8.31294212595276360566742823721142e-01 1.67177838355710456363922844502667e-01 3.77552367853570269851104512781603e-04
 	 8.31294212595276360566742823721142e-01 1.67177838355710456363922844502667e-01 1.52794904901324161625164599342952e-03 3.77552367853570269851104512781603e-04
 	 8.31294212595276360566742823721142e-01 1.52794904901324161625164599342952e-03 1.67177838355710456363922844502667e-01 3.77552367853570269851104512781603e-04
 	 3.71478099445237464060198817605851e-01 1.49718224721410841232538402323371e-02 6.13550078082621408448460442741634e-01 1.55168496985503764906688672908786e-03
 	 3.71478099445237464060198817605851e-01 6.13550078082621408448460442741634e-01 1.49718224721410841232538402323371e-02 1.55168496985503764906688672908786e-03
 	 1.49718224721410841232538402323371e-02 3.71478099445237464060198817605851e-01 6.13550078082621408448460442741634e-01 1.55168496985503764906688672908786e-03
 	 1.49718224721410841232538402323371e-02 6.13550078082621408448460442741634e-01 3.71478099445237464060198817605851e-01 1.55168496985503764906688672908786e-03
 	 6.13550078082621408448460442741634e-01 3.71478099445237464060198817605851e-01 1.49718224721410841232538402323371e-02 1.55168496985503764906688672908786e-03
 	 6.13550078082621408448460442741634e-01 1.49718224721410841232538402323371e-02 3.71478099445237464060198817605851e-01 1.55168496985503764906688672908786e-03
 	 1.59023884712373636540760912794212e-01 6.80425879912778096975101149723741e-03 8.34171856488498564274891577952076e-01 8.64414560746594971829548370578777e-04
 	 1.59023884712373636540760912794212e-01 8.34171856488498564274891577952076e-01 6.80425879912778096975101149723741e-03 8.64414560746594971829548370578777e-04
 	 6.80425879912778096975101149723741e-03 1.59023884712373636540760912794212e-01 8.34171856488498564274891577952076e-01 8.64414560746594971829548370578777e-04
 	 6.80425879912778096975101149723741e-03 8.34171856488498564274891577952076e-01 1.59023884712373636540760912794212e-01 8.64414560746594971829548370578777e-04
 	 8.34171856488498564274891577952076e-01 1.59023884712373636540760912794212e-01 6.80425879912778096975101149723741e-03 8.64414560746594971829548370578777e-04
 	 8.34171856488498564274891577952076e-01 6.80425879912778096975101149723741e-03 1.59023884712373636540760912794212e-01 8.64414560746594971829548370578777e-04
 	 4.62179329282665363187732054939261e-02 3.53139747015546109909500671619753e-02 9.18468092370178790240231592179043e-01 9.97184931873168175012200897810999e-04
 	 4.62179329282665363187732054939261e-02 9.18468092370178790240231592179043e-01 3.53139747015546109909500671619753e-02 9.97184931873168175012200897810999e-04
 	 3.53139747015546109909500671619753e-02 4.62179329282665363187732054939261e-02 9.18468092370178790240231592179043e-01 9.97184931873168175012200897810999e-04
 	 3.53139747015546109909500671619753e-02 9.18468092370178790240231592179043e-01 4.62179329282665363187732054939261e-02 9.97184931873168175012200897810999e-04
 	 9.18468092370178790240231592179043e-01 4.62179329282665363187732054939261e-02 3.53139747015546109909500671619753e-02 9.97184931873168175012200897810999e-04
 	 9.18468092370178790240231592179043e-01 3.53139747015546109909500671619753e-02 4.62179329282665363187732054939261e-02 9.97184931873168175012200897810999e-04
 	 1.14865167380080651637896949068818e-01 1.58398644760465636543989020879053e-03 8.83550846172314718884877038362902e-01 4.09077031298047419458768780842206e-04
 	 1.14865167380080651637896949068818e-01 8.83550846172314718884877038362902e-01 1.58398644760465636543989020879053e-03 4.09077031298047419458768780842206e-04
 	 1.58398644760465636543989020879053e-03 1.14865167380080651637896949068818e-01 8.83550846172314718884877038362902e-01 4.09077031298047419458768780842206e-04
 	 1.58398644760465636543989020879053e-03 8.83550846172314718884877038362902e-01 1.14865167380080651637896949068818e-01 4.09077031298047419458768780842206e-04
 	 8.83550846172314718884877038362902e-01 1.14865167380080651637896949068818e-01 1.58398644760465636543989020879053e-03 4.09077031298047419458768780842206e-04
 	 8.83550846172314718884877038362902e-01 1.58398644760465636543989020879053e-03 1.14865167380080651637896949068818e-01 4.09077031298047419458768780842206e-04
 	 3.34246008184714449296137672718032e-01 2.15166720844818110114360365514585e-02 6.44237319730803670303487251658225e-01 2.04366716008443300225949634807421e-03
 	 3.34246008184714449296137672718032e-01 6.44237319730803670303487251658225e-01 2.15166720844818110114360365514585e-02 2.04366716008443300225949634807421e-03
 	 2.15166720844818110114360365514585e-02 3.34246008184714449296137672718032e-01 6.44237319730803670303487251658225e-01 2.04366716008443300225949634807421e-03
 	 2.15166720844818110114360365514585e-02 6.44237319730803670303487251658225e-01 3.34246008184714449296137672718032e-01 2.04366716008443300225949634807421e-03
 	 6.44237319730803670303487251658225e-01 3.34246008184714449296137672718032e-01 2.15166720844818110114360365514585e-02 2.04366716008443300225949634807421e-03
 	 6.44237319730803670303487251658225e-01 2.15166720844818110114360365514585e-02 3.34246008184714449296137672718032e-01 2.04366716008443300225949634807421e-03
 	 7.23711649483900210100273397983983e-02 2.02526169256312012223464336102552e-03 9.25603573359046860602461492817383e-01 4.12644332627623024699337062060067e-04
 	 7.23711649483900210100273397983983e-02 9.25603573359046860602461492817383e-01 2.02526169256312012223464336102552e-03 4.12644332627623024699337062060067e-04
 	 2.02526169256312012223464336102552e-03 7.23711649483900210100273397983983e-02 9.25603573359046860602461492817383e-01 4.12644332627623024699337062060067e-04
 	 2.02526169256312012223464336102552e-03 9.25603573359046860602461492817383e-01 7.23711649483900210100273397983983e-02 4.12644332627623024699337062060067e-04
 	 9.25603573359046860602461492817383e-01 7.23711649483900210100273397983983e-02 2.02526169256312012223464336102552e-03 4.12644332627623024699337062060067e-04
 	 9.25603573359046860602461492817383e-01 2.02526169256312012223464336102552e-03 7.23711649483900210100273397983983e-02 4.12644332627623024699337062060067e-04
 	 2.23684246664788699554549111780943e-01 1.53612037490868675454480651865197e-02 7.60954549586124406879150683380431e-01 1.91469675439683603528073785327024e-03
 	 2.23684246664788699554549111780943e-01 7.60954549586124406879150683380431e-01 1.53612037490868675454480651865197e-02 1.91469675439683603528073785327024e-03
 	 1.53612037490868675454480651865197e-02 2.23684246664788699554549111780943e-01 7.60954549586124406879150683380431e-01 1.91469675439683603528073785327024e-03
 	 1.53612037490868675454480651865197e-02 7.60954549586124406879150683380431e-01 2.23684246664788699554549111780943e-01 1.91469675439683603528073785327024e-03
 	 7.60954549586124406879150683380431e-01 2.23684246664788699554549111780943e-01 1.53612037490868675454480651865197e-02 1.91469675439683603528073785327024e-03
 	 7.60954549586124406879150683380431e-01 1.53612037490868675454480651865197e-02 2.23684246664788699554549111780943e-01 1.91469675439683603528073785327024e-03
 	 1.11129016990584944535314093627676e-01 1.01659439479149828200466032512850e-02 8.78705039061499992847359408187913e-01 1.16400313598994352426441167835947e-03
 	 1.11129016990584944535314093627676e-01 8.78705039061499992847359408187913e-01 1.01659439479149828200466032512850e-02 1.16400313598994352426441167835947e-03
 	 1.01659439479149828200466032512850e-02 1.11129016990584944535314093627676e-01 8.78705039061499992847359408187913e-01 1.16400313598994352426441167835947e-03
 	 1.01659439479149828200466032512850e-02 8.78705039061499992847359408187913e-01 1.11129016990584944535314093627676e-01 1.16400313598994352426441167835947e-03
 	 8.78705039061499992847359408187913e-01 1.11129016990584944535314093627676e-01 1.01659439479149828200466032512850e-02 1.16400313598994352426441167835947e-03
 	 8.78705039061499992847359408187913e-01 1.01659439479149828200466032512850e-02 1.11129016990584944535314093627676e-01 1.16400313598994352426441167835947e-03
 	 2.76444541807790877818717945046956e-01 3.00138537838292723813893303486111e-02 6.93541604408379863677680532418890e-01 2.91867371065237775698553157610604e-03
 	 2.76444541807790877818717945046956e-01 6.93541604408379863677680532418890e-01 3.00138537838292723813893303486111e-02 2.91867371065237775698553157610604e-03
 	 3.00138537838292723813893303486111e-02 2.76444541807790877818717945046956e-01 6.93541604408379863677680532418890e-01 2.91867371065237775698553157610604e-03
 	 3.00138537838292723813893303486111e-02 6.93541604408379863677680532418890e-01 2.76444541807790877818717945046956e-01 2.91867371065237775698553157610604e-03
 	 6.93541604408379863677680532418890e-01 2.76444541807790877818717945046956e-01 3.00138537838292723813893303486111e-02 2.91867371065237775698553157610604e-03
 	 6.93541604408379863677680532418890e-01 3.00138537838292723813893303486111e-02 2.76444541807790877818717945046956e-01 2.91867371065237775698553157610604e-03
 	 1.69263355465675779942813505840604e-01 1.89700426400215629851864207466861e-02 8.11766601894302719522045208577765e-01 1.94233817232235847320687138761741e-03
 	 1.69263355465675779942813505840604e-01 8.11766601894302719522045208577765e-01 1.89700426400215629851864207466861e-02 1.94233817232235847320687138761741e-03
 	 1.89700426400215629851864207466861e-02 1.69263355465675779942813505840604e-01 8.11766601894302719522045208577765e-01 1.94233817232235847320687138761741e-03
 	 1.89700426400215629851864207466861e-02 8.11766601894302719522045208577765e-01 1.69263355465675779942813505840604e-01 1.94233817232235847320687138761741e-03
 	 8.11766601894302719522045208577765e-01 1.69263355465675779942813505840604e-01 1.89700426400215629851864207466861e-02 1.94233817232235847320687138761741e-03
 	 8.11766601894302719522045208577765e-01 1.89700426400215629851864207466861e-02 1.69263355465675779942813505840604e-01 1.94233817232235847320687138761741e-03
 	 1.19650955248758308901990687900252e-01 2.67407842221269662075222584007861e-02 8.53608260529114648562654110719450e-01 2.04371606423298709381830562392679e-03
 	 1.19650955248758308901990687900252e-01 8.53608260529114648562654110719450e-01 2.67407842221269662075222584007861e-02 2.04371606423298709381830562392679e-03
 	 2.67407842221269662075222584007861e-02 1.19650955248758308901990687900252e-01 8.53608260529114648562654110719450e-01 2.04371606423298709381830562392679e-03
 	 2.67407842221269662075222584007861e-02 8.53608260529114648562654110719450e-01 1.19650955248758308901990687900252e-01 2.04371606423298709381830562392679e-03
 	 8.53608260529114648562654110719450e-01 1.19650955248758308901990687900252e-01 2.67407842221269662075222584007861e-02 2.04371606423298709381830562392679e-03
 	 8.53608260529114648562654110719450e-01 2.67407842221269662075222584007861e-02 1.19650955248758308901990687900252e-01 2.04371606423298709381830562392679e-03
 	 2.83019097129268648593836132931756e-01 8.53818693537522336624301377838719e-04 7.16127084177193840019981507794000e-01 4.56178858434889966926711890593538e-04
 	 2.83019097129268648593836132931756e-01 7.16127084177193840019981507794000e-01 8.53818693537522336624301377838719e-04 4.56178858434889966926711890593538e-04
 	 8.53818693537522336624301377838719e-04 2.83019097129268648593836132931756e-01 7.16127084177193840019981507794000e-01 4.56178858434889966926711890593538e-04
 	 8.53818693537522336624301377838719e-04 7.16127084177193840019981507794000e-01 2.83019097129268648593836132931756e-01 4.56178858434889966926711890593538e-04
 	 7.16127084177193840019981507794000e-01 2.83019097129268648593836132931756e-01 8.53818693537522336624301377838719e-04 4.56178858434889966926711890593538e-04
 	 7.16127084177193840019981507794000e-01 8.53818693537522336624301377838719e-04 2.83019097129268648593836132931756e-01 4.56178858434889966926711890593538e-04
 	 7.04045501511467719524262065533549e-02 1.22584700439817353978533276404050e-02 9.17336979804871499588614369713468e-01 1.11815265069852443763354088446249e-03
 	 7.04045501511467719524262065533549e-02 9.17336979804871499588614369713468e-01 1.22584700439817353978533276404050e-02 1.11815265069852443763354088446249e-03
 	 1.22584700439817353978533276404050e-02 7.04045501511467719524262065533549e-02 9.17336979804871499588614369713468e-01 1.11815265069852443763354088446249e-03
 	 1.22584700439817353978533276404050e-02 9.17336979804871499588614369713468e-01 7.04045501511467719524262065533549e-02 1.11815265069852443763354088446249e-03
 	 9.17336979804871499588614369713468e-01 7.04045501511467719524262065533549e-02 1.22584700439817353978533276404050e-02 1.11815265069852443763354088446249e-03
 	 9.17336979804871499588614369713468e-01 1.22584700439817353978533276404050e-02 7.04045501511467719524262065533549e-02 1.11815265069852443763354088446249e-03
 	 2.16472098751412100892110856875661e-01 3.71700471134970150677290234852990e-02 7.46357854135090814651221080566756e-01 3.03647241161237799178529428445472e-03
 	 2.16472098751412100892110856875661e-01 7.46357854135090814651221080566756e-01 3.71700471134970150677290234852990e-02 3.03647241161237799178529428445472e-03
 	 3.71700471134970150677290234852990e-02 2.16472098751412100892110856875661e-01 7.46357854135090814651221080566756e-01 3.03647241161237799178529428445472e-03
 	 3.71700471134970150677290234852990e-02 7.46357854135090814651221080566756e-01 2.16472098751412100892110856875661e-01 3.03647241161237799178529428445472e-03
 	 7.46357854135090814651221080566756e-01 2.16472098751412100892110856875661e-01 3.71700471134970150677290234852990e-02 3.03647241161237799178529428445472e-03
 	 7.46357854135090814651221080566756e-01 3.71700471134970150677290234852990e-02 2.16472098751412100892110856875661e-01 3.03647241161237799178529428445472e-03
 	 7.69268815632590530206869061657926e-02 3.21942006634704513956535265606362e-02 8.90878917773270440072508336015744e-01 1.94018567911140716979179199341843e-03
 	 7.69268815632590530206869061657926e-02 8.90878917773270440072508336015744e-01 3.21942006634704513956535265606362e-02 1.94018567911140716979179199341843e-03
 	 3.21942006634704513956535265606362e-02 7.69268815632590530206869061657926e-02 8.90878917773270440072508336015744e-01 1.94018567911140716979179199341843e-03
 	 3.21942006634704513956535265606362e-02 8.90878917773270440072508336015744e-01 7.69268815632590530206869061657926e-02 1.94018567911140716979179199341843e-03
 	 8.90878917773270440072508336015744e-01 7.69268815632590530206869061657926e-02 3.21942006634704513956535265606362e-02 1.94018567911140716979179199341843e-03
 	 8.90878917773270440072508336015744e-01 3.21942006634704513956535265606362e-02 7.69268815632590530206869061657926e-02 1.94018567911140716979179199341843e-03
 	 4.29222732038551268995973941855482e-01 8.93215271131544107097166573794311e-03 5.61845115250133253503861396893626e-01 1.91492348439295783507629877817635e-03
 	 4.29222732038551268995973941855482e-01 5.61845115250133253503861396893626e-01 8.93215271131544107097166573794311e-03 1.91492348439295783507629877817635e-03
 	 8.93215271131544107097166573794311e-03 4.29222732038551268995973941855482e-01 5.61845115250133253503861396893626e-01 1.91492348439295783507629877817635e-03
 	 8.93215271131544107097166573794311e-03 5.61845115250133253503861396893626e-01 4.29222732038551268995973941855482e-01 1.91492348439295783507629877817635e-03
 	 5.61845115250133253503861396893626e-01 4.29222732038551268995973941855482e-01 8.93215271131544107097166573794311e-03 1.91492348439295783507629877817635e-03
 	 5.61845115250133253503861396893626e-01 8.93215271131544107097166573794311e-03 4.29222732038551268995973941855482e-01 1.91492348439295783507629877817635e-03
 	 3.25147924885204830935947484249482e-01 2.24045215227499733279259430673847e-01 4.50806859887295408029217469447758e-01 8.23213405622759235302776659182200e-03
 	 3.25147924885204830935947484249482e-01 4.50806859887295408029217469447758e-01 2.24045215227499733279259430673847e-01 8.23213405622759235302776659182200e-03
 	 2.24045215227499733279259430673847e-01 3.25147924885204830935947484249482e-01 4.50806859887295408029217469447758e-01 8.23213405622759235302776659182200e-03
 	 2.24045215227499733279259430673847e-01 4.50806859887295408029217469447758e-01 3.25147924885204830935947484249482e-01 8.23213405622759235302776659182200e-03
 	 4.50806859887295408029217469447758e-01 3.25147924885204830935947484249482e-01 2.24045215227499733279259430673847e-01 8.23213405622759235302776659182200e-03
 	 4.50806859887295408029217469447758e-01 2.24045215227499733279259430673847e-01 3.25147924885204830935947484249482e-01 8.23213405622759235302776659182200e-03
 	 2.78272710286936342249930476100417e-01 1.87626216990675664941790046214010e-01 5.34101072722388048319430708943401e-01 7.53952048587020525610702392782514e-03
 	 2.78272710286936342249930476100417e-01 5.34101072722388048319430708943401e-01 1.87626216990675664941790046214010e-01 7.53952048587020525610702392782514e-03
 	 1.87626216990675664941790046214010e-01 2.78272710286936342249930476100417e-01 5.34101072722388048319430708943401e-01 7.53952048587020525610702392782514e-03
 	 1.87626216990675664941790046214010e-01 5.34101072722388048319430708943401e-01 2.78272710286936342249930476100417e-01 7.53952048587020525610702392782514e-03
 	 5.34101072722388048319430708943401e-01 2.78272710286936342249930476100417e-01 1.87626216990675664941790046214010e-01 7.53952048587020525610702392782514e-03
 	 5.34101072722388048319430708943401e-01 1.87626216990675664941790046214010e-01 2.78272710286936342249930476100417e-01 7.53952048587020525610702392782514e-03
 	 2.85210253518710044051687191313249e-01 9.75852132386811378650381954003024e-03 7.05031225157421892468789792474126e-01 1.85517462487268290985409358029301e-03
 	 2.85210253518710044051687191313249e-01 7.05031225157421892468789792474126e-01 9.75852132386811378650381954003024e-03 1.85517462487268290985409358029301e-03
 	 9.75852132386811378650381954003024e-03 2.85210253518710044051687191313249e-01 7.05031225157421892468789792474126e-01 1.85517462487268290985409358029301e-03
 	 9.75852132386811378650381954003024e-03 7.05031225157421892468789792474126e-01 2.85210253518710044051687191313249e-01 1.85517462487268290985409358029301e-03
 	 7.05031225157421892468789792474126e-01 2.85210253518710044051687191313249e-01 9.75852132386811378650381954003024e-03 1.85517462487268290985409358029301e-03
 	 7.05031225157421892468789792474126e-01 9.75852132386811378650381954003024e-03 2.85210253518710044051687191313249e-01 1.85517462487268290985409358029301e-03
 	 2.72725631829831005603637095191516e-01 5.87062906216736027364966332697804e-02 6.68568077548495343087608944188105e-01 4.40482137416807039559385472671238e-03
 	 2.72725631829831005603637095191516e-01 6.68568077548495343087608944188105e-01 5.87062906216736027364966332697804e-02 4.40482137416807039559385472671238e-03
 	 5.87062906216736027364966332697804e-02 2.72725631829831005603637095191516e-01 6.68568077548495343087608944188105e-01 4.40482137416807039559385472671238e-03
 	 5.87062906216736027364966332697804e-02 6.68568077548495343087608944188105e-01 2.72725631829831005603637095191516e-01 4.40482137416807039559385472671238e-03
 	 6.68568077548495343087608944188105e-01 2.72725631829831005603637095191516e-01 5.87062906216736027364966332697804e-02 4.40482137416807039559385472671238e-03
 	 6.68568077548495343087608944188105e-01 5.87062906216736027364966332697804e-02 2.72725631829831005603637095191516e-01 4.40482137416807039559385472671238e-03
 	 4.15469594771239403296902992224204e-01 3.07419996861602630444654238317526e-02 5.53788405542600226105776073382003e-01 3.80720500618590175501143590963693e-03
 	 4.15469594771239403296902992224204e-01 5.53788405542600226105776073382003e-01 3.07419996861602630444654238317526e-02 3.80720500618590175501143590963693e-03
 	 3.07419996861602630444654238317526e-02 4.15469594771239403296902992224204e-01 5.53788405542600226105776073382003e-01 3.80720500618590175501143590963693e-03
 	 3.07419996861602630444654238317526e-02 5.53788405542600226105776073382003e-01 4.15469594771239403296902992224204e-01 3.80720500618590175501143590963693e-03
 	 5.53788405542600226105776073382003e-01 4.15469594771239403296902992224204e-01 3.07419996861602630444654238317526e-02 3.80720500618590175501143590963693e-03
 	 5.53788405542600226105776073382003e-01 3.07419996861602630444654238317526e-02 4.15469594771239403296902992224204e-01 3.80720500618590175501143590963693e-03
 	 2.20577446533709115028543124026328e-01 3.25675363711016695872357828989152e-03 7.76165799829180658164773376483936e-01 9.69444579054541915978659982755516e-04
 	 2.20577446533709115028543124026328e-01 7.76165799829180658164773376483936e-01 3.25675363711016695872357828989152e-03 9.69444579054541915978659982755516e-04
 	 3.25675363711016695872357828989152e-03 2.20577446533709115028543124026328e-01 7.76165799829180658164773376483936e-01 9.69444579054541915978659982755516e-04
 	 3.25675363711016695872357828989152e-03 7.76165799829180658164773376483936e-01 2.20577446533709115028543124026328e-01 9.69444579054541915978659982755516e-04
 	 7.76165799829180658164773376483936e-01 2.20577446533709115028543124026328e-01 3.25675363711016695872357828989152e-03 9.69444579054541915978659982755516e-04
 	 7.76165799829180658164773376483936e-01 3.25675363711016695872357828989152e-03 2.20577446533709115028543124026328e-01 9.69444579054541915978659982755516e-04
 	 3.42885620394358714424498657535878e-01 4.51876229604891294089341613471333e-02 6.11926756645152170044354988931445e-01 4.22408033348078450208706868806985e-03
 	 3.42885620394358714424498657535878e-01 6.11926756645152170044354988931445e-01 4.51876229604891294089341613471333e-02 4.22408033348078450208706868806985e-03
 	 4.51876229604891294089341613471333e-02 3.42885620394358714424498657535878e-01 6.11926756645152170044354988931445e-01 4.22408033348078450208706868806985e-03
 	 4.51876229604891294089341613471333e-02 6.11926756645152170044354988931445e-01 3.42885620394358714424498657535878e-01 4.22408033348078450208706868806985e-03
 	 6.11926756645152170044354988931445e-01 3.42885620394358714424498657535878e-01 4.51876229604891294089341613471333e-02 4.22408033348078450208706868806985e-03
 	 6.11926756645152170044354988931445e-01 4.51876229604891294089341613471333e-02 3.42885620394358714424498657535878e-01 4.22408033348078450208706868806985e-03
 	 2.31503860611680267744816319464007e-01 1.50818510224056762103472806302307e-01 6.17677629164262942396135258604772e-01 6.61932555294043357962952001116719e-03
 	 2.31503860611680267744816319464007e-01 6.17677629164262942396135258604772e-01 1.50818510224056762103472806302307e-01 6.61932555294043357962952001116719e-03
 	 1.50818510224056762103472806302307e-01 2.31503860611680267744816319464007e-01 6.17677629164262942396135258604772e-01 6.61932555294043357962952001116719e-03
 	 1.50818510224056762103472806302307e-01 6.17677629164262942396135258604772e-01 2.31503860611680267744816319464007e-01 6.61932555294043357962952001116719e-03
 	 6.17677629164262942396135258604772e-01 2.31503860611680267744816319464007e-01 1.50818510224056762103472806302307e-01 6.61932555294043357962952001116719e-03
 	 6.17677629164262942396135258604772e-01 1.50818510224056762103472806302307e-01 2.31503860611680267744816319464007e-01 6.61932555294043357962952001116719e-03
 	 3.81017129649182106909677258954616e-02 1.66736740374798728114846824155393e-02 9.45224612997601965069804919039598e-01 1.00140728882683826238275681674850e-03
 	 3.81017129649182106909677258954616e-02 9.45224612997601965069804919039598e-01 1.66736740374798728114846824155393e-02 1.00140728882683826238275681674850e-03
 	 1.66736740374798728114846824155393e-02 3.81017129649182106909677258954616e-02 9.45224612997601965069804919039598e-01 1.00140728882683826238275681674850e-03
 	 1.66736740374798728114846824155393e-02 9.45224612997601965069804919039598e-01 3.81017129649182106909677258954616e-02 1.00140728882683826238275681674850e-03
 	 9.45224612997601965069804919039598e-01 3.81017129649182106909677258954616e-02 1.66736740374798728114846824155393e-02 1.00140728882683826238275681674850e-03
 	 9.45224612997601965069804919039598e-01 1.66736740374798728114846824155393e-02 3.81017129649182106909677258954616e-02 1.00140728882683826238275681674850e-03
 	 3.52891108510167694767289958690526e-01 1.62105242145544004017665429273620e-01 4.85003649344288301215044612035854e-01 7.55631107452150660441780871678930e-03
 	 3.52891108510167694767289958690526e-01 4.85003649344288301215044612035854e-01 1.62105242145544004017665429273620e-01 7.55631107452150660441780871678930e-03
 	 1.62105242145544004017665429273620e-01 3.52891108510167694767289958690526e-01 4.85003649344288301215044612035854e-01 7.55631107452150660441780871678930e-03
 	 1.62105242145544004017665429273620e-01 4.85003649344288301215044612035854e-01 3.52891108510167694767289958690526e-01 7.55631107452150660441780871678930e-03
 	 4.85003649344288301215044612035854e-01 3.52891108510167694767289958690526e-01 1.62105242145544004017665429273620e-01 7.55631107452150660441780871678930e-03
 	 4.85003649344288301215044612035854e-01 1.62105242145544004017665429273620e-01 3.52891108510167694767289958690526e-01 7.55631107452150660441780871678930e-03
 	 4.00076069919581056577584377009771e-01 6.45258600999303599810019704818842e-02 5.35398069980488555685838036879431e-01 5.29870504399362462349953872831065e-03
 	 4.00076069919581056577584377009771e-01 5.35398069980488555685838036879431e-01 6.45258600999303599810019704818842e-02 5.29870504399362462349953872831065e-03
 	 6.45258600999303599810019704818842e-02 4.00076069919581056577584377009771e-01 5.35398069980488555685838036879431e-01 5.29870504399362462349953872831065e-03
 	 6.45258600999303599810019704818842e-02 5.35398069980488555685838036879431e-01 4.00076069919581056577584377009771e-01 5.29870504399362462349953872831065e-03
 	 5.35398069980488555685838036879431e-01 4.00076069919581056577584377009771e-01 6.45258600999303599810019704818842e-02 5.29870504399362462349953872831065e-03
 	 5.35398069980488555685838036879431e-01 6.45258600999303599810019704818842e-02 4.00076069919581056577584377009771e-01 5.29870504399362462349953872831065e-03
 	 1.87784341546537586475906778105127e-01 1.14379695468569117511314914281684e-01 6.97835962984893365401717346685473e-01 5.55468979612842948118123231893151e-03
 	 1.87784341546537586475906778105127e-01 6.97835962984893365401717346685473e-01 1.14379695468569117511314914281684e-01 5.55468979612842948118123231893151e-03
 	 1.14379695468569117511314914281684e-01 1.87784341546537586475906778105127e-01 6.97835962984893365401717346685473e-01 5.55468979612842948118123231893151e-03
 	 1.14379695468569117511314914281684e-01 6.97835962984893365401717346685473e-01 1.87784341546537586475906778105127e-01 5.55468979612842948118123231893151e-03
 	 6.97835962984893365401717346685473e-01 1.87784341546537586475906778105127e-01 1.14379695468569117511314914281684e-01 5.55468979612842948118123231893151e-03
 	 6.97835962984893365401717346685473e-01 1.14379695468569117511314914281684e-01 1.87784341546537586475906778105127e-01 5.55468979612842948118123231893151e-03
 	 2.07376937690341156539375333522912e-01 6.95719958527820786509110462247918e-02 7.23051066456876778687501428066753e-01 4.50598456094945289118758324775627e-03
 	 2.07376937690341156539375333522912e-01 7.23051066456876778687501428066753e-01 6.95719958527820786509110462247918e-02 4.50598456094945289118758324775627e-03
 	 6.95719958527820786509110462247918e-02 2.07376937690341156539375333522912e-01 7.23051066456876778687501428066753e-01 4.50598456094945289118758324775627e-03
 	 6.95719958527820786509110462247918e-02 7.23051066456876778687501428066753e-01 2.07376937690341156539375333522912e-01 4.50598456094945289118758324775627e-03
 	 7.23051066456876778687501428066753e-01 2.07376937690341156539375333522912e-01 6.95719958527820786509110462247918e-02 4.50598456094945289118758324775627e-03
 	 7.23051066456876778687501428066753e-01 6.95719958527820786509110462247918e-02 2.07376937690341156539375333522912e-01 4.50598456094945289118758324775627e-03
 	 1.07803830226375463308130520090344e-01 5.60343597005426088952795282693842e-02 8.36161810073081879224332624289673e-01 3.11313513892029491980650846016943e-03
 	 1.07803830226375463308130520090344e-01 8.36161810073081879224332624289673e-01 5.60343597005426088952795282693842e-02 3.11313513892029491980650846016943e-03
 	 5.60343597005426088952795282693842e-02 1.07803830226375463308130520090344e-01 8.36161810073081879224332624289673e-01 3.11313513892029491980650846016943e-03
 	 5.60343597005426088952795282693842e-02 8.36161810073081879224332624289673e-01 1.07803830226375463308130520090344e-01 3.11313513892029491980650846016943e-03
 	 8.36161810073081879224332624289673e-01 1.07803830226375463308130520090344e-01 5.60343597005426088952795282693842e-02 3.11313513892029491980650846016943e-03
 	 8.36161810073081879224332624289673e-01 5.60343597005426088952795282693842e-02 1.07803830226375463308130520090344e-01 3.11313513892029491980650846016943e-03
 	 1.47901466073126069966647833098250e-01 8.15896657841670980282344771694625e-02 7.70508868142706804249542074103374e-01 4.38983821620269470953346058195166e-03
 	 1.47901466073126069966647833098250e-01 7.70508868142706804249542074103374e-01 8.15896657841670980282344771694625e-02 4.38983821620269470953346058195166e-03
 	 8.15896657841670980282344771694625e-02 1.47901466073126069966647833098250e-01 7.70508868142706804249542074103374e-01 4.38983821620269470953346058195166e-03
 	 8.15896657841670980282344771694625e-02 7.70508868142706804249542074103374e-01 1.47901466073126069966647833098250e-01 4.38983821620269470953346058195166e-03
 	 7.70508868142706804249542074103374e-01 1.47901466073126069966647833098250e-01 8.15896657841670980282344771694625e-02 4.38983821620269470953346058195166e-03
 	 7.70508868142706804249542074103374e-01 8.15896657841670980282344771694625e-02 1.47901466073126069966647833098250e-01 4.38983821620269470953346058195166e-03
 	 1.60042668411358779412267949737725e-01 4.46292737712247408743415633125551e-02 7.95328057817416556041223429929232e-01 3.23855237208292394412989523289070e-03
 	 1.60042668411358779412267949737725e-01 7.95328057817416556041223429929232e-01 4.46292737712247408743415633125551e-02 3.23855237208292394412989523289070e-03
 	 4.46292737712247408743415633125551e-02 1.60042668411358779412267949737725e-01 7.95328057817416556041223429929232e-01 3.23855237208292394412989523289070e-03
 	 4.46292737712247408743415633125551e-02 7.95328057817416556041223429929232e-01 1.60042668411358779412267949737725e-01 3.23855237208292394412989523289070e-03
 	 7.95328057817416556041223429929232e-01 1.60042668411358779412267949737725e-01 4.46292737712247408743415633125551e-02 3.23855237208292394412989523289070e-03
 	 7.95328057817416556041223429929232e-01 4.46292737712247408743415633125551e-02 1.60042668411358779412267949737725e-01 3.23855237208292394412989523289070e-03
 	 3.77876669688772037769552980535082e-01 1.08791876599217379739670263916196e-01 5.13331453712010499224049908661982e-01 6.57429811160953597032330364413610e-03
 	 3.77876669688772037769552980535082e-01 5.13331453712010499224049908661982e-01 1.08791876599217379739670263916196e-01 6.57429811160953597032330364413610e-03
 	 1.08791876599217379739670263916196e-01 3.77876669688772037769552980535082e-01 5.13331453712010499224049908661982e-01 6.57429811160953597032330364413610e-03
 	 1.08791876599217379739670263916196e-01 5.13331453712010499224049908661982e-01 3.77876669688772037769552980535082e-01 6.57429811160953597032330364413610e-03
 	 5.13331453712010499224049908661982e-01 3.77876669688772037769552980535082e-01 1.08791876599217379739670263916196e-01 6.57429811160953597032330364413610e-03
 	 5.13331453712010499224049908661982e-01 1.08791876599217379739670263916196e-01 3.77876669688772037769552980535082e-01 6.57429811160953597032330364413610e-03
 	 3.92233696648084315117266385186667e-02 3.20614858452418710968445658693327e-03 9.57570481750667390485887153772637e-01 4.61937580374655173617859382773077e-04
 	 3.92233696648084315117266385186667e-02 9.57570481750667390485887153772637e-01 3.20614858452418710968445658693327e-03 4.61937580374655173617859382773077e-04
 	 3.20614858452418710968445658693327e-03 3.92233696648084315117266385186667e-02 9.57570481750667390485887153772637e-01 4.61937580374655173617859382773077e-04
 	 3.20614858452418710968445658693327e-03 9.57570481750667390485887153772637e-01 3.92233696648084315117266385186667e-02 4.61937580374655173617859382773077e-04
 	 9.57570481750667390485887153772637e-01 3.92233696648084315117266385186667e-02 3.20614858452418710968445658693327e-03 4.61937580374655173617859382773077e-04
 	 9.57570481750667390485887153772637e-01 3.20614858452418710968445658693327e-03 3.92233696648084315117266385186667e-02 4.61937580374655173617859382773077e-04
 	 3.24304445077138125963500669968198e-01 8.29765480589191445348618003663432e-02 5.92719006863942632357122874964261e-01 5.62032986226963619802443616890741e-03
 	 3.24304445077138125963500669968198e-01 5.92719006863942632357122874964261e-01 8.29765480589191445348618003663432e-02 5.62032986226963619802443616890741e-03
 	 8.29765480589191445348618003663432e-02 3.24304445077138125963500669968198e-01 5.92719006863942632357122874964261e-01 5.62032986226963619802443616890741e-03
 	 8.29765480589191445348618003663432e-02 5.92719006863942632357122874964261e-01 3.24304445077138125963500669968198e-01 5.62032986226963619802443616890741e-03
 	 5.92719006863942632357122874964261e-01 3.24304445077138125963500669968198e-01 8.29765480589191445348618003663432e-02 5.62032986226963619802443616890741e-03
 	 5.92719006863942632357122874964261e-01 8.29765480589191445348618003663432e-02 3.24304445077138125963500669968198e-01 5.62032986226963619802443616890741e-03
 	 3.50984847622504703146262272639433e-01 3.52073500998824817295740352562916e-03 6.45494417367507011817906459327787e-01 1.23276955692974135234130095284399e-03
 	 3.50984847622504703146262272639433e-01 6.45494417367507011817906459327787e-01 3.52073500998824817295740352562916e-03 1.23276955692974135234130095284399e-03
 	 3.52073500998824817295740352562916e-03 3.50984847622504703146262272639433e-01 6.45494417367507011817906459327787e-01 1.23276955692974135234130095284399e-03
 	 3.52073500998824817295740352562916e-03 6.45494417367507011817906459327787e-01 3.50984847622504703146262272639433e-01 1.23276955692974135234130095284399e-03
 	 6.45494417367507011817906459327787e-01 3.50984847622504703146262272639433e-01 3.52073500998824817295740352562916e-03 1.23276955692974135234130095284399e-03
 	 6.45494417367507011817906459327787e-01 3.52073500998824817295740352562916e-03 3.50984847622504703146262272639433e-01 1.23276955692974135234130095284399e-03
 	 4.20870827625693666451667240835377e-01 5.98294728636777515748401690132141e-04 5.78530877645669572295616944757057e-01 4.49010238196147280602399387561263e-04
 	 4.20870827625693666451667240835377e-01 5.78530877645669572295616944757057e-01 5.98294728636777515748401690132141e-04 4.49010238196147280602399387561263e-04
 	 5.98294728636777515748401690132141e-04 4.20870827625693666451667240835377e-01 5.78530877645669572295616944757057e-01 4.49010238196147280602399387561263e-04
 	 5.98294728636777515748401690132141e-04 5.78530877645669572295616944757057e-01 4.20870827625693666451667240835377e-01 4.49010238196147280602399387561263e-04
 	 5.78530877645669572295616944757057e-01 4.20870827625693666451667240835377e-01 5.98294728636777515748401690132141e-04 4.49010238196147280602399387561263e-04
 	 5.78530877645669572295616944757057e-01 5.98294728636777515748401690132141e-04 4.20870827625693666451667240835377e-01 4.49010238196147280602399387561263e-04
 	 2.52656038560264695203017026869929e-01 9.96837194601994935894140326126944e-02 6.47660241979535755696417709259549e-01 5.68818326535674816113452578747456e-03
 	 2.52656038560264695203017026869929e-01 6.47660241979535755696417709259549e-01 9.96837194601994935894140326126944e-02 5.68818326535674816113452578747456e-03
 	 9.96837194601994935894140326126944e-02 2.52656038560264695203017026869929e-01 6.47660241979535755696417709259549e-01 5.68818326535674816113452578747456e-03
 	 9.96837194601994935894140326126944e-02 6.47660241979535755696417709259549e-01 2.52656038560264695203017026869929e-01 5.68818326535674816113452578747456e-03
 	 6.47660241979535755696417709259549e-01 2.52656038560264695203017026869929e-01 9.96837194601994935894140326126944e-02 5.68818326535674816113452578747456e-03
 	 6.47660241979535755696417709259549e-01 9.96837194601994935894140326126944e-02 2.52656038560264695203017026869929e-01 5.68818326535674816113452578747456e-03
 	 3.01670333560527526017835953098256e-01 1.30823914375048672154022710856225e-01 5.67505752064423774072565720416605e-01 6.74790889612226184313126253755399e-03
 	 3.01670333560527526017835953098256e-01 5.67505752064423774072565720416605e-01 1.30823914375048672154022710856225e-01 6.74790889612226184313126253755399e-03
 	 1.30823914375048672154022710856225e-01 3.01670333560527526017835953098256e-01 5.67505752064423774072565720416605e-01 6.74790889612226184313126253755399e-03
 	 1.30823914375048672154022710856225e-01 5.67505752064423774072565720416605e-01 3.01670333560527526017835953098256e-01 6.74790889612226184313126253755399e-03
 	 5.67505752064423774072565720416605e-01 3.01670333560527526017835953098256e-01 1.30823914375048672154022710856225e-01 6.74790889612226184313126253755399e-03
 	 5.67505752064423774072565720416605e-01 1.30823914375048672154022710856225e-01 3.01670333560527526017835953098256e-01 6.74790889612226184313126253755399e-03
 	 1.60613879667907410997429451526841e-02 2.99558774001274126519422935643888e-03 9.80943024293196463858635070209857e-01 2.78560625048633906872264098808500e-04
 	 1.60613879667907410997429451526841e-02 9.80943024293196463858635070209857e-01 2.99558774001274126519422935643888e-03 2.78560625048633906872264098808500e-04
 	 2.99558774001274126519422935643888e-03 1.60613879667907410997429451526841e-02 9.80943024293196463858635070209857e-01 2.78560625048633906872264098808500e-04
 	 2.99558774001274126519422935643888e-03 9.80943024293196463858635070209857e-01 1.60613879667907410997429451526841e-02 2.78560625048633906872264098808500e-04
 	 9.80943024293196463858635070209857e-01 1.60613879667907410997429451526841e-02 2.99558774001274126519422935643888e-03 2.78560625048633906872264098808500e-04
 	 9.80943024293196463858635070209857e-01 2.99558774001274126519422935643888e-03 1.60613879667907410997429451526841e-02 2.78560625048633906872264098808500e-04
 	 ];
 
 	 case  41 

 	 % ALG. DEG.:   41
 	 % PTS CARD.:  309
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw_bar=[
 	 1.81005509308153171577071560705008e-03 1.81005509308153171577071560705008e-03 9.96379889813836960854587232461199e-01 5.22093231255159353457369342255134e-05
 	 1.81005509308153171577071560705008e-03 9.96379889813836960854587232461199e-01 1.81005509308153171577071560705008e-03 5.22093231255159353457369342255134e-05
 	 9.96379889813836960854587232461199e-01 1.81005509308153171577071560705008e-03 1.81005509308153171577071560705008e-03 5.22093231255159353457369342255134e-05
 	 3.14607751383877753958984158089152e-01 3.14607751383877753958984158089152e-01 3.70784497232244492082031683821697e-01 6.44326967088270068789723765689814e-03
 	 3.14607751383877753958984158089152e-01 3.70784497232244492082031683821697e-01 3.14607751383877753958984158089152e-01 6.44326967088270068789723765689814e-03
 	 3.70784497232244492082031683821697e-01 3.14607751383877753958984158089152e-01 3.14607751383877753958984158089152e-01 6.44326967088270068789723765689814e-03
 	 3.71832457839435748248035906726727e-01 3.71832457839435748248035906726727e-01 2.56335084321128503503928186546545e-01 5.64620377250461217416566128690647e-03
 	 3.71832457839435748248035906726727e-01 2.56335084321128503503928186546545e-01 3.71832457839435748248035906726727e-01 5.64620377250461217416566128690647e-03
 	 2.56335084321128503503928186546545e-01 3.71832457839435748248035906726727e-01 3.71832457839435748248035906726727e-01 5.64620377250461217416566128690647e-03
 	 4.81848960175834395425198408702272e-01 4.81848960175834395425198408702272e-01 3.63020796483312091496031825954560e-02 2.97510682474237328487554066214216e-03
 	 4.81848960175834395425198408702272e-01 3.63020796483312091496031825954560e-02 4.81848960175834395425198408702272e-01 2.97510682474237328487554066214216e-03
 	 3.63020796483312091496031825954560e-02 4.81848960175834395425198408702272e-01 4.81848960175834395425198408702272e-01 2.97510682474237328487554066214216e-03
 	 1.42281998308420726262468747336243e-01 1.42281998308420726262468747336243e-01 7.15436003383158602986213736585341e-01 4.24495577711119301267395087506884e-03
 	 1.42281998308420726262468747336243e-01 7.15436003383158602986213736585341e-01 1.42281998308420726262468747336243e-01 4.24495577711119301267395087506884e-03
 	 7.15436003383158602986213736585341e-01 1.42281998308420726262468747336243e-01 1.42281998308420726262468747336243e-01 4.24495577711119301267395087506884e-03
 	 1.74633614866341574378694190272654e-01 1.74633614866341574378694190272654e-01 6.50732770267316906753762850712519e-01 5.03625170897638481382063702085361e-03
 	 1.74633614866341574378694190272654e-01 6.50732770267316906753762850712519e-01 1.74633614866341574378694190272654e-01 5.03625170897638481382063702085361e-03
 	 6.50732770267316906753762850712519e-01 1.74633614866341574378694190272654e-01 1.74633614866341574378694190272654e-01 5.03625170897638481382063702085361e-03
 	 4.25198078415139901764518981508445e-01 4.25198078415139901764518981508445e-01 1.49603843169720196470962036983110e-01 6.01010047716223853170314228577809e-03
 	 4.25198078415139901764518981508445e-01 1.49603843169720196470962036983110e-01 4.25198078415139901764518981508445e-01 6.01010047716223853170314228577809e-03
 	 1.49603843169720196470962036983110e-01 4.25198078415139901764518981508445e-01 4.25198078415139901764518981508445e-01 6.01010047716223853170314228577809e-03
 	 2.09977372337917744804514086354175e-01 2.09977372337917744804514086354175e-01 5.80045255324164510390971827291651e-01 6.07722899697736226864996922358841e-03
 	 2.09977372337917744804514086354175e-01 5.80045255324164510390971827291651e-01 2.09977372337917744804514086354175e-01 6.07722899697736226864996922358841e-03
 	 5.80045255324164510390971827291651e-01 2.09977372337917744804514086354175e-01 2.09977372337917744804514086354175e-01 6.07722899697736226864996922358841e-03
 	 2.62739973625342737584276164852781e-01 2.62739973625342737584276164852781e-01 4.74520052749314524831447670294438e-01 6.76714020842247073600494999823241e-03
 	 2.62739973625342737584276164852781e-01 4.74520052749314524831447670294438e-01 2.62739973625342737584276164852781e-01 6.76714020842247073600494999823241e-03
 	 4.74520052749314524831447670294438e-01 2.62739973625342737584276164852781e-01 2.62739973625342737584276164852781e-01 6.76714020842247073600494999823241e-03
 	 4.98603639231114337260208912994131e-01 4.98603639231114337260208912994131e-01 2.79272153777132547958217401173897e-03 1.02363997030043333245907799522456e-03
 	 4.98603639231114337260208912994131e-01 2.79272153777132547958217401173897e-03 4.98603639231114337260208912994131e-01 1.02363997030043333245907799522456e-03
 	 2.79272153777132547958217401173897e-03 4.98603639231114337260208912994131e-01 4.98603639231114337260208912994131e-01 1.02363997030043333245907799522456e-03
 	 3.99566525526970250936642514716368e-01 3.99566525526970250936642514716368e-01 2.00866948946059498126714970567264e-01 7.23010973295169605268295498490261e-03
 	 3.99566525526970250936642514716368e-01 2.00866948946059498126714970567264e-01 3.99566525526970250936642514716368e-01 7.23010973295169605268295498490261e-03
 	 2.00866948946059498126714970567264e-01 3.99566525526970250936642514716368e-01 3.99566525526970250936642514716368e-01 7.23010973295169605268295498490261e-03
 	 4.66761057785514965612350124501972e-01 4.66761057785514965612350124501972e-01 6.64778844289700687752997509960551e-02 5.13387032523844513004496192820625e-03
 	 4.66761057785514965612350124501972e-01 6.64778844289700687752997509960551e-02 4.66761057785514965612350124501972e-01 5.13387032523844513004496192820625e-03
 	 6.64778844289700687752997509960551e-02 4.66761057785514965612350124501972e-01 4.66761057785514965612350124501972e-01 5.13387032523844513004496192820625e-03
 	 1.03095485576030487795406997975078e-01 1.03095485576030487795406997975078e-01 7.93809028847939024409186004049843e-01 3.96956903935961110535535212306968e-03
 	 1.03095485576030487795406997975078e-01 7.93809028847939024409186004049843e-01 1.03095485576030487795406997975078e-01 3.96956903935961110535535212306968e-03
 	 7.93809028847939024409186004049843e-01 1.03095485576030487795406997975078e-01 1.03095485576030487795406997975078e-01 3.96956903935961110535535212306968e-03
 	 9.33847895869260646861675922991708e-01 2.67728022087155327624063971825308e-02 3.93793019220238238453646317793755e-02 9.46633996452899252951884712103947e-04
 	 9.33847895869260646861675922991708e-01 3.93793019220238238453646317793755e-02 2.67728022087155327624063971825308e-02 9.46633996452899252951884712103947e-04
 	 2.67728022087155327624063971825308e-02 9.33847895869260646861675922991708e-01 3.93793019220238238453646317793755e-02 9.46633996452899252951884712103947e-04
 	 2.67728022087155327624063971825308e-02 3.93793019220238238453646317793755e-02 9.33847895869260646861675922991708e-01 9.46633996452899252951884712103947e-04
 	 3.93793019220238238453646317793755e-02 9.33847895869260646861675922991708e-01 2.67728022087155327624063971825308e-02 9.46633996452899252951884712103947e-04
 	 3.93793019220238238453646317793755e-02 2.67728022087155327624063971825308e-02 9.33847895869260646861675922991708e-01 9.46633996452899252951884712103947e-04
 	 7.08749727266859141927568543906091e-02 2.14673861123130318984131292836537e-02 9.07657641161001005336572688975139e-01 1.07783832938708316363796146930554e-03
 	 7.08749727266859141927568543906091e-02 9.07657641161001005336572688975139e-01 2.14673861123130318984131292836537e-02 1.07783832938708316363796146930554e-03
 	 2.14673861123130318984131292836537e-02 7.08749727266859141927568543906091e-02 9.07657641161001005336572688975139e-01 1.07783832938708316363796146930554e-03
 	 2.14673861123130318984131292836537e-02 9.07657641161001005336572688975139e-01 7.08749727266859141927568543906091e-02 1.07783832938708316363796146930554e-03
 	 9.07657641161001005336572688975139e-01 7.08749727266859141927568543906091e-02 2.14673861123130318984131292836537e-02 1.07783832938708316363796146930554e-03
 	 9.07657641161001005336572688975139e-01 2.14673861123130318984131292836537e-02 7.08749727266859141927568543906091e-02 1.07783832938708316363796146930554e-03
 	 2.27676589099523561665616711024995e-02 1.19851112427548141953215221633400e-02 9.65247229847292831372840282710968e-01 5.53551406304639238495357567160227e-04
 	 2.27676589099523561665616711024995e-02 9.65247229847292831372840282710968e-01 1.19851112427548141953215221633400e-02 5.53551406304639238495357567160227e-04
 	 1.19851112427548141953215221633400e-02 2.27676589099523561665616711024995e-02 9.65247229847292831372840282710968e-01 5.53551406304639238495357567160227e-04
 	 1.19851112427548141953215221633400e-02 9.65247229847292831372840282710968e-01 2.27676589099523561665616711024995e-02 5.53551406304639238495357567160227e-04
 	 9.65247229847292831372840282710968e-01 2.27676589099523561665616711024995e-02 1.19851112427548141953215221633400e-02 5.53551406304639238495357567160227e-04
 	 9.65247229847292831372840282710968e-01 1.19851112427548141953215221633400e-02 2.27676589099523561665616711024995e-02 5.53551406304639238495357567160227e-04
 	 2.12702658519097947964482386851159e-01 9.64112026242689990063183813617798e-02 6.90886138856632969762472384900320e-01 3.74472091527996726184612796828333e-03
 	 2.12702658519097947964482386851159e-01 6.90886138856632969762472384900320e-01 9.64112026242689990063183813617798e-02 3.74472091527996726184612796828333e-03
 	 9.64112026242689990063183813617798e-02 2.12702658519097947964482386851159e-01 6.90886138856632969762472384900320e-01 3.74472091527996726184612796828333e-03
 	 9.64112026242689990063183813617798e-02 6.90886138856632969762472384900320e-01 2.12702658519097947964482386851159e-01 3.74472091527996726184612796828333e-03
 	 6.90886138856632969762472384900320e-01 2.12702658519097947964482386851159e-01 9.64112026242689990063183813617798e-02 3.74472091527996726184612796828333e-03
 	 6.90886138856632969762472384900320e-01 9.64112026242689990063183813617798e-02 2.12702658519097947964482386851159e-01 3.74472091527996726184612796828333e-03
 	 1.97079994941520175721905161481118e-01 1.27978222846432787562775956757832e-01 6.74941782212047036715318881761050e-01 4.07373920962235663151274067672603e-03
 	 1.97079994941520175721905161481118e-01 6.74941782212047036715318881761050e-01 1.27978222846432787562775956757832e-01 4.07373920962235663151274067672603e-03
 	 1.27978222846432787562775956757832e-01 1.97079994941520175721905161481118e-01 6.74941782212047036715318881761050e-01 4.07373920962235663151274067672603e-03
 	 1.27978222846432787562775956757832e-01 6.74941782212047036715318881761050e-01 1.97079994941520175721905161481118e-01 4.07373920962235663151274067672603e-03
 	 6.74941782212047036715318881761050e-01 1.97079994941520175721905161481118e-01 1.27978222846432787562775956757832e-01 4.07373920962235663151274067672603e-03
 	 6.74941782212047036715318881761050e-01 1.27978222846432787562775956757832e-01 1.97079994941520175721905161481118e-01 4.07373920962235663151274067672603e-03
 	 6.39130414360007115259776355742360e-02 4.23991066111561523688244790264434e-02 8.93687851952843059777364942419808e-01 1.78875457066462670296935755231971e-03
 	 6.39130414360007115259776355742360e-02 8.93687851952843059777364942419808e-01 4.23991066111561523688244790264434e-02 1.78875457066462670296935755231971e-03
 	 4.23991066111561523688244790264434e-02 6.39130414360007115259776355742360e-02 8.93687851952843059777364942419808e-01 1.78875457066462670296935755231971e-03
 	 4.23991066111561523688244790264434e-02 8.93687851952843059777364942419808e-01 6.39130414360007115259776355742360e-02 1.78875457066462670296935755231971e-03
 	 8.93687851952843059777364942419808e-01 6.39130414360007115259776355742360e-02 4.23991066111561523688244790264434e-02 1.78875457066462670296935755231971e-03
 	 8.93687851952843059777364942419808e-01 4.23991066111561523688244790264434e-02 6.39130414360007115259776355742360e-02 1.78875457066462670296935755231971e-03
 	 9.16254632757576847890135240959353e-02 1.16869974011746882713858042279753e-02 8.96687539323067550611767728696577e-01 1.03142473814346949390063912233018e-03
 	 9.16254632757576847890135240959353e-02 8.96687539323067550611767728696577e-01 1.16869974011746882713858042279753e-02 1.03142473814346949390063912233018e-03
 	 1.16869974011746882713858042279753e-02 9.16254632757576847890135240959353e-02 8.96687539323067550611767728696577e-01 1.03142473814346949390063912233018e-03
 	 1.16869974011746882713858042279753e-02 8.96687539323067550611767728696577e-01 9.16254632757576847890135240959353e-02 1.03142473814346949390063912233018e-03
 	 8.96687539323067550611767728696577e-01 9.16254632757576847890135240959353e-02 1.16869974011746882713858042279753e-02 1.03142473814346949390063912233018e-03
 	 8.96687539323067550611767728696577e-01 1.16869974011746882713858042279753e-02 9.16254632757576847890135240959353e-02 1.03142473814346949390063912233018e-03
 	 8.89175403557379839813989974572905e-02 6.32415329385831864739131447095133e-02 8.47840926705678898933626896905480e-01 2.53220726832706398770622691074550e-03
 	 8.89175403557379839813989974572905e-02 8.47840926705678898933626896905480e-01 6.32415329385831864739131447095133e-02 2.53220726832706398770622691074550e-03
 	 6.32415329385831864739131447095133e-02 8.89175403557379839813989974572905e-02 8.47840926705678898933626896905480e-01 2.53220726832706398770622691074550e-03
 	 6.32415329385831864739131447095133e-02 8.47840926705678898933626896905480e-01 8.89175403557379839813989974572905e-02 2.53220726832706398770622691074550e-03
 	 8.47840926705678898933626896905480e-01 8.89175403557379839813989974572905e-02 6.32415329385831864739131447095133e-02 2.53220726832706398770622691074550e-03
 	 8.47840926705678898933626896905480e-01 6.32415329385831864739131447095133e-02 8.89175403557379839813989974572905e-02 2.53220726832706398770622691074550e-03
 	 4.59230558903699015438348851603223e-01 1.48409448407795345470372438967388e-02 5.25928496255521404911803529103054e-01 2.25247855792463534327363383624743e-03
 	 4.59230558903699015438348851603223e-01 5.25928496255521404911803529103054e-01 1.48409448407795345470372438967388e-02 2.25247855792463534327363383624743e-03
 	 1.48409448407795345470372438967388e-02 4.59230558903699015438348851603223e-01 5.25928496255521404911803529103054e-01 2.25247855792463534327363383624743e-03
 	 1.48409448407795345470372438967388e-02 5.25928496255521404911803529103054e-01 4.59230558903699015438348851603223e-01 2.25247855792463534327363383624743e-03
 	 5.25928496255521404911803529103054e-01 4.59230558903699015438348851603223e-01 1.48409448407795345470372438967388e-02 2.25247855792463534327363383624743e-03
 	 5.25928496255521404911803529103054e-01 1.48409448407795345470372438967388e-02 4.59230558903699015438348851603223e-01 2.25247855792463534327363383624743e-03
 	 3.38843822348438572511497568484629e-02 1.84003961561307214853111524632823e-03 9.64275578149543122208342538215220e-01 2.81837508465940364456997491160450e-04
 	 3.38843822348438572511497568484629e-02 9.64275578149543122208342538215220e-01 1.84003961561307214853111524632823e-03 2.81837508465940364456997491160450e-04
 	 1.84003961561307214853111524632823e-03 3.38843822348438572511497568484629e-02 9.64275578149543122208342538215220e-01 2.81837508465940364456997491160450e-04
 	 1.84003961561307214853111524632823e-03 9.64275578149543122208342538215220e-01 3.38843822348438572511497568484629e-02 2.81837508465940364456997491160450e-04
 	 9.64275578149543122208342538215220e-01 3.38843822348438572511497568484629e-02 1.84003961561307214853111524632823e-03 2.81837508465940364456997491160450e-04
 	 9.64275578149543122208342538215220e-01 1.84003961561307214853111524632823e-03 3.38843822348438572511497568484629e-02 2.81837508465940364456997491160450e-04
 	 3.20075210406615351388381895958446e-01 2.58057113739871668567360529777943e-01 4.21867675853512980044257574263611e-01 6.10937306964821642135676782459086e-03
 	 3.20075210406615351388381895958446e-01 4.21867675853512980044257574263611e-01 2.58057113739871668567360529777943e-01 6.10937306964821642135676782459086e-03
 	 2.58057113739871668567360529777943e-01 3.20075210406615351388381895958446e-01 4.21867675853512980044257574263611e-01 6.10937306964821642135676782459086e-03
 	 2.58057113739871668567360529777943e-01 4.21867675853512980044257574263611e-01 3.20075210406615351388381895958446e-01 6.10937306964821642135676782459086e-03
 	 4.21867675853512980044257574263611e-01 3.20075210406615351388381895958446e-01 2.58057113739871668567360529777943e-01 6.10937306964821642135676782459086e-03
 	 4.21867675853512980044257574263611e-01 2.58057113739871668567360529777943e-01 3.20075210406615351388381895958446e-01 6.10937306964821642135676782459086e-03
 	 4.22068492531888939112150183063932e-01 3.62192254340186342576046740759921e-02 5.41712282034092384996881719416706e-01 3.30897121530235359745941714493256e-03
 	 4.22068492531888939112150183063932e-01 5.41712282034092384996881719416706e-01 3.62192254340186342576046740759921e-02 3.30897121530235359745941714493256e-03
 	 3.62192254340186342576046740759921e-02 4.22068492531888939112150183063932e-01 5.41712282034092384996881719416706e-01 3.30897121530235359745941714493256e-03
 	 3.62192254340186342576046740759921e-02 5.41712282034092384996881719416706e-01 4.22068492531888939112150183063932e-01 3.30897121530235359745941714493256e-03
 	 5.41712282034092384996881719416706e-01 4.22068492531888939112150183063932e-01 3.62192254340186342576046740759921e-02 3.30897121530235359745941714493256e-03
 	 5.41712282034092384996881719416706e-01 3.62192254340186342576046740759921e-02 4.22068492531888939112150183063932e-01 3.30897121530235359745941714493256e-03
 	 4.78764410729283981793535929227801e-02 1.05439660443664238315131242984535e-02 9.41579592882705096457129911868833e-01 7.50340374100598212110668772112376e-04
 	 4.78764410729283981793535929227801e-02 9.41579592882705096457129911868833e-01 1.05439660443664238315131242984535e-02 7.50340374100598212110668772112376e-04
 	 1.05439660443664238315131242984535e-02 4.78764410729283981793535929227801e-02 9.41579592882705096457129911868833e-01 7.50340374100598212110668772112376e-04
 	 1.05439660443664238315131242984535e-02 9.41579592882705096457129911868833e-01 4.78764410729283981793535929227801e-02 7.50340374100598212110668772112376e-04
 	 9.41579592882705096457129911868833e-01 4.78764410729283981793535929227801e-02 1.05439660443664238315131242984535e-02 7.50340374100598212110668772112376e-04
 	 9.41579592882705096457129911868833e-01 1.05439660443664238315131242984535e-02 4.78764410729283981793535929227801e-02 7.50340374100598212110668772112376e-04
 	 3.61799022706076223165894134581322e-01 1.51026887499565554140446010933374e-01 4.87174089794358222693659854485304e-01 6.22365923320957348946480536255876e-03
 	 3.61799022706076223165894134581322e-01 4.87174089794358222693659854485304e-01 1.51026887499565554140446010933374e-01 6.22365923320957348946480536255876e-03
 	 1.51026887499565554140446010933374e-01 3.61799022706076223165894134581322e-01 4.87174089794358222693659854485304e-01 6.22365923320957348946480536255876e-03
 	 1.51026887499565554140446010933374e-01 4.87174089794358222693659854485304e-01 3.61799022706076223165894134581322e-01 6.22365923320957348946480536255876e-03
 	 4.87174089794358222693659854485304e-01 3.61799022706076223165894134581322e-01 1.51026887499565554140446010933374e-01 6.22365923320957348946480536255876e-03
 	 4.87174089794358222693659854485304e-01 1.51026887499565554140446010933374e-01 3.61799022706076223165894134581322e-01 6.22365923320957348946480536255876e-03
 	 6.84569430922209731793515175013454e-02 2.48206090173236360030273317534011e-03 9.29060996006046746487072596210055e-01 4.90420871014329330661585260031643e-04
 	 6.84569430922209731793515175013454e-02 9.29060996006046746487072596210055e-01 2.48206090173236360030273317534011e-03 4.90420871014329330661585260031643e-04
 	 2.48206090173236360030273317534011e-03 6.84569430922209731793515175013454e-02 9.29060996006046746487072596210055e-01 4.90420871014329330661585260031643e-04
 	 2.48206090173236360030273317534011e-03 9.29060996006046746487072596210055e-01 6.84569430922209731793515175013454e-02 4.90420871014329330661585260031643e-04
 	 9.29060996006046746487072596210055e-01 6.84569430922209731793515175013454e-02 2.48206090173236360030273317534011e-03 4.90420871014329330661585260031643e-04
 	 9.29060996006046746487072596210055e-01 2.48206090173236360030273317534011e-03 6.84569430922209731793515175013454e-02 4.90420871014329330661585260031643e-04
 	 2.36288472596456022856159506773110e-01 1.54957767021962872222573537328572e-01 6.08753760381581132676842571527231e-01 5.89064426570423248924468495602014e-03
 	 2.36288472596456022856159506773110e-01 6.08753760381581132676842571527231e-01 1.54957767021962872222573537328572e-01 5.89064426570423248924468495602014e-03
 	 1.54957767021962872222573537328572e-01 2.36288472596456022856159506773110e-01 6.08753760381581132676842571527231e-01 5.89064426570423248924468495602014e-03
 	 1.54957767021962872222573537328572e-01 6.08753760381581132676842571527231e-01 2.36288472596456022856159506773110e-01 5.89064426570423248924468495602014e-03
 	 6.08753760381581132676842571527231e-01 2.36288472596456022856159506773110e-01 1.54957767021962872222573537328572e-01 5.89064426570423248924468495602014e-03
 	 6.08753760381581132676842571527231e-01 1.54957767021962872222573537328572e-01 2.36288472596456022856159506773110e-01 5.89064426570423248924468495602014e-03
 	 2.97895418985049564852829462324735e-01 1.51961553665098864085436503046367e-01 5.50143027349851543306158418999985e-01 6.23812011911400315922193726692058e-03
 	 2.97895418985049564852829462324735e-01 5.50143027349851543306158418999985e-01 1.51961553665098864085436503046367e-01 6.23812011911400315922193726692058e-03
 	 1.51961553665098864085436503046367e-01 2.97895418985049564852829462324735e-01 5.50143027349851543306158418999985e-01 6.23812011911400315922193726692058e-03
 	 1.51961553665098864085436503046367e-01 5.50143027349851543306158418999985e-01 2.97895418985049564852829462324735e-01 6.23812011911400315922193726692058e-03
 	 5.50143027349851543306158418999985e-01 2.97895418985049564852829462324735e-01 1.51961553665098864085436503046367e-01 6.23812011911400315922193726692058e-03
 	 5.50143027349851543306158418999985e-01 1.51961553665098864085436503046367e-01 2.97895418985049564852829462324735e-01 6.23812011911400315922193726692058e-03
 	 1.12557251523921778013637151616422e-01 2.37754573037215425485024766771858e-03 8.85065202745705992271041395724751e-01 5.88918188128133204134462275192163e-04
 	 1.12557251523921778013637151616422e-01 8.85065202745705992271041395724751e-01 2.37754573037215425485024766771858e-03 5.88918188128133204134462275192163e-04
 	 2.37754573037215425485024766771858e-03 1.12557251523921778013637151616422e-01 8.85065202745705992271041395724751e-01 5.88918188128133204134462275192163e-04
 	 2.37754573037215425485024766771858e-03 8.85065202745705992271041395724751e-01 1.12557251523921778013637151616422e-01 5.88918188128133204134462275192163e-04
 	 8.85065202745705992271041395724751e-01 1.12557251523921778013637151616422e-01 2.37754573037215425485024766771858e-03 5.88918188128133204134462275192163e-04
 	 8.85065202745705992271041395724751e-01 2.37754573037215425485024766771858e-03 1.12557251523921778013637151616422e-01 5.88918188128133204134462275192163e-04
 	 1.20658629713076021722217845422165e-02 3.04923808583817523149006589733290e-03 9.84884898942854247749778551224153e-01 2.39051561804768910235105550121659e-04
 	 1.20658629713076021722217845422165e-02 9.84884898942854247749778551224153e-01 3.04923808583817523149006589733290e-03 2.39051561804768910235105550121659e-04
 	 3.04923808583817523149006589733290e-03 1.20658629713076021722217845422165e-02 9.84884898942854247749778551224153e-01 2.39051561804768910235105550121659e-04
 	 3.04923808583817523149006589733290e-03 9.84884898942854247749778551224153e-01 1.20658629713076021722217845422165e-02 2.39051561804768910235105550121659e-04
 	 9.84884898942854247749778551224153e-01 1.20658629713076021722217845422165e-02 3.04923808583817523149006589733290e-03 2.39051561804768910235105550121659e-04
 	 9.84884898942854247749778551224153e-01 3.04923808583817523149006589733290e-03 1.20658629713076021722217845422165e-02 2.39051561804768910235105550121659e-04
 	 3.90653097086316902775138260039967e-01 1.50754657505242934539824162243349e-02 5.94271437163158777750027184083592e-01 2.33813375986911906739829092316540e-03
 	 3.90653097086316902775138260039967e-01 5.94271437163158777750027184083592e-01 1.50754657505242934539824162243349e-02 2.33813375986911906739829092316540e-03
 	 1.50754657505242934539824162243349e-02 3.90653097086316902775138260039967e-01 5.94271437163158777750027184083592e-01 2.33813375986911906739829092316540e-03
 	 1.50754657505242934539824162243349e-02 5.94271437163158777750027184083592e-01 3.90653097086316902775138260039967e-01 2.33813375986911906739829092316540e-03
 	 5.94271437163158777750027184083592e-01 3.90653097086316902775138260039967e-01 1.50754657505242934539824162243349e-02 2.33813375986911906739829092316540e-03
 	 5.94271437163158777750027184083592e-01 1.50754657505242934539824162243349e-02 3.90653097086316902775138260039967e-01 2.33813375986911906739829092316540e-03
 	 4.27410727373970178444295697772759e-01 2.88455410756848591377621282560995e-03 5.69704718518461272758202085242374e-01 1.04543297077560682142860493115677e-03
 	 4.27410727373970178444295697772759e-01 5.69704718518461272758202085242374e-01 2.88455410756848591377621282560995e-03 1.04543297077560682142860493115677e-03
 	 2.88455410756848591377621282560995e-03 4.27410727373970178444295697772759e-01 5.69704718518461272758202085242374e-01 1.04543297077560682142860493115677e-03
 	 2.88455410756848591377621282560995e-03 5.69704718518461272758202085242374e-01 4.27410727373970178444295697772759e-01 1.04543297077560682142860493115677e-03
 	 5.69704718518461272758202085242374e-01 4.27410727373970178444295697772759e-01 2.88455410756848591377621282560995e-03 1.04543297077560682142860493115677e-03
 	 5.69704718518461272758202085242374e-01 2.88455410756848591377621282560995e-03 4.27410727373970178444295697772759e-01 1.04543297077560682142860493115677e-03
 	 4.11845522097719740628463114262559e-01 1.04765137725845669525170933411573e-01 4.83389340176434589846365952325868e-01 5.99018912030955565095613479797976e-03
 	 4.11845522097719740628463114262559e-01 4.83389340176434589846365952325868e-01 1.04765137725845669525170933411573e-01 5.99018912030955565095613479797976e-03
 	 1.04765137725845669525170933411573e-01 4.11845522097719740628463114262559e-01 4.83389340176434589846365952325868e-01 5.99018912030955565095613479797976e-03
 	 1.04765137725845669525170933411573e-01 4.83389340176434589846365952325868e-01 4.11845522097719740628463114262559e-01 5.99018912030955565095613479797976e-03
 	 4.83389340176434589846365952325868e-01 4.11845522097719740628463114262559e-01 1.04765137725845669525170933411573e-01 5.99018912030955565095613479797976e-03
 	 4.83389340176434589846365952325868e-01 1.04765137725845669525170933411573e-01 4.11845522097719740628463114262559e-01 5.99018912030955565095613479797976e-03
 	 3.22221194516843667532413064691355e-01 1.48317675755721811031717649598249e-02 6.62947037907584246774206349073211e-01 2.28824958726125135891060757842297e-03
 	 3.22221194516843667532413064691355e-01 6.62947037907584246774206349073211e-01 1.48317675755721811031717649598249e-02 2.28824958726125135891060757842297e-03
 	 1.48317675755721811031717649598249e-02 3.22221194516843667532413064691355e-01 6.62947037907584246774206349073211e-01 2.28824958726125135891060757842297e-03
 	 1.48317675755721811031717649598249e-02 6.62947037907584246774206349073211e-01 3.22221194516843667532413064691355e-01 2.28824958726125135891060757842297e-03
 	 6.62947037907584246774206349073211e-01 3.22221194516843667532413064691355e-01 1.48317675755721811031717649598249e-02 2.28824958726125135891060757842297e-03
 	 6.62947037907584246774206349073211e-01 1.48317675755721811031717649598249e-02 3.22221194516843667532413064691355e-01 2.28824958726125135891060757842297e-03
 	 3.54524901630881295044872558719362e-01 3.67451935646271599100742832888500e-02 6.08729904804491517289477542362874e-01 3.61048705655584237228516997220140e-03
 	 3.54524901630881295044872558719362e-01 6.08729904804491517289477542362874e-01 3.67451935646271599100742832888500e-02 3.61048705655584237228516997220140e-03
 	 3.67451935646271599100742832888500e-02 3.54524901630881295044872558719362e-01 6.08729904804491517289477542362874e-01 3.61048705655584237228516997220140e-03
 	 3.67451935646271599100742832888500e-02 6.08729904804491517289477542362874e-01 3.54524901630881295044872558719362e-01 3.61048705655584237228516997220140e-03
 	 6.08729904804491517289477542362874e-01 3.54524901630881295044872558719362e-01 3.67451935646271599100742832888500e-02 3.61048705655584237228516997220140e-03
 	 6.08729904804491517289477542362874e-01 3.67451935646271599100742832888500e-02 3.54524901630881295044872558719362e-01 3.61048705655584237228516997220140e-03
 	 3.32027617298779720300672124722041e-01 2.02832977056254276648772361113515e-01 4.65139405644966030806131129793357e-01 7.05865780855016288625192188987967e-03
 	 3.32027617298779720300672124722041e-01 4.65139405644966030806131129793357e-01 2.02832977056254276648772361113515e-01 7.05865780855016288625192188987967e-03
 	 2.02832977056254276648772361113515e-01 3.32027617298779720300672124722041e-01 4.65139405644966030806131129793357e-01 7.05865780855016288625192188987967e-03
 	 2.02832977056254276648772361113515e-01 4.65139405644966030806131129793357e-01 3.32027617298779720300672124722041e-01 7.05865780855016288625192188987967e-03
 	 4.65139405644966030806131129793357e-01 3.32027617298779720300672124722041e-01 2.02832977056254276648772361113515e-01 7.05865780855016288625192188987967e-03
 	 4.65139405644966030806131129793357e-01 2.02832977056254276648772361113515e-01 3.32027617298779720300672124722041e-01 7.05865780855016288625192188987967e-03
 	 2.53029739084772276047630157336243e-01 6.55893176896967106115354795292660e-02 6.81380943225531110485349017835688e-01 4.37855257370275540579340756153215e-03
 	 2.53029739084772276047630157336243e-01 6.81380943225531110485349017835688e-01 6.55893176896967106115354795292660e-02 4.37855257370275540579340756153215e-03
 	 6.55893176896967106115354795292660e-02 2.53029739084772276047630157336243e-01 6.81380943225531110485349017835688e-01 4.37855257370275540579340756153215e-03
 	 6.55893176896967106115354795292660e-02 6.81380943225531110485349017835688e-01 2.53029739084772276047630157336243e-01 4.37855257370275540579340756153215e-03
 	 6.81380943225531110485349017835688e-01 2.53029739084772276047630157336243e-01 6.55893176896967106115354795292660e-02 4.37855257370275540579340756153215e-03
 	 6.81380943225531110485349017835688e-01 6.55893176896967106115354795292660e-02 2.53029739084772276047630157336243e-01 4.37855257370275540579340756153215e-03
 	 3.57039904894509707578009738426772e-01 2.83340788181253838001749656427819e-03 6.40126687223677826032997018046444e-01 1.01713835895030795843096971253772e-03
 	 3.57039904894509707578009738426772e-01 6.40126687223677826032997018046444e-01 2.83340788181253838001749656427819e-03 1.01713835895030795843096971253772e-03
 	 2.83340788181253838001749656427819e-03 3.57039904894509707578009738426772e-01 6.40126687223677826032997018046444e-01 1.01713835895030795843096971253772e-03
 	 2.83340788181253838001749656427819e-03 6.40126687223677826032997018046444e-01 3.57039904894509707578009738426772e-01 1.01713835895030795843096971253772e-03
 	 6.40126687223677826032997018046444e-01 3.57039904894509707578009738426772e-01 2.83340788181253838001749656427819e-03 1.01713835895030795843096971253772e-03
 	 6.40126687223677826032997018046444e-01 2.83340788181253838001749656427819e-03 3.57039904894509707578009738426772e-01 1.01713835895030795843096971253772e-03
 	 2.87060689211655395425282222277019e-01 3.60525157666744186513163583640562e-02 6.76886795021670151228931899822783e-01 3.45548452472045890954133184891361e-03
 	 2.87060689211655395425282222277019e-01 6.76886795021670151228931899822783e-01 3.60525157666744186513163583640562e-02 3.45548452472045890954133184891361e-03
 	 3.60525157666744186513163583640562e-02 2.87060689211655395425282222277019e-01 6.76886795021670151228931899822783e-01 3.45548452472045890954133184891361e-03
 	 3.60525157666744186513163583640562e-02 6.76886795021670151228931899822783e-01 2.87060689211655395425282222277019e-01 3.45548452472045890954133184891361e-03
 	 6.76886795021670151228931899822783e-01 2.87060689211655395425282222277019e-01 3.60525157666744186513163583640562e-02 3.45548452472045890954133184891361e-03
 	 6.76886795021670151228931899822783e-01 3.60525157666744186513163583640562e-02 2.87060689211655395425282222277019e-01 3.45548452472045890954133184891361e-03
 	 1.36131351631136071622663052949065e-01 1.41561971271275018058322103797764e-02 8.49712451241736443918739496439230e-01 1.66261924157719265769672656318789e-03
 	 1.36131351631136071622663052949065e-01 8.49712451241736443918739496439230e-01 1.41561971271275018058322103797764e-02 1.66261924157719265769672656318789e-03
 	 1.41561971271275018058322103797764e-02 1.36131351631136071622663052949065e-01 8.49712451241736443918739496439230e-01 1.66261924157719265769672656318789e-03
 	 1.41561971271275018058322103797764e-02 8.49712451241736443918739496439230e-01 1.36131351631136071622663052949065e-01 1.66261924157719265769672656318789e-03
 	 8.49712451241736443918739496439230e-01 1.36131351631136071622663052949065e-01 1.41561971271275018058322103797764e-02 1.66261924157719265769672656318789e-03
 	 8.49712451241736443918739496439230e-01 1.41561971271275018058322103797764e-02 1.36131351631136071622663052949065e-01 1.66261924157719265769672656318789e-03
 	 1.32224125661775021578492328444554e-01 6.37728096721327936124978918996931e-02 8.04003064666092170931221971841296e-01 3.35117065326869705346735095474742e-03
 	 1.32224125661775021578492328444554e-01 8.04003064666092170931221971841296e-01 6.37728096721327936124978918996931e-02 3.35117065326869705346735095474742e-03
 	 6.37728096721327936124978918996931e-02 1.32224125661775021578492328444554e-01 8.04003064666092170931221971841296e-01 3.35117065326869705346735095474742e-03
 	 6.37728096721327936124978918996931e-02 8.04003064666092170931221971841296e-01 1.32224125661775021578492328444554e-01 3.35117065326869705346735095474742e-03
 	 8.04003064666092170931221971841296e-01 1.32224125661775021578492328444554e-01 6.37728096721327936124978918996931e-02 3.35117065326869705346735095474742e-03
 	 8.04003064666092170931221971841296e-01 6.37728096721327936124978918996931e-02 1.32224125661775021578492328444554e-01 3.35117065326869705346735095474742e-03
 	 1.07924219839552332222964992070047e-01 3.35534395458731288242049117798160e-02 8.58522340614574552830617903964594e-01 2.38656465053288958239052774956690e-03
 	 1.07924219839552332222964992070047e-01 8.58522340614574552830617903964594e-01 3.35534395458731288242049117798160e-02 2.38656465053288958239052774956690e-03
 	 3.35534395458731288242049117798160e-02 1.07924219839552332222964992070047e-01 8.58522340614574552830617903964594e-01 2.38656465053288958239052774956690e-03
 	 3.35534395458731288242049117798160e-02 8.58522340614574552830617903964594e-01 1.07924219839552332222964992070047e-01 2.38656465053288958239052774956690e-03
 	 8.58522340614574552830617903964594e-01 1.07924219839552332222964992070047e-01 3.35534395458731288242049117798160e-02 2.38656465053288958239052774956690e-03
 	 8.58522340614574552830617903964594e-01 3.35534395458731288242049117798160e-02 1.07924219839552332222964992070047e-01 2.38656465053288958239052774956690e-03
 	 1.52886902141386588072080598976754e-01 9.95790446035427906368298067718570e-02 7.47534053255070607413301786436932e-01 4.17537899316884099365498883571490e-03
 	 1.52886902141386588072080598976754e-01 7.47534053255070607413301786436932e-01 9.95790446035427906368298067718570e-02 4.17537899316884099365498883571490e-03
 	 9.95790446035427906368298067718570e-02 1.52886902141386588072080598976754e-01 7.47534053255070607413301786436932e-01 4.17537899316884099365498883571490e-03
 	 9.95790446035427906368298067718570e-02 7.47534053255070607413301786436932e-01 1.52886902141386588072080598976754e-01 4.17537899316884099365498883571490e-03
 	 7.47534053255070607413301786436932e-01 1.52886902141386588072080598976754e-01 9.95790446035427906368298067718570e-02 4.17537899316884099365498883571490e-03
 	 7.47534053255070607413301786436932e-01 9.95790446035427906368298067718570e-02 1.52886902141386588072080598976754e-01 4.17537899316884099365498883571490e-03
 	 1.88101771929606642608234778890619e-01 6.46491520250393747470951666400651e-02 7.47249076045353954889094438840402e-01 3.87112148854263553657273355668167e-03
 	 1.88101771929606642608234778890619e-01 7.47249076045353954889094438840402e-01 6.46491520250393747470951666400651e-02 3.87112148854263553657273355668167e-03
 	 6.46491520250393747470951666400651e-02 1.88101771929606642608234778890619e-01 7.47249076045353954889094438840402e-01 3.87112148854263553657273355668167e-03
 	 6.46491520250393747470951666400651e-02 7.47249076045353954889094438840402e-01 1.88101771929606642608234778890619e-01 3.87112148854263553657273355668167e-03
 	 7.47249076045353954889094438840402e-01 1.88101771929606642608234778890619e-01 6.46491520250393747470951666400651e-02 3.87112148854263553657273355668167e-03
 	 7.47249076045353954889094438840402e-01 6.46491520250393747470951666400651e-02 1.88101771929606642608234778890619e-01 3.87112148854263553657273355668167e-03
 	 2.54982429150887923707813342844020e-01 1.48987268708079909768082771392983e-02 7.30118843978304066233420144271804e-01 2.19233919604389440594083282576321e-03
 	 2.54982429150887923707813342844020e-01 7.30118843978304066233420144271804e-01 1.48987268708079909768082771392983e-02 2.19233919604389440594083282576321e-03
 	 1.48987268708079909768082771392983e-02 2.54982429150887923707813342844020e-01 7.30118843978304066233420144271804e-01 2.19233919604389440594083282576321e-03
 	 1.48987268708079909768082771392983e-02 7.30118843978304066233420144271804e-01 2.54982429150887923707813342844020e-01 2.19233919604389440594083282576321e-03
 	 7.30118843978304066233420144271804e-01 2.54982429150887923707813342844020e-01 1.48987268708079909768082771392983e-02 2.19233919604389440594083282576321e-03
 	 7.30118843978304066233420144271804e-01 1.48987268708079909768082771392983e-02 2.54982429150887923707813342844020e-01 2.19233919604389440594083282576321e-03
 	 2.23078080481277696289765799519955e-01 2.85444727801385713522597242786105e-03 7.74067472240708376318707450991496e-01 9.12732336521520476978197589090769e-04
 	 2.23078080481277696289765799519955e-01 7.74067472240708376318707450991496e-01 2.85444727801385713522597242786105e-03 9.12732336521520476978197589090769e-04
 	 2.85444727801385713522597242786105e-03 2.23078080481277696289765799519955e-01 7.74067472240708376318707450991496e-01 9.12732336521520476978197589090769e-04
 	 2.85444727801385713522597242786105e-03 7.74067472240708376318707450991496e-01 2.23078080481277696289765799519955e-01 9.12732336521520476978197589090769e-04
 	 7.74067472240708376318707450991496e-01 2.23078080481277696289765799519955e-01 2.85444727801385713522597242786105e-03 9.12732336521520476978197589090769e-04
 	 7.74067472240708376318707450991496e-01 2.85444727801385713522597242786105e-03 2.23078080481277696289765799519955e-01 9.12732336521520476978197589090769e-04
 	 1.64050736021032539380115622407175e-01 2.83077182118177030772931956903449e-03 8.33118492157785661689217704406474e-01 8.02834652615350423572604388056106e-04
 	 1.64050736021032539380115622407175e-01 8.33118492157785661689217704406474e-01 2.83077182118177030772931956903449e-03 8.02834652615350423572604388056106e-04
 	 2.83077182118177030772931956903449e-03 1.64050736021032539380115622407175e-01 8.33118492157785661689217704406474e-01 8.02834652615350423572604388056106e-04
 	 2.83077182118177030772931956903449e-03 8.33118492157785661689217704406474e-01 1.64050736021032539380115622407175e-01 8.02834652615350423572604388056106e-04
 	 8.33118492157785661689217704406474e-01 1.64050736021032539380115622407175e-01 2.83077182118177030772931956903449e-03 8.02834652615350423572604388056106e-04
 	 8.33118492157785661689217704406474e-01 2.83077182118177030772931956903449e-03 1.64050736021032539380115622407175e-01 8.02834652615350423572604388056106e-04
 	 2.88151117418988578222638352599461e-01 2.83594679658896297452796986249268e-03 7.09012935784422482221600603224942e-01 9.79359601578623679973834015299872e-04
 	 2.88151117418988578222638352599461e-01 7.09012935784422482221600603224942e-01 2.83594679658896297452796986249268e-03 9.79359601578623679973834015299872e-04
 	 2.83594679658896297452796986249268e-03 2.88151117418988578222638352599461e-01 7.09012935784422482221600603224942e-01 9.79359601578623679973834015299872e-04
 	 2.83594679658896297452796986249268e-03 7.09012935784422482221600603224942e-01 2.88151117418988578222638352599461e-01 9.79359601578623679973834015299872e-04
 	 7.09012935784422482221600603224942e-01 2.88151117418988578222638352599461e-01 2.83594679658896297452796986249268e-03 9.79359601578623679973834015299872e-04
 	 7.09012935784422482221600603224942e-01 2.83594679658896297452796986249268e-03 2.88151117418988578222638352599461e-01 9.79359601578623679973834015299872e-04
 	 3.40957788874061529238446155432030e-01 1.05632686278177900796038102271268e-01 5.53409524847760514454364511038875e-01 5.95508676088807396148405715052832e-03
 	 3.40957788874061529238446155432030e-01 5.53409524847760514454364511038875e-01 1.05632686278177900796038102271268e-01 5.95508676088807396148405715052832e-03
 	 1.05632686278177900796038102271268e-01 3.40957788874061529238446155432030e-01 5.53409524847760514454364511038875e-01 5.95508676088807396148405715052832e-03
 	 1.05632686278177900796038102271268e-01 5.53409524847760514454364511038875e-01 3.40957788874061529238446155432030e-01 5.95508676088807396148405715052832e-03
 	 5.53409524847760514454364511038875e-01 3.40957788874061529238446155432030e-01 1.05632686278177900796038102271268e-01 5.95508676088807396148405715052832e-03
 	 5.53409524847760514454364511038875e-01 1.05632686278177900796038102271268e-01 3.40957788874061529238446155432030e-01 5.95508676088807396148405715052832e-03
 	 2.68293448069283901880055509536760e-01 2.05408895782746736546897636799258e-01 5.26297656147969306061895622406155e-01 6.75251533871753639032275984277476e-03
 	 2.68293448069283901880055509536760e-01 5.26297656147969306061895622406155e-01 2.05408895782746736546897636799258e-01 6.75251533871753639032275984277476e-03
 	 2.05408895782746736546897636799258e-01 2.68293448069283901880055509536760e-01 5.26297656147969306061895622406155e-01 6.75251533871753639032275984277476e-03
 	 2.05408895782746736546897636799258e-01 5.26297656147969306061895622406155e-01 2.68293448069283901880055509536760e-01 6.75251533871753639032275984277476e-03
 	 5.26297656147969306061895622406155e-01 2.68293448069283901880055509536760e-01 2.05408895782746736546897636799258e-01 6.75251533871753639032275984277476e-03
 	 5.26297656147969306061895622406155e-01 2.05408895782746736546897636799258e-01 2.68293448069283901880055509536760e-01 6.75251533871753639032275984277476e-03
 	 3.19409003528324686449479941074969e-01 6.74786310679263284795226240930788e-02 6.13112365403749026704360858275322e-01 4.93267460824589002582607477620513e-03
 	 3.19409003528324686449479941074969e-01 6.13112365403749026704360858275322e-01 6.74786310679263284795226240930788e-02 4.93267460824589002582607477620513e-03
 	 6.74786310679263284795226240930788e-02 3.19409003528324686449479941074969e-01 6.13112365403749026704360858275322e-01 4.93267460824589002582607477620513e-03
 	 6.74786310679263284795226240930788e-02 6.13112365403749026704360858275322e-01 3.19409003528324686449479941074969e-01 4.93267460824589002582607477620513e-03
 	 6.13112365403749026704360858275322e-01 3.19409003528324686449479941074969e-01 6.74786310679263284795226240930788e-02 4.93267460824589002582607477620513e-03
 	 6.13112365403749026704360858275322e-01 6.74786310679263284795226240930788e-02 3.19409003528324686449479941074969e-01 4.93267460824589002582607477620513e-03
 	 1.92295465185952280107173351098027e-01 1.49331073629515708595105749623144e-02 7.92771427451096077909653558890568e-01 1.99951712364401183036344278320939e-03
 	 1.92295465185952280107173351098027e-01 7.92771427451096077909653558890568e-01 1.49331073629515708595105749623144e-02 1.99951712364401183036344278320939e-03
 	 1.49331073629515708595105749623144e-02 1.92295465185952280107173351098027e-01 7.92771427451096077909653558890568e-01 1.99951712364401183036344278320939e-03
 	 1.49331073629515708595105749623144e-02 7.92771427451096077909653558890568e-01 1.92295465185952280107173351098027e-01 1.99951712364401183036344278320939e-03
 	 7.92771427451096077909653558890568e-01 1.92295465185952280107173351098027e-01 1.49331073629515708595105749623144e-02 1.99951712364401183036344278320939e-03
 	 7.92771427451096077909653558890568e-01 1.49331073629515708595105749623144e-02 1.92295465185952280107173351098027e-01 1.99951712364401183036344278320939e-03
 	 1.60414053402923612035024802935368e-01 3.53852934054426707111140615324985e-02 8.04200653191633696437179423810448e-01 2.85816989282751138939930868332340e-03
 	 1.60414053402923612035024802935368e-01 8.04200653191633696437179423810448e-01 3.53852934054426707111140615324985e-02 2.85816989282751138939930868332340e-03
 	 3.53852934054426707111140615324985e-02 1.60414053402923612035024802935368e-01 8.04200653191633696437179423810448e-01 2.85816989282751138939930868332340e-03
 	 3.53852934054426707111140615324985e-02 8.04200653191633696437179423810448e-01 1.60414053402923612035024802935368e-01 2.85816989282751138939930868332340e-03
 	 8.04200653191633696437179423810448e-01 1.60414053402923612035024802935368e-01 3.53852934054426707111140615324985e-02 2.85816989282751138939930868332340e-03
 	 8.04200653191633696437179423810448e-01 3.53852934054426707111140615324985e-02 1.60414053402923612035024802935368e-01 2.85816989282751138939930868332340e-03
 	 2.21253498980421736685997302629403e-01 3.62519958338577280576586758797930e-02 7.42494505185720465867404982418520e-01 3.25738294944941933137250167362708e-03
 	 2.21253498980421736685997302629403e-01 7.42494505185720465867404982418520e-01 3.62519958338577280576586758797930e-02 3.25738294944941933137250167362708e-03
 	 3.62519958338577280576586758797930e-02 2.21253498980421736685997302629403e-01 7.42494505185720465867404982418520e-01 3.25738294944941933137250167362708e-03
 	 3.62519958338577280576586758797930e-02 7.42494505185720465867404982418520e-01 2.21253498980421736685997302629403e-01 3.25738294944941933137250167362708e-03
 	 7.42494505185720465867404982418520e-01 2.21253498980421736685997302629403e-01 3.62519958338577280576586758797930e-02 3.25738294944941933137250167362708e-03
 	 7.42494505185720465867404982418520e-01 3.62519958338577280576586758797930e-02 2.21253498980421736685997302629403e-01 3.25738294944941933137250167362708e-03
 	 2.71194224068813549699541454174323e-01 1.06599696973037380565152432154719e-01 6.22206078958149055857518305856502e-01 5.87228165837252406161761442149327e-03
 	 2.71194224068813549699541454174323e-01 6.22206078958149055857518305856502e-01 1.06599696973037380565152432154719e-01 5.87228165837252406161761442149327e-03
 	 1.06599696973037380565152432154719e-01 2.71194224068813549699541454174323e-01 6.22206078958149055857518305856502e-01 5.87228165837252406161761442149327e-03
 	 1.06599696973037380565152432154719e-01 6.22206078958149055857518305856502e-01 2.71194224068813549699541454174323e-01 5.87228165837252406161761442149327e-03
 	 6.22206078958149055857518305856502e-01 2.71194224068813549699541454174323e-01 1.06599696973037380565152432154719e-01 5.87228165837252406161761442149327e-03
 	 6.22206078958149055857518305856502e-01 1.06599696973037380565152432154719e-01 2.71194224068813549699541454174323e-01 5.87228165837252406161761442149327e-03
 	 3.92323411299770385962659702272504e-01 6.65697076536746201735894601370092e-02 5.41106881046554910597023990703747e-01 5.09507844750052216187263809388241e-03
 	 3.92323411299770385962659702272504e-01 5.41106881046554910597023990703747e-01 6.65697076536746201735894601370092e-02 5.09507844750052216187263809388241e-03
 	 6.65697076536746201735894601370092e-02 3.92323411299770385962659702272504e-01 5.41106881046554910597023990703747e-01 5.09507844750052216187263809388241e-03
 	 6.65697076536746201735894601370092e-02 5.41106881046554910597023990703747e-01 3.92323411299770385962659702272504e-01 5.09507844750052216187263809388241e-03
 	 5.41106881046554910597023990703747e-01 3.92323411299770385962659702272504e-01 6.65697076536746201735894601370092e-02 5.09507844750052216187263809388241e-03
 	 5.41106881046554910597023990703747e-01 6.65697076536746201735894601370092e-02 3.92323411299770385962659702272504e-01 5.09507844750052216187263809388241e-03
 	 ];
 
 	 case  42 

 	 % ALG. DEG.:   42
 	 % PTS CARD.:  324
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw_bar=[
 	 4.02371925109793249220047073322348e-01 4.02371925109793249220047073322348e-01 1.95256149780413501559905853355303e-01 3.54644001597716803514392935881006e-03
 	 4.02371925109793249220047073322348e-01 1.95256149780413501559905853355303e-01 4.02371925109793249220047073322348e-01 3.54644001597716803514392935881006e-03
 	 1.95256149780413501559905853355303e-01 4.02371925109793249220047073322348e-01 4.02371925109793249220047073322348e-01 3.54644001597716803514392935881006e-03
 	 1.36539257595404031446484349743287e-03 1.36539257595404031446484349743287e-03 9.97269214848091944958241583663039e-01 3.47195354365621033530461825300506e-05
 	 1.36539257595404031446484349743287e-03 9.97269214848091944958241583663039e-01 1.36539257595404031446484349743287e-03 3.47195354365621033530461825300506e-05
 	 9.97269214848091944958241583663039e-01 1.36539257595404031446484349743287e-03 1.36539257595404031446484349743287e-03 3.47195354365621033530461825300506e-05
 	 4.97531729625205365596940509931301e-01 4.97531729625205365596940509931301e-01 4.93654074958926880611898013739847e-03 1.01416964283273613837976778739858e-03
 	 4.97531729625205365596940509931301e-01 4.93654074958926880611898013739847e-03 4.97531729625205365596940509931301e-01 1.01416964283273613837976778739858e-03
 	 4.93654074958926880611898013739847e-03 4.97531729625205365596940509931301e-01 4.97531729625205365596940509931301e-01 1.01416964283273613837976778739858e-03
 	 4.79900295754419115024091979648801e-01 4.79900295754419115024091979648801e-01 4.01994084911617699518160407023970e-02 2.84418595701223979668736951964547e-03
 	 4.79900295754419115024091979648801e-01 4.01994084911617699518160407023970e-02 4.79900295754419115024091979648801e-01 2.84418595701223979668736951964547e-03
 	 4.01994084911617699518160407023970e-02 4.79900295754419115024091979648801e-01 4.79900295754419115024091979648801e-01 2.84418595701223979668736951964547e-03
 	 6.64663290557835906291472838347545e-02 6.64663290557835906291472838347545e-02 8.67067341888432818741705432330491e-01 1.87098153802288001343323564640286e-03
 	 6.64663290557835906291472838347545e-02 8.67067341888432818741705432330491e-01 6.64663290557835906291472838347545e-02 1.87098153802288001343323564640286e-03
 	 8.67067341888432818741705432330491e-01 6.64663290557835906291472838347545e-02 6.64663290557835906291472838347545e-02 1.87098153802288001343323564640286e-03
 	 4.32363893877459951053943143506331e-02 4.32363893877459951053943143506331e-02 9.13527221224508023666999179113191e-01 1.33262500040798076601789023953870e-03
 	 4.32363893877459951053943143506331e-02 9.13527221224508023666999179113191e-01 4.32363893877459951053943143506331e-02 1.33262500040798076601789023953870e-03
 	 9.13527221224508023666999179113191e-01 4.32363893877459951053943143506331e-02 4.32363893877459951053943143506331e-02 1.33262500040798076601789023953870e-03
 	 4.90305014201646682803215071544400e-01 4.90305014201646682803215071544400e-01 1.93899715967066343935698569111992e-02 2.19268168158588466418179585559756e-03
 	 4.90305014201646682803215071544400e-01 1.93899715967066343935698569111992e-02 4.90305014201646682803215071544400e-01 2.19268168158588466418179585559756e-03
 	 1.93899715967066343935698569111992e-02 4.90305014201646682803215071544400e-01 4.90305014201646682803215071544400e-01 2.19268168158588466418179585559756e-03
 	 2.69988226283729981780368234467460e-02 2.69988226283729981780368234467460e-02 9.46002354743254003643926353106508e-01 9.52405955654681501097724716231596e-04
 	 2.69988226283729981780368234467460e-02 9.46002354743254003643926353106508e-01 2.69988226283729981780368234467460e-02 9.52405955654681501097724716231596e-04
 	 9.46002354743254003643926353106508e-01 2.69988226283729981780368234467460e-02 2.69988226283729981780368234467460e-02 9.52405955654681501097724716231596e-04
 	 1.38504806910322769697430089763657e-01 1.38504806910322769697430089763657e-01 7.22990386179354516116291051730514e-01 4.35985004189246797695611590484077e-03
 	 1.38504806910322769697430089763657e-01 7.22990386179354516116291051730514e-01 1.38504806910322769697430089763657e-01 4.35985004189246797695611590484077e-03
 	 7.22990386179354516116291051730514e-01 1.38504806910322769697430089763657e-01 1.38504806910322769697430089763657e-01 4.35985004189246797695611590484077e-03
 	 4.67013207355763959593986101026530e-01 4.67013207355763959593986101026530e-01 6.59735852884720808120277979469392e-02 4.53253225503275156832438952392295e-03
 	 4.67013207355763959593986101026530e-01 6.59735852884720808120277979469392e-02 4.67013207355763959593986101026530e-01 4.53253225503275156832438952392295e-03
 	 6.59735852884720808120277979469392e-02 4.67013207355763959593986101026530e-01 4.67013207355763959593986101026530e-01 4.53253225503275156832438952392295e-03
 	 1.06580425858858796051009676375543e-01 1.06580425858858796051009676375543e-01 7.86839148282282407897980647248914e-01 3.69607066155387773559448660876114e-03
 	 1.06580425858858796051009676375543e-01 7.86839148282282407897980647248914e-01 1.06580425858858796051009676375543e-01 3.69607066155387773559448660876114e-03
 	 7.86839148282282407897980647248914e-01 1.06580425858858796051009676375543e-01 1.06580425858858796051009676375543e-01 3.69607066155387773559448660876114e-03
 	 3.11735391072587297855989163508639e-01 3.11735391072587297855989163508639e-01 3.76529217854825404288021672982723e-01 8.09733760902839154460775006327822e-03
 	 3.11735391072587297855989163508639e-01 3.76529217854825404288021672982723e-01 3.11735391072587297855989163508639e-01 8.09733760902839154460775006327822e-03
 	 3.76529217854825404288021672982723e-01 3.11735391072587297855989163508639e-01 3.11735391072587297855989163508639e-01 8.09733760902839154460775006327822e-03
 	 2.44860575868881713557101420519757e-01 2.44860575868881713557101420519757e-01 5.10278848262236572885797158960486e-01 7.29060105278677393625397229470764e-03
 	 2.44860575868881713557101420519757e-01 5.10278848262236572885797158960486e-01 2.44860575868881713557101420519757e-01 7.29060105278677393625397229470764e-03
 	 5.10278848262236572885797158960486e-01 2.44860575868881713557101420519757e-01 2.44860575868881713557101420519757e-01 7.29060105278677393625397229470764e-03
 	 1.74835145811190639797416679357411e-01 1.74835145811190639797416679357411e-01 6.50329708377618720405166641285177e-01 6.05552678202537272150740577103534e-03
 	 1.74835145811190639797416679357411e-01 6.50329708377618720405166641285177e-01 1.74835145811190639797416679357411e-01 6.05552678202537272150740577103534e-03
 	 6.50329708377618720405166641285177e-01 1.74835145811190639797416679357411e-01 1.74835145811190639797416679357411e-01 6.05552678202537272150740577103534e-03
 	 4.27569334150190383248002490290673e-01 4.27569334150190383248002490290673e-01 1.44861331699619233503995019418653e-01 6.75894463922976918013318936573341e-03
 	 4.27569334150190383248002490290673e-01 1.44861331699619233503995019418653e-01 4.27569334150190383248002490290673e-01 6.75894463922976918013318936573341e-03
 	 1.44861331699619233503995019418653e-01 4.27569334150190383248002490290673e-01 4.27569334150190383248002490290673e-01 6.75894463922976918013318936573341e-03
 	 3.74270156678447651898977710516192e-01 3.74270156678447651898977710516192e-01 2.51459686643104696202044578967616e-01 7.92204457659131423830078944092747e-03
 	 3.74270156678447651898977710516192e-01 2.51459686643104696202044578967616e-01 3.74270156678447651898977710516192e-01 7.92204457659131423830078944092747e-03
 	 2.51459686643104696202044578967616e-01 3.74270156678447651898977710516192e-01 3.74270156678447651898977710516192e-01 7.92204457659131423830078944092747e-03
 	 3.30553853684353138309148789630854e-01 1.57042560146290624892295717529578e-03 6.67875720714183995774249069654616e-01 5.32731694340532490640482965460478e-04
 	 3.30553853684353138309148789630854e-01 6.67875720714183995774249069654616e-01 1.57042560146290624892295717529578e-03 5.32731694340532490640482965460478e-04
 	 1.57042560146290624892295717529578e-03 3.30553853684353138309148789630854e-01 6.67875720714183995774249069654616e-01 5.32731694340532490640482965460478e-04
 	 1.57042560146290624892295717529578e-03 6.67875720714183995774249069654616e-01 3.30553853684353138309148789630854e-01 5.32731694340532490640482965460478e-04
 	 6.67875720714183995774249069654616e-01 3.30553853684353138309148789630854e-01 1.57042560146290624892295717529578e-03 5.32731694340532490640482965460478e-04
 	 6.67875720714183995774249069654616e-01 1.57042560146290624892295717529578e-03 3.30553853684353138309148789630854e-01 5.32731694340532490640482965460478e-04
 	 9.69953965146683194653576265409356e-01 9.61466912071009052742631695309683e-03 2.04313657326067148189974176375472e-02 4.39077027169824073149495546886101e-04
 	 9.69953965146683194653576265409356e-01 2.04313657326067148189974176375472e-02 9.61466912071009052742631695309683e-03 4.39077027169824073149495546886101e-04
 	 9.61466912071009052742631695309683e-03 9.69953965146683194653576265409356e-01 2.04313657326067148189974176375472e-02 4.39077027169824073149495546886101e-04
 	 9.61466912071009052742631695309683e-03 2.04313657326067148189974176375472e-02 9.69953965146683194653576265409356e-01 4.39077027169824073149495546886101e-04
 	 2.04313657326067148189974176375472e-02 9.69953965146683194653576265409356e-01 9.61466912071009052742631695309683e-03 4.39077027169824073149495546886101e-04
 	 2.04313657326067148189974176375472e-02 9.61466912071009052742631695309683e-03 9.69953965146683194653576265409356e-01 4.39077027169824073149495546886101e-04
 	 5.71983061939756801117518136834406e-02 2.19035586156293565762709363298200e-02 9.20898135190394984128658961708425e-01 1.03702504653542678346445082837590e-03
 	 5.71983061939756801117518136834406e-02 9.20898135190394984128658961708425e-01 2.19035586156293565762709363298200e-02 1.03702504653542678346445082837590e-03
 	 2.19035586156293565762709363298200e-02 5.71983061939756801117518136834406e-02 9.20898135190394984128658961708425e-01 1.03702504653542678346445082837590e-03
 	 2.19035586156293565762709363298200e-02 9.20898135190394984128658961708425e-01 5.71983061939756801117518136834406e-02 1.03702504653542678346445082837590e-03
 	 9.20898135190394984128658961708425e-01 5.71983061939756801117518136834406e-02 2.19035586156293565762709363298200e-02 1.03702504653542678346445082837590e-03
 	 9.20898135190394984128658961708425e-01 2.19035586156293565762709363298200e-02 5.71983061939756801117518136834406e-02 1.03702504653542678346445082837590e-03
 	 4.53270971637945607746189580211649e-01 1.49355129029098685801424384322900e-03 5.45235477071763452450170461816015e-01 5.59551950228043964985502611853008e-04
 	 4.53270971637945607746189580211649e-01 5.45235477071763452450170461816015e-01 1.49355129029098685801424384322900e-03 5.59551950228043964985502611853008e-04
 	 1.49355129029098685801424384322900e-03 4.53270971637945607746189580211649e-01 5.45235477071763452450170461816015e-01 5.59551950228043964985502611853008e-04
 	 1.49355129029098685801424384322900e-03 5.45235477071763452450170461816015e-01 4.53270971637945607746189580211649e-01 5.59551950228043964985502611853008e-04
 	 5.45235477071763452450170461816015e-01 4.53270971637945607746189580211649e-01 1.49355129029098685801424384322900e-03 5.59551950228043964985502611853008e-04
 	 5.45235477071763452450170461816015e-01 1.49355129029098685801424384322900e-03 4.53270971637945607746189580211649e-01 5.59551950228043964985502611853008e-04
 	 1.40732473906720334522191251380718e-01 5.54414996743645416277246340541751e-02 8.03826026418915096094508498936193e-01 2.53792050646477239730924857497030e-03
 	 1.40732473906720334522191251380718e-01 8.03826026418915096094508498936193e-01 5.54414996743645416277246340541751e-02 2.53792050646477239730924857497030e-03
 	 5.54414996743645416277246340541751e-02 1.40732473906720334522191251380718e-01 8.03826026418915096094508498936193e-01 2.53792050646477239730924857497030e-03
 	 5.54414996743645416277246340541751e-02 8.03826026418915096094508498936193e-01 1.40732473906720334522191251380718e-01 2.53792050646477239730924857497030e-03
 	 8.03826026418915096094508498936193e-01 1.40732473906720334522191251380718e-01 5.54414996743645416277246340541751e-02 2.53792050646477239730924857497030e-03
 	 8.03826026418915096094508498936193e-01 5.54414996743645416277246340541751e-02 1.40732473906720334522191251380718e-01 2.53792050646477239730924857497030e-03
 	 1.83788630301941036115920269367052e-01 1.18693569421395000995644863905909e-01 6.97517800276663990644010482355952e-01 4.05815779811395833942544442152212e-03
 	 1.83788630301941036115920269367052e-01 6.97517800276663990644010482355952e-01 1.18693569421395000995644863905909e-01 4.05815779811395833942544442152212e-03
 	 1.18693569421395000995644863905909e-01 1.83788630301941036115920269367052e-01 6.97517800276663990644010482355952e-01 4.05815779811395833942544442152212e-03
 	 1.18693569421395000995644863905909e-01 6.97517800276663990644010482355952e-01 1.83788630301941036115920269367052e-01 4.05815779811395833942544442152212e-03
 	 6.97517800276663990644010482355952e-01 1.83788630301941036115920269367052e-01 1.18693569421395000995644863905909e-01 4.05815779811395833942544442152212e-03
 	 6.97517800276663990644010482355952e-01 1.18693569421395000995644863905909e-01 1.83788630301941036115920269367052e-01 4.05815779811395833942544442152212e-03
 	 3.21121524868778346339937002085207e-02 1.39305721718615584114875360910446e-03 9.66494790295935990442899310437497e-01 2.26642575207491354808211903026915e-04
 	 3.21121524868778346339937002085207e-02 9.66494790295935990442899310437497e-01 1.39305721718615584114875360910446e-03 2.26642575207491354808211903026915e-04
 	 1.39305721718615584114875360910446e-03 3.21121524868778346339937002085207e-02 9.66494790295935990442899310437497e-01 2.26642575207491354808211903026915e-04
 	 1.39305721718615584114875360910446e-03 9.66494790295935990442899310437497e-01 3.21121524868778346339937002085207e-02 2.26642575207491354808211903026915e-04
 	 9.66494790295935990442899310437497e-01 3.21121524868778346339937002085207e-02 1.39305721718615584114875360910446e-03 2.26642575207491354808211903026915e-04
 	 9.66494790295935990442899310437497e-01 1.39305721718615584114875360910446e-03 3.21121524868778346339937002085207e-02 2.26642575207491354808211903026915e-04
 	 4.29640722006761482942849283972464e-02 1.02994751818414106286914133647770e-02 9.46736452617482515670133125240682e-01 6.81853343141496613666330262049087e-04
 	 4.29640722006761482942849283972464e-02 9.46736452617482515670133125240682e-01 1.02994751818414106286914133647770e-02 6.81853343141496613666330262049087e-04
 	 1.02994751818414106286914133647770e-02 4.29640722006761482942849283972464e-02 9.46736452617482515670133125240682e-01 6.81853343141496613666330262049087e-04
 	 1.02994751818414106286914133647770e-02 9.46736452617482515670133125240682e-01 4.29640722006761482942849283972464e-02 6.81853343141496613666330262049087e-04
 	 9.46736452617482515670133125240682e-01 4.29640722006761482942849283972464e-02 1.02994751818414106286914133647770e-02 6.81853343141496613666330262049087e-04
 	 9.46736452617482515670133125240682e-01 1.02994751818414106286914133647770e-02 4.29640722006761482942849283972464e-02 6.81853343141496613666330262049087e-04
 	 1.05248427300748837592836437693222e-02 2.58470999228818361717618934392249e-03 9.86890447277636861933558520831866e-01 1.87093068615602395841912564122822e-04
 	 1.05248427300748837592836437693222e-02 9.86890447277636861933558520831866e-01 2.58470999228818361717618934392249e-03 1.87093068615602395841912564122822e-04
 	 2.58470999228818361717618934392249e-03 1.05248427300748837592836437693222e-02 9.86890447277636861933558520831866e-01 1.87093068615602395841912564122822e-04
 	 2.58470999228818361717618934392249e-03 9.86890447277636861933558520831866e-01 1.05248427300748837592836437693222e-02 1.87093068615602395841912564122822e-04
 	 9.86890447277636861933558520831866e-01 1.05248427300748837592836437693222e-02 2.58470999228818361717618934392249e-03 1.87093068615602395841912564122822e-04
 	 9.86890447277636861933558520831866e-01 2.58470999228818361717618934392249e-03 1.05248427300748837592836437693222e-02 1.87093068615602395841912564122822e-04
 	 7.53790285629702960790154975256883e-02 3.94743127161576515260499320447707e-02 8.85146658720872059333828474336769e-01 1.68662966982373232344150082440137e-03
 	 7.53790285629702960790154975256883e-02 8.85146658720872059333828474336769e-01 3.94743127161576515260499320447707e-02 1.68662966982373232344150082440137e-03
 	 3.94743127161576515260499320447707e-02 7.53790285629702960790154975256883e-02 8.85146658720872059333828474336769e-01 1.68662966982373232344150082440137e-03
 	 3.94743127161576515260499320447707e-02 8.85146658720872059333828474336769e-01 7.53790285629702960790154975256883e-02 1.68662966982373232344150082440137e-03
 	 8.85146658720872059333828474336769e-01 7.53790285629702960790154975256883e-02 3.94743127161576515260499320447707e-02 1.68662966982373232344150082440137e-03
 	 8.85146658720872059333828474336769e-01 3.94743127161576515260499320447707e-02 7.53790285629702960790154975256883e-02 1.68662966982373232344150082440137e-03
 	 4.36333362089955989482348286401248e-01 1.22938385245525295258461895286928e-02 5.51372799385491441093165576603496e-01 1.90254979645790018964734979789455e-03
 	 4.36333362089955989482348286401248e-01 5.51372799385491441093165576603496e-01 1.22938385245525295258461895286928e-02 1.90254979645790018964734979789455e-03
 	 1.22938385245525295258461895286928e-02 4.36333362089955989482348286401248e-01 5.51372799385491441093165576603496e-01 1.90254979645790018964734979789455e-03
 	 1.22938385245525295258461895286928e-02 5.51372799385491441093165576603496e-01 4.36333362089955989482348286401248e-01 1.90254979645790018964734979789455e-03
 	 5.51372799385491441093165576603496e-01 4.36333362089955989482348286401248e-01 1.22938385245525295258461895286928e-02 1.90254979645790018964734979789455e-03
 	 5.51372799385491441093165576603496e-01 1.22938385245525295258461895286928e-02 4.36333362089955989482348286401248e-01 1.90254979645790018964734979789455e-03
 	 2.70490746514976954095743622019654e-01 2.58980924784568732402445512263967e-03 7.26919444237177359013912791851908e-01 7.73367025299780781397163131885009e-04
 	 2.70490746514976954095743622019654e-01 7.26919444237177359013912791851908e-01 2.58980924784568732402445512263967e-03 7.73367025299780781397163131885009e-04
 	 2.58980924784568732402445512263967e-03 2.70490746514976954095743622019654e-01 7.26919444237177359013912791851908e-01 7.73367025299780781397163131885009e-04
 	 2.58980924784568732402445512263967e-03 7.26919444237177359013912791851908e-01 2.70490746514976954095743622019654e-01 7.73367025299780781397163131885009e-04
 	 7.26919444237177359013912791851908e-01 2.70490746514976954095743622019654e-01 2.58980924784568732402445512263967e-03 7.73367025299780781397163131885009e-04
 	 7.26919444237177359013912791851908e-01 2.58980924784568732402445512263967e-03 2.70490746514976954095743622019654e-01 7.73367025299780781397163131885009e-04
 	 3.50813643381097384210676182192401e-01 3.75563888722968697297943663215847e-02 6.11629967746605829326256298372755e-01 3.17238789090024033562320582291250e-03
 	 3.50813643381097384210676182192401e-01 6.11629967746605829326256298372755e-01 3.75563888722968697297943663215847e-02 3.17238789090024033562320582291250e-03
 	 3.75563888722968697297943663215847e-02 3.50813643381097384210676182192401e-01 6.11629967746605829326256298372755e-01 3.17238789090024033562320582291250e-03
 	 3.75563888722968697297943663215847e-02 6.11629967746605829326256298372755e-01 3.50813643381097384210676182192401e-01 3.17238789090024033562320582291250e-03
 	 6.11629967746605829326256298372755e-01 3.50813643381097384210676182192401e-01 3.75563888722968697297943663215847e-02 3.17238789090024033562320582291250e-03
 	 6.11629967746605829326256298372755e-01 3.75563888722968697297943663215847e-02 3.50813643381097384210676182192401e-01 3.17238789090024033562320582291250e-03
 	 3.72765511974292140795483874171623e-01 1.70945467207073396875838255937197e-02 6.10139941305000599314212195167784e-01 2.16852470986174253667067013395808e-03
 	 3.72765511974292140795483874171623e-01 6.10139941305000599314212195167784e-01 1.70945467207073396875838255937197e-02 2.16852470986174253667067013395808e-03
 	 1.70945467207073396875838255937197e-02 3.72765511974292140795483874171623e-01 6.10139941305000599314212195167784e-01 2.16852470986174253667067013395808e-03
 	 1.70945467207073396875838255937197e-02 6.10139941305000599314212195167784e-01 3.72765511974292140795483874171623e-01 2.16852470986174253667067013395808e-03
 	 6.10139941305000599314212195167784e-01 3.72765511974292140795483874171623e-01 1.70945467207073396875838255937197e-02 2.16852470986174253667067013395808e-03
 	 6.10139941305000599314212195167784e-01 1.70945467207073396875838255937197e-02 3.72765511974292140795483874171623e-01 2.16852470986174253667067013395808e-03
 	 2.17107352263341546461106190690771e-01 8.57583162943158783253494448217680e-02 6.97134331442342602969119980116375e-01 4.07411747364071468585633439829508e-03
 	 2.17107352263341546461106190690771e-01 6.97134331442342602969119980116375e-01 8.57583162943158783253494448217680e-02 4.07411747364071468585633439829508e-03
 	 8.57583162943158783253494448217680e-02 2.17107352263341546461106190690771e-01 6.97134331442342602969119980116375e-01 4.07411747364071468585633439829508e-03
 	 8.57583162943158783253494448217680e-02 6.97134331442342602969119980116375e-01 2.17107352263341546461106190690771e-01 4.07411747364071468585633439829508e-03
 	 6.97134331442342602969119980116375e-01 2.17107352263341546461106190690771e-01 8.57583162943158783253494448217680e-02 4.07411747364071468585633439829508e-03
 	 6.97134331442342602969119980116375e-01 8.57583162943158783253494448217680e-02 2.17107352263341546461106190690771e-01 4.07411747364071468585633439829508e-03
 	 1.92756365009005836697042468586005e-01 5.79856449641143953388500165146979e-02 7.49257990026879761025213610992068e-01 3.37208901439615136089167357624774e-03
 	 1.92756365009005836697042468586005e-01 7.49257990026879761025213610992068e-01 5.79856449641143953388500165146979e-02 3.37208901439615136089167357624774e-03
 	 5.79856449641143953388500165146979e-02 1.92756365009005836697042468586005e-01 7.49257990026879761025213610992068e-01 3.37208901439615136089167357624774e-03
 	 5.79856449641143953388500165146979e-02 7.49257990026879761025213610992068e-01 1.92756365009005836697042468586005e-01 3.37208901439615136089167357624774e-03
 	 7.49257990026879761025213610992068e-01 1.92756365009005836697042468586005e-01 5.79856449641143953388500165146979e-02 3.37208901439615136089167357624774e-03
 	 7.49257990026879761025213610992068e-01 5.79856449641143953388500165146979e-02 1.92756365009005836697042468586005e-01 3.37208901439615136089167357624774e-03
 	 4.20685030686416272516225944855250e-01 3.38481728829903155686409377267410e-02 5.45466796430593370281769693974638e-01 3.33746541534930222377974828873448e-03
 	 4.20685030686416272516225944855250e-01 5.45466796430593370281769693974638e-01 3.38481728829903155686409377267410e-02 3.33746541534930222377974828873448e-03
 	 3.38481728829903155686409377267410e-02 4.20685030686416272516225944855250e-01 5.45466796430593370281769693974638e-01 3.33746541534930222377974828873448e-03
 	 3.38481728829903155686409377267410e-02 5.45466796430593370281769693974638e-01 4.20685030686416272516225944855250e-01 3.33746541534930222377974828873448e-03
 	 5.45466796430593370281769693974638e-01 4.20685030686416272516225944855250e-01 3.38481728829903155686409377267410e-02 3.33746541534930222377974828873448e-03
 	 5.45466796430593370281769693974638e-01 3.38481728829903155686409377267410e-02 4.20685030686416272516225944855250e-01 3.33746541534930222377974828873448e-03
 	 2.12485185437091050886238008388318e-01 2.52669138520864814539956810790500e-03 7.84988123177700281019042449770495e-01 7.44300460712227305443144942387335e-04
 	 2.12485185437091050886238008388318e-01 7.84988123177700281019042449770495e-01 2.52669138520864814539956810790500e-03 7.44300460712227305443144942387335e-04
 	 2.52669138520864814539956810790500e-03 2.12485185437091050886238008388318e-01 7.84988123177700281019042449770495e-01 7.44300460712227305443144942387335e-04
 	 2.52669138520864814539956810790500e-03 7.84988123177700281019042449770495e-01 2.12485185437091050886238008388318e-01 7.44300460712227305443144942387335e-04
 	 7.84988123177700281019042449770495e-01 2.12485185437091050886238008388318e-01 2.52669138520864814539956810790500e-03 7.44300460712227305443144942387335e-04
 	 7.84988123177700281019042449770495e-01 2.52669138520864814539956810790500e-03 2.12485185437091050886238008388318e-01 7.44300460712227305443144942387335e-04
 	 3.19257208729187336171406741414103e-01 1.06565421155276375542175770760878e-02 6.70086249155284918721520170947770e-01 1.74900565750928625730065135712721e-03
 	 3.19257208729187336171406741414103e-01 6.70086249155284918721520170947770e-01 1.06565421155276375542175770760878e-02 1.74900565750928625730065135712721e-03
 	 1.06565421155276375542175770760878e-02 3.19257208729187336171406741414103e-01 6.70086249155284918721520170947770e-01 1.74900565750928625730065135712721e-03
 	 1.06565421155276375542175770760878e-02 6.70086249155284918721520170947770e-01 3.19257208729187336171406741414103e-01 1.74900565750928625730065135712721e-03
 	 6.70086249155284918721520170947770e-01 3.19257208729187336171406741414103e-01 1.06565421155276375542175770760878e-02 1.74900565750928625730065135712721e-03
 	 6.70086249155284918721520170947770e-01 1.06565421155276375542175770760878e-02 3.19257208729187336171406741414103e-01 1.74900565750928625730065135712721e-03
 	 2.51638235512572583374435453151818e-01 1.34296732422585305549711520711753e-02 7.34932091245168894744210774661042e-01 1.90316839543802737884370390730737e-03
 	 2.51638235512572583374435453151818e-01 7.34932091245168894744210774661042e-01 1.34296732422585305549711520711753e-02 1.90316839543802737884370390730737e-03
 	 1.34296732422585305549711520711753e-02 2.51638235512572583374435453151818e-01 7.34932091245168894744210774661042e-01 1.90316839543802737884370390730737e-03
 	 1.34296732422585305549711520711753e-02 7.34932091245168894744210774661042e-01 2.51638235512572583374435453151818e-01 1.90316839543802737884370390730737e-03
 	 7.34932091245168894744210774661042e-01 2.51638235512572583374435453151818e-01 1.34296732422585305549711520711753e-02 1.90316839543802737884370390730737e-03
 	 7.34932091245168894744210774661042e-01 1.34296732422585305549711520711753e-02 2.51638235512572583374435453151818e-01 1.90316839543802737884370390730737e-03
 	 1.52211981456809364310345245030476e-01 8.83417782932650746952063514072506e-02 7.59446240249925574872236211376730e-01 3.95814449075659359478240872931565e-03
 	 1.52211981456809364310345245030476e-01 7.59446240249925574872236211376730e-01 8.83417782932650746952063514072506e-02 3.95814449075659359478240872931565e-03
 	 8.83417782932650746952063514072506e-02 1.52211981456809364310345245030476e-01 7.59446240249925574872236211376730e-01 3.95814449075659359478240872931565e-03
 	 8.83417782932650746952063514072506e-02 7.59446240249925574872236211376730e-01 1.52211981456809364310345245030476e-01 3.95814449075659359478240872931565e-03
 	 7.59446240249925574872236211376730e-01 1.52211981456809364310345245030476e-01 8.83417782932650746952063514072506e-02 3.95814449075659359478240872931565e-03
 	 7.59446240249925574872236211376730e-01 8.83417782932650746952063514072506e-02 1.52211981456809364310345245030476e-01 3.95814449075659359478240872931565e-03
 	 1.11142094794033280402700825106876e-01 3.29221182111608043352468655484699e-02 8.55935786994805991589885252324166e-01 2.16333001191750928099422068839885e-03
 	 1.11142094794033280402700825106876e-01 8.55935786994805991589885252324166e-01 3.29221182111608043352468655484699e-02 2.16333001191750928099422068839885e-03
 	 3.29221182111608043352468655484699e-02 1.11142094794033280402700825106876e-01 8.55935786994805991589885252324166e-01 2.16333001191750928099422068839885e-03
 	 3.29221182111608043352468655484699e-02 8.55935786994805991589885252324166e-01 1.11142094794033280402700825106876e-01 2.16333001191750928099422068839885e-03
 	 8.55935786994805991589885252324166e-01 1.11142094794033280402700825106876e-01 3.29221182111608043352468655484699e-02 2.16333001191750928099422068839885e-03
 	 8.55935786994805991589885252324166e-01 3.29221182111608043352468655484699e-02 1.11142094794033280402700825106876e-01 2.16333001191750928099422068839885e-03
 	 3.58150058851250285840706055751070e-01 1.94800760777327719441842646119767e-01 4.47049180371421994717451298129163e-01 6.26674139654182296710338562206744e-03
 	 3.58150058851250285840706055751070e-01 4.47049180371421994717451298129163e-01 1.94800760777327719441842646119767e-01 6.26674139654182296710338562206744e-03
 	 1.94800760777327719441842646119767e-01 3.58150058851250285840706055751070e-01 4.47049180371421994717451298129163e-01 6.26674139654182296710338562206744e-03
 	 1.94800760777327719441842646119767e-01 4.47049180371421994717451298129163e-01 3.58150058851250285840706055751070e-01 6.26674139654182296710338562206744e-03
 	 4.47049180371421994717451298129163e-01 3.58150058851250285840706055751070e-01 1.94800760777327719441842646119767e-01 6.26674139654182296710338562206744e-03
 	 4.47049180371421994717451298129163e-01 1.94800760777327719441842646119767e-01 3.58150058851250285840706055751070e-01 6.26674139654182296710338562206744e-03
 	 1.63799856956150069464683838305064e-01 3.14610159618917972768059598820400e-02 8.04739127081958161014085817441810e-01 2.43147094475280921635484965293017e-03
 	 1.63799856956150069464683838305064e-01 8.04739127081958161014085817441810e-01 3.14610159618917972768059598820400e-02 2.43147094475280921635484965293017e-03
 	 3.14610159618917972768059598820400e-02 1.63799856956150069464683838305064e-01 8.04739127081958161014085817441810e-01 2.43147094475280921635484965293017e-03
 	 3.14610159618917972768059598820400e-02 8.04739127081958161014085817441810e-01 1.63799856956150069464683838305064e-01 2.43147094475280921635484965293017e-03
 	 8.04739127081958161014085817441810e-01 1.63799856956150069464683838305064e-01 3.14610159618917972768059598820400e-02 2.43147094475280921635484965293017e-03
 	 8.04739127081958161014085817441810e-01 3.14610159618917972768059598820400e-02 1.63799856956150069464683838305064e-01 2.43147094475280921635484965293017e-03
 	 1.02112773336674317326000505090633e-01 6.73683101645258797240956027962966e-02 8.30518916498799830705479507741984e-01 2.82657809760245492744501483173281e-03
 	 1.02112773336674317326000505090633e-01 8.30518916498799830705479507741984e-01 6.73683101645258797240956027962966e-02 2.82657809760245492744501483173281e-03
 	 6.73683101645258797240956027962966e-02 1.02112773336674317326000505090633e-01 8.30518916498799830705479507741984e-01 2.82657809760245492744501483173281e-03
 	 6.73683101645258797240956027962966e-02 8.30518916498799830705479507741984e-01 1.02112773336674317326000505090633e-01 2.82657809760245492744501483173281e-03
 	 8.30518916498799830705479507741984e-01 1.02112773336674317326000505090633e-01 6.73683101645258797240956027962966e-02 2.82657809760245492744501483173281e-03
 	 8.30518916498799830705479507741984e-01 6.73683101645258797240956027962966e-02 1.02112773336674317326000505090633e-01 2.82657809760245492744501483173281e-03
 	 2.33555703019351579285967090982012e-01 1.86565244199972779526319754950237e-01 5.79879052780675641187713154067751e-01 6.47535622548328377440229886019551e-03
 	 2.33555703019351579285967090982012e-01 5.79879052780675641187713154067751e-01 1.86565244199972779526319754950237e-01 6.47535622548328377440229886019551e-03
 	 1.86565244199972779526319754950237e-01 2.33555703019351579285967090982012e-01 5.79879052780675641187713154067751e-01 6.47535622548328377440229886019551e-03
 	 1.86565244199972779526319754950237e-01 5.79879052780675641187713154067751e-01 2.33555703019351579285967090982012e-01 6.47535622548328377440229886019551e-03
 	 5.79879052780675641187713154067751e-01 2.33555703019351579285967090982012e-01 1.86565244199972779526319754950237e-01 6.47535622548328377440229886019551e-03
 	 5.79879052780675641187713154067751e-01 1.86565244199972779526319754950237e-01 2.33555703019351579285967090982012e-01 6.47535622548328377440229886019551e-03
 	 3.21416462831711324810157748288475e-01 6.38834834123953448914434716243704e-02 6.14700053755893316420610972272698e-01 4.24848245125418726847454919948177e-03
 	 3.21416462831711324810157748288475e-01 6.14700053755893316420610972272698e-01 6.38834834123953448914434716243704e-02 4.24848245125418726847454919948177e-03
 	 6.38834834123953448914434716243704e-02 3.21416462831711324810157748288475e-01 6.14700053755893316420610972272698e-01 4.24848245125418726847454919948177e-03
 	 6.38834834123953448914434716243704e-02 6.14700053755893316420610972272698e-01 3.21416462831711324810157748288475e-01 4.24848245125418726847454919948177e-03
 	 6.14700053755893316420610972272698e-01 3.21416462831711324810157748288475e-01 6.38834834123953448914434716243704e-02 4.24848245125418726847454919948177e-03
 	 6.14700053755893316420610972272698e-01 6.38834834123953448914434716243704e-02 3.21416462831711324810157748288475e-01 4.24848245125418726847454919948177e-03
 	 2.23336184895712552833657582596061e-01 3.25712217949498672453501058043912e-02 7.44092593309337635432143542857375e-01 2.91008590906225448127764288130948e-03
 	 2.23336184895712552833657582596061e-01 7.44092593309337635432143542857375e-01 3.25712217949498672453501058043912e-02 2.91008590906225448127764288130948e-03
 	 3.25712217949498672453501058043912e-02 2.23336184895712552833657582596061e-01 7.44092593309337635432143542857375e-01 2.91008590906225448127764288130948e-03
 	 3.25712217949498672453501058043912e-02 7.44092593309337635432143542857375e-01 2.23336184895712552833657582596061e-01 2.91008590906225448127764288130948e-03
 	 7.44092593309337635432143542857375e-01 2.23336184895712552833657582596061e-01 3.25712217949498672453501058043912e-02 2.91008590906225448127764288130948e-03
 	 7.44092593309337635432143542857375e-01 3.25712217949498672453501058043912e-02 2.23336184895712552833657582596061e-01 2.91008590906225448127764288130948e-03
 	 1.90588118946320272950600838157698e-01 1.32734827561577940074899473188452e-02 7.96138398297521865387693651427981e-01 1.75439433093140776005747216714781e-03
 	 1.90588118946320272950600838157698e-01 7.96138398297521865387693651427981e-01 1.32734827561577940074899473188452e-02 1.75439433093140776005747216714781e-03
 	 1.32734827561577940074899473188452e-02 1.90588118946320272950600838157698e-01 7.96138398297521865387693651427981e-01 1.75439433093140776005747216714781e-03
 	 1.32734827561577940074899473188452e-02 7.96138398297521865387693651427981e-01 1.90588118946320272950600838157698e-01 1.75439433093140776005747216714781e-03
 	 7.96138398297521865387693651427981e-01 1.90588118946320272950600838157698e-01 1.32734827561577940074899473188452e-02 1.75439433093140776005747216714781e-03
 	 7.96138398297521865387693651427981e-01 1.32734827561577940074899473188452e-02 1.90588118946320272950600838157698e-01 1.75439433093140776005747216714781e-03
 	 2.27355840245479501326997251453577e-01 1.36233775509128074432396715565119e-01 6.36410384245392424240606032981304e-01 5.32781436353257920046644358080812e-03
 	 2.27355840245479501326997251453577e-01 6.36410384245392424240606032981304e-01 1.36233775509128074432396715565119e-01 5.32781436353257920046644358080812e-03
 	 1.36233775509128074432396715565119e-01 2.27355840245479501326997251453577e-01 6.36410384245392424240606032981304e-01 5.32781436353257920046644358080812e-03
 	 1.36233775509128074432396715565119e-01 6.36410384245392424240606032981304e-01 2.27355840245479501326997251453577e-01 5.32781436353257920046644358080812e-03
 	 6.36410384245392424240606032981304e-01 2.27355840245479501326997251453577e-01 1.36233775509128074432396715565119e-01 5.32781436353257920046644358080812e-03
 	 6.36410384245392424240606032981304e-01 1.36233775509128074432396715565119e-01 2.27355840245479501326997251453577e-01 5.32781436353257920046644358080812e-03
 	 1.56767922787160035591469409155252e-01 2.61537753388922135366900789676947e-03 8.40616699678950807239630194089841e-01 7.11735515053380169217533968151201e-04
 	 1.56767922787160035591469409155252e-01 8.40616699678950807239630194089841e-01 2.61537753388922135366900789676947e-03 7.11735515053380169217533968151201e-04
 	 2.61537753388922135366900789676947e-03 1.56767922787160035591469409155252e-01 8.40616699678950807239630194089841e-01 7.11735515053380169217533968151201e-04
 	 2.61537753388922135366900789676947e-03 8.40616699678950807239630194089841e-01 1.56767922787160035591469409155252e-01 7.11735515053380169217533968151201e-04
 	 8.40616699678950807239630194089841e-01 1.56767922787160035591469409155252e-01 2.61537753388922135366900789676947e-03 7.11735515053380169217533968151201e-04
 	 8.40616699678950807239630194089841e-01 2.61537753388922135366900789676947e-03 1.56767922787160035591469409155252e-01 7.11735515053380169217533968151201e-04
 	 1.34033334986778468467250036155747e-01 1.34812112051568063625373028457943e-02 8.52485453808064730374383088928880e-01 1.56851961814343746764999210085989e-03
 	 1.34033334986778468467250036155747e-01 8.52485453808064730374383088928880e-01 1.34812112051568063625373028457943e-02 1.56851961814343746764999210085989e-03
 	 1.34812112051568063625373028457943e-02 1.34033334986778468467250036155747e-01 8.52485453808064730374383088928880e-01 1.56851961814343746764999210085989e-03
 	 1.34812112051568063625373028457943e-02 8.52485453808064730374383088928880e-01 1.34033334986778468467250036155747e-01 1.56851961814343746764999210085989e-03
 	 8.52485453808064730374383088928880e-01 1.34033334986778468467250036155747e-01 1.34812112051568063625373028457943e-02 1.56851961814343746764999210085989e-03
 	 8.52485453808064730374383088928880e-01 1.34812112051568063625373028457943e-02 1.34033334986778468467250036155747e-01 1.56851961814343746764999210085989e-03
 	 2.95721175745453590533173837684444e-01 1.91884104352206263932600904809078e-01 5.12394719902340090023074026248651e-01 6.90968370338533501712197093524992e-03
 	 2.95721175745453590533173837684444e-01 5.12394719902340090023074026248651e-01 1.91884104352206263932600904809078e-01 6.90968370338533501712197093524992e-03
 	 1.91884104352206263932600904809078e-01 2.95721175745453590533173837684444e-01 5.12394719902340090023074026248651e-01 6.90968370338533501712197093524992e-03
 	 1.91884104352206263932600904809078e-01 5.12394719902340090023074026248651e-01 2.95721175745453590533173837684444e-01 6.90968370338533501712197093524992e-03
 	 5.12394719902340090023074026248651e-01 2.95721175745453590533173837684444e-01 1.91884104352206263932600904809078e-01 6.90968370338533501712197093524992e-03
 	 5.12394719902340090023074026248651e-01 1.91884104352206263932600904809078e-01 2.95721175745453590533173837684444e-01 6.90968370338533501712197093524992e-03
 	 1.06719271813000365911605626934033e-01 2.54728163216983664179915436420742e-03 8.90733446554829777497275244968478e-01 6.07766889338416096619233108810931e-04
 	 1.06719271813000365911605626934033e-01 8.90733446554829777497275244968478e-01 2.54728163216983664179915436420742e-03 6.07766889338416096619233108810931e-04
 	 2.54728163216983664179915436420742e-03 1.06719271813000365911605626934033e-01 8.90733446554829777497275244968478e-01 6.07766889338416096619233108810931e-04
 	 2.54728163216983664179915436420742e-03 8.90733446554829777497275244968478e-01 1.06719271813000365911605626934033e-01 6.07766889338416096619233108810931e-04
 	 8.90733446554829777497275244968478e-01 1.06719271813000365911605626934033e-01 2.54728163216983664179915436420742e-03 6.07766889338416096619233108810931e-04
 	 8.90733446554829777497275244968478e-01 2.54728163216983664179915436420742e-03 1.06719271813000365911605626934033e-01 6.07766889338416096619233108810931e-04
 	 4.12566419483916535515533041689196e-01 1.01037294355759685315909734981688e-01 4.86396286160323820801920646772487e-01 5.85990605055180212301646491823703e-03
 	 4.12566419483916535515533041689196e-01 4.86396286160323820801920646772487e-01 1.01037294355759685315909734981688e-01 5.85990605055180212301646491823703e-03
 	 1.01037294355759685315909734981688e-01 4.12566419483916535515533041689196e-01 4.86396286160323820801920646772487e-01 5.85990605055180212301646491823703e-03
 	 1.01037294355759685315909734981688e-01 4.86396286160323820801920646772487e-01 4.12566419483916535515533041689196e-01 5.85990605055180212301646491823703e-03
 	 4.86396286160323820801920646772487e-01 4.12566419483916535515533041689196e-01 1.01037294355759685315909734981688e-01 5.85990605055180212301646491823703e-03
 	 4.86396286160323820801920646772487e-01 1.01037294355759685315909734981688e-01 4.12566419483916535515533041689196e-01 5.85990605055180212301646491823703e-03
 	 3.07851982992886075152227931539528e-01 2.49750741165288780987197014837875e-01 4.42397275841825143860575053622597e-01 7.76518604062968829243596147193784e-03
 	 3.07851982992886075152227931539528e-01 4.42397275841825143860575053622597e-01 2.49750741165288780987197014837875e-01 7.76518604062968829243596147193784e-03
 	 2.49750741165288780987197014837875e-01 3.07851982992886075152227931539528e-01 4.42397275841825143860575053622597e-01 7.76518604062968829243596147193784e-03
 	 2.49750741165288780987197014837875e-01 4.42397275841825143860575053622597e-01 3.07851982992886075152227931539528e-01 7.76518604062968829243596147193784e-03
 	 4.42397275841825143860575053622597e-01 3.07851982992886075152227931539528e-01 2.49750741165288780987197014837875e-01 7.76518604062968829243596147193784e-03
 	 4.42397275841825143860575053622597e-01 2.49750741165288780987197014837875e-01 3.07851982992886075152227931539528e-01 7.76518604062968829243596147193784e-03
 	 8.70205486996966370849548866317491e-02 1.37126252885580324908376681491973e-02 8.99266826011745346036718729010317e-01 1.31004083298611254115861868285720e-03
 	 8.70205486996966370849548866317491e-02 8.99266826011745346036718729010317e-01 1.37126252885580324908376681491973e-02 1.31004083298611254115861868285720e-03
 	 1.37126252885580324908376681491973e-02 8.70205486996966370849548866317491e-02 8.99266826011745346036718729010317e-01 1.31004083298611254115861868285720e-03
 	 1.37126252885580324908376681491973e-02 8.99266826011745346036718729010317e-01 8.70205486996966370849548866317491e-02 1.31004083298611254115861868285720e-03
 	 8.99266826011745346036718729010317e-01 8.70205486996966370849548866317491e-02 1.37126252885580324908376681491973e-02 1.31004083298611254115861868285720e-03
 	 8.99266826011745346036718729010317e-01 1.37126252885580324908376681491973e-02 8.70205486996966370849548866317491e-02 1.31004083298611254115861868285720e-03
 	 3.89428331681219708215735408884939e-01 3.34459543340264765787228640192552e-03 6.07227072885377694433373108040541e-01 1.05709724917227038815115136571876e-03
 	 3.89428331681219708215735408884939e-01 6.07227072885377694433373108040541e-01 3.34459543340264765787228640192552e-03 1.05709724917227038815115136571876e-03
 	 3.34459543340264765787228640192552e-03 3.89428331681219708215735408884939e-01 6.07227072885377694433373108040541e-01 1.05709724917227038815115136571876e-03
 	 3.34459543340264765787228640192552e-03 6.07227072885377694433373108040541e-01 3.89428331681219708215735408884939e-01 1.05709724917227038815115136571876e-03
 	 6.07227072885377694433373108040541e-01 3.89428331681219708215735408884939e-01 3.34459543340264765787228640192552e-03 1.05709724917227038815115136571876e-03
 	 6.07227072885377694433373108040541e-01 3.34459543340264765787228640192552e-03 3.89428331681219708215735408884939e-01 1.05709724917227038815115136571876e-03
 	 2.61293970314177004254929670423735e-01 5.56746304306052139376781440205377e-02 6.83031399255217830379649512906326e-01 4.04119765075060168729725873504321e-03
 	 2.61293970314177004254929670423735e-01 6.83031399255217830379649512906326e-01 5.56746304306052139376781440205377e-02 4.04119765075060168729725873504321e-03
 	 5.56746304306052139376781440205377e-02 2.61293970314177004254929670423735e-01 6.83031399255217830379649512906326e-01 4.04119765075060168729725873504321e-03
 	 5.56746304306052139376781440205377e-02 6.83031399255217830379649512906326e-01 2.61293970314177004254929670423735e-01 4.04119765075060168729725873504321e-03
 	 6.83031399255217830379649512906326e-01 2.61293970314177004254929670423735e-01 5.56746304306052139376781440205377e-02 4.04119765075060168729725873504321e-03
 	 6.83031399255217830379649512906326e-01 5.56746304306052139376781440205377e-02 2.61293970314177004254929670423735e-01 4.04119765075060168729725873504321e-03
 	 6.49755331098118837918065082703833e-02 2.80375859354026635977819026379620e-03 9.32220708296647826429648375778925e-01 5.24247891345938285545535961773567e-04
 	 6.49755331098118837918065082703833e-02 9.32220708296647826429648375778925e-01 2.80375859354026635977819026379620e-03 5.24247891345938285545535961773567e-04
 	 2.80375859354026635977819026379620e-03 6.49755331098118837918065082703833e-02 9.32220708296647826429648375778925e-01 5.24247891345938285545535961773567e-04
 	 2.80375859354026635977819026379620e-03 9.32220708296647826429648375778925e-01 6.49755331098118837918065082703833e-02 5.24247891345938285545535961773567e-04
 	 9.32220708296647826429648375778925e-01 6.49755331098118837918065082703833e-02 2.80375859354026635977819026379620e-03 5.24247891345938285545535961773567e-04
 	 9.32220708296647826429648375778925e-01 2.80375859354026635977819026379620e-03 6.49755331098118837918065082703833e-02 5.24247891345938285545535961773567e-04
 	 2.71950006098130969700576997638564e-01 9.63505000772398451092115578830999e-02 6.31699493824629088045696789777139e-01 5.20486800632010988137965412647645e-03
 	 2.71950006098130969700576997638564e-01 6.31699493824629088045696789777139e-01 9.63505000772398451092115578830999e-02 5.20486800632010988137965412647645e-03
 	 9.63505000772398451092115578830999e-02 2.71950006098130969700576997638564e-01 6.31699493824629088045696789777139e-01 5.20486800632010988137965412647645e-03
 	 9.63505000772398451092115578830999e-02 6.31699493824629088045696789777139e-01 2.71950006098130969700576997638564e-01 5.20486800632010988137965412647645e-03
 	 6.31699493824629088045696789777139e-01 2.71950006098130969700576997638564e-01 9.63505000772398451092115578830999e-02 5.20486800632010988137965412647645e-03
 	 6.31699493824629088045696789777139e-01 9.63505000772398451092115578830999e-02 2.71950006098130969700576997638564e-01 5.20486800632010988137965412647645e-03
 	 2.93090364272546199941871236660518e-01 2.91991066004359950403213019853865e-02 6.77710529127017791140019653539639e-01 3.03331132626987300462961805180839e-03
 	 2.93090364272546199941871236660518e-01 6.77710529127017791140019653539639e-01 2.91991066004359950403213019853865e-02 3.03331132626987300462961805180839e-03
 	 2.91991066004359950403213019853865e-02 2.93090364272546199941871236660518e-01 6.77710529127017791140019653539639e-01 3.03331132626987300462961805180839e-03
 	 2.91991066004359950403213019853865e-02 6.77710529127017791140019653539639e-01 2.93090364272546199941871236660518e-01 3.03331132626987300462961805180839e-03
 	 6.77710529127017791140019653539639e-01 2.93090364272546199941871236660518e-01 2.91991066004359950403213019853865e-02 3.03331132626987300462961805180839e-03
 	 6.77710529127017791140019653539639e-01 2.91991066004359950403213019853865e-02 2.93090364272546199941871236660518e-01 3.03331132626987300462961805180839e-03
 	 3.94664826587819206338281219359487e-01 6.35745506621691741644397666277655e-02 5.41760622750011577863915590569377e-01 4.86855236039786948287755308228952e-03
 	 3.94664826587819206338281219359487e-01 5.41760622750011577863915590569377e-01 6.35745506621691741644397666277655e-02 4.86855236039786948287755308228952e-03
 	 6.35745506621691741644397666277655e-02 3.94664826587819206338281219359487e-01 5.41760622750011577863915590569377e-01 4.86855236039786948287755308228952e-03
 	 6.35745506621691741644397666277655e-02 5.41760622750011577863915590569377e-01 3.94664826587819206338281219359487e-01 4.86855236039786948287755308228952e-03
 	 5.41760622750011577863915590569377e-01 3.94664826587819206338281219359487e-01 6.35745506621691741644397666277655e-02 4.86855236039786948287755308228952e-03
 	 5.41760622750011577863915590569377e-01 6.35745506621691741644397666277655e-02 3.94664826587819206338281219359487e-01 4.86855236039786948287755308228952e-03
 	 3.56852218192982795219592162538902e-01 1.43928580065543848531817161529034e-01 4.99219201741473384004166291560978e-01 6.60287261808896637493848658095885e-03
 	 3.56852218192982795219592162538902e-01 4.99219201741473384004166291560978e-01 1.43928580065543848531817161529034e-01 6.60287261808896637493848658095885e-03
 	 1.43928580065543848531817161529034e-01 3.56852218192982795219592162538902e-01 4.99219201741473384004166291560978e-01 6.60287261808896637493848658095885e-03
 	 1.43928580065543848531817161529034e-01 4.99219201741473384004166291560978e-01 3.56852218192982795219592162538902e-01 6.60287261808896637493848658095885e-03
 	 4.99219201741473384004166291560978e-01 3.56852218192982795219592162538902e-01 1.43928580065543848531817161529034e-01 6.60287261808896637493848658095885e-03
 	 4.99219201741473384004166291560978e-01 1.43928580065543848531817161529034e-01 3.56852218192982795219592162538902e-01 6.60287261808896637493848658095885e-03
 	 3.41361351638876264757982426090166e-01 9.92086997532997810766985935515549e-02 5.59429948607823912531955556914909e-01 5.65313668831240404705207325264382e-03
 	 3.41361351638876264757982426090166e-01 5.59429948607823912531955556914909e-01 9.92086997532997810766985935515549e-02 5.65313668831240404705207325264382e-03
 	 9.92086997532997810766985935515549e-02 3.41361351638876264757982426090166e-01 5.59429948607823912531955556914909e-01 5.65313668831240404705207325264382e-03
 	 9.92086997532997810766985935515549e-02 5.59429948607823912531955556914909e-01 3.41361351638876264757982426090166e-01 5.65313668831240404705207325264382e-03
 	 5.59429948607823912531955556914909e-01 3.41361351638876264757982426090166e-01 9.92086997532997810766985935515549e-02 5.65313668831240404705207325264382e-03
 	 5.59429948607823912531955556914909e-01 9.92086997532997810766985935515549e-02 3.41361351638876264757982426090166e-01 5.65313668831240404705207325264382e-03
 	 2.89512941079514585229759404683136e-01 1.40388921421462892213938289387443e-01 5.70098137499022605823029152816162e-01 6.19192901234393803383548871011044e-03
 	 2.89512941079514585229759404683136e-01 5.70098137499022605823029152816162e-01 1.40388921421462892213938289387443e-01 6.19192901234393803383548871011044e-03
 	 1.40388921421462892213938289387443e-01 2.89512941079514585229759404683136e-01 5.70098137499022605823029152816162e-01 6.19192901234393803383548871011044e-03
 	 1.40388921421462892213938289387443e-01 5.70098137499022605823029152816162e-01 2.89512941079514585229759404683136e-01 6.19192901234393803383548871011044e-03
 	 5.70098137499022605823029152816162e-01 2.89512941079514585229759404683136e-01 1.40388921421462892213938289387443e-01 6.19192901234393803383548871011044e-03
 	 5.70098137499022605823029152816162e-01 1.40388921421462892213938289387443e-01 2.89512941079514585229759404683136e-01 6.19192901234393803383548871011044e-03
 	 ];
 
 	 case  43 

 	 % ALG. DEG.:   43
 	 % PTS CARD.:  339
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw_bar=[
 	 4.11780170859933791760454369068611e-01 4.11780170859933791760454369068611e-01 1.76439658280132416479091261862777e-01 3.07996556918163372912333741737712e-03
 	 4.11780170859933791760454369068611e-01 1.76439658280132416479091261862777e-01 4.11780170859933791760454369068611e-01 3.07996556918163372912333741737712e-03
 	 1.76439658280132416479091261862777e-01 4.11780170859933791760454369068611e-01 4.11780170859933791760454369068611e-01 3.07996556918163372912333741737712e-03
 	 4.75575867099131466275707680324558e-01 4.75575867099131466275707680324558e-01 4.88482658017370674485846393508837e-02 2.48734822024648414770520155059330e-03
 	 4.75575867099131466275707680324558e-01 4.88482658017370674485846393508837e-02 4.75575867099131466275707680324558e-01 2.48734822024648414770520155059330e-03
 	 4.88482658017370674485846393508837e-02 4.75575867099131466275707680324558e-01 4.75575867099131466275707680324558e-01 2.48734822024648414770520155059330e-03
 	 4.99179836734477966331269271904603e-01 4.99179836734477966331269271904603e-01 1.64032653104406733746145619079471e-03 6.08615722180780196852445396160647e-04
 	 4.99179836734477966331269271904603e-01 1.64032653104406733746145619079471e-03 4.99179836734477966331269271904603e-01 6.08615722180780196852445396160647e-04
 	 1.64032653104406733746145619079471e-03 4.99179836734477966331269271904603e-01 4.99179836734477966331269271904603e-01 6.08615722180780196852445396160647e-04
 	 2.96247988168869824665563328380813e-01 2.96247988168869824665563328380813e-01 4.07504023662260350668873343238374e-01 5.87808233375915721585780460145543e-03
 	 2.96247988168869824665563328380813e-01 4.07504023662260350668873343238374e-01 2.96247988168869824665563328380813e-01 5.87808233375915721585780460145543e-03
 	 4.07504023662260350668873343238374e-01 2.96247988168869824665563328380813e-01 2.96247988168869824665563328380813e-01 5.87808233375915721585780460145543e-03
 	 3.53188804887000662446894239110406e-01 3.53188804887000662446894239110406e-01 2.93622390225998675106211521779187e-01 6.86848896651495646054064181385002e-03
 	 3.53188804887000662446894239110406e-01 2.93622390225998675106211521779187e-01 3.53188804887000662446894239110406e-01 6.86848896651495646054064181385002e-03
 	 2.93622390225998675106211521779187e-01 3.53188804887000662446894239110406e-01 3.53188804887000662446894239110406e-01 6.86848896651495646054064181385002e-03
 	 4.95105980802769907178628727706382e-01 4.95105980802769907178628727706382e-01 9.78803839446018564274254458723590e-03 1.61430724391575428598721853035158e-03
 	 4.95105980802769907178628727706382e-01 9.78803839446018564274254458723590e-03 4.95105980802769907178628727706382e-01 1.61430724391575428598721853035158e-03
 	 9.78803839446018564274254458723590e-03 4.95105980802769907178628727706382e-01 4.95105980802769907178628727706382e-01 1.61430724391575428598721853035158e-03
 	 3.29098159605345705336354455994297e-02 3.29098159605345705336354455994297e-02 9.34180368078930900566092532244511e-01 1.08362242927104862610931945710036e-03
 	 3.29098159605345705336354455994297e-02 9.34180368078930900566092532244511e-01 3.29098159605345705336354455994297e-02 1.08362242927104862610931945710036e-03
 	 9.34180368078930900566092532244511e-01 3.29098159605345705336354455994297e-02 3.29098159605345705336354455994297e-02 1.08362242927104862610931945710036e-03
 	 4.86563751130688337820373590147938e-01 4.86563751130688337820373590147938e-01 2.68724977386233243592528197041247e-02 2.71660506829517764751380504151257e-03
 	 4.86563751130688337820373590147938e-01 2.68724977386233243592528197041247e-02 4.86563751130688337820373590147938e-01 2.71660506829517764751380504151257e-03
 	 2.68724977386233243592528197041247e-02 4.86563751130688337820373590147938e-01 4.86563751130688337820373590147938e-01 2.71660506829517764751380504151257e-03
 	 6.27150483897616628503612901113229e-02 6.27150483897616628503612901113229e-02 8.74569903220476674299277419777354e-01 2.02432930454965421748769749399344e-03
 	 6.27150483897616628503612901113229e-02 8.74569903220476674299277419777354e-01 6.27150483897616628503612901113229e-02 2.02432930454965421748769749399344e-03
 	 8.74569903220476674299277419777354e-01 6.27150483897616628503612901113229e-02 6.27150483897616628503612901113229e-02 2.02432930454965421748769749399344e-03
 	 1.44743559770221352778207801748067e-01 1.44743559770221352778207801748067e-01 7.10512880459557294443584396503866e-01 4.24543192106432466792487190332395e-03
 	 1.44743559770221352778207801748067e-01 7.10512880459557294443584396503866e-01 1.44743559770221352778207801748067e-01 4.24543192106432466792487190332395e-03
 	 7.10512880459557294443584396503866e-01 1.44743559770221352778207801748067e-01 1.44743559770221352778207801748067e-01 4.24543192106432466792487190332395e-03
 	 1.33646206082615737198437955157715e-02 1.33646206082615737198437955157715e-02 9.73270758783476797049161177710630e-01 4.72102105579207066612251741943851e-04
 	 1.33646206082615737198437955157715e-02 9.73270758783476797049161177710630e-01 1.33646206082615737198437955157715e-02 4.72102105579207066612251741943851e-04
 	 9.73270758783476797049161177710630e-01 1.33646206082615737198437955157715e-02 1.33646206082615737198437955157715e-02 4.72102105579207066612251741943851e-04
 	 2.56494137002013589468618626199259e-03 2.56494137002013589468618626199259e-03 9.94870117259959774180799740861403e-01 8.57325766798822173735128426841356e-05
 	 2.56494137002013589468618626199259e-03 9.94870117259959774180799740861403e-01 2.56494137002013589468618626199259e-03 8.57325766798822173735128426841356e-05
 	 9.94870117259959774180799740861403e-01 2.56494137002013589468618626199259e-03 2.56494137002013589468618626199259e-03 8.57325766798822173735128426841356e-05
 	 1.87772242778578402067068964242935e-01 1.87772242778578402067068964242935e-01 6.24455514442843195865862071514130e-01 5.33527534239618995981491167412969e-03
 	 1.87772242778578402067068964242935e-01 6.24455514442843195865862071514130e-01 1.87772242778578402067068964242935e-01 5.33527534239618995981491167412969e-03
 	 6.24455514442843195865862071514130e-01 1.87772242778578402067068964242935e-01 1.87772242778578402067068964242935e-01 5.33527534239618995981491167412969e-03
 	 3.82564308786935480810598164680414e-01 3.82564308786935480810598164680414e-01 2.34871382426129038378803670639172e-01 6.94968086905658078561431878483745e-03
 	 3.82564308786935480810598164680414e-01 2.34871382426129038378803670639172e-01 3.82564308786935480810598164680414e-01 6.94968086905658078561431878483745e-03
 	 2.34871382426129038378803670639172e-01 3.82564308786935480810598164680414e-01 3.82564308786935480810598164680414e-01 6.94968086905658078561431878483745e-03
 	 4.52892260845951022396604912501061e-01 4.52892260845951022396604912501061e-01 9.42154783080979552067901749978773e-02 5.33280542040101383782779720377221e-03
 	 4.52892260845951022396604912501061e-01 9.42154783080979552067901749978773e-02 4.52892260845951022396604912501061e-01 5.33280542040101383782779720377221e-03
 	 9.42154783080979552067901749978773e-02 4.52892260845951022396604912501061e-01 4.52892260845951022396604912501061e-01 5.33280542040101383782779720377221e-03
 	 9.28670462140478714108127178405994e-02 9.28670462140478714108127178405994e-02 8.14265907571904312689525795576628e-01 3.29070614585399729562498194468390e-03
 	 9.28670462140478714108127178405994e-02 8.14265907571904312689525795576628e-01 9.28670462140478714108127178405994e-02 3.29070614585399729562498194468390e-03
 	 8.14265907571904312689525795576628e-01 9.28670462140478714108127178405994e-02 9.28670462140478714108127178405994e-02 3.29070614585399729562498194468390e-03
 	 2.52484932649090720868656489983550e-01 2.52484932649090720868656489983550e-01 4.95030134701818558262687020032899e-01 7.31420914312034143450746981329758e-03
 	 2.52484932649090720868656489983550e-01 4.95030134701818558262687020032899e-01 2.52484932649090720868656489983550e-01 7.31420914312034143450746981329758e-03
 	 4.95030134701818558262687020032899e-01 2.52484932649090720868656489983550e-01 2.52484932649090720868656489983550e-01 7.31420914312034143450746981329758e-03
 	 2.29739436527249235586722875268606e-01 1.45453795387832596208710356222582e-01 6.24806768084918084937839921622071e-01 3.91263834081756987914868517464129e-03
 	 2.29739436527249235586722875268606e-01 6.24806768084918084937839921622071e-01 1.45453795387832596208710356222582e-01 3.91263834081756987914868517464129e-03
 	 1.45453795387832596208710356222582e-01 2.29739436527249235586722875268606e-01 6.24806768084918084937839921622071e-01 3.91263834081756987914868517464129e-03
 	 1.45453795387832596208710356222582e-01 6.24806768084918084937839921622071e-01 2.29739436527249235586722875268606e-01 3.91263834081756987914868517464129e-03
 	 6.24806768084918084937839921622071e-01 2.29739436527249235586722875268606e-01 1.45453795387832596208710356222582e-01 3.91263834081756987914868517464129e-03
 	 6.24806768084918084937839921622071e-01 1.45453795387832596208710356222582e-01 2.29739436527249235586722875268606e-01 3.91263834081756987914868517464129e-03
 	 3.60558076088783818757832477785996e-01 3.24154748417785493197484925076424e-02 6.07026449069437590289055606262991e-01 2.65755977207712086249347116506669e-03
 	 3.60558076088783818757832477785996e-01 6.07026449069437590289055606262991e-01 3.24154748417785493197484925076424e-02 2.65755977207712086249347116506669e-03
 	 3.24154748417785493197484925076424e-02 3.60558076088783818757832477785996e-01 6.07026449069437590289055606262991e-01 2.65755977207712086249347116506669e-03
 	 3.24154748417785493197484925076424e-02 6.07026449069437590289055606262991e-01 3.60558076088783818757832477785996e-01 2.65755977207712086249347116506669e-03
 	 6.07026449069437590289055606262991e-01 3.60558076088783818757832477785996e-01 3.24154748417785493197484925076424e-02 2.65755977207712086249347116506669e-03
 	 6.07026449069437590289055606262991e-01 3.24154748417785493197484925076424e-02 3.60558076088783818757832477785996e-01 2.65755977207712086249347116506669e-03
 	 9.59172276669436746354691081251076e-02 1.24129082244383796146403042826023e-02 8.91669864108617926667932351847412e-01 1.04038585761636291626697214951491e-03
 	 9.59172276669436746354691081251076e-02 8.91669864108617926667932351847412e-01 1.24129082244383796146403042826023e-02 1.04038585761636291626697214951491e-03
 	 1.24129082244383796146403042826023e-02 9.59172276669436746354691081251076e-02 8.91669864108617926667932351847412e-01 1.04038585761636291626697214951491e-03
 	 1.24129082244383796146403042826023e-02 8.91669864108617926667932351847412e-01 9.59172276669436746354691081251076e-02 1.04038585761636291626697214951491e-03
 	 8.91669864108617926667932351847412e-01 9.59172276669436746354691081251076e-02 1.24129082244383796146403042826023e-02 1.04038585761636291626697214951491e-03
 	 8.91669864108617926667932351847412e-01 1.24129082244383796146403042826023e-02 9.59172276669436746354691081251076e-02 1.04038585761636291626697214951491e-03
 	 1.89801510111088478360841236280976e-01 1.37858117891493076045961174713739e-01 6.72340371997418473348773204634199e-01 3.86882224552416355972672690199943e-03
 	 1.89801510111088478360841236280976e-01 6.72340371997418473348773204634199e-01 1.37858117891493076045961174713739e-01 3.86882224552416355972672690199943e-03
 	 1.37858117891493076045961174713739e-01 1.89801510111088478360841236280976e-01 6.72340371997418473348773204634199e-01 3.86882224552416355972672690199943e-03
 	 1.37858117891493076045961174713739e-01 6.72340371997418473348773204634199e-01 1.89801510111088478360841236280976e-01 3.86882224552416355972672690199943e-03
 	 6.72340371997418473348773204634199e-01 1.89801510111088478360841236280976e-01 1.37858117891493076045961174713739e-01 3.86882224552416355972672690199943e-03
 	 6.72340371997418473348773204634199e-01 1.37858117891493076045961174713739e-01 1.89801510111088478360841236280976e-01 3.86882224552416355972672690199943e-03
 	 4.01058451292605144811176387520391e-01 1.35336131153596217480128416355001e-01 4.63605417553798582197543964866782e-01 5.43600792158506051360289390572689e-03
 	 4.01058451292605144811176387520391e-01 4.63605417553798582197543964866782e-01 1.35336131153596217480128416355001e-01 5.43600792158506051360289390572689e-03
 	 1.35336131153596217480128416355001e-01 4.01058451292605144811176387520391e-01 4.63605417553798582197543964866782e-01 5.43600792158506051360289390572689e-03
 	 1.35336131153596217480128416355001e-01 4.63605417553798582197543964866782e-01 4.01058451292605144811176387520391e-01 5.43600792158506051360289390572689e-03
 	 4.63605417553798582197543964866782e-01 4.01058451292605144811176387520391e-01 1.35336131153596217480128416355001e-01 5.43600792158506051360289390572689e-03
 	 4.63605417553798582197543964866782e-01 1.35336131153596217480128416355001e-01 4.01058451292605144811176387520391e-01 5.43600792158506051360289390572689e-03
 	 2.77582532276102134094486473259167e-01 1.43526791892476662804156717356818e-01 5.78890675831421286368083656270755e-01 5.13302107701345180362784148542232e-03
 	 2.77582532276102134094486473259167e-01 5.78890675831421286368083656270755e-01 1.43526791892476662804156717356818e-01 5.13302107701345180362784148542232e-03
 	 1.43526791892476662804156717356818e-01 2.77582532276102134094486473259167e-01 5.78890675831421286368083656270755e-01 5.13302107701345180362784148542232e-03
 	 1.43526791892476662804156717356818e-01 5.78890675831421286368083656270755e-01 2.77582532276102134094486473259167e-01 5.13302107701345180362784148542232e-03
 	 5.78890675831421286368083656270755e-01 2.77582532276102134094486473259167e-01 1.43526791892476662804156717356818e-01 5.13302107701345180362784148542232e-03
 	 5.78890675831421286368083656270755e-01 1.43526791892476662804156717356818e-01 2.77582532276102134094486473259167e-01 5.13302107701345180362784148542232e-03
 	 3.06118376690335036727219630847685e-01 3.54515915965141689691897397551656e-02 6.58430031713150842875847956747748e-01 2.72488526040648134166066718364618e-03
 	 3.06118376690335036727219630847685e-01 6.58430031713150842875847956747748e-01 3.54515915965141689691897397551656e-02 2.72488526040648134166066718364618e-03
 	 3.54515915965141689691897397551656e-02 3.06118376690335036727219630847685e-01 6.58430031713150842875847956747748e-01 2.72488526040648134166066718364618e-03
 	 3.54515915965141689691897397551656e-02 6.58430031713150842875847956747748e-01 3.06118376690335036727219630847685e-01 2.72488526040648134166066718364618e-03
 	 6.58430031713150842875847956747748e-01 3.06118376690335036727219630847685e-01 3.54515915965141689691897397551656e-02 2.72488526040648134166066718364618e-03
 	 6.58430031713150842875847956747748e-01 3.54515915965141689691897397551656e-02 3.06118376690335036727219630847685e-01 2.72488526040648134166066718364618e-03
 	 4.18289170173424762477765170842758e-01 3.54185331313221704596649885843362e-02 5.46292296695253032368100321036763e-01 3.08192782770260386912553052241037e-03
 	 4.18289170173424762477765170842758e-01 5.46292296695253032368100321036763e-01 3.54185331313221704596649885843362e-02 3.08192782770260386912553052241037e-03
 	 3.54185331313221704596649885843362e-02 4.18289170173424762477765170842758e-01 5.46292296695253032368100321036763e-01 3.08192782770260386912553052241037e-03
 	 3.54185331313221704596649885843362e-02 5.46292296695253032368100321036763e-01 4.18289170173424762477765170842758e-01 3.08192782770260386912553052241037e-03
 	 5.46292296695253032368100321036763e-01 4.18289170173424762477765170842758e-01 3.54185331313221704596649885843362e-02 3.08192782770260386912553052241037e-03
 	 5.46292296695253032368100321036763e-01 3.54185331313221704596649885843362e-02 4.18289170173424762477765170842758e-01 3.08192782770260386912553052241037e-03
 	 9.65099243357523811637221911041706e-02 5.57938681257981461403261391751585e-02 8.47696207538449542084890708792955e-01 2.19601466089651116767034189081187e-03
 	 9.65099243357523811637221911041706e-02 8.47696207538449542084890708792955e-01 5.57938681257981461403261391751585e-02 2.19601466089651116767034189081187e-03
 	 5.57938681257981461403261391751585e-02 9.65099243357523811637221911041706e-02 8.47696207538449542084890708792955e-01 2.19601466089651116767034189081187e-03
 	 5.57938681257981461403261391751585e-02 8.47696207538449542084890708792955e-01 9.65099243357523811637221911041706e-02 2.19601466089651116767034189081187e-03
 	 8.47696207538449542084890708792955e-01 9.65099243357523811637221911041706e-02 5.57938681257981461403261391751585e-02 2.19601466089651116767034189081187e-03
 	 8.47696207538449542084890708792955e-01 5.57938681257981461403261391751585e-02 9.65099243357523811637221911041706e-02 2.19601466089651116767034189081187e-03
 	 1.32839741110529208079071850079345e-01 6.39762347898086281006158060336020e-02 8.03184024099662163820312343887053e-01 2.70717162918946915861617696918984e-03
 	 1.32839741110529208079071850079345e-01 8.03184024099662163820312343887053e-01 6.39762347898086281006158060336020e-02 2.70717162918946915861617696918984e-03
 	 6.39762347898086281006158060336020e-02 1.32839741110529208079071850079345e-01 8.03184024099662163820312343887053e-01 2.70717162918946915861617696918984e-03
 	 6.39762347898086281006158060336020e-02 8.03184024099662163820312343887053e-01 1.32839741110529208079071850079345e-01 2.70717162918946915861617696918984e-03
 	 8.03184024099662163820312343887053e-01 1.32839741110529208079071850079345e-01 6.39762347898086281006158060336020e-02 2.70717162918946915861617696918984e-03
 	 8.03184024099662163820312343887053e-01 6.39762347898086281006158060336020e-02 1.32839741110529208079071850079345e-01 2.70717162918946915861617696918984e-03
 	 9.69643297980663232404907603267930e-02 3.02625797417711110692817300105162e-02 8.72773090460162492831841518636793e-01 1.77325056630299915556847611952662e-03
 	 9.69643297980663232404907603267930e-02 8.72773090460162492831841518636793e-01 3.02625797417711110692817300105162e-02 1.77325056630299915556847611952662e-03
 	 3.02625797417711110692817300105162e-02 9.69643297980663232404907603267930e-02 8.72773090460162492831841518636793e-01 1.77325056630299915556847611952662e-03
 	 3.02625797417711110692817300105162e-02 8.72773090460162492831841518636793e-01 9.69643297980663232404907603267930e-02 1.77325056630299915556847611952662e-03
 	 8.72773090460162492831841518636793e-01 9.69643297980663232404907603267930e-02 3.02625797417711110692817300105162e-02 1.77325056630299915556847611952662e-03
 	 8.72773090460162492831841518636793e-01 3.02625797417711110692817300105162e-02 9.69643297980663232404907603267930e-02 1.77325056630299915556847611952662e-03
 	 4.28753753691012928772607892824453e-01 1.46376163589685189675426713051820e-02 5.56608629950018585219595479429699e-01 2.11940953208560002238303177080070e-03
 	 4.28753753691012928772607892824453e-01 5.56608629950018585219595479429699e-01 1.46376163589685189675426713051820e-02 2.11940953208560002238303177080070e-03
 	 1.46376163589685189675426713051820e-02 4.28753753691012928772607892824453e-01 5.56608629950018585219595479429699e-01 2.11940953208560002238303177080070e-03
 	 1.46376163589685189675426713051820e-02 5.56608629950018585219595479429699e-01 4.28753753691012928772607892824453e-01 2.11940953208560002238303177080070e-03
 	 5.56608629950018585219595479429699e-01 4.28753753691012928772607892824453e-01 1.46376163589685189675426713051820e-02 2.11940953208560002238303177080070e-03
 	 5.56608629950018585219595479429699e-01 1.46376163589685189675426713051820e-02 4.28753753691012928772607892824453e-01 2.11940953208560002238303177080070e-03
 	 1.36853445326083039690345799499482e-01 1.36052509293985018912209739028185e-02 8.49541303744518527807372265669983e-01 1.38226582739965240739787866175448e-03
 	 1.36853445326083039690345799499482e-01 8.49541303744518527807372265669983e-01 1.36052509293985018912209739028185e-02 1.38226582739965240739787866175448e-03
 	 1.36052509293985018912209739028185e-02 1.36853445326083039690345799499482e-01 8.49541303744518527807372265669983e-01 1.38226582739965240739787866175448e-03
 	 1.36052509293985018912209739028185e-02 8.49541303744518527807372265669983e-01 1.36853445326083039690345799499482e-01 1.38226582739965240739787866175448e-03
 	 8.49541303744518527807372265669983e-01 1.36853445326083039690345799499482e-01 1.36052509293985018912209739028185e-02 1.38226582739965240739787866175448e-03
 	 8.49541303744518527807372265669983e-01 1.36052509293985018912209739028185e-02 1.36853445326083039690345799499482e-01 1.38226582739965240739787866175448e-03
 	 3.63561909099252844601579681693693e-01 2.47604062219227219476813672827120e-03 6.33962050278554900550886941346107e-01 8.28779602275981231579438102130553e-04
 	 3.63561909099252844601579681693693e-01 6.33962050278554900550886941346107e-01 2.47604062219227219476813672827120e-03 8.28779602275981231579438102130553e-04
 	 2.47604062219227219476813672827120e-03 3.63561909099252844601579681693693e-01 6.33962050278554900550886941346107e-01 8.28779602275981231579438102130553e-04
 	 2.47604062219227219476813672827120e-03 6.33962050278554900550886941346107e-01 3.63561909099252844601579681693693e-01 8.28779602275981231579438102130553e-04
 	 6.33962050278554900550886941346107e-01 3.63561909099252844601579681693693e-01 2.47604062219227219476813672827120e-03 8.28779602275981231579438102130553e-04
 	 6.33962050278554900550886941346107e-01 2.47604062219227219476813672827120e-03 3.63561909099252844601579681693693e-01 8.28779602275981231579438102130553e-04
 	 3.36143572327619710726764878927497e-01 1.42925973377929421692655864717381e-01 5.20930454294450839825003640726209e-01 5.76092997036831318269367585571672e-03
 	 3.36143572327619710726764878927497e-01 5.20930454294450839825003640726209e-01 1.42925973377929421692655864717381e-01 5.76092997036831318269367585571672e-03
 	 1.42925973377929421692655864717381e-01 3.36143572327619710726764878927497e-01 5.20930454294450839825003640726209e-01 5.76092997036831318269367585571672e-03
 	 1.42925973377929421692655864717381e-01 5.20930454294450839825003640726209e-01 3.36143572327619710726764878927497e-01 5.76092997036831318269367585571672e-03
 	 5.20930454294450839825003640726209e-01 3.36143572327619710726764878927497e-01 1.42925973377929421692655864717381e-01 5.76092997036831318269367585571672e-03
 	 5.20930454294450839825003640726209e-01 1.42925973377929421692655864717381e-01 3.36143572327619710726764878927497e-01 5.76092997036831318269367585571672e-03
 	 9.40988534499003353994694975881430e-02 2.42077774579726101231158530424636e-03 9.03480368804302380603132860414917e-01 4.86640653578934506088421452218995e-04
 	 9.40988534499003353994694975881430e-02 9.03480368804302380603132860414917e-01 2.42077774579726101231158530424636e-03 4.86640653578934506088421452218995e-04
 	 2.42077774579726101231158530424636e-03 9.40988534499003353994694975881430e-02 9.03480368804302380603132860414917e-01 4.86640653578934506088421452218995e-04
 	 2.42077774579726101231158530424636e-03 9.03480368804302380603132860414917e-01 9.40988534499003353994694975881430e-02 4.86640653578934506088421452218995e-04
 	 9.03480368804302380603132860414917e-01 9.40988534499003353994694975881430e-02 2.42077774579726101231158530424636e-03 4.86640653578934506088421452218995e-04
 	 9.03480368804302380603132860414917e-01 2.42077774579726101231158530424636e-03 9.40988534499003353994694975881430e-02 4.86640653578934506088421452218995e-04
 	 2.42710586669900529876997552491957e-01 1.95150339989513393890163683863648e-01 5.62139073340586103988414379273308e-01 6.06117060449665699672916474582962e-03
 	 2.42710586669900529876997552491957e-01 5.62139073340586103988414379273308e-01 1.95150339989513393890163683863648e-01 6.06117060449665699672916474582962e-03
 	 1.95150339989513393890163683863648e-01 2.42710586669900529876997552491957e-01 5.62139073340586103988414379273308e-01 6.06117060449665699672916474582962e-03
 	 1.95150339989513393890163683863648e-01 5.62139073340586103988414379273308e-01 2.42710586669900529876997552491957e-01 6.06117060449665699672916474582962e-03
 	 5.62139073340586103988414379273308e-01 2.42710586669900529876997552491957e-01 1.95150339989513393890163683863648e-01 6.06117060449665699672916474582962e-03
 	 5.62139073340586103988414379273308e-01 1.95150339989513393890163683863648e-01 2.42710586669900529876997552491957e-01 6.06117060449665699672916474582962e-03
 	 4.25238442831057605886257988458965e-01 6.40551018216570233754225682787364e-02 5.10706455347285315227168212004472e-01 3.95916035300131977786586290335435e-03
 	 4.25238442831057605886257988458965e-01 5.10706455347285315227168212004472e-01 6.40551018216570233754225682787364e-02 3.95916035300131977786586290335435e-03
 	 6.40551018216570233754225682787364e-02 4.25238442831057605886257988458965e-01 5.10706455347285315227168212004472e-01 3.95916035300131977786586290335435e-03
 	 6.40551018216570233754225682787364e-02 5.10706455347285315227168212004472e-01 4.25238442831057605886257988458965e-01 3.95916035300131977786586290335435e-03
 	 5.10706455347285315227168212004472e-01 4.25238442831057605886257988458965e-01 6.40551018216570233754225682787364e-02 3.95916035300131977786586290335435e-03
 	 5.10706455347285315227168212004472e-01 6.40551018216570233754225682787364e-02 4.25238442831057605886257988458965e-01 3.95916035300131977786586290335435e-03
 	 3.64278126974187321795994876083569e-01 1.31876112324832255040529815914851e-02 6.22534261793329490863868613814702e-01 1.95153056148470219720303386878868e-03
 	 3.64278126974187321795994876083569e-01 6.22534261793329490863868613814702e-01 1.31876112324832255040529815914851e-02 1.95153056148470219720303386878868e-03
 	 1.31876112324832255040529815914851e-02 3.64278126974187321795994876083569e-01 6.22534261793329490863868613814702e-01 1.95153056148470219720303386878868e-03
 	 1.31876112324832255040529815914851e-02 6.22534261793329490863868613814702e-01 3.64278126974187321795994876083569e-01 1.95153056148470219720303386878868e-03
 	 6.22534261793329490863868613814702e-01 3.64278126974187321795994876083569e-01 1.31876112324832255040529815914851e-02 1.95153056148470219720303386878868e-03
 	 6.22534261793329490863868613814702e-01 1.31876112324832255040529815914851e-02 3.64278126974187321795994876083569e-01 1.95153056148470219720303386878868e-03
 	 1.77663726489636492056334304834309e-01 6.18730821070126515981435488811258e-02 7.60463191403350835528840434562881e-01 3.17586401957850117741544160310241e-03
 	 1.77663726489636492056334304834309e-01 7.60463191403350835528840434562881e-01 6.18730821070126515981435488811258e-02 3.17586401957850117741544160310241e-03
 	 6.18730821070126515981435488811258e-02 1.77663726489636492056334304834309e-01 7.60463191403350835528840434562881e-01 3.17586401957850117741544160310241e-03
 	 6.18730821070126515981435488811258e-02 7.60463191403350835528840434562881e-01 1.77663726489636492056334304834309e-01 3.17586401957850117741544160310241e-03
 	 7.60463191403350835528840434562881e-01 1.77663726489636492056334304834309e-01 6.18730821070126515981435488811258e-02 3.17586401957850117741544160310241e-03
 	 7.60463191403350835528840434562881e-01 6.18730821070126515981435488811258e-02 1.77663726489636492056334304834309e-01 3.17586401957850117741544160310241e-03
 	 5.88456479492050557600357763021748e-02 2.61247234276882700845789919696927e-03 9.38541879708026050010971630399581e-01 4.17768978402480455243417356570035e-04
 	 5.88456479492050557600357763021748e-02 9.38541879708026050010971630399581e-01 2.61247234276882700845789919696927e-03 4.17768978402480455243417356570035e-04
 	 2.61247234276882700845789919696927e-03 5.88456479492050557600357763021748e-02 9.38541879708026050010971630399581e-01 4.17768978402480455243417356570035e-04
 	 2.61247234276882700845789919696927e-03 9.38541879708026050010971630399581e-01 5.88456479492050557600357763021748e-02 4.17768978402480455243417356570035e-04
 	 9.38541879708026050010971630399581e-01 5.88456479492050557600357763021748e-02 2.61247234276882700845789919696927e-03 4.17768978402480455243417356570035e-04
 	 9.38541879708026050010971630399581e-01 2.61247234276882700845789919696927e-03 5.88456479492050557600357763021748e-02 4.17768978402480455243417356570035e-04
 	 2.50099601909829272194940585904988e-01 3.41904035600949715578700249807298e-02 7.15709994530075777063871100835968e-01 2.80379851300375073155923821843771e-03
 	 2.50099601909829272194940585904988e-01 7.15709994530075777063871100835968e-01 3.41904035600949715578700249807298e-02 2.80379851300375073155923821843771e-03
 	 3.41904035600949715578700249807298e-02 2.50099601909829272194940585904988e-01 7.15709994530075777063871100835968e-01 2.80379851300375073155923821843771e-03
 	 3.41904035600949715578700249807298e-02 7.15709994530075777063871100835968e-01 2.50099601909829272194940585904988e-01 2.80379851300375073155923821843771e-03
 	 7.15709994530075777063871100835968e-01 2.50099601909829272194940585904988e-01 3.41904035600949715578700249807298e-02 2.80379851300375073155923821843771e-03
 	 7.15709994530075777063871100835968e-01 3.41904035600949715578700249807298e-02 2.50099601909829272194940585904988e-01 2.80379851300375073155923821843771e-03
 	 3.19725865365346195723361688578734e-02 2.65083133054744551210246683581317e-03 9.65376582132917993028797809529351e-01 3.07432300124120007605438287257016e-04
 	 3.19725865365346195723361688578734e-02 9.65376582132917993028797809529351e-01 2.65083133054744551210246683581317e-03 3.07432300124120007605438287257016e-04
 	 2.65083133054744551210246683581317e-03 3.19725865365346195723361688578734e-02 9.65376582132917993028797809529351e-01 3.07432300124120007605438287257016e-04
 	 2.65083133054744551210246683581317e-03 9.65376582132917993028797809529351e-01 3.19725865365346195723361688578734e-02 3.07432300124120007605438287257016e-04
 	 9.65376582132917993028797809529351e-01 3.19725865365346195723361688578734e-02 2.65083133054744551210246683581317e-03 3.07432300124120007605438287257016e-04
 	 9.65376582132917993028797809529351e-01 2.65083133054744551210246683581317e-03 3.19725865365346195723361688578734e-02 3.07432300124120007605438287257016e-04
 	 2.41723961357679040240498125058366e-01 2.59156908972399966165078843971514e-03 7.55684469552596937980126767797628e-01 7.58047874515678488625824993363267e-04
 	 2.41723961357679040240498125058366e-01 7.55684469552596937980126767797628e-01 2.59156908972399966165078843971514e-03 7.58047874515678488625824993363267e-04
 	 2.59156908972399966165078843971514e-03 2.41723961357679040240498125058366e-01 7.55684469552596937980126767797628e-01 7.58047874515678488625824993363267e-04
 	 2.59156908972399966165078843971514e-03 7.55684469552596937980126767797628e-01 2.41723961357679040240498125058366e-01 7.58047874515678488625824993363267e-04
 	 7.55684469552596937980126767797628e-01 2.41723961357679040240498125058366e-01 2.59156908972399966165078843971514e-03 7.58047874515678488625824993363267e-04
 	 7.55684469552596937980126767797628e-01 2.59156908972399966165078843971514e-03 2.41723961357679040240498125058366e-01 7.58047874515678488625824993363267e-04
 	 1.84404707439201814844764726331050e-01 1.42733464909807362258620244688245e-02 8.01321946069817436786308917362476e-01 1.62856018719141864940780362047690e-03
 	 1.84404707439201814844764726331050e-01 8.01321946069817436786308917362476e-01 1.42733464909807362258620244688245e-02 1.62856018719141864940780362047690e-03
 	 1.42733464909807362258620244688245e-02 1.84404707439201814844764726331050e-01 8.01321946069817436786308917362476e-01 1.62856018719141864940780362047690e-03
 	 1.42733464909807362258620244688245e-02 8.01321946069817436786308917362476e-01 1.84404707439201814844764726331050e-01 1.62856018719141864940780362047690e-03
 	 8.01321946069817436786308917362476e-01 1.84404707439201814844764726331050e-01 1.42733464909807362258620244688245e-02 1.62856018719141864940780362047690e-03
 	 8.01321946069817436786308917362476e-01 1.42733464909807362258620244688245e-02 1.84404707439201814844764726331050e-01 1.62856018719141864940780362047690e-03
 	 6.12563890152719517367962964726757e-02 1.38564076854345488015729515041130e-02 9.24887203299293525482482891675318e-01 1.00158151513169563218141888683022e-03
 	 6.12563890152719517367962964726757e-02 9.24887203299293525482482891675318e-01 1.38564076854345488015729515041130e-02 1.00158151513169563218141888683022e-03
 	 1.38564076854345488015729515041130e-02 6.12563890152719517367962964726757e-02 9.24887203299293525482482891675318e-01 1.00158151513169563218141888683022e-03
 	 1.38564076854345488015729515041130e-02 9.24887203299293525482482891675318e-01 6.12563890152719517367962964726757e-02 1.00158151513169563218141888683022e-03
 	 9.24887203299293525482482891675318e-01 6.12563890152719517367962964726757e-02 1.38564076854345488015729515041130e-02 1.00158151513169563218141888683022e-03
 	 9.24887203299293525482482891675318e-01 1.38564076854345488015729515041130e-02 6.12563890152719517367962964726757e-02 1.00158151513169563218141888683022e-03
 	 1.32571416922718544884052249699380e-02 2.49382626599786065904607035292884e-03 9.84249032041730309572358237346634e-01 1.89703509221097088750795922607040e-04
 	 1.32571416922718544884052249699380e-02 9.84249032041730309572358237346634e-01 2.49382626599786065904607035292884e-03 1.89703509221097088750795922607040e-04
 	 2.49382626599786065904607035292884e-03 1.32571416922718544884052249699380e-02 9.84249032041730309572358237346634e-01 1.89703509221097088750795922607040e-04
 	 2.49382626599786065904607035292884e-03 9.84249032041730309572358237346634e-01 1.32571416922718544884052249699380e-02 1.89703509221097088750795922607040e-04
 	 9.84249032041730309572358237346634e-01 1.32571416922718544884052249699380e-02 2.49382626599786065904607035292884e-03 1.89703509221097088750795922607040e-04
 	 9.84249032041730309572358237346634e-01 2.49382626599786065904607035292884e-03 1.32571416922718544884052249699380e-02 1.89703509221097088750795922607040e-04
 	 1.37973140081455225569584399636369e-01 1.00440931058371943351836819147138e-01 7.61585928860172844956366589030949e-01 3.92259371882643179813010547718477e-03
 	 1.37973140081455225569584399636369e-01 7.61585928860172844956366589030949e-01 1.00440931058371943351836819147138e-01 3.92259371882643179813010547718477e-03
 	 1.00440931058371943351836819147138e-01 1.37973140081455225569584399636369e-01 7.61585928860172844956366589030949e-01 3.92259371882643179813010547718477e-03
 	 1.00440931058371943351836819147138e-01 7.61585928860172844956366589030949e-01 1.37973140081455225569584399636369e-01 3.92259371882643179813010547718477e-03
 	 7.61585928860172844956366589030949e-01 1.37973140081455225569584399636369e-01 1.00440931058371943351836819147138e-01 3.92259371882643179813010547718477e-03
 	 7.61585928860172844956366589030949e-01 1.00440931058371943351836819147138e-01 1.37973140081455225569584399636369e-01 3.92259371882643179813010547718477e-03
 	 3.32056799273112990267264876820263e-02 1.36974423527236825043340573415662e-02 9.53096877719965096531495873932727e-01 7.35264449071113533086541114158763e-04
 	 3.32056799273112990267264876820263e-02 9.53096877719965096531495873932727e-01 1.36974423527236825043340573415662e-02 7.35264449071113533086541114158763e-04
 	 1.36974423527236825043340573415662e-02 3.32056799273112990267264876820263e-02 9.53096877719965096531495873932727e-01 7.35264449071113533086541114158763e-04
 	 1.36974423527236825043340573415662e-02 9.53096877719965096531495873932727e-01 3.32056799273112990267264876820263e-02 7.35264449071113533086541114158763e-04
 	 9.53096877719965096531495873932727e-01 3.32056799273112990267264876820263e-02 1.36974423527236825043340573415662e-02 7.35264449071113533086541114158763e-04
 	 9.53096877719965096531495873932727e-01 1.36974423527236825043340573415662e-02 3.32056799273112990267264876820263e-02 7.35264449071113533086541114158763e-04
 	 1.94466196781106465119037807198765e-01 3.41431958895440298973333881349390e-02 7.71390607329349498044734900759067e-01 2.62775009826658832029488976900211e-03
 	 1.94466196781106465119037807198765e-01 7.71390607329349498044734900759067e-01 3.41431958895440298973333881349390e-02 2.62775009826658832029488976900211e-03
 	 3.41431958895440298973333881349390e-02 1.94466196781106465119037807198765e-01 7.71390607329349498044734900759067e-01 2.62775009826658832029488976900211e-03
 	 3.41431958895440298973333881349390e-02 7.71390607329349498044734900759067e-01 1.94466196781106465119037807198765e-01 2.62775009826658832029488976900211e-03
 	 7.71390607329349498044734900759067e-01 1.94466196781106465119037807198765e-01 3.41431958895440298973333881349390e-02 2.62775009826658832029488976900211e-03
 	 7.71390607329349498044734900759067e-01 3.41431958895440298973333881349390e-02 1.94466196781106465119037807198765e-01 2.62775009826658832029488976900211e-03
 	 2.39482635085204537128689139535709e-01 1.38046252946412654344365833480879e-02 7.46712739620154275499430696072523e-01 1.84163391902791308794851143915139e-03
 	 2.39482635085204537128689139535709e-01 7.46712739620154275499430696072523e-01 1.38046252946412654344365833480879e-02 1.84163391902791308794851143915139e-03
 	 1.38046252946412654344365833480879e-02 2.39482635085204537128689139535709e-01 7.46712739620154275499430696072523e-01 1.84163391902791308794851143915139e-03
 	 1.38046252946412654344365833480879e-02 7.46712739620154275499430696072523e-01 2.39482635085204537128689139535709e-01 1.84163391902791308794851143915139e-03
 	 7.46712739620154275499430696072523e-01 2.39482635085204537128689139535709e-01 1.38046252946412654344365833480879e-02 1.84163391902791308794851143915139e-03
 	 7.46712739620154275499430696072523e-01 1.38046252946412654344365833480879e-02 2.39482635085204537128689139535709e-01 1.84163391902791308794851143915139e-03
 	 3.64554227776340777911201485039783e-01 1.86497214299555097438698680889502e-01 4.48948557924104152405675449699629e-01 5.92503277267376199377579837346275e-03
 	 3.64554227776340777911201485039783e-01 4.48948557924104152405675449699629e-01 1.86497214299555097438698680889502e-01 5.92503277267376199377579837346275e-03
 	 1.86497214299555097438698680889502e-01 3.64554227776340777911201485039783e-01 4.48948557924104152405675449699629e-01 5.92503277267376199377579837346275e-03
 	 1.86497214299555097438698680889502e-01 4.48948557924104152405675449699629e-01 3.64554227776340777911201485039783e-01 5.92503277267376199377579837346275e-03
 	 4.48948557924104152405675449699629e-01 3.64554227776340777911201485039783e-01 1.86497214299555097438698680889502e-01 5.92503277267376199377579837346275e-03
 	 4.48948557924104152405675449699629e-01 1.86497214299555097438698680889502e-01 3.64554227776340777911201485039783e-01 5.92503277267376199377579837346275e-03
 	 1.37356402366199809028657341514190e-01 2.54175936468376819851733294797214e-03 8.60101838269116347746034989540931e-01 6.12338840814290403039010790564589e-04
 	 1.37356402366199809028657341514190e-01 8.60101838269116347746034989540931e-01 2.54175936468376819851733294797214e-03 6.12338840814290403039010790564589e-04
 	 2.54175936468376819851733294797214e-03 1.37356402366199809028657341514190e-01 8.60101838269116347746034989540931e-01 6.12338840814290403039010790564589e-04
 	 2.54175936468376819851733294797214e-03 8.60101838269116347746034989540931e-01 1.37356402366199809028657341514190e-01 6.12338840814290403039010790564589e-04
 	 8.60101838269116347746034989540931e-01 1.37356402366199809028657341514190e-01 2.54175936468376819851733294797214e-03 6.12338840814290403039010790564589e-04
 	 8.60101838269116347746034989540931e-01 2.54175936468376819851733294797214e-03 1.37356402366199809028657341514190e-01 6.12338840814290403039010790564589e-04
 	 2.32232037318890388588599194008566e-01 6.30349337046809815587877778852999e-02 7.04733028976428643730400835920591e-01 3.82496344847885888507121876500605e-03
 	 2.32232037318890388588599194008566e-01 7.04733028976428643730400835920591e-01 6.30349337046809815587877778852999e-02 3.82496344847885888507121876500605e-03
 	 6.30349337046809815587877778852999e-02 2.32232037318890388588599194008566e-01 7.04733028976428643730400835920591e-01 3.82496344847885888507121876500605e-03
 	 6.30349337046809815587877778852999e-02 7.04733028976428643730400835920591e-01 2.32232037318890388588599194008566e-01 3.82496344847885888507121876500605e-03
 	 7.04733028976428643730400835920591e-01 2.32232037318890388588599194008566e-01 6.30349337046809815587877778852999e-02 3.82496344847885888507121876500605e-03
 	 7.04733028976428643730400835920591e-01 6.30349337046809815587877778852999e-02 2.32232037318890388588599194008566e-01 3.82496344847885888507121876500605e-03
 	 2.92661395072246866000398313190090e-01 6.38769125793660075274260634614620e-02 6.43461692348387126472175623348448e-01 4.12830322220625756807210748888792e-03
 	 2.92661395072246866000398313190090e-01 6.43461692348387126472175623348448e-01 6.38769125793660075274260634614620e-02 4.12830322220625756807210748888792e-03
 	 6.38769125793660075274260634614620e-02 2.92661395072246866000398313190090e-01 6.43461692348387126472175623348448e-01 4.12830322220625756807210748888792e-03
 	 6.38769125793660075274260634614620e-02 6.43461692348387126472175623348448e-01 2.92661395072246866000398313190090e-01 4.12830322220625756807210748888792e-03
 	 6.43461692348387126472175623348448e-01 2.92661395072246866000398313190090e-01 6.38769125793660075274260634614620e-02 4.12830322220625756807210748888792e-03
 	 6.43461692348387126472175623348448e-01 6.38769125793660075274260634614620e-02 2.92661395072246866000398313190090e-01 4.12830322220625756807210748888792e-03
 	 3.17648116398156710182831830024952e-01 2.41952845175475161898503984048148e-01 4.40399038426368127918664185926900e-01 6.69203204174123166686483088483328e-03
 	 3.17648116398156710182831830024952e-01 4.40399038426368127918664185926900e-01 2.41952845175475161898503984048148e-01 6.69203204174123166686483088483328e-03
 	 2.41952845175475161898503984048148e-01 3.17648116398156710182831830024952e-01 4.40399038426368127918664185926900e-01 6.69203204174123166686483088483328e-03
 	 2.41952845175475161898503984048148e-01 4.40399038426368127918664185926900e-01 3.17648116398156710182831830024952e-01 6.69203204174123166686483088483328e-03
 	 4.40399038426368127918664185926900e-01 3.17648116398156710182831830024952e-01 2.41952845175475161898503984048148e-01 6.69203204174123166686483088483328e-03
 	 4.40399038426368127918664185926900e-01 2.41952845175475161898503984048148e-01 3.17648116398156710182831830024952e-01 6.69203204174123166686483088483328e-03
 	 3.00301596615778321197609557202668e-01 1.45992712589763495162342721300774e-02 6.85099132125245424695947349391645e-01 2.04728294739298100068936037132517e-03
 	 3.00301596615778321197609557202668e-01 6.85099132125245424695947349391645e-01 1.45992712589763495162342721300774e-02 2.04728294739298100068936037132517e-03
 	 1.45992712589763495162342721300774e-02 3.00301596615778321197609557202668e-01 6.85099132125245424695947349391645e-01 2.04728294739298100068936037132517e-03
 	 1.45992712589763495162342721300774e-02 6.85099132125245424695947349391645e-01 3.00301596615778321197609557202668e-01 2.04728294739298100068936037132517e-03
 	 6.85099132125245424695947349391645e-01 3.00301596615778321197609557202668e-01 1.45992712589763495162342721300774e-02 2.04728294739298100068936037132517e-03
 	 6.85099132125245424695947349391645e-01 1.45992712589763495162342721300774e-02 3.00301596615778321197609557202668e-01 2.04728294739298100068936037132517e-03
 	 3.00561353716810975011952677959925e-01 2.81811459692608715435491184564398e-03 6.96620531686262922654861995397368e-01 8.78015679165091030532186433532615e-04
 	 3.00561353716810975011952677959925e-01 6.96620531686262922654861995397368e-01 2.81811459692608715435491184564398e-03 8.78015679165091030532186433532615e-04
 	 2.81811459692608715435491184564398e-03 3.00561353716810975011952677959925e-01 6.96620531686262922654861995397368e-01 8.78015679165091030532186433532615e-04
 	 2.81811459692608715435491184564398e-03 6.96620531686262922654861995397368e-01 3.00561353716810975011952677959925e-01 8.78015679165091030532186433532615e-04
 	 6.96620531686262922654861995397368e-01 3.00561353716810975011952677959925e-01 2.81811459692608715435491184564398e-03 8.78015679165091030532186433532615e-04
 	 6.96620531686262922654861995397368e-01 2.81811459692608715435491184564398e-03 3.00561353716810975011952677959925e-01 8.78015679165091030532186433532615e-04
 	 6.05239793987312202361295021546539e-02 3.41344995593797426169935249617993e-02 9.05341521041889030207983068976318e-01 1.57778511854587836019114810426345e-03
 	 6.05239793987312202361295021546539e-02 9.05341521041889030207983068976318e-01 3.41344995593797426169935249617993e-02 1.57778511854587836019114810426345e-03
 	 3.41344995593797426169935249617993e-02 6.05239793987312202361295021546539e-02 9.05341521041889030207983068976318e-01 1.57778511854587836019114810426345e-03
 	 3.41344995593797426169935249617993e-02 9.05341521041889030207983068976318e-01 6.05239793987312202361295021546539e-02 1.57778511854587836019114810426345e-03
 	 9.05341521041889030207983068976318e-01 6.05239793987312202361295021546539e-02 3.41344995593797426169935249617993e-02 1.57778511854587836019114810426345e-03
 	 9.05341521041889030207983068976318e-01 3.41344995593797426169935249617993e-02 6.05239793987312202361295021546539e-02 1.57778511854587836019114810426345e-03
 	 3.00785919233889365020928607918904e-01 1.93355477276418330490059815929271e-01 5.05858603489692360000162807409652e-01 6.30743591098840809816561403522428e-03
 	 3.00785919233889365020928607918904e-01 5.05858603489692360000162807409652e-01 1.93355477276418330490059815929271e-01 6.30743591098840809816561403522428e-03
 	 1.93355477276418330490059815929271e-01 3.00785919233889365020928607918904e-01 5.05858603489692360000162807409652e-01 6.30743591098840809816561403522428e-03
 	 1.93355477276418330490059815929271e-01 5.05858603489692360000162807409652e-01 3.00785919233889365020928607918904e-01 6.30743591098840809816561403522428e-03
 	 5.05858603489692360000162807409652e-01 3.00785919233889365020928607918904e-01 1.93355477276418330490059815929271e-01 6.30743591098840809816561403522428e-03
 	 5.05858603489692360000162807409652e-01 1.93355477276418330490059815929271e-01 3.00785919233889365020928607918904e-01 6.30743591098840809816561403522428e-03
 	 1.89550703977685197632041536053293e-01 9.73629697501508795109970151315792e-02 7.13086326272163950612537064444041e-01 4.27263982105316811321849002069939e-03
 	 1.89550703977685197632041536053293e-01 7.13086326272163950612537064444041e-01 9.73629697501508795109970151315792e-02 4.27263982105316811321849002069939e-03
 	 9.73629697501508795109970151315792e-02 1.89550703977685197632041536053293e-01 7.13086326272163950612537064444041e-01 4.27263982105316811321849002069939e-03
 	 9.73629697501508795109970151315792e-02 7.13086326272163950612537064444041e-01 1.89550703977685197632041536053293e-01 4.27263982105316811321849002069939e-03
 	 7.13086326272163950612537064444041e-01 1.89550703977685197632041536053293e-01 9.73629697501508795109970151315792e-02 4.27263982105316811321849002069939e-03
 	 7.13086326272163950612537064444041e-01 9.73629697501508795109970151315792e-02 1.89550703977685197632041536053293e-01 4.27263982105316811321849002069939e-03
 	 4.30139903362148912080442642036360e-01 2.78830240511142692441670654091013e-03 5.67071794232739678776056280185003e-01 9.69837346239260113776869953738924e-04
 	 4.30139903362148912080442642036360e-01 5.67071794232739678776056280185003e-01 2.78830240511142692441670654091013e-03 9.69837346239260113776869953738924e-04
 	 2.78830240511142692441670654091013e-03 4.30139903362148912080442642036360e-01 5.67071794232739678776056280185003e-01 9.69837346239260113776869953738924e-04
 	 2.78830240511142692441670654091013e-03 5.67071794232739678776056280185003e-01 4.30139903362148912080442642036360e-01 9.69837346239260113776869953738924e-04
 	 5.67071794232739678776056280185003e-01 4.30139903362148912080442642036360e-01 2.78830240511142692441670654091013e-03 9.69837346239260113776869953738924e-04
 	 5.67071794232739678776056280185003e-01 2.78830240511142692441670654091013e-03 4.30139903362148912080442642036360e-01 9.69837346239260113776869953738924e-04
 	 1.87018572217664685863880436045292e-01 2.75596244648371960922483836498031e-03 8.10225465335851602333150367485359e-01 7.38018270457863143768628688690114e-04
 	 1.87018572217664685863880436045292e-01 8.10225465335851602333150367485359e-01 2.75596244648371960922483836498031e-03 7.38018270457863143768628688690114e-04
 	 2.75596244648371960922483836498031e-03 1.87018572217664685863880436045292e-01 8.10225465335851602333150367485359e-01 7.38018270457863143768628688690114e-04
 	 2.75596244648371960922483836498031e-03 8.10225465335851602333150367485359e-01 1.87018572217664685863880436045292e-01 7.38018270457863143768628688690114e-04
 	 8.10225465335851602333150367485359e-01 1.87018572217664685863880436045292e-01 2.75596244648371960922483836498031e-03 7.38018270457863143768628688690114e-04
 	 8.10225465335851602333150367485359e-01 2.75596244648371960922483836498031e-03 1.87018572217664685863880436045292e-01 7.38018270457863143768628688690114e-04
 	 3.79189522509007448380913274377235e-01 9.78271071588677626484908955717401e-02 5.22983370332124830603959253494395e-01 5.26188136012751932202302640462221e-03
 	 3.79189522509007448380913274377235e-01 5.22983370332124830603959253494395e-01 9.78271071588677626484908955717401e-02 5.26188136012751932202302640462221e-03
 	 9.78271071588677626484908955717401e-02 3.79189522509007448380913274377235e-01 5.22983370332124830603959253494395e-01 5.26188136012751932202302640462221e-03
 	 9.78271071588677626484908955717401e-02 5.22983370332124830603959253494395e-01 3.79189522509007448380913274377235e-01 5.26188136012751932202302640462221e-03
 	 5.22983370332124830603959253494395e-01 3.79189522509007448380913274377235e-01 9.78271071588677626484908955717401e-02 5.26188136012751932202302640462221e-03
 	 5.22983370332124830603959253494395e-01 9.78271071588677626484908955717401e-02 3.79189522509007448380913274377235e-01 5.26188136012751932202302640462221e-03
 	 3.12966976982159250653126036922913e-01 9.95736856368709677411743541597389e-02 5.87459337380969781605699608917348e-01 5.30027197499825276916229910284528e-03
 	 3.12966976982159250653126036922913e-01 5.87459337380969781605699608917348e-01 9.95736856368709677411743541597389e-02 5.30027197499825276916229910284528e-03
 	 9.95736856368709677411743541597389e-02 3.12966976982159250653126036922913e-01 5.87459337380969781605699608917348e-01 5.30027197499825276916229910284528e-03
 	 9.95736856368709677411743541597389e-02 5.87459337380969781605699608917348e-01 3.12966976982159250653126036922913e-01 5.30027197499825276916229910284528e-03
 	 5.87459337380969781605699608917348e-01 3.12966976982159250653126036922913e-01 9.95736856368709677411743541597389e-02 5.30027197499825276916229910284528e-03
 	 5.87459337380969781605699608917348e-01 9.95736856368709677411743541597389e-02 3.12966976982159250653126036922913e-01 5.30027197499825276916229910284528e-03
 	 1.41804487017288982642071459849831e-01 3.41143516662648707549188031862286e-02 8.24081161316446153541903640871169e-01 2.45580101027916995401478850169497e-03
 	 1.41804487017288982642071459849831e-01 8.24081161316446153541903640871169e-01 3.41143516662648707549188031862286e-02 2.45580101027916995401478850169497e-03
 	 3.41143516662648707549188031862286e-02 1.41804487017288982642071459849831e-01 8.24081161316446153541903640871169e-01 2.45580101027916995401478850169497e-03
 	 3.41143516662648707549188031862286e-02 8.24081161316446153541903640871169e-01 1.41804487017288982642071459849831e-01 2.45580101027916995401478850169497e-03
 	 8.24081161316446153541903640871169e-01 1.41804487017288982642071459849831e-01 3.41143516662648707549188031862286e-02 2.45580101027916995401478850169497e-03
 	 8.24081161316446153541903640871169e-01 3.41143516662648707549188031862286e-02 1.41804487017288982642071459849831e-01 2.45580101027916995401478850169497e-03
 	 2.48181460015588495338079155771993e-01 1.00497443272928421720280312001705e-01 6.51321096711483082941640532226302e-01 5.05561039515768553126440210121473e-03
 	 2.48181460015588495338079155771993e-01 6.51321096711483082941640532226302e-01 1.00497443272928421720280312001705e-01 5.05561039515768553126440210121473e-03
 	 1.00497443272928421720280312001705e-01 2.48181460015588495338079155771993e-01 6.51321096711483082941640532226302e-01 5.05561039515768553126440210121473e-03
 	 1.00497443272928421720280312001705e-01 6.51321096711483082941640532226302e-01 2.48181460015588495338079155771993e-01 5.05561039515768553126440210121473e-03
 	 6.51321096711483082941640532226302e-01 2.48181460015588495338079155771993e-01 1.00497443272928421720280312001705e-01 5.05561039515768553126440210121473e-03
 	 6.51321096711483082941640532226302e-01 1.00497443272928421720280312001705e-01 2.48181460015588495338079155771993e-01 5.05561039515768553126440210121473e-03
 	 3.58797835407998699785991902899696e-01 6.16738036965516905896222965566267e-02 5.79528360895449567991022377100307e-01 4.43419096913021202471805182199205e-03
 	 3.58797835407998699785991902899696e-01 5.79528360895449567991022377100307e-01 6.16738036965516905896222965566267e-02 4.43419096913021202471805182199205e-03
 	 6.16738036965516905896222965566267e-02 3.58797835407998699785991902899696e-01 5.79528360895449567991022377100307e-01 4.43419096913021202471805182199205e-03
 	 6.16738036965516905896222965566267e-02 5.79528360895449567991022377100307e-01 3.58797835407998699785991902899696e-01 4.43419096913021202471805182199205e-03
 	 5.79528360895449567991022377100307e-01 3.58797835407998699785991902899696e-01 6.16738036965516905896222965566267e-02 4.43419096913021202471805182199205e-03
 	 5.79528360895449567991022377100307e-01 6.16738036965516905896222965566267e-02 3.58797835407998699785991902899696e-01 4.43419096913021202471805182199205e-03
 	 ];
 
 	 case  44 

 	 % ALG. DEG.:   44
 	 % PTS CARD.:  354
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-15  

 	 xyw_bar=[
 	 1.71230757996369982974760315386220e-03 1.71230757996369982974760315386220e-03 9.96575384840072575620695261022775e-01 4.43040909141474614145288224431596e-05
 	 1.71230757996369982974760315386220e-03 9.96575384840072575620695261022775e-01 1.71230757996369982974760315386220e-03 4.43040909141474614145288224431596e-05
 	 9.96575384840072575620695261022775e-01 1.71230757996369982974760315386220e-03 1.71230757996369982974760315386220e-03 4.43040909141474614145288224431596e-05
 	 2.91673514653004867236418817810772e-02 2.91673514653004867236418817810772e-02 9.41665297069399054308291852066759e-01 1.12297738282371504896228753267451e-03
 	 2.91673514653004867236418817810772e-02 9.41665297069399054308291852066759e-01 2.91673514653004867236418817810772e-02 1.12297738282371504896228753267451e-03
 	 9.41665297069399054308291852066759e-01 2.91673514653004867236418817810772e-02 2.91673514653004867236418817810772e-02 1.12297738282371504896228753267451e-03
 	 4.95499879123024178362300062872237e-02 4.95499879123024178362300062872237e-02 9.00900024175395164327539987425553e-01 1.74515156553294481685256744896151e-03
 	 4.95499879123024178362300062872237e-02 9.00900024175395164327539987425553e-01 4.95499879123024178362300062872237e-02 1.74515156553294481685256744896151e-03
 	 9.00900024175395164327539987425553e-01 4.95499879123024178362300062872237e-02 4.95499879123024178362300062872237e-02 1.74515156553294481685256744896151e-03
 	 4.87723980583153360335302295425208e-01 4.87723980583153360335302295425208e-01 2.45520388336932793293954091495834e-02 2.72965271648993069997235494383858e-03
 	 4.87723980583153360335302295425208e-01 2.45520388336932793293954091495834e-02 4.87723980583153360335302295425208e-01 2.72965271648993069997235494383858e-03
 	 2.45520388336932793293954091495834e-02 4.87723980583153360335302295425208e-01 4.87723980583153360335302295425208e-01 2.72965271648993069997235494383858e-03
 	 4.96061804465474931458146556906286e-01 4.96061804465474931458146556906286e-01 7.87639106905013708370688618742861e-03 1.20450601341192320078987698650508e-03
 	 4.96061804465474931458146556906286e-01 7.87639106905013708370688618742861e-03 4.96061804465474931458146556906286e-01 1.20450601341192320078987698650508e-03
 	 7.87639106905013708370688618742861e-03 4.96061804465474931458146556906286e-01 4.96061804465474931458146556906286e-01 1.20450601341192320078987698650508e-03
 	 7.65961156051737368510856640568818e-02 7.65961156051737368510856640568818e-02 8.46807768789652470786677440628409e-01 2.36579331077924710433069144244200e-03
 	 7.65961156051737368510856640568818e-02 8.46807768789652470786677440628409e-01 7.65961156051737368510856640568818e-02 2.36579331077924710433069144244200e-03
 	 8.46807768789652470786677440628409e-01 7.65961156051737368510856640568818e-02 7.65961156051737368510856640568818e-02 2.36579331077924710433069144244200e-03
 	 4.75951846052771243567036663080216e-01 4.75951846052771243567036663080216e-01 4.80963078944575128659266738395672e-02 3.51119426834121083069728541659060e-03
 	 4.75951846052771243567036663080216e-01 4.80963078944575128659266738395672e-02 4.75951846052771243567036663080216e-01 3.51119426834121083069728541659060e-03
 	 4.80963078944575128659266738395672e-02 4.75951846052771243567036663080216e-01 4.75951846052771243567036663080216e-01 3.51119426834121083069728541659060e-03
 	 1.09095541957237654462353759754478e-01 1.09095541957237654462353759754478e-01 7.81808916085524718830868096119957e-01 2.94346804719577102849026317699099e-03
 	 1.09095541957237654462353759754478e-01 7.81808916085524718830868096119957e-01 1.09095541957237654462353759754478e-01 2.94346804719577102849026317699099e-03
 	 7.81808916085524718830868096119957e-01 1.09095541957237654462353759754478e-01 1.09095541957237654462353759754478e-01 2.94346804719577102849026317699099e-03
 	 2.31247003693840935678593950797222e-01 2.31247003693840935678593950797222e-01 5.37505992612318128642812098405557e-01 6.72324289847308752959831323892104e-03
 	 2.31247003693840935678593950797222e-01 5.37505992612318128642812098405557e-01 2.31247003693840935678593950797222e-01 6.72324289847308752959831323892104e-03
 	 5.37505992612318128642812098405557e-01 2.31247003693840935678593950797222e-01 2.31247003693840935678593950797222e-01 6.72324289847308752959831323892104e-03
 	 1.95908198223650492630909525360039e-01 1.95908198223650492630909525360039e-01 6.08183603552699070249332180537749e-01 4.97985881251891693288769147329731e-03
 	 1.95908198223650492630909525360039e-01 6.08183603552699070249332180537749e-01 1.95908198223650492630909525360039e-01 4.97985881251891693288769147329731e-03
 	 6.08183603552699070249332180537749e-01 1.95908198223650492630909525360039e-01 1.95908198223650492630909525360039e-01 4.97985881251891693288769147329731e-03
 	 4.22321808207151372371868092159275e-01 4.22321808207151372371868092159275e-01 1.55356383585697255256263815681450e-01 4.92083724524676382333643331890016e-03
 	 4.22321808207151372371868092159275e-01 1.55356383585697255256263815681450e-01 4.22321808207151372371868092159275e-01 4.92083724524676382333643331890016e-03
 	 1.55356383585697255256263815681450e-01 4.22321808207151372371868092159275e-01 4.22321808207151372371868092159275e-01 4.92083724524676382333643331890016e-03
 	 4.54881749959505921054869759245776e-01 4.54881749959505921054869759245776e-01 9.02365000809881578902604815084487e-02 5.02147502859759658350169431173526e-03
 	 4.54881749959505921054869759245776e-01 9.02365000809881578902604815084487e-02 4.54881749959505921054869759245776e-01 5.02147502859759658350169431173526e-03
 	 9.02365000809881578902604815084487e-02 4.54881749959505921054869759245776e-01 4.54881749959505921054869759245776e-01 5.02147502859759658350169431173526e-03
 	 1.43900119540420812214165380282793e-01 1.43900119540420812214165380282793e-01 7.12199760919158375571669239434414e-01 4.44659324076130801212114462828140e-03
 	 1.43900119540420812214165380282793e-01 7.12199760919158375571669239434414e-01 1.43900119540420812214165380282793e-01 4.44659324076130801212114462828140e-03
 	 7.12199760919158375571669239434414e-01 1.43900119540420812214165380282793e-01 1.43900119540420812214165380282793e-01 4.44659324076130801212114462828140e-03
 	 4.02340447854735383526048053681734e-01 4.02340447854735383526048053681734e-01 1.95319104290529232947903892636532e-01 4.64661276458439975040048963705885e-03
 	 4.02340447854735383526048053681734e-01 1.95319104290529232947903892636532e-01 4.02340447854735383526048053681734e-01 4.64661276458439975040048963705885e-03
 	 1.95319104290529232947903892636532e-01 4.02340447854735383526048053681734e-01 4.02340447854735383526048053681734e-01 4.64661276458439975040048963705885e-03
 	 2.94295765690833932559655750083039e-01 2.94295765690833932559655750083039e-01 4.11408468618332134880688499833923e-01 6.42547205017432194323889760312341e-03
 	 2.94295765690833932559655750083039e-01 4.11408468618332134880688499833923e-01 2.94295765690833932559655750083039e-01 6.42547205017432194323889760312341e-03
 	 4.11408468618332134880688499833923e-01 2.94295765690833932559655750083039e-01 2.94295765690833932559655750083039e-01 6.42547205017432194323889760312341e-03
 	 3.51615788795768935415253508836031e-01 3.51615788795768935415253508836031e-01 2.96768422408462129169492982327938e-01 6.26558788362682490130639578751470e-03
 	 3.51615788795768935415253508836031e-01 2.96768422408462129169492982327938e-01 3.51615788795768935415253508836031e-01 6.26558788362682490130639578751470e-03
 	 2.96768422408462129169492982327938e-01 3.51615788795768935415253508836031e-01 3.51615788795768935415253508836031e-01 6.26558788362682490130639578751470e-03
 	 1.97551676157197361738404595143948e-02 1.07567195566842938037055432687339e-02 9.69488112827595949205772285495186e-01 4.11975646436957645447896059209825e-04
 	 1.97551676157197361738404595143948e-02 9.69488112827595949205772285495186e-01 1.07567195566842938037055432687339e-02 4.11975646436957645447896059209825e-04
 	 1.07567195566842938037055432687339e-02 1.97551676157197361738404595143948e-02 9.69488112827595949205772285495186e-01 4.11975646436957645447896059209825e-04
 	 1.07567195566842938037055432687339e-02 9.69488112827595949205772285495186e-01 1.97551676157197361738404595143948e-02 4.11975646436957645447896059209825e-04
 	 9.69488112827595949205772285495186e-01 1.97551676157197361738404595143948e-02 1.07567195566842938037055432687339e-02 4.11975646436957645447896059209825e-04
 	 9.69488112827595949205772285495186e-01 1.07567195566842938037055432687339e-02 1.97551676157197361738404595143948e-02 4.11975646436957645447896059209825e-04
 	 9.95165813818446182148491629959608e-02 7.80585899861933429737248513191616e-04 8.99702832718293432634482087451033e-01 2.73240846003681883257668827624798e-04
 	 9.95165813818446182148491629959608e-02 8.99702832718293432634482087451033e-01 7.80585899861933429737248513191616e-04 2.73240846003681883257668827624798e-04
 	 7.80585899861933429737248513191616e-04 9.95165813818446182148491629959608e-02 8.99702832718293432634482087451033e-01 2.73240846003681883257668827624798e-04
 	 7.80585899861933429737248513191616e-04 8.99702832718293432634482087451033e-01 9.95165813818446182148491629959608e-02 2.73240846003681883257668827624798e-04
 	 8.99702832718293432634482087451033e-01 9.95165813818446182148491629959608e-02 7.80585899861933429737248513191616e-04 2.73240846003681883257668827624798e-04
 	 8.99702832718293432634482087451033e-01 7.80585899861933429737248513191616e-04 9.95165813818446182148491629959608e-02 2.73240846003681883257668827624798e-04
 	 1.53494544755213874198673806859006e-01 1.93833291279059036736620580398949e-03 8.44567122331995601136611639958574e-01 5.39328443929896692021763726643258e-04
 	 1.53494544755213874198673806859006e-01 8.44567122331995601136611639958574e-01 1.93833291279059036736620580398949e-03 5.39328443929896692021763726643258e-04
 	 1.93833291279059036736620580398949e-03 1.53494544755213874198673806859006e-01 8.44567122331995601136611639958574e-01 5.39328443929896692021763726643258e-04
 	 1.93833291279059036736620580398949e-03 8.44567122331995601136611639958574e-01 1.53494544755213874198673806859006e-01 5.39328443929896692021763726643258e-04
 	 8.44567122331995601136611639958574e-01 1.53494544755213874198673806859006e-01 1.93833291279059036736620580398949e-03 5.39328443929896692021763726643258e-04
 	 8.44567122331995601136611639958574e-01 1.93833291279059036736620580398949e-03 1.53494544755213874198673806859006e-01 5.39328443929896692021763726643258e-04
 	 4.60607452003998885103897009685170e-01 1.78614248052541058943420981819372e-03 5.37606405515475671563763171434402e-01 6.70978970582038159939375354667845e-04
 	 4.60607452003998885103897009685170e-01 5.37606405515475671563763171434402e-01 1.78614248052541058943420981819372e-03 6.70978970582038159939375354667845e-04
 	 1.78614248052541058943420981819372e-03 4.60607452003998885103897009685170e-01 5.37606405515475671563763171434402e-01 6.70978970582038159939375354667845e-04
 	 1.78614248052541058943420981819372e-03 5.37606405515475671563763171434402e-01 4.60607452003998885103897009685170e-01 6.70978970582038159939375354667845e-04
 	 5.37606405515475671563763171434402e-01 4.60607452003998885103897009685170e-01 1.78614248052541058943420981819372e-03 6.70978970582038159939375354667845e-04
 	 5.37606405515475671563763171434402e-01 1.78614248052541058943420981819372e-03 4.60607452003998885103897009685170e-01 6.70978970582038159939375354667845e-04
 	 2.96420604264443915409898977486591e-02 1.75422517105275517501628002037251e-03 9.68603714402502924407656337280059e-01 2.25931536113939824671897893537675e-04
 	 2.96420604264443915409898977486591e-02 9.68603714402502924407656337280059e-01 1.75422517105275517501628002037251e-03 2.25931536113939824671897893537675e-04
 	 1.75422517105275517501628002037251e-03 2.96420604264443915409898977486591e-02 9.68603714402502924407656337280059e-01 2.25931536113939824671897893537675e-04
 	 1.75422517105275517501628002037251e-03 9.68603714402502924407656337280059e-01 2.96420604264443915409898977486591e-02 2.25931536113939824671897893537675e-04
 	 9.68603714402502924407656337280059e-01 2.96420604264443915409898977486591e-02 1.75422517105275517501628002037251e-03 2.25931536113939824671897893537675e-04
 	 9.68603714402502924407656337280059e-01 1.75422517105275517501628002037251e-03 2.96420604264443915409898977486591e-02 2.25931536113939824671897893537675e-04
 	 3.33840624824811804671753634465858e-01 5.17294259660069986710151379583067e-04 6.65642080915528122631030782940798e-01 3.22066309418337390173270318172172e-04
 	 3.33840624824811804671753634465858e-01 6.65642080915528122631030782940798e-01 5.17294259660069986710151379583067e-04 3.22066309418337390173270318172172e-04
 	 5.17294259660069986710151379583067e-04 3.33840624824811804671753634465858e-01 6.65642080915528122631030782940798e-01 3.22066309418337390173270318172172e-04
 	 5.17294259660069986710151379583067e-04 6.65642080915528122631030782940798e-01 3.33840624824811804671753634465858e-01 3.22066309418337390173270318172172e-04
 	 6.65642080915528122631030782940798e-01 3.33840624824811804671753634465858e-01 5.17294259660069986710151379583067e-04 3.22066309418337390173270318172172e-04
 	 6.65642080915528122631030782940798e-01 5.17294259660069986710151379583067e-04 3.33840624824811804671753634465858e-01 3.22066309418337390173270318172172e-04
 	 1.19426687227411967850976282079500e-01 7.54587092570611038533368031266946e-03 8.73027441846881857578921426465968e-01 9.67767302795132519990795039177556e-04
 	 1.19426687227411967850976282079500e-01 8.73027441846881857578921426465968e-01 7.54587092570611038533368031266946e-03 9.67767302795132519990795039177556e-04
 	 7.54587092570611038533368031266946e-03 1.19426687227411967850976282079500e-01 8.73027441846881857578921426465968e-01 9.67767302795132519990795039177556e-04
 	 7.54587092570611038533368031266946e-03 8.73027441846881857578921426465968e-01 1.19426687227411967850976282079500e-01 9.67767302795132519990795039177556e-04
 	 8.73027441846881857578921426465968e-01 1.19426687227411967850976282079500e-01 7.54587092570611038533368031266946e-03 9.67767302795132519990795039177556e-04
 	 8.73027441846881857578921426465968e-01 7.54587092570611038533368031266946e-03 1.19426687227411967850976282079500e-01 9.67767302795132519990795039177556e-04
 	 1.73311806699428916367367037310032e-01 1.14925464528052804352720173142188e-02 8.15195646847765797993190517445328e-01 1.34666489218176034861618184379495e-03
 	 1.73311806699428916367367037310032e-01 8.15195646847765797993190517445328e-01 1.14925464528052804352720173142188e-02 1.34666489218176034861618184379495e-03
 	 1.14925464528052804352720173142188e-02 1.73311806699428916367367037310032e-01 8.15195646847765797993190517445328e-01 1.34666489218176034861618184379495e-03
 	 1.14925464528052804352720173142188e-02 8.15195646847765797993190517445328e-01 1.73311806699428916367367037310032e-01 1.34666489218176034861618184379495e-03
 	 8.15195646847765797993190517445328e-01 1.73311806699428916367367037310032e-01 1.14925464528052804352720173142188e-02 1.34666489218176034861618184379495e-03
 	 8.15195646847765797993190517445328e-01 1.14925464528052804352720173142188e-02 1.73311806699428916367367037310032e-01 1.34666489218176034861618184379495e-03
 	 5.93978633857566162834729084352148e-02 2.42629677211045335916139720211504e-02 9.16339168893138822369337503914721e-01 1.33750828398123441757838758547905e-03
 	 5.93978633857566162834729084352148e-02 9.16339168893138822369337503914721e-01 2.42629677211045335916139720211504e-02 1.33750828398123441757838758547905e-03
 	 2.42629677211045335916139720211504e-02 5.93978633857566162834729084352148e-02 9.16339168893138822369337503914721e-01 1.33750828398123441757838758547905e-03
 	 2.42629677211045335916139720211504e-02 9.16339168893138822369337503914721e-01 5.93978633857566162834729084352148e-02 1.33750828398123441757838758547905e-03
 	 9.16339168893138822369337503914721e-01 5.93978633857566162834729084352148e-02 2.42629677211045335916139720211504e-02 1.33750828398123441757838758547905e-03
 	 9.16339168893138822369337503914721e-01 2.42629677211045335916139720211504e-02 5.93978633857566162834729084352148e-02 1.33750828398123441757838758547905e-03
 	 2.59446164627843145478180986174266e-01 9.79769330245964208125908356805667e-03 7.30756142069697189889154742559185e-01 1.20942803668823081753025405760127e-03
 	 2.59446164627843145478180986174266e-01 7.30756142069697189889154742559185e-01 9.79769330245964208125908356805667e-03 1.20942803668823081753025405760127e-03
 	 9.79769330245964208125908356805667e-03 2.59446164627843145478180986174266e-01 7.30756142069697189889154742559185e-01 1.20942803668823081753025405760127e-03
 	 9.79769330245964208125908356805667e-03 7.30756142069697189889154742559185e-01 2.59446164627843145478180986174266e-01 1.20942803668823081753025405760127e-03
 	 7.30756142069697189889154742559185e-01 2.59446164627843145478180986174266e-01 9.79769330245964208125908356805667e-03 1.20942803668823081753025405760127e-03
 	 7.30756142069697189889154742559185e-01 9.79769330245964208125908356805667e-03 2.59446164627843145478180986174266e-01 1.20942803668823081753025405760127e-03
 	 2.69664879531117784861038444432779e-01 1.89915082820833660409709509053755e-03 7.28435969640673808278563683415996e-01 5.97376141761882446280795821991205e-04
 	 2.69664879531117784861038444432779e-01 7.28435969640673808278563683415996e-01 1.89915082820833660409709509053755e-03 5.97376141761882446280795821991205e-04
 	 1.89915082820833660409709509053755e-03 2.69664879531117784861038444432779e-01 7.28435969640673808278563683415996e-01 5.97376141761882446280795821991205e-04
 	 1.89915082820833660409709509053755e-03 7.28435969640673808278563683415996e-01 2.69664879531117784861038444432779e-01 5.97376141761882446280795821991205e-04
 	 7.28435969640673808278563683415996e-01 2.69664879531117784861038444432779e-01 1.89915082820833660409709509053755e-03 5.97376141761882446280795821991205e-04
 	 7.28435969640673808278563683415996e-01 1.89915082820833660409709509053755e-03 2.69664879531117784861038444432779e-01 5.97376141761882446280795821991205e-04
 	 3.23428410410956435061535785280284e-01 7.67467985614434661245653046535153e-03 6.68896909732899280776052819419419e-01 1.46820106373356956165621145515843e-03
 	 3.23428410410956435061535785280284e-01 6.68896909732899280776052819419419e-01 7.67467985614434661245653046535153e-03 1.46820106373356956165621145515843e-03
 	 7.67467985614434661245653046535153e-03 3.23428410410956435061535785280284e-01 6.68896909732899280776052819419419e-01 1.46820106373356956165621145515843e-03
 	 7.67467985614434661245653046535153e-03 6.68896909732899280776052819419419e-01 3.23428410410956435061535785280284e-01 1.46820106373356956165621145515843e-03
 	 6.68896909732899280776052819419419e-01 3.23428410410956435061535785280284e-01 7.67467985614434661245653046535153e-03 1.46820106373356956165621145515843e-03
 	 6.68896909732899280776052819419419e-01 7.67467985614434661245653046535153e-03 3.23428410410956435061535785280284e-01 1.46820106373356956165621145515843e-03
 	 2.09397609435192477711495939729502e-01 2.70720430776859224270003423384878e-03 7.87895186257038915300654480233788e-01 8.01054485201240667503752579392540e-04
 	 2.09397609435192477711495939729502e-01 7.87895186257038915300654480233788e-01 2.70720430776859224270003423384878e-03 8.01054485201240667503752579392540e-04
 	 2.70720430776859224270003423384878e-03 2.09397609435192477711495939729502e-01 7.87895186257038915300654480233788e-01 8.01054485201240667503752579392540e-04
 	 2.70720430776859224270003423384878e-03 7.87895186257038915300654480233788e-01 2.09397609435192477711495939729502e-01 8.01054485201240667503752579392540e-04
 	 7.87895186257038915300654480233788e-01 2.09397609435192477711495939729502e-01 2.70720430776859224270003423384878e-03 8.01054485201240667503752579392540e-04
 	 7.87895186257038915300654480233788e-01 2.70720430776859224270003423384878e-03 2.09397609435192477711495939729502e-01 8.01054485201240667503752579392540e-04
 	 1.07937373867395408622016361732676e-02 2.70639655716989335765276791789802e-03 9.86499866056090635169084634981118e-01 1.85567042337732529631161293437458e-04
 	 1.07937373867395408622016361732676e-02 9.86499866056090635169084634981118e-01 2.70639655716989335765276791789802e-03 1.85567042337732529631161293437458e-04
 	 2.70639655716989335765276791789802e-03 1.07937373867395408622016361732676e-02 9.86499866056090635169084634981118e-01 1.85567042337732529631161293437458e-04
 	 2.70639655716989335765276791789802e-03 9.86499866056090635169084634981118e-01 1.07937373867395408622016361732676e-02 1.85567042337732529631161293437458e-04
 	 9.86499866056090635169084634981118e-01 1.07937373867395408622016361732676e-02 2.70639655716989335765276791789802e-03 1.85567042337732529631161293437458e-04
 	 9.86499866056090635169084634981118e-01 2.70639655716989335765276791789802e-03 1.07937373867395408622016361732676e-02 1.85567042337732529631161293437458e-04
 	 4.16577600266789249694454611017136e-02 1.04627340296394866214768626377918e-02 9.47879505943681532897926445002668e-01 7.21422026426122458588052754890896e-04
 	 4.16577600266789249694454611017136e-02 9.47879505943681532897926445002668e-01 1.04627340296394866214768626377918e-02 7.21422026426122458588052754890896e-04
 	 1.04627340296394866214768626377918e-02 4.16577600266789249694454611017136e-02 9.47879505943681532897926445002668e-01 7.21422026426122458588052754890896e-04
 	 1.04627340296394866214768626377918e-02 9.47879505943681532897926445002668e-01 4.16577600266789249694454611017136e-02 7.21422026426122458588052754890896e-04
 	 9.47879505943681532897926445002668e-01 4.16577600266789249694454611017136e-02 1.04627340296394866214768626377918e-02 7.21422026426122458588052754890896e-04
 	 9.47879505943681532897926445002668e-01 1.04627340296394866214768626377918e-02 4.16577600266789249694454611017136e-02 7.21422026426122458588052754890896e-04
 	 1.39300774418482237182459471114271e-01 2.15128602849198879987113741663052e-02 8.39186365296597847063253539090510e-01 1.53216672404742786962883460688545e-03
 	 1.39300774418482237182459471114271e-01 8.39186365296597847063253539090510e-01 2.15128602849198879987113741663052e-02 1.53216672404742786962883460688545e-03
 	 2.15128602849198879987113741663052e-02 1.39300774418482237182459471114271e-01 8.39186365296597847063253539090510e-01 1.53216672404742786962883460688545e-03
 	 2.15128602849198879987113741663052e-02 8.39186365296597847063253539090510e-01 1.39300774418482237182459471114271e-01 1.53216672404742786962883460688545e-03
 	 8.39186365296597847063253539090510e-01 1.39300774418482237182459471114271e-01 2.15128602849198879987113741663052e-02 1.53216672404742786962883460688545e-03
 	 8.39186365296597847063253539090510e-01 2.15128602849198879987113741663052e-02 1.39300774418482237182459471114271e-01 1.53216672404742786962883460688545e-03
 	 9.71407574555290531659323960411712e-02 2.28245356349519729066699369468552e-02 8.80034706909518904538458627939690e-01 1.50902662042829349350880896452054e-03
 	 9.71407574555290531659323960411712e-02 8.80034706909518904538458627939690e-01 2.28245356349519729066699369468552e-02 1.50902662042829349350880896452054e-03
 	 2.28245356349519729066699369468552e-02 9.71407574555290531659323960411712e-02 8.80034706909518904538458627939690e-01 1.50902662042829349350880896452054e-03
 	 2.28245356349519729066699369468552e-02 8.80034706909518904538458627939690e-01 9.71407574555290531659323960411712e-02 1.50902662042829349350880896452054e-03
 	 8.80034706909518904538458627939690e-01 9.71407574555290531659323960411712e-02 2.28245356349519729066699369468552e-02 1.50902662042829349350880896452054e-03
 	 8.80034706909518904538458627939690e-01 2.28245356349519729066699369468552e-02 9.71407574555290531659323960411712e-02 1.50902662042829349350880896452054e-03
 	 1.51124809738970578010253120737616e-01 1.00088530304790021552285850248154e-01 7.48786659956239386559673221199773e-01 3.40172247294901397215993732459083e-03
 	 1.51124809738970578010253120737616e-01 7.48786659956239386559673221199773e-01 1.00088530304790021552285850248154e-01 3.40172247294901397215993732459083e-03
 	 1.00088530304790021552285850248154e-01 1.51124809738970578010253120737616e-01 7.48786659956239386559673221199773e-01 3.40172247294901397215993732459083e-03
 	 1.00088530304790021552285850248154e-01 7.48786659956239386559673221199773e-01 1.51124809738970578010253120737616e-01 3.40172247294901397215993732459083e-03
 	 7.48786659956239386559673221199773e-01 1.51124809738970578010253120737616e-01 1.00088530304790021552285850248154e-01 3.40172247294901397215993732459083e-03
 	 7.48786659956239386559673221199773e-01 1.00088530304790021552285850248154e-01 1.51124809738970578010253120737616e-01 3.40172247294901397215993732459083e-03
 	 3.93932395535154467047789239586564e-01 3.15956953663550782485103241015167e-03 6.02908034928209990432890208467143e-01 1.03598816380638496237320822501715e-03
 	 3.93932395535154467047789239586564e-01 6.02908034928209990432890208467143e-01 3.15956953663550782485103241015167e-03 1.03598816380638496237320822501715e-03
 	 3.15956953663550782485103241015167e-03 3.93932395535154467047789239586564e-01 6.02908034928209990432890208467143e-01 1.03598816380638496237320822501715e-03
 	 3.15956953663550782485103241015167e-03 6.02908034928209990432890208467143e-01 3.93932395535154467047789239586564e-01 1.03598816380638496237320822501715e-03
 	 6.02908034928209990432890208467143e-01 3.93932395535154467047789239586564e-01 3.15956953663550782485103241015167e-03 1.03598816380638496237320822501715e-03
 	 6.02908034928209990432890208467143e-01 3.15956953663550782485103241015167e-03 3.93932395535154467047789239586564e-01 1.03598816380638496237320822501715e-03
 	 1.27637459417324766741685948545637e-01 4.35675752808351648970308644948091e-02 8.28794965301840047544601475237869e-01 2.37748769277986013101489071175365e-03
 	 1.27637459417324766741685948545637e-01 8.28794965301840047544601475237869e-01 4.35675752808351648970308644948091e-02 2.37748769277986013101489071175365e-03
 	 4.35675752808351648970308644948091e-02 1.27637459417324766741685948545637e-01 8.28794965301840047544601475237869e-01 2.37748769277986013101489071175365e-03
 	 4.35675752808351648970308644948091e-02 8.28794965301840047544601475237869e-01 1.27637459417324766741685948545637e-01 2.37748769277986013101489071175365e-03
 	 8.28794965301840047544601475237869e-01 1.27637459417324766741685948545637e-01 4.35675752808351648970308644948091e-02 2.37748769277986013101489071175365e-03
 	 8.28794965301840047544601475237869e-01 4.35675752808351648970308644948091e-02 1.27637459417324766741685948545637e-01 2.37748769277986013101489071175365e-03
 	 2.15342785917052303990004702427541e-01 6.28153762458395631407270798263198e-02 7.21841837837108202258207256818423e-01 3.39539123418467489803895809075129e-03
 	 2.15342785917052303990004702427541e-01 7.21841837837108202258207256818423e-01 6.28153762458395631407270798263198e-02 3.39539123418467489803895809075129e-03
 	 6.28153762458395631407270798263198e-02 2.15342785917052303990004702427541e-01 7.21841837837108202258207256818423e-01 3.39539123418467489803895809075129e-03
 	 6.28153762458395631407270798263198e-02 7.21841837837108202258207256818423e-01 2.15342785917052303990004702427541e-01 3.39539123418467489803895809075129e-03
 	 7.21841837837108202258207256818423e-01 2.15342785917052303990004702427541e-01 6.28153762458395631407270798263198e-02 3.39539123418467489803895809075129e-03
 	 7.21841837837108202258207256818423e-01 6.28153762458395631407270798263198e-02 2.15342785917052303990004702427541e-01 3.39539123418467489803895809075129e-03
 	 1.80523887256028525705175979965134e-01 3.46911866169311577934308843396138e-02 7.84784926127040316501393135695253e-01 2.70408838248181781008239177310770e-03
 	 1.80523887256028525705175979965134e-01 7.84784926127040316501393135695253e-01 3.46911866169311577934308843396138e-02 2.70408838248181781008239177310770e-03
 	 3.46911866169311577934308843396138e-02 1.80523887256028525705175979965134e-01 7.84784926127040316501393135695253e-01 2.70408838248181781008239177310770e-03
 	 3.46911866169311577934308843396138e-02 7.84784926127040316501393135695253e-01 1.80523887256028525705175979965134e-01 2.70408838248181781008239177310770e-03
 	 7.84784926127040316501393135695253e-01 1.80523887256028525705175979965134e-01 3.46911866169311577934308843396138e-02 2.70408838248181781008239177310770e-03
 	 7.84784926127040316501393135695253e-01 3.46911866169311577934308843396138e-02 1.80523887256028525705175979965134e-01 2.70408838248181781008239177310770e-03
 	 3.70697478749728304148192137290607e-01 1.59521357680311760829372502712431e-02 6.13350385482240412216015101876110e-01 2.01700339029128742143748276305359e-03
 	 3.70697478749728304148192137290607e-01 6.13350385482240412216015101876110e-01 1.59521357680311760829372502712431e-02 2.01700339029128742143748276305359e-03
 	 1.59521357680311760829372502712431e-02 3.70697478749728304148192137290607e-01 6.13350385482240412216015101876110e-01 2.01700339029128742143748276305359e-03
 	 1.59521357680311760829372502712431e-02 6.13350385482240412216015101876110e-01 3.70697478749728304148192137290607e-01 2.01700339029128742143748276305359e-03
 	 6.13350385482240412216015101876110e-01 3.70697478749728304148192137290607e-01 1.59521357680311760829372502712431e-02 2.01700339029128742143748276305359e-03
 	 6.13350385482240412216015101876110e-01 1.59521357680311760829372502712431e-02 3.70697478749728304148192137290607e-01 2.01700339029128742143748276305359e-03
 	 2.38904346634593867104712217042106e-01 3.65656909809639746322673659051361e-02 7.24529962384442116629656993609387e-01 2.79188113242576823117002682295151e-03
 	 2.38904346634593867104712217042106e-01 7.24529962384442116629656993609387e-01 3.65656909809639746322673659051361e-02 2.79188113242576823117002682295151e-03
 	 3.65656909809639746322673659051361e-02 2.38904346634593867104712217042106e-01 7.24529962384442116629656993609387e-01 2.79188113242576823117002682295151e-03
 	 3.65656909809639746322673659051361e-02 7.24529962384442116629656993609387e-01 2.38904346634593867104712217042106e-01 2.79188113242576823117002682295151e-03
 	 7.24529962384442116629656993609387e-01 2.38904346634593867104712217042106e-01 3.65656909809639746322673659051361e-02 2.79188113242576823117002682295151e-03
 	 7.24529962384442116629656993609387e-01 3.65656909809639746322673659051361e-02 2.38904346634593867104712217042106e-01 2.79188113242576823117002682295151e-03
 	 4.03544504764916933670093612818164e-01 1.22867248406971205088034082564263e-01 4.73588246828111902875235728060943e-01 4.30045886573049256085266023319491e-03
 	 4.03544504764916933670093612818164e-01 4.73588246828111902875235728060943e-01 1.22867248406971205088034082564263e-01 4.30045886573049256085266023319491e-03
 	 1.22867248406971205088034082564263e-01 4.03544504764916933670093612818164e-01 4.73588246828111902875235728060943e-01 4.30045886573049256085266023319491e-03
 	 1.22867248406971205088034082564263e-01 4.73588246828111902875235728060943e-01 4.03544504764916933670093612818164e-01 4.30045886573049256085266023319491e-03
 	 4.73588246828111902875235728060943e-01 4.03544504764916933670093612818164e-01 1.22867248406971205088034082564263e-01 4.30045886573049256085266023319491e-03
 	 4.73588246828111902875235728060943e-01 1.22867248406971205088034082564263e-01 4.03544504764916933670093612818164e-01 4.30045886573049256085266023319491e-03
 	 2.51088618401061669516138863400556e-01 1.22061192033510804155760354205995e-01 6.26850189565427484694737358950078e-01 4.98385652919375657377010213622270e-03
 	 2.51088618401061669516138863400556e-01 6.26850189565427484694737358950078e-01 1.22061192033510804155760354205995e-01 4.98385652919375657377010213622270e-03
 	 1.22061192033510804155760354205995e-01 2.51088618401061669516138863400556e-01 6.26850189565427484694737358950078e-01 4.98385652919375657377010213622270e-03
 	 1.22061192033510804155760354205995e-01 6.26850189565427484694737358950078e-01 2.51088618401061669516138863400556e-01 4.98385652919375657377010213622270e-03
 	 6.26850189565427484694737358950078e-01 2.51088618401061669516138863400556e-01 1.22061192033510804155760354205995e-01 4.98385652919375657377010213622270e-03
 	 6.26850189565427484694737358950078e-01 1.22061192033510804155760354205995e-01 2.51088618401061669516138863400556e-01 4.98385652919375657377010213622270e-03
 	 3.10092460353001919681759090963169e-01 8.78278870328067923223258617326792e-02 6.02079652614191274118127239489695e-01 4.65329627566698610791062762359616e-03
 	 3.10092460353001919681759090963169e-01 6.02079652614191274118127239489695e-01 8.78278870328067923223258617326792e-02 4.65329627566698610791062762359616e-03
 	 8.78278870328067923223258617326792e-02 3.10092460353001919681759090963169e-01 6.02079652614191274118127239489695e-01 4.65329627566698610791062762359616e-03
 	 8.78278870328067923223258617326792e-02 6.02079652614191274118127239489695e-01 3.10092460353001919681759090963169e-01 4.65329627566698610791062762359616e-03
 	 6.02079652614191274118127239489695e-01 3.10092460353001919681759090963169e-01 8.78278870328067923223258617326792e-02 4.65329627566698610791062762359616e-03
 	 6.02079652614191274118127239489695e-01 8.78278870328067923223258617326792e-02 3.10092460353001919681759090963169e-01 4.65329627566698610791062762359616e-03
 	 4.17188937068111109773838052205974e-01 6.56811030561964964702426073017705e-02 5.17129959875692435389282763935626e-01 4.12787604225650119060819775995697e-03
 	 4.17188937068111109773838052205974e-01 5.17129959875692435389282763935626e-01 6.56811030561964964702426073017705e-02 4.12787604225650119060819775995697e-03
 	 6.56811030561964964702426073017705e-02 4.17188937068111109773838052205974e-01 5.17129959875692435389282763935626e-01 4.12787604225650119060819775995697e-03
 	 6.56811030561964964702426073017705e-02 5.17129959875692435389282763935626e-01 4.17188937068111109773838052205974e-01 4.12787604225650119060819775995697e-03
 	 5.17129959875692435389282763935626e-01 4.17188937068111109773838052205974e-01 6.56811030561964964702426073017705e-02 4.12787604225650119060819775995697e-03
 	 5.17129959875692435389282763935626e-01 6.56811030561964964702426073017705e-02 4.17188937068111109773838052205974e-01 4.12787604225650119060819775995697e-03
 	 8.42771975158688041451782169133367e-02 4.57201471848305632250664132243401e-02 8.70002655299300653446437081584008e-01 2.05782176235249063961374460518527e-03
 	 8.42771975158688041451782169133367e-02 8.70002655299300653446437081584008e-01 4.57201471848305632250664132243401e-02 2.05782176235249063961374460518527e-03
 	 4.57201471848305632250664132243401e-02 8.42771975158688041451782169133367e-02 8.70002655299300653446437081584008e-01 2.05782176235249063961374460518527e-03
 	 4.57201471848305632250664132243401e-02 8.70002655299300653446437081584008e-01 8.42771975158688041451782169133367e-02 2.05782176235249063961374460518527e-03
 	 8.70002655299300653446437081584008e-01 8.42771975158688041451782169133367e-02 4.57201471848305632250664132243401e-02 2.05782176235249063961374460518527e-03
 	 8.70002655299300653446437081584008e-01 4.57201471848305632250664132243401e-02 8.42771975158688041451782169133367e-02 2.05782176235249063961374460518527e-03
 	 2.87517281890495191021273058140650e-01 5.28034108950670294513329849905858e-02 6.59679307214437793405181764683221e-01 3.89382045842880889635617691624248e-03
 	 2.87517281890495191021273058140650e-01 6.59679307214437793405181764683221e-01 5.28034108950670294513329849905858e-02 3.89382045842880889635617691624248e-03
 	 5.28034108950670294513329849905858e-02 2.87517281890495191021273058140650e-01 6.59679307214437793405181764683221e-01 3.89382045842880889635617691624248e-03
 	 5.28034108950670294513329849905858e-02 6.59679307214437793405181764683221e-01 2.87517281890495191021273058140650e-01 3.89382045842880889635617691624248e-03
 	 6.59679307214437793405181764683221e-01 2.87517281890495191021273058140650e-01 5.28034108950670294513329849905858e-02 3.89382045842880889635617691624248e-03
 	 6.59679307214437793405181764683221e-01 5.28034108950670294513329849905858e-02 2.87517281890495191021273058140650e-01 3.89382045842880889635617691624248e-03
 	 3.42142184906992441462136866903165e-01 3.32627075502785821137230470867507e-02 6.24595107542728955607458374288399e-01 2.77076139655554106594470553659448e-03
 	 3.42142184906992441462136866903165e-01 6.24595107542728955607458374288399e-01 3.32627075502785821137230470867507e-02 2.77076139655554106594470553659448e-03
 	 3.32627075502785821137230470867507e-02 3.42142184906992441462136866903165e-01 6.24595107542728955607458374288399e-01 2.77076139655554106594470553659448e-03
 	 3.32627075502785821137230470867507e-02 6.24595107542728955607458374288399e-01 3.42142184906992441462136866903165e-01 2.77076139655554106594470553659448e-03
 	 6.24595107542728955607458374288399e-01 3.42142184906992441462136866903165e-01 3.32627075502785821137230470867507e-02 2.77076139655554106594470553659448e-03
 	 6.24595107542728955607458374288399e-01 3.32627075502785821137230470867507e-02 3.42142184906992441462136866903165e-01 2.77076139655554106594470553659448e-03
 	 2.90781335627484260886177480642800e-01 2.30909511650298354679122780908074e-02 6.86127713207486000790424895967590e-01 2.48014399850676183975628497080379e-03
 	 2.90781335627484260886177480642800e-01 6.86127713207486000790424895967590e-01 2.30909511650298354679122780908074e-02 2.48014399850676183975628497080379e-03
 	 2.30909511650298354679122780908074e-02 2.90781335627484260886177480642800e-01 6.86127713207486000790424895967590e-01 2.48014399850676183975628497080379e-03
 	 2.30909511650298354679122780908074e-02 6.86127713207486000790424895967590e-01 2.90781335627484260886177480642800e-01 2.48014399850676183975628497080379e-03
 	 6.86127713207486000790424895967590e-01 2.90781335627484260886177480642800e-01 2.30909511650298354679122780908074e-02 2.48014399850676183975628497080379e-03
 	 6.86127713207486000790424895967590e-01 2.30909511650298354679122780908074e-02 2.90781335627484260886177480642800e-01 2.48014399850676183975628497080379e-03
 	 7.77385297161002769561477521165216e-02 8.41212288864582984071471827292044e-03 9.13849347395253919223989669262664e-01 8.62902180833547056450216761191996e-04
 	 7.77385297161002769561477521165216e-02 9.13849347395253919223989669262664e-01 8.41212288864582984071471827292044e-03 8.62902180833547056450216761191996e-04
 	 8.41212288864582984071471827292044e-03 7.77385297161002769561477521165216e-02 9.13849347395253919223989669262664e-01 8.62902180833547056450216761191996e-04
 	 8.41212288864582984071471827292044e-03 9.13849347395253919223989669262664e-01 7.77385297161002769561477521165216e-02 8.62902180833547056450216761191996e-04
 	 9.13849347395253919223989669262664e-01 7.77385297161002769561477521165216e-02 8.41212288864582984071471827292044e-03 8.62902180833547056450216761191996e-04
 	 9.13849347395253919223989669262664e-01 8.41212288864582984071471827292044e-03 7.77385297161002769561477521165216e-02 8.62902180833547056450216761191996e-04
 	 5.83538087981567143991412649484118e-02 1.85584469043908713639656760108210e-03 9.39790346511404139917544853233267e-01 3.20933177574294866470777654043900e-04
 	 5.83538087981567143991412649484118e-02 9.39790346511404139917544853233267e-01 1.85584469043908713639656760108210e-03 3.20933177574294866470777654043900e-04
 	 1.85584469043908713639656760108210e-03 5.83538087981567143991412649484118e-02 9.39790346511404139917544853233267e-01 3.20933177574294866470777654043900e-04
 	 1.85584469043908713639656760108210e-03 9.39790346511404139917544853233267e-01 5.83538087981567143991412649484118e-02 3.20933177574294866470777654043900e-04
 	 9.39790346511404139917544853233267e-01 5.83538087981567143991412649484118e-02 1.85584469043908713639656760108210e-03 3.20933177574294866470777654043900e-04
 	 9.39790346511404139917544853233267e-01 1.85584469043908713639656760108210e-03 5.83538087981567143991412649484118e-02 3.20933177574294866470777654043900e-04
 	 3.53736217391187435232779989746632e-01 1.51861221499153403735604683788551e-01 4.94402561109659188787190942093730e-01 4.98100861061743539759394394650371e-03
 	 3.53736217391187435232779989746632e-01 4.94402561109659188787190942093730e-01 1.51861221499153403735604683788551e-01 4.98100861061743539759394394650371e-03
 	 1.51861221499153403735604683788551e-01 3.53736217391187435232779989746632e-01 4.94402561109659188787190942093730e-01 4.98100861061743539759394394650371e-03
 	 1.51861221499153403735604683788551e-01 4.94402561109659188787190942093730e-01 3.53736217391187435232779989746632e-01 4.98100861061743539759394394650371e-03
 	 4.94402561109659188787190942093730e-01 3.53736217391187435232779989746632e-01 1.51861221499153403735604683788551e-01 4.98100861061743539759394394650371e-03
 	 4.94402561109659188787190942093730e-01 1.51861221499153403735604683788551e-01 3.53736217391187435232779989746632e-01 4.98100861061743539759394394650371e-03
 	 1.94103683421922135199366721280967e-01 1.46693846495503765758883218950359e-01 6.59202470082574154552901291026501e-01 5.01957791808152389151365113661996e-03
 	 1.94103683421922135199366721280967e-01 6.59202470082574154552901291026501e-01 1.46693846495503765758883218950359e-01 5.01957791808152389151365113661996e-03
 	 1.46693846495503765758883218950359e-01 1.94103683421922135199366721280967e-01 6.59202470082574154552901291026501e-01 5.01957791808152389151365113661996e-03
 	 1.46693846495503765758883218950359e-01 6.59202470082574154552901291026501e-01 1.94103683421922135199366721280967e-01 5.01957791808152389151365113661996e-03
 	 6.59202470082574154552901291026501e-01 1.94103683421922135199366721280967e-01 1.46693846495503765758883218950359e-01 5.01957791808152389151365113661996e-03
 	 6.59202470082574154552901291026501e-01 1.46693846495503765758883218950359e-01 1.94103683421922135199366721280967e-01 5.01957791808152389151365113661996e-03
 	 1.15244680262074267185212761432922e-01 7.30582724234847963318273400545877e-02 8.11697047314440922605172090698034e-01 2.76923281829352706598368349943939e-03
 	 1.15244680262074267185212761432922e-01 8.11697047314440922605172090698034e-01 7.30582724234847963318273400545877e-02 2.76923281829352706598368349943939e-03
 	 7.30582724234847963318273400545877e-02 1.15244680262074267185212761432922e-01 8.11697047314440922605172090698034e-01 2.76923281829352706598368349943939e-03
 	 7.30582724234847963318273400545877e-02 8.11697047314440922605172090698034e-01 1.15244680262074267185212761432922e-01 2.76923281829352706598368349943939e-03
 	 8.11697047314440922605172090698034e-01 1.15244680262074267185212761432922e-01 7.30582724234847963318273400545877e-02 2.76923281829352706598368349943939e-03
 	 8.11697047314440922605172090698034e-01 7.30582724234847963318273400545877e-02 1.15244680262074267185212761432922e-01 2.76923281829352706598368349943939e-03
 	 2.52648918856827386925090195290977e-01 8.33205145800466895344982276583323e-02 6.64030566563125868029260345792864e-01 3.70158065967882751040596289726636e-03
 	 2.52648918856827386925090195290977e-01 6.64030566563125868029260345792864e-01 8.33205145800466895344982276583323e-02 3.70158065967882751040596289726636e-03
 	 8.33205145800466895344982276583323e-02 2.52648918856827386925090195290977e-01 6.64030566563125868029260345792864e-01 3.70158065967882751040596289726636e-03
 	 8.33205145800466895344982276583323e-02 6.64030566563125868029260345792864e-01 2.52648918856827386925090195290977e-01 3.70158065967882751040596289726636e-03
 	 6.64030566563125868029260345792864e-01 2.52648918856827386925090195290977e-01 8.33205145800466895344982276583323e-02 3.70158065967882751040596289726636e-03
 	 6.64030566563125868029260345792864e-01 8.33205145800466895344982276583323e-02 2.52648918856827386925090195290977e-01 3.70158065967882751040596289726636e-03
 	 3.70638127911035064609990286044194e-01 9.76700995193537646610337787933531e-02 5.31691772569611087462249088275712e-01 5.07503745916199587584483055024975e-03
 	 3.70638127911035064609990286044194e-01 5.31691772569611087462249088275712e-01 9.76700995193537646610337787933531e-02 5.07503745916199587584483055024975e-03
 	 9.76700995193537646610337787933531e-02 3.70638127911035064609990286044194e-01 5.31691772569611087462249088275712e-01 5.07503745916199587584483055024975e-03
 	 9.76700995193537646610337787933531e-02 5.31691772569611087462249088275712e-01 3.70638127911035064609990286044194e-01 5.07503745916199587584483055024975e-03
 	 5.31691772569611087462249088275712e-01 3.70638127911035064609990286044194e-01 9.76700995193537646610337787933531e-02 5.07503745916199587584483055024975e-03
 	 5.31691772569611087462249088275712e-01 9.76700995193537646610337787933531e-02 3.70638127911035064609990286044194e-01 5.07503745916199587584483055024975e-03
 	 1.97510766235328455442399331332126e-01 1.02127473235820234731541233941243e-01 7.00361760528851240437120395654347e-01 4.26767669154818046067800807463755e-03
 	 1.97510766235328455442399331332126e-01 7.00361760528851240437120395654347e-01 1.02127473235820234731541233941243e-01 4.26767669154818046067800807463755e-03
 	 1.02127473235820234731541233941243e-01 1.97510766235328455442399331332126e-01 7.00361760528851240437120395654347e-01 4.26767669154818046067800807463755e-03
 	 1.02127473235820234731541233941243e-01 7.00361760528851240437120395654347e-01 1.97510766235328455442399331332126e-01 4.26767669154818046067800807463755e-03
 	 7.00361760528851240437120395654347e-01 1.97510766235328455442399331332126e-01 1.02127473235820234731541233941243e-01 4.26767669154818046067800807463755e-03
 	 7.00361760528851240437120395654347e-01 1.02127473235820234731541233941243e-01 1.97510766235328455442399331332126e-01 4.26767669154818046067800807463755e-03
 	 2.19102178776639594515174280786596e-01 1.69401226467935060726599516556234e-02 7.63957698576566923698294431233080e-01 1.72922730398813442528882511339816e-03
 	 2.19102178776639594515174280786596e-01 7.63957698576566923698294431233080e-01 1.69401226467935060726599516556234e-02 1.72922730398813442528882511339816e-03
 	 1.69401226467935060726599516556234e-02 2.19102178776639594515174280786596e-01 7.63957698576566923698294431233080e-01 1.72922730398813442528882511339816e-03
 	 1.69401226467935060726599516556234e-02 7.63957698576566923698294431233080e-01 2.19102178776639594515174280786596e-01 1.72922730398813442528882511339816e-03
 	 7.63957698576566923698294431233080e-01 2.19102178776639594515174280786596e-01 1.69401226467935060726599516556234e-02 1.72922730398813442528882511339816e-03
 	 7.63957698576566923698294431233080e-01 1.69401226467935060726599516556234e-02 2.19102178776639594515174280786596e-01 1.72922730398813442528882511339816e-03
 	 1.64749471455534146624444247208885e-01 6.46074146543942490206191564539040e-02 7.70643113890071562721573172893841e-01 3.22473991224394868765346089389823e-03
 	 1.64749471455534146624444247208885e-01 7.70643113890071562721573172893841e-01 6.46074146543942490206191564539040e-02 3.22473991224394868765346089389823e-03
 	 6.46074146543942490206191564539040e-02 1.64749471455534146624444247208885e-01 7.70643113890071562721573172893841e-01 3.22473991224394868765346089389823e-03
 	 6.46074146543942490206191564539040e-02 7.70643113890071562721573172893841e-01 1.64749471455534146624444247208885e-01 3.22473991224394868765346089389823e-03
 	 7.70643113890071562721573172893841e-01 1.64749471455534146624444247208885e-01 6.46074146543942490206191564539040e-02 3.22473991224394868765346089389823e-03
 	 7.70643113890071562721573172893841e-01 6.46074146543942490206191564539040e-02 1.64749471455534146624444247208885e-01 3.22473991224394868765346089389823e-03
 	 3.48756887430614948009122144867433e-01 1.94293491861925404773359105092823e-01 4.56949620707459647217518750039744e-01 5.28794771296189642512119988282393e-03
 	 3.48756887430614948009122144867433e-01 4.56949620707459647217518750039744e-01 1.94293491861925404773359105092823e-01 5.28794771296189642512119988282393e-03
 	 1.94293491861925404773359105092823e-01 3.48756887430614948009122144867433e-01 4.56949620707459647217518750039744e-01 5.28794771296189642512119988282393e-03
 	 1.94293491861925404773359105092823e-01 4.56949620707459647217518750039744e-01 3.48756887430614948009122144867433e-01 5.28794771296189642512119988282393e-03
 	 4.56949620707459647217518750039744e-01 3.48756887430614948009122144867433e-01 1.94293491861925404773359105092823e-01 5.28794771296189642512119988282393e-03
 	 4.56949620707459647217518750039744e-01 1.94293491861925404773359105092823e-01 3.48756887430614948009122144867433e-01 5.28794771296189642512119988282393e-03
 	 3.55853330058662320478646279298118e-01 5.87895877753212212080136112035689e-02 5.85357082166016451374446205591084e-01 4.01958428636507020259571731912729e-03
 	 3.55853330058662320478646279298118e-01 5.85357082166016451374446205591084e-01 5.87895877753212212080136112035689e-02 4.01958428636507020259571731912729e-03
 	 5.87895877753212212080136112035689e-02 3.55853330058662320478646279298118e-01 5.85357082166016451374446205591084e-01 4.01958428636507020259571731912729e-03
 	 5.87895877753212212080136112035689e-02 5.85357082166016451374446205591084e-01 3.55853330058662320478646279298118e-01 4.01958428636507020259571731912729e-03
 	 5.85357082166016451374446205591084e-01 3.55853330058662320478646279298118e-01 5.87895877753212212080136112035689e-02 4.01958428636507020259571731912729e-03
 	 5.85357082166016451374446205591084e-01 5.87895877753212212080136112035689e-02 3.55853330058662320478646279298118e-01 4.01958428636507020259571731912729e-03
 	 3.48716528985469398360663717539865e-01 2.43584975885173138365757949941326e-01 4.07698495129357407762427101260982e-01 6.06083320730004676546442965445749e-03
 	 3.48716528985469398360663717539865e-01 4.07698495129357407762427101260982e-01 2.43584975885173138365757949941326e-01 6.06083320730004676546442965445749e-03
 	 2.43584975885173138365757949941326e-01 3.48716528985469398360663717539865e-01 4.07698495129357407762427101260982e-01 6.06083320730004676546442965445749e-03
 	 2.43584975885173138365757949941326e-01 4.07698495129357407762427101260982e-01 3.48716528985469398360663717539865e-01 6.06083320730004676546442965445749e-03
 	 4.07698495129357407762427101260982e-01 3.48716528985469398360663717539865e-01 2.43584975885173138365757949941326e-01 6.06083320730004676546442965445749e-03
 	 4.07698495129357407762427101260982e-01 2.43584975885173138365757949941326e-01 3.48716528985469398360663717539865e-01 6.06083320730004676546442965445749e-03
 	 2.90704335549696046836487539621885e-01 1.86125965956163291759040134820680e-01 5.23169698494140633648896709928522e-01 5.79913705856328204335525811075058e-03
 	 2.90704335549696046836487539621885e-01 5.23169698494140633648896709928522e-01 1.86125965956163291759040134820680e-01 5.79913705856328204335525811075058e-03
 	 1.86125965956163291759040134820680e-01 2.90704335549696046836487539621885e-01 5.23169698494140633648896709928522e-01 5.79913705856328204335525811075058e-03
 	 1.86125965956163291759040134820680e-01 5.23169698494140633648896709928522e-01 2.90704335549696046836487539621885e-01 5.79913705856328204335525811075058e-03
 	 5.23169698494140633648896709928522e-01 2.90704335549696046836487539621885e-01 1.86125965956163291759040134820680e-01 5.79913705856328204335525811075058e-03
 	 5.23169698494140633648896709928522e-01 1.86125965956163291759040134820680e-01 2.90704335549696046836487539621885e-01 5.79913705856328204335525811075058e-03
 	 2.89862934817113671037702715693740e-01 2.38357019552556226305028985734680e-01 4.71780045630330102657268298571580e-01 6.39314752111004060142196436800077e-03
 	 2.89862934817113671037702715693740e-01 4.71780045630330102657268298571580e-01 2.38357019552556226305028985734680e-01 6.39314752111004060142196436800077e-03
 	 2.38357019552556226305028985734680e-01 2.89862934817113671037702715693740e-01 4.71780045630330102657268298571580e-01 6.39314752111004060142196436800077e-03
 	 2.38357019552556226305028985734680e-01 4.71780045630330102657268298571580e-01 2.89862934817113671037702715693740e-01 6.39314752111004060142196436800077e-03
 	 4.71780045630330102657268298571580e-01 2.89862934817113671037702715693740e-01 2.38357019552556226305028985734680e-01 6.39314752111004060142196436800077e-03
 	 4.71780045630330102657268298571580e-01 2.38357019552556226305028985734680e-01 2.89862934817113671037702715693740e-01 6.39314752111004060142196436800077e-03
 	 3.09383575445457970065632480327622e-01 1.31229616791972980571756579593057e-01 5.59386807762569104873762171337148e-01 5.65467500898843115908487533260995e-03
 	 3.09383575445457970065632480327622e-01 5.59386807762569104873762171337148e-01 1.31229616791972980571756579593057e-01 5.65467500898843115908487533260995e-03
 	 1.31229616791972980571756579593057e-01 3.09383575445457970065632480327622e-01 5.59386807762569104873762171337148e-01 5.65467500898843115908487533260995e-03
 	 1.31229616791972980571756579593057e-01 5.59386807762569104873762171337148e-01 3.09383575445457970065632480327622e-01 5.65467500898843115908487533260995e-03
 	 5.59386807762569104873762171337148e-01 3.09383575445457970065632480327622e-01 1.31229616791972980571756579593057e-01 5.65467500898843115908487533260995e-03
 	 5.59386807762569104873762171337148e-01 1.31229616791972980571756579593057e-01 3.09383575445457970065632480327622e-01 5.65467500898843115908487533260995e-03
 	 2.46979539099244443933756087972142e-01 1.68458978552479210488712624282925e-01 5.84561482348276317821955672116019e-01 5.31104941689996938591900033088677e-03
 	 2.46979539099244443933756087972142e-01 5.84561482348276317821955672116019e-01 1.68458978552479210488712624282925e-01 5.31104941689996938591900033088677e-03
 	 1.68458978552479210488712624282925e-01 2.46979539099244443933756087972142e-01 5.84561482348276317821955672116019e-01 5.31104941689996938591900033088677e-03
 	 1.68458978552479210488712624282925e-01 5.84561482348276317821955672116019e-01 2.46979539099244443933756087972142e-01 5.31104941689996938591900033088677e-03
 	 5.84561482348276317821955672116019e-01 2.46979539099244443933756087972142e-01 1.68458978552479210488712624282925e-01 5.31104941689996938591900033088677e-03
 	 5.84561482348276317821955672116019e-01 1.68458978552479210488712624282925e-01 2.46979539099244443933756087972142e-01 5.31104941689996938591900033088677e-03
 	 4.35345195121465189380671745311702e-01 1.31254695112234757298219633980807e-02 5.51529335367311301929760247730883e-01 1.97323042147589874928392816855194e-03
 	 4.35345195121465189380671745311702e-01 5.51529335367311301929760247730883e-01 1.31254695112234757298219633980807e-02 1.97323042147589874928392816855194e-03
 	 1.31254695112234757298219633980807e-02 4.35345195121465189380671745311702e-01 5.51529335367311301929760247730883e-01 1.97323042147589874928392816855194e-03
 	 1.31254695112234757298219633980807e-02 5.51529335367311301929760247730883e-01 4.35345195121465189380671745311702e-01 1.97323042147589874928392816855194e-03
 	 5.51529335367311301929760247730883e-01 4.35345195121465189380671745311702e-01 1.31254695112234757298219633980807e-02 1.97323042147589874928392816855194e-03
 	 5.51529335367311301929760247730883e-01 1.31254695112234757298219633980807e-02 4.35345195121465189380671745311702e-01 1.97323042147589874928392816855194e-03
 	 4.13701289314883091652319535569404e-01 3.44134405185802239035552929635742e-02 5.51885270166536767710852018353762e-01 3.55547947156693898776436135733547e-03
 	 4.13701289314883091652319535569404e-01 5.51885270166536767710852018353762e-01 3.44134405185802239035552929635742e-02 3.55547947156693898776436135733547e-03
 	 3.44134405185802239035552929635742e-02 4.13701289314883091652319535569404e-01 5.51885270166536767710852018353762e-01 3.55547947156693898776436135733547e-03
 	 3.44134405185802239035552929635742e-02 5.51885270166536767710852018353762e-01 4.13701289314883091652319535569404e-01 3.55547947156693898776436135733547e-03
 	 5.51885270166536767710852018353762e-01 4.13701289314883091652319535569404e-01 3.44134405185802239035552929635742e-02 3.55547947156693898776436135733547e-03
 	 5.51885270166536767710852018353762e-01 3.44134405185802239035552929635742e-02 4.13701289314883091652319535569404e-01 3.55547947156693898776436135733547e-03
 	 ];
 
 	 case  45 

 	 % ALG. DEG.:   45
 	 % PTS CARD.:  370
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 6.94146965438502405731924227438867e-03
 	 1.29806653300276658713485744556237e-01 1.29806653300276658713485744556237e-01 7.40386693399446738084179742145352e-01 3.20241715035257277707780865227960e-03
 	 1.29806653300276658713485744556237e-01 7.40386693399446738084179742145352e-01 1.29806653300276658713485744556237e-01 3.20241715035257277707780865227960e-03
 	 7.40386693399446738084179742145352e-01 1.29806653300276658713485744556237e-01 1.29806653300276658713485744556237e-01 3.20241715035257277707780865227960e-03
 	 2.06349665630883027933606399528799e-01 2.06349665630883027933606399528799e-01 5.87300668738233944132787200942403e-01 4.63734884112197275757294434583855e-03
 	 2.06349665630883027933606399528799e-01 5.87300668738233944132787200942403e-01 2.06349665630883027933606399528799e-01 4.63734884112197275757294434583855e-03
 	 5.87300668738233944132787200942403e-01 2.06349665630883027933606399528799e-01 2.06349665630883027933606399528799e-01 4.63734884112197275757294434583855e-03
 	 1.75084588806939833727227551207761e-01 1.75084588806939833727227551207761e-01 6.49830822386120332545544897584477e-01 4.08706046548729627632123850844437e-03
 	 1.75084588806939833727227551207761e-01 6.49830822386120332545544897584477e-01 1.75084588806939833727227551207761e-01 4.08706046548729627632123850844437e-03
 	 6.49830822386120332545544897584477e-01 1.75084588806939833727227551207761e-01 1.75084588806939833727227551207761e-01 4.08706046548729627632123850844437e-03
 	 4.99504576867959404484764718290535e-01 4.99504576867959404484764718290535e-01 9.90846264081191030470563418930396e-04 4.83113523032025697200725344870875e-04
 	 4.99504576867959404484764718290535e-01 9.90846264081191030470563418930396e-04 4.99504576867959404484764718290535e-01 4.83113523032025697200725344870875e-04
 	 9.90846264081191030470563418930396e-04 4.99504576867959404484764718290535e-01 4.99504576867959404484764718290535e-01 4.83113523032025697200725344870875e-04
 	 5.52204190605027900318191313999705e-02 5.52204190605027900318191313999705e-02 8.89559161878994419936361737200059e-01 1.69261014055523822952054047163983e-03
 	 5.52204190605027900318191313999705e-02 8.89559161878994419936361737200059e-01 5.52204190605027900318191313999705e-02 1.69261014055523822952054047163983e-03
 	 8.89559161878994419936361737200059e-01 5.52204190605027900318191313999705e-02 5.52204190605027900318191313999705e-02 1.69261014055523822952054047163983e-03
 	 2.99152765836593892423422857973492e-01 2.99152765836593892423422857973492e-01 4.01694468326812215153154284053016e-01 6.83375537569812317034712023655629e-03
 	 2.99152765836593892423422857973492e-01 4.01694468326812215153154284053016e-01 2.99152765836593892423422857973492e-01 6.83375537569812317034712023655629e-03
 	 4.01694468326812215153154284053016e-01 2.99152765836593892423422857973492e-01 2.99152765836593892423422857973492e-01 6.83375537569812317034712023655629e-03
 	 3.66982277256458211400769187093829e-01 3.66982277256458211400769187093829e-01 2.66035445487083577198461625812342e-01 6.89250479858695246082600505133087e-03
 	 3.66982277256458211400769187093829e-01 2.66035445487083577198461625812342e-01 3.66982277256458211400769187093829e-01 6.89250479858695246082600505133087e-03
 	 2.66035445487083577198461625812342e-01 3.66982277256458211400769187093829e-01 3.66982277256458211400769187093829e-01 6.89250479858695246082600505133087e-03
 	 2.64921642390380518428116829454666e-01 2.64921642390380518428116829454666e-01 4.70156715219238963143766341090668e-01 6.31465699303289731969535125699622e-03
 	 2.64921642390380518428116829454666e-01 4.70156715219238963143766341090668e-01 2.64921642390380518428116829454666e-01 6.31465699303289731969535125699622e-03
 	 4.70156715219238963143766341090668e-01 2.64921642390380518428116829454666e-01 2.64921642390380518428116829454666e-01 6.31465699303289731969535125699622e-03
 	 3.98469068413945026740918819996295e-01 3.98469068413945026740918819996295e-01 2.03061863172109946518162360007409e-01 6.55830750019788417948252146061350e-03
 	 3.98469068413945026740918819996295e-01 2.03061863172109946518162360007409e-01 3.98469068413945026740918819996295e-01 6.55830750019788417948252146061350e-03
 	 2.03061863172109946518162360007409e-01 3.98469068413945026740918819996295e-01 3.98469068413945026740918819996295e-01 6.55830750019788417948252146061350e-03
 	 4.52620190751494178016400837805122e-01 4.52620190751494178016400837805122e-01 9.47596184970116439671983243897557e-02 5.01685948596821036649107128368996e-03
 	 4.52620190751494178016400837805122e-01 9.47596184970116439671983243897557e-02 4.52620190751494178016400837805122e-01 5.01685948596821036649107128368996e-03
 	 9.47596184970116439671983243897557e-02 4.52620190751494178016400837805122e-01 4.52620190751494178016400837805122e-01 5.01685948596821036649107128368996e-03
 	 4.26861049533307446157692766064429e-01 4.26861049533307446157692766064429e-01 1.46277900933385107684614467871143e-01 5.88250912617529955056516755007578e-03
 	 4.26861049533307446157692766064429e-01 1.46277900933385107684614467871143e-01 4.26861049533307446157692766064429e-01 5.88250912617529955056516755007578e-03
 	 1.46277900933385107684614467871143e-01 4.26861049533307446157692766064429e-01 4.26861049533307446157692766064429e-01 5.88250912617529955056516755007578e-03
 	 9.45724371334943636480119266707334e-02 9.45724371334943636480119266707334e-02 8.10855125733011217192824915400706e-01 3.13714346216426845023739211626435e-03
 	 9.45724371334943636480119266707334e-02 8.10855125733011217192824915400706e-01 9.45724371334943636480119266707334e-02 3.13714346216426845023739211626435e-03
 	 8.10855125733011217192824915400706e-01 9.45724371334943636480119266707334e-02 9.45724371334943636480119266707334e-02 3.13714346216426845023739211626435e-03
 	 4.72989470868897310396050670533441e-01 4.72989470868897310396050670533441e-01 5.40210582622053792078986589331180e-02 4.09306514781966959692915963842097e-03
 	 4.72989470868897310396050670533441e-01 5.40210582622053792078986589331180e-02 4.72989470868897310396050670533441e-01 4.09306514781966959692915963842097e-03
 	 5.40210582622053792078986589331180e-02 4.72989470868897310396050670533441e-01 4.72989470868897310396050670533441e-01 4.09306514781966959692915963842097e-03
 	 3.40851411567991424700352354193456e-02 3.40851411567991424700352354193456e-02 9.31829717686401659548778297903482e-01 1.25131468532045870070690263275992e-03
 	 3.40851411567991424700352354193456e-02 9.31829717686401659548778297903482e-01 3.40851411567991424700352354193456e-02 1.25131468532045870070690263275992e-03
 	 9.31829717686401659548778297903482e-01 3.40851411567991424700352354193456e-02 3.40851411567991424700352354193456e-02 1.25131468532045870070690263275992e-03
 	 4.86998996825781460540127909553121e-01 4.86998996825781460540127909553121e-01 2.60020063484370789197441808937583e-02 3.05580577029882947612260402081574e-03
 	 4.86998996825781460540127909553121e-01 2.60020063484370789197441808937583e-02 4.86998996825781460540127909553121e-01 3.05580577029882947612260402081574e-03
 	 2.60020063484370789197441808937583e-02 4.86998996825781460540127909553121e-01 4.86998996825781460540127909553121e-01 3.05580577029882947612260402081574e-03
 	 1.26048038307361616461310660497475e-02 7.29242955084338090321338654575811e-03 9.80102766618420440103420787636423e-01 1.94306424775461054465369725718915e-04
 	 1.26048038307361616461310660497475e-02 9.80102766618420440103420787636423e-01 7.29242955084338090321338654575811e-03 1.94306424775461054465369725718915e-04
 	 7.29242955084338090321338654575811e-03 1.26048038307361616461310660497475e-02 9.80102766618420440103420787636423e-01 1.94306424775461054465369725718915e-04
 	 7.29242955084338090321338654575811e-03 9.80102766618420440103420787636423e-01 1.26048038307361616461310660497475e-02 1.94306424775461054465369725718915e-04
 	 9.80102766618420440103420787636423e-01 1.26048038307361616461310660497475e-02 7.29242955084338090321338654575811e-03 1.94306424775461054465369725718915e-04
 	 9.80102766618420440103420787636423e-01 7.29242955084338090321338654575811e-03 1.26048038307361616461310660497475e-02 1.94306424775461054465369725718915e-04
 	 4.60547663144127931295068734129927e-03 1.34999718211049760455133572634168e-03 9.94044526186448229587711011845386e-01 5.93664802978331965373735845670211e-05
 	 4.60547663144127931295068734129927e-03 9.94044526186448229587711011845386e-01 1.34999718211049760455133572634168e-03 5.93664802978331965373735845670211e-05
 	 1.34999718211049760455133572634168e-03 4.60547663144127931295068734129927e-03 9.94044526186448229587711011845386e-01 5.93664802978331965373735845670211e-05
 	 1.34999718211049760455133572634168e-03 9.94044526186448229587711011845386e-01 4.60547663144127931295068734129927e-03 5.93664802978331965373735845670211e-05
 	 9.94044526186448229587711011845386e-01 4.60547663144127931295068734129927e-03 1.34999718211049760455133572634168e-03 5.93664802978331965373735845670211e-05
 	 9.94044526186448229587711011845386e-01 1.34999718211049760455133572634168e-03 4.60547663144127931295068734129927e-03 5.93664802978331965373735845670211e-05
 	 6.79464966039111523121718505535682e-02 6.85917593806053670774103281360112e-03 9.25194327458028320521066234505270e-01 4.80688707502662957923855735486995e-04
 	 6.79464966039111523121718505535682e-02 9.25194327458028320521066234505270e-01 6.85917593806053670774103281360112e-03 4.80688707502662957923855735486995e-04
 	 6.85917593806053670774103281360112e-03 6.79464966039111523121718505535682e-02 9.25194327458028320521066234505270e-01 4.80688707502662957923855735486995e-04
 	 6.85917593806053670774103281360112e-03 9.25194327458028320521066234505270e-01 6.79464966039111523121718505535682e-02 4.80688707502662957923855735486995e-04
 	 9.25194327458028320521066234505270e-01 6.79464966039111523121718505535682e-02 6.85917593806053670774103281360112e-03 4.80688707502662957923855735486995e-04
 	 9.25194327458028320521066234505270e-01 6.85917593806053670774103281360112e-03 6.79464966039111523121718505535682e-02 4.80688707502662957923855735486995e-04
 	 6.93380043634408277375413831578044e-02 1.22976799593489888665076570362089e-03 9.29432227640624275544212196109584e-01 2.30124933500223960176206405847665e-04
 	 6.93380043634408277375413831578044e-02 9.29432227640624275544212196109584e-01 1.22976799593489888665076570362089e-03 2.30124933500223960176206405847665e-04
 	 1.22976799593489888665076570362089e-03 6.93380043634408277375413831578044e-02 9.29432227640624275544212196109584e-01 2.30124933500223960176206405847665e-04
 	 1.22976799593489888665076570362089e-03 9.29432227640624275544212196109584e-01 6.93380043634408277375413831578044e-02 2.30124933500223960176206405847665e-04
 	 9.29432227640624275544212196109584e-01 6.93380043634408277375413831578044e-02 1.22976799593489888665076570362089e-03 2.30124933500223960176206405847665e-04
 	 9.29432227640624275544212196109584e-01 1.22976799593489888665076570362089e-03 6.93380043634408277375413831578044e-02 2.30124933500223960176206405847665e-04
 	 4.68270859870947964154197507014032e-01 8.78010020069475149995241736178286e-03 5.22949039928357284345850075624185e-01 1.29446271706814305772759166046626e-03
 	 4.68270859870947964154197507014032e-01 5.22949039928357284345850075624185e-01 8.78010020069475149995241736178286e-03 1.29446271706814305772759166046626e-03
 	 8.78010020069475149995241736178286e-03 4.68270859870947964154197507014032e-01 5.22949039928357284345850075624185e-01 1.29446271706814305772759166046626e-03
 	 8.78010020069475149995241736178286e-03 5.22949039928357284345850075624185e-01 4.68270859870947964154197507014032e-01 1.29446271706814305772759166046626e-03
 	 5.22949039928357284345850075624185e-01 4.68270859870947964154197507014032e-01 8.78010020069475149995241736178286e-03 1.29446271706814305772759166046626e-03
 	 5.22949039928357284345850075624185e-01 8.78010020069475149995241736178286e-03 4.68270859870947964154197507014032e-01 1.29446271706814305772759166046626e-03
 	 2.50495170335221506441314431867795e-01 1.68302636118027710253330919698556e-03 7.47821803303598264811569151788717e-01 4.60520898290685666651850249664335e-04
 	 2.50495170335221506441314431867795e-01 7.47821803303598264811569151788717e-01 1.68302636118027710253330919698556e-03 4.60520898290685666651850249664335e-04
 	 1.68302636118027710253330919698556e-03 2.50495170335221506441314431867795e-01 7.47821803303598264811569151788717e-01 4.60520898290685666651850249664335e-04
 	 1.68302636118027710253330919698556e-03 7.47821803303598264811569151788717e-01 2.50495170335221506441314431867795e-01 4.60520898290685666651850249664335e-04
 	 7.47821803303598264811569151788717e-01 2.50495170335221506441314431867795e-01 1.68302636118027710253330919698556e-03 4.60520898290685666651850249664335e-04
 	 7.47821803303598264811569151788717e-01 1.68302636118027710253330919698556e-03 2.50495170335221506441314431867795e-01 4.60520898290685666651850249664335e-04
 	 1.79231013398374397493917342671921e-02 1.75797258353514685921825666525820e-03 9.80318926076627406018815236166120e-01 1.55069008002866085774856808043864e-04
 	 1.79231013398374397493917342671921e-02 9.80318926076627406018815236166120e-01 1.75797258353514685921825666525820e-03 1.55069008002866085774856808043864e-04
 	 1.75797258353514685921825666525820e-03 1.79231013398374397493917342671921e-02 9.80318926076627406018815236166120e-01 1.55069008002866085774856808043864e-04
 	 1.75797258353514685921825666525820e-03 9.80318926076627406018815236166120e-01 1.79231013398374397493917342671921e-02 1.55069008002866085774856808043864e-04
 	 9.80318926076627406018815236166120e-01 1.79231013398374397493917342671921e-02 1.75797258353514685921825666525820e-03 1.55069008002866085774856808043864e-04
 	 9.80318926076627406018815236166120e-01 1.75797258353514685921825666525820e-03 1.79231013398374397493917342671921e-02 1.55069008002866085774856808043864e-04
 	 3.59456841995052789329179177002516e-01 1.47561365316294709065791934676781e-03 6.39067544351784255773907261755085e-01 5.26432016899674765260386255505409e-04
 	 3.59456841995052789329179177002516e-01 6.39067544351784255773907261755085e-01 1.47561365316294709065791934676781e-03 5.26432016899674765260386255505409e-04
 	 1.47561365316294709065791934676781e-03 3.59456841995052789329179177002516e-01 6.39067544351784255773907261755085e-01 5.26432016899674765260386255505409e-04
 	 1.47561365316294709065791934676781e-03 6.39067544351784255773907261755085e-01 3.59456841995052789329179177002516e-01 5.26432016899674765260386255505409e-04
 	 6.39067544351784255773907261755085e-01 3.59456841995052789329179177002516e-01 1.47561365316294709065791934676781e-03 5.26432016899674765260386255505409e-04
 	 6.39067544351784255773907261755085e-01 1.47561365316294709065791934676781e-03 3.59456841995052789329179177002516e-01 5.26432016899674765260386255505409e-04
 	 2.21153984784947493791307238097943e-01 1.53663127462592530303453486340004e-01 6.25182887752459892638512428675313e-01 4.07760280087719664127154928223717e-03
 	 2.21153984784947493791307238097943e-01 6.25182887752459892638512428675313e-01 1.53663127462592530303453486340004e-01 4.07760280087719664127154928223717e-03
 	 1.53663127462592530303453486340004e-01 2.21153984784947493791307238097943e-01 6.25182887752459892638512428675313e-01 4.07760280087719664127154928223717e-03
 	 1.53663127462592530303453486340004e-01 6.25182887752459892638512428675313e-01 2.21153984784947493791307238097943e-01 4.07760280087719664127154928223717e-03
 	 6.25182887752459892638512428675313e-01 2.21153984784947493791307238097943e-01 1.53663127462592530303453486340004e-01 4.07760280087719664127154928223717e-03
 	 6.25182887752459892638512428675313e-01 1.53663127462592530303453486340004e-01 2.21153984784947493791307238097943e-01 4.07760280087719664127154928223717e-03
 	 2.38973194878696115761584906067583e-01 2.27625216137249258840924426294805e-01 5.33401588984054542130763820750872e-01 2.72733715556331595200600936834689e-03
 	 2.38973194878696115761584906067583e-01 5.33401588984054542130763820750872e-01 2.27625216137249258840924426294805e-01 2.72733715556331595200600936834689e-03
 	 2.27625216137249258840924426294805e-01 2.38973194878696115761584906067583e-01 5.33401588984054542130763820750872e-01 2.72733715556331595200600936834689e-03
 	 2.27625216137249258840924426294805e-01 5.33401588984054542130763820750872e-01 2.38973194878696115761584906067583e-01 2.72733715556331595200600936834689e-03
 	 5.33401588984054542130763820750872e-01 2.38973194878696115761584906067583e-01 2.27625216137249258840924426294805e-01 2.72733715556331595200600936834689e-03
 	 5.33401588984054542130763820750872e-01 2.27625216137249258840924426294805e-01 2.38973194878696115761584906067583e-01 2.72733715556331595200600936834689e-03
 	 2.26522885981175758907113504392328e-01 1.14203037751511859987374464253662e-01 6.59274076267312381105512031354010e-01 3.81783836004181541950996958689757e-03
 	 2.26522885981175758907113504392328e-01 6.59274076267312381105512031354010e-01 1.14203037751511859987374464253662e-01 3.81783836004181541950996958689757e-03
 	 1.14203037751511859987374464253662e-01 2.26522885981175758907113504392328e-01 6.59274076267312381105512031354010e-01 3.81783836004181541950996958689757e-03
 	 1.14203037751511859987374464253662e-01 6.59274076267312381105512031354010e-01 2.26522885981175758907113504392328e-01 3.81783836004181541950996958689757e-03
 	 6.59274076267312381105512031354010e-01 2.26522885981175758907113504392328e-01 1.14203037751511859987374464253662e-01 3.81783836004181541950996958689757e-03
 	 6.59274076267312381105512031354010e-01 1.14203037751511859987374464253662e-01 2.26522885981175758907113504392328e-01 3.81783836004181541950996958689757e-03
 	 2.39590524037790186806518022422097e-01 8.03750594685513908288498896581586e-02 6.80034416493658366853480856661918e-01 3.24358992848865559932569624379539e-03
 	 2.39590524037790186806518022422097e-01 6.80034416493658366853480856661918e-01 8.03750594685513908288498896581586e-02 3.24358992848865559932569624379539e-03
 	 8.03750594685513908288498896581586e-02 2.39590524037790186806518022422097e-01 6.80034416493658366853480856661918e-01 3.24358992848865559932569624379539e-03
 	 8.03750594685513908288498896581586e-02 6.80034416493658366853480856661918e-01 2.39590524037790186806518022422097e-01 3.24358992848865559932569624379539e-03
 	 6.80034416493658366853480856661918e-01 2.39590524037790186806518022422097e-01 8.03750594685513908288498896581586e-02 3.24358992848865559932569624379539e-03
 	 6.80034416493658366853480856661918e-01 8.03750594685513908288498896581586e-02 2.39590524037790186806518022422097e-01 3.24358992848865559932569624379539e-03
 	 1.78291402992592273868410757131642e-01 3.06183636824900254347348038663768e-02 7.91090233324917679880172727280296e-01 1.88496571838490619733852415862430e-03
 	 1.78291402992592273868410757131642e-01 7.91090233324917679880172727280296e-01 3.06183636824900254347348038663768e-02 1.88496571838490619733852415862430e-03
 	 3.06183636824900254347348038663768e-02 1.78291402992592273868410757131642e-01 7.91090233324917679880172727280296e-01 1.88496571838490619733852415862430e-03
 	 3.06183636824900254347348038663768e-02 7.91090233324917679880172727280296e-01 1.78291402992592273868410757131642e-01 1.88496571838490619733852415862430e-03
 	 7.91090233324917679880172727280296e-01 1.78291402992592273868410757131642e-01 3.06183636824900254347348038663768e-02 1.88496571838490619733852415862430e-03
 	 7.91090233324917679880172727280296e-01 3.06183636824900254347348038663768e-02 1.78291402992592273868410757131642e-01 1.88496571838490619733852415862430e-03
 	 2.82586689120417511311700309306616e-01 2.69421027814230988617349993319294e-02 6.90471208098159427990481162851211e-01 2.18072238760697988818604287075686e-03
 	 2.82586689120417511311700309306616e-01 6.90471208098159427990481162851211e-01 2.69421027814230988617349993319294e-02 2.18072238760697988818604287075686e-03
 	 2.69421027814230988617349993319294e-02 2.82586689120417511311700309306616e-01 6.90471208098159427990481162851211e-01 2.18072238760697988818604287075686e-03
 	 2.69421027814230988617349993319294e-02 6.90471208098159427990481162851211e-01 2.82586689120417511311700309306616e-01 2.18072238760697988818604287075686e-03
 	 6.90471208098159427990481162851211e-01 2.82586689120417511311700309306616e-01 2.69421027814230988617349993319294e-02 2.18072238760697988818604287075686e-03
 	 6.90471208098159427990481162851211e-01 2.69421027814230988617349993319294e-02 2.82586689120417511311700309306616e-01 2.18072238760697988818604287075686e-03
 	 1.37257110258729553287082580936840e-01 3.27972135469326506185261393966357e-02 8.29945676194337789155497375759296e-01 1.83458123916104302517093849189678e-03
 	 1.37257110258729553287082580936840e-01 8.29945676194337789155497375759296e-01 3.27972135469326506185261393966357e-02 1.83458123916104302517093849189678e-03
 	 3.27972135469326506185261393966357e-02 1.37257110258729553287082580936840e-01 8.29945676194337789155497375759296e-01 1.83458123916104302517093849189678e-03
 	 3.27972135469326506185261393966357e-02 8.29945676194337789155497375759296e-01 1.37257110258729553287082580936840e-01 1.83458123916104302517093849189678e-03
 	 8.29945676194337789155497375759296e-01 1.37257110258729553287082580936840e-01 3.27972135469326506185261393966357e-02 1.83458123916104302517093849189678e-03
 	 8.29945676194337789155497375759296e-01 3.27972135469326506185261393966357e-02 1.37257110258729553287082580936840e-01 1.83458123916104302517093849189678e-03
 	 1.00254415236569610625494419764436e-01 3.27271127336489636716621021150786e-02 8.67018472029781439580631285934942e-01 1.62733979543270819781430880368589e-03
 	 1.00254415236569610625494419764436e-01 8.67018472029781439580631285934942e-01 3.27271127336489636716621021150786e-02 1.62733979543270819781430880368589e-03
 	 3.27271127336489636716621021150786e-02 1.00254415236569610625494419764436e-01 8.67018472029781439580631285934942e-01 1.62733979543270819781430880368589e-03
 	 3.27271127336489636716621021150786e-02 8.67018472029781439580631285934942e-01 1.00254415236569610625494419764436e-01 1.62733979543270819781430880368589e-03
 	 8.67018472029781439580631285934942e-01 1.00254415236569610625494419764436e-01 3.27271127336489636716621021150786e-02 1.62733979543270819781430880368589e-03
 	 8.67018472029781439580631285934942e-01 3.27271127336489636716621021150786e-02 1.00254415236569610625494419764436e-01 1.62733979543270819781430880368589e-03
 	 5.17074765599652777514627643995482e-02 1.51601013138725621010038935310149e-02 9.33132422126162097697488206904382e-01 8.28532821172723991411113164673452e-04
 	 5.17074765599652777514627643995482e-02 9.33132422126162097697488206904382e-01 1.51601013138725621010038935310149e-02 8.28532821172723991411113164673452e-04
 	 1.51601013138725621010038935310149e-02 5.17074765599652777514627643995482e-02 9.33132422126162097697488206904382e-01 8.28532821172723991411113164673452e-04
 	 1.51601013138725621010038935310149e-02 9.33132422126162097697488206904382e-01 5.17074765599652777514627643995482e-02 8.28532821172723991411113164673452e-04
 	 9.33132422126162097697488206904382e-01 5.17074765599652777514627643995482e-02 1.51601013138725621010038935310149e-02 8.28532821172723991411113164673452e-04
 	 9.33132422126162097697488206904382e-01 1.51601013138725621010038935310149e-02 5.17074765599652777514627643995482e-02 8.28532821172723991411113164673452e-04
 	 2.60614855137656920014421757514356e-01 1.70884652952977555973035350689315e-01 5.68500491909365468501391660538502e-01 5.10749008676768517095423405294241e-03
 	 2.60614855137656920014421757514356e-01 5.68500491909365468501391660538502e-01 1.70884652952977555973035350689315e-01 5.10749008676768517095423405294241e-03
 	 1.70884652952977555973035350689315e-01 2.60614855137656920014421757514356e-01 5.68500491909365468501391660538502e-01 5.10749008676768517095423405294241e-03
 	 1.70884652952977555973035350689315e-01 5.68500491909365468501391660538502e-01 2.60614855137656920014421757514356e-01 5.10749008676768517095423405294241e-03
 	 5.68500491909365468501391660538502e-01 2.60614855137656920014421757514356e-01 1.70884652952977555973035350689315e-01 5.10749008676768517095423405294241e-03
 	 5.68500491909365468501391660538502e-01 1.70884652952977555973035350689315e-01 2.60614855137656920014421757514356e-01 5.10749008676768517095423405294241e-03
 	 2.27214324959957303384783244837308e-01 2.86632862041672348274445880633721e-02 7.44122388835875447909984359284863e-01 2.23911335889155280187701180238946e-03
 	 2.27214324959957303384783244837308e-01 7.44122388835875447909984359284863e-01 2.86632862041672348274445880633721e-02 2.23911335889155280187701180238946e-03
 	 2.86632862041672348274445880633721e-02 2.27214324959957303384783244837308e-01 7.44122388835875447909984359284863e-01 2.23911335889155280187701180238946e-03
 	 2.86632862041672348274445880633721e-02 7.44122388835875447909984359284863e-01 2.27214324959957303384783244837308e-01 2.23911335889155280187701180238946e-03
 	 7.44122388835875447909984359284863e-01 2.27214324959957303384783244837308e-01 2.86632862041672348274445880633721e-02 2.23911335889155280187701180238946e-03
 	 7.44122388835875447909984359284863e-01 2.86632862041672348274445880633721e-02 2.27214324959957303384783244837308e-01 2.23911335889155280187701180238946e-03
 	 3.11040487235050899794686074528727e-01 1.26956715659609486318570858998100e-02 6.76263841198988080449794324522372e-01 1.64017236442103790487745396120545e-03
 	 3.11040487235050899794686074528727e-01 6.76263841198988080449794324522372e-01 1.26956715659609486318570858998100e-02 1.64017236442103790487745396120545e-03
 	 1.26956715659609486318570858998100e-02 3.11040487235050899794686074528727e-01 6.76263841198988080449794324522372e-01 1.64017236442103790487745396120545e-03
 	 1.26956715659609486318570858998100e-02 6.76263841198988080449794324522372e-01 3.11040487235050899794686074528727e-01 1.64017236442103790487745396120545e-03
 	 6.76263841198988080449794324522372e-01 3.11040487235050899794686074528727e-01 1.26956715659609486318570858998100e-02 1.64017236442103790487745396120545e-03
 	 6.76263841198988080449794324522372e-01 1.26956715659609486318570858998100e-02 3.11040487235050899794686074528727e-01 1.64017236442103790487745396120545e-03
 	 1.85623876299053219840473616386589e-01 8.79015352488810713937894547598262e-02 7.26474588452065694887949121039128e-01 3.67167139317773564416436116175646e-03
 	 1.85623876299053219840473616386589e-01 7.26474588452065694887949121039128e-01 8.79015352488810713937894547598262e-02 3.67167139317773564416436116175646e-03
 	 8.79015352488810713937894547598262e-02 1.85623876299053219840473616386589e-01 7.26474588452065694887949121039128e-01 3.67167139317773564416436116175646e-03
 	 8.79015352488810713937894547598262e-02 7.26474588452065694887949121039128e-01 1.85623876299053219840473616386589e-01 3.67167139317773564416436116175646e-03
 	 7.26474588452065694887949121039128e-01 1.85623876299053219840473616386589e-01 8.79015352488810713937894547598262e-02 3.67167139317773564416436116175646e-03
 	 7.26474588452065694887949121039128e-01 8.79015352488810713937894547598262e-02 1.85623876299053219840473616386589e-01 3.67167139317773564416436116175646e-03
 	 6.58626437608177683902255239445367e-02 3.07203461767424183814778615442265e-02 9.03417010062439795881061854743166e-01 1.41300494159943041024007914785443e-03
 	 6.58626437608177683902255239445367e-02 9.03417010062439795881061854743166e-01 3.07203461767424183814778615442265e-02 1.41300494159943041024007914785443e-03
 	 3.07203461767424183814778615442265e-02 6.58626437608177683902255239445367e-02 9.03417010062439795881061854743166e-01 1.41300494159943041024007914785443e-03
 	 3.07203461767424183814778615442265e-02 9.03417010062439795881061854743166e-01 6.58626437608177683902255239445367e-02 1.41300494159943041024007914785443e-03
 	 9.03417010062439795881061854743166e-01 6.58626437608177683902255239445367e-02 3.07203461767424183814778615442265e-02 1.41300494159943041024007914785443e-03
 	 9.03417010062439795881061854743166e-01 3.07203461767424183814778615442265e-02 6.58626437608177683902255239445367e-02 1.41300494159943041024007914785443e-03
 	 3.01590470095362273017514098683023e-01 2.81455063987638438166571930310056e-03 6.95594979264761437143249622749863e-01 7.64442000862078038271596458486101e-04
 	 3.01590470095362273017514098683023e-01 6.95594979264761437143249622749863e-01 2.81455063987638438166571930310056e-03 7.64442000862078038271596458486101e-04
 	 2.81455063987638438166571930310056e-03 3.01590470095362273017514098683023e-01 6.95594979264761437143249622749863e-01 7.64442000862078038271596458486101e-04
 	 2.81455063987638438166571930310056e-03 6.95594979264761437143249622749863e-01 3.01590470095362273017514098683023e-01 7.64442000862078038271596458486101e-04
 	 6.95594979264761437143249622749863e-01 3.01590470095362273017514098683023e-01 2.81455063987638438166571930310056e-03 7.64442000862078038271596458486101e-04
 	 6.95594979264761437143249622749863e-01 2.81455063987638438166571930310056e-03 3.01590470095362273017514098683023e-01 7.64442000862078038271596458486101e-04
 	 2.92542657654236315512008559380774e-01 7.98394163722915967129623027176422e-02 6.27617925973472101652816945716040e-01 3.95403162605319994510333359016840e-03
 	 2.92542657654236315512008559380774e-01 6.27617925973472101652816945716040e-01 7.98394163722915967129623027176422e-02 3.95403162605319994510333359016840e-03
 	 7.98394163722915967129623027176422e-02 2.92542657654236315512008559380774e-01 6.27617925973472101652816945716040e-01 3.95403162605319994510333359016840e-03
 	 7.98394163722915967129623027176422e-02 6.27617925973472101652816945716040e-01 2.92542657654236315512008559380774e-01 3.95403162605319994510333359016840e-03
 	 6.27617925973472101652816945716040e-01 2.92542657654236315512008559380774e-01 7.98394163722915967129623027176422e-02 3.95403162605319994510333359016840e-03
 	 6.27617925973472101652816945716040e-01 7.98394163722915967129623027176422e-02 2.92542657654236315512008559380774e-01 3.95403162605319994510333359016840e-03
 	 2.73024847528849125277705667258488e-02 1.33211979027671369862906303183081e-02 9.59376317344348028548495221912162e-01 6.44833544957115279219750370032216e-04
 	 2.73024847528849125277705667258488e-02 9.59376317344348028548495221912162e-01 1.33211979027671369862906303183081e-02 6.44833544957115279219750370032216e-04
 	 1.33211979027671369862906303183081e-02 2.73024847528849125277705667258488e-02 9.59376317344348028548495221912162e-01 6.44833544957115279219750370032216e-04
 	 1.33211979027671369862906303183081e-02 9.59376317344348028548495221912162e-01 2.73024847528849125277705667258488e-02 6.44833544957115279219750370032216e-04
 	 9.59376317344348028548495221912162e-01 2.73024847528849125277705667258488e-02 1.33211979027671369862906303183081e-02 6.44833544957115279219750370032216e-04
 	 9.59376317344348028548495221912162e-01 1.33211979027671369862906303183081e-02 2.73024847528849125277705667258488e-02 6.44833544957115279219750370032216e-04
 	 3.71571920577544234642886067376821e-01 9.60218601811555806657683120874935e-03 6.18825893404340132697427634411724e-01 1.55475690253807641294514496621559e-03
 	 3.71571920577544234642886067376821e-01 6.18825893404340132697427634411724e-01 9.60218601811555806657683120874935e-03 1.55475690253807641294514496621559e-03
 	 9.60218601811555806657683120874935e-03 3.71571920577544234642886067376821e-01 6.18825893404340132697427634411724e-01 1.55475690253807641294514496621559e-03
 	 9.60218601811555806657683120874935e-03 6.18825893404340132697427634411724e-01 3.71571920577544234642886067376821e-01 1.55475690253807641294514496621559e-03
 	 6.18825893404340132697427634411724e-01 3.71571920577544234642886067376821e-01 9.60218601811555806657683120874935e-03 1.55475690253807641294514496621559e-03
 	 6.18825893404340132697427634411724e-01 9.60218601811555806657683120874935e-03 3.71571920577544234642886067376821e-01 1.55475690253807641294514496621559e-03
 	 2.01007303993687103105258984214743e-01 2.50243738523270699627976121348638e-03 7.96490258621080249312740306777414e-01 6.26479792481225272043898755214286e-04
 	 2.01007303993687103105258984214743e-01 7.96490258621080249312740306777414e-01 2.50243738523270699627976121348638e-03 6.26479792481225272043898755214286e-04
 	 2.50243738523270699627976121348638e-03 2.01007303993687103105258984214743e-01 7.96490258621080249312740306777414e-01 6.26479792481225272043898755214286e-04
 	 2.50243738523270699627976121348638e-03 7.96490258621080249312740306777414e-01 2.01007303993687103105258984214743e-01 6.26479792481225272043898755214286e-04
 	 7.96490258621080249312740306777414e-01 2.01007303993687103105258984214743e-01 2.50243738523270699627976121348638e-03 6.26479792481225272043898755214286e-04
 	 7.96490258621080249312740306777414e-01 2.50243738523270699627976121348638e-03 2.01007303993687103105258984214743e-01 6.26479792481225272043898755214286e-04
 	 2.93183129372266426670989858394023e-01 2.01730828065996542486359999202250e-01 5.05086042561737058598225758032640e-01 5.99180575017385901731570285733142e-03
 	 2.93183129372266426670989858394023e-01 5.05086042561737058598225758032640e-01 2.01730828065996542486359999202250e-01 5.99180575017385901731570285733142e-03
 	 2.01730828065996542486359999202250e-01 2.93183129372266426670989858394023e-01 5.05086042561737058598225758032640e-01 5.99180575017385901731570285733142e-03
 	 2.01730828065996542486359999202250e-01 5.05086042561737058598225758032640e-01 2.93183129372266426670989858394023e-01 5.99180575017385901731570285733142e-03
 	 5.05086042561737058598225758032640e-01 2.93183129372266426670989858394023e-01 2.01730828065996542486359999202250e-01 5.99180575017385901731570285733142e-03
 	 5.05086042561737058598225758032640e-01 2.01730828065996542486359999202250e-01 2.93183129372266426670989858394023e-01 5.99180575017385901731570285733142e-03
 	 2.33331891103622568461872788248002e-01 5.26776823006486205613896345312241e-02 7.13990426595728755465586345962947e-01 3.05841781456401076710882591669360e-03
 	 2.33331891103622568461872788248002e-01 7.13990426595728755465586345962947e-01 5.26776823006486205613896345312241e-02 3.05841781456401076710882591669360e-03
 	 5.26776823006486205613896345312241e-02 2.33331891103622568461872788248002e-01 7.13990426595728755465586345962947e-01 3.05841781456401076710882591669360e-03
 	 5.26776823006486205613896345312241e-02 7.13990426595728755465586345962947e-01 2.33331891103622568461872788248002e-01 3.05841781456401076710882591669360e-03
 	 7.13990426595728755465586345962947e-01 2.33331891103622568461872788248002e-01 5.26776823006486205613896345312241e-02 3.05841781456401076710882591669360e-03
 	 7.13990426595728755465586345962947e-01 5.26776823006486205613896345312241e-02 2.33331891103622568461872788248002e-01 3.05841781456401076710882591669360e-03
 	 1.79299141897004327139697466009238e-01 5.57691461107685942932832290352962e-02 7.64931711992227092444807112769922e-01 2.99640790415312647729240147498331e-03
 	 1.79299141897004327139697466009238e-01 7.64931711992227092444807112769922e-01 5.57691461107685942932832290352962e-02 2.99640790415312647729240147498331e-03
 	 5.57691461107685942932832290352962e-02 1.79299141897004327139697466009238e-01 7.64931711992227092444807112769922e-01 2.99640790415312647729240147498331e-03
 	 5.57691461107685942932832290352962e-02 7.64931711992227092444807112769922e-01 1.79299141897004327139697466009238e-01 2.99640790415312647729240147498331e-03
 	 7.64931711992227092444807112769922e-01 1.79299141897004327139697466009238e-01 5.57691461107685942932832290352962e-02 2.99640790415312647729240147498331e-03
 	 7.64931711992227092444807112769922e-01 5.57691461107685942932832290352962e-02 1.79299141897004327139697466009238e-01 2.99640790415312647729240147498331e-03
 	 2.93435331129092979995931500525330e-01 4.82367013092171934007801326060871e-02 6.58327967561689875175545694219181e-01 3.23337358331722644205763472768922e-03
 	 2.93435331129092979995931500525330e-01 6.58327967561689875175545694219181e-01 4.82367013092171934007801326060871e-02 3.23337358331722644205763472768922e-03
 	 4.82367013092171934007801326060871e-02 2.93435331129092979995931500525330e-01 6.58327967561689875175545694219181e-01 3.23337358331722644205763472768922e-03
 	 4.82367013092171934007801326060871e-02 6.58327967561689875175545694219181e-01 2.93435331129092979995931500525330e-01 3.23337358331722644205763472768922e-03
 	 6.58327967561689875175545694219181e-01 2.93435331129092979995931500525330e-01 4.82367013092171934007801326060871e-02 3.23337358331722644205763472768922e-03
 	 6.58327967561689875175545694219181e-01 4.82367013092171934007801326060871e-02 2.93435331129092979995931500525330e-01 3.23337358331722644205763472768922e-03
 	 3.29840596275619235555609520815779e-01 2.33697583553122173460891985996568e-01 4.36461820171258563227922877558740e-01 6.64636436497996908184804354391417e-03
 	 3.29840596275619235555609520815779e-01 4.36461820171258563227922877558740e-01 2.33697583553122173460891985996568e-01 6.64636436497996908184804354391417e-03
 	 2.33697583553122173460891985996568e-01 3.29840596275619235555609520815779e-01 4.36461820171258563227922877558740e-01 6.64636436497996908184804354391417e-03
 	 2.33697583553122173460891985996568e-01 4.36461820171258563227922877558740e-01 3.29840596275619235555609520815779e-01 6.64636436497996908184804354391417e-03
 	 4.36461820171258563227922877558740e-01 3.29840596275619235555609520815779e-01 2.33697583553122173460891985996568e-01 6.64636436497996908184804354391417e-03
 	 4.36461820171258563227922877558740e-01 2.33697583553122173460891985996568e-01 3.29840596275619235555609520815779e-01 6.64636436497996908184804354391417e-03
 	 1.38175693611527594661936291231541e-01 9.26621506087761254155665824328025e-02 7.69162155779696266044709318521200e-01 3.19490493290886055227639772624570e-03
 	 1.38175693611527594661936291231541e-01 7.69162155779696266044709318521200e-01 9.26621506087761254155665824328025e-02 3.19490493290886055227639772624570e-03
 	 9.26621506087761254155665824328025e-02 1.38175693611527594661936291231541e-01 7.69162155779696266044709318521200e-01 3.19490493290886055227639772624570e-03
 	 9.26621506087761254155665824328025e-02 7.69162155779696266044709318521200e-01 1.38175693611527594661936291231541e-01 3.19490493290886055227639772624570e-03
 	 7.69162155779696266044709318521200e-01 1.38175693611527594661936291231541e-01 9.26621506087761254155665824328025e-02 3.19490493290886055227639772624570e-03
 	 7.69162155779696266044709318521200e-01 9.26621506087761254155665824328025e-02 1.38175693611527594661936291231541e-01 3.19490493290886055227639772624570e-03
 	 3.58512865776101086190408295806265e-01 1.73454768103072393126140582353401e-01 4.68032366120826548439026737469248e-01 6.16199168297773894331648136812873e-03
 	 3.58512865776101086190408295806265e-01 4.68032366120826548439026737469248e-01 1.73454768103072393126140582353401e-01 6.16199168297773894331648136812873e-03
 	 1.73454768103072393126140582353401e-01 3.58512865776101086190408295806265e-01 4.68032366120826548439026737469248e-01 6.16199168297773894331648136812873e-03
 	 1.73454768103072393126140582353401e-01 4.68032366120826548439026737469248e-01 3.58512865776101086190408295806265e-01 6.16199168297773894331648136812873e-03
 	 4.68032366120826548439026737469248e-01 3.58512865776101086190408295806265e-01 1.73454768103072393126140582353401e-01 6.16199168297773894331648136812873e-03
 	 4.68032366120826548439026737469248e-01 1.73454768103072393126140582353401e-01 3.58512865776101086190408295806265e-01 6.16199168297773894331648136812873e-03
 	 4.20337783466548764454984166150098e-01 1.78508936465828042805537023696161e-02 5.61811322886868524939529834227869e-01 2.18381773128974946557301350935631e-03
 	 4.20337783466548764454984166150098e-01 5.61811322886868524939529834227869e-01 1.78508936465828042805537023696161e-02 2.18381773128974946557301350935631e-03
 	 1.78508936465828042805537023696161e-02 4.20337783466548764454984166150098e-01 5.61811322886868524939529834227869e-01 2.18381773128974946557301350935631e-03
 	 1.78508936465828042805537023696161e-02 5.61811322886868524939529834227869e-01 4.20337783466548764454984166150098e-01 2.18381773128974946557301350935631e-03
 	 5.61811322886868524939529834227869e-01 4.20337783466548764454984166150098e-01 1.78508936465828042805537023696161e-02 2.18381773128974946557301350935631e-03
 	 5.61811322886868524939529834227869e-01 1.78508936465828042805537023696161e-02 4.20337783466548764454984166150098e-01 2.18381773128974946557301350935631e-03
 	 2.79051133003480611449731441098265e-01 1.19946692495847162529543084019679e-01 6.01002174500672170509574243624229e-01 4.83822875359725141503064449466365e-03
 	 2.79051133003480611449731441098265e-01 6.01002174500672170509574243624229e-01 1.19946692495847162529543084019679e-01 4.83822875359725141503064449466365e-03
 	 1.19946692495847162529543084019679e-01 2.79051133003480611449731441098265e-01 6.01002174500672170509574243624229e-01 4.83822875359725141503064449466365e-03
 	 1.19946692495847162529543084019679e-01 6.01002174500672170509574243624229e-01 2.79051133003480611449731441098265e-01 4.83822875359725141503064449466365e-03
 	 6.01002174500672170509574243624229e-01 2.79051133003480611449731441098265e-01 1.19946692495847162529543084019679e-01 4.83822875359725141503064449466365e-03
 	 6.01002174500672170509574243624229e-01 1.19946692495847162529543084019679e-01 2.79051133003480611449731441098265e-01 4.83822875359725141503064449466365e-03
 	 9.34626722493710621053608633701515e-02 1.39846172517608963864477189531499e-02 8.92552710498867973853975854581222e-01 1.17094351950811125309681592909783e-03
 	 9.34626722493710621053608633701515e-02 8.92552710498867973853975854581222e-01 1.39846172517608963864477189531499e-02 1.17094351950811125309681592909783e-03
 	 1.39846172517608963864477189531499e-02 9.34626722493710621053608633701515e-02 8.92552710498867973853975854581222e-01 1.17094351950811125309681592909783e-03
 	 1.39846172517608963864477189531499e-02 8.92552710498867973853975854581222e-01 9.34626722493710621053608633701515e-02 1.17094351950811125309681592909783e-03
 	 8.92552710498867973853975854581222e-01 9.34626722493710621053608633701515e-02 1.39846172517608963864477189531499e-02 1.17094351950811125309681592909783e-03
 	 8.92552710498867973853975854581222e-01 1.39846172517608963864477189531499e-02 9.34626722493710621053608633701515e-02 1.17094351950811125309681592909783e-03
 	 3.87408987689019879141483215789776e-01 1.19357764315077496952710589539493e-01 4.93233247995902623905806194670731e-01 5.40749685643983520055844138596512e-03
 	 3.87408987689019879141483215789776e-01 4.93233247995902623905806194670731e-01 1.19357764315077496952710589539493e-01 5.40749685643983520055844138596512e-03
 	 1.19357764315077496952710589539493e-01 3.87408987689019879141483215789776e-01 4.93233247995902623905806194670731e-01 5.40749685643983520055844138596512e-03
 	 1.19357764315077496952710589539493e-01 4.93233247995902623905806194670731e-01 3.87408987689019879141483215789776e-01 5.40749685643983520055844138596512e-03
 	 4.93233247995902623905806194670731e-01 3.87408987689019879141483215789776e-01 1.19357764315077496952710589539493e-01 5.40749685643983520055844138596512e-03
 	 4.93233247995902623905806194670731e-01 1.19357764315077496952710589539493e-01 3.87408987689019879141483215789776e-01 5.40749685643983520055844138596512e-03
 	 4.07184695661520157372592620959040e-01 7.35846549853617637459990419301903e-02 5.19230649353118023370257105852943e-01 4.53338912374901936014337522351525e-03
 	 4.07184695661520157372592620959040e-01 5.19230649353118023370257105852943e-01 7.35846549853617637459990419301903e-02 4.53338912374901936014337522351525e-03
 	 7.35846549853617637459990419301903e-02 4.07184695661520157372592620959040e-01 5.19230649353118023370257105852943e-01 4.53338912374901936014337522351525e-03
 	 7.35846549853617637459990419301903e-02 5.19230649353118023370257105852943e-01 4.07184695661520157372592620959040e-01 4.53338912374901936014337522351525e-03
 	 5.19230649353118023370257105852943e-01 4.07184695661520157372592620959040e-01 7.35846549853617637459990419301903e-02 4.53338912374901936014337522351525e-03
 	 5.19230649353118023370257105852943e-01 7.35846549853617637459990419301903e-02 4.07184695661520157372592620959040e-01 4.53338912374901936014337522351525e-03
 	 1.87640583389709708628245721229177e-01 1.27167478485407797750283975801722e-02 7.99642668761749497718938073376194e-01 1.52684444453663717596036963897177e-03
 	 1.87640583389709708628245721229177e-01 7.99642668761749497718938073376194e-01 1.27167478485407797750283975801722e-02 1.52684444453663717596036963897177e-03
 	 1.27167478485407797750283975801722e-02 1.87640583389709708628245721229177e-01 7.99642668761749497718938073376194e-01 1.52684444453663717596036963897177e-03
 	 1.27167478485407797750283975801722e-02 7.99642668761749497718938073376194e-01 1.87640583389709708628245721229177e-01 1.52684444453663717596036963897177e-03
 	 7.99642668761749497718938073376194e-01 1.87640583389709708628245721229177e-01 1.27167478485407797750283975801722e-02 1.52684444453663717596036963897177e-03
 	 7.99642668761749497718938073376194e-01 1.27167478485407797750283975801722e-02 1.87640583389709708628245721229177e-01 1.52684444453663717596036963897177e-03
 	 1.52225526038276298690377075217839e-01 2.44038040768785029904774930287203e-03 8.45334093554035770345933542557759e-01 5.98555758752111017814701021677593e-04
 	 1.52225526038276298690377075217839e-01 8.45334093554035770345933542557759e-01 2.44038040768785029904774930287203e-03 5.98555758752111017814701021677593e-04
 	 2.44038040768785029904774930287203e-03 1.52225526038276298690377075217839e-01 8.45334093554035770345933542557759e-01 5.98555758752111017814701021677593e-04
 	 2.44038040768785029904774930287203e-03 8.45334093554035770345933542557759e-01 1.52225526038276298690377075217839e-01 5.98555758752111017814701021677593e-04
 	 8.45334093554035770345933542557759e-01 1.52225526038276298690377075217839e-01 2.44038040768785029904774930287203e-03 5.98555758752111017814701021677593e-04
 	 8.45334093554035770345933542557759e-01 2.44038040768785029904774930287203e-03 1.52225526038276298690377075217839e-01 5.98555758752111017814701021677593e-04
 	 1.74142001786563360710147208010312e-01 1.29890625977294477122470084395900e-01 6.95967372236142134411807091964874e-01 4.22133743140726096221282404030717e-03
 	 1.74142001786563360710147208010312e-01 6.95967372236142134411807091964874e-01 1.29890625977294477122470084395900e-01 4.22133743140726096221282404030717e-03
 	 1.29890625977294477122470084395900e-01 1.74142001786563360710147208010312e-01 6.95967372236142134411807091964874e-01 4.22133743140726096221282404030717e-03
 	 1.29890625977294477122470084395900e-01 6.95967372236142134411807091964874e-01 1.74142001786563360710147208010312e-01 4.22133743140726096221282404030717e-03
 	 6.95967372236142134411807091964874e-01 1.74142001786563360710147208010312e-01 1.29890625977294477122470084395900e-01 4.22133743140726096221282404030717e-03
 	 6.95967372236142134411807091964874e-01 1.29890625977294477122470084395900e-01 1.74142001786563360710147208010312e-01 4.22133743140726096221282404030717e-03
 	 3.21408155175526122349083379958756e-01 1.43880630387304531137004914853605e-01 5.34711214437169291002760473929811e-01 5.51456223133949419851207451870323e-03
 	 3.21408155175526122349083379958756e-01 5.34711214437169291002760473929811e-01 1.43880630387304531137004914853605e-01 5.51456223133949419851207451870323e-03
 	 1.43880630387304531137004914853605e-01 3.21408155175526122349083379958756e-01 5.34711214437169291002760473929811e-01 5.51456223133949419851207451870323e-03
 	 1.43880630387304531137004914853605e-01 5.34711214437169291002760473929811e-01 3.21408155175526122349083379958756e-01 5.51456223133949419851207451870323e-03
 	 5.34711214437169291002760473929811e-01 3.21408155175526122349083379958756e-01 1.43880630387304531137004914853605e-01 5.51456223133949419851207451870323e-03
 	 5.34711214437169291002760473929811e-01 1.43880630387304531137004914853605e-01 3.21408155175526122349083379958756e-01 5.51456223133949419851207451870323e-03
 	 8.88043361734264791174098263581982e-02 5.88598092883567541866440819831041e-02 8.52335854538216697307007052586414e-01 2.33717780991066562124025551838713e-03
 	 8.88043361734264791174098263581982e-02 8.52335854538216697307007052586414e-01 5.88598092883567541866440819831041e-02 2.33717780991066562124025551838713e-03
 	 5.88598092883567541866440819831041e-02 8.88043361734264791174098263581982e-02 8.52335854538216697307007052586414e-01 2.33717780991066562124025551838713e-03
 	 5.88598092883567541866440819831041e-02 8.52335854538216697307007052586414e-01 8.88043361734264791174098263581982e-02 2.33717780991066562124025551838713e-03
 	 8.52335854538216697307007052586414e-01 8.88043361734264791174098263581982e-02 5.88598092883567541866440819831041e-02 2.33717780991066562124025551838713e-03
 	 8.52335854538216697307007052586414e-01 5.88598092883567541866440819831041e-02 8.88043361734264791174098263581982e-02 2.33717780991066562124025551838713e-03
 	 1.30428915551712210074697395612020e-01 6.02973413848093622857682305493654e-02 8.09273743063478434578428277745843e-01 2.78798895267969807504337964587648e-03
 	 1.30428915551712210074697395612020e-01 8.09273743063478434578428277745843e-01 6.02973413848093622857682305493654e-02 2.78798895267969807504337964587648e-03
 	 6.02973413848093622857682305493654e-02 1.30428915551712210074697395612020e-01 8.09273743063478434578428277745843e-01 2.78798895267969807504337964587648e-03
 	 6.02973413848093622857682305493654e-02 8.09273743063478434578428277745843e-01 1.30428915551712210074697395612020e-01 2.78798895267969807504337964587648e-03
 	 8.09273743063478434578428277745843e-01 1.30428915551712210074697395612020e-01 6.02973413848093622857682305493654e-02 2.78798895267969807504337964587648e-03
 	 8.09273743063478434578428277745843e-01 6.02973413848093622857682305493654e-02 1.30428915551712210074697395612020e-01 2.78798895267969807504337964587648e-03
 	 1.36837912722210020000090935354820e-01 1.32254525993588060300831799054322e-02 8.49936634678431168765655456809327e-01 1.43057499537056829856662698574610e-03
 	 1.36837912722210020000090935354820e-01 8.49936634678431168765655456809327e-01 1.32254525993588060300831799054322e-02 1.43057499537056829856662698574610e-03
 	 1.32254525993588060300831799054322e-02 1.36837912722210020000090935354820e-01 8.49936634678431168765655456809327e-01 1.43057499537056829856662698574610e-03
 	 1.32254525993588060300831799054322e-02 8.49936634678431168765655456809327e-01 1.36837912722210020000090935354820e-01 1.43057499537056829856662698574610e-03
 	 8.49936634678431168765655456809327e-01 1.36837912722210020000090935354820e-01 1.32254525993588060300831799054322e-02 1.43057499537056829856662698574610e-03
 	 8.49936634678431168765655456809327e-01 1.32254525993588060300831799054322e-02 1.36837912722210020000090935354820e-01 1.43057499537056829856662698574610e-03
 	 3.52853359179670589274024905535043e-01 5.72712595019886847036438837221795e-02 5.89875381318340830105739769351203e-01 3.97204224187744456969761941422803e-03
 	 3.52853359179670589274024905535043e-01 5.89875381318340830105739769351203e-01 5.72712595019886847036438837221795e-02 3.97204224187744456969761941422803e-03
 	 5.72712595019886847036438837221795e-02 3.52853359179670589274024905535043e-01 5.89875381318340830105739769351203e-01 3.97204224187744456969761941422803e-03
 	 5.72712595019886847036438837221795e-02 5.89875381318340830105739769351203e-01 3.52853359179670589274024905535043e-01 3.97204224187744456969761941422803e-03
 	 5.89875381318340830105739769351203e-01 3.52853359179670589274024905535043e-01 5.72712595019886847036438837221795e-02 3.97204224187744456969761941422803e-03
 	 5.89875381318340830105739769351203e-01 5.72712595019886847036438837221795e-02 3.52853359179670589274024905535043e-01 3.97204224187744456969761941422803e-03
 	 2.46386900217142157387684164859820e-01 1.09336475862860226654360573661506e-02 7.42679452196571832089944109611679e-01 1.62302142939108745567367009243753e-03
 	 2.46386900217142157387684164859820e-01 7.42679452196571832089944109611679e-01 1.09336475862860226654360573661506e-02 1.62302142939108745567367009243753e-03
 	 1.09336475862860226654360573661506e-02 2.46386900217142157387684164859820e-01 7.42679452196571832089944109611679e-01 1.62302142939108745567367009243753e-03
 	 1.09336475862860226654360573661506e-02 7.42679452196571832089944109611679e-01 2.46386900217142157387684164859820e-01 1.62302142939108745567367009243753e-03
 	 7.42679452196571832089944109611679e-01 2.46386900217142157387684164859820e-01 1.09336475862860226654360573661506e-02 1.62302142939108745567367009243753e-03
 	 7.42679452196571832089944109611679e-01 1.09336475862860226654360573661506e-02 2.46386900217142157387684164859820e-01 1.62302142939108745567367009243753e-03
 	 3.43520044059471285624596248453599e-01 9.59251650895475566072079232071701e-02 5.60554790850981254912710483040428e-01 4.83085487789508896683265959381970e-03
 	 3.43520044059471285624596248453599e-01 5.60554790850981254912710483040428e-01 9.59251650895475566072079232071701e-02 4.83085487789508896683265959381970e-03
 	 9.59251650895475566072079232071701e-02 3.43520044059471285624596248453599e-01 5.60554790850981254912710483040428e-01 4.83085487789508896683265959381970e-03
 	 9.59251650895475566072079232071701e-02 5.60554790850981254912710483040428e-01 3.43520044059471285624596248453599e-01 4.83085487789508896683265959381970e-03
 	 5.60554790850981254912710483040428e-01 3.43520044059471285624596248453599e-01 9.59251650895475566072079232071701e-02 4.83085487789508896683265959381970e-03
 	 5.60554790850981254912710483040428e-01 9.59251650895475566072079232071701e-02 3.43520044059471285624596248453599e-01 4.83085487789508896683265959381970e-03
 	 4.16208963636464202018316882458748e-01 3.96704297157567664644517435590387e-02 5.44120606647779059272806989611126e-01 3.53967881614650203836447417415911e-03
 	 4.16208963636464202018316882458748e-01 5.44120606647779059272806989611126e-01 3.96704297157567664644517435590387e-02 3.53967881614650203836447417415911e-03
 	 3.96704297157567664644517435590387e-02 4.16208963636464202018316882458748e-01 5.44120606647779059272806989611126e-01 3.53967881614650203836447417415911e-03
 	 3.96704297157567664644517435590387e-02 5.44120606647779059272806989611126e-01 4.16208963636464202018316882458748e-01 3.53967881614650203836447417415911e-03
 	 5.44120606647779059272806989611126e-01 4.16208963636464202018316882458748e-01 3.96704297157567664644517435590387e-02 3.53967881614650203836447417415911e-03
 	 5.44120606647779059272806989611126e-01 3.96704297157567664644517435590387e-02 4.16208963636464202018316882458748e-01 3.53967881614650203836447417415911e-03
 	 3.90118106999857716665758289309451e-02 2.79504775052941568241893222079852e-03 9.58193141549484872498965160048101e-01 3.67065989418061231104595254493006e-04
 	 3.90118106999857716665758289309451e-02 9.58193141549484872498965160048101e-01 2.79504775052941568241893222079852e-03 3.67065989418061231104595254493006e-04
 	 2.79504775052941568241893222079852e-03 3.90118106999857716665758289309451e-02 9.58193141549484872498965160048101e-01 3.67065989418061231104595254493006e-04
 	 2.79504775052941568241893222079852e-03 9.58193141549484872498965160048101e-01 3.90118106999857716665758289309451e-02 3.67065989418061231104595254493006e-04
 	 9.58193141549484872498965160048101e-01 3.90118106999857716665758289309451e-02 2.79504775052941568241893222079852e-03 3.67065989418061231104595254493006e-04
 	 9.58193141549484872498965160048101e-01 2.79504775052941568241893222079852e-03 3.90118106999857716665758289309451e-02 3.67065989418061231104595254493006e-04
 	 1.07180714134606072662769804537675e-01 2.66661165267688318042393902373988e-03 8.90152674212717043289444518450182e-01 5.70969909404181680603884707636553e-04
 	 1.07180714134606072662769804537675e-01 8.90152674212717043289444518450182e-01 2.66661165267688318042393902373988e-03 5.70969909404181680603884707636553e-04
 	 2.66661165267688318042393902373988e-03 1.07180714134606072662769804537675e-01 8.90152674212717043289444518450182e-01 5.70969909404181680603884707636553e-04
 	 2.66661165267688318042393902373988e-03 8.90152674212717043289444518450182e-01 1.07180714134606072662769804537675e-01 5.70969909404181680603884707636553e-04
 	 8.90152674212717043289444518450182e-01 1.07180714134606072662769804537675e-01 2.66661165267688318042393902373988e-03 5.70969909404181680603884707636553e-04
 	 8.90152674212717043289444518450182e-01 2.66661165267688318042393902373988e-03 1.07180714134606072662769804537675e-01 5.70969909404181680603884707636553e-04
 	 4.26423819706326090450687615884817e-01 2.53953007625778645617309337012557e-03 5.71036650217416119623692338791443e-01 8.76113539168821872475667600355109e-04
 	 4.26423819706326090450687615884817e-01 5.71036650217416119623692338791443e-01 2.53953007625778645617309337012557e-03 8.76113539168821872475667600355109e-04
 	 2.53953007625778645617309337012557e-03 4.26423819706326090450687615884817e-01 5.71036650217416119623692338791443e-01 8.76113539168821872475667600355109e-04
 	 2.53953007625778645617309337012557e-03 5.71036650217416119623692338791443e-01 4.26423819706326090450687615884817e-01 8.76113539168821872475667600355109e-04
 	 5.71036650217416119623692338791443e-01 4.26423819706326090450687615884817e-01 2.53953007625778645617309337012557e-03 8.76113539168821872475667600355109e-04
 	 5.71036650217416119623692338791443e-01 2.53953007625778645617309337012557e-03 4.26423819706326090450687615884817e-01 8.76113539168821872475667600355109e-04
 	 3.51960131363829642481277915067039e-01 2.87313755582887971062877596750695e-02 6.19308493077881605515244700654875e-01 3.08711097492416451648633568538571e-03
 	 3.51960131363829642481277915067039e-01 6.19308493077881605515244700654875e-01 2.87313755582887971062877596750695e-02 3.08711097492416451648633568538571e-03
 	 2.87313755582887971062877596750695e-02 3.51960131363829642481277915067039e-01 6.19308493077881605515244700654875e-01 3.08711097492416451648633568538571e-03
 	 2.87313755582887971062877596750695e-02 6.19308493077881605515244700654875e-01 3.51960131363829642481277915067039e-01 3.08711097492416451648633568538571e-03
 	 6.19308493077881605515244700654875e-01 3.51960131363829642481277915067039e-01 2.87313755582887971062877596750695e-02 3.08711097492416451648633568538571e-03
 	 6.19308493077881605515244700654875e-01 2.87313755582887971062877596750695e-02 3.51960131363829642481277915067039e-01 3.08711097492416451648633568538571e-03
 	 ];
 
 	 case  46 

 	 % ALG. DEG.:   46
 	 % PTS CARD.:  385
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.4e-15  

 	 xyw_bar=[
 	 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 3.33333333333333314829616256247391e-01 6.63504712320718819523746034860778e-03
 	 4.79162709481021131807665369706228e-01 4.79162709481021131807665369706228e-01 4.16745810379577363846692605875432e-02 1.50636238789958920754330495839213e-03
 	 4.79162709481021131807665369706228e-01 4.16745810379577363846692605875432e-02 4.79162709481021131807665369706228e-01 1.50636238789958920754330495839213e-03
 	 4.16745810379577363846692605875432e-02 4.79162709481021131807665369706228e-01 4.79162709481021131807665369706228e-01 1.50636238789958920754330495839213e-03
 	 4.86830795833199034272631422481936e-02 4.86830795833199034272631422481936e-02 9.02633840833360179267685907689156e-01 1.24746918164534781672814212072353e-03
 	 4.86830795833199034272631422481936e-02 9.02633840833360179267685907689156e-01 4.86830795833199034272631422481936e-02 1.24746918164534781672814212072353e-03
 	 9.02633840833360179267685907689156e-01 4.86830795833199034272631422481936e-02 4.86830795833199034272631422481936e-02 1.24746918164534781672814212072353e-03
 	 4.86849434452578500032160491173272e-01 4.86849434452578500032160491173272e-01 2.63011310948429999356790176534560e-02 2.18951638330011676483732863118803e-03
 	 4.86849434452578500032160491173272e-01 2.63011310948429999356790176534560e-02 4.86849434452578500032160491173272e-01 2.18951638330011676483732863118803e-03
 	 2.63011310948429999356790176534560e-02 4.86849434452578500032160491173272e-01 4.86849434452578500032160491173272e-01 2.18951638330011676483732863118803e-03
 	 1.96294809229449501719599879834277e-01 1.96294809229449501719599879834277e-01 6.07410381541100941049649009073619e-01 4.53261651834184920578652011613485e-03
 	 1.96294809229449501719599879834277e-01 6.07410381541100941049649009073619e-01 1.96294809229449501719599879834277e-01 4.53261651834184920578652011613485e-03
 	 6.07410381541100941049649009073619e-01 1.96294809229449501719599879834277e-01 1.96294809229449501719599879834277e-01 4.53261651834184920578652011613485e-03
 	 1.65798716567095938412279565454810e-01 1.65798716567095938412279565454810e-01 6.68402566865808123175440869090380e-01 4.11213355121611227188660464548775e-03
 	 1.65798716567095938412279565454810e-01 6.68402566865808123175440869090380e-01 1.65798716567095938412279565454810e-01 4.11213355121611227188660464548775e-03
 	 6.68402566865808123175440869090380e-01 1.65798716567095938412279565454810e-01 1.65798716567095938412279565454810e-01 4.11213355121611227188660464548775e-03
 	 2.29007117787044606194157836398517e-01 2.29007117787044606194157836398517e-01 5.41985764425910732100533095945138e-01 5.33628399786334299548240522881315e-03
 	 2.29007117787044606194157836398517e-01 5.41985764425910732100533095945138e-01 2.29007117787044606194157836398517e-01 5.33628399786334299548240522881315e-03
 	 5.41985764425910732100533095945138e-01 2.29007117787044606194157836398517e-01 2.29007117787044606194157836398517e-01 5.33628399786334299548240522881315e-03
 	 2.99898101879728595786644973486545e-01 2.99898101879728595786644973486545e-01 4.00203796240542808426710053026909e-01 6.47562192782264508389422630330046e-03
 	 2.99898101879728595786644973486545e-01 4.00203796240542808426710053026909e-01 2.99898101879728595786644973486545e-01 6.47562192782264508389422630330046e-03
 	 4.00203796240542808426710053026909e-01 2.99898101879728595786644973486545e-01 2.99898101879728595786644973486545e-01 6.47562192782264508389422630330046e-03
 	 3.66081261411425384899587243126007e-01 3.66081261411425384899587243126007e-01 2.67837477177149230200825513747986e-01 6.52831694543144422371305779506656e-03
 	 3.66081261411425384899587243126007e-01 2.67837477177149230200825513747986e-01 3.66081261411425384899587243126007e-01 6.52831694543144422371305779506656e-03
 	 2.67837477177149230200825513747986e-01 3.66081261411425384899587243126007e-01 3.66081261411425384899587243126007e-01 6.52831694543144422371305779506656e-03
 	 3.07693439520817652033102262976172e-02 3.07693439520817652033102262976172e-02 9.38461312095836497348955163033679e-01 9.71709700137126839401824351938330e-04
 	 3.07693439520817652033102262976172e-02 9.38461312095836497348955163033679e-01 3.07693439520817652033102262976172e-02 9.71709700137126839401824351938330e-04
 	 9.38461312095836497348955163033679e-01 3.07693439520817652033102262976172e-02 3.07693439520817652033102262976172e-02 9.71709700137126839401824351938330e-04
 	 8.24986937635582839867254278942710e-02 8.24986937635582839867254278942710e-02 8.35002612472883432026549144211458e-01 2.43869790147542781291734037552033e-03
 	 8.24986937635582839867254278942710e-02 8.35002612472883432026549144211458e-01 8.24986937635582839867254278942710e-02 2.43869790147542781291734037552033e-03
 	 8.35002612472883432026549144211458e-01 8.24986937635582839867254278942710e-02 8.24986937635582839867254278942710e-02 2.43869790147542781291734037552033e-03
 	 4.60823004347588105478195075193071e-01 4.60823004347588105478195075193071e-01 7.83539913048237890436098496138584e-02 4.18820407177640779278204874458424e-03
 	 4.60823004347588105478195075193071e-01 7.83539913048237890436098496138584e-02 4.60823004347588105478195075193071e-01 4.18820407177640779278204874458424e-03
 	 7.83539913048237890436098496138584e-02 4.60823004347588105478195075193071e-01 4.60823004347588105478195075193071e-01 4.18820407177640779278204874458424e-03
 	 2.66615708697696740525628911200329e-01 2.66615708697696740525628911200329e-01 4.66768582604606518948742177599343e-01 5.98627429647512459415237273674393e-03
 	 2.66615708697696740525628911200329e-01 4.66768582604606518948742177599343e-01 2.66615708697696740525628911200329e-01 5.98627429647512459415237273674393e-03
 	 4.66768582604606518948742177599343e-01 2.66615708697696740525628911200329e-01 2.66615708697696740525628911200329e-01 5.98627429647512459415237273674393e-03
 	 1.28439434947512254314716528824647e-01 1.28439434947512254314716528824647e-01 7.43121130104975491370566942350706e-01 3.77348015653308083150463403399044e-03
 	 1.28439434947512254314716528824647e-01 7.43121130104975491370566942350706e-01 1.28439434947512254314716528824647e-01 3.77348015653308083150463403399044e-03
 	 7.43121130104975491370566942350706e-01 1.28439434947512254314716528824647e-01 1.28439434947512254314716528824647e-01 3.77348015653308083150463403399044e-03
 	 3.97511575402048289440415373974247e-01 3.97511575402048289440415373974247e-01 2.04976849195903421119169252051506e-01 6.48164725448656560413684957211444e-03
 	 3.97511575402048289440415373974247e-01 2.04976849195903421119169252051506e-01 3.97511575402048289440415373974247e-01 6.48164725448656560413684957211444e-03
 	 2.04976849195903421119169252051506e-01 3.97511575402048289440415373974247e-01 3.97511575402048289440415373974247e-01 6.48164725448656560413684957211444e-03
 	 1.28796984358850331170431857685799e-02 1.28796984358850331170431857685799e-02 9.74240603128229909479784964787541e-01 4.49346710280046194880415599826051e-04
 	 1.28796984358850331170431857685799e-02 9.74240603128229909479784964787541e-01 1.28796984358850331170431857685799e-02 4.49346710280046194880415599826051e-04
 	 9.74240603128229909479784964787541e-01 1.28796984358850331170431857685799e-02 1.28796984358850331170431857685799e-02 4.49346710280046194880415599826051e-04
 	 4.92922242405799231057539344647012e-04 4.92922242405799231057539344647012e-04 9.99014155515188351230904117983300e-01 1.40952201359505446516887094965398e-05
 	 4.92922242405799231057539344647012e-04 9.99014155515188351230904117983300e-01 4.92922242405799231057539344647012e-04 1.40952201359505446516887094965398e-05
 	 9.99014155515188351230904117983300e-01 4.92922242405799231057539344647012e-04 4.92922242405799231057539344647012e-04 1.40952201359505446516887094965398e-05
 	 3.97969764640709822156594555053744e-01 1.54123149166077250127315778627235e-01 4.47907086193212844449362819432281e-01 4.45370818693301660784467088660676e-03
 	 3.97969764640709822156594555053744e-01 4.47907086193212844449362819432281e-01 1.54123149166077250127315778627235e-01 4.45370818693301660784467088660676e-03
 	 1.54123149166077250127315778627235e-01 3.97969764640709822156594555053744e-01 4.47907086193212844449362819432281e-01 4.45370818693301660784467088660676e-03
 	 1.54123149166077250127315778627235e-01 4.47907086193212844449362819432281e-01 3.97969764640709822156594555053744e-01 4.45370818693301660784467088660676e-03
 	 4.47907086193212844449362819432281e-01 3.97969764640709822156594555053744e-01 1.54123149166077250127315778627235e-01 4.45370818693301660784467088660676e-03
 	 4.47907086193212844449362819432281e-01 1.54123149166077250127315778627235e-01 3.97969764640709822156594555053744e-01 4.45370818693301660784467088660676e-03
 	 4.14307607988175785607154466561042e-01 1.13136705924023417413337710968335e-01 4.72555686087800796979507822470623e-01 4.32000952464165009075935941496027e-03
 	 4.14307607988175785607154466561042e-01 4.72555686087800796979507822470623e-01 1.13136705924023417413337710968335e-01 4.32000952464165009075935941496027e-03
 	 1.13136705924023417413337710968335e-01 4.14307607988175785607154466561042e-01 4.72555686087800796979507822470623e-01 4.32000952464165009075935941496027e-03
 	 1.13136705924023417413337710968335e-01 4.72555686087800796979507822470623e-01 4.14307607988175785607154466561042e-01 4.32000952464165009075935941496027e-03
 	 4.72555686087800796979507822470623e-01 4.14307607988175785607154466561042e-01 1.13136705924023417413337710968335e-01 4.32000952464165009075935941496027e-03
 	 4.72555686087800796979507822470623e-01 1.13136705924023417413337710968335e-01 4.14307607988175785607154466561042e-01 4.32000952464165009075935941496027e-03
 	 3.29728249876623691339005972622545e-01 7.30183277797032820322087331987859e-02 5.97253422343673068262148717622040e-01 3.08687965593893711910289390232265e-03
 	 3.29728249876623691339005972622545e-01 5.97253422343673068262148717622040e-01 7.30183277797032820322087331987859e-02 3.08687965593893711910289390232265e-03
 	 7.30183277797032820322087331987859e-02 3.29728249876623691339005972622545e-01 5.97253422343673068262148717622040e-01 3.08687965593893711910289390232265e-03
 	 7.30183277797032820322087331987859e-02 5.97253422343673068262148717622040e-01 3.29728249876623691339005972622545e-01 3.08687965593893711910289390232265e-03
 	 5.97253422343673068262148717622040e-01 3.29728249876623691339005972622545e-01 7.30183277797032820322087331987859e-02 3.08687965593893711910289390232265e-03
 	 5.97253422343673068262148717622040e-01 7.30183277797032820322087331987859e-02 3.29728249876623691339005972622545e-01 3.08687965593893711910289390232265e-03
 	 2.25759242330057757763839276776707e-01 1.09803376807363559097829863731022e-01 6.64437380862578752527269898564555e-01 3.43022581548034152798543061635428e-03
 	 2.25759242330057757763839276776707e-01 6.64437380862578752527269898564555e-01 1.09803376807363559097829863731022e-01 3.43022581548034152798543061635428e-03
 	 1.09803376807363559097829863731022e-01 2.25759242330057757763839276776707e-01 6.64437380862578752527269898564555e-01 3.43022581548034152798543061635428e-03
 	 1.09803376807363559097829863731022e-01 6.64437380862578752527269898564555e-01 2.25759242330057757763839276776707e-01 3.43022581548034152798543061635428e-03
 	 6.64437380862578752527269898564555e-01 2.25759242330057757763839276776707e-01 1.09803376807363559097829863731022e-01 3.43022581548034152798543061635428e-03
 	 6.64437380862578752527269898564555e-01 1.09803376807363559097829863731022e-01 2.25759242330057757763839276776707e-01 3.43022581548034152798543061635428e-03
 	 3.28699347560523658096087729063584e-01 1.02835875371072957285001336913410e-01 5.68464777068403370741123126208549e-01 3.78276198239127460151709492208738e-03
 	 3.28699347560523658096087729063584e-01 5.68464777068403370741123126208549e-01 1.02835875371072957285001336913410e-01 3.78276198239127460151709492208738e-03
 	 1.02835875371072957285001336913410e-01 3.28699347560523658096087729063584e-01 5.68464777068403370741123126208549e-01 3.78276198239127460151709492208738e-03
 	 1.02835875371072957285001336913410e-01 5.68464777068403370741123126208549e-01 3.28699347560523658096087729063584e-01 3.78276198239127460151709492208738e-03
 	 5.68464777068403370741123126208549e-01 3.28699347560523658096087729063584e-01 1.02835875371072957285001336913410e-01 3.78276198239127460151709492208738e-03
 	 5.68464777068403370741123126208549e-01 1.02835875371072957285001336913410e-01 3.28699347560523658096087729063584e-01 3.78276198239127460151709492208738e-03
 	 5.70245183292808974218068840400520e-02 1.04550153444100853150633412269599e-02 9.32520466326309027671470630593831e-01 6.70430640062610514427754448973928e-04
 	 5.70245183292808974218068840400520e-02 9.32520466326309027671470630593831e-01 1.04550153444100853150633412269599e-02 6.70430640062610514427754448973928e-04
 	 1.04550153444100853150633412269599e-02 5.70245183292808974218068840400520e-02 9.32520466326309027671470630593831e-01 6.70430640062610514427754448973928e-04
 	 1.04550153444100853150633412269599e-02 9.32520466326309027671470630593831e-01 5.70245183292808974218068840400520e-02 6.70430640062610514427754448973928e-04
 	 9.32520466326309027671470630593831e-01 5.70245183292808974218068840400520e-02 1.04550153444100853150633412269599e-02 6.70430640062610514427754448973928e-04
 	 9.32520466326309027671470630593831e-01 1.04550153444100853150633412269599e-02 5.70245183292808974218068840400520e-02 6.70430640062610514427754448973928e-04
 	 2.18153490627607082874561683638603e-01 1.47522261546056410175253859051736e-01 6.34324247826336562461335688567488e-01 4.17411476734055007786761137822396e-03
 	 2.18153490627607082874561683638603e-01 6.34324247826336562461335688567488e-01 1.47522261546056410175253859051736e-01 4.17411476734055007786761137822396e-03
 	 1.47522261546056410175253859051736e-01 2.18153490627607082874561683638603e-01 6.34324247826336562461335688567488e-01 4.17411476734055007786761137822396e-03
 	 1.47522261546056410175253859051736e-01 6.34324247826336562461335688567488e-01 2.18153490627607082874561683638603e-01 4.17411476734055007786761137822396e-03
 	 6.34324247826336562461335688567488e-01 2.18153490627607082874561683638603e-01 1.47522261546056410175253859051736e-01 4.17411476734055007786761137822396e-03
 	 6.34324247826336562461335688567488e-01 1.47522261546056410175253859051736e-01 2.18153490627607082874561683638603e-01 4.17411476734055007786761137822396e-03
 	 2.02306345883463578605443444757839e-01 5.21260968074300848340563163674233e-02 7.45567557309106399010545374039793e-01 2.55836665697603115460223577315446e-03
 	 2.02306345883463578605443444757839e-01 7.45567557309106399010545374039793e-01 5.21260968074300848340563163674233e-02 2.55836665697603115460223577315446e-03
 	 5.21260968074300848340563163674233e-02 2.02306345883463578605443444757839e-01 7.45567557309106399010545374039793e-01 2.55836665697603115460223577315446e-03
 	 5.21260968074300848340563163674233e-02 7.45567557309106399010545374039793e-01 2.02306345883463578605443444757839e-01 2.55836665697603115460223577315446e-03
 	 7.45567557309106399010545374039793e-01 2.02306345883463578605443444757839e-01 5.21260968074300848340563163674233e-02 2.55836665697603115460223577315446e-03
 	 7.45567557309106399010545374039793e-01 5.21260968074300848340563163674233e-02 2.02306345883463578605443444757839e-01 2.55836665697603115460223577315446e-03
 	 2.13283209808807994178891931369435e-01 8.00841957661688891301210446727055e-02 7.06632594425023130568774831772316e-01 3.18398695212329836679021610734708e-03
 	 2.13283209808807994178891931369435e-01 7.06632594425023130568774831772316e-01 8.00841957661688891301210446727055e-02 3.18398695212329836679021610734708e-03
 	 8.00841957661688891301210446727055e-02 2.13283209808807994178891931369435e-01 7.06632594425023130568774831772316e-01 3.18398695212329836679021610734708e-03
 	 8.00841957661688891301210446727055e-02 7.06632594425023130568774831772316e-01 2.13283209808807994178891931369435e-01 3.18398695212329836679021610734708e-03
 	 7.06632594425023130568774831772316e-01 2.13283209808807994178891931369435e-01 8.00841957661688891301210446727055e-02 3.18398695212329836679021610734708e-03
 	 7.06632594425023130568774831772316e-01 8.00841957661688891301210446727055e-02 2.13283209808807994178891931369435e-01 3.18398695212329836679021610734708e-03
 	 8.21335887122196829646103566346937e-03 2.16078035466830617461475583240826e-03 9.89625860774109744610882444249000e-01 1.31717092795391541720784189806182e-04
 	 8.21335887122196829646103566346937e-03 9.89625860774109744610882444249000e-01 2.16078035466830617461475583240826e-03 1.31717092795391541720784189806182e-04
 	 2.16078035466830617461475583240826e-03 8.21335887122196829646103566346937e-03 9.89625860774109744610882444249000e-01 1.31717092795391541720784189806182e-04
 	 2.16078035466830617461475583240826e-03 9.89625860774109744610882444249000e-01 8.21335887122196829646103566346937e-03 1.31717092795391541720784189806182e-04
 	 9.89625860774109744610882444249000e-01 8.21335887122196829646103566346937e-03 2.16078035466830617461475583240826e-03 1.31717092795391541720784189806182e-04
 	 9.89625860774109744610882444249000e-01 2.16078035466830617461475583240826e-03 8.21335887122196829646103566346937e-03 1.31717092795391541720784189806182e-04
 	 4.61515361612300334392955392104341e-01 1.13638023497272810935498910112074e-02 5.27120836037972440024645948142279e-01 1.64567238310600995679355840195512e-03
 	 4.61515361612300334392955392104341e-01 5.27120836037972440024645948142279e-01 1.13638023497272810935498910112074e-02 1.64567238310600995679355840195512e-03
 	 1.13638023497272810935498910112074e-02 4.61515361612300334392955392104341e-01 5.27120836037972440024645948142279e-01 1.64567238310600995679355840195512e-03
 	 1.13638023497272810935498910112074e-02 5.27120836037972440024645948142279e-01 4.61515361612300334392955392104341e-01 1.64567238310600995679355840195512e-03
 	 5.27120836037972440024645948142279e-01 4.61515361612300334392955392104341e-01 1.13638023497272810935498910112074e-02 1.64567238310600995679355840195512e-03
 	 5.27120836037972440024645948142279e-01 1.13638023497272810935498910112074e-02 4.61515361612300334392955392104341e-01 1.64567238310600995679355840195512e-03
 	 3.54622467312705691444563171899063e-01 1.29778523617651048160936966269219e-01 5.15599009069643288150075477460632e-01 4.59548309325857363971667979285485e-03
 	 3.54622467312705691444563171899063e-01 5.15599009069643288150075477460632e-01 1.29778523617651048160936966269219e-01 4.59548309325857363971667979285485e-03
 	 1.29778523617651048160936966269219e-01 3.54622467312705691444563171899063e-01 5.15599009069643288150075477460632e-01 4.59548309325857363971667979285485e-03
 	 1.29778523617651048160936966269219e-01 5.15599009069643288150075477460632e-01 3.54622467312705691444563171899063e-01 4.59548309325857363971667979285485e-03
 	 5.15599009069643288150075477460632e-01 3.54622467312705691444563171899063e-01 1.29778523617651048160936966269219e-01 4.59548309325857363971667979285485e-03
 	 5.15599009069643288150075477460632e-01 1.29778523617651048160936966269219e-01 3.54622467312705691444563171899063e-01 4.59548309325857363971667979285485e-03
 	 3.10920643586031608673891923899646e-01 4.89372786072454005190657255752740e-02 6.40142077806722942234785023174481e-01 2.86886015681563338181048194996947e-03
 	 3.10920643586031608673891923899646e-01 6.40142077806722942234785023174481e-01 4.89372786072454005190657255752740e-02 2.86886015681563338181048194996947e-03
 	 4.89372786072454005190657255752740e-02 3.10920643586031608673891923899646e-01 6.40142077806722942234785023174481e-01 2.86886015681563338181048194996947e-03
 	 4.89372786072454005190657255752740e-02 6.40142077806722942234785023174481e-01 3.10920643586031608673891923899646e-01 2.86886015681563338181048194996947e-03
 	 6.40142077806722942234785023174481e-01 3.10920643586031608673891923899646e-01 4.89372786072454005190657255752740e-02 2.86886015681563338181048194996947e-03
 	 6.40142077806722942234785023174481e-01 4.89372786072454005190657255752740e-02 3.10920643586031608673891923899646e-01 2.86886015681563338181048194996947e-03
 	 3.04955784133230656252067092282232e-01 1.58417559007465957865434802442905e-01 5.36626656859303441393649336532690e-01 4.72673406092024694230557813057203e-03
 	 3.04955784133230656252067092282232e-01 5.36626656859303441393649336532690e-01 1.58417559007465957865434802442905e-01 4.72673406092024694230557813057203e-03
 	 1.58417559007465957865434802442905e-01 3.04955784133230656252067092282232e-01 5.36626656859303441393649336532690e-01 4.72673406092024694230557813057203e-03
 	 1.58417559007465957865434802442905e-01 5.36626656859303441393649336532690e-01 3.04955784133230656252067092282232e-01 4.72673406092024694230557813057203e-03
 	 5.36626656859303441393649336532690e-01 3.04955784133230656252067092282232e-01 1.58417559007465957865434802442905e-01 4.72673406092024694230557813057203e-03
 	 5.36626656859303441393649336532690e-01 1.58417559007465957865434802442905e-01 3.04955784133230656252067092282232e-01 4.72673406092024694230557813057203e-03
 	 2.50794437563904126786695769624203e-01 1.75500085438409114679814138071379e-01 5.73705476997686703022338861046592e-01 4.80873176882953487498717493053846e-03
 	 2.50794437563904126786695769624203e-01 5.73705476997686703022338861046592e-01 1.75500085438409114679814138071379e-01 4.80873176882953487498717493053846e-03
 	 1.75500085438409114679814138071379e-01 2.50794437563904126786695769624203e-01 5.73705476997686703022338861046592e-01 4.80873176882953487498717493053846e-03
 	 1.75500085438409114679814138071379e-01 5.73705476997686703022338861046592e-01 2.50794437563904126786695769624203e-01 4.80873176882953487498717493053846e-03
 	 5.73705476997686703022338861046592e-01 2.50794437563904126786695769624203e-01 1.75500085438409114679814138071379e-01 4.80873176882953487498717493053846e-03
 	 5.73705476997686703022338861046592e-01 1.75500085438409114679814138071379e-01 2.50794437563904126786695769624203e-01 4.80873176882953487498717493053846e-03
 	 4.33869221864480514305739689007169e-01 5.31263813104962887012838734790421e-02 5.13004396825023190054082533606561e-01 3.19276708369346361865437344818019e-03
 	 4.33869221864480514305739689007169e-01 5.13004396825023190054082533606561e-01 5.31263813104962887012838734790421e-02 3.19276708369346361865437344818019e-03
 	 5.31263813104962887012838734790421e-02 4.33869221864480514305739689007169e-01 5.13004396825023190054082533606561e-01 3.19276708369346361865437344818019e-03
 	 5.31263813104962887012838734790421e-02 5.13004396825023190054082533606561e-01 4.33869221864480514305739689007169e-01 3.19276708369346361865437344818019e-03
 	 5.13004396825023190054082533606561e-01 4.33869221864480514305739689007169e-01 5.31263813104962887012838734790421e-02 3.19276708369346361865437344818019e-03
 	 5.13004396825023190054082533606561e-01 5.31263813104962887012838734790421e-02 4.33869221864480514305739689007169e-01 3.19276708369346361865437344818019e-03
 	 7.70376986253196172071966429939494e-02 5.09089773583295684966643079860660e-02 8.72053324016350828173926856834441e-01 1.74876505028943884413605847072404e-03
 	 7.70376986253196172071966429939494e-02 8.72053324016350828173926856834441e-01 5.09089773583295684966643079860660e-02 1.74876505028943884413605847072404e-03
 	 5.09089773583295684966643079860660e-02 7.70376986253196172071966429939494e-02 8.72053324016350828173926856834441e-01 1.74876505028943884413605847072404e-03
 	 5.09089773583295684966643079860660e-02 8.72053324016350828173926856834441e-01 7.70376986253196172071966429939494e-02 1.74876505028943884413605847072404e-03
 	 8.72053324016350828173926856834441e-01 7.70376986253196172071966429939494e-02 5.09089773583295684966643079860660e-02 1.74876505028943884413605847072404e-03
 	 8.72053324016350828173926856834441e-01 5.09089773583295684966643079860660e-02 7.70376986253196172071966429939494e-02 1.74876505028943884413605847072404e-03
 	 2.76836186019522423329419780202443e-01 1.11213995971377495319831751885431e-02 7.12042414383339816730256188748172e-01 1.43067033238301498029865221894852e-03
 	 2.76836186019522423329419780202443e-01 7.12042414383339816730256188748172e-01 1.11213995971377495319831751885431e-02 1.43067033238301498029865221894852e-03
 	 1.11213995971377495319831751885431e-02 2.76836186019522423329419780202443e-01 7.12042414383339816730256188748172e-01 1.43067033238301498029865221894852e-03
 	 1.11213995971377495319831751885431e-02 7.12042414383339816730256188748172e-01 2.76836186019522423329419780202443e-01 1.43067033238301498029865221894852e-03
 	 7.12042414383339816730256188748172e-01 2.76836186019522423329419780202443e-01 1.11213995971377495319831751885431e-02 1.43067033238301498029865221894852e-03
 	 7.12042414383339816730256188748172e-01 1.11213995971377495319831751885431e-02 2.76836186019522423329419780202443e-01 1.43067033238301498029865221894852e-03
 	 1.73637162103421421877058605787170e-01 1.17797536807179720197424899197358e-02 8.14583084215860675492137943365378e-01 1.26817527893533670869941065717512e-03
 	 1.73637162103421421877058605787170e-01 8.14583084215860675492137943365378e-01 1.17797536807179720197424899197358e-02 1.26817527893533670869941065717512e-03
 	 1.17797536807179720197424899197358e-02 1.73637162103421421877058605787170e-01 8.14583084215860675492137943365378e-01 1.26817527893533670869941065717512e-03
 	 1.17797536807179720197424899197358e-02 8.14583084215860675492137943365378e-01 1.73637162103421421877058605787170e-01 1.26817527893533670869941065717512e-03
 	 8.14583084215860675492137943365378e-01 1.73637162103421421877058605787170e-01 1.17797536807179720197424899197358e-02 1.26817527893533670869941065717512e-03
 	 8.14583084215860675492137943365378e-01 1.17797536807179720197424899197358e-02 1.73637162103421421877058605787170e-01 1.26817527893533670869941065717512e-03
 	 3.35433688661376960826743243160308e-01 1.18081263036933694493546553871965e-02 6.52758185034929772072587184084114e-01 1.57903374391168385866557333230276e-03
 	 3.35433688661376960826743243160308e-01 6.52758185034929772072587184084114e-01 1.18081263036933694493546553871965e-02 1.57903374391168385866557333230276e-03
 	 1.18081263036933694493546553871965e-02 3.35433688661376960826743243160308e-01 6.52758185034929772072587184084114e-01 1.57903374391168385866557333230276e-03
 	 1.18081263036933694493546553871965e-02 6.52758185034929772072587184084114e-01 3.35433688661376960826743243160308e-01 1.57903374391168385866557333230276e-03
 	 6.52758185034929772072587184084114e-01 3.35433688661376960826743243160308e-01 1.18081263036933694493546553871965e-02 1.57903374391168385866557333230276e-03
 	 6.52758185034929772072587184084114e-01 1.18081263036933694493546553871965e-02 3.35433688661376960826743243160308e-01 1.57903374391168385866557333230276e-03
 	 3.75064218452396624936540092676296e-01 5.12438839908936349942791821376886e-02 5.73691897556709684558029493928188e-01 3.21544520843206971597028065446011e-03
 	 3.75064218452396624936540092676296e-01 5.73691897556709684558029493928188e-01 5.12438839908936349942791821376886e-02 3.21544520843206971597028065446011e-03
 	 5.12438839908936349942791821376886e-02 3.75064218452396624936540092676296e-01 5.73691897556709684558029493928188e-01 3.21544520843206971597028065446011e-03
 	 5.12438839908936349942791821376886e-02 5.73691897556709684558029493928188e-01 3.75064218452396624936540092676296e-01 3.21544520843206971597028065446011e-03
 	 5.73691897556709684558029493928188e-01 3.75064218452396624936540092676296e-01 5.12438839908936349942791821376886e-02 3.21544520843206971597028065446011e-03
 	 5.73691897556709684558029493928188e-01 5.12438839908936349942791821376886e-02 3.75064218452396624936540092676296e-01 3.21544520843206971597028065446011e-03
 	 3.46711286129900431163264329370577e-01 1.82541256476132840447235139436089e-01 4.70747457393966728389500531193335e-01 5.39770582201698229801722916931794e-03
 	 3.46711286129900431163264329370577e-01 4.70747457393966728389500531193335e-01 1.82541256476132840447235139436089e-01 5.39770582201698229801722916931794e-03
 	 1.82541256476132840447235139436089e-01 3.46711286129900431163264329370577e-01 4.70747457393966728389500531193335e-01 5.39770582201698229801722916931794e-03
 	 1.82541256476132840447235139436089e-01 4.70747457393966728389500531193335e-01 3.46711286129900431163264329370577e-01 5.39770582201698229801722916931794e-03
 	 4.70747457393966728389500531193335e-01 3.46711286129900431163264329370577e-01 1.82541256476132840447235139436089e-01 5.39770582201698229801722916931794e-03
 	 4.70747457393966728389500531193335e-01 1.82541256476132840447235139436089e-01 3.46711286129900431163264329370577e-01 5.39770582201698229801722916931794e-03
 	 2.55968511260664111084395244688494e-01 5.39018714502928694698447031896649e-02 6.90129617289042984751290532585699e-01 3.06270520301089432119168165513656e-03
 	 2.55968511260664111084395244688494e-01 6.90129617289042984751290532585699e-01 5.39018714502928694698447031896649e-02 3.06270520301089432119168165513656e-03
 	 5.39018714502928694698447031896649e-02 2.55968511260664111084395244688494e-01 6.90129617289042984751290532585699e-01 3.06270520301089432119168165513656e-03
 	 5.39018714502928694698447031896649e-02 6.90129617289042984751290532585699e-01 2.55968511260664111084395244688494e-01 3.06270520301089432119168165513656e-03
 	 6.90129617289042984751290532585699e-01 2.55968511260664111084395244688494e-01 5.39018714502928694698447031896649e-02 3.06270520301089432119168165513656e-03
 	 6.90129617289042984751290532585699e-01 5.39018714502928694698447031896649e-02 2.55968511260664111084395244688494e-01 3.06270520301089432119168165513656e-03
 	 2.92006920788531632027229534287471e-01 2.73433134615536990730255695325468e-02 6.80649765749914648083063184458297e-01 2.31921840963746159897107546044026e-03
 	 2.92006920788531632027229534287471e-01 6.80649765749914648083063184458297e-01 2.73433134615536990730255695325468e-02 2.31921840963746159897107546044026e-03
 	 2.73433134615536990730255695325468e-02 2.92006920788531632027229534287471e-01 6.80649765749914648083063184458297e-01 2.31921840963746159897107546044026e-03
 	 2.73433134615536990730255695325468e-02 6.80649765749914648083063184458297e-01 2.92006920788531632027229534287471e-01 2.31921840963746159897107546044026e-03
 	 6.80649765749914648083063184458297e-01 2.92006920788531632027229534287471e-01 2.73433134615536990730255695325468e-02 2.31921840963746159897107546044026e-03
 	 6.80649765749914648083063184458297e-01 2.73433134615536990730255695325468e-02 2.92006920788531632027229534287471e-01 2.31921840963746159897107546044026e-03
 	 2.36417239579575555463719638282782e-01 2.97423818792802684141118874094900e-02 7.33840378541144144897145906725200e-01 2.29610029017729465675157207726897e-03
 	 2.36417239579575555463719638282782e-01 7.33840378541144144897145906725200e-01 2.97423818792802684141118874094900e-02 2.29610029017729465675157207726897e-03
 	 2.97423818792802684141118874094900e-02 2.36417239579575555463719638282782e-01 7.33840378541144144897145906725200e-01 2.29610029017729465675157207726897e-03
 	 2.97423818792802684141118874094900e-02 7.33840378541144144897145906725200e-01 2.36417239579575555463719638282782e-01 2.29610029017729465675157207726897e-03
 	 7.33840378541144144897145906725200e-01 2.36417239579575555463719638282782e-01 2.97423818792802684141118874094900e-02 2.29610029017729465675157207726897e-03
 	 7.33840378541144144897145906725200e-01 2.97423818792802684141118874094900e-02 2.36417239579575555463719638282782e-01 2.29610029017729465675157207726897e-03
 	 4.66150898129435442562851221737219e-01 2.19129468105736533237171137500354e-03 5.31657807189507169987052748183487e-01 7.33810332071203538784054387633660e-04
 	 4.66150898129435442562851221737219e-01 5.31657807189507169987052748183487e-01 2.19129468105736533237171137500354e-03 7.33810332071203538784054387633660e-04
 	 2.19129468105736533237171137500354e-03 4.66150898129435442562851221737219e-01 5.31657807189507169987052748183487e-01 7.33810332071203538784054387633660e-04
 	 2.19129468105736533237171137500354e-03 5.31657807189507169987052748183487e-01 4.66150898129435442562851221737219e-01 7.33810332071203538784054387633660e-04
 	 5.31657807189507169987052748183487e-01 4.66150898129435442562851221737219e-01 2.19129468105736533237171137500354e-03 7.33810332071203538784054387633660e-04
 	 5.31657807189507169987052748183487e-01 2.19129468105736533237171137500354e-03 4.66150898129435442562851221737219e-01 7.33810332071203538784054387633660e-04
 	 2.23482629145585642849169971668744e-01 1.25736658366042697299036490221624e-02 7.63943705017810170687653226195835e-01 1.44376027674081286976404125965701e-03
 	 2.23482629145585642849169971668744e-01 7.63943705017810170687653226195835e-01 1.25736658366042697299036490221624e-02 1.44376027674081286976404125965701e-03
 	 1.25736658366042697299036490221624e-02 2.23482629145585642849169971668744e-01 7.63943705017810170687653226195835e-01 1.44376027674081286976404125965701e-03
 	 1.25736658366042697299036490221624e-02 7.63943705017810170687653226195835e-01 2.23482629145585642849169971668744e-01 1.44376027674081286976404125965701e-03
 	 7.63943705017810170687653226195835e-01 2.23482629145585642849169971668744e-01 1.25736658366042697299036490221624e-02 1.44376027674081286976404125965701e-03
 	 7.63943705017810170687653226195835e-01 1.25736658366042697299036490221624e-02 2.23482629145585642849169971668744e-01 1.44376027674081286976404125965701e-03
 	 3.97368013878000581051708195445826e-01 1.15196691295125427934031847598817e-02 5.91112316992486896971570331515977e-01 1.65866632396426843566727971079899e-03
 	 3.97368013878000581051708195445826e-01 5.91112316992486896971570331515977e-01 1.15196691295125427934031847598817e-02 1.65866632396426843566727971079899e-03
 	 1.15196691295125427934031847598817e-02 3.97368013878000581051708195445826e-01 5.91112316992486896971570331515977e-01 1.65866632396426843566727971079899e-03
 	 1.15196691295125427934031847598817e-02 5.91112316992486896971570331515977e-01 3.97368013878000581051708195445826e-01 1.65866632396426843566727971079899e-03
 	 5.91112316992486896971570331515977e-01 3.97368013878000581051708195445826e-01 1.15196691295125427934031847598817e-02 1.65866632396426843566727971079899e-03
 	 5.91112316992486896971570331515977e-01 1.15196691295125427934031847598817e-02 3.97368013878000581051708195445826e-01 1.65866632396426843566727971079899e-03
 	 2.85679243244989944372491663671099e-01 2.10668037666766339022217380261282e-01 5.03652719088243716605290956067620e-01 5.57072930811327443612057663813175e-03
 	 2.85679243244989944372491663671099e-01 5.03652719088243716605290956067620e-01 2.10668037666766339022217380261282e-01 5.57072930811327443612057663813175e-03
 	 2.10668037666766339022217380261282e-01 2.85679243244989944372491663671099e-01 5.03652719088243716605290956067620e-01 5.57072930811327443612057663813175e-03
 	 2.10668037666766339022217380261282e-01 5.03652719088243716605290956067620e-01 2.85679243244989944372491663671099e-01 5.57072930811327443612057663813175e-03
 	 5.03652719088243716605290956067620e-01 2.85679243244989944372491663671099e-01 2.10668037666766339022217380261282e-01 5.57072930811327443612057663813175e-03
 	 5.03652719088243716605290956067620e-01 2.10668037666766339022217380261282e-01 2.85679243244989944372491663671099e-01 5.57072930811327443612057663813175e-03
 	 4.00991912296406793903003062951029e-01 2.17085028246803788537500068400732e-03 5.96837237421125266223498329054564e-01 7.21437434464601784825377173149263e-04
 	 4.00991912296406793903003062951029e-01 5.96837237421125266223498329054564e-01 2.17085028246803788537500068400732e-03 7.21437434464601784825377173149263e-04
 	 2.17085028246803788537500068400732e-03 4.00991912296406793903003062951029e-01 5.96837237421125266223498329054564e-01 7.21437434464601784825377173149263e-04
 	 2.17085028246803788537500068400732e-03 5.96837237421125266223498329054564e-01 4.00991912296406793903003062951029e-01 7.21437434464601784825377173149263e-04
 	 5.96837237421125266223498329054564e-01 4.00991912296406793903003062951029e-01 2.17085028246803788537500068400732e-03 7.21437434464601784825377173149263e-04
 	 5.96837237421125266223498329054564e-01 2.17085028246803788537500068400732e-03 4.00991912296406793903003062951029e-01 7.21437434464601784825377173149263e-04
 	 1.56273510404076748647739236730558e-01 5.57664223797979460850449129338813e-02 7.87960067216125326083897562057246e-01 2.62212782441478700970471926723349e-03
 	 1.56273510404076748647739236730558e-01 7.87960067216125326083897562057246e-01 5.57664223797979460850449129338813e-02 2.62212782441478700970471926723349e-03
 	 5.57664223797979460850449129338813e-02 1.56273510404076748647739236730558e-01 7.87960067216125326083897562057246e-01 2.62212782441478700970471926723349e-03
 	 5.57664223797979460850449129338813e-02 7.87960067216125326083897562057246e-01 1.56273510404076748647739236730558e-01 2.62212782441478700970471926723349e-03
 	 7.87960067216125326083897562057246e-01 1.56273510404076748647739236730558e-01 5.57664223797979460850449129338813e-02 2.62212782441478700970471926723349e-03
 	 7.87960067216125326083897562057246e-01 5.57664223797979460850449129338813e-02 1.56273510404076748647739236730558e-01 2.62212782441478700970471926723349e-03
 	 4.77858936846818488364263544099231e-02 2.09790827030163079536251302670280e-03 9.50116198045016457918165997398319e-01 3.03579603372383796059535976397115e-04
 	 4.77858936846818488364263544099231e-02 9.50116198045016457918165997398319e-01 2.09790827030163079536251302670280e-03 3.03579603372383796059535976397115e-04
 	 2.09790827030163079536251302670280e-03 4.77858936846818488364263544099231e-02 9.50116198045016457918165997398319e-01 3.03579603372383796059535976397115e-04
 	 2.09790827030163079536251302670280e-03 9.50116198045016457918165997398319e-01 4.77858936846818488364263544099231e-02 3.03579603372383796059535976397115e-04
 	 9.50116198045016457918165997398319e-01 4.77858936846818488364263544099231e-02 2.09790827030163079536251302670280e-03 3.03579603372383796059535976397115e-04
 	 9.50116198045016457918165997398319e-01 2.09790827030163079536251302670280e-03 4.77858936846818488364263544099231e-02 3.03579603372383796059535976397115e-04
 	 1.82249159931374082876942566144862e-01 2.90781975795925198835512048844976e-02 7.88672642489033459689551364135696e-01 2.10008700114841691253264599481554e-03
 	 1.82249159931374082876942566144862e-01 7.88672642489033459689551364135696e-01 2.90781975795925198835512048844976e-02 2.10008700114841691253264599481554e-03
 	 2.90781975795925198835512048844976e-02 1.82249159931374082876942566144862e-01 7.88672642489033459689551364135696e-01 2.10008700114841691253264599481554e-03
 	 2.90781975795925198835512048844976e-02 7.88672642489033459689551364135696e-01 1.82249159931374082876942566144862e-01 2.10008700114841691253264599481554e-03
 	 7.88672642489033459689551364135696e-01 1.82249159931374082876942566144862e-01 2.90781975795925198835512048844976e-02 2.10008700114841691253264599481554e-03
 	 7.88672642489033459689551364135696e-01 2.90781975795925198835512048844976e-02 1.82249159931374082876942566144862e-01 2.10008700114841691253264599481554e-03
 	 8.93475681919859154866969674912980e-02 1.15829668440252560313030727456862e-02 8.99069464963988762562507872644346e-01 9.66298618741335819774807003312844e-04
 	 8.93475681919859154866969674912980e-02 8.99069464963988762562507872644346e-01 1.15829668440252560313030727456862e-02 9.66298618741335819774807003312844e-04
 	 1.15829668440252560313030727456862e-02 8.93475681919859154866969674912980e-02 8.99069464963988762562507872644346e-01 9.66298618741335819774807003312844e-04
 	 1.15829668440252560313030727456862e-02 8.99069464963988762562507872644346e-01 8.93475681919859154866969674912980e-02 9.66298618741335819774807003312844e-04
 	 8.99069464963988762562507872644346e-01 8.93475681919859154866969674912980e-02 1.15829668440252560313030727456862e-02 9.66298618741335819774807003312844e-04
 	 8.99069464963988762562507872644346e-01 1.15829668440252560313030727456862e-02 8.93475681919859154866969674912980e-02 9.66298618741335819774807003312844e-04
 	 1.65219881239912769199662534447270e-01 8.74623616502727824206786522154289e-02 7.47317757109814406746295389893930e-01 3.20467237022898851495078531570471e-03
 	 1.65219881239912769199662534447270e-01 7.47317757109814406746295389893930e-01 8.74623616502727824206786522154289e-02 3.20467237022898851495078531570471e-03
 	 8.74623616502727824206786522154289e-02 1.65219881239912769199662534447270e-01 7.47317757109814406746295389893930e-01 3.20467237022898851495078531570471e-03
 	 8.74623616502727824206786522154289e-02 7.47317757109814406746295389893930e-01 1.65219881239912769199662534447270e-01 3.20467237022898851495078531570471e-03
 	 7.47317757109814406746295389893930e-01 1.65219881239912769199662534447270e-01 8.74623616502727824206786522154289e-02 3.20467237022898851495078531570471e-03
 	 7.47317757109814406746295389893930e-01 8.74623616502727824206786522154289e-02 1.65219881239912769199662534447270e-01 3.20467237022898851495078531570471e-03
 	 8.052800473916843