
function [V1,V2,V3]=set_zhang_cui_liu_pre(deg)

V1=[]; V2=[]; V3=[];

switch deg
    case 1
        W=[1];
        V3=[W];
    case 2
        W=1/3;
        V2=1./6.;
    case 3
        W=[.28114980244097964825351432270207695
            .05218353089235368507981901063125638];
        V2=[.16288285039589191090016180418490635
            .47791988356756370000000000000000000];
    case 4
        W=[.22338158967801146569500700843312280;
            .10995174365532186763832632490021053];
        V2=[.44594849091596488631832925388305199;
            .09157621350977074345957146340220151];
    case 5
        W=[9./40.
            .12593918054482715259568394550018133
            .13239415278850618073764938783315200
            ];
        
        V2=[.10128650732345633880098736191512383
            .47014206410511508977044120951344760];
        V3=[1./3.];
    case 6
        W=[ .05084490637020681692093680910686898,
            .11678627572637936602528961138557944,
            .08285107561837357519355345642044245];
        V2=[.06308901449150222834033160287081916,
            .24928674517091042129163855310701908];
        V1=[
            .05314504984481694735324967163139815 .31035245103378440541660773395655215];
    case 7
        %         W=[ .14431560767778716825109111048906462,
        %             .10321737053471825028179155029212903,
        %             .03245849762319808031092592834178060,
        %             .09509163426728462479389610438858432,
        %             .02723031417443499426484469007390892];
        %
        %         V3=[.33333333333333333333333333333333333];
        %         v2=[
        %             .17056930775176020662229350149146450,
        %             .05054722831703097545842355059659895,
        %             .45929258829272315602881551449416932,];
        %         v1=[
        %             .26311282963463811342178578628464359,.00839477740995760533721383453929445];
        
        
        W=[ .14431560767778716825109111048906462
            .10321737053471825028179155029212903
            .03245849762319808031092592834178060
            .09509163426728462479389610438858432
            .02723031417443499426484469007390892];
        
        V3=[.33333333333333333333333333333333333];
        V2=[.17056930775176020662229350149146450
            .05054722831703097545842355059659895
            .45929258829272315602881551449416932];
        V1=[.26311282963463811342178578628464359 .00839477740995760533721383453929445];
        
    case 8
        W=[  0.0519871420646,
            0.1032344051380,
            0.1881601469167,
            0.0707034101784,
            0.0909390760952,];
        
        V2=[0.0451890097844,
            0.4815198347833,
            0.4036039798179];
        V1=[
            0.7475124727339, 0.2220631655373,
            0.1369912012649, 0.2182900709714,];
        
        %
        % W=[  Dup21(0.0519871420646),
        %             Dup111(0.0707034101784),
        %             Dup111(0.0909390760952),
        %             Dup21(0.1032344051380),
        %             Dup21(0.1881601469167)];
        %
        %         V=[Perm21(0.0451890097844),
        %             Perm111(0.7475124727339, 0.2220631655373),
        %             Perm111(0.1369912012649, 0.2182900709714),
        %             Perm21(0.4815198347833),
        %             Perm21(0.4036039798179)];
        
        
    case 9
        
        W=[.09713579628279883381924198250728863,
            .03133470022713907053685483128720932,
            .02557767565869803126167879855899982,
            .07782754100477427931673935629940396,
            .07964773892721025303289177426404527,
            .04328353937728937728937728937728938];
        
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .48968251919873762778370692483619280,
            .04472951339445270986510658996627636,
            .43708959149293663726993036443535497,
            .18820353561903273024096128046733557,];
        V1=[
            .74119859878449802069007987352342383,.22196298916076569567510252769319107];
        
    case 10
        W=[.08093742879762288025711312381650193,
            .07729858800296312168250698238034344,
            .07845763861237173136809392083439673,
            .01746916799592948691760716329067815,
            .00429237418483282803048040209013191,
            .03746885821046764297902076548504452,
            .02694935259187995964544947958109671];
        
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .42727317884677553809044271751544715,
            .18309922244867502052157438485022004,
            .49043401970113058745397122237684843,
            .01257244555158053273132908502104126,];
        V1=[
            .65426866792006614066657009558762790,...
            .30804600168524770000000000000000000,
            .12280457706855927343012981748128116,...
            .03337183373930478624081644177478038];
        
    case 11
        
        W=[.08117796029686715951547596874982357,
            .01232404350690949411847390101623284,
            .06282800974441010728333942816029398,
            .01222037904936452975521221500393789,
            .06770134895281150992098886182322559,
            .04021969362885169042356688960756866,
            .01476227271771610133629306558778206,
            .04072799645829903966033695848161786];
        
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .03093835524543078489519501499130475,
            .43649818113412884191761527655997324,
            .49898476370259326628798698383139087,
            .21468819795859433660687581387825086,
            .11368310404211339020529315622836178,];
        V1=[
            .82561876616486290435880620030835800,...
            .15974230459185018980086078822500751,
            .64047231013486526767703659081896681,...
            .31178371570959900000000000000000000];
        
    case 12
        W=[.00616626105155901723386648378523035,
            .06285822421788510035427051309288255,
            .03479611293070894298932839729499937,
            .04369254453803840213545726255747497,
            .02573106644045533541779092307156443,
            .02235677320230344571183907670231999,
            .01731623110865889237164210081103407,
            .04037155776638092951782869925223677];
        
        V2=[.02131735045321037024685697551572825,
            .27121038501211592234595134039689474,
            .12757614554158592467389632515428357,
            .43972439229446027297973662348436108,
            .48821738977380488256466206525881104,];
        V1=[
            .69583608678780342214163552323607254, .28132558098993954824813069297455275,
            .85801403354407263059053661662617818, .11625191590759714124135414784260182,
            .60894323577978780685619243776371007, .27571326968551419397479634607976398];
        
    case 13
        W=[.06796003658683164428177442468088488,
            .05560196753045332870725746601046147,
            .05827848511919998140476708351333981,
            .00605233710353917184179280003229082,
            .02399440192889473077371079945095965,
            .03464127614084837046598682851091822,
            .01496540110516566726324585713290344,
            .02417903981159381913744574557306076,
            .00959068100354326272259509016611089];
        
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .42694141425980040602081253503137421,
            .22137228629183290065481255470507908,
            .02150968110884318386929131353405208,
            .48907694645253934990068971909020439,];
        V1=[
            .62354599555367557081585435318623659, .30844176089211777465847185254124531,
            .86470777029544277530254595089569318,...
            .11092204280346339541286954522167452,
            .74850711589995219517301859578870965,...
            .16359740106785048023388790171095725,
            .72235779312418796526062013230478405,...
            .27251581777342966618005046435408685];
        
    case 14
        W=[.04216258873699301753823043732418613,
            .00492340360240008168182602350904215,
            .01443369966977666760170992148065332,
            .03278835354412535064131097873862534,
            .02188358136942889064084494596332597,
            .05177410450729158631478491016639640,
            .02466575321256367396287524518363623,
            .03857151078706068322848902781041086,
            .01443630811353384049608869199901580,
            .00501022883850067176986009308248912];
        
        V2=[.17720553241254343695661069046505908,
            .01939096124870104817825009505452951,
            .06179988309087260126747882843693579,
            .41764471934045392250944082218564344,
            .48896391036217863867737602045239024,
            .27347752830883865975494428326269856,];
        V1=[
            .17226668782135557837528960161365733,...
            .05712475740364793903567712421891471,
            .57022229084668317349769621336235426,...
            .09291624935697182475824858954872035,
            .29837288213625775297083151805961273,...
            .01464695005565440967054132792007421,
            .11897449769695684539818196192990548,...
            .00126833093287202508724640109549269];
        
    case 15
        
        % a 49-point rule communicated by Freddie Witherden freddie@witherden.org
        % 2D 49 point order 15 rule 1:4:6, 346 tries, 3288 evals, error = 4.251e-17
        W=[.02357126703190634206659321140821418,
            .01517314955721170450311858877690239,
            .01297600128392884154979521077280757,
            .01706629596800615670942600046160914,
            .04576001946273760698482638108892258,
            .00222757447282223154006065426298478,
            .02701014165986947101315702212247500,
            .02608377963958756403057720483642768,
            .01211015327702828337230795926322736,
            .01564785059680444573399007149035058,
            .03417088937929479242522512890637806];
        
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .11022229622834687297855264132259850,
            .05197643301003435047003197947889073,
            .49114565807532554119014945122395425,
            .39315718888435884048226809785071794,];
        V1=[
            .03737440487572919066543605209836625,...
            .96251835223001214880811969560396873,
            .24824877798467321198263980694374938,...
            .19316669854521416819773100288721521,
            .20699402274830217740486528153682148,...
            .08689590883549962551575259619781217,
            .14854110526954708137688902238435510,...
            .01743682539845430796259020511767948,
            .30674237923596382376588728350286621,...
            .01749251095825766163254977051260599,
            .36703198754220473278855469116984882,...
            .09034802175864556044634095119222305];
    case 16
        
        %                 % A 60-point order 17 rule found by using the number of points reported in:
        %  *	H. Xiao and Z. Gimbutas,
        %  *	A numerical algorithm for the construction of efficient quadrature
        %  *	rules in two and higher dimensions,
        %  *	Computers and Mathematics with Applications, 59 2010, 663-676 */
        W=[.04802218868037709055183940458051988,
            .01470910030680192710340364286186919,
            .02954458654931925599530972679646409,
            .02612501735108837749859756549171557,
            .00278038735239000697500301613866207,
            .03182177300053664950342729005594961,
            .00864583434950965990117373416984893,
            .01430033290449536514661642536825213,
            .02784977720360082995222987342395349,
            .00704167340663609756237018808928069,
            .01789983825993372860177020907581078,
            .02745820038434976307247003810091720,
            .00729979693943176208411254408777766];
        
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .08179498313137387264146559311886101,
            .16530060196977965062676193293355656,
            .46859210534946138669460289729660561,
            .01443881344541668261410895669566020,
            .24178428539178335340689445929320769,
            .49531034298776996406549508687740551,];
        V1=[
            .65051340266135229943114468484168666,...
            .33139974453708955658132316818259388,
            .60401128149599703984940410303596702,...
            .30324716274994218504155217807834692,
            .80216825757474166361686194781166705,...
            .18802805952123717344418211429398875,
            .75650560644282839655115407575806082,...
            .18350466852229686368238027743700035,
            .46593843871411818488381073359154639,...
            .35964594879750460000000000000001000,
            .90639484399204150136249966186534000,...
            .07719437129575543228251522505271386];
        
        
    case 17
        W=[.03829254008003568749425168889491817,
            .01669528699775339594318472807122019,
            .00143512454359061224492929722268097,
            .02864276849185053630399044294140648,
            .03408569078206214964786810427776196,
            .02467274200053089056925349793140004,
            .00586679757537134154263246190805349,
            .02321859500422896151112767944153052,
            .03084965458251406099116307348593810,
            .01881398544005420038782109445200127,
            .00512343450397285555007197439694996,
            .00701239348475201777118052342883162,
            .01538229443504461311363086994295179,
            .00303013148261713122418018061550803];
        
        V2=[.24056306963626902977934166278860247,
            .08092323589766073062004798772340524,
            .01001414912499135088254841140047604,
            .15437652078663289107430782196727737,
            .41716986201996268598941663596983268,
            .47086974573840098186867398532866671,
            .49811803384542204444865152799034832,
            .36473840565291924199871629076775930,];
        V1=[
            .10986590708262616153720966373050601,...
            .30466576969866569523225839525499357,
            .20493227462918790108024139159058423,...
            .05248758390645425414786013344982922,
            .05813921564266244000000000000000000,...
            .01500053995225954378593128753997425,
            .13859554086776482539309659376771751,...
            .01501023347973182500884052064335399,
            .34660546952009260087829868774027952,...
            .02336212893314653752768977049783837,
            .24821986889585591697209834974065293,...
            .00000099999999999965762180770907324];
        
    case 18
        
        %  * Note: the rule QUAD_2D_P19 was taken from the book by
        %  *	P. Solin, K. Segeth, and I. Dolezel,
        %  *	"Higer-order Finite Element Methods",
        %  *	Chapman and Hall/CRC Press, 2003. */
        
        W=[.03290633138891865208361434484647497,
            .01033073189127205336703996357174833,
            .02238724726301639252918455603516271,
            .03026612586946807086528019098259122,
            .03049096780219778100003158657852042,
            .02415921274164090491184803098664001,
            .01605080358680087529162277027642948,
            .00808458026178406048180567324219442,
            .00207936202748478075134750167439841,
            .00388487690498138975670499199277266,
            .02557416061202190389292970195260027,
            .00888090357333805774552592470351753,
            .01612454676173139121978526932783766,
            .00249194181749067544058464757594956,
            .01824284011895057837766571320973615,
            .01025856373619852130804807004235813,
            .00379992885530191397907315371363970];
        
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .48960998707300633196613106574829817,
            .45453689269789266204675939053572830,
            .40141668064943118739399562381068860,
            .25555165440309761132218176810926787,
            .17707794215212955164267520651590115,
            .11006105322795186130008495167737397,
            .05552862425183967124867841247135571,
            .01262186377722866849023476677870599,];
        V1=[
            .60063379479464500000000000000000000,...
            .39575478735694286230479469406582787,
            .13446675453077978561204319893264695,...
            .55760326158878396836395324250118097,
            .72098702581736505521665290233827892,...
            .26456694840652020804030173490121494,
            .59452706895587092461388928802650670,...
            .35853935220595058842492699064590088,
            .83933147368083857861749007714840520,...
            .15780740596859474473767360335950651,
            .22386142409791569130336938950653642,...
            .70108797892617336732328833655951158,
            .82293132406985663162747155916053316,...
            .14242160111338343731557475687723745,
            .92434425262078402945585913790156314,...
            .06549462808293770339232652498592557];
        
        
        %     * Rules 20-24, 26-29 are found by Simone Weikl simone.weikl@googlemail.com,
        %  * Diploma Thesis, Technische Universiat Munchen, Zentrum Mathematik, 2011 */
        
    case 20
        
        W=[.02343898837621685337578235989880370,
            .01701187887065179140821050028462978,
            .02213462902539847149771471956849632,
            .02225012034148936704815054477635356,
            .02108801427518765728972259255778044,
            .01436673198237250674135242117943876,
            .00596064247309054870158068681368087,
            .00185446185638856226012710730597991,
            .00766503799888173467975505965999393,
            .00611096641377269564490800130795800,
            .00329750122890750342409287108138500,
            .00258504328745784243926241647780699,
            .01604829966346833686116840419650012,
            .00987379147789446687652271685071374,
            .00817314741769008089505196969930370,
            .02127212420812707803762062418100071,
            .01629559968072678577307785994248523,
            .01910541781474788066581373037653881];
        %
        %  FLOAT QUAD_2D_P20_pts[LengthQUAD_2D_P20_wts * 3] = {
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .47253969049374944291236394079678822,
            .43559179765819053474788158522088855,
            .38548317769095410374903697427852223,
            .18589787266938260089793207404361894,
            .10294309387227568202927226453268166,
            .04420435682210499536228665005842580,
            .01187700008194990884008379159291605,];
        V1=[
            .42317710194393600041367501539791831,...
            .56624681421216737896202019229528315,
            .28717803493735130968896269265785627,...
            .70363134375008177073022062562769704,
            .16282486571070316869304103317873899,...
            .83237331116054735414989063179341648,
            .06468063449817511170284328732719589,...
            .92925769945837560706677619337951412,
            .33400627700511908113700959506140627,...
            .61323701639938793580192466071340766,
            .21092379552418127847921338445298798,...
            .75151051490601053625741794541954190,
            .11508038084136831598057023754719804,...
            .85015113156210283588089253042485358,
            .31075208646508429564535326048014931,...
            .56198974953953613108255692415961755,
            .20200619801045898902767636571938539,...
            .70171644023616188456192811677305342,
            .28902320790895929973608959414472710,...
            .49138856232319209839401293034098827];
        
    case 21
        
        % /* The rule below is reported in the paper:
        %  *	Papanicolopulos, S., A.,
        %  * 	New fully symmetric and rotationally symmetric cubature rules on the
        %  * 	triangle using minimal orthonormal bases,
        %  *	J. Computational and Applied Mathematics, Vol. 294, 2016, pp.39-48 */
        % %  FLOAT QUAD_2D_P21_wts[] = {
        W=[.00153252214157029927832972284942362,
            .00295964208580089055557643244435822,
            .00710507195198322705473634640429004,
            .01242202545015119261392701182790142,
            .01315385309054860400530165567389379,
            .01610711993355940881429849025111080,
            .01955699832742153003791726026064669,
            .02114714580341115240235728776162335,
            .02148724961809553292499438055586582,
            .00324321603629715843164230514808509,
            .00444606682456729614112175291076191,
            .00444713701276898568121864572732943,
            .00719283008979440275755795626382300,
            .00968818276967735751464842894718971,
            .01077186725474600415287816641481312,
            .01537644879227419490362875554570800,
            .01541820162505099647808429434299382,
            .01872799408182348912155361034660658,
            .01961890797839586264061345700479913];
        %
        %  FLOAT QUAD_2D_P21_pts[LengthQUAD_2D_P21_wts * 3] = {
        V2=[.01083064791389613439818531875282892,
            .49868116928006762187511807510022292,
            .05320630259370221372937428477043579,
            .48436880679907196058128682726473251,
            .11717932446409532061312493414817476,
            .18619987453160044065356184245386411,
            .23770504697050237030777008826766300,
            .45111809686333143558277239278860940,
            .29890161661837960265935712860196744,];
        V1=[
            .01017037551397023833029242013076474,.05610607874044113073901605353578031,
            .00740148001912942691985111704851672,.23806090893927819107377783880076336,
            .00948888021003903598802889438007338,.13371423612729252503412567154133090,
            .01078708528953292731070298166591233,.36087827036133643028378433162192850,
            .04888641015641196213015335363186247,.12856000707434670174510612755634180,
            .04079047843492138579001393428298806,.23192922019831618515287729451119134,
            .10225476525427212998164710587805099,.21318238024685212224076314392042087,
            .05619510372649343472752614615138017,.34615363893081412151163375832691108,
            .19392111402204940534236787859220491,.35741779412597604193763009688130316,
            .13139693759954925634229231531863966,.30964180048539107980510336108955521];
        
        
    case 22
        
        % /* The rule below is reported in the paper:
        %  *	Papanicolopulos, S., A.,
        %  * 	New fully symmetric and rotationally symmetric cubature rules on the
        %  * 	triangle using minimal orthonormal bases,
        %  *	J. Computational and Applied Mathematics, Vol. 294, 2016, pp.39-48 */
        %  FLOAT QUAD_2D_P22_wts[] = {
        W=[ .00069714569625074030369942481362133,
            .00173365376198036236244040089465219,
            .00466131304304557368006266059260170,
            .01158457676559956471190194225470023,
            .01187897403302190998142733919159934,
            .01533880365566670016085333491517060,
            .01971637694027233703178135471037246,
            .02057215149173475351932757540044250,
            .02384066027813703919931347525917147,
            .02446119708987487225534932817494781,
            .00182862802731120927204804019418561,
            .00188044970396283839898767788993490,
            .00370410864001110188501003141229496,
            .00466834037183480579057625840302880,
            .00721134117192958564362665357306283,
            .00796743335988734266364119940269571,
            .00903580036943713630598503580960509,
            .00948064111155901466263790694355664,
            .01561737012835320857159572546229795,
            .01624531918105698418898193939757981,
            .02178480822353151268049778007478454];
        %
        %  FLOAT QUAD_2D_P22_pts[LengthQUAD_2D_P22_wts * 3] = {
        V2=[ .00722823551590805269240186985118743,
            .49971491656223188463531154910591767,
            .04195252727280408802705553682804348,
            .31413219152050094565940577630042994,
            .48001365161711654879356466888729030,
            .12308745423016114898448687333895172,
            .44571963043911530549256371899531770,
            .18986241218389367642303052024426076,
            .26033923338175577283598939801891875,
            .39636684767162598240715439210378845,];
        V1=[
            .00773958468860307799587341381217818,.03910016782732837999359532547054414,
            .00057706413021840388680988197995853,.29956301031600608000000000000000000,
            .00979577185352314036856347829609728,.09916758085225246952608204467401148,
            .00918868020649896490029828421437019,.18619068155280570806618576756346898,
            .01346708756840181797029316077776570,.40293889185510044331704310704540997,
            .05062631246733689522786952921020785,.10358808540929187702277517444504398,
            .04838811776183765022487372116607709,.18082300688832890010580439799931826,
            .02749143585326034673258117826660649,.28194341507949187524318191991162303,
            .06713397444770439007586079560898384,.35071285339799134366628146898304461,
            .09670430361686034561495436311127678,.23017640440360132139166340852745074,
            .15193045482670229286438888320778608,.31159323586348644974639923203001594];
        
    case 22
        
        % /* The rule below is reported in the paper:
        %  *	Papanicolopulos, S., A.,
        %  * 	New fully symmetric and rotationally symmetric cubature rules on the
        %  * 	triangle using minimal orthonormal bases,
        %  *	J. Computational and Applied Mathematics, Vol. 294, 2016, pp.39-48 */
        % %  FLOAT QUAD_2D_P23_wts[] = {
        W=[.00102338493393064825880875292048368,
            .00234953285611607429820752203919566,
            .00442272294831746458300712854673892,
            .00935939493458907159588059346569364,
            .01122330490795551618339838001860665,
            .01145539386071866483451404196187953,
            .01485152819027043031788493609445202,
            .01873399097752303244589658710992199,
            .02009544889817501015648393973138171,
            .02186952160246302231865049077371942,
            .00139037413890586280792572004623041,
            .00209361317170022977809045175923150,
            .00226272789116058493926098904342501,
            .00509887607853182356576648513174798,
            .00580279248634163562097040517303610,
            .00699047412016323154662825915726588,
            .01010544741268549508636466193618720,
            .01094068682011104235992829469791130,
            .01269774746720014444245594705387966,
            .01493690521473593308948584780344384,
            .01624594488896314707519973030797813,
            .02040896492113806885822368822529305];
        %
        %  FLOAT QUAD_2D_P23_pts[LengthQUAD_2D_P23_wts * 3] = {
        V2=[ .00884309098564000781144468419871075,
            .49904231799536473576318688106778703,
            .04191849463192120115455956274854522,
            .08384395940074188671519383182016759,
            .35156602225687808437472423305189879,
            .48142250008209757218970635991224348,
            .13603683917665686011746620285416514,
            .44588621023292908434421744174344724,
            .19833791969077397732302473244075886,
            .39764873352592070572902821621712745,];
        V1=[
            .00215375088982479143593969096276917,.11147822164436514858831541609060182,
            .00797567048343379974299672675667051,.04599876191192738898335879375393121,
            .00222521306870228962165445623994274,.29991704500621364115075519706889153,
            .01056799023421332981938693231799616,.19450617255148173513923298602622080,
            .02639015796005238716769753666365164,.10487601375183195540194359053325350,
            .01372661478891633442412470482374058,.39359274155812221677807114606384301,
            .03293167071711912354883994110324428,.27745010154284908600010796990105572,
            .05645836928678800749584878194121292,.17041930960722382214358721748321713,
            .24905869950604636107649169253437782,.28048464594062623291197233102900262,
            .06710022884559872615982757386133093,.35940684385217631018244572992741760,
            .10095848404745636455551318905522403,.23967897332407877845308433492438781,
            .15208140311691476836002821658866124,.31660538238914823066544783358734965];
        
    case 24
        % /* The rule below is reported in the paper:
        %  *	Papanicolopulos, S., A.,
        %  * 	New fully symmetric and rotationally symmetric cubature rules on the
        %  * 	triangle using minimal orthonormal bases,
        %  *	J. Computational and Applied Mathematics, Vol. 294, 2016, pp.39-48 */
        %  FLOAT QUAD_2D_P24_wts[] = {
        W=[.02293794348096749067720820639821200,
            .00076737746111581423045153600120047,
            .00552357844475169754997038457424443,
            .00838499530275631071273403550487762,
            .01221738017800235239788392469826439,
            .01307039060561178310890784719893180,
            .01788122775842957825015047766363903,
            .01822174413909730956979133198261050,
            .02164149721756761699449458590855473,
            .02168831292692260197279166115848309,
            .00174618458266172170313203275603945,
            .00183857160374278724340785925075360,
            .00199893663336212883772988094673110,
            .00206369617133590779327617815189614,
            .00229539508715841568165484400462521,
            .00457952328890823144675590528548258,
            .00529323009909540365054590996973504,
            .00557874699599088171390666100209646,
            .00861933948725664134146173130325259,
            .00999235399224706921212863098136616,
            .01030561620768130769226672677282150,
            .01460454612625024725227714201539116,
            .01499850067625046347206078267251109,
            .01923078311743667878627312147552622];
        %
        %  FLOAT QUAD_2D_P24_pts[LengthQUAD_2D_P24_wts * 3] = {
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .00764481587209140357148961957868539,
            .49512326693489419346010327445636948,
            .08533571470774055253577908615445653,
            .47540435757943002732921306991884855,
            .14361312600254966163076940146917127,
            .44000137550057370651541171540277806,
            .20438684787130391661942173912629914,
            .39155520703268199132653695865910252,
            .26936069184956821890376700734821267,];
        V1=[
            .00128915765322182138873877223282987,.38930032117370399940994358985608046,
            .00804615544134750962080148406751868,.03994551899851089671071946872000290,
            .00397463904079080448292596145774045,.17756755351844720149250759536631588,
            .00565339683877998034115515308702144,.09730437316339079594262256407299041,
            .03654164634700071865936106746572505,.04737913646955582393784813835746318,
            .00847203125278924422001665909111615,.27654233490622630027478984616955668,
            .03186878555848486368527331611156268,.10186004800841345175103882567179717,
            .02507448575695932327989859470575696,.17990041142989784948776341885611339,
            .02495464920723698331110869690511693,.37476148829145151703198672023817762,
            .07180692748992666960708660113790562,.16285371365641890528167019069210662,
            .04649536832522560731056542252010275,.26299994692532693286696577835230479,
            .07944565832892777248067300362002874,.35387462268603241581179193663132046,
            .11210496839891452618514886571897182,.24045272001109686579097131221331152,
            .16288704432089312482891199962593472,.31632883636136616749409848630342490];
        %
        
        %
        
        % /* The rule below is reported in the paper:
        %  *	S. Wandzura and H. Xiao, Symmetric quadrature rules on a triangle,
        %  *	Computers and Mathematics with Applications, 45 2003, 1829C1840,
        %  * and was communicated by Don Wilton dwilton@mindspring.com */
        %  FLOAT QUAD_2D_P25_wts[] = {
    case 25
        
        W=[ .00800558188002042313368589293942171,
            .01594707683239049085408554937789681,
            .01310914123079550369839487163291327,
            .01958300096563560520647726105123795,
            .01647088544153726359394636789647424,
            .00854727907409214131204679403754348,
            .00816188585722650120293135168156145,
            .00612114653998375062550303141747500,
            .00290849826493666035989604760244737,
            .00069227524566199872959231564688970,
            .00124828919927740405463308732687347,
            .00340475290880302630290932517884509,
            .00335965432606405469389982622818046,
            .00171615653949675776835927257382091,
            .00148085631671560275966191325505238,
            .00351131261072868028754024041382735,
            .00739355014970648910670774728325426,
            .00798308747737656611293770143977919,
            .00435596261315803802370299459187773,
            .00736505670141783108374850348433179,
            .01096357284641954589593589943582605,
            .01174996174354112327739198111865119,
            .01001560071379857640896706453029824,
            .01330964078762866755490152722632760,
            .01415444650522613072733705129605375,
            .01488137956116800324975278964173671];
        %
        %  FLOAT QUAD_2D_P25_pts[LengthQUAD_2D_P25_wts * 3] = {
        V2=[ .48602675846341286632108494106576852,
            .43441069933617422686934557925604870,
            .38988913524396382753969636952404462,
            .29844323401980449068329287355490048,
            .23404417233737183658023656970596734,
            .15146833460901760000000000000000000,
            .11273389354599349281729186486594851,
            .07771569209152620223369817320827966,
            .03489309361429690849533026177733858,
            .00725818462093238916117013110606335,];
        V1=[
            .00129235270444219584099302931665302,.22721445215336410000000000000000000,
            .00539970127211620182189732363132860,.43501055485357173125113362379450230,
            .00638400303397498941895749776744540,.32030959927220447113000026445341979,
            .00502821150199308271328582097413442,.09175032228000531039287201063543536,
            .00682675862178184570668051931419220,.03801083585872443391784793002157854,
            .01001619963992951145867446496978043,.15742521848531178511320753380098114,
            .02575781317339004661287123576293491,.23988965977853325914298591466950265,
            .03022789811991582345896227492462806,.36194311812606053179871201193912355,
            .03050499010716207795935512861230592,.08355196095482845510691464351287596,
            .04595654736256931928622033280840303,.14844322073241812268238560824628123,
            .06744280054027761427028802732221226,.28373970872753497227148332506495505,
            .07004509141591061747706842947324321,.40689937511878760390382808292080011,
            .08391152464011664050042868280051014,.19411398702489250643935208871855679,
            .12037553567715270000000000000000000,.32413434700070320631848835964861372,
            .14806689915736669746097550576436943,.22927748355598104616627200389359665,
            .19177186586732510675561189736742768,.32561812259598383120936369037062376];
        
    case 26
        W=[.01417752160999602353323977972271527,
            .01562847738814814970970457453697594,
            .01463752622911178264133988219347403,
            .01199877346634344861456211855900933,
            .01408927503571013898691920328509770,
            .01137089506541742371508421522672789,
            .00576148405319945074736514087034656,
            .00288047484993807908673712870762860,
            .00061792400780682863983571128624684,
            .00369419331787613967876812943308712,
            .00343799094677204927555439258769779,
            .00286153444220796869854630479719978,
            .00203926220043675486828725055944921,
            .00212260415935469294564133350026422,
            .00119562615477588655866810063068187,
            .00685739162489405400311650380844794,
            .00734359958211473751194803942744208,
            .00692380910755335710497733455285917,
            .00568034562903817703600660475801349,
            .00482902212700270888221406835346564,
            .01217016111615610869604849372625312,
            .01093398470027832184481918666951027,
            .00874472678661106729318818910817295,
            .00680604517250698803302377412054323,
            .01411590919743288381954091229224022,
            .01311478562571945830368980380706058,
            .01294033945976499045298096058107199];
        %
        %  FLOAT QUAD_2D_P26_pts[LengthQUAD_2D_P26_wts * 3] = {
        V3=[ .33333333333333333333333333333333333,];
        V2=[
            .42738077638464831074877265985432388,
            .38699172838462112393769349339592202,
            .29080160649677600000000000000000000,
            .21955119391561192225377283920396941,
            .14147766876769242783780816190264115,
            .08529773902470504192646771859292695,
            .03245379871194203562256093430387330,
            .00688528565235726390272245979876787,];
        V1=[
            .43994521155768505420225073420375411,...
            .55367421644525807832051112152536738,
            .32999703483323129491627843183841851,...
            .66364319673874589711499831297210598,
            .23082959156933124460906369415091164,...
            .76308863521363336439140145775470392,
            .14794411408540751228070615912033131,...
            .84674293184236109088401920967886276,
            .08331051165939022562807285094666142,...
            .90927752172075602921190126258082178,
            .03550260326758216848726613913161973,...
            .95859557015929357672073151433554495,
            .43799285096397419659511807977149749,...
            .52875010002019513801184885338236967,
            .34184511530123979780425420810756385,...
            .62501066255799393838930209588631898,
            .24321991316551786475075820451965981,...
            .72464470136332536323906998980156002,
            .15369391178063810461104521948139224,...
            .81668780811826632451173297381674549,
            .08182824840515584556272055876947980,...
            .88137737650647236457017244683395591,
            .40543528702386735945093314372836966,...
            .51444288504473371249851667233726474,
            .30047523445100120928119574237532588,...
            .62059693664252388102960854157646856,
            .21029877498305665945876052946338960,...
            .71260468401313836547438957626142950,
            .14192949723680286586293618687501310,...
            .78364422636910025200372459985859611,
            .32282570605532179374541311121620042,...
            .53538969633347138690064718160659645,
            .22503850086766503651915588373212567,...
            .63399334111941569685209117569438308,
            .30622801452292528203795810454570981,...
            .48023900880456248705776905427268046];
        
    case 27
        
        W=[ .00132645422676788269875694817310637,
            .01017606777254880480746165608356455,
            .01355363518955792585297110164615270,
            .01435575232352898855810447417832482,
            .01762154025479284493331530463863313,
            .01286456612407540576521896438320606,
            .01021120788721442034062871052526150,
            .00805484559136441340259536953879069,
            .00485083247712445072994650912354335,
            .00276034923845063648517112406186915,
            .00064652022402423359706690809995414,
            .00298280618704304171833833804758432,
            .00286890029157565788749757647924691,
            .00146771786779737406777795858954528,
            .00163545643437809674920446933139427,
            .00326270663499477733596716702887470,
            .00127830372794885836417837000658451,
            .00355054931897130700729806858502069,
            .00705687847901615495175919551339405,
            .00710874754932738751234293916033450,
            .00619331568447356835579144233234119,
            .00430573263634848540647054196708181,
            .00538152713709093753671677026319717,
            .00946147607081304454837567274132095,
            .01038776441184486432462624183330042,
            .00693741437082199035643509373698783,
            .01056786087493971379972576670902532,
            .01001591520410395750929434758482549,
            .01145776939470566123752859291178484,
            .01297709014466941197797189467632131];
        %
        %  FLOAT QUAD_2D_P27_pts[LengthQUAD_2D_P27_wts * 3] = {
        V3=[ .33333333333333333333333333333333333,];
        V2=[
            .46427084805466920349262004314703836,
            .43229831434028157352333551631753476,
            .39075381477193176882883899825279826,
            .29984903083812250736371384535095833,
            .24238609336669501198579355664452309,
            .19575163384470794764935880541589295,
            .11096422071801854111207889228991412,
            .06784943782072336611132231104850517,
            .03248814431443691367844218208374596,
            .00702227048619495308291407220447055,];
        V1=[
            .44433448769671943201275224300444114,...
            .55016916248187282000891941332861776,
            .24271988774832453561075341685216292,...
            .75119868054856110177318171512240453,
            .15818892475209601952406305738166283,...
            .83835069531284232651520750772598161,
            .08845560649090179633078521783025438,...
            .90629410967510652581883999276555543,
            .33999316891507000002332849881468819,...
            .65372187099256441503697325319687970,
            .03671154847229659731571109853308589,...
            .95724604370116430180960160528414269,
            .08124029610361356005058157071908989,...
            .89177919384281966240532352562349587,
            .43194999140455781310320628223711064,...
            .53892333102966923458236030560490706,
            .32699693161719831316306130873483095,...
            .64047090201394740296518952785936033,
            .23408117072735995645396481889795017,...
            .73431597148508412293269931866205238,
            .15347363272308466475181254734395719,...
            .82492267618399551423539156004582949,
            .12699941589030054190683503157639795,...
            .81688483424950280690392059398500667,
            .36806660226545525465188762517330287,...
            .55934053585742889058858737838306859,
            .26979607114851247262701085083588115,...
            .65088590636580683812387505565452156,
            .18699471085773505905185124894492060,...
            .74499601198138427785033316282140954,
            .34595044287272788784072078462621499,...
            .52709408040032769073500598867000113,
            .18245632238005479720023182986667859,...
            .69385768740918414496471841615003464,
            .26018384965949842909231289915918049,...
            .59478379886135638965559275913807350,
            .31984867358313578155757977176391537,...
            .48237346031069377766871464449285085];
        
    case 28
        W=[ .00372851181690746808458802773780931,
            .00193654415522499089798121523079372,
            .00605141039266348349682076643537264,
            .01141411355071663950946117311831634,
            .01608007376313012939112012516866485,
            .01403532910432407033763380729780537,
            .00978327794286426243399757092983715,
            .01267830169820560106561705330317056,
            .01011411585946974486266089228810336,
            .00376318422499545225814714605310903,
            .00243119330615522129960297283149783,
            .00042588994531646428122960119842518,
            .00206901772064515543837924811367839,
            .00215432386268054430571141067616092,
            .00166065394763716989540584667501249,
            .00138084032913645059993106848688128,
            .00360171025661803306118091200062737,
            .00097386114094506619777294737048538,
            .00535413394306626012053016995775099,
            .00423736286661477466768017827663045,
            .00330847570421703082215419515418717,
            .00448583942101861046216741271009491,
            .00776555845120818901711264608747662,
            .00687043734971177067707693439653168,
            .00584068837096601687691778384738186,
            .00888657317183860444062439413402823,
            .01038315778562466496474547463182699,
            .00655128753862388719526464995777170,
            .00877076875255828946048204111223478,
            .01218892935729072907621500755722349,
            .01250643549629844281533668106200953,
            .01269847559228270197407683124148953];
        %
        %  FLOAT QUAD_2D_P28_pts[LengthQUAD_2D_P28_wts * 3] = {
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .49835341312677973221949148740253129,
            .48856275409050881854170094866703248,
            .46478147828724737521816425323927792,
            .38976627332101772838564635544311420,
            .30154675118298200000000000000000000,
            .26157407405925900000000000000000000,
            .21410788634590951182959860455114779,
            .17013819127147552416852263597020987,
            .06437078350269442260455184210867187,
            .03056003210401320908223320131174623,
            .00570940793308473608535324150722078,];
        V1=[
            .29536153497141490674708319047417597,...
            .70085350685240175269511103394845061,
            .20287670215559760434708665743838398,...
            .79193561974577570926640621745254478,
            .12817949523631330608909975560928685,...
            .86701504698388816611813701911598314,
            .07052544109205498392587648111966164,...
            .92391986491477366531821910182946052,
            .39532631740896702860171237522193030,...
            .59771306110677331467243551041521591,
            .02956827316914143637172672359648260,...
            .96465253113231383432304266408275803,
            .30675094998690715371535728527788425,...
            .66850082953013352645351336823624571,
            .22517182313337122500507617369889188,...
            .75132263382025994493510577224942991,
            .07635892427059552575901260109062831,...
            .89611941137326587665824353804536658,
            .14042475531972069418905256134644577,...
            .83328227859710106355842490700741297,
            .39118747052871590865900820029002383,...
            .57082898894634335709509739044406166,
            .19396081112987221646366179522225910,...
            .75010271498110326795986200675381153,
            .11586020721321567595528110784524463,...
            .81777490624407893257309046195761535,
            .28023728574593295635247200998364845,...
            .65528264369963779978719065630966078,
            .35489334757487301545619510855666152,...
            .55787563056563336146991239029436233,
            .14534210735467833470209926430836432,...
            .74965464658825236845917501382975580,
            .21353594460615902118568163630567554,...
            .67815620035398476715714603087527412,
            .38905986757978011881345023070696881,...
            .47478610218807292068119420965885141,
            .27562890222960030201915925622737738,...
            .58603008200093619992681987776326855,
            .31377995329904710006329372044106871,...
            .49151146351194286330016259453399046];
        
    case 29
        %  FLOAT QUAD_2D_P29_wts[] = {
        W=[.01390369197243498012196860526728523,
            .00119407074555933681859037971323571,
            .00558417807814421700320296020710969,
            .01401429650050351710041595861194328,
            .01410780604708034305616878409304137,
            .01342810431576591351787528351663394,
            .01217537497609338458269338763086290,
            .00722294427143959319468499698239233,
            .00443751867960735637759182913807913,
            .00019771881519265609682851845605640,
            .00129189419129147303154103509431602,
            .00112772642035394166015974617443553,
            .00184745171735374848441682404155343,
            .00071782203324654941618021167082972,
            .00351318664214703198725396103172539,
            .00349660600844854338988705837555120,
            .00241690948038281274650124841577492,
            .00081313466613996608724908914031470,
            .00564942974660398293146765321429865,
            .00445904031659885067338404631595062,
            .00185640152529500022792451101805069,
            .00701742231395962656370871380070187,
            .00476963067992196310852157152860163,
            .00768181583252764607257537723234668,
            .00866304121915658321589732638654127,
            .00694192073189620264349957702824600,
            .00608713825993680733195825320444232,
            .00987867211691082287437749173658670,
            .01040317740016649468355653503351506,
            .00677295750139824628718993144871263,
            .00832356466794721739792214655562608,
            .01175825678556958331667970045402759,
            .01268117819931458364046050771195975];
        %
        %  FLOAT QUAD_2D_P29_pts[LengthQUAD_2D_P29_wts * 3] = {
        V3=[.33333333333333333333333333333333333,];
        V2=[
            .49941626286799955409520464498316269,
            .48948346983261497522938052895559610,
            .38337490646926000907612840544797942,
            .28657967124624950515035657391568590,
            .23675743798075908296846185092132762,
            .18444854262549379977888738237869426,
            .09592097238345002706204055857161251,
            .05732663714886085602392016667935097,
            .00360814709934401389942946854275571,];
        V1=[
            .32459168027628713302158859225874986,...
            .67371212175894638940968866052450810,
            .20538296110395026907966241605897587,...
            .79285585098032246467154265489876875,
            .12781715504878891712709027697510756,...
            .86682261130980615198333080160570653,
            .06397213170443202744985506555180679,...
            .93422003016808671513846621034706181,
            .40877270304610163463977433263460813,...
            .58330425747295030197062188244089100,
            .26000366001505949148390106470940356,...
            .72820244365190777874589416567626502,
            .08370103760471207151750106127384500,...
            .89846466640643977698190152996194171,
            .02277724243943714846816275979306666,...
            .97158629182957065178007512301223061,
            .33249703304933480878170490873619909,...
            .64248824389424048968615511405857584,
            .17546771597780866991339541376496896,...
            .80343317590650447549486585236617441,
            .04239144337139153742306881985042489,...
            .93728223742102642341436645741650662,
            .23808696074926436006355587074260398,...
            .71698190885093363334019663932316818,
            .11385025949319543285234976170424461,...
            .84431131334463485469301787175078758,
            .40769947121073335745665277255775013,...
            .54824721541790114707748890982833737,
            .30971996601029726066117003751273698,...
            .62232557895213827911084197477161010,
            .16501257707342404851428639610530038,...
            .76776792910869773214284522469888712,
            .43736489346938777507788866536148926,...
            .48468874869866900000000000000000000,
            .23036169231961739485460160639223048,...
            .66627592302530221745209390079397421,
            .35305476702238759018727511157688575,...
            .54053899274173894698475001785466288,
            .15871875580457590021286449358564550,...
            .72119885820756830541154885697690356,
            .40214959194205300000000000000000001,...
            .45482738530050760506736521027227478,
            .27186848606196062046228695803969211,...
            .57716886061275534659861021805529577,
            .32870389995531448574405098549674708,...
            .47881463249708848352487404443818064];
        
end

if isempty(V1)+isempty(V2)+isempty(V3) < 3
    L3=size(V3,1);
    L2=size(V2,1);
    L1=size(V1,1);
    
    if L3 > 0
        V3=[W(1)];
    end
    
    if L2 >0
        V2=[W(L3+1:L3+L2) V2];
    end
    
    if L1 >0
        V1=[W(L3+L2+1:end) V1];
    end
    
end


