
 	 function xyw=set_lyness_jespersen_(deg) 
 

 	 % --------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % --------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 % --------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
 	 % --------------------------------------------------------------------
 
      	 %----------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %----------------------------------------
 	 % |   1 |   1 |   0 |   0 | 1.92e-16 |PI|
 	 % |   2 |   3 |   0 |   0 | 2.78e-16 |PI|
 	 % |   3 |   4 |   1 |   0 | 2.78e-16 |NI|
 	 % |   4 |   9 |   0 |   0 | 3.05e-16 |PI|
 	 % |   5 |   7 |   0 |   0 | 4.02e-16 |PI|
 	 % |   6 |  12 |   0 |   0 | 1.29e-13 |PI|
 	 % |   7 |  13 |   1 |   0 | 2.17e-14 |NI|
 	 % |   8 |  16 |   0 |   0 | 8.24e-15 |PI|
 	 % |   9 |  19 |   0 |   0 | 8.31e-15 |PI|
 	 % |  11 |  28 |   0 |   0 | 3.57e-14 |PI|
 	 %---------------------------------------
 
 
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
     
 	 switch deg
 
 	 case   1 

 	 % ALG. DEG.:    1
 	 % PTS CARD.:    1
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.9e-16  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333314830e-01 5.00000000000000000000e-01
 	 ];
 
 	 case   2 

 	 % ALG. DEG.:    2
 	 % PTS CARD.:    3
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.8e-16  

 	 xyw=[
 	 0.00000000000000000000e+00 5.00000000000000000000e-01 1.66666666666666657415e-01
 	 5.00000000000000000000e-01 0.00000000000000000000e+00 1.66666666666666657415e-01
 	 5.00000000000000000000e-01 5.00000000000000000000e-01 1.66666666666666657415e-01
 	 ];
 
 	 case   3 

 	 % ALG. DEG.:    3
 	 % PTS CARD.:    4
 	 % NEG. W.  :    1
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.8e-16  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333314830e-01 -2.81250000000000000000e-01
 	 5.99999999999999977796e-01 1.99999999999999955591e-01 2.60416666666666685170e-01
 	 2.00000000000000011102e-01 5.99999999999999977796e-01 2.60416666666666685170e-01
 	 2.00000000000000011102e-01 1.99999999999999955591e-01 2.60416666666666685170e-01
 	 ];
 
 	 case   4 

 	 % ALG. DEG.:    4
 	 % PTS CARD.:    9
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.1e-16  

 	 xyw=[
 	 1.00000000000000000000e+00 0.00000000000000000000e+00 1.02700676729666814241e-02
 	 0.00000000000000000000e+00 1.00000000000000000000e+00 1.02700676729666814241e-02
 	 0.00000000000000000000e+00 0.00000000000000000000e+00 1.02700676729666814241e-02
 	 0.00000000000000000000e+00 5.00000000000000000000e-01 3.09877494341335747718e-02
 	 5.00000000000000000000e-01 0.00000000000000000000e+00 3.09877494341335747718e-02
 	 5.00000000000000000000e-01 5.00000000000000000000e-01 3.09877494341335747718e-02
 	 6.22839030607109989113e-01 1.88580484696444949932e-01 1.25408849559566409892e-01
 	 1.88580484696445060955e-01 6.22839030607109878090e-01 1.25408849559566409892e-01
 	 1.88580484696445060955e-01 1.88580484696444949932e-01 1.25408849559566409892e-01
 	 ];
 
 	 case   5 

 	 % ALG. DEG.:    5
 	 % PTS CARD.:    7
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 4.0e-16  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 1.12500000000000002776e-01
 	 7.97426985353087203201e-01 1.01286507323456453911e-01 6.29695902724135836426e-02
 	 1.01286507323456329011e-01 7.97426985353087314223e-01 6.29695902724135836426e-02
 	 1.01286507323456329011e-01 1.01286507323456453911e-01 6.29695902724135836426e-02
 	 5.97158717897698088084e-02 4.70142064105115164985e-01 6.61970763942530820989e-02
 	 4.70142064105115053962e-01 5.97158717897698920751e-02 6.61970763942530820989e-02
 	 4.70142064105115053962e-01 4.70142064105115164985e-01 6.61970763942530820989e-02
 	 ];
 
 	 case   6 

 	 % ALG. DEG.:    6
 	 % PTS CARD.:   12
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.3e-13  

 	 xyw=[
 	 5.01426509658134178515e-01 2.49286745170932855231e-01 5.83931378631703731918e-02
 	 2.49286745170932910742e-01 5.01426509658134178515e-01 5.83931378631703731918e-02
 	 2.49286745170932910742e-01 2.49286745170932855231e-01 5.83931378631703731918e-02
 	 8.73821971016996545956e-01 6.30890144915017270222e-02 2.54224531851027328588e-02
 	 6.30890144915017686555e-02 8.73821971016996545956e-01 2.54224531851027328588e-02
 	 6.30890144915016853888e-02 6.30890144915017270222e-02 2.54224531851027328588e-02
 	 6.36502499121393894299e-01 3.10352451033773957256e-01 4.14255378091964582277e-02
 	 5.31450498448321623224e-02 6.36502499121393894299e-01 4.14255378091964582277e-02
 	 3.10352451033773957256e-01 5.31450498448321484446e-02 4.14255378091964582277e-02
 	 5.31450498448321623224e-02 3.10352451033773957256e-01 4.14255378091964582277e-02
 	 3.10352451033773957256e-01 6.36502499121393894299e-01 4.14255378091964582277e-02
 	 6.36502499121393894299e-01 5.31450498448321484446e-02 4.14255378091964582277e-02
 	 ];
 
 	 case   7 

 	 % ALG. DEG.:    7
 	 % PTS CARD.:   13
 	 % NEG. W.  :    1
 	 % OUT PTS. :    0
 	 % M.E.INF. : 2.2e-14  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 -7.47850222338747455675e-02
 	 4.79308067841906715323e-01 2.60345966079046697850e-01 8.78076287166137947615e-02
 	 2.60345966079046586827e-01 4.79308067841906715323e-01 8.78076287166137947615e-02
 	 2.60345966079046697850e-01 2.60345966079046586827e-01 8.78076287166137947615e-02
 	 8.69739794195567461621e-01 6.51301029022163247006e-02 2.66736178044194478798e-02
 	 6.51301029022162275561e-02 8.69739794195567461621e-01 2.66736178044194478798e-02
 	 6.51301029022163108229e-02 6.51301029022162136783e-02 2.66736178044194478798e-02
 	 6.38444188569809556455e-01 3.12865496004872900571e-01 3.85568804451291644031e-02
 	 4.86903154253175568522e-02 6.38444188569809556455e-01 3.85568804451291644031e-02
 	 3.12865496004872900571e-01 4.86903154253175429744e-02 3.85568804451291644031e-02
 	 4.86903154253175568522e-02 3.12865496004872900571e-01 3.85568804451291644031e-02
 	 3.12865496004872900571e-01 6.38444188569809556455e-01 3.85568804451291644031e-02
 	 6.38444188569809556455e-01 4.86903154253175429744e-02 3.85568804451291644031e-02
 	 ];
 
 	 case   8 

 	 % ALG. DEG.:    8
 	 % PTS CARD.:   16
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.2e-15  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 7.21578038388931003455e-02
 	 8.14148234145541244144e-02 4.59292588292723014121e-01 4.75458171336424831321e-02
 	 4.59292588292722903098e-01 8.14148234145540827811e-02 4.75458171336424831321e-02
 	 4.59292588292723014121e-01 4.59292588292722903098e-01 4.75458171336424831321e-02
 	 8.98905543365937864664e-01 5.05472283170310676681e-02 1.62292488115990674036e-02
 	 5.05472283170310329736e-02 8.98905543365937864664e-01 1.62292488115990674036e-02
 	 5.05472283170311023626e-02 5.05472283170310676681e-02 1.62292488115990674036e-02
 	 6.58861384496479685069e-01 1.70569307751760268488e-01 5.16086852673591986451e-02
 	 1.70569307751760101954e-01 6.58861384496479685069e-01 5.16086852673591986451e-02
 	 1.70569307751760212977e-01 1.70569307751760046443e-01 5.16086852673591986451e-02
 	 8.39477740995721137540e-03 2.63112829634638667464e-01 1.36151570872174321886e-02
 	 7.28492392955404133303e-01 8.39477740995719923234e-03 1.36151570872174321886e-02
 	 2.63112829634638667464e-01 7.28492392955404133303e-01 1.36151570872174321886e-02
 	 7.28492392955404133303e-01 2.63112829634638667464e-01 1.36151570872174321886e-02
 	 2.63112829634638667464e-01 8.39477740995719923234e-03 1.36151570872174321886e-02
 	 8.39477740995721137540e-03 7.28492392955404133303e-01 1.36151570872174321886e-02
 	 ];
 
 	 case   9 

 	 % ALG. DEG.:    9
 	 % PTS CARD.:   19
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 8.3e-15  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 4.85678981413980512261e-02
 	 2.06349616025259287311e-02 4.89682519198737065125e-01 1.56673501135699173858e-02
 	 4.89682519198737009614e-01 2.06349616025259807728e-02 1.56673501135699173858e-02
 	 4.89682519198737009614e-01 4.89682519198737065125e-01 1.56673501135699173858e-02
 	 1.25820817014129004985e-01 4.37089591492935469752e-01 3.89137705023877150667e-02
 	 4.37089591492935525263e-01 1.25820817014129060496e-01 3.89137705023877150667e-02
 	 4.37089591492935414241e-01 4.37089591492935580774e-01 3.89137705023877150667e-02
 	 6.23592928761935616500e-01 1.88203535619032136239e-01 3.98238694636045484354e-02
 	 1.88203535619032191750e-01 6.23592928761935616500e-01 3.98238694636045484354e-02
 	 1.88203535619032191750e-01 1.88203535619032136239e-01 3.98238694636045484354e-02
 	 9.10540973211094062378e-01 4.47295133944529688108e-02 1.27888378293490503207e-02
 	 4.47295133944529688108e-02 9.10540973211094062378e-01 1.27888378293490503207e-02
 	 4.47295133944529688108e-02 4.47295133944529688108e-02 1.27888378293490503207e-02
 	 3.68384120547362581277e-02 2.21962989160765733487e-01 2.16417696886447019633e-02
 	 7.41198598784498008385e-01 3.68384120547362581277e-02 2.16417696886447019633e-02
 	 2.21962989160765733487e-01 7.41198598784498008385e-01 2.16417696886447019633e-02
 	 7.41198598784498008385e-01 2.21962989160765733487e-01 2.16417696886447019633e-02
 	 2.21962989160765733487e-01 3.68384120547362581277e-02 2.16417696886447019633e-02
 	 3.68384120547362581277e-02 7.41198598784498008385e-01 2.16417696886447019633e-02
 	 ];
 
 	 case  11 

 	 % ALG. DEG.:   11
 	 % PTS CARD.:   28
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.6e-14  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 4.39886505811109482234e-02
 	 9.48021718143423286485e-01 2.59891409282884122689e-02 4.37215577686809499236e-03
 	 2.59891409282883290022e-02 9.48021718143423286485e-01 4.37215577686809499236e-03
 	 2.59891409282883845133e-02 2.59891409282883012466e-02 4.37215577686809499236e-03
 	 8.11424994704154634029e-01 9.42875026479226274745e-02 1.90407859969676657164e-02
 	 9.42875026479226968634e-02 8.11424994704154634029e-01 1.90407859969676657164e-02
 	 9.42875026479226691078e-02 9.42875026479227384968e-02 1.90407859969676657164e-02
 	 1.07264499655705999176e-02 4.94636775017214702643e-01 9.42772402806562638544e-03
 	 4.94636775017214702643e-01 1.07264499655705947134e-02 9.42772402806562638544e-03
 	 4.94636775017214702643e-01 4.94636775017214702643e-01 9.42772402806562638544e-03
 	 5.85313234770971524412e-01 2.07343382614514237794e-01 3.60798487723704985886e-02
 	 2.07343382614514210038e-01 5.85313234770971524412e-01 3.60798487723704985886e-02
 	 2.07343382614514265549e-01 2.07343382614514237794e-01 3.60798487723704985886e-02
 	 1.22184388599018700639e-01 4.38907805700490594170e-01 3.46645693527685982982e-02
 	 4.38907805700490705192e-01 1.22184388599018700639e-01 3.46645693527685982982e-02
 	 4.38907805700490594170e-01 4.38907805700490705192e-01 3.46645693527685982982e-02
 	 0.00000000000000000000e+00 1.41129718717363572544e-01 3.68119189165028691535e-03
 	 8.58870281282636427456e-01 0.00000000000000000000e+00 3.68119189165028691535e-03
 	 1.41129718717363572544e-01 8.58870281282636427456e-01 3.68119189165028691535e-03
 	 8.58870281282636427456e-01 1.41129718717363572544e-01 3.68119189165028691535e-03
 	 1.41129718717363572544e-01 0.00000000000000000000e+00 3.68119189165028691535e-03
 	 0.00000000000000000000e+00 8.58870281282636427456e-01 3.68119189165028691535e-03
 	 4.48416775891305532942e-02 2.77220667528279229863e-01 2.05281577146443003357e-02
 	 6.77937654882590168270e-01 4.48416775891306018664e-02 2.05281577146443003357e-02
 	 2.77220667528279229863e-01 6.77937654882590168270e-01 2.05281577146443003357e-02
 	 6.77937654882590168270e-01 2.77220667528279229863e-01 2.05281577146443003357e-02
 	 2.77220667528279229863e-01 4.48416775891306018664e-02 2.05281577146443003357e-02
 	 4.48416775891305532942e-02 6.77937654882590168270e-01 2.05281577146443003357e-02
 	 ];
 

 	 otherwise
 	 xyw=[];
 	 end
 


 
