
 	 function xyw=set_lyness_jespersen_II(deg) 
 

 	 % --------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % --------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 % --------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
 	 % --------------------------------------------------------------------
 
     
 	 %----------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %----------------------------------------
 	 % |   2 |   4 |   0 |   0 | 1.39e-16 |PI|
 	 %---------------------------------------
 
 
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
     
 	 switch deg
 
 	 case   2 

 	 % ALG. DEG.:    2
 	 % PTS CARD.:    4
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.4e-16  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333314830e-01 3.75000000000000000000e-01
 	 1.00000000000000000000e+00 0.00000000000000000000e+00 4.16666666666666643537e-02
 	 0.00000000000000000000e+00 1.00000000000000000000e+00 4.16666666666666643537e-02
 	 0.00000000000000000000e+00 0.00000000000000000000e+00 4.16666666666666643537e-02
 	 ];
 

 	 otherwise
 	 xyw=[];
 	 end
 

 
