
 	 function xyw=set_lyness_jespersen_III(deg) 
 

 	 % --------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % --------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 % --------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
 	 % --------------------------------------------------------------------
 
     %----------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %----------------------------------------
 	 % |   3 |   7 |   0 |   0 | 3.33e-16 |PI|
 	 % |   4 |  10 |   3 |   0 | 6.11e-16 |NI|
 	 % |   5 |  10 |   0 |   0 | 3.05e-16 |PI|
 	 % |   6 |  13 |   0 |   0 | 3.08e-15 |PI|
 	 % |   7 |  16 |   0 |   0 | 1.50e-15 |PI|
 	 % |   8 |  21 |   3 |   0 | 6.55e-15 |NI|
 	 % |   9 |  22 |   0 |   0 | 3.89e-15 |PI|
 	 %---------------------------------------
 
 
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
     
 	 switch deg
 
 	 case   3 

 	 % ALG. DEG.:    3
 	 % PTS CARD.:    7
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.3e-16  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 2.25000000000000005551e-01
 	 1.00000000000000000000e+00 0.00000000000000000000e+00 2.49999999999999979183e-02
 	 0.00000000000000000000e+00 1.00000000000000000000e+00 2.49999999999999979183e-02
 	 0.00000000000000000000e+00 0.00000000000000000000e+00 2.49999999999999979183e-02
 	 0.00000000000000000000e+00 5.00000000000000000000e-01 6.66666666666666657415e-02
 	 5.00000000000000000000e-01 0.00000000000000000000e+00 6.66666666666666657415e-02
 	 5.00000000000000000000e-01 5.00000000000000000000e-01 6.66666666666666657415e-02
 	 ];
 
 	 case   4 

 	 % ALG. DEG.:    4
 	 % PTS CARD.:   10
 	 % NEG. W.  :    3
 	 % OUT PTS. :    0
 	 % M.E.INF. : 6.1e-16  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 2.25000000000000005551e-01
 	 1.00000000000000000000e+00 0.00000000000000000000e+00 -8.33333333333333321769e-03
 	 0.00000000000000000000e+00 1.00000000000000000000e+00 -8.33333333333333321769e-03
 	 0.00000000000000000000e+00 0.00000000000000000000e+00 -8.33333333333333321769e-03
 	 0.00000000000000000000e+00 2.11324865405187245493e-01 4.99999999999999958367e-02
 	 7.88675134594812754507e-01 0.00000000000000000000e+00 4.99999999999999958367e-02
 	 2.11324865405187189982e-01 7.88675134594812865529e-01 4.99999999999999958367e-02
 	 7.88675134594812754507e-01 2.11324865405187245493e-01 4.99999999999999958367e-02
 	 2.11324865405187189982e-01 0.00000000000000000000e+00 4.99999999999999958367e-02
 	 0.00000000000000000000e+00 7.88675134594812865529e-01 4.99999999999999958367e-02
 	 ];
 
 	 case   5 

 	 % ALG. DEG.:    5
 	 % PTS CARD.:   10
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.1e-16  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 1.26562499999999994449e-01
 	 1.00000000000000000000e+00 0.00000000000000000000e+00 5.55555555555555576758e-03
 	 0.00000000000000000000e+00 1.00000000000000000000e+00 5.55555555555555576758e-03
 	 0.00000000000000000000e+00 0.00000000000000000000e+00 5.55555555555555576758e-03
 	 0.00000000000000000000e+00 5.00000000000000000000e-01 3.55555555555555555247e-02
 	 5.00000000000000000000e-01 0.00000000000000000000e+00 3.55555555555555555247e-02
 	 5.00000000000000000000e-01 5.00000000000000000000e-01 3.55555555555555555247e-02
 	 7.14285714285714301575e-01 1.42857142857142793702e-01 8.33680555555555563574e-02
 	 1.42857142857142849213e-01 7.14285714285714301575e-01 8.33680555555555563574e-02
 	 1.42857142857142849213e-01 1.42857142857142793702e-01 8.33680555555555563574e-02
 	 ];
 
 	 case   6 

 	 % ALG. DEG.:    6
 	 % PTS CARD.:   13
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.1e-15  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 7.63544833941761508234e-02
 	 5.23383720926974688181e-02 4.73830813953651230896e-01 4.90679340394460372643e-02
 	 4.73830813953651286408e-01 5.23383720926974271848e-02 4.90679340394460372643e-02
 	 4.73830813953651286408e-01 4.73830813953651230896e-01 4.90679340394460372643e-02
 	 6.55764660738364923986e-01 1.72117669630817538007e-01 6.47842146403127677745e-02
 	 1.72117669630817510251e-01 6.55764660738364923986e-01 6.47842146403127677745e-02
 	 1.72117669630817565762e-01 1.72117669630817538007e-01 6.47842146403127677745e-02
 	 0.00000000000000000000e+00 1.34692645916542952378e-01 1.36815117610912407448e-02
 	 8.65307354083457047622e-01 0.00000000000000000000e+00 1.36815117610912407448e-02
 	 1.34692645916542952378e-01 8.65307354083457047622e-01 1.36815117610912407448e-02
 	 8.65307354083457047622e-01 1.34692645916542952378e-01 1.36815117610912407448e-02
 	 1.34692645916542952378e-01 0.00000000000000000000e+00 1.36815117610912407448e-02
 	 0.00000000000000000000e+00 8.65307354083457047622e-01 1.36815117610912407448e-02
 	 ];
 
 	 case   7 

 	 % ALG. DEG.:    7
 	 % PTS CARD.:   16
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.5e-15  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 8.81563078002625954976e-02
 	 1.00000000000000000000e+00 0.00000000000000000000e+00 2.01816922128051669250e-03
 	 0.00000000000000000000e+00 1.00000000000000000000e+00 2.01816922128051669250e-03
 	 0.00000000000000000000e+00 0.00000000000000000000e+00 2.01816922128051669250e-03
 	 6.90127879552479117642e-01 1.54936060223760496690e-01 5.83260292949515646299e-02
 	 1.54936060223760413423e-01 6.90127879552479117642e-01 5.83260292949515646299e-02
 	 1.54936060223760468935e-01 1.54936060223760385668e-01 5.83260292949515646299e-02
 	 6.16985077123759287354e-02 4.69150746143812025224e-01 5.32519959070870060880e-02
 	 4.69150746143812025224e-01 6.16985077123759495521e-02 5.32519959070870060880e-02
 	 4.69150746143812025224e-01 4.69150746143812025224e-01 5.32519959070870060880e-02
 	 0.00000000000000000000e+00 1.60700827727076389628e-01 1.18425181549633579126e-02
 	 8.39299172272923610372e-01 0.00000000000000000000e+00 1.18425181549633579126e-02
 	 1.60700827727076389628e-01 8.39299172272923610372e-01 1.18425181549633579126e-02
 	 8.39299172272923610372e-01 1.60700827727076389628e-01 1.18425181549633579126e-02
 	 1.60700827727076389628e-01 0.00000000000000000000e+00 1.18425181549633579126e-02
 	 0.00000000000000000000e+00 8.39299172272923610372e-01 1.18425181549633579126e-02
 	 ];
 
 	 case   8 

 	 % ALG. DEG.:    8
 	 % PTS CARD.:   21
 	 % NEG. W.  :    3
 	 % OUT PTS. :    0
 	 % M.E.INF. : 6.6e-15  

 	 xyw=[
 	 1.00000000000000000000e+00 0.00000000000000000000e+00 2.01212322548795837646e-03
 	 0.00000000000000000000e+00 1.00000000000000000000e+00 2.01212322548795837646e-03
 	 0.00000000000000000000e+00 0.00000000000000000000e+00 2.01212322548795837646e-03
 	 0.00000000000000000000e+00 5.00000000000000000000e-01 -1.41526331319190928903e-01
 	 5.00000000000000000000e-01 0.00000000000000000000e+00 -1.41526331319190928903e-01
 	 5.00000000000000000000e-01 5.00000000000000000000e-01 -1.41526331319190928903e-01
 	 8.63721164888366782497e-03 4.95681394175558120985e-01 1.73727911481889013556e-01
 	 4.95681394175558176496e-01 8.63721164888364700829e-03 1.73727911481889013556e-01
 	 4.95681394175558176496e-01 4.95681394175558120985e-01 1.73727911481889013556e-01
 	 8.19344484971469277923e-01 9.03277575142653610385e-02 3.24538298568710012471e-02
 	 9.03277575142653332829e-02 8.19344484971469277923e-01 3.24538298568710012471e-02
 	 9.03277575142653887941e-02 9.03277575142653610385e-02 3.24538298568710012471e-02
 	 5.31690500585389469457e-01 2.34154749707305320783e-01 7.51975461200220379743e-02
 	 2.34154749707305209760e-01 5.31690500585389469457e-01 7.51975461200220379743e-02
 	 2.34154749707305320783e-01 2.34154749707305209760e-01 7.51975461200220379743e-02
 	 0.00000000000000000000e+00 2.76393202250020952881e-01 1.24007936507936501053e-02
 	 7.23606797749979047119e-01 0.00000000000000000000e+00 1.24007936507936501053e-02
 	 2.76393202250020952881e-01 7.23606797749979047119e-01 1.24007936507936501053e-02
 	 7.23606797749979047119e-01 2.76393202250020952881e-01 1.24007936507936501053e-02
 	 2.76393202250020952881e-01 0.00000000000000000000e+00 1.24007936507936501053e-02
 	 0.00000000000000000000e+00 7.23606797749979047119e-01 1.24007936507936501053e-02
 	 ];
 
 	 case   9 

 	 % ALG. DEG.:    9
 	 % PTS CARD.:   22
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.9e-15  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 5.66812422299595997099e-02
 	 1.00000000000000000000e+00 0.00000000000000000000e+00 1.77095631641063317114e-04
 	 0.00000000000000000000e+00 1.00000000000000000000e+00 1.77095631641063317114e-04
 	 0.00000000000000000000e+00 0.00000000000000000000e+00 1.77095631641063317114e-04
 	 0.00000000000000000000e+00 5.00000000000000000000e-01 8.00568585643213204150e-03
 	 5.00000000000000000000e-01 0.00000000000000000000e+00 8.00568585643213204150e-03
 	 5.00000000000000000000e-01 5.00000000000000000000e-01 8.00568585643213204150e-03
 	 1.00441323625967693367e-01 4.49779338187016097805e-01 4.20707167722883315641e-02
 	 4.49779338187016208828e-01 1.00441323625967693367e-01 4.20707167722883315641e-02
 	 4.49779338187016097805e-01 4.49779338187016208828e-01 4.20707167722883315641e-02
 	 9.06105113601819334157e-01 4.69474431990903884326e-02 1.30320906191450664596e-02
 	 4.69474431990903329215e-02 9.06105113601819334157e-01 1.30320906191450664596e-02
 	 4.69474431990903329215e-02 4.69474431990903884326e-02 1.30320906191450664596e-02
 	 6.16256174525102062844e-01 1.91871912737449079600e-01 4.12037909998841309078e-02
 	 1.91871912737448913067e-01 6.16256174525102062844e-01 4.12037909998841309078e-02
 	 1.91871912737449024089e-01 1.91871912737448857555e-01 4.12037909998841309078e-02
 	 3.68384120547362581277e-02 2.21962989160765733487e-01 2.16417696886447019633e-02
 	 7.41198598784498008385e-01 3.68384120547362581277e-02 2.16417696886447019633e-02
 	 2.21962989160765733487e-01 7.41198598784498008385e-01 2.16417696886447019633e-02
 	 7.41198598784498008385e-01 2.21962989160765733487e-01 2.16417696886447019633e-02
 	 2.21962989160765733487e-01 3.68384120547362581277e-02 2.16417696886447019633e-02
 	 3.68384120547362581277e-02 7.41198598784498008385e-01 2.16417696886447019633e-02
 	 ];
 

 	 otherwise
 	 xyw=[];
 	 end
 


 
