
 	 function xyw=set_lyness_jespersen_IV(deg) 
 

 	 % --------------------------------------------------------------------
 	 % CUBATURE RULE ON THE SIMPLEX [0 0; 0 1; 1 0] WITH ADE EQUAL TO deg.
 	 % --------------------------------------------------------------------
 	 % INPUT: 
 	 % deg: algebraic degree of precision (ADE) of the rule.
 	 % --------------------------------------------------------------------
 	 % OUTPUT: 
 	 % xyw: MATRIX OF NODES xyw(:,1:2) AND WEIGHTS xyw(:,3).
 	 % --------------------------------------------------------------------
 
     %----------------------------------------
 	 % | DEG | CARD | W- | PT.O|   M.E.   |Q.| 
 	 %----------------------------------------
 	 % |   4 |   6 |   0 |   0 | 1.94e-16 |PI|
 	 % |   6 |  16 |   4 |   0 | 7.22e-16 |NI|
 	 % |   8 |  16 |   1 |   0 | 3.07e-15 |NI|
 	 %---------------------------------------
 
 
 	 %--------------------------------------------------------------------
  	 % LEGEND:
 	 %--------------------------------------------------------------------
 	 % DEG  : algebraic degree of precision
 	 % CARD : cardinality of the pointset
 	 % W-   : negative weights
 	 % PT.O : points outside the simplex [0 0; 1 0; 0 1].
 	 % M.E. : maximum moment error in inf norm.
 	 % Q.: quality of the rule.
 	 %        PI: pos. weights, points in simplex
 	 %        NI: some neg. weights, points in simplex
 	 %        P0: pos. weights, some points out of the simplex
 	 %        N0: some neg. weights, some points out of the simplex
 	 %--------------------------------------------------------------------
     
 	 switch deg
 
 	 case   4 

 	 % ALG. DEG.:    4
 	 % PTS CARD.:    6
 	 % NEG. W.  :    0
 	 % OUT PTS. :    0
 	 % M.E.INF. : 1.9e-16  

 	 xyw=[
 	 8.16847572980458513925e-01 9.15762135097707430376e-02 5.49758718276609145703e-02
 	 9.15762135097707291598e-02 8.16847572980458513925e-01 5.49758718276609145703e-02
 	 9.15762135097707569154e-02 9.15762135097707430376e-02 5.49758718276609145703e-02
 	 1.08103018168070205696e-01 4.45948490915964890213e-01 1.11690794839005749783e-01
 	 4.45948490915964890213e-01 1.08103018168070219573e-01 1.11690794839005749783e-01
 	 4.45948490915964890213e-01 4.45948490915964890213e-01 1.11690794839005749783e-01
 	 ];
 
 	 case   6 

 	 % ALG. DEG.:    6
 	 % PTS CARD.:   16
 	 % NEG. W.  :    4
 	 % OUT PTS. :    0
 	 % M.E.INF. : 7.2e-16  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 -2.89285714285714312677e-01
 	 1.00000000000000000000e+00 0.00000000000000000000e+00 -9.92063492063492008421e-03
 	 0.00000000000000000000e+00 1.00000000000000000000e+00 -9.92063492063492008421e-03
 	 0.00000000000000000000e+00 0.00000000000000000000e+00 -9.92063492063492008421e-03
 	 0.00000000000000000000e+00 5.00000000000000000000e-01 2.69841269841269854046e-02
 	 5.00000000000000000000e-01 0.00000000000000000000e+00 2.69841269841269854046e-02
 	 5.00000000000000000000e-01 5.00000000000000000000e-01 2.69841269841269854046e-02
 	 5.00000000000000000000e-01 2.50000000000000000000e-01 2.03174603174603202183e-01
 	 2.50000000000000000000e-01 5.00000000000000000000e-01 2.03174603174603202183e-01
 	 2.50000000000000000000e-01 2.50000000000000000000e-01 2.03174603174603202183e-01
 	 0.00000000000000000000e+00 9.17517095361369827700e-02 2.14285714285714253002e-02
 	 9.08248290463863017230e-01 0.00000000000000000000e+00 2.14285714285714253002e-02
 	 9.17517095361370244033e-02 9.08248290463863017230e-01 2.14285714285714253002e-02
 	 9.08248290463863017230e-01 9.17517095361369827700e-02 2.14285714285714253002e-02
 	 9.17517095361370244033e-02 0.00000000000000000000e+00 2.14285714285714253002e-02
 	 0.00000000000000000000e+00 9.08248290463863017230e-01 2.14285714285714253002e-02
 	 ];
 
 	 case   8 

 	 % ALG. DEG.:    8
 	 % PTS CARD.:   16
 	 % NEG. W.  :    1
 	 % OUT PTS. :    0
 	 % M.E.INF. : 3.1e-15  

 	 xyw=[
 	 3.33333333333333314830e-01 3.33333333333333370341e-01 -1.41709192555697888194e-01
 	 4.66691212356950685392e-02 4.76665439382152444914e-01 3.49534809663262016621e-02
 	 4.76665439382152500425e-01 4.66691212356951101725e-02 3.49534809663262016621e-02
 	 4.76665439382152389403e-01 4.76665439382152555936e-01 3.49534809663262016621e-02
 	 9.32456311891039280049e-01 3.37718440544804154868e-02 8.54545633580044115829e-03
 	 3.37718440544803322201e-02 9.32456311891039280049e-01 8.54545633580044115829e-03
 	 3.37718440544803877312e-02 3.37718440544803044645e-02 8.54545633580044115829e-03
 	 4.59304221669192103139e-01 2.70347889165403865164e-01 1.09414941165225099162e-01
 	 2.70347889165403976186e-01 4.59304221669192047628e-01 1.09414941165225099162e-01
 	 2.70347889165403976186e-01 2.70347889165403865164e-01 1.09414941165225099162e-01
 	 5.14643354866614888277e-02 2.02706173746087126020e-01 3.04945928589404578746e-02
 	 7.45829490767251357397e-01 5.14643354866615165832e-02 3.04945928589404578746e-02
 	 2.02706173746087126020e-01 7.45829490767251357397e-01 3.04945928589404578746e-02
 	 7.45829490767251357397e-01 2.02706173746087126020e-01 3.04945928589404578746e-02
 	 2.02706173746087126020e-01 5.14643354866615165832e-02 3.04945928589404578746e-02
 	 5.14643354866614888277e-02 7.45829490767251357397e-01 3.04945928589404578746e-02
 	 ];
 

 	 otherwise
 	 xyw=[];
 	 end
 


 
